/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	ValaList* type_argument_list;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static void vala_member_access_finalize (ValaCodeNode * obj);
static GType vala_member_access_get_type_once (void);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}

void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, NULL);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the list of generic type arguments.
 *
 * @return type argument list
 */
ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _type_arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_type_arg_list = _tmp5_;
		_tmp6_ = _type_arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_type_arg_size = _tmp8_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp9_;
			gpointer _tmp10_;
			ValaDataType* _tmp11_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp9_ = _type_arg_list;
			_tmp10_ = vala_list_get (_tmp9_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp10_;
			_tmp11_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	gchar* result = NULL;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	method = VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL;
	_tmp2_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp3_ = _tmp2_;
	if (VALA_IS_CONSTANT (_tmp3_)) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp7_)) {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_member_access_get_inner (self);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			ValaExpression* _tmp10_;
			ValaExpression* _tmp11_;
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			_tmp10_ = vala_member_access_get_inner (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_expression_get_symbol_reference (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp4_ = VALA_IS_CONSTANT (_tmp13_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp14_ = FALSE;
			ValaMethod* _tmp15_;
			_tmp15_ = method;
			if (_tmp15_ != NULL) {
				gboolean _tmp16_ = FALSE;
				ValaMethod* _tmp17_;
				ValaMemberBinding _tmp18_;
				ValaMemberBinding _tmp19_;
				_tmp17_ = method;
				_tmp18_ = vala_method_get_binding (_tmp17_);
				_tmp19_ = _tmp18_;
				if (_tmp19_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp16_ = TRUE;
				} else {
					gboolean _tmp20_;
					_tmp20_ = self->priv->_prototype_access;
					_tmp16_ = _tmp20_;
				}
				_tmp14_ = _tmp16_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				result = TRUE;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	c = VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL;
	_tmp2_ = c;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		ValaConstant* _tmp4_;
		_tmp4_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp4_)) {
			_tmp3_ = TRUE;
		} else {
			ValaConstant* _tmp5_;
			ValaDataType* _tmp6_;
			ValaDataType* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp5_ = c;
			_tmp6_ = vala_constant_get_type_reference (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = vala_data_type_get_nullable (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp3_ = !_tmp9_;
		}
		result = _tmp3_;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	gboolean _tmp16_;
	gboolean _tmp566_ = FALSE;
	gboolean _tmp567_ = FALSE;
	gboolean _tmp568_ = FALSE;
	ValaExpression* _tmp569_;
	ValaExpression* _tmp570_;
	ValaSymbol* _tmp596_;
	ValaSymbol* _tmp597_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp649_;
	ValaSymbol* _tmp650_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp651_;
	ValaSymbol* _tmp652_;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp1039_;
	ValaSymbol* _tmp1040_;
	ValaSymbol* _tmp1042_;
	ValaVersionAttribute* _tmp1043_;
	ValaVersionAttribute* _tmp1044_;
	ValaSourceReference* _tmp1045_;
	ValaSourceReference* _tmp1046_;
	gboolean _tmp1047_ = FALSE;
	ValaSymbolAccessibility _tmp1048_;
	gboolean _tmp1104_ = FALSE;
	gboolean _tmp1131_ = FALSE;
	gboolean _tmp1132_ = FALSE;
	ValaDataType* _tmp1384_;
	ValaDataType* _tmp1385_;
	gboolean _tmp1388_;
	gboolean _tmp1389_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_member_access_get_inner (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_member_access_get_inner (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _type_arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _type_arg_index = 0;
		_tmp8_ = self->priv->type_argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_type_arg_list = _tmp9_;
		_tmp10_ = _type_arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_type_arg_size = _tmp12_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp13_;
			gpointer _tmp14_;
			ValaDataType* _tmp15_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp13_ = _type_arg_list;
			_tmp14_ = vala_list_get (_tmp13_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp14_;
			_tmp15_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp15_, context);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp16_ = self->priv->_qualified;
	if (_tmp16_) {
		ValaNamespace* _tmp17_;
		ValaNamespace* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaScope* _tmp20_;
		ValaScope* _tmp21_;
		const gchar* _tmp22_;
		ValaSymbol* _tmp23_;
		ValaSymbol* _tmp24_;
		_tmp17_ = vala_code_context_get_root (context);
		_tmp18_ = _tmp17_;
		base_symbol = (ValaSymbol*) _tmp18_;
		_tmp19_ = base_symbol;
		_tmp20_ = vala_symbol_get_scope (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = self->priv->_member_name;
		_tmp23_ = vala_scope_lookup (_tmp21_, _tmp22_);
		_tmp24_ = _tmp23_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp24_);
		_vala_code_node_unref0 (_tmp24_);
	} else {
		ValaExpression* _tmp25_;
		ValaExpression* _tmp26_;
		_tmp25_ = vala_member_access_get_inner (self);
		_tmp26_ = _tmp25_;
		if (_tmp26_ == NULL) {
			const gchar* _tmp27_;
			ValaSemanticAnalyzer* _tmp32_;
			ValaSemanticAnalyzer* _tmp33_;
			ValaSymbol* _tmp34_;
			ValaSymbol* _tmp35_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp36_;
			ValaSemanticAnalyzer* _tmp37_;
			ValaSymbol* _tmp38_;
			ValaSymbol* _tmp39_;
			gboolean _tmp138_ = FALSE;
			ValaSymbol* _tmp139_;
			ValaSymbol* _tmp140_;
			_tmp27_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp27_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp28_;
				ValaSemanticAnalyzer* _tmp29_;
				_tmp28_ = vala_code_context_get_analyzer (context);
				_tmp29_ = _tmp28_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp29_)) {
					ValaSourceReference* _tmp30_;
					ValaSourceReference* _tmp31_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp31_ = _tmp30_;
					vala_report_error (_tmp31_, "This access invalid outside of instance methods");
					result = FALSE;
					return result;
				}
			}
			_tmp32_ = vala_code_context_get_analyzer (context);
			_tmp33_ = _tmp32_;
			_tmp34_ = vala_semantic_analyzer_get_current_symbol (_tmp33_);
			_tmp35_ = _tmp34_;
			base_symbol = _tmp35_;
			method_found = FALSE;
			_tmp36_ = vala_code_context_get_analyzer (context);
			_tmp37_ = _tmp36_;
			_tmp38_ = vala_semantic_analyzer_get_current_symbol (_tmp37_);
			_tmp39_ = _tmp38_;
			sym = _tmp39_;
			while (TRUE) {
				gboolean _tmp40_ = FALSE;
				ValaSymbol* _tmp41_;
				ValaSymbol* _tmp87_;
				const gchar* _tmp88_;
				ValaSymbol* _tmp89_;
				ValaSymbol* _tmp90_;
				gboolean _tmp91_ = FALSE;
				gboolean _tmp92_ = FALSE;
				ValaSymbol* _tmp93_;
				ValaSymbol* _tmp94_;
				ValaSymbol* _tmp132_;
				ValaSymbol* _tmp133_;
				ValaSymbol* _tmp135_;
				ValaSymbol* _tmp136_;
				ValaSymbol* _tmp137_;
				_tmp41_ = sym;
				if (_tmp41_ != NULL) {
					ValaSymbol* _tmp42_;
					ValaSymbol* _tmp43_;
					_tmp42_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp43_ = _tmp42_;
					_tmp40_ = _tmp43_ == NULL;
				} else {
					_tmp40_ = FALSE;
				}
				if (!_tmp40_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp44_;
					_tmp44_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp44_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp45_;
						ValaCreationMethod* _tmp46_;
						ValaParameter* _tmp47_;
						ValaParameter* _tmp48_;
						_tmp45_ = sym;
						cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
						_tmp46_ = cm;
						_tmp47_ = vala_method_get_this_parameter ((ValaMethod*) _tmp46_);
						_tmp48_ = _tmp47_;
						this_parameter = _tmp48_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
					} else {
						ValaSymbol* _tmp49_;
						_tmp49_ = sym;
						if (VALA_IS_PROPERTY (_tmp49_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp50_;
							ValaProperty* _tmp51_;
							ValaParameter* _tmp52_;
							ValaParameter* _tmp53_;
							ValaProperty* _tmp54_;
							ValaMemberBinding _tmp55_;
							ValaMemberBinding _tmp56_;
							ValaProperty* _tmp57_;
							ValaMemberBinding _tmp58_;
							ValaMemberBinding _tmp59_;
							_tmp50_ = sym;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp51_ = prop;
							_tmp52_ = vala_property_get_this_parameter (_tmp51_);
							_tmp53_ = _tmp52_;
							this_parameter = _tmp53_;
							_tmp54_ = prop;
							_tmp55_ = vala_property_get_binding (_tmp54_);
							_tmp56_ = _tmp55_;
							may_access_instance_members = _tmp56_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp57_ = prop;
							_tmp58_ = vala_property_get_binding (_tmp57_);
							_tmp59_ = _tmp58_;
							may_access_klass_members = _tmp59_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
						} else {
							ValaSymbol* _tmp60_;
							_tmp60_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp60_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp61_;
								ValaConstructor* _tmp62_;
								ValaParameter* _tmp63_;
								ValaParameter* _tmp64_;
								ValaConstructor* _tmp65_;
								ValaMemberBinding _tmp66_;
								ValaMemberBinding _tmp67_;
								_tmp61_ = sym;
								c = G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, VALA_TYPE_CONSTRUCTOR, ValaConstructor);
								_tmp62_ = c;
								_tmp63_ = vala_constructor_get_this_parameter (_tmp62_);
								_tmp64_ = _tmp63_;
								this_parameter = _tmp64_;
								_tmp65_ = c;
								_tmp66_ = vala_constructor_get_binding (_tmp65_);
								_tmp67_ = _tmp66_;
								may_access_instance_members = _tmp67_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
							} else {
								ValaSymbol* _tmp68_;
								_tmp68_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp68_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp69_;
									ValaDestructor* _tmp70_;
									ValaParameter* _tmp71_;
									ValaParameter* _tmp72_;
									ValaDestructor* _tmp73_;
									ValaMemberBinding _tmp74_;
									ValaMemberBinding _tmp75_;
									_tmp69_ = sym;
									d = G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, VALA_TYPE_DESTRUCTOR, ValaDestructor);
									_tmp70_ = d;
									_tmp71_ = vala_destructor_get_this_parameter (_tmp70_);
									_tmp72_ = _tmp71_;
									this_parameter = _tmp72_;
									_tmp73_ = d;
									_tmp74_ = vala_destructor_get_binding (_tmp73_);
									_tmp75_ = _tmp74_;
									may_access_instance_members = _tmp75_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
								} else {
									ValaSymbol* _tmp76_;
									_tmp76_ = sym;
									if (VALA_IS_METHOD (_tmp76_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp77_;
										ValaMethod* _tmp78_;
										ValaParameter* _tmp79_;
										ValaParameter* _tmp80_;
										ValaMethod* _tmp81_;
										ValaMemberBinding _tmp82_;
										ValaMemberBinding _tmp83_;
										ValaMethod* _tmp84_;
										ValaMemberBinding _tmp85_;
										ValaMemberBinding _tmp86_;
										_tmp77_ = sym;
										m = G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, VALA_TYPE_METHOD, ValaMethod);
										_tmp78_ = m;
										_tmp79_ = vala_method_get_this_parameter (_tmp78_);
										_tmp80_ = _tmp79_;
										this_parameter = _tmp80_;
										_tmp81_ = m;
										_tmp82_ = vala_method_get_binding (_tmp81_);
										_tmp83_ = _tmp82_;
										may_access_instance_members = _tmp83_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp84_ = m;
										_tmp85_ = vala_method_get_binding (_tmp84_);
										_tmp86_ = _tmp85_;
										may_access_klass_members = _tmp86_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
									}
								}
							}
						}
					}
				}
				_tmp87_ = sym;
				_tmp88_ = self->priv->_member_name;
				_tmp89_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp87_, _tmp88_);
				_tmp90_ = _tmp89_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp90_);
				_vala_code_node_unref0 (_tmp90_);
				_tmp93_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp94_ = _tmp93_;
				if (_tmp94_ == NULL) {
					ValaSymbol* _tmp95_;
					_tmp95_ = sym;
					_tmp92_ = VALA_IS_TYPESYMBOL (_tmp95_);
				} else {
					_tmp92_ = FALSE;
				}
				if (_tmp92_) {
					_tmp91_ = may_access_instance_members;
				} else {
					_tmp91_ = FALSE;
				}
				if (_tmp91_) {
					ValaParameter* _tmp96_;
					ValaDataType* _tmp97_;
					ValaDataType* _tmp98_;
					const gchar* _tmp99_;
					ValaSymbol* _tmp100_;
					ValaSymbol* _tmp101_;
					gboolean _tmp102_ = FALSE;
					ValaSymbol* _tmp103_;
					ValaSymbol* _tmp104_;
					_tmp96_ = this_parameter;
					_tmp97_ = vala_variable_get_variable_type ((ValaVariable*) _tmp96_);
					_tmp98_ = _tmp97_;
					_tmp99_ = self->priv->_member_name;
					_tmp100_ = vala_data_type_get_member (_tmp98_, _tmp99_);
					_tmp101_ = _tmp100_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp101_);
					_vala_code_node_unref0 (_tmp101_);
					_tmp103_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp104_ = _tmp103_;
					if (_tmp104_ != NULL) {
						ValaSymbol* _tmp105_;
						ValaSymbol* _tmp106_;
						_tmp105_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp106_ = _tmp105_;
						_tmp102_ = vala_member_access_is_instance_symbol (_tmp106_);
					} else {
						_tmp102_ = FALSE;
					}
					if (_tmp102_) {
						ValaSourceReference* _tmp107_;
						ValaSourceReference* _tmp108_;
						ValaMemberAccess* _tmp109_;
						ValaMemberAccess* _tmp110_;
						ValaExpression* _tmp111_;
						ValaExpression* _tmp112_;
						ValaParameter* _tmp113_;
						ValaDataType* _tmp114_;
						ValaDataType* _tmp115_;
						ValaDataType* _tmp116_;
						ValaDataType* _tmp117_;
						ValaExpression* _tmp118_;
						ValaExpression* _tmp119_;
						ValaDataType* _tmp120_;
						ValaDataType* _tmp121_;
						ValaExpression* _tmp122_;
						ValaExpression* _tmp123_;
						ValaParameter* _tmp124_;
						ValaExpression* _tmp125_;
						ValaExpression* _tmp126_;
						ValaDataType* _tmp127_;
						ValaDataType* _tmp128_;
						const gchar* _tmp129_;
						ValaSymbol* _tmp130_;
						ValaSymbol* _tmp131_;
						_tmp107_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp108_ = _tmp107_;
						_tmp109_ = vala_member_access_new (NULL, "this", _tmp108_);
						_tmp110_ = _tmp109_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp110_);
						_vala_code_node_unref0 (_tmp110_);
						_tmp111_ = vala_member_access_get_inner (self);
						_tmp112_ = _tmp111_;
						_tmp113_ = this_parameter;
						_tmp114_ = vala_variable_get_variable_type ((ValaVariable*) _tmp113_);
						_tmp115_ = _tmp114_;
						_tmp116_ = vala_data_type_copy (_tmp115_);
						_tmp117_ = _tmp116_;
						vala_expression_set_value_type (_tmp112_, _tmp117_);
						_vala_code_node_unref0 (_tmp117_);
						_tmp118_ = vala_member_access_get_inner (self);
						_tmp119_ = _tmp118_;
						_tmp120_ = vala_expression_get_value_type (_tmp119_);
						_tmp121_ = _tmp120_;
						vala_data_type_set_value_owned (_tmp121_, FALSE);
						_tmp122_ = vala_member_access_get_inner (self);
						_tmp123_ = _tmp122_;
						_tmp124_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp123_, (ValaSymbol*) _tmp124_);
						_tmp125_ = vala_member_access_get_inner (self);
						_tmp126_ = _tmp125_;
						_tmp127_ = vala_expression_get_value_type (_tmp126_);
						_tmp128_ = _tmp127_;
						_tmp129_ = self->priv->_member_name;
						_tmp130_ = vala_data_type_get_member (_tmp128_, _tmp129_);
						_tmp131_ = _tmp130_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp131_);
						_vala_code_node_unref0 (_tmp131_);
					}
				}
				_tmp132_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp133_ = _tmp132_;
				if (_tmp133_ == NULL) {
					ValaSymbol* _tmp134_;
					_tmp134_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp134_)) {
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp135_ = sym;
				_tmp136_ = vala_symbol_get_parent_symbol (_tmp135_);
				_tmp137_ = _tmp136_;
				sym = _tmp137_;
			}
			_tmp139_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp140_ = _tmp139_;
			if (_tmp140_ == NULL) {
				ValaSourceReference* _tmp141_;
				ValaSourceReference* _tmp142_;
				_tmp141_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp142_ = _tmp141_;
				_tmp138_ = _tmp142_ != NULL;
			} else {
				_tmp138_ = FALSE;
			}
			if (_tmp138_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp143_;
					ValaSourceReference* _tmp144_;
					ValaList* _tmp145_;
					ValaList* _tmp146_;
					ValaList* _tmp147_;
					gint _ns_size = 0;
					ValaList* _tmp148_;
					gint _tmp149_;
					gint _tmp150_;
					gint _ns_index = 0;
					_tmp143_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp144_ = _tmp143_;
					_tmp145_ = vala_source_reference_get_using_directives (_tmp144_);
					_tmp146_ = _tmp145_;
					_tmp147_ = _vala_iterable_ref0 (_tmp146_);
					_ns_list = _tmp147_;
					_tmp148_ = _ns_list;
					_tmp149_ = vala_collection_get_size ((ValaCollection*) _tmp148_);
					_tmp150_ = _tmp149_;
					_ns_size = _tmp150_;
					_ns_index = -1;
					while (TRUE) {
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp151_;
						gpointer _tmp152_;
						ValaUsingDirective* _tmp153_;
						gboolean _tmp154_;
						gboolean _tmp155_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp156_;
						ValaSymbol* _tmp157_;
						ValaSymbol* _tmp158_;
						ValaScope* _tmp159_;
						ValaScope* _tmp160_;
						const gchar* _tmp161_;
						ValaSymbol* _tmp162_;
						ValaSymbol* _tmp163_;
						_ns_index = _ns_index + 1;
						if (!(_ns_index < _ns_size)) {
							break;
						}
						_tmp151_ = _ns_list;
						_tmp152_ = vala_list_get (_tmp151_, _ns_index);
						ns = (ValaUsingDirective*) _tmp152_;
						_tmp153_ = ns;
						_tmp154_ = vala_code_node_get_error ((ValaCodeNode*) _tmp153_);
						_tmp155_ = _tmp154_;
						if (_tmp155_) {
							_vala_code_node_unref0 (ns);
							continue;
						}
						_tmp156_ = ns;
						_tmp157_ = vala_using_directive_get_namespace_symbol (_tmp156_);
						_tmp158_ = _tmp157_;
						_tmp159_ = vala_symbol_get_scope (_tmp158_);
						_tmp160_ = _tmp159_;
						_tmp161_ = self->priv->_member_name;
						_tmp162_ = vala_scope_lookup (_tmp160_, _tmp161_);
						local_sym = _tmp162_;
						_tmp163_ = local_sym;
						if (_tmp163_ != NULL) {
							gboolean _tmp164_ = FALSE;
							ValaSymbol* _tmp165_;
							ValaSymbol* _tmp166_;
							ValaSymbol* _tmp182_;
							_tmp165_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp166_ = _tmp165_;
							if (_tmp166_ != NULL) {
								ValaSymbol* _tmp167_;
								ValaSymbol* _tmp168_;
								ValaSymbol* _tmp169_;
								_tmp167_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp168_ = _tmp167_;
								_tmp169_ = local_sym;
								_tmp164_ = _tmp168_ != _tmp169_;
							} else {
								_tmp164_ = FALSE;
							}
							if (_tmp164_) {
								ValaSourceReference* _tmp170_;
								ValaSourceReference* _tmp171_;
								const gchar* _tmp172_;
								ValaSymbol* _tmp173_;
								ValaSymbol* _tmp174_;
								gchar* _tmp175_;
								gchar* _tmp176_;
								ValaSymbol* _tmp177_;
								gchar* _tmp178_;
								gchar* _tmp179_;
								gchar* _tmp180_;
								gchar* _tmp181_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp170_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp171_ = _tmp170_;
								_tmp172_ = self->priv->_member_name;
								_tmp173_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp174_ = _tmp173_;
								_tmp175_ = vala_symbol_get_full_name (_tmp174_);
								_tmp176_ = _tmp175_;
								_tmp177_ = local_sym;
								_tmp178_ = vala_symbol_get_full_name (_tmp177_);
								_tmp179_ = _tmp178_;
								_tmp180_ = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", _tmp172_, _tmp176_, _tmp179_);
								_tmp181_ = _tmp180_;
								vala_report_error (_tmp171_, _tmp181_);
								_g_free0 (_tmp181_);
								_g_free0 (_tmp179_);
								_g_free0 (_tmp176_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (_ns_list);
								return result;
							}
							_tmp182_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp182_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
					_vala_iterable_unref0 (_ns_list);
				}
			}
		} else {
			ValaExpression* _tmp183_;
			ValaExpression* _tmp184_;
			gboolean _tmp185_;
			gboolean _tmp186_;
			ValaExpression* _tmp187_;
			ValaExpression* _tmp188_;
			ValaDataType* _tmp189_;
			ValaDataType* _tmp190_;
			ValaExpression* _tmp208_;
			ValaExpression* _tmp209_;
			gboolean _tmp224_ = FALSE;
			ValaExpression* _tmp225_;
			ValaExpression* _tmp226_;
			gboolean _tmp233_ = FALSE;
			ValaExpression* _tmp234_;
			ValaExpression* _tmp235_;
			gboolean _tmp256_ = FALSE;
			ValaExpression* _tmp257_;
			ValaExpression* _tmp258_;
			gboolean _tmp277_ = FALSE;
			ValaSymbol* _tmp278_;
			ValaSymbol* _tmp279_;
			gboolean _tmp313_ = FALSE;
			gboolean _tmp314_ = FALSE;
			ValaSymbol* _tmp315_;
			ValaSymbol* _tmp316_;
			gboolean _tmp548_ = FALSE;
			ValaSymbol* _tmp549_;
			ValaSymbol* _tmp550_;
			_tmp183_ = vala_member_access_get_inner (self);
			_tmp184_ = _tmp183_;
			_tmp185_ = vala_code_node_get_error ((ValaCodeNode*) _tmp184_);
			_tmp186_ = _tmp185_;
			if (_tmp186_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				return result;
			}
			_tmp187_ = vala_member_access_get_inner (self);
			_tmp188_ = _tmp187_;
			_tmp189_ = vala_expression_get_value_type (_tmp188_);
			_tmp190_ = _tmp189_;
			if (VALA_IS_POINTER_TYPE (_tmp190_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp191_;
				ValaExpression* _tmp192_;
				ValaDataType* _tmp193_;
				ValaDataType* _tmp194_;
				gboolean _tmp195_ = FALSE;
				ValaPointerType* _tmp196_;
				_tmp191_ = vala_member_access_get_inner (self);
				_tmp192_ = _tmp191_;
				_tmp193_ = vala_expression_get_value_type (_tmp192_);
				_tmp194_ = _tmp193_;
				pointer_type = VALA_IS_POINTER_TYPE (_tmp194_) ? ((ValaPointerType*) _tmp194_) : NULL;
				_tmp196_ = pointer_type;
				if (_tmp196_ != NULL) {
					ValaPointerType* _tmp197_;
					ValaDataType* _tmp198_;
					ValaDataType* _tmp199_;
					_tmp197_ = pointer_type;
					_tmp198_ = vala_pointer_type_get_base_type (_tmp197_);
					_tmp199_ = _tmp198_;
					_tmp195_ = VALA_IS_VALUE_TYPE (_tmp199_);
				} else {
					_tmp195_ = FALSE;
				}
				if (_tmp195_) {
					ValaExpression* _tmp200_;
					ValaExpression* _tmp201_;
					ValaSourceReference* _tmp202_;
					ValaSourceReference* _tmp203_;
					ValaPointerIndirection* _tmp204_;
					ValaPointerIndirection* _tmp205_;
					ValaExpression* _tmp206_;
					ValaExpression* _tmp207_;
					_tmp200_ = vala_member_access_get_inner (self);
					_tmp201_ = _tmp200_;
					_tmp202_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp203_ = _tmp202_;
					_tmp204_ = vala_pointer_indirection_new (_tmp201_, _tmp203_);
					_tmp205_ = _tmp204_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp205_);
					_vala_code_node_unref0 (_tmp205_);
					_tmp206_ = vala_member_access_get_inner (self);
					_tmp207_ = _tmp206_;
					vala_code_node_check ((ValaCodeNode*) _tmp207_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
			}
			_tmp208_ = vala_member_access_get_inner (self);
			_tmp209_ = _tmp208_;
			if (VALA_IS_MEMBER_ACCESS (_tmp209_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp210_;
				ValaExpression* _tmp211_;
				ValaMemberAccess* _tmp212_;
				gboolean _tmp213_;
				_tmp210_ = vala_member_access_get_inner (self);
				_tmp211_ = _tmp210_;
				ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp211_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
				_tmp212_ = ma;
				_tmp213_ = _tmp212_->priv->_prototype_access;
				if (_tmp213_) {
					ValaSourceReference* _tmp214_;
					ValaSourceReference* _tmp215_;
					ValaExpression* _tmp216_;
					ValaExpression* _tmp217_;
					ValaSymbol* _tmp218_;
					ValaSymbol* _tmp219_;
					gchar* _tmp220_;
					gchar* _tmp221_;
					gchar* _tmp222_;
					gchar* _tmp223_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp214_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp215_ = _tmp214_;
					_tmp216_ = vala_member_access_get_inner (self);
					_tmp217_ = _tmp216_;
					_tmp218_ = vala_expression_get_symbol_reference (_tmp217_);
					_tmp219_ = _tmp218_;
					_tmp220_ = vala_symbol_get_full_name (_tmp219_);
					_tmp221_ = _tmp220_;
					_tmp222_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp221_);
					_tmp223_ = _tmp222_;
					vala_report_error (_tmp215_, _tmp223_);
					_g_free0 (_tmp223_);
					_g_free0 (_tmp221_);
					result = FALSE;
					return result;
				}
			}
			_tmp225_ = vala_member_access_get_inner (self);
			_tmp226_ = _tmp225_;
			if (VALA_IS_CAST_EXPRESSION (_tmp226_)) {
				ValaExpression* _tmp227_;
				ValaExpression* _tmp228_;
				gboolean _tmp229_;
				gboolean _tmp230_;
				_tmp227_ = vala_member_access_get_inner (self);
				_tmp228_ = _tmp227_;
				_tmp229_ = vala_cast_expression_get_is_silent_cast (G_TYPE_CHECK_INSTANCE_CAST (_tmp228_, VALA_TYPE_CAST_EXPRESSION, ValaCastExpression));
				_tmp230_ = _tmp229_;
				_tmp224_ = _tmp230_;
			} else {
				_tmp224_ = FALSE;
			}
			if (_tmp224_) {
				ValaSourceReference* _tmp231_;
				ValaSourceReference* _tmp232_;
				_tmp231_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp232_ = _tmp231_;
				vala_report_warning (_tmp232_, "Access to possible `null'. Perform a check or use an unsafe cast.");
			}
			_tmp234_ = vala_member_access_get_inner (self);
			_tmp235_ = _tmp234_;
			if (VALA_IS_MEMBER_ACCESS (_tmp235_)) {
				_tmp233_ = TRUE;
			} else {
				ValaExpression* _tmp236_;
				ValaExpression* _tmp237_;
				_tmp236_ = vala_member_access_get_inner (self);
				_tmp237_ = _tmp236_;
				_tmp233_ = VALA_IS_BASE_ACCESS (_tmp237_);
			}
			if (_tmp233_) {
				ValaExpression* _tmp238_;
				ValaExpression* _tmp239_;
				ValaSymbol* _tmp240_;
				ValaSymbol* _tmp241_;
				gboolean _tmp242_ = FALSE;
				ValaSymbol* _tmp243_;
				ValaSymbol* _tmp244_;
				_tmp238_ = vala_member_access_get_inner (self);
				_tmp239_ = _tmp238_;
				_tmp240_ = vala_expression_get_symbol_reference (_tmp239_);
				_tmp241_ = _tmp240_;
				base_symbol = _tmp241_;
				_tmp243_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp244_ = _tmp243_;
				if (_tmp244_ == NULL) {
					gboolean _tmp245_ = FALSE;
					ValaSymbol* _tmp246_;
					_tmp246_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp246_)) {
						_tmp245_ = TRUE;
					} else {
						ValaSymbol* _tmp247_;
						_tmp247_ = base_symbol;
						_tmp245_ = VALA_IS_TYPESYMBOL (_tmp247_);
					}
					_tmp242_ = _tmp245_;
				} else {
					_tmp242_ = FALSE;
				}
				if (_tmp242_) {
					ValaSymbol* _tmp248_;
					ValaScope* _tmp249_;
					ValaScope* _tmp250_;
					const gchar* _tmp251_;
					ValaSymbol* _tmp252_;
					ValaSymbol* _tmp253_;
					ValaExpression* _tmp254_;
					ValaExpression* _tmp255_;
					_tmp248_ = base_symbol;
					_tmp249_ = vala_symbol_get_scope (_tmp248_);
					_tmp250_ = _tmp249_;
					_tmp251_ = self->priv->_member_name;
					_tmp252_ = vala_scope_lookup (_tmp250_, _tmp251_);
					_tmp253_ = _tmp252_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp253_);
					_vala_code_node_unref0 (_tmp253_);
					_tmp254_ = vala_member_access_get_inner (self);
					_tmp255_ = _tmp254_;
					if (VALA_IS_BASE_ACCESS (_tmp255_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp257_ = vala_member_access_get_inner (self);
			_tmp258_ = _tmp257_;
			if (VALA_IS_MEMBER_ACCESS (_tmp258_)) {
				ValaExpression* _tmp259_;
				ValaExpression* _tmp260_;
				ValaSymbol* _tmp261_;
				ValaSymbol* _tmp262_;
				_tmp259_ = vala_member_access_get_inner (self);
				_tmp260_ = _tmp259_;
				_tmp261_ = vala_expression_get_symbol_reference (_tmp260_);
				_tmp262_ = _tmp261_;
				_tmp256_ = VALA_IS_TYPEPARAMETER (_tmp262_);
			} else {
				_tmp256_ = FALSE;
			}
			if (_tmp256_) {
				ValaExpression* _tmp263_;
				ValaExpression* _tmp264_;
				ValaExpression* _tmp265_;
				ValaExpression* _tmp266_;
				ValaSymbol* _tmp267_;
				ValaSymbol* _tmp268_;
				ValaGenericType* _tmp269_;
				ValaGenericType* _tmp270_;
				ValaExpression* _tmp271_;
				ValaExpression* _tmp272_;
				ValaDataType* _tmp273_;
				ValaDataType* _tmp274_;
				ValaSourceReference* _tmp275_;
				ValaSourceReference* _tmp276_;
				_tmp263_ = vala_member_access_get_inner (self);
				_tmp264_ = _tmp263_;
				_tmp265_ = vala_member_access_get_inner (self);
				_tmp266_ = _tmp265_;
				_tmp267_ = vala_expression_get_symbol_reference (_tmp266_);
				_tmp268_ = _tmp267_;
				_tmp269_ = vala_generic_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp268_, VALA_TYPE_TYPEPARAMETER, ValaTypeParameter));
				_tmp270_ = _tmp269_;
				vala_expression_set_value_type (_tmp264_, (ValaDataType*) _tmp270_);
				_vala_code_node_unref0 (_tmp270_);
				_tmp271_ = vala_member_access_get_inner (self);
				_tmp272_ = _tmp271_;
				_tmp273_ = vala_expression_get_value_type (_tmp272_);
				_tmp274_ = _tmp273_;
				_tmp275_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp276_ = _tmp275_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp274_, _tmp276_);
			}
			_tmp278_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp279_ = _tmp278_;
			if (_tmp279_ == NULL) {
				ValaExpression* _tmp280_;
				ValaExpression* _tmp281_;
				ValaDataType* _tmp282_;
				ValaDataType* _tmp283_;
				_tmp280_ = vala_member_access_get_inner (self);
				_tmp281_ = _tmp280_;
				_tmp282_ = vala_expression_get_value_type (_tmp281_);
				_tmp283_ = _tmp282_;
				_tmp277_ = _tmp283_ != NULL;
			} else {
				_tmp277_ = FALSE;
			}
			if (_tmp277_) {
				gboolean _tmp284_;
				ValaSymbol* _tmp311_;
				ValaSymbol* _tmp312_;
				_tmp284_ = self->priv->_pointer_member_access;
				if (_tmp284_) {
					ValaExpression* _tmp285_;
					ValaExpression* _tmp286_;
					ValaDataType* _tmp287_;
					ValaDataType* _tmp288_;
					const gchar* _tmp289_;
					ValaSymbol* _tmp290_;
					ValaSymbol* _tmp291_;
					_tmp285_ = vala_member_access_get_inner (self);
					_tmp286_ = _tmp285_;
					_tmp287_ = vala_expression_get_value_type (_tmp286_);
					_tmp288_ = _tmp287_;
					_tmp289_ = self->priv->_member_name;
					_tmp290_ = vala_data_type_get_pointer_member (_tmp288_, _tmp289_);
					_tmp291_ = _tmp290_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp291_);
					_vala_code_node_unref0 (_tmp291_);
				} else {
					ValaExpression* _tmp292_;
					ValaExpression* _tmp293_;
					ValaDataType* _tmp294_;
					ValaDataType* _tmp295_;
					ValaTypeSymbol* _tmp296_;
					ValaTypeSymbol* _tmp297_;
					ValaExpression* _tmp304_;
					ValaExpression* _tmp305_;
					ValaDataType* _tmp306_;
					ValaDataType* _tmp307_;
					const gchar* _tmp308_;
					ValaSymbol* _tmp309_;
					ValaSymbol* _tmp310_;
					_tmp292_ = vala_member_access_get_inner (self);
					_tmp293_ = _tmp292_;
					_tmp294_ = vala_expression_get_value_type (_tmp293_);
					_tmp295_ = _tmp294_;
					_tmp296_ = vala_data_type_get_type_symbol (_tmp295_);
					_tmp297_ = _tmp296_;
					if (_tmp297_ != NULL) {
						ValaExpression* _tmp298_;
						ValaExpression* _tmp299_;
						ValaDataType* _tmp300_;
						ValaDataType* _tmp301_;
						ValaTypeSymbol* _tmp302_;
						ValaTypeSymbol* _tmp303_;
						_tmp298_ = vala_member_access_get_inner (self);
						_tmp299_ = _tmp298_;
						_tmp300_ = vala_expression_get_value_type (_tmp299_);
						_tmp301_ = _tmp300_;
						_tmp302_ = vala_data_type_get_type_symbol (_tmp301_);
						_tmp303_ = _tmp302_;
						base_symbol = (ValaSymbol*) _tmp303_;
					}
					_tmp304_ = vala_member_access_get_inner (self);
					_tmp305_ = _tmp304_;
					_tmp306_ = vala_expression_get_value_type (_tmp305_);
					_tmp307_ = _tmp306_;
					_tmp308_ = self->priv->_member_name;
					_tmp309_ = vala_data_type_get_member (_tmp307_, _tmp308_);
					_tmp310_ = _tmp309_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp310_);
					_vala_code_node_unref0 (_tmp310_);
				}
				_tmp311_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp312_ = _tmp311_;
				if (_tmp312_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp315_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp316_ = _tmp315_;
			if (_tmp316_ == NULL) {
				ValaExpression* _tmp317_;
				ValaExpression* _tmp318_;
				ValaDataType* _tmp319_;
				ValaDataType* _tmp320_;
				_tmp317_ = vala_member_access_get_inner (self);
				_tmp318_ = _tmp317_;
				_tmp319_ = vala_expression_get_value_type (_tmp318_);
				_tmp320_ = _tmp319_;
				_tmp314_ = _tmp320_ != NULL;
			} else {
				_tmp314_ = FALSE;
			}
			if (_tmp314_) {
				ValaExpression* _tmp321_;
				ValaExpression* _tmp322_;
				ValaDataType* _tmp323_;
				ValaDataType* _tmp324_;
				gboolean _tmp325_;
				gboolean _tmp326_;
				_tmp321_ = vala_member_access_get_inner (self);
				_tmp322_ = _tmp321_;
				_tmp323_ = vala_expression_get_value_type (_tmp322_);
				_tmp324_ = _tmp323_;
				_tmp325_ = vala_data_type_get_is_dynamic (_tmp324_);
				_tmp326_ = _tmp325_;
				_tmp313_ = _tmp326_;
			} else {
				_tmp313_ = FALSE;
			}
			if (_tmp313_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp327_;
				ValaExpression* _tmp328_;
				ValaDataType* _tmp329_;
				ValaDataType* _tmp330_;
				ValaObjectType* _tmp331_;
				ValaCodeNode* _tmp332_;
				ValaCodeNode* _tmp333_;
				ValaSymbol* _tmp496_;
				ValaSymbol* _tmp497_;
				ValaSymbol* _tmp546_;
				ValaSymbol* _tmp547_;
				_tmp327_ = vala_member_access_get_inner (self);
				_tmp328_ = _tmp327_;
				_tmp329_ = vala_expression_get_value_type (_tmp328_);
				_tmp330_ = _tmp329_;
				_tmp331_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp330_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp331_;
				_tmp332_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp333_ = _tmp332_;
				if (VALA_IS_METHOD_CALL (_tmp333_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp334_;
					ValaCodeNode* _tmp335_;
					ValaMethodCall* _tmp336_;
					ValaExpression* _tmp337_;
					ValaExpression* _tmp338_;
					_tmp334_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp335_ = _tmp334_;
					invoc = G_TYPE_CHECK_INSTANCE_CAST (_tmp335_, VALA_TYPE_METHOD_CALL, ValaMethodCall);
					_tmp336_ = invoc;
					_tmp337_ = vala_method_call_get_call (_tmp336_);
					_tmp338_ = _tmp337_;
					if (_tmp338_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp339_;
						ValaDataType* _tmp340_;
						ValaDataType* _tmp341_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp356_;
						ValaExpression* _tmp357_;
						ValaDataType* _tmp358_;
						ValaDataType* _tmp359_;
						const gchar* _tmp360_;
						ValaDataType* _tmp361_;
						ValaSourceReference* _tmp362_;
						ValaSourceReference* _tmp363_;
						ValaDynamicMethod* _tmp364_;
						ValaDynamicMethod* _tmp365_;
						ValaMethodCall* _tmp366_;
						ValaErrorType* err = NULL;
						ValaErrorType* _tmp367_;
						ValaErrorType* _tmp368_;
						ValaDynamicMethod* _tmp369_;
						ValaErrorType* _tmp370_;
						ValaDynamicMethod* _tmp371_;
						ValaDynamicMethod* _tmp372_;
						ValaParameter* _tmp373_;
						ValaParameter* _tmp374_;
						ValaDynamicMethod* _tmp375_;
						ValaObjectType* _tmp376_;
						ValaDataType* _tmp377_;
						ValaDataType* _tmp378_;
						ValaParameter* _tmp379_;
						ValaParameter* _tmp380_;
						ValaObjectType* _tmp381_;
						ValaTypeSymbol* _tmp382_;
						ValaTypeSymbol* _tmp383_;
						ValaScope* _tmp384_;
						ValaScope* _tmp385_;
						ValaDynamicMethod* _tmp386_;
						ValaDynamicMethod* _tmp387_;
						_tmp339_ = invoc;
						_tmp340_ = vala_expression_get_target_type ((ValaExpression*) _tmp339_);
						_tmp341_ = _tmp340_;
						if (_tmp341_ != NULL) {
							ValaMethodCall* _tmp342_;
							ValaDataType* _tmp343_;
							ValaDataType* _tmp344_;
							ValaDataType* _tmp345_;
							ValaDataType* _tmp346_;
							_tmp342_ = invoc;
							_tmp343_ = vala_expression_get_target_type ((ValaExpression*) _tmp342_);
							_tmp344_ = _tmp343_;
							_tmp345_ = vala_data_type_copy (_tmp344_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp345_;
							_tmp346_ = ret_type;
							vala_data_type_set_value_owned (_tmp346_, TRUE);
						} else {
							ValaMethodCall* _tmp347_;
							ValaCodeNode* _tmp348_;
							ValaCodeNode* _tmp349_;
							_tmp347_ = invoc;
							_tmp348_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp347_);
							_tmp349_ = _tmp348_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp349_)) {
								ValaVoidType* _tmp350_;
								_tmp350_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp350_;
							} else {
								ValaExpression* _tmp351_;
								ValaExpression* _tmp352_;
								ValaDataType* _tmp353_;
								ValaDataType* _tmp354_;
								ValaDataType* _tmp355_;
								_tmp351_ = vala_member_access_get_inner (self);
								_tmp352_ = _tmp351_;
								_tmp353_ = vala_expression_get_value_type (_tmp352_);
								_tmp354_ = _tmp353_;
								_tmp355_ = vala_data_type_copy (_tmp354_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp355_;
							}
						}
						_tmp356_ = vala_member_access_get_inner (self);
						_tmp357_ = _tmp356_;
						_tmp358_ = vala_expression_get_value_type (_tmp357_);
						_tmp359_ = _tmp358_;
						_tmp360_ = self->priv->_member_name;
						_tmp361_ = ret_type;
						_tmp362_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp363_ = _tmp362_;
						_tmp364_ = vala_dynamic_method_new (_tmp359_, _tmp360_, _tmp361_, _tmp363_, NULL);
						m = _tmp364_;
						_tmp365_ = m;
						_tmp366_ = invoc;
						vala_dynamic_method_set_invocation (_tmp365_, _tmp366_);
						_tmp367_ = vala_error_type_new (NULL, NULL, NULL);
						err = _tmp367_;
						_tmp368_ = err;
						vala_error_type_set_dynamic_error (_tmp368_, TRUE);
						_tmp369_ = m;
						_tmp370_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp369_, (ValaDataType*) _tmp370_);
						_tmp371_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp371_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp372_ = m;
						_tmp373_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp374_ = _tmp373_;
						vala_callable_add_parameter ((ValaCallable*) _tmp372_, _tmp374_);
						_vala_code_node_unref0 (_tmp374_);
						_tmp375_ = m;
						_tmp376_ = dynamic_object_type;
						_tmp377_ = vala_data_type_copy ((ValaDataType*) _tmp376_);
						_tmp378_ = _tmp377_;
						_tmp379_ = vala_parameter_new ("this", _tmp378_, NULL);
						_tmp380_ = _tmp379_;
						vala_method_set_this_parameter ((ValaMethod*) _tmp375_, _tmp380_);
						_vala_code_node_unref0 (_tmp380_);
						_vala_code_node_unref0 (_tmp378_);
						_tmp381_ = dynamic_object_type;
						_tmp382_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp381_);
						_tmp383_ = _tmp382_;
						_tmp384_ = vala_symbol_get_scope ((ValaSymbol*) _tmp383_);
						_tmp385_ = _tmp384_;
						_tmp386_ = m;
						vala_scope_add (_tmp385_, NULL, (ValaSymbol*) _tmp386_);
						_tmp387_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp387_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
				} else {
					ValaCodeNode* _tmp388_;
					ValaCodeNode* _tmp389_;
					_tmp388_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp389_ = _tmp388_;
					if (VALA_IS_ASSIGNMENT (_tmp389_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp390_;
						ValaCodeNode* _tmp391_;
						ValaAssignment* _tmp392_;
						ValaExpression* _tmp393_;
						ValaExpression* _tmp394_;
						_tmp390_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp391_ = _tmp390_;
						a = G_TYPE_CHECK_INSTANCE_CAST (_tmp391_, VALA_TYPE_ASSIGNMENT, ValaAssignment);
						_tmp392_ = a;
						_tmp393_ = vala_assignment_get_left (_tmp392_);
						_tmp394_ = _tmp393_;
						if (_tmp394_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							ValaDynamicProperty* prop = NULL;
							ValaExpression* _tmp395_;
							ValaExpression* _tmp396_;
							ValaDataType* _tmp397_;
							ValaDataType* _tmp398_;
							const gchar* _tmp399_;
							ValaSourceReference* _tmp400_;
							ValaSourceReference* _tmp401_;
							ValaDynamicProperty* _tmp402_;
							ValaDynamicProperty* _tmp403_;
							ValaDynamicProperty* _tmp404_;
							ValaDynamicProperty* _tmp405_;
							ValaSourceReference* _tmp406_;
							ValaSourceReference* _tmp407_;
							ValaPropertyAccessor* _tmp408_;
							ValaPropertyAccessor* _tmp409_;
							ValaDynamicProperty* _tmp410_;
							ValaExpression* _tmp411_;
							ValaExpression* _tmp412_;
							ValaDataType* _tmp413_;
							ValaDataType* _tmp414_;
							ValaTypeSymbol* _tmp415_;
							ValaTypeSymbol* _tmp416_;
							ValaScope* _tmp417_;
							ValaScope* _tmp418_;
							ValaObjectType* _tmp419_;
							ValaTypeSymbol* _tmp420_;
							ValaTypeSymbol* _tmp421_;
							ValaScope* _tmp422_;
							ValaScope* _tmp423_;
							ValaDynamicProperty* _tmp424_;
							ValaDynamicProperty* _tmp425_;
							_tmp395_ = vala_member_access_get_inner (self);
							_tmp396_ = _tmp395_;
							_tmp397_ = vala_expression_get_value_type (_tmp396_);
							_tmp398_ = _tmp397_;
							_tmp399_ = self->priv->_member_name;
							_tmp400_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp401_ = _tmp400_;
							_tmp402_ = vala_dynamic_property_new (_tmp398_, _tmp399_, _tmp401_, NULL);
							prop = _tmp402_;
							_tmp403_ = prop;
							vala_symbol_set_access ((ValaSymbol*) _tmp403_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp404_ = prop;
							_tmp405_ = prop;
							_tmp406_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp405_);
							_tmp407_ = _tmp406_;
							_tmp408_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp407_, NULL);
							_tmp409_ = _tmp408_;
							vala_property_set_set_accessor ((ValaProperty*) _tmp404_, _tmp409_);
							_vala_code_node_unref0 (_tmp409_);
							_tmp410_ = prop;
							_tmp411_ = vala_member_access_get_inner (self);
							_tmp412_ = _tmp411_;
							_tmp413_ = vala_expression_get_value_type (_tmp412_);
							_tmp414_ = _tmp413_;
							_tmp415_ = vala_data_type_get_type_symbol (_tmp414_);
							_tmp416_ = _tmp415_;
							_tmp417_ = vala_symbol_get_scope ((ValaSymbol*) _tmp416_);
							_tmp418_ = _tmp417_;
							vala_symbol_set_owner ((ValaSymbol*) _tmp410_, _tmp418_);
							_tmp419_ = dynamic_object_type;
							_tmp420_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp419_);
							_tmp421_ = _tmp420_;
							_tmp422_ = vala_symbol_get_scope ((ValaSymbol*) _tmp421_);
							_tmp423_ = _tmp422_;
							_tmp424_ = prop;
							vala_scope_add (_tmp423_, NULL, (ValaSymbol*) _tmp424_);
							_tmp425_ = prop;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp425_);
							_vala_code_node_unref0 (prop);
						}
					} else {
						gboolean _tmp426_ = FALSE;
						gboolean _tmp427_ = FALSE;
						ValaCodeNode* _tmp428_;
						ValaCodeNode* _tmp429_;
						_tmp428_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp429_ = _tmp428_;
						if (VALA_IS_MEMBER_ACCESS (_tmp429_)) {
							ValaExpression* _tmp430_;
							ValaExpression* _tmp431_;
							_tmp430_ = vala_member_access_get_inner (self);
							_tmp431_ = _tmp430_;
							_tmp427_ = VALA_IS_MEMBER_ACCESS (_tmp431_);
						} else {
							_tmp427_ = FALSE;
						}
						if (_tmp427_) {
							ValaCodeNode* _tmp432_;
							ValaCodeNode* _tmp433_;
							ValaCodeNode* _tmp434_;
							ValaCodeNode* _tmp435_;
							_tmp432_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp433_ = _tmp432_;
							_tmp434_ = vala_code_node_get_parent_node (_tmp433_);
							_tmp435_ = _tmp434_;
							_tmp426_ = VALA_IS_METHOD_CALL (_tmp435_);
						} else {
							_tmp426_ = FALSE;
						}
						if (_tmp426_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp436_;
							ValaCodeNode* _tmp437_;
							gboolean _tmp438_ = FALSE;
							ValaMemberAccess* _tmp439_;
							const gchar* _tmp440_;
							_tmp436_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp437_ = _tmp436_;
							ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp437_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
							_tmp439_ = ma;
							_tmp440_ = _tmp439_->priv->_member_name;
							if (g_strcmp0 (_tmp440_, "connect") == 0) {
								_tmp438_ = TRUE;
							} else {
								ValaMemberAccess* _tmp441_;
								const gchar* _tmp442_;
								_tmp441_ = ma;
								_tmp442_ = _tmp441_->priv->_member_name;
								_tmp438_ = g_strcmp0 (_tmp442_, "connect_after") == 0;
							}
							if (_tmp438_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp443_;
								ValaExpression* _tmp444_;
								ValaDataType* _tmp445_;
								ValaDataType* _tmp446_;
								const gchar* _tmp447_;
								ValaVoidType* _tmp448_;
								ValaVoidType* _tmp449_;
								ValaSourceReference* _tmp450_;
								ValaSourceReference* _tmp451_;
								ValaDynamicSignal* _tmp452_;
								ValaDynamicSignal* _tmp453_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp454_;
								ValaCodeNode* _tmp455_;
								ValaCodeNode* _tmp456_;
								ValaCodeNode* _tmp457_;
								ValaMethodCall* _tmp458_;
								ValaMethodCall* _tmp459_;
								ValaList* _tmp460_;
								gint _tmp461_;
								gint _tmp462_;
								ValaDynamicSignal* _tmp488_;
								ValaObjectType* _tmp489_;
								ValaTypeSymbol* _tmp490_;
								ValaTypeSymbol* _tmp491_;
								ValaScope* _tmp492_;
								ValaScope* _tmp493_;
								ValaDynamicSignal* _tmp494_;
								ValaDynamicSignal* _tmp495_;
								_tmp443_ = vala_member_access_get_inner (self);
								_tmp444_ = _tmp443_;
								_tmp445_ = vala_expression_get_value_type (_tmp444_);
								_tmp446_ = _tmp445_;
								_tmp447_ = self->priv->_member_name;
								_tmp448_ = vala_void_type_new (NULL);
								_tmp449_ = _tmp448_;
								_tmp450_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp451_ = _tmp450_;
								_tmp452_ = vala_dynamic_signal_new (_tmp446_, _tmp447_, (ValaDataType*) _tmp449_, _tmp451_, NULL);
								_tmp453_ = _tmp452_;
								_vala_code_node_unref0 (_tmp449_);
								s = _tmp453_;
								_tmp454_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp455_ = _tmp454_;
								_tmp456_ = vala_code_node_get_parent_node (_tmp455_);
								_tmp457_ = _tmp456_;
								_tmp458_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp457_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp458_;
								_tmp459_ = mcall;
								_tmp460_ = vala_method_call_get_argument_list (_tmp459_);
								_tmp461_ = vala_collection_get_size ((ValaCollection*) _tmp460_);
								_tmp462_ = _tmp461_;
								if (_tmp462_ > 0) {
									ValaDynamicSignal* _tmp463_;
									ValaMethodCall* _tmp464_;
									ValaList* _tmp465_;
									gpointer _tmp466_;
									ValaExpression* _tmp467_;
									ValaMemberAccess* arg = NULL;
									ValaDynamicSignal* _tmp468_;
									ValaExpression* _tmp469_;
									ValaExpression* _tmp470_;
									gboolean _tmp471_ = FALSE;
									gboolean _tmp472_ = FALSE;
									ValaMemberAccess* _tmp473_;
									_tmp463_ = s;
									_tmp464_ = mcall;
									_tmp465_ = vala_method_call_get_argument_list (_tmp464_);
									_tmp466_ = vala_list_get (_tmp465_, 0);
									_tmp467_ = (ValaExpression*) _tmp466_;
									vala_dynamic_signal_set_handler (_tmp463_, _tmp467_);
									_vala_code_node_unref0 (_tmp467_);
									_tmp468_ = s;
									_tmp469_ = vala_dynamic_signal_get_handler (_tmp468_);
									_tmp470_ = _tmp469_;
									arg = VALA_IS_MEMBER_ACCESS (_tmp470_) ? ((ValaMemberAccess*) _tmp470_) : NULL;
									_tmp473_ = arg;
									if (_tmp473_ == NULL) {
										_tmp472_ = TRUE;
									} else {
										ValaMemberAccess* _tmp474_;
										_tmp474_ = arg;
										_tmp472_ = !vala_code_node_check ((ValaCodeNode*) _tmp474_, context);
									}
									if (_tmp472_) {
										_tmp471_ = TRUE;
									} else {
										ValaMemberAccess* _tmp475_;
										ValaSymbol* _tmp476_;
										ValaSymbol* _tmp477_;
										_tmp475_ = arg;
										_tmp476_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp475_);
										_tmp477_ = _tmp476_;
										_tmp471_ = !VALA_IS_METHOD (_tmp477_);
									}
									if (_tmp471_) {
										ValaDynamicSignal* _tmp478_;
										ValaExpression* _tmp479_;
										ValaExpression* _tmp480_;
										ValaSourceReference* _tmp481_;
										ValaSourceReference* _tmp482_;
										ValaDynamicSignal* _tmp483_;
										gchar* _tmp484_;
										gchar* _tmp485_;
										gchar* _tmp486_;
										gchar* _tmp487_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp478_ = s;
										_tmp479_ = vala_dynamic_signal_get_handler (_tmp478_);
										_tmp480_ = _tmp479_;
										_tmp481_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp480_);
										_tmp482_ = _tmp481_;
										_tmp483_ = s;
										_tmp484_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp483_);
										_tmp485_ = _tmp484_;
										_tmp486_ = g_strdup_printf ("Invalid handler for `%s'", _tmp485_);
										_tmp487_ = _tmp486_;
										vala_report_error (_tmp482_, _tmp487_);
										_g_free0 (_tmp487_);
										_g_free0 (_tmp485_);
									}
								}
								_tmp488_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp488_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp489_ = dynamic_object_type;
								_tmp490_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp489_);
								_tmp491_ = _tmp490_;
								_tmp492_ = vala_symbol_get_scope ((ValaSymbol*) _tmp491_);
								_tmp493_ = _tmp492_;
								_tmp494_ = s;
								vala_scope_add (_tmp493_, NULL, (ValaSymbol*) _tmp494_);
								_tmp495_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp495_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							}
						}
					}
				}
				_tmp496_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp497_ = _tmp496_;
				if (_tmp497_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp498_;
					ValaExpression* _tmp499_;
					ValaDataType* _tmp500_;
					ValaDataType* _tmp501_;
					const gchar* _tmp502_;
					ValaSourceReference* _tmp503_;
					ValaSourceReference* _tmp504_;
					ValaDynamicProperty* _tmp505_;
					ValaDataType* _tmp506_;
					ValaDataType* _tmp507_;
					ValaDynamicProperty* _tmp518_;
					ValaDynamicProperty* _tmp519_;
					ValaDynamicProperty* _tmp520_;
					ValaDataType* _tmp521_;
					ValaDataType* _tmp522_;
					ValaDataType* _tmp523_;
					ValaDataType* _tmp524_;
					ValaDynamicProperty* _tmp525_;
					ValaSourceReference* _tmp526_;
					ValaSourceReference* _tmp527_;
					ValaPropertyAccessor* _tmp528_;
					ValaPropertyAccessor* _tmp529_;
					ValaDynamicProperty* _tmp530_;
					ValaExpression* _tmp531_;
					ValaExpression* _tmp532_;
					ValaDataType* _tmp533_;
					ValaDataType* _tmp534_;
					ValaTypeSymbol* _tmp535_;
					ValaTypeSymbol* _tmp536_;
					ValaScope* _tmp537_;
					ValaScope* _tmp538_;
					ValaObjectType* _tmp539_;
					ValaTypeSymbol* _tmp540_;
					ValaTypeSymbol* _tmp541_;
					ValaScope* _tmp542_;
					ValaScope* _tmp543_;
					ValaDynamicProperty* _tmp544_;
					ValaDynamicProperty* _tmp545_;
					_tmp498_ = vala_member_access_get_inner (self);
					_tmp499_ = _tmp498_;
					_tmp500_ = vala_expression_get_value_type (_tmp499_);
					_tmp501_ = _tmp500_;
					_tmp502_ = self->priv->_member_name;
					_tmp503_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp504_ = _tmp503_;
					_tmp505_ = vala_dynamic_property_new (_tmp501_, _tmp502_, _tmp504_, NULL);
					prop = _tmp505_;
					_tmp506_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp507_ = _tmp506_;
					if (_tmp507_ != NULL) {
						ValaDynamicProperty* _tmp508_;
						ValaDataType* _tmp509_;
						ValaDataType* _tmp510_;
						_tmp508_ = prop;
						_tmp509_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp510_ = _tmp509_;
						vala_property_set_property_type ((ValaProperty*) _tmp508_, _tmp510_);
					} else {
						ValaDynamicProperty* _tmp511_;
						ValaExpression* _tmp512_;
						ValaExpression* _tmp513_;
						ValaDataType* _tmp514_;
						ValaDataType* _tmp515_;
						ValaDataType* _tmp516_;
						ValaDataType* _tmp517_;
						_tmp511_ = prop;
						_tmp512_ = vala_member_access_get_inner (self);
						_tmp513_ = _tmp512_;
						_tmp514_ = vala_expression_get_value_type (_tmp513_);
						_tmp515_ = _tmp514_;
						_tmp516_ = vala_data_type_copy (_tmp515_);
						_tmp517_ = _tmp516_;
						vala_property_set_property_type ((ValaProperty*) _tmp511_, _tmp517_);
						_vala_code_node_unref0 (_tmp517_);
					}
					_tmp518_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp518_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp519_ = prop;
					_tmp520_ = prop;
					_tmp521_ = vala_property_get_property_type ((ValaProperty*) _tmp520_);
					_tmp522_ = _tmp521_;
					_tmp523_ = vala_data_type_copy (_tmp522_);
					_tmp524_ = _tmp523_;
					_tmp525_ = prop;
					_tmp526_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp525_);
					_tmp527_ = _tmp526_;
					_tmp528_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp524_, NULL, _tmp527_, NULL);
					_tmp529_ = _tmp528_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp519_, _tmp529_);
					_vala_code_node_unref0 (_tmp529_);
					_vala_code_node_unref0 (_tmp524_);
					_tmp530_ = prop;
					_tmp531_ = vala_member_access_get_inner (self);
					_tmp532_ = _tmp531_;
					_tmp533_ = vala_expression_get_value_type (_tmp532_);
					_tmp534_ = _tmp533_;
					_tmp535_ = vala_data_type_get_type_symbol (_tmp534_);
					_tmp536_ = _tmp535_;
					_tmp537_ = vala_symbol_get_scope ((ValaSymbol*) _tmp536_);
					_tmp538_ = _tmp537_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp530_, _tmp538_);
					_tmp539_ = dynamic_object_type;
					_tmp540_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp539_);
					_tmp541_ = _tmp540_;
					_tmp542_ = vala_symbol_get_scope ((ValaSymbol*) _tmp541_);
					_tmp543_ = _tmp542_;
					_tmp544_ = prop;
					vala_scope_add (_tmp543_, NULL, (ValaSymbol*) _tmp544_);
					_tmp545_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp545_);
					_vala_code_node_unref0 (prop);
				}
				_tmp546_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp547_ = _tmp546_;
				if (_tmp547_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp549_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp550_ = _tmp549_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp550_)) {
				ValaExpression* _tmp551_;
				ValaExpression* _tmp552_;
				ValaDataType* _tmp553_;
				ValaDataType* _tmp554_;
				_tmp551_ = vala_member_access_get_inner (self);
				_tmp552_ = _tmp551_;
				_tmp553_ = vala_expression_get_value_type (_tmp552_);
				_tmp554_ = _tmp553_;
				_tmp548_ = VALA_IS_ARRAY_TYPE (_tmp554_);
			} else {
				_tmp548_ = FALSE;
			}
			if (_tmp548_) {
				ValaArrayType* value_array_type = NULL;
				ValaExpression* _tmp555_;
				ValaExpression* _tmp556_;
				ValaDataType* _tmp557_;
				ValaDataType* _tmp558_;
				gboolean _tmp559_ = FALSE;
				ValaArrayType* _tmp560_;
				_tmp555_ = vala_member_access_get_inner (self);
				_tmp556_ = _tmp555_;
				_tmp557_ = vala_expression_get_value_type (_tmp556_);
				_tmp558_ = _tmp557_;
				value_array_type = VALA_IS_ARRAY_TYPE (_tmp558_) ? ((ValaArrayType*) _tmp558_) : NULL;
				_tmp560_ = value_array_type;
				if (_tmp560_ != NULL) {
					ValaArrayType* _tmp561_;
					gboolean _tmp562_;
					gboolean _tmp563_;
					_tmp561_ = value_array_type;
					_tmp562_ = vala_array_type_get_inline_allocated (_tmp561_);
					_tmp563_ = _tmp562_;
					_tmp559_ = _tmp563_;
				} else {
					_tmp559_ = FALSE;
				}
				if (_tmp559_) {
					ValaSourceReference* _tmp564_;
					ValaSourceReference* _tmp565_;
					_tmp564_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp565_ = _tmp564_;
					vala_report_error (_tmp565_, "`resize' is not supported for arrays with fixed length");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
			}
		}
	}
	_tmp569_ = vala_member_access_get_inner (self);
	_tmp570_ = _tmp569_;
	if (_tmp570_ == NULL) {
		ValaSymbol* _tmp571_;
		ValaSymbol* _tmp572_;
		_tmp571_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp572_ = _tmp571_;
		_tmp568_ = _tmp572_ == NULL;
	} else {
		_tmp568_ = FALSE;
	}
	if (_tmp568_) {
		ValaDataType* _tmp573_;
		ValaDataType* _tmp574_;
		_tmp573_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp574_ = _tmp573_;
		_tmp567_ = _tmp574_ != NULL;
	} else {
		_tmp567_ = FALSE;
	}
	if (_tmp567_) {
		ValaDataType* _tmp575_;
		ValaDataType* _tmp576_;
		ValaTypeSymbol* _tmp577_;
		ValaTypeSymbol* _tmp578_;
		_tmp575_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp576_ = _tmp575_;
		_tmp577_ = vala_data_type_get_type_symbol (_tmp576_);
		_tmp578_ = _tmp577_;
		_tmp566_ = VALA_IS_ENUM (_tmp578_);
	} else {
		_tmp566_ = FALSE;
	}
	if (_tmp566_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp579_;
		ValaDataType* _tmp580_;
		ValaTypeSymbol* _tmp581_;
		ValaTypeSymbol* _tmp582_;
		_tmp579_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp580_ = _tmp579_;
		_tmp581_ = vala_data_type_get_type_symbol (_tmp580_);
		_tmp582_ = _tmp581_;
		enum_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp582_, VALA_TYPE_ENUM, ValaEnum);
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp583_;
			ValaList* _tmp584_;
			ValaList* _tmp585_;
			gint _val_size = 0;
			ValaList* _tmp586_;
			gint _tmp587_;
			gint _tmp588_;
			gint _val_index = 0;
			_tmp583_ = enum_type;
			_tmp584_ = vala_enum_get_values (_tmp583_);
			_tmp585_ = _vala_iterable_ref0 (_tmp584_);
			_val_list = _tmp585_;
			_tmp586_ = _val_list;
			_tmp587_ = vala_collection_get_size ((ValaCollection*) _tmp586_);
			_tmp588_ = _tmp587_;
			_val_size = _tmp588_;
			_val_index = -1;
			while (TRUE) {
				ValaEnumValue* val = NULL;
				ValaList* _tmp589_;
				gpointer _tmp590_;
				const gchar* _tmp591_;
				ValaEnumValue* _tmp592_;
				const gchar* _tmp593_;
				const gchar* _tmp594_;
				_val_index = _val_index + 1;
				if (!(_val_index < _val_size)) {
					break;
				}
				_tmp589_ = _val_list;
				_tmp590_ = vala_list_get (_tmp589_, _val_index);
				val = (ValaEnumValue*) _tmp590_;
				_tmp591_ = self->priv->_member_name;
				_tmp592_ = val;
				_tmp593_ = vala_symbol_get_name ((ValaSymbol*) _tmp592_);
				_tmp594_ = _tmp593_;
				if (g_strcmp0 (_tmp591_, _tmp594_) == 0) {
					ValaEnumValue* _tmp595_;
					_tmp595_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp595_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
			_vala_iterable_unref0 (_val_list);
		}
	}
	_tmp596_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp597_ = _tmp596_;
	if (_tmp597_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp598_;
		ValaSymbol* base_type = NULL;
		gboolean _tmp599_ = FALSE;
		ValaExpression* _tmp600_;
		ValaExpression* _tmp601_;
		gchar* base_type_package = NULL;
		gchar* _tmp621_;
		gboolean _tmp622_ = FALSE;
		ValaSymbol* _tmp623_;
		ValaSourceReference* _tmp638_;
		ValaSourceReference* _tmp639_;
		const gchar* _tmp640_;
		const gchar* _tmp641_;
		const gchar* _tmp642_;
		gchar* _tmp643_;
		gchar* _tmp644_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp598_ = g_strdup ("(null)");
		base_type_name = _tmp598_;
		base_type = NULL;
		_tmp600_ = vala_member_access_get_inner (self);
		_tmp601_ = _tmp600_;
		if (_tmp601_ != NULL) {
			ValaExpression* _tmp602_;
			ValaExpression* _tmp603_;
			ValaDataType* _tmp604_;
			ValaDataType* _tmp605_;
			_tmp602_ = vala_member_access_get_inner (self);
			_tmp603_ = _tmp602_;
			_tmp604_ = vala_expression_get_value_type (_tmp603_);
			_tmp605_ = _tmp604_;
			_tmp599_ = _tmp605_ != NULL;
		} else {
			_tmp599_ = FALSE;
		}
		if (_tmp599_) {
			ValaExpression* _tmp606_;
			ValaExpression* _tmp607_;
			ValaDataType* _tmp608_;
			ValaDataType* _tmp609_;
			gchar* _tmp610_;
			ValaExpression* _tmp611_;
			ValaExpression* _tmp612_;
			ValaDataType* _tmp613_;
			ValaDataType* _tmp614_;
			ValaTypeSymbol* _tmp615_;
			ValaTypeSymbol* _tmp616_;
			_tmp606_ = vala_member_access_get_inner (self);
			_tmp607_ = _tmp606_;
			_tmp608_ = vala_expression_get_value_type (_tmp607_);
			_tmp609_ = _tmp608_;
			_tmp610_ = vala_code_node_to_string ((ValaCodeNode*) _tmp609_);
			_g_free0 (base_type_name);
			base_type_name = _tmp610_;
			_tmp611_ = vala_member_access_get_inner (self);
			_tmp612_ = _tmp611_;
			_tmp613_ = vala_expression_get_value_type (_tmp612_);
			_tmp614_ = _tmp613_;
			_tmp615_ = vala_data_type_get_type_symbol (_tmp614_);
			_tmp616_ = _tmp615_;
			base_type = (ValaSymbol*) _tmp616_;
		} else {
			ValaSymbol* _tmp617_;
			_tmp617_ = base_symbol;
			if (_tmp617_ != NULL) {
				ValaSymbol* _tmp618_;
				gchar* _tmp619_;
				ValaSymbol* _tmp620_;
				_tmp618_ = base_symbol;
				_tmp619_ = vala_symbol_get_full_name (_tmp618_);
				_g_free0 (base_type_name);
				base_type_name = _tmp619_;
				_tmp620_ = base_symbol;
				base_type = _tmp620_;
			}
		}
		_tmp621_ = g_strdup ("");
		base_type_package = _tmp621_;
		_tmp623_ = base_type;
		if (_tmp623_ != NULL) {
			ValaSymbol* _tmp624_;
			gboolean _tmp625_;
			gboolean _tmp626_;
			_tmp624_ = base_type;
			_tmp625_ = vala_symbol_get_external_package (_tmp624_);
			_tmp626_ = _tmp625_;
			_tmp622_ = _tmp626_;
		} else {
			_tmp622_ = FALSE;
		}
		if (_tmp622_) {
			ValaSymbol* _tmp627_;
			ValaSourceReference* _tmp628_;
			ValaSourceReference* _tmp629_;
			ValaSourceFile* _tmp630_;
			ValaSourceFile* _tmp631_;
			const gchar* _tmp632_;
			const gchar* _tmp633_;
			gchar* _tmp634_;
			const gchar* _tmp635_;
			_tmp627_ = base_symbol;
			_tmp628_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp627_);
			_tmp629_ = _tmp628_;
			_tmp630_ = vala_source_reference_get_file (_tmp629_);
			_tmp631_ = _tmp630_;
			_tmp632_ = vala_source_file_get_package_name (_tmp631_);
			_tmp633_ = _tmp632_;
			_tmp634_ = g_strdup (_tmp633_);
			_g_free0 (base_type_package);
			base_type_package = _tmp634_;
			_tmp635_ = base_type_package;
			if (_tmp635_ != NULL) {
				const gchar* _tmp636_;
				gchar* _tmp637_;
				_tmp636_ = base_type_package;
				_tmp637_ = g_strdup_printf (" (%s)", _tmp636_);
				_g_free0 (base_type_package);
				base_type_package = _tmp637_;
			}
		}
		_tmp638_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp639_ = _tmp638_;
		_tmp640_ = self->priv->_member_name;
		_tmp641_ = base_type_name;
		_tmp642_ = base_type_package;
		_tmp643_ = g_strdup_printf ("The name `%s' does not exist in the context of `%s'%s", _tmp640_, _tmp641_, _tmp642_);
		_tmp644_ = _tmp643_;
		vala_report_error (_tmp639_, _tmp644_);
		_g_free0 (_tmp644_);
		result = FALSE;
		_g_free0 (base_type_package);
		_g_free0 (base_type_name);
		return result;
	} else {
		ValaSymbol* _tmp645_;
		ValaSymbol* _tmp646_;
		gboolean _tmp647_;
		gboolean _tmp648_;
		_tmp645_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp646_ = _tmp645_;
		_tmp647_ = vala_code_node_get_error ((ValaCodeNode*) _tmp646_);
		_tmp648_ = _tmp647_;
		if (_tmp648_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
	}
	_tmp649_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp650_ = _tmp649_;
	member = _tmp650_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp651_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp651_, context)) {
		result = FALSE;
		return result;
	}
	_tmp652_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp652_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp653_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp654_;
		ValaSymbol* _tmp655_;
		ValaSymbol* _tmp656_;
		gboolean _tmp657_ = FALSE;
		ValaBlock* _tmp658_;
		_tmp653_ = member;
		local = G_TYPE_CHECK_INSTANCE_CAST (_tmp653_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
		_tmp654_ = local;
		_tmp655_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp654_);
		_tmp656_ = _tmp655_;
		block = VALA_IS_BLOCK (_tmp656_) ? ((ValaBlock*) _tmp656_) : NULL;
		_tmp658_ = block;
		if (_tmp658_ != NULL) {
			ValaBlock* _tmp659_;
			ValaSymbol* _tmp660_;
			ValaSemanticAnalyzer* _tmp661_;
			ValaSemanticAnalyzer* _tmp662_;
			ValaSymbol* _tmp663_;
			ValaSymbol* _tmp664_;
			_tmp659_ = block;
			_tmp660_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp659_);
			_tmp661_ = vala_code_context_get_analyzer (context);
			_tmp662_ = _tmp661_;
			_tmp663_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp662_);
			_tmp664_ = _tmp663_;
			_tmp657_ = _tmp660_ != _tmp664_;
		} else {
			_tmp657_ = FALSE;
		}
		if (_tmp657_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp665_;
			ValaSemanticAnalyzer* _tmp666_;
			ValaSymbol* _tmp667_;
			ValaSymbol* _tmp668_;
			ValaLocalVariable* _tmp679_;
			ValaBlock* _tmp680_;
			_tmp665_ = vala_code_context_get_analyzer (context);
			_tmp666_ = _tmp665_;
			_tmp667_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp666_);
			_tmp668_ = _tmp667_;
			sym = _tmp668_;
			while (TRUE) {
				ValaSymbol* _tmp669_;
				ValaBlock* _tmp670_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp671_;
				ValaMethod* _tmp672_;
				ValaSymbol* _tmp676_;
				ValaSymbol* _tmp677_;
				ValaSymbol* _tmp678_;
				_tmp669_ = sym;
				_tmp670_ = block;
				if (!(_tmp669_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp670_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp671_ = sym;
				method = VALA_IS_METHOD (_tmp671_) ? ((ValaMethod*) _tmp671_) : NULL;
				_tmp672_ = method;
				if (_tmp672_ != NULL) {
					ValaMethod* _tmp673_;
					ValaMethod* _tmp674_;
					ValaLocalVariable* _tmp675_;
					_tmp673_ = method;
					vala_method_set_closure (_tmp673_, TRUE);
					_tmp674_ = method;
					_tmp675_ = local;
					vala_method_add_captured_variable (_tmp674_, _tmp675_);
				}
				_tmp676_ = sym;
				_tmp677_ = vala_symbol_get_parent_symbol (_tmp676_);
				_tmp678_ = _tmp677_;
				sym = _tmp678_;
			}
			_tmp679_ = local;
			vala_local_variable_set_captured (_tmp679_, TRUE);
			_tmp680_ = block;
			vala_block_set_captured (_tmp680_, TRUE);
		}
	} else {
		ValaSymbol* _tmp681_;
		_tmp681_ = member;
		if (VALA_IS_PARAMETER (_tmp681_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp682_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp683_;
			ValaSymbol* _tmp684_;
			ValaSymbol* _tmp685_;
			gboolean _tmp686_ = FALSE;
			gboolean _tmp687_ = FALSE;
			ValaMethod* _tmp688_;
			_tmp682_ = member;
			param = G_TYPE_CHECK_INSTANCE_CAST (_tmp682_, VALA_TYPE_PARAMETER, ValaParameter);
			_tmp683_ = param;
			_tmp684_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp683_);
			_tmp685_ = _tmp684_;
			m = VALA_IS_METHOD (_tmp685_) ? ((ValaMethod*) _tmp685_) : NULL;
			_tmp688_ = m;
			if (_tmp688_ != NULL) {
				ValaMethod* _tmp689_;
				ValaSemanticAnalyzer* _tmp690_;
				ValaSemanticAnalyzer* _tmp691_;
				ValaSymbol* _tmp692_;
				ValaSymbol* _tmp693_;
				_tmp689_ = m;
				_tmp690_ = vala_code_context_get_analyzer (context);
				_tmp691_ = _tmp690_;
				_tmp692_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp691_);
				_tmp693_ = _tmp692_;
				_tmp687_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp689_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp693_;
			} else {
				_tmp687_ = FALSE;
			}
			if (_tmp687_) {
				ValaParameter* _tmp694_;
				ValaMethod* _tmp695_;
				ValaParameter* _tmp696_;
				ValaParameter* _tmp697_;
				_tmp694_ = param;
				_tmp695_ = m;
				_tmp696_ = vala_method_get_this_parameter (_tmp695_);
				_tmp697_ = _tmp696_;
				_tmp686_ = _tmp694_ != _tmp697_;
			} else {
				_tmp686_ = FALSE;
			}
			if (_tmp686_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp698_;
				ValaSemanticAnalyzer* _tmp699_;
				ValaSymbol* _tmp700_;
				ValaSymbol* _tmp701_;
				ValaParameter* _tmp710_;
				ValaMethod* _tmp711_;
				ValaBlock* _tmp712_;
				ValaBlock* _tmp713_;
				ValaParameter* _tmp714_;
				ValaParameterDirection _tmp715_;
				ValaParameterDirection _tmp716_;
				_tmp698_ = vala_code_context_get_analyzer (context);
				_tmp699_ = _tmp698_;
				_tmp700_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp699_);
				_tmp701_ = _tmp700_;
				sym = _tmp701_;
				while (TRUE) {
					ValaSymbol* _tmp702_;
					ValaMethod* _tmp703_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp704_;
					ValaMethod* _tmp705_;
					ValaSymbol* _tmp707_;
					ValaSymbol* _tmp708_;
					ValaSymbol* _tmp709_;
					_tmp702_ = sym;
					_tmp703_ = m;
					if (!(_tmp702_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp703_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp704_ = sym;
					method = VALA_IS_METHOD (_tmp704_) ? ((ValaMethod*) _tmp704_) : NULL;
					_tmp705_ = method;
					if (_tmp705_ != NULL) {
						ValaMethod* _tmp706_;
						_tmp706_ = method;
						vala_method_set_closure (_tmp706_, TRUE);
					}
					_tmp707_ = sym;
					_tmp708_ = vala_symbol_get_parent_symbol (_tmp707_);
					_tmp709_ = _tmp708_;
					sym = _tmp709_;
				}
				_tmp710_ = param;
				vala_parameter_set_captured (_tmp710_, TRUE);
				_tmp711_ = m;
				_tmp712_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp711_);
				_tmp713_ = _tmp712_;
				vala_block_set_captured (_tmp713_, TRUE);
				_tmp714_ = param;
				_tmp715_ = vala_parameter_get_direction (_tmp714_);
				_tmp716_ = _tmp715_;
				if (_tmp716_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp717_;
					ValaSourceReference* _tmp718_;
					ValaParameter* _tmp719_;
					gchar* _tmp720_;
					gchar* _tmp721_;
					gchar* _tmp722_;
					gchar* _tmp723_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp717_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp718_ = _tmp717_;
					_tmp719_ = param;
					_tmp720_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp719_);
					_tmp721_ = _tmp720_;
					_tmp722_ = g_strdup_printf ("Cannot capture reference or output parameter `%s'", _tmp721_);
					_tmp723_ = _tmp722_;
					vala_report_error (_tmp718_, _tmp723_);
					_g_free0 (_tmp723_);
					_g_free0 (_tmp721_);
				}
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp724_;
				ValaSymbol* _tmp725_;
				ValaSymbol* _tmp726_;
				ValaSymbol* _tmp727_;
				ValaSymbol* _tmp728_;
				gboolean _tmp729_ = FALSE;
				gboolean _tmp730_ = FALSE;
				ValaPropertyAccessor* _tmp731_;
				_tmp724_ = param;
				_tmp725_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp724_);
				_tmp726_ = _tmp725_;
				_tmp727_ = vala_symbol_get_parent_symbol (_tmp726_);
				_tmp728_ = _tmp727_;
				acc = VALA_IS_PROPERTY_ACCESSOR (_tmp728_) ? ((ValaPropertyAccessor*) _tmp728_) : NULL;
				_tmp731_ = acc;
				if (_tmp731_ != NULL) {
					ValaPropertyAccessor* _tmp732_;
					ValaSemanticAnalyzer* _tmp733_;
					ValaSemanticAnalyzer* _tmp734_;
					ValaSymbol* _tmp735_;
					ValaSymbol* _tmp736_;
					_tmp732_ = acc;
					_tmp733_ = vala_code_context_get_analyzer (context);
					_tmp734_ = _tmp733_;
					_tmp735_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp734_);
					_tmp736_ = _tmp735_;
					_tmp730_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp732_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp736_;
				} else {
					_tmp730_ = FALSE;
				}
				if (_tmp730_) {
					ValaParameter* _tmp737_;
					ValaPropertyAccessor* _tmp738_;
					ValaProperty* _tmp739_;
					ValaProperty* _tmp740_;
					ValaParameter* _tmp741_;
					ValaParameter* _tmp742_;
					_tmp737_ = param;
					_tmp738_ = acc;
					_tmp739_ = vala_property_accessor_get_prop (_tmp738_);
					_tmp740_ = _tmp739_;
					_tmp741_ = vala_property_get_this_parameter (_tmp740_);
					_tmp742_ = _tmp741_;
					_tmp729_ = _tmp737_ != _tmp742_;
				} else {
					_tmp729_ = FALSE;
				}
				if (_tmp729_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp743_;
					ValaSemanticAnalyzer* _tmp744_;
					ValaSymbol* _tmp745_;
					ValaSymbol* _tmp746_;
					ValaParameter* _tmp755_;
					ValaPropertyAccessor* _tmp756_;
					ValaBlock* _tmp757_;
					ValaBlock* _tmp758_;
					_tmp743_ = vala_code_context_get_analyzer (context);
					_tmp744_ = _tmp743_;
					_tmp745_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp744_);
					_tmp746_ = _tmp745_;
					sym = _tmp746_;
					while (TRUE) {
						ValaSymbol* _tmp747_;
						ValaMethod* _tmp748_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp749_;
						ValaMethod* _tmp750_;
						ValaSymbol* _tmp752_;
						ValaSymbol* _tmp753_;
						ValaSymbol* _tmp754_;
						_tmp747_ = sym;
						_tmp748_ = m;
						if (!(_tmp747_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp748_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp749_ = sym;
						method = VALA_IS_METHOD (_tmp749_) ? ((ValaMethod*) _tmp749_) : NULL;
						_tmp750_ = method;
						if (_tmp750_ != NULL) {
							ValaMethod* _tmp751_;
							_tmp751_ = method;
							vala_method_set_closure (_tmp751_, TRUE);
						}
						_tmp752_ = sym;
						_tmp753_ = vala_symbol_get_parent_symbol (_tmp752_);
						_tmp754_ = _tmp753_;
						sym = _tmp754_;
					}
					_tmp755_ = param;
					vala_parameter_set_captured (_tmp755_, TRUE);
					_tmp756_ = acc;
					_tmp757_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp756_);
					_tmp758_ = _tmp757_;
					vala_block_set_captured (_tmp758_, TRUE);
				}
			}
		} else {
			ValaSymbol* _tmp759_;
			_tmp759_ = member;
			if (VALA_IS_FIELD (_tmp759_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp760_;
				ValaField* _tmp761_;
				ValaSymbolAccessibility _tmp762_;
				ValaSymbolAccessibility _tmp763_;
				ValaField* _tmp764_;
				ValaMemberBinding _tmp765_;
				ValaMemberBinding _tmp766_;
				ValaField* _tmp767_;
				ValaMemberBinding _tmp768_;
				ValaMemberBinding _tmp769_;
				ValaField* _tmp770_;
				ValaDataType* _tmp771_;
				ValaDataType* _tmp772_;
				_tmp760_ = member;
				f = G_TYPE_CHECK_INSTANCE_CAST (_tmp760_, VALA_TYPE_FIELD, ValaField);
				_tmp761_ = f;
				_tmp762_ = vala_symbol_get_access ((ValaSymbol*) _tmp761_);
				_tmp763_ = _tmp762_;
				access = _tmp763_;
				_tmp764_ = f;
				_tmp765_ = vala_field_get_binding (_tmp764_);
				_tmp766_ = _tmp765_;
				instance = _tmp766_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp767_ = f;
				_tmp768_ = vala_field_get_binding (_tmp767_);
				_tmp769_ = _tmp768_;
				klass = _tmp769_ == VALA_MEMBER_BINDING_CLASS;
				_tmp770_ = f;
				_tmp771_ = vala_variable_get_variable_type ((ValaVariable*) _tmp770_);
				_tmp772_ = _tmp771_;
				if (VALA_IS_GENERIC_TYPE (_tmp772_)) {
					generics = TRUE;
				}
			} else {
				ValaSymbol* _tmp773_;
				_tmp773_ = member;
				if (VALA_IS_CONSTANT (_tmp773_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp774_;
					ValaConstant* _tmp775_;
					ValaSymbolAccessibility _tmp776_;
					ValaSymbolAccessibility _tmp777_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp778_;
					ValaSymbol* _tmp779_;
					ValaSymbol* _tmp780_;
					gboolean _tmp781_ = FALSE;
					ValaBlock* _tmp782_;
					_tmp774_ = member;
					c = G_TYPE_CHECK_INSTANCE_CAST (_tmp774_, VALA_TYPE_CONSTANT, ValaConstant);
					_tmp775_ = c;
					_tmp776_ = vala_symbol_get_access ((ValaSymbol*) _tmp775_);
					_tmp777_ = _tmp776_;
					access = _tmp777_;
					_tmp778_ = c;
					_tmp779_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp778_);
					_tmp780_ = _tmp779_;
					block = VALA_IS_BLOCK (_tmp780_) ? ((ValaBlock*) _tmp780_) : NULL;
					_tmp782_ = block;
					if (_tmp782_ != NULL) {
						ValaBlock* _tmp783_;
						ValaSymbol* _tmp784_;
						ValaSemanticAnalyzer* _tmp785_;
						ValaSemanticAnalyzer* _tmp786_;
						ValaSymbol* _tmp787_;
						ValaSymbol* _tmp788_;
						_tmp783_ = block;
						_tmp784_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp783_);
						_tmp785_ = vala_code_context_get_analyzer (context);
						_tmp786_ = _tmp785_;
						_tmp787_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp786_);
						_tmp788_ = _tmp787_;
						_tmp781_ = _tmp784_ != _tmp788_;
					} else {
						_tmp781_ = FALSE;
					}
					if (_tmp781_) {
						ValaSourceReference* _tmp789_;
						ValaSourceReference* _tmp790_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp789_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp790_ = _tmp789_;
						vala_report_error (_tmp790_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						return result;
					}
				} else {
					ValaSymbol* _tmp791_;
					_tmp791_ = member;
					if (VALA_IS_METHOD (_tmp791_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp792_;
						ValaMethod* _tmp793_;
						gboolean _tmp794_;
						gboolean _tmp795_;
						ValaMethod* _tmp884_;
						ValaSymbolAccessibility _tmp885_;
						ValaSymbolAccessibility _tmp886_;
						ValaMethod* _tmp887_;
						ValaMethod* _tmp891_;
						ValaMemberBinding _tmp892_;
						ValaMemberBinding _tmp893_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp912_;
						ValaDataType* _tmp913_;
						ValaDataType* _tmp914_;
						gboolean _tmp915_ = FALSE;
						ValaGenericType* _tmp916_;
						_tmp792_ = member;
						m = G_TYPE_CHECK_INSTANCE_CAST (_tmp792_, VALA_TYPE_METHOD, ValaMethod);
						_tmp793_ = m;
						_tmp794_ = vala_method_get_is_async_callback (_tmp793_);
						_tmp795_ = _tmp794_;
						if (_tmp795_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp796_;
							ValaSemanticAnalyzer* _tmp797_;
							ValaMethod* _tmp798_;
							ValaMethod* _tmp799_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp800_;
							ValaMethod* _tmp829_;
							ValaSemanticAnalyzer* _tmp830_;
							ValaSemanticAnalyzer* _tmp831_;
							ValaMethod* _tmp832_;
							ValaMethod* _tmp833_;
							ValaMethod* _tmp849_;
							ValaMethod* _tmp850_;
							ValaMethod* _tmp851_;
							ValaSymbol* _tmp852_;
							ValaSymbol* _tmp853_;
							_tmp796_ = vala_code_context_get_analyzer (context);
							_tmp797_ = _tmp796_;
							_tmp798_ = vala_semantic_analyzer_get_current_async_method (_tmp797_);
							_tmp799_ = _tmp798_;
							async_method = _tmp799_;
							is_valid_access = FALSE;
							_tmp800_ = async_method;
							if (_tmp800_ != NULL) {
								ValaMethod* _tmp801_;
								ValaMethod* _tmp802_;
								ValaMethod* _tmp803_;
								_tmp801_ = m;
								_tmp802_ = async_method;
								_tmp803_ = vala_method_get_callback_method (_tmp802_);
								if (_tmp801_ == _tmp803_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp804_ = FALSE;
									ValaMethod* _tmp805_;
									ValaMethod* _tmp806_;
									ValaMethod* _tmp807_;
									_tmp805_ = async_method;
									_tmp806_ = vala_method_get_base_method (_tmp805_);
									_tmp807_ = _tmp806_;
									if (_tmp807_ != NULL) {
										ValaMethod* _tmp808_;
										ValaMethod* _tmp809_;
										ValaMethod* _tmp810_;
										ValaMethod* _tmp811_;
										ValaMethod* _tmp812_;
										_tmp808_ = m;
										_tmp809_ = async_method;
										_tmp810_ = vala_method_get_base_method (_tmp809_);
										_tmp811_ = _tmp810_;
										_tmp812_ = vala_method_get_callback_method (_tmp811_);
										_tmp804_ = _tmp808_ == _tmp812_;
									} else {
										_tmp804_ = FALSE;
									}
									if (_tmp804_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp813_ = FALSE;
										ValaMethod* _tmp814_;
										ValaMethod* _tmp815_;
										ValaMethod* _tmp816_;
										_tmp814_ = async_method;
										_tmp815_ = vala_method_get_base_interface_method (_tmp814_);
										_tmp816_ = _tmp815_;
										if (_tmp816_ != NULL) {
											ValaMethod* _tmp817_;
											ValaMethod* _tmp818_;
											ValaMethod* _tmp819_;
											ValaMethod* _tmp820_;
											ValaMethod* _tmp821_;
											_tmp817_ = m;
											_tmp818_ = async_method;
											_tmp819_ = vala_method_get_base_interface_method (_tmp818_);
											_tmp820_ = _tmp819_;
											_tmp821_ = vala_method_get_callback_method (_tmp820_);
											_tmp813_ = _tmp817_ == _tmp821_;
										} else {
											_tmp813_ = FALSE;
										}
										if (_tmp813_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp822_;
								ValaSourceReference* _tmp823_;
								ValaMethod* _tmp824_;
								gchar* _tmp825_;
								gchar* _tmp826_;
								gchar* _tmp827_;
								gchar* _tmp828_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp822_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp823_ = _tmp822_;
								_tmp824_ = m;
								_tmp825_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp824_);
								_tmp826_ = _tmp825_;
								_tmp827_ = g_strdup_printf ("Access to async callback `%s' not allowed in this context", _tmp826_);
								_tmp828_ = _tmp827_;
								vala_report_error (_tmp823_, _tmp828_);
								_g_free0 (_tmp828_);
								_g_free0 (_tmp826_);
								result = FALSE;
								return result;
							}
							_tmp829_ = async_method;
							_tmp830_ = vala_code_context_get_analyzer (context);
							_tmp831_ = _tmp830_;
							_tmp832_ = vala_semantic_analyzer_get_current_method (_tmp831_);
							_tmp833_ = _tmp832_;
							if (_tmp829_ != _tmp833_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp834_;
								ValaSemanticAnalyzer* _tmp835_;
								ValaMethod* _tmp836_;
								ValaMethod* _tmp837_;
								ValaMethod* _tmp846_;
								ValaBlock* _tmp847_;
								ValaBlock* _tmp848_;
								_tmp834_ = vala_code_context_get_analyzer (context);
								_tmp835_ = _tmp834_;
								_tmp836_ = vala_semantic_analyzer_get_current_method (_tmp835_);
								_tmp837_ = _tmp836_;
								sym = (ValaSymbol*) _tmp837_;
								while (TRUE) {
									ValaSymbol* _tmp838_;
									ValaMethod* _tmp839_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp840_;
									ValaMethod* _tmp841_;
									ValaSymbol* _tmp843_;
									ValaSymbol* _tmp844_;
									ValaSymbol* _tmp845_;
									_tmp838_ = sym;
									_tmp839_ = async_method;
									if (!(_tmp838_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp839_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp840_ = sym;
									method = VALA_IS_METHOD (_tmp840_) ? ((ValaMethod*) _tmp840_) : NULL;
									_tmp841_ = method;
									if (_tmp841_ != NULL) {
										ValaMethod* _tmp842_;
										_tmp842_ = method;
										vala_method_set_closure (_tmp842_, TRUE);
									}
									_tmp843_ = sym;
									_tmp844_ = vala_symbol_get_parent_symbol (_tmp843_);
									_tmp845_ = _tmp844_;
									sym = _tmp845_;
								}
								_tmp846_ = async_method;
								_tmp847_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp846_);
								_tmp848_ = _tmp847_;
								vala_block_set_captured (_tmp848_, TRUE);
							}
							_tmp849_ = async_method;
							_tmp850_ = vala_method_get_callback_method (_tmp849_);
							m = _tmp850_;
							_tmp851_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp851_);
							_tmp852_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp853_ = _tmp852_;
							member = _tmp853_;
						} else {
							ValaMethod* _tmp854_;
							ValaMethod* _tmp855_;
							ValaMethod* _tmp856_;
							_tmp854_ = m;
							_tmp855_ = vala_method_get_base_method (_tmp854_);
							_tmp856_ = _tmp855_;
							if (_tmp856_ != NULL) {
								ValaMethod* _tmp857_;
								ValaMethod* _tmp858_;
								ValaMethod* _tmp859_;
								ValaMethod* _tmp860_;
								ValaSignal* _tmp861_;
								ValaSignal* _tmp862_;
								ValaSymbol* _tmp867_;
								ValaSymbol* _tmp868_;
								_tmp857_ = m;
								_tmp858_ = vala_method_get_base_method (_tmp857_);
								_tmp859_ = _tmp858_;
								m = _tmp859_;
								_tmp860_ = m;
								_tmp861_ = vala_method_get_signal_reference (_tmp860_);
								_tmp862_ = _tmp861_;
								if (_tmp862_ != NULL) {
									ValaMethod* _tmp863_;
									ValaSignal* _tmp864_;
									ValaSignal* _tmp865_;
									_tmp863_ = m;
									_tmp864_ = vala_method_get_signal_reference (_tmp863_);
									_tmp865_ = _tmp864_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp865_);
								} else {
									ValaMethod* _tmp866_;
									_tmp866_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp866_);
								}
								_tmp867_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp868_ = _tmp867_;
								member = _tmp868_;
							} else {
								ValaMethod* _tmp869_;
								ValaMethod* _tmp870_;
								ValaMethod* _tmp871_;
								_tmp869_ = m;
								_tmp870_ = vala_method_get_base_interface_method (_tmp869_);
								_tmp871_ = _tmp870_;
								if (_tmp871_ != NULL) {
									ValaMethod* _tmp872_;
									ValaMethod* _tmp873_;
									ValaMethod* _tmp874_;
									ValaMethod* _tmp875_;
									ValaSignal* _tmp876_;
									ValaSignal* _tmp877_;
									ValaSymbol* _tmp882_;
									ValaSymbol* _tmp883_;
									_tmp872_ = m;
									_tmp873_ = vala_method_get_base_interface_method (_tmp872_);
									_tmp874_ = _tmp873_;
									m = _tmp874_;
									_tmp875_ = m;
									_tmp876_ = vala_method_get_signal_reference (_tmp875_);
									_tmp877_ = _tmp876_;
									if (_tmp877_ != NULL) {
										ValaMethod* _tmp878_;
										ValaSignal* _tmp879_;
										ValaSignal* _tmp880_;
										_tmp878_ = m;
										_tmp879_ = vala_method_get_signal_reference (_tmp878_);
										_tmp880_ = _tmp879_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp880_);
									} else {
										ValaMethod* _tmp881_;
										_tmp881_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp881_);
									}
									_tmp882_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp883_ = _tmp882_;
									member = _tmp883_;
								}
							}
						}
						_tmp884_ = m;
						_tmp885_ = vala_symbol_get_access ((ValaSymbol*) _tmp884_);
						_tmp886_ = _tmp885_;
						access = _tmp886_;
						_tmp887_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp887_)) {
							ValaMethod* _tmp888_;
							ValaMemberBinding _tmp889_;
							ValaMemberBinding _tmp890_;
							_tmp888_ = m;
							_tmp889_ = vala_method_get_binding (_tmp888_);
							_tmp890_ = _tmp889_;
							instance = _tmp890_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp891_ = m;
						_tmp892_ = vala_method_get_binding (_tmp891_);
						_tmp893_ = _tmp892_;
						klass = _tmp893_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp894_;
							ValaList* _tmp895_;
							ValaList* _tmp896_;
							gint _param_size = 0;
							ValaList* _tmp897_;
							gint _tmp898_;
							gint _tmp899_;
							gint _param_index = 0;
							_tmp894_ = m;
							_tmp895_ = vala_callable_get_parameters ((ValaCallable*) _tmp894_);
							_tmp896_ = _vala_iterable_ref0 (_tmp895_);
							_param_list = _tmp896_;
							_tmp897_ = _param_list;
							_tmp898_ = vala_collection_get_size ((ValaCollection*) _tmp897_);
							_tmp899_ = _tmp898_;
							_param_size = _tmp899_;
							_param_index = -1;
							while (TRUE) {
								ValaParameter* param = NULL;
								ValaList* _tmp900_;
								gpointer _tmp901_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp902_;
								ValaDataType* _tmp903_;
								ValaDataType* _tmp904_;
								gboolean _tmp905_ = FALSE;
								ValaGenericType* _tmp906_;
								_param_index = _param_index + 1;
								if (!(_param_index < _param_size)) {
									break;
								}
								_tmp900_ = _param_list;
								_tmp901_ = vala_list_get (_tmp900_, _param_index);
								param = (ValaParameter*) _tmp901_;
								_tmp902_ = param;
								_tmp903_ = vala_variable_get_variable_type ((ValaVariable*) _tmp902_);
								_tmp904_ = _tmp903_;
								generic_type = VALA_IS_GENERIC_TYPE (_tmp904_) ? ((ValaGenericType*) _tmp904_) : NULL;
								_tmp906_ = generic_type;
								if (_tmp906_ != NULL) {
									ValaGenericType* _tmp907_;
									ValaTypeParameter* _tmp908_;
									ValaTypeParameter* _tmp909_;
									ValaSymbol* _tmp910_;
									ValaSymbol* _tmp911_;
									_tmp907_ = generic_type;
									_tmp908_ = vala_generic_type_get_type_parameter (_tmp907_);
									_tmp909_ = _tmp908_;
									_tmp910_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp909_);
									_tmp911_ = _tmp910_;
									_tmp905_ = VALA_IS_TYPESYMBOL (_tmp911_);
								} else {
									_tmp905_ = FALSE;
								}
								if (_tmp905_) {
									generics = TRUE;
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp912_ = m;
						_tmp913_ = vala_callable_get_return_type ((ValaCallable*) _tmp912_);
						_tmp914_ = _tmp913_;
						generic_type = VALA_IS_GENERIC_TYPE (_tmp914_) ? ((ValaGenericType*) _tmp914_) : NULL;
						_tmp916_ = generic_type;
						if (_tmp916_ != NULL) {
							ValaGenericType* _tmp917_;
							ValaTypeParameter* _tmp918_;
							ValaTypeParameter* _tmp919_;
							ValaSymbol* _tmp920_;
							ValaSymbol* _tmp921_;
							_tmp917_ = generic_type;
							_tmp918_ = vala_generic_type_get_type_parameter (_tmp917_);
							_tmp919_ = _tmp918_;
							_tmp920_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp919_);
							_tmp921_ = _tmp920_;
							_tmp915_ = VALA_IS_TYPESYMBOL (_tmp921_);
						} else {
							_tmp915_ = FALSE;
						}
						if (_tmp915_) {
							generics = TRUE;
						}
					} else {
						ValaSymbol* _tmp922_;
						_tmp922_ = member;
						if (VALA_IS_PROPERTY (_tmp922_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp923_;
							ValaProperty* _tmp924_;
							ValaProperty* _tmp925_;
							ValaProperty* _tmp926_;
							ValaProperty* _tmp927_;
							ValaProperty* _tmp943_;
							ValaSymbolAccessibility _tmp944_;
							ValaSymbolAccessibility _tmp945_;
							gboolean _tmp946_;
							gboolean _tmp947_;
							ValaProperty* _tmp1012_;
							ValaMemberBinding _tmp1013_;
							ValaMemberBinding _tmp1014_;
							ValaProperty* _tmp1015_;
							ValaDataType* _tmp1016_;
							ValaDataType* _tmp1017_;
							_tmp923_ = member;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp923_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp924_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp924_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								return result;
							}
							_tmp925_ = prop;
							_tmp926_ = vala_property_get_base_property (_tmp925_);
							_tmp927_ = _tmp926_;
							if (_tmp927_ != NULL) {
								ValaProperty* _tmp928_;
								ValaProperty* _tmp929_;
								ValaProperty* _tmp930_;
								ValaProperty* _tmp931_;
								ValaSymbol* _tmp932_;
								ValaSymbol* _tmp933_;
								_tmp928_ = prop;
								_tmp929_ = vala_property_get_base_property (_tmp928_);
								_tmp930_ = _tmp929_;
								prop = _tmp930_;
								_tmp931_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp931_);
								_tmp932_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp933_ = _tmp932_;
								member = _tmp933_;
							} else {
								ValaProperty* _tmp934_;
								ValaProperty* _tmp935_;
								ValaProperty* _tmp936_;
								_tmp934_ = prop;
								_tmp935_ = vala_property_get_base_interface_property (_tmp934_);
								_tmp936_ = _tmp935_;
								if (_tmp936_ != NULL) {
									ValaProperty* _tmp937_;
									ValaProperty* _tmp938_;
									ValaProperty* _tmp939_;
									ValaProperty* _tmp940_;
									ValaSymbol* _tmp941_;
									ValaSymbol* _tmp942_;
									_tmp937_ = prop;
									_tmp938_ = vala_property_get_base_interface_property (_tmp937_);
									_tmp939_ = _tmp938_;
									prop = _tmp939_;
									_tmp940_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp940_);
									_tmp941_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp942_ = _tmp941_;
									member = _tmp942_;
								}
							}
							_tmp943_ = prop;
							_tmp944_ = vala_symbol_get_access ((ValaSymbol*) _tmp943_);
							_tmp945_ = _tmp944_;
							access = _tmp945_;
							_tmp946_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp947_ = _tmp946_;
							if (_tmp947_) {
								ValaProperty* _tmp948_;
								ValaPropertyAccessor* _tmp949_;
								ValaPropertyAccessor* _tmp950_;
								ValaProperty* _tmp958_;
								ValaSymbolAccessibility _tmp959_;
								ValaSymbolAccessibility _tmp960_;
								_tmp948_ = prop;
								_tmp949_ = vala_property_get_set_accessor (_tmp948_);
								_tmp950_ = _tmp949_;
								if (_tmp950_ == NULL) {
									ValaSourceReference* _tmp951_;
									ValaSourceReference* _tmp952_;
									ValaProperty* _tmp953_;
									gchar* _tmp954_;
									gchar* _tmp955_;
									gchar* _tmp956_;
									gchar* _tmp957_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp951_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp952_ = _tmp951_;
									_tmp953_ = prop;
									_tmp954_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp953_);
									_tmp955_ = _tmp954_;
									_tmp956_ = g_strdup_printf ("Property `%s' is read-only", _tmp955_);
									_tmp957_ = _tmp956_;
									vala_report_error (_tmp952_, _tmp957_);
									_g_free0 (_tmp957_);
									_g_free0 (_tmp955_);
									result = FALSE;
									return result;
								}
								_tmp958_ = prop;
								_tmp959_ = vala_symbol_get_access ((ValaSymbol*) _tmp958_);
								_tmp960_ = _tmp959_;
								if (_tmp960_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp961_;
									ValaPropertyAccessor* _tmp962_;
									ValaPropertyAccessor* _tmp963_;
									ValaSymbolAccessibility _tmp964_;
									ValaSymbolAccessibility _tmp965_;
									_tmp961_ = prop;
									_tmp962_ = vala_property_get_set_accessor (_tmp961_);
									_tmp963_ = _tmp962_;
									_tmp964_ = vala_symbol_get_access ((ValaSymbol*) _tmp963_);
									_tmp965_ = _tmp964_;
									access = _tmp965_;
								} else {
									gboolean _tmp966_ = FALSE;
									ValaProperty* _tmp967_;
									ValaSymbolAccessibility _tmp968_;
									ValaSymbolAccessibility _tmp969_;
									_tmp967_ = prop;
									_tmp968_ = vala_symbol_get_access ((ValaSymbol*) _tmp967_);
									_tmp969_ = _tmp968_;
									if (_tmp969_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp970_;
										ValaPropertyAccessor* _tmp971_;
										ValaPropertyAccessor* _tmp972_;
										ValaSymbolAccessibility _tmp973_;
										ValaSymbolAccessibility _tmp974_;
										_tmp970_ = prop;
										_tmp971_ = vala_property_get_set_accessor (_tmp970_);
										_tmp972_ = _tmp971_;
										_tmp973_ = vala_symbol_get_access ((ValaSymbol*) _tmp972_);
										_tmp974_ = _tmp973_;
										_tmp966_ = _tmp974_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp966_ = FALSE;
									}
									if (_tmp966_) {
										ValaProperty* _tmp975_;
										ValaPropertyAccessor* _tmp976_;
										ValaPropertyAccessor* _tmp977_;
										ValaSymbolAccessibility _tmp978_;
										ValaSymbolAccessibility _tmp979_;
										_tmp975_ = prop;
										_tmp976_ = vala_property_get_set_accessor (_tmp975_);
										_tmp977_ = _tmp976_;
										_tmp978_ = vala_symbol_get_access ((ValaSymbol*) _tmp977_);
										_tmp979_ = _tmp978_;
										access = _tmp979_;
									}
								}
							} else {
								ValaProperty* _tmp980_;
								ValaPropertyAccessor* _tmp981_;
								ValaPropertyAccessor* _tmp982_;
								ValaProperty* _tmp990_;
								ValaSymbolAccessibility _tmp991_;
								ValaSymbolAccessibility _tmp992_;
								_tmp980_ = prop;
								_tmp981_ = vala_property_get_get_accessor (_tmp980_);
								_tmp982_ = _tmp981_;
								if (_tmp982_ == NULL) {
									ValaSourceReference* _tmp983_;
									ValaSourceReference* _tmp984_;
									ValaProperty* _tmp985_;
									gchar* _tmp986_;
									gchar* _tmp987_;
									gchar* _tmp988_;
									gchar* _tmp989_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp983_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp984_ = _tmp983_;
									_tmp985_ = prop;
									_tmp986_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp985_);
									_tmp987_ = _tmp986_;
									_tmp988_ = g_strdup_printf ("Property `%s' is write-only", _tmp987_);
									_tmp989_ = _tmp988_;
									vala_report_error (_tmp984_, _tmp989_);
									_g_free0 (_tmp989_);
									_g_free0 (_tmp987_);
									result = FALSE;
									return result;
								}
								_tmp990_ = prop;
								_tmp991_ = vala_symbol_get_access ((ValaSymbol*) _tmp990_);
								_tmp992_ = _tmp991_;
								if (_tmp992_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp993_;
									ValaPropertyAccessor* _tmp994_;
									ValaPropertyAccessor* _tmp995_;
									ValaSymbolAccessibility _tmp996_;
									ValaSymbolAccessibility _tmp997_;
									_tmp993_ = prop;
									_tmp994_ = vala_property_get_get_accessor (_tmp993_);
									_tmp995_ = _tmp994_;
									_tmp996_ = vala_symbol_get_access ((ValaSymbol*) _tmp995_);
									_tmp997_ = _tmp996_;
									access = _tmp997_;
								} else {
									gboolean _tmp998_ = FALSE;
									ValaProperty* _tmp999_;
									ValaSymbolAccessibility _tmp1000_;
									ValaSymbolAccessibility _tmp1001_;
									_tmp999_ = prop;
									_tmp1000_ = vala_symbol_get_access ((ValaSymbol*) _tmp999_);
									_tmp1001_ = _tmp1000_;
									if (_tmp1001_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1002_;
										ValaPropertyAccessor* _tmp1003_;
										ValaPropertyAccessor* _tmp1004_;
										ValaSymbolAccessibility _tmp1005_;
										ValaSymbolAccessibility _tmp1006_;
										_tmp1002_ = prop;
										_tmp1003_ = vala_property_get_get_accessor (_tmp1002_);
										_tmp1004_ = _tmp1003_;
										_tmp1005_ = vala_symbol_get_access ((ValaSymbol*) _tmp1004_);
										_tmp1006_ = _tmp1005_;
										_tmp998_ = _tmp1006_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp998_ = FALSE;
									}
									if (_tmp998_) {
										ValaProperty* _tmp1007_;
										ValaPropertyAccessor* _tmp1008_;
										ValaPropertyAccessor* _tmp1009_;
										ValaSymbolAccessibility _tmp1010_;
										ValaSymbolAccessibility _tmp1011_;
										_tmp1007_ = prop;
										_tmp1008_ = vala_property_get_get_accessor (_tmp1007_);
										_tmp1009_ = _tmp1008_;
										_tmp1010_ = vala_symbol_get_access ((ValaSymbol*) _tmp1009_);
										_tmp1011_ = _tmp1010_;
										access = _tmp1011_;
									}
								}
							}
							_tmp1012_ = prop;
							_tmp1013_ = vala_property_get_binding (_tmp1012_);
							_tmp1014_ = _tmp1013_;
							instance = _tmp1014_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1015_ = prop;
							_tmp1016_ = vala_property_get_property_type (_tmp1015_);
							_tmp1017_ = _tmp1016_;
							if (VALA_IS_GENERIC_TYPE (_tmp1017_)) {
								generics = TRUE;
							}
						} else {
							ValaSymbol* _tmp1018_;
							_tmp1018_ = member;
							if (VALA_IS_SIGNAL (_tmp1018_)) {
								ValaSymbol* _tmp1019_;
								ValaSymbolAccessibility _tmp1020_;
								ValaSymbolAccessibility _tmp1021_;
								instance = TRUE;
								_tmp1019_ = member;
								_tmp1020_ = vala_symbol_get_access (_tmp1019_);
								_tmp1021_ = _tmp1020_;
								access = _tmp1021_;
							} else {
								gboolean _tmp1022_ = FALSE;
								gboolean _tmp1023_;
								_tmp1023_ = self->priv->_creation_member;
								if (!_tmp1023_) {
									ValaSymbol* _tmp1024_;
									_tmp1024_ = member;
									_tmp1022_ = VALA_IS_ERROR_CODE (_tmp1024_);
								} else {
									_tmp1022_ = FALSE;
								}
								if (_tmp1022_) {
									ValaSymbol* _tmp1025_;
									ValaConstant* _tmp1026_;
									ValaConstant* _tmp1027_;
									ValaSymbol* _tmp1028_;
									ValaSymbol* _tmp1029_;
									_tmp1025_ = member;
									_tmp1026_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp1025_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp1027_ = _tmp1026_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1027_);
									_tmp1028_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1029_ = _tmp1028_;
									member = _tmp1029_;
								}
							}
						}
					}
				}
			}
		}
	}
	parent = (ValaCodeNode*) self;
	while (TRUE) {
		ValaCodeNode* _tmp1030_;
		ValaSymbol* _tmp1031_;
		ValaCodeNode* _tmp1032_;
		ValaCodeNode* _tmp1033_;
		ValaCodeNode* _tmp1034_;
		gboolean _tmp1035_ = FALSE;
		ValaCodeNode* _tmp1036_;
		_tmp1030_ = parent;
		_tmp1031_ = member;
		if (!(_tmp1030_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1031_, VALA_TYPE_CODE_NODE, ValaCodeNode))) {
			break;
		}
		_tmp1032_ = parent;
		_tmp1033_ = vala_code_node_get_parent_node (_tmp1032_);
		_tmp1034_ = _tmp1033_;
		parent = _tmp1034_;
		_tmp1036_ = parent;
		if (_tmp1036_ == NULL) {
			_tmp1035_ = TRUE;
		} else {
			ValaCodeNode* _tmp1037_;
			ValaSymbol* _tmp1038_;
			_tmp1037_ = parent;
			_tmp1038_ = member;
			_tmp1035_ = _tmp1037_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1038_, VALA_TYPE_CODE_NODE, ValaCodeNode);
		}
		if (_tmp1035_) {
			break;
		}
	}
	_tmp1039_ = parent;
	_tmp1040_ = member;
	if (_tmp1039_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1040_, VALA_TYPE_CODE_NODE, ValaCodeNode)) {
		ValaSymbol* _tmp1041_;
		_tmp1041_ = member;
		vala_symbol_set_used (_tmp1041_, TRUE);
	}
	_tmp1042_ = member;
	_tmp1043_ = vala_symbol_get_version (_tmp1042_);
	_tmp1044_ = _tmp1043_;
	_tmp1045_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1046_ = _tmp1045_;
	vala_version_attribute_check (_tmp1044_, _tmp1046_);
	_tmp1048_ = access;
	if (_tmp1048_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1049_;
		ValaSymbol* _tmp1050_;
		ValaSymbol* _tmp1051_;
		_tmp1049_ = member;
		_tmp1050_ = vala_symbol_get_parent_symbol (_tmp1049_);
		_tmp1051_ = _tmp1050_;
		_tmp1047_ = VALA_IS_TYPESYMBOL (_tmp1051_);
	} else {
		_tmp1047_ = FALSE;
	}
	if (_tmp1047_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1052_;
		ValaSymbol* _tmp1053_;
		ValaSymbol* _tmp1054_;
		gboolean in_subtype = FALSE;
		_tmp1052_ = member;
		_tmp1053_ = vala_symbol_get_parent_symbol (_tmp1052_);
		_tmp1054_ = _tmp1053_;
		target_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp1054_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1055_;
			ValaSemanticAnalyzer* _tmp1056_;
			ValaSymbol* _tmp1057_;
			ValaSymbol* _tmp1058_;
			ValaSymbol* _tmp1059_;
			_tmp1055_ = vala_code_context_get_analyzer (context);
			_tmp1056_ = _tmp1055_;
			_tmp1057_ = vala_semantic_analyzer_get_current_symbol (_tmp1056_);
			_tmp1058_ = _tmp1057_;
			_tmp1059_ = _vala_code_node_ref0 (_tmp1058_);
			this_symbol = _tmp1059_;
			{
				gboolean _tmp1060_ = FALSE;
				_tmp1060_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1065_;
					ValaSymbol* _tmp1066_;
					ValaTypeSymbol* _tmp1067_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1068_;
					gboolean _tmp1069_ = FALSE;
					ValaClass* _tmp1070_;
					if (!_tmp1060_) {
						ValaSymbol* _tmp1061_;
						ValaSymbol* _tmp1062_;
						ValaSymbol* _tmp1063_;
						ValaSymbol* _tmp1064_;
						_tmp1061_ = this_symbol;
						_tmp1062_ = vala_symbol_get_parent_symbol (_tmp1061_);
						_tmp1063_ = _tmp1062_;
						_tmp1064_ = _vala_code_node_ref0 (_tmp1063_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1064_;
					}
					_tmp1060_ = FALSE;
					_tmp1065_ = this_symbol;
					if (!(_tmp1065_ != NULL)) {
						break;
					}
					_tmp1066_ = this_symbol;
					_tmp1067_ = target_type;
					if (_tmp1066_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1067_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1068_ = this_symbol;
					cl = VALA_IS_CLASS (_tmp1068_) ? ((ValaClass*) _tmp1068_) : NULL;
					_tmp1070_ = cl;
					if (_tmp1070_ != NULL) {
						ValaClass* _tmp1071_;
						ValaTypeSymbol* _tmp1072_;
						_tmp1071_ = cl;
						_tmp1072_ = target_type;
						_tmp1069_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1071_, _tmp1072_);
					} else {
						_tmp1069_ = FALSE;
					}
					if (_tmp1069_) {
						in_subtype = TRUE;
						break;
					}
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1073_;
			ValaSourceReference* _tmp1074_;
			ValaSymbol* _tmp1075_;
			gchar* _tmp1076_;
			gchar* _tmp1077_;
			gchar* _tmp1078_;
			gchar* _tmp1079_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1073_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1074_ = _tmp1073_;
			_tmp1075_ = member;
			_tmp1076_ = vala_symbol_get_full_name (_tmp1075_);
			_tmp1077_ = _tmp1076_;
			_tmp1078_ = g_strdup_printf ("Access to protected member `%s' denied", _tmp1077_);
			_tmp1079_ = _tmp1078_;
			vala_report_error (_tmp1074_, _tmp1079_);
			_g_free0 (_tmp1079_);
			_g_free0 (_tmp1077_);
			result = FALSE;
			return result;
		}
	} else {
		ValaSymbolAccessibility _tmp1080_;
		_tmp1080_ = access;
		if (_tmp1080_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1081_;
			ValaSymbol* _tmp1082_;
			ValaSymbol* _tmp1083_;
			gboolean in_target_type = FALSE;
			_tmp1081_ = member;
			_tmp1082_ = vala_symbol_get_parent_symbol (_tmp1081_);
			_tmp1083_ = _tmp1082_;
			target_type = _tmp1083_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1084_;
				ValaSemanticAnalyzer* _tmp1085_;
				ValaSymbol* _tmp1086_;
				ValaSymbol* _tmp1087_;
				ValaSymbol* _tmp1088_;
				_tmp1084_ = vala_code_context_get_analyzer (context);
				_tmp1085_ = _tmp1084_;
				_tmp1086_ = vala_semantic_analyzer_get_current_symbol (_tmp1085_);
				_tmp1087_ = _tmp1086_;
				_tmp1088_ = _vala_code_node_ref0 (_tmp1087_);
				this_symbol = _tmp1088_;
				{
					gboolean _tmp1089_ = FALSE;
					_tmp1089_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1094_;
						ValaSymbol* _tmp1095_;
						ValaSymbol* _tmp1096_;
						if (!_tmp1089_) {
							ValaSymbol* _tmp1090_;
							ValaSymbol* _tmp1091_;
							ValaSymbol* _tmp1092_;
							ValaSymbol* _tmp1093_;
							_tmp1090_ = this_symbol;
							_tmp1091_ = vala_symbol_get_parent_symbol (_tmp1090_);
							_tmp1092_ = _tmp1091_;
							_tmp1093_ = _vala_code_node_ref0 (_tmp1092_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1093_;
						}
						_tmp1089_ = FALSE;
						_tmp1094_ = this_symbol;
						if (!(_tmp1094_ != NULL)) {
							break;
						}
						_tmp1095_ = target_type;
						_tmp1096_ = this_symbol;
						if (_tmp1095_ == _tmp1096_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1097_;
				ValaSourceReference* _tmp1098_;
				ValaSymbol* _tmp1099_;
				gchar* _tmp1100_;
				gchar* _tmp1101_;
				gchar* _tmp1102_;
				gchar* _tmp1103_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1097_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1098_ = _tmp1097_;
				_tmp1099_ = member;
				_tmp1100_ = vala_symbol_get_full_name (_tmp1099_);
				_tmp1101_ = _tmp1100_;
				_tmp1102_ = g_strdup_printf ("Access to private member `%s' denied", _tmp1101_);
				_tmp1103_ = _tmp1102_;
				vala_report_error (_tmp1098_, _tmp1103_);
				_g_free0 (_tmp1103_);
				_g_free0 (_tmp1101_);
				result = FALSE;
				return result;
			}
		}
	}
	if (generics) {
		ValaExpression* _tmp1105_;
		ValaExpression* _tmp1106_;
		_tmp1105_ = vala_member_access_get_inner (self);
		_tmp1106_ = _tmp1105_;
		_tmp1104_ = _tmp1106_ != NULL;
	} else {
		_tmp1104_ = FALSE;
	}
	if (_tmp1104_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1107_;
		ValaExpression* _tmp1108_;
		ValaDataType* _tmp1109_;
		ValaDataType* _tmp1110_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1111_;
		ValaExpression* _tmp1112_;
		ValaDataType* _tmp1113_;
		ValaDataType* _tmp1114_;
		ValaPointerType* _tmp1115_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1119_;
		gboolean _tmp1120_ = FALSE;
		gboolean _tmp1121_ = FALSE;
		ValaObjectType* _tmp1122_;
		_tmp1107_ = vala_member_access_get_inner (self);
		_tmp1108_ = _tmp1107_;
		_tmp1109_ = vala_expression_get_value_type (_tmp1108_);
		_tmp1110_ = _tmp1109_;
		instance_type = _tmp1110_;
		_tmp1111_ = vala_member_access_get_inner (self);
		_tmp1112_ = _tmp1111_;
		_tmp1113_ = vala_expression_get_value_type (_tmp1112_);
		_tmp1114_ = _tmp1113_;
		pointer_type = VALA_IS_POINTER_TYPE (_tmp1114_) ? ((ValaPointerType*) _tmp1114_) : NULL;
		_tmp1115_ = pointer_type;
		if (_tmp1115_ != NULL) {
			ValaPointerType* _tmp1116_;
			ValaDataType* _tmp1117_;
			ValaDataType* _tmp1118_;
			_tmp1116_ = pointer_type;
			_tmp1117_ = vala_pointer_type_get_base_type (_tmp1116_);
			_tmp1118_ = _tmp1117_;
			instance_type = _tmp1118_;
		}
		_tmp1119_ = instance_type;
		object_type = VALA_IS_OBJECT_TYPE (_tmp1119_) ? ((ValaObjectType*) _tmp1119_) : NULL;
		_tmp1122_ = object_type;
		if (_tmp1122_ != NULL) {
			ValaObjectType* _tmp1123_;
			ValaObjectTypeSymbol* _tmp1124_;
			ValaObjectTypeSymbol* _tmp1125_;
			_tmp1123_ = object_type;
			_tmp1124_ = vala_object_type_get_object_type_symbol (_tmp1123_);
			_tmp1125_ = _tmp1124_;
			_tmp1121_ = vala_object_type_symbol_has_type_parameters (_tmp1125_);
		} else {
			_tmp1121_ = FALSE;
		}
		if (_tmp1121_) {
			ValaDataType* _tmp1126_;
			_tmp1126_ = instance_type;
			_tmp1120_ = !vala_data_type_has_type_arguments (_tmp1126_);
		} else {
			_tmp1120_ = FALSE;
		}
		if (_tmp1120_) {
			ValaExpression* _tmp1127_;
			ValaExpression* _tmp1128_;
			ValaSourceReference* _tmp1129_;
			ValaSourceReference* _tmp1130_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1127_ = vala_member_access_get_inner (self);
			_tmp1128_ = _tmp1127_;
			_tmp1129_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1128_);
			_tmp1130_ = _tmp1129_;
			vala_report_error (_tmp1130_, "missing generic type arguments");
			result = FALSE;
			return result;
		}
	}
	if (instance) {
		_tmp1132_ = !may_access_instance_members;
	} else {
		_tmp1132_ = FALSE;
	}
	if (_tmp1132_) {
		_tmp1131_ = TRUE;
	} else {
		gboolean _tmp1133_ = FALSE;
		if (klass) {
			_tmp1133_ = !may_access_klass_members;
		} else {
			_tmp1133_ = FALSE;
		}
		_tmp1131_ = _tmp1133_;
	}
	if (_tmp1131_) {
		ValaSymbol* _tmp1134_;
		ValaSymbol* _tmp1135_;
		ValaDataType* _tmp1158_;
		ValaDataType* _tmp1159_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1134_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1135_ = _tmp1134_;
		if (VALA_IS_METHOD (_tmp1135_)) {
			ValaSemanticAnalyzer* _tmp1136_;
			ValaSemanticAnalyzer* _tmp1137_;
			ValaSymbol* _tmp1138_;
			ValaSymbol* _tmp1139_;
			gboolean _tmp1140_;
			gboolean _tmp1141_;
			ValaDataType* _tmp1142_;
			ValaDataType* _tmp1143_;
			_tmp1136_ = vala_code_context_get_analyzer (context);
			_tmp1137_ = _tmp1136_;
			_tmp1138_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1139_ = _tmp1138_;
			_tmp1140_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1141_ = _tmp1140_;
			_tmp1142_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1137_, _tmp1139_, _tmp1141_);
			_tmp1143_ = _tmp1142_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1143_);
			_vala_code_node_unref0 (_tmp1143_);
		} else {
			ValaSymbol* _tmp1144_;
			ValaSymbol* _tmp1145_;
			_tmp1144_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1145_ = _tmp1144_;
			if (VALA_IS_FIELD (_tmp1145_)) {
				ValaSymbol* _tmp1146_;
				ValaSymbol* _tmp1147_;
				ValaFieldPrototype* _tmp1148_;
				ValaFieldPrototype* _tmp1149_;
				_tmp1146_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1147_ = _tmp1146_;
				_tmp1148_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1147_, VALA_TYPE_FIELD, ValaField));
				_tmp1149_ = _tmp1148_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1149_);
				_vala_code_node_unref0 (_tmp1149_);
			} else {
				ValaSymbol* _tmp1150_;
				ValaSymbol* _tmp1151_;
				_tmp1150_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1151_ = _tmp1150_;
				if (VALA_IS_PROPERTY (_tmp1151_)) {
					ValaSymbol* _tmp1152_;
					ValaSymbol* _tmp1153_;
					ValaPropertyPrototype* _tmp1154_;
					ValaPropertyPrototype* _tmp1155_;
					_tmp1152_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1153_ = _tmp1152_;
					_tmp1154_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1153_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1155_ = _tmp1154_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1155_);
					_vala_code_node_unref0 (_tmp1155_);
				} else {
					ValaInvalidType* _tmp1156_;
					ValaInvalidType* _tmp1157_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp1156_ = vala_invalid_type_new ();
					_tmp1157_ = _tmp1156_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1157_);
					_vala_code_node_unref0 (_tmp1157_);
				}
			}
		}
		_tmp1158_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1159_ = _tmp1158_;
		if (_tmp1159_ != NULL) {
			ValaDataType* _tmp1160_;
			ValaDataType* _tmp1161_;
			ValaDataType* _tmp1162_;
			ValaDataType* _tmp1163_;
			gboolean _tmp1164_;
			gboolean _tmp1165_;
			_tmp1160_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1161_ = _tmp1160_;
			_tmp1162_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1163_ = _tmp1162_;
			_tmp1164_ = vala_data_type_get_value_owned (_tmp1163_);
			_tmp1165_ = _tmp1164_;
			vala_data_type_set_value_owned (_tmp1161_, _tmp1165_);
		}
	} else {
		gboolean _tmp1166_ = FALSE;
		gboolean _tmp1187_ = FALSE;
		gboolean _tmp1188_ = FALSE;
		gboolean _tmp1189_ = FALSE;
		gboolean _tmp1190_ = FALSE;
		gboolean _tmp1207_ = FALSE;
		gboolean _tmp1208_ = FALSE;
		gboolean _tmp1209_ = FALSE;
		gboolean _tmp1210_ = FALSE;
		gboolean _tmp1211_ = FALSE;
		gboolean _tmp1212_;
		gboolean _tmp1213_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1240_;
		ValaSymbol* _tmp1241_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1242_;
		ValaExpression* _tmp1243_;
		gboolean _tmp1244_ = FALSE;
		gboolean _tmp1245_ = FALSE;
		gboolean _tmp1246_ = FALSE;
		gboolean _tmp1247_ = FALSE;
		gboolean _tmp1248_ = FALSE;
		ValaMethod* _tmp1249_;
		ValaSemanticAnalyzer* _tmp1286_;
		ValaSemanticAnalyzer* _tmp1287_;
		ValaSymbol* _tmp1288_;
		ValaSymbol* _tmp1289_;
		gboolean _tmp1290_;
		gboolean _tmp1291_;
		ValaDataType* _tmp1292_;
		ValaDataType* _tmp1293_;
		gboolean _tmp1294_ = FALSE;
		ValaExpression* _tmp1295_;
		ValaExpression* _tmp1296_;
		ValaSymbol* _tmp1309_;
		ValaSymbol* _tmp1310_;
		if (instance) {
			ValaExpression* _tmp1167_;
			ValaExpression* _tmp1168_;
			_tmp1167_ = vala_member_access_get_inner (self);
			_tmp1168_ = _tmp1167_;
			_tmp1166_ = _tmp1168_ == NULL;
		} else {
			_tmp1166_ = FALSE;
		}
		if (_tmp1166_) {
			ValaSourceReference* _tmp1169_;
			ValaSourceReference* _tmp1170_;
			ValaMemberAccess* _tmp1171_;
			ValaMemberAccess* _tmp1172_;
			ValaExpression* _tmp1173_;
			ValaExpression* _tmp1174_;
			ValaParameter* _tmp1175_;
			ValaDataType* _tmp1176_;
			ValaDataType* _tmp1177_;
			ValaDataType* _tmp1178_;
			ValaDataType* _tmp1179_;
			ValaExpression* _tmp1180_;
			ValaExpression* _tmp1181_;
			ValaDataType* _tmp1182_;
			ValaDataType* _tmp1183_;
			ValaExpression* _tmp1184_;
			ValaExpression* _tmp1185_;
			ValaParameter* _tmp1186_;
			_tmp1169_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1170_ = _tmp1169_;
			_tmp1171_ = vala_member_access_new (NULL, "this", _tmp1170_);
			_tmp1172_ = _tmp1171_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1172_);
			_vala_code_node_unref0 (_tmp1172_);
			_tmp1173_ = vala_member_access_get_inner (self);
			_tmp1174_ = _tmp1173_;
			_tmp1175_ = this_parameter;
			_tmp1176_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1175_);
			_tmp1177_ = _tmp1176_;
			_tmp1178_ = vala_data_type_copy (_tmp1177_);
			_tmp1179_ = _tmp1178_;
			vala_expression_set_value_type (_tmp1174_, _tmp1179_);
			_vala_code_node_unref0 (_tmp1179_);
			_tmp1180_ = vala_member_access_get_inner (self);
			_tmp1181_ = _tmp1180_;
			_tmp1182_ = vala_expression_get_value_type (_tmp1181_);
			_tmp1183_ = _tmp1182_;
			vala_data_type_set_value_owned (_tmp1183_, FALSE);
			_tmp1184_ = vala_member_access_get_inner (self);
			_tmp1185_ = _tmp1184_;
			_tmp1186_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1185_, (ValaSymbol*) _tmp1186_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1190_ = !klass;
		} else {
			_tmp1190_ = FALSE;
		}
		if (_tmp1190_) {
			ValaSymbol* _tmp1191_;
			ValaSymbol* _tmp1192_;
			_tmp1191_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1192_ = _tmp1191_;
			_tmp1189_ = !VALA_IS_CREATION_METHOD (_tmp1192_);
		} else {
			_tmp1189_ = FALSE;
		}
		if (_tmp1189_) {
			_tmp1188_ = may_access_instance_members;
		} else {
			_tmp1188_ = FALSE;
		}
		if (_tmp1188_) {
			ValaExpression* _tmp1193_;
			ValaExpression* _tmp1194_;
			_tmp1193_ = vala_member_access_get_inner (self);
			_tmp1194_ = _tmp1193_;
			_tmp1187_ = _tmp1194_ != NULL;
		} else {
			_tmp1187_ = FALSE;
		}
		if (_tmp1187_) {
			ValaExpression* _tmp1195_;
			ValaExpression* _tmp1196_;
			ValaSymbol* _tmp1197_;
			ValaSymbol* _tmp1198_;
			_tmp1195_ = vala_member_access_get_inner (self);
			_tmp1196_ = _tmp1195_;
			_tmp1197_ = vala_expression_get_symbol_reference (_tmp1196_);
			_tmp1198_ = _tmp1197_;
			if (VALA_IS_METHOD (_tmp1198_)) {
			} else {
				ValaSourceReference* _tmp1199_;
				ValaSourceReference* _tmp1200_;
				ValaSymbol* _tmp1201_;
				ValaSymbol* _tmp1202_;
				gchar* _tmp1203_;
				gchar* _tmp1204_;
				gchar* _tmp1205_;
				gchar* _tmp1206_;
				_tmp1199_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1200_ = _tmp1199_;
				_tmp1201_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1202_ = _tmp1201_;
				_tmp1203_ = vala_symbol_get_full_name (_tmp1202_);
				_tmp1204_ = _tmp1203_;
				_tmp1205_ = g_strdup_printf ("Access to static member `%s' with an instance reference", _tmp1204_);
				_tmp1206_ = _tmp1205_;
				vala_report_warning (_tmp1200_, _tmp1206_);
				_g_free0 (_tmp1206_);
				_g_free0 (_tmp1204_);
			}
		}
		_tmp1212_ = vala_code_context_get_experimental_non_null (context);
		_tmp1213_ = _tmp1212_;
		if (_tmp1213_) {
			_tmp1211_ = instance;
		} else {
			_tmp1211_ = FALSE;
		}
		if (_tmp1211_) {
			ValaExpression* _tmp1214_;
			ValaExpression* _tmp1215_;
			ValaDataType* _tmp1216_;
			ValaDataType* _tmp1217_;
			gboolean _tmp1218_;
			gboolean _tmp1219_;
			_tmp1214_ = vala_member_access_get_inner (self);
			_tmp1215_ = _tmp1214_;
			_tmp1216_ = vala_expression_get_value_type (_tmp1215_);
			_tmp1217_ = _tmp1216_;
			_tmp1218_ = vala_data_type_get_nullable (_tmp1217_);
			_tmp1219_ = _tmp1218_;
			_tmp1210_ = _tmp1219_;
		} else {
			_tmp1210_ = FALSE;
		}
		if (_tmp1210_) {
			ValaExpression* _tmp1220_;
			ValaExpression* _tmp1221_;
			ValaDataType* _tmp1222_;
			ValaDataType* _tmp1223_;
			_tmp1220_ = vala_member_access_get_inner (self);
			_tmp1221_ = _tmp1220_;
			_tmp1222_ = vala_expression_get_value_type (_tmp1221_);
			_tmp1223_ = _tmp1222_;
			_tmp1209_ = !VALA_IS_POINTER_TYPE (_tmp1223_);
		} else {
			_tmp1209_ = FALSE;
		}
		if (_tmp1209_) {
			ValaExpression* _tmp1224_;
			ValaExpression* _tmp1225_;
			ValaDataType* _tmp1226_;
			ValaDataType* _tmp1227_;
			_tmp1224_ = vala_member_access_get_inner (self);
			_tmp1225_ = _tmp1224_;
			_tmp1226_ = vala_expression_get_value_type (_tmp1225_);
			_tmp1227_ = _tmp1226_;
			_tmp1208_ = !VALA_IS_GENERIC_TYPE (_tmp1227_);
		} else {
			_tmp1208_ = FALSE;
		}
		if (_tmp1208_) {
			ValaExpression* _tmp1228_;
			ValaExpression* _tmp1229_;
			ValaDataType* _tmp1230_;
			ValaDataType* _tmp1231_;
			_tmp1228_ = vala_member_access_get_inner (self);
			_tmp1229_ = _tmp1228_;
			_tmp1230_ = vala_expression_get_value_type (_tmp1229_);
			_tmp1231_ = _tmp1230_;
			_tmp1207_ = !VALA_IS_ARRAY_TYPE (_tmp1231_);
		} else {
			_tmp1207_ = FALSE;
		}
		if (_tmp1207_) {
			ValaSourceReference* _tmp1232_;
			ValaSourceReference* _tmp1233_;
			ValaSymbol* _tmp1234_;
			ValaSymbol* _tmp1235_;
			gchar* _tmp1236_;
			gchar* _tmp1237_;
			gchar* _tmp1238_;
			gchar* _tmp1239_;
			_tmp1232_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1233_ = _tmp1232_;
			_tmp1234_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1235_ = _tmp1234_;
			_tmp1236_ = vala_symbol_get_full_name (_tmp1235_);
			_tmp1237_ = _tmp1236_;
			_tmp1238_ = g_strdup_printf ("Access to instance member `%s' from nullable reference denied", _tmp1237_);
			_tmp1239_ = _tmp1238_;
			vala_report_error (_tmp1233_, _tmp1239_);
			_g_free0 (_tmp1239_);
			_g_free0 (_tmp1237_);
		}
		_tmp1240_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1241_ = _tmp1240_;
		m = VALA_IS_METHOD (_tmp1241_) ? ((ValaMethod*) _tmp1241_) : NULL;
		_tmp1242_ = vala_member_access_get_inner (self);
		_tmp1243_ = _tmp1242_;
		inner_ma = VALA_IS_MEMBER_ACCESS (_tmp1243_) ? ((ValaMemberAccess*) _tmp1243_) : NULL;
		_tmp1249_ = m;
		if (_tmp1249_ != NULL) {
			ValaMethod* _tmp1250_;
			ValaMemberBinding _tmp1251_;
			ValaMemberBinding _tmp1252_;
			_tmp1250_ = m;
			_tmp1251_ = vala_method_get_binding (_tmp1250_);
			_tmp1252_ = _tmp1251_;
			_tmp1248_ = _tmp1252_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1248_ = FALSE;
		}
		if (_tmp1248_) {
			ValaMethod* _tmp1253_;
			ValaSymbol* _tmp1254_;
			ValaSymbol* _tmp1255_;
			_tmp1253_ = m;
			_tmp1254_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1253_);
			_tmp1255_ = _tmp1254_;
			_tmp1247_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1255_);
		} else {
			_tmp1247_ = FALSE;
		}
		if (_tmp1247_) {
			ValaExpression* _tmp1256_;
			ValaExpression* _tmp1257_;
			_tmp1256_ = vala_member_access_get_inner (self);
			_tmp1257_ = _tmp1256_;
			_tmp1246_ = _tmp1257_ != NULL;
		} else {
			_tmp1246_ = FALSE;
		}
		if (_tmp1246_) {
			ValaExpression* _tmp1258_;
			ValaExpression* _tmp1259_;
			ValaDataType* _tmp1260_;
			ValaDataType* _tmp1261_;
			_tmp1258_ = vala_member_access_get_inner (self);
			_tmp1259_ = _tmp1258_;
			_tmp1260_ = vala_expression_get_value_type (_tmp1259_);
			_tmp1261_ = _tmp1260_;
			_tmp1245_ = _tmp1261_ == NULL;
		} else {
			_tmp1245_ = FALSE;
		}
		if (_tmp1245_) {
			ValaMemberAccess* _tmp1262_;
			ValaList* _tmp1263_;
			gint _tmp1264_;
			gint _tmp1265_;
			_tmp1262_ = inner_ma;
			_tmp1263_ = _tmp1262_->priv->type_argument_list;
			_tmp1264_ = vala_collection_get_size ((ValaCollection*) _tmp1263_);
			_tmp1265_ = _tmp1264_;
			_tmp1244_ = _tmp1265_ > 0;
		} else {
			_tmp1244_ = FALSE;
		}
		if (_tmp1244_) {
			ValaExpression* _tmp1266_;
			ValaExpression* _tmp1267_;
			ValaMethod* _tmp1268_;
			ValaSymbol* _tmp1269_;
			ValaSymbol* _tmp1270_;
			ValaObjectType* _tmp1271_;
			ValaObjectType* _tmp1272_;
			_tmp1266_ = vala_member_access_get_inner (self);
			_tmp1267_ = _tmp1266_;
			_tmp1268_ = m;
			_tmp1269_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1268_);
			_tmp1270_ = _tmp1269_;
			_tmp1271_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1270_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1272_ = _tmp1271_;
			vala_expression_set_value_type (_tmp1267_, (ValaDataType*) _tmp1272_);
			_vala_code_node_unref0 (_tmp1272_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1273_;
				ValaList* _tmp1274_;
				ValaList* _tmp1275_;
				gint _type_argument_size = 0;
				ValaList* _tmp1276_;
				gint _tmp1277_;
				gint _tmp1278_;
				gint _type_argument_index = 0;
				_tmp1273_ = inner_ma;
				_tmp1274_ = _tmp1273_->priv->type_argument_list;
				_tmp1275_ = _vala_iterable_ref0 (_tmp1274_);
				_type_argument_list = _tmp1275_;
				_tmp1276_ = _type_argument_list;
				_tmp1277_ = vala_collection_get_size ((ValaCollection*) _tmp1276_);
				_tmp1278_ = _tmp1277_;
				_type_argument_size = _tmp1278_;
				_type_argument_index = -1;
				while (TRUE) {
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1279_;
					gpointer _tmp1280_;
					ValaExpression* _tmp1281_;
					ValaExpression* _tmp1282_;
					ValaDataType* _tmp1283_;
					ValaDataType* _tmp1284_;
					ValaDataType* _tmp1285_;
					_type_argument_index = _type_argument_index + 1;
					if (!(_type_argument_index < _type_argument_size)) {
						break;
					}
					_tmp1279_ = _type_argument_list;
					_tmp1280_ = vala_list_get (_tmp1279_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1280_;
					_tmp1281_ = vala_member_access_get_inner (self);
					_tmp1282_ = _tmp1281_;
					_tmp1283_ = vala_expression_get_value_type (_tmp1282_);
					_tmp1284_ = _tmp1283_;
					_tmp1285_ = type_argument;
					vala_data_type_add_type_argument (_tmp1284_, _tmp1285_);
					_vala_code_node_unref0 (type_argument);
				}
				_vala_iterable_unref0 (_type_argument_list);
			}
		}
		_tmp1286_ = vala_code_context_get_analyzer (context);
		_tmp1287_ = _tmp1286_;
		_tmp1288_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1289_ = _tmp1288_;
		_tmp1290_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1291_ = _tmp1290_;
		_tmp1292_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1287_, _tmp1289_, _tmp1291_);
		_tmp1293_ = _tmp1292_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1293_);
		_vala_code_node_unref0 (_tmp1293_);
		_tmp1295_ = vala_member_access_get_inner (self);
		_tmp1296_ = _tmp1295_;
		if (_tmp1296_ != NULL) {
			ValaDataType* _tmp1297_;
			ValaDataType* _tmp1298_;
			_tmp1297_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1298_ = _tmp1297_;
			_tmp1294_ = _tmp1298_ != NULL;
		} else {
			_tmp1294_ = FALSE;
		}
		if (_tmp1294_) {
			ValaDataType* _tmp1299_;
			ValaDataType* _tmp1300_;
			ValaExpression* _tmp1301_;
			ValaExpression* _tmp1302_;
			ValaDataType* _tmp1303_;
			ValaDataType* _tmp1304_;
			ValaDataType* _tmp1305_;
			ValaDataType* _tmp1306_;
			_tmp1299_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1300_ = _tmp1299_;
			_tmp1301_ = vala_member_access_get_inner (self);
			_tmp1302_ = _tmp1301_;
			_tmp1303_ = vala_expression_get_value_type (_tmp1302_);
			_tmp1304_ = _tmp1303_;
			_tmp1305_ = vala_data_type_get_actual_type (_tmp1300_, _tmp1304_, NULL, (ValaCodeNode*) self);
			_tmp1306_ = _tmp1305_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1306_);
			_vala_code_node_unref0 (_tmp1306_);
		} else {
			ValaDataType* _tmp1307_;
			ValaDataType* _tmp1308_;
			_tmp1307_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1308_ = _tmp1307_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1308_);
		}
		_tmp1309_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1310_ = _tmp1309_;
		if (VALA_IS_METHOD (_tmp1310_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1311_;
			ValaSymbol* _tmp1312_;
			ValaDataType* _tmp1313_;
			ValaDataType* _tmp1314_;
			gboolean _tmp1321_ = FALSE;
			_tmp1311_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1312_ = _tmp1311_;
			method = G_TYPE_CHECK_INSTANCE_CAST (_tmp1312_, VALA_TYPE_METHOD, ValaMethod);
			_tmp1313_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1314_ = _tmp1313_;
			if (_tmp1314_ != NULL) {
				ValaDataType* _tmp1315_;
				ValaDataType* _tmp1316_;
				ValaDataType* _tmp1317_;
				ValaDataType* _tmp1318_;
				gboolean _tmp1319_;
				gboolean _tmp1320_;
				_tmp1315_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1316_ = _tmp1315_;
				_tmp1317_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1318_ = _tmp1317_;
				_tmp1319_ = vala_data_type_get_value_owned (_tmp1318_);
				_tmp1320_ = _tmp1319_;
				vala_data_type_set_value_owned (_tmp1316_, _tmp1320_);
			}
			if (instance) {
				ValaMethod* _tmp1322_;
				ValaSymbol* _tmp1323_;
				ValaSymbol* _tmp1324_;
				_tmp1322_ = method;
				_tmp1323_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1322_);
				_tmp1324_ = _tmp1323_;
				_tmp1321_ = VALA_IS_TYPESYMBOL (_tmp1324_);
			} else {
				_tmp1321_ = FALSE;
			}
			if (_tmp1321_) {
				ValaExpression* _tmp1325_;
				ValaExpression* _tmp1326_;
				ValaMethod* _tmp1327_;
				ValaSymbol* _tmp1328_;
				ValaSymbol* _tmp1329_;
				ValaDataType* _tmp1330_;
				ValaDataType* _tmp1331_;
				ValaExpression* _tmp1332_;
				ValaExpression* _tmp1333_;
				ValaDataType* _tmp1334_;
				ValaDataType* _tmp1335_;
				ValaMethod* _tmp1336_;
				ValaParameter* _tmp1337_;
				ValaParameter* _tmp1338_;
				ValaDataType* _tmp1339_;
				ValaDataType* _tmp1340_;
				gboolean _tmp1341_;
				gboolean _tmp1342_;
				_tmp1325_ = vala_member_access_get_inner (self);
				_tmp1326_ = _tmp1325_;
				_tmp1327_ = method;
				_tmp1328_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1327_);
				_tmp1329_ = _tmp1328_;
				_tmp1330_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1329_);
				_tmp1331_ = _tmp1330_;
				vala_expression_set_target_type (_tmp1326_, _tmp1331_);
				_vala_code_node_unref0 (_tmp1331_);
				_tmp1332_ = vala_member_access_get_inner (self);
				_tmp1333_ = _tmp1332_;
				_tmp1334_ = vala_expression_get_target_type (_tmp1333_);
				_tmp1335_ = _tmp1334_;
				_tmp1336_ = method;
				_tmp1337_ = vala_method_get_this_parameter (_tmp1336_);
				_tmp1338_ = _tmp1337_;
				_tmp1339_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1338_);
				_tmp1340_ = _tmp1339_;
				_tmp1341_ = vala_data_type_get_value_owned (_tmp1340_);
				_tmp1342_ = _tmp1341_;
				vala_data_type_set_value_owned (_tmp1335_, _tmp1342_);
			}
		} else {
			gboolean _tmp1343_ = FALSE;
			gboolean _tmp1344_ = FALSE;
			ValaSymbol* _tmp1345_;
			ValaSymbol* _tmp1346_;
			_tmp1345_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1346_ = _tmp1345_;
			if (VALA_IS_PROPERTY (_tmp1346_)) {
				_tmp1344_ = instance;
			} else {
				_tmp1344_ = FALSE;
			}
			if (_tmp1344_) {
				ValaSymbol* _tmp1347_;
				ValaSymbol* _tmp1348_;
				ValaSymbol* _tmp1349_;
				ValaSymbol* _tmp1350_;
				_tmp1347_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1348_ = _tmp1347_;
				_tmp1349_ = vala_symbol_get_parent_symbol (_tmp1348_);
				_tmp1350_ = _tmp1349_;
				_tmp1343_ = _tmp1350_ != NULL;
			} else {
				_tmp1343_ = FALSE;
			}
			if (_tmp1343_) {
				ValaExpression* _tmp1351_;
				ValaExpression* _tmp1352_;
				ValaSymbol* _tmp1353_;
				ValaSymbol* _tmp1354_;
				ValaSymbol* _tmp1355_;
				ValaSymbol* _tmp1356_;
				ValaDataType* _tmp1357_;
				ValaDataType* _tmp1358_;
				_tmp1351_ = vala_member_access_get_inner (self);
				_tmp1352_ = _tmp1351_;
				_tmp1353_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1354_ = _tmp1353_;
				_tmp1355_ = vala_symbol_get_parent_symbol (_tmp1354_);
				_tmp1356_ = _tmp1355_;
				_tmp1357_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1356_);
				_tmp1358_ = _tmp1357_;
				vala_expression_set_target_type (_tmp1352_, _tmp1358_);
				_vala_code_node_unref0 (_tmp1358_);
			} else {
				gboolean _tmp1359_ = FALSE;
				gboolean _tmp1360_ = FALSE;
				gboolean _tmp1361_ = FALSE;
				ValaSymbol* _tmp1362_;
				ValaSymbol* _tmp1363_;
				_tmp1362_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1363_ = _tmp1362_;
				if (VALA_IS_FIELD (_tmp1363_)) {
					_tmp1361_ = TRUE;
				} else {
					ValaSymbol* _tmp1364_;
					ValaSymbol* _tmp1365_;
					_tmp1364_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1365_ = _tmp1364_;
					_tmp1361_ = VALA_IS_SIGNAL (_tmp1365_);
				}
				if (_tmp1361_) {
					_tmp1360_ = instance;
				} else {
					_tmp1360_ = FALSE;
				}
				if (_tmp1360_) {
					ValaSymbol* _tmp1366_;
					ValaSymbol* _tmp1367_;
					ValaSymbol* _tmp1368_;
					ValaSymbol* _tmp1369_;
					_tmp1366_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1367_ = _tmp1366_;
					_tmp1368_ = vala_symbol_get_parent_symbol (_tmp1367_);
					_tmp1369_ = _tmp1368_;
					_tmp1359_ = _tmp1369_ != NULL;
				} else {
					_tmp1359_ = FALSE;
				}
				if (_tmp1359_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1370_;
					ValaSymbol* _tmp1371_;
					ValaSymbol* _tmp1372_;
					ValaSymbol* _tmp1373_;
					ValaDataType* _tmp1374_;
					ValaExpression* _tmp1375_;
					ValaExpression* _tmp1376_;
					ValaDataType* _tmp1377_;
					ValaExpression* _tmp1378_;
					ValaExpression* _tmp1379_;
					ValaDataType* _tmp1380_;
					ValaDataType* _tmp1381_;
					ValaDataType* _tmp1382_;
					ValaDataType* _tmp1383_;
					_tmp1370_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1371_ = _tmp1370_;
					_tmp1372_ = vala_symbol_get_parent_symbol (_tmp1371_);
					_tmp1373_ = _tmp1372_;
					_tmp1374_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1373_);
					parent_type = _tmp1374_;
					_tmp1375_ = vala_member_access_get_inner (self);
					_tmp1376_ = _tmp1375_;
					_tmp1377_ = parent_type;
					_tmp1378_ = vala_member_access_get_inner (self);
					_tmp1379_ = _tmp1378_;
					_tmp1380_ = vala_expression_get_value_type (_tmp1379_);
					_tmp1381_ = _tmp1380_;
					_tmp1382_ = vala_data_type_get_actual_type (_tmp1377_, _tmp1381_, NULL, (ValaCodeNode*) self);
					_tmp1383_ = _tmp1382_;
					vala_expression_set_target_type (_tmp1376_, _tmp1383_);
					_vala_code_node_unref0 (_tmp1383_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
	}
	_tmp1384_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1385_ = _tmp1384_;
	if (_tmp1385_ != NULL) {
		ValaDataType* _tmp1386_;
		ValaDataType* _tmp1387_;
		_tmp1386_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp1387_ = _tmp1386_;
		vala_code_node_check ((ValaCodeNode*) _tmp1387_, context);
	}
	_tmp1388_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1389_ = _tmp1388_;
	result = !_tmp1389_;
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp50_;
	ValaExpression* _tmp51_;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	ValaMemberAccess* _tmp54_;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp83_ = FALSE;
	ValaSymbol* _tmp84_;
	ValaSymbol* _tmp85_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_METHOD (_tmp11_)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (VALA_IS_PROPERTY (_tmp18_)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (VALA_IS_PARAMETER (_tmp27_)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp39_)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		ValaExpression* _tmp46_;
		ValaExpression* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		_tmp46_ = vala_member_access_get_inner (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_get_value_type (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp34_ = VALA_IS_ARRAY_TYPE (_tmp49_);
	}
	struct_or_array = _tmp34_;
	_tmp50_ = vala_member_access_get_inner (self);
	_tmp51_ = _tmp50_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL;
	_tmp54_ = ma;
	if (_tmp54_ == NULL) {
		_tmp53_ = struct_or_array;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		_tmp55_ = vala_member_access_get_inner (self);
		_tmp56_ = _tmp55_;
		_tmp52_ = VALA_IS_POINTER_INDIRECTION (_tmp56_);
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		ValaExpression* _tmp57_;
		ValaExpression* _tmp58_;
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		_tmp57_ = vala_member_access_get_inner (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp60_ = _tmp59_;
		ma = VALA_IS_MEMBER_ACCESS (_tmp60_) ? ((ValaMemberAccess*) _tmp60_) : NULL;
	}
	if (instance) {
		_tmp64_ = struct_or_array;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		gboolean _tmp65_ = FALSE;
		ValaSymbol* _tmp66_;
		ValaSymbol* _tmp67_;
		_tmp66_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp67_ = _tmp66_;
		if (VALA_IS_METHOD (_tmp67_)) {
			_tmp65_ = TRUE;
		} else {
			gboolean _tmp68_;
			gboolean _tmp69_;
			_tmp68_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp69_ = _tmp68_;
			_tmp65_ = _tmp69_;
		}
		_tmp63_ = _tmp65_;
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		gboolean _tmp70_ = FALSE;
		gboolean _tmp71_ = FALSE;
		ValaMemberAccess* _tmp72_;
		_tmp72_ = ma;
		if (_tmp72_ != NULL) {
			ValaMemberAccess* _tmp73_;
			ValaSymbol* _tmp74_;
			ValaSymbol* _tmp75_;
			_tmp73_ = ma;
			_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp71_ = VALA_IS_VARIABLE (_tmp75_);
		} else {
			_tmp71_ = FALSE;
		}
		if (_tmp71_) {
			_tmp70_ = TRUE;
		} else {
			ValaExpression* _tmp76_;
			ValaExpression* _tmp77_;
			_tmp76_ = vala_member_access_get_inner (self);
			_tmp77_ = _tmp76_;
			_tmp70_ = VALA_IS_ELEMENT_ACCESS (_tmp77_);
		}
		_tmp62_ = _tmp70_;
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		_tmp61_ = !this_access;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		ValaExpression* _tmp78_;
		ValaExpression* _tmp79_;
		ValaMemberAccess* _tmp80_;
		_tmp78_ = vala_member_access_get_inner (self);
		_tmp79_ = _tmp78_;
		vala_expression_set_lvalue (_tmp79_, TRUE);
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaMemberAccess* _tmp82_;
			_tmp81_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp81_, TRUE);
			_tmp82_ = ma;
			vala_member_access_check_lvalue_access (_tmp82_);
		}
	}
	_tmp84_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp85_ = _tmp84_;
	if (VALA_IS_METHOD (_tmp85_)) {
		ValaSymbol* _tmp86_;
		ValaSymbol* _tmp87_;
		ValaAttribute* _tmp88_;
		_tmp86_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp87_ = _tmp86_;
		_tmp88_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp83_ = _tmp88_ != NULL;
	} else {
		_tmp83_ = FALSE;
	}
	if (_tmp83_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp89_;
		ValaSymbol* _tmp90_;
		ValaSymbol* _tmp91_;
		ValaSymbol* _tmp92_;
		gboolean _tmp93_ = FALSE;
		gboolean _tmp94_ = FALSE;
		ValaClass* _tmp95_;
		_tmp89_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_METHOD, ValaMethod));
		_tmp92_ = _tmp91_;
		cl = VALA_IS_CLASS (_tmp92_) ? ((ValaClass*) _tmp92_) : NULL;
		_tmp95_ = cl;
		if (_tmp95_ != NULL) {
			ValaClass* _tmp96_;
			gboolean _tmp97_;
			gboolean _tmp98_;
			_tmp96_ = cl;
			_tmp97_ = vala_class_get_is_compact (_tmp96_);
			_tmp98_ = _tmp97_;
			_tmp94_ = _tmp98_;
		} else {
			_tmp94_ = FALSE;
		}
		if (_tmp94_) {
			ValaMemberAccess* _tmp99_;
			_tmp99_ = ma;
			_tmp93_ = _tmp99_ != NULL;
		} else {
			_tmp93_ = FALSE;
		}
		if (_tmp93_) {
			ValaMemberAccess* _tmp100_;
			ValaMemberAccess* _tmp101_;
			_tmp100_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp100_, TRUE);
			_tmp101_ = ma;
			vala_member_access_check_lvalue_access (_tmp101_);
		}
	}
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL;
	_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp7_ = _tmp6_;
	param = VALA_IS_PARAMETER (_tmp7_) ? ((ValaParameter*) _tmp7_) : NULL;
	_tmp8_ = local;
	if (_tmp8_ != NULL) {
		ValaLocalVariable* _tmp9_;
		_tmp9_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp9_);
	} else {
		gboolean _tmp10_ = FALSE;
		ValaParameter* _tmp11_;
		_tmp11_ = param;
		if (_tmp11_ != NULL) {
			ValaParameter* _tmp12_;
			ValaParameterDirection _tmp13_;
			ValaParameterDirection _tmp14_;
			_tmp12_ = param;
			_tmp13_ = vala_parameter_get_direction (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp10_ = _tmp14_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			ValaParameter* _tmp15_;
			_tmp15_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp15_);
		}
	}
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass,
                               gpointer klass_data)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
static GType
vala_member_access_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
	GType vala_member_access_type_id;
	vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
	ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
	return vala_member_access_type_id;
}

GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		GType vala_member_access_type_id;
		vala_member_access_type_id = vala_member_access_get_type_once ();
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}

