/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	ValaList* type_argument_list;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static void vala_member_access_finalize (ValaCodeNode * obj);
static GType vala_member_access_get_type_once (void);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}

void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, NULL);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the list of generic type arguments.
 *
 * @return type argument list
 */
ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _type_arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_type_arg_list = _tmp5_;
		_tmp6_ = _type_arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_type_arg_size = _tmp8_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp9_;
			gpointer _tmp10_;
			ValaDataType* _tmp11_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp9_ = _type_arg_list;
			_tmp10_ = vala_list_get (_tmp9_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp10_;
			_tmp11_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	gchar* result = NULL;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	method = VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL;
	_tmp2_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp3_ = _tmp2_;
	if (VALA_IS_CONSTANT (_tmp3_)) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp7_)) {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_member_access_get_inner (self);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			ValaExpression* _tmp10_;
			ValaExpression* _tmp11_;
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			_tmp10_ = vala_member_access_get_inner (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_expression_get_symbol_reference (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp4_ = VALA_IS_CONSTANT (_tmp13_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp14_ = FALSE;
			ValaMethod* _tmp15_;
			_tmp15_ = method;
			if (_tmp15_ != NULL) {
				gboolean _tmp16_ = FALSE;
				ValaMethod* _tmp17_;
				ValaMemberBinding _tmp18_;
				ValaMemberBinding _tmp19_;
				_tmp17_ = method;
				_tmp18_ = vala_method_get_binding (_tmp17_);
				_tmp19_ = _tmp18_;
				if (_tmp19_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp16_ = TRUE;
				} else {
					gboolean _tmp20_;
					_tmp20_ = self->priv->_prototype_access;
					_tmp16_ = _tmp20_;
				}
				_tmp14_ = _tmp16_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				result = TRUE;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	c = VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL;
	_tmp2_ = c;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		ValaConstant* _tmp4_;
		_tmp4_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp4_)) {
			_tmp3_ = TRUE;
		} else {
			ValaConstant* _tmp5_;
			ValaDataType* _tmp6_;
			ValaDataType* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp5_ = c;
			_tmp6_ = vala_constant_get_type_reference (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = vala_data_type_get_nullable (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp3_ = !_tmp9_;
		}
		result = _tmp3_;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	ValaArrayList* visited_types = NULL;
	GEqualFunc _tmp16_;
	ValaArrayList* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp638_ = FALSE;
	gboolean _tmp639_ = FALSE;
	gboolean _tmp640_ = FALSE;
	ValaExpression* _tmp641_;
	ValaExpression* _tmp642_;
	ValaSymbol* _tmp668_;
	ValaSymbol* _tmp669_;
	ValaSymbol* _tmp739_;
	ValaSymbol* _tmp740_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp778_;
	ValaSymbol* _tmp779_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp780_;
	ValaSymbol* _tmp781_;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp1168_;
	ValaSymbol* _tmp1169_;
	ValaSymbol* _tmp1171_;
	ValaVersionAttribute* _tmp1172_;
	ValaVersionAttribute* _tmp1173_;
	ValaSourceReference* _tmp1174_;
	ValaSourceReference* _tmp1175_;
	gboolean _tmp1176_ = FALSE;
	ValaSymbolAccessibility _tmp1177_;
	gboolean _tmp1233_ = FALSE;
	gboolean _tmp1260_ = FALSE;
	gboolean _tmp1261_ = FALSE;
	ValaDataType* _tmp1538_;
	ValaDataType* _tmp1539_;
	gboolean _tmp1542_;
	gboolean _tmp1543_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_member_access_get_inner (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_member_access_get_inner (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _type_arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _type_arg_index = 0;
		_tmp8_ = self->priv->type_argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_type_arg_list = _tmp9_;
		_tmp10_ = _type_arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_type_arg_size = _tmp12_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp13_;
			gpointer _tmp14_;
			ValaDataType* _tmp15_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp13_ = _type_arg_list;
			_tmp14_ = vala_list_get (_tmp13_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp14_;
			_tmp15_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp15_, context);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	_tmp16_ = g_direct_equal;
	_tmp17_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp16_);
	visited_types = _tmp17_;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp18_ = self->priv->_qualified;
	if (_tmp18_) {
		ValaNamespace* _tmp19_;
		ValaNamespace* _tmp20_;
		ValaSymbol* _tmp21_;
		ValaScope* _tmp22_;
		ValaScope* _tmp23_;
		const gchar* _tmp24_;
		ValaSymbol* _tmp25_;
		ValaSymbol* _tmp26_;
		_tmp19_ = vala_code_context_get_root (context);
		_tmp20_ = _tmp19_;
		base_symbol = (ValaSymbol*) _tmp20_;
		_tmp21_ = base_symbol;
		_tmp22_ = vala_symbol_get_scope (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = self->priv->_member_name;
		_tmp25_ = vala_scope_lookup (_tmp23_, _tmp24_);
		_tmp26_ = _tmp25_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp26_);
		_vala_code_node_unref0 (_tmp26_);
	} else {
		ValaExpression* _tmp27_;
		ValaExpression* _tmp28_;
		_tmp27_ = vala_member_access_get_inner (self);
		_tmp28_ = _tmp27_;
		if (_tmp28_ == NULL) {
			const gchar* _tmp29_;
			ValaSemanticAnalyzer* _tmp34_;
			ValaSemanticAnalyzer* _tmp35_;
			ValaSymbol* _tmp36_;
			ValaSymbol* _tmp37_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp38_;
			ValaSemanticAnalyzer* _tmp39_;
			ValaSymbol* _tmp40_;
			ValaSymbol* _tmp41_;
			gboolean _tmp175_ = FALSE;
			ValaSymbol* _tmp176_;
			ValaSymbol* _tmp177_;
			_tmp29_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp29_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp30_;
				ValaSemanticAnalyzer* _tmp31_;
				_tmp30_ = vala_code_context_get_analyzer (context);
				_tmp31_ = _tmp30_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp31_)) {
					ValaSourceReference* _tmp32_;
					ValaSourceReference* _tmp33_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp33_ = _tmp32_;
					vala_report_error (_tmp33_, "This access invalid outside of instance methods");
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
			}
			_tmp34_ = vala_code_context_get_analyzer (context);
			_tmp35_ = _tmp34_;
			_tmp36_ = vala_semantic_analyzer_get_current_symbol (_tmp35_);
			_tmp37_ = _tmp36_;
			base_symbol = _tmp37_;
			method_found = FALSE;
			_tmp38_ = vala_code_context_get_analyzer (context);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_semantic_analyzer_get_current_symbol (_tmp39_);
			_tmp41_ = _tmp40_;
			sym = _tmp41_;
			while (TRUE) {
				gboolean _tmp42_ = FALSE;
				ValaSymbol* _tmp43_;
				ValaSymbol* _tmp89_;
				const gchar* _tmp90_;
				ValaSymbol* _tmp91_;
				ValaSymbol* _tmp92_;
				gboolean _tmp93_ = FALSE;
				ValaSymbol* _tmp94_;
				ValaSymbol* _tmp95_;
				gboolean _tmp128_ = FALSE;
				gboolean _tmp129_ = FALSE;
				ValaSymbol* _tmp130_;
				ValaSymbol* _tmp131_;
				ValaSymbol* _tmp169_;
				ValaSymbol* _tmp170_;
				ValaSymbol* _tmp172_;
				ValaSymbol* _tmp173_;
				ValaSymbol* _tmp174_;
				_tmp43_ = sym;
				if (_tmp43_ != NULL) {
					ValaSymbol* _tmp44_;
					ValaSymbol* _tmp45_;
					_tmp44_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp45_ = _tmp44_;
					_tmp42_ = _tmp45_ == NULL;
				} else {
					_tmp42_ = FALSE;
				}
				if (!_tmp42_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp46_;
					_tmp46_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp46_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp47_;
						ValaCreationMethod* _tmp48_;
						ValaParameter* _tmp49_;
						ValaParameter* _tmp50_;
						_tmp47_ = sym;
						cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
						_tmp48_ = cm;
						_tmp49_ = vala_method_get_this_parameter ((ValaMethod*) _tmp48_);
						_tmp50_ = _tmp49_;
						this_parameter = _tmp50_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
					} else {
						ValaSymbol* _tmp51_;
						_tmp51_ = sym;
						if (VALA_IS_PROPERTY (_tmp51_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp52_;
							ValaProperty* _tmp53_;
							ValaParameter* _tmp54_;
							ValaParameter* _tmp55_;
							ValaProperty* _tmp56_;
							ValaMemberBinding _tmp57_;
							ValaMemberBinding _tmp58_;
							ValaProperty* _tmp59_;
							ValaMemberBinding _tmp60_;
							ValaMemberBinding _tmp61_;
							_tmp52_ = sym;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp53_ = prop;
							_tmp54_ = vala_property_get_this_parameter (_tmp53_);
							_tmp55_ = _tmp54_;
							this_parameter = _tmp55_;
							_tmp56_ = prop;
							_tmp57_ = vala_property_get_binding (_tmp56_);
							_tmp58_ = _tmp57_;
							may_access_instance_members = _tmp58_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp59_ = prop;
							_tmp60_ = vala_property_get_binding (_tmp59_);
							_tmp61_ = _tmp60_;
							may_access_klass_members = _tmp61_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
						} else {
							ValaSymbol* _tmp62_;
							_tmp62_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp62_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp63_;
								ValaConstructor* _tmp64_;
								ValaParameter* _tmp65_;
								ValaParameter* _tmp66_;
								ValaConstructor* _tmp67_;
								ValaMemberBinding _tmp68_;
								ValaMemberBinding _tmp69_;
								_tmp63_ = sym;
								c = G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, VALA_TYPE_CONSTRUCTOR, ValaConstructor);
								_tmp64_ = c;
								_tmp65_ = vala_constructor_get_this_parameter (_tmp64_);
								_tmp66_ = _tmp65_;
								this_parameter = _tmp66_;
								_tmp67_ = c;
								_tmp68_ = vala_constructor_get_binding (_tmp67_);
								_tmp69_ = _tmp68_;
								may_access_instance_members = _tmp69_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
							} else {
								ValaSymbol* _tmp70_;
								_tmp70_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp70_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp71_;
									ValaDestructor* _tmp72_;
									ValaParameter* _tmp73_;
									ValaParameter* _tmp74_;
									ValaDestructor* _tmp75_;
									ValaMemberBinding _tmp76_;
									ValaMemberBinding _tmp77_;
									_tmp71_ = sym;
									d = G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, VALA_TYPE_DESTRUCTOR, ValaDestructor);
									_tmp72_ = d;
									_tmp73_ = vala_destructor_get_this_parameter (_tmp72_);
									_tmp74_ = _tmp73_;
									this_parameter = _tmp74_;
									_tmp75_ = d;
									_tmp76_ = vala_destructor_get_binding (_tmp75_);
									_tmp77_ = _tmp76_;
									may_access_instance_members = _tmp77_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
								} else {
									ValaSymbol* _tmp78_;
									_tmp78_ = sym;
									if (VALA_IS_METHOD (_tmp78_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp79_;
										ValaMethod* _tmp80_;
										ValaParameter* _tmp81_;
										ValaParameter* _tmp82_;
										ValaMethod* _tmp83_;
										ValaMemberBinding _tmp84_;
										ValaMemberBinding _tmp85_;
										ValaMethod* _tmp86_;
										ValaMemberBinding _tmp87_;
										ValaMemberBinding _tmp88_;
										_tmp79_ = sym;
										m = G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, VALA_TYPE_METHOD, ValaMethod);
										_tmp80_ = m;
										_tmp81_ = vala_method_get_this_parameter (_tmp80_);
										_tmp82_ = _tmp81_;
										this_parameter = _tmp82_;
										_tmp83_ = m;
										_tmp84_ = vala_method_get_binding (_tmp83_);
										_tmp85_ = _tmp84_;
										may_access_instance_members = _tmp85_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp86_ = m;
										_tmp87_ = vala_method_get_binding (_tmp86_);
										_tmp88_ = _tmp87_;
										may_access_klass_members = _tmp88_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
									}
								}
							}
						}
					}
				}
				_tmp89_ = sym;
				_tmp90_ = self->priv->_member_name;
				_tmp91_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp89_, _tmp90_);
				_tmp92_ = _tmp91_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp92_);
				_vala_code_node_unref0 (_tmp92_);
				_tmp94_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp95_ = _tmp94_;
				if (_tmp95_ == NULL) {
					ValaSymbol* _tmp96_;
					_tmp96_ = sym;
					_tmp93_ = VALA_IS_WITH_STATEMENT (_tmp96_);
				} else {
					_tmp93_ = FALSE;
				}
				if (_tmp93_) {
					ValaWithStatement* w = NULL;
					ValaSymbol* _tmp97_;
					ValaDataType* variable_type = NULL;
					ValaWithStatement* _tmp98_;
					ValaLocalVariable* _tmp99_;
					ValaLocalVariable* _tmp100_;
					ValaDataType* _tmp101_;
					ValaDataType* _tmp102_;
					ValaDataType* _tmp103_;
					ValaDataType* _tmp104_;
					ValaArrayList* _tmp109_;
					ValaDataType* _tmp110_;
					ValaDataType* _tmp111_;
					const gchar* _tmp112_;
					ValaSymbol* _tmp113_;
					ValaSymbol* _tmp114_;
					ValaSymbol* _tmp115_;
					ValaSymbol* _tmp116_;
					_tmp97_ = sym;
					w = G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, VALA_TYPE_WITH_STATEMENT, ValaWithStatement);
					_tmp98_ = w;
					_tmp99_ = vala_with_statement_get_with_variable (_tmp98_);
					_tmp100_ = _tmp99_;
					_tmp101_ = vala_variable_get_variable_type ((ValaVariable*) _tmp100_);
					_tmp102_ = _tmp101_;
					_tmp103_ = _vala_code_node_ref0 (_tmp102_);
					variable_type = _tmp103_;
					_tmp104_ = variable_type;
					if (VALA_IS_POINTER_TYPE (_tmp104_)) {
						ValaDataType* _tmp105_;
						ValaDataType* _tmp106_;
						ValaDataType* _tmp107_;
						ValaDataType* _tmp108_;
						_tmp105_ = variable_type;
						_tmp106_ = vala_pointer_type_get_base_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp105_, VALA_TYPE_POINTER_TYPE, ValaPointerType));
						_tmp107_ = _tmp106_;
						_tmp108_ = _vala_code_node_ref0 (_tmp107_);
						_vala_code_node_unref0 (variable_type);
						variable_type = _tmp108_;
					}
					_tmp109_ = visited_types;
					_tmp110_ = variable_type;
					vala_collection_add ((ValaCollection*) _tmp109_, _tmp110_);
					_tmp111_ = variable_type;
					_tmp112_ = self->priv->_member_name;
					_tmp113_ = vala_data_type_get_member (_tmp111_, _tmp112_);
					_tmp114_ = _tmp113_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp114_);
					_vala_code_node_unref0 (_tmp114_);
					_tmp115_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp116_ = _tmp115_;
					if (_tmp116_ != NULL) {
						ValaWithStatement* _tmp117_;
						ValaLocalVariable* _tmp118_;
						ValaLocalVariable* _tmp119_;
						const gchar* _tmp120_;
						const gchar* _tmp121_;
						ValaSourceReference* _tmp122_;
						ValaSourceReference* _tmp123_;
						ValaMemberAccess* _tmp124_;
						ValaMemberAccess* _tmp125_;
						ValaExpression* _tmp126_;
						ValaExpression* _tmp127_;
						_tmp117_ = w;
						_tmp118_ = vala_with_statement_get_with_variable (_tmp117_);
						_tmp119_ = _tmp118_;
						_tmp120_ = vala_symbol_get_name ((ValaSymbol*) _tmp119_);
						_tmp121_ = _tmp120_;
						_tmp122_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp123_ = _tmp122_;
						_tmp124_ = vala_member_access_new (NULL, _tmp121_, _tmp123_);
						_tmp125_ = _tmp124_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp125_);
						_vala_code_node_unref0 (_tmp125_);
						_tmp126_ = vala_member_access_get_inner (self);
						_tmp127_ = _tmp126_;
						vala_code_node_check ((ValaCodeNode*) _tmp127_, context);
						may_access_instance_members = TRUE;
					}
					_vala_code_node_unref0 (variable_type);
				}
				_tmp130_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp131_ = _tmp130_;
				if (_tmp131_ == NULL) {
					ValaSymbol* _tmp132_;
					_tmp132_ = sym;
					_tmp129_ = VALA_IS_TYPESYMBOL (_tmp132_);
				} else {
					_tmp129_ = FALSE;
				}
				if (_tmp129_) {
					_tmp128_ = may_access_instance_members;
				} else {
					_tmp128_ = FALSE;
				}
				if (_tmp128_) {
					ValaParameter* _tmp133_;
					ValaDataType* _tmp134_;
					ValaDataType* _tmp135_;
					const gchar* _tmp136_;
					ValaSymbol* _tmp137_;
					ValaSymbol* _tmp138_;
					gboolean _tmp139_ = FALSE;
					ValaSymbol* _tmp140_;
					ValaSymbol* _tmp141_;
					_tmp133_ = this_parameter;
					_tmp134_ = vala_variable_get_variable_type ((ValaVariable*) _tmp133_);
					_tmp135_ = _tmp134_;
					_tmp136_ = self->priv->_member_name;
					_tmp137_ = vala_data_type_get_member (_tmp135_, _tmp136_);
					_tmp138_ = _tmp137_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp138_);
					_vala_code_node_unref0 (_tmp138_);
					_tmp140_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp141_ = _tmp140_;
					if (_tmp141_ != NULL) {
						ValaSymbol* _tmp142_;
						ValaSymbol* _tmp143_;
						_tmp142_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp143_ = _tmp142_;
						_tmp139_ = vala_member_access_is_instance_symbol (_tmp143_);
					} else {
						_tmp139_ = FALSE;
					}
					if (_tmp139_) {
						ValaSourceReference* _tmp144_;
						ValaSourceReference* _tmp145_;
						ValaMemberAccess* _tmp146_;
						ValaMemberAccess* _tmp147_;
						ValaExpression* _tmp148_;
						ValaExpression* _tmp149_;
						ValaParameter* _tmp150_;
						ValaDataType* _tmp151_;
						ValaDataType* _tmp152_;
						ValaDataType* _tmp153_;
						ValaDataType* _tmp154_;
						ValaExpression* _tmp155_;
						ValaExpression* _tmp156_;
						ValaDataType* _tmp157_;
						ValaDataType* _tmp158_;
						ValaExpression* _tmp159_;
						ValaExpression* _tmp160_;
						ValaParameter* _tmp161_;
						ValaExpression* _tmp162_;
						ValaExpression* _tmp163_;
						ValaDataType* _tmp164_;
						ValaDataType* _tmp165_;
						const gchar* _tmp166_;
						ValaSymbol* _tmp167_;
						ValaSymbol* _tmp168_;
						_tmp144_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp145_ = _tmp144_;
						_tmp146_ = vala_member_access_new (NULL, "this", _tmp145_);
						_tmp147_ = _tmp146_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp147_);
						_vala_code_node_unref0 (_tmp147_);
						_tmp148_ = vala_member_access_get_inner (self);
						_tmp149_ = _tmp148_;
						_tmp150_ = this_parameter;
						_tmp151_ = vala_variable_get_variable_type ((ValaVariable*) _tmp150_);
						_tmp152_ = _tmp151_;
						_tmp153_ = vala_data_type_copy (_tmp152_);
						_tmp154_ = _tmp153_;
						vala_expression_set_value_type (_tmp149_, _tmp154_);
						_vala_code_node_unref0 (_tmp154_);
						_tmp155_ = vala_member_access_get_inner (self);
						_tmp156_ = _tmp155_;
						_tmp157_ = vala_expression_get_value_type (_tmp156_);
						_tmp158_ = _tmp157_;
						vala_data_type_set_value_owned (_tmp158_, FALSE);
						_tmp159_ = vala_member_access_get_inner (self);
						_tmp160_ = _tmp159_;
						_tmp161_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp160_, (ValaSymbol*) _tmp161_);
						_tmp162_ = vala_member_access_get_inner (self);
						_tmp163_ = _tmp162_;
						_tmp164_ = vala_expression_get_value_type (_tmp163_);
						_tmp165_ = _tmp164_;
						_tmp166_ = self->priv->_member_name;
						_tmp167_ = vala_data_type_get_member (_tmp165_, _tmp166_);
						_tmp168_ = _tmp167_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp168_);
						_vala_code_node_unref0 (_tmp168_);
					}
				}
				_tmp169_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp170_ = _tmp169_;
				if (_tmp170_ == NULL) {
					ValaSymbol* _tmp171_;
					_tmp171_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp171_)) {
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp172_ = sym;
				_tmp173_ = vala_symbol_get_parent_symbol (_tmp172_);
				_tmp174_ = _tmp173_;
				sym = _tmp174_;
			}
			_tmp176_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp177_ = _tmp176_;
			if (_tmp177_ == NULL) {
				ValaSourceReference* _tmp178_;
				ValaSourceReference* _tmp179_;
				_tmp178_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp179_ = _tmp178_;
				_tmp175_ = _tmp179_ != NULL;
			} else {
				_tmp175_ = FALSE;
			}
			if (_tmp175_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp180_;
					ValaSourceReference* _tmp181_;
					ValaList* _tmp182_;
					ValaList* _tmp183_;
					ValaList* _tmp184_;
					gint _ns_size = 0;
					ValaList* _tmp185_;
					gint _tmp186_;
					gint _tmp187_;
					gint _ns_index = 0;
					_tmp180_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp181_ = _tmp180_;
					_tmp182_ = vala_source_reference_get_using_directives (_tmp181_);
					_tmp183_ = _tmp182_;
					_tmp184_ = _vala_iterable_ref0 (_tmp183_);
					_ns_list = _tmp184_;
					_tmp185_ = _ns_list;
					_tmp186_ = vala_collection_get_size ((ValaCollection*) _tmp185_);
					_tmp187_ = _tmp186_;
					_ns_size = _tmp187_;
					_ns_index = -1;
					while (TRUE) {
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp188_;
						gpointer _tmp189_;
						ValaUsingDirective* _tmp190_;
						gboolean _tmp191_;
						gboolean _tmp192_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp193_;
						ValaSymbol* _tmp194_;
						ValaSymbol* _tmp195_;
						ValaScope* _tmp196_;
						ValaScope* _tmp197_;
						const gchar* _tmp198_;
						ValaSymbol* _tmp199_;
						ValaSymbol* _tmp200_;
						_ns_index = _ns_index + 1;
						if (!(_ns_index < _ns_size)) {
							break;
						}
						_tmp188_ = _ns_list;
						_tmp189_ = vala_list_get (_tmp188_, _ns_index);
						ns = (ValaUsingDirective*) _tmp189_;
						_tmp190_ = ns;
						_tmp191_ = vala_code_node_get_error ((ValaCodeNode*) _tmp190_);
						_tmp192_ = _tmp191_;
						if (_tmp192_) {
							_vala_code_node_unref0 (ns);
							continue;
						}
						_tmp193_ = ns;
						_tmp194_ = vala_using_directive_get_namespace_symbol (_tmp193_);
						_tmp195_ = _tmp194_;
						_tmp196_ = vala_symbol_get_scope (_tmp195_);
						_tmp197_ = _tmp196_;
						_tmp198_ = self->priv->_member_name;
						_tmp199_ = vala_scope_lookup (_tmp197_, _tmp198_);
						local_sym = _tmp199_;
						_tmp200_ = local_sym;
						if (_tmp200_ != NULL) {
							gboolean _tmp201_ = FALSE;
							ValaSymbol* _tmp202_;
							ValaSymbol* _tmp203_;
							ValaSymbol* inner_sym = NULL;
							ValaSymbol* _tmp219_;
							ValaSymbol* _tmp220_;
							ValaSymbol* _tmp221_;
							ValaMemberAccess* inner_ma = NULL;
							ValaExpression* _tmp241_;
							ValaExpression* _tmp242_;
							ValaSymbol* _tmp243_;
							_tmp202_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp203_ = _tmp202_;
							if (_tmp203_ != NULL) {
								ValaSymbol* _tmp204_;
								ValaSymbol* _tmp205_;
								ValaSymbol* _tmp206_;
								_tmp204_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp205_ = _tmp204_;
								_tmp206_ = local_sym;
								_tmp201_ = _tmp205_ != _tmp206_;
							} else {
								_tmp201_ = FALSE;
							}
							if (_tmp201_) {
								ValaSourceReference* _tmp207_;
								ValaSourceReference* _tmp208_;
								const gchar* _tmp209_;
								ValaSymbol* _tmp210_;
								ValaSymbol* _tmp211_;
								gchar* _tmp212_;
								gchar* _tmp213_;
								ValaSymbol* _tmp214_;
								gchar* _tmp215_;
								gchar* _tmp216_;
								gchar* _tmp217_;
								gchar* _tmp218_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp207_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp208_ = _tmp207_;
								_tmp209_ = self->priv->_member_name;
								_tmp210_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp211_ = _tmp210_;
								_tmp212_ = vala_symbol_get_full_name (_tmp211_);
								_tmp213_ = _tmp212_;
								_tmp214_ = local_sym;
								_tmp215_ = vala_symbol_get_full_name (_tmp214_);
								_tmp216_ = _tmp215_;
								_tmp217_ = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", _tmp209_, _tmp213_, _tmp216_);
								_tmp218_ = _tmp217_;
								vala_report_error (_tmp208_, _tmp218_);
								_g_free0 (_tmp218_);
								_g_free0 (_tmp216_);
								_g_free0 (_tmp213_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (_ns_list);
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp219_ = local_sym;
							_tmp220_ = vala_symbol_get_parent_symbol (_tmp219_);
							_tmp221_ = _tmp220_;
							inner_sym = _tmp221_;
							inner_ma = self;
							while (TRUE) {
								gboolean _tmp222_ = FALSE;
								ValaSymbol* _tmp223_;
								ValaMemberAccess* _tmp227_;
								ValaSymbol* _tmp228_;
								const gchar* _tmp229_;
								const gchar* _tmp230_;
								ValaSourceReference* _tmp231_;
								ValaSourceReference* _tmp232_;
								ValaMemberAccess* _tmp233_;
								ValaMemberAccess* _tmp234_;
								ValaMemberAccess* _tmp235_;
								ValaExpression* _tmp236_;
								ValaExpression* _tmp237_;
								ValaSymbol* _tmp238_;
								ValaSymbol* _tmp239_;
								ValaSymbol* _tmp240_;
								_tmp223_ = inner_sym;
								if (_tmp223_ != NULL) {
									ValaSymbol* _tmp224_;
									const gchar* _tmp225_;
									const gchar* _tmp226_;
									_tmp224_ = inner_sym;
									_tmp225_ = vala_symbol_get_name (_tmp224_);
									_tmp226_ = _tmp225_;
									_tmp222_ = _tmp226_ != NULL;
								} else {
									_tmp222_ = FALSE;
								}
								if (!_tmp222_) {
									break;
								}
								_tmp227_ = inner_ma;
								_tmp228_ = inner_sym;
								_tmp229_ = vala_symbol_get_name (_tmp228_);
								_tmp230_ = _tmp229_;
								_tmp231_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp232_ = _tmp231_;
								_tmp233_ = vala_member_access_new (NULL, _tmp230_, _tmp232_);
								_tmp234_ = _tmp233_;
								vala_member_access_set_inner (_tmp227_, (ValaExpression*) _tmp234_);
								_vala_code_node_unref0 (_tmp234_);
								_tmp235_ = inner_ma;
								_tmp236_ = vala_member_access_get_inner (_tmp235_);
								_tmp237_ = _tmp236_;
								inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp237_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
								_tmp238_ = inner_sym;
								_tmp239_ = vala_symbol_get_parent_symbol (_tmp238_);
								_tmp240_ = _tmp239_;
								inner_sym = _tmp240_;
							}
							_tmp241_ = vala_member_access_get_inner (self);
							_tmp242_ = _tmp241_;
							vala_code_node_check ((ValaCodeNode*) _tmp242_, context);
							_tmp243_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp243_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
					_vala_iterable_unref0 (_ns_list);
				}
			}
		} else {
			ValaExpression* _tmp244_;
			ValaExpression* _tmp245_;
			gboolean _tmp246_;
			gboolean _tmp247_;
			ValaExpression* _tmp248_;
			ValaExpression* _tmp249_;
			ValaDataType* _tmp250_;
			ValaDataType* _tmp251_;
			ValaExpression* _tmp269_;
			ValaExpression* _tmp270_;
			gboolean _tmp285_ = FALSE;
			ValaExpression* _tmp286_;
			ValaExpression* _tmp287_;
			gboolean _tmp294_ = FALSE;
			ValaExpression* _tmp295_;
			ValaExpression* _tmp296_;
			gboolean _tmp317_ = FALSE;
			ValaExpression* _tmp318_;
			ValaExpression* _tmp319_;
			gboolean _tmp338_ = FALSE;
			ValaSymbol* _tmp339_;
			ValaSymbol* _tmp340_;
			gboolean _tmp374_ = FALSE;
			gboolean _tmp375_ = FALSE;
			ValaSymbol* _tmp376_;
			ValaSymbol* _tmp377_;
			gboolean _tmp609_ = FALSE;
			ValaSymbol* _tmp610_;
			ValaSymbol* _tmp611_;
			_tmp244_ = vala_member_access_get_inner (self);
			_tmp245_ = _tmp244_;
			_tmp246_ = vala_code_node_get_error ((ValaCodeNode*) _tmp245_);
			_tmp247_ = _tmp246_;
			if (_tmp247_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
			_tmp248_ = vala_member_access_get_inner (self);
			_tmp249_ = _tmp248_;
			_tmp250_ = vala_expression_get_value_type (_tmp249_);
			_tmp251_ = _tmp250_;
			if (VALA_IS_POINTER_TYPE (_tmp251_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp252_;
				ValaExpression* _tmp253_;
				ValaDataType* _tmp254_;
				ValaDataType* _tmp255_;
				gboolean _tmp256_ = FALSE;
				ValaPointerType* _tmp257_;
				_tmp252_ = vala_member_access_get_inner (self);
				_tmp253_ = _tmp252_;
				_tmp254_ = vala_expression_get_value_type (_tmp253_);
				_tmp255_ = _tmp254_;
				pointer_type = VALA_IS_POINTER_TYPE (_tmp255_) ? ((ValaPointerType*) _tmp255_) : NULL;
				_tmp257_ = pointer_type;
				if (_tmp257_ != NULL) {
					ValaPointerType* _tmp258_;
					ValaDataType* _tmp259_;
					ValaDataType* _tmp260_;
					_tmp258_ = pointer_type;
					_tmp259_ = vala_pointer_type_get_base_type (_tmp258_);
					_tmp260_ = _tmp259_;
					_tmp256_ = VALA_IS_VALUE_TYPE (_tmp260_);
				} else {
					_tmp256_ = FALSE;
				}
				if (_tmp256_) {
					ValaExpression* _tmp261_;
					ValaExpression* _tmp262_;
					ValaSourceReference* _tmp263_;
					ValaSourceReference* _tmp264_;
					ValaPointerIndirection* _tmp265_;
					ValaPointerIndirection* _tmp266_;
					ValaExpression* _tmp267_;
					ValaExpression* _tmp268_;
					_tmp261_ = vala_member_access_get_inner (self);
					_tmp262_ = _tmp261_;
					_tmp263_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp264_ = _tmp263_;
					_tmp265_ = vala_pointer_indirection_new (_tmp262_, _tmp264_);
					_tmp266_ = _tmp265_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp266_);
					_vala_code_node_unref0 (_tmp266_);
					_tmp267_ = vala_member_access_get_inner (self);
					_tmp268_ = _tmp267_;
					vala_code_node_check ((ValaCodeNode*) _tmp268_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
			}
			_tmp269_ = vala_member_access_get_inner (self);
			_tmp270_ = _tmp269_;
			if (VALA_IS_MEMBER_ACCESS (_tmp270_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp271_;
				ValaExpression* _tmp272_;
				ValaMemberAccess* _tmp273_;
				gboolean _tmp274_;
				_tmp271_ = vala_member_access_get_inner (self);
				_tmp272_ = _tmp271_;
				ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp272_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
				_tmp273_ = ma;
				_tmp274_ = _tmp273_->priv->_prototype_access;
				if (_tmp274_) {
					ValaSourceReference* _tmp275_;
					ValaSourceReference* _tmp276_;
					ValaExpression* _tmp277_;
					ValaExpression* _tmp278_;
					ValaSymbol* _tmp279_;
					ValaSymbol* _tmp280_;
					gchar* _tmp281_;
					gchar* _tmp282_;
					gchar* _tmp283_;
					gchar* _tmp284_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp275_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp276_ = _tmp275_;
					_tmp277_ = vala_member_access_get_inner (self);
					_tmp278_ = _tmp277_;
					_tmp279_ = vala_expression_get_symbol_reference (_tmp278_);
					_tmp280_ = _tmp279_;
					_tmp281_ = vala_symbol_get_full_name (_tmp280_);
					_tmp282_ = _tmp281_;
					_tmp283_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp282_);
					_tmp284_ = _tmp283_;
					vala_report_error (_tmp276_, _tmp284_);
					_g_free0 (_tmp284_);
					_g_free0 (_tmp282_);
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
			}
			_tmp286_ = vala_member_access_get_inner (self);
			_tmp287_ = _tmp286_;
			if (VALA_IS_CAST_EXPRESSION (_tmp287_)) {
				ValaExpression* _tmp288_;
				ValaExpression* _tmp289_;
				gboolean _tmp290_;
				gboolean _tmp291_;
				_tmp288_ = vala_member_access_get_inner (self);
				_tmp289_ = _tmp288_;
				_tmp290_ = vala_cast_expression_get_is_silent_cast (G_TYPE_CHECK_INSTANCE_CAST (_tmp289_, VALA_TYPE_CAST_EXPRESSION, ValaCastExpression));
				_tmp291_ = _tmp290_;
				_tmp285_ = _tmp291_;
			} else {
				_tmp285_ = FALSE;
			}
			if (_tmp285_) {
				ValaSourceReference* _tmp292_;
				ValaSourceReference* _tmp293_;
				_tmp292_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp293_ = _tmp292_;
				vala_report_warning (_tmp293_, "Access to possible `null'. Perform a check or use an unsafe cast.");
			}
			_tmp295_ = vala_member_access_get_inner (self);
			_tmp296_ = _tmp295_;
			if (VALA_IS_MEMBER_ACCESS (_tmp296_)) {
				_tmp294_ = TRUE;
			} else {
				ValaExpression* _tmp297_;
				ValaExpression* _tmp298_;
				_tmp297_ = vala_member_access_get_inner (self);
				_tmp298_ = _tmp297_;
				_tmp294_ = VALA_IS_BASE_ACCESS (_tmp298_);
			}
			if (_tmp294_) {
				ValaExpression* _tmp299_;
				ValaExpression* _tmp300_;
				ValaSymbol* _tmp301_;
				ValaSymbol* _tmp302_;
				gboolean _tmp303_ = FALSE;
				ValaSymbol* _tmp304_;
				ValaSymbol* _tmp305_;
				_tmp299_ = vala_member_access_get_inner (self);
				_tmp300_ = _tmp299_;
				_tmp301_ = vala_expression_get_symbol_reference (_tmp300_);
				_tmp302_ = _tmp301_;
				base_symbol = _tmp302_;
				_tmp304_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp305_ = _tmp304_;
				if (_tmp305_ == NULL) {
					gboolean _tmp306_ = FALSE;
					ValaSymbol* _tmp307_;
					_tmp307_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp307_)) {
						_tmp306_ = TRUE;
					} else {
						ValaSymbol* _tmp308_;
						_tmp308_ = base_symbol;
						_tmp306_ = VALA_IS_TYPESYMBOL (_tmp308_);
					}
					_tmp303_ = _tmp306_;
				} else {
					_tmp303_ = FALSE;
				}
				if (_tmp303_) {
					ValaSymbol* _tmp309_;
					ValaScope* _tmp310_;
					ValaScope* _tmp311_;
					const gchar* _tmp312_;
					ValaSymbol* _tmp313_;
					ValaSymbol* _tmp314_;
					ValaExpression* _tmp315_;
					ValaExpression* _tmp316_;
					_tmp309_ = base_symbol;
					_tmp310_ = vala_symbol_get_scope (_tmp309_);
					_tmp311_ = _tmp310_;
					_tmp312_ = self->priv->_member_name;
					_tmp313_ = vala_scope_lookup (_tmp311_, _tmp312_);
					_tmp314_ = _tmp313_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp314_);
					_vala_code_node_unref0 (_tmp314_);
					_tmp315_ = vala_member_access_get_inner (self);
					_tmp316_ = _tmp315_;
					if (VALA_IS_BASE_ACCESS (_tmp316_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp318_ = vala_member_access_get_inner (self);
			_tmp319_ = _tmp318_;
			if (VALA_IS_MEMBER_ACCESS (_tmp319_)) {
				ValaExpression* _tmp320_;
				ValaExpression* _tmp321_;
				ValaSymbol* _tmp322_;
				ValaSymbol* _tmp323_;
				_tmp320_ = vala_member_access_get_inner (self);
				_tmp321_ = _tmp320_;
				_tmp322_ = vala_expression_get_symbol_reference (_tmp321_);
				_tmp323_ = _tmp322_;
				_tmp317_ = VALA_IS_TYPEPARAMETER (_tmp323_);
			} else {
				_tmp317_ = FALSE;
			}
			if (_tmp317_) {
				ValaExpression* _tmp324_;
				ValaExpression* _tmp325_;
				ValaExpression* _tmp326_;
				ValaExpression* _tmp327_;
				ValaSymbol* _tmp328_;
				ValaSymbol* _tmp329_;
				ValaGenericType* _tmp330_;
				ValaGenericType* _tmp331_;
				ValaExpression* _tmp332_;
				ValaExpression* _tmp333_;
				ValaDataType* _tmp334_;
				ValaDataType* _tmp335_;
				ValaSourceReference* _tmp336_;
				ValaSourceReference* _tmp337_;
				_tmp324_ = vala_member_access_get_inner (self);
				_tmp325_ = _tmp324_;
				_tmp326_ = vala_member_access_get_inner (self);
				_tmp327_ = _tmp326_;
				_tmp328_ = vala_expression_get_symbol_reference (_tmp327_);
				_tmp329_ = _tmp328_;
				_tmp330_ = vala_generic_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp329_, VALA_TYPE_TYPEPARAMETER, ValaTypeParameter));
				_tmp331_ = _tmp330_;
				vala_expression_set_value_type (_tmp325_, (ValaDataType*) _tmp331_);
				_vala_code_node_unref0 (_tmp331_);
				_tmp332_ = vala_member_access_get_inner (self);
				_tmp333_ = _tmp332_;
				_tmp334_ = vala_expression_get_value_type (_tmp333_);
				_tmp335_ = _tmp334_;
				_tmp336_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp337_ = _tmp336_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp335_, _tmp337_);
			}
			_tmp339_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp340_ = _tmp339_;
			if (_tmp340_ == NULL) {
				ValaExpression* _tmp341_;
				ValaExpression* _tmp342_;
				ValaDataType* _tmp343_;
				ValaDataType* _tmp344_;
				_tmp341_ = vala_member_access_get_inner (self);
				_tmp342_ = _tmp341_;
				_tmp343_ = vala_expression_get_value_type (_tmp342_);
				_tmp344_ = _tmp343_;
				_tmp338_ = _tmp344_ != NULL;
			} else {
				_tmp338_ = FALSE;
			}
			if (_tmp338_) {
				gboolean _tmp345_;
				ValaSymbol* _tmp372_;
				ValaSymbol* _tmp373_;
				_tmp345_ = self->priv->_pointer_member_access;
				if (_tmp345_) {
					ValaExpression* _tmp346_;
					ValaExpression* _tmp347_;
					ValaDataType* _tmp348_;
					ValaDataType* _tmp349_;
					const gchar* _tmp350_;
					ValaSymbol* _tmp351_;
					ValaSymbol* _tmp352_;
					_tmp346_ = vala_member_access_get_inner (self);
					_tmp347_ = _tmp346_;
					_tmp348_ = vala_expression_get_value_type (_tmp347_);
					_tmp349_ = _tmp348_;
					_tmp350_ = self->priv->_member_name;
					_tmp351_ = vala_data_type_get_pointer_member (_tmp349_, _tmp350_);
					_tmp352_ = _tmp351_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp352_);
					_vala_code_node_unref0 (_tmp352_);
				} else {
					ValaExpression* _tmp353_;
					ValaExpression* _tmp354_;
					ValaDataType* _tmp355_;
					ValaDataType* _tmp356_;
					ValaTypeSymbol* _tmp357_;
					ValaTypeSymbol* _tmp358_;
					ValaExpression* _tmp365_;
					ValaExpression* _tmp366_;
					ValaDataType* _tmp367_;
					ValaDataType* _tmp368_;
					const gchar* _tmp369_;
					ValaSymbol* _tmp370_;
					ValaSymbol* _tmp371_;
					_tmp353_ = vala_member_access_get_inner (self);
					_tmp354_ = _tmp353_;
					_tmp355_ = vala_expression_get_value_type (_tmp354_);
					_tmp356_ = _tmp355_;
					_tmp357_ = vala_data_type_get_type_symbol (_tmp356_);
					_tmp358_ = _tmp357_;
					if (_tmp358_ != NULL) {
						ValaExpression* _tmp359_;
						ValaExpression* _tmp360_;
						ValaDataType* _tmp361_;
						ValaDataType* _tmp362_;
						ValaTypeSymbol* _tmp363_;
						ValaTypeSymbol* _tmp364_;
						_tmp359_ = vala_member_access_get_inner (self);
						_tmp360_ = _tmp359_;
						_tmp361_ = vala_expression_get_value_type (_tmp360_);
						_tmp362_ = _tmp361_;
						_tmp363_ = vala_data_type_get_type_symbol (_tmp362_);
						_tmp364_ = _tmp363_;
						base_symbol = (ValaSymbol*) _tmp364_;
					}
					_tmp365_ = vala_member_access_get_inner (self);
					_tmp366_ = _tmp365_;
					_tmp367_ = vala_expression_get_value_type (_tmp366_);
					_tmp368_ = _tmp367_;
					_tmp369_ = self->priv->_member_name;
					_tmp370_ = vala_data_type_get_member (_tmp368_, _tmp369_);
					_tmp371_ = _tmp370_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp371_);
					_vala_code_node_unref0 (_tmp371_);
				}
				_tmp372_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp373_ = _tmp372_;
				if (_tmp373_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp376_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp377_ = _tmp376_;
			if (_tmp377_ == NULL) {
				ValaExpression* _tmp378_;
				ValaExpression* _tmp379_;
				ValaDataType* _tmp380_;
				ValaDataType* _tmp381_;
				_tmp378_ = vala_member_access_get_inner (self);
				_tmp379_ = _tmp378_;
				_tmp380_ = vala_expression_get_value_type (_tmp379_);
				_tmp381_ = _tmp380_;
				_tmp375_ = _tmp381_ != NULL;
			} else {
				_tmp375_ = FALSE;
			}
			if (_tmp375_) {
				ValaExpression* _tmp382_;
				ValaExpression* _tmp383_;
				ValaDataType* _tmp384_;
				ValaDataType* _tmp385_;
				gboolean _tmp386_;
				gboolean _tmp387_;
				_tmp382_ = vala_member_access_get_inner (self);
				_tmp383_ = _tmp382_;
				_tmp384_ = vala_expression_get_value_type (_tmp383_);
				_tmp385_ = _tmp384_;
				_tmp386_ = vala_data_type_get_is_dynamic (_tmp385_);
				_tmp387_ = _tmp386_;
				_tmp374_ = _tmp387_;
			} else {
				_tmp374_ = FALSE;
			}
			if (_tmp374_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp388_;
				ValaExpression* _tmp389_;
				ValaDataType* _tmp390_;
				ValaDataType* _tmp391_;
				ValaObjectType* _tmp392_;
				ValaCodeNode* _tmp393_;
				ValaCodeNode* _tmp394_;
				ValaSymbol* _tmp557_;
				ValaSymbol* _tmp558_;
				ValaSymbol* _tmp607_;
				ValaSymbol* _tmp608_;
				_tmp388_ = vala_member_access_get_inner (self);
				_tmp389_ = _tmp388_;
				_tmp390_ = vala_expression_get_value_type (_tmp389_);
				_tmp391_ = _tmp390_;
				_tmp392_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp391_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp392_;
				_tmp393_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp394_ = _tmp393_;
				if (VALA_IS_METHOD_CALL (_tmp394_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp395_;
					ValaCodeNode* _tmp396_;
					ValaMethodCall* _tmp397_;
					ValaExpression* _tmp398_;
					ValaExpression* _tmp399_;
					_tmp395_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp396_ = _tmp395_;
					invoc = G_TYPE_CHECK_INSTANCE_CAST (_tmp396_, VALA_TYPE_METHOD_CALL, ValaMethodCall);
					_tmp397_ = invoc;
					_tmp398_ = vala_method_call_get_call (_tmp397_);
					_tmp399_ = _tmp398_;
					if (_tmp399_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp400_;
						ValaDataType* _tmp401_;
						ValaDataType* _tmp402_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp417_;
						ValaExpression* _tmp418_;
						ValaDataType* _tmp419_;
						ValaDataType* _tmp420_;
						const gchar* _tmp421_;
						ValaDataType* _tmp422_;
						ValaSourceReference* _tmp423_;
						ValaSourceReference* _tmp424_;
						ValaDynamicMethod* _tmp425_;
						ValaDynamicMethod* _tmp426_;
						ValaMethodCall* _tmp427_;
						ValaErrorType* err = NULL;
						ValaErrorType* _tmp428_;
						ValaErrorType* _tmp429_;
						ValaDynamicMethod* _tmp430_;
						ValaErrorType* _tmp431_;
						ValaDynamicMethod* _tmp432_;
						ValaDynamicMethod* _tmp433_;
						ValaParameter* _tmp434_;
						ValaParameter* _tmp435_;
						ValaDynamicMethod* _tmp436_;
						ValaObjectType* _tmp437_;
						ValaDataType* _tmp438_;
						ValaDataType* _tmp439_;
						ValaParameter* _tmp440_;
						ValaParameter* _tmp441_;
						ValaObjectType* _tmp442_;
						ValaTypeSymbol* _tmp443_;
						ValaTypeSymbol* _tmp444_;
						ValaScope* _tmp445_;
						ValaScope* _tmp446_;
						ValaDynamicMethod* _tmp447_;
						ValaDynamicMethod* _tmp448_;
						_tmp400_ = invoc;
						_tmp401_ = vala_expression_get_target_type ((ValaExpression*) _tmp400_);
						_tmp402_ = _tmp401_;
						if (_tmp402_ != NULL) {
							ValaMethodCall* _tmp403_;
							ValaDataType* _tmp404_;
							ValaDataType* _tmp405_;
							ValaDataType* _tmp406_;
							ValaDataType* _tmp407_;
							_tmp403_ = invoc;
							_tmp404_ = vala_expression_get_target_type ((ValaExpression*) _tmp403_);
							_tmp405_ = _tmp404_;
							_tmp406_ = vala_data_type_copy (_tmp405_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp406_;
							_tmp407_ = ret_type;
							vala_data_type_set_value_owned (_tmp407_, TRUE);
						} else {
							ValaMethodCall* _tmp408_;
							ValaCodeNode* _tmp409_;
							ValaCodeNode* _tmp410_;
							_tmp408_ = invoc;
							_tmp409_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp408_);
							_tmp410_ = _tmp409_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp410_)) {
								ValaVoidType* _tmp411_;
								_tmp411_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp411_;
							} else {
								ValaExpression* _tmp412_;
								ValaExpression* _tmp413_;
								ValaDataType* _tmp414_;
								ValaDataType* _tmp415_;
								ValaDataType* _tmp416_;
								_tmp412_ = vala_member_access_get_inner (self);
								_tmp413_ = _tmp412_;
								_tmp414_ = vala_expression_get_value_type (_tmp413_);
								_tmp415_ = _tmp414_;
								_tmp416_ = vala_data_type_copy (_tmp415_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp416_;
							}
						}
						_tmp417_ = vala_member_access_get_inner (self);
						_tmp418_ = _tmp417_;
						_tmp419_ = vala_expression_get_value_type (_tmp418_);
						_tmp420_ = _tmp419_;
						_tmp421_ = self->priv->_member_name;
						_tmp422_ = ret_type;
						_tmp423_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp424_ = _tmp423_;
						_tmp425_ = vala_dynamic_method_new (_tmp420_, _tmp421_, _tmp422_, _tmp424_, NULL);
						m = _tmp425_;
						_tmp426_ = m;
						_tmp427_ = invoc;
						vala_dynamic_method_set_invocation (_tmp426_, _tmp427_);
						_tmp428_ = vala_error_type_new (NULL, NULL, NULL);
						err = _tmp428_;
						_tmp429_ = err;
						vala_error_type_set_dynamic_error (_tmp429_, TRUE);
						_tmp430_ = m;
						_tmp431_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp430_, (ValaDataType*) _tmp431_);
						_tmp432_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp432_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp433_ = m;
						_tmp434_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp435_ = _tmp434_;
						vala_callable_add_parameter ((ValaCallable*) _tmp433_, _tmp435_);
						_vala_code_node_unref0 (_tmp435_);
						_tmp436_ = m;
						_tmp437_ = dynamic_object_type;
						_tmp438_ = vala_data_type_copy ((ValaDataType*) _tmp437_);
						_tmp439_ = _tmp438_;
						_tmp440_ = vala_parameter_new ("this", _tmp439_, NULL);
						_tmp441_ = _tmp440_;
						vala_method_set_this_parameter ((ValaMethod*) _tmp436_, _tmp441_);
						_vala_code_node_unref0 (_tmp441_);
						_vala_code_node_unref0 (_tmp439_);
						_tmp442_ = dynamic_object_type;
						_tmp443_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp442_);
						_tmp444_ = _tmp443_;
						_tmp445_ = vala_symbol_get_scope ((ValaSymbol*) _tmp444_);
						_tmp446_ = _tmp445_;
						_tmp447_ = m;
						vala_scope_add (_tmp446_, NULL, (ValaSymbol*) _tmp447_);
						_tmp448_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp448_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
				} else {
					ValaCodeNode* _tmp449_;
					ValaCodeNode* _tmp450_;
					_tmp449_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp450_ = _tmp449_;
					if (VALA_IS_ASSIGNMENT (_tmp450_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp451_;
						ValaCodeNode* _tmp452_;
						ValaAssignment* _tmp453_;
						ValaExpression* _tmp454_;
						ValaExpression* _tmp455_;
						_tmp451_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp452_ = _tmp451_;
						a = G_TYPE_CHECK_INSTANCE_CAST (_tmp452_, VALA_TYPE_ASSIGNMENT, ValaAssignment);
						_tmp453_ = a;
						_tmp454_ = vala_assignment_get_left (_tmp453_);
						_tmp455_ = _tmp454_;
						if (_tmp455_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							ValaDynamicProperty* prop = NULL;
							ValaExpression* _tmp456_;
							ValaExpression* _tmp457_;
							ValaDataType* _tmp458_;
							ValaDataType* _tmp459_;
							const gchar* _tmp460_;
							ValaSourceReference* _tmp461_;
							ValaSourceReference* _tmp462_;
							ValaDynamicProperty* _tmp463_;
							ValaDynamicProperty* _tmp464_;
							ValaDynamicProperty* _tmp465_;
							ValaDynamicProperty* _tmp466_;
							ValaSourceReference* _tmp467_;
							ValaSourceReference* _tmp468_;
							ValaPropertyAccessor* _tmp469_;
							ValaPropertyAccessor* _tmp470_;
							ValaDynamicProperty* _tmp471_;
							ValaExpression* _tmp472_;
							ValaExpression* _tmp473_;
							ValaDataType* _tmp474_;
							ValaDataType* _tmp475_;
							ValaTypeSymbol* _tmp476_;
							ValaTypeSymbol* _tmp477_;
							ValaScope* _tmp478_;
							ValaScope* _tmp479_;
							ValaObjectType* _tmp480_;
							ValaTypeSymbol* _tmp481_;
							ValaTypeSymbol* _tmp482_;
							ValaScope* _tmp483_;
							ValaScope* _tmp484_;
							ValaDynamicProperty* _tmp485_;
							ValaDynamicProperty* _tmp486_;
							_tmp456_ = vala_member_access_get_inner (self);
							_tmp457_ = _tmp456_;
							_tmp458_ = vala_expression_get_value_type (_tmp457_);
							_tmp459_ = _tmp458_;
							_tmp460_ = self->priv->_member_name;
							_tmp461_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp462_ = _tmp461_;
							_tmp463_ = vala_dynamic_property_new (_tmp459_, _tmp460_, _tmp462_, NULL);
							prop = _tmp463_;
							_tmp464_ = prop;
							vala_symbol_set_access ((ValaSymbol*) _tmp464_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp465_ = prop;
							_tmp466_ = prop;
							_tmp467_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp466_);
							_tmp468_ = _tmp467_;
							_tmp469_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp468_, NULL);
							_tmp470_ = _tmp469_;
							vala_property_set_set_accessor ((ValaProperty*) _tmp465_, _tmp470_);
							_vala_code_node_unref0 (_tmp470_);
							_tmp471_ = prop;
							_tmp472_ = vala_member_access_get_inner (self);
							_tmp473_ = _tmp472_;
							_tmp474_ = vala_expression_get_value_type (_tmp473_);
							_tmp475_ = _tmp474_;
							_tmp476_ = vala_data_type_get_type_symbol (_tmp475_);
							_tmp477_ = _tmp476_;
							_tmp478_ = vala_symbol_get_scope ((ValaSymbol*) _tmp477_);
							_tmp479_ = _tmp478_;
							vala_symbol_set_owner ((ValaSymbol*) _tmp471_, _tmp479_);
							_tmp480_ = dynamic_object_type;
							_tmp481_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp480_);
							_tmp482_ = _tmp481_;
							_tmp483_ = vala_symbol_get_scope ((ValaSymbol*) _tmp482_);
							_tmp484_ = _tmp483_;
							_tmp485_ = prop;
							vala_scope_add (_tmp484_, NULL, (ValaSymbol*) _tmp485_);
							_tmp486_ = prop;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp486_);
							_vala_code_node_unref0 (prop);
						}
					} else {
						gboolean _tmp487_ = FALSE;
						gboolean _tmp488_ = FALSE;
						ValaCodeNode* _tmp489_;
						ValaCodeNode* _tmp490_;
						_tmp489_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp490_ = _tmp489_;
						if (VALA_IS_MEMBER_ACCESS (_tmp490_)) {
							ValaExpression* _tmp491_;
							ValaExpression* _tmp492_;
							_tmp491_ = vala_member_access_get_inner (self);
							_tmp492_ = _tmp491_;
							_tmp488_ = VALA_IS_MEMBER_ACCESS (_tmp492_);
						} else {
							_tmp488_ = FALSE;
						}
						if (_tmp488_) {
							ValaCodeNode* _tmp493_;
							ValaCodeNode* _tmp494_;
							ValaCodeNode* _tmp495_;
							ValaCodeNode* _tmp496_;
							_tmp493_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp494_ = _tmp493_;
							_tmp495_ = vala_code_node_get_parent_node (_tmp494_);
							_tmp496_ = _tmp495_;
							_tmp487_ = VALA_IS_METHOD_CALL (_tmp496_);
						} else {
							_tmp487_ = FALSE;
						}
						if (_tmp487_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp497_;
							ValaCodeNode* _tmp498_;
							gboolean _tmp499_ = FALSE;
							ValaMemberAccess* _tmp500_;
							const gchar* _tmp501_;
							_tmp497_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp498_ = _tmp497_;
							ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp498_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
							_tmp500_ = ma;
							_tmp501_ = _tmp500_->priv->_member_name;
							if (g_strcmp0 (_tmp501_, "connect") == 0) {
								_tmp499_ = TRUE;
							} else {
								ValaMemberAccess* _tmp502_;
								const gchar* _tmp503_;
								_tmp502_ = ma;
								_tmp503_ = _tmp502_->priv->_member_name;
								_tmp499_ = g_strcmp0 (_tmp503_, "connect_after") == 0;
							}
							if (_tmp499_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp504_;
								ValaExpression* _tmp505_;
								ValaDataType* _tmp506_;
								ValaDataType* _tmp507_;
								const gchar* _tmp508_;
								ValaVoidType* _tmp509_;
								ValaVoidType* _tmp510_;
								ValaSourceReference* _tmp511_;
								ValaSourceReference* _tmp512_;
								ValaDynamicSignal* _tmp513_;
								ValaDynamicSignal* _tmp514_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp515_;
								ValaCodeNode* _tmp516_;
								ValaCodeNode* _tmp517_;
								ValaCodeNode* _tmp518_;
								ValaMethodCall* _tmp519_;
								ValaMethodCall* _tmp520_;
								ValaList* _tmp521_;
								gint _tmp522_;
								gint _tmp523_;
								ValaDynamicSignal* _tmp549_;
								ValaObjectType* _tmp550_;
								ValaTypeSymbol* _tmp551_;
								ValaTypeSymbol* _tmp552_;
								ValaScope* _tmp553_;
								ValaScope* _tmp554_;
								ValaDynamicSignal* _tmp555_;
								ValaDynamicSignal* _tmp556_;
								_tmp504_ = vala_member_access_get_inner (self);
								_tmp505_ = _tmp504_;
								_tmp506_ = vala_expression_get_value_type (_tmp505_);
								_tmp507_ = _tmp506_;
								_tmp508_ = self->priv->_member_name;
								_tmp509_ = vala_void_type_new (NULL);
								_tmp510_ = _tmp509_;
								_tmp511_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp512_ = _tmp511_;
								_tmp513_ = vala_dynamic_signal_new (_tmp507_, _tmp508_, (ValaDataType*) _tmp510_, _tmp512_, NULL);
								_tmp514_ = _tmp513_;
								_vala_code_node_unref0 (_tmp510_);
								s = _tmp514_;
								_tmp515_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp516_ = _tmp515_;
								_tmp517_ = vala_code_node_get_parent_node (_tmp516_);
								_tmp518_ = _tmp517_;
								_tmp519_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp518_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp519_;
								_tmp520_ = mcall;
								_tmp521_ = vala_method_call_get_argument_list (_tmp520_);
								_tmp522_ = vala_collection_get_size ((ValaCollection*) _tmp521_);
								_tmp523_ = _tmp522_;
								if (_tmp523_ > 0) {
									ValaDynamicSignal* _tmp524_;
									ValaMethodCall* _tmp525_;
									ValaList* _tmp526_;
									gpointer _tmp527_;
									ValaExpression* _tmp528_;
									ValaMemberAccess* arg = NULL;
									ValaDynamicSignal* _tmp529_;
									ValaExpression* _tmp530_;
									ValaExpression* _tmp531_;
									gboolean _tmp532_ = FALSE;
									gboolean _tmp533_ = FALSE;
									ValaMemberAccess* _tmp534_;
									_tmp524_ = s;
									_tmp525_ = mcall;
									_tmp526_ = vala_method_call_get_argument_list (_tmp525_);
									_tmp527_ = vala_list_get (_tmp526_, 0);
									_tmp528_ = (ValaExpression*) _tmp527_;
									vala_dynamic_signal_set_handler (_tmp524_, _tmp528_);
									_vala_code_node_unref0 (_tmp528_);
									_tmp529_ = s;
									_tmp530_ = vala_dynamic_signal_get_handler (_tmp529_);
									_tmp531_ = _tmp530_;
									arg = VALA_IS_MEMBER_ACCESS (_tmp531_) ? ((ValaMemberAccess*) _tmp531_) : NULL;
									_tmp534_ = arg;
									if (_tmp534_ == NULL) {
										_tmp533_ = TRUE;
									} else {
										ValaMemberAccess* _tmp535_;
										_tmp535_ = arg;
										_tmp533_ = !vala_code_node_check ((ValaCodeNode*) _tmp535_, context);
									}
									if (_tmp533_) {
										_tmp532_ = TRUE;
									} else {
										ValaMemberAccess* _tmp536_;
										ValaSymbol* _tmp537_;
										ValaSymbol* _tmp538_;
										_tmp536_ = arg;
										_tmp537_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp536_);
										_tmp538_ = _tmp537_;
										_tmp532_ = !VALA_IS_METHOD (_tmp538_);
									}
									if (_tmp532_) {
										ValaDynamicSignal* _tmp539_;
										ValaExpression* _tmp540_;
										ValaExpression* _tmp541_;
										ValaSourceReference* _tmp542_;
										ValaSourceReference* _tmp543_;
										ValaDynamicSignal* _tmp544_;
										gchar* _tmp545_;
										gchar* _tmp546_;
										gchar* _tmp547_;
										gchar* _tmp548_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp539_ = s;
										_tmp540_ = vala_dynamic_signal_get_handler (_tmp539_);
										_tmp541_ = _tmp540_;
										_tmp542_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp541_);
										_tmp543_ = _tmp542_;
										_tmp544_ = s;
										_tmp545_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp544_);
										_tmp546_ = _tmp545_;
										_tmp547_ = g_strdup_printf ("Invalid handler for `%s'", _tmp546_);
										_tmp548_ = _tmp547_;
										vala_report_error (_tmp543_, _tmp548_);
										_g_free0 (_tmp548_);
										_g_free0 (_tmp546_);
									}
								}
								_tmp549_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp549_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp550_ = dynamic_object_type;
								_tmp551_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp550_);
								_tmp552_ = _tmp551_;
								_tmp553_ = vala_symbol_get_scope ((ValaSymbol*) _tmp552_);
								_tmp554_ = _tmp553_;
								_tmp555_ = s;
								vala_scope_add (_tmp554_, NULL, (ValaSymbol*) _tmp555_);
								_tmp556_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp556_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							}
						}
					}
				}
				_tmp557_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp558_ = _tmp557_;
				if (_tmp558_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp559_;
					ValaExpression* _tmp560_;
					ValaDataType* _tmp561_;
					ValaDataType* _tmp562_;
					const gchar* _tmp563_;
					ValaSourceReference* _tmp564_;
					ValaSourceReference* _tmp565_;
					ValaDynamicProperty* _tmp566_;
					ValaDataType* _tmp567_;
					ValaDataType* _tmp568_;
					ValaDynamicProperty* _tmp579_;
					ValaDynamicProperty* _tmp580_;
					ValaDynamicProperty* _tmp581_;
					ValaDataType* _tmp582_;
					ValaDataType* _tmp583_;
					ValaDataType* _tmp584_;
					ValaDataType* _tmp585_;
					ValaDynamicProperty* _tmp586_;
					ValaSourceReference* _tmp587_;
					ValaSourceReference* _tmp588_;
					ValaPropertyAccessor* _tmp589_;
					ValaPropertyAccessor* _tmp590_;
					ValaDynamicProperty* _tmp591_;
					ValaExpression* _tmp592_;
					ValaExpression* _tmp593_;
					ValaDataType* _tmp594_;
					ValaDataType* _tmp595_;
					ValaTypeSymbol* _tmp596_;
					ValaTypeSymbol* _tmp597_;
					ValaScope* _tmp598_;
					ValaScope* _tmp599_;
					ValaObjectType* _tmp600_;
					ValaTypeSymbol* _tmp601_;
					ValaTypeSymbol* _tmp602_;
					ValaScope* _tmp603_;
					ValaScope* _tmp604_;
					ValaDynamicProperty* _tmp605_;
					ValaDynamicProperty* _tmp606_;
					_tmp559_ = vala_member_access_get_inner (self);
					_tmp560_ = _tmp559_;
					_tmp561_ = vala_expression_get_value_type (_tmp560_);
					_tmp562_ = _tmp561_;
					_tmp563_ = self->priv->_member_name;
					_tmp564_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp565_ = _tmp564_;
					_tmp566_ = vala_dynamic_property_new (_tmp562_, _tmp563_, _tmp565_, NULL);
					prop = _tmp566_;
					_tmp567_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp568_ = _tmp567_;
					if (_tmp568_ != NULL) {
						ValaDynamicProperty* _tmp569_;
						ValaDataType* _tmp570_;
						ValaDataType* _tmp571_;
						_tmp569_ = prop;
						_tmp570_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp571_ = _tmp570_;
						vala_property_set_property_type ((ValaProperty*) _tmp569_, _tmp571_);
					} else {
						ValaDynamicProperty* _tmp572_;
						ValaExpression* _tmp573_;
						ValaExpression* _tmp574_;
						ValaDataType* _tmp575_;
						ValaDataType* _tmp576_;
						ValaDataType* _tmp577_;
						ValaDataType* _tmp578_;
						_tmp572_ = prop;
						_tmp573_ = vala_member_access_get_inner (self);
						_tmp574_ = _tmp573_;
						_tmp575_ = vala_expression_get_value_type (_tmp574_);
						_tmp576_ = _tmp575_;
						_tmp577_ = vala_data_type_copy (_tmp576_);
						_tmp578_ = _tmp577_;
						vala_property_set_property_type ((ValaProperty*) _tmp572_, _tmp578_);
						_vala_code_node_unref0 (_tmp578_);
					}
					_tmp579_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp579_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp580_ = prop;
					_tmp581_ = prop;
					_tmp582_ = vala_property_get_property_type ((ValaProperty*) _tmp581_);
					_tmp583_ = _tmp582_;
					_tmp584_ = vala_data_type_copy (_tmp583_);
					_tmp585_ = _tmp584_;
					_tmp586_ = prop;
					_tmp587_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp586_);
					_tmp588_ = _tmp587_;
					_tmp589_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp585_, NULL, _tmp588_, NULL);
					_tmp590_ = _tmp589_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp580_, _tmp590_);
					_vala_code_node_unref0 (_tmp590_);
					_vala_code_node_unref0 (_tmp585_);
					_tmp591_ = prop;
					_tmp592_ = vala_member_access_get_inner (self);
					_tmp593_ = _tmp592_;
					_tmp594_ = vala_expression_get_value_type (_tmp593_);
					_tmp595_ = _tmp594_;
					_tmp596_ = vala_data_type_get_type_symbol (_tmp595_);
					_tmp597_ = _tmp596_;
					_tmp598_ = vala_symbol_get_scope ((ValaSymbol*) _tmp597_);
					_tmp599_ = _tmp598_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp591_, _tmp599_);
					_tmp600_ = dynamic_object_type;
					_tmp601_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp600_);
					_tmp602_ = _tmp601_;
					_tmp603_ = vala_symbol_get_scope ((ValaSymbol*) _tmp602_);
					_tmp604_ = _tmp603_;
					_tmp605_ = prop;
					vala_scope_add (_tmp604_, NULL, (ValaSymbol*) _tmp605_);
					_tmp606_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp606_);
					_vala_code_node_unref0 (prop);
				}
				_tmp607_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp608_ = _tmp607_;
				if (_tmp608_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp610_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp611_ = _tmp610_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp611_)) {
				ValaExpression* _tmp612_;
				ValaExpression* _tmp613_;
				ValaSymbol* _tmp614_;
				ValaSymbol* _tmp615_;
				_tmp612_ = vala_member_access_get_inner (self);
				_tmp613_ = _tmp612_;
				_tmp614_ = vala_expression_get_symbol_reference (_tmp613_);
				_tmp615_ = _tmp614_;
				_tmp609_ = VALA_IS_VARIABLE (_tmp615_);
			} else {
				_tmp609_ = FALSE;
			}
			if (_tmp609_) {
				ValaArrayType* inner_type = NULL;
				ValaSemanticAnalyzer* _tmp616_;
				ValaSemanticAnalyzer* _tmp617_;
				ValaExpression* _tmp618_;
				ValaExpression* _tmp619_;
				ValaSymbol* _tmp620_;
				ValaSymbol* _tmp621_;
				ValaDataType* _tmp622_;
				ValaArrayType* _tmp623_;
				gboolean _tmp624_ = FALSE;
				ValaArrayType* _tmp625_;
				_tmp616_ = vala_code_context_get_analyzer (context);
				_tmp617_ = _tmp616_;
				_tmp618_ = vala_member_access_get_inner (self);
				_tmp619_ = _tmp618_;
				_tmp620_ = vala_expression_get_symbol_reference (_tmp619_);
				_tmp621_ = _tmp620_;
				_tmp622_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp617_, _tmp621_, TRUE);
				_tmp623_ = VALA_IS_ARRAY_TYPE (_tmp622_) ? ((ValaArrayType*) _tmp622_) : NULL;
				if (_tmp623_ == NULL) {
					_vala_code_node_unref0 (_tmp622_);
				}
				inner_type = _tmp623_;
				_tmp625_ = inner_type;
				if (_tmp625_ != NULL) {
					ValaArrayType* _tmp626_;
					gboolean _tmp627_;
					gboolean _tmp628_;
					_tmp626_ = inner_type;
					_tmp627_ = vala_array_type_get_inline_allocated (_tmp626_);
					_tmp628_ = _tmp627_;
					_tmp624_ = _tmp628_;
				} else {
					_tmp624_ = FALSE;
				}
				if (_tmp624_) {
					ValaSourceReference* _tmp629_;
					ValaSourceReference* _tmp630_;
					_tmp629_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp630_ = _tmp629_;
					vala_report_error (_tmp630_, "`resize' is not supported for arrays with fixed length");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				} else {
					gboolean _tmp631_ = FALSE;
					ValaArrayType* _tmp632_;
					_tmp632_ = inner_type;
					if (_tmp632_ != NULL) {
						ValaArrayType* _tmp633_;
						gboolean _tmp634_;
						gboolean _tmp635_;
						_tmp633_ = inner_type;
						_tmp634_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp633_);
						_tmp635_ = _tmp634_;
						_tmp631_ = !_tmp635_;
					} else {
						_tmp631_ = FALSE;
					}
					if (_tmp631_) {
						ValaSourceReference* _tmp636_;
						ValaSourceReference* _tmp637_;
						_tmp636_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp637_ = _tmp636_;
						vala_report_error (_tmp637_, "`resize' is not allowed for unowned array references");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
				}
				_vala_code_node_unref0 (inner_type);
			}
		}
	}
	_tmp641_ = vala_member_access_get_inner (self);
	_tmp642_ = _tmp641_;
	if (_tmp642_ == NULL) {
		ValaSymbol* _tmp643_;
		ValaSymbol* _tmp644_;
		_tmp643_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp644_ = _tmp643_;
		_tmp640_ = _tmp644_ == NULL;
	} else {
		_tmp640_ = FALSE;
	}
	if (_tmp640_) {
		ValaDataType* _tmp645_;
		ValaDataType* _tmp646_;
		_tmp645_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp646_ = _tmp645_;
		_tmp639_ = _tmp646_ != NULL;
	} else {
		_tmp639_ = FALSE;
	}
	if (_tmp639_) {
		ValaDataType* _tmp647_;
		ValaDataType* _tmp648_;
		ValaTypeSymbol* _tmp649_;
		ValaTypeSymbol* _tmp650_;
		_tmp647_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp648_ = _tmp647_;
		_tmp649_ = vala_data_type_get_type_symbol (_tmp648_);
		_tmp650_ = _tmp649_;
		_tmp638_ = VALA_IS_ENUM (_tmp650_);
	} else {
		_tmp638_ = FALSE;
	}
	if (_tmp638_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp651_;
		ValaDataType* _tmp652_;
		ValaTypeSymbol* _tmp653_;
		ValaTypeSymbol* _tmp654_;
		_tmp651_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp652_ = _tmp651_;
		_tmp653_ = vala_data_type_get_type_symbol (_tmp652_);
		_tmp654_ = _tmp653_;
		enum_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp654_, VALA_TYPE_ENUM, ValaEnum);
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp655_;
			ValaList* _tmp656_;
			ValaList* _tmp657_;
			gint _val_size = 0;
			ValaList* _tmp658_;
			gint _tmp659_;
			gint _tmp660_;
			gint _val_index = 0;
			_tmp655_ = enum_type;
			_tmp656_ = vala_enum_get_values (_tmp655_);
			_tmp657_ = _vala_iterable_ref0 (_tmp656_);
			_val_list = _tmp657_;
			_tmp658_ = _val_list;
			_tmp659_ = vala_collection_get_size ((ValaCollection*) _tmp658_);
			_tmp660_ = _tmp659_;
			_val_size = _tmp660_;
			_val_index = -1;
			while (TRUE) {
				ValaEnumValue* val = NULL;
				ValaList* _tmp661_;
				gpointer _tmp662_;
				const gchar* _tmp663_;
				ValaEnumValue* _tmp664_;
				const gchar* _tmp665_;
				const gchar* _tmp666_;
				_val_index = _val_index + 1;
				if (!(_val_index < _val_size)) {
					break;
				}
				_tmp661_ = _val_list;
				_tmp662_ = vala_list_get (_tmp661_, _val_index);
				val = (ValaEnumValue*) _tmp662_;
				_tmp663_ = self->priv->_member_name;
				_tmp664_ = val;
				_tmp665_ = vala_symbol_get_name ((ValaSymbol*) _tmp664_);
				_tmp666_ = _tmp665_;
				if (g_strcmp0 (_tmp663_, _tmp666_) == 0) {
					ValaEnumValue* _tmp667_;
					_tmp667_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp667_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
			_vala_iterable_unref0 (_val_list);
		}
	}
	_tmp668_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp669_ = _tmp668_;
	if (_tmp669_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp670_;
		ValaSymbol* base_type = NULL;
		gboolean _tmp671_ = FALSE;
		ValaExpression* _tmp672_;
		ValaExpression* _tmp673_;
		gchar* base_type_package = NULL;
		gchar* _tmp693_;
		gboolean _tmp694_ = FALSE;
		ValaSymbol* _tmp695_;
		gchar* visited_types_string = NULL;
		gchar* _tmp710_;
		ValaSourceReference* _tmp725_;
		ValaSourceReference* _tmp726_;
		const gchar* _tmp727_;
		const gchar* _tmp728_;
		const gchar* _tmp729_;
		const gchar* _tmp730_;
		gchar* _tmp731_;
		gchar* _tmp732_;
		ValaInvalidType* _tmp733_;
		ValaInvalidType* _tmp734_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp670_ = g_strdup ("(null)");
		base_type_name = _tmp670_;
		base_type = NULL;
		_tmp672_ = vala_member_access_get_inner (self);
		_tmp673_ = _tmp672_;
		if (_tmp673_ != NULL) {
			ValaExpression* _tmp674_;
			ValaExpression* _tmp675_;
			ValaDataType* _tmp676_;
			ValaDataType* _tmp677_;
			_tmp674_ = vala_member_access_get_inner (self);
			_tmp675_ = _tmp674_;
			_tmp676_ = vala_expression_get_value_type (_tmp675_);
			_tmp677_ = _tmp676_;
			_tmp671_ = _tmp677_ != NULL;
		} else {
			_tmp671_ = FALSE;
		}
		if (_tmp671_) {
			ValaExpression* _tmp678_;
			ValaExpression* _tmp679_;
			ValaDataType* _tmp680_;
			ValaDataType* _tmp681_;
			gchar* _tmp682_;
			ValaExpression* _tmp683_;
			ValaExpression* _tmp684_;
			ValaDataType* _tmp685_;
			ValaDataType* _tmp686_;
			ValaTypeSymbol* _tmp687_;
			ValaTypeSymbol* _tmp688_;
			_tmp678_ = vala_member_access_get_inner (self);
			_tmp679_ = _tmp678_;
			_tmp680_ = vala_expression_get_value_type (_tmp679_);
			_tmp681_ = _tmp680_;
			_tmp682_ = vala_code_node_to_string ((ValaCodeNode*) _tmp681_);
			_g_free0 (base_type_name);
			base_type_name = _tmp682_;
			_tmp683_ = vala_member_access_get_inner (self);
			_tmp684_ = _tmp683_;
			_tmp685_ = vala_expression_get_value_type (_tmp684_);
			_tmp686_ = _tmp685_;
			_tmp687_ = vala_data_type_get_type_symbol (_tmp686_);
			_tmp688_ = _tmp687_;
			base_type = (ValaSymbol*) _tmp688_;
		} else {
			ValaSymbol* _tmp689_;
			_tmp689_ = base_symbol;
			if (_tmp689_ != NULL) {
				ValaSymbol* _tmp690_;
				gchar* _tmp691_;
				ValaSymbol* _tmp692_;
				_tmp690_ = base_symbol;
				_tmp691_ = vala_symbol_get_full_name (_tmp690_);
				_g_free0 (base_type_name);
				base_type_name = _tmp691_;
				_tmp692_ = base_symbol;
				base_type = _tmp692_;
			}
		}
		_tmp693_ = g_strdup ("");
		base_type_package = _tmp693_;
		_tmp695_ = base_type;
		if (_tmp695_ != NULL) {
			ValaSymbol* _tmp696_;
			gboolean _tmp697_;
			gboolean _tmp698_;
			_tmp696_ = base_type;
			_tmp697_ = vala_symbol_get_external_package (_tmp696_);
			_tmp698_ = _tmp697_;
			_tmp694_ = _tmp698_;
		} else {
			_tmp694_ = FALSE;
		}
		if (_tmp694_) {
			ValaSymbol* _tmp699_;
			ValaSourceReference* _tmp700_;
			ValaSourceReference* _tmp701_;
			ValaSourceFile* _tmp702_;
			ValaSourceFile* _tmp703_;
			const gchar* _tmp704_;
			const gchar* _tmp705_;
			gchar* _tmp706_;
			const gchar* _tmp707_;
			_tmp699_ = base_symbol;
			_tmp700_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp699_);
			_tmp701_ = _tmp700_;
			_tmp702_ = vala_source_reference_get_file (_tmp701_);
			_tmp703_ = _tmp702_;
			_tmp704_ = vala_source_file_get_package_name (_tmp703_);
			_tmp705_ = _tmp704_;
			_tmp706_ = g_strdup (_tmp705_);
			_g_free0 (base_type_package);
			base_type_package = _tmp706_;
			_tmp707_ = base_type_package;
			if (_tmp707_ != NULL) {
				const gchar* _tmp708_;
				gchar* _tmp709_;
				_tmp708_ = base_type_package;
				_tmp709_ = g_strdup_printf (" (%s)", _tmp708_);
				_g_free0 (base_type_package);
				base_type_package = _tmp709_;
			}
		}
		_tmp710_ = g_strdup ("");
		visited_types_string = _tmp710_;
		{
			ValaArrayList* _type_list = NULL;
			ValaArrayList* _tmp711_;
			ValaArrayList* _tmp712_;
			gint _type_size = 0;
			ValaArrayList* _tmp713_;
			gint _tmp714_;
			gint _tmp715_;
			gint _type_index = 0;
			_tmp711_ = visited_types;
			_tmp712_ = _vala_iterable_ref0 (_tmp711_);
			_type_list = _tmp712_;
			_tmp713_ = _type_list;
			_tmp714_ = vala_collection_get_size ((ValaCollection*) _tmp713_);
			_tmp715_ = _tmp714_;
			_type_size = _tmp715_;
			_type_index = -1;
			while (TRUE) {
				ValaDataType* type = NULL;
				ValaArrayList* _tmp716_;
				gpointer _tmp717_;
				const gchar* _tmp718_;
				ValaDataType* _tmp719_;
				gchar* _tmp720_;
				gchar* _tmp721_;
				gchar* _tmp722_;
				gchar* _tmp723_;
				gchar* _tmp724_;
				_type_index = _type_index + 1;
				if (!(_type_index < _type_size)) {
					break;
				}
				_tmp716_ = _type_list;
				_tmp717_ = vala_list_get ((ValaList*) _tmp716_, _type_index);
				type = (ValaDataType*) _tmp717_;
				_tmp718_ = visited_types_string;
				_tmp719_ = type;
				_tmp720_ = vala_code_node_to_string ((ValaCodeNode*) _tmp719_);
				_tmp721_ = _tmp720_;
				_tmp722_ = g_strdup_printf (" or `%s'", _tmp721_);
				_tmp723_ = _tmp722_;
				_tmp724_ = g_strconcat (_tmp718_, _tmp723_, NULL);
				_g_free0 (visited_types_string);
				visited_types_string = _tmp724_;
				_g_free0 (_tmp723_);
				_g_free0 (_tmp721_);
				_vala_code_node_unref0 (type);
			}
			_vala_iterable_unref0 (_type_list);
		}
		_tmp725_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp726_ = _tmp725_;
		_tmp727_ = self->priv->_member_name;
		_tmp728_ = base_type_name;
		_tmp729_ = base_type_package;
		_tmp730_ = visited_types_string;
		_tmp731_ = g_strdup_printf ("The name `%s' does not exist in the context of `%s'%s%s", _tmp727_, _tmp728_, _tmp729_, _tmp730_);
		_tmp732_ = _tmp731_;
		vala_report_error (_tmp726_, _tmp732_);
		_g_free0 (_tmp732_);
		_tmp733_ = vala_invalid_type_new ();
		_tmp734_ = _tmp733_;
		vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp734_);
		_vala_code_node_unref0 (_tmp734_);
		result = FALSE;
		_g_free0 (visited_types_string);
		_g_free0 (base_type_package);
		_g_free0 (base_type_name);
		_vala_iterable_unref0 (visited_types);
		return result;
	} else {
		ValaSymbol* _tmp735_;
		ValaSymbol* _tmp736_;
		gboolean _tmp737_;
		gboolean _tmp738_;
		_tmp735_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp736_ = _tmp735_;
		_tmp737_ = vala_code_node_get_error ((ValaCodeNode*) _tmp736_);
		_tmp738_ = _tmp737_;
		if (_tmp738_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	}
	_tmp739_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp740_ = _tmp739_;
	if (VALA_IS_SIGNAL (_tmp740_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp741_;
		ValaSymbol* _tmp742_;
		ValaCodeNode* ma = NULL;
		ValaCodeNode* parent = NULL;
		ValaCodeNode* _tmp749_;
		ValaCodeNode* _tmp750_;
		ValaCodeNode* _tmp751_;
		gboolean _tmp752_ = FALSE;
		gboolean _tmp753_ = FALSE;
		gboolean _tmp754_ = FALSE;
		ValaCodeNode* _tmp755_;
		_tmp741_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp742_ = _tmp741_;
		sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp742_, VALA_TYPE_SIGNAL, ValaSignal);
		ma = (ValaCodeNode*) self;
		while (TRUE) {
			ValaCodeNode* _tmp743_;
			ValaCodeNode* _tmp744_;
			ValaCodeNode* _tmp745_;
			ValaCodeNode* _tmp746_;
			ValaCodeNode* _tmp747_;
			ValaCodeNode* _tmp748_;
			_tmp743_ = ma;
			_tmp744_ = vala_code_node_get_parent_node (_tmp743_);
			_tmp745_ = _tmp744_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp745_)) {
				break;
			}
			_tmp746_ = ma;
			_tmp747_ = vala_code_node_get_parent_node (_tmp746_);
			_tmp748_ = _tmp747_;
			ma = _tmp748_;
		}
		_tmp749_ = ma;
		_tmp750_ = vala_code_node_get_parent_node (_tmp749_);
		_tmp751_ = _tmp750_;
		parent = _tmp751_;
		_tmp755_ = parent;
		if (_tmp755_ != NULL) {
			ValaCodeNode* _tmp756_;
			_tmp756_ = parent;
			_tmp754_ = !VALA_IS_ELEMENT_ACCESS (_tmp756_);
		} else {
			_tmp754_ = FALSE;
		}
		if (_tmp754_) {
			ValaCodeNode* _tmp757_;
			ValaExpression* _tmp758_;
			ValaExpression* _tmp759_;
			_tmp757_ = ma;
			_tmp758_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp757_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp759_ = _tmp758_;
			_tmp753_ = !VALA_IS_BASE_ACCESS (_tmp759_);
		} else {
			_tmp753_ = FALSE;
		}
		if (_tmp753_) {
			gboolean _tmp760_ = FALSE;
			ValaCodeNode* _tmp761_;
			_tmp761_ = parent;
			if (!VALA_IS_METHOD_CALL (_tmp761_)) {
				_tmp760_ = TRUE;
			} else {
				ValaCodeNode* _tmp762_;
				ValaList* _tmp763_;
				_tmp762_ = parent;
				_tmp763_ = vala_method_call_get_argument_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp762_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
				_tmp760_ = vala_collection_contains ((ValaCollection*) _tmp763_, (ValaExpression*) self);
			}
			_tmp752_ = _tmp760_;
		} else {
			_tmp752_ = FALSE;
		}
		if (_tmp752_) {
			ValaSignal* _tmp764_;
			ValaAttribute* _tmp765_;
			_tmp764_ = sig;
			_tmp765_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp764_, "HasEmitter");
			if (_tmp765_ != NULL) {
				ValaSignal* _tmp766_;
				ValaSignal* _tmp767_;
				ValaMethod* _tmp768_;
				ValaMethod* _tmp769_;
				_tmp766_ = sig;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp766_, context)) {
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
				_tmp767_ = sig;
				_tmp768_ = vala_signal_get_emitter (_tmp767_);
				_tmp769_ = _tmp768_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp769_);
			} else {
				ValaSourceReference* _tmp770_;
				ValaSourceReference* _tmp771_;
				ValaSymbol* _tmp772_;
				ValaSymbol* _tmp773_;
				gchar* _tmp774_;
				gchar* _tmp775_;
				gchar* _tmp776_;
				gchar* _tmp777_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp770_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp771_ = _tmp770_;
				_tmp772_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp773_ = _tmp772_;
				_tmp774_ = vala_symbol_get_full_name (_tmp773_);
				_tmp775_ = _tmp774_;
				_tmp776_ = g_strdup_printf ("Signal `%s' requires emitter in this context", _tmp775_);
				_tmp777_ = _tmp776_;
				vala_report_error (_tmp771_, _tmp777_);
				_g_free0 (_tmp777_);
				_g_free0 (_tmp775_);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
		}
	}
	_tmp778_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp779_ = _tmp778_;
	member = _tmp779_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp780_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp780_, context)) {
		result = FALSE;
		_vala_iterable_unref0 (visited_types);
		return result;
	}
	_tmp781_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp781_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp782_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp783_;
		ValaSymbol* _tmp784_;
		ValaSymbol* _tmp785_;
		gboolean _tmp786_ = FALSE;
		ValaBlock* _tmp787_;
		_tmp782_ = member;
		local = G_TYPE_CHECK_INSTANCE_CAST (_tmp782_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
		_tmp783_ = local;
		_tmp784_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp783_);
		_tmp785_ = _tmp784_;
		block = VALA_IS_BLOCK (_tmp785_) ? ((ValaBlock*) _tmp785_) : NULL;
		_tmp787_ = block;
		if (_tmp787_ != NULL) {
			ValaBlock* _tmp788_;
			ValaSymbol* _tmp789_;
			ValaSemanticAnalyzer* _tmp790_;
			ValaSemanticAnalyzer* _tmp791_;
			ValaSymbol* _tmp792_;
			ValaSymbol* _tmp793_;
			_tmp788_ = block;
			_tmp789_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp788_);
			_tmp790_ = vala_code_context_get_analyzer (context);
			_tmp791_ = _tmp790_;
			_tmp792_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp791_);
			_tmp793_ = _tmp792_;
			_tmp786_ = _tmp789_ != _tmp793_;
		} else {
			_tmp786_ = FALSE;
		}
		if (_tmp786_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp794_;
			ValaSemanticAnalyzer* _tmp795_;
			ValaSymbol* _tmp796_;
			ValaSymbol* _tmp797_;
			ValaLocalVariable* _tmp808_;
			ValaBlock* _tmp809_;
			_tmp794_ = vala_code_context_get_analyzer (context);
			_tmp795_ = _tmp794_;
			_tmp796_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp795_);
			_tmp797_ = _tmp796_;
			sym = _tmp797_;
			while (TRUE) {
				ValaSymbol* _tmp798_;
				ValaBlock* _tmp799_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp800_;
				ValaMethod* _tmp801_;
				ValaSymbol* _tmp805_;
				ValaSymbol* _tmp806_;
				ValaSymbol* _tmp807_;
				_tmp798_ = sym;
				_tmp799_ = block;
				if (!(_tmp798_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp799_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp800_ = sym;
				method = VALA_IS_METHOD (_tmp800_) ? ((ValaMethod*) _tmp800_) : NULL;
				_tmp801_ = method;
				if (_tmp801_ != NULL) {
					ValaMethod* _tmp802_;
					ValaMethod* _tmp803_;
					ValaLocalVariable* _tmp804_;
					_tmp802_ = method;
					vala_method_set_closure (_tmp802_, TRUE);
					_tmp803_ = method;
					_tmp804_ = local;
					vala_method_add_captured_variable (_tmp803_, _tmp804_);
				}
				_tmp805_ = sym;
				_tmp806_ = vala_symbol_get_parent_symbol (_tmp805_);
				_tmp807_ = _tmp806_;
				sym = _tmp807_;
			}
			_tmp808_ = local;
			vala_local_variable_set_captured (_tmp808_, TRUE);
			_tmp809_ = block;
			vala_block_set_captured (_tmp809_, TRUE);
		}
	} else {
		ValaSymbol* _tmp810_;
		_tmp810_ = member;
		if (VALA_IS_PARAMETER (_tmp810_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp811_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp812_;
			ValaSymbol* _tmp813_;
			ValaSymbol* _tmp814_;
			gboolean _tmp815_ = FALSE;
			gboolean _tmp816_ = FALSE;
			ValaMethod* _tmp817_;
			_tmp811_ = member;
			param = G_TYPE_CHECK_INSTANCE_CAST (_tmp811_, VALA_TYPE_PARAMETER, ValaParameter);
			_tmp812_ = param;
			_tmp813_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp812_);
			_tmp814_ = _tmp813_;
			m = VALA_IS_METHOD (_tmp814_) ? ((ValaMethod*) _tmp814_) : NULL;
			_tmp817_ = m;
			if (_tmp817_ != NULL) {
				ValaMethod* _tmp818_;
				ValaSemanticAnalyzer* _tmp819_;
				ValaSemanticAnalyzer* _tmp820_;
				ValaSymbol* _tmp821_;
				ValaSymbol* _tmp822_;
				_tmp818_ = m;
				_tmp819_ = vala_code_context_get_analyzer (context);
				_tmp820_ = _tmp819_;
				_tmp821_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp820_);
				_tmp822_ = _tmp821_;
				_tmp816_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp818_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp822_;
			} else {
				_tmp816_ = FALSE;
			}
			if (_tmp816_) {
				ValaParameter* _tmp823_;
				ValaMethod* _tmp824_;
				ValaParameter* _tmp825_;
				ValaParameter* _tmp826_;
				_tmp823_ = param;
				_tmp824_ = m;
				_tmp825_ = vala_method_get_this_parameter (_tmp824_);
				_tmp826_ = _tmp825_;
				_tmp815_ = _tmp823_ != _tmp826_;
			} else {
				_tmp815_ = FALSE;
			}
			if (_tmp815_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp827_;
				ValaSemanticAnalyzer* _tmp828_;
				ValaSymbol* _tmp829_;
				ValaSymbol* _tmp830_;
				ValaParameter* _tmp839_;
				ValaMethod* _tmp840_;
				ValaBlock* _tmp841_;
				ValaBlock* _tmp842_;
				ValaParameter* _tmp843_;
				ValaParameterDirection _tmp844_;
				ValaParameterDirection _tmp845_;
				_tmp827_ = vala_code_context_get_analyzer (context);
				_tmp828_ = _tmp827_;
				_tmp829_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp828_);
				_tmp830_ = _tmp829_;
				sym = _tmp830_;
				while (TRUE) {
					ValaSymbol* _tmp831_;
					ValaMethod* _tmp832_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp833_;
					ValaMethod* _tmp834_;
					ValaSymbol* _tmp836_;
					ValaSymbol* _tmp837_;
					ValaSymbol* _tmp838_;
					_tmp831_ = sym;
					_tmp832_ = m;
					if (!(_tmp831_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp832_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp833_ = sym;
					method = VALA_IS_METHOD (_tmp833_) ? ((ValaMethod*) _tmp833_) : NULL;
					_tmp834_ = method;
					if (_tmp834_ != NULL) {
						ValaMethod* _tmp835_;
						_tmp835_ = method;
						vala_method_set_closure (_tmp835_, TRUE);
					}
					_tmp836_ = sym;
					_tmp837_ = vala_symbol_get_parent_symbol (_tmp836_);
					_tmp838_ = _tmp837_;
					sym = _tmp838_;
				}
				_tmp839_ = param;
				vala_parameter_set_captured (_tmp839_, TRUE);
				_tmp840_ = m;
				_tmp841_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp840_);
				_tmp842_ = _tmp841_;
				vala_block_set_captured (_tmp842_, TRUE);
				_tmp843_ = param;
				_tmp844_ = vala_parameter_get_direction (_tmp843_);
				_tmp845_ = _tmp844_;
				if (_tmp845_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp846_;
					ValaSourceReference* _tmp847_;
					ValaParameter* _tmp848_;
					gchar* _tmp849_;
					gchar* _tmp850_;
					gchar* _tmp851_;
					gchar* _tmp852_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp846_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp847_ = _tmp846_;
					_tmp848_ = param;
					_tmp849_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp848_);
					_tmp850_ = _tmp849_;
					_tmp851_ = g_strdup_printf ("Cannot capture reference or output parameter `%s'", _tmp850_);
					_tmp852_ = _tmp851_;
					vala_report_error (_tmp847_, _tmp852_);
					_g_free0 (_tmp852_);
					_g_free0 (_tmp850_);
				}
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp853_;
				ValaSymbol* _tmp854_;
				ValaSymbol* _tmp855_;
				ValaSymbol* _tmp856_;
				ValaSymbol* _tmp857_;
				gboolean _tmp858_ = FALSE;
				gboolean _tmp859_ = FALSE;
				ValaPropertyAccessor* _tmp860_;
				_tmp853_ = param;
				_tmp854_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp853_);
				_tmp855_ = _tmp854_;
				_tmp856_ = vala_symbol_get_parent_symbol (_tmp855_);
				_tmp857_ = _tmp856_;
				acc = VALA_IS_PROPERTY_ACCESSOR (_tmp857_) ? ((ValaPropertyAccessor*) _tmp857_) : NULL;
				_tmp860_ = acc;
				if (_tmp860_ != NULL) {
					ValaPropertyAccessor* _tmp861_;
					ValaSemanticAnalyzer* _tmp862_;
					ValaSemanticAnalyzer* _tmp863_;
					ValaSymbol* _tmp864_;
					ValaSymbol* _tmp865_;
					_tmp861_ = acc;
					_tmp862_ = vala_code_context_get_analyzer (context);
					_tmp863_ = _tmp862_;
					_tmp864_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp863_);
					_tmp865_ = _tmp864_;
					_tmp859_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp861_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp865_;
				} else {
					_tmp859_ = FALSE;
				}
				if (_tmp859_) {
					ValaParameter* _tmp866_;
					ValaPropertyAccessor* _tmp867_;
					ValaProperty* _tmp868_;
					ValaProperty* _tmp869_;
					ValaParameter* _tmp870_;
					ValaParameter* _tmp871_;
					_tmp866_ = param;
					_tmp867_ = acc;
					_tmp868_ = vala_property_accessor_get_prop (_tmp867_);
					_tmp869_ = _tmp868_;
					_tmp870_ = vala_property_get_this_parameter (_tmp869_);
					_tmp871_ = _tmp870_;
					_tmp858_ = _tmp866_ != _tmp871_;
				} else {
					_tmp858_ = FALSE;
				}
				if (_tmp858_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp872_;
					ValaSemanticAnalyzer* _tmp873_;
					ValaSymbol* _tmp874_;
					ValaSymbol* _tmp875_;
					ValaParameter* _tmp884_;
					ValaPropertyAccessor* _tmp885_;
					ValaBlock* _tmp886_;
					ValaBlock* _tmp887_;
					_tmp872_ = vala_code_context_get_analyzer (context);
					_tmp873_ = _tmp872_;
					_tmp874_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp873_);
					_tmp875_ = _tmp874_;
					sym = _tmp875_;
					while (TRUE) {
						ValaSymbol* _tmp876_;
						ValaMethod* _tmp877_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp878_;
						ValaMethod* _tmp879_;
						ValaSymbol* _tmp881_;
						ValaSymbol* _tmp882_;
						ValaSymbol* _tmp883_;
						_tmp876_ = sym;
						_tmp877_ = m;
						if (!(_tmp876_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp877_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp878_ = sym;
						method = VALA_IS_METHOD (_tmp878_) ? ((ValaMethod*) _tmp878_) : NULL;
						_tmp879_ = method;
						if (_tmp879_ != NULL) {
							ValaMethod* _tmp880_;
							_tmp880_ = method;
							vala_method_set_closure (_tmp880_, TRUE);
						}
						_tmp881_ = sym;
						_tmp882_ = vala_symbol_get_parent_symbol (_tmp881_);
						_tmp883_ = _tmp882_;
						sym = _tmp883_;
					}
					_tmp884_ = param;
					vala_parameter_set_captured (_tmp884_, TRUE);
					_tmp885_ = acc;
					_tmp886_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp885_);
					_tmp887_ = _tmp886_;
					vala_block_set_captured (_tmp887_, TRUE);
				}
			}
		} else {
			ValaSymbol* _tmp888_;
			_tmp888_ = member;
			if (VALA_IS_FIELD (_tmp888_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp889_;
				ValaField* _tmp890_;
				ValaSymbolAccessibility _tmp891_;
				ValaSymbolAccessibility _tmp892_;
				ValaField* _tmp893_;
				ValaMemberBinding _tmp894_;
				ValaMemberBinding _tmp895_;
				ValaField* _tmp896_;
				ValaMemberBinding _tmp897_;
				ValaMemberBinding _tmp898_;
				ValaField* _tmp899_;
				ValaDataType* _tmp900_;
				ValaDataType* _tmp901_;
				_tmp889_ = member;
				f = G_TYPE_CHECK_INSTANCE_CAST (_tmp889_, VALA_TYPE_FIELD, ValaField);
				_tmp890_ = f;
				_tmp891_ = vala_symbol_get_access ((ValaSymbol*) _tmp890_);
				_tmp892_ = _tmp891_;
				access = _tmp892_;
				_tmp893_ = f;
				_tmp894_ = vala_field_get_binding (_tmp893_);
				_tmp895_ = _tmp894_;
				instance = _tmp895_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp896_ = f;
				_tmp897_ = vala_field_get_binding (_tmp896_);
				_tmp898_ = _tmp897_;
				klass = _tmp898_ == VALA_MEMBER_BINDING_CLASS;
				_tmp899_ = f;
				_tmp900_ = vala_variable_get_variable_type ((ValaVariable*) _tmp899_);
				_tmp901_ = _tmp900_;
				if (VALA_IS_GENERIC_TYPE (_tmp901_)) {
					generics = TRUE;
				}
			} else {
				ValaSymbol* _tmp902_;
				_tmp902_ = member;
				if (VALA_IS_CONSTANT (_tmp902_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp903_;
					ValaConstant* _tmp904_;
					ValaSymbolAccessibility _tmp905_;
					ValaSymbolAccessibility _tmp906_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp907_;
					ValaSymbol* _tmp908_;
					ValaSymbol* _tmp909_;
					gboolean _tmp910_ = FALSE;
					ValaBlock* _tmp911_;
					_tmp903_ = member;
					c = G_TYPE_CHECK_INSTANCE_CAST (_tmp903_, VALA_TYPE_CONSTANT, ValaConstant);
					_tmp904_ = c;
					_tmp905_ = vala_symbol_get_access ((ValaSymbol*) _tmp904_);
					_tmp906_ = _tmp905_;
					access = _tmp906_;
					_tmp907_ = c;
					_tmp908_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp907_);
					_tmp909_ = _tmp908_;
					block = VALA_IS_BLOCK (_tmp909_) ? ((ValaBlock*) _tmp909_) : NULL;
					_tmp911_ = block;
					if (_tmp911_ != NULL) {
						ValaBlock* _tmp912_;
						ValaSymbol* _tmp913_;
						ValaSemanticAnalyzer* _tmp914_;
						ValaSemanticAnalyzer* _tmp915_;
						ValaSymbol* _tmp916_;
						ValaSymbol* _tmp917_;
						_tmp912_ = block;
						_tmp913_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp912_);
						_tmp914_ = vala_code_context_get_analyzer (context);
						_tmp915_ = _tmp914_;
						_tmp916_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp915_);
						_tmp917_ = _tmp916_;
						_tmp910_ = _tmp913_ != _tmp917_;
					} else {
						_tmp910_ = FALSE;
					}
					if (_tmp910_) {
						ValaSourceReference* _tmp918_;
						ValaSourceReference* _tmp919_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp918_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp919_ = _tmp918_;
						vala_report_error (_tmp919_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						_vala_iterable_unref0 (visited_types);
						return result;
					}
				} else {
					ValaSymbol* _tmp920_;
					_tmp920_ = member;
					if (VALA_IS_METHOD (_tmp920_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp921_;
						ValaMethod* _tmp922_;
						gboolean _tmp923_;
						gboolean _tmp924_;
						ValaMethod* _tmp1013_;
						ValaSymbolAccessibility _tmp1014_;
						ValaSymbolAccessibility _tmp1015_;
						ValaMethod* _tmp1016_;
						ValaMethod* _tmp1020_;
						ValaMemberBinding _tmp1021_;
						ValaMemberBinding _tmp1022_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp1041_;
						ValaDataType* _tmp1042_;
						ValaDataType* _tmp1043_;
						gboolean _tmp1044_ = FALSE;
						ValaGenericType* _tmp1045_;
						_tmp921_ = member;
						m = G_TYPE_CHECK_INSTANCE_CAST (_tmp921_, VALA_TYPE_METHOD, ValaMethod);
						_tmp922_ = m;
						_tmp923_ = vala_method_get_is_async_callback (_tmp922_);
						_tmp924_ = _tmp923_;
						if (_tmp924_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp925_;
							ValaSemanticAnalyzer* _tmp926_;
							ValaMethod* _tmp927_;
							ValaMethod* _tmp928_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp929_;
							ValaMethod* _tmp958_;
							ValaSemanticAnalyzer* _tmp959_;
							ValaSemanticAnalyzer* _tmp960_;
							ValaMethod* _tmp961_;
							ValaMethod* _tmp962_;
							ValaMethod* _tmp978_;
							ValaMethod* _tmp979_;
							ValaMethod* _tmp980_;
							ValaSymbol* _tmp981_;
							ValaSymbol* _tmp982_;
							_tmp925_ = vala_code_context_get_analyzer (context);
							_tmp926_ = _tmp925_;
							_tmp927_ = vala_semantic_analyzer_get_current_async_method (_tmp926_);
							_tmp928_ = _tmp927_;
							async_method = _tmp928_;
							is_valid_access = FALSE;
							_tmp929_ = async_method;
							if (_tmp929_ != NULL) {
								ValaMethod* _tmp930_;
								ValaMethod* _tmp931_;
								ValaMethod* _tmp932_;
								_tmp930_ = m;
								_tmp931_ = async_method;
								_tmp932_ = vala_method_get_callback_method (_tmp931_);
								if (_tmp930_ == _tmp932_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp933_ = FALSE;
									ValaMethod* _tmp934_;
									ValaMethod* _tmp935_;
									ValaMethod* _tmp936_;
									_tmp934_ = async_method;
									_tmp935_ = vala_method_get_base_method (_tmp934_);
									_tmp936_ = _tmp935_;
									if (_tmp936_ != NULL) {
										ValaMethod* _tmp937_;
										ValaMethod* _tmp938_;
										ValaMethod* _tmp939_;
										ValaMethod* _tmp940_;
										ValaMethod* _tmp941_;
										_tmp937_ = m;
										_tmp938_ = async_method;
										_tmp939_ = vala_method_get_base_method (_tmp938_);
										_tmp940_ = _tmp939_;
										_tmp941_ = vala_method_get_callback_method (_tmp940_);
										_tmp933_ = _tmp937_ == _tmp941_;
									} else {
										_tmp933_ = FALSE;
									}
									if (_tmp933_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp942_ = FALSE;
										ValaMethod* _tmp943_;
										ValaMethod* _tmp944_;
										ValaMethod* _tmp945_;
										_tmp943_ = async_method;
										_tmp944_ = vala_method_get_base_interface_method (_tmp943_);
										_tmp945_ = _tmp944_;
										if (_tmp945_ != NULL) {
											ValaMethod* _tmp946_;
											ValaMethod* _tmp947_;
											ValaMethod* _tmp948_;
											ValaMethod* _tmp949_;
											ValaMethod* _tmp950_;
											_tmp946_ = m;
											_tmp947_ = async_method;
											_tmp948_ = vala_method_get_base_interface_method (_tmp947_);
											_tmp949_ = _tmp948_;
											_tmp950_ = vala_method_get_callback_method (_tmp949_);
											_tmp942_ = _tmp946_ == _tmp950_;
										} else {
											_tmp942_ = FALSE;
										}
										if (_tmp942_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp951_;
								ValaSourceReference* _tmp952_;
								ValaMethod* _tmp953_;
								gchar* _tmp954_;
								gchar* _tmp955_;
								gchar* _tmp956_;
								gchar* _tmp957_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp951_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp952_ = _tmp951_;
								_tmp953_ = m;
								_tmp954_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp953_);
								_tmp955_ = _tmp954_;
								_tmp956_ = g_strdup_printf ("Access to async callback `%s' not allowed in this context", _tmp955_);
								_tmp957_ = _tmp956_;
								vala_report_error (_tmp952_, _tmp957_);
								_g_free0 (_tmp957_);
								_g_free0 (_tmp955_);
								result = FALSE;
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp958_ = async_method;
							_tmp959_ = vala_code_context_get_analyzer (context);
							_tmp960_ = _tmp959_;
							_tmp961_ = vala_semantic_analyzer_get_current_method (_tmp960_);
							_tmp962_ = _tmp961_;
							if (_tmp958_ != _tmp962_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp963_;
								ValaSemanticAnalyzer* _tmp964_;
								ValaMethod* _tmp965_;
								ValaMethod* _tmp966_;
								ValaMethod* _tmp975_;
								ValaBlock* _tmp976_;
								ValaBlock* _tmp977_;
								_tmp963_ = vala_code_context_get_analyzer (context);
								_tmp964_ = _tmp963_;
								_tmp965_ = vala_semantic_analyzer_get_current_method (_tmp964_);
								_tmp966_ = _tmp965_;
								sym = (ValaSymbol*) _tmp966_;
								while (TRUE) {
									ValaSymbol* _tmp967_;
									ValaMethod* _tmp968_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp969_;
									ValaMethod* _tmp970_;
									ValaSymbol* _tmp972_;
									ValaSymbol* _tmp973_;
									ValaSymbol* _tmp974_;
									_tmp967_ = sym;
									_tmp968_ = async_method;
									if (!(_tmp967_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp968_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp969_ = sym;
									method = VALA_IS_METHOD (_tmp969_) ? ((ValaMethod*) _tmp969_) : NULL;
									_tmp970_ = method;
									if (_tmp970_ != NULL) {
										ValaMethod* _tmp971_;
										_tmp971_ = method;
										vala_method_set_closure (_tmp971_, TRUE);
									}
									_tmp972_ = sym;
									_tmp973_ = vala_symbol_get_parent_symbol (_tmp972_);
									_tmp974_ = _tmp973_;
									sym = _tmp974_;
								}
								_tmp975_ = async_method;
								_tmp976_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp975_);
								_tmp977_ = _tmp976_;
								vala_block_set_captured (_tmp977_, TRUE);
							}
							_tmp978_ = async_method;
							_tmp979_ = vala_method_get_callback_method (_tmp978_);
							m = _tmp979_;
							_tmp980_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp980_);
							_tmp981_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp982_ = _tmp981_;
							member = _tmp982_;
						} else {
							ValaMethod* _tmp983_;
							ValaMethod* _tmp984_;
							ValaMethod* _tmp985_;
							_tmp983_ = m;
							_tmp984_ = vala_method_get_base_method (_tmp983_);
							_tmp985_ = _tmp984_;
							if (_tmp985_ != NULL) {
								ValaMethod* _tmp986_;
								ValaMethod* _tmp987_;
								ValaMethod* _tmp988_;
								ValaMethod* _tmp989_;
								ValaSignal* _tmp990_;
								ValaSignal* _tmp991_;
								ValaSymbol* _tmp996_;
								ValaSymbol* _tmp997_;
								_tmp986_ = m;
								_tmp987_ = vala_method_get_base_method (_tmp986_);
								_tmp988_ = _tmp987_;
								m = _tmp988_;
								_tmp989_ = m;
								_tmp990_ = vala_method_get_signal_reference (_tmp989_);
								_tmp991_ = _tmp990_;
								if (_tmp991_ != NULL) {
									ValaMethod* _tmp992_;
									ValaSignal* _tmp993_;
									ValaSignal* _tmp994_;
									_tmp992_ = m;
									_tmp993_ = vala_method_get_signal_reference (_tmp992_);
									_tmp994_ = _tmp993_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp994_);
								} else {
									ValaMethod* _tmp995_;
									_tmp995_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp995_);
								}
								_tmp996_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp997_ = _tmp996_;
								member = _tmp997_;
							} else {
								ValaMethod* _tmp998_;
								ValaMethod* _tmp999_;
								ValaMethod* _tmp1000_;
								_tmp998_ = m;
								_tmp999_ = vala_method_get_base_interface_method (_tmp998_);
								_tmp1000_ = _tmp999_;
								if (_tmp1000_ != NULL) {
									ValaMethod* _tmp1001_;
									ValaMethod* _tmp1002_;
									ValaMethod* _tmp1003_;
									ValaMethod* _tmp1004_;
									ValaSignal* _tmp1005_;
									ValaSignal* _tmp1006_;
									ValaSymbol* _tmp1011_;
									ValaSymbol* _tmp1012_;
									_tmp1001_ = m;
									_tmp1002_ = vala_method_get_base_interface_method (_tmp1001_);
									_tmp1003_ = _tmp1002_;
									m = _tmp1003_;
									_tmp1004_ = m;
									_tmp1005_ = vala_method_get_signal_reference (_tmp1004_);
									_tmp1006_ = _tmp1005_;
									if (_tmp1006_ != NULL) {
										ValaMethod* _tmp1007_;
										ValaSignal* _tmp1008_;
										ValaSignal* _tmp1009_;
										_tmp1007_ = m;
										_tmp1008_ = vala_method_get_signal_reference (_tmp1007_);
										_tmp1009_ = _tmp1008_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1009_);
									} else {
										ValaMethod* _tmp1010_;
										_tmp1010_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1010_);
									}
									_tmp1011_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1012_ = _tmp1011_;
									member = _tmp1012_;
								}
							}
						}
						_tmp1013_ = m;
						_tmp1014_ = vala_symbol_get_access ((ValaSymbol*) _tmp1013_);
						_tmp1015_ = _tmp1014_;
						access = _tmp1015_;
						_tmp1016_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp1016_)) {
							ValaMethod* _tmp1017_;
							ValaMemberBinding _tmp1018_;
							ValaMemberBinding _tmp1019_;
							_tmp1017_ = m;
							_tmp1018_ = vala_method_get_binding (_tmp1017_);
							_tmp1019_ = _tmp1018_;
							instance = _tmp1019_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp1020_ = m;
						_tmp1021_ = vala_method_get_binding (_tmp1020_);
						_tmp1022_ = _tmp1021_;
						klass = _tmp1022_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp1023_;
							ValaList* _tmp1024_;
							ValaList* _tmp1025_;
							gint _param_size = 0;
							ValaList* _tmp1026_;
							gint _tmp1027_;
							gint _tmp1028_;
							gint _param_index = 0;
							_tmp1023_ = m;
							_tmp1024_ = vala_callable_get_parameters ((ValaCallable*) _tmp1023_);
							_tmp1025_ = _vala_iterable_ref0 (_tmp1024_);
							_param_list = _tmp1025_;
							_tmp1026_ = _param_list;
							_tmp1027_ = vala_collection_get_size ((ValaCollection*) _tmp1026_);
							_tmp1028_ = _tmp1027_;
							_param_size = _tmp1028_;
							_param_index = -1;
							while (TRUE) {
								ValaParameter* param = NULL;
								ValaList* _tmp1029_;
								gpointer _tmp1030_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp1031_;
								ValaDataType* _tmp1032_;
								ValaDataType* _tmp1033_;
								gboolean _tmp1034_ = FALSE;
								ValaGenericType* _tmp1035_;
								_param_index = _param_index + 1;
								if (!(_param_index < _param_size)) {
									break;
								}
								_tmp1029_ = _param_list;
								_tmp1030_ = vala_list_get (_tmp1029_, _param_index);
								param = (ValaParameter*) _tmp1030_;
								_tmp1031_ = param;
								_tmp1032_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1031_);
								_tmp1033_ = _tmp1032_;
								generic_type = VALA_IS_GENERIC_TYPE (_tmp1033_) ? ((ValaGenericType*) _tmp1033_) : NULL;
								_tmp1035_ = generic_type;
								if (_tmp1035_ != NULL) {
									ValaGenericType* _tmp1036_;
									ValaTypeParameter* _tmp1037_;
									ValaTypeParameter* _tmp1038_;
									ValaSymbol* _tmp1039_;
									ValaSymbol* _tmp1040_;
									_tmp1036_ = generic_type;
									_tmp1037_ = vala_generic_type_get_type_parameter (_tmp1036_);
									_tmp1038_ = _tmp1037_;
									_tmp1039_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1038_);
									_tmp1040_ = _tmp1039_;
									_tmp1034_ = VALA_IS_TYPESYMBOL (_tmp1040_);
								} else {
									_tmp1034_ = FALSE;
								}
								if (_tmp1034_) {
									generics = TRUE;
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp1041_ = m;
						_tmp1042_ = vala_callable_get_return_type ((ValaCallable*) _tmp1041_);
						_tmp1043_ = _tmp1042_;
						generic_type = VALA_IS_GENERIC_TYPE (_tmp1043_) ? ((ValaGenericType*) _tmp1043_) : NULL;
						_tmp1045_ = generic_type;
						if (_tmp1045_ != NULL) {
							ValaGenericType* _tmp1046_;
							ValaTypeParameter* _tmp1047_;
							ValaTypeParameter* _tmp1048_;
							ValaSymbol* _tmp1049_;
							ValaSymbol* _tmp1050_;
							_tmp1046_ = generic_type;
							_tmp1047_ = vala_generic_type_get_type_parameter (_tmp1046_);
							_tmp1048_ = _tmp1047_;
							_tmp1049_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1048_);
							_tmp1050_ = _tmp1049_;
							_tmp1044_ = VALA_IS_TYPESYMBOL (_tmp1050_);
						} else {
							_tmp1044_ = FALSE;
						}
						if (_tmp1044_) {
							generics = TRUE;
						}
					} else {
						ValaSymbol* _tmp1051_;
						_tmp1051_ = member;
						if (VALA_IS_PROPERTY (_tmp1051_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp1052_;
							ValaProperty* _tmp1053_;
							ValaProperty* _tmp1054_;
							ValaProperty* _tmp1055_;
							ValaProperty* _tmp1056_;
							ValaProperty* _tmp1072_;
							ValaSymbolAccessibility _tmp1073_;
							ValaSymbolAccessibility _tmp1074_;
							gboolean _tmp1075_;
							gboolean _tmp1076_;
							ValaProperty* _tmp1141_;
							ValaMemberBinding _tmp1142_;
							ValaMemberBinding _tmp1143_;
							ValaProperty* _tmp1144_;
							ValaDataType* _tmp1145_;
							ValaDataType* _tmp1146_;
							_tmp1052_ = member;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp1052_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp1053_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp1053_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp1054_ = prop;
							_tmp1055_ = vala_property_get_base_property (_tmp1054_);
							_tmp1056_ = _tmp1055_;
							if (_tmp1056_ != NULL) {
								ValaProperty* _tmp1057_;
								ValaProperty* _tmp1058_;
								ValaProperty* _tmp1059_;
								ValaProperty* _tmp1060_;
								ValaSymbol* _tmp1061_;
								ValaSymbol* _tmp1062_;
								_tmp1057_ = prop;
								_tmp1058_ = vala_property_get_base_property (_tmp1057_);
								_tmp1059_ = _tmp1058_;
								prop = _tmp1059_;
								_tmp1060_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1060_);
								_tmp1061_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1062_ = _tmp1061_;
								member = _tmp1062_;
							} else {
								ValaProperty* _tmp1063_;
								ValaProperty* _tmp1064_;
								ValaProperty* _tmp1065_;
								_tmp1063_ = prop;
								_tmp1064_ = vala_property_get_base_interface_property (_tmp1063_);
								_tmp1065_ = _tmp1064_;
								if (_tmp1065_ != NULL) {
									ValaProperty* _tmp1066_;
									ValaProperty* _tmp1067_;
									ValaProperty* _tmp1068_;
									ValaProperty* _tmp1069_;
									ValaSymbol* _tmp1070_;
									ValaSymbol* _tmp1071_;
									_tmp1066_ = prop;
									_tmp1067_ = vala_property_get_base_interface_property (_tmp1066_);
									_tmp1068_ = _tmp1067_;
									prop = _tmp1068_;
									_tmp1069_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1069_);
									_tmp1070_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1071_ = _tmp1070_;
									member = _tmp1071_;
								}
							}
							_tmp1072_ = prop;
							_tmp1073_ = vala_symbol_get_access ((ValaSymbol*) _tmp1072_);
							_tmp1074_ = _tmp1073_;
							access = _tmp1074_;
							_tmp1075_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp1076_ = _tmp1075_;
							if (_tmp1076_) {
								ValaProperty* _tmp1077_;
								ValaPropertyAccessor* _tmp1078_;
								ValaPropertyAccessor* _tmp1079_;
								ValaProperty* _tmp1087_;
								ValaSymbolAccessibility _tmp1088_;
								ValaSymbolAccessibility _tmp1089_;
								_tmp1077_ = prop;
								_tmp1078_ = vala_property_get_set_accessor (_tmp1077_);
								_tmp1079_ = _tmp1078_;
								if (_tmp1079_ == NULL) {
									ValaSourceReference* _tmp1080_;
									ValaSourceReference* _tmp1081_;
									ValaProperty* _tmp1082_;
									gchar* _tmp1083_;
									gchar* _tmp1084_;
									gchar* _tmp1085_;
									gchar* _tmp1086_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1080_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1081_ = _tmp1080_;
									_tmp1082_ = prop;
									_tmp1083_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1082_);
									_tmp1084_ = _tmp1083_;
									_tmp1085_ = g_strdup_printf ("Property `%s' is read-only", _tmp1084_);
									_tmp1086_ = _tmp1085_;
									vala_report_error (_tmp1081_, _tmp1086_);
									_g_free0 (_tmp1086_);
									_g_free0 (_tmp1084_);
									result = FALSE;
									_vala_iterable_unref0 (visited_types);
									return result;
								}
								_tmp1087_ = prop;
								_tmp1088_ = vala_symbol_get_access ((ValaSymbol*) _tmp1087_);
								_tmp1089_ = _tmp1088_;
								if (_tmp1089_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1090_;
									ValaPropertyAccessor* _tmp1091_;
									ValaPropertyAccessor* _tmp1092_;
									ValaSymbolAccessibility _tmp1093_;
									ValaSymbolAccessibility _tmp1094_;
									_tmp1090_ = prop;
									_tmp1091_ = vala_property_get_set_accessor (_tmp1090_);
									_tmp1092_ = _tmp1091_;
									_tmp1093_ = vala_symbol_get_access ((ValaSymbol*) _tmp1092_);
									_tmp1094_ = _tmp1093_;
									access = _tmp1094_;
								} else {
									gboolean _tmp1095_ = FALSE;
									ValaProperty* _tmp1096_;
									ValaSymbolAccessibility _tmp1097_;
									ValaSymbolAccessibility _tmp1098_;
									_tmp1096_ = prop;
									_tmp1097_ = vala_symbol_get_access ((ValaSymbol*) _tmp1096_);
									_tmp1098_ = _tmp1097_;
									if (_tmp1098_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1099_;
										ValaPropertyAccessor* _tmp1100_;
										ValaPropertyAccessor* _tmp1101_;
										ValaSymbolAccessibility _tmp1102_;
										ValaSymbolAccessibility _tmp1103_;
										_tmp1099_ = prop;
										_tmp1100_ = vala_property_get_set_accessor (_tmp1099_);
										_tmp1101_ = _tmp1100_;
										_tmp1102_ = vala_symbol_get_access ((ValaSymbol*) _tmp1101_);
										_tmp1103_ = _tmp1102_;
										_tmp1095_ = _tmp1103_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1095_ = FALSE;
									}
									if (_tmp1095_) {
										ValaProperty* _tmp1104_;
										ValaPropertyAccessor* _tmp1105_;
										ValaPropertyAccessor* _tmp1106_;
										ValaSymbolAccessibility _tmp1107_;
										ValaSymbolAccessibility _tmp1108_;
										_tmp1104_ = prop;
										_tmp1105_ = vala_property_get_set_accessor (_tmp1104_);
										_tmp1106_ = _tmp1105_;
										_tmp1107_ = vala_symbol_get_access ((ValaSymbol*) _tmp1106_);
										_tmp1108_ = _tmp1107_;
										access = _tmp1108_;
									}
								}
							} else {
								ValaProperty* _tmp1109_;
								ValaPropertyAccessor* _tmp1110_;
								ValaPropertyAccessor* _tmp1111_;
								ValaProperty* _tmp1119_;
								ValaSymbolAccessibility _tmp1120_;
								ValaSymbolAccessibility _tmp1121_;
								_tmp1109_ = prop;
								_tmp1110_ = vala_property_get_get_accessor (_tmp1109_);
								_tmp1111_ = _tmp1110_;
								if (_tmp1111_ == NULL) {
									ValaSourceReference* _tmp1112_;
									ValaSourceReference* _tmp1113_;
									ValaProperty* _tmp1114_;
									gchar* _tmp1115_;
									gchar* _tmp1116_;
									gchar* _tmp1117_;
									gchar* _tmp1118_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1112_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1113_ = _tmp1112_;
									_tmp1114_ = prop;
									_tmp1115_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1114_);
									_tmp1116_ = _tmp1115_;
									_tmp1117_ = g_strdup_printf ("Property `%s' is write-only", _tmp1116_);
									_tmp1118_ = _tmp1117_;
									vala_report_error (_tmp1113_, _tmp1118_);
									_g_free0 (_tmp1118_);
									_g_free0 (_tmp1116_);
									result = FALSE;
									_vala_iterable_unref0 (visited_types);
									return result;
								}
								_tmp1119_ = prop;
								_tmp1120_ = vala_symbol_get_access ((ValaSymbol*) _tmp1119_);
								_tmp1121_ = _tmp1120_;
								if (_tmp1121_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1122_;
									ValaPropertyAccessor* _tmp1123_;
									ValaPropertyAccessor* _tmp1124_;
									ValaSymbolAccessibility _tmp1125_;
									ValaSymbolAccessibility _tmp1126_;
									_tmp1122_ = prop;
									_tmp1123_ = vala_property_get_get_accessor (_tmp1122_);
									_tmp1124_ = _tmp1123_;
									_tmp1125_ = vala_symbol_get_access ((ValaSymbol*) _tmp1124_);
									_tmp1126_ = _tmp1125_;
									access = _tmp1126_;
								} else {
									gboolean _tmp1127_ = FALSE;
									ValaProperty* _tmp1128_;
									ValaSymbolAccessibility _tmp1129_;
									ValaSymbolAccessibility _tmp1130_;
									_tmp1128_ = prop;
									_tmp1129_ = vala_symbol_get_access ((ValaSymbol*) _tmp1128_);
									_tmp1130_ = _tmp1129_;
									if (_tmp1130_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1131_;
										ValaPropertyAccessor* _tmp1132_;
										ValaPropertyAccessor* _tmp1133_;
										ValaSymbolAccessibility _tmp1134_;
										ValaSymbolAccessibility _tmp1135_;
										_tmp1131_ = prop;
										_tmp1132_ = vala_property_get_get_accessor (_tmp1131_);
										_tmp1133_ = _tmp1132_;
										_tmp1134_ = vala_symbol_get_access ((ValaSymbol*) _tmp1133_);
										_tmp1135_ = _tmp1134_;
										_tmp1127_ = _tmp1135_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1127_ = FALSE;
									}
									if (_tmp1127_) {
										ValaProperty* _tmp1136_;
										ValaPropertyAccessor* _tmp1137_;
										ValaPropertyAccessor* _tmp1138_;
										ValaSymbolAccessibility _tmp1139_;
										ValaSymbolAccessibility _tmp1140_;
										_tmp1136_ = prop;
										_tmp1137_ = vala_property_get_get_accessor (_tmp1136_);
										_tmp1138_ = _tmp1137_;
										_tmp1139_ = vala_symbol_get_access ((ValaSymbol*) _tmp1138_);
										_tmp1140_ = _tmp1139_;
										access = _tmp1140_;
									}
								}
							}
							_tmp1141_ = prop;
							_tmp1142_ = vala_property_get_binding (_tmp1141_);
							_tmp1143_ = _tmp1142_;
							instance = _tmp1143_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1144_ = prop;
							_tmp1145_ = vala_property_get_property_type (_tmp1144_);
							_tmp1146_ = _tmp1145_;
							if (VALA_IS_GENERIC_TYPE (_tmp1146_)) {
								generics = TRUE;
							}
						} else {
							ValaSymbol* _tmp1147_;
							_tmp1147_ = member;
							if (VALA_IS_SIGNAL (_tmp1147_)) {
								ValaSymbol* _tmp1148_;
								ValaSymbolAccessibility _tmp1149_;
								ValaSymbolAccessibility _tmp1150_;
								instance = TRUE;
								_tmp1148_ = member;
								_tmp1149_ = vala_symbol_get_access (_tmp1148_);
								_tmp1150_ = _tmp1149_;
								access = _tmp1150_;
							} else {
								gboolean _tmp1151_ = FALSE;
								gboolean _tmp1152_;
								_tmp1152_ = self->priv->_creation_member;
								if (!_tmp1152_) {
									ValaSymbol* _tmp1153_;
									_tmp1153_ = member;
									_tmp1151_ = VALA_IS_ERROR_CODE (_tmp1153_);
								} else {
									_tmp1151_ = FALSE;
								}
								if (_tmp1151_) {
									ValaSymbol* _tmp1154_;
									ValaConstant* _tmp1155_;
									ValaConstant* _tmp1156_;
									ValaSymbol* _tmp1157_;
									ValaSymbol* _tmp1158_;
									_tmp1154_ = member;
									_tmp1155_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp1154_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp1156_ = _tmp1155_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1156_);
									_tmp1157_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1158_ = _tmp1157_;
									member = _tmp1158_;
								}
							}
						}
					}
				}
			}
		}
	}
	parent = (ValaCodeNode*) self;
	while (TRUE) {
		ValaCodeNode* _tmp1159_;
		ValaSymbol* _tmp1160_;
		ValaCodeNode* _tmp1161_;
		ValaCodeNode* _tmp1162_;
		ValaCodeNode* _tmp1163_;
		gboolean _tmp1164_ = FALSE;
		ValaCodeNode* _tmp1165_;
		_tmp1159_ = parent;
		_tmp1160_ = member;
		if (!(_tmp1159_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1160_, VALA_TYPE_CODE_NODE, ValaCodeNode))) {
			break;
		}
		_tmp1161_ = parent;
		_tmp1162_ = vala_code_node_get_parent_node (_tmp1161_);
		_tmp1163_ = _tmp1162_;
		parent = _tmp1163_;
		_tmp1165_ = parent;
		if (_tmp1165_ == NULL) {
			_tmp1164_ = TRUE;
		} else {
			ValaCodeNode* _tmp1166_;
			ValaSymbol* _tmp1167_;
			_tmp1166_ = parent;
			_tmp1167_ = member;
			_tmp1164_ = _tmp1166_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1167_, VALA_TYPE_CODE_NODE, ValaCodeNode);
		}
		if (_tmp1164_) {
			break;
		}
	}
	_tmp1168_ = parent;
	_tmp1169_ = member;
	if (_tmp1168_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1169_, VALA_TYPE_CODE_NODE, ValaCodeNode)) {
		ValaSymbol* _tmp1170_;
		_tmp1170_ = member;
		vala_symbol_set_used (_tmp1170_, TRUE);
	}
	_tmp1171_ = member;
	_tmp1172_ = vala_symbol_get_version (_tmp1171_);
	_tmp1173_ = _tmp1172_;
	_tmp1174_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1175_ = _tmp1174_;
	vala_version_attribute_check (_tmp1173_, context, _tmp1175_);
	_tmp1177_ = access;
	if (_tmp1177_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1178_;
		ValaSymbol* _tmp1179_;
		ValaSymbol* _tmp1180_;
		_tmp1178_ = member;
		_tmp1179_ = vala_symbol_get_parent_symbol (_tmp1178_);
		_tmp1180_ = _tmp1179_;
		_tmp1176_ = VALA_IS_TYPESYMBOL (_tmp1180_);
	} else {
		_tmp1176_ = FALSE;
	}
	if (_tmp1176_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1181_;
		ValaSymbol* _tmp1182_;
		ValaSymbol* _tmp1183_;
		gboolean in_subtype = FALSE;
		_tmp1181_ = member;
		_tmp1182_ = vala_symbol_get_parent_symbol (_tmp1181_);
		_tmp1183_ = _tmp1182_;
		target_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp1183_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1184_;
			ValaSemanticAnalyzer* _tmp1185_;
			ValaSymbol* _tmp1186_;
			ValaSymbol* _tmp1187_;
			ValaSymbol* _tmp1188_;
			_tmp1184_ = vala_code_context_get_analyzer (context);
			_tmp1185_ = _tmp1184_;
			_tmp1186_ = vala_semantic_analyzer_get_current_symbol (_tmp1185_);
			_tmp1187_ = _tmp1186_;
			_tmp1188_ = _vala_code_node_ref0 (_tmp1187_);
			this_symbol = _tmp1188_;
			{
				gboolean _tmp1189_ = FALSE;
				_tmp1189_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1194_;
					ValaSymbol* _tmp1195_;
					ValaTypeSymbol* _tmp1196_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1197_;
					gboolean _tmp1198_ = FALSE;
					ValaClass* _tmp1199_;
					if (!_tmp1189_) {
						ValaSymbol* _tmp1190_;
						ValaSymbol* _tmp1191_;
						ValaSymbol* _tmp1192_;
						ValaSymbol* _tmp1193_;
						_tmp1190_ = this_symbol;
						_tmp1191_ = vala_symbol_get_parent_symbol (_tmp1190_);
						_tmp1192_ = _tmp1191_;
						_tmp1193_ = _vala_code_node_ref0 (_tmp1192_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1193_;
					}
					_tmp1189_ = FALSE;
					_tmp1194_ = this_symbol;
					if (!(_tmp1194_ != NULL)) {
						break;
					}
					_tmp1195_ = this_symbol;
					_tmp1196_ = target_type;
					if (_tmp1195_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1196_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1197_ = this_symbol;
					cl = VALA_IS_CLASS (_tmp1197_) ? ((ValaClass*) _tmp1197_) : NULL;
					_tmp1199_ = cl;
					if (_tmp1199_ != NULL) {
						ValaClass* _tmp1200_;
						ValaTypeSymbol* _tmp1201_;
						_tmp1200_ = cl;
						_tmp1201_ = target_type;
						_tmp1198_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1200_, _tmp1201_);
					} else {
						_tmp1198_ = FALSE;
					}
					if (_tmp1198_) {
						in_subtype = TRUE;
						break;
					}
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1202_;
			ValaSourceReference* _tmp1203_;
			ValaSymbol* _tmp1204_;
			gchar* _tmp1205_;
			gchar* _tmp1206_;
			gchar* _tmp1207_;
			gchar* _tmp1208_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1202_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1203_ = _tmp1202_;
			_tmp1204_ = member;
			_tmp1205_ = vala_symbol_get_full_name (_tmp1204_);
			_tmp1206_ = _tmp1205_;
			_tmp1207_ = g_strdup_printf ("Access to protected member `%s' denied", _tmp1206_);
			_tmp1208_ = _tmp1207_;
			vala_report_error (_tmp1203_, _tmp1208_);
			_g_free0 (_tmp1208_);
			_g_free0 (_tmp1206_);
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	} else {
		ValaSymbolAccessibility _tmp1209_;
		_tmp1209_ = access;
		if (_tmp1209_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1210_;
			ValaSymbol* _tmp1211_;
			ValaSymbol* _tmp1212_;
			gboolean in_target_type = FALSE;
			_tmp1210_ = member;
			_tmp1211_ = vala_symbol_get_parent_symbol (_tmp1210_);
			_tmp1212_ = _tmp1211_;
			target_type = _tmp1212_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1213_;
				ValaSemanticAnalyzer* _tmp1214_;
				ValaSymbol* _tmp1215_;
				ValaSymbol* _tmp1216_;
				ValaSymbol* _tmp1217_;
				_tmp1213_ = vala_code_context_get_analyzer (context);
				_tmp1214_ = _tmp1213_;
				_tmp1215_ = vala_semantic_analyzer_get_current_symbol (_tmp1214_);
				_tmp1216_ = _tmp1215_;
				_tmp1217_ = _vala_code_node_ref0 (_tmp1216_);
				this_symbol = _tmp1217_;
				{
					gboolean _tmp1218_ = FALSE;
					_tmp1218_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1223_;
						ValaSymbol* _tmp1224_;
						ValaSymbol* _tmp1225_;
						if (!_tmp1218_) {
							ValaSymbol* _tmp1219_;
							ValaSymbol* _tmp1220_;
							ValaSymbol* _tmp1221_;
							ValaSymbol* _tmp1222_;
							_tmp1219_ = this_symbol;
							_tmp1220_ = vala_symbol_get_parent_symbol (_tmp1219_);
							_tmp1221_ = _tmp1220_;
							_tmp1222_ = _vala_code_node_ref0 (_tmp1221_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1222_;
						}
						_tmp1218_ = FALSE;
						_tmp1223_ = this_symbol;
						if (!(_tmp1223_ != NULL)) {
							break;
						}
						_tmp1224_ = target_type;
						_tmp1225_ = this_symbol;
						if (_tmp1224_ == _tmp1225_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1226_;
				ValaSourceReference* _tmp1227_;
				ValaSymbol* _tmp1228_;
				gchar* _tmp1229_;
				gchar* _tmp1230_;
				gchar* _tmp1231_;
				gchar* _tmp1232_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1226_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1227_ = _tmp1226_;
				_tmp1228_ = member;
				_tmp1229_ = vala_symbol_get_full_name (_tmp1228_);
				_tmp1230_ = _tmp1229_;
				_tmp1231_ = g_strdup_printf ("Access to private member `%s' denied", _tmp1230_);
				_tmp1232_ = _tmp1231_;
				vala_report_error (_tmp1227_, _tmp1232_);
				_g_free0 (_tmp1232_);
				_g_free0 (_tmp1230_);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
		}
	}
	if (generics) {
		ValaExpression* _tmp1234_;
		ValaExpression* _tmp1235_;
		_tmp1234_ = vala_member_access_get_inner (self);
		_tmp1235_ = _tmp1234_;
		_tmp1233_ = _tmp1235_ != NULL;
	} else {
		_tmp1233_ = FALSE;
	}
	if (_tmp1233_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1236_;
		ValaExpression* _tmp1237_;
		ValaDataType* _tmp1238_;
		ValaDataType* _tmp1239_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1240_;
		ValaExpression* _tmp1241_;
		ValaDataType* _tmp1242_;
		ValaDataType* _tmp1243_;
		ValaPointerType* _tmp1244_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1248_;
		gboolean _tmp1249_ = FALSE;
		gboolean _tmp1250_ = FALSE;
		ValaObjectType* _tmp1251_;
		_tmp1236_ = vala_member_access_get_inner (self);
		_tmp1237_ = _tmp1236_;
		_tmp1238_ = vala_expression_get_value_type (_tmp1237_);
		_tmp1239_ = _tmp1238_;
		instance_type = _tmp1239_;
		_tmp1240_ = vala_member_access_get_inner (self);
		_tmp1241_ = _tmp1240_;
		_tmp1242_ = vala_expression_get_value_type (_tmp1241_);
		_tmp1243_ = _tmp1242_;
		pointer_type = VALA_IS_POINTER_TYPE (_tmp1243_) ? ((ValaPointerType*) _tmp1243_) : NULL;
		_tmp1244_ = pointer_type;
		if (_tmp1244_ != NULL) {
			ValaPointerType* _tmp1245_;
			ValaDataType* _tmp1246_;
			ValaDataType* _tmp1247_;
			_tmp1245_ = pointer_type;
			_tmp1246_ = vala_pointer_type_get_base_type (_tmp1245_);
			_tmp1247_ = _tmp1246_;
			instance_type = _tmp1247_;
		}
		_tmp1248_ = instance_type;
		object_type = VALA_IS_OBJECT_TYPE (_tmp1248_) ? ((ValaObjectType*) _tmp1248_) : NULL;
		_tmp1251_ = object_type;
		if (_tmp1251_ != NULL) {
			ValaObjectType* _tmp1252_;
			ValaObjectTypeSymbol* _tmp1253_;
			ValaObjectTypeSymbol* _tmp1254_;
			_tmp1252_ = object_type;
			_tmp1253_ = vala_object_type_get_object_type_symbol (_tmp1252_);
			_tmp1254_ = _tmp1253_;
			_tmp1250_ = vala_object_type_symbol_has_type_parameters (_tmp1254_);
		} else {
			_tmp1250_ = FALSE;
		}
		if (_tmp1250_) {
			ValaDataType* _tmp1255_;
			_tmp1255_ = instance_type;
			_tmp1249_ = !vala_data_type_has_type_arguments (_tmp1255_);
		} else {
			_tmp1249_ = FALSE;
		}
		if (_tmp1249_) {
			ValaExpression* _tmp1256_;
			ValaExpression* _tmp1257_;
			ValaSourceReference* _tmp1258_;
			ValaSourceReference* _tmp1259_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1256_ = vala_member_access_get_inner (self);
			_tmp1257_ = _tmp1256_;
			_tmp1258_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1257_);
			_tmp1259_ = _tmp1258_;
			vala_report_error (_tmp1259_, "missing generic type arguments");
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	}
	if (instance) {
		_tmp1261_ = !may_access_instance_members;
	} else {
		_tmp1261_ = FALSE;
	}
	if (_tmp1261_) {
		_tmp1260_ = TRUE;
	} else {
		gboolean _tmp1262_ = FALSE;
		if (klass) {
			_tmp1262_ = !may_access_klass_members;
		} else {
			_tmp1262_ = FALSE;
		}
		_tmp1260_ = _tmp1262_;
	}
	if (_tmp1260_) {
		ValaSymbol* _tmp1263_;
		ValaSymbol* _tmp1264_;
		ValaDataType* _tmp1287_;
		ValaDataType* _tmp1288_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1263_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1264_ = _tmp1263_;
		if (VALA_IS_METHOD (_tmp1264_)) {
			ValaSemanticAnalyzer* _tmp1265_;
			ValaSemanticAnalyzer* _tmp1266_;
			ValaSymbol* _tmp1267_;
			ValaSymbol* _tmp1268_;
			gboolean _tmp1269_;
			gboolean _tmp1270_;
			ValaDataType* _tmp1271_;
			ValaDataType* _tmp1272_;
			_tmp1265_ = vala_code_context_get_analyzer (context);
			_tmp1266_ = _tmp1265_;
			_tmp1267_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1268_ = _tmp1267_;
			_tmp1269_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1270_ = _tmp1269_;
			_tmp1271_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1266_, _tmp1268_, _tmp1270_);
			_tmp1272_ = _tmp1271_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1272_);
			_vala_code_node_unref0 (_tmp1272_);
		} else {
			ValaSymbol* _tmp1273_;
			ValaSymbol* _tmp1274_;
			_tmp1273_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1274_ = _tmp1273_;
			if (VALA_IS_FIELD (_tmp1274_)) {
				ValaSymbol* _tmp1275_;
				ValaSymbol* _tmp1276_;
				ValaFieldPrototype* _tmp1277_;
				ValaFieldPrototype* _tmp1278_;
				_tmp1275_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1276_ = _tmp1275_;
				_tmp1277_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1276_, VALA_TYPE_FIELD, ValaField));
				_tmp1278_ = _tmp1277_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1278_);
				_vala_code_node_unref0 (_tmp1278_);
			} else {
				ValaSymbol* _tmp1279_;
				ValaSymbol* _tmp1280_;
				_tmp1279_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1280_ = _tmp1279_;
				if (VALA_IS_PROPERTY (_tmp1280_)) {
					ValaSymbol* _tmp1281_;
					ValaSymbol* _tmp1282_;
					ValaPropertyPrototype* _tmp1283_;
					ValaPropertyPrototype* _tmp1284_;
					_tmp1281_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1282_ = _tmp1281_;
					_tmp1283_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1282_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1284_ = _tmp1283_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1284_);
					_vala_code_node_unref0 (_tmp1284_);
				} else {
					ValaInvalidType* _tmp1285_;
					ValaInvalidType* _tmp1286_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp1285_ = vala_invalid_type_new ();
					_tmp1286_ = _tmp1285_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1286_);
					_vala_code_node_unref0 (_tmp1286_);
				}
			}
		}
		_tmp1287_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1288_ = _tmp1287_;
		if (_tmp1288_ != NULL) {
			ValaDataType* _tmp1289_;
			ValaDataType* _tmp1290_;
			ValaDataType* _tmp1291_;
			ValaDataType* _tmp1292_;
			gboolean _tmp1293_;
			gboolean _tmp1294_;
			_tmp1289_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1290_ = _tmp1289_;
			_tmp1291_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1292_ = _tmp1291_;
			_tmp1293_ = vala_data_type_get_value_owned (_tmp1292_);
			_tmp1294_ = _tmp1293_;
			vala_data_type_set_value_owned (_tmp1290_, _tmp1294_);
		}
	} else {
		gboolean _tmp1295_ = FALSE;
		gboolean _tmp1316_ = FALSE;
		gboolean _tmp1317_ = FALSE;
		gboolean _tmp1318_ = FALSE;
		gboolean _tmp1319_ = FALSE;
		gboolean _tmp1361_ = FALSE;
		gboolean _tmp1362_ = FALSE;
		gboolean _tmp1363_ = FALSE;
		gboolean _tmp1364_ = FALSE;
		gboolean _tmp1365_ = FALSE;
		gboolean _tmp1366_;
		gboolean _tmp1367_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1394_;
		ValaSymbol* _tmp1395_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1396_;
		ValaExpression* _tmp1397_;
		gboolean _tmp1398_ = FALSE;
		gboolean _tmp1399_ = FALSE;
		gboolean _tmp1400_ = FALSE;
		gboolean _tmp1401_ = FALSE;
		gboolean _tmp1402_ = FALSE;
		ValaMethod* _tmp1403_;
		ValaSemanticAnalyzer* _tmp1440_;
		ValaSemanticAnalyzer* _tmp1441_;
		ValaSymbol* _tmp1442_;
		ValaSymbol* _tmp1443_;
		gboolean _tmp1444_;
		gboolean _tmp1445_;
		ValaDataType* _tmp1446_;
		ValaDataType* _tmp1447_;
		gboolean _tmp1448_ = FALSE;
		ValaExpression* _tmp1449_;
		ValaExpression* _tmp1450_;
		ValaSymbol* _tmp1463_;
		ValaSymbol* _tmp1464_;
		if (instance) {
			ValaExpression* _tmp1296_;
			ValaExpression* _tmp1297_;
			_tmp1296_ = vala_member_access_get_inner (self);
			_tmp1297_ = _tmp1296_;
			_tmp1295_ = _tmp1297_ == NULL;
		} else {
			_tmp1295_ = FALSE;
		}
		if (_tmp1295_) {
			ValaSourceReference* _tmp1298_;
			ValaSourceReference* _tmp1299_;
			ValaMemberAccess* _tmp1300_;
			ValaMemberAccess* _tmp1301_;
			ValaExpression* _tmp1302_;
			ValaExpression* _tmp1303_;
			ValaParameter* _tmp1304_;
			ValaDataType* _tmp1305_;
			ValaDataType* _tmp1306_;
			ValaDataType* _tmp1307_;
			ValaDataType* _tmp1308_;
			ValaExpression* _tmp1309_;
			ValaExpression* _tmp1310_;
			ValaDataType* _tmp1311_;
			ValaDataType* _tmp1312_;
			ValaExpression* _tmp1313_;
			ValaExpression* _tmp1314_;
			ValaParameter* _tmp1315_;
			_tmp1298_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1299_ = _tmp1298_;
			_tmp1300_ = vala_member_access_new (NULL, "this", _tmp1299_);
			_tmp1301_ = _tmp1300_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1301_);
			_vala_code_node_unref0 (_tmp1301_);
			_tmp1302_ = vala_member_access_get_inner (self);
			_tmp1303_ = _tmp1302_;
			_tmp1304_ = this_parameter;
			_tmp1305_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1304_);
			_tmp1306_ = _tmp1305_;
			_tmp1307_ = vala_data_type_copy (_tmp1306_);
			_tmp1308_ = _tmp1307_;
			vala_expression_set_value_type (_tmp1303_, _tmp1308_);
			_vala_code_node_unref0 (_tmp1308_);
			_tmp1309_ = vala_member_access_get_inner (self);
			_tmp1310_ = _tmp1309_;
			_tmp1311_ = vala_expression_get_value_type (_tmp1310_);
			_tmp1312_ = _tmp1311_;
			vala_data_type_set_value_owned (_tmp1312_, FALSE);
			_tmp1313_ = vala_member_access_get_inner (self);
			_tmp1314_ = _tmp1313_;
			_tmp1315_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1314_, (ValaSymbol*) _tmp1315_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1319_ = !klass;
		} else {
			_tmp1319_ = FALSE;
		}
		if (_tmp1319_) {
			ValaSymbol* _tmp1320_;
			ValaSymbol* _tmp1321_;
			_tmp1320_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1321_ = _tmp1320_;
			_tmp1318_ = !VALA_IS_CREATION_METHOD (_tmp1321_);
		} else {
			_tmp1318_ = FALSE;
		}
		if (_tmp1318_) {
			_tmp1317_ = may_access_instance_members;
		} else {
			_tmp1317_ = FALSE;
		}
		if (_tmp1317_) {
			ValaExpression* _tmp1322_;
			ValaExpression* _tmp1323_;
			_tmp1322_ = vala_member_access_get_inner (self);
			_tmp1323_ = _tmp1322_;
			_tmp1316_ = _tmp1323_ != NULL;
		} else {
			_tmp1316_ = FALSE;
		}
		if (_tmp1316_) {
			ValaExpression* _tmp1324_;
			ValaExpression* _tmp1325_;
			ValaSymbol* _tmp1326_;
			ValaSymbol* _tmp1327_;
			_tmp1324_ = vala_member_access_get_inner (self);
			_tmp1325_ = _tmp1324_;
			_tmp1326_ = vala_expression_get_symbol_reference (_tmp1325_);
			_tmp1327_ = _tmp1326_;
			if (VALA_IS_METHOD (_tmp1327_)) {
			} else {
				ValaSourceReference* _tmp1328_;
				ValaSourceReference* _tmp1329_;
				ValaSymbol* _tmp1330_;
				ValaSymbol* _tmp1331_;
				gchar* _tmp1332_;
				gchar* _tmp1333_;
				gchar* _tmp1334_;
				gchar* _tmp1335_;
				ValaSymbol* inner_sym = NULL;
				ValaSymbol* _tmp1336_;
				ValaSymbol* _tmp1337_;
				ValaSymbol* _tmp1338_;
				ValaSymbol* _tmp1339_;
				ValaMemberAccess* inner_ma = NULL;
				ValaExpression* _tmp1359_;
				ValaExpression* _tmp1360_;
				_tmp1328_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1329_ = _tmp1328_;
				_tmp1330_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1331_ = _tmp1330_;
				_tmp1332_ = vala_symbol_get_full_name (_tmp1331_);
				_tmp1333_ = _tmp1332_;
				_tmp1334_ = g_strdup_printf ("Access to static member `%s' with an instance reference", _tmp1333_);
				_tmp1335_ = _tmp1334_;
				vala_report_warning (_tmp1329_, _tmp1335_);
				_g_free0 (_tmp1335_);
				_g_free0 (_tmp1333_);
				_tmp1336_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1337_ = _tmp1336_;
				_tmp1338_ = vala_symbol_get_parent_symbol (_tmp1337_);
				_tmp1339_ = _tmp1338_;
				inner_sym = _tmp1339_;
				inner_ma = self;
				while (TRUE) {
					gboolean _tmp1340_ = FALSE;
					ValaSymbol* _tmp1341_;
					ValaMemberAccess* _tmp1345_;
					ValaSymbol* _tmp1346_;
					const gchar* _tmp1347_;
					const gchar* _tmp1348_;
					ValaSourceReference* _tmp1349_;
					ValaSourceReference* _tmp1350_;
					ValaMemberAccess* _tmp1351_;
					ValaMemberAccess* _tmp1352_;
					ValaMemberAccess* _tmp1353_;
					ValaExpression* _tmp1354_;
					ValaExpression* _tmp1355_;
					ValaSymbol* _tmp1356_;
					ValaSymbol* _tmp1357_;
					ValaSymbol* _tmp1358_;
					_tmp1341_ = inner_sym;
					if (_tmp1341_ != NULL) {
						ValaSymbol* _tmp1342_;
						const gchar* _tmp1343_;
						const gchar* _tmp1344_;
						_tmp1342_ = inner_sym;
						_tmp1343_ = vala_symbol_get_name (_tmp1342_);
						_tmp1344_ = _tmp1343_;
						_tmp1340_ = _tmp1344_ != NULL;
					} else {
						_tmp1340_ = FALSE;
					}
					if (!_tmp1340_) {
						break;
					}
					_tmp1345_ = inner_ma;
					_tmp1346_ = inner_sym;
					_tmp1347_ = vala_symbol_get_name (_tmp1346_);
					_tmp1348_ = _tmp1347_;
					_tmp1349_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1350_ = _tmp1349_;
					_tmp1351_ = vala_member_access_new (NULL, _tmp1348_, _tmp1350_);
					_tmp1352_ = _tmp1351_;
					vala_member_access_set_inner (_tmp1345_, (ValaExpression*) _tmp1352_);
					_vala_code_node_unref0 (_tmp1352_);
					_tmp1353_ = inner_ma;
					_tmp1354_ = vala_member_access_get_inner (_tmp1353_);
					_tmp1355_ = _tmp1354_;
					inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp1355_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
					_tmp1356_ = inner_sym;
					_tmp1357_ = vala_symbol_get_parent_symbol (_tmp1356_);
					_tmp1358_ = _tmp1357_;
					inner_sym = _tmp1358_;
				}
				_tmp1359_ = vala_member_access_get_inner (self);
				_tmp1360_ = _tmp1359_;
				vala_code_node_check ((ValaCodeNode*) _tmp1360_, context);
			}
		}
		_tmp1366_ = vala_code_context_get_experimental_non_null (context);
		_tmp1367_ = _tmp1366_;
		if (_tmp1367_) {
			_tmp1365_ = instance;
		} else {
			_tmp1365_ = FALSE;
		}
		if (_tmp1365_) {
			ValaExpression* _tmp1368_;
			ValaExpression* _tmp1369_;
			ValaDataType* _tmp1370_;
			ValaDataType* _tmp1371_;
			gboolean _tmp1372_;
			gboolean _tmp1373_;
			_tmp1368_ = vala_member_access_get_inner (self);
			_tmp1369_ = _tmp1368_;
			_tmp1370_ = vala_expression_get_value_type (_tmp1369_);
			_tmp1371_ = _tmp1370_;
			_tmp1372_ = vala_data_type_get_nullable (_tmp1371_);
			_tmp1373_ = _tmp1372_;
			_tmp1364_ = _tmp1373_;
		} else {
			_tmp1364_ = FALSE;
		}
		if (_tmp1364_) {
			ValaExpression* _tmp1374_;
			ValaExpression* _tmp1375_;
			ValaDataType* _tmp1376_;
			ValaDataType* _tmp1377_;
			_tmp1374_ = vala_member_access_get_inner (self);
			_tmp1375_ = _tmp1374_;
			_tmp1376_ = vala_expression_get_value_type (_tmp1375_);
			_tmp1377_ = _tmp1376_;
			_tmp1363_ = !VALA_IS_POINTER_TYPE (_tmp1377_);
		} else {
			_tmp1363_ = FALSE;
		}
		if (_tmp1363_) {
			ValaExpression* _tmp1378_;
			ValaExpression* _tmp1379_;
			ValaDataType* _tmp1380_;
			ValaDataType* _tmp1381_;
			_tmp1378_ = vala_member_access_get_inner (self);
			_tmp1379_ = _tmp1378_;
			_tmp1380_ = vala_expression_get_value_type (_tmp1379_);
			_tmp1381_ = _tmp1380_;
			_tmp1362_ = !VALA_IS_GENERIC_TYPE (_tmp1381_);
		} else {
			_tmp1362_ = FALSE;
		}
		if (_tmp1362_) {
			ValaExpression* _tmp1382_;
			ValaExpression* _tmp1383_;
			ValaDataType* _tmp1384_;
			ValaDataType* _tmp1385_;
			_tmp1382_ = vala_member_access_get_inner (self);
			_tmp1383_ = _tmp1382_;
			_tmp1384_ = vala_expression_get_value_type (_tmp1383_);
			_tmp1385_ = _tmp1384_;
			_tmp1361_ = !VALA_IS_ARRAY_TYPE (_tmp1385_);
		} else {
			_tmp1361_ = FALSE;
		}
		if (_tmp1361_) {
			ValaSourceReference* _tmp1386_;
			ValaSourceReference* _tmp1387_;
			ValaSymbol* _tmp1388_;
			ValaSymbol* _tmp1389_;
			gchar* _tmp1390_;
			gchar* _tmp1391_;
			gchar* _tmp1392_;
			gchar* _tmp1393_;
			_tmp1386_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1387_ = _tmp1386_;
			_tmp1388_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1389_ = _tmp1388_;
			_tmp1390_ = vala_symbol_get_full_name (_tmp1389_);
			_tmp1391_ = _tmp1390_;
			_tmp1392_ = g_strdup_printf ("Access to instance member `%s' from nullable reference denied", _tmp1391_);
			_tmp1393_ = _tmp1392_;
			vala_report_error (_tmp1387_, _tmp1393_);
			_g_free0 (_tmp1393_);
			_g_free0 (_tmp1391_);
		}
		_tmp1394_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1395_ = _tmp1394_;
		m = VALA_IS_METHOD (_tmp1395_) ? ((ValaMethod*) _tmp1395_) : NULL;
		_tmp1396_ = vala_member_access_get_inner (self);
		_tmp1397_ = _tmp1396_;
		inner_ma = VALA_IS_MEMBER_ACCESS (_tmp1397_) ? ((ValaMemberAccess*) _tmp1397_) : NULL;
		_tmp1403_ = m;
		if (_tmp1403_ != NULL) {
			ValaMethod* _tmp1404_;
			ValaMemberBinding _tmp1405_;
			ValaMemberBinding _tmp1406_;
			_tmp1404_ = m;
			_tmp1405_ = vala_method_get_binding (_tmp1404_);
			_tmp1406_ = _tmp1405_;
			_tmp1402_ = _tmp1406_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1402_ = FALSE;
		}
		if (_tmp1402_) {
			ValaMethod* _tmp1407_;
			ValaSymbol* _tmp1408_;
			ValaSymbol* _tmp1409_;
			_tmp1407_ = m;
			_tmp1408_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1407_);
			_tmp1409_ = _tmp1408_;
			_tmp1401_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1409_);
		} else {
			_tmp1401_ = FALSE;
		}
		if (_tmp1401_) {
			ValaExpression* _tmp1410_;
			ValaExpression* _tmp1411_;
			_tmp1410_ = vala_member_access_get_inner (self);
			_tmp1411_ = _tmp1410_;
			_tmp1400_ = _tmp1411_ != NULL;
		} else {
			_tmp1400_ = FALSE;
		}
		if (_tmp1400_) {
			ValaExpression* _tmp1412_;
			ValaExpression* _tmp1413_;
			ValaDataType* _tmp1414_;
			ValaDataType* _tmp1415_;
			_tmp1412_ = vala_member_access_get_inner (self);
			_tmp1413_ = _tmp1412_;
			_tmp1414_ = vala_expression_get_value_type (_tmp1413_);
			_tmp1415_ = _tmp1414_;
			_tmp1399_ = _tmp1415_ == NULL;
		} else {
			_tmp1399_ = FALSE;
		}
		if (_tmp1399_) {
			ValaMemberAccess* _tmp1416_;
			ValaList* _tmp1417_;
			gint _tmp1418_;
			gint _tmp1419_;
			_tmp1416_ = inner_ma;
			_tmp1417_ = _tmp1416_->priv->type_argument_list;
			_tmp1418_ = vala_collection_get_size ((ValaCollection*) _tmp1417_);
			_tmp1419_ = _tmp1418_;
			_tmp1398_ = _tmp1419_ > 0;
		} else {
			_tmp1398_ = FALSE;
		}
		if (_tmp1398_) {
			ValaExpression* _tmp1420_;
			ValaExpression* _tmp1421_;
			ValaMethod* _tmp1422_;
			ValaSymbol* _tmp1423_;
			ValaSymbol* _tmp1424_;
			ValaObjectType* _tmp1425_;
			ValaObjectType* _tmp1426_;
			_tmp1420_ = vala_member_access_get_inner (self);
			_tmp1421_ = _tmp1420_;
			_tmp1422_ = m;
			_tmp1423_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1422_);
			_tmp1424_ = _tmp1423_;
			_tmp1425_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1424_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1426_ = _tmp1425_;
			vala_expression_set_value_type (_tmp1421_, (ValaDataType*) _tmp1426_);
			_vala_code_node_unref0 (_tmp1426_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1427_;
				ValaList* _tmp1428_;
				ValaList* _tmp1429_;
				gint _type_argument_size = 0;
				ValaList* _tmp1430_;
				gint _tmp1431_;
				gint _tmp1432_;
				gint _type_argument_index = 0;
				_tmp1427_ = inner_ma;
				_tmp1428_ = _tmp1427_->priv->type_argument_list;
				_tmp1429_ = _vala_iterable_ref0 (_tmp1428_);
				_type_argument_list = _tmp1429_;
				_tmp1430_ = _type_argument_list;
				_tmp1431_ = vala_collection_get_size ((ValaCollection*) _tmp1430_);
				_tmp1432_ = _tmp1431_;
				_type_argument_size = _tmp1432_;
				_type_argument_index = -1;
				while (TRUE) {
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1433_;
					gpointer _tmp1434_;
					ValaExpression* _tmp1435_;
					ValaExpression* _tmp1436_;
					ValaDataType* _tmp1437_;
					ValaDataType* _tmp1438_;
					ValaDataType* _tmp1439_;
					_type_argument_index = _type_argument_index + 1;
					if (!(_type_argument_index < _type_argument_size)) {
						break;
					}
					_tmp1433_ = _type_argument_list;
					_tmp1434_ = vala_list_get (_tmp1433_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1434_;
					_tmp1435_ = vala_member_access_get_inner (self);
					_tmp1436_ = _tmp1435_;
					_tmp1437_ = vala_expression_get_value_type (_tmp1436_);
					_tmp1438_ = _tmp1437_;
					_tmp1439_ = type_argument;
					vala_data_type_add_type_argument (_tmp1438_, _tmp1439_);
					_vala_code_node_unref0 (type_argument);
				}
				_vala_iterable_unref0 (_type_argument_list);
			}
		}
		_tmp1440_ = vala_code_context_get_analyzer (context);
		_tmp1441_ = _tmp1440_;
		_tmp1442_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1443_ = _tmp1442_;
		_tmp1444_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1445_ = _tmp1444_;
		_tmp1446_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1441_, _tmp1443_, _tmp1445_);
		_tmp1447_ = _tmp1446_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1447_);
		_vala_code_node_unref0 (_tmp1447_);
		_tmp1449_ = vala_member_access_get_inner (self);
		_tmp1450_ = _tmp1449_;
		if (_tmp1450_ != NULL) {
			ValaDataType* _tmp1451_;
			ValaDataType* _tmp1452_;
			_tmp1451_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1452_ = _tmp1451_;
			_tmp1448_ = _tmp1452_ != NULL;
		} else {
			_tmp1448_ = FALSE;
		}
		if (_tmp1448_) {
			ValaDataType* _tmp1453_;
			ValaDataType* _tmp1454_;
			ValaExpression* _tmp1455_;
			ValaExpression* _tmp1456_;
			ValaDataType* _tmp1457_;
			ValaDataType* _tmp1458_;
			ValaDataType* _tmp1459_;
			ValaDataType* _tmp1460_;
			_tmp1453_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1454_ = _tmp1453_;
			_tmp1455_ = vala_member_access_get_inner (self);
			_tmp1456_ = _tmp1455_;
			_tmp1457_ = vala_expression_get_value_type (_tmp1456_);
			_tmp1458_ = _tmp1457_;
			_tmp1459_ = vala_data_type_get_actual_type (_tmp1454_, _tmp1458_, NULL, (ValaCodeNode*) self);
			_tmp1460_ = _tmp1459_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1460_);
			_vala_code_node_unref0 (_tmp1460_);
		} else {
			ValaDataType* _tmp1461_;
			ValaDataType* _tmp1462_;
			_tmp1461_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1462_ = _tmp1461_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1462_);
		}
		_tmp1463_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1464_ = _tmp1463_;
		if (VALA_IS_METHOD (_tmp1464_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1465_;
			ValaSymbol* _tmp1466_;
			ValaDataType* _tmp1467_;
			ValaDataType* _tmp1468_;
			gboolean _tmp1475_ = FALSE;
			_tmp1465_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1466_ = _tmp1465_;
			method = G_TYPE_CHECK_INSTANCE_CAST (_tmp1466_, VALA_TYPE_METHOD, ValaMethod);
			_tmp1467_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1468_ = _tmp1467_;
			if (_tmp1468_ != NULL) {
				ValaDataType* _tmp1469_;
				ValaDataType* _tmp1470_;
				ValaDataType* _tmp1471_;
				ValaDataType* _tmp1472_;
				gboolean _tmp1473_;
				gboolean _tmp1474_;
				_tmp1469_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1470_ = _tmp1469_;
				_tmp1471_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1472_ = _tmp1471_;
				_tmp1473_ = vala_data_type_get_value_owned (_tmp1472_);
				_tmp1474_ = _tmp1473_;
				vala_data_type_set_value_owned (_tmp1470_, _tmp1474_);
			}
			if (instance) {
				ValaMethod* _tmp1476_;
				ValaSymbol* _tmp1477_;
				ValaSymbol* _tmp1478_;
				_tmp1476_ = method;
				_tmp1477_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1476_);
				_tmp1478_ = _tmp1477_;
				_tmp1475_ = VALA_IS_TYPESYMBOL (_tmp1478_);
			} else {
				_tmp1475_ = FALSE;
			}
			if (_tmp1475_) {
				ValaExpression* _tmp1479_;
				ValaExpression* _tmp1480_;
				ValaMethod* _tmp1481_;
				ValaSymbol* _tmp1482_;
				ValaSymbol* _tmp1483_;
				ValaDataType* _tmp1484_;
				ValaDataType* _tmp1485_;
				ValaExpression* _tmp1486_;
				ValaExpression* _tmp1487_;
				ValaDataType* _tmp1488_;
				ValaDataType* _tmp1489_;
				ValaMethod* _tmp1490_;
				ValaParameter* _tmp1491_;
				ValaParameter* _tmp1492_;
				ValaDataType* _tmp1493_;
				ValaDataType* _tmp1494_;
				gboolean _tmp1495_;
				gboolean _tmp1496_;
				_tmp1479_ = vala_member_access_get_inner (self);
				_tmp1480_ = _tmp1479_;
				_tmp1481_ = method;
				_tmp1482_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1481_);
				_tmp1483_ = _tmp1482_;
				_tmp1484_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1483_);
				_tmp1485_ = _tmp1484_;
				vala_expression_set_target_type (_tmp1480_, _tmp1485_);
				_vala_code_node_unref0 (_tmp1485_);
				_tmp1486_ = vala_member_access_get_inner (self);
				_tmp1487_ = _tmp1486_;
				_tmp1488_ = vala_expression_get_target_type (_tmp1487_);
				_tmp1489_ = _tmp1488_;
				_tmp1490_ = method;
				_tmp1491_ = vala_method_get_this_parameter (_tmp1490_);
				_tmp1492_ = _tmp1491_;
				_tmp1493_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1492_);
				_tmp1494_ = _tmp1493_;
				_tmp1495_ = vala_data_type_get_value_owned (_tmp1494_);
				_tmp1496_ = _tmp1495_;
				vala_data_type_set_value_owned (_tmp1489_, _tmp1496_);
			}
		} else {
			gboolean _tmp1497_ = FALSE;
			gboolean _tmp1498_ = FALSE;
			ValaSymbol* _tmp1499_;
			ValaSymbol* _tmp1500_;
			_tmp1499_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1500_ = _tmp1499_;
			if (VALA_IS_PROPERTY (_tmp1500_)) {
				_tmp1498_ = instance;
			} else {
				_tmp1498_ = FALSE;
			}
			if (_tmp1498_) {
				ValaSymbol* _tmp1501_;
				ValaSymbol* _tmp1502_;
				ValaSymbol* _tmp1503_;
				ValaSymbol* _tmp1504_;
				_tmp1501_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1502_ = _tmp1501_;
				_tmp1503_ = vala_symbol_get_parent_symbol (_tmp1502_);
				_tmp1504_ = _tmp1503_;
				_tmp1497_ = _tmp1504_ != NULL;
			} else {
				_tmp1497_ = FALSE;
			}
			if (_tmp1497_) {
				ValaExpression* _tmp1505_;
				ValaExpression* _tmp1506_;
				ValaSymbol* _tmp1507_;
				ValaSymbol* _tmp1508_;
				ValaSymbol* _tmp1509_;
				ValaSymbol* _tmp1510_;
				ValaDataType* _tmp1511_;
				ValaDataType* _tmp1512_;
				_tmp1505_ = vala_member_access_get_inner (self);
				_tmp1506_ = _tmp1505_;
				_tmp1507_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1508_ = _tmp1507_;
				_tmp1509_ = vala_symbol_get_parent_symbol (_tmp1508_);
				_tmp1510_ = _tmp1509_;
				_tmp1511_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1510_);
				_tmp1512_ = _tmp1511_;
				vala_expression_set_target_type (_tmp1506_, _tmp1512_);
				_vala_code_node_unref0 (_tmp1512_);
			} else {
				gboolean _tmp1513_ = FALSE;
				gboolean _tmp1514_ = FALSE;
				gboolean _tmp1515_ = FALSE;
				ValaSymbol* _tmp1516_;
				ValaSymbol* _tmp1517_;
				_tmp1516_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1517_ = _tmp1516_;
				if (VALA_IS_FIELD (_tmp1517_)) {
					_tmp1515_ = TRUE;
				} else {
					ValaSymbol* _tmp1518_;
					ValaSymbol* _tmp1519_;
					_tmp1518_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1519_ = _tmp1518_;
					_tmp1515_ = VALA_IS_SIGNAL (_tmp1519_);
				}
				if (_tmp1515_) {
					_tmp1514_ = instance;
				} else {
					_tmp1514_ = FALSE;
				}
				if (_tmp1514_) {
					ValaSymbol* _tmp1520_;
					ValaSymbol* _tmp1521_;
					ValaSymbol* _tmp1522_;
					ValaSymbol* _tmp1523_;
					_tmp1520_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1521_ = _tmp1520_;
					_tmp1522_ = vala_symbol_get_parent_symbol (_tmp1521_);
					_tmp1523_ = _tmp1522_;
					_tmp1513_ = _tmp1523_ != NULL;
				} else {
					_tmp1513_ = FALSE;
				}
				if (_tmp1513_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1524_;
					ValaSymbol* _tmp1525_;
					ValaSymbol* _tmp1526_;
					ValaSymbol* _tmp1527_;
					ValaDataType* _tmp1528_;
					ValaExpression* _tmp1529_;
					ValaExpression* _tmp1530_;
					ValaDataType* _tmp1531_;
					ValaExpression* _tmp1532_;
					ValaExpression* _tmp1533_;
					ValaDataType* _tmp1534_;
					ValaDataType* _tmp1535_;
					ValaDataType* _tmp1536_;
					ValaDataType* _tmp1537_;
					_tmp1524_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1525_ = _tmp1524_;
					_tmp1526_ = vala_symbol_get_parent_symbol (_tmp1525_);
					_tmp1527_ = _tmp1526_;
					_tmp1528_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1527_);
					parent_type = _tmp1528_;
					_tmp1529_ = vala_member_access_get_inner (self);
					_tmp1530_ = _tmp1529_;
					_tmp1531_ = parent_type;
					_tmp1532_ = vala_member_access_get_inner (self);
					_tmp1533_ = _tmp1532_;
					_tmp1534_ = vala_expression_get_value_type (_tmp1533_);
					_tmp1535_ = _tmp1534_;
					_tmp1536_ = vala_data_type_get_actual_type (_tmp1531_, _tmp1535_, NULL, (ValaCodeNode*) self);
					_tmp1537_ = _tmp1536_;
					vala_expression_set_target_type (_tmp1530_, _tmp1537_);
					_vala_code_node_unref0 (_tmp1537_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
	}
	_tmp1538_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1539_ = _tmp1538_;
	if (_tmp1539_ != NULL) {
		ValaDataType* _tmp1540_;
		ValaDataType* _tmp1541_;
		_tmp1540_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp1541_ = _tmp1540_;
		vala_code_node_check ((ValaCodeNode*) _tmp1541_, context);
	}
	_tmp1542_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1543_ = _tmp1542_;
	result = !_tmp1543_;
	_vala_iterable_unref0 (visited_types);
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp50_;
	ValaExpression* _tmp51_;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	ValaMemberAccess* _tmp54_;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp83_ = FALSE;
	ValaSymbol* _tmp84_;
	ValaSymbol* _tmp85_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_METHOD (_tmp11_)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (VALA_IS_PROPERTY (_tmp18_)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (VALA_IS_PARAMETER (_tmp27_)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp39_)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		ValaExpression* _tmp46_;
		ValaExpression* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		_tmp46_ = vala_member_access_get_inner (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_get_value_type (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp34_ = VALA_IS_ARRAY_TYPE (_tmp49_);
	}
	struct_or_array = _tmp34_;
	_tmp50_ = vala_member_access_get_inner (self);
	_tmp51_ = _tmp50_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL;
	_tmp54_ = ma;
	if (_tmp54_ == NULL) {
		_tmp53_ = struct_or_array;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		_tmp55_ = vala_member_access_get_inner (self);
		_tmp56_ = _tmp55_;
		_tmp52_ = VALA_IS_POINTER_INDIRECTION (_tmp56_);
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		ValaExpression* _tmp57_;
		ValaExpression* _tmp58_;
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		_tmp57_ = vala_member_access_get_inner (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp60_ = _tmp59_;
		ma = VALA_IS_MEMBER_ACCESS (_tmp60_) ? ((ValaMemberAccess*) _tmp60_) : NULL;
	}
	if (instance) {
		_tmp64_ = struct_or_array;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		gboolean _tmp65_ = FALSE;
		ValaSymbol* _tmp66_;
		ValaSymbol* _tmp67_;
		_tmp66_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp67_ = _tmp66_;
		if (VALA_IS_METHOD (_tmp67_)) {
			_tmp65_ = TRUE;
		} else {
			gboolean _tmp68_;
			gboolean _tmp69_;
			_tmp68_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp69_ = _tmp68_;
			_tmp65_ = _tmp69_;
		}
		_tmp63_ = _tmp65_;
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		gboolean _tmp70_ = FALSE;
		gboolean _tmp71_ = FALSE;
		ValaMemberAccess* _tmp72_;
		_tmp72_ = ma;
		if (_tmp72_ != NULL) {
			ValaMemberAccess* _tmp73_;
			ValaSymbol* _tmp74_;
			ValaSymbol* _tmp75_;
			_tmp73_ = ma;
			_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp71_ = VALA_IS_VARIABLE (_tmp75_);
		} else {
			_tmp71_ = FALSE;
		}
		if (_tmp71_) {
			_tmp70_ = TRUE;
		} else {
			ValaExpression* _tmp76_;
			ValaExpression* _tmp77_;
			_tmp76_ = vala_member_access_get_inner (self);
			_tmp77_ = _tmp76_;
			_tmp70_ = VALA_IS_ELEMENT_ACCESS (_tmp77_);
		}
		_tmp62_ = _tmp70_;
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		_tmp61_ = !this_access;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		ValaExpression* _tmp78_;
		ValaExpression* _tmp79_;
		ValaMemberAccess* _tmp80_;
		_tmp78_ = vala_member_access_get_inner (self);
		_tmp79_ = _tmp78_;
		vala_expression_set_lvalue (_tmp79_, TRUE);
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaMemberAccess* _tmp82_;
			_tmp81_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp81_, TRUE);
			_tmp82_ = ma;
			vala_member_access_check_lvalue_access (_tmp82_);
		}
	}
	_tmp84_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp85_ = _tmp84_;
	if (VALA_IS_METHOD (_tmp85_)) {
		ValaSymbol* _tmp86_;
		ValaSymbol* _tmp87_;
		ValaAttribute* _tmp88_;
		_tmp86_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp87_ = _tmp86_;
		_tmp88_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp83_ = _tmp88_ != NULL;
	} else {
		_tmp83_ = FALSE;
	}
	if (_tmp83_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp89_;
		ValaSymbol* _tmp90_;
		ValaSymbol* _tmp91_;
		ValaSymbol* _tmp92_;
		gboolean _tmp93_ = FALSE;
		gboolean _tmp94_ = FALSE;
		ValaClass* _tmp95_;
		_tmp89_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_METHOD, ValaMethod));
		_tmp92_ = _tmp91_;
		cl = VALA_IS_CLASS (_tmp92_) ? ((ValaClass*) _tmp92_) : NULL;
		_tmp95_ = cl;
		if (_tmp95_ != NULL) {
			ValaClass* _tmp96_;
			gboolean _tmp97_;
			gboolean _tmp98_;
			_tmp96_ = cl;
			_tmp97_ = vala_class_get_is_compact (_tmp96_);
			_tmp98_ = _tmp97_;
			_tmp94_ = _tmp98_;
		} else {
			_tmp94_ = FALSE;
		}
		if (_tmp94_) {
			ValaMemberAccess* _tmp99_;
			_tmp99_ = ma;
			_tmp93_ = _tmp99_ != NULL;
		} else {
			_tmp93_ = FALSE;
		}
		if (_tmp93_) {
			ValaMemberAccess* _tmp100_;
			ValaMemberAccess* _tmp101_;
			_tmp100_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp100_, TRUE);
			_tmp101_ = ma;
			vala_member_access_check_lvalue_access (_tmp101_);
		}
	}
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL;
	_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp7_ = _tmp6_;
	param = VALA_IS_PARAMETER (_tmp7_) ? ((ValaParameter*) _tmp7_) : NULL;
	_tmp8_ = local;
	if (_tmp8_ != NULL) {
		ValaLocalVariable* _tmp9_;
		_tmp9_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp9_);
	} else {
		gboolean _tmp10_ = FALSE;
		ValaParameter* _tmp11_;
		_tmp11_ = param;
		if (_tmp11_ != NULL) {
			ValaParameter* _tmp12_;
			ValaParameterDirection _tmp13_;
			ValaParameterDirection _tmp14_;
			_tmp12_ = param;
			_tmp13_ = vala_parameter_get_direction (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp10_ = _tmp14_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			ValaParameter* _tmp15_;
			_tmp15_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp15_);
		}
	}
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass,
                               gpointer klass_data)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
static GType
vala_member_access_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
	GType vala_member_access_type_id;
	vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
	ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
	return vala_member_access_type_id;
}

GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		GType vala_member_access_type_id;
		vala_member_access_type_id = vala_member_access_get_type_once ();
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}

