/* valaunaryexpression.c generated by valac, the Vala compiler
 * generated from valaunaryexpression.vala, do not modify */

/* valaunaryexpression.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaUnaryExpressionPrivate {
	ValaUnaryOperator _operator;
	ValaExpression* _inner;
};

static gint ValaUnaryExpression_private_offset;
static gpointer vala_unary_expression_parent_class = NULL;

static void vala_unary_expression_set_operator (ValaUnaryExpression* self,
                                         ValaUnaryOperator value);
static void vala_unary_expression_set_inner (ValaUnaryExpression* self,
                                      ValaExpression* value);
static void vala_unary_expression_real_accept (ValaCodeNode* base,
                                        ValaCodeVisitor* visitor);
static void vala_unary_expression_real_accept_children (ValaCodeNode* base,
                                                 ValaCodeVisitor* visitor);
static void vala_unary_expression_real_replace_expression (ValaCodeNode* base,
                                                    ValaExpression* old_node,
                                                    ValaExpression* new_node);
static gchar* vala_unary_expression_real_to_string (ValaCodeNode* base);
static gboolean vala_unary_expression_real_is_constant (ValaExpression* base);
static gboolean vala_unary_expression_real_is_pure (ValaExpression* base);
static gboolean vala_unary_expression_real_is_accessible (ValaExpression* base,
                                                   ValaSymbol* sym);
static gboolean vala_unary_expression_is_numeric_type (ValaUnaryExpression* self,
                                                ValaDataType* type);
static gboolean vala_unary_expression_is_integer_type (ValaUnaryExpression* self,
                                                ValaDataType* type);
static ValaMemberAccess* vala_unary_expression_find_member_access (ValaUnaryExpression* self,
                                                            ValaExpression* expr);
static void vala_unary_expression_real_get_error_types (ValaCodeNode* base,
                                                 ValaCollection* collection,
                                                 ValaSourceReference* source_reference);
static gboolean vala_unary_expression_real_check (ValaCodeNode* base,
                                           ValaCodeContext* context);
static void vala_unary_expression_real_emit (ValaCodeNode* base,
                                      ValaCodeGenerator* codegen);
static void vala_unary_expression_real_get_defined_variables (ValaCodeNode* base,
                                                       ValaCollection* collection);
static void vala_unary_expression_real_get_used_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_unary_expression_finalize (ValaCodeNode * obj);
static GType vala_unary_expression_get_type_once (void);

static inline gpointer
vala_unary_expression_get_instance_private (ValaUnaryExpression* self)
{
	return G_STRUCT_MEMBER_P (self, ValaUnaryExpression_private_offset);
}

ValaUnaryOperator
vala_unary_expression_get_operator (ValaUnaryExpression* self)
{
	ValaUnaryOperator result;
	ValaUnaryOperator _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_operator;
	result = _tmp0_;
	return result;
}

static void
vala_unary_expression_set_operator (ValaUnaryExpression* self,
                                    ValaUnaryOperator value)
{
	g_return_if_fail (self != NULL);
	self->priv->_operator = value;
}

ValaExpression*
vala_unary_expression_get_inner (ValaUnaryExpression* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_unary_expression_set_inner (ValaUnaryExpression* self,
                                 ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

/**
 * Creates a new unary expression.
 *
 * @param op     unary operator
 * @param _inner operand
 * @param source reference to source code
 * @return       newly created binary expression
 */
ValaUnaryExpression*
vala_unary_expression_construct (GType object_type,
                                 ValaUnaryOperator op,
                                 ValaExpression* _inner,
                                 ValaSourceReference* source)
{
	ValaUnaryExpression* self = NULL;
	g_return_val_if_fail (_inner != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	self = (ValaUnaryExpression*) vala_expression_construct (object_type);
	vala_unary_expression_set_operator (self, op);
	vala_unary_expression_set_inner (self, _inner);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source);
	return self;
}

ValaUnaryExpression*
vala_unary_expression_new (ValaUnaryOperator op,
                           ValaExpression* _inner,
                           ValaSourceReference* source)
{
	return vala_unary_expression_construct (VALA_TYPE_UNARY_EXPRESSION, op, _inner, source);
}

static void
vala_unary_expression_real_accept (ValaCodeNode* base,
                                   ValaCodeVisitor* visitor)
{
	ValaUnaryExpression * self;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_unary_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_unary_expression_real_accept_children (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor)
{
	ValaUnaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_unary_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
}

static void
vala_unary_expression_real_replace_expression (ValaCodeNode* base,
                                               ValaExpression* old_node,
                                               ValaExpression* new_node)
{
	ValaUnaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_unary_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_unary_expression_set_inner (self, new_node);
	}
}

static gchar*
vala_unary_expression_real_to_string (ValaCodeNode* base)
{
	ValaUnaryExpression * self;
	ValaUnaryOperator _tmp0_;
	const gchar* _tmp1_;
	ValaExpression* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result = NULL;
	self = (ValaUnaryExpression*) base;
	_tmp0_ = self->priv->_operator;
	_tmp1_ = vala_unary_operator_to_string (_tmp0_);
	_tmp2_ = self->priv->_inner;
	_tmp3_ = vala_code_node_to_string ((ValaCodeNode*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp1_, _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	result = _tmp6_;
	return result;
}

static gboolean
vala_unary_expression_real_is_constant (ValaExpression* base)
{
	ValaUnaryExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaUnaryOperator _tmp1_;
	gboolean _tmp3_ = FALSE;
	ValaUnaryOperator _tmp4_;
	ValaExpression* _tmp15_;
	ValaExpression* _tmp16_;
	gboolean result = FALSE;
	self = (ValaUnaryExpression*) base;
	_tmp1_ = self->priv->_operator;
	if (_tmp1_ == VALA_UNARY_OPERATOR_INCREMENT) {
		_tmp0_ = TRUE;
	} else {
		ValaUnaryOperator _tmp2_;
		_tmp2_ = self->priv->_operator;
		_tmp0_ = _tmp2_ == VALA_UNARY_OPERATOR_DECREMENT;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = self->priv->_operator;
	if (_tmp4_ == VALA_UNARY_OPERATOR_REF) {
		_tmp3_ = TRUE;
	} else {
		ValaUnaryOperator _tmp5_;
		_tmp5_ = self->priv->_operator;
		_tmp3_ = _tmp5_ == VALA_UNARY_OPERATOR_OUT;
	}
	if (_tmp3_) {
		ValaField* field = NULL;
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaSymbol* _tmp9_;
		gboolean _tmp10_ = FALSE;
		ValaField* _tmp11_;
		_tmp6_ = vala_unary_expression_get_inner (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_expression_get_symbol_reference (_tmp7_);
		_tmp9_ = _tmp8_;
		field = VALA_IS_FIELD (_tmp9_) ? ((ValaField*) _tmp9_) : NULL;
		_tmp11_ = field;
		if (_tmp11_ != NULL) {
			ValaField* _tmp12_;
			ValaMemberBinding _tmp13_;
			ValaMemberBinding _tmp14_;
			_tmp12_ = field;
			_tmp13_ = vala_field_get_binding (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp10_ = _tmp14_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			result = TRUE;
			return result;
		} else {
			result = FALSE;
			return result;
		}
	}
	_tmp15_ = vala_unary_expression_get_inner (self);
	_tmp16_ = _tmp15_;
	result = vala_expression_is_constant (_tmp16_);
	return result;
}

static gboolean
vala_unary_expression_real_is_pure (ValaExpression* base)
{
	ValaUnaryExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaUnaryOperator _tmp1_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	gboolean result = FALSE;
	self = (ValaUnaryExpression*) base;
	_tmp1_ = self->priv->_operator;
	if (_tmp1_ == VALA_UNARY_OPERATOR_INCREMENT) {
		_tmp0_ = TRUE;
	} else {
		ValaUnaryOperator _tmp2_;
		_tmp2_ = self->priv->_operator;
		_tmp0_ = _tmp2_ == VALA_UNARY_OPERATOR_DECREMENT;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = vala_unary_expression_get_inner (self);
	_tmp4_ = _tmp3_;
	result = vala_expression_is_pure (_tmp4_);
	return result;
}

static gboolean
vala_unary_expression_real_is_accessible (ValaExpression* base,
                                          ValaSymbol* sym)
{
	ValaUnaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean result = FALSE;
	self = (ValaUnaryExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp0_ = vala_unary_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	result = vala_expression_is_accessible (_tmp1_, sym);
	return result;
}

static gboolean
vala_unary_expression_is_numeric_type (ValaUnaryExpression* self,
                                       ValaDataType* type)
{
	ValaStruct* st = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp6_ = FALSE;
	ValaStruct* _tmp7_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	_tmp0_ = vala_data_type_get_type_symbol (type);
	_tmp1_ = _tmp0_;
	st = VALA_IS_STRUCT (_tmp1_) ? ((ValaStruct*) _tmp1_) : NULL;
	_tmp3_ = vala_data_type_get_nullable (type);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		_tmp2_ = TRUE;
	} else {
		ValaStruct* _tmp5_;
		_tmp5_ = st;
		_tmp2_ = _tmp5_ == NULL;
	}
	if (_tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp7_ = st;
	if (vala_struct_is_integer_type (_tmp7_)) {
		_tmp6_ = TRUE;
	} else {
		ValaStruct* _tmp8_;
		_tmp8_ = st;
		_tmp6_ = vala_struct_is_floating_type (_tmp8_);
	}
	result = _tmp6_;
	return result;
}

static gboolean
vala_unary_expression_is_integer_type (ValaUnaryExpression* self,
                                       ValaDataType* type)
{
	ValaStruct* st = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gboolean _tmp4_;
	ValaStruct* _tmp6_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	_tmp0_ = vala_data_type_get_type_symbol (type);
	_tmp1_ = _tmp0_;
	st = VALA_IS_STRUCT (_tmp1_) ? ((ValaStruct*) _tmp1_) : NULL;
	_tmp3_ = vala_data_type_get_nullable (type);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		_tmp2_ = TRUE;
	} else {
		ValaStruct* _tmp5_;
		_tmp5_ = st;
		_tmp2_ = _tmp5_ == NULL;
	}
	if (_tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp6_ = st;
	result = vala_struct_is_integer_type (_tmp6_);
	return result;
}

static ValaMemberAccess*
vala_unary_expression_find_member_access (ValaUnaryExpression* self,
                                          ValaExpression* expr)
{
	ValaMemberAccess* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	if (VALA_IS_MEMBER_ACCESS (expr)) {
		ValaMemberAccess* _tmp0_;
		_tmp0_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (expr, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		result = _tmp0_;
		return result;
	}
	result = NULL;
	return result;
}

static void
vala_unary_expression_real_get_error_types (ValaCodeNode* base,
                                            ValaCollection* collection,
                                            ValaSourceReference* source_reference)
{
	ValaUnaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_unary_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp1_, collection, source_reference);
}

static gboolean
vala_unary_expression_real_check (ValaCodeNode* base,
                                  ValaCodeContext* context)
{
	ValaUnaryExpression * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	ValaUnaryOperator _tmp5_;
	ValaExpression* _tmp18_;
	ValaExpression* _tmp19_;
	gboolean _tmp20_ = FALSE;
	ValaExpression* _tmp21_;
	ValaExpression* _tmp22_;
	ValaDataType* _tmp23_;
	ValaDataType* _tmp24_;
	ValaUnaryOperator _tmp41_;
	ValaDataType* _tmp198_;
	ValaDataType* _tmp199_;
	gboolean _tmp200_;
	gboolean _tmp201_;
	gboolean result = FALSE;
	self = (ValaUnaryExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = self->priv->_operator;
	if (_tmp5_ == VALA_UNARY_OPERATOR_REF) {
		_tmp4_ = TRUE;
	} else {
		ValaUnaryOperator _tmp6_;
		_tmp6_ = self->priv->_operator;
		_tmp4_ = _tmp6_ == VALA_UNARY_OPERATOR_OUT;
	}
	if (_tmp4_) {
		ValaExpression* _tmp7_;
		ValaExpression* _tmp8_;
		ValaExpression* _tmp9_;
		ValaExpression* _tmp10_;
		ValaDataType* _tmp11_;
		ValaDataType* _tmp12_;
		_tmp7_ = vala_unary_expression_get_inner (self);
		_tmp8_ = _tmp7_;
		vala_expression_set_lvalue (_tmp8_, TRUE);
		_tmp9_ = vala_unary_expression_get_inner (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp12_ = _tmp11_;
		vala_expression_set_target_type (_tmp10_, _tmp12_);
	} else {
		gboolean _tmp13_ = FALSE;
		ValaUnaryOperator _tmp14_;
		_tmp14_ = self->priv->_operator;
		if (_tmp14_ == VALA_UNARY_OPERATOR_INCREMENT) {
			_tmp13_ = TRUE;
		} else {
			ValaUnaryOperator _tmp15_;
			_tmp15_ = self->priv->_operator;
			_tmp13_ = _tmp15_ == VALA_UNARY_OPERATOR_DECREMENT;
		}
		if (_tmp13_) {
			ValaExpression* _tmp16_;
			ValaExpression* _tmp17_;
			_tmp16_ = vala_unary_expression_get_inner (self);
			_tmp17_ = _tmp16_;
			vala_expression_set_lvalue (_tmp17_, TRUE);
		}
	}
	_tmp18_ = vala_unary_expression_get_inner (self);
	_tmp19_ = _tmp18_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp19_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp21_ = vala_unary_expression_get_inner (self);
	_tmp22_ = _tmp21_;
	_tmp23_ = vala_expression_get_value_type (_tmp22_);
	_tmp24_ = _tmp23_;
	if (VALA_IS_FIELD_PROTOTYPE (_tmp24_)) {
		_tmp20_ = TRUE;
	} else {
		ValaExpression* _tmp25_;
		ValaExpression* _tmp26_;
		ValaDataType* _tmp27_;
		ValaDataType* _tmp28_;
		_tmp25_ = vala_unary_expression_get_inner (self);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_expression_get_value_type (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp20_ = VALA_IS_PROPERTY_PROTOTYPE (_tmp28_);
	}
	if (_tmp20_) {
		ValaExpression* _tmp29_;
		ValaExpression* _tmp30_;
		ValaSourceReference* _tmp31_;
		ValaSourceReference* _tmp32_;
		ValaExpression* _tmp33_;
		ValaExpression* _tmp34_;
		ValaSymbol* _tmp35_;
		ValaSymbol* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp29_ = vala_unary_expression_get_inner (self);
		_tmp30_ = _tmp29_;
		_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = vala_unary_expression_get_inner (self);
		_tmp34_ = _tmp33_;
		_tmp35_ = vala_expression_get_symbol_reference (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = vala_symbol_get_full_name (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp38_);
		_tmp40_ = _tmp39_;
		vala_report_error (_tmp32_, _tmp40_);
		_g_free0 (_tmp40_);
		_g_free0 (_tmp38_);
		result = FALSE;
		return result;
	}
	_tmp41_ = self->priv->_operator;
	switch (_tmp41_) {
		case VALA_UNARY_OPERATOR_PLUS:
		case VALA_UNARY_OPERATOR_MINUS:
		{
			ValaExpression* _tmp42_;
			ValaExpression* _tmp43_;
			ValaDataType* _tmp44_;
			ValaDataType* _tmp45_;
			ValaExpression* _tmp56_;
			ValaExpression* _tmp57_;
			ValaDataType* _tmp58_;
			ValaDataType* _tmp59_;
			_tmp42_ = vala_unary_expression_get_inner (self);
			_tmp43_ = _tmp42_;
			_tmp44_ = vala_expression_get_value_type (_tmp43_);
			_tmp45_ = _tmp44_;
			if (!vala_unary_expression_is_numeric_type (self, _tmp45_)) {
				ValaSourceReference* _tmp46_;
				ValaSourceReference* _tmp47_;
				ValaExpression* _tmp48_;
				ValaExpression* _tmp49_;
				ValaDataType* _tmp50_;
				ValaDataType* _tmp51_;
				gchar* _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp55_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp46_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp47_ = _tmp46_;
				_tmp48_ = vala_unary_expression_get_inner (self);
				_tmp49_ = _tmp48_;
				_tmp50_ = vala_expression_get_value_type (_tmp49_);
				_tmp51_ = _tmp50_;
				_tmp52_ = vala_code_node_to_string ((ValaCodeNode*) _tmp51_);
				_tmp53_ = _tmp52_;
				_tmp54_ = g_strdup_printf ("Operator not supported for `%s'", _tmp53_);
				_tmp55_ = _tmp54_;
				vala_report_error (_tmp47_, _tmp55_);
				_g_free0 (_tmp55_);
				_g_free0 (_tmp53_);
				result = FALSE;
				return result;
			}
			_tmp56_ = vala_unary_expression_get_inner (self);
			_tmp57_ = _tmp56_;
			_tmp58_ = vala_expression_get_value_type (_tmp57_);
			_tmp59_ = _tmp58_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp59_);
			break;
		}
		case VALA_UNARY_OPERATOR_LOGICAL_NEGATION:
		{
			gboolean _tmp60_ = FALSE;
			ValaExpression* _tmp61_;
			ValaExpression* _tmp62_;
			ValaDataType* _tmp63_;
			ValaDataType* _tmp64_;
			gboolean _tmp65_;
			gboolean _tmp66_;
			ValaExpression* _tmp84_;
			ValaExpression* _tmp85_;
			ValaDataType* _tmp86_;
			ValaDataType* _tmp87_;
			_tmp61_ = vala_unary_expression_get_inner (self);
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_expression_get_value_type (_tmp62_);
			_tmp64_ = _tmp63_;
			_tmp65_ = vala_data_type_get_nullable (_tmp64_);
			_tmp66_ = _tmp65_;
			if (_tmp66_) {
				_tmp60_ = TRUE;
			} else {
				ValaExpression* _tmp67_;
				ValaExpression* _tmp68_;
				ValaDataType* _tmp69_;
				ValaDataType* _tmp70_;
				ValaSemanticAnalyzer* _tmp71_;
				ValaSemanticAnalyzer* _tmp72_;
				ValaDataType* _tmp73_;
				_tmp67_ = vala_unary_expression_get_inner (self);
				_tmp68_ = _tmp67_;
				_tmp69_ = vala_expression_get_value_type (_tmp68_);
				_tmp70_ = _tmp69_;
				_tmp71_ = vala_code_context_get_analyzer (context);
				_tmp72_ = _tmp71_;
				_tmp73_ = _tmp72_->bool_type;
				_tmp60_ = !vala_data_type_compatible (_tmp70_, _tmp73_);
			}
			if (_tmp60_) {
				ValaSourceReference* _tmp74_;
				ValaSourceReference* _tmp75_;
				ValaExpression* _tmp76_;
				ValaExpression* _tmp77_;
				ValaDataType* _tmp78_;
				ValaDataType* _tmp79_;
				gchar* _tmp80_;
				gchar* _tmp81_;
				gchar* _tmp82_;
				gchar* _tmp83_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp75_ = _tmp74_;
				_tmp76_ = vala_unary_expression_get_inner (self);
				_tmp77_ = _tmp76_;
				_tmp78_ = vala_expression_get_value_type (_tmp77_);
				_tmp79_ = _tmp78_;
				_tmp80_ = vala_code_node_to_string ((ValaCodeNode*) _tmp79_);
				_tmp81_ = _tmp80_;
				_tmp82_ = g_strdup_printf ("Operator not supported for `%s'", _tmp81_);
				_tmp83_ = _tmp82_;
				vala_report_error (_tmp75_, _tmp83_);
				_g_free0 (_tmp83_);
				_g_free0 (_tmp81_);
				result = FALSE;
				return result;
			}
			_tmp84_ = vala_unary_expression_get_inner (self);
			_tmp85_ = _tmp84_;
			_tmp86_ = vala_expression_get_value_type (_tmp85_);
			_tmp87_ = _tmp86_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp87_);
			break;
		}
		case VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT:
		{
			gboolean _tmp88_ = FALSE;
			ValaExpression* _tmp89_;
			ValaExpression* _tmp90_;
			ValaDataType* _tmp91_;
			ValaDataType* _tmp92_;
			ValaExpression* _tmp107_;
			ValaExpression* _tmp108_;
			ValaDataType* _tmp109_;
			ValaDataType* _tmp110_;
			_tmp89_ = vala_unary_expression_get_inner (self);
			_tmp90_ = _tmp89_;
			_tmp91_ = vala_expression_get_value_type (_tmp90_);
			_tmp92_ = _tmp91_;
			if (!vala_unary_expression_is_integer_type (self, _tmp92_)) {
				ValaExpression* _tmp93_;
				ValaExpression* _tmp94_;
				ValaDataType* _tmp95_;
				ValaDataType* _tmp96_;
				_tmp93_ = vala_unary_expression_get_inner (self);
				_tmp94_ = _tmp93_;
				_tmp95_ = vala_expression_get_value_type (_tmp94_);
				_tmp96_ = _tmp95_;
				_tmp88_ = !VALA_IS_ENUM_VALUE_TYPE (_tmp96_);
			} else {
				_tmp88_ = FALSE;
			}
			if (_tmp88_) {
				ValaSourceReference* _tmp97_;
				ValaSourceReference* _tmp98_;
				ValaExpression* _tmp99_;
				ValaExpression* _tmp100_;
				ValaDataType* _tmp101_;
				ValaDataType* _tmp102_;
				gchar* _tmp103_;
				gchar* _tmp104_;
				gchar* _tmp105_;
				gchar* _tmp106_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp97_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp98_ = _tmp97_;
				_tmp99_ = vala_unary_expression_get_inner (self);
				_tmp100_ = _tmp99_;
				_tmp101_ = vala_expression_get_value_type (_tmp100_);
				_tmp102_ = _tmp101_;
				_tmp103_ = vala_code_node_to_string ((ValaCodeNode*) _tmp102_);
				_tmp104_ = _tmp103_;
				_tmp105_ = g_strdup_printf ("Operator not supported for `%s'", _tmp104_);
				_tmp106_ = _tmp105_;
				vala_report_error (_tmp98_, _tmp106_);
				_g_free0 (_tmp106_);
				_g_free0 (_tmp104_);
				result = FALSE;
				return result;
			}
			_tmp107_ = vala_unary_expression_get_inner (self);
			_tmp108_ = _tmp107_;
			_tmp109_ = vala_expression_get_value_type (_tmp108_);
			_tmp110_ = _tmp109_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp110_);
			break;
		}
		case VALA_UNARY_OPERATOR_INCREMENT:
		case VALA_UNARY_OPERATOR_DECREMENT:
		{
			ValaExpression* _tmp111_;
			ValaExpression* _tmp112_;
			ValaDataType* _tmp113_;
			ValaDataType* _tmp114_;
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp125_;
			ValaExpression* _tmp126_;
			ValaMemberAccess* _tmp127_;
			ValaMemberAccess* _tmp128_;
			ValaMemberAccess* old_value = NULL;
			ValaMemberAccess* _tmp131_;
			ValaExpression* _tmp132_;
			ValaExpression* _tmp133_;
			ValaMemberAccess* _tmp134_;
			const gchar* _tmp135_;
			const gchar* _tmp136_;
			ValaExpression* _tmp137_;
			ValaExpression* _tmp138_;
			ValaSourceReference* _tmp139_;
			ValaSourceReference* _tmp140_;
			ValaMemberAccess* _tmp141_;
			ValaBinaryOperator _tmp142_ = 0;
			ValaUnaryOperator _tmp143_;
			ValaBinaryExpression* bin = NULL;
			ValaMemberAccess* _tmp144_;
			ValaIntegerLiteral* _tmp145_;
			ValaIntegerLiteral* _tmp146_;
			ValaSourceReference* _tmp147_;
			ValaSourceReference* _tmp148_;
			ValaBinaryExpression* _tmp149_;
			ValaBinaryExpression* _tmp150_;
			ValaAssignment* assignment = NULL;
			ValaMemberAccess* _tmp151_;
			ValaBinaryExpression* _tmp152_;
			ValaSourceReference* _tmp153_;
			ValaSourceReference* _tmp154_;
			ValaAssignment* _tmp155_;
			ValaAssignment* _tmp156_;
			ValaDataType* _tmp157_;
			ValaDataType* _tmp158_;
			ValaSemanticAnalyzer* _tmp159_;
			ValaSemanticAnalyzer* _tmp160_;
			ValaList* _tmp161_;
			ValaCodeNode* _tmp162_;
			ValaCodeNode* _tmp163_;
			ValaAssignment* _tmp164_;
			ValaAssignment* _tmp165_;
			_tmp111_ = vala_unary_expression_get_inner (self);
			_tmp112_ = _tmp111_;
			_tmp113_ = vala_expression_get_value_type (_tmp112_);
			_tmp114_ = _tmp113_;
			if (!vala_unary_expression_is_integer_type (self, _tmp114_)) {
				ValaSourceReference* _tmp115_;
				ValaSourceReference* _tmp116_;
				ValaExpression* _tmp117_;
				ValaExpression* _tmp118_;
				ValaDataType* _tmp119_;
				ValaDataType* _tmp120_;
				gchar* _tmp121_;
				gchar* _tmp122_;
				gchar* _tmp123_;
				gchar* _tmp124_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp115_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp116_ = _tmp115_;
				_tmp117_ = vala_unary_expression_get_inner (self);
				_tmp118_ = _tmp117_;
				_tmp119_ = vala_expression_get_value_type (_tmp118_);
				_tmp120_ = _tmp119_;
				_tmp121_ = vala_code_node_to_string ((ValaCodeNode*) _tmp120_);
				_tmp122_ = _tmp121_;
				_tmp123_ = g_strdup_printf ("Operator not supported for `%s'", _tmp122_);
				_tmp124_ = _tmp123_;
				vala_report_error (_tmp116_, _tmp124_);
				_g_free0 (_tmp124_);
				_g_free0 (_tmp122_);
				result = FALSE;
				return result;
			}
			_tmp125_ = vala_unary_expression_get_inner (self);
			_tmp126_ = _tmp125_;
			_tmp127_ = vala_unary_expression_find_member_access (self, _tmp126_);
			ma = _tmp127_;
			_tmp128_ = ma;
			if (_tmp128_ == NULL) {
				ValaSourceReference* _tmp129_;
				ValaSourceReference* _tmp130_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp129_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp130_ = _tmp129_;
				vala_report_error (_tmp130_, "Prefix operators not supported for this expression");
				result = FALSE;
				_vala_code_node_unref0 (ma);
				return result;
			}
			_tmp131_ = ma;
			_tmp132_ = vala_member_access_get_inner (_tmp131_);
			_tmp133_ = _tmp132_;
			_tmp134_ = ma;
			_tmp135_ = vala_member_access_get_member_name (_tmp134_);
			_tmp136_ = _tmp135_;
			_tmp137_ = vala_unary_expression_get_inner (self);
			_tmp138_ = _tmp137_;
			_tmp139_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp138_);
			_tmp140_ = _tmp139_;
			_tmp141_ = vala_member_access_new (_tmp133_, _tmp136_, _tmp140_);
			old_value = _tmp141_;
			_tmp143_ = self->priv->_operator;
			if (_tmp143_ == VALA_UNARY_OPERATOR_INCREMENT) {
				_tmp142_ = VALA_BINARY_OPERATOR_PLUS;
			} else {
				_tmp142_ = VALA_BINARY_OPERATOR_MINUS;
			}
			_tmp144_ = old_value;
			_tmp145_ = vala_integer_literal_new ("1", NULL);
			_tmp146_ = _tmp145_;
			_tmp147_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp148_ = _tmp147_;
			_tmp149_ = vala_binary_expression_new (_tmp142_, (ValaExpression*) _tmp144_, (ValaExpression*) _tmp146_, _tmp148_);
			_tmp150_ = _tmp149_;
			_vala_code_node_unref0 (_tmp146_);
			bin = _tmp150_;
			_tmp151_ = ma;
			_tmp152_ = bin;
			_tmp153_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp154_ = _tmp153_;
			_tmp155_ = vala_assignment_new ((ValaExpression*) _tmp151_, (ValaExpression*) _tmp152_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp154_);
			assignment = _tmp155_;
			_tmp156_ = assignment;
			_tmp157_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp158_ = _tmp157_;
			vala_expression_set_target_type ((ValaExpression*) _tmp156_, _tmp158_);
			_tmp159_ = vala_code_context_get_analyzer (context);
			_tmp160_ = _tmp159_;
			_tmp161_ = _tmp160_->replaced_nodes;
			vala_collection_add ((ValaCollection*) _tmp161_, (ValaCodeNode*) self);
			_tmp162_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp163_ = _tmp162_;
			_tmp164_ = assignment;
			vala_code_node_replace_expression (_tmp163_, (ValaExpression*) self, (ValaExpression*) _tmp164_);
			_tmp165_ = assignment;
			vala_code_node_check ((ValaCodeNode*) _tmp165_, context);
			result = TRUE;
			_vala_code_node_unref0 (assignment);
			_vala_code_node_unref0 (bin);
			_vala_code_node_unref0 (old_value);
			_vala_code_node_unref0 (ma);
			return result;
		}
		case VALA_UNARY_OPERATOR_REF:
		case VALA_UNARY_OPERATOR_OUT:
		{
			ValaElementAccess* ea = NULL;
			ValaExpression* _tmp166_;
			ValaExpression* _tmp167_;
			gboolean _tmp168_ = FALSE;
			gboolean _tmp169_ = FALSE;
			gboolean _tmp170_ = FALSE;
			ValaExpression* _tmp171_;
			ValaExpression* _tmp172_;
			ValaSymbol* _tmp173_;
			ValaSymbol* _tmp174_;
			_tmp166_ = vala_unary_expression_get_inner (self);
			_tmp167_ = _tmp166_;
			ea = VALA_IS_ELEMENT_ACCESS (_tmp167_) ? ((ValaElementAccess*) _tmp167_) : NULL;
			_tmp171_ = vala_unary_expression_get_inner (self);
			_tmp172_ = _tmp171_;
			_tmp173_ = vala_expression_get_symbol_reference (_tmp172_);
			_tmp174_ = _tmp173_;
			if (VALA_IS_FIELD (_tmp174_)) {
				_tmp170_ = TRUE;
			} else {
				ValaExpression* _tmp175_;
				ValaExpression* _tmp176_;
				ValaSymbol* _tmp177_;
				ValaSymbol* _tmp178_;
				_tmp175_ = vala_unary_expression_get_inner (self);
				_tmp176_ = _tmp175_;
				_tmp177_ = vala_expression_get_symbol_reference (_tmp176_);
				_tmp178_ = _tmp177_;
				_tmp170_ = VALA_IS_PARAMETER (_tmp178_);
			}
			if (_tmp170_) {
				_tmp169_ = TRUE;
			} else {
				ValaExpression* _tmp179_;
				ValaExpression* _tmp180_;
				ValaSymbol* _tmp181_;
				ValaSymbol* _tmp182_;
				_tmp179_ = vala_unary_expression_get_inner (self);
				_tmp180_ = _tmp179_;
				_tmp181_ = vala_expression_get_symbol_reference (_tmp180_);
				_tmp182_ = _tmp181_;
				_tmp169_ = VALA_IS_LOCAL_VARIABLE (_tmp182_);
			}
			if (_tmp169_) {
				_tmp168_ = TRUE;
			} else {
				gboolean _tmp183_ = FALSE;
				ValaElementAccess* _tmp184_;
				_tmp184_ = ea;
				if (_tmp184_ != NULL) {
					ValaElementAccess* _tmp185_;
					ValaExpression* _tmp186_;
					ValaExpression* _tmp187_;
					ValaDataType* _tmp188_;
					ValaDataType* _tmp189_;
					_tmp185_ = ea;
					_tmp186_ = vala_element_access_get_container (_tmp185_);
					_tmp187_ = _tmp186_;
					_tmp188_ = vala_expression_get_value_type (_tmp187_);
					_tmp189_ = _tmp188_;
					_tmp183_ = VALA_IS_ARRAY_TYPE (_tmp189_);
				} else {
					_tmp183_ = FALSE;
				}
				_tmp168_ = _tmp183_;
			}
			if (_tmp168_) {
				ValaExpression* _tmp190_;
				ValaExpression* _tmp191_;
				ValaDataType* _tmp192_;
				ValaDataType* _tmp193_;
				vala_expression_set_lvalue ((ValaExpression*) self, TRUE);
				_tmp190_ = vala_unary_expression_get_inner (self);
				_tmp191_ = _tmp190_;
				_tmp192_ = vala_expression_get_value_type (_tmp191_);
				_tmp193_ = _tmp192_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp193_);
			} else {
				ValaSourceReference* _tmp194_;
				ValaSourceReference* _tmp195_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp194_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp195_ = _tmp194_;
				vala_report_error (_tmp195_, "ref and out method arguments can only be used with fields, parameters," \
" local variables, and array element access");
				result = FALSE;
				return result;
			}
			break;
		}
		default:
		{
			ValaSourceReference* _tmp196_;
			ValaSourceReference* _tmp197_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp196_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp197_ = _tmp196_;
			vala_report_error (_tmp197_, "internal error: unsupported unary operator");
			result = FALSE;
			return result;
		}
	}
	_tmp198_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp199_ = _tmp198_;
	vala_code_node_check ((ValaCodeNode*) _tmp199_, context);
	_tmp200_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp201_ = _tmp200_;
	result = !_tmp201_;
	return result;
}

static void
vala_unary_expression_real_emit (ValaCodeNode* base,
                                 ValaCodeGenerator* codegen)
{
	ValaUnaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_unary_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	vala_code_node_emit ((ValaCodeNode*) _tmp1_, codegen);
	vala_code_visitor_visit_unary_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_unary_expression_real_get_defined_variables (ValaCodeNode* base,
                                                  ValaCollection* collection)
{
	ValaUnaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaUnaryOperator _tmp3_;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_unary_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp3_ = self->priv->_operator;
	if (_tmp3_ == VALA_UNARY_OPERATOR_OUT) {
		_tmp2_ = TRUE;
	} else {
		ValaUnaryOperator _tmp4_;
		_tmp4_ = self->priv->_operator;
		_tmp2_ = _tmp4_ == VALA_UNARY_OPERATOR_REF;
	}
	if (_tmp2_) {
		ValaLocalVariable* local = NULL;
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaParameter* param = NULL;
		ValaExpression* _tmp9_;
		ValaExpression* _tmp10_;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaLocalVariable* _tmp13_;
		gboolean _tmp15_ = FALSE;
		ValaParameter* _tmp16_;
		_tmp5_ = vala_unary_expression_get_inner (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_expression_get_symbol_reference (_tmp6_);
		_tmp8_ = _tmp7_;
		local = VALA_IS_LOCAL_VARIABLE (_tmp8_) ? ((ValaLocalVariable*) _tmp8_) : NULL;
		_tmp9_ = vala_unary_expression_get_inner (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_expression_get_symbol_reference (_tmp10_);
		_tmp12_ = _tmp11_;
		param = VALA_IS_PARAMETER (_tmp12_) ? ((ValaParameter*) _tmp12_) : NULL;
		_tmp13_ = local;
		if (_tmp13_ != NULL) {
			ValaLocalVariable* _tmp14_;
			_tmp14_ = local;
			vala_collection_add (collection, (ValaVariable*) _tmp14_);
		}
		_tmp16_ = param;
		if (_tmp16_ != NULL) {
			ValaParameter* _tmp17_;
			ValaParameterDirection _tmp18_;
			ValaParameterDirection _tmp19_;
			_tmp17_ = param;
			_tmp18_ = vala_parameter_get_direction (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp15_ = _tmp19_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			ValaParameter* _tmp20_;
			_tmp20_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp20_);
		}
	}
}

static void
vala_unary_expression_real_get_used_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaUnaryExpression * self;
	ValaUnaryOperator _tmp0_;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = self->priv->_operator;
	if (_tmp0_ != VALA_UNARY_OPERATOR_OUT) {
		ValaExpression* _tmp1_;
		ValaExpression* _tmp2_;
		_tmp1_ = vala_unary_expression_get_inner (self);
		_tmp2_ = _tmp1_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp2_, collection);
	}
}

static void
vala_unary_expression_class_init (ValaUnaryExpressionClass * klass,
                                  gpointer klass_data)
{
	vala_unary_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_unary_expression_finalize;
	g_type_class_adjust_private_offset (klass, &ValaUnaryExpression_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_unary_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_unary_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_unary_expression_real_replace_expression;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_unary_expression_real_to_string;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_unary_expression_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_unary_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_unary_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_unary_expression_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_unary_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_unary_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_unary_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_unary_expression_real_get_used_variables;
}

static void
vala_unary_expression_instance_init (ValaUnaryExpression * self,
                                     gpointer klass)
{
	self->priv = vala_unary_expression_get_instance_private (self);
}

static void
vala_unary_expression_finalize (ValaCodeNode * obj)
{
	ValaUnaryExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression);
	_vala_code_node_unref0 (self->priv->_inner);
	VALA_CODE_NODE_CLASS (vala_unary_expression_parent_class)->finalize (obj);
}

/**
 * Represents an expression with one operand in the source code.
 *
 * Supports +, -, !, ~, ref, out.
 */
static GType
vala_unary_expression_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaUnaryExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_unary_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaUnaryExpression), 0, (GInstanceInitFunc) vala_unary_expression_instance_init, NULL };
	GType vala_unary_expression_type_id;
	vala_unary_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaUnaryExpression", &g_define_type_info, 0);
	ValaUnaryExpression_private_offset = g_type_add_instance_private (vala_unary_expression_type_id, sizeof (ValaUnaryExpressionPrivate));
	return vala_unary_expression_type_id;
}

GType
vala_unary_expression_get_type (void)
{
	static volatile gsize vala_unary_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_unary_expression_type_id__volatile)) {
		GType vala_unary_expression_type_id;
		vala_unary_expression_type_id = vala_unary_expression_get_type_once ();
		g_once_init_leave (&vala_unary_expression_type_id__volatile, vala_unary_expression_type_id);
	}
	return vala_unary_expression_type_id__volatile;
}

const gchar*
vala_unary_operator_to_string (ValaUnaryOperator self)
{
	const gchar* result = NULL;
	switch (self) {
		case VALA_UNARY_OPERATOR_PLUS:
		{
			result = "+";
			return result;
		}
		case VALA_UNARY_OPERATOR_MINUS:
		{
			result = "-";
			return result;
		}
		case VALA_UNARY_OPERATOR_LOGICAL_NEGATION:
		{
			result = "!";
			return result;
		}
		case VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT:
		{
			result = "~";
			return result;
		}
		case VALA_UNARY_OPERATOR_INCREMENT:
		{
			result = "++";
			return result;
		}
		case VALA_UNARY_OPERATOR_DECREMENT:
		{
			result = "--";
			return result;
		}
		case VALA_UNARY_OPERATOR_REF:
		{
			result = "ref ";
			return result;
		}
		case VALA_UNARY_OPERATOR_OUT:
		{
			result = "out ";
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GType
vala_unary_operator_get_type_once (void)
{
	static const GEnumValue values[] = {{VALA_UNARY_OPERATOR_NONE, "VALA_UNARY_OPERATOR_NONE", "none"}, {VALA_UNARY_OPERATOR_PLUS, "VALA_UNARY_OPERATOR_PLUS", "plus"}, {VALA_UNARY_OPERATOR_MINUS, "VALA_UNARY_OPERATOR_MINUS", "minus"}, {VALA_UNARY_OPERATOR_LOGICAL_NEGATION, "VALA_UNARY_OPERATOR_LOGICAL_NEGATION", "logical-negation"}, {VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT, "VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT", "bitwise-complement"}, {VALA_UNARY_OPERATOR_INCREMENT, "VALA_UNARY_OPERATOR_INCREMENT", "increment"}, {VALA_UNARY_OPERATOR_DECREMENT, "VALA_UNARY_OPERATOR_DECREMENT", "decrement"}, {VALA_UNARY_OPERATOR_REF, "VALA_UNARY_OPERATOR_REF", "ref"}, {VALA_UNARY_OPERATOR_OUT, "VALA_UNARY_OPERATOR_OUT", "out"}, {0, NULL, NULL}};
	GType vala_unary_operator_type_id;
	vala_unary_operator_type_id = g_enum_register_static ("ValaUnaryOperator", values);
	return vala_unary_operator_type_id;
}

GType
vala_unary_operator_get_type (void)
{
	static volatile gsize vala_unary_operator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_unary_operator_type_id__volatile)) {
		GType vala_unary_operator_type_id;
		vala_unary_operator_type_id = vala_unary_operator_get_type_once ();
		g_once_init_leave (&vala_unary_operator_type_id__volatile, vala_unary_operator_type_id);
	}
	return vala_unary_operator_type_id__volatile;
}

