/* valageniescanner.c generated by valac, the Vala compiler
 * generated from valageniescanner.vala, do not modify */

/* valageniescanner.vala
 *
 * Copyright (C) 2008-2012  Jamie McCracken, Jürg Billeter
 * Based on code by Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jamie McCracken jamiemcc gnome org
 */

#include "vala.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>

#define VALA_GENIE_SCANNER_TYPE_CONDITIONAL (vala_genie_scanner_conditional_get_type ())
typedef struct _ValaGenieScannerConditional ValaGenieScannerConditional;
typedef enum  {
	VALA_GENIE_SCANNER_STATE_PARENS,
	VALA_GENIE_SCANNER_STATE_BRACE,
	VALA_GENIE_SCANNER_STATE_BRACKET,
	VALA_GENIE_SCANNER_STATE_REGEX_LITERAL,
	VALA_GENIE_SCANNER_STATE_TEMPLATE,
	VALA_GENIE_SCANNER_STATE_TEMPLATE_PART
} ValaGenieScannerState;

#define VALA_GENIE_SCANNER_TYPE_STATE (vala_genie_scanner_state_get_type ())
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_comment_unref0(var) ((var == NULL) ? NULL : (var = (vala_comment_unref (var), NULL)))
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ValaGenieParamSpecScanner ValaGenieParamSpecScanner;

struct _ValaGenieScannerConditional {
	gboolean matched;
	gboolean else_found;
	gboolean skip_section;
};

struct _ValaGenieScannerPrivate {
	ValaSourceFile* _source_file;
	gint _indent_spaces;
	gchar* begin;
	gchar* current;
	gchar* end;
	gint line;
	gint column;
	gint current_indent_level;
	gint indent_level;
	gint pending_dedents;
	gint open_parens_count;
	gint open_brace_count;
	ValaGenieTokenType last_token;
	gboolean parse_started;
	ValaComment* _comment;
	ValaGenieScannerConditional* conditional_stack;
	gint conditional_stack_length1;
	gint _conditional_stack_size_;
	ValaGenieScannerState* state_stack;
	gint state_stack_length1;
	gint _state_stack_size_;
};

struct _ValaGenieParamSpecScanner {
	GParamSpec parent_instance;
};

static gint ValaGenieScanner_private_offset;
static gpointer vala_genie_scanner_parent_class = NULL;

static GType vala_genie_scanner_conditional_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaGenieScannerConditional* vala_genie_scanner_conditional_dup (const ValaGenieScannerConditional* self);
static void vala_genie_scanner_conditional_free (ValaGenieScannerConditional* self);
static GType vala_genie_scanner_state_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void vala_genie_scanner_set_source_file (ValaGenieScanner* self,
                                         ValaSourceFile* value);
static gboolean vala_genie_scanner_in_template (ValaGenieScanner* self);
static gboolean vala_genie_scanner_in_template_part (ValaGenieScanner* self);
static gboolean vala_genie_scanner_is_ident_char (ValaGenieScanner* self,
                                           gchar c);
static gboolean vala_genie_scanner_in_regex_literal (ValaGenieScanner* self);
static ValaSourceReference* vala_genie_scanner_get_source_reference (ValaGenieScanner* self,
                                                              gint offset,
                                                              gint length);
static gboolean vala_genie_scanner_matches (gchar* begin,
                                     const gchar* keyword);
static void _vala_array_add3 (ValaGenieScannerState* * array,
                       gint* length,
                       gint* size,
                       ValaGenieScannerState value);
static void _vala_array_add4 (ValaGenieScannerState* * array,
                       gint* length,
                       gint* size,
                       ValaGenieScannerState value);
static void _vala_array_add5 (ValaGenieScannerState* * array,
                       gint* length,
                       gint* size,
                       ValaGenieScannerState value);
static void _vala_array_add6 (ValaGenieScannerState* * array,
                       gint* length,
                       gint* size,
                       ValaGenieScannerState value);
static void vala_genie_scanner_space (ValaGenieScanner* self);
static void vala_genie_scanner_skip_space_tabs (ValaGenieScanner* self);
static inline gboolean vala_genie_scanner_newline (ValaGenieScanner* self);
static gboolean vala_genie_scanner_skip_newlines (ValaGenieScanner* self);
static gint vala_genie_scanner_count_tabs (ValaGenieScanner* self);
static void _vala_array_add7 (ValaGenieScannerState* * array,
                       gint* length,
                       gint* size,
                       ValaGenieScannerState value);
static void _vala_array_add8 (ValaGenieScannerState* * array,
                       gint* length,
                       gint* size,
                       ValaGenieScannerState value);
static void _vala_array_add9 (ValaGenieScannerState* * array,
                       gint* length,
                       gint* size,
                       ValaGenieScannerState value);
static void _vala_array_add10 (ValaGenieScannerState* * array,
                        gint* length,
                        gint* size,
                        ValaGenieScannerState value);
static void _vala_array_add11 (ValaGenieScannerState* * array,
                        gint* length,
                        gint* size,
                        ValaGenieScannerState value);
static gboolean vala_genie_scanner_whitespace (ValaGenieScanner* self);
static void vala_genie_scanner_pp_directive (ValaGenieScanner* self);
static gboolean vala_genie_scanner_comment (ValaGenieScanner* self,
                                     gboolean file_comment);
static void vala_genie_scanner_push_comment (ValaGenieScanner* self,
                                      const gchar* comment_item,
                                      ValaSourceReference* source_reference,
                                      gboolean file_comment);
static gboolean vala_genie_scanner_skip_tabs (ValaGenieScanner* self);
static gboolean vala_genie_scanner_pp_whitespace (ValaGenieScanner* self);
static void vala_genie_scanner_pp_space (ValaGenieScanner* self);
static void vala_genie_scanner_parse_pp_if (ValaGenieScanner* self);
static void vala_genie_scanner_parse_pp_elif (ValaGenieScanner* self);
static void vala_genie_scanner_parse_pp_else (ValaGenieScanner* self);
static void vala_genie_scanner_parse_pp_endif (ValaGenieScanner* self);
static void vala_genie_scanner_pp_eol (ValaGenieScanner* self);
static gboolean vala_genie_scanner_parse_pp_expression (ValaGenieScanner* self);
static void _vala_array_add12 (ValaGenieScannerConditional* * array,
                        gint* length,
                        gint* size,
                        const ValaGenieScannerConditional* value);
static gboolean vala_genie_scanner_parse_pp_symbol (ValaGenieScanner* self);
static gboolean vala_genie_scanner_parse_pp_primary_expression (ValaGenieScanner* self);
static gboolean vala_genie_scanner_parse_pp_unary_expression (ValaGenieScanner* self);
static gboolean vala_genie_scanner_parse_pp_equality_expression (ValaGenieScanner* self);
static gboolean vala_genie_scanner_parse_pp_and_expression (ValaGenieScanner* self);
static gboolean vala_genie_scanner_parse_pp_or_expression (ValaGenieScanner* self);
static void vala_genie_scanner_finalize (ValaGenieScanner * obj);
static GType vala_genie_scanner_get_type_once (void);

static inline gpointer
vala_genie_scanner_get_instance_private (ValaGenieScanner* self)
{
	return G_STRUCT_MEMBER_P (self, ValaGenieScanner_private_offset);
}

static GType
vala_genie_scanner_state_get_type_once (void)
{
	static const GEnumValue values[] = {{VALA_GENIE_SCANNER_STATE_PARENS, "VALA_GENIE_SCANNER_STATE_PARENS", "parens"}, {VALA_GENIE_SCANNER_STATE_BRACE, "VALA_GENIE_SCANNER_STATE_BRACE", "brace"}, {VALA_GENIE_SCANNER_STATE_BRACKET, "VALA_GENIE_SCANNER_STATE_BRACKET", "bracket"}, {VALA_GENIE_SCANNER_STATE_REGEX_LITERAL, "VALA_GENIE_SCANNER_STATE_REGEX_LITERAL", "regex-literal"}, {VALA_GENIE_SCANNER_STATE_TEMPLATE, "VALA_GENIE_SCANNER_STATE_TEMPLATE", "template"}, {VALA_GENIE_SCANNER_STATE_TEMPLATE_PART, "VALA_GENIE_SCANNER_STATE_TEMPLATE_PART", "template-part"}, {0, NULL, NULL}};
	GType vala_genie_scanner_state_type_id;
	vala_genie_scanner_state_type_id = g_enum_register_static ("ValaGenieScannerState", values);
	return vala_genie_scanner_state_type_id;
}

static GType
vala_genie_scanner_state_get_type (void)
{
	static volatile gsize vala_genie_scanner_state_type_id__volatile = 0;
	if (g_once_init_enter (&vala_genie_scanner_state_type_id__volatile)) {
		GType vala_genie_scanner_state_type_id;
		vala_genie_scanner_state_type_id = vala_genie_scanner_state_get_type_once ();
		g_once_init_leave (&vala_genie_scanner_state_type_id__volatile, vala_genie_scanner_state_type_id);
	}
	return vala_genie_scanner_state_type_id__volatile;
}

ValaSourceFile*
vala_genie_scanner_get_source_file (ValaGenieScanner* self)
{
	ValaSourceFile* result;
	ValaSourceFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_file;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static void
vala_genie_scanner_set_source_file (ValaGenieScanner* self,
                                    ValaSourceFile* value)
{
	ValaSourceFile* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_source_file_ref0 (value);
	_vala_source_file_unref0 (self->priv->_source_file);
	self->priv->_source_file = _tmp0_;
}

gint
vala_genie_scanner_get_indent_spaces (ValaGenieScanner* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_indent_spaces;
	return result;
}

void
vala_genie_scanner_set_indent_spaces (ValaGenieScanner* self,
                                      gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_indent_spaces = value;
}

ValaGenieScanner*
vala_genie_scanner_construct (GType object_type,
                              ValaSourceFile* source_file)
{
	ValaGenieScanner* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (source_file != NULL, NULL);
	self = (ValaGenieScanner*) g_type_create_instance (object_type);
	vala_genie_scanner_set_source_file (self, source_file);
	_tmp0_ = vala_source_file_get_mapped_contents (source_file);
	self->priv->begin = _tmp0_;
	_tmp1_ = self->priv->begin;
	self->priv->end = _tmp1_ + vala_source_file_get_mapped_length (source_file);
	_tmp2_ = self->priv->begin;
	self->priv->current = _tmp2_;
	self->priv->_indent_spaces = 0;
	self->priv->line = 1;
	self->priv->column = 1;
	self->priv->current_indent_level = 0;
	self->priv->indent_level = 0;
	self->priv->pending_dedents = 0;
	self->priv->open_parens_count = 0;
	self->priv->open_brace_count = 0;
	self->priv->parse_started = FALSE;
	self->priv->last_token = VALA_GENIE_TOKEN_TYPE_NONE;
	return self;
}

ValaGenieScanner*
vala_genie_scanner_new (ValaSourceFile* source_file)
{
	return vala_genie_scanner_construct (VALA_GENIE_TYPE_SCANNER, source_file);
}

static gboolean
vala_genie_scanner_in_template (ValaGenieScanner* self)
{
	gboolean _tmp0_ = FALSE;
	ValaGenieScannerState* _tmp1_;
	gint _tmp1__length1;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->state_stack;
	_tmp1__length1 = self->priv->state_stack_length1;
	if (_tmp1__length1 > 0) {
		ValaGenieScannerState* _tmp2_;
		gint _tmp2__length1;
		ValaGenieScannerState* _tmp3_;
		gint _tmp3__length1;
		ValaGenieScannerState _tmp4_;
		_tmp2_ = self->priv->state_stack;
		_tmp2__length1 = self->priv->state_stack_length1;
		_tmp3_ = self->priv->state_stack;
		_tmp3__length1 = self->priv->state_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_ == VALA_GENIE_SCANNER_STATE_TEMPLATE;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_genie_scanner_in_template_part (ValaGenieScanner* self)
{
	gboolean _tmp0_ = FALSE;
	ValaGenieScannerState* _tmp1_;
	gint _tmp1__length1;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->state_stack;
	_tmp1__length1 = self->priv->state_stack_length1;
	if (_tmp1__length1 > 0) {
		ValaGenieScannerState* _tmp2_;
		gint _tmp2__length1;
		ValaGenieScannerState* _tmp3_;
		gint _tmp3__length1;
		ValaGenieScannerState _tmp4_;
		_tmp2_ = self->priv->state_stack;
		_tmp2__length1 = self->priv->state_stack_length1;
		_tmp3_ = self->priv->state_stack;
		_tmp3__length1 = self->priv->state_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_ == VALA_GENIE_SCANNER_STATE_TEMPLATE_PART;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_genie_scanner_is_ident_char (ValaGenieScanner* self,
                                  gchar c)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (g_ascii_isalnum (c)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = c == '_';
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_genie_scanner_in_regex_literal (ValaGenieScanner* self)
{
	gboolean _tmp0_ = FALSE;
	ValaGenieScannerState* _tmp1_;
	gint _tmp1__length1;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->state_stack;
	_tmp1__length1 = self->priv->state_stack_length1;
	if (_tmp1__length1 > 0) {
		ValaGenieScannerState* _tmp2_;
		gint _tmp2__length1;
		ValaGenieScannerState* _tmp3_;
		gint _tmp3__length1;
		ValaGenieScannerState _tmp4_;
		_tmp2_ = self->priv->state_stack;
		_tmp2__length1 = self->priv->state_stack_length1;
		_tmp3_ = self->priv->state_stack;
		_tmp3__length1 = self->priv->state_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_ == VALA_GENIE_SCANNER_STATE_REGEX_LITERAL;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static ValaSourceReference*
vala_genie_scanner_get_source_reference (ValaGenieScanner* self,
                                         gint offset,
                                         gint length)
{
	ValaSourceFile* _tmp0_;
	gchar* _tmp1_;
	ValaSourceLocation _tmp2_ = {0};
	gchar* _tmp3_;
	ValaSourceLocation _tmp4_ = {0};
	ValaSourceReference* _tmp5_;
	ValaSourceReference* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_file;
	_tmp1_ = self->priv->current;
	vala_source_location_init (&_tmp2_, _tmp1_, self->priv->line, self->priv->column + offset);
	_tmp3_ = self->priv->current;
	vala_source_location_init (&_tmp4_, _tmp3_ + length, self->priv->line, (self->priv->column + offset) + length);
	_tmp5_ = vala_source_reference_new (_tmp0_, &_tmp2_, &_tmp4_);
	result = _tmp5_;
	return result;
}

ValaGenieTokenType
vala_genie_scanner_read_regex_token (ValaGenieScanner* self,
                                     ValaSourceLocation* token_begin,
                                     ValaSourceLocation* token_end)
{
	ValaSourceLocation _vala_token_begin = {0};
	ValaSourceLocation _vala_token_end = {0};
	ValaGenieTokenType type = 0;
	gchar* begin = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint token_length_in_chars = 0;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp111_;
	ValaGenieTokenType result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->current;
	begin = _tmp0_;
	_tmp1_ = begin;
	vala_source_location_init (&_vala_token_begin, _tmp1_, self->priv->line, self->priv->column);
	token_length_in_chars = -1;
	_tmp2_ = self->priv->current;
	_tmp3_ = self->priv->end;
	if (_tmp2_ >= _tmp3_) {
		type = VALA_GENIE_TOKEN_TYPE_EOF;
	} else {
		gchar* _tmp4_;
		gchar _tmp5_;
		_tmp4_ = self->priv->current;
		_tmp5_ = _tmp4_[0];
		switch (_tmp5_) {
			case '/':
			{
				gchar* _tmp6_;
				gint _tmp7_;
				gboolean fl_i = FALSE;
				gboolean fl_s = FALSE;
				gboolean fl_m = FALSE;
				gboolean fl_x = FALSE;
				type = VALA_GENIE_TOKEN_TYPE_CLOSE_REGEX_LITERAL;
				_tmp6_ = self->priv->current;
				self->priv->current = _tmp6_ + 1;
				_tmp7_ = self->priv->state_stack_length1;
				self->priv->state_stack_length1 = _tmp7_ - 1;
				fl_i = FALSE;
				fl_s = FALSE;
				fl_m = FALSE;
				fl_x = FALSE;
				while (TRUE) {
					gboolean _tmp8_ = FALSE;
					gboolean _tmp9_ = FALSE;
					gboolean _tmp10_ = FALSE;
					gchar* _tmp11_;
					gchar _tmp12_;
					gchar* _tmp19_;
					gchar _tmp20_;
					gchar* _tmp29_;
					gint _tmp30_;
					_tmp11_ = self->priv->current;
					_tmp12_ = _tmp11_[0];
					if (_tmp12_ == 'i') {
						_tmp10_ = TRUE;
					} else {
						gchar* _tmp13_;
						gchar _tmp14_;
						_tmp13_ = self->priv->current;
						_tmp14_ = _tmp13_[0];
						_tmp10_ = _tmp14_ == 's';
					}
					if (_tmp10_) {
						_tmp9_ = TRUE;
					} else {
						gchar* _tmp15_;
						gchar _tmp16_;
						_tmp15_ = self->priv->current;
						_tmp16_ = _tmp15_[0];
						_tmp9_ = _tmp16_ == 'm';
					}
					if (_tmp9_) {
						_tmp8_ = TRUE;
					} else {
						gchar* _tmp17_;
						gchar _tmp18_;
						_tmp17_ = self->priv->current;
						_tmp18_ = _tmp17_[0];
						_tmp8_ = _tmp18_ == 'x';
					}
					if (!_tmp8_) {
						break;
					}
					_tmp19_ = self->priv->current;
					_tmp20_ = _tmp19_[0];
					switch (_tmp20_) {
						case 'i':
						{
							if (fl_i) {
								ValaSourceReference* _tmp21_;
								ValaSourceReference* _tmp22_;
								_tmp21_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
								_tmp22_ = _tmp21_;
								vala_report_error (_tmp22_, "modifier 'i' used more than once");
								_vala_source_reference_unref0 (_tmp22_);
							}
							fl_i = TRUE;
							break;
						}
						case 's':
						{
							if (fl_s) {
								ValaSourceReference* _tmp23_;
								ValaSourceReference* _tmp24_;
								_tmp23_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
								_tmp24_ = _tmp23_;
								vala_report_error (_tmp24_, "modifier 's' used more than once");
								_vala_source_reference_unref0 (_tmp24_);
							}
							fl_s = TRUE;
							break;
						}
						case 'm':
						{
							if (fl_m) {
								ValaSourceReference* _tmp25_;
								ValaSourceReference* _tmp26_;
								_tmp25_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
								_tmp26_ = _tmp25_;
								vala_report_error (_tmp26_, "modifier 'm' used more than once");
								_vala_source_reference_unref0 (_tmp26_);
							}
							fl_m = TRUE;
							break;
						}
						case 'x':
						{
							if (fl_x) {
								ValaSourceReference* _tmp27_;
								ValaSourceReference* _tmp28_;
								_tmp27_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
								_tmp28_ = _tmp27_;
								vala_report_error (_tmp28_, "modifier 'x' used more than once");
								_vala_source_reference_unref0 (_tmp28_);
							}
							fl_x = TRUE;
							break;
						}
						default:
						break;
					}
					_tmp29_ = self->priv->current;
					self->priv->current = _tmp29_ + 1;
					_tmp30_ = token_length_in_chars;
					token_length_in_chars = _tmp30_ + 1;
				}
				break;
			}
			default:
			{
				gboolean _tmp98_ = FALSE;
				gchar* _tmp99_;
				gchar* _tmp100_;
				type = VALA_GENIE_TOKEN_TYPE_REGEX_LITERAL;
				token_length_in_chars = 0;
				while (TRUE) {
					gboolean _tmp31_ = FALSE;
					gchar* _tmp32_;
					gchar* _tmp33_;
					gchar* _tmp36_;
					gchar _tmp37_;
					_tmp32_ = self->priv->current;
					_tmp33_ = self->priv->end;
					if (_tmp32_ < _tmp33_) {
						gchar* _tmp34_;
						gchar _tmp35_;
						_tmp34_ = self->priv->current;
						_tmp35_ = _tmp34_[0];
						_tmp31_ = _tmp35_ != '/';
					} else {
						_tmp31_ = FALSE;
					}
					if (!_tmp31_) {
						break;
					}
					_tmp36_ = self->priv->current;
					_tmp37_ = _tmp36_[0];
					if (_tmp37_ == '\\') {
						gchar* _tmp38_;
						gint _tmp39_;
						gchar* _tmp40_;
						gchar* _tmp41_;
						gchar* _tmp42_;
						gchar _tmp43_;
						_tmp38_ = self->priv->current;
						self->priv->current = _tmp38_ + 1;
						_tmp39_ = token_length_in_chars;
						token_length_in_chars = _tmp39_ + 1;
						_tmp40_ = self->priv->current;
						_tmp41_ = self->priv->end;
						if (_tmp40_ >= _tmp41_) {
							break;
						}
						_tmp42_ = self->priv->current;
						_tmp43_ = _tmp42_[0];
						switch (_tmp43_) {
							case '\'':
							case '"':
							case '\\':
							case '/':
							case '^':
							case '$':
							case '.':
							case '[':
							case ']':
							case '{':
							case '}':
							case '(':
							case ')':
							case '?':
							case '*':
							case '+':
							case '-':
							case '#':
							case '&':
							case '~':
							case ':':
							case ';':
							case '<':
							case '>':
							case '|':
							case '%':
							case '=':
							case '@':
							case '0':
							case 'b':
							case 'B':
							case 'f':
							case 'n':
							case 'N':
							case 'r':
							case 'R':
							case 't':
							case 'v':
							case 'a':
							case 'A':
							case 'p':
							case 'P':
							case 'e':
							case 'd':
							case 'D':
							case 's':
							case 'S':
							case 'w':
							case 'W':
							case 'G':
							case 'z':
							case 'Z':
							{
								gchar* _tmp44_;
								gint _tmp45_;
								_tmp44_ = self->priv->current;
								self->priv->current = _tmp44_ + 1;
								_tmp45_ = token_length_in_chars;
								token_length_in_chars = _tmp45_ + 1;
								break;
							}
							case 'u':
							{
								gchar* _tmp46_;
								gint _tmp47_;
								gint digit_length = 0;
								_tmp46_ = self->priv->current;
								self->priv->current = _tmp46_ + 1;
								_tmp47_ = token_length_in_chars;
								token_length_in_chars = _tmp47_ + 1;
								{
									gboolean _tmp48_ = FALSE;
									digit_length = 0;
									_tmp48_ = TRUE;
									while (TRUE) {
										gboolean _tmp50_ = FALSE;
										gchar* _tmp51_;
										gchar* _tmp52_;
										gchar* _tmp55_;
										gint _tmp56_;
										if (!_tmp48_) {
											gint _tmp49_;
											_tmp49_ = digit_length;
											digit_length = _tmp49_ + 1;
										}
										_tmp48_ = FALSE;
										_tmp51_ = self->priv->current;
										_tmp52_ = self->priv->end;
										if (_tmp51_ < _tmp52_) {
											gchar* _tmp53_;
											gchar _tmp54_;
											_tmp53_ = self->priv->current;
											_tmp54_ = _tmp53_[0];
											_tmp50_ = g_ascii_isxdigit (_tmp54_);
										} else {
											_tmp50_ = FALSE;
										}
										if (!_tmp50_) {
											break;
										}
										_tmp55_ = self->priv->current;
										self->priv->current = _tmp55_ + 1;
										_tmp56_ = token_length_in_chars;
										token_length_in_chars = _tmp56_ + 1;
									}
								}
								if (digit_length < 1) {
									ValaSourceReference* _tmp57_;
									ValaSourceReference* _tmp58_;
									_tmp57_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
									_tmp58_ = _tmp57_;
									vala_report_error (_tmp58_, "\\u used with no following hex digits");
									_vala_source_reference_unref0 (_tmp58_);
								} else {
									if (digit_length < 4) {
										ValaSourceReference* _tmp59_;
										ValaSourceReference* _tmp60_;
										_tmp59_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
										_tmp60_ = _tmp59_;
										vala_report_error (_tmp60_, "incomplete universal character name");
										_vala_source_reference_unref0 (_tmp60_);
									}
								}
								break;
							}
							case 'x':
							{
								gchar* _tmp61_;
								gint _tmp62_;
								gint digit_length = 0;
								_tmp61_ = self->priv->current;
								self->priv->current = _tmp61_ + 1;
								_tmp62_ = token_length_in_chars;
								token_length_in_chars = _tmp62_ + 1;
								{
									gboolean _tmp63_ = FALSE;
									digit_length = 0;
									_tmp63_ = TRUE;
									while (TRUE) {
										gboolean _tmp64_ = FALSE;
										gchar* _tmp65_;
										gchar* _tmp66_;
										gchar* _tmp69_;
										gchar _tmp70_;
										gchar* _tmp72_;
										gint _tmp73_;
										if (!_tmp63_) {
										}
										_tmp63_ = FALSE;
										_tmp65_ = self->priv->current;
										_tmp66_ = self->priv->end;
										if (_tmp65_ < _tmp66_) {
											gchar* _tmp67_;
											gchar _tmp68_;
											_tmp67_ = self->priv->current;
											_tmp68_ = _tmp67_[0];
											_tmp64_ = g_ascii_isxdigit (_tmp68_);
										} else {
											_tmp64_ = FALSE;
										}
										if (!_tmp64_) {
											break;
										}
										_tmp69_ = self->priv->current;
										_tmp70_ = _tmp69_[0];
										if (_tmp70_ != '0') {
											gint _tmp71_;
											_tmp71_ = digit_length;
											digit_length = _tmp71_ + 1;
										}
										_tmp72_ = self->priv->current;
										self->priv->current = _tmp72_ + 1;
										_tmp73_ = token_length_in_chars;
										token_length_in_chars = _tmp73_ + 1;
									}
								}
								if (digit_length < 1) {
									ValaSourceReference* _tmp74_;
									ValaSourceReference* _tmp75_;
									_tmp74_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
									_tmp75_ = _tmp74_;
									vala_report_error (_tmp75_, "\\x used with no following hex digits");
									_vala_source_reference_unref0 (_tmp75_);
								} else {
									if (digit_length > 2) {
										ValaSourceReference* _tmp76_;
										ValaSourceReference* _tmp77_;
										_tmp76_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
										_tmp77_ = _tmp76_;
										vala_report_error (_tmp77_, "hex escape sequence out of range");
										_vala_source_reference_unref0 (_tmp77_);
									}
								}
								break;
							}
							default:
							{
								gchar* _tmp78_;
								gchar _tmp79_;
								_tmp78_ = self->priv->current;
								_tmp79_ = _tmp78_[0];
								if (g_ascii_isdigit (_tmp79_)) {
									gchar* _tmp80_;
									gint _tmp81_;
									gchar* _tmp82_;
									gchar _tmp83_;
									_tmp80_ = self->priv->current;
									self->priv->current = _tmp80_ + 1;
									_tmp81_ = token_length_in_chars;
									token_length_in_chars = _tmp81_ + 1;
									_tmp82_ = self->priv->current;
									_tmp83_ = _tmp82_[0];
									if (g_ascii_isdigit (_tmp83_)) {
										gchar* _tmp84_;
										gint _tmp85_;
										_tmp84_ = self->priv->current;
										self->priv->current = _tmp84_ + 1;
										_tmp85_ = token_length_in_chars;
										token_length_in_chars = _tmp85_ + 1;
									}
								} else {
									ValaSourceReference* _tmp86_;
									ValaSourceReference* _tmp87_;
									_tmp86_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
									_tmp87_ = _tmp86_;
									vala_report_error (_tmp87_, "invalid escape sequence");
									_vala_source_reference_unref0 (_tmp87_);
								}
								break;
							}
						}
					} else {
						gchar* _tmp88_;
						gchar _tmp89_;
						_tmp88_ = self->priv->current;
						_tmp89_ = _tmp88_[0];
						if (_tmp89_ == '\n') {
							break;
						} else {
							gunichar u = 0U;
							gchar* _tmp90_;
							gchar* _tmp91_;
							gchar* _tmp92_;
							_tmp90_ = self->priv->current;
							_tmp91_ = self->priv->end;
							_tmp92_ = self->priv->current;
							u = g_utf8_get_char_validated ((const gchar*) _tmp90_, (gssize) ((glong) (_tmp91_ - _tmp92_)));
							if (u != ((gunichar) -1)) {
								gchar* _tmp93_;
								gint _tmp94_;
								_tmp93_ = self->priv->current;
								self->priv->current = _tmp93_ + g_unichar_to_utf8 (u, NULL);
								_tmp94_ = token_length_in_chars;
								token_length_in_chars = _tmp94_ + 1;
							} else {
								gchar* _tmp95_;
								ValaSourceReference* _tmp96_;
								ValaSourceReference* _tmp97_;
								_tmp95_ = self->priv->current;
								self->priv->current = _tmp95_ + 1;
								_tmp96_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
								_tmp97_ = _tmp96_;
								vala_report_error (_tmp97_, "invalid UTF-8 character");
								_vala_source_reference_unref0 (_tmp97_);
							}
						}
					}
				}
				_tmp99_ = self->priv->current;
				_tmp100_ = self->priv->end;
				if (_tmp99_ >= _tmp100_) {
					_tmp98_ = TRUE;
				} else {
					gchar* _tmp101_;
					gchar _tmp102_;
					_tmp101_ = self->priv->current;
					_tmp102_ = _tmp101_[0];
					_tmp98_ = _tmp102_ == '\n';
				}
				if (_tmp98_) {
					ValaSourceReference* _tmp103_;
					ValaSourceReference* _tmp104_;
					gint _tmp105_;
					ValaSourceLocation _tmp106_ = {0};
					ValaSourceLocation _tmp107_ = {0};
					ValaGenieTokenType _tmp108_;
					_tmp103_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
					_tmp104_ = _tmp103_;
					vala_report_error (_tmp104_, "syntax error, expected \"");
					_vala_source_reference_unref0 (_tmp104_);
					_tmp105_ = self->priv->state_stack_length1;
					self->priv->state_stack_length1 = _tmp105_ - 1;
					_tmp108_ = vala_genie_scanner_read_token (self, &_tmp106_, &_tmp107_);
					_vala_token_begin = _tmp106_;
					_vala_token_end = _tmp107_;
					result = _tmp108_;
					if (token_begin) {
						*token_begin = _vala_token_begin;
					}
					if (token_end) {
						*token_end = _vala_token_end;
					}
					return result;
				}
				break;
			}
		}
	}
	if (token_length_in_chars < 0) {
		gchar* _tmp109_;
		gchar* _tmp110_;
		_tmp109_ = self->priv->current;
		_tmp110_ = begin;
		self->priv->column = self->priv->column + ((gint) (_tmp109_ - _tmp110_));
	} else {
		self->priv->column = self->priv->column + token_length_in_chars;
	}
	_tmp111_ = self->priv->current;
	vala_source_location_init (&_vala_token_end, _tmp111_, self->priv->line, self->priv->column - 1);
	result = type;
	if (token_begin) {
		*token_begin = _vala_token_begin;
	}
	if (token_end) {
		*token_end = _vala_token_end;
	}
	return result;
}

void
vala_genie_scanner_seek (ValaGenieScanner* self,
                         ValaSourceLocation* location)
{
	ValaSourceLocation _tmp0_;
	gchar* _tmp1_;
	ValaSourceLocation _tmp2_;
	ValaSourceLocation _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_tmp0_ = *location;
	_tmp1_ = _tmp0_.pos;
	self->priv->current = _tmp1_;
	_tmp2_ = *location;
	self->priv->line = _tmp2_.line;
	_tmp3_ = *location;
	self->priv->column = _tmp3_.column;
	self->priv->conditional_stack = (g_free (self->priv->conditional_stack), NULL);
	self->priv->conditional_stack = NULL;
	self->priv->conditional_stack_length1 = 0;
	self->priv->_conditional_stack_size_ = self->priv->conditional_stack_length1;
	self->priv->state_stack = (g_free (self->priv->state_stack), NULL);
	self->priv->state_stack = NULL;
	self->priv->state_stack_length1 = 0;
	self->priv->_state_stack_size_ = self->priv->state_stack_length1;
}

ValaGenieTokenType
vala_genie_scanner_get_identifier_or_keyword (gchar* begin,
                                              gint len)
{
	ValaGenieTokenType result = 0;
	switch (len) {
		case 2:
		{
			gchar _tmp0_;
			_tmp0_ = begin[0];
			switch (_tmp0_) {
				case 'a':
				{
					if (vala_genie_scanner_matches (begin, "as")) {
						result = VALA_GENIE_TOKEN_TYPE_AS;
						return result;
					}
					break;
				}
				case 'd':
				{
					if (vala_genie_scanner_matches (begin, "do")) {
						result = VALA_GENIE_TOKEN_TYPE_DO;
						return result;
					}
					break;
				}
				case 'i':
				{
					gchar _tmp1_;
					_tmp1_ = begin[1];
					switch (_tmp1_) {
						case 'f':
						{
							result = VALA_GENIE_TOKEN_TYPE_IF;
							return result;
						}
						case 'n':
						{
							result = VALA_GENIE_TOKEN_TYPE_IN;
							return result;
						}
						case 's':
						{
							result = VALA_GENIE_TOKEN_TYPE_IS;
							return result;
						}
						default:
						break;
					}
					break;
				}
				case 'o':
				{
					if (vala_genie_scanner_matches (begin, "of")) {
						result = VALA_GENIE_TOKEN_TYPE_OF;
						return result;
					}
					if (vala_genie_scanner_matches (begin, "or")) {
						result = VALA_GENIE_TOKEN_TYPE_OP_OR;
						return result;
					}
					break;
				}
				case 't':
				{
					if (vala_genie_scanner_matches (begin, "to")) {
						result = VALA_GENIE_TOKEN_TYPE_TO;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 3:
		{
			gchar _tmp2_;
			_tmp2_ = begin[0];
			switch (_tmp2_) {
				case 'a':
				{
					if (vala_genie_scanner_matches (begin, "and")) {
						result = VALA_GENIE_TOKEN_TYPE_OP_AND;
						return result;
					}
					break;
				}
				case 'd':
				{
					if (vala_genie_scanner_matches (begin, "def")) {
						result = VALA_GENIE_TOKEN_TYPE_DEF;
						return result;
					}
					break;
				}
				case 'f':
				{
					if (vala_genie_scanner_matches (begin, "for")) {
						result = VALA_GENIE_TOKEN_TYPE_FOR;
						return result;
					}
					break;
				}
				case 'g':
				{
					if (vala_genie_scanner_matches (begin, "get")) {
						result = VALA_GENIE_TOKEN_TYPE_GET;
						return result;
					}
					break;
				}
				case 'i':
				{
					if (vala_genie_scanner_matches (begin, "isa")) {
						result = VALA_GENIE_TOKEN_TYPE_ISA;
						return result;
					}
					break;
				}
				case 'n':
				{
					gchar _tmp3_;
					_tmp3_ = begin[1];
					switch (_tmp3_) {
						case 'e':
						{
							if (vala_genie_scanner_matches (begin, "new")) {
								result = VALA_GENIE_TOKEN_TYPE_NEW;
								return result;
							}
							break;
						}
						case 'o':
						{
							if (vala_genie_scanner_matches (begin, "not")) {
								result = VALA_GENIE_TOKEN_TYPE_OP_NEG;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'o':
				{
					if (vala_genie_scanner_matches (begin, "out")) {
						result = VALA_GENIE_TOKEN_TYPE_OUT;
						return result;
					}
					break;
				}
				case 'r':
				{
					if (vala_genie_scanner_matches (begin, "ref")) {
						result = VALA_GENIE_TOKEN_TYPE_REF;
						return result;
					}
					break;
				}
				case 's':
				{
					if (vala_genie_scanner_matches (begin, "set")) {
						result = VALA_GENIE_TOKEN_TYPE_SET;
						return result;
					}
					break;
				}
				case 't':
				{
					if (vala_genie_scanner_matches (begin, "try")) {
						result = VALA_GENIE_TOKEN_TYPE_TRY;
						return result;
					}
					break;
				}
				case 'v':
				{
					if (vala_genie_scanner_matches (begin, "var")) {
						result = VALA_GENIE_TOKEN_TYPE_VAR;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 4:
		{
			gchar _tmp4_;
			_tmp4_ = begin[0];
			switch (_tmp4_) {
				case 'c':
				{
					if (vala_genie_scanner_matches (begin, "case")) {
						result = VALA_GENIE_TOKEN_TYPE_CASE;
						return result;
					}
					break;
				}
				case 'd':
				{
					if (vala_genie_scanner_matches (begin, "dict")) {
						result = VALA_GENIE_TOKEN_TYPE_DICT;
						return result;
					}
					break;
				}
				case 'e':
				{
					gchar _tmp5_;
					_tmp5_ = begin[1];
					switch (_tmp5_) {
						case 'l':
						{
							if (vala_genie_scanner_matches (begin, "else")) {
								result = VALA_GENIE_TOKEN_TYPE_ELSE;
								return result;
							}
							break;
						}
						case 'n':
						{
							if (vala_genie_scanner_matches (begin, "enum")) {
								result = VALA_GENIE_TOKEN_TYPE_ENUM;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'i':
				{
					if (vala_genie_scanner_matches (begin, "init")) {
						result = VALA_GENIE_TOKEN_TYPE_INIT;
						return result;
					}
					break;
				}
				case 'l':
				{
					gchar _tmp6_;
					_tmp6_ = begin[1];
					switch (_tmp6_) {
						case 'i':
						{
							if (vala_genie_scanner_matches (begin, "list")) {
								result = VALA_GENIE_TOKEN_TYPE_LIST;
								return result;
							}
							break;
						}
						case 'o':
						{
							if (vala_genie_scanner_matches (begin, "lock")) {
								result = VALA_GENIE_TOKEN_TYPE_LOCK;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'n':
				{
					if (vala_genie_scanner_matches (begin, "null")) {
						result = VALA_GENIE_TOKEN_TYPE_NULL;
						return result;
					}
					break;
				}
				case 'p':
				{
					gchar _tmp7_;
					_tmp7_ = begin[1];
					switch (_tmp7_) {
						case 'a':
						{
							if (vala_genie_scanner_matches (begin, "pass")) {
								result = VALA_GENIE_TOKEN_TYPE_PASS;
								return result;
							}
							break;
						}
						case 'r':
						{
							if (vala_genie_scanner_matches (begin, "prop")) {
								result = VALA_GENIE_TOKEN_TYPE_PROP;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 's':
				{
					if (vala_genie_scanner_matches (begin, "self")) {
						result = VALA_GENIE_TOKEN_TYPE_SELF;
						return result;
					}
					break;
				}
				case 't':
				{
					if (vala_genie_scanner_matches (begin, "true")) {
						result = VALA_GENIE_TOKEN_TYPE_TRUE;
						return result;
					}
					break;
				}
				case 'u':
				{
					if (vala_genie_scanner_matches (begin, "uses")) {
						result = VALA_GENIE_TOKEN_TYPE_USES;
						return result;
					}
					break;
				}
				case 'v':
				{
					if (vala_genie_scanner_matches (begin, "void")) {
						result = VALA_GENIE_TOKEN_TYPE_VOID;
						return result;
					}
					break;
				}
				case 'w':
				{
					gchar _tmp8_;
					_tmp8_ = begin[1];
					switch (_tmp8_) {
						case 'e':
						{
							if (vala_genie_scanner_matches (begin, "weak")) {
								result = VALA_GENIE_TOKEN_TYPE_WEAK;
								return result;
							}
							break;
						}
						case 'h':
						{
							if (vala_genie_scanner_matches (begin, "when")) {
								result = VALA_GENIE_TOKEN_TYPE_WHEN;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 5:
		{
			gchar _tmp9_;
			_tmp9_ = begin[0];
			switch (_tmp9_) {
				case 'a':
				{
					gchar _tmp10_;
					_tmp10_ = begin[1];
					switch (_tmp10_) {
						case 'r':
						{
							if (vala_genie_scanner_matches (begin, "array")) {
								result = VALA_GENIE_TOKEN_TYPE_ARRAY;
								return result;
							}
							break;
						}
						case 's':
						{
							if (vala_genie_scanner_matches (begin, "async")) {
								result = VALA_GENIE_TOKEN_TYPE_ASYNC;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'b':
				{
					if (vala_genie_scanner_matches (begin, "break")) {
						result = VALA_GENIE_TOKEN_TYPE_BREAK;
						return result;
					}
					break;
				}
				case 'c':
				{
					gchar _tmp11_;
					_tmp11_ = begin[1];
					switch (_tmp11_) {
						case 'l':
						{
							if (vala_genie_scanner_matches (begin, "class")) {
								result = VALA_GENIE_TOKEN_TYPE_CLASS;
								return result;
							}
							break;
						}
						case 'o':
						{
							if (vala_genie_scanner_matches (begin, "const")) {
								result = VALA_GENIE_TOKEN_TYPE_CONST;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'e':
				{
					if (vala_genie_scanner_matches (begin, "event")) {
						result = VALA_GENIE_TOKEN_TYPE_EVENT;
						return result;
					}
					break;
				}
				case 'f':
				{
					gchar _tmp12_;
					_tmp12_ = begin[1];
					switch (_tmp12_) {
						case 'a':
						{
							if (vala_genie_scanner_matches (begin, "false")) {
								result = VALA_GENIE_TOKEN_TYPE_FALSE;
								return result;
							}
							break;
						}
						case 'i':
						{
							if (vala_genie_scanner_matches (begin, "final")) {
								result = VALA_GENIE_TOKEN_TYPE_FINAL;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'o':
				{
					if (vala_genie_scanner_matches (begin, "owned")) {
						result = VALA_GENIE_TOKEN_TYPE_OWNED;
						return result;
					}
					break;
				}
				case 'p':
				{
					if (vala_genie_scanner_matches (begin, "print")) {
						result = VALA_GENIE_TOKEN_TYPE_PRINT;
						return result;
					}
					break;
				}
				case 's':
				{
					if (vala_genie_scanner_matches (begin, "super")) {
						result = VALA_GENIE_TOKEN_TYPE_SUPER;
						return result;
					}
					break;
				}
				case 'r':
				{
					if (vala_genie_scanner_matches (begin, "raise")) {
						result = VALA_GENIE_TOKEN_TYPE_RAISE;
						return result;
					}
					break;
				}
				case 'w':
				{
					if (vala_genie_scanner_matches (begin, "while")) {
						result = VALA_GENIE_TOKEN_TYPE_WHILE;
						return result;
					}
					break;
				}
				case 'y':
				{
					if (vala_genie_scanner_matches (begin, "yield")) {
						result = VALA_GENIE_TOKEN_TYPE_YIELD;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 6:
		{
			gchar _tmp13_;
			_tmp13_ = begin[0];
			switch (_tmp13_) {
				case 'a':
				{
					if (vala_genie_scanner_matches (begin, "assert")) {
						result = VALA_GENIE_TOKEN_TYPE_ASSERT;
						return result;
					}
					break;
				}
				case 'd':
				{
					gchar _tmp14_;
					_tmp14_ = begin[1];
					switch (_tmp14_) {
						case 'e':
						{
							if (vala_genie_scanner_matches (begin, "delete")) {
								result = VALA_GENIE_TOKEN_TYPE_DELETE;
								return result;
							}
							break;
						}
						case 'o':
						{
							if (vala_genie_scanner_matches (begin, "downto")) {
								result = VALA_GENIE_TOKEN_TYPE_DOWNTO;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'e':
				{
					gchar _tmp15_;
					_tmp15_ = begin[1];
					switch (_tmp15_) {
						case 'x':
						{
							gchar _tmp16_;
							_tmp16_ = begin[2];
							switch (_tmp16_) {
								case 'c':
								{
									if (vala_genie_scanner_matches (begin, "except")) {
										result = VALA_GENIE_TOKEN_TYPE_EXCEPT;
										return result;
									}
									break;
								}
								case 't':
								{
									if (vala_genie_scanner_matches (begin, "extern")) {
										result = VALA_GENIE_TOKEN_TYPE_EXTERN;
										return result;
									}
									break;
								}
								default:
								break;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'i':
				{
					if (vala_genie_scanner_matches (begin, "inline")) {
						result = VALA_GENIE_TOKEN_TYPE_INLINE;
						return result;
					}
					break;
				}
				case 'p':
				{
					gchar _tmp17_;
					_tmp17_ = begin[1];
					switch (_tmp17_) {
						case 'a':
						{
							if (vala_genie_scanner_matches (begin, "params")) {
								result = VALA_GENIE_TOKEN_TYPE_PARAMS;
								return result;
							}
							break;
						}
						case 'u':
						{
							if (vala_genie_scanner_matches (begin, "public")) {
								result = VALA_GENIE_TOKEN_TYPE_PUBLIC;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'r':
				{
					gchar _tmp18_;
					_tmp18_ = begin[1];
					switch (_tmp18_) {
						case 'a':
						{
							if (vala_genie_scanner_matches (begin, "raises")) {
								result = VALA_GENIE_TOKEN_TYPE_RAISES;
								return result;
							}
							break;
						}
						case 'e':
						{
							if (vala_genie_scanner_matches (begin, "return")) {
								result = VALA_GENIE_TOKEN_TYPE_RETURN;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 's':
				{
					gchar _tmp19_;
					_tmp19_ = begin[1];
					switch (_tmp19_) {
						case 'e':
						{
							if (vala_genie_scanner_matches (begin, "sealed")) {
								result = VALA_GENIE_TOKEN_TYPE_SEALED;
								return result;
							}
							break;
						}
						case 'i':
						{
							if (vala_genie_scanner_matches (begin, "sizeof")) {
								result = VALA_GENIE_TOKEN_TYPE_SIZEOF;
								return result;
							}
							break;
						}
						case 't':
						{
							gchar _tmp20_;
							_tmp20_ = begin[2];
							switch (_tmp20_) {
								case 'a':
								{
									if (vala_genie_scanner_matches (begin, "static")) {
										result = VALA_GENIE_TOKEN_TYPE_STATIC;
										return result;
									}
									break;
								}
								case 'r':
								{
									if (vala_genie_scanner_matches (begin, "struct")) {
										result = VALA_GENIE_TOKEN_TYPE_STRUCT;
										return result;
									}
									break;
								}
								default:
								break;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 't':
				{
					if (vala_genie_scanner_matches (begin, "typeof")) {
						result = VALA_GENIE_TOKEN_TYPE_TYPEOF;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 7:
		{
			gchar _tmp21_;
			_tmp21_ = begin[0];
			switch (_tmp21_) {
				case 'd':
				{
					gchar _tmp22_;
					_tmp22_ = begin[1];
					switch (_tmp22_) {
						case 'e':
						{
							if (vala_genie_scanner_matches (begin, "default")) {
								result = VALA_GENIE_TOKEN_TYPE_DEFAULT;
								return result;
							}
							break;
						}
						case 'y':
						{
							if (vala_genie_scanner_matches (begin, "dynamic")) {
								result = VALA_GENIE_TOKEN_TYPE_DYNAMIC;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'e':
				{
					if (vala_genie_scanner_matches (begin, "ensures")) {
						result = VALA_GENIE_TOKEN_TYPE_ENSURES;
						return result;
					}
					break;
				}
				case 'f':
				{
					gchar _tmp23_;
					_tmp23_ = begin[1];
					switch (_tmp23_) {
						case 'i':
						{
							if (vala_genie_scanner_matches (begin, "finally")) {
								result = VALA_GENIE_TOKEN_TYPE_FINALLY;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'p':
				{
					if (vala_genie_scanner_matches (begin, "private")) {
						result = VALA_GENIE_TOKEN_TYPE_PRIVATE;
						return result;
					}
					break;
				}
				case 'u':
				{
					if (vala_genie_scanner_matches (begin, "unowned")) {
						result = VALA_GENIE_TOKEN_TYPE_UNOWNED;
						return result;
					}
					break;
				}
				case 'v':
				{
					if (vala_genie_scanner_matches (begin, "virtual")) {
						result = VALA_GENIE_TOKEN_TYPE_VIRTUAL;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 8:
		{
			gchar _tmp24_;
			_tmp24_ = begin[0];
			switch (_tmp24_) {
				case 'a':
				{
					if (vala_genie_scanner_matches (begin, "abstract")) {
						result = VALA_GENIE_TOKEN_TYPE_ABSTRACT;
						return result;
					}
					break;
				}
				case 'c':
				{
					if (vala_genie_scanner_matches (begin, "continue")) {
						result = VALA_GENIE_TOKEN_TYPE_CONTINUE;
						return result;
					}
					break;
				}
				case 'd':
				{
					if (vala_genie_scanner_matches (begin, "delegate")) {
						result = VALA_GENIE_TOKEN_TYPE_DELEGATE;
						return result;
					}
					break;
				}
				case 'i':
				{
					if (vala_genie_scanner_matches (begin, "internal")) {
						result = VALA_GENIE_TOKEN_TYPE_INTERNAL;
						return result;
					}
					break;
				}
				case 'o':
				{
					if (vala_genie_scanner_matches (begin, "override")) {
						result = VALA_GENIE_TOKEN_TYPE_OVERRIDE;
						return result;
					}
					break;
				}
				case 'r':
				{
					gchar _tmp25_;
					_tmp25_ = begin[2];
					switch (_tmp25_) {
						case 'a':
						{
							if (vala_genie_scanner_matches (begin, "readonly")) {
								result = VALA_GENIE_TOKEN_TYPE_READONLY;
								return result;
							}
							break;
						}
						case 'q':
						{
							if (vala_genie_scanner_matches (begin, "requires")) {
								result = VALA_GENIE_TOKEN_TYPE_REQUIRES;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'v':
				{
					if (vala_genie_scanner_matches (begin, "volatile")) {
						result = VALA_GENIE_TOKEN_TYPE_VOLATILE;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 9:
		{
			gchar _tmp26_;
			_tmp26_ = begin[0];
			switch (_tmp26_) {
				case 'c':
				{
					if (vala_genie_scanner_matches (begin, "construct")) {
						result = VALA_GENIE_TOKEN_TYPE_CONSTRUCT;
						return result;
					}
					break;
				}
				case 'e':
				{
					if (vala_genie_scanner_matches (begin, "exception")) {
						result = VALA_GENIE_TOKEN_TYPE_ERRORDOMAIN;
						return result;
					}
					break;
				}
				case 'i':
				{
					if (vala_genie_scanner_matches (begin, "interface")) {
						result = VALA_GENIE_TOKEN_TYPE_INTERFACE;
						return result;
					}
					break;
				}
				case 'n':
				{
					if (vala_genie_scanner_matches (begin, "namespace")) {
						result = VALA_GENIE_TOKEN_TYPE_NAMESPACE;
						return result;
					}
					break;
				}
				case 'p':
				{
					if (vala_genie_scanner_matches (begin, "protected")) {
						result = VALA_GENIE_TOKEN_TYPE_PROTECTED;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 10:
		{
			gchar _tmp27_;
			_tmp27_ = begin[0];
			switch (_tmp27_) {
				case 'i':
				{
					if (vala_genie_scanner_matches (begin, "implements")) {
						result = VALA_GENIE_TOKEN_TYPE_IMPLEMENTS;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		default:
		break;
	}
	result = VALA_GENIE_TOKEN_TYPE_IDENTIFIER;
	return result;
}

static void
_vala_array_add3 (ValaGenieScannerState* * array,
                  gint* length,
                  gint* size,
                  ValaGenieScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add4 (ValaGenieScannerState* * array,
                  gint* length,
                  gint* size,
                  ValaGenieScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add5 (ValaGenieScannerState* * array,
                  gint* length,
                  gint* size,
                  ValaGenieScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add6 (ValaGenieScannerState* * array,
                  gint* length,
                  gint* size,
                  ValaGenieScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}

ValaGenieTokenType
vala_genie_scanner_read_template_token (ValaGenieScanner* self,
                                        ValaSourceLocation* token_begin,
                                        ValaSourceLocation* token_end)
{
	ValaSourceLocation _vala_token_begin = {0};
	ValaSourceLocation _vala_token_end = {0};
	ValaGenieTokenType type = 0;
	gchar* begin = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint token_length_in_chars = 0;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp110_;
	ValaGenieTokenType result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->current;
	begin = _tmp0_;
	_tmp1_ = begin;
	vala_source_location_init (&_vala_token_begin, _tmp1_, self->priv->line, self->priv->column);
	token_length_in_chars = -1;
	_tmp2_ = self->priv->current;
	_tmp3_ = self->priv->end;
	if (_tmp2_ >= _tmp3_) {
		type = VALA_GENIE_TOKEN_TYPE_EOF;
	} else {
		gchar* _tmp4_;
		gchar _tmp5_;
		_tmp4_ = self->priv->current;
		_tmp5_ = _tmp4_[0];
		switch (_tmp5_) {
			case '"':
			{
				gchar* _tmp6_;
				gint _tmp7_;
				type = VALA_GENIE_TOKEN_TYPE_CLOSE_TEMPLATE;
				_tmp6_ = self->priv->current;
				self->priv->current = _tmp6_ + 1;
				_tmp7_ = self->priv->state_stack_length1;
				self->priv->state_stack_length1 = _tmp7_ - 1;
				break;
			}
			case '$':
			{
				gchar* _tmp8_;
				gchar* _tmp9_;
				gboolean _tmp10_ = FALSE;
				gchar* _tmp11_;
				gchar _tmp12_;
				_tmp8_ = _vala_token_begin.pos;
				_vala_token_begin.pos = _tmp8_ + 1;
				_tmp9_ = self->priv->current;
				self->priv->current = _tmp9_ + 1;
				_tmp11_ = self->priv->current;
				_tmp12_ = _tmp11_[0];
				if (g_ascii_isalpha (_tmp12_)) {
					_tmp10_ = TRUE;
				} else {
					gchar* _tmp13_;
					gchar _tmp14_;
					_tmp13_ = self->priv->current;
					_tmp14_ = _tmp13_[0];
					_tmp10_ = _tmp14_ == '_';
				}
				if (_tmp10_) {
					gint len = 0;
					len = 0;
					while (TRUE) {
						gboolean _tmp15_ = FALSE;
						gchar* _tmp16_;
						gchar* _tmp17_;
						gchar* _tmp20_;
						gint _tmp21_;
						_tmp16_ = self->priv->current;
						_tmp17_ = self->priv->end;
						if (_tmp16_ < _tmp17_) {
							gchar* _tmp18_;
							gchar _tmp19_;
							_tmp18_ = self->priv->current;
							_tmp19_ = _tmp18_[0];
							_tmp15_ = vala_genie_scanner_is_ident_char (self, _tmp19_);
						} else {
							_tmp15_ = FALSE;
						}
						if (!_tmp15_) {
							break;
						}
						_tmp20_ = self->priv->current;
						self->priv->current = _tmp20_ + 1;
						_tmp21_ = len;
						len = _tmp21_ + 1;
					}
					type = VALA_GENIE_TOKEN_TYPE_IDENTIFIER;
					_vala_array_add3 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_TEMPLATE_PART);
				} else {
					gchar* _tmp22_;
					gchar _tmp23_;
					_tmp22_ = self->priv->current;
					_tmp23_ = _tmp22_[0];
					if (_tmp23_ == '(') {
						gchar* _tmp24_;
						ValaSourceLocation _tmp25_ = {0};
						ValaSourceLocation _tmp26_ = {0};
						ValaGenieTokenType _tmp27_;
						_tmp24_ = self->priv->current;
						self->priv->current = _tmp24_ + 1;
						self->priv->column = self->priv->column + 2;
						_vala_array_add4 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_PARENS);
						_tmp27_ = vala_genie_scanner_read_token (self, &_tmp25_, &_tmp26_);
						_vala_token_begin = _tmp25_;
						_vala_token_end = _tmp26_;
						result = _tmp27_;
						if (token_begin) {
							*token_begin = _vala_token_begin;
						}
						if (token_end) {
							*token_end = _vala_token_end;
						}
						return result;
					} else {
						gchar* _tmp28_;
						gchar _tmp29_;
						_tmp28_ = self->priv->current;
						_tmp29_ = _tmp28_[0];
						if (_tmp29_ == '$') {
							gchar* _tmp30_;
							type = VALA_GENIE_TOKEN_TYPE_TEMPLATE_STRING_LITERAL;
							_tmp30_ = self->priv->current;
							self->priv->current = _tmp30_ + 1;
							_vala_array_add5 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_TEMPLATE_PART);
						} else {
							ValaSourceReference* _tmp31_;
							ValaSourceReference* _tmp32_;
							ValaSourceLocation _tmp33_ = {0};
							ValaSourceLocation _tmp34_ = {0};
							ValaGenieTokenType _tmp35_;
							_tmp31_ = vala_genie_scanner_get_source_reference (self, 1, 0);
							_tmp32_ = _tmp31_;
							vala_report_error (_tmp32_, "unexpected character");
							_vala_source_reference_unref0 (_tmp32_);
							_tmp35_ = vala_genie_scanner_read_template_token (self, &_tmp33_, &_tmp34_);
							_vala_token_begin = _tmp33_;
							_vala_token_end = _tmp34_;
							result = _tmp35_;
							if (token_begin) {
								*token_begin = _vala_token_begin;
							}
							if (token_end) {
								*token_end = _vala_token_end;
							}
							return result;
						}
					}
				}
				break;
			}
			default:
			{
				gchar* _tmp100_;
				gchar* _tmp101_;
				type = VALA_GENIE_TOKEN_TYPE_TEMPLATE_STRING_LITERAL;
				token_length_in_chars = 0;
				while (TRUE) {
					gboolean _tmp36_ = FALSE;
					gboolean _tmp37_ = FALSE;
					gchar* _tmp38_;
					gchar* _tmp39_;
					gchar* _tmp44_;
					gchar _tmp45_;
					_tmp38_ = self->priv->current;
					_tmp39_ = self->priv->end;
					if (_tmp38_ < _tmp39_) {
						gchar* _tmp40_;
						gchar _tmp41_;
						_tmp40_ = self->priv->current;
						_tmp41_ = _tmp40_[0];
						_tmp37_ = _tmp41_ != '"';
					} else {
						_tmp37_ = FALSE;
					}
					if (_tmp37_) {
						gchar* _tmp42_;
						gchar _tmp43_;
						_tmp42_ = self->priv->current;
						_tmp43_ = _tmp42_[0];
						_tmp36_ = _tmp43_ != '$';
					} else {
						_tmp36_ = FALSE;
					}
					if (!_tmp36_) {
						break;
					}
					_tmp44_ = self->priv->current;
					_tmp45_ = _tmp44_[0];
					if (_tmp45_ == '\\') {
						gchar* _tmp46_;
						gint _tmp47_;
						gchar* _tmp48_;
						gchar* _tmp49_;
						gchar* _tmp50_;
						gchar _tmp51_;
						_tmp46_ = self->priv->current;
						self->priv->current = _tmp46_ + 1;
						_tmp47_ = token_length_in_chars;
						token_length_in_chars = _tmp47_ + 1;
						_tmp48_ = self->priv->current;
						_tmp49_ = self->priv->end;
						if (_tmp48_ >= _tmp49_) {
							break;
						}
						_tmp50_ = self->priv->current;
						_tmp51_ = _tmp50_[0];
						switch (_tmp51_) {
							case '\'':
							case '"':
							case '\\':
							case '0':
							case 'b':
							case 'f':
							case 'n':
							case 'r':
							case 't':
							case 'v':
							{
								gchar* _tmp52_;
								gint _tmp53_;
								_tmp52_ = self->priv->current;
								self->priv->current = _tmp52_ + 1;
								_tmp53_ = token_length_in_chars;
								token_length_in_chars = _tmp53_ + 1;
								break;
							}
							case 'u':
							{
								gchar* _tmp54_;
								gint _tmp55_;
								gint digit_length = 0;
								_tmp54_ = self->priv->current;
								self->priv->current = _tmp54_ + 1;
								_tmp55_ = token_length_in_chars;
								token_length_in_chars = _tmp55_ + 1;
								{
									gboolean _tmp56_ = FALSE;
									digit_length = 0;
									_tmp56_ = TRUE;
									while (TRUE) {
										gboolean _tmp58_ = FALSE;
										gchar* _tmp59_;
										gchar* _tmp60_;
										gchar* _tmp63_;
										gint _tmp64_;
										if (!_tmp56_) {
											gint _tmp57_;
											_tmp57_ = digit_length;
											digit_length = _tmp57_ + 1;
										}
										_tmp56_ = FALSE;
										_tmp59_ = self->priv->current;
										_tmp60_ = self->priv->end;
										if (_tmp59_ < _tmp60_) {
											gchar* _tmp61_;
											gchar _tmp62_;
											_tmp61_ = self->priv->current;
											_tmp62_ = _tmp61_[0];
											_tmp58_ = g_ascii_isxdigit (_tmp62_);
										} else {
											_tmp58_ = FALSE;
										}
										if (!_tmp58_) {
											break;
										}
										_tmp63_ = self->priv->current;
										self->priv->current = _tmp63_ + 1;
										_tmp64_ = token_length_in_chars;
										token_length_in_chars = _tmp64_ + 1;
									}
								}
								if (digit_length < 1) {
									ValaSourceReference* _tmp65_;
									ValaSourceReference* _tmp66_;
									_tmp65_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
									_tmp66_ = _tmp65_;
									vala_report_error (_tmp66_, "\\u used with no following hex digits");
									_vala_source_reference_unref0 (_tmp66_);
								} else {
									if (digit_length < 4) {
										ValaSourceReference* _tmp67_;
										ValaSourceReference* _tmp68_;
										_tmp67_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
										_tmp68_ = _tmp67_;
										vala_report_error (_tmp68_, "incomplete universal character name");
										_vala_source_reference_unref0 (_tmp68_);
									}
								}
								break;
							}
							case 'x':
							{
								gchar* _tmp69_;
								gint _tmp70_;
								gint digit_length = 0;
								_tmp69_ = self->priv->current;
								self->priv->current = _tmp69_ + 1;
								_tmp70_ = token_length_in_chars;
								token_length_in_chars = _tmp70_ + 1;
								{
									gboolean _tmp71_ = FALSE;
									digit_length = 0;
									_tmp71_ = TRUE;
									while (TRUE) {
										gboolean _tmp72_ = FALSE;
										gchar* _tmp73_;
										gchar* _tmp74_;
										gchar* _tmp77_;
										gchar _tmp78_;
										gchar* _tmp80_;
										gint _tmp81_;
										if (!_tmp71_) {
										}
										_tmp71_ = FALSE;
										_tmp73_ = self->priv->current;
										_tmp74_ = self->priv->end;
										if (_tmp73_ < _tmp74_) {
											gchar* _tmp75_;
											gchar _tmp76_;
											_tmp75_ = self->priv->current;
											_tmp76_ = _tmp75_[0];
											_tmp72_ = g_ascii_isxdigit (_tmp76_);
										} else {
											_tmp72_ = FALSE;
										}
										if (!_tmp72_) {
											break;
										}
										_tmp77_ = self->priv->current;
										_tmp78_ = _tmp77_[0];
										if (_tmp78_ != '0') {
											gint _tmp79_;
											_tmp79_ = digit_length;
											digit_length = _tmp79_ + 1;
										}
										_tmp80_ = self->priv->current;
										self->priv->current = _tmp80_ + 1;
										_tmp81_ = token_length_in_chars;
										token_length_in_chars = _tmp81_ + 1;
									}
								}
								if (digit_length < 1) {
									ValaSourceReference* _tmp82_;
									ValaSourceReference* _tmp83_;
									_tmp82_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
									_tmp83_ = _tmp82_;
									vala_report_error (_tmp83_, "\\x used with no following hex digits");
									_vala_source_reference_unref0 (_tmp83_);
								} else {
									if (digit_length > 2) {
										ValaSourceReference* _tmp84_;
										ValaSourceReference* _tmp85_;
										_tmp84_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
										_tmp85_ = _tmp84_;
										vala_report_error (_tmp85_, "hex escape sequence out of range");
										_vala_source_reference_unref0 (_tmp85_);
									}
								}
								break;
							}
							default:
							{
								ValaSourceReference* _tmp86_;
								ValaSourceReference* _tmp87_;
								_tmp86_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
								_tmp87_ = _tmp86_;
								vala_report_error (_tmp87_, "invalid escape sequence");
								_vala_source_reference_unref0 (_tmp87_);
								break;
							}
						}
					} else {
						gchar* _tmp88_;
						gchar _tmp89_;
						_tmp88_ = self->priv->current;
						_tmp89_ = _tmp88_[0];
						if (_tmp89_ == '\n') {
							gchar* _tmp90_;
							gint _tmp91_;
							_tmp90_ = self->priv->current;
							self->priv->current = _tmp90_ + 1;
							_tmp91_ = self->priv->line;
							self->priv->line = _tmp91_ + 1;
							self->priv->column = 1;
							token_length_in_chars = 1;
						} else {
							gunichar u = 0U;
							gchar* _tmp92_;
							gchar* _tmp93_;
							gchar* _tmp94_;
							_tmp92_ = self->priv->current;
							_tmp93_ = self->priv->end;
							_tmp94_ = self->priv->current;
							u = g_utf8_get_char_validated ((const gchar*) _tmp92_, (gssize) ((glong) (_tmp93_ - _tmp94_)));
							if (u != ((gunichar) -1)) {
								gchar* _tmp95_;
								gint _tmp96_;
								_tmp95_ = self->priv->current;
								self->priv->current = _tmp95_ + g_unichar_to_utf8 (u, NULL);
								_tmp96_ = token_length_in_chars;
								token_length_in_chars = _tmp96_ + 1;
							} else {
								gchar* _tmp97_;
								ValaSourceReference* _tmp98_;
								ValaSourceReference* _tmp99_;
								_tmp97_ = self->priv->current;
								self->priv->current = _tmp97_ + 1;
								_tmp98_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
								_tmp99_ = _tmp98_;
								vala_report_error (_tmp99_, "invalid UTF-8 character");
								_vala_source_reference_unref0 (_tmp99_);
							}
						}
					}
				}
				_tmp100_ = self->priv->current;
				_tmp101_ = self->priv->end;
				if (_tmp100_ >= _tmp101_) {
					ValaSourceReference* _tmp102_;
					ValaSourceReference* _tmp103_;
					gint _tmp104_;
					ValaSourceLocation _tmp105_ = {0};
					ValaSourceLocation _tmp106_ = {0};
					ValaGenieTokenType _tmp107_;
					_tmp102_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
					_tmp103_ = _tmp102_;
					vala_report_error (_tmp103_, "syntax error, expected \"");
					_vala_source_reference_unref0 (_tmp103_);
					_tmp104_ = self->priv->state_stack_length1;
					self->priv->state_stack_length1 = _tmp104_ - 1;
					_tmp107_ = vala_genie_scanner_read_token (self, &_tmp105_, &_tmp106_);
					_vala_token_begin = _tmp105_;
					_vala_token_end = _tmp106_;
					result = _tmp107_;
					if (token_begin) {
						*token_begin = _vala_token_begin;
					}
					if (token_end) {
						*token_end = _vala_token_end;
					}
					return result;
				}
				_vala_array_add6 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_TEMPLATE_PART);
				break;
			}
		}
	}
	if (token_length_in_chars < 0) {
		gchar* _tmp108_;
		gchar* _tmp109_;
		_tmp108_ = self->priv->current;
		_tmp109_ = begin;
		self->priv->column = self->priv->column + ((gint) (_tmp108_ - _tmp109_));
	} else {
		self->priv->column = self->priv->column + token_length_in_chars;
	}
	_tmp110_ = self->priv->current;
	vala_source_location_init (&_vala_token_end, _tmp110_, self->priv->line, self->priv->column - 1);
	result = type;
	if (token_begin) {
		*token_begin = _vala_token_begin;
	}
	if (token_end) {
		*token_end = _vala_token_end;
	}
	return result;
}

static void
_vala_array_add7 (ValaGenieScannerState* * array,
                  gint* length,
                  gint* size,
                  ValaGenieScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add8 (ValaGenieScannerState* * array,
                  gint* length,
                  gint* size,
                  ValaGenieScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add9 (ValaGenieScannerState* * array,
                  gint* length,
                  gint* size,
                  ValaGenieScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add10 (ValaGenieScannerState* * array,
                   gint* length,
                   gint* size,
                   ValaGenieScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add11 (ValaGenieScannerState* * array,
                   gint* length,
                   gint* size,
                   ValaGenieScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}

ValaGenieTokenType
vala_genie_scanner_read_token (ValaGenieScanner* self,
                               ValaSourceLocation* token_begin,
                               ValaSourceLocation* token_end)
{
	ValaSourceLocation _vala_token_begin = {0};
	ValaSourceLocation _vala_token_end = {0};
	gchar* _tmp0_;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp37_ = FALSE;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
	ValaGenieTokenType type = 0;
	gchar* begin = NULL;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gint token_length_in_chars = 0;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp465_;
	ValaGenieTokenType _tmp466_;
	ValaGenieTokenType result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->current;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->current;
		vala_source_location_init (&_vala_token_begin, _tmp1_, self->priv->line, self->priv->column);
		_tmp2_ = self->priv->current;
		vala_source_location_init (&_vala_token_end, _tmp2_, self->priv->line, self->priv->column);
		result = VALA_GENIE_TOKEN_TYPE_EOF;
		if (token_begin) {
			*token_begin = _vala_token_begin;
		}
		if (token_end) {
			*token_end = _vala_token_end;
		}
		return result;
	}
	if (vala_genie_scanner_in_template (self)) {
		ValaSourceLocation _tmp3_ = {0};
		ValaSourceLocation _tmp4_ = {0};
		ValaGenieTokenType _tmp5_;
		_tmp5_ = vala_genie_scanner_read_template_token (self, &_tmp3_, &_tmp4_);
		_vala_token_begin = _tmp3_;
		_vala_token_end = _tmp4_;
		result = _tmp5_;
		if (token_begin) {
			*token_begin = _vala_token_begin;
		}
		if (token_end) {
			*token_end = _vala_token_end;
		}
		return result;
	} else {
		if (vala_genie_scanner_in_template_part (self)) {
			gint _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp6_ = self->priv->state_stack_length1;
			self->priv->state_stack_length1 = _tmp6_ - 1;
			_tmp7_ = self->priv->current;
			vala_source_location_init (&_vala_token_begin, _tmp7_, self->priv->line, self->priv->column);
			_tmp8_ = self->priv->current;
			vala_source_location_init (&_vala_token_end, _tmp8_, self->priv->line, self->priv->column - 1);
			result = VALA_GENIE_TOKEN_TYPE_COMMA;
			if (token_begin) {
				*token_begin = _vala_token_begin;
			}
			if (token_end) {
				*token_end = _vala_token_end;
			}
			return result;
		} else {
			if (vala_genie_scanner_in_regex_literal (self)) {
				ValaSourceLocation _tmp9_ = {0};
				ValaSourceLocation _tmp10_ = {0};
				ValaGenieTokenType _tmp11_;
				_tmp11_ = vala_genie_scanner_read_regex_token (self, &_tmp9_, &_tmp10_);
				_vala_token_begin = _tmp9_;
				_vala_token_end = _tmp10_;
				result = _tmp11_;
				if (token_begin) {
					*token_begin = _vala_token_begin;
				}
				if (token_end) {
					*token_end = _vala_token_end;
				}
				return result;
			}
		}
	}
	if (self->priv->pending_dedents > 0) {
		gint _tmp12_;
		gint _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp12_ = self->priv->pending_dedents;
		self->priv->pending_dedents = _tmp12_ - 1;
		_tmp13_ = self->priv->indent_level;
		self->priv->indent_level = _tmp13_ - 1;
		_tmp14_ = self->priv->current;
		vala_source_location_init (&_vala_token_begin, _tmp14_, self->priv->line, self->priv->column);
		_tmp15_ = self->priv->current;
		vala_source_location_init (&_vala_token_end, _tmp15_, self->priv->line, self->priv->column);
		self->priv->last_token = VALA_GENIE_TOKEN_TYPE_DEDENT;
		result = VALA_GENIE_TOKEN_TYPE_DEDENT;
		if (token_begin) {
			*token_begin = _vala_token_begin;
		}
		if (token_end) {
			*token_end = _vala_token_end;
		}
		return result;
	}
	if (self->priv->_indent_spaces == 0) {
		_tmp16_ = TRUE;
	} else {
		ValaGenieTokenType _tmp17_;
		_tmp17_ = self->priv->last_token;
		_tmp16_ = _tmp17_ != VALA_GENIE_TOKEN_TYPE_EOL;
	}
	if (_tmp16_) {
		vala_genie_scanner_space (self);
	}
	while (TRUE) {
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp26_;
		gint _tmp27_;
		_tmp20_ = self->priv->current;
		_tmp21_ = self->priv->end;
		if (_tmp20_ < _tmp21_) {
			gchar* _tmp22_;
			gchar _tmp23_;
			_tmp22_ = self->priv->current;
			_tmp23_ = _tmp22_[0];
			_tmp19_ = _tmp23_ == '\\';
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			gchar* _tmp24_;
			gchar _tmp25_;
			_tmp24_ = self->priv->current;
			_tmp25_ = _tmp24_[1];
			_tmp18_ = _tmp25_ == '\n';
		} else {
			_tmp18_ = FALSE;
		}
		if (!_tmp18_) {
			break;
		}
		_tmp26_ = self->priv->current;
		self->priv->current = _tmp26_ + 2;
		_tmp27_ = self->priv->line;
		self->priv->line = _tmp27_ + 1;
		vala_genie_scanner_skip_space_tabs (self);
	}
	while (TRUE) {
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_ = FALSE;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp35_;
		gint _tmp36_;
		_tmp30_ = self->priv->current;
		_tmp31_ = self->priv->end;
		if (_tmp30_ < _tmp31_) {
			gchar* _tmp32_;
			gchar _tmp33_;
			_tmp32_ = self->priv->current;
			_tmp33_ = _tmp32_[0];
			_tmp29_ = _tmp33_ == '\n';
		} else {
			_tmp29_ = FALSE;
		}
		if (_tmp29_) {
			gboolean _tmp34_ = FALSE;
			if (self->priv->open_parens_count > 0) {
				_tmp34_ = TRUE;
			} else {
				_tmp34_ = self->priv->open_brace_count > 0;
			}
			_tmp28_ = _tmp34_;
		} else {
			_tmp28_ = FALSE;
		}
		if (!_tmp28_) {
			break;
		}
		_tmp35_ = self->priv->current;
		self->priv->current = _tmp35_ + 1;
		_tmp36_ = self->priv->line;
		self->priv->line = _tmp36_ + 1;
		vala_genie_scanner_skip_space_tabs (self);
	}
	if (vala_genie_scanner_newline (self)) {
		_tmp39_ = self->priv->parse_started;
	} else {
		_tmp39_ = FALSE;
	}
	if (_tmp39_) {
		ValaGenieTokenType _tmp40_;
		_tmp40_ = self->priv->last_token;
		_tmp38_ = _tmp40_ != VALA_GENIE_TOKEN_TYPE_EOL;
	} else {
		_tmp38_ = FALSE;
	}
	if (_tmp38_) {
		ValaGenieTokenType _tmp41_;
		_tmp41_ = self->priv->last_token;
		_tmp37_ = _tmp41_ != VALA_GENIE_TOKEN_TYPE_SEMICOLON;
	} else {
		_tmp37_ = FALSE;
	}
	if (_tmp37_) {
		gchar* _tmp42_;
		gchar* _tmp43_;
		_tmp42_ = self->priv->current;
		vala_source_location_init (&_vala_token_begin, _tmp42_, self->priv->line, self->priv->column);
		_tmp43_ = self->priv->current;
		vala_source_location_init (&_vala_token_end, _tmp43_, self->priv->line, self->priv->column);
		self->priv->last_token = VALA_GENIE_TOKEN_TYPE_EOL;
		result = VALA_GENIE_TOKEN_TYPE_EOL;
		if (token_begin) {
			*token_begin = _vala_token_begin;
		}
		if (token_end) {
			*token_end = _vala_token_end;
		}
		return result;
	}
	while (TRUE) {
		gchar* _tmp44_;
		if (!vala_genie_scanner_skip_newlines (self)) {
			break;
		}
		_tmp44_ = self->priv->current;
		vala_source_location_init (&_vala_token_begin, _tmp44_, self->priv->line, self->priv->column);
		self->priv->current_indent_level = vala_genie_scanner_count_tabs (self);
		if (self->priv->current_indent_level == -1) {
			continue;
		}
		if (self->priv->current_indent_level > self->priv->indent_level) {
			gchar* _tmp45_;
			self->priv->indent_level = self->priv->current_indent_level;
			_tmp45_ = self->priv->current;
			vala_source_location_init (&_vala_token_end, _tmp45_, self->priv->line, self->priv->column);
			self->priv->last_token = VALA_GENIE_TOKEN_TYPE_INDENT;
			result = VALA_GENIE_TOKEN_TYPE_INDENT;
			if (token_begin) {
				*token_begin = _vala_token_begin;
			}
			if (token_end) {
				*token_end = _vala_token_end;
			}
			return result;
		} else {
			if (self->priv->current_indent_level < self->priv->indent_level) {
				gint _tmp46_;
				gchar* _tmp47_;
				_tmp46_ = self->priv->indent_level;
				self->priv->indent_level = _tmp46_ - 1;
				self->priv->pending_dedents = self->priv->indent_level - self->priv->current_indent_level;
				_tmp47_ = self->priv->current;
				vala_source_location_init (&_vala_token_end, _tmp47_, self->priv->line, self->priv->column);
				self->priv->last_token = VALA_GENIE_TOKEN_TYPE_DEDENT;
				result = VALA_GENIE_TOKEN_TYPE_DEDENT;
				if (token_begin) {
					*token_begin = _vala_token_begin;
				}
				if (token_end) {
					*token_end = _vala_token_end;
				}
				return result;
			}
		}
	}
	_tmp48_ = self->priv->current;
	begin = _tmp48_;
	_tmp49_ = begin;
	vala_source_location_init (&_vala_token_begin, _tmp49_, self->priv->line, self->priv->column);
	token_length_in_chars = -1;
	self->priv->parse_started = TRUE;
	_tmp50_ = self->priv->current;
	_tmp51_ = self->priv->end;
	if (_tmp50_ >= _tmp51_) {
		if (self->priv->indent_level > 0) {
			gint _tmp52_;
			_tmp52_ = self->priv->indent_level;
			self->priv->indent_level = _tmp52_ - 1;
			self->priv->pending_dedents = self->priv->indent_level;
			type = VALA_GENIE_TOKEN_TYPE_DEDENT;
		} else {
			type = VALA_GENIE_TOKEN_TYPE_EOF;
		}
	} else {
		gboolean _tmp53_ = FALSE;
		gchar* _tmp54_;
		gchar _tmp55_;
		_tmp54_ = self->priv->current;
		_tmp55_ = _tmp54_[0];
		if (g_ascii_isalpha (_tmp55_)) {
			_tmp53_ = TRUE;
		} else {
			gchar* _tmp56_;
			gchar _tmp57_;
			_tmp56_ = self->priv->current;
			_tmp57_ = _tmp56_[0];
			_tmp53_ = _tmp57_ == '_';
		}
		if (_tmp53_) {
			gint len = 0;
			gchar* _tmp65_;
			len = 0;
			while (TRUE) {
				gboolean _tmp58_ = FALSE;
				gchar* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp63_;
				gint _tmp64_;
				_tmp59_ = self->priv->current;
				_tmp60_ = self->priv->end;
				if (_tmp59_ < _tmp60_) {
					gchar* _tmp61_;
					gchar _tmp62_;
					_tmp61_ = self->priv->current;
					_tmp62_ = _tmp61_[0];
					_tmp58_ = vala_genie_scanner_is_ident_char (self, _tmp62_);
				} else {
					_tmp58_ = FALSE;
				}
				if (!_tmp58_) {
					break;
				}
				_tmp63_ = self->priv->current;
				self->priv->current = _tmp63_ + 1;
				_tmp64_ = len;
				len = _tmp64_ + 1;
			}
			_tmp65_ = begin;
			type = vala_genie_scanner_get_identifier_or_keyword (_tmp65_, len);
		} else {
			gchar* _tmp66_;
			gchar _tmp67_;
			_tmp66_ = self->priv->current;
			_tmp67_ = _tmp66_[0];
			if (_tmp67_ == '@') {
				gboolean _tmp68_ = FALSE;
				gchar* _tmp69_;
				gchar* _tmp70_;
				_tmp69_ = self->priv->current;
				_tmp70_ = self->priv->end;
				if (_tmp69_ < (_tmp70_ - 1)) {
					gchar* _tmp71_;
					gchar _tmp72_;
					_tmp71_ = self->priv->current;
					_tmp72_ = _tmp71_[1];
					_tmp68_ = _tmp72_ == '"';
				} else {
					_tmp68_ = FALSE;
				}
				if (_tmp68_) {
					gchar* _tmp73_;
					type = VALA_GENIE_TOKEN_TYPE_OPEN_TEMPLATE;
					_tmp73_ = self->priv->current;
					self->priv->current = _tmp73_ + 2;
					_vala_array_add7 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_TEMPLATE);
				} else {
					gchar* _tmp74_;
					gchar* _tmp75_;
					gint len = 0;
					_tmp74_ = _vala_token_begin.pos;
					_vala_token_begin.pos = _tmp74_ + 1;
					_tmp75_ = self->priv->current;
					self->priv->current = _tmp75_ + 1;
					len = 0;
					while (TRUE) {
						gboolean _tmp76_ = FALSE;
						gchar* _tmp77_;
						gchar* _tmp78_;
						gchar* _tmp81_;
						gint _tmp82_;
						_tmp77_ = self->priv->current;
						_tmp78_ = self->priv->end;
						if (_tmp77_ < _tmp78_) {
							gchar* _tmp79_;
							gchar _tmp80_;
							_tmp79_ = self->priv->current;
							_tmp80_ = _tmp79_[0];
							_tmp76_ = vala_genie_scanner_is_ident_char (self, _tmp80_);
						} else {
							_tmp76_ = FALSE;
						}
						if (!_tmp76_) {
							break;
						}
						_tmp81_ = self->priv->current;
						self->priv->current = _tmp81_ + 1;
						_tmp82_ = len;
						len = _tmp82_ + 1;
					}
					type = VALA_GENIE_TOKEN_TYPE_IDENTIFIER;
				}
			} else {
				gchar* _tmp83_;
				gchar _tmp84_;
				_tmp83_ = self->priv->current;
				_tmp84_ = _tmp83_[0];
				if (g_ascii_isdigit (_tmp84_)) {
					gboolean _tmp91_ = FALSE;
					gchar* _tmp92_;
					gchar* _tmp93_;
					while (TRUE) {
						gboolean _tmp85_ = FALSE;
						gchar* _tmp86_;
						gchar* _tmp87_;
						gchar* _tmp90_;
						_tmp86_ = self->priv->current;
						_tmp87_ = self->priv->end;
						if (_tmp86_ < _tmp87_) {
							gchar* _tmp88_;
							gchar _tmp89_;
							_tmp88_ = self->priv->current;
							_tmp89_ = _tmp88_[0];
							_tmp85_ = g_ascii_isdigit (_tmp89_);
						} else {
							_tmp85_ = FALSE;
						}
						if (!_tmp85_) {
							break;
						}
						_tmp90_ = self->priv->current;
						self->priv->current = _tmp90_ + 1;
					}
					type = VALA_GENIE_TOKEN_TYPE_INTEGER_LITERAL;
					_tmp92_ = self->priv->current;
					_tmp93_ = self->priv->end;
					if (_tmp92_ < _tmp93_) {
						gchar* _tmp94_;
						gchar _tmp95_;
						_tmp94_ = self->priv->current;
						_tmp95_ = _tmp94_[0];
						_tmp91_ = g_ascii_tolower (_tmp95_) == 'l';
					} else {
						_tmp91_ = FALSE;
					}
					if (_tmp91_) {
						gchar* _tmp96_;
						gboolean _tmp97_ = FALSE;
						gchar* _tmp98_;
						gchar* _tmp99_;
						_tmp96_ = self->priv->current;
						self->priv->current = _tmp96_ + 1;
						_tmp98_ = self->priv->current;
						_tmp99_ = self->priv->end;
						if (_tmp98_ < _tmp99_) {
							gchar* _tmp100_;
							gchar _tmp101_;
							_tmp100_ = self->priv->current;
							_tmp101_ = _tmp100_[0];
							_tmp97_ = g_ascii_tolower (_tmp101_) == 'l';
						} else {
							_tmp97_ = FALSE;
						}
						if (_tmp97_) {
							gchar* _tmp102_;
							_tmp102_ = self->priv->current;
							self->priv->current = _tmp102_ + 1;
						}
					} else {
						gboolean _tmp103_ = FALSE;
						gchar* _tmp104_;
						gchar* _tmp105_;
						_tmp104_ = self->priv->current;
						_tmp105_ = self->priv->end;
						if (_tmp104_ < _tmp105_) {
							gchar* _tmp106_;
							gchar _tmp107_;
							_tmp106_ = self->priv->current;
							_tmp107_ = _tmp106_[0];
							_tmp103_ = g_ascii_tolower (_tmp107_) == 'u';
						} else {
							_tmp103_ = FALSE;
						}
						if (_tmp103_) {
							gchar* _tmp108_;
							gboolean _tmp109_ = FALSE;
							gchar* _tmp110_;
							gchar* _tmp111_;
							_tmp108_ = self->priv->current;
							self->priv->current = _tmp108_ + 1;
							_tmp110_ = self->priv->current;
							_tmp111_ = self->priv->end;
							if (_tmp110_ < _tmp111_) {
								gchar* _tmp112_;
								gchar _tmp113_;
								_tmp112_ = self->priv->current;
								_tmp113_ = _tmp112_[0];
								_tmp109_ = g_ascii_tolower (_tmp113_) == 'l';
							} else {
								_tmp109_ = FALSE;
							}
							if (_tmp109_) {
								gchar* _tmp114_;
								gboolean _tmp115_ = FALSE;
								gchar* _tmp116_;
								gchar* _tmp117_;
								_tmp114_ = self->priv->current;
								self->priv->current = _tmp114_ + 1;
								_tmp116_ = self->priv->current;
								_tmp117_ = self->priv->end;
								if (_tmp116_ < _tmp117_) {
									gchar* _tmp118_;
									gchar _tmp119_;
									_tmp118_ = self->priv->current;
									_tmp119_ = _tmp118_[0];
									_tmp115_ = g_ascii_tolower (_tmp119_) == 'l';
								} else {
									_tmp115_ = FALSE;
								}
								if (_tmp115_) {
									gchar* _tmp120_;
									_tmp120_ = self->priv->current;
									self->priv->current = _tmp120_ + 1;
								}
							}
						} else {
							gboolean _tmp121_ = FALSE;
							gboolean _tmp122_ = FALSE;
							gchar* _tmp123_;
							gchar* _tmp124_;
							_tmp123_ = self->priv->current;
							_tmp124_ = self->priv->end;
							if (_tmp123_ < (_tmp124_ - 1)) {
								gchar* _tmp125_;
								gchar _tmp126_;
								_tmp125_ = self->priv->current;
								_tmp126_ = _tmp125_[0];
								_tmp122_ = _tmp126_ == '.';
							} else {
								_tmp122_ = FALSE;
							}
							if (_tmp122_) {
								gchar* _tmp127_;
								gchar _tmp128_;
								_tmp127_ = self->priv->current;
								_tmp128_ = _tmp127_[1];
								_tmp121_ = g_ascii_isdigit (_tmp128_);
							} else {
								_tmp121_ = FALSE;
							}
							if (_tmp121_) {
								gchar* _tmp129_;
								gboolean _tmp136_ = FALSE;
								gchar* _tmp137_;
								gchar* _tmp138_;
								gboolean _tmp157_ = FALSE;
								gchar* _tmp158_;
								gchar* _tmp159_;
								_tmp129_ = self->priv->current;
								self->priv->current = _tmp129_ + 1;
								while (TRUE) {
									gboolean _tmp130_ = FALSE;
									gchar* _tmp131_;
									gchar* _tmp132_;
									gchar* _tmp135_;
									_tmp131_ = self->priv->current;
									_tmp132_ = self->priv->end;
									if (_tmp131_ < _tmp132_) {
										gchar* _tmp133_;
										gchar _tmp134_;
										_tmp133_ = self->priv->current;
										_tmp134_ = _tmp133_[0];
										_tmp130_ = g_ascii_isdigit (_tmp134_);
									} else {
										_tmp130_ = FALSE;
									}
									if (!_tmp130_) {
										break;
									}
									_tmp135_ = self->priv->current;
									self->priv->current = _tmp135_ + 1;
								}
								_tmp137_ = self->priv->current;
								_tmp138_ = self->priv->end;
								if (_tmp137_ < _tmp138_) {
									gchar* _tmp139_;
									gchar _tmp140_;
									_tmp139_ = self->priv->current;
									_tmp140_ = _tmp139_[0];
									_tmp136_ = g_ascii_tolower (_tmp140_) == 'e';
								} else {
									_tmp136_ = FALSE;
								}
								if (_tmp136_) {
									gchar* _tmp141_;
									gboolean _tmp142_ = FALSE;
									gchar* _tmp143_;
									gchar* _tmp144_;
									_tmp141_ = self->priv->current;
									self->priv->current = _tmp141_ + 1;
									_tmp143_ = self->priv->current;
									_tmp144_ = self->priv->end;
									if (_tmp143_ < _tmp144_) {
										gboolean _tmp145_ = FALSE;
										gchar* _tmp146_;
										gchar _tmp147_;
										_tmp146_ = self->priv->current;
										_tmp147_ = _tmp146_[0];
										if (_tmp147_ == '+') {
											_tmp145_ = TRUE;
										} else {
											gchar* _tmp148_;
											gchar _tmp149_;
											_tmp148_ = self->priv->current;
											_tmp149_ = _tmp148_[0];
											_tmp145_ = _tmp149_ == '-';
										}
										_tmp142_ = _tmp145_;
									} else {
										_tmp142_ = FALSE;
									}
									if (_tmp142_) {
										gchar* _tmp150_;
										_tmp150_ = self->priv->current;
										self->priv->current = _tmp150_ + 1;
									}
									while (TRUE) {
										gboolean _tmp151_ = FALSE;
										gchar* _tmp152_;
										gchar* _tmp153_;
										gchar* _tmp156_;
										_tmp152_ = self->priv->current;
										_tmp153_ = self->priv->end;
										if (_tmp152_ < _tmp153_) {
											gchar* _tmp154_;
											gchar _tmp155_;
											_tmp154_ = self->priv->current;
											_tmp155_ = _tmp154_[0];
											_tmp151_ = g_ascii_isdigit (_tmp155_);
										} else {
											_tmp151_ = FALSE;
										}
										if (!_tmp151_) {
											break;
										}
										_tmp156_ = self->priv->current;
										self->priv->current = _tmp156_ + 1;
									}
								}
								_tmp158_ = self->priv->current;
								_tmp159_ = self->priv->end;
								if (_tmp158_ < _tmp159_) {
									gchar* _tmp160_;
									gchar _tmp161_;
									_tmp160_ = self->priv->current;
									_tmp161_ = _tmp160_[0];
									_tmp157_ = g_ascii_tolower (_tmp161_) == 'f';
								} else {
									_tmp157_ = FALSE;
								}
								if (_tmp157_) {
									gchar* _tmp162_;
									_tmp162_ = self->priv->current;
									self->priv->current = _tmp162_ + 1;
								}
								type = VALA_GENIE_TOKEN_TYPE_REAL_LITERAL;
							} else {
								gboolean _tmp163_ = FALSE;
								gboolean _tmp164_ = FALSE;
								gboolean _tmp165_ = FALSE;
								gboolean _tmp166_ = FALSE;
								gchar* _tmp167_;
								gchar* _tmp168_;
								_tmp167_ = self->priv->current;
								_tmp168_ = self->priv->end;
								if (_tmp167_ < _tmp168_) {
									gchar* _tmp169_;
									gchar* _tmp170_;
									_tmp169_ = self->priv->current;
									_tmp170_ = begin;
									_tmp166_ = _tmp169_ == (_tmp170_ + 1);
								} else {
									_tmp166_ = FALSE;
								}
								if (_tmp166_) {
									gchar* _tmp171_;
									gchar _tmp172_;
									_tmp171_ = begin;
									_tmp172_ = _tmp171_[0];
									_tmp165_ = _tmp172_ == '0';
								} else {
									_tmp165_ = FALSE;
								}
								if (_tmp165_) {
									gchar* _tmp173_;
									gchar _tmp174_;
									_tmp173_ = begin;
									_tmp174_ = _tmp173_[1];
									_tmp164_ = _tmp174_ == 'x';
								} else {
									_tmp164_ = FALSE;
								}
								if (_tmp164_) {
									gchar* _tmp175_;
									gchar _tmp176_;
									_tmp175_ = begin;
									_tmp176_ = _tmp175_[2];
									_tmp163_ = g_ascii_isxdigit (_tmp176_);
								} else {
									_tmp163_ = FALSE;
								}
								if (_tmp163_) {
									gchar* _tmp177_;
									_tmp177_ = self->priv->current;
									self->priv->current = _tmp177_ + 1;
									while (TRUE) {
										gboolean _tmp178_ = FALSE;
										gchar* _tmp179_;
										gchar* _tmp180_;
										gchar* _tmp183_;
										_tmp179_ = self->priv->current;
										_tmp180_ = self->priv->end;
										if (_tmp179_ < _tmp180_) {
											gchar* _tmp181_;
											gchar _tmp182_;
											_tmp181_ = self->priv->current;
											_tmp182_ = _tmp181_[0];
											_tmp178_ = g_ascii_isxdigit (_tmp182_);
										} else {
											_tmp178_ = FALSE;
										}
										if (!_tmp178_) {
											break;
										}
										_tmp183_ = self->priv->current;
										self->priv->current = _tmp183_ + 1;
									}
								} else {
									gboolean _tmp184_ = FALSE;
									gchar* _tmp185_;
									gchar* _tmp186_;
									_tmp185_ = self->priv->current;
									_tmp186_ = self->priv->end;
									if (_tmp185_ < _tmp186_) {
										gchar* _tmp187_;
										gchar _tmp188_;
										_tmp187_ = self->priv->current;
										_tmp188_ = _tmp187_[0];
										_tmp184_ = vala_genie_scanner_is_ident_char (self, _tmp188_);
									} else {
										_tmp184_ = FALSE;
									}
									if (_tmp184_) {
										while (TRUE) {
											gboolean _tmp189_ = FALSE;
											gchar* _tmp190_;
											gchar* _tmp191_;
											gchar* _tmp194_;
											_tmp190_ = self->priv->current;
											_tmp191_ = self->priv->end;
											if (_tmp190_ < _tmp191_) {
												gchar* _tmp192_;
												gchar _tmp193_;
												_tmp192_ = self->priv->current;
												_tmp193_ = _tmp192_[0];
												_tmp189_ = vala_genie_scanner_is_ident_char (self, _tmp193_);
											} else {
												_tmp189_ = FALSE;
											}
											if (!_tmp189_) {
												break;
											}
											_tmp194_ = self->priv->current;
											self->priv->current = _tmp194_ + 1;
										}
										type = VALA_GENIE_TOKEN_TYPE_IDENTIFIER;
									}
								}
							}
						}
					}
				} else {
					gchar* _tmp195_;
					gchar _tmp196_;
					_tmp195_ = self->priv->current;
					_tmp196_ = _tmp195_[0];
					switch (_tmp196_) {
						case '{':
						{
							gint _tmp197_;
							gchar* _tmp198_;
							type = VALA_GENIE_TOKEN_TYPE_OPEN_BRACE;
							_tmp197_ = self->priv->open_brace_count;
							self->priv->open_brace_count = _tmp197_ + 1;
							_vala_array_add8 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_BRACE);
							_tmp198_ = self->priv->current;
							self->priv->current = _tmp198_ + 1;
							break;
						}
						case '}':
						{
							gint _tmp199_;
							ValaGenieScannerState* _tmp200_;
							gint _tmp200__length1;
							gchar* _tmp202_;
							type = VALA_GENIE_TOKEN_TYPE_CLOSE_BRACE;
							_tmp199_ = self->priv->open_brace_count;
							self->priv->open_brace_count = _tmp199_ - 1;
							_tmp200_ = self->priv->state_stack;
							_tmp200__length1 = self->priv->state_stack_length1;
							if (_tmp200__length1 > 0) {
								gint _tmp201_;
								_tmp201_ = self->priv->state_stack_length1;
								self->priv->state_stack_length1 = _tmp201_ - 1;
							}
							_tmp202_ = self->priv->current;
							self->priv->current = _tmp202_ + 1;
							break;
						}
						case '(':
						{
							gint _tmp203_;
							gchar* _tmp204_;
							type = VALA_GENIE_TOKEN_TYPE_OPEN_PARENS;
							_tmp203_ = self->priv->open_parens_count;
							self->priv->open_parens_count = _tmp203_ + 1;
							_vala_array_add9 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_PARENS);
							_tmp204_ = self->priv->current;
							self->priv->current = _tmp204_ + 1;
							break;
						}
						case ')':
						{
							gint _tmp205_;
							gchar* _tmp206_;
							ValaGenieScannerState* _tmp207_;
							gint _tmp207__length1;
							type = VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS;
							_tmp205_ = self->priv->open_parens_count;
							self->priv->open_parens_count = _tmp205_ - 1;
							_tmp206_ = self->priv->current;
							self->priv->current = _tmp206_ + 1;
							_tmp207_ = self->priv->state_stack;
							_tmp207__length1 = self->priv->state_stack_length1;
							if (_tmp207__length1 > 0) {
								gint _tmp208_;
								_tmp208_ = self->priv->state_stack_length1;
								self->priv->state_stack_length1 = _tmp208_ - 1;
							}
							if (vala_genie_scanner_in_template (self)) {
								type = VALA_GENIE_TOKEN_TYPE_COMMA;
							}
							break;
						}
						case '[':
						{
							gchar* _tmp209_;
							type = VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET;
							_vala_array_add10 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_BRACKET);
							_tmp209_ = self->priv->current;
							self->priv->current = _tmp209_ + 1;
							break;
						}
						case ']':
						{
							ValaGenieScannerState* _tmp210_;
							gint _tmp210__length1;
							gchar* _tmp212_;
							type = VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET;
							_tmp210_ = self->priv->state_stack;
							_tmp210__length1 = self->priv->state_stack_length1;
							if (_tmp210__length1 > 0) {
								gint _tmp211_;
								_tmp211_ = self->priv->state_stack_length1;
								self->priv->state_stack_length1 = _tmp211_ - 1;
							}
							_tmp212_ = self->priv->current;
							self->priv->current = _tmp212_ + 1;
							break;
						}
						case '.':
						{
							gchar* _tmp213_;
							gchar* _tmp214_;
							gchar* _tmp215_;
							type = VALA_GENIE_TOKEN_TYPE_DOT;
							_tmp213_ = self->priv->current;
							self->priv->current = _tmp213_ + 1;
							_tmp214_ = self->priv->current;
							_tmp215_ = self->priv->end;
							if (_tmp214_ < (_tmp215_ - 1)) {
								gboolean _tmp216_ = FALSE;
								gchar* _tmp217_;
								gchar _tmp218_;
								_tmp217_ = self->priv->current;
								_tmp218_ = _tmp217_[0];
								if (_tmp218_ == '.') {
									gchar* _tmp219_;
									gchar _tmp220_;
									_tmp219_ = self->priv->current;
									_tmp220_ = _tmp219_[1];
									_tmp216_ = _tmp220_ == '.';
								} else {
									_tmp216_ = FALSE;
								}
								if (_tmp216_) {
									gchar* _tmp221_;
									type = VALA_GENIE_TOKEN_TYPE_ELLIPSIS;
									_tmp221_ = self->priv->current;
									self->priv->current = _tmp221_ + 2;
								}
							}
							break;
						}
						case ':':
						{
							gchar* _tmp222_;
							type = VALA_GENIE_TOKEN_TYPE_COLON;
							_tmp222_ = self->priv->current;
							self->priv->current = _tmp222_ + 1;
							break;
						}
						case ',':
						{
							gchar* _tmp223_;
							type = VALA_GENIE_TOKEN_TYPE_COMMA;
							_tmp223_ = self->priv->current;
							self->priv->current = _tmp223_ + 1;
							break;
						}
						case ';':
						{
							gchar* _tmp224_;
							type = VALA_GENIE_TOKEN_TYPE_SEMICOLON;
							_tmp224_ = self->priv->current;
							self->priv->current = _tmp224_ + 1;
							break;
						}
						case '#':
						{
							gchar* _tmp225_;
							type = VALA_GENIE_TOKEN_TYPE_HASH;
							_tmp225_ = self->priv->current;
							self->priv->current = _tmp225_ + 1;
							break;
						}
						case '?':
						{
							gchar* _tmp226_;
							type = VALA_GENIE_TOKEN_TYPE_INTERR;
							_tmp226_ = self->priv->current;
							self->priv->current = _tmp226_ + 1;
							break;
						}
						case '|':
						{
							gchar* _tmp227_;
							gchar* _tmp228_;
							gchar* _tmp229_;
							type = VALA_GENIE_TOKEN_TYPE_BITWISE_OR;
							_tmp227_ = self->priv->current;
							self->priv->current = _tmp227_ + 1;
							_tmp228_ = self->priv->current;
							_tmp229_ = self->priv->end;
							if (_tmp228_ < _tmp229_) {
								gchar* _tmp230_;
								gchar _tmp231_;
								_tmp230_ = self->priv->current;
								_tmp231_ = _tmp230_[0];
								switch (_tmp231_) {
									case '=':
									{
										gchar* _tmp232_;
										type = VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_OR;
										_tmp232_ = self->priv->current;
										self->priv->current = _tmp232_ + 1;
										break;
									}
									case '|':
									{
										gchar* _tmp233_;
										type = VALA_GENIE_TOKEN_TYPE_OP_OR;
										_tmp233_ = self->priv->current;
										self->priv->current = _tmp233_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '&':
						{
							gchar* _tmp234_;
							gchar* _tmp235_;
							gchar* _tmp236_;
							type = VALA_GENIE_TOKEN_TYPE_BITWISE_AND;
							_tmp234_ = self->priv->current;
							self->priv->current = _tmp234_ + 1;
							_tmp235_ = self->priv->current;
							_tmp236_ = self->priv->end;
							if (_tmp235_ < _tmp236_) {
								gchar* _tmp237_;
								gchar _tmp238_;
								_tmp237_ = self->priv->current;
								_tmp238_ = _tmp237_[0];
								switch (_tmp238_) {
									case '=':
									{
										gchar* _tmp239_;
										type = VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_AND;
										_tmp239_ = self->priv->current;
										self->priv->current = _tmp239_ + 1;
										break;
									}
									case '&':
									{
										gchar* _tmp240_;
										type = VALA_GENIE_TOKEN_TYPE_OP_AND;
										_tmp240_ = self->priv->current;
										self->priv->current = _tmp240_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '^':
						{
							gchar* _tmp241_;
							gboolean _tmp242_ = FALSE;
							gchar* _tmp243_;
							gchar* _tmp244_;
							type = VALA_GENIE_TOKEN_TYPE_CARRET;
							_tmp241_ = self->priv->current;
							self->priv->current = _tmp241_ + 1;
							_tmp243_ = self->priv->current;
							_tmp244_ = self->priv->end;
							if (_tmp243_ < _tmp244_) {
								gchar* _tmp245_;
								gchar _tmp246_;
								_tmp245_ = self->priv->current;
								_tmp246_ = _tmp245_[0];
								_tmp242_ = _tmp246_ == '=';
							} else {
								_tmp242_ = FALSE;
							}
							if (_tmp242_) {
								gchar* _tmp247_;
								type = VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_XOR;
								_tmp247_ = self->priv->current;
								self->priv->current = _tmp247_ + 1;
							}
							break;
						}
						case '~':
						{
							gchar* _tmp248_;
							type = VALA_GENIE_TOKEN_TYPE_TILDE;
							_tmp248_ = self->priv->current;
							self->priv->current = _tmp248_ + 1;
							break;
						}
						case '=':
						{
							gchar* _tmp249_;
							gchar* _tmp250_;
							gchar* _tmp251_;
							type = VALA_GENIE_TOKEN_TYPE_ASSIGN;
							_tmp249_ = self->priv->current;
							self->priv->current = _tmp249_ + 1;
							_tmp250_ = self->priv->current;
							_tmp251_ = self->priv->end;
							if (_tmp250_ < _tmp251_) {
								gchar* _tmp252_;
								gchar _tmp253_;
								_tmp252_ = self->priv->current;
								_tmp253_ = _tmp252_[0];
								switch (_tmp253_) {
									case '=':
									{
										gchar* _tmp254_;
										type = VALA_GENIE_TOKEN_TYPE_OP_EQ;
										_tmp254_ = self->priv->current;
										self->priv->current = _tmp254_ + 1;
										break;
									}
									case '>':
									{
										gchar* _tmp255_;
										type = VALA_GENIE_TOKEN_TYPE_LAMBDA;
										_tmp255_ = self->priv->current;
										self->priv->current = _tmp255_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '<':
						{
							gchar* _tmp256_;
							gchar* _tmp257_;
							gchar* _tmp258_;
							type = VALA_GENIE_TOKEN_TYPE_OP_LT;
							_tmp256_ = self->priv->current;
							self->priv->current = _tmp256_ + 1;
							_tmp257_ = self->priv->current;
							_tmp258_ = self->priv->end;
							if (_tmp257_ < _tmp258_) {
								gchar* _tmp259_;
								gchar _tmp260_;
								_tmp259_ = self->priv->current;
								_tmp260_ = _tmp259_[0];
								switch (_tmp260_) {
									case '=':
									{
										gchar* _tmp261_;
										type = VALA_GENIE_TOKEN_TYPE_OP_LE;
										_tmp261_ = self->priv->current;
										self->priv->current = _tmp261_ + 1;
										break;
									}
									case '<':
									{
										gchar* _tmp262_;
										gboolean _tmp263_ = FALSE;
										gchar* _tmp264_;
										gchar* _tmp265_;
										type = VALA_GENIE_TOKEN_TYPE_OP_SHIFT_LEFT;
										_tmp262_ = self->priv->current;
										self->priv->current = _tmp262_ + 1;
										_tmp264_ = self->priv->current;
										_tmp265_ = self->priv->end;
										if (_tmp264_ < _tmp265_) {
											gchar* _tmp266_;
											gchar _tmp267_;
											_tmp266_ = self->priv->current;
											_tmp267_ = _tmp266_[0];
											_tmp263_ = _tmp267_ == '=';
										} else {
											_tmp263_ = FALSE;
										}
										if (_tmp263_) {
											gchar* _tmp268_;
											type = VALA_GENIE_TOKEN_TYPE_ASSIGN_SHIFT_LEFT;
											_tmp268_ = self->priv->current;
											self->priv->current = _tmp268_ + 1;
										}
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '>':
						{
							gchar* _tmp269_;
							gboolean _tmp270_ = FALSE;
							gchar* _tmp271_;
							gchar* _tmp272_;
							type = VALA_GENIE_TOKEN_TYPE_OP_GT;
							_tmp269_ = self->priv->current;
							self->priv->current = _tmp269_ + 1;
							_tmp271_ = self->priv->current;
							_tmp272_ = self->priv->end;
							if (_tmp271_ < _tmp272_) {
								gchar* _tmp273_;
								gchar _tmp274_;
								_tmp273_ = self->priv->current;
								_tmp274_ = _tmp273_[0];
								_tmp270_ = _tmp274_ == '=';
							} else {
								_tmp270_ = FALSE;
							}
							if (_tmp270_) {
								gchar* _tmp275_;
								type = VALA_GENIE_TOKEN_TYPE_OP_GE;
								_tmp275_ = self->priv->current;
								self->priv->current = _tmp275_ + 1;
							}
							break;
						}
						case '!':
						{
							gchar* _tmp276_;
							gboolean _tmp277_ = FALSE;
							gchar* _tmp278_;
							gchar* _tmp279_;
							type = VALA_GENIE_TOKEN_TYPE_OP_NEG;
							_tmp276_ = self->priv->current;
							self->priv->current = _tmp276_ + 1;
							_tmp278_ = self->priv->current;
							_tmp279_ = self->priv->end;
							if (_tmp278_ < _tmp279_) {
								gchar* _tmp280_;
								gchar _tmp281_;
								_tmp280_ = self->priv->current;
								_tmp281_ = _tmp280_[0];
								_tmp277_ = _tmp281_ == '=';
							} else {
								_tmp277_ = FALSE;
							}
							if (_tmp277_) {
								gchar* _tmp282_;
								type = VALA_GENIE_TOKEN_TYPE_OP_NE;
								_tmp282_ = self->priv->current;
								self->priv->current = _tmp282_ + 1;
							}
							break;
						}
						case '+':
						{
							gchar* _tmp283_;
							gchar* _tmp284_;
							gchar* _tmp285_;
							type = VALA_GENIE_TOKEN_TYPE_PLUS;
							_tmp283_ = self->priv->current;
							self->priv->current = _tmp283_ + 1;
							_tmp284_ = self->priv->current;
							_tmp285_ = self->priv->end;
							if (_tmp284_ < _tmp285_) {
								gchar* _tmp286_;
								gchar _tmp287_;
								_tmp286_ = self->priv->current;
								_tmp287_ = _tmp286_[0];
								switch (_tmp287_) {
									case '=':
									{
										gchar* _tmp288_;
										type = VALA_GENIE_TOKEN_TYPE_ASSIGN_ADD;
										_tmp288_ = self->priv->current;
										self->priv->current = _tmp288_ + 1;
										break;
									}
									case '+':
									{
										gchar* _tmp289_;
										type = VALA_GENIE_TOKEN_TYPE_OP_INC;
										_tmp289_ = self->priv->current;
										self->priv->current = _tmp289_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '-':
						{
							gchar* _tmp290_;
							gchar* _tmp291_;
							gchar* _tmp292_;
							type = VALA_GENIE_TOKEN_TYPE_MINUS;
							_tmp290_ = self->priv->current;
							self->priv->current = _tmp290_ + 1;
							_tmp291_ = self->priv->current;
							_tmp292_ = self->priv->end;
							if (_tmp291_ < _tmp292_) {
								gchar* _tmp293_;
								gchar _tmp294_;
								_tmp293_ = self->priv->current;
								_tmp294_ = _tmp293_[0];
								switch (_tmp294_) {
									case '=':
									{
										gchar* _tmp295_;
										type = VALA_GENIE_TOKEN_TYPE_ASSIGN_SUB;
										_tmp295_ = self->priv->current;
										self->priv->current = _tmp295_ + 1;
										break;
									}
									case '-':
									{
										gchar* _tmp296_;
										type = VALA_GENIE_TOKEN_TYPE_OP_DEC;
										_tmp296_ = self->priv->current;
										self->priv->current = _tmp296_ + 1;
										break;
									}
									case '>':
									{
										gchar* _tmp297_;
										type = VALA_GENIE_TOKEN_TYPE_OP_PTR;
										_tmp297_ = self->priv->current;
										self->priv->current = _tmp297_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '*':
						{
							gchar* _tmp298_;
							gboolean _tmp299_ = FALSE;
							gchar* _tmp300_;
							gchar* _tmp301_;
							type = VALA_GENIE_TOKEN_TYPE_STAR;
							_tmp298_ = self->priv->current;
							self->priv->current = _tmp298_ + 1;
							_tmp300_ = self->priv->current;
							_tmp301_ = self->priv->end;
							if (_tmp300_ < _tmp301_) {
								gchar* _tmp302_;
								gchar _tmp303_;
								_tmp302_ = self->priv->current;
								_tmp303_ = _tmp302_[0];
								_tmp299_ = _tmp303_ == '=';
							} else {
								_tmp299_ = FALSE;
							}
							if (_tmp299_) {
								gchar* _tmp304_;
								type = VALA_GENIE_TOKEN_TYPE_ASSIGN_MUL;
								_tmp304_ = self->priv->current;
								self->priv->current = _tmp304_ + 1;
							}
							break;
						}
						case '/':
						{
							ValaGenieTokenType _tmp305_;
							_tmp305_ = self->priv->last_token;
							switch (_tmp305_) {
								case VALA_GENIE_TOKEN_TYPE_ASSIGN:
								case VALA_GENIE_TOKEN_TYPE_COMMA:
								case VALA_GENIE_TOKEN_TYPE_MINUS:
								case VALA_GENIE_TOKEN_TYPE_OP_AND:
								case VALA_GENIE_TOKEN_TYPE_OP_EQ:
								case VALA_GENIE_TOKEN_TYPE_OP_GE:
								case VALA_GENIE_TOKEN_TYPE_OP_GT:
								case VALA_GENIE_TOKEN_TYPE_OP_INC:
								case VALA_GENIE_TOKEN_TYPE_OP_LE:
								case VALA_GENIE_TOKEN_TYPE_OP_LT:
								case VALA_GENIE_TOKEN_TYPE_OP_NE:
								case VALA_GENIE_TOKEN_TYPE_OP_NEG:
								case VALA_GENIE_TOKEN_TYPE_OP_OR:
								case VALA_GENIE_TOKEN_TYPE_OPEN_BRACE:
								case VALA_GENIE_TOKEN_TYPE_OPEN_PARENS:
								case VALA_GENIE_TOKEN_TYPE_PLUS:
								case VALA_GENIE_TOKEN_TYPE_RETURN:
								{
									gchar* _tmp306_;
									type = VALA_GENIE_TOKEN_TYPE_OPEN_REGEX_LITERAL;
									_vala_array_add11 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_REGEX_LITERAL);
									_tmp306_ = self->priv->current;
									self->priv->current = _tmp306_ + 1;
									break;
								}
								default:
								{
									gchar* _tmp307_;
									gboolean _tmp308_ = FALSE;
									gchar* _tmp309_;
									gchar* _tmp310_;
									type = VALA_GENIE_TOKEN_TYPE_DIV;
									_tmp307_ = self->priv->current;
									self->priv->current = _tmp307_ + 1;
									_tmp309_ = self->priv->current;
									_tmp310_ = self->priv->end;
									if (_tmp309_ < _tmp310_) {
										gchar* _tmp311_;
										gchar _tmp312_;
										_tmp311_ = self->priv->current;
										_tmp312_ = _tmp311_[0];
										_tmp308_ = _tmp312_ == '=';
									} else {
										_tmp308_ = FALSE;
									}
									if (_tmp308_) {
										gchar* _tmp313_;
										type = VALA_GENIE_TOKEN_TYPE_ASSIGN_DIV;
										_tmp313_ = self->priv->current;
										self->priv->current = _tmp313_ + 1;
									}
									break;
								}
							}
							break;
						}
						case '%':
						{
							gchar* _tmp314_;
							gboolean _tmp315_ = FALSE;
							gchar* _tmp316_;
							gchar* _tmp317_;
							type = VALA_GENIE_TOKEN_TYPE_PERCENT;
							_tmp314_ = self->priv->current;
							self->priv->current = _tmp314_ + 1;
							_tmp316_ = self->priv->current;
							_tmp317_ = self->priv->end;
							if (_tmp316_ < _tmp317_) {
								gchar* _tmp318_;
								gchar _tmp319_;
								_tmp318_ = self->priv->current;
								_tmp319_ = _tmp318_[0];
								_tmp315_ = _tmp319_ == '=';
							} else {
								_tmp315_ = FALSE;
							}
							if (_tmp315_) {
								gchar* _tmp320_;
								type = VALA_GENIE_TOKEN_TYPE_ASSIGN_PERCENT;
								_tmp320_ = self->priv->current;
								self->priv->current = _tmp320_ + 1;
							}
							break;
						}
						case '\'':
						case '"':
						{
							gchar* _tmp321_;
							gchar _tmp322_;
							gchar* _tmp367_;
							gchar* _tmp441_;
							gchar* _tmp442_;
							_tmp321_ = begin;
							_tmp322_ = _tmp321_[0];
							if (_tmp322_ == '\'') {
								type = VALA_GENIE_TOKEN_TYPE_CHARACTER_LITERAL;
							} else {
								gboolean _tmp323_ = FALSE;
								gboolean _tmp324_ = FALSE;
								gchar* _tmp325_;
								gchar* _tmp326_;
								_tmp325_ = self->priv->current;
								_tmp326_ = self->priv->end;
								if (_tmp325_ < (_tmp326_ - 6)) {
									gchar* _tmp327_;
									gchar _tmp328_;
									_tmp327_ = begin;
									_tmp328_ = _tmp327_[1];
									_tmp324_ = _tmp328_ == '"';
								} else {
									_tmp324_ = FALSE;
								}
								if (_tmp324_) {
									gchar* _tmp329_;
									gchar _tmp330_;
									_tmp329_ = begin;
									_tmp330_ = _tmp329_[2];
									_tmp323_ = _tmp330_ == '"';
								} else {
									_tmp323_ = FALSE;
								}
								if (_tmp323_) {
									gchar* _tmp331_;
									gboolean _tmp356_ = FALSE;
									gboolean _tmp357_ = FALSE;
									gchar* _tmp358_;
									gchar _tmp359_;
									type = VALA_GENIE_TOKEN_TYPE_VERBATIM_STRING_LITERAL;
									token_length_in_chars = 6;
									_tmp331_ = self->priv->current;
									self->priv->current = _tmp331_ + 3;
									while (TRUE) {
										gchar* _tmp332_;
										gchar* _tmp333_;
										gboolean _tmp334_ = FALSE;
										gboolean _tmp335_ = FALSE;
										gboolean _tmp336_ = FALSE;
										gchar* _tmp337_;
										gchar _tmp338_;
										_tmp332_ = self->priv->current;
										_tmp333_ = self->priv->end;
										if (!(_tmp332_ < (_tmp333_ - 4))) {
											break;
										}
										_tmp337_ = self->priv->current;
										_tmp338_ = _tmp337_[0];
										if (_tmp338_ == '"') {
											gchar* _tmp339_;
											gchar _tmp340_;
											_tmp339_ = self->priv->current;
											_tmp340_ = _tmp339_[1];
											_tmp336_ = _tmp340_ == '"';
										} else {
											_tmp336_ = FALSE;
										}
										if (_tmp336_) {
											gchar* _tmp341_;
											gchar _tmp342_;
											_tmp341_ = self->priv->current;
											_tmp342_ = _tmp341_[2];
											_tmp335_ = _tmp342_ == '"';
										} else {
											_tmp335_ = FALSE;
										}
										if (_tmp335_) {
											gchar* _tmp343_;
											gchar _tmp344_;
											_tmp343_ = self->priv->current;
											_tmp344_ = _tmp343_[3];
											_tmp334_ = _tmp344_ != '"';
										} else {
											_tmp334_ = FALSE;
										}
										if (_tmp334_) {
											break;
										} else {
											gchar* _tmp345_;
											gchar _tmp346_;
											_tmp345_ = self->priv->current;
											_tmp346_ = _tmp345_[0];
											if (_tmp346_ == '\n') {
												gchar* _tmp347_;
												gint _tmp348_;
												_tmp347_ = self->priv->current;
												self->priv->current = _tmp347_ + 1;
												_tmp348_ = self->priv->line;
												self->priv->line = _tmp348_ + 1;
												self->priv->column = 1;
												token_length_in_chars = 3;
											} else {
												gunichar u = 0U;
												gchar* _tmp349_;
												gchar* _tmp350_;
												gchar* _tmp351_;
												_tmp349_ = self->priv->current;
												_tmp350_ = self->priv->end;
												_tmp351_ = self->priv->current;
												u = g_utf8_get_char_validated ((const gchar*) _tmp349_, (gssize) ((glong) (_tmp350_ - _tmp351_)));
												if (u != ((gunichar) -1)) {
													gchar* _tmp352_;
													gint _tmp353_;
													_tmp352_ = self->priv->current;
													self->priv->current = _tmp352_ + g_unichar_to_utf8 (u, NULL);
													_tmp353_ = token_length_in_chars;
													token_length_in_chars = _tmp353_ + 1;
												} else {
													ValaSourceReference* _tmp354_;
													ValaSourceReference* _tmp355_;
													_tmp354_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
													_tmp355_ = _tmp354_;
													vala_report_error (_tmp355_, "invalid UTF-8 character");
													_vala_source_reference_unref0 (_tmp355_);
												}
											}
										}
									}
									_tmp358_ = self->priv->current;
									_tmp359_ = _tmp358_[0];
									if (_tmp359_ == '"') {
										gchar* _tmp360_;
										gchar _tmp361_;
										_tmp360_ = self->priv->current;
										_tmp361_ = _tmp360_[1];
										_tmp357_ = _tmp361_ == '"';
									} else {
										_tmp357_ = FALSE;
									}
									if (_tmp357_) {
										gchar* _tmp362_;
										gchar _tmp363_;
										_tmp362_ = self->priv->current;
										_tmp363_ = _tmp362_[2];
										_tmp356_ = _tmp363_ == '"';
									} else {
										_tmp356_ = FALSE;
									}
									if (_tmp356_) {
										gchar* _tmp364_;
										_tmp364_ = self->priv->current;
										self->priv->current = _tmp364_ + 3;
									} else {
										ValaSourceReference* _tmp365_;
										ValaSourceReference* _tmp366_;
										_tmp365_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
										_tmp366_ = _tmp365_;
										vala_report_error (_tmp366_, "syntax error, expected \"\"\"");
										_vala_source_reference_unref0 (_tmp366_);
									}
									break;
								} else {
									type = VALA_GENIE_TOKEN_TYPE_STRING_LITERAL;
								}
							}
							token_length_in_chars = 2;
							_tmp367_ = self->priv->current;
							self->priv->current = _tmp367_ + 1;
							while (TRUE) {
								gboolean _tmp368_ = FALSE;
								gchar* _tmp369_;
								gchar* _tmp370_;
								gchar* _tmp375_;
								gchar _tmp376_;
								gboolean _tmp431_ = FALSE;
								gboolean _tmp432_ = FALSE;
								gchar* _tmp433_;
								gchar* _tmp434_;
								_tmp369_ = self->priv->current;
								_tmp370_ = self->priv->end;
								if (_tmp369_ < _tmp370_) {
									gchar* _tmp371_;
									gchar _tmp372_;
									gchar* _tmp373_;
									gchar _tmp374_;
									_tmp371_ = self->priv->current;
									_tmp372_ = _tmp371_[0];
									_tmp373_ = begin;
									_tmp374_ = _tmp373_[0];
									_tmp368_ = _tmp372_ != _tmp374_;
								} else {
									_tmp368_ = FALSE;
								}
								if (!_tmp368_) {
									break;
								}
								_tmp375_ = self->priv->current;
								_tmp376_ = _tmp375_[0];
								if (_tmp376_ == '\\') {
									gchar* _tmp377_;
									gint _tmp378_;
									gchar* _tmp379_;
									gchar* _tmp380_;
									gchar* _tmp381_;
									gchar _tmp382_;
									_tmp377_ = self->priv->current;
									self->priv->current = _tmp377_ + 1;
									_tmp378_ = token_length_in_chars;
									token_length_in_chars = _tmp378_ + 1;
									_tmp379_ = self->priv->current;
									_tmp380_ = self->priv->end;
									if (_tmp379_ >= _tmp380_) {
										break;
									}
									_tmp381_ = self->priv->current;
									_tmp382_ = _tmp381_[0];
									switch (_tmp382_) {
										case '\'':
										case '"':
										case '\\':
										case '0':
										case 'b':
										case 'f':
										case 'n':
										case 'r':
										case 't':
										case 'v':
										{
											gchar* _tmp383_;
											gint _tmp384_;
											_tmp383_ = self->priv->current;
											self->priv->current = _tmp383_ + 1;
											_tmp384_ = token_length_in_chars;
											token_length_in_chars = _tmp384_ + 1;
											break;
										}
										case 'u':
										{
											gchar* _tmp385_;
											gint _tmp386_;
											gint digit_length = 0;
											_tmp385_ = self->priv->current;
											self->priv->current = _tmp385_ + 1;
											_tmp386_ = token_length_in_chars;
											token_length_in_chars = _tmp386_ + 1;
											{
												gboolean _tmp387_ = FALSE;
												digit_length = 0;
												_tmp387_ = TRUE;
												while (TRUE) {
													gboolean _tmp389_ = FALSE;
													gchar* _tmp390_;
													gchar* _tmp391_;
													gchar* _tmp394_;
													gint _tmp395_;
													if (!_tmp387_) {
														gint _tmp388_;
														_tmp388_ = digit_length;
														digit_length = _tmp388_ + 1;
													}
													_tmp387_ = FALSE;
													_tmp390_ = self->priv->current;
													_tmp391_ = self->priv->end;
													if (_tmp390_ < _tmp391_) {
														gchar* _tmp392_;
														gchar _tmp393_;
														_tmp392_ = self->priv->current;
														_tmp393_ = _tmp392_[0];
														_tmp389_ = g_ascii_isxdigit (_tmp393_);
													} else {
														_tmp389_ = FALSE;
													}
													if (!_tmp389_) {
														break;
													}
													_tmp394_ = self->priv->current;
													self->priv->current = _tmp394_ + 1;
													_tmp395_ = token_length_in_chars;
													token_length_in_chars = _tmp395_ + 1;
												}
											}
											if (digit_length < 1) {
												ValaSourceReference* _tmp396_;
												ValaSourceReference* _tmp397_;
												_tmp396_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
												_tmp397_ = _tmp396_;
												vala_report_error (_tmp397_, "\\u used with no following hex digits");
												_vala_source_reference_unref0 (_tmp397_);
											} else {
												if (digit_length < 4) {
													ValaSourceReference* _tmp398_;
													ValaSourceReference* _tmp399_;
													_tmp398_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
													_tmp399_ = _tmp398_;
													vala_report_error (_tmp399_, "incomplete universal character name");
													_vala_source_reference_unref0 (_tmp399_);
												}
											}
											break;
										}
										case 'x':
										{
											gchar* _tmp400_;
											gint _tmp401_;
											gint digit_length = 0;
											_tmp400_ = self->priv->current;
											self->priv->current = _tmp400_ + 1;
											_tmp401_ = token_length_in_chars;
											token_length_in_chars = _tmp401_ + 1;
											{
												gboolean _tmp402_ = FALSE;
												digit_length = 0;
												_tmp402_ = TRUE;
												while (TRUE) {
													gboolean _tmp403_ = FALSE;
													gchar* _tmp404_;
													gchar* _tmp405_;
													gchar* _tmp408_;
													gchar _tmp409_;
													gchar* _tmp411_;
													gint _tmp412_;
													if (!_tmp402_) {
													}
													_tmp402_ = FALSE;
													_tmp404_ = self->priv->current;
													_tmp405_ = self->priv->end;
													if (_tmp404_ < _tmp405_) {
														gchar* _tmp406_;
														gchar _tmp407_;
														_tmp406_ = self->priv->current;
														_tmp407_ = _tmp406_[0];
														_tmp403_ = g_ascii_isxdigit (_tmp407_);
													} else {
														_tmp403_ = FALSE;
													}
													if (!_tmp403_) {
														break;
													}
													_tmp408_ = self->priv->current;
													_tmp409_ = _tmp408_[0];
													if (_tmp409_ != '0') {
														gint _tmp410_;
														_tmp410_ = digit_length;
														digit_length = _tmp410_ + 1;
													}
													_tmp411_ = self->priv->current;
													self->priv->current = _tmp411_ + 1;
													_tmp412_ = token_length_in_chars;
													token_length_in_chars = _tmp412_ + 1;
												}
											}
											if (digit_length < 1) {
												ValaSourceReference* _tmp413_;
												ValaSourceReference* _tmp414_;
												_tmp413_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
												_tmp414_ = _tmp413_;
												vala_report_error (_tmp414_, "\\x used with no following hex digits");
												_vala_source_reference_unref0 (_tmp414_);
											} else {
												if (digit_length > 2) {
													ValaSourceReference* _tmp415_;
													ValaSourceReference* _tmp416_;
													_tmp415_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
													_tmp416_ = _tmp415_;
													vala_report_error (_tmp416_, "hex escape sequence out of range");
													_vala_source_reference_unref0 (_tmp416_);
												}
											}
											break;
										}
										default:
										{
											ValaSourceReference* _tmp417_;
											ValaSourceReference* _tmp418_;
											_tmp417_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
											_tmp418_ = _tmp417_;
											vala_report_error (_tmp418_, "invalid escape sequence");
											_vala_source_reference_unref0 (_tmp418_);
											break;
										}
									}
								} else {
									gchar* _tmp419_;
									gchar _tmp420_;
									_tmp419_ = self->priv->current;
									_tmp420_ = _tmp419_[0];
									if (_tmp420_ == '\n') {
										gchar* _tmp421_;
										gint _tmp422_;
										_tmp421_ = self->priv->current;
										self->priv->current = _tmp421_ + 1;
										_tmp422_ = self->priv->line;
										self->priv->line = _tmp422_ + 1;
										self->priv->column = 1;
										token_length_in_chars = 1;
									} else {
										gunichar u = 0U;
										gchar* _tmp423_;
										gchar* _tmp424_;
										gchar* _tmp425_;
										_tmp423_ = self->priv->current;
										_tmp424_ = self->priv->end;
										_tmp425_ = self->priv->current;
										u = g_utf8_get_char_validated ((const gchar*) _tmp423_, (gssize) ((glong) (_tmp424_ - _tmp425_)));
										if (u != ((gunichar) -1)) {
											gchar* _tmp426_;
											gint _tmp427_;
											_tmp426_ = self->priv->current;
											self->priv->current = _tmp426_ + g_unichar_to_utf8 (u, NULL);
											_tmp427_ = token_length_in_chars;
											token_length_in_chars = _tmp427_ + 1;
										} else {
											gchar* _tmp428_;
											ValaSourceReference* _tmp429_;
											ValaSourceReference* _tmp430_;
											_tmp428_ = self->priv->current;
											self->priv->current = _tmp428_ + 1;
											_tmp429_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
											_tmp430_ = _tmp429_;
											vala_report_error (_tmp430_, "invalid UTF-8 character");
											_vala_source_reference_unref0 (_tmp430_);
										}
									}
								}
								_tmp433_ = self->priv->current;
								_tmp434_ = self->priv->end;
								if (_tmp433_ < _tmp434_) {
									gchar* _tmp435_;
									gchar _tmp436_;
									_tmp435_ = begin;
									_tmp436_ = _tmp435_[0];
									_tmp432_ = _tmp436_ == '\'';
								} else {
									_tmp432_ = FALSE;
								}
								if (_tmp432_) {
									gchar* _tmp437_;
									gchar _tmp438_;
									_tmp437_ = self->priv->current;
									_tmp438_ = _tmp437_[0];
									_tmp431_ = _tmp438_ != '\'';
								} else {
									_tmp431_ = FALSE;
								}
								if (_tmp431_) {
									ValaSourceReference* _tmp439_;
									ValaSourceReference* _tmp440_;
									_tmp439_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
									_tmp440_ = _tmp439_;
									vala_report_error (_tmp440_, "invalid character literal");
									_vala_source_reference_unref0 (_tmp440_);
								}
							}
							_tmp441_ = self->priv->current;
							_tmp442_ = self->priv->end;
							if (_tmp441_ < _tmp442_) {
								gchar* _tmp443_;
								_tmp443_ = self->priv->current;
								self->priv->current = _tmp443_ + 1;
							} else {
								ValaSourceReference* _tmp444_;
								ValaSourceReference* _tmp445_;
								gchar* _tmp446_;
								gchar _tmp447_;
								gchar* _tmp448_;
								gchar* _tmp449_;
								_tmp444_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
								_tmp445_ = _tmp444_;
								_tmp446_ = begin;
								_tmp447_ = _tmp446_[0];
								_tmp448_ = g_strdup_printf ("syntax error, expected %c", (gint) _tmp447_);
								_tmp449_ = _tmp448_;
								vala_report_error (_tmp445_, _tmp449_);
								_g_free0 (_tmp449_);
								_vala_source_reference_unref0 (_tmp445_);
							}
							break;
						}
						default:
						{
							gunichar u = 0U;
							gchar* _tmp450_;
							gchar* _tmp451_;
							gchar* _tmp452_;
							gint _tmp459_;
							ValaSourceLocation _tmp460_ = {0};
							ValaSourceLocation _tmp461_ = {0};
							ValaGenieTokenType _tmp462_;
							_tmp450_ = self->priv->current;
							_tmp451_ = self->priv->end;
							_tmp452_ = self->priv->current;
							u = g_utf8_get_char_validated ((const gchar*) _tmp450_, (gssize) ((glong) (_tmp451_ - _tmp452_)));
							if (u != ((gunichar) -1)) {
								gchar* _tmp453_;
								ValaSourceReference* _tmp454_;
								ValaSourceReference* _tmp455_;
								_tmp453_ = self->priv->current;
								self->priv->current = _tmp453_ + g_unichar_to_utf8 (u, NULL);
								_tmp454_ = vala_genie_scanner_get_source_reference (self, 0, 0);
								_tmp455_ = _tmp454_;
								vala_report_error (_tmp455_, "syntax error, unexpected character");
								_vala_source_reference_unref0 (_tmp455_);
							} else {
								gchar* _tmp456_;
								ValaSourceReference* _tmp457_;
								ValaSourceReference* _tmp458_;
								_tmp456_ = self->priv->current;
								self->priv->current = _tmp456_ + 1;
								_tmp457_ = vala_genie_scanner_get_source_reference (self, 0, 0);
								_tmp458_ = _tmp457_;
								vala_report_error (_tmp458_, "invalid UTF-8 character");
								_vala_source_reference_unref0 (_tmp458_);
							}
							_tmp459_ = self->priv->column;
							self->priv->column = _tmp459_ + 1;
							_tmp462_ = vala_genie_scanner_read_token (self, &_tmp460_, &_tmp461_);
							_vala_token_begin = _tmp460_;
							_vala_token_end = _tmp461_;
							result = _tmp462_;
							if (token_begin) {
								*token_begin = _vala_token_begin;
							}
							if (token_end) {
								*token_end = _vala_token_end;
							}
							return result;
						}
					}
				}
			}
		}
	}
	if (token_length_in_chars < 0) {
		gchar* _tmp463_;
		gchar* _tmp464_;
		_tmp463_ = self->priv->current;
		_tmp464_ = begin;
		self->priv->column = self->priv->column + ((gint) (_tmp463_ - _tmp464_));
	} else {
		self->priv->column = self->priv->column + token_length_in_chars;
	}
	_tmp465_ = self->priv->current;
	vala_source_location_init (&_vala_token_end, _tmp465_, self->priv->line, self->priv->column - 1);
	_tmp466_ = type;
	self->priv->last_token = _tmp466_;
	result = type;
	if (token_begin) {
		*token_begin = _vala_token_begin;
	}
	if (token_end) {
		*token_end = _vala_token_end;
	}
	return result;
}

static gint
vala_genie_scanner_count_tabs (ValaGenieScanner* self)
{
	gint tab_count = 0;
	gboolean _tmp16_ = FALSE;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	tab_count = 0;
	if (self->priv->_indent_spaces == 0) {
		while (TRUE) {
			gboolean _tmp0_ = FALSE;
			gchar* _tmp1_;
			gchar* _tmp2_;
			gchar* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			_tmp1_ = self->priv->current;
			_tmp2_ = self->priv->end;
			if (_tmp1_ < _tmp2_) {
				gchar* _tmp3_;
				gchar _tmp4_;
				_tmp3_ = self->priv->current;
				_tmp4_ = _tmp3_[0];
				_tmp0_ = _tmp4_ == '\t';
			} else {
				_tmp0_ = FALSE;
			}
			if (!_tmp0_) {
				break;
			}
			_tmp5_ = self->priv->current;
			self->priv->current = _tmp5_ + 1;
			_tmp6_ = self->priv->column;
			self->priv->column = _tmp6_ + 1;
			_tmp7_ = tab_count;
			tab_count = _tmp7_ + 1;
		}
	} else {
		gint space_count = 0;
		space_count = 0;
		while (TRUE) {
			gboolean _tmp8_ = FALSE;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			_tmp9_ = self->priv->current;
			_tmp10_ = self->priv->end;
			if (_tmp9_ < _tmp10_) {
				gchar* _tmp11_;
				gchar _tmp12_;
				_tmp11_ = self->priv->current;
				_tmp12_ = _tmp11_[0];
				_tmp8_ = _tmp12_ == ' ';
			} else {
				_tmp8_ = FALSE;
			}
			if (!_tmp8_) {
				break;
			}
			_tmp13_ = self->priv->current;
			self->priv->current = _tmp13_ + 1;
			_tmp14_ = self->priv->column;
			self->priv->column = _tmp14_ + 1;
			_tmp15_ = space_count;
			space_count = _tmp15_ + 1;
		}
		tab_count = space_count / self->priv->_indent_spaces;
	}
	vala_genie_scanner_space (self);
	_tmp17_ = self->priv->current;
	_tmp18_ = self->priv->end;
	if (_tmp17_ < _tmp18_) {
		gchar* _tmp19_;
		gchar _tmp20_;
		_tmp19_ = self->priv->current;
		_tmp20_ = _tmp19_[0];
		_tmp16_ = _tmp20_ == '\n';
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		result = -1;
		return result;
	}
	result = tab_count;
	return result;
}

static gboolean
vala_genie_scanner_matches (gchar* begin,
                            const gchar* keyword)
{
	gchar* keyword_array = NULL;
	glong len = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (keyword != NULL, FALSE);
	keyword_array = (gchar*) keyword;
	_tmp0_ = strlen (keyword);
	_tmp1_ = _tmp0_;
	len = (glong) _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gchar _tmp4_;
				gchar* _tmp5_;
				gchar _tmp6_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(((glong) i) < len)) {
					break;
				}
				_tmp4_ = begin[i];
				_tmp5_ = keyword_array;
				_tmp6_ = _tmp5_[i];
				if (_tmp4_ != _tmp6_) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
vala_genie_scanner_whitespace (ValaGenieScanner* self)
{
	gboolean found = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp8_;
		gint _tmp9_;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->end;
		if (_tmp2_ < _tmp3_) {
			gchar* _tmp4_;
			gchar _tmp5_;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_[0];
			_tmp1_ = g_ascii_isspace (_tmp5_);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[0];
			_tmp0_ = _tmp7_ != '\n';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		found = TRUE;
		_tmp8_ = self->priv->current;
		self->priv->current = _tmp8_ + 1;
		_tmp9_ = self->priv->column;
		self->priv->column = _tmp9_ + 1;
	}
	if (self->priv->column == 1) {
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp12_ = self->priv->current;
		_tmp13_ = self->priv->end;
		_tmp11_ = _tmp12_ < _tmp13_;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		gchar* _tmp14_;
		gchar _tmp15_;
		_tmp14_ = self->priv->current;
		_tmp15_ = _tmp14_[0];
		_tmp10_ = _tmp15_ == '#';
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		vala_genie_scanner_pp_directive (self);
		result = TRUE;
		return result;
	}
	result = found;
	return result;
}

static inline gboolean
vala_genie_scanner_newline (ValaGenieScanner* self)
{
	gchar* _tmp0_;
	gchar _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->current;
	_tmp1_ = _tmp0_[0];
	if (_tmp1_ == '\n') {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
vala_genie_scanner_skip_newlines (ValaGenieScanner* self)
{
	gboolean new_lines = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	new_lines = FALSE;
	while (TRUE) {
		gchar* _tmp0_;
		gint _tmp1_;
		if (!vala_genie_scanner_newline (self)) {
			break;
		}
		_tmp0_ = self->priv->current;
		self->priv->current = _tmp0_ + 1;
		_tmp1_ = self->priv->line;
		self->priv->line = _tmp1_ + 1;
		self->priv->column = 1;
		self->priv->current_indent_level = 0;
		new_lines = TRUE;
	}
	result = new_lines;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
vala_genie_scanner_comment (ValaGenieScanner* self,
                            gboolean file_comment)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_;
	gchar* _tmp13_;
	gchar _tmp14_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp3_ = self->priv->current;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = self->priv->current;
		_tmp5_ = self->priv->end;
		_tmp2_ = _tmp4_ > (_tmp5_ - 2);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gchar* _tmp6_;
		gchar _tmp7_;
		_tmp6_ = self->priv->current;
		_tmp7_ = _tmp6_[0];
		_tmp1_ = _tmp7_ != '/';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp8_ = FALSE;
		gchar* _tmp9_;
		gchar _tmp10_;
		_tmp9_ = self->priv->current;
		_tmp10_ = _tmp9_[1];
		if (_tmp10_ != '/') {
			gchar* _tmp11_;
			gchar _tmp12_;
			_tmp11_ = self->priv->current;
			_tmp12_ = _tmp11_[1];
			_tmp8_ = _tmp12_ != '*';
		} else {
			_tmp8_ = FALSE;
		}
		_tmp0_ = _tmp8_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp13_ = self->priv->current;
	_tmp14_ = _tmp13_[1];
	if (_tmp14_ == '/') {
		ValaSourceReference* source_reference = NULL;
		gchar* _tmp16_;
		gboolean _tmp23_ = FALSE;
		gchar* _tmp24_;
		gchar _tmp25_;
		ValaSourceReference* _tmp29_;
		source_reference = NULL;
		if (file_comment) {
			ValaSourceReference* _tmp15_;
			_tmp15_ = vala_genie_scanner_get_source_reference (self, 0, 0);
			_vala_source_reference_unref0 (source_reference);
			source_reference = _tmp15_;
		}
		_tmp16_ = self->priv->current;
		self->priv->current = _tmp16_ + 2;
		while (TRUE) {
			gboolean _tmp17_ = FALSE;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp22_;
			_tmp18_ = self->priv->current;
			_tmp19_ = self->priv->end;
			if (_tmp18_ < _tmp19_) {
				gchar* _tmp20_;
				gchar _tmp21_;
				_tmp20_ = self->priv->current;
				_tmp21_ = _tmp20_[0];
				_tmp17_ = _tmp21_ != '\n';
			} else {
				_tmp17_ = FALSE;
			}
			if (!_tmp17_) {
				break;
			}
			_tmp22_ = self->priv->current;
			self->priv->current = _tmp22_ + 1;
		}
		_tmp24_ = self->priv->current;
		_tmp25_ = _tmp24_[0];
		if (_tmp25_ == '\n') {
			ValaGenieTokenType _tmp26_;
			_tmp26_ = self->priv->last_token;
			_tmp23_ = _tmp26_ == VALA_GENIE_TOKEN_TYPE_EOL;
		} else {
			_tmp23_ = FALSE;
		}
		if (_tmp23_) {
			gchar* _tmp27_;
			gint _tmp28_;
			_tmp27_ = self->priv->current;
			self->priv->current = _tmp27_ + 1;
			_tmp28_ = self->priv->line;
			self->priv->line = _tmp28_ + 1;
			self->priv->column = 1;
			self->priv->current_indent_level = 0;
		}
		_tmp29_ = source_reference;
		if (_tmp29_ != NULL) {
			gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			ValaSourceReference* _tmp35_;
			_tmp30_ = self->priv->begin;
			_tmp31_ = self->priv->current;
			_tmp32_ = self->priv->begin;
			_tmp33_ = string_substring ((const gchar*) _tmp30_, (glong) 0, (glong) (_tmp31_ - _tmp32_));
			_tmp34_ = _tmp33_;
			_tmp35_ = source_reference;
			vala_genie_scanner_push_comment (self, _tmp34_, _tmp35_, file_comment);
			_g_free0 (_tmp34_);
		}
		_vala_source_reference_unref0 (source_reference);
	} else {
		ValaSourceReference* source_reference = NULL;
		gboolean _tmp36_ = FALSE;
		gboolean _tmp39_ = FALSE;
		gchar* _tmp40_;
		gchar _tmp41_;
		gchar* _tmp43_;
		gchar* begin = NULL;
		gchar* _tmp44_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		ValaSourceReference* _tmp62_;
		gchar* _tmp69_;
		source_reference = NULL;
		if (file_comment) {
			gchar* _tmp37_;
			gchar _tmp38_;
			_tmp37_ = self->priv->current;
			_tmp38_ = _tmp37_[2];
			_tmp36_ = _tmp38_ == '*';
		} else {
			_tmp36_ = FALSE;
		}
		if (_tmp36_) {
			result = FALSE;
			_vala_source_reference_unref0 (source_reference);
			return result;
		}
		_tmp40_ = self->priv->current;
		_tmp41_ = _tmp40_[2];
		if (_tmp41_ == '*') {
			_tmp39_ = TRUE;
		} else {
			_tmp39_ = file_comment;
		}
		if (_tmp39_) {
			ValaSourceReference* _tmp42_;
			_tmp42_ = vala_genie_scanner_get_source_reference (self, 0, 0);
			_vala_source_reference_unref0 (source_reference);
			source_reference = _tmp42_;
		}
		_tmp43_ = self->priv->current;
		self->priv->current = _tmp43_ + 2;
		_tmp44_ = self->priv->current;
		begin = _tmp44_;
		while (TRUE) {
			gboolean _tmp45_ = FALSE;
			gchar* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp53_;
			gchar _tmp54_;
			gchar* _tmp56_;
			gint _tmp57_;
			_tmp46_ = self->priv->current;
			_tmp47_ = self->priv->end;
			if (_tmp46_ < (_tmp47_ - 1)) {
				gboolean _tmp48_ = FALSE;
				gchar* _tmp49_;
				gchar _tmp50_;
				_tmp49_ = self->priv->current;
				_tmp50_ = _tmp49_[0];
				if (_tmp50_ != '*') {
					_tmp48_ = TRUE;
				} else {
					gchar* _tmp51_;
					gchar _tmp52_;
					_tmp51_ = self->priv->current;
					_tmp52_ = _tmp51_[1];
					_tmp48_ = _tmp52_ != '/';
				}
				_tmp45_ = _tmp48_;
			} else {
				_tmp45_ = FALSE;
			}
			if (!_tmp45_) {
				break;
			}
			_tmp53_ = self->priv->current;
			_tmp54_ = _tmp53_[0];
			if (_tmp54_ == '\n') {
				gint _tmp55_;
				_tmp55_ = self->priv->line;
				self->priv->line = _tmp55_ + 1;
				self->priv->column = 0;
			}
			_tmp56_ = self->priv->current;
			self->priv->current = _tmp56_ + 1;
			_tmp57_ = self->priv->column;
			self->priv->column = _tmp57_ + 1;
		}
		_tmp58_ = self->priv->current;
		_tmp59_ = self->priv->end;
		if (_tmp58_ == (_tmp59_ - 1)) {
			ValaSourceReference* _tmp60_;
			ValaSourceReference* _tmp61_;
			_tmp60_ = vala_genie_scanner_get_source_reference (self, 0, 0);
			_tmp61_ = _tmp60_;
			vala_report_error (_tmp61_, "syntax error, expected */");
			_vala_source_reference_unref0 (_tmp61_);
			result = TRUE;
			_vala_source_reference_unref0 (source_reference);
			return result;
		}
		_tmp62_ = source_reference;
		if (_tmp62_ != NULL) {
			gchar* comment = NULL;
			gchar* _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			gchar* _tmp66_;
			const gchar* _tmp67_;
			ValaSourceReference* _tmp68_;
			_tmp63_ = begin;
			_tmp64_ = self->priv->current;
			_tmp65_ = begin;
			_tmp66_ = string_substring ((const gchar*) _tmp63_, (glong) 0, (glong) (_tmp64_ - _tmp65_));
			comment = _tmp66_;
			_tmp67_ = comment;
			_tmp68_ = source_reference;
			vala_genie_scanner_push_comment (self, _tmp67_, _tmp68_, file_comment);
			_g_free0 (comment);
		}
		_tmp69_ = self->priv->current;
		self->priv->current = _tmp69_ + 2;
		self->priv->column = self->priv->column + 2;
		_vala_source_reference_unref0 (source_reference);
	}
	result = TRUE;
	return result;
}

static gboolean
vala_genie_scanner_skip_tabs (ValaGenieScanner* self)
{
	gboolean found = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp5_;
		gint _tmp6_;
		_tmp1_ = self->priv->current;
		_tmp2_ = self->priv->end;
		if (_tmp1_ < _tmp2_) {
			gchar* _tmp3_;
			gchar _tmp4_;
			_tmp3_ = self->priv->current;
			_tmp4_ = _tmp3_[0];
			_tmp0_ = _tmp4_ == '\t';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp5_ = self->priv->current;
		self->priv->current = _tmp5_ + 1;
		_tmp6_ = self->priv->column;
		self->priv->column = _tmp6_ + 1;
		found = TRUE;
	}
	result = found;
	return result;
}

static void
vala_genie_scanner_skip_space_tabs (ValaGenieScanner* self)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		if (vala_genie_scanner_whitespace (self)) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = vala_genie_scanner_skip_tabs (self);
		}
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = vala_genie_scanner_comment (self, FALSE);
		}
		if (!_tmp0_) {
			break;
		}
	}
}

static void
vala_genie_scanner_space (ValaGenieScanner* self)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (vala_genie_scanner_whitespace (self)) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = vala_genie_scanner_comment (self, FALSE);
		}
		if (!_tmp0_) {
			break;
		}
	}
}

void
vala_genie_scanner_parse_file_comments (ValaGenieScanner* self)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (vala_genie_scanner_whitespace (self)) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = vala_genie_scanner_comment (self, TRUE);
		}
		if (!_tmp0_) {
			break;
		}
	}
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static void
vala_genie_scanner_push_comment (ValaGenieScanner* self,
                                 const gchar* comment_item,
                                 ValaSourceReference* source_reference,
                                 gboolean file_comment)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (comment_item != NULL);
	g_return_if_fail (source_reference != NULL);
	if (string_get (comment_item, (glong) 0) == '*') {
		ValaComment* _tmp0_;
		ValaComment* _tmp3_;
		_tmp0_ = self->priv->_comment;
		if (_tmp0_ != NULL) {
			ValaSourceFile* _tmp1_;
			ValaComment* _tmp2_;
			_tmp1_ = self->priv->_source_file;
			_tmp2_ = self->priv->_comment;
			vala_source_file_add_comment (_tmp1_, _tmp2_);
		}
		_tmp3_ = vala_comment_new (comment_item, source_reference);
		_vala_comment_unref0 (self->priv->_comment);
		self->priv->_comment = _tmp3_;
	}
	if (file_comment) {
		ValaSourceFile* _tmp4_;
		ValaComment* _tmp5_;
		ValaComment* _tmp6_;
		_tmp4_ = self->priv->_source_file;
		_tmp5_ = vala_comment_new (comment_item, source_reference);
		_tmp6_ = _tmp5_;
		vala_source_file_add_comment (_tmp4_, _tmp6_);
		_vala_comment_unref0 (_tmp6_);
		_vala_comment_unref0 (self->priv->_comment);
		self->priv->_comment = NULL;
	}
}

/**
 * Clears and returns the content of the comment stack.
 *
 * @return saved comment
 */
static gpointer
_vala_comment_ref0 (gpointer self)
{
	return self ? vala_comment_ref (self) : NULL;
}

ValaComment*
vala_genie_scanner_pop_comment (ValaGenieScanner* self)
{
	ValaComment* _tmp0_;
	ValaComment* comment = NULL;
	ValaComment* _tmp1_;
	ValaComment* _tmp2_;
	ValaComment* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_comment;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->_comment;
	_tmp2_ = _vala_comment_ref0 (_tmp1_);
	comment = _tmp2_;
	_vala_comment_unref0 (self->priv->_comment);
	self->priv->_comment = NULL;
	result = comment;
	return result;
}

static gboolean
vala_genie_scanner_pp_whitespace (ValaGenieScanner* self)
{
	gboolean found = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp8_;
		gint _tmp9_;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->end;
		if (_tmp2_ < _tmp3_) {
			gchar* _tmp4_;
			gchar _tmp5_;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_[0];
			_tmp1_ = g_ascii_isspace (_tmp5_);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[0];
			_tmp0_ = _tmp7_ != '\n';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		found = TRUE;
		_tmp8_ = self->priv->current;
		self->priv->current = _tmp8_ + 1;
		_tmp9_ = self->priv->column;
		self->priv->column = _tmp9_ + 1;
	}
	result = found;
	return result;
}

static void
vala_genie_scanner_pp_space (ValaGenieScanner* self)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (vala_genie_scanner_pp_whitespace (self)) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = vala_genie_scanner_comment (self, FALSE);
		}
		if (!_tmp0_) {
			break;
		}
	}
}

static void
vala_genie_scanner_pp_directive (ValaGenieScanner* self)
{
	gchar* _tmp0_;
	gint _tmp1_;
	gchar* begin = NULL;
	gchar* _tmp2_;
	gint len = 0;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp21_ = FALSE;
	ValaGenieScannerConditional* _tmp22_;
	gint _tmp22__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current;
	self->priv->current = _tmp0_ + 1;
	_tmp1_ = self->priv->column;
	self->priv->column = _tmp1_ + 1;
	vala_genie_scanner_pp_space (self);
	_tmp2_ = self->priv->current;
	begin = _tmp2_;
	len = 0;
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp4_ = self->priv->current;
		_tmp5_ = self->priv->end;
		if (_tmp4_ < _tmp5_) {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[0];
			_tmp3_ = g_ascii_isalnum (_tmp7_);
		} else {
			_tmp3_ = FALSE;
		}
		if (!_tmp3_) {
			break;
		}
		_tmp8_ = self->priv->current;
		self->priv->current = _tmp8_ + 1;
		_tmp9_ = self->priv->column;
		self->priv->column = _tmp9_ + 1;
		_tmp10_ = len;
		len = _tmp10_ + 1;
	}
	if (len == 2) {
		gchar* _tmp12_;
		_tmp12_ = begin;
		_tmp11_ = vala_genie_scanner_matches (_tmp12_, "if");
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		vala_genie_scanner_parse_pp_if (self);
	} else {
		gboolean _tmp13_ = FALSE;
		if (len == 4) {
			gchar* _tmp14_;
			_tmp14_ = begin;
			_tmp13_ = vala_genie_scanner_matches (_tmp14_, "elif");
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			vala_genie_scanner_parse_pp_elif (self);
		} else {
			gboolean _tmp15_ = FALSE;
			if (len == 4) {
				gchar* _tmp16_;
				_tmp16_ = begin;
				_tmp15_ = vala_genie_scanner_matches (_tmp16_, "else");
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				vala_genie_scanner_parse_pp_else (self);
			} else {
				gboolean _tmp17_ = FALSE;
				if (len == 5) {
					gchar* _tmp18_;
					_tmp18_ = begin;
					_tmp17_ = vala_genie_scanner_matches (_tmp18_, "endif");
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					vala_genie_scanner_parse_pp_endif (self);
				} else {
					ValaSourceReference* _tmp19_;
					ValaSourceReference* _tmp20_;
					_tmp19_ = vala_genie_scanner_get_source_reference (self, -len, len);
					_tmp20_ = _tmp19_;
					vala_report_error (_tmp20_, "syntax error, invalid preprocessing directive");
					_vala_source_reference_unref0 (_tmp20_);
				}
			}
		}
	}
	_tmp22_ = self->priv->conditional_stack;
	_tmp22__length1 = self->priv->conditional_stack_length1;
	if (_tmp22__length1 > 0) {
		ValaGenieScannerConditional* _tmp23_;
		gint _tmp23__length1;
		ValaGenieScannerConditional* _tmp24_;
		gint _tmp24__length1;
		ValaGenieScannerConditional _tmp25_;
		_tmp23_ = self->priv->conditional_stack;
		_tmp23__length1 = self->priv->conditional_stack_length1;
		_tmp24_ = self->priv->conditional_stack;
		_tmp24__length1 = self->priv->conditional_stack_length1;
		_tmp25_ = _tmp23_[_tmp24__length1 - 1];
		_tmp21_ = _tmp25_.skip_section;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		gboolean bol = FALSE;
		bol = FALSE;
		while (TRUE) {
			gchar* _tmp26_;
			gchar* _tmp27_;
			gboolean _tmp28_ = FALSE;
			gboolean _tmp29_ = FALSE;
			gchar* _tmp35_;
			gchar _tmp36_;
			gchar* _tmp40_;
			gint _tmp41_;
			_tmp26_ = self->priv->current;
			_tmp27_ = self->priv->end;
			if (!(_tmp26_ < _tmp27_)) {
				break;
			}
			if (bol) {
				gchar* _tmp30_;
				gchar* _tmp31_;
				_tmp30_ = self->priv->current;
				_tmp31_ = self->priv->end;
				_tmp29_ = _tmp30_ < _tmp31_;
			} else {
				_tmp29_ = FALSE;
			}
			if (_tmp29_) {
				gchar* _tmp32_;
				gchar _tmp33_;
				_tmp32_ = self->priv->current;
				_tmp33_ = _tmp32_[0];
				_tmp28_ = _tmp33_ == '#';
			} else {
				_tmp28_ = FALSE;
			}
			if (_tmp28_) {
				gchar* _tmp34_;
				_tmp34_ = self->priv->current;
				self->priv->current = _tmp34_ - (self->priv->column - 1);
				self->priv->column = 1;
				return;
			}
			_tmp35_ = self->priv->current;
			_tmp36_ = _tmp35_[0];
			if (_tmp36_ == '\n') {
				gint _tmp37_;
				_tmp37_ = self->priv->line;
				self->priv->line = _tmp37_ + 1;
				self->priv->column = 0;
				bol = TRUE;
			} else {
				gchar* _tmp38_;
				gchar _tmp39_;
				_tmp38_ = self->priv->current;
				_tmp39_ = _tmp38_[0];
				if (!g_ascii_isspace (_tmp39_)) {
					bol = FALSE;
				}
			}
			_tmp40_ = self->priv->current;
			self->priv->current = _tmp40_ + 1;
			_tmp41_ = self->priv->column;
			self->priv->column = _tmp41_ + 1;
		}
	}
}

static void
vala_genie_scanner_pp_eol (ValaGenieScanner* self)
{
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	vala_genie_scanner_pp_space (self);
	_tmp1_ = self->priv->current;
	_tmp2_ = self->priv->end;
	if (_tmp1_ >= _tmp2_) {
		_tmp0_ = TRUE;
	} else {
		gchar* _tmp3_;
		gchar _tmp4_;
		_tmp3_ = self->priv->current;
		_tmp4_ = _tmp3_[0];
		_tmp0_ = _tmp4_ != '\n';
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp5_;
		ValaSourceReference* _tmp6_;
		_tmp5_ = vala_genie_scanner_get_source_reference (self, 0, 0);
		_tmp6_ = _tmp5_;
		vala_report_error (_tmp6_, "syntax error, expected newline");
		_vala_source_reference_unref0 (_tmp6_);
	}
}

static void
_vala_array_add12 (ValaGenieScannerConditional* * array,
                   gint* length,
                   gint* size,
                   const ValaGenieScannerConditional* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerConditional, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
vala_genie_scanner_parse_pp_if (ValaGenieScanner* self)
{
	gboolean condition = FALSE;
	ValaGenieScannerConditional _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	vala_genie_scanner_pp_space (self);
	condition = vala_genie_scanner_parse_pp_expression (self);
	vala_genie_scanner_pp_eol (self);
	memset (&_tmp0_, 0, sizeof (ValaGenieScannerConditional));
	_vala_array_add12 (&self->priv->conditional_stack, &self->priv->conditional_stack_length1, &self->priv->_conditional_stack_size_, &_tmp0_);
	if (condition) {
		gboolean _tmp2_ = FALSE;
		ValaGenieScannerConditional* _tmp3_;
		gint _tmp3__length1;
		_tmp3_ = self->priv->conditional_stack;
		_tmp3__length1 = self->priv->conditional_stack_length1;
		if (_tmp3__length1 == 1) {
			_tmp2_ = TRUE;
		} else {
			ValaGenieScannerConditional* _tmp4_;
			gint _tmp4__length1;
			ValaGenieScannerConditional* _tmp5_;
			gint _tmp5__length1;
			ValaGenieScannerConditional _tmp6_;
			_tmp4_ = self->priv->conditional_stack;
			_tmp4__length1 = self->priv->conditional_stack_length1;
			_tmp5_ = self->priv->conditional_stack;
			_tmp5__length1 = self->priv->conditional_stack_length1;
			_tmp6_ = _tmp4_[_tmp5__length1 - 2];
			_tmp2_ = !_tmp6_.skip_section;
		}
		_tmp1_ = _tmp2_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ValaGenieScannerConditional* _tmp7_;
		gint _tmp7__length1;
		ValaGenieScannerConditional* _tmp8_;
		gint _tmp8__length1;
		_tmp7_ = self->priv->conditional_stack;
		_tmp7__length1 = self->priv->conditional_stack_length1;
		_tmp8_ = self->priv->conditional_stack;
		_tmp8__length1 = self->priv->conditional_stack_length1;
		_tmp7_[_tmp8__length1 - 1].matched = TRUE;
	} else {
		ValaGenieScannerConditional* _tmp9_;
		gint _tmp9__length1;
		ValaGenieScannerConditional* _tmp10_;
		gint _tmp10__length1;
		_tmp9_ = self->priv->conditional_stack;
		_tmp9__length1 = self->priv->conditional_stack_length1;
		_tmp10_ = self->priv->conditional_stack;
		_tmp10__length1 = self->priv->conditional_stack_length1;
		_tmp9_[_tmp10__length1 - 1].skip_section = TRUE;
	}
}

static void
vala_genie_scanner_parse_pp_elif (ValaGenieScanner* self)
{
	gboolean condition = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaGenieScannerConditional* _tmp1_;
	gint _tmp1__length1;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	g_return_if_fail (self != NULL);
	vala_genie_scanner_pp_space (self);
	condition = vala_genie_scanner_parse_pp_expression (self);
	vala_genie_scanner_pp_eol (self);
	_tmp1_ = self->priv->conditional_stack;
	_tmp1__length1 = self->priv->conditional_stack_length1;
	if (_tmp1__length1 == 0) {
		_tmp0_ = TRUE;
	} else {
		ValaGenieScannerConditional* _tmp2_;
		gint _tmp2__length1;
		ValaGenieScannerConditional* _tmp3_;
		gint _tmp3__length1;
		ValaGenieScannerConditional _tmp4_;
		_tmp2_ = self->priv->conditional_stack;
		_tmp2__length1 = self->priv->conditional_stack_length1;
		_tmp3_ = self->priv->conditional_stack;
		_tmp3__length1 = self->priv->conditional_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_.else_found;
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp5_;
		ValaSourceReference* _tmp6_;
		_tmp5_ = vala_genie_scanner_get_source_reference (self, 0, 0);
		_tmp6_ = _tmp5_;
		vala_report_error (_tmp6_, "syntax error, unexpected #elif");
		_vala_source_reference_unref0 (_tmp6_);
		return;
	}
	if (condition) {
		ValaGenieScannerConditional* _tmp9_;
		gint _tmp9__length1;
		ValaGenieScannerConditional* _tmp10_;
		gint _tmp10__length1;
		ValaGenieScannerConditional _tmp11_;
		_tmp9_ = self->priv->conditional_stack;
		_tmp9__length1 = self->priv->conditional_stack_length1;
		_tmp10_ = self->priv->conditional_stack;
		_tmp10__length1 = self->priv->conditional_stack_length1;
		_tmp11_ = _tmp9_[_tmp10__length1 - 1];
		_tmp8_ = !_tmp11_.matched;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		gboolean _tmp12_ = FALSE;
		ValaGenieScannerConditional* _tmp13_;
		gint _tmp13__length1;
		_tmp13_ = self->priv->conditional_stack;
		_tmp13__length1 = self->priv->conditional_stack_length1;
		if (_tmp13__length1 == 1) {
			_tmp12_ = TRUE;
		} else {
			ValaGenieScannerConditional* _tmp14_;
			gint _tmp14__length1;
			ValaGenieScannerConditional* _tmp15_;
			gint _tmp15__length1;
			ValaGenieScannerConditional _tmp16_;
			_tmp14_ = self->priv->conditional_stack;
			_tmp14__length1 = self->priv->conditional_stack_length1;
			_tmp15_ = self->priv->conditional_stack;
			_tmp15__length1 = self->priv->conditional_stack_length1;
			_tmp16_ = _tmp14_[_tmp15__length1 - 2];
			_tmp12_ = !_tmp16_.skip_section;
		}
		_tmp7_ = _tmp12_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		ValaGenieScannerConditional* _tmp17_;
		gint _tmp17__length1;
		ValaGenieScannerConditional* _tmp18_;
		gint _tmp18__length1;
		ValaGenieScannerConditional* _tmp19_;
		gint _tmp19__length1;
		ValaGenieScannerConditional* _tmp20_;
		gint _tmp20__length1;
		_tmp17_ = self->priv->conditional_stack;
		_tmp17__length1 = self->priv->conditional_stack_length1;
		_tmp18_ = self->priv->conditional_stack;
		_tmp18__length1 = self->priv->conditional_stack_length1;
		_tmp17_[_tmp18__length1 - 1].matched = TRUE;
		_tmp19_ = self->priv->conditional_stack;
		_tmp19__length1 = self->priv->conditional_stack_length1;
		_tmp20_ = self->priv->conditional_stack;
		_tmp20__length1 = self->priv->conditional_stack_length1;
		_tmp19_[_tmp20__length1 - 1].skip_section = FALSE;
	} else {
		ValaGenieScannerConditional* _tmp21_;
		gint _tmp21__length1;
		ValaGenieScannerConditional* _tmp22_;
		gint _tmp22__length1;
		_tmp21_ = self->priv->conditional_stack;
		_tmp21__length1 = self->priv->conditional_stack_length1;
		_tmp22_ = self->priv->conditional_stack;
		_tmp22__length1 = self->priv->conditional_stack_length1;
		_tmp21_[_tmp22__length1 - 1].skip_section = TRUE;
	}
}

static void
vala_genie_scanner_parse_pp_else (ValaGenieScanner* self)
{
	gboolean _tmp0_ = FALSE;
	ValaGenieScannerConditional* _tmp1_;
	gint _tmp1__length1;
	gboolean _tmp7_ = FALSE;
	ValaGenieScannerConditional* _tmp8_;
	gint _tmp8__length1;
	ValaGenieScannerConditional* _tmp9_;
	gint _tmp9__length1;
	ValaGenieScannerConditional _tmp10_;
	g_return_if_fail (self != NULL);
	vala_genie_scanner_pp_eol (self);
	_tmp1_ = self->priv->conditional_stack;
	_tmp1__length1 = self->priv->conditional_stack_length1;
	if (_tmp1__length1 == 0) {
		_tmp0_ = TRUE;
	} else {
		ValaGenieScannerConditional* _tmp2_;
		gint _tmp2__length1;
		ValaGenieScannerConditional* _tmp3_;
		gint _tmp3__length1;
		ValaGenieScannerConditional _tmp4_;
		_tmp2_ = self->priv->conditional_stack;
		_tmp2__length1 = self->priv->conditional_stack_length1;
		_tmp3_ = self->priv->conditional_stack;
		_tmp3__length1 = self->priv->conditional_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_.else_found;
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp5_;
		ValaSourceReference* _tmp6_;
		_tmp5_ = vala_genie_scanner_get_source_reference (self, 0, 0);
		_tmp6_ = _tmp5_;
		vala_report_error (_tmp6_, "syntax error, unexpected #else");
		_vala_source_reference_unref0 (_tmp6_);
		return;
	}
	_tmp8_ = self->priv->conditional_stack;
	_tmp8__length1 = self->priv->conditional_stack_length1;
	_tmp9_ = self->priv->conditional_stack;
	_tmp9__length1 = self->priv->conditional_stack_length1;
	_tmp10_ = _tmp8_[_tmp9__length1 - 1];
	if (!_tmp10_.matched) {
		gboolean _tmp11_ = FALSE;
		ValaGenieScannerConditional* _tmp12_;
		gint _tmp12__length1;
		_tmp12_ = self->priv->conditional_stack;
		_tmp12__length1 = self->priv->conditional_stack_length1;
		if (_tmp12__length1 == 1) {
			_tmp11_ = TRUE;
		} else {
			ValaGenieScannerConditional* _tmp13_;
			gint _tmp13__length1;
			ValaGenieScannerConditional* _tmp14_;
			gint _tmp14__length1;
			ValaGenieScannerConditional _tmp15_;
			_tmp13_ = self->priv->conditional_stack;
			_tmp13__length1 = self->priv->conditional_stack_length1;
			_tmp14_ = self->priv->conditional_stack;
			_tmp14__length1 = self->priv->conditional_stack_length1;
			_tmp15_ = _tmp13_[_tmp14__length1 - 2];
			_tmp11_ = !_tmp15_.skip_section;
		}
		_tmp7_ = _tmp11_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		ValaGenieScannerConditional* _tmp16_;
		gint _tmp16__length1;
		ValaGenieScannerConditional* _tmp17_;
		gint _tmp17__length1;
		ValaGenieScannerConditional* _tmp18_;
		gint _tmp18__length1;
		ValaGenieScannerConditional* _tmp19_;
		gint _tmp19__length1;
		_tmp16_ = self->priv->conditional_stack;
		_tmp16__length1 = self->priv->conditional_stack_length1;
		_tmp17_ = self->priv->conditional_stack;
		_tmp17__length1 = self->priv->conditional_stack_length1;
		_tmp16_[_tmp17__length1 - 1].matched = TRUE;
		_tmp18_ = self->priv->conditional_stack;
		_tmp18__length1 = self->priv->conditional_stack_length1;
		_tmp19_ = self->priv->conditional_stack;
		_tmp19__length1 = self->priv->conditional_stack_length1;
		_tmp18_[_tmp19__length1 - 1].skip_section = FALSE;
	} else {
		ValaGenieScannerConditional* _tmp20_;
		gint _tmp20__length1;
		ValaGenieScannerConditional* _tmp21_;
		gint _tmp21__length1;
		_tmp20_ = self->priv->conditional_stack;
		_tmp20__length1 = self->priv->conditional_stack_length1;
		_tmp21_ = self->priv->conditional_stack;
		_tmp21__length1 = self->priv->conditional_stack_length1;
		_tmp20_[_tmp21__length1 - 1].skip_section = TRUE;
	}
}

static void
vala_genie_scanner_parse_pp_endif (ValaGenieScanner* self)
{
	ValaGenieScannerConditional* _tmp0_;
	gint _tmp0__length1;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	vala_genie_scanner_pp_eol (self);
	_tmp0_ = self->priv->conditional_stack;
	_tmp0__length1 = self->priv->conditional_stack_length1;
	if (_tmp0__length1 == 0) {
		ValaSourceReference* _tmp1_;
		ValaSourceReference* _tmp2_;
		_tmp1_ = vala_genie_scanner_get_source_reference (self, 0, 0);
		_tmp2_ = _tmp1_;
		vala_report_error (_tmp2_, "syntax error, unexpected #endif");
		_vala_source_reference_unref0 (_tmp2_);
		return;
	}
	_tmp3_ = self->priv->conditional_stack_length1;
	self->priv->conditional_stack_length1 = _tmp3_ - 1;
}

static gboolean
vala_genie_scanner_parse_pp_symbol (ValaGenieScanner* self)
{
	gint len = 0;
	gchar* identifier = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gboolean defined = FALSE;
	const gchar* _tmp12_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	len = 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp1_ = self->priv->current;
		_tmp2_ = self->priv->end;
		if (_tmp1_ < _tmp2_) {
			gchar* _tmp3_;
			gchar _tmp4_;
			_tmp3_ = self->priv->current;
			_tmp4_ = _tmp3_[0];
			_tmp0_ = vala_genie_scanner_is_ident_char (self, _tmp4_);
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp5_ = self->priv->current;
		self->priv->current = _tmp5_ + 1;
		_tmp6_ = self->priv->column;
		self->priv->column = _tmp6_ + 1;
		_tmp7_ = len;
		len = _tmp7_ + 1;
	}
	if (len == 0) {
		ValaSourceReference* _tmp8_;
		ValaSourceReference* _tmp9_;
		_tmp8_ = vala_genie_scanner_get_source_reference (self, 0, 0);
		_tmp9_ = _tmp8_;
		vala_report_error (_tmp9_, "syntax error, expected identifier");
		_vala_source_reference_unref0 (_tmp9_);
		result = FALSE;
		return result;
	}
	_tmp10_ = self->priv->current;
	_tmp11_ = string_substring ((const gchar*) (_tmp10_ - len), (glong) 0, (glong) len);
	identifier = _tmp11_;
	_tmp12_ = identifier;
	if (g_strcmp0 (_tmp12_, "true") == 0) {
		defined = TRUE;
	} else {
		const gchar* _tmp13_;
		_tmp13_ = identifier;
		if (g_strcmp0 (_tmp13_, "false") == 0) {
			defined = FALSE;
		} else {
			ValaSourceFile* _tmp14_;
			ValaCodeContext* _tmp15_;
			ValaCodeContext* _tmp16_;
			const gchar* _tmp17_;
			_tmp14_ = self->priv->_source_file;
			_tmp15_ = vala_source_file_get_context (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = identifier;
			defined = vala_code_context_is_defined (_tmp16_, _tmp17_);
		}
	}
	result = defined;
	_g_free0 (identifier);
	return result;
}

static gboolean
vala_genie_scanner_parse_pp_primary_expression (ValaGenieScanner* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->current;
	_tmp1_ = self->priv->end;
	if (_tmp0_ >= _tmp1_) {
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		_tmp2_ = vala_genie_scanner_get_source_reference (self, 0, 0);
		_tmp3_ = _tmp2_;
		vala_report_error (_tmp3_, "syntax error, expected identifier");
		_vala_source_reference_unref0 (_tmp3_);
	} else {
		gchar* _tmp4_;
		gchar _tmp5_;
		_tmp4_ = self->priv->current;
		_tmp5_ = _tmp4_[0];
		if (vala_genie_scanner_is_ident_char (self, _tmp5_)) {
			result = vala_genie_scanner_parse_pp_symbol (self);
			return result;
		} else {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[0];
			if (_tmp7_ == '(') {
				gchar* _tmp8_;
				gint _tmp9_;
				gboolean _result_ = FALSE;
				gboolean _tmp10_ = FALSE;
				gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp8_ = self->priv->current;
				self->priv->current = _tmp8_ + 1;
				_tmp9_ = self->priv->column;
				self->priv->column = _tmp9_ + 1;
				vala_genie_scanner_pp_space (self);
				_result_ = vala_genie_scanner_parse_pp_expression (self);
				vala_genie_scanner_pp_space (self);
				_tmp11_ = self->priv->current;
				_tmp12_ = self->priv->end;
				if (_tmp11_ < _tmp12_) {
					gchar* _tmp13_;
					gchar _tmp14_;
					_tmp13_ = self->priv->current;
					_tmp14_ = _tmp13_[0];
					_tmp10_ = _tmp14_ == ')';
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					gchar* _tmp15_;
					gint _tmp16_;
					_tmp15_ = self->priv->current;
					self->priv->current = _tmp15_ + 1;
					_tmp16_ = self->priv->column;
					self->priv->column = _tmp16_ + 1;
				} else {
					ValaSourceReference* _tmp17_;
					ValaSourceReference* _tmp18_;
					_tmp17_ = vala_genie_scanner_get_source_reference (self, 0, 0);
					_tmp18_ = _tmp17_;
					vala_report_error (_tmp18_, "syntax error, expected `)'");
					_vala_source_reference_unref0 (_tmp18_);
				}
				result = _result_;
				return result;
			} else {
				ValaSourceReference* _tmp19_;
				ValaSourceReference* _tmp20_;
				_tmp19_ = vala_genie_scanner_get_source_reference (self, 0, 0);
				_tmp20_ = _tmp19_;
				vala_report_error (_tmp20_, "syntax error, expected identifier");
				_vala_source_reference_unref0 (_tmp20_);
			}
		}
	}
	result = FALSE;
	return result;
}

static gboolean
vala_genie_scanner_parse_pp_unary_expression (ValaGenieScanner* self)
{
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->current;
	_tmp2_ = self->priv->end;
	if (_tmp1_ < _tmp2_) {
		gchar* _tmp3_;
		gchar _tmp4_;
		_tmp3_ = self->priv->current;
		_tmp4_ = _tmp3_[0];
		_tmp0_ = _tmp4_ == '!';
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		gint _tmp6_;
		_tmp5_ = self->priv->current;
		self->priv->current = _tmp5_ + 1;
		_tmp6_ = self->priv->column;
		self->priv->column = _tmp6_ + 1;
		vala_genie_scanner_pp_space (self);
		result = !vala_genie_scanner_parse_pp_unary_expression (self);
		return result;
	}
	result = vala_genie_scanner_parse_pp_primary_expression (self);
	return result;
}

static gboolean
vala_genie_scanner_parse_pp_equality_expression (ValaGenieScanner* self)
{
	gboolean left = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	left = vala_genie_scanner_parse_pp_unary_expression (self);
	vala_genie_scanner_pp_space (self);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->end;
		if (_tmp2_ < (_tmp3_ - 1)) {
			gchar* _tmp4_;
			gchar _tmp5_;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_[0];
			_tmp1_ = _tmp5_ == '=';
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[1];
			_tmp0_ = _tmp7_ == '=';
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			gchar* _tmp8_;
			gboolean right = FALSE;
			_tmp8_ = self->priv->current;
			self->priv->current = _tmp8_ + 2;
			self->priv->column = self->priv->column + 2;
			vala_genie_scanner_pp_space (self);
			right = vala_genie_scanner_parse_pp_unary_expression (self);
			left = left == right;
		} else {
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_ = FALSE;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp11_ = self->priv->current;
			_tmp12_ = self->priv->end;
			if (_tmp11_ < (_tmp12_ - 1)) {
				gchar* _tmp13_;
				gchar _tmp14_;
				_tmp13_ = self->priv->current;
				_tmp14_ = _tmp13_[0];
				_tmp10_ = _tmp14_ == '!';
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				gchar* _tmp15_;
				gchar _tmp16_;
				_tmp15_ = self->priv->current;
				_tmp16_ = _tmp15_[1];
				_tmp9_ = _tmp16_ == '=';
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				gchar* _tmp17_;
				gboolean right = FALSE;
				_tmp17_ = self->priv->current;
				self->priv->current = _tmp17_ + 2;
				self->priv->column = self->priv->column + 2;
				vala_genie_scanner_pp_space (self);
				right = vala_genie_scanner_parse_pp_unary_expression (self);
				left = left != right;
			} else {
				break;
			}
		}
	}
	result = left;
	return result;
}

static gboolean
vala_genie_scanner_parse_pp_and_expression (ValaGenieScanner* self)
{
	gboolean left = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	left = vala_genie_scanner_parse_pp_equality_expression (self);
	vala_genie_scanner_pp_space (self);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp8_;
		gboolean right = FALSE;
		gboolean _tmp9_ = FALSE;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->end;
		if (_tmp2_ < (_tmp3_ - 1)) {
			gchar* _tmp4_;
			gchar _tmp5_;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_[0];
			_tmp1_ = _tmp5_ == '&';
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[1];
			_tmp0_ = _tmp7_ == '&';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp8_ = self->priv->current;
		self->priv->current = _tmp8_ + 2;
		self->priv->column = self->priv->column + 2;
		vala_genie_scanner_pp_space (self);
		right = vala_genie_scanner_parse_pp_equality_expression (self);
		if (left) {
			_tmp9_ = right;
		} else {
			_tmp9_ = FALSE;
		}
		left = _tmp9_;
	}
	result = left;
	return result;
}

static gboolean
vala_genie_scanner_parse_pp_or_expression (ValaGenieScanner* self)
{
	gboolean left = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	left = vala_genie_scanner_parse_pp_and_expression (self);
	vala_genie_scanner_pp_space (self);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp8_;
		gboolean right = FALSE;
		gboolean _tmp9_ = FALSE;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->end;
		if (_tmp2_ < (_tmp3_ - 1)) {
			gchar* _tmp4_;
			gchar _tmp5_;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_[0];
			_tmp1_ = _tmp5_ == '|';
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[1];
			_tmp0_ = _tmp7_ == '|';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp8_ = self->priv->current;
		self->priv->current = _tmp8_ + 2;
		self->priv->column = self->priv->column + 2;
		vala_genie_scanner_pp_space (self);
		right = vala_genie_scanner_parse_pp_and_expression (self);
		if (left) {
			_tmp9_ = TRUE;
		} else {
			_tmp9_ = right;
		}
		left = _tmp9_;
	}
	result = left;
	return result;
}

static gboolean
vala_genie_scanner_parse_pp_expression (ValaGenieScanner* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_genie_scanner_parse_pp_or_expression (self);
	return result;
}

static ValaGenieScannerConditional*
vala_genie_scanner_conditional_dup (const ValaGenieScannerConditional* self)
{
	ValaGenieScannerConditional* dup;
	dup = g_new0 (ValaGenieScannerConditional, 1);
	memcpy (dup, self, sizeof (ValaGenieScannerConditional));
	return dup;
}

static void
vala_genie_scanner_conditional_free (ValaGenieScannerConditional* self)
{
	g_free (self);
}

static GType
vala_genie_scanner_conditional_get_type_once (void)
{
	GType vala_genie_scanner_conditional_type_id;
	vala_genie_scanner_conditional_type_id = g_boxed_type_register_static ("ValaGenieScannerConditional", (GBoxedCopyFunc) vala_genie_scanner_conditional_dup, (GBoxedFreeFunc) vala_genie_scanner_conditional_free);
	return vala_genie_scanner_conditional_type_id;
}

static GType
vala_genie_scanner_conditional_get_type (void)
{
	static volatile gsize vala_genie_scanner_conditional_type_id__volatile = 0;
	if (g_once_init_enter (&vala_genie_scanner_conditional_type_id__volatile)) {
		GType vala_genie_scanner_conditional_type_id;
		vala_genie_scanner_conditional_type_id = vala_genie_scanner_conditional_get_type_once ();
		g_once_init_leave (&vala_genie_scanner_conditional_type_id__volatile, vala_genie_scanner_conditional_type_id);
	}
	return vala_genie_scanner_conditional_type_id__volatile;
}

static void
vala_genie_value_scanner_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_genie_value_scanner_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_genie_scanner_unref (value->data[0].v_pointer);
	}
}

static void
vala_genie_value_scanner_copy_value (const GValue* src_value,
                                     GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_genie_scanner_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_genie_value_scanner_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_genie_value_scanner_collect_value (GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaGenieScanner * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_genie_scanner_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_genie_value_scanner_lcopy_value (const GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	ValaGenieScanner ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_genie_scanner_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
vala_genie_param_spec_scanner (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags)
{
	ValaGenieParamSpecScanner* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_GENIE_TYPE_SCANNER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
vala_genie_value_get_scanner (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GENIE_TYPE_SCANNER), NULL);
	return value->data[0].v_pointer;
}

void
vala_genie_value_set_scanner (GValue* value,
                              gpointer v_object)
{
	ValaGenieScanner * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GENIE_TYPE_SCANNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GENIE_TYPE_SCANNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_genie_scanner_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_genie_scanner_unref (old);
	}
}

void
vala_genie_value_take_scanner (GValue* value,
                               gpointer v_object)
{
	ValaGenieScanner * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GENIE_TYPE_SCANNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GENIE_TYPE_SCANNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_genie_scanner_unref (old);
	}
}

static void
vala_genie_scanner_class_init (ValaGenieScannerClass * klass,
                               gpointer klass_data)
{
	vala_genie_scanner_parent_class = g_type_class_peek_parent (klass);
	((ValaGenieScannerClass *) klass)->finalize = vala_genie_scanner_finalize;
	g_type_class_adjust_private_offset (klass, &ValaGenieScanner_private_offset);
}

static void
vala_genie_scanner_instance_init (ValaGenieScanner * self,
                                  gpointer klass)
{
	self->priv = vala_genie_scanner_get_instance_private (self);
	self->ref_count = 1;
}

static void
vala_genie_scanner_finalize (ValaGenieScanner * obj)
{
	ValaGenieScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_GENIE_TYPE_SCANNER, ValaGenieScanner);
	g_signal_handlers_destroy (self);
	_vala_source_file_unref0 (self->priv->_source_file);
	_vala_comment_unref0 (self->priv->_comment);
	self->priv->conditional_stack = (g_free (self->priv->conditional_stack), NULL);
	self->priv->state_stack = (g_free (self->priv->state_stack), NULL);
}

/**
 * Lexical scanner for Genie source files.
 */
static GType
vala_genie_scanner_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { vala_genie_value_scanner_init, vala_genie_value_scanner_free_value, vala_genie_value_scanner_copy_value, vala_genie_value_scanner_peek_pointer, "p", vala_genie_value_scanner_collect_value, "p", vala_genie_value_scanner_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValaGenieScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_genie_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGenieScanner), 0, (GInstanceInitFunc) vala_genie_scanner_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType vala_genie_scanner_type_id;
	vala_genie_scanner_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGenieScanner", &g_define_type_info, &g_define_type_fundamental_info, 0);
	ValaGenieScanner_private_offset = g_type_add_instance_private (vala_genie_scanner_type_id, sizeof (ValaGenieScannerPrivate));
	return vala_genie_scanner_type_id;
}

GType
vala_genie_scanner_get_type (void)
{
	static volatile gsize vala_genie_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&vala_genie_scanner_type_id__volatile)) {
		GType vala_genie_scanner_type_id;
		vala_genie_scanner_type_id = vala_genie_scanner_get_type_once ();
		g_once_init_leave (&vala_genie_scanner_type_id__volatile, vala_genie_scanner_type_id);
	}
	return vala_genie_scanner_type_id__volatile;
}

gpointer
vala_genie_scanner_ref (gpointer instance)
{
	ValaGenieScanner * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
vala_genie_scanner_unref (gpointer instance)
{
	ValaGenieScanner * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GENIE_SCANNER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

