/* valaccodeinvocationexpressionmodule.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#ifndef __GOBJECT_VALACCODEINVOCATIONEXPRESSIONMODULE_H__
#define __GOBJECT_VALACCODEINVOCATIONEXPRESSIONMODULE_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valainvocationexpression.h>
#include <gobject/valaccodeassignmentmodule.h>
#include <gobject/valaccodegenerator.h>
#include <gobject/valaccodemodule.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_INVOCATION_EXPRESSION_MODULE (vala_ccode_invocation_expression_module_get_type ())
#define VALA_CCODE_INVOCATION_EXPRESSION_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_INVOCATION_EXPRESSION_MODULE, ValaCCodeInvocationExpressionModule))
#define VALA_CCODE_INVOCATION_EXPRESSION_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_INVOCATION_EXPRESSION_MODULE, ValaCCodeInvocationExpressionModuleClass))
#define VALA_IS_CCODE_INVOCATION_EXPRESSION_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_INVOCATION_EXPRESSION_MODULE))
#define VALA_IS_CCODE_INVOCATION_EXPRESSION_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_INVOCATION_EXPRESSION_MODULE))
#define VALA_CCODE_INVOCATION_EXPRESSION_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_INVOCATION_EXPRESSION_MODULE, ValaCCodeInvocationExpressionModuleClass))

typedef struct _ValaCCodeInvocationExpressionModule ValaCCodeInvocationExpressionModule;
typedef struct _ValaCCodeInvocationExpressionModuleClass ValaCCodeInvocationExpressionModuleClass;
typedef struct _ValaCCodeInvocationExpressionModulePrivate ValaCCodeInvocationExpressionModulePrivate;

struct _ValaCCodeInvocationExpressionModule {
	ValaCCodeAssignmentModule parent_instance;
	ValaCCodeInvocationExpressionModulePrivate * priv;
};

struct _ValaCCodeInvocationExpressionModuleClass {
	ValaCCodeAssignmentModuleClass parent_class;
};


ValaCCodeInvocationExpressionModule* vala_ccode_invocation_expression_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeInvocationExpressionModule* vala_ccode_invocation_expression_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
GType vala_ccode_invocation_expression_module_get_type (void);


G_END_DECLS

#endif
