/* valaccodedelegatemodule.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodedelegatemodule.h>
#include <vala/valacodenode.h>
#include <vala/valacodevisitor.h>
#include <ccode/valaccodefunctiondeclarator.h>
#include <vala/valatypesymbol.h>
#include <vala/valaformalparameter.h>
#include <ccode/valaccodeformalparameter.h>
#include <vala/valaarraytype.h>
#include <vala/valasymbol.h>
#include <ccode/valaccodetypedefinition.h>
#include <vala/valadatatype.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodefragment.h>
#include <ccode/valaccodenode.h>
#include <vala/valaunaryexpression.h>
#include <vala/valainvocationexpression.h>
#include <vala/valalambdaexpression.h>
#include <vala/valamethod.h>
#include <vala/valamember.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodeparenthesizedexpression.h>
#include <ccode/valaccodeunaryexpression.h>
#include <vala/valalocalvariable.h>
#include <vala/valafield.h>
#include <vala/valamemberaccess.h>
#include <ccode/valaccodememberaccess.h>
#include <gobject/valaccodebasemodule.h>




enum  {
	VALA_CCODE_DELEGATE_MODULE_DUMMY_PROPERTY
};
static void vala_ccode_delegate_module_real_visit_delegate (ValaCCodeModule* base, ValaDelegate* d);
static char* vala_ccode_delegate_module_real_get_delegate_target_cname (ValaCCodeBaseModule* base, const char* delegate_cname);
static ValaCCodeExpression* vala_ccode_delegate_module_real_get_delegate_target_cexpression (ValaCCodeBaseModule* base, ValaExpression* delegate_expr);
static char* vala_ccode_delegate_module_real_get_delegate_target_destroy_notify_cname (ValaCCodeBaseModule* base, const char* delegate_cname);
static gpointer vala_ccode_delegate_module_parent_class = NULL;



ValaCCodeDelegateModule* vala_ccode_delegate_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeDelegateModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = ((ValaCCodeDelegateModule*) (g_type_create_instance (object_type)));
	self = ((ValaCCodeDelegateModule*) (vala_ccode_array_module_construct (object_type, codegen, next)));
	return self;
}


ValaCCodeDelegateModule* vala_ccode_delegate_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_delegate_module_construct (VALA_TYPE_CCODE_DELEGATE_MODULE, codegen, next);
}


static void vala_ccode_delegate_module_real_visit_delegate (ValaCCodeModule* base, ValaDelegate* d) {
	ValaCCodeDelegateModule * self;
	char* _tmp0;
	ValaCCodeFunctionDeclarator* _tmp1;
	ValaCCodeFunctionDeclarator* cfundecl;
	char* _tmp6;
	ValaCCodeTypeDefinition* _tmp7;
	ValaCCodeTypeDefinition* ctypedef;
	self = ((ValaCCodeDelegateModule*) (base));
	g_return_if_fail (d != NULL);
	vala_code_node_accept_children (((ValaCodeNode*) (d)), ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
	_tmp0 = NULL;
	_tmp1 = NULL;
	cfundecl = (_tmp1 = vala_ccode_function_declarator_new ((_tmp0 = vala_typesymbol_get_cname (((ValaTypeSymbol*) (d)), FALSE))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
	{
		GeeList* param_collection;
		int param_it;
		param_collection = vala_delegate_get_parameters (d);
		for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
			{
				vala_ccode_function_declarator_add_parameter (cfundecl, VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (((ValaCodeNode*) (param)))));
				/* handle array parameters*/
				if (!vala_formal_parameter_get_no_array_length (param) && VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))) {
					ValaArrayType* _tmp2;
					ValaArrayType* array_type;
					char* length_ctype;
					_tmp2 = NULL;
					array_type = (_tmp2 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp2 == NULL ? NULL : vala_code_node_ref (_tmp2)));
					length_ctype = g_strdup ("int");
					if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
						char* _tmp3;
						_tmp3 = NULL;
						length_ctype = (_tmp3 = g_strdup ("int*"), (length_ctype = (g_free (length_ctype), NULL)), _tmp3);
					}
					{
						gint dim;
						dim = 1;
						for (; dim <= vala_array_type_get_rank (array_type); dim++) {
							char* _tmp4;
							ValaCCodeFormalParameter* _tmp5;
							ValaCCodeFormalParameter* cparam;
							_tmp4 = NULL;
							_tmp5 = NULL;
							cparam = (_tmp5 = vala_ccode_formal_parameter_new ((_tmp4 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), vala_symbol_get_name (((ValaSymbol*) (param))), dim)), length_ctype), (_tmp4 = (g_free (_tmp4), NULL)), _tmp5);
							vala_ccode_function_declarator_add_parameter (cfundecl, cparam);
							(cparam == NULL ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL)));
						}
					}
					(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
					length_ctype = (g_free (length_ctype), NULL);
				}
				(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (gee_collection_object_unref (param_collection), NULL)));
	}
	if (vala_delegate_get_has_target (d)) {
		ValaCCodeFormalParameter* cparam;
		cparam = vala_ccode_formal_parameter_new ("user_data", "void*");
		vala_ccode_function_declarator_add_parameter (cfundecl, cparam);
		(cparam == NULL ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL)));
	}
	_tmp6 = NULL;
	_tmp7 = NULL;
	ctypedef = (_tmp7 = vala_ccode_type_definition_new ((_tmp6 = vala_data_type_get_cname (vala_delegate_get_return_type (d))), ((ValaCCodeDeclarator*) (cfundecl))), (_tmp6 = (g_free (_tmp6), NULL)), _tmp7);
	if (!vala_symbol_is_internal_symbol (((ValaSymbol*) (d)))) {
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->header_type_declaration, ((ValaCCodeNode*) (ctypedef)));
	} else {
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) (self))->source_type_declaration, ((ValaCCodeNode*) (ctypedef)));
	}
	(cfundecl == NULL ? NULL : (cfundecl = (vala_ccode_node_unref (cfundecl), NULL)));
	(ctypedef == NULL ? NULL : (ctypedef = (vala_ccode_node_unref (ctypedef), NULL)));
}


static char* vala_ccode_delegate_module_real_get_delegate_target_cname (ValaCCodeBaseModule* base, const char* delegate_cname) {
	ValaCCodeDelegateModule * self;
	self = ((ValaCCodeDelegateModule*) (base));
	g_return_val_if_fail (delegate_cname != NULL, NULL);
	return g_strdup_printf ("%s_target", delegate_cname);
}


static ValaCCodeExpression* vala_ccode_delegate_module_real_get_delegate_target_cexpression (ValaCCodeBaseModule* base, ValaExpression* delegate_expr) {
	ValaCCodeDelegateModule * self;
	gboolean is_out;
	self = ((ValaCCodeDelegateModule*) (base));
	g_return_val_if_fail (delegate_expr != NULL, NULL);
	is_out = FALSE;
	if (VALA_IS_UNARY_EXPRESSION (delegate_expr)) {
		ValaUnaryExpression* _tmp0;
		ValaUnaryExpression* unary_expr;
		_tmp0 = NULL;
		unary_expr = (_tmp0 = VALA_UNARY_EXPRESSION (delegate_expr), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
		if (vala_unary_expression_get_operator (unary_expr) == VALA_UNARY_OPERATOR_OUT || vala_unary_expression_get_operator (unary_expr) == VALA_UNARY_OPERATOR_REF) {
			delegate_expr = vala_unary_expression_get_inner (unary_expr);
			is_out = TRUE;
		}
		(unary_expr == NULL ? NULL : (unary_expr = (vala_code_node_unref (unary_expr), NULL)));
	}
	if (VALA_IS_INVOCATION_EXPRESSION (delegate_expr)) {
		ValaInvocationExpression* _tmp1;
		ValaInvocationExpression* invocation_expr;
		ValaCCodeExpression* _tmp2;
		ValaCCodeExpression* _tmp3;
		_tmp1 = NULL;
		invocation_expr = (_tmp1 = VALA_INVOCATION_EXPRESSION (delegate_expr), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
		_tmp2 = NULL;
		_tmp3 = NULL;
		return (_tmp3 = (_tmp2 = vala_invocation_expression_get_delegate_target (invocation_expr), (_tmp2 == NULL ? NULL : vala_ccode_node_ref (_tmp2))), (invocation_expr == NULL ? NULL : (invocation_expr = (vala_code_node_unref (invocation_expr), NULL))), _tmp3);
	} else {
		if (VALA_IS_LAMBDA_EXPRESSION (delegate_expr)) {
			if ((((ValaCCodeBaseModule*) (self))->current_method != NULL && vala_method_get_binding (((ValaCCodeBaseModule*) (self))->current_method) == MEMBER_BINDING_INSTANCE) || ((ValaCCodeBaseModule*) (self))->in_constructor) {
				return ((ValaCCodeExpression*) (vala_ccode_identifier_new ("self")));
			} else {
				return ((ValaCCodeExpression*) (vala_ccode_constant_new ("NULL")));
			}
		} else {
			if (vala_expression_get_symbol_reference (delegate_expr) != NULL) {
				if (VALA_IS_FORMAL_PARAMETER (vala_expression_get_symbol_reference (delegate_expr))) {
					ValaFormalParameter* _tmp6;
					ValaFormalParameter* param;
					char* _tmp7;
					ValaCCodeExpression* _tmp8;
					ValaCCodeExpression* target_expr;
					_tmp6 = NULL;
					param = (_tmp6 = VALA_FORMAL_PARAMETER (vala_expression_get_symbol_reference (delegate_expr)), (_tmp6 == NULL ? NULL : vala_code_node_ref (_tmp6)));
					_tmp7 = NULL;
					_tmp8 = NULL;
					target_expr = (_tmp8 = ((ValaCCodeExpression*) (vala_ccode_identifier_new ((_tmp7 = vala_ccode_base_module_get_delegate_target_cname (((ValaCCodeBaseModule*) (self)), vala_symbol_get_name (((ValaSymbol*) (param)))))))), (_tmp7 = (g_free (_tmp7), NULL)), _tmp8);
					if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
						ValaCCodeExpression* _tmp10;
						ValaCCodeUnaryExpression* _tmp9;
						/* accessing argument of out/ref param*/
						_tmp10 = NULL;
						_tmp9 = NULL;
						target_expr = (_tmp10 = ((ValaCCodeExpression*) (vala_ccode_parenthesized_expression_new (((ValaCCodeExpression*) ((_tmp9 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, target_expr))))))), (target_expr == NULL ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL))), _tmp10);
						(_tmp9 == NULL ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)));
					}
					if (is_out) {
						ValaCCodeExpression* _tmp11;
						/* passing array as out/ref*/
						_tmp11 = NULL;
						return (_tmp11 = ((ValaCCodeExpression*) (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, target_expr))), (param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL))), (target_expr == NULL ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL))), _tmp11);
					} else {
						ValaCCodeExpression* _tmp12;
						_tmp12 = NULL;
						return (_tmp12 = target_expr, (param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL))), _tmp12);
					}
					(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
					(target_expr == NULL ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL)));
				} else {
					if (VALA_IS_LOCAL_VARIABLE (vala_expression_get_symbol_reference (delegate_expr))) {
						ValaLocalVariable* _tmp13;
						ValaLocalVariable* local;
						char* _tmp14;
						ValaCCodeIdentifier* _tmp15;
						ValaCCodeIdentifier* target_expr;
						_tmp13 = NULL;
						local = (_tmp13 = VALA_LOCAL_VARIABLE (vala_expression_get_symbol_reference (delegate_expr)), (_tmp13 == NULL ? NULL : vala_code_node_ref (_tmp13)));
						_tmp14 = NULL;
						_tmp15 = NULL;
						target_expr = (_tmp15 = vala_ccode_identifier_new ((_tmp14 = vala_ccode_base_module_get_delegate_target_cname (((ValaCCodeBaseModule*) (self)), vala_symbol_get_name (((ValaSymbol*) (local)))))), (_tmp14 = (g_free (_tmp14), NULL)), _tmp15);
						if (is_out) {
							ValaCCodeExpression* _tmp16;
							_tmp16 = NULL;
							return (_tmp16 = ((ValaCCodeExpression*) (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ((ValaCCodeExpression*) (target_expr))))), (local == NULL ? NULL : (local = (vala_code_node_unref (local), NULL))), (target_expr == NULL ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL))), _tmp16);
						} else {
							ValaCCodeExpression* _tmp17;
							_tmp17 = NULL;
							return (_tmp17 = ((ValaCCodeExpression*) (target_expr)), (local == NULL ? NULL : (local = (vala_code_node_unref (local), NULL))), _tmp17);
						}
						(local == NULL ? NULL : (local = (vala_code_node_unref (local), NULL)));
						(target_expr == NULL ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL)));
					} else {
						if (VALA_IS_FIELD (vala_expression_get_symbol_reference (delegate_expr))) {
							ValaField* _tmp18;
							ValaField* field;
							char* target_cname;
							ValaMemberAccess* _tmp19;
							ValaMemberAccess* ma;
							ValaDataType* _tmp20;
							ValaDataType* base_type;
							ValaCCodeExpression* target_expr;
							ValaCCodeExpression* pub_inst;
							_tmp18 = NULL;
							field = (_tmp18 = VALA_FIELD (vala_expression_get_symbol_reference (delegate_expr)), (_tmp18 == NULL ? NULL : vala_code_node_ref (_tmp18)));
							target_cname = vala_ccode_base_module_get_delegate_target_cname (((ValaCCodeBaseModule*) (self)), vala_symbol_get_name (((ValaSymbol*) (field))));
							_tmp19 = NULL;
							ma = (_tmp19 = VALA_MEMBER_ACCESS (delegate_expr), (_tmp19 == NULL ? NULL : vala_code_node_ref (_tmp19)));
							_tmp20 = NULL;
							base_type = (_tmp20 = vala_expression_get_value_type (vala_member_access_get_inner (ma)), (_tmp20 == NULL ? NULL : vala_code_node_ref (_tmp20)));
							target_expr = NULL;
							pub_inst = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode (((ValaCCodeBaseModule*) (self)), ((ValaCodeNode*) (vala_member_access_get_inner (ma)))));
							if (vala_field_get_binding (field) == MEMBER_BINDING_INSTANCE) {
								ValaDataType* _tmp21;
								ValaDataType* instance_expression_type;
								ValaDataType* instance_target_type;
								ValaCCodeExpression* typed_inst;
								ValaCCodeExpression* inst;
								_tmp21 = NULL;
								instance_expression_type = (_tmp21 = base_type, (_tmp21 == NULL ? NULL : vala_code_node_ref (_tmp21)));
								instance_target_type = vala_ccode_base_module_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (((ValaSymbol*) (field)))));
								typed_inst = vala_ccode_base_module_transform_expression (((ValaCCodeBaseModule*) (self)), pub_inst, instance_expression_type, instance_target_type, NULL);
								inst = NULL;
								if (vala_symbol_get_access (((ValaSymbol*) (field))) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
									ValaCCodeExpression* _tmp22;
									_tmp22 = NULL;
									inst = (_tmp22 = ((ValaCCodeExpression*) (vala_ccode_member_access_new_pointer (typed_inst, "priv"))), (inst == NULL ? NULL : (inst = (vala_ccode_node_unref (inst), NULL))), _tmp22);
								} else {
									ValaCCodeExpression* _tmp24;
									ValaCCodeExpression* _tmp23;
									_tmp24 = NULL;
									_tmp23 = NULL;
									inst = (_tmp24 = (_tmp23 = typed_inst, (_tmp23 == NULL ? NULL : vala_ccode_node_ref (_tmp23))), (inst == NULL ? NULL : (inst = (vala_ccode_node_unref (inst), NULL))), _tmp24);
								}
								if (vala_typesymbol_is_reference_type ((VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (((ValaSymbol*) (field))))))) {
									ValaCCodeExpression* _tmp25;
									_tmp25 = NULL;
									target_expr = (_tmp25 = ((ValaCCodeExpression*) (vala_ccode_member_access_new_pointer (inst, target_cname))), (target_expr == NULL ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL))), _tmp25);
								} else {
									ValaCCodeExpression* _tmp26;
									_tmp26 = NULL;
									target_expr = (_tmp26 = ((ValaCCodeExpression*) (vala_ccode_member_access_new (inst, target_cname, FALSE))), (target_expr == NULL ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL))), _tmp26);
								}
								(instance_expression_type == NULL ? NULL : (instance_expression_type = (vala_code_node_unref (instance_expression_type), NULL)));
								(instance_target_type == NULL ? NULL : (instance_target_type = (vala_code_node_unref (instance_target_type), NULL)));
								(typed_inst == NULL ? NULL : (typed_inst = (vala_ccode_node_unref (typed_inst), NULL)));
								(inst == NULL ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)));
							} else {
								ValaCCodeExpression* _tmp27;
								_tmp27 = NULL;
								target_expr = (_tmp27 = ((ValaCCodeExpression*) (vala_ccode_identifier_new (target_cname))), (target_expr == NULL ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL))), _tmp27);
							}
							if (is_out) {
								ValaCCodeExpression* _tmp28;
								_tmp28 = NULL;
								return (_tmp28 = ((ValaCCodeExpression*) (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, target_expr))), (field == NULL ? NULL : (field = (vala_code_node_unref (field), NULL))), (target_cname = (g_free (target_cname), NULL)), (ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL))), (base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL))), (target_expr == NULL ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL))), (pub_inst == NULL ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL))), _tmp28);
							} else {
								ValaCCodeExpression* _tmp29;
								_tmp29 = NULL;
								return (_tmp29 = target_expr, (field == NULL ? NULL : (field = (vala_code_node_unref (field), NULL))), (target_cname = (g_free (target_cname), NULL)), (ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL))), (base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL))), (pub_inst == NULL ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL))), _tmp29);
							}
							(field == NULL ? NULL : (field = (vala_code_node_unref (field), NULL)));
							target_cname = (g_free (target_cname), NULL);
							(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
							(base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)));
							(target_expr == NULL ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL)));
							(pub_inst == NULL ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL)));
						} else {
							if (VALA_IS_METHOD (vala_expression_get_symbol_reference (delegate_expr))) {
								ValaMethod* _tmp30;
								ValaMethod* m;
								ValaMemberAccess* _tmp31;
								ValaMemberAccess* ma;
								_tmp30 = NULL;
								m = (_tmp30 = VALA_METHOD (vala_expression_get_symbol_reference (delegate_expr)), (_tmp30 == NULL ? NULL : vala_code_node_ref (_tmp30)));
								_tmp31 = NULL;
								ma = (_tmp31 = VALA_MEMBER_ACCESS (delegate_expr), (_tmp31 == NULL ? NULL : vala_code_node_ref (_tmp31)));
								if (vala_method_get_binding (m) == MEMBER_BINDING_STATIC) {
									ValaCCodeExpression* _tmp32;
									_tmp32 = NULL;
									return (_tmp32 = ((ValaCCodeExpression*) (vala_ccode_constant_new ("NULL"))), (m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL))), (ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL))), _tmp32);
								} else {
									ValaCCodeExpression* _tmp33;
									_tmp33 = NULL;
									return (_tmp33 = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode (((ValaCCodeBaseModule*) (self)), ((ValaCodeNode*) (vala_member_access_get_inner (ma))))), (m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL))), (ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL))), _tmp33);
								}
								(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
								(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
							}
						}
					}
				}
			}
		}
	}
	return ((ValaCCodeExpression*) (vala_ccode_constant_new ("NULL")));
}


static char* vala_ccode_delegate_module_real_get_delegate_target_destroy_notify_cname (ValaCCodeBaseModule* base, const char* delegate_cname) {
	ValaCCodeDelegateModule * self;
	self = ((ValaCCodeDelegateModule*) (base));
	g_return_val_if_fail (delegate_cname != NULL, NULL);
	return g_strdup_printf ("%s_target_destroy_notify", delegate_cname);
}


static void vala_ccode_delegate_module_class_init (ValaCCodeDelegateModuleClass * klass) {
	vala_ccode_delegate_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->visit_delegate = vala_ccode_delegate_module_real_visit_delegate;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_delegate_target_cname = vala_ccode_delegate_module_real_get_delegate_target_cname;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_delegate_target_cexpression = vala_ccode_delegate_module_real_get_delegate_target_cexpression;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_delegate_target_destroy_notify_cname = vala_ccode_delegate_module_real_get_delegate_target_destroy_notify_cname;
}


static void vala_ccode_delegate_module_instance_init (ValaCCodeDelegateModule * self) {
}


GType vala_ccode_delegate_module_get_type (void) {
	static GType vala_ccode_delegate_module_type_id = 0;
	if (vala_ccode_delegate_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeDelegateModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_delegate_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeDelegateModule), 0, (GInstanceInitFunc) vala_ccode_delegate_module_instance_init, NULL };
		vala_ccode_delegate_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ARRAY_MODULE, "ValaCCodeDelegateModule", &g_define_type_info, 0);
	}
	return vala_ccode_delegate_module_type_id;
}




