/* valadbusclientmodule.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
*  Copyright (C) 2008  Philip Van Hoof
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Philip Van Hoof <pvanhoof@gnome.org>
 */

#ifndef __GOBJECT_VALADBUSCLIENTMODULE_H__
#define __GOBJECT_VALADBUSCLIENTMODULE_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valadynamicmethod.h>
#include <vala/valaarraytype.h>
#include <gobject/valagasyncmodule.h>
#include <gobject/valaccodegenerator.h>
#include <gobject/valaccodemodule.h>

G_BEGIN_DECLS


#define VALA_TYPE_DBUS_CLIENT_MODULE (vala_dbus_client_module_get_type ())
#define VALA_DBUS_CLIENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DBUS_CLIENT_MODULE, ValaDBusClientModule))
#define VALA_DBUS_CLIENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DBUS_CLIENT_MODULE, ValaDBusClientModuleClass))
#define VALA_IS_DBUS_CLIENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DBUS_CLIENT_MODULE))
#define VALA_IS_DBUS_CLIENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DBUS_CLIENT_MODULE))
#define VALA_DBUS_CLIENT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DBUS_CLIENT_MODULE, ValaDBusClientModuleClass))

typedef struct _ValaDBusClientModule ValaDBusClientModule;
typedef struct _ValaDBusClientModuleClass ValaDBusClientModuleClass;
typedef struct _ValaDBusClientModulePrivate ValaDBusClientModulePrivate;

/**
 * The link between a dynamic method and generated code.
 */
struct _ValaDBusClientModule {
	ValaGAsyncModule parent_instance;
	ValaDBusClientModulePrivate * priv;
};

struct _ValaDBusClientModuleClass {
	ValaGAsyncModuleClass parent_class;
};


ValaDBusClientModule* vala_dbus_client_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaDBusClientModule* vala_dbus_client_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
gboolean vala_dbus_client_module_dbus_use_ptr_array (ValaDBusClientModule* self, ValaArrayType* array_type);
GType vala_dbus_client_module_get_type (void);


G_END_DECLS

#endif
