/* valainterfaceregisterfunction.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valainterfaceregisterfunction.h>
#include <vala/valadatatype.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodenode.h>




struct _ValaInterfaceRegisterFunctionPrivate {
	ValaInterface* _interface_reference;
};

#define VALA_INTERFACE_REGISTER_FUNCTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_INTERFACE_REGISTER_FUNCTION, ValaInterfaceRegisterFunctionPrivate))
enum  {
	VALA_INTERFACE_REGISTER_FUNCTION_DUMMY_PROPERTY
};
static ValaTypeSymbol* vala_interface_register_function_real_get_type_declaration (ValaTypeRegisterFunction* base);
static char* vala_interface_register_function_real_get_type_struct_name (ValaTypeRegisterFunction* base);
static char* vala_interface_register_function_real_get_base_init_func_name (ValaTypeRegisterFunction* base);
static char* vala_interface_register_function_real_get_class_init_func_name (ValaTypeRegisterFunction* base);
static char* vala_interface_register_function_real_get_instance_struct_size (ValaTypeRegisterFunction* base);
static char* vala_interface_register_function_real_get_instance_init_func_name (ValaTypeRegisterFunction* base);
static char* vala_interface_register_function_real_get_parent_type_name (ValaTypeRegisterFunction* base);
static ValaSymbolAccessibility vala_interface_register_function_real_get_accessibility (ValaTypeRegisterFunction* base);
static ValaCCodeFragment* vala_interface_register_function_real_get_type_interface_init_statements (ValaTypeRegisterFunction* base);
static gpointer vala_interface_register_function_parent_class = NULL;
static void vala_interface_register_function_finalize (ValaTypeRegisterFunction* obj);



ValaInterfaceRegisterFunction* vala_interface_register_function_construct (GType object_type, ValaInterface* iface, ValaCodeContext* context) {
	ValaInterfaceRegisterFunction* self;
	g_return_val_if_fail (iface != NULL, NULL);
	g_return_val_if_fail (context != NULL, NULL);
	self = ((ValaInterfaceRegisterFunction*) (g_type_create_instance (object_type)));
	vala_interface_register_function_set_interface_reference (self, iface);
	vala_typeregister_function_set_context (((ValaTypeRegisterFunction*) (self)), context);
	return self;
}


ValaInterfaceRegisterFunction* vala_interface_register_function_new (ValaInterface* iface, ValaCodeContext* context) {
	return vala_interface_register_function_construct (VALA_TYPE_INTERFACE_REGISTER_FUNCTION, iface, context);
}


static ValaTypeSymbol* vala_interface_register_function_real_get_type_declaration (ValaTypeRegisterFunction* base) {
	ValaInterfaceRegisterFunction * self;
	ValaTypeSymbol* _tmp0;
	self = ((ValaInterfaceRegisterFunction*) (base));
	_tmp0 = NULL;
	return (_tmp0 = ((ValaTypeSymbol*) (self->priv->_interface_reference)), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
}


static char* vala_interface_register_function_real_get_type_struct_name (ValaTypeRegisterFunction* base) {
	ValaInterfaceRegisterFunction * self;
	self = ((ValaInterfaceRegisterFunction*) (base));
	return vala_interface_get_type_cname (self->priv->_interface_reference);
}


static char* vala_interface_register_function_real_get_base_init_func_name (ValaTypeRegisterFunction* base) {
	ValaInterfaceRegisterFunction * self;
	char* _tmp0;
	char* _tmp1;
	self = ((ValaInterfaceRegisterFunction*) (base));
	_tmp0 = NULL;
	_tmp1 = NULL;
	return (_tmp1 = g_strdup_printf ("%s_base_init", (_tmp0 = vala_symbol_get_lower_case_cname (((ValaSymbol*) (self->priv->_interface_reference)), NULL))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
}


static char* vala_interface_register_function_real_get_class_init_func_name (ValaTypeRegisterFunction* base) {
	ValaInterfaceRegisterFunction * self;
	self = ((ValaInterfaceRegisterFunction*) (base));
	return g_strdup ("NULL");
}


static char* vala_interface_register_function_real_get_instance_struct_size (ValaTypeRegisterFunction* base) {
	ValaInterfaceRegisterFunction * self;
	self = ((ValaInterfaceRegisterFunction*) (base));
	return g_strdup ("0");
}


static char* vala_interface_register_function_real_get_instance_init_func_name (ValaTypeRegisterFunction* base) {
	ValaInterfaceRegisterFunction * self;
	self = ((ValaInterfaceRegisterFunction*) (base));
	return g_strdup ("NULL");
}


static char* vala_interface_register_function_real_get_parent_type_name (ValaTypeRegisterFunction* base) {
	ValaInterfaceRegisterFunction * self;
	self = ((ValaInterfaceRegisterFunction*) (base));
	return g_strdup ("G_TYPE_INTERFACE");
}


static ValaSymbolAccessibility vala_interface_register_function_real_get_accessibility (ValaTypeRegisterFunction* base) {
	ValaInterfaceRegisterFunction * self;
	self = ((ValaInterfaceRegisterFunction*) (base));
	return vala_symbol_get_access (((ValaSymbol*) (self->priv->_interface_reference)));
}


static ValaCCodeFragment* vala_interface_register_function_real_get_type_interface_init_statements (ValaTypeRegisterFunction* base) {
	ValaInterfaceRegisterFunction * self;
	ValaCCodeFragment* frag;
	self = ((ValaInterfaceRegisterFunction*) (base));
	frag = vala_ccode_fragment_new ();
	/* register all prerequisites */
	{
		GeeList* prereq_ref_collection;
		int prereq_ref_it;
		prereq_ref_collection = vala_interface_get_prerequisites (self->priv->_interface_reference);
		for (prereq_ref_it = 0; prereq_ref_it < gee_collection_get_size (GEE_COLLECTION (prereq_ref_collection)); prereq_ref_it = prereq_ref_it + 1) {
			ValaDataType* prereq_ref;
			prereq_ref = ((ValaDataType*) (gee_list_get (GEE_LIST (prereq_ref_collection), prereq_ref_it)));
			{
				ValaTypeSymbol* _tmp0;
				ValaTypeSymbol* prereq;
				ValaCCodeIdentifier* _tmp1;
				ValaCCodeFunctionCall* _tmp2;
				ValaCCodeFunctionCall* func;
				ValaCCodeIdentifier* _tmp5;
				char* _tmp4;
				char* _tmp3;
				ValaCCodeIdentifier* _tmp7;
				char* _tmp6;
				ValaCCodeExpressionStatement* _tmp8;
				_tmp0 = NULL;
				prereq = (_tmp0 = vala_data_type_get_data_type (prereq_ref), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
				_tmp1 = NULL;
				_tmp2 = NULL;
				func = (_tmp2 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp1 = vala_ccode_identifier_new ("g_type_interface_add_prerequisite"))))), (_tmp1 == NULL ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL))), _tmp2);
				_tmp5 = NULL;
				_tmp4 = NULL;
				_tmp3 = NULL;
				vala_ccode_function_call_add_argument (func, ((ValaCCodeExpression*) ((_tmp5 = vala_ccode_identifier_new ((_tmp4 = g_strdup_printf ("%s_type_id", (_tmp3 = vala_symbol_get_lower_case_cname (((ValaSymbol*) (self->priv->_interface_reference)), NULL)))))))));
				(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
				_tmp4 = (g_free (_tmp4), NULL);
				_tmp3 = (g_free (_tmp3), NULL);
				_tmp7 = NULL;
				_tmp6 = NULL;
				vala_ccode_function_call_add_argument (func, ((ValaCCodeExpression*) ((_tmp7 = vala_ccode_identifier_new ((_tmp6 = vala_typesymbol_get_type_id (prereq)))))));
				(_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)));
				_tmp6 = (g_free (_tmp6), NULL);
				_tmp8 = NULL;
				vala_ccode_fragment_append (frag, ((ValaCCodeNode*) ((_tmp8 = vala_ccode_expression_statement_new (((ValaCCodeExpression*) (func)))))));
				(_tmp8 == NULL ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)));
				(prereq_ref == NULL ? NULL : (prereq_ref = (vala_code_node_unref (prereq_ref), NULL)));
				(prereq == NULL ? NULL : (prereq = (vala_code_node_unref (prereq), NULL)));
				(func == NULL ? NULL : (func = (vala_ccode_node_unref (func), NULL)));
			}
		}
		(prereq_ref_collection == NULL ? NULL : (prereq_ref_collection = (gee_collection_object_unref (prereq_ref_collection), NULL)));
	}
	return frag;
}


ValaInterface* vala_interface_register_function_get_interface_reference (ValaInterfaceRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_interface_reference;
}


void vala_interface_register_function_set_interface_reference (ValaInterfaceRegisterFunction* self, ValaInterface* value) {
	g_return_if_fail (self != NULL);
	self->priv->_interface_reference = value;
}


static void vala_interface_register_function_class_init (ValaInterfaceRegisterFunctionClass * klass) {
	vala_interface_register_function_parent_class = g_type_class_peek_parent (klass);
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->finalize = vala_interface_register_function_finalize;
	g_type_class_add_private (klass, sizeof (ValaInterfaceRegisterFunctionPrivate));
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_declaration = vala_interface_register_function_real_get_type_declaration;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_struct_name = vala_interface_register_function_real_get_type_struct_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_base_init_func_name = vala_interface_register_function_real_get_base_init_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_class_init_func_name = vala_interface_register_function_real_get_class_init_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_instance_struct_size = vala_interface_register_function_real_get_instance_struct_size;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_instance_init_func_name = vala_interface_register_function_real_get_instance_init_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_parent_type_name = vala_interface_register_function_real_get_parent_type_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_accessibility = vala_interface_register_function_real_get_accessibility;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_interface_init_statements = vala_interface_register_function_real_get_type_interface_init_statements;
}


static void vala_interface_register_function_instance_init (ValaInterfaceRegisterFunction * self) {
	self->priv = VALA_INTERFACE_REGISTER_FUNCTION_GET_PRIVATE (self);
}


static void vala_interface_register_function_finalize (ValaTypeRegisterFunction* obj) {
	ValaInterfaceRegisterFunction * self;
	self = VALA_INTERFACE_REGISTER_FUNCTION (obj);
	VALA_TYPEREGISTER_FUNCTION_CLASS (vala_interface_register_function_parent_class)->finalize (obj);
}


GType vala_interface_register_function_get_type (void) {
	static GType vala_interface_register_function_type_id = 0;
	if (vala_interface_register_function_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaInterfaceRegisterFunctionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_interface_register_function_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInterfaceRegisterFunction), 0, (GInstanceInitFunc) vala_interface_register_function_instance_init, NULL };
		vala_interface_register_function_type_id = g_type_register_static (VALA_TYPE_TYPEREGISTER_FUNCTION, "ValaInterfaceRegisterFunction", &g_define_type_info, 0);
	}
	return vala_interface_register_function_type_id;
}




