/* valagidlparser.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#ifndef __VAPIGEN_VALAGIDLPARSER_H__
#define __VAPIGEN_VALAGIDLPARSER_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valacodevisitor.h>
#include <vala/valacodecontext.h>
#include <vala/valanamespace.h>
#include <vala/valaclass.h>
#include <vala/valastruct.h>
#include <vala/valainterface.h>
#include <vala/valaenum.h>
#include <vala/valaerrordomain.h>
#include <vala/valadelegate.h>
#include <vala/valasourcefile.h>

G_BEGIN_DECLS


#define VALA_TYPE_GIDL_PARSER (vala_gidl_parser_get_type ())
#define VALA_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParser))
#define VALA_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))
#define VALA_IS_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GIDL_PARSER))
#define VALA_IS_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GIDL_PARSER))
#define VALA_GIDL_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))

typedef struct _ValaGIdlParser ValaGIdlParser;
typedef struct _ValaGIdlParserClass ValaGIdlParserClass;
typedef struct _ValaGIdlParserPrivate ValaGIdlParserPrivate;

/**
 * Code visitor parsing all GIDL files.
 */
struct _ValaGIdlParser {
	ValaCodeVisitor parent_instance;
	ValaGIdlParserPrivate * priv;
};

struct _ValaGIdlParserClass {
	ValaCodeVisitorClass parent_class;
};


void vala_gidl_parser_parse (ValaGIdlParser* self, ValaCodeContext* context);
ValaGIdlParser* vala_gidl_parser_construct (GType object_type);
ValaGIdlParser* vala_gidl_parser_new (void);
GType vala_gidl_parser_get_type (void);


G_END_DECLS

#endif
