/* valaccodebasemodule.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodebasemodule.h>
#include <vala/valacodevisitor.h>
#include <vala/valaobjecttype.h>
#include <vala/valaobjecttypesymbol.h>
#include <vala/valavaluetype.h>
#include <vala/valaerrordomain.h>
#include <vala/valaerrorcode.h>
#include <vala/valareport.h>
#include <vala/valainvalidtype.h>
#include <vala/valapointertype.h>
#include <vala/valavoidtype.h>
#include <ccode/valaccodeassignment.h>
#include <gee/hashmap.h>
#include <gee/map.h>
#include <gee/collection.h>
#include <vala/valaarraytype.h>
#include <ccode/valaccodecommaexpression.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodememberaccess.h>
#include <vala/valanulltype.h>
#include <vala/valainstancecast.h>
#include <ccode/valaccodecastexpression.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodereturnstatement.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeconditionalexpression.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodeinitializerlist.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <vala/valareferencetype.h>
#include <vala/valadostatement.h>
#include <vala/valawhilestatement.h>
#include <vala/valaforstatement.h>
#include <vala/valaforeachstatement.h>
#include <vala/valaswitchstatement.h>
#include <vala/valadynamicproperty.h>
#include <gee/hashset.h>
#include <ccode/valaccodeincludedirective.h>
#include <ccode/valaccodeifstatement.h>
#include <vala/valasourcefilecycle.h>
#include <ccode/valaccodetypedefinition.h>
#include <ccode/valaccodemacroreplacement.h>
#include <ccode/valaccodecomment.h>
#include <ccode/valaccodewriter.h>
#include <ccode/valaccodeoncesection.h>
#include <ccode/valaccodenewline.h>
#include <vala/valascope.h>
#include <ccode/valaccodeenumvalue.h>
#include <vala/valalockable.h>
#include <ccode/valaccodeparenthesizedexpression.h>
#include <vala/valadelegatetype.h>
#include <vala/valadelegate.h>
#include <vala/valaarraycreationexpression.h>
#include <ccode/valaccodefunctiondeclarator.h>
#include <ccode/valaccodeemptystatement.h>
#include <vala/valagenerictype.h>
#include <vala/valamethodcall.h>
#include <ccode/valaccodecasestatement.h>
#include <vala/valamemberinitializer.h>




struct _ValaCCodeBaseModulePrivate {
	ValaCodeContext* _context;
	GeeMap* variable_name_map;
};

#define VALA_CCODE_BASE_MODULE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModulePrivate))
enum  {
	VALA_CCODE_BASE_MODULE_DUMMY_PROPERTY
};
static ValaCCodeIdentifier* vala_ccode_base_module_real_get_value_setter_function (ValaCCodeModule* base, ValaDataType* type_reference);
static ValaCCodeIncludeDirective* vala_ccode_base_module_get_internal_include (ValaCCodeBaseModule* self, const char* filename);
static void vala_ccode_base_module_real_append_vala_array_free (ValaCCodeBaseModule* self);
static void vala_ccode_base_module_real_append_vala_array_move (ValaCCodeBaseModule* self);
static void vala_ccode_base_module_append_vala_strcmp0 (ValaCCodeBaseModule* self);
static void vala_ccode_base_module_real_visit_source_file (ValaCCodeModule* base, ValaSourceFile* source_file);
static char* vala_ccode_base_module_get_define_for_filename (const char* filename);
static void vala_ccode_base_module_real_emit (ValaCCodeModule* base, ValaCodeContext* context);
static void vala_ccode_base_module_real_visit_enum (ValaCCodeModule* base, ValaEnum* en);
static void vala_ccode_base_module_real_visit_enum_value (ValaCCodeModule* base, ValaEnumValue* ev);
static void vala_ccode_base_module_real_visit_member (ValaCCodeModule* base, ValaMember* m);
static void vala_ccode_base_module_real_visit_constant (ValaCCodeModule* base, ValaConstant* c);
static void vala_ccode_base_module_real_visit_field (ValaCCodeModule* base, ValaField* f);
static void vala_ccode_base_module_real_visit_formal_parameter (ValaCCodeModule* base, ValaFormalParameter* p);
static void vala_ccode_base_module_real_visit_property (ValaCCodeModule* base, ValaProperty* prop);
static void vala_ccode_base_module_real_visit_property_accessor (ValaCCodeModule* base, ValaPropertyAccessor* acc);
static void vala_ccode_base_module_real_visit_destructor (ValaCCodeModule* base, ValaDestructor* d);
static void vala_ccode_base_module_real_visit_block (ValaCCodeModule* base, ValaBlock* b);
static void vala_ccode_base_module_real_visit_empty_statement (ValaCCodeModule* base, ValaEmptyStatement* stmt);
static void vala_ccode_base_module_real_visit_declaration_statement (ValaCCodeModule* base, ValaDeclarationStatement* stmt);
static void vala_ccode_base_module_real_visit_local_variable (ValaCCodeModule* base, ValaLocalVariable* local);
static void vala_ccode_base_module_real_visit_initializer_list (ValaCCodeModule* base, ValaInitializerList* list);
static ValaCCodeExpression* vala_ccode_base_module_get_type_id_expression (ValaCCodeBaseModule* self, ValaDataType* type);
static ValaCCodeExpression* vala_ccode_base_module_real_get_dup_func_expression (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference);
static char* vala_ccode_base_module_generate_struct_dup_wrapper (ValaCCodeBaseModule* self, ValaValueType* value_type);
static char* vala_ccode_base_module_generate_glist_free_wrapper (ValaCCodeBaseModule* self, ValaDataType* list_type, ValaCCodeIdentifier* element_destroy_func_expression);
static void vala_ccode_base_module_real_visit_end_full_expression (ValaCCodeModule* base, ValaExpression* expr);
static void vala_ccode_base_module_real_visit_expression_statement (ValaCCodeModule* base, ValaExpressionStatement* stmt);
static void vala_ccode_base_module_append_param_free (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeFragment* cfrag);
static gboolean vala_ccode_base_module_append_local_free_expr (ValaCCodeBaseModule* self, ValaSymbol* sym, ValaCCodeCommaExpression* ccomma, gboolean stop_at_loop);
static gboolean vala_ccode_base_module_append_param_free_expr (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeCommaExpression* ccomma);
static void vala_ccode_base_module_create_local_free_expr (ValaCCodeBaseModule* self, ValaExpression* expr);
static void vala_ccode_base_module_real_visit_return_statement (ValaCCodeModule* base, ValaReturnStatement* stmt);
static char* vala_ccode_base_module_get_symbol_lock_name (ValaCCodeBaseModule* self, ValaSymbol* sym);
static void vala_ccode_base_module_real_visit_lock_statement (ValaCCodeModule* base, ValaLockStatement* stmt);
static void vala_ccode_base_module_real_visit_delete_statement (ValaCCodeModule* base, ValaDeleteStatement* stmt);
static void vala_ccode_base_module_real_visit_expression (ValaCCodeModule* base, ValaExpression* expr);
static void vala_ccode_base_module_real_visit_boolean_literal (ValaCCodeModule* base, ValaBooleanLiteral* expr);
static void vala_ccode_base_module_real_visit_character_literal (ValaCCodeModule* base, ValaCharacterLiteral* expr);
static void vala_ccode_base_module_real_visit_integer_literal (ValaCCodeModule* base, ValaIntegerLiteral* expr);
static void vala_ccode_base_module_real_visit_real_literal (ValaCCodeModule* base, ValaRealLiteral* expr);
static void vala_ccode_base_module_real_visit_string_literal (ValaCCodeModule* base, ValaStringLiteral* expr);
static void vala_ccode_base_module_real_visit_null_literal (ValaCCodeModule* base, ValaNullLiteral* expr);
static void vala_ccode_base_module_real_visit_parenthesized_expression (ValaCCodeModule* base, ValaParenthesizedExpression* expr);
static char* vala_ccode_base_module_real_get_delegate_target_cname (ValaCCodeBaseModule* self, const char* delegate_cname);
static ValaCCodeExpression* vala_ccode_base_module_real_get_delegate_target_cexpression (ValaCCodeBaseModule* self, ValaExpression* delegate_expr);
static char* vala_ccode_base_module_real_get_delegate_target_destroy_notify_cname (ValaCCodeBaseModule* self, const char* delegate_cname);
static void vala_ccode_base_module_real_visit_base_access (ValaCCodeModule* base, ValaBaseAccess* expr);
static void vala_ccode_base_module_real_visit_postfix_expression (ValaCCodeModule* base, ValaPostfixExpression* expr);
static ValaMemberAccess* vala_ccode_base_module_find_property_access (ValaCCodeBaseModule* self, ValaExpression* expr);
static void vala_ccode_base_module_real_visit_object_creation_expression (ValaCCodeModule* base, ValaObjectCreationExpression* expr);
static void vala_ccode_base_module_real_visit_sizeof_expression (ValaCCodeModule* base, ValaSizeofExpression* expr);
static void vala_ccode_base_module_real_visit_typeof_expression (ValaCCodeModule* base, ValaTypeofExpression* expr);
static void vala_ccode_base_module_real_visit_unary_expression (ValaCCodeModule* base, ValaUnaryExpression* expr);
static void vala_ccode_base_module_real_visit_cast_expression (ValaCCodeModule* base, ValaCastExpression* expr);
static void vala_ccode_base_module_real_visit_pointer_indirection (ValaCCodeModule* base, ValaPointerIndirection* expr);
static void vala_ccode_base_module_real_visit_addressof_expression (ValaCCodeModule* base, ValaAddressofExpression* expr);
static void vala_ccode_base_module_real_visit_reference_transfer_expression (ValaCCodeModule* base, ValaReferenceTransferExpression* expr);
static void vala_ccode_base_module_real_visit_binary_expression (ValaCCodeModule* base, ValaBinaryExpression* expr);
static ValaCCodeExpression* vala_ccode_base_module_create_type_check (ValaCCodeBaseModule* self, ValaCCodeNode* ccodenode, ValaDataType* type);
static void vala_ccode_base_module_real_visit_type_check (ValaCCodeModule* base, ValaTypeCheck* expr);
static void vala_ccode_base_module_real_visit_lambda_expression (ValaCCodeModule* base, ValaLambdaExpression* l);
static ValaCCodeExpression* vala_ccode_base_module_real_get_implicit_cast_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
static ValaCCodeStatement* vala_ccode_base_module_create_property_type_check_statement (ValaCCodeBaseModule* self, ValaProperty* prop, gboolean check_return_type, ValaTypeSymbol* t, gboolean non_null, const char* var_name);
static gpointer vala_ccode_base_module_parent_class = NULL;
static void vala_ccode_base_module_finalize (ValaCCodeModule* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaCCodeBaseModule* vala_ccode_base_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeBaseModule* self;
	GeeSet* _tmp0;
	GeeSet* _tmp1;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaCCodeBaseModule*) vala_ccode_module_construct (object_type, codegen, next);
	_tmp0 = NULL;
	self->predefined_marshal_set = (_tmp0 = (GeeSet*) gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal), (self->predefined_marshal_set == NULL) ? NULL : (self->predefined_marshal_set = (gee_collection_object_unref (self->predefined_marshal_set), NULL)), _tmp0);
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:VOID");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:BOOLEAN");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:CHAR");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:UCHAR");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:INT");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:UINT");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:LONG");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:ULONG");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:ENUM");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:FLAGS");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:FLOAT");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:DOUBLE");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:STRING");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:POINTER");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:OBJECT");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "STRING:OBJECT,POINTER");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:UINT,POINTER");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "BOOLEAN:FLAGS");
	_tmp1 = NULL;
	self->c_keywords = (_tmp1 = (GeeSet*) gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal), (self->c_keywords == NULL) ? NULL : (self->c_keywords = (gee_collection_object_unref (self->c_keywords), NULL)), _tmp1);
	/* C99 keywords*/
	gee_collection_add ((GeeCollection*) self->c_keywords, "_Bool");
	gee_collection_add ((GeeCollection*) self->c_keywords, "_Complex");
	gee_collection_add ((GeeCollection*) self->c_keywords, "_Imaginary");
	gee_collection_add ((GeeCollection*) self->c_keywords, "auto");
	gee_collection_add ((GeeCollection*) self->c_keywords, "break");
	gee_collection_add ((GeeCollection*) self->c_keywords, "case");
	gee_collection_add ((GeeCollection*) self->c_keywords, "char");
	gee_collection_add ((GeeCollection*) self->c_keywords, "const");
	gee_collection_add ((GeeCollection*) self->c_keywords, "continue");
	gee_collection_add ((GeeCollection*) self->c_keywords, "default");
	gee_collection_add ((GeeCollection*) self->c_keywords, "do");
	gee_collection_add ((GeeCollection*) self->c_keywords, "double");
	gee_collection_add ((GeeCollection*) self->c_keywords, "else");
	gee_collection_add ((GeeCollection*) self->c_keywords, "enum");
	gee_collection_add ((GeeCollection*) self->c_keywords, "extern");
	gee_collection_add ((GeeCollection*) self->c_keywords, "float");
	gee_collection_add ((GeeCollection*) self->c_keywords, "for");
	gee_collection_add ((GeeCollection*) self->c_keywords, "goto");
	gee_collection_add ((GeeCollection*) self->c_keywords, "if");
	gee_collection_add ((GeeCollection*) self->c_keywords, "inline");
	gee_collection_add ((GeeCollection*) self->c_keywords, "int");
	gee_collection_add ((GeeCollection*) self->c_keywords, "long");
	gee_collection_add ((GeeCollection*) self->c_keywords, "register");
	gee_collection_add ((GeeCollection*) self->c_keywords, "restrict");
	gee_collection_add ((GeeCollection*) self->c_keywords, "return");
	gee_collection_add ((GeeCollection*) self->c_keywords, "short");
	gee_collection_add ((GeeCollection*) self->c_keywords, "signed");
	gee_collection_add ((GeeCollection*) self->c_keywords, "sizeof");
	gee_collection_add ((GeeCollection*) self->c_keywords, "static");
	gee_collection_add ((GeeCollection*) self->c_keywords, "struct");
	gee_collection_add ((GeeCollection*) self->c_keywords, "switch");
	gee_collection_add ((GeeCollection*) self->c_keywords, "typedef");
	gee_collection_add ((GeeCollection*) self->c_keywords, "union");
	gee_collection_add ((GeeCollection*) self->c_keywords, "unsigned");
	gee_collection_add ((GeeCollection*) self->c_keywords, "void");
	gee_collection_add ((GeeCollection*) self->c_keywords, "volatile");
	gee_collection_add ((GeeCollection*) self->c_keywords, "while");
	/* MSVC keywords*/
	gee_collection_add ((GeeCollection*) self->c_keywords, "cdecl");
	return self;
}


ValaCCodeBaseModule* vala_ccode_base_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_base_module_construct (VALA_TYPE_CCODE_BASE_MODULE, codegen, next);
}


static ValaCCodeIdentifier* vala_ccode_base_module_real_get_value_setter_function (ValaCCodeModule* base, ValaDataType* type_reference) {
	ValaCCodeBaseModule * self;
	self = (ValaCCodeBaseModule*) base;
	g_return_val_if_fail (type_reference != NULL, NULL);
	if (vala_data_type_get_data_type (type_reference) != NULL) {
		char* _tmp0;
		ValaCCodeIdentifier* _tmp1;
		_tmp0 = NULL;
		_tmp1 = NULL;
		return (_tmp1 = vala_ccode_identifier_new (_tmp0 = vala_typesymbol_get_set_value_function (vala_data_type_get_data_type (type_reference))), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
	} else {
		return vala_ccode_identifier_new ("g_value_set_pointer");
	}
}


static ValaCCodeIncludeDirective* vala_ccode_base_module_get_internal_include (ValaCCodeBaseModule* self, const char* filename) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	return vala_ccode_include_directive_new (filename, vala_code_context_get_library (self->priv->_context) == NULL);
}


static void vala_ccode_base_module_real_append_vala_array_free (ValaCCodeBaseModule* self) {
	g_return_if_fail (self != NULL);
}


void vala_ccode_base_module_append_vala_array_free (ValaCCodeBaseModule* self) {
	VALA_CCODE_BASE_MODULE_GET_CLASS (self)->append_vala_array_free (self);
}


static void vala_ccode_base_module_real_append_vala_array_move (ValaCCodeBaseModule* self) {
	g_return_if_fail (self != NULL);
}


void vala_ccode_base_module_append_vala_array_move (ValaCCodeBaseModule* self) {
	VALA_CCODE_BASE_MODULE_GET_CLASS (self)->append_vala_array_move (self);
}


static void vala_ccode_base_module_append_vala_strcmp0 (ValaCCodeBaseModule* self) {
	ValaCCodeFunction* fun;
	ValaCCodeFormalParameter* _tmp0;
	ValaCCodeFormalParameter* _tmp1;
	ValaCCodeFunction* _tmp2;
	ValaCCodeIdentifier* _tmp4;
	ValaCCodeIdentifier* _tmp3;
	ValaCCodeBinaryExpression* _tmp5;
	ValaCCodeBinaryExpression* cineq;
	ValaCCodeBlock* _tmp6;
	ValaCCodeBlock* cblock;
	ValaCCodeBinaryExpression* _tmp9;
	ValaCCodeConstant* _tmp8;
	ValaCCodeIdentifier* _tmp7;
	ValaCCodeIfStatement* _tmp10;
	ValaCCodeIfStatement* cif;
	ValaCCodeReturnStatement* _tmp12;
	ValaCCodeUnaryExpression* _tmp11;
	ValaCCodeBlock* _tmp13;
	ValaCCodeIfStatement* _tmp17;
	ValaCCodeBinaryExpression* _tmp16;
	ValaCCodeConstant* _tmp15;
	ValaCCodeIdentifier* _tmp14;
	ValaCCodeReturnStatement* _tmp18;
	ValaCCodeIdentifier* _tmp19;
	ValaCCodeFunctionCall* _tmp20;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp21;
	ValaCCodeIdentifier* _tmp22;
	ValaCCodeReturnStatement* _tmp23;
	g_return_if_fail (self != NULL);
	fun = vala_ccode_function_new ("_vala_strcmp0", "int");
	vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
	_tmp0 = NULL;
	vala_ccode_function_add_parameter (fun, _tmp0 = vala_ccode_formal_parameter_new ("str1", "const char *"));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	_tmp1 = NULL;
	vala_ccode_function_add_parameter (fun, _tmp1 = vala_ccode_formal_parameter_new ("str2", "const char *"));
	(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
	_tmp2 = NULL;
	vala_ccode_fragment_append (self->source_type_member_declaration, (ValaCCodeNode*) (_tmp2 = vala_ccode_function_copy (fun)));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	/* (str1 != str2)*/
	_tmp4 = NULL;
	_tmp3 = NULL;
	_tmp5 = NULL;
	cineq = (_tmp5 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) (_tmp3 = vala_ccode_identifier_new ("str1")), (ValaCCodeExpression*) (_tmp4 = vala_ccode_identifier_new ("str2"))), (_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)), (_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)), _tmp5);
	_tmp6 = NULL;
	vala_ccode_function_set_block (fun, _tmp6 = vala_ccode_block_new ());
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	cblock = vala_ccode_block_new ();
	/* if (str1 == NULL)*/
	_tmp9 = NULL;
	_tmp8 = NULL;
	_tmp7 = NULL;
	_tmp10 = NULL;
	cif = (_tmp10 = vala_ccode_if_statement_new ((ValaCCodeExpression*) (_tmp9 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new ("str1")), (ValaCCodeExpression*) (_tmp8 = vala_ccode_constant_new ("NULL")))), (ValaCCodeStatement*) cblock, NULL), (_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)), (_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)), (_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)), _tmp10);
	/* return -(str1 != str2);*/
	_tmp12 = NULL;
	_tmp11 = NULL;
	vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp12 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp11 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_MINUS, (ValaCCodeExpression*) cineq)))));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), (ValaCCodeNode*) cif);
	_tmp13 = NULL;
	cblock = (_tmp13 = vala_ccode_block_new (), (cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL)), _tmp13);
	/* if (str2 == NULL)*/
	_tmp17 = NULL;
	_tmp16 = NULL;
	_tmp15 = NULL;
	_tmp14 = NULL;
	cif = (_tmp17 = vala_ccode_if_statement_new ((ValaCCodeExpression*) (_tmp16 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) (_tmp14 = vala_ccode_identifier_new ("str2")), (ValaCCodeExpression*) (_tmp15 = vala_ccode_constant_new ("NULL")))), (ValaCCodeStatement*) cblock, NULL), (cif == NULL) ? NULL : (cif = (vala_ccode_node_unref (cif), NULL)), _tmp17);
	(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
	(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
	(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
	/* return (str1 != str2);*/
	_tmp18 = NULL;
	vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp18 = vala_ccode_return_statement_new ((ValaCCodeExpression*) cineq)));
	(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), (ValaCCodeNode*) cif);
	/* strcmp (str1, str2)*/
	_tmp19 = NULL;
	_tmp20 = NULL;
	ccall = (_tmp20 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp19 = vala_ccode_identifier_new ("strcmp"))), (_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)), _tmp20);
	_tmp21 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp21 = vala_ccode_identifier_new ("str1")));
	(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
	_tmp22 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp22 = vala_ccode_identifier_new ("str2")));
	(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
	/* return strcmp (str1, str2);*/
	_tmp23 = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), (ValaCCodeNode*) (_tmp23 = vala_ccode_return_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
	vala_ccode_fragment_append (self->source_type_member_definition, (ValaCCodeNode*) fun);
	(fun == NULL) ? NULL : (fun = (vala_ccode_node_unref (fun), NULL));
	(cineq == NULL) ? NULL : (cineq = (vala_ccode_node_unref (cineq), NULL));
	(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
	(cif == NULL) ? NULL : (cif = (vala_ccode_node_unref (cif), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
}


static void vala_ccode_base_module_real_visit_source_file (ValaCCodeModule* base, ValaSourceFile* source_file) {
	ValaCCodeBaseModule * self;
	ValaCCodeFragment* _tmp0;
	ValaCCodeFragment* _tmp1;
	ValaCCodeFragment* _tmp2;
	ValaCCodeFragment* _tmp3;
	ValaCCodeFragment* _tmp4;
	ValaCCodeFragment* _tmp5;
	ValaCCodeFragment* _tmp6;
	ValaCCodeFragment* _tmp7;
	ValaCCodeFragment* _tmp8;
	ValaCCodeFragment* _tmp9;
	ValaCCodeFragment* _tmp10;
	ValaCCodeFragment* _tmp11;
	ValaCCodeFragment* _tmp12;
	ValaCCodeFragment* _tmp13;
	GeeSet* _tmp14;
	GeeSet* _tmp15;
	ValaCCodeIncludeDirective* _tmp16;
	ValaCCodeIncludeDirective* _tmp17;
	gboolean _tmp18;
	GeeList* used_includes;
	char* _tmp23;
	char* _tmp71;
	char* _tmp72;
	char* header_define;
	ValaCCodeComment* comment;
	char* _tmp82;
	ValaCCodeWriter* _tmp83;
	ValaCCodeWriter* writer;
	ValaCCodeOnceSection* once;
	ValaCCodeNewline* _tmp85;
	ValaCCodeNewline* _tmp86;
	ValaCCodeIdentifier* _tmp87;
	ValaCCodeNewline* _tmp88;
	ValaCCodeNewline* _tmp89;
	ValaCCodeNewline* _tmp90;
	ValaCCodeNewline* _tmp91;
	ValaCCodeNewline* _tmp92;
	ValaCCodeNewline* _tmp93;
	ValaCCodeIdentifier* _tmp94;
	ValaCCodeNewline* _tmp95;
	ValaCCodeNewline* _tmp96;
	ValaCCodeWriter* _tmp98;
	char* _tmp97;
	ValaCCodeFragment* _tmp100;
	ValaCCodeFragment* _tmp101;
	ValaCCodeFragment* _tmp102;
	ValaCCodeFragment* _tmp103;
	ValaCCodeFragment* _tmp104;
	ValaCCodeFragment* _tmp105;
	ValaCCodeFragment* _tmp106;
	ValaCCodeFragment* _tmp107;
	ValaCCodeFragment* _tmp108;
	ValaCCodeFragment* _tmp109;
	ValaCCodeFragment* _tmp110;
	ValaCCodeFragment* _tmp111;
	ValaCCodeFragment* _tmp112;
	ValaCCodeFragment* _tmp113;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (source_file != NULL);
	_tmp0 = NULL;
	self->header_begin = (_tmp0 = vala_ccode_fragment_new (), (self->header_begin == NULL) ? NULL : (self->header_begin = (vala_ccode_node_unref (self->header_begin), NULL)), _tmp0);
	_tmp1 = NULL;
	self->header_type_declaration = (_tmp1 = vala_ccode_fragment_new (), (self->header_type_declaration == NULL) ? NULL : (self->header_type_declaration = (vala_ccode_node_unref (self->header_type_declaration), NULL)), _tmp1);
	_tmp2 = NULL;
	self->header_type_definition = (_tmp2 = vala_ccode_fragment_new (), (self->header_type_definition == NULL) ? NULL : (self->header_type_definition = (vala_ccode_node_unref (self->header_type_definition), NULL)), _tmp2);
	_tmp3 = NULL;
	self->header_type_member_declaration = (_tmp3 = vala_ccode_fragment_new (), (self->header_type_member_declaration == NULL) ? NULL : (self->header_type_member_declaration = (vala_ccode_node_unref (self->header_type_member_declaration), NULL)), _tmp3);
	_tmp4 = NULL;
	self->header_constant_declaration = (_tmp4 = vala_ccode_fragment_new (), (self->header_constant_declaration == NULL) ? NULL : (self->header_constant_declaration = (vala_ccode_node_unref (self->header_constant_declaration), NULL)), _tmp4);
	_tmp5 = NULL;
	self->source_begin = (_tmp5 = vala_ccode_fragment_new (), (self->source_begin == NULL) ? NULL : (self->source_begin = (vala_ccode_node_unref (self->source_begin), NULL)), _tmp5);
	_tmp6 = NULL;
	self->source_include_directives = (_tmp6 = vala_ccode_fragment_new (), (self->source_include_directives == NULL) ? NULL : (self->source_include_directives = (vala_ccode_node_unref (self->source_include_directives), NULL)), _tmp6);
	_tmp7 = NULL;
	self->source_type_declaration = (_tmp7 = vala_ccode_fragment_new (), (self->source_type_declaration == NULL) ? NULL : (self->source_type_declaration = (vala_ccode_node_unref (self->source_type_declaration), NULL)), _tmp7);
	_tmp8 = NULL;
	self->source_type_definition = (_tmp8 = vala_ccode_fragment_new (), (self->source_type_definition == NULL) ? NULL : (self->source_type_definition = (vala_ccode_node_unref (self->source_type_definition), NULL)), _tmp8);
	_tmp9 = NULL;
	self->source_type_member_declaration = (_tmp9 = vala_ccode_fragment_new (), (self->source_type_member_declaration == NULL) ? NULL : (self->source_type_member_declaration = (vala_ccode_node_unref (self->source_type_member_declaration), NULL)), _tmp9);
	_tmp10 = NULL;
	self->source_constant_declaration = (_tmp10 = vala_ccode_fragment_new (), (self->source_constant_declaration == NULL) ? NULL : (self->source_constant_declaration = (vala_ccode_node_unref (self->source_constant_declaration), NULL)), _tmp10);
	_tmp11 = NULL;
	self->source_type_member_definition = (_tmp11 = vala_ccode_fragment_new (), (self->source_type_member_definition == NULL) ? NULL : (self->source_type_member_definition = (vala_ccode_node_unref (self->source_type_member_definition), NULL)), _tmp11);
	_tmp12 = NULL;
	self->source_signal_marshaller_definition = (_tmp12 = vala_ccode_fragment_new (), (self->source_signal_marshaller_definition == NULL) ? NULL : (self->source_signal_marshaller_definition = (vala_ccode_node_unref (self->source_signal_marshaller_definition), NULL)), _tmp12);
	_tmp13 = NULL;
	self->source_signal_marshaller_declaration = (_tmp13 = vala_ccode_fragment_new (), (self->source_signal_marshaller_declaration == NULL) ? NULL : (self->source_signal_marshaller_declaration = (vala_ccode_node_unref (self->source_signal_marshaller_declaration), NULL)), _tmp13);
	_tmp14 = NULL;
	self->user_marshal_set = (_tmp14 = (GeeSet*) gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal), (self->user_marshal_set == NULL) ? NULL : (self->user_marshal_set = (gee_collection_object_unref (self->user_marshal_set), NULL)), _tmp14);
	self->next_temp_var_id = 0;
	self->string_h_needed = FALSE;
	self->gvaluecollector_h_needed = FALSE;
	self->gio_h_needed = FALSE;
	self->dbus_glib_h_needed = FALSE;
	self->dbus_glib_h_needed_in_header = FALSE;
	self->requires_free_checked = FALSE;
	self->requires_array_free = FALSE;
	self->requires_array_move = FALSE;
	self->requires_strcmp0 = FALSE;
	_tmp15 = NULL;
	self->wrappers = (_tmp15 = (GeeSet*) gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal), (self->wrappers == NULL) ? NULL : (self->wrappers = (gee_collection_object_unref (self->wrappers), NULL)), _tmp15);
	_tmp16 = NULL;
	vala_ccode_fragment_append (self->header_begin, (ValaCCodeNode*) (_tmp16 = vala_ccode_include_directive_new ("glib.h", FALSE)));
	(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
	_tmp17 = NULL;
	vala_ccode_fragment_append (self->header_begin, (ValaCCodeNode*) (_tmp17 = vala_ccode_include_directive_new ("glib-object.h", FALSE)));
	(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
	_tmp18 = FALSE;
	if (vala_code_context_get_basedir (self->priv->_context) != NULL) {
		_tmp18 = TRUE;
	} else {
		_tmp18 = vala_code_context_get_library (self->priv->_context) != NULL;
	}
	if (_tmp18) {
		ValaCCodeIncludeDirective* _tmp20;
		char* _tmp19;
		_tmp20 = NULL;
		_tmp19 = NULL;
		vala_ccode_fragment_append (self->source_include_directives, (ValaCCodeNode*) (_tmp20 = vala_ccode_include_directive_new (_tmp19 = vala_source_file_get_cinclude_filename (source_file), FALSE)));
		(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
		_tmp19 = (g_free (_tmp19), NULL);
	} else {
		ValaCCodeIncludeDirective* _tmp22;
		char* _tmp21;
		_tmp22 = NULL;
		_tmp21 = NULL;
		vala_ccode_fragment_append (self->source_include_directives, (ValaCCodeNode*) (_tmp22 = vala_ccode_include_directive_new (_tmp21 = vala_source_file_get_cinclude_filename (source_file), TRUE)));
		(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
		_tmp21 = (g_free (_tmp21), NULL);
	}
	used_includes = (GeeList*) gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_equal);
	gee_collection_add ((GeeCollection*) used_includes, "glib.h");
	gee_collection_add ((GeeCollection*) used_includes, "glib-object.h");
	_tmp23 = NULL;
	gee_collection_add ((GeeCollection*) used_includes, _tmp23 = vala_source_file_get_cinclude_filename (source_file));
	_tmp23 = (g_free (_tmp23), NULL);
	{
		GeeList* _tmp24;
		GeeIterator* _tmp25;
		GeeIterator* filename_it;
		_tmp24 = NULL;
		_tmp25 = NULL;
		filename_it = (_tmp25 = gee_iterable_iterator ((GeeIterable*) (_tmp24 = vala_source_file_get_header_external_includes (source_file))), (_tmp24 == NULL) ? NULL : (_tmp24 = (gee_collection_object_unref (_tmp24), NULL)), _tmp25);
		while (gee_iterator_next (filename_it)) {
			char* filename;
			filename = (char*) gee_iterator_get (filename_it);
			if (!gee_collection_contains ((GeeCollection*) used_includes, filename)) {
				ValaCCodeIncludeDirective* _tmp26;
				_tmp26 = NULL;
				vala_ccode_fragment_append (self->header_begin, (ValaCCodeNode*) (_tmp26 = vala_ccode_include_directive_new (filename, FALSE)));
				(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
				gee_collection_add ((GeeCollection*) used_includes, filename);
			}
			filename = (g_free (filename), NULL);
		}
		(filename_it == NULL) ? NULL : (filename_it = (gee_collection_object_unref (filename_it), NULL));
	}
	{
		GeeList* _tmp27;
		GeeIterator* _tmp28;
		GeeIterator* filename_it;
		_tmp27 = NULL;
		_tmp28 = NULL;
		filename_it = (_tmp28 = gee_iterable_iterator ((GeeIterable*) (_tmp27 = vala_source_file_get_header_internal_includes (source_file))), (_tmp27 == NULL) ? NULL : (_tmp27 = (gee_collection_object_unref (_tmp27), NULL)), _tmp28);
		while (gee_iterator_next (filename_it)) {
			char* filename;
			filename = (char*) gee_iterator_get (filename_it);
			if (!gee_collection_contains ((GeeCollection*) used_includes, filename)) {
				ValaCCodeIncludeDirective* _tmp29;
				_tmp29 = NULL;
				vala_ccode_fragment_append (self->header_begin, (ValaCCodeNode*) (_tmp29 = vala_ccode_base_module_get_internal_include (self, filename)));
				(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
				gee_collection_add ((GeeCollection*) used_includes, filename);
			}
			filename = (g_free (filename), NULL);
		}
		(filename_it == NULL) ? NULL : (filename_it = (gee_collection_object_unref (filename_it), NULL));
	}
	{
		GeeList* _tmp30;
		GeeIterator* _tmp31;
		GeeIterator* filename_it;
		_tmp30 = NULL;
		_tmp31 = NULL;
		filename_it = (_tmp31 = gee_iterable_iterator ((GeeIterable*) (_tmp30 = vala_source_file_get_source_external_includes (source_file))), (_tmp30 == NULL) ? NULL : (_tmp30 = (gee_collection_object_unref (_tmp30), NULL)), _tmp31);
		while (gee_iterator_next (filename_it)) {
			char* filename;
			filename = (char*) gee_iterator_get (filename_it);
			if (!gee_collection_contains ((GeeCollection*) used_includes, filename)) {
				ValaCCodeIncludeDirective* _tmp32;
				_tmp32 = NULL;
				vala_ccode_fragment_append (self->source_include_directives, (ValaCCodeNode*) (_tmp32 = vala_ccode_include_directive_new (filename, FALSE)));
				(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
				gee_collection_add ((GeeCollection*) used_includes, filename);
			}
			filename = (g_free (filename), NULL);
		}
		(filename_it == NULL) ? NULL : (filename_it = (gee_collection_object_unref (filename_it), NULL));
	}
	{
		GeeList* _tmp33;
		GeeIterator* _tmp34;
		GeeIterator* filename_it;
		_tmp33 = NULL;
		_tmp34 = NULL;
		filename_it = (_tmp34 = gee_iterable_iterator ((GeeIterable*) (_tmp33 = vala_source_file_get_source_internal_includes (source_file))), (_tmp33 == NULL) ? NULL : (_tmp33 = (gee_collection_object_unref (_tmp33), NULL)), _tmp34);
		while (gee_iterator_next (filename_it)) {
			char* filename;
			filename = (char*) gee_iterator_get (filename_it);
			if (!gee_collection_contains ((GeeCollection*) used_includes, filename)) {
				ValaCCodeIncludeDirective* _tmp35;
				_tmp35 = NULL;
				vala_ccode_fragment_append (self->source_include_directives, (ValaCCodeNode*) (_tmp35 = vala_ccode_base_module_get_internal_include (self, filename)));
				(_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL));
				gee_collection_add ((GeeCollection*) used_includes, filename);
			}
			filename = (g_free (filename), NULL);
		}
		(filename_it == NULL) ? NULL : (filename_it = (gee_collection_object_unref (filename_it), NULL));
	}
	{
		GeeSet* _tmp36;
		GeeIterator* _tmp37;
		GeeIterator* symbol_it;
		_tmp36 = NULL;
		_tmp37 = NULL;
		symbol_it = (_tmp37 = gee_iterable_iterator ((GeeIterable*) (_tmp36 = vala_source_file_get_source_symbol_dependencies (source_file))), (_tmp36 == NULL) ? NULL : (_tmp36 = (gee_collection_object_unref (_tmp36), NULL)), _tmp37);
		while (gee_iterator_next (symbol_it)) {
			ValaSymbol* symbol;
			gboolean _tmp38;
			symbol = (ValaSymbol*) gee_iterator_get (symbol_it);
			_tmp38 = FALSE;
			if (!vala_symbol_get_external (symbol)) {
				_tmp38 = vala_symbol_get_external_package (symbol);
			} else {
				_tmp38 = FALSE;
			}
			if (_tmp38) {
				vala_code_node_accept ((ValaCodeNode*) symbol, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
			}
			(symbol == NULL) ? NULL : (symbol = (vala_code_node_unref (symbol), NULL));
		}
		(symbol_it == NULL) ? NULL : (symbol_it = (gee_collection_object_unref (symbol_it), NULL));
	}
	if (vala_source_file_get_is_cycle_head (source_file)) {
		{
			GeeIterator* cycle_file_it;
			cycle_file_it = gee_iterable_iterator ((GeeIterable*) vala_source_file_get_cycle (source_file)->files);
			while (gee_iterator_next (cycle_file_it)) {
				ValaSourceFile* _tmp39;
				ValaSourceFile* cycle_file;
				_tmp39 = NULL;
				cycle_file = (_tmp39 = (ValaSourceFile*) gee_iterator_get (cycle_file_it), (_tmp39 == NULL) ? NULL : vala_source_file_ref (_tmp39));
				{
					GeeList* _tmp40;
					GeeIterator* _tmp41;
					GeeIterator* node_it;
					_tmp40 = NULL;
					_tmp41 = NULL;
					node_it = (_tmp41 = gee_iterable_iterator ((GeeIterable*) (_tmp40 = vala_source_file_get_nodes (cycle_file))), (_tmp40 == NULL) ? NULL : (_tmp40 = (gee_collection_object_unref (_tmp40), NULL)), _tmp41);
					while (gee_iterator_next (node_it)) {
						ValaCodeNode* node;
						node = (ValaCodeNode*) gee_iterator_get (node_it);
						if (VALA_IS_STRUCT (node)) {
							ValaStruct* _tmp42;
							ValaStruct* st;
							ValaCCodeTypeDefinition* _tmp47;
							ValaCCodeVariableDeclarator* _tmp46;
							char* _tmp45;
							char* _tmp44;
							char* _tmp43;
							_tmp42 = NULL;
							st = (_tmp42 = VALA_STRUCT (node), (_tmp42 == NULL) ? NULL : vala_code_node_ref (_tmp42));
							_tmp47 = NULL;
							_tmp46 = NULL;
							_tmp45 = NULL;
							_tmp44 = NULL;
							_tmp43 = NULL;
							vala_ccode_fragment_append (self->header_type_declaration, (ValaCCodeNode*) (_tmp47 = vala_ccode_type_definition_new (_tmp44 = g_strdup_printf ("struct _%s", _tmp43 = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE)), (ValaCCodeDeclarator*) (_tmp46 = vala_ccode_variable_declarator_new (_tmp45 = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE))))));
							(_tmp47 == NULL) ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL));
							(_tmp46 == NULL) ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL));
							_tmp45 = (g_free (_tmp45), NULL);
							_tmp44 = (g_free (_tmp44), NULL);
							_tmp43 = (g_free (_tmp43), NULL);
							(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
						} else {
							if (VALA_IS_CLASS (node)) {
								ValaClass* _tmp48;
								ValaClass* cl;
								ValaCCodeTypeDefinition* _tmp53;
								ValaCCodeVariableDeclarator* _tmp52;
								char* _tmp51;
								char* _tmp50;
								char* _tmp49;
								ValaCCodeTypeDefinition* _tmp59;
								ValaCCodeVariableDeclarator* _tmp58;
								char* _tmp57;
								char* _tmp56;
								char* _tmp55;
								char* _tmp54;
								_tmp48 = NULL;
								cl = (_tmp48 = VALA_CLASS (node), (_tmp48 == NULL) ? NULL : vala_code_node_ref (_tmp48));
								_tmp53 = NULL;
								_tmp52 = NULL;
								_tmp51 = NULL;
								_tmp50 = NULL;
								_tmp49 = NULL;
								vala_ccode_fragment_append (self->header_type_declaration, (ValaCCodeNode*) (_tmp53 = vala_ccode_type_definition_new (_tmp50 = g_strdup_printf ("struct _%s", _tmp49 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE)), (ValaCCodeDeclarator*) (_tmp52 = vala_ccode_variable_declarator_new (_tmp51 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))))));
								(_tmp53 == NULL) ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL));
								(_tmp52 == NULL) ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL));
								_tmp51 = (g_free (_tmp51), NULL);
								_tmp50 = (g_free (_tmp50), NULL);
								_tmp49 = (g_free (_tmp49), NULL);
								_tmp59 = NULL;
								_tmp58 = NULL;
								_tmp57 = NULL;
								_tmp56 = NULL;
								_tmp55 = NULL;
								_tmp54 = NULL;
								vala_ccode_fragment_append (self->header_type_declaration, (ValaCCodeNode*) (_tmp59 = vala_ccode_type_definition_new (_tmp55 = g_strdup_printf ("struct _%sClass", _tmp54 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE)), (ValaCCodeDeclarator*) (_tmp58 = vala_ccode_variable_declarator_new (_tmp57 = g_strdup_printf ("%sClass", _tmp56 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE)))))));
								(_tmp59 == NULL) ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL));
								(_tmp58 == NULL) ? NULL : (_tmp58 = (vala_ccode_node_unref (_tmp58), NULL));
								_tmp57 = (g_free (_tmp57), NULL);
								_tmp56 = (g_free (_tmp56), NULL);
								_tmp55 = (g_free (_tmp55), NULL);
								_tmp54 = (g_free (_tmp54), NULL);
								(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
							} else {
								if (VALA_IS_INTERFACE (node)) {
									ValaInterface* _tmp60;
									ValaInterface* iface;
									ValaCCodeTypeDefinition* _tmp65;
									ValaCCodeVariableDeclarator* _tmp64;
									char* _tmp63;
									char* _tmp62;
									char* _tmp61;
									ValaCCodeTypeDefinition* _tmp70;
									ValaCCodeVariableDeclarator* _tmp69;
									char* _tmp68;
									char* _tmp67;
									char* _tmp66;
									_tmp60 = NULL;
									iface = (_tmp60 = VALA_INTERFACE (node), (_tmp60 == NULL) ? NULL : vala_code_node_ref (_tmp60));
									_tmp65 = NULL;
									_tmp64 = NULL;
									_tmp63 = NULL;
									_tmp62 = NULL;
									_tmp61 = NULL;
									vala_ccode_fragment_append (self->header_type_declaration, (ValaCCodeNode*) (_tmp65 = vala_ccode_type_definition_new (_tmp62 = g_strdup_printf ("struct _%s", _tmp61 = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE)), (ValaCCodeDeclarator*) (_tmp64 = vala_ccode_variable_declarator_new (_tmp63 = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE))))));
									(_tmp65 == NULL) ? NULL : (_tmp65 = (vala_ccode_node_unref (_tmp65), NULL));
									(_tmp64 == NULL) ? NULL : (_tmp64 = (vala_ccode_node_unref (_tmp64), NULL));
									_tmp63 = (g_free (_tmp63), NULL);
									_tmp62 = (g_free (_tmp62), NULL);
									_tmp61 = (g_free (_tmp61), NULL);
									_tmp70 = NULL;
									_tmp69 = NULL;
									_tmp68 = NULL;
									_tmp67 = NULL;
									_tmp66 = NULL;
									vala_ccode_fragment_append (self->header_type_declaration, (ValaCCodeNode*) (_tmp70 = vala_ccode_type_definition_new (_tmp67 = g_strdup_printf ("struct _%s", _tmp66 = vala_interface_get_type_cname (iface)), (ValaCCodeDeclarator*) (_tmp69 = vala_ccode_variable_declarator_new (_tmp68 = vala_interface_get_type_cname (iface))))));
									(_tmp70 == NULL) ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL));
									(_tmp69 == NULL) ? NULL : (_tmp69 = (vala_ccode_node_unref (_tmp69), NULL));
									_tmp68 = (g_free (_tmp68), NULL);
									_tmp67 = (g_free (_tmp67), NULL);
									_tmp66 = (g_free (_tmp66), NULL);
									(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
								}
							}
						}
						(node == NULL) ? NULL : (node = (vala_code_node_unref (node), NULL));
					}
					(node_it == NULL) ? NULL : (node_it = (gee_collection_object_unref (node_it), NULL));
				}
				(cycle_file == NULL) ? NULL : (cycle_file = (vala_source_file_unref (cycle_file), NULL));
			}
			(cycle_file_it == NULL) ? NULL : (cycle_file_it = (gee_collection_object_unref (cycle_file_it), NULL));
		}
	}
	vala_source_file_accept_children (source_file, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (vala_report_get_errors () > 0) {
		(used_includes == NULL) ? NULL : (used_includes = (gee_collection_object_unref (used_includes), NULL));
		return;
	}
	_tmp71 = NULL;
	_tmp72 = NULL;
	header_define = (_tmp72 = vala_ccode_base_module_get_define_for_filename (_tmp71 = vala_source_file_get_cinclude_filename (source_file)), _tmp71 = (g_free (_tmp71), NULL), _tmp72);
	/* generate hardcoded "well-known" macros */
	if (self->requires_free_checked) {
		ValaCCodeMacroReplacement* _tmp73;
		_tmp73 = NULL;
		vala_ccode_fragment_append (self->source_begin, (ValaCCodeNode*) (_tmp73 = vala_ccode_macro_replacement_new ("VALA_FREE_CHECKED(o,f)", "((o) == NULL ? NULL : ((o) = (f (o), NULL)))")));
		(_tmp73 == NULL) ? NULL : (_tmp73 = (vala_ccode_node_unref (_tmp73), NULL));
	}
	if (self->requires_array_free) {
		vala_ccode_base_module_append_vala_array_free (self);
	}
	if (self->requires_array_move) {
		vala_ccode_base_module_append_vala_array_move (self);
	}
	if (self->requires_strcmp0) {
		vala_ccode_base_module_append_vala_strcmp0 (self);
	}
	if (self->string_h_needed) {
		ValaCCodeIncludeDirective* _tmp74;
		_tmp74 = NULL;
		vala_ccode_fragment_append (self->source_include_directives, (ValaCCodeNode*) (_tmp74 = vala_ccode_include_directive_new ("string.h", FALSE)));
		(_tmp74 == NULL) ? NULL : (_tmp74 = (vala_ccode_node_unref (_tmp74), NULL));
	}
	if (self->gvaluecollector_h_needed) {
		ValaCCodeIncludeDirective* _tmp75;
		_tmp75 = NULL;
		vala_ccode_fragment_append (self->source_include_directives, (ValaCCodeNode*) (_tmp75 = vala_ccode_include_directive_new ("gobject/gvaluecollector.h", FALSE)));
		(_tmp75 == NULL) ? NULL : (_tmp75 = (vala_ccode_node_unref (_tmp75), NULL));
	}
	if (self->gio_h_needed) {
		ValaCCodeIncludeDirective* _tmp76;
		_tmp76 = NULL;
		vala_ccode_fragment_append (self->header_begin, (ValaCCodeNode*) (_tmp76 = vala_ccode_include_directive_new ("gio/gio.h", FALSE)));
		(_tmp76 == NULL) ? NULL : (_tmp76 = (vala_ccode_node_unref (_tmp76), NULL));
	}
	if (self->dbus_glib_h_needed_in_header) {
		ValaCCodeIncludeDirective* _tmp77;
		ValaCCodeIncludeDirective* _tmp78;
		_tmp77 = NULL;
		vala_ccode_fragment_append (self->header_begin, (ValaCCodeNode*) (_tmp77 = vala_ccode_include_directive_new ("dbus/dbus.h", FALSE)));
		(_tmp77 == NULL) ? NULL : (_tmp77 = (vala_ccode_node_unref (_tmp77), NULL));
		_tmp78 = NULL;
		vala_ccode_fragment_append (self->header_begin, (ValaCCodeNode*) (_tmp78 = vala_ccode_include_directive_new ("dbus/dbus-glib.h", FALSE)));
		(_tmp78 == NULL) ? NULL : (_tmp78 = (vala_ccode_node_unref (_tmp78), NULL));
	} else {
		if (self->dbus_glib_h_needed) {
			ValaCCodeIncludeDirective* _tmp79;
			ValaCCodeIncludeDirective* _tmp80;
			_tmp79 = NULL;
			vala_ccode_fragment_append (self->source_include_directives, (ValaCCodeNode*) (_tmp79 = vala_ccode_include_directive_new ("dbus/dbus.h", FALSE)));
			(_tmp79 == NULL) ? NULL : (_tmp79 = (vala_ccode_node_unref (_tmp79), NULL));
			_tmp80 = NULL;
			vala_ccode_fragment_append (self->source_include_directives, (ValaCCodeNode*) (_tmp80 = vala_ccode_include_directive_new ("dbus/dbus-glib.h", FALSE)));
			(_tmp80 == NULL) ? NULL : (_tmp80 = (vala_ccode_node_unref (_tmp80), NULL));
		}
	}
	comment = NULL;
	if (vala_source_file_get_comment (source_file) != NULL) {
		ValaCCodeComment* _tmp81;
		_tmp81 = NULL;
		comment = (_tmp81 = vala_ccode_comment_new (vala_source_file_get_comment (source_file)), (comment == NULL) ? NULL : (comment = (vala_ccode_node_unref (comment), NULL)), _tmp81);
	}
	_tmp82 = NULL;
	_tmp83 = NULL;
	writer = (_tmp83 = vala_ccode_writer_new (_tmp82 = vala_source_file_get_cheader_filename (source_file)), _tmp82 = (g_free (_tmp82), NULL), _tmp83);
	if (!vala_ccode_writer_open (writer)) {
		char* _tmp84;
		_tmp84 = NULL;
		vala_report_error (NULL, _tmp84 = g_strdup_printf ("unable to open `%s' for writing", vala_ccode_writer_get_filename (writer)));
		_tmp84 = (g_free (_tmp84), NULL);
		(used_includes == NULL) ? NULL : (used_includes = (gee_collection_object_unref (used_includes), NULL));
		header_define = (g_free (header_define), NULL);
		(comment == NULL) ? NULL : (comment = (vala_ccode_node_unref (comment), NULL));
		(writer == NULL) ? NULL : (writer = (vala_ccode_writer_unref (writer), NULL));
		return;
	}
	if (comment != NULL) {
		vala_ccode_node_write ((ValaCCodeNode*) comment, writer);
	}
	vala_ccode_writer_write_newline (writer);
	once = vala_ccode_once_section_new (header_define);
	_tmp85 = NULL;
	vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp85 = vala_ccode_newline_new ()));
	(_tmp85 == NULL) ? NULL : (_tmp85 = (vala_ccode_node_unref (_tmp85), NULL));
	vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) self->header_begin);
	_tmp86 = NULL;
	vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp86 = vala_ccode_newline_new ()));
	(_tmp86 == NULL) ? NULL : (_tmp86 = (vala_ccode_node_unref (_tmp86), NULL));
	_tmp87 = NULL;
	vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp87 = vala_ccode_identifier_new ("G_BEGIN_DECLS")));
	(_tmp87 == NULL) ? NULL : (_tmp87 = (vala_ccode_node_unref (_tmp87), NULL));
	_tmp88 = NULL;
	vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp88 = vala_ccode_newline_new ()));
	(_tmp88 == NULL) ? NULL : (_tmp88 = (vala_ccode_node_unref (_tmp88), NULL));
	_tmp89 = NULL;
	vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp89 = vala_ccode_newline_new ()));
	(_tmp89 == NULL) ? NULL : (_tmp89 = (vala_ccode_node_unref (_tmp89), NULL));
	vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) self->header_type_declaration);
	_tmp90 = NULL;
	vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp90 = vala_ccode_newline_new ()));
	(_tmp90 == NULL) ? NULL : (_tmp90 = (vala_ccode_node_unref (_tmp90), NULL));
	vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) self->header_type_definition);
	_tmp91 = NULL;
	vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp91 = vala_ccode_newline_new ()));
	(_tmp91 == NULL) ? NULL : (_tmp91 = (vala_ccode_node_unref (_tmp91), NULL));
	vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) self->header_type_member_declaration);
	_tmp92 = NULL;
	vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp92 = vala_ccode_newline_new ()));
	(_tmp92 == NULL) ? NULL : (_tmp92 = (vala_ccode_node_unref (_tmp92), NULL));
	vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) self->header_constant_declaration);
	_tmp93 = NULL;
	vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp93 = vala_ccode_newline_new ()));
	(_tmp93 == NULL) ? NULL : (_tmp93 = (vala_ccode_node_unref (_tmp93), NULL));
	_tmp94 = NULL;
	vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp94 = vala_ccode_identifier_new ("G_END_DECLS")));
	(_tmp94 == NULL) ? NULL : (_tmp94 = (vala_ccode_node_unref (_tmp94), NULL));
	_tmp95 = NULL;
	vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp95 = vala_ccode_newline_new ()));
	(_tmp95 == NULL) ? NULL : (_tmp95 = (vala_ccode_node_unref (_tmp95), NULL));
	_tmp96 = NULL;
	vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp96 = vala_ccode_newline_new ()));
	(_tmp96 == NULL) ? NULL : (_tmp96 = (vala_ccode_node_unref (_tmp96), NULL));
	vala_ccode_node_write ((ValaCCodeNode*) once, writer);
	vala_ccode_writer_close (writer);
	_tmp98 = NULL;
	_tmp97 = NULL;
	writer = (_tmp98 = vala_ccode_writer_new (_tmp97 = vala_source_file_get_csource_filename (source_file)), (writer == NULL) ? NULL : (writer = (vala_ccode_writer_unref (writer), NULL)), _tmp98);
	_tmp97 = (g_free (_tmp97), NULL);
	if (!vala_ccode_writer_open (writer)) {
		char* _tmp99;
		_tmp99 = NULL;
		vala_report_error (NULL, _tmp99 = g_strdup_printf ("unable to open `%s' for writing", vala_ccode_writer_get_filename (writer)));
		_tmp99 = (g_free (_tmp99), NULL);
		(used_includes == NULL) ? NULL : (used_includes = (gee_collection_object_unref (used_includes), NULL));
		header_define = (g_free (header_define), NULL);
		(comment == NULL) ? NULL : (comment = (vala_ccode_node_unref (comment), NULL));
		(writer == NULL) ? NULL : (writer = (vala_ccode_writer_unref (writer), NULL));
		(once == NULL) ? NULL : (once = (vala_ccode_node_unref (once), NULL));
		return;
	}
	vala_ccode_writer_set_line_directives (writer, vala_code_context_get_debug (self->priv->_context));
	if (comment != NULL) {
		vala_ccode_node_write ((ValaCCodeNode*) comment, writer);
	}
	vala_ccode_node_write ((ValaCCodeNode*) self->source_begin, writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write ((ValaCCodeNode*) self->source_include_directives, writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write_combined ((ValaCCodeNode*) self->source_type_declaration, writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write_combined ((ValaCCodeNode*) self->source_type_definition, writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write_declaration ((ValaCCodeNode*) self->source_type_member_declaration, writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write ((ValaCCodeNode*) self->source_type_member_declaration, writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write ((ValaCCodeNode*) self->source_constant_declaration, writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write_declaration ((ValaCCodeNode*) self->source_signal_marshaller_declaration, writer);
	vala_ccode_node_write ((ValaCCodeNode*) self->source_signal_marshaller_declaration, writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write ((ValaCCodeNode*) self->source_type_member_definition, writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write ((ValaCCodeNode*) self->source_signal_marshaller_definition, writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_writer_close (writer);
	_tmp100 = NULL;
	self->header_begin = (_tmp100 = NULL, (self->header_begin == NULL) ? NULL : (self->header_begin = (vala_ccode_node_unref (self->header_begin), NULL)), _tmp100);
	_tmp101 = NULL;
	self->header_type_declaration = (_tmp101 = NULL, (self->header_type_declaration == NULL) ? NULL : (self->header_type_declaration = (vala_ccode_node_unref (self->header_type_declaration), NULL)), _tmp101);
	_tmp102 = NULL;
	self->header_type_definition = (_tmp102 = NULL, (self->header_type_definition == NULL) ? NULL : (self->header_type_definition = (vala_ccode_node_unref (self->header_type_definition), NULL)), _tmp102);
	_tmp103 = NULL;
	self->header_type_member_declaration = (_tmp103 = NULL, (self->header_type_member_declaration == NULL) ? NULL : (self->header_type_member_declaration = (vala_ccode_node_unref (self->header_type_member_declaration), NULL)), _tmp103);
	_tmp104 = NULL;
	self->header_constant_declaration = (_tmp104 = NULL, (self->header_constant_declaration == NULL) ? NULL : (self->header_constant_declaration = (vala_ccode_node_unref (self->header_constant_declaration), NULL)), _tmp104);
	_tmp105 = NULL;
	self->source_begin = (_tmp105 = NULL, (self->source_begin == NULL) ? NULL : (self->source_begin = (vala_ccode_node_unref (self->source_begin), NULL)), _tmp105);
	_tmp106 = NULL;
	self->source_include_directives = (_tmp106 = NULL, (self->source_include_directives == NULL) ? NULL : (self->source_include_directives = (vala_ccode_node_unref (self->source_include_directives), NULL)), _tmp106);
	_tmp107 = NULL;
	self->source_type_declaration = (_tmp107 = NULL, (self->source_type_declaration == NULL) ? NULL : (self->source_type_declaration = (vala_ccode_node_unref (self->source_type_declaration), NULL)), _tmp107);
	_tmp108 = NULL;
	self->source_type_definition = (_tmp108 = NULL, (self->source_type_definition == NULL) ? NULL : (self->source_type_definition = (vala_ccode_node_unref (self->source_type_definition), NULL)), _tmp108);
	_tmp109 = NULL;
	self->source_type_member_declaration = (_tmp109 = NULL, (self->source_type_member_declaration == NULL) ? NULL : (self->source_type_member_declaration = (vala_ccode_node_unref (self->source_type_member_declaration), NULL)), _tmp109);
	_tmp110 = NULL;
	self->source_constant_declaration = (_tmp110 = NULL, (self->source_constant_declaration == NULL) ? NULL : (self->source_constant_declaration = (vala_ccode_node_unref (self->source_constant_declaration), NULL)), _tmp110);
	_tmp111 = NULL;
	self->source_type_member_definition = (_tmp111 = NULL, (self->source_type_member_definition == NULL) ? NULL : (self->source_type_member_definition = (vala_ccode_node_unref (self->source_type_member_definition), NULL)), _tmp111);
	_tmp112 = NULL;
	self->source_signal_marshaller_definition = (_tmp112 = NULL, (self->source_signal_marshaller_definition == NULL) ? NULL : (self->source_signal_marshaller_definition = (vala_ccode_node_unref (self->source_signal_marshaller_definition), NULL)), _tmp112);
	_tmp113 = NULL;
	self->source_signal_marshaller_declaration = (_tmp113 = NULL, (self->source_signal_marshaller_declaration == NULL) ? NULL : (self->source_signal_marshaller_declaration = (vala_ccode_node_unref (self->source_signal_marshaller_declaration), NULL)), _tmp113);
	(used_includes == NULL) ? NULL : (used_includes = (gee_collection_object_unref (used_includes), NULL));
	header_define = (g_free (header_define), NULL);
	(comment == NULL) ? NULL : (comment = (vala_ccode_node_unref (comment), NULL));
	(writer == NULL) ? NULL : (writer = (vala_ccode_writer_unref (writer), NULL));
	(once == NULL) ? NULL : (once = (vala_ccode_node_unref (once), NULL));
}


static char* vala_ccode_base_module_get_define_for_filename (const char* filename) {
	GString* define;
	const char* _tmp0;
	char* i;
	const char* _tmp4;
	char* _tmp5;
	g_return_val_if_fail (filename != NULL, NULL);
	define = g_string_new ("__");
	_tmp0 = NULL;
	i = (_tmp0 = filename, (_tmp0 == NULL) ? NULL : g_strdup (_tmp0));
	while (g_utf8_strlen (i, -1) > 0) {
		gunichar c;
		gboolean _tmp1;
		char* _tmp3;
		const char* _tmp2;
		c = g_utf8_get_char (i);
		_tmp1 = FALSE;
		if (g_unichar_isalnum (c)) {
			_tmp1 = c < 0x80;
		} else {
			_tmp1 = FALSE;
		}
		if (_tmp1) {
			g_string_append_unichar (define, g_unichar_toupper (c));
		} else {
			g_string_append_c (define, '_');
		}
		_tmp3 = NULL;
		_tmp2 = NULL;
		i = (_tmp3 = (_tmp2 = g_utf8_next_char (i), (_tmp2 == NULL) ? NULL : g_strdup (_tmp2)), i = (g_free (i), NULL), _tmp3);
	}
	g_string_append (define, "__");
	_tmp4 = NULL;
	_tmp5 = NULL;
	return (_tmp5 = (_tmp4 = define->str, (_tmp4 == NULL) ? NULL : g_strdup (_tmp4)), (define == NULL) ? NULL : (define = (g_string_free (define, TRUE), NULL)), i = (g_free (i), NULL), _tmp5);
}


static void vala_ccode_base_module_real_emit (ValaCCodeModule* base, ValaCodeContext* context) {
	ValaCCodeBaseModule * self;
	ValaSymbol* _tmp1;
	ValaSymbol* _tmp0;
	ValaDataType* _tmp3;
	ValaTypeSymbol* _tmp2;
	ValaDataType* _tmp5;
	ValaTypeSymbol* _tmp4;
	ValaDataType* _tmp7;
	ValaTypeSymbol* _tmp6;
	ValaDataType* _tmp9;
	ValaTypeSymbol* _tmp8;
	ValaDataType* _tmp11;
	ValaTypeSymbol* _tmp10;
	ValaDataType* _tmp13;
	ValaTypeSymbol* _tmp12;
	ValaDataType* _tmp15;
	ValaTypeSymbol* _tmp14;
	ValaDataType* _tmp17;
	ValaTypeSymbol* _tmp16;
	ValaDataType* _tmp19;
	ValaTypeSymbol* _tmp18;
	ValaDataType* _tmp21;
	ValaTypeSymbol* _tmp20;
	ValaDataType* _tmp23;
	ValaTypeSymbol* _tmp22;
	ValaDataType* _tmp25;
	ValaTypeSymbol* _tmp24;
	ValaDataType* _tmp27;
	ValaTypeSymbol* _tmp26;
	ValaDataType* _tmp29;
	ValaTypeSymbol* _tmp28;
	ValaDataType* _tmp31;
	ValaTypeSymbol* _tmp30;
	ValaDataType* _tmp33;
	ValaTypeSymbol* _tmp32;
	ValaDataType* _tmp35;
	ValaTypeSymbol* _tmp34;
	ValaDataType* _tmp37;
	ValaTypeSymbol* _tmp36;
	ValaDataType* _tmp39;
	ValaClass* _tmp38;
	ValaMethod* _tmp40;
	ValaSymbol* glib_ns;
	ValaTypeSymbol* _tmp41;
	ValaTypeSymbol* _tmp42;
	ValaErrorType* _tmp43;
	ValaClass* _tmp44;
	ValaClass* _tmp45;
	ValaTypeSymbol* _tmp46;
	ValaTypeSymbol* _tmp47;
	ValaDataType* _tmp49;
	ValaTypeSymbol* _tmp48;
	ValaStruct* _tmp50;
	ValaStruct* _tmp51;
	ValaTypeSymbol* _tmp52;
	ValaSymbol* gee_ns;
	ValaSymbol* dbus_ns;
	GeeList* source_files;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (context != NULL);
	vala_ccode_base_module_set_context (self, context);
	vala_code_context_find_header_cycles (context);
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->root_symbol = (_tmp1 = (_tmp0 = (ValaSymbol*) vala_code_context_get_root (context), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0)), (self->root_symbol == NULL) ? NULL : (self->root_symbol = (vala_code_node_unref (self->root_symbol), NULL)), _tmp1);
	_tmp3 = NULL;
	_tmp2 = NULL;
	self->bool_type = (_tmp3 = (ValaDataType*) vala_value_type_new (_tmp2 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "bool"))), (self->bool_type == NULL) ? NULL : (self->bool_type = (vala_code_node_unref (self->bool_type), NULL)), _tmp3);
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_code_node_unref (_tmp2), NULL));
	_tmp5 = NULL;
	_tmp4 = NULL;
	self->char_type = (_tmp5 = (ValaDataType*) vala_value_type_new (_tmp4 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "char"))), (self->char_type == NULL) ? NULL : (self->char_type = (vala_code_node_unref (self->char_type), NULL)), _tmp5);
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_code_node_unref (_tmp4), NULL));
	_tmp7 = NULL;
	_tmp6 = NULL;
	self->uchar_type = (_tmp7 = (ValaDataType*) vala_value_type_new (_tmp6 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "uchar"))), (self->uchar_type == NULL) ? NULL : (self->uchar_type = (vala_code_node_unref (self->uchar_type), NULL)), _tmp7);
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_code_node_unref (_tmp6), NULL));
	_tmp9 = NULL;
	_tmp8 = NULL;
	self->unichar_type = (_tmp9 = (ValaDataType*) vala_value_type_new (_tmp8 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "unichar"))), (self->unichar_type == NULL) ? NULL : (self->unichar_type = (vala_code_node_unref (self->unichar_type), NULL)), _tmp9);
	(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_code_node_unref (_tmp8), NULL));
	_tmp11 = NULL;
	_tmp10 = NULL;
	self->short_type = (_tmp11 = (ValaDataType*) vala_value_type_new (_tmp10 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "short"))), (self->short_type == NULL) ? NULL : (self->short_type = (vala_code_node_unref (self->short_type), NULL)), _tmp11);
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_code_node_unref (_tmp10), NULL));
	_tmp13 = NULL;
	_tmp12 = NULL;
	self->ushort_type = (_tmp13 = (ValaDataType*) vala_value_type_new (_tmp12 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "ushort"))), (self->ushort_type == NULL) ? NULL : (self->ushort_type = (vala_code_node_unref (self->ushort_type), NULL)), _tmp13);
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_code_node_unref (_tmp12), NULL));
	_tmp15 = NULL;
	_tmp14 = NULL;
	self->int_type = (_tmp15 = (ValaDataType*) vala_value_type_new (_tmp14 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "int"))), (self->int_type == NULL) ? NULL : (self->int_type = (vala_code_node_unref (self->int_type), NULL)), _tmp15);
	(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_code_node_unref (_tmp14), NULL));
	_tmp17 = NULL;
	_tmp16 = NULL;
	self->uint_type = (_tmp17 = (ValaDataType*) vala_value_type_new (_tmp16 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "uint"))), (self->uint_type == NULL) ? NULL : (self->uint_type = (vala_code_node_unref (self->uint_type), NULL)), _tmp17);
	(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_code_node_unref (_tmp16), NULL));
	_tmp19 = NULL;
	_tmp18 = NULL;
	self->long_type = (_tmp19 = (ValaDataType*) vala_value_type_new (_tmp18 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "long"))), (self->long_type == NULL) ? NULL : (self->long_type = (vala_code_node_unref (self->long_type), NULL)), _tmp19);
	(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_code_node_unref (_tmp18), NULL));
	_tmp21 = NULL;
	_tmp20 = NULL;
	self->ulong_type = (_tmp21 = (ValaDataType*) vala_value_type_new (_tmp20 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "ulong"))), (self->ulong_type == NULL) ? NULL : (self->ulong_type = (vala_code_node_unref (self->ulong_type), NULL)), _tmp21);
	(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_code_node_unref (_tmp20), NULL));
	_tmp23 = NULL;
	_tmp22 = NULL;
	self->int8_type = (_tmp23 = (ValaDataType*) vala_value_type_new (_tmp22 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "int8"))), (self->int8_type == NULL) ? NULL : (self->int8_type = (vala_code_node_unref (self->int8_type), NULL)), _tmp23);
	(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_code_node_unref (_tmp22), NULL));
	_tmp25 = NULL;
	_tmp24 = NULL;
	self->uint8_type = (_tmp25 = (ValaDataType*) vala_value_type_new (_tmp24 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "uint8"))), (self->uint8_type == NULL) ? NULL : (self->uint8_type = (vala_code_node_unref (self->uint8_type), NULL)), _tmp25);
	(_tmp24 == NULL) ? NULL : (_tmp24 = (vala_code_node_unref (_tmp24), NULL));
	_tmp27 = NULL;
	_tmp26 = NULL;
	self->int32_type = (_tmp27 = (ValaDataType*) vala_value_type_new (_tmp26 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "int32"))), (self->int32_type == NULL) ? NULL : (self->int32_type = (vala_code_node_unref (self->int32_type), NULL)), _tmp27);
	(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_code_node_unref (_tmp26), NULL));
	_tmp29 = NULL;
	_tmp28 = NULL;
	self->uint32_type = (_tmp29 = (ValaDataType*) vala_value_type_new (_tmp28 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "uint32"))), (self->uint32_type == NULL) ? NULL : (self->uint32_type = (vala_code_node_unref (self->uint32_type), NULL)), _tmp29);
	(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_code_node_unref (_tmp28), NULL));
	_tmp31 = NULL;
	_tmp30 = NULL;
	self->int64_type = (_tmp31 = (ValaDataType*) vala_value_type_new (_tmp30 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "int64"))), (self->int64_type == NULL) ? NULL : (self->int64_type = (vala_code_node_unref (self->int64_type), NULL)), _tmp31);
	(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_code_node_unref (_tmp30), NULL));
	_tmp33 = NULL;
	_tmp32 = NULL;
	self->uint64_type = (_tmp33 = (ValaDataType*) vala_value_type_new (_tmp32 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "uint64"))), (self->uint64_type == NULL) ? NULL : (self->uint64_type = (vala_code_node_unref (self->uint64_type), NULL)), _tmp33);
	(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_code_node_unref (_tmp32), NULL));
	_tmp35 = NULL;
	_tmp34 = NULL;
	self->float_type = (_tmp35 = (ValaDataType*) vala_value_type_new (_tmp34 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "float"))), (self->float_type == NULL) ? NULL : (self->float_type = (vala_code_node_unref (self->float_type), NULL)), _tmp35);
	(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_code_node_unref (_tmp34), NULL));
	_tmp37 = NULL;
	_tmp36 = NULL;
	self->double_type = (_tmp37 = (ValaDataType*) vala_value_type_new (_tmp36 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "double"))), (self->double_type == NULL) ? NULL : (self->double_type = (vala_code_node_unref (self->double_type), NULL)), _tmp37);
	(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_code_node_unref (_tmp36), NULL));
	_tmp39 = NULL;
	_tmp38 = NULL;
	self->string_type = (_tmp39 = (ValaDataType*) vala_object_type_new ((ValaObjectTypeSymbol*) (_tmp38 = VALA_CLASS (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "string")))), (self->string_type == NULL) ? NULL : (self->string_type = (vala_code_node_unref (self->string_type), NULL)), _tmp39);
	(_tmp38 == NULL) ? NULL : (_tmp38 = (vala_code_node_unref (_tmp38), NULL));
	_tmp40 = NULL;
	self->substring_method = (_tmp40 = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) vala_data_type_get_data_type (self->string_type)), "substring")), (self->substring_method == NULL) ? NULL : (self->substring_method = (vala_code_node_unref (self->substring_method), NULL)), _tmp40);
	glib_ns = vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "GLib");
	_tmp41 = NULL;
	self->gtype_type = (_tmp41 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Type")), (self->gtype_type == NULL) ? NULL : (self->gtype_type = (vala_code_node_unref (self->gtype_type), NULL)), _tmp41);
	_tmp42 = NULL;
	self->gobject_type = (_tmp42 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Object")), (self->gobject_type == NULL) ? NULL : (self->gobject_type = (vala_code_node_unref (self->gobject_type), NULL)), _tmp42);
	_tmp43 = NULL;
	self->gerror_type = (_tmp43 = vala_error_type_new (NULL, NULL, NULL), (self->gerror_type == NULL) ? NULL : (self->gerror_type = (vala_code_node_unref (self->gerror_type), NULL)), _tmp43);
	_tmp44 = NULL;
	self->glist_type = (_tmp44 = VALA_CLASS (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "List")), (self->glist_type == NULL) ? NULL : (self->glist_type = (vala_code_node_unref (self->glist_type), NULL)), _tmp44);
	_tmp45 = NULL;
	self->gslist_type = (_tmp45 = VALA_CLASS (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "SList")), (self->gslist_type == NULL) ? NULL : (self->gslist_type = (vala_code_node_unref (self->gslist_type), NULL)), _tmp45);
	_tmp46 = NULL;
	self->gstringbuilder_type = (_tmp46 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "StringBuilder")), (self->gstringbuilder_type == NULL) ? NULL : (self->gstringbuilder_type = (vala_code_node_unref (self->gstringbuilder_type), NULL)), _tmp46);
	_tmp47 = NULL;
	self->garray_type = (_tmp47 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Array")), (self->garray_type == NULL) ? NULL : (self->garray_type = (vala_code_node_unref (self->garray_type), NULL)), _tmp47);
	_tmp49 = NULL;
	_tmp48 = NULL;
	self->gquark_type = (_tmp49 = (ValaDataType*) vala_value_type_new (_tmp48 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Quark"))), (self->gquark_type == NULL) ? NULL : (self->gquark_type = (vala_code_node_unref (self->gquark_type), NULL)), _tmp49);
	(_tmp48 == NULL) ? NULL : (_tmp48 = (vala_code_node_unref (_tmp48), NULL));
	_tmp50 = NULL;
	self->gvalue_type = (_tmp50 = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Value")), (self->gvalue_type == NULL) ? NULL : (self->gvalue_type = (vala_code_node_unref (self->gvalue_type), NULL)), _tmp50);
	_tmp51 = NULL;
	self->mutex_type = (_tmp51 = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "StaticRecMutex")), (self->mutex_type == NULL) ? NULL : (self->mutex_type = (vala_code_node_unref (self->mutex_type), NULL)), _tmp51);
	_tmp52 = NULL;
	self->type_module_type = (_tmp52 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "TypeModule")), (self->type_module_type == NULL) ? NULL : (self->type_module_type = (vala_code_node_unref (self->type_module_type), NULL)), _tmp52);
	if (vala_code_context_get_module_init_method (context) != NULL) {
		ValaCCodeFragment* _tmp53;
		_tmp53 = NULL;
		self->module_init_fragment = (_tmp53 = vala_ccode_fragment_new (), (self->module_init_fragment == NULL) ? NULL : (self->module_init_fragment = (vala_ccode_node_unref (self->module_init_fragment), NULL)), _tmp53);
		{
			GeeList* _tmp54;
			GeeIterator* _tmp55;
			GeeIterator* parameter_it;
			_tmp54 = NULL;
			_tmp55 = NULL;
			parameter_it = (_tmp55 = gee_iterable_iterator ((GeeIterable*) (_tmp54 = vala_method_get_parameters (vala_code_context_get_module_init_method (context)))), (_tmp54 == NULL) ? NULL : (_tmp54 = (gee_collection_object_unref (_tmp54), NULL)), _tmp55);
			while (gee_iterator_next (parameter_it)) {
				ValaFormalParameter* parameter;
				parameter = (ValaFormalParameter*) gee_iterator_get (parameter_it);
				if (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (parameter)) == self->type_module_type) {
					char* _tmp57;
					const char* _tmp56;
					self->in_plugin = TRUE;
					_tmp57 = NULL;
					_tmp56 = NULL;
					self->module_init_param_name = (_tmp57 = (_tmp56 = vala_symbol_get_name ((ValaSymbol*) parameter), (_tmp56 == NULL) ? NULL : g_strdup (_tmp56)), self->module_init_param_name = (g_free (self->module_init_param_name), NULL), _tmp57);
					(parameter == NULL) ? NULL : (parameter = (vala_code_node_unref (parameter), NULL));
					break;
				}
				(parameter == NULL) ? NULL : (parameter = (vala_code_node_unref (parameter), NULL));
			}
			(parameter_it == NULL) ? NULL : (parameter_it = (gee_collection_object_unref (parameter_it), NULL));
		}
	}
	gee_ns = vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "Gee");
	if (gee_ns != NULL) {
		ValaInterface* _tmp58;
		ValaInterface* _tmp59;
		_tmp58 = NULL;
		self->list_type = (_tmp58 = VALA_INTERFACE (vala_scope_lookup (vala_symbol_get_scope (gee_ns), "List")), (self->list_type == NULL) ? NULL : (self->list_type = (vala_code_node_unref (self->list_type), NULL)), _tmp58);
		_tmp59 = NULL;
		self->map_type = (_tmp59 = VALA_INTERFACE (vala_scope_lookup (vala_symbol_get_scope (gee_ns), "Map")), (self->map_type == NULL) ? NULL : (self->map_type = (vala_code_node_unref (self->map_type), NULL)), _tmp59);
	}
	dbus_ns = vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "DBus");
	if (dbus_ns != NULL) {
		ValaTypeSymbol* _tmp60;
		_tmp60 = NULL;
		self->dbus_object_type = (_tmp60 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (dbus_ns), "Object")), (self->dbus_object_type == NULL) ? NULL : (self->dbus_object_type = (vala_code_node_unref (self->dbus_object_type), NULL)), _tmp60);
	}
	/* we're only interested in non-pkg source files */
	source_files = vala_code_context_get_source_files (context);
	{
		GeeIterator* file_it;
		file_it = gee_iterable_iterator ((GeeIterable*) source_files);
		while (gee_iterator_next (file_it)) {
			ValaSourceFile* file;
			file = (ValaSourceFile*) gee_iterator_get (file_it);
			if (!vala_source_file_get_external_package (file)) {
				vala_source_file_accept (file, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
			}
			(file == NULL) ? NULL : (file = (vala_source_file_unref (file), NULL));
		}
		(file_it == NULL) ? NULL : (file_it = (gee_collection_object_unref (file_it), NULL));
	}
	(glib_ns == NULL) ? NULL : (glib_ns = (vala_code_node_unref (glib_ns), NULL));
	(gee_ns == NULL) ? NULL : (gee_ns = (vala_code_node_unref (gee_ns), NULL));
	(dbus_ns == NULL) ? NULL : (dbus_ns = (vala_code_node_unref (dbus_ns), NULL));
	(source_files == NULL) ? NULL : (source_files = (gee_collection_object_unref (source_files), NULL));
}


static void vala_ccode_base_module_real_visit_enum (ValaCCodeModule* base, ValaEnum* en) {
	ValaCCodeBaseModule * self;
	ValaCCodeEnum* _tmp1;
	char* _tmp0;
	ValaCCodeFragment* decl_frag;
	ValaCCodeFragment* def_frag;
	ValaCCodeNewline* _tmp11;
	ValaCCodeNewline* _tmp12;
	char* _tmp13;
	char* _tmp14;
	char* macro;
	ValaCCodeMacroReplacement* _tmp16;
	char* _tmp15;
	ValaCCodeInitializerList* clist;
	ValaCCodeInitializerList* clist_ev;
	ValaCCodeInitializerList* _tmp26;
	ValaCCodeConstant* _tmp27;
	ValaCCodeConstant* _tmp28;
	ValaCCodeConstant* _tmp29;
	ValaCCodeVariableDeclarator* enum_decl;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeBlock* type_init;
	char* _tmp32;
	char* _tmp33;
	char* fun_name;
	ValaCCodeFunction* regfun;
	ValaCCodeBlock* regblock;
	ValaCCodeDeclaration* _tmp34;
	char* _tmp35;
	char* _tmp36;
	char* type_id_name;
	ValaCCodeVariableDeclarator* _tmp38;
	ValaCCodeConstant* _tmp37;
	ValaCCodeFunctionCall* reg_call;
	ValaCCodeConstant* _tmp45;
	char* _tmp44;
	char* _tmp43;
	ValaCCodeIdentifier* _tmp46;
	ValaCCodeExpressionStatement* _tmp49;
	ValaCCodeAssignment* _tmp48;
	ValaCCodeIdentifier* _tmp47;
	ValaCCodeIdentifier* _tmp50;
	ValaCCodeFunctionCall* _tmp51;
	ValaCCodeFunctionCall* cond;
	ValaCCodeBinaryExpression* _tmp54;
	ValaCCodeConstant* _tmp53;
	ValaCCodeIdentifier* _tmp52;
	ValaCCodeIfStatement* cif;
	ValaCCodeReturnStatement* _tmp56;
	ValaCCodeConstant* _tmp55;
	ValaCCodeNewline* _tmp59;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (en != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->cenum = (_tmp1 = vala_ccode_enum_new (_tmp0 = vala_typesymbol_get_cname ((ValaTypeSymbol*) en, FALSE)), (self->cenum == NULL) ? NULL : (self->cenum = (vala_ccode_node_unref (self->cenum), NULL)), _tmp1);
	_tmp0 = (g_free (_tmp0), NULL);
	decl_frag = NULL;
	def_frag = NULL;
	if (vala_symbol_get_access ((ValaSymbol*) en) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeFragment* _tmp3;
		ValaCCodeFragment* _tmp2;
		ValaCCodeFragment* _tmp5;
		ValaCCodeFragment* _tmp4;
		_tmp3 = NULL;
		_tmp2 = NULL;
		decl_frag = (_tmp3 = (_tmp2 = self->header_type_declaration, (_tmp2 == NULL) ? NULL : vala_ccode_node_ref (_tmp2)), (decl_frag == NULL) ? NULL : (decl_frag = (vala_ccode_node_unref (decl_frag), NULL)), _tmp3);
		_tmp5 = NULL;
		_tmp4 = NULL;
		def_frag = (_tmp5 = (_tmp4 = self->header_type_definition, (_tmp4 == NULL) ? NULL : vala_ccode_node_ref (_tmp4)), (def_frag == NULL) ? NULL : (def_frag = (vala_ccode_node_unref (def_frag), NULL)), _tmp5);
	} else {
		ValaCCodeFragment* _tmp7;
		ValaCCodeFragment* _tmp6;
		ValaCCodeFragment* _tmp9;
		ValaCCodeFragment* _tmp8;
		_tmp7 = NULL;
		_tmp6 = NULL;
		decl_frag = (_tmp7 = (_tmp6 = self->source_type_declaration, (_tmp6 == NULL) ? NULL : vala_ccode_node_ref (_tmp6)), (decl_frag == NULL) ? NULL : (decl_frag = (vala_ccode_node_unref (decl_frag), NULL)), _tmp7);
		_tmp9 = NULL;
		_tmp8 = NULL;
		def_frag = (_tmp9 = (_tmp8 = self->source_type_definition, (_tmp8 == NULL) ? NULL : vala_ccode_node_ref (_tmp8)), (def_frag == NULL) ? NULL : (def_frag = (vala_ccode_node_unref (def_frag), NULL)), _tmp9);
	}
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) en)) != NULL) {
		ValaCCodeComment* _tmp10;
		_tmp10 = NULL;
		vala_ccode_fragment_append (def_frag, (ValaCCodeNode*) (_tmp10 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) en)))));
		(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	}
	vala_ccode_fragment_append (def_frag, (ValaCCodeNode*) self->cenum);
	_tmp11 = NULL;
	vala_ccode_fragment_append (def_frag, (ValaCCodeNode*) (_tmp11 = vala_ccode_newline_new ()));
	(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
	vala_code_node_accept_children ((ValaCodeNode*) en, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (!vala_enum_get_has_type_id (en)) {
		(decl_frag == NULL) ? NULL : (decl_frag = (vala_ccode_node_unref (decl_frag), NULL));
		(def_frag == NULL) ? NULL : (def_frag = (vala_ccode_node_unref (def_frag), NULL));
		return;
	}
	_tmp12 = NULL;
	vala_ccode_fragment_append (decl_frag, (ValaCCodeNode*) (_tmp12 = vala_ccode_newline_new ()));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	_tmp13 = NULL;
	_tmp14 = NULL;
	macro = (_tmp14 = g_strdup_printf ("(%s_get_type ())", _tmp13 = vala_symbol_get_lower_case_cname ((ValaSymbol*) en, NULL)), _tmp13 = (g_free (_tmp13), NULL), _tmp14);
	_tmp16 = NULL;
	_tmp15 = NULL;
	vala_ccode_fragment_append (decl_frag, (ValaCCodeNode*) (_tmp16 = vala_ccode_macro_replacement_new (_tmp15 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) en), macro)));
	(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
	_tmp15 = (g_free (_tmp15), NULL);
	clist = vala_ccode_initializer_list_new ();
	/* or during visit time? */
	clist_ev = NULL;
	{
		GeeList* _tmp17;
		GeeIterator* _tmp18;
		GeeIterator* ev_it;
		_tmp17 = NULL;
		_tmp18 = NULL;
		ev_it = (_tmp18 = gee_iterable_iterator ((GeeIterable*) (_tmp17 = vala_enum_get_values (en))), (_tmp17 == NULL) ? NULL : (_tmp17 = (gee_collection_object_unref (_tmp17), NULL)), _tmp18);
		while (gee_iterator_next (ev_it)) {
			ValaEnumValue* ev;
			ValaCCodeInitializerList* _tmp19;
			ValaCCodeConstant* _tmp21;
			char* _tmp20;
			ValaCCodeIdentifier* _tmp24;
			char* _tmp23;
			char* _tmp22;
			ValaCCodeConstant* _tmp25;
			ev = (ValaEnumValue*) gee_iterator_get (ev_it);
			_tmp19 = NULL;
			clist_ev = (_tmp19 = vala_ccode_initializer_list_new (), (clist_ev == NULL) ? NULL : (clist_ev = (vala_ccode_node_unref (clist_ev), NULL)), _tmp19);
			_tmp21 = NULL;
			_tmp20 = NULL;
			vala_ccode_initializer_list_append (clist_ev, (ValaCCodeExpression*) (_tmp21 = vala_ccode_constant_new (_tmp20 = vala_enum_value_get_cname (ev))));
			(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
			_tmp20 = (g_free (_tmp20), NULL);
			_tmp24 = NULL;
			_tmp23 = NULL;
			_tmp22 = NULL;
			vala_ccode_initializer_list_append (clist_ev, (ValaCCodeExpression*) (_tmp24 = vala_ccode_identifier_new (_tmp23 = g_strdup_printf ("\"%s\"", _tmp22 = vala_enum_value_get_cname (ev)))));
			(_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL));
			_tmp23 = (g_free (_tmp23), NULL);
			_tmp22 = (g_free (_tmp22), NULL);
			_tmp25 = NULL;
			vala_ccode_initializer_list_append (clist_ev, (ValaCCodeExpression*) (_tmp25 = vala_enum_value_get_canonical_cconstant (ev)));
			(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
			vala_ccode_initializer_list_append (clist, (ValaCCodeExpression*) clist_ev);
			(ev == NULL) ? NULL : (ev = (vala_code_node_unref (ev), NULL));
		}
		(ev_it == NULL) ? NULL : (ev_it = (gee_collection_object_unref (ev_it), NULL));
	}
	_tmp26 = NULL;
	clist_ev = (_tmp26 = vala_ccode_initializer_list_new (), (clist_ev == NULL) ? NULL : (clist_ev = (vala_ccode_node_unref (clist_ev), NULL)), _tmp26);
	_tmp27 = NULL;
	vala_ccode_initializer_list_append (clist_ev, (ValaCCodeExpression*) (_tmp27 = vala_ccode_constant_new ("0")));
	(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
	_tmp28 = NULL;
	vala_ccode_initializer_list_append (clist_ev, (ValaCCodeExpression*) (_tmp28 = vala_ccode_constant_new ("NULL")));
	(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
	_tmp29 = NULL;
	vala_ccode_initializer_list_append (clist_ev, (ValaCCodeExpression*) (_tmp29 = vala_ccode_constant_new ("NULL")));
	(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
	vala_ccode_initializer_list_append (clist, (ValaCCodeExpression*) clist_ev);
	enum_decl = vala_ccode_variable_declarator_new_with_initializer ("values[]", (ValaCCodeExpression*) clist);
	cdecl_ = NULL;
	if (vala_enum_get_is_flags (en)) {
		ValaCCodeDeclaration* _tmp30;
		_tmp30 = NULL;
		cdecl_ = (_tmp30 = vala_ccode_declaration_new ("const GFlagsValue"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp30);
	} else {
		ValaCCodeDeclaration* _tmp31;
		_tmp31 = NULL;
		cdecl_ = (_tmp31 = vala_ccode_declaration_new ("const GEnumValue"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp31);
	}
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) enum_decl);
	vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	type_init = vala_ccode_block_new ();
	vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) cdecl_);
	_tmp32 = NULL;
	_tmp33 = NULL;
	fun_name = (_tmp33 = g_strdup_printf ("%s_get_type", _tmp32 = vala_symbol_get_lower_case_cname ((ValaSymbol*) en, NULL)), _tmp32 = (g_free (_tmp32), NULL), _tmp33);
	regfun = vala_ccode_function_new (fun_name, "GType");
	regblock = vala_ccode_block_new ();
	_tmp34 = NULL;
	cdecl_ = (_tmp34 = vala_ccode_declaration_new ("GType"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp34);
	_tmp35 = NULL;
	_tmp36 = NULL;
	type_id_name = (_tmp36 = g_strdup_printf ("%s_type_id", _tmp35 = vala_symbol_get_lower_case_cname ((ValaSymbol*) en, NULL)), _tmp35 = (g_free (_tmp35), NULL), _tmp36);
	_tmp38 = NULL;
	_tmp37 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp38 = vala_ccode_variable_declarator_new_with_initializer (type_id_name, (ValaCCodeExpression*) (_tmp37 = vala_ccode_constant_new ("0")))));
	(_tmp38 == NULL) ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL));
	(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
	vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	vala_ccode_block_add_statement (regblock, (ValaCCodeNode*) cdecl_);
	reg_call = NULL;
	if (vala_enum_get_is_flags (en)) {
		ValaCCodeFunctionCall* _tmp40;
		ValaCCodeIdentifier* _tmp39;
		_tmp40 = NULL;
		_tmp39 = NULL;
		reg_call = (_tmp40 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp39 = vala_ccode_identifier_new ("g_flags_register_static"))), (reg_call == NULL) ? NULL : (reg_call = (vala_ccode_node_unref (reg_call), NULL)), _tmp40);
		(_tmp39 == NULL) ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL));
	} else {
		ValaCCodeFunctionCall* _tmp42;
		ValaCCodeIdentifier* _tmp41;
		_tmp42 = NULL;
		_tmp41 = NULL;
		reg_call = (_tmp42 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp41 = vala_ccode_identifier_new ("g_enum_register_static"))), (reg_call == NULL) ? NULL : (reg_call = (vala_ccode_node_unref (reg_call), NULL)), _tmp42);
		(_tmp41 == NULL) ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL));
	}
	_tmp45 = NULL;
	_tmp44 = NULL;
	_tmp43 = NULL;
	vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp45 = vala_ccode_constant_new (_tmp44 = g_strdup_printf ("\"%s\"", _tmp43 = vala_typesymbol_get_cname ((ValaTypeSymbol*) en, FALSE)))));
	(_tmp45 == NULL) ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL));
	_tmp44 = (g_free (_tmp44), NULL);
	_tmp43 = (g_free (_tmp43), NULL);
	_tmp46 = NULL;
	vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp46 = vala_ccode_identifier_new ("values")));
	(_tmp46 == NULL) ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL));
	_tmp49 = NULL;
	_tmp48 = NULL;
	_tmp47 = NULL;
	vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) (_tmp49 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp48 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp47 = vala_ccode_identifier_new (type_id_name)), (ValaCCodeExpression*) reg_call, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp49 == NULL) ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL));
	(_tmp48 == NULL) ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL));
	(_tmp47 == NULL) ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL));
	_tmp50 = NULL;
	_tmp51 = NULL;
	cond = (_tmp51 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp50 = vala_ccode_identifier_new ("G_UNLIKELY"))), (_tmp50 == NULL) ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL)), _tmp51);
	_tmp54 = NULL;
	_tmp53 = NULL;
	_tmp52 = NULL;
	vala_ccode_function_call_add_argument (cond, (ValaCCodeExpression*) (_tmp54 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) (_tmp52 = vala_ccode_identifier_new (type_id_name)), (ValaCCodeExpression*) (_tmp53 = vala_ccode_constant_new ("0")))));
	(_tmp54 == NULL) ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL));
	(_tmp53 == NULL) ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL));
	(_tmp52 == NULL) ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL));
	cif = vala_ccode_if_statement_new ((ValaCCodeExpression*) cond, (ValaCCodeStatement*) type_init, NULL);
	vala_ccode_block_add_statement (regblock, (ValaCCodeNode*) cif);
	_tmp56 = NULL;
	_tmp55 = NULL;
	vala_ccode_block_add_statement (regblock, (ValaCCodeNode*) (_tmp56 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp55 = vala_ccode_constant_new (type_id_name)))));
	(_tmp56 == NULL) ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL));
	(_tmp55 == NULL) ? NULL : (_tmp55 = (vala_ccode_node_unref (_tmp55), NULL));
	if (vala_symbol_get_access ((ValaSymbol*) en) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeFunction* _tmp57;
		_tmp57 = NULL;
		vala_ccode_fragment_append (self->header_type_member_declaration, (ValaCCodeNode*) (_tmp57 = vala_ccode_function_copy (regfun)));
		(_tmp57 == NULL) ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL));
	} else {
		ValaCCodeFunction* _tmp58;
		_tmp58 = NULL;
		vala_ccode_fragment_append (self->source_type_member_declaration, (ValaCCodeNode*) (_tmp58 = vala_ccode_function_copy (regfun)));
		(_tmp58 == NULL) ? NULL : (_tmp58 = (vala_ccode_node_unref (_tmp58), NULL));
	}
	vala_ccode_function_set_block (regfun, regblock);
	_tmp59 = NULL;
	vala_ccode_fragment_append (self->source_type_member_definition, (ValaCCodeNode*) (_tmp59 = vala_ccode_newline_new ()));
	(_tmp59 == NULL) ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL));
	vala_ccode_fragment_append (self->source_type_member_definition, (ValaCCodeNode*) regfun);
	(decl_frag == NULL) ? NULL : (decl_frag = (vala_ccode_node_unref (decl_frag), NULL));
	(def_frag == NULL) ? NULL : (def_frag = (vala_ccode_node_unref (def_frag), NULL));
	macro = (g_free (macro), NULL);
	(clist == NULL) ? NULL : (clist = (vala_ccode_node_unref (clist), NULL));
	(clist_ev == NULL) ? NULL : (clist_ev = (vala_ccode_node_unref (clist_ev), NULL));
	(enum_decl == NULL) ? NULL : (enum_decl = (vala_ccode_node_unref (enum_decl), NULL));
	(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
	(type_init == NULL) ? NULL : (type_init = (vala_ccode_node_unref (type_init), NULL));
	fun_name = (g_free (fun_name), NULL);
	(regfun == NULL) ? NULL : (regfun = (vala_ccode_node_unref (regfun), NULL));
	(regblock == NULL) ? NULL : (regblock = (vala_ccode_node_unref (regblock), NULL));
	type_id_name = (g_free (type_id_name), NULL);
	(reg_call == NULL) ? NULL : (reg_call = (vala_ccode_node_unref (reg_call), NULL));
	(cond == NULL) ? NULL : (cond = (vala_ccode_node_unref (cond), NULL));
	(cif == NULL) ? NULL : (cif = (vala_ccode_node_unref (cif), NULL));
}


static void vala_ccode_base_module_real_visit_enum_value (ValaCCodeModule* base, ValaEnumValue* ev) {
	ValaCCodeBaseModule * self;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (ev != NULL);
	if (vala_enum_value_get_value (ev) == NULL) {
		ValaCCodeEnumValue* _tmp1;
		char* _tmp0;
		_tmp1 = NULL;
		_tmp0 = NULL;
		vala_ccode_enum_add_value (self->cenum, _tmp1 = vala_ccode_enum_value_new (_tmp0 = vala_enum_value_get_cname (ev), NULL));
		(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
		_tmp0 = (g_free (_tmp0), NULL);
	} else {
		ValaCCodeEnumValue* _tmp3;
		char* _tmp2;
		vala_code_node_accept ((ValaCodeNode*) vala_enum_value_get_value (ev), (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
		_tmp3 = NULL;
		_tmp2 = NULL;
		vala_ccode_enum_add_value (self->cenum, _tmp3 = vala_ccode_enum_value_new (_tmp2 = vala_enum_value_get_cname (ev), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_enum_value_get_value (ev)))));
		(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
		_tmp2 = (g_free (_tmp2), NULL);
	}
}


static void vala_ccode_base_module_real_visit_member (ValaCCodeModule* base, ValaMember* m) {
	ValaCCodeBaseModule * self;
	gboolean _tmp0;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (m != NULL);
	_tmp0 = FALSE;
	if (VALA_IS_LOCKABLE (m)) {
		_tmp0 = vala_lockable_get_lock_used ((VALA_LOCKABLE (m)));
	} else {
		_tmp0 = FALSE;
	}
	/* stuff meant for all lockable members */
	if (_tmp0) {
		ValaCCodeExpression* l;
		ValaCCodeExpression* _tmp3;
		char* _tmp2;
		ValaCCodeMemberAccess* _tmp1;
		char* _tmp5;
		char* _tmp4;
		ValaCCodeIdentifier* _tmp7;
		char* _tmp6;
		ValaCCodeFunctionCall* _tmp8;
		ValaCCodeFunctionCall* initf;
		ValaCCodeUnaryExpression* _tmp9;
		ValaCCodeExpressionStatement* _tmp10;
		ValaCCodeIdentifier* _tmp11;
		ValaCCodeFunctionCall* _tmp12;
		ValaCCodeFunctionCall* fc;
		ValaCCodeUnaryExpression* _tmp13;
		l = (ValaCCodeExpression*) vala_ccode_identifier_new ("self");
		_tmp3 = NULL;
		_tmp2 = NULL;
		_tmp1 = NULL;
		l = (_tmp3 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp1 = vala_ccode_member_access_new_pointer (l, "priv")), _tmp2 = vala_ccode_base_module_get_symbol_lock_name (self, (ValaSymbol*) m)), (l == NULL) ? NULL : (l = (vala_ccode_node_unref (l), NULL)), _tmp3);
		_tmp2 = (g_free (_tmp2), NULL);
		(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
		_tmp5 = NULL;
		_tmp4 = NULL;
		vala_ccode_struct_add_field (self->instance_priv_struct, _tmp4 = vala_typesymbol_get_cname ((ValaTypeSymbol*) self->mutex_type, FALSE), _tmp5 = vala_ccode_base_module_get_symbol_lock_name (self, (ValaSymbol*) m));
		_tmp5 = (g_free (_tmp5), NULL);
		_tmp4 = (g_free (_tmp4), NULL);
		_tmp7 = NULL;
		_tmp6 = NULL;
		_tmp8 = NULL;
		initf = (_tmp8 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new (_tmp6 = vala_method_get_cname (vala_struct_get_default_construction_method (self->mutex_type))))), (_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)), _tmp6 = (g_free (_tmp6), NULL), _tmp8);
		_tmp9 = NULL;
		vala_ccode_function_call_add_argument (initf, (ValaCCodeExpression*) (_tmp9 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, l)));
		(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
		_tmp10 = NULL;
		vala_ccode_fragment_append (self->instance_init_fragment, (ValaCCodeNode*) (_tmp10 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) initf)));
		(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
		self->requires_free_checked = TRUE;
		_tmp11 = NULL;
		_tmp12 = NULL;
		fc = (_tmp12 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp11 = vala_ccode_identifier_new ("g_static_rec_mutex_free"))), (_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL)), _tmp12);
		_tmp13 = NULL;
		vala_ccode_function_call_add_argument (fc, (ValaCCodeExpression*) (_tmp13 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, l)));
		(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
		if (self->instance_finalize_fragment != NULL) {
			ValaCCodeExpressionStatement* _tmp14;
			_tmp14 = NULL;
			vala_ccode_fragment_append (self->instance_finalize_fragment, (ValaCCodeNode*) (_tmp14 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) fc)));
			(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
		}
		(l == NULL) ? NULL : (l = (vala_ccode_node_unref (l), NULL));
		(initf == NULL) ? NULL : (initf = (vala_ccode_node_unref (initf), NULL));
		(fc == NULL) ? NULL : (fc = (vala_ccode_node_unref (fc), NULL));
	}
}


static void vala_ccode_base_module_real_visit_constant (ValaCCodeModule* base, ValaConstant* c) {
	ValaCCodeBaseModule * self;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (c != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) c, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (!(VALA_IS_ARRAY_TYPE (vala_constant_get_type_reference (c)))) {
		char* _tmp0;
		ValaCCodeMacroReplacement* _tmp1;
		ValaCCodeMacroReplacement* cdefine;
		_tmp0 = NULL;
		_tmp1 = NULL;
		cdefine = (_tmp1 = vala_ccode_macro_replacement_new_with_expression (_tmp0 = vala_constant_get_cname (c), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_constant_get_initializer (c)))), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
		if (!vala_symbol_is_internal_symbol ((ValaSymbol*) c)) {
			vala_ccode_fragment_append (self->header_type_member_declaration, (ValaCCodeNode*) cdefine);
		} else {
			vala_ccode_fragment_append (self->source_type_member_declaration, (ValaCCodeNode*) cdefine);
		}
		(cdefine == NULL) ? NULL : (cdefine = (vala_ccode_node_unref (cdefine), NULL));
	} else {
		char* _tmp2;
		ValaCCodeDeclaration* _tmp3;
		ValaCCodeDeclaration* cdecl_;
		char* arr;
		ValaCCodeVariableDeclarator* _tmp7;
		char* _tmp6;
		char* _tmp5;
		_tmp2 = NULL;
		_tmp3 = NULL;
		cdecl_ = (_tmp3 = vala_ccode_declaration_new (_tmp2 = vala_data_type_get_const_cname (vala_constant_get_type_reference (c))), _tmp2 = (g_free (_tmp2), NULL), _tmp3);
		arr = g_strdup ("");
		if (VALA_IS_ARRAY_TYPE (vala_constant_get_type_reference (c))) {
			char* _tmp4;
			_tmp4 = NULL;
			arr = (_tmp4 = g_strdup ("[]"), arr = (g_free (arr), NULL), _tmp4);
		}
		_tmp7 = NULL;
		_tmp6 = NULL;
		_tmp5 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp7 = vala_ccode_variable_declarator_new_with_initializer (_tmp6 = g_strdup_printf ("%s%s", _tmp5 = vala_constant_get_cname (c), arr), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_constant_get_initializer (c))))));
		(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
		_tmp6 = (g_free (_tmp6), NULL);
		_tmp5 = (g_free (_tmp5), NULL);
		vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
		if (!vala_symbol_is_internal_symbol ((ValaSymbol*) c)) {
			vala_ccode_fragment_append (self->header_constant_declaration, (ValaCCodeNode*) cdecl_);
		} else {
			vala_ccode_fragment_append (self->source_constant_declaration, (ValaCCodeNode*) cdecl_);
		}
		(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
		arr = (g_free (arr), NULL);
	}
}


static void vala_ccode_base_module_real_visit_field (ValaCCodeModule* base, ValaField* f) {
	ValaCCodeBaseModule * self;
	ValaClass* _tmp1;
	ValaSymbol* _tmp0;
	ValaClass* cl;
	gboolean _tmp2;
	gboolean is_gtypeinstance;
	ValaCCodeExpression* lhs;
	ValaCCodeStruct* st;
	char* field_ctype;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (f != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) f, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	_tmp1 = NULL;
	_tmp0 = NULL;
	cl = (_tmp1 = (_tmp0 = vala_symbol_get_parent_symbol ((ValaSymbol*) f), VALA_IS_CLASS (_tmp0) ? ((ValaClass*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp2 = FALSE;
	if (cl != NULL) {
		_tmp2 = !vala_class_get_is_compact (cl);
	} else {
		_tmp2 = FALSE;
	}
	is_gtypeinstance = (_tmp2);
	lhs = NULL;
	st = NULL;
	field_ctype = vala_data_type_get_cname (vala_field_get_field_type (f));
	if (vala_field_get_is_volatile (f)) {
		char* _tmp3;
		_tmp3 = NULL;
		field_ctype = (_tmp3 = g_strconcat ("volatile ", field_ctype, NULL), field_ctype = (g_free (field_ctype), NULL), _tmp3);
	}
	if (vala_symbol_get_access ((ValaSymbol*) f) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
			ValaCCodeStruct* _tmp5;
			ValaCCodeStruct* _tmp4;
			ValaCCodeExpression* _tmp8;
			char* _tmp7;
			ValaCCodeIdentifier* _tmp6;
			_tmp5 = NULL;
			_tmp4 = NULL;
			st = (_tmp5 = (_tmp4 = self->instance_struct, (_tmp4 == NULL) ? NULL : vala_ccode_node_ref (_tmp4)), (st == NULL) ? NULL : (st = (vala_ccode_node_unref (st), NULL)), _tmp5);
			_tmp8 = NULL;
			_tmp7 = NULL;
			_tmp6 = NULL;
			lhs = (_tmp8 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp6 = vala_ccode_identifier_new ("self")), _tmp7 = vala_field_get_cname (f)), (lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL)), _tmp8);
			_tmp7 = (g_free (_tmp7), NULL);
			(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
		} else {
			if (vala_field_get_binding (f) == MEMBER_BINDING_CLASS) {
				ValaCCodeStruct* _tmp10;
				ValaCCodeStruct* _tmp9;
				_tmp10 = NULL;
				_tmp9 = NULL;
				st = (_tmp10 = (_tmp9 = self->type_struct, (_tmp9 == NULL) ? NULL : vala_ccode_node_ref (_tmp9)), (st == NULL) ? NULL : (st = (vala_ccode_node_unref (st), NULL)), _tmp10);
			} else {
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* _tmp12;
				char* _tmp11;
				char* _tmp13;
				ValaCCodeVariableDeclarator* _tmp14;
				ValaCCodeVariableDeclarator* var_decl;
				ValaCCodeExpression* _tmp15;
				ValaCCodeDeclaration* var_def;
				ValaCCodeExpression* _tmp18;
				char* _tmp17;
				cdecl_ = vala_ccode_declaration_new (field_ctype);
				_tmp12 = NULL;
				_tmp11 = NULL;
				vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp12 = vala_ccode_variable_declarator_new (_tmp11 = vala_field_get_cname (f))));
				(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
				_tmp11 = (g_free (_tmp11), NULL);
				vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_EXTERN);
				vala_ccode_fragment_append (self->header_type_member_declaration, (ValaCCodeNode*) cdecl_);
				_tmp13 = NULL;
				_tmp14 = NULL;
				var_decl = (_tmp14 = vala_ccode_variable_declarator_new (_tmp13 = vala_field_get_cname (f)), _tmp13 = (g_free (_tmp13), NULL), _tmp14);
				_tmp15 = NULL;
				vala_ccode_variable_declarator_set_initializer (var_decl, _tmp15 = vala_ccode_base_module_default_value_for_type (self, vala_field_get_field_type (f), TRUE));
				(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
				if (vala_field_get_initializer (f) != NULL) {
					ValaCCodeExpression* _tmp16;
					ValaCCodeExpression* init;
					_tmp16 = NULL;
					init = (_tmp16 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_field_get_initializer (f))), (_tmp16 == NULL) ? NULL : vala_ccode_node_ref (_tmp16));
					if (vala_ccode_base_module_is_constant_ccode_expression (self, init)) {
						vala_ccode_variable_declarator_set_initializer (var_decl, init);
					}
					(init == NULL) ? NULL : (init = (vala_ccode_node_unref (init), NULL));
				}
				var_def = vala_ccode_declaration_new (field_ctype);
				vala_ccode_declaration_add_declarator (var_def, (ValaCCodeDeclarator*) var_decl);
				vala_ccode_declaration_set_modifiers (var_def, VALA_CCODE_MODIFIERS_EXTERN);
				vala_ccode_fragment_append (self->source_type_member_declaration, (ValaCCodeNode*) var_def);
				_tmp18 = NULL;
				_tmp17 = NULL;
				lhs = (_tmp18 = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp17 = vala_field_get_cname (f)), (lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL)), _tmp18);
				_tmp17 = (g_free (_tmp17), NULL);
				(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
				(var_decl == NULL) ? NULL : (var_decl = (vala_ccode_node_unref (var_decl), NULL));
				(var_def == NULL) ? NULL : (var_def = (vala_ccode_node_unref (var_def), NULL));
			}
		}
	} else {
		if (vala_symbol_get_access ((ValaSymbol*) f) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
				if (is_gtypeinstance) {
					ValaCCodeStruct* _tmp20;
					ValaCCodeStruct* _tmp19;
					ValaCCodeExpression* _tmp24;
					char* _tmp23;
					ValaCCodeMemberAccess* _tmp22;
					ValaCCodeIdentifier* _tmp21;
					_tmp20 = NULL;
					_tmp19 = NULL;
					st = (_tmp20 = (_tmp19 = self->instance_priv_struct, (_tmp19 == NULL) ? NULL : vala_ccode_node_ref (_tmp19)), (st == NULL) ? NULL : (st = (vala_ccode_node_unref (st), NULL)), _tmp20);
					_tmp24 = NULL;
					_tmp23 = NULL;
					_tmp22 = NULL;
					_tmp21 = NULL;
					lhs = (_tmp24 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp22 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp21 = vala_ccode_identifier_new ("self")), "priv")), _tmp23 = vala_field_get_cname (f)), (lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL)), _tmp24);
					_tmp23 = (g_free (_tmp23), NULL);
					(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
					(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
				} else {
					ValaCCodeStruct* _tmp26;
					ValaCCodeStruct* _tmp25;
					ValaCCodeExpression* _tmp29;
					char* _tmp28;
					ValaCCodeIdentifier* _tmp27;
					_tmp26 = NULL;
					_tmp25 = NULL;
					st = (_tmp26 = (_tmp25 = self->instance_struct, (_tmp25 == NULL) ? NULL : vala_ccode_node_ref (_tmp25)), (st == NULL) ? NULL : (st = (vala_ccode_node_unref (st), NULL)), _tmp26);
					_tmp29 = NULL;
					_tmp28 = NULL;
					_tmp27 = NULL;
					lhs = (_tmp29 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp27 = vala_ccode_identifier_new ("self")), _tmp28 = vala_field_get_cname (f)), (lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL)), _tmp29);
					_tmp28 = (g_free (_tmp28), NULL);
					(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
				}
			} else {
				if (vala_field_get_binding (f) == MEMBER_BINDING_CLASS) {
					ValaCCodeStruct* _tmp31;
					ValaCCodeStruct* _tmp30;
					_tmp31 = NULL;
					_tmp30 = NULL;
					st = (_tmp31 = (_tmp30 = self->type_struct, (_tmp30 == NULL) ? NULL : vala_ccode_node_ref (_tmp30)), (st == NULL) ? NULL : (st = (vala_ccode_node_unref (st), NULL)), _tmp31);
				} else {
					ValaCCodeDeclaration* cdecl_;
					char* _tmp32;
					ValaCCodeVariableDeclarator* _tmp33;
					ValaCCodeVariableDeclarator* var_decl;
					ValaCCodeExpression* _tmp36;
					char* _tmp35;
					cdecl_ = vala_ccode_declaration_new (field_ctype);
					_tmp32 = NULL;
					_tmp33 = NULL;
					var_decl = (_tmp33 = vala_ccode_variable_declarator_new (_tmp32 = vala_field_get_cname (f)), _tmp32 = (g_free (_tmp32), NULL), _tmp33);
					if (vala_field_get_initializer (f) != NULL) {
						ValaCCodeExpression* _tmp34;
						ValaCCodeExpression* init;
						_tmp34 = NULL;
						init = (_tmp34 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_field_get_initializer (f))), (_tmp34 == NULL) ? NULL : vala_ccode_node_ref (_tmp34));
						if (vala_ccode_base_module_is_constant_ccode_expression (self, init)) {
							vala_ccode_variable_declarator_set_initializer (var_decl, init);
						}
						(init == NULL) ? NULL : (init = (vala_ccode_node_unref (init), NULL));
					}
					vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) var_decl);
					vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
					vala_ccode_fragment_append (self->source_type_member_declaration, (ValaCCodeNode*) cdecl_);
					_tmp36 = NULL;
					_tmp35 = NULL;
					lhs = (_tmp36 = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp35 = vala_field_get_cname (f)), (lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL)), _tmp36);
					_tmp35 = (g_free (_tmp35), NULL);
					(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
					(var_decl == NULL) ? NULL : (var_decl = (vala_ccode_node_unref (var_decl), NULL));
				}
			}
		}
	}
	if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
		char* _tmp37;
		gboolean _tmp38;
		gboolean _tmp54;
		_tmp37 = NULL;
		vala_ccode_struct_add_field (st, field_ctype, _tmp37 = vala_field_get_cname (f));
		_tmp37 = (g_free (_tmp37), NULL);
		_tmp38 = FALSE;
		if (VALA_IS_ARRAY_TYPE (vala_field_get_field_type (f))) {
			_tmp38 = !vala_field_get_no_array_length (f);
		} else {
			_tmp38 = FALSE;
		}
		if (_tmp38) {
			ValaArrayType* _tmp39;
			ValaArrayType* array_type;
			/* create fields to store array dimensions*/
			_tmp39 = NULL;
			array_type = (_tmp39 = VALA_ARRAY_TYPE (vala_field_get_field_type (f)), (_tmp39 == NULL) ? NULL : vala_code_node_ref (_tmp39));
			{
				gint dim;
				dim = 1;
				for (; dim <= vala_array_type_get_rank (array_type); dim++) {
					ValaDataType* len_type;
					char* _tmp41;
					char* _tmp40;
					len_type = vala_data_type_copy (self->int_type);
					_tmp41 = NULL;
					_tmp40 = NULL;
					vala_ccode_struct_add_field (st, _tmp40 = vala_data_type_get_cname (len_type), _tmp41 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_symbol_get_name ((ValaSymbol*) f), dim));
					_tmp41 = (g_free (_tmp41), NULL);
					_tmp40 = (g_free (_tmp40), NULL);
					(len_type == NULL) ? NULL : (len_type = (vala_code_node_unref (len_type), NULL));
				}
			}
			(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		} else {
			if (VALA_IS_DELEGATE_TYPE (vala_field_get_field_type (f))) {
				ValaDelegateType* _tmp42;
				ValaDelegateType* delegate_type;
				_tmp42 = NULL;
				delegate_type = (_tmp42 = VALA_DELEGATE_TYPE (vala_field_get_field_type (f)), (_tmp42 == NULL) ? NULL : vala_code_node_ref (_tmp42));
				if (vala_delegate_get_has_target (vala_delegate_type_get_delegate_symbol (delegate_type))) {
					char* _tmp43;
					/* create field to store delegate target*/
					_tmp43 = NULL;
					vala_ccode_struct_add_field (st, "gpointer", _tmp43 = vala_ccode_base_module_get_delegate_target_cname (self, vala_symbol_get_name ((ValaSymbol*) f)));
					_tmp43 = (g_free (_tmp43), NULL);
				}
				(delegate_type == NULL) ? NULL : (delegate_type = (vala_code_node_unref (delegate_type), NULL));
			}
		}
		if (vala_field_get_initializer (f) != NULL) {
			ValaCCodeExpression* _tmp44;
			ValaCCodeExpression* rhs;
			ValaCCodeExpressionStatement* _tmp46;
			ValaCCodeAssignment* _tmp45;
			gboolean _tmp47;
			gboolean _tmp48;
			_tmp44 = NULL;
			rhs = (_tmp44 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_field_get_initializer (f))), (_tmp44 == NULL) ? NULL : vala_ccode_node_ref (_tmp44));
			_tmp46 = NULL;
			_tmp45 = NULL;
			vala_ccode_fragment_append (self->instance_init_fragment, (ValaCCodeNode*) (_tmp46 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp45 = vala_ccode_assignment_new (lhs, rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp46 == NULL) ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL));
			(_tmp45 == NULL) ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL));
			_tmp47 = FALSE;
			_tmp48 = FALSE;
			if (VALA_IS_ARRAY_TYPE (vala_field_get_field_type (f))) {
				_tmp48 = !vala_field_get_no_array_length (f);
			} else {
				_tmp48 = FALSE;
			}
			if (_tmp48) {
				_tmp47 = VALA_IS_ARRAY_CREATION_EXPRESSION (vala_field_get_initializer (f));
			} else {
				_tmp47 = FALSE;
			}
			if (_tmp47) {
				ValaArrayType* _tmp49;
				ValaArrayType* array_type;
				ValaMemberAccess* this_access;
				ValaDataType* _tmp50;
				ValaCCodeIdentifier* _tmp51;
				ValaMemberAccess* ma;
				GeeList* sizes;
				_tmp49 = NULL;
				array_type = (_tmp49 = VALA_ARRAY_TYPE (vala_field_get_field_type (f)), (_tmp49 == NULL) ? NULL : vala_code_node_ref (_tmp49));
				this_access = vala_member_access_new_simple ("this", NULL);
				_tmp50 = NULL;
				vala_expression_set_value_type ((ValaExpression*) this_access, _tmp50 = vala_ccode_base_module_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) f))));
				(_tmp50 == NULL) ? NULL : (_tmp50 = (vala_code_node_unref (_tmp50), NULL));
				_tmp51 = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) this_access, (ValaCCodeNode*) (_tmp51 = vala_ccode_identifier_new ("self")));
				(_tmp51 == NULL) ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL));
				ma = vala_member_access_new ((ValaExpression*) this_access, vala_symbol_get_name ((ValaSymbol*) f), NULL);
				vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) f);
				sizes = vala_array_creation_expression_get_sizes ((VALA_ARRAY_CREATION_EXPRESSION (vala_field_get_initializer (f))));
				{
					gint dim;
					dim = 1;
					for (; dim <= vala_array_type_get_rank (array_type); dim++) {
						ValaCCodeExpression* array_len_lhs;
						ValaExpression* size;
						ValaCCodeExpressionStatement* _tmp53;
						ValaCCodeAssignment* _tmp52;
						array_len_lhs = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), (ValaExpression*) ma, dim);
						size = (ValaExpression*) gee_list_get ((GeeList*) sizes, dim - 1);
						_tmp53 = NULL;
						_tmp52 = NULL;
						vala_ccode_fragment_append (self->instance_init_fragment, (ValaCCodeNode*) (_tmp53 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp52 = vala_ccode_assignment_new (array_len_lhs, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) size)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
						(_tmp53 == NULL) ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL));
						(_tmp52 == NULL) ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL));
						(array_len_lhs == NULL) ? NULL : (array_len_lhs = (vala_ccode_node_unref (array_len_lhs), NULL));
						(size == NULL) ? NULL : (size = (vala_code_node_unref (size), NULL));
					}
				}
				(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
				(this_access == NULL) ? NULL : (this_access = (vala_code_node_unref (this_access), NULL));
				(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
				(sizes == NULL) ? NULL : (sizes = (gee_collection_object_unref (sizes), NULL));
			}
			(rhs == NULL) ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL));
		}
		_tmp54 = FALSE;
		if (vala_ccode_base_module_requires_destroy (self, vala_field_get_field_type (f))) {
			_tmp54 = self->instance_finalize_fragment != NULL;
		} else {
			_tmp54 = FALSE;
		}
		if (_tmp54) {
			ValaMemberAccess* this_access;
			ValaDataType* _tmp55;
			ValaStruct* _tmp57;
			ValaSymbol* _tmp56;
			ValaStruct* st;
			gboolean _tmp58;
			ValaMemberAccess* ma;
			ValaCCodeExpressionStatement* _tmp62;
			ValaCCodeExpression* _tmp61;
			this_access = vala_member_access_new_simple ("this", NULL);
			_tmp55 = NULL;
			vala_expression_set_value_type ((ValaExpression*) this_access, _tmp55 = vala_ccode_base_module_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) f))));
			(_tmp55 == NULL) ? NULL : (_tmp55 = (vala_code_node_unref (_tmp55), NULL));
			_tmp57 = NULL;
			_tmp56 = NULL;
			st = (_tmp57 = (_tmp56 = vala_symbol_get_parent_symbol ((ValaSymbol*) f), VALA_IS_STRUCT (_tmp56) ? ((ValaStruct*) _tmp56) : NULL), (_tmp57 == NULL) ? NULL : vala_code_node_ref (_tmp57));
			_tmp58 = FALSE;
			if (st != NULL) {
				_tmp58 = !vala_struct_is_simple_type (st);
			} else {
				_tmp58 = FALSE;
			}
			if (_tmp58) {
				ValaCCodeIdentifier* _tmp59;
				_tmp59 = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) this_access, (ValaCCodeNode*) (_tmp59 = vala_ccode_identifier_new ("(*self)")));
				(_tmp59 == NULL) ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL));
			} else {
				ValaCCodeIdentifier* _tmp60;
				_tmp60 = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) this_access, (ValaCCodeNode*) (_tmp60 = vala_ccode_identifier_new ("self")));
				(_tmp60 == NULL) ? NULL : (_tmp60 = (vala_ccode_node_unref (_tmp60), NULL));
			}
			ma = vala_member_access_new ((ValaExpression*) this_access, vala_symbol_get_name ((ValaSymbol*) f), NULL);
			vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) f);
			_tmp62 = NULL;
			_tmp61 = NULL;
			vala_ccode_fragment_append (self->instance_finalize_fragment, (ValaCCodeNode*) (_tmp62 = vala_ccode_expression_statement_new (_tmp61 = vala_ccode_base_module_get_unref_expression (self, lhs, vala_field_get_field_type (f), (ValaExpression*) ma))));
			(_tmp62 == NULL) ? NULL : (_tmp62 = (vala_ccode_node_unref (_tmp62), NULL));
			(_tmp61 == NULL) ? NULL : (_tmp61 = (vala_ccode_node_unref (_tmp61), NULL));
			(this_access == NULL) ? NULL : (this_access = (vala_code_node_unref (this_access), NULL));
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
			(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
		}
	} else {
		if (vala_field_get_binding (f) == MEMBER_BINDING_CLASS) {
			char* _tmp63;
			_tmp63 = NULL;
			vala_ccode_struct_add_field (st, field_ctype, _tmp63 = vala_field_get_cname (f));
			_tmp63 = (g_free (_tmp63), NULL);
		} else {
			gboolean _tmp64;
			_tmp64 = FALSE;
			if (VALA_IS_ARRAY_TYPE (vala_field_get_field_type (f))) {
				_tmp64 = !vala_field_get_no_array_length (f);
			} else {
				_tmp64 = FALSE;
			}
			/* add array length fields where necessary */
			if (_tmp64) {
				ValaArrayType* _tmp65;
				ValaArrayType* array_type;
				_tmp65 = NULL;
				array_type = (_tmp65 = VALA_ARRAY_TYPE (vala_field_get_field_type (f)), (_tmp65 == NULL) ? NULL : vala_code_node_ref (_tmp65));
				{
					gint dim;
					dim = 1;
					for (; dim <= vala_array_type_get_rank (array_type); dim++) {
						ValaDataType* len_type;
						char* _tmp66;
						ValaCCodeDeclaration* _tmp67;
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeVariableDeclarator* _tmp70;
						char* _tmp69;
						char* _tmp68;
						len_type = vala_data_type_copy (self->int_type);
						_tmp66 = NULL;
						_tmp67 = NULL;
						cdecl_ = (_tmp67 = vala_ccode_declaration_new (_tmp66 = vala_data_type_get_cname (len_type)), _tmp66 = (g_free (_tmp66), NULL), _tmp67);
						_tmp70 = NULL;
						_tmp69 = NULL;
						_tmp68 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp70 = vala_ccode_variable_declarator_new (_tmp69 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp68 = vala_field_get_cname (f), dim))));
						(_tmp70 == NULL) ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL));
						_tmp69 = (g_free (_tmp69), NULL);
						_tmp68 = (g_free (_tmp68), NULL);
						if (vala_symbol_get_access ((ValaSymbol*) f) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
							vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_EXTERN);
							vala_ccode_fragment_append (self->header_type_member_declaration, (ValaCCodeNode*) cdecl_);
						} else {
							vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
							vala_ccode_fragment_append (self->source_type_member_declaration, (ValaCCodeNode*) cdecl_);
						}
						(len_type == NULL) ? NULL : (len_type = (vala_code_node_unref (len_type), NULL));
						(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
					}
				}
				(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
			} else {
				if (VALA_IS_DELEGATE_TYPE (vala_field_get_field_type (f))) {
					ValaDelegateType* _tmp71;
					ValaDelegateType* delegate_type;
					_tmp71 = NULL;
					delegate_type = (_tmp71 = VALA_DELEGATE_TYPE (vala_field_get_field_type (f)), (_tmp71 == NULL) ? NULL : vala_code_node_ref (_tmp71));
					if (vala_delegate_get_has_target (vala_delegate_type_get_delegate_symbol (delegate_type))) {
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeVariableDeclarator* _tmp74;
						char* _tmp73;
						char* _tmp72;
						/* create field to store delegate target*/
						cdecl_ = vala_ccode_declaration_new ("gpointer");
						_tmp74 = NULL;
						_tmp73 = NULL;
						_tmp72 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp74 = vala_ccode_variable_declarator_new (_tmp73 = vala_ccode_base_module_get_delegate_target_cname (self, _tmp72 = vala_field_get_cname (f)))));
						(_tmp74 == NULL) ? NULL : (_tmp74 = (vala_ccode_node_unref (_tmp74), NULL));
						_tmp73 = (g_free (_tmp73), NULL);
						_tmp72 = (g_free (_tmp72), NULL);
						if (vala_symbol_get_access ((ValaSymbol*) f) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
							vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_EXTERN);
							vala_ccode_fragment_append (self->header_type_member_declaration, (ValaCCodeNode*) cdecl_);
						} else {
							vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
							vala_ccode_fragment_append (self->source_type_member_declaration, (ValaCCodeNode*) cdecl_);
						}
						(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
					}
					(delegate_type == NULL) ? NULL : (delegate_type = (vala_code_node_unref (delegate_type), NULL));
				}
			}
			if (vala_field_get_initializer (f) != NULL) {
				ValaCCodeExpression* _tmp75;
				ValaCCodeExpression* rhs;
				_tmp75 = NULL;
				rhs = (_tmp75 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_field_get_initializer (f))), (_tmp75 == NULL) ? NULL : vala_ccode_node_ref (_tmp75));
				if (!vala_ccode_base_module_is_constant_ccode_expression (self, rhs)) {
					if (VALA_IS_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) f))) {
						ValaCCodeExpressionStatement* _tmp77;
						ValaCCodeAssignment* _tmp76;
						_tmp77 = NULL;
						_tmp76 = NULL;
						vala_ccode_fragment_append (self->class_init_fragment, (ValaCCodeNode*) (_tmp77 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp76 = vala_ccode_assignment_new (lhs, rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
						(_tmp77 == NULL) ? NULL : (_tmp77 = (vala_ccode_node_unref (_tmp77), NULL));
						(_tmp76 == NULL) ? NULL : (_tmp76 = (vala_ccode_node_unref (_tmp76), NULL));
					} else {
						vala_code_node_set_error ((ValaCodeNode*) f, TRUE);
						vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) f), "Non-constant field initializers not supported in this context");
						(rhs == NULL) ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL));
						(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
						(lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL));
						(st == NULL) ? NULL : (st = (vala_ccode_node_unref (st), NULL));
						field_ctype = (g_free (field_ctype), NULL);
						return;
					}
				}
				(rhs == NULL) ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL));
			}
		}
	}
	(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	(lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL));
	(st == NULL) ? NULL : (st = (vala_ccode_node_unref (st), NULL));
	field_ctype = (g_free (field_ctype), NULL);
}


gboolean vala_ccode_base_module_is_constant_ccode_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* cexpr) {
	ValaCCodeParenthesizedExpression* _tmp5;
	ValaCCodeExpression* _tmp4;
	ValaCCodeParenthesizedExpression* cparenthesized;
	gboolean _tmp6;
	gboolean _tmp7;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cexpr != NULL, FALSE);
	if (VALA_IS_CCODE_CONSTANT (cexpr)) {
		return TRUE;
	} else {
		if (VALA_IS_CCODE_BINARY_EXPRESSION (cexpr)) {
			ValaCCodeBinaryExpression* _tmp1;
			ValaCCodeBinaryExpression* cbinary;
			gboolean _tmp2;
			gboolean _tmp3;
			_tmp1 = NULL;
			cbinary = (_tmp1 = VALA_CCODE_BINARY_EXPRESSION (cexpr), (_tmp1 == NULL) ? NULL : vala_ccode_node_ref (_tmp1));
			_tmp2 = FALSE;
			if (vala_ccode_base_module_is_constant_ccode_expression (self, vala_ccode_binary_expression_get_left (cbinary))) {
				_tmp2 = vala_ccode_base_module_is_constant_ccode_expression (self, vala_ccode_binary_expression_get_right (cbinary));
			} else {
				_tmp2 = FALSE;
			}
			return (_tmp3 = _tmp2, (cbinary == NULL) ? NULL : (cbinary = (vala_ccode_node_unref (cbinary), NULL)), _tmp3);
		}
	}
	_tmp5 = NULL;
	_tmp4 = NULL;
	cparenthesized = (_tmp5 = ((_tmp4 = cexpr, VALA_IS_CCODE_PARENTHESIZED_EXPRESSION (_tmp4) ? ((ValaCCodeParenthesizedExpression*) _tmp4) : NULL)), (_tmp5 == NULL) ? NULL : vala_ccode_node_ref (_tmp5));
	_tmp6 = FALSE;
	if (NULL != cparenthesized) {
		_tmp6 = vala_ccode_base_module_is_constant_ccode_expression (self, vala_ccode_parenthesized_expression_get_inner (cparenthesized));
	} else {
		_tmp6 = FALSE;
	}
	return (_tmp7 = (_tmp6), (cparenthesized == NULL) ? NULL : (cparenthesized = (vala_ccode_node_unref (cparenthesized), NULL)), _tmp7);
}


/**
 * Returns whether the passed cexpr is a pure expression, i.e. an
 * expression without side-effects.
 */
gboolean vala_ccode_base_module_is_pure_ccode_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* cexpr) {
	gboolean _tmp0;
	ValaCCodeParenthesizedExpression* _tmp8;
	ValaCCodeExpression* _tmp7;
	ValaCCodeParenthesizedExpression* cparenthesized;
	gboolean _tmp9;
	gboolean _tmp10;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cexpr != NULL, FALSE);
	_tmp0 = FALSE;
	if (VALA_IS_CCODE_CONSTANT (cexpr)) {
		_tmp0 = TRUE;
	} else {
		_tmp0 = VALA_IS_CCODE_IDENTIFIER (cexpr);
	}
	if (_tmp0) {
		return TRUE;
	} else {
		if (VALA_IS_CCODE_BINARY_EXPRESSION (cexpr)) {
			ValaCCodeBinaryExpression* _tmp2;
			ValaCCodeBinaryExpression* cbinary;
			gboolean _tmp3;
			gboolean _tmp4;
			_tmp2 = NULL;
			cbinary = (_tmp2 = VALA_CCODE_BINARY_EXPRESSION (cexpr), (_tmp2 == NULL) ? NULL : vala_ccode_node_ref (_tmp2));
			_tmp3 = FALSE;
			if (vala_ccode_base_module_is_pure_ccode_expression (self, vala_ccode_binary_expression_get_left (cbinary))) {
				_tmp3 = vala_ccode_base_module_is_constant_ccode_expression (self, vala_ccode_binary_expression_get_right (cbinary));
			} else {
				_tmp3 = FALSE;
			}
			return (_tmp4 = _tmp3, (cbinary == NULL) ? NULL : (cbinary = (vala_ccode_node_unref (cbinary), NULL)), _tmp4);
		} else {
			if (VALA_IS_CCODE_MEMBER_ACCESS (cexpr)) {
				ValaCCodeMemberAccess* _tmp5;
				ValaCCodeMemberAccess* cma;
				gboolean _tmp6;
				_tmp5 = NULL;
				cma = (_tmp5 = VALA_CCODE_MEMBER_ACCESS (cexpr), (_tmp5 == NULL) ? NULL : vala_ccode_node_ref (_tmp5));
				return (_tmp6 = vala_ccode_base_module_is_pure_ccode_expression (self, vala_ccode_member_access_get_inner (cma)), (cma == NULL) ? NULL : (cma = (vala_ccode_node_unref (cma), NULL)), _tmp6);
			}
		}
	}
	_tmp8 = NULL;
	_tmp7 = NULL;
	cparenthesized = (_tmp8 = ((_tmp7 = cexpr, VALA_IS_CCODE_PARENTHESIZED_EXPRESSION (_tmp7) ? ((ValaCCodeParenthesizedExpression*) _tmp7) : NULL)), (_tmp8 == NULL) ? NULL : vala_ccode_node_ref (_tmp8));
	_tmp9 = FALSE;
	if (NULL != cparenthesized) {
		_tmp9 = vala_ccode_base_module_is_pure_ccode_expression (self, vala_ccode_parenthesized_expression_get_inner (cparenthesized));
	} else {
		_tmp9 = FALSE;
	}
	return (_tmp10 = (_tmp9), (cparenthesized == NULL) ? NULL : (cparenthesized = (vala_ccode_node_unref (cparenthesized), NULL)), _tmp10);
}


static void vala_ccode_base_module_real_visit_formal_parameter (ValaCCodeModule* base, ValaFormalParameter* p) {
	ValaCCodeBaseModule * self;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (p != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) p, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (!vala_formal_parameter_get_ellipsis (p)) {
		char* ctypename;
		const char* _tmp0;
		char* cname;
		ValaCCodeFormalParameter* _tmp6;
		ctypename = vala_data_type_get_cname (vala_formal_parameter_get_parameter_type (p));
		_tmp0 = NULL;
		cname = (_tmp0 = vala_symbol_get_name ((ValaSymbol*) p), (_tmp0 == NULL) ? NULL : g_strdup (_tmp0));
		/* pass non-simple structs always by reference*/
		if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (p)))) {
			ValaStruct* _tmp1;
			ValaStruct* st;
			gboolean _tmp2;
			gboolean _tmp3;
			_tmp1 = NULL;
			st = (_tmp1 = VALA_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (p))), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
			_tmp2 = FALSE;
			_tmp3 = FALSE;
			if (!vala_struct_is_simple_type (st)) {
				_tmp3 = vala_formal_parameter_get_direction (p) == VALA_PARAMETER_DIRECTION_IN;
			} else {
				_tmp3 = FALSE;
			}
			if (_tmp3) {
				_tmp2 = !vala_data_type_get_nullable (vala_formal_parameter_get_parameter_type (p));
			} else {
				_tmp2 = FALSE;
			}
			if (_tmp2) {
				char* _tmp4;
				_tmp4 = NULL;
				ctypename = (_tmp4 = g_strconcat (ctypename, ("*"), NULL), ctypename = (g_free (ctypename), NULL), _tmp4);
			}
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
		}
		if (vala_formal_parameter_get_direction (p) != VALA_PARAMETER_DIRECTION_IN) {
			char* _tmp5;
			_tmp5 = NULL;
			ctypename = (_tmp5 = g_strconcat (ctypename, ("*"), NULL), ctypename = (g_free (ctypename), NULL), _tmp5);
		}
		_tmp6 = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) p, (ValaCCodeNode*) (_tmp6 = vala_ccode_formal_parameter_new (cname, ctypename)));
		(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
		ctypename = (g_free (ctypename), NULL);
		cname = (g_free (cname), NULL);
	} else {
		ValaCCodeFormalParameter* _tmp7;
		_tmp7 = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) p, (ValaCCodeNode*) (_tmp7 = vala_ccode_formal_parameter_new_with_ellipsis ()));
		(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	}
}


static void vala_ccode_base_module_real_visit_property (ValaCCodeModule* base, ValaProperty* prop) {
	ValaCCodeBaseModule * self;
	gint old_next_temp_var_id;
	ValaClass* _tmp1;
	ValaSymbol* _tmp0;
	ValaClass* cl;
	gboolean _tmp2;
	gboolean _tmp3;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (prop != NULL);
	old_next_temp_var_id = self->next_temp_var_id;
	self->next_temp_var_id = 0;
	vala_code_node_accept_children ((ValaCodeNode*) prop, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	self->next_temp_var_id = old_next_temp_var_id;
	_tmp1 = NULL;
	_tmp0 = NULL;
	cl = (_tmp1 = (_tmp0 = vala_symbol_get_parent_symbol ((ValaSymbol*) prop), VALA_IS_CLASS (_tmp0) ? ((ValaClass*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp2 = FALSE;
	_tmp3 = FALSE;
	if (cl != NULL) {
		_tmp3 = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) cl, self->gobject_type);
	} else {
		_tmp3 = FALSE;
	}
	if (_tmp3) {
		_tmp2 = vala_property_get_binding (prop) == MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2 = FALSE;
	}
	if (_tmp2) {
		gboolean _tmp4;
		_tmp4 = FALSE;
		if (!vala_data_type_is_real_struct_type (vala_property_get_property_type (prop))) {
			_tmp4 = vala_symbol_get_access ((ValaSymbol*) prop) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
		} else {
			_tmp4 = FALSE;
		}
		/* GObject property
		 FIXME: omit real struct types for now since they
		 cannot be expressed as gobject property yet
		 don't register private properties*/
		if (_tmp4) {
			ValaCCodeEnumValue* _tmp6;
			char* _tmp5;
			_tmp6 = NULL;
			_tmp5 = NULL;
			vala_ccode_enum_add_value (self->prop_enum, _tmp6 = vala_ccode_enum_value_new (_tmp5 = vala_property_get_upper_case_cname (prop), NULL));
			(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
			_tmp5 = (g_free (_tmp5), NULL);
		}
	}
	(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
}


static void vala_ccode_base_module_real_visit_property_accessor (ValaCCodeModule* base, ValaPropertyAccessor* acc) {
	ValaCCodeBaseModule * self;
	ValaPropertyAccessor* _tmp1;
	ValaPropertyAccessor* _tmp0;
	ValaProperty* _tmp2;
	ValaProperty* prop;
	gboolean returns_real_struct;
	gboolean _tmp3;
	ValaTypeSymbol* _tmp7;
	ValaTypeSymbol* t;
	ValaReferenceType* this_type;
	char* _tmp10;
	ValaCCodeFormalParameter* _tmp11;
	ValaCCodeFormalParameter* cselfparam;
	ValaDataType* value_type;
	ValaCCodeFormalParameter* cvalueparam;
	gboolean _tmp17;
	ValaPropertyAccessor* _tmp105;
	ValaDataType* _tmp106;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (acc != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->current_property_accessor = (_tmp1 = (_tmp0 = acc, (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0)), (self->current_property_accessor == NULL) ? NULL : (self->current_property_accessor = (vala_code_node_unref (self->current_property_accessor), NULL)), _tmp1);
	self->current_method_inner_error = FALSE;
	_tmp2 = NULL;
	prop = (_tmp2 = VALA_PROPERTY (vala_property_accessor_get_prop (acc)), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
	returns_real_struct = vala_data_type_is_real_struct_type (vala_property_get_property_type (prop));
	_tmp3 = FALSE;
	if (vala_property_accessor_get_readable (acc)) {
		_tmp3 = !returns_real_struct;
	} else {
		_tmp3 = FALSE;
	}
	if (_tmp3) {
		ValaDataType* _tmp5;
		ValaDataType* _tmp4;
		_tmp5 = NULL;
		_tmp4 = NULL;
		self->current_return_type = (_tmp5 = (_tmp4 = vala_property_get_property_type (prop), (_tmp4 == NULL) ? NULL : vala_code_node_ref (_tmp4)), (self->current_return_type == NULL) ? NULL : (self->current_return_type = (vala_code_node_unref (self->current_return_type), NULL)), _tmp5);
	} else {
		ValaDataType* _tmp6;
		_tmp6 = NULL;
		self->current_return_type = (_tmp6 = (ValaDataType*) vala_void_type_new (), (self->current_return_type == NULL) ? NULL : (self->current_return_type = (vala_code_node_unref (self->current_return_type), NULL)), _tmp6);
	}
	vala_code_node_accept_children ((ValaCodeNode*) acc, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	_tmp7 = NULL;
	t = (_tmp7 = VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) prop)), (_tmp7 == NULL) ? NULL : vala_code_node_ref (_tmp7));
	this_type = NULL;
	if (VALA_IS_CLASS (t)) {
		ValaReferenceType* _tmp8;
		_tmp8 = NULL;
		this_type = (_tmp8 = (ValaReferenceType*) vala_object_type_new ((ValaObjectTypeSymbol*) VALA_CLASS (t)), (this_type == NULL) ? NULL : (this_type = (vala_code_node_unref (this_type), NULL)), _tmp8);
	} else {
		ValaReferenceType* _tmp9;
		_tmp9 = NULL;
		this_type = (_tmp9 = (ValaReferenceType*) vala_object_type_new ((ValaObjectTypeSymbol*) VALA_INTERFACE (t)), (this_type == NULL) ? NULL : (this_type = (vala_code_node_unref (this_type), NULL)), _tmp9);
	}
	_tmp10 = NULL;
	_tmp11 = NULL;
	cselfparam = (_tmp11 = vala_ccode_formal_parameter_new ("self", _tmp10 = vala_data_type_get_cname ((ValaDataType*) this_type)), _tmp10 = (g_free (_tmp10), NULL), _tmp11);
	value_type = vala_data_type_copy (vala_property_get_property_type (prop));
	cvalueparam = NULL;
	if (returns_real_struct) {
		ValaCCodeFormalParameter* _tmp14;
		char* _tmp13;
		char* _tmp12;
		_tmp14 = NULL;
		_tmp13 = NULL;
		_tmp12 = NULL;
		cvalueparam = (_tmp14 = vala_ccode_formal_parameter_new ("value", _tmp13 = g_strconcat (_tmp12 = vala_data_type_get_cname (value_type), "*", NULL)), (cvalueparam == NULL) ? NULL : (cvalueparam = (vala_ccode_node_unref (cvalueparam), NULL)), _tmp14);
		_tmp13 = (g_free (_tmp13), NULL);
		_tmp12 = (g_free (_tmp12), NULL);
	} else {
		ValaCCodeFormalParameter* _tmp16;
		char* _tmp15;
		_tmp16 = NULL;
		_tmp15 = NULL;
		cvalueparam = (_tmp16 = vala_ccode_formal_parameter_new ("value", _tmp15 = vala_data_type_get_cname (value_type)), (cvalueparam == NULL) ? NULL : (cvalueparam = (vala_ccode_node_unref (cvalueparam), NULL)), _tmp16);
		_tmp15 = (g_free (_tmp15), NULL);
	}
	_tmp17 = FALSE;
	if (vala_property_get_is_abstract (prop)) {
		_tmp17 = TRUE;
	} else {
		_tmp17 = vala_property_get_is_virtual (prop);
	}
	if (_tmp17) {
		ValaCCodeFunctionDeclarator* vdeclarator;
		gboolean _tmp29;
		gboolean _tmp30;
		gboolean _tmp31;
		gboolean _tmp32;
		ValaCCodeBlock* block;
		ValaCCodeFunctionCall* vcast;
		ValaCCodeIdentifier* _tmp46;
		vdeclarator = NULL;
		if (vala_property_accessor_get_readable (acc)) {
			ValaCCodeFunction* _tmp20;
			char* _tmp19;
			char* _tmp18;
			char* _tmp21;
			ValaCCodeDeclaration* _tmp22;
			ValaCCodeDeclaration* vdecl;
			ValaCCodeFunctionDeclarator* _tmp24;
			char* _tmp23;
			_tmp20 = NULL;
			_tmp19 = NULL;
			_tmp18 = NULL;
			self->function = (_tmp20 = vala_ccode_function_new (_tmp18 = vala_property_accessor_get_cname (acc), _tmp19 = vala_data_type_get_cname (self->current_return_type)), (self->function == NULL) ? NULL : (self->function = (vala_ccode_node_unref (self->function), NULL)), _tmp20);
			_tmp19 = (g_free (_tmp19), NULL);
			_tmp18 = (g_free (_tmp18), NULL);
			_tmp21 = NULL;
			_tmp22 = NULL;
			vdecl = (_tmp22 = vala_ccode_declaration_new (_tmp21 = vala_data_type_get_cname (self->current_return_type)), _tmp21 = (g_free (_tmp21), NULL), _tmp22);
			_tmp24 = NULL;
			_tmp23 = NULL;
			vdeclarator = (_tmp24 = vala_ccode_function_declarator_new (_tmp23 = g_strdup_printf ("get_%s", vala_symbol_get_name ((ValaSymbol*) prop))), (vdeclarator == NULL) ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL)), _tmp24);
			_tmp23 = (g_free (_tmp23), NULL);
			vala_ccode_declaration_add_declarator (vdecl, (ValaCCodeDeclarator*) vdeclarator);
			vala_ccode_struct_add_declaration (self->type_struct, vdecl);
			(vdecl == NULL) ? NULL : (vdecl = (vala_ccode_node_unref (vdecl), NULL));
		} else {
			ValaCCodeFunction* _tmp26;
			char* _tmp25;
			ValaCCodeDeclaration* vdecl;
			ValaCCodeFunctionDeclarator* _tmp28;
			char* _tmp27;
			_tmp26 = NULL;
			_tmp25 = NULL;
			self->function = (_tmp26 = vala_ccode_function_new (_tmp25 = vala_property_accessor_get_cname (acc), "void"), (self->function == NULL) ? NULL : (self->function = (vala_ccode_node_unref (self->function), NULL)), _tmp26);
			_tmp25 = (g_free (_tmp25), NULL);
			vdecl = vala_ccode_declaration_new ("void");
			_tmp28 = NULL;
			_tmp27 = NULL;
			vdeclarator = (_tmp28 = vala_ccode_function_declarator_new (_tmp27 = g_strdup_printf ("set_%s", vala_symbol_get_name ((ValaSymbol*) prop))), (vdeclarator == NULL) ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL)), _tmp28);
			_tmp27 = (g_free (_tmp27), NULL);
			vala_ccode_declaration_add_declarator (vdecl, (ValaCCodeDeclarator*) vdeclarator);
			vala_ccode_struct_add_declaration (self->type_struct, vdecl);
			(vdecl == NULL) ? NULL : (vdecl = (vala_ccode_node_unref (vdecl), NULL));
		}
		vala_ccode_function_add_parameter (self->function, cselfparam);
		vala_ccode_function_declarator_add_parameter (vdeclarator, cselfparam);
		_tmp29 = FALSE;
		_tmp30 = FALSE;
		if (vala_property_accessor_get_writable (acc)) {
			_tmp30 = TRUE;
		} else {
			_tmp30 = vala_property_accessor_get_construction (acc);
		}
		if (_tmp30) {
			_tmp29 = TRUE;
		} else {
			_tmp29 = returns_real_struct;
		}
		if (_tmp29) {
			vala_ccode_function_add_parameter (self->function, cvalueparam);
			vala_ccode_function_declarator_add_parameter (vdeclarator, cvalueparam);
		}
		_tmp31 = FALSE;
		_tmp32 = FALSE;
		if (!vala_symbol_is_internal_symbol ((ValaSymbol*) prop)) {
			gboolean _tmp33;
			_tmp33 = FALSE;
			if (vala_property_accessor_get_readable (acc)) {
				_tmp33 = TRUE;
			} else {
				_tmp33 = vala_property_accessor_get_writable (acc);
			}
			_tmp32 = (_tmp33);
		} else {
			_tmp32 = FALSE;
		}
		if (_tmp32) {
			_tmp31 = vala_property_accessor_get_access (acc) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
		} else {
			_tmp31 = FALSE;
		}
		if (_tmp31) {
			ValaCCodeFunction* _tmp34;
			/* accessor function should be public if the property is a public symbol and it's not a construct-only setter*/
			_tmp34 = NULL;
			vala_ccode_fragment_append (self->header_type_member_declaration, (ValaCCodeNode*) (_tmp34 = vala_ccode_function_copy (self->function)));
			(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
		} else {
			ValaCCodeFunction* _tmp35;
			vala_ccode_function_set_modifiers (self->function, vala_ccode_function_get_modifiers (self->function) | (VALA_CCODE_MODIFIERS_STATIC));
			_tmp35 = NULL;
			vala_ccode_fragment_append (self->source_type_member_declaration, (ValaCCodeNode*) (_tmp35 = vala_ccode_function_copy (self->function)));
			(_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL));
		}
		block = vala_ccode_block_new ();
		vala_ccode_function_set_block (self->function, block);
		vcast = NULL;
		if (VALA_IS_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) prop))) {
			ValaInterface* _tmp36;
			ValaInterface* iface;
			ValaCCodeFunctionCall* _tmp40;
			ValaCCodeIdentifier* _tmp39;
			char* _tmp38;
			char* _tmp37;
			_tmp36 = NULL;
			iface = (_tmp36 = VALA_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) prop)), (_tmp36 == NULL) ? NULL : vala_code_node_ref (_tmp36));
			_tmp40 = NULL;
			_tmp39 = NULL;
			_tmp38 = NULL;
			_tmp37 = NULL;
			vcast = (_tmp40 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp39 = vala_ccode_identifier_new (_tmp38 = g_strdup_printf ("%s_GET_INTERFACE", _tmp37 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) iface, NULL))))), (vcast == NULL) ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL)), _tmp40);
			(_tmp39 == NULL) ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL));
			_tmp38 = (g_free (_tmp38), NULL);
			_tmp37 = (g_free (_tmp37), NULL);
			(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
		} else {
			ValaClass* _tmp41;
			ValaClass* cl;
			ValaCCodeFunctionCall* _tmp45;
			ValaCCodeIdentifier* _tmp44;
			char* _tmp43;
			char* _tmp42;
			_tmp41 = NULL;
			cl = (_tmp41 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) prop)), (_tmp41 == NULL) ? NULL : vala_code_node_ref (_tmp41));
			_tmp45 = NULL;
			_tmp44 = NULL;
			_tmp43 = NULL;
			_tmp42 = NULL;
			vcast = (_tmp45 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp44 = vala_ccode_identifier_new (_tmp43 = g_strdup_printf ("%s_GET_CLASS", _tmp42 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL))))), (vcast == NULL) ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL)), _tmp45);
			(_tmp44 == NULL) ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL));
			_tmp43 = (g_free (_tmp43), NULL);
			_tmp42 = (g_free (_tmp42), NULL);
			(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
		}
		_tmp46 = NULL;
		vala_ccode_function_call_add_argument (vcast, (ValaCCodeExpression*) (_tmp46 = vala_ccode_identifier_new ("self")));
		(_tmp46 == NULL) ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL));
		if (vala_property_accessor_get_readable (acc)) {
			ValaCCodeMemberAccess* _tmp48;
			char* _tmp47;
			ValaCCodeFunctionCall* _tmp49;
			ValaCCodeFunctionCall* vcall;
			ValaCCodeIdentifier* _tmp50;
			_tmp48 = NULL;
			_tmp47 = NULL;
			_tmp49 = NULL;
			vcall = (_tmp49 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp48 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) vcast, _tmp47 = g_strdup_printf ("get_%s", vala_symbol_get_name ((ValaSymbol*) prop))))), (_tmp48 == NULL) ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL)), _tmp47 = (g_free (_tmp47), NULL), _tmp49);
			_tmp50 = NULL;
			vala_ccode_function_call_add_argument (vcall, (ValaCCodeExpression*) (_tmp50 = vala_ccode_identifier_new ("self")));
			(_tmp50 == NULL) ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL));
			if (returns_real_struct) {
				ValaCCodeIdentifier* _tmp51;
				ValaCCodeExpressionStatement* _tmp52;
				_tmp51 = NULL;
				vala_ccode_function_call_add_argument (vcall, (ValaCCodeExpression*) (_tmp51 = vala_ccode_identifier_new ("value")));
				(_tmp51 == NULL) ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL));
				_tmp52 = NULL;
				vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp52 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) vcall)));
				(_tmp52 == NULL) ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL));
			} else {
				ValaCCodeReturnStatement* _tmp53;
				_tmp53 = NULL;
				vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp53 = vala_ccode_return_statement_new ((ValaCCodeExpression*) vcall)));
				(_tmp53 == NULL) ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL));
			}
			(vcall == NULL) ? NULL : (vcall = (vala_ccode_node_unref (vcall), NULL));
		} else {
			ValaCCodeMemberAccess* _tmp55;
			char* _tmp54;
			ValaCCodeFunctionCall* _tmp56;
			ValaCCodeFunctionCall* vcall;
			ValaCCodeIdentifier* _tmp57;
			ValaCCodeIdentifier* _tmp58;
			ValaCCodeExpressionStatement* _tmp59;
			_tmp55 = NULL;
			_tmp54 = NULL;
			_tmp56 = NULL;
			vcall = (_tmp56 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp55 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) vcast, _tmp54 = g_strdup_printf ("set_%s", vala_symbol_get_name ((ValaSymbol*) prop))))), (_tmp55 == NULL) ? NULL : (_tmp55 = (vala_ccode_node_unref (_tmp55), NULL)), _tmp54 = (g_free (_tmp54), NULL), _tmp56);
			_tmp57 = NULL;
			vala_ccode_function_call_add_argument (vcall, (ValaCCodeExpression*) (_tmp57 = vala_ccode_identifier_new ("self")));
			(_tmp57 == NULL) ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL));
			_tmp58 = NULL;
			vala_ccode_function_call_add_argument (vcall, (ValaCCodeExpression*) (_tmp58 = vala_ccode_identifier_new ("value")));
			(_tmp58 == NULL) ? NULL : (_tmp58 = (vala_ccode_node_unref (_tmp58), NULL));
			_tmp59 = NULL;
			vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp59 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) vcall)));
			(_tmp59 == NULL) ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL));
			(vcall == NULL) ? NULL : (vcall = (vala_ccode_node_unref (vcall), NULL));
		}
		vala_ccode_fragment_append (self->source_type_member_definition, (ValaCCodeNode*) self->function);
		(vdeclarator == NULL) ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL));
		(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
		(vcast == NULL) ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL));
	}
	if (!vala_property_get_is_abstract (prop)) {
		gboolean _tmp60;
		gboolean is_virtual;
		char* cname;
		gboolean _tmp66;
		gboolean _tmp67;
		ValaObjectType* base_type;
		gboolean _tmp75;
		gboolean _tmp76;
		gboolean _tmp89;
		ValaTypeSymbol* _tmp92;
		ValaTypeSymbol* typesymbol;
		gboolean _tmp93;
		gboolean _tmp94;
		gboolean _tmp95;
		gboolean _tmp96;
		gboolean _tmp97;
		_tmp60 = FALSE;
		if (vala_property_get_base_property (prop) != NULL) {
			_tmp60 = TRUE;
		} else {
			_tmp60 = vala_property_get_base_interface_property (prop) != NULL;
		}
		is_virtual = _tmp60;
		cname = NULL;
		if (is_virtual) {
			if (vala_property_accessor_get_readable (acc)) {
				char* _tmp62;
				char* _tmp61;
				_tmp62 = NULL;
				_tmp61 = NULL;
				cname = (_tmp62 = g_strdup_printf ("%s_real_get_%s", _tmp61 = vala_symbol_get_lower_case_cname ((ValaSymbol*) t, NULL), vala_symbol_get_name ((ValaSymbol*) prop)), cname = (g_free (cname), NULL), _tmp62);
				_tmp61 = (g_free (_tmp61), NULL);
			} else {
				char* _tmp64;
				char* _tmp63;
				_tmp64 = NULL;
				_tmp63 = NULL;
				cname = (_tmp64 = g_strdup_printf ("%s_real_set_%s", _tmp63 = vala_symbol_get_lower_case_cname ((ValaSymbol*) t, NULL), vala_symbol_get_name ((ValaSymbol*) prop)), cname = (g_free (cname), NULL), _tmp64);
				_tmp63 = (g_free (_tmp63), NULL);
			}
		} else {
			char* _tmp65;
			_tmp65 = NULL;
			cname = (_tmp65 = vala_property_accessor_get_cname (acc), cname = (g_free (cname), NULL), _tmp65);
		}
		_tmp66 = FALSE;
		_tmp67 = FALSE;
		if (vala_property_accessor_get_writable (acc)) {
			_tmp67 = TRUE;
		} else {
			_tmp67 = vala_property_accessor_get_construction (acc);
		}
		if (_tmp67) {
			_tmp66 = TRUE;
		} else {
			_tmp66 = returns_real_struct;
		}
		if (_tmp66) {
			ValaCCodeFunction* _tmp68;
			_tmp68 = NULL;
			self->function = (_tmp68 = vala_ccode_function_new (cname, "void"), (self->function == NULL) ? NULL : (self->function = (vala_ccode_node_unref (self->function), NULL)), _tmp68);
		} else {
			ValaCCodeFunction* _tmp70;
			char* _tmp69;
			_tmp70 = NULL;
			_tmp69 = NULL;
			self->function = (_tmp70 = vala_ccode_function_new (cname, _tmp69 = vala_data_type_get_cname (vala_property_get_property_type (prop))), (self->function == NULL) ? NULL : (self->function = (vala_ccode_node_unref (self->function), NULL)), _tmp70);
			_tmp69 = (g_free (_tmp69), NULL);
		}
		base_type = NULL;
		if (vala_property_get_binding (prop) == MEMBER_BINDING_INSTANCE) {
			if (is_virtual) {
				ValaCCodeFormalParameter* _tmp74;
				char* _tmp73;
				if (vala_property_get_base_property (prop) != NULL) {
					ValaObjectType* _tmp71;
					_tmp71 = NULL;
					base_type = (_tmp71 = vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_property_get_base_property (prop)))), (base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)), _tmp71);
				} else {
					if (vala_property_get_base_interface_property (prop) != NULL) {
						ValaObjectType* _tmp72;
						_tmp72 = NULL;
						base_type = (_tmp72 = vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_property_get_base_interface_property (prop)))), (base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)), _tmp72);
					}
				}
				vala_ccode_function_set_modifiers (self->function, vala_ccode_function_get_modifiers (self->function) | (VALA_CCODE_MODIFIERS_STATIC));
				_tmp74 = NULL;
				_tmp73 = NULL;
				vala_ccode_function_add_parameter (self->function, _tmp74 = vala_ccode_formal_parameter_new ("base", _tmp73 = vala_data_type_get_cname ((ValaDataType*) base_type)));
				(_tmp74 == NULL) ? NULL : (_tmp74 = (vala_ccode_node_unref (_tmp74), NULL));
				_tmp73 = (g_free (_tmp73), NULL);
			} else {
				vala_ccode_function_add_parameter (self->function, cselfparam);
			}
		}
		_tmp75 = FALSE;
		_tmp76 = FALSE;
		if (vala_property_accessor_get_writable (acc)) {
			_tmp76 = TRUE;
		} else {
			_tmp76 = vala_property_accessor_get_construction (acc);
		}
		if (_tmp76) {
			_tmp75 = TRUE;
		} else {
			_tmp75 = returns_real_struct;
		}
		if (_tmp75) {
			vala_ccode_function_add_parameter (self->function, cvalueparam);
		}
		if (!is_virtual) {
			gboolean _tmp77;
			gboolean _tmp78;
			_tmp77 = FALSE;
			_tmp78 = FALSE;
			if (!vala_symbol_is_internal_symbol ((ValaSymbol*) prop)) {
				gboolean _tmp79;
				_tmp79 = FALSE;
				if (vala_property_accessor_get_readable (acc)) {
					_tmp79 = TRUE;
				} else {
					_tmp79 = vala_property_accessor_get_writable (acc);
				}
				_tmp78 = (_tmp79);
			} else {
				_tmp78 = FALSE;
			}
			if (_tmp78) {
				_tmp77 = vala_property_accessor_get_access (acc) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
			} else {
				_tmp77 = FALSE;
			}
			if (_tmp77) {
				ValaCCodeFunction* _tmp80;
				/* accessor function should be public if the property is a public symbol and it's not a construct-only setter*/
				_tmp80 = NULL;
				vala_ccode_fragment_append (self->header_type_member_declaration, (ValaCCodeNode*) (_tmp80 = vala_ccode_function_copy (self->function)));
				(_tmp80 == NULL) ? NULL : (_tmp80 = (vala_ccode_node_unref (_tmp80), NULL));
			} else {
				ValaCCodeFunction* _tmp81;
				vala_ccode_function_set_modifiers (self->function, vala_ccode_function_get_modifiers (self->function) | (VALA_CCODE_MODIFIERS_STATIC));
				_tmp81 = NULL;
				vala_ccode_fragment_append (self->source_type_member_declaration, (ValaCCodeNode*) (_tmp81 = vala_ccode_function_copy (self->function)));
				(_tmp81 == NULL) ? NULL : (_tmp81 = (vala_ccode_node_unref (_tmp81), NULL));
			}
		}
		vala_ccode_function_set_block (self->function, VALA_CCODE_BLOCK (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_property_accessor_get_body (acc))));
		if (is_virtual) {
			char* _tmp82;
			ValaCCodeDeclaration* _tmp83;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp86;
			ValaCCodeExpression* _tmp85;
			ValaCCodeIdentifier* _tmp84;
			_tmp82 = NULL;
			_tmp83 = NULL;
			cdecl_ = (_tmp83 = vala_ccode_declaration_new (_tmp82 = vala_data_type_get_cname ((ValaDataType*) this_type)), _tmp82 = (g_free (_tmp82), NULL), _tmp83);
			_tmp86 = NULL;
			_tmp85 = NULL;
			_tmp84 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp86 = vala_ccode_variable_declarator_new_with_initializer ("self", _tmp85 = vala_ccode_base_module_transform_expression (self, (ValaCCodeExpression*) (_tmp84 = vala_ccode_identifier_new ("base")), (ValaDataType*) base_type, (ValaDataType*) this_type, NULL))));
			(_tmp86 == NULL) ? NULL : (_tmp86 = (vala_ccode_node_unref (_tmp86), NULL));
			(_tmp85 == NULL) ? NULL : (_tmp85 = (vala_ccode_node_unref (_tmp85), NULL));
			(_tmp84 == NULL) ? NULL : (_tmp84 = (vala_ccode_node_unref (_tmp84), NULL));
			vala_ccode_block_prepend_statement (vala_ccode_function_get_block (self->function), (ValaCCodeNode*) cdecl_);
			(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
		}
		if (self->current_method_inner_error) {
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp88;
			ValaCCodeConstant* _tmp87;
			cdecl_ = vala_ccode_declaration_new ("GError *");
			_tmp88 = NULL;
			_tmp87 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp88 = vala_ccode_variable_declarator_new_with_initializer ("inner_error", (ValaCCodeExpression*) (_tmp87 = vala_ccode_constant_new ("NULL")))));
			(_tmp88 == NULL) ? NULL : (_tmp88 = (vala_ccode_node_unref (_tmp88), NULL));
			(_tmp87 == NULL) ? NULL : (_tmp87 = (vala_ccode_node_unref (_tmp87), NULL));
			vala_ccode_block_prepend_statement (vala_ccode_function_get_block (self->function), (ValaCCodeNode*) cdecl_);
			(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
		}
		_tmp89 = FALSE;
		if (vala_property_get_binding (prop) == MEMBER_BINDING_INSTANCE) {
			_tmp89 = !is_virtual;
		} else {
			_tmp89 = FALSE;
		}
		if (_tmp89) {
			if (returns_real_struct) {
				ValaCCodeStatement* _tmp90;
				_tmp90 = NULL;
				vala_ccode_block_prepend_statement (vala_ccode_function_get_block (self->function), (ValaCCodeNode*) (_tmp90 = vala_ccode_base_module_create_property_type_check_statement (self, prop, FALSE, t, TRUE, "self")));
				(_tmp90 == NULL) ? NULL : (_tmp90 = (vala_ccode_node_unref (_tmp90), NULL));
			} else {
				ValaCCodeStatement* _tmp91;
				_tmp91 = NULL;
				vala_ccode_block_prepend_statement (vala_ccode_function_get_block (self->function), (ValaCCodeNode*) (_tmp91 = vala_ccode_base_module_create_property_type_check_statement (self, prop, vala_property_accessor_get_readable (acc), t, TRUE, "self")));
				(_tmp91 == NULL) ? NULL : (_tmp91 = (vala_ccode_node_unref (_tmp91), NULL));
			}
		}
		/* notify on property changes*/
		_tmp92 = NULL;
		typesymbol = (_tmp92 = VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) prop)), (_tmp92 == NULL) ? NULL : vala_code_node_ref (_tmp92));
		_tmp93 = FALSE;
		_tmp94 = FALSE;
		_tmp95 = FALSE;
		_tmp96 = FALSE;
		_tmp97 = FALSE;
		if (vala_typesymbol_is_subtype_of (typesymbol, self->gobject_type)) {
			_tmp97 = vala_property_get_notify (prop);
		} else {
			_tmp97 = FALSE;
		}
		if (_tmp97) {
			_tmp96 = vala_symbol_get_access ((ValaSymbol*) prop) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
		} else {
			_tmp96 = FALSE;
		}
		if (_tmp96) {
			_tmp95 = vala_property_get_binding (prop) == MEMBER_BINDING_INSTANCE;
		} else {
			_tmp95 = FALSE;
		}
		if (_tmp95) {
			_tmp94 = !vala_data_type_is_real_struct_type (vala_property_get_property_type (prop));
		} else {
			_tmp94 = FALSE;
		}
		if (_tmp94) {
			gboolean _tmp98;
			_tmp98 = FALSE;
			if (vala_property_accessor_get_writable (acc)) {
				_tmp98 = TRUE;
			} else {
				_tmp98 = vala_property_accessor_get_construction (acc);
			}
			_tmp93 = (_tmp98);
		} else {
			_tmp93 = FALSE;
		}
		if (_tmp93) {
			ValaCCodeIdentifier* _tmp99;
			ValaCCodeFunctionCall* _tmp100;
			ValaCCodeFunctionCall* notify_call;
			ValaCCodeCastExpression* _tmp102;
			ValaCCodeIdentifier* _tmp101;
			ValaCCodeConstant* _tmp103;
			ValaCCodeExpressionStatement* _tmp104;
			/* FIXME: use better means to detect gobject properties*/
			_tmp99 = NULL;
			_tmp100 = NULL;
			notify_call = (_tmp100 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp99 = vala_ccode_identifier_new ("g_object_notify"))), (_tmp99 == NULL) ? NULL : (_tmp99 = (vala_ccode_node_unref (_tmp99), NULL)), _tmp100);
			_tmp102 = NULL;
			_tmp101 = NULL;
			vala_ccode_function_call_add_argument (notify_call, (ValaCCodeExpression*) (_tmp102 = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp101 = vala_ccode_identifier_new ("self")), "GObject *")));
			(_tmp102 == NULL) ? NULL : (_tmp102 = (vala_ccode_node_unref (_tmp102), NULL));
			(_tmp101 == NULL) ? NULL : (_tmp101 = (vala_ccode_node_unref (_tmp101), NULL));
			_tmp103 = NULL;
			vala_ccode_function_call_add_argument (notify_call, (ValaCCodeExpression*) (_tmp103 = vala_property_get_canonical_cconstant (prop)));
			(_tmp103 == NULL) ? NULL : (_tmp103 = (vala_ccode_node_unref (_tmp103), NULL));
			_tmp104 = NULL;
			vala_ccode_block_add_statement (vala_ccode_function_get_block (self->function), (ValaCCodeNode*) (_tmp104 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) notify_call)));
			(_tmp104 == NULL) ? NULL : (_tmp104 = (vala_ccode_node_unref (_tmp104), NULL));
			(notify_call == NULL) ? NULL : (notify_call = (vala_ccode_node_unref (notify_call), NULL));
		}
		vala_ccode_fragment_append (self->source_type_member_definition, (ValaCCodeNode*) self->function);
		cname = (g_free (cname), NULL);
		(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
		(typesymbol == NULL) ? NULL : (typesymbol = (vala_code_node_unref (typesymbol), NULL));
	}
	_tmp105 = NULL;
	self->current_property_accessor = (_tmp105 = NULL, (self->current_property_accessor == NULL) ? NULL : (self->current_property_accessor = (vala_code_node_unref (self->current_property_accessor), NULL)), _tmp105);
	_tmp106 = NULL;
	self->current_return_type = (_tmp106 = NULL, (self->current_return_type == NULL) ? NULL : (self->current_return_type = (vala_code_node_unref (self->current_return_type), NULL)), _tmp106);
	(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
	(t == NULL) ? NULL : (t = (vala_code_node_unref (t), NULL));
	(this_type == NULL) ? NULL : (this_type = (vala_code_node_unref (this_type), NULL));
	(cselfparam == NULL) ? NULL : (cselfparam = (vala_ccode_node_unref (cselfparam), NULL));
	(value_type == NULL) ? NULL : (value_type = (vala_code_node_unref (value_type), NULL));
	(cvalueparam == NULL) ? NULL : (cvalueparam = (vala_ccode_node_unref (cvalueparam), NULL));
}


static void vala_ccode_base_module_real_visit_destructor (ValaCCodeModule* base, ValaDestructor* d) {
	ValaCCodeBaseModule * self;
	ValaCCodeFragment* cfrag;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (d != NULL);
	self->current_method_inner_error = FALSE;
	vala_code_node_accept_children ((ValaCodeNode*) d, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	cfrag = vala_ccode_fragment_new ();
	if (self->current_method_inner_error) {
		ValaCCodeDeclaration* cdecl_;
		ValaCCodeVariableDeclarator* _tmp1;
		ValaCCodeConstant* _tmp0;
		cdecl_ = vala_ccode_declaration_new ("GError *");
		_tmp1 = NULL;
		_tmp0 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp1 = vala_ccode_variable_declarator_new_with_initializer ("inner_error", (ValaCCodeExpression*) (_tmp0 = vala_ccode_constant_new ("NULL")))));
		(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
		(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
		vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) cdecl_);
		(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
	}
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode ((ValaCodeNode*) vala_destructor_get_body (d)));
	vala_code_node_set_ccodenode ((ValaCodeNode*) d, (ValaCCodeNode*) cfrag);
	(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
}


static void vala_ccode_base_module_real_visit_block (ValaCCodeModule* base, ValaBlock* b) {
	ValaCCodeBaseModule * self;
	ValaSymbol* _tmp0;
	ValaSymbol* old_symbol;
	ValaSymbol* _tmp2;
	ValaSymbol* _tmp1;
	GeeList* local_vars;
	ValaCCodeBlock* cblock;
	ValaSymbol* _tmp24;
	ValaSymbol* _tmp23;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (b != NULL);
	_tmp0 = NULL;
	old_symbol = (_tmp0 = self->current_symbol, (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->current_symbol = (_tmp2 = (_tmp1 = (ValaSymbol*) b, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (self->current_symbol == NULL) ? NULL : (self->current_symbol = (vala_code_node_unref (self->current_symbol), NULL)), _tmp2);
	vala_code_node_accept_children ((ValaCodeNode*) b, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	local_vars = vala_block_get_local_variables (b);
	{
		GeeIterator* local_it;
		local_it = gee_iterable_iterator ((GeeIterable*) local_vars);
		while (gee_iterator_next (local_it)) {
			ValaLocalVariable* local;
			local = (ValaLocalVariable*) gee_iterator_get (local_it);
			vala_symbol_set_active ((ValaSymbol*) local, FALSE);
			(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
		}
		(local_it == NULL) ? NULL : (local_it = (gee_collection_object_unref (local_it), NULL));
	}
	cblock = vala_ccode_block_new ();
	{
		GeeList* _tmp3;
		GeeIterator* _tmp4;
		GeeIterator* stmt_it;
		_tmp3 = NULL;
		_tmp4 = NULL;
		stmt_it = (_tmp4 = gee_iterable_iterator ((GeeIterable*) (_tmp3 = vala_block_get_statements (b))), (_tmp3 == NULL) ? NULL : (_tmp3 = (gee_collection_object_unref (_tmp3), NULL)), _tmp4);
		while (gee_iterator_next (stmt_it)) {
			ValaCodeNode* stmt;
			ValaSourceReference* _tmp5;
			ValaSourceReference* src;
			gboolean _tmp6;
			stmt = (ValaCodeNode*) ((ValaStatement*) gee_iterator_get (stmt_it));
			if (vala_code_node_get_error (stmt)) {
				(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
				continue;
			}
			_tmp5 = NULL;
			src = (_tmp5 = vala_code_node_get_source_reference (stmt), (_tmp5 == NULL) ? NULL : vala_source_reference_ref (_tmp5));
			_tmp6 = FALSE;
			if (src != NULL) {
				_tmp6 = vala_source_reference_get_comment (src) != NULL;
			} else {
				_tmp6 = FALSE;
			}
			if (_tmp6) {
				ValaCCodeComment* _tmp7;
				_tmp7 = NULL;
				vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp7 = vala_ccode_comment_new (vala_source_reference_get_comment (src))));
				(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
			}
			if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))) {
				{
					GeeList* _tmp8;
					GeeIterator* _tmp9;
					GeeIterator* cstmt_it;
					_tmp8 = NULL;
					_tmp9 = NULL;
					cstmt_it = (_tmp9 = gee_iterable_iterator ((GeeIterable*) (_tmp8 = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt)))))), (_tmp8 == NULL) ? NULL : (_tmp8 = (gee_collection_object_unref (_tmp8), NULL)), _tmp9);
					while (gee_iterator_next (cstmt_it)) {
						ValaCCodeNode* cstmt;
						cstmt = (ValaCCodeNode*) gee_iterator_get (cstmt_it);
						vala_ccode_block_add_statement (cblock, cstmt);
						(cstmt == NULL) ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL));
					}
					(cstmt_it == NULL) ? NULL : (cstmt_it = (gee_collection_object_unref (cstmt_it), NULL));
				}
			} else {
				vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (stmt));
			}
			(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
			(src == NULL) ? NULL : (src = (vala_source_reference_unref (src), NULL));
		}
		(stmt_it == NULL) ? NULL : (stmt_it = (gee_collection_object_unref (stmt_it), NULL));
	}
	{
		GeeIterator* local_it;
		local_it = gee_iterable_iterator ((GeeIterable*) local_vars);
		while (gee_iterator_next (local_it)) {
			ValaLocalVariable* local;
			gboolean _tmp10;
			local = (ValaLocalVariable*) gee_iterator_get (local_it);
			_tmp10 = FALSE;
			if (!vala_local_variable_get_floating (local)) {
				_tmp10 = vala_ccode_base_module_requires_destroy (self, vala_local_variable_get_variable_type (local));
			} else {
				_tmp10 = FALSE;
			}
			if (_tmp10) {
				ValaMemberAccess* ma;
				ValaCCodeExpressionStatement* _tmp14;
				ValaCCodeExpression* _tmp13;
				ValaCCodeIdentifier* _tmp12;
				char* _tmp11;
				ma = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) local), NULL);
				vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) local);
				_tmp14 = NULL;
				_tmp13 = NULL;
				_tmp12 = NULL;
				_tmp11 = NULL;
				vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp14 = vala_ccode_expression_statement_new (_tmp13 = vala_ccode_base_module_get_unref_expression (self, (ValaCCodeExpression*) (_tmp12 = vala_ccode_identifier_new (_tmp11 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) local)))), vala_local_variable_get_variable_type (local), (ValaExpression*) ma))));
				(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
				(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
				(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
				_tmp11 = (g_free (_tmp11), NULL);
				(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
			}
			(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
		}
		(local_it == NULL) ? NULL : (local_it = (gee_collection_object_unref (local_it), NULL));
	}
	if (VALA_IS_METHOD (vala_symbol_get_parent_symbol ((ValaSymbol*) b))) {
		ValaMethod* _tmp15;
		ValaMethod* m;
		_tmp15 = NULL;
		m = (_tmp15 = VALA_METHOD (vala_symbol_get_parent_symbol ((ValaSymbol*) b)), (_tmp15 == NULL) ? NULL : vala_code_node_ref (_tmp15));
		{
			GeeList* _tmp16;
			GeeIterator* _tmp17;
			GeeIterator* param_it;
			_tmp16 = NULL;
			_tmp17 = NULL;
			param_it = (_tmp17 = gee_iterable_iterator ((GeeIterable*) (_tmp16 = vala_method_get_parameters (m))), (_tmp16 == NULL) ? NULL : (_tmp16 = (gee_collection_object_unref (_tmp16), NULL)), _tmp17);
			while (gee_iterator_next (param_it)) {
				ValaFormalParameter* param;
				gboolean _tmp18;
				param = (ValaFormalParameter*) gee_iterator_get (param_it);
				_tmp18 = FALSE;
				if (vala_ccode_base_module_requires_destroy (self, vala_formal_parameter_get_parameter_type (param))) {
					_tmp18 = vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN;
				} else {
					_tmp18 = FALSE;
				}
				if (_tmp18) {
					ValaMemberAccess* ma;
					ValaCCodeExpressionStatement* _tmp22;
					ValaCCodeExpression* _tmp21;
					ValaCCodeIdentifier* _tmp20;
					char* _tmp19;
					ma = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) param), NULL);
					vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) param);
					_tmp22 = NULL;
					_tmp21 = NULL;
					_tmp20 = NULL;
					_tmp19 = NULL;
					vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp22 = vala_ccode_expression_statement_new (_tmp21 = vala_ccode_base_module_get_unref_expression (self, (ValaCCodeExpression*) (_tmp20 = vala_ccode_identifier_new (_tmp19 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) param)))), vala_formal_parameter_get_parameter_type (param), (ValaExpression*) ma))));
					(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
					(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
					(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
					_tmp19 = (g_free (_tmp19), NULL);
					(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
				}
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
			}
			(param_it == NULL) ? NULL : (param_it = (gee_collection_object_unref (param_it), NULL));
		}
		(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
	}
	vala_code_node_set_ccodenode ((ValaCodeNode*) b, (ValaCCodeNode*) cblock);
	_tmp24 = NULL;
	_tmp23 = NULL;
	self->current_symbol = (_tmp24 = (_tmp23 = old_symbol, (_tmp23 == NULL) ? NULL : vala_code_node_ref (_tmp23)), (self->current_symbol == NULL) ? NULL : (self->current_symbol = (vala_code_node_unref (self->current_symbol), NULL)), _tmp24);
	(old_symbol == NULL) ? NULL : (old_symbol = (vala_code_node_unref (old_symbol), NULL));
	(local_vars == NULL) ? NULL : (local_vars = (gee_collection_object_unref (local_vars), NULL));
	(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
}


static void vala_ccode_base_module_real_visit_empty_statement (ValaCCodeModule* base, ValaEmptyStatement* stmt) {
	ValaCCodeBaseModule * self;
	ValaCCodeEmptyStatement* _tmp0;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) (_tmp0 = vala_ccode_empty_statement_new ()));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
}


static void vala_ccode_base_module_real_visit_declaration_statement (ValaCCodeModule* base, ValaDeclarationStatement* stmt) {
	ValaCCodeBaseModule * self;
	ValaLocalVariable* _tmp1;
	ValaSymbol* _tmp0;
	ValaLocalVariable* local;
	gboolean _tmp2;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept ((ValaCodeNode*) vala_declaration_statement_get_declaration (stmt), (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, vala_code_node_get_ccodenode ((ValaCodeNode*) vala_declaration_statement_get_declaration (stmt)));
	_tmp1 = NULL;
	_tmp0 = NULL;
	local = (_tmp1 = (_tmp0 = vala_declaration_statement_get_declaration (stmt), VALA_IS_LOCAL_VARIABLE (_tmp0) ? ((ValaLocalVariable*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp2 = FALSE;
	if (local != NULL) {
		_tmp2 = vala_local_variable_get_initializer (local) != NULL;
	} else {
		_tmp2 = FALSE;
	}
	if (_tmp2) {
		vala_ccode_base_module_create_temp_decl (self, (ValaStatement*) stmt, (GeeList*) vala_local_variable_get_initializer (local)->temp_vars);
	}
	vala_ccode_base_module_create_temp_decl (self, (ValaStatement*) stmt, (GeeList*) self->temp_vars);
	gee_collection_clear ((GeeCollection*) self->temp_vars);
	(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
}


char* vala_ccode_base_module_get_variable_cname (ValaCCodeBaseModule* self, const char* name) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	if (g_utf8_get_char (g_utf8_offset_to_pointer (name, 0)) == '.') {
		/* compiler-internal variable*/
		if (!gee_map_contains (self->priv->variable_name_map, name)) {
			char* _tmp0;
			_tmp0 = NULL;
			gee_map_set (self->priv->variable_name_map, name, _tmp0 = g_strdup_printf ("_tmp%d", self->next_temp_var_id));
			_tmp0 = (g_free (_tmp0), NULL);
			self->next_temp_var_id++;
		}
		return (char*) gee_map_get (self->priv->variable_name_map, name);
	} else {
		if (gee_collection_contains ((GeeCollection*) self->c_keywords, name)) {
			return g_strconcat (name, "_", NULL);
		} else {
			const char* _tmp3;
			_tmp3 = NULL;
			return (_tmp3 = name, (_tmp3 == NULL) ? NULL : g_strdup (_tmp3));
		}
	}
}


static void vala_ccode_base_module_real_visit_local_variable (ValaCCodeModule* base, ValaLocalVariable* local) {
	ValaCCodeBaseModule * self;
	ValaCCodeExpression* rhs;
	gboolean _tmp12;
	char* _tmp45;
	ValaCCodeVariableDeclarator* _tmp46;
	ValaCCodeVariableDeclarator* cvar;
	ValaCCodeFragment* cfrag;
	char* _tmp47;
	ValaCCodeDeclaration* _tmp48;
	ValaCCodeDeclaration* cdecl_;
	gboolean _tmp49;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (local != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) local, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (VALA_IS_ARRAY_TYPE (vala_local_variable_get_variable_type (local))) {
		ValaArrayType* _tmp0;
		ValaArrayType* array_type;
		/* create variables to store array dimensions*/
		_tmp0 = NULL;
		array_type = (_tmp0 = VALA_ARRAY_TYPE (vala_local_variable_get_variable_type (local)), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
		{
			gint dim;
			dim = 1;
			for (; dim <= vala_array_type_get_rank (array_type); dim++) {
				char* _tmp3;
				char* _tmp2;
				ValaDataType* _tmp1;
				ValaLocalVariable* _tmp4;
				ValaLocalVariable* len_var;
				_tmp3 = NULL;
				_tmp2 = NULL;
				_tmp1 = NULL;
				_tmp4 = NULL;
				len_var = (_tmp4 = vala_local_variable_new (_tmp1 = vala_data_type_copy (self->int_type), _tmp3 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp2 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) local)), dim), NULL, NULL), _tmp3 = (g_free (_tmp3), NULL), _tmp2 = (g_free (_tmp2), NULL), (_tmp1 == NULL) ? NULL : (_tmp1 = (vala_code_node_unref (_tmp1), NULL)), _tmp4);
				gee_list_insert ((GeeList*) self->temp_vars, 0, len_var);
				(len_var == NULL) ? NULL : (len_var = (vala_code_node_unref (len_var), NULL));
			}
		}
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	} else {
		if (VALA_IS_DELEGATE_TYPE (vala_local_variable_get_variable_type (local))) {
			ValaDelegateType* _tmp5;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp6;
			ValaDelegate* d;
			_tmp5 = NULL;
			deleg_type = (_tmp5 = VALA_DELEGATE_TYPE (vala_local_variable_get_variable_type (local)), (_tmp5 == NULL) ? NULL : vala_code_node_ref (_tmp5));
			_tmp6 = NULL;
			d = (_tmp6 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp6 == NULL) ? NULL : vala_code_node_ref (_tmp6));
			if (vala_delegate_get_has_target (d)) {
				char* _tmp10;
				char* _tmp9;
				ValaPointerType* _tmp8;
				ValaVoidType* _tmp7;
				ValaLocalVariable* _tmp11;
				ValaLocalVariable* target_var;
				/* create variable to store delegate target*/
				_tmp10 = NULL;
				_tmp9 = NULL;
				_tmp8 = NULL;
				_tmp7 = NULL;
				_tmp11 = NULL;
				target_var = (_tmp11 = vala_local_variable_new ((ValaDataType*) (_tmp8 = vala_pointer_type_new ((ValaDataType*) (_tmp7 = vala_void_type_new ()), NULL)), _tmp10 = vala_ccode_base_module_get_delegate_target_cname (self, _tmp9 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) local))), NULL, NULL), _tmp10 = (g_free (_tmp10), NULL), _tmp9 = (g_free (_tmp9), NULL), (_tmp8 == NULL) ? NULL : (_tmp8 = (vala_code_node_unref (_tmp8), NULL)), (_tmp7 == NULL) ? NULL : (_tmp7 = (vala_code_node_unref (_tmp7), NULL)), _tmp11);
				gee_list_insert ((GeeList*) self->temp_vars, 0, target_var);
				(target_var == NULL) ? NULL : (target_var = (vala_code_node_unref (target_var), NULL));
			}
			(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
			(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
		}
	}
	rhs = NULL;
	_tmp12 = FALSE;
	if (vala_local_variable_get_initializer (local) != NULL) {
		_tmp12 = vala_code_node_get_ccodenode ((ValaCodeNode*) vala_local_variable_get_initializer (local)) != NULL;
	} else {
		_tmp12 = FALSE;
	}
	if (_tmp12) {
		ValaCCodeExpression* _tmp14;
		ValaCCodeExpression* _tmp13;
		_tmp14 = NULL;
		_tmp13 = NULL;
		rhs = (_tmp14 = (_tmp13 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_local_variable_get_initializer (local))), (_tmp13 == NULL) ? NULL : vala_ccode_node_ref (_tmp13)), (rhs == NULL) ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL)), _tmp14);
		if (VALA_IS_ARRAY_TYPE (vala_local_variable_get_variable_type (local))) {
			ValaArrayType* _tmp15;
			ValaArrayType* array_type;
			ValaCCodeCommaExpression* ccomma;
			ValaLocalVariable* temp_var;
			ValaCCodeAssignment* _tmp17;
			ValaCCodeIdentifier* _tmp16;
			ValaCCodeIdentifier* _tmp22;
			ValaCCodeExpression* _tmp24;
			ValaCCodeExpression* _tmp23;
			_tmp15 = NULL;
			array_type = (_tmp15 = VALA_ARRAY_TYPE (vala_local_variable_get_variable_type (local)), (_tmp15 == NULL) ? NULL : vala_code_node_ref (_tmp15));
			ccomma = vala_ccode_comma_expression_new ();
			temp_var = vala_ccode_base_module_get_temp_variable (self, vala_local_variable_get_variable_type (local), TRUE, (ValaCodeNode*) local);
			gee_list_insert ((GeeList*) self->temp_vars, 0, temp_var);
			_tmp17 = NULL;
			_tmp16 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp17 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp16 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var))), rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
			(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
			(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
			{
				gint dim;
				dim = 1;
				for (; dim <= vala_array_type_get_rank (array_type); dim++) {
					char* _tmp19;
					char* _tmp18;
					ValaCCodeIdentifier* _tmp20;
					ValaCCodeIdentifier* lhs_array_len;
					ValaCCodeExpression* rhs_array_len;
					ValaCCodeAssignment* _tmp21;
					_tmp19 = NULL;
					_tmp18 = NULL;
					_tmp20 = NULL;
					lhs_array_len = (_tmp20 = vala_ccode_identifier_new (_tmp19 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp18 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) local)), dim)), _tmp19 = (g_free (_tmp19), NULL), _tmp18 = (g_free (_tmp18), NULL), _tmp20);
					rhs_array_len = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_local_variable_get_initializer (local), dim);
					_tmp21 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp21 = vala_ccode_assignment_new ((ValaCCodeExpression*) lhs_array_len, rhs_array_len, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
					(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
					(lhs_array_len == NULL) ? NULL : (lhs_array_len = (vala_ccode_node_unref (lhs_array_len), NULL));
					(rhs_array_len == NULL) ? NULL : (rhs_array_len = (vala_ccode_node_unref (rhs_array_len), NULL));
				}
			}
			_tmp22 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp22 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var))));
			(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
			_tmp24 = NULL;
			_tmp23 = NULL;
			rhs = (_tmp24 = (_tmp23 = (ValaCCodeExpression*) ccomma, (_tmp23 == NULL) ? NULL : vala_ccode_node_ref (_tmp23)), (rhs == NULL) ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL)), _tmp24);
			(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
			(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
			(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
		} else {
			if (VALA_IS_DELEGATE_TYPE (vala_local_variable_get_variable_type (local))) {
				ValaDelegateType* _tmp25;
				ValaDelegateType* deleg_type;
				ValaDelegate* _tmp26;
				ValaDelegate* d;
				_tmp25 = NULL;
				deleg_type = (_tmp25 = VALA_DELEGATE_TYPE (vala_local_variable_get_variable_type (local)), (_tmp25 == NULL) ? NULL : vala_code_node_ref (_tmp25));
				_tmp26 = NULL;
				d = (_tmp26 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp26 == NULL) ? NULL : vala_code_node_ref (_tmp26));
				if (vala_delegate_get_has_target (d)) {
					ValaCCodeCommaExpression* ccomma;
					ValaLocalVariable* temp_var;
					ValaCCodeAssignment* _tmp28;
					ValaCCodeIdentifier* _tmp27;
					char* _tmp30;
					char* _tmp29;
					ValaCCodeIdentifier* _tmp31;
					ValaCCodeIdentifier* lhs_delegate_target;
					ValaCCodeExpression* rhs_delegate_target;
					ValaCCodeAssignment* _tmp32;
					ValaCCodeIdentifier* _tmp33;
					ValaCCodeExpression* _tmp35;
					ValaCCodeExpression* _tmp34;
					ccomma = vala_ccode_comma_expression_new ();
					temp_var = vala_ccode_base_module_get_temp_variable (self, vala_local_variable_get_variable_type (local), TRUE, (ValaCodeNode*) local);
					gee_list_insert ((GeeList*) self->temp_vars, 0, temp_var);
					_tmp28 = NULL;
					_tmp27 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp28 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp27 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var))), rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
					(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
					(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
					_tmp30 = NULL;
					_tmp29 = NULL;
					_tmp31 = NULL;
					lhs_delegate_target = (_tmp31 = vala_ccode_identifier_new (_tmp30 = vala_ccode_base_module_get_delegate_target_cname (self, _tmp29 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) local)))), _tmp30 = (g_free (_tmp30), NULL), _tmp29 = (g_free (_tmp29), NULL), _tmp31);
					rhs_delegate_target = vala_ccode_base_module_get_delegate_target_cexpression (self, vala_local_variable_get_initializer (local));
					_tmp32 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp32 = vala_ccode_assignment_new ((ValaCCodeExpression*) lhs_delegate_target, rhs_delegate_target, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
					(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
					_tmp33 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp33 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var))));
					(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
					_tmp35 = NULL;
					_tmp34 = NULL;
					rhs = (_tmp35 = (_tmp34 = (ValaCCodeExpression*) ccomma, (_tmp34 == NULL) ? NULL : vala_ccode_node_ref (_tmp34)), (rhs == NULL) ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL)), _tmp35);
					(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
					(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
					(lhs_delegate_target == NULL) ? NULL : (lhs_delegate_target = (vala_ccode_node_unref (lhs_delegate_target), NULL));
					(rhs_delegate_target == NULL) ? NULL : (rhs_delegate_target = (vala_ccode_node_unref (rhs_delegate_target), NULL));
				}
				(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
				(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
			}
		}
	} else {
		if (vala_data_type_is_reference_type_or_type_parameter (vala_local_variable_get_variable_type (local))) {
			ValaCCodeExpression* _tmp36;
			_tmp36 = NULL;
			rhs = (_tmp36 = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL"), (rhs == NULL) ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL)), _tmp36);
			if (VALA_IS_ARRAY_TYPE (vala_local_variable_get_variable_type (local))) {
				ValaArrayType* _tmp37;
				ValaArrayType* array_type;
				ValaCCodeCommaExpression* ccomma;
				ValaCCodeExpression* _tmp44;
				ValaCCodeExpression* _tmp43;
				/* initialize array length variables*/
				_tmp37 = NULL;
				array_type = (_tmp37 = VALA_ARRAY_TYPE (vala_local_variable_get_variable_type (local)), (_tmp37 == NULL) ? NULL : vala_code_node_ref (_tmp37));
				ccomma = vala_ccode_comma_expression_new ();
				{
					gint dim;
					dim = 1;
					for (; dim <= vala_array_type_get_rank (array_type); dim++) {
						ValaCCodeAssignment* _tmp42;
						ValaCCodeConstant* _tmp41;
						ValaCCodeIdentifier* _tmp40;
						char* _tmp39;
						char* _tmp38;
						_tmp42 = NULL;
						_tmp41 = NULL;
						_tmp40 = NULL;
						_tmp39 = NULL;
						_tmp38 = NULL;
						vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp42 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp40 = vala_ccode_identifier_new (_tmp39 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp38 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) local)), dim))), (ValaCCodeExpression*) (_tmp41 = vala_ccode_constant_new ("0")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
						(_tmp42 == NULL) ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL));
						(_tmp41 == NULL) ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL));
						(_tmp40 == NULL) ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL));
						_tmp39 = (g_free (_tmp39), NULL);
						_tmp38 = (g_free (_tmp38), NULL);
					}
				}
				vala_ccode_comma_expression_append_expression (ccomma, rhs);
				_tmp44 = NULL;
				_tmp43 = NULL;
				rhs = (_tmp44 = (_tmp43 = (ValaCCodeExpression*) ccomma, (_tmp43 == NULL) ? NULL : vala_ccode_node_ref (_tmp43)), (rhs == NULL) ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL)), _tmp44);
				(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
				(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
			}
		}
	}
	_tmp45 = NULL;
	_tmp46 = NULL;
	cvar = (_tmp46 = vala_ccode_variable_declarator_new_with_initializer (_tmp45 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) local)), rhs), _tmp45 = (g_free (_tmp45), NULL), _tmp46);
	cfrag = vala_ccode_fragment_new ();
	_tmp47 = NULL;
	_tmp48 = NULL;
	cdecl_ = (_tmp48 = vala_ccode_declaration_new (_tmp47 = vala_data_type_get_cname (vala_local_variable_get_variable_type (local))), _tmp47 = (g_free (_tmp47), NULL), _tmp48);
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) cvar);
	vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) cdecl_);
	_tmp49 = FALSE;
	if (vala_local_variable_get_initializer (local) != NULL) {
		_tmp49 = vala_code_node_get_tree_can_fail ((ValaCodeNode*) vala_local_variable_get_initializer (local));
	} else {
		_tmp49 = FALSE;
	}
	if (_tmp49) {
		vala_ccode_module_add_simple_check (vala_ccode_module_get_head ((ValaCCodeModule*) self), (ValaCodeNode*) vala_local_variable_get_initializer (local), cfrag);
	}
	/* try to initialize uninitialized variables */
	if (vala_ccode_variable_declarator_get_initializer (cvar) == NULL) {
		ValaCCodeExpression* _tmp50;
		_tmp50 = NULL;
		vala_ccode_variable_declarator_set_initializer (cvar, _tmp50 = vala_ccode_base_module_default_value_for_type (self, vala_local_variable_get_variable_type (local), TRUE));
		(_tmp50 == NULL) ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL));
	}
	vala_code_node_set_ccodenode ((ValaCodeNode*) local, (ValaCCodeNode*) cfrag);
	vala_symbol_set_active ((ValaSymbol*) local, TRUE);
	(rhs == NULL) ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL));
	(cvar == NULL) ? NULL : (cvar = (vala_ccode_node_unref (cvar), NULL));
	(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
	(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
}


static void vala_ccode_base_module_real_visit_initializer_list (ValaCCodeModule* base, ValaInitializerList* list) {
	ValaCCodeBaseModule * self;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (list != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) list, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_expression_get_target_type ((ValaExpression*) list)))) {
		ValaStruct* _tmp0;
		ValaStruct* st;
		ValaCCodeInitializerList* clist;
		GeeList* _tmp1;
		GeeIterator* _tmp2;
		GeeIterator* field_it;
		/* initializer is used as struct initializer */
		_tmp0 = NULL;
		st = (_tmp0 = VALA_STRUCT (vala_data_type_get_data_type (vala_expression_get_target_type ((ValaExpression*) list))), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
		clist = vala_ccode_initializer_list_new ();
		_tmp1 = NULL;
		_tmp2 = NULL;
		field_it = (_tmp2 = gee_iterable_iterator ((GeeIterable*) (_tmp1 = vala_struct_get_fields (st))), (_tmp1 == NULL) ? NULL : (_tmp1 = (gee_collection_object_unref (_tmp1), NULL)), _tmp2);
		{
			GeeList* _tmp3;
			GeeIterator* _tmp4;
			GeeIterator* expr_it;
			_tmp3 = NULL;
			_tmp4 = NULL;
			expr_it = (_tmp4 = gee_iterable_iterator ((GeeIterable*) (_tmp3 = vala_initializer_list_get_initializers (list))), (_tmp3 == NULL) ? NULL : (_tmp3 = (gee_collection_object_unref (_tmp3), NULL)), _tmp4);
			while (gee_iterator_next (expr_it)) {
				ValaExpression* expr;
				ValaField* field;
				ValaCCodeExpression* _tmp7;
				ValaCCodeExpression* cexpr;
				char* ctype;
				expr = (ValaExpression*) gee_iterator_get (expr_it);
				field = NULL;
				while (field == NULL) {
					ValaField* _tmp5;
					gee_iterator_next (field_it);
					_tmp5 = NULL;
					field = (_tmp5 = (ValaField*) gee_iterator_get (field_it), (field == NULL) ? NULL : (field = (vala_code_node_unref (field), NULL)), _tmp5);
					if (vala_field_get_binding (field) != MEMBER_BINDING_INSTANCE) {
						ValaField* _tmp6;
						/* we only initialize instance fields*/
						_tmp6 = NULL;
						field = (_tmp6 = NULL, (field == NULL) ? NULL : (field = (vala_code_node_unref (field), NULL)), _tmp6);
					}
				}
				_tmp7 = NULL;
				cexpr = (_tmp7 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) expr)), (_tmp7 == NULL) ? NULL : vala_ccode_node_ref (_tmp7));
				ctype = vala_field_get_ctype (field);
				if (ctype != NULL) {
					ValaCCodeExpression* _tmp8;
					_tmp8 = NULL;
					cexpr = (_tmp8 = (ValaCCodeExpression*) vala_ccode_cast_expression_new (cexpr, ctype), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp8);
				}
				vala_ccode_initializer_list_append (clist, cexpr);
				(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
				(field == NULL) ? NULL : (field = (vala_code_node_unref (field), NULL));
				(cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL));
				ctype = (g_free (ctype), NULL);
			}
			(expr_it == NULL) ? NULL : (expr_it = (gee_collection_object_unref (expr_it), NULL));
		}
		vala_code_node_set_ccodenode ((ValaCodeNode*) list, (ValaCCodeNode*) clist);
		(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
		(clist == NULL) ? NULL : (clist = (vala_ccode_node_unref (clist), NULL));
		(field_it == NULL) ? NULL : (field_it = (gee_collection_object_unref (field_it), NULL));
	} else {
		ValaCCodeInitializerList* clist;
		clist = vala_ccode_initializer_list_new ();
		{
			GeeList* _tmp9;
			GeeIterator* _tmp10;
			GeeIterator* expr_it;
			_tmp9 = NULL;
			_tmp10 = NULL;
			expr_it = (_tmp10 = gee_iterable_iterator ((GeeIterable*) (_tmp9 = vala_initializer_list_get_initializers (list))), (_tmp9 == NULL) ? NULL : (_tmp9 = (gee_collection_object_unref (_tmp9), NULL)), _tmp10);
			while (gee_iterator_next (expr_it)) {
				ValaExpression* expr;
				expr = (ValaExpression*) gee_iterator_get (expr_it);
				vala_ccode_initializer_list_append (clist, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) expr)));
				(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
			}
			(expr_it == NULL) ? NULL : (expr_it = (gee_collection_object_unref (expr_it), NULL));
		}
		vala_code_node_set_ccodenode ((ValaCodeNode*) list, (ValaCCodeNode*) clist);
		(clist == NULL) ? NULL : (clist = (vala_ccode_node_unref (clist), NULL));
	}
}


ValaLocalVariable* vala_ccode_base_module_get_temp_variable (ValaCCodeBaseModule* self, ValaDataType* type, gboolean value_owned, ValaCodeNode* node_reference) {
	ValaDataType* var_type;
	char* _tmp0;
	ValaLocalVariable* _tmp1;
	ValaLocalVariable* local;
	ValaLocalVariable* _tmp2;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	var_type = vala_data_type_copy (type);
	vala_data_type_set_value_owned (var_type, value_owned);
	_tmp0 = NULL;
	_tmp1 = NULL;
	local = (_tmp1 = vala_local_variable_new (var_type, _tmp0 = g_strdup_printf ("_tmp%d", self->next_temp_var_id), NULL, NULL), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
	if (node_reference != NULL) {
		vala_code_node_set_source_reference ((ValaCodeNode*) local, vala_code_node_get_source_reference (node_reference));
	}
	self->next_temp_var_id++;
	_tmp2 = NULL;
	return (_tmp2 = local, (var_type == NULL) ? NULL : (var_type = (vala_code_node_unref (var_type), NULL)), _tmp2);
}


static ValaCCodeExpression* vala_ccode_base_module_get_type_id_expression (ValaCCodeBaseModule* self, ValaDataType* type) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	if (VALA_IS_GENERIC_TYPE (type)) {
		char* _tmp0;
		char* _tmp1;
		char* var_name;
		ValaCCodeMemberAccess* _tmp3;
		ValaCCodeIdentifier* _tmp2;
		ValaCCodeExpression* _tmp4;
		ValaCCodeExpression* _tmp5;
		_tmp0 = NULL;
		_tmp1 = NULL;
		var_name = (_tmp1 = g_strdup_printf ("%s_type", _tmp0 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) vala_data_type_get_type_parameter (type)), -1)), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
		_tmp3 = NULL;
		_tmp2 = NULL;
		_tmp4 = NULL;
		_tmp5 = NULL;
		return (_tmp5 = (_tmp4 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp3 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp2 = vala_ccode_identifier_new ("self")), "priv")), var_name), (_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)), (_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)), _tmp4), var_name = (g_free (var_name), NULL), _tmp5);
	} else {
		char* type_id;
		ValaCCodeExpression* _tmp7;
		type_id = vala_data_type_get_type_id (type);
		if (type_id == NULL) {
			char* _tmp6;
			_tmp6 = NULL;
			type_id = (_tmp6 = g_strdup ("G_TYPE_INVALID"), type_id = (g_free (type_id), NULL), _tmp6);
		}
		_tmp7 = NULL;
		return (_tmp7 = (ValaCCodeExpression*) vala_ccode_identifier_new (type_id), type_id = (g_free (type_id), NULL), _tmp7);
	}
}


static ValaCCodeExpression* vala_ccode_base_module_real_get_dup_func_expression (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	if (VALA_IS_ERROR_TYPE (type)) {
		return (ValaCCodeExpression*) vala_ccode_identifier_new ("g_error_copy");
	} else {
		if (vala_data_type_get_data_type (type) != NULL) {
			char* dup_function;
			ValaClass* _tmp2;
			ValaTypeSymbol* _tmp1;
			ValaClass* cl;
			ValaCCodeExpression* _tmp14;
			dup_function = NULL;
			_tmp2 = NULL;
			_tmp1 = NULL;
			cl = (_tmp2 = (_tmp1 = vala_data_type_get_data_type (type), VALA_IS_CLASS (_tmp1) ? ((ValaClass*) _tmp1) : NULL), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
			if (vala_typesymbol_is_reference_counting (vala_data_type_get_data_type (type))) {
				char* _tmp3;
				gboolean _tmp4;
				_tmp3 = NULL;
				dup_function = (_tmp3 = vala_typesymbol_get_ref_function (vala_data_type_get_data_type (type)), dup_function = (g_free (dup_function), NULL), _tmp3);
				_tmp4 = FALSE;
				if (VALA_IS_INTERFACE (vala_data_type_get_data_type (type))) {
					_tmp4 = dup_function == NULL;
				} else {
					_tmp4 = FALSE;
				}
				if (_tmp4) {
					char* _tmp6;
					char* _tmp5;
					ValaCCodeExpression* _tmp7;
					_tmp6 = NULL;
					_tmp5 = NULL;
					vala_report_error (source_reference, _tmp6 = g_strdup_printf ("missing class prerequisite for interface `%s'", _tmp5 = vala_symbol_get_full_name ((ValaSymbol*) vala_data_type_get_data_type (type))));
					_tmp6 = (g_free (_tmp6), NULL);
					_tmp5 = (g_free (_tmp5), NULL);
					_tmp7 = NULL;
					return (_tmp7 = NULL, dup_function = (g_free (dup_function), NULL), (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), _tmp7);
				}
			} else {
				gboolean _tmp8;
				_tmp8 = FALSE;
				if (cl != NULL) {
					_tmp8 = vala_class_get_is_immutable (cl);
				} else {
					_tmp8 = FALSE;
				}
				if (_tmp8) {
					char* _tmp9;
					/* allow duplicates of immutable instances as for example strings*/
					_tmp9 = NULL;
					dup_function = (_tmp9 = vala_typesymbol_get_dup_function (vala_data_type_get_data_type (type)), dup_function = (g_free (dup_function), NULL), _tmp9);
				} else {
					if (VALA_IS_VALUE_TYPE (type)) {
						if (vala_data_type_get_nullable (type)) {
							char* _tmp10;
							_tmp10 = NULL;
							dup_function = (_tmp10 = vala_ccode_base_module_generate_struct_dup_wrapper (self, VALA_VALUE_TYPE (type)), dup_function = (g_free (dup_function), NULL), _tmp10);
						} else {
							char* _tmp11;
							_tmp11 = NULL;
							dup_function = (_tmp11 = g_strdup (""), dup_function = (g_free (dup_function), NULL), _tmp11);
						}
					} else {
						char* _tmp12;
						ValaCCodeExpression* _tmp13;
						/* duplicating non-reference counted objects may cause side-effects (and performance issues)*/
						_tmp12 = NULL;
						vala_report_error (source_reference, _tmp12 = g_strdup_printf ("duplicating %s instance, use weak variable or explicitly invoke copy method", vala_symbol_get_name ((ValaSymbol*) vala_data_type_get_data_type (type))));
						_tmp12 = (g_free (_tmp12), NULL);
						_tmp13 = NULL;
						return (_tmp13 = NULL, dup_function = (g_free (dup_function), NULL), (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), _tmp13);
					}
				}
			}
			_tmp14 = NULL;
			return (_tmp14 = (ValaCCodeExpression*) vala_ccode_identifier_new (dup_function), dup_function = (g_free (dup_function), NULL), (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), _tmp14);
		} else {
			gboolean _tmp15;
			_tmp15 = FALSE;
			if (vala_data_type_get_type_parameter (type) != NULL) {
				_tmp15 = VALA_IS_CLASS (self->current_type_symbol);
			} else {
				_tmp15 = FALSE;
			}
			if (_tmp15) {
				char* _tmp16;
				char* _tmp17;
				char* func_name;
				ValaCCodeMemberAccess* _tmp19;
				ValaCCodeIdentifier* _tmp18;
				ValaCCodeExpression* _tmp20;
				ValaCCodeExpression* _tmp21;
				_tmp16 = NULL;
				_tmp17 = NULL;
				func_name = (_tmp17 = g_strdup_printf ("%s_dup_func", _tmp16 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) vala_data_type_get_type_parameter (type)), -1)), _tmp16 = (g_free (_tmp16), NULL), _tmp17);
				_tmp19 = NULL;
				_tmp18 = NULL;
				_tmp20 = NULL;
				_tmp21 = NULL;
				return (_tmp21 = (_tmp20 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp19 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp18 = vala_ccode_identifier_new ("self")), "priv")), func_name), (_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)), (_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)), _tmp20), func_name = (g_free (func_name), NULL), _tmp21);
			} else {
				if (VALA_IS_POINTER_TYPE (type)) {
					ValaPointerType* _tmp22;
					ValaPointerType* pointer_type;
					ValaCCodeExpression* _tmp23;
					_tmp22 = NULL;
					pointer_type = (_tmp22 = VALA_POINTER_TYPE (type), (_tmp22 == NULL) ? NULL : vala_code_node_ref (_tmp22));
					_tmp23 = NULL;
					return (_tmp23 = vala_ccode_base_module_get_dup_func_expression (self, vala_pointer_type_get_base_type (pointer_type), source_reference), (pointer_type == NULL) ? NULL : (pointer_type = (vala_code_node_unref (pointer_type), NULL)), _tmp23);
				} else {
					return (ValaCCodeExpression*) vala_ccode_constant_new ("NULL");
				}
			}
		}
	}
}


ValaCCodeExpression* vala_ccode_base_module_get_dup_func_expression (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference) {
	return VALA_CCODE_BASE_MODULE_GET_CLASS (self)->get_dup_func_expression (self, type, source_reference);
}


static char* vala_ccode_base_module_generate_struct_dup_wrapper (ValaCCodeBaseModule* self, ValaValueType* value_type) {
	char* _tmp0;
	char* _tmp1;
	char* dup_func;
	char* _tmp3;
	ValaCCodeFunction* _tmp4;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp6;
	char* _tmp5;
	ValaCCodeBlock* block;
	ValaCCodeIdentifier* _tmp7;
	ValaCCodeFunctionCall* _tmp8;
	ValaCCodeFunctionCall* dup_call;
	ValaCCodeIdentifier* _tmp9;
	ValaCCodeIdentifier* _tmp10;
	ValaCCodeFunctionCall* _tmp11;
	ValaCCodeFunctionCall* sizeof_call;
	ValaCCodeIdentifier* _tmp13;
	char* _tmp12;
	ValaCCodeReturnStatement* _tmp14;
	ValaCCodeFunction* _tmp15;
	char* _tmp16;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (value_type != NULL, NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	dup_func = (_tmp1 = g_strdup_printf ("_%sdup", _tmp0 = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) vala_value_type_get_type_symbol (value_type))), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
	if (!vala_ccode_base_module_add_wrapper (self, dup_func)) {
		/* wrapper already defined*/
		return dup_func;
	}
	/* declaration*/
	_tmp3 = NULL;
	_tmp4 = NULL;
	function = (_tmp4 = vala_ccode_function_new (dup_func, _tmp3 = vala_data_type_get_cname ((ValaDataType*) value_type)), _tmp3 = (g_free (_tmp3), NULL), _tmp4);
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp6 = NULL;
	_tmp5 = NULL;
	vala_ccode_function_add_parameter (function, _tmp6 = vala_ccode_formal_parameter_new ("self", _tmp5 = vala_data_type_get_cname ((ValaDataType*) value_type)));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	_tmp5 = (g_free (_tmp5), NULL);
	/* definition*/
	block = vala_ccode_block_new ();
	_tmp7 = NULL;
	_tmp8 = NULL;
	dup_call = (_tmp8 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new ("g_memdup"))), (_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)), _tmp8);
	_tmp9 = NULL;
	vala_ccode_function_call_add_argument (dup_call, (ValaCCodeExpression*) (_tmp9 = vala_ccode_identifier_new ("self")));
	(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	_tmp10 = NULL;
	_tmp11 = NULL;
	sizeof_call = (_tmp11 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp10 = vala_ccode_identifier_new ("sizeof"))), (_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)), _tmp11);
	_tmp13 = NULL;
	_tmp12 = NULL;
	vala_ccode_function_call_add_argument (sizeof_call, (ValaCCodeExpression*) (_tmp13 = vala_ccode_identifier_new (_tmp12 = vala_typesymbol_get_cname (vala_value_type_get_type_symbol (value_type), FALSE))));
	(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
	_tmp12 = (g_free (_tmp12), NULL);
	vala_ccode_function_call_add_argument (dup_call, (ValaCCodeExpression*) sizeof_call);
	_tmp14 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp14 = vala_ccode_return_statement_new ((ValaCCodeExpression*) dup_call)));
	(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
	/* append to file*/
	_tmp15 = NULL;
	vala_ccode_fragment_append (self->source_type_member_declaration, (ValaCCodeNode*) (_tmp15 = vala_ccode_function_copy (function)));
	(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (self->source_type_member_definition, (ValaCCodeNode*) function);
	_tmp16 = NULL;
	return (_tmp16 = dup_func, (function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL)), (block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL)), (dup_call == NULL) ? NULL : (dup_call = (vala_ccode_node_unref (dup_call), NULL)), (sizeof_call == NULL) ? NULL : (sizeof_call = (vala_ccode_node_unref (sizeof_call), NULL)), _tmp16);
}


ValaCCodeExpression* vala_ccode_base_module_get_destroy_func_expression (ValaCCodeBaseModule* self, ValaDataType* type) {
	gboolean _tmp0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp0 = FALSE;
	if (vala_data_type_get_data_type (type) == VALA_TYPESYMBOL (self->glist_type)) {
		_tmp0 = TRUE;
	} else {
		_tmp0 = vala_data_type_get_data_type (type) == VALA_TYPESYMBOL (self->gslist_type);
	}
	if (_tmp0) {
		gboolean elements_require_free;
		ValaCCodeExpression* element_destroy_func_expression;
		gboolean _tmp4;
		/* create wrapper function to free list elements if necessary*/
		elements_require_free = FALSE;
		element_destroy_func_expression = NULL;
		{
			GeeList* _tmp1;
			GeeIterator* _tmp2;
			GeeIterator* type_arg_it;
			_tmp1 = NULL;
			_tmp2 = NULL;
			type_arg_it = (_tmp2 = gee_iterable_iterator ((GeeIterable*) (_tmp1 = vala_data_type_get_type_arguments (type))), (_tmp1 == NULL) ? NULL : (_tmp1 = (gee_collection_object_unref (_tmp1), NULL)), _tmp2);
			while (gee_iterator_next (type_arg_it)) {
				ValaDataType* type_arg;
				type_arg = (ValaDataType*) gee_iterator_get (type_arg_it);
				elements_require_free = vala_ccode_base_module_requires_destroy (self, type_arg);
				if (elements_require_free) {
					ValaCCodeExpression* _tmp3;
					_tmp3 = NULL;
					element_destroy_func_expression = (_tmp3 = vala_ccode_base_module_get_destroy_func_expression (self, type_arg), (element_destroy_func_expression == NULL) ? NULL : (element_destroy_func_expression = (vala_ccode_node_unref (element_destroy_func_expression), NULL)), _tmp3);
				}
				(type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL));
			}
			(type_arg_it == NULL) ? NULL : (type_arg_it = (gee_collection_object_unref (type_arg_it), NULL));
		}
		_tmp4 = FALSE;
		if (elements_require_free) {
			_tmp4 = VALA_IS_CCODE_IDENTIFIER (element_destroy_func_expression);
		} else {
			_tmp4 = FALSE;
		}
		if (_tmp4) {
			char* _tmp5;
			ValaCCodeExpression* _tmp6;
			ValaCCodeExpression* _tmp7;
			_tmp5 = NULL;
			_tmp6 = NULL;
			_tmp7 = NULL;
			return (_tmp7 = (_tmp6 = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp5 = vala_ccode_base_module_generate_glist_free_wrapper (self, type, VALA_CCODE_IDENTIFIER (element_destroy_func_expression))), _tmp5 = (g_free (_tmp5), NULL), _tmp6), (element_destroy_func_expression == NULL) ? NULL : (element_destroy_func_expression = (vala_ccode_node_unref (element_destroy_func_expression), NULL)), _tmp7);
		} else {
			char* _tmp8;
			ValaCCodeExpression* _tmp9;
			ValaCCodeExpression* _tmp10;
			_tmp8 = NULL;
			_tmp9 = NULL;
			_tmp10 = NULL;
			return (_tmp10 = (_tmp9 = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp8 = vala_typesymbol_get_free_function (vala_data_type_get_data_type (type))), _tmp8 = (g_free (_tmp8), NULL), _tmp9), (element_destroy_func_expression == NULL) ? NULL : (element_destroy_func_expression = (vala_ccode_node_unref (element_destroy_func_expression), NULL)), _tmp10);
		}
		(element_destroy_func_expression == NULL) ? NULL : (element_destroy_func_expression = (vala_ccode_node_unref (element_destroy_func_expression), NULL));
	} else {
		if (VALA_IS_ERROR_TYPE (type)) {
			return (ValaCCodeExpression*) vala_ccode_identifier_new ("g_error_free");
		} else {
			if (vala_data_type_get_data_type (type) != NULL) {
				char* unref_function;
				ValaCCodeExpression* _tmp23;
				unref_function = NULL;
				if (VALA_IS_REFERENCE_TYPE (type)) {
					if (vala_typesymbol_is_reference_counting (vala_data_type_get_data_type (type))) {
						char* _tmp12;
						gboolean _tmp13;
						_tmp12 = NULL;
						unref_function = (_tmp12 = vala_typesymbol_get_unref_function (vala_data_type_get_data_type (type)), unref_function = (g_free (unref_function), NULL), _tmp12);
						_tmp13 = FALSE;
						if (VALA_IS_INTERFACE (vala_data_type_get_data_type (type))) {
							_tmp13 = unref_function == NULL;
						} else {
							_tmp13 = FALSE;
						}
						if (_tmp13) {
							char* _tmp15;
							char* _tmp14;
							ValaCCodeExpression* _tmp16;
							_tmp15 = NULL;
							_tmp14 = NULL;
							vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) type), _tmp15 = g_strdup_printf ("missing class prerequisite for interface `%s'", _tmp14 = vala_symbol_get_full_name ((ValaSymbol*) vala_data_type_get_data_type (type))));
							_tmp15 = (g_free (_tmp15), NULL);
							_tmp14 = (g_free (_tmp14), NULL);
							_tmp16 = NULL;
							return (_tmp16 = NULL, unref_function = (g_free (unref_function), NULL), _tmp16);
						}
					} else {
						char* _tmp17;
						_tmp17 = NULL;
						unref_function = (_tmp17 = vala_typesymbol_get_free_function (vala_data_type_get_data_type (type)), unref_function = (g_free (unref_function), NULL), _tmp17);
					}
				} else {
					if (vala_data_type_get_nullable (type)) {
						char* _tmp18;
						_tmp18 = NULL;
						unref_function = (_tmp18 = vala_typesymbol_get_free_function (vala_data_type_get_data_type (type)), unref_function = (g_free (unref_function), NULL), _tmp18);
						if (unref_function == NULL) {
							char* _tmp19;
							_tmp19 = NULL;
							unref_function = (_tmp19 = g_strdup ("g_free"), unref_function = (g_free (unref_function), NULL), _tmp19);
						}
					} else {
						ValaStruct* _tmp20;
						ValaStruct* st;
						char* _tmp21;
						_tmp20 = NULL;
						st = (_tmp20 = VALA_STRUCT (vala_data_type_get_data_type (type)), (_tmp20 == NULL) ? NULL : vala_code_node_ref (_tmp20));
						_tmp21 = NULL;
						unref_function = (_tmp21 = vala_typesymbol_get_destroy_function ((ValaTypeSymbol*) st), unref_function = (g_free (unref_function), NULL), _tmp21);
						(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
					}
				}
				if (unref_function == NULL) {
					ValaCCodeExpression* _tmp22;
					_tmp22 = NULL;
					return (_tmp22 = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL"), unref_function = (g_free (unref_function), NULL), _tmp22);
				}
				_tmp23 = NULL;
				return (_tmp23 = (ValaCCodeExpression*) vala_ccode_identifier_new (unref_function), unref_function = (g_free (unref_function), NULL), _tmp23);
			} else {
				gboolean _tmp24;
				_tmp24 = FALSE;
				if (vala_data_type_get_type_parameter (type) != NULL) {
					_tmp24 = VALA_IS_CLASS (self->current_type_symbol);
				} else {
					_tmp24 = FALSE;
				}
				if (_tmp24) {
					char* _tmp25;
					char* _tmp26;
					char* func_name;
					ValaCCodeMemberAccess* _tmp28;
					ValaCCodeIdentifier* _tmp27;
					ValaCCodeExpression* _tmp29;
					ValaCCodeExpression* _tmp30;
					_tmp25 = NULL;
					_tmp26 = NULL;
					func_name = (_tmp26 = g_strdup_printf ("%s_destroy_func", _tmp25 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) vala_data_type_get_type_parameter (type)), -1)), _tmp25 = (g_free (_tmp25), NULL), _tmp26);
					_tmp28 = NULL;
					_tmp27 = NULL;
					_tmp29 = NULL;
					_tmp30 = NULL;
					return (_tmp30 = (_tmp29 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp28 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp27 = vala_ccode_identifier_new ("self")), "priv")), func_name), (_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL)), (_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL)), _tmp29), func_name = (g_free (func_name), NULL), _tmp30);
				} else {
					if (VALA_IS_ARRAY_TYPE (type)) {
						return (ValaCCodeExpression*) vala_ccode_identifier_new ("g_free");
					} else {
						if (VALA_IS_POINTER_TYPE (type)) {
							return (ValaCCodeExpression*) vala_ccode_identifier_new ("g_free");
						} else {
							return (ValaCCodeExpression*) vala_ccode_constant_new ("NULL");
						}
					}
				}
			}
		}
	}
}


static char* vala_ccode_base_module_generate_glist_free_wrapper (ValaCCodeBaseModule* self, ValaDataType* list_type, ValaCCodeIdentifier* element_destroy_func_expression) {
	char* _tmp0;
	char* _tmp1;
	char* destroy_func;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp4;
	char* _tmp3;
	ValaCCodeBlock* block;
	ValaCCodeFunctionCall* element_free_call;
	ValaCCodeIdentifier* _tmp9;
	ValaCCodeCastExpression* _tmp10;
	ValaCCodeConstant* _tmp11;
	ValaCCodeExpressionStatement* _tmp12;
	ValaCCodeIdentifier* _tmp14;
	char* _tmp13;
	ValaCCodeFunctionCall* _tmp15;
	ValaCCodeFunctionCall* cfreecall;
	ValaCCodeIdentifier* _tmp16;
	ValaCCodeExpressionStatement* _tmp17;
	ValaCCodeFunction* _tmp18;
	char* _tmp19;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (list_type != NULL, NULL);
	g_return_val_if_fail (element_destroy_func_expression != NULL, NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	destroy_func = (_tmp1 = g_strdup_printf ("_%s_%s", _tmp0 = vala_typesymbol_get_free_function (vala_data_type_get_data_type (list_type)), vala_ccode_identifier_get_name (element_destroy_func_expression)), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
	if (!vala_ccode_base_module_add_wrapper (self, destroy_func)) {
		/* wrapper already defined*/
		return destroy_func;
	}
	/* declaration*/
	function = vala_ccode_function_new (destroy_func, "void");
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (function, _tmp4 = vala_ccode_formal_parameter_new ("self", _tmp3 = vala_data_type_get_cname (list_type)));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp3 = (g_free (_tmp3), NULL);
	/* definition*/
	block = vala_ccode_block_new ();
	element_free_call = NULL;
	if (vala_data_type_get_data_type (list_type) == VALA_TYPESYMBOL (self->glist_type)) {
		ValaCCodeFunctionCall* _tmp6;
		ValaCCodeIdentifier* _tmp5;
		_tmp6 = NULL;
		_tmp5 = NULL;
		element_free_call = (_tmp6 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp5 = vala_ccode_identifier_new ("g_list_foreach"))), (element_free_call == NULL) ? NULL : (element_free_call = (vala_ccode_node_unref (element_free_call), NULL)), _tmp6);
		(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	} else {
		ValaCCodeFunctionCall* _tmp8;
		ValaCCodeIdentifier* _tmp7;
		_tmp8 = NULL;
		_tmp7 = NULL;
		element_free_call = (_tmp8 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new ("g_slist_foreach"))), (element_free_call == NULL) ? NULL : (element_free_call = (vala_ccode_node_unref (element_free_call), NULL)), _tmp8);
		(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	}
	_tmp9 = NULL;
	vala_ccode_function_call_add_argument (element_free_call, (ValaCCodeExpression*) (_tmp9 = vala_ccode_identifier_new ("self")));
	(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	_tmp10 = NULL;
	vala_ccode_function_call_add_argument (element_free_call, (ValaCCodeExpression*) (_tmp10 = vala_ccode_cast_expression_new ((ValaCCodeExpression*) element_destroy_func_expression, "GFunc")));
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	_tmp11 = NULL;
	vala_ccode_function_call_add_argument (element_free_call, (ValaCCodeExpression*) (_tmp11 = vala_ccode_constant_new ("NULL")));
	(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
	_tmp12 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp12 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) element_free_call)));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	_tmp14 = NULL;
	_tmp13 = NULL;
	_tmp15 = NULL;
	cfreecall = (_tmp15 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp14 = vala_ccode_identifier_new (_tmp13 = vala_typesymbol_get_free_function (vala_data_type_get_data_type (list_type))))), (_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)), _tmp13 = (g_free (_tmp13), NULL), _tmp15);
	_tmp16 = NULL;
	vala_ccode_function_call_add_argument (cfreecall, (ValaCCodeExpression*) (_tmp16 = vala_ccode_identifier_new ("self")));
	(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
	_tmp17 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp17 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cfreecall)));
	(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
	/* append to file*/
	_tmp18 = NULL;
	vala_ccode_fragment_append (self->source_type_member_declaration, (ValaCCodeNode*) (_tmp18 = vala_ccode_function_copy (function)));
	(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (self->source_type_member_definition, (ValaCCodeNode*) function);
	_tmp19 = NULL;
	return (_tmp19 = destroy_func, (function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL)), (block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL)), (element_free_call == NULL) ? NULL : (element_free_call = (vala_ccode_node_unref (element_free_call), NULL)), (cfreecall == NULL) ? NULL : (cfreecall = (vala_ccode_node_unref (cfreecall), NULL)), _tmp19);
}


ValaCCodeExpression* vala_ccode_base_module_get_unref_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr) {
	ValaCCodeExpression* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* ccall;
	gboolean _tmp2;
	ValaCCodeConstant* _tmp12;
	ValaCCodeBinaryExpression* _tmp13;
	ValaCCodeBinaryExpression* cisnull;
	ValaCCodeCommaExpression* ccomma;
	gboolean _tmp20;
	ValaCCodeConstant* _tmp30;
	ValaCCodeAssignment* cassign;
	gboolean _tmp31;
	gboolean _tmp32;
	gboolean uses_gfree;
	gboolean _tmp34;
	ValaCCodeConstant* _tmp36;
	ValaCCodeExpression* _tmp37;
	ValaCCodeExpression* _tmp38;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cvar != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	ccall = (_tmp1 = vala_ccode_function_call_new (_tmp0 = vala_ccode_base_module_get_destroy_func_expression (self, type)), (_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)), _tmp1);
	_tmp2 = FALSE;
	if (VALA_IS_VALUE_TYPE (type)) {
		_tmp2 = !vala_data_type_get_nullable (type);
	} else {
		_tmp2 = FALSE;
	}
	if (_tmp2) {
		ValaCCodeUnaryExpression* _tmp3;
		/* normal value type, no null check*/
		_tmp3 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp3 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, cvar)));
		(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
		if (vala_data_type_get_data_type (type) == VALA_TYPESYMBOL (self->gvalue_type)) {
			ValaCCodeIdentifier* _tmp4;
			ValaCCodeFunctionCall* _tmp5;
			ValaCCodeFunctionCall* cisvalid;
			ValaCCodeUnaryExpression* _tmp6;
			ValaCCodeCommaExpression* ccomma;
			ValaCCodeConstant* _tmp7;
			ValaCCodeConstant* _tmp8;
			ValaCCodeExpression* _tmp9;
			ValaCCodeExpression* _tmp10;
			/* g_value_unset must not be called for already unset values*/
			_tmp4 = NULL;
			_tmp5 = NULL;
			cisvalid = (_tmp5 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp4 = vala_ccode_identifier_new ("G_IS_VALUE"))), (_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)), _tmp5);
			_tmp6 = NULL;
			vala_ccode_function_call_add_argument (cisvalid, (ValaCCodeExpression*) (_tmp6 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, cvar)));
			(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
			ccomma = vala_ccode_comma_expression_new ();
			vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) ccall);
			_tmp7 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp7 = vala_ccode_constant_new ("NULL")));
			(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
			_tmp8 = NULL;
			_tmp9 = NULL;
			_tmp10 = NULL;
			return (_tmp10 = (_tmp9 = (ValaCCodeExpression*) vala_ccode_conditional_expression_new ((ValaCCodeExpression*) cisvalid, (ValaCCodeExpression*) ccomma, (ValaCCodeExpression*) (_tmp8 = vala_ccode_constant_new ("NULL"))), (_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)), _tmp9), (cisvalid == NULL) ? NULL : (cisvalid = (vala_ccode_node_unref (cisvalid), NULL)), (ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL)), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp10);
		} else {
			return (ValaCCodeExpression*) ccall;
		}
	}
	/* (foo == NULL ? NULL : foo = (unref (foo), NULL)) 
	 can be simplified to
	 * foo = (unref (foo), NULL)
	 * if foo is of static type non-null
	 */
	_tmp12 = NULL;
	_tmp13 = NULL;
	cisnull = (_tmp13 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, cvar, (ValaCCodeExpression*) (_tmp12 = vala_ccode_constant_new ("NULL"))), (_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)), _tmp13);
	if (vala_data_type_get_type_parameter (type) != NULL) {
		gboolean _tmp14;
		ValaCCodeConstant* _tmp17;
		ValaCCodeExpression* _tmp16;
		ValaCCodeBinaryExpression* _tmp18;
		ValaCCodeBinaryExpression* cunrefisnull;
		ValaCCodeBinaryExpression* _tmp19;
		_tmp14 = FALSE;
		if (!(VALA_IS_CLASS (self->current_type_symbol))) {
			_tmp14 = TRUE;
		} else {
			_tmp14 = vala_class_get_is_compact (self->current_class);
		}
		if (_tmp14) {
			ValaCCodeExpression* _tmp15;
			_tmp15 = NULL;
			return (_tmp15 = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL"), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), (cisnull == NULL) ? NULL : (cisnull = (vala_ccode_node_unref (cisnull), NULL)), _tmp15);
		}
		/* unref functions are optional for type parameters*/
		_tmp17 = NULL;
		_tmp16 = NULL;
		_tmp18 = NULL;
		cunrefisnull = (_tmp18 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp16 = vala_ccode_base_module_get_destroy_func_expression (self, type), (ValaCCodeExpression*) (_tmp17 = vala_ccode_constant_new ("NULL"))), (_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)), (_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)), _tmp18);
		_tmp19 = NULL;
		cisnull = (_tmp19 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, (ValaCCodeExpression*) cisnull, (ValaCCodeExpression*) cunrefisnull), (cisnull == NULL) ? NULL : (cisnull = (vala_ccode_node_unref (cisnull), NULL)), _tmp19);
		(cunrefisnull == NULL) ? NULL : (cunrefisnull = (vala_ccode_node_unref (cunrefisnull), NULL));
	}
	vala_ccode_function_call_add_argument (ccall, cvar);
	/* set freed references to NULL to prevent further use */
	ccomma = vala_ccode_comma_expression_new ();
	_tmp20 = FALSE;
	if (vala_data_type_get_data_type (type) == self->gstringbuilder_type) {
		_tmp20 = TRUE;
	} else {
		_tmp20 = vala_data_type_get_data_type (type) == self->garray_type;
	}
	if (_tmp20) {
		ValaCCodeConstant* _tmp21;
		_tmp21 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp21 = vala_ccode_constant_new ("TRUE")));
		(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
	} else {
		if (VALA_IS_ARRAY_TYPE (type)) {
			ValaArrayType* _tmp22;
			ValaArrayType* array_type;
			gboolean _tmp23;
			_tmp22 = NULL;
			array_type = (_tmp22 = VALA_ARRAY_TYPE (type), (_tmp22 == NULL) ? NULL : vala_code_node_ref (_tmp22));
			_tmp23 = FALSE;
			if (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == NULL) {
				_tmp23 = TRUE;
			} else {
				_tmp23 = vala_typesymbol_is_reference_type (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)));
			}
			if (_tmp23) {
				gboolean first;
				ValaCCodeExpression* csizeexpr;
				ValaCCodeIdentifier* _tmp27;
				ValaCCodeCastExpression* _tmp29;
				ValaCCodeExpression* _tmp28;
				self->requires_array_free = TRUE;
				first = TRUE;
				csizeexpr = NULL;
				{
					gint dim;
					dim = 1;
					for (; dim <= vala_array_type_get_rank (array_type); dim++) {
						if (first) {
							ValaCCodeExpression* _tmp24;
							_tmp24 = NULL;
							csizeexpr = (_tmp24 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), expr, dim), (csizeexpr == NULL) ? NULL : (csizeexpr = (vala_ccode_node_unref (csizeexpr), NULL)), _tmp24);
							first = FALSE;
						} else {
							ValaCCodeExpression* _tmp26;
							ValaCCodeExpression* _tmp25;
							_tmp26 = NULL;
							_tmp25 = NULL;
							csizeexpr = (_tmp26 = (ValaCCodeExpression*) vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, csizeexpr, _tmp25 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), expr, dim)), (csizeexpr == NULL) ? NULL : (csizeexpr = (vala_ccode_node_unref (csizeexpr), NULL)), _tmp26);
							(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
						}
					}
				}
				_tmp27 = NULL;
				vala_ccode_function_call_set_call (ccall, (ValaCCodeExpression*) (_tmp27 = vala_ccode_identifier_new ("_vala_array_free")));
				(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
				vala_ccode_function_call_add_argument (ccall, csizeexpr);
				_tmp29 = NULL;
				_tmp28 = NULL;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp29 = vala_ccode_cast_expression_new (_tmp28 = vala_ccode_base_module_get_destroy_func_expression (self, vala_array_type_get_element_type (array_type)), "GDestroyNotify")));
				(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
				(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
				(csizeexpr == NULL) ? NULL : (csizeexpr = (vala_ccode_node_unref (csizeexpr), NULL));
			}
			(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		}
	}
	vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) ccall);
	_tmp30 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp30 = vala_ccode_constant_new ("NULL")));
	(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
	cassign = vala_ccode_assignment_new (cvar, (ValaCCodeExpression*) ccomma, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	_tmp31 = FALSE;
	_tmp32 = FALSE;
	if (vala_data_type_get_data_type (type) != NULL) {
		_tmp32 = !vala_typesymbol_is_reference_counting (vala_data_type_get_data_type (type));
	} else {
		_tmp32 = FALSE;
	}
	if (_tmp32) {
		char* _tmp33;
		_tmp33 = NULL;
		_tmp31 = _vala_strcmp0 (_tmp33 = vala_typesymbol_get_free_function (vala_data_type_get_data_type (type)), "g_free") == 0;
		_tmp33 = (g_free (_tmp33), NULL);
	} else {
		_tmp31 = FALSE;
	}
	/* g_free (NULL) is allowed*/
	uses_gfree = (_tmp31);
	_tmp34 = FALSE;
	if (uses_gfree) {
		_tmp34 = TRUE;
	} else {
		_tmp34 = VALA_IS_ARRAY_TYPE (type);
	}
	uses_gfree = _tmp34;
	if (uses_gfree) {
		ValaCCodeExpression* _tmp35;
		_tmp35 = NULL;
		return (_tmp35 = (ValaCCodeExpression*) cassign, (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), (cisnull == NULL) ? NULL : (cisnull = (vala_ccode_node_unref (cisnull), NULL)), (ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL)), _tmp35);
	}
	_tmp36 = NULL;
	_tmp37 = NULL;
	_tmp38 = NULL;
	return (_tmp38 = (_tmp37 = (ValaCCodeExpression*) vala_ccode_conditional_expression_new ((ValaCCodeExpression*) cisnull, (ValaCCodeExpression*) (_tmp36 = vala_ccode_constant_new ("NULL")), (ValaCCodeExpression*) cassign), (_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL)), _tmp37), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), (cisnull == NULL) ? NULL : (cisnull = (vala_ccode_node_unref (cisnull), NULL)), (ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL)), (cassign == NULL) ? NULL : (cassign = (vala_ccode_node_unref (cassign), NULL)), _tmp38);
}


static void vala_ccode_base_module_real_visit_end_full_expression (ValaCCodeModule* base, ValaExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaDataType* _tmp0;
	ValaDataType* expr_type;
	ValaLocalVariable* full_expr_var;
	ValaCCodeCommaExpression* expr_list;
	ValaCCodeAssignment* _tmp4;
	ValaCCodeIdentifier* _tmp3;
	ValaCCodeIdentifier* _tmp7;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	/* expr is a full expression, i.e. an initializer, the
	 * expression in an expression statement, the controlling
	 * expression in if, while, for, or foreach statements
	 *
	 * we unref temporary variables at the end of a full
	 * expression
	 
	 can't automatically deep copy lists yet, so do it
	 * manually for now
	 * replace with
	 * expr.temp_vars = temp_vars;
	 * when deep list copying works
	 */
	gee_collection_clear ((GeeCollection*) expr->temp_vars);
	{
		GeeIterator* local_it;
		local_it = gee_iterable_iterator ((GeeIterable*) self->temp_vars);
		while (gee_iterator_next (local_it)) {
			ValaLocalVariable* local;
			local = (ValaLocalVariable*) gee_iterator_get (local_it);
			gee_collection_add ((GeeCollection*) expr->temp_vars, local);
			(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
		}
		(local_it == NULL) ? NULL : (local_it = (gee_collection_object_unref (local_it), NULL));
	}
	gee_collection_clear ((GeeCollection*) self->temp_vars);
	if (gee_collection_get_size ((GeeCollection*) (GEE_LIST (self->temp_ref_vars))) == 0) {
		/* nothing to do without temporary variables */
		return;
	}
	_tmp0 = NULL;
	expr_type = (_tmp0 = vala_expression_get_value_type (expr), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	if (vala_expression_get_target_type (expr) != NULL) {
		ValaDataType* _tmp2;
		ValaDataType* _tmp1;
		_tmp2 = NULL;
		_tmp1 = NULL;
		expr_type = (_tmp2 = (_tmp1 = vala_expression_get_target_type (expr), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (expr_type == NULL) ? NULL : (expr_type = (vala_code_node_unref (expr_type), NULL)), _tmp2);
	}
	full_expr_var = vala_ccode_base_module_get_temp_variable (self, expr_type, TRUE, (ValaCodeNode*) expr);
	gee_collection_add ((GeeCollection*) expr->temp_vars, full_expr_var);
	expr_list = vala_ccode_comma_expression_new ();
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_comma_expression_append_expression (expr_list, (ValaCCodeExpression*) (_tmp4 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp3 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) full_expr_var))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) expr)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	{
		GeeIterator* local_it;
		local_it = gee_iterable_iterator ((GeeIterable*) self->temp_ref_vars);
		while (gee_iterator_next (local_it)) {
			ValaLocalVariable* local;
			ValaMemberAccess* ma;
			ValaCCodeExpression* _tmp6;
			ValaCCodeIdentifier* _tmp5;
			local = (ValaLocalVariable*) gee_iterator_get (local_it);
			ma = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) local), NULL);
			vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) local);
			_tmp6 = NULL;
			_tmp5 = NULL;
			vala_ccode_comma_expression_append_expression (expr_list, _tmp6 = vala_ccode_base_module_get_unref_expression (self, (ValaCCodeExpression*) (_tmp5 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) local))), vala_local_variable_get_variable_type (local), (ValaExpression*) ma));
			(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
			(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
			(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
			(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
		}
		(local_it == NULL) ? NULL : (local_it = (gee_collection_object_unref (local_it), NULL));
	}
	_tmp7 = NULL;
	vala_ccode_comma_expression_append_expression (expr_list, (ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) full_expr_var))));
	(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) expr_list);
	gee_collection_clear ((GeeCollection*) self->temp_ref_vars);
	(expr_type == NULL) ? NULL : (expr_type = (vala_code_node_unref (expr_type), NULL));
	(full_expr_var == NULL) ? NULL : (full_expr_var = (vala_code_node_unref (full_expr_var), NULL));
	(expr_list == NULL) ? NULL : (expr_list = (vala_ccode_node_unref (expr_list), NULL));
}


void vala_ccode_base_module_append_temp_decl (ValaCCodeBaseModule* self, ValaCCodeFragment* cfrag, GeeList* temp_vars) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (cfrag != NULL);
	g_return_if_fail (temp_vars != NULL);
	{
		GeeIterator* local_it;
		local_it = gee_iterable_iterator ((GeeIterable*) temp_vars);
		while (gee_iterator_next (local_it)) {
			ValaLocalVariable* local;
			char* _tmp0;
			ValaCCodeDeclaration* _tmp1;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* vardecl;
			ValaStruct* _tmp3;
			ValaTypeSymbol* _tmp2;
			ValaStruct* st;
			local = (ValaLocalVariable*) gee_iterator_get (local_it);
			_tmp0 = NULL;
			_tmp1 = NULL;
			cdecl_ = (_tmp1 = vala_ccode_declaration_new (_tmp0 = vala_data_type_get_cname (vala_local_variable_get_variable_type (local))), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
			vardecl = vala_ccode_variable_declarator_new (vala_symbol_get_name ((ValaSymbol*) local));
			/* sets #line*/
			vala_code_node_set_ccodenode ((ValaCodeNode*) local, (ValaCCodeNode*) vardecl);
			vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) vardecl);
			_tmp3 = NULL;
			_tmp2 = NULL;
			st = (_tmp3 = (_tmp2 = vala_data_type_get_data_type (vala_local_variable_get_variable_type (local)), VALA_IS_STRUCT (_tmp2) ? ((ValaStruct*) _tmp2) : NULL), (_tmp3 == NULL) ? NULL : vala_code_node_ref (_tmp3));
			if (vala_data_type_is_reference_type_or_type_parameter (vala_local_variable_get_variable_type (local))) {
				ValaCCodeConstant* _tmp4;
				_tmp4 = NULL;
				vala_ccode_variable_declarator_set_initializer (vardecl, (ValaCCodeExpression*) (_tmp4 = vala_ccode_constant_new ("NULL")));
				(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
			} else {
				gboolean _tmp5;
				_tmp5 = FALSE;
				if (st != NULL) {
					_tmp5 = !vala_struct_is_simple_type (st);
				} else {
					_tmp5 = FALSE;
				}
				if (_tmp5) {
					ValaCCodeInitializerList* clist;
					ValaCCodeConstant* _tmp6;
					/* 0-initialize struct with struct initializer { 0 }
					 necessary as they will be passed by reference*/
					clist = vala_ccode_initializer_list_new ();
					_tmp6 = NULL;
					vala_ccode_initializer_list_append (clist, (ValaCCodeExpression*) (_tmp6 = vala_ccode_constant_new ("0")));
					(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
					vala_ccode_variable_declarator_set_initializer (vardecl, (ValaCCodeExpression*) clist);
					(clist == NULL) ? NULL : (clist = (vala_ccode_node_unref (clist), NULL));
				}
			}
			vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) cdecl_);
			(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
			(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
			(vardecl == NULL) ? NULL : (vardecl = (vala_ccode_node_unref (vardecl), NULL));
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
		}
		(local_it == NULL) ? NULL : (local_it = (gee_collection_object_unref (local_it), NULL));
	}
}


static void vala_ccode_base_module_real_visit_expression_statement (ValaCCodeModule* base, ValaExpressionStatement* stmt) {
	ValaCCodeBaseModule * self;
	ValaCCodeExpressionStatement* _tmp0;
	ValaMethodCall* _tmp2;
	ValaExpression* _tmp1;
	ValaMethodCall* invoc;
	gboolean _tmp24;
	ValaCCodeFragment* cfrag;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (vala_code_node_get_error ((ValaCodeNode*) vala_expression_statement_get_expression (stmt))) {
		vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
		return;
	}
	_tmp0 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) (_tmp0 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_expression_statement_get_expression (stmt))))));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	_tmp2 = NULL;
	_tmp1 = NULL;
	invoc = (_tmp2 = (_tmp1 = vala_expression_statement_get_expression (stmt), VALA_IS_METHOD_CALL (_tmp1) ? ((ValaMethodCall*) _tmp1) : NULL), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
	if (invoc != NULL) {
		ValaMethod* _tmp4;
		ValaSymbol* _tmp3;
		ValaMethod* m;
		ValaMemberAccess* _tmp6;
		ValaExpression* _tmp5;
		ValaMemberAccess* ma;
		gboolean _tmp7;
		gboolean _tmp8;
		gboolean _tmp9;
		gboolean _tmp10;
		_tmp4 = NULL;
		_tmp3 = NULL;
		m = (_tmp4 = (_tmp3 = vala_expression_get_symbol_reference (vala_method_call_get_call (invoc)), VALA_IS_METHOD (_tmp3) ? ((ValaMethod*) _tmp3) : NULL), (_tmp4 == NULL) ? NULL : vala_code_node_ref (_tmp4));
		_tmp6 = NULL;
		_tmp5 = NULL;
		ma = (_tmp6 = (_tmp5 = vala_method_call_get_call (invoc), VALA_IS_MEMBER_ACCESS (_tmp5) ? ((ValaMemberAccess*) _tmp5) : NULL), (_tmp6 == NULL) ? NULL : vala_code_node_ref (_tmp6));
		_tmp7 = FALSE;
		_tmp8 = FALSE;
		_tmp9 = FALSE;
		_tmp10 = FALSE;
		if (m != NULL) {
			_tmp10 = vala_method_get_coroutine (m);
		} else {
			_tmp10 = FALSE;
		}
		if (_tmp10) {
			_tmp9 = self->current_method != NULL;
		} else {
			_tmp9 = FALSE;
		}
		if (_tmp9) {
			_tmp8 = vala_method_get_coroutine (self->current_method);
		} else {
			_tmp8 = FALSE;
		}
		if (_tmp8) {
			gboolean _tmp11;
			gboolean _tmp12;
			_tmp11 = FALSE;
			_tmp12 = FALSE;
			if (ma == NULL) {
				_tmp12 = TRUE;
			} else {
				_tmp12 = _vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") != 0;
			}
			if (_tmp12) {
				_tmp11 = TRUE;
			} else {
				_tmp11 = vala_expression_get_symbol_reference (vala_member_access_get_inner (ma)) != vala_expression_get_symbol_reference ((ValaExpression*) ma);
			}
			_tmp7 = (_tmp11);
		} else {
			_tmp7 = FALSE;
		}
		if (_tmp7) {
			ValaCCodeFragment* cfrag;
			gint state;
			ValaCCodeExpressionStatement* _tmp18;
			ValaCCodeAssignment* _tmp17;
			ValaCCodeConstant* _tmp16;
			char* _tmp15;
			ValaCCodeMemberAccess* _tmp14;
			ValaCCodeIdentifier* _tmp13;
			ValaCCodeReturnStatement* _tmp20;
			ValaCCodeConstant* _tmp19;
			ValaCCodeCaseStatement* _tmp23;
			ValaCCodeConstant* _tmp22;
			char* _tmp21;
			cfrag = vala_ccode_fragment_new ();
			state = self->next_coroutine_state++;
			vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode ((ValaCodeNode*) stmt));
			_tmp18 = NULL;
			_tmp17 = NULL;
			_tmp16 = NULL;
			_tmp15 = NULL;
			_tmp14 = NULL;
			_tmp13 = NULL;
			vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp18 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp17 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp14 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp13 = vala_ccode_identifier_new ("data")), "state")), (ValaCCodeExpression*) (_tmp16 = vala_ccode_constant_new (_tmp15 = g_strdup_printf ("%i", state))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
			(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
			(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
			_tmp15 = (g_free (_tmp15), NULL);
			(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
			(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
			_tmp20 = NULL;
			_tmp19 = NULL;
			vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp20 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp19 = vala_ccode_constant_new ("FALSE")))));
			(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
			(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
			_tmp23 = NULL;
			_tmp22 = NULL;
			_tmp21 = NULL;
			vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp23 = vala_ccode_case_statement_new ((ValaCCodeExpression*) (_tmp22 = vala_ccode_constant_new (_tmp21 = g_strdup_printf ("%i", state))))));
			(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
			(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
			_tmp21 = (g_free (_tmp21), NULL);
			vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cfrag);
			(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
		}
		(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
		(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
	}
	_tmp24 = FALSE;
	if (vala_code_node_get_tree_can_fail ((ValaCodeNode*) stmt)) {
		_tmp24 = vala_code_node_get_tree_can_fail ((ValaCodeNode*) vala_expression_statement_get_expression (stmt));
	} else {
		_tmp24 = FALSE;
	}
	if (_tmp24) {
		ValaCCodeFragment* cfrag;
		/* simple case, no node breakdown necessary*/
		cfrag = vala_ccode_fragment_new ();
		vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode ((ValaCodeNode*) stmt));
		vala_ccode_module_add_simple_check (vala_ccode_module_get_head ((ValaCCodeModule*) self), (ValaCodeNode*) vala_expression_statement_get_expression (stmt), cfrag);
		vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cfrag);
		(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
	}
	/* free temporary objects */
	if (gee_collection_get_size ((GeeCollection*) (GEE_LIST (self->temp_vars))) == 0) {
		/* nothing to do without temporary variables */
		(invoc == NULL) ? NULL : (invoc = (vala_code_node_unref (invoc), NULL));
		return;
	}
	cfrag = vala_ccode_fragment_new ();
	vala_ccode_base_module_append_temp_decl (self, cfrag, (GeeList*) self->temp_vars);
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode ((ValaCodeNode*) stmt));
	{
		GeeIterator* local_it;
		local_it = gee_iterable_iterator ((GeeIterable*) self->temp_ref_vars);
		while (gee_iterator_next (local_it)) {
			ValaLocalVariable* local;
			ValaMemberAccess* ma;
			ValaCCodeExpressionStatement* _tmp27;
			ValaCCodeExpression* _tmp26;
			ValaCCodeIdentifier* _tmp25;
			local = (ValaLocalVariable*) gee_iterator_get (local_it);
			ma = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) local), NULL);
			vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) local);
			_tmp27 = NULL;
			_tmp26 = NULL;
			_tmp25 = NULL;
			vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp27 = vala_ccode_expression_statement_new (_tmp26 = vala_ccode_base_module_get_unref_expression (self, (ValaCCodeExpression*) (_tmp25 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) local))), vala_local_variable_get_variable_type (local), (ValaExpression*) ma))));
			(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
			(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
			(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
			(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
			(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
		}
		(local_it == NULL) ? NULL : (local_it = (gee_collection_object_unref (local_it), NULL));
	}
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cfrag);
	gee_collection_clear ((GeeCollection*) self->temp_vars);
	gee_collection_clear ((GeeCollection*) self->temp_ref_vars);
	(invoc == NULL) ? NULL : (invoc = (vala_code_node_unref (invoc), NULL));
	(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
}


void vala_ccode_base_module_create_temp_decl (ValaCCodeBaseModule* self, ValaStatement* stmt, GeeList* temp_vars) {
	ValaCCodeFragment* cfrag;
	g_return_if_fail (self != NULL);
	g_return_if_fail (stmt != NULL);
	g_return_if_fail (temp_vars != NULL);
	/* declare temporary variables */
	if (gee_collection_get_size ((GeeCollection*) temp_vars) == 0) {
		/* nothing to do without temporary variables */
		return;
	}
	cfrag = vala_ccode_fragment_new ();
	vala_ccode_base_module_append_temp_decl (self, cfrag, temp_vars);
	/* FIXME cast to CodeNode shouldn't be necessary as Statement requires CodeNode*/
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode ((VALA_CODE_NODE (stmt))));
	vala_code_node_set_ccodenode ((VALA_CODE_NODE (stmt)), (ValaCCodeNode*) cfrag);
	(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
}


void vala_ccode_base_module_append_local_free (ValaCCodeBaseModule* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, gboolean stop_at_loop) {
	ValaBlock* _tmp0;
	ValaBlock* b;
	GeeList* local_vars;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	g_return_if_fail (cfrag != NULL);
	_tmp0 = NULL;
	b = (_tmp0 = VALA_BLOCK (sym), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	local_vars = vala_block_get_local_variables (b);
	{
		GeeIterator* local_it;
		local_it = gee_iterable_iterator ((GeeIterable*) local_vars);
		while (gee_iterator_next (local_it)) {
			ValaLocalVariable* local;
			gboolean _tmp1;
			gboolean _tmp2;
			local = (ValaLocalVariable*) gee_iterator_get (local_it);
			_tmp1 = FALSE;
			_tmp2 = FALSE;
			if (vala_symbol_get_active ((ValaSymbol*) local)) {
				_tmp2 = !vala_local_variable_get_floating (local);
			} else {
				_tmp2 = FALSE;
			}
			if (_tmp2) {
				_tmp1 = vala_ccode_base_module_requires_destroy (self, vala_local_variable_get_variable_type (local));
			} else {
				_tmp1 = FALSE;
			}
			if (_tmp1) {
				ValaMemberAccess* ma;
				ValaCCodeExpressionStatement* _tmp6;
				ValaCCodeExpression* _tmp5;
				ValaCCodeIdentifier* _tmp4;
				char* _tmp3;
				ma = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) local), NULL);
				vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) local);
				_tmp6 = NULL;
				_tmp5 = NULL;
				_tmp4 = NULL;
				_tmp3 = NULL;
				vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp6 = vala_ccode_expression_statement_new (_tmp5 = vala_ccode_base_module_get_unref_expression (self, (ValaCCodeExpression*) (_tmp4 = vala_ccode_identifier_new (_tmp3 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) local)))), vala_local_variable_get_variable_type (local), (ValaExpression*) ma))));
				(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
				(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
				(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
				_tmp3 = (g_free (_tmp3), NULL);
				(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
			}
			(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
		}
		(local_it == NULL) ? NULL : (local_it = (gee_collection_object_unref (local_it), NULL));
	}
	if (stop_at_loop) {
		gboolean _tmp7;
		gboolean _tmp8;
		gboolean _tmp9;
		gboolean _tmp10;
		_tmp7 = FALSE;
		_tmp8 = FALSE;
		_tmp9 = FALSE;
		_tmp10 = FALSE;
		if (VALA_IS_DO_STATEMENT (vala_code_node_get_parent_node ((ValaCodeNode*) b))) {
			_tmp10 = TRUE;
		} else {
			_tmp10 = VALA_IS_WHILE_STATEMENT (vala_code_node_get_parent_node ((ValaCodeNode*) b));
		}
		if (_tmp10) {
			_tmp9 = TRUE;
		} else {
			_tmp9 = VALA_IS_FOR_STATEMENT (vala_code_node_get_parent_node ((ValaCodeNode*) b));
		}
		if (_tmp9) {
			_tmp8 = TRUE;
		} else {
			_tmp8 = VALA_IS_FOREACH_STATEMENT (vala_code_node_get_parent_node ((ValaCodeNode*) b));
		}
		if (_tmp8) {
			_tmp7 = TRUE;
		} else {
			_tmp7 = VALA_IS_SWITCH_STATEMENT (vala_code_node_get_parent_node ((ValaCodeNode*) b));
		}
		if (_tmp7) {
			(b == NULL) ? NULL : (b = (vala_code_node_unref (b), NULL));
			(local_vars == NULL) ? NULL : (local_vars = (gee_collection_object_unref (local_vars), NULL));
			return;
		}
	}
	if (VALA_IS_BLOCK (vala_symbol_get_parent_symbol (sym))) {
		vala_ccode_base_module_append_local_free (self, vala_symbol_get_parent_symbol (sym), cfrag, stop_at_loop);
	} else {
		if (VALA_IS_METHOD (vala_symbol_get_parent_symbol (sym))) {
			vala_ccode_base_module_append_param_free (self, VALA_METHOD (vala_symbol_get_parent_symbol (sym)), cfrag);
		}
	}
	(b == NULL) ? NULL : (b = (vala_code_node_unref (b), NULL));
	(local_vars == NULL) ? NULL : (local_vars = (gee_collection_object_unref (local_vars), NULL));
}


static void vala_ccode_base_module_append_param_free (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeFragment* cfrag) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	g_return_if_fail (cfrag != NULL);
	{
		GeeList* _tmp0;
		GeeIterator* _tmp1;
		GeeIterator* param_it;
		_tmp0 = NULL;
		_tmp1 = NULL;
		param_it = (_tmp1 = gee_iterable_iterator ((GeeIterable*) (_tmp0 = vala_method_get_parameters (m))), (_tmp0 == NULL) ? NULL : (_tmp0 = (gee_collection_object_unref (_tmp0), NULL)), _tmp1);
		while (gee_iterator_next (param_it)) {
			ValaFormalParameter* param;
			gboolean _tmp2;
			param = (ValaFormalParameter*) gee_iterator_get (param_it);
			_tmp2 = FALSE;
			if (vala_ccode_base_module_requires_destroy (self, vala_formal_parameter_get_parameter_type (param))) {
				_tmp2 = vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN;
			} else {
				_tmp2 = FALSE;
			}
			if (_tmp2) {
				ValaMemberAccess* ma;
				ValaCCodeExpressionStatement* _tmp6;
				ValaCCodeExpression* _tmp5;
				ValaCCodeIdentifier* _tmp4;
				char* _tmp3;
				ma = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) param), NULL);
				vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) param);
				_tmp6 = NULL;
				_tmp5 = NULL;
				_tmp4 = NULL;
				_tmp3 = NULL;
				vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp6 = vala_ccode_expression_statement_new (_tmp5 = vala_ccode_base_module_get_unref_expression (self, (ValaCCodeExpression*) (_tmp4 = vala_ccode_identifier_new (_tmp3 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) param)))), vala_formal_parameter_get_parameter_type (param), (ValaExpression*) ma))));
				(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
				(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
				(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
				_tmp3 = (g_free (_tmp3), NULL);
				(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
			}
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(param_it == NULL) ? NULL : (param_it = (gee_collection_object_unref (param_it), NULL));
	}
}


void vala_ccode_base_module_create_local_free (ValaCCodeBaseModule* self, ValaCodeNode* stmt, gboolean stop_at_loop) {
	ValaCCodeFragment* cfrag;
	g_return_if_fail (self != NULL);
	g_return_if_fail (stmt != NULL);
	cfrag = vala_ccode_fragment_new ();
	vala_ccode_base_module_append_local_free (self, self->current_symbol, cfrag, stop_at_loop);
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (stmt));
	vala_code_node_set_ccodenode (stmt, (ValaCCodeNode*) cfrag);
	(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
}


static gboolean vala_ccode_base_module_append_local_free_expr (ValaCCodeBaseModule* self, ValaSymbol* sym, ValaCCodeCommaExpression* ccomma, gboolean stop_at_loop) {
	gboolean found;
	ValaBlock* _tmp0;
	ValaBlock* b;
	GeeList* local_vars;
	gboolean _tmp8;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sym != NULL, FALSE);
	g_return_val_if_fail (ccomma != NULL, FALSE);
	found = FALSE;
	_tmp0 = NULL;
	b = (_tmp0 = VALA_BLOCK (sym), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	local_vars = vala_block_get_local_variables (b);
	{
		GeeIterator* local_it;
		local_it = gee_iterable_iterator ((GeeIterable*) local_vars);
		while (gee_iterator_next (local_it)) {
			ValaLocalVariable* local;
			gboolean _tmp1;
			gboolean _tmp2;
			local = (ValaLocalVariable*) gee_iterator_get (local_it);
			_tmp1 = FALSE;
			_tmp2 = FALSE;
			if (vala_symbol_get_active ((ValaSymbol*) local)) {
				_tmp2 = !vala_local_variable_get_floating (local);
			} else {
				_tmp2 = FALSE;
			}
			if (_tmp2) {
				_tmp1 = vala_ccode_base_module_requires_destroy (self, vala_local_variable_get_variable_type (local));
			} else {
				_tmp1 = FALSE;
			}
			if (_tmp1) {
				ValaMemberAccess* ma;
				ValaCCodeExpression* _tmp5;
				ValaCCodeIdentifier* _tmp4;
				char* _tmp3;
				found = TRUE;
				ma = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) local), NULL);
				vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) local);
				_tmp5 = NULL;
				_tmp4 = NULL;
				_tmp3 = NULL;
				vala_ccode_comma_expression_append_expression (ccomma, _tmp5 = vala_ccode_base_module_get_unref_expression (self, (ValaCCodeExpression*) (_tmp4 = vala_ccode_identifier_new (_tmp3 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) local)))), vala_local_variable_get_variable_type (local), (ValaExpression*) ma));
				(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
				(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
				_tmp3 = (g_free (_tmp3), NULL);
				(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
			}
			(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
		}
		(local_it == NULL) ? NULL : (local_it = (gee_collection_object_unref (local_it), NULL));
	}
	if (VALA_IS_BLOCK (vala_symbol_get_parent_symbol (sym))) {
		gboolean _tmp6;
		_tmp6 = FALSE;
		if (vala_ccode_base_module_append_local_free_expr (self, vala_symbol_get_parent_symbol (sym), ccomma, stop_at_loop)) {
			_tmp6 = TRUE;
		} else {
			_tmp6 = found;
		}
		found = _tmp6;
	} else {
		if (VALA_IS_METHOD (vala_symbol_get_parent_symbol (sym))) {
			gboolean _tmp7;
			_tmp7 = FALSE;
			if (vala_ccode_base_module_append_param_free_expr (self, VALA_METHOD (vala_symbol_get_parent_symbol (sym)), ccomma)) {
				_tmp7 = TRUE;
			} else {
				_tmp7 = found;
			}
			found = _tmp7;
		}
	}
	return (_tmp8 = found, (b == NULL) ? NULL : (b = (vala_code_node_unref (b), NULL)), (local_vars == NULL) ? NULL : (local_vars = (gee_collection_object_unref (local_vars), NULL)), _tmp8);
}


static gboolean vala_ccode_base_module_append_param_free_expr (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeCommaExpression* ccomma) {
	gboolean found;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (m != NULL, FALSE);
	g_return_val_if_fail (ccomma != NULL, FALSE);
	found = FALSE;
	{
		GeeList* _tmp0;
		GeeIterator* _tmp1;
		GeeIterator* param_it;
		_tmp0 = NULL;
		_tmp1 = NULL;
		param_it = (_tmp1 = gee_iterable_iterator ((GeeIterable*) (_tmp0 = vala_method_get_parameters (m))), (_tmp0 == NULL) ? NULL : (_tmp0 = (gee_collection_object_unref (_tmp0), NULL)), _tmp1);
		while (gee_iterator_next (param_it)) {
			ValaFormalParameter* param;
			gboolean _tmp2;
			param = (ValaFormalParameter*) gee_iterator_get (param_it);
			_tmp2 = FALSE;
			if (vala_ccode_base_module_requires_destroy (self, vala_formal_parameter_get_parameter_type (param))) {
				_tmp2 = vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN;
			} else {
				_tmp2 = FALSE;
			}
			if (_tmp2) {
				ValaMemberAccess* ma;
				ValaCCodeExpression* _tmp5;
				ValaCCodeIdentifier* _tmp4;
				char* _tmp3;
				found = TRUE;
				ma = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) param), NULL);
				vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) param);
				_tmp5 = NULL;
				_tmp4 = NULL;
				_tmp3 = NULL;
				vala_ccode_comma_expression_append_expression (ccomma, _tmp5 = vala_ccode_base_module_get_unref_expression (self, (ValaCCodeExpression*) (_tmp4 = vala_ccode_identifier_new (_tmp3 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) param)))), vala_formal_parameter_get_parameter_type (param), (ValaExpression*) ma));
				(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
				(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
				_tmp3 = (g_free (_tmp3), NULL);
				(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
			}
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(param_it == NULL) ? NULL : (param_it = (gee_collection_object_unref (param_it), NULL));
	}
	return found;
}


static void vala_ccode_base_module_create_local_free_expr (ValaCCodeBaseModule* self, ValaExpression* expr) {
	ValaDataType* _tmp0;
	ValaDataType* expr_type;
	ValaLocalVariable* return_expr_decl;
	ValaCCodeCommaExpression* ccomma;
	ValaCCodeAssignment* _tmp4;
	ValaCCodeIdentifier* _tmp3;
	ValaCCodeIdentifier* _tmp5;
	g_return_if_fail (self != NULL);
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	expr_type = (_tmp0 = vala_expression_get_value_type (expr), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	if (vala_expression_get_target_type (expr) != NULL) {
		ValaDataType* _tmp2;
		ValaDataType* _tmp1;
		_tmp2 = NULL;
		_tmp1 = NULL;
		expr_type = (_tmp2 = (_tmp1 = vala_expression_get_target_type (expr), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (expr_type == NULL) ? NULL : (expr_type = (vala_code_node_unref (expr_type), NULL)), _tmp2);
	}
	return_expr_decl = vala_ccode_base_module_get_temp_variable (self, expr_type, TRUE, (ValaCodeNode*) expr);
	ccomma = vala_ccode_comma_expression_new ();
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp4 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp3 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) return_expr_decl))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) expr)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	if (!vala_ccode_base_module_append_local_free_expr (self, self->current_symbol, ccomma, FALSE)) {
		/* no local variables need to be freed */
		(expr_type == NULL) ? NULL : (expr_type = (vala_code_node_unref (expr_type), NULL));
		(return_expr_decl == NULL) ? NULL : (return_expr_decl = (vala_code_node_unref (return_expr_decl), NULL));
		(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
		return;
	}
	_tmp5 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp5 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) return_expr_decl))));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccomma);
	gee_collection_add ((GeeCollection*) expr->temp_vars, return_expr_decl);
	(expr_type == NULL) ? NULL : (expr_type = (vala_code_node_unref (expr_type), NULL));
	(return_expr_decl == NULL) ? NULL : (return_expr_decl = (vala_code_node_unref (return_expr_decl), NULL));
	(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
}


static void vala_ccode_base_module_real_visit_return_statement (ValaCCodeModule* base, ValaReturnStatement* stmt) {
	ValaCCodeBaseModule * self;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (stmt != NULL);
	/* avoid unnecessary ref/unref pair*/
	if (vala_return_statement_get_return_expression (stmt) != NULL) {
		ValaLocalVariable* _tmp1;
		ValaSymbol* _tmp0;
		ValaLocalVariable* local;
		gboolean _tmp2;
		gboolean _tmp3;
		_tmp1 = NULL;
		_tmp0 = NULL;
		local = (_tmp1 = (_tmp0 = vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt)), VALA_IS_LOCAL_VARIABLE (_tmp0) ? ((ValaLocalVariable*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
		_tmp2 = FALSE;
		_tmp3 = FALSE;
		if (vala_data_type_get_value_owned (self->current_return_type)) {
			_tmp3 = local != NULL;
		} else {
			_tmp3 = FALSE;
		}
		if (_tmp3) {
			_tmp2 = vala_data_type_get_value_owned (vala_local_variable_get_variable_type (local));
		} else {
			_tmp2 = FALSE;
		}
		if (_tmp2) {
			/* return expression is local variable taking ownership and
			 * current method is transferring ownership 
			 don't ref expression*/
			vala_data_type_set_value_owned (vala_expression_get_value_type (vala_return_statement_get_return_expression (stmt)), TRUE);
		}
		(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
	}
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (vala_return_statement_get_return_expression (stmt) == NULL) {
		ValaCCodeReturnStatement* _tmp4;
		_tmp4 = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) (_tmp4 = vala_ccode_return_statement_new (NULL)));
		(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
		vala_ccode_base_module_create_local_free (self, (ValaCodeNode*) stmt, FALSE);
	} else {
		ValaSymbol* return_expression_symbol;
		ValaLocalVariable* _tmp6;
		ValaSymbol* _tmp5;
		ValaLocalVariable* local;
		gboolean _tmp7;
		gboolean _tmp8;
		gboolean _tmp11;
		gboolean _tmp12;
		gboolean _tmp21;
		gboolean _tmp22;
		return_expression_symbol = NULL;
		/* avoid unnecessary ref/unref pair*/
		_tmp6 = NULL;
		_tmp5 = NULL;
		local = (_tmp6 = (_tmp5 = vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt)), VALA_IS_LOCAL_VARIABLE (_tmp5) ? ((ValaLocalVariable*) _tmp5) : NULL), (_tmp6 == NULL) ? NULL : vala_code_node_ref (_tmp6));
		_tmp7 = FALSE;
		_tmp8 = FALSE;
		if (vala_data_type_get_value_owned (self->current_return_type)) {
			_tmp8 = local != NULL;
		} else {
			_tmp8 = FALSE;
		}
		if (_tmp8) {
			_tmp7 = vala_data_type_get_value_owned (vala_local_variable_get_variable_type (local));
		} else {
			_tmp7 = FALSE;
		}
		if (_tmp7) {
			ValaSymbol* _tmp10;
			ValaSymbol* _tmp9;
			/* return expression is local variable taking ownership and
			 * current method is transferring ownership 
			 don't unref variable*/
			_tmp10 = NULL;
			_tmp9 = NULL;
			return_expression_symbol = (_tmp10 = (_tmp9 = (ValaSymbol*) local, (_tmp9 == NULL) ? NULL : vala_code_node_ref (_tmp9)), (return_expression_symbol == NULL) ? NULL : (return_expression_symbol = (vala_code_node_unref (return_expression_symbol), NULL)), _tmp10);
			vala_symbol_set_active (return_expression_symbol, FALSE);
		}
		_tmp11 = FALSE;
		_tmp12 = FALSE;
		if (self->current_method != NULL) {
			_tmp12 = !vala_method_get_no_array_length (self->current_method);
		} else {
			_tmp12 = FALSE;
		}
		if (_tmp12) {
			_tmp11 = VALA_IS_ARRAY_TYPE (self->current_return_type);
		} else {
			_tmp11 = FALSE;
		}
		/* return array length if appropriate*/
		if (_tmp11) {
			ValaLocalVariable* return_expr_decl;
			ValaCCodeCommaExpression* ccomma;
			ValaCCodeAssignment* _tmp14;
			ValaCCodeIdentifier* _tmp13;
			ValaArrayType* _tmp15;
			ValaArrayType* array_type;
			ValaCCodeIdentifier* _tmp20;
			return_expr_decl = vala_ccode_base_module_get_temp_variable (self, vala_expression_get_value_type (vala_return_statement_get_return_expression (stmt)), TRUE, (ValaCodeNode*) stmt);
			ccomma = vala_ccode_comma_expression_new ();
			_tmp14 = NULL;
			_tmp13 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp14 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp13 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) return_expr_decl))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_return_statement_get_return_expression (stmt))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
			(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
			(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
			_tmp15 = NULL;
			array_type = (_tmp15 = VALA_ARRAY_TYPE (self->current_return_type), (_tmp15 == NULL) ? NULL : vala_code_node_ref (_tmp15));
			{
				gint dim;
				dim = 1;
				for (; dim <= vala_array_type_get_rank (array_type); dim++) {
					ValaCCodeIdentifier* _tmp17;
					char* _tmp16;
					ValaCCodeUnaryExpression* _tmp18;
					ValaCCodeUnaryExpression* len_l;
					ValaCCodeExpression* len_r;
					ValaCCodeAssignment* _tmp19;
					_tmp17 = NULL;
					_tmp16 = NULL;
					_tmp18 = NULL;
					len_l = (_tmp18 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp17 = vala_ccode_identifier_new (_tmp16 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), "result", dim)))), (_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)), _tmp16 = (g_free (_tmp16), NULL), _tmp18);
					len_r = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_return_statement_get_return_expression (stmt), dim);
					_tmp19 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp19 = vala_ccode_assignment_new ((ValaCCodeExpression*) len_l, len_r, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
					(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
					(len_l == NULL) ? NULL : (len_l = (vala_ccode_node_unref (len_l), NULL));
					(len_r == NULL) ? NULL : (len_r = (vala_ccode_node_unref (len_r), NULL));
				}
			}
			_tmp20 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp20 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) return_expr_decl))));
			(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
			vala_code_node_set_ccodenode ((ValaCodeNode*) vala_return_statement_get_return_expression (stmt), (ValaCCodeNode*) ccomma);
			gee_collection_add ((GeeCollection*) vala_return_statement_get_return_expression (stmt)->temp_vars, return_expr_decl);
			(return_expr_decl == NULL) ? NULL : (return_expr_decl = (vala_code_node_unref (return_expr_decl), NULL));
			(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
			(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		}
		vala_ccode_base_module_create_local_free_expr (self, vala_return_statement_get_return_expression (stmt));
		_tmp21 = FALSE;
		_tmp22 = FALSE;
		if (self->current_property_accessor != NULL) {
			_tmp22 = vala_property_accessor_get_readable (self->current_property_accessor);
		} else {
			_tmp22 = FALSE;
		}
		if (_tmp22) {
			_tmp21 = vala_data_type_is_real_struct_type (vala_property_get_property_type (vala_property_accessor_get_prop (self->current_property_accessor)));
		} else {
			_tmp21 = FALSE;
		}
		/* Property getters of non simple structs shall return the struct value as out parameter,
		 therefore replace any return statement with an assignment statement to the out formal
		 paramenter and insert an empty return statement afterwards.*/
		if (_tmp21) {
			ValaCCodeFragment* cfragment;
			ValaCCodeExpressionStatement* _tmp25;
			ValaCCodeAssignment* _tmp24;
			ValaCCodeIdentifier* _tmp23;
			ValaCCodeReturnStatement* _tmp26;
			cfragment = vala_ccode_fragment_new ();
			_tmp25 = NULL;
			_tmp24 = NULL;
			_tmp23 = NULL;
			vala_ccode_fragment_append (cfragment, (ValaCCodeNode*) (_tmp25 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp24 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp23 = vala_ccode_identifier_new ("*value")), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_return_statement_get_return_expression (stmt))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
			(_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL));
			(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
			_tmp26 = NULL;
			vala_ccode_fragment_append (cfragment, (ValaCCodeNode*) (_tmp26 = vala_ccode_return_statement_new (NULL)));
			(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
			vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cfragment);
			(cfragment == NULL) ? NULL : (cfragment = (vala_ccode_node_unref (cfragment), NULL));
		} else {
			ValaCCodeReturnStatement* _tmp27;
			_tmp27 = NULL;
			vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) (_tmp27 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_return_statement_get_return_expression (stmt))))));
			(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
		}
		vala_ccode_base_module_create_temp_decl (self, (ValaStatement*) stmt, (GeeList*) vala_return_statement_get_return_expression (stmt)->temp_vars);
		if (return_expression_symbol != NULL) {
			vala_symbol_set_active (return_expression_symbol, TRUE);
		}
		(return_expression_symbol == NULL) ? NULL : (return_expression_symbol = (vala_code_node_unref (return_expression_symbol), NULL));
		(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
	}
}


static char* vala_ccode_base_module_get_symbol_lock_name (ValaCCodeBaseModule* self, ValaSymbol* sym) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	return g_strdup_printf ("__lock_%s", vala_symbol_get_name (sym));
}


static void vala_ccode_base_module_real_visit_lock_statement (ValaCCodeModule* base, ValaLockStatement* stmt) {
	ValaCCodeBaseModule * self;
	ValaCCodeFragment* cn;
	ValaCCodeExpression* l;
	ValaCCodeFunctionCall* fc;
	ValaExpression* _tmp0;
	ValaExpression* inner_node;
	ValaCCodeExpression* _tmp7;
	char* _tmp6;
	ValaCCodeMemberAccess* _tmp5;
	ValaCCodeFunctionCall* _tmp11;
	ValaCCodeIdentifier* _tmp10;
	char* _tmp9;
	ValaMethod* _tmp8;
	ValaCCodeUnaryExpression* _tmp12;
	ValaCCodeExpressionStatement* _tmp13;
	ValaCCodeFunctionCall* _tmp17;
	ValaCCodeIdentifier* _tmp16;
	char* _tmp15;
	ValaMethod* _tmp14;
	ValaCCodeUnaryExpression* _tmp18;
	ValaCCodeExpressionStatement* _tmp19;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (stmt != NULL);
	cn = vala_ccode_fragment_new ();
	l = NULL;
	fc = NULL;
	_tmp0 = NULL;
	inner_node = (_tmp0 = vala_member_access_get_inner ((VALA_MEMBER_ACCESS (vala_lock_statement_get_resource (stmt)))), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	if (inner_node == NULL) {
		ValaCCodeExpression* _tmp1;
		_tmp1 = NULL;
		l = (_tmp1 = (ValaCCodeExpression*) vala_ccode_identifier_new ("self"), (l == NULL) ? NULL : (l = (vala_ccode_node_unref (l), NULL)), _tmp1);
	} else {
		if (vala_symbol_get_parent_symbol (vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt))) != VALA_SYMBOL (self->current_type_symbol)) {
			ValaCCodeExpression* _tmp2;
			_tmp2 = NULL;
			l = (_tmp2 = (ValaCCodeExpression*) vala_instance_cast_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) inner_node)), VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt))))), (l == NULL) ? NULL : (l = (vala_ccode_node_unref (l), NULL)), _tmp2);
		} else {
			ValaCCodeExpression* _tmp4;
			ValaCCodeExpression* _tmp3;
			_tmp4 = NULL;
			_tmp3 = NULL;
			l = (_tmp4 = (_tmp3 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) inner_node)), (_tmp3 == NULL) ? NULL : vala_ccode_node_ref (_tmp3)), (l == NULL) ? NULL : (l = (vala_ccode_node_unref (l), NULL)), _tmp4);
		}
	}
	_tmp7 = NULL;
	_tmp6 = NULL;
	_tmp5 = NULL;
	l = (_tmp7 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp5 = vala_ccode_member_access_new_pointer (l, "priv")), _tmp6 = vala_ccode_base_module_get_symbol_lock_name (self, vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt)))), (l == NULL) ? NULL : (l = (vala_ccode_node_unref (l), NULL)), _tmp7);
	_tmp6 = (g_free (_tmp6), NULL);
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp11 = NULL;
	_tmp10 = NULL;
	_tmp9 = NULL;
	_tmp8 = NULL;
	fc = (_tmp11 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp10 = vala_ccode_identifier_new (_tmp9 = vala_method_get_cname (_tmp8 = (VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) self->mutex_type), "lock"))))))), (fc == NULL) ? NULL : (fc = (vala_ccode_node_unref (fc), NULL)), _tmp11);
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	_tmp9 = (g_free (_tmp9), NULL);
	(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_code_node_unref (_tmp8), NULL));
	_tmp12 = NULL;
	vala_ccode_function_call_add_argument (fc, (ValaCCodeExpression*) (_tmp12 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, l)));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	_tmp13 = NULL;
	vala_ccode_fragment_append (cn, (ValaCCodeNode*) (_tmp13 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) fc)));
	(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
	vala_ccode_fragment_append (cn, vala_code_node_get_ccodenode ((ValaCodeNode*) vala_lock_statement_get_body (stmt)));
	_tmp17 = NULL;
	_tmp16 = NULL;
	_tmp15 = NULL;
	_tmp14 = NULL;
	fc = (_tmp17 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp16 = vala_ccode_identifier_new (_tmp15 = vala_method_get_cname (_tmp14 = (VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) self->mutex_type), "unlock"))))))), (fc == NULL) ? NULL : (fc = (vala_ccode_node_unref (fc), NULL)), _tmp17);
	(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
	_tmp15 = (g_free (_tmp15), NULL);
	(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_code_node_unref (_tmp14), NULL));
	_tmp18 = NULL;
	vala_ccode_function_call_add_argument (fc, (ValaCCodeExpression*) (_tmp18 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, l)));
	(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
	_tmp19 = NULL;
	vala_ccode_fragment_append (cn, (ValaCCodeNode*) (_tmp19 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) fc)));
	(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cn);
	(cn == NULL) ? NULL : (cn = (vala_ccode_node_unref (cn), NULL));
	(l == NULL) ? NULL : (l = (vala_ccode_node_unref (l), NULL));
	(fc == NULL) ? NULL : (fc = (vala_ccode_node_unref (fc), NULL));
	(inner_node == NULL) ? NULL : (inner_node = (vala_code_node_unref (inner_node), NULL));
}


static void vala_ccode_base_module_real_visit_delete_statement (ValaCCodeModule* base, ValaDeleteStatement* stmt) {
	ValaCCodeBaseModule * self;
	ValaPointerType* _tmp0;
	ValaPointerType* pointer_type;
	ValaDataType* _tmp1;
	ValaDataType* type;
	gboolean _tmp2;
	ValaCCodeExpression* _tmp5;
	ValaCCodeFunctionCall* _tmp6;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeExpressionStatement* _tmp7;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	_tmp0 = NULL;
	pointer_type = (_tmp0 = VALA_POINTER_TYPE (vala_expression_get_value_type (vala_delete_statement_get_expression (stmt))), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	_tmp1 = NULL;
	type = (_tmp1 = (ValaDataType*) pointer_type, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp2 = FALSE;
	if (vala_data_type_get_data_type (vala_pointer_type_get_base_type (pointer_type)) != NULL) {
		_tmp2 = vala_typesymbol_is_reference_type (vala_data_type_get_data_type (vala_pointer_type_get_base_type (pointer_type)));
	} else {
		_tmp2 = FALSE;
	}
	if (_tmp2) {
		ValaDataType* _tmp4;
		ValaDataType* _tmp3;
		_tmp4 = NULL;
		_tmp3 = NULL;
		type = (_tmp4 = (_tmp3 = vala_pointer_type_get_base_type (pointer_type), (_tmp3 == NULL) ? NULL : vala_code_node_ref (_tmp3)), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp4);
	}
	_tmp5 = NULL;
	_tmp6 = NULL;
	ccall = (_tmp6 = vala_ccode_function_call_new (_tmp5 = vala_ccode_base_module_get_destroy_func_expression (self, type)), (_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)), _tmp6);
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_delete_statement_get_expression (stmt))));
	_tmp7 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) (_tmp7 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	(pointer_type == NULL) ? NULL : (pointer_type = (vala_code_node_unref (pointer_type), NULL));
	(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
}


static void vala_ccode_base_module_real_visit_expression (ValaCCodeModule* base, ValaExpression* expr) {
	ValaCCodeBaseModule * self;
	gboolean _tmp0;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0 = FALSE;
	if (vala_code_node_get_ccodenode ((ValaCodeNode*) expr) != NULL) {
		_tmp0 = !vala_expression_get_lvalue (expr);
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		gboolean _tmp1;
		ValaCCodeExpression* _tmp3;
		gboolean _tmp4;
		_tmp1 = FALSE;
		if (VALA_IS_GENERIC_TYPE (vala_expression_get_formal_value_type (expr))) {
			_tmp1 = !(VALA_IS_GENERIC_TYPE (vala_expression_get_value_type (expr)));
		} else {
			_tmp1 = FALSE;
		}
		if (_tmp1) {
			if (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_data_type_get_type_parameter (vala_expression_get_formal_value_type (expr))) != VALA_SYMBOL (self->garray_type)) {
				ValaCCodeExpression* _tmp2;
				/* GArray doesn't use pointer-based generics*/
				_tmp2 = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp2 = vala_ccode_base_module_convert_from_generic_pointer (self, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) expr)), vala_expression_get_value_type (expr))));
				(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
			}
		}
		/* memory management, implicit casts, and boxing/unboxing*/
		_tmp3 = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp3 = vala_ccode_base_module_transform_expression (self, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) expr)), vala_expression_get_value_type (expr), vala_expression_get_target_type (expr), expr)));
		(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
		_tmp4 = FALSE;
		if (VALA_IS_GENERIC_TYPE (vala_expression_get_formal_target_type (expr))) {
			_tmp4 = !(VALA_IS_GENERIC_TYPE (vala_expression_get_target_type (expr)));
		} else {
			_tmp4 = FALSE;
		}
		if (_tmp4) {
			if (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_data_type_get_type_parameter (vala_expression_get_formal_target_type (expr))) != VALA_SYMBOL (self->garray_type)) {
				ValaCCodeExpression* _tmp5;
				/* GArray doesn't use pointer-based generics*/
				_tmp5 = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp5 = vala_ccode_base_module_convert_to_generic_pointer (self, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) expr)), vala_expression_get_target_type (expr))));
				(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
			}
		}
	}
}


static void vala_ccode_base_module_real_visit_boolean_literal (ValaCCodeModule* base, ValaBooleanLiteral* expr) {
	ValaCCodeBaseModule * self;
	const char* _tmp0;
	ValaCCodeConstant* _tmp1;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	if (vala_boolean_literal_get_value (expr)) {
		_tmp0 = "TRUE";
	} else {
		_tmp0 = "FALSE";
	}
	_tmp1 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp1 = vala_ccode_constant_new (_tmp0)));
	(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
}


static void vala_ccode_base_module_real_visit_character_literal (ValaCCodeModule* base, ValaCharacterLiteral* expr) {
	ValaCCodeBaseModule * self;
	gboolean _tmp0;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0 = FALSE;
	if (vala_character_literal_get_char (expr) >= 0x20) {
		_tmp0 = vala_character_literal_get_char (expr) < 0x80;
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		ValaCCodeConstant* _tmp1;
		_tmp1 = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp1 = vala_ccode_constant_new (vala_character_literal_get_value (expr))));
		(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
	} else {
		ValaCCodeConstant* _tmp3;
		char* _tmp2;
		_tmp3 = NULL;
		_tmp2 = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp3 = vala_ccode_constant_new (_tmp2 = g_strdup_printf ("%uU", (guint) vala_character_literal_get_char (expr)))));
		(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
		_tmp2 = (g_free (_tmp2), NULL);
	}
}


static void vala_ccode_base_module_real_visit_integer_literal (ValaCCodeModule* base, ValaIntegerLiteral* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeConstant* _tmp0;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp0 = vala_ccode_constant_new (vala_integer_literal_get_value (expr))));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
}


static void vala_ccode_base_module_real_visit_real_literal (ValaCCodeModule* base, ValaRealLiteral* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeConstant* _tmp0;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp0 = vala_ccode_constant_new (vala_real_literal_get_value (expr))));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
}


static void vala_ccode_base_module_real_visit_string_literal (ValaCCodeModule* base, ValaStringLiteral* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeConstant* _tmp0;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp0 = vala_ccode_constant_new (vala_string_literal_get_value (expr))));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
}


static void vala_ccode_base_module_real_visit_null_literal (ValaCCodeModule* base, ValaNullLiteral* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeConstant* _tmp0;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp0 = vala_ccode_constant_new ("NULL")));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
}


static void vala_ccode_base_module_real_visit_parenthesized_expression (ValaCCodeModule* base, ValaParenthesizedExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeParenthesizedExpression* _tmp0;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp0 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_parenthesized_expression_get_inner (expr))))));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
}


static char* vala_ccode_base_module_real_get_delegate_target_cname (ValaCCodeBaseModule* self, const char* delegate_cname) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (delegate_cname != NULL, NULL);
	g_assert_not_reached ();
}


char* vala_ccode_base_module_get_delegate_target_cname (ValaCCodeBaseModule* self, const char* delegate_cname) {
	return VALA_CCODE_BASE_MODULE_GET_CLASS (self)->get_delegate_target_cname (self, delegate_cname);
}


static ValaCCodeExpression* vala_ccode_base_module_real_get_delegate_target_cexpression (ValaCCodeBaseModule* self, ValaExpression* delegate_expr) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (delegate_expr != NULL, NULL);
	g_assert_not_reached ();
}


ValaCCodeExpression* vala_ccode_base_module_get_delegate_target_cexpression (ValaCCodeBaseModule* self, ValaExpression* delegate_expr) {
	return VALA_CCODE_BASE_MODULE_GET_CLASS (self)->get_delegate_target_cexpression (self, delegate_expr);
}


static char* vala_ccode_base_module_real_get_delegate_target_destroy_notify_cname (ValaCCodeBaseModule* self, const char* delegate_cname) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (delegate_cname != NULL, NULL);
	g_assert_not_reached ();
}


char* vala_ccode_base_module_get_delegate_target_destroy_notify_cname (ValaCCodeBaseModule* self, const char* delegate_cname) {
	return VALA_CCODE_BASE_MODULE_GET_CLASS (self)->get_delegate_target_destroy_notify_cname (self, delegate_cname);
}


static void vala_ccode_base_module_real_visit_base_access (ValaCCodeModule* base, ValaBaseAccess* expr) {
	ValaCCodeBaseModule * self;
	ValaInstanceCast* _tmp1;
	ValaCCodeIdentifier* _tmp0;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp1 = vala_instance_cast_new ((ValaCCodeExpression*) (_tmp0 = vala_ccode_identifier_new ("self")), vala_data_type_get_data_type (vala_expression_get_value_type ((ValaExpression*) expr)))));
	(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
}


static void vala_ccode_base_module_real_visit_postfix_expression (ValaCCodeModule* base, ValaPostfixExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaMemberAccess* ma;
	ValaCCodeUnaryOperator _tmp8;
	ValaCCodeUnaryOperator op;
	ValaCCodeUnaryExpression* _tmp9;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	ma = vala_ccode_base_module_find_property_access (self, vala_postfix_expression_get_inner (expr));
	if (ma != NULL) {
		ValaProperty* _tmp0;
		ValaProperty* prop;
		ValaCCodeCommaExpression* ccomma;
		ValaLocalVariable* temp_decl;
		ValaCCodeAssignment* _tmp2;
		ValaCCodeIdentifier* _tmp1;
		ValaCCodeBinaryOperator _tmp3;
		ValaCCodeBinaryOperator op;
		ValaCCodeConstant* _tmp5;
		ValaCCodeIdentifier* _tmp4;
		ValaCCodeBinaryExpression* _tmp6;
		ValaCCodeBinaryExpression* cexpr;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* _tmp7;
		/* property postfix expression*/
		_tmp0 = NULL;
		prop = (_tmp0 = VALA_PROPERTY (vala_expression_get_symbol_reference ((ValaExpression*) ma)), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
		ccomma = vala_ccode_comma_expression_new ();
		/* assign current value to temp variable*/
		temp_decl = vala_ccode_base_module_get_temp_variable (self, vala_property_get_property_type (prop), TRUE, (ValaCodeNode*) expr);
		gee_list_insert ((GeeList*) self->temp_vars, 0, temp_decl);
		_tmp2 = NULL;
		_tmp1 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp2 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp1 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_decl))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_postfix_expression_get_inner (expr))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
		(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
		_tmp3 = 0;
		if (vala_postfix_expression_get_increment (expr)) {
			_tmp3 = VALA_CCODE_BINARY_OPERATOR_PLUS;
		} else {
			_tmp3 = VALA_CCODE_BINARY_OPERATOR_MINUS;
		}
		/* increment/decrement property*/
		op = _tmp3;
		_tmp5 = NULL;
		_tmp4 = NULL;
		_tmp6 = NULL;
		cexpr = (_tmp6 = vala_ccode_binary_expression_new (op, (ValaCCodeExpression*) (_tmp4 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_decl))), (ValaCCodeExpression*) (_tmp5 = vala_ccode_constant_new ("1"))), (_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)), (_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)), _tmp6);
		ccall = vala_ccode_base_module_get_property_set_call (self, prop, ma, (ValaCCodeExpression*) cexpr);
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) ccall);
		/* return previous value*/
		_tmp7 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_decl))));
		(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccomma);
		(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
		(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
		(temp_decl == NULL) ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL));
		(cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL));
		(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
		(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
		return;
	}
	_tmp8 = 0;
	if (vala_postfix_expression_get_increment (expr)) {
		_tmp8 = VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT;
	} else {
		_tmp8 = VALA_CCODE_UNARY_OPERATOR_POSTFIX_DECREMENT;
	}
	op = _tmp8;
	_tmp9 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp9 = vala_ccode_unary_expression_new (op, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_postfix_expression_get_inner (expr))))));
	(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
}


static ValaMemberAccess* vala_ccode_base_module_find_property_access (ValaCCodeBaseModule* self, ValaExpression* expr) {
	ValaMemberAccess* _tmp3;
	ValaMemberAccess* ma;
	ValaMemberAccess* _tmp5;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	if (VALA_IS_PARENTHESIZED_EXPRESSION (expr)) {
		ValaParenthesizedExpression* _tmp0;
		ValaParenthesizedExpression* pe;
		ValaMemberAccess* _tmp1;
		_tmp0 = NULL;
		pe = (_tmp0 = VALA_PARENTHESIZED_EXPRESSION (expr), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
		_tmp1 = NULL;
		return (_tmp1 = vala_ccode_base_module_find_property_access (self, vala_parenthesized_expression_get_inner (pe)), (pe == NULL) ? NULL : (pe = (vala_code_node_unref (pe), NULL)), _tmp1);
	}
	if (!(VALA_IS_MEMBER_ACCESS (expr))) {
		return NULL;
	}
	_tmp3 = NULL;
	ma = (_tmp3 = VALA_MEMBER_ACCESS (expr), (_tmp3 == NULL) ? NULL : vala_code_node_ref (_tmp3));
	if (VALA_IS_PROPERTY (vala_expression_get_symbol_reference ((ValaExpression*) ma))) {
		return ma;
	}
	_tmp5 = NULL;
	return (_tmp5 = NULL, (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), _tmp5);
}


gboolean vala_ccode_base_module_requires_copy (ValaCCodeBaseModule* self, ValaDataType* type) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	if (!vala_data_type_is_disposable (type)) {
		return FALSE;
	}
	if (vala_data_type_get_type_parameter (type) != NULL) {
		gboolean _tmp1;
		_tmp1 = FALSE;
		if (!(VALA_IS_CLASS (self->current_type_symbol))) {
			_tmp1 = TRUE;
		} else {
			_tmp1 = vala_class_get_is_compact (self->current_class);
		}
		if (_tmp1) {
			return FALSE;
		}
	}
	return TRUE;
}


gboolean vala_ccode_base_module_requires_destroy (ValaCCodeBaseModule* self, ValaDataType* type) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	if (!vala_data_type_is_disposable (type)) {
		return FALSE;
	}
	if (vala_data_type_get_type_parameter (type) != NULL) {
		gboolean _tmp1;
		_tmp1 = FALSE;
		if (!(VALA_IS_CLASS (self->current_type_symbol))) {
			_tmp1 = TRUE;
		} else {
			_tmp1 = vala_class_get_is_compact (self->current_class);
		}
		if (_tmp1) {
			return FALSE;
		}
	}
	return TRUE;
}


ValaCCodeExpression* vala_ccode_base_module_get_ref_cexpression (ValaCCodeBaseModule* self, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node) {
	gboolean _tmp0;
	ValaCCodeExpression* dupexpr;
	ValaCCodeFunctionCall* ccall;
	gboolean _tmp18;
	gboolean _tmp19;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (expression_type != NULL, NULL);
	g_return_val_if_fail (cexpr != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0 = FALSE;
	if (VALA_IS_VALUE_TYPE (expression_type)) {
		_tmp0 = !vala_data_type_get_nullable (expression_type);
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		ValaLocalVariable* decl;
		ValaCCodeIdentifier* ctemp;
		ValaValueType* _tmp1;
		ValaValueType* vt;
		ValaStruct* _tmp2;
		ValaStruct* st;
		ValaCCodeIdentifier* _tmp4;
		char* _tmp3;
		ValaCCodeFunctionCall* _tmp5;
		ValaCCodeFunctionCall* copy_call;
		ValaCCodeUnaryExpression* _tmp6;
		ValaCCodeUnaryExpression* _tmp7;
		ValaCCodeCommaExpression* ccomma;
		char* _tmp8;
		gboolean _tmp9;
		ValaCCodeExpression* _tmp16;
		/* normal value type, no null check
		 (copy (&expr, &temp), temp)*/
		decl = vala_ccode_base_module_get_temp_variable (self, expression_type, FALSE, node);
		gee_list_insert ((GeeList*) self->temp_vars, 0, decl);
		ctemp = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) decl));
		_tmp1 = NULL;
		vt = (_tmp1 = VALA_VALUE_TYPE (expression_type), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
		_tmp2 = NULL;
		st = (_tmp2 = VALA_STRUCT (vala_value_type_get_type_symbol (vt)), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
		_tmp4 = NULL;
		_tmp3 = NULL;
		_tmp5 = NULL;
		copy_call = (_tmp5 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp4 = vala_ccode_identifier_new (_tmp3 = vala_typesymbol_get_copy_function ((ValaTypeSymbol*) st)))), (_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)), _tmp3 = (g_free (_tmp3), NULL), _tmp5);
		_tmp6 = NULL;
		vala_ccode_function_call_add_argument (copy_call, (ValaCCodeExpression*) (_tmp6 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, cexpr)));
		(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
		_tmp7 = NULL;
		vala_ccode_function_call_add_argument (copy_call, (ValaCCodeExpression*) (_tmp7 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) ctemp)));
		(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
		ccomma = vala_ccode_comma_expression_new ();
		_tmp8 = NULL;
		if ((_tmp9 = _vala_strcmp0 (_tmp8 = vala_typesymbol_get_copy_function ((ValaTypeSymbol*) st), "g_value_copy") == 0, _tmp8 = (g_free (_tmp8), NULL), _tmp9)) {
			ValaCCodeIdentifier* _tmp10;
			ValaCCodeFunctionCall* _tmp11;
			ValaCCodeFunctionCall* value_type_call;
			ValaCCodeUnaryExpression* _tmp12;
			ValaCCodeIdentifier* _tmp13;
			ValaCCodeFunctionCall* _tmp14;
			ValaCCodeFunctionCall* init_call;
			ValaCCodeUnaryExpression* _tmp15;
			/* GValue requires g_value_init in addition to g_value_copy*/
			_tmp10 = NULL;
			_tmp11 = NULL;
			value_type_call = (_tmp11 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp10 = vala_ccode_identifier_new ("G_VALUE_TYPE"))), (_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)), _tmp11);
			_tmp12 = NULL;
			vala_ccode_function_call_add_argument (value_type_call, (ValaCCodeExpression*) (_tmp12 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, cexpr)));
			(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
			_tmp13 = NULL;
			_tmp14 = NULL;
			init_call = (_tmp14 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp13 = vala_ccode_identifier_new ("g_value_init"))), (_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)), _tmp14);
			_tmp15 = NULL;
			vala_ccode_function_call_add_argument (init_call, (ValaCCodeExpression*) (_tmp15 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) ctemp)));
			(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
			vala_ccode_function_call_add_argument (init_call, (ValaCCodeExpression*) value_type_call);
			vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) init_call);
			(value_type_call == NULL) ? NULL : (value_type_call = (vala_ccode_node_unref (value_type_call), NULL));
			(init_call == NULL) ? NULL : (init_call = (vala_ccode_node_unref (init_call), NULL));
		}
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) copy_call);
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) ctemp);
		_tmp16 = NULL;
		return (_tmp16 = (ValaCCodeExpression*) ccomma, (decl == NULL) ? NULL : (decl = (vala_code_node_unref (decl), NULL)), (ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL)), (vt == NULL) ? NULL : (vt = (vala_code_node_unref (vt), NULL)), (st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL)), (copy_call == NULL) ? NULL : (copy_call = (vala_ccode_node_unref (copy_call), NULL)), _tmp16);
	}
	/* (temp = expr, temp == NULL ? NULL : ref (temp))
	 *
	 * can be simplified to
	 * ref (expr)
	 * if static type of expr is non-null
	 */
	dupexpr = vala_ccode_base_module_get_dup_func_expression (self, expression_type, vala_code_node_get_source_reference (node));
	if (dupexpr == NULL) {
		ValaCCodeExpression* _tmp17;
		vala_code_node_set_error (node, TRUE);
		_tmp17 = NULL;
		return (_tmp17 = NULL, (dupexpr == NULL) ? NULL : (dupexpr = (vala_ccode_node_unref (dupexpr), NULL)), _tmp17);
	}
	ccall = vala_ccode_function_call_new (dupexpr);
	_tmp18 = FALSE;
	_tmp19 = FALSE;
	if (!(VALA_IS_ARRAY_TYPE (expression_type))) {
		_tmp19 = expr != NULL;
	} else {
		_tmp19 = FALSE;
	}
	if (_tmp19) {
		_tmp18 = vala_expression_is_non_null (expr);
	} else {
		_tmp18 = FALSE;
	}
	if (_tmp18) {
		ValaCCodeExpression* _tmp20;
		/* expression is non-null*/
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) expr)));
		_tmp20 = NULL;
		return (_tmp20 = (ValaCCodeExpression*) ccall, (dupexpr == NULL) ? NULL : (dupexpr = (vala_ccode_node_unref (dupexpr), NULL)), _tmp20);
	} else {
		ValaLocalVariable* decl;
		ValaCCodeIdentifier* ctemp;
		ValaCCodeConstant* _tmp21;
		ValaCCodeBinaryExpression* _tmp22;
		ValaCCodeBinaryExpression* cisnull;
		ValaCCodeCommaExpression* ccomma;
		ValaCCodeAssignment* _tmp34;
		ValaCCodeExpression* cifnull;
		ValaCCodeConditionalExpression* _tmp37;
		ValaCCodeExpression* _tmp38;
		decl = vala_ccode_base_module_get_temp_variable (self, expression_type, FALSE, node);
		gee_list_insert ((GeeList*) self->temp_vars, 0, decl);
		ctemp = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) decl));
		_tmp21 = NULL;
		_tmp22 = NULL;
		cisnull = (_tmp22 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) ctemp, (ValaCCodeExpression*) (_tmp21 = vala_ccode_constant_new ("NULL"))), (_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL)), _tmp22);
		if (vala_data_type_get_type_parameter (expression_type) != NULL) {
			ValaCCodeConstant* _tmp26;
			ValaCCodeExpression* _tmp25;
			ValaCCodeBinaryExpression* _tmp27;
			ValaCCodeBinaryExpression* cdupisnull;
			ValaCCodeBinaryExpression* _tmp28;
			if (!(VALA_IS_CLASS (self->current_type_symbol))) {
				ValaCCodeExpression* _tmp23;
				ValaCCodeExpression* _tmp24;
				_tmp23 = NULL;
				_tmp24 = NULL;
				return (_tmp24 = (_tmp23 = cexpr, (_tmp23 == NULL) ? NULL : vala_ccode_node_ref (_tmp23)), (decl == NULL) ? NULL : (decl = (vala_code_node_unref (decl), NULL)), (ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL)), (cisnull == NULL) ? NULL : (cisnull = (vala_ccode_node_unref (cisnull), NULL)), (dupexpr == NULL) ? NULL : (dupexpr = (vala_ccode_node_unref (dupexpr), NULL)), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp24);
			}
			/* dup functions are optional for type parameters*/
			_tmp26 = NULL;
			_tmp25 = NULL;
			_tmp27 = NULL;
			cdupisnull = (_tmp27 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp25 = vala_ccode_base_module_get_dup_func_expression (self, expression_type, vala_code_node_get_source_reference (node)), (ValaCCodeExpression*) (_tmp26 = vala_ccode_constant_new ("NULL"))), (_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL)), (_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL)), _tmp27);
			_tmp28 = NULL;
			cisnull = (_tmp28 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, (ValaCCodeExpression*) cisnull, (ValaCCodeExpression*) cdupisnull), (cisnull == NULL) ? NULL : (cisnull = (vala_ccode_node_unref (cisnull), NULL)), _tmp28);
			(cdupisnull == NULL) ? NULL : (cdupisnull = (vala_ccode_node_unref (cdupisnull), NULL));
		}
		if (vala_data_type_get_type_parameter (expression_type) != NULL) {
			ValaCCodeCastExpression* _tmp29;
			/* cast from gconstpointer to gpointer as GBoxedCopyFunc expects gpointer*/
			_tmp29 = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp29 = vala_ccode_cast_expression_new ((ValaCCodeExpression*) ctemp, "gpointer")));
			(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
		} else {
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) ctemp);
		}
		if (VALA_IS_ARRAY_TYPE (expression_type)) {
			ValaArrayType* _tmp30;
			ValaArrayType* array_type;
			gboolean first;
			ValaCCodeExpression* csizeexpr;
			_tmp30 = NULL;
			array_type = (_tmp30 = VALA_ARRAY_TYPE (expression_type), (_tmp30 == NULL) ? NULL : vala_code_node_ref (_tmp30));
			first = TRUE;
			csizeexpr = NULL;
			{
				gint dim;
				dim = 1;
				for (; dim <= vala_array_type_get_rank (array_type); dim++) {
					if (first) {
						ValaCCodeExpression* _tmp31;
						_tmp31 = NULL;
						csizeexpr = (_tmp31 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), expr, dim), (csizeexpr == NULL) ? NULL : (csizeexpr = (vala_ccode_node_unref (csizeexpr), NULL)), _tmp31);
						first = FALSE;
					} else {
						ValaCCodeExpression* _tmp33;
						ValaCCodeExpression* _tmp32;
						_tmp33 = NULL;
						_tmp32 = NULL;
						csizeexpr = (_tmp33 = (ValaCCodeExpression*) vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, csizeexpr, _tmp32 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), expr, dim)), (csizeexpr == NULL) ? NULL : (csizeexpr = (vala_ccode_node_unref (csizeexpr), NULL)), _tmp33);
						(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
					}
				}
			}
			vala_ccode_function_call_add_argument (ccall, csizeexpr);
			(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
			(csizeexpr == NULL) ? NULL : (csizeexpr = (vala_ccode_node_unref (csizeexpr), NULL));
		}
		ccomma = vala_ccode_comma_expression_new ();
		_tmp34 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp34 = vala_ccode_assignment_new ((ValaCCodeExpression*) ctemp, cexpr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
		cifnull = NULL;
		if (vala_data_type_get_data_type (expression_type) != NULL) {
			ValaCCodeExpression* _tmp35;
			_tmp35 = NULL;
			cifnull = (_tmp35 = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL"), (cifnull == NULL) ? NULL : (cifnull = (vala_ccode_node_unref (cifnull), NULL)), _tmp35);
		} else {
			ValaCCodeExpression* _tmp36;
			/* the value might be non-null even when the dup function is null,
			 so we may not just use NULL for type parameters
			 cast from gconstpointer to gpointer as methods in
			 generic classes may not return gconstpointer*/
			_tmp36 = NULL;
			cifnull = (_tmp36 = (ValaCCodeExpression*) vala_ccode_cast_expression_new ((ValaCCodeExpression*) ctemp, "gpointer"), (cifnull == NULL) ? NULL : (cifnull = (vala_ccode_node_unref (cifnull), NULL)), _tmp36);
		}
		_tmp37 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp37 = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) cisnull, cifnull, (ValaCCodeExpression*) ccall)));
		(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
		_tmp38 = NULL;
		return (_tmp38 = (ValaCCodeExpression*) ccomma, (decl == NULL) ? NULL : (decl = (vala_code_node_unref (decl), NULL)), (ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL)), (cisnull == NULL) ? NULL : (cisnull = (vala_ccode_node_unref (cisnull), NULL)), (cifnull == NULL) ? NULL : (cifnull = (vala_ccode_node_unref (cifnull), NULL)), (dupexpr == NULL) ? NULL : (dupexpr = (vala_ccode_node_unref (dupexpr), NULL)), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp38);
	}
	(dupexpr == NULL) ? NULL : (dupexpr = (vala_ccode_node_unref (dupexpr), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
}


static void vala_ccode_base_module_real_visit_object_creation_expression (ValaCCodeModule* base, ValaObjectCreationExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeExpression* instance;
	ValaCCodeExpression* creation_expr;
	ValaStruct* _tmp1;
	ValaTypeSymbol* _tmp0;
	ValaStruct* st;
	gboolean _tmp2;
	gboolean _tmp3;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	instance = NULL;
	creation_expr = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	st = (_tmp1 = (_tmp0 = vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)), VALA_IS_STRUCT (_tmp0) ? ((ValaStruct*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp2 = FALSE;
	_tmp3 = FALSE;
	if (st != NULL) {
		_tmp3 = !vala_struct_is_simple_type (st);
	} else {
		_tmp3 = FALSE;
	}
	if ((_tmp3)) {
		_tmp2 = TRUE;
	} else {
		GeeList* _tmp4;
		_tmp4 = NULL;
		_tmp2 = gee_collection_get_size ((GeeCollection*) (_tmp4 = vala_object_creation_expression_get_object_initializer (expr))) > 0;
		(_tmp4 == NULL) ? NULL : (_tmp4 = (gee_collection_object_unref (_tmp4), NULL));
	}
	if (_tmp2) {
		ValaLocalVariable* temp_decl;
		ValaCCodeExpression* _tmp6;
		char* _tmp5;
		/* value-type initialization or object creation expression with object initializer*/
		temp_decl = vala_ccode_base_module_get_temp_variable (self, vala_object_creation_expression_get_type_reference (expr), FALSE, (ValaCodeNode*) expr);
		gee_collection_add ((GeeCollection*) self->temp_vars, temp_decl);
		_tmp6 = NULL;
		_tmp5 = NULL;
		instance = (_tmp6 = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp5 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) temp_decl))), (instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)), _tmp6);
		_tmp5 = (g_free (_tmp5), NULL);
		(temp_decl == NULL) ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL));
	}
	if (vala_expression_get_symbol_reference ((ValaExpression*) expr) == NULL) {
		ValaCCodeFunctionCall* creation_call;
		gboolean _tmp7;
		ValaCCodeExpression* _tmp28;
		ValaCCodeExpression* _tmp27;
		creation_call = NULL;
		_tmp7 = FALSE;
		if (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)) == VALA_TYPESYMBOL (self->glist_type)) {
			_tmp7 = TRUE;
		} else {
			_tmp7 = vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)) == VALA_TYPESYMBOL (self->gslist_type);
		}
		/* no creation method*/
		if (_tmp7) {
			ValaCCodeConstant* _tmp8;
			/* NULL is an empty list*/
			_tmp8 = NULL;
			vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp8 = vala_ccode_constant_new ("NULL")));
			(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
		} else {
			gboolean _tmp9;
			_tmp9 = FALSE;
			if (VALA_IS_CLASS (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
				_tmp9 = vala_typesymbol_is_subtype_of (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)), self->gobject_type);
			} else {
				_tmp9 = FALSE;
			}
			if (_tmp9) {
				ValaCCodeFunctionCall* _tmp11;
				ValaCCodeIdentifier* _tmp10;
				ValaCCodeConstant* _tmp13;
				char* _tmp12;
				ValaCCodeConstant* _tmp14;
				_tmp11 = NULL;
				_tmp10 = NULL;
				creation_call = (_tmp11 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp10 = vala_ccode_identifier_new ("g_object_new"))), (creation_call == NULL) ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL)), _tmp11);
				(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
				_tmp13 = NULL;
				_tmp12 = NULL;
				vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp13 = vala_ccode_constant_new (_tmp12 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr))))));
				(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
				_tmp12 = (g_free (_tmp12), NULL);
				_tmp14 = NULL;
				vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp14 = vala_ccode_constant_new ("NULL")));
				(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
			} else {
				if (VALA_IS_CLASS (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
					ValaCCodeFunctionCall* _tmp16;
					ValaCCodeIdentifier* _tmp15;
					ValaCCodeConstant* _tmp18;
					char* _tmp17;
					ValaCCodeConstant* _tmp19;
					_tmp16 = NULL;
					_tmp15 = NULL;
					creation_call = (_tmp16 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp15 = vala_ccode_identifier_new ("g_new0"))), (creation_call == NULL) ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL)), _tmp16);
					(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
					_tmp18 = NULL;
					_tmp17 = NULL;
					vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp18 = vala_ccode_constant_new (_tmp17 = vala_typesymbol_get_cname (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)), FALSE))));
					(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
					_tmp17 = (g_free (_tmp17), NULL);
					_tmp19 = NULL;
					vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp19 = vala_ccode_constant_new ("1")));
					(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
				} else {
					if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
						ValaCCodeFunctionCall* _tmp21;
						ValaCCodeIdentifier* _tmp20;
						ValaCCodeUnaryExpression* _tmp22;
						ValaCCodeConstant* _tmp23;
						ValaCCodeIdentifier* _tmp26;
						char* _tmp25;
						char* _tmp24;
						/* memset needs string.h*/
						self->string_h_needed = TRUE;
						_tmp21 = NULL;
						_tmp20 = NULL;
						creation_call = (_tmp21 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp20 = vala_ccode_identifier_new ("memset"))), (creation_call == NULL) ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL)), _tmp21);
						(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
						_tmp22 = NULL;
						vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp22 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, instance)));
						(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
						_tmp23 = NULL;
						vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp23 = vala_ccode_constant_new ("0")));
						(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
						_tmp26 = NULL;
						_tmp25 = NULL;
						_tmp24 = NULL;
						vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp26 = vala_ccode_identifier_new (_tmp25 = g_strdup_printf ("sizeof (%s)", _tmp24 = vala_data_type_get_cname (vala_object_creation_expression_get_type_reference (expr))))));
						(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
						_tmp25 = (g_free (_tmp25), NULL);
						_tmp24 = (g_free (_tmp24), NULL);
					}
				}
			}
		}
		_tmp28 = NULL;
		_tmp27 = NULL;
		creation_expr = (_tmp28 = (_tmp27 = (ValaCCodeExpression*) creation_call, (_tmp27 == NULL) ? NULL : vala_ccode_node_ref (_tmp27)), (creation_expr == NULL) ? NULL : (creation_expr = (vala_ccode_node_unref (creation_expr), NULL)), _tmp28);
		(creation_call == NULL) ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL));
	} else {
		if (VALA_IS_METHOD (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
			ValaMethod* _tmp29;
			ValaMethod* m;
			GeeList* params;
			ValaCCodeFunctionCall* creation_call;
			ValaCCodeFunctionCall* _tmp32;
			ValaCCodeIdentifier* _tmp31;
			char* _tmp30;
			gboolean _tmp33;
			gboolean _tmp34;
			ValaClass* _tmp37;
			ValaTypeSymbol* _tmp36;
			ValaClass* cl;
			gboolean _tmp38;
			GeeHashMap* carg_map;
			gboolean ellipsis;
			gint i;
			gint arg_pos;
			GeeIterator* params_it;
			gint last_pos;
			gint min_pos;
			gboolean _tmp62;
			gboolean _tmp63;
			ValaCCodeExpression* _tmp70;
			ValaCCodeExpression* _tmp69;
			char* _tmp71;
			gboolean _tmp72;
			/* use creation method*/
			_tmp29 = NULL;
			m = (_tmp29 = VALA_METHOD (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp29 == NULL) ? NULL : vala_code_node_ref (_tmp29));
			params = vala_method_get_parameters (m);
			creation_call = NULL;
			_tmp32 = NULL;
			_tmp31 = NULL;
			_tmp30 = NULL;
			creation_call = (_tmp32 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp31 = vala_ccode_identifier_new (_tmp30 = vala_method_get_cname (m)))), (creation_call == NULL) ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL)), _tmp32);
			(_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL));
			_tmp30 = (g_free (_tmp30), NULL);
			_tmp33 = FALSE;
			_tmp34 = FALSE;
			if (st != NULL) {
				_tmp34 = !vala_struct_is_simple_type (st);
			} else {
				_tmp34 = FALSE;
			}
			if ((_tmp34)) {
				_tmp33 = !(vala_method_get_cinstance_parameter_position (m) < 0);
			} else {
				_tmp33 = FALSE;
			}
			if (_tmp33) {
				ValaCCodeUnaryExpression* _tmp35;
				_tmp35 = NULL;
				vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp35 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, instance)));
				(_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL));
			}
			_tmp37 = NULL;
			_tmp36 = NULL;
			cl = (_tmp37 = (_tmp36 = vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)), VALA_IS_CLASS (_tmp36) ? ((ValaClass*) _tmp36) : NULL), (_tmp37 == NULL) ? NULL : vala_code_node_ref (_tmp37));
			_tmp38 = FALSE;
			if (cl != NULL) {
				_tmp38 = !vala_class_get_is_compact (cl);
			} else {
				_tmp38 = FALSE;
			}
			if (_tmp38) {
				{
					GeeList* _tmp39;
					GeeIterator* _tmp40;
					GeeIterator* type_arg_it;
					_tmp39 = NULL;
					_tmp40 = NULL;
					type_arg_it = (_tmp40 = gee_iterable_iterator ((GeeIterable*) (_tmp39 = vala_data_type_get_type_arguments (vala_object_creation_expression_get_type_reference (expr)))), (_tmp39 == NULL) ? NULL : (_tmp39 = (gee_collection_object_unref (_tmp39), NULL)), _tmp40);
					while (gee_iterator_next (type_arg_it)) {
						ValaDataType* type_arg;
						ValaCCodeExpression* _tmp41;
						type_arg = (ValaDataType*) gee_iterator_get (type_arg_it);
						_tmp41 = NULL;
						vala_ccode_function_call_add_argument (creation_call, _tmp41 = vala_ccode_base_module_get_type_id_expression (self, type_arg));
						(_tmp41 == NULL) ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL));
						if (vala_ccode_base_module_requires_copy (self, type_arg)) {
							ValaCCodeExpression* dup_func;
							ValaCCodeCastExpression* _tmp42;
							ValaCCodeExpression* _tmp43;
							dup_func = vala_ccode_base_module_get_dup_func_expression (self, type_arg, vala_code_node_get_source_reference ((ValaCodeNode*) type_arg));
							if (dup_func == NULL) {
								/* type doesn't contain a copy function*/
								vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
								(dup_func == NULL) ? NULL : (dup_func = (vala_ccode_node_unref (dup_func), NULL));
								(type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL));
								(type_arg_it == NULL) ? NULL : (type_arg_it = (gee_collection_object_unref (type_arg_it), NULL));
								(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
								(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
								(creation_call == NULL) ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL));
								(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
								(instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL));
								(creation_expr == NULL) ? NULL : (creation_expr = (vala_ccode_node_unref (creation_expr), NULL));
								(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
								return;
							}
							_tmp42 = NULL;
							vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp42 = vala_ccode_cast_expression_new (dup_func, "GBoxedCopyFunc")));
							(_tmp42 == NULL) ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL));
							_tmp43 = NULL;
							vala_ccode_function_call_add_argument (creation_call, _tmp43 = vala_ccode_base_module_get_destroy_func_expression (self, type_arg));
							(_tmp43 == NULL) ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL));
							(dup_func == NULL) ? NULL : (dup_func = (vala_ccode_node_unref (dup_func), NULL));
						} else {
							ValaCCodeConstant* _tmp44;
							ValaCCodeConstant* _tmp45;
							_tmp44 = NULL;
							vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp44 = vala_ccode_constant_new ("NULL")));
							(_tmp44 == NULL) ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL));
							_tmp45 = NULL;
							vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp45 = vala_ccode_constant_new ("NULL")));
							(_tmp45 == NULL) ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL));
						}
						(type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL));
					}
					(type_arg_it == NULL) ? NULL : (type_arg_it = (gee_collection_object_unref (type_arg_it), NULL));
				}
			}
			carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
			ellipsis = FALSE;
			i = 1;
			arg_pos = 0;
			params_it = gee_iterable_iterator ((GeeIterable*) params);
			{
				GeeList* _tmp46;
				GeeIterator* _tmp47;
				GeeIterator* arg_it;
				_tmp46 = NULL;
				_tmp47 = NULL;
				arg_it = (_tmp47 = gee_iterable_iterator ((GeeIterable*) (_tmp46 = vala_object_creation_expression_get_argument_list (expr))), (_tmp46 == NULL) ? NULL : (_tmp46 = (gee_collection_object_unref (_tmp46), NULL)), _tmp47);
				while (gee_iterator_next (arg_it)) {
					ValaExpression* arg;
					ValaCCodeExpression* _tmp48;
					ValaCCodeExpression* cexpr;
					ValaFormalParameter* param;
					arg = (ValaExpression*) gee_iterator_get (arg_it);
					_tmp48 = NULL;
					cexpr = (_tmp48 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) arg)), (_tmp48 == NULL) ? NULL : vala_ccode_node_ref (_tmp48));
					param = NULL;
					if (gee_iterator_next (params_it)) {
						ValaFormalParameter* _tmp49;
						_tmp49 = NULL;
						param = (_tmp49 = (ValaFormalParameter*) gee_iterator_get (params_it), (param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL)), _tmp49);
						ellipsis = vala_formal_parameter_get_ellipsis (param);
						if (!ellipsis) {
							gboolean _tmp50;
							ValaCCodeExpression* _tmp55;
							_tmp50 = FALSE;
							if (!vala_formal_parameter_get_no_array_length (param)) {
								_tmp50 = VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param));
							} else {
								_tmp50 = FALSE;
							}
							if (_tmp50) {
								ValaArrayType* _tmp51;
								ValaArrayType* array_type;
								_tmp51 = NULL;
								array_type = (_tmp51 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp51 == NULL) ? NULL : vala_code_node_ref (_tmp51));
								{
									gint dim;
									dim = 1;
									for (; dim <= vala_array_type_get_rank (array_type); dim++) {
										ValaCCodeExpression* _tmp52;
										_tmp52 = NULL;
										gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (self, vala_formal_parameter_get_carray_length_parameter_position (param) + (0.01 * dim), FALSE)), _tmp52 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), arg, dim));
										(_tmp52 == NULL) ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL));
									}
								}
								(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
							} else {
								if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param))) {
									ValaDelegateType* _tmp53;
									ValaDelegateType* deleg_type;
									ValaDelegate* _tmp54;
									ValaDelegate* d;
									_tmp53 = NULL;
									deleg_type = (_tmp53 = VALA_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp53 == NULL) ? NULL : vala_code_node_ref (_tmp53));
									_tmp54 = NULL;
									d = (_tmp54 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp54 == NULL) ? NULL : vala_code_node_ref (_tmp54));
									if (vala_delegate_get_has_target (d)) {
										ValaCCodeExpression* delegate_target;
										delegate_target = vala_ccode_base_module_get_delegate_target_cexpression (self, arg);
										gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), delegate_target);
										(delegate_target == NULL) ? NULL : (delegate_target = (vala_ccode_node_unref (delegate_target), NULL));
									}
									(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
									(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
								}
							}
							_tmp55 = NULL;
							cexpr = (_tmp55 = vala_ccode_base_module_handle_struct_argument (self, param, arg, cexpr), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp55);
						}
						arg_pos = vala_ccode_base_module_get_param_pos (self, vala_formal_parameter_get_cparameter_position (param), ellipsis);
					} else {
						/* default argument position*/
						arg_pos = vala_ccode_base_module_get_param_pos (self, (double) i, ellipsis);
					}
					gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (arg_pos), cexpr);
					i++;
					(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
					(cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL));
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				}
				(arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL));
			}
			while (gee_iterator_next (params_it)) {
				ValaFormalParameter* param;
				param = (ValaFormalParameter*) gee_iterator_get (params_it);
				if (vala_formal_parameter_get_ellipsis (param)) {
					ellipsis = TRUE;
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
					break;
				}
				if (vala_formal_parameter_get_default_expression (param) == NULL) {
					char* _tmp56;
					_tmp56 = NULL;
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) expr), _tmp56 = g_strdup_printf ("no default expression for argument %d", i));
					_tmp56 = (g_free (_tmp56), NULL);
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
					(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
					(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
					(creation_call == NULL) ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL));
					(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
					(carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL));
					(params_it == NULL) ? NULL : (params_it = (gee_collection_object_unref (params_it), NULL));
					(instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL));
					(creation_expr == NULL) ? NULL : (creation_expr = (vala_ccode_node_unref (creation_expr), NULL));
					(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
					return;
				}
				/* evaluate default expression here as the code
				 * generator might not have visited the formal
				 * parameter yet */
				vala_code_node_accept ((ValaCodeNode*) vala_formal_parameter_get_default_expression (param), (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
				gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (self, vala_formal_parameter_get_cparameter_position (param), FALSE)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_formal_parameter_get_default_expression (param))));
				i++;
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
			}
			/* append C arguments in the right order*/
			last_pos = -1;
			min_pos = 0;
			while (TRUE) {
				ValaCCodeExpression* _tmp61;
				min_pos = -1;
				{
					GeeSet* _tmp57;
					GeeIterator* _tmp58;
					GeeIterator* pos_it;
					_tmp57 = NULL;
					_tmp58 = NULL;
					pos_it = (_tmp58 = gee_iterable_iterator ((GeeIterable*) (_tmp57 = gee_map_get_keys ((GeeMap*) carg_map))), (_tmp57 == NULL) ? NULL : (_tmp57 = (gee_collection_object_unref (_tmp57), NULL)), _tmp58);
					while (gee_iterator_next (pos_it)) {
						gint pos;
						gboolean _tmp59;
						pos = GPOINTER_TO_INT (gee_iterator_get (pos_it));
						_tmp59 = FALSE;
						if (pos > last_pos) {
							gboolean _tmp60;
							_tmp60 = FALSE;
							if (min_pos == (-1)) {
								_tmp60 = TRUE;
							} else {
								_tmp60 = pos < min_pos;
							}
							_tmp59 = (_tmp60);
						} else {
							_tmp59 = FALSE;
						}
						if (_tmp59) {
							min_pos = pos;
						}
					}
					(pos_it == NULL) ? NULL : (pos_it = (gee_collection_object_unref (pos_it), NULL));
				}
				if (min_pos == (-1)) {
					break;
				}
				_tmp61 = NULL;
				vala_ccode_function_call_add_argument (creation_call, _tmp61 = (ValaCCodeExpression*) gee_map_get ((GeeMap*) carg_map, GINT_TO_POINTER (min_pos)));
				(_tmp61 == NULL) ? NULL : (_tmp61 = (vala_ccode_node_unref (_tmp61), NULL));
				last_pos = min_pos;
			}
			_tmp62 = FALSE;
			_tmp63 = FALSE;
			if (st != NULL) {
				_tmp63 = !vala_struct_is_simple_type (st);
			} else {
				_tmp63 = FALSE;
			}
			if ((_tmp63)) {
				_tmp62 = vala_method_get_cinstance_parameter_position (m) < 0;
			} else {
				_tmp62 = FALSE;
			}
			if (_tmp62) {
				ValaCCodeUnaryExpression* _tmp64;
				/* instance parameter is at the end in a struct creation method*/
				_tmp64 = NULL;
				vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp64 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, instance)));
				(_tmp64 == NULL) ? NULL : (_tmp64 = (vala_ccode_node_unref (_tmp64), NULL));
			}
			if (vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr)) {
				ValaCCodeUnaryExpression* _tmp66;
				ValaCCodeIdentifier* _tmp65;
				/* method can fail*/
				self->current_method_inner_error = TRUE;
				_tmp66 = NULL;
				_tmp65 = NULL;
				vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp66 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp65 = vala_ccode_identifier_new ("inner_error")))));
				(_tmp66 == NULL) ? NULL : (_tmp66 = (vala_ccode_node_unref (_tmp66), NULL));
				(_tmp65 == NULL) ? NULL : (_tmp65 = (vala_ccode_node_unref (_tmp65), NULL));
			}
			if (ellipsis) {
				gboolean _tmp67;
				_tmp67 = FALSE;
				if (!vala_method_get_printf_format (m)) {
					_tmp67 = _vala_strcmp0 (vala_method_get_sentinel (m), "") != 0;
				} else {
					_tmp67 = FALSE;
				}
				/* ensure variable argument list ends with NULL
				 * except when using printf-style arguments */
				if (_tmp67) {
					ValaCCodeConstant* _tmp68;
					_tmp68 = NULL;
					vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp68 = vala_ccode_constant_new (vala_method_get_sentinel (m))));
					(_tmp68 == NULL) ? NULL : (_tmp68 = (vala_ccode_node_unref (_tmp68), NULL));
				}
			}
			_tmp70 = NULL;
			_tmp69 = NULL;
			creation_expr = (_tmp70 = (_tmp69 = (ValaCCodeExpression*) creation_call, (_tmp69 == NULL) ? NULL : vala_ccode_node_ref (_tmp69)), (creation_expr == NULL) ? NULL : (creation_expr = (vala_ccode_node_unref (creation_expr), NULL)), _tmp70);
			/* cast the return value of the creation method back to the intended type if
			 it requested a special C return type*/
			_tmp71 = NULL;
			if ((_tmp72 = (_tmp71 = vala_ccode_module_get_custom_creturn_type (vala_ccode_module_get_head ((ValaCCodeModule*) self), m)) != NULL, _tmp71 = (g_free (_tmp71), NULL), _tmp72)) {
				ValaCCodeExpression* _tmp74;
				char* _tmp73;
				_tmp74 = NULL;
				_tmp73 = NULL;
				creation_expr = (_tmp74 = (ValaCCodeExpression*) vala_ccode_cast_expression_new (creation_expr, _tmp73 = vala_data_type_get_cname (vala_object_creation_expression_get_type_reference (expr))), (creation_expr == NULL) ? NULL : (creation_expr = (vala_ccode_node_unref (creation_expr), NULL)), _tmp74);
				_tmp73 = (g_free (_tmp73), NULL);
			}
			(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
			(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
			(creation_call == NULL) ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL));
			(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
			(carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL));
			(params_it == NULL) ? NULL : (params_it = (gee_collection_object_unref (params_it), NULL));
		} else {
			if (VALA_IS_ERROR_CODE (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
				ValaErrorCode* _tmp75;
				ValaErrorCode* ecode;
				ValaErrorDomain* _tmp76;
				ValaErrorDomain* edomain;
				ValaCCodeFunctionCall* creation_call;
				ValaCCodeFunctionCall* _tmp78;
				ValaCCodeIdentifier* _tmp77;
				ValaCCodeIdentifier* _tmp80;
				char* _tmp79;
				ValaCCodeIdentifier* _tmp82;
				char* _tmp81;
				ValaCCodeExpression* _tmp86;
				ValaCCodeExpression* _tmp85;
				_tmp75 = NULL;
				ecode = (_tmp75 = VALA_ERROR_CODE (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp75 == NULL) ? NULL : vala_code_node_ref (_tmp75));
				_tmp76 = NULL;
				edomain = (_tmp76 = VALA_ERROR_DOMAIN (vala_symbol_get_parent_symbol ((ValaSymbol*) ecode)), (_tmp76 == NULL) ? NULL : vala_code_node_ref (_tmp76));
				creation_call = NULL;
				_tmp78 = NULL;
				_tmp77 = NULL;
				creation_call = (_tmp78 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp77 = vala_ccode_identifier_new ("g_error_new"))), (creation_call == NULL) ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL)), _tmp78);
				(_tmp77 == NULL) ? NULL : (_tmp77 = (vala_ccode_node_unref (_tmp77), NULL));
				_tmp80 = NULL;
				_tmp79 = NULL;
				vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp80 = vala_ccode_identifier_new (_tmp79 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) edomain, NULL))));
				(_tmp80 == NULL) ? NULL : (_tmp80 = (vala_ccode_node_unref (_tmp80), NULL));
				_tmp79 = (g_free (_tmp79), NULL);
				_tmp82 = NULL;
				_tmp81 = NULL;
				vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp82 = vala_ccode_identifier_new (_tmp81 = vala_typesymbol_get_cname ((ValaTypeSymbol*) ecode, FALSE))));
				(_tmp82 == NULL) ? NULL : (_tmp82 = (vala_ccode_node_unref (_tmp82), NULL));
				_tmp81 = (g_free (_tmp81), NULL);
				{
					GeeList* _tmp83;
					GeeIterator* _tmp84;
					GeeIterator* arg_it;
					_tmp83 = NULL;
					_tmp84 = NULL;
					arg_it = (_tmp84 = gee_iterable_iterator ((GeeIterable*) (_tmp83 = vala_object_creation_expression_get_argument_list (expr))), (_tmp83 == NULL) ? NULL : (_tmp83 = (gee_collection_object_unref (_tmp83), NULL)), _tmp84);
					while (gee_iterator_next (arg_it)) {
						ValaExpression* arg;
						arg = (ValaExpression*) gee_iterator_get (arg_it);
						vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) arg)));
						(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
					}
					(arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL));
				}
				_tmp86 = NULL;
				_tmp85 = NULL;
				creation_expr = (_tmp86 = (_tmp85 = (ValaCCodeExpression*) creation_call, (_tmp85 == NULL) ? NULL : vala_ccode_node_ref (_tmp85)), (creation_expr == NULL) ? NULL : (creation_expr = (vala_ccode_node_unref (creation_expr), NULL)), _tmp86);
				(ecode == NULL) ? NULL : (ecode = (vala_code_node_unref (ecode), NULL));
				(edomain == NULL) ? NULL : (edomain = (vala_code_node_unref (edomain), NULL));
				(creation_call == NULL) ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL));
			} else {
				g_assert (FALSE);
			}
		}
	}
	if (instance != NULL) {
		ValaCCodeCommaExpression* ccomma;
		ccomma = vala_ccode_comma_expression_new ();
		if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
			vala_ccode_comma_expression_append_expression (ccomma, creation_expr);
		} else {
			ValaCCodeAssignment* _tmp87;
			_tmp87 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp87 = vala_ccode_assignment_new (instance, creation_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
			(_tmp87 == NULL) ? NULL : (_tmp87 = (vala_ccode_node_unref (_tmp87), NULL));
		}
		{
			GeeList* _tmp88;
			GeeIterator* _tmp89;
			GeeIterator* init_it;
			_tmp88 = NULL;
			_tmp89 = NULL;
			init_it = (_tmp89 = gee_iterable_iterator ((GeeIterable*) (_tmp88 = vala_object_creation_expression_get_object_initializer (expr))), (_tmp88 == NULL) ? NULL : (_tmp88 = (gee_collection_object_unref (_tmp88), NULL)), _tmp89);
			while (gee_iterator_next (init_it)) {
				ValaMemberInitializer* init;
				init = (ValaMemberInitializer*) gee_iterator_get (init_it);
				if (VALA_IS_FIELD (vala_member_initializer_get_symbol_reference (init))) {
					ValaField* _tmp90;
					ValaField* f;
					ValaDataType* instance_target_type;
					ValaCCodeExpression* typed_inst;
					ValaCCodeExpression* lhs;
					ValaCCodeAssignment* _tmp95;
					_tmp90 = NULL;
					f = (_tmp90 = VALA_FIELD (vala_member_initializer_get_symbol_reference (init)), (_tmp90 == NULL) ? NULL : vala_code_node_ref (_tmp90));
					instance_target_type = vala_ccode_base_module_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) f)));
					typed_inst = vala_ccode_base_module_transform_expression (self, instance, vala_object_creation_expression_get_type_reference (expr), instance_target_type, NULL);
					lhs = NULL;
					if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
						ValaCCodeExpression* _tmp92;
						char* _tmp91;
						_tmp92 = NULL;
						_tmp91 = NULL;
						lhs = (_tmp92 = (ValaCCodeExpression*) vala_ccode_member_access_new (typed_inst, _tmp91 = vala_field_get_cname (f), FALSE), (lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL)), _tmp92);
						_tmp91 = (g_free (_tmp91), NULL);
					} else {
						ValaCCodeExpression* _tmp94;
						char* _tmp93;
						_tmp94 = NULL;
						_tmp93 = NULL;
						lhs = (_tmp94 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (typed_inst, _tmp93 = vala_field_get_cname (f)), (lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL)), _tmp94);
						_tmp93 = (g_free (_tmp93), NULL);
					}
					_tmp95 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp95 = vala_ccode_assignment_new (lhs, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_initializer_get_initializer (init))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
					(_tmp95 == NULL) ? NULL : (_tmp95 = (vala_ccode_node_unref (_tmp95), NULL));
					(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
					(instance_target_type == NULL) ? NULL : (instance_target_type = (vala_code_node_unref (instance_target_type), NULL));
					(typed_inst == NULL) ? NULL : (typed_inst = (vala_ccode_node_unref (typed_inst), NULL));
					(lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL));
				} else {
					if (VALA_IS_PROPERTY (vala_member_initializer_get_symbol_reference (init))) {
						ValaMemberAccess* inst_ma;
						ValaMemberAccess* ma;
						ValaCCodeFunctionCall* _tmp96;
						inst_ma = vala_member_access_new_simple ("new", NULL);
						vala_expression_set_value_type ((ValaExpression*) inst_ma, vala_object_creation_expression_get_type_reference (expr));
						vala_code_node_set_ccodenode ((ValaCodeNode*) inst_ma, (ValaCCodeNode*) instance);
						ma = vala_member_access_new ((ValaExpression*) inst_ma, vala_member_initializer_get_name (init), NULL);
						_tmp96 = NULL;
						vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp96 = vala_ccode_base_module_get_property_set_call (self, VALA_PROPERTY (vala_member_initializer_get_symbol_reference (init)), ma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_initializer_get_initializer (init))))));
						(_tmp96 == NULL) ? NULL : (_tmp96 = (vala_ccode_node_unref (_tmp96), NULL));
						(inst_ma == NULL) ? NULL : (inst_ma = (vala_code_node_unref (inst_ma), NULL));
						(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
					}
				}
				(init == NULL) ? NULL : (init = (vala_code_node_unref (init), NULL));
			}
			(init_it == NULL) ? NULL : (init_it = (gee_collection_object_unref (init_it), NULL));
		}
		vala_ccode_comma_expression_append_expression (ccomma, instance);
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccomma);
		(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
	} else {
		if (creation_expr != NULL) {
			vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) creation_expr);
		}
	}
	(instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL));
	(creation_expr == NULL) ? NULL : (creation_expr = (vala_ccode_node_unref (creation_expr), NULL));
	(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
}


ValaCCodeExpression* vala_ccode_base_module_handle_struct_argument (ValaCCodeBaseModule* self, ValaFormalParameter* param, ValaExpression* arg, ValaCCodeExpression* cexpr) {
	gboolean _tmp0;
	gboolean _tmp1;
	ValaCCodeExpression* _tmp15;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (param != NULL, NULL);
	g_return_val_if_fail (arg != NULL, NULL);
	_tmp0 = FALSE;
	_tmp1 = FALSE;
	if (!(VALA_IS_NULL_TYPE (vala_expression_get_value_type (arg)))) {
		_tmp1 = VALA_IS_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param)));
	} else {
		_tmp1 = FALSE;
	}
	if (_tmp1) {
		_tmp0 = !vala_struct_is_simple_type ((VALA_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param)))));
	} else {
		_tmp0 = FALSE;
	}
	/* pass non-simple struct instances always by reference*/
	if (_tmp0) {
		gboolean _tmp2;
		_tmp2 = FALSE;
		if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN) {
			_tmp2 = !vala_data_type_get_nullable (vala_formal_parameter_get_parameter_type (param));
		} else {
			_tmp2 = FALSE;
		}
		/* we already use a reference for arguments of ref, out, and nullable parameters*/
		if (_tmp2) {
			ValaCCodeUnaryExpression* _tmp4;
			ValaCCodeExpression* _tmp3;
			ValaCCodeUnaryExpression* unary;
			gboolean _tmp5;
			_tmp4 = NULL;
			_tmp3 = NULL;
			unary = (_tmp4 = (_tmp3 = cexpr, VALA_IS_CCODE_UNARY_EXPRESSION (_tmp3) ? ((ValaCCodeUnaryExpression*) _tmp3) : NULL), (_tmp4 == NULL) ? NULL : vala_ccode_node_ref (_tmp4));
			_tmp5 = FALSE;
			if (unary != NULL) {
				_tmp5 = vala_ccode_unary_expression_get_operator (unary) == VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION;
			} else {
				_tmp5 = FALSE;
			}
			if (_tmp5) {
				ValaCCodeExpression* _tmp6;
				ValaCCodeExpression* _tmp7;
				/* *expr => expr*/
				_tmp6 = NULL;
				_tmp7 = NULL;
				return (_tmp7 = (_tmp6 = vala_ccode_unary_expression_get_inner (unary), (_tmp6 == NULL) ? NULL : vala_ccode_node_ref (_tmp6)), (unary == NULL) ? NULL : (unary = (vala_ccode_node_unref (unary), NULL)), _tmp7);
			} else {
				gboolean _tmp8;
				_tmp8 = FALSE;
				if (VALA_IS_CCODE_IDENTIFIER (cexpr)) {
					_tmp8 = TRUE;
				} else {
					_tmp8 = VALA_IS_CCODE_MEMBER_ACCESS (cexpr);
				}
				if (_tmp8) {
					ValaCCodeExpression* _tmp9;
					_tmp9 = NULL;
					return (_tmp9 = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, cexpr), (unary == NULL) ? NULL : (unary = (vala_ccode_node_unref (unary), NULL)), _tmp9);
				} else {
					ValaCCodeCommaExpression* ccomma;
					ValaLocalVariable* temp_var;
					ValaCCodeAssignment* _tmp11;
					ValaCCodeIdentifier* _tmp10;
					ValaCCodeUnaryExpression* _tmp13;
					ValaCCodeIdentifier* _tmp12;
					ValaCCodeExpression* _tmp14;
					/* if cexpr is e.g. a function call, we can't take the address of the expression
					 (tmp = expr, &tmp)*/
					ccomma = vala_ccode_comma_expression_new ();
					temp_var = vala_ccode_base_module_get_temp_variable (self, vala_expression_get_value_type (arg), TRUE, NULL);
					gee_list_insert ((GeeList*) self->temp_vars, 0, temp_var);
					_tmp11 = NULL;
					_tmp10 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp11 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp10 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var))), cexpr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
					(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
					(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
					_tmp13 = NULL;
					_tmp12 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp13 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp12 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var))))));
					(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
					(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
					_tmp14 = NULL;
					return (_tmp14 = (ValaCCodeExpression*) ccomma, (temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL)), (unary == NULL) ? NULL : (unary = (vala_ccode_node_unref (unary), NULL)), _tmp14);
				}
			}
			(unary == NULL) ? NULL : (unary = (vala_ccode_node_unref (unary), NULL));
		}
	}
	_tmp15 = NULL;
	return (_tmp15 = cexpr, (_tmp15 == NULL) ? NULL : vala_ccode_node_ref (_tmp15));
}


static void vala_ccode_base_module_real_visit_sizeof_expression (ValaCCodeModule* base, ValaSizeofExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* csizeof;
	ValaCCodeIdentifier* _tmp3;
	char* _tmp2;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	csizeof = (_tmp1 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0 = vala_ccode_identifier_new ("sizeof"))), (_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)), _tmp1);
	_tmp3 = NULL;
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (csizeof, (ValaCCodeExpression*) (_tmp3 = vala_ccode_identifier_new (_tmp2 = vala_data_type_get_cname (vala_sizeof_expression_get_type_reference (expr)))));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	_tmp2 = (g_free (_tmp2), NULL);
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) csizeof);
	(csizeof == NULL) ? NULL : (csizeof = (vala_ccode_node_unref (csizeof), NULL));
}


static void vala_ccode_base_module_real_visit_typeof_expression (ValaCCodeModule* base, ValaTypeofExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeExpression* _tmp0;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp0 = vala_ccode_base_module_get_type_id_expression (self, vala_typeof_expression_get_type_reference (expr))));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
}


static void vala_ccode_base_module_real_visit_unary_expression (ValaCCodeModule* base, ValaUnaryExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeUnaryOperator op;
	ValaCCodeUnaryExpression* _tmp0;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	op = 0;
	if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_PLUS) {
		op = VALA_CCODE_UNARY_OPERATOR_PLUS;
	} else {
		if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_MINUS) {
			op = VALA_CCODE_UNARY_OPERATOR_MINUS;
		} else {
			if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_LOGICAL_NEGATION) {
				op = VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION;
			} else {
				if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT) {
					op = VALA_CCODE_UNARY_OPERATOR_BITWISE_COMPLEMENT;
				} else {
					if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_INCREMENT) {
						op = VALA_CCODE_UNARY_OPERATOR_PREFIX_INCREMENT;
					} else {
						if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_DECREMENT) {
							op = VALA_CCODE_UNARY_OPERATOR_PREFIX_DECREMENT;
						} else {
							if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_REF) {
								op = VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF;
							} else {
								if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_OUT) {
									op = VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF;
								} else {
									g_assert_not_reached ();
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp0 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp0 = vala_ccode_unary_expression_new (op, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_unary_expression_get_inner (expr))))));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
}


static void vala_ccode_base_module_real_visit_cast_expression (ValaCCodeModule* base, ValaCastExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaClass* _tmp1;
	ValaTypeSymbol* _tmp0;
	ValaClass* cl;
	ValaInterface* _tmp3;
	ValaTypeSymbol* _tmp2;
	ValaInterface* iface;
	gboolean _tmp4;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	cl = (_tmp1 = (_tmp0 = vala_data_type_get_data_type (vala_cast_expression_get_type_reference (expr)), VALA_IS_CLASS (_tmp0) ? ((ValaClass*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp3 = NULL;
	_tmp2 = NULL;
	iface = (_tmp3 = (_tmp2 = vala_data_type_get_data_type (vala_cast_expression_get_type_reference (expr)), VALA_IS_INTERFACE (_tmp2) ? ((ValaInterface*) _tmp2) : NULL), (_tmp3 == NULL) ? NULL : vala_code_node_ref (_tmp3));
	_tmp4 = FALSE;
	if (iface != NULL) {
		_tmp4 = TRUE;
	} else {
		gboolean _tmp5;
		_tmp5 = FALSE;
		if (cl != NULL) {
			_tmp5 = !vala_class_get_is_compact (cl);
		} else {
			_tmp5 = FALSE;
		}
		_tmp4 = (_tmp5);
	}
	if (_tmp4) {
		/* checked cast for strict subtypes of GTypeInstance*/
		if (vala_cast_expression_get_is_silent_cast (expr)) {
			ValaCCodeCommaExpression* ccomma;
			ValaLocalVariable* temp_decl;
			ValaCCodeIdentifier* ctemp;
			ValaCCodeAssignment* cinit;
			ValaCCodeExpression* ccheck;
			char* _tmp6;
			ValaCCodeCastExpression* _tmp7;
			ValaCCodeCastExpression* ccast;
			ValaCCodeConstant* cnull;
			ValaCCodeConditionalExpression* _tmp8;
			ccomma = vala_ccode_comma_expression_new ();
			temp_decl = vala_ccode_base_module_get_temp_variable (self, vala_expression_get_value_type (vala_cast_expression_get_inner (expr)), TRUE, (ValaCodeNode*) expr);
			gee_collection_add ((GeeCollection*) self->temp_vars, temp_decl);
			ctemp = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_decl));
			cinit = vala_ccode_assignment_new ((ValaCCodeExpression*) ctemp, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_cast_expression_get_inner (expr))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			ccheck = vala_ccode_base_module_create_type_check (self, (ValaCCodeNode*) ctemp, vala_cast_expression_get_type_reference (expr));
			_tmp6 = NULL;
			_tmp7 = NULL;
			ccast = (_tmp7 = vala_ccode_cast_expression_new ((ValaCCodeExpression*) ctemp, _tmp6 = vala_data_type_get_cname (vala_cast_expression_get_type_reference (expr))), _tmp6 = (g_free (_tmp6), NULL), _tmp7);
			cnull = vala_ccode_constant_new ("NULL");
			vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) cinit);
			_tmp8 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp8 = vala_ccode_conditional_expression_new (ccheck, (ValaCCodeExpression*) ccast, (ValaCCodeExpression*) cnull)));
			(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
			vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccomma);
			(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
			(temp_decl == NULL) ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL));
			(ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL));
			(cinit == NULL) ? NULL : (cinit = (vala_ccode_node_unref (cinit), NULL));
			(ccheck == NULL) ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL));
			(ccast == NULL) ? NULL : (ccast = (vala_ccode_node_unref (ccast), NULL));
			(cnull == NULL) ? NULL : (cnull = (vala_ccode_node_unref (cnull), NULL));
		} else {
			ValaInstanceCast* _tmp9;
			_tmp9 = NULL;
			vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp9 = vala_instance_cast_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_cast_expression_get_inner (expr))), vala_data_type_get_data_type (vala_cast_expression_get_type_reference (expr)))));
			(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
		}
	} else {
		ValaCCodeCastExpression* _tmp11;
		char* _tmp10;
		if (vala_cast_expression_get_is_silent_cast (expr)) {
			vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) expr), "Operation not supported for this type");
			(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
			(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
			return;
		}
		_tmp11 = NULL;
		_tmp10 = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp11 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_cast_expression_get_inner (expr))), _tmp10 = vala_data_type_get_cname (vala_cast_expression_get_type_reference (expr)))));
		(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
		_tmp10 = (g_free (_tmp10), NULL);
	}
	(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
}


static void vala_ccode_base_module_real_visit_pointer_indirection (ValaCCodeModule* base, ValaPointerIndirection* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeUnaryExpression* _tmp0;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp0 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_pointer_indirection_get_inner (expr))))));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
}


static void vala_ccode_base_module_real_visit_addressof_expression (ValaCCodeModule* base, ValaAddressofExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeUnaryExpression* _tmp0;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp0 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_addressof_expression_get_inner (expr))))));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
}


static void vala_ccode_base_module_real_visit_reference_transfer_expression (ValaCCodeModule* base, ValaReferenceTransferExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeCommaExpression* ccomma;
	ValaLocalVariable* temp_decl;
	ValaCCodeIdentifier* cvar;
	ValaCCodeAssignment* _tmp0;
	ValaCCodeAssignment* _tmp2;
	ValaCCodeConstant* _tmp1;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	/* (tmp = var, var = null, tmp) */
	ccomma = vala_ccode_comma_expression_new ();
	temp_decl = vala_ccode_base_module_get_temp_variable (self, vala_expression_get_value_type ((ValaExpression*) expr), TRUE, (ValaCodeNode*) expr);
	gee_list_insert ((GeeList*) self->temp_vars, 0, temp_decl);
	cvar = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_decl));
	_tmp0 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp0 = vala_ccode_assignment_new ((ValaCCodeExpression*) cvar, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_reference_transfer_expression_get_inner (expr))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	_tmp2 = NULL;
	_tmp1 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp2 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_reference_transfer_expression_get_inner (expr))), (ValaCCodeExpression*) (_tmp1 = vala_ccode_constant_new ("NULL")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
	vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) cvar);
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccomma);
	(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
	(temp_decl == NULL) ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL));
	(cvar == NULL) ? NULL : (cvar = (vala_ccode_node_unref (cvar), NULL));
}


static void vala_ccode_base_module_real_visit_binary_expression (ValaCCodeModule* base, ValaBinaryExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeExpression* _tmp0;
	ValaCCodeExpression* cleft;
	ValaCCodeExpression* _tmp1;
	ValaCCodeExpression* cright;
	ValaCCodeBinaryOperator op;
	gboolean _tmp4;
	gboolean _tmp20;
	gboolean _tmp21;
	gboolean _tmp22;
	ValaCCodeBinaryExpression* _tmp47;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	_tmp0 = NULL;
	cleft = (_tmp0 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_binary_expression_get_left (expr))), (_tmp0 == NULL) ? NULL : vala_ccode_node_ref (_tmp0));
	_tmp1 = NULL;
	cright = (_tmp1 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_binary_expression_get_right (expr))), (_tmp1 == NULL) ? NULL : vala_ccode_node_ref (_tmp1));
	op = 0;
	if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_PLUS) {
		op = VALA_CCODE_BINARY_OPERATOR_PLUS;
	} else {
		if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_MINUS) {
			op = VALA_CCODE_BINARY_OPERATOR_MINUS;
		} else {
			if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_MUL) {
				op = VALA_CCODE_BINARY_OPERATOR_MUL;
			} else {
				if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_DIV) {
					op = VALA_CCODE_BINARY_OPERATOR_DIV;
				} else {
					if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_MOD) {
						op = VALA_CCODE_BINARY_OPERATOR_MOD;
					} else {
						if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_SHIFT_LEFT) {
							op = VALA_CCODE_BINARY_OPERATOR_SHIFT_LEFT;
						} else {
							if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_SHIFT_RIGHT) {
								op = VALA_CCODE_BINARY_OPERATOR_SHIFT_RIGHT;
							} else {
								if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_LESS_THAN) {
									op = VALA_CCODE_BINARY_OPERATOR_LESS_THAN;
								} else {
									if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_GREATER_THAN) {
										op = VALA_CCODE_BINARY_OPERATOR_GREATER_THAN;
									} else {
										if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL) {
											op = VALA_CCODE_BINARY_OPERATOR_LESS_THAN_OR_EQUAL;
										} else {
											if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL) {
												op = VALA_CCODE_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL;
											} else {
												if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_EQUALITY) {
													op = VALA_CCODE_BINARY_OPERATOR_EQUALITY;
												} else {
													if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_INEQUALITY) {
														op = VALA_CCODE_BINARY_OPERATOR_INEQUALITY;
													} else {
														if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_BITWISE_AND) {
															op = VALA_CCODE_BINARY_OPERATOR_BITWISE_AND;
														} else {
															if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_BITWISE_OR) {
																op = VALA_CCODE_BINARY_OPERATOR_BITWISE_OR;
															} else {
																if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_BITWISE_XOR) {
																	op = VALA_CCODE_BINARY_OPERATOR_BITWISE_XOR;
																} else {
																	if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_AND) {
																		op = VALA_CCODE_BINARY_OPERATOR_AND;
																	} else {
																		if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_OR) {
																			op = VALA_CCODE_BINARY_OPERATOR_OR;
																		} else {
																			if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_IN) {
																				ValaCCodeBinaryExpression* _tmp3;
																				ValaCCodeBinaryExpression* _tmp2;
																				_tmp3 = NULL;
																				_tmp2 = NULL;
																				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp3 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) (_tmp2 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_BITWISE_AND, cright, cleft)), cleft)));
																				(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
																				(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
																				(cleft == NULL) ? NULL : (cleft = (vala_ccode_node_unref (cleft), NULL));
																				(cright == NULL) ? NULL : (cright = (vala_ccode_node_unref (cright), NULL));
																				return;
																			} else {
																				g_assert_not_reached ();
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp4 = FALSE;
	if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_EQUALITY) {
		_tmp4 = TRUE;
	} else {
		_tmp4 = vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_INEQUALITY;
	}
	if (_tmp4) {
		ValaStruct* _tmp6;
		ValaTypeSymbol* _tmp5;
		ValaStruct* left_type_as_struct;
		ValaStruct* _tmp8;
		ValaTypeSymbol* _tmp7;
		ValaStruct* right_type_as_struct;
		gboolean _tmp9;
		gboolean _tmp10;
		gboolean _tmp11;
		_tmp6 = NULL;
		_tmp5 = NULL;
		left_type_as_struct = (_tmp6 = (_tmp5 = vala_data_type_get_data_type (vala_expression_get_value_type (vala_binary_expression_get_left (expr))), VALA_IS_STRUCT (_tmp5) ? ((ValaStruct*) _tmp5) : NULL), (_tmp6 == NULL) ? NULL : vala_code_node_ref (_tmp6));
		_tmp8 = NULL;
		_tmp7 = NULL;
		right_type_as_struct = (_tmp8 = (_tmp7 = vala_data_type_get_data_type (vala_expression_get_value_type (vala_binary_expression_get_right (expr))), VALA_IS_STRUCT (_tmp7) ? ((ValaStruct*) _tmp7) : NULL), (_tmp8 == NULL) ? NULL : vala_code_node_ref (_tmp8));
		_tmp9 = FALSE;
		_tmp10 = FALSE;
		_tmp11 = FALSE;
		if (VALA_IS_CLASS (vala_data_type_get_data_type (vala_expression_get_value_type (vala_binary_expression_get_left (expr))))) {
			_tmp11 = !vala_class_get_is_compact ((VALA_CLASS (vala_data_type_get_data_type (vala_expression_get_value_type (vala_binary_expression_get_left (expr))))));
		} else {
			_tmp11 = FALSE;
		}
		if (_tmp11) {
			_tmp10 = VALA_IS_CLASS (vala_data_type_get_data_type (vala_expression_get_value_type (vala_binary_expression_get_right (expr))));
		} else {
			_tmp10 = FALSE;
		}
		if (_tmp10) {
			_tmp9 = !vala_class_get_is_compact ((VALA_CLASS (vala_data_type_get_data_type (vala_expression_get_value_type (vala_binary_expression_get_right (expr))))));
		} else {
			_tmp9 = FALSE;
		}
		if (_tmp9) {
			ValaClass* _tmp12;
			ValaClass* left_cl;
			ValaClass* _tmp13;
			ValaClass* right_cl;
			_tmp12 = NULL;
			left_cl = (_tmp12 = VALA_CLASS (vala_data_type_get_data_type (vala_expression_get_value_type (vala_binary_expression_get_left (expr)))), (_tmp12 == NULL) ? NULL : vala_code_node_ref (_tmp12));
			_tmp13 = NULL;
			right_cl = (_tmp13 = VALA_CLASS (vala_data_type_get_data_type (vala_expression_get_value_type (vala_binary_expression_get_right (expr)))), (_tmp13 == NULL) ? NULL : vala_code_node_ref (_tmp13));
			if (left_cl != right_cl) {
				if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) left_cl, (ValaTypeSymbol*) right_cl)) {
					ValaCCodeExpression* _tmp14;
					_tmp14 = NULL;
					cleft = (_tmp14 = (ValaCCodeExpression*) vala_instance_cast_new (cleft, (ValaTypeSymbol*) right_cl), (cleft == NULL) ? NULL : (cleft = (vala_ccode_node_unref (cleft), NULL)), _tmp14);
				} else {
					if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) right_cl, (ValaTypeSymbol*) left_cl)) {
						ValaCCodeExpression* _tmp15;
						_tmp15 = NULL;
						cright = (_tmp15 = (ValaCCodeExpression*) vala_instance_cast_new (cright, (ValaTypeSymbol*) left_cl), (cright == NULL) ? NULL : (cright = (vala_ccode_node_unref (cright), NULL)), _tmp15);
					}
				}
			}
			(left_cl == NULL) ? NULL : (left_cl = (vala_code_node_unref (left_cl), NULL));
			(right_cl == NULL) ? NULL : (right_cl = (vala_code_node_unref (right_cl), NULL));
		} else {
			gboolean _tmp16;
			_tmp16 = FALSE;
			if (left_type_as_struct != NULL) {
				_tmp16 = VALA_IS_NULL_TYPE (vala_expression_get_value_type (vala_binary_expression_get_right (expr)));
			} else {
				_tmp16 = FALSE;
			}
			if (_tmp16) {
				ValaCCodeExpression* _tmp17;
				_tmp17 = NULL;
				cleft = (_tmp17 = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, cleft), (cleft == NULL) ? NULL : (cleft = (vala_ccode_node_unref (cleft), NULL)), _tmp17);
			} else {
				gboolean _tmp18;
				_tmp18 = FALSE;
				if (right_type_as_struct != NULL) {
					_tmp18 = VALA_IS_NULL_TYPE (vala_expression_get_value_type (vala_binary_expression_get_left (expr)));
				} else {
					_tmp18 = FALSE;
				}
				if (_tmp18) {
					ValaCCodeExpression* _tmp19;
					_tmp19 = NULL;
					cright = (_tmp19 = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, cright), (cright == NULL) ? NULL : (cright = (vala_ccode_node_unref (cright), NULL)), _tmp19);
				}
			}
		}
		(left_type_as_struct == NULL) ? NULL : (left_type_as_struct = (vala_code_node_unref (left_type_as_struct), NULL));
		(right_type_as_struct == NULL) ? NULL : (right_type_as_struct = (vala_code_node_unref (right_type_as_struct), NULL));
	}
	_tmp20 = FALSE;
	_tmp21 = FALSE;
	_tmp22 = FALSE;
	if (!(VALA_IS_NULL_TYPE (vala_expression_get_value_type (vala_binary_expression_get_left (expr))))) {
		_tmp22 = vala_data_type_compatible (vala_expression_get_value_type (vala_binary_expression_get_left (expr)), self->string_type);
	} else {
		_tmp22 = FALSE;
	}
	if (_tmp22) {
		_tmp21 = !(VALA_IS_NULL_TYPE (vala_expression_get_value_type (vala_binary_expression_get_right (expr))));
	} else {
		_tmp21 = FALSE;
	}
	if (_tmp21) {
		_tmp20 = vala_data_type_compatible (vala_expression_get_value_type (vala_binary_expression_get_right (expr)), self->string_type);
	} else {
		_tmp20 = FALSE;
	}
	if (_tmp20) {
		if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_PLUS) {
			gboolean _tmp23;
			_tmp23 = FALSE;
			if (vala_expression_is_constant (vala_binary_expression_get_left (expr))) {
				_tmp23 = vala_expression_is_constant (vala_binary_expression_get_right (expr));
			} else {
				_tmp23 = FALSE;
			}
			/* string concatenation*/
			if (_tmp23) {
				char* left;
				char* right;
				ValaCCodeConstant* _tmp33;
				char* _tmp32;
				left = NULL;
				right = NULL;
				if (VALA_IS_CCODE_IDENTIFIER (cleft)) {
					char* _tmp25;
					const char* _tmp24;
					_tmp25 = NULL;
					_tmp24 = NULL;
					left = (_tmp25 = (_tmp24 = vala_ccode_identifier_get_name ((VALA_CCODE_IDENTIFIER (cleft))), (_tmp24 == NULL) ? NULL : g_strdup (_tmp24)), left = (g_free (left), NULL), _tmp25);
				} else {
					if (VALA_IS_CCODE_CONSTANT (cleft)) {
						char* _tmp27;
						const char* _tmp26;
						_tmp27 = NULL;
						_tmp26 = NULL;
						left = (_tmp27 = (_tmp26 = vala_ccode_constant_get_name ((VALA_CCODE_CONSTANT (cleft))), (_tmp26 == NULL) ? NULL : g_strdup (_tmp26)), left = (g_free (left), NULL), _tmp27);
					} else {
						g_assert_not_reached ();
					}
				}
				if (VALA_IS_CCODE_IDENTIFIER (cright)) {
					char* _tmp29;
					const char* _tmp28;
					_tmp29 = NULL;
					_tmp28 = NULL;
					right = (_tmp29 = (_tmp28 = vala_ccode_identifier_get_name ((VALA_CCODE_IDENTIFIER (cright))), (_tmp28 == NULL) ? NULL : g_strdup (_tmp28)), right = (g_free (right), NULL), _tmp29);
				} else {
					if (VALA_IS_CCODE_CONSTANT (cright)) {
						char* _tmp31;
						const char* _tmp30;
						_tmp31 = NULL;
						_tmp30 = NULL;
						right = (_tmp31 = (_tmp30 = vala_ccode_constant_get_name ((VALA_CCODE_CONSTANT (cright))), (_tmp30 == NULL) ? NULL : g_strdup (_tmp30)), right = (g_free (right), NULL), _tmp31);
					} else {
						g_assert_not_reached ();
					}
				}
				_tmp33 = NULL;
				_tmp32 = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp33 = vala_ccode_constant_new (_tmp32 = g_strdup_printf ("%s %s", left, right))));
				(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
				_tmp32 = (g_free (_tmp32), NULL);
				left = (g_free (left), NULL);
				right = (g_free (right), NULL);
				(cleft == NULL) ? NULL : (cleft = (vala_ccode_node_unref (cleft), NULL));
				(cright == NULL) ? NULL : (cright = (vala_ccode_node_unref (cright), NULL));
				return;
			} else {
				ValaCCodeIdentifier* _tmp34;
				ValaCCodeFunctionCall* _tmp35;
				ValaCCodeFunctionCall* ccall;
				ValaCCodeConstant* _tmp36;
				/* convert to g_strconcat (a, b, NULL)*/
				_tmp34 = NULL;
				_tmp35 = NULL;
				ccall = (_tmp35 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp34 = vala_ccode_identifier_new ("g_strconcat"))), (_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL)), _tmp35);
				vala_ccode_function_call_add_argument (ccall, cleft);
				vala_ccode_function_call_add_argument (ccall, cright);
				_tmp36 = NULL;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp36 = vala_ccode_constant_new ("NULL")));
				(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall);
				(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
				(cleft == NULL) ? NULL : (cleft = (vala_ccode_node_unref (cleft), NULL));
				(cright == NULL) ? NULL : (cright = (vala_ccode_node_unref (cright), NULL));
				return;
			}
		} else {
			gboolean _tmp37;
			gboolean _tmp38;
			gboolean _tmp39;
			gboolean _tmp40;
			gboolean _tmp41;
			_tmp37 = FALSE;
			_tmp38 = FALSE;
			_tmp39 = FALSE;
			_tmp40 = FALSE;
			_tmp41 = FALSE;
			if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_EQUALITY) {
				_tmp41 = TRUE;
			} else {
				_tmp41 = vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_INEQUALITY;
			}
			if (_tmp41) {
				_tmp40 = TRUE;
			} else {
				_tmp40 = vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_LESS_THAN;
			}
			if (_tmp40) {
				_tmp39 = TRUE;
			} else {
				_tmp39 = vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_GREATER_THAN;
			}
			if (_tmp39) {
				_tmp38 = TRUE;
			} else {
				_tmp38 = vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL;
			}
			if (_tmp38) {
				_tmp37 = TRUE;
			} else {
				_tmp37 = vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL;
			}
			if (_tmp37) {
				ValaCCodeIdentifier* _tmp42;
				ValaCCodeFunctionCall* _tmp43;
				ValaCCodeFunctionCall* ccall;
				ValaCCodeExpression* _tmp45;
				ValaCCodeExpression* _tmp44;
				ValaCCodeExpression* _tmp46;
				self->requires_strcmp0 = TRUE;
				_tmp42 = NULL;
				_tmp43 = NULL;
				ccall = (_tmp43 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp42 = vala_ccode_identifier_new ("_vala_strcmp0"))), (_tmp42 == NULL) ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL)), _tmp43);
				vala_ccode_function_call_add_argument (ccall, cleft);
				vala_ccode_function_call_add_argument (ccall, cright);
				_tmp45 = NULL;
				_tmp44 = NULL;
				cleft = (_tmp45 = (_tmp44 = (ValaCCodeExpression*) ccall, (_tmp44 == NULL) ? NULL : vala_ccode_node_ref (_tmp44)), (cleft == NULL) ? NULL : (cleft = (vala_ccode_node_unref (cleft), NULL)), _tmp45);
				_tmp46 = NULL;
				cright = (_tmp46 = (ValaCCodeExpression*) vala_ccode_constant_new ("0"), (cright == NULL) ? NULL : (cright = (vala_ccode_node_unref (cright), NULL)), _tmp46);
				(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
			}
		}
	}
	_tmp47 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp47 = vala_ccode_binary_expression_new (op, cleft, cright)));
	(_tmp47 == NULL) ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL));
	(cleft == NULL) ? NULL : (cleft = (vala_ccode_node_unref (cleft), NULL));
	(cright == NULL) ? NULL : (cright = (vala_ccode_node_unref (cright), NULL));
}


char* vala_ccode_base_module_get_type_check_function (ValaCCodeBaseModule* self, ValaTypeSymbol* type) {
	ValaClass* _tmp1;
	ValaTypeSymbol* _tmp0;
	ValaClass* cl;
	gboolean _tmp2;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	cl = (_tmp1 = (_tmp0 = type, VALA_IS_CLASS (_tmp0) ? ((ValaClass*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp2 = FALSE;
	if (cl != NULL) {
		_tmp2 = vala_class_get_type_check_function (cl) != NULL;
	} else {
		_tmp2 = FALSE;
	}
	if (_tmp2) {
		const char* _tmp3;
		char* _tmp4;
		_tmp3 = NULL;
		_tmp4 = NULL;
		return (_tmp4 = (_tmp3 = vala_class_get_type_check_function (cl), (_tmp3 == NULL) ? NULL : g_strdup (_tmp3)), (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), _tmp4);
	} else {
		char* _tmp5;
		_tmp5 = NULL;
		return (_tmp5 = vala_typesymbol_get_upper_case_cname (type, "IS_"), (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), _tmp5);
	}
	(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
}


static ValaCCodeExpression* vala_ccode_base_module_create_type_check (ValaCCodeBaseModule* self, ValaCCodeNode* ccodenode, ValaDataType* type) {
	ValaErrorType* _tmp1;
	ValaDataType* _tmp0;
	ValaErrorType* et;
	gboolean _tmp2;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (ccodenode != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	et = (_tmp1 = (_tmp0 = type, VALA_IS_ERROR_TYPE (_tmp0) ? ((ValaErrorType*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp2 = FALSE;
	if (et != NULL) {
		_tmp2 = vala_error_type_get_error_code (et) != NULL;
	} else {
		_tmp2 = FALSE;
	}
	if (_tmp2) {
		ValaCCodeIdentifier* _tmp3;
		ValaCCodeFunctionCall* _tmp4;
		ValaCCodeFunctionCall* matches_call;
		ValaCCodeIdentifier* _tmp6;
		char* _tmp5;
		ValaCCodeIdentifier* _tmp8;
		char* _tmp7;
		ValaCCodeExpression* _tmp9;
		_tmp3 = NULL;
		_tmp4 = NULL;
		matches_call = (_tmp4 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp3 = vala_ccode_identifier_new ("g_error_matches"))), (_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)), _tmp4);
		vala_ccode_function_call_add_argument (matches_call, VALA_CCODE_EXPRESSION (ccodenode));
		_tmp6 = NULL;
		_tmp5 = NULL;
		vala_ccode_function_call_add_argument (matches_call, (ValaCCodeExpression*) (_tmp6 = vala_ccode_identifier_new (_tmp5 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) vala_error_type_get_error_domain (et), NULL))));
		(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
		_tmp5 = (g_free (_tmp5), NULL);
		_tmp8 = NULL;
		_tmp7 = NULL;
		vala_ccode_function_call_add_argument (matches_call, (ValaCCodeExpression*) (_tmp8 = vala_ccode_identifier_new (_tmp7 = vala_typesymbol_get_cname ((ValaTypeSymbol*) vala_error_type_get_error_code (et), FALSE))));
		(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
		_tmp7 = (g_free (_tmp7), NULL);
		_tmp9 = NULL;
		return (_tmp9 = (ValaCCodeExpression*) matches_call, (et == NULL) ? NULL : (et = (vala_code_node_unref (et), NULL)), _tmp9);
	} else {
		gboolean _tmp10;
		_tmp10 = FALSE;
		if (et != NULL) {
			_tmp10 = vala_error_type_get_error_domain (et) != NULL;
		} else {
			_tmp10 = FALSE;
		}
		if (_tmp10) {
			ValaCCodeMemberAccess* instance_domain;
			char* _tmp11;
			ValaCCodeIdentifier* _tmp12;
			ValaCCodeIdentifier* type_domain;
			ValaCCodeExpression* _tmp13;
			instance_domain = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccodenode), "domain");
			_tmp11 = NULL;
			_tmp12 = NULL;
			type_domain = (_tmp12 = vala_ccode_identifier_new (_tmp11 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) vala_error_type_get_error_domain (et), NULL)), _tmp11 = (g_free (_tmp11), NULL), _tmp12);
			_tmp13 = NULL;
			return (_tmp13 = (ValaCCodeExpression*) vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) instance_domain, (ValaCCodeExpression*) type_domain), (instance_domain == NULL) ? NULL : (instance_domain = (vala_ccode_node_unref (instance_domain), NULL)), (type_domain == NULL) ? NULL : (type_domain = (vala_ccode_node_unref (type_domain), NULL)), (et == NULL) ? NULL : (et = (vala_code_node_unref (et), NULL)), _tmp13);
		} else {
			ValaCCodeIdentifier* _tmp15;
			char* _tmp14;
			ValaCCodeFunctionCall* _tmp16;
			ValaCCodeFunctionCall* ccheck;
			ValaCCodeExpression* _tmp17;
			_tmp15 = NULL;
			_tmp14 = NULL;
			_tmp16 = NULL;
			ccheck = (_tmp16 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp15 = vala_ccode_identifier_new (_tmp14 = vala_ccode_base_module_get_type_check_function (self, vala_data_type_get_data_type (type))))), (_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)), _tmp14 = (g_free (_tmp14), NULL), _tmp16);
			vala_ccode_function_call_add_argument (ccheck, VALA_CCODE_EXPRESSION (ccodenode));
			_tmp17 = NULL;
			return (_tmp17 = (ValaCCodeExpression*) ccheck, (et == NULL) ? NULL : (et = (vala_code_node_unref (et), NULL)), _tmp17);
		}
	}
	(et == NULL) ? NULL : (et = (vala_code_node_unref (et), NULL));
}


static void vala_ccode_base_module_real_visit_type_check (ValaCCodeModule* base, ValaTypeCheck* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeExpression* _tmp0;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp0 = vala_ccode_base_module_create_type_check (self, vala_code_node_get_ccodenode ((ValaCodeNode*) vala_typecheck_get_expression (expr)), vala_typecheck_get_type_reference (expr))));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
}


static void vala_ccode_base_module_real_visit_lambda_expression (ValaCCodeModule* base, ValaLambdaExpression* l) {
	ValaCCodeBaseModule * self;
	ValaDelegateType* _tmp0;
	ValaDelegateType* dt;
	GeeArrayList* _tmp1;
	GeeArrayList* old_temp_vars;
	GeeArrayList* _tmp2;
	GeeArrayList* old_temp_ref_vars;
	GeeArrayList* _tmp3;
	GeeArrayList* _tmp4;
	GeeArrayList* _tmp6;
	GeeArrayList* _tmp5;
	GeeArrayList* _tmp8;
	GeeArrayList* _tmp7;
	ValaCCodeIdentifier* _tmp10;
	char* _tmp9;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (l != NULL);
	/* use instance position from delegate*/
	_tmp0 = NULL;
	dt = (_tmp0 = VALA_DELEGATE_TYPE (vala_expression_get_target_type ((ValaExpression*) l)), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	vala_method_set_cinstance_parameter_position (vala_lambda_expression_get_method (l), vala_delegate_get_cinstance_parameter_position (vala_delegate_type_get_delegate_symbol (dt)));
	_tmp1 = NULL;
	old_temp_vars = (_tmp1 = self->temp_vars, (_tmp1 == NULL) ? NULL : gee_collection_object_ref (_tmp1));
	_tmp2 = NULL;
	old_temp_ref_vars = (_tmp2 = self->temp_ref_vars, (_tmp2 == NULL) ? NULL : gee_collection_object_ref (_tmp2));
	_tmp3 = NULL;
	self->temp_vars = (_tmp3 = gee_array_list_new (VALA_TYPE_LOCAL_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal), (self->temp_vars == NULL) ? NULL : (self->temp_vars = (gee_collection_object_unref (self->temp_vars), NULL)), _tmp3);
	_tmp4 = NULL;
	self->temp_ref_vars = (_tmp4 = gee_array_list_new (VALA_TYPE_LOCAL_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal), (self->temp_ref_vars == NULL) ? NULL : (self->temp_ref_vars = (gee_collection_object_unref (self->temp_ref_vars), NULL)), _tmp4);
	vala_code_node_accept_children ((ValaCodeNode*) l, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	_tmp6 = NULL;
	_tmp5 = NULL;
	self->temp_vars = (_tmp6 = (_tmp5 = old_temp_vars, (_tmp5 == NULL) ? NULL : gee_collection_object_ref (_tmp5)), (self->temp_vars == NULL) ? NULL : (self->temp_vars = (gee_collection_object_unref (self->temp_vars), NULL)), _tmp6);
	_tmp8 = NULL;
	_tmp7 = NULL;
	self->temp_ref_vars = (_tmp8 = (_tmp7 = old_temp_ref_vars, (_tmp7 == NULL) ? NULL : gee_collection_object_ref (_tmp7)), (self->temp_ref_vars == NULL) ? NULL : (self->temp_ref_vars = (gee_collection_object_unref (self->temp_ref_vars), NULL)), _tmp8);
	_tmp10 = NULL;
	_tmp9 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) l, (ValaCCodeNode*) (_tmp10 = vala_ccode_identifier_new (_tmp9 = vala_method_get_cname (vala_lambda_expression_get_method (l)))));
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	_tmp9 = (g_free (_tmp9), NULL);
	(dt == NULL) ? NULL : (dt = (vala_code_node_unref (dt), NULL));
	(old_temp_vars == NULL) ? NULL : (old_temp_vars = (gee_collection_object_unref (old_temp_vars), NULL));
	(old_temp_ref_vars == NULL) ? NULL : (old_temp_ref_vars = (gee_collection_object_unref (old_temp_ref_vars), NULL));
}


ValaCCodeExpression* vala_ccode_base_module_convert_from_generic_pointer (ValaCCodeBaseModule* self, ValaCCodeExpression* cexpr, ValaDataType* actual_type) {
	ValaCCodeExpression* _tmp0;
	ValaCCodeExpression* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cexpr != NULL, NULL);
	g_return_val_if_fail (actual_type != NULL, NULL);
	_tmp0 = NULL;
	result = (_tmp0 = cexpr, (_tmp0 == NULL) ? NULL : vala_ccode_node_ref (_tmp0));
	if (VALA_IS_STRUCT (vala_data_type_get_data_type (actual_type))) {
		ValaStruct* _tmp1;
		ValaStruct* st;
		_tmp1 = NULL;
		st = (_tmp1 = VALA_STRUCT (vala_data_type_get_data_type (actual_type)), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
		if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->uint_type)) {
			ValaCCodeIdentifier* _tmp2;
			ValaCCodeFunctionCall* _tmp3;
			ValaCCodeFunctionCall* cconv;
			ValaCCodeExpression* _tmp5;
			ValaCCodeExpression* _tmp4;
			_tmp2 = NULL;
			_tmp3 = NULL;
			cconv = (_tmp3 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp2 = vala_ccode_identifier_new ("GPOINTER_TO_UINT"))), (_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)), _tmp3);
			vala_ccode_function_call_add_argument (cconv, cexpr);
			_tmp5 = NULL;
			_tmp4 = NULL;
			result = (_tmp5 = (_tmp4 = (ValaCCodeExpression*) cconv, (_tmp4 == NULL) ? NULL : vala_ccode_node_ref (_tmp4)), (result == NULL) ? NULL : (result = (vala_ccode_node_unref (result), NULL)), _tmp5);
			(cconv == NULL) ? NULL : (cconv = (vala_ccode_node_unref (cconv), NULL));
		} else {
			gboolean _tmp6;
			_tmp6 = FALSE;
			if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->bool_type)) {
				_tmp6 = TRUE;
			} else {
				_tmp6 = vala_struct_is_integer_type (st);
			}
			if (_tmp6) {
				ValaCCodeIdentifier* _tmp7;
				ValaCCodeFunctionCall* _tmp8;
				ValaCCodeFunctionCall* cconv;
				ValaCCodeExpression* _tmp10;
				ValaCCodeExpression* _tmp9;
				_tmp7 = NULL;
				_tmp8 = NULL;
				cconv = (_tmp8 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new ("GPOINTER_TO_INT"))), (_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)), _tmp8);
				vala_ccode_function_call_add_argument (cconv, cexpr);
				_tmp10 = NULL;
				_tmp9 = NULL;
				result = (_tmp10 = (_tmp9 = (ValaCCodeExpression*) cconv, (_tmp9 == NULL) ? NULL : vala_ccode_node_ref (_tmp9)), (result == NULL) ? NULL : (result = (vala_ccode_node_unref (result), NULL)), _tmp10);
				(cconv == NULL) ? NULL : (cconv = (vala_ccode_node_unref (cconv), NULL));
			}
		}
		(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
	} else {
		gboolean _tmp11;
		_tmp11 = FALSE;
		if (vala_data_type_get_data_type (actual_type) != NULL) {
			_tmp11 = vala_typesymbol_is_reference_type (vala_data_type_get_data_type (actual_type));
		} else {
			_tmp11 = FALSE;
		}
		if (_tmp11) {
			ValaCCodeExpression* _tmp13;
			char* _tmp12;
			_tmp13 = NULL;
			_tmp12 = NULL;
			result = (_tmp13 = (ValaCCodeExpression*) vala_ccode_cast_expression_new (cexpr, _tmp12 = vala_data_type_get_cname (actual_type)), (result == NULL) ? NULL : (result = (vala_ccode_node_unref (result), NULL)), _tmp13);
			_tmp12 = (g_free (_tmp12), NULL);
		}
	}
	return result;
}


ValaCCodeExpression* vala_ccode_base_module_convert_to_generic_pointer (ValaCCodeBaseModule* self, ValaCCodeExpression* cexpr, ValaDataType* actual_type) {
	ValaCCodeExpression* _tmp0;
	ValaCCodeExpression* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cexpr != NULL, NULL);
	g_return_val_if_fail (actual_type != NULL, NULL);
	_tmp0 = NULL;
	result = (_tmp0 = cexpr, (_tmp0 == NULL) ? NULL : vala_ccode_node_ref (_tmp0));
	if (VALA_IS_STRUCT (vala_data_type_get_data_type (actual_type))) {
		ValaStruct* _tmp1;
		ValaStruct* st;
		_tmp1 = NULL;
		st = (_tmp1 = VALA_STRUCT (vala_data_type_get_data_type (actual_type)), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
		if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->uint_type)) {
			ValaCCodeIdentifier* _tmp2;
			ValaCCodeFunctionCall* _tmp3;
			ValaCCodeFunctionCall* cconv;
			ValaCCodeExpression* _tmp5;
			ValaCCodeExpression* _tmp4;
			_tmp2 = NULL;
			_tmp3 = NULL;
			cconv = (_tmp3 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp2 = vala_ccode_identifier_new ("GUINT_TO_POINTER"))), (_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)), _tmp3);
			vala_ccode_function_call_add_argument (cconv, cexpr);
			_tmp5 = NULL;
			_tmp4 = NULL;
			result = (_tmp5 = (_tmp4 = (ValaCCodeExpression*) cconv, (_tmp4 == NULL) ? NULL : vala_ccode_node_ref (_tmp4)), (result == NULL) ? NULL : (result = (vala_ccode_node_unref (result), NULL)), _tmp5);
			(cconv == NULL) ? NULL : (cconv = (vala_ccode_node_unref (cconv), NULL));
		} else {
			gboolean _tmp6;
			_tmp6 = FALSE;
			if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->bool_type)) {
				_tmp6 = TRUE;
			} else {
				_tmp6 = vala_struct_is_integer_type (st);
			}
			if (_tmp6) {
				ValaCCodeIdentifier* _tmp7;
				ValaCCodeFunctionCall* _tmp8;
				ValaCCodeFunctionCall* cconv;
				ValaCCodeExpression* _tmp10;
				ValaCCodeExpression* _tmp9;
				_tmp7 = NULL;
				_tmp8 = NULL;
				cconv = (_tmp8 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new ("GINT_TO_POINTER"))), (_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)), _tmp8);
				vala_ccode_function_call_add_argument (cconv, cexpr);
				_tmp10 = NULL;
				_tmp9 = NULL;
				result = (_tmp10 = (_tmp9 = (ValaCCodeExpression*) cconv, (_tmp9 == NULL) ? NULL : vala_ccode_node_ref (_tmp9)), (result == NULL) ? NULL : (result = (vala_ccode_node_unref (result), NULL)), _tmp10);
				(cconv == NULL) ? NULL : (cconv = (vala_ccode_node_unref (cconv), NULL));
			}
		}
		(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
	}
	return result;
}


/* manage memory and implicit casts*/
ValaCCodeExpression* vala_ccode_base_module_transform_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr) {
	ValaCCodeExpression* _tmp0;
	ValaCCodeExpression* cexpr;
	gboolean _tmp2;
	gboolean _tmp7;
	gboolean _tmp8;
	gboolean _tmp9;
	gboolean boxing;
	gboolean _tmp10;
	gboolean _tmp11;
	gboolean _tmp12;
	gboolean unboxing;
	gboolean _tmp13;
	gboolean _tmp54;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (source_cexpr != NULL, NULL);
	_tmp0 = NULL;
	cexpr = (_tmp0 = source_cexpr, (_tmp0 == NULL) ? NULL : vala_ccode_node_ref (_tmp0));
	if (expression_type == NULL) {
		return cexpr;
	}
	_tmp2 = FALSE;
	if (vala_data_type_get_value_owned (expression_type)) {
		_tmp2 = vala_data_type_get_floating_reference (expression_type);
	} else {
		_tmp2 = FALSE;
	}
	if (_tmp2) {
		ValaCCodeIdentifier* _tmp3;
		ValaCCodeFunctionCall* _tmp4;
		ValaCCodeFunctionCall* csink;
		ValaCCodeExpression* _tmp6;
		ValaCCodeExpression* _tmp5;
		/* constructor of GInitiallyUnowned subtype
		 * returns floating reference, sink it
		 */
		_tmp3 = NULL;
		_tmp4 = NULL;
		csink = (_tmp4 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp3 = vala_ccode_identifier_new ("g_object_ref_sink"))), (_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)), _tmp4);
		vala_ccode_function_call_add_argument (csink, cexpr);
		_tmp6 = NULL;
		_tmp5 = NULL;
		cexpr = (_tmp6 = (_tmp5 = (ValaCCodeExpression*) csink, (_tmp5 == NULL) ? NULL : vala_ccode_node_ref (_tmp5)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp6);
		(csink == NULL) ? NULL : (csink = (vala_ccode_node_unref (csink), NULL));
	}
	_tmp7 = FALSE;
	_tmp8 = FALSE;
	_tmp9 = FALSE;
	if (VALA_IS_VALUE_TYPE (expression_type)) {
		_tmp9 = !vala_data_type_get_nullable (expression_type);
	} else {
		_tmp9 = FALSE;
	}
	if (_tmp9) {
		_tmp8 = VALA_IS_VALUE_TYPE (target_type);
	} else {
		_tmp8 = FALSE;
	}
	if (_tmp8) {
		_tmp7 = vala_data_type_get_nullable (target_type);
	} else {
		_tmp7 = FALSE;
	}
	boxing = (_tmp7);
	_tmp10 = FALSE;
	_tmp11 = FALSE;
	_tmp12 = FALSE;
	if (VALA_IS_VALUE_TYPE (expression_type)) {
		_tmp12 = vala_data_type_get_nullable (expression_type);
	} else {
		_tmp12 = FALSE;
	}
	if (_tmp12) {
		_tmp11 = VALA_IS_VALUE_TYPE (target_type);
	} else {
		_tmp11 = FALSE;
	}
	if (_tmp11) {
		_tmp10 = !vala_data_type_get_nullable (target_type);
	} else {
		_tmp10 = FALSE;
	}
	unboxing = (_tmp10);
	_tmp13 = FALSE;
	if (vala_data_type_get_value_owned (expression_type)) {
		gboolean _tmp14;
		gboolean _tmp15;
		gboolean _tmp16;
		_tmp14 = FALSE;
		_tmp15 = FALSE;
		_tmp16 = FALSE;
		if (target_type == NULL) {
			_tmp16 = TRUE;
		} else {
			_tmp16 = !vala_data_type_get_value_owned (target_type);
		}
		if (_tmp16) {
			_tmp15 = TRUE;
		} else {
			_tmp15 = boxing;
		}
		if (_tmp15) {
			_tmp14 = TRUE;
		} else {
			_tmp14 = unboxing;
		}
		_tmp13 = (_tmp14);
	} else {
		_tmp13 = FALSE;
	}
	if (_tmp13) {
		ValaPointerType* _tmp18;
		ValaDataType* _tmp17;
		ValaPointerType* pointer_type;
		gboolean _tmp19;
		/* value leaked, destroy it*/
		_tmp18 = NULL;
		_tmp17 = NULL;
		pointer_type = (_tmp18 = (_tmp17 = target_type, VALA_IS_POINTER_TYPE (_tmp17) ? ((ValaPointerType*) _tmp17) : NULL), (_tmp18 == NULL) ? NULL : vala_code_node_ref (_tmp18));
		_tmp19 = FALSE;
		if (pointer_type != NULL) {
			_tmp19 = !(VALA_IS_VOID_TYPE (vala_pointer_type_get_base_type (pointer_type)));
		} else {
			_tmp19 = FALSE;
		}
		if (_tmp19) {
		} else {
			if (vala_ccode_base_module_requires_destroy (self, expression_type)) {
				ValaLocalVariable* decl;
				ValaCCodeExpression* _tmp22;
				ValaCCodeIdentifier* _tmp21;
				char* _tmp20;
				gboolean _tmp23;
				decl = vala_ccode_base_module_get_temp_variable (self, expression_type, TRUE, (ValaCodeNode*) expression_type);
				gee_list_insert ((GeeList*) self->temp_vars, 0, decl);
				gee_list_insert ((GeeList*) self->temp_ref_vars, 0, decl);
				_tmp22 = NULL;
				_tmp21 = NULL;
				_tmp20 = NULL;
				cexpr = (_tmp22 = (ValaCCodeExpression*) vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp21 = vala_ccode_identifier_new (_tmp20 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) decl)))), cexpr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp22);
				(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
				_tmp20 = (g_free (_tmp20), NULL);
				_tmp23 = FALSE;
				if (VALA_IS_ARRAY_TYPE (expression_type)) {
					_tmp23 = expr != NULL;
				} else {
					_tmp23 = FALSE;
				}
				if (_tmp23) {
					ValaArrayType* _tmp24;
					ValaArrayType* array_type;
					ValaCCodeCommaExpression* ccomma;
					ValaCCodeIdentifier* _tmp33;
					char* _tmp32;
					ValaCCodeExpression* _tmp35;
					ValaCCodeExpression* _tmp34;
					_tmp24 = NULL;
					array_type = (_tmp24 = VALA_ARRAY_TYPE (expression_type), (_tmp24 == NULL) ? NULL : vala_code_node_ref (_tmp24));
					ccomma = vala_ccode_comma_expression_new ();
					vala_ccode_comma_expression_append_expression (ccomma, cexpr);
					{
						gint dim;
						dim = 1;
						for (; dim <= vala_array_type_get_rank (array_type); dim++) {
							char* _tmp26;
							ValaDataType* _tmp25;
							ValaLocalVariable* _tmp27;
							ValaLocalVariable* len_decl;
							ValaCCodeAssignment* _tmp31;
							ValaCCodeExpression* _tmp30;
							ValaCCodeIdentifier* _tmp29;
							char* _tmp28;
							_tmp26 = NULL;
							_tmp25 = NULL;
							_tmp27 = NULL;
							len_decl = (_tmp27 = vala_local_variable_new (_tmp25 = vala_data_type_copy (self->int_type), _tmp26 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_symbol_get_name ((ValaSymbol*) decl), dim), NULL, NULL), _tmp26 = (g_free (_tmp26), NULL), (_tmp25 == NULL) ? NULL : (_tmp25 = (vala_code_node_unref (_tmp25), NULL)), _tmp27);
							gee_list_insert ((GeeList*) self->temp_vars, 0, len_decl);
							_tmp31 = NULL;
							_tmp30 = NULL;
							_tmp29 = NULL;
							_tmp28 = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp31 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp29 = vala_ccode_identifier_new (_tmp28 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) len_decl)))), _tmp30 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), expr, dim), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
							(_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL));
							(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
							(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
							_tmp28 = (g_free (_tmp28), NULL);
							(len_decl == NULL) ? NULL : (len_decl = (vala_code_node_unref (len_decl), NULL));
						}
					}
					_tmp33 = NULL;
					_tmp32 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp33 = vala_ccode_identifier_new (_tmp32 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) decl)))));
					(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
					_tmp32 = (g_free (_tmp32), NULL);
					_tmp35 = NULL;
					_tmp34 = NULL;
					cexpr = (_tmp35 = (_tmp34 = (ValaCCodeExpression*) ccomma, (_tmp34 == NULL) ? NULL : vala_ccode_node_ref (_tmp34)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp35);
					(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
					(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
				}
				(decl == NULL) ? NULL : (decl = (vala_code_node_unref (decl), NULL));
			}
		}
		(pointer_type == NULL) ? NULL : (pointer_type = (vala_code_node_unref (pointer_type), NULL));
	}
	if (target_type == NULL) {
		/* value will be destroyed, no need for implicit casts*/
		return cexpr;
	}
	if (boxing) {
		ValaCCodeUnaryExpression* _tmp38;
		ValaCCodeExpression* _tmp37;
		ValaCCodeUnaryExpression* unary;
		gboolean _tmp39;
		/* value needs to be boxed*/
		_tmp38 = NULL;
		_tmp37 = NULL;
		unary = (_tmp38 = (_tmp37 = cexpr, VALA_IS_CCODE_UNARY_EXPRESSION (_tmp37) ? ((ValaCCodeUnaryExpression*) _tmp37) : NULL), (_tmp38 == NULL) ? NULL : vala_ccode_node_ref (_tmp38));
		_tmp39 = FALSE;
		if (unary != NULL) {
			_tmp39 = vala_ccode_unary_expression_get_operator (unary) == VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION;
		} else {
			_tmp39 = FALSE;
		}
		if (_tmp39) {
			ValaCCodeExpression* _tmp41;
			ValaCCodeExpression* _tmp40;
			/* *expr => expr*/
			_tmp41 = NULL;
			_tmp40 = NULL;
			cexpr = (_tmp41 = (_tmp40 = vala_ccode_unary_expression_get_inner (unary), (_tmp40 == NULL) ? NULL : vala_ccode_node_ref (_tmp40)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp41);
		} else {
			gboolean _tmp42;
			_tmp42 = FALSE;
			if (VALA_IS_CCODE_IDENTIFIER (cexpr)) {
				_tmp42 = TRUE;
			} else {
				_tmp42 = VALA_IS_CCODE_MEMBER_ACCESS (cexpr);
			}
			if (_tmp42) {
				ValaCCodeExpression* _tmp43;
				_tmp43 = NULL;
				cexpr = (_tmp43 = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, cexpr), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp43);
			} else {
				ValaLocalVariable* decl;
				ValaCCodeCommaExpression* ccomma;
				ValaCCodeAssignment* _tmp46;
				ValaCCodeIdentifier* _tmp45;
				char* _tmp44;
				ValaCCodeUnaryExpression* _tmp49;
				ValaCCodeIdentifier* _tmp48;
				char* _tmp47;
				ValaCCodeExpression* _tmp51;
				ValaCCodeExpression* _tmp50;
				decl = vala_ccode_base_module_get_temp_variable (self, expression_type, vala_data_type_get_value_owned (expression_type), (ValaCodeNode*) expression_type);
				gee_list_insert ((GeeList*) self->temp_vars, 0, decl);
				ccomma = vala_ccode_comma_expression_new ();
				_tmp46 = NULL;
				_tmp45 = NULL;
				_tmp44 = NULL;
				vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp46 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp45 = vala_ccode_identifier_new (_tmp44 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) decl)))), cexpr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
				(_tmp46 == NULL) ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL));
				(_tmp45 == NULL) ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL));
				_tmp44 = (g_free (_tmp44), NULL);
				_tmp49 = NULL;
				_tmp48 = NULL;
				_tmp47 = NULL;
				vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp49 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp48 = vala_ccode_identifier_new (_tmp47 = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) decl)))))));
				(_tmp49 == NULL) ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL));
				(_tmp48 == NULL) ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL));
				_tmp47 = (g_free (_tmp47), NULL);
				_tmp51 = NULL;
				_tmp50 = NULL;
				cexpr = (_tmp51 = (_tmp50 = (ValaCCodeExpression*) ccomma, (_tmp50 == NULL) ? NULL : vala_ccode_node_ref (_tmp50)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp51);
				(decl == NULL) ? NULL : (decl = (vala_code_node_unref (decl), NULL));
				(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
			}
		}
		(unary == NULL) ? NULL : (unary = (vala_ccode_node_unref (unary), NULL));
	} else {
		if (unboxing) {
			ValaCCodeExpression* _tmp52;
			/* unbox value*/
			_tmp52 = NULL;
			cexpr = (_tmp52 = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, cexpr), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp52);
		} else {
			ValaCCodeExpression* _tmp53;
			_tmp53 = NULL;
			cexpr = (_tmp53 = vala_ccode_base_module_get_implicit_cast_expression (self, cexpr, expression_type, target_type, expr), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp53);
		}
	}
	_tmp54 = FALSE;
	if (vala_data_type_get_value_owned (target_type)) {
		gboolean _tmp55;
		gboolean _tmp56;
		_tmp55 = FALSE;
		_tmp56 = FALSE;
		if (!vala_data_type_get_value_owned (expression_type)) {
			_tmp56 = TRUE;
		} else {
			_tmp56 = boxing;
		}
		if (_tmp56) {
			_tmp55 = TRUE;
		} else {
			_tmp55 = unboxing;
		}
		_tmp54 = (_tmp55);
	} else {
		_tmp54 = FALSE;
	}
	if (_tmp54) {
		gboolean _tmp57;
		_tmp57 = FALSE;
		if (vala_ccode_base_module_requires_copy (self, target_type)) {
			_tmp57 = !(VALA_IS_NULL_TYPE (expression_type));
		} else {
			_tmp57 = FALSE;
		}
		/* need to copy value*/
		if (_tmp57) {
			ValaCodeNode* _tmp58;
			ValaCodeNode* node;
			ValaCCodeExpression* _tmp61;
			_tmp58 = NULL;
			node = (_tmp58 = (ValaCodeNode*) expr, (_tmp58 == NULL) ? NULL : vala_code_node_ref (_tmp58));
			if (node == NULL) {
				ValaCodeNode* _tmp60;
				ValaCodeNode* _tmp59;
				_tmp60 = NULL;
				_tmp59 = NULL;
				node = (_tmp60 = (_tmp59 = (ValaCodeNode*) expression_type, (_tmp59 == NULL) ? NULL : vala_code_node_ref (_tmp59)), (node == NULL) ? NULL : (node = (vala_code_node_unref (node), NULL)), _tmp60);
			}
			_tmp61 = NULL;
			cexpr = (_tmp61 = vala_ccode_base_module_get_ref_cexpression (self, target_type, cexpr, expr, node), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp61);
			(node == NULL) ? NULL : (node = (vala_code_node_unref (node), NULL));
		}
	}
	return cexpr;
}


static ValaCCodeExpression* vala_ccode_base_module_real_get_implicit_cast_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr) {
	ValaCCodeExpression* _tmp0;
	ValaCCodeExpression* cexpr;
	gboolean _tmp1;
	ValaClass* _tmp5;
	ValaTypeSymbol* _tmp4;
	ValaClass* cl;
	ValaInterface* _tmp7;
	ValaTypeSymbol* _tmp6;
	ValaInterface* iface;
	gboolean _tmp8;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (source_cexpr != NULL, NULL);
	_tmp0 = NULL;
	cexpr = (_tmp0 = source_cexpr, (_tmp0 == NULL) ? NULL : vala_ccode_node_ref (_tmp0));
	_tmp1 = FALSE;
	if (vala_data_type_get_data_type (expression_type) != NULL) {
		_tmp1 = vala_data_type_get_data_type (expression_type) == vala_data_type_get_data_type (target_type);
	} else {
		_tmp1 = FALSE;
	}
	if (_tmp1) {
		/* same type, no cast required*/
		return cexpr;
	}
	if (VALA_IS_NULL_TYPE (expression_type)) {
		/* null literal, no cast required when not converting to generic type pointer*/
		return cexpr;
	}
	_tmp5 = NULL;
	_tmp4 = NULL;
	cl = (_tmp5 = (_tmp4 = vala_data_type_get_data_type (target_type), VALA_IS_CLASS (_tmp4) ? ((ValaClass*) _tmp4) : NULL), (_tmp5 == NULL) ? NULL : vala_code_node_ref (_tmp5));
	_tmp7 = NULL;
	_tmp6 = NULL;
	iface = (_tmp7 = (_tmp6 = vala_data_type_get_data_type (target_type), VALA_IS_INTERFACE (_tmp6) ? ((ValaInterface*) _tmp6) : NULL), (_tmp7 == NULL) ? NULL : vala_code_node_ref (_tmp7));
	_tmp8 = FALSE;
	if (vala_code_context_get_checking (self->priv->_context)) {
		gboolean _tmp9;
		_tmp9 = FALSE;
		if (iface != NULL) {
			_tmp9 = TRUE;
		} else {
			gboolean _tmp10;
			_tmp10 = FALSE;
			if (cl != NULL) {
				_tmp10 = !vala_class_get_is_compact (cl);
			} else {
				_tmp10 = FALSE;
			}
			_tmp9 = (_tmp10);
		}
		_tmp8 = (_tmp9);
	} else {
		_tmp8 = FALSE;
	}
	if (_tmp8) {
		ValaCCodeExpression* _tmp11;
		/* checked cast for strict subtypes of GTypeInstance*/
		_tmp11 = NULL;
		return (_tmp11 = (ValaCCodeExpression*) vala_instance_cast_new (cexpr, vala_data_type_get_data_type (target_type)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), (iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL)), _tmp11);
	} else {
		gboolean _tmp12;
		_tmp12 = FALSE;
		if (vala_data_type_get_data_type (target_type) != NULL) {
			char* _tmp14;
			char* _tmp13;
			_tmp14 = NULL;
			_tmp13 = NULL;
			_tmp12 = _vala_strcmp0 (_tmp13 = vala_data_type_get_cname (expression_type), _tmp14 = vala_data_type_get_cname (target_type)) != 0;
			_tmp14 = (g_free (_tmp14), NULL);
			_tmp13 = (g_free (_tmp13), NULL);
		} else {
			_tmp12 = FALSE;
		}
		if (_tmp12) {
			ValaStruct* _tmp16;
			ValaTypeSymbol* _tmp15;
			ValaStruct* st;
			gboolean _tmp17;
			_tmp16 = NULL;
			_tmp15 = NULL;
			st = (_tmp16 = (_tmp15 = vala_data_type_get_data_type (target_type), VALA_IS_STRUCT (_tmp15) ? ((ValaStruct*) _tmp15) : NULL), (_tmp16 == NULL) ? NULL : vala_code_node_ref (_tmp16));
			_tmp17 = FALSE;
			if (vala_typesymbol_is_reference_type (vala_data_type_get_data_type (target_type))) {
				_tmp17 = TRUE;
			} else {
				gboolean _tmp18;
				_tmp18 = FALSE;
				if (st != NULL) {
					_tmp18 = vala_struct_is_simple_type (st);
				} else {
					_tmp18 = FALSE;
				}
				_tmp17 = (_tmp18);
			}
			if (_tmp17) {
				char* _tmp19;
				ValaCCodeExpression* _tmp20;
				ValaCCodeExpression* _tmp21;
				/* don't cast non-simple structs*/
				_tmp19 = NULL;
				_tmp20 = NULL;
				_tmp21 = NULL;
				return (_tmp21 = (_tmp20 = (ValaCCodeExpression*) vala_ccode_cast_expression_new (cexpr, _tmp19 = vala_data_type_get_cname (target_type)), _tmp19 = (g_free (_tmp19), NULL), _tmp20), (st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), (iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL)), _tmp21);
			} else {
				ValaCCodeExpression* _tmp22;
				_tmp22 = NULL;
				return (_tmp22 = cexpr, (st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL)), (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), (iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL)), _tmp22);
			}
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
		} else {
			ValaCCodeExpression* _tmp23;
			_tmp23 = NULL;
			return (_tmp23 = cexpr, (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), (iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL)), _tmp23);
		}
	}
	(cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL));
	(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
}


ValaCCodeExpression* vala_ccode_base_module_get_implicit_cast_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr) {
	return VALA_CCODE_BASE_MODULE_GET_CLASS (self)->get_implicit_cast_expression (self, source_cexpr, expression_type, target_type, expr);
}


ValaCCodeFunctionCall* vala_ccode_base_module_get_property_set_call (ValaCCodeBaseModule* self, ValaProperty* prop, ValaMemberAccess* ma, ValaCCodeExpression* cexpr) {
	char* set_func;
	ValaProperty* _tmp23;
	ValaProperty* base_property;
	ValaCCodeIdentifier* _tmp32;
	ValaCCodeFunctionCall* _tmp33;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeFunctionCall* _tmp37;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prop != NULL, NULL);
	g_return_val_if_fail (ma != NULL, NULL);
	g_return_val_if_fail (cexpr != NULL, NULL);
	if (VALA_IS_BASE_ACCESS (vala_member_access_get_inner (ma))) {
		if (vala_property_get_base_property (prop) != NULL) {
			ValaClass* _tmp0;
			ValaClass* base_class;
			ValaCCodeIdentifier* _tmp3;
			char* _tmp2;
			char* _tmp1;
			ValaCCodeFunctionCall* _tmp4;
			ValaCCodeFunctionCall* vcast;
			ValaCCodeIdentifier* _tmp7;
			char* _tmp6;
			char* _tmp5;
			ValaCCodeMemberAccess* _tmp9;
			char* _tmp8;
			ValaCCodeFunctionCall* _tmp10;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeExpression* _tmp11;
			ValaCCodeFunctionCall* _tmp12;
			_tmp0 = NULL;
			base_class = (_tmp0 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_property_get_base_property (prop))), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
			_tmp3 = NULL;
			_tmp2 = NULL;
			_tmp1 = NULL;
			_tmp4 = NULL;
			vcast = (_tmp4 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp3 = vala_ccode_identifier_new (_tmp2 = g_strdup_printf ("%s_CLASS", _tmp1 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) base_class, NULL))))), (_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)), _tmp2 = (g_free (_tmp2), NULL), _tmp1 = (g_free (_tmp1), NULL), _tmp4);
			_tmp7 = NULL;
			_tmp6 = NULL;
			_tmp5 = NULL;
			vala_ccode_function_call_add_argument (vcast, (ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new (_tmp6 = g_strdup_printf ("%s_parent_class", _tmp5 = vala_symbol_get_lower_case_cname ((ValaSymbol*) self->current_class, NULL)))));
			(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
			_tmp6 = (g_free (_tmp6), NULL);
			_tmp5 = (g_free (_tmp5), NULL);
			_tmp9 = NULL;
			_tmp8 = NULL;
			_tmp10 = NULL;
			ccall = (_tmp10 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp9 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) vcast, _tmp8 = g_strdup_printf ("set_%s", vala_symbol_get_name ((ValaSymbol*) prop))))), (_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)), _tmp8 = (g_free (_tmp8), NULL), _tmp10);
			_tmp11 = NULL;
			vala_ccode_function_call_add_argument (ccall, _tmp11 = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode (self, (ValaCodeNode*) vala_member_access_get_inner (ma))));
			(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
			vala_ccode_function_call_add_argument (ccall, cexpr);
			_tmp12 = NULL;
			return (_tmp12 = ccall, (base_class == NULL) ? NULL : (base_class = (vala_code_node_unref (base_class), NULL)), (vcast == NULL) ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL)), _tmp12);
		} else {
			if (vala_property_get_base_interface_property (prop) != NULL) {
				ValaInterface* _tmp13;
				ValaInterface* base_iface;
				char* _tmp15;
				char* _tmp14;
				char* _tmp16;
				char* parent_iface_var;
				ValaCCodeMemberAccess* _tmp19;
				char* _tmp18;
				ValaCCodeIdentifier* _tmp17;
				ValaCCodeFunctionCall* _tmp20;
				ValaCCodeFunctionCall* ccall;
				ValaCCodeExpression* _tmp21;
				ValaCCodeFunctionCall* _tmp22;
				_tmp13 = NULL;
				base_iface = (_tmp13 = VALA_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_property_get_base_interface_property (prop))), (_tmp13 == NULL) ? NULL : vala_code_node_ref (_tmp13));
				_tmp15 = NULL;
				_tmp14 = NULL;
				_tmp16 = NULL;
				parent_iface_var = (_tmp16 = g_strdup_printf ("%s_%s_parent_iface", _tmp14 = vala_symbol_get_lower_case_cname ((ValaSymbol*) self->current_class, NULL), _tmp15 = vala_symbol_get_lower_case_cname ((ValaSymbol*) base_iface, NULL)), _tmp15 = (g_free (_tmp15), NULL), _tmp14 = (g_free (_tmp14), NULL), _tmp16);
				_tmp19 = NULL;
				_tmp18 = NULL;
				_tmp17 = NULL;
				_tmp20 = NULL;
				ccall = (_tmp20 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp19 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp17 = vala_ccode_identifier_new (parent_iface_var)), _tmp18 = g_strdup_printf ("set_%s", vala_symbol_get_name ((ValaSymbol*) prop))))), (_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)), _tmp18 = (g_free (_tmp18), NULL), (_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)), _tmp20);
				_tmp21 = NULL;
				vala_ccode_function_call_add_argument (ccall, _tmp21 = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode (self, (ValaCodeNode*) vala_member_access_get_inner (ma))));
				(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
				vala_ccode_function_call_add_argument (ccall, cexpr);
				_tmp22 = NULL;
				return (_tmp22 = ccall, (base_iface == NULL) ? NULL : (base_iface = (vala_code_node_unref (base_iface), NULL)), parent_iface_var = (g_free (parent_iface_var), NULL), _tmp22);
			}
		}
	}
	set_func = g_strdup ("g_object_set");
	_tmp23 = NULL;
	base_property = (_tmp23 = prop, (_tmp23 == NULL) ? NULL : vala_code_node_ref (_tmp23));
	if (!vala_property_get_no_accessor_method (prop)) {
		ValaTypeSymbol* _tmp28;
		ValaTypeSymbol* base_property_type;
		char* _tmp30;
		char* _tmp29;
		if (vala_property_get_base_property (prop) != NULL) {
			ValaProperty* _tmp25;
			ValaProperty* _tmp24;
			_tmp25 = NULL;
			_tmp24 = NULL;
			base_property = (_tmp25 = (_tmp24 = vala_property_get_base_property (prop), (_tmp24 == NULL) ? NULL : vala_code_node_ref (_tmp24)), (base_property == NULL) ? NULL : (base_property = (vala_code_node_unref (base_property), NULL)), _tmp25);
		} else {
			if (vala_property_get_base_interface_property (prop) != NULL) {
				ValaProperty* _tmp27;
				ValaProperty* _tmp26;
				_tmp27 = NULL;
				_tmp26 = NULL;
				base_property = (_tmp27 = (_tmp26 = vala_property_get_base_interface_property (prop), (_tmp26 == NULL) ? NULL : vala_code_node_ref (_tmp26)), (base_property == NULL) ? NULL : (base_property = (vala_code_node_unref (base_property), NULL)), _tmp27);
			}
		}
		_tmp28 = NULL;
		base_property_type = (_tmp28 = VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) base_property)), (_tmp28 == NULL) ? NULL : vala_code_node_ref (_tmp28));
		_tmp30 = NULL;
		_tmp29 = NULL;
		set_func = (_tmp30 = g_strdup_printf ("%s_set_%s", _tmp29 = vala_symbol_get_lower_case_cname ((ValaSymbol*) base_property_type, NULL), vala_symbol_get_name ((ValaSymbol*) base_property)), set_func = (g_free (set_func), NULL), _tmp30);
		_tmp29 = (g_free (_tmp29), NULL);
		if (VALA_IS_DYNAMIC_PROPERTY (prop)) {
			char* _tmp31;
			_tmp31 = NULL;
			set_func = (_tmp31 = vala_ccode_module_get_dynamic_property_setter_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), VALA_DYNAMIC_PROPERTY (prop)), set_func = (g_free (set_func), NULL), _tmp31);
		}
		(base_property_type == NULL) ? NULL : (base_property_type = (vala_code_node_unref (base_property_type), NULL));
	}
	_tmp32 = NULL;
	_tmp33 = NULL;
	ccall = (_tmp33 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp32 = vala_ccode_identifier_new (set_func))), (_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL)), _tmp33);
	if (vala_property_get_binding (prop) == MEMBER_BINDING_INSTANCE) {
		ValaCCodeExpression* _tmp34;
		/* target instance is first argument */
		_tmp34 = NULL;
		vala_ccode_function_call_add_argument (ccall, _tmp34 = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode (self, (ValaCodeNode*) vala_member_access_get_inner (ma))));
		(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
	}
	if (vala_property_get_no_accessor_method (prop)) {
		ValaCCodeConstant* _tmp35;
		/* property name is second argument of g_object_set */
		_tmp35 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp35 = vala_property_get_canonical_cconstant (prop)));
		(_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL));
	}
	vala_ccode_function_call_add_argument (ccall, cexpr);
	if (vala_property_get_no_accessor_method (prop)) {
		ValaCCodeConstant* _tmp36;
		_tmp36 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp36 = vala_ccode_constant_new ("NULL")));
		(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
	}
	_tmp37 = NULL;
	return (_tmp37 = ccall, set_func = (g_free (set_func), NULL), (base_property == NULL) ? NULL : (base_property = (vala_code_node_unref (base_property), NULL)), _tmp37);
}


/* indicates whether a given Expression eligable for an ADDRESS_OF operator
 * from a vala to C point of view all expressions denoting locals, fields and
 * parameters are eligable to an ADDRESS_OF operator */
gboolean vala_ccode_base_module_is_address_of_possible (ValaCCodeBaseModule* self, ValaExpression* e) {
	ValaMemberAccess* _tmp1;
	ValaExpression* _tmp0;
	ValaMemberAccess* ma;
	gboolean _tmp7;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp1 = NULL;
	_tmp0 = NULL;
	ma = (_tmp1 = (_tmp0 = e, VALA_IS_MEMBER_ACCESS (_tmp0) ? ((ValaMemberAccess*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	if (ma == NULL) {
		gboolean _tmp2;
		return (_tmp2 = FALSE, (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), _tmp2);
	}
	if (vala_expression_get_symbol_reference ((ValaExpression*) ma) == NULL) {
		gboolean _tmp3;
		return (_tmp3 = FALSE, (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), _tmp3);
	}
	if (VALA_IS_FORMAL_PARAMETER (vala_expression_get_symbol_reference ((ValaExpression*) ma))) {
		gboolean _tmp4;
		return (_tmp4 = TRUE, (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), _tmp4);
	}
	if (VALA_IS_LOCAL_VARIABLE (vala_expression_get_symbol_reference ((ValaExpression*) ma))) {
		gboolean _tmp5;
		return (_tmp5 = TRUE, (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), _tmp5);
	}
	if (VALA_IS_FIELD (vala_expression_get_symbol_reference ((ValaExpression*) ma))) {
		gboolean _tmp6;
		return (_tmp6 = TRUE, (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), _tmp6);
	}
	return (_tmp7 = FALSE, (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), _tmp7);
}


/* retrieve the correct address_of expression for a give expression, creates temporary variables
 * where necessary, ce is the corresponding ccode expression for e */
ValaCCodeExpression* vala_ccode_base_module_get_address_of_expression (ValaCCodeBaseModule* self, ValaExpression* e, ValaCCodeExpression* ce) {
	ValaCCodeCommaExpression* ccomma;
	ValaLocalVariable* temp_decl;
	ValaCCodeIdentifier* ctemp;
	ValaCCodeAssignment* _tmp1;
	ValaCCodeUnaryExpression* _tmp2;
	ValaCCodeExpression* _tmp3;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (e != NULL, NULL);
	g_return_val_if_fail (ce != NULL, NULL);
	/* is address of trivially possible?*/
	if (vala_ccode_base_module_is_address_of_possible (self, e)) {
		return (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ce);
	}
	ccomma = vala_ccode_comma_expression_new ();
	temp_decl = vala_ccode_base_module_get_temp_variable (self, vala_expression_get_value_type (e), TRUE, NULL);
	ctemp = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_decl));
	gee_collection_add ((GeeCollection*) self->temp_vars, temp_decl);
	_tmp1 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp1 = vala_ccode_assignment_new ((ValaCCodeExpression*) ctemp, ce, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
	(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
	_tmp2 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp2 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) ctemp)));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	_tmp3 = NULL;
	return (_tmp3 = (ValaCCodeExpression*) ccomma, (temp_decl == NULL) ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL)), (ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL)), _tmp3);
}


gboolean vala_ccode_base_module_add_wrapper (ValaCCodeBaseModule* self, const char* wrapper_name) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (wrapper_name != NULL, FALSE);
	return gee_collection_add ((GeeCollection*) self->wrappers, wrapper_name);
}


ValaDataType* vala_ccode_base_module_get_data_type_for_symbol (ValaTypeSymbol* sym) {
	ValaDataType* type;
	g_return_val_if_fail (sym != NULL, NULL);
	type = NULL;
	if (VALA_IS_CLASS (sym)) {
		ValaDataType* _tmp0;
		_tmp0 = NULL;
		type = (_tmp0 = (ValaDataType*) vala_object_type_new ((ValaObjectTypeSymbol*) VALA_CLASS (sym)), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp0);
	} else {
		if (VALA_IS_INTERFACE (sym)) {
			ValaDataType* _tmp1;
			_tmp1 = NULL;
			type = (_tmp1 = (ValaDataType*) vala_object_type_new ((ValaObjectTypeSymbol*) VALA_INTERFACE (sym)), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp1);
		} else {
			if (VALA_IS_STRUCT (sym)) {
				ValaDataType* _tmp2;
				_tmp2 = NULL;
				type = (_tmp2 = (ValaDataType*) vala_value_type_new ((ValaTypeSymbol*) VALA_STRUCT (sym)), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp2);
			} else {
				if (VALA_IS_ENUM (sym)) {
					ValaDataType* _tmp3;
					_tmp3 = NULL;
					type = (_tmp3 = (ValaDataType*) vala_value_type_new ((ValaTypeSymbol*) VALA_ENUM (sym)), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp3);
				} else {
					if (VALA_IS_ERROR_DOMAIN (sym)) {
						ValaDataType* _tmp4;
						_tmp4 = NULL;
						type = (_tmp4 = (ValaDataType*) vala_error_type_new (VALA_ERROR_DOMAIN (sym), NULL, NULL), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp4);
					} else {
						if (VALA_IS_ERROR_CODE (sym)) {
							ValaDataType* _tmp5;
							_tmp5 = NULL;
							type = (_tmp5 = (ValaDataType*) vala_error_type_new (VALA_ERROR_DOMAIN (vala_symbol_get_parent_symbol ((ValaSymbol*) sym)), VALA_ERROR_CODE (sym), NULL), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp5);
						} else {
							char* _tmp7;
							char* _tmp6;
							ValaDataType* _tmp8;
							_tmp7 = NULL;
							_tmp6 = NULL;
							vala_report_error (NULL, _tmp7 = g_strdup_printf ("internal error: `%s' is not a supported type", _tmp6 = vala_symbol_get_full_name ((ValaSymbol*) sym)));
							_tmp7 = (g_free (_tmp7), NULL);
							_tmp6 = (g_free (_tmp6), NULL);
							_tmp8 = NULL;
							return (_tmp8 = (ValaDataType*) vala_invalid_type_new (), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp8);
						}
					}
				}
			}
		}
	}
	return type;
}


ValaCCodeExpression* vala_ccode_base_module_default_value_for_type (ValaCCodeBaseModule* self, ValaDataType* type, gboolean initializer_expression) {
	gboolean _tmp0;
	gboolean _tmp1;
	gboolean _tmp2;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp0 = FALSE;
	_tmp1 = FALSE;
	_tmp2 = FALSE;
	if (vala_data_type_get_data_type (type) != NULL) {
		_tmp2 = vala_typesymbol_is_reference_type (vala_data_type_get_data_type (type));
	} else {
		_tmp2 = FALSE;
	}
	if ((_tmp2)) {
		_tmp1 = TRUE;
	} else {
		_tmp1 = VALA_IS_POINTER_TYPE (type);
	}
	if (_tmp1) {
		_tmp0 = TRUE;
	} else {
		_tmp0 = VALA_IS_ARRAY_TYPE (type);
	}
	if (_tmp0) {
		return (ValaCCodeExpression*) vala_ccode_constant_new ("NULL");
	} else {
		gboolean _tmp4;
		_tmp4 = FALSE;
		if (vala_data_type_get_data_type (type) != NULL) {
			char* _tmp5;
			_tmp5 = NULL;
			_tmp4 = (_tmp5 = vala_typesymbol_get_default_value (vala_data_type_get_data_type (type))) != NULL;
			_tmp5 = (g_free (_tmp5), NULL);
		} else {
			_tmp4 = FALSE;
		}
		if (_tmp4) {
			char* _tmp6;
			ValaCCodeExpression* _tmp7;
			_tmp6 = NULL;
			_tmp7 = NULL;
			return (_tmp7 = (ValaCCodeExpression*) vala_ccode_constant_new (_tmp6 = vala_typesymbol_get_default_value (vala_data_type_get_data_type (type))), _tmp6 = (g_free (_tmp6), NULL), _tmp7);
		} else {
			gboolean _tmp9;
			_tmp9 = FALSE;
			if (VALA_IS_STRUCT (vala_data_type_get_data_type (type))) {
				_tmp9 = initializer_expression;
			} else {
				_tmp9 = FALSE;
			}
			if (_tmp9) {
				ValaCCodeInitializerList* clist;
				ValaCCodeConstant* _tmp10;
				/* 0-initialize struct with struct initializer { 0 }
				 only allowed as initializer expression in C*/
				clist = vala_ccode_initializer_list_new ();
				_tmp10 = NULL;
				vala_ccode_initializer_list_append (clist, (ValaCCodeExpression*) (_tmp10 = vala_ccode_constant_new ("0")));
				(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
				return (ValaCCodeExpression*) clist;
			} else {
				if (vala_data_type_get_type_parameter (type) != NULL) {
					return (ValaCCodeExpression*) vala_ccode_constant_new ("NULL");
				} else {
					if (VALA_IS_ERROR_TYPE (type)) {
						return (ValaCCodeExpression*) vala_ccode_constant_new ("NULL");
					}
				}
			}
		}
	}
	return NULL;
}


static ValaCCodeStatement* vala_ccode_base_module_create_property_type_check_statement (ValaCCodeBaseModule* self, ValaProperty* prop, gboolean check_return_type, ValaTypeSymbol* t, gboolean non_null, const char* var_name) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prop != NULL, NULL);
	g_return_val_if_fail (t != NULL, NULL);
	g_return_val_if_fail (var_name != NULL, NULL);
	if (check_return_type) {
		return vala_ccode_base_module_create_type_check_statement (self, (ValaCodeNode*) prop, vala_property_get_property_type (prop), t, non_null, var_name);
	} else {
		ValaVoidType* _tmp1;
		ValaCCodeStatement* _tmp2;
		_tmp1 = NULL;
		_tmp2 = NULL;
		return (_tmp2 = vala_ccode_base_module_create_type_check_statement (self, (ValaCodeNode*) prop, (ValaDataType*) (_tmp1 = vala_void_type_new ()), t, non_null, var_name), (_tmp1 == NULL) ? NULL : (_tmp1 = (vala_code_node_unref (_tmp1), NULL)), _tmp2);
	}
}


ValaCCodeStatement* vala_ccode_base_module_create_type_check_statement (ValaCCodeBaseModule* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaTypeSymbol* t, gboolean non_null, const char* var_name) {
	ValaCCodeFunctionCall* ccheck;
	gboolean _tmp0;
	ValaCCodeStatement* _tmp21;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (method_node != NULL, NULL);
	g_return_val_if_fail (ret_type != NULL, NULL);
	g_return_val_if_fail (t != NULL, NULL);
	g_return_val_if_fail (var_name != NULL, NULL);
	ccheck = vala_ccode_function_call_new (NULL);
	_tmp0 = FALSE;
	if (vala_code_context_get_checking (self->priv->_context)) {
		gboolean _tmp1;
		gboolean _tmp2;
		_tmp1 = FALSE;
		_tmp2 = FALSE;
		if (VALA_IS_CLASS (t)) {
			_tmp2 = !vala_class_get_is_compact ((VALA_CLASS (t)));
		} else {
			_tmp2 = FALSE;
		}
		if ((_tmp2)) {
			_tmp1 = TRUE;
		} else {
			_tmp1 = VALA_IS_INTERFACE (t);
		}
		_tmp0 = (_tmp1);
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		ValaCCodeIdentifier* _tmp4;
		char* _tmp3;
		ValaCCodeFunctionCall* _tmp5;
		ValaCCodeFunctionCall* ctype_check;
		ValaCCodeIdentifier* _tmp6;
		ValaCCodeExpression* _tmp7;
		ValaCCodeExpression* cexpr;
		_tmp4 = NULL;
		_tmp3 = NULL;
		_tmp5 = NULL;
		ctype_check = (_tmp5 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp4 = vala_ccode_identifier_new (_tmp3 = vala_ccode_base_module_get_type_check_function (self, t)))), (_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)), _tmp3 = (g_free (_tmp3), NULL), _tmp5);
		_tmp6 = NULL;
		vala_ccode_function_call_add_argument (ctype_check, (ValaCCodeExpression*) (_tmp6 = vala_ccode_identifier_new (var_name)));
		(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
		_tmp7 = NULL;
		cexpr = (_tmp7 = (ValaCCodeExpression*) ctype_check, (_tmp7 == NULL) ? NULL : vala_ccode_node_ref (_tmp7));
		if (!non_null) {
			ValaCCodeConstant* _tmp9;
			ValaCCodeIdentifier* _tmp8;
			ValaCCodeBinaryExpression* _tmp10;
			ValaCCodeBinaryExpression* cnull;
			ValaCCodeExpression* _tmp11;
			_tmp9 = NULL;
			_tmp8 = NULL;
			_tmp10 = NULL;
			cnull = (_tmp10 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) (_tmp8 = vala_ccode_identifier_new (var_name)), (ValaCCodeExpression*) (_tmp9 = vala_ccode_constant_new ("NULL"))), (_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)), (_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)), _tmp10);
			_tmp11 = NULL;
			cexpr = (_tmp11 = (ValaCCodeExpression*) vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, (ValaCCodeExpression*) cnull, (ValaCCodeExpression*) ctype_check), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp11);
			(cnull == NULL) ? NULL : (cnull = (vala_ccode_node_unref (cnull), NULL));
		}
		vala_ccode_function_call_add_argument (ccheck, cexpr);
		(ctype_check == NULL) ? NULL : (ctype_check = (vala_ccode_node_unref (ctype_check), NULL));
		(cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL));
	} else {
		if (!non_null) {
			ValaCCodeStatement* _tmp12;
			_tmp12 = NULL;
			return (_tmp12 = NULL, (ccheck == NULL) ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL)), _tmp12);
		} else {
			ValaCCodeConstant* _tmp14;
			ValaCCodeIdentifier* _tmp13;
			ValaCCodeBinaryExpression* _tmp15;
			ValaCCodeBinaryExpression* cnonnull;
			_tmp14 = NULL;
			_tmp13 = NULL;
			_tmp15 = NULL;
			cnonnull = (_tmp15 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) (_tmp13 = vala_ccode_identifier_new (var_name)), (ValaCCodeExpression*) (_tmp14 = vala_ccode_constant_new ("NULL"))), (_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)), (_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)), _tmp15);
			vala_ccode_function_call_add_argument (ccheck, (ValaCCodeExpression*) cnonnull);
			(cnonnull == NULL) ? NULL : (cnonnull = (vala_ccode_node_unref (cnonnull), NULL));
		}
	}
	if (VALA_IS_VOID_TYPE (ret_type)) {
		ValaCCodeIdentifier* _tmp16;
		/* void function */
		_tmp16 = NULL;
		vala_ccode_function_call_set_call (ccheck, (ValaCCodeExpression*) (_tmp16 = vala_ccode_identifier_new ("g_return_if_fail")));
		(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
	} else {
		ValaCCodeIdentifier* _tmp17;
		ValaCCodeExpression* cdefault;
		_tmp17 = NULL;
		vala_ccode_function_call_set_call (ccheck, (ValaCCodeExpression*) (_tmp17 = vala_ccode_identifier_new ("g_return_val_if_fail")));
		(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
		cdefault = vala_ccode_base_module_default_value_for_type (self, ret_type, FALSE);
		if (cdefault != NULL) {
			vala_ccode_function_call_add_argument (ccheck, cdefault);
		} else {
			ValaCCodeConstant* _tmp18;
			ValaCCodeStatement* _tmp19;
			ValaCCodeStatement* _tmp20;
			_tmp18 = NULL;
			_tmp19 = NULL;
			_tmp20 = NULL;
			return (_tmp20 = (_tmp19 = (ValaCCodeStatement*) vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp18 = vala_ccode_constant_new ("0"))), (_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)), _tmp19), (cdefault == NULL) ? NULL : (cdefault = (vala_ccode_node_unref (cdefault), NULL)), (ccheck == NULL) ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL)), _tmp20);
		}
		(cdefault == NULL) ? NULL : (cdefault = (vala_ccode_node_unref (cdefault), NULL));
	}
	_tmp21 = NULL;
	return (_tmp21 = (ValaCCodeStatement*) vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccheck), (ccheck == NULL) ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL)), _tmp21);
}


gint vala_ccode_base_module_get_param_pos (ValaCCodeBaseModule* self, double param_pos, gboolean ellipsis) {
	g_return_val_if_fail (self != NULL, 0);
	if (!ellipsis) {
		if (param_pos >= 0) {
			return (gint) (param_pos * 1000);
		} else {
			return (gint) ((100 + param_pos) * 1000);
		}
	} else {
		if (param_pos >= 0) {
			return (gint) ((100 + param_pos) * 1000);
		} else {
			return (gint) ((200 + param_pos) * 1000);
		}
	}
}


ValaCCodeNode* vala_ccode_base_module_get_ccodenode (ValaCCodeBaseModule* self, ValaCodeNode* node) {
	ValaCCodeNode* _tmp0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	if (vala_code_node_get_ccodenode (node) == NULL) {
		vala_code_node_accept (node, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	}
	_tmp0 = NULL;
	return (_tmp0 = vala_code_node_get_ccodenode (node), (_tmp0 == NULL) ? NULL : vala_ccode_node_ref (_tmp0));
}


ValaCodeContext* vala_ccode_base_module_get_context (ValaCCodeBaseModule* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_context;
}


void vala_ccode_base_module_set_context (ValaCCodeBaseModule* self, ValaCodeContext* value) {
	ValaCodeContext* _tmp2;
	ValaCodeContext* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_context = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_code_context_ref (_tmp1)), (self->priv->_context == NULL) ? NULL : (self->priv->_context = (vala_code_context_unref (self->priv->_context), NULL)), _tmp2);
}


static void vala_ccode_base_module_class_init (ValaCCodeBaseModuleClass * klass) {
	vala_ccode_base_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->finalize = vala_ccode_base_module_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeBaseModulePrivate));
	VALA_CCODE_MODULE_CLASS (klass)->get_value_setter_function = vala_ccode_base_module_real_get_value_setter_function;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->append_vala_array_free = vala_ccode_base_module_real_append_vala_array_free;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->append_vala_array_move = vala_ccode_base_module_real_append_vala_array_move;
	VALA_CCODE_MODULE_CLASS (klass)->visit_source_file = vala_ccode_base_module_real_visit_source_file;
	VALA_CCODE_MODULE_CLASS (klass)->emit = vala_ccode_base_module_real_emit;
	VALA_CCODE_MODULE_CLASS (klass)->visit_enum = vala_ccode_base_module_real_visit_enum;
	VALA_CCODE_MODULE_CLASS (klass)->visit_enum_value = vala_ccode_base_module_real_visit_enum_value;
	VALA_CCODE_MODULE_CLASS (klass)->visit_member = vala_ccode_base_module_real_visit_member;
	VALA_CCODE_MODULE_CLASS (klass)->visit_constant = vala_ccode_base_module_real_visit_constant;
	VALA_CCODE_MODULE_CLASS (klass)->visit_field = vala_ccode_base_module_real_visit_field;
	VALA_CCODE_MODULE_CLASS (klass)->visit_formal_parameter = vala_ccode_base_module_real_visit_formal_parameter;
	VALA_CCODE_MODULE_CLASS (klass)->visit_property = vala_ccode_base_module_real_visit_property;
	VALA_CCODE_MODULE_CLASS (klass)->visit_property_accessor = vala_ccode_base_module_real_visit_property_accessor;
	VALA_CCODE_MODULE_CLASS (klass)->visit_destructor = vala_ccode_base_module_real_visit_destructor;
	VALA_CCODE_MODULE_CLASS (klass)->visit_block = vala_ccode_base_module_real_visit_block;
	VALA_CCODE_MODULE_CLASS (klass)->visit_empty_statement = vala_ccode_base_module_real_visit_empty_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_declaration_statement = vala_ccode_base_module_real_visit_declaration_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_local_variable = vala_ccode_base_module_real_visit_local_variable;
	VALA_CCODE_MODULE_CLASS (klass)->visit_initializer_list = vala_ccode_base_module_real_visit_initializer_list;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_dup_func_expression = vala_ccode_base_module_real_get_dup_func_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_end_full_expression = vala_ccode_base_module_real_visit_end_full_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_expression_statement = vala_ccode_base_module_real_visit_expression_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_return_statement = vala_ccode_base_module_real_visit_return_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_lock_statement = vala_ccode_base_module_real_visit_lock_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_delete_statement = vala_ccode_base_module_real_visit_delete_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_expression = vala_ccode_base_module_real_visit_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_boolean_literal = vala_ccode_base_module_real_visit_boolean_literal;
	VALA_CCODE_MODULE_CLASS (klass)->visit_character_literal = vala_ccode_base_module_real_visit_character_literal;
	VALA_CCODE_MODULE_CLASS (klass)->visit_integer_literal = vala_ccode_base_module_real_visit_integer_literal;
	VALA_CCODE_MODULE_CLASS (klass)->visit_real_literal = vala_ccode_base_module_real_visit_real_literal;
	VALA_CCODE_MODULE_CLASS (klass)->visit_string_literal = vala_ccode_base_module_real_visit_string_literal;
	VALA_CCODE_MODULE_CLASS (klass)->visit_null_literal = vala_ccode_base_module_real_visit_null_literal;
	VALA_CCODE_MODULE_CLASS (klass)->visit_parenthesized_expression = vala_ccode_base_module_real_visit_parenthesized_expression;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_delegate_target_cname = vala_ccode_base_module_real_get_delegate_target_cname;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_delegate_target_cexpression = vala_ccode_base_module_real_get_delegate_target_cexpression;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_delegate_target_destroy_notify_cname = vala_ccode_base_module_real_get_delegate_target_destroy_notify_cname;
	VALA_CCODE_MODULE_CLASS (klass)->visit_base_access = vala_ccode_base_module_real_visit_base_access;
	VALA_CCODE_MODULE_CLASS (klass)->visit_postfix_expression = vala_ccode_base_module_real_visit_postfix_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_object_creation_expression = vala_ccode_base_module_real_visit_object_creation_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_sizeof_expression = vala_ccode_base_module_real_visit_sizeof_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_typeof_expression = vala_ccode_base_module_real_visit_typeof_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_unary_expression = vala_ccode_base_module_real_visit_unary_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_cast_expression = vala_ccode_base_module_real_visit_cast_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_pointer_indirection = vala_ccode_base_module_real_visit_pointer_indirection;
	VALA_CCODE_MODULE_CLASS (klass)->visit_addressof_expression = vala_ccode_base_module_real_visit_addressof_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_reference_transfer_expression = vala_ccode_base_module_real_visit_reference_transfer_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_binary_expression = vala_ccode_base_module_real_visit_binary_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_type_check = vala_ccode_base_module_real_visit_type_check;
	VALA_CCODE_MODULE_CLASS (klass)->visit_lambda_expression = vala_ccode_base_module_real_visit_lambda_expression;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_implicit_cast_expression = vala_ccode_base_module_real_get_implicit_cast_expression;
}


static void vala_ccode_base_module_instance_init (ValaCCodeBaseModule * self) {
	self->priv = VALA_CCODE_BASE_MODULE_GET_PRIVATE (self);
	self->temp_vars = gee_array_list_new (VALA_TYPE_LOCAL_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->temp_ref_vars = gee_array_list_new (VALA_TYPE_LOCAL_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->next_temp_var_id = 0;
	self->in_creation_method = FALSE;
	self->in_constructor = FALSE;
	self->in_static_or_class_ctor = FALSE;
	self->current_method_inner_error = FALSE;
	self->next_coroutine_state = 1;
	self->in_plugin = FALSE;
	self->priv->variable_name_map = (GeeMap*) gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_direct_equal);
}


static void vala_ccode_base_module_finalize (ValaCCodeModule* obj) {
	ValaCCodeBaseModule * self;
	self = VALA_CCODE_BASE_MODULE (obj);
	(self->priv->_context == NULL) ? NULL : (self->priv->_context = (vala_code_context_unref (self->priv->_context), NULL));
	(self->root_symbol == NULL) ? NULL : (self->root_symbol = (vala_code_node_unref (self->root_symbol), NULL));
	(self->current_symbol == NULL) ? NULL : (self->current_symbol = (vala_code_node_unref (self->current_symbol), NULL));
	(self->current_type_symbol == NULL) ? NULL : (self->current_type_symbol = (vala_code_node_unref (self->current_type_symbol), NULL));
	(self->current_class == NULL) ? NULL : (self->current_class = (vala_code_node_unref (self->current_class), NULL));
	(self->current_method == NULL) ? NULL : (self->current_method = (vala_code_node_unref (self->current_method), NULL));
	(self->current_return_type == NULL) ? NULL : (self->current_return_type = (vala_code_node_unref (self->current_return_type), NULL));
	(self->current_try == NULL) ? NULL : (self->current_try = (vala_code_node_unref (self->current_try), NULL));
	(self->current_property_accessor == NULL) ? NULL : (self->current_property_accessor = (vala_code_node_unref (self->current_property_accessor), NULL));
	(self->header_begin == NULL) ? NULL : (self->header_begin = (vala_ccode_node_unref (self->header_begin), NULL));
	(self->header_type_declaration == NULL) ? NULL : (self->header_type_declaration = (vala_ccode_node_unref (self->header_type_declaration), NULL));
	(self->header_type_definition == NULL) ? NULL : (self->header_type_definition = (vala_ccode_node_unref (self->header_type_definition), NULL));
	(self->header_type_member_declaration == NULL) ? NULL : (self->header_type_member_declaration = (vala_ccode_node_unref (self->header_type_member_declaration), NULL));
	(self->header_constant_declaration == NULL) ? NULL : (self->header_constant_declaration = (vala_ccode_node_unref (self->header_constant_declaration), NULL));
	(self->source_begin == NULL) ? NULL : (self->source_begin = (vala_ccode_node_unref (self->source_begin), NULL));
	(self->source_include_directives == NULL) ? NULL : (self->source_include_directives = (vala_ccode_node_unref (self->source_include_directives), NULL));
	(self->source_type_declaration == NULL) ? NULL : (self->source_type_declaration = (vala_ccode_node_unref (self->source_type_declaration), NULL));
	(self->source_type_definition == NULL) ? NULL : (self->source_type_definition = (vala_ccode_node_unref (self->source_type_definition), NULL));
	(self->source_type_member_declaration == NULL) ? NULL : (self->source_type_member_declaration = (vala_ccode_node_unref (self->source_type_member_declaration), NULL));
	(self->source_constant_declaration == NULL) ? NULL : (self->source_constant_declaration = (vala_ccode_node_unref (self->source_constant_declaration), NULL));
	(self->source_signal_marshaller_declaration == NULL) ? NULL : (self->source_signal_marshaller_declaration = (vala_ccode_node_unref (self->source_signal_marshaller_declaration), NULL));
	(self->source_type_member_definition == NULL) ? NULL : (self->source_type_member_definition = (vala_ccode_node_unref (self->source_type_member_definition), NULL));
	(self->class_init_fragment == NULL) ? NULL : (self->class_init_fragment = (vala_ccode_node_unref (self->class_init_fragment), NULL));
	(self->instance_init_fragment == NULL) ? NULL : (self->instance_init_fragment = (vala_ccode_node_unref (self->instance_init_fragment), NULL));
	(self->instance_finalize_fragment == NULL) ? NULL : (self->instance_finalize_fragment = (vala_ccode_node_unref (self->instance_finalize_fragment), NULL));
	(self->source_signal_marshaller_definition == NULL) ? NULL : (self->source_signal_marshaller_definition = (vala_ccode_node_unref (self->source_signal_marshaller_definition), NULL));
	(self->module_init_fragment == NULL) ? NULL : (self->module_init_fragment = (vala_ccode_node_unref (self->module_init_fragment), NULL));
	(self->param_spec_struct == NULL) ? NULL : (self->param_spec_struct = (vala_ccode_node_unref (self->param_spec_struct), NULL));
	(self->instance_struct == NULL) ? NULL : (self->instance_struct = (vala_ccode_node_unref (self->instance_struct), NULL));
	(self->type_struct == NULL) ? NULL : (self->type_struct = (vala_ccode_node_unref (self->type_struct), NULL));
	(self->instance_priv_struct == NULL) ? NULL : (self->instance_priv_struct = (vala_ccode_node_unref (self->instance_priv_struct), NULL));
	(self->prop_enum == NULL) ? NULL : (self->prop_enum = (vala_ccode_node_unref (self->prop_enum), NULL));
	(self->cenum == NULL) ? NULL : (self->cenum = (vala_ccode_node_unref (self->cenum), NULL));
	(self->function == NULL) ? NULL : (self->function = (vala_ccode_node_unref (self->function), NULL));
	(self->block == NULL) ? NULL : (self->block = (vala_ccode_node_unref (self->block), NULL));
	(self->temp_vars == NULL) ? NULL : (self->temp_vars = (gee_collection_object_unref (self->temp_vars), NULL));
	(self->temp_ref_vars == NULL) ? NULL : (self->temp_ref_vars = (gee_collection_object_unref (self->temp_ref_vars), NULL));
	(self->user_marshal_set == NULL) ? NULL : (self->user_marshal_set = (gee_collection_object_unref (self->user_marshal_set), NULL));
	(self->predefined_marshal_set == NULL) ? NULL : (self->predefined_marshal_set = (gee_collection_object_unref (self->predefined_marshal_set), NULL));
	(self->c_keywords == NULL) ? NULL : (self->c_keywords = (gee_collection_object_unref (self->c_keywords), NULL));
	(self->bool_type == NULL) ? NULL : (self->bool_type = (vala_code_node_unref (self->bool_type), NULL));
	(self->char_type == NULL) ? NULL : (self->char_type = (vala_code_node_unref (self->char_type), NULL));
	(self->uchar_type == NULL) ? NULL : (self->uchar_type = (vala_code_node_unref (self->uchar_type), NULL));
	(self->unichar_type == NULL) ? NULL : (self->unichar_type = (vala_code_node_unref (self->unichar_type), NULL));
	(self->short_type == NULL) ? NULL : (self->short_type = (vala_code_node_unref (self->short_type), NULL));
	(self->ushort_type == NULL) ? NULL : (self->ushort_type = (vala_code_node_unref (self->ushort_type), NULL));
	(self->int_type == NULL) ? NULL : (self->int_type = (vala_code_node_unref (self->int_type), NULL));
	(self->uint_type == NULL) ? NULL : (self->uint_type = (vala_code_node_unref (self->uint_type), NULL));
	(self->long_type == NULL) ? NULL : (self->long_type = (vala_code_node_unref (self->long_type), NULL));
	(self->ulong_type == NULL) ? NULL : (self->ulong_type = (vala_code_node_unref (self->ulong_type), NULL));
	(self->int8_type == NULL) ? NULL : (self->int8_type = (vala_code_node_unref (self->int8_type), NULL));
	(self->uint8_type == NULL) ? NULL : (self->uint8_type = (vala_code_node_unref (self->uint8_type), NULL));
	(self->int32_type == NULL) ? NULL : (self->int32_type = (vala_code_node_unref (self->int32_type), NULL));
	(self->uint32_type == NULL) ? NULL : (self->uint32_type = (vala_code_node_unref (self->uint32_type), NULL));
	(self->int64_type == NULL) ? NULL : (self->int64_type = (vala_code_node_unref (self->int64_type), NULL));
	(self->uint64_type == NULL) ? NULL : (self->uint64_type = (vala_code_node_unref (self->uint64_type), NULL));
	(self->string_type == NULL) ? NULL : (self->string_type = (vala_code_node_unref (self->string_type), NULL));
	(self->float_type == NULL) ? NULL : (self->float_type = (vala_code_node_unref (self->float_type), NULL));
	(self->double_type == NULL) ? NULL : (self->double_type = (vala_code_node_unref (self->double_type), NULL));
	(self->gtype_type == NULL) ? NULL : (self->gtype_type = (vala_code_node_unref (self->gtype_type), NULL));
	(self->gobject_type == NULL) ? NULL : (self->gobject_type = (vala_code_node_unref (self->gobject_type), NULL));
	(self->gerror_type == NULL) ? NULL : (self->gerror_type = (vala_code_node_unref (self->gerror_type), NULL));
	(self->glist_type == NULL) ? NULL : (self->glist_type = (vala_code_node_unref (self->glist_type), NULL));
	(self->gslist_type == NULL) ? NULL : (self->gslist_type = (vala_code_node_unref (self->gslist_type), NULL));
	(self->gstringbuilder_type == NULL) ? NULL : (self->gstringbuilder_type = (vala_code_node_unref (self->gstringbuilder_type), NULL));
	(self->garray_type == NULL) ? NULL : (self->garray_type = (vala_code_node_unref (self->garray_type), NULL));
	(self->gquark_type == NULL) ? NULL : (self->gquark_type = (vala_code_node_unref (self->gquark_type), NULL));
	(self->gvalue_type == NULL) ? NULL : (self->gvalue_type = (vala_code_node_unref (self->gvalue_type), NULL));
	(self->mutex_type == NULL) ? NULL : (self->mutex_type = (vala_code_node_unref (self->mutex_type), NULL));
	(self->type_module_type == NULL) ? NULL : (self->type_module_type = (vala_code_node_unref (self->type_module_type), NULL));
	(self->list_type == NULL) ? NULL : (self->list_type = (vala_code_node_unref (self->list_type), NULL));
	(self->map_type == NULL) ? NULL : (self->map_type = (vala_code_node_unref (self->map_type), NULL));
	(self->dbus_object_type == NULL) ? NULL : (self->dbus_object_type = (vala_code_node_unref (self->dbus_object_type), NULL));
	(self->substring_method == NULL) ? NULL : (self->substring_method = (vala_code_node_unref (self->substring_method), NULL));
	self->module_init_param_name = (g_free (self->module_init_param_name), NULL);
	(self->wrappers == NULL) ? NULL : (self->wrappers = (gee_collection_object_unref (self->wrappers), NULL));
	(self->priv->variable_name_map == NULL) ? NULL : (self->priv->variable_name_map = (gee_collection_object_unref (self->priv->variable_name_map), NULL));
	VALA_CCODE_MODULE_CLASS (vala_ccode_base_module_parent_class)->finalize (obj);
}


GType vala_ccode_base_module_get_type (void) {
	static GType vala_ccode_base_module_type_id = 0;
	if (vala_ccode_base_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeBaseModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_base_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeBaseModule), 0, (GInstanceInitFunc) vala_ccode_base_module_instance_init, NULL };
		vala_ccode_base_module_type_id = g_type_register_static (VALA_TYPE_CCODE_MODULE, "ValaCCodeBaseModule", &g_define_type_info, 0);
	}
	return vala_ccode_base_module_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




