/* valaarraytype.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaarraytype.h>
#include <vala/valacodenode.h>
#include <vala/valaarraylengthfield.h>
#include <vala/valaarrayresizemethod.h>
#include <vala/valaarraymovemethod.h>
#include <vala/valasourcefile.h>
#include <vala/valacodecontext.h>
#include <vala/valanamespace.h>
#include <vala/valavaluetype.h>
#include <vala/valatypesymbol.h>
#include <vala/valafield.h>
#include <vala/valamethod.h>
#include <vala/valavoidtype.h>
#include <vala/valaformalparameter.h>
#include <vala/valapointertype.h>




struct _ValaArrayTypePrivate {
	gint _rank;
	ValaDataType* _element_type;
	ValaArrayLengthField* length_field;
	ValaArrayResizeMethod* resize_method;
	ValaArrayMoveMethod* move_method;
};

#define VALA_ARRAY_TYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ARRAY_TYPE, ValaArrayTypePrivate))
enum  {
	VALA_ARRAY_TYPE_DUMMY_PROPERTY
};
static ValaSymbol* vala_array_type_real_get_member (ValaDataType* base, const char* member_name);
static ValaArrayLengthField* vala_array_type_get_length_field (ValaArrayType* self);
static ValaArrayResizeMethod* vala_array_type_get_resize_method (ValaArrayType* self);
static ValaArrayMoveMethod* vala_array_type_get_move_method (ValaArrayType* self);
static ValaDataType* vala_array_type_real_copy (ValaDataType* base);
static char* vala_array_type_real_get_cname (ValaDataType* base);
static gboolean vala_array_type_real_is_array (ValaDataType* base);
static char* vala_array_type_real_to_qualified_string (ValaDataType* base, ValaScope* scope);
static gboolean vala_array_type_real_compatible (ValaDataType* base, ValaDataType* target_type);
static gboolean vala_array_type_real_is_reference_type_or_type_parameter (ValaDataType* base);
static char* vala_array_type_real_get_type_signature (ValaDataType* base);
static void vala_array_type_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_array_type_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static GeeList* vala_array_type_real_get_symbols (ValaDataType* base);
static gpointer vala_array_type_parent_class = NULL;
static void vala_array_type_finalize (ValaCodeNode* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaArrayType* vala_array_type_construct (GType object_type, ValaDataType* element_type, gint rank, ValaSourceReference* source_reference) {
	ValaArrayType* self;
	g_return_val_if_fail (element_type != NULL, NULL);
	self = (ValaArrayType*) g_type_create_instance (object_type);
	vala_array_type_set_element_type (self, element_type);
	vala_array_type_set_rank (self, rank);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaArrayType* vala_array_type_new (ValaDataType* element_type, gint rank, ValaSourceReference* source_reference) {
	return vala_array_type_construct (VALA_TYPE_ARRAY_TYPE, element_type, rank, source_reference);
}


static ValaSymbol* vala_array_type_real_get_member (ValaDataType* base, const char* member_name) {
	ValaArrayType * self;
	self = (ValaArrayType*) base;
	g_return_val_if_fail (member_name != NULL, NULL);
	if (_vala_strcmp0 (member_name, "length") == 0) {
		return (ValaSymbol*) vala_array_type_get_length_field (self);
	} else {
		if (_vala_strcmp0 (member_name, "move") == 0) {
			return (ValaSymbol*) vala_array_type_get_move_method (self);
		} else {
			if (_vala_strcmp0 (member_name, "resize") == 0) {
				return (ValaSymbol*) vala_array_type_get_resize_method (self);
			}
		}
	}
	return NULL;
}


static ValaArrayLengthField* vala_array_type_get_length_field (ValaArrayType* self) {
	ValaArrayLengthField* _tmp7;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->length_field == NULL) {
		ValaArrayLengthField* _tmp0;
		ValaNamespace* _tmp1;
		ValaNamespace* root_symbol;
		_tmp0 = NULL;
		self->priv->length_field = (_tmp0 = vala_array_length_field_new (vala_code_node_get_source_reference ((ValaCodeNode*) self)), (self->priv->length_field == NULL) ? NULL : (self->priv->length_field = (vala_code_node_unref (self->priv->length_field), NULL)), _tmp0);
		vala_symbol_set_access ((ValaSymbol*) self->priv->length_field, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp1 = NULL;
		root_symbol = (_tmp1 = vala_code_context_get_root (vala_source_file_get_context (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) self)))), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
		if (self->priv->_rank > 1) {
			ValaTypeSymbol* _tmp2;
			ValaValueType* _tmp3;
			ValaValueType* integer;
			ValaArrayType* _tmp4;
			/* length is an int[] containing the dimensions of the array, starting at 0*/
			_tmp2 = NULL;
			_tmp3 = NULL;
			integer = (_tmp3 = vala_value_type_new (_tmp2 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) root_symbol), "int"))), (_tmp2 == NULL) ? NULL : (_tmp2 = (vala_code_node_unref (_tmp2), NULL)), _tmp3);
			_tmp4 = NULL;
			vala_field_set_field_type ((ValaField*) self->priv->length_field, (ValaDataType*) (_tmp4 = vala_array_type_new ((ValaDataType*) integer, 1, vala_code_node_get_source_reference ((ValaCodeNode*) self))));
			(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_code_node_unref (_tmp4), NULL));
			(integer == NULL) ? NULL : (integer = (vala_code_node_unref (integer), NULL));
		} else {
			ValaValueType* _tmp6;
			ValaTypeSymbol* _tmp5;
			_tmp6 = NULL;
			_tmp5 = NULL;
			vala_field_set_field_type ((ValaField*) self->priv->length_field, (ValaDataType*) (_tmp6 = vala_value_type_new (_tmp5 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) root_symbol), "int")))));
			(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_code_node_unref (_tmp6), NULL));
			(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_code_node_unref (_tmp5), NULL));
		}
		(root_symbol == NULL) ? NULL : (root_symbol = (vala_code_node_unref (root_symbol), NULL));
	}
	_tmp7 = NULL;
	return (_tmp7 = self->priv->length_field, (_tmp7 == NULL) ? NULL : vala_code_node_ref (_tmp7));
}


static ValaArrayResizeMethod* vala_array_type_get_resize_method (ValaArrayType* self) {
	ValaArrayResizeMethod* _tmp6;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->resize_method == NULL) {
		ValaArrayResizeMethod* _tmp0;
		ValaVoidType* _tmp1;
		ValaNamespace* _tmp2;
		ValaNamespace* root_symbol;
		ValaTypeSymbol* _tmp3;
		ValaValueType* _tmp4;
		ValaValueType* int_type;
		ValaFormalParameter* _tmp5;
		_tmp0 = NULL;
		self->priv->resize_method = (_tmp0 = vala_array_resize_method_new (vala_code_node_get_source_reference ((ValaCodeNode*) self)), (self->priv->resize_method == NULL) ? NULL : (self->priv->resize_method = (vala_code_node_unref (self->priv->resize_method), NULL)), _tmp0);
		_tmp1 = NULL;
		vala_method_set_return_type ((ValaMethod*) self->priv->resize_method, (ValaDataType*) (_tmp1 = vala_void_type_new ()));
		(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_code_node_unref (_tmp1), NULL));
		vala_symbol_set_access ((ValaSymbol*) self->priv->resize_method, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		vala_method_set_cname ((ValaMethod*) self->priv->resize_method, "g_renew");
		_tmp2 = NULL;
		root_symbol = (_tmp2 = vala_code_context_get_root (vala_source_file_get_context (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) self)))), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
		_tmp3 = NULL;
		_tmp4 = NULL;
		int_type = (_tmp4 = vala_value_type_new (_tmp3 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) root_symbol), "int"))), (_tmp3 == NULL) ? NULL : (_tmp3 = (vala_code_node_unref (_tmp3), NULL)), _tmp4);
		_tmp5 = NULL;
		vala_method_add_parameter ((ValaMethod*) self->priv->resize_method, _tmp5 = vala_formal_parameter_new ("length", (ValaDataType*) int_type, NULL));
		(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_code_node_unref (_tmp5), NULL));
		vala_method_set_returns_modified_pointer ((ValaMethod*) self->priv->resize_method, TRUE);
		(root_symbol == NULL) ? NULL : (root_symbol = (vala_code_node_unref (root_symbol), NULL));
		(int_type == NULL) ? NULL : (int_type = (vala_code_node_unref (int_type), NULL));
	}
	_tmp6 = NULL;
	return (_tmp6 = self->priv->resize_method, (_tmp6 == NULL) ? NULL : vala_code_node_ref (_tmp6));
}


static ValaArrayMoveMethod* vala_array_type_get_move_method (ValaArrayType* self) {
	ValaArrayMoveMethod* _tmp8;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->move_method == NULL) {
		ValaArrayMoveMethod* _tmp0;
		ValaVoidType* _tmp1;
		ValaNamespace* _tmp2;
		ValaNamespace* root_symbol;
		ValaTypeSymbol* _tmp3;
		ValaValueType* _tmp4;
		ValaValueType* int_type;
		ValaFormalParameter* _tmp5;
		ValaFormalParameter* _tmp6;
		ValaFormalParameter* _tmp7;
		_tmp0 = NULL;
		self->priv->move_method = (_tmp0 = vala_array_move_method_new (vala_code_node_get_source_reference ((ValaCodeNode*) self)), (self->priv->move_method == NULL) ? NULL : (self->priv->move_method = (vala_code_node_unref (self->priv->move_method), NULL)), _tmp0);
		_tmp1 = NULL;
		vala_method_set_return_type ((ValaMethod*) self->priv->move_method, (ValaDataType*) (_tmp1 = vala_void_type_new ()));
		(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_code_node_unref (_tmp1), NULL));
		vala_symbol_set_access ((ValaSymbol*) self->priv->move_method, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		vala_method_set_cname ((ValaMethod*) self->priv->move_method, "_vala_array_move");
		_tmp2 = NULL;
		root_symbol = (_tmp2 = vala_code_context_get_root (vala_source_file_get_context (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) self)))), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
		_tmp3 = NULL;
		_tmp4 = NULL;
		int_type = (_tmp4 = vala_value_type_new (_tmp3 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) root_symbol), "int"))), (_tmp3 == NULL) ? NULL : (_tmp3 = (vala_code_node_unref (_tmp3), NULL)), _tmp4);
		_tmp5 = NULL;
		vala_method_add_parameter ((ValaMethod*) self->priv->move_method, _tmp5 = vala_formal_parameter_new ("src", (ValaDataType*) int_type, NULL));
		(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_code_node_unref (_tmp5), NULL));
		_tmp6 = NULL;
		vala_method_add_parameter ((ValaMethod*) self->priv->move_method, _tmp6 = vala_formal_parameter_new ("dest", (ValaDataType*) int_type, NULL));
		(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_code_node_unref (_tmp6), NULL));
		_tmp7 = NULL;
		vala_method_add_parameter ((ValaMethod*) self->priv->move_method, _tmp7 = vala_formal_parameter_new ("length", (ValaDataType*) int_type, NULL));
		(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_code_node_unref (_tmp7), NULL));
		(root_symbol == NULL) ? NULL : (root_symbol = (vala_code_node_unref (root_symbol), NULL));
		(int_type == NULL) ? NULL : (int_type = (vala_code_node_unref (int_type), NULL));
	}
	_tmp8 = NULL;
	return (_tmp8 = self->priv->move_method, (_tmp8 == NULL) ? NULL : vala_code_node_ref (_tmp8));
}


static ValaDataType* vala_array_type_real_copy (ValaDataType* base) {
	ValaArrayType * self;
	ValaDataType* _tmp0;
	ValaArrayType* _tmp1;
	ValaArrayType* result;
	self = (ValaArrayType*) base;
	_tmp0 = NULL;
	_tmp1 = NULL;
	result = (_tmp1 = vala_array_type_new (_tmp0 = vala_data_type_copy (vala_array_type_get_element_type (self)), self->priv->_rank, vala_code_node_get_source_reference ((ValaCodeNode*) self)), (_tmp0 == NULL) ? NULL : (_tmp0 = (vala_code_node_unref (_tmp0), NULL)), _tmp1);
	vala_data_type_set_value_owned ((ValaDataType*) result, vala_data_type_get_value_owned ((ValaDataType*) self));
	vala_data_type_set_nullable ((ValaDataType*) result, vala_data_type_get_nullable ((ValaDataType*) self));
	vala_data_type_set_floating_reference ((ValaDataType*) result, vala_data_type_get_floating_reference ((ValaDataType*) self));
	return (ValaDataType*) result;
}


static char* vala_array_type_real_get_cname (ValaDataType* base) {
	ValaArrayType * self;
	char* _tmp0;
	char* _tmp1;
	self = (ValaArrayType*) base;
	/* FIXME add support for [Immutable] or [Const] attribute to support arrays to const data*/
	_tmp0 = NULL;
	_tmp1 = NULL;
	return (_tmp1 = g_strconcat (_tmp0 = vala_data_type_get_cname (vala_array_type_get_element_type (self)), "*", NULL), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
}


static gboolean vala_array_type_real_is_array (ValaDataType* base) {
	ValaArrayType * self;
	self = (ValaArrayType*) base;
	return TRUE;
}


static char* vala_array_type_real_to_qualified_string (ValaDataType* base, ValaScope* scope) {
	ValaArrayType * self;
	const char* _tmp0;
	char* _tmp2;
	char* _tmp1;
	char* _tmp3;
	self = (ValaArrayType*) base;
	_tmp0 = NULL;
	if (vala_data_type_get_nullable ((ValaDataType*) self)) {
		_tmp0 = "?";
	} else {
		_tmp0 = "";
	}
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp3 = NULL;
	return (_tmp3 = g_strdup_printf ("%s[%s]%s", _tmp1 = vala_data_type_to_qualified_string (vala_array_type_get_element_type (self), scope), _tmp2 = g_strnfill ((gulong) (self->priv->_rank - 1), ','), _tmp0), _tmp2 = (g_free (_tmp2), NULL), _tmp1 = (g_free (_tmp1), NULL), _tmp3);
}


static gboolean vala_array_type_real_compatible (ValaDataType* base, ValaDataType* target_type) {
	ValaArrayType * self;
	gboolean _tmp0;
	ValaArrayType* _tmp6;
	ValaDataType* _tmp5;
	ValaArrayType* target_array_type;
	gboolean _tmp8;
	gboolean _tmp10;
	self = (ValaArrayType*) base;
	g_return_val_if_fail (target_type != NULL, FALSE);
	_tmp0 = FALSE;
	if (VALA_IS_POINTER_TYPE (target_type)) {
		_tmp0 = TRUE;
	} else {
		gboolean _tmp1;
		_tmp1 = FALSE;
		if (vala_data_type_get_data_type (target_type) != NULL) {
			ValaAttribute* _tmp2;
			_tmp2 = NULL;
			_tmp1 = (_tmp2 = vala_code_node_get_attribute ((ValaCodeNode*) vala_data_type_get_data_type (target_type), "PointerType")) != NULL;
			(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_code_node_unref (_tmp2), NULL));
		} else {
			_tmp1 = FALSE;
		}
		_tmp0 = (_tmp1);
	}
	if (_tmp0) {
		/* any array type can be cast to a generic pointer */
		return TRUE;
	}
	/* temporarily ignore type parameters */
	if (vala_data_type_get_type_parameter (target_type) != NULL) {
		return TRUE;
	}
	_tmp6 = NULL;
	_tmp5 = NULL;
	target_array_type = (_tmp6 = (_tmp5 = target_type, VALA_IS_ARRAY_TYPE (_tmp5) ? ((ValaArrayType*) _tmp5) : NULL), (_tmp6 == NULL) ? NULL : vala_code_node_ref (_tmp6));
	if (target_array_type == NULL) {
		gboolean _tmp7;
		return (_tmp7 = FALSE, (target_array_type == NULL) ? NULL : (target_array_type = (vala_code_node_unref (target_array_type), NULL)), _tmp7);
	}
	_tmp8 = FALSE;
	if (vala_data_type_compatible (vala_array_type_get_element_type (self), vala_array_type_get_element_type (target_array_type))) {
		_tmp8 = vala_data_type_compatible (vala_array_type_get_element_type (target_array_type), vala_array_type_get_element_type (self));
	} else {
		_tmp8 = FALSE;
	}
	if (_tmp8) {
		gboolean _tmp9;
		return (_tmp9 = TRUE, (target_array_type == NULL) ? NULL : (target_array_type = (vala_code_node_unref (target_array_type), NULL)), _tmp9);
	}
	return (_tmp10 = FALSE, (target_array_type == NULL) ? NULL : (target_array_type = (vala_code_node_unref (target_array_type), NULL)), _tmp10);
}


static gboolean vala_array_type_real_is_reference_type_or_type_parameter (ValaDataType* base) {
	ValaArrayType * self;
	self = (ValaArrayType*) base;
	return TRUE;
}


static char* vala_array_type_real_get_type_signature (ValaDataType* base) {
	ValaArrayType * self;
	char* element_type_signature;
	char* _tmp1;
	self = (ValaArrayType*) base;
	element_type_signature = vala_data_type_get_type_signature (vala_array_type_get_element_type (self));
	if (element_type_signature == NULL) {
		char* _tmp0;
		_tmp0 = NULL;
		return (_tmp0 = NULL, element_type_signature = (g_free (element_type_signature), NULL), _tmp0);
	}
	_tmp1 = NULL;
	return (_tmp1 = g_strconcat ("a", element_type_signature, NULL), element_type_signature = (g_free (element_type_signature), NULL), _tmp1);
}


static void vala_array_type_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaArrayType * self;
	self = (ValaArrayType*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_node_accept ((ValaCodeNode*) vala_array_type_get_element_type (self), visitor);
}


static void vala_array_type_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaArrayType * self;
	self = (ValaArrayType*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	if (vala_array_type_get_element_type (self) == old_type) {
		vala_array_type_set_element_type (self, new_type);
	}
}


static GeeList* vala_array_type_real_get_symbols (ValaDataType* base) {
	ValaArrayType * self;
	self = (ValaArrayType*) base;
	return vala_data_type_get_symbols (vala_array_type_get_element_type (self));
}


ValaDataType* vala_array_type_get_element_type (ValaArrayType* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_element_type;
}


void vala_array_type_set_element_type (ValaArrayType* self, ValaDataType* value) {
	ValaDataType* _tmp2;
	ValaDataType* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_element_type = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (self->priv->_element_type == NULL) ? NULL : (self->priv->_element_type = (vala_code_node_unref (self->priv->_element_type), NULL)), _tmp2);
	vala_code_node_set_parent_node ((ValaCodeNode*) self->priv->_element_type, (ValaCodeNode*) self);
}


gint vala_array_type_get_rank (ValaArrayType* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_rank;
}


void vala_array_type_set_rank (ValaArrayType* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_rank = value;
}


static void vala_array_type_class_init (ValaArrayTypeClass * klass) {
	vala_array_type_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_array_type_finalize;
	g_type_class_add_private (klass, sizeof (ValaArrayTypePrivate));
	VALA_DATA_TYPE_CLASS (klass)->get_member = vala_array_type_real_get_member;
	VALA_DATA_TYPE_CLASS (klass)->copy = vala_array_type_real_copy;
	VALA_DATA_TYPE_CLASS (klass)->get_cname = vala_array_type_real_get_cname;
	VALA_DATA_TYPE_CLASS (klass)->is_array = vala_array_type_real_is_array;
	VALA_DATA_TYPE_CLASS (klass)->to_qualified_string = vala_array_type_real_to_qualified_string;
	VALA_DATA_TYPE_CLASS (klass)->compatible = vala_array_type_real_compatible;
	VALA_DATA_TYPE_CLASS (klass)->is_reference_type_or_type_parameter = vala_array_type_real_is_reference_type_or_type_parameter;
	VALA_DATA_TYPE_CLASS (klass)->get_type_signature = vala_array_type_real_get_type_signature;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_array_type_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_array_type_real_replace_type;
	VALA_DATA_TYPE_CLASS (klass)->get_symbols = vala_array_type_real_get_symbols;
}


static void vala_array_type_instance_init (ValaArrayType * self) {
	self->priv = VALA_ARRAY_TYPE_GET_PRIVATE (self);
}


static void vala_array_type_finalize (ValaCodeNode* obj) {
	ValaArrayType * self;
	self = VALA_ARRAY_TYPE (obj);
	(self->priv->_element_type == NULL) ? NULL : (self->priv->_element_type = (vala_code_node_unref (self->priv->_element_type), NULL));
	(self->priv->length_field == NULL) ? NULL : (self->priv->length_field = (vala_code_node_unref (self->priv->length_field), NULL));
	(self->priv->resize_method == NULL) ? NULL : (self->priv->resize_method = (vala_code_node_unref (self->priv->resize_method), NULL));
	(self->priv->move_method == NULL) ? NULL : (self->priv->move_method = (vala_code_node_unref (self->priv->move_method), NULL));
	VALA_CODE_NODE_CLASS (vala_array_type_parent_class)->finalize (obj);
}


GType vala_array_type_get_type (void) {
	static GType vala_array_type_type_id = 0;
	if (vala_array_type_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaArrayTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_array_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaArrayType), 0, (GInstanceInitFunc) vala_array_type_instance_init, NULL };
		vala_array_type_type_id = g_type_register_static (VALA_TYPE_REFERENCE_TYPE, "ValaArrayType", &g_define_type_info, 0);
	}
	return vala_array_type_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




