/* valaccodemethodmodule.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodemethodmodule.h>
#include <vala/valaclass.h>
#include <vala/valatypesymbol.h>
#include <vala/valaobjecttype.h>
#include <vala/valaobjecttypesymbol.h>
#include <vala/valacodenode.h>
#include <vala/valacodevisitor.h>
#include <ccode/valaccodeblock.h>
#include <vala/valablock.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valaexpressionstatement.h>
#include <vala/valaproperty.h>
#include <vala/valapropertyaccessor.h>
#include <ccode/valaccodefragment.h>
#include <ccode/valaccodenode.h>
#include <gee/collection.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodecastexpression.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodedeclarator.h>
#include <vala/valasymbol.h>
#include <vala/valaattribute.h>
#include <ccode/valaccodemodifiers.h>
#include <gee/hashmap.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodestruct.h>
#include <float.h>
#include <math.h>
#include <vala/valamember.h>
#include <vala/valastruct.h>
#include <vala/valainterface.h>
#include <vala/valavaluetype.h>
#include <vala/valaclasstype.h>
#include <vala/valatypeparameter.h>
#include <vala/valaformalparameter.h>
#include <vala/valaarraytype.h>
#include <vala/valadelegatetype.h>
#include <vala/valadelegate.h>
#include <vala/valamethodtype.h>
#include <ccode/valaccodeswitchstatement.h>
#include <ccode/valaccodememberaccess.h>
#include <ccode/valaccodecasestatement.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodereturnstatement.h>
#include <vala/valareferencetype.h>
#include <vala/valaexpression.h>
#include <ccode/valaccodestatement.h>
#include <vala/valacodecontext.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodeunaryexpression.h>
#include <vala/valasourcereference.h>
#include <ccode/valaccodecomment.h>
#include <vala/valapointertype.h>
#include <vala/valavoidtype.h>
#include <vala/valastatement.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodewhilestatement.h>
#include <gobject/valaccodebasemodule.h>




enum  {
	VALA_CCODE_METHOD_MODULE_DUMMY_PROPERTY
};
static gboolean vala_ccode_method_module_real_method_has_wrapper (ValaCCodeModule* base, ValaMethod* method);
static char* vala_ccode_method_module_real_get_custom_creturn_type (ValaCCodeModule* base, ValaMethod* m);
static char* vala_ccode_method_module_get_creturn_type (ValaCCodeMethodModule* self, ValaMethod* m, const char* default_value);
static void vala_ccode_method_module_real_visit_method (ValaCCodeModule* base, ValaMethod* m);
static void vala_ccode_method_module_real_generate_cparameters (ValaCCodeModule* base, ValaMethod* m, ValaDataType* creturn_type, gboolean in_gtypeinstance_creation_method, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
static ValaCCodeStatement* vala_ccode_method_module_create_method_type_check_statement (ValaCCodeMethodModule* self, ValaMethod* m, ValaDataType* return_type, ValaTypeSymbol* t, gboolean non_null, const char* var_name);
static ValaCCodeStatement* vala_ccode_method_module_create_precondition_statement (ValaCCodeMethodModule* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaExpression* precondition);
static ValaCCodeStatement* vala_ccode_method_module_create_postcondition_statement (ValaCCodeMethodModule* self, ValaExpression* postcondition);
static ValaTypeSymbol* vala_ccode_method_module_find_parent_type (ValaCCodeMethodModule* self, ValaSymbol* sym);
static void vala_ccode_method_module_add_object_creation (ValaCCodeMethodModule* self, ValaCCodeBlock* b, gboolean has_params);
static void vala_ccode_method_module_real_visit_creation_method (ValaCCodeModule* base, ValaCreationMethod* m);
static gpointer vala_ccode_method_module_parent_class = NULL;



ValaCCodeMethodModule* vala_ccode_method_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeMethodModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaCCodeMethodModule*) vala_ccode_struct_module_construct (object_type, codegen, next);
	return self;
}


ValaCCodeMethodModule* vala_ccode_method_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_method_module_construct (VALA_TYPE_CCODE_METHOD_MODULE, codegen, next);
}


static gboolean vala_ccode_method_module_real_method_has_wrapper (ValaCCodeModule* base, ValaMethod* method) {
	ValaCCodeMethodModule * self;
	ValaAttribute* _tmp0;
	gboolean _tmp1;
	self = (ValaCCodeMethodModule*) base;
	g_return_val_if_fail (method != NULL, FALSE);
	_tmp0 = NULL;
	return (_tmp1 = ((_tmp0 = vala_code_node_get_attribute ((ValaCodeNode*) method, "NoWrapper")) == NULL), (_tmp0 == NULL) ? NULL : (_tmp0 = (vala_code_node_unref (_tmp0), NULL)), _tmp1);
}


static char* vala_ccode_method_module_real_get_custom_creturn_type (ValaCCodeModule* base, ValaMethod* m) {
	ValaCCodeMethodModule * self;
	ValaAttribute* attr;
	char* _tmp1;
	self = (ValaCCodeMethodModule*) base;
	g_return_val_if_fail (m != NULL, NULL);
	attr = vala_code_node_get_attribute ((ValaCodeNode*) m, "CCode");
	if (attr != NULL) {
		char* type;
		type = vala_attribute_get_string (attr, "type");
		if (type != NULL) {
			char* _tmp0;
			_tmp0 = NULL;
			return (_tmp0 = type, (attr == NULL) ? NULL : (attr = (vala_code_node_unref (attr), NULL)), _tmp0);
		}
		type = (g_free (type), NULL);
	}
	_tmp1 = NULL;
	return (_tmp1 = NULL, (attr == NULL) ? NULL : (attr = (vala_code_node_unref (attr), NULL)), _tmp1);
}


static char* vala_ccode_method_module_get_creturn_type (ValaCCodeMethodModule* self, ValaMethod* m, const char* default_value) {
	char* type;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	g_return_val_if_fail (default_value != NULL, NULL);
	type = vala_ccode_module_get_custom_creturn_type ((ValaCCodeModule*) self, m);
	if (type == NULL) {
		const char* _tmp0;
		char* _tmp1;
		_tmp0 = NULL;
		_tmp1 = NULL;
		return (_tmp1 = (_tmp0 = default_value, (_tmp0 == NULL) ? NULL : g_strdup (_tmp0)), type = (g_free (type), NULL), _tmp1);
	}
	return type;
}


static void vala_ccode_method_module_real_visit_method (ValaCCodeModule* base, ValaMethod* m) {
	ValaCCodeMethodModule * self;
	ValaMethod* _tmp0;
	ValaMethod* old_method;
	ValaDataType* _tmp1;
	ValaDataType* old_return_type;
	gboolean old_method_inner_error;
	gint old_next_temp_var_id;
	ValaSymbol* _tmp3;
	ValaSymbol* _tmp2;
	ValaMethod* _tmp5;
	ValaMethod* _tmp4;
	ValaDataType* _tmp7;
	ValaDataType* _tmp6;
	gboolean in_gtypeinstance_creation_method;
	gboolean in_gobject_creation_method;
	gboolean in_fundamental_creation_method;
	ValaDataType* _tmp8;
	ValaDataType* creturn_type;
	gboolean inner_error;
	ValaSymbol* _tmp35;
	ValaSymbol* _tmp34;
	ValaMethod* _tmp37;
	ValaMethod* _tmp36;
	ValaDataType* _tmp39;
	ValaDataType* _tmp38;
	ValaCCodeFunction* _tmp43;
	char* _tmp42;
	char* _tmp41;
	char* _tmp40;
	GeeHashMap* cparam_map;
	ValaCCodeFunctionDeclarator* vdeclarator;
	gboolean _tmp44;
	gboolean visible;
	gboolean _tmp49;
	gboolean _tmp234;
	self = (ValaCCodeMethodModule*) base;
	g_return_if_fail (m != NULL);
	_tmp0 = NULL;
	old_method = (_tmp0 = ((ValaCCodeBaseModule*) self)->current_method, (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	_tmp1 = NULL;
	old_return_type = (_tmp1 = ((ValaCCodeBaseModule*) self)->current_return_type, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	old_method_inner_error = ((ValaCCodeBaseModule*) self)->current_method_inner_error;
	old_next_temp_var_id = ((ValaCCodeBaseModule*) self)->next_temp_var_id;
	_tmp3 = NULL;
	_tmp2 = NULL;
	((ValaCCodeBaseModule*) self)->current_symbol = (_tmp3 = (_tmp2 = (ValaSymbol*) m, (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2)), (((ValaCCodeBaseModule*) self)->current_symbol == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_symbol), NULL)), _tmp3);
	_tmp5 = NULL;
	_tmp4 = NULL;
	((ValaCCodeBaseModule*) self)->current_method = (_tmp5 = (_tmp4 = m, (_tmp4 == NULL) ? NULL : vala_code_node_ref (_tmp4)), (((ValaCCodeBaseModule*) self)->current_method == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_method = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_method), NULL)), _tmp5);
	_tmp7 = NULL;
	_tmp6 = NULL;
	((ValaCCodeBaseModule*) self)->current_return_type = (_tmp7 = (_tmp6 = vala_method_get_return_type (m), (_tmp6 == NULL) ? NULL : vala_code_node_ref (_tmp6)), (((ValaCCodeBaseModule*) self)->current_return_type == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_return_type = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_return_type), NULL)), _tmp7);
	((ValaCCodeBaseModule*) self)->current_method_inner_error = FALSE;
	((ValaCCodeBaseModule*) self)->next_temp_var_id = 0;
	in_gtypeinstance_creation_method = FALSE;
	in_gobject_creation_method = FALSE;
	in_fundamental_creation_method = FALSE;
	_tmp8 = NULL;
	creturn_type = (_tmp8 = ((ValaCCodeBaseModule*) self)->current_return_type, (_tmp8 == NULL) ? NULL : vala_code_node_ref (_tmp8));
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaClass* _tmp10;
		ValaTypeSymbol* _tmp9;
		ValaClass* cl;
		gboolean _tmp11;
		((ValaCCodeBaseModule*) self)->in_creation_method = TRUE;
		_tmp10 = NULL;
		_tmp9 = NULL;
		cl = (_tmp10 = (_tmp9 = ((ValaCCodeBaseModule*) self)->current_type_symbol, VALA_IS_CLASS (_tmp9) ? ((ValaClass*) _tmp9) : NULL), (_tmp10 == NULL) ? NULL : vala_code_node_ref (_tmp10));
		_tmp11 = FALSE;
		if (cl != NULL) {
			_tmp11 = !vala_class_get_is_compact (cl);
		} else {
			_tmp11 = FALSE;
		}
		if (_tmp11) {
			in_gtypeinstance_creation_method = TRUE;
			if (vala_class_get_base_class (cl) == NULL) {
				in_fundamental_creation_method = TRUE;
			} else {
				if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) cl, ((ValaCCodeBaseModule*) self)->gobject_type)) {
					in_gobject_creation_method = TRUE;
				}
			}
		}
		if (cl != NULL) {
			ValaDataType* _tmp12;
			_tmp12 = NULL;
			creturn_type = (_tmp12 = (ValaDataType*) vala_object_type_new ((ValaObjectTypeSymbol*) cl), (creturn_type == NULL) ? NULL : (creturn_type = (vala_code_node_unref (creturn_type), NULL)), _tmp12);
		}
		(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	}
	vala_code_node_accept_children ((ValaCodeNode*) m, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (VALA_IS_CREATION_METHOD (m)) {
		gboolean _tmp13;
		_tmp13 = FALSE;
		if (in_gobject_creation_method) {
			_tmp13 = vala_method_get_body (m) != NULL;
		} else {
			_tmp13 = FALSE;
		}
		if (_tmp13) {
			ValaCCodeBlock* cblock;
			cblock = vala_ccode_block_new ();
			if (!vala_creation_method_get_chain_up ((VALA_CREATION_METHOD (m)))) {
				gboolean _tmp21;
				/* set construct properties*/
				{
					GeeList* _tmp14;
					GeeIterator* _tmp15;
					GeeIterator* stmt_it;
					/* set construct properties*/
					_tmp14 = NULL;
					_tmp15 = NULL;
					stmt_it = (_tmp15 = gee_iterable_iterator ((GeeIterable*) (_tmp14 = vala_block_get_statements (vala_method_get_body (m)))), (_tmp14 == NULL) ? NULL : (_tmp14 = (gee_collection_object_unref (_tmp14), NULL)), _tmp15);
					/* set construct properties*/
					while (gee_iterator_next (stmt_it)) {
						ValaCodeNode* stmt;
						ValaExpressionStatement* _tmp17;
						ValaCodeNode* _tmp16;
						ValaExpressionStatement* expr_stmt;
						/* set construct properties*/
						stmt = (ValaCodeNode*) ((ValaStatement*) gee_iterator_get (stmt_it));
						_tmp17 = NULL;
						_tmp16 = NULL;
						expr_stmt = (_tmp17 = (_tmp16 = stmt, VALA_IS_EXPRESSION_STATEMENT (_tmp16) ? ((ValaExpressionStatement*) _tmp16) : NULL), (_tmp17 == NULL) ? NULL : vala_code_node_ref (_tmp17));
						if (expr_stmt != NULL) {
							ValaProperty* prop;
							gboolean _tmp18;
							prop = vala_expression_statement_assigned_property (expr_stmt);
							_tmp18 = FALSE;
							if (prop != NULL) {
								_tmp18 = vala_property_accessor_get_construction (vala_property_get_set_accessor (prop));
							} else {
								_tmp18 = FALSE;
							}
							if (_tmp18) {
								if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))) {
									{
										GeeList* _tmp19;
										GeeIterator* _tmp20;
										GeeIterator* cstmt_it;
										_tmp19 = NULL;
										_tmp20 = NULL;
										cstmt_it = (_tmp20 = gee_iterable_iterator ((GeeIterable*) (_tmp19 = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt)))))), (_tmp19 == NULL) ? NULL : (_tmp19 = (gee_collection_object_unref (_tmp19), NULL)), _tmp20);
										while (gee_iterator_next (cstmt_it)) {
											ValaCCodeNode* cstmt;
											cstmt = (ValaCCodeNode*) gee_iterator_get (cstmt_it);
											vala_ccode_block_add_statement (cblock, cstmt);
											(cstmt == NULL) ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL));
										}
										(cstmt_it == NULL) ? NULL : (cstmt_it = (gee_collection_object_unref (cstmt_it), NULL));
									}
								} else {
									vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (stmt));
								}
							}
							(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
						}
						(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
						(expr_stmt == NULL) ? NULL : (expr_stmt = (vala_code_node_unref (expr_stmt), NULL));
					}
					(stmt_it == NULL) ? NULL : (stmt_it = (gee_collection_object_unref (stmt_it), NULL));
				}
				_tmp21 = FALSE;
				if (vala_creation_method_get_n_construction_params ((VALA_CREATION_METHOD (m))) > 0) {
					_tmp21 = TRUE;
				} else {
					GeeList* _tmp22;
					_tmp22 = NULL;
					_tmp21 = gee_collection_get_size ((GeeCollection*) (_tmp22 = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class))) > 0;
					(_tmp22 == NULL) ? NULL : (_tmp22 = (gee_collection_object_unref (_tmp22), NULL));
				}
				vala_ccode_method_module_add_object_creation (self, cblock, _tmp21);
			} else {
				char* _tmp24;
				char* _tmp23;
				ValaCCodeDeclaration* _tmp25;
				ValaCCodeDeclaration* cdeclaration;
				ValaCCodeVariableDeclarator* _tmp26;
				_tmp24 = NULL;
				_tmp23 = NULL;
				_tmp25 = NULL;
				cdeclaration = (_tmp25 = vala_ccode_declaration_new (_tmp24 = g_strdup_printf ("%s *", _tmp23 = vala_typesymbol_get_cname ((ValaTypeSymbol*) (VALA_CLASS (((ValaCCodeBaseModule*) self)->current_type_symbol)), FALSE))), _tmp24 = (g_free (_tmp24), NULL), _tmp23 = (g_free (_tmp23), NULL), _tmp25);
				_tmp26 = NULL;
				vala_ccode_declaration_add_declarator (cdeclaration, (ValaCCodeDeclarator*) (_tmp26 = vala_ccode_variable_declarator_new ("self")));
				(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
				vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) cdeclaration);
				(cdeclaration == NULL) ? NULL : (cdeclaration = (vala_ccode_node_unref (cdeclaration), NULL));
			}
			/* other initialization code*/
			{
				GeeList* _tmp27;
				GeeIterator* _tmp28;
				GeeIterator* stmt_it;
				/* other initialization code*/
				_tmp27 = NULL;
				_tmp28 = NULL;
				stmt_it = (_tmp28 = gee_iterable_iterator ((GeeIterable*) (_tmp27 = vala_block_get_statements (vala_method_get_body (m)))), (_tmp27 == NULL) ? NULL : (_tmp27 = (gee_collection_object_unref (_tmp27), NULL)), _tmp28);
				/* other initialization code*/
				while (gee_iterator_next (stmt_it)) {
					ValaCodeNode* stmt;
					ValaExpressionStatement* _tmp30;
					ValaCodeNode* _tmp29;
					ValaExpressionStatement* expr_stmt;
					/* other initialization code*/
					stmt = (ValaCodeNode*) ((ValaStatement*) gee_iterator_get (stmt_it));
					_tmp30 = NULL;
					_tmp29 = NULL;
					expr_stmt = (_tmp30 = (_tmp29 = stmt, VALA_IS_EXPRESSION_STATEMENT (_tmp29) ? ((ValaExpressionStatement*) _tmp29) : NULL), (_tmp30 == NULL) ? NULL : vala_code_node_ref (_tmp30));
					if (expr_stmt != NULL) {
						ValaProperty* prop;
						gboolean _tmp31;
						prop = vala_expression_statement_assigned_property (expr_stmt);
						_tmp31 = FALSE;
						if (prop != NULL) {
							_tmp31 = vala_property_accessor_get_construction (vala_property_get_set_accessor (prop));
						} else {
							_tmp31 = FALSE;
						}
						if (_tmp31) {
							(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
							(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
							(expr_stmt == NULL) ? NULL : (expr_stmt = (vala_code_node_unref (expr_stmt), NULL));
							continue;
						}
						(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
					}
					if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))) {
						{
							GeeList* _tmp32;
							GeeIterator* _tmp33;
							GeeIterator* cstmt_it;
							_tmp32 = NULL;
							_tmp33 = NULL;
							cstmt_it = (_tmp33 = gee_iterable_iterator ((GeeIterable*) (_tmp32 = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt)))))), (_tmp32 == NULL) ? NULL : (_tmp32 = (gee_collection_object_unref (_tmp32), NULL)), _tmp33);
							while (gee_iterator_next (cstmt_it)) {
								ValaCCodeNode* cstmt;
								cstmt = (ValaCCodeNode*) gee_iterator_get (cstmt_it);
								vala_ccode_block_add_statement (cblock, cstmt);
								(cstmt == NULL) ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL));
							}
							(cstmt_it == NULL) ? NULL : (cstmt_it = (gee_collection_object_unref (cstmt_it), NULL));
						}
					} else {
						vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (stmt));
					}
					(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
					(expr_stmt == NULL) ? NULL : (expr_stmt = (vala_code_node_unref (expr_stmt), NULL));
				}
				(stmt_it == NULL) ? NULL : (stmt_it = (gee_collection_object_unref (stmt_it), NULL));
			}
			vala_code_node_set_ccodenode ((ValaCodeNode*) vala_method_get_body (m), (ValaCCodeNode*) cblock);
			(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
		}
		((ValaCCodeBaseModule*) self)->in_creation_method = FALSE;
	}
	inner_error = ((ValaCCodeBaseModule*) self)->current_method_inner_error;
	_tmp35 = NULL;
	_tmp34 = NULL;
	((ValaCCodeBaseModule*) self)->current_symbol = (_tmp35 = (_tmp34 = vala_symbol_get_parent_symbol (((ValaCCodeBaseModule*) self)->current_symbol), (_tmp34 == NULL) ? NULL : vala_code_node_ref (_tmp34)), (((ValaCCodeBaseModule*) self)->current_symbol == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_symbol), NULL)), _tmp35);
	_tmp37 = NULL;
	_tmp36 = NULL;
	((ValaCCodeBaseModule*) self)->current_method = (_tmp37 = (_tmp36 = old_method, (_tmp36 == NULL) ? NULL : vala_code_node_ref (_tmp36)), (((ValaCCodeBaseModule*) self)->current_method == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_method = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_method), NULL)), _tmp37);
	_tmp39 = NULL;
	_tmp38 = NULL;
	((ValaCCodeBaseModule*) self)->current_return_type = (_tmp39 = (_tmp38 = old_return_type, (_tmp38 == NULL) ? NULL : vala_code_node_ref (_tmp38)), (((ValaCCodeBaseModule*) self)->current_return_type == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_return_type = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_return_type), NULL)), _tmp39);
	((ValaCCodeBaseModule*) self)->current_method_inner_error = old_method_inner_error;
	((ValaCCodeBaseModule*) self)->next_temp_var_id = old_next_temp_var_id;
	_tmp43 = NULL;
	_tmp42 = NULL;
	_tmp41 = NULL;
	_tmp40 = NULL;
	((ValaCCodeBaseModule*) self)->function = (_tmp43 = vala_ccode_function_new (_tmp40 = vala_method_get_real_cname (m), _tmp42 = vala_ccode_method_module_get_creturn_type (self, m, _tmp41 = vala_data_type_get_cname (creturn_type))), (((ValaCCodeBaseModule*) self)->function == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->function = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->function), NULL)), _tmp43);
	_tmp42 = (g_free (_tmp42), NULL);
	_tmp41 = (g_free (_tmp41), NULL);
	_tmp40 = (g_free (_tmp40), NULL);
	vala_code_node_set_ccodenode ((ValaCodeNode*) m, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function);
	if (vala_method_get_is_inline (m)) {
		vala_ccode_function_set_modifiers (((ValaCCodeBaseModule*) self)->function, vala_ccode_function_get_modifiers (((ValaCCodeBaseModule*) self)->function) | (VALA_CCODE_MODIFIERS_INLINE));
	}
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	vdeclarator = NULL;
	_tmp44 = FALSE;
	if (vala_method_get_is_abstract (m)) {
		_tmp44 = TRUE;
	} else {
		_tmp44 = vala_method_get_is_virtual (m);
	}
	if (_tmp44) {
		char* _tmp46;
		char* _tmp45;
		ValaCCodeDeclaration* _tmp47;
		ValaCCodeDeclaration* vdecl;
		ValaCCodeFunctionDeclarator* _tmp48;
		_tmp46 = NULL;
		_tmp45 = NULL;
		_tmp47 = NULL;
		vdecl = (_tmp47 = vala_ccode_declaration_new (_tmp46 = vala_ccode_method_module_get_creturn_type (self, m, _tmp45 = vala_data_type_get_cname (creturn_type))), _tmp46 = (g_free (_tmp46), NULL), _tmp45 = (g_free (_tmp45), NULL), _tmp47);
		_tmp48 = NULL;
		vdeclarator = (_tmp48 = vala_ccode_function_declarator_new (vala_method_get_vfunc_name (m)), (vdeclarator == NULL) ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL)), _tmp48);
		vala_ccode_declaration_add_declarator (vdecl, (ValaCCodeDeclarator*) vdeclarator);
		vala_ccode_struct_add_declaration (((ValaCCodeBaseModule*) self)->type_struct, vdecl);
		(vdecl == NULL) ? NULL : (vdecl = (vala_ccode_node_unref (vdecl), NULL));
	}
	vala_ccode_module_generate_cparameters ((ValaCCodeModule*) self, m, creturn_type, in_gtypeinstance_creation_method, (GeeMap*) cparam_map, ((ValaCCodeBaseModule*) self)->function, vdeclarator, NULL, NULL, 3);
	visible = !vala_symbol_is_internal_symbol ((ValaSymbol*) m);
	_tmp49 = FALSE;
	if (!vala_method_get_is_abstract (m)) {
		_tmp49 = TRUE;
	} else {
		gboolean _tmp50;
		_tmp50 = FALSE;
		if (vala_method_get_is_abstract (m)) {
			_tmp50 = VALA_IS_CLASS (((ValaCCodeBaseModule*) self)->current_type_symbol);
		} else {
			_tmp50 = FALSE;
		}
		_tmp49 = (_tmp50);
	}
	/* generate *_real_* functions for virtual methods
	 also generate them for abstract methods of classes to prevent faulty subclassing*/
	if (_tmp49) {
		gboolean _tmp51;
		gboolean _tmp52;
		_tmp51 = FALSE;
		_tmp52 = FALSE;
		if (visible) {
			_tmp52 = vala_method_get_base_method (m) == NULL;
		} else {
			_tmp52 = FALSE;
		}
		if (_tmp52) {
			_tmp51 = vala_method_get_base_interface_method (m) == NULL;
		} else {
			_tmp51 = FALSE;
		}
		if (_tmp51) {
			ValaCCodeFunction* _tmp53;
			/* public methods need function declaration in
			 * header file except virtual/overridden methods */
			_tmp53 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->header_type_member_declaration, (ValaCCodeNode*) (_tmp53 = vala_ccode_function_copy (((ValaCCodeBaseModule*) self)->function)));
			(_tmp53 == NULL) ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL));
		} else {
			ValaCCodeFunction* _tmp54;
			/* declare all other functions in source file to
			 * avoid dependency on order within source file */
			vala_ccode_function_set_modifiers (((ValaCCodeBaseModule*) self)->function, vala_ccode_function_get_modifiers (((ValaCCodeBaseModule*) self)->function) | (VALA_CCODE_MODIFIERS_STATIC));
			_tmp54 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp54 = vala_ccode_function_copy (((ValaCCodeBaseModule*) self)->function)));
			(_tmp54 == NULL) ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL));
		}
		/* Methods imported from a plain C file don't
		 * have a body, e.g. Vala.Parser.parse_file () */
		if (vala_method_get_body (m) != NULL) {
			ValaCCodeFragment* cinit;
			gboolean _tmp216;
			vala_ccode_function_set_block (((ValaCCodeBaseModule*) self)->function, VALA_CCODE_BLOCK (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_method_get_body (m))));
			vala_ccode_node_set_line ((ValaCCodeNode*) vala_ccode_function_get_block (((ValaCCodeBaseModule*) self)->function), vala_ccode_node_get_line ((ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function));
			cinit = vala_ccode_fragment_new ();
			vala_ccode_block_prepend_statement (vala_ccode_function_get_block (((ValaCCodeBaseModule*) self)->function), (ValaCCodeNode*) cinit);
			if (vala_method_get_coroutine (m)) {
				char* _tmp56;
				char* _tmp55;
				ValaCCodeFunction* _tmp57;
				ValaCCodeFunction* co_function;
				ValaCCodeFormalParameter* _tmp61;
				char* _tmp60;
				char* _tmp59;
				char* _tmp58;
				ValaCCodeFunction* _tmp62;
				ValaCCodeMemberAccess* _tmp64;
				ValaCCodeIdentifier* _tmp63;
				ValaCCodeSwitchStatement* _tmp65;
				ValaCCodeSwitchStatement* cswitch;
				ValaCCodeCaseStatement* _tmp67;
				ValaCCodeConstant* _tmp66;
				ValaCCodeIdentifier* _tmp68;
				ValaCCodeFunctionCall* _tmp69;
				ValaCCodeFunctionCall* object_creation;
				ValaCCodeConstant* _tmp70;
				ValaCCodeConstant* _tmp71;
				ValaCCodeConstant* _tmp72;
				ValaCCodeIdentifier* _tmp73;
				ValaCCodeFunctionCall* _tmp74;
				ValaCCodeFunctionCall* async_result_creation;
				ValaCCodeMemberAccess* _tmp76;
				ValaCCodeIdentifier* _tmp75;
				ValaCCodeMemberAccess* _tmp78;
				ValaCCodeIdentifier* _tmp77;
				ValaCCodeIdentifier* _tmp79;
				ValaCCodeIdentifier* _tmp80;
				ValaCCodeFunctionCall* _tmp81;
				ValaCCodeFunctionCall* completecall;
				ValaCCodeExpressionStatement* _tmp82;
				ValaCCodeReturnStatement* _tmp84;
				ValaCCodeConstant* _tmp83;
				ValaCCodeBlock* _tmp85;
				_tmp56 = NULL;
				_tmp55 = NULL;
				_tmp57 = NULL;
				co_function = (_tmp57 = vala_ccode_function_new (_tmp56 = g_strconcat (_tmp55 = vala_method_get_real_cname (m), "_co", NULL), "gboolean"), _tmp56 = (g_free (_tmp56), NULL), _tmp55 = (g_free (_tmp55), NULL), _tmp57);
				/* data struct to hold parameters, local variables, and the return value*/
				_tmp61 = NULL;
				_tmp60 = NULL;
				_tmp59 = NULL;
				_tmp58 = NULL;
				vala_ccode_function_add_parameter (co_function, _tmp61 = vala_ccode_formal_parameter_new ("data", _tmp60 = g_strconcat (_tmp59 = vala_symbol_lower_case_to_camel_case (_tmp58 = vala_method_get_cname (m)), "Data*", NULL)));
				(_tmp61 == NULL) ? NULL : (_tmp61 = (vala_ccode_node_unref (_tmp61), NULL));
				_tmp60 = (g_free (_tmp60), NULL);
				_tmp59 = (g_free (_tmp59), NULL);
				_tmp58 = (g_free (_tmp58), NULL);
				vala_ccode_function_set_modifiers (co_function, vala_ccode_function_get_modifiers (co_function) | (VALA_CCODE_MODIFIERS_STATIC));
				_tmp62 = NULL;
				vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp62 = vala_ccode_function_copy (co_function)));
				(_tmp62 == NULL) ? NULL : (_tmp62 = (vala_ccode_node_unref (_tmp62), NULL));
				_tmp64 = NULL;
				_tmp63 = NULL;
				_tmp65 = NULL;
				cswitch = (_tmp65 = vala_ccode_switch_statement_new ((ValaCCodeExpression*) (_tmp64 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp63 = vala_ccode_identifier_new ("data")), "state"))), (_tmp64 == NULL) ? NULL : (_tmp64 = (vala_ccode_node_unref (_tmp64), NULL)), (_tmp63 == NULL) ? NULL : (_tmp63 = (vala_ccode_node_unref (_tmp63), NULL)), _tmp65);
				/* initial coroutine state*/
				_tmp67 = NULL;
				_tmp66 = NULL;
				vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp67 = vala_ccode_case_statement_new ((ValaCCodeExpression*) (_tmp66 = vala_ccode_constant_new ("0")))));
				(_tmp67 == NULL) ? NULL : (_tmp67 = (vala_ccode_node_unref (_tmp67), NULL));
				(_tmp66 == NULL) ? NULL : (_tmp66 = (vala_ccode_node_unref (_tmp66), NULL));
				/* coroutine body*/
				vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) vala_ccode_function_get_block (((ValaCCodeBaseModule*) self)->function));
				/* complete async call by invoking callback*/
				_tmp68 = NULL;
				_tmp69 = NULL;
				object_creation = (_tmp69 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp68 = vala_ccode_identifier_new ("g_object_newv"))), (_tmp68 == NULL) ? NULL : (_tmp68 = (vala_ccode_node_unref (_tmp68), NULL)), _tmp69);
				_tmp70 = NULL;
				vala_ccode_function_call_add_argument (object_creation, (ValaCCodeExpression*) (_tmp70 = vala_ccode_constant_new ("G_TYPE_OBJECT")));
				(_tmp70 == NULL) ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL));
				_tmp71 = NULL;
				vala_ccode_function_call_add_argument (object_creation, (ValaCCodeExpression*) (_tmp71 = vala_ccode_constant_new ("0")));
				(_tmp71 == NULL) ? NULL : (_tmp71 = (vala_ccode_node_unref (_tmp71), NULL));
				_tmp72 = NULL;
				vala_ccode_function_call_add_argument (object_creation, (ValaCCodeExpression*) (_tmp72 = vala_ccode_constant_new ("NULL")));
				(_tmp72 == NULL) ? NULL : (_tmp72 = (vala_ccode_node_unref (_tmp72), NULL));
				_tmp73 = NULL;
				_tmp74 = NULL;
				async_result_creation = (_tmp74 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp73 = vala_ccode_identifier_new ("g_simple_async_result_new"))), (_tmp73 == NULL) ? NULL : (_tmp73 = (vala_ccode_node_unref (_tmp73), NULL)), _tmp74);
				vala_ccode_function_call_add_argument (async_result_creation, (ValaCCodeExpression*) object_creation);
				_tmp76 = NULL;
				_tmp75 = NULL;
				vala_ccode_function_call_add_argument (async_result_creation, (ValaCCodeExpression*) (_tmp76 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp75 = vala_ccode_identifier_new ("data")), "callback")));
				(_tmp76 == NULL) ? NULL : (_tmp76 = (vala_ccode_node_unref (_tmp76), NULL));
				(_tmp75 == NULL) ? NULL : (_tmp75 = (vala_ccode_node_unref (_tmp75), NULL));
				_tmp78 = NULL;
				_tmp77 = NULL;
				vala_ccode_function_call_add_argument (async_result_creation, (ValaCCodeExpression*) (_tmp78 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp77 = vala_ccode_identifier_new ("data")), "user_data")));
				(_tmp78 == NULL) ? NULL : (_tmp78 = (vala_ccode_node_unref (_tmp78), NULL));
				(_tmp77 == NULL) ? NULL : (_tmp77 = (vala_ccode_node_unref (_tmp77), NULL));
				_tmp79 = NULL;
				vala_ccode_function_call_add_argument (async_result_creation, (ValaCCodeExpression*) (_tmp79 = vala_ccode_identifier_new ("data")));
				(_tmp79 == NULL) ? NULL : (_tmp79 = (vala_ccode_node_unref (_tmp79), NULL));
				_tmp80 = NULL;
				_tmp81 = NULL;
				completecall = (_tmp81 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp80 = vala_ccode_identifier_new ("g_simple_async_result_complete"))), (_tmp80 == NULL) ? NULL : (_tmp80 = (vala_ccode_node_unref (_tmp80), NULL)), _tmp81);
				vala_ccode_function_call_add_argument (completecall, (ValaCCodeExpression*) async_result_creation);
				_tmp82 = NULL;
				vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp82 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) completecall)));
				(_tmp82 == NULL) ? NULL : (_tmp82 = (vala_ccode_node_unref (_tmp82), NULL));
				_tmp84 = NULL;
				_tmp83 = NULL;
				vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp84 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp83 = vala_ccode_constant_new ("FALSE")))));
				(_tmp84 == NULL) ? NULL : (_tmp84 = (vala_ccode_node_unref (_tmp84), NULL));
				(_tmp83 == NULL) ? NULL : (_tmp83 = (vala_ccode_node_unref (_tmp83), NULL));
				_tmp85 = NULL;
				vala_ccode_function_set_block (co_function, _tmp85 = vala_ccode_block_new ());
				(_tmp85 == NULL) ? NULL : (_tmp85 = (vala_ccode_node_unref (_tmp85), NULL));
				vala_ccode_block_add_statement (vala_ccode_function_get_block (co_function), (ValaCCodeNode*) cswitch);
				vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) co_function);
				(co_function == NULL) ? NULL : (co_function = (vala_ccode_node_unref (co_function), NULL));
				(cswitch == NULL) ? NULL : (cswitch = (vala_ccode_node_unref (cswitch), NULL));
				(object_creation == NULL) ? NULL : (object_creation = (vala_ccode_node_unref (object_creation), NULL));
				(async_result_creation == NULL) ? NULL : (async_result_creation = (vala_ccode_node_unref (async_result_creation), NULL));
				(completecall == NULL) ? NULL : (completecall = (vala_ccode_node_unref (completecall), NULL));
			}
			if (VALA_IS_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m))) {
				ValaClass* _tmp86;
				ValaClass* cl;
				gboolean _tmp87;
				_tmp86 = NULL;
				cl = (_tmp86 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), (_tmp86 == NULL) ? NULL : vala_code_node_ref (_tmp86));
				_tmp87 = FALSE;
				if (vala_method_get_overrides (m)) {
					_tmp87 = TRUE;
				} else {
					gboolean _tmp88;
					gboolean _tmp89;
					_tmp88 = FALSE;
					_tmp89 = FALSE;
					if (vala_method_get_base_interface_method (m) != NULL) {
						_tmp89 = !vala_method_get_is_abstract (m);
					} else {
						_tmp89 = FALSE;
					}
					if (_tmp89) {
						_tmp88 = !vala_method_get_is_virtual (m);
					} else {
						_tmp88 = FALSE;
					}
					_tmp87 = (_tmp88);
				}
				if (_tmp87) {
					ValaMethod* base_method;
					ValaReferenceType* base_expression_type;
					ValaObjectType* self_target_type;
					ValaCCodeIdentifier* _tmp96;
					ValaCCodeExpression* _tmp97;
					ValaCCodeExpression* cself;
					char* _tmp99;
					char* _tmp98;
					ValaCCodeDeclaration* _tmp100;
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeVariableDeclarator* _tmp101;
					base_method = NULL;
					base_expression_type = NULL;
					if (vala_method_get_overrides (m)) {
						ValaMethod* _tmp91;
						ValaMethod* _tmp90;
						ValaReferenceType* _tmp92;
						_tmp91 = NULL;
						_tmp90 = NULL;
						base_method = (_tmp91 = (_tmp90 = vala_method_get_base_method (m), (_tmp90 == NULL) ? NULL : vala_code_node_ref (_tmp90)), (base_method == NULL) ? NULL : (base_method = (vala_code_node_unref (base_method), NULL)), _tmp91);
						_tmp92 = NULL;
						base_expression_type = (_tmp92 = (ValaReferenceType*) vala_object_type_new ((ValaObjectTypeSymbol*) VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) base_method))), (base_expression_type == NULL) ? NULL : (base_expression_type = (vala_code_node_unref (base_expression_type), NULL)), _tmp92);
					} else {
						ValaMethod* _tmp94;
						ValaMethod* _tmp93;
						ValaReferenceType* _tmp95;
						_tmp94 = NULL;
						_tmp93 = NULL;
						base_method = (_tmp94 = (_tmp93 = vala_method_get_base_interface_method (m), (_tmp93 == NULL) ? NULL : vala_code_node_ref (_tmp93)), (base_method == NULL) ? NULL : (base_method = (vala_code_node_unref (base_method), NULL)), _tmp94);
						_tmp95 = NULL;
						base_expression_type = (_tmp95 = (ValaReferenceType*) vala_object_type_new ((ValaObjectTypeSymbol*) VALA_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) base_method))), (base_expression_type == NULL) ? NULL : (base_expression_type = (vala_code_node_unref (base_expression_type), NULL)), _tmp95);
					}
					self_target_type = vala_object_type_new ((ValaObjectTypeSymbol*) cl);
					_tmp96 = NULL;
					_tmp97 = NULL;
					cself = (_tmp97 = vala_ccode_base_module_transform_expression ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) (_tmp96 = vala_ccode_identifier_new ("base")), (ValaDataType*) base_expression_type, (ValaDataType*) self_target_type, NULL), (_tmp96 == NULL) ? NULL : (_tmp96 = (vala_ccode_node_unref (_tmp96), NULL)), _tmp97);
					_tmp99 = NULL;
					_tmp98 = NULL;
					_tmp100 = NULL;
					cdecl_ = (_tmp100 = vala_ccode_declaration_new (_tmp99 = g_strdup_printf ("%s *", _tmp98 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))), _tmp99 = (g_free (_tmp99), NULL), _tmp98 = (g_free (_tmp98), NULL), _tmp100);
					_tmp101 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp101 = vala_ccode_variable_declarator_new_with_initializer ("self", cself)));
					(_tmp101 == NULL) ? NULL : (_tmp101 = (vala_ccode_node_unref (_tmp101), NULL));
					vala_ccode_fragment_append (cinit, (ValaCCodeNode*) cdecl_);
					(base_method == NULL) ? NULL : (base_method = (vala_code_node_unref (base_method), NULL));
					(base_expression_type == NULL) ? NULL : (base_expression_type = (vala_code_node_unref (base_expression_type), NULL));
					(self_target_type == NULL) ? NULL : (self_target_type = (vala_code_node_unref (self_target_type), NULL));
					(cself == NULL) ? NULL : (cself = (vala_ccode_node_unref (cself), NULL));
					(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
				} else {
					gboolean _tmp102;
					_tmp102 = FALSE;
					if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
						_tmp102 = !(VALA_IS_CREATION_METHOD (m));
					} else {
						_tmp102 = FALSE;
					}
					if (_tmp102) {
						ValaCCodeStatement* ccheckstmt;
						ccheckstmt = vala_ccode_method_module_create_method_type_check_statement (self, m, creturn_type, (ValaTypeSymbol*) cl, TRUE, "self");
						vala_ccode_node_set_line ((ValaCCodeNode*) ccheckstmt, vala_ccode_node_get_line ((ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function));
						vala_ccode_fragment_append (cinit, (ValaCCodeNode*) ccheckstmt);
						(ccheckstmt == NULL) ? NULL : (ccheckstmt = (vala_ccode_node_unref (ccheckstmt), NULL));
					}
				}
				(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
			}
			{
				GeeList* _tmp103;
				GeeIterator* _tmp104;
				GeeIterator* param_it;
				_tmp103 = NULL;
				_tmp104 = NULL;
				param_it = (_tmp104 = gee_iterable_iterator ((GeeIterable*) (_tmp103 = vala_method_get_parameters (m))), (_tmp103 == NULL) ? NULL : (_tmp103 = (gee_collection_object_unref (_tmp103), NULL)), _tmp104);
				while (gee_iterator_next (param_it)) {
					ValaFormalParameter* param;
					ValaTypeSymbol* _tmp105;
					ValaTypeSymbol* t;
					gboolean _tmp106;
					param = (ValaFormalParameter*) gee_iterator_get (param_it);
					if (vala_formal_parameter_get_ellipsis (param)) {
						(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
						break;
					}
					_tmp105 = NULL;
					t = (_tmp105 = vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param)), (_tmp105 == NULL) ? NULL : vala_code_node_ref (_tmp105));
					_tmp106 = FALSE;
					if (t != NULL) {
						_tmp106 = vala_typesymbol_is_reference_type (t);
					} else {
						_tmp106 = FALSE;
					}
					if (_tmp106) {
						if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_OUT) {
							gboolean _tmp107;
							ValaCCodeStatement* type_check;
							_tmp107 = FALSE;
							if (vala_code_context_get_non_null (vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self))) {
								_tmp107 = !vala_data_type_get_nullable (vala_formal_parameter_get_parameter_type (param));
							} else {
								_tmp107 = FALSE;
							}
							type_check = vala_ccode_method_module_create_method_type_check_statement (self, m, creturn_type, t, (_tmp107), vala_symbol_get_name ((ValaSymbol*) param));
							if (type_check != NULL) {
								vala_ccode_node_set_line ((ValaCCodeNode*) type_check, vala_ccode_node_get_line ((ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function));
								vala_ccode_fragment_append (cinit, (ValaCCodeNode*) type_check);
							}
							(type_check == NULL) ? NULL : (type_check = (vala_ccode_node_unref (type_check), NULL));
						} else {
							ValaCCodeConstant* _tmp110;
							ValaCCodeUnaryExpression* _tmp109;
							ValaCCodeIdentifier* _tmp108;
							ValaCCodeAssignment* _tmp111;
							ValaCCodeAssignment* a;
							ValaCCodeExpressionStatement* _tmp112;
							/* ensure that the passed reference for output parameter is cleared*/
							_tmp110 = NULL;
							_tmp109 = NULL;
							_tmp108 = NULL;
							_tmp111 = NULL;
							a = (_tmp111 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp109 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp108 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))))), (ValaCCodeExpression*) (_tmp110 = vala_ccode_constant_new ("NULL")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp110 == NULL) ? NULL : (_tmp110 = (vala_ccode_node_unref (_tmp110), NULL)), (_tmp109 == NULL) ? NULL : (_tmp109 = (vala_ccode_node_unref (_tmp109), NULL)), (_tmp108 == NULL) ? NULL : (_tmp108 = (vala_ccode_node_unref (_tmp108), NULL)), _tmp111);
							_tmp112 = NULL;
							vala_ccode_fragment_append (cinit, (ValaCCodeNode*) (_tmp112 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) a)));
							(_tmp112 == NULL) ? NULL : (_tmp112 = (vala_ccode_node_unref (_tmp112), NULL));
							(a == NULL) ? NULL : (a = (vala_ccode_node_unref (a), NULL));
						}
					}
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
					(t == NULL) ? NULL : (t = (vala_code_node_unref (t), NULL));
				}
				(param_it == NULL) ? NULL : (param_it = (gee_collection_object_unref (param_it), NULL));
			}
			if (inner_error) {
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* _tmp114;
				ValaCCodeConstant* _tmp113;
				/* always separate error parameter and inner_error local variable
				 * as error may be set to NULL but we're always interested in inner errors
				 */
				cdecl_ = vala_ccode_declaration_new ("GError *");
				_tmp114 = NULL;
				_tmp113 = NULL;
				vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp114 = vala_ccode_variable_declarator_new_with_initializer ("inner_error", (ValaCCodeExpression*) (_tmp113 = vala_ccode_constant_new ("NULL")))));
				(_tmp114 == NULL) ? NULL : (_tmp114 = (vala_ccode_node_unref (_tmp114), NULL));
				(_tmp113 == NULL) ? NULL : (_tmp113 = (vala_ccode_node_unref (_tmp113), NULL));
				vala_ccode_fragment_append (cinit, (ValaCCodeNode*) cdecl_);
				(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
			}
			if (!vala_method_get_coroutine (m)) {
				gboolean _tmp115;
				_tmp115 = FALSE;
				if (vala_code_node_get_source_reference ((ValaCodeNode*) m) != NULL) {
					_tmp115 = vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) m)) != NULL;
				} else {
					_tmp115 = FALSE;
				}
				if (_tmp115) {
					ValaCCodeComment* _tmp116;
					_tmp116 = NULL;
					vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) (_tmp116 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) m)))));
					(_tmp116 == NULL) ? NULL : (_tmp116 = (vala_ccode_node_unref (_tmp116), NULL));
				}
				vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function);
			}
			if (VALA_IS_CREATION_METHOD (m)) {
				if (in_gobject_creation_method) {
					gint n_params;
					gboolean _tmp117;
					n_params = vala_creation_method_get_n_construction_params ((VALA_CREATION_METHOD (m)));
					_tmp117 = FALSE;
					if (n_params > 0) {
						_tmp117 = TRUE;
					} else {
						GeeList* _tmp118;
						_tmp118 = NULL;
						_tmp117 = gee_collection_get_size ((GeeCollection*) (_tmp118 = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class))) > 0;
						(_tmp118 == NULL) ? NULL : (_tmp118 = (gee_collection_object_unref (_tmp118), NULL));
					}
					if (_tmp117) {
						ValaCCodeIdentifier* _tmp119;
						ValaCCodeFunctionCall* _tmp120;
						ValaCCodeFunctionCall* cparamsinit;
						ValaCCodeIdentifier* _tmp121;
						ValaCCodeConstant* _tmp124;
						char* _tmp123;
						GeeList* _tmp122;
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeVariableDeclarator* _tmp125;
						ValaCCodeDeclaration* _tmp126;
						ValaCCodeVariableDeclarator* _tmp128;
						ValaCCodeIdentifier* _tmp127;
						/* declare construction parameter array*/
						_tmp119 = NULL;
						_tmp120 = NULL;
						cparamsinit = (_tmp120 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp119 = vala_ccode_identifier_new ("g_new0"))), (_tmp119 == NULL) ? NULL : (_tmp119 = (vala_ccode_node_unref (_tmp119), NULL)), _tmp120);
						_tmp121 = NULL;
						vala_ccode_function_call_add_argument (cparamsinit, (ValaCCodeExpression*) (_tmp121 = vala_ccode_identifier_new ("GParameter")));
						(_tmp121 == NULL) ? NULL : (_tmp121 = (vala_ccode_node_unref (_tmp121), NULL));
						_tmp124 = NULL;
						_tmp123 = NULL;
						_tmp122 = NULL;
						vala_ccode_function_call_add_argument (cparamsinit, (ValaCCodeExpression*) (_tmp124 = vala_ccode_constant_new (_tmp123 = g_strdup_printf ("%i", (n_params + (3 * gee_collection_get_size ((GeeCollection*) (_tmp122 = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class)))))))));
						(_tmp124 == NULL) ? NULL : (_tmp124 = (vala_ccode_node_unref (_tmp124), NULL));
						_tmp123 = (g_free (_tmp123), NULL);
						(_tmp122 == NULL) ? NULL : (_tmp122 = (gee_collection_object_unref (_tmp122), NULL));
						cdecl_ = vala_ccode_declaration_new ("GParameter *");
						_tmp125 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp125 = vala_ccode_variable_declarator_new_with_initializer ("__params", (ValaCCodeExpression*) cparamsinit)));
						(_tmp125 == NULL) ? NULL : (_tmp125 = (vala_ccode_node_unref (_tmp125), NULL));
						vala_ccode_fragment_append (cinit, (ValaCCodeNode*) cdecl_);
						_tmp126 = NULL;
						cdecl_ = (_tmp126 = vala_ccode_declaration_new ("GParameter *"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp126);
						_tmp128 = NULL;
						_tmp127 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp128 = vala_ccode_variable_declarator_new_with_initializer ("__params_it", (ValaCCodeExpression*) (_tmp127 = vala_ccode_identifier_new ("__params")))));
						(_tmp128 == NULL) ? NULL : (_tmp128 = (vala_ccode_node_unref (_tmp128), NULL));
						(_tmp127 == NULL) ? NULL : (_tmp127 = (vala_ccode_node_unref (_tmp127), NULL));
						vala_ccode_fragment_append (cinit, (ValaCCodeNode*) cdecl_);
						(cparamsinit == NULL) ? NULL : (cparamsinit = (vala_ccode_node_unref (cparamsinit), NULL));
						(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
					}
					/* type, dup func, and destroy func properties for generic types */
					{
						GeeList* _tmp129;
						GeeIterator* _tmp130;
						GeeIterator* type_param_it;
						/* type, dup func, and destroy func properties for generic types */
						_tmp129 = NULL;
						_tmp130 = NULL;
						type_param_it = (_tmp130 = gee_iterable_iterator ((GeeIterable*) (_tmp129 = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class))), (_tmp129 == NULL) ? NULL : (_tmp129 = (gee_collection_object_unref (_tmp129), NULL)), _tmp130);
						/* type, dup func, and destroy func properties for generic types */
						while (gee_iterator_next (type_param_it)) {
							ValaTypeParameter* type_param;
							ValaCCodeConstant* prop_name;
							ValaCCodeIdentifier* param_name;
							ValaCCodeConstant* _tmp133;
							char* _tmp132;
							char* _tmp131;
							ValaCCodeIdentifier* _tmp136;
							char* _tmp135;
							char* _tmp134;
							ValaCCodeExpressionStatement* _tmp139;
							ValaCCodeExpression* _tmp138;
							ValaValueType* _tmp137;
							ValaCCodeConstant* _tmp142;
							char* _tmp141;
							char* _tmp140;
							ValaCCodeIdentifier* _tmp145;
							char* _tmp144;
							char* _tmp143;
							ValaCCodeExpressionStatement* _tmp149;
							ValaCCodeExpression* _tmp148;
							ValaPointerType* _tmp147;
							ValaVoidType* _tmp146;
							ValaCCodeConstant* _tmp152;
							char* _tmp151;
							char* _tmp150;
							ValaCCodeIdentifier* _tmp155;
							char* _tmp154;
							char* _tmp153;
							ValaCCodeExpressionStatement* _tmp159;
							ValaCCodeExpression* _tmp158;
							ValaPointerType* _tmp157;
							ValaVoidType* _tmp156;
							/* type, dup func, and destroy func properties for generic types */
							type_param = (ValaTypeParameter*) gee_iterator_get (type_param_it);
							prop_name = NULL;
							param_name = NULL;
							_tmp133 = NULL;
							_tmp132 = NULL;
							_tmp131 = NULL;
							prop_name = (_tmp133 = vala_ccode_constant_new (_tmp132 = g_strdup_printf ("\"%s-type\"", _tmp131 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), (prop_name == NULL) ? NULL : (prop_name = (vala_ccode_node_unref (prop_name), NULL)), _tmp133);
							_tmp132 = (g_free (_tmp132), NULL);
							_tmp131 = (g_free (_tmp131), NULL);
							_tmp136 = NULL;
							_tmp135 = NULL;
							_tmp134 = NULL;
							param_name = (_tmp136 = vala_ccode_identifier_new (_tmp135 = g_strdup_printf ("%s_type", _tmp134 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), (param_name == NULL) ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL)), _tmp136);
							_tmp135 = (g_free (_tmp135), NULL);
							_tmp134 = (g_free (_tmp134), NULL);
							_tmp139 = NULL;
							_tmp138 = NULL;
							_tmp137 = NULL;
							vala_ccode_fragment_append (cinit, (ValaCCodeNode*) (_tmp139 = vala_ccode_expression_statement_new (_tmp138 = vala_ccode_module_get_construct_property_assignment ((ValaCCodeModule*) self, prop_name, (ValaDataType*) (_tmp137 = vala_value_type_new (((ValaCCodeBaseModule*) self)->gtype_type)), (ValaCCodeExpression*) param_name))));
							(_tmp139 == NULL) ? NULL : (_tmp139 = (vala_ccode_node_unref (_tmp139), NULL));
							(_tmp138 == NULL) ? NULL : (_tmp138 = (vala_ccode_node_unref (_tmp138), NULL));
							(_tmp137 == NULL) ? NULL : (_tmp137 = (vala_code_node_unref (_tmp137), NULL));
							_tmp142 = NULL;
							_tmp141 = NULL;
							_tmp140 = NULL;
							prop_name = (_tmp142 = vala_ccode_constant_new (_tmp141 = g_strdup_printf ("\"%s-dup-func\"", _tmp140 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), (prop_name == NULL) ? NULL : (prop_name = (vala_ccode_node_unref (prop_name), NULL)), _tmp142);
							_tmp141 = (g_free (_tmp141), NULL);
							_tmp140 = (g_free (_tmp140), NULL);
							_tmp145 = NULL;
							_tmp144 = NULL;
							_tmp143 = NULL;
							param_name = (_tmp145 = vala_ccode_identifier_new (_tmp144 = g_strdup_printf ("%s_dup_func", _tmp143 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), (param_name == NULL) ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL)), _tmp145);
							_tmp144 = (g_free (_tmp144), NULL);
							_tmp143 = (g_free (_tmp143), NULL);
							_tmp149 = NULL;
							_tmp148 = NULL;
							_tmp147 = NULL;
							_tmp146 = NULL;
							vala_ccode_fragment_append (cinit, (ValaCCodeNode*) (_tmp149 = vala_ccode_expression_statement_new (_tmp148 = vala_ccode_module_get_construct_property_assignment ((ValaCCodeModule*) self, prop_name, (ValaDataType*) (_tmp147 = vala_pointer_type_new ((ValaDataType*) (_tmp146 = vala_void_type_new ()), NULL)), (ValaCCodeExpression*) param_name))));
							(_tmp149 == NULL) ? NULL : (_tmp149 = (vala_ccode_node_unref (_tmp149), NULL));
							(_tmp148 == NULL) ? NULL : (_tmp148 = (vala_ccode_node_unref (_tmp148), NULL));
							(_tmp147 == NULL) ? NULL : (_tmp147 = (vala_code_node_unref (_tmp147), NULL));
							(_tmp146 == NULL) ? NULL : (_tmp146 = (vala_code_node_unref (_tmp146), NULL));
							_tmp152 = NULL;
							_tmp151 = NULL;
							_tmp150 = NULL;
							prop_name = (_tmp152 = vala_ccode_constant_new (_tmp151 = g_strdup_printf ("\"%s-destroy-func\"", _tmp150 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), (prop_name == NULL) ? NULL : (prop_name = (vala_ccode_node_unref (prop_name), NULL)), _tmp152);
							_tmp151 = (g_free (_tmp151), NULL);
							_tmp150 = (g_free (_tmp150), NULL);
							_tmp155 = NULL;
							_tmp154 = NULL;
							_tmp153 = NULL;
							param_name = (_tmp155 = vala_ccode_identifier_new (_tmp154 = g_strdup_printf ("%s_destroy_func", _tmp153 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), (param_name == NULL) ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL)), _tmp155);
							_tmp154 = (g_free (_tmp154), NULL);
							_tmp153 = (g_free (_tmp153), NULL);
							_tmp159 = NULL;
							_tmp158 = NULL;
							_tmp157 = NULL;
							_tmp156 = NULL;
							vala_ccode_fragment_append (cinit, (ValaCCodeNode*) (_tmp159 = vala_ccode_expression_statement_new (_tmp158 = vala_ccode_module_get_construct_property_assignment ((ValaCCodeModule*) self, prop_name, (ValaDataType*) (_tmp157 = vala_pointer_type_new ((ValaDataType*) (_tmp156 = vala_void_type_new ()), NULL)), (ValaCCodeExpression*) param_name))));
							(_tmp159 == NULL) ? NULL : (_tmp159 = (vala_ccode_node_unref (_tmp159), NULL));
							(_tmp158 == NULL) ? NULL : (_tmp158 = (vala_ccode_node_unref (_tmp158), NULL));
							(_tmp157 == NULL) ? NULL : (_tmp157 = (vala_code_node_unref (_tmp157), NULL));
							(_tmp156 == NULL) ? NULL : (_tmp156 = (vala_code_node_unref (_tmp156), NULL));
							(type_param == NULL) ? NULL : (type_param = (vala_code_node_unref (type_param), NULL));
							(prop_name == NULL) ? NULL : (prop_name = (vala_ccode_node_unref (prop_name), NULL));
							(param_name == NULL) ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL));
						}
						(type_param_it == NULL) ? NULL : (type_param_it = (gee_collection_object_unref (type_param_it), NULL));
					}
				} else {
					if (in_gtypeinstance_creation_method) {
						ValaClass* _tmp160;
						ValaClass* cl;
						char* _tmp162;
						char* _tmp161;
						ValaCCodeDeclaration* _tmp163;
						ValaCCodeDeclaration* cdeclaration;
						ValaCCodeVariableDeclarator* cdecl_;
						_tmp160 = NULL;
						cl = (_tmp160 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), (_tmp160 == NULL) ? NULL : vala_code_node_ref (_tmp160));
						_tmp162 = NULL;
						_tmp161 = NULL;
						_tmp163 = NULL;
						cdeclaration = (_tmp163 = vala_ccode_declaration_new (_tmp162 = g_strconcat (_tmp161 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE), "*", NULL)), _tmp162 = (g_free (_tmp162), NULL), _tmp161 = (g_free (_tmp161), NULL), _tmp163);
						cdecl_ = vala_ccode_variable_declarator_new ("self");
						vala_ccode_declaration_add_declarator (cdeclaration, (ValaCCodeDeclarator*) cdecl_);
						vala_ccode_fragment_append (cinit, (ValaCCodeNode*) cdeclaration);
						if (!vala_creation_method_get_chain_up ((VALA_CREATION_METHOD (m)))) {
							ValaCCodeIdentifier* _tmp164;
							ValaCCodeFunctionCall* _tmp165;
							ValaCCodeFunctionCall* ccall;
							ValaCCodeIdentifier* _tmp166;
							ValaCCodeCastExpression* _tmp169;
							char* _tmp168;
							char* _tmp167;
							/* TODO implicitly chain up to base class as in add_object_creation*/
							_tmp164 = NULL;
							_tmp165 = NULL;
							ccall = (_tmp165 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp164 = vala_ccode_identifier_new ("g_type_create_instance"))), (_tmp164 == NULL) ? NULL : (_tmp164 = (vala_ccode_node_unref (_tmp164), NULL)), _tmp165);
							_tmp166 = NULL;
							vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp166 = vala_ccode_identifier_new ("object_type")));
							(_tmp166 == NULL) ? NULL : (_tmp166 = (vala_ccode_node_unref (_tmp166), NULL));
							_tmp169 = NULL;
							_tmp168 = NULL;
							_tmp167 = NULL;
							vala_ccode_variable_declarator_set_initializer (cdecl_, (ValaCCodeExpression*) (_tmp169 = vala_ccode_cast_expression_new ((ValaCCodeExpression*) ccall, _tmp168 = g_strconcat (_tmp167 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE), "*", NULL))));
							(_tmp169 == NULL) ? NULL : (_tmp169 = (vala_ccode_node_unref (_tmp169), NULL));
							_tmp168 = (g_free (_tmp168), NULL);
							_tmp167 = (g_free (_tmp167), NULL);
							(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
						}
						/* type, dup func, and destroy func fields for generic types */
						{
							GeeList* _tmp170;
							GeeIterator* _tmp171;
							GeeIterator* type_param_it;
							/* type, dup func, and destroy func fields for generic types */
							_tmp170 = NULL;
							_tmp171 = NULL;
							type_param_it = (_tmp171 = gee_iterable_iterator ((GeeIterable*) (_tmp170 = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class))), (_tmp170 == NULL) ? NULL : (_tmp170 = (gee_collection_object_unref (_tmp170), NULL)), _tmp171);
							/* type, dup func, and destroy func fields for generic types */
							while (gee_iterator_next (type_param_it)) {
								ValaTypeParameter* type_param;
								ValaCCodeIdentifier* param_name;
								ValaCCodeAssignment* assign;
								ValaCCodeIdentifier* _tmp172;
								ValaCCodeMemberAccess* _tmp173;
								ValaCCodeMemberAccess* priv_access;
								ValaCCodeIdentifier* _tmp176;
								char* _tmp175;
								char* _tmp174;
								ValaCCodeAssignment* _tmp178;
								ValaCCodeMemberAccess* _tmp177;
								ValaCCodeExpressionStatement* _tmp179;
								ValaCCodeIdentifier* _tmp182;
								char* _tmp181;
								char* _tmp180;
								ValaCCodeAssignment* _tmp184;
								ValaCCodeMemberAccess* _tmp183;
								ValaCCodeExpressionStatement* _tmp185;
								ValaCCodeIdentifier* _tmp188;
								char* _tmp187;
								char* _tmp186;
								ValaCCodeAssignment* _tmp190;
								ValaCCodeMemberAccess* _tmp189;
								ValaCCodeExpressionStatement* _tmp191;
								/* type, dup func, and destroy func fields for generic types */
								type_param = (ValaTypeParameter*) gee_iterator_get (type_param_it);
								param_name = NULL;
								assign = NULL;
								_tmp172 = NULL;
								_tmp173 = NULL;
								priv_access = (_tmp173 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp172 = vala_ccode_identifier_new ("self")), "priv"), (_tmp172 == NULL) ? NULL : (_tmp172 = (vala_ccode_node_unref (_tmp172), NULL)), _tmp173);
								_tmp176 = NULL;
								_tmp175 = NULL;
								_tmp174 = NULL;
								param_name = (_tmp176 = vala_ccode_identifier_new (_tmp175 = g_strdup_printf ("%s_type", _tmp174 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), (param_name == NULL) ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL)), _tmp176);
								_tmp175 = (g_free (_tmp175), NULL);
								_tmp174 = (g_free (_tmp174), NULL);
								_tmp178 = NULL;
								_tmp177 = NULL;
								assign = (_tmp178 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp177 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) priv_access, vala_ccode_identifier_get_name (param_name))), (ValaCCodeExpression*) param_name, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (assign == NULL) ? NULL : (assign = (vala_ccode_node_unref (assign), NULL)), _tmp178);
								(_tmp177 == NULL) ? NULL : (_tmp177 = (vala_ccode_node_unref (_tmp177), NULL));
								_tmp179 = NULL;
								vala_ccode_fragment_append (cinit, (ValaCCodeNode*) (_tmp179 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) assign)));
								(_tmp179 == NULL) ? NULL : (_tmp179 = (vala_ccode_node_unref (_tmp179), NULL));
								_tmp182 = NULL;
								_tmp181 = NULL;
								_tmp180 = NULL;
								param_name = (_tmp182 = vala_ccode_identifier_new (_tmp181 = g_strdup_printf ("%s_dup_func", _tmp180 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), (param_name == NULL) ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL)), _tmp182);
								_tmp181 = (g_free (_tmp181), NULL);
								_tmp180 = (g_free (_tmp180), NULL);
								_tmp184 = NULL;
								_tmp183 = NULL;
								assign = (_tmp184 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp183 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) priv_access, vala_ccode_identifier_get_name (param_name))), (ValaCCodeExpression*) param_name, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (assign == NULL) ? NULL : (assign = (vala_ccode_node_unref (assign), NULL)), _tmp184);
								(_tmp183 == NULL) ? NULL : (_tmp183 = (vala_ccode_node_unref (_tmp183), NULL));
								_tmp185 = NULL;
								vala_ccode_fragment_append (cinit, (ValaCCodeNode*) (_tmp185 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) assign)));
								(_tmp185 == NULL) ? NULL : (_tmp185 = (vala_ccode_node_unref (_tmp185), NULL));
								_tmp188 = NULL;
								_tmp187 = NULL;
								_tmp186 = NULL;
								param_name = (_tmp188 = vala_ccode_identifier_new (_tmp187 = g_strdup_printf ("%s_destroy_func", _tmp186 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), (param_name == NULL) ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL)), _tmp188);
								_tmp187 = (g_free (_tmp187), NULL);
								_tmp186 = (g_free (_tmp186), NULL);
								_tmp190 = NULL;
								_tmp189 = NULL;
								assign = (_tmp190 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp189 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) priv_access, vala_ccode_identifier_get_name (param_name))), (ValaCCodeExpression*) param_name, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (assign == NULL) ? NULL : (assign = (vala_ccode_node_unref (assign), NULL)), _tmp190);
								(_tmp189 == NULL) ? NULL : (_tmp189 = (vala_ccode_node_unref (_tmp189), NULL));
								_tmp191 = NULL;
								vala_ccode_fragment_append (cinit, (ValaCCodeNode*) (_tmp191 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) assign)));
								(_tmp191 == NULL) ? NULL : (_tmp191 = (vala_ccode_node_unref (_tmp191), NULL));
								(type_param == NULL) ? NULL : (type_param = (vala_code_node_unref (type_param), NULL));
								(param_name == NULL) ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL));
								(assign == NULL) ? NULL : (assign = (vala_ccode_node_unref (assign), NULL));
								(priv_access == NULL) ? NULL : (priv_access = (vala_ccode_node_unref (priv_access), NULL));
							}
							(type_param_it == NULL) ? NULL : (type_param_it = (gee_collection_object_unref (type_param_it), NULL));
						}
						(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
						(cdeclaration == NULL) ? NULL : (cdeclaration = (vala_ccode_node_unref (cdeclaration), NULL));
						(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
					} else {
						if (VALA_IS_CLASS (((ValaCCodeBaseModule*) self)->current_type_symbol)) {
							ValaClass* _tmp192;
							ValaClass* cl;
							char* _tmp194;
							char* _tmp193;
							ValaCCodeDeclaration* _tmp195;
							ValaCCodeDeclaration* cdecl_;
							ValaCCodeIdentifier* _tmp196;
							ValaCCodeFunctionCall* _tmp197;
							ValaCCodeFunctionCall* ccall;
							ValaCCodeIdentifier* _tmp199;
							char* _tmp198;
							ValaCCodeVariableDeclarator* _tmp200;
							ValaCCodeIdentifier* _tmp203;
							char* _tmp202;
							char* _tmp201;
							ValaCCodeFunctionCall* _tmp204;
							ValaCCodeFunctionCall* cinitcall;
							ValaCCodeIdentifier* _tmp205;
							ValaCCodeExpressionStatement* _tmp206;
							_tmp192 = NULL;
							cl = (_tmp192 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), (_tmp192 == NULL) ? NULL : vala_code_node_ref (_tmp192));
							_tmp194 = NULL;
							_tmp193 = NULL;
							_tmp195 = NULL;
							cdecl_ = (_tmp195 = vala_ccode_declaration_new (_tmp194 = g_strconcat (_tmp193 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE), "*", NULL)), _tmp194 = (g_free (_tmp194), NULL), _tmp193 = (g_free (_tmp193), NULL), _tmp195);
							_tmp196 = NULL;
							_tmp197 = NULL;
							ccall = (_tmp197 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp196 = vala_ccode_identifier_new ("g_slice_new0"))), (_tmp196 == NULL) ? NULL : (_tmp196 = (vala_ccode_node_unref (_tmp196), NULL)), _tmp197);
							_tmp199 = NULL;
							_tmp198 = NULL;
							vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp199 = vala_ccode_identifier_new (_tmp198 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))));
							(_tmp199 == NULL) ? NULL : (_tmp199 = (vala_ccode_node_unref (_tmp199), NULL));
							_tmp198 = (g_free (_tmp198), NULL);
							_tmp200 = NULL;
							vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp200 = vala_ccode_variable_declarator_new_with_initializer ("self", (ValaCCodeExpression*) ccall)));
							(_tmp200 == NULL) ? NULL : (_tmp200 = (vala_ccode_node_unref (_tmp200), NULL));
							vala_ccode_fragment_append (cinit, (ValaCCodeNode*) cdecl_);
							_tmp203 = NULL;
							_tmp202 = NULL;
							_tmp201 = NULL;
							_tmp204 = NULL;
							cinitcall = (_tmp204 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp203 = vala_ccode_identifier_new (_tmp202 = g_strdup_printf ("%s_instance_init", _tmp201 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL))))), (_tmp203 == NULL) ? NULL : (_tmp203 = (vala_ccode_node_unref (_tmp203), NULL)), _tmp202 = (g_free (_tmp202), NULL), _tmp201 = (g_free (_tmp201), NULL), _tmp204);
							_tmp205 = NULL;
							vala_ccode_function_call_add_argument (cinitcall, (ValaCCodeExpression*) (_tmp205 = vala_ccode_identifier_new ("self")));
							(_tmp205 == NULL) ? NULL : (_tmp205 = (vala_ccode_node_unref (_tmp205), NULL));
							_tmp206 = NULL;
							vala_ccode_fragment_append (cinit, (ValaCCodeNode*) (_tmp206 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cinitcall)));
							(_tmp206 == NULL) ? NULL : (_tmp206 = (vala_ccode_node_unref (_tmp206), NULL));
							(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
							(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
							(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
							(cinitcall == NULL) ? NULL : (cinitcall = (vala_ccode_node_unref (cinitcall), NULL));
						} else {
							ValaStruct* _tmp207;
							ValaStruct* st;
							ValaCCodeIdentifier* _tmp208;
							ValaCCodeFunctionCall* _tmp209;
							ValaCCodeFunctionCall* czero;
							ValaCCodeIdentifier* _tmp210;
							ValaCCodeConstant* _tmp211;
							ValaCCodeIdentifier* _tmp214;
							char* _tmp213;
							char* _tmp212;
							ValaCCodeExpressionStatement* _tmp215;
							_tmp207 = NULL;
							st = (_tmp207 = VALA_STRUCT (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), (_tmp207 == NULL) ? NULL : vala_code_node_ref (_tmp207));
							/* memset needs string.h*/
							((ValaCCodeBaseModule*) self)->string_h_needed = TRUE;
							_tmp208 = NULL;
							_tmp209 = NULL;
							czero = (_tmp209 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp208 = vala_ccode_identifier_new ("memset"))), (_tmp208 == NULL) ? NULL : (_tmp208 = (vala_ccode_node_unref (_tmp208), NULL)), _tmp209);
							_tmp210 = NULL;
							vala_ccode_function_call_add_argument (czero, (ValaCCodeExpression*) (_tmp210 = vala_ccode_identifier_new ("self")));
							(_tmp210 == NULL) ? NULL : (_tmp210 = (vala_ccode_node_unref (_tmp210), NULL));
							_tmp211 = NULL;
							vala_ccode_function_call_add_argument (czero, (ValaCCodeExpression*) (_tmp211 = vala_ccode_constant_new ("0")));
							(_tmp211 == NULL) ? NULL : (_tmp211 = (vala_ccode_node_unref (_tmp211), NULL));
							_tmp214 = NULL;
							_tmp213 = NULL;
							_tmp212 = NULL;
							vala_ccode_function_call_add_argument (czero, (ValaCCodeExpression*) (_tmp214 = vala_ccode_identifier_new (_tmp213 = g_strdup_printf ("sizeof (%s)", _tmp212 = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE)))));
							(_tmp214 == NULL) ? NULL : (_tmp214 = (vala_ccode_node_unref (_tmp214), NULL));
							_tmp213 = (g_free (_tmp213), NULL);
							_tmp212 = (g_free (_tmp212), NULL);
							_tmp215 = NULL;
							vala_ccode_fragment_append (cinit, (ValaCCodeNode*) (_tmp215 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) czero)));
							(_tmp215 == NULL) ? NULL : (_tmp215 = (vala_ccode_node_unref (_tmp215), NULL));
							(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
							(czero == NULL) ? NULL : (czero = (vala_ccode_node_unref (czero), NULL));
						}
					}
				}
			}
			_tmp216 = FALSE;
			if (vala_code_context_get_module_init_method (vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self)) == m) {
				_tmp216 = ((ValaCCodeBaseModule*) self)->in_plugin;
			} else {
				_tmp216 = FALSE;
			}
			if (_tmp216) {
				/* GTypeModule-based plug-in, register types*/
				vala_ccode_fragment_append (cinit, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->module_init_fragment);
			}
			{
				GeeList* _tmp217;
				GeeIterator* _tmp218;
				GeeIterator* precondition_it;
				_tmp217 = NULL;
				_tmp218 = NULL;
				precondition_it = (_tmp218 = gee_iterable_iterator ((GeeIterable*) (_tmp217 = vala_method_get_preconditions (m))), (_tmp217 == NULL) ? NULL : (_tmp217 = (gee_collection_object_unref (_tmp217), NULL)), _tmp218);
				while (gee_iterator_next (precondition_it)) {
					ValaExpression* precondition;
					ValaCCodeStatement* _tmp219;
					precondition = (ValaExpression*) gee_iterator_get (precondition_it);
					_tmp219 = NULL;
					vala_ccode_fragment_append (cinit, (ValaCCodeNode*) (_tmp219 = vala_ccode_method_module_create_precondition_statement (self, (ValaCodeNode*) m, creturn_type, precondition)));
					(_tmp219 == NULL) ? NULL : (_tmp219 = (vala_ccode_node_unref (_tmp219), NULL));
					(precondition == NULL) ? NULL : (precondition = (vala_code_node_unref (precondition), NULL));
				}
				(precondition_it == NULL) ? NULL : (precondition_it = (gee_collection_object_unref (precondition_it), NULL));
			}
			(cinit == NULL) ? NULL : (cinit = (vala_ccode_node_unref (cinit), NULL));
		} else {
			if (vala_method_get_is_abstract (m)) {
				ValaCCodeBlock* cblock;
				ValaCCodeStatement* _tmp220;
				ValaCCodeIdentifier* _tmp221;
				ValaCCodeFunctionCall* _tmp222;
				ValaCCodeFunctionCall* type_from_instance_call;
				ValaCCodeIdentifier* _tmp223;
				ValaCCodeIdentifier* _tmp224;
				ValaCCodeFunctionCall* _tmp225;
				ValaCCodeFunctionCall* type_name_call;
				char* _tmp226;
				char* _tmp227;
				char* error_string;
				ValaCCodeIdentifier* _tmp228;
				ValaCCodeFunctionCall* _tmp229;
				ValaCCodeFunctionCall* cerrorcall;
				ValaCCodeConstant* _tmp230;
				ValaCCodeExpressionStatement* _tmp231;
				ValaCCodeReturnStatement* _tmp233;
				ValaCCodeExpression* _tmp232;
				/* generate helpful error message if a sublcass does not implement an abstract method.
				 This is only meaningful for subclasses implemented in C since the vala compiler would
				 complain during compile time of such en error.*/
				cblock = vala_ccode_block_new ();
				/* add a typecheck statement for "self"*/
				_tmp220 = NULL;
				vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp220 = vala_ccode_method_module_create_method_type_check_statement (self, m, creturn_type, ((ValaCCodeBaseModule*) self)->current_type_symbol, TRUE, "self")));
				(_tmp220 == NULL) ? NULL : (_tmp220 = (vala_ccode_node_unref (_tmp220), NULL));
				/* add critical warning that this method should not have been called*/
				_tmp221 = NULL;
				_tmp222 = NULL;
				type_from_instance_call = (_tmp222 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp221 = vala_ccode_identifier_new ("G_TYPE_FROM_INSTANCE"))), (_tmp221 == NULL) ? NULL : (_tmp221 = (vala_ccode_node_unref (_tmp221), NULL)), _tmp222);
				_tmp223 = NULL;
				vala_ccode_function_call_add_argument (type_from_instance_call, (ValaCCodeExpression*) (_tmp223 = vala_ccode_identifier_new ("self")));
				(_tmp223 == NULL) ? NULL : (_tmp223 = (vala_ccode_node_unref (_tmp223), NULL));
				_tmp224 = NULL;
				_tmp225 = NULL;
				type_name_call = (_tmp225 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp224 = vala_ccode_identifier_new ("g_type_name"))), (_tmp224 == NULL) ? NULL : (_tmp224 = (vala_ccode_node_unref (_tmp224), NULL)), _tmp225);
				vala_ccode_function_call_add_argument (type_name_call, (ValaCCodeExpression*) type_from_instance_call);
				_tmp226 = NULL;
				_tmp227 = NULL;
				error_string = (_tmp227 = g_strdup_printf ("\"Type `%%s' does not implement abstract method `%s'\"", _tmp226 = vala_method_get_cname (m)), _tmp226 = (g_free (_tmp226), NULL), _tmp227);
				_tmp228 = NULL;
				_tmp229 = NULL;
				cerrorcall = (_tmp229 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp228 = vala_ccode_identifier_new ("g_critical"))), (_tmp228 == NULL) ? NULL : (_tmp228 = (vala_ccode_node_unref (_tmp228), NULL)), _tmp229);
				_tmp230 = NULL;
				vala_ccode_function_call_add_argument (cerrorcall, (ValaCCodeExpression*) (_tmp230 = vala_ccode_constant_new (error_string)));
				(_tmp230 == NULL) ? NULL : (_tmp230 = (vala_ccode_node_unref (_tmp230), NULL));
				vala_ccode_function_call_add_argument (cerrorcall, (ValaCCodeExpression*) type_name_call);
				_tmp231 = NULL;
				vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp231 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cerrorcall)));
				(_tmp231 == NULL) ? NULL : (_tmp231 = (vala_ccode_node_unref (_tmp231), NULL));
				/* add return statement*/
				_tmp233 = NULL;
				_tmp232 = NULL;
				vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp233 = vala_ccode_return_statement_new (_tmp232 = vala_ccode_base_module_default_value_for_type ((ValaCCodeBaseModule*) self, creturn_type, FALSE))));
				(_tmp233 == NULL) ? NULL : (_tmp233 = (vala_ccode_node_unref (_tmp233), NULL));
				(_tmp232 == NULL) ? NULL : (_tmp232 = (vala_ccode_node_unref (_tmp232), NULL));
				vala_ccode_function_set_block (((ValaCCodeBaseModule*) self)->function, cblock);
				vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function);
				(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
				(type_from_instance_call == NULL) ? NULL : (type_from_instance_call = (vala_ccode_node_unref (type_from_instance_call), NULL));
				(type_name_call == NULL) ? NULL : (type_name_call = (vala_ccode_node_unref (type_name_call), NULL));
				error_string = (g_free (error_string), NULL);
				(cerrorcall == NULL) ? NULL : (cerrorcall = (vala_ccode_node_unref (cerrorcall), NULL));
			}
		}
	}
	_tmp234 = FALSE;
	if (vala_method_get_is_abstract (m)) {
		_tmp234 = TRUE;
	} else {
		_tmp234 = vala_method_get_is_virtual (m);
	}
	if (_tmp234) {
		GeeHashMap* _tmp235;
		GeeHashMap* carg_map;
		_tmp235 = NULL;
		cparam_map = (_tmp235 = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal), (cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL)), _tmp235);
		carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
		vala_ccode_method_module_generate_vfunc (self, m, creturn_type, (GeeMap*) cparam_map, (GeeMap*) carg_map, "", 3);
		(carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL));
	}
	if (vala_method_get_entry_point (m)) {
		ValaCCodeFunction* cmain;
		ValaCCodeFormalParameter* _tmp236;
		ValaCCodeFormalParameter* _tmp237;
		ValaCCodeBlock* main_block;
		ValaCCodeFunctionCall* _tmp243;
		ValaCCodeIdentifier* _tmp242;
		ValaCCodeExpressionStatement* _tmp244;
		ValaCCodeExpressionStatement* type_init_call;
		ValaCCodeIdentifier* _tmp245;
		ValaCCodeFunctionCall* _tmp246;
		ValaCCodeFunctionCall* main_call;
		GeeList* _tmp247;
		gboolean _tmp248;
		/* m is possible entry point, add appropriate startup code*/
		cmain = vala_ccode_function_new ("main", "int");
		vala_ccode_node_set_line ((ValaCCodeNode*) cmain, vala_ccode_node_get_line ((ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function));
		_tmp236 = NULL;
		vala_ccode_function_add_parameter (cmain, _tmp236 = vala_ccode_formal_parameter_new ("argc", "int"));
		(_tmp236 == NULL) ? NULL : (_tmp236 = (vala_ccode_node_unref (_tmp236), NULL));
		_tmp237 = NULL;
		vala_ccode_function_add_parameter (cmain, _tmp237 = vala_ccode_formal_parameter_new ("argv", "char **"));
		(_tmp237 == NULL) ? NULL : (_tmp237 = (vala_ccode_node_unref (_tmp237), NULL));
		main_block = vala_ccode_block_new ();
		if (vala_code_context_get_thread (vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self))) {
			ValaCCodeIdentifier* _tmp238;
			ValaCCodeFunctionCall* _tmp239;
			ValaCCodeFunctionCall* thread_init_call;
			ValaCCodeConstant* _tmp240;
			ValaCCodeExpressionStatement* _tmp241;
			_tmp238 = NULL;
			_tmp239 = NULL;
			thread_init_call = (_tmp239 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp238 = vala_ccode_identifier_new ("g_thread_init"))), (_tmp238 == NULL) ? NULL : (_tmp238 = (vala_ccode_node_unref (_tmp238), NULL)), _tmp239);
			vala_ccode_node_set_line ((ValaCCodeNode*) thread_init_call, vala_ccode_node_get_line ((ValaCCodeNode*) cmain));
			_tmp240 = NULL;
			vala_ccode_function_call_add_argument (thread_init_call, (ValaCCodeExpression*) (_tmp240 = vala_ccode_constant_new ("NULL")));
			(_tmp240 == NULL) ? NULL : (_tmp240 = (vala_ccode_node_unref (_tmp240), NULL));
			_tmp241 = NULL;
			vala_ccode_block_add_statement (main_block, (ValaCCodeNode*) (_tmp241 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) thread_init_call)));
			(_tmp241 == NULL) ? NULL : (_tmp241 = (vala_ccode_node_unref (_tmp241), NULL));
			(thread_init_call == NULL) ? NULL : (thread_init_call = (vala_ccode_node_unref (thread_init_call), NULL));
		}
		_tmp243 = NULL;
		_tmp242 = NULL;
		_tmp244 = NULL;
		type_init_call = (_tmp244 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp243 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp242 = vala_ccode_identifier_new ("g_type_init"))))), (_tmp243 == NULL) ? NULL : (_tmp243 = (vala_ccode_node_unref (_tmp243), NULL)), (_tmp242 == NULL) ? NULL : (_tmp242 = (vala_ccode_node_unref (_tmp242), NULL)), _tmp244);
		vala_ccode_node_set_line ((ValaCCodeNode*) type_init_call, vala_ccode_node_get_line ((ValaCCodeNode*) cmain));
		vala_ccode_block_add_statement (main_block, (ValaCCodeNode*) type_init_call);
		_tmp245 = NULL;
		_tmp246 = NULL;
		main_call = (_tmp246 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp245 = vala_ccode_identifier_new (vala_ccode_function_get_name (((ValaCCodeBaseModule*) self)->function)))), (_tmp245 == NULL) ? NULL : (_tmp245 = (vala_ccode_node_unref (_tmp245), NULL)), _tmp246);
		_tmp247 = NULL;
		if ((_tmp248 = gee_collection_get_size ((GeeCollection*) (_tmp247 = vala_method_get_parameters (m))) == 1, (_tmp247 == NULL) ? NULL : (_tmp247 = (gee_collection_object_unref (_tmp247), NULL)), _tmp248)) {
			ValaCCodeIdentifier* _tmp249;
			ValaCCodeIdentifier* _tmp250;
			_tmp249 = NULL;
			vala_ccode_function_call_add_argument (main_call, (ValaCCodeExpression*) (_tmp249 = vala_ccode_identifier_new ("argv")));
			(_tmp249 == NULL) ? NULL : (_tmp249 = (vala_ccode_node_unref (_tmp249), NULL));
			_tmp250 = NULL;
			vala_ccode_function_call_add_argument (main_call, (ValaCCodeExpression*) (_tmp250 = vala_ccode_identifier_new ("argc")));
			(_tmp250 == NULL) ? NULL : (_tmp250 = (vala_ccode_node_unref (_tmp250), NULL));
		}
		if (VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
			ValaCCodeExpressionStatement* main_stmt;
			ValaCCodeConstant* _tmp251;
			ValaCCodeReturnStatement* _tmp252;
			ValaCCodeReturnStatement* ret_stmt;
			/* method returns void, always use 0 as exit code*/
			main_stmt = vala_ccode_expression_statement_new ((ValaCCodeExpression*) main_call);
			vala_ccode_node_set_line ((ValaCCodeNode*) main_stmt, vala_ccode_node_get_line ((ValaCCodeNode*) cmain));
			vala_ccode_block_add_statement (main_block, (ValaCCodeNode*) main_stmt);
			_tmp251 = NULL;
			_tmp252 = NULL;
			ret_stmt = (_tmp252 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp251 = vala_ccode_constant_new ("0"))), (_tmp251 == NULL) ? NULL : (_tmp251 = (vala_ccode_node_unref (_tmp251), NULL)), _tmp252);
			vala_ccode_node_set_line ((ValaCCodeNode*) ret_stmt, vala_ccode_node_get_line ((ValaCCodeNode*) cmain));
			vala_ccode_block_add_statement (main_block, (ValaCCodeNode*) ret_stmt);
			(main_stmt == NULL) ? NULL : (main_stmt = (vala_ccode_node_unref (main_stmt), NULL));
			(ret_stmt == NULL) ? NULL : (ret_stmt = (vala_ccode_node_unref (ret_stmt), NULL));
		} else {
			ValaCCodeReturnStatement* main_stmt;
			main_stmt = vala_ccode_return_statement_new ((ValaCCodeExpression*) main_call);
			vala_ccode_node_set_line ((ValaCCodeNode*) main_stmt, vala_ccode_node_get_line ((ValaCCodeNode*) cmain));
			vala_ccode_block_add_statement (main_block, (ValaCCodeNode*) main_stmt);
			(main_stmt == NULL) ? NULL : (main_stmt = (vala_ccode_node_unref (main_stmt), NULL));
		}
		vala_ccode_function_set_block (cmain, main_block);
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) cmain);
		(cmain == NULL) ? NULL : (cmain = (vala_ccode_node_unref (cmain), NULL));
		(main_block == NULL) ? NULL : (main_block = (vala_ccode_node_unref (main_block), NULL));
		(type_init_call == NULL) ? NULL : (type_init_call = (vala_ccode_node_unref (type_init_call), NULL));
		(main_call == NULL) ? NULL : (main_call = (vala_ccode_node_unref (main_call), NULL));
	}
	(old_method == NULL) ? NULL : (old_method = (vala_code_node_unref (old_method), NULL));
	(old_return_type == NULL) ? NULL : (old_return_type = (vala_code_node_unref (old_return_type), NULL));
	(creturn_type == NULL) ? NULL : (creturn_type = (vala_code_node_unref (creturn_type), NULL));
	(cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL));
	(vdeclarator == NULL) ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL));
}


static void vala_ccode_method_module_real_generate_cparameters (ValaCCodeModule* base, ValaMethod* m, ValaDataType* creturn_type, gboolean in_gtypeinstance_creation_method, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction) {
	ValaCCodeMethodModule * self;
	gboolean _tmp0;
	gint last_pos;
	gint min_pos;
	self = (ValaCCodeMethodModule*) base;
	g_return_if_fail (m != NULL);
	g_return_if_fail (creturn_type != NULL);
	g_return_if_fail (cparam_map != NULL);
	g_return_if_fail (func != NULL);
	_tmp0 = FALSE;
	if (VALA_IS_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m))) {
		_tmp0 = VALA_IS_CREATION_METHOD (m);
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		ValaClass* _tmp1;
		ValaClass* cl;
		gboolean _tmp2;
		_tmp1 = NULL;
		cl = (_tmp1 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
		_tmp2 = FALSE;
		if (!vala_class_get_is_compact (cl)) {
			_tmp2 = vcall == NULL;
		} else {
			_tmp2 = FALSE;
		}
		if (_tmp2) {
			ValaCCodeFormalParameter* _tmp3;
			_tmp3 = NULL;
			gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), _tmp3 = vala_ccode_formal_parameter_new ("object_type", "GType"));
			(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
		}
		(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	} else {
		gboolean _tmp4;
		_tmp4 = FALSE;
		if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
			_tmp4 = TRUE;
		} else {
			gboolean _tmp5;
			_tmp5 = FALSE;
			if (VALA_IS_STRUCT (vala_symbol_get_parent_symbol ((ValaSymbol*) m))) {
				_tmp5 = VALA_IS_CREATION_METHOD (m);
			} else {
				_tmp5 = FALSE;
			}
			_tmp4 = (_tmp5);
		}
		if (_tmp4) {
			ValaTypeSymbol* parent_type;
			ValaDataType* this_type;
			ValaCCodeFormalParameter* instance_param;
			gboolean _tmp9;
			gboolean _tmp10;
			parent_type = vala_ccode_method_module_find_parent_type (self, (ValaSymbol*) m);
			this_type = NULL;
			if (VALA_IS_CLASS (parent_type)) {
				ValaDataType* _tmp6;
				_tmp6 = NULL;
				this_type = (_tmp6 = (ValaDataType*) vala_object_type_new ((ValaObjectTypeSymbol*) VALA_CLASS (parent_type)), (this_type == NULL) ? NULL : (this_type = (vala_code_node_unref (this_type), NULL)), _tmp6);
			} else {
				if (VALA_IS_INTERFACE (parent_type)) {
					ValaDataType* _tmp7;
					_tmp7 = NULL;
					this_type = (_tmp7 = (ValaDataType*) vala_object_type_new ((ValaObjectTypeSymbol*) VALA_INTERFACE (parent_type)), (this_type == NULL) ? NULL : (this_type = (vala_code_node_unref (this_type), NULL)), _tmp7);
				} else {
					ValaDataType* _tmp8;
					_tmp8 = NULL;
					this_type = (_tmp8 = (ValaDataType*) vala_value_type_new (parent_type), (this_type == NULL) ? NULL : (this_type = (vala_code_node_unref (this_type), NULL)), _tmp8);
				}
			}
			instance_param = NULL;
			_tmp9 = FALSE;
			_tmp10 = FALSE;
			if (vala_method_get_base_interface_method (m) != NULL) {
				_tmp10 = !vala_method_get_is_abstract (m);
			} else {
				_tmp10 = FALSE;
			}
			if (_tmp10) {
				_tmp9 = !vala_method_get_is_virtual (m);
			} else {
				_tmp9 = FALSE;
			}
			if (_tmp9) {
				ValaObjectType* base_type;
				ValaCCodeFormalParameter* _tmp12;
				char* _tmp11;
				base_type = vala_object_type_new ((ValaObjectTypeSymbol*) VALA_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_method_get_base_interface_method (m))));
				_tmp12 = NULL;
				_tmp11 = NULL;
				instance_param = (_tmp12 = vala_ccode_formal_parameter_new ("base", _tmp11 = vala_data_type_get_cname ((ValaDataType*) base_type)), (instance_param == NULL) ? NULL : (instance_param = (vala_ccode_node_unref (instance_param), NULL)), _tmp12);
				_tmp11 = (g_free (_tmp11), NULL);
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
			} else {
				if (vala_method_get_overrides (m)) {
					ValaObjectType* base_type;
					ValaCCodeFormalParameter* _tmp14;
					char* _tmp13;
					base_type = vala_object_type_new ((ValaObjectTypeSymbol*) VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_method_get_base_method (m))));
					_tmp14 = NULL;
					_tmp13 = NULL;
					instance_param = (_tmp14 = vala_ccode_formal_parameter_new ("base", _tmp13 = vala_data_type_get_cname ((ValaDataType*) base_type)), (instance_param == NULL) ? NULL : (instance_param = (vala_ccode_node_unref (instance_param), NULL)), _tmp14);
					_tmp13 = (g_free (_tmp13), NULL);
					(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
				} else {
					gboolean _tmp15;
					_tmp15 = FALSE;
					if (VALA_IS_STRUCT (vala_symbol_get_parent_symbol ((ValaSymbol*) m))) {
						_tmp15 = !vala_struct_is_simple_type ((VALA_STRUCT (vala_symbol_get_parent_symbol ((ValaSymbol*) m))));
					} else {
						_tmp15 = FALSE;
					}
					if (_tmp15) {
						ValaCCodeFormalParameter* _tmp17;
						char* _tmp16;
						_tmp17 = NULL;
						_tmp16 = NULL;
						instance_param = (_tmp17 = vala_ccode_formal_parameter_new ("*self", _tmp16 = vala_data_type_get_cname (this_type)), (instance_param == NULL) ? NULL : (instance_param = (vala_ccode_node_unref (instance_param), NULL)), _tmp17);
						_tmp16 = (g_free (_tmp16), NULL);
					} else {
						ValaCCodeFormalParameter* _tmp19;
						char* _tmp18;
						_tmp19 = NULL;
						_tmp18 = NULL;
						instance_param = (_tmp19 = vala_ccode_formal_parameter_new ("self", _tmp18 = vala_data_type_get_cname (this_type)), (instance_param == NULL) ? NULL : (instance_param = (vala_ccode_node_unref (instance_param), NULL)), _tmp19);
						_tmp18 = (g_free (_tmp18), NULL);
					}
				}
			}
			gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), instance_param);
			(parent_type == NULL) ? NULL : (parent_type = (vala_code_node_unref (parent_type), NULL));
			(this_type == NULL) ? NULL : (this_type = (vala_code_node_unref (this_type), NULL));
			(instance_param == NULL) ? NULL : (instance_param = (vala_ccode_node_unref (instance_param), NULL));
		} else {
			if (vala_method_get_binding (m) == MEMBER_BINDING_CLASS) {
				ValaTypeSymbol* parent_type;
				ValaDataType* this_type;
				ValaDataType* _tmp20;
				char* _tmp21;
				ValaCCodeFormalParameter* _tmp22;
				ValaCCodeFormalParameter* class_param;
				parent_type = vala_ccode_method_module_find_parent_type (self, (ValaSymbol*) m);
				this_type = NULL;
				_tmp20 = NULL;
				this_type = (_tmp20 = (ValaDataType*) vala_class_type_new (VALA_CLASS (parent_type)), (this_type == NULL) ? NULL : (this_type = (vala_code_node_unref (this_type), NULL)), _tmp20);
				_tmp21 = NULL;
				_tmp22 = NULL;
				class_param = (_tmp22 = vala_ccode_formal_parameter_new ("klass", _tmp21 = vala_data_type_get_cname (this_type)), _tmp21 = (g_free (_tmp21), NULL), _tmp22);
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), class_param);
				(parent_type == NULL) ? NULL : (parent_type = (vala_code_node_unref (parent_type), NULL));
				(this_type == NULL) ? NULL : (this_type = (vala_code_node_unref (this_type), NULL));
				(class_param == NULL) ? NULL : (class_param = (vala_ccode_node_unref (class_param), NULL));
			}
		}
	}
	if (in_gtypeinstance_creation_method) {
		gint type_param_index;
		/* memory management for generic types*/
		type_param_index = 0;
		{
			GeeList* _tmp23;
			GeeIterator* _tmp24;
			GeeIterator* type_param_it;
			_tmp23 = NULL;
			_tmp24 = NULL;
			type_param_it = (_tmp24 = gee_iterable_iterator ((GeeIterable*) (_tmp23 = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class))), (_tmp23 == NULL) ? NULL : (_tmp23 = (gee_collection_object_unref (_tmp23), NULL)), _tmp24);
			while (gee_iterator_next (type_param_it)) {
				ValaTypeParameter* type_param;
				ValaCCodeFormalParameter* _tmp27;
				char* _tmp26;
				char* _tmp25;
				ValaCCodeFormalParameter* _tmp30;
				char* _tmp29;
				char* _tmp28;
				ValaCCodeFormalParameter* _tmp33;
				char* _tmp32;
				char* _tmp31;
				type_param = (ValaTypeParameter*) gee_iterator_get (type_param_it);
				_tmp27 = NULL;
				_tmp26 = NULL;
				_tmp25 = NULL;
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.01, FALSE)), _tmp27 = vala_ccode_formal_parameter_new (_tmp26 = g_strdup_printf ("%s_type", _tmp25 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)), "GType"));
				(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
				_tmp26 = (g_free (_tmp26), NULL);
				_tmp25 = (g_free (_tmp25), NULL);
				_tmp30 = NULL;
				_tmp29 = NULL;
				_tmp28 = NULL;
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.02, FALSE)), _tmp30 = vala_ccode_formal_parameter_new (_tmp29 = g_strdup_printf ("%s_dup_func", _tmp28 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)), "GBoxedCopyFunc"));
				(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
				_tmp29 = (g_free (_tmp29), NULL);
				_tmp28 = (g_free (_tmp28), NULL);
				_tmp33 = NULL;
				_tmp32 = NULL;
				_tmp31 = NULL;
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.03, FALSE)), _tmp33 = vala_ccode_formal_parameter_new (_tmp32 = g_strdup_printf ("%s_destroy_func", _tmp31 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)), "GDestroyNotify"));
				(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
				_tmp32 = (g_free (_tmp32), NULL);
				_tmp31 = (g_free (_tmp31), NULL);
				if (carg_map != NULL) {
					ValaCCodeIdentifier* _tmp36;
					char* _tmp35;
					char* _tmp34;
					ValaCCodeIdentifier* _tmp39;
					char* _tmp38;
					char* _tmp37;
					ValaCCodeIdentifier* _tmp42;
					char* _tmp41;
					char* _tmp40;
					_tmp36 = NULL;
					_tmp35 = NULL;
					_tmp34 = NULL;
					gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.01, FALSE)), (ValaCCodeExpression*) (_tmp36 = vala_ccode_identifier_new (_tmp35 = g_strdup_printf ("%s_type", _tmp34 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)))));
					(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
					_tmp35 = (g_free (_tmp35), NULL);
					_tmp34 = (g_free (_tmp34), NULL);
					_tmp39 = NULL;
					_tmp38 = NULL;
					_tmp37 = NULL;
					gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.02, FALSE)), (ValaCCodeExpression*) (_tmp39 = vala_ccode_identifier_new (_tmp38 = g_strdup_printf ("%s_dup_func", _tmp37 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)))));
					(_tmp39 == NULL) ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL));
					_tmp38 = (g_free (_tmp38), NULL);
					_tmp37 = (g_free (_tmp37), NULL);
					_tmp42 = NULL;
					_tmp41 = NULL;
					_tmp40 = NULL;
					gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.03, FALSE)), (ValaCCodeExpression*) (_tmp42 = vala_ccode_identifier_new (_tmp41 = g_strdup_printf ("%s_destroy_func", _tmp40 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)))));
					(_tmp42 == NULL) ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL));
					_tmp41 = (g_free (_tmp41), NULL);
					_tmp40 = (g_free (_tmp40), NULL);
				}
				type_param_index++;
				(type_param == NULL) ? NULL : (type_param = (vala_code_node_unref (type_param), NULL));
			}
			(type_param_it == NULL) ? NULL : (type_param_it = (gee_collection_object_unref (type_param_it), NULL));
		}
	}
	{
		GeeList* _tmp43;
		GeeIterator* _tmp44;
		GeeIterator* param_it;
		_tmp43 = NULL;
		_tmp44 = NULL;
		param_it = (_tmp44 = gee_iterable_iterator ((GeeIterable*) (_tmp43 = vala_method_get_parameters (m))), (_tmp43 == NULL) ? NULL : (_tmp43 = (gee_collection_object_unref (_tmp43), NULL)), _tmp44);
		while (gee_iterator_next (param_it)) {
			ValaFormalParameter* param;
			gboolean _tmp45;
			param = (ValaFormalParameter*) gee_iterator_get (param_it);
			if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_OUT) {
				if ((direction & 1) == 0) {
					/* no in paramters*/
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
					continue;
				}
			} else {
				if ((direction & 2) == 0) {
					/* no out paramters*/
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
					continue;
				}
			}
			_tmp45 = FALSE;
			if (!vala_formal_parameter_get_no_array_length (param)) {
				_tmp45 = VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param));
			} else {
				_tmp45 = FALSE;
			}
			if (_tmp45) {
				ValaArrayType* _tmp46;
				ValaArrayType* array_type;
				char* length_ctype;
				_tmp46 = NULL;
				array_type = (_tmp46 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp46 == NULL) ? NULL : vala_code_node_ref (_tmp46));
				length_ctype = g_strdup ("int");
				if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
					char* _tmp47;
					_tmp47 = NULL;
					length_ctype = (_tmp47 = g_strdup ("int*"), length_ctype = (g_free (length_ctype), NULL), _tmp47);
				}
				{
					gint dim;
					dim = 1;
					for (; dim <= vala_array_type_get_rank (array_type); dim++) {
						char* _tmp48;
						ValaCCodeFormalParameter* _tmp49;
						ValaCCodeFormalParameter* cparam;
						_tmp48 = NULL;
						_tmp49 = NULL;
						cparam = (_tmp49 = vala_ccode_formal_parameter_new (_tmp48 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_symbol_get_name ((ValaSymbol*) param), dim), length_ctype), _tmp48 = (g_free (_tmp48), NULL), _tmp49);
						gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_carray_length_parameter_position (param) + (0.01 * dim), FALSE)), cparam);
						if (carg_map != NULL) {
							ValaCCodeIdentifier* _tmp50;
							_tmp50 = NULL;
							gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_carray_length_parameter_position (param) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) (_tmp50 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))));
							(_tmp50 == NULL) ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL));
						}
						(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
					}
				}
				(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
				length_ctype = (g_free (length_ctype), NULL);
			}
			gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cparameter_position (param), FALSE)), VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode ((ValaCodeNode*) param)));
			if (carg_map != NULL) {
				ValaCCodeIdentifier* _tmp51;
				_tmp51 = NULL;
				gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cparameter_position (param), FALSE)), (ValaCCodeExpression*) (_tmp51 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))));
				(_tmp51 == NULL) ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL));
			}
			if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param))) {
				ValaDelegateType* _tmp52;
				ValaDelegateType* deleg_type;
				ValaDelegate* _tmp53;
				ValaDelegate* d;
				_tmp52 = NULL;
				deleg_type = (_tmp52 = VALA_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp52 == NULL) ? NULL : vala_code_node_ref (_tmp52));
				_tmp53 = NULL;
				d = (_tmp53 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp53 == NULL) ? NULL : vala_code_node_ref (_tmp53));
				if (vala_delegate_get_has_target (d)) {
					char* _tmp54;
					ValaCCodeFormalParameter* _tmp55;
					ValaCCodeFormalParameter* cparam;
					_tmp54 = NULL;
					_tmp55 = NULL;
					cparam = (_tmp55 = vala_ccode_formal_parameter_new (_tmp54 = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param)), "void*"), _tmp54 = (g_free (_tmp54), NULL), _tmp55);
					gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), cparam);
					if (carg_map != NULL) {
						ValaCCodeIdentifier* _tmp56;
						_tmp56 = NULL;
						gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), (ValaCCodeExpression*) (_tmp56 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))));
						(_tmp56 == NULL) ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL));
					}
					if (vala_data_type_get_value_owned ((ValaDataType*) deleg_type)) {
						ValaCCodeFormalParameter* _tmp58;
						char* _tmp57;
						_tmp58 = NULL;
						_tmp57 = NULL;
						cparam = (_tmp58 = vala_ccode_formal_parameter_new (_tmp57 = vala_ccode_base_module_get_delegate_target_destroy_notify_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param)), "GDestroyNotify"), (cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL)), _tmp58);
						_tmp57 = (g_free (_tmp57), NULL);
						gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param) + 0.01, FALSE)), cparam);
						if (carg_map != NULL) {
							ValaCCodeIdentifier* _tmp59;
							_tmp59 = NULL;
							gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param) + 0.01, FALSE)), (ValaCCodeExpression*) (_tmp59 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))));
							(_tmp59 == NULL) ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL));
						}
					}
					(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
				}
				(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
				(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
			} else {
				if (VALA_IS_METHOD_TYPE (vala_formal_parameter_get_parameter_type (param))) {
					char* _tmp60;
					ValaCCodeFormalParameter* _tmp61;
					ValaCCodeFormalParameter* cparam;
					_tmp60 = NULL;
					_tmp61 = NULL;
					cparam = (_tmp61 = vala_ccode_formal_parameter_new (_tmp60 = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param)), "void*"), _tmp60 = (g_free (_tmp60), NULL), _tmp61);
					gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), cparam);
					if (carg_map != NULL) {
						ValaCCodeIdentifier* _tmp62;
						_tmp62 = NULL;
						gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), (ValaCCodeExpression*) (_tmp62 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))));
						(_tmp62 == NULL) ? NULL : (_tmp62 = (vala_ccode_node_unref (_tmp62), NULL));
					}
					(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
				}
			}
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(param_it == NULL) ? NULL : (param_it = (gee_collection_object_unref (param_it), NULL));
	}
	if ((direction & 2) != 0) {
		gboolean _tmp63;
		GeeList* _tmp73;
		gboolean _tmp74;
		_tmp63 = FALSE;
		if (!vala_method_get_no_array_length (m)) {
			_tmp63 = VALA_IS_ARRAY_TYPE (creturn_type);
		} else {
			_tmp63 = FALSE;
		}
		if (_tmp63) {
			ValaArrayType* _tmp64;
			ValaArrayType* array_type;
			/* return array length if appropriate*/
			_tmp64 = NULL;
			array_type = (_tmp64 = VALA_ARRAY_TYPE (creturn_type), (_tmp64 == NULL) ? NULL : vala_code_node_ref (_tmp64));
			{
				gint dim;
				dim = 1;
				for (; dim <= vala_array_type_get_rank (array_type); dim++) {
					char* _tmp65;
					ValaCCodeFormalParameter* _tmp66;
					ValaCCodeFormalParameter* cparam;
					_tmp65 = NULL;
					_tmp66 = NULL;
					cparam = (_tmp66 = vala_ccode_formal_parameter_new (_tmp65 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), "result", dim), "int*"), _tmp65 = (g_free (_tmp65), NULL), _tmp66);
					gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_carray_length_parameter_position (m) + (0.01 * dim), FALSE)), cparam);
					if (carg_map != NULL) {
						ValaCCodeIdentifier* _tmp67;
						_tmp67 = NULL;
						gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_carray_length_parameter_position (m) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) (_tmp67 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))));
						(_tmp67 == NULL) ? NULL : (_tmp67 = (vala_ccode_node_unref (_tmp67), NULL));
					}
					(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
				}
			}
			(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		} else {
			if (VALA_IS_DELEGATE_TYPE (creturn_type)) {
				ValaDelegateType* _tmp68;
				ValaDelegateType* deleg_type;
				ValaDelegate* _tmp69;
				ValaDelegate* d;
				/* return delegate target if appropriate*/
				_tmp68 = NULL;
				deleg_type = (_tmp68 = VALA_DELEGATE_TYPE (creturn_type), (_tmp68 == NULL) ? NULL : vala_code_node_ref (_tmp68));
				_tmp69 = NULL;
				d = (_tmp69 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp69 == NULL) ? NULL : vala_code_node_ref (_tmp69));
				if (vala_delegate_get_has_target (d)) {
					char* _tmp70;
					ValaCCodeFormalParameter* _tmp71;
					ValaCCodeFormalParameter* cparam;
					_tmp70 = NULL;
					_tmp71 = NULL;
					cparam = (_tmp71 = vala_ccode_formal_parameter_new (_tmp70 = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, "result"), "void*"), _tmp70 = (g_free (_tmp70), NULL), _tmp71);
					gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cdelegate_target_parameter_position (m), FALSE)), cparam);
					if (carg_map != NULL) {
						ValaCCodeIdentifier* _tmp72;
						_tmp72 = NULL;
						gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cdelegate_target_parameter_position (m), FALSE)), (ValaCCodeExpression*) (_tmp72 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))));
						(_tmp72 == NULL) ? NULL : (_tmp72 = (vala_ccode_node_unref (_tmp72), NULL));
					}
					(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
				}
				(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
				(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
			}
		}
		_tmp73 = NULL;
		if ((_tmp74 = gee_collection_get_size ((GeeCollection*) (_tmp73 = vala_code_node_get_error_types ((ValaCodeNode*) m))) > 0, (_tmp73 == NULL) ? NULL : (_tmp73 = (gee_collection_object_unref (_tmp73), NULL)), _tmp74)) {
			ValaCCodeFormalParameter* cparam;
			cparam = vala_ccode_formal_parameter_new ("error", "GError**");
			gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), cparam);
			if (carg_map != NULL) {
				ValaCCodeIdentifier* _tmp75;
				_tmp75 = NULL;
				gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp75 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))));
				(_tmp75 == NULL) ? NULL : (_tmp75 = (vala_ccode_node_unref (_tmp75), NULL));
			}
			(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
		}
	}
	/* append C parameters in the right order*/
	last_pos = -1;
	min_pos = 0;
	while (TRUE) {
		ValaCCodeFormalParameter* _tmp80;
		min_pos = -1;
		{
			GeeSet* _tmp76;
			GeeIterator* _tmp77;
			GeeIterator* pos_it;
			_tmp76 = NULL;
			_tmp77 = NULL;
			pos_it = (_tmp77 = gee_iterable_iterator ((GeeIterable*) (_tmp76 = gee_map_get_keys (cparam_map))), (_tmp76 == NULL) ? NULL : (_tmp76 = (gee_collection_object_unref (_tmp76), NULL)), _tmp77);
			while (gee_iterator_next (pos_it)) {
				gint pos;
				gboolean _tmp78;
				pos = GPOINTER_TO_INT (gee_iterator_get (pos_it));
				_tmp78 = FALSE;
				if (pos > last_pos) {
					gboolean _tmp79;
					_tmp79 = FALSE;
					if (min_pos == (-1)) {
						_tmp79 = TRUE;
					} else {
						_tmp79 = pos < min_pos;
					}
					_tmp78 = (_tmp79);
				} else {
					_tmp78 = FALSE;
				}
				if (_tmp78) {
					min_pos = pos;
				}
			}
			(pos_it == NULL) ? NULL : (pos_it = (gee_collection_object_unref (pos_it), NULL));
		}
		if (min_pos == (-1)) {
			break;
		}
		_tmp80 = NULL;
		vala_ccode_function_add_parameter (func, _tmp80 = (ValaCCodeFormalParameter*) gee_map_get (cparam_map, GINT_TO_POINTER (min_pos)));
		(_tmp80 == NULL) ? NULL : (_tmp80 = (vala_ccode_node_unref (_tmp80), NULL));
		if (vdeclarator != NULL) {
			ValaCCodeFormalParameter* _tmp81;
			_tmp81 = NULL;
			vala_ccode_function_declarator_add_parameter (vdeclarator, _tmp81 = (ValaCCodeFormalParameter*) gee_map_get (cparam_map, GINT_TO_POINTER (min_pos)));
			(_tmp81 == NULL) ? NULL : (_tmp81 = (vala_ccode_node_unref (_tmp81), NULL));
		}
		if (vcall != NULL) {
			ValaCCodeExpression* _tmp82;
			_tmp82 = NULL;
			vala_ccode_function_call_add_argument (vcall, _tmp82 = (ValaCCodeExpression*) gee_map_get (carg_map, GINT_TO_POINTER (min_pos)));
			(_tmp82 == NULL) ? NULL : (_tmp82 = (vala_ccode_node_unref (_tmp82), NULL));
		}
		last_pos = min_pos;
	}
}


void vala_ccode_method_module_generate_vfunc (ValaCCodeMethodModule* self, ValaMethod* m, ValaDataType* return_type, GeeMap* cparam_map, GeeMap* carg_map, const char* suffix, gint direction) {
	gboolean visible;
	char* _tmp2;
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp3;
	ValaCCodeFunction* vfunc;
	ValaCCodeBlock* vblock;
	ValaCCodeFunctionCall* vcast;
	ValaCCodeIdentifier* _tmp17;
	ValaCCodeMemberAccess* _tmp19;
	char* _tmp18;
	ValaCCodeFunctionCall* _tmp20;
	ValaCCodeFunctionCall* vcall;
	ValaCCodeIdentifier* _tmp21;
	ValaCCodeStatement* cstmt;
	GeeList* _tmp32;
	gboolean _tmp33;
	gboolean _tmp41;
	gboolean _tmp42;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	g_return_if_fail (return_type != NULL);
	g_return_if_fail (cparam_map != NULL);
	g_return_if_fail (carg_map != NULL);
	g_return_if_fail (suffix != NULL);
	visible = !vala_symbol_is_internal_symbol ((ValaSymbol*) m);
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp3 = NULL;
	vfunc = (_tmp3 = vala_ccode_function_new (_tmp1 = g_strconcat (_tmp0 = vala_method_get_cname (m), suffix, NULL), _tmp2 = vala_data_type_get_cname (return_type)), _tmp2 = (g_free (_tmp2), NULL), _tmp1 = (g_free (_tmp1), NULL), _tmp0 = (g_free (_tmp0), NULL), _tmp3);
	vala_ccode_node_set_line ((ValaCCodeNode*) vfunc, vala_ccode_node_get_line ((ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function));
	vblock = vala_ccode_block_new ();
	{
		GeeList* _tmp4;
		GeeIterator* _tmp5;
		GeeIterator* precondition_it;
		_tmp4 = NULL;
		_tmp5 = NULL;
		precondition_it = (_tmp5 = gee_iterable_iterator ((GeeIterable*) (_tmp4 = vala_method_get_preconditions (m))), (_tmp4 == NULL) ? NULL : (_tmp4 = (gee_collection_object_unref (_tmp4), NULL)), _tmp5);
		while (gee_iterator_next (precondition_it)) {
			ValaExpression* precondition;
			ValaCCodeStatement* _tmp6;
			precondition = (ValaExpression*) gee_iterator_get (precondition_it);
			_tmp6 = NULL;
			vala_ccode_block_add_statement (vblock, (ValaCCodeNode*) (_tmp6 = vala_ccode_method_module_create_precondition_statement (self, (ValaCodeNode*) m, return_type, precondition)));
			(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
			(precondition == NULL) ? NULL : (precondition = (vala_code_node_unref (precondition), NULL));
		}
		(precondition_it == NULL) ? NULL : (precondition_it = (gee_collection_object_unref (precondition_it), NULL));
	}
	vcast = NULL;
	if (VALA_IS_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) m))) {
		ValaInterface* _tmp7;
		ValaInterface* iface;
		ValaCCodeFunctionCall* _tmp11;
		ValaCCodeIdentifier* _tmp10;
		char* _tmp9;
		char* _tmp8;
		_tmp7 = NULL;
		iface = (_tmp7 = VALA_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), (_tmp7 == NULL) ? NULL : vala_code_node_ref (_tmp7));
		_tmp11 = NULL;
		_tmp10 = NULL;
		_tmp9 = NULL;
		_tmp8 = NULL;
		vcast = (_tmp11 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp10 = vala_ccode_identifier_new (_tmp9 = g_strdup_printf ("%s_GET_INTERFACE", _tmp8 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) iface, NULL))))), (vcast == NULL) ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL)), _tmp11);
		(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
		_tmp9 = (g_free (_tmp9), NULL);
		_tmp8 = (g_free (_tmp8), NULL);
		(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
	} else {
		ValaClass* _tmp12;
		ValaClass* cl;
		ValaCCodeFunctionCall* _tmp16;
		ValaCCodeIdentifier* _tmp15;
		char* _tmp14;
		char* _tmp13;
		_tmp12 = NULL;
		cl = (_tmp12 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), (_tmp12 == NULL) ? NULL : vala_code_node_ref (_tmp12));
		_tmp16 = NULL;
		_tmp15 = NULL;
		_tmp14 = NULL;
		_tmp13 = NULL;
		vcast = (_tmp16 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp15 = vala_ccode_identifier_new (_tmp14 = g_strdup_printf ("%s_GET_CLASS", _tmp13 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL))))), (vcast == NULL) ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL)), _tmp16);
		(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
		_tmp14 = (g_free (_tmp14), NULL);
		_tmp13 = (g_free (_tmp13), NULL);
		(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	}
	_tmp17 = NULL;
	vala_ccode_function_call_add_argument (vcast, (ValaCCodeExpression*) (_tmp17 = vala_ccode_identifier_new ("self")));
	(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
	_tmp19 = NULL;
	_tmp18 = NULL;
	_tmp20 = NULL;
	vcall = (_tmp20 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp19 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) vcast, _tmp18 = g_strconcat (vala_method_get_vfunc_name (m), suffix, NULL)))), (_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)), _tmp18 = (g_free (_tmp18), NULL), _tmp20);
	_tmp21 = NULL;
	gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), (ValaCCodeExpression*) (_tmp21 = vala_ccode_identifier_new ("self")));
	(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
	vala_ccode_module_generate_cparameters ((ValaCCodeModule*) self, m, return_type, FALSE, cparam_map, vfunc, NULL, carg_map, vcall, direction);
	cstmt = NULL;
	if (VALA_IS_VOID_TYPE (return_type)) {
		ValaCCodeStatement* _tmp22;
		_tmp22 = NULL;
		cstmt = (_tmp22 = (ValaCCodeStatement*) vala_ccode_expression_statement_new ((ValaCCodeExpression*) vcall), (cstmt == NULL) ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL)), _tmp22);
	} else {
		GeeList* _tmp23;
		gboolean _tmp24;
		_tmp23 = NULL;
		if ((_tmp24 = gee_collection_get_size ((GeeCollection*) (_tmp23 = vala_method_get_postconditions (m))) == 0, (_tmp23 == NULL) ? NULL : (_tmp23 = (gee_collection_object_unref (_tmp23), NULL)), _tmp24)) {
			ValaCCodeStatement* _tmp25;
			/* pass method return value */
			_tmp25 = NULL;
			cstmt = (_tmp25 = (ValaCCodeStatement*) vala_ccode_return_statement_new ((ValaCCodeExpression*) vcall), (cstmt == NULL) ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL)), _tmp25);
		} else {
			char* _tmp27;
			char* _tmp26;
			ValaCCodeDeclaration* _tmp28;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp29;
			ValaCCodeStatement* _tmp31;
			ValaCCodeStatement* _tmp30;
			/* store method return value for postconditions */
			_tmp27 = NULL;
			_tmp26 = NULL;
			_tmp28 = NULL;
			cdecl_ = (_tmp28 = vala_ccode_declaration_new (_tmp27 = vala_ccode_method_module_get_creturn_type (self, m, _tmp26 = vala_data_type_get_cname (return_type))), _tmp27 = (g_free (_tmp27), NULL), _tmp26 = (g_free (_tmp26), NULL), _tmp28);
			_tmp29 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp29 = vala_ccode_variable_declarator_new_with_initializer ("result", (ValaCCodeExpression*) vcall)));
			(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
			_tmp31 = NULL;
			_tmp30 = NULL;
			cstmt = (_tmp31 = (_tmp30 = (ValaCCodeStatement*) cdecl_, (_tmp30 == NULL) ? NULL : vala_ccode_node_ref (_tmp30)), (cstmt == NULL) ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL)), _tmp31);
			(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
		}
	}
	vala_ccode_node_set_line ((ValaCCodeNode*) cstmt, vala_ccode_node_get_line ((ValaCCodeNode*) vfunc));
	vala_ccode_block_add_statement (vblock, (ValaCCodeNode*) cstmt);
	_tmp32 = NULL;
	if ((_tmp33 = gee_collection_get_size ((GeeCollection*) (_tmp32 = vala_method_get_postconditions (m))) > 0, (_tmp32 == NULL) ? NULL : (_tmp32 = (gee_collection_object_unref (_tmp32), NULL)), _tmp33)) {
		{
			GeeList* _tmp34;
			GeeIterator* _tmp35;
			GeeIterator* postcondition_it;
			_tmp34 = NULL;
			_tmp35 = NULL;
			postcondition_it = (_tmp35 = gee_iterable_iterator ((GeeIterable*) (_tmp34 = vala_method_get_postconditions (m))), (_tmp34 == NULL) ? NULL : (_tmp34 = (gee_collection_object_unref (_tmp34), NULL)), _tmp35);
			while (gee_iterator_next (postcondition_it)) {
				ValaExpression* postcondition;
				ValaCCodeStatement* _tmp36;
				postcondition = (ValaExpression*) gee_iterator_get (postcondition_it);
				_tmp36 = NULL;
				vala_ccode_block_add_statement (vblock, (ValaCCodeNode*) (_tmp36 = vala_ccode_method_module_create_postcondition_statement (self, postcondition)));
				(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
				(postcondition == NULL) ? NULL : (postcondition = (vala_code_node_unref (postcondition), NULL));
			}
			(postcondition_it == NULL) ? NULL : (postcondition_it = (gee_collection_object_unref (postcondition_it), NULL));
		}
		if (!(VALA_IS_VOID_TYPE (return_type))) {
			ValaCCodeIdentifier* _tmp37;
			ValaCCodeReturnStatement* _tmp38;
			ValaCCodeReturnStatement* cret_stmt;
			_tmp37 = NULL;
			_tmp38 = NULL;
			cret_stmt = (_tmp38 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp37 = vala_ccode_identifier_new ("result"))), (_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL)), _tmp38);
			vala_ccode_node_set_line ((ValaCCodeNode*) cret_stmt, vala_ccode_node_get_line ((ValaCCodeNode*) vfunc));
			vala_ccode_block_add_statement (vblock, (ValaCCodeNode*) cret_stmt);
			(cret_stmt == NULL) ? NULL : (cret_stmt = (vala_ccode_node_unref (cret_stmt), NULL));
		}
	}
	if (visible) {
		ValaCCodeFunction* _tmp39;
		_tmp39 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->header_type_member_declaration, (ValaCCodeNode*) (_tmp39 = vala_ccode_function_copy (vfunc)));
		(_tmp39 == NULL) ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL));
	} else {
		ValaCCodeFunction* _tmp40;
		vala_ccode_function_set_modifiers (vfunc, vala_ccode_function_get_modifiers (vfunc) | (VALA_CCODE_MODIFIERS_STATIC));
		_tmp40 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp40 = vala_ccode_function_copy (vfunc)));
		(_tmp40 == NULL) ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL));
	}
	vala_ccode_function_set_block (vfunc, vblock);
	_tmp41 = FALSE;
	_tmp42 = FALSE;
	if (vala_method_get_is_abstract (m)) {
		_tmp42 = vala_code_node_get_source_reference ((ValaCodeNode*) m) != NULL;
	} else {
		_tmp42 = FALSE;
	}
	if (_tmp42) {
		_tmp41 = vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) m)) != NULL;
	} else {
		_tmp41 = FALSE;
	}
	if (_tmp41) {
		ValaCCodeComment* _tmp43;
		_tmp43 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) (_tmp43 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) m)))));
		(_tmp43 == NULL) ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL));
	}
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) vfunc);
	(vfunc == NULL) ? NULL : (vfunc = (vala_ccode_node_unref (vfunc), NULL));
	(vblock == NULL) ? NULL : (vblock = (vala_ccode_node_unref (vblock), NULL));
	(vcast == NULL) ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL));
	(vcall == NULL) ? NULL : (vcall = (vala_ccode_node_unref (vcall), NULL));
	(cstmt == NULL) ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL));
}


static ValaCCodeStatement* vala_ccode_method_module_create_method_type_check_statement (ValaCCodeMethodModule* self, ValaMethod* m, ValaDataType* return_type, ValaTypeSymbol* t, gboolean non_null, const char* var_name) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	g_return_val_if_fail (t != NULL, NULL);
	g_return_val_if_fail (var_name != NULL, NULL);
	return vala_ccode_base_module_create_type_check_statement ((ValaCCodeBaseModule*) self, (ValaCodeNode*) m, return_type, t, non_null, var_name);
}


static ValaCCodeStatement* vala_ccode_method_module_create_precondition_statement (ValaCCodeMethodModule* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaExpression* precondition) {
	ValaCCodeFunctionCall* ccheck;
	ValaCCodeStatement* _tmp5;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (method_node != NULL, NULL);
	g_return_val_if_fail (ret_type != NULL, NULL);
	g_return_val_if_fail (precondition != NULL, NULL);
	ccheck = vala_ccode_function_call_new (NULL);
	vala_ccode_function_call_add_argument (ccheck, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) precondition)));
	if (VALA_IS_VOID_TYPE (ret_type)) {
		ValaCCodeIdentifier* _tmp0;
		/* void function */
		_tmp0 = NULL;
		vala_ccode_function_call_set_call (ccheck, (ValaCCodeExpression*) (_tmp0 = vala_ccode_identifier_new ("g_return_if_fail")));
		(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	} else {
		ValaCCodeIdentifier* _tmp1;
		ValaCCodeExpression* cdefault;
		_tmp1 = NULL;
		vala_ccode_function_call_set_call (ccheck, (ValaCCodeExpression*) (_tmp1 = vala_ccode_identifier_new ("g_return_val_if_fail")));
		(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
		cdefault = vala_ccode_base_module_default_value_for_type ((ValaCCodeBaseModule*) self, ret_type, FALSE);
		if (cdefault != NULL) {
			vala_ccode_function_call_add_argument (ccheck, cdefault);
		} else {
			ValaCCodeConstant* _tmp2;
			ValaCCodeStatement* _tmp3;
			ValaCCodeStatement* _tmp4;
			_tmp2 = NULL;
			_tmp3 = NULL;
			_tmp4 = NULL;
			return (_tmp4 = (_tmp3 = (ValaCCodeStatement*) vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp2 = vala_ccode_constant_new ("0"))), (_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)), _tmp3), (cdefault == NULL) ? NULL : (cdefault = (vala_ccode_node_unref (cdefault), NULL)), (ccheck == NULL) ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL)), _tmp4);
		}
		(cdefault == NULL) ? NULL : (cdefault = (vala_ccode_node_unref (cdefault), NULL));
	}
	_tmp5 = NULL;
	return (_tmp5 = (ValaCCodeStatement*) vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccheck), (ccheck == NULL) ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL)), _tmp5);
}


static ValaCCodeStatement* vala_ccode_method_module_create_postcondition_statement (ValaCCodeMethodModule* self, ValaExpression* postcondition) {
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* cassert;
	ValaCCodeStatement* _tmp2;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (postcondition != NULL, NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	cassert = (_tmp1 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0 = vala_ccode_identifier_new ("g_assert"))), (_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)), _tmp1);
	vala_ccode_function_call_add_argument (cassert, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) postcondition)));
	_tmp2 = NULL;
	return (_tmp2 = (ValaCCodeStatement*) vala_ccode_expression_statement_new ((ValaCCodeExpression*) cassert), (cassert == NULL) ? NULL : (cassert = (vala_ccode_node_unref (cassert), NULL)), _tmp2);
}


static ValaTypeSymbol* vala_ccode_method_module_find_parent_type (ValaCCodeMethodModule* self, ValaSymbol* sym) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	while (sym != NULL) {
		if (VALA_IS_TYPESYMBOL (sym)) {
			ValaTypeSymbol* _tmp0;
			_tmp0 = NULL;
			return (_tmp0 = VALA_TYPESYMBOL (sym), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
		}
		sym = vala_symbol_get_parent_symbol (sym);
	}
	return NULL;
}


static void vala_ccode_method_module_add_object_creation (ValaCCodeMethodModule* self, ValaCCodeBlock* b, gboolean has_params) {
	ValaClass* _tmp0;
	ValaClass* cl;
	gboolean chain_up;
	ValaCreationMethod* cm;
	gboolean _tmp7;
	gboolean _tmp8;
	ValaCCodeVariableDeclarator* cdecl_;
	char* _tmp24;
	char* _tmp23;
	ValaCCodeDeclaration* _tmp25;
	ValaCCodeDeclaration* cdeclaration;
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	_tmp0 = NULL;
	cl = (_tmp0 = VALA_CLASS (((ValaCCodeBaseModule*) self)->current_type_symbol), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	chain_up = FALSE;
	cm = NULL;
	if (vala_class_get_base_class (cl) != NULL) {
		ValaCreationMethod* _tmp3;
		ValaCreationMethod* _tmp2;
		ValaMethod* _tmp1;
		gboolean _tmp4;
		gboolean _tmp5;
		_tmp3 = NULL;
		_tmp2 = NULL;
		_tmp1 = NULL;
		cm = (_tmp3 = (_tmp2 = (_tmp1 = vala_class_get_default_construction_method (vala_class_get_base_class (cl)), VALA_IS_CREATION_METHOD (_tmp1) ? ((ValaCreationMethod*) _tmp1) : NULL), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2)), (cm == NULL) ? NULL : (cm = (vala_code_node_unref (cm), NULL)), _tmp3);
		_tmp4 = FALSE;
		_tmp5 = FALSE;
		if (cm != NULL) {
			GeeList* _tmp6;
			_tmp6 = NULL;
			_tmp5 = gee_collection_get_size ((GeeCollection*) (_tmp6 = vala_method_get_parameters ((ValaMethod*) cm))) == 0;
			(_tmp6 == NULL) ? NULL : (_tmp6 = (gee_collection_object_unref (_tmp6), NULL));
		} else {
			_tmp5 = FALSE;
		}
		if (_tmp5) {
			_tmp4 = vala_method_get_has_construct_function ((ValaMethod*) cm);
		} else {
			_tmp4 = FALSE;
		}
		if (_tmp4) {
			if (!has_params) {
				chain_up = TRUE;
			}
		}
	}
	_tmp7 = FALSE;
	_tmp8 = FALSE;
	if (!has_params) {
		_tmp8 = !chain_up;
	} else {
		_tmp8 = FALSE;
	}
	if (_tmp8) {
		_tmp7 = VALA_TYPESYMBOL (vala_class_get_base_class (cl)) != ((ValaCCodeBaseModule*) self)->gobject_type;
	} else {
		_tmp7 = FALSE;
	}
	if (_tmp7) {
	}
	/* possibly report warning or error about missing base call*/
	cdecl_ = vala_ccode_variable_declarator_new ("self");
	if (chain_up) {
		ValaCCodeIdentifier* _tmp10;
		char* _tmp9;
		ValaCCodeFunctionCall* _tmp11;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* _tmp12;
		ValaCCodeCastExpression* _tmp15;
		char* _tmp14;
		char* _tmp13;
		_tmp10 = NULL;
		_tmp9 = NULL;
		_tmp11 = NULL;
		ccall = (_tmp11 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp10 = vala_ccode_identifier_new (_tmp9 = vala_method_get_real_cname ((ValaMethod*) cm)))), (_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)), _tmp9 = (g_free (_tmp9), NULL), _tmp11);
		_tmp12 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp12 = vala_ccode_identifier_new ("object_type")));
		(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
		_tmp15 = NULL;
		_tmp14 = NULL;
		_tmp13 = NULL;
		vala_ccode_variable_declarator_set_initializer (cdecl_, (ValaCCodeExpression*) (_tmp15 = vala_ccode_cast_expression_new ((ValaCCodeExpression*) ccall, _tmp14 = g_strdup_printf ("%s*", _tmp13 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE)))));
		(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
		_tmp14 = (g_free (_tmp14), NULL);
		_tmp13 = (g_free (_tmp13), NULL);
		(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	} else {
		ValaCCodeIdentifier* _tmp16;
		ValaCCodeFunctionCall* _tmp17;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* _tmp18;
		_tmp16 = NULL;
		_tmp17 = NULL;
		ccall = (_tmp17 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp16 = vala_ccode_identifier_new ("g_object_newv"))), (_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)), _tmp17);
		_tmp18 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp18 = vala_ccode_identifier_new ("object_type")));
		(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
		if (has_params) {
			ValaCCodeConstant* _tmp19;
			ValaCCodeConstant* _tmp20;
			_tmp19 = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp19 = vala_ccode_constant_new ("__params_it - __params")));
			(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
			_tmp20 = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp20 = vala_ccode_constant_new ("__params")));
			(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
		} else {
			ValaCCodeConstant* _tmp21;
			ValaCCodeConstant* _tmp22;
			_tmp21 = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp21 = vala_ccode_constant_new ("0")));
			(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
			_tmp22 = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp22 = vala_ccode_constant_new ("NULL")));
			(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
		}
		vala_ccode_variable_declarator_set_initializer (cdecl_, (ValaCCodeExpression*) ccall);
		(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	}
	_tmp24 = NULL;
	_tmp23 = NULL;
	_tmp25 = NULL;
	cdeclaration = (_tmp25 = vala_ccode_declaration_new (_tmp24 = g_strdup_printf ("%s *", _tmp23 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))), _tmp24 = (g_free (_tmp24), NULL), _tmp23 = (g_free (_tmp23), NULL), _tmp25);
	vala_ccode_declaration_add_declarator (cdeclaration, (ValaCCodeDeclarator*) cdecl_);
	vala_ccode_block_add_statement (b, (ValaCCodeNode*) cdeclaration);
	(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	(cm == NULL) ? NULL : (cm = (vala_code_node_unref (cm), NULL));
	(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
	(cdeclaration == NULL) ? NULL : (cdeclaration = (vala_ccode_node_unref (cdeclaration), NULL));
}


static void vala_ccode_method_module_real_visit_creation_method (ValaCCodeModule* base, ValaCreationMethod* m) {
	ValaCCodeMethodModule * self;
	gboolean visible;
	gboolean _tmp0;
	gboolean _tmp1;
	ValaDataType* creturn_type;
	gboolean _tmp9;
	gboolean _tmp20;
	gboolean _tmp21;
	self = (ValaCCodeMethodModule*) base;
	g_return_if_fail (m != NULL);
	visible = !vala_symbol_is_internal_symbol ((ValaSymbol*) m);
	_tmp0 = FALSE;
	_tmp1 = FALSE;
	if (vala_method_get_body ((ValaMethod*) m) != NULL) {
		_tmp1 = VALA_IS_CLASS (((ValaCCodeBaseModule*) self)->current_type_symbol);
	} else {
		_tmp1 = FALSE;
	}
	if (_tmp1) {
		_tmp0 = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class, ((ValaCCodeBaseModule*) self)->gobject_type);
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		gint n_params;
		n_params = 0;
		{
			GeeList* _tmp2;
			GeeIterator* _tmp3;
			GeeIterator* stmt_it;
			_tmp2 = NULL;
			_tmp3 = NULL;
			stmt_it = (_tmp3 = gee_iterable_iterator ((GeeIterable*) (_tmp2 = vala_block_get_statements (vala_method_get_body ((ValaMethod*) m)))), (_tmp2 == NULL) ? NULL : (_tmp2 = (gee_collection_object_unref (_tmp2), NULL)), _tmp3);
			while (gee_iterator_next (stmt_it)) {
				ValaStatement* stmt;
				ValaExpressionStatement* _tmp5;
				ValaStatement* _tmp4;
				ValaExpressionStatement* expr_stmt;
				stmt = (ValaStatement*) gee_iterator_get (stmt_it);
				_tmp5 = NULL;
				_tmp4 = NULL;
				expr_stmt = (_tmp5 = (_tmp4 = stmt, VALA_IS_EXPRESSION_STATEMENT (_tmp4) ? ((ValaExpressionStatement*) _tmp4) : NULL), (_tmp5 == NULL) ? NULL : vala_code_node_ref (_tmp5));
				if (expr_stmt != NULL) {
					ValaProperty* prop;
					gboolean _tmp6;
					prop = vala_expression_statement_assigned_property (expr_stmt);
					_tmp6 = FALSE;
					if (prop != NULL) {
						_tmp6 = vala_property_accessor_get_construction (vala_property_get_set_accessor (prop));
					} else {
						_tmp6 = FALSE;
					}
					if (_tmp6) {
						n_params++;
					}
					(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				}
				(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
				(expr_stmt == NULL) ? NULL : (expr_stmt = (vala_code_node_unref (expr_stmt), NULL));
			}
			(stmt_it == NULL) ? NULL : (stmt_it = (gee_collection_object_unref (stmt_it), NULL));
		}
		vala_creation_method_set_n_construction_params (m, n_params);
	}
	vala_ccode_module_visit_method (vala_ccode_module_get_head ((ValaCCodeModule*) self), (ValaMethod*) m);
	creturn_type = NULL;
	if (((ValaCCodeBaseModule*) self)->current_class != NULL) {
		ValaDataType* _tmp7;
		_tmp7 = NULL;
		creturn_type = (_tmp7 = (ValaDataType*) vala_object_type_new ((ValaObjectTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class), (creturn_type == NULL) ? NULL : (creturn_type = (vala_code_node_unref (creturn_type), NULL)), _tmp7);
	} else {
		ValaDataType* _tmp8;
		_tmp8 = NULL;
		creturn_type = (_tmp8 = (ValaDataType*) vala_void_type_new (), (creturn_type == NULL) ? NULL : (creturn_type = (vala_code_node_unref (creturn_type), NULL)), _tmp8);
	}
	_tmp9 = FALSE;
	if (((ValaCCodeBaseModule*) self)->current_class != NULL) {
		_tmp9 = !vala_class_get_is_compact (((ValaCCodeBaseModule*) self)->current_class);
	} else {
		_tmp9 = FALSE;
	}
	if (_tmp9) {
		char* _tmp11;
		char* _tmp10;
		ValaCCodeFunction* _tmp12;
		ValaCCodeFunction* vfunc;
		GeeHashMap* cparam_map;
		GeeHashMap* carg_map;
		ValaCCodeBlock* vblock;
		ValaCCodeIdentifier* _tmp14;
		char* _tmp13;
		ValaCCodeFunctionCall* _tmp15;
		ValaCCodeFunctionCall* vcall;
		ValaCCodeIdentifier* _tmp17;
		char* _tmp16;
		ValaCCodeStatement* cstmt;
		_tmp11 = NULL;
		_tmp10 = NULL;
		_tmp12 = NULL;
		vfunc = (_tmp12 = vala_ccode_function_new (_tmp10 = vala_method_get_cname ((ValaMethod*) m), _tmp11 = vala_data_type_get_cname (creturn_type)), _tmp11 = (g_free (_tmp11), NULL), _tmp10 = (g_free (_tmp10), NULL), _tmp12);
		vala_ccode_node_set_line ((ValaCCodeNode*) vfunc, vala_ccode_node_get_line ((ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function));
		cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
		carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
		vblock = vala_ccode_block_new ();
		_tmp14 = NULL;
		_tmp13 = NULL;
		_tmp15 = NULL;
		vcall = (_tmp15 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp14 = vala_ccode_identifier_new (_tmp13 = vala_method_get_real_cname ((ValaMethod*) m)))), (_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)), _tmp13 = (g_free (_tmp13), NULL), _tmp15);
		_tmp17 = NULL;
		_tmp16 = NULL;
		vala_ccode_function_call_add_argument (vcall, (ValaCCodeExpression*) (_tmp17 = vala_ccode_identifier_new (_tmp16 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class))));
		(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
		_tmp16 = (g_free (_tmp16), NULL);
		vala_ccode_module_generate_cparameters ((ValaCCodeModule*) self, (ValaMethod*) m, creturn_type, TRUE, (GeeMap*) cparam_map, vfunc, NULL, (GeeMap*) carg_map, vcall, 3);
		cstmt = (ValaCCodeStatement*) vala_ccode_return_statement_new ((ValaCCodeExpression*) vcall);
		vala_ccode_node_set_line ((ValaCCodeNode*) cstmt, vala_ccode_node_get_line ((ValaCCodeNode*) vfunc));
		vala_ccode_block_add_statement (vblock, (ValaCCodeNode*) cstmt);
		if (visible) {
			ValaCCodeFunction* _tmp18;
			_tmp18 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->header_type_member_declaration, (ValaCCodeNode*) (_tmp18 = vala_ccode_function_copy (vfunc)));
			(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
		} else {
			ValaCCodeFunction* _tmp19;
			vala_ccode_function_set_modifiers (vfunc, vala_ccode_function_get_modifiers (vfunc) | (VALA_CCODE_MODIFIERS_STATIC));
			_tmp19 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp19 = vala_ccode_function_copy (vfunc)));
			(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
		}
		vala_ccode_function_set_block (vfunc, vblock);
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) vfunc);
		(vfunc == NULL) ? NULL : (vfunc = (vala_ccode_node_unref (vfunc), NULL));
		(cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL));
		(carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL));
		(vblock == NULL) ? NULL : (vblock = (vala_ccode_node_unref (vblock), NULL));
		(vcall == NULL) ? NULL : (vcall = (vala_ccode_node_unref (vcall), NULL));
		(cstmt == NULL) ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL));
	}
	_tmp20 = FALSE;
	_tmp21 = FALSE;
	if (((ValaCCodeBaseModule*) self)->current_class != NULL) {
		_tmp21 = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class, ((ValaCCodeBaseModule*) self)->gobject_type);
	} else {
		_tmp21 = FALSE;
	}
	if (_tmp21) {
		gboolean _tmp22;
		_tmp22 = FALSE;
		if (vala_creation_method_get_n_construction_params ((VALA_CREATION_METHOD (m))) > 0) {
			_tmp22 = TRUE;
		} else {
			GeeList* _tmp23;
			_tmp23 = NULL;
			_tmp22 = gee_collection_get_size ((GeeCollection*) (_tmp23 = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class))) > 0;
			(_tmp23 == NULL) ? NULL : (_tmp23 = (gee_collection_object_unref (_tmp23), NULL));
		}
		_tmp20 = (_tmp22);
	} else {
		_tmp20 = FALSE;
	}
	if (_tmp20) {
		ValaCCodeIdentifier* _tmp25;
		ValaCCodeIdentifier* _tmp24;
		ValaCCodeBinaryExpression* _tmp26;
		ValaCCodeBinaryExpression* ccond;
		ValaCCodeBlock* cdofreeparam;
		ValaCCodeExpressionStatement* _tmp29;
		ValaCCodeUnaryExpression* _tmp28;
		ValaCCodeIdentifier* _tmp27;
		ValaCCodeIdentifier* _tmp30;
		ValaCCodeFunctionCall* _tmp31;
		ValaCCodeFunctionCall* cunsetcall;
		ValaCCodeUnaryExpression* _tmp34;
		ValaCCodeMemberAccess* _tmp33;
		ValaCCodeIdentifier* _tmp32;
		ValaCCodeExpressionStatement* _tmp35;
		ValaCCodeWhileStatement* _tmp36;
		ValaCCodeIdentifier* _tmp37;
		ValaCCodeFunctionCall* _tmp38;
		ValaCCodeFunctionCall* cfreeparams;
		ValaCCodeIdentifier* _tmp39;
		ValaCCodeExpressionStatement* _tmp40;
		_tmp25 = NULL;
		_tmp24 = NULL;
		_tmp26 = NULL;
		ccond = (_tmp26 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, (ValaCCodeExpression*) (_tmp24 = vala_ccode_identifier_new ("__params_it")), (ValaCCodeExpression*) (_tmp25 = vala_ccode_identifier_new ("__params"))), (_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL)), (_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL)), _tmp26);
		cdofreeparam = vala_ccode_block_new ();
		_tmp29 = NULL;
		_tmp28 = NULL;
		_tmp27 = NULL;
		vala_ccode_block_add_statement (cdofreeparam, (ValaCCodeNode*) (_tmp29 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp28 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_PREFIX_DECREMENT, (ValaCCodeExpression*) (_tmp27 = vala_ccode_identifier_new ("__params_it")))))));
		(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
		(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
		(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
		_tmp30 = NULL;
		_tmp31 = NULL;
		cunsetcall = (_tmp31 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp30 = vala_ccode_identifier_new ("g_value_unset"))), (_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL)), _tmp31);
		_tmp34 = NULL;
		_tmp33 = NULL;
		_tmp32 = NULL;
		vala_ccode_function_call_add_argument (cunsetcall, (ValaCCodeExpression*) (_tmp34 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp33 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp32 = vala_ccode_identifier_new ("__params_it")), "value")))));
		(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
		(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
		(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
		_tmp35 = NULL;
		vala_ccode_block_add_statement (cdofreeparam, (ValaCCodeNode*) (_tmp35 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cunsetcall)));
		(_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL));
		_tmp36 = NULL;
		vala_ccode_block_add_statement (vala_ccode_function_get_block (((ValaCCodeBaseModule*) self)->function), (ValaCCodeNode*) (_tmp36 = vala_ccode_while_statement_new ((ValaCCodeExpression*) ccond, (ValaCCodeStatement*) cdofreeparam)));
		(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
		_tmp37 = NULL;
		_tmp38 = NULL;
		cfreeparams = (_tmp38 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp37 = vala_ccode_identifier_new ("g_free"))), (_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL)), _tmp38);
		_tmp39 = NULL;
		vala_ccode_function_call_add_argument (cfreeparams, (ValaCCodeExpression*) (_tmp39 = vala_ccode_identifier_new ("__params")));
		(_tmp39 == NULL) ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL));
		_tmp40 = NULL;
		vala_ccode_block_add_statement (vala_ccode_function_get_block (((ValaCCodeBaseModule*) self)->function), (ValaCCodeNode*) (_tmp40 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cfreeparams)));
		(_tmp40 == NULL) ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL));
		(ccond == NULL) ? NULL : (ccond = (vala_ccode_node_unref (ccond), NULL));
		(cdofreeparam == NULL) ? NULL : (cdofreeparam = (vala_ccode_node_unref (cdofreeparam), NULL));
		(cunsetcall == NULL) ? NULL : (cunsetcall = (vala_ccode_node_unref (cunsetcall), NULL));
		(cfreeparams == NULL) ? NULL : (cfreeparams = (vala_ccode_node_unref (cfreeparams), NULL));
	}
	if (VALA_IS_CLASS (((ValaCCodeBaseModule*) self)->current_type_symbol)) {
		ValaCCodeExpression* cresult;
		char* _tmp41;
		gboolean _tmp42;
		ValaCCodeReturnStatement* creturn;
		cresult = (ValaCCodeExpression*) vala_ccode_identifier_new ("self");
		_tmp41 = NULL;
		if ((_tmp42 = (_tmp41 = vala_ccode_module_get_custom_creturn_type ((ValaCCodeModule*) self, (ValaMethod*) m)) != NULL, _tmp41 = (g_free (_tmp41), NULL), _tmp42)) {
			ValaCCodeExpression* _tmp44;
			char* _tmp43;
			_tmp44 = NULL;
			_tmp43 = NULL;
			cresult = (_tmp44 = (ValaCCodeExpression*) vala_ccode_cast_expression_new (cresult, _tmp43 = vala_ccode_module_get_custom_creturn_type ((ValaCCodeModule*) self, (ValaMethod*) m)), (cresult == NULL) ? NULL : (cresult = (vala_ccode_node_unref (cresult), NULL)), _tmp44);
			_tmp43 = (g_free (_tmp43), NULL);
		}
		creturn = vala_ccode_return_statement_new (NULL);
		vala_ccode_return_statement_set_return_expression (creturn, cresult);
		vala_ccode_block_add_statement (vala_ccode_function_get_block (((ValaCCodeBaseModule*) self)->function), (ValaCCodeNode*) creturn);
		(cresult == NULL) ? NULL : (cresult = (vala_ccode_node_unref (cresult), NULL));
		(creturn == NULL) ? NULL : (creturn = (vala_ccode_node_unref (creturn), NULL));
	}
	(creturn_type == NULL) ? NULL : (creturn_type = (vala_code_node_unref (creturn_type), NULL));
}


static void vala_ccode_method_module_class_init (ValaCCodeMethodModuleClass * klass) {
	vala_ccode_method_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->method_has_wrapper = vala_ccode_method_module_real_method_has_wrapper;
	VALA_CCODE_MODULE_CLASS (klass)->get_custom_creturn_type = vala_ccode_method_module_real_get_custom_creturn_type;
	VALA_CCODE_MODULE_CLASS (klass)->visit_method = vala_ccode_method_module_real_visit_method;
	VALA_CCODE_MODULE_CLASS (klass)->generate_cparameters = vala_ccode_method_module_real_generate_cparameters;
	VALA_CCODE_MODULE_CLASS (klass)->visit_creation_method = vala_ccode_method_module_real_visit_creation_method;
}


static void vala_ccode_method_module_instance_init (ValaCCodeMethodModule * self) {
}


GType vala_ccode_method_module_get_type (void) {
	static GType vala_ccode_method_module_type_id = 0;
	if (vala_ccode_method_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodModule), 0, (GInstanceInitFunc) vala_ccode_method_module_instance_init, NULL };
		vala_ccode_method_module_type_id = g_type_register_static (VALA_TYPE_CCODE_STRUCT_MODULE, "ValaCCodeMethodModule", &g_define_type_info, 0);
	}
	return vala_ccode_method_module_type_id;
}




