/* valadeclarationstatement.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valadeclarationstatement.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valasymbol.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>
#include <vala/valasemanticanalyzer.h>
#include <vala/valalocalvariable.h>
#include <vala/valadatatype.h>




struct _ValaDeclarationStatementPrivate {
	ValaSymbol* _declaration;
};

#define VALA_DECLARATION_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_DECLARATION_STATEMENT, ValaDeclarationStatementPrivate))
enum  {
	VALA_DECLARATION_STATEMENT_DUMMY_PROPERTY
};
static void vala_declaration_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_declaration_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_declaration_statement_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
static void vala_declaration_statement_real_get_defined_variables (ValaCodeNode* base, GeeCollection* collection);
static void vala_declaration_statement_real_get_used_variables (ValaCodeNode* base, GeeCollection* collection);
static gpointer vala_declaration_statement_parent_class = NULL;
static ValaStatementIface* vala_declaration_statement_vala_statement_parent_iface = NULL;
static void vala_declaration_statement_finalize (ValaCodeNode* obj);



/**
 * Creates a new declaration statement.
 *
 * @param decl   local variable declaration
 * @param source reference to source code
 * @return       newly created declaration statement
 */
ValaDeclarationStatement* vala_declaration_statement_construct (GType object_type, ValaSymbol* declaration, ValaSourceReference* source_reference) {
	ValaDeclarationStatement* self;
	g_return_val_if_fail (declaration != NULL, NULL);
	self = (ValaDeclarationStatement*) g_type_create_instance (object_type);
	vala_declaration_statement_set_declaration (self, declaration);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaDeclarationStatement* vala_declaration_statement_new (ValaSymbol* declaration, ValaSourceReference* source_reference) {
	return vala_declaration_statement_construct (VALA_TYPE_DECLARATION_STATEMENT, declaration, source_reference);
}


static void vala_declaration_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaDeclarationStatement * self;
	self = (ValaDeclarationStatement*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_declaration_statement (visitor, self);
}


static void vala_declaration_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaDeclarationStatement * self;
	self = (ValaDeclarationStatement*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_node_accept ((ValaCodeNode*) vala_declaration_statement_get_declaration (self), visitor);
}


static gboolean vala_declaration_statement_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaDeclarationStatement * self;
	ValaLocalVariable* _tmp2;
	ValaSymbol* _tmp1;
	ValaLocalVariable* local;
	gboolean _tmp3;
	gboolean _tmp6;
	self = (ValaDeclarationStatement*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	if (vala_code_node_get_checked ((ValaCodeNode*) self)) {
		return !vala_code_node_get_error ((ValaCodeNode*) self);
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	vala_code_node_check ((ValaCodeNode*) vala_declaration_statement_get_declaration (self), analyzer);
	_tmp2 = NULL;
	_tmp1 = NULL;
	local = (_tmp2 = (_tmp1 = vala_declaration_statement_get_declaration (self), VALA_IS_LOCAL_VARIABLE (_tmp1) ? ((ValaLocalVariable*) _tmp1) : NULL), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
	_tmp3 = FALSE;
	if (local != NULL) {
		_tmp3 = vala_local_variable_get_initializer (local) != NULL;
	} else {
		_tmp3 = FALSE;
	}
	if (_tmp3) {
		{
			GeeList* _tmp4;
			GeeIterator* _tmp5;
			GeeIterator* error_type_it;
			_tmp4 = NULL;
			_tmp5 = NULL;
			error_type_it = (_tmp5 = gee_iterable_iterator ((GeeIterable*) (_tmp4 = vala_code_node_get_error_types ((ValaCodeNode*) vala_local_variable_get_initializer (local)))), (_tmp4 == NULL) ? NULL : (_tmp4 = (gee_collection_object_unref (_tmp4), NULL)), _tmp5);
			while (gee_iterator_next (error_type_it)) {
				ValaDataType* error_type;
				ValaDataType* initializer_error_type;
				error_type = (ValaDataType*) gee_iterator_get (error_type_it);
				/* ensure we can trace back which expression may throw errors of this type*/
				initializer_error_type = vala_data_type_copy (error_type);
				vala_code_node_set_source_reference ((ValaCodeNode*) initializer_error_type, vala_code_node_get_source_reference ((ValaCodeNode*) vala_local_variable_get_initializer (local)));
				vala_code_node_add_error_type ((ValaCodeNode*) self, initializer_error_type);
				(error_type == NULL) ? NULL : (error_type = (vala_code_node_unref (error_type), NULL));
				(initializer_error_type == NULL) ? NULL : (initializer_error_type = (vala_code_node_unref (initializer_error_type), NULL));
			}
			(error_type_it == NULL) ? NULL : (error_type_it = (gee_collection_object_unref (error_type_it), NULL));
		}
	}
	return (_tmp6 = !vala_code_node_get_error ((ValaCodeNode*) self), (local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL)), _tmp6);
}


static void vala_declaration_statement_real_get_defined_variables (ValaCodeNode* base, GeeCollection* collection) {
	ValaDeclarationStatement * self;
	ValaLocalVariable* _tmp1;
	ValaSymbol* _tmp0;
	ValaLocalVariable* local;
	gboolean _tmp2;
	self = (ValaDeclarationStatement*) base;
	g_return_if_fail (collection != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	local = (_tmp1 = (_tmp0 = vala_declaration_statement_get_declaration (self), VALA_IS_LOCAL_VARIABLE (_tmp0) ? ((ValaLocalVariable*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp2 = FALSE;
	if (local != NULL) {
		_tmp2 = vala_local_variable_get_initializer (local) != NULL;
	} else {
		_tmp2 = FALSE;
	}
	if (_tmp2) {
		vala_code_node_get_defined_variables ((ValaCodeNode*) vala_local_variable_get_initializer (local), collection);
		gee_collection_add (collection, local);
	}
	(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
}


static void vala_declaration_statement_real_get_used_variables (ValaCodeNode* base, GeeCollection* collection) {
	ValaDeclarationStatement * self;
	ValaLocalVariable* _tmp1;
	ValaSymbol* _tmp0;
	ValaLocalVariable* local;
	gboolean _tmp2;
	self = (ValaDeclarationStatement*) base;
	g_return_if_fail (collection != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	local = (_tmp1 = (_tmp0 = vala_declaration_statement_get_declaration (self), VALA_IS_LOCAL_VARIABLE (_tmp0) ? ((ValaLocalVariable*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp2 = FALSE;
	if (local != NULL) {
		_tmp2 = vala_local_variable_get_initializer (local) != NULL;
	} else {
		_tmp2 = FALSE;
	}
	if (_tmp2) {
		vala_code_node_get_used_variables ((ValaCodeNode*) vala_local_variable_get_initializer (local), collection);
	}
	(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
}


ValaSymbol* vala_declaration_statement_get_declaration (ValaDeclarationStatement* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_declaration;
}


void vala_declaration_statement_set_declaration (ValaDeclarationStatement* self, ValaSymbol* value) {
	ValaSymbol* _tmp2;
	ValaSymbol* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_declaration = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (self->priv->_declaration == NULL) ? NULL : (self->priv->_declaration = (vala_code_node_unref (self->priv->_declaration), NULL)), _tmp2);
	if (self->priv->_declaration != NULL) {
		vala_code_node_set_parent_node ((ValaCodeNode*) self->priv->_declaration, (ValaCodeNode*) self);
	}
}


static void vala_declaration_statement_class_init (ValaDeclarationStatementClass * klass) {
	vala_declaration_statement_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_declaration_statement_finalize;
	g_type_class_add_private (klass, sizeof (ValaDeclarationStatementPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_declaration_statement_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_declaration_statement_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->check = vala_declaration_statement_real_check;
	VALA_CODE_NODE_CLASS (klass)->get_defined_variables = vala_declaration_statement_real_get_defined_variables;
	VALA_CODE_NODE_CLASS (klass)->get_used_variables = vala_declaration_statement_real_get_used_variables;
}


static void vala_declaration_statement_vala_statement_interface_init (ValaStatementIface * iface) {
	vala_declaration_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void vala_declaration_statement_instance_init (ValaDeclarationStatement * self) {
	self->priv = VALA_DECLARATION_STATEMENT_GET_PRIVATE (self);
}


static void vala_declaration_statement_finalize (ValaCodeNode* obj) {
	ValaDeclarationStatement * self;
	self = VALA_DECLARATION_STATEMENT (obj);
	(self->priv->_declaration == NULL) ? NULL : (self->priv->_declaration = (vala_code_node_unref (self->priv->_declaration), NULL));
	VALA_CODE_NODE_CLASS (vala_declaration_statement_parent_class)->finalize (obj);
}


GType vala_declaration_statement_get_type (void) {
	static GType vala_declaration_statement_type_id = 0;
	if (vala_declaration_statement_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDeclarationStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_declaration_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDeclarationStatement), 0, (GInstanceInitFunc) vala_declaration_statement_instance_init, NULL };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_declaration_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		vala_declaration_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaDeclarationStatement", &g_define_type_info, 0);
		g_type_add_interface_static (vala_declaration_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
	}
	return vala_declaration_statement_type_id;
}




