/* valastatementlist.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valastatementlist.h>
#include <gee/arraylist.h>
#include <gee/list.h>
#include <gee/collection.h>
#include <gee/iterable.h>
#include <gee/iterator.h>




struct _ValaStatementListPrivate {
	GeeList* list;
};

#define VALA_STATEMENT_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_STATEMENT_LIST, ValaStatementListPrivate))
enum  {
	VALA_STATEMENT_LIST_DUMMY_PROPERTY
};
static void vala_statement_list_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_statement_list_parent_class = NULL;
static ValaStatementIface* vala_statement_list_vala_statement_parent_iface = NULL;
static void vala_statement_list_finalize (ValaCodeNode* obj);



ValaStatementList* vala_statement_list_construct (GType object_type, ValaSourceReference* source_reference) {
	ValaStatementList* self;
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaStatementList*) g_type_create_instance (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaStatementList* vala_statement_list_new (ValaSourceReference* source_reference) {
	return vala_statement_list_construct (VALA_TYPE_STATEMENT_LIST, source_reference);
}


ValaStatement* vala_statement_list_get (ValaStatementList* self, gint index) {
	g_return_val_if_fail (self != NULL, NULL);
	return (ValaStatement*) gee_list_get (self->priv->list, index);
}


void vala_statement_list_set (ValaStatementList* self, gint index, ValaStatement* stmt) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (stmt != NULL);
	gee_list_set (self->priv->list, index, stmt);
}


void vala_statement_list_add (ValaStatementList* self, ValaStatement* stmt) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (stmt != NULL);
	gee_collection_add ((GeeCollection*) self->priv->list, stmt);
}


void vala_statement_list_insert (ValaStatementList* self, gint index, ValaStatement* stmt) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (stmt != NULL);
	gee_list_insert (self->priv->list, index, stmt);
}


static void vala_statement_list_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaStatementList * self;
	self = (ValaStatementList*) base;
	g_return_if_fail (visitor != NULL);
	{
		GeeIterator* stmt_it;
		stmt_it = gee_iterable_iterator ((GeeIterable*) self->priv->list);
		while (gee_iterator_next (stmt_it)) {
			ValaStatement* stmt;
			stmt = (ValaStatement*) gee_iterator_get (stmt_it);
			vala_code_node_accept ((ValaCodeNode*) stmt, visitor);
			(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
		}
		(stmt_it == NULL) ? NULL : (stmt_it = (gee_collection_object_unref (stmt_it), NULL));
	}
}


gint vala_statement_list_get_length (ValaStatementList* self) {
	g_return_val_if_fail (self != NULL, 0);
	return gee_collection_get_size ((GeeCollection*) self->priv->list);
}


static void vala_statement_list_class_init (ValaStatementListClass * klass) {
	vala_statement_list_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_statement_list_finalize;
	g_type_class_add_private (klass, sizeof (ValaStatementListPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_statement_list_real_accept;
}


static void vala_statement_list_vala_statement_interface_init (ValaStatementIface * iface) {
	vala_statement_list_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void vala_statement_list_instance_init (ValaStatementList * self) {
	self->priv = VALA_STATEMENT_LIST_GET_PRIVATE (self);
	self->priv->list = (GeeList*) gee_array_list_new (VALA_TYPE_STATEMENT, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
}


static void vala_statement_list_finalize (ValaCodeNode* obj) {
	ValaStatementList * self;
	self = VALA_STATEMENT_LIST (obj);
	(self->priv->list == NULL) ? NULL : (self->priv->list = (gee_collection_object_unref (self->priv->list), NULL));
	VALA_CODE_NODE_CLASS (vala_statement_list_parent_class)->finalize (obj);
}


GType vala_statement_list_get_type (void) {
	static GType vala_statement_list_type_id = 0;
	if (vala_statement_list_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaStatementListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_statement_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaStatementList), 0, (GInstanceInitFunc) vala_statement_list_instance_init, NULL };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_statement_list_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		vala_statement_list_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaStatementList", &g_define_type_info, 0);
		g_type_add_interface_static (vala_statement_list_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
	}
	return vala_statement_list_type_id;
}




