/* valaccodeexpression.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodeexpression.h>




enum  {
	VALA_CCODE_EXPRESSION_DUMMY_PROPERTY
};
static void vala_ccode_expression_real_write_inner (ValaCCodeExpression* self, ValaCCodeWriter* writer);
static gpointer vala_ccode_expression_parent_class = NULL;



static void vala_ccode_expression_real_write_inner (ValaCCodeExpression* self, ValaCCodeWriter* writer) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (writer != NULL);
	vala_ccode_node_write ((ValaCCodeNode*) self, writer);
}


void vala_ccode_expression_write_inner (ValaCCodeExpression* self, ValaCCodeWriter* writer) {
	VALA_CCODE_EXPRESSION_GET_CLASS (self)->write_inner (self, writer);
}


static void vala_ccode_expression_class_init (ValaCCodeExpressionClass * klass) {
	vala_ccode_expression_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_EXPRESSION_CLASS (klass)->write_inner = vala_ccode_expression_real_write_inner;
}


static void vala_ccode_expression_instance_init (ValaCCodeExpression * self) {
}


GType vala_ccode_expression_get_type (void) {
	static GType vala_ccode_expression_type_id = 0;
	if (vala_ccode_expression_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeExpression), 0, (GInstanceInitFunc) vala_ccode_expression_instance_init, NULL };
		vala_ccode_expression_type_id = g_type_register_static (VALA_TYPE_CCODE_NODE, "ValaCCodeExpression", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_ccode_expression_type_id;
}




