/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodemethodcallmodule.h>
#include <vala/valacodenode.h>
#include <vala/valacodevisitor.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeexpression.h>
#include <vala/valamethod.h>
#include <gee/list.h>
#include <vala/valamemberaccess.h>
#include <vala/valaexpression.h>
#include <vala/valadatatype.h>
#include <vala/valamethodtype.h>
#include <vala/valasignaltype.h>
#include <vala/valabaseaccess.h>
#include <vala/valasignal.h>
#include <vala/valaobjecttype.h>
#include <vala/valaclass.h>
#include <ccode/valaccodeidentifier.h>
#include <stdlib.h>
#include <string.h>
#include <gee/hashmap.h>
#include <vala/valaarrayresizemethod.h>
#include <vala/valaarraytype.h>
#include <gee/map.h>
#include <float.h>
#include <math.h>
#include <vala/valaarraymovemethod.h>
#include <vala/valamember.h>
#include <vala/valacreationmethod.h>
#include <vala/valasymbol.h>
#include <vala/valastruct.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodememberaccess.h>
#include <ccode/valaccodecommaexpression.h>
#include <vala/valalocalvariable.h>
#include <ccode/valaccodeassignment.h>
#include <vala/valatypesymbol.h>
#include <vala/valadynamicmethod.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valaunaryexpression.h>
#include <vala/valaformalparameter.h>
#include <vala/valasourcereference.h>
#include <ccode/valaccodecastexpression.h>
#include <vala/valadelegatetype.h>
#include <vala/valadelegate.h>
#include <ccode/valaccodeconstant.h>
#include <vala/valavoidtype.h>
#include <vala/valapointertype.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeconditionalexpression.h>
#include <gobject/valaccodebasemodule.h>




enum  {
	VALA_CCODE_METHOD_CALL_MODULE_DUMMY_PROPERTY
};
static void vala_ccode_method_call_module_real_visit_method_call (ValaCCodeModule* base, ValaMethodCall* expr);
static gpointer vala_ccode_method_call_module_parent_class = NULL;
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaCCodeMethodCallModule* vala_ccode_method_call_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeMethodCallModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type, codegen, next);
	return self;
}


ValaCCodeMethodCallModule* vala_ccode_method_call_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE, codegen, next);
}


static void vala_ccode_method_call_module_real_visit_method_call (ValaCCodeModule* base, ValaMethodCall* expr) {
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall;
	ValaMethod* m;
	GeeList* params;
	ValaMemberAccess* _tmp1;
	ValaExpression* _tmp0;
	ValaMemberAccess* ma;
	ValaDataType* _tmp2;
	ValaDataType* itype;
	GeeList* _tmp3;
	ValaCCodeExpression* _tmp19;
	ValaCCodeExpression* ccall_expr;
	GeeHashMap* carg_map;
	ValaCCodeExpression* instance;
	gboolean _tmp23;
	gboolean _tmp24;
	gboolean ellipsis;
	gint i;
	gint arg_pos;
	GeeIterator* params_it;
	gboolean _tmp145;
	gboolean _tmp156;
	gboolean _tmp176;
	gint last_pos;
	gint min_pos;
	gboolean _tmp191;
	gboolean _tmp192;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	/* the bare function call*/
	ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_method_call_get_call (expr))));
	m = NULL;
	params = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	ma = (_tmp1 = (_tmp0 = vala_method_call_get_call (expr), VALA_IS_MEMBER_ACCESS (_tmp0) ? ((ValaMemberAccess*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp2 = NULL;
	itype = (_tmp2 = vala_expression_get_value_type (vala_method_call_get_call (expr)), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
	_tmp3 = NULL;
	params = (_tmp3 = vala_data_type_get_parameters (itype), (params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL)), _tmp3);
	if (VALA_IS_METHOD_TYPE (itype)) {
		ValaMethod* _tmp5;
		ValaMethod* _tmp4;
		g_assert (ma != NULL);
		_tmp5 = NULL;
		_tmp4 = NULL;
		m = (_tmp5 = (_tmp4 = vala_method_type_get_method_symbol ((VALA_METHOD_TYPE (itype))), (_tmp4 == NULL) ? NULL : vala_code_node_ref (_tmp4)), (m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL)), _tmp5);
	} else {
		if (VALA_IS_SIGNAL_TYPE (itype)) {
			ValaSignalType* _tmp6;
			ValaSignalType* sig_type;
			gboolean _tmp7;
			gboolean _tmp8;
			_tmp6 = NULL;
			sig_type = (_tmp6 = VALA_SIGNAL_TYPE (itype), (_tmp6 == NULL) ? NULL : vala_code_node_ref (_tmp6));
			_tmp7 = FALSE;
			_tmp8 = FALSE;
			if (ma != NULL) {
				_tmp8 = VALA_IS_BASE_ACCESS (vala_member_access_get_inner (ma));
			} else {
				_tmp8 = FALSE;
			}
			if (_tmp8) {
				_tmp7 = vala_signal_get_is_virtual (vala_signal_type_get_signal_symbol (sig_type));
			} else {
				_tmp7 = FALSE;
			}
			if (_tmp7) {
				ValaMethod* _tmp9;
				_tmp9 = NULL;
				m = (_tmp9 = vala_signal_get_method_handler (vala_signal_type_get_signal_symbol (sig_type)), (m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL)), _tmp9);
			} else {
				ValaCCodeFunctionCall* _tmp11;
				ValaCCodeFunctionCall* _tmp10;
				_tmp11 = NULL;
				_tmp10 = NULL;
				ccall = (_tmp11 = (_tmp10 = VALA_CCODE_FUNCTION_CALL (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_method_call_get_call (expr))), (_tmp10 == NULL) ? NULL : vala_ccode_node_ref (_tmp10)), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp11);
			}
			(sig_type == NULL) ? NULL : (sig_type = (vala_code_node_unref (sig_type), NULL));
		} else {
			if (VALA_IS_OBJECT_TYPE (itype)) {
				ValaClass* _tmp12;
				ValaClass* cl;
				ValaMethod* _tmp14;
				ValaMethod* _tmp13;
				ValaCCodeFunctionCall* _tmp17;
				ValaCCodeIdentifier* _tmp16;
				char* _tmp15;
				ValaCCodeIdentifier* _tmp18;
				/* constructor*/
				_tmp12 = NULL;
				cl = (_tmp12 = VALA_CLASS (vala_object_type_get_type_symbol ((VALA_OBJECT_TYPE (itype)))), (_tmp12 == NULL) ? NULL : vala_code_node_ref (_tmp12));
				_tmp14 = NULL;
				_tmp13 = NULL;
				m = (_tmp14 = (_tmp13 = vala_class_get_default_construction_method (cl), (_tmp13 == NULL) ? NULL : vala_code_node_ref (_tmp13)), (m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL)), _tmp14);
				_tmp17 = NULL;
				_tmp16 = NULL;
				_tmp15 = NULL;
				ccall = (_tmp17 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp16 = vala_ccode_identifier_new (_tmp15 = vala_method_get_real_cname (m)))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp17);
				(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
				_tmp15 = (g_free (_tmp15), NULL);
				_tmp18 = NULL;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp18 = vala_ccode_identifier_new ("object_type")));
				(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
				(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
			}
		}
	}
	/* the complete call expression, might include casts, comma expressions, and/or assignments*/
	_tmp19 = NULL;
	ccall_expr = (_tmp19 = (ValaCCodeExpression*) ccall, (_tmp19 == NULL) ? NULL : vala_ccode_node_ref (_tmp19));
	carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		ValaArrayType* _tmp20;
		ValaArrayType* array_type;
		ValaCCodeIdentifier* _tmp22;
		char* _tmp21;
		_tmp20 = NULL;
		array_type = (_tmp20 = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (ma))), (_tmp20 == NULL) ? NULL : vala_code_node_ref (_tmp20));
		_tmp22 = NULL;
		_tmp21 = NULL;
		gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) 0, FALSE)), (ValaCCodeExpression*) (_tmp22 = vala_ccode_identifier_new (_tmp21 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))));
		(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
		_tmp21 = (g_free (_tmp21), NULL);
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	} else {
		if (VALA_IS_ARRAY_MOVE_METHOD (m)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		}
	}
	instance = NULL;
	_tmp23 = FALSE;
	_tmp24 = FALSE;
	if (m != NULL) {
		_tmp24 = vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE;
	} else {
		_tmp24 = FALSE;
	}
	if (_tmp24) {
		_tmp23 = !(VALA_IS_CREATION_METHOD (m));
	} else {
		_tmp23 = FALSE;
	}
	if (_tmp23) {
		ValaCCodeExpression* _tmp26;
		ValaCCodeExpression* _tmp25;
		ValaStruct* _tmp28;
		ValaSymbol* _tmp27;
		ValaStruct* st;
		gboolean _tmp29;
		_tmp26 = NULL;
		_tmp25 = NULL;
		instance = (_tmp26 = (_tmp25 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (ma))), (_tmp25 == NULL) ? NULL : vala_ccode_node_ref (_tmp25)), (instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)), _tmp26);
		_tmp28 = NULL;
		_tmp27 = NULL;
		st = (_tmp28 = (_tmp27 = vala_symbol_get_parent_symbol ((ValaSymbol*) m), VALA_IS_STRUCT (_tmp27) ? ((ValaStruct*) _tmp27) : NULL), (_tmp28 == NULL) ? NULL : vala_code_node_ref (_tmp28));
		_tmp29 = FALSE;
		if (st != NULL) {
			_tmp29 = !vala_struct_is_simple_type (st);
		} else {
			_tmp29 = FALSE;
		}
		if (_tmp29) {
			ValaCCodeUnaryExpression* _tmp31;
			ValaCCodeExpression* _tmp30;
			ValaCCodeUnaryExpression* unary;
			gboolean _tmp32;
			/* we need to pass struct instance by reference*/
			_tmp31 = NULL;
			_tmp30 = NULL;
			unary = (_tmp31 = (_tmp30 = instance, VALA_IS_CCODE_UNARY_EXPRESSION (_tmp30) ? ((ValaCCodeUnaryExpression*) _tmp30) : NULL), (_tmp31 == NULL) ? NULL : vala_ccode_node_ref (_tmp31));
			_tmp32 = FALSE;
			if (unary != NULL) {
				_tmp32 = vala_ccode_unary_expression_get_operator (unary) == VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION;
			} else {
				_tmp32 = FALSE;
			}
			if (_tmp32) {
				ValaCCodeExpression* _tmp34;
				ValaCCodeExpression* _tmp33;
				/* *expr => expr*/
				_tmp34 = NULL;
				_tmp33 = NULL;
				instance = (_tmp34 = (_tmp33 = vala_ccode_unary_expression_get_inner (unary), (_tmp33 == NULL) ? NULL : vala_ccode_node_ref (_tmp33)), (instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)), _tmp34);
			} else {
				gboolean _tmp35;
				_tmp35 = FALSE;
				if (VALA_IS_CCODE_IDENTIFIER (instance)) {
					_tmp35 = TRUE;
				} else {
					_tmp35 = VALA_IS_CCODE_MEMBER_ACCESS (instance);
				}
				if (_tmp35) {
					ValaCCodeExpression* _tmp36;
					_tmp36 = NULL;
					instance = (_tmp36 = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, instance), (instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)), _tmp36);
				} else {
					ValaCCodeCommaExpression* ccomma;
					ValaLocalVariable* temp_var;
					ValaCCodeAssignment* _tmp38;
					ValaCCodeIdentifier* _tmp37;
					ValaCCodeUnaryExpression* _tmp40;
					ValaCCodeIdentifier* _tmp39;
					ValaCCodeExpression* _tmp42;
					ValaCCodeExpression* _tmp41;
					/* if instance is e.g. a function call, we can't take the address of the expression
					 (tmp = expr, &tmp)*/
					ccomma = vala_ccode_comma_expression_new ();
					temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_target_type (vala_member_access_get_inner (ma)), TRUE, NULL);
					gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
					_tmp38 = NULL;
					_tmp37 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp38 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp37 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var))), instance, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
					(_tmp38 == NULL) ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL));
					(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
					_tmp40 = NULL;
					_tmp39 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp40 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp39 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var))))));
					(_tmp40 == NULL) ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL));
					(_tmp39 == NULL) ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL));
					_tmp42 = NULL;
					_tmp41 = NULL;
					instance = (_tmp42 = (_tmp41 = (ValaCCodeExpression*) ccomma, (_tmp41 == NULL) ? NULL : vala_ccode_node_ref (_tmp41)), (instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)), _tmp42);
					(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
					(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
				}
			}
			(unary == NULL) ? NULL : (unary = (vala_ccode_node_unref (unary), NULL));
		}
		gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), instance);
		(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
	} else {
		gboolean _tmp43;
		_tmp43 = FALSE;
		if (m != NULL) {
			_tmp43 = vala_method_get_binding (m) == MEMBER_BINDING_CLASS;
		} else {
			_tmp43 = FALSE;
		}
		if (_tmp43) {
			ValaClass* _tmp44;
			ValaClass* cl;
			ValaCCodeIdentifier* _tmp47;
			char* _tmp46;
			char* _tmp45;
			ValaCCodeFunctionCall* _tmp48;
			ValaCCodeFunctionCall* cast;
			ValaCCodeExpression* klass;
			_tmp44 = NULL;
			cl = (_tmp44 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), (_tmp44 == NULL) ? NULL : vala_code_node_ref (_tmp44));
			_tmp47 = NULL;
			_tmp46 = NULL;
			_tmp45 = NULL;
			_tmp48 = NULL;
			cast = (_tmp48 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp47 = vala_ccode_identifier_new (_tmp46 = g_strconcat (_tmp45 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL), "_CLASS", NULL)))), (_tmp47 == NULL) ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL)), _tmp46 = (g_free (_tmp46), NULL), _tmp45 = (g_free (_tmp45), NULL), _tmp48);
			klass = NULL;
			if (vala_member_access_get_inner (ma) == NULL) {
				if (((ValaCCodeBaseModule*) self)->in_static_or_class_ctor) {
					ValaCCodeExpression* _tmp49;
					/* Accessing the method from a static or class constructor*/
					_tmp49 = NULL;
					klass = (_tmp49 = (ValaCCodeExpression*) vala_ccode_identifier_new ("klass"), (klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)), _tmp49);
				} else {
					ValaCCodeIdentifier* _tmp50;
					ValaCCodeFunctionCall* _tmp51;
					ValaCCodeFunctionCall* k;
					ValaCCodeIdentifier* _tmp52;
					ValaCCodeExpression* _tmp54;
					ValaCCodeExpression* _tmp53;
					/* Accessing the method from within an instance method*/
					_tmp50 = NULL;
					_tmp51 = NULL;
					k = (_tmp51 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp50 = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS"))), (_tmp50 == NULL) ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL)), _tmp51);
					_tmp52 = NULL;
					vala_ccode_function_call_add_argument (k, (ValaCCodeExpression*) (_tmp52 = vala_ccode_identifier_new ("self")));
					(_tmp52 == NULL) ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL));
					_tmp54 = NULL;
					_tmp53 = NULL;
					klass = (_tmp54 = (_tmp53 = (ValaCCodeExpression*) k, (_tmp53 == NULL) ? NULL : vala_ccode_node_ref (_tmp53)), (klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)), _tmp54);
					(k == NULL) ? NULL : (k = (vala_ccode_node_unref (k), NULL));
				}
			} else {
				ValaCCodeIdentifier* _tmp55;
				ValaCCodeFunctionCall* _tmp56;
				ValaCCodeFunctionCall* k;
				ValaCCodeExpression* _tmp58;
				ValaCCodeExpression* _tmp57;
				/* Accessing the method of an instance*/
				_tmp55 = NULL;
				_tmp56 = NULL;
				k = (_tmp56 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp55 = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS"))), (_tmp55 == NULL) ? NULL : (_tmp55 = (vala_ccode_node_unref (_tmp55), NULL)), _tmp56);
				vala_ccode_function_call_add_argument (k, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (ma))));
				_tmp58 = NULL;
				_tmp57 = NULL;
				klass = (_tmp58 = (_tmp57 = (ValaCCodeExpression*) k, (_tmp57 == NULL) ? NULL : vala_ccode_node_ref (_tmp57)), (klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)), _tmp58);
				(k == NULL) ? NULL : (k = (vala_ccode_node_unref (k), NULL));
			}
			vala_ccode_function_call_add_argument (cast, klass);
			gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), (ValaCCodeExpression*) cast);
			(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
			(cast == NULL) ? NULL : (cast = (vala_ccode_node_unref (cast), NULL));
			(klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL));
		}
	}
	if (VALA_IS_ARRAY_MOVE_METHOD (m)) {
		ValaArrayType* _tmp59;
		ValaArrayType* array_type;
		ValaCCodeIdentifier* _tmp60;
		ValaCCodeFunctionCall* _tmp61;
		ValaCCodeFunctionCall* csizeof;
		ValaCCodeIdentifier* _tmp63;
		char* _tmp62;
		_tmp59 = NULL;
		array_type = (_tmp59 = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (ma))), (_tmp59 == NULL) ? NULL : vala_code_node_ref (_tmp59));
		_tmp60 = NULL;
		_tmp61 = NULL;
		csizeof = (_tmp61 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp60 = vala_ccode_identifier_new ("sizeof"))), (_tmp60 == NULL) ? NULL : (_tmp60 = (vala_ccode_node_unref (_tmp60), NULL)), _tmp61);
		_tmp63 = NULL;
		_tmp62 = NULL;
		vala_ccode_function_call_add_argument (csizeof, (ValaCCodeExpression*) (_tmp63 = vala_ccode_identifier_new (_tmp62 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))));
		(_tmp63 == NULL) ? NULL : (_tmp63 = (vala_ccode_node_unref (_tmp63), NULL));
		_tmp62 = (g_free (_tmp62), NULL);
		gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) csizeof);
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		(csizeof == NULL) ? NULL : (csizeof = (vala_ccode_node_unref (csizeof), NULL));
	} else {
		if (VALA_IS_DYNAMIC_METHOD (m)) {
			gint param_nr;
			vala_method_clear_parameters (m);
			param_nr = 1;
			{
				GeeList* _tmp64;
				GeeIterator* _tmp65;
				GeeIterator* _arg_it;
				_tmp64 = NULL;
				_tmp65 = NULL;
				_arg_it = (_tmp65 = gee_iterable_iterator ((GeeIterable*) (_tmp64 = vala_method_call_get_argument_list (expr))), (_tmp64 == NULL) ? NULL : (_tmp64 = (gee_collection_object_unref (_tmp64), NULL)), _tmp65);
				while (gee_iterator_next (_arg_it)) {
					ValaExpression* arg;
					ValaUnaryExpression* _tmp67;
					ValaExpression* _tmp66;
					ValaUnaryExpression* unary;
					gboolean _tmp68;
					arg = (ValaExpression*) gee_iterator_get (_arg_it);
					_tmp67 = NULL;
					_tmp66 = NULL;
					unary = (_tmp67 = (_tmp66 = arg, VALA_IS_UNARY_EXPRESSION (_tmp66) ? ((ValaUnaryExpression*) _tmp66) : NULL), (_tmp67 == NULL) ? NULL : vala_code_node_ref (_tmp67));
					_tmp68 = FALSE;
					if (unary != NULL) {
						_tmp68 = vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp68 = FALSE;
					}
					if (_tmp68) {
						char* _tmp69;
						ValaFormalParameter* _tmp70;
						ValaFormalParameter* param;
						/* out argument*/
						_tmp69 = NULL;
						_tmp70 = NULL;
						param = (_tmp70 = vala_formal_parameter_new (_tmp69 = g_strdup_printf ("param%d", param_nr), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), NULL), _tmp69 = (g_free (_tmp69), NULL), _tmp70);
						vala_formal_parameter_set_direction (param, VALA_PARAMETER_DIRECTION_OUT);
						vala_method_add_parameter (m, param);
						(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
					} else {
						gboolean _tmp71;
						_tmp71 = FALSE;
						if (unary != NULL) {
							_tmp71 = vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp71 = FALSE;
						}
						if (_tmp71) {
							char* _tmp72;
							ValaFormalParameter* _tmp73;
							ValaFormalParameter* param;
							/* ref argument*/
							_tmp72 = NULL;
							_tmp73 = NULL;
							param = (_tmp73 = vala_formal_parameter_new (_tmp72 = g_strdup_printf ("param%d", param_nr), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), NULL), _tmp72 = (g_free (_tmp72), NULL), _tmp73);
							vala_formal_parameter_set_direction (param, VALA_PARAMETER_DIRECTION_REF);
							vala_method_add_parameter (m, param);
							(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
						} else {
							ValaFormalParameter* _tmp75;
							char* _tmp74;
							/* in argument*/
							_tmp75 = NULL;
							_tmp74 = NULL;
							vala_method_add_parameter (m, _tmp75 = vala_formal_parameter_new (_tmp74 = g_strdup_printf ("param%d", param_nr), vala_expression_get_value_type (arg), NULL));
							(_tmp75 == NULL) ? NULL : (_tmp75 = (vala_code_node_unref (_tmp75), NULL));
							_tmp74 = (g_free (_tmp74), NULL);
						}
					}
					param_nr++;
					(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
					(unary == NULL) ? NULL : (unary = (vala_code_node_unref (unary), NULL));
				}
				(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
			}
			{
				GeeList* _tmp76;
				GeeIterator* _tmp77;
				GeeIterator* _param_it;
				_tmp76 = NULL;
				_tmp77 = NULL;
				_param_it = (_tmp77 = gee_iterable_iterator ((GeeIterable*) (_tmp76 = vala_method_get_parameters (m))), (_tmp76 == NULL) ? NULL : (_tmp76 = (gee_collection_object_unref (_tmp76), NULL)), _tmp77);
				while (gee_iterator_next (_param_it)) {
					ValaFormalParameter* param;
					param = (ValaFormalParameter*) gee_iterator_get (_param_it);
					vala_code_node_accept ((ValaCodeNode*) param, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				}
				(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
			}
			vala_ccode_module_generate_dynamic_method_wrapper (vala_ccode_module_get_head ((ValaCCodeModule*) self), VALA_DYNAMIC_METHOD (m));
		} else {
			if (VALA_IS_CREATION_METHOD (m)) {
				ValaCCodeExpression* _tmp82;
				ValaCCodeCastExpression* _tmp81;
				char* _tmp80;
				char* _tmp79;
				ValaCCodeIdentifier* _tmp78;
				_tmp82 = NULL;
				_tmp81 = NULL;
				_tmp80 = NULL;
				_tmp79 = NULL;
				_tmp78 = NULL;
				ccall_expr = (_tmp82 = (ValaCCodeExpression*) vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp78 = vala_ccode_identifier_new ("self")), (ValaCCodeExpression*) (_tmp81 = vala_ccode_cast_expression_new ((ValaCCodeExpression*) ccall, _tmp80 = g_strconcat (_tmp79 = vala_typesymbol_get_cname ((ValaTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class, FALSE), "*", NULL))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp82);
				(_tmp81 == NULL) ? NULL : (_tmp81 = (vala_ccode_node_unref (_tmp81), NULL));
				_tmp80 = (g_free (_tmp80), NULL);
				_tmp79 = (g_free (_tmp79), NULL);
				(_tmp78 == NULL) ? NULL : (_tmp78 = (vala_ccode_node_unref (_tmp78), NULL));
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	arg_pos = 0;
	params_it = gee_iterable_iterator ((GeeIterable*) params);
	{
		GeeList* _tmp83;
		GeeIterator* _tmp84;
		GeeIterator* _arg_it;
		_tmp83 = NULL;
		_tmp84 = NULL;
		_arg_it = (_tmp84 = gee_iterable_iterator ((GeeIterable*) (_tmp83 = vala_method_call_get_argument_list (expr))), (_tmp83 == NULL) ? NULL : (_tmp83 = (gee_collection_object_unref (_tmp83), NULL)), _tmp84);
		while (gee_iterator_next (_arg_it)) {
			ValaExpression* arg;
			ValaCCodeExpression* _tmp85;
			ValaCCodeExpression* cexpr;
			arg = (ValaExpression*) gee_iterator_get (_arg_it);
			_tmp85 = NULL;
			cexpr = (_tmp85 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) arg)), (_tmp85 == NULL) ? NULL : vala_ccode_node_ref (_tmp85));
			if (gee_iterator_next (params_it)) {
				ValaFormalParameter* param;
				gboolean _tmp86;
				param = (ValaFormalParameter*) gee_iterator_get (params_it);
				_tmp86 = FALSE;
				if (vala_formal_parameter_get_params_array (param)) {
					_tmp86 = TRUE;
				} else {
					_tmp86 = vala_formal_parameter_get_ellipsis (param);
				}
				ellipsis = _tmp86;
				if (!ellipsis) {
					gboolean multiple_cargs;
					gboolean _tmp87;
					ValaCCodeExpression* _tmp107;
					gboolean _tmp108;
					gboolean _tmp114;
					gboolean _tmp115;
					gboolean _tmp116;
					/* if the vala argument expands to multiple C arguments,
					 we have to make sure that the C arguments don't depend
					 on each other as there is no guaranteed argument
					 evaluation order
					 http://bugzilla.gnome.org/show_bug.cgi?id=519597*/
					multiple_cargs = FALSE;
					_tmp87 = FALSE;
					if (!vala_formal_parameter_get_no_array_length (param)) {
						_tmp87 = VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param));
					} else {
						_tmp87 = FALSE;
					}
					if (_tmp87) {
						ValaArrayType* _tmp88;
						ValaArrayType* array_type;
						_tmp88 = NULL;
						array_type = (_tmp88 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp88 == NULL) ? NULL : vala_code_node_ref (_tmp88));
						{
							gint dim;
							dim = 1;
							for (; dim <= vala_array_type_get_rank (array_type); dim++) {
								ValaCCodeExpression* _tmp89;
								_tmp89 = NULL;
								gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_carray_length_parameter_position (param) + (0.01 * dim), FALSE)), _tmp89 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), arg, dim));
								(_tmp89 == NULL) ? NULL : (_tmp89 = (vala_ccode_node_unref (_tmp89), NULL));
							}
						}
						multiple_cargs = TRUE;
						(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
					} else {
						if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param))) {
							ValaDelegateType* _tmp90;
							ValaDelegateType* deleg_type;
							ValaDelegate* _tmp91;
							ValaDelegate* d;
							_tmp90 = NULL;
							deleg_type = (_tmp90 = VALA_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp90 == NULL) ? NULL : vala_code_node_ref (_tmp90));
							_tmp91 = NULL;
							d = (_tmp91 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp91 == NULL) ? NULL : vala_code_node_ref (_tmp91));
							if (vala_delegate_get_has_target (d)) {
								ValaCCodeExpression* delegate_target;
								delegate_target = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, arg);
								if (vala_data_type_get_value_owned ((ValaDataType*) deleg_type)) {
									ValaCCodeExpression* delegate_target_destroy_notify;
									ValaMethod* _tmp93;
									ValaSymbol* _tmp92;
									ValaMethod* delegate_method;
									ValaMemberAccess* _tmp95;
									ValaExpression* _tmp94;
									ValaMemberAccess* arg_ma;
									gboolean _tmp96;
									gboolean _tmp97;
									gboolean _tmp98;
									gboolean _tmp99;
									delegate_target_destroy_notify = NULL;
									_tmp93 = NULL;
									_tmp92 = NULL;
									delegate_method = (_tmp93 = (_tmp92 = vala_expression_get_symbol_reference (arg), VALA_IS_METHOD (_tmp92) ? ((ValaMethod*) _tmp92) : NULL), (_tmp93 == NULL) ? NULL : vala_code_node_ref (_tmp93));
									_tmp95 = NULL;
									_tmp94 = NULL;
									arg_ma = (_tmp95 = (_tmp94 = arg, VALA_IS_MEMBER_ACCESS (_tmp94) ? ((ValaMemberAccess*) _tmp94) : NULL), (_tmp95 == NULL) ? NULL : vala_code_node_ref (_tmp95));
									_tmp96 = FALSE;
									_tmp97 = FALSE;
									_tmp98 = FALSE;
									_tmp99 = FALSE;
									if (delegate_method != NULL) {
										_tmp99 = vala_method_get_binding (delegate_method) == MEMBER_BINDING_INSTANCE;
									} else {
										_tmp99 = FALSE;
									}
									if (_tmp99) {
										_tmp98 = vala_member_access_get_inner (arg_ma) != NULL;
									} else {
										_tmp98 = FALSE;
									}
									if (_tmp98) {
										_tmp97 = vala_data_type_get_data_type (vala_expression_get_value_type (vala_member_access_get_inner (arg_ma))) != NULL;
									} else {
										_tmp97 = FALSE;
									}
									if (_tmp97) {
										_tmp96 = vala_typesymbol_is_reference_counting (vala_data_type_get_data_type (vala_expression_get_value_type (vala_member_access_get_inner (arg_ma))));
									} else {
										_tmp96 = FALSE;
									}
									if (_tmp96) {
										ValaCCodeExpression* _tmp100;
										ValaCCodeFunctionCall* _tmp101;
										ValaCCodeFunctionCall* ref_call;
										ValaCCodeExpression* _tmp103;
										ValaCCodeExpression* _tmp102;
										ValaCCodeExpression* _tmp104;
										_tmp100 = NULL;
										_tmp101 = NULL;
										ref_call = (_tmp101 = vala_ccode_function_call_new (_tmp100 = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (vala_member_access_get_inner (arg_ma)), vala_code_node_get_source_reference ((ValaCodeNode*) arg))), (_tmp100 == NULL) ? NULL : (_tmp100 = (vala_ccode_node_unref (_tmp100), NULL)), _tmp101);
										vala_ccode_function_call_add_argument (ref_call, delegate_target);
										_tmp103 = NULL;
										_tmp102 = NULL;
										delegate_target = (_tmp103 = (_tmp102 = (ValaCCodeExpression*) ref_call, (_tmp102 == NULL) ? NULL : vala_ccode_node_ref (_tmp102)), (delegate_target == NULL) ? NULL : (delegate_target = (vala_ccode_node_unref (delegate_target), NULL)), _tmp103);
										_tmp104 = NULL;
										delegate_target_destroy_notify = (_tmp104 = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (vala_member_access_get_inner (arg_ma))), (delegate_target_destroy_notify == NULL) ? NULL : (delegate_target_destroy_notify = (vala_ccode_node_unref (delegate_target_destroy_notify), NULL)), _tmp104);
										(ref_call == NULL) ? NULL : (ref_call = (vala_ccode_node_unref (ref_call), NULL));
									} else {
										ValaCCodeExpression* _tmp105;
										_tmp105 = NULL;
										delegate_target_destroy_notify = (_tmp105 = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL"), (delegate_target_destroy_notify == NULL) ? NULL : (delegate_target_destroy_notify = (vala_ccode_node_unref (delegate_target_destroy_notify), NULL)), _tmp105);
									}
									gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param) + 0.01, FALSE)), delegate_target_destroy_notify);
									(delegate_target_destroy_notify == NULL) ? NULL : (delegate_target_destroy_notify = (vala_ccode_node_unref (delegate_target_destroy_notify), NULL));
									(delegate_method == NULL) ? NULL : (delegate_method = (vala_code_node_unref (delegate_method), NULL));
									(arg_ma == NULL) ? NULL : (arg_ma = (vala_code_node_unref (arg_ma), NULL));
								}
								gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), delegate_target);
								multiple_cargs = TRUE;
								(delegate_target == NULL) ? NULL : (delegate_target = (vala_ccode_node_unref (delegate_target), NULL));
							}
							(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
							(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
						} else {
							if (VALA_IS_METHOD_TYPE (vala_formal_parameter_get_parameter_type (param))) {
								ValaCCodeExpression* _tmp106;
								_tmp106 = NULL;
								gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), _tmp106 = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, arg));
								(_tmp106 == NULL) ? NULL : (_tmp106 = (vala_ccode_node_unref (_tmp106), NULL));
								multiple_cargs = TRUE;
							}
						}
					}
					_tmp107 = NULL;
					cexpr = (_tmp107 = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, param, arg, cexpr), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp107);
					_tmp108 = FALSE;
					if (multiple_cargs) {
						_tmp108 = VALA_IS_METHOD_CALL (arg);
					} else {
						_tmp108 = FALSE;
					}
					if (_tmp108) {
						ValaCCodeCommaExpression* ccomma;
						ValaLocalVariable* temp_decl;
						ValaCCodeAssignment* _tmp110;
						ValaCCodeIdentifier* _tmp109;
						ValaCCodeExpression* _tmp111;
						ValaCCodeExpression* _tmp113;
						ValaCCodeExpression* _tmp112;
						/* if vala argument is invocation expression
						 the auxiliary C argument(s) will depend on the main C argument
						 (tmp = arg1, call (tmp, arg2, arg3,...))*/
						ccomma = vala_ccode_comma_expression_new ();
						temp_decl = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (arg), TRUE, NULL);
						gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_decl);
						_tmp110 = NULL;
						_tmp109 = NULL;
						vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp110 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp109 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_decl))), cexpr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
						(_tmp110 == NULL) ? NULL : (_tmp110 = (vala_ccode_node_unref (_tmp110), NULL));
						(_tmp109 == NULL) ? NULL : (_tmp109 = (vala_ccode_node_unref (_tmp109), NULL));
						_tmp111 = NULL;
						cexpr = (_tmp111 = (ValaCCodeExpression*) vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_decl)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp111);
						vala_ccode_comma_expression_append_expression (ccomma, ccall_expr);
						_tmp113 = NULL;
						_tmp112 = NULL;
						ccall_expr = (_tmp113 = (_tmp112 = (ValaCCodeExpression*) ccomma, (_tmp112 == NULL) ? NULL : vala_ccode_node_ref (_tmp112)), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp113);
						(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
						(temp_decl == NULL) ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL));
					}
					_tmp114 = FALSE;
					_tmp115 = FALSE;
					_tmp116 = FALSE;
					if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
						_tmp116 = vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (arg));
					} else {
						_tmp116 = FALSE;
					}
					if (_tmp116) {
						gboolean _tmp117;
						_tmp117 = FALSE;
						if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT) {
							_tmp117 = TRUE;
						} else {
							_tmp117 = !vala_data_type_get_value_owned (vala_formal_parameter_get_parameter_type (param));
						}
						_tmp115 = (_tmp117);
					} else {
						_tmp115 = FALSE;
					}
					if (_tmp115) {
						_tmp114 = !(VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)));
					} else {
						_tmp114 = FALSE;
					}
					/* unref old value for non-null non-weak ref/out arguments
					 disabled for arrays for now as that requires special handling
					 (ret_tmp = call (&tmp), var1 = (assign_tmp = dup (tmp), free (var1), assign_tmp), ret_tmp)*/
					if (_tmp114) {
						ValaUnaryExpression* _tmp118;
						ValaUnaryExpression* unary;
						ValaCCodeCommaExpression* ccomma;
						ValaLocalVariable* temp_var;
						ValaCCodeExpression* _tmp120;
						ValaCCodeIdentifier* _tmp119;
						ValaLocalVariable* ret_temp_var;
						ValaDataType* _tmp125;
						gboolean _tmp126;
						ValaCCodeCommaExpression* cassign_comma;
						ValaLocalVariable* assign_temp_var;
						ValaCCodeAssignment* _tmp134;
						ValaCCodeExpression* _tmp133;
						ValaCCodeIdentifier* _tmp132;
						ValaCCodeIdentifier* _tmp131;
						ValaCCodeExpression* _tmp135;
						ValaCCodeIdentifier* _tmp136;
						ValaCCodeAssignment* _tmp137;
						ValaDataType* _tmp138;
						gboolean _tmp139;
						ValaCCodeExpression* _tmp142;
						ValaCCodeExpression* _tmp141;
						_tmp118 = NULL;
						unary = (_tmp118 = VALA_UNARY_EXPRESSION (arg), (_tmp118 == NULL) ? NULL : vala_code_node_ref (_tmp118));
						ccomma = vala_ccode_comma_expression_new ();
						temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_parameter_type (param), vala_data_type_get_value_owned (vala_formal_parameter_get_parameter_type (param)), NULL);
						gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
						_tmp120 = NULL;
						_tmp119 = NULL;
						cexpr = (_tmp120 = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp119 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var)))), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp120);
						(_tmp119 == NULL) ? NULL : (_tmp119 = (vala_ccode_node_unref (_tmp119), NULL));
						if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_REF) {
							ValaCCodeCommaExpression* crefcomma;
							ValaCCodeAssignment* _tmp122;
							ValaCCodeIdentifier* _tmp121;
							ValaCCodeExpression* _tmp124;
							ValaCCodeExpression* _tmp123;
							crefcomma = vala_ccode_comma_expression_new ();
							_tmp122 = NULL;
							_tmp121 = NULL;
							vala_ccode_comma_expression_append_expression (crefcomma, (ValaCCodeExpression*) (_tmp122 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp121 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_unary_expression_get_inner (unary))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
							(_tmp122 == NULL) ? NULL : (_tmp122 = (vala_ccode_node_unref (_tmp122), NULL));
							(_tmp121 == NULL) ? NULL : (_tmp121 = (vala_ccode_node_unref (_tmp121), NULL));
							vala_ccode_comma_expression_append_expression (crefcomma, cexpr);
							_tmp124 = NULL;
							_tmp123 = NULL;
							cexpr = (_tmp124 = (_tmp123 = (ValaCCodeExpression*) crefcomma, (_tmp123 == NULL) ? NULL : vala_ccode_node_ref (_tmp123)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp124);
							(crefcomma == NULL) ? NULL : (crefcomma = (vala_ccode_node_unref (crefcomma), NULL));
						}
						/* call function*/
						ret_temp_var = NULL;
						_tmp125 = NULL;
						if ((_tmp126 = VALA_IS_VOID_TYPE (_tmp125 = vala_data_type_get_return_type (itype)), (_tmp125 == NULL) ? NULL : (_tmp125 = (vala_code_node_unref (_tmp125), NULL)), _tmp126)) {
							vala_ccode_comma_expression_append_expression (ccomma, ccall_expr);
						} else {
							ValaLocalVariable* _tmp128;
							ValaDataType* _tmp127;
							ValaCCodeAssignment* _tmp130;
							ValaCCodeIdentifier* _tmp129;
							_tmp128 = NULL;
							_tmp127 = NULL;
							ret_temp_var = (_tmp128 = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp127 = vala_data_type_get_return_type (itype), TRUE, NULL), (ret_temp_var == NULL) ? NULL : (ret_temp_var = (vala_code_node_unref (ret_temp_var), NULL)), _tmp128);
							(_tmp127 == NULL) ? NULL : (_tmp127 = (vala_code_node_unref (_tmp127), NULL));
							gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, ret_temp_var);
							_tmp130 = NULL;
							_tmp129 = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp130 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp129 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) ret_temp_var))), ccall_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
							(_tmp130 == NULL) ? NULL : (_tmp130 = (vala_ccode_node_unref (_tmp130), NULL));
							(_tmp129 == NULL) ? NULL : (_tmp129 = (vala_ccode_node_unref (_tmp129), NULL));
						}
						cassign_comma = vala_ccode_comma_expression_new ();
						assign_temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), vala_data_type_get_value_owned (vala_expression_get_value_type (vala_unary_expression_get_inner (unary))), NULL);
						gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, assign_temp_var);
						_tmp134 = NULL;
						_tmp133 = NULL;
						_tmp132 = NULL;
						_tmp131 = NULL;
						vala_ccode_comma_expression_append_expression (cassign_comma, (ValaCCodeExpression*) (_tmp134 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp131 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) assign_temp_var))), _tmp133 = vala_ccode_base_module_transform_expression ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) (_tmp132 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var))), vala_formal_parameter_get_parameter_type (param), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), arg), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
						(_tmp134 == NULL) ? NULL : (_tmp134 = (vala_ccode_node_unref (_tmp134), NULL));
						(_tmp133 == NULL) ? NULL : (_tmp133 = (vala_ccode_node_unref (_tmp133), NULL));
						(_tmp132 == NULL) ? NULL : (_tmp132 = (vala_ccode_node_unref (_tmp132), NULL));
						(_tmp131 == NULL) ? NULL : (_tmp131 = (vala_ccode_node_unref (_tmp131), NULL));
						/* unref old value*/
						_tmp135 = NULL;
						vala_ccode_comma_expression_append_expression (cassign_comma, _tmp135 = vala_ccode_base_module_get_unref_expression ((ValaCCodeBaseModule*) self, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_unary_expression_get_inner (unary))), vala_expression_get_value_type (arg), arg));
						(_tmp135 == NULL) ? NULL : (_tmp135 = (vala_ccode_node_unref (_tmp135), NULL));
						_tmp136 = NULL;
						vala_ccode_comma_expression_append_expression (cassign_comma, (ValaCCodeExpression*) (_tmp136 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) assign_temp_var))));
						(_tmp136 == NULL) ? NULL : (_tmp136 = (vala_ccode_node_unref (_tmp136), NULL));
						/* assign new value*/
						_tmp137 = NULL;
						vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp137 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_unary_expression_get_inner (unary))), (ValaCCodeExpression*) cassign_comma, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
						(_tmp137 == NULL) ? NULL : (_tmp137 = (vala_ccode_node_unref (_tmp137), NULL));
						/* return value*/
						_tmp138 = NULL;
						if ((_tmp139 = !(VALA_IS_VOID_TYPE (_tmp138 = vala_data_type_get_return_type (itype))), (_tmp138 == NULL) ? NULL : (_tmp138 = (vala_code_node_unref (_tmp138), NULL)), _tmp139)) {
							ValaCCodeIdentifier* _tmp140;
							_tmp140 = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp140 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) ret_temp_var))));
							(_tmp140 == NULL) ? NULL : (_tmp140 = (vala_ccode_node_unref (_tmp140), NULL));
						}
						_tmp142 = NULL;
						_tmp141 = NULL;
						ccall_expr = (_tmp142 = (_tmp141 = (ValaCCodeExpression*) ccomma, (_tmp141 == NULL) ? NULL : vala_ccode_node_ref (_tmp141)), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp142);
						(unary == NULL) ? NULL : (unary = (vala_code_node_unref (unary), NULL));
						(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
						(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
						(ret_temp_var == NULL) ? NULL : (ret_temp_var = (vala_code_node_unref (ret_temp_var), NULL));
						(cassign_comma == NULL) ? NULL : (cassign_comma = (vala_ccode_node_unref (cassign_comma), NULL));
						(assign_temp_var == NULL) ? NULL : (assign_temp_var = (vala_code_node_unref (assign_temp_var), NULL));
					}
					if (vala_formal_parameter_get_ctype (param) != NULL) {
						ValaCCodeExpression* _tmp143;
						_tmp143 = NULL;
						cexpr = (_tmp143 = (ValaCCodeExpression*) vala_ccode_cast_expression_new (cexpr, vala_formal_parameter_get_ctype (param)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp143);
					}
				}
				arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cparameter_position (param), ellipsis);
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
			} else {
				/* default argument position*/
				arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) i, ellipsis);
			}
			gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (arg_pos), cexpr);
			i++;
			(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
			(cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL));
		}
		(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
	}
	if (gee_iterator_next (params_it)) {
		ValaFormalParameter* param;
		gboolean _tmp144;
		param = (ValaFormalParameter*) gee_iterator_get (params_it);
		_tmp144 = FALSE;
		if (vala_formal_parameter_get_params_array (param)) {
			_tmp144 = TRUE;
		} else {
			_tmp144 = vala_formal_parameter_get_ellipsis (param);
		}
		/* if there are more parameters than arguments,
		 * the additional parameter is an ellipsis parameter
		 * otherwise there is a bug in the semantic analyzer
		 */
		g_assert (_tmp144);
		ellipsis = TRUE;
		(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
	}
	_tmp145 = FALSE;
	if (m != NULL) {
		_tmp145 = VALA_IS_ARRAY_TYPE (vala_method_get_return_type (m));
	} else {
		_tmp145 = FALSE;
	}
	/* add length argument for methods returning arrays */
	if (_tmp145) {
		ValaArrayType* _tmp146;
		ValaArrayType* array_type;
		_tmp146 = NULL;
		array_type = (_tmp146 = VALA_ARRAY_TYPE (vala_method_get_return_type (m)), (_tmp146 == NULL) ? NULL : vala_code_node_ref (_tmp146));
		{
			gint dim;
			dim = 1;
			for (; dim <= vala_array_type_get_rank (array_type); dim++) {
				if (!vala_method_get_no_array_length (m)) {
					ValaLocalVariable* temp_var;
					ValaCCodeIdentifier* temp_ref;
					ValaCCodeUnaryExpression* _tmp147;
					temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->int_type, TRUE, NULL);
					temp_ref = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var));
					gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
					_tmp147 = NULL;
					gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_carray_length_parameter_position (m) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) (_tmp147 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) temp_ref)));
					(_tmp147 == NULL) ? NULL : (_tmp147 = (vala_ccode_node_unref (_tmp147), NULL));
					vala_method_call_append_array_size (expr, (ValaCCodeExpression*) temp_ref);
					(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
					(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
				} else {
					ValaCCodeConstant* _tmp148;
					_tmp148 = NULL;
					vala_method_call_append_array_size (expr, (ValaCCodeExpression*) (_tmp148 = vala_ccode_constant_new ("-1")));
					(_tmp148 == NULL) ? NULL : (_tmp148 = (vala_ccode_node_unref (_tmp148), NULL));
				}
			}
		}
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	} else {
		gboolean _tmp149;
		_tmp149 = FALSE;
		if (m != NULL) {
			_tmp149 = VALA_IS_DELEGATE_TYPE (vala_method_get_return_type (m));
		} else {
			_tmp149 = FALSE;
		}
		if (_tmp149) {
			ValaDelegateType* _tmp150;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp151;
			ValaDelegate* d;
			_tmp150 = NULL;
			deleg_type = (_tmp150 = VALA_DELEGATE_TYPE (vala_method_get_return_type (m)), (_tmp150 == NULL) ? NULL : vala_code_node_ref (_tmp150));
			_tmp151 = NULL;
			d = (_tmp151 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp151 == NULL) ? NULL : vala_code_node_ref (_tmp151));
			if (vala_delegate_get_has_target (d)) {
				ValaPointerType* _tmp153;
				ValaVoidType* _tmp152;
				ValaLocalVariable* _tmp154;
				ValaLocalVariable* temp_var;
				ValaCCodeIdentifier* temp_ref;
				ValaCCodeUnaryExpression* _tmp155;
				_tmp153 = NULL;
				_tmp152 = NULL;
				_tmp154 = NULL;
				temp_var = (_tmp154 = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) (_tmp153 = vala_pointer_type_new ((ValaDataType*) (_tmp152 = vala_void_type_new ()), NULL)), TRUE, NULL), (_tmp153 == NULL) ? NULL : (_tmp153 = (vala_code_node_unref (_tmp153), NULL)), (_tmp152 == NULL) ? NULL : (_tmp152 = (vala_code_node_unref (_tmp152), NULL)), _tmp154);
				temp_ref = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var));
				gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
				_tmp155 = NULL;
				gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cdelegate_target_parameter_position (m), FALSE)), (ValaCCodeExpression*) (_tmp155 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) temp_ref)));
				(_tmp155 == NULL) ? NULL : (_tmp155 = (vala_ccode_node_unref (_tmp155), NULL));
				vala_method_call_set_delegate_target (expr, (ValaCCodeExpression*) temp_ref);
				(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
				(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
			}
			(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
			(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
		}
	}
	_tmp156 = FALSE;
	if (m != NULL) {
		_tmp156 = vala_method_get_coroutine (m);
	} else {
		_tmp156 = FALSE;
	}
	if (_tmp156) {
		gboolean _tmp157;
		gboolean _tmp158;
		_tmp157 = FALSE;
		_tmp158 = FALSE;
		if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
			_tmp158 = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
		} else {
			_tmp158 = FALSE;
		}
		if ((_tmp158)) {
			_tmp157 = TRUE;
		} else {
			gboolean _tmp159;
			_tmp159 = FALSE;
			if (_vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") == 0) {
				_tmp159 = vala_expression_get_symbol_reference (vala_member_access_get_inner (ma)) == vala_expression_get_symbol_reference ((ValaExpression*) ma);
			} else {
				_tmp159 = FALSE;
			}
			_tmp157 = (_tmp159);
		}
		if (_tmp157) {
			ValaCCodeIdentifier* _tmp160;
			ValaCCodeIdentifier* cid;
			char* _tmp161;
			gboolean _tmp162;
			/* asynchronous call*/
			_tmp160 = NULL;
			cid = (_tmp160 = VALA_CCODE_IDENTIFIER (vala_ccode_function_call_get_call (ccall)), (_tmp160 == NULL) ? NULL : vala_ccode_node_ref (_tmp160));
			_tmp161 = NULL;
			vala_ccode_identifier_set_name (cid, _tmp161 = g_strconcat (vala_ccode_identifier_get_name (cid), ("_async"), NULL));
			_tmp161 = (g_free (_tmp161), NULL);
			_tmp162 = FALSE;
			if (_vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") == 0) {
				_tmp162 = vala_expression_get_symbol_reference (vala_member_access_get_inner (ma)) == vala_expression_get_symbol_reference ((ValaExpression*) ma);
			} else {
				_tmp162 = FALSE;
			}
			if (_tmp162) {
				ValaCCodeConstant* _tmp163;
				ValaCCodeConstant* _tmp164;
				_tmp163 = NULL;
				gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp163 = vala_ccode_constant_new ("NULL")));
				(_tmp163 == NULL) ? NULL : (_tmp163 = (vala_ccode_node_unref (_tmp163), NULL));
				_tmp164 = NULL;
				gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) (_tmp164 = vala_ccode_constant_new ("NULL")));
				(_tmp164 == NULL) ? NULL : (_tmp164 = (vala_ccode_node_unref (_tmp164), NULL));
			} else {
				ValaCCodeIdentifier* _tmp167;
				char* _tmp166;
				char* _tmp165;
				ValaCCodeIdentifier* _tmp168;
				_tmp167 = NULL;
				_tmp166 = NULL;
				_tmp165 = NULL;
				gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp167 = vala_ccode_identifier_new (_tmp166 = g_strconcat (_tmp165 = vala_method_get_cname (((ValaCCodeBaseModule*) self)->current_method), "_ready", NULL))));
				(_tmp167 == NULL) ? NULL : (_tmp167 = (vala_ccode_node_unref (_tmp167), NULL));
				_tmp166 = (g_free (_tmp166), NULL);
				_tmp165 = (g_free (_tmp165), NULL);
				_tmp168 = NULL;
				gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) (_tmp168 = vala_ccode_identifier_new ("data")));
				(_tmp168 == NULL) ? NULL : (_tmp168 = (vala_ccode_node_unref (_tmp168), NULL));
			}
			(cid == NULL) ? NULL : (cid = (vala_ccode_node_unref (cid), NULL));
		}
	}
	if (vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr)) {
		ValaCCodeUnaryExpression* _tmp170;
		ValaCCodeIdentifier* _tmp169;
		/* method can fail*/
		((ValaCCodeBaseModule*) self)->current_method_inner_error = TRUE;
		/* add &inner_error before the ellipsis arguments*/
		_tmp170 = NULL;
		_tmp169 = NULL;
		gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp170 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp169 = vala_ccode_identifier_new ("inner_error")))));
		(_tmp170 == NULL) ? NULL : (_tmp170 = (vala_ccode_node_unref (_tmp170), NULL));
		(_tmp169 == NULL) ? NULL : (_tmp169 = (vala_ccode_node_unref (_tmp169), NULL));
	}
	if (ellipsis) {
		gboolean _tmp171;
		_tmp171 = FALSE;
		if (!vala_method_get_printf_format (m)) {
			_tmp171 = _vala_strcmp0 (vala_method_get_sentinel (m), "") != 0;
		} else {
			_tmp171 = FALSE;
		}
		/* ensure variable argument list ends with NULL
		 * except when using printf-style arguments */
		if (_tmp171) {
			ValaCCodeConstant* _tmp172;
			_tmp172 = NULL;
			gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), TRUE)), (ValaCCodeExpression*) (_tmp172 = vala_ccode_constant_new (vala_method_get_sentinel (m))));
			(_tmp172 == NULL) ? NULL : (_tmp172 = (vala_ccode_node_unref (_tmp172), NULL));
		}
	} else {
		if (VALA_IS_DELEGATE_TYPE (itype)) {
			ValaDelegateType* _tmp173;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp174;
			ValaDelegate* d;
			_tmp173 = NULL;
			deleg_type = (_tmp173 = VALA_DELEGATE_TYPE (itype), (_tmp173 == NULL) ? NULL : vala_code_node_ref (_tmp173));
			_tmp174 = NULL;
			d = (_tmp174 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp174 == NULL) ? NULL : vala_code_node_ref (_tmp174));
			if (vala_delegate_get_has_target (d)) {
				ValaCCodeExpression* _tmp175;
				_tmp175 = NULL;
				gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_delegate_get_cinstance_parameter_position (d), FALSE)), _tmp175 = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, vala_method_call_get_call (expr)));
				(_tmp175 == NULL) ? NULL : (_tmp175 = (vala_ccode_node_unref (_tmp175), NULL));
			}
			(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
			(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
		}
	}
	_tmp176 = FALSE;
	if (VALA_IS_SIGNAL_TYPE (itype)) {
		ValaDataType* _tmp177;
		_tmp177 = NULL;
		_tmp176 = !(VALA_IS_VOID_TYPE (_tmp177 = vala_data_type_get_return_type (itype)));
		(_tmp177 == NULL) ? NULL : (_tmp177 = (vala_code_node_unref (_tmp177), NULL));
	} else {
		_tmp176 = FALSE;
	}
	/* pass address for the return value of non-void signals without emitter functions*/
	if (_tmp176) {
		ValaSignal* _tmp178;
		ValaSignal* sig;
		gboolean _tmp179;
		gboolean _tmp180;
		_tmp178 = NULL;
		sig = (_tmp178 = vala_signal_type_get_signal_symbol ((VALA_SIGNAL_TYPE (itype))), (_tmp178 == NULL) ? NULL : vala_code_node_ref (_tmp178));
		_tmp179 = FALSE;
		_tmp180 = FALSE;
		if (ma != NULL) {
			_tmp180 = VALA_IS_BASE_ACCESS (vala_member_access_get_inner (ma));
		} else {
			_tmp180 = FALSE;
		}
		if (_tmp180) {
			_tmp179 = vala_signal_get_is_virtual (sig);
		} else {
			_tmp179 = FALSE;
		}
		if (_tmp179) {
		} else {
			if (!vala_signal_get_has_emitter (sig)) {
				ValaDataType* _tmp181;
				ValaLocalVariable* _tmp182;
				ValaLocalVariable* temp_var;
				ValaCCodeIdentifier* temp_ref;
				ValaCCodeUnaryExpression* _tmp183;
				ValaCCodeCommaExpression* ccomma;
				ValaCCodeExpression* _tmp185;
				ValaCCodeExpression* _tmp184;
				_tmp181 = NULL;
				_tmp182 = NULL;
				temp_var = (_tmp182 = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp181 = vala_data_type_get_return_type (itype), TRUE, NULL), (_tmp181 == NULL) ? NULL : (_tmp181 = (vala_code_node_unref (_tmp181), NULL)), _tmp182);
				temp_ref = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var));
				gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
				_tmp183 = NULL;
				gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), TRUE)), (ValaCCodeExpression*) (_tmp183 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) temp_ref)));
				(_tmp183 == NULL) ? NULL : (_tmp183 = (vala_ccode_node_unref (_tmp183), NULL));
				ccomma = vala_ccode_comma_expression_new ();
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall_expr));
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (temp_ref));
				_tmp185 = NULL;
				_tmp184 = NULL;
				ccall_expr = (_tmp185 = (_tmp184 = (ValaCCodeExpression*) ccomma, (_tmp184 == NULL) ? NULL : vala_ccode_node_ref (_tmp184)), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp185);
				(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
				(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
				(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
			}
		}
		(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
	}
	/* append C arguments in the right order*/
	last_pos = -1;
	min_pos = 0;
	while (TRUE) {
		ValaCCodeExpression* _tmp190;
		min_pos = -1;
		{
			GeeSet* _tmp186;
			GeeIterator* _tmp187;
			GeeIterator* _pos_it;
			_tmp186 = NULL;
			_tmp187 = NULL;
			_pos_it = (_tmp187 = gee_iterable_iterator ((GeeIterable*) (_tmp186 = gee_map_get_keys ((GeeMap*) carg_map))), (_tmp186 == NULL) ? NULL : (_tmp186 = (gee_collection_object_unref (_tmp186), NULL)), _tmp187);
			while (gee_iterator_next (_pos_it)) {
				gint pos;
				gboolean _tmp188;
				pos = GPOINTER_TO_INT (gee_iterator_get (_pos_it));
				_tmp188 = FALSE;
				if (pos > last_pos) {
					gboolean _tmp189;
					_tmp189 = FALSE;
					if (min_pos == (-1)) {
						_tmp189 = TRUE;
					} else {
						_tmp189 = pos < min_pos;
					}
					_tmp188 = (_tmp189);
				} else {
					_tmp188 = FALSE;
				}
				if (_tmp188) {
					min_pos = pos;
				}
			}
			(_pos_it == NULL) ? NULL : (_pos_it = (gee_collection_object_unref (_pos_it), NULL));
		}
		if (min_pos == (-1)) {
			break;
		}
		_tmp190 = NULL;
		vala_ccode_function_call_add_argument (ccall, _tmp190 = (ValaCCodeExpression*) gee_map_get ((GeeMap*) carg_map, GINT_TO_POINTER (min_pos)));
		(_tmp190 == NULL) ? NULL : (_tmp190 = (vala_ccode_node_unref (_tmp190), NULL));
		last_pos = min_pos;
	}
	_tmp191 = FALSE;
	_tmp192 = FALSE;
	if (m != NULL) {
		_tmp192 = vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE;
	} else {
		_tmp192 = FALSE;
	}
	if (_tmp192) {
		_tmp191 = vala_method_get_returns_modified_pointer (m);
	} else {
		_tmp191 = FALSE;
	}
	if (_tmp191) {
		ValaCCodeAssignment* _tmp193;
		_tmp193 = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp193 = vala_ccode_assignment_new (instance, ccall_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		(_tmp193 == NULL) ? NULL : (_tmp193 = (vala_ccode_node_unref (_tmp193), NULL));
	} else {
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall_expr);
	}
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		GeeList* _tmp194;
		GeeIterator* _tmp195;
		GeeIterator* arg_it;
		ValaCCodeExpression* _tmp197;
		ValaExpression* _tmp196;
		ValaCCodeExpression* _tmp198;
		ValaCCodeExpression* new_size;
		ValaLocalVariable* temp_decl;
		ValaCCodeIdentifier* temp_ref;
		ValaCCodeExpression* clen;
		ValaCCodeExpression* _tmp199;
		ValaCCodeExpression* celems;
		ValaArrayType* _tmp200;
		ValaArrayType* array_type;
		char* _tmp202;
		char* _tmp201;
		ValaCCodeIdentifier* _tmp203;
		ValaCCodeIdentifier* csizeof;
		ValaCCodeBinaryExpression* cdelta;
		ValaCCodeBinaryExpression* ccheck;
		ValaCCodeIdentifier* _tmp204;
		ValaCCodeFunctionCall* _tmp205;
		ValaCCodeFunctionCall* czero;
		ValaCCodeBinaryExpression* _tmp206;
		ValaCCodeConstant* _tmp207;
		ValaCCodeBinaryExpression* _tmp208;
		ValaCCodeCommaExpression* ccomma;
		ValaCCodeAssignment* _tmp209;
		ValaCCodeConditionalExpression* _tmp211;
		ValaCCodeConstant* _tmp210;
		ValaCCodeAssignment* _tmp213;
		ValaCCodeExpression* _tmp212;
		/* FIXME: size expression must not be evaluated twice at runtime (potential side effects)*/
		_tmp194 = NULL;
		_tmp195 = NULL;
		arg_it = (_tmp195 = gee_iterable_iterator ((GeeIterable*) (_tmp194 = vala_method_call_get_argument_list (expr))), (_tmp194 == NULL) ? NULL : (_tmp194 = (gee_collection_object_unref (_tmp194), NULL)), _tmp195);
		gee_iterator_next (arg_it);
		_tmp197 = NULL;
		_tmp196 = NULL;
		_tmp198 = NULL;
		new_size = (_tmp198 = (_tmp197 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) (_tmp196 = (ValaExpression*) gee_iterator_get (arg_it)))), (_tmp197 == NULL) ? NULL : vala_ccode_node_ref (_tmp197)), (_tmp196 == NULL) ? NULL : (_tmp196 = (vala_code_node_unref (_tmp196), NULL)), _tmp198);
		temp_decl = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->int_type, TRUE, NULL);
		temp_ref = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_decl));
		gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_decl);
		/* memset needs string.h */
		((ValaCCodeBaseModule*) self)->string_h_needed = TRUE;
		clen = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_member_access_get_inner (ma), 1);
		_tmp199 = NULL;
		celems = (_tmp199 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (ma))), (_tmp199 == NULL) ? NULL : vala_ccode_node_ref (_tmp199));
		_tmp200 = NULL;
		array_type = (_tmp200 = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (ma))), (_tmp200 == NULL) ? NULL : vala_code_node_ref (_tmp200));
		_tmp202 = NULL;
		_tmp201 = NULL;
		_tmp203 = NULL;
		csizeof = (_tmp203 = vala_ccode_identifier_new (_tmp202 = g_strdup_printf ("sizeof (%s)", _tmp201 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))), _tmp202 = (g_free (_tmp202), NULL), _tmp201 = (g_free (_tmp201), NULL), _tmp203);
		cdelta = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, (ValaCCodeExpression*) temp_ref, clen);
		ccheck = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, (ValaCCodeExpression*) temp_ref, clen);
		_tmp204 = NULL;
		_tmp205 = NULL;
		czero = (_tmp205 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp204 = vala_ccode_identifier_new ("memset"))), (_tmp204 == NULL) ? NULL : (_tmp204 = (vala_ccode_node_unref (_tmp204), NULL)), _tmp205);
		_tmp206 = NULL;
		vala_ccode_function_call_add_argument (czero, (ValaCCodeExpression*) (_tmp206 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, celems, clen)));
		(_tmp206 == NULL) ? NULL : (_tmp206 = (vala_ccode_node_unref (_tmp206), NULL));
		_tmp207 = NULL;
		vala_ccode_function_call_add_argument (czero, (ValaCCodeExpression*) (_tmp207 = vala_ccode_constant_new ("0")));
		(_tmp207 == NULL) ? NULL : (_tmp207 = (vala_ccode_node_unref (_tmp207), NULL));
		_tmp208 = NULL;
		vala_ccode_function_call_add_argument (czero, (ValaCCodeExpression*) (_tmp208 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) csizeof, (ValaCCodeExpression*) cdelta)));
		(_tmp208 == NULL) ? NULL : (_tmp208 = (vala_ccode_node_unref (_tmp208), NULL));
		ccomma = vala_ccode_comma_expression_new ();
		_tmp209 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp209 = vala_ccode_assignment_new ((ValaCCodeExpression*) temp_ref, new_size, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		(_tmp209 == NULL) ? NULL : (_tmp209 = (vala_ccode_node_unref (_tmp209), NULL));
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) expr)));
		_tmp211 = NULL;
		_tmp210 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp211 = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) ccheck, (ValaCCodeExpression*) czero, (ValaCCodeExpression*) (_tmp210 = vala_ccode_constant_new ("NULL")))));
		(_tmp211 == NULL) ? NULL : (_tmp211 = (vala_ccode_node_unref (_tmp211), NULL));
		(_tmp210 == NULL) ? NULL : (_tmp210 = (vala_ccode_node_unref (_tmp210), NULL));
		_tmp213 = NULL;
		_tmp212 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp213 = vala_ccode_assignment_new (_tmp212 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_member_access_get_inner (ma), 1), (ValaCCodeExpression*) temp_ref, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		(_tmp213 == NULL) ? NULL : (_tmp213 = (vala_ccode_node_unref (_tmp213), NULL));
		(_tmp212 == NULL) ? NULL : (_tmp212 = (vala_ccode_node_unref (_tmp212), NULL));
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccomma);
		(arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL));
		(new_size == NULL) ? NULL : (new_size = (vala_ccode_node_unref (new_size), NULL));
		(temp_decl == NULL) ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL));
		(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
		(clen == NULL) ? NULL : (clen = (vala_ccode_node_unref (clen), NULL));
		(celems == NULL) ? NULL : (celems = (vala_ccode_node_unref (celems), NULL));
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		(csizeof == NULL) ? NULL : (csizeof = (vala_ccode_node_unref (csizeof), NULL));
		(cdelta == NULL) ? NULL : (cdelta = (vala_ccode_node_unref (cdelta), NULL));
		(ccheck == NULL) ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL));
		(czero == NULL) ? NULL : (czero = (vala_ccode_node_unref (czero), NULL));
		(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
	}
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
	(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
	(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
	(itype == NULL) ? NULL : (itype = (vala_code_node_unref (itype), NULL));
	(ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL));
	(carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL));
	(instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL));
	(params_it == NULL) ? NULL : (params_it = (gee_collection_object_unref (params_it), NULL));
}


static void vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass) {
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->visit_method_call = vala_ccode_method_call_module_real_visit_method_call;
}


static void vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self) {
}


GType vala_ccode_method_call_module_get_type (void) {
	static GType vala_ccode_method_call_module_type_id = 0;
	if (vala_ccode_method_call_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
		vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
	}
	return vala_ccode_method_call_module_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




