/* valaccodemodule.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __GOBJECT_VALACCODEMODULE_H__
#define __GOBJECT_VALACCODEMODULE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodeexpression.h>
#include <vala/valaexpression.h>
#include <vala/valadynamicsignal.h>
#include <vala/valacodenode.h>
#include <ccode/valaccodefragment.h>
#include <ccode/valaccodefunctioncall.h>
#include <vala/valaproperty.h>
#include <vala/valasignal.h>
#include <vala/valatypesymbol.h>
#include <vala/valaobjecttypesymbol.h>
#include <ccode/valaccodeidentifier.h>
#include <vala/valadatatype.h>
#include <vala/valadynamicproperty.h>
#include <gee/list.h>
#include <ccode/valaccodeconstant.h>
#include <vala/valamethod.h>
#include <vala/valadynamicmethod.h>
#include <vala/valacodecontext.h>
#include <vala/valasourcefile.h>
#include <vala/valaclass.h>
#include <vala/valainterface.h>
#include <vala/valastruct.h>
#include <vala/valaenum.h>
#include <vala/valaenumvalue.h>
#include <vala/valaerrordomain.h>
#include <vala/valaerrorcode.h>
#include <vala/valadelegate.h>
#include <vala/valamember.h>
#include <vala/valaconstant.h>
#include <vala/valafield.h>
#include <vala/valacreationmethod.h>
#include <vala/valaformalparameter.h>
#include <vala/valapropertyaccessor.h>
#include <vala/valaconstructor.h>
#include <vala/valadestructor.h>
#include <vala/valablock.h>
#include <vala/valaemptystatement.h>
#include <vala/valadeclarationstatement.h>
#include <vala/valalocalvariable.h>
#include <vala/valainitializerlist.h>
#include <vala/valaexpressionstatement.h>
#include <vala/valaifstatement.h>
#include <vala/valaswitchstatement.h>
#include <vala/valaswitchsection.h>
#include <vala/valaswitchlabel.h>
#include <vala/valawhilestatement.h>
#include <vala/valadostatement.h>
#include <vala/valaforstatement.h>
#include <vala/valaforeachstatement.h>
#include <vala/valabreakstatement.h>
#include <vala/valacontinuestatement.h>
#include <vala/valareturnstatement.h>
#include <vala/valayieldstatement.h>
#include <vala/valathrowstatement.h>
#include <vala/valatrystatement.h>
#include <vala/valacatchclause.h>
#include <vala/valalockstatement.h>
#include <vala/valadeletestatement.h>
#include <vala/valaarraycreationexpression.h>
#include <vala/valabooleanliteral.h>
#include <vala/valacharacterliteral.h>
#include <vala/valaintegerliteral.h>
#include <vala/valarealliteral.h>
#include <vala/valastringliteral.h>
#include <vala/valanullliteral.h>
#include <vala/valaparenthesizedexpression.h>
#include <vala/valamemberaccess.h>
#include <vala/valamethodcall.h>
#include <vala/valaelementaccess.h>
#include <vala/valabaseaccess.h>
#include <vala/valapostfixexpression.h>
#include <vala/valaobjectcreationexpression.h>
#include <vala/valasizeofexpression.h>
#include <vala/valatypeofexpression.h>
#include <vala/valaunaryexpression.h>
#include <vala/valacastexpression.h>
#include <vala/valapointerindirection.h>
#include <vala/valaaddressofexpression.h>
#include <vala/valareferencetransferexpression.h>
#include <vala/valabinaryexpression.h>
#include <vala/valatypecheck.h>
#include <vala/valalambdaexpression.h>
#include <vala/valaassignment.h>
#include <gee/map.h>
#include <ccode/valaccodefunction.h>
#include <ccode/valaccodefunctiondeclarator.h>
#include <gobject/valaccodegenerator.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_MODULE (vala_ccode_module_get_type ())
#define VALA_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModule))
#define VALA_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))
#define VALA_IS_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MODULE))
#define VALA_IS_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MODULE))
#define VALA_CCODE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))

typedef struct _ValaCCodeModulePrivate ValaCCodeModulePrivate;
typedef struct _ValaParamSpecCCodeModule ValaParamSpecCCodeModule;

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeModule {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeModulePrivate * priv;
};

struct _ValaCCodeModuleClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeModule *self);
	void (*emit) (ValaCCodeModule* self, ValaCodeContext* context);
	void (*visit_source_file) (ValaCCodeModule* self, ValaSourceFile* source_file);
	void (*visit_class) (ValaCCodeModule* self, ValaClass* cl);
	void (*visit_interface) (ValaCCodeModule* self, ValaInterface* iface);
	void (*visit_struct) (ValaCCodeModule* self, ValaStruct* st);
	void (*visit_enum) (ValaCCodeModule* self, ValaEnum* en);
	void (*visit_enum_value) (ValaCCodeModule* self, ValaEnumValue* ev);
	void (*visit_error_domain) (ValaCCodeModule* self, ValaErrorDomain* edomain);
	void (*visit_error_code) (ValaCCodeModule* self, ValaErrorCode* ecode);
	void (*visit_delegate) (ValaCCodeModule* self, ValaDelegate* d);
	void (*visit_member) (ValaCCodeModule* self, ValaMember* m);
	void (*visit_constant) (ValaCCodeModule* self, ValaConstant* c);
	void (*visit_field) (ValaCCodeModule* self, ValaField* f);
	void (*visit_method) (ValaCCodeModule* self, ValaMethod* m);
	void (*visit_creation_method) (ValaCCodeModule* self, ValaCreationMethod* m);
	void (*visit_formal_parameter) (ValaCCodeModule* self, ValaFormalParameter* p);
	void (*visit_property) (ValaCCodeModule* self, ValaProperty* prop);
	void (*visit_property_accessor) (ValaCCodeModule* self, ValaPropertyAccessor* acc);
	void (*visit_signal) (ValaCCodeModule* self, ValaSignal* sig);
	void (*visit_constructor) (ValaCCodeModule* self, ValaConstructor* c);
	void (*visit_destructor) (ValaCCodeModule* self, ValaDestructor* d);
	void (*visit_block) (ValaCCodeModule* self, ValaBlock* b);
	void (*visit_empty_statement) (ValaCCodeModule* self, ValaEmptyStatement* stmt);
	void (*visit_declaration_statement) (ValaCCodeModule* self, ValaDeclarationStatement* stmt);
	void (*visit_local_variable) (ValaCCodeModule* self, ValaLocalVariable* local);
	void (*visit_initializer_list) (ValaCCodeModule* self, ValaInitializerList* list);
	void (*visit_end_full_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_expression_statement) (ValaCCodeModule* self, ValaExpressionStatement* stmt);
	void (*visit_if_statement) (ValaCCodeModule* self, ValaIfStatement* stmt);
	void (*visit_switch_statement) (ValaCCodeModule* self, ValaSwitchStatement* stmt);
	void (*visit_switch_section) (ValaCCodeModule* self, ValaSwitchSection* section);
	void (*visit_switch_label) (ValaCCodeModule* self, ValaSwitchLabel* label);
	void (*visit_while_statement) (ValaCCodeModule* self, ValaWhileStatement* stmt);
	void (*visit_do_statement) (ValaCCodeModule* self, ValaDoStatement* stmt);
	void (*visit_for_statement) (ValaCCodeModule* self, ValaForStatement* stmt);
	void (*visit_foreach_statement) (ValaCCodeModule* self, ValaForeachStatement* stmt);
	void (*visit_break_statement) (ValaCCodeModule* self, ValaBreakStatement* stmt);
	void (*visit_continue_statement) (ValaCCodeModule* self, ValaContinueStatement* stmt);
	void (*visit_return_statement) (ValaCCodeModule* self, ValaReturnStatement* stmt);
	void (*visit_yield_statement) (ValaCCodeModule* self, ValaYieldStatement* stmt);
	void (*visit_throw_statement) (ValaCCodeModule* self, ValaThrowStatement* stmt);
	void (*visit_try_statement) (ValaCCodeModule* self, ValaTryStatement* stmt);
	void (*visit_catch_clause) (ValaCCodeModule* self, ValaCatchClause* clause);
	void (*visit_lock_statement) (ValaCCodeModule* self, ValaLockStatement* stmt);
	void (*visit_delete_statement) (ValaCCodeModule* self, ValaDeleteStatement* stmt);
	void (*visit_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_array_creation_expression) (ValaCCodeModule* self, ValaArrayCreationExpression* expr);
	void (*visit_boolean_literal) (ValaCCodeModule* self, ValaBooleanLiteral* expr);
	void (*visit_character_literal) (ValaCCodeModule* self, ValaCharacterLiteral* expr);
	void (*visit_integer_literal) (ValaCCodeModule* self, ValaIntegerLiteral* expr);
	void (*visit_real_literal) (ValaCCodeModule* self, ValaRealLiteral* expr);
	void (*visit_string_literal) (ValaCCodeModule* self, ValaStringLiteral* expr);
	void (*visit_null_literal) (ValaCCodeModule* self, ValaNullLiteral* expr);
	void (*visit_parenthesized_expression) (ValaCCodeModule* self, ValaParenthesizedExpression* expr);
	void (*visit_member_access) (ValaCCodeModule* self, ValaMemberAccess* expr);
	void (*visit_method_call) (ValaCCodeModule* self, ValaMethodCall* expr);
	void (*visit_element_access) (ValaCCodeModule* self, ValaElementAccess* expr);
	void (*visit_base_access) (ValaCCodeModule* self, ValaBaseAccess* expr);
	void (*visit_postfix_expression) (ValaCCodeModule* self, ValaPostfixExpression* expr);
	void (*visit_object_creation_expression) (ValaCCodeModule* self, ValaObjectCreationExpression* expr);
	void (*visit_sizeof_expression) (ValaCCodeModule* self, ValaSizeofExpression* expr);
	void (*visit_typeof_expression) (ValaCCodeModule* self, ValaTypeofExpression* expr);
	void (*visit_unary_expression) (ValaCCodeModule* self, ValaUnaryExpression* expr);
	void (*visit_cast_expression) (ValaCCodeModule* self, ValaCastExpression* expr);
	void (*visit_pointer_indirection) (ValaCCodeModule* self, ValaPointerIndirection* expr);
	void (*visit_addressof_expression) (ValaCCodeModule* self, ValaAddressofExpression* expr);
	void (*visit_reference_transfer_expression) (ValaCCodeModule* self, ValaReferenceTransferExpression* expr);
	void (*visit_binary_expression) (ValaCCodeModule* self, ValaBinaryExpression* expr);
	void (*visit_type_check) (ValaCCodeModule* self, ValaTypeCheck* expr);
	void (*visit_lambda_expression) (ValaCCodeModule* self, ValaLambdaExpression* l);
	void (*visit_assignment) (ValaCCodeModule* self, ValaAssignment* a);
	void (*generate_cparameters) (ValaCCodeModule* self, ValaMethod* m, ValaDataType* creturn_type, gboolean in_gtypeinstance_creation_method, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
	char* (*get_custom_creturn_type) (ValaCCodeModule* self, ValaMethod* m);
	void (*generate_dynamic_method_wrapper) (ValaCCodeModule* self, ValaDynamicMethod* method);
	gboolean (*method_has_wrapper) (ValaCCodeModule* self, ValaMethod* method);
	ValaCCodeIdentifier* (*get_value_setter_function) (ValaCCodeModule* self, ValaDataType* type_reference);
	ValaCCodeExpression* (*get_construct_property_assignment) (ValaCCodeModule* self, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value);
	ValaCCodeFunctionCall* (*get_param_spec) (ValaCCodeModule* self, ValaProperty* prop);
	ValaCCodeFunctionCall* (*get_signal_creation) (ValaCCodeModule* self, ValaSignal* sig, ValaTypeSymbol* type);
	ValaCCodeFragment* (*register_dbus_info) (ValaCCodeModule* self, ValaObjectTypeSymbol* bindable);
	char* (*get_dynamic_property_getter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_property_setter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_signal_cname) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_connect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_disconnect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	void (*generate_marshaller) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, gboolean dbus);
	char* (*get_marshaller_function) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, const char* prefix, gboolean dbus);
	char* (*get_array_length_cname) (ValaCCodeModule* self, const char* array_cname, gint dim);
	ValaCCodeExpression* (*get_array_length_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
	void (*add_simple_check) (ValaCCodeModule* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
};

struct _ValaParamSpecCCodeModule {
	GParamSpec parent_instance;
};


ValaCCodeModule* vala_ccode_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeModule* vala_ccode_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
void vala_ccode_module_emit (ValaCCodeModule* self, ValaCodeContext* context);
void vala_ccode_module_visit_source_file (ValaCCodeModule* self, ValaSourceFile* source_file);
void vala_ccode_module_visit_class (ValaCCodeModule* self, ValaClass* cl);
void vala_ccode_module_visit_interface (ValaCCodeModule* self, ValaInterface* iface);
void vala_ccode_module_visit_struct (ValaCCodeModule* self, ValaStruct* st);
void vala_ccode_module_visit_enum (ValaCCodeModule* self, ValaEnum* en);
void vala_ccode_module_visit_enum_value (ValaCCodeModule* self, ValaEnumValue* ev);
void vala_ccode_module_visit_error_domain (ValaCCodeModule* self, ValaErrorDomain* edomain);
void vala_ccode_module_visit_error_code (ValaCCodeModule* self, ValaErrorCode* ecode);
void vala_ccode_module_visit_delegate (ValaCCodeModule* self, ValaDelegate* d);
void vala_ccode_module_visit_member (ValaCCodeModule* self, ValaMember* m);
void vala_ccode_module_visit_constant (ValaCCodeModule* self, ValaConstant* c);
void vala_ccode_module_visit_field (ValaCCodeModule* self, ValaField* f);
void vala_ccode_module_visit_method (ValaCCodeModule* self, ValaMethod* m);
void vala_ccode_module_visit_creation_method (ValaCCodeModule* self, ValaCreationMethod* m);
void vala_ccode_module_visit_formal_parameter (ValaCCodeModule* self, ValaFormalParameter* p);
void vala_ccode_module_visit_property (ValaCCodeModule* self, ValaProperty* prop);
void vala_ccode_module_visit_property_accessor (ValaCCodeModule* self, ValaPropertyAccessor* acc);
void vala_ccode_module_visit_signal (ValaCCodeModule* self, ValaSignal* sig);
void vala_ccode_module_visit_constructor (ValaCCodeModule* self, ValaConstructor* c);
void vala_ccode_module_visit_destructor (ValaCCodeModule* self, ValaDestructor* d);
void vala_ccode_module_visit_block (ValaCCodeModule* self, ValaBlock* b);
void vala_ccode_module_visit_empty_statement (ValaCCodeModule* self, ValaEmptyStatement* stmt);
void vala_ccode_module_visit_declaration_statement (ValaCCodeModule* self, ValaDeclarationStatement* stmt);
void vala_ccode_module_visit_local_variable (ValaCCodeModule* self, ValaLocalVariable* local);
void vala_ccode_module_visit_initializer_list (ValaCCodeModule* self, ValaInitializerList* list);
void vala_ccode_module_visit_end_full_expression (ValaCCodeModule* self, ValaExpression* expr);
void vala_ccode_module_visit_expression_statement (ValaCCodeModule* self, ValaExpressionStatement* stmt);
void vala_ccode_module_visit_if_statement (ValaCCodeModule* self, ValaIfStatement* stmt);
void vala_ccode_module_visit_switch_statement (ValaCCodeModule* self, ValaSwitchStatement* stmt);
void vala_ccode_module_visit_switch_section (ValaCCodeModule* self, ValaSwitchSection* section);
void vala_ccode_module_visit_switch_label (ValaCCodeModule* self, ValaSwitchLabel* label);
void vala_ccode_module_visit_while_statement (ValaCCodeModule* self, ValaWhileStatement* stmt);
void vala_ccode_module_visit_do_statement (ValaCCodeModule* self, ValaDoStatement* stmt);
void vala_ccode_module_visit_for_statement (ValaCCodeModule* self, ValaForStatement* stmt);
void vala_ccode_module_visit_foreach_statement (ValaCCodeModule* self, ValaForeachStatement* stmt);
void vala_ccode_module_visit_break_statement (ValaCCodeModule* self, ValaBreakStatement* stmt);
void vala_ccode_module_visit_continue_statement (ValaCCodeModule* self, ValaContinueStatement* stmt);
void vala_ccode_module_visit_return_statement (ValaCCodeModule* self, ValaReturnStatement* stmt);
void vala_ccode_module_visit_yield_statement (ValaCCodeModule* self, ValaYieldStatement* stmt);
void vala_ccode_module_visit_throw_statement (ValaCCodeModule* self, ValaThrowStatement* stmt);
void vala_ccode_module_visit_try_statement (ValaCCodeModule* self, ValaTryStatement* stmt);
void vala_ccode_module_visit_catch_clause (ValaCCodeModule* self, ValaCatchClause* clause);
void vala_ccode_module_visit_lock_statement (ValaCCodeModule* self, ValaLockStatement* stmt);
void vala_ccode_module_visit_delete_statement (ValaCCodeModule* self, ValaDeleteStatement* stmt);
void vala_ccode_module_visit_expression (ValaCCodeModule* self, ValaExpression* expr);
void vala_ccode_module_visit_array_creation_expression (ValaCCodeModule* self, ValaArrayCreationExpression* expr);
void vala_ccode_module_visit_boolean_literal (ValaCCodeModule* self, ValaBooleanLiteral* expr);
void vala_ccode_module_visit_character_literal (ValaCCodeModule* self, ValaCharacterLiteral* expr);
void vala_ccode_module_visit_integer_literal (ValaCCodeModule* self, ValaIntegerLiteral* expr);
void vala_ccode_module_visit_real_literal (ValaCCodeModule* self, ValaRealLiteral* expr);
void vala_ccode_module_visit_string_literal (ValaCCodeModule* self, ValaStringLiteral* expr);
void vala_ccode_module_visit_null_literal (ValaCCodeModule* self, ValaNullLiteral* expr);
void vala_ccode_module_visit_parenthesized_expression (ValaCCodeModule* self, ValaParenthesizedExpression* expr);
void vala_ccode_module_visit_member_access (ValaCCodeModule* self, ValaMemberAccess* expr);
void vala_ccode_module_visit_method_call (ValaCCodeModule* self, ValaMethodCall* expr);
void vala_ccode_module_visit_element_access (ValaCCodeModule* self, ValaElementAccess* expr);
void vala_ccode_module_visit_base_access (ValaCCodeModule* self, ValaBaseAccess* expr);
void vala_ccode_module_visit_postfix_expression (ValaCCodeModule* self, ValaPostfixExpression* expr);
void vala_ccode_module_visit_object_creation_expression (ValaCCodeModule* self, ValaObjectCreationExpression* expr);
void vala_ccode_module_visit_sizeof_expression (ValaCCodeModule* self, ValaSizeofExpression* expr);
void vala_ccode_module_visit_typeof_expression (ValaCCodeModule* self, ValaTypeofExpression* expr);
void vala_ccode_module_visit_unary_expression (ValaCCodeModule* self, ValaUnaryExpression* expr);
void vala_ccode_module_visit_cast_expression (ValaCCodeModule* self, ValaCastExpression* expr);
void vala_ccode_module_visit_pointer_indirection (ValaCCodeModule* self, ValaPointerIndirection* expr);
void vala_ccode_module_visit_addressof_expression (ValaCCodeModule* self, ValaAddressofExpression* expr);
void vala_ccode_module_visit_reference_transfer_expression (ValaCCodeModule* self, ValaReferenceTransferExpression* expr);
void vala_ccode_module_visit_binary_expression (ValaCCodeModule* self, ValaBinaryExpression* expr);
void vala_ccode_module_visit_type_check (ValaCCodeModule* self, ValaTypeCheck* expr);
void vala_ccode_module_visit_lambda_expression (ValaCCodeModule* self, ValaLambdaExpression* l);
void vala_ccode_module_visit_assignment (ValaCCodeModule* self, ValaAssignment* a);
void vala_ccode_module_generate_cparameters (ValaCCodeModule* self, ValaMethod* m, ValaDataType* creturn_type, gboolean in_gtypeinstance_creation_method, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
char* vala_ccode_module_get_custom_creturn_type (ValaCCodeModule* self, ValaMethod* m);
void vala_ccode_module_generate_dynamic_method_wrapper (ValaCCodeModule* self, ValaDynamicMethod* method);
gboolean vala_ccode_module_method_has_wrapper (ValaCCodeModule* self, ValaMethod* method);
ValaCCodeIdentifier* vala_ccode_module_get_value_setter_function (ValaCCodeModule* self, ValaDataType* type_reference);
ValaCCodeExpression* vala_ccode_module_get_construct_property_assignment (ValaCCodeModule* self, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value);
ValaCCodeFunctionCall* vala_ccode_module_get_param_spec (ValaCCodeModule* self, ValaProperty* prop);
ValaCCodeFunctionCall* vala_ccode_module_get_signal_creation (ValaCCodeModule* self, ValaSignal* sig, ValaTypeSymbol* type);
ValaCCodeFragment* vala_ccode_module_register_dbus_info (ValaCCodeModule* self, ValaObjectTypeSymbol* bindable);
char* vala_ccode_module_get_dynamic_property_getter_cname (ValaCCodeModule* self, ValaDynamicProperty* node);
char* vala_ccode_module_get_dynamic_property_setter_cname (ValaCCodeModule* self, ValaDynamicProperty* node);
char* vala_ccode_module_get_dynamic_signal_cname (ValaCCodeModule* self, ValaDynamicSignal* node);
char* vala_ccode_module_get_dynamic_signal_connect_wrapper_name (ValaCCodeModule* self, ValaDynamicSignal* node);
char* vala_ccode_module_get_dynamic_signal_disconnect_wrapper_name (ValaCCodeModule* self, ValaDynamicSignal* node);
void vala_ccode_module_generate_marshaller (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, gboolean dbus);
char* vala_ccode_module_get_marshaller_function (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, const char* prefix, gboolean dbus);
char* vala_ccode_module_get_array_length_cname (ValaCCodeModule* self, const char* array_cname, gint dim);
ValaCCodeExpression* vala_ccode_module_get_array_length_cexpression (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
void vala_ccode_module_add_simple_check (ValaCCodeModule* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
ValaCCodeGenerator* vala_ccode_module_get_codegen (ValaCCodeModule* self);
ValaCCodeModule* vala_ccode_module_get_head (ValaCCodeModule* self);
GParamSpec* vala_param_spec_ccode_module (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
gpointer vala_value_get_ccode_module (const GValue* value);
void vala_value_set_ccode_module (GValue* value, gpointer v_object);
GType vala_ccode_module_get_type (void);
gpointer vala_ccode_module_ref (gpointer instance);
void vala_ccode_module_unref (gpointer instance);


G_END_DECLS

#endif
