/* valaaddressofexpression.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaaddressofexpression.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>
#include <vala/valasemanticanalyzer.h>
#include <vala/valavaluetype.h>
#include <vala/valaobjecttype.h>
#include <vala/valapointertype.h>
#include <vala/valareport.h>
#include <vala/valadatatype.h>




struct _ValaAddressofExpressionPrivate {
	ValaExpression* _inner;
};

#define VALA_ADDRESSOF_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ADDRESSOF_EXPRESSION, ValaAddressofExpressionPrivate))
enum  {
	VALA_ADDRESSOF_EXPRESSION_DUMMY_PROPERTY
};
static void vala_addressof_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_addressof_expression_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static gboolean vala_addressof_expression_real_is_pure (ValaExpression* base);
static gboolean vala_addressof_expression_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
static gpointer vala_addressof_expression_parent_class = NULL;
static void vala_addressof_expression_finalize (ValaCodeNode* obj);



/**
 * Creates a new address-of expression.
 *
 * @param inner variable whose address is to be computed
 * @return      newly created address-of expression
 */
ValaAddressofExpression* vala_addressof_expression_construct (GType object_type, ValaExpression* inner, ValaSourceReference* source_reference) {
	ValaAddressofExpression* self;
	g_return_val_if_fail (inner != NULL, NULL);
	self = (ValaAddressofExpression*) g_type_create_instance (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_addressof_expression_set_inner (self, inner);
	return self;
}


ValaAddressofExpression* vala_addressof_expression_new (ValaExpression* inner, ValaSourceReference* source_reference) {
	return vala_addressof_expression_construct (VALA_TYPE_ADDRESSOF_EXPRESSION, inner, source_reference);
}


static void vala_addressof_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaAddressofExpression * self;
	self = (ValaAddressofExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_node_accept ((ValaCodeNode*) vala_addressof_expression_get_inner (self), visitor);
	vala_code_visitor_visit_addressof_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void vala_addressof_expression_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaAddressofExpression * self;
	self = (ValaAddressofExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	if (vala_addressof_expression_get_inner (self) == old_node) {
		vala_addressof_expression_set_inner (self, new_node);
	}
}


static gboolean vala_addressof_expression_real_is_pure (ValaExpression* base) {
	ValaAddressofExpression * self;
	self = (ValaAddressofExpression*) base;
	return vala_expression_is_pure (vala_addressof_expression_get_inner (self));
}


static gboolean vala_addressof_expression_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaAddressofExpression * self;
	gboolean _tmp2;
	gboolean _tmp3;
	self = (ValaAddressofExpression*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	if (vala_code_node_get_checked ((ValaCodeNode*) self)) {
		return !vala_code_node_get_error ((ValaCodeNode*) self);
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	if (!vala_code_node_check ((ValaCodeNode*) vala_addressof_expression_get_inner (self), analyzer)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		return FALSE;
	}
	_tmp2 = FALSE;
	_tmp3 = FALSE;
	if (VALA_IS_VALUE_TYPE (vala_expression_get_value_type (vala_addressof_expression_get_inner (self)))) {
		_tmp3 = TRUE;
	} else {
		_tmp3 = VALA_IS_OBJECT_TYPE (vala_expression_get_value_type (vala_addressof_expression_get_inner (self)));
	}
	if (_tmp3) {
		_tmp2 = TRUE;
	} else {
		_tmp2 = VALA_IS_POINTER_TYPE (vala_expression_get_value_type (vala_addressof_expression_get_inner (self)));
	}
	if (!(_tmp2)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "Address-of operator not supported for this expression");
		return FALSE;
	}
	if (vala_data_type_is_reference_type_or_type_parameter (vala_expression_get_value_type (vala_addressof_expression_get_inner (self)))) {
		ValaPointerType* _tmp6;
		ValaPointerType* _tmp5;
		_tmp6 = NULL;
		_tmp5 = NULL;
		vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) (_tmp6 = vala_pointer_type_new ((ValaDataType*) (_tmp5 = vala_pointer_type_new (vala_expression_get_value_type (vala_addressof_expression_get_inner (self)), NULL)), NULL)));
		(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_code_node_unref (_tmp6), NULL));
		(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_code_node_unref (_tmp5), NULL));
	} else {
		ValaPointerType* _tmp7;
		_tmp7 = NULL;
		vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) (_tmp7 = vala_pointer_type_new (vala_expression_get_value_type (vala_addressof_expression_get_inner (self)), NULL)));
		(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_code_node_unref (_tmp7), NULL));
	}
	return !vala_code_node_get_error ((ValaCodeNode*) self);
}


ValaExpression* vala_addressof_expression_get_inner (ValaAddressofExpression* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_inner;
}


void vala_addressof_expression_set_inner (ValaAddressofExpression* self, ValaExpression* value) {
	ValaExpression* _tmp2;
	ValaExpression* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_inner = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (self->priv->_inner == NULL) ? NULL : (self->priv->_inner = (vala_code_node_unref (self->priv->_inner), NULL)), _tmp2);
	vala_code_node_set_parent_node ((ValaCodeNode*) self->priv->_inner, (ValaCodeNode*) self);
}


static void vala_addressof_expression_class_init (ValaAddressofExpressionClass * klass) {
	vala_addressof_expression_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_addressof_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaAddressofExpressionPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_addressof_expression_real_accept;
	VALA_CODE_NODE_CLASS (klass)->replace_expression = vala_addressof_expression_real_replace_expression;
	VALA_EXPRESSION_CLASS (klass)->is_pure = vala_addressof_expression_real_is_pure;
	VALA_CODE_NODE_CLASS (klass)->check = vala_addressof_expression_real_check;
}


static void vala_addressof_expression_instance_init (ValaAddressofExpression * self) {
	self->priv = VALA_ADDRESSOF_EXPRESSION_GET_PRIVATE (self);
}


static void vala_addressof_expression_finalize (ValaCodeNode* obj) {
	ValaAddressofExpression * self;
	self = VALA_ADDRESSOF_EXPRESSION (obj);
	(self->priv->_inner == NULL) ? NULL : (self->priv->_inner = (vala_code_node_unref (self->priv->_inner), NULL));
	VALA_CODE_NODE_CLASS (vala_addressof_expression_parent_class)->finalize (obj);
}


GType vala_addressof_expression_get_type (void) {
	static GType vala_addressof_expression_type_id = 0;
	if (vala_addressof_expression_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaAddressofExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_addressof_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaAddressofExpression), 0, (GInstanceInitFunc) vala_addressof_expression_instance_init, NULL };
		vala_addressof_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaAddressofExpression", &g_define_type_info, 0);
	}
	return vala_addressof_expression_type_id;
}




