/* valacatchvala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALACATCHCLAUSE_H__
#define __VALA_VALACATCHCLAUSE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee/collection.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_CATCH_CLAUSE (vala_catch_clause_get_type ())
#define VALA_CATCH_CLAUSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CATCH_CLAUSE, ValaCatchClause))
#define VALA_CATCH_CLAUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CATCH_CLAUSE, ValaCatchClauseClass))
#define VALA_IS_CATCH_CLAUSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CATCH_CLAUSE))
#define VALA_IS_CATCH_CLAUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CATCH_CLAUSE))
#define VALA_CATCH_CLAUSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CATCH_CLAUSE, ValaCatchClauseClass))

typedef struct _ValaCatchClausePrivate ValaCatchClausePrivate;

/**
 * Represents a catch clause in a try statement in the source code.
 */
struct _ValaCatchClause {
	ValaCodeNode parent_instance;
	ValaCatchClausePrivate * priv;
};

struct _ValaCatchClauseClass {
	ValaCodeNodeClass parent_class;
};


ValaCatchClause* vala_catch_clause_construct (GType object_type, ValaDataType* error_type, const char* variable_name, ValaBlock* body, ValaSourceReference* source_reference);
ValaCatchClause* vala_catch_clause_new (ValaDataType* error_type, const char* variable_name, ValaBlock* body, ValaSourceReference* source_reference);
ValaDataType* vala_catch_clause_get_error_type (ValaCatchClause* self);
void vala_catch_clause_set_error_type (ValaCatchClause* self, ValaDataType* value);
const char* vala_catch_clause_get_variable_name (ValaCatchClause* self);
void vala_catch_clause_set_variable_name (ValaCatchClause* self, const char* value);
ValaBlock* vala_catch_clause_get_body (ValaCatchClause* self);
void vala_catch_clause_set_body (ValaCatchClause* self, ValaBlock* value);
ValaLocalVariable* vala_catch_clause_get_error_variable (ValaCatchClause* self);
void vala_catch_clause_set_error_variable (ValaCatchClause* self, ValaLocalVariable* value);
const char* vala_catch_clause_get_clabel_name (ValaCatchClause* self);
void vala_catch_clause_set_clabel_name (ValaCatchClause* self, const char* value);
GType vala_catch_clause_get_type (void);


G_END_DECLS

#endif
