/* valafieldprototype.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valafieldprototype.h>
#include <vala/valasymbol.h>




struct _ValaFieldPrototypePrivate {
	ValaField* _field_symbol;
};

#define VALA_FIELD_PROTOTYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_FIELD_PROTOTYPE, ValaFieldPrototypePrivate))
enum  {
	VALA_FIELD_PROTOTYPE_DUMMY_PROPERTY
};
static ValaDataType* vala_field_prototype_real_copy (ValaDataType* base);
static char* vala_field_prototype_real_to_qualified_string (ValaDataType* base, ValaScope* scope);
static gpointer vala_field_prototype_parent_class = NULL;
static void vala_field_prototype_finalize (ValaCodeNode* obj);



ValaFieldPrototype* vala_field_prototype_construct (GType object_type, ValaField* field_symbol) {
	ValaFieldPrototype* self;
	g_return_val_if_fail (field_symbol != NULL, NULL);
	self = (ValaFieldPrototype*) g_type_create_instance (object_type);
	vala_field_prototype_set_field_symbol (self, field_symbol);
	return self;
}


ValaFieldPrototype* vala_field_prototype_new (ValaField* field_symbol) {
	return vala_field_prototype_construct (VALA_TYPE_FIELD_PROTOTYPE, field_symbol);
}


static ValaDataType* vala_field_prototype_real_copy (ValaDataType* base) {
	ValaFieldPrototype * self;
	ValaFieldPrototype* result;
	self = (ValaFieldPrototype*) base;
	result = vala_field_prototype_new (self->priv->_field_symbol);
	return (ValaDataType*) result;
}


static char* vala_field_prototype_real_to_qualified_string (ValaDataType* base, ValaScope* scope) {
	ValaFieldPrototype * self;
	self = (ValaFieldPrototype*) base;
	return vala_symbol_get_full_name ((ValaSymbol*) self->priv->_field_symbol);
}


ValaField* vala_field_prototype_get_field_symbol (ValaFieldPrototype* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_field_symbol;
}


void vala_field_prototype_set_field_symbol (ValaFieldPrototype* self, ValaField* value) {
	ValaField* _tmp2;
	ValaField* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_field_symbol = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (self->priv->_field_symbol == NULL) ? NULL : (self->priv->_field_symbol = (vala_code_node_unref (self->priv->_field_symbol), NULL)), _tmp2);
}


static void vala_field_prototype_class_init (ValaFieldPrototypeClass * klass) {
	vala_field_prototype_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_field_prototype_finalize;
	g_type_class_add_private (klass, sizeof (ValaFieldPrototypePrivate));
	VALA_DATA_TYPE_CLASS (klass)->copy = vala_field_prototype_real_copy;
	VALA_DATA_TYPE_CLASS (klass)->to_qualified_string = vala_field_prototype_real_to_qualified_string;
}


static void vala_field_prototype_instance_init (ValaFieldPrototype * self) {
	self->priv = VALA_FIELD_PROTOTYPE_GET_PRIVATE (self);
}


static void vala_field_prototype_finalize (ValaCodeNode* obj) {
	ValaFieldPrototype * self;
	self = VALA_FIELD_PROTOTYPE (obj);
	(self->priv->_field_symbol == NULL) ? NULL : (self->priv->_field_symbol = (vala_code_node_unref (self->priv->_field_symbol), NULL));
	VALA_CODE_NODE_CLASS (vala_field_prototype_parent_class)->finalize (obj);
}


GType vala_field_prototype_get_type (void) {
	static GType vala_field_prototype_type_id = 0;
	if (vala_field_prototype_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaFieldPrototypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_field_prototype_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaFieldPrototype), 0, (GInstanceInitFunc) vala_field_prototype_instance_init, NULL };
		vala_field_prototype_type_id = g_type_register_static (VALA_TYPE_DATA_TYPE, "ValaFieldPrototype", &g_define_type_info, 0);
	}
	return vala_field_prototype_type_id;
}




