/* valascope.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALASCOPE_H__
#define __VALA_VALASCOPE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_SCOPE (vala_scope_get_type ())
#define VALA_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCOPE, ValaScope))
#define VALA_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCOPE, ValaScopeClass))
#define VALA_IS_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCOPE))
#define VALA_IS_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCOPE))
#define VALA_SCOPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCOPE, ValaScopeClass))

typedef struct _ValaScopePrivate ValaScopePrivate;
typedef struct _ValaParamSpecScope ValaParamSpecScope;

/**
 * Represents a part of the symbol tree.
 */
struct _ValaScope {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaScopePrivate * priv;
};

struct _ValaScopeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaScope *self);
};

struct _ValaParamSpecScope {
	GParamSpec parent_instance;
};


ValaScope* vala_scope_construct (GType object_type, ValaSymbol* owner);
ValaScope* vala_scope_new (ValaSymbol* owner);
void vala_scope_add (ValaScope* self, const char* name, ValaSymbol* sym);
void vala_scope_remove (ValaScope* self, const char* name);
ValaSymbol* vala_scope_lookup (ValaScope* self, const char* name);
gboolean vala_scope_is_subscope_of (ValaScope* self, ValaScope* scope);
ValaSymbol* vala_scope_get_owner (ValaScope* self);
void vala_scope_set_owner (ValaScope* self, ValaSymbol* value);
ValaScope* vala_scope_get_parent_scope (ValaScope* self);
void vala_scope_set_parent_scope (ValaScope* self, ValaScope* value);
GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
gpointer vala_value_get_scope (const GValue* value);
void vala_value_set_scope (GValue* value, gpointer v_object);
GType vala_scope_get_type (void);
gpointer vala_scope_ref (gpointer instance);
void vala_scope_unref (gpointer instance);


G_END_DECLS

#endif
