/* valaunresolvedsymbol.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALAUNRESOLVEDSYMBOL_H__
#define __VALA_VALAUNRESOLVEDSYMBOL_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valasymbol.h>
#include <vala/valasourcereference.h>

G_BEGIN_DECLS


#define VALA_TYPE_UNRESOLVED_SYMBOL (vala_unresolved_symbol_get_type ())
#define VALA_UNRESOLVED_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_UNRESOLVED_SYMBOL, ValaUnresolvedSymbol))
#define VALA_UNRESOLVED_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_UNRESOLVED_SYMBOL, ValaUnresolvedSymbolClass))
#define VALA_IS_UNRESOLVED_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_UNRESOLVED_SYMBOL))
#define VALA_IS_UNRESOLVED_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_UNRESOLVED_SYMBOL))
#define VALA_UNRESOLVED_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_UNRESOLVED_SYMBOL, ValaUnresolvedSymbolClass))

typedef struct _ValaUnresolvedSymbol ValaUnresolvedSymbol;
typedef struct _ValaUnresolvedSymbolClass ValaUnresolvedSymbolClass;
typedef struct _ValaUnresolvedSymbolPrivate ValaUnresolvedSymbolPrivate;

/**
 * An unresolved reference to a symbol.
 */
struct _ValaUnresolvedSymbol {
	ValaSymbol parent_instance;
	ValaUnresolvedSymbolPrivate * priv;
};

struct _ValaUnresolvedSymbolClass {
	ValaSymbolClass parent_class;
};


ValaUnresolvedSymbol* vala_unresolved_symbol_construct (GType object_type, ValaUnresolvedSymbol* inner, const char* name, ValaSourceReference* source_reference);
ValaUnresolvedSymbol* vala_unresolved_symbol_new (ValaUnresolvedSymbol* inner, const char* name, ValaSourceReference* source_reference);
ValaUnresolvedSymbol* vala_unresolved_symbol_copy (ValaUnresolvedSymbol* self);
ValaUnresolvedSymbol* vala_unresolved_symbol_get_inner (ValaUnresolvedSymbol* self);
void vala_unresolved_symbol_set_inner (ValaUnresolvedSymbol* self, ValaUnresolvedSymbol* value);
gboolean vala_unresolved_symbol_get_qualified (ValaUnresolvedSymbol* self);
void vala_unresolved_symbol_set_qualified (ValaUnresolvedSymbol* self, gboolean value);
GType vala_unresolved_symbol_get_type (void);


G_END_DECLS

#endif
