/* valaccodecontrolflowmodule.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodecontrolflowmodule.h>
#include <vala/valacodenode.h>
#include <vala/valacodevisitor.h>
#include <ccode/valaccodeifstatement.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodestatement.h>
#include <vala/valaexpression.h>
#include <vala/valastatement.h>
#include <gee/list.h>
#include <vala/valadatatype.h>
#include <vala/valalocalvariable.h>
#include <ccode/valaccodeidentifier.h>
#include <vala/valasymbol.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodefragment.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeconditionalexpression.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <vala/valablock.h>
#include <ccode/valaccodeblock.h>
#include <ccode/valaccodedostatement.h>
#include <ccode/valaccodeswitchstatement.h>
#include <ccode/valaccodelabel.h>
#include <ccode/valaccodecasestatement.h>
#include <ccode/valaccodewhilestatement.h>
#include <ccode/valaccodeforstatement.h>
#include <vala/valaarraytype.h>
#include <gee/collection.h>
#include <ccode/valaccodeelementaccess.h>
#include <vala/valaobjecttype.h>
#include <vala/valaobjecttypesymbol.h>
#include <ccode/valaccodememberaccess.h>
#include <vala/valareport.h>
#include <vala/valasourcereference.h>
#include <vala/valamemberaccess.h>
#include <ccode/valaccodebreakstatement.h>
#include <ccode/valaccodecontinuestatement.h>
#include <gobject/valaccodebasemodule.h>




enum  {
	VALA_CCODE_CONTROL_FLOW_MODULE_DUMMY_PROPERTY
};
static void vala_ccode_control_flow_module_real_visit_if_statement (ValaCCodeModule* base, ValaIfStatement* stmt);
static void vala_ccode_control_flow_module_visit_string_switch_statement (ValaCCodeControlFlowModule* self, ValaSwitchStatement* stmt);
static void vala_ccode_control_flow_module_real_visit_switch_statement (ValaCCodeModule* base, ValaSwitchStatement* stmt);
static void vala_ccode_control_flow_module_real_visit_switch_section (ValaCCodeModule* base, ValaSwitchSection* section);
static void vala_ccode_control_flow_module_real_visit_switch_label (ValaCCodeModule* base, ValaSwitchLabel* label);
static void vala_ccode_control_flow_module_real_visit_while_statement (ValaCCodeModule* base, ValaWhileStatement* stmt);
static void vala_ccode_control_flow_module_real_visit_do_statement (ValaCCodeModule* base, ValaDoStatement* stmt);
static void vala_ccode_control_flow_module_real_visit_for_statement (ValaCCodeModule* base, ValaForStatement* stmt);
static void vala_ccode_control_flow_module_real_visit_foreach_statement (ValaCCodeModule* base, ValaForeachStatement* stmt);
static void vala_ccode_control_flow_module_real_visit_break_statement (ValaCCodeModule* base, ValaBreakStatement* stmt);
static void vala_ccode_control_flow_module_real_visit_continue_statement (ValaCCodeModule* base, ValaContinueStatement* stmt);
static gpointer vala_ccode_control_flow_module_parent_class = NULL;



ValaCCodeControlFlowModule* vala_ccode_control_flow_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeControlFlowModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaCCodeControlFlowModule*) vala_ccode_method_module_construct (object_type, codegen, next);
	return self;
}


ValaCCodeControlFlowModule* vala_ccode_control_flow_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_control_flow_module_construct (VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, codegen, next);
}


static void vala_ccode_control_flow_module_real_visit_if_statement (ValaCCodeModule* base, ValaIfStatement* stmt) {
	ValaCCodeControlFlowModule * self;
	self = (ValaCCodeControlFlowModule*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (vala_if_statement_get_false_statement (stmt) != NULL) {
		ValaCCodeIfStatement* _tmp0;
		_tmp0 = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) (_tmp0 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_if_statement_get_condition (stmt))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_if_statement_get_true_statement (stmt))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_if_statement_get_false_statement (stmt))))));
		(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	} else {
		ValaCCodeIfStatement* _tmp1;
		_tmp1 = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) (_tmp1 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_if_statement_get_condition (stmt))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_if_statement_get_true_statement (stmt))), NULL)));
		(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
	}
	vala_ccode_base_module_create_temp_decl ((ValaCCodeBaseModule*) self, (ValaStatement*) stmt, (GeeList*) vala_if_statement_get_condition (stmt)->temp_vars);
}


static void vala_ccode_control_flow_module_visit_string_switch_statement (ValaCCodeControlFlowModule* self, ValaSwitchStatement* stmt) {
	ValaLocalVariable* temp_var;
	ValaCCodeIdentifier* ctemp;
	ValaCCodeAssignment* cinit;
	ValaCCodeConstant* czero;
	ValaCCodeFragment* cswitchblock;
	ValaCCodeConstant* _tmp0;
	ValaCCodeBinaryExpression* _tmp1;
	ValaCCodeBinaryExpression* cisnull;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeFunctionCall* _tmp3;
	ValaCCodeFunctionCall* cquark;
	ValaCCodeConstant* _tmp4;
	ValaCCodeConditionalExpression* _tmp5;
	ValaCCodeConditionalExpression* ccond;
	ValaLocalVariable* _tmp6;
	gint label_count;
	ValaCCodeExpressionStatement* _tmp15;
	ValaCCodeIdentifier* _tmp16;
	ValaCCodeAssignment* _tmp17;
	ValaCCodeExpressionStatement* _tmp18;
	GeeList* default_statements;
	ValaCCodeStatement* ctopstmt;
	ValaCCodeIfStatement* coldif;
	g_return_if_fail (self != NULL);
	g_return_if_fail (stmt != NULL);
	/* we need a temporary variable to save the property value*/
	temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (vala_switch_statement_get_expression (stmt)), TRUE, (ValaCodeNode*) stmt);
	gee_list_insert ((GeeList*) vala_switch_statement_get_expression (stmt)->temp_vars, 0, temp_var);
	ctemp = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var));
	cinit = vala_ccode_assignment_new ((ValaCCodeExpression*) ctemp, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_switch_statement_get_expression (stmt))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	czero = vala_ccode_constant_new ("0");
	cswitchblock = vala_ccode_fragment_new ();
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cswitchblock);
	_tmp0 = NULL;
	_tmp1 = NULL;
	cisnull = (_tmp1 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) (_tmp0 = vala_ccode_constant_new ("NULL")), (ValaCCodeExpression*) ctemp), (_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)), _tmp1);
	_tmp2 = NULL;
	_tmp3 = NULL;
	cquark = (_tmp3 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp2 = vala_ccode_identifier_new ("g_quark_from_string"))), (_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)), _tmp3);
	vala_ccode_function_call_add_argument (cquark, (ValaCCodeExpression*) ctemp);
	_tmp4 = NULL;
	_tmp5 = NULL;
	ccond = (_tmp5 = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) cisnull, (ValaCCodeExpression*) (_tmp4 = vala_ccode_constant_new ("0")), (ValaCCodeExpression*) cquark), (_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)), _tmp5);
	_tmp6 = NULL;
	temp_var = (_tmp6 = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->gquark_type, TRUE, NULL), (temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL)), _tmp6);
	gee_list_insert ((GeeList*) vala_switch_statement_get_expression (stmt)->temp_vars, 0, temp_var);
	label_count = 0;
	{
		GeeList* _tmp7;
		GeeIterator* _tmp8;
		GeeIterator* _section_it;
		_tmp7 = NULL;
		_tmp8 = NULL;
		_section_it = (_tmp8 = gee_iterable_iterator ((GeeIterable*) (_tmp7 = vala_switch_statement_get_sections (stmt))), (_tmp7 == NULL) ? NULL : (_tmp7 = (gee_collection_object_unref (_tmp7), NULL)), _tmp8);
		while (gee_iterator_next (_section_it)) {
			ValaSwitchSection* section;
			section = (ValaSwitchSection*) gee_iterator_get (_section_it);
			if (vala_switch_section_has_default_label (section)) {
				(section == NULL) ? NULL : (section = (vala_code_node_unref (section), NULL));
				continue;
			}
			{
				GeeList* _tmp9;
				GeeIterator* _tmp10;
				GeeIterator* _label_it;
				_tmp9 = NULL;
				_tmp10 = NULL;
				_label_it = (_tmp10 = gee_iterable_iterator ((GeeIterable*) (_tmp9 = vala_switch_section_get_labels (section))), (_tmp9 == NULL) ? NULL : (_tmp9 = (gee_collection_object_unref (_tmp9), NULL)), _tmp10);
				while (gee_iterator_next (_label_it)) {
					ValaSwitchLabel* label;
					ValaCCodeExpression* _tmp11;
					ValaCCodeExpression* cexpr;
					label = (ValaSwitchLabel*) gee_iterator_get (_label_it);
					_tmp11 = NULL;
					cexpr = (_tmp11 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_switch_label_get_expression (label))), (_tmp11 == NULL) ? NULL : vala_ccode_node_ref (_tmp11));
					if (vala_ccode_base_module_is_constant_ccode_expression ((ValaCCodeBaseModule*) self, cexpr)) {
						char* cname;
						char* _tmp12;
						ValaCCodeDeclaration* _tmp13;
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeVariableDeclarator* _tmp14;
						cname = g_strdup_printf ("%s_label%d", vala_symbol_get_name ((ValaSymbol*) temp_var), label_count++);
						_tmp12 = NULL;
						_tmp13 = NULL;
						cdecl_ = (_tmp13 = vala_ccode_declaration_new (_tmp12 = vala_data_type_get_cname (((ValaCCodeBaseModule*) self)->gquark_type)), _tmp12 = (g_free (_tmp12), NULL), _tmp13);
						vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
						_tmp14 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp14 = vala_ccode_variable_declarator_new_with_initializer (cname, (ValaCCodeExpression*) czero)));
						(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
						vala_ccode_fragment_append (cswitchblock, (ValaCCodeNode*) cdecl_);
						cname = (g_free (cname), NULL);
						(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
					}
					(label == NULL) ? NULL : (label = (vala_code_node_unref (label), NULL));
					(cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL));
				}
				(_label_it == NULL) ? NULL : (_label_it = (gee_collection_object_unref (_label_it), NULL));
			}
			(section == NULL) ? NULL : (section = (vala_code_node_unref (section), NULL));
		}
		(_section_it == NULL) ? NULL : (_section_it = (gee_collection_object_unref (_section_it), NULL));
	}
	_tmp15 = NULL;
	vala_ccode_fragment_append (cswitchblock, (ValaCCodeNode*) (_tmp15 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cinit)));
	(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
	_tmp16 = NULL;
	ctemp = (_tmp16 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var)), (ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL)), _tmp16);
	_tmp17 = NULL;
	cinit = (_tmp17 = vala_ccode_assignment_new ((ValaCCodeExpression*) ctemp, (ValaCCodeExpression*) ccond, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (cinit == NULL) ? NULL : (cinit = (vala_ccode_node_unref (cinit), NULL)), _tmp17);
	_tmp18 = NULL;
	vala_ccode_fragment_append (cswitchblock, (ValaCCodeNode*) (_tmp18 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cinit)));
	(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
	vala_ccode_base_module_create_temp_decl ((ValaCCodeBaseModule*) self, (ValaStatement*) stmt, (GeeList*) vala_switch_statement_get_expression (stmt)->temp_vars);
	default_statements = NULL;
	label_count = 0;
	/* generate nested if statements*/
	ctopstmt = NULL;
	coldif = NULL;
	{
		GeeList* _tmp19;
		GeeIterator* _tmp20;
		GeeIterator* _section_it;
		_tmp19 = NULL;
		_tmp20 = NULL;
		_section_it = (_tmp20 = gee_iterable_iterator ((GeeIterable*) (_tmp19 = vala_switch_statement_get_sections (stmt))), (_tmp19 == NULL) ? NULL : (_tmp19 = (gee_collection_object_unref (_tmp19), NULL)), _tmp20);
		while (gee_iterator_next (_section_it)) {
			ValaSwitchSection* section;
			ValaCCodeBinaryExpression* cor;
			ValaCCodeBlock* cblock;
			ValaCCodeConstant* _tmp42;
			ValaCCodeDoStatement* _tmp43;
			ValaCCodeDoStatement* cdo;
			ValaCCodeIfStatement* cif;
			ValaCCodeIfStatement* _tmp47;
			ValaCCodeIfStatement* _tmp46;
			section = (ValaSwitchSection*) gee_iterator_get (_section_it);
			if (vala_switch_section_has_default_label (section)) {
				GeeList* _tmp21;
				_tmp21 = NULL;
				default_statements = (_tmp21 = vala_block_get_statements ((ValaBlock*) section), (default_statements == NULL) ? NULL : (default_statements = (gee_collection_object_unref (default_statements), NULL)), _tmp21);
				(section == NULL) ? NULL : (section = (vala_code_node_unref (section), NULL));
				continue;
			}
			cor = NULL;
			{
				GeeList* _tmp22;
				GeeIterator* _tmp23;
				GeeIterator* _label_it;
				_tmp22 = NULL;
				_tmp23 = NULL;
				_label_it = (_tmp23 = gee_iterable_iterator ((GeeIterable*) (_tmp22 = vala_switch_section_get_labels (section))), (_tmp22 == NULL) ? NULL : (_tmp22 = (gee_collection_object_unref (_tmp22), NULL)), _tmp23);
				while (gee_iterator_next (_label_it)) {
					ValaSwitchLabel* label;
					ValaCCodeExpression* _tmp24;
					ValaCCodeExpression* cexpr;
					ValaCCodeBinaryExpression* ccmp;
					label = (ValaSwitchLabel*) gee_iterator_get (_label_it);
					_tmp24 = NULL;
					cexpr = (_tmp24 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_switch_label_get_expression (label))), (_tmp24 == NULL) ? NULL : vala_ccode_node_ref (_tmp24));
					if (vala_ccode_base_module_is_constant_ccode_expression ((ValaCCodeBaseModule*) self, cexpr)) {
						char* _tmp25;
						ValaCCodeIdentifier* _tmp26;
						ValaCCodeIdentifier* cname;
						ValaCCodeBinaryExpression* ccondition;
						ValaCCodeIdentifier* _tmp27;
						ValaCCodeFunctionCall* _tmp28;
						ValaCCodeFunctionCall* ccall;
						ValaCCodeAssignment* _tmp29;
						ValaCCodeExpression* _tmp30;
						_tmp25 = NULL;
						_tmp26 = NULL;
						cname = (_tmp26 = vala_ccode_identifier_new (_tmp25 = g_strdup_printf ("%s_label%d", vala_symbol_get_name ((ValaSymbol*) temp_var), label_count++)), _tmp25 = (g_free (_tmp25), NULL), _tmp26);
						ccondition = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) czero, (ValaCCodeExpression*) cname);
						_tmp27 = NULL;
						_tmp28 = NULL;
						ccall = (_tmp28 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp27 = vala_ccode_identifier_new ("g_quark_from_static_string"))), (_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL)), _tmp28);
						_tmp29 = NULL;
						cinit = (_tmp29 = vala_ccode_assignment_new ((ValaCCodeExpression*) cname, (ValaCCodeExpression*) ccall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (cinit == NULL) ? NULL : (cinit = (vala_ccode_node_unref (cinit), NULL)), _tmp29);
						vala_ccode_function_call_add_argument (ccall, cexpr);
						_tmp30 = NULL;
						cexpr = (_tmp30 = (ValaCCodeExpression*) vala_ccode_conditional_expression_new ((ValaCCodeExpression*) ccondition, (ValaCCodeExpression*) cname, (ValaCCodeExpression*) cinit), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp30);
						(cname == NULL) ? NULL : (cname = (vala_ccode_node_unref (cname), NULL));
						(ccondition == NULL) ? NULL : (ccondition = (vala_ccode_node_unref (ccondition), NULL));
						(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
					} else {
						ValaCCodeIdentifier* _tmp31;
						ValaCCodeFunctionCall* _tmp32;
						ValaCCodeFunctionCall* ccall;
						ValaCCodeExpression* _tmp34;
						ValaCCodeExpression* _tmp33;
						_tmp31 = NULL;
						_tmp32 = NULL;
						ccall = (_tmp32 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp31 = vala_ccode_identifier_new ("g_quark_from_string"))), (_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL)), _tmp32);
						vala_ccode_function_call_add_argument (ccall, cexpr);
						_tmp34 = NULL;
						_tmp33 = NULL;
						cexpr = (_tmp34 = (_tmp33 = (ValaCCodeExpression*) ccall, (_tmp33 == NULL) ? NULL : vala_ccode_node_ref (_tmp33)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp34);
						(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
					}
					ccmp = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) ctemp, cexpr);
					if (cor == NULL) {
						ValaCCodeBinaryExpression* _tmp36;
						ValaCCodeBinaryExpression* _tmp35;
						_tmp36 = NULL;
						_tmp35 = NULL;
						cor = (_tmp36 = (_tmp35 = ccmp, (_tmp35 == NULL) ? NULL : vala_ccode_node_ref (_tmp35)), (cor == NULL) ? NULL : (cor = (vala_ccode_node_unref (cor), NULL)), _tmp36);
					} else {
						ValaCCodeBinaryExpression* _tmp37;
						_tmp37 = NULL;
						cor = (_tmp37 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, (ValaCCodeExpression*) cor, (ValaCCodeExpression*) ccmp), (cor == NULL) ? NULL : (cor = (vala_ccode_node_unref (cor), NULL)), _tmp37);
					}
					(label == NULL) ? NULL : (label = (vala_code_node_unref (label), NULL));
					(cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL));
					(ccmp == NULL) ? NULL : (ccmp = (vala_ccode_node_unref (ccmp), NULL));
				}
				(_label_it == NULL) ? NULL : (_label_it = (gee_collection_object_unref (_label_it), NULL));
			}
			cblock = vala_ccode_block_new ();
			{
				GeeList* _tmp38;
				GeeIterator* _tmp39;
				GeeIterator* _body_stmt_it;
				_tmp38 = NULL;
				_tmp39 = NULL;
				_body_stmt_it = (_tmp39 = gee_iterable_iterator ((GeeIterable*) (_tmp38 = vala_block_get_statements ((ValaBlock*) section))), (_tmp38 == NULL) ? NULL : (_tmp38 = (gee_collection_object_unref (_tmp38), NULL)), _tmp39);
				while (gee_iterator_next (_body_stmt_it)) {
					ValaCodeNode* body_stmt;
					body_stmt = (ValaCodeNode*) ((ValaStatement*) gee_iterator_get (_body_stmt_it));
					if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (body_stmt))) {
						{
							GeeList* _tmp40;
							GeeIterator* _tmp41;
							GeeIterator* _cstmt_it;
							_tmp40 = NULL;
							_tmp41 = NULL;
							_cstmt_it = (_tmp41 = gee_iterable_iterator ((GeeIterable*) (_tmp40 = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (body_stmt)))))), (_tmp40 == NULL) ? NULL : (_tmp40 = (gee_collection_object_unref (_tmp40), NULL)), _tmp41);
							while (gee_iterator_next (_cstmt_it)) {
								ValaCCodeNode* cstmt;
								cstmt = (ValaCCodeNode*) gee_iterator_get (_cstmt_it);
								vala_ccode_block_add_statement (cblock, cstmt);
								(cstmt == NULL) ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL));
							}
							(_cstmt_it == NULL) ? NULL : (_cstmt_it = (gee_collection_object_unref (_cstmt_it), NULL));
						}
					} else {
						vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (body_stmt));
					}
					(body_stmt == NULL) ? NULL : (body_stmt = (vala_code_node_unref (body_stmt), NULL));
				}
				(_body_stmt_it == NULL) ? NULL : (_body_stmt_it = (gee_collection_object_unref (_body_stmt_it), NULL));
			}
			_tmp42 = NULL;
			_tmp43 = NULL;
			cdo = (_tmp43 = vala_ccode_do_statement_new ((ValaCCodeStatement*) cblock, (ValaCCodeExpression*) (_tmp42 = vala_ccode_constant_new ("0"))), (_tmp42 == NULL) ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL)), _tmp43);
			cif = vala_ccode_if_statement_new ((ValaCCodeExpression*) cor, (ValaCCodeStatement*) cdo, NULL);
			if (coldif != NULL) {
				vala_ccode_if_statement_set_false_statement (coldif, (ValaCCodeStatement*) cif);
			} else {
				ValaCCodeStatement* _tmp45;
				ValaCCodeStatement* _tmp44;
				_tmp45 = NULL;
				_tmp44 = NULL;
				ctopstmt = (_tmp45 = (_tmp44 = (ValaCCodeStatement*) cif, (_tmp44 == NULL) ? NULL : vala_ccode_node_ref (_tmp44)), (ctopstmt == NULL) ? NULL : (ctopstmt = (vala_ccode_node_unref (ctopstmt), NULL)), _tmp45);
			}
			_tmp47 = NULL;
			_tmp46 = NULL;
			coldif = (_tmp47 = (_tmp46 = cif, (_tmp46 == NULL) ? NULL : vala_ccode_node_ref (_tmp46)), (coldif == NULL) ? NULL : (coldif = (vala_ccode_node_unref (coldif), NULL)), _tmp47);
			(section == NULL) ? NULL : (section = (vala_code_node_unref (section), NULL));
			(cor == NULL) ? NULL : (cor = (vala_ccode_node_unref (cor), NULL));
			(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
			(cdo == NULL) ? NULL : (cdo = (vala_ccode_node_unref (cdo), NULL));
			(cif == NULL) ? NULL : (cif = (vala_ccode_node_unref (cif), NULL));
		}
		(_section_it == NULL) ? NULL : (_section_it = (gee_collection_object_unref (_section_it), NULL));
	}
	if (default_statements != NULL) {
		ValaCCodeBlock* cblock;
		ValaCCodeConstant* _tmp48;
		ValaCCodeDoStatement* _tmp49;
		ValaCCodeDoStatement* cdo;
		cblock = vala_ccode_block_new ();
		{
			GeeIterator* _body_stmt_it;
			_body_stmt_it = gee_iterable_iterator ((GeeIterable*) default_statements);
			while (gee_iterator_next (_body_stmt_it)) {
				ValaCodeNode* body_stmt;
				body_stmt = (ValaCodeNode*) ((ValaStatement*) gee_iterator_get (_body_stmt_it));
				vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (body_stmt));
				(body_stmt == NULL) ? NULL : (body_stmt = (vala_code_node_unref (body_stmt), NULL));
			}
			(_body_stmt_it == NULL) ? NULL : (_body_stmt_it = (gee_collection_object_unref (_body_stmt_it), NULL));
		}
		_tmp48 = NULL;
		_tmp49 = NULL;
		cdo = (_tmp49 = vala_ccode_do_statement_new ((ValaCCodeStatement*) cblock, (ValaCCodeExpression*) (_tmp48 = vala_ccode_constant_new ("0"))), (_tmp48 == NULL) ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL)), _tmp49);
		if (coldif == NULL) {
			ValaCCodeStatement* _tmp51;
			ValaCCodeStatement* _tmp50;
			/* there is only one section and that section
			 contains a default label*/
			_tmp51 = NULL;
			_tmp50 = NULL;
			ctopstmt = (_tmp51 = (_tmp50 = (ValaCCodeStatement*) cdo, (_tmp50 == NULL) ? NULL : vala_ccode_node_ref (_tmp50)), (ctopstmt == NULL) ? NULL : (ctopstmt = (vala_ccode_node_unref (ctopstmt), NULL)), _tmp51);
		} else {
			vala_ccode_if_statement_set_false_statement (coldif, (ValaCCodeStatement*) cdo);
		}
		(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
		(cdo == NULL) ? NULL : (cdo = (vala_ccode_node_unref (cdo), NULL));
	}
	vala_ccode_fragment_append (cswitchblock, (ValaCCodeNode*) ctopstmt);
	(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
	(ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL));
	(cinit == NULL) ? NULL : (cinit = (vala_ccode_node_unref (cinit), NULL));
	(czero == NULL) ? NULL : (czero = (vala_ccode_node_unref (czero), NULL));
	(cswitchblock == NULL) ? NULL : (cswitchblock = (vala_ccode_node_unref (cswitchblock), NULL));
	(cisnull == NULL) ? NULL : (cisnull = (vala_ccode_node_unref (cisnull), NULL));
	(cquark == NULL) ? NULL : (cquark = (vala_ccode_node_unref (cquark), NULL));
	(ccond == NULL) ? NULL : (ccond = (vala_ccode_node_unref (ccond), NULL));
	(default_statements == NULL) ? NULL : (default_statements = (gee_collection_object_unref (default_statements), NULL));
	(ctopstmt == NULL) ? NULL : (ctopstmt = (vala_ccode_node_unref (ctopstmt), NULL));
	(coldif == NULL) ? NULL : (coldif = (vala_ccode_node_unref (coldif), NULL));
}


static void vala_ccode_control_flow_module_real_visit_switch_statement (ValaCCodeModule* base, ValaSwitchStatement* stmt) {
	ValaCCodeControlFlowModule * self;
	ValaCCodeSwitchStatement* cswitch;
	self = (ValaCCodeControlFlowModule*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (vala_data_type_compatible (vala_expression_get_value_type (vala_switch_statement_get_expression (stmt)), ((ValaCCodeBaseModule*) self)->string_type)) {
		vala_ccode_control_flow_module_visit_string_switch_statement (self, stmt);
		return;
	}
	cswitch = vala_ccode_switch_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_switch_statement_get_expression (stmt))));
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cswitch);
	{
		GeeList* _tmp0;
		GeeIterator* _tmp1;
		GeeIterator* _section_it;
		_tmp0 = NULL;
		_tmp1 = NULL;
		_section_it = (_tmp1 = gee_iterable_iterator ((GeeIterable*) (_tmp0 = vala_switch_statement_get_sections (stmt))), (_tmp0 == NULL) ? NULL : (_tmp0 = (gee_collection_object_unref (_tmp0), NULL)), _tmp1);
		while (gee_iterator_next (_section_it)) {
			ValaSwitchSection* section;
			ValaCCodeBlock* cblock;
			section = (ValaSwitchSection*) gee_iterator_get (_section_it);
			if (vala_switch_section_has_default_label (section)) {
				ValaCCodeLabel* _tmp2;
				ValaCCodeBlock* cdefaultblock;
				_tmp2 = NULL;
				vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp2 = vala_ccode_label_new ("default")));
				(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
				cdefaultblock = vala_ccode_block_new ();
				vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) cdefaultblock);
				{
					GeeList* _tmp3;
					GeeIterator* _tmp4;
					GeeIterator* _default_stmt_it;
					_tmp3 = NULL;
					_tmp4 = NULL;
					_default_stmt_it = (_tmp4 = gee_iterable_iterator ((GeeIterable*) (_tmp3 = vala_block_get_statements ((ValaBlock*) section))), (_tmp3 == NULL) ? NULL : (_tmp3 = (gee_collection_object_unref (_tmp3), NULL)), _tmp4);
					while (gee_iterator_next (_default_stmt_it)) {
						ValaCodeNode* default_stmt;
						default_stmt = (ValaCodeNode*) ((ValaStatement*) gee_iterator_get (_default_stmt_it));
						vala_ccode_block_add_statement (cdefaultblock, vala_code_node_get_ccodenode (default_stmt));
						(default_stmt == NULL) ? NULL : (default_stmt = (vala_code_node_unref (default_stmt), NULL));
					}
					(_default_stmt_it == NULL) ? NULL : (_default_stmt_it = (gee_collection_object_unref (_default_stmt_it), NULL));
				}
				(cdefaultblock == NULL) ? NULL : (cdefaultblock = (vala_ccode_node_unref (cdefaultblock), NULL));
				(section == NULL) ? NULL : (section = (vala_code_node_unref (section), NULL));
				continue;
			}
			{
				GeeList* _tmp5;
				GeeIterator* _tmp6;
				GeeIterator* _label_it;
				_tmp5 = NULL;
				_tmp6 = NULL;
				_label_it = (_tmp6 = gee_iterable_iterator ((GeeIterable*) (_tmp5 = vala_switch_section_get_labels (section))), (_tmp5 == NULL) ? NULL : (_tmp5 = (gee_collection_object_unref (_tmp5), NULL)), _tmp6);
				while (gee_iterator_next (_label_it)) {
					ValaSwitchLabel* label;
					ValaCCodeCaseStatement* _tmp7;
					label = (ValaSwitchLabel*) gee_iterator_get (_label_it);
					_tmp7 = NULL;
					vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp7 = vala_ccode_case_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_switch_label_get_expression (label))))));
					(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
					(label == NULL) ? NULL : (label = (vala_code_node_unref (label), NULL));
				}
				(_label_it == NULL) ? NULL : (_label_it = (gee_collection_object_unref (_label_it), NULL));
			}
			cblock = vala_ccode_block_new ();
			vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) cblock);
			{
				GeeList* _tmp8;
				GeeIterator* _tmp9;
				GeeIterator* _body_stmt_it;
				_tmp8 = NULL;
				_tmp9 = NULL;
				_body_stmt_it = (_tmp9 = gee_iterable_iterator ((GeeIterable*) (_tmp8 = vala_block_get_statements ((ValaBlock*) section))), (_tmp8 == NULL) ? NULL : (_tmp8 = (gee_collection_object_unref (_tmp8), NULL)), _tmp9);
				while (gee_iterator_next (_body_stmt_it)) {
					ValaCodeNode* body_stmt;
					body_stmt = (ValaCodeNode*) ((ValaStatement*) gee_iterator_get (_body_stmt_it));
					vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (body_stmt));
					(body_stmt == NULL) ? NULL : (body_stmt = (vala_code_node_unref (body_stmt), NULL));
				}
				(_body_stmt_it == NULL) ? NULL : (_body_stmt_it = (gee_collection_object_unref (_body_stmt_it), NULL));
			}
			(section == NULL) ? NULL : (section = (vala_code_node_unref (section), NULL));
			(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
		}
		(_section_it == NULL) ? NULL : (_section_it = (gee_collection_object_unref (_section_it), NULL));
	}
	(cswitch == NULL) ? NULL : (cswitch = (vala_ccode_node_unref (cswitch), NULL));
}


static void vala_ccode_control_flow_module_real_visit_switch_section (ValaCCodeModule* base, ValaSwitchSection* section) {
	ValaCCodeControlFlowModule * self;
	self = (ValaCCodeControlFlowModule*) base;
	g_return_if_fail (section != NULL);
	vala_ccode_module_visit_block ((ValaCCodeModule*) self, (ValaBlock*) section);
}


static void vala_ccode_control_flow_module_real_visit_switch_label (ValaCCodeModule* base, ValaSwitchLabel* label) {
	ValaCCodeControlFlowModule * self;
	self = (ValaCCodeControlFlowModule*) base;
	g_return_if_fail (label != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) label, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
}


static void vala_ccode_control_flow_module_real_visit_while_statement (ValaCCodeModule* base, ValaWhileStatement* stmt) {
	ValaCCodeControlFlowModule * self;
	ValaCCodeWhileStatement* _tmp0;
	self = (ValaCCodeControlFlowModule*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) (_tmp0 = vala_ccode_while_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_while_statement_get_condition (stmt))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_while_statement_get_body (stmt))))));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	vala_ccode_base_module_create_temp_decl ((ValaCCodeBaseModule*) self, (ValaStatement*) stmt, (GeeList*) vala_while_statement_get_condition (stmt)->temp_vars);
}


static void vala_ccode_control_flow_module_real_visit_do_statement (ValaCCodeModule* base, ValaDoStatement* stmt) {
	ValaCCodeControlFlowModule * self;
	ValaCCodeDoStatement* _tmp0;
	self = (ValaCCodeControlFlowModule*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) (_tmp0 = vala_ccode_do_statement_new (VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_do_statement_get_body (stmt))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_do_statement_get_condition (stmt))))));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	vala_ccode_base_module_create_temp_decl ((ValaCCodeBaseModule*) self, (ValaStatement*) stmt, (GeeList*) vala_do_statement_get_condition (stmt)->temp_vars);
}


static void vala_ccode_control_flow_module_real_visit_for_statement (ValaCCodeModule* base, ValaForStatement* stmt) {
	ValaCCodeControlFlowModule * self;
	ValaCCodeExpression* ccondition;
	ValaCCodeForStatement* cfor;
	self = (ValaCCodeControlFlowModule*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	ccondition = NULL;
	if (vala_for_statement_get_condition (stmt) != NULL) {
		ValaCCodeExpression* _tmp1;
		ValaCCodeExpression* _tmp0;
		_tmp1 = NULL;
		_tmp0 = NULL;
		ccondition = (_tmp1 = (_tmp0 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_for_statement_get_condition (stmt))), (_tmp0 == NULL) ? NULL : vala_ccode_node_ref (_tmp0)), (ccondition == NULL) ? NULL : (ccondition = (vala_ccode_node_unref (ccondition), NULL)), _tmp1);
	}
	cfor = vala_ccode_for_statement_new (ccondition, VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_for_statement_get_body (stmt))));
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cfor);
	{
		GeeList* _tmp2;
		GeeIterator* _tmp3;
		GeeIterator* _init_expr_it;
		_tmp2 = NULL;
		_tmp3 = NULL;
		_init_expr_it = (_tmp3 = gee_iterable_iterator ((GeeIterable*) (_tmp2 = vala_for_statement_get_initializer (stmt))), (_tmp2 == NULL) ? NULL : (_tmp2 = (gee_collection_object_unref (_tmp2), NULL)), _tmp3);
		while (gee_iterator_next (_init_expr_it)) {
			ValaExpression* init_expr;
			init_expr = (ValaExpression*) gee_iterator_get (_init_expr_it);
			vala_ccode_for_statement_add_initializer (cfor, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) init_expr)));
			vala_ccode_base_module_create_temp_decl ((ValaCCodeBaseModule*) self, (ValaStatement*) stmt, (GeeList*) init_expr->temp_vars);
			(init_expr == NULL) ? NULL : (init_expr = (vala_code_node_unref (init_expr), NULL));
		}
		(_init_expr_it == NULL) ? NULL : (_init_expr_it = (gee_collection_object_unref (_init_expr_it), NULL));
	}
	{
		GeeList* _tmp4;
		GeeIterator* _tmp5;
		GeeIterator* _it_expr_it;
		_tmp4 = NULL;
		_tmp5 = NULL;
		_it_expr_it = (_tmp5 = gee_iterable_iterator ((GeeIterable*) (_tmp4 = vala_for_statement_get_iterator (stmt))), (_tmp4 == NULL) ? NULL : (_tmp4 = (gee_collection_object_unref (_tmp4), NULL)), _tmp5);
		while (gee_iterator_next (_it_expr_it)) {
			ValaExpression* it_expr;
			it_expr = (ValaExpression*) gee_iterator_get (_it_expr_it);
			vala_ccode_for_statement_add_iterator (cfor, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) it_expr)));
			vala_ccode_base_module_create_temp_decl ((ValaCCodeBaseModule*) self, (ValaStatement*) stmt, (GeeList*) it_expr->temp_vars);
			(it_expr == NULL) ? NULL : (it_expr = (vala_code_node_unref (it_expr), NULL));
		}
		(_it_expr_it == NULL) ? NULL : (_it_expr_it = (gee_collection_object_unref (_it_expr_it), NULL));
	}
	if (vala_for_statement_get_condition (stmt) != NULL) {
		vala_ccode_base_module_create_temp_decl ((ValaCCodeBaseModule*) self, (ValaStatement*) stmt, (GeeList*) vala_for_statement_get_condition (stmt)->temp_vars);
	}
	(ccondition == NULL) ? NULL : (ccondition = (vala_ccode_node_unref (ccondition), NULL));
	(cfor == NULL) ? NULL : (cfor = (vala_ccode_node_unref (cfor), NULL));
}


static void vala_ccode_control_flow_module_real_visit_foreach_statement (ValaCCodeModule* base, ValaForeachStatement* stmt) {
	ValaCCodeControlFlowModule * self;
	ValaCCodeBlock* cblock;
	ValaCCodeFragment* cfrag;
	ValaLocalVariable* _tmp0;
	ValaLocalVariable* collection_backup;
	ValaDataType* collection_type;
	char* _tmp1;
	ValaCCodeDeclaration* _tmp2;
	ValaCCodeDeclaration* ccoldecl;
	ValaCCodeVariableDeclarator* ccolvardecl;
	gboolean _tmp3;
	self = (ValaCCodeControlFlowModule*) base;
	g_return_if_fail (stmt != NULL);
	vala_symbol_set_active ((ValaSymbol*) vala_foreach_statement_get_element_variable (stmt), TRUE);
	vala_symbol_set_active ((ValaSymbol*) vala_foreach_statement_get_collection_variable (stmt), TRUE);
	if (vala_foreach_statement_get_iterator_variable (stmt) != NULL) {
		vala_symbol_set_active ((ValaSymbol*) vala_foreach_statement_get_iterator_variable (stmt), TRUE);
	}
	vala_ccode_module_visit_block ((ValaCCodeModule*) self, (ValaBlock*) stmt);
	cblock = vala_ccode_block_new ();
	/* sets #line*/
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cblock);
	cfrag = vala_ccode_fragment_new ();
	vala_ccode_base_module_append_temp_decl ((ValaCCodeBaseModule*) self, cfrag, (GeeList*) vala_foreach_statement_get_collection (stmt)->temp_vars);
	vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) cfrag);
	_tmp0 = NULL;
	collection_backup = (_tmp0 = vala_foreach_statement_get_collection_variable (stmt), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	collection_type = vala_data_type_copy (vala_local_variable_get_variable_type (collection_backup));
	_tmp1 = NULL;
	_tmp2 = NULL;
	ccoldecl = (_tmp2 = vala_ccode_declaration_new (_tmp1 = vala_data_type_get_cname (collection_type)), _tmp1 = (g_free (_tmp1), NULL), _tmp2);
	ccolvardecl = vala_ccode_variable_declarator_new_with_initializer (vala_symbol_get_name ((ValaSymbol*) collection_backup), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_foreach_statement_get_collection (stmt))));
	vala_ccode_node_set_line ((ValaCCodeNode*) ccolvardecl, vala_ccode_node_get_line ((ValaCCodeNode*) cblock));
	vala_ccode_declaration_add_declarator (ccoldecl, (ValaCCodeDeclarator*) ccolvardecl);
	vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) ccoldecl);
	_tmp3 = FALSE;
	if (vala_code_node_get_tree_can_fail ((ValaCodeNode*) stmt)) {
		_tmp3 = vala_code_node_get_tree_can_fail ((ValaCodeNode*) vala_foreach_statement_get_collection (stmt));
	} else {
		_tmp3 = FALSE;
	}
	if (_tmp3) {
		ValaCCodeFragment* _tmp4;
		/* exception handling*/
		_tmp4 = NULL;
		cfrag = (_tmp4 = vala_ccode_fragment_new (), (cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL)), _tmp4);
		vala_ccode_module_add_simple_check (vala_ccode_module_get_head ((ValaCCodeModule*) self), (ValaCodeNode*) vala_foreach_statement_get_collection (stmt), cfrag);
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) cfrag);
	}
	if (VALA_IS_ARRAY_TYPE (vala_expression_get_value_type (vala_foreach_statement_get_collection (stmt)))) {
		ValaArrayType* _tmp5;
		ValaArrayType* array_type;
		ValaCCodeExpression* array_len;
		ValaCCodeDeclaration* clendecl;
		ValaCCodeVariableDeclarator* _tmp7;
		char* _tmp6;
		_tmp5 = NULL;
		array_type = (_tmp5 = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_foreach_statement_get_collection (stmt))), (_tmp5 == NULL) ? NULL : vala_code_node_ref (_tmp5));
		array_len = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_foreach_statement_get_collection (stmt), -1);
		/* store array length for use by _vala_array_free*/
		clendecl = vala_ccode_declaration_new ("int");
		_tmp7 = NULL;
		_tmp6 = NULL;
		vala_ccode_declaration_add_declarator (clendecl, (ValaCCodeDeclarator*) (_tmp7 = vala_ccode_variable_declarator_new_with_initializer (_tmp6 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_symbol_get_name ((ValaSymbol*) collection_backup), 1), array_len)));
		(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
		_tmp6 = (g_free (_tmp6), NULL);
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) clendecl);
		if (VALA_IS_CCODE_CONSTANT (array_len)) {
			char* it_name;
			char* _tmp8;
			ValaCCodeDeclaration* _tmp9;
			ValaCCodeDeclaration* citdecl;
			ValaCCodeVariableDeclarator* _tmp10;
			ValaCCodeBlock* cbody;
			char* _tmp11;
			ValaCCodeExpression* _tmp12;
			ValaCCodeExpression* element_expr;
			ValaDataType* element_type;
			ValaCCodeExpression* _tmp13;
			ValaCCodeFragment* _tmp14;
			char* _tmp15;
			ValaCCodeDeclaration* _tmp16;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp17;
			ValaCCodeConstant* _tmp25;
			ValaCCodeIdentifier* _tmp24;
			char* _tmp23;
			ValaCCodeBinaryExpression* _tmp26;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeForStatement* cfor;
			ValaCCodeAssignment* _tmp29;
			ValaCCodeIdentifier* _tmp28;
			ValaCCodeIdentifier* _tmp27;
			ValaCCodeAssignment* _tmp34;
			ValaCCodeBinaryExpression* _tmp33;
			ValaCCodeConstant* _tmp32;
			ValaCCodeIdentifier* _tmp31;
			ValaCCodeIdentifier* _tmp30;
			/* the array has no length parameter i.e. it is NULL-terminated array*/
			it_name = g_strdup_printf ("%s_it", vala_foreach_statement_get_variable_name (stmt));
			_tmp8 = NULL;
			_tmp9 = NULL;
			citdecl = (_tmp9 = vala_ccode_declaration_new (_tmp8 = vala_data_type_get_cname (collection_type)), _tmp8 = (g_free (_tmp8), NULL), _tmp9);
			_tmp10 = NULL;
			vala_ccode_declaration_add_declarator (citdecl, (ValaCCodeDeclarator*) (_tmp10 = vala_ccode_variable_declarator_new (it_name)));
			(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
			vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) citdecl);
			cbody = vala_ccode_block_new ();
			_tmp11 = NULL;
			_tmp12 = NULL;
			element_expr = (_tmp12 = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp11 = g_strdup_printf ("*%s", it_name)), _tmp11 = (g_free (_tmp11), NULL), _tmp12);
			element_type = vala_data_type_copy (vala_array_type_get_element_type (array_type));
			vala_data_type_set_value_owned (element_type, FALSE);
			_tmp13 = NULL;
			element_expr = (_tmp13 = vala_ccode_base_module_transform_expression ((ValaCCodeBaseModule*) self, element_expr, element_type, vala_foreach_statement_get_type_reference (stmt), NULL), (element_expr == NULL) ? NULL : (element_expr = (vala_ccode_node_unref (element_expr), NULL)), _tmp13);
			_tmp14 = NULL;
			cfrag = (_tmp14 = vala_ccode_fragment_new (), (cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL)), _tmp14);
			vala_ccode_base_module_append_temp_decl ((ValaCCodeBaseModule*) self, cfrag, (GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars);
			vala_ccode_block_add_statement (cbody, (ValaCCodeNode*) cfrag);
			gee_collection_clear ((GeeCollection*) ((ValaCCodeBaseModule*) self)->temp_vars);
			_tmp15 = NULL;
			_tmp16 = NULL;
			cdecl_ = (_tmp16 = vala_ccode_declaration_new (_tmp15 = vala_data_type_get_cname (vala_foreach_statement_get_type_reference (stmt))), _tmp15 = (g_free (_tmp15), NULL), _tmp16);
			_tmp17 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp17 = vala_ccode_variable_declarator_new_with_initializer (vala_foreach_statement_get_variable_name (stmt), element_expr)));
			(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
			vala_ccode_block_add_statement (cbody, (ValaCCodeNode*) cdecl_);
			/* add array length variable for stacked arrays*/
			if (VALA_IS_ARRAY_TYPE (vala_foreach_statement_get_type_reference (stmt))) {
				ValaArrayType* _tmp18;
				ValaArrayType* inner_array_type;
				_tmp18 = NULL;
				inner_array_type = (_tmp18 = VALA_ARRAY_TYPE (vala_foreach_statement_get_type_reference (stmt)), (_tmp18 == NULL) ? NULL : vala_code_node_ref (_tmp18));
				{
					gint dim;
					dim = 1;
					for (; dim <= vala_array_type_get_rank (inner_array_type); dim++) {
						ValaCCodeDeclaration* _tmp19;
						ValaCCodeVariableDeclarator* _tmp22;
						ValaCCodeConstant* _tmp21;
						char* _tmp20;
						_tmp19 = NULL;
						cdecl_ = (_tmp19 = vala_ccode_declaration_new ("int"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp19);
						_tmp22 = NULL;
						_tmp21 = NULL;
						_tmp20 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp22 = vala_ccode_variable_declarator_new_with_initializer (_tmp20 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_foreach_statement_get_variable_name (stmt), dim), (ValaCCodeExpression*) (_tmp21 = vala_ccode_constant_new ("-1")))));
						(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
						(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
						_tmp20 = (g_free (_tmp20), NULL);
						vala_ccode_block_add_statement (cbody, (ValaCCodeNode*) cdecl_);
					}
				}
				(inner_array_type == NULL) ? NULL : (inner_array_type = (vala_code_node_unref (inner_array_type), NULL));
			}
			vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode ((ValaCodeNode*) vala_foreach_statement_get_body (stmt)));
			_tmp25 = NULL;
			_tmp24 = NULL;
			_tmp23 = NULL;
			_tmp26 = NULL;
			ccond = (_tmp26 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) (_tmp24 = vala_ccode_identifier_new (_tmp23 = g_strdup_printf ("*%s", it_name))), (ValaCCodeExpression*) (_tmp25 = vala_ccode_constant_new ("NULL"))), (_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL)), (_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL)), _tmp23 = (g_free (_tmp23), NULL), _tmp26);
			cfor = vala_ccode_for_statement_new ((ValaCCodeExpression*) ccond, (ValaCCodeStatement*) cbody);
			_tmp29 = NULL;
			_tmp28 = NULL;
			_tmp27 = NULL;
			vala_ccode_for_statement_add_initializer (cfor, (ValaCCodeExpression*) (_tmp29 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp27 = vala_ccode_identifier_new (it_name)), (ValaCCodeExpression*) (_tmp28 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) collection_backup))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
			(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
			(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
			(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
			_tmp34 = NULL;
			_tmp33 = NULL;
			_tmp32 = NULL;
			_tmp31 = NULL;
			_tmp30 = NULL;
			vala_ccode_for_statement_add_iterator (cfor, (ValaCCodeExpression*) (_tmp34 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp30 = vala_ccode_identifier_new (it_name)), (ValaCCodeExpression*) (_tmp33 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) (_tmp31 = vala_ccode_identifier_new (it_name)), (ValaCCodeExpression*) (_tmp32 = vala_ccode_constant_new ("1")))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
			(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
			(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
			(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
			(_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL));
			(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
			vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) cfor);
			it_name = (g_free (it_name), NULL);
			(citdecl == NULL) ? NULL : (citdecl = (vala_ccode_node_unref (citdecl), NULL));
			(cbody == NULL) ? NULL : (cbody = (vala_ccode_node_unref (cbody), NULL));
			(element_expr == NULL) ? NULL : (element_expr = (vala_ccode_node_unref (element_expr), NULL));
			(element_type == NULL) ? NULL : (element_type = (vala_code_node_unref (element_type), NULL));
			(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
			(ccond == NULL) ? NULL : (ccond = (vala_ccode_node_unref (ccond), NULL));
			(cfor == NULL) ? NULL : (cfor = (vala_ccode_node_unref (cfor), NULL));
		} else {
			char* it_name;
			ValaCCodeDeclaration* citdecl;
			ValaCCodeVariableDeclarator* _tmp35;
			ValaCCodeBlock* cbody;
			ValaCCodeIdentifier* _tmp37;
			ValaCCodeIdentifier* _tmp36;
			ValaCCodeExpression* _tmp38;
			ValaCCodeExpression* element_expr;
			ValaDataType* element_type;
			ValaCCodeExpression* _tmp39;
			ValaCCodeFragment* _tmp40;
			char* _tmp41;
			ValaCCodeDeclaration* _tmp42;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp43;
			ValaCCodeConstant* _tmp49;
			ValaCCodeBinaryExpression* _tmp50;
			ValaCCodeBinaryExpression* ccond_ind1;
			ValaCCodeIdentifier* _tmp51;
			ValaCCodeBinaryExpression* _tmp52;
			ValaCCodeBinaryExpression* ccond_ind2;
			ValaCCodeBinaryExpression* ccond_ind;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeForStatement* cfor;
			ValaCCodeAssignment* _tmp68;
			ValaCCodeConstant* _tmp67;
			ValaCCodeIdentifier* _tmp66;
			ValaCCodeAssignment* _tmp73;
			ValaCCodeBinaryExpression* _tmp72;
			ValaCCodeConstant* _tmp71;
			ValaCCodeIdentifier* _tmp70;
			ValaCCodeIdentifier* _tmp69;
			/* the array has a length parameter*/
			it_name = (g_strconcat (vala_foreach_statement_get_variable_name (stmt), "_it", NULL));
			citdecl = vala_ccode_declaration_new ("int");
			_tmp35 = NULL;
			vala_ccode_declaration_add_declarator (citdecl, (ValaCCodeDeclarator*) (_tmp35 = vala_ccode_variable_declarator_new (it_name)));
			(_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL));
			vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) citdecl);
			cbody = vala_ccode_block_new ();
			_tmp37 = NULL;
			_tmp36 = NULL;
			_tmp38 = NULL;
			element_expr = (_tmp38 = (ValaCCodeExpression*) vala_ccode_element_access_new ((ValaCCodeExpression*) (_tmp36 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) collection_backup))), (ValaCCodeExpression*) (_tmp37 = vala_ccode_identifier_new (it_name))), (_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL)), (_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL)), _tmp38);
			element_type = vala_data_type_copy (vala_array_type_get_element_type (array_type));
			vala_data_type_set_value_owned (element_type, FALSE);
			_tmp39 = NULL;
			element_expr = (_tmp39 = vala_ccode_base_module_transform_expression ((ValaCCodeBaseModule*) self, element_expr, element_type, vala_foreach_statement_get_type_reference (stmt), NULL), (element_expr == NULL) ? NULL : (element_expr = (vala_ccode_node_unref (element_expr), NULL)), _tmp39);
			_tmp40 = NULL;
			cfrag = (_tmp40 = vala_ccode_fragment_new (), (cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL)), _tmp40);
			vala_ccode_base_module_append_temp_decl ((ValaCCodeBaseModule*) self, cfrag, (GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars);
			vala_ccode_block_add_statement (cbody, (ValaCCodeNode*) cfrag);
			gee_collection_clear ((GeeCollection*) ((ValaCCodeBaseModule*) self)->temp_vars);
			_tmp41 = NULL;
			_tmp42 = NULL;
			cdecl_ = (_tmp42 = vala_ccode_declaration_new (_tmp41 = vala_data_type_get_cname (vala_foreach_statement_get_type_reference (stmt))), _tmp41 = (g_free (_tmp41), NULL), _tmp42);
			_tmp43 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp43 = vala_ccode_variable_declarator_new_with_initializer (vala_foreach_statement_get_variable_name (stmt), element_expr)));
			(_tmp43 == NULL) ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL));
			vala_ccode_block_add_statement (cbody, (ValaCCodeNode*) cdecl_);
			/* add array length variable for stacked arrays*/
			if (VALA_IS_ARRAY_TYPE (vala_foreach_statement_get_type_reference (stmt))) {
				ValaArrayType* _tmp44;
				ValaArrayType* inner_array_type;
				_tmp44 = NULL;
				inner_array_type = (_tmp44 = VALA_ARRAY_TYPE (vala_foreach_statement_get_type_reference (stmt)), (_tmp44 == NULL) ? NULL : vala_code_node_ref (_tmp44));
				{
					gint dim;
					dim = 1;
					for (; dim <= vala_array_type_get_rank (inner_array_type); dim++) {
						ValaCCodeDeclaration* _tmp45;
						ValaCCodeVariableDeclarator* _tmp48;
						ValaCCodeConstant* _tmp47;
						char* _tmp46;
						_tmp45 = NULL;
						cdecl_ = (_tmp45 = vala_ccode_declaration_new ("int"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp45);
						_tmp48 = NULL;
						_tmp47 = NULL;
						_tmp46 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp48 = vala_ccode_variable_declarator_new_with_initializer (_tmp46 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_foreach_statement_get_variable_name (stmt), dim), (ValaCCodeExpression*) (_tmp47 = vala_ccode_constant_new ("-1")))));
						(_tmp48 == NULL) ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL));
						(_tmp47 == NULL) ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL));
						_tmp46 = (g_free (_tmp46), NULL);
						vala_ccode_block_add_statement (cbody, (ValaCCodeNode*) cdecl_);
					}
				}
				(inner_array_type == NULL) ? NULL : (inner_array_type = (vala_code_node_unref (inner_array_type), NULL));
			}
			vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode ((ValaCodeNode*) vala_foreach_statement_get_body (stmt)));
			_tmp49 = NULL;
			_tmp50 = NULL;
			ccond_ind1 = (_tmp50 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, array_len, (ValaCCodeExpression*) (_tmp49 = vala_ccode_constant_new ("-1"))), (_tmp49 == NULL) ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL)), _tmp50);
			_tmp51 = NULL;
			_tmp52 = NULL;
			ccond_ind2 = (_tmp52 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, (ValaCCodeExpression*) (_tmp51 = vala_ccode_identifier_new (it_name)), array_len), (_tmp51 == NULL) ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL)), _tmp52);
			ccond_ind = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_AND, (ValaCCodeExpression*) ccond_ind1, (ValaCCodeExpression*) ccond_ind2);
			/* only check for null if the containers elements are of reference-type */
			ccond = NULL;
			if (vala_data_type_is_reference_type_or_type_parameter (vala_array_type_get_element_type (array_type))) {
				ValaCCodeConstant* _tmp53;
				ValaCCodeBinaryExpression* _tmp54;
				ValaCCodeBinaryExpression* ccond_term1;
				ValaCCodeConstant* _tmp58;
				ValaCCodeElementAccess* _tmp57;
				ValaCCodeIdentifier* _tmp56;
				ValaCCodeIdentifier* _tmp55;
				ValaCCodeBinaryExpression* _tmp59;
				ValaCCodeBinaryExpression* ccond_term2;
				ValaCCodeBinaryExpression* ccond_term;
				ValaCCodeBinaryExpression* _tmp60;
				_tmp53 = NULL;
				_tmp54 = NULL;
				ccond_term1 = (_tmp54 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, array_len, (ValaCCodeExpression*) (_tmp53 = vala_ccode_constant_new ("-1"))), (_tmp53 == NULL) ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL)), _tmp54);
				_tmp58 = NULL;
				_tmp57 = NULL;
				_tmp56 = NULL;
				_tmp55 = NULL;
				_tmp59 = NULL;
				ccond_term2 = (_tmp59 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) (_tmp57 = vala_ccode_element_access_new ((ValaCCodeExpression*) (_tmp55 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) collection_backup))), (ValaCCodeExpression*) (_tmp56 = vala_ccode_identifier_new (it_name)))), (ValaCCodeExpression*) (_tmp58 = vala_ccode_constant_new ("NULL"))), (_tmp58 == NULL) ? NULL : (_tmp58 = (vala_ccode_node_unref (_tmp58), NULL)), (_tmp57 == NULL) ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL)), (_tmp56 == NULL) ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL)), (_tmp55 == NULL) ? NULL : (_tmp55 = (vala_ccode_node_unref (_tmp55), NULL)), _tmp59);
				ccond_term = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_AND, (ValaCCodeExpression*) ccond_term1, (ValaCCodeExpression*) ccond_term2);
				_tmp60 = NULL;
				ccond = (_tmp60 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, (ValaCCodeExpression*) ccond_ind, (ValaCCodeExpression*) ccond_term), (ccond == NULL) ? NULL : (ccond = (vala_ccode_node_unref (ccond), NULL)), _tmp60);
				(ccond_term1 == NULL) ? NULL : (ccond_term1 = (vala_ccode_node_unref (ccond_term1), NULL));
				(ccond_term2 == NULL) ? NULL : (ccond_term2 = (vala_ccode_node_unref (ccond_term2), NULL));
				(ccond_term == NULL) ? NULL : (ccond_term = (vala_ccode_node_unref (ccond_term), NULL));
			} else {
				ValaCCodeIdentifier* _tmp61;
				ValaCCodeFunctionCall* _tmp62;
				ValaCCodeFunctionCall* cassert;
				ValaCCodeExpressionStatement* _tmp63;
				ValaCCodeBinaryExpression* _tmp65;
				ValaCCodeBinaryExpression* _tmp64;
				/* assert when trying to iterate over value-type arrays of unknown length */
				_tmp61 = NULL;
				_tmp62 = NULL;
				cassert = (_tmp62 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp61 = vala_ccode_identifier_new ("g_assert"))), (_tmp61 == NULL) ? NULL : (_tmp61 = (vala_ccode_node_unref (_tmp61), NULL)), _tmp62);
				vala_ccode_function_call_add_argument (cassert, (ValaCCodeExpression*) ccond_ind1);
				_tmp63 = NULL;
				vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp63 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cassert)));
				(_tmp63 == NULL) ? NULL : (_tmp63 = (vala_ccode_node_unref (_tmp63), NULL));
				_tmp65 = NULL;
				_tmp64 = NULL;
				ccond = (_tmp65 = (_tmp64 = ccond_ind2, (_tmp64 == NULL) ? NULL : vala_ccode_node_ref (_tmp64)), (ccond == NULL) ? NULL : (ccond = (vala_ccode_node_unref (ccond), NULL)), _tmp65);
				(cassert == NULL) ? NULL : (cassert = (vala_ccode_node_unref (cassert), NULL));
			}
			cfor = vala_ccode_for_statement_new ((ValaCCodeExpression*) ccond, (ValaCCodeStatement*) cbody);
			_tmp68 = NULL;
			_tmp67 = NULL;
			_tmp66 = NULL;
			vala_ccode_for_statement_add_initializer (cfor, (ValaCCodeExpression*) (_tmp68 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp66 = vala_ccode_identifier_new (it_name)), (ValaCCodeExpression*) (_tmp67 = vala_ccode_constant_new ("0")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
			(_tmp68 == NULL) ? NULL : (_tmp68 = (vala_ccode_node_unref (_tmp68), NULL));
			(_tmp67 == NULL) ? NULL : (_tmp67 = (vala_ccode_node_unref (_tmp67), NULL));
			(_tmp66 == NULL) ? NULL : (_tmp66 = (vala_ccode_node_unref (_tmp66), NULL));
			_tmp73 = NULL;
			_tmp72 = NULL;
			_tmp71 = NULL;
			_tmp70 = NULL;
			_tmp69 = NULL;
			vala_ccode_for_statement_add_iterator (cfor, (ValaCCodeExpression*) (_tmp73 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp69 = vala_ccode_identifier_new (it_name)), (ValaCCodeExpression*) (_tmp72 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) (_tmp70 = vala_ccode_identifier_new (it_name)), (ValaCCodeExpression*) (_tmp71 = vala_ccode_constant_new ("1")))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
			(_tmp73 == NULL) ? NULL : (_tmp73 = (vala_ccode_node_unref (_tmp73), NULL));
			(_tmp72 == NULL) ? NULL : (_tmp72 = (vala_ccode_node_unref (_tmp72), NULL));
			(_tmp71 == NULL) ? NULL : (_tmp71 = (vala_ccode_node_unref (_tmp71), NULL));
			(_tmp70 == NULL) ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL));
			(_tmp69 == NULL) ? NULL : (_tmp69 = (vala_ccode_node_unref (_tmp69), NULL));
			vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) cfor);
			it_name = (g_free (it_name), NULL);
			(citdecl == NULL) ? NULL : (citdecl = (vala_ccode_node_unref (citdecl), NULL));
			(cbody == NULL) ? NULL : (cbody = (vala_ccode_node_unref (cbody), NULL));
			(element_expr == NULL) ? NULL : (element_expr = (vala_ccode_node_unref (element_expr), NULL));
			(element_type == NULL) ? NULL : (element_type = (vala_code_node_unref (element_type), NULL));
			(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
			(ccond_ind1 == NULL) ? NULL : (ccond_ind1 = (vala_ccode_node_unref (ccond_ind1), NULL));
			(ccond_ind2 == NULL) ? NULL : (ccond_ind2 = (vala_ccode_node_unref (ccond_ind2), NULL));
			(ccond_ind == NULL) ? NULL : (ccond_ind = (vala_ccode_node_unref (ccond_ind), NULL));
			(ccond == NULL) ? NULL : (ccond = (vala_ccode_node_unref (ccond), NULL));
			(cfor == NULL) ? NULL : (cfor = (vala_ccode_node_unref (cfor), NULL));
		}
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		(array_len == NULL) ? NULL : (array_len = (vala_ccode_node_unref (array_len), NULL));
		(clendecl == NULL) ? NULL : (clendecl = (vala_ccode_node_unref (clendecl), NULL));
	} else {
		gboolean _tmp74;
		ValaObjectType* _tmp75;
		gboolean _tmp76;
		_tmp74 = FALSE;
		_tmp75 = NULL;
		if ((_tmp76 = vala_data_type_compatible (vala_expression_get_value_type (vala_foreach_statement_get_collection (stmt)), (ValaDataType*) (_tmp75 = vala_object_type_new ((ValaObjectTypeSymbol*) ((ValaCCodeBaseModule*) self)->glist_type))), (_tmp75 == NULL) ? NULL : (_tmp75 = (vala_code_node_unref (_tmp75), NULL)), _tmp76)) {
			_tmp74 = TRUE;
		} else {
			ValaObjectType* _tmp77;
			_tmp77 = NULL;
			_tmp74 = vala_data_type_compatible (vala_expression_get_value_type (vala_foreach_statement_get_collection (stmt)), (ValaDataType*) (_tmp77 = vala_object_type_new ((ValaObjectTypeSymbol*) ((ValaCCodeBaseModule*) self)->gslist_type)));
			(_tmp77 == NULL) ? NULL : (_tmp77 = (vala_code_node_unref (_tmp77), NULL));
		}
		if (_tmp74) {
			char* it_name;
			char* _tmp78;
			ValaCCodeDeclaration* _tmp79;
			ValaCCodeDeclaration* citdecl;
			ValaCCodeVariableDeclarator* citvardecl;
			ValaCCodeBlock* cbody;
			ValaCCodeIdentifier* _tmp80;
			ValaCCodeExpression* _tmp81;
			ValaCCodeExpression* element_expr;
			GeeList* _tmp82;
			gboolean _tmp83;
			ValaDataType* _tmp85;
			GeeList* _tmp84;
			ValaDataType* _tmp86;
			ValaDataType* element_data_type;
			ValaCCodeExpression* _tmp87;
			ValaCCodeExpression* _tmp88;
			ValaCCodeFragment* _tmp89;
			char* _tmp90;
			ValaCCodeDeclaration* _tmp91;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* cvardecl;
			ValaCCodeConstant* _tmp93;
			ValaCCodeIdentifier* _tmp92;
			ValaCCodeBinaryExpression* _tmp94;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeForStatement* cfor;
			ValaCCodeAssignment* _tmp97;
			ValaCCodeIdentifier* _tmp96;
			ValaCCodeIdentifier* _tmp95;
			ValaCCodeAssignment* _tmp101;
			ValaCCodeMemberAccess* _tmp100;
			ValaCCodeIdentifier* _tmp99;
			ValaCCodeIdentifier* _tmp98;
			/* iterating over a GList or GSList*/
			it_name = g_strdup_printf ("%s_it", vala_foreach_statement_get_variable_name (stmt));
			_tmp78 = NULL;
			_tmp79 = NULL;
			citdecl = (_tmp79 = vala_ccode_declaration_new (_tmp78 = vala_data_type_get_cname (collection_type)), _tmp78 = (g_free (_tmp78), NULL), _tmp79);
			citvardecl = vala_ccode_variable_declarator_new (it_name);
			vala_ccode_node_set_line ((ValaCCodeNode*) citvardecl, vala_ccode_node_get_line ((ValaCCodeNode*) cblock));
			vala_ccode_declaration_add_declarator (citdecl, (ValaCCodeDeclarator*) citvardecl);
			vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) citdecl);
			cbody = vala_ccode_block_new ();
			_tmp80 = NULL;
			_tmp81 = NULL;
			element_expr = (_tmp81 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp80 = vala_ccode_identifier_new (it_name)), "data"), (_tmp80 == NULL) ? NULL : (_tmp80 = (vala_ccode_node_unref (_tmp80), NULL)), _tmp81);
			_tmp82 = NULL;
			if ((_tmp83 = gee_collection_get_size ((GeeCollection*) (_tmp82 = vala_data_type_get_type_arguments (collection_type))) != 1, (_tmp82 == NULL) ? NULL : (_tmp82 = (gee_collection_object_unref (_tmp82), NULL)), _tmp83)) {
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) stmt), "internal error: missing generic type argument");
				vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
				it_name = (g_free (it_name), NULL);
				(citdecl == NULL) ? NULL : (citdecl = (vala_ccode_node_unref (citdecl), NULL));
				(citvardecl == NULL) ? NULL : (citvardecl = (vala_ccode_node_unref (citvardecl), NULL));
				(cbody == NULL) ? NULL : (cbody = (vala_ccode_node_unref (cbody), NULL));
				(element_expr == NULL) ? NULL : (element_expr = (vala_ccode_node_unref (element_expr), NULL));
				(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
				(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
				(collection_backup == NULL) ? NULL : (collection_backup = (vala_code_node_unref (collection_backup), NULL));
				(collection_type == NULL) ? NULL : (collection_type = (vala_code_node_unref (collection_type), NULL));
				(ccoldecl == NULL) ? NULL : (ccoldecl = (vala_ccode_node_unref (ccoldecl), NULL));
				(ccolvardecl == NULL) ? NULL : (ccolvardecl = (vala_ccode_node_unref (ccolvardecl), NULL));
				return;
			}
			_tmp85 = NULL;
			_tmp84 = NULL;
			_tmp86 = NULL;
			element_data_type = (_tmp86 = vala_data_type_copy (_tmp85 = (ValaDataType*) gee_list_get (_tmp84 = vala_data_type_get_type_arguments (collection_type), 0)), (_tmp85 == NULL) ? NULL : (_tmp85 = (vala_code_node_unref (_tmp85), NULL)), (_tmp84 == NULL) ? NULL : (_tmp84 = (gee_collection_object_unref (_tmp84), NULL)), _tmp86);
			vala_data_type_set_value_owned (element_data_type, FALSE);
			_tmp87 = NULL;
			element_expr = (_tmp87 = vala_ccode_base_module_convert_from_generic_pointer ((ValaCCodeBaseModule*) self, element_expr, element_data_type), (element_expr == NULL) ? NULL : (element_expr = (vala_ccode_node_unref (element_expr), NULL)), _tmp87);
			_tmp88 = NULL;
			element_expr = (_tmp88 = vala_ccode_base_module_transform_expression ((ValaCCodeBaseModule*) self, element_expr, element_data_type, vala_foreach_statement_get_type_reference (stmt), NULL), (element_expr == NULL) ? NULL : (element_expr = (vala_ccode_node_unref (element_expr), NULL)), _tmp88);
			_tmp89 = NULL;
			cfrag = (_tmp89 = vala_ccode_fragment_new (), (cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL)), _tmp89);
			vala_ccode_base_module_append_temp_decl ((ValaCCodeBaseModule*) self, cfrag, (GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars);
			vala_ccode_block_add_statement (cbody, (ValaCCodeNode*) cfrag);
			gee_collection_clear ((GeeCollection*) ((ValaCCodeBaseModule*) self)->temp_vars);
			_tmp90 = NULL;
			_tmp91 = NULL;
			cdecl_ = (_tmp91 = vala_ccode_declaration_new (_tmp90 = vala_data_type_get_cname (vala_foreach_statement_get_type_reference (stmt))), _tmp90 = (g_free (_tmp90), NULL), _tmp91);
			cvardecl = vala_ccode_variable_declarator_new_with_initializer (vala_foreach_statement_get_variable_name (stmt), element_expr);
			vala_ccode_node_set_line ((ValaCCodeNode*) cvardecl, vala_ccode_node_get_line ((ValaCCodeNode*) cblock));
			vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) cvardecl);
			vala_ccode_block_add_statement (cbody, (ValaCCodeNode*) cdecl_);
			vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode ((ValaCodeNode*) vala_foreach_statement_get_body (stmt)));
			_tmp93 = NULL;
			_tmp92 = NULL;
			_tmp94 = NULL;
			ccond = (_tmp94 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) (_tmp92 = vala_ccode_identifier_new (it_name)), (ValaCCodeExpression*) (_tmp93 = vala_ccode_constant_new ("NULL"))), (_tmp93 == NULL) ? NULL : (_tmp93 = (vala_ccode_node_unref (_tmp93), NULL)), (_tmp92 == NULL) ? NULL : (_tmp92 = (vala_ccode_node_unref (_tmp92), NULL)), _tmp94);
			cfor = vala_ccode_for_statement_new ((ValaCCodeExpression*) ccond, (ValaCCodeStatement*) cbody);
			_tmp97 = NULL;
			_tmp96 = NULL;
			_tmp95 = NULL;
			vala_ccode_for_statement_add_initializer (cfor, (ValaCCodeExpression*) (_tmp97 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp95 = vala_ccode_identifier_new (it_name)), (ValaCCodeExpression*) (_tmp96 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) collection_backup))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
			(_tmp97 == NULL) ? NULL : (_tmp97 = (vala_ccode_node_unref (_tmp97), NULL));
			(_tmp96 == NULL) ? NULL : (_tmp96 = (vala_ccode_node_unref (_tmp96), NULL));
			(_tmp95 == NULL) ? NULL : (_tmp95 = (vala_ccode_node_unref (_tmp95), NULL));
			_tmp101 = NULL;
			_tmp100 = NULL;
			_tmp99 = NULL;
			_tmp98 = NULL;
			vala_ccode_for_statement_add_iterator (cfor, (ValaCCodeExpression*) (_tmp101 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp98 = vala_ccode_identifier_new (it_name)), (ValaCCodeExpression*) (_tmp100 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp99 = vala_ccode_identifier_new (it_name)), "next")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
			(_tmp101 == NULL) ? NULL : (_tmp101 = (vala_ccode_node_unref (_tmp101), NULL));
			(_tmp100 == NULL) ? NULL : (_tmp100 = (vala_ccode_node_unref (_tmp100), NULL));
			(_tmp99 == NULL) ? NULL : (_tmp99 = (vala_ccode_node_unref (_tmp99), NULL));
			(_tmp98 == NULL) ? NULL : (_tmp98 = (vala_ccode_node_unref (_tmp98), NULL));
			vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) cfor);
			it_name = (g_free (it_name), NULL);
			(citdecl == NULL) ? NULL : (citdecl = (vala_ccode_node_unref (citdecl), NULL));
			(citvardecl == NULL) ? NULL : (citvardecl = (vala_ccode_node_unref (citvardecl), NULL));
			(cbody == NULL) ? NULL : (cbody = (vala_ccode_node_unref (cbody), NULL));
			(element_expr == NULL) ? NULL : (element_expr = (vala_ccode_node_unref (element_expr), NULL));
			(element_data_type == NULL) ? NULL : (element_data_type = (vala_code_node_unref (element_data_type), NULL));
			(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
			(cvardecl == NULL) ? NULL : (cvardecl = (vala_ccode_node_unref (cvardecl), NULL));
			(ccond == NULL) ? NULL : (ccond = (vala_ccode_node_unref (ccond), NULL));
			(cfor == NULL) ? NULL : (cfor = (vala_ccode_node_unref (cfor), NULL));
		}
	}
	{
		GeeList* _tmp102;
		GeeIterator* _tmp103;
		GeeIterator* _local_it;
		_tmp102 = NULL;
		_tmp103 = NULL;
		_local_it = (_tmp103 = gee_iterable_iterator ((GeeIterable*) (_tmp102 = vala_block_get_local_variables ((ValaBlock*) stmt))), (_tmp102 == NULL) ? NULL : (_tmp102 = (gee_collection_object_unref (_tmp102), NULL)), _tmp103);
		while (gee_iterator_next (_local_it)) {
			ValaLocalVariable* local;
			local = (ValaLocalVariable*) gee_iterator_get (_local_it);
			if (vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, vala_local_variable_get_variable_type (local))) {
				ValaMemberAccess* ma;
				ValaCCodeExpression* _tmp106;
				ValaCCodeIdentifier* _tmp105;
				char* _tmp104;
				ValaCCodeExpressionStatement* _tmp107;
				ValaCCodeExpressionStatement* cunref;
				ma = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) local), NULL);
				vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) local);
				_tmp106 = NULL;
				_tmp105 = NULL;
				_tmp104 = NULL;
				_tmp107 = NULL;
				cunref = (_tmp107 = vala_ccode_expression_statement_new (_tmp106 = vala_ccode_base_module_get_unref_expression ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) (_tmp105 = vala_ccode_identifier_new (_tmp104 = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) local)))), vala_local_variable_get_variable_type (local), (ValaExpression*) ma)), (_tmp106 == NULL) ? NULL : (_tmp106 = (vala_ccode_node_unref (_tmp106), NULL)), (_tmp105 == NULL) ? NULL : (_tmp105 = (vala_ccode_node_unref (_tmp105), NULL)), _tmp104 = (g_free (_tmp104), NULL), _tmp107);
				vala_ccode_node_set_line ((ValaCCodeNode*) cunref, vala_ccode_node_get_line ((ValaCCodeNode*) cblock));
				vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) cunref);
				(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
				(cunref == NULL) ? NULL : (cunref = (vala_ccode_node_unref (cunref), NULL));
			}
			(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
		}
		(_local_it == NULL) ? NULL : (_local_it = (gee_collection_object_unref (_local_it), NULL));
	}
	(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
	(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
	(collection_backup == NULL) ? NULL : (collection_backup = (vala_code_node_unref (collection_backup), NULL));
	(collection_type == NULL) ? NULL : (collection_type = (vala_code_node_unref (collection_type), NULL));
	(ccoldecl == NULL) ? NULL : (ccoldecl = (vala_ccode_node_unref (ccoldecl), NULL));
	(ccolvardecl == NULL) ? NULL : (ccolvardecl = (vala_ccode_node_unref (ccolvardecl), NULL));
}


static void vala_ccode_control_flow_module_real_visit_break_statement (ValaCCodeModule* base, ValaBreakStatement* stmt) {
	ValaCCodeControlFlowModule * self;
	ValaCCodeBreakStatement* _tmp0;
	self = (ValaCCodeControlFlowModule*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) (_tmp0 = vala_ccode_break_statement_new ()));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	vala_ccode_base_module_create_local_free ((ValaCCodeBaseModule*) self, (ValaCodeNode*) stmt, TRUE);
}


static void vala_ccode_control_flow_module_real_visit_continue_statement (ValaCCodeModule* base, ValaContinueStatement* stmt) {
	ValaCCodeControlFlowModule * self;
	ValaCCodeContinueStatement* _tmp0;
	self = (ValaCCodeControlFlowModule*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) (_tmp0 = vala_ccode_continue_statement_new ()));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	vala_ccode_base_module_create_local_free ((ValaCCodeBaseModule*) self, (ValaCodeNode*) stmt, TRUE);
}


static void vala_ccode_control_flow_module_class_init (ValaCCodeControlFlowModuleClass * klass) {
	vala_ccode_control_flow_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->visit_if_statement = vala_ccode_control_flow_module_real_visit_if_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_switch_statement = vala_ccode_control_flow_module_real_visit_switch_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_switch_section = vala_ccode_control_flow_module_real_visit_switch_section;
	VALA_CCODE_MODULE_CLASS (klass)->visit_switch_label = vala_ccode_control_flow_module_real_visit_switch_label;
	VALA_CCODE_MODULE_CLASS (klass)->visit_while_statement = vala_ccode_control_flow_module_real_visit_while_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_do_statement = vala_ccode_control_flow_module_real_visit_do_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_for_statement = vala_ccode_control_flow_module_real_visit_for_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_foreach_statement = vala_ccode_control_flow_module_real_visit_foreach_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_break_statement = vala_ccode_control_flow_module_real_visit_break_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_continue_statement = vala_ccode_control_flow_module_real_visit_continue_statement;
}


static void vala_ccode_control_flow_module_instance_init (ValaCCodeControlFlowModule * self) {
}


GType vala_ccode_control_flow_module_get_type (void) {
	static GType vala_ccode_control_flow_module_type_id = 0;
	if (vala_ccode_control_flow_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeControlFlowModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_control_flow_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeControlFlowModule), 0, (GInstanceInitFunc) vala_ccode_control_flow_module_instance_init, NULL };
		vala_ccode_control_flow_module_type_id = g_type_register_static (VALA_TYPE_CCODE_METHOD_MODULE, "ValaCCodeControlFlowModule", &g_define_type_info, 0);
	}
	return vala_ccode_control_flow_module_type_id;
}




