/* valainstancecast.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valainstancecast.h>
#include <ccode/valaccodeidentifier.h>
#include <stdlib.h>
#include <string.h>




struct _ValaInstanceCastPrivate {
	ValaTypeSymbol* _type_reference;
	ValaCCodeExpression* _inner;
};

#define VALA_INSTANCE_CAST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_INSTANCE_CAST, ValaInstanceCastPrivate))
enum  {
	VALA_INSTANCE_CAST_DUMMY_PROPERTY
};
static gpointer vala_instance_cast_parent_class = NULL;
static void vala_instance_cast_finalize (ValaCCodeNode* obj);



/**
 * Creates a new instance cast expression.
 *
 * @param expr an expression
 * @param type the target type
 * @return     newly created instance cast expression
 */
ValaInstanceCast* vala_instance_cast_construct (GType object_type, ValaCCodeExpression* expr, ValaTypeSymbol* type) {
	ValaInstanceCast* self;
	ValaCCodeIdentifier* _tmp1;
	char* _tmp0;
	g_return_val_if_fail (expr != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	self = (ValaInstanceCast*) g_type_create_instance (object_type);
	vala_instance_cast_set_inner (self, expr);
	vala_instance_cast_set_type_reference (self, type);
	_tmp1 = NULL;
	_tmp0 = NULL;
	vala_ccode_function_call_set_call ((ValaCCodeFunctionCall*) self, (ValaCCodeExpression*) (_tmp1 = vala_ccode_identifier_new (_tmp0 = vala_typesymbol_get_upper_case_cname (self->priv->_type_reference, NULL))));
	(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
	_tmp0 = (g_free (_tmp0), NULL);
	vala_ccode_function_call_add_argument ((ValaCCodeFunctionCall*) self, VALA_CCODE_EXPRESSION (self->priv->_inner));
	return self;
}


ValaInstanceCast* vala_instance_cast_new (ValaCCodeExpression* expr, ValaTypeSymbol* type) {
	return vala_instance_cast_construct (VALA_TYPE_INSTANCE_CAST, expr, type);
}


ValaTypeSymbol* vala_instance_cast_get_type_reference (ValaInstanceCast* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_type_reference;
}


void vala_instance_cast_set_type_reference (ValaInstanceCast* self, ValaTypeSymbol* value) {
	g_return_if_fail (self != NULL);
	self->priv->_type_reference = value;
}


ValaCCodeExpression* vala_instance_cast_get_inner (ValaInstanceCast* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_inner;
}


void vala_instance_cast_set_inner (ValaInstanceCast* self, ValaCCodeExpression* value) {
	ValaCCodeExpression* _tmp2;
	ValaCCodeExpression* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_inner = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_ccode_node_ref (_tmp1)), (self->priv->_inner == NULL) ? NULL : (self->priv->_inner = (vala_ccode_node_unref (self->priv->_inner), NULL)), _tmp2);
}


static void vala_instance_cast_class_init (ValaInstanceCastClass * klass) {
	vala_instance_cast_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_instance_cast_finalize;
	g_type_class_add_private (klass, sizeof (ValaInstanceCastPrivate));
}


static void vala_instance_cast_instance_init (ValaInstanceCast * self) {
	self->priv = VALA_INSTANCE_CAST_GET_PRIVATE (self);
}


static void vala_instance_cast_finalize (ValaCCodeNode* obj) {
	ValaInstanceCast * self;
	self = VALA_INSTANCE_CAST (obj);
	(self->priv->_inner == NULL) ? NULL : (self->priv->_inner = (vala_ccode_node_unref (self->priv->_inner), NULL));
	VALA_CCODE_NODE_CLASS (vala_instance_cast_parent_class)->finalize (obj);
}


GType vala_instance_cast_get_type (void) {
	static GType vala_instance_cast_type_id = 0;
	if (vala_instance_cast_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaInstanceCastClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_instance_cast_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInstanceCast), 0, (GInstanceInitFunc) vala_instance_cast_instance_init, NULL };
		vala_instance_cast_type_id = g_type_register_static (VALA_TYPE_CCODE_FUNCTION_CALL, "ValaInstanceCast", &g_define_type_info, 0);
	}
	return vala_instance_cast_type_id;
}




