/* valastatementlist.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALASTATEMENTLIST_H__
#define __VALA_VALASTATEMENTLIST_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valacodenode.h>
#include <vala/valastatement.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>

G_BEGIN_DECLS


#define VALA_TYPE_STATEMENT_LIST (vala_statement_list_get_type ())
#define VALA_STATEMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STATEMENT_LIST, ValaStatementList))
#define VALA_STATEMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STATEMENT_LIST, ValaStatementListClass))
#define VALA_IS_STATEMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STATEMENT_LIST))
#define VALA_IS_STATEMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STATEMENT_LIST))
#define VALA_STATEMENT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STATEMENT_LIST, ValaStatementListClass))

typedef struct _ValaStatementList ValaStatementList;
typedef struct _ValaStatementListClass ValaStatementListClass;
typedef struct _ValaStatementListPrivate ValaStatementListPrivate;

struct _ValaStatementList {
	ValaCodeNode parent_instance;
	ValaStatementListPrivate * priv;
};

struct _ValaStatementListClass {
	ValaCodeNodeClass parent_class;
};


ValaStatementList* vala_statement_list_construct (GType object_type, ValaSourceReference* source_reference);
ValaStatementList* vala_statement_list_new (ValaSourceReference* source_reference);
ValaStatement* vala_statement_list_get (ValaStatementList* self, gint index);
void vala_statement_list_set (ValaStatementList* self, gint index, ValaStatement* stmt);
void vala_statement_list_add (ValaStatementList* self, ValaStatement* stmt);
void vala_statement_list_insert (ValaStatementList* self, gint index, ValaStatement* stmt);
gint vala_statement_list_get_length (ValaStatementList* self);
GType vala_statement_list_get_type (void);


G_END_DECLS

#endif
