/* valaclassregisterfunction.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gobject/valaclassregisterfunction.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valadatatype.h>
#include <vala/valainterface.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodeexpressionstatement.h>




struct _ValaClassRegisterFunctionPrivate {
	ValaClass* _class_reference;
};

#define VALA_CLASS_REGISTER_FUNCTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CLASS_REGISTER_FUNCTION, ValaClassRegisterFunctionPrivate))
enum  {
	VALA_CLASS_REGISTER_FUNCTION_DUMMY_PROPERTY
};
static ValaTypeSymbol* vala_class_register_function_real_get_type_declaration (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_type_struct_name (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_base_init_func_name (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_class_finalize_func_name (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_base_finalize_func_name (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_class_init_func_name (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_instance_struct_size (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_instance_init_func_name (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_parent_type_name (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_type_flags (ValaTypeRegisterFunction* base);
static ValaSymbolAccessibility vala_class_register_function_real_get_accessibility (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_gtype_value_table_init_function_name (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_gtype_value_table_free_function_name (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_gtype_value_table_copy_function_name (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_gtype_value_table_peek_pointer_function_name (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_gtype_value_table_collect_value_function_name (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_gtype_value_table_lcopy_value_function_name (ValaTypeRegisterFunction* base);
static ValaCCodeFragment* vala_class_register_function_real_get_type_interface_init_declaration (ValaTypeRegisterFunction* base);
static ValaCCodeFragment* vala_class_register_function_real_get_type_interface_init_statements (ValaTypeRegisterFunction* base);
static gpointer vala_class_register_function_parent_class = NULL;
static void vala_class_register_function_finalize (ValaTypeRegisterFunction* obj);



/**
 * Creates a new C function to register the specified class at runtime.
 *
 * @param cl a class
 * @return   newly created class register function
 */
ValaClassRegisterFunction* vala_class_register_function_construct (GType object_type, ValaClass* cl, ValaCodeContext* context) {
	ValaClassRegisterFunction* self;
	g_return_val_if_fail (cl != NULL, NULL);
	g_return_val_if_fail (context != NULL, NULL);
	self = (ValaClassRegisterFunction*) g_type_create_instance (object_type);
	vala_class_register_function_set_class_reference (self, cl);
	vala_typeregister_function_set_context ((ValaTypeRegisterFunction*) self, context);
	return self;
}


ValaClassRegisterFunction* vala_class_register_function_new (ValaClass* cl, ValaCodeContext* context) {
	return vala_class_register_function_construct (VALA_TYPE_CLASS_REGISTER_FUNCTION, cl, context);
}


static ValaTypeSymbol* vala_class_register_function_real_get_type_declaration (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	ValaTypeSymbol* _tmp0;
	self = (ValaClassRegisterFunction*) base;
	_tmp0 = NULL;
	return (_tmp0 = (ValaTypeSymbol*) self->priv->_class_reference, (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
}


static char* vala_class_register_function_real_get_type_struct_name (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	char* _tmp0;
	char* _tmp1;
	self = (ValaClassRegisterFunction*) base;
	_tmp0 = NULL;
	_tmp1 = NULL;
	return (_tmp1 = g_strdup_printf ("%sClass", _tmp0 = vala_typesymbol_get_cname ((ValaTypeSymbol*) self->priv->_class_reference, FALSE)), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
}


static char* vala_class_register_function_real_get_base_init_func_name (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	gboolean _tmp0;
	self = (ValaClassRegisterFunction*) base;
	_tmp0 = FALSE;
	if (vala_class_get_class_constructor (self->priv->_class_reference) != NULL) {
		_tmp0 = TRUE;
	} else {
		_tmp0 = vala_class_get_has_class_private_fields (self->priv->_class_reference);
	}
	if (_tmp0) {
		char* _tmp1;
		char* _tmp2;
		_tmp1 = NULL;
		_tmp2 = NULL;
		return (_tmp2 = g_strdup_printf ("%s_base_init", _tmp1 = vala_symbol_get_lower_case_cname ((ValaSymbol*) self->priv->_class_reference, NULL)), _tmp1 = (g_free (_tmp1), NULL), _tmp2);
	} else {
		return g_strdup ("NULL");
	}
}


static char* vala_class_register_function_real_get_class_finalize_func_name (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	self = (ValaClassRegisterFunction*) base;
	if (vala_class_get_static_destructor (self->priv->_class_reference) != NULL) {
		char* _tmp0;
		char* _tmp1;
		_tmp0 = NULL;
		_tmp1 = NULL;
		return (_tmp1 = g_strdup_printf ("%s_class_finalize", _tmp0 = vala_symbol_get_lower_case_cname ((ValaSymbol*) self->priv->_class_reference, NULL)), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
	} else {
		return g_strdup ("NULL");
	}
}


static char* vala_class_register_function_real_get_base_finalize_func_name (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	gboolean _tmp0;
	self = (ValaClassRegisterFunction*) base;
	_tmp0 = FALSE;
	if (vala_class_get_class_destructor (self->priv->_class_reference) != NULL) {
		_tmp0 = TRUE;
	} else {
		_tmp0 = vala_class_get_has_class_private_fields (self->priv->_class_reference);
	}
	if (_tmp0) {
		char* _tmp1;
		char* _tmp2;
		_tmp1 = NULL;
		_tmp2 = NULL;
		return (_tmp2 = g_strdup_printf ("%s_base_finalize", _tmp1 = vala_symbol_get_lower_case_cname ((ValaSymbol*) self->priv->_class_reference, NULL)), _tmp1 = (g_free (_tmp1), NULL), _tmp2);
	} else {
		return g_strdup ("NULL");
	}
}


static char* vala_class_register_function_real_get_class_init_func_name (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	char* _tmp0;
	char* _tmp1;
	self = (ValaClassRegisterFunction*) base;
	_tmp0 = NULL;
	_tmp1 = NULL;
	return (_tmp1 = g_strdup_printf ("%s_class_init", _tmp0 = vala_symbol_get_lower_case_cname ((ValaSymbol*) self->priv->_class_reference, NULL)), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
}


static char* vala_class_register_function_real_get_instance_struct_size (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	char* _tmp0;
	char* _tmp1;
	self = (ValaClassRegisterFunction*) base;
	_tmp0 = NULL;
	_tmp1 = NULL;
	return (_tmp1 = g_strdup_printf ("sizeof (%s)", _tmp0 = vala_typesymbol_get_cname ((ValaTypeSymbol*) self->priv->_class_reference, FALSE)), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
}


static char* vala_class_register_function_real_get_instance_init_func_name (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	char* _tmp0;
	char* _tmp1;
	self = (ValaClassRegisterFunction*) base;
	_tmp0 = NULL;
	_tmp1 = NULL;
	return (_tmp1 = g_strdup_printf ("%s_instance_init", _tmp0 = vala_symbol_get_lower_case_cname ((ValaSymbol*) self->priv->_class_reference, NULL)), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
}


static char* vala_class_register_function_real_get_parent_type_name (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	self = (ValaClassRegisterFunction*) base;
	return vala_typesymbol_get_type_id ((ValaTypeSymbol*) vala_class_get_base_class (self->priv->_class_reference));
}


static char* vala_class_register_function_real_get_type_flags (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	self = (ValaClassRegisterFunction*) base;
	if (vala_class_get_is_abstract (self->priv->_class_reference)) {
		return g_strdup ("G_TYPE_FLAG_ABSTRACT");
	} else {
		return g_strdup ("0");
	}
}


static ValaSymbolAccessibility vala_class_register_function_real_get_accessibility (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	self = (ValaClassRegisterFunction*) base;
	return vala_symbol_get_access ((ValaSymbol*) self->priv->_class_reference);
}


static char* vala_class_register_function_real_get_gtype_value_table_init_function_name (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	gboolean _tmp0;
	gboolean is_fundamental;
	self = (ValaClassRegisterFunction*) base;
	_tmp0 = FALSE;
	if (!vala_class_get_is_compact (self->priv->_class_reference)) {
		_tmp0 = vala_class_get_base_class (self->priv->_class_reference) == NULL;
	} else {
		_tmp0 = FALSE;
	}
	is_fundamental = _tmp0;
	if (is_fundamental) {
		char* _tmp1;
		char* _tmp2;
		_tmp1 = NULL;
		_tmp2 = NULL;
		return (_tmp2 = g_strdup_printf ("%s_init", _tmp1 = vala_symbol_get_lower_case_cname ((ValaSymbol*) self->priv->_class_reference, "value_")), _tmp1 = (g_free (_tmp1), NULL), _tmp2);
	}
	return NULL;
}


static char* vala_class_register_function_real_get_gtype_value_table_free_function_name (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	gboolean _tmp0;
	gboolean is_fundamental;
	self = (ValaClassRegisterFunction*) base;
	_tmp0 = FALSE;
	if (!vala_class_get_is_compact (self->priv->_class_reference)) {
		_tmp0 = vala_class_get_base_class (self->priv->_class_reference) == NULL;
	} else {
		_tmp0 = FALSE;
	}
	is_fundamental = _tmp0;
	if (is_fundamental) {
		char* _tmp1;
		char* _tmp2;
		_tmp1 = NULL;
		_tmp2 = NULL;
		return (_tmp2 = g_strdup_printf ("%s_free_value", _tmp1 = vala_symbol_get_lower_case_cname ((ValaSymbol*) self->priv->_class_reference, "value_")), _tmp1 = (g_free (_tmp1), NULL), _tmp2);
	}
	return NULL;
}


static char* vala_class_register_function_real_get_gtype_value_table_copy_function_name (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	gboolean _tmp0;
	gboolean is_fundamental;
	self = (ValaClassRegisterFunction*) base;
	_tmp0 = FALSE;
	if (!vala_class_get_is_compact (self->priv->_class_reference)) {
		_tmp0 = vala_class_get_base_class (self->priv->_class_reference) == NULL;
	} else {
		_tmp0 = FALSE;
	}
	is_fundamental = _tmp0;
	if (is_fundamental) {
		char* _tmp1;
		char* _tmp2;
		_tmp1 = NULL;
		_tmp2 = NULL;
		return (_tmp2 = g_strdup_printf ("%s_copy_value", _tmp1 = vala_symbol_get_lower_case_cname ((ValaSymbol*) self->priv->_class_reference, "value_")), _tmp1 = (g_free (_tmp1), NULL), _tmp2);
	}
	return NULL;
}


static char* vala_class_register_function_real_get_gtype_value_table_peek_pointer_function_name (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	gboolean _tmp0;
	gboolean is_fundamental;
	self = (ValaClassRegisterFunction*) base;
	_tmp0 = FALSE;
	if (!vala_class_get_is_compact (self->priv->_class_reference)) {
		_tmp0 = vala_class_get_base_class (self->priv->_class_reference) == NULL;
	} else {
		_tmp0 = FALSE;
	}
	is_fundamental = _tmp0;
	if (is_fundamental) {
		char* _tmp1;
		char* _tmp2;
		_tmp1 = NULL;
		_tmp2 = NULL;
		return (_tmp2 = g_strdup_printf ("%s_peek_pointer", _tmp1 = vala_symbol_get_lower_case_cname ((ValaSymbol*) self->priv->_class_reference, "value_")), _tmp1 = (g_free (_tmp1), NULL), _tmp2);
	}
	return NULL;
}


static char* vala_class_register_function_real_get_gtype_value_table_collect_value_function_name (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	gboolean _tmp0;
	gboolean is_fundamental;
	self = (ValaClassRegisterFunction*) base;
	_tmp0 = FALSE;
	if (!vala_class_get_is_compact (self->priv->_class_reference)) {
		_tmp0 = vala_class_get_base_class (self->priv->_class_reference) == NULL;
	} else {
		_tmp0 = FALSE;
	}
	is_fundamental = _tmp0;
	if (is_fundamental) {
		char* _tmp1;
		char* _tmp2;
		_tmp1 = NULL;
		_tmp2 = NULL;
		return (_tmp2 = g_strdup_printf ("%s_collect_value", _tmp1 = vala_symbol_get_lower_case_cname ((ValaSymbol*) self->priv->_class_reference, "value_")), _tmp1 = (g_free (_tmp1), NULL), _tmp2);
	}
	return NULL;
}


static char* vala_class_register_function_real_get_gtype_value_table_lcopy_value_function_name (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	gboolean _tmp0;
	gboolean is_fundamental;
	self = (ValaClassRegisterFunction*) base;
	_tmp0 = FALSE;
	if (!vala_class_get_is_compact (self->priv->_class_reference)) {
		_tmp0 = vala_class_get_base_class (self->priv->_class_reference) == NULL;
	} else {
		_tmp0 = FALSE;
	}
	is_fundamental = _tmp0;
	if (is_fundamental) {
		char* _tmp1;
		char* _tmp2;
		_tmp1 = NULL;
		_tmp2 = NULL;
		return (_tmp2 = g_strdup_printf ("%s_lcopy_value", _tmp1 = vala_symbol_get_lower_case_cname ((ValaSymbol*) self->priv->_class_reference, "value_")), _tmp1 = (g_free (_tmp1), NULL), _tmp2);
	}
	return NULL;
}


static ValaCCodeFragment* vala_class_register_function_real_get_type_interface_init_declaration (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	ValaCCodeFragment* frag;
	self = (ValaClassRegisterFunction*) base;
	frag = vala_ccode_fragment_new ();
	{
		GeeList* _tmp0;
		GeeIterator* _tmp1;
		GeeIterator* _base_type_it;
		_tmp0 = NULL;
		_tmp1 = NULL;
		_base_type_it = (_tmp1 = gee_iterable_iterator ((GeeIterable*) (_tmp0 = vala_class_get_base_types (self->priv->_class_reference))), (_tmp0 == NULL) ? NULL : (_tmp0 = (gee_collection_object_unref (_tmp0), NULL)), _tmp1);
		while (gee_iterator_next (_base_type_it)) {
			ValaDataType* base_type;
			ValaInterface* _tmp2;
			ValaInterface* iface;
			char* _tmp3;
			char* _tmp4;
			char* iface_info_name;
			ValaCCodeDeclaration* ctypedecl;
			ValaCCodeVariableDeclarator* _tmp9;
			ValaCCodeConstant* _tmp8;
			char* _tmp7;
			char* _tmp6;
			char* _tmp5;
			base_type = (ValaDataType*) gee_iterator_get (_base_type_it);
			if (!(VALA_IS_INTERFACE (vala_data_type_get_data_type (base_type)))) {
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
				continue;
			}
			_tmp2 = NULL;
			iface = (_tmp2 = VALA_INTERFACE (vala_data_type_get_data_type (base_type)), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
			_tmp3 = NULL;
			_tmp4 = NULL;
			iface_info_name = (_tmp4 = g_strdup_printf ("%s_info", _tmp3 = vala_symbol_get_lower_case_cname ((ValaSymbol*) iface, NULL)), _tmp3 = (g_free (_tmp3), NULL), _tmp4);
			ctypedecl = vala_ccode_declaration_new ("const GInterfaceInfo");
			vala_ccode_declaration_set_modifiers (ctypedecl, VALA_CCODE_MODIFIERS_STATIC);
			_tmp9 = NULL;
			_tmp8 = NULL;
			_tmp7 = NULL;
			_tmp6 = NULL;
			_tmp5 = NULL;
			vala_ccode_declaration_add_declarator (ctypedecl, (ValaCCodeDeclarator*) (_tmp9 = vala_ccode_variable_declarator_new_with_initializer (iface_info_name, (ValaCCodeExpression*) (_tmp8 = vala_ccode_constant_new (_tmp7 = g_strdup_printf ("{ (GInterfaceInitFunc) %s_%s_interface_init, (GInterfaceFinalizeFunc) NULL, NULL}", _tmp5 = vala_symbol_get_lower_case_cname ((ValaSymbol*) self->priv->_class_reference, NULL), _tmp6 = vala_symbol_get_lower_case_cname ((ValaSymbol*) iface, NULL)))))));
			(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
			(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
			_tmp7 = (g_free (_tmp7), NULL);
			_tmp6 = (g_free (_tmp6), NULL);
			_tmp5 = (g_free (_tmp5), NULL);
			vala_ccode_fragment_append (frag, (ValaCCodeNode*) ctypedecl);
			(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
			(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
			iface_info_name = (g_free (iface_info_name), NULL);
			(ctypedecl == NULL) ? NULL : (ctypedecl = (vala_ccode_node_unref (ctypedecl), NULL));
		}
		(_base_type_it == NULL) ? NULL : (_base_type_it = (gee_collection_object_unref (_base_type_it), NULL));
	}
	return frag;
}


static ValaCCodeFragment* vala_class_register_function_real_get_type_interface_init_statements (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	ValaCCodeFragment* frag;
	self = (ValaClassRegisterFunction*) base;
	frag = vala_ccode_fragment_new ();
	{
		GeeList* _tmp0;
		GeeIterator* _tmp1;
		GeeIterator* _base_type_it;
		_tmp0 = NULL;
		_tmp1 = NULL;
		_base_type_it = (_tmp1 = gee_iterable_iterator ((GeeIterable*) (_tmp0 = vala_class_get_base_types (self->priv->_class_reference))), (_tmp0 == NULL) ? NULL : (_tmp0 = (gee_collection_object_unref (_tmp0), NULL)), _tmp1);
		while (gee_iterator_next (_base_type_it)) {
			ValaDataType* base_type;
			ValaInterface* _tmp2;
			ValaInterface* iface;
			char* _tmp3;
			char* _tmp4;
			char* iface_info_name;
			ValaCCodeIdentifier* _tmp5;
			ValaCCodeFunctionCall* _tmp6;
			ValaCCodeFunctionCall* reg_call;
			ValaCCodeIdentifier* _tmp9;
			char* _tmp8;
			char* _tmp7;
			ValaCCodeIdentifier* _tmp11;
			char* _tmp10;
			ValaCCodeIdentifier* _tmp13;
			char* _tmp12;
			ValaCCodeExpressionStatement* _tmp14;
			base_type = (ValaDataType*) gee_iterator_get (_base_type_it);
			if (!(VALA_IS_INTERFACE (vala_data_type_get_data_type (base_type)))) {
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
				continue;
			}
			_tmp2 = NULL;
			iface = (_tmp2 = VALA_INTERFACE (vala_data_type_get_data_type (base_type)), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
			_tmp3 = NULL;
			_tmp4 = NULL;
			iface_info_name = (_tmp4 = g_strdup_printf ("%s_info", _tmp3 = vala_symbol_get_lower_case_cname ((ValaSymbol*) iface, NULL)), _tmp3 = (g_free (_tmp3), NULL), _tmp4);
			_tmp5 = NULL;
			_tmp6 = NULL;
			reg_call = (_tmp6 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp5 = vala_ccode_identifier_new ("g_type_add_interface_static"))), (_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)), _tmp6);
			_tmp9 = NULL;
			_tmp8 = NULL;
			_tmp7 = NULL;
			vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp9 = vala_ccode_identifier_new (_tmp8 = g_strdup_printf ("%s_type_id", _tmp7 = vala_symbol_get_lower_case_cname ((ValaSymbol*) self->priv->_class_reference, NULL)))));
			(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
			_tmp8 = (g_free (_tmp8), NULL);
			_tmp7 = (g_free (_tmp7), NULL);
			_tmp11 = NULL;
			_tmp10 = NULL;
			vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp11 = vala_ccode_identifier_new (_tmp10 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) iface))));
			(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
			_tmp10 = (g_free (_tmp10), NULL);
			_tmp13 = NULL;
			_tmp12 = NULL;
			vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp13 = vala_ccode_identifier_new (_tmp12 = g_strdup_printf ("&%s", iface_info_name))));
			(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
			_tmp12 = (g_free (_tmp12), NULL);
			_tmp14 = NULL;
			vala_ccode_fragment_append (frag, (ValaCCodeNode*) (_tmp14 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) reg_call)));
			(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
			(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
			(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
			iface_info_name = (g_free (iface_info_name), NULL);
			(reg_call == NULL) ? NULL : (reg_call = (vala_ccode_node_unref (reg_call), NULL));
		}
		(_base_type_it == NULL) ? NULL : (_base_type_it = (gee_collection_object_unref (_base_type_it), NULL));
	}
	return frag;
}


ValaClass* vala_class_register_function_get_class_reference (ValaClassRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_class_reference;
}


void vala_class_register_function_set_class_reference (ValaClassRegisterFunction* self, ValaClass* value) {
	g_return_if_fail (self != NULL);
	self->priv->_class_reference = value;
}


static void vala_class_register_function_class_init (ValaClassRegisterFunctionClass * klass) {
	vala_class_register_function_parent_class = g_type_class_peek_parent (klass);
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->finalize = vala_class_register_function_finalize;
	g_type_class_add_private (klass, sizeof (ValaClassRegisterFunctionPrivate));
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_declaration = vala_class_register_function_real_get_type_declaration;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_struct_name = vala_class_register_function_real_get_type_struct_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_base_init_func_name = vala_class_register_function_real_get_base_init_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_class_finalize_func_name = vala_class_register_function_real_get_class_finalize_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_base_finalize_func_name = vala_class_register_function_real_get_base_finalize_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_class_init_func_name = vala_class_register_function_real_get_class_init_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_instance_struct_size = vala_class_register_function_real_get_instance_struct_size;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_instance_init_func_name = vala_class_register_function_real_get_instance_init_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_parent_type_name = vala_class_register_function_real_get_parent_type_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_flags = vala_class_register_function_real_get_type_flags;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_accessibility = vala_class_register_function_real_get_accessibility;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_init_function_name = vala_class_register_function_real_get_gtype_value_table_init_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_free_function_name = vala_class_register_function_real_get_gtype_value_table_free_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_copy_function_name = vala_class_register_function_real_get_gtype_value_table_copy_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_peek_pointer_function_name = vala_class_register_function_real_get_gtype_value_table_peek_pointer_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_collect_value_function_name = vala_class_register_function_real_get_gtype_value_table_collect_value_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_lcopy_value_function_name = vala_class_register_function_real_get_gtype_value_table_lcopy_value_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_interface_init_declaration = vala_class_register_function_real_get_type_interface_init_declaration;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_interface_init_statements = vala_class_register_function_real_get_type_interface_init_statements;
}


static void vala_class_register_function_instance_init (ValaClassRegisterFunction * self) {
	self->priv = VALA_CLASS_REGISTER_FUNCTION_GET_PRIVATE (self);
}


static void vala_class_register_function_finalize (ValaTypeRegisterFunction* obj) {
	ValaClassRegisterFunction * self;
	self = VALA_CLASS_REGISTER_FUNCTION (obj);
	VALA_TYPEREGISTER_FUNCTION_CLASS (vala_class_register_function_parent_class)->finalize (obj);
}


GType vala_class_register_function_get_type (void) {
	static GType vala_class_register_function_type_id = 0;
	if (vala_class_register_function_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaClassRegisterFunctionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_class_register_function_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaClassRegisterFunction), 0, (GInstanceInitFunc) vala_class_register_function_instance_init, NULL };
		vala_class_register_function_type_id = g_type_register_static (VALA_TYPE_TYPEREGISTER_FUNCTION, "ValaClassRegisterFunction", &g_define_type_info, 0);
	}
	return vala_class_register_function_type_id;
}




