/* valabooleantype.vala
 *
 * Copyright (C) 2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALABOOLEANTYPE_H__
#define __VALA_VALABOOLEANTYPE_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valavaluetype.h>
#include <vala/valastruct.h>
#include <vala/valadatatype.h>

G_BEGIN_DECLS


#define VALA_TYPE_BOOLEAN_TYPE (vala_boolean_type_get_type ())
#define VALA_BOOLEAN_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BOOLEAN_TYPE, ValaBooleanType))
#define VALA_BOOLEAN_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BOOLEAN_TYPE, ValaBooleanTypeClass))
#define VALA_IS_BOOLEAN_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BOOLEAN_TYPE))
#define VALA_IS_BOOLEAN_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BOOLEAN_TYPE))
#define VALA_BOOLEAN_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BOOLEAN_TYPE, ValaBooleanTypeClass))

typedef struct _ValaBooleanType ValaBooleanType;
typedef struct _ValaBooleanTypeClass ValaBooleanTypeClass;
typedef struct _ValaBooleanTypePrivate ValaBooleanTypePrivate;

/**
 * A boolean type.
 */
struct _ValaBooleanType {
	ValaValueType parent_instance;
	ValaBooleanTypePrivate * priv;
};

struct _ValaBooleanTypeClass {
	ValaValueTypeClass parent_class;
};


ValaBooleanType* vala_boolean_type_construct (GType object_type, ValaStruct* type_symbol);
ValaBooleanType* vala_boolean_type_new (ValaStruct* type_symbol);
GType vala_boolean_type_get_type (void);


G_END_DECLS

#endif
