/* valagenerictype.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valagenerictype.h>
#include <vala/valatypeparameter.h>
#include <vala/valascope.h>
#include <vala/valasymbol.h>




enum  {
	VALA_GENERIC_TYPE_DUMMY_PROPERTY
};
static ValaDataType* vala_generic_type_real_copy (ValaDataType* base);
static char* vala_generic_type_real_get_cname (ValaDataType* base);
static char* vala_generic_type_real_get_type_id (ValaDataType* base);
static char* vala_generic_type_real_to_qualified_string (ValaDataType* base, ValaScope* scope);
static gpointer vala_generic_type_parent_class = NULL;



ValaGenericType* vala_generic_type_construct (GType object_type, ValaTypeParameter* type_parameter) {
	ValaGenericType* self;
	g_return_val_if_fail (type_parameter != NULL, NULL);
	self = (ValaGenericType*) g_type_create_instance (object_type);
	vala_data_type_set_type_parameter ((ValaDataType*) self, type_parameter);
	/* type parameters are always considered nullable*/
	vala_data_type_set_nullable ((ValaDataType*) self, TRUE);
	return self;
}


ValaGenericType* vala_generic_type_new (ValaTypeParameter* type_parameter) {
	return vala_generic_type_construct (VALA_TYPE_GENERIC_TYPE, type_parameter);
}


static ValaDataType* vala_generic_type_real_copy (ValaDataType* base) {
	ValaGenericType * self;
	ValaGenericType* result;
	self = (ValaGenericType*) base;
	result = vala_generic_type_new (vala_data_type_get_type_parameter ((ValaDataType*) self));
	vala_code_node_set_source_reference ((ValaCodeNode*) result, vala_code_node_get_source_reference ((ValaCodeNode*) self));
	vala_data_type_set_value_owned ((ValaDataType*) result, vala_data_type_get_value_owned ((ValaDataType*) self));
	vala_data_type_set_nullable ((ValaDataType*) result, vala_data_type_get_nullable ((ValaDataType*) self));
	vala_data_type_set_floating_reference ((ValaDataType*) result, vala_data_type_get_floating_reference ((ValaDataType*) self));
	return (ValaDataType*) result;
}


static char* vala_generic_type_real_get_cname (ValaDataType* base) {
	ValaGenericType * self;
	self = (ValaGenericType*) base;
	if (vala_data_type_get_value_owned ((ValaDataType*) self)) {
		return g_strdup ("gpointer");
	} else {
		return g_strdup ("gconstpointer");
	}
}


static char* vala_generic_type_real_get_type_id (ValaDataType* base) {
	ValaGenericType * self;
	self = (ValaGenericType*) base;
	return g_strdup ("G_TYPE_POINTER");
}


static char* vala_generic_type_real_to_qualified_string (ValaDataType* base, ValaScope* scope) {
	ValaGenericType * self;
	const char* _tmp0;
	self = (ValaGenericType*) base;
	_tmp0 = NULL;
	return (_tmp0 = vala_symbol_get_name ((ValaSymbol*) vala_data_type_get_type_parameter ((ValaDataType*) self)), (_tmp0 == NULL) ? NULL : g_strdup (_tmp0));
}


static void vala_generic_type_class_init (ValaGenericTypeClass * klass) {
	vala_generic_type_parent_class = g_type_class_peek_parent (klass);
	VALA_DATA_TYPE_CLASS (klass)->copy = vala_generic_type_real_copy;
	VALA_DATA_TYPE_CLASS (klass)->get_cname = vala_generic_type_real_get_cname;
	VALA_DATA_TYPE_CLASS (klass)->get_type_id = vala_generic_type_real_get_type_id;
	VALA_DATA_TYPE_CLASS (klass)->to_qualified_string = vala_generic_type_real_to_qualified_string;
}


static void vala_generic_type_instance_init (ValaGenericType * self) {
}


GType vala_generic_type_get_type (void) {
	static GType vala_generic_type_type_id = 0;
	if (vala_generic_type_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGenericTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_generic_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGenericType), 0, (GInstanceInitFunc) vala_generic_type_instance_init, NULL };
		vala_generic_type_type_id = g_type_register_static (VALA_TYPE_DATA_TYPE, "ValaGenericType", &g_define_type_info, 0);
	}
	return vala_generic_type_type_id;
}




