/* valastructvaluetype.vala
 *
 * Copyright (C) 2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valastructvaluetype.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valatypesymbol.h>
#include <vala/valacodenode.h>




enum  {
	VALA_STRUCT_VALUE_TYPE_DUMMY_PROPERTY
};
static ValaDataType* vala_struct_value_type_real_copy (ValaDataType* base);
static gpointer vala_struct_value_type_parent_class = NULL;



ValaStructValueType* vala_struct_value_type_construct (GType object_type, ValaStruct* type_symbol) {
	ValaStructValueType* self;
	g_return_val_if_fail (type_symbol != NULL, NULL);
	self = (ValaStructValueType*) vala_value_type_construct (object_type, (ValaTypeSymbol*) type_symbol);
	return self;
}


ValaStructValueType* vala_struct_value_type_new (ValaStruct* type_symbol) {
	return vala_struct_value_type_construct (VALA_TYPE_STRUCT_VALUE_TYPE, type_symbol);
}


static ValaDataType* vala_struct_value_type_real_copy (ValaDataType* base) {
	ValaStructValueType * self;
	ValaStructValueType* result;
	self = (ValaStructValueType*) base;
	result = vala_struct_value_type_new (VALA_STRUCT (vala_value_type_get_type_symbol ((ValaValueType*) self)));
	vala_code_node_set_source_reference ((ValaCodeNode*) result, vala_code_node_get_source_reference ((ValaCodeNode*) self));
	vala_data_type_set_value_owned ((ValaDataType*) result, vala_data_type_get_value_owned ((ValaDataType*) self));
	vala_data_type_set_nullable ((ValaDataType*) result, vala_data_type_get_nullable ((ValaDataType*) self));
	{
		GeeList* _tmp0;
		GeeIterator* _tmp1;
		GeeIterator* _arg_it;
		_tmp0 = NULL;
		_tmp1 = NULL;
		_arg_it = (_tmp1 = gee_iterable_iterator ((GeeIterable*) (_tmp0 = vala_data_type_get_type_arguments ((ValaDataType*) self))), (_tmp0 == NULL) ? NULL : (_tmp0 = (gee_collection_object_unref (_tmp0), NULL)), _tmp1);
		while (gee_iterator_next (_arg_it)) {
			ValaDataType* arg;
			ValaDataType* _tmp2;
			arg = (ValaDataType*) gee_iterator_get (_arg_it);
			_tmp2 = NULL;
			vala_data_type_add_type_argument ((ValaDataType*) result, _tmp2 = vala_data_type_copy (arg));
			(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_code_node_unref (_tmp2), NULL));
			(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
		}
		(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
	}
	return (ValaDataType*) result;
}


static void vala_struct_value_type_class_init (ValaStructValueTypeClass * klass) {
	vala_struct_value_type_parent_class = g_type_class_peek_parent (klass);
	VALA_DATA_TYPE_CLASS (klass)->copy = vala_struct_value_type_real_copy;
}


static void vala_struct_value_type_instance_init (ValaStructValueType * self) {
}


GType vala_struct_value_type_get_type (void) {
	static GType vala_struct_value_type_type_id = 0;
	if (vala_struct_value_type_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaStructValueTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_struct_value_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaStructValueType), 0, (GInstanceInitFunc) vala_struct_value_type_instance_init, NULL };
		vala_struct_value_type_type_id = g_type_register_static (VALA_TYPE_VALUE_TYPE, "ValaStructValueType", &g_define_type_info, 0);
	}
	return vala_struct_value_type_type_id;
}




