/* valaccodememberaccessmodule.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodememberaccessmodule.h>
#include <vala/valacodenode.h>
#include <vala/valacodevisitor.h>
#include <ccode/valaccodeexpression.h>
#include <vala/valadatatype.h>
#include <vala/valaexpression.h>
#include <vala/valamethod.h>
#include <vala/valabaseaccess.h>
#include <vala/valasymbol.h>
#include <vala/valaclass.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeidentifier.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valatypesymbol.h>
#include <ccode/valaccodememberaccess.h>
#include <vala/valainterface.h>
#include <vala/valalocalvariable.h>
#include <gee/list.h>
#include <ccode/valaccodeassignment.h>
#include <vala/valacreationmethod.h>
#include <vala/valaarraylengthfield.h>
#include <vala/valafield.h>
#include <vala/valamember.h>
#include <vala/valapointertype.h>
#include <vala/valaconstant.h>
#include <vala/valaproperty.h>
#include <vala/valapropertyaccessor.h>
#include <vala/valadynamicproperty.h>
#include <ccode/valaccodecommaexpression.h>
#include <gee/collection.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodeconstant.h>
#include <vala/valaenumvalue.h>
#include <vala/valaformalparameter.h>
#include <vala/valastruct.h>
#include <gobject/valaccodebasemodule.h>




enum  {
	VALA_CCODE_MEMBER_ACCESS_MODULE_DUMMY_PROPERTY
};
static void vala_ccode_member_access_module_real_visit_member_access (ValaCCodeModule* base, ValaMemberAccess* expr);
static gpointer vala_ccode_member_access_module_parent_class = NULL;
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaCCodeMemberAccessModule* vala_ccode_member_access_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeMemberAccessModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaCCodeMemberAccessModule*) vala_ccode_control_flow_module_construct (object_type, codegen, next);
	return self;
}


ValaCCodeMemberAccessModule* vala_ccode_member_access_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_member_access_module_construct (VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, codegen, next);
}


static void vala_ccode_member_access_module_real_visit_member_access (ValaCCodeModule* base, ValaMemberAccess* expr) {
	ValaCCodeMemberAccessModule * self;
	ValaCCodeExpression* pub_inst;
	ValaDataType* base_type;
	self = (ValaCCodeMemberAccessModule*) base;
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	pub_inst = NULL;
	base_type = NULL;
	if (vala_member_access_get_inner (expr) != NULL) {
		ValaCCodeExpression* _tmp1;
		ValaCCodeExpression* _tmp0;
		_tmp1 = NULL;
		_tmp0 = NULL;
		pub_inst = (_tmp1 = (_tmp0 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (expr))), (_tmp0 == NULL) ? NULL : vala_ccode_node_ref (_tmp0)), (pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL)), _tmp1);
		if (vala_expression_get_value_type (vala_member_access_get_inner (expr)) != NULL) {
			ValaDataType* _tmp3;
			ValaDataType* _tmp2;
			_tmp3 = NULL;
			_tmp2 = NULL;
			base_type = (_tmp3 = (_tmp2 = vala_expression_get_value_type (vala_member_access_get_inner (expr)), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2)), (base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)), _tmp3);
		}
	}
	if (VALA_IS_METHOD (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
		ValaMethod* _tmp4;
		ValaMethod* m;
		_tmp4 = NULL;
		m = (_tmp4 = VALA_METHOD (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp4 == NULL) ? NULL : vala_code_node_ref (_tmp4));
		if (VALA_IS_BASE_ACCESS (vala_member_access_get_inner (expr))) {
			if (vala_method_get_base_method (m) != NULL) {
				ValaClass* _tmp5;
				ValaClass* base_class;
				ValaCCodeIdentifier* _tmp8;
				char* _tmp7;
				char* _tmp6;
				ValaCCodeFunctionCall* _tmp9;
				ValaCCodeFunctionCall* vcast;
				ValaCCodeIdentifier* _tmp12;
				char* _tmp11;
				char* _tmp10;
				ValaCCodeMemberAccess* _tmp13;
				_tmp5 = NULL;
				base_class = (_tmp5 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_method_get_base_method (m))), (_tmp5 == NULL) ? NULL : vala_code_node_ref (_tmp5));
				_tmp8 = NULL;
				_tmp7 = NULL;
				_tmp6 = NULL;
				_tmp9 = NULL;
				vcast = (_tmp9 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp8 = vala_ccode_identifier_new (_tmp7 = g_strdup_printf ("%s_CLASS", _tmp6 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) base_class, NULL))))), (_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)), _tmp7 = (g_free (_tmp7), NULL), _tmp6 = (g_free (_tmp6), NULL), _tmp9);
				_tmp12 = NULL;
				_tmp11 = NULL;
				_tmp10 = NULL;
				vala_ccode_function_call_add_argument (vcast, (ValaCCodeExpression*) (_tmp12 = vala_ccode_identifier_new (_tmp11 = g_strdup_printf ("%s_parent_class", _tmp10 = vala_symbol_get_lower_case_cname ((ValaSymbol*) ((ValaCCodeBaseModule*) self)->current_class, NULL)))));
				(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
				_tmp11 = (g_free (_tmp11), NULL);
				_tmp10 = (g_free (_tmp10), NULL);
				_tmp13 = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp13 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) vcast, vala_symbol_get_name ((ValaSymbol*) m))));
				(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
				(base_class == NULL) ? NULL : (base_class = (vala_code_node_unref (base_class), NULL));
				(vcast == NULL) ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL));
				(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
				(pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL));
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
				return;
			} else {
				if (vala_method_get_base_interface_method (m) != NULL) {
					ValaInterface* _tmp14;
					ValaInterface* base_iface;
					char* _tmp16;
					char* _tmp15;
					char* _tmp17;
					char* parent_iface_var;
					ValaCCodeMemberAccess* _tmp19;
					ValaCCodeIdentifier* _tmp18;
					_tmp14 = NULL;
					base_iface = (_tmp14 = VALA_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_method_get_base_interface_method (m))), (_tmp14 == NULL) ? NULL : vala_code_node_ref (_tmp14));
					_tmp16 = NULL;
					_tmp15 = NULL;
					_tmp17 = NULL;
					parent_iface_var = (_tmp17 = g_strdup_printf ("%s_%s_parent_iface", _tmp15 = vala_symbol_get_lower_case_cname ((ValaSymbol*) ((ValaCCodeBaseModule*) self)->current_class, NULL), _tmp16 = vala_symbol_get_lower_case_cname ((ValaSymbol*) base_iface, NULL)), _tmp16 = (g_free (_tmp16), NULL), _tmp15 = (g_free (_tmp15), NULL), _tmp17);
					_tmp19 = NULL;
					_tmp18 = NULL;
					vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp19 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp18 = vala_ccode_identifier_new (parent_iface_var)), vala_symbol_get_name ((ValaSymbol*) m))));
					(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
					(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
					(base_iface == NULL) ? NULL : (base_iface = (vala_code_node_unref (base_iface), NULL));
					parent_iface_var = (g_free (parent_iface_var), NULL);
					(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
					(pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL));
					(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
					return;
				}
			}
		}
		if (vala_method_get_base_method (m) != NULL) {
			if (!vala_ccode_module_method_has_wrapper (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_method_get_base_method (m))) {
				ValaCCodeExpression* _tmp20;
				ValaCCodeExpression* inst;
				gboolean _tmp21;
				ValaClass* _tmp23;
				ValaClass* base_class;
				ValaCCodeIdentifier* _tmp26;
				char* _tmp25;
				char* _tmp24;
				ValaCCodeFunctionCall* _tmp27;
				ValaCCodeFunctionCall* vclass;
				ValaCCodeMemberAccess* _tmp28;
				_tmp20 = NULL;
				inst = (_tmp20 = pub_inst, (_tmp20 == NULL) ? NULL : vala_ccode_node_ref (_tmp20));
				_tmp21 = FALSE;
				if (vala_member_access_get_inner (expr) != NULL) {
					_tmp21 = !vala_expression_is_pure (vala_member_access_get_inner (expr));
				} else {
					_tmp21 = FALSE;
				}
				if (_tmp21) {
					ValaLocalVariable* temp_var;
					ValaCCodeIdentifier* ctemp;
					ValaCCodeExpression* _tmp22;
					/* instance expression has side-effects
					 store in temp. variable*/
					temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (vala_member_access_get_inner (expr)), TRUE, NULL);
					gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
					ctemp = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var));
					_tmp22 = NULL;
					inst = (_tmp22 = (ValaCCodeExpression*) vala_ccode_assignment_new ((ValaCCodeExpression*) ctemp, pub_inst, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp22);
					vala_code_node_set_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (expr), (ValaCCodeNode*) ctemp);
					(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
					(ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL));
				}
				_tmp23 = NULL;
				base_class = (_tmp23 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_method_get_base_method (m))), (_tmp23 == NULL) ? NULL : vala_code_node_ref (_tmp23));
				_tmp26 = NULL;
				_tmp25 = NULL;
				_tmp24 = NULL;
				_tmp27 = NULL;
				vclass = (_tmp27 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp26 = vala_ccode_identifier_new (_tmp25 = g_strdup_printf ("%s_GET_CLASS", _tmp24 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) base_class, NULL))))), (_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL)), _tmp25 = (g_free (_tmp25), NULL), _tmp24 = (g_free (_tmp24), NULL), _tmp27);
				vala_ccode_function_call_add_argument (vclass, inst);
				_tmp28 = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp28 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) vclass, vala_symbol_get_name ((ValaSymbol*) m))));
				(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
				(inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL));
				(base_class == NULL) ? NULL : (base_class = (vala_code_node_unref (base_class), NULL));
				(vclass == NULL) ? NULL : (vclass = (vala_ccode_node_unref (vclass), NULL));
			} else {
				ValaCCodeIdentifier* _tmp30;
				char* _tmp29;
				_tmp30 = NULL;
				_tmp29 = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp30 = vala_ccode_identifier_new (_tmp29 = vala_method_get_cname (vala_method_get_base_method (m)))));
				(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
				_tmp29 = (g_free (_tmp29), NULL);
			}
		} else {
			if (vala_method_get_base_interface_method (m) != NULL) {
				ValaCCodeIdentifier* _tmp32;
				char* _tmp31;
				_tmp32 = NULL;
				_tmp31 = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp32 = vala_ccode_identifier_new (_tmp31 = vala_method_get_cname (vala_method_get_base_interface_method (m)))));
				(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
				_tmp31 = (g_free (_tmp31), NULL);
			} else {
				if (VALA_IS_CREATION_METHOD (m)) {
					ValaCCodeIdentifier* _tmp34;
					char* _tmp33;
					_tmp34 = NULL;
					_tmp33 = NULL;
					vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp34 = vala_ccode_identifier_new (_tmp33 = vala_method_get_real_cname (m))));
					(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
					_tmp33 = (g_free (_tmp33), NULL);
				} else {
					ValaCCodeIdentifier* _tmp36;
					char* _tmp35;
					_tmp36 = NULL;
					_tmp35 = NULL;
					vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp36 = vala_ccode_identifier_new (_tmp35 = vala_method_get_cname (m))));
					(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
					_tmp35 = (g_free (_tmp35), NULL);
				}
			}
		}
		(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
	} else {
		if (VALA_IS_ARRAY_LENGTH_FIELD (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
			ValaCCodeExpression* _tmp37;
			_tmp37 = NULL;
			vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp37 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_member_access_get_inner (expr), 1)));
			(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
		} else {
			if (VALA_IS_FIELD (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
				ValaField* _tmp38;
				ValaField* f;
				gboolean _tmp80;
				_tmp38 = NULL;
				f = (_tmp38 = VALA_FIELD (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp38 == NULL) ? NULL : vala_code_node_ref (_tmp38));
				if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
					ValaDataType* instance_target_type;
					ValaClass* _tmp40;
					ValaTypeSymbol* _tmp39;
					ValaClass* cl;
					gboolean _tmp41;
					gboolean is_gtypeinstance;
					ValaCCodeExpression* inst;
					gboolean _tmp43;
					gboolean _tmp47;
					instance_target_type = vala_ccode_base_module_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) f)));
					_tmp40 = NULL;
					_tmp39 = NULL;
					cl = (_tmp40 = (_tmp39 = vala_data_type_get_data_type (instance_target_type), VALA_IS_CLASS (_tmp39) ? ((ValaClass*) _tmp39) : NULL), (_tmp40 == NULL) ? NULL : vala_code_node_ref (_tmp40));
					_tmp41 = FALSE;
					if ((vala_data_type_get_data_type (instance_target_type) == VALA_TYPESYMBOL (cl))) {
						gboolean _tmp42;
						_tmp42 = FALSE;
						if (cl == NULL) {
							_tmp42 = TRUE;
						} else {
							_tmp42 = !vala_class_get_is_compact (cl);
						}
						_tmp41 = (_tmp42);
					} else {
						_tmp41 = FALSE;
					}
					is_gtypeinstance = (_tmp41);
					inst = NULL;
					_tmp43 = FALSE;
					if (is_gtypeinstance) {
						_tmp43 = vala_symbol_get_access ((ValaSymbol*) f) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
					} else {
						_tmp43 = FALSE;
					}
					if (_tmp43) {
						ValaCCodeExpression* _tmp44;
						_tmp44 = NULL;
						inst = (_tmp44 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (pub_inst, "priv"), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp44);
					} else {
						ValaCCodeExpression* _tmp46;
						ValaCCodeExpression* _tmp45;
						_tmp46 = NULL;
						_tmp45 = NULL;
						inst = (_tmp46 = (_tmp45 = pub_inst, (_tmp45 == NULL) ? NULL : vala_ccode_node_ref (_tmp45)), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp46);
					}
					_tmp47 = FALSE;
					if (vala_typesymbol_is_reference_type (vala_data_type_get_data_type (instance_target_type))) {
						_tmp47 = TRUE;
					} else {
						gboolean _tmp48;
						_tmp48 = FALSE;
						if (vala_member_access_get_inner (expr) != NULL) {
							_tmp48 = VALA_IS_POINTER_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (expr)));
						} else {
							_tmp48 = FALSE;
						}
						_tmp47 = (_tmp48);
					}
					if (_tmp47) {
						ValaCCodeMemberAccess* _tmp50;
						char* _tmp49;
						_tmp50 = NULL;
						_tmp49 = NULL;
						vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp50 = vala_ccode_member_access_new_pointer (inst, _tmp49 = vala_field_get_cname (f))));
						(_tmp50 == NULL) ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL));
						_tmp49 = (g_free (_tmp49), NULL);
					} else {
						ValaCCodeMemberAccess* _tmp52;
						char* _tmp51;
						_tmp52 = NULL;
						_tmp51 = NULL;
						vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp52 = vala_ccode_member_access_new (inst, _tmp51 = vala_field_get_cname (f), FALSE)));
						(_tmp52 == NULL) ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL));
						_tmp51 = (g_free (_tmp51), NULL);
					}
					(instance_target_type == NULL) ? NULL : (instance_target_type = (vala_code_node_unref (instance_target_type), NULL));
					(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
					(inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL));
				} else {
					if (vala_field_get_binding (f) == MEMBER_BINDING_CLASS) {
						ValaClass* _tmp53;
						ValaClass* cl;
						ValaCCodeIdentifier* _tmp56;
						char* _tmp55;
						char* _tmp54;
						ValaCCodeFunctionCall* _tmp57;
						ValaCCodeFunctionCall* cast;
						ValaCCodeExpression* klass;
						_tmp53 = NULL;
						cl = (_tmp53 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) f)), (_tmp53 == NULL) ? NULL : vala_code_node_ref (_tmp53));
						_tmp56 = NULL;
						_tmp55 = NULL;
						_tmp54 = NULL;
						_tmp57 = NULL;
						cast = (_tmp57 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp56 = vala_ccode_identifier_new (_tmp55 = g_strconcat (_tmp54 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL), "_CLASS", NULL)))), (_tmp56 == NULL) ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL)), _tmp55 = (g_free (_tmp55), NULL), _tmp54 = (g_free (_tmp54), NULL), _tmp57);
						klass = NULL;
						if (vala_member_access_get_inner (expr) == NULL) {
							if (((ValaCCodeBaseModule*) self)->in_static_or_class_ctor) {
								ValaCCodeExpression* _tmp58;
								/* Accessing the field from a static or class constructor*/
								_tmp58 = NULL;
								klass = (_tmp58 = (ValaCCodeExpression*) vala_ccode_identifier_new ("klass"), (klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)), _tmp58);
							} else {
								ValaCCodeIdentifier* _tmp59;
								ValaCCodeFunctionCall* _tmp60;
								ValaCCodeFunctionCall* k;
								ValaCCodeIdentifier* _tmp61;
								ValaCCodeExpression* _tmp63;
								ValaCCodeExpression* _tmp62;
								/* Accessing the field from within an instance method*/
								_tmp59 = NULL;
								_tmp60 = NULL;
								k = (_tmp60 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp59 = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS"))), (_tmp59 == NULL) ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL)), _tmp60);
								_tmp61 = NULL;
								vala_ccode_function_call_add_argument (k, (ValaCCodeExpression*) (_tmp61 = vala_ccode_identifier_new ("self")));
								(_tmp61 == NULL) ? NULL : (_tmp61 = (vala_ccode_node_unref (_tmp61), NULL));
								_tmp63 = NULL;
								_tmp62 = NULL;
								klass = (_tmp63 = (_tmp62 = (ValaCCodeExpression*) k, (_tmp62 == NULL) ? NULL : vala_ccode_node_ref (_tmp62)), (klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)), _tmp63);
								(k == NULL) ? NULL : (k = (vala_ccode_node_unref (k), NULL));
							}
						} else {
							ValaCCodeIdentifier* _tmp64;
							ValaCCodeFunctionCall* _tmp65;
							ValaCCodeFunctionCall* k;
							ValaCCodeExpression* _tmp67;
							ValaCCodeExpression* _tmp66;
							/* Accessing the field of an instance*/
							_tmp64 = NULL;
							_tmp65 = NULL;
							k = (_tmp65 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp64 = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS"))), (_tmp64 == NULL) ? NULL : (_tmp64 = (vala_ccode_node_unref (_tmp64), NULL)), _tmp65);
							vala_ccode_function_call_add_argument (k, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (expr))));
							_tmp67 = NULL;
							_tmp66 = NULL;
							klass = (_tmp67 = (_tmp66 = (ValaCCodeExpression*) k, (_tmp66 == NULL) ? NULL : vala_ccode_node_ref (_tmp66)), (klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)), _tmp67);
							(k == NULL) ? NULL : (k = (vala_ccode_node_unref (k), NULL));
						}
						vala_ccode_function_call_add_argument (cast, klass);
						if (vala_symbol_get_access ((ValaSymbol*) f) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
							ValaCCodeIdentifier* _tmp70;
							char* _tmp69;
							char* _tmp68;
							ValaCCodeFunctionCall* _tmp71;
							ValaCCodeFunctionCall* ccall;
							ValaCCodeIdentifier* _tmp72;
							ValaCCodeFunctionCall* _tmp73;
							ValaCCodeFunctionCall* ccall2;
							ValaCCodeMemberAccess* _tmp75;
							char* _tmp74;
							_tmp70 = NULL;
							_tmp69 = NULL;
							_tmp68 = NULL;
							_tmp71 = NULL;
							ccall = (_tmp71 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp70 = vala_ccode_identifier_new (_tmp69 = g_strdup_printf ("%s_GET_CLASS_PRIVATE", _tmp68 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL))))), (_tmp70 == NULL) ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL)), _tmp69 = (g_free (_tmp69), NULL), _tmp68 = (g_free (_tmp68), NULL), _tmp71);
							_tmp72 = NULL;
							_tmp73 = NULL;
							ccall2 = (_tmp73 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp72 = vala_ccode_identifier_new ("G_TYPE_FROM_CLASS"))), (_tmp72 == NULL) ? NULL : (_tmp72 = (vala_ccode_node_unref (_tmp72), NULL)), _tmp73);
							vala_ccode_function_call_add_argument (ccall2, (ValaCCodeExpression*) cast);
							vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) ccall2);
							_tmp75 = NULL;
							_tmp74 = NULL;
							vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp75 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ccall, _tmp74 = vala_field_get_cname (f))));
							(_tmp75 == NULL) ? NULL : (_tmp75 = (vala_ccode_node_unref (_tmp75), NULL));
							_tmp74 = (g_free (_tmp74), NULL);
							(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
							(ccall2 == NULL) ? NULL : (ccall2 = (vala_ccode_node_unref (ccall2), NULL));
						} else {
							ValaCCodeMemberAccess* _tmp77;
							char* _tmp76;
							_tmp77 = NULL;
							_tmp76 = NULL;
							vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp77 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) cast, _tmp76 = vala_field_get_cname (f))));
							(_tmp77 == NULL) ? NULL : (_tmp77 = (vala_ccode_node_unref (_tmp77), NULL));
							_tmp76 = (g_free (_tmp76), NULL);
						}
						(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
						(cast == NULL) ? NULL : (cast = (vala_ccode_node_unref (cast), NULL));
						(klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL));
					} else {
						ValaCCodeIdentifier* _tmp79;
						char* _tmp78;
						_tmp79 = NULL;
						_tmp78 = NULL;
						vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp79 = vala_ccode_identifier_new (_tmp78 = vala_field_get_cname (f))));
						(_tmp79 == NULL) ? NULL : (_tmp79 = (vala_ccode_node_unref (_tmp79), NULL));
						_tmp78 = (g_free (_tmp78), NULL);
					}
				}
				_tmp80 = FALSE;
				if (vala_data_type_get_type_parameter (vala_field_get_field_type (f)) != NULL) {
					_tmp80 = vala_data_type_get_type_parameter (vala_expression_get_value_type ((ValaExpression*) expr)) == NULL;
				} else {
					_tmp80 = FALSE;
				}
				if (_tmp80) {
					ValaCCodeExpression* _tmp81;
					_tmp81 = NULL;
					vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp81 = vala_ccode_base_module_convert_from_generic_pointer ((ValaCCodeBaseModule*) self, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) expr)), vala_expression_get_value_type ((ValaExpression*) expr))));
					(_tmp81 == NULL) ? NULL : (_tmp81 = (vala_ccode_node_unref (_tmp81), NULL));
				}
				(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
			} else {
				if (VALA_IS_CONSTANT (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
					ValaConstant* _tmp82;
					ValaConstant* c;
					ValaCCodeIdentifier* _tmp84;
					char* _tmp83;
					_tmp82 = NULL;
					c = (_tmp82 = VALA_CONSTANT (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp82 == NULL) ? NULL : vala_code_node_ref (_tmp82));
					_tmp84 = NULL;
					_tmp83 = NULL;
					vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp84 = vala_ccode_identifier_new (_tmp83 = vala_constant_get_cname (c))));
					(_tmp84 == NULL) ? NULL : (_tmp84 = (vala_ccode_node_unref (_tmp84), NULL));
					_tmp83 = (g_free (_tmp83), NULL);
					(c == NULL) ? NULL : (c = (vala_code_node_unref (c), NULL));
				} else {
					if (VALA_IS_PROPERTY (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
						ValaProperty* _tmp85;
						ValaProperty* prop;
						gboolean _tmp105;
						gboolean _tmp106;
						gboolean _tmp107;
						_tmp85 = NULL;
						prop = (_tmp85 = VALA_PROPERTY (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp85 == NULL) ? NULL : vala_code_node_ref (_tmp85));
						if (VALA_IS_BASE_ACCESS (vala_member_access_get_inner (expr))) {
							if (vala_property_get_base_property (prop) != NULL) {
								ValaClass* _tmp86;
								ValaClass* base_class;
								ValaCCodeIdentifier* _tmp89;
								char* _tmp88;
								char* _tmp87;
								ValaCCodeFunctionCall* _tmp90;
								ValaCCodeFunctionCall* vcast;
								ValaCCodeIdentifier* _tmp93;
								char* _tmp92;
								char* _tmp91;
								ValaCCodeMemberAccess* _tmp95;
								char* _tmp94;
								ValaCCodeFunctionCall* _tmp96;
								ValaCCodeFunctionCall* ccall;
								_tmp86 = NULL;
								base_class = (_tmp86 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_property_get_base_property (prop))), (_tmp86 == NULL) ? NULL : vala_code_node_ref (_tmp86));
								_tmp89 = NULL;
								_tmp88 = NULL;
								_tmp87 = NULL;
								_tmp90 = NULL;
								vcast = (_tmp90 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp89 = vala_ccode_identifier_new (_tmp88 = g_strdup_printf ("%s_CLASS", _tmp87 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) base_class, NULL))))), (_tmp89 == NULL) ? NULL : (_tmp89 = (vala_ccode_node_unref (_tmp89), NULL)), _tmp88 = (g_free (_tmp88), NULL), _tmp87 = (g_free (_tmp87), NULL), _tmp90);
								_tmp93 = NULL;
								_tmp92 = NULL;
								_tmp91 = NULL;
								vala_ccode_function_call_add_argument (vcast, (ValaCCodeExpression*) (_tmp93 = vala_ccode_identifier_new (_tmp92 = g_strdup_printf ("%s_parent_class", _tmp91 = vala_symbol_get_lower_case_cname ((ValaSymbol*) ((ValaCCodeBaseModule*) self)->current_class, NULL)))));
								(_tmp93 == NULL) ? NULL : (_tmp93 = (vala_ccode_node_unref (_tmp93), NULL));
								_tmp92 = (g_free (_tmp92), NULL);
								_tmp91 = (g_free (_tmp91), NULL);
								_tmp95 = NULL;
								_tmp94 = NULL;
								_tmp96 = NULL;
								ccall = (_tmp96 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp95 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) vcast, _tmp94 = g_strdup_printf ("get_%s", vala_symbol_get_name ((ValaSymbol*) prop))))), (_tmp95 == NULL) ? NULL : (_tmp95 = (vala_ccode_node_unref (_tmp95), NULL)), _tmp94 = (g_free (_tmp94), NULL), _tmp96);
								vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (expr))));
								vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall);
								(base_class == NULL) ? NULL : (base_class = (vala_code_node_unref (base_class), NULL));
								(vcast == NULL) ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL));
								(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
								(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
								(pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL));
								(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
								return;
							} else {
								if (vala_property_get_base_interface_property (prop) != NULL) {
									ValaInterface* _tmp97;
									ValaInterface* base_iface;
									char* _tmp99;
									char* _tmp98;
									char* _tmp100;
									char* parent_iface_var;
									ValaCCodeMemberAccess* _tmp103;
									char* _tmp102;
									ValaCCodeIdentifier* _tmp101;
									ValaCCodeFunctionCall* _tmp104;
									ValaCCodeFunctionCall* ccall;
									_tmp97 = NULL;
									base_iface = (_tmp97 = VALA_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_property_get_base_interface_property (prop))), (_tmp97 == NULL) ? NULL : vala_code_node_ref (_tmp97));
									_tmp99 = NULL;
									_tmp98 = NULL;
									_tmp100 = NULL;
									parent_iface_var = (_tmp100 = g_strdup_printf ("%s_%s_parent_iface", _tmp98 = vala_symbol_get_lower_case_cname ((ValaSymbol*) ((ValaCCodeBaseModule*) self)->current_class, NULL), _tmp99 = vala_symbol_get_lower_case_cname ((ValaSymbol*) base_iface, NULL)), _tmp99 = (g_free (_tmp99), NULL), _tmp98 = (g_free (_tmp98), NULL), _tmp100);
									_tmp103 = NULL;
									_tmp102 = NULL;
									_tmp101 = NULL;
									_tmp104 = NULL;
									ccall = (_tmp104 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp103 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp101 = vala_ccode_identifier_new (parent_iface_var)), _tmp102 = g_strdup_printf ("get_%s", vala_symbol_get_name ((ValaSymbol*) prop))))), (_tmp103 == NULL) ? NULL : (_tmp103 = (vala_ccode_node_unref (_tmp103), NULL)), _tmp102 = (g_free (_tmp102), NULL), (_tmp101 == NULL) ? NULL : (_tmp101 = (vala_ccode_node_unref (_tmp101), NULL)), _tmp104);
									vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (expr))));
									vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall);
									(base_iface == NULL) ? NULL : (base_iface = (vala_code_node_unref (base_iface), NULL));
									parent_iface_var = (g_free (parent_iface_var), NULL);
									(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
									(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
									(pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL));
									(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
									return;
								}
							}
						}
						_tmp105 = FALSE;
						_tmp106 = FALSE;
						_tmp107 = FALSE;
						if (vala_property_accessor_get_automatic_body (vala_property_get_get_accessor (prop))) {
							_tmp107 = VALA_SYMBOL (((ValaCCodeBaseModule*) self)->current_type_symbol) == vala_symbol_get_parent_symbol ((ValaSymbol*) prop);
						} else {
							_tmp107 = FALSE;
						}
						if (_tmp107) {
							_tmp106 = vala_property_get_base_property (prop) == NULL;
						} else {
							_tmp106 = FALSE;
						}
						if (_tmp106) {
							_tmp105 = vala_property_get_base_interface_property (prop) == NULL;
						} else {
							_tmp105 = FALSE;
						}
						if (_tmp105) {
							ValaCCodeExpression* inst;
							ValaCCodeExpression* _tmp108;
							ValaCCodeMemberAccess* _tmp110;
							char* _tmp109;
							inst = NULL;
							_tmp108 = NULL;
							inst = (_tmp108 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (pub_inst, "priv"), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp108);
							_tmp110 = NULL;
							_tmp109 = NULL;
							vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp110 = vala_ccode_member_access_new_pointer (inst, _tmp109 = vala_field_get_cname (vala_property_get_field (prop)))));
							(_tmp110 == NULL) ? NULL : (_tmp110 = (vala_ccode_node_unref (_tmp110), NULL));
							_tmp109 = (g_free (_tmp109), NULL);
							(inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL));
						} else {
							if (!vala_property_get_no_accessor_method (prop)) {
								ValaProperty* _tmp111;
								ValaProperty* base_property;
								char* getter_cname;
								ValaCCodeIdentifier* _tmp118;
								ValaCCodeFunctionCall* _tmp119;
								ValaCCodeFunctionCall* ccall;
								_tmp111 = NULL;
								base_property = (_tmp111 = prop, (_tmp111 == NULL) ? NULL : vala_code_node_ref (_tmp111));
								if (vala_property_get_base_property (prop) != NULL) {
									ValaProperty* _tmp113;
									ValaProperty* _tmp112;
									_tmp113 = NULL;
									_tmp112 = NULL;
									base_property = (_tmp113 = (_tmp112 = vala_property_get_base_property (prop), (_tmp112 == NULL) ? NULL : vala_code_node_ref (_tmp112)), (base_property == NULL) ? NULL : (base_property = (vala_code_node_unref (base_property), NULL)), _tmp113);
								} else {
									if (vala_property_get_base_interface_property (prop) != NULL) {
										ValaProperty* _tmp115;
										ValaProperty* _tmp114;
										_tmp115 = NULL;
										_tmp114 = NULL;
										base_property = (_tmp115 = (_tmp114 = vala_property_get_base_interface_property (prop), (_tmp114 == NULL) ? NULL : vala_code_node_ref (_tmp114)), (base_property == NULL) ? NULL : (base_property = (vala_code_node_unref (base_property), NULL)), _tmp115);
									}
								}
								getter_cname = NULL;
								if (VALA_IS_DYNAMIC_PROPERTY (prop)) {
									char* _tmp116;
									_tmp116 = NULL;
									getter_cname = (_tmp116 = vala_ccode_module_get_dynamic_property_getter_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), VALA_DYNAMIC_PROPERTY (prop)), getter_cname = (g_free (getter_cname), NULL), _tmp116);
								} else {
									char* _tmp117;
									_tmp117 = NULL;
									getter_cname = (_tmp117 = vala_property_accessor_get_cname (vala_property_get_get_accessor (base_property)), getter_cname = (g_free (getter_cname), NULL), _tmp117);
								}
								_tmp118 = NULL;
								_tmp119 = NULL;
								ccall = (_tmp119 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp118 = vala_ccode_identifier_new (getter_cname))), (_tmp118 == NULL) ? NULL : (_tmp118 = (vala_ccode_node_unref (_tmp118), NULL)), _tmp119);
								if (vala_property_get_binding (prop) == MEMBER_BINDING_INSTANCE) {
									vala_ccode_function_call_add_argument (ccall, pub_inst);
								}
								/* Property access to real struct types is handled differently
								 The value is returned by out parameter*/
								if (vala_data_type_is_real_struct_type (vala_property_get_property_type (base_property))) {
									ValaCCodeCommaExpression* ccomma;
									ValaLocalVariable* temp_var;
									ValaCCodeIdentifier* ctemp;
									ValaCCodeUnaryExpression* _tmp120;
									ccomma = vala_ccode_comma_expression_new ();
									temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_property_accessor_get_value_type (vala_property_get_get_accessor (base_property)), TRUE, NULL);
									ctemp = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var));
									gee_collection_add ((GeeCollection*) ((ValaCCodeBaseModule*) self)->temp_vars, temp_var);
									_tmp120 = NULL;
									vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp120 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) ctemp)));
									(_tmp120 == NULL) ? NULL : (_tmp120 = (vala_ccode_node_unref (_tmp120), NULL));
									vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) ccall);
									vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) ctemp);
									vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccomma);
									(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
									(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
									(ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL));
								} else {
									vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall);
								}
								(base_property == NULL) ? NULL : (base_property = (vala_code_node_unref (base_property), NULL));
								getter_cname = (g_free (getter_cname), NULL);
								(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
							} else {
								ValaCCodeIdentifier* _tmp121;
								ValaCCodeFunctionCall* _tmp122;
								ValaCCodeFunctionCall* ccall;
								ValaCCodeConstant* _tmp123;
								ValaCCodeCommaExpression* ccomma;
								ValaLocalVariable* temp_var;
								ValaCCodeIdentifier* ctemp;
								ValaCCodeUnaryExpression* _tmp124;
								ValaCCodeConstant* _tmp125;
								_tmp121 = NULL;
								_tmp122 = NULL;
								ccall = (_tmp122 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp121 = vala_ccode_identifier_new ("g_object_get"))), (_tmp121 == NULL) ? NULL : (_tmp121 = (vala_ccode_node_unref (_tmp121), NULL)), _tmp122);
								vala_ccode_function_call_add_argument (ccall, pub_inst);
								/* property name is second argument of g_object_get*/
								_tmp123 = NULL;
								vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp123 = vala_property_get_canonical_cconstant (prop)));
								(_tmp123 == NULL) ? NULL : (_tmp123 = (vala_ccode_node_unref (_tmp123), NULL));
								/* g_object_get always returns owned values
								 therefore, property getters of properties
								 without accessor methods need to be marked as owned*/
								ccomma = vala_ccode_comma_expression_new ();
								temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_value_type ((ValaExpression*) expr), TRUE, NULL);
								ctemp = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var));
								gee_collection_add ((GeeCollection*) ((ValaCCodeBaseModule*) self)->temp_vars, temp_var);
								_tmp124 = NULL;
								vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp124 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) ctemp)));
								(_tmp124 == NULL) ? NULL : (_tmp124 = (vala_ccode_node_unref (_tmp124), NULL));
								_tmp125 = NULL;
								vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp125 = vala_ccode_constant_new ("NULL")));
								(_tmp125 == NULL) ? NULL : (_tmp125 = (vala_ccode_node_unref (_tmp125), NULL));
								vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) ccall);
								vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) ctemp);
								vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccomma);
								(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
								(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
								(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
								(ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL));
							}
						}
						(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
					} else {
						if (VALA_IS_ENUM_VALUE (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
							ValaEnumValue* _tmp126;
							ValaEnumValue* ev;
							ValaCCodeConstant* _tmp128;
							char* _tmp127;
							_tmp126 = NULL;
							ev = (_tmp126 = VALA_ENUM_VALUE (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp126 == NULL) ? NULL : vala_code_node_ref (_tmp126));
							_tmp128 = NULL;
							_tmp127 = NULL;
							vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp128 = vala_ccode_constant_new (_tmp127 = vala_enum_value_get_cname (ev))));
							(_tmp128 == NULL) ? NULL : (_tmp128 = (vala_ccode_node_unref (_tmp128), NULL));
							_tmp127 = (g_free (_tmp127), NULL);
							(ev == NULL) ? NULL : (ev = (vala_code_node_unref (ev), NULL));
						} else {
							if (VALA_IS_LOCAL_VARIABLE (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
								ValaLocalVariable* _tmp129;
								ValaLocalVariable* local;
								ValaCCodeExpression* _tmp130;
								_tmp129 = NULL;
								local = (_tmp129 = VALA_LOCAL_VARIABLE (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp129 == NULL) ? NULL : vala_code_node_ref (_tmp129));
								_tmp130 = NULL;
								vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp130 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) local))));
								(_tmp130 == NULL) ? NULL : (_tmp130 = (vala_ccode_node_unref (_tmp130), NULL));
								(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
							} else {
								if (VALA_IS_FORMAL_PARAMETER (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
									ValaFormalParameter* _tmp131;
									ValaFormalParameter* p;
									_tmp131 = NULL;
									p = (_tmp131 = VALA_FORMAL_PARAMETER (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp131 == NULL) ? NULL : vala_code_node_ref (_tmp131));
									if (_vala_strcmp0 (vala_symbol_get_name ((ValaSymbol*) p), "this") == 0) {
										gboolean _tmp132;
										_tmp132 = FALSE;
										if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
											_tmp132 = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
										} else {
											_tmp132 = FALSE;
										}
										if (_tmp132) {
											ValaCCodeExpression* _tmp133;
											/* use closure*/
											_tmp133 = NULL;
											vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp133 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "self")));
											(_tmp133 == NULL) ? NULL : (_tmp133 = (vala_ccode_node_unref (_tmp133), NULL));
										} else {
											ValaStruct* _tmp135;
											ValaTypeSymbol* _tmp134;
											ValaStruct* st;
											gboolean _tmp136;
											_tmp135 = NULL;
											_tmp134 = NULL;
											st = (_tmp135 = (_tmp134 = ((ValaCCodeBaseModule*) self)->current_type_symbol, VALA_IS_STRUCT (_tmp134) ? ((ValaStruct*) _tmp134) : NULL), (_tmp135 == NULL) ? NULL : vala_code_node_ref (_tmp135));
											_tmp136 = FALSE;
											if (st != NULL) {
												_tmp136 = !vala_struct_is_simple_type (st);
											} else {
												_tmp136 = FALSE;
											}
											if (_tmp136) {
												ValaCCodeIdentifier* _tmp137;
												_tmp137 = NULL;
												vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp137 = vala_ccode_identifier_new ("(*self)")));
												(_tmp137 == NULL) ? NULL : (_tmp137 = (vala_ccode_node_unref (_tmp137), NULL));
											} else {
												ValaCCodeIdentifier* _tmp138;
												_tmp138 = NULL;
												vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp138 = vala_ccode_identifier_new ("self")));
												(_tmp138 == NULL) ? NULL : (_tmp138 = (vala_ccode_node_unref (_tmp138), NULL));
											}
											(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
										}
									} else {
										gboolean _tmp139;
										_tmp139 = FALSE;
										if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
											_tmp139 = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
										} else {
											_tmp139 = FALSE;
										}
										if (_tmp139) {
											ValaCCodeExpression* _tmp140;
											/* use closure*/
											_tmp140 = NULL;
											vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp140 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) p))));
											(_tmp140 == NULL) ? NULL : (_tmp140 = (vala_ccode_node_unref (_tmp140), NULL));
										} else {
											ValaStruct* _tmp142;
											ValaTypeSymbol* _tmp141;
											ValaStruct* type_as_struct;
											gboolean _tmp143;
											_tmp142 = NULL;
											_tmp141 = NULL;
											type_as_struct = (_tmp142 = (_tmp141 = vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (p)), VALA_IS_STRUCT (_tmp141) ? ((ValaStruct*) _tmp141) : NULL), (_tmp142 == NULL) ? NULL : vala_code_node_ref (_tmp142));
											_tmp143 = FALSE;
											if (vala_formal_parameter_get_direction (p) != VALA_PARAMETER_DIRECTION_IN) {
												_tmp143 = TRUE;
											} else {
												gboolean _tmp144;
												gboolean _tmp145;
												_tmp144 = FALSE;
												_tmp145 = FALSE;
												if (type_as_struct != NULL) {
													_tmp145 = !vala_struct_is_simple_type (type_as_struct);
												} else {
													_tmp145 = FALSE;
												}
												if (_tmp145) {
													_tmp144 = !vala_data_type_get_nullable (vala_formal_parameter_get_parameter_type (p));
												} else {
													_tmp144 = FALSE;
												}
												_tmp143 = (_tmp144);
											}
											if (_tmp143) {
												ValaCCodeIdentifier* _tmp147;
												char* _tmp146;
												_tmp147 = NULL;
												_tmp146 = NULL;
												vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp147 = vala_ccode_identifier_new (_tmp146 = g_strdup_printf ("(*%s)", vala_symbol_get_name ((ValaSymbol*) p)))));
												(_tmp147 == NULL) ? NULL : (_tmp147 = (vala_ccode_node_unref (_tmp147), NULL));
												_tmp146 = (g_free (_tmp146), NULL);
											} else {
												gboolean _tmp148;
												gboolean _tmp149;
												gboolean _tmp150;
												_tmp148 = FALSE;
												_tmp149 = FALSE;
												_tmp150 = FALSE;
												if (((ValaCCodeBaseModule*) self)->current_property_accessor != NULL) {
													_tmp150 = vala_property_accessor_get_writable (((ValaCCodeBaseModule*) self)->current_property_accessor);
												} else {
													_tmp150 = FALSE;
												}
												if (_tmp150) {
													_tmp149 = vala_property_accessor_get_value_parameter (((ValaCCodeBaseModule*) self)->current_property_accessor) == p;
												} else {
													_tmp149 = FALSE;
												}
												if (_tmp149) {
													_tmp148 = vala_data_type_is_real_struct_type (vala_property_get_property_type (vala_property_accessor_get_prop (((ValaCCodeBaseModule*) self)->current_property_accessor)));
												} else {
													_tmp148 = FALSE;
												}
												/* Property setters of non simple structs shall replace all occurences
												 of the "value" formal parameter with a dereferencing version of that
												 parameter.*/
												if (_tmp148) {
													ValaCCodeIdentifier* _tmp151;
													_tmp151 = NULL;
													vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp151 = vala_ccode_identifier_new ("(*value)")));
													(_tmp151 == NULL) ? NULL : (_tmp151 = (vala_ccode_node_unref (_tmp151), NULL));
												} else {
													ValaCCodeIdentifier* _tmp152;
													_tmp152 = NULL;
													vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp152 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) p))));
													(_tmp152 == NULL) ? NULL : (_tmp152 = (vala_ccode_node_unref (_tmp152), NULL));
												}
											}
											(type_as_struct == NULL) ? NULL : (type_as_struct = (vala_code_node_unref (type_as_struct), NULL));
										}
									}
									(p == NULL) ? NULL : (p = (vala_code_node_unref (p), NULL));
								}
							}
						}
					}
				}
			}
		}
	}
	(pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL));
	(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
}


static void vala_ccode_member_access_module_class_init (ValaCCodeMemberAccessModuleClass * klass) {
	vala_ccode_member_access_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->visit_member_access = vala_ccode_member_access_module_real_visit_member_access;
}


static void vala_ccode_member_access_module_instance_init (ValaCCodeMemberAccessModule * self) {
}


GType vala_ccode_member_access_module_get_type (void) {
	static GType vala_ccode_member_access_module_type_id = 0;
	if (vala_ccode_member_access_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMemberAccessModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_member_access_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMemberAccessModule), 0, (GInstanceInitFunc) vala_ccode_member_access_module_instance_init, NULL };
		vala_ccode_member_access_module_type_id = g_type_register_static (VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, "ValaCCodeMemberAccessModule", &g_define_type_info, 0);
	}
	return vala_ccode_member_access_module_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




