/* valabasicblock.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALABASICBLOCK_H__
#define __VALA_VALABASICBLOCK_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/list.h>
#include <gee/set.h>
#include <vala/valacodenode.h>
#include <vala/valaphifunction.h>

G_BEGIN_DECLS


#define VALA_TYPE_BASIC_BLOCK (vala_basic_block_get_type ())
#define VALA_BASIC_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BASIC_BLOCK, ValaBasicBlock))
#define VALA_BASIC_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BASIC_BLOCK, ValaBasicBlockClass))
#define VALA_IS_BASIC_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BASIC_BLOCK))
#define VALA_IS_BASIC_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BASIC_BLOCK))
#define VALA_BASIC_BLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BASIC_BLOCK, ValaBasicBlockClass))

typedef struct _ValaBasicBlockPrivate ValaBasicBlockPrivate;
typedef struct _ValaParamSpecBasicBlock ValaParamSpecBasicBlock;

/**
 * Represents a basic block, i.e. a straight-line piece of code without any
 * jumps or jump targets.
 */
struct _ValaBasicBlock {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaBasicBlockPrivate * priv;
};

struct _ValaBasicBlockClass {
	GTypeClass parent_class;
	void (*finalize) (ValaBasicBlock *self);
};

struct _ValaParamSpecBasicBlock {
	GParamSpec parent_instance;
};


ValaBasicBlock* vala_basic_block_construct (GType object_type);
ValaBasicBlock* vala_basic_block_new (void);
ValaBasicBlock* vala_basic_block_construct_entry (GType object_type);
ValaBasicBlock* vala_basic_block_new_entry (void);
ValaBasicBlock* vala_basic_block_construct_exit (GType object_type);
ValaBasicBlock* vala_basic_block_new_exit (void);
void vala_basic_block_add_node (ValaBasicBlock* self, ValaCodeNode* node);
GeeList* vala_basic_block_get_nodes (ValaBasicBlock* self);
void vala_basic_block_connect (ValaBasicBlock* self, ValaBasicBlock* target);
GeeList* vala_basic_block_get_predecessors (ValaBasicBlock* self);
GeeList* vala_basic_block_get_successors (ValaBasicBlock* self);
void vala_basic_block_add_child (ValaBasicBlock* self, ValaBasicBlock* block);
GeeList* vala_basic_block_get_children (ValaBasicBlock* self);
void vala_basic_block_add_dominator_frontier (ValaBasicBlock* self, ValaBasicBlock* block);
GeeSet* vala_basic_block_get_dominator_frontier (ValaBasicBlock* self);
void vala_basic_block_add_phi_function (ValaBasicBlock* self, ValaPhiFunction* phi);
GeeSet* vala_basic_block_get_phi_functions (ValaBasicBlock* self);
ValaBasicBlock* vala_basic_block_get_parent (ValaBasicBlock* self);
GParamSpec* vala_param_spec_basic_block (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
gpointer vala_value_get_basic_block (const GValue* value);
void vala_value_set_basic_block (GValue* value, gpointer v_object);
GType vala_basic_block_get_type (void);
gpointer vala_basic_block_ref (gpointer instance);
void vala_basic_block_unref (gpointer instance);


G_END_DECLS

#endif
