/* valaccodememberaccess.vala
 *
 * Copyright (C) 2006  Raffaele Sandrini
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 *	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodeelementaccess.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodenode.h>




struct _ValaCCodeElementAccessPrivate {
	ValaCCodeExpression* _container;
	ValaCCodeExpression* _index;
};

#define VALA_CCODE_ELEMENT_ACCESS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_ELEMENT_ACCESS, ValaCCodeElementAccessPrivate))
enum  {
	VALA_CCODE_ELEMENT_ACCESS_DUMMY_PROPERTY
};
static void vala_ccode_element_access_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_element_access_parent_class = NULL;
static void vala_ccode_element_access_finalize (ValaCCodeNode* obj);



ValaCCodeElementAccess* vala_ccode_element_access_construct (GType object_type, ValaCCodeExpression* cont, ValaCCodeExpression* i) {
	ValaCCodeElementAccess* self;
	g_return_val_if_fail (cont != NULL, NULL);
	g_return_val_if_fail (i != NULL, NULL);
	self = (ValaCCodeElementAccess*) g_type_create_instance (object_type);
	vala_ccode_element_access_set_container (self, cont);
	vala_ccode_element_access_set_index (self, i);
	return self;
}


ValaCCodeElementAccess* vala_ccode_element_access_new (ValaCCodeExpression* cont, ValaCCodeExpression* i) {
	return vala_ccode_element_access_construct (VALA_TYPE_CCODE_ELEMENT_ACCESS, cont, i);
}


static void vala_ccode_element_access_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeElementAccess * self;
	self = (ValaCCodeElementAccess*) base;
	g_return_if_fail (writer != NULL);
	vala_ccode_expression_write_inner (self->priv->_container, writer);
	vala_ccode_writer_write_string (writer, "[");
	vala_ccode_node_write ((ValaCCodeNode*) self->priv->_index, writer);
	vala_ccode_writer_write_string (writer, "]");
}


ValaCCodeExpression* vala_ccode_element_access_get_container (ValaCCodeElementAccess* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_container;
}


void vala_ccode_element_access_set_container (ValaCCodeElementAccess* self, ValaCCodeExpression* value) {
	ValaCCodeExpression* _tmp2;
	ValaCCodeExpression* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_container = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_ccode_node_ref (_tmp1)), (self->priv->_container == NULL) ? NULL : (self->priv->_container = (vala_ccode_node_unref (self->priv->_container), NULL)), _tmp2);
}


ValaCCodeExpression* vala_ccode_element_access_get_index (ValaCCodeElementAccess* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_index;
}


void vala_ccode_element_access_set_index (ValaCCodeElementAccess* self, ValaCCodeExpression* value) {
	ValaCCodeExpression* _tmp2;
	ValaCCodeExpression* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_index = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_ccode_node_ref (_tmp1)), (self->priv->_index == NULL) ? NULL : (self->priv->_index = (vala_ccode_node_unref (self->priv->_index), NULL)), _tmp2);
}


static void vala_ccode_element_access_class_init (ValaCCodeElementAccessClass * klass) {
	vala_ccode_element_access_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_ccode_element_access_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeElementAccessPrivate));
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_element_access_real_write;
}


static void vala_ccode_element_access_instance_init (ValaCCodeElementAccess * self) {
	self->priv = VALA_CCODE_ELEMENT_ACCESS_GET_PRIVATE (self);
}


static void vala_ccode_element_access_finalize (ValaCCodeNode* obj) {
	ValaCCodeElementAccess * self;
	self = VALA_CCODE_ELEMENT_ACCESS (obj);
	(self->priv->_container == NULL) ? NULL : (self->priv->_container = (vala_ccode_node_unref (self->priv->_container), NULL));
	(self->priv->_index == NULL) ? NULL : (self->priv->_index = (vala_ccode_node_unref (self->priv->_index), NULL));
	VALA_CCODE_NODE_CLASS (vala_ccode_element_access_parent_class)->finalize (obj);
}


GType vala_ccode_element_access_get_type (void) {
	static GType vala_ccode_element_access_type_id = 0;
	if (vala_ccode_element_access_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeElementAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_element_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeElementAccess), 0, (GInstanceInitFunc) vala_ccode_element_access_instance_init, NULL };
		vala_ccode_element_access_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION, "ValaCCodeElementAccess", &g_define_type_info, 0);
	}
	return vala_ccode_element_access_type_id;
}




