/* valatuple.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valatuple.h>
#include <gee/arraylist.h>
#include <gee/collection.h>




struct _ValaTuplePrivate {
	GeeList* expression_list;
};

#define VALA_TUPLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_TUPLE, ValaTuplePrivate))
enum  {
	VALA_TUPLE_DUMMY_PROPERTY
};
static gboolean vala_tuple_real_is_pure (ValaExpression* base);
static gpointer vala_tuple_parent_class = NULL;
static void vala_tuple_finalize (ValaCodeNode* obj);



ValaTuple* vala_tuple_construct (GType object_type) {
	ValaTuple* self;
	self = (ValaTuple*) g_type_create_instance (object_type);
	return self;
}


ValaTuple* vala_tuple_new (void) {
	return vala_tuple_construct (VALA_TYPE_TUPLE);
}


void vala_tuple_add_expression (ValaTuple* self, ValaExpression* expr) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (expr != NULL);
	gee_collection_add ((GeeCollection*) self->priv->expression_list, expr);
}


GeeList* vala_tuple_get_expressions (ValaTuple* self) {
	GeeList* _tmp0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0 = NULL;
	return (_tmp0 = self->priv->expression_list, (_tmp0 == NULL) ? NULL : gee_collection_object_ref (_tmp0));
}


static gboolean vala_tuple_real_is_pure (ValaExpression* base) {
	ValaTuple * self;
	self = (ValaTuple*) base;
	return FALSE;
}


static void vala_tuple_class_init (ValaTupleClass * klass) {
	vala_tuple_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_tuple_finalize;
	g_type_class_add_private (klass, sizeof (ValaTuplePrivate));
	VALA_EXPRESSION_CLASS (klass)->is_pure = vala_tuple_real_is_pure;
}


static void vala_tuple_instance_init (ValaTuple * self) {
	self->priv = VALA_TUPLE_GET_PRIVATE (self);
	self->priv->expression_list = (GeeList*) gee_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
}


static void vala_tuple_finalize (ValaCodeNode* obj) {
	ValaTuple * self;
	self = VALA_TUPLE (obj);
	(self->priv->expression_list == NULL) ? NULL : (self->priv->expression_list = (gee_collection_object_unref (self->priv->expression_list), NULL));
	VALA_CODE_NODE_CLASS (vala_tuple_parent_class)->finalize (obj);
}


GType vala_tuple_get_type (void) {
	static GType vala_tuple_type_id = 0;
	if (vala_tuple_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaTupleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_tuple_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaTuple), 0, (GInstanceInitFunc) vala_tuple_instance_init, NULL };
		vala_tuple_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaTuple", &g_define_type_info, 0);
	}
	return vala_tuple_type_id;
}




