/* valaccodeblock.c generated by valac, the Vala compiler
 * generated from valaccodeblock.vala, do not modify */

/* valaccodeblock.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "valaccode.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))

struct _ValaCCodeBlockPrivate {
	gboolean _suppress_newline;
	ValaList* statements;
};

static gint ValaCCodeBlock_private_offset;
static gpointer vala_ccode_block_parent_class = NULL;

static void vala_ccode_block_real_write (ValaCCodeNode* base,
                                  ValaCCodeWriter* writer);
static void vala_ccode_block_finalize (ValaCCodeNode * obj);
static GType vala_ccode_block_get_type_once (void);

static inline gpointer
vala_ccode_block_get_instance_private (ValaCCodeBlock* self)
{
	return G_STRUCT_MEMBER_P (self, ValaCCodeBlock_private_offset);
}

gboolean
vala_ccode_block_get_suppress_newline (ValaCCodeBlock* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_suppress_newline;
	return result;
}

void
vala_ccode_block_set_suppress_newline (ValaCCodeBlock* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_suppress_newline = value;
}

/**
 * Prepend the specified statement to the list of statements.
 */
void
vala_ccode_block_prepend_statement (ValaCCodeBlock* self,
                                    ValaCCodeNode* statement)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (statement != NULL);
	_tmp0_ = self->priv->statements;
	vala_list_insert (_tmp0_, 0, statement);
}

/**
 * Append the specified statement to the list of statements.
 */
void
vala_ccode_block_add_statement (ValaCCodeBlock* self,
                                ValaCCodeNode* statement)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (statement != NULL);
	_tmp0_ = self->priv->statements;
	vala_collection_add ((ValaCollection*) _tmp0_, statement);
}

static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}

static void
vala_ccode_block_real_write (ValaCCodeNode* base,
                             ValaCCodeWriter* writer)
{
	ValaCCodeBlock * self;
	ValaCCodeNode* last_statement = NULL;
	gboolean _tmp32_;
	self = (ValaCCodeBlock*) base;
	g_return_if_fail (writer != NULL);
	last_statement = NULL;
	vala_ccode_writer_write_begin_block (writer);
	{
		ValaList* _statement_list = NULL;
		ValaList* _tmp0_;
		gint _statement_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _statement_index = 0;
		_tmp0_ = self->priv->statements;
		_statement_list = _tmp0_;
		_tmp1_ = _statement_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_statement_size = _tmp3_;
		_statement_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaCCodeNode* statement = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaCCodeNode* _tmp8_;
			gboolean _tmp9_ = FALSE;
			ValaCCodeNode* _tmp10_;
			_statement_index = _statement_index + 1;
			_tmp4_ = _statement_index;
			_tmp5_ = _statement_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _statement_list;
			_tmp7_ = vala_list_get (_tmp6_, _statement_index);
			statement = (ValaCCodeNode*) _tmp7_;
			_tmp8_ = statement;
			vala_ccode_node_write_declaration (_tmp8_, writer);
			_tmp10_ = statement;
			if (VALA_IS_CCODE_LABEL (_tmp10_)) {
				_tmp9_ = TRUE;
			} else {
				ValaCCodeNode* _tmp11_;
				_tmp11_ = statement;
				_tmp9_ = VALA_IS_CCODE_CASE_STATEMENT (_tmp11_);
			}
			if (_tmp9_) {
				_vala_ccode_node_unref0 (last_statement);
				last_statement = NULL;
			} else {
				gboolean _tmp12_ = FALSE;
				gboolean _tmp13_ = FALSE;
				gboolean _tmp14_ = FALSE;
				ValaCCodeNode* _tmp15_;
				_tmp15_ = statement;
				if (VALA_IS_CCODE_RETURN_STATEMENT (_tmp15_)) {
					_tmp14_ = TRUE;
				} else {
					ValaCCodeNode* _tmp16_;
					_tmp16_ = statement;
					_tmp14_ = VALA_IS_CCODE_GOTO_STATEMENT (_tmp16_);
				}
				if (_tmp14_) {
					_tmp13_ = TRUE;
				} else {
					ValaCCodeNode* _tmp17_;
					_tmp17_ = statement;
					_tmp13_ = VALA_IS_CCODE_CONTINUE_STATEMENT (_tmp17_);
				}
				if (_tmp13_) {
					_tmp12_ = TRUE;
				} else {
					ValaCCodeNode* _tmp18_;
					_tmp18_ = statement;
					_tmp12_ = VALA_IS_CCODE_BREAK_STATEMENT (_tmp18_);
				}
				if (_tmp12_) {
					ValaCCodeNode* _tmp19_;
					ValaCCodeNode* _tmp20_;
					_tmp19_ = statement;
					_tmp20_ = _vala_ccode_node_ref0 (_tmp19_);
					_vala_ccode_node_unref0 (last_statement);
					last_statement = _tmp20_;
				}
			}
			_vala_ccode_node_unref0 (statement);
		}
	}
	{
		ValaList* _statement_list = NULL;
		ValaList* _tmp21_;
		gint _statement_size = 0;
		ValaList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _statement_index = 0;
		_tmp21_ = self->priv->statements;
		_statement_list = _tmp21_;
		_tmp22_ = _statement_list;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_statement_size = _tmp24_;
		_statement_index = -1;
		while (TRUE) {
			gint _tmp25_;
			gint _tmp26_;
			ValaCCodeNode* statement = NULL;
			ValaList* _tmp27_;
			gpointer _tmp28_;
			ValaCCodeNode* _tmp29_;
			ValaCCodeNode* _tmp30_;
			ValaCCodeNode* _tmp31_;
			_statement_index = _statement_index + 1;
			_tmp25_ = _statement_index;
			_tmp26_ = _statement_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _statement_list;
			_tmp28_ = vala_list_get (_tmp27_, _statement_index);
			statement = (ValaCCodeNode*) _tmp28_;
			_tmp29_ = statement;
			vala_ccode_node_write (_tmp29_, writer);
			_tmp30_ = statement;
			_tmp31_ = last_statement;
			if (_tmp30_ == _tmp31_) {
				_vala_ccode_node_unref0 (statement);
				break;
			}
			_vala_ccode_node_unref0 (statement);
		}
	}
	vala_ccode_writer_write_end_block (writer);
	_tmp32_ = self->priv->_suppress_newline;
	if (!_tmp32_) {
		vala_ccode_writer_write_newline (writer);
	}
	_vala_ccode_node_unref0 (last_statement);
}

ValaCCodeBlock*
vala_ccode_block_construct (GType object_type)
{
	ValaCCodeBlock* self = NULL;
	self = (ValaCCodeBlock*) vala_ccode_statement_construct (object_type);
	return self;
}

ValaCCodeBlock*
vala_ccode_block_new (void)
{
	return vala_ccode_block_construct (VALA_TYPE_CCODE_BLOCK);
}

static void
vala_ccode_block_class_init (ValaCCodeBlockClass * klass,
                             gpointer klass_data)
{
	vala_ccode_block_parent_class = g_type_class_peek_parent (klass);
	((ValaCCodeNodeClass *) klass)->finalize = vala_ccode_block_finalize;
	g_type_class_adjust_private_offset (klass, &ValaCCodeBlock_private_offset);
	((ValaCCodeNodeClass *) klass)->write = (void (*) (ValaCCodeNode*, ValaCCodeWriter*)) vala_ccode_block_real_write;
}

static void
vala_ccode_block_instance_init (ValaCCodeBlock * self,
                                gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_ccode_block_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_CCODE_NODE, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp0_);
	self->priv->statements = (ValaList*) _tmp1_;
}

static void
vala_ccode_block_finalize (ValaCCodeNode * obj)
{
	ValaCCodeBlock * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CCODE_BLOCK, ValaCCodeBlock);
	_vala_iterable_unref0 (self->priv->statements);
	VALA_CCODE_NODE_CLASS (vala_ccode_block_parent_class)->finalize (obj);
}

/**
 * Represents a C code block.
 */
static GType
vala_ccode_block_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeBlockClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_block_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeBlock), 0, (GInstanceInitFunc) vala_ccode_block_instance_init, NULL };
	GType vala_ccode_block_type_id;
	vala_ccode_block_type_id = g_type_register_static (VALA_TYPE_CCODE_STATEMENT, "ValaCCodeBlock", &g_define_type_info, 0);
	ValaCCodeBlock_private_offset = g_type_add_instance_private (vala_ccode_block_type_id, sizeof (ValaCCodeBlockPrivate));
	return vala_ccode_block_type_id;
}

GType
vala_ccode_block_get_type (void)
{
	static volatile gsize vala_ccode_block_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_block_type_id__volatile)) {
		GType vala_ccode_block_type_id;
		vala_ccode_block_type_id = vala_ccode_block_get_type_once ();
		g_once_init_leave (&vala_ccode_block_type_id__volatile, vala_ccode_block_type_id);
	}
	return vala_ccode_block_type_id__volatile;
}

