/* valaccodemethodcallmodule.c generated by valac, the Vala compiler
 * generated from valaccodemethodcallmodule.vala, do not modify */

/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "valacodegen.h"
#include <vala.h>
#include <glib.h>
#include <valaccode.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

static gpointer vala_ccode_method_call_module_parent_class = NULL;

static void vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                           ValaMethodCall* expr);
static gchar* vala_ccode_method_call_module_generate_enum_to_string_function (ValaCCodeMethodCallModule* self,
                                                                       ValaEnum* en);
static gchar* vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self);
static gboolean vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                             ValaMethodCall* c);
static GType vala_ccode_method_call_module_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                      ValaMethodCall* expr)
{
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* async_call = NULL;
	ValaCCodeFunctionCall* finish_call = NULL;
	ValaMethod* m = NULL;
	ValaDelegate* deleg = NULL;
	ValaList* params = NULL;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaMemberAccess* _tmp6_;
	ValaDataType* itype = NULL;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaList* _tmp13_;
	ValaList* _tmp14_;
	ValaDataType* _tmp15_;
	ValaHashMap* in_arg_map = NULL;
	GHashFunc _tmp166_;
	GEqualFunc _tmp167_;
	GEqualFunc _tmp168_;
	ValaHashMap* _tmp169_;
	ValaHashMap* out_arg_map = NULL;
	ValaHashMap* _tmp170_;
	ValaHashMap* _tmp171_;
	gboolean _tmp172_ = FALSE;
	ValaMethod* _tmp173_;
	gboolean _tmp420_ = FALSE;
	ValaMethod* _tmp421_;
	ValaCCodeExpression* ccall_expr = NULL;
	ValaCCodeFunctionCall* _tmp640_;
	ValaCCodeExpression* _tmp641_;
	gboolean _tmp642_ = FALSE;
	ValaMethod* _tmp643_;
	ValaCCodeExpression* instance = NULL;
	gboolean _tmp671_ = FALSE;
	ValaMethod* _tmp672_;
	gboolean _tmp835_ = FALSE;
	ValaMethod* _tmp836_;
	ValaMethod* _tmp888_;
	gboolean ellipsis = FALSE;
	gint i = 0;
	gint arg_pos = 0;
	ValaIterator* params_it = NULL;
	ValaList* _tmp1079_;
	ValaIterator* _tmp1080_;
	ValaIterator* _tmp1500_;
	gboolean _tmp1510_ = FALSE;
	gboolean _tmp1511_ = FALSE;
	ValaMethod* _tmp1512_;
	gboolean _tmp1633_ = FALSE;
	ValaDelegate* _tmp1634_;
	gboolean _tmp1730_ = FALSE;
	ValaMethod* _tmp1731_;
	gboolean _tmp1747_;
	gboolean _tmp1748_;
	gboolean _tmp1791_ = FALSE;
	ValaDelegate* _tmp1792_;
	gboolean return_result_via_out_param = FALSE;
	ValaDataType* _tmp1810_;
	ValaDataType* _tmp1811_;
	gboolean _tmp1812_ = FALSE;
	ValaDataType* _tmp1813_;
	ValaCCodeFunctionCall* _tmp1841_;
	ValaCCodeFunctionCall* _tmp1842_;
	ValaCCodeExpression* out_param_ref = NULL;
	gint last_pos = 0;
	gint min_pos = 0;
	ValaCCodeFunctionCall* _tmp1855_;
	ValaCCodeFunctionCall* _tmp1856_;
	ValaCCodeFunctionCall* _tmp1871_;
	gboolean _tmp1886_;
	gboolean _tmp1887_;
	gboolean _tmp1911_;
	gboolean _tmp1912_;
	ValaDataType* collection_type = NULL;
	gboolean _tmp1942_ = FALSE;
	ValaMemberAccess* _tmp1943_;
	gboolean _tmp1952_ = FALSE;
	gboolean _tmp1953_ = FALSE;
	gboolean _tmp1954_ = FALSE;
	ValaDataType* _tmp1955_;
	gboolean _tmp2015_ = FALSE;
	gboolean _tmp2016_ = FALSE;
	ValaMethod* _tmp2017_;
	gboolean _tmp2055_ = FALSE;
	gboolean _tmp2056_ = FALSE;
	gboolean _tmp2057_ = FALSE;
	gboolean _tmp2058_ = FALSE;
	gboolean _tmp2059_ = FALSE;
	ValaMethod* _tmp2060_;
	gboolean _tmp2077_ = FALSE;
	gboolean _tmp2078_ = FALSE;
	ValaMethod* _tmp2079_;
	ValaMethod* _tmp2098_;
	gboolean _tmp2208_ = FALSE;
	ValaCodeNode* _tmp2209_;
	ValaCodeNode* _tmp2210_;
	ValaList* _tmp2310_;
	ValaIterator* _tmp2311_;
	gboolean _tmp2464_ = FALSE;
	gboolean _tmp2465_ = FALSE;
	ValaMethod* _tmp2466_;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_get_cvalue (_tmp1_);
	_tmp3_ = vala_ccode_function_call_new (_tmp2_);
	ccall = _tmp3_;
	async_call = NULL;
	finish_call = NULL;
	m = NULL;
	deleg = NULL;
	_tmp4_ = vala_method_call_get_call (expr);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp5_) : NULL);
	ma = _tmp6_;
	_tmp7_ = vala_method_call_get_call (expr);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_expression_get_value_type (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _vala_code_node_ref0 (_tmp10_);
	itype = _tmp11_;
	_tmp12_ = itype;
	_tmp13_ = vala_data_type_get_parameters (_tmp12_);
	_tmp14_ = _vala_iterable_ref0 (_tmp13_);
	_vala_iterable_unref0 (params);
	params = _tmp14_;
	_tmp15_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, VALA_TYPE_METHOD_TYPE)) {
		ValaMemberAccess* _tmp16_;
		ValaDataType* _tmp17_;
		ValaMethod* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaMethod* _tmp21_;
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		ValaMemberAccess* _tmp29_;
		ValaExpression* _tmp30_;
		ValaExpression* _tmp31_;
		_tmp16_ = ma;
		_vala_assert (_tmp16_ != NULL, "ma != null");
		_tmp17_ = itype;
		_tmp18_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp19_ = _tmp18_;
		_tmp20_ = _vala_code_node_ref0 (_tmp19_);
		_vala_code_node_unref0 (m);
		m = _tmp20_;
		_tmp21_ = m;
		if (!vala_get_ccode_simple_generics (_tmp21_)) {
			ValaCodeContext* _tmp22_;
			ValaCodeContext* _tmp23_;
			ValaSemanticAnalyzer* _tmp24_;
			ValaSemanticAnalyzer* _tmp25_;
			ValaMemberAccess* _tmp26_;
			_tmp22_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp23_ = _tmp22_;
			_tmp24_ = vala_code_context_get_analyzer (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = ma;
			vala_semantic_analyzer_check_type_arguments (_tmp25_, _tmp26_);
		}
		_tmp29_ = ma;
		_tmp30_ = vala_member_access_get_inner (_tmp29_);
		_tmp31_ = _tmp30_;
		if (_tmp31_ != NULL) {
			ValaMemberAccess* _tmp32_;
			ValaExpression* _tmp33_;
			ValaExpression* _tmp34_;
			ValaDataType* _tmp35_;
			ValaDataType* _tmp36_;
			_tmp32_ = ma;
			_tmp33_ = vala_member_access_get_inner (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_expression_get_value_type (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp28_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp36_, VALA_TYPE_ENUM_VALUE_TYPE);
		} else {
			_tmp28_ = FALSE;
		}
		if (_tmp28_) {
			ValaMemberAccess* _tmp37_;
			ValaExpression* _tmp38_;
			ValaExpression* _tmp39_;
			ValaDataType* _tmp40_;
			ValaDataType* _tmp41_;
			ValaMethod* _tmp42_;
			ValaMethod* _tmp43_;
			_tmp37_ = ma;
			_tmp38_ = vala_member_access_get_inner (_tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_expression_get_value_type (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_enum_value_type_get_to_string_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueType));
			_tmp43_ = m;
			_tmp27_ = _tmp42_ == _tmp43_;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			ValaEnum* en = NULL;
			ValaMemberAccess* _tmp44_;
			ValaExpression* _tmp45_;
			ValaExpression* _tmp46_;
			ValaDataType* _tmp47_;
			ValaDataType* _tmp48_;
			ValaTypeSymbol* _tmp49_;
			ValaTypeSymbol* _tmp50_;
			ValaCCodeFunctionCall* _tmp51_;
			ValaEnum* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			ValaCCodeIdentifier* _tmp55_;
			ValaCCodeIdentifier* _tmp56_;
			_tmp44_ = ma;
			_tmp45_ = vala_member_access_get_inner (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_expression_get_value_type (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_data_type_get_type_symbol (_tmp48_);
			_tmp50_ = _tmp49_;
			en = G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, VALA_TYPE_ENUM, ValaEnum);
			_tmp51_ = ccall;
			_tmp52_ = en;
			_tmp53_ = vala_ccode_method_call_module_generate_enum_to_string_function (self, _tmp52_);
			_tmp54_ = _tmp53_;
			_tmp55_ = vala_ccode_identifier_new (_tmp54_);
			_tmp56_ = _tmp55_;
			vala_ccode_function_call_set_call (_tmp51_, (ValaCCodeExpression*) _tmp56_);
			_vala_ccode_node_unref0 (_tmp56_);
			_g_free0 (_tmp54_);
		} else {
			gboolean _tmp57_ = FALSE;
			gboolean _tmp58_ = FALSE;
			gboolean _tmp59_ = FALSE;
			gboolean _tmp60_ = FALSE;
			ValaCodeContext* _tmp61_;
			ValaCodeContext* _tmp62_;
			ValaProfile _tmp63_;
			ValaProfile _tmp64_;
			_tmp61_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_code_context_get_profile (_tmp62_);
			_tmp64_ = _tmp63_;
			if (_tmp64_ == VALA_PROFILE_POSIX) {
				ValaMemberAccess* _tmp65_;
				ValaExpression* _tmp66_;
				ValaExpression* _tmp67_;
				_tmp65_ = ma;
				_tmp66_ = vala_member_access_get_inner (_tmp65_);
				_tmp67_ = _tmp66_;
				_tmp60_ = _tmp67_ != NULL;
			} else {
				_tmp60_ = FALSE;
			}
			if (_tmp60_) {
				ValaMemberAccess* _tmp68_;
				ValaExpression* _tmp69_;
				ValaExpression* _tmp70_;
				ValaDataType* _tmp71_;
				ValaDataType* _tmp72_;
				_tmp68_ = ma;
				_tmp69_ = vala_member_access_get_inner (_tmp68_);
				_tmp70_ = _tmp69_;
				_tmp71_ = vala_expression_get_value_type (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp59_ = _tmp72_ != NULL;
			} else {
				_tmp59_ = FALSE;
			}
			if (_tmp59_) {
				ValaMemberAccess* _tmp73_;
				ValaExpression* _tmp74_;
				ValaExpression* _tmp75_;
				ValaDataType* _tmp76_;
				ValaDataType* _tmp77_;
				ValaTypeSymbol* _tmp78_;
				ValaTypeSymbol* _tmp79_;
				ValaDataType* _tmp80_;
				ValaTypeSymbol* _tmp81_;
				ValaTypeSymbol* _tmp82_;
				_tmp73_ = ma;
				_tmp74_ = vala_member_access_get_inner (_tmp73_);
				_tmp75_ = _tmp74_;
				_tmp76_ = vala_expression_get_value_type (_tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = vala_data_type_get_type_symbol (_tmp77_);
				_tmp79_ = _tmp78_;
				_tmp80_ = ((ValaCCodeBaseModule*) self)->string_type;
				_tmp81_ = vala_data_type_get_type_symbol (_tmp80_);
				_tmp82_ = _tmp81_;
				_tmp58_ = _tmp79_ == _tmp82_;
			} else {
				_tmp58_ = FALSE;
			}
			if (_tmp58_) {
				ValaMemberAccess* _tmp83_;
				const gchar* _tmp84_;
				const gchar* _tmp85_;
				_tmp83_ = ma;
				_tmp84_ = vala_member_access_get_member_name (_tmp83_);
				_tmp85_ = _tmp84_;
				_tmp57_ = g_strcmp0 (_tmp85_, "printf") == 0;
			} else {
				_tmp57_ = FALSE;
			}
			if (_tmp57_) {
				ValaCCodeFunctionCall* _tmp86_;
				gchar* _tmp87_;
				gchar* _tmp88_;
				ValaCCodeIdentifier* _tmp89_;
				ValaCCodeIdentifier* _tmp90_;
				_tmp86_ = ccall;
				_tmp87_ = vala_ccode_method_call_module_generate_string_printf_function (self);
				_tmp88_ = _tmp87_;
				_tmp89_ = vala_ccode_identifier_new (_tmp88_);
				_tmp90_ = _tmp89_;
				vala_ccode_function_call_set_call (_tmp86_, (ValaCCodeExpression*) _tmp90_);
				_vala_ccode_node_unref0 (_tmp90_);
				_g_free0 (_tmp88_);
			} else {
				gboolean _tmp91_;
				gboolean _tmp92_;
				_tmp91_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp92_ = _tmp91_;
				if (_tmp92_) {
					ValaCCodeFunctionCall* _tmp93_;
					ValaMethod* _tmp94_;
					gchar* _tmp95_;
					gchar* _tmp96_;
					ValaCCodeIdentifier* _tmp97_;
					ValaCCodeIdentifier* _tmp98_;
					_tmp93_ = ccall;
					_tmp94_ = m;
					_tmp95_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_tmp96_ = _tmp95_;
					_tmp97_ = vala_ccode_identifier_new (_tmp96_);
					_tmp98_ = _tmp97_;
					vala_ccode_function_call_set_call (_tmp93_, (ValaCCodeExpression*) _tmp98_);
					_vala_ccode_node_unref0 (_tmp98_);
					_g_free0 (_tmp96_);
				}
			}
		}
	} else {
		ValaDataType* _tmp99_;
		_tmp99_ = itype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp99_, VALA_TYPE_SIGNAL_TYPE)) {
			ValaSignalType* sig_type = NULL;
			ValaDataType* _tmp100_;
			ValaSignalType* _tmp101_;
			gboolean _tmp102_ = FALSE;
			gboolean _tmp103_ = FALSE;
			ValaMemberAccess* _tmp104_;
			_tmp100_ = itype;
			_tmp101_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
			sig_type = _tmp101_;
			_tmp104_ = ma;
			if (_tmp104_ != NULL) {
				ValaMemberAccess* _tmp105_;
				ValaExpression* _tmp106_;
				ValaExpression* _tmp107_;
				_tmp105_ = ma;
				_tmp106_ = vala_member_access_get_inner (_tmp105_);
				_tmp107_ = _tmp106_;
				_tmp103_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp107_, VALA_TYPE_BASE_ACCESS);
			} else {
				_tmp103_ = FALSE;
			}
			if (_tmp103_) {
				ValaSignalType* _tmp108_;
				ValaSignal* _tmp109_;
				ValaSignal* _tmp110_;
				gboolean _tmp111_;
				gboolean _tmp112_;
				_tmp108_ = sig_type;
				_tmp109_ = vala_signal_type_get_signal_symbol (_tmp108_);
				_tmp110_ = _tmp109_;
				_tmp111_ = vala_signal_get_is_virtual (_tmp110_);
				_tmp112_ = _tmp111_;
				_tmp102_ = _tmp112_;
			} else {
				_tmp102_ = FALSE;
			}
			if (_tmp102_) {
				ValaSignalType* _tmp113_;
				ValaSignal* _tmp114_;
				ValaSignal* _tmp115_;
				ValaMethod* _tmp116_;
				ValaMethod* _tmp117_;
				ValaMethod* _tmp118_;
				_tmp113_ = sig_type;
				_tmp114_ = vala_signal_type_get_signal_symbol (_tmp113_);
				_tmp115_ = _tmp114_;
				_tmp116_ = vala_signal_get_default_handler (_tmp115_);
				_tmp117_ = _tmp116_;
				_tmp118_ = _vala_code_node_ref0 (_tmp117_);
				_vala_code_node_unref0 (m);
				m = _tmp118_;
			} else {
				ValaExpression* _tmp119_;
				ValaExpression* _tmp120_;
				ValaCCodeExpression* _tmp121_;
				ValaCCodeFunctionCall* _tmp122_;
				_tmp119_ = vala_method_call_get_call (expr);
				_tmp120_ = _tmp119_;
				_tmp121_ = vala_get_cvalue (_tmp120_);
				_tmp122_ = _vala_ccode_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp121_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall));
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp122_;
			}
			_vala_code_node_unref0 (sig_type);
		} else {
			ValaDataType* _tmp123_;
			_tmp123_ = itype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp123_, VALA_TYPE_OBJECT_TYPE)) {
				ValaClass* cl = NULL;
				ValaDataType* _tmp124_;
				ValaTypeSymbol* _tmp125_;
				ValaTypeSymbol* _tmp126_;
				ValaClass* _tmp127_;
				ValaClass* _tmp128_;
				ValaCreationMethod* _tmp129_;
				ValaCreationMethod* _tmp130_;
				ValaMethod* _tmp131_;
				ValaMethod* _tmp132_;
				ValaCCodeFile* _tmp133_;
				gchar* real_name = NULL;
				ValaMethod* _tmp134_;
				gchar* _tmp135_;
				gboolean _tmp136_;
				gboolean _tmp137_;
				const gchar* _tmp140_;
				ValaCCodeIdentifier* _tmp141_;
				ValaCCodeIdentifier* _tmp142_;
				ValaCCodeFunctionCall* _tmp143_;
				_tmp124_ = itype;
				_tmp125_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp126_ = _tmp125_;
				_tmp127_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp126_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp127_;
				_tmp128_ = cl;
				_tmp129_ = vala_class_get_default_construction_method (_tmp128_);
				_tmp130_ = _tmp129_;
				_tmp131_ = _vala_code_node_ref0 ((ValaMethod*) _tmp130_);
				_vala_code_node_unref0 (m);
				m = _tmp131_;
				_tmp132_ = m;
				_tmp133_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp132_, _tmp133_);
				_tmp134_ = m;
				_tmp135_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp134_);
				real_name = _tmp135_;
				_tmp136_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp137_ = _tmp136_;
				if (_tmp137_) {
					ValaMethod* _tmp138_;
					gchar* _tmp139_;
					_tmp138_ = m;
					_tmp139_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp138_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_g_free0 (real_name);
					real_name = _tmp139_;
				}
				_tmp140_ = real_name;
				_tmp141_ = vala_ccode_identifier_new (_tmp140_);
				_tmp142_ = _tmp141_;
				_tmp143_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp142_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp143_;
				_vala_ccode_node_unref0 (_tmp142_);
				_g_free0 (real_name);
				_vala_code_node_unref0 (cl);
			} else {
				ValaDataType* _tmp144_;
				_tmp144_ = itype;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp144_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp145_;
					ValaTypeSymbol* _tmp146_;
					ValaTypeSymbol* _tmp147_;
					ValaStruct* _tmp148_;
					ValaStruct* _tmp149_;
					ValaCreationMethod* _tmp150_;
					ValaCreationMethod* _tmp151_;
					ValaMethod* _tmp152_;
					ValaMethod* _tmp153_;
					ValaCCodeFile* _tmp154_;
					ValaMethod* _tmp155_;
					gchar* _tmp156_;
					gchar* _tmp157_;
					ValaCCodeIdentifier* _tmp158_;
					ValaCCodeIdentifier* _tmp159_;
					ValaCCodeFunctionCall* _tmp160_;
					_tmp145_ = itype;
					_tmp146_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp145_, VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType));
					_tmp147_ = _tmp146_;
					_tmp148_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp147_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp148_;
					_tmp149_ = st;
					_tmp150_ = vala_struct_get_default_construction_method (_tmp149_);
					_tmp151_ = _tmp150_;
					_tmp152_ = _vala_code_node_ref0 ((ValaMethod*) _tmp151_);
					_vala_code_node_unref0 (m);
					m = _tmp152_;
					_tmp153_ = m;
					_tmp154_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp153_, _tmp154_);
					_tmp155_ = m;
					_tmp156_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp155_);
					_tmp157_ = _tmp156_;
					_tmp158_ = vala_ccode_identifier_new (_tmp157_);
					_tmp159_ = _tmp158_;
					_tmp160_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp159_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp160_;
					_vala_ccode_node_unref0 (_tmp159_);
					_g_free0 (_tmp157_);
					_vala_code_node_unref0 (st);
				} else {
					ValaDataType* _tmp161_;
					_tmp161_ = itype;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp161_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDataType* _tmp162_;
						ValaDelegate* _tmp163_;
						ValaDelegate* _tmp164_;
						ValaDelegate* _tmp165_;
						_tmp162_ = itype;
						_tmp163_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp162_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp164_ = _tmp163_;
						_tmp165_ = _vala_code_node_ref0 (_tmp164_);
						_vala_code_node_unref0 (deleg);
						deleg = _tmp165_;
					}
				}
			}
		}
	}
	_tmp166_ = g_direct_hash;
	_tmp167_ = g_direct_equal;
	_tmp168_ = g_direct_equal;
	_tmp169_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp166_, _tmp167_, _tmp168_);
	in_arg_map = _tmp169_;
	_tmp170_ = in_arg_map;
	_tmp171_ = _vala_map_ref0 (_tmp170_);
	out_arg_map = _tmp171_;
	_tmp173_ = m;
	if (_tmp173_ != NULL) {
		ValaMethod* _tmp174_;
		gboolean _tmp175_;
		gboolean _tmp176_;
		_tmp174_ = m;
		_tmp175_ = vala_method_get_coroutine (_tmp174_);
		_tmp176_ = _tmp175_;
		_tmp172_ = _tmp176_;
	} else {
		_tmp172_ = FALSE;
	}
	if (_tmp172_) {
		ValaMethod* _tmp177_;
		gchar* _tmp178_;
		gchar* _tmp179_;
		ValaCCodeIdentifier* _tmp180_;
		ValaCCodeIdentifier* _tmp181_;
		ValaCCodeFunctionCall* _tmp182_;
		ValaMethod* _tmp183_;
		gchar* _tmp184_;
		gchar* _tmp185_;
		ValaCCodeIdentifier* _tmp186_;
		ValaCCodeIdentifier* _tmp187_;
		ValaCCodeFunctionCall* _tmp188_;
		ValaMemberAccess* _tmp189_;
		ValaExpression* _tmp190_;
		ValaExpression* _tmp191_;
		gboolean _tmp367_ = FALSE;
		ValaMemberAccess* _tmp368_;
		const gchar* _tmp369_;
		const gchar* _tmp370_;
		_tmp177_ = m;
		_tmp178_ = vala_get_ccode_name ((ValaCodeNode*) _tmp177_);
		_tmp179_ = _tmp178_;
		_tmp180_ = vala_ccode_identifier_new (_tmp179_);
		_tmp181_ = _tmp180_;
		_tmp182_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp181_);
		_vala_ccode_node_unref0 (async_call);
		async_call = _tmp182_;
		_vala_ccode_node_unref0 (_tmp181_);
		_g_free0 (_tmp179_);
		_tmp183_ = m;
		_tmp184_ = vala_get_ccode_finish_name (_tmp183_);
		_tmp185_ = _tmp184_;
		_tmp186_ = vala_ccode_identifier_new (_tmp185_);
		_tmp187_ = _tmp186_;
		_tmp188_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp187_);
		_vala_ccode_node_unref0 (finish_call);
		finish_call = _tmp188_;
		_vala_ccode_node_unref0 (_tmp187_);
		_g_free0 (_tmp185_);
		_tmp189_ = ma;
		_tmp190_ = vala_member_access_get_inner (_tmp189_);
		_tmp191_ = _tmp190_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp191_, VALA_TYPE_BASE_ACCESS)) {
			ValaCCodeExpression* vcast = NULL;
			ValaMethod* _tmp192_;
			ValaMethod* _tmp193_;
			ValaMethod* _tmp194_;
			ValaCCodeExpression* _tmp225_;
			vcast = NULL;
			_tmp192_ = m;
			_tmp193_ = vala_method_get_base_method (_tmp192_);
			_tmp194_ = _tmp193_;
			if (_tmp194_ != NULL) {
				ValaClass* base_class = NULL;
				ValaMethod* _tmp195_;
				ValaMethod* _tmp196_;
				ValaMethod* _tmp197_;
				ValaSymbol* _tmp198_;
				ValaSymbol* _tmp199_;
				ValaClass* _tmp200_;
				gchar* _tmp201_;
				gchar* _tmp202_;
				ValaCCodeIdentifier* _tmp203_;
				ValaCCodeIdentifier* _tmp204_;
				ValaCCodeFunctionCall* _tmp205_;
				ValaCCodeExpression* _tmp206_;
				ValaClass* _tmp207_;
				ValaClass* _tmp208_;
				gchar* _tmp209_;
				gchar* _tmp210_;
				gchar* _tmp211_;
				gchar* _tmp212_;
				ValaCCodeIdentifier* _tmp213_;
				ValaCCodeIdentifier* _tmp214_;
				_tmp195_ = m;
				_tmp196_ = vala_method_get_base_method (_tmp195_);
				_tmp197_ = _tmp196_;
				_tmp198_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp197_);
				_tmp199_ = _tmp198_;
				base_class = G_TYPE_CHECK_INSTANCE_CAST (_tmp199_, VALA_TYPE_CLASS, ValaClass);
				_tmp200_ = base_class;
				_tmp201_ = vala_get_ccode_class_type_function (_tmp200_);
				_tmp202_ = _tmp201_;
				_tmp203_ = vala_ccode_identifier_new (_tmp202_);
				_tmp204_ = _tmp203_;
				_tmp205_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp204_);
				_vala_ccode_node_unref0 (vcast);
				vcast = (ValaCCodeExpression*) _tmp205_;
				_vala_ccode_node_unref0 (_tmp204_);
				_g_free0 (_tmp202_);
				_tmp206_ = vcast;
				_tmp207_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp208_ = _tmp207_;
				_tmp209_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp208_, NULL);
				_tmp210_ = _tmp209_;
				_tmp211_ = g_strdup_printf ("%s_parent_class", _tmp210_);
				_tmp212_ = _tmp211_;
				_tmp213_ = vala_ccode_identifier_new (_tmp212_);
				_tmp214_ = _tmp213_;
				vala_ccode_function_call_add_argument (G_TYPE_CHECK_INSTANCE_CAST (_tmp206_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall), (ValaCCodeExpression*) _tmp214_);
				_vala_ccode_node_unref0 (_tmp214_);
				_g_free0 (_tmp212_);
				_g_free0 (_tmp210_);
			} else {
				ValaMethod* _tmp215_;
				ValaMethod* _tmp216_;
				ValaMethod* _tmp217_;
				_tmp215_ = m;
				_tmp216_ = vala_method_get_base_interface_method (_tmp215_);
				_tmp217_ = _tmp216_;
				if (_tmp217_ != NULL) {
					ValaInterface* base_iface = NULL;
					ValaMethod* _tmp218_;
					ValaMethod* _tmp219_;
					ValaMethod* _tmp220_;
					ValaSymbol* _tmp221_;
					ValaSymbol* _tmp222_;
					ValaInterface* _tmp223_;
					ValaCCodeExpression* _tmp224_;
					_tmp218_ = m;
					_tmp219_ = vala_method_get_base_interface_method (_tmp218_);
					_tmp220_ = _tmp219_;
					_tmp221_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp220_);
					_tmp222_ = _tmp221_;
					base_iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp222_, VALA_TYPE_INTERFACE, ValaInterface);
					_tmp223_ = base_iface;
					_tmp224_ = vala_ccode_base_module_get_this_interface_cexpression ((ValaCCodeBaseModule*) self, _tmp223_);
					_vala_ccode_node_unref0 (vcast);
					vcast = _tmp224_;
				}
			}
			_tmp225_ = vcast;
			if (_tmp225_ != NULL) {
				ValaCCodeFunctionCall* _tmp226_;
				ValaCCodeExpression* _tmp227_;
				ValaMethod* _tmp228_;
				gchar* _tmp229_;
				gchar* _tmp230_;
				ValaCCodeMemberAccess* _tmp231_;
				ValaCCodeMemberAccess* _tmp232_;
				ValaCCodeFunctionCall* _tmp233_;
				ValaCCodeExpression* _tmp234_;
				ValaMethod* _tmp235_;
				gchar* _tmp236_;
				gchar* _tmp237_;
				ValaCCodeMemberAccess* _tmp238_;
				ValaCCodeMemberAccess* _tmp239_;
				_tmp226_ = async_call;
				_tmp227_ = vcast;
				_tmp228_ = m;
				_tmp229_ = vala_get_ccode_vfunc_name (_tmp228_);
				_tmp230_ = _tmp229_;
				_tmp231_ = vala_ccode_member_access_new_pointer (_tmp227_, _tmp230_);
				_tmp232_ = _tmp231_;
				vala_ccode_function_call_set_call (_tmp226_, (ValaCCodeExpression*) _tmp232_);
				_vala_ccode_node_unref0 (_tmp232_);
				_g_free0 (_tmp230_);
				_tmp233_ = finish_call;
				_tmp234_ = vcast;
				_tmp235_ = m;
				_tmp236_ = vala_get_ccode_finish_vfunc_name (_tmp235_);
				_tmp237_ = _tmp236_;
				_tmp238_ = vala_ccode_member_access_new_pointer (_tmp234_, _tmp237_);
				_tmp239_ = _tmp238_;
				vala_ccode_function_call_set_call (_tmp233_, (ValaCCodeExpression*) _tmp239_);
				_vala_ccode_node_unref0 (_tmp239_);
				_g_free0 (_tmp237_);
			}
			_vala_ccode_node_unref0 (vcast);
		} else {
			gboolean _tmp240_ = FALSE;
			gboolean _tmp241_ = FALSE;
			gboolean _tmp242_ = FALSE;
			ValaMethod* _tmp243_;
			_tmp243_ = m;
			if (_tmp243_ != NULL) {
				ValaMethod* _tmp244_;
				_tmp244_ = m;
				_tmp242_ = vala_get_ccode_no_wrapper (_tmp244_);
			} else {
				_tmp242_ = FALSE;
			}
			if (_tmp242_) {
				ValaMethod* _tmp245_;
				ValaMemberBinding _tmp246_;
				ValaMemberBinding _tmp247_;
				_tmp245_ = m;
				_tmp246_ = vala_method_get_binding (_tmp245_);
				_tmp247_ = _tmp246_;
				_tmp241_ = _tmp247_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp241_ = FALSE;
			}
			if (_tmp241_) {
				ValaMethod* _tmp248_;
				_tmp248_ = m;
				_tmp240_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp248_, VALA_TYPE_CREATION_METHOD);
			} else {
				_tmp240_ = FALSE;
			}
			if (_tmp240_) {
				ValaTargetValue* instance_value = NULL;
				ValaMemberAccess* _tmp249_;
				ValaExpression* _tmp250_;
				ValaExpression* _tmp251_;
				ValaTargetValue* _tmp252_;
				ValaTargetValue* _tmp253_;
				ValaTargetValue* _tmp254_;
				gboolean _tmp255_ = FALSE;
				gboolean _tmp256_ = FALSE;
				ValaMemberAccess* _tmp257_;
				const gchar* _tmp258_;
				const gchar* _tmp259_;
				ValaCCodeExpression* pub_inst = NULL;
				ValaTargetValue* _tmp281_;
				ValaCCodeExpression* _tmp282_;
				ValaCCodeExpression* _tmp283_;
				ValaCCodeFunctionCall* vcast = NULL;
				ValaMethod* _tmp284_;
				ValaSymbol* _tmp285_;
				ValaSymbol* _tmp286_;
				ValaCCodeFunctionCall* _tmp352_;
				_tmp249_ = ma;
				_tmp250_ = vala_member_access_get_inner (_tmp249_);
				_tmp251_ = _tmp250_;
				_tmp252_ = vala_expression_get_target_value (_tmp251_);
				_tmp253_ = _tmp252_;
				_tmp254_ = _vala_target_value_ref0 (_tmp253_);
				instance_value = _tmp254_;
				_tmp257_ = ma;
				_tmp258_ = vala_member_access_get_member_name (_tmp257_);
				_tmp259_ = _tmp258_;
				if (g_strcmp0 (_tmp259_, "begin") == 0) {
					_tmp256_ = TRUE;
				} else {
					ValaMemberAccess* _tmp260_;
					const gchar* _tmp261_;
					const gchar* _tmp262_;
					_tmp260_ = ma;
					_tmp261_ = vala_member_access_get_member_name (_tmp260_);
					_tmp262_ = _tmp261_;
					_tmp256_ = g_strcmp0 (_tmp262_, "end") == 0;
				}
				if (_tmp256_) {
					ValaMemberAccess* _tmp263_;
					ValaExpression* _tmp264_;
					ValaExpression* _tmp265_;
					ValaSymbol* _tmp266_;
					ValaSymbol* _tmp267_;
					ValaMemberAccess* _tmp268_;
					ValaSymbol* _tmp269_;
					ValaSymbol* _tmp270_;
					_tmp263_ = ma;
					_tmp264_ = vala_member_access_get_inner (_tmp263_);
					_tmp265_ = _tmp264_;
					_tmp266_ = vala_expression_get_symbol_reference (_tmp265_);
					_tmp267_ = _tmp266_;
					_tmp268_ = ma;
					_tmp269_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp268_);
					_tmp270_ = _tmp269_;
					_tmp255_ = _tmp267_ == _tmp270_;
				} else {
					_tmp255_ = FALSE;
				}
				if (_tmp255_) {
					ValaMemberAccess* inner_ma = NULL;
					ValaMemberAccess* _tmp271_;
					ValaExpression* _tmp272_;
					ValaExpression* _tmp273_;
					ValaMemberAccess* _tmp274_;
					ValaMemberAccess* _tmp275_;
					ValaExpression* _tmp276_;
					ValaExpression* _tmp277_;
					ValaTargetValue* _tmp278_;
					ValaTargetValue* _tmp279_;
					ValaTargetValue* _tmp280_;
					_tmp271_ = ma;
					_tmp272_ = vala_member_access_get_inner (_tmp271_);
					_tmp273_ = _tmp272_;
					_tmp274_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp273_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
					inner_ma = _tmp274_;
					_tmp275_ = inner_ma;
					_tmp276_ = vala_member_access_get_inner (_tmp275_);
					_tmp277_ = _tmp276_;
					_tmp278_ = vala_expression_get_target_value (_tmp277_);
					_tmp279_ = _tmp278_;
					_tmp280_ = _vala_target_value_ref0 (_tmp279_);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp280_;
					_vala_code_node_unref0 (inner_ma);
				}
				_tmp281_ = instance_value;
				_tmp282_ = vala_get_cvalue_ (_tmp281_);
				_tmp283_ = _vala_ccode_node_ref0 (_tmp282_);
				pub_inst = _tmp283_;
				vcast = NULL;
				_tmp284_ = m;
				_tmp285_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp284_);
				_tmp286_ = _tmp285_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp286_, VALA_TYPE_CLASS)) {
					ValaClass* base_class = NULL;
					ValaMethod* _tmp287_;
					ValaSymbol* _tmp288_;
					ValaSymbol* _tmp289_;
					ValaClass* _tmp290_;
					gboolean _tmp291_;
					gboolean _tmp292_;
					_tmp287_ = m;
					_tmp288_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp287_);
					_tmp289_ = _tmp288_;
					base_class = G_TYPE_CHECK_INSTANCE_CAST (_tmp289_, VALA_TYPE_CLASS, ValaClass);
					_tmp290_ = base_class;
					_tmp291_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp290_);
					_tmp292_ = _tmp291_;
					if (_tmp292_) {
						ValaCCodeIdentifier* _tmp293_;
						ValaCCodeIdentifier* _tmp294_;
						ValaCCodeFunctionCall* _tmp295_;
						ValaCCodeFunctionCall* _tmp296_;
						ValaCCodeExpression* _tmp297_;
						ValaCCodeFunctionCall* _tmp298_;
						ValaClass* _tmp299_;
						gchar* _tmp300_;
						gchar* _tmp301_;
						ValaCCodeIdentifier* _tmp302_;
						ValaCCodeIdentifier* _tmp303_;
						ValaCCodeFunctionCall* _tmp304_;
						ValaClass* _tmp305_;
						gchar* _tmp306_;
						gchar* _tmp307_;
						ValaCCodeIdentifier* _tmp308_;
						ValaCCodeIdentifier* _tmp309_;
						_tmp293_ = vala_ccode_identifier_new ("G_TYPE_INSTANCE_GET_CLASS");
						_tmp294_ = _tmp293_;
						_tmp295_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp294_);
						_vala_ccode_node_unref0 (vcast);
						vcast = _tmp295_;
						_vala_ccode_node_unref0 (_tmp294_);
						_tmp296_ = vcast;
						_tmp297_ = pub_inst;
						vala_ccode_function_call_add_argument (_tmp296_, _tmp297_);
						_tmp298_ = vcast;
						_tmp299_ = base_class;
						_tmp300_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp299_);
						_tmp301_ = _tmp300_;
						_tmp302_ = vala_ccode_identifier_new (_tmp301_);
						_tmp303_ = _tmp302_;
						vala_ccode_function_call_add_argument (_tmp298_, (ValaCCodeExpression*) _tmp303_);
						_vala_ccode_node_unref0 (_tmp303_);
						_g_free0 (_tmp301_);
						_tmp304_ = vcast;
						_tmp305_ = base_class;
						_tmp306_ = vala_get_ccode_type_name ((ValaObjectTypeSymbol*) _tmp305_);
						_tmp307_ = _tmp306_;
						_tmp308_ = vala_ccode_identifier_new (_tmp307_);
						_tmp309_ = _tmp308_;
						vala_ccode_function_call_add_argument (_tmp304_, (ValaCCodeExpression*) _tmp309_);
						_vala_ccode_node_unref0 (_tmp309_);
						_g_free0 (_tmp307_);
					} else {
						ValaClass* _tmp310_;
						gchar* _tmp311_;
						gchar* _tmp312_;
						ValaCCodeIdentifier* _tmp313_;
						ValaCCodeIdentifier* _tmp314_;
						ValaCCodeFunctionCall* _tmp315_;
						ValaCCodeFunctionCall* _tmp316_;
						ValaCCodeExpression* _tmp317_;
						_tmp310_ = base_class;
						_tmp311_ = vala_get_ccode_type_get_function ((ValaObjectTypeSymbol*) _tmp310_);
						_tmp312_ = _tmp311_;
						_tmp313_ = vala_ccode_identifier_new (_tmp312_);
						_tmp314_ = _tmp313_;
						_tmp315_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp314_);
						_vala_ccode_node_unref0 (vcast);
						vcast = _tmp315_;
						_vala_ccode_node_unref0 (_tmp314_);
						_g_free0 (_tmp312_);
						_tmp316_ = vcast;
						_tmp317_ = pub_inst;
						vala_ccode_function_call_add_argument (_tmp316_, _tmp317_);
					}
				} else {
					ValaMethod* _tmp318_;
					ValaSymbol* _tmp319_;
					ValaSymbol* _tmp320_;
					_tmp318_ = m;
					_tmp319_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp318_);
					_tmp320_ = _tmp319_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp320_, VALA_TYPE_INTERFACE)) {
						ValaInterface* base_iface = NULL;
						ValaMethod* _tmp321_;
						ValaSymbol* _tmp322_;
						ValaSymbol* _tmp323_;
						ValaInterface* _tmp324_;
						gboolean _tmp325_;
						gboolean _tmp326_;
						_tmp321_ = m;
						_tmp322_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp321_);
						_tmp323_ = _tmp322_;
						base_iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp323_, VALA_TYPE_INTERFACE, ValaInterface);
						_tmp324_ = base_iface;
						_tmp325_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp324_);
						_tmp326_ = _tmp325_;
						if (_tmp326_) {
							ValaCCodeIdentifier* _tmp327_;
							ValaCCodeIdentifier* _tmp328_;
							ValaCCodeFunctionCall* _tmp329_;
							ValaCCodeFunctionCall* _tmp330_;
							ValaCCodeExpression* _tmp331_;
							ValaCCodeFunctionCall* _tmp332_;
							ValaInterface* _tmp333_;
							gchar* _tmp334_;
							gchar* _tmp335_;
							ValaCCodeIdentifier* _tmp336_;
							ValaCCodeIdentifier* _tmp337_;
							ValaCCodeFunctionCall* _tmp338_;
							ValaInterface* _tmp339_;
							gchar* _tmp340_;
							gchar* _tmp341_;
							ValaCCodeIdentifier* _tmp342_;
							ValaCCodeIdentifier* _tmp343_;
							_tmp327_ = vala_ccode_identifier_new ("G_TYPE_INSTANCE_GET_INTERFACE");
							_tmp328_ = _tmp327_;
							_tmp329_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp328_);
							_vala_ccode_node_unref0 (vcast);
							vcast = _tmp329_;
							_vala_ccode_node_unref0 (_tmp328_);
							_tmp330_ = vcast;
							_tmp331_ = pub_inst;
							vala_ccode_function_call_add_argument (_tmp330_, _tmp331_);
							_tmp332_ = vcast;
							_tmp333_ = base_iface;
							_tmp334_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp333_);
							_tmp335_ = _tmp334_;
							_tmp336_ = vala_ccode_identifier_new (_tmp335_);
							_tmp337_ = _tmp336_;
							vala_ccode_function_call_add_argument (_tmp332_, (ValaCCodeExpression*) _tmp337_);
							_vala_ccode_node_unref0 (_tmp337_);
							_g_free0 (_tmp335_);
							_tmp338_ = vcast;
							_tmp339_ = base_iface;
							_tmp340_ = vala_get_ccode_type_name ((ValaObjectTypeSymbol*) _tmp339_);
							_tmp341_ = _tmp340_;
							_tmp342_ = vala_ccode_identifier_new (_tmp341_);
							_tmp343_ = _tmp342_;
							vala_ccode_function_call_add_argument (_tmp338_, (ValaCCodeExpression*) _tmp343_);
							_vala_ccode_node_unref0 (_tmp343_);
							_g_free0 (_tmp341_);
						} else {
							ValaInterface* _tmp344_;
							gchar* _tmp345_;
							gchar* _tmp346_;
							ValaCCodeIdentifier* _tmp347_;
							ValaCCodeIdentifier* _tmp348_;
							ValaCCodeFunctionCall* _tmp349_;
							ValaCCodeFunctionCall* _tmp350_;
							ValaCCodeExpression* _tmp351_;
							_tmp344_ = base_iface;
							_tmp345_ = vala_get_ccode_type_get_function ((ValaObjectTypeSymbol*) _tmp344_);
							_tmp346_ = _tmp345_;
							_tmp347_ = vala_ccode_identifier_new (_tmp346_);
							_tmp348_ = _tmp347_;
							_tmp349_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp348_);
							_vala_ccode_node_unref0 (vcast);
							vcast = _tmp349_;
							_vala_ccode_node_unref0 (_tmp348_);
							_g_free0 (_tmp346_);
							_tmp350_ = vcast;
							_tmp351_ = pub_inst;
							vala_ccode_function_call_add_argument (_tmp350_, _tmp351_);
						}
					}
				}
				_tmp352_ = vcast;
				if (_tmp352_ != NULL) {
					ValaCCodeFunctionCall* _tmp353_;
					ValaCCodeFunctionCall* _tmp354_;
					ValaMethod* _tmp355_;
					gchar* _tmp356_;
					gchar* _tmp357_;
					ValaCCodeMemberAccess* _tmp358_;
					ValaCCodeMemberAccess* _tmp359_;
					ValaCCodeFunctionCall* _tmp360_;
					ValaCCodeFunctionCall* _tmp361_;
					ValaMethod* _tmp362_;
					gchar* _tmp363_;
					gchar* _tmp364_;
					ValaCCodeMemberAccess* _tmp365_;
					ValaCCodeMemberAccess* _tmp366_;
					_tmp353_ = async_call;
					_tmp354_ = vcast;
					_tmp355_ = m;
					_tmp356_ = vala_get_ccode_vfunc_name (_tmp355_);
					_tmp357_ = _tmp356_;
					_tmp358_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp354_, _tmp357_);
					_tmp359_ = _tmp358_;
					vala_ccode_function_call_set_call (_tmp353_, (ValaCCodeExpression*) _tmp359_);
					_vala_ccode_node_unref0 (_tmp359_);
					_g_free0 (_tmp357_);
					_tmp360_ = finish_call;
					_tmp361_ = vcast;
					_tmp362_ = m;
					_tmp363_ = vala_get_ccode_finish_vfunc_name (_tmp362_);
					_tmp364_ = _tmp363_;
					_tmp365_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp361_, _tmp364_);
					_tmp366_ = _tmp365_;
					vala_ccode_function_call_set_call (_tmp360_, (ValaCCodeExpression*) _tmp366_);
					_vala_ccode_node_unref0 (_tmp366_);
					_g_free0 (_tmp364_);
				}
				_vala_ccode_node_unref0 (vcast);
				_vala_ccode_node_unref0 (pub_inst);
				_vala_target_value_unref0 (instance_value);
			}
		}
		_tmp368_ = ma;
		_tmp369_ = vala_member_access_get_member_name (_tmp368_);
		_tmp370_ = _tmp369_;
		if (g_strcmp0 (_tmp370_, "begin") == 0) {
			ValaMemberAccess* _tmp371_;
			ValaExpression* _tmp372_;
			ValaExpression* _tmp373_;
			ValaSymbol* _tmp374_;
			ValaSymbol* _tmp375_;
			ValaMemberAccess* _tmp376_;
			ValaSymbol* _tmp377_;
			ValaSymbol* _tmp378_;
			_tmp371_ = ma;
			_tmp372_ = vala_member_access_get_inner (_tmp371_);
			_tmp373_ = _tmp372_;
			_tmp374_ = vala_expression_get_symbol_reference (_tmp373_);
			_tmp375_ = _tmp374_;
			_tmp376_ = ma;
			_tmp377_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp376_);
			_tmp378_ = _tmp377_;
			_tmp367_ = _tmp375_ == _tmp378_;
		} else {
			_tmp367_ = FALSE;
		}
		if (_tmp367_) {
			ValaCCodeFunctionCall* _tmp379_;
			ValaCCodeFunctionCall* _tmp380_;
			ValaMethod* _tmp381_;
			ValaList* _tmp382_;
			ValaList* _tmp383_;
			_tmp379_ = async_call;
			_tmp380_ = _vala_ccode_node_ref0 (_tmp379_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp380_;
			_tmp381_ = m;
			_tmp382_ = vala_method_get_async_begin_parameters (_tmp381_);
			_tmp383_ = _vala_iterable_ref0 (_tmp382_);
			_vala_iterable_unref0 (params);
			params = _tmp383_;
		} else {
			gboolean _tmp384_ = FALSE;
			ValaMemberAccess* _tmp385_;
			const gchar* _tmp386_;
			const gchar* _tmp387_;
			_tmp385_ = ma;
			_tmp386_ = vala_member_access_get_member_name (_tmp385_);
			_tmp387_ = _tmp386_;
			if (g_strcmp0 (_tmp387_, "end") == 0) {
				ValaMemberAccess* _tmp388_;
				ValaExpression* _tmp389_;
				ValaExpression* _tmp390_;
				ValaSymbol* _tmp391_;
				ValaSymbol* _tmp392_;
				ValaMemberAccess* _tmp393_;
				ValaSymbol* _tmp394_;
				ValaSymbol* _tmp395_;
				_tmp388_ = ma;
				_tmp389_ = vala_member_access_get_inner (_tmp388_);
				_tmp390_ = _tmp389_;
				_tmp391_ = vala_expression_get_symbol_reference (_tmp390_);
				_tmp392_ = _tmp391_;
				_tmp393_ = ma;
				_tmp394_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp393_);
				_tmp395_ = _tmp394_;
				_tmp384_ = _tmp392_ == _tmp395_;
			} else {
				_tmp384_ = FALSE;
			}
			if (_tmp384_) {
				ValaCCodeFunctionCall* _tmp396_;
				ValaCCodeFunctionCall* _tmp397_;
				ValaMethod* _tmp398_;
				ValaList* _tmp399_;
				ValaList* _tmp400_;
				_tmp396_ = finish_call;
				_tmp397_ = _vala_ccode_node_ref0 (_tmp396_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp397_;
				_tmp398_ = m;
				_tmp399_ = vala_method_get_async_end_parameters (_tmp398_);
				_tmp400_ = _vala_iterable_ref0 (_tmp399_);
				_vala_iterable_unref0 (params);
				params = _tmp400_;
			} else {
				gboolean _tmp401_;
				gboolean _tmp402_;
				_tmp401_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) expr);
				_tmp402_ = _tmp401_;
				if (!_tmp402_) {
					ValaCCodeFunctionCall* _tmp403_;
					ValaCCodeFunctionCall* _tmp404_;
					ValaMethod* _tmp405_;
					ValaList* _tmp406_;
					ValaList* _tmp407_;
					_tmp403_ = async_call;
					_tmp404_ = _vala_ccode_node_ref0 (_tmp403_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp404_;
					_tmp405_ = m;
					_tmp406_ = vala_method_get_async_begin_parameters (_tmp405_);
					_tmp407_ = _vala_iterable_ref0 (_tmp406_);
					_vala_iterable_unref0 (params);
					params = _tmp407_;
				} else {
					ValaCCodeFunctionCall* _tmp408_;
					ValaCCodeFunctionCall* _tmp409_;
					GHashFunc _tmp410_;
					GEqualFunc _tmp411_;
					GEqualFunc _tmp412_;
					ValaHashMap* _tmp413_;
					ValaHashMap* _tmp414_;
					ValaMethod* _tmp415_;
					ValaCCodeIdentifier* _tmp416_;
					ValaCCodeIdentifier* _tmp417_;
					ValaCCodeMemberAccess* _tmp418_;
					ValaCCodeMemberAccess* _tmp419_;
					_tmp408_ = finish_call;
					_tmp409_ = _vala_ccode_node_ref0 (_tmp408_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp409_;
					_tmp410_ = g_direct_hash;
					_tmp411_ = g_direct_equal;
					_tmp412_ = g_direct_equal;
					_tmp413_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp410_, _tmp411_, _tmp412_);
					_vala_map_unref0 (out_arg_map);
					out_arg_map = _tmp413_;
					_tmp414_ = out_arg_map;
					_tmp415_ = m;
					_tmp416_ = vala_ccode_identifier_new ("_data_");
					_tmp417_ = _tmp416_;
					_tmp418_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp417_, "_res_");
					_tmp419_ = _tmp418_;
					vala_map_set ((ValaMap*) _tmp414_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_async_result_pos (_tmp415_), FALSE)), (ValaCCodeExpression*) _tmp419_);
					_vala_ccode_node_unref0 (_tmp419_);
					_vala_ccode_node_unref0 (_tmp417_);
				}
			}
		}
	}
	_tmp421_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp421_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp422_;
		ValaSymbol* _tmp423_;
		ValaSymbol* _tmp424_;
		_tmp422_ = m;
		_tmp423_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp422_);
		_tmp424_ = _tmp423_;
		_tmp420_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp424_, VALA_TYPE_CLASS);
	} else {
		_tmp420_ = FALSE;
	}
	if (_tmp420_) {
		ValaCodeContext* _tmp425_;
		ValaCodeContext* _tmp426_;
		ValaProfile _tmp427_;
		ValaProfile _tmp428_;
		ValaClass* _tmp440_;
		ValaClass* _tmp441_;
		gboolean _tmp442_;
		gboolean _tmp443_;
		_tmp425_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp426_ = _tmp425_;
		_tmp427_ = vala_code_context_get_profile (_tmp426_);
		_tmp428_ = _tmp427_;
		if (_tmp428_ == VALA_PROFILE_GOBJECT) {
			ValaMethod* _tmp429_;
			ValaSymbol* _tmp430_;
			ValaSymbol* _tmp431_;
			gboolean _tmp432_;
			gboolean _tmp433_;
			_tmp429_ = m;
			_tmp430_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp429_);
			_tmp431_ = _tmp430_;
			_tmp432_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp431_, VALA_TYPE_CLASS, ValaClass));
			_tmp433_ = _tmp432_;
			if (!_tmp433_) {
				ValaCCodeFunctionCall* _tmp434_;
				ValaCCodeExpression* _tmp435_;
				ValaCCodeExpression* _tmp436_;
				_tmp434_ = ccall;
				_tmp435_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "object_type");
				_tmp436_ = _tmp435_;
				vala_ccode_function_call_add_argument (_tmp434_, _tmp436_);
				_vala_ccode_node_unref0 (_tmp436_);
			}
		} else {
			ValaCCodeFunctionCall* _tmp437_;
			ValaCCodeExpression* _tmp438_;
			ValaCCodeExpression* _tmp439_;
			_tmp437_ = ccall;
			_tmp438_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp439_ = _tmp438_;
			vala_ccode_function_call_add_argument (_tmp437_, _tmp439_);
			_vala_ccode_node_unref0 (_tmp439_);
		}
		_tmp440_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp441_ = _tmp440_;
		_tmp442_ = vala_class_get_is_compact (_tmp441_);
		_tmp443_ = _tmp442_;
		if (!_tmp443_) {
			ValaClass* _tmp444_;
			ValaClass* _tmp445_;
			ValaMethod* _tmp446_;
			ValaSymbol* _tmp447_;
			ValaSymbol* _tmp448_;
			_tmp444_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp445_ = _tmp444_;
			_tmp446_ = m;
			_tmp447_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp446_);
			_tmp448_ = _tmp447_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp445_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp448_) {
				{
					ValaList* _base_type_list = NULL;
					ValaClass* _tmp449_;
					ValaClass* _tmp450_;
					ValaList* _tmp451_;
					gint _base_type_size = 0;
					ValaList* _tmp452_;
					gint _tmp453_;
					gint _tmp454_;
					gint _base_type_index = 0;
					_tmp449_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp450_ = _tmp449_;
					_tmp451_ = vala_class_get_base_types (_tmp450_);
					_base_type_list = _tmp451_;
					_tmp452_ = _base_type_list;
					_tmp453_ = vala_collection_get_size ((ValaCollection*) _tmp452_);
					_tmp454_ = _tmp453_;
					_base_type_size = _tmp454_;
					_base_type_index = -1;
					while (TRUE) {
						gint _tmp455_;
						gint _tmp456_;
						ValaDataType* base_type = NULL;
						ValaList* _tmp457_;
						gpointer _tmp458_;
						ValaDataType* _tmp459_;
						ValaTypeSymbol* _tmp460_;
						ValaTypeSymbol* _tmp461_;
						_base_type_index = _base_type_index + 1;
						_tmp455_ = _base_type_index;
						_tmp456_ = _base_type_size;
						if (!(_tmp455_ < _tmp456_)) {
							break;
						}
						_tmp457_ = _base_type_list;
						_tmp458_ = vala_list_get (_tmp457_, _base_type_index);
						base_type = (ValaDataType*) _tmp458_;
						_tmp459_ = base_type;
						_tmp460_ = vala_data_type_get_type_symbol (_tmp459_);
						_tmp461_ = _tmp460_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp461_, VALA_TYPE_CLASS)) {
							ValaList* type_parameters = NULL;
							ValaMethod* _tmp462_;
							gchar* _tmp463_;
							gchar* _tmp464_;
							gboolean _tmp465_;
							ValaMethod* _tmp471_;
							ValaHashMap* _tmp472_;
							ValaDataType* _tmp473_;
							ValaList* _tmp474_;
							ValaList* _tmp475_;
							type_parameters = NULL;
							_tmp462_ = m;
							_tmp463_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp462_);
							_tmp464_ = _tmp463_;
							_tmp465_ = g_strcmp0 (_tmp464_, "g_object_new") == 0;
							_g_free0 (_tmp464_);
							if (_tmp465_) {
								ValaDataType* _tmp466_;
								ValaTypeSymbol* _tmp467_;
								ValaTypeSymbol* _tmp468_;
								ValaList* _tmp469_;
								ValaList* _tmp470_;
								_tmp466_ = base_type;
								_tmp467_ = vala_data_type_get_type_symbol (_tmp466_);
								_tmp468_ = _tmp467_;
								_tmp469_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp468_, VALA_TYPE_CLASS, ValaClass));
								_tmp470_ = _vala_iterable_ref0 (_tmp469_);
								_vala_iterable_unref0 (type_parameters);
								type_parameters = _tmp470_;
							}
							_tmp471_ = m;
							_tmp472_ = in_arg_map;
							_tmp473_ = base_type;
							_tmp474_ = vala_data_type_get_type_arguments (_tmp473_);
							_tmp475_ = type_parameters;
							vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, _tmp471_, (ValaMap*) _tmp472_, _tmp474_, (ValaCodeNode*) expr, TRUE, _tmp475_);
							_vala_iterable_unref0 (type_parameters);
							_vala_code_node_unref0 (base_type);
							break;
						}
						_vala_code_node_unref0 (base_type);
					}
				}
			} else {
				gint type_param_index = 0;
				ValaClass* cl = NULL;
				ValaMethod* _tmp476_;
				ValaSymbol* _tmp477_;
				ValaSymbol* _tmp478_;
				ValaClass* _tmp479_;
				type_param_index = 0;
				_tmp476_ = m;
				_tmp477_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp476_);
				_tmp478_ = _tmp477_;
				_tmp479_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp478_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp479_;
				{
					ValaList* _type_param_list = NULL;
					ValaClass* _tmp480_;
					ValaList* _tmp481_;
					gint _type_param_size = 0;
					ValaList* _tmp482_;
					gint _tmp483_;
					gint _tmp484_;
					gint _type_param_index = 0;
					_tmp480_ = cl;
					_tmp481_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp480_);
					_type_param_list = _tmp481_;
					_tmp482_ = _type_param_list;
					_tmp483_ = vala_collection_get_size ((ValaCollection*) _tmp482_);
					_tmp484_ = _tmp483_;
					_type_param_size = _tmp484_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp485_;
						gint _tmp486_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp487_;
						gpointer _tmp488_;
						ValaHashMap* _tmp489_;
						ValaTypeParameter* _tmp490_;
						const gchar* _tmp491_;
						const gchar* _tmp492_;
						gchar* _tmp493_;
						gchar* _tmp494_;
						gchar* _tmp495_;
						gchar* _tmp496_;
						ValaCCodeIdentifier* _tmp497_;
						ValaCCodeIdentifier* _tmp498_;
						ValaHashMap* _tmp499_;
						ValaTypeParameter* _tmp500_;
						const gchar* _tmp501_;
						const gchar* _tmp502_;
						gchar* _tmp503_;
						gchar* _tmp504_;
						gchar* _tmp505_;
						gchar* _tmp506_;
						ValaCCodeIdentifier* _tmp507_;
						ValaCCodeIdentifier* _tmp508_;
						ValaHashMap* _tmp509_;
						ValaTypeParameter* _tmp510_;
						const gchar* _tmp511_;
						const gchar* _tmp512_;
						gchar* _tmp513_;
						gchar* _tmp514_;
						gchar* _tmp515_;
						gchar* _tmp516_;
						ValaCCodeIdentifier* _tmp517_;
						ValaCCodeIdentifier* _tmp518_;
						gint _tmp519_;
						_type_param_index = _type_param_index + 1;
						_tmp485_ = _type_param_index;
						_tmp486_ = _type_param_size;
						if (!(_tmp485_ < _tmp486_)) {
							break;
						}
						_tmp487_ = _type_param_list;
						_tmp488_ = vala_list_get (_tmp487_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp488_;
						_tmp489_ = in_arg_map;
						_tmp490_ = type_param;
						_tmp491_ = vala_symbol_get_name ((ValaSymbol*) _tmp490_);
						_tmp492_ = _tmp491_;
						_tmp493_ = g_ascii_strdown (_tmp492_, (gssize) -1);
						_tmp494_ = _tmp493_;
						_tmp495_ = g_strdup_printf ("%s_type", _tmp494_);
						_tmp496_ = _tmp495_;
						_tmp497_ = vala_ccode_identifier_new (_tmp496_);
						_tmp498_ = _tmp497_;
						vala_map_set ((ValaMap*) _tmp489_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp498_);
						_vala_ccode_node_unref0 (_tmp498_);
						_g_free0 (_tmp496_);
						_g_free0 (_tmp494_);
						_tmp499_ = in_arg_map;
						_tmp500_ = type_param;
						_tmp501_ = vala_symbol_get_name ((ValaSymbol*) _tmp500_);
						_tmp502_ = _tmp501_;
						_tmp503_ = g_ascii_strdown (_tmp502_, (gssize) -1);
						_tmp504_ = _tmp503_;
						_tmp505_ = g_strdup_printf ("%s_dup_func", _tmp504_);
						_tmp506_ = _tmp505_;
						_tmp507_ = vala_ccode_identifier_new (_tmp506_);
						_tmp508_ = _tmp507_;
						vala_map_set ((ValaMap*) _tmp499_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.02, FALSE)), (ValaCCodeExpression*) _tmp508_);
						_vala_ccode_node_unref0 (_tmp508_);
						_g_free0 (_tmp506_);
						_g_free0 (_tmp504_);
						_tmp509_ = in_arg_map;
						_tmp510_ = type_param;
						_tmp511_ = vala_symbol_get_name ((ValaSymbol*) _tmp510_);
						_tmp512_ = _tmp511_;
						_tmp513_ = g_ascii_strdown (_tmp512_, (gssize) -1);
						_tmp514_ = _tmp513_;
						_tmp515_ = g_strdup_printf ("%s_destroy_func", _tmp514_);
						_tmp516_ = _tmp515_;
						_tmp517_ = vala_ccode_identifier_new (_tmp516_);
						_tmp518_ = _tmp517_;
						vala_map_set ((ValaMap*) _tmp509_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.03, FALSE)), (ValaCCodeExpression*) _tmp518_);
						_vala_ccode_node_unref0 (_tmp518_);
						_g_free0 (_tmp516_);
						_g_free0 (_tmp514_);
						_tmp519_ = type_param_index;
						type_param_index = _tmp519_ + 1;
						_vala_code_node_unref0 (type_param);
					}
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			ValaClass* _tmp520_;
			ValaClass* _tmp521_;
			ValaClass* _tmp522_;
			_tmp520_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp521_ = _tmp520_;
			_tmp522_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp521_, (ValaTypeSymbol*) _tmp522_)) {
				gchar* class_prefix = NULL;
				ValaClass* _tmp523_;
				ValaClass* _tmp524_;
				gchar* _tmp525_;
				gchar* prepare_func = NULL;
				gchar* _tmp526_;
				gchar* check_func = NULL;
				gchar* _tmp527_;
				ValaCCodeDeclaration* funcs = NULL;
				ValaCCodeDeclaration* _tmp551_;
				ValaCCodeDeclaration* _tmp552_;
				ValaCCodeDeclaration* _tmp553_;
				const gchar* _tmp554_;
				const gchar* _tmp555_;
				const gchar* _tmp556_;
				const gchar* _tmp557_;
				gchar* _tmp558_;
				gchar* _tmp559_;
				ValaCCodeConstant* _tmp560_;
				ValaCCodeConstant* _tmp561_;
				ValaCCodeVariableDeclarator* _tmp562_;
				ValaCCodeVariableDeclarator* _tmp563_;
				ValaCCodeFunction* _tmp564_;
				ValaCCodeFunction* _tmp565_;
				ValaCCodeDeclaration* _tmp566_;
				ValaCCodeFunctionCall* _tmp567_;
				ValaCCodeIdentifier* _tmp568_;
				ValaCCodeIdentifier* _tmp569_;
				ValaCCodeUnaryExpression* _tmp570_;
				ValaCCodeUnaryExpression* _tmp571_;
				ValaCCodeCastExpression* _tmp572_;
				ValaCCodeCastExpression* _tmp573_;
				ValaCCodeFunctionCall* csizeof = NULL;
				ValaCCodeIdentifier* _tmp574_;
				ValaCCodeIdentifier* _tmp575_;
				ValaCCodeFunctionCall* _tmp576_;
				ValaCCodeFunctionCall* _tmp577_;
				ValaCCodeFunctionCall* _tmp578_;
				ValaClass* _tmp579_;
				ValaClass* _tmp580_;
				gchar* _tmp581_;
				gchar* _tmp582_;
				ValaCCodeIdentifier* _tmp583_;
				ValaCCodeIdentifier* _tmp584_;
				ValaCCodeFunctionCall* _tmp585_;
				ValaCCodeFunctionCall* _tmp586_;
				_tmp523_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp524_ = _tmp523_;
				_tmp525_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp524_, NULL);
				class_prefix = _tmp525_;
				_tmp526_ = g_strdup ("NULL");
				prepare_func = _tmp526_;
				_tmp527_ = g_strdup ("NULL");
				check_func = _tmp527_;
				{
					ValaList* _impl_list = NULL;
					ValaClass* _tmp528_;
					ValaClass* _tmp529_;
					ValaList* _tmp530_;
					gint _impl_size = 0;
					ValaList* _tmp531_;
					gint _tmp532_;
					gint _tmp533_;
					gint _impl_index = 0;
					_tmp528_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp529_ = _tmp528_;
					_tmp530_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp529_);
					_impl_list = _tmp530_;
					_tmp531_ = _impl_list;
					_tmp532_ = vala_collection_get_size ((ValaCollection*) _tmp531_);
					_tmp533_ = _tmp532_;
					_impl_size = _tmp533_;
					_impl_index = -1;
					while (TRUE) {
						gint _tmp534_;
						gint _tmp535_;
						ValaMethod* impl = NULL;
						ValaList* _tmp536_;
						gpointer _tmp537_;
						ValaMethod* _tmp538_;
						gboolean _tmp539_;
						gboolean _tmp540_;
						ValaMethod* _tmp541_;
						const gchar* _tmp542_;
						const gchar* _tmp543_;
						const gchar* _tmp544_;
						GQuark _tmp546_ = 0U;
						static GQuark _tmp545_label0 = 0;
						static GQuark _tmp545_label1 = 0;
						_impl_index = _impl_index + 1;
						_tmp534_ = _impl_index;
						_tmp535_ = _impl_size;
						if (!(_tmp534_ < _tmp535_)) {
							break;
						}
						_tmp536_ = _impl_list;
						_tmp537_ = vala_list_get (_tmp536_, _impl_index);
						impl = (ValaMethod*) _tmp537_;
						_tmp538_ = impl;
						_tmp539_ = vala_method_get_overrides (_tmp538_);
						_tmp540_ = _tmp539_;
						if (!_tmp540_) {
							_vala_code_node_unref0 (impl);
							continue;
						}
						_tmp541_ = impl;
						_tmp542_ = vala_symbol_get_name ((ValaSymbol*) _tmp541_);
						_tmp543_ = _tmp542_;
						_tmp544_ = _tmp543_;
						_tmp546_ = (NULL == _tmp544_) ? 0 : g_quark_from_string (_tmp544_);
						if (_tmp546_ == ((0 != _tmp545_label0) ? _tmp545_label0 : (_tmp545_label0 = g_quark_from_static_string ("prepare")))) {
							switch (0) {
								default:
								{
									const gchar* _tmp547_;
									gchar* _tmp548_;
									_tmp547_ = class_prefix;
									_tmp548_ = g_strdup_printf ("%s_real_prepare", _tmp547_);
									_g_free0 (prepare_func);
									prepare_func = _tmp548_;
									break;
								}
							}
						} else if (_tmp546_ == ((0 != _tmp545_label1) ? _tmp545_label1 : (_tmp545_label1 = g_quark_from_static_string ("check")))) {
							switch (0) {
								default:
								{
									const gchar* _tmp549_;
									gchar* _tmp550_;
									_tmp549_ = class_prefix;
									_tmp550_ = g_strdup_printf ("%s_real_check", _tmp549_);
									_g_free0 (check_func);
									check_func = _tmp550_;
									break;
								}
							}
						} else {
							switch (0) {
								default:
								{
									break;
								}
							}
						}
						_vala_code_node_unref0 (impl);
					}
				}
				_tmp551_ = vala_ccode_declaration_new ("const GSourceFuncs");
				funcs = _tmp551_;
				_tmp552_ = funcs;
				vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp552_, VALA_CCODE_MODIFIERS_STATIC);
				_tmp553_ = funcs;
				_tmp554_ = prepare_func;
				_tmp555_ = check_func;
				_tmp556_ = class_prefix;
				_tmp557_ = class_prefix;
				_tmp558_ = g_strdup_printf ("{ %s, %s, %s_real_dispatch, %s_finalize}", _tmp554_, _tmp555_, _tmp556_, _tmp557_);
				_tmp559_ = _tmp558_;
				_tmp560_ = vala_ccode_constant_new (_tmp559_);
				_tmp561_ = _tmp560_;
				_tmp562_ = vala_ccode_variable_declarator_new ("_source_funcs", (ValaCCodeExpression*) _tmp561_, NULL);
				_tmp563_ = _tmp562_;
				vala_ccode_declaration_add_declarator (_tmp553_, (ValaCCodeDeclarator*) _tmp563_);
				_vala_ccode_node_unref0 (_tmp563_);
				_vala_ccode_node_unref0 (_tmp561_);
				_g_free0 (_tmp559_);
				_tmp564_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp565_ = _tmp564_;
				_tmp566_ = funcs;
				vala_ccode_function_add_statement (_tmp565_, (ValaCCodeNode*) _tmp566_);
				_tmp567_ = ccall;
				_tmp568_ = vala_ccode_identifier_new ("_source_funcs");
				_tmp569_ = _tmp568_;
				_tmp570_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp569_);
				_tmp571_ = _tmp570_;
				_tmp572_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp571_, "GSourceFuncs *");
				_tmp573_ = _tmp572_;
				vala_ccode_function_call_add_argument (_tmp567_, (ValaCCodeExpression*) _tmp573_);
				_vala_ccode_node_unref0 (_tmp573_);
				_vala_ccode_node_unref0 (_tmp571_);
				_vala_ccode_node_unref0 (_tmp569_);
				_tmp574_ = vala_ccode_identifier_new ("sizeof");
				_tmp575_ = _tmp574_;
				_tmp576_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp575_);
				_tmp577_ = _tmp576_;
				_vala_ccode_node_unref0 (_tmp575_);
				csizeof = _tmp577_;
				_tmp578_ = csizeof;
				_tmp579_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp580_ = _tmp579_;
				_tmp581_ = vala_get_ccode_name ((ValaCodeNode*) _tmp580_);
				_tmp582_ = _tmp581_;
				_tmp583_ = vala_ccode_identifier_new (_tmp582_);
				_tmp584_ = _tmp583_;
				vala_ccode_function_call_add_argument (_tmp578_, (ValaCCodeExpression*) _tmp584_);
				_vala_ccode_node_unref0 (_tmp584_);
				_g_free0 (_tmp582_);
				_tmp585_ = ccall;
				_tmp586_ = csizeof;
				vala_ccode_function_call_add_argument (_tmp585_, (ValaCCodeExpression*) _tmp586_);
				_vala_ccode_node_unref0 (csizeof);
				_vala_ccode_node_unref0 (funcs);
				_g_free0 (check_func);
				_g_free0 (prepare_func);
				_g_free0 (class_prefix);
			} else {
				gboolean _tmp587_ = FALSE;
				ValaClass* _tmp588_;
				ValaClass* _tmp589_;
				ValaClass* _tmp590_;
				ValaClass* _tmp591_;
				_tmp588_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp589_ = _tmp588_;
				_tmp590_ = vala_class_get_base_class (_tmp589_);
				_tmp591_ = _tmp590_;
				if (_tmp591_ != NULL) {
					ValaMethod* _tmp592_;
					_tmp592_ = m;
					_tmp587_ = vala_get_ccode_simple_generics (_tmp592_);
				} else {
					_tmp587_ = FALSE;
				}
				if (_tmp587_) {
					ValaClass* _tmp593_;
					ValaClass* _tmp594_;
					ValaMethod* _tmp595_;
					ValaSymbol* _tmp596_;
					ValaSymbol* _tmp597_;
					_tmp593_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp594_ = _tmp593_;
					_tmp595_ = m;
					_tmp596_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp595_);
					_tmp597_ = _tmp596_;
					if (G_TYPE_CHECK_INSTANCE_CAST (_tmp594_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp597_) {
						{
							ValaList* _base_type_list = NULL;
							ValaClass* _tmp598_;
							ValaClass* _tmp599_;
							ValaList* _tmp600_;
							gint _base_type_size = 0;
							ValaList* _tmp601_;
							gint _tmp602_;
							gint _tmp603_;
							gint _base_type_index = 0;
							_tmp598_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
							_tmp599_ = _tmp598_;
							_tmp600_ = vala_class_get_base_types (_tmp599_);
							_base_type_list = _tmp600_;
							_tmp601_ = _base_type_list;
							_tmp602_ = vala_collection_get_size ((ValaCollection*) _tmp601_);
							_tmp603_ = _tmp602_;
							_base_type_size = _tmp603_;
							_base_type_index = -1;
							while (TRUE) {
								gint _tmp604_;
								gint _tmp605_;
								ValaDataType* base_type = NULL;
								ValaList* _tmp606_;
								gpointer _tmp607_;
								ValaDataType* _tmp608_;
								ValaTypeSymbol* _tmp609_;
								ValaTypeSymbol* _tmp610_;
								_base_type_index = _base_type_index + 1;
								_tmp604_ = _base_type_index;
								_tmp605_ = _base_type_size;
								if (!(_tmp604_ < _tmp605_)) {
									break;
								}
								_tmp606_ = _base_type_list;
								_tmp607_ = vala_list_get (_tmp606_, _base_type_index);
								base_type = (ValaDataType*) _tmp607_;
								_tmp608_ = base_type;
								_tmp609_ = vala_data_type_get_type_symbol (_tmp608_);
								_tmp610_ = _tmp609_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp610_, VALA_TYPE_CLASS)) {
									ValaMethod* _tmp611_;
									ValaHashMap* _tmp612_;
									ValaDataType* _tmp613_;
									ValaList* _tmp614_;
									_tmp611_ = m;
									_tmp612_ = in_arg_map;
									_tmp613_ = base_type;
									_tmp614_ = vala_data_type_get_type_arguments (_tmp613_);
									vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, _tmp611_, (ValaMap*) _tmp612_, _tmp614_, (ValaCodeNode*) expr, FALSE, NULL);
									_vala_code_node_unref0 (base_type);
									break;
								}
								_vala_code_node_unref0 (base_type);
							}
						}
					} else {
					}
				}
			}
		}
	} else {
		gboolean _tmp615_ = FALSE;
		ValaMethod* _tmp616_;
		_tmp616_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp616_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp617_;
			ValaSymbol* _tmp618_;
			ValaSymbol* _tmp619_;
			_tmp617_ = m;
			_tmp618_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp617_);
			_tmp619_ = _tmp618_;
			_tmp615_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp619_, VALA_TYPE_STRUCT);
		} else {
			_tmp615_ = FALSE;
		}
		if (_tmp615_) {
			ValaCCodeFunctionCall* _tmp620_;
			ValaCCodeExpression* _tmp621_;
			ValaCCodeExpression* _tmp622_;
			_tmp620_ = ccall;
			_tmp621_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp622_ = _tmp621_;
			vala_ccode_function_call_add_argument (_tmp620_, _tmp622_);
			_vala_ccode_node_unref0 (_tmp622_);
		} else {
			gboolean _tmp623_ = FALSE;
			gboolean _tmp624_ = FALSE;
			gboolean _tmp625_ = FALSE;
			gboolean _tmp626_ = FALSE;
			ValaMethod* _tmp627_;
			_tmp627_ = m;
			if (_tmp627_ != NULL) {
				ValaMethod* _tmp628_;
				_tmp628_ = m;
				_tmp626_ = vala_method_has_type_parameters (_tmp628_);
			} else {
				_tmp626_ = FALSE;
			}
			if (_tmp626_) {
				ValaMethod* _tmp629_;
				_tmp629_ = m;
				_tmp625_ = !vala_get_ccode_has_generic_type_parameter (_tmp629_);
			} else {
				_tmp625_ = FALSE;
			}
			if (_tmp625_) {
				ValaMethod* _tmp630_;
				_tmp630_ = m;
				_tmp624_ = !vala_get_ccode_simple_generics (_tmp630_);
			} else {
				_tmp624_ = FALSE;
			}
			if (_tmp624_) {
				gboolean _tmp631_ = FALSE;
				ValaCCodeFunctionCall* _tmp632_;
				ValaCCodeFunctionCall* _tmp633_;
				_tmp632_ = ccall;
				_tmp633_ = finish_call;
				if (_tmp632_ != _tmp633_) {
					_tmp631_ = TRUE;
				} else {
					gboolean _tmp634_;
					gboolean _tmp635_;
					_tmp634_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) expr);
					_tmp635_ = _tmp634_;
					_tmp631_ = _tmp635_;
				}
				_tmp623_ = _tmp631_;
			} else {
				_tmp623_ = FALSE;
			}
			if (_tmp623_) {
				ValaMethod* _tmp636_;
				ValaHashMap* _tmp637_;
				ValaMemberAccess* _tmp638_;
				ValaList* _tmp639_;
				_tmp636_ = m;
				_tmp637_ = in_arg_map;
				_tmp638_ = ma;
				_tmp639_ = vala_member_access_get_type_arguments (_tmp638_);
				vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, _tmp636_, (ValaMap*) _tmp637_, _tmp639_, (ValaCodeNode*) expr, FALSE, NULL);
			}
		}
	}
	_tmp640_ = ccall;
	_tmp641_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp640_);
	ccall_expr = _tmp641_;
	_tmp643_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp643_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaCodeContext* _tmp644_;
		ValaCodeContext* _tmp645_;
		ValaProfile _tmp646_;
		ValaProfile _tmp647_;
		_tmp644_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp645_ = _tmp644_;
		_tmp646_ = vala_code_context_get_profile (_tmp645_);
		_tmp647_ = _tmp646_;
		_tmp642_ = _tmp647_ != VALA_PROFILE_POSIX;
	} else {
		_tmp642_ = FALSE;
	}
	if (_tmp642_) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp648_;
		ValaExpression* _tmp649_;
		ValaExpression* _tmp650_;
		ValaDataType* _tmp651_;
		ValaDataType* _tmp652_;
		ValaArrayType* _tmp653_;
		ValaHashMap* _tmp654_;
		ValaArrayType* _tmp655_;
		ValaDataType* _tmp656_;
		ValaDataType* _tmp657_;
		gchar* _tmp658_;
		gchar* _tmp659_;
		ValaCCodeIdentifier* _tmp660_;
		ValaCCodeIdentifier* _tmp661_;
		_tmp648_ = ma;
		_tmp649_ = vala_member_access_get_inner (_tmp648_);
		_tmp650_ = _tmp649_;
		_tmp651_ = vala_expression_get_value_type (_tmp650_);
		_tmp652_ = _tmp651_;
		_tmp653_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp652_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp653_;
		_tmp654_ = in_arg_map;
		_tmp655_ = array_type;
		_tmp656_ = vala_array_type_get_element_type (_tmp655_);
		_tmp657_ = _tmp656_;
		_tmp658_ = vala_get_ccode_name ((ValaCodeNode*) _tmp657_);
		_tmp659_ = _tmp658_;
		_tmp660_ = vala_ccode_identifier_new (_tmp659_);
		_tmp661_ = _tmp660_;
		vala_map_set ((ValaMap*) _tmp654_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) 0, FALSE)), (ValaCCodeExpression*) _tmp661_);
		_vala_ccode_node_unref0 (_tmp661_);
		_g_free0 (_tmp659_);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp662_;
		_tmp662_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp662_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		} else {
			ValaMethod* _tmp663_;
			_tmp663_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp663_, VALA_TYPE_ARRAY_COPY_METHOD)) {
				ValaMemberAccess* _tmp664_;
				ValaExpression* _tmp665_;
				ValaExpression* _tmp666_;
				ValaTargetValue* _tmp667_;
				ValaTargetValue* _tmp668_;
				ValaTargetValue* _tmp669_;
				ValaTargetValue* _tmp670_;
				_tmp664_ = ma;
				_tmp665_ = vala_member_access_get_inner (_tmp664_);
				_tmp666_ = _tmp665_;
				_tmp667_ = vala_expression_get_target_value (_tmp666_);
				_tmp668_ = _tmp667_;
				_tmp669_ = vala_ccode_base_module_copy_value ((ValaCCodeBaseModule*) self, _tmp668_, (ValaCodeNode*) expr);
				_tmp670_ = _tmp669_;
				vala_expression_set_target_value ((ValaExpression*) expr, _tmp670_);
				_vala_target_value_unref0 (_tmp670_);
				_vala_ccode_node_unref0 (ccall_expr);
				_vala_map_unref0 (out_arg_map);
				_vala_map_unref0 (in_arg_map);
				_vala_code_node_unref0 (itype);
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (deleg);
				_vala_code_node_unref0 (m);
				_vala_ccode_node_unref0 (finish_call);
				_vala_ccode_node_unref0 (async_call);
				_vala_ccode_node_unref0 (ccall);
				return;
			}
		}
	}
	instance = NULL;
	_tmp672_ = m;
	if (_tmp672_ != NULL) {
		ValaMethod* _tmp673_;
		gboolean _tmp674_;
		gboolean _tmp675_;
		_tmp673_ = m;
		_tmp674_ = vala_method_get_is_async_callback (_tmp673_);
		_tmp675_ = _tmp674_;
		_tmp671_ = _tmp675_;
	} else {
		_tmp671_ = FALSE;
	}
	if (_tmp671_) {
		ValaMethod* _tmp676_;
		ValaMethod* _tmp677_;
		gboolean _tmp678_;
		gboolean _tmp679_;
		ValaHashMap* _tmp693_;
		ValaMethod* _tmp694_;
		ValaCCodeExpression* _tmp695_;
		ValaHashMap* _tmp696_;
		ValaMethod* _tmp697_;
		ValaCCodeExpression* _tmp698_;
		_tmp676_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp677_ = _tmp676_;
		_tmp678_ = vala_method_get_closure (_tmp677_);
		_tmp679_ = _tmp678_;
		if (_tmp679_) {
			ValaBlock* block = NULL;
			ValaMethod* _tmp680_;
			ValaSymbol* _tmp681_;
			ValaSymbol* _tmp682_;
			ValaBlock* _tmp683_;
			ValaBlock* _tmp684_;
			ValaBlock* _tmp685_;
			ValaBlock* _tmp686_;
			gchar* _tmp687_;
			gchar* _tmp688_;
			ValaCCodeExpression* _tmp689_;
			ValaCCodeExpression* _tmp690_;
			ValaCCodeMemberAccess* _tmp691_;
			_tmp680_ = m;
			_tmp681_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp680_);
			_tmp682_ = _tmp681_;
			_tmp683_ = vala_subroutine_get_body ((ValaSubroutine*) G_TYPE_CHECK_INSTANCE_CAST (_tmp682_, VALA_TYPE_METHOD, ValaMethod));
			_tmp684_ = _tmp683_;
			_tmp685_ = _vala_code_node_ref0 (_tmp684_);
			block = _tmp685_;
			_tmp686_ = block;
			_tmp687_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp686_));
			_tmp688_ = _tmp687_;
			_tmp689_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp688_);
			_tmp690_ = _tmp689_;
			_tmp691_ = vala_ccode_member_access_new_pointer (_tmp690_, "_async_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp691_;
			_vala_ccode_node_unref0 (_tmp690_);
			_g_free0 (_tmp688_);
			_vala_code_node_unref0 (block);
		} else {
			ValaCCodeIdentifier* _tmp692_;
			_tmp692_ = vala_ccode_identifier_new ("_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp692_;
		}
		_tmp693_ = in_arg_map;
		_tmp694_ = m;
		_tmp695_ = instance;
		vala_map_set ((ValaMap*) _tmp693_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp694_), FALSE)), _tmp695_);
		_tmp696_ = out_arg_map;
		_tmp697_ = m;
		_tmp698_ = instance;
		vala_map_set ((ValaMap*) _tmp696_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp697_), FALSE)), _tmp698_);
	} else {
		gboolean _tmp699_ = FALSE;
		gboolean _tmp700_ = FALSE;
		ValaMethod* _tmp701_;
		_tmp701_ = m;
		if (_tmp701_ != NULL) {
			ValaMethod* _tmp702_;
			ValaMemberBinding _tmp703_;
			ValaMemberBinding _tmp704_;
			_tmp702_ = m;
			_tmp703_ = vala_method_get_binding (_tmp702_);
			_tmp704_ = _tmp703_;
			_tmp700_ = _tmp704_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp700_ = FALSE;
		}
		if (_tmp700_) {
			ValaMethod* _tmp705_;
			_tmp705_ = m;
			_tmp699_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp705_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp699_ = FALSE;
		}
		if (_tmp699_) {
			ValaTargetValue* instance_value = NULL;
			ValaMemberAccess* _tmp706_;
			ValaExpression* _tmp707_;
			ValaExpression* _tmp708_;
			ValaTargetValue* _tmp709_;
			ValaTargetValue* _tmp710_;
			ValaTargetValue* _tmp711_;
			gboolean _tmp712_ = FALSE;
			gboolean _tmp713_ = FALSE;
			ValaMemberAccess* _tmp714_;
			const gchar* _tmp715_;
			const gchar* _tmp716_;
			ValaTargetValue* _tmp738_;
			ValaCCodeExpression* _tmp739_;
			ValaCCodeExpression* _tmp740_;
			ValaStruct* st = NULL;
			ValaMethod* _tmp741_;
			ValaSymbol* _tmp742_;
			ValaSymbol* _tmp743_;
			ValaStruct* _tmp744_;
			gboolean _tmp745_ = FALSE;
			ValaStruct* _tmp746_;
			ValaMethod* _tmp754_;
			gboolean _tmp755_;
			gboolean _tmp756_;
			_tmp706_ = ma;
			_tmp707_ = vala_member_access_get_inner (_tmp706_);
			_tmp708_ = _tmp707_;
			_tmp709_ = vala_expression_get_target_value (_tmp708_);
			_tmp710_ = _tmp709_;
			_tmp711_ = _vala_target_value_ref0 (_tmp710_);
			instance_value = _tmp711_;
			_tmp714_ = ma;
			_tmp715_ = vala_member_access_get_member_name (_tmp714_);
			_tmp716_ = _tmp715_;
			if (g_strcmp0 (_tmp716_, "begin") == 0) {
				_tmp713_ = TRUE;
			} else {
				ValaMemberAccess* _tmp717_;
				const gchar* _tmp718_;
				const gchar* _tmp719_;
				_tmp717_ = ma;
				_tmp718_ = vala_member_access_get_member_name (_tmp717_);
				_tmp719_ = _tmp718_;
				_tmp713_ = g_strcmp0 (_tmp719_, "end") == 0;
			}
			if (_tmp713_) {
				ValaMemberAccess* _tmp720_;
				ValaExpression* _tmp721_;
				ValaExpression* _tmp722_;
				ValaSymbol* _tmp723_;
				ValaSymbol* _tmp724_;
				ValaMemberAccess* _tmp725_;
				ValaSymbol* _tmp726_;
				ValaSymbol* _tmp727_;
				_tmp720_ = ma;
				_tmp721_ = vala_member_access_get_inner (_tmp720_);
				_tmp722_ = _tmp721_;
				_tmp723_ = vala_expression_get_symbol_reference (_tmp722_);
				_tmp724_ = _tmp723_;
				_tmp725_ = ma;
				_tmp726_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp725_);
				_tmp727_ = _tmp726_;
				_tmp712_ = _tmp724_ == _tmp727_;
			} else {
				_tmp712_ = FALSE;
			}
			if (_tmp712_) {
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp728_;
				ValaExpression* _tmp729_;
				ValaExpression* _tmp730_;
				ValaMemberAccess* _tmp731_;
				ValaMemberAccess* _tmp732_;
				ValaExpression* _tmp733_;
				ValaExpression* _tmp734_;
				ValaTargetValue* _tmp735_;
				ValaTargetValue* _tmp736_;
				ValaTargetValue* _tmp737_;
				_tmp728_ = ma;
				_tmp729_ = vala_member_access_get_inner (_tmp728_);
				_tmp730_ = _tmp729_;
				_tmp731_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp730_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				inner_ma = _tmp731_;
				_tmp732_ = inner_ma;
				_tmp733_ = vala_member_access_get_inner (_tmp732_);
				_tmp734_ = _tmp733_;
				_tmp735_ = vala_expression_get_target_value (_tmp734_);
				_tmp736_ = _tmp735_;
				_tmp737_ = _vala_target_value_ref0 (_tmp736_);
				_vala_target_value_unref0 (instance_value);
				instance_value = _tmp737_;
				_vala_code_node_unref0 (inner_ma);
			}
			_tmp738_ = instance_value;
			_tmp739_ = vala_get_cvalue_ (_tmp738_);
			_tmp740_ = _vala_ccode_node_ref0 (_tmp739_);
			_vala_ccode_node_unref0 (instance);
			instance = _tmp740_;
			_tmp741_ = m;
			_tmp742_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp741_);
			_tmp743_ = _tmp742_;
			_tmp744_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp743_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp743_) : NULL);
			st = _tmp744_;
			_tmp746_ = st;
			if (_tmp746_ != NULL) {
				ValaStruct* _tmp747_;
				_tmp747_ = st;
				_tmp745_ = !vala_struct_is_simple_type (_tmp747_);
			} else {
				_tmp745_ = FALSE;
			}
			if (_tmp745_) {
				ValaTargetValue* _tmp748_;
				ValaTargetValue* _tmp751_;
				ValaCCodeExpression* _tmp752_;
				ValaCCodeUnaryExpression* _tmp753_;
				_tmp748_ = instance_value;
				if (!vala_get_lvalue (_tmp748_)) {
					ValaTargetValue* _tmp749_;
					ValaTargetValue* _tmp750_;
					_tmp749_ = instance_value;
					_tmp750_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, _tmp749_, (ValaCodeNode*) expr, NULL);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp750_;
				}
				_tmp751_ = instance_value;
				_tmp752_ = vala_get_cvalue_ (_tmp751_);
				_tmp753_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp752_);
				_vala_ccode_node_unref0 (instance);
				instance = (ValaCCodeExpression*) _tmp753_;
			}
			_tmp754_ = m;
			_tmp755_ = vala_method_get_coroutine (_tmp754_);
			_tmp756_ = _tmp755_;
			if (!_tmp756_) {
				ValaHashMap* _tmp757_;
				ValaMethod* _tmp758_;
				ValaCCodeExpression* _tmp759_;
				_tmp757_ = in_arg_map;
				_tmp758_ = m;
				_tmp759_ = instance;
				vala_map_set ((ValaMap*) _tmp757_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp758_), FALSE)), _tmp759_);
			} else {
				gboolean _tmp760_;
				gboolean _tmp761_;
				_tmp760_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) expr);
				_tmp761_ = _tmp760_;
				if (_tmp761_) {
					ValaHashMap* _tmp762_;
					ValaMethod* _tmp763_;
					ValaCCodeExpression* _tmp764_;
					ValaMethod* _tmp765_;
					_tmp762_ = in_arg_map;
					_tmp763_ = m;
					_tmp764_ = instance;
					vala_map_set ((ValaMap*) _tmp762_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp763_), FALSE)), _tmp764_);
					_tmp765_ = m;
					if (vala_get_ccode_finish_instance (_tmp765_)) {
						ValaHashMap* _tmp766_;
						ValaMethod* _tmp767_;
						ValaCCodeExpression* _tmp768_;
						_tmp766_ = out_arg_map;
						_tmp767_ = m;
						_tmp768_ = instance;
						vala_map_set ((ValaMap*) _tmp766_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp767_), FALSE)), _tmp768_);
					}
				} else {
					gboolean _tmp769_ = FALSE;
					ValaMemberAccess* _tmp770_;
					const gchar* _tmp771_;
					const gchar* _tmp772_;
					_tmp770_ = ma;
					_tmp771_ = vala_member_access_get_member_name (_tmp770_);
					_tmp772_ = _tmp771_;
					if (g_strcmp0 (_tmp772_, "end") != 0) {
						_tmp769_ = TRUE;
					} else {
						ValaMethod* _tmp773_;
						_tmp773_ = m;
						_tmp769_ = vala_get_ccode_finish_instance (_tmp773_);
					}
					if (_tmp769_) {
						ValaHashMap* _tmp774_;
						ValaMethod* _tmp775_;
						ValaCCodeExpression* _tmp776_;
						ValaHashMap* _tmp777_;
						ValaMethod* _tmp778_;
						ValaCCodeExpression* _tmp779_;
						_tmp774_ = out_arg_map;
						_tmp775_ = m;
						_tmp776_ = instance;
						vala_map_set ((ValaMap*) _tmp774_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp775_), FALSE)), _tmp776_);
						_tmp777_ = in_arg_map;
						_tmp778_ = m;
						_tmp779_ = instance;
						vala_map_set ((ValaMap*) _tmp777_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp778_), FALSE)), _tmp779_);
					}
				}
			}
			_vala_code_node_unref0 (st);
			_vala_target_value_unref0 (instance_value);
		} else {
			gboolean _tmp780_ = FALSE;
			ValaMethod* _tmp781_;
			_tmp781_ = m;
			if (_tmp781_ != NULL) {
				ValaMethod* _tmp782_;
				ValaMemberBinding _tmp783_;
				ValaMemberBinding _tmp784_;
				_tmp782_ = m;
				_tmp783_ = vala_method_get_binding (_tmp782_);
				_tmp784_ = _tmp783_;
				_tmp780_ = _tmp784_ == VALA_MEMBER_BINDING_CLASS;
			} else {
				_tmp780_ = FALSE;
			}
			if (_tmp780_) {
				ValaClass* cl = NULL;
				ValaMethod* _tmp785_;
				ValaSymbol* _tmp786_;
				ValaSymbol* _tmp787_;
				ValaClass* _tmp788_;
				ValaCCodeFunctionCall* cast = NULL;
				ValaClass* _tmp789_;
				gchar* _tmp790_;
				gchar* _tmp791_;
				ValaCCodeIdentifier* _tmp792_;
				ValaCCodeIdentifier* _tmp793_;
				ValaCCodeFunctionCall* _tmp794_;
				ValaCCodeFunctionCall* _tmp795_;
				ValaCCodeExpression* klass = NULL;
				ValaMemberAccess* _tmp796_;
				ValaExpression* _tmp797_;
				ValaExpression* _tmp798_;
				ValaCCodeFunctionCall* _tmp827_;
				ValaCCodeExpression* _tmp828_;
				ValaHashMap* _tmp829_;
				ValaMethod* _tmp830_;
				ValaCCodeFunctionCall* _tmp831_;
				ValaHashMap* _tmp832_;
				ValaMethod* _tmp833_;
				ValaCCodeFunctionCall* _tmp834_;
				_tmp785_ = m;
				_tmp786_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp785_);
				_tmp787_ = _tmp786_;
				_tmp788_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp787_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp788_;
				_tmp789_ = cl;
				_tmp790_ = vala_get_ccode_class_type_function (_tmp789_);
				_tmp791_ = _tmp790_;
				_tmp792_ = vala_ccode_identifier_new (_tmp791_);
				_tmp793_ = _tmp792_;
				_tmp794_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp793_);
				_tmp795_ = _tmp794_;
				_vala_ccode_node_unref0 (_tmp793_);
				_g_free0 (_tmp791_);
				cast = _tmp795_;
				_tmp796_ = ma;
				_tmp797_ = vala_member_access_get_inner (_tmp796_);
				_tmp798_ = _tmp797_;
				if (_tmp798_ == NULL) {
					ValaDataType* _tmp799_;
					_tmp799_ = vala_ccode_base_module_get_this_type ((ValaCCodeBaseModule*) self);
					if (_tmp799_ == NULL) {
						ValaCCodeIdentifier* _tmp800_;
						_tmp800_ = vala_ccode_identifier_new ("klass");
						_vala_ccode_node_unref0 (klass);
						klass = (ValaCCodeExpression*) _tmp800_;
					} else {
						ValaCCodeFunctionCall* k = NULL;
						ValaClass* _tmp801_;
						gchar* _tmp802_;
						gchar* _tmp803_;
						ValaCCodeIdentifier* _tmp804_;
						ValaCCodeIdentifier* _tmp805_;
						ValaCCodeFunctionCall* _tmp806_;
						ValaCCodeFunctionCall* _tmp807_;
						ValaCCodeFunctionCall* _tmp808_;
						ValaCCodeExpression* _tmp809_;
						ValaCCodeExpression* _tmp810_;
						ValaCCodeFunctionCall* _tmp811_;
						ValaCCodeExpression* _tmp812_;
						_tmp801_ = cl;
						_tmp802_ = vala_get_ccode_type_get_function ((ValaObjectTypeSymbol*) _tmp801_);
						_tmp803_ = _tmp802_;
						_tmp804_ = vala_ccode_identifier_new (_tmp803_);
						_tmp805_ = _tmp804_;
						_tmp806_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp805_);
						_tmp807_ = _tmp806_;
						_vala_ccode_node_unref0 (_tmp805_);
						_g_free0 (_tmp803_);
						k = _tmp807_;
						_tmp808_ = k;
						_tmp809_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
						_tmp810_ = _tmp809_;
						vala_ccode_function_call_add_argument (_tmp808_, _tmp810_);
						_vala_ccode_node_unref0 (_tmp810_);
						_tmp811_ = k;
						_tmp812_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp811_);
						_vala_ccode_node_unref0 (klass);
						klass = _tmp812_;
						_vala_ccode_node_unref0 (k);
					}
				} else {
					ValaCCodeFunctionCall* k = NULL;
					ValaClass* _tmp813_;
					gchar* _tmp814_;
					gchar* _tmp815_;
					ValaCCodeIdentifier* _tmp816_;
					ValaCCodeIdentifier* _tmp817_;
					ValaCCodeFunctionCall* _tmp818_;
					ValaCCodeFunctionCall* _tmp819_;
					ValaCCodeFunctionCall* _tmp820_;
					ValaMemberAccess* _tmp821_;
					ValaExpression* _tmp822_;
					ValaExpression* _tmp823_;
					ValaCCodeExpression* _tmp824_;
					ValaCCodeFunctionCall* _tmp825_;
					ValaCCodeExpression* _tmp826_;
					_tmp813_ = cl;
					_tmp814_ = vala_get_ccode_type_get_function ((ValaObjectTypeSymbol*) _tmp813_);
					_tmp815_ = _tmp814_;
					_tmp816_ = vala_ccode_identifier_new (_tmp815_);
					_tmp817_ = _tmp816_;
					_tmp818_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp817_);
					_tmp819_ = _tmp818_;
					_vala_ccode_node_unref0 (_tmp817_);
					_g_free0 (_tmp815_);
					k = _tmp819_;
					_tmp820_ = k;
					_tmp821_ = ma;
					_tmp822_ = vala_member_access_get_inner (_tmp821_);
					_tmp823_ = _tmp822_;
					_tmp824_ = vala_get_cvalue (_tmp823_);
					vala_ccode_function_call_add_argument (_tmp820_, _tmp824_);
					_tmp825_ = k;
					_tmp826_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp825_);
					_vala_ccode_node_unref0 (klass);
					klass = _tmp826_;
					_vala_ccode_node_unref0 (k);
				}
				_tmp827_ = cast;
				_tmp828_ = klass;
				vala_ccode_function_call_add_argument (_tmp827_, _tmp828_);
				_tmp829_ = in_arg_map;
				_tmp830_ = m;
				_tmp831_ = cast;
				vala_map_set ((ValaMap*) _tmp829_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp830_), FALSE)), (ValaCCodeExpression*) _tmp831_);
				_tmp832_ = out_arg_map;
				_tmp833_ = m;
				_tmp834_ = cast;
				vala_map_set ((ValaMap*) _tmp832_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp833_), FALSE)), (ValaCCodeExpression*) _tmp834_);
				_vala_ccode_node_unref0 (klass);
				_vala_ccode_node_unref0 (cast);
				_vala_code_node_unref0 (cl);
			}
		}
	}
	_tmp836_ = m;
	if (_tmp836_ != NULL) {
		ValaMethod* _tmp837_;
		_tmp837_ = m;
		_tmp835_ = vala_get_ccode_has_generic_type_parameter (_tmp837_);
	} else {
		_tmp835_ = FALSE;
	}
	if (_tmp835_) {
		ValaMethod* _tmp838_;
		_tmp838_ = m;
		if (vala_method_has_type_parameters (_tmp838_)) {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp839_;
				ValaList* _tmp840_;
				gint _type_arg_size = 0;
				ValaList* _tmp841_;
				gint _tmp842_;
				gint _tmp843_;
				gint _type_arg_index = 0;
				_tmp839_ = ma;
				_tmp840_ = vala_member_access_get_type_arguments (_tmp839_);
				_type_arg_list = _tmp840_;
				_tmp841_ = _type_arg_list;
				_tmp842_ = vala_collection_get_size ((ValaCollection*) _tmp841_);
				_tmp843_ = _tmp842_;
				_type_arg_size = _tmp843_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp844_;
					gint _tmp845_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp846_;
					gpointer _tmp847_;
					gboolean _tmp848_ = FALSE;
					gboolean _tmp849_ = FALSE;
					gboolean _tmp850_ = FALSE;
					ValaMethod* _tmp851_;
					ValaHashMap* _tmp859_;
					ValaMethod* _tmp860_;
					ValaDataType* _tmp861_;
					gchar* _tmp862_;
					gchar* _tmp863_;
					ValaCCodeIdentifier* _tmp864_;
					ValaCCodeIdentifier* _tmp865_;
					gint _tmp866_;
					_type_arg_index = _type_arg_index + 1;
					_tmp844_ = _type_arg_index;
					_tmp845_ = _type_arg_size;
					if (!(_tmp844_ < _tmp845_)) {
						break;
					}
					_tmp846_ = _type_arg_list;
					_tmp847_ = vala_list_get (_tmp846_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp847_;
					_tmp851_ = m;
					if (vala_get_ccode_simple_generics (_tmp851_)) {
						ValaDataType* _tmp852_;
						_tmp852_ = type_arg;
						_tmp850_ = vala_data_type_is_real_struct_type (_tmp852_);
					} else {
						_tmp850_ = FALSE;
					}
					if (_tmp850_) {
						ValaDataType* _tmp853_;
						gboolean _tmp854_;
						gboolean _tmp855_;
						_tmp853_ = type_arg;
						_tmp854_ = vala_data_type_get_nullable (_tmp853_);
						_tmp855_ = _tmp854_;
						_tmp849_ = !_tmp855_;
					} else {
						_tmp849_ = FALSE;
					}
					if (_tmp849_) {
						ValaDataType* _tmp856_;
						_tmp856_ = type_arg;
						_tmp848_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp856_, VALA_TYPE_POINTER_TYPE);
					} else {
						_tmp848_ = FALSE;
					}
					if (_tmp848_) {
						ValaDataType* _tmp857_;
						ValaPointerType* _tmp858_;
						_tmp857_ = type_arg;
						_tmp858_ = vala_pointer_type_new (_tmp857_, NULL);
						_vala_code_node_unref0 (type_arg);
						type_arg = (ValaDataType*) _tmp858_;
					}
					_tmp859_ = in_arg_map;
					_tmp860_ = m;
					_tmp861_ = type_arg;
					_tmp862_ = vala_get_ccode_name ((ValaCodeNode*) _tmp861_);
					_tmp863_ = _tmp862_;
					_tmp864_ = vala_ccode_identifier_new (_tmp863_);
					_tmp865_ = _tmp864_;
					vala_map_set ((ValaMap*) _tmp859_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp860_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp865_);
					_vala_ccode_node_unref0 (_tmp865_);
					_g_free0 (_tmp863_);
					_tmp866_ = type_param_index;
					type_param_index = _tmp866_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
			}
		} else {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp867_;
				ValaExpression* _tmp868_;
				ValaExpression* _tmp869_;
				ValaDataType* _tmp870_;
				ValaDataType* _tmp871_;
				ValaList* _tmp872_;
				gint _type_arg_size = 0;
				ValaList* _tmp873_;
				gint _tmp874_;
				gint _tmp875_;
				gint _type_arg_index = 0;
				_tmp867_ = ma;
				_tmp868_ = vala_member_access_get_inner (_tmp867_);
				_tmp869_ = _tmp868_;
				_tmp870_ = vala_expression_get_value_type (_tmp869_);
				_tmp871_ = _tmp870_;
				_tmp872_ = vala_data_type_get_type_arguments (_tmp871_);
				_type_arg_list = _tmp872_;
				_tmp873_ = _type_arg_list;
				_tmp874_ = vala_collection_get_size ((ValaCollection*) _tmp873_);
				_tmp875_ = _tmp874_;
				_type_arg_size = _tmp875_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp876_;
					gint _tmp877_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp878_;
					gpointer _tmp879_;
					ValaHashMap* _tmp880_;
					ValaMethod* _tmp881_;
					ValaDataType* _tmp882_;
					gchar* _tmp883_;
					gchar* _tmp884_;
					ValaCCodeIdentifier* _tmp885_;
					ValaCCodeIdentifier* _tmp886_;
					gint _tmp887_;
					_type_arg_index = _type_arg_index + 1;
					_tmp876_ = _type_arg_index;
					_tmp877_ = _type_arg_size;
					if (!(_tmp876_ < _tmp877_)) {
						break;
					}
					_tmp878_ = _type_arg_list;
					_tmp879_ = vala_list_get (_tmp878_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp879_;
					_tmp880_ = in_arg_map;
					_tmp881_ = m;
					_tmp882_ = type_arg;
					_tmp883_ = vala_get_ccode_name ((ValaCodeNode*) _tmp882_);
					_tmp884_ = _tmp883_;
					_tmp885_ = vala_ccode_identifier_new (_tmp884_);
					_tmp886_ = _tmp885_;
					vala_map_set ((ValaMap*) _tmp880_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp881_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp886_);
					_vala_ccode_node_unref0 (_tmp886_);
					_g_free0 (_tmp884_);
					_tmp887_ = type_param_index;
					type_param_index = _tmp887_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
			}
		}
	}
	_tmp888_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp888_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp889_;
		ValaExpression* _tmp890_;
		ValaExpression* _tmp891_;
		ValaDataType* _tmp892_;
		ValaDataType* _tmp893_;
		ValaArrayType* _tmp894_;
		ValaCCodeFunctionCall* csizeof = NULL;
		ValaCCodeIdentifier* _tmp895_;
		ValaCCodeIdentifier* _tmp896_;
		ValaCCodeFunctionCall* _tmp897_;
		ValaCCodeFunctionCall* _tmp898_;
		ValaCCodeFunctionCall* _tmp899_;
		ValaArrayType* _tmp900_;
		ValaDataType* _tmp901_;
		ValaDataType* _tmp902_;
		gchar* _tmp903_;
		gchar* _tmp904_;
		ValaCCodeIdentifier* _tmp905_;
		ValaCCodeIdentifier* _tmp906_;
		ValaHashMap* _tmp907_;
		ValaCCodeFunctionCall* _tmp908_;
		_tmp889_ = ma;
		_tmp890_ = vala_member_access_get_inner (_tmp889_);
		_tmp891_ = _tmp890_;
		_tmp892_ = vala_expression_get_value_type (_tmp891_);
		_tmp893_ = _tmp892_;
		_tmp894_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp893_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp894_;
		_tmp895_ = vala_ccode_identifier_new ("sizeof");
		_tmp896_ = _tmp895_;
		_tmp897_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp896_);
		_tmp898_ = _tmp897_;
		_vala_ccode_node_unref0 (_tmp896_);
		csizeof = _tmp898_;
		_tmp899_ = csizeof;
		_tmp900_ = array_type;
		_tmp901_ = vala_array_type_get_element_type (_tmp900_);
		_tmp902_ = _tmp901_;
		_tmp903_ = vala_get_ccode_name ((ValaCodeNode*) _tmp902_);
		_tmp904_ = _tmp903_;
		_tmp905_ = vala_ccode_identifier_new (_tmp904_);
		_tmp906_ = _tmp905_;
		vala_ccode_function_call_add_argument (_tmp899_, (ValaCCodeExpression*) _tmp906_);
		_vala_ccode_node_unref0 (_tmp906_);
		_g_free0 (_tmp904_);
		_tmp907_ = in_arg_map;
		_tmp908_ = csizeof;
		vala_map_set ((ValaMap*) _tmp907_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp908_);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp909_;
		_tmp909_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp909_, VALA_TYPE_DYNAMIC_METHOD)) {
			ValaCCodeBaseModuleEmitContext* _tmp910_;
			ValaMethod* _tmp911_;
			ValaMethod* _tmp912_;
			gint param_nr = 0;
			ValaMethod* _tmp976_;
			ValaCCodeBaseModuleEmitContext* _tmp977_;
			_tmp910_ = ((ValaCCodeBaseModule*) self)->emit_context;
			_tmp911_ = m;
			vala_ccode_base_module_emit_context_push_symbol (_tmp910_, (ValaSymbol*) _tmp911_);
			_tmp912_ = m;
			vala_method_clear_parameters (_tmp912_);
			param_nr = 1;
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp913_;
				gint _arg_size = 0;
				ValaList* _tmp914_;
				gint _tmp915_;
				gint _tmp916_;
				gint _arg_index = 0;
				_tmp913_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) expr);
				_arg_list = _tmp913_;
				_tmp914_ = _arg_list;
				_tmp915_ = vala_collection_get_size ((ValaCollection*) _tmp914_);
				_tmp916_ = _tmp915_;
				_arg_size = _tmp916_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp917_;
					gint _tmp918_;
					ValaExpression* arg = NULL;
					ValaList* _tmp919_;
					gpointer _tmp920_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp921_;
					ValaUnaryExpression* _tmp922_;
					gboolean _tmp923_ = FALSE;
					ValaUnaryExpression* _tmp924_;
					gint _tmp965_;
					_arg_index = _arg_index + 1;
					_tmp917_ = _arg_index;
					_tmp918_ = _arg_size;
					if (!(_tmp917_ < _tmp918_)) {
						break;
					}
					_tmp919_ = _arg_list;
					_tmp920_ = vala_list_get (_tmp919_, _arg_index);
					arg = (ValaExpression*) _tmp920_;
					_tmp921_ = arg;
					_tmp922_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp921_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp921_) : NULL);
					unary = _tmp922_;
					_tmp924_ = unary;
					if (_tmp924_ != NULL) {
						ValaUnaryExpression* _tmp925_;
						ValaUnaryOperator _tmp926_;
						ValaUnaryOperator _tmp927_;
						_tmp925_ = unary;
						_tmp926_ = vala_unary_expression_get_operator (_tmp925_);
						_tmp927_ = _tmp926_;
						_tmp923_ = _tmp927_ == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp923_ = FALSE;
					}
					if (_tmp923_) {
						ValaParameter* param = NULL;
						gchar* _tmp928_;
						gchar* _tmp929_;
						ValaUnaryExpression* _tmp930_;
						ValaExpression* _tmp931_;
						ValaExpression* _tmp932_;
						ValaDataType* _tmp933_;
						ValaDataType* _tmp934_;
						ValaParameter* _tmp935_;
						ValaParameter* _tmp936_;
						ValaParameter* _tmp937_;
						ValaMethod* _tmp938_;
						ValaParameter* _tmp939_;
						_tmp928_ = g_strdup_printf ("param%d", param_nr);
						_tmp929_ = _tmp928_;
						_tmp930_ = unary;
						_tmp931_ = vala_unary_expression_get_inner (_tmp930_);
						_tmp932_ = _tmp931_;
						_tmp933_ = vala_expression_get_value_type (_tmp932_);
						_tmp934_ = _tmp933_;
						_tmp935_ = vala_parameter_new (_tmp929_, _tmp934_, NULL);
						_tmp936_ = _tmp935_;
						_g_free0 (_tmp929_);
						param = _tmp936_;
						_tmp937_ = param;
						vala_parameter_set_direction (_tmp937_, VALA_PARAMETER_DIRECTION_OUT);
						_tmp938_ = m;
						_tmp939_ = param;
						vala_callable_add_parameter ((ValaCallable*) _tmp938_, _tmp939_);
						_vala_code_node_unref0 (param);
					} else {
						gboolean _tmp940_ = FALSE;
						ValaUnaryExpression* _tmp941_;
						_tmp941_ = unary;
						if (_tmp941_ != NULL) {
							ValaUnaryExpression* _tmp942_;
							ValaUnaryOperator _tmp943_;
							ValaUnaryOperator _tmp944_;
							_tmp942_ = unary;
							_tmp943_ = vala_unary_expression_get_operator (_tmp942_);
							_tmp944_ = _tmp943_;
							_tmp940_ = _tmp944_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp940_ = FALSE;
						}
						if (_tmp940_) {
							ValaParameter* param = NULL;
							gchar* _tmp945_;
							gchar* _tmp946_;
							ValaUnaryExpression* _tmp947_;
							ValaExpression* _tmp948_;
							ValaExpression* _tmp949_;
							ValaDataType* _tmp950_;
							ValaDataType* _tmp951_;
							ValaParameter* _tmp952_;
							ValaParameter* _tmp953_;
							ValaParameter* _tmp954_;
							ValaMethod* _tmp955_;
							ValaParameter* _tmp956_;
							_tmp945_ = g_strdup_printf ("param%d", param_nr);
							_tmp946_ = _tmp945_;
							_tmp947_ = unary;
							_tmp948_ = vala_unary_expression_get_inner (_tmp947_);
							_tmp949_ = _tmp948_;
							_tmp950_ = vala_expression_get_value_type (_tmp949_);
							_tmp951_ = _tmp950_;
							_tmp952_ = vala_parameter_new (_tmp946_, _tmp951_, NULL);
							_tmp953_ = _tmp952_;
							_g_free0 (_tmp946_);
							param = _tmp953_;
							_tmp954_ = param;
							vala_parameter_set_direction (_tmp954_, VALA_PARAMETER_DIRECTION_REF);
							_tmp955_ = m;
							_tmp956_ = param;
							vala_callable_add_parameter ((ValaCallable*) _tmp955_, _tmp956_);
							_vala_code_node_unref0 (param);
						} else {
							ValaMethod* _tmp957_;
							gchar* _tmp958_;
							gchar* _tmp959_;
							ValaExpression* _tmp960_;
							ValaDataType* _tmp961_;
							ValaDataType* _tmp962_;
							ValaParameter* _tmp963_;
							ValaParameter* _tmp964_;
							_tmp957_ = m;
							_tmp958_ = g_strdup_printf ("param%d", param_nr);
							_tmp959_ = _tmp958_;
							_tmp960_ = arg;
							_tmp961_ = vala_expression_get_value_type (_tmp960_);
							_tmp962_ = _tmp961_;
							_tmp963_ = vala_parameter_new (_tmp959_, _tmp962_, NULL);
							_tmp964_ = _tmp963_;
							vala_callable_add_parameter ((ValaCallable*) _tmp957_, _tmp964_);
							_vala_code_node_unref0 (_tmp964_);
							_g_free0 (_tmp959_);
						}
					}
					_tmp965_ = param_nr;
					param_nr = _tmp965_ + 1;
					_vala_code_node_unref0 (unary);
					_vala_code_node_unref0 (arg);
				}
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp966_;
				ValaList* _tmp967_;
				gint _param_size = 0;
				ValaList* _tmp968_;
				gint _tmp969_;
				gint _tmp970_;
				gint _param_index = 0;
				_tmp966_ = m;
				_tmp967_ = vala_callable_get_parameters ((ValaCallable*) _tmp966_);
				_param_list = _tmp967_;
				_tmp968_ = _param_list;
				_tmp969_ = vala_collection_get_size ((ValaCollection*) _tmp968_);
				_tmp970_ = _tmp969_;
				_param_size = _tmp970_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp971_;
					gint _tmp972_;
					ValaParameter* param = NULL;
					ValaList* _tmp973_;
					gpointer _tmp974_;
					ValaParameter* _tmp975_;
					_param_index = _param_index + 1;
					_tmp971_ = _param_index;
					_tmp972_ = _param_size;
					if (!(_tmp971_ < _tmp972_)) {
						break;
					}
					_tmp973_ = _param_list;
					_tmp974_ = vala_list_get (_tmp973_, _param_index);
					param = (ValaParameter*) _tmp974_;
					_tmp975_ = param;
					vala_code_node_accept ((ValaCodeNode*) _tmp975_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (param);
				}
			}
			_tmp976_ = m;
			vala_ccode_base_module_generate_dynamic_method_wrapper ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp976_, VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethod));
			_tmp977_ = ((ValaCCodeBaseModule*) self)->emit_context;
			vala_ccode_base_module_emit_context_pop_symbol (_tmp977_);
		} else {
			gboolean _tmp978_ = FALSE;
			gboolean _tmp979_ = FALSE;
			ValaMethod* _tmp980_;
			_tmp980_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp980_, VALA_TYPE_CREATION_METHOD)) {
				ValaCodeContext* _tmp981_;
				ValaCodeContext* _tmp982_;
				ValaProfile _tmp983_;
				ValaProfile _tmp984_;
				_tmp981_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp982_ = _tmp981_;
				_tmp983_ = vala_code_context_get_profile (_tmp982_);
				_tmp984_ = _tmp983_;
				_tmp979_ = _tmp984_ == VALA_PROFILE_GOBJECT;
			} else {
				_tmp979_ = FALSE;
			}
			if (_tmp979_) {
				ValaMethod* _tmp985_;
				ValaSymbol* _tmp986_;
				ValaSymbol* _tmp987_;
				_tmp985_ = m;
				_tmp986_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp985_);
				_tmp987_ = _tmp986_;
				_tmp978_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp987_, VALA_TYPE_CLASS);
			} else {
				_tmp978_ = FALSE;
			}
			if (_tmp978_) {
				ValaCCodeFunction* _tmp988_;
				ValaCCodeFunction* _tmp989_;
				ValaCCodeExpression* _tmp990_;
				ValaCCodeExpression* _tmp991_;
				ValaCCodeFunctionCall* _tmp992_;
				ValaClass* _tmp993_;
				ValaClass* _tmp994_;
				gchar* _tmp995_;
				gchar* _tmp996_;
				gchar* _tmp997_;
				gchar* _tmp998_;
				ValaCCodeCastExpression* _tmp999_;
				ValaCCodeCastExpression* _tmp1000_;
				ValaMethod* _tmp1001_;
				ValaMethod* _tmp1002_;
				ValaBlock* _tmp1003_;
				ValaBlock* _tmp1004_;
				gboolean _tmp1005_;
				gboolean _tmp1006_;
				gboolean _tmp1033_ = FALSE;
				ValaClass* _tmp1034_;
				ValaClass* _tmp1035_;
				gboolean _tmp1036_;
				gboolean _tmp1037_;
				_tmp988_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp989_ = _tmp988_;
				_tmp990_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
				_tmp991_ = _tmp990_;
				_tmp992_ = ccall;
				_tmp993_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp994_ = _tmp993_;
				_tmp995_ = vala_get_ccode_name ((ValaCodeNode*) _tmp994_);
				_tmp996_ = _tmp995_;
				_tmp997_ = g_strconcat (_tmp996_, "*", NULL);
				_tmp998_ = _tmp997_;
				_tmp999_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp992_, _tmp998_);
				_tmp1000_ = _tmp999_;
				vala_ccode_function_add_assignment (_tmp989_, _tmp991_, (ValaCCodeExpression*) _tmp1000_);
				_vala_ccode_node_unref0 (_tmp1000_);
				_g_free0 (_tmp998_);
				_g_free0 (_tmp996_);
				_vala_ccode_node_unref0 (_tmp991_);
				_tmp1001_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
				_tmp1002_ = _tmp1001_;
				_tmp1003_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp1002_);
				_tmp1004_ = _tmp1003_;
				_tmp1005_ = vala_block_get_captured (_tmp1004_);
				_tmp1006_ = _tmp1005_;
				if (_tmp1006_) {
					ValaCCodeFunctionCall* ref_call = NULL;
					ValaClass* _tmp1007_;
					ValaClass* _tmp1008_;
					ValaObjectType* _tmp1009_;
					ValaObjectType* _tmp1010_;
					ValaSourceReference* _tmp1011_;
					ValaSourceReference* _tmp1012_;
					ValaCCodeExpression* _tmp1013_;
					ValaCCodeExpression* _tmp1014_;
					ValaCCodeFunctionCall* _tmp1015_;
					ValaCCodeFunctionCall* _tmp1016_;
					ValaCCodeFunctionCall* _tmp1017_;
					ValaCCodeExpression* _tmp1018_;
					ValaCCodeExpression* _tmp1019_;
					ValaCCodeFunction* _tmp1020_;
					ValaCCodeFunction* _tmp1021_;
					ValaMethod* _tmp1022_;
					ValaMethod* _tmp1023_;
					ValaBlock* _tmp1024_;
					ValaBlock* _tmp1025_;
					gchar* _tmp1026_;
					gchar* _tmp1027_;
					ValaCCodeExpression* _tmp1028_;
					ValaCCodeExpression* _tmp1029_;
					ValaCCodeMemberAccess* _tmp1030_;
					ValaCCodeMemberAccess* _tmp1031_;
					ValaCCodeFunctionCall* _tmp1032_;
					_tmp1007_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp1008_ = _tmp1007_;
					_tmp1009_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp1008_);
					_tmp1010_ = _tmp1009_;
					_tmp1011_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
					_tmp1012_ = _tmp1011_;
					_tmp1013_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1010_, _tmp1012_, FALSE);
					_tmp1014_ = _tmp1013_;
					_tmp1015_ = vala_ccode_function_call_new (_tmp1014_);
					_tmp1016_ = _tmp1015_;
					_vala_ccode_node_unref0 (_tmp1014_);
					_vala_code_node_unref0 (_tmp1010_);
					ref_call = _tmp1016_;
					_tmp1017_ = ref_call;
					_tmp1018_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp1019_ = _tmp1018_;
					vala_ccode_function_call_add_argument (_tmp1017_, _tmp1019_);
					_vala_ccode_node_unref0 (_tmp1019_);
					_tmp1020_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp1021_ = _tmp1020_;
					_tmp1022_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
					_tmp1023_ = _tmp1022_;
					_tmp1024_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp1023_);
					_tmp1025_ = _tmp1024_;
					_tmp1026_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp1025_));
					_tmp1027_ = _tmp1026_;
					_tmp1028_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1027_);
					_tmp1029_ = _tmp1028_;
					_tmp1030_ = vala_ccode_member_access_new_pointer (_tmp1029_, "self");
					_tmp1031_ = _tmp1030_;
					_tmp1032_ = ref_call;
					vala_ccode_function_add_assignment (_tmp1021_, (ValaCCodeExpression*) _tmp1031_, (ValaCCodeExpression*) _tmp1032_);
					_vala_ccode_node_unref0 (_tmp1031_);
					_vala_ccode_node_unref0 (_tmp1029_);
					_g_free0 (_tmp1027_);
					_vala_ccode_node_unref0 (ref_call);
				}
				_tmp1034_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp1035_ = _tmp1034_;
				_tmp1036_ = vala_class_get_is_compact (_tmp1035_);
				_tmp1037_ = _tmp1036_;
				if (!_tmp1037_) {
					ValaClass* _tmp1038_;
					ValaClass* _tmp1039_;
					_tmp1038_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp1039_ = _tmp1038_;
					_tmp1033_ = vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) _tmp1039_);
				} else {
					_tmp1033_ = FALSE;
				}
				if (_tmp1033_) {
					gchar** suffices = NULL;
					gchar* _tmp1040_;
					gchar* _tmp1041_;
					gchar* _tmp1042_;
					gchar** _tmp1043_;
					gint suffices_length1;
					gint _suffices_size_;
					_tmp1040_ = g_strdup ("type");
					_tmp1041_ = g_strdup ("dup_func");
					_tmp1042_ = g_strdup ("destroy_func");
					_tmp1043_ = g_new0 (gchar*, 3 + 1);
					_tmp1043_[0] = _tmp1040_;
					_tmp1043_[1] = _tmp1041_;
					_tmp1043_[2] = _tmp1042_;
					suffices = _tmp1043_;
					suffices_length1 = 3;
					_suffices_size_ = suffices_length1;
					{
						ValaList* _type_param_list = NULL;
						ValaClass* _tmp1044_;
						ValaClass* _tmp1045_;
						ValaList* _tmp1046_;
						gint _type_param_size = 0;
						ValaList* _tmp1047_;
						gint _tmp1048_;
						gint _tmp1049_;
						gint _type_param_index = 0;
						_tmp1044_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp1045_ = _tmp1044_;
						_tmp1046_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp1045_);
						_type_param_list = _tmp1046_;
						_tmp1047_ = _type_param_list;
						_tmp1048_ = vala_collection_get_size ((ValaCollection*) _tmp1047_);
						_tmp1049_ = _tmp1048_;
						_type_param_size = _tmp1049_;
						_type_param_index = -1;
						while (TRUE) {
							gint _tmp1050_;
							gint _tmp1051_;
							ValaTypeParameter* type_param = NULL;
							ValaList* _tmp1052_;
							gpointer _tmp1053_;
							ValaCCodeMemberAccess* priv_access = NULL;
							ValaCCodeIdentifier* _tmp1054_;
							ValaCCodeIdentifier* _tmp1055_;
							ValaCCodeMemberAccess* _tmp1056_;
							ValaCCodeMemberAccess* _tmp1057_;
							gchar** _tmp1058_;
							gint _tmp1058__length1;
							_type_param_index = _type_param_index + 1;
							_tmp1050_ = _type_param_index;
							_tmp1051_ = _type_param_size;
							if (!(_tmp1050_ < _tmp1051_)) {
								break;
							}
							_tmp1052_ = _type_param_list;
							_tmp1053_ = vala_list_get (_tmp1052_, _type_param_index);
							type_param = (ValaTypeParameter*) _tmp1053_;
							_tmp1054_ = vala_ccode_identifier_new ("self");
							_tmp1055_ = _tmp1054_;
							_tmp1056_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1055_, "priv");
							_tmp1057_ = _tmp1056_;
							_vala_ccode_node_unref0 (_tmp1055_);
							priv_access = _tmp1057_;
							_tmp1058_ = suffices;
							_tmp1058__length1 = suffices_length1;
							{
								gchar** suffix_collection = NULL;
								gint suffix_collection_length1 = 0;
								gint _suffix_collection_size_ = 0;
								gint suffix_it = 0;
								suffix_collection = _tmp1058_;
								suffix_collection_length1 = _tmp1058__length1;
								for (suffix_it = 0; suffix_it < suffix_collection_length1; suffix_it = suffix_it + 1) {
									gchar* _tmp1059_;
									gchar* suffix = NULL;
									_tmp1059_ = g_strdup (suffix_collection[suffix_it]);
									suffix = _tmp1059_;
									{
										ValaCCodeIdentifier* param_name = NULL;
										ValaTypeParameter* _tmp1060_;
										const gchar* _tmp1061_;
										const gchar* _tmp1062_;
										gchar* _tmp1063_;
										gchar* _tmp1064_;
										const gchar* _tmp1065_;
										gchar* _tmp1066_;
										gchar* _tmp1067_;
										ValaCCodeIdentifier* _tmp1068_;
										ValaCCodeIdentifier* _tmp1069_;
										ValaCCodeFunction* _tmp1070_;
										ValaCCodeFunction* _tmp1071_;
										ValaCCodeMemberAccess* _tmp1072_;
										ValaCCodeIdentifier* _tmp1073_;
										const gchar* _tmp1074_;
										const gchar* _tmp1075_;
										ValaCCodeMemberAccess* _tmp1076_;
										ValaCCodeMemberAccess* _tmp1077_;
										ValaCCodeIdentifier* _tmp1078_;
										_tmp1060_ = type_param;
										_tmp1061_ = vala_symbol_get_name ((ValaSymbol*) _tmp1060_);
										_tmp1062_ = _tmp1061_;
										_tmp1063_ = g_ascii_strdown (_tmp1062_, (gssize) -1);
										_tmp1064_ = _tmp1063_;
										_tmp1065_ = suffix;
										_tmp1066_ = g_strdup_printf ("%s_%s", _tmp1064_, _tmp1065_);
										_tmp1067_ = _tmp1066_;
										_tmp1068_ = vala_ccode_identifier_new (_tmp1067_);
										_tmp1069_ = _tmp1068_;
										_g_free0 (_tmp1067_);
										_g_free0 (_tmp1064_);
										param_name = _tmp1069_;
										_tmp1070_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
										_tmp1071_ = _tmp1070_;
										_tmp1072_ = priv_access;
										_tmp1073_ = param_name;
										_tmp1074_ = vala_ccode_identifier_get_name (_tmp1073_);
										_tmp1075_ = _tmp1074_;
										_tmp1076_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1072_, _tmp1075_);
										_tmp1077_ = _tmp1076_;
										_tmp1078_ = param_name;
										vala_ccode_function_add_assignment (_tmp1071_, (ValaCCodeExpression*) _tmp1077_, (ValaCCodeExpression*) _tmp1078_);
										_vala_ccode_node_unref0 (_tmp1077_);
										_vala_ccode_node_unref0 (param_name);
										_g_free0 (suffix);
									}
								}
							}
							_vala_ccode_node_unref0 (priv_access);
							_vala_code_node_unref0 (type_param);
						}
					}
					suffices = (_vala_array_free (suffices, suffices_length1, (GDestroyNotify) g_free), NULL);
				}
				_vala_ccode_node_unref0 (ccall_expr);
				ccall_expr = NULL;
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	_tmp1079_ = params;
	_tmp1080_ = vala_iterable_iterator ((ValaIterable*) _tmp1079_);
	params_it = _tmp1080_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp1081_;
		gint _arg_size = 0;
		ValaList* _tmp1082_;
		gint _tmp1083_;
		gint _tmp1084_;
		gint _arg_index = 0;
		_tmp1081_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) expr);
		_arg_list = _tmp1081_;
		_tmp1082_ = _arg_list;
		_tmp1083_ = vala_collection_get_size ((ValaCollection*) _tmp1082_);
		_tmp1084_ = _tmp1083_;
		_arg_size = _tmp1084_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp1085_;
			gint _tmp1086_;
			ValaExpression* arg = NULL;
			ValaList* _tmp1087_;
			gpointer _tmp1088_;
			ValaCCodeExpression* cexpr = NULL;
			ValaExpression* _tmp1089_;
			ValaCCodeExpression* _tmp1090_;
			ValaCCodeExpression* _tmp1091_;
			ValaHashMap* carg_map = NULL;
			ValaHashMap* _tmp1092_;
			ValaHashMap* _tmp1093_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp1094_;
			gboolean _tmp1104_ = FALSE;
			ValaParameter* _tmp1105_;
			gdouble _tmp1449_ = 0.0;
			gboolean _tmp1450_ = FALSE;
			ValaParameter* _tmp1451_;
			ValaHashMap* _tmp1453_;
			ValaCCodeExpression* _tmp1454_;
			gboolean _tmp1455_ = FALSE;
			ValaMethod* _tmp1456_;
			gboolean _tmp1481_ = FALSE;
			ValaExpression* _tmp1482_;
			gint _tmp1499_;
			_arg_index = _arg_index + 1;
			_tmp1085_ = _arg_index;
			_tmp1086_ = _arg_size;
			if (!(_tmp1085_ < _tmp1086_)) {
				break;
			}
			_tmp1087_ = _arg_list;
			_tmp1088_ = vala_list_get (_tmp1087_, _arg_index);
			arg = (ValaExpression*) _tmp1088_;
			_tmp1089_ = arg;
			_tmp1090_ = vala_get_cvalue (_tmp1089_);
			_tmp1091_ = _vala_ccode_node_ref0 (_tmp1090_);
			cexpr = _tmp1091_;
			_tmp1092_ = in_arg_map;
			_tmp1093_ = _vala_map_ref0 (_tmp1092_);
			carg_map = _tmp1093_;
			param = NULL;
			_tmp1094_ = params_it;
			if (vala_iterator_next (_tmp1094_)) {
				ValaIterator* _tmp1095_;
				gpointer _tmp1096_;
				gboolean _tmp1097_ = FALSE;
				ValaParameter* _tmp1098_;
				gboolean _tmp1099_;
				gboolean _tmp1100_;
				_tmp1095_ = params_it;
				_tmp1096_ = vala_iterator_get (_tmp1095_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp1096_;
				_tmp1098_ = param;
				_tmp1099_ = vala_parameter_get_params_array (_tmp1098_);
				_tmp1100_ = _tmp1099_;
				if (_tmp1100_) {
					_tmp1097_ = TRUE;
				} else {
					ValaParameter* _tmp1101_;
					gboolean _tmp1102_;
					gboolean _tmp1103_;
					_tmp1101_ = param;
					_tmp1102_ = vala_parameter_get_ellipsis (_tmp1101_);
					_tmp1103_ = _tmp1102_;
					_tmp1097_ = _tmp1103_;
				}
				ellipsis = _tmp1097_;
			}
			_tmp1105_ = param;
			if (_tmp1105_ != NULL) {
				_tmp1104_ = !ellipsis;
			} else {
				_tmp1104_ = FALSE;
			}
			if (_tmp1104_) {
				ValaParameter* _tmp1106_;
				ValaParameterDirection _tmp1107_;
				ValaParameterDirection _tmp1108_;
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp1111_;
				ValaUnaryExpression* _tmp1112_;
				gboolean _tmp1113_ = FALSE;
				ValaUnaryExpression* _tmp1114_;
				ValaParameter* _tmp1379_;
				gchar* _tmp1380_;
				gchar* _tmp1381_;
				gboolean _tmp1382_;
				_tmp1106_ = param;
				_tmp1107_ = vala_parameter_get_direction (_tmp1106_);
				_tmp1108_ = _tmp1107_;
				if (_tmp1108_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaHashMap* _tmp1109_;
					ValaHashMap* _tmp1110_;
					_tmp1109_ = out_arg_map;
					_tmp1110_ = _vala_map_ref0 (_tmp1109_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp1110_;
				}
				_tmp1111_ = arg;
				_tmp1112_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1111_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1111_) : NULL);
				unary = _tmp1112_;
				_tmp1114_ = unary;
				if (_tmp1114_ == NULL) {
					_tmp1113_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp1115_;
					ValaUnaryOperator _tmp1116_;
					ValaUnaryOperator _tmp1117_;
					_tmp1115_ = unary;
					_tmp1116_ = vala_unary_expression_get_operator (_tmp1115_);
					_tmp1117_ = _tmp1116_;
					_tmp1113_ = _tmp1117_ != VALA_UNARY_OPERATOR_OUT;
				}
				if (_tmp1113_) {
					gboolean _tmp1118_ = FALSE;
					gboolean _tmp1119_ = FALSE;
					ValaParameter* _tmp1120_;
					ValaParameter* _tmp1262_;
					ValaExpression* _tmp1263_;
					ValaCCodeExpression* _tmp1264_;
					ValaCCodeExpression* _tmp1265_;
					_tmp1120_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1120_)) {
						ValaParameter* _tmp1121_;
						ValaDataType* _tmp1122_;
						ValaDataType* _tmp1123_;
						_tmp1121_ = param;
						_tmp1122_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1121_);
						_tmp1123_ = _tmp1122_;
						_tmp1119_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1123_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp1119_ = FALSE;
					}
					if (_tmp1119_) {
						ValaParameter* _tmp1124_;
						ValaDataType* _tmp1125_;
						ValaDataType* _tmp1126_;
						gboolean _tmp1127_;
						gboolean _tmp1128_;
						_tmp1124_ = param;
						_tmp1125_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1124_);
						_tmp1126_ = _tmp1125_;
						_tmp1127_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp1126_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp1128_ = _tmp1127_;
						_tmp1118_ = !_tmp1128_;
					} else {
						_tmp1118_ = FALSE;
					}
					if (_tmp1118_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp1129_;
						ValaDataType* _tmp1130_;
						ValaDataType* _tmp1131_;
						ValaArrayType* _tmp1132_;
						gchar* length_ctype = NULL;
						ValaParameter* _tmp1133_;
						gchar* _tmp1134_;
						gboolean _tmp1135_ = FALSE;
						ValaUnaryExpression* _tmp1136_;
						_tmp1129_ = param;
						_tmp1130_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1129_);
						_tmp1131_ = _tmp1130_;
						_tmp1132_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1131_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp1132_;
						_tmp1133_ = param;
						_tmp1134_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1133_);
						length_ctype = _tmp1134_;
						_tmp1136_ = unary;
						if (_tmp1136_ != NULL) {
							ValaUnaryExpression* _tmp1137_;
							ValaUnaryOperator _tmp1138_;
							ValaUnaryOperator _tmp1139_;
							_tmp1137_ = unary;
							_tmp1138_ = vala_unary_expression_get_operator (_tmp1137_);
							_tmp1139_ = _tmp1138_;
							_tmp1135_ = _tmp1139_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp1135_ = FALSE;
						}
						if (_tmp1135_) {
							const gchar* _tmp1140_;
							gchar* _tmp1141_;
							_tmp1140_ = length_ctype;
							_tmp1141_ = g_strdup_printf ("%s*", _tmp1140_);
							_g_free0 (length_ctype);
							length_ctype = _tmp1141_;
						}
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp1142_ = FALSE;
								_tmp1142_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp1144_;
									gint _tmp1145_;
									gint _tmp1146_;
									ValaCCodeCastExpression* array_length_expr = NULL;
									ValaExpression* _tmp1147_;
									ValaCCodeExpression* _tmp1148_;
									ValaCCodeExpression* _tmp1149_;
									const gchar* _tmp1150_;
									ValaCCodeCastExpression* _tmp1151_;
									ValaCCodeCastExpression* _tmp1152_;
									ValaHashMap* _tmp1153_;
									ValaParameter* _tmp1154_;
									ValaCCodeCastExpression* _tmp1155_;
									if (!_tmp1142_) {
										gint _tmp1143_;
										_tmp1143_ = dim;
										dim = _tmp1143_ + 1;
									}
									_tmp1142_ = FALSE;
									_tmp1144_ = array_type;
									_tmp1145_ = vala_array_type_get_rank (_tmp1144_);
									_tmp1146_ = _tmp1145_;
									if (!(dim <= _tmp1146_)) {
										break;
									}
									_tmp1147_ = arg;
									_tmp1148_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1147_, dim);
									_tmp1149_ = _tmp1148_;
									_tmp1150_ = length_ctype;
									_tmp1151_ = vala_ccode_cast_expression_new (_tmp1149_, _tmp1150_);
									_tmp1152_ = _tmp1151_;
									_vala_ccode_node_unref0 (_tmp1149_);
									array_length_expr = _tmp1152_;
									_tmp1153_ = carg_map;
									_tmp1154_ = param;
									_tmp1155_ = array_length_expr;
									vala_map_set ((ValaMap*) _tmp1153_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1154_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1155_);
									_vala_ccode_node_unref0 (array_length_expr);
								}
							}
						}
						_g_free0 (length_ctype);
						_vala_code_node_unref0 (array_type);
					} else {
						gboolean _tmp1156_ = FALSE;
						ValaParameter* _tmp1157_;
						_tmp1157_ = param;
						if (vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1157_)) {
							ValaParameter* _tmp1158_;
							ValaDataType* _tmp1159_;
							ValaDataType* _tmp1160_;
							_tmp1158_ = param;
							_tmp1159_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1158_);
							_tmp1160_ = _tmp1159_;
							_tmp1156_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1160_, VALA_TYPE_DELEGATE_TYPE);
						} else {
							_tmp1156_ = FALSE;
						}
						if (_tmp1156_) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp1161_;
							ValaDataType* _tmp1162_;
							ValaDataType* _tmp1163_;
							ValaDelegateType* _tmp1164_;
							ValaDelegateType* _tmp1165_;
							ValaDelegate* _tmp1166_;
							ValaDelegate* _tmp1167_;
							gboolean _tmp1168_;
							gboolean _tmp1169_;
							_tmp1161_ = param;
							_tmp1162_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1161_);
							_tmp1163_ = _tmp1162_;
							_tmp1164_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1163_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp1164_;
							_tmp1165_ = deleg_type;
							_tmp1166_ = vala_delegate_type_get_delegate_symbol (_tmp1165_);
							_tmp1167_ = _tmp1166_;
							_tmp1168_ = vala_delegate_get_has_target (_tmp1167_);
							_tmp1169_ = _tmp1168_;
							if (_tmp1169_) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaCCodeExpression* delegate_target = NULL;
								ValaExpression* _tmp1170_;
								ValaCCodeExpression* _tmp1171_ = NULL;
								ValaCCodeExpression* _tmp1172_;
								ValaCCodeExpression* _tmp1173_;
								ValaParameter* _tmp1174_;
								gchar* _tmp1175_;
								gchar* _tmp1176_;
								gboolean _tmp1177_;
								_tmp1170_ = arg;
								_tmp1172_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1170_, &_tmp1171_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp1171_;
								delegate_target = _tmp1172_;
								_tmp1173_ = delegate_target;
								_vala_assert (_tmp1173_ != NULL, "delegate_target != null");
								_tmp1174_ = param;
								_tmp1175_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1174_);
								_tmp1176_ = _tmp1175_;
								_tmp1177_ = g_strcmp0 (_tmp1176_, "GClosure*") == 0;
								_g_free0 (_tmp1176_);
								if (_tmp1177_) {
									ValaCCodeFunctionCall* closure_new = NULL;
									ValaCCodeIdentifier* _tmp1178_;
									ValaCCodeIdentifier* _tmp1179_;
									ValaCCodeFunctionCall* _tmp1180_;
									ValaCCodeFunctionCall* _tmp1181_;
									ValaCCodeFunctionCall* _tmp1182_;
									ValaCCodeExpression* _tmp1183_;
									ValaCCodeCastExpression* _tmp1184_;
									ValaCCodeCastExpression* _tmp1185_;
									ValaCCodeFunctionCall* _tmp1186_;
									ValaCCodeExpression* _tmp1187_;
									ValaCCodeFunctionCall* _tmp1188_;
									ValaCCodeExpression* _tmp1189_;
									ValaCCodeCastExpression* _tmp1190_;
									ValaCCodeCastExpression* _tmp1191_;
									ValaCCodeExpression* _tmp1192_;
									ValaCCodeConstant* _tmp1193_;
									ValaCCodeConstant* _tmp1194_;
									ValaCCodeBinaryExpression* _tmp1195_;
									ValaCCodeBinaryExpression* _tmp1196_;
									ValaCCodeConstant* _tmp1197_;
									ValaCCodeConstant* _tmp1198_;
									ValaCCodeFunctionCall* _tmp1199_;
									ValaCCodeConditionalExpression* _tmp1200_;
									_tmp1178_ = vala_ccode_identifier_new ("g_cclosure_new");
									_tmp1179_ = _tmp1178_;
									_tmp1180_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1179_);
									_tmp1181_ = _tmp1180_;
									_vala_ccode_node_unref0 (_tmp1179_);
									closure_new = _tmp1181_;
									_tmp1182_ = closure_new;
									_tmp1183_ = cexpr;
									_tmp1184_ = vala_ccode_cast_expression_new (_tmp1183_, "GCallback");
									_tmp1185_ = _tmp1184_;
									vala_ccode_function_call_add_argument (_tmp1182_, (ValaCCodeExpression*) _tmp1185_);
									_vala_ccode_node_unref0 (_tmp1185_);
									_tmp1186_ = closure_new;
									_tmp1187_ = delegate_target;
									vala_ccode_function_call_add_argument (_tmp1186_, _tmp1187_);
									_tmp1188_ = closure_new;
									_tmp1189_ = delegate_target_destroy_notify;
									_tmp1190_ = vala_ccode_cast_expression_new (_tmp1189_, "GClosureNotify");
									_tmp1191_ = _tmp1190_;
									vala_ccode_function_call_add_argument (_tmp1188_, (ValaCCodeExpression*) _tmp1191_);
									_vala_ccode_node_unref0 (_tmp1191_);
									_tmp1192_ = cexpr;
									_tmp1193_ = vala_ccode_constant_new ("NULL");
									_tmp1194_ = _tmp1193_;
									_tmp1195_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp1192_, (ValaCCodeExpression*) _tmp1194_);
									_tmp1196_ = _tmp1195_;
									_tmp1197_ = vala_ccode_constant_new ("NULL");
									_tmp1198_ = _tmp1197_;
									_tmp1199_ = closure_new;
									_tmp1200_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1196_, (ValaCCodeExpression*) _tmp1198_, (ValaCCodeExpression*) _tmp1199_);
									_vala_ccode_node_unref0 (cexpr);
									cexpr = (ValaCCodeExpression*) _tmp1200_;
									_vala_ccode_node_unref0 (_tmp1198_);
									_vala_ccode_node_unref0 (_tmp1196_);
									_vala_ccode_node_unref0 (_tmp1194_);
									_vala_ccode_node_unref0 (closure_new);
								} else {
									ValaCCodeExpression* node = NULL;
									ValaHashMap* _tmp1201_;
									ValaParameter* _tmp1202_;
									gpointer _tmp1203_;
									gboolean _tmp1204_ = FALSE;
									ValaCCodeExpression* _tmp1205_;
									_tmp1201_ = carg_map;
									_tmp1202_ = param;
									_tmp1203_ = vala_map_get ((ValaMap*) _tmp1201_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1202_), FALSE)));
									node = (ValaCCodeExpression*) _tmp1203_;
									_tmp1205_ = node;
									if (_tmp1205_ == NULL) {
										_tmp1204_ = TRUE;
									} else {
										gboolean _tmp1206_ = FALSE;
										ValaCCodeExpression* _tmp1207_;
										_tmp1207_ = node;
										if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1207_, VALA_TYPE_CCODE_CONSTANT)) {
											ValaCCodeExpression* _tmp1208_;
											const gchar* _tmp1209_;
											const gchar* _tmp1210_;
											_tmp1208_ = node;
											_tmp1209_ = vala_ccode_constant_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp1208_, VALA_TYPE_CCODE_CONSTANT, ValaCCodeConstant));
											_tmp1210_ = _tmp1209_;
											_tmp1206_ = g_strcmp0 (_tmp1210_, "NULL") == 0;
										} else {
											_tmp1206_ = FALSE;
										}
										_tmp1204_ = _tmp1206_;
									}
									if (_tmp1204_) {
										ValaHashMap* _tmp1211_;
										ValaParameter* _tmp1212_;
										ValaCCodeExpression* _tmp1213_;
										ValaDelegateType* _tmp1214_;
										_tmp1211_ = carg_map;
										_tmp1212_ = param;
										_tmp1213_ = delegate_target;
										vala_map_set ((ValaMap*) _tmp1211_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1212_), FALSE)), _tmp1213_);
										_tmp1214_ = deleg_type;
										if (vala_data_type_is_disposable ((ValaDataType*) _tmp1214_)) {
											ValaCCodeExpression* _tmp1215_;
											ValaHashMap* _tmp1216_;
											ValaParameter* _tmp1217_;
											ValaCCodeExpression* _tmp1218_;
											_tmp1215_ = delegate_target_destroy_notify;
											_vala_assert (_tmp1215_ != NULL, "delegate_target_destroy_notify != null");
											_tmp1216_ = carg_map;
											_tmp1217_ = param;
											_tmp1218_ = delegate_target_destroy_notify;
											vala_map_set ((ValaMap*) _tmp1216_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1217_), FALSE)), _tmp1218_);
										}
									}
									_vala_ccode_node_unref0 (node);
								}
								_vala_ccode_node_unref0 (delegate_target);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							}
							_vala_code_node_unref0 (deleg_type);
						} else {
							ValaParameter* _tmp1219_;
							ValaDataType* _tmp1220_;
							ValaDataType* _tmp1221_;
							_tmp1219_ = param;
							_tmp1220_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1219_);
							_tmp1221_ = _tmp1220_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1221_, VALA_TYPE_METHOD_TYPE)) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaHashMap* _tmp1222_;
								ValaParameter* _tmp1223_;
								ValaExpression* _tmp1224_;
								ValaCCodeExpression* _tmp1225_ = NULL;
								ValaCCodeExpression* _tmp1226_;
								ValaCCodeExpression* _tmp1227_;
								_tmp1222_ = carg_map;
								_tmp1223_ = param;
								_tmp1224_ = arg;
								_tmp1226_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1224_, &_tmp1225_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp1225_;
								_tmp1227_ = _tmp1226_;
								vala_map_set ((ValaMap*) _tmp1222_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1223_), FALSE)), _tmp1227_);
								_vala_ccode_node_unref0 (_tmp1227_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							} else {
								ValaParameter* _tmp1228_;
								ValaDataType* _tmp1229_;
								ValaDataType* _tmp1230_;
								_tmp1228_ = param;
								_tmp1229_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1228_);
								_tmp1230_ = _tmp1229_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1230_, VALA_TYPE_GENERIC_TYPE)) {
									gboolean _tmp1231_ = FALSE;
									ValaMethod* _tmp1232_;
									_tmp1232_ = m;
									if (_tmp1232_ != NULL) {
										ValaMethod* _tmp1233_;
										_tmp1233_ = m;
										_tmp1231_ = vala_get_ccode_simple_generics (_tmp1233_);
									} else {
										_tmp1231_ = FALSE;
									}
									if (_tmp1231_) {
										ValaGenericType* generic_type = NULL;
										ValaParameter* _tmp1234_;
										ValaDataType* _tmp1235_;
										ValaDataType* _tmp1236_;
										ValaGenericType* _tmp1237_;
										gint type_param_index = 0;
										ValaMethod* _tmp1238_;
										ValaGenericType* _tmp1239_;
										ValaTypeParameter* _tmp1240_;
										ValaTypeParameter* _tmp1241_;
										const gchar* _tmp1242_;
										const gchar* _tmp1243_;
										ValaDataType* type_arg = NULL;
										ValaMemberAccess* _tmp1244_;
										ValaList* _tmp1245_;
										gpointer _tmp1246_;
										ValaParameter* _tmp1247_;
										ValaDataType* _tmp1248_;
										ValaDataType* _tmp1249_;
										gboolean _tmp1250_;
										gboolean _tmp1251_;
										_tmp1234_ = param;
										_tmp1235_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1234_);
										_tmp1236_ = _tmp1235_;
										_tmp1237_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1236_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
										generic_type = _tmp1237_;
										_tmp1238_ = m;
										_tmp1239_ = generic_type;
										_tmp1240_ = vala_generic_type_get_type_parameter (_tmp1239_);
										_tmp1241_ = _tmp1240_;
										_tmp1242_ = vala_symbol_get_name ((ValaSymbol*) _tmp1241_);
										_tmp1243_ = _tmp1242_;
										type_param_index = vala_method_get_type_parameter_index (_tmp1238_, _tmp1243_);
										_tmp1244_ = ma;
										_tmp1245_ = vala_member_access_get_type_arguments (_tmp1244_);
										_tmp1246_ = vala_list_get (_tmp1245_, type_param_index);
										type_arg = (ValaDataType*) _tmp1246_;
										_tmp1247_ = param;
										_tmp1248_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1247_);
										_tmp1249_ = _tmp1248_;
										_tmp1250_ = vala_data_type_get_value_owned (_tmp1249_);
										_tmp1251_ = _tmp1250_;
										if (_tmp1251_) {
											ValaDataType* _tmp1252_;
											_tmp1252_ = type_arg;
											if (vala_ccode_base_module_requires_copy (_tmp1252_)) {
												ValaHashMap* _tmp1253_;
												ValaParameter* _tmp1254_;
												ValaDataType* _tmp1255_;
												ValaCCodeExpression* _tmp1256_;
												ValaCCodeExpression* _tmp1257_;
												_tmp1253_ = carg_map;
												_tmp1254_ = param;
												_tmp1255_ = type_arg;
												_tmp1256_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, _tmp1255_, FALSE);
												_tmp1257_ = _tmp1256_;
												vala_map_set ((ValaMap*) _tmp1253_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1254_), FALSE)), _tmp1257_);
												_vala_ccode_node_unref0 (_tmp1257_);
											} else {
												ValaHashMap* _tmp1258_;
												ValaParameter* _tmp1259_;
												ValaCCodeConstant* _tmp1260_;
												ValaCCodeConstant* _tmp1261_;
												_tmp1258_ = carg_map;
												_tmp1259_ = param;
												_tmp1260_ = vala_ccode_constant_new ("NULL");
												_tmp1261_ = _tmp1260_;
												vala_map_set ((ValaMap*) _tmp1258_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1259_), FALSE)), (ValaCCodeExpression*) _tmp1261_);
												_vala_ccode_node_unref0 (_tmp1261_);
											}
										}
										_vala_code_node_unref0 (type_arg);
										_vala_code_node_unref0 (generic_type);
									}
								}
							}
						}
					}
					_tmp1262_ = param;
					_tmp1263_ = arg;
					_tmp1264_ = cexpr;
					_tmp1265_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, _tmp1262_, _tmp1263_, _tmp1264_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1265_;
				} else {
					ValaExpression* _tmp1266_;
					ValaLocalVariable* temp_var = NULL;
					ValaParameter* _tmp1267_;
					ValaDataType* _tmp1268_;
					ValaDataType* _tmp1269_;
					ValaParameter* _tmp1270_;
					ValaDataType* _tmp1271_;
					ValaDataType* _tmp1272_;
					gboolean _tmp1273_;
					gboolean _tmp1274_;
					ValaLocalVariable* _tmp1275_;
					ValaLocalVariable* _tmp1276_;
					ValaExpression* _tmp1277_;
					ValaLocalVariable* _tmp1278_;
					const gchar* _tmp1279_;
					const gchar* _tmp1280_;
					ValaCCodeExpression* _tmp1281_;
					ValaCCodeExpression* _tmp1282_;
					ValaExpression* _tmp1283_;
					ValaTargetValue* _tmp1284_;
					ValaTargetValue* _tmp1285_;
					ValaExpression* _tmp1286_;
					ValaDataType* _tmp1287_;
					ValaDataType* _tmp1288_;
					ValaExpression* _tmp1289_;
					ValaCCodeExpression* _tmp1290_;
					ValaCCodeUnaryExpression* _tmp1291_;
					gboolean _tmp1292_ = FALSE;
					gboolean _tmp1293_ = FALSE;
					ValaParameter* _tmp1294_;
					_tmp1266_ = arg;
					vala_expression_set_target_value (_tmp1266_, NULL);
					_tmp1267_ = param;
					_tmp1268_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1267_);
					_tmp1269_ = _tmp1268_;
					_tmp1270_ = param;
					_tmp1271_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1270_);
					_tmp1272_ = _tmp1271_;
					_tmp1273_ = vala_data_type_get_value_owned (_tmp1272_);
					_tmp1274_ = _tmp1273_;
					_tmp1275_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1269_, _tmp1274_, NULL, TRUE);
					temp_var = _tmp1275_;
					_tmp1276_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1276_, FALSE);
					_tmp1277_ = arg;
					_tmp1278_ = temp_var;
					_tmp1279_ = vala_symbol_get_name ((ValaSymbol*) _tmp1278_);
					_tmp1280_ = _tmp1279_;
					_tmp1281_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1280_);
					_tmp1282_ = _tmp1281_;
					vala_set_cvalue (_tmp1277_, _tmp1282_);
					_vala_ccode_node_unref0 (_tmp1282_);
					_tmp1283_ = arg;
					_tmp1284_ = vala_expression_get_target_value (_tmp1283_);
					_tmp1285_ = _tmp1284_;
					_tmp1286_ = arg;
					_tmp1287_ = vala_expression_get_target_type (_tmp1286_);
					_tmp1288_ = _tmp1287_;
					vala_target_value_set_value_type (_tmp1285_, _tmp1288_);
					_tmp1289_ = arg;
					_tmp1290_ = vala_get_cvalue (_tmp1289_);
					_tmp1291_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1290_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1291_;
					_tmp1294_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1294_)) {
						ValaParameter* _tmp1295_;
						ValaDataType* _tmp1296_;
						ValaDataType* _tmp1297_;
						_tmp1295_ = param;
						_tmp1296_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1295_);
						_tmp1297_ = _tmp1296_;
						_tmp1293_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1297_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp1293_ = FALSE;
					}
					if (_tmp1293_) {
						ValaParameter* _tmp1298_;
						ValaDataType* _tmp1299_;
						ValaDataType* _tmp1300_;
						gboolean _tmp1301_;
						gboolean _tmp1302_;
						_tmp1298_ = param;
						_tmp1299_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1298_);
						_tmp1300_ = _tmp1299_;
						_tmp1301_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp1300_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp1302_ = _tmp1301_;
						_tmp1292_ = !_tmp1302_;
					} else {
						_tmp1292_ = FALSE;
					}
					if (_tmp1292_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp1303_;
						ValaDataType* _tmp1304_;
						ValaDataType* _tmp1305_;
						ValaArrayType* _tmp1306_;
						gchar* length_ctype = NULL;
						ValaParameter* _tmp1307_;
						gchar* _tmp1308_;
						_tmp1303_ = param;
						_tmp1304_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1303_);
						_tmp1305_ = _tmp1304_;
						_tmp1306_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1305_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp1306_;
						_tmp1307_ = param;
						_tmp1308_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1307_);
						length_ctype = _tmp1308_;
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp1309_ = FALSE;
								_tmp1309_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp1311_;
									gint _tmp1312_;
									gint _tmp1313_;
									ValaLocalVariable* temp_array_length = NULL;
									const gchar* _tmp1314_;
									ValaCType* _tmp1315_;
									ValaCType* _tmp1316_;
									ValaLocalVariable* _tmp1317_;
									ValaLocalVariable* _tmp1318_;
									ValaLocalVariable* _tmp1319_;
									ValaExpression* _tmp1320_;
									ValaLocalVariable* _tmp1321_;
									const gchar* _tmp1322_;
									const gchar* _tmp1323_;
									ValaCCodeExpression* _tmp1324_;
									ValaCCodeExpression* _tmp1325_;
									ValaHashMap* _tmp1326_;
									ValaParameter* _tmp1327_;
									ValaExpression* _tmp1328_;
									ValaList* _tmp1329_;
									gpointer _tmp1330_;
									ValaCCodeExpression* _tmp1331_;
									ValaCCodeUnaryExpression* _tmp1332_;
									ValaCCodeUnaryExpression* _tmp1333_;
									if (!_tmp1309_) {
										gint _tmp1310_;
										_tmp1310_ = dim;
										dim = _tmp1310_ + 1;
									}
									_tmp1309_ = FALSE;
									_tmp1311_ = array_type;
									_tmp1312_ = vala_array_type_get_rank (_tmp1311_);
									_tmp1313_ = _tmp1312_;
									if (!(dim <= _tmp1313_)) {
										break;
									}
									_tmp1314_ = length_ctype;
									_tmp1315_ = vala_ctype_new (_tmp1314_, "0");
									_tmp1316_ = _tmp1315_;
									_tmp1317_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1316_, TRUE, NULL, TRUE);
									_tmp1318_ = _tmp1317_;
									_vala_code_node_unref0 (_tmp1316_);
									temp_array_length = _tmp1318_;
									_tmp1319_ = temp_array_length;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1319_, FALSE);
									_tmp1320_ = arg;
									_tmp1321_ = temp_array_length;
									_tmp1322_ = vala_symbol_get_name ((ValaSymbol*) _tmp1321_);
									_tmp1323_ = _tmp1322_;
									_tmp1324_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1323_);
									_tmp1325_ = _tmp1324_;
									vala_append_array_length (_tmp1320_, _tmp1325_);
									_vala_ccode_node_unref0 (_tmp1325_);
									_tmp1326_ = carg_map;
									_tmp1327_ = param;
									_tmp1328_ = arg;
									_tmp1329_ = vala_get_array_lengths (_tmp1328_);
									_tmp1330_ = vala_list_get (_tmp1329_, dim - 1);
									_tmp1331_ = (ValaCCodeExpression*) _tmp1330_;
									_tmp1332_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1331_);
									_tmp1333_ = _tmp1332_;
									vala_map_set ((ValaMap*) _tmp1326_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1327_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1333_);
									_vala_ccode_node_unref0 (_tmp1333_);
									_vala_ccode_node_unref0 (_tmp1331_);
									_vala_code_node_unref0 (temp_array_length);
								}
							}
						}
						_g_free0 (length_ctype);
						_vala_code_node_unref0 (array_type);
					} else {
						gboolean _tmp1334_ = FALSE;
						ValaParameter* _tmp1335_;
						_tmp1335_ = param;
						if (vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1335_)) {
							ValaParameter* _tmp1336_;
							ValaDataType* _tmp1337_;
							ValaDataType* _tmp1338_;
							_tmp1336_ = param;
							_tmp1337_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1336_);
							_tmp1338_ = _tmp1337_;
							_tmp1334_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1338_, VALA_TYPE_DELEGATE_TYPE);
						} else {
							_tmp1334_ = FALSE;
						}
						if (_tmp1334_) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp1339_;
							ValaDataType* _tmp1340_;
							ValaDataType* _tmp1341_;
							ValaDelegateType* _tmp1342_;
							ValaDelegateType* _tmp1343_;
							ValaDelegate* _tmp1344_;
							ValaDelegate* _tmp1345_;
							gboolean _tmp1346_;
							gboolean _tmp1347_;
							_tmp1339_ = param;
							_tmp1340_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1339_);
							_tmp1341_ = _tmp1340_;
							_tmp1342_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1341_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp1342_;
							_tmp1343_ = deleg_type;
							_tmp1344_ = vala_delegate_type_get_delegate_symbol (_tmp1343_);
							_tmp1345_ = _tmp1344_;
							_tmp1346_ = vala_delegate_get_has_target (_tmp1345_);
							_tmp1347_ = _tmp1346_;
							if (_tmp1347_) {
								ValaDataType* _tmp1348_;
								ValaLocalVariable* _tmp1349_;
								ValaLocalVariable* _tmp1350_;
								ValaExpression* _tmp1351_;
								ValaLocalVariable* _tmp1352_;
								const gchar* _tmp1353_;
								const gchar* _tmp1354_;
								ValaCCodeExpression* _tmp1355_;
								ValaCCodeExpression* _tmp1356_;
								ValaHashMap* _tmp1357_;
								ValaParameter* _tmp1358_;
								ValaExpression* _tmp1359_;
								ValaCCodeExpression* _tmp1360_;
								ValaCCodeUnaryExpression* _tmp1361_;
								ValaCCodeUnaryExpression* _tmp1362_;
								ValaDelegateType* _tmp1363_;
								_tmp1348_ = ((ValaCCodeBaseModule*) self)->delegate_target_type;
								_tmp1349_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1348_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1349_;
								_tmp1350_ = temp_var;
								vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1350_, FALSE);
								_tmp1351_ = arg;
								_tmp1352_ = temp_var;
								_tmp1353_ = vala_symbol_get_name ((ValaSymbol*) _tmp1352_);
								_tmp1354_ = _tmp1353_;
								_tmp1355_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1354_);
								_tmp1356_ = _tmp1355_;
								vala_set_delegate_target (_tmp1351_, _tmp1356_);
								_vala_ccode_node_unref0 (_tmp1356_);
								_tmp1357_ = carg_map;
								_tmp1358_ = param;
								_tmp1359_ = arg;
								_tmp1360_ = vala_get_delegate_target (_tmp1359_);
								_tmp1361_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1360_);
								_tmp1362_ = _tmp1361_;
								vala_map_set ((ValaMap*) _tmp1357_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1358_), FALSE)), (ValaCCodeExpression*) _tmp1362_);
								_vala_ccode_node_unref0 (_tmp1362_);
								_tmp1363_ = deleg_type;
								if (vala_data_type_is_disposable ((ValaDataType*) _tmp1363_)) {
									ValaDelegateType* _tmp1364_;
									ValaLocalVariable* _tmp1365_;
									ValaLocalVariable* _tmp1366_;
									ValaExpression* _tmp1367_;
									ValaLocalVariable* _tmp1368_;
									const gchar* _tmp1369_;
									const gchar* _tmp1370_;
									ValaCCodeExpression* _tmp1371_;
									ValaCCodeExpression* _tmp1372_;
									ValaHashMap* _tmp1373_;
									ValaParameter* _tmp1374_;
									ValaExpression* _tmp1375_;
									ValaCCodeExpression* _tmp1376_;
									ValaCCodeUnaryExpression* _tmp1377_;
									ValaCCodeUnaryExpression* _tmp1378_;
									_tmp1364_ = ((ValaCCodeBaseModule*) self)->delegate_target_destroy_type;
									_tmp1365_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1364_, TRUE, NULL, TRUE);
									_vala_code_node_unref0 (temp_var);
									temp_var = _tmp1365_;
									_tmp1366_ = temp_var;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1366_, FALSE);
									_tmp1367_ = arg;
									_tmp1368_ = temp_var;
									_tmp1369_ = vala_symbol_get_name ((ValaSymbol*) _tmp1368_);
									_tmp1370_ = _tmp1369_;
									_tmp1371_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1370_);
									_tmp1372_ = _tmp1371_;
									vala_set_delegate_target_destroy_notify (_tmp1367_, _tmp1372_);
									_vala_ccode_node_unref0 (_tmp1372_);
									_tmp1373_ = carg_map;
									_tmp1374_ = param;
									_tmp1375_ = arg;
									_tmp1376_ = vala_get_delegate_target_destroy_notify (_tmp1375_);
									_tmp1377_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1376_);
									_tmp1378_ = _tmp1377_;
									vala_map_set ((ValaMap*) _tmp1373_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1374_), FALSE)), (ValaCCodeExpression*) _tmp1378_);
									_vala_ccode_node_unref0 (_tmp1378_);
								}
							}
							_vala_code_node_unref0 (deleg_type);
						}
					}
					_vala_code_node_unref0 (temp_var);
				}
				_tmp1379_ = param;
				_tmp1380_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1379_);
				_tmp1381_ = _tmp1380_;
				_tmp1382_ = _tmp1381_ != NULL;
				_g_free0 (_tmp1381_);
				if (_tmp1382_) {
					ValaCCodeExpression* _tmp1383_;
					ValaParameter* _tmp1384_;
					gchar* _tmp1385_;
					gchar* _tmp1386_;
					ValaCCodeCastExpression* _tmp1387_;
					_tmp1383_ = cexpr;
					_tmp1384_ = param;
					_tmp1385_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1384_);
					_tmp1386_ = _tmp1385_;
					_tmp1387_ = vala_ccode_cast_expression_new (_tmp1383_, _tmp1386_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1387_;
					_g_free0 (_tmp1386_);
				}
				_vala_code_node_unref0 (unary);
			} else {
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp1388_;
				ValaUnaryExpression* _tmp1389_;
				gboolean _tmp1390_ = FALSE;
				gboolean _tmp1391_ = FALSE;
				_tmp1388_ = arg;
				_tmp1389_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1388_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1388_) : NULL);
				unary = _tmp1389_;
				if (ellipsis) {
					ValaUnaryExpression* _tmp1392_;
					_tmp1392_ = unary;
					_tmp1391_ = _tmp1392_ != NULL;
				} else {
					_tmp1391_ = FALSE;
				}
				if (_tmp1391_) {
					ValaUnaryExpression* _tmp1393_;
					ValaUnaryOperator _tmp1394_;
					ValaUnaryOperator _tmp1395_;
					_tmp1393_ = unary;
					_tmp1394_ = vala_unary_expression_get_operator (_tmp1393_);
					_tmp1395_ = _tmp1394_;
					_tmp1390_ = _tmp1395_ == VALA_UNARY_OPERATOR_OUT;
				} else {
					_tmp1390_ = FALSE;
				}
				if (_tmp1390_) {
					ValaHashMap* _tmp1396_;
					ValaHashMap* _tmp1397_;
					ValaExpression* _tmp1398_;
					ValaLocalVariable* temp_var = NULL;
					ValaExpression* _tmp1399_;
					ValaDataType* _tmp1400_;
					ValaDataType* _tmp1401_;
					ValaExpression* _tmp1402_;
					ValaDataType* _tmp1403_;
					ValaDataType* _tmp1404_;
					gboolean _tmp1405_;
					gboolean _tmp1406_;
					ValaLocalVariable* _tmp1407_;
					ValaLocalVariable* _tmp1408_;
					ValaExpression* _tmp1409_;
					ValaLocalVariable* _tmp1410_;
					const gchar* _tmp1411_;
					const gchar* _tmp1412_;
					ValaCCodeExpression* _tmp1413_;
					ValaCCodeExpression* _tmp1414_;
					ValaExpression* _tmp1415_;
					ValaTargetValue* _tmp1416_;
					ValaTargetValue* _tmp1417_;
					ValaExpression* _tmp1418_;
					ValaDataType* _tmp1419_;
					ValaDataType* _tmp1420_;
					gboolean _tmp1421_ = FALSE;
					ValaExpression* _tmp1422_;
					ValaDataType* _tmp1423_;
					ValaDataType* _tmp1424_;
					ValaExpression* _tmp1443_;
					ValaCCodeExpression* _tmp1444_;
					ValaCCodeUnaryExpression* _tmp1445_;
					_tmp1396_ = out_arg_map;
					_tmp1397_ = _vala_map_ref0 (_tmp1396_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp1397_;
					_tmp1398_ = arg;
					vala_expression_set_target_value (_tmp1398_, NULL);
					_tmp1399_ = arg;
					_tmp1400_ = vala_expression_get_value_type (_tmp1399_);
					_tmp1401_ = _tmp1400_;
					_tmp1402_ = arg;
					_tmp1403_ = vala_expression_get_value_type (_tmp1402_);
					_tmp1404_ = _tmp1403_;
					_tmp1405_ = vala_data_type_get_value_owned (_tmp1404_);
					_tmp1406_ = _tmp1405_;
					_tmp1407_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1401_, _tmp1406_, NULL, TRUE);
					temp_var = _tmp1407_;
					_tmp1408_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1408_, FALSE);
					_tmp1409_ = arg;
					_tmp1410_ = temp_var;
					_tmp1411_ = vala_symbol_get_name ((ValaSymbol*) _tmp1410_);
					_tmp1412_ = _tmp1411_;
					_tmp1413_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1412_);
					_tmp1414_ = _tmp1413_;
					vala_set_cvalue (_tmp1409_, _tmp1414_);
					_vala_ccode_node_unref0 (_tmp1414_);
					_tmp1415_ = arg;
					_tmp1416_ = vala_expression_get_target_value (_tmp1415_);
					_tmp1417_ = _tmp1416_;
					_tmp1418_ = arg;
					_tmp1419_ = vala_expression_get_value_type (_tmp1418_);
					_tmp1420_ = _tmp1419_;
					vala_target_value_set_value_type (_tmp1417_, _tmp1420_);
					_tmp1422_ = arg;
					_tmp1423_ = vala_expression_get_value_type (_tmp1422_);
					_tmp1424_ = _tmp1423_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1424_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaExpression* _tmp1425_;
						ValaDataType* _tmp1426_;
						ValaDataType* _tmp1427_;
						ValaDelegate* _tmp1428_;
						ValaDelegate* _tmp1429_;
						gboolean _tmp1430_;
						gboolean _tmp1431_;
						_tmp1425_ = arg;
						_tmp1426_ = vala_expression_get_value_type (_tmp1425_);
						_tmp1427_ = _tmp1426_;
						_tmp1428_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1427_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp1429_ = _tmp1428_;
						_tmp1430_ = vala_delegate_get_has_target (_tmp1429_);
						_tmp1431_ = _tmp1430_;
						_tmp1421_ = _tmp1431_;
					} else {
						_tmp1421_ = FALSE;
					}
					if (_tmp1421_) {
						ValaGLibValue* arg_value = NULL;
						ValaExpression* _tmp1432_;
						ValaTargetValue* _tmp1433_;
						ValaTargetValue* _tmp1434_;
						ValaGLibValue* _tmp1435_;
						ValaCCodeExpression* _tmp1436_;
						ValaGLibValue* _tmp1439_;
						ValaCCodeExpression* _tmp1440_;
						_tmp1432_ = arg;
						_tmp1433_ = vala_expression_get_target_value (_tmp1432_);
						_tmp1434_ = _tmp1433_;
						arg_value = G_TYPE_CHECK_INSTANCE_CAST (_tmp1434_, VALA_TYPE_GLIB_VALUE, ValaGLibValue);
						_tmp1435_ = arg_value;
						_tmp1436_ = _tmp1435_->delegate_target_cvalue;
						if (_tmp1436_ == NULL) {
							ValaGLibValue* _tmp1437_;
							ValaCCodeConstant* _tmp1438_;
							_tmp1437_ = arg_value;
							_tmp1438_ = vala_ccode_constant_new ("NULL");
							_vala_ccode_node_unref0 (_tmp1437_->delegate_target_cvalue);
							_tmp1437_->delegate_target_cvalue = (ValaCCodeExpression*) _tmp1438_;
						}
						_tmp1439_ = arg_value;
						_tmp1440_ = _tmp1439_->delegate_target_destroy_notify_cvalue;
						if (_tmp1440_ == NULL) {
							ValaGLibValue* _tmp1441_;
							ValaCCodeConstant* _tmp1442_;
							_tmp1441_ = arg_value;
							_tmp1442_ = vala_ccode_constant_new ("NULL");
							_vala_ccode_node_unref0 (_tmp1441_->delegate_target_destroy_notify_cvalue);
							_tmp1441_->delegate_target_destroy_notify_cvalue = (ValaCCodeExpression*) _tmp1442_;
						}
					}
					_tmp1443_ = arg;
					_tmp1444_ = vala_get_cvalue (_tmp1443_);
					_tmp1445_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1444_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1445_;
					_vala_code_node_unref0 (temp_var);
				} else {
					ValaExpression* _tmp1446_;
					ValaCCodeExpression* _tmp1447_;
					ValaCCodeExpression* _tmp1448_;
					_tmp1446_ = arg;
					_tmp1447_ = cexpr;
					_tmp1448_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1446_, _tmp1447_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1448_;
				}
				_vala_code_node_unref0 (unary);
			}
			_tmp1451_ = param;
			if (_tmp1451_ != NULL) {
				_tmp1450_ = !ellipsis;
			} else {
				_tmp1450_ = FALSE;
			}
			if (_tmp1450_) {
				ValaParameter* _tmp1452_;
				_tmp1452_ = param;
				_tmp1449_ = vala_get_ccode_pos (_tmp1452_);
			} else {
				_tmp1449_ = (gdouble) i;
			}
			arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, _tmp1449_, ellipsis);
			_tmp1453_ = carg_map;
			_tmp1454_ = cexpr;
			vala_map_set ((ValaMap*) _tmp1453_, (gpointer) ((gintptr) arg_pos), _tmp1454_);
			_tmp1456_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1456_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
				ValaCodeContext* _tmp1457_;
				ValaCodeContext* _tmp1458_;
				ValaProfile _tmp1459_;
				ValaProfile _tmp1460_;
				_tmp1457_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp1458_ = _tmp1457_;
				_tmp1459_ = vala_code_context_get_profile (_tmp1458_);
				_tmp1460_ = _tmp1459_;
				_tmp1455_ = _tmp1460_ == VALA_PROFILE_POSIX;
			} else {
				_tmp1455_ = FALSE;
			}
			if (_tmp1455_) {
				ValaCCodeIdentifier* csizeof = NULL;
				ValaMemberAccess* _tmp1461_;
				ValaExpression* _tmp1462_;
				ValaExpression* _tmp1463_;
				ValaDataType* _tmp1464_;
				ValaDataType* _tmp1465_;
				ValaDataType* _tmp1466_;
				ValaDataType* _tmp1467_;
				gchar* _tmp1468_;
				gchar* _tmp1469_;
				gchar* _tmp1470_;
				gchar* _tmp1471_;
				ValaCCodeIdentifier* _tmp1472_;
				ValaCCodeIdentifier* _tmp1473_;
				ValaHashMap* _tmp1474_;
				ValaCCodeIdentifier* _tmp1475_;
				ValaCCodeExpression* _tmp1476_;
				ValaCCodeBinaryExpression* _tmp1477_;
				ValaCCodeBinaryExpression* _tmp1478_;
				_tmp1461_ = ma;
				_tmp1462_ = vala_member_access_get_inner (_tmp1461_);
				_tmp1463_ = _tmp1462_;
				_tmp1464_ = vala_expression_get_value_type (_tmp1463_);
				_tmp1465_ = _tmp1464_;
				_tmp1466_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp1465_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp1467_ = _tmp1466_;
				_tmp1468_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1467_);
				_tmp1469_ = _tmp1468_;
				_tmp1470_ = g_strdup_printf ("sizeof (%s)", _tmp1469_);
				_tmp1471_ = _tmp1470_;
				_tmp1472_ = vala_ccode_identifier_new (_tmp1471_);
				_tmp1473_ = _tmp1472_;
				_g_free0 (_tmp1471_);
				_g_free0 (_tmp1469_);
				csizeof = _tmp1473_;
				_tmp1474_ = carg_map;
				_tmp1475_ = csizeof;
				_tmp1476_ = cexpr;
				_tmp1477_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1475_, _tmp1476_);
				_tmp1478_ = _tmp1477_;
				vala_map_set ((ValaMap*) _tmp1474_, (gpointer) ((gintptr) arg_pos), (ValaCCodeExpression*) _tmp1478_);
				_vala_ccode_node_unref0 (_tmp1478_);
				_vala_ccode_node_unref0 (csizeof);
			} else {
				ValaHashMap* _tmp1479_;
				ValaCCodeExpression* _tmp1480_;
				_tmp1479_ = carg_map;
				_tmp1480_ = cexpr;
				vala_map_set ((ValaMap*) _tmp1479_, (gpointer) ((gintptr) arg_pos), _tmp1480_);
			}
			_tmp1482_ = arg;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1482_, VALA_TYPE_NAMED_ARGUMENT)) {
				_tmp1481_ = ellipsis;
			} else {
				_tmp1481_ = FALSE;
			}
			if (_tmp1481_) {
				ValaNamedArgument* named_arg = NULL;
				ValaExpression* _tmp1483_;
				ValaNamedArgument* _tmp1484_;
				gchar* name = NULL;
				ValaNamedArgument* _tmp1485_;
				const gchar* _tmp1486_;
				const gchar* _tmp1487_;
				gchar** _tmp1488_;
				gchar** _tmp1489_;
				gchar** _tmp1490_;
				gint _tmp1490__length1;
				gchar* _tmp1491_;
				gchar* _tmp1492_;
				ValaHashMap* _tmp1493_;
				const gchar* _tmp1494_;
				gchar* _tmp1495_;
				gchar* _tmp1496_;
				ValaCCodeConstant* _tmp1497_;
				ValaCCodeConstant* _tmp1498_;
				_tmp1483_ = arg;
				_tmp1484_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1483_, VALA_TYPE_NAMED_ARGUMENT, ValaNamedArgument));
				named_arg = _tmp1484_;
				_tmp1485_ = named_arg;
				_tmp1486_ = vala_named_argument_get_name (_tmp1485_);
				_tmp1487_ = _tmp1486_;
				_tmp1489_ = _tmp1488_ = g_strsplit (_tmp1487_, "_", 0);
				_tmp1490_ = _tmp1489_;
				_tmp1490__length1 = _vala_array_length (_tmp1488_);
				_tmp1491_ = _vala_g_strjoinv ("-", _tmp1490_, (gint) _vala_array_length (_tmp1488_));
				_tmp1492_ = _tmp1491_;
				_tmp1490_ = (_vala_array_free (_tmp1490_, _tmp1490__length1, (GDestroyNotify) g_free), NULL);
				name = _tmp1492_;
				_tmp1493_ = carg_map;
				_tmp1494_ = name;
				_tmp1495_ = g_strdup_printf ("\"%s\"", _tmp1494_);
				_tmp1496_ = _tmp1495_;
				_tmp1497_ = vala_ccode_constant_new (_tmp1496_);
				_tmp1498_ = _tmp1497_;
				vala_map_set ((ValaMap*) _tmp1493_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, i - 0.1, ellipsis)), (ValaCCodeExpression*) _tmp1498_);
				_vala_ccode_node_unref0 (_tmp1498_);
				_g_free0 (_tmp1496_);
				_g_free0 (name);
				_vala_code_node_unref0 (named_arg);
			}
			_tmp1499_ = i;
			i = _tmp1499_ + 1;
			_vala_code_node_unref0 (param);
			_vala_map_unref0 (carg_map);
			_vala_ccode_node_unref0 (cexpr);
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp1500_ = params_it;
	if (vala_iterator_next (_tmp1500_)) {
		ValaParameter* param = NULL;
		ValaIterator* _tmp1501_;
		gpointer _tmp1502_;
		gboolean _tmp1503_ = FALSE;
		ValaParameter* _tmp1504_;
		gboolean _tmp1505_;
		gboolean _tmp1506_;
		_tmp1501_ = params_it;
		_tmp1502_ = vala_iterator_get (_tmp1501_);
		param = (ValaParameter*) _tmp1502_;
		_tmp1504_ = param;
		_tmp1505_ = vala_parameter_get_params_array (_tmp1504_);
		_tmp1506_ = _tmp1505_;
		if (_tmp1506_) {
			_tmp1503_ = TRUE;
		} else {
			ValaParameter* _tmp1507_;
			gboolean _tmp1508_;
			gboolean _tmp1509_;
			_tmp1507_ = param;
			_tmp1508_ = vala_parameter_get_ellipsis (_tmp1507_);
			_tmp1509_ = _tmp1508_;
			_tmp1503_ = _tmp1509_;
		}
		_vala_assert (_tmp1503_, "param.params_array || param.ellipsis");
		ellipsis = TRUE;
		_vala_code_node_unref0 (param);
	}
	_tmp1512_ = m;
	if (_tmp1512_ != NULL) {
		ValaMethod* _tmp1513_;
		ValaDataType* _tmp1514_;
		ValaDataType* _tmp1515_;
		_tmp1513_ = m;
		_tmp1514_ = vala_callable_get_return_type ((ValaCallable*) _tmp1513_);
		_tmp1515_ = _tmp1514_;
		_tmp1511_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1515_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1511_ = FALSE;
	}
	if (_tmp1511_) {
		ValaCCodeFunctionCall* _tmp1516_;
		ValaCCodeFunctionCall* _tmp1517_;
		_tmp1516_ = async_call;
		_tmp1517_ = ccall;
		_tmp1510_ = _tmp1516_ != _tmp1517_;
	} else {
		_tmp1510_ = FALSE;
	}
	if (_tmp1510_) {
		ValaArrayType* array_type = NULL;
		ValaMethod* _tmp1518_;
		ValaDataType* _tmp1519_;
		ValaDataType* _tmp1520_;
		ValaArrayType* _tmp1521_;
		_tmp1518_ = m;
		_tmp1519_ = vala_callable_get_return_type ((ValaCallable*) _tmp1518_);
		_tmp1520_ = _tmp1519_;
		_tmp1521_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1520_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1521_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1522_ = FALSE;
				_tmp1522_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1524_;
					gint _tmp1525_;
					gint _tmp1526_;
					ValaMethod* _tmp1527_;
					if (!_tmp1522_) {
						gint _tmp1523_;
						_tmp1523_ = dim;
						dim = _tmp1523_ + 1;
					}
					_tmp1522_ = FALSE;
					_tmp1524_ = array_type;
					_tmp1525_ = vala_array_type_get_rank (_tmp1524_);
					_tmp1526_ = _tmp1525_;
					if (!(dim <= _tmp1526_)) {
						break;
					}
					_tmp1527_ = m;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1527_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1528_;
						ValaDataType* _tmp1529_;
						ValaLocalVariable* _tmp1530_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1531_;
						const gchar* _tmp1532_;
						const gchar* _tmp1533_;
						ValaCCodeExpression* _tmp1534_;
						ValaLocalVariable* _tmp1535_;
						ValaCCodeExpression* _tmp1536_;
						ValaCCodeExpression* _tmp1537_;
						ValaCCodeAssignment* _tmp1538_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1539_;
						ValaCCodeIdentifier* _tmp1540_;
						ValaCCodeFunctionCall* _tmp1541_;
						ValaCCodeFunctionCall* _tmp1542_;
						ValaCCodeFunctionCall* _tmp1543_;
						ValaCCodeExpression* _tmp1544_;
						ValaCCodeFunctionCall* _tmp1545_;
						_tmp1528_ = itype;
						_tmp1529_ = vala_data_type_get_return_type (_tmp1528_);
						_tmp1530_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1529_, TRUE, NULL, FALSE);
						temp_var = _tmp1530_;
						_tmp1531_ = temp_var;
						_tmp1532_ = vala_symbol_get_name ((ValaSymbol*) _tmp1531_);
						_tmp1533_ = _tmp1532_;
						_tmp1534_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1533_);
						temp_ref = _tmp1534_;
						_tmp1535_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1535_, FALSE);
						_tmp1536_ = temp_ref;
						_tmp1537_ = ccall_expr;
						_tmp1538_ = vala_ccode_assignment_new (_tmp1536_, _tmp1537_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1538_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1539_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1540_ = _tmp1539_;
						_tmp1541_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1540_);
						_tmp1542_ = _tmp1541_;
						_vala_ccode_node_unref0 (_tmp1540_);
						len_call = _tmp1542_;
						_tmp1543_ = len_call;
						_tmp1544_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1543_, _tmp1544_);
						_tmp1545_ = len_call;
						vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1545_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaMethod* _tmp1546_;
						_tmp1546_ = m;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1546_)) {
							gchar* length_ctype = NULL;
							ValaMethod* _tmp1547_;
							gchar* _tmp1548_;
							ValaLocalVariable* temp_var = NULL;
							const gchar* _tmp1549_;
							ValaCType* _tmp1550_;
							ValaCType* _tmp1551_;
							ValaLocalVariable* _tmp1552_;
							ValaLocalVariable* _tmp1553_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1554_;
							const gchar* _tmp1555_;
							const gchar* _tmp1556_;
							ValaCCodeExpression* _tmp1557_;
							ValaLocalVariable* _tmp1558_;
							ValaHashMap* _tmp1559_;
							ValaMethod* _tmp1560_;
							ValaCCodeExpression* _tmp1561_;
							ValaCCodeUnaryExpression* _tmp1562_;
							ValaCCodeUnaryExpression* _tmp1563_;
							ValaCCodeExpression* _tmp1564_;
							_tmp1547_ = m;
							_tmp1548_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1547_);
							length_ctype = _tmp1548_;
							_tmp1549_ = length_ctype;
							_tmp1550_ = vala_ctype_new (_tmp1549_, "0");
							_tmp1551_ = _tmp1550_;
							_tmp1552_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1551_, TRUE, NULL, TRUE);
							_tmp1553_ = _tmp1552_;
							_vala_code_node_unref0 (_tmp1551_);
							temp_var = _tmp1553_;
							_tmp1554_ = temp_var;
							_tmp1555_ = vala_symbol_get_name ((ValaSymbol*) _tmp1554_);
							_tmp1556_ = _tmp1555_;
							_tmp1557_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1556_);
							temp_ref = _tmp1557_;
							_tmp1558_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1558_, FALSE);
							_tmp1559_ = out_arg_map;
							_tmp1560_ = m;
							_tmp1561_ = temp_ref;
							_tmp1562_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1561_);
							_tmp1563_ = _tmp1562_;
							vala_map_set ((ValaMap*) _tmp1559_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1560_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1563_);
							_vala_ccode_node_unref0 (_tmp1563_);
							_tmp1564_ = temp_ref;
							vala_append_array_length ((ValaExpression*) expr, _tmp1564_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
							_g_free0 (length_ctype);
						} else {
							ValaMethod* _tmp1565_;
							gchar* _tmp1566_;
							gchar* _tmp1567_;
							gboolean _tmp1568_;
							_tmp1565_ = m;
							_tmp1566_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1565_);
							_tmp1567_ = _tmp1566_;
							_tmp1568_ = _tmp1567_ != NULL;
							_g_free0 (_tmp1567_);
							if (_tmp1568_) {
								ValaMethod* _tmp1569_;
								gchar* _tmp1570_;
								gchar* _tmp1571_;
								ValaCCodeConstant* _tmp1572_;
								ValaCCodeConstant* _tmp1573_;
								_tmp1569_ = m;
								_tmp1570_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1569_);
								_tmp1571_ = _tmp1570_;
								_tmp1572_ = vala_ccode_constant_new (_tmp1571_);
								_tmp1573_ = _tmp1572_;
								vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1573_);
								_vala_ccode_node_unref0 (_tmp1573_);
								_g_free0 (_tmp1571_);
							} else {
								ValaCCodeConstant* _tmp1574_;
								ValaCCodeConstant* _tmp1575_;
								_tmp1574_ = vala_ccode_constant_new ("-1");
								_tmp1575_ = _tmp1574_;
								vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1575_);
								_vala_ccode_node_unref0 (_tmp1575_);
							}
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1576_ = FALSE;
		gboolean _tmp1577_ = FALSE;
		ValaMethod* _tmp1578_;
		_tmp1578_ = m;
		if (_tmp1578_ != NULL) {
			ValaMethod* _tmp1579_;
			ValaDataType* _tmp1580_;
			ValaDataType* _tmp1581_;
			_tmp1579_ = m;
			_tmp1580_ = vala_callable_get_return_type ((ValaCallable*) _tmp1579_);
			_tmp1581_ = _tmp1580_;
			_tmp1577_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1581_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1577_ = FALSE;
		}
		if (_tmp1577_) {
			ValaCCodeFunctionCall* _tmp1582_;
			ValaCCodeFunctionCall* _tmp1583_;
			_tmp1582_ = async_call;
			_tmp1583_ = ccall;
			_tmp1576_ = _tmp1582_ != _tmp1583_;
		} else {
			_tmp1576_ = FALSE;
		}
		if (_tmp1576_) {
			ValaDelegateType* deleg_type = NULL;
			ValaMethod* _tmp1584_;
			ValaDataType* _tmp1585_;
			ValaDataType* _tmp1586_;
			ValaDelegateType* _tmp1587_;
			gboolean _tmp1588_ = FALSE;
			ValaMethod* _tmp1589_;
			_tmp1584_ = m;
			_tmp1585_ = vala_callable_get_return_type ((ValaCallable*) _tmp1584_);
			_tmp1586_ = _tmp1585_;
			_tmp1587_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1586_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1587_;
			_tmp1589_ = m;
			if (vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1589_)) {
				ValaDelegateType* _tmp1590_;
				ValaDelegate* _tmp1591_;
				ValaDelegate* _tmp1592_;
				gboolean _tmp1593_;
				gboolean _tmp1594_;
				_tmp1590_ = deleg_type;
				_tmp1591_ = vala_delegate_type_get_delegate_symbol (_tmp1590_);
				_tmp1592_ = _tmp1591_;
				_tmp1593_ = vala_delegate_get_has_target (_tmp1592_);
				_tmp1594_ = _tmp1593_;
				_tmp1588_ = _tmp1594_;
			} else {
				_tmp1588_ = FALSE;
			}
			if (_tmp1588_) {
				ValaLocalVariable* temp_var = NULL;
				ValaDataType* _tmp1595_;
				ValaLocalVariable* _tmp1596_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1597_;
				const gchar* _tmp1598_;
				const gchar* _tmp1599_;
				ValaCCodeExpression* _tmp1600_;
				ValaLocalVariable* _tmp1601_;
				ValaHashMap* _tmp1602_;
				ValaMethod* _tmp1603_;
				ValaCCodeExpression* _tmp1604_;
				ValaCCodeUnaryExpression* _tmp1605_;
				ValaCCodeUnaryExpression* _tmp1606_;
				ValaCCodeExpression* _tmp1607_;
				ValaDelegateType* _tmp1608_;
				_tmp1595_ = ((ValaCCodeBaseModule*) self)->delegate_target_type;
				_tmp1596_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1595_, TRUE, NULL, TRUE);
				temp_var = _tmp1596_;
				_tmp1597_ = temp_var;
				_tmp1598_ = vala_symbol_get_name ((ValaSymbol*) _tmp1597_);
				_tmp1599_ = _tmp1598_;
				_tmp1600_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1599_);
				temp_ref = _tmp1600_;
				_tmp1601_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1601_, FALSE);
				_tmp1602_ = out_arg_map;
				_tmp1603_ = m;
				_tmp1604_ = temp_ref;
				_tmp1605_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1604_);
				_tmp1606_ = _tmp1605_;
				vala_map_set ((ValaMap*) _tmp1602_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1603_), FALSE)), (ValaCCodeExpression*) _tmp1606_);
				_vala_ccode_node_unref0 (_tmp1606_);
				_tmp1607_ = temp_ref;
				vala_set_delegate_target ((ValaExpression*) expr, _tmp1607_);
				_tmp1608_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1608_)) {
					ValaDelegateType* _tmp1609_;
					ValaLocalVariable* _tmp1610_;
					ValaLocalVariable* _tmp1611_;
					const gchar* _tmp1612_;
					const gchar* _tmp1613_;
					ValaCCodeExpression* _tmp1614_;
					ValaLocalVariable* _tmp1615_;
					ValaHashMap* _tmp1616_;
					ValaMethod* _tmp1617_;
					ValaCCodeExpression* _tmp1618_;
					ValaCCodeUnaryExpression* _tmp1619_;
					ValaCCodeUnaryExpression* _tmp1620_;
					ValaCCodeExpression* _tmp1621_;
					_tmp1609_ = ((ValaCCodeBaseModule*) self)->delegate_target_destroy_type;
					_tmp1610_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1609_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1610_;
					_tmp1611_ = temp_var;
					_tmp1612_ = vala_symbol_get_name ((ValaSymbol*) _tmp1611_);
					_tmp1613_ = _tmp1612_;
					_tmp1614_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1613_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1614_;
					_tmp1615_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1615_, FALSE);
					_tmp1616_ = out_arg_map;
					_tmp1617_ = m;
					_tmp1618_ = temp_ref;
					_tmp1619_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1618_);
					_tmp1620_ = _tmp1619_;
					vala_map_set ((ValaMap*) _tmp1616_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1617_), FALSE)), (ValaCCodeExpression*) _tmp1620_);
					_vala_ccode_node_unref0 (_tmp1620_);
					_tmp1621_ = temp_ref;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, _tmp1621_);
				} else {
					ValaCCodeConstant* _tmp1622_;
					ValaCCodeConstant* _tmp1623_;
					_tmp1622_ = vala_ccode_constant_new ("NULL");
					_tmp1623_ = _tmp1622_;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1623_);
					_vala_ccode_node_unref0 (_tmp1623_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			} else {
				ValaCCodeConstant* _tmp1624_;
				ValaCCodeConstant* _tmp1625_;
				ValaDelegateType* _tmp1626_;
				ValaDelegate* _tmp1627_;
				ValaDelegate* _tmp1628_;
				gboolean _tmp1629_;
				gboolean _tmp1630_;
				_tmp1624_ = vala_ccode_constant_new ("NULL");
				_tmp1625_ = _tmp1624_;
				vala_set_delegate_target ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1625_);
				_vala_ccode_node_unref0 (_tmp1625_);
				_tmp1626_ = deleg_type;
				_tmp1627_ = vala_delegate_type_get_delegate_symbol (_tmp1626_);
				_tmp1628_ = _tmp1627_;
				_tmp1629_ = vala_delegate_get_has_target (_tmp1628_);
				_tmp1630_ = _tmp1629_;
				if (_tmp1630_) {
					ValaCCodeConstant* _tmp1631_;
					ValaCCodeConstant* _tmp1632_;
					_tmp1631_ = vala_ccode_constant_new ("NULL");
					_tmp1632_ = _tmp1631_;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1632_);
					_vala_ccode_node_unref0 (_tmp1632_);
				}
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1634_ = deleg;
	if (_tmp1634_ != NULL) {
		ValaDelegate* _tmp1635_;
		ValaDataType* _tmp1636_;
		ValaDataType* _tmp1637_;
		_tmp1635_ = deleg;
		_tmp1636_ = vala_callable_get_return_type ((ValaCallable*) _tmp1635_);
		_tmp1637_ = _tmp1636_;
		_tmp1633_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1637_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1633_ = FALSE;
	}
	if (_tmp1633_) {
		ValaArrayType* array_type = NULL;
		ValaDelegate* _tmp1638_;
		ValaDataType* _tmp1639_;
		ValaDataType* _tmp1640_;
		ValaArrayType* _tmp1641_;
		_tmp1638_ = deleg;
		_tmp1639_ = vala_callable_get_return_type ((ValaCallable*) _tmp1638_);
		_tmp1640_ = _tmp1639_;
		_tmp1641_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1640_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1641_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1642_ = FALSE;
				_tmp1642_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1644_;
					gint _tmp1645_;
					gint _tmp1646_;
					ValaDelegate* _tmp1647_;
					if (!_tmp1642_) {
						gint _tmp1643_;
						_tmp1643_ = dim;
						dim = _tmp1643_ + 1;
					}
					_tmp1642_ = FALSE;
					_tmp1644_ = array_type;
					_tmp1645_ = vala_array_type_get_rank (_tmp1644_);
					_tmp1646_ = _tmp1645_;
					if (!(dim <= _tmp1646_)) {
						break;
					}
					_tmp1647_ = deleg;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1647_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1648_;
						ValaDataType* _tmp1649_;
						ValaLocalVariable* _tmp1650_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1651_;
						const gchar* _tmp1652_;
						const gchar* _tmp1653_;
						ValaCCodeExpression* _tmp1654_;
						ValaLocalVariable* _tmp1655_;
						ValaCCodeExpression* _tmp1656_;
						ValaCCodeExpression* _tmp1657_;
						ValaCCodeAssignment* _tmp1658_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1659_;
						ValaCCodeIdentifier* _tmp1660_;
						ValaCCodeFunctionCall* _tmp1661_;
						ValaCCodeFunctionCall* _tmp1662_;
						ValaCCodeFunctionCall* _tmp1663_;
						ValaCCodeExpression* _tmp1664_;
						ValaCCodeFunctionCall* _tmp1665_;
						_tmp1648_ = itype;
						_tmp1649_ = vala_data_type_get_return_type (_tmp1648_);
						_tmp1650_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1649_, TRUE, NULL, FALSE);
						temp_var = _tmp1650_;
						_tmp1651_ = temp_var;
						_tmp1652_ = vala_symbol_get_name ((ValaSymbol*) _tmp1651_);
						_tmp1653_ = _tmp1652_;
						_tmp1654_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1653_);
						temp_ref = _tmp1654_;
						_tmp1655_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1655_, FALSE);
						_tmp1656_ = temp_ref;
						_tmp1657_ = ccall_expr;
						_tmp1658_ = vala_ccode_assignment_new (_tmp1656_, _tmp1657_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1658_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1659_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1660_ = _tmp1659_;
						_tmp1661_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1660_);
						_tmp1662_ = _tmp1661_;
						_vala_ccode_node_unref0 (_tmp1660_);
						len_call = _tmp1662_;
						_tmp1663_ = len_call;
						_tmp1664_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1663_, _tmp1664_);
						_tmp1665_ = len_call;
						vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1665_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaDelegate* _tmp1666_;
						_tmp1666_ = deleg;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1666_)) {
							gchar* length_ctype = NULL;
							ValaDelegate* _tmp1667_;
							gchar* _tmp1668_;
							ValaLocalVariable* temp_var = NULL;
							const gchar* _tmp1669_;
							ValaCType* _tmp1670_;
							ValaCType* _tmp1671_;
							ValaLocalVariable* _tmp1672_;
							ValaLocalVariable* _tmp1673_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1674_;
							const gchar* _tmp1675_;
							const gchar* _tmp1676_;
							ValaCCodeExpression* _tmp1677_;
							ValaLocalVariable* _tmp1678_;
							ValaHashMap* _tmp1679_;
							ValaDelegate* _tmp1680_;
							ValaCCodeExpression* _tmp1681_;
							ValaCCodeUnaryExpression* _tmp1682_;
							ValaCCodeUnaryExpression* _tmp1683_;
							ValaCCodeExpression* _tmp1684_;
							_tmp1667_ = deleg;
							_tmp1668_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1667_);
							length_ctype = _tmp1668_;
							_tmp1669_ = length_ctype;
							_tmp1670_ = vala_ctype_new (_tmp1669_, "0");
							_tmp1671_ = _tmp1670_;
							_tmp1672_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1671_, TRUE, NULL, TRUE);
							_tmp1673_ = _tmp1672_;
							_vala_code_node_unref0 (_tmp1671_);
							temp_var = _tmp1673_;
							_tmp1674_ = temp_var;
							_tmp1675_ = vala_symbol_get_name ((ValaSymbol*) _tmp1674_);
							_tmp1676_ = _tmp1675_;
							_tmp1677_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1676_);
							temp_ref = _tmp1677_;
							_tmp1678_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1678_, FALSE);
							_tmp1679_ = out_arg_map;
							_tmp1680_ = deleg;
							_tmp1681_ = temp_ref;
							_tmp1682_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1681_);
							_tmp1683_ = _tmp1682_;
							vala_map_set ((ValaMap*) _tmp1679_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1680_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1683_);
							_vala_ccode_node_unref0 (_tmp1683_);
							_tmp1684_ = temp_ref;
							vala_append_array_length ((ValaExpression*) expr, _tmp1684_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
							_g_free0 (length_ctype);
						} else {
							ValaCCodeConstant* _tmp1685_;
							ValaCCodeConstant* _tmp1686_;
							_tmp1685_ = vala_ccode_constant_new ("-1");
							_tmp1686_ = _tmp1685_;
							vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1686_);
							_vala_ccode_node_unref0 (_tmp1686_);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1687_ = FALSE;
		gboolean _tmp1688_ = FALSE;
		ValaDelegate* _tmp1689_;
		_tmp1689_ = deleg;
		if (_tmp1689_ != NULL) {
			ValaDelegate* _tmp1690_;
			ValaDataType* _tmp1691_;
			ValaDataType* _tmp1692_;
			_tmp1690_ = deleg;
			_tmp1691_ = vala_callable_get_return_type ((ValaCallable*) _tmp1690_);
			_tmp1692_ = _tmp1691_;
			_tmp1688_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1692_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1688_ = FALSE;
		}
		if (_tmp1688_) {
			ValaDelegate* _tmp1693_;
			_tmp1693_ = deleg;
			_tmp1687_ = vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1693_);
		} else {
			_tmp1687_ = FALSE;
		}
		if (_tmp1687_) {
			ValaDelegateType* deleg_type = NULL;
			ValaDelegate* _tmp1694_;
			ValaDataType* _tmp1695_;
			ValaDataType* _tmp1696_;
			ValaDelegateType* _tmp1697_;
			ValaDelegateType* _tmp1698_;
			ValaDelegate* _tmp1699_;
			ValaDelegate* _tmp1700_;
			gboolean _tmp1701_;
			gboolean _tmp1702_;
			_tmp1694_ = deleg;
			_tmp1695_ = vala_callable_get_return_type ((ValaCallable*) _tmp1694_);
			_tmp1696_ = _tmp1695_;
			_tmp1697_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1696_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1697_;
			_tmp1698_ = deleg_type;
			_tmp1699_ = vala_delegate_type_get_delegate_symbol (_tmp1698_);
			_tmp1700_ = _tmp1699_;
			_tmp1701_ = vala_delegate_get_has_target (_tmp1700_);
			_tmp1702_ = _tmp1701_;
			if (_tmp1702_) {
				ValaLocalVariable* temp_var = NULL;
				ValaDataType* _tmp1703_;
				ValaLocalVariable* _tmp1704_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1705_;
				const gchar* _tmp1706_;
				const gchar* _tmp1707_;
				ValaCCodeExpression* _tmp1708_;
				ValaLocalVariable* _tmp1709_;
				ValaHashMap* _tmp1710_;
				ValaDelegate* _tmp1711_;
				ValaCCodeExpression* _tmp1712_;
				ValaCCodeUnaryExpression* _tmp1713_;
				ValaCCodeUnaryExpression* _tmp1714_;
				ValaCCodeExpression* _tmp1715_;
				ValaDelegateType* _tmp1716_;
				_tmp1703_ = ((ValaCCodeBaseModule*) self)->delegate_target_type;
				_tmp1704_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1703_, TRUE, NULL, TRUE);
				temp_var = _tmp1704_;
				_tmp1705_ = temp_var;
				_tmp1706_ = vala_symbol_get_name ((ValaSymbol*) _tmp1705_);
				_tmp1707_ = _tmp1706_;
				_tmp1708_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1707_);
				temp_ref = _tmp1708_;
				_tmp1709_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1709_, FALSE);
				_tmp1710_ = out_arg_map;
				_tmp1711_ = deleg;
				_tmp1712_ = temp_ref;
				_tmp1713_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1712_);
				_tmp1714_ = _tmp1713_;
				vala_map_set ((ValaMap*) _tmp1710_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1711_), FALSE)), (ValaCCodeExpression*) _tmp1714_);
				_vala_ccode_node_unref0 (_tmp1714_);
				_tmp1715_ = temp_ref;
				vala_set_delegate_target ((ValaExpression*) expr, _tmp1715_);
				_tmp1716_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1716_)) {
					ValaDelegateType* _tmp1717_;
					ValaLocalVariable* _tmp1718_;
					ValaLocalVariable* _tmp1719_;
					const gchar* _tmp1720_;
					const gchar* _tmp1721_;
					ValaCCodeExpression* _tmp1722_;
					ValaLocalVariable* _tmp1723_;
					ValaHashMap* _tmp1724_;
					ValaDelegate* _tmp1725_;
					ValaCCodeExpression* _tmp1726_;
					ValaCCodeUnaryExpression* _tmp1727_;
					ValaCCodeUnaryExpression* _tmp1728_;
					ValaCCodeExpression* _tmp1729_;
					_tmp1717_ = ((ValaCCodeBaseModule*) self)->delegate_target_destroy_type;
					_tmp1718_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1717_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1718_;
					_tmp1719_ = temp_var;
					_tmp1720_ = vala_symbol_get_name ((ValaSymbol*) _tmp1719_);
					_tmp1721_ = _tmp1720_;
					_tmp1722_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1721_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1722_;
					_tmp1723_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1723_, FALSE);
					_tmp1724_ = out_arg_map;
					_tmp1725_ = deleg;
					_tmp1726_ = temp_ref;
					_tmp1727_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1726_);
					_tmp1728_ = _tmp1727_;
					vala_map_set ((ValaMap*) _tmp1724_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1725_), FALSE)), (ValaCCodeExpression*) _tmp1728_);
					_vala_ccode_node_unref0 (_tmp1728_);
					_tmp1729_ = temp_ref;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, _tmp1729_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1731_ = m;
	if (_tmp1731_ != NULL) {
		ValaMethod* _tmp1732_;
		gboolean _tmp1733_;
		gboolean _tmp1734_;
		_tmp1732_ = m;
		_tmp1733_ = vala_method_get_coroutine (_tmp1732_);
		_tmp1734_ = _tmp1733_;
		_tmp1730_ = _tmp1734_;
	} else {
		_tmp1730_ = FALSE;
	}
	if (_tmp1730_) {
		gboolean _tmp1735_;
		gboolean _tmp1736_;
		_tmp1735_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) expr);
		_tmp1736_ = _tmp1735_;
		if (_tmp1736_) {
			ValaHashMap* _tmp1737_;
			ValaMethod* _tmp1738_;
			ValaMethod* _tmp1739_;
			gchar* _tmp1740_;
			gchar* _tmp1741_;
			ValaCCodeIdentifier* _tmp1742_;
			ValaCCodeIdentifier* _tmp1743_;
			ValaHashMap* _tmp1744_;
			ValaCCodeIdentifier* _tmp1745_;
			ValaCCodeIdentifier* _tmp1746_;
			_tmp1737_ = in_arg_map;
			_tmp1738_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp1739_ = _tmp1738_;
			_tmp1740_ = vala_ccode_base_module_generate_ready_function ((ValaCCodeBaseModule*) self, _tmp1739_);
			_tmp1741_ = _tmp1740_;
			_tmp1742_ = vala_ccode_identifier_new (_tmp1741_);
			_tmp1743_ = _tmp1742_;
			vala_map_set ((ValaMap*) _tmp1737_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1743_);
			_vala_ccode_node_unref0 (_tmp1743_);
			_g_free0 (_tmp1741_);
			_tmp1744_ = in_arg_map;
			_tmp1745_ = vala_ccode_identifier_new ("_data_");
			_tmp1746_ = _tmp1745_;
			vala_map_set ((ValaMap*) _tmp1744_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) _tmp1746_);
			_vala_ccode_node_unref0 (_tmp1746_);
		}
	}
	_tmp1747_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr);
	_tmp1748_ = _tmp1747_;
	if (_tmp1748_) {
		ValaCallable* _tmp1749_ = NULL;
		ValaMethod* _tmp1750_;
		ValaHashMap* _tmp1752_;
		ValaCCodeExpression* _tmp1753_;
		ValaCCodeExpression* _tmp1754_;
		ValaCCodeUnaryExpression* _tmp1755_;
		ValaCCodeUnaryExpression* _tmp1756_;
		vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
		_tmp1750_ = m;
		_tmp1749_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1750_, VALA_TYPE_CALLABLE, ValaCallable);
		if (_tmp1749_ == NULL) {
			ValaDelegate* _tmp1751_;
			_tmp1751_ = deleg;
			_tmp1749_ = (ValaCallable*) _tmp1751_;
		}
		_tmp1752_ = out_arg_map;
		_tmp1753_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
		_tmp1754_ = _tmp1753_;
		_tmp1755_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1754_);
		_tmp1756_ = _tmp1755_;
		vala_map_set ((ValaMap*) _tmp1752_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_error_pos (_tmp1749_), FALSE)), (ValaCCodeExpression*) _tmp1756_);
		_vala_ccode_node_unref0 (_tmp1756_);
		_vala_ccode_node_unref0 (_tmp1754_);
	} else {
		gboolean _tmp1757_ = FALSE;
		gboolean _tmp1758_ = FALSE;
		ValaMethod* _tmp1759_;
		_tmp1759_ = m;
		if (_tmp1759_ != NULL) {
			ValaMethod* _tmp1760_;
			_tmp1760_ = m;
			_tmp1758_ = vala_method_has_error_type_parameter (_tmp1760_);
		} else {
			_tmp1758_ = FALSE;
		}
		if (_tmp1758_) {
			ValaCCodeFunctionCall* _tmp1761_;
			ValaCCodeFunctionCall* _tmp1762_;
			_tmp1761_ = async_call;
			_tmp1762_ = ccall;
			_tmp1757_ = _tmp1761_ != _tmp1762_;
		} else {
			_tmp1757_ = FALSE;
		}
		if (_tmp1757_) {
			ValaHashMap* _tmp1763_;
			ValaMethod* _tmp1764_;
			ValaCCodeConstant* _tmp1765_;
			ValaCCodeConstant* _tmp1766_;
			_tmp1763_ = out_arg_map;
			_tmp1764_ = m;
			_tmp1765_ = vala_ccode_constant_new ("NULL");
			_tmp1766_ = _tmp1765_;
			vala_map_set ((ValaMap*) _tmp1763_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_error_pos ((ValaCallable*) _tmp1764_), FALSE)), (ValaCCodeExpression*) _tmp1766_);
			_vala_ccode_node_unref0 (_tmp1766_);
		}
	}
	if (ellipsis) {
		ValaMethod* _tmp1767_;
		_tmp1767_ = m;
		if (_tmp1767_ == NULL) {
			ValaHashMap* _tmp1768_;
			ValaCCodeConstant* _tmp1769_;
			ValaCCodeConstant* _tmp1770_;
			_tmp1768_ = in_arg_map;
			_tmp1769_ = vala_ccode_constant_new ("NULL");
			_tmp1770_ = _tmp1769_;
			vala_map_set ((ValaMap*) _tmp1768_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1770_);
			_vala_ccode_node_unref0 (_tmp1770_);
		} else {
			gboolean _tmp1771_ = FALSE;
			gboolean _tmp1772_ = FALSE;
			gboolean _tmp1773_ = FALSE;
			ValaMethod* _tmp1774_;
			gboolean _tmp1775_;
			gboolean _tmp1776_;
			_tmp1774_ = m;
			_tmp1775_ = vala_method_get_printf_format (_tmp1774_);
			_tmp1776_ = _tmp1775_;
			if (!_tmp1776_) {
				ValaMethod* _tmp1777_;
				gboolean _tmp1778_;
				gboolean _tmp1779_;
				_tmp1777_ = m;
				_tmp1778_ = vala_method_get_scanf_format (_tmp1777_);
				_tmp1779_ = _tmp1778_;
				_tmp1773_ = !_tmp1779_;
			} else {
				_tmp1773_ = FALSE;
			}
			if (_tmp1773_) {
				ValaMethod* _tmp1780_;
				gchar* _tmp1781_;
				gchar* _tmp1782_;
				_tmp1780_ = m;
				_tmp1781_ = vala_get_ccode_sentinel (_tmp1780_);
				_tmp1782_ = _tmp1781_;
				_tmp1772_ = g_strcmp0 (_tmp1782_, "") != 0;
				_g_free0 (_tmp1782_);
			} else {
				_tmp1772_ = FALSE;
			}
			if (_tmp1772_) {
				gboolean _tmp1783_;
				gboolean _tmp1784_;
				_tmp1783_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp1784_ = _tmp1783_;
				_tmp1771_ = !_tmp1784_;
			} else {
				_tmp1771_ = FALSE;
			}
			if (_tmp1771_) {
				ValaHashMap* _tmp1785_;
				ValaMethod* _tmp1786_;
				gchar* _tmp1787_;
				gchar* _tmp1788_;
				ValaCCodeConstant* _tmp1789_;
				ValaCCodeConstant* _tmp1790_;
				_tmp1785_ = in_arg_map;
				_tmp1786_ = m;
				_tmp1787_ = vala_get_ccode_sentinel (_tmp1786_);
				_tmp1788_ = _tmp1787_;
				_tmp1789_ = vala_ccode_constant_new (_tmp1788_);
				_tmp1790_ = _tmp1789_;
				vala_map_set ((ValaMap*) _tmp1785_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1790_);
				_vala_ccode_node_unref0 (_tmp1790_);
				_g_free0 (_tmp1788_);
			}
		}
	}
	_tmp1792_ = deleg;
	if (_tmp1792_ != NULL) {
		ValaDelegate* _tmp1793_;
		gboolean _tmp1794_;
		gboolean _tmp1795_;
		_tmp1793_ = deleg;
		_tmp1794_ = vala_delegate_get_has_target (_tmp1793_);
		_tmp1795_ = _tmp1794_;
		_tmp1791_ = _tmp1795_;
	} else {
		_tmp1791_ = FALSE;
	}
	if (_tmp1791_) {
		ValaCCodeExpression* delegate_target_destroy_notify = NULL;
		ValaHashMap* _tmp1796_;
		ValaDelegate* _tmp1797_;
		ValaExpression* _tmp1798_;
		ValaExpression* _tmp1799_;
		ValaCCodeExpression* _tmp1800_ = NULL;
		ValaCCodeExpression* _tmp1801_;
		ValaCCodeExpression* _tmp1802_;
		ValaHashMap* _tmp1803_;
		ValaDelegate* _tmp1804_;
		ValaExpression* _tmp1805_;
		ValaExpression* _tmp1806_;
		ValaCCodeExpression* _tmp1807_ = NULL;
		ValaCCodeExpression* _tmp1808_;
		ValaCCodeExpression* _tmp1809_;
		_tmp1796_ = in_arg_map;
		_tmp1797_ = deleg;
		_tmp1798_ = vala_method_call_get_call (expr);
		_tmp1799_ = _tmp1798_;
		_tmp1801_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1799_, &_tmp1800_);
		_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		delegate_target_destroy_notify = _tmp1800_;
		_tmp1802_ = _tmp1801_;
		vala_map_set ((ValaMap*) _tmp1796_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1797_), FALSE)), _tmp1802_);
		_vala_ccode_node_unref0 (_tmp1802_);
		_tmp1803_ = out_arg_map;
		_tmp1804_ = deleg;
		_tmp1805_ = vala_method_call_get_call (expr);
		_tmp1806_ = _tmp1805_;
		_tmp1808_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1806_, &_tmp1807_);
		_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		delegate_target_destroy_notify = _tmp1807_;
		_tmp1809_ = _tmp1808_;
		vala_map_set ((ValaMap*) _tmp1803_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1804_), FALSE)), _tmp1809_);
		_vala_ccode_node_unref0 (_tmp1809_);
		_vala_ccode_node_unref0 (delegate_target_destroy_notify);
	}
	_tmp1810_ = itype;
	_tmp1811_ = vala_data_type_get_return_type (_tmp1810_);
	return_result_via_out_param = vala_data_type_is_real_non_null_struct_type (_tmp1811_);
	_tmp1813_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1813_, VALA_TYPE_SIGNAL_TYPE)) {
		ValaDataType* _tmp1814_;
		ValaDataType* _tmp1815_;
		_tmp1814_ = itype;
		_tmp1815_ = vala_data_type_get_return_type (_tmp1814_);
		_tmp1812_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1815_, VALA_TYPE_VOID_TYPE);
	} else {
		_tmp1812_ = FALSE;
	}
	if (_tmp1812_) {
		ValaSignal* sig = NULL;
		ValaDataType* _tmp1816_;
		ValaSignal* _tmp1817_;
		ValaSignal* _tmp1818_;
		ValaSignal* _tmp1819_;
		gboolean _tmp1820_ = FALSE;
		gboolean _tmp1821_ = FALSE;
		ValaMemberAccess* _tmp1822_;
		_tmp1816_ = itype;
		_tmp1817_ = vala_signal_type_get_signal_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1816_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
		_tmp1818_ = _tmp1817_;
		_tmp1819_ = _vala_code_node_ref0 (_tmp1818_);
		sig = _tmp1819_;
		_tmp1822_ = ma;
		if (_tmp1822_ != NULL) {
			ValaMemberAccess* _tmp1823_;
			ValaExpression* _tmp1824_;
			ValaExpression* _tmp1825_;
			_tmp1823_ = ma;
			_tmp1824_ = vala_member_access_get_inner (_tmp1823_);
			_tmp1825_ = _tmp1824_;
			_tmp1821_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1825_, VALA_TYPE_BASE_ACCESS);
		} else {
			_tmp1821_ = FALSE;
		}
		if (_tmp1821_) {
			ValaSignal* _tmp1826_;
			gboolean _tmp1827_;
			gboolean _tmp1828_;
			_tmp1826_ = sig;
			_tmp1827_ = vala_signal_get_is_virtual (_tmp1826_);
			_tmp1828_ = _tmp1827_;
			_tmp1820_ = _tmp1828_;
		} else {
			_tmp1820_ = FALSE;
		}
		if (_tmp1820_) {
		} else {
			gboolean _tmp1829_ = FALSE;
			ValaSignal* _tmp1830_;
			_tmp1830_ = sig;
			if (!vala_get_ccode_has_emitter (_tmp1830_)) {
				_tmp1829_ = TRUE;
			} else {
				ValaMemberAccess* _tmp1831_;
				ValaSourceReference* _tmp1832_;
				ValaSourceReference* _tmp1833_;
				ValaSourceFile* _tmp1834_;
				ValaSourceFile* _tmp1835_;
				ValaSignal* _tmp1836_;
				ValaSourceReference* _tmp1837_;
				ValaSourceReference* _tmp1838_;
				ValaSourceFile* _tmp1839_;
				ValaSourceFile* _tmp1840_;
				_tmp1831_ = ma;
				_tmp1832_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1831_);
				_tmp1833_ = _tmp1832_;
				_tmp1834_ = vala_source_reference_get_file (_tmp1833_);
				_tmp1835_ = _tmp1834_;
				_tmp1836_ = sig;
				_tmp1837_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1836_);
				_tmp1838_ = _tmp1837_;
				_tmp1839_ = vala_source_reference_get_file (_tmp1838_);
				_tmp1840_ = _tmp1839_;
				_tmp1829_ = _tmp1835_ == _tmp1840_;
			}
			if (_tmp1829_) {
				return_result_via_out_param = TRUE;
			}
		}
		_vala_code_node_unref0 (sig);
	}
	_tmp1841_ = async_call;
	_tmp1842_ = ccall;
	if (_tmp1841_ == _tmp1842_) {
		return_result_via_out_param = FALSE;
	}
	out_param_ref = NULL;
	if (return_result_via_out_param) {
		ValaLocalVariable* out_param_var = NULL;
		ValaDataType* _tmp1843_;
		ValaDataType* _tmp1844_;
		ValaLocalVariable* _tmp1845_;
		ValaLocalVariable* _tmp1846_;
		const gchar* _tmp1847_;
		const gchar* _tmp1848_;
		ValaCCodeExpression* _tmp1849_;
		ValaLocalVariable* _tmp1850_;
		ValaHashMap* _tmp1851_;
		ValaCCodeExpression* _tmp1852_;
		ValaCCodeUnaryExpression* _tmp1853_;
		ValaCCodeUnaryExpression* _tmp1854_;
		_tmp1843_ = itype;
		_tmp1844_ = vala_data_type_get_return_type (_tmp1843_);
		_tmp1845_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1844_, TRUE, NULL, TRUE);
		out_param_var = _tmp1845_;
		_tmp1846_ = out_param_var;
		_tmp1847_ = vala_symbol_get_name ((ValaSymbol*) _tmp1846_);
		_tmp1848_ = _tmp1847_;
		_tmp1849_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1848_);
		_vala_ccode_node_unref0 (out_param_ref);
		out_param_ref = _tmp1849_;
		_tmp1850_ = out_param_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1850_, FALSE);
		_tmp1851_ = out_arg_map;
		_tmp1852_ = out_param_ref;
		_tmp1853_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1852_);
		_tmp1854_ = _tmp1853_;
		vala_map_set ((ValaMap*) _tmp1851_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -3, FALSE)), (ValaCCodeExpression*) _tmp1854_);
		_vala_ccode_node_unref0 (_tmp1854_);
		_vala_code_node_unref0 (out_param_var);
	}
	_tmp1855_ = async_call;
	_tmp1856_ = ccall;
	if (_tmp1855_ != _tmp1856_) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1867_;
			ValaHashMap* _tmp1868_;
			gpointer _tmp1869_;
			ValaCCodeExpression* _tmp1870_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1857_;
				ValaSet* _tmp1858_;
				ValaSet* _tmp1859_;
				ValaIterator* _tmp1860_;
				ValaIterator* _tmp1861_;
				_tmp1857_ = out_arg_map;
				_tmp1858_ = vala_map_get_keys ((ValaMap*) _tmp1857_);
				_tmp1859_ = _tmp1858_;
				_tmp1860_ = vala_iterable_iterator ((ValaIterable*) _tmp1859_);
				_tmp1861_ = _tmp1860_;
				_vala_iterable_unref0 (_tmp1859_);
				_pos_it = _tmp1861_;
				while (TRUE) {
					ValaIterator* _tmp1862_;
					gint pos = 0;
					ValaIterator* _tmp1863_;
					gpointer _tmp1864_;
					gboolean _tmp1865_ = FALSE;
					_tmp1862_ = _pos_it;
					if (!vala_iterator_next (_tmp1862_)) {
						break;
					}
					_tmp1863_ = _pos_it;
					_tmp1864_ = vala_iterator_get (_tmp1863_);
					pos = (gint) ((gintptr) _tmp1864_);
					if (pos > last_pos) {
						gboolean _tmp1866_ = FALSE;
						if (min_pos == -1) {
							_tmp1866_ = TRUE;
						} else {
							_tmp1866_ = pos < min_pos;
						}
						_tmp1865_ = _tmp1866_;
					} else {
						_tmp1865_ = FALSE;
					}
					if (_tmp1865_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1867_ = ccall;
			_tmp1868_ = out_arg_map;
			_tmp1869_ = vala_map_get ((ValaMap*) _tmp1868_, (gpointer) ((gintptr) min_pos));
			_tmp1870_ = (ValaCCodeExpression*) _tmp1869_;
			vala_ccode_function_call_add_argument (_tmp1867_, _tmp1870_);
			_vala_ccode_node_unref0 (_tmp1870_);
			last_pos = min_pos;
		}
	}
	_tmp1871_ = async_call;
	if (_tmp1871_ != NULL) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1882_;
			ValaHashMap* _tmp1883_;
			gpointer _tmp1884_;
			ValaCCodeExpression* _tmp1885_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1872_;
				ValaSet* _tmp1873_;
				ValaSet* _tmp1874_;
				ValaIterator* _tmp1875_;
				ValaIterator* _tmp1876_;
				_tmp1872_ = in_arg_map;
				_tmp1873_ = vala_map_get_keys ((ValaMap*) _tmp1872_);
				_tmp1874_ = _tmp1873_;
				_tmp1875_ = vala_iterable_iterator ((ValaIterable*) _tmp1874_);
				_tmp1876_ = _tmp1875_;
				_vala_iterable_unref0 (_tmp1874_);
				_pos_it = _tmp1876_;
				while (TRUE) {
					ValaIterator* _tmp1877_;
					gint pos = 0;
					ValaIterator* _tmp1878_;
					gpointer _tmp1879_;
					gboolean _tmp1880_ = FALSE;
					_tmp1877_ = _pos_it;
					if (!vala_iterator_next (_tmp1877_)) {
						break;
					}
					_tmp1878_ = _pos_it;
					_tmp1879_ = vala_iterator_get (_tmp1878_);
					pos = (gint) ((gintptr) _tmp1879_);
					if (pos > last_pos) {
						gboolean _tmp1881_ = FALSE;
						if (min_pos == -1) {
							_tmp1881_ = TRUE;
						} else {
							_tmp1881_ = pos < min_pos;
						}
						_tmp1880_ = _tmp1881_;
					} else {
						_tmp1880_ = FALSE;
					}
					if (_tmp1880_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1882_ = async_call;
			_tmp1883_ = in_arg_map;
			_tmp1884_ = vala_map_get ((ValaMap*) _tmp1883_, (gpointer) ((gintptr) min_pos));
			_tmp1885_ = (ValaCCodeExpression*) _tmp1884_;
			vala_ccode_function_call_add_argument (_tmp1882_, _tmp1885_);
			_vala_ccode_node_unref0 (_tmp1885_);
			last_pos = min_pos;
		}
	}
	_tmp1886_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) expr);
	_tmp1887_ = _tmp1886_;
	if (_tmp1887_) {
		gint state = 0;
		ValaCCodeBaseModuleEmitContext* _tmp1888_;
		gint _tmp1889_;
		ValaCCodeFunction* _tmp1890_;
		ValaCCodeFunction* _tmp1891_;
		ValaCCodeIdentifier* _tmp1892_;
		ValaCCodeIdentifier* _tmp1893_;
		ValaCCodeMemberAccess* _tmp1894_;
		ValaCCodeMemberAccess* _tmp1895_;
		gchar* _tmp1896_;
		gchar* _tmp1897_;
		ValaCCodeConstant* _tmp1898_;
		ValaCCodeConstant* _tmp1899_;
		ValaCCodeFunction* _tmp1900_;
		ValaCCodeFunction* _tmp1901_;
		ValaCCodeFunctionCall* _tmp1902_;
		ValaCCodeFunction* _tmp1903_;
		ValaCCodeFunction* _tmp1904_;
		ValaCCodeConstant* _tmp1905_;
		ValaCCodeConstant* _tmp1906_;
		ValaCCodeFunction* _tmp1907_;
		ValaCCodeFunction* _tmp1908_;
		gchar* _tmp1909_;
		gchar* _tmp1910_;
		_tmp1888_ = ((ValaCCodeBaseModule*) self)->emit_context;
		_tmp1889_ = _tmp1888_->next_coroutine_state;
		_tmp1888_->next_coroutine_state = _tmp1889_ + 1;
		state = _tmp1889_;
		_tmp1890_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1891_ = _tmp1890_;
		_tmp1892_ = vala_ccode_identifier_new ("_data_");
		_tmp1893_ = _tmp1892_;
		_tmp1894_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1893_, "_state_");
		_tmp1895_ = _tmp1894_;
		_tmp1896_ = g_strdup_printf ("%i", state);
		_tmp1897_ = _tmp1896_;
		_tmp1898_ = vala_ccode_constant_new (_tmp1897_);
		_tmp1899_ = _tmp1898_;
		vala_ccode_function_add_assignment (_tmp1891_, (ValaCCodeExpression*) _tmp1895_, (ValaCCodeExpression*) _tmp1899_);
		_vala_ccode_node_unref0 (_tmp1899_);
		_g_free0 (_tmp1897_);
		_vala_ccode_node_unref0 (_tmp1895_);
		_vala_ccode_node_unref0 (_tmp1893_);
		_tmp1900_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1901_ = _tmp1900_;
		_tmp1902_ = async_call;
		vala_ccode_function_add_expression (_tmp1901_, (ValaCCodeExpression*) _tmp1902_);
		_tmp1903_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1904_ = _tmp1903_;
		_tmp1905_ = vala_ccode_constant_new ("FALSE");
		_tmp1906_ = _tmp1905_;
		vala_ccode_function_add_return (_tmp1904_, (ValaCCodeExpression*) _tmp1906_);
		_vala_ccode_node_unref0 (_tmp1906_);
		_tmp1907_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1908_ = _tmp1907_;
		_tmp1909_ = g_strdup_printf ("_state_%d", state);
		_tmp1910_ = _tmp1909_;
		vala_ccode_function_add_label (_tmp1908_, _tmp1910_);
		_g_free0 (_tmp1910_);
	}
	_tmp1911_ = vala_method_call_get_is_assert (expr);
	_tmp1912_ = _tmp1911_;
	if (_tmp1912_) {
		gchar* message = NULL;
		ValaSourceReference* _tmp1913_;
		ValaSourceReference* _tmp1914_;
		ValaSourceLocation _tmp1915_ = {0};
		ValaSourceLocation _tmp1916_;
		gchar* _tmp1917_;
		ValaSourceReference* _tmp1918_;
		ValaSourceReference* _tmp1919_;
		ValaSourceLocation _tmp1920_ = {0};
		ValaSourceLocation _tmp1921_;
		gchar* _tmp1922_;
		ValaSourceReference* _tmp1923_;
		ValaSourceReference* _tmp1924_;
		ValaSourceLocation _tmp1925_ = {0};
		ValaSourceLocation _tmp1926_;
		gchar* _tmp1927_;
		gchar* _tmp1928_;
		ValaCCodeFunctionCall* _tmp1929_;
		ValaCCodeIdentifier* _tmp1930_;
		ValaCCodeIdentifier* _tmp1931_;
		ValaCCodeFunctionCall* _tmp1932_;
		const gchar* _tmp1933_;
		gchar* _tmp1934_;
		gchar* _tmp1935_;
		gchar* _tmp1936_;
		gchar* _tmp1937_;
		gchar* _tmp1938_;
		gchar* _tmp1939_;
		ValaCCodeConstant* _tmp1940_;
		ValaCCodeConstant* _tmp1941_;
		_tmp1913_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1914_ = _tmp1913_;
		vala_source_reference_get_begin (_tmp1914_, &_tmp1915_);
		_tmp1916_ = _tmp1915_;
		_tmp1917_ = _tmp1916_.pos;
		_tmp1918_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1919_ = _tmp1918_;
		vala_source_reference_get_end (_tmp1919_, &_tmp1920_);
		_tmp1921_ = _tmp1920_;
		_tmp1922_ = _tmp1921_.pos;
		_tmp1923_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1924_ = _tmp1923_;
		vala_source_reference_get_begin (_tmp1924_, &_tmp1925_);
		_tmp1926_ = _tmp1925_;
		_tmp1927_ = _tmp1926_.pos;
		_tmp1928_ = string_substring ((const gchar*) _tmp1917_, (glong) 0, (glong) ((gint) (_tmp1922_ - _tmp1927_)));
		message = _tmp1928_;
		_tmp1929_ = ccall;
		_tmp1930_ = vala_ccode_identifier_new ("_vala_assert");
		_tmp1931_ = _tmp1930_;
		vala_ccode_function_call_set_call (_tmp1929_, (ValaCCodeExpression*) _tmp1931_);
		_vala_ccode_node_unref0 (_tmp1931_);
		_tmp1932_ = ccall;
		_tmp1933_ = message;
		_tmp1934_ = string_replace (_tmp1933_, "\n", " ");
		_tmp1935_ = _tmp1934_;
		_tmp1936_ = g_strescape (_tmp1935_, "");
		_tmp1937_ = _tmp1936_;
		_tmp1938_ = g_strdup_printf ("\"%s\"", _tmp1937_);
		_tmp1939_ = _tmp1938_;
		_tmp1940_ = vala_ccode_constant_new (_tmp1939_);
		_tmp1941_ = _tmp1940_;
		vala_ccode_function_call_add_argument (_tmp1932_, (ValaCCodeExpression*) _tmp1941_);
		_vala_ccode_node_unref0 (_tmp1941_);
		_g_free0 (_tmp1939_);
		_g_free0 (_tmp1937_);
		_g_free0 (_tmp1935_);
		((ValaCCodeBaseModule*) self)->requires_assert = TRUE;
		_g_free0 (message);
	}
	collection_type = NULL;
	_tmp1943_ = ma;
	if (_tmp1943_ != NULL) {
		ValaMemberAccess* _tmp1944_;
		ValaExpression* _tmp1945_;
		ValaExpression* _tmp1946_;
		_tmp1944_ = ma;
		_tmp1945_ = vala_member_access_get_inner (_tmp1944_);
		_tmp1946_ = _tmp1945_;
		_tmp1942_ = _tmp1946_ != NULL;
	} else {
		_tmp1942_ = FALSE;
	}
	if (_tmp1942_) {
		ValaMemberAccess* _tmp1947_;
		ValaExpression* _tmp1948_;
		ValaExpression* _tmp1949_;
		ValaDataType* _tmp1950_;
		ValaDataType* _tmp1951_;
		_tmp1947_ = ma;
		_tmp1948_ = vala_member_access_get_inner (_tmp1947_);
		_tmp1949_ = _tmp1948_;
		_tmp1950_ = vala_expression_get_value_type (_tmp1949_);
		_tmp1951_ = _tmp1950_;
		collection_type = _tmp1951_;
	}
	_tmp1955_ = collection_type;
	if (_tmp1955_ != NULL) {
		gboolean _tmp1956_ = FALSE;
		gboolean _tmp1957_ = FALSE;
		ValaDataType* _tmp1958_;
		ValaTypeSymbol* _tmp1959_;
		ValaTypeSymbol* _tmp1960_;
		ValaClass* _tmp1961_;
		_tmp1958_ = collection_type;
		_tmp1959_ = vala_data_type_get_type_symbol (_tmp1958_);
		_tmp1960_ = _tmp1959_;
		_tmp1961_ = ((ValaCCodeBaseModule*) self)->glist_type;
		if (_tmp1960_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1961_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol)) {
			_tmp1957_ = TRUE;
		} else {
			ValaDataType* _tmp1962_;
			ValaTypeSymbol* _tmp1963_;
			ValaTypeSymbol* _tmp1964_;
			ValaClass* _tmp1965_;
			_tmp1962_ = collection_type;
			_tmp1963_ = vala_data_type_get_type_symbol (_tmp1962_);
			_tmp1964_ = _tmp1963_;
			_tmp1965_ = ((ValaCCodeBaseModule*) self)->gslist_type;
			_tmp1957_ = _tmp1964_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1965_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		}
		if (_tmp1957_) {
			_tmp1956_ = TRUE;
		} else {
			ValaDataType* _tmp1966_;
			ValaTypeSymbol* _tmp1967_;
			ValaTypeSymbol* _tmp1968_;
			ValaClass* _tmp1969_;
			_tmp1966_ = collection_type;
			_tmp1967_ = vala_data_type_get_type_symbol (_tmp1966_);
			_tmp1968_ = _tmp1967_;
			_tmp1969_ = ((ValaCCodeBaseModule*) self)->gqueue_type;
			_tmp1956_ = _tmp1968_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1969_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		}
		_tmp1954_ = _tmp1956_;
	} else {
		_tmp1954_ = FALSE;
	}
	if (_tmp1954_) {
		gboolean _tmp1970_ = FALSE;
		ValaMemberAccess* _tmp1971_;
		const gchar* _tmp1972_;
		const gchar* _tmp1973_;
		_tmp1971_ = ma;
		_tmp1972_ = vala_member_access_get_member_name (_tmp1971_);
		_tmp1973_ = _tmp1972_;
		if (g_strcmp0 (_tmp1973_, "remove") == 0) {
			_tmp1970_ = TRUE;
		} else {
			ValaMemberAccess* _tmp1974_;
			const gchar* _tmp1975_;
			const gchar* _tmp1976_;
			_tmp1974_ = ma;
			_tmp1975_ = vala_member_access_get_member_name (_tmp1974_);
			_tmp1976_ = _tmp1975_;
			_tmp1970_ = g_strcmp0 (_tmp1976_, "remove_all") == 0;
		}
		_tmp1953_ = _tmp1970_;
	} else {
		_tmp1953_ = FALSE;
	}
	if (_tmp1953_) {
		ValaDataType* _tmp1977_;
		ValaCodeContext* _tmp1978_;
		ValaCodeContext* _tmp1979_;
		_tmp1977_ = collection_type;
		_tmp1978_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp1979_ = _tmp1978_;
		_tmp1952_ = vala_data_type_check_type_arguments (_tmp1977_, _tmp1979_, FALSE);
	} else {
		_tmp1952_ = FALSE;
	}
	if (_tmp1952_) {
		ValaMethod* remove_method = NULL;
		ValaDataType* _tmp1980_;
		ValaTypeSymbol* _tmp1981_;
		ValaTypeSymbol* _tmp1982_;
		ValaScope* _tmp1983_;
		ValaScope* _tmp1984_;
		ValaMemberAccess* _tmp1985_;
		const gchar* _tmp1986_;
		const gchar* _tmp1987_;
		gchar* _tmp1988_;
		gchar* _tmp1989_;
		ValaSymbol* _tmp1990_;
		ValaMethod* _tmp1991_;
		ValaDataType* type_arg = NULL;
		ValaDataType* _tmp1992_;
		ValaList* _tmp1993_;
		gpointer _tmp1994_;
		gboolean _tmp1995_ = FALSE;
		ValaMethod* _tmp1996_;
		_tmp1980_ = collection_type;
		_tmp1981_ = vala_data_type_get_type_symbol (_tmp1980_);
		_tmp1982_ = _tmp1981_;
		_tmp1983_ = vala_symbol_get_scope ((ValaSymbol*) _tmp1982_);
		_tmp1984_ = _tmp1983_;
		_tmp1985_ = ma;
		_tmp1986_ = vala_member_access_get_member_name (_tmp1985_);
		_tmp1987_ = _tmp1986_;
		_tmp1988_ = g_strconcat (_tmp1987_, "_full", NULL);
		_tmp1989_ = _tmp1988_;
		_tmp1990_ = vala_scope_lookup (_tmp1984_, _tmp1989_);
		_tmp1991_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1990_, VALA_TYPE_METHOD, ValaMethod);
		_g_free0 (_tmp1989_);
		remove_method = _tmp1991_;
		_tmp1992_ = collection_type;
		_tmp1993_ = vala_data_type_get_type_arguments (_tmp1992_);
		_tmp1994_ = vala_list_get (_tmp1993_, 0);
		type_arg = (ValaDataType*) _tmp1994_;
		_tmp1996_ = remove_method;
		if (_tmp1996_ != NULL) {
			ValaDataType* _tmp1997_;
			_tmp1997_ = type_arg;
			_tmp1995_ = vala_ccode_base_module_requires_destroy (_tmp1997_);
		} else {
			_tmp1995_ = FALSE;
		}
		if (_tmp1995_) {
			ValaMethod* _tmp1998_;
			ValaCCodeFunctionCall* _tmp2000_;
			ValaMethod* _tmp2001_;
			gchar* _tmp2002_;
			gchar* _tmp2003_;
			ValaCCodeIdentifier* _tmp2004_;
			ValaCCodeIdentifier* _tmp2005_;
			ValaCCodeFunctionCall* _tmp2006_;
			ValaDataType* _tmp2007_;
			ValaCCodeExpression* _tmp2008_;
			ValaCCodeExpression* _tmp2009_;
			_tmp1998_ = remove_method;
			if (vala_ccode_base_module_add_generated_external_symbol ((ValaCCodeBaseModule*) self, (ValaSymbol*) _tmp1998_)) {
				ValaMethod* _tmp1999_;
				_tmp1999_ = remove_method;
				vala_code_visitor_visit_method ((ValaCodeVisitor*) self, _tmp1999_);
			}
			_tmp2000_ = ccall;
			_tmp2001_ = remove_method;
			_tmp2002_ = vala_get_ccode_name ((ValaCodeNode*) _tmp2001_);
			_tmp2003_ = _tmp2002_;
			_tmp2004_ = vala_ccode_identifier_new (_tmp2003_);
			_tmp2005_ = _tmp2004_;
			vala_ccode_function_call_set_call (_tmp2000_, (ValaCCodeExpression*) _tmp2005_);
			_vala_ccode_node_unref0 (_tmp2005_);
			_g_free0 (_tmp2003_);
			_tmp2006_ = ccall;
			_tmp2007_ = type_arg;
			_tmp2008_ = vala_ccode_base_module_get_destroy0_func_expression ((ValaCCodeBaseModule*) self, _tmp2007_, FALSE);
			_tmp2009_ = _tmp2008_;
			vala_ccode_function_call_add_argument (_tmp2006_, _tmp2009_);
			_vala_ccode_node_unref0 (_tmp2009_);
		}
		_vala_code_node_unref0 (type_arg);
		_vala_code_node_unref0 (remove_method);
	}
	if (return_result_via_out_param) {
		ValaCCodeFunction* _tmp2010_;
		ValaCCodeFunction* _tmp2011_;
		ValaCCodeExpression* _tmp2012_;
		ValaCCodeExpression* _tmp2013_;
		ValaCCodeExpression* _tmp2014_;
		_tmp2010_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2011_ = _tmp2010_;
		_tmp2012_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp2011_, _tmp2012_);
		_tmp2013_ = out_param_ref;
		_tmp2014_ = _vala_ccode_node_ref0 (_tmp2013_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = _tmp2014_;
	}
	_tmp2017_ = m;
	if (_tmp2017_ != NULL) {
		ValaMethod* _tmp2018_;
		ValaMemberBinding _tmp2019_;
		ValaMemberBinding _tmp2020_;
		_tmp2018_ = m;
		_tmp2019_ = vala_method_get_binding (_tmp2018_);
		_tmp2020_ = _tmp2019_;
		_tmp2016_ = _tmp2020_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2016_ = FALSE;
	}
	if (_tmp2016_) {
		ValaMethod* _tmp2021_;
		gboolean _tmp2022_;
		gboolean _tmp2023_;
		_tmp2021_ = m;
		_tmp2022_ = vala_method_get_returns_modified_pointer (_tmp2021_);
		_tmp2023_ = _tmp2022_;
		_tmp2015_ = _tmp2023_;
	} else {
		_tmp2015_ = FALSE;
	}
	if (_tmp2015_) {
		gboolean _tmp2024_ = FALSE;
		gboolean _tmp2025_ = FALSE;
		ValaMemberAccess* _tmp2026_;
		_tmp2026_ = ma;
		if (_tmp2026_ != NULL) {
			ValaMemberAccess* _tmp2027_;
			ValaExpression* _tmp2028_;
			ValaExpression* _tmp2029_;
			ValaSymbol* _tmp2030_;
			ValaSymbol* _tmp2031_;
			_tmp2027_ = ma;
			_tmp2028_ = vala_member_access_get_inner (_tmp2027_);
			_tmp2029_ = _tmp2028_;
			_tmp2030_ = vala_expression_get_symbol_reference (_tmp2029_);
			_tmp2031_ = _tmp2030_;
			_tmp2025_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2031_, VALA_TYPE_PROPERTY);
		} else {
			_tmp2025_ = FALSE;
		}
		if (_tmp2025_) {
			ValaMemberAccess* _tmp2032_;
			ValaExpression* _tmp2033_;
			ValaExpression* _tmp2034_;
			_tmp2032_ = ma;
			_tmp2033_ = vala_member_access_get_inner (_tmp2032_);
			_tmp2034_ = _tmp2033_;
			_tmp2024_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2034_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp2024_ = FALSE;
		}
		if (_tmp2024_) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp2035_;
			ValaExpression* _tmp2036_;
			ValaExpression* _tmp2037_;
			ValaSymbol* _tmp2038_;
			ValaSymbol* _tmp2039_;
			ValaProperty* _tmp2040_;
			ValaProperty* _tmp2041_;
			ValaMemberAccess* _tmp2042_;
			ValaExpression* _tmp2043_;
			ValaExpression* _tmp2044_;
			ValaExpression* _tmp2045_;
			ValaExpression* _tmp2046_;
			ValaDataType* _tmp2047_;
			ValaDataType* _tmp2048_;
			ValaCCodeExpression* _tmp2049_;
			ValaGLibValue* _tmp2050_;
			ValaGLibValue* _tmp2051_;
			_tmp2035_ = ma;
			_tmp2036_ = vala_member_access_get_inner (_tmp2035_);
			_tmp2037_ = _tmp2036_;
			_tmp2038_ = vala_expression_get_symbol_reference (_tmp2037_);
			_tmp2039_ = _tmp2038_;
			_tmp2040_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2039_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp2040_;
			_tmp2041_ = prop;
			_tmp2042_ = ma;
			_tmp2043_ = vala_member_access_get_inner (_tmp2042_);
			_tmp2044_ = _tmp2043_;
			_tmp2045_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp2044_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp2046_ = _tmp2045_;
			_tmp2047_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp2048_ = _tmp2047_;
			_tmp2049_ = ccall_expr;
			_tmp2050_ = vala_glib_value_new (_tmp2048_, _tmp2049_, FALSE);
			_tmp2051_ = _tmp2050_;
			vala_ccode_base_module_store_property ((ValaCCodeBaseModule*) self, _tmp2041_, _tmp2046_, (ValaTargetValue*) _tmp2051_);
			_vala_target_value_unref0 (_tmp2051_);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = NULL;
			_vala_code_node_unref0 (prop);
		} else {
			ValaCCodeExpression* _tmp2052_;
			ValaCCodeExpression* _tmp2053_;
			ValaCCodeAssignment* _tmp2054_;
			_tmp2052_ = instance;
			_tmp2053_ = ccall_expr;
			_tmp2054_ = vala_ccode_assignment_new (_tmp2052_, _tmp2053_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = (ValaCCodeExpression*) _tmp2054_;
		}
	}
	_tmp2060_ = m;
	if (_tmp2060_ != NULL) {
		ValaMethod* _tmp2061_;
		_tmp2061_ = m;
		_tmp2059_ = vala_get_ccode_simple_generics (_tmp2061_);
	} else {
		_tmp2059_ = FALSE;
	}
	if (_tmp2059_) {
		ValaMethod* _tmp2062_;
		ValaDataType* _tmp2063_;
		ValaDataType* _tmp2064_;
		_tmp2062_ = m;
		_tmp2063_ = vala_callable_get_return_type ((ValaCallable*) _tmp2062_);
		_tmp2064_ = _tmp2063_;
		_tmp2058_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2064_, VALA_TYPE_GENERIC_TYPE);
	} else {
		_tmp2058_ = FALSE;
	}
	if (_tmp2058_) {
		ValaDataType* _tmp2065_;
		ValaDataType* _tmp2066_;
		_tmp2065_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp2066_ = _tmp2065_;
		_tmp2057_ = vala_data_type_is_real_struct_type (_tmp2066_);
	} else {
		_tmp2057_ = FALSE;
	}
	if (_tmp2057_) {
		ValaDataType* _tmp2067_;
		ValaDataType* _tmp2068_;
		gboolean _tmp2069_;
		gboolean _tmp2070_;
		_tmp2067_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp2068_ = _tmp2067_;
		_tmp2069_ = vala_data_type_get_nullable (_tmp2068_);
		_tmp2070_ = _tmp2069_;
		_tmp2056_ = !_tmp2070_;
	} else {
		_tmp2056_ = FALSE;
	}
	if (_tmp2056_) {
		ValaDataType* _tmp2071_;
		ValaDataType* _tmp2072_;
		_tmp2071_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp2072_ = _tmp2071_;
		_tmp2055_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp2072_, VALA_TYPE_POINTER_TYPE);
	} else {
		_tmp2055_ = FALSE;
	}
	if (_tmp2055_) {
		ValaCCodeExpression* _tmp2073_;
		ValaCCodeParenthesizedExpression* _tmp2074_;
		ValaCCodeParenthesizedExpression* _tmp2075_;
		ValaCCodeUnaryExpression* _tmp2076_;
		_tmp2073_ = ccall_expr;
		_tmp2074_ = vala_ccode_parenthesized_expression_new (_tmp2073_);
		_tmp2075_ = _tmp2074_;
		_tmp2076_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) _tmp2075_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp2076_;
		_vala_ccode_node_unref0 (_tmp2075_);
	}
	_tmp2079_ = m;
	if (_tmp2079_ != NULL) {
		ValaMethod* _tmp2080_;
		gchar* _tmp2081_;
		gchar* _tmp2082_;
		_tmp2080_ = m;
		_tmp2081_ = vala_get_ccode_type ((ValaCodeNode*) _tmp2080_);
		_tmp2082_ = _tmp2081_;
		_tmp2078_ = _tmp2082_ != NULL;
		_g_free0 (_tmp2082_);
	} else {
		_tmp2078_ = FALSE;
	}
	if (_tmp2078_) {
		ValaMethod* _tmp2083_;
		gchar* _tmp2084_;
		gchar* _tmp2085_;
		ValaMethod* _tmp2086_;
		ValaDataType* _tmp2087_;
		ValaDataType* _tmp2088_;
		gchar* _tmp2089_;
		gchar* _tmp2090_;
		_tmp2083_ = m;
		_tmp2084_ = vala_get_ccode_type ((ValaCodeNode*) _tmp2083_);
		_tmp2085_ = _tmp2084_;
		_tmp2086_ = m;
		_tmp2087_ = vala_callable_get_return_type ((ValaCallable*) _tmp2086_);
		_tmp2088_ = _tmp2087_;
		_tmp2089_ = vala_get_ccode_name ((ValaCodeNode*) _tmp2088_);
		_tmp2090_ = _tmp2089_;
		_tmp2077_ = g_strcmp0 (_tmp2085_, _tmp2090_) != 0;
		_g_free0 (_tmp2090_);
		_g_free0 (_tmp2085_);
	} else {
		_tmp2077_ = FALSE;
	}
	if (_tmp2077_) {
		ValaCCodeExpression* _tmp2091_;
		ValaMethod* _tmp2092_;
		ValaDataType* _tmp2093_;
		ValaDataType* _tmp2094_;
		gchar* _tmp2095_;
		gchar* _tmp2096_;
		ValaCCodeCastExpression* _tmp2097_;
		_tmp2091_ = ccall_expr;
		_tmp2092_ = m;
		_tmp2093_ = vala_callable_get_return_type ((ValaCallable*) _tmp2092_);
		_tmp2094_ = _tmp2093_;
		_tmp2095_ = vala_get_ccode_name ((ValaCodeNode*) _tmp2094_);
		_tmp2096_ = _tmp2095_;
		_tmp2097_ = vala_ccode_cast_expression_new (_tmp2091_, _tmp2096_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp2097_;
		_g_free0 (_tmp2096_);
	}
	_tmp2098_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2098_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaIterator* arg_it = NULL;
		ValaList* _tmp2099_;
		ValaIterator* _tmp2100_;
		ValaIterator* _tmp2101_;
		ValaCCodeExpression* new_size = NULL;
		ValaIterator* _tmp2102_;
		gpointer _tmp2103_;
		ValaExpression* _tmp2104_;
		ValaCCodeExpression* _tmp2105_;
		ValaCCodeExpression* _tmp2106_;
		ValaCCodeExpression* _tmp2107_;
		ValaLocalVariable* temp_decl = NULL;
		ValaDataType* _tmp2108_;
		ValaLocalVariable* _tmp2109_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp2110_;
		const gchar* _tmp2111_;
		const gchar* _tmp2112_;
		ValaCCodeExpression* _tmp2113_;
		ValaLocalVariable* _tmp2114_;
		ValaCCodeFile* _tmp2115_;
		ValaCCodeExpression* clen = NULL;
		ValaMemberAccess* _tmp2116_;
		ValaExpression* _tmp2117_;
		ValaExpression* _tmp2118_;
		ValaCCodeExpression* _tmp2119_;
		ValaCCodeExpression* celems = NULL;
		ValaMemberAccess* _tmp2120_;
		ValaExpression* _tmp2121_;
		ValaExpression* _tmp2122_;
		ValaCCodeExpression* _tmp2123_;
		ValaCCodeExpression* _tmp2124_;
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp2125_;
		ValaExpression* _tmp2126_;
		ValaExpression* _tmp2127_;
		ValaDataType* _tmp2128_;
		ValaDataType* _tmp2129_;
		ValaArrayType* _tmp2130_;
		ValaCCodeIdentifier* csizeof = NULL;
		ValaArrayType* _tmp2131_;
		ValaDataType* _tmp2132_;
		ValaDataType* _tmp2133_;
		gchar* _tmp2134_;
		gchar* _tmp2135_;
		gchar* _tmp2136_;
		gchar* _tmp2137_;
		ValaCCodeIdentifier* _tmp2138_;
		ValaCCodeIdentifier* _tmp2139_;
		ValaCCodeBinaryExpression* cdelta = NULL;
		ValaCCodeExpression* _tmp2140_;
		ValaCCodeExpression* _tmp2141_;
		ValaCCodeBinaryExpression* _tmp2142_;
		ValaCCodeBinaryExpression* ccheck = NULL;
		ValaCCodeExpression* _tmp2143_;
		ValaCCodeExpression* _tmp2144_;
		ValaCCodeBinaryExpression* _tmp2145_;
		ValaCCodeFunctionCall* czero = NULL;
		ValaCCodeIdentifier* _tmp2146_;
		ValaCCodeIdentifier* _tmp2147_;
		ValaCCodeFunctionCall* _tmp2148_;
		ValaCCodeFunctionCall* _tmp2149_;
		ValaCCodeFunctionCall* _tmp2150_;
		ValaCCodeExpression* _tmp2151_;
		ValaCCodeExpression* _tmp2152_;
		ValaCCodeBinaryExpression* _tmp2153_;
		ValaCCodeBinaryExpression* _tmp2154_;
		ValaCCodeFunctionCall* _tmp2155_;
		ValaCCodeConstant* _tmp2156_;
		ValaCCodeConstant* _tmp2157_;
		ValaCCodeFunctionCall* _tmp2158_;
		ValaCCodeIdentifier* _tmp2159_;
		ValaCCodeBinaryExpression* _tmp2160_;
		ValaCCodeBinaryExpression* _tmp2161_;
		ValaCCodeBinaryExpression* _tmp2162_;
		ValaCCodeFunction* _tmp2163_;
		ValaCCodeFunction* _tmp2164_;
		ValaCCodeExpression* _tmp2165_;
		ValaCCodeExpression* _tmp2166_;
		ValaCCodeFunction* _tmp2167_;
		ValaCCodeFunction* _tmp2168_;
		ValaCCodeExpression* _tmp2169_;
		ValaCCodeFunction* _tmp2170_;
		ValaCCodeFunction* _tmp2171_;
		ValaCCodeBinaryExpression* _tmp2172_;
		ValaCCodeFunctionCall* _tmp2173_;
		ValaCCodeConstant* _tmp2174_;
		ValaCCodeConstant* _tmp2175_;
		ValaCCodeConditionalExpression* _tmp2176_;
		ValaCCodeConditionalExpression* _tmp2177_;
		ValaCCodeFunction* _tmp2178_;
		ValaCCodeFunction* _tmp2179_;
		ValaMemberAccess* _tmp2180_;
		ValaExpression* _tmp2181_;
		ValaExpression* _tmp2182_;
		ValaCCodeExpression* _tmp2183_;
		ValaCCodeExpression* _tmp2184_;
		ValaCCodeExpression* _tmp2185_;
		ValaSymbol* array_var = NULL;
		ValaMemberAccess* _tmp2186_;
		ValaExpression* _tmp2187_;
		ValaExpression* _tmp2188_;
		ValaSymbol* _tmp2189_;
		ValaSymbol* _tmp2190_;
		ValaSymbol* _tmp2191_;
		gboolean _tmp2192_ = FALSE;
		gboolean _tmp2193_ = FALSE;
		ValaSymbol* _tmp2194_;
		_tmp2099_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) expr);
		_tmp2100_ = vala_iterable_iterator ((ValaIterable*) _tmp2099_);
		arg_it = _tmp2100_;
		_tmp2101_ = arg_it;
		vala_iterator_next (_tmp2101_);
		_tmp2102_ = arg_it;
		_tmp2103_ = vala_iterator_get (_tmp2102_);
		_tmp2104_ = (ValaExpression*) _tmp2103_;
		_tmp2105_ = vala_get_cvalue (_tmp2104_);
		_tmp2106_ = _vala_ccode_node_ref0 (_tmp2105_);
		_tmp2107_ = _tmp2106_;
		_vala_code_node_unref0 (_tmp2104_);
		new_size = _tmp2107_;
		_tmp2108_ = ((ValaCCodeBaseModule*) self)->int_type;
		_tmp2109_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp2108_, TRUE, NULL, FALSE);
		temp_decl = _tmp2109_;
		_tmp2110_ = temp_decl;
		_tmp2111_ = vala_symbol_get_name ((ValaSymbol*) _tmp2110_);
		_tmp2112_ = _tmp2111_;
		_tmp2113_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp2112_);
		temp_ref = _tmp2113_;
		_tmp2114_ = temp_decl;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp2114_, FALSE);
		_tmp2115_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp2115_, "string.h", FALSE);
		_tmp2116_ = ma;
		_tmp2117_ = vala_member_access_get_inner (_tmp2116_);
		_tmp2118_ = _tmp2117_;
		_tmp2119_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp2118_, 1);
		clen = _tmp2119_;
		_tmp2120_ = ma;
		_tmp2121_ = vala_member_access_get_inner (_tmp2120_);
		_tmp2122_ = _tmp2121_;
		_tmp2123_ = vala_get_cvalue (_tmp2122_);
		_tmp2124_ = _vala_ccode_node_ref0 (_tmp2123_);
		celems = _tmp2124_;
		_tmp2125_ = ma;
		_tmp2126_ = vala_member_access_get_inner (_tmp2125_);
		_tmp2127_ = _tmp2126_;
		_tmp2128_ = vala_expression_get_value_type (_tmp2127_);
		_tmp2129_ = _tmp2128_;
		_tmp2130_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2129_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp2130_;
		_tmp2131_ = array_type;
		_tmp2132_ = vala_array_type_get_element_type (_tmp2131_);
		_tmp2133_ = _tmp2132_;
		_tmp2134_ = vala_get_ccode_name ((ValaCodeNode*) _tmp2133_);
		_tmp2135_ = _tmp2134_;
		_tmp2136_ = g_strdup_printf ("sizeof (%s)", _tmp2135_);
		_tmp2137_ = _tmp2136_;
		_tmp2138_ = vala_ccode_identifier_new (_tmp2137_);
		_tmp2139_ = _tmp2138_;
		_g_free0 (_tmp2137_);
		_g_free0 (_tmp2135_);
		csizeof = _tmp2139_;
		_tmp2140_ = temp_ref;
		_tmp2141_ = clen;
		_tmp2142_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, _tmp2140_, _tmp2141_);
		cdelta = _tmp2142_;
		_tmp2143_ = temp_ref;
		_tmp2144_ = clen;
		_tmp2145_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, _tmp2143_, _tmp2144_);
		ccheck = _tmp2145_;
		_tmp2146_ = vala_ccode_identifier_new ("memset");
		_tmp2147_ = _tmp2146_;
		_tmp2148_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2147_);
		_tmp2149_ = _tmp2148_;
		_vala_ccode_node_unref0 (_tmp2147_);
		czero = _tmp2149_;
		_tmp2150_ = czero;
		_tmp2151_ = celems;
		_tmp2152_ = clen;
		_tmp2153_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp2151_, _tmp2152_);
		_tmp2154_ = _tmp2153_;
		vala_ccode_function_call_add_argument (_tmp2150_, (ValaCCodeExpression*) _tmp2154_);
		_vala_ccode_node_unref0 (_tmp2154_);
		_tmp2155_ = czero;
		_tmp2156_ = vala_ccode_constant_new ("0");
		_tmp2157_ = _tmp2156_;
		vala_ccode_function_call_add_argument (_tmp2155_, (ValaCCodeExpression*) _tmp2157_);
		_vala_ccode_node_unref0 (_tmp2157_);
		_tmp2158_ = czero;
		_tmp2159_ = csizeof;
		_tmp2160_ = cdelta;
		_tmp2161_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp2159_, (ValaCCodeExpression*) _tmp2160_);
		_tmp2162_ = _tmp2161_;
		vala_ccode_function_call_add_argument (_tmp2158_, (ValaCCodeExpression*) _tmp2162_);
		_vala_ccode_node_unref0 (_tmp2162_);
		_tmp2163_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2164_ = _tmp2163_;
		_tmp2165_ = temp_ref;
		_tmp2166_ = new_size;
		vala_ccode_function_add_assignment (_tmp2164_, _tmp2165_, _tmp2166_);
		_tmp2167_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2168_ = _tmp2167_;
		_tmp2169_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp2168_, _tmp2169_);
		_tmp2170_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2171_ = _tmp2170_;
		_tmp2172_ = ccheck;
		_tmp2173_ = czero;
		_tmp2174_ = vala_ccode_constant_new ("NULL");
		_tmp2175_ = _tmp2174_;
		_tmp2176_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp2172_, (ValaCCodeExpression*) _tmp2173_, (ValaCCodeExpression*) _tmp2175_);
		_tmp2177_ = _tmp2176_;
		vala_ccode_function_add_expression (_tmp2171_, (ValaCCodeExpression*) _tmp2177_);
		_vala_ccode_node_unref0 (_tmp2177_);
		_vala_ccode_node_unref0 (_tmp2175_);
		_tmp2178_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2179_ = _tmp2178_;
		_tmp2180_ = ma;
		_tmp2181_ = vala_member_access_get_inner (_tmp2180_);
		_tmp2182_ = _tmp2181_;
		_tmp2183_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp2182_, 1);
		_tmp2184_ = _tmp2183_;
		_tmp2185_ = temp_ref;
		vala_ccode_function_add_assignment (_tmp2179_, _tmp2184_, _tmp2185_);
		_vala_ccode_node_unref0 (_tmp2184_);
		_tmp2186_ = ma;
		_tmp2187_ = vala_member_access_get_inner (_tmp2186_);
		_tmp2188_ = _tmp2187_;
		_tmp2189_ = vala_expression_get_symbol_reference (_tmp2188_);
		_tmp2190_ = _tmp2189_;
		_tmp2191_ = _vala_code_node_ref0 (_tmp2190_);
		array_var = _tmp2191_;
		_tmp2194_ = array_var;
		if (_tmp2194_ != NULL) {
			ValaSymbol* _tmp2195_;
			_tmp2195_ = array_var;
			_tmp2193_ = vala_symbol_is_internal_symbol (_tmp2195_);
		} else {
			_tmp2193_ = FALSE;
		}
		if (_tmp2193_) {
			gboolean _tmp2196_ = FALSE;
			ValaSymbol* _tmp2197_;
			_tmp2197_ = array_var;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2197_, VALA_TYPE_LOCAL_VARIABLE)) {
				_tmp2196_ = TRUE;
			} else {
				ValaSymbol* _tmp2198_;
				_tmp2198_ = array_var;
				_tmp2196_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2198_, VALA_TYPE_FIELD);
			}
			_tmp2192_ = _tmp2196_;
		} else {
			_tmp2192_ = FALSE;
		}
		if (_tmp2192_) {
			ValaCCodeFunction* _tmp2199_;
			ValaCCodeFunction* _tmp2200_;
			ValaMemberAccess* _tmp2201_;
			ValaExpression* _tmp2202_;
			ValaExpression* _tmp2203_;
			ValaTargetValue* _tmp2204_;
			ValaTargetValue* _tmp2205_;
			ValaCCodeExpression* _tmp2206_;
			ValaCCodeExpression* _tmp2207_;
			_tmp2199_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp2200_ = _tmp2199_;
			_tmp2201_ = ma;
			_tmp2202_ = vala_member_access_get_inner (_tmp2201_);
			_tmp2203_ = _tmp2202_;
			_tmp2204_ = vala_expression_get_target_value (_tmp2203_);
			_tmp2205_ = _tmp2204_;
			_tmp2206_ = vala_get_array_size_cvalue (_tmp2205_);
			_tmp2207_ = temp_ref;
			vala_ccode_function_add_assignment (_tmp2200_, _tmp2206_, _tmp2207_);
		}
		_vala_code_node_unref0 (array_var);
		_vala_ccode_node_unref0 (czero);
		_vala_ccode_node_unref0 (ccheck);
		_vala_ccode_node_unref0 (cdelta);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
		_vala_ccode_node_unref0 (celems);
		_vala_ccode_node_unref0 (clen);
		_vala_ccode_node_unref0 (temp_ref);
		_vala_code_node_unref0 (temp_decl);
		_vala_ccode_node_unref0 (new_size);
		_vala_iterator_unref0 (arg_it);
		_vala_ccode_node_unref0 (out_param_ref);
		_vala_iterator_unref0 (params_it);
		_vala_ccode_node_unref0 (instance);
		_vala_ccode_node_unref0 (ccall_expr);
		_vala_map_unref0 (out_arg_map);
		_vala_map_unref0 (in_arg_map);
		_vala_code_node_unref0 (itype);
		_vala_code_node_unref0 (ma);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (deleg);
		_vala_code_node_unref0 (m);
		_vala_ccode_node_unref0 (finish_call);
		_vala_ccode_node_unref0 (async_call);
		_vala_ccode_node_unref0 (ccall);
		return;
	}
	_tmp2209_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
	_tmp2210_ = _tmp2209_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2210_, VALA_TYPE_EXPRESSION_STATEMENT)) {
		ValaDataType* _tmp2211_;
		ValaDataType* _tmp2212_;
		_tmp2211_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp2212_ = _tmp2211_;
		_tmp2208_ = !vala_data_type_is_disposable (_tmp2212_);
	} else {
		_tmp2208_ = FALSE;
	}
	if (_tmp2208_) {
		gboolean _tmp2213_ = FALSE;
		ValaCCodeExpression* _tmp2214_;
		_tmp2214_ = ccall_expr;
		if (_tmp2214_ != NULL) {
			_tmp2213_ = !return_result_via_out_param;
		} else {
			_tmp2213_ = FALSE;
		}
		if (_tmp2213_) {
			ValaCCodeFunction* _tmp2215_;
			ValaCCodeFunction* _tmp2216_;
			ValaCCodeExpression* _tmp2217_;
			_tmp2215_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp2216_ = _tmp2215_;
			_tmp2217_ = ccall_expr;
			vala_ccode_function_add_expression (_tmp2216_, _tmp2217_);
		}
	} else {
		ValaDataType* result_type = NULL;
		ValaDataType* _tmp2218_;
		ValaDataType* _tmp2219_;
		ValaDataType* _tmp2220_;
		gboolean _tmp2221_ = FALSE;
		ValaDataType* _tmp2222_;
		ValaDataType* _tmp2223_;
		gboolean _tmp2276_ = FALSE;
		ValaMethod* _tmp2277_;
		_tmp2218_ = itype;
		_tmp2219_ = vala_data_type_get_return_type (_tmp2218_);
		_tmp2220_ = _vala_code_node_ref0 (_tmp2219_);
		result_type = _tmp2220_;
		_tmp2222_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
		_tmp2223_ = _tmp2222_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2223_, VALA_TYPE_GENERIC_TYPE)) {
			ValaDataType* _tmp2224_;
			ValaDataType* _tmp2225_;
			_tmp2224_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp2225_ = _tmp2224_;
			_tmp2221_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp2225_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp2221_ = FALSE;
		}
		if (_tmp2221_) {
			ValaTypeParameter* type_parameter = NULL;
			ValaDataType* _tmp2226_;
			ValaDataType* _tmp2227_;
			ValaTypeParameter* _tmp2228_;
			ValaTypeParameter* _tmp2229_;
			ValaTypeParameter* _tmp2230_;
			ValaStruct* st = NULL;
			ValaTypeParameter* _tmp2231_;
			ValaSymbol* _tmp2232_;
			ValaSymbol* _tmp2233_;
			ValaSymbol* _tmp2234_;
			ValaSymbol* _tmp2235_;
			ValaStruct* _tmp2236_;
			gboolean _tmp2237_ = FALSE;
			ValaTypeParameter* _tmp2238_;
			ValaSymbol* _tmp2239_;
			ValaSymbol* _tmp2240_;
			ValaTypeSymbol* _tmp2241_;
			gboolean _tmp2250_ = FALSE;
			gboolean _tmp2251_ = FALSE;
			ValaStruct* _tmp2252_;
			_tmp2226_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
			_tmp2227_ = _tmp2226_;
			_tmp2228_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp2227_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
			_tmp2229_ = _tmp2228_;
			_tmp2230_ = _vala_code_node_ref0 (_tmp2229_);
			type_parameter = _tmp2230_;
			_tmp2231_ = type_parameter;
			_tmp2232_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2231_);
			_tmp2233_ = _tmp2232_;
			_tmp2234_ = vala_symbol_get_parent_symbol (_tmp2233_);
			_tmp2235_ = _tmp2234_;
			_tmp2236_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2235_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp2235_) : NULL);
			st = _tmp2236_;
			_tmp2238_ = type_parameter;
			_tmp2239_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2238_);
			_tmp2240_ = _tmp2239_;
			_tmp2241_ = ((ValaCCodeBaseModule*) self)->garray_type;
			if (_tmp2240_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp2241_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				_tmp2237_ = TRUE;
			} else {
				gboolean _tmp2242_ = FALSE;
				ValaStruct* _tmp2243_;
				_tmp2243_ = st;
				if (_tmp2243_ != NULL) {
					ValaStruct* _tmp2244_;
					gchar* _tmp2245_;
					gchar* _tmp2246_;
					_tmp2244_ = st;
					_tmp2245_ = vala_get_ccode_name ((ValaCodeNode*) _tmp2244_);
					_tmp2246_ = _tmp2245_;
					_tmp2242_ = g_strcmp0 (_tmp2246_, "va_list") == 0;
					_g_free0 (_tmp2246_);
				} else {
					_tmp2242_ = FALSE;
				}
				_tmp2237_ = _tmp2242_;
			}
			if (_tmp2237_) {
				ValaDataType* _tmp2247_;
				ValaDataType* _tmp2248_;
				ValaDataType* _tmp2249_;
				_tmp2247_ = vala_expression_get_value_type ((ValaExpression*) expr);
				_tmp2248_ = _tmp2247_;
				_tmp2249_ = _vala_code_node_ref0 (_tmp2248_);
				_vala_code_node_unref0 (result_type);
				result_type = _tmp2249_;
			}
			_tmp2252_ = st;
			if (_tmp2252_ != NULL) {
				ValaStruct* _tmp2253_;
				gchar* _tmp2254_;
				gchar* _tmp2255_;
				_tmp2253_ = st;
				_tmp2254_ = vala_get_ccode_name ((ValaCodeNode*) _tmp2253_);
				_tmp2255_ = _tmp2254_;
				_tmp2251_ = g_strcmp0 (_tmp2255_, "va_list") == 0;
				_g_free0 (_tmp2255_);
			} else {
				_tmp2251_ = FALSE;
			}
			if (_tmp2251_) {
				ValaMemberAccess* _tmp2256_;
				const gchar* _tmp2257_;
				const gchar* _tmp2258_;
				_tmp2256_ = ma;
				_tmp2257_ = vala_member_access_get_member_name (_tmp2256_);
				_tmp2258_ = _tmp2257_;
				_tmp2250_ = g_strcmp0 (_tmp2258_, "arg") == 0;
			} else {
				_tmp2250_ = FALSE;
			}
			if (_tmp2250_) {
				gboolean _tmp2259_ = FALSE;
				ValaDataType* _tmp2260_;
				_tmp2260_ = result_type;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2260_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDataType* _tmp2261_;
					ValaDelegate* _tmp2262_;
					ValaDelegate* _tmp2263_;
					gboolean _tmp2264_;
					gboolean _tmp2265_;
					_tmp2261_ = result_type;
					_tmp2262_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp2261_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
					_tmp2263_ = _tmp2262_;
					_tmp2264_ = vala_delegate_get_has_target (_tmp2263_);
					_tmp2265_ = _tmp2264_;
					_tmp2259_ = _tmp2265_;
				} else {
					_tmp2259_ = FALSE;
				}
				if (_tmp2259_) {
					ValaGLibValue* arg_value = NULL;
					ValaTargetValue* _tmp2266_;
					ValaTargetValue* _tmp2267_;
					ValaGLibValue* _tmp2268_;
					ValaCCodeExpression* _tmp2269_;
					ValaGLibValue* _tmp2272_;
					ValaCCodeExpression* _tmp2273_;
					vala_set_cvalue ((ValaExpression*) expr, NULL);
					_tmp2266_ = vala_expression_get_target_value ((ValaExpression*) expr);
					_tmp2267_ = _tmp2266_;
					arg_value = G_TYPE_CHECK_INSTANCE_CAST (_tmp2267_, VALA_TYPE_GLIB_VALUE, ValaGLibValue);
					_tmp2268_ = arg_value;
					_tmp2269_ = _tmp2268_->delegate_target_cvalue;
					if (_tmp2269_ == NULL) {
						ValaGLibValue* _tmp2270_;
						ValaCCodeConstant* _tmp2271_;
						_tmp2270_ = arg_value;
						_tmp2271_ = vala_ccode_constant_new ("NULL");
						_vala_ccode_node_unref0 (_tmp2270_->delegate_target_cvalue);
						_tmp2270_->delegate_target_cvalue = (ValaCCodeExpression*) _tmp2271_;
					}
					_tmp2272_ = arg_value;
					_tmp2273_ = _tmp2272_->delegate_target_destroy_notify_cvalue;
					if (_tmp2273_ == NULL) {
						ValaGLibValue* _tmp2274_;
						ValaCCodeConstant* _tmp2275_;
						_tmp2274_ = arg_value;
						_tmp2275_ = vala_ccode_constant_new ("NULL");
						_vala_ccode_node_unref0 (_tmp2274_->delegate_target_destroy_notify_cvalue);
						_tmp2274_->delegate_target_destroy_notify_cvalue = (ValaCCodeExpression*) _tmp2275_;
					}
				}
			}
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (type_parameter);
		}
		_tmp2277_ = m;
		if (_tmp2277_ != NULL) {
			ValaMethod* _tmp2278_;
			_tmp2278_ = m;
			_tmp2276_ = vala_method_get_format_arg_index (_tmp2278_) >= 0;
		} else {
			_tmp2276_ = FALSE;
		}
		if (_tmp2276_) {
			ValaCCodeExpression* _tmp2279_;
			_tmp2279_ = ccall_expr;
			vala_set_cvalue ((ValaExpression*) expr, _tmp2279_);
		} else {
			gboolean _tmp2280_ = FALSE;
			ValaMethod* _tmp2281_;
			_tmp2281_ = m;
			if (_tmp2281_ != NULL) {
				ValaMethod* _tmp2282_;
				_tmp2282_ = m;
				_tmp2280_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp2282_, "CCode", "use_inplace", FALSE);
			} else {
				_tmp2280_ = FALSE;
			}
			if (_tmp2280_) {
				ValaCCodeExpression* _tmp2283_;
				_tmp2283_ = ccall_expr;
				vala_set_cvalue ((ValaExpression*) expr, _tmp2283_);
			} else {
				gboolean _tmp2284_ = FALSE;
				gboolean _tmp2285_ = FALSE;
				if (!return_result_via_out_param) {
					_tmp2285_ = !vala_ccode_method_call_module_has_ref_out_argument (self, expr);
				} else {
					_tmp2285_ = FALSE;
				}
				if (_tmp2285_) {
					gboolean _tmp2286_ = FALSE;
					ValaDataType* _tmp2287_;
					_tmp2287_ = result_type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2287_, VALA_TYPE_VALUE_TYPE)) {
						ValaDataType* _tmp2288_;
						_tmp2288_ = result_type;
						_tmp2286_ = !vala_data_type_is_disposable (_tmp2288_);
					} else {
						_tmp2286_ = FALSE;
					}
					_tmp2284_ = _tmp2286_;
				} else {
					_tmp2284_ = FALSE;
				}
				if (_tmp2284_) {
					ValaCCodeExpression* _tmp2289_;
					_tmp2289_ = ccall_expr;
					vala_set_cvalue ((ValaExpression*) expr, _tmp2289_);
				} else {
					if (!return_result_via_out_param) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp2290_;
						ValaDataType* _tmp2291_;
						gboolean _tmp2292_;
						gboolean _tmp2293_;
						ValaLocalVariable* _tmp2294_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp2295_;
						const gchar* _tmp2296_;
						const gchar* _tmp2297_;
						ValaCCodeExpression* _tmp2298_;
						ValaLocalVariable* _tmp2299_;
						ValaCCodeFunction* _tmp2300_;
						ValaCCodeFunction* _tmp2301_;
						ValaCCodeExpression* _tmp2302_;
						ValaCCodeExpression* _tmp2303_;
						ValaCCodeExpression* _tmp2304_;
						ValaTargetValue* _tmp2305_;
						ValaTargetValue* _tmp2306_;
						_tmp2290_ = result_type;
						_tmp2291_ = result_type;
						_tmp2292_ = vala_data_type_get_value_owned (_tmp2291_);
						_tmp2293_ = _tmp2292_;
						_tmp2294_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp2290_, _tmp2293_, NULL, FALSE);
						temp_var = _tmp2294_;
						_tmp2295_ = temp_var;
						_tmp2296_ = vala_symbol_get_name ((ValaSymbol*) _tmp2295_);
						_tmp2297_ = _tmp2296_;
						_tmp2298_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp2297_);
						temp_ref = _tmp2298_;
						_tmp2299_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp2299_, FALSE);
						_tmp2300_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp2301_ = _tmp2300_;
						_tmp2302_ = temp_ref;
						_tmp2303_ = ccall_expr;
						vala_ccode_function_add_assignment (_tmp2301_, _tmp2302_, _tmp2303_);
						_tmp2304_ = temp_ref;
						vala_set_cvalue ((ValaExpression*) expr, _tmp2304_);
						_tmp2305_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2306_ = _tmp2305_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2306_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaCCodeExpression* _tmp2307_;
						ValaTargetValue* _tmp2308_;
						ValaTargetValue* _tmp2309_;
						_tmp2307_ = ccall_expr;
						vala_set_cvalue ((ValaExpression*) expr, _tmp2307_);
						_tmp2308_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2309_ = _tmp2308_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2309_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
					}
				}
			}
		}
		_vala_code_node_unref0 (result_type);
	}
	_tmp2310_ = params;
	_tmp2311_ = vala_iterable_iterator ((ValaIterable*) _tmp2310_);
	_vala_iterator_unref0 (params_it);
	params_it = _tmp2311_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2312_;
		gint _arg_size = 0;
		ValaList* _tmp2313_;
		gint _tmp2314_;
		gint _tmp2315_;
		gint _arg_index = 0;
		_tmp2312_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) expr);
		_arg_list = _tmp2312_;
		_tmp2313_ = _arg_list;
		_tmp2314_ = vala_collection_get_size ((ValaCollection*) _tmp2313_);
		_tmp2315_ = _tmp2314_;
		_arg_size = _tmp2315_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp2316_;
			gint _tmp2317_;
			ValaExpression* arg = NULL;
			ValaList* _tmp2318_;
			gpointer _tmp2319_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp2320_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp2323_;
			ValaUnaryExpression* _tmp2324_;
			gboolean _tmp2325_ = FALSE;
			ValaUnaryExpression* _tmp2326_;
			gboolean _tmp2384_ = FALSE;
			ValaUnaryExpression* _tmp2385_;
			ValaUnaryExpression* _tmp2389_;
			ValaExpression* _tmp2390_;
			ValaExpression* _tmp2391_;
			ValaDataType* _tmp2392_;
			ValaDataType* _tmp2393_;
			gboolean _tmp2403_ = FALSE;
			ValaMemberAccess* _tmp2404_;
			ValaSymbol* _tmp2405_;
			ValaSymbol* _tmp2406_;
			ValaUnaryExpression* _tmp2422_;
			ValaExpression* _tmp2423_;
			ValaExpression* _tmp2424_;
			ValaTargetValue* _tmp2425_;
			ValaTargetValue* _tmp2426_;
			ValaUnaryExpression* _tmp2427_;
			ValaTargetValue* _tmp2428_;
			ValaTargetValue* _tmp2429_;
			ValaUnaryExpression* _tmp2430_;
			ValaExpression* _tmp2431_;
			ValaExpression* _tmp2432_;
			ValaDataType* _tmp2433_;
			ValaDataType* _tmp2434_;
			ValaExpression* _tmp2435_;
			ValaTargetValue* _tmp2436_;
			ValaTargetValue* _tmp2437_;
			ValaSourceReference* _tmp2438_;
			ValaSourceReference* _tmp2439_;
			gboolean _tmp2440_ = FALSE;
			ValaParameter* _tmp2441_;
			_arg_index = _arg_index + 1;
			_tmp2316_ = _arg_index;
			_tmp2317_ = _arg_size;
			if (!(_tmp2316_ < _tmp2317_)) {
				break;
			}
			_tmp2318_ = _arg_list;
			_tmp2319_ = vala_list_get (_tmp2318_, _arg_index);
			arg = (ValaExpression*) _tmp2319_;
			param = NULL;
			_tmp2320_ = params_it;
			if (vala_iterator_next (_tmp2320_)) {
				ValaIterator* _tmp2321_;
				gpointer _tmp2322_;
				_tmp2321_ = params_it;
				_tmp2322_ = vala_iterator_get (_tmp2321_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp2322_;
			}
			_tmp2323_ = arg;
			_tmp2324_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2323_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp2323_) : NULL);
			unary = _tmp2324_;
			_tmp2326_ = unary;
			if (_tmp2326_ != NULL) {
				ValaUnaryExpression* _tmp2327_;
				ValaUnaryOperator _tmp2328_;
				ValaUnaryOperator _tmp2329_;
				_tmp2327_ = unary;
				_tmp2328_ = vala_unary_expression_get_operator (_tmp2327_);
				_tmp2329_ = _tmp2328_;
				_tmp2325_ = _tmp2329_ == VALA_UNARY_OPERATOR_REF;
			} else {
				_tmp2325_ = FALSE;
			}
			if (_tmp2325_) {
				gboolean _tmp2330_ = FALSE;
				gboolean _tmp2331_ = FALSE;
				gboolean _tmp2332_ = FALSE;
				gboolean _tmp2333_ = FALSE;
				ValaParameter* _tmp2334_;
				_tmp2334_ = param;
				if (_tmp2334_ != NULL) {
					ValaParameter* _tmp2335_;
					_tmp2335_ = param;
					_tmp2333_ = vala_get_ccode_array_length ((ValaCodeNode*) _tmp2335_);
				} else {
					_tmp2333_ = FALSE;
				}
				if (_tmp2333_) {
					ValaParameter* _tmp2336_;
					ValaDataType* _tmp2337_;
					ValaDataType* _tmp2338_;
					_tmp2336_ = param;
					_tmp2337_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2336_);
					_tmp2338_ = _tmp2337_;
					_tmp2332_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2338_, VALA_TYPE_ARRAY_TYPE);
				} else {
					_tmp2332_ = FALSE;
				}
				if (_tmp2332_) {
					ValaParameter* _tmp2339_;
					ValaDataType* _tmp2340_;
					ValaDataType* _tmp2341_;
					gboolean _tmp2342_;
					gboolean _tmp2343_;
					_tmp2339_ = param;
					_tmp2340_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2339_);
					_tmp2341_ = _tmp2340_;
					_tmp2342_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp2341_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp2343_ = _tmp2342_;
					_tmp2331_ = !_tmp2343_;
				} else {
					_tmp2331_ = FALSE;
				}
				if (_tmp2331_) {
					ValaParameter* _tmp2344_;
					ValaDataType* _tmp2345_;
					ValaDataType* _tmp2346_;
					gint _tmp2347_;
					gint _tmp2348_;
					_tmp2344_ = param;
					_tmp2345_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2344_);
					_tmp2346_ = _tmp2345_;
					_tmp2347_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp2346_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp2348_ = _tmp2347_;
					_tmp2330_ = _tmp2348_ == 1;
				} else {
					_tmp2330_ = FALSE;
				}
				if (_tmp2330_) {
					ValaVariable* array_var = NULL;
					ValaUnaryExpression* _tmp2349_;
					ValaExpression* _tmp2350_;
					ValaExpression* _tmp2351_;
					ValaSymbol* _tmp2352_;
					ValaSymbol* _tmp2353_;
					gboolean _tmp2354_ = FALSE;
					gboolean _tmp2355_ = FALSE;
					gboolean _tmp2356_ = FALSE;
					gboolean _tmp2357_ = FALSE;
					ValaVariable* _tmp2358_;
					_tmp2349_ = unary;
					_tmp2350_ = vala_unary_expression_get_inner (_tmp2349_);
					_tmp2351_ = _tmp2350_;
					_tmp2352_ = vala_expression_get_symbol_reference (_tmp2351_);
					_tmp2353_ = _tmp2352_;
					array_var = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2353_, VALA_TYPE_VARIABLE) ? ((ValaVariable*) _tmp2353_) : NULL;
					_tmp2358_ = array_var;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2358_, VALA_TYPE_LOCAL_VARIABLE)) {
						_tmp2357_ = TRUE;
					} else {
						ValaVariable* _tmp2359_;
						_tmp2359_ = array_var;
						_tmp2357_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2359_, VALA_TYPE_FIELD);
					}
					if (_tmp2357_) {
						ValaVariable* _tmp2360_;
						_tmp2360_ = array_var;
						_tmp2356_ = vala_symbol_is_internal_symbol ((ValaSymbol*) _tmp2360_);
					} else {
						_tmp2356_ = FALSE;
					}
					if (_tmp2356_) {
						ValaVariable* _tmp2361_;
						ValaDataType* _tmp2362_;
						ValaDataType* _tmp2363_;
						_tmp2361_ = array_var;
						_tmp2362_ = vala_variable_get_variable_type (_tmp2361_);
						_tmp2363_ = _tmp2362_;
						_tmp2355_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2363_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp2355_ = FALSE;
					}
					if (_tmp2355_) {
						ValaVariable* _tmp2364_;
						ValaDataType* _tmp2365_;
						ValaDataType* _tmp2366_;
						gboolean _tmp2367_;
						gboolean _tmp2368_;
						_tmp2364_ = array_var;
						_tmp2365_ = vala_variable_get_variable_type (_tmp2364_);
						_tmp2366_ = _tmp2365_;
						_tmp2367_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp2366_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp2368_ = _tmp2367_;
						_tmp2354_ = !_tmp2368_;
					} else {
						_tmp2354_ = FALSE;
					}
					if (_tmp2354_) {
						ValaCCodeFunction* _tmp2369_;
						ValaCCodeFunction* _tmp2370_;
						ValaUnaryExpression* _tmp2371_;
						ValaExpression* _tmp2372_;
						ValaExpression* _tmp2373_;
						ValaTargetValue* _tmp2374_;
						ValaTargetValue* _tmp2375_;
						ValaCCodeExpression* _tmp2376_;
						ValaUnaryExpression* _tmp2377_;
						ValaExpression* _tmp2378_;
						ValaExpression* _tmp2379_;
						ValaTargetValue* _tmp2380_;
						ValaTargetValue* _tmp2381_;
						ValaCCodeExpression* _tmp2382_;
						ValaCCodeExpression* _tmp2383_;
						_tmp2369_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp2370_ = _tmp2369_;
						_tmp2371_ = unary;
						_tmp2372_ = vala_unary_expression_get_inner (_tmp2371_);
						_tmp2373_ = _tmp2372_;
						_tmp2374_ = vala_expression_get_target_value (_tmp2373_);
						_tmp2375_ = _tmp2374_;
						_tmp2376_ = vala_get_array_size_cvalue (_tmp2375_);
						_tmp2377_ = unary;
						_tmp2378_ = vala_unary_expression_get_inner (_tmp2377_);
						_tmp2379_ = _tmp2378_;
						_tmp2380_ = vala_expression_get_target_value (_tmp2379_);
						_tmp2381_ = _tmp2380_;
						_tmp2382_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2381_, 1);
						_tmp2383_ = _tmp2382_;
						vala_ccode_function_add_assignment (_tmp2370_, _tmp2376_, _tmp2383_);
						_vala_ccode_node_unref0 (_tmp2383_);
					}
				}
			}
			_tmp2385_ = unary;
			if (_tmp2385_ == NULL) {
				_tmp2384_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp2386_;
				ValaUnaryOperator _tmp2387_;
				ValaUnaryOperator _tmp2388_;
				_tmp2386_ = unary;
				_tmp2387_ = vala_unary_expression_get_operator (_tmp2386_);
				_tmp2388_ = _tmp2387_;
				_tmp2384_ = _tmp2388_ != VALA_UNARY_OPERATOR_OUT;
			}
			if (_tmp2384_) {
				_vala_code_node_unref0 (unary);
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp2389_ = unary;
			_tmp2390_ = vala_unary_expression_get_inner (_tmp2389_);
			_tmp2391_ = _tmp2390_;
			_tmp2392_ = vala_expression_get_value_type (_tmp2391_);
			_tmp2393_ = _tmp2392_;
			if (vala_ccode_base_module_requires_destroy (_tmp2393_)) {
				ValaCCodeFunction* _tmp2394_;
				ValaCCodeFunction* _tmp2395_;
				ValaUnaryExpression* _tmp2396_;
				ValaExpression* _tmp2397_;
				ValaExpression* _tmp2398_;
				ValaTargetValue* _tmp2399_;
				ValaTargetValue* _tmp2400_;
				ValaCCodeExpression* _tmp2401_;
				ValaCCodeExpression* _tmp2402_;
				_tmp2394_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2395_ = _tmp2394_;
				_tmp2396_ = unary;
				_tmp2397_ = vala_unary_expression_get_inner (_tmp2396_);
				_tmp2398_ = _tmp2397_;
				_tmp2399_ = vala_expression_get_target_value (_tmp2398_);
				_tmp2400_ = _tmp2399_;
				_tmp2401_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, _tmp2400_, FALSE);
				_tmp2402_ = _tmp2401_;
				vala_ccode_function_add_expression (_tmp2395_, _tmp2402_);
				_vala_ccode_node_unref0 (_tmp2402_);
			}
			_tmp2404_ = ma;
			_tmp2405_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp2404_);
			_tmp2406_ = _tmp2405_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2406_, VALA_TYPE_DYNAMIC_METHOD)) {
				ValaUnaryExpression* _tmp2407_;
				ValaTargetValue* _tmp2408_;
				ValaTargetValue* _tmp2409_;
				ValaDataType* _tmp2410_;
				ValaDataType* _tmp2411_;
				_tmp2407_ = unary;
				_tmp2408_ = vala_expression_get_target_value ((ValaExpression*) _tmp2407_);
				_tmp2409_ = _tmp2408_;
				_tmp2410_ = vala_target_value_get_value_type (_tmp2409_);
				_tmp2411_ = _tmp2410_;
				_tmp2403_ = _tmp2411_ == NULL;
			} else {
				_tmp2403_ = FALSE;
			}
			if (_tmp2403_) {
				ValaUnaryExpression* _tmp2412_;
				ValaTargetValue* _tmp2413_;
				ValaTargetValue* _tmp2414_;
				ValaUnaryExpression* _tmp2415_;
				ValaExpression* _tmp2416_;
				ValaExpression* _tmp2417_;
				ValaDataType* _tmp2418_;
				ValaDataType* _tmp2419_;
				ValaDataType* _tmp2420_;
				ValaDataType* _tmp2421_;
				_tmp2412_ = unary;
				_tmp2413_ = vala_expression_get_target_value ((ValaExpression*) _tmp2412_);
				_tmp2414_ = _tmp2413_;
				_tmp2415_ = unary;
				_tmp2416_ = vala_unary_expression_get_inner (_tmp2415_);
				_tmp2417_ = _tmp2416_;
				_tmp2418_ = vala_expression_get_value_type (_tmp2417_);
				_tmp2419_ = _tmp2418_;
				_tmp2420_ = vala_data_type_copy (_tmp2419_);
				_tmp2421_ = _tmp2420_;
				vala_target_value_set_value_type (_tmp2414_, _tmp2421_);
				_vala_code_node_unref0 (_tmp2421_);
			}
			_tmp2422_ = unary;
			_tmp2423_ = vala_unary_expression_get_inner (_tmp2422_);
			_tmp2424_ = _tmp2423_;
			_tmp2425_ = vala_expression_get_target_value (_tmp2424_);
			_tmp2426_ = _tmp2425_;
			_tmp2427_ = unary;
			_tmp2428_ = vala_expression_get_target_value ((ValaExpression*) _tmp2427_);
			_tmp2429_ = _tmp2428_;
			_tmp2430_ = unary;
			_tmp2431_ = vala_unary_expression_get_inner (_tmp2430_);
			_tmp2432_ = _tmp2431_;
			_tmp2433_ = vala_expression_get_value_type (_tmp2432_);
			_tmp2434_ = _tmp2433_;
			_tmp2435_ = arg;
			_tmp2436_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, _tmp2429_, _tmp2434_, (ValaCodeNode*) _tmp2435_);
			_tmp2437_ = _tmp2436_;
			_tmp2438_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp2439_ = _tmp2438_;
			vala_ccode_base_module_store_value ((ValaCCodeBaseModule*) self, _tmp2426_, _tmp2437_, _tmp2439_);
			_vala_target_value_unref0 (_tmp2437_);
			_tmp2441_ = param;
			if (_tmp2441_ != NULL) {
				ValaParameter* _tmp2442_;
				_tmp2442_ = param;
				_tmp2440_ = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp2442_);
			} else {
				_tmp2440_ = FALSE;
			}
			if (_tmp2440_) {
				ValaCCodeFunctionCall* len_call = NULL;
				ValaCCodeIdentifier* _tmp2443_;
				ValaCCodeIdentifier* _tmp2444_;
				ValaCCodeFunctionCall* _tmp2445_;
				ValaCCodeFunctionCall* _tmp2446_;
				ValaCCodeFunctionCall* _tmp2447_;
				ValaUnaryExpression* _tmp2448_;
				ValaExpression* _tmp2449_;
				ValaExpression* _tmp2450_;
				ValaTargetValue* _tmp2451_;
				ValaTargetValue* _tmp2452_;
				ValaCCodeExpression* _tmp2453_;
				ValaCCodeFunction* _tmp2454_;
				ValaCCodeFunction* _tmp2455_;
				ValaUnaryExpression* _tmp2456_;
				ValaExpression* _tmp2457_;
				ValaExpression* _tmp2458_;
				ValaTargetValue* _tmp2459_;
				ValaTargetValue* _tmp2460_;
				ValaCCodeExpression* _tmp2461_;
				ValaCCodeExpression* _tmp2462_;
				ValaCCodeFunctionCall* _tmp2463_;
				((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
				_tmp2443_ = vala_ccode_identifier_new ("_vala_array_length");
				_tmp2444_ = _tmp2443_;
				_tmp2445_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2444_);
				_tmp2446_ = _tmp2445_;
				_vala_ccode_node_unref0 (_tmp2444_);
				len_call = _tmp2446_;
				_tmp2447_ = len_call;
				_tmp2448_ = unary;
				_tmp2449_ = vala_unary_expression_get_inner (_tmp2448_);
				_tmp2450_ = _tmp2449_;
				_tmp2451_ = vala_expression_get_target_value (_tmp2450_);
				_tmp2452_ = _tmp2451_;
				_tmp2453_ = vala_get_cvalue_ (_tmp2452_);
				vala_ccode_function_call_add_argument (_tmp2447_, _tmp2453_);
				_tmp2454_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2455_ = _tmp2454_;
				_tmp2456_ = unary;
				_tmp2457_ = vala_unary_expression_get_inner (_tmp2456_);
				_tmp2458_ = _tmp2457_;
				_tmp2459_ = vala_expression_get_target_value (_tmp2458_);
				_tmp2460_ = _tmp2459_;
				_tmp2461_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2460_, 1);
				_tmp2462_ = _tmp2461_;
				_tmp2463_ = len_call;
				vala_ccode_function_add_assignment (_tmp2455_, _tmp2462_, (ValaCCodeExpression*) _tmp2463_);
				_vala_ccode_node_unref0 (_tmp2462_);
				_vala_ccode_node_unref0 (len_call);
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp2466_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2466_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp2467_;
		ValaSymbol* _tmp2468_;
		ValaSymbol* _tmp2469_;
		_tmp2467_ = m;
		_tmp2468_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2467_);
		_tmp2469_ = _tmp2468_;
		_tmp2465_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2469_, VALA_TYPE_CLASS);
	} else {
		_tmp2465_ = FALSE;
	}
	if (_tmp2465_) {
		gboolean _tmp2470_ = FALSE;
		gboolean _tmp2471_ = FALSE;
		ValaClass* _tmp2472_;
		ValaClass* _tmp2473_;
		gboolean _tmp2474_;
		gboolean _tmp2475_;
		_tmp2472_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2473_ = _tmp2472_;
		_tmp2474_ = vala_class_get_is_compact (_tmp2473_);
		_tmp2475_ = _tmp2474_;
		if (_tmp2475_) {
			ValaClass* _tmp2476_;
			ValaClass* _tmp2477_;
			ValaClass* _tmp2478_;
			ValaClass* _tmp2479_;
			_tmp2476_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2477_ = _tmp2476_;
			_tmp2478_ = vala_class_get_base_class (_tmp2477_);
			_tmp2479_ = _tmp2478_;
			_tmp2471_ = _tmp2479_ != NULL;
		} else {
			_tmp2471_ = FALSE;
		}
		if (_tmp2471_) {
			_tmp2470_ = TRUE;
		} else {
			ValaClass* _tmp2480_;
			ValaClass* _tmp2481_;
			ValaClass* _tmp2482_;
			_tmp2480_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2481_ = _tmp2480_;
			_tmp2482_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			_tmp2470_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp2481_, (ValaTypeSymbol*) _tmp2482_);
		}
		_tmp2464_ = _tmp2470_;
	} else {
		_tmp2464_ = FALSE;
	}
	if (_tmp2464_) {
		ValaCCodeFunctionCall* cinitcall = NULL;
		ValaClass* _tmp2483_;
		ValaClass* _tmp2484_;
		gchar* _tmp2485_;
		gchar* _tmp2486_;
		gchar* _tmp2487_;
		gchar* _tmp2488_;
		ValaCCodeIdentifier* _tmp2489_;
		ValaCCodeIdentifier* _tmp2490_;
		ValaCCodeFunctionCall* _tmp2491_;
		ValaCCodeFunctionCall* _tmp2492_;
		ValaCCodeFunctionCall* _tmp2493_;
		ValaCCodeExpression* _tmp2494_;
		ValaCCodeExpression* _tmp2495_;
		ValaClass* _tmp2496_;
		ValaClass* _tmp2497_;
		gboolean _tmp2498_;
		gboolean _tmp2499_;
		ValaCCodeFunction* _tmp2503_;
		ValaCCodeFunction* _tmp2504_;
		ValaCCodeFunctionCall* _tmp2505_;
		_tmp2483_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2484_ = _tmp2483_;
		_tmp2485_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp2484_, NULL);
		_tmp2486_ = _tmp2485_;
		_tmp2487_ = g_strdup_printf ("%s_instance_init", _tmp2486_);
		_tmp2488_ = _tmp2487_;
		_tmp2489_ = vala_ccode_identifier_new (_tmp2488_);
		_tmp2490_ = _tmp2489_;
		_tmp2491_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2490_);
		_tmp2492_ = _tmp2491_;
		_vala_ccode_node_unref0 (_tmp2490_);
		_g_free0 (_tmp2488_);
		_g_free0 (_tmp2486_);
		cinitcall = _tmp2492_;
		_tmp2493_ = cinitcall;
		_tmp2494_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp2495_ = _tmp2494_;
		vala_ccode_function_call_add_argument (_tmp2493_, _tmp2495_);
		_vala_ccode_node_unref0 (_tmp2495_);
		_tmp2496_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2497_ = _tmp2496_;
		_tmp2498_ = vala_class_get_is_compact (_tmp2497_);
		_tmp2499_ = _tmp2498_;
		if (!_tmp2499_) {
			ValaCCodeFunctionCall* _tmp2500_;
			ValaCCodeConstant* _tmp2501_;
			ValaCCodeConstant* _tmp2502_;
			_tmp2500_ = cinitcall;
			_tmp2501_ = vala_ccode_constant_new ("NULL");
			_tmp2502_ = _tmp2501_;
			vala_ccode_function_call_add_argument (_tmp2500_, (ValaCCodeExpression*) _tmp2502_);
			_vala_ccode_node_unref0 (_tmp2502_);
		}
		_tmp2503_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2504_ = _tmp2503_;
		_tmp2505_ = cinitcall;
		vala_ccode_function_add_expression (_tmp2504_, (ValaCCodeExpression*) _tmp2505_);
		_vala_ccode_node_unref0 (cinitcall);
	}
	_vala_ccode_node_unref0 (out_param_ref);
	_vala_iterator_unref0 (params_it);
	_vala_ccode_node_unref0 (instance);
	_vala_ccode_node_unref0 (ccall_expr);
	_vala_map_unref0 (out_arg_map);
	_vala_map_unref0 (in_arg_map);
	_vala_code_node_unref0 (itype);
	_vala_code_node_unref0 (ma);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (deleg);
	_vala_code_node_unref0 (m);
	_vala_ccode_node_unref0 (finish_call);
	_vala_ccode_node_unref0 (async_call);
	_vala_ccode_node_unref0 (ccall);
}

static gchar*
vala_ccode_method_call_module_generate_enum_to_string_function (ValaCCodeMethodCallModule* self,
                                                                ValaEnum* en)
{
	gchar* to_string_func = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCCodeFunction* function = NULL;
	const gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeBaseModuleEmitContext* _tmp13_;
	ValaCCodeBaseModuleEmitContext* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeFunction* _tmp46_;
	ValaCCodeFunction* _tmp47_;
	ValaCCodeFunction* _tmp48_;
	ValaCCodeFunction* _tmp49_;
	ValaCCodeConstant* _tmp50_;
	ValaCCodeConstant* _tmp51_;
	ValaCCodeFile* _tmp52_;
	ValaCCodeFunction* _tmp53_;
	ValaCCodeFile* _tmp54_;
	ValaCCodeFunction* _tmp55_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_%s_to_string", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	to_string_func = _tmp3_;
	_tmp4_ = to_string_func;
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, _tmp4_)) {
		result = to_string_func;
		return result;
	}
	_tmp5_ = to_string_func;
	_tmp6_ = vala_ccode_function_new (_tmp5_, "const char*");
	function = _tmp6_;
	_tmp7_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp7_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8_ = function;
	_tmp9_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_parameter_new ("value", _tmp10_);
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp8_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp14_ = _tmp13_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp14_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp14_);
	_tmp15_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_constant_new ("value");
	_tmp19_ = _tmp18_;
	vala_ccode_function_open_switch (_tmp17_, (ValaCCodeExpression*) _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	{
		ValaList* _enum_value_list = NULL;
		ValaList* _tmp20_;
		gint _enum_value_size = 0;
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _enum_value_index = 0;
		_tmp20_ = vala_enum_get_values (en);
		_enum_value_list = _tmp20_;
		_tmp21_ = _enum_value_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_enum_value_size = _tmp23_;
		_enum_value_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			ValaEnumValue* enum_value = NULL;
			ValaList* _tmp26_;
			gpointer _tmp27_;
			ValaCCodeFunction* _tmp28_;
			ValaCCodeFunction* _tmp29_;
			ValaEnumValue* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			ValaCCodeIdentifier* _tmp33_;
			ValaCCodeIdentifier* _tmp34_;
			ValaCCodeFunction* _tmp35_;
			ValaCCodeFunction* _tmp36_;
			ValaEnumValue* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			ValaCCodeConstant* _tmp44_;
			ValaCCodeConstant* _tmp45_;
			_enum_value_index = _enum_value_index + 1;
			_tmp24_ = _enum_value_index;
			_tmp25_ = _enum_value_size;
			if (!(_tmp24_ < _tmp25_)) {
				break;
			}
			_tmp26_ = _enum_value_list;
			_tmp27_ = vala_list_get (_tmp26_, _enum_value_index);
			enum_value = (ValaEnumValue*) _tmp27_;
			_tmp28_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp29_ = _tmp28_;
			_tmp30_ = enum_value;
			_tmp31_ = vala_get_ccode_name ((ValaCodeNode*) _tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = vala_ccode_identifier_new (_tmp32_);
			_tmp34_ = _tmp33_;
			vala_ccode_function_add_case (_tmp29_, (ValaCCodeExpression*) _tmp34_);
			_vala_ccode_node_unref0 (_tmp34_);
			_g_free0 (_tmp32_);
			_tmp35_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp36_ = _tmp35_;
			_tmp37_ = enum_value;
			_tmp38_ = vala_get_ccode_name ((ValaCodeNode*) _tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = g_strconcat ("\"", _tmp39_, NULL);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_strconcat (_tmp41_, "\"", NULL);
			_tmp43_ = _tmp42_;
			_tmp44_ = vala_ccode_constant_new (_tmp43_);
			_tmp45_ = _tmp44_;
			vala_ccode_function_add_return (_tmp36_, (ValaCCodeExpression*) _tmp45_);
			_vala_ccode_node_unref0 (_tmp45_);
			_g_free0 (_tmp43_);
			_g_free0 (_tmp41_);
			_g_free0 (_tmp39_);
			_vala_code_node_unref0 (enum_value);
		}
	}
	_tmp46_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp47_ = _tmp46_;
	vala_ccode_function_close (_tmp47_);
	_tmp48_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp49_ = _tmp48_;
	_tmp50_ = vala_ccode_constant_new ("NULL");
	_tmp51_ = _tmp50_;
	vala_ccode_function_add_return (_tmp49_, (ValaCCodeExpression*) _tmp51_);
	_vala_ccode_node_unref0 (_tmp51_);
	_tmp52_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp53_ = function;
	vala_ccode_file_add_function_declaration (_tmp52_, _tmp53_);
	_tmp54_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp55_ = function;
	vala_ccode_file_add_function (_tmp54_, _tmp55_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	result = to_string_func;
	_vala_ccode_node_unref0 (function);
	return result;
}

static gboolean
vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                    ValaMethodCall* c)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) c);
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* arg = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp8_;
			gboolean _tmp9_ = FALSE;
			ValaUnaryExpression* _tmp10_;
			_arg_index = _arg_index + 1;
			_tmp4_ = _arg_index;
			_tmp5_ = _arg_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _arg_list;
			_tmp7_ = vala_list_get (_tmp6_, _arg_index);
			arg = (ValaExpression*) _tmp7_;
			_tmp8_ = arg;
			unary = G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp8_) : NULL;
			_tmp10_ = unary;
			if (_tmp10_ != NULL) {
				gboolean _tmp11_ = FALSE;
				ValaUnaryExpression* _tmp12_;
				ValaUnaryOperator _tmp13_;
				ValaUnaryOperator _tmp14_;
				_tmp12_ = unary;
				_tmp13_ = vala_unary_expression_get_operator (_tmp12_);
				_tmp14_ = _tmp13_;
				if (_tmp14_ == VALA_UNARY_OPERATOR_OUT) {
					_tmp11_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp15_;
					ValaUnaryOperator _tmp16_;
					ValaUnaryOperator _tmp17_;
					_tmp15_ = unary;
					_tmp16_ = vala_unary_expression_get_operator (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp11_ = _tmp17_ == VALA_UNARY_OPERATOR_REF;
				}
				_tmp9_ = _tmp11_;
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				result = TRUE;
				_vala_code_node_unref0 (arg);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
	}
	result = FALSE;
	return result;
}

static gchar*
vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self)
{
	ValaCCodeFunction* function = NULL;
	ValaCCodeFunction* _tmp1_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeParameter* _tmp3_;
	ValaCCodeParameter* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeParameter* _tmp6_;
	ValaCCodeParameter* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeBaseModuleEmitContext* _tmp9_;
	ValaCCodeBaseModuleEmitContext* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	ValaCCodeFunction* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeVariableDeclarator* _tmp14_;
	ValaCCodeVariableDeclarator* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeVariableDeclarator* _tmp18_;
	ValaCCodeVariableDeclarator* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaCCodeVariableDeclarator* _tmp22_;
	ValaCCodeVariableDeclarator* _tmp23_;
	ValaCCodeFunctionCall* va_start = NULL;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeFunctionCall* _tmp26_;
	ValaCCodeFunctionCall* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	ValaCCodeIdentifier* _tmp29_;
	ValaCCodeIdentifier* _tmp30_;
	ValaCCodeFunctionCall* _tmp31_;
	ValaCCodeIdentifier* _tmp32_;
	ValaCCodeIdentifier* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaCCodeFunctionCall* _tmp36_;
	ValaCodeContext* _tmp37_;
	ValaCodeContext* _tmp38_;
	ValaProfile _tmp39_;
	ValaProfile _tmp40_;
	ValaCCodeFunctionCall* vsnprintf = NULL;
	ValaCCodeIdentifier* _tmp42_;
	ValaCCodeIdentifier* _tmp43_;
	ValaCCodeFunctionCall* _tmp44_;
	ValaCCodeFunctionCall* _tmp45_;
	ValaCCodeFunctionCall* _tmp46_;
	ValaCCodeConstant* _tmp47_;
	ValaCCodeConstant* _tmp48_;
	ValaCCodeFunctionCall* _tmp49_;
	ValaCCodeConstant* _tmp50_;
	ValaCCodeConstant* _tmp51_;
	ValaCCodeFunctionCall* _tmp52_;
	ValaCCodeIdentifier* _tmp53_;
	ValaCCodeIdentifier* _tmp54_;
	ValaCCodeFunctionCall* _tmp55_;
	ValaCCodeIdentifier* _tmp56_;
	ValaCCodeIdentifier* _tmp57_;
	ValaCCodeFunction* _tmp58_;
	ValaCCodeFunction* _tmp59_;
	ValaCCodeIdentifier* _tmp60_;
	ValaCCodeIdentifier* _tmp61_;
	ValaCCodeFunctionCall* _tmp62_;
	ValaCCodeConstant* _tmp63_;
	ValaCCodeConstant* _tmp64_;
	ValaCCodeBinaryExpression* _tmp65_;
	ValaCCodeBinaryExpression* _tmp66_;
	ValaCCodeFunctionCall* va_end = NULL;
	ValaCCodeIdentifier* _tmp67_;
	ValaCCodeIdentifier* _tmp68_;
	ValaCCodeFunctionCall* _tmp69_;
	ValaCCodeFunctionCall* _tmp70_;
	ValaCCodeFunctionCall* _tmp71_;
	ValaCCodeIdentifier* _tmp72_;
	ValaCCodeIdentifier* _tmp73_;
	ValaCCodeFunction* _tmp74_;
	ValaCCodeFunction* _tmp75_;
	ValaCCodeFunctionCall* _tmp76_;
	ValaCCodeFunctionCall* malloc = NULL;
	ValaCCodeIdentifier* _tmp77_;
	ValaCCodeIdentifier* _tmp78_;
	ValaCCodeFunctionCall* _tmp79_;
	ValaCCodeFunctionCall* _tmp80_;
	ValaCCodeFunctionCall* _tmp81_;
	ValaCCodeIdentifier* _tmp82_;
	ValaCCodeIdentifier* _tmp83_;
	ValaCCodeFunction* _tmp84_;
	ValaCCodeFunction* _tmp85_;
	ValaCCodeIdentifier* _tmp86_;
	ValaCCodeIdentifier* _tmp87_;
	ValaCCodeFunctionCall* _tmp88_;
	ValaCCodeIdentifier* _tmp89_;
	ValaCCodeIdentifier* _tmp90_;
	ValaCCodeFunctionCall* _tmp91_;
	ValaCCodeFunctionCall* _tmp92_;
	ValaCCodeIdentifier* _tmp93_;
	ValaCCodeIdentifier* _tmp94_;
	ValaCCodeFunctionCall* _tmp95_;
	ValaCCodeIdentifier* _tmp96_;
	ValaCCodeIdentifier* _tmp97_;
	ValaCCodeFunction* _tmp98_;
	ValaCCodeFunction* _tmp99_;
	ValaCCodeFunctionCall* _tmp100_;
	ValaCCodeIdentifier* _tmp101_;
	ValaCCodeIdentifier* _tmp102_;
	ValaCCodeFunctionCall* _tmp103_;
	ValaCCodeFunctionCall* _tmp104_;
	ValaCCodeIdentifier* _tmp105_;
	ValaCCodeIdentifier* _tmp106_;
	ValaCCodeFunctionCall* _tmp107_;
	ValaCCodeIdentifier* _tmp108_;
	ValaCCodeIdentifier* _tmp109_;
	ValaCCodeFunctionCall* _tmp110_;
	ValaCCodeIdentifier* _tmp111_;
	ValaCCodeIdentifier* _tmp112_;
	ValaCCodeFunctionCall* _tmp113_;
	ValaCCodeIdentifier* _tmp114_;
	ValaCCodeIdentifier* _tmp115_;
	ValaCCodeFunction* _tmp116_;
	ValaCCodeFunction* _tmp117_;
	ValaCCodeFunctionCall* _tmp118_;
	ValaCCodeIdentifier* _tmp119_;
	ValaCCodeIdentifier* _tmp120_;
	ValaCCodeFunctionCall* _tmp121_;
	ValaCCodeFunctionCall* _tmp122_;
	ValaCCodeIdentifier* _tmp123_;
	ValaCCodeIdentifier* _tmp124_;
	ValaCCodeFunction* _tmp125_;
	ValaCCodeFunction* _tmp126_;
	ValaCCodeFunctionCall* _tmp127_;
	ValaCCodeFunction* _tmp128_;
	ValaCCodeFunction* _tmp129_;
	ValaCCodeIdentifier* _tmp130_;
	ValaCCodeIdentifier* _tmp131_;
	ValaCCodeFile* _tmp132_;
	ValaCCodeFile* _tmp133_;
	ValaCCodeFunction* _tmp134_;
	ValaCCodeFile* _tmp135_;
	ValaCCodeFunction* _tmp136_;
	gchar* _tmp137_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, "string_printf")) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("string_printf");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = vala_ccode_function_new ("string_printf", "char*");
	function = _tmp1_;
	_tmp2_ = function;
	_tmp3_ = vala_ccode_parameter_new ("format", "const char*");
	_tmp4_ = _tmp3_;
	vala_ccode_function_add_parameter (_tmp2_, _tmp4_);
	_vala_ccode_node_unref0 (_tmp4_);
	_tmp5_ = function;
	_tmp6_ = vala_ccode_parameter_new_with_ellipsis ();
	_tmp7_ = _tmp6_;
	vala_ccode_function_add_parameter (_tmp5_, _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	_tmp8_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp8_, VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_PRINTF);
	_tmp9_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp10_ = _tmp9_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp10_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp10_);
	_tmp11_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp11_);
	_tmp12_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_variable_declarator_new ("length", NULL, NULL);
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_declaration (_tmp13_, "int", (ValaCCodeDeclarator*) _tmp15_, 0);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_variable_declarator_new ("ap", NULL, NULL);
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_declaration (_tmp17_, "va_list", (ValaCCodeDeclarator*) _tmp19_, 0);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_variable_declarator_new ("result", NULL, NULL);
	_tmp23_ = _tmp22_;
	vala_ccode_function_add_declaration (_tmp21_, "char*", (ValaCCodeDeclarator*) _tmp23_, 0);
	_vala_ccode_node_unref0 (_tmp23_);
	_tmp24_ = vala_ccode_identifier_new ("va_start");
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp25_);
	_tmp27_ = _tmp26_;
	_vala_ccode_node_unref0 (_tmp25_);
	va_start = _tmp27_;
	_tmp28_ = va_start;
	_tmp29_ = vala_ccode_identifier_new ("ap");
	_tmp30_ = _tmp29_;
	vala_ccode_function_call_add_argument (_tmp28_, (ValaCCodeExpression*) _tmp30_);
	_vala_ccode_node_unref0 (_tmp30_);
	_tmp31_ = va_start;
	_tmp32_ = vala_ccode_identifier_new ("format");
	_tmp33_ = _tmp32_;
	vala_ccode_function_call_add_argument (_tmp31_, (ValaCCodeExpression*) _tmp33_);
	_vala_ccode_node_unref0 (_tmp33_);
	_tmp34_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = va_start;
	vala_ccode_function_add_expression (_tmp35_, (ValaCCodeExpression*) _tmp36_);
	_tmp37_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
	_tmp38_ = _tmp37_;
	_tmp39_ = vala_code_context_get_profile (_tmp38_);
	_tmp40_ = _tmp39_;
	if (_tmp40_ == VALA_PROFILE_POSIX) {
		ValaCCodeFile* _tmp41_;
		_tmp41_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp41_, "stdio.h", FALSE);
	}
	_tmp42_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp43_ = _tmp42_;
	_tmp44_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp43_);
	_tmp45_ = _tmp44_;
	_vala_ccode_node_unref0 (_tmp43_);
	vsnprintf = _tmp45_;
	_tmp46_ = vsnprintf;
	_tmp47_ = vala_ccode_constant_new ("NULL");
	_tmp48_ = _tmp47_;
	vala_ccode_function_call_add_argument (_tmp46_, (ValaCCodeExpression*) _tmp48_);
	_vala_ccode_node_unref0 (_tmp48_);
	_tmp49_ = vsnprintf;
	_tmp50_ = vala_ccode_constant_new ("0");
	_tmp51_ = _tmp50_;
	vala_ccode_function_call_add_argument (_tmp49_, (ValaCCodeExpression*) _tmp51_);
	_vala_ccode_node_unref0 (_tmp51_);
	_tmp52_ = vsnprintf;
	_tmp53_ = vala_ccode_identifier_new ("format");
	_tmp54_ = _tmp53_;
	vala_ccode_function_call_add_argument (_tmp52_, (ValaCCodeExpression*) _tmp54_);
	_vala_ccode_node_unref0 (_tmp54_);
	_tmp55_ = vsnprintf;
	_tmp56_ = vala_ccode_identifier_new ("ap");
	_tmp57_ = _tmp56_;
	vala_ccode_function_call_add_argument (_tmp55_, (ValaCCodeExpression*) _tmp57_);
	_vala_ccode_node_unref0 (_tmp57_);
	_tmp58_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp59_ = _tmp58_;
	_tmp60_ = vala_ccode_identifier_new ("length");
	_tmp61_ = _tmp60_;
	_tmp62_ = vsnprintf;
	_tmp63_ = vala_ccode_constant_new ("1");
	_tmp64_ = _tmp63_;
	_tmp65_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp62_, (ValaCCodeExpression*) _tmp64_);
	_tmp66_ = _tmp65_;
	vala_ccode_function_add_assignment (_tmp59_, (ValaCCodeExpression*) _tmp61_, (ValaCCodeExpression*) _tmp66_);
	_vala_ccode_node_unref0 (_tmp66_);
	_vala_ccode_node_unref0 (_tmp64_);
	_vala_ccode_node_unref0 (_tmp61_);
	_tmp67_ = vala_ccode_identifier_new ("va_end");
	_tmp68_ = _tmp67_;
	_tmp69_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp68_);
	_tmp70_ = _tmp69_;
	_vala_ccode_node_unref0 (_tmp68_);
	va_end = _tmp70_;
	_tmp71_ = va_end;
	_tmp72_ = vala_ccode_identifier_new ("ap");
	_tmp73_ = _tmp72_;
	vala_ccode_function_call_add_argument (_tmp71_, (ValaCCodeExpression*) _tmp73_);
	_vala_ccode_node_unref0 (_tmp73_);
	_tmp74_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp75_ = _tmp74_;
	_tmp76_ = va_end;
	vala_ccode_function_add_expression (_tmp75_, (ValaCCodeExpression*) _tmp76_);
	_tmp77_ = vala_ccode_identifier_new ("malloc");
	_tmp78_ = _tmp77_;
	_tmp79_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp78_);
	_tmp80_ = _tmp79_;
	_vala_ccode_node_unref0 (_tmp78_);
	malloc = _tmp80_;
	_tmp81_ = malloc;
	_tmp82_ = vala_ccode_identifier_new ("length");
	_tmp83_ = _tmp82_;
	vala_ccode_function_call_add_argument (_tmp81_, (ValaCCodeExpression*) _tmp83_);
	_vala_ccode_node_unref0 (_tmp83_);
	_tmp84_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp85_ = _tmp84_;
	_tmp86_ = vala_ccode_identifier_new ("result");
	_tmp87_ = _tmp86_;
	_tmp88_ = malloc;
	vala_ccode_function_add_assignment (_tmp85_, (ValaCCodeExpression*) _tmp87_, (ValaCCodeExpression*) _tmp88_);
	_vala_ccode_node_unref0 (_tmp87_);
	_tmp89_ = vala_ccode_identifier_new ("va_start");
	_tmp90_ = _tmp89_;
	_tmp91_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp90_);
	_vala_ccode_node_unref0 (va_start);
	va_start = _tmp91_;
	_vala_ccode_node_unref0 (_tmp90_);
	_tmp92_ = va_start;
	_tmp93_ = vala_ccode_identifier_new ("ap");
	_tmp94_ = _tmp93_;
	vala_ccode_function_call_add_argument (_tmp92_, (ValaCCodeExpression*) _tmp94_);
	_vala_ccode_node_unref0 (_tmp94_);
	_tmp95_ = va_start;
	_tmp96_ = vala_ccode_identifier_new ("format");
	_tmp97_ = _tmp96_;
	vala_ccode_function_call_add_argument (_tmp95_, (ValaCCodeExpression*) _tmp97_);
	_vala_ccode_node_unref0 (_tmp97_);
	_tmp98_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp99_ = _tmp98_;
	_tmp100_ = va_start;
	vala_ccode_function_add_expression (_tmp99_, (ValaCCodeExpression*) _tmp100_);
	_tmp101_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp102_ = _tmp101_;
	_tmp103_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp102_);
	_vala_ccode_node_unref0 (vsnprintf);
	vsnprintf = _tmp103_;
	_vala_ccode_node_unref0 (_tmp102_);
	_tmp104_ = vsnprintf;
	_tmp105_ = vala_ccode_identifier_new ("result");
	_tmp106_ = _tmp105_;
	vala_ccode_function_call_add_argument (_tmp104_, (ValaCCodeExpression*) _tmp106_);
	_vala_ccode_node_unref0 (_tmp106_);
	_tmp107_ = vsnprintf;
	_tmp108_ = vala_ccode_identifier_new ("length");
	_tmp109_ = _tmp108_;
	vala_ccode_function_call_add_argument (_tmp107_, (ValaCCodeExpression*) _tmp109_);
	_vala_ccode_node_unref0 (_tmp109_);
	_tmp110_ = vsnprintf;
	_tmp111_ = vala_ccode_identifier_new ("format");
	_tmp112_ = _tmp111_;
	vala_ccode_function_call_add_argument (_tmp110_, (ValaCCodeExpression*) _tmp112_);
	_vala_ccode_node_unref0 (_tmp112_);
	_tmp113_ = vsnprintf;
	_tmp114_ = vala_ccode_identifier_new ("ap");
	_tmp115_ = _tmp114_;
	vala_ccode_function_call_add_argument (_tmp113_, (ValaCCodeExpression*) _tmp115_);
	_vala_ccode_node_unref0 (_tmp115_);
	_tmp116_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp117_ = _tmp116_;
	_tmp118_ = vsnprintf;
	vala_ccode_function_add_expression (_tmp117_, (ValaCCodeExpression*) _tmp118_);
	_tmp119_ = vala_ccode_identifier_new ("va_end");
	_tmp120_ = _tmp119_;
	_tmp121_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp120_);
	_vala_ccode_node_unref0 (va_end);
	va_end = _tmp121_;
	_vala_ccode_node_unref0 (_tmp120_);
	_tmp122_ = va_end;
	_tmp123_ = vala_ccode_identifier_new ("ap");
	_tmp124_ = _tmp123_;
	vala_ccode_function_call_add_argument (_tmp122_, (ValaCCodeExpression*) _tmp124_);
	_vala_ccode_node_unref0 (_tmp124_);
	_tmp125_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp126_ = _tmp125_;
	_tmp127_ = va_end;
	vala_ccode_function_add_expression (_tmp126_, (ValaCCodeExpression*) _tmp127_);
	_tmp128_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp129_ = _tmp128_;
	_tmp130_ = vala_ccode_identifier_new ("result");
	_tmp131_ = _tmp130_;
	vala_ccode_function_add_return (_tmp129_, (ValaCCodeExpression*) _tmp131_);
	_vala_ccode_node_unref0 (_tmp131_);
	_tmp132_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_include (_tmp132_, "stdarg.h", FALSE);
	_tmp133_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp134_ = function;
	vala_ccode_file_add_function_declaration (_tmp133_, _tmp134_);
	_tmp135_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp136_ = function;
	vala_ccode_file_add_function (_tmp135_, _tmp136_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	_tmp137_ = g_strdup ("string_printf");
	result = _tmp137_;
	_vala_ccode_node_unref0 (malloc);
	_vala_ccode_node_unref0 (va_end);
	_vala_ccode_node_unref0 (vsnprintf);
	_vala_ccode_node_unref0 (va_start);
	_vala_ccode_node_unref0 (function);
	return result;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_construct (GType object_type)
{
	ValaCCodeMethodCallModule* self = NULL;
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type);
	return self;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_new (void)
{
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE);
}

static void
vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass,
                                          gpointer klass_data)
{
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_ccode_method_call_module_real_visit_method_call;
}

static void
vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self,
                                             gpointer klass)
{
}

static GType
vala_ccode_method_call_module_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
	GType vala_ccode_method_call_module_type_id;
	vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
	return vala_ccode_method_call_module_type_id;
}

GType
vala_ccode_method_call_module_get_type (void)
{
	static volatile gsize vala_ccode_method_call_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_method_call_module_type_id__volatile)) {
		GType vala_ccode_method_call_module_type_id;
		vala_ccode_method_call_module_type_id = vala_ccode_method_call_module_get_type_once ();
		g_once_init_leave (&vala_ccode_method_call_module_type_id__volatile, vala_ccode_method_call_module_type_id);
	}
	return vala_ccode_method_call_module_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

