/* girdocumentationimporter.c generated by valac, the Vala compiler
 * generated from girdocumentationimporter.vala, do not modify */

/* girdocumentationimporter.vala
 *
 * Copyright (C) 2008-2010  Jürg Billeter
 * Copyright (C) 2011       Luca Bruno
 * Copyright (C) 2011-2014  Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Luca Bruno <lucabru@src.gnome.org>
 *  Florian Brosch <flo.brosch@gmail.com>
 */

#include "valadoc.h"
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

enum  {
	VALADOC_IMPORTER_GIR_DOCUMENTATION_IMPORTER_0_PROPERTY,
	VALADOC_IMPORTER_GIR_DOCUMENTATION_IMPORTER_FILE_EXTENSION_PROPERTY,
	VALADOC_IMPORTER_GIR_DOCUMENTATION_IMPORTER_NUM_PROPERTIES
};
static GParamSpec* valadoc_importer_gir_documentation_importer_properties[VALADOC_IMPORTER_GIR_DOCUMENTATION_IMPORTER_NUM_PROPERTIES];
#define _vala_markup_reader_unref0(var) ((var == NULL) ? NULL : (var = (vala_markup_reader_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

#define VALADOC_IMPORTER_GIR_DOCUMENTATION_IMPORTER_TYPE_IMPLICIT_PARAMETER_POS (valadoc_importer_gir_documentation_importer_implicit_parameter_pos_get_type ())
typedef struct _ValadocImporterGirDocumentationImporterImplicitParameterPos ValadocImporterGirDocumentationImporterImplicitParameterPos;
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _valadoc_api_source_comment_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_api_source_comment_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _ValadocImporterGirDocumentationImporterPrivate {
	ValaMarkupTokenType current_token;
	ValaSourceLocation begin;
	ValaSourceLocation end;
	ValaMarkupReader* reader;
	ValadocDocumentationParser* parser;
	ValadocApiSourceFile* file;
	gchar* parent_c_identifier;
};

struct _ValadocImporterGirDocumentationImporterImplicitParameterPos {
	gint parameter;
	gint position;
};

static gint ValadocImporterGirDocumentationImporter_private_offset;
static gpointer valadoc_importer_gir_documentation_importer_parent_class = NULL;

#define VALADOC_IMPORTER_GIR_DOCUMENTATION_IMPORTER_GIR_VERSION "1.2"
static void valadoc_importer_gir_documentation_importer_real_process (ValadocImporterDocumentationImporter* base,
                                                               const gchar* source_file);
static void valadoc_importer_gir_documentation_importer_next (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_error (ValadocImporterGirDocumentationImporter* self,
                                                        const gchar* message);
static void valadoc_importer_gir_documentation_importer_parse_repository (ValadocImporterGirDocumentationImporter* self);
static ValadocApiParameter* valadoc_importer_gir_documentation_importer_find_parameter (ValadocImporterGirDocumentationImporter* self,
                                                                                 ValadocApiNode* node,
                                                                                 const gchar* name);
static inline gchar* valadoc_importer_gir_documentation_importer_get_cparameter_name (ValadocImporterGirDocumentationImporter* self,
                                                                        gchar** param_names,
                                                                        gint param_names_length1,
                                                                        gint length_pos);
static GType valadoc_importer_gir_documentation_importer_implicit_parameter_pos_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static ValadocImporterGirDocumentationImporterImplicitParameterPos* valadoc_importer_gir_documentation_importer_implicit_parameter_pos_dup (const ValadocImporterGirDocumentationImporterImplicitParameterPos* self);
static void valadoc_importer_gir_documentation_importer_implicit_parameter_pos_free (ValadocImporterGirDocumentationImporterImplicitParameterPos* self);
static void valadoc_importer_gir_documentation_importer_attach_comment (ValadocImporterGirDocumentationImporter* self,
                                                                 const gchar* cname,
                                                                 ValadocApiGirSourceComment* comment,
                                                                 gchar** param_names,
                                                                 gint param_names_length1,
                                                                 ValadocImporterGirDocumentationImporterImplicitParameterPos* destroy_notifies,
                                                                 gint destroy_notifies_length1,
                                                                 ValadocImporterGirDocumentationImporterImplicitParameterPos* closures,
                                                                 gint closures_length1,
                                                                 ValadocImporterGirDocumentationImporterImplicitParameterPos* array_lengths,
                                                                 gint array_lengths_length1,
                                                                 gint array_length_ret);
 G_GNUC_INTERNAL void valadoc_api_parameter_set_implicit_destroy_cparameter_name (ValadocApiParameter* self,
                                                                 const gchar* value);
 G_GNUC_INTERNAL void valadoc_api_parameter_set_implicit_closure_cparameter_name (ValadocApiParameter* self,
                                                                 const gchar* value);
 G_GNUC_INTERNAL void valadoc_api_parameter_set_implicit_array_length_cparameter_name (ValadocApiParameter* self,
                                                                      const gchar* value);
 G_GNUC_INTERNAL void valadoc_api_callable_set_implicit_array_length_cparameter_name (ValadocApiCallable* self,
                                                                     const gchar* value);
 G_GNUC_INTERNAL void valadoc_api_node_set_documentation (ValadocApiNode* self,
                                         ValadocContentComment* value);
static void valadoc_importer_gir_documentation_importer_warning (ValadocImporterGirDocumentationImporter* self,
                                                          const gchar* message);
static void valadoc_importer_gir_documentation_importer_start_element (ValadocImporterGirDocumentationImporter* self,
                                                                const gchar* name);
static void valadoc_importer_gir_documentation_importer_end_element (ValadocImporterGirDocumentationImporter* self,
                                                              const gchar* name);
static void valadoc_importer_gir_documentation_importer_parse_namespace (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_parse_include (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_parse_package (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_parse_c_include (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_skip_element (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_parse_alias (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_parse_enumeration (ValadocImporterGirDocumentationImporter* self,
                                                                    const gchar* element_name);
static void valadoc_importer_gir_documentation_importer_parse_bitfield (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_parse_method (ValadocImporterGirDocumentationImporter* self,
                                                               const gchar* element_name);
static void valadoc_importer_gir_documentation_importer_parse_callback (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_parse_record (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_parse_class (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_parse_interface (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_parse_boxed (ValadocImporterGirDocumentationImporter* self,
                                                              const gchar* element_name);
static void valadoc_importer_gir_documentation_importer_parse_union (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_parse_constant (ValadocImporterGirDocumentationImporter* self);
static ValadocApiGirSourceComment* valadoc_importer_gir_documentation_importer_parse_symbol_doc (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_parse_type (ValadocImporterGirDocumentationImporter* self,
                                                             gint* array_length_pos);
static ValadocApiSourceComment* valadoc_importer_gir_documentation_importer_parse_doc (ValadocImporterGirDocumentationImporter* self,
                                                                                const gchar* element_name);
static void valadoc_importer_gir_documentation_importer_parse_enumeration_member (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_parse_return_value (ValadocImporterGirDocumentationImporter* self,
                                                                     ValadocApiSourceComment* * comment,
                                                                     gint* array_length_ret);
static void valadoc_importer_gir_documentation_importer_parse_parameter (ValadocImporterGirDocumentationImporter* self,
                                                                  ValadocApiSourceComment* * comment,
                                                                  gchar* * param_name,
                                                                  gint* destroy_pos,
                                                                  gint* closure_pos,
                                                                  gint* array_length_pos);
static void valadoc_importer_gir_documentation_importer_parse_field (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_parse_constructor (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_parse_property (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_parse_signal (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_parse_function (ValadocImporterGirDocumentationImporter* self,
                                                                 const gchar* element_name);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void valadoc_importer_gir_documentation_importer_implicit_parameter_pos_init (ValadocImporterGirDocumentationImporterImplicitParameterPos *self,
                                                                              gint parameter,
                                                                              gint position);
static void _vala_array_add4 (ValadocImporterGirDocumentationImporterImplicitParameterPos* * array,
                       gint* length,
                       gint* size,
                       const ValadocImporterGirDocumentationImporterImplicitParameterPos* value);
static void _vala_array_add5 (ValadocImporterGirDocumentationImporterImplicitParameterPos* * array,
                       gint* length,
                       gint* size,
                       const ValadocImporterGirDocumentationImporterImplicitParameterPos* value);
static void _vala_array_add6 (ValadocImporterGirDocumentationImporterImplicitParameterPos* * array,
                       gint* length,
                       gint* size,
                       const ValadocImporterGirDocumentationImporterImplicitParameterPos* value);
static void valadoc_importer_gir_documentation_importer_finalize (GObject * obj);
static GType valadoc_importer_gir_documentation_importer_get_type_once (void);
static void _vala_valadoc_importer_gir_documentation_importer_get_property (GObject * object,
                                                                     guint property_id,
                                                                     GValue * value,
                                                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
valadoc_importer_gir_documentation_importer_get_instance_private (ValadocImporterGirDocumentationImporter* self)
{
	return G_STRUCT_MEMBER_P (self, ValadocImporterGirDocumentationImporter_private_offset);
}

static const gchar*
valadoc_importer_gir_documentation_importer_real_get_file_extension (ValadocImporterDocumentationImporter* base)
{
	const gchar* result;
	ValadocImporterGirDocumentationImporter* self;
	self = (ValadocImporterGirDocumentationImporter*) base;
	result = "gir";
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

ValadocImporterGirDocumentationImporter*
valadoc_importer_gir_documentation_importer_construct (GType object_type,
                                                       ValadocApiTree* tree,
                                                       ValadocDocumentationParser* parser,
                                                       ValadocModuleLoader* modules,
                                                       ValadocSettings* settings,
                                                       ValadocErrorReporter* reporter)
{
	ValadocImporterGirDocumentationImporter * self = NULL;
	ValadocDocumentationParser* _tmp0_;
	g_return_val_if_fail (tree != NULL, NULL);
	g_return_val_if_fail (parser != NULL, NULL);
	g_return_val_if_fail (modules != NULL, NULL);
	g_return_val_if_fail (settings != NULL, NULL);
	g_return_val_if_fail (reporter != NULL, NULL);
	self = (ValadocImporterGirDocumentationImporter*) valadoc_importer_documentation_importer_construct (object_type, tree, modules, settings);
	_tmp0_ = _g_object_ref0 (parser);
	_g_object_unref0 (self->priv->parser);
	self->priv->parser = _tmp0_;
	return self;
}

ValadocImporterGirDocumentationImporter*
valadoc_importer_gir_documentation_importer_new (ValadocApiTree* tree,
                                                 ValadocDocumentationParser* parser,
                                                 ValadocModuleLoader* modules,
                                                 ValadocSettings* settings,
                                                 ValadocErrorReporter* reporter)
{
	return valadoc_importer_gir_documentation_importer_construct (VALADOC_IMPORTER_TYPE_GIR_DOCUMENTATION_IMPORTER, tree, parser, modules, settings, reporter);
}

static void
valadoc_importer_gir_documentation_importer_real_process (ValadocImporterDocumentationImporter* base,
                                                          const gchar* source_file)
{
	ValadocImporterGirDocumentationImporter * self;
	ValaSourceFile* data = NULL;
	ValadocApiTree* _tmp0_;
	ValaCodeContext* _tmp1_;
	ValaCodeContext* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	ValaSourceFile* _tmp5_;
	ValaSourceFile* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	ValadocApiPackage* _tmp9_;
	ValadocApiPackage* _tmp10_;
	ValaSourceFile* _tmp11_;
	ValadocApiSourceFile* _tmp12_;
	ValaMarkupReader* _tmp13_;
	self = (ValadocImporterGirDocumentationImporter*) base;
	g_return_if_fail (source_file != NULL);
	_tmp0_ = ((ValadocImporterDocumentationImporter*) self)->tree;
	_tmp1_ = valadoc_api_tree_get_context (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_path_get_basename (source_file);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_source_file_new (_tmp2_, VALA_SOURCE_FILE_TYPE_PACKAGE, _tmp4_, NULL, FALSE);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	data = _tmp6_;
	_tmp7_ = g_path_get_basename (source_file);
	_tmp8_ = _tmp7_;
	_tmp9_ = valadoc_api_package_new (_tmp8_, TRUE, NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = data;
	_tmp12_ = valadoc_api_source_file_new (_tmp10_, source_file, NULL, _tmp11_);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp12_;
	_g_object_unref0 (_tmp10_);
	_g_free0 (_tmp8_);
	_tmp13_ = vala_markup_reader_new (source_file);
	_vala_markup_reader_unref0 (self->priv->reader);
	self->priv->reader = _tmp13_;
	{
		gboolean _tmp14_ = FALSE;
		_tmp14_ = TRUE;
		while (TRUE) {
			ValaMarkupTokenType _tmp20_;
			if (!_tmp14_) {
				gboolean _tmp15_ = FALSE;
				ValaMarkupTokenType _tmp16_;
				_tmp16_ = self->priv->current_token;
				if (_tmp16_ != VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
					ValaMarkupReader* _tmp17_;
					const gchar* _tmp18_;
					const gchar* _tmp19_;
					_tmp17_ = self->priv->reader;
					_tmp18_ = vala_markup_reader_get_name (_tmp17_);
					_tmp19_ = _tmp18_;
					_tmp15_ = g_strcmp0 (_tmp19_, "repository") != 0;
				} else {
					_tmp15_ = FALSE;
				}
				if (!_tmp15_) {
					break;
				}
			}
			_tmp14_ = FALSE;
			valadoc_importer_gir_documentation_importer_next (self);
			_tmp20_ = self->priv->current_token;
			if (_tmp20_ == VALA_MARKUP_TOKEN_TYPE_EOF) {
				valadoc_importer_gir_documentation_importer_error (self, "unexpected end of file");
				_vala_source_file_unref0 (data);
				return;
			}
		}
	}
	valadoc_importer_gir_documentation_importer_parse_repository (self);
	_vala_markup_reader_unref0 (self->priv->reader);
	self->priv->reader = NULL;
	_g_object_unref0 (self->priv->file);
	self->priv->file = NULL;
	_vala_source_file_unref0 (data);
}

static ValadocApiParameter*
valadoc_importer_gir_documentation_importer_find_parameter (ValadocImporterGirDocumentationImporter* self,
                                                            ValadocApiNode* node,
                                                            const gchar* name)
{
	ValaList* parameters = NULL;
	ValaList* _tmp0_;
	ValadocApiParameter* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = valadoc_api_node_get_children_by_type (node, VALADOC_API_NODE_TYPE_FORMAL_PARAMETER, FALSE);
	parameters = _tmp0_;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp1_ = parameters;
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValadocApiNode* param = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValadocApiNode* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			_param_index = _param_index + 1;
			_tmp5_ = _param_index;
			_tmp6_ = _param_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _param_list;
			_tmp8_ = vala_list_get (_tmp7_, _param_index);
			param = (ValadocApiNode*) _tmp8_;
			_tmp9_ = param;
			_tmp10_ = valadoc_api_node_get_name ((ValadocApiNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, VALADOC_API_TYPE_PARAMETER, ValadocApiParameter));
			_tmp11_ = _tmp10_;
			if (g_strcmp0 (_tmp11_, name) == 0) {
				ValadocApiNode* _tmp12_;
				ValadocApiParameter* _tmp13_;
				_tmp12_ = param;
				_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALADOC_API_TYPE_PARAMETER, ValadocApiParameter));
				result = _tmp13_;
				_g_object_unref0 (param);
				_vala_iterable_unref0 (parameters);
				return result;
			}
			_g_object_unref0 (param);
		}
	}
	result = NULL;
	_vala_iterable_unref0 (parameters);
	return result;
}

static inline gchar*
valadoc_importer_gir_documentation_importer_get_cparameter_name (ValadocImporterGirDocumentationImporter* self,
                                                                 gchar** param_names,
                                                                 gint param_names_length1,
                                                                 gint length_pos)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (length_pos < 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = param_names_length1 < length_pos;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp1_ = param_names[length_pos];
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

static void
valadoc_importer_gir_documentation_importer_attach_comment (ValadocImporterGirDocumentationImporter* self,
                                                            const gchar* cname,
                                                            ValadocApiGirSourceComment* comment,
                                                            gchar** param_names,
                                                            gint param_names_length1,
                                                            ValadocImporterGirDocumentationImporterImplicitParameterPos* destroy_notifies,
                                                            gint destroy_notifies_length1,
                                                            ValadocImporterGirDocumentationImporterImplicitParameterPos* closures,
                                                            gint closures_length1,
                                                            ValadocImporterGirDocumentationImporterImplicitParameterPos* array_lengths,
                                                            gint array_lengths_length1,
                                                            gint array_length_ret)
{
	ValadocApiNode* node = NULL;
	ValadocApiTree* _tmp0_;
	ValadocApiNode* _tmp1_;
	ValadocApiNode* _tmp2_;
	ValadocContentComment* content = NULL;
	ValadocDocumentationParser* _tmp34_;
	ValadocApiNode* _tmp35_;
	ValadocContentComment* _tmp36_;
	ValadocContentComment* _tmp37_;
	ValadocApiNode* _tmp38_;
	ValadocContentComment* _tmp39_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cname != NULL);
	if (comment == NULL) {
		return;
	}
	_tmp0_ = ((ValadocImporterDocumentationImporter*) self)->tree;
	_tmp1_ = valadoc_api_tree_search_symbol_cstr (_tmp0_, NULL, cname);
	node = _tmp1_;
	_tmp2_ = node;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (node);
		return;
	}
	if (param_names != NULL) {
		ValadocApiNode* _tmp30_;
		{
			ValadocImporterGirDocumentationImporterImplicitParameterPos* pos_collection = NULL;
			gint pos_collection_length1 = 0;
			gint _pos_collection_size_ = 0;
			gint pos_it = 0;
			pos_collection = destroy_notifies;
			pos_collection_length1 = destroy_notifies_length1;
			for (pos_it = 0; pos_it < pos_collection_length1; pos_it = pos_it + 1) {
				ValadocImporterGirDocumentationImporterImplicitParameterPos pos = {0};
				pos = pos_collection[pos_it];
				{
					ValadocApiParameter* param = NULL;
					ValadocApiNode* _tmp3_;
					ValadocImporterGirDocumentationImporterImplicitParameterPos _tmp4_;
					const gchar* _tmp5_;
					ValadocApiParameter* _tmp6_;
					ValadocApiParameter* _tmp7_;
					ValadocApiParameter* _tmp8_;
					ValadocImporterGirDocumentationImporterImplicitParameterPos _tmp9_;
					gchar* _tmp10_;
					gchar* _tmp11_;
					_tmp3_ = node;
					_tmp4_ = pos;
					_tmp5_ = param_names[_tmp4_.parameter];
					_tmp6_ = valadoc_importer_gir_documentation_importer_find_parameter (self, _tmp3_, _tmp5_);
					param = _tmp6_;
					_tmp7_ = param;
					if (_tmp7_ == NULL) {
						_g_object_unref0 (param);
						continue;
					}
					_tmp8_ = param;
					_tmp9_ = pos;
					_tmp10_ = valadoc_importer_gir_documentation_importer_get_cparameter_name (self, param_names, (gint) param_names_length1, _tmp9_.position);
					_tmp11_ = _tmp10_;
					valadoc_api_parameter_set_implicit_destroy_cparameter_name (_tmp8_, _tmp11_);
					_g_free0 (_tmp11_);
					_g_object_unref0 (param);
				}
			}
		}
		{
			ValadocImporterGirDocumentationImporterImplicitParameterPos* pos_collection = NULL;
			gint pos_collection_length1 = 0;
			gint _pos_collection_size_ = 0;
			gint pos_it = 0;
			pos_collection = closures;
			pos_collection_length1 = closures_length1;
			for (pos_it = 0; pos_it < pos_collection_length1; pos_it = pos_it + 1) {
				ValadocImporterGirDocumentationImporterImplicitParameterPos pos = {0};
				pos = pos_collection[pos_it];
				{
					ValadocApiParameter* param = NULL;
					ValadocApiNode* _tmp12_;
					ValadocImporterGirDocumentationImporterImplicitParameterPos _tmp13_;
					const gchar* _tmp14_;
					ValadocApiParameter* _tmp15_;
					ValadocApiParameter* _tmp16_;
					ValadocApiParameter* _tmp17_;
					ValadocImporterGirDocumentationImporterImplicitParameterPos _tmp18_;
					gchar* _tmp19_;
					gchar* _tmp20_;
					_tmp12_ = node;
					_tmp13_ = pos;
					_tmp14_ = param_names[_tmp13_.parameter];
					_tmp15_ = valadoc_importer_gir_documentation_importer_find_parameter (self, _tmp12_, _tmp14_);
					param = _tmp15_;
					_tmp16_ = param;
					if (_tmp16_ == NULL) {
						_g_object_unref0 (param);
						continue;
					}
					_tmp17_ = param;
					_tmp18_ = pos;
					_tmp19_ = valadoc_importer_gir_documentation_importer_get_cparameter_name (self, param_names, (gint) param_names_length1, _tmp18_.position);
					_tmp20_ = _tmp19_;
					valadoc_api_parameter_set_implicit_closure_cparameter_name (_tmp17_, _tmp20_);
					_g_free0 (_tmp20_);
					_g_object_unref0 (param);
				}
			}
		}
		{
			ValadocImporterGirDocumentationImporterImplicitParameterPos* pos_collection = NULL;
			gint pos_collection_length1 = 0;
			gint _pos_collection_size_ = 0;
			gint pos_it = 0;
			pos_collection = array_lengths;
			pos_collection_length1 = array_lengths_length1;
			for (pos_it = 0; pos_it < pos_collection_length1; pos_it = pos_it + 1) {
				ValadocImporterGirDocumentationImporterImplicitParameterPos pos = {0};
				pos = pos_collection[pos_it];
				{
					ValadocApiParameter* param = NULL;
					ValadocApiNode* _tmp21_;
					ValadocImporterGirDocumentationImporterImplicitParameterPos _tmp22_;
					const gchar* _tmp23_;
					ValadocApiParameter* _tmp24_;
					ValadocApiParameter* _tmp25_;
					ValadocApiParameter* _tmp26_;
					ValadocImporterGirDocumentationImporterImplicitParameterPos _tmp27_;
					gchar* _tmp28_;
					gchar* _tmp29_;
					_tmp21_ = node;
					_tmp22_ = pos;
					_tmp23_ = param_names[_tmp22_.parameter];
					_tmp24_ = valadoc_importer_gir_documentation_importer_find_parameter (self, _tmp21_, _tmp23_);
					param = _tmp24_;
					_tmp25_ = param;
					if (_tmp25_ == NULL) {
						_g_object_unref0 (param);
						continue;
					}
					_tmp26_ = param;
					_tmp27_ = pos;
					_tmp28_ = valadoc_importer_gir_documentation_importer_get_cparameter_name (self, param_names, (gint) param_names_length1, _tmp27_.position);
					_tmp29_ = _tmp28_;
					valadoc_api_parameter_set_implicit_array_length_cparameter_name (_tmp26_, _tmp29_);
					_g_free0 (_tmp29_);
					_g_object_unref0 (param);
				}
			}
		}
		_tmp30_ = node;
		if (VALADOC_API_IS_CALLABLE (_tmp30_)) {
			ValadocApiNode* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			_tmp31_ = node;
			_tmp32_ = valadoc_importer_gir_documentation_importer_get_cparameter_name (self, param_names, (gint) param_names_length1, array_length_ret);
			_tmp33_ = _tmp32_;
			valadoc_api_callable_set_implicit_array_length_cparameter_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, VALADOC_API_TYPE_CALLABLE, ValadocApiCallable), _tmp33_);
			_g_free0 (_tmp33_);
		}
	}
	_tmp34_ = self->priv->parser;
	_tmp35_ = node;
	_tmp36_ = valadoc_documentation_parser_parse (_tmp34_, _tmp35_, (ValadocApiSourceComment*) comment);
	content = _tmp36_;
	_tmp37_ = content;
	if (_tmp37_ == NULL) {
		_g_object_unref0 (content);
		_g_object_unref0 (node);
		return;
	}
	_tmp38_ = node;
	_tmp39_ = content;
	valadoc_api_node_set_documentation (_tmp38_, _tmp39_);
	_g_object_unref0 (content);
	_g_object_unref0 (node);
}

static void
valadoc_importer_gir_documentation_importer_warning (ValadocImporterGirDocumentationImporter* self,
                                                     const gchar* message)
{
	ValadocApiSourceFile* _tmp0_;
	ValaSourceFile* _tmp1_;
	ValaSourceFile* _tmp2_;
	ValaSourceLocation _tmp3_;
	ValaSourceLocation _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaSourceReference* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = self->priv->file;
	_tmp1_ = valadoc_api_source_file_get_data (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->begin;
	_tmp4_ = self->priv->end;
	_tmp5_ = vala_source_reference_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, VALA_TYPE_SOURCE_FILE, ValaSourceFile), &_tmp3_, &_tmp4_);
	_tmp6_ = _tmp5_;
	vala_report_warning (_tmp6_, "%s", message);
	_vala_source_reference_unref0 (_tmp6_);
}

static void
valadoc_importer_gir_documentation_importer_error (ValadocImporterGirDocumentationImporter* self,
                                                   const gchar* message)
{
	ValadocApiSourceFile* _tmp0_;
	ValaSourceFile* _tmp1_;
	ValaSourceFile* _tmp2_;
	ValaSourceLocation _tmp3_;
	ValaSourceLocation _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaSourceReference* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = self->priv->file;
	_tmp1_ = valadoc_api_source_file_get_data (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->begin;
	_tmp4_ = self->priv->end;
	_tmp5_ = vala_source_reference_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, VALA_TYPE_SOURCE_FILE, ValaSourceFile), &_tmp3_, &_tmp4_);
	_tmp6_ = _tmp5_;
	vala_report_error (_tmp6_, "%s", message);
	_vala_source_reference_unref0 (_tmp6_);
}

static void
valadoc_importer_gir_documentation_importer_next (ValadocImporterGirDocumentationImporter* self)
{
	ValaMarkupReader* _tmp0_;
	ValaSourceLocation _tmp1_ = {0};
	ValaSourceLocation _tmp2_ = {0};
	ValaMarkupTokenType _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaMarkupTokenType _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_read_token (_tmp0_, &_tmp1_, &_tmp2_);
	self->priv->begin = _tmp1_;
	self->priv->end = _tmp2_;
	self->priv->current_token = _tmp3_;
	_tmp5_ = self->priv->current_token;
	if (_tmp5_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		ValaMarkupReader* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp6_ = self->priv->reader;
		_tmp7_ = vala_markup_reader_get_name (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = g_strcmp0 (_tmp8_, "annotation") == 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		valadoc_importer_gir_documentation_importer_next (self);
		valadoc_importer_gir_documentation_importer_next (self);
	}
}

static void
valadoc_importer_gir_documentation_importer_start_element (ValadocImporterGirDocumentationImporter* self,
                                                           const gchar* name)
{
	gboolean _tmp0_ = FALSE;
	ValaMarkupTokenType _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp1_ = self->priv->current_token;
	if (_tmp1_ != VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		_tmp0_ = TRUE;
	} else {
		ValaMarkupReader* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = self->priv->reader;
		_tmp3_ = vala_markup_reader_get_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 (_tmp4_, name) != 0;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = g_strdup_printf ("expected start element of `%s'", name);
		_tmp6_ = _tmp5_;
		valadoc_importer_gir_documentation_importer_error (self, _tmp6_);
		_g_free0 (_tmp6_);
	}
}

static void
valadoc_importer_gir_documentation_importer_end_element (ValadocImporterGirDocumentationImporter* self,
                                                         const gchar* name)
{
	gboolean _tmp0_ = FALSE;
	ValaMarkupTokenType _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp1_ = self->priv->current_token;
	if (_tmp1_ != VALA_MARKUP_TOKEN_TYPE_END_ELEMENT) {
		_tmp0_ = TRUE;
	} else {
		ValaMarkupReader* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = self->priv->reader;
		_tmp3_ = vala_markup_reader_get_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 (_tmp4_, name) != 0;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = g_strdup_printf ("expected end element of `%s'", name);
		_tmp6_ = _tmp5_;
		valadoc_importer_gir_documentation_importer_error (self, _tmp6_);
		_g_free0 (_tmp6_);
	}
	valadoc_importer_gir_documentation_importer_next (self);
}

static void
valadoc_importer_gir_documentation_importer_parse_repository (ValadocImporterGirDocumentationImporter* self)
{
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, "repository");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "version");
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, VALADOC_IMPORTER_GIR_DOCUMENTATION_IMPORTER_GIR_VERSION) != 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		ValaMarkupReader* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp4_ = self->priv->reader;
		_tmp5_ = vala_markup_reader_get_attribute (_tmp4_, "version");
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strdup_printf ("unsupported GIR version %s (supported: %s)", _tmp6_, VALADOC_IMPORTER_GIR_DOCUMENTATION_IMPORTER_GIR_VERSION);
		_tmp8_ = _tmp7_;
		valadoc_importer_gir_documentation_importer_error (self, _tmp8_);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
		return;
	}
	valadoc_importer_gir_documentation_importer_next (self);
	while (TRUE) {
		ValaMarkupTokenType _tmp9_;
		ValaMarkupReader* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp9_ = self->priv->current_token;
		if (!(_tmp9_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp10_ = self->priv->reader;
		_tmp11_ = vala_markup_reader_get_name (_tmp10_);
		_tmp12_ = _tmp11_;
		if (g_strcmp0 (_tmp12_, "namespace") == 0) {
			valadoc_importer_gir_documentation_importer_parse_namespace (self);
		} else {
			ValaMarkupReader* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			_tmp13_ = self->priv->reader;
			_tmp14_ = vala_markup_reader_get_name (_tmp13_);
			_tmp15_ = _tmp14_;
			if (g_strcmp0 (_tmp15_, "include") == 0) {
				valadoc_importer_gir_documentation_importer_parse_include (self);
			} else {
				ValaMarkupReader* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				_tmp16_ = self->priv->reader;
				_tmp17_ = vala_markup_reader_get_name (_tmp16_);
				_tmp18_ = _tmp17_;
				if (g_strcmp0 (_tmp18_, "package") == 0) {
					valadoc_importer_gir_documentation_importer_parse_package (self);
				} else {
					ValaMarkupReader* _tmp19_;
					const gchar* _tmp20_;
					const gchar* _tmp21_;
					_tmp19_ = self->priv->reader;
					_tmp20_ = vala_markup_reader_get_name (_tmp19_);
					_tmp21_ = _tmp20_;
					if (g_strcmp0 (_tmp21_, "c:include") == 0) {
						valadoc_importer_gir_documentation_importer_parse_c_include (self);
					} else {
						ValaMarkupReader* _tmp22_;
						const gchar* _tmp23_;
						const gchar* _tmp24_;
						gchar* _tmp25_;
						gchar* _tmp26_;
						_tmp22_ = self->priv->reader;
						_tmp23_ = vala_markup_reader_get_name (_tmp22_);
						_tmp24_ = _tmp23_;
						_tmp25_ = g_strdup_printf ("unknown child element `%s' in `repository'", _tmp24_);
						_tmp26_ = _tmp25_;
						valadoc_importer_gir_documentation_importer_error (self, _tmp26_);
						_g_free0 (_tmp26_);
						valadoc_importer_gir_documentation_importer_skip_element (self);
					}
				}
			}
		}
	}
	valadoc_importer_gir_documentation_importer_end_element (self, "repository");
}

static void
valadoc_importer_gir_documentation_importer_parse_include (ValadocImporterGirDocumentationImporter* self)
{
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, "include");
	valadoc_importer_gir_documentation_importer_next (self);
	valadoc_importer_gir_documentation_importer_end_element (self, "include");
}

static void
valadoc_importer_gir_documentation_importer_parse_package (ValadocImporterGirDocumentationImporter* self)
{
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, "package");
	valadoc_importer_gir_documentation_importer_next (self);
	valadoc_importer_gir_documentation_importer_end_element (self, "package");
}

static void
valadoc_importer_gir_documentation_importer_parse_c_include (ValadocImporterGirDocumentationImporter* self)
{
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, "c:include");
	valadoc_importer_gir_documentation_importer_next (self);
	valadoc_importer_gir_documentation_importer_end_element (self, "c:include");
}

static void
valadoc_importer_gir_documentation_importer_skip_element (ValadocImporterGirDocumentationImporter* self)
{
	gint level = 0;
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_next (self);
	level = 1;
	while (TRUE) {
		ValaMarkupTokenType _tmp0_;
		if (!(level > 0)) {
			break;
		}
		_tmp0_ = self->priv->current_token;
		if (_tmp0_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
			gint _tmp1_;
			_tmp1_ = level;
			level = _tmp1_ + 1;
		} else {
			ValaMarkupTokenType _tmp2_;
			_tmp2_ = self->priv->current_token;
			if (_tmp2_ == VALA_MARKUP_TOKEN_TYPE_END_ELEMENT) {
				gint _tmp3_;
				_tmp3_ = level;
				level = _tmp3_ - 1;
			} else {
				ValaMarkupTokenType _tmp4_;
				_tmp4_ = self->priv->current_token;
				if (_tmp4_ == VALA_MARKUP_TOKEN_TYPE_EOF) {
					valadoc_importer_gir_documentation_importer_error (self, "unexpected end of file");
					break;
				}
			}
		}
		valadoc_importer_gir_documentation_importer_next (self);
	}
}

static void
valadoc_importer_gir_documentation_importer_parse_namespace (ValadocImporterGirDocumentationImporter* self)
{
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, "namespace");
	valadoc_importer_gir_documentation_importer_next (self);
	while (TRUE) {
		ValaMarkupTokenType _tmp0_;
		ValaMarkupReader* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp0_ = self->priv->current_token;
		if (!(_tmp0_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp1_ = self->priv->reader;
		_tmp2_ = vala_markup_reader_get_name (_tmp1_);
		_tmp3_ = _tmp2_;
		if (g_strcmp0 (_tmp3_, "alias") == 0) {
			valadoc_importer_gir_documentation_importer_parse_alias (self);
		} else {
			ValaMarkupReader* _tmp4_;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			_tmp4_ = self->priv->reader;
			_tmp5_ = vala_markup_reader_get_name (_tmp4_);
			_tmp6_ = _tmp5_;
			if (g_strcmp0 (_tmp6_, "enumeration") == 0) {
				valadoc_importer_gir_documentation_importer_parse_enumeration (self, "enumeration");
			} else {
				ValaMarkupReader* _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				_tmp7_ = self->priv->reader;
				_tmp8_ = vala_markup_reader_get_name (_tmp7_);
				_tmp9_ = _tmp8_;
				if (g_strcmp0 (_tmp9_, "bitfield") == 0) {
					valadoc_importer_gir_documentation_importer_parse_bitfield (self);
				} else {
					ValaMarkupReader* _tmp10_;
					const gchar* _tmp11_;
					const gchar* _tmp12_;
					_tmp10_ = self->priv->reader;
					_tmp11_ = vala_markup_reader_get_name (_tmp10_);
					_tmp12_ = _tmp11_;
					if (g_strcmp0 (_tmp12_, "function") == 0) {
						valadoc_importer_gir_documentation_importer_parse_method (self, "function");
					} else {
						ValaMarkupReader* _tmp13_;
						const gchar* _tmp14_;
						const gchar* _tmp15_;
						_tmp13_ = self->priv->reader;
						_tmp14_ = vala_markup_reader_get_name (_tmp13_);
						_tmp15_ = _tmp14_;
						if (g_strcmp0 (_tmp15_, "function-macro") == 0) {
							valadoc_importer_gir_documentation_importer_skip_element (self);
						} else {
							ValaMarkupReader* _tmp16_;
							const gchar* _tmp17_;
							const gchar* _tmp18_;
							_tmp16_ = self->priv->reader;
							_tmp17_ = vala_markup_reader_get_name (_tmp16_);
							_tmp18_ = _tmp17_;
							if (g_strcmp0 (_tmp18_, "callback") == 0) {
								valadoc_importer_gir_documentation_importer_parse_callback (self);
							} else {
								ValaMarkupReader* _tmp19_;
								const gchar* _tmp20_;
								const gchar* _tmp21_;
								_tmp19_ = self->priv->reader;
								_tmp20_ = vala_markup_reader_get_name (_tmp19_);
								_tmp21_ = _tmp20_;
								if (g_strcmp0 (_tmp21_, "record") == 0) {
									valadoc_importer_gir_documentation_importer_parse_record (self);
								} else {
									ValaMarkupReader* _tmp22_;
									const gchar* _tmp23_;
									const gchar* _tmp24_;
									_tmp22_ = self->priv->reader;
									_tmp23_ = vala_markup_reader_get_name (_tmp22_);
									_tmp24_ = _tmp23_;
									if (g_strcmp0 (_tmp24_, "class") == 0) {
										valadoc_importer_gir_documentation_importer_parse_class (self);
									} else {
										ValaMarkupReader* _tmp25_;
										const gchar* _tmp26_;
										const gchar* _tmp27_;
										_tmp25_ = self->priv->reader;
										_tmp26_ = vala_markup_reader_get_name (_tmp25_);
										_tmp27_ = _tmp26_;
										if (g_strcmp0 (_tmp27_, "interface") == 0) {
											valadoc_importer_gir_documentation_importer_parse_interface (self);
										} else {
											ValaMarkupReader* _tmp28_;
											const gchar* _tmp29_;
											const gchar* _tmp30_;
											_tmp28_ = self->priv->reader;
											_tmp29_ = vala_markup_reader_get_name (_tmp28_);
											_tmp30_ = _tmp29_;
											if (g_strcmp0 (_tmp30_, "glib:boxed") == 0) {
												valadoc_importer_gir_documentation_importer_parse_boxed (self, "glib:boxed");
											} else {
												ValaMarkupReader* _tmp31_;
												const gchar* _tmp32_;
												const gchar* _tmp33_;
												_tmp31_ = self->priv->reader;
												_tmp32_ = vala_markup_reader_get_name (_tmp31_);
												_tmp33_ = _tmp32_;
												if (g_strcmp0 (_tmp33_, "union") == 0) {
													valadoc_importer_gir_documentation_importer_parse_union (self);
												} else {
													ValaMarkupReader* _tmp34_;
													const gchar* _tmp35_;
													const gchar* _tmp36_;
													_tmp34_ = self->priv->reader;
													_tmp35_ = vala_markup_reader_get_name (_tmp34_);
													_tmp36_ = _tmp35_;
													if (g_strcmp0 (_tmp36_, "constant") == 0) {
														valadoc_importer_gir_documentation_importer_parse_constant (self);
													} else {
														ValaMarkupReader* _tmp37_;
														const gchar* _tmp38_;
														const gchar* _tmp39_;
														_tmp37_ = self->priv->reader;
														_tmp38_ = vala_markup_reader_get_name (_tmp37_);
														_tmp39_ = _tmp38_;
														if (g_strcmp0 (_tmp39_, "docsection") == 0) {
															valadoc_importer_gir_documentation_importer_skip_element (self);
														} else {
															ValaMarkupReader* _tmp40_;
															const gchar* _tmp41_;
															const gchar* _tmp42_;
															gchar* _tmp43_;
															gchar* _tmp44_;
															_tmp40_ = self->priv->reader;
															_tmp41_ = vala_markup_reader_get_name (_tmp40_);
															_tmp42_ = _tmp41_;
															_tmp43_ = g_strdup_printf ("unknown child element `%s' in `namespace'", _tmp42_);
															_tmp44_ = _tmp43_;
															valadoc_importer_gir_documentation_importer_error (self, _tmp44_);
															_g_free0 (_tmp44_);
															valadoc_importer_gir_documentation_importer_skip_element (self);
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	valadoc_importer_gir_documentation_importer_end_element (self, "namespace");
}

static void
valadoc_importer_gir_documentation_importer_parse_alias (ValadocImporterGirDocumentationImporter* self)
{
	gchar* c_identifier = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	ValadocApiGirSourceComment* comment = NULL;
	ValadocApiGirSourceComment* _tmp2_;
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, "alias");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "c:type");
	c_identifier = _tmp1_;
	valadoc_importer_gir_documentation_importer_next (self);
	_tmp2_ = valadoc_importer_gir_documentation_importer_parse_symbol_doc (self);
	comment = _tmp2_;
	valadoc_importer_gir_documentation_importer_attach_comment (self, c_identifier, comment, NULL, (gint) 0, NULL, (gint) 0, NULL, (gint) 0, NULL, (gint) 0, -1);
	valadoc_importer_gir_documentation_importer_parse_type (self, NULL);
	valadoc_importer_gir_documentation_importer_end_element (self, "alias");
	_valadoc_api_source_comment_unref0 (comment);
	_g_free0 (c_identifier);
}

static ValadocApiGirSourceComment*
valadoc_importer_gir_documentation_importer_parse_symbol_doc (ValadocImporterGirDocumentationImporter* self)
{
	ValadocApiGirSourceComment* comment = NULL;
	ValadocApiSourceComment* doc_deprecated = NULL;
	ValadocApiSourceComment* doc_version = NULL;
	ValadocApiSourceComment* doc_stability = NULL;
	ValadocApiGirSourceComment* _tmp32_;
	ValadocApiGirSourceComment* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	comment = NULL;
	doc_deprecated = NULL;
	doc_version = NULL;
	doc_stability = NULL;
	while (TRUE) {
		ValaMarkupTokenType _tmp0_;
		ValaMarkupReader* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp0_ = self->priv->current_token;
		if (!(_tmp0_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp1_ = self->priv->reader;
		_tmp2_ = vala_markup_reader_get_name (_tmp1_);
		_tmp3_ = _tmp2_;
		if (g_strcmp0 (_tmp3_, "doc") == 0) {
			ValaMarkupTokenType _tmp4_;
			valadoc_importer_gir_documentation_importer_start_element (self, "doc");
			valadoc_importer_gir_documentation_importer_next (self);
			_tmp4_ = self->priv->current_token;
			if (_tmp4_ == VALA_MARKUP_TOKEN_TYPE_TEXT) {
				ValaMarkupReader* _tmp5_;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				ValadocApiSourceFile* _tmp8_;
				ValaSourceLocation _tmp9_;
				ValaSourceLocation _tmp10_;
				ValaSourceLocation _tmp11_;
				ValaSourceLocation _tmp12_;
				ValadocApiGirSourceComment* _tmp13_;
				_tmp5_ = self->priv->reader;
				_tmp6_ = vala_markup_reader_get_content (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = self->priv->file;
				_tmp9_ = self->priv->begin;
				_tmp10_ = self->priv->begin;
				_tmp11_ = self->priv->end;
				_tmp12_ = self->priv->end;
				_tmp13_ = valadoc_api_gir_source_comment_new (_tmp7_, _tmp8_, _tmp9_.line, _tmp10_.column, _tmp11_.line, _tmp12_.column);
				_valadoc_api_source_comment_unref0 (comment);
				comment = _tmp13_;
				valadoc_importer_gir_documentation_importer_next (self);
			}
			valadoc_importer_gir_documentation_importer_end_element (self, "doc");
		} else {
			ValaMarkupReader* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			_tmp14_ = self->priv->reader;
			_tmp15_ = vala_markup_reader_get_name (_tmp14_);
			_tmp16_ = _tmp15_;
			if (g_strcmp0 (_tmp16_, "doc-deprecated") == 0) {
				ValadocApiSourceComment* _tmp17_;
				_tmp17_ = valadoc_importer_gir_documentation_importer_parse_doc (self, "doc-deprecated");
				_valadoc_api_source_comment_unref0 (doc_deprecated);
				doc_deprecated = _tmp17_;
			} else {
				ValaMarkupReader* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				_tmp18_ = self->priv->reader;
				_tmp19_ = vala_markup_reader_get_name (_tmp18_);
				_tmp20_ = _tmp19_;
				if (g_strcmp0 (_tmp20_, "doc-version") == 0) {
					ValadocApiSourceComment* _tmp21_;
					_tmp21_ = valadoc_importer_gir_documentation_importer_parse_doc (self, "doc-version");
					_valadoc_api_source_comment_unref0 (doc_version);
					doc_version = _tmp21_;
				} else {
					ValaMarkupReader* _tmp22_;
					const gchar* _tmp23_;
					const gchar* _tmp24_;
					_tmp22_ = self->priv->reader;
					_tmp23_ = vala_markup_reader_get_name (_tmp22_);
					_tmp24_ = _tmp23_;
					if (g_strcmp0 (_tmp24_, "doc-stability") == 0) {
						ValadocApiSourceComment* _tmp25_;
						_tmp25_ = valadoc_importer_gir_documentation_importer_parse_doc (self, "doc-stability");
						_valadoc_api_source_comment_unref0 (doc_stability);
						doc_stability = _tmp25_;
					} else {
						ValaMarkupReader* _tmp26_;
						const gchar* _tmp27_;
						const gchar* _tmp28_;
						_tmp26_ = self->priv->reader;
						_tmp27_ = vala_markup_reader_get_name (_tmp26_);
						_tmp28_ = _tmp27_;
						if (g_strcmp0 (_tmp28_, "source-position") == 0) {
							valadoc_importer_gir_documentation_importer_skip_element (self);
						} else {
							ValaMarkupReader* _tmp29_;
							const gchar* _tmp30_;
							const gchar* _tmp31_;
							_tmp29_ = self->priv->reader;
							_tmp30_ = vala_markup_reader_get_name (_tmp29_);
							_tmp31_ = _tmp30_;
							if (g_strcmp0 (_tmp31_, "attribute") == 0) {
								valadoc_importer_gir_documentation_importer_skip_element (self);
							} else {
								break;
							}
						}
					}
				}
			}
		}
	}
	_tmp32_ = comment;
	if (_tmp32_ != NULL) {
		ValadocApiGirSourceComment* _tmp33_;
		ValadocApiSourceComment* _tmp34_;
		ValadocApiGirSourceComment* _tmp35_;
		ValadocApiSourceComment* _tmp36_;
		ValadocApiGirSourceComment* _tmp37_;
		ValadocApiSourceComment* _tmp38_;
		_tmp33_ = comment;
		_tmp34_ = doc_deprecated;
		valadoc_api_gir_source_comment_set_deprecated_comment (_tmp33_, _tmp34_);
		_tmp35_ = comment;
		_tmp36_ = doc_version;
		valadoc_api_gir_source_comment_set_version_comment (_tmp35_, _tmp36_);
		_tmp37_ = comment;
		_tmp38_ = doc_stability;
		valadoc_api_gir_source_comment_set_stability_comment (_tmp37_, _tmp38_);
	}
	result = comment;
	_valadoc_api_source_comment_unref0 (doc_stability);
	_valadoc_api_source_comment_unref0 (doc_version);
	_valadoc_api_source_comment_unref0 (doc_deprecated);
	return result;
}

static ValadocApiSourceComment*
valadoc_importer_gir_documentation_importer_parse_doc (ValadocImporterGirDocumentationImporter* self,
                                                       const gchar* element_name)
{
	ValaMarkupReader* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	ValadocApiSourceComment* comment = NULL;
	ValaMarkupTokenType _tmp3_;
	ValadocApiSourceComment* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (element_name != NULL, NULL);
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, element_name) != 0) {
		result = NULL;
		return result;
	}
	valadoc_importer_gir_documentation_importer_start_element (self, element_name);
	valadoc_importer_gir_documentation_importer_next (self);
	comment = NULL;
	_tmp3_ = self->priv->current_token;
	if (_tmp3_ == VALA_MARKUP_TOKEN_TYPE_TEXT) {
		ValaMarkupReader* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		ValadocApiSourceFile* _tmp7_;
		ValaSourceLocation _tmp8_;
		ValaSourceLocation _tmp9_;
		ValaSourceLocation _tmp10_;
		ValaSourceLocation _tmp11_;
		ValadocApiSourceComment* _tmp12_;
		_tmp4_ = self->priv->reader;
		_tmp5_ = vala_markup_reader_get_content (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->file;
		_tmp8_ = self->priv->begin;
		_tmp9_ = self->priv->begin;
		_tmp10_ = self->priv->end;
		_tmp11_ = self->priv->end;
		_tmp12_ = valadoc_api_source_comment_new (_tmp6_, _tmp7_, _tmp8_.line, _tmp9_.column, _tmp10_.line, _tmp11_.column);
		_valadoc_api_source_comment_unref0 (comment);
		comment = _tmp12_;
		valadoc_importer_gir_documentation_importer_next (self);
	}
	valadoc_importer_gir_documentation_importer_end_element (self, element_name);
	result = comment;
	return result;
}

static void
valadoc_importer_gir_documentation_importer_parse_enumeration (ValadocImporterGirDocumentationImporter* self,
                                                               const gchar* element_name)
{
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	ValadocApiGirSourceComment* comment = NULL;
	ValadocApiGirSourceComment* _tmp2_;
	const gchar* _tmp3_;
	ValadocApiGirSourceComment* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element_name != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, element_name);
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "c:type");
	_g_free0 (self->priv->parent_c_identifier);
	self->priv->parent_c_identifier = _tmp1_;
	valadoc_importer_gir_documentation_importer_next (self);
	_tmp2_ = valadoc_importer_gir_documentation_importer_parse_symbol_doc (self);
	comment = _tmp2_;
	_tmp3_ = self->priv->parent_c_identifier;
	_tmp4_ = comment;
	valadoc_importer_gir_documentation_importer_attach_comment (self, _tmp3_, _tmp4_, NULL, (gint) 0, NULL, (gint) 0, NULL, (gint) 0, NULL, (gint) 0, -1);
	while (TRUE) {
		ValaMarkupTokenType _tmp5_;
		ValaMarkupReader* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp5_ = self->priv->current_token;
		if (!(_tmp5_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp6_ = self->priv->reader;
		_tmp7_ = vala_markup_reader_get_name (_tmp6_);
		_tmp8_ = _tmp7_;
		if (g_strcmp0 (_tmp8_, "member") == 0) {
			valadoc_importer_gir_documentation_importer_parse_enumeration_member (self);
		} else {
			ValaMarkupReader* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			_tmp9_ = self->priv->reader;
			_tmp10_ = vala_markup_reader_get_name (_tmp9_);
			_tmp11_ = _tmp10_;
			if (g_strcmp0 (_tmp11_, "function") == 0) {
				valadoc_importer_gir_documentation_importer_skip_element (self);
			} else {
				ValaMarkupReader* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp12_ = self->priv->reader;
				_tmp13_ = vala_markup_reader_get_name (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = g_strdup_printf ("unknown child element `%s' in `%s'", _tmp14_, element_name);
				_tmp16_ = _tmp15_;
				valadoc_importer_gir_documentation_importer_error (self, _tmp16_);
				_g_free0 (_tmp16_);
				valadoc_importer_gir_documentation_importer_skip_element (self);
			}
		}
	}
	_g_free0 (self->priv->parent_c_identifier);
	self->priv->parent_c_identifier = NULL;
	valadoc_importer_gir_documentation_importer_end_element (self, element_name);
	_valadoc_api_source_comment_unref0 (comment);
}

static void
valadoc_importer_gir_documentation_importer_parse_bitfield (ValadocImporterGirDocumentationImporter* self)
{
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_parse_enumeration (self, "bitfield");
}

static void
valadoc_importer_gir_documentation_importer_parse_enumeration_member (ValadocImporterGirDocumentationImporter* self)
{
	gchar* c_identifier = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	ValadocApiGirSourceComment* comment = NULL;
	ValadocApiGirSourceComment* _tmp2_;
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, "member");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "c:identifier");
	c_identifier = _tmp1_;
	valadoc_importer_gir_documentation_importer_next (self);
	_tmp2_ = valadoc_importer_gir_documentation_importer_parse_symbol_doc (self);
	comment = _tmp2_;
	valadoc_importer_gir_documentation_importer_attach_comment (self, c_identifier, comment, NULL, (gint) 0, NULL, (gint) 0, NULL, (gint) 0, NULL, (gint) 0, -1);
	valadoc_importer_gir_documentation_importer_end_element (self, "member");
	_valadoc_api_source_comment_unref0 (comment);
	_g_free0 (c_identifier);
}

static void
valadoc_importer_gir_documentation_importer_parse_return_value (ValadocImporterGirDocumentationImporter* self,
                                                                ValadocApiSourceComment* * comment,
                                                                gint* array_length_ret)
{
	ValadocApiSourceComment* _vala_comment = NULL;
	gint _vala_array_length_ret = 0;
	ValadocApiGirSourceComment* _tmp0_;
	gint _tmp1_ = 0;
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, "return-value");
	valadoc_importer_gir_documentation_importer_next (self);
	_tmp0_ = valadoc_importer_gir_documentation_importer_parse_symbol_doc (self);
	_valadoc_api_source_comment_unref0 (_vala_comment);
	_vala_comment = (ValadocApiSourceComment*) _tmp0_;
	valadoc_importer_gir_documentation_importer_parse_type (self, &_tmp1_);
	_vala_array_length_ret = _tmp1_;
	valadoc_importer_gir_documentation_importer_end_element (self, "return-value");
	if (comment) {
		*comment = _vala_comment;
	} else {
		_valadoc_api_source_comment_unref0 (_vala_comment);
	}
	if (array_length_ret) {
		*array_length_ret = _vala_array_length_ret;
	}
}

static void
valadoc_importer_gir_documentation_importer_parse_parameter (ValadocImporterGirDocumentationImporter* self,
                                                             ValadocApiSourceComment* * comment,
                                                             gchar* * param_name,
                                                             gint* destroy_pos,
                                                             gint* closure_pos,
                                                             gint* array_length_pos)
{
	ValadocApiSourceComment* _vala_comment = NULL;
	gchar* _vala_param_name = NULL;
	gint _vala_destroy_pos = 0;
	gint _vala_closure_pos = 0;
	gint _vala_array_length_pos = 0;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	gchar* closure = NULL;
	ValaMarkupReader* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* destroy = NULL;
	ValaMarkupReader* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	ValadocApiGirSourceComment* _tmp10_;
	ValaMarkupReader* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, "parameter");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "name");
	_g_free0 (_vala_param_name);
	_vala_param_name = _tmp1_;
	_vala_array_length_pos = -1;
	_vala_destroy_pos = -1;
	_vala_closure_pos = -1;
	_tmp2_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_get_attribute (_tmp2_, "closure");
	closure = _tmp3_;
	_tmp4_ = closure;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		_tmp5_ = closure;
		_vala_closure_pos = atoi (_tmp5_);
		if (_vala_closure_pos < 0) {
			valadoc_importer_gir_documentation_importer_warning (self, "invalid closure position");
		}
	}
	_tmp6_ = self->priv->reader;
	_tmp7_ = vala_markup_reader_get_attribute (_tmp6_, "destroy");
	destroy = _tmp7_;
	_tmp8_ = destroy;
	if (_tmp8_ != NULL) {
		const gchar* _tmp9_;
		_tmp9_ = destroy;
		_vala_destroy_pos = atoi (_tmp9_);
		if (_vala_destroy_pos < 0) {
			valadoc_importer_gir_documentation_importer_warning (self, "invalid destroy position");
		}
	}
	valadoc_importer_gir_documentation_importer_next (self);
	_tmp10_ = valadoc_importer_gir_documentation_importer_parse_symbol_doc (self);
	_valadoc_api_source_comment_unref0 (_vala_comment);
	_vala_comment = (ValadocApiSourceComment*) _tmp10_;
	_tmp11_ = self->priv->reader;
	_tmp12_ = vala_markup_reader_get_name (_tmp11_);
	_tmp13_ = _tmp12_;
	if (g_strcmp0 (_tmp13_, "varargs") == 0) {
		gchar* _tmp14_;
		valadoc_importer_gir_documentation_importer_start_element (self, "varargs");
		_tmp14_ = g_strdup ("...");
		_g_free0 (_vala_param_name);
		_vala_param_name = _tmp14_;
		valadoc_importer_gir_documentation_importer_next (self);
		valadoc_importer_gir_documentation_importer_end_element (self, "varargs");
	} else {
		gint _tmp15_ = 0;
		valadoc_importer_gir_documentation_importer_parse_type (self, &_tmp15_);
		_vala_array_length_pos = _tmp15_;
	}
	valadoc_importer_gir_documentation_importer_end_element (self, "parameter");
	_g_free0 (destroy);
	_g_free0 (closure);
	if (comment) {
		*comment = _vala_comment;
	} else {
		_valadoc_api_source_comment_unref0 (_vala_comment);
	}
	if (param_name) {
		*param_name = _vala_param_name;
	} else {
		_g_free0 (_vala_param_name);
	}
	if (destroy_pos) {
		*destroy_pos = _vala_destroy_pos;
	}
	if (closure_pos) {
		*closure_pos = _vala_closure_pos;
	}
	if (array_length_pos) {
		*array_length_pos = _vala_array_length_pos;
	}
}

static void
valadoc_importer_gir_documentation_importer_parse_type (ValadocImporterGirDocumentationImporter* self,
                                                        gint* array_length_pos)
{
	gint _vala_array_length_pos = 0;
	ValaMarkupReader* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_vala_array_length_pos = -1;
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, "array") == 0) {
		gchar* length = NULL;
		ValaMarkupReader* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp3_ = self->priv->reader;
		_tmp4_ = vala_markup_reader_get_attribute (_tmp3_, "length");
		length = _tmp4_;
		_tmp5_ = length;
		if (_tmp5_ != NULL) {
			const gchar* _tmp6_;
			_tmp6_ = length;
			_vala_array_length_pos = atoi (_tmp6_);
			if (_vala_array_length_pos < 0) {
				valadoc_importer_gir_documentation_importer_warning (self, "invalid array length position");
			}
		}
		valadoc_importer_gir_documentation_importer_skip_element (self);
		_g_free0 (length);
	} else {
		valadoc_importer_gir_documentation_importer_skip_element (self);
	}
	if (array_length_pos) {
		*array_length_pos = _vala_array_length_pos;
	}
}

static void
valadoc_importer_gir_documentation_importer_parse_record (ValadocImporterGirDocumentationImporter* self)
{
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp5_;
	gboolean is_type_struct = FALSE;
	ValaMarkupReader* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	ValadocApiGirSourceComment* comment = NULL;
	ValadocApiGirSourceComment* _tmp10_;
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, "record");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "c:type");
	_g_free0 (self->priv->parent_c_identifier);
	self->priv->parent_c_identifier = _tmp1_;
	_tmp2_ = self->priv->parent_c_identifier;
	if (_tmp2_ == NULL) {
		ValaMarkupReader* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->priv->reader;
		_tmp4_ = vala_markup_reader_get_attribute (_tmp3_, "glib:type-name");
		_g_free0 (self->priv->parent_c_identifier);
		self->priv->parent_c_identifier = _tmp4_;
	}
	_tmp5_ = self->priv->parent_c_identifier;
	if (g_str_has_suffix (_tmp5_, "Private")) {
		_g_free0 (self->priv->parent_c_identifier);
		self->priv->parent_c_identifier = NULL;
		valadoc_importer_gir_documentation_importer_skip_element (self);
		return;
	}
	_tmp6_ = self->priv->reader;
	_tmp7_ = vala_markup_reader_get_attribute (_tmp6_, "glib:is-gtype-struct-for");
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_ != NULL;
	_g_free0 (_tmp8_);
	is_type_struct = _tmp9_;
	valadoc_importer_gir_documentation_importer_next (self);
	_tmp10_ = valadoc_importer_gir_documentation_importer_parse_symbol_doc (self);
	comment = _tmp10_;
	if (is_type_struct == FALSE) {
		const gchar* _tmp11_;
		ValadocApiGirSourceComment* _tmp12_;
		_tmp11_ = self->priv->parent_c_identifier;
		_tmp12_ = comment;
		valadoc_importer_gir_documentation_importer_attach_comment (self, _tmp11_, _tmp12_, NULL, (gint) 0, NULL, (gint) 0, NULL, (gint) 0, NULL, (gint) 0, -1);
	}
	while (TRUE) {
		ValaMarkupTokenType _tmp13_;
		ValaMarkupReader* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp13_ = self->priv->current_token;
		if (!(_tmp13_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp14_ = self->priv->reader;
		_tmp15_ = vala_markup_reader_get_name (_tmp14_);
		_tmp16_ = _tmp15_;
		if (g_strcmp0 (_tmp16_, "field") == 0) {
			valadoc_importer_gir_documentation_importer_parse_field (self);
		} else {
			ValaMarkupReader* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			_tmp17_ = self->priv->reader;
			_tmp18_ = vala_markup_reader_get_name (_tmp17_);
			_tmp19_ = _tmp18_;
			if (g_strcmp0 (_tmp19_, "constructor") == 0) {
				valadoc_importer_gir_documentation_importer_parse_constructor (self);
			} else {
				ValaMarkupReader* _tmp20_;
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				_tmp20_ = self->priv->reader;
				_tmp21_ = vala_markup_reader_get_name (_tmp20_);
				_tmp22_ = _tmp21_;
				if (g_strcmp0 (_tmp22_, "method") == 0) {
					valadoc_importer_gir_documentation_importer_parse_method (self, "method");
				} else {
					ValaMarkupReader* _tmp23_;
					const gchar* _tmp24_;
					const gchar* _tmp25_;
					_tmp23_ = self->priv->reader;
					_tmp24_ = vala_markup_reader_get_name (_tmp23_);
					_tmp25_ = _tmp24_;
					if (g_strcmp0 (_tmp25_, "function") == 0) {
						valadoc_importer_gir_documentation_importer_skip_element (self);
					} else {
						ValaMarkupReader* _tmp26_;
						const gchar* _tmp27_;
						const gchar* _tmp28_;
						_tmp26_ = self->priv->reader;
						_tmp27_ = vala_markup_reader_get_name (_tmp26_);
						_tmp28_ = _tmp27_;
						if (g_strcmp0 (_tmp28_, "union") == 0) {
							valadoc_importer_gir_documentation_importer_parse_union (self);
						} else {
							ValaMarkupReader* _tmp29_;
							const gchar* _tmp30_;
							const gchar* _tmp31_;
							gchar* _tmp32_;
							gchar* _tmp33_;
							_tmp29_ = self->priv->reader;
							_tmp30_ = vala_markup_reader_get_name (_tmp29_);
							_tmp31_ = _tmp30_;
							_tmp32_ = g_strdup_printf ("unknown child element `%s' in `record'", _tmp31_);
							_tmp33_ = _tmp32_;
							valadoc_importer_gir_documentation_importer_error (self, _tmp33_);
							_g_free0 (_tmp33_);
							valadoc_importer_gir_documentation_importer_skip_element (self);
						}
					}
				}
			}
		}
	}
	_g_free0 (self->priv->parent_c_identifier);
	self->priv->parent_c_identifier = NULL;
	valadoc_importer_gir_documentation_importer_end_element (self, "record");
	_valadoc_api_source_comment_unref0 (comment);
}

static void
valadoc_importer_gir_documentation_importer_parse_class (ValadocImporterGirDocumentationImporter* self)
{
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	ValadocApiGirSourceComment* comment = NULL;
	ValadocApiGirSourceComment* _tmp5_;
	const gchar* _tmp6_;
	ValadocApiGirSourceComment* _tmp7_;
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, "class");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "c:type");
	_g_free0 (self->priv->parent_c_identifier);
	self->priv->parent_c_identifier = _tmp1_;
	_tmp2_ = self->priv->parent_c_identifier;
	if (_tmp2_ == NULL) {
		ValaMarkupReader* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->priv->reader;
		_tmp4_ = vala_markup_reader_get_attribute (_tmp3_, "glib:type-name");
		_g_free0 (self->priv->parent_c_identifier);
		self->priv->parent_c_identifier = _tmp4_;
	}
	valadoc_importer_gir_documentation_importer_next (self);
	_tmp5_ = valadoc_importer_gir_documentation_importer_parse_symbol_doc (self);
	comment = _tmp5_;
	_tmp6_ = self->priv->parent_c_identifier;
	_tmp7_ = comment;
	valadoc_importer_gir_documentation_importer_attach_comment (self, _tmp6_, _tmp7_, NULL, (gint) 0, NULL, (gint) 0, NULL, (gint) 0, NULL, (gint) 0, -1);
	while (TRUE) {
		ValaMarkupTokenType _tmp8_;
		ValaMarkupReader* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp8_ = self->priv->current_token;
		if (!(_tmp8_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp9_ = self->priv->reader;
		_tmp10_ = vala_markup_reader_get_name (_tmp9_);
		_tmp11_ = _tmp10_;
		if (g_strcmp0 (_tmp11_, "implements") == 0) {
			valadoc_importer_gir_documentation_importer_skip_element (self);
		} else {
			ValaMarkupReader* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			_tmp12_ = self->priv->reader;
			_tmp13_ = vala_markup_reader_get_name (_tmp12_);
			_tmp14_ = _tmp13_;
			if (g_strcmp0 (_tmp14_, "constant") == 0) {
				valadoc_importer_gir_documentation_importer_parse_constant (self);
			} else {
				ValaMarkupReader* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				_tmp15_ = self->priv->reader;
				_tmp16_ = vala_markup_reader_get_name (_tmp15_);
				_tmp17_ = _tmp16_;
				if (g_strcmp0 (_tmp17_, "field") == 0) {
					valadoc_importer_gir_documentation_importer_parse_field (self);
				} else {
					ValaMarkupReader* _tmp18_;
					const gchar* _tmp19_;
					const gchar* _tmp20_;
					_tmp18_ = self->priv->reader;
					_tmp19_ = vala_markup_reader_get_name (_tmp18_);
					_tmp20_ = _tmp19_;
					if (g_strcmp0 (_tmp20_, "property") == 0) {
						valadoc_importer_gir_documentation_importer_parse_property (self);
					} else {
						ValaMarkupReader* _tmp21_;
						const gchar* _tmp22_;
						const gchar* _tmp23_;
						_tmp21_ = self->priv->reader;
						_tmp22_ = vala_markup_reader_get_name (_tmp21_);
						_tmp23_ = _tmp22_;
						if (g_strcmp0 (_tmp23_, "constructor") == 0) {
							valadoc_importer_gir_documentation_importer_parse_constructor (self);
						} else {
							ValaMarkupReader* _tmp24_;
							const gchar* _tmp25_;
							const gchar* _tmp26_;
							_tmp24_ = self->priv->reader;
							_tmp25_ = vala_markup_reader_get_name (_tmp24_);
							_tmp26_ = _tmp25_;
							if (g_strcmp0 (_tmp26_, "function") == 0) {
								valadoc_importer_gir_documentation_importer_parse_method (self, "function");
							} else {
								ValaMarkupReader* _tmp27_;
								const gchar* _tmp28_;
								const gchar* _tmp29_;
								_tmp27_ = self->priv->reader;
								_tmp28_ = vala_markup_reader_get_name (_tmp27_);
								_tmp29_ = _tmp28_;
								if (g_strcmp0 (_tmp29_, "method") == 0) {
									valadoc_importer_gir_documentation_importer_parse_method (self, "method");
								} else {
									ValaMarkupReader* _tmp30_;
									const gchar* _tmp31_;
									const gchar* _tmp32_;
									_tmp30_ = self->priv->reader;
									_tmp31_ = vala_markup_reader_get_name (_tmp30_);
									_tmp32_ = _tmp31_;
									if (g_strcmp0 (_tmp32_, "virtual-method") == 0) {
										valadoc_importer_gir_documentation_importer_parse_method (self, "virtual-method");
									} else {
										ValaMarkupReader* _tmp33_;
										const gchar* _tmp34_;
										const gchar* _tmp35_;
										_tmp33_ = self->priv->reader;
										_tmp34_ = vala_markup_reader_get_name (_tmp33_);
										_tmp35_ = _tmp34_;
										if (g_strcmp0 (_tmp35_, "union") == 0) {
											valadoc_importer_gir_documentation_importer_parse_union (self);
										} else {
											ValaMarkupReader* _tmp36_;
											const gchar* _tmp37_;
											const gchar* _tmp38_;
											_tmp36_ = self->priv->reader;
											_tmp37_ = vala_markup_reader_get_name (_tmp36_);
											_tmp38_ = _tmp37_;
											if (g_strcmp0 (_tmp38_, "glib:signal") == 0) {
												valadoc_importer_gir_documentation_importer_parse_signal (self);
											} else {
												ValaMarkupReader* _tmp39_;
												const gchar* _tmp40_;
												const gchar* _tmp41_;
												gchar* _tmp42_;
												gchar* _tmp43_;
												_tmp39_ = self->priv->reader;
												_tmp40_ = vala_markup_reader_get_name (_tmp39_);
												_tmp41_ = _tmp40_;
												_tmp42_ = g_strdup_printf ("unknown child element `%s' in `class'", _tmp41_);
												_tmp43_ = _tmp42_;
												valadoc_importer_gir_documentation_importer_error (self, _tmp43_);
												_g_free0 (_tmp43_);
												valadoc_importer_gir_documentation_importer_skip_element (self);
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_g_free0 (self->priv->parent_c_identifier);
	self->priv->parent_c_identifier = NULL;
	valadoc_importer_gir_documentation_importer_end_element (self, "class");
	_valadoc_api_source_comment_unref0 (comment);
}

static void
valadoc_importer_gir_documentation_importer_parse_interface (ValadocImporterGirDocumentationImporter* self)
{
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	ValadocApiGirSourceComment* comment = NULL;
	ValadocApiGirSourceComment* _tmp5_;
	const gchar* _tmp6_;
	ValadocApiGirSourceComment* _tmp7_;
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, "interface");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "c:type");
	_g_free0 (self->priv->parent_c_identifier);
	self->priv->parent_c_identifier = _tmp1_;
	_tmp2_ = self->priv->parent_c_identifier;
	if (_tmp2_ == NULL) {
		ValaMarkupReader* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->priv->reader;
		_tmp4_ = vala_markup_reader_get_attribute (_tmp3_, "glib:type-name");
		_g_free0 (self->priv->parent_c_identifier);
		self->priv->parent_c_identifier = _tmp4_;
	}
	valadoc_importer_gir_documentation_importer_next (self);
	_tmp5_ = valadoc_importer_gir_documentation_importer_parse_symbol_doc (self);
	comment = _tmp5_;
	_tmp6_ = self->priv->parent_c_identifier;
	_tmp7_ = comment;
	valadoc_importer_gir_documentation_importer_attach_comment (self, _tmp6_, _tmp7_, NULL, (gint) 0, NULL, (gint) 0, NULL, (gint) 0, NULL, (gint) 0, -1);
	while (TRUE) {
		ValaMarkupTokenType _tmp8_;
		ValaMarkupReader* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp8_ = self->priv->current_token;
		if (!(_tmp8_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp9_ = self->priv->reader;
		_tmp10_ = vala_markup_reader_get_name (_tmp9_);
		_tmp11_ = _tmp10_;
		if (g_strcmp0 (_tmp11_, "prerequisite") == 0) {
			valadoc_importer_gir_documentation_importer_skip_element (self);
		} else {
			ValaMarkupReader* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			_tmp12_ = self->priv->reader;
			_tmp13_ = vala_markup_reader_get_name (_tmp12_);
			_tmp14_ = _tmp13_;
			if (g_strcmp0 (_tmp14_, "field") == 0) {
				valadoc_importer_gir_documentation_importer_parse_field (self);
			} else {
				ValaMarkupReader* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				_tmp15_ = self->priv->reader;
				_tmp16_ = vala_markup_reader_get_name (_tmp15_);
				_tmp17_ = _tmp16_;
				if (g_strcmp0 (_tmp17_, "property") == 0) {
					valadoc_importer_gir_documentation_importer_parse_property (self);
				} else {
					ValaMarkupReader* _tmp18_;
					const gchar* _tmp19_;
					const gchar* _tmp20_;
					_tmp18_ = self->priv->reader;
					_tmp19_ = vala_markup_reader_get_name (_tmp18_);
					_tmp20_ = _tmp19_;
					if (g_strcmp0 (_tmp20_, "virtual-method") == 0) {
						valadoc_importer_gir_documentation_importer_parse_method (self, "virtual-method");
					} else {
						ValaMarkupReader* _tmp21_;
						const gchar* _tmp22_;
						const gchar* _tmp23_;
						_tmp21_ = self->priv->reader;
						_tmp22_ = vala_markup_reader_get_name (_tmp21_);
						_tmp23_ = _tmp22_;
						if (g_strcmp0 (_tmp23_, "function") == 0) {
							valadoc_importer_gir_documentation_importer_parse_method (self, "function");
						} else {
							ValaMarkupReader* _tmp24_;
							const gchar* _tmp25_;
							const gchar* _tmp26_;
							_tmp24_ = self->priv->reader;
							_tmp25_ = vala_markup_reader_get_name (_tmp24_);
							_tmp26_ = _tmp25_;
							if (g_strcmp0 (_tmp26_, "method") == 0) {
								valadoc_importer_gir_documentation_importer_parse_method (self, "method");
							} else {
								ValaMarkupReader* _tmp27_;
								const gchar* _tmp28_;
								const gchar* _tmp29_;
								_tmp27_ = self->priv->reader;
								_tmp28_ = vala_markup_reader_get_name (_tmp27_);
								_tmp29_ = _tmp28_;
								if (g_strcmp0 (_tmp29_, "glib:signal") == 0) {
									valadoc_importer_gir_documentation_importer_parse_signal (self);
								} else {
									ValaMarkupReader* _tmp30_;
									const gchar* _tmp31_;
									const gchar* _tmp32_;
									gchar* _tmp33_;
									gchar* _tmp34_;
									_tmp30_ = self->priv->reader;
									_tmp31_ = vala_markup_reader_get_name (_tmp30_);
									_tmp32_ = _tmp31_;
									_tmp33_ = g_strdup_printf ("unknown child element `%s' in `interface'", _tmp32_);
									_tmp34_ = _tmp33_;
									valadoc_importer_gir_documentation_importer_error (self, _tmp34_);
									_g_free0 (_tmp34_);
									valadoc_importer_gir_documentation_importer_skip_element (self);
								}
							}
						}
					}
				}
			}
		}
	}
	_g_free0 (self->priv->parent_c_identifier);
	self->priv->parent_c_identifier = NULL;
	valadoc_importer_gir_documentation_importer_end_element (self, "interface");
	_valadoc_api_source_comment_unref0 (comment);
}

static void
valadoc_importer_gir_documentation_importer_parse_field (ValadocImporterGirDocumentationImporter* self)
{
	gchar* c_identifier = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	ValadocApiGirSourceComment* _tmp8_;
	ValadocApiGirSourceComment* _tmp9_;
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, "field");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "name");
	c_identifier = _tmp1_;
	_tmp2_ = self->priv->parent_c_identifier;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp3_ = self->priv->parent_c_identifier;
		_tmp4_ = g_strconcat (_tmp3_, ".", NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = c_identifier;
		_tmp7_ = g_strconcat (_tmp5_, _tmp6_, NULL);
		_g_free0 (c_identifier);
		c_identifier = _tmp7_;
		_g_free0 (_tmp5_);
	}
	valadoc_importer_gir_documentation_importer_next (self);
	_tmp8_ = valadoc_importer_gir_documentation_importer_parse_symbol_doc (self);
	_tmp9_ = _tmp8_;
	_valadoc_api_source_comment_unref0 (_tmp9_);
	valadoc_importer_gir_documentation_importer_parse_type (self, NULL);
	valadoc_importer_gir_documentation_importer_end_element (self, "field");
	_g_free0 (c_identifier);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
valadoc_importer_gir_documentation_importer_parse_property (ValadocImporterGirDocumentationImporter* self)
{
	gchar* c_identifier = NULL;
	const gchar* _tmp0_;
	ValaMarkupReader* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	ValadocApiGirSourceComment* comment = NULL;
	ValadocApiGirSourceComment* _tmp8_;
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, "property");
	_tmp0_ = self->priv->parent_c_identifier;
	_tmp1_ = self->priv->reader;
	_tmp2_ = vala_markup_reader_get_attribute (_tmp1_, "name");
	_tmp3_ = _tmp2_;
	_tmp4_ = string_replace (_tmp3_, "-", "_");
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("%s:%s", _tmp0_, _tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	c_identifier = _tmp7_;
	valadoc_importer_gir_documentation_importer_next (self);
	_tmp8_ = valadoc_importer_gir_documentation_importer_parse_symbol_doc (self);
	comment = _tmp8_;
	valadoc_importer_gir_documentation_importer_attach_comment (self, c_identifier, comment, NULL, (gint) 0, NULL, (gint) 0, NULL, (gint) 0, NULL, (gint) 0, -1);
	valadoc_importer_gir_documentation_importer_parse_type (self, NULL);
	valadoc_importer_gir_documentation_importer_end_element (self, "property");
	_valadoc_api_source_comment_unref0 (comment);
	_g_free0 (c_identifier);
}

static void
valadoc_importer_gir_documentation_importer_parse_callback (ValadocImporterGirDocumentationImporter* self)
{
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_parse_function (self, "callback");
}

static void
valadoc_importer_gir_documentation_importer_parse_constructor (ValadocImporterGirDocumentationImporter* self)
{
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_parse_function (self, "constructor");
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add4 (ValadocImporterGirDocumentationImporterImplicitParameterPos* * array,
                  gint* length,
                  gint* size,
                  const ValadocImporterGirDocumentationImporterImplicitParameterPos* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValadocImporterGirDocumentationImporterImplicitParameterPos, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add5 (ValadocImporterGirDocumentationImporterImplicitParameterPos* * array,
                  gint* length,
                  gint* size,
                  const ValadocImporterGirDocumentationImporterImplicitParameterPos* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValadocImporterGirDocumentationImporterImplicitParameterPos, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add6 (ValadocImporterGirDocumentationImporterImplicitParameterPos* * array,
                  gint* length,
                  gint* size,
                  const ValadocImporterGirDocumentationImporterImplicitParameterPos* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValadocImporterGirDocumentationImporterImplicitParameterPos, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
valadoc_importer_gir_documentation_importer_parse_function (ValadocImporterGirDocumentationImporter* self,
                                                            const gchar* element_name)
{
	gchar* c_identifier = NULL;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	ValadocApiGirSourceComment* comment = NULL;
	ValadocApiGirSourceComment* _tmp24_;
	ValadocImporterGirDocumentationImporterImplicitParameterPos* destroy_notifies = NULL;
	ValadocImporterGirDocumentationImporterImplicitParameterPos* _tmp25_;
	gint destroy_notifies_length1;
	gint _destroy_notifies_size_;
	ValadocImporterGirDocumentationImporterImplicitParameterPos* array_lengths = NULL;
	ValadocImporterGirDocumentationImporterImplicitParameterPos* _tmp26_;
	gint array_lengths_length1;
	gint _array_lengths_size_;
	ValadocImporterGirDocumentationImporterImplicitParameterPos* closures = NULL;
	ValadocImporterGirDocumentationImporterImplicitParameterPos* _tmp27_;
	gint closures_length1;
	gint _closures_size_;
	gchar** param_names = NULL;
	gchar** _tmp28_;
	gint param_names_length1;
	gint _param_names_size_;
	gint array_length_ret = 0;
	gboolean _tmp29_ = FALSE;
	ValaMarkupTokenType _tmp30_;
	gboolean _tmp46_ = FALSE;
	ValaMarkupTokenType _tmp47_;
	const gchar* _tmp99_;
	ValadocApiGirSourceComment* _tmp100_;
	gchar** _tmp101_;
	gint _tmp101__length1;
	ValadocImporterGirDocumentationImporterImplicitParameterPos* _tmp102_;
	gint _tmp102__length1;
	ValadocImporterGirDocumentationImporterImplicitParameterPos* _tmp103_;
	gint _tmp103__length1;
	ValadocImporterGirDocumentationImporterImplicitParameterPos* _tmp104_;
	gint _tmp104__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element_name != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, element_name);
	c_identifier = NULL;
	_tmp0_ = element_name;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (((_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("constructor")))) || (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("function"))))) || (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("method"))))) {
		switch (0) {
			default:
			{
				ValaMarkupReader* _tmp3_;
				gchar* _tmp4_;
				_tmp3_ = self->priv->reader;
				_tmp4_ = vala_markup_reader_get_attribute (_tmp3_, "c:identifier");
				_g_free0 (c_identifier);
				c_identifier = _tmp4_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("callback")))) {
		switch (0) {
			default:
			{
				ValaMarkupReader* _tmp5_;
				gchar* _tmp6_;
				const gchar* _tmp7_;
				_tmp5_ = self->priv->reader;
				_tmp6_ = vala_markup_reader_get_attribute (_tmp5_, "c:type");
				_g_free0 (c_identifier);
				c_identifier = _tmp6_;
				_tmp7_ = c_identifier;
				if (_tmp7_ == NULL) {
					ValaMarkupReader* _tmp8_;
					gchar* _tmp9_;
					_tmp8_ = self->priv->reader;
					_tmp9_ = vala_markup_reader_get_attribute (_tmp8_, "name");
					_g_free0 (c_identifier);
					c_identifier = _tmp9_;
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("virtual-method")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp10_;
				ValaMarkupReader* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp10_ = self->priv->parent_c_identifier;
				_tmp11_ = self->priv->reader;
				_tmp12_ = vala_markup_reader_get_attribute (_tmp11_, "name");
				_tmp13_ = _tmp12_;
				_tmp14_ = string_replace (_tmp13_, "-", "_");
				_tmp15_ = _tmp14_;
				_tmp16_ = g_strdup_printf ("%s->%s", _tmp10_, _tmp15_);
				_g_free0 (c_identifier);
				c_identifier = _tmp16_;
				_g_free0 (_tmp15_);
				_g_free0 (_tmp13_);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("glib:signal")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp17_;
				ValaMarkupReader* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				_tmp17_ = self->priv->parent_c_identifier;
				_tmp18_ = self->priv->reader;
				_tmp19_ = vala_markup_reader_get_attribute (_tmp18_, "name");
				_tmp20_ = _tmp19_;
				_tmp21_ = string_replace (_tmp20_, "-", "_");
				_tmp22_ = _tmp21_;
				_tmp23_ = g_strdup_printf ("%s::%s", _tmp17_, _tmp22_);
				_g_free0 (c_identifier);
				c_identifier = _tmp23_;
				_g_free0 (_tmp22_);
				_g_free0 (_tmp20_);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				valadoc_importer_gir_documentation_importer_skip_element (self);
				_g_free0 (c_identifier);
				return;
			}
		}
	}
	valadoc_importer_gir_documentation_importer_next (self);
	_tmp24_ = valadoc_importer_gir_documentation_importer_parse_symbol_doc (self);
	comment = _tmp24_;
	_tmp25_ = g_new0 (ValadocImporterGirDocumentationImporterImplicitParameterPos, 0);
	destroy_notifies = _tmp25_;
	destroy_notifies_length1 = 0;
	_destroy_notifies_size_ = destroy_notifies_length1;
	_tmp26_ = g_new0 (ValadocImporterGirDocumentationImporterImplicitParameterPos, 0);
	array_lengths = _tmp26_;
	array_lengths_length1 = 0;
	_array_lengths_size_ = array_lengths_length1;
	_tmp27_ = g_new0 (ValadocImporterGirDocumentationImporterImplicitParameterPos, 0);
	closures = _tmp27_;
	closures_length1 = 0;
	_closures_size_ = closures_length1;
	_tmp28_ = g_new0 (gchar*, 0 + 1);
	param_names = _tmp28_;
	param_names_length1 = 0;
	_param_names_size_ = param_names_length1;
	array_length_ret = -1;
	_tmp30_ = self->priv->current_token;
	if (_tmp30_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		ValaMarkupReader* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp31_ = self->priv->reader;
		_tmp32_ = vala_markup_reader_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp29_ = g_strcmp0 (_tmp33_, "return-value") == 0;
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		ValadocApiSourceComment* return_comment = NULL;
		ValadocApiSourceComment* _tmp34_ = NULL;
		gint _tmp35_ = 0;
		ValadocApiSourceComment* _tmp36_;
		valadoc_importer_gir_documentation_importer_parse_return_value (self, &_tmp34_, &_tmp35_);
		_valadoc_api_source_comment_unref0 (return_comment);
		return_comment = _tmp34_;
		array_length_ret = _tmp35_;
		_tmp36_ = return_comment;
		if (_tmp36_ != NULL) {
			ValadocApiGirSourceComment* _tmp37_;
			ValadocApiGirSourceComment* _tmp44_;
			ValadocApiSourceComment* _tmp45_;
			_tmp37_ = comment;
			if (_tmp37_ == NULL) {
				ValadocApiSourceFile* _tmp38_;
				ValaSourceLocation _tmp39_;
				ValaSourceLocation _tmp40_;
				ValaSourceLocation _tmp41_;
				ValaSourceLocation _tmp42_;
				ValadocApiGirSourceComment* _tmp43_;
				_tmp38_ = self->priv->file;
				_tmp39_ = self->priv->begin;
				_tmp40_ = self->priv->begin;
				_tmp41_ = self->priv->end;
				_tmp42_ = self->priv->end;
				_tmp43_ = valadoc_api_gir_source_comment_new ("", _tmp38_, _tmp39_.line, _tmp40_.column, _tmp41_.line, _tmp42_.column);
				_valadoc_api_source_comment_unref0 (comment);
				comment = _tmp43_;
			}
			_tmp44_ = comment;
			_tmp45_ = return_comment;
			valadoc_api_gir_source_comment_set_return_comment (_tmp44_, _tmp45_);
		}
		_valadoc_api_source_comment_unref0 (return_comment);
	}
	_tmp47_ = self->priv->current_token;
	if (_tmp47_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		ValaMarkupReader* _tmp48_;
		const gchar* _tmp49_;
		const gchar* _tmp50_;
		_tmp48_ = self->priv->reader;
		_tmp49_ = vala_markup_reader_get_name (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp46_ = g_strcmp0 (_tmp50_, "parameters") == 0;
	} else {
		_tmp46_ = FALSE;
	}
	if (_tmp46_) {
		gboolean _tmp51_ = FALSE;
		ValaMarkupTokenType _tmp52_;
		valadoc_importer_gir_documentation_importer_start_element (self, "parameters");
		valadoc_importer_gir_documentation_importer_next (self);
		_tmp52_ = self->priv->current_token;
		if (_tmp52_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
			ValaMarkupReader* _tmp53_;
			const gchar* _tmp54_;
			const gchar* _tmp55_;
			_tmp53_ = self->priv->reader;
			_tmp54_ = vala_markup_reader_get_name (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp51_ = g_strcmp0 (_tmp55_, "instance-parameter") == 0;
		} else {
			_tmp51_ = FALSE;
		}
		if (_tmp51_) {
			gchar* instance_param_name = NULL;
			ValaMarkupReader* _tmp56_;
			gchar* _tmp57_;
			ValadocApiSourceComment* param_comment = NULL;
			ValadocApiGirSourceComment* _tmp58_;
			ValadocApiSourceComment* _tmp59_;
			_tmp56_ = self->priv->reader;
			_tmp57_ = vala_markup_reader_get_attribute (_tmp56_, "name");
			instance_param_name = _tmp57_;
			valadoc_importer_gir_documentation_importer_next (self);
			_tmp58_ = valadoc_importer_gir_documentation_importer_parse_symbol_doc (self);
			param_comment = (ValadocApiSourceComment*) _tmp58_;
			valadoc_importer_gir_documentation_importer_parse_type (self, NULL);
			valadoc_importer_gir_documentation_importer_end_element (self, "instance-parameter");
			_tmp59_ = param_comment;
			if (_tmp59_ != NULL) {
				ValadocApiGirSourceComment* _tmp60_;
				ValadocApiGirSourceComment* _tmp67_;
				const gchar* _tmp68_;
				ValadocApiSourceComment* _tmp69_;
				ValadocApiGirSourceComment* _tmp70_;
				const gchar* _tmp71_;
				_tmp60_ = comment;
				if (_tmp60_ == NULL) {
					ValadocApiSourceFile* _tmp61_;
					ValaSourceLocation _tmp62_;
					ValaSourceLocation _tmp63_;
					ValaSourceLocation _tmp64_;
					ValaSourceLocation _tmp65_;
					ValadocApiGirSourceComment* _tmp66_;
					_tmp61_ = self->priv->file;
					_tmp62_ = self->priv->begin;
					_tmp63_ = self->priv->begin;
					_tmp64_ = self->priv->end;
					_tmp65_ = self->priv->end;
					_tmp66_ = valadoc_api_gir_source_comment_new ("", _tmp61_, _tmp62_.line, _tmp63_.column, _tmp64_.line, _tmp65_.column);
					_valadoc_api_source_comment_unref0 (comment);
					comment = _tmp66_;
				}
				_tmp67_ = comment;
				_tmp68_ = instance_param_name;
				_tmp69_ = param_comment;
				valadoc_api_gir_source_comment_add_parameter_content (_tmp67_, _tmp68_, _tmp69_);
				_tmp70_ = comment;
				_tmp71_ = instance_param_name;
				valadoc_api_gir_source_comment_set_instance_param_name (_tmp70_, _tmp71_);
			}
			_valadoc_api_source_comment_unref0 (param_comment);
			_g_free0 (instance_param_name);
		}
		{
			gint pcount = 0;
			pcount = 0;
			{
				gboolean _tmp72_ = FALSE;
				_tmp72_ = TRUE;
				while (TRUE) {
					ValaMarkupTokenType _tmp74_;
					ValadocApiSourceComment* param_comment = NULL;
					gint array_length_pos = 0;
					gint destroy_pos = 0;
					gint closure_pos = 0;
					gchar* param_name = NULL;
					ValadocApiSourceComment* _tmp75_ = NULL;
					gchar* _tmp76_ = NULL;
					gint _tmp77_ = 0;
					gint _tmp78_ = 0;
					gint _tmp79_ = 0;
					const gchar* _tmp80_;
					gchar* _tmp81_;
					gboolean _tmp82_ = FALSE;
					gboolean _tmp84_ = FALSE;
					gboolean _tmp86_ = FALSE;
					ValadocApiSourceComment* _tmp88_;
					if (!_tmp72_) {
						gint _tmp73_;
						_tmp73_ = pcount;
						pcount = _tmp73_ + 1;
					}
					_tmp72_ = FALSE;
					_tmp74_ = self->priv->current_token;
					if (!(_tmp74_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
						break;
					}
					valadoc_importer_gir_documentation_importer_parse_parameter (self, &_tmp75_, &_tmp76_, &_tmp77_, &_tmp78_, &_tmp79_);
					_valadoc_api_source_comment_unref0 (param_comment);
					param_comment = _tmp75_;
					_g_free0 (param_name);
					param_name = _tmp76_;
					destroy_pos = _tmp77_;
					closure_pos = _tmp78_;
					array_length_pos = _tmp79_;
					_tmp80_ = param_name;
					_tmp81_ = g_strdup (_tmp80_);
					_vala_array_add3 (&param_names, &param_names_length1, &_param_names_size_, _tmp81_);
					if (destroy_pos >= 0) {
						_tmp82_ = pcount != destroy_pos;
					} else {
						_tmp82_ = FALSE;
					}
					if (_tmp82_) {
						ValadocImporterGirDocumentationImporterImplicitParameterPos _tmp83_ = {0};
						valadoc_importer_gir_documentation_importer_implicit_parameter_pos_init (&_tmp83_, pcount, destroy_pos);
						_vala_array_add4 (&destroy_notifies, &destroy_notifies_length1, &_destroy_notifies_size_, &_tmp83_);
					}
					if (closure_pos >= 0) {
						_tmp84_ = pcount != closure_pos;
					} else {
						_tmp84_ = FALSE;
					}
					if (_tmp84_) {
						ValadocImporterGirDocumentationImporterImplicitParameterPos _tmp85_ = {0};
						valadoc_importer_gir_documentation_importer_implicit_parameter_pos_init (&_tmp85_, pcount, closure_pos);
						_vala_array_add5 (&closures, &closures_length1, &_closures_size_, &_tmp85_);
					}
					if (array_length_pos >= 0) {
						_tmp86_ = pcount != destroy_pos;
					} else {
						_tmp86_ = FALSE;
					}
					if (_tmp86_) {
						ValadocImporterGirDocumentationImporterImplicitParameterPos _tmp87_ = {0};
						valadoc_importer_gir_documentation_importer_implicit_parameter_pos_init (&_tmp87_, pcount, array_length_pos);
						_vala_array_add6 (&array_lengths, &array_lengths_length1, &_array_lengths_size_, &_tmp87_);
					}
					_tmp88_ = param_comment;
					if (_tmp88_ != NULL) {
						ValadocApiGirSourceComment* _tmp89_;
						ValadocApiGirSourceComment* _tmp96_;
						const gchar* _tmp97_;
						ValadocApiSourceComment* _tmp98_;
						_tmp89_ = comment;
						if (_tmp89_ == NULL) {
							ValadocApiSourceFile* _tmp90_;
							ValaSourceLocation _tmp91_;
							ValaSourceLocation _tmp92_;
							ValaSourceLocation _tmp93_;
							ValaSourceLocation _tmp94_;
							ValadocApiGirSourceComment* _tmp95_;
							_tmp90_ = self->priv->file;
							_tmp91_ = self->priv->begin;
							_tmp92_ = self->priv->begin;
							_tmp93_ = self->priv->end;
							_tmp94_ = self->priv->end;
							_tmp95_ = valadoc_api_gir_source_comment_new ("", _tmp90_, _tmp91_.line, _tmp92_.column, _tmp93_.line, _tmp94_.column);
							_valadoc_api_source_comment_unref0 (comment);
							comment = _tmp95_;
						}
						_tmp96_ = comment;
						_tmp97_ = param_name;
						_tmp98_ = param_comment;
						valadoc_api_gir_source_comment_add_parameter_content (_tmp96_, _tmp97_, _tmp98_);
					}
					_g_free0 (param_name);
					_valadoc_api_source_comment_unref0 (param_comment);
				}
			}
		}
		valadoc_importer_gir_documentation_importer_end_element (self, "parameters");
	}
	_tmp99_ = c_identifier;
	_tmp100_ = comment;
	_tmp101_ = param_names;
	_tmp101__length1 = param_names_length1;
	_tmp102_ = destroy_notifies;
	_tmp102__length1 = destroy_notifies_length1;
	_tmp103_ = closures;
	_tmp103__length1 = closures_length1;
	_tmp104_ = array_lengths;
	_tmp104__length1 = array_lengths_length1;
	valadoc_importer_gir_documentation_importer_attach_comment (self, _tmp99_, _tmp100_, _tmp101_, (gint) _tmp101__length1, _tmp102_, (gint) _tmp102__length1, _tmp103_, (gint) _tmp103__length1, _tmp104_, (gint) _tmp104__length1, array_length_ret);
	valadoc_importer_gir_documentation_importer_end_element (self, element_name);
	param_names = (_vala_array_free (param_names, param_names_length1, (GDestroyNotify) g_free), NULL);
	closures = (g_free (closures), NULL);
	array_lengths = (g_free (array_lengths), NULL);
	destroy_notifies = (g_free (destroy_notifies), NULL);
	_valadoc_api_source_comment_unref0 (comment);
	_g_free0 (c_identifier);
}

static void
valadoc_importer_gir_documentation_importer_parse_method (ValadocImporterGirDocumentationImporter* self,
                                                          const gchar* element_name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (element_name != NULL);
	valadoc_importer_gir_documentation_importer_parse_function (self, element_name);
}

static void
valadoc_importer_gir_documentation_importer_parse_signal (ValadocImporterGirDocumentationImporter* self)
{
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_parse_function (self, "glib:signal");
}

static void
valadoc_importer_gir_documentation_importer_parse_boxed (ValadocImporterGirDocumentationImporter* self,
                                                         const gchar* element_name)
{
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	ValadocApiGirSourceComment* _tmp5_;
	ValadocApiGirSourceComment* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element_name != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, element_name);
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "name");
	_g_free0 (self->priv->parent_c_identifier);
	self->priv->parent_c_identifier = _tmp1_;
	_tmp2_ = self->priv->parent_c_identifier;
	if (_tmp2_ == NULL) {
		ValaMarkupReader* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->priv->reader;
		_tmp4_ = vala_markup_reader_get_attribute (_tmp3_, "glib:name");
		_g_free0 (self->priv->parent_c_identifier);
		self->priv->parent_c_identifier = _tmp4_;
	}
	valadoc_importer_gir_documentation_importer_next (self);
	_tmp5_ = valadoc_importer_gir_documentation_importer_parse_symbol_doc (self);
	_tmp6_ = _tmp5_;
	_valadoc_api_source_comment_unref0 (_tmp6_);
	while (TRUE) {
		ValaMarkupTokenType _tmp7_;
		ValaMarkupReader* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp7_ = self->priv->current_token;
		if (!(_tmp7_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp8_ = self->priv->reader;
		_tmp9_ = vala_markup_reader_get_name (_tmp8_);
		_tmp10_ = _tmp9_;
		if (g_strcmp0 (_tmp10_, "field") == 0) {
			valadoc_importer_gir_documentation_importer_parse_field (self);
		} else {
			ValaMarkupReader* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			_tmp11_ = self->priv->reader;
			_tmp12_ = vala_markup_reader_get_name (_tmp11_);
			_tmp13_ = _tmp12_;
			if (g_strcmp0 (_tmp13_, "constructor") == 0) {
				valadoc_importer_gir_documentation_importer_parse_constructor (self);
			} else {
				ValaMarkupReader* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				_tmp14_ = self->priv->reader;
				_tmp15_ = vala_markup_reader_get_name (_tmp14_);
				_tmp16_ = _tmp15_;
				if (g_strcmp0 (_tmp16_, "method") == 0) {
					valadoc_importer_gir_documentation_importer_parse_method (self, "method");
				} else {
					ValaMarkupReader* _tmp17_;
					const gchar* _tmp18_;
					const gchar* _tmp19_;
					_tmp17_ = self->priv->reader;
					_tmp18_ = vala_markup_reader_get_name (_tmp17_);
					_tmp19_ = _tmp18_;
					if (g_strcmp0 (_tmp19_, "function") == 0) {
						valadoc_importer_gir_documentation_importer_skip_element (self);
					} else {
						ValaMarkupReader* _tmp20_;
						const gchar* _tmp21_;
						const gchar* _tmp22_;
						_tmp20_ = self->priv->reader;
						_tmp21_ = vala_markup_reader_get_name (_tmp20_);
						_tmp22_ = _tmp21_;
						if (g_strcmp0 (_tmp22_, "union") == 0) {
							valadoc_importer_gir_documentation_importer_parse_union (self);
						} else {
							ValaMarkupReader* _tmp23_;
							const gchar* _tmp24_;
							const gchar* _tmp25_;
							gchar* _tmp26_;
							gchar* _tmp27_;
							_tmp23_ = self->priv->reader;
							_tmp24_ = vala_markup_reader_get_name (_tmp23_);
							_tmp25_ = _tmp24_;
							_tmp26_ = g_strdup_printf ("unknown child element `%s' in `class'", _tmp25_);
							_tmp27_ = _tmp26_;
							valadoc_importer_gir_documentation_importer_error (self, _tmp27_);
							_g_free0 (_tmp27_);
							valadoc_importer_gir_documentation_importer_skip_element (self);
						}
					}
				}
			}
		}
	}
	_g_free0 (self->priv->parent_c_identifier);
	self->priv->parent_c_identifier = NULL;
	valadoc_importer_gir_documentation_importer_end_element (self, element_name);
}

static void
valadoc_importer_gir_documentation_importer_parse_union (ValadocImporterGirDocumentationImporter* self)
{
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	ValadocApiGirSourceComment* comment = NULL;
	ValadocApiGirSourceComment* _tmp3_;
	const gchar* _tmp4_;
	ValadocApiGirSourceComment* _tmp5_;
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, "union");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "c:type");
	_g_free0 (self->priv->parent_c_identifier);
	self->priv->parent_c_identifier = _tmp1_;
	_tmp2_ = self->priv->parent_c_identifier;
	if (_tmp2_ == NULL) {
		valadoc_importer_gir_documentation_importer_skip_element (self);
		return;
	}
	valadoc_importer_gir_documentation_importer_next (self);
	_tmp3_ = valadoc_importer_gir_documentation_importer_parse_symbol_doc (self);
	comment = _tmp3_;
	_tmp4_ = self->priv->parent_c_identifier;
	_tmp5_ = comment;
	valadoc_importer_gir_documentation_importer_attach_comment (self, _tmp4_, _tmp5_, NULL, (gint) 0, NULL, (gint) 0, NULL, (gint) 0, NULL, (gint) 0, -1);
	while (TRUE) {
		ValaMarkupTokenType _tmp6_;
		ValaMarkupReader* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp6_ = self->priv->current_token;
		if (!(_tmp6_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp7_ = self->priv->reader;
		_tmp8_ = vala_markup_reader_get_name (_tmp7_);
		_tmp9_ = _tmp8_;
		if (g_strcmp0 (_tmp9_, "field") == 0) {
			valadoc_importer_gir_documentation_importer_parse_field (self);
		} else {
			ValaMarkupReader* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			_tmp10_ = self->priv->reader;
			_tmp11_ = vala_markup_reader_get_name (_tmp10_);
			_tmp12_ = _tmp11_;
			if (g_strcmp0 (_tmp12_, "constructor") == 0) {
				valadoc_importer_gir_documentation_importer_parse_constructor (self);
			} else {
				ValaMarkupReader* _tmp13_;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				_tmp13_ = self->priv->reader;
				_tmp14_ = vala_markup_reader_get_name (_tmp13_);
				_tmp15_ = _tmp14_;
				if (g_strcmp0 (_tmp15_, "method") == 0) {
					valadoc_importer_gir_documentation_importer_parse_method (self, "method");
				} else {
					ValaMarkupReader* _tmp16_;
					const gchar* _tmp17_;
					const gchar* _tmp18_;
					_tmp16_ = self->priv->reader;
					_tmp17_ = vala_markup_reader_get_name (_tmp16_);
					_tmp18_ = _tmp17_;
					if (g_strcmp0 (_tmp18_, "function") == 0) {
						valadoc_importer_gir_documentation_importer_skip_element (self);
					} else {
						ValaMarkupReader* _tmp19_;
						const gchar* _tmp20_;
						const gchar* _tmp21_;
						_tmp19_ = self->priv->reader;
						_tmp20_ = vala_markup_reader_get_name (_tmp19_);
						_tmp21_ = _tmp20_;
						if (g_strcmp0 (_tmp21_, "record") == 0) {
							valadoc_importer_gir_documentation_importer_parse_record (self);
						} else {
							ValaMarkupReader* _tmp22_;
							const gchar* _tmp23_;
							const gchar* _tmp24_;
							gchar* _tmp25_;
							gchar* _tmp26_;
							_tmp22_ = self->priv->reader;
							_tmp23_ = vala_markup_reader_get_name (_tmp22_);
							_tmp24_ = _tmp23_;
							_tmp25_ = g_strdup_printf ("unknown child element `%s' in `union'", _tmp24_);
							_tmp26_ = _tmp25_;
							valadoc_importer_gir_documentation_importer_error (self, _tmp26_);
							_g_free0 (_tmp26_);
							valadoc_importer_gir_documentation_importer_skip_element (self);
						}
					}
				}
			}
		}
	}
	_g_free0 (self->priv->parent_c_identifier);
	self->priv->parent_c_identifier = NULL;
	valadoc_importer_gir_documentation_importer_end_element (self, "union");
	_valadoc_api_source_comment_unref0 (comment);
}

static void
valadoc_importer_gir_documentation_importer_parse_constant (ValadocImporterGirDocumentationImporter* self)
{
	gchar* c_identifier = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp5_;
	ValadocApiGirSourceComment* comment = NULL;
	ValadocApiGirSourceComment* _tmp6_;
	const gchar* _tmp7_;
	ValadocApiGirSourceComment* _tmp8_;
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, "constant");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "c:identifier");
	c_identifier = _tmp1_;
	_tmp2_ = c_identifier;
	if (_tmp2_ == NULL) {
		ValaMarkupReader* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->priv->reader;
		_tmp4_ = vala_markup_reader_get_attribute (_tmp3_, "c:type");
		_g_free0 (c_identifier);
		c_identifier = _tmp4_;
	}
	_tmp5_ = c_identifier;
	if (_tmp5_ == NULL) {
		valadoc_importer_gir_documentation_importer_skip_element (self);
		_g_free0 (c_identifier);
		return;
	}
	valadoc_importer_gir_documentation_importer_next (self);
	_tmp6_ = valadoc_importer_gir_documentation_importer_parse_symbol_doc (self);
	comment = _tmp6_;
	_tmp7_ = c_identifier;
	_tmp8_ = comment;
	valadoc_importer_gir_documentation_importer_attach_comment (self, _tmp7_, _tmp8_, NULL, (gint) 0, NULL, (gint) 0, NULL, (gint) 0, NULL, (gint) 0, -1);
	valadoc_importer_gir_documentation_importer_parse_type (self, NULL);
	valadoc_importer_gir_documentation_importer_end_element (self, "constant");
	_valadoc_api_source_comment_unref0 (comment);
	_g_free0 (c_identifier);
}

static void
valadoc_importer_gir_documentation_importer_implicit_parameter_pos_init (ValadocImporterGirDocumentationImporterImplicitParameterPos *self,
                                                                         gint parameter,
                                                                         gint position)
{
	memset (self, 0, sizeof (ValadocImporterGirDocumentationImporterImplicitParameterPos));
	(*self).parameter = parameter;
	(*self).position = position;
}

static ValadocImporterGirDocumentationImporterImplicitParameterPos*
valadoc_importer_gir_documentation_importer_implicit_parameter_pos_dup (const ValadocImporterGirDocumentationImporterImplicitParameterPos* self)
{
	ValadocImporterGirDocumentationImporterImplicitParameterPos* dup;
	dup = g_new0 (ValadocImporterGirDocumentationImporterImplicitParameterPos, 1);
	memcpy (dup, self, sizeof (ValadocImporterGirDocumentationImporterImplicitParameterPos));
	return dup;
}

static void
valadoc_importer_gir_documentation_importer_implicit_parameter_pos_free (ValadocImporterGirDocumentationImporterImplicitParameterPos* self)
{
	g_free (self);
}

static GType
valadoc_importer_gir_documentation_importer_implicit_parameter_pos_get_type_once (void)
{
	GType valadoc_importer_gir_documentation_importer_implicit_parameter_pos_type_id;
	valadoc_importer_gir_documentation_importer_implicit_parameter_pos_type_id = g_boxed_type_register_static ("ValadocImporterGirDocumentationImporterImplicitParameterPos", (GBoxedCopyFunc) valadoc_importer_gir_documentation_importer_implicit_parameter_pos_dup, (GBoxedFreeFunc) valadoc_importer_gir_documentation_importer_implicit_parameter_pos_free);
	return valadoc_importer_gir_documentation_importer_implicit_parameter_pos_type_id;
}

static GType
valadoc_importer_gir_documentation_importer_implicit_parameter_pos_get_type (void)
{
	static volatile gsize valadoc_importer_gir_documentation_importer_implicit_parameter_pos_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_importer_gir_documentation_importer_implicit_parameter_pos_type_id__volatile)) {
		GType valadoc_importer_gir_documentation_importer_implicit_parameter_pos_type_id;
		valadoc_importer_gir_documentation_importer_implicit_parameter_pos_type_id = valadoc_importer_gir_documentation_importer_implicit_parameter_pos_get_type_once ();
		g_once_init_leave (&valadoc_importer_gir_documentation_importer_implicit_parameter_pos_type_id__volatile, valadoc_importer_gir_documentation_importer_implicit_parameter_pos_type_id);
	}
	return valadoc_importer_gir_documentation_importer_implicit_parameter_pos_type_id__volatile;
}

static void
valadoc_importer_gir_documentation_importer_class_init (ValadocImporterGirDocumentationImporterClass * klass,
                                                        gpointer klass_data)
{
	valadoc_importer_gir_documentation_importer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ValadocImporterGirDocumentationImporter_private_offset);
	((ValadocImporterDocumentationImporterClass *) klass)->process = (void (*) (ValadocImporterDocumentationImporter*, const gchar*)) valadoc_importer_gir_documentation_importer_real_process;
	VALADOC_IMPORTER_DOCUMENTATION_IMPORTER_CLASS (klass)->get_file_extension = valadoc_importer_gir_documentation_importer_real_get_file_extension;
	G_OBJECT_CLASS (klass)->get_property = _vala_valadoc_importer_gir_documentation_importer_get_property;
	G_OBJECT_CLASS (klass)->finalize = valadoc_importer_gir_documentation_importer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_IMPORTER_GIR_DOCUMENTATION_IMPORTER_FILE_EXTENSION_PROPERTY, valadoc_importer_gir_documentation_importer_properties[VALADOC_IMPORTER_GIR_DOCUMENTATION_IMPORTER_FILE_EXTENSION_PROPERTY] = g_param_spec_string ("file-extension", "file-extension", "file-extension", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
valadoc_importer_gir_documentation_importer_instance_init (ValadocImporterGirDocumentationImporter * self,
                                                           gpointer klass)
{
	self->priv = valadoc_importer_gir_documentation_importer_get_instance_private (self);
}

static void
valadoc_importer_gir_documentation_importer_finalize (GObject * obj)
{
	ValadocImporterGirDocumentationImporter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_IMPORTER_TYPE_GIR_DOCUMENTATION_IMPORTER, ValadocImporterGirDocumentationImporter);
	_vala_markup_reader_unref0 (self->priv->reader);
	_g_object_unref0 (self->priv->parser);
	_g_object_unref0 (self->priv->file);
	_g_free0 (self->priv->parent_c_identifier);
	G_OBJECT_CLASS (valadoc_importer_gir_documentation_importer_parent_class)->finalize (obj);
}

static GType
valadoc_importer_gir_documentation_importer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValadocImporterGirDocumentationImporterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_importer_gir_documentation_importer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocImporterGirDocumentationImporter), 0, (GInstanceInitFunc) valadoc_importer_gir_documentation_importer_instance_init, NULL };
	GType valadoc_importer_gir_documentation_importer_type_id;
	valadoc_importer_gir_documentation_importer_type_id = g_type_register_static (VALADOC_IMPORTER_TYPE_DOCUMENTATION_IMPORTER, "ValadocImporterGirDocumentationImporter", &g_define_type_info, 0);
	ValadocImporterGirDocumentationImporter_private_offset = g_type_add_instance_private (valadoc_importer_gir_documentation_importer_type_id, sizeof (ValadocImporterGirDocumentationImporterPrivate));
	return valadoc_importer_gir_documentation_importer_type_id;
}

GType
valadoc_importer_gir_documentation_importer_get_type (void)
{
	static volatile gsize valadoc_importer_gir_documentation_importer_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_importer_gir_documentation_importer_type_id__volatile)) {
		GType valadoc_importer_gir_documentation_importer_type_id;
		valadoc_importer_gir_documentation_importer_type_id = valadoc_importer_gir_documentation_importer_get_type_once ();
		g_once_init_leave (&valadoc_importer_gir_documentation_importer_type_id__volatile, valadoc_importer_gir_documentation_importer_type_id);
	}
	return valadoc_importer_gir_documentation_importer_type_id__volatile;
}

static void
_vala_valadoc_importer_gir_documentation_importer_get_property (GObject * object,
                                                                guint property_id,
                                                                GValue * value,
                                                                GParamSpec * pspec)
{
	ValadocImporterGirDocumentationImporter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_IMPORTER_TYPE_GIR_DOCUMENTATION_IMPORTER, ValadocImporterGirDocumentationImporter);
	switch (property_id) {
		case VALADOC_IMPORTER_GIR_DOCUMENTATION_IMPORTER_FILE_EXTENSION_PROPERTY:
		g_value_set_string (value, valadoc_importer_documentation_importer_get_file_extension ((ValadocImporterDocumentationImporter*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

