/* valagtkmodule.c generated by valac, the Vala compiler
 * generated from valagtkmodule.vala, do not modify */

/* valagtkmodule.vala
 *
 * Copyright (C) 2013  Jürg Billeter
 * Copyright (C) 2013-2014  Luca Bruno
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Luca Bruno <lucabru@src.gnome.org>
 */

#include "valacodegen.h"
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <vala.h>
#include <glib/gstdio.h>
#include <valaccode.h>

#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_markup_reader_unref0(var) ((var == NULL) ? NULL : (var = (vala_markup_reader_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))

struct _ValaGtkModulePrivate {
	ValaHashMap* type_id_to_vala_map;
	ValaHashMap* cclass_to_vala_map;
	ValaHashMap* gresource_to_file_map;
	ValaHashMap* current_handler_to_property_map;
	ValaHashMap* current_handler_to_signal_map;
	ValaHashMap* current_child_to_class_map;
	ValaList* current_required_app_classes;
};

static gint ValaGtkModule_private_offset;
static gpointer vala_gtk_module_parent_class = NULL;

static void vala_gtk_module_ensure_type_id_to_vala_map (ValaGtkModule* self);
static void vala_gtk_module_recurse_type_id_to_vala_map (ValaGtkModule* self,
                                                  ValaNamespace* ns);
static void vala_gtk_module_ensure_cclass_to_vala_map (ValaGtkModule* self);
static void vala_gtk_module_recurse_cclass_to_vala_map (ValaGtkModule* self,
                                                 ValaNamespace* ns);
static void vala_gtk_module_ensure_gresource_to_file_map (ValaGtkModule* self);
static void vala_gtk_module_process_current_ui_resource (ValaGtkModule* self,
                                                  const gchar* ui_resource,
                                                  ValaCodeNode* node);
static gboolean vala_gtk_module_is_gtk_template (ValaGtkModule* self,
                                          ValaClass* cl);
static void vala_gtk_module_real_generate_class_init (ValaGTypeModule* base,
                                               ValaClass* cl);
static void vala_gtk_module_real_visit_property (ValaCodeVisitor* base,
                                          ValaProperty* prop);
static void vala_gtk_module_real_visit_field (ValaCodeVisitor* base,
                                       ValaField* f);
static void vala_gtk_module_real_visit_method (ValaCodeVisitor* base,
                                        ValaMethod* m);
static void vala_gtk_module_real_end_instance_init (ValaGTypeModule* base,
                                             ValaClass* cl);
static void vala_gtk_module_finalize (ValaCodeVisitor * obj);
static GType vala_gtk_module_get_type_once (void);

static inline gpointer
vala_gtk_module_get_instance_private (ValaGtkModule* self)
{
	return G_STRUCT_MEMBER_P (self, ValaGtkModule_private_offset);
}

static void
vala_gtk_module_ensure_type_id_to_vala_map (ValaGtkModule* self)
{
	ValaHashMap* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GEqualFunc _tmp3_;
	ValaHashMap* _tmp4_;
	ValaCodeContext* _tmp5_;
	ValaCodeContext* _tmp6_;
	ValaNamespace* _tmp7_;
	ValaNamespace* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->type_id_to_vala_map;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_direct_equal;
	_tmp4_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, VALA_TYPE_CLASS, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_, _tmp2_, _tmp3_);
	_vala_map_unref0 (self->priv->type_id_to_vala_map);
	self->priv->type_id_to_vala_map = _tmp4_;
	_tmp5_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_code_context_get_root (_tmp6_);
	_tmp8_ = _tmp7_;
	vala_gtk_module_recurse_type_id_to_vala_map (self, _tmp8_);
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
vala_gtk_module_recurse_type_id_to_vala_map (ValaGtkModule* self,
                                             ValaNamespace* ns)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp0_;
		gint _cl_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _cl_index = 0;
		_tmp0_ = vala_namespace_get_classes (ns);
		_cl_list = _tmp0_;
		_tmp1_ = _cl_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_cl_size = _tmp3_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaClass* cl = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaClass* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_cl_index = _cl_index + 1;
			_tmp4_ = _cl_index;
			_tmp5_ = _cl_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _cl_list;
			_tmp7_ = vala_list_get (_tmp6_, _cl_index);
			cl = (ValaClass*) _tmp7_;
			_tmp8_ = cl;
			_tmp9_ = vala_class_get_is_compact (_tmp8_);
			_tmp10_ = _tmp9_;
			if (!_tmp10_) {
				gchar* type_id = NULL;
				ValaClass* _tmp11_;
				gchar* _tmp12_;
				const gchar* _tmp13_;
				gint i = 0;
				const gchar* _tmp14_;
				ValaHashMap* _tmp21_;
				const gchar* _tmp22_;
				ValaClass* _tmp23_;
				_tmp11_ = cl;
				_tmp12_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp11_);
				type_id = _tmp12_;
				_tmp13_ = type_id;
				if (_tmp13_ == NULL) {
					_g_free0 (type_id);
					_vala_code_node_unref0 (cl);
					continue;
				}
				_tmp14_ = type_id;
				i = string_index_of_char (_tmp14_, (gunichar) '(', 0);
				if (i > 0) {
					const gchar* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					_tmp15_ = type_id;
					_tmp16_ = string_substring (_tmp15_, (glong) 0, (glong) (i - 1));
					_tmp17_ = _tmp16_;
					_tmp18_ = string_strip (_tmp17_);
					_g_free0 (type_id);
					type_id = _tmp18_;
					_g_free0 (_tmp17_);
				} else {
					const gchar* _tmp19_;
					gchar* _tmp20_;
					_tmp19_ = type_id;
					_tmp20_ = string_strip (_tmp19_);
					_g_free0 (type_id);
					type_id = _tmp20_;
				}
				_tmp21_ = self->priv->type_id_to_vala_map;
				_tmp22_ = type_id;
				_tmp23_ = cl;
				vala_map_set ((ValaMap*) _tmp21_, _tmp22_, _tmp23_);
				_g_free0 (type_id);
			}
			_vala_code_node_unref0 (cl);
		}
	}
	{
		ValaList* _inner_list = NULL;
		ValaList* _tmp24_;
		gint _inner_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _inner_index = 0;
		_tmp24_ = vala_namespace_get_namespaces (ns);
		_inner_list = _tmp24_;
		_tmp25_ = _inner_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_inner_size = _tmp27_;
		_inner_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			ValaNamespace* inner = NULL;
			ValaList* _tmp30_;
			gpointer _tmp31_;
			ValaNamespace* _tmp32_;
			_inner_index = _inner_index + 1;
			_tmp28_ = _inner_index;
			_tmp29_ = _inner_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _inner_list;
			_tmp31_ = vala_list_get (_tmp30_, _inner_index);
			inner = (ValaNamespace*) _tmp31_;
			_tmp32_ = inner;
			vala_gtk_module_recurse_type_id_to_vala_map (self, _tmp32_);
			_vala_code_node_unref0 (inner);
		}
	}
}

static void
vala_gtk_module_ensure_cclass_to_vala_map (ValaGtkModule* self)
{
	ValaHashMap* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GEqualFunc _tmp3_;
	ValaHashMap* _tmp4_;
	ValaCodeContext* _tmp5_;
	ValaCodeContext* _tmp6_;
	ValaNamespace* _tmp7_;
	ValaNamespace* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cclass_to_vala_map;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_direct_equal;
	_tmp4_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, VALA_TYPE_CLASS, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_, _tmp2_, _tmp3_);
	_vala_map_unref0 (self->priv->cclass_to_vala_map);
	self->priv->cclass_to_vala_map = _tmp4_;
	_tmp5_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_code_context_get_root (_tmp6_);
	_tmp8_ = _tmp7_;
	vala_gtk_module_recurse_cclass_to_vala_map (self, _tmp8_);
}

static void
vala_gtk_module_recurse_cclass_to_vala_map (ValaGtkModule* self,
                                            ValaNamespace* ns)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp0_;
		gint _cl_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _cl_index = 0;
		_tmp0_ = vala_namespace_get_classes (ns);
		_cl_list = _tmp0_;
		_tmp1_ = _cl_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_cl_size = _tmp3_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaClass* cl = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaClass* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_cl_index = _cl_index + 1;
			_tmp4_ = _cl_index;
			_tmp5_ = _cl_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _cl_list;
			_tmp7_ = vala_list_get (_tmp6_, _cl_index);
			cl = (ValaClass*) _tmp7_;
			_tmp8_ = cl;
			_tmp9_ = vala_class_get_is_compact (_tmp8_);
			_tmp10_ = _tmp9_;
			if (!_tmp10_) {
				ValaHashMap* _tmp11_;
				ValaClass* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				ValaClass* _tmp15_;
				_tmp11_ = self->priv->cclass_to_vala_map;
				_tmp12_ = cl;
				_tmp13_ = vala_get_ccode_name ((ValaCodeNode*) _tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = cl;
				vala_map_set ((ValaMap*) _tmp11_, _tmp14_, _tmp15_);
				_g_free0 (_tmp14_);
			}
			_vala_code_node_unref0 (cl);
		}
	}
	{
		ValaList* _inner_list = NULL;
		ValaList* _tmp16_;
		gint _inner_size = 0;
		ValaList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _inner_index = 0;
		_tmp16_ = vala_namespace_get_namespaces (ns);
		_inner_list = _tmp16_;
		_tmp17_ = _inner_list;
		_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_inner_size = _tmp19_;
		_inner_index = -1;
		while (TRUE) {
			gint _tmp20_;
			gint _tmp21_;
			ValaNamespace* inner = NULL;
			ValaList* _tmp22_;
			gpointer _tmp23_;
			ValaNamespace* _tmp24_;
			_inner_index = _inner_index + 1;
			_tmp20_ = _inner_index;
			_tmp21_ = _inner_size;
			if (!(_tmp20_ < _tmp21_)) {
				break;
			}
			_tmp22_ = _inner_list;
			_tmp23_ = vala_list_get (_tmp22_, _inner_index);
			inner = (ValaNamespace*) _tmp23_;
			_tmp24_ = inner;
			vala_gtk_module_recurse_cclass_to_vala_map (self, _tmp24_);
			_vala_code_node_unref0 (inner);
		}
	}
}

static void
vala_gtk_module_ensure_gresource_to_file_map (ValaGtkModule* self)
{
	ValaHashMap* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GEqualFunc _tmp3_;
	ValaHashMap* _tmp4_;
	ValaCodeContext* _tmp5_;
	ValaCodeContext* _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gint _tmp8_ = 0;
	gchar** _tmp9_;
	gint _tmp9__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->gresource_to_file_map;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_direct_equal;
	_tmp4_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp1_, _tmp2_, _tmp3_);
	_vala_map_unref0 (self->priv->gresource_to_file_map);
	self->priv->gresource_to_file_map = _tmp4_;
	_tmp5_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_code_context_get_gresources (_tmp6_, &_tmp8_);
	_tmp7__length1 = _tmp8_;
	_tmp9_ = _tmp7_;
	_tmp9__length1 = _tmp7__length1;
	{
		gchar** gresource_collection = NULL;
		gint gresource_collection_length1 = 0;
		gint _gresource_collection_size_ = 0;
		gint gresource_it = 0;
		gresource_collection = _tmp9_;
		gresource_collection_length1 = _tmp9__length1;
		for (gresource_it = 0; gresource_it < gresource_collection_length1; gresource_it = gresource_it + 1) {
			gchar* _tmp10_;
			gchar* gresource = NULL;
			_tmp10_ = g_strdup (gresource_collection[gresource_it]);
			gresource = _tmp10_;
			{
				const gchar* _tmp11_;
				ValaMarkupReader* reader = NULL;
				const gchar* _tmp13_;
				ValaMarkupReader* _tmp14_;
				gint state = 0;
				gchar* prefix = NULL;
				gchar* alias = NULL;
				ValaMarkupTokenType current_token = 0;
				ValaMarkupReader* _tmp15_;
				_tmp11_ = gresource;
				if (!g_file_test (_tmp11_, G_FILE_TEST_EXISTS)) {
					const gchar* _tmp12_;
					_tmp12_ = gresource;
					vala_report_error (NULL, "GResources file `%s' does not exist", _tmp12_);
					_g_free0 (gresource);
					continue;
				}
				_tmp13_ = gresource;
				_tmp14_ = vala_markup_reader_new (_tmp13_);
				reader = _tmp14_;
				state = 0;
				prefix = NULL;
				alias = NULL;
				_tmp15_ = reader;
				current_token = vala_markup_reader_read_token (_tmp15_, NULL, NULL);
				while (TRUE) {
					gboolean _tmp16_ = FALSE;
					ValaMarkupReader* _tmp51_;
					if (!(current_token != VALA_MARKUP_TOKEN_TYPE_EOF)) {
						break;
					}
					if (current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
						ValaMarkupReader* _tmp17_;
						const gchar* _tmp18_;
						const gchar* _tmp19_;
						_tmp17_ = reader;
						_tmp18_ = vala_markup_reader_get_name (_tmp17_);
						_tmp19_ = _tmp18_;
						_tmp16_ = g_strcmp0 (_tmp19_, "gresource") == 0;
					} else {
						_tmp16_ = FALSE;
					}
					if (_tmp16_) {
						ValaMarkupReader* _tmp20_;
						gchar* _tmp21_;
						_tmp20_ = reader;
						_tmp21_ = vala_markup_reader_get_attribute (_tmp20_, "prefix");
						_g_free0 (prefix);
						prefix = _tmp21_;
					} else {
						gboolean _tmp22_ = FALSE;
						if (current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
							ValaMarkupReader* _tmp23_;
							const gchar* _tmp24_;
							const gchar* _tmp25_;
							_tmp23_ = reader;
							_tmp24_ = vala_markup_reader_get_name (_tmp23_);
							_tmp25_ = _tmp24_;
							_tmp22_ = g_strcmp0 (_tmp25_, "file") == 0;
						} else {
							_tmp22_ = FALSE;
						}
						if (_tmp22_) {
							ValaMarkupReader* _tmp26_;
							gchar* _tmp27_;
							_tmp26_ = reader;
							_tmp27_ = vala_markup_reader_get_attribute (_tmp26_, "alias");
							_g_free0 (alias);
							alias = _tmp27_;
							state = 1;
						} else {
							gboolean _tmp28_ = FALSE;
							if (state == 1) {
								_tmp28_ = current_token == VALA_MARKUP_TOKEN_TYPE_TEXT;
							} else {
								_tmp28_ = FALSE;
							}
							if (_tmp28_) {
								gchar* name = NULL;
								ValaMarkupReader* _tmp29_;
								const gchar* _tmp30_;
								const gchar* _tmp31_;
								gchar* _tmp32_;
								gchar* filename = NULL;
								ValaCodeContext* _tmp33_;
								ValaCodeContext* _tmp34_;
								const gchar* _tmp35_;
								const gchar* _tmp36_;
								gchar* _tmp37_;
								const gchar* _tmp38_;
								ValaHashMap* _tmp45_;
								const gchar* _tmp46_;
								const gchar* _tmp47_;
								gchar* _tmp48_;
								gchar* _tmp49_;
								const gchar* _tmp50_;
								_tmp29_ = reader;
								_tmp30_ = vala_markup_reader_get_content (_tmp29_);
								_tmp31_ = _tmp30_;
								_tmp32_ = g_strdup (_tmp31_);
								name = _tmp32_;
								_tmp33_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
								_tmp34_ = _tmp33_;
								_tmp35_ = gresource;
								_tmp36_ = name;
								_tmp37_ = vala_code_context_get_gresource_path (_tmp34_, _tmp35_, _tmp36_);
								filename = _tmp37_;
								_tmp38_ = alias;
								if (_tmp38_ != NULL) {
									ValaHashMap* _tmp39_;
									const gchar* _tmp40_;
									const gchar* _tmp41_;
									gchar* _tmp42_;
									gchar* _tmp43_;
									const gchar* _tmp44_;
									_tmp39_ = self->priv->gresource_to_file_map;
									_tmp40_ = prefix;
									_tmp41_ = alias;
									_tmp42_ = g_build_filename (_tmp40_, _tmp41_, NULL);
									_tmp43_ = _tmp42_;
									_tmp44_ = filename;
									vala_map_set ((ValaMap*) _tmp39_, _tmp43_, _tmp44_);
									_g_free0 (_tmp43_);
								}
								_tmp45_ = self->priv->gresource_to_file_map;
								_tmp46_ = prefix;
								_tmp47_ = name;
								_tmp48_ = g_build_filename (_tmp46_, _tmp47_, NULL);
								_tmp49_ = _tmp48_;
								_tmp50_ = filename;
								vala_map_set ((ValaMap*) _tmp45_, _tmp49_, _tmp50_);
								_g_free0 (_tmp49_);
								state = 0;
								_g_free0 (filename);
								_g_free0 (name);
							}
						}
					}
					_tmp51_ = reader;
					current_token = vala_markup_reader_read_token (_tmp51_, NULL, NULL);
				}
				_g_free0 (alias);
				_g_free0 (prefix);
				_vala_markup_reader_unref0 (reader);
				_g_free0 (gresource);
			}
		}
	}
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
vala_gtk_module_process_current_ui_resource (ValaGtkModule* self,
                                             const gchar* ui_resource,
                                             ValaCodeNode* node)
{
	gchar* ui_file = NULL;
	ValaHashMap* _tmp0_;
	gpointer _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	GHashFunc _tmp7_;
	GEqualFunc _tmp8_;
	GEqualFunc _tmp9_;
	ValaHashMap* _tmp10_;
	GHashFunc _tmp11_;
	GEqualFunc _tmp12_;
	GEqualFunc _tmp13_;
	ValaHashMap* _tmp14_;
	ValaMarkupReader* reader = NULL;
	const gchar* _tmp15_;
	ValaMarkupReader* _tmp16_;
	ValaClass* current_class = NULL;
	ValaProperty* current_property = NULL;
	gboolean template_tag_found = FALSE;
	ValaMarkupTokenType current_token = 0;
	ValaMarkupReader* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ui_resource != NULL);
	g_return_if_fail (node != NULL);
	vala_gtk_module_ensure_type_id_to_vala_map (self);
	vala_gtk_module_ensure_cclass_to_vala_map (self);
	vala_gtk_module_ensure_gresource_to_file_map (self);
	_vala_map_unref0 (self->priv->current_handler_to_signal_map);
	self->priv->current_handler_to_signal_map = NULL;
	_vala_map_unref0 (self->priv->current_child_to_class_map);
	self->priv->current_child_to_class_map = NULL;
	_tmp0_ = self->priv->gresource_to_file_map;
	_tmp1_ = vala_map_get ((ValaMap*) _tmp0_, ui_resource);
	ui_file = (gchar*) _tmp1_;
	_tmp3_ = ui_file;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = ui_file;
		_tmp2_ = !g_file_test (_tmp4_, G_FILE_TEST_EXISTS);
	}
	if (_tmp2_) {
		ValaSourceReference* _tmp5_;
		ValaSourceReference* _tmp6_;
		vala_code_node_set_error (node, TRUE);
		_tmp5_ = vala_code_node_get_source_reference (node);
		_tmp6_ = _tmp5_;
		vala_report_error (_tmp6_, "UI resource not found: `%s'. Please make sure to specify the proper GR" \
"esources xml files with --gresources and alternative search locations " \
"with --gresourcesdir.", ui_resource);
		_g_free0 (ui_file);
		return;
	}
	_tmp7_ = g_str_hash;
	_tmp8_ = g_str_equal;
	_tmp9_ = g_direct_equal;
	_tmp10_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, VALA_TYPE_SIGNAL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp7_, _tmp8_, _tmp9_);
	_vala_map_unref0 (self->priv->current_handler_to_signal_map);
	self->priv->current_handler_to_signal_map = _tmp10_;
	_tmp11_ = g_str_hash;
	_tmp12_ = g_str_equal;
	_tmp13_ = g_direct_equal;
	_tmp14_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, VALA_TYPE_CLASS, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp11_, _tmp12_, _tmp13_);
	_vala_map_unref0 (self->priv->current_child_to_class_map);
	self->priv->current_child_to_class_map = _tmp14_;
	_tmp15_ = ui_file;
	_tmp16_ = vala_markup_reader_new (_tmp15_);
	reader = _tmp16_;
	current_class = NULL;
	current_property = NULL;
	template_tag_found = FALSE;
	_tmp17_ = reader;
	current_token = vala_markup_reader_read_token (_tmp17_, NULL, NULL);
	while (TRUE) {
		const gchar* current_name = NULL;
		ValaMarkupReader* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		gboolean _tmp21_ = FALSE;
		ValaMarkupReader* _tmp132_;
		if (!(current_token != VALA_MARKUP_TOKEN_TYPE_EOF)) {
			break;
		}
		_tmp18_ = reader;
		_tmp19_ = vala_markup_reader_get_name (_tmp18_);
		_tmp20_ = _tmp19_;
		current_name = _tmp20_;
		if (current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
			gboolean _tmp22_ = FALSE;
			const gchar* _tmp23_;
			_tmp23_ = current_name;
			if (g_strcmp0 (_tmp23_, "object") == 0) {
				_tmp22_ = TRUE;
			} else {
				const gchar* _tmp24_;
				_tmp24_ = current_name;
				_tmp22_ = g_strcmp0 (_tmp24_, "template") == 0;
			}
			_tmp21_ = _tmp22_;
		} else {
			_tmp21_ = FALSE;
		}
		if (_tmp21_) {
			const gchar* _tmp25_;
			ValaClass* _tmp33_;
			ValaClass* _tmp45_;
			_vala_code_node_unref0 (current_class);
			current_class = NULL;
			_tmp25_ = current_name;
			if (g_strcmp0 (_tmp25_, "object") == 0) {
				gchar* type_id = NULL;
				ValaMarkupReader* _tmp26_;
				gchar* _tmp27_;
				const gchar* _tmp28_;
				_tmp26_ = reader;
				_tmp27_ = vala_markup_reader_get_attribute (_tmp26_, "type-func");
				type_id = _tmp27_;
				_tmp28_ = type_id;
				if (_tmp28_ != NULL) {
					ValaHashMap* _tmp29_;
					const gchar* _tmp30_;
					gpointer _tmp31_;
					_tmp29_ = self->priv->type_id_to_vala_map;
					_tmp30_ = type_id;
					_tmp31_ = vala_map_get ((ValaMap*) _tmp29_, _tmp30_);
					_vala_code_node_unref0 (current_class);
					current_class = (ValaClass*) _tmp31_;
				}
				_g_free0 (type_id);
			} else {
				const gchar* _tmp32_;
				_tmp32_ = current_name;
				if (g_strcmp0 (_tmp32_, "template") == 0) {
					template_tag_found = TRUE;
				}
			}
			_tmp33_ = current_class;
			if (_tmp33_ == NULL) {
				gchar* class_name = NULL;
				ValaMarkupReader* _tmp34_;
				gchar* _tmp35_;
				const gchar* _tmp36_;
				ValaHashMap* _tmp42_;
				const gchar* _tmp43_;
				gpointer _tmp44_;
				_tmp34_ = reader;
				_tmp35_ = vala_markup_reader_get_attribute (_tmp34_, "class");
				class_name = _tmp35_;
				_tmp36_ = class_name;
				if (_tmp36_ == NULL) {
					ValaSourceReference* _tmp37_;
					ValaSourceReference* _tmp38_;
					const gchar* _tmp39_;
					const gchar* _tmp40_;
					ValaMarkupReader* _tmp41_;
					_tmp37_ = vala_code_node_get_source_reference (node);
					_tmp38_ = _tmp37_;
					_tmp39_ = current_name;
					_tmp40_ = ui_file;
					vala_report_error (_tmp38_, "Invalid %s in ui file `%s'", _tmp39_, _tmp40_);
					_tmp41_ = reader;
					current_token = vala_markup_reader_read_token (_tmp41_, NULL, NULL);
					_g_free0 (class_name);
					continue;
				}
				_tmp42_ = self->priv->cclass_to_vala_map;
				_tmp43_ = class_name;
				_tmp44_ = vala_map_get ((ValaMap*) _tmp42_, _tmp43_);
				_vala_code_node_unref0 (current_class);
				current_class = (ValaClass*) _tmp44_;
				_g_free0 (class_name);
			}
			_tmp45_ = current_class;
			if (_tmp45_ != NULL) {
				gchar* child_name = NULL;
				ValaMarkupReader* _tmp46_;
				gchar* _tmp47_;
				const gchar* _tmp48_;
				_tmp46_ = reader;
				_tmp47_ = vala_markup_reader_get_attribute (_tmp46_, "id");
				child_name = _tmp47_;
				_tmp48_ = child_name;
				if (_tmp48_ != NULL) {
					ValaHashMap* _tmp49_;
					const gchar* _tmp50_;
					ValaClass* _tmp51_;
					_tmp49_ = self->priv->current_child_to_class_map;
					_tmp50_ = child_name;
					_tmp51_ = current_class;
					vala_map_set ((ValaMap*) _tmp49_, _tmp50_, _tmp51_);
				}
				_g_free0 (child_name);
			}
		} else {
			gboolean _tmp52_ = FALSE;
			gboolean _tmp53_ = FALSE;
			ValaClass* _tmp54_;
			_tmp54_ = current_class;
			if (_tmp54_ != NULL) {
				_tmp53_ = current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT;
			} else {
				_tmp53_ = FALSE;
			}
			if (_tmp53_) {
				const gchar* _tmp55_;
				_tmp55_ = current_name;
				_tmp52_ = g_strcmp0 (_tmp55_, "signal") == 0;
			} else {
				_tmp52_ = FALSE;
			}
			if (_tmp52_) {
				gchar* signal_name = NULL;
				ValaMarkupReader* _tmp56_;
				gchar* _tmp57_;
				gchar* handler_name = NULL;
				ValaMarkupReader* _tmp58_;
				gchar* _tmp59_;
				ValaClass* _tmp60_;
				_tmp56_ = reader;
				_tmp57_ = vala_markup_reader_get_attribute (_tmp56_, "name");
				signal_name = _tmp57_;
				_tmp58_ = reader;
				_tmp59_ = vala_markup_reader_get_attribute (_tmp58_, "handler");
				handler_name = _tmp59_;
				_tmp60_ = current_class;
				if (_tmp60_ != NULL) {
					gboolean _tmp61_ = FALSE;
					const gchar* _tmp62_;
					gint sep_idx = 0;
					const gchar* _tmp77_;
					ValaSignal* sig = NULL;
					ValaClass* _tmp80_;
					const gchar* _tmp81_;
					gchar* _tmp82_;
					gchar* _tmp83_;
					ValaSymbol* _tmp84_;
					ValaSignal* _tmp85_;
					ValaSignal* _tmp86_;
					ValaSignal* _tmp87_;
					_tmp62_ = signal_name;
					if (_tmp62_ == NULL) {
						_tmp61_ = TRUE;
					} else {
						const gchar* _tmp63_;
						_tmp63_ = handler_name;
						_tmp61_ = _tmp63_ == NULL;
					}
					if (_tmp61_) {
						const gchar* _tmp64_;
						ValaMarkupReader* _tmp76_;
						_tmp64_ = signal_name;
						if (_tmp64_ != NULL) {
							ValaSourceReference* _tmp65_;
							ValaSourceReference* _tmp66_;
							const gchar* _tmp67_;
							const gchar* _tmp68_;
							_tmp65_ = vala_code_node_get_source_reference (node);
							_tmp66_ = _tmp65_;
							_tmp67_ = signal_name;
							_tmp68_ = ui_file;
							vala_report_error (_tmp66_, "Invalid signal `%s' without handler in ui file `%s'", _tmp67_, _tmp68_);
						} else {
							const gchar* _tmp69_;
							_tmp69_ = handler_name;
							if (_tmp69_ != NULL) {
								ValaSourceReference* _tmp70_;
								ValaSourceReference* _tmp71_;
								const gchar* _tmp72_;
								_tmp70_ = vala_code_node_get_source_reference (node);
								_tmp71_ = _tmp70_;
								_tmp72_ = ui_file;
								vala_report_error (_tmp71_, "Invalid signal without name in ui file `%s'", _tmp72_);
							} else {
								ValaSourceReference* _tmp73_;
								ValaSourceReference* _tmp74_;
								const gchar* _tmp75_;
								_tmp73_ = vala_code_node_get_source_reference (node);
								_tmp74_ = _tmp73_;
								_tmp75_ = ui_file;
								vala_report_error (_tmp74_, "Invalid signal without name and handler in ui file `%s'", _tmp75_);
							}
						}
						_tmp76_ = reader;
						current_token = vala_markup_reader_read_token (_tmp76_, NULL, NULL);
						_g_free0 (handler_name);
						_g_free0 (signal_name);
						continue;
					}
					_tmp77_ = signal_name;
					sep_idx = string_index_of (_tmp77_, "::", 0);
					if (sep_idx >= 0) {
						const gchar* _tmp78_;
						gchar* _tmp79_;
						_tmp78_ = signal_name;
						_tmp79_ = string_substring (_tmp78_, (glong) 0, (glong) sep_idx);
						_g_free0 (signal_name);
						signal_name = _tmp79_;
					}
					_tmp80_ = current_class;
					_tmp81_ = signal_name;
					_tmp82_ = string_replace (_tmp81_, "-", "_");
					_tmp83_ = _tmp82_;
					_tmp84_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) _tmp80_, _tmp83_);
					_tmp85_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp84_, VALA_TYPE_SIGNAL) ? ((ValaSignal*) _tmp84_) : NULL;
					if (_tmp85_ == NULL) {
						_vala_code_node_unref0 (_tmp84_);
					}
					_tmp86_ = _tmp85_;
					_g_free0 (_tmp83_);
					sig = _tmp86_;
					_tmp87_ = sig;
					if (_tmp87_ != NULL) {
						ValaHashMap* _tmp88_;
						const gchar* _tmp89_;
						ValaSignal* _tmp90_;
						_tmp88_ = self->priv->current_handler_to_signal_map;
						_tmp89_ = handler_name;
						_tmp90_ = sig;
						vala_map_set ((ValaMap*) _tmp88_, _tmp89_, _tmp90_);
					}
					_vala_code_node_unref0 (sig);
				}
				_g_free0 (handler_name);
				_g_free0 (signal_name);
			} else {
				gboolean _tmp91_ = FALSE;
				gboolean _tmp92_ = FALSE;
				ValaClass* _tmp93_;
				_tmp93_ = current_class;
				if (_tmp93_ != NULL) {
					_tmp92_ = current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT;
				} else {
					_tmp92_ = FALSE;
				}
				if (_tmp92_) {
					const gchar* _tmp94_;
					_tmp94_ = current_name;
					_tmp91_ = g_strcmp0 (_tmp94_, "binding") == 0;
				} else {
					_tmp91_ = FALSE;
				}
				if (_tmp91_) {
					gchar* property_name = NULL;
					ValaMarkupReader* _tmp95_;
					gchar* _tmp96_;
					const gchar* _tmp97_;
					const gchar* _tmp102_;
					gchar* _tmp103_;
					ValaClass* _tmp104_;
					const gchar* _tmp105_;
					ValaSymbol* _tmp106_;
					ValaProperty* _tmp107_;
					ValaProperty* _tmp108_;
					_tmp95_ = reader;
					_tmp96_ = vala_markup_reader_get_attribute (_tmp95_, "name");
					property_name = _tmp96_;
					_tmp97_ = property_name;
					if (_tmp97_ == NULL) {
						ValaSourceReference* _tmp98_;
						ValaSourceReference* _tmp99_;
						const gchar* _tmp100_;
						ValaMarkupReader* _tmp101_;
						_tmp98_ = vala_code_node_get_source_reference (node);
						_tmp99_ = _tmp98_;
						_tmp100_ = ui_file;
						vala_report_error (_tmp99_, "Invalid binding in ui file `%s'", _tmp100_);
						_tmp101_ = reader;
						current_token = vala_markup_reader_read_token (_tmp101_, NULL, NULL);
						_g_free0 (property_name);
						continue;
					}
					_tmp102_ = property_name;
					_tmp103_ = string_replace (_tmp102_, "-", "_");
					_g_free0 (property_name);
					property_name = _tmp103_;
					_tmp104_ = current_class;
					_tmp105_ = property_name;
					_tmp106_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) _tmp104_, _tmp105_);
					_tmp107_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp106_, VALA_TYPE_PROPERTY) ? ((ValaProperty*) _tmp106_) : NULL;
					if (_tmp107_ == NULL) {
						_vala_code_node_unref0 (_tmp106_);
					}
					_vala_code_node_unref0 (current_property);
					current_property = _tmp107_;
					_tmp108_ = current_property;
					if (_tmp108_ == NULL) {
						ValaSourceReference* _tmp109_;
						ValaSourceReference* _tmp110_;
						ValaClass* _tmp111_;
						gchar* _tmp112_;
						gchar* _tmp113_;
						const gchar* _tmp114_;
						const gchar* _tmp115_;
						ValaMarkupReader* _tmp116_;
						_tmp109_ = vala_code_node_get_source_reference (node);
						_tmp110_ = _tmp109_;
						_tmp111_ = current_class;
						_tmp112_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp111_);
						_tmp113_ = _tmp112_;
						_tmp114_ = property_name;
						_tmp115_ = ui_file;
						vala_report_error (_tmp110_, "Unknown property `%s:%s' for binding in ui file `%s'", _tmp113_, _tmp114_, _tmp115_);
						_g_free0 (_tmp113_);
						_tmp116_ = reader;
						current_token = vala_markup_reader_read_token (_tmp116_, NULL, NULL);
						_g_free0 (property_name);
						continue;
					}
					_g_free0 (property_name);
				} else {
					gboolean _tmp117_ = FALSE;
					gboolean _tmp118_ = FALSE;
					ValaClass* _tmp119_;
					_tmp119_ = current_class;
					if (_tmp119_ != NULL) {
						_tmp118_ = current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT;
					} else {
						_tmp118_ = FALSE;
					}
					if (_tmp118_) {
						const gchar* _tmp120_;
						_tmp120_ = current_name;
						_tmp117_ = g_strcmp0 (_tmp120_, "closure") == 0;
					} else {
						_tmp117_ = FALSE;
					}
					if (_tmp117_) {
						gchar* handler_name = NULL;
						ValaMarkupReader* _tmp121_;
						gchar* _tmp122_;
						ValaProperty* _tmp123_;
						_tmp121_ = reader;
						_tmp122_ = vala_markup_reader_get_attribute (_tmp121_, "function");
						handler_name = _tmp122_;
						_tmp123_ = current_property;
						if (_tmp123_ != NULL) {
							const gchar* _tmp124_;
							ValaHashMap* _tmp129_;
							const gchar* _tmp130_;
							ValaProperty* _tmp131_;
							_tmp124_ = handler_name;
							if (_tmp124_ == NULL) {
								ValaSourceReference* _tmp125_;
								ValaSourceReference* _tmp126_;
								const gchar* _tmp127_;
								ValaMarkupReader* _tmp128_;
								_tmp125_ = vala_code_node_get_source_reference (node);
								_tmp126_ = _tmp125_;
								_tmp127_ = ui_file;
								vala_report_error (_tmp126_, "Invalid closure in ui file `%s'", _tmp127_);
								_tmp128_ = reader;
								current_token = vala_markup_reader_read_token (_tmp128_, NULL, NULL);
								_g_free0 (handler_name);
								continue;
							}
							_tmp129_ = self->priv->current_handler_to_property_map;
							_tmp130_ = handler_name;
							_tmp131_ = current_property;
							vala_map_set ((ValaMap*) _tmp129_, _tmp130_, _tmp131_);
							_vala_code_node_unref0 (current_property);
							current_property = NULL;
						}
						_g_free0 (handler_name);
					}
				}
			}
		}
		_tmp132_ = reader;
		current_token = vala_markup_reader_read_token (_tmp132_, NULL, NULL);
	}
	if (!template_tag_found) {
		ValaSourceReference* _tmp133_;
		ValaSourceReference* _tmp134_;
		_tmp133_ = vala_code_node_get_source_reference (node);
		_tmp134_ = _tmp133_;
		vala_report_error (_tmp134_, "ui resource `%s' does not describe a valid composite template", ui_resource);
	}
	_vala_code_node_unref0 (current_property);
	_vala_code_node_unref0 (current_class);
	_vala_markup_reader_unref0 (reader);
	_g_free0 (ui_file);
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_gtk_module_is_gtk_template (ValaGtkModule* self,
                                 ValaClass* cl)
{
	ValaAttribute* attr = NULL;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	ValaAttribute* _tmp2_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cl != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) cl, "GtkTemplate");
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	attr = _tmp1_;
	_tmp2_ = attr;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		ValaClass* _tmp4_;
		_tmp4_ = ((ValaCCodeBaseModule*) self)->gtk_widget_type;
		if (_tmp4_ == NULL) {
			_tmp3_ = TRUE;
		} else {
			ValaClass* _tmp5_;
			_tmp5_ = ((ValaCCodeBaseModule*) self)->gtk_widget_type;
			_tmp3_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) cl, (ValaTypeSymbol*) _tmp5_);
		}
		if (_tmp3_) {
			gboolean _tmp6_;
			gboolean _tmp7_;
			_tmp6_ = vala_code_node_get_error ((ValaCodeNode*) cl);
			_tmp7_ = _tmp6_;
			if (!_tmp7_) {
				ValaAttribute* _tmp8_;
				ValaSourceReference* _tmp9_;
				ValaSourceReference* _tmp10_;
				_tmp8_ = attr;
				_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp8_);
				_tmp10_ = _tmp9_;
				vala_report_error (_tmp10_, "subclassing Gtk.Widget is required for using Gtk templates");
				vala_code_node_set_error ((ValaCodeNode*) cl, TRUE);
			}
			result = FALSE;
			_vala_code_node_unref0 (attr);
			return result;
		}
		result = TRUE;
		_vala_code_node_unref0 (attr);
		return result;
	}
	result = FALSE;
	_vala_code_node_unref0 (attr);
	return result;
}

static void
vala_gtk_module_real_generate_class_init (ValaGTypeModule* base,
                                          ValaClass* cl)
{
	ValaGtkModule * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gchar* ui = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp7_;
	ValaCCodeFunctionCall* call = NULL;
	ValaCCodeIdentifier* _tmp8_;
	ValaCCodeIdentifier* _tmp9_;
	ValaCCodeFunctionCall* _tmp10_;
	ValaCCodeFunctionCall* _tmp11_;
	ValaCCodeFunctionCall* _tmp12_;
	ValaCCodeIdentifier* _tmp13_;
	ValaCCodeIdentifier* _tmp14_;
	ValaCCodeFunctionCall* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeConstant* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaCCodeFunction* _tmp22_;
	ValaCCodeFunctionCall* _tmp23_;
	ValaList* _tmp24_;
	self = (ValaGtkModule*) base;
	g_return_if_fail (cl != NULL);
	VALA_GTYPE_MODULE_CLASS (vala_gtk_module_parent_class)->generate_class_init ((ValaGTypeModule*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModule), cl);
	_tmp1_ = vala_code_node_get_error ((ValaCodeNode*) cl);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !vala_gtk_module_is_gtk_template (self, cl);
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = vala_code_node_get_attribute_string ((ValaCodeNode*) cl, "GtkTemplate", "ui", NULL);
	ui = _tmp3_;
	_tmp4_ = ui;
	if (_tmp4_ == NULL) {
		ValaSourceReference* _tmp5_;
		ValaSourceReference* _tmp6_;
		_tmp5_ = vala_code_node_get_source_reference ((ValaCodeNode*) cl);
		_tmp6_ = _tmp5_;
		vala_report_error (_tmp6_, "empty ui resource declaration for Gtk widget template");
		vala_code_node_set_error ((ValaCodeNode*) cl, TRUE);
		_g_free0 (ui);
		return;
	}
	_tmp7_ = ui;
	vala_gtk_module_process_current_ui_resource (self, _tmp7_, (ValaCodeNode*) cl);
	_tmp8_ = vala_ccode_identifier_new ("gtk_widget_class_set_template_from_resource");
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp9_);
	_tmp11_ = _tmp10_;
	_vala_ccode_node_unref0 (_tmp9_);
	call = _tmp11_;
	_tmp12_ = call;
	_tmp13_ = vala_ccode_identifier_new ("GTK_WIDGET_CLASS (klass)");
	_tmp14_ = _tmp13_;
	vala_ccode_function_call_add_argument (_tmp12_, (ValaCCodeExpression*) _tmp14_);
	_vala_ccode_node_unref0 (_tmp14_);
	_tmp15_ = call;
	_tmp16_ = ui;
	_tmp17_ = g_strdup_printf ("\"%s\"", _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = vala_ccode_constant_new (_tmp18_);
	_tmp20_ = _tmp19_;
	vala_ccode_function_call_add_argument (_tmp15_, (ValaCCodeExpression*) _tmp20_);
	_vala_ccode_node_unref0 (_tmp20_);
	_g_free0 (_tmp18_);
	_tmp21_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp22_ = _tmp21_;
	_tmp23_ = call;
	vala_ccode_function_add_expression (_tmp22_, (ValaCCodeExpression*) _tmp23_);
	_tmp24_ = self->priv->current_required_app_classes;
	vala_collection_clear ((ValaCollection*) _tmp24_);
	_vala_ccode_node_unref0 (call);
	_g_free0 (ui);
}

static void
vala_gtk_module_real_visit_property (ValaCodeVisitor* base,
                                     ValaProperty* prop)
{
	ValaGtkModule * self;
	gboolean _tmp0_ = FALSE;
	ValaAttribute* _tmp1_;
	self = (ValaGtkModule*) base;
	g_return_if_fail (prop != NULL);
	_tmp1_ = vala_code_node_get_attribute ((ValaCodeNode*) prop, "GtkChild");
	if (_tmp1_ != NULL) {
		ValaField* _tmp2_;
		ValaField* _tmp3_;
		_tmp2_ = vala_property_get_field (prop);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) prop);
		_tmp5_ = _tmp4_;
		vala_report_error (_tmp5_, "[GtkChild] is only allowed on automatic properties");
	}
	VALA_CODE_VISITOR_CLASS (vala_gtk_module_parent_class)->visit_property ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModule), prop);
}

static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}

static void
vala_gtk_module_real_visit_field (ValaCodeVisitor* base,
                                  ValaField* f)
{
	ValaGtkModule * self;
	ValaClass* cl = NULL;
	ValaClass* _tmp0_;
	ValaClass* _tmp1_;
	ValaClass* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaClass* _tmp4_;
	gboolean _tmp8_ = FALSE;
	ValaMemberBinding _tmp9_;
	ValaMemberBinding _tmp10_;
	ValaClass* _tmp12_;
	ValaCCodeBaseModuleEmitContext* _tmp15_;
	gchar* gtk_name = NULL;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	ValaClass* child_class = NULL;
	ValaHashMap* _tmp19_;
	const gchar* _tmp20_;
	gpointer _tmp21_;
	ValaClass* _tmp22_;
	ValaClass* field_class = NULL;
	ValaDataType* _tmp26_;
	ValaDataType* _tmp27_;
	ValaTypeSymbol* _tmp28_;
	ValaTypeSymbol* _tmp29_;
	gboolean _tmp30_ = FALSE;
	ValaClass* _tmp31_;
	gboolean internal_child = FALSE;
	ValaCCodeExpression* offset = NULL;
	ValaCCodeFunctionCall* call = NULL;
	ValaCCodeIdentifier* _tmp85_;
	ValaCCodeIdentifier* _tmp86_;
	ValaCCodeFunctionCall* _tmp87_;
	ValaCCodeFunctionCall* _tmp88_;
	ValaCCodeFunctionCall* _tmp89_;
	ValaCCodeIdentifier* _tmp90_;
	ValaCCodeIdentifier* _tmp91_;
	ValaCCodeFunctionCall* _tmp92_;
	const gchar* _tmp93_;
	gchar* _tmp94_;
	gchar* _tmp95_;
	ValaCCodeConstant* _tmp96_;
	ValaCCodeConstant* _tmp97_;
	const gchar* _tmp98_ = NULL;
	ValaCCodeFunctionCall* _tmp99_;
	ValaCCodeConstant* _tmp100_;
	ValaCCodeConstant* _tmp101_;
	ValaCCodeFunctionCall* _tmp102_;
	ValaCCodeExpression* _tmp103_;
	ValaCCodeFunction* _tmp104_;
	ValaCCodeFunction* _tmp105_;
	ValaCCodeFunctionCall* _tmp106_;
	gboolean _tmp107_ = FALSE;
	ValaClass* _tmp108_;
	gboolean _tmp109_;
	gboolean _tmp110_;
	self = (ValaGtkModule*) base;
	g_return_if_fail (f != NULL);
	VALA_CODE_VISITOR_CLASS (vala_gtk_module_parent_class)->visit_field ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModule), f);
	_tmp0_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (_tmp1_);
	cl = _tmp2_;
	_tmp4_ = cl;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		ValaClass* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = cl;
		_tmp6_ = vala_code_node_get_error ((ValaCodeNode*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_;
	}
	if (_tmp3_) {
		_vala_code_node_unref0 (cl);
		return;
	}
	_tmp9_ = vala_field_get_binding (f);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != VALA_MEMBER_BINDING_INSTANCE) {
		_tmp8_ = TRUE;
	} else {
		ValaAttribute* _tmp11_;
		_tmp11_ = vala_code_node_get_attribute ((ValaCodeNode*) f, "GtkChild");
		_tmp8_ = _tmp11_ == NULL;
	}
	if (_tmp8_) {
		_vala_code_node_unref0 (cl);
		return;
	}
	_tmp12_ = cl;
	if (!vala_gtk_module_is_gtk_template (self, _tmp12_)) {
		ValaSourceReference* _tmp13_;
		ValaSourceReference* _tmp14_;
		_tmp13_ = vala_code_node_get_source_reference ((ValaCodeNode*) f);
		_tmp14_ = _tmp13_;
		vala_report_error (_tmp14_, "[GtkChild] is only allowed in classes with a [GtkTemplate] attribute");
		_vala_code_node_unref0 (cl);
		return;
	}
	_tmp15_ = ((ValaCCodeBaseModule*) self)->class_init_context;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp15_);
	_tmp16_ = vala_symbol_get_name ((ValaSymbol*) f);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_code_node_get_attribute_string ((ValaCodeNode*) f, "GtkChild", "name", _tmp17_);
	gtk_name = _tmp18_;
	_tmp19_ = self->priv->current_child_to_class_map;
	_tmp20_ = gtk_name;
	_tmp21_ = vala_map_get ((ValaMap*) _tmp19_, _tmp20_);
	child_class = (ValaClass*) _tmp21_;
	_tmp22_ = child_class;
	if (_tmp22_ == NULL) {
		ValaSourceReference* _tmp23_;
		ValaSourceReference* _tmp24_;
		const gchar* _tmp25_;
		_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) f);
		_tmp24_ = _tmp23_;
		_tmp25_ = gtk_name;
		vala_report_error (_tmp24_, "could not find child `%s'", _tmp25_);
		_vala_code_node_unref0 (child_class);
		_g_free0 (gtk_name);
		_vala_code_node_unref0 (cl);
		return;
	}
	_tmp26_ = vala_variable_get_variable_type ((ValaVariable*) f);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_data_type_get_type_symbol (_tmp27_);
	_tmp29_ = _tmp28_;
	field_class = G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp29_) : NULL;
	_tmp31_ = field_class;
	if (_tmp31_ == NULL) {
		_tmp30_ = TRUE;
	} else {
		ValaClass* _tmp32_;
		ValaClass* _tmp33_;
		_tmp32_ = child_class;
		_tmp33_ = field_class;
		_tmp30_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp32_, (ValaTypeSymbol*) _tmp33_);
	}
	if (_tmp30_) {
		ValaSourceReference* _tmp34_;
		ValaSourceReference* _tmp35_;
		ValaClass* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		ValaClass* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) f);
		_tmp35_ = _tmp34_;
		_tmp36_ = child_class;
		_tmp37_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = field_class;
		_tmp40_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp39_);
		_tmp41_ = _tmp40_;
		vala_report_error (_tmp35_, "cannot convert from Gtk child type `%s' to `%s'", _tmp38_, _tmp41_);
		_g_free0 (_tmp41_);
		_g_free0 (_tmp38_);
		_vala_code_node_unref0 (child_class);
		_g_free0 (gtk_name);
		_vala_code_node_unref0 (cl);
		return;
	}
	internal_child = vala_code_node_get_attribute_bool ((ValaCodeNode*) f, "GtkChild", "internal", FALSE);
	if (vala_symbol_is_private_symbol ((ValaSymbol*) f)) {
		ValaCCodeFunctionCall* private_field_offset = NULL;
		ValaCCodeIdentifier* _tmp42_;
		ValaCCodeIdentifier* _tmp43_;
		ValaCCodeFunctionCall* _tmp44_;
		ValaCCodeFunctionCall* _tmp45_;
		ValaCCodeFunctionCall* _tmp46_;
		ValaClass* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		ValaCCodeIdentifier* _tmp52_;
		ValaCCodeIdentifier* _tmp53_;
		ValaCCodeFunctionCall* _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		ValaCCodeIdentifier* _tmp57_;
		ValaCCodeIdentifier* _tmp58_;
		ValaClass* _tmp59_;
		gchar* _tmp60_;
		gchar* _tmp61_;
		gchar* _tmp62_;
		gchar* _tmp63_;
		ValaCCodeIdentifier* _tmp64_;
		ValaCCodeIdentifier* _tmp65_;
		ValaCCodeFunctionCall* _tmp66_;
		ValaCCodeBinaryExpression* _tmp67_;
		_tmp42_ = vala_ccode_identifier_new ("G_STRUCT_OFFSET");
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp43_);
		_tmp45_ = _tmp44_;
		_vala_ccode_node_unref0 (_tmp43_);
		private_field_offset = _tmp45_;
		_tmp46_ = private_field_offset;
		_tmp47_ = cl;
		_tmp48_ = vala_get_ccode_name ((ValaCodeNode*) _tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = g_strdup_printf ("%sPrivate", _tmp49_);
		_tmp51_ = _tmp50_;
		_tmp52_ = vala_ccode_identifier_new (_tmp51_);
		_tmp53_ = _tmp52_;
		vala_ccode_function_call_add_argument (_tmp46_, (ValaCCodeExpression*) _tmp53_);
		_vala_ccode_node_unref0 (_tmp53_);
		_g_free0 (_tmp51_);
		_g_free0 (_tmp49_);
		_tmp54_ = private_field_offset;
		_tmp55_ = vala_get_ccode_name ((ValaCodeNode*) f);
		_tmp56_ = _tmp55_;
		_tmp57_ = vala_ccode_identifier_new (_tmp56_);
		_tmp58_ = _tmp57_;
		vala_ccode_function_call_add_argument (_tmp54_, (ValaCCodeExpression*) _tmp58_);
		_vala_ccode_node_unref0 (_tmp58_);
		_g_free0 (_tmp56_);
		_tmp59_ = cl;
		_tmp60_ = vala_get_ccode_name ((ValaCodeNode*) _tmp59_);
		_tmp61_ = _tmp60_;
		_tmp62_ = g_strdup_printf ("%s_private_offset", _tmp61_);
		_tmp63_ = _tmp62_;
		_tmp64_ = vala_ccode_identifier_new (_tmp63_);
		_tmp65_ = _tmp64_;
		_tmp66_ = private_field_offset;
		_tmp67_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp65_, (ValaCCodeExpression*) _tmp66_);
		_vala_ccode_node_unref0 (offset);
		offset = (ValaCCodeExpression*) _tmp67_;
		_vala_ccode_node_unref0 (_tmp65_);
		_g_free0 (_tmp63_);
		_g_free0 (_tmp61_);
		_vala_ccode_node_unref0 (private_field_offset);
	} else {
		ValaCCodeFunctionCall* offset_call = NULL;
		ValaCCodeIdentifier* _tmp68_;
		ValaCCodeIdentifier* _tmp69_;
		ValaCCodeFunctionCall* _tmp70_;
		ValaCCodeFunctionCall* _tmp71_;
		ValaCCodeFunctionCall* _tmp72_;
		ValaClass* _tmp73_;
		gchar* _tmp74_;
		gchar* _tmp75_;
		ValaCCodeIdentifier* _tmp76_;
		ValaCCodeIdentifier* _tmp77_;
		ValaCCodeFunctionCall* _tmp78_;
		gchar* _tmp79_;
		gchar* _tmp80_;
		ValaCCodeIdentifier* _tmp81_;
		ValaCCodeIdentifier* _tmp82_;
		ValaCCodeFunctionCall* _tmp83_;
		ValaCCodeExpression* _tmp84_;
		_tmp68_ = vala_ccode_identifier_new ("G_STRUCT_OFFSET");
		_tmp69_ = _tmp68_;
		_tmp70_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp69_);
		_tmp71_ = _tmp70_;
		_vala_ccode_node_unref0 (_tmp69_);
		offset_call = _tmp71_;
		_tmp72_ = offset_call;
		_tmp73_ = cl;
		_tmp74_ = vala_get_ccode_name ((ValaCodeNode*) _tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = vala_ccode_identifier_new (_tmp75_);
		_tmp77_ = _tmp76_;
		vala_ccode_function_call_add_argument (_tmp72_, (ValaCCodeExpression*) _tmp77_);
		_vala_ccode_node_unref0 (_tmp77_);
		_g_free0 (_tmp75_);
		_tmp78_ = offset_call;
		_tmp79_ = vala_get_ccode_name ((ValaCodeNode*) f);
		_tmp80_ = _tmp79_;
		_tmp81_ = vala_ccode_identifier_new (_tmp80_);
		_tmp82_ = _tmp81_;
		vala_ccode_function_call_add_argument (_tmp78_, (ValaCCodeExpression*) _tmp82_);
		_vala_ccode_node_unref0 (_tmp82_);
		_g_free0 (_tmp80_);
		_tmp83_ = offset_call;
		_tmp84_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp83_);
		_vala_ccode_node_unref0 (offset);
		offset = _tmp84_;
		_vala_ccode_node_unref0 (offset_call);
	}
	_tmp85_ = vala_ccode_identifier_new ("gtk_widget_class_bind_template_child_full");
	_tmp86_ = _tmp85_;
	_tmp87_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp86_);
	_tmp88_ = _tmp87_;
	_vala_ccode_node_unref0 (_tmp86_);
	call = _tmp88_;
	_tmp89_ = call;
	_tmp90_ = vala_ccode_identifier_new ("GTK_WIDGET_CLASS (klass)");
	_tmp91_ = _tmp90_;
	vala_ccode_function_call_add_argument (_tmp89_, (ValaCCodeExpression*) _tmp91_);
	_vala_ccode_node_unref0 (_tmp91_);
	_tmp92_ = call;
	_tmp93_ = gtk_name;
	_tmp94_ = g_strdup_printf ("\"%s\"", _tmp93_);
	_tmp95_ = _tmp94_;
	_tmp96_ = vala_ccode_constant_new (_tmp95_);
	_tmp97_ = _tmp96_;
	vala_ccode_function_call_add_argument (_tmp92_, (ValaCCodeExpression*) _tmp97_);
	_vala_ccode_node_unref0 (_tmp97_);
	_g_free0 (_tmp95_);
	if (internal_child) {
		_tmp98_ = "TRUE";
	} else {
		_tmp98_ = "FALSE";
	}
	_tmp99_ = call;
	_tmp100_ = vala_ccode_constant_new (_tmp98_);
	_tmp101_ = _tmp100_;
	vala_ccode_function_call_add_argument (_tmp99_, (ValaCCodeExpression*) _tmp101_);
	_vala_ccode_node_unref0 (_tmp101_);
	_tmp102_ = call;
	_tmp103_ = offset;
	vala_ccode_function_call_add_argument (_tmp102_, _tmp103_);
	_tmp104_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp105_ = _tmp104_;
	_tmp106_ = call;
	vala_ccode_function_add_expression (_tmp105_, (ValaCCodeExpression*) _tmp106_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	_tmp108_ = field_class;
	_tmp109_ = vala_symbol_get_external ((ValaSymbol*) _tmp108_);
	_tmp110_ = _tmp109_;
	if (!_tmp110_) {
		ValaClass* _tmp111_;
		gboolean _tmp112_;
		gboolean _tmp113_;
		_tmp111_ = field_class;
		_tmp112_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp111_);
		_tmp113_ = _tmp112_;
		_tmp107_ = !_tmp113_;
	} else {
		_tmp107_ = FALSE;
	}
	if (_tmp107_) {
		ValaList* _tmp114_;
		ValaClass* _tmp115_;
		_tmp114_ = self->priv->current_required_app_classes;
		_tmp115_ = field_class;
		vala_collection_add ((ValaCollection*) _tmp114_, _tmp115_);
	}
	_vala_ccode_node_unref0 (call);
	_vala_ccode_node_unref0 (offset);
	_vala_code_node_unref0 (child_class);
	_g_free0 (gtk_name);
	_vala_code_node_unref0 (cl);
}

static void
vala_gtk_module_real_visit_method (ValaCodeVisitor* base,
                                   ValaMethod* m)
{
	ValaGtkModule * self;
	ValaClass* cl = NULL;
	ValaClass* _tmp0_;
	ValaClass* _tmp1_;
	ValaClass* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	ValaClass* _tmp5_;
	gboolean _tmp10_ = FALSE;
	ValaMemberBinding _tmp11_;
	ValaMemberBinding _tmp12_;
	gchar* handler_name = NULL;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	ValaSignal* sig = NULL;
	ValaHashMap* _tmp17_;
	const gchar* _tmp18_;
	gpointer _tmp19_;
	ValaProperty* prop = NULL;
	ValaHashMap* _tmp20_;
	const gchar* _tmp21_;
	gpointer _tmp22_;
	gboolean _tmp23_ = FALSE;
	ValaSignal* _tmp24_;
	ValaCCodeBaseModuleEmitContext* _tmp29_;
	ValaSignal* _tmp30_;
	ValaProperty* _tmp81_;
	self = (ValaGtkModule*) base;
	g_return_if_fail (m != NULL);
	VALA_CODE_VISITOR_CLASS (vala_gtk_module_parent_class)->visit_method ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModule), m);
	_tmp0_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (_tmp1_);
	cl = _tmp2_;
	_tmp5_ = cl;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		ValaClass* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp6_ = cl;
		_tmp7_ = vala_code_node_get_error ((ValaCodeNode*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		ValaClass* _tmp9_;
		_tmp9_ = cl;
		_tmp3_ = !vala_gtk_module_is_gtk_template (self, _tmp9_);
	}
	if (_tmp3_) {
		_vala_code_node_unref0 (cl);
		return;
	}
	_tmp11_ = vala_method_get_binding (m);
	_tmp12_ = _tmp11_;
	if (_tmp12_ != VALA_MEMBER_BINDING_INSTANCE) {
		_tmp10_ = TRUE;
	} else {
		ValaAttribute* _tmp13_;
		_tmp13_ = vala_code_node_get_attribute ((ValaCodeNode*) m, "GtkCallback");
		_tmp10_ = _tmp13_ == NULL;
	}
	if (_tmp10_) {
		_vala_code_node_unref0 (cl);
		return;
	}
	_tmp14_ = vala_symbol_get_name ((ValaSymbol*) m);
	_tmp15_ = _tmp14_;
	_tmp16_ = vala_code_node_get_attribute_string ((ValaCodeNode*) m, "GtkCallback", "name", _tmp15_);
	handler_name = _tmp16_;
	_tmp17_ = self->priv->current_handler_to_signal_map;
	_tmp18_ = handler_name;
	_tmp19_ = vala_map_get ((ValaMap*) _tmp17_, _tmp18_);
	sig = (ValaSignal*) _tmp19_;
	_tmp20_ = self->priv->current_handler_to_property_map;
	_tmp21_ = handler_name;
	_tmp22_ = vala_map_get ((ValaMap*) _tmp20_, _tmp21_);
	prop = (ValaProperty*) _tmp22_;
	_tmp24_ = sig;
	if (_tmp24_ == NULL) {
		ValaProperty* _tmp25_;
		_tmp25_ = prop;
		_tmp23_ = _tmp25_ == NULL;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		ValaSourceReference* _tmp26_;
		ValaSourceReference* _tmp27_;
		const gchar* _tmp28_;
		_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp27_ = _tmp26_;
		_tmp28_ = handler_name;
		vala_report_error (_tmp27_, "could not find signal or property for handler `%s'", _tmp28_);
		_vala_code_node_unref0 (prop);
		_vala_code_node_unref0 (sig);
		_g_free0 (handler_name);
		_vala_code_node_unref0 (cl);
		return;
	}
	_tmp29_ = ((ValaCCodeBaseModule*) self)->class_init_context;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp29_);
	_tmp30_ = sig;
	if (_tmp30_ != NULL) {
		ValaSignal* _tmp31_;
		ValaCodeContext* _tmp32_;
		ValaCodeContext* _tmp33_;
		ValaMethodType* method_type = NULL;
		ValaMethodType* _tmp34_;
		ValaSignalType* signal_type = NULL;
		ValaSignal* _tmp35_;
		ValaSignalType* _tmp36_;
		ValaDelegateType* delegate_type = NULL;
		ValaSignalType* _tmp37_;
		ValaDelegateType* _tmp38_;
		ValaMethodType* _tmp39_;
		ValaDelegateType* _tmp40_;
		_tmp31_ = sig;
		_tmp32_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp33_ = _tmp32_;
		vala_code_node_check ((ValaCodeNode*) _tmp31_, _tmp33_);
		_tmp34_ = vala_method_type_new (m);
		method_type = _tmp34_;
		_tmp35_ = sig;
		_tmp36_ = vala_signal_type_new (_tmp35_);
		signal_type = _tmp36_;
		_tmp37_ = signal_type;
		_tmp38_ = vala_signal_type_get_handler_type (_tmp37_);
		delegate_type = _tmp38_;
		_tmp39_ = method_type;
		_tmp40_ = delegate_type;
		if (!vala_data_type_compatible ((ValaDataType*) _tmp39_, (ValaDataType*) _tmp40_)) {
			ValaSourceReference* _tmp41_;
			ValaSourceReference* _tmp42_;
			ValaMethodType* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			ValaDelegateType* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			ValaDelegateType* _tmp49_;
			const gchar* _tmp50_;
			const gchar* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			_tmp41_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
			_tmp42_ = _tmp41_;
			_tmp43_ = method_type;
			_tmp44_ = vala_code_node_to_string ((ValaCodeNode*) _tmp43_);
			_tmp45_ = _tmp44_;
			_tmp46_ = delegate_type;
			_tmp47_ = vala_code_node_to_string ((ValaCodeNode*) _tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = delegate_type;
			_tmp50_ = vala_symbol_get_name ((ValaSymbol*) m);
			_tmp51_ = _tmp50_;
			_tmp52_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp49_, _tmp51_);
			_tmp53_ = _tmp52_;
			vala_report_error (_tmp42_, "method `%s' is incompatible with signal `%s', expected `%s'", _tmp45_, _tmp48_, _tmp53_);
			_g_free0 (_tmp53_);
			_g_free0 (_tmp48_);
			_g_free0 (_tmp45_);
		} else {
			gchar* wrapper = NULL;
			ValaSignalType* _tmp54_;
			ValaDelegateType* _tmp55_;
			ValaDelegateType* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			ValaCCodeFunctionCall* call = NULL;
			ValaCCodeIdentifier* _tmp59_;
			ValaCCodeIdentifier* _tmp60_;
			ValaCCodeFunctionCall* _tmp61_;
			ValaCCodeFunctionCall* _tmp62_;
			ValaCCodeFunctionCall* _tmp63_;
			ValaCCodeIdentifier* _tmp64_;
			ValaCCodeIdentifier* _tmp65_;
			ValaCCodeFunctionCall* _tmp66_;
			const gchar* _tmp67_;
			gchar* _tmp68_;
			gchar* _tmp69_;
			ValaCCodeConstant* _tmp70_;
			ValaCCodeConstant* _tmp71_;
			ValaCCodeFunctionCall* _tmp72_;
			const gchar* _tmp73_;
			gchar* _tmp74_;
			gchar* _tmp75_;
			ValaCCodeIdentifier* _tmp76_;
			ValaCCodeIdentifier* _tmp77_;
			ValaCCodeFunction* _tmp78_;
			ValaCCodeFunction* _tmp79_;
			ValaCCodeFunctionCall* _tmp80_;
			_tmp54_ = signal_type;
			_tmp55_ = vala_signal_type_get_handler_type (_tmp54_);
			_tmp56_ = _tmp55_;
			_tmp57_ = vala_ccode_delegate_module_generate_delegate_wrapper ((ValaCCodeDelegateModule*) self, m, _tmp56_, (ValaCodeNode*) m);
			_tmp58_ = _tmp57_;
			_vala_code_node_unref0 (_tmp56_);
			wrapper = _tmp58_;
			_tmp59_ = vala_ccode_identifier_new ("gtk_widget_class_bind_template_callback_full");
			_tmp60_ = _tmp59_;
			_tmp61_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp60_);
			_tmp62_ = _tmp61_;
			_vala_ccode_node_unref0 (_tmp60_);
			call = _tmp62_;
			_tmp63_ = call;
			_tmp64_ = vala_ccode_identifier_new ("GTK_WIDGET_CLASS (klass)");
			_tmp65_ = _tmp64_;
			vala_ccode_function_call_add_argument (_tmp63_, (ValaCCodeExpression*) _tmp65_);
			_vala_ccode_node_unref0 (_tmp65_);
			_tmp66_ = call;
			_tmp67_ = handler_name;
			_tmp68_ = g_strdup_printf ("\"%s\"", _tmp67_);
			_tmp69_ = _tmp68_;
			_tmp70_ = vala_ccode_constant_new (_tmp69_);
			_tmp71_ = _tmp70_;
			vala_ccode_function_call_add_argument (_tmp66_, (ValaCCodeExpression*) _tmp71_);
			_vala_ccode_node_unref0 (_tmp71_);
			_g_free0 (_tmp69_);
			_tmp72_ = call;
			_tmp73_ = wrapper;
			_tmp74_ = g_strdup_printf ("G_CALLBACK(%s)", _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp76_ = vala_ccode_identifier_new (_tmp75_);
			_tmp77_ = _tmp76_;
			vala_ccode_function_call_add_argument (_tmp72_, (ValaCCodeExpression*) _tmp77_);
			_vala_ccode_node_unref0 (_tmp77_);
			_g_free0 (_tmp75_);
			_tmp78_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp79_ = _tmp78_;
			_tmp80_ = call;
			vala_ccode_function_add_expression (_tmp79_, (ValaCCodeExpression*) _tmp80_);
			_vala_ccode_node_unref0 (call);
			_g_free0 (wrapper);
		}
		_vala_code_node_unref0 (delegate_type);
		_vala_code_node_unref0 (signal_type);
		_vala_code_node_unref0 (method_type);
	}
	_tmp81_ = prop;
	if (_tmp81_ != NULL) {
		ValaProperty* _tmp82_;
		ValaCodeContext* _tmp83_;
		ValaCodeContext* _tmp84_;
		ValaCCodeFunctionCall* call = NULL;
		ValaCCodeIdentifier* _tmp85_;
		ValaCCodeIdentifier* _tmp86_;
		ValaCCodeFunctionCall* _tmp87_;
		ValaCCodeFunctionCall* _tmp88_;
		ValaCCodeFunctionCall* _tmp89_;
		ValaCCodeIdentifier* _tmp90_;
		ValaCCodeIdentifier* _tmp91_;
		ValaCCodeFunctionCall* _tmp92_;
		const gchar* _tmp93_;
		gchar* _tmp94_;
		gchar* _tmp95_;
		ValaCCodeConstant* _tmp96_;
		ValaCCodeConstant* _tmp97_;
		ValaCCodeFunctionCall* _tmp98_;
		gchar* _tmp99_;
		gchar* _tmp100_;
		gchar* _tmp101_;
		gchar* _tmp102_;
		ValaCCodeIdentifier* _tmp103_;
		ValaCCodeIdentifier* _tmp104_;
		ValaCCodeFunction* _tmp105_;
		ValaCCodeFunction* _tmp106_;
		ValaCCodeFunctionCall* _tmp107_;
		_tmp82_ = prop;
		_tmp83_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp84_ = _tmp83_;
		vala_code_node_check ((ValaCodeNode*) _tmp82_, _tmp84_);
		_tmp85_ = vala_ccode_identifier_new ("gtk_widget_class_bind_template_callback_full");
		_tmp86_ = _tmp85_;
		_tmp87_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp86_);
		_tmp88_ = _tmp87_;
		_vala_ccode_node_unref0 (_tmp86_);
		call = _tmp88_;
		_tmp89_ = call;
		_tmp90_ = vala_ccode_identifier_new ("GTK_WIDGET_CLASS (klass)");
		_tmp91_ = _tmp90_;
		vala_ccode_function_call_add_argument (_tmp89_, (ValaCCodeExpression*) _tmp91_);
		_vala_ccode_node_unref0 (_tmp91_);
		_tmp92_ = call;
		_tmp93_ = handler_name;
		_tmp94_ = g_strdup_printf ("\"%s\"", _tmp93_);
		_tmp95_ = _tmp94_;
		_tmp96_ = vala_ccode_constant_new (_tmp95_);
		_tmp97_ = _tmp96_;
		vala_ccode_function_call_add_argument (_tmp92_, (ValaCCodeExpression*) _tmp97_);
		_vala_ccode_node_unref0 (_tmp97_);
		_g_free0 (_tmp95_);
		_tmp98_ = call;
		_tmp99_ = vala_get_ccode_name ((ValaCodeNode*) m);
		_tmp100_ = _tmp99_;
		_tmp101_ = g_strdup_printf ("G_CALLBACK(%s)", _tmp100_);
		_tmp102_ = _tmp101_;
		_tmp103_ = vala_ccode_identifier_new (_tmp102_);
		_tmp104_ = _tmp103_;
		vala_ccode_function_call_add_argument (_tmp98_, (ValaCCodeExpression*) _tmp104_);
		_vala_ccode_node_unref0 (_tmp104_);
		_g_free0 (_tmp102_);
		_g_free0 (_tmp100_);
		_tmp105_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp106_ = _tmp105_;
		_tmp107_ = call;
		vala_ccode_function_add_expression (_tmp106_, (ValaCCodeExpression*) _tmp107_);
		_vala_ccode_node_unref0 (call);
	}
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	_vala_code_node_unref0 (prop);
	_vala_code_node_unref0 (sig);
	_g_free0 (handler_name);
	_vala_code_node_unref0 (cl);
}

static void
vala_gtk_module_real_end_instance_init (ValaGTypeModule* base,
                                        ValaClass* cl)
{
	ValaGtkModule * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaCCodeFunctionCall* call = NULL;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeIdentifier* _tmp26_;
	ValaCCodeFunctionCall* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	ValaCCodeFunctionCall* _tmp29_;
	ValaCCodeIdentifier* _tmp30_;
	ValaCCodeIdentifier* _tmp31_;
	ValaCCodeFunction* _tmp32_;
	ValaCCodeFunction* _tmp33_;
	ValaCCodeFunctionCall* _tmp34_;
	self = (ValaGtkModule*) base;
	g_return_if_fail (cl != NULL);
	if (cl == NULL) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) cl);
		_tmp3_ = _tmp2_;
		_tmp1_ = _tmp3_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !vala_gtk_module_is_gtk_template (self, cl);
	}
	if (_tmp0_) {
		return;
	}
	{
		ValaList* _req_list = NULL;
		ValaList* _tmp4_;
		gint _req_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _req_index = 0;
		_tmp4_ = self->priv->current_required_app_classes;
		_req_list = _tmp4_;
		_tmp5_ = _req_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_req_size = _tmp7_;
		_req_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			ValaClass* req = NULL;
			ValaList* _tmp10_;
			gpointer _tmp11_;
			ValaCCodeFunctionCall* call = NULL;
			ValaCCodeIdentifier* _tmp12_;
			ValaCCodeIdentifier* _tmp13_;
			ValaCCodeFunctionCall* _tmp14_;
			ValaCCodeFunctionCall* _tmp15_;
			ValaCCodeFunctionCall* _tmp16_;
			ValaClass* _tmp17_;
			ValaDataType* _tmp18_;
			ValaDataType* _tmp19_;
			ValaCCodeExpression* _tmp20_;
			ValaCCodeExpression* _tmp21_;
			ValaCCodeFunction* _tmp22_;
			ValaCCodeFunction* _tmp23_;
			ValaCCodeFunctionCall* _tmp24_;
			_req_index = _req_index + 1;
			_tmp8_ = _req_index;
			_tmp9_ = _req_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _req_list;
			_tmp11_ = vala_list_get (_tmp10_, _req_index);
			req = (ValaClass*) _tmp11_;
			_tmp12_ = vala_ccode_identifier_new ("g_type_ensure");
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp13_);
			_tmp15_ = _tmp14_;
			_vala_ccode_node_unref0 (_tmp13_);
			call = _tmp15_;
			_tmp16_ = call;
			_tmp17_ = req;
			_tmp18_ = vala_semantic_analyzer_get_data_type_for_symbol ((ValaSymbol*) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_ccode_base_module_get_type_id_expression ((ValaCCodeBaseModule*) self, _tmp19_, FALSE);
			_tmp21_ = _tmp20_;
			vala_ccode_function_call_add_argument (_tmp16_, _tmp21_);
			_vala_ccode_node_unref0 (_tmp21_);
			_vala_code_node_unref0 (_tmp19_);
			_tmp22_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp23_ = _tmp22_;
			_tmp24_ = call;
			vala_ccode_function_add_expression (_tmp23_, (ValaCCodeExpression*) _tmp24_);
			_vala_ccode_node_unref0 (call);
			_vala_code_node_unref0 (req);
		}
	}
	_tmp25_ = vala_ccode_identifier_new ("gtk_widget_init_template");
	_tmp26_ = _tmp25_;
	_tmp27_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp26_);
	_tmp28_ = _tmp27_;
	_vala_ccode_node_unref0 (_tmp26_);
	call = _tmp28_;
	_tmp29_ = call;
	_tmp30_ = vala_ccode_identifier_new ("GTK_WIDGET (self)");
	_tmp31_ = _tmp30_;
	vala_ccode_function_call_add_argument (_tmp29_, (ValaCCodeExpression*) _tmp31_);
	_vala_ccode_node_unref0 (_tmp31_);
	_tmp32_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp33_ = _tmp32_;
	_tmp34_ = call;
	vala_ccode_function_add_expression (_tmp33_, (ValaCCodeExpression*) _tmp34_);
	_vala_ccode_node_unref0 (call);
}

ValaGtkModule*
vala_gtk_module_construct (GType object_type)
{
	ValaGtkModule* self = NULL;
	self = (ValaGtkModule*) vala_gsignal_module_construct (object_type);
	return self;
}

ValaGtkModule*
vala_gtk_module_new (void)
{
	return vala_gtk_module_construct (VALA_TYPE_GTK_MODULE);
}

static void
vala_gtk_module_class_init (ValaGtkModuleClass * klass,
                            gpointer klass_data)
{
	vala_gtk_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_gtk_module_finalize;
	g_type_class_adjust_private_offset (klass, &ValaGtkModule_private_offset);
	((ValaGTypeModuleClass *) klass)->generate_class_init = (void (*) (ValaGTypeModule*, ValaClass*)) vala_gtk_module_real_generate_class_init;
	((ValaCodeVisitorClass *) klass)->visit_property = (void (*) (ValaCodeVisitor*, ValaProperty*)) vala_gtk_module_real_visit_property;
	((ValaCodeVisitorClass *) klass)->visit_field = (void (*) (ValaCodeVisitor*, ValaField*)) vala_gtk_module_real_visit_field;
	((ValaCodeVisitorClass *) klass)->visit_method = (void (*) (ValaCodeVisitor*, ValaMethod*)) vala_gtk_module_real_visit_method;
	((ValaGTypeModuleClass *) klass)->end_instance_init = (void (*) (ValaGTypeModule*, ValaClass*)) vala_gtk_module_real_end_instance_init;
}

static void
vala_gtk_module_instance_init (ValaGtkModule * self,
                               gpointer klass)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	GEqualFunc _tmp6_;
	ValaHashMap* _tmp7_;
	GHashFunc _tmp8_;
	GEqualFunc _tmp9_;
	GEqualFunc _tmp10_;
	ValaHashMap* _tmp11_;
	GEqualFunc _tmp12_;
	ValaArrayList* _tmp13_;
	self->priv = vala_gtk_module_get_instance_private (self);
	self->priv->type_id_to_vala_map = NULL;
	self->priv->cclass_to_vala_map = NULL;
	self->priv->gresource_to_file_map = NULL;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, VALA_TYPE_PROPERTY, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_, _tmp1_, _tmp2_);
	self->priv->current_handler_to_property_map = _tmp3_;
	_tmp4_ = g_str_hash;
	_tmp5_ = g_str_equal;
	_tmp6_ = g_direct_equal;
	_tmp7_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, VALA_TYPE_SIGNAL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_, _tmp5_, _tmp6_);
	self->priv->current_handler_to_signal_map = _tmp7_;
	_tmp8_ = g_str_hash;
	_tmp9_ = g_str_equal;
	_tmp10_ = g_direct_equal;
	_tmp11_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, VALA_TYPE_CLASS, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp8_, _tmp9_, _tmp10_);
	self->priv->current_child_to_class_map = _tmp11_;
	_tmp12_ = g_direct_equal;
	_tmp13_ = vala_array_list_new (VALA_TYPE_CLASS, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp12_);
	self->priv->current_required_app_classes = (ValaList*) _tmp13_;
}

static void
vala_gtk_module_finalize (ValaCodeVisitor * obj)
{
	ValaGtkModule * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_GTK_MODULE, ValaGtkModule);
	_vala_map_unref0 (self->priv->type_id_to_vala_map);
	_vala_map_unref0 (self->priv->cclass_to_vala_map);
	_vala_map_unref0 (self->priv->gresource_to_file_map);
	_vala_map_unref0 (self->priv->current_handler_to_property_map);
	_vala_map_unref0 (self->priv->current_handler_to_signal_map);
	_vala_map_unref0 (self->priv->current_child_to_class_map);
	_vala_iterable_unref0 (self->priv->current_required_app_classes);
	VALA_CODE_VISITOR_CLASS (vala_gtk_module_parent_class)->finalize (obj);
}

static GType
vala_gtk_module_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaGtkModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gtk_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGtkModule), 0, (GInstanceInitFunc) vala_gtk_module_instance_init, NULL };
	GType vala_gtk_module_type_id;
	vala_gtk_module_type_id = g_type_register_static (VALA_TYPE_GSIGNAL_MODULE, "ValaGtkModule", &g_define_type_info, 0);
	ValaGtkModule_private_offset = g_type_add_instance_private (vala_gtk_module_type_id, sizeof (ValaGtkModulePrivate));
	return vala_gtk_module_type_id;
}

GType
vala_gtk_module_get_type (void)
{
	static volatile gsize vala_gtk_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gtk_module_type_id__volatile)) {
		GType vala_gtk_module_type_id;
		vala_gtk_module_type_id = vala_gtk_module_get_type_once ();
		g_once_init_leave (&vala_gtk_module_type_id__volatile, vala_gtk_module_type_id);
	}
	return vala_gtk_module_type_id__volatile;
}

