/* gee.vapi generated by valac, do not modify. */

namespace Vala {
	[CCode (cheader_filename = "valagee.h")]
	public class ArrayList<G> : Vala.List<G> {
		public ArrayList (GLib.EqualFunc<G> equal_func = GLib.direct_equal);
		public override bool add (G item);
		public override void clear ();
		public override bool contains (G item);
		public override G @get (int index);
		public override GLib.Type get_element_type ();
		public override int index_of (G item);
		public override void insert (int index, G item);
		public override Vala.Iterator<G> iterator ();
		public override bool remove (G item);
		public override G remove_at (int index);
		public override void @set (int index, G item);
		public GLib.EqualFunc<G> equal_func { set; }
		public override int size { get; }
	}
	[CCode (cheader_filename = "valagee.h")]
	public abstract class Collection<G> : Vala.Iterable<G> {
		protected Collection ();
		public abstract bool add (G item);
		public virtual bool add_all (Vala.Collection<G> collection);
		public abstract void clear ();
		public abstract bool contains (G item);
		public abstract bool remove (G item);
		public virtual G[] to_array ();
		public virtual bool is_empty { get; }
		public abstract int size { get; }
	}
	[CCode (cheader_filename = "valagee.h")]
	public class HashMap<K,V> : Vala.Map<K,V> {
		public HashMap (GLib.HashFunc<K> key_hash_func = GLib.direct_hash, GLib.EqualFunc<K> key_equal_func = GLib.direct_equal, GLib.EqualFunc<V> value_equal_func = GLib.direct_equal);
		public override void clear ();
		public override bool contains (K key);
		public override V @get (K key);
		public override Vala.Set<K> get_keys ();
		public override Vala.Collection<V> get_values ();
		public override Vala.MapIterator<K,V> map_iterator ();
		public override bool remove (K key);
		public override void @set (K key, V value);
		public GLib.EqualFunc<K> key_equal_func { set; }
		public GLib.HashFunc<K> key_hash_func { set; }
		public override int size { get; }
		public GLib.EqualFunc<V> value_equal_func { set; }
	}
	[CCode (cheader_filename = "valagee.h")]
	public class HashSet<G> : Vala.Set<G> {
		public HashSet (GLib.HashFunc<G> hash_func = GLib.direct_hash, GLib.EqualFunc<G> equal_func = GLib.direct_equal);
		public override bool add (G key);
		public override void clear ();
		public override bool contains (G key);
		public override GLib.Type get_element_type ();
		public override Vala.Iterator<G> iterator ();
		public override bool remove (G key);
		public GLib.EqualFunc<G> equal_func { set; }
		public GLib.HashFunc<G> hash_func { set; }
		public override int size { get; }
	}
	[CCode (cheader_filename = "valagee.h")]
	public abstract class Iterable<G> {
		protected Iterable ();
		public abstract GLib.Type get_element_type ();
		public abstract Vala.Iterator<G> iterator ();
	}
	[CCode (cheader_filename = "valagee.h")]
	public abstract class Iterator<G> {
		protected Iterator ();
		public abstract G @get ();
		public abstract bool has_next ();
		public abstract bool next ();
		public abstract void remove ();
		public abstract bool valid { get; }
	}
	[CCode (cheader_filename = "valagee.h")]
	public abstract class List<G> : Vala.Collection<G> {
		protected List ();
		public virtual G first ();
		public abstract G @get (int index);
		public abstract int index_of (G item);
		public abstract void insert (int index, G item);
		public virtual void insert_all (int index, Vala.Collection<G> collection);
		public virtual G last ();
		public abstract G remove_at (int index);
		public abstract void @set (int index, G item);
		public virtual void sort (owned GLib.CompareDataFunc<G> compare_func);
	}
	[CCode (cheader_filename = "valagee.h")]
	public abstract class Map<K,V> {
		protected Map ();
		public abstract void clear ();
		public abstract bool contains (K key);
		public abstract V @get (K key);
		public abstract Vala.Set<K> get_keys ();
		public abstract Vala.Collection<V> get_values ();
		public abstract Vala.MapIterator<K,V> map_iterator ();
		public abstract bool remove (K key);
		public abstract void @set (K key, V value);
		public abstract int size { get; }
	}
	[CCode (cheader_filename = "valagee.h")]
	public abstract class MapIterator<K,V> {
		protected MapIterator ();
		public abstract K get_key ();
		public abstract V get_value ();
		public abstract bool next ();
	}
	[CCode (cheader_filename = "valagee.h")]
	public abstract class Set<G> : Vala.Collection<G> {
		protected Set ();
	}
}
/* vala.vapi generated by valac, do not modify. */

namespace Vala {
	namespace Genie {
		[CCode (cheader_filename = "vala.h")]
		public class Parser : Vala.CodeVisitor {
			public Parser ();
			public void parse (Vala.CodeContext context);
			public void parse_file (Vala.SourceFile source_file);
			public override void visit_source_file (Vala.SourceFile source_file);
		}
		[CCode (cheader_filename = "vala.h")]
		public class Scanner {
			public Scanner (Vala.SourceFile source_file);
			public static Vala.Genie.TokenType get_identifier_or_keyword (char* begin, int len);
			public void parse_file_comments ();
			public Vala.Comment? pop_comment ();
			public Vala.Genie.TokenType read_regex_token (out Vala.SourceLocation token_begin, out Vala.SourceLocation token_end);
			public Vala.Genie.TokenType read_template_token (out Vala.SourceLocation token_begin, out Vala.SourceLocation token_end);
			public Vala.Genie.TokenType read_token (out Vala.SourceLocation token_begin, out Vala.SourceLocation token_end);
			public void seek (Vala.SourceLocation location);
			public int indent_spaces { get; set; }
			public Vala.SourceFile source_file { get; private set; }
		}
		[CCode (cheader_filename = "vala.h")]
		public enum TokenType {
			NONE,
			ABSTRACT,
			ARRAY,
			AS,
			ASSERT,
			ASSIGN,
			ASSIGN_ADD,
			ASSIGN_BITWISE_AND,
			ASSIGN_BITWISE_OR,
			ASSIGN_BITWISE_XOR,
			ASSIGN_DIV,
			ASSIGN_MUL,
			ASSIGN_PERCENT,
			ASSIGN_SHIFT_LEFT,
			ASSIGN_SUB,
			ASYNC,
			BITWISE_AND,
			BITWISE_OR,
			BREAK,
			CARRET,
			CASE,
			CHARACTER_LITERAL,
			CLASS,
			CLOSE_BRACE,
			CLOSE_BRACKET,
			CLOSE_PARENS,
			CLOSE_REGEX_LITERAL,
			CLOSE_TEMPLATE,
			COLON,
			COMMA,
			CONST,
			CONSTRUCT,
			CONTINUE,
			DEDENT,
			DEF,
			DEFAULT,
			DELEGATE,
			DELETE,
			DICT,
			DIV,
			DO,
			DOT,
			DOWNTO,
			DYNAMIC,
			ELLIPSIS,
			ELSE,
			ENUM,
			ENSURES,
			ERRORDOMAIN,
			EOF,
			EOL,
			EVENT,
			EXCEPT,
			EXTERN,
			FALSE,
			FINAL,
			FINALLY,
			FOR,
			GET,
			HASH,
			IDENTIFIER,
			IF,
			IMPLEMENTS,
			IN,
			INDENT,
			INIT,
			INLINE,
			INTEGER_LITERAL,
			INTERFACE,
			INTERNAL,
			INTERR,
			IS,
			ISA,
			LAMBDA,
			LIST,
			LOCK,
			MINUS,
			NAMESPACE,
			NEW,
			NULL,
			OF,
			OUT,
			OP_AND,
			OP_DEC,
			OP_EQ,
			OP_GE,
			OP_GT,
			OP_INC,
			OP_LE,
			OP_LT,
			OP_NE,
			OP_NEG,
			OP_OR,
			OP_PTR,
			OP_SHIFT_LEFT,
			OPEN_BRACE,
			OPEN_BRACKET,
			OPEN_PARENS,
			OPEN_REGEX_LITERAL,
			OPEN_TEMPLATE,
			OVERRIDE,
			OWNED,
			PARAMS,
			PASS,
			PERCENT,
			PLUS,
			PRINT,
			PRIVATE,
			PROP,
			PROTECTED,
			PUBLIC,
			RAISE,
			RAISES,
			READONLY,
			REAL_LITERAL,
			REF,
			REGEX_LITERAL,
			REQUIRES,
			RETURN,
			SEALED,
			SELF,
			SEMICOLON,
			SET,
			SIZEOF,
			STAR,
			STATIC,
			STRING_LITERAL,
			STRUCT,
			SUPER,
			TEMPLATE_STRING_LITERAL,
			TILDE,
			TO,
			TRUE,
			TRY,
			TYPEOF,
			UNOWNED,
			USES,
			VAR,
			VERBATIM_STRING_LITERAL,
			VIRTUAL,
			VOID,
			VOLATILE,
			WEAK,
			WHEN,
			WHILE,
			YIELD;
			public unowned string to_string ();
		}
	}
	[CCode (cheader_filename = "vala.h")]
	public class AddressofExpression : Vala.Expression {
		public AddressofExpression (Vala.Expression inner, Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public override bool is_accessible (Vala.Symbol sym);
		public override bool is_pure ();
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public override string to_string ();
		public Vala.Expression inner { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class ArrayCopyMethod : Vala.Method {
		public ArrayCopyMethod (Vala.SourceReference? source_reference = null);
	}
	[CCode (cheader_filename = "vala.h")]
	public class ArrayCreationExpression : Vala.Expression {
		public ArrayCreationExpression (Vala.DataType element_type, int rank, Vala.InitializerList? initializer_list, Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public void append_size (Vala.Expression size);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public unowned Vala.List<Vala.Expression> get_sizes ();
		public override void get_used_variables (Vala.Collection<Vala.Variable> collection);
		public override bool is_accessible (Vala.Symbol sym);
		public override bool is_pure ();
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public override void replace_type (Vala.DataType old_type, Vala.DataType new_type);
		public override string to_string ();
		public Vala.DataType element_type { get; private set; }
		public Vala.InitializerList? initializer_list { get; private set; }
		public Vala.DataType? length_type { get; set; }
		public int rank { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class ArrayLengthField : Vala.Field {
		public ArrayLengthField (Vala.SourceReference? source_reference = null);
	}
	[CCode (cheader_filename = "vala.h")]
	public class ArrayMoveMethod : Vala.Method {
		public ArrayMoveMethod (Vala.SourceReference? source_reference = null);
	}
	[CCode (cheader_filename = "vala.h")]
	public class ArrayResizeMethod : Vala.Method {
		public ArrayResizeMethod (Vala.SourceReference? source_reference = null);
	}
	[CCode (cheader_filename = "vala.h")]
	public class ArrayType : Vala.ReferenceType {
		public ArrayType (Vala.DataType element_type, int rank, Vala.SourceReference? source_reference = null);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override bool compatible (Vala.DataType target_type);
		public override Vala.DataType copy ();
		public override Vala.DataType get_actual_type (Vala.DataType? derived_instance_type, Vala.List<Vala.DataType>? method_type_arguments, Vala.CodeNode? node_reference);
		public override Vala.Symbol? get_member (string member_name);
		public override Vala.DataType? infer_type_argument (Vala.TypeParameter type_param, Vala.DataType value_type);
		public override bool is_accessible (Vala.Symbol sym);
		public override bool is_disposable ();
		public override bool is_reference_type_or_type_parameter ();
		public override void replace_type (Vala.DataType old_type, Vala.DataType new_type);
		public override string to_qualified_string (Vala.Scope? scope);
		public Vala.DataType element_type { get; set; }
		public bool fixed_length { get; set; }
		public bool inline_allocated { get; set; }
		public bool invalid_syntax { get; set; }
		public Vala.Expression? length { get; set; }
		public Vala.DataType? length_type { get; set; }
		public int rank { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class Assignment : Vala.Expression {
		public Assignment (Vala.Expression left, Vala.Expression right, Vala.AssignmentOperator operator = AssignmentOperator.SIMPLE, Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public override void get_defined_variables (Vala.Collection<Vala.Variable> collection);
		public override void get_error_types (Vala.Collection<Vala.DataType> collection, Vala.SourceReference? source_reference = null);
		public override void get_used_variables (Vala.Collection<Vala.Variable> collection);
		public override bool is_accessible (Vala.Symbol sym);
		public override bool is_pure ();
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public override string to_string ();
		public Vala.Expression left { get; private set; }
		public Vala.AssignmentOperator operator { get; private set; }
		public Vala.Expression right { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class Attribute : Vala.CodeNode {
		public Attribute (string name, Vala.SourceReference? source_reference = null);
		public void add_argument (string key, string value);
		public bool get_bool (string name, bool default_value = false);
		public double get_double (string name, double default_value = 0);
		public int get_integer (string name, int default_value = 0);
		public string? get_string (string name, string? default_value = null);
		public bool has_argument (string name);
		public Vala.Map<string,string> args { get; private set; }
		public string name { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class AttributeCache {
		public AttributeCache ();
	}
	[CCode (cheader_filename = "vala.h")]
	public class BaseAccess : Vala.Expression {
		public BaseAccess (Vala.SourceReference? source = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public override bool is_pure ();
		public override string to_string ();
	}
	[CCode (cheader_filename = "vala.h")]
	public class BasicBlock {
		public BasicBlock ();
		public void add_child (Vala.BasicBlock block);
		public void add_dominator_frontier (Vala.BasicBlock block);
		public void add_node (Vala.CodeNode node);
		public void add_phi_function (Vala.PhiFunction phi);
		public void connect (Vala.BasicBlock target);
		public BasicBlock.entry ();
		public BasicBlock.exit ();
		public unowned Vala.List<weak Vala.BasicBlock> get_children ();
		public unowned Vala.Set<weak Vala.BasicBlock> get_dominator_frontier ();
		public unowned Vala.List<Vala.CodeNode> get_nodes ();
		public unowned Vala.Set<Vala.PhiFunction> get_phi_functions ();
		public unowned Vala.List<weak Vala.BasicBlock> get_predecessors ();
		public unowned Vala.List<weak Vala.BasicBlock> get_successors ();
		public weak Vala.BasicBlock parent { get; private set; }
		public int postorder_number { get; set; }
		public bool postorder_visited { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class BinaryExpression : Vala.Expression {
		public BinaryExpression (Vala.BinaryOperator op, Vala.Expression _left, Vala.Expression _right, Vala.SourceReference? source = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public BinaryExpression.chained (Vala.BinaryOperator op, Vala.Expression _left, Vala.Expression _right, Vala.SourceReference? source = null);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public override void get_defined_variables (Vala.Collection<Vala.Variable> collection);
		public override void get_error_types (Vala.Collection<Vala.DataType> collection, Vala.SourceReference? source_reference = null);
		public override void get_used_variables (Vala.Collection<Vala.Variable> collection);
		public override bool is_accessible (Vala.Symbol sym);
		public override bool is_constant ();
		public override bool is_non_null ();
		public override bool is_pure ();
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public override string to_string ();
		public bool is_chained { get; private set; }
		public Vala.Expression left { get; private set; }
		public Vala.BinaryOperator operator { get; private set; }
		public Vala.Expression right { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class Block : Vala.Symbol, Vala.Statement {
		public Block (Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public void add_local_constant (Vala.Constant constant);
		public void add_local_variable (Vala.LocalVariable local);
		public void add_statement (Vala.Statement stmt);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public override void get_error_types (Vala.Collection<Vala.DataType> collection, Vala.SourceReference? source_reference = null);
		public unowned Vala.List<Vala.Constant> get_local_constants ();
		public unowned Vala.List<Vala.LocalVariable> get_local_variables ();
		public Vala.List<Vala.Statement> get_statements ();
		public void insert_before (Vala.Statement stmt, Vala.Statement new_stmt);
		public void insert_statement (int index, Vala.Statement stmt);
		public void remove_local_variable (Vala.LocalVariable local);
		public void replace_statement (Vala.Statement old_stmt, Vala.Statement new_stmt);
		public bool captured { get; set; }
		public bool contains_jump_statement { get; set; }
		public bool unreachable_exit { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class BooleanLiteral : Vala.Literal {
		public BooleanLiteral (bool b, Vala.SourceReference? source = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public override bool is_pure ();
		public override string to_string ();
		public bool value { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class BooleanType : Vala.ValueType {
		public BooleanType (Vala.Struct type_symbol);
		public override Vala.DataType copy ();
	}
	[CCode (cheader_filename = "vala.h")]
	public class BreakStatement : Vala.CodeNode, Vala.Statement {
		public BreakStatement (Vala.SourceReference? source = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void emit (Vala.CodeGenerator codegen);
	}
	[CCode (cheader_filename = "vala.h")]
	public abstract class CallableType : Vala.DataType {
		protected CallableType (Vala.Symbol symbol);
		public override unowned Vala.List<Vala.Parameter>? get_parameters ();
		public override unowned Vala.DataType? get_return_type ();
		public override bool is_invokable ();
		public override string to_prototype_string (string? override_name = null);
		public weak Vala.Callable callable_symbol { get; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class CastExpression : Vala.Expression {
		public CastExpression (Vala.Expression inner, Vala.DataType type_reference, Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public override void get_defined_variables (Vala.Collection<Vala.Variable> collection);
		public override void get_error_types (Vala.Collection<Vala.DataType> collection, Vala.SourceReference? source_reference = null);
		public override void get_used_variables (Vala.Collection<Vala.Variable> collection);
		public override bool is_accessible (Vala.Symbol sym);
		public override bool is_constant ();
		public override bool is_pure ();
		public CastExpression.non_null (Vala.Expression inner, Vala.SourceReference? source_reference = null);
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public override void replace_type (Vala.DataType old_type, Vala.DataType new_type);
		public CastExpression.silent (Vala.Expression inner, Vala.DataType type_reference, Vala.SourceReference? source_reference = null);
		public override string to_string ();
		public Vala.Expression inner { get; private set; }
		public bool is_non_null_cast { get; private set; }
		public bool is_silent_cast { get; private set; }
		public Vala.DataType type_reference { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class CatchClause : Vala.CodeNode {
		public CatchClause (Vala.DataType? error_type, string? variable_name, Vala.Block body, Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public override void get_defined_variables (Vala.Collection<Vala.Variable> collection);
		public override void replace_type (Vala.DataType old_type, Vala.DataType new_type);
		public Vala.Block body { get; private set; }
		public Vala.DataType? error_type { get; private set; }
		public Vala.LocalVariable error_variable { get; private set; }
		public string? variable_name { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class CharacterLiteral : Vala.Literal {
		public CharacterLiteral (string c, Vala.SourceReference? source = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public unichar get_char ();
		public override bool is_pure ();
		public override string to_string ();
		public string value { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class Class : Vala.ObjectTypeSymbol {
		public Class (string name, Vala.SourceReference? source_reference = null, Vala.Comment? comment = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public void add_base_type (Vala.DataType type);
		public override void add_constructor (Vala.Constructor c);
		public override void add_destructor (Vala.Destructor d);
		public override void add_field (Vala.Field f);
		public override void add_method (Vala.Method m);
		public override void add_property (Vala.Property prop);
		public override bool check (Vala.CodeContext context);
		public unowned Vala.List<Vala.DataType> get_base_types ();
		public Vala.HashMap<Vala.Method,Vala.Method> get_implicit_implementations ();
		public bool implements (Vala.Interface i);
		public bool is_a (Vala.ObjectTypeSymbol t);
		public bool is_fundamental ();
		public override bool is_reference_type ();
		public override bool is_subtype_of (Vala.TypeSymbol t);
		public override void replace_type (Vala.DataType old_type, Vala.DataType new_type);
		public Vala.Class base_class { get; set; }
		public Vala.Constructor? class_constructor { get; private set; }
		public Vala.Destructor? class_destructor { get; private set; }
		public Vala.Constructor? constructor { get; private set; }
		public Vala.CreationMethod? default_construction_method { get; private set; }
		public Vala.Destructor? destructor { get; private set; }
		public bool has_class_private_fields { get; private set; }
		public bool has_private_fields { get; set; }
		public bool is_abstract { get; set; }
		public bool is_compact { get; }
		public bool is_error_base { get; }
		public bool is_immutable { get; }
		public bool is_opaque { get; }
		public bool is_sealed { get; set; }
		public bool is_singleton { get; }
		public Vala.Constructor? static_constructor { get; private set; }
		public Vala.Destructor? static_destructor { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class ClassType : Vala.ReferenceType {
		public ClassType (Vala.Class class_symbol);
		public override Vala.DataType copy ();
		public weak Vala.Class class_symbol { get; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class CodeContext {
		public CodeContext ();
		public void accept (Vala.CodeVisitor visitor);
		public void add_c_source_file (string file);
		public void add_define (string define);
		public bool add_external_package (string pkg);
		public void add_package (string pkg);
		public bool add_packages_from_file (string filename);
		public void add_source_file (Vala.SourceFile file);
		public bool add_source_filename (string filename, bool is_source = false, bool cmdline = false);
		public void check ();
		public static Vala.CodeContext @get ();
		public unowned Vala.List<string> get_c_source_files ();
		public string? get_gir_path (string gir);
		public string? get_gresource_path (string gresource, string resource);
		public string? get_metadata_path (string gir_filename);
		public unowned Vala.List<string> get_packages ();
		public unowned Vala.SourceFile? get_source_file (string filename);
		public unowned Vala.List<Vala.SourceFile> get_source_files ();
		public string? get_vapi_path (string pkg);
		public bool has_package (string pkg);
		public bool is_defined (string define);
		public string? pkg_config_compile_flags (string package_name);
		public bool pkg_config_exists (string package_name);
		public string? pkg_config_modversion (string package_name);
		public static void pop ();
		public static void push (Vala.CodeContext context);
		public static string realpath (string name);
		public bool require_glib_version (int major, int minor);
		public void set_target_glib_version (string target_glib);
		public void set_target_profile (Vala.Profile profile, bool include_stdpkg = true);
		public void write_dependencies (string filename);
		public void write_external_dependencies (string filename);
		public bool abi_stability { get; set; }
		public Vala.SemanticAnalyzer analyzer { get; private set; }
		public bool assert { get; set; }
		public string basedir { get; set; }
		public bool ccode_only { get; set; }
		public bool checking { get; set; }
		public Vala.CodeGenerator codegen { get; set; }
		public bool compile_only { get; set; }
		public bool debug { get; set; }
		public bool deprecated { get; set; }
		public string directory { get; set; }
		public Vala.Method? entry_point { get; set; }
		public string entry_point_name { get; set; }
		public bool experimental { get; set; }
		public bool experimental_non_null { get; set; }
		public Vala.FlowAnalyzer flow_analyzer { get; private set; }
		public string[] gir_directories { get; set; }
		public bool gobject_tracing { get; set; }
		public string[] gresources { get; set; }
		public string[] gresources_directories { get; set; }
		public string? header_filename { get; set; }
		public bool hide_internal { get; set; }
		public string? includedir { get; set; }
		public string? internal_header_filename { get; set; }
		public bool keep_going { get; set; }
		public bool mem_profiler { get; set; }
		public string[] metadata_directories { get; set; }
		public Vala.Method module_init_method { get; set; }
		public int optlevel { get; set; }
		public string output { get; set; }
		public string pkg_config_command { get; set; }
		public Vala.Profile profile { get; private set; }
		public Vala.Report report { get; set; }
		public Vala.SymbolResolver resolver { get; private set; }
		public Vala.Namespace root { get; }
		public bool run_output { get; set; }
		public bool save_csources { get; }
		public bool save_temps { get; set; }
		public bool since_check { get; set; }
		public string? symbols_filename { get; set; }
		public bool use_fast_vapi { get; set; }
		public Vala.UsedAttr used_attr { get; set; }
		public bool vapi_comments { get; set; }
		public string[] vapi_directories { get; set; }
		public bool verbose_mode { get; set; }
		public bool version_header { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public abstract class CodeGenerator : Vala.CodeVisitor {
		protected CodeGenerator ();
		public virtual void emit (Vala.CodeContext context);
		public abstract Vala.TargetValue load_field (Vala.Field field, Vala.TargetValue? instance, Vala.Expression? expr = null);
		public abstract Vala.TargetValue load_local (Vala.LocalVariable local, Vala.Expression? expr = null);
		public abstract Vala.TargetValue load_parameter (Vala.Parameter param, Vala.Expression? expr = null);
		public abstract void store_field (Vala.Field field, Vala.TargetValue? instance, Vala.TargetValue value, Vala.SourceReference? source_reference = null);
		public abstract void store_local (Vala.LocalVariable local, Vala.TargetValue value, bool initializer, Vala.SourceReference? source_reference = null);
		public abstract void store_parameter (Vala.Parameter param, Vala.TargetValue value, bool capturing_parameter = false, Vala.SourceReference? source_reference = null);
	}
	[CCode (cheader_filename = "vala.h")]
	public abstract class CodeNode {
		public GLib.List<Vala.Attribute> attributes;
		protected CodeNode ();
		public virtual void accept (Vala.CodeVisitor visitor);
		public virtual void accept_children (Vala.CodeVisitor visitor);
		public virtual bool check (Vala.CodeContext context);
		public bool copy_attribute_bool (Vala.CodeNode source, string attribute, string argument);
		public bool copy_attribute_double (Vala.CodeNode source, string attribute, string argument);
		public bool copy_attribute_integer (Vala.CodeNode source, string attribute, string argument);
		public bool copy_attribute_string (Vala.CodeNode source, string attribute, string argument);
		public virtual void emit (Vala.CodeGenerator codegen);
		public unowned Vala.Attribute? get_attribute (string name);
		public bool get_attribute_bool (string attribute, string argument, bool default_value = false);
		public unowned Vala.AttributeCache? get_attribute_cache (int index);
		public static int get_attribute_cache_index ();
		public double get_attribute_double (string attribute, string argument, double default_value = 0);
		public int get_attribute_integer (string attribute, string argument, int default_value = 0);
		public string? get_attribute_string (string attribute, string argument, string? default_value = null);
		public virtual void get_defined_variables (Vala.Collection<Vala.Variable> collection);
		public virtual void get_error_types (Vala.Collection<Vala.DataType> collection, Vala.SourceReference? source_reference = null);
		public static string get_temp_name ();
		public virtual void get_used_variables (Vala.Collection<Vala.Variable> collection);
		public bool has_attribute_argument (string attribute, string argument);
		public void remove_attribute_argument (string attribute, string argument);
		public virtual void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public virtual void replace_type (Vala.DataType old_type, Vala.DataType new_type);
		public void set_attribute (string name, bool value, Vala.SourceReference? source_reference = null);
		public void set_attribute_bool (string attribute, string argument, bool value, Vala.SourceReference? source_reference = null);
		public void set_attribute_cache (int index, Vala.AttributeCache cache);
		public void set_attribute_double (string attribute, string argument, double value, Vala.SourceReference? source_reference = null);
		public void set_attribute_integer (string attribute, string argument, int value, Vala.SourceReference? source_reference = null);
		public void set_attribute_string (string attribute, string argument, string? value, Vala.SourceReference? source_reference = null);
		public virtual string to_string ();
		public bool checked { get; set; }
		public bool error { get; set; }
		public weak Vala.CodeNode? parent_node { get; protected set; }
		public Vala.SourceReference? source_reference { get; set; }
		public bool tree_can_fail { get; }
		public string type_name { get; }
		public bool unreachable { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public abstract class CodeVisitor {
		protected CodeVisitor ();
		public virtual void visit_addressof_expression (Vala.AddressofExpression expr);
		public virtual void visit_array_creation_expression (Vala.ArrayCreationExpression expr);
		public virtual void visit_assignment (Vala.Assignment a);
		public virtual void visit_base_access (Vala.BaseAccess expr);
		public virtual void visit_binary_expression (Vala.BinaryExpression expr);
		public virtual void visit_block (Vala.Block b);
		public virtual void visit_boolean_literal (Vala.BooleanLiteral lit);
		public virtual void visit_break_statement (Vala.BreakStatement stmt);
		public virtual void visit_cast_expression (Vala.CastExpression expr);
		public virtual void visit_catch_clause (Vala.CatchClause clause);
		public virtual void visit_character_literal (Vala.CharacterLiteral lit);
		public virtual void visit_class (Vala.Class cl);
		public virtual void visit_conditional_expression (Vala.ConditionalExpression expr);
		public virtual void visit_constant (Vala.Constant c);
		public virtual void visit_constructor (Vala.Constructor c);
		public virtual void visit_continue_statement (Vala.ContinueStatement stmt);
		public virtual void visit_creation_method (Vala.CreationMethod m);
		public virtual void visit_data_type (Vala.DataType type);
		public virtual void visit_declaration_statement (Vala.DeclarationStatement stmt);
		public virtual void visit_delegate (Vala.Delegate d);
		public virtual void visit_delete_statement (Vala.DeleteStatement stmt);
		public virtual void visit_destructor (Vala.Destructor d);
		public virtual void visit_do_statement (Vala.DoStatement stmt);
		public virtual void visit_element_access (Vala.ElementAccess expr);
		public virtual void visit_empty_statement (Vala.EmptyStatement stmt);
		public virtual void visit_end_full_expression (Vala.Expression expr);
		public virtual void visit_enum (Vala.Enum en);
		public virtual void visit_enum_value (Vala.EnumValue ev);
		public virtual void visit_error_code (Vala.ErrorCode ecode);
		public virtual void visit_error_domain (Vala.ErrorDomain edomain);
		public virtual void visit_expression (Vala.Expression expr);
		public virtual void visit_expression_statement (Vala.ExpressionStatement stmt);
		public virtual void visit_field (Vala.Field f);
		public virtual void visit_for_statement (Vala.ForStatement stmt);
		public virtual void visit_foreach_statement (Vala.ForeachStatement stmt);
		public virtual void visit_formal_parameter (Vala.Parameter p);
		public virtual void visit_if_statement (Vala.IfStatement stmt);
		public virtual void visit_initializer_list (Vala.InitializerList list);
		public virtual void visit_integer_literal (Vala.IntegerLiteral lit);
		public virtual void visit_interface (Vala.Interface iface);
		public virtual void visit_lambda_expression (Vala.LambdaExpression expr);
		public virtual void visit_local_variable (Vala.LocalVariable local);
		public virtual void visit_lock_statement (Vala.LockStatement stmt);
		public virtual void visit_loop_statement (Vala.LoopStatement stmt);
		public virtual void visit_member_access (Vala.MemberAccess expr);
		public virtual void visit_method (Vala.Method m);
		public virtual void visit_method_call (Vala.MethodCall expr);
		public virtual void visit_named_argument (Vala.NamedArgument expr);
		public virtual void visit_namespace (Vala.Namespace ns);
		public virtual void visit_null_literal (Vala.NullLiteral lit);
		public virtual void visit_object_creation_expression (Vala.ObjectCreationExpression expr);
		public virtual void visit_pointer_indirection (Vala.PointerIndirection expr);
		public virtual void visit_postfix_expression (Vala.PostfixExpression expr);
		public virtual void visit_property (Vala.Property prop);
		public virtual void visit_property_accessor (Vala.PropertyAccessor acc);
		public virtual void visit_real_literal (Vala.RealLiteral lit);
		public virtual void visit_reference_transfer_expression (Vala.ReferenceTransferExpression expr);
		public virtual void visit_regex_literal (Vala.RegexLiteral lit);
		public virtual void visit_return_statement (Vala.ReturnStatement stmt);
		public virtual void visit_signal (Vala.Signal sig);
		public virtual void visit_sizeof_expression (Vala.SizeofExpression expr);
		public virtual void visit_slice_expression (Vala.SliceExpression expr);
		public virtual void visit_source_file (Vala.SourceFile source_file);
		public virtual void visit_string_literal (Vala.StringLiteral lit);
		public virtual void visit_struct (Vala.Struct st);
		public virtual void visit_switch_label (Vala.SwitchLabel label);
		public virtual void visit_switch_section (Vala.SwitchSection section);
		public virtual void visit_switch_statement (Vala.SwitchStatement stmt);
		public virtual void visit_template (Vala.Template tmpl);
		public virtual void visit_throw_statement (Vala.ThrowStatement stmt);
		public virtual void visit_try_statement (Vala.TryStatement stmt);
		public virtual void visit_tuple (Vala.Tuple tuple);
		public virtual void visit_type_check (Vala.TypeCheck expr);
		public virtual void visit_type_parameter (Vala.TypeParameter p);
		public virtual void visit_typeof_expression (Vala.TypeofExpression expr);
		public virtual void visit_unary_expression (Vala.UnaryExpression expr);
		public virtual void visit_unlock_statement (Vala.UnlockStatement stmt);
		public virtual void visit_using_directive (Vala.UsingDirective ns);
		public virtual void visit_while_statement (Vala.WhileStatement stmt);
		public virtual void visit_with_statement (Vala.WithStatement stmt);
		public virtual void visit_yield_statement (Vala.YieldStatement y);
	}
	[CCode (cheader_filename = "vala.h")]
	public class CodeWriter : Vala.CodeVisitor {
		public CodeWriter (Vala.CodeWriterType type = CodeWriterType.EXTERNAL);
		public void set_cheader_override (string original, string replacement);
		public override void visit_addressof_expression (Vala.AddressofExpression expr);
		public override void visit_array_creation_expression (Vala.ArrayCreationExpression expr);
		public override void visit_assignment (Vala.Assignment a);
		public override void visit_base_access (Vala.BaseAccess expr);
		public override void visit_binary_expression (Vala.BinaryExpression expr);
		public override void visit_block (Vala.Block b);
		public override void visit_boolean_literal (Vala.BooleanLiteral lit);
		public override void visit_break_statement (Vala.BreakStatement stmt);
		public override void visit_cast_expression (Vala.CastExpression expr);
		public override void visit_catch_clause (Vala.CatchClause clause);
		public override void visit_character_literal (Vala.CharacterLiteral lit);
		public override void visit_class (Vala.Class cl);
		public override void visit_conditional_expression (Vala.ConditionalExpression expr);
		public override void visit_constant (Vala.Constant c);
		public override void visit_constructor (Vala.Constructor c);
		public override void visit_continue_statement (Vala.ContinueStatement stmt);
		public override void visit_creation_method (Vala.CreationMethod m);
		public override void visit_declaration_statement (Vala.DeclarationStatement stmt);
		public override void visit_delegate (Vala.Delegate cb);
		public override void visit_delete_statement (Vala.DeleteStatement stmt);
		public override void visit_destructor (Vala.Destructor d);
		public override void visit_do_statement (Vala.DoStatement stmt);
		public override void visit_element_access (Vala.ElementAccess expr);
		public override void visit_empty_statement (Vala.EmptyStatement stmt);
		public override void visit_enum (Vala.Enum en);
		public override void visit_error_domain (Vala.ErrorDomain edomain);
		public override void visit_expression_statement (Vala.ExpressionStatement stmt);
		public override void visit_field (Vala.Field f);
		public override void visit_for_statement (Vala.ForStatement stmt);
		public override void visit_foreach_statement (Vala.ForeachStatement stmt);
		public override void visit_if_statement (Vala.IfStatement stmt);
		public override void visit_initializer_list (Vala.InitializerList list);
		public override void visit_integer_literal (Vala.IntegerLiteral lit);
		public override void visit_interface (Vala.Interface iface);
		public override void visit_lambda_expression (Vala.LambdaExpression expr);
		public override void visit_local_variable (Vala.LocalVariable local);
		public override void visit_lock_statement (Vala.LockStatement stmt);
		public override void visit_loop_statement (Vala.LoopStatement stmt);
		public override void visit_member_access (Vala.MemberAccess expr);
		public override void visit_method (Vala.Method m);
		public override void visit_method_call (Vala.MethodCall expr);
		public override void visit_namespace (Vala.Namespace ns);
		public override void visit_null_literal (Vala.NullLiteral lit);
		public override void visit_object_creation_expression (Vala.ObjectCreationExpression expr);
		public override void visit_pointer_indirection (Vala.PointerIndirection expr);
		public override void visit_postfix_expression (Vala.PostfixExpression expr);
		public override void visit_property (Vala.Property prop);
		public override void visit_real_literal (Vala.RealLiteral lit);
		public override void visit_reference_transfer_expression (Vala.ReferenceTransferExpression expr);
		public override void visit_return_statement (Vala.ReturnStatement stmt);
		public override void visit_signal (Vala.Signal sig);
		public override void visit_sizeof_expression (Vala.SizeofExpression expr);
		public override void visit_slice_expression (Vala.SliceExpression expr);
		public override void visit_string_literal (Vala.StringLiteral lit);
		public override void visit_struct (Vala.Struct st);
		public override void visit_switch_label (Vala.SwitchLabel label);
		public override void visit_switch_section (Vala.SwitchSection section);
		public override void visit_switch_statement (Vala.SwitchStatement stmt);
		public override void visit_throw_statement (Vala.ThrowStatement stmt);
		public override void visit_try_statement (Vala.TryStatement stmt);
		public override void visit_type_check (Vala.TypeCheck expr);
		public override void visit_typeof_expression (Vala.TypeofExpression expr);
		public override void visit_unary_expression (Vala.UnaryExpression expr);
		public override void visit_unlock_statement (Vala.UnlockStatement stmt);
		public override void visit_using_directive (Vala.UsingDirective ns);
		public override void visit_while_statement (Vala.WhileStatement stmt);
		public override void visit_with_statement (Vala.WithStatement stmt);
		public override void visit_yield_statement (Vala.YieldStatement y);
		public void write_file (Vala.CodeContext context, string filename);
	}
	[CCode (cheader_filename = "vala.h")]
	public class Comment {
		public Comment (string comment, Vala.SourceReference _source_reference);
		public string content { get; private set; }
		public Vala.SourceReference source_reference { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class ConditionalExpression : Vala.Expression {
		public ConditionalExpression (Vala.Expression cond, Vala.Expression true_expr, Vala.Expression false_expr, Vala.SourceReference? source = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void get_defined_variables (Vala.Collection<Vala.Variable> collection);
		public override void get_error_types (Vala.Collection<Vala.DataType> collection, Vala.SourceReference? source_reference = null);
		public override void get_used_variables (Vala.Collection<Vala.Variable> collection);
		public override bool is_accessible (Vala.Symbol sym);
		public override bool is_pure ();
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public override string to_string ();
		public Vala.Expression condition { get; private set; }
		public Vala.Expression false_expression { get; private set; }
		public Vala.Expression true_expression { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class Constant : Vala.Symbol {
		public Constant (string name, Vala.DataType? type_reference, Vala.Expression? value, Vala.SourceReference? source_reference = null, Vala.Comment? comment = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public override void replace_type (Vala.DataType old_type, Vala.DataType new_type);
		public Vala.DataType type_reference { get; set; }
		public Vala.Expression? value { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class Constructor : Vala.Subroutine {
		public Constructor (Vala.SourceReference? source = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public Vala.MemberBinding binding { get; set; }
		public override bool has_result { get; }
		public Vala.Parameter this_parameter { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class ContinueStatement : Vala.CodeNode, Vala.Statement {
		public ContinueStatement (Vala.SourceReference? source = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void emit (Vala.CodeGenerator codegen);
	}
	[CCode (cheader_filename = "vala.h")]
	public class CreationMethod : Vala.Method {
		public CreationMethod (string? class_name, string? name, Vala.SourceReference? source_reference = null, Vala.Comment? comment = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public bool chain_up { get; set; }
		public string class_name { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public abstract class DataType : Vala.CodeNode {
		protected DataType ();
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public void add_type_argument (Vala.DataType arg);
		public bool check_type_arguments (Vala.CodeContext context, bool allow_none = false);
		public virtual bool compatible (Vala.DataType target_type);
		public abstract Vala.DataType copy ();
		public virtual bool equals (Vala.DataType type2);
		public virtual Vala.DataType get_actual_type (Vala.DataType? derived_instance_type, Vala.List<Vala.DataType>? method_type_arguments, Vala.CodeNode? node_reference);
		public virtual Vala.Symbol? get_member (string member_name);
		public virtual unowned Vala.List<Vala.Parameter>? get_parameters ();
		public virtual Vala.Symbol? get_pointer_member (string member_name);
		public virtual unowned Vala.DataType? get_return_type ();
		public unowned Vala.List<Vala.DataType> get_type_arguments ();
		public string? get_type_signature (Vala.Symbol? symbol = null);
		public bool has_type_arguments ();
		public virtual Vala.DataType? infer_type_argument (Vala.TypeParameter type_param, Vala.DataType value_type);
		public virtual bool is_accessible (Vala.Symbol sym);
		public virtual bool is_disposable ();
		public bool is_generic ();
		public virtual bool is_invokable ();
		public bool is_non_null_simple_type ();
		public bool is_real_non_null_struct_type ();
		public virtual bool is_real_struct_type ();
		public virtual bool is_reference_type_or_type_parameter ();
		public bool is_weak ();
		public void remove_all_type_arguments ();
		public override void replace_type (Vala.DataType old_type, Vala.DataType new_type);
		public void replace_type_parameter (Vala.TypeParameter old_type_param, Vala.TypeParameter new_type_param);
		public virtual bool stricter (Vala.DataType type2);
		public virtual string to_prototype_string (string? override_name = null);
		public virtual string to_qualified_string (Vala.Scope? scope = null);
		public override string to_string ();
		protected DataType.with_symbol (Vala.Symbol? symbol);
		public weak Vala.Symbol? context_symbol { get; set; }
		public bool floating_reference { get; set; }
		public bool is_dynamic { get; set; }
		public bool nullable { get; set; }
		public weak Vala.Symbol? symbol { get; private set; }
		public weak Vala.TypeSymbol? type_symbol { get; }
		public bool value_owned { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class DeclarationStatement : Vala.CodeNode, Vala.Statement {
		public DeclarationStatement (Vala.Symbol declaration, Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public override void get_defined_variables (Vala.Collection<Vala.Variable> collection);
		public override void get_error_types (Vala.Collection<Vala.DataType> collection, Vala.SourceReference? source_reference = null);
		public override void get_used_variables (Vala.Collection<Vala.Variable> collection);
		public Vala.Symbol declaration { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class Delegate : Vala.TypeSymbol, Vala.Callable {
		public Delegate (string? name, Vala.DataType return_type, Vala.SourceReference? source_reference = null, Vala.Comment? comment = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public void add_error_type (Vala.DataType error_type);
		public void add_type_parameter (Vala.TypeParameter p);
		public override bool check (Vala.CodeContext context);
		public override void get_error_types (Vala.Collection<Vala.DataType> collection, Vala.SourceReference? source_reference = null);
		public override int get_type_parameter_index (string name);
		public unowned Vala.List<Vala.TypeParameter> get_type_parameters ();
		public bool has_type_parameters ();
		public override bool is_reference_type ();
		public bool matches_method (Vala.Method m, Vala.DataType dt);
		public override void replace_type (Vala.DataType old_type, Vala.DataType new_type);
		public bool has_target { get; set; }
		public Vala.DataType? sender_type { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class DelegateDestroyField : Vala.Field {
		public DelegateDestroyField (Vala.SourceReference? source_reference = null);
	}
	[CCode (cheader_filename = "vala.h")]
	public class DelegateTargetField : Vala.Field {
		public DelegateTargetField (Vala.SourceReference? source_reference = null);
	}
	[CCode (cheader_filename = "vala.h")]
	public class DelegateType : Vala.CallableType {
		public DelegateType (Vala.Delegate delegate_symbol);
		public override bool check (Vala.CodeContext context);
		public override bool compatible (Vala.DataType target_type);
		public override Vala.DataType copy ();
		public override bool equals (Vala.DataType type2);
		public override Vala.Symbol? get_member (string member_name);
		public override bool is_accessible (Vala.Symbol sym);
		public override bool is_disposable ();
		public weak Vala.Delegate delegate_symbol { get; }
		public bool is_called_once { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class DeleteStatement : Vala.CodeNode, Vala.Statement {
		public DeleteStatement (Vala.Expression expression, Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public Vala.Expression expression { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class Destructor : Vala.Subroutine {
		public Destructor (Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public Vala.MemberBinding binding { get; set; }
		public override bool has_result { get; }
		public Vala.Parameter this_parameter { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class DoStatement : Vala.Loop, Vala.Statement {
		public DoStatement (Vala.Expression condition, Vala.Block body, Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
	}
	[CCode (cheader_filename = "vala.h")]
	public class DynamicMethod : Vala.Method {
		public DynamicMethod (Vala.DataType dynamic_type, string name, Vala.DataType return_type, Vala.SourceReference? source_reference = null, Vala.Comment? comment = null);
		public override bool check (Vala.CodeContext context);
		public Vala.DataType dynamic_type { get; set; }
		public Vala.MethodCall invocation { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class DynamicProperty : Vala.Property {
		public DynamicProperty (Vala.DataType dynamic_type, string name, Vala.SourceReference? source_reference = null, Vala.Comment? comment = null);
		public override bool check (Vala.CodeContext context);
		public Vala.DataType dynamic_type { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class DynamicSignal : Vala.Signal {
		public DynamicSignal (Vala.DataType dynamic_type, string name, Vala.DataType return_type, Vala.SourceReference? source_reference = null, Vala.Comment? comment = null);
		public Vala.DataType dynamic_type { get; set; }
		public Vala.Expression handler { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class ElementAccess : Vala.Expression {
		public ElementAccess (Vala.Expression container, Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public void append_index (Vala.Expression index);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public override void get_defined_variables (Vala.Collection<Vala.Variable> collection);
		public override void get_error_types (Vala.Collection<Vala.DataType> collection, Vala.SourceReference? source_reference = null);
		public unowned Vala.List<Vala.Expression> get_indices ();
		public override void get_used_variables (Vala.Collection<Vala.Variable> collection);
		public override bool is_accessible (Vala.Symbol sym);
		public override bool is_pure ();
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public override string to_string ();
		public Vala.Expression container { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class EmptyStatement : Vala.CodeNode, Vala.Statement {
		public EmptyStatement (Vala.SourceReference? source = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void emit (Vala.CodeGenerator codegen);
	}
	[CCode (cheader_filename = "vala.h")]
	public class Enum : Vala.TypeSymbol {
		public Enum (string name, Vala.SourceReference? source_reference = null, Vala.Comment? comment = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override void add_constant (Vala.Constant c);
		public override void add_method (Vala.Method m);
		public void add_value (Vala.EnumValue value);
		public override bool check (Vala.CodeContext context);
		public unowned Vala.List<Vala.Constant> get_constants ();
		public unowned Vala.List<Vala.Method> get_methods ();
		public unowned Vala.List<Vala.EnumValue> get_values ();
		public override bool is_reference_type ();
		public bool is_flags { get; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class EnumValue : Vala.Constant {
		public EnumValue (string name, Vala.Expression? value, Vala.SourceReference? source_reference = null, Vala.Comment? comment = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public string nick { get; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class EnumValueType : Vala.ValueType {
		public EnumValueType (Vala.Enum type_symbol);
		public override Vala.DataType copy ();
		public override Vala.Symbol? get_member (string member_name);
		public unowned Vala.Method get_to_string_method ();
	}
	[CCode (cheader_filename = "vala.h")]
	public class ErrorCode : Vala.TypeSymbol {
		public ErrorCode (string name, Vala.SourceReference? source_reference = null, Vala.Comment? comment = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public ErrorCode.with_value (string name, Vala.Expression value, Vala.SourceReference? source_reference = null);
		public Vala.Constant code { get; private set; }
		public Vala.Expression? value { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class ErrorDomain : Vala.TypeSymbol {
		public ErrorDomain (string name, Vala.SourceReference? source_reference = null, Vala.Comment? comment = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public void add_code (Vala.ErrorCode ecode);
		public override void add_method (Vala.Method m);
		public override bool check (Vala.CodeContext context);
		public unowned Vala.List<Vala.ErrorCode> get_codes ();
		public unowned Vala.List<Vala.Method> get_methods ();
		public override bool is_reference_type ();
	}
	[CCode (cheader_filename = "vala.h")]
	public class ErrorType : Vala.ReferenceType {
		public ErrorType (Vala.ErrorDomain? error_domain, Vala.ErrorCode? error_code, Vala.SourceReference? source_reference = null);
		public override bool check (Vala.CodeContext context);
		public override bool compatible (Vala.DataType target_type);
		public override Vala.DataType copy ();
		public override bool equals (Vala.DataType type2);
		public override Vala.Symbol? get_member (string member_name);
		public override bool is_reference_type_or_type_parameter ();
		public bool dynamic_error { get; set; }
		public weak Vala.ErrorCode? error_code { get; set; }
		public weak Vala.ErrorDomain? error_domain { get; }
	}
	[CCode (cheader_filename = "vala.h")]
	public abstract class Expression : Vala.CodeNode {
		protected Expression ();
		public void insert_statement (Vala.Block block, Vala.Statement stmt);
		public virtual bool is_accessible (Vala.Symbol sym);
		public bool is_always_false ();
		public bool is_always_true ();
		public virtual bool is_constant ();
		public virtual bool is_non_null ();
		public abstract bool is_pure ();
		public Vala.DataType? formal_target_type { get; set; }
		public Vala.DataType? formal_value_type { get; set; }
		public bool lvalue { get; set; }
		public Vala.Statement? parent_statement { get; }
		public weak Vala.Symbol symbol_reference { get; set; }
		public Vala.DataType target_type { get; set; }
		public Vala.TargetValue? target_value { get; set; }
		public Vala.DataType value_type { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class ExpressionStatement : Vala.CodeNode, Vala.Statement {
		public ExpressionStatement (Vala.Expression expression, Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public override void get_defined_variables (Vala.Collection<Vala.Variable> collection);
		public override void get_error_types (Vala.Collection<Vala.DataType> collection, Vala.SourceReference? source_reference = null);
		public override void get_used_variables (Vala.Collection<Vala.Variable> collection);
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public Vala.Expression expression { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class Field : Vala.Variable, Vala.Lockable {
		public Field (string name, Vala.DataType variable_type, Vala.Expression? initializer, Vala.SourceReference? source_reference = null, Vala.Comment? comment = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public override void replace_type (Vala.DataType old_type, Vala.DataType new_type);
		public Vala.MemberBinding binding { get; set; }
		public bool is_volatile { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class FieldPrototype : Vala.DataType {
		public FieldPrototype (Vala.Field field_symbol);
		public override Vala.DataType copy ();
		public override string to_qualified_string (Vala.Scope? scope);
		public weak Vala.Field field_symbol { get; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class FloatingType : Vala.ValueType {
		public FloatingType (Vala.Struct type_symbol);
		public override Vala.DataType copy ();
	}
	[CCode (cheader_filename = "vala.h")]
	public class FlowAnalyzer : Vala.CodeVisitor {
		public FlowAnalyzer ();
		public void analyze (Vala.CodeContext context);
		public override void visit_block (Vala.Block b);
		public override void visit_break_statement (Vala.BreakStatement stmt);
		public override void visit_class (Vala.Class cl);
		public override void visit_continue_statement (Vala.ContinueStatement stmt);
		public override void visit_creation_method (Vala.CreationMethod m);
		public override void visit_declaration_statement (Vala.DeclarationStatement stmt);
		public override void visit_enum (Vala.Enum en);
		public override void visit_error_domain (Vala.ErrorDomain ed);
		public override void visit_expression (Vala.Expression expr);
		public override void visit_expression_statement (Vala.ExpressionStatement stmt);
		public override void visit_field (Vala.Field f);
		public override void visit_foreach_statement (Vala.ForeachStatement stmt);
		public override void visit_if_statement (Vala.IfStatement stmt);
		public override void visit_interface (Vala.Interface iface);
		public override void visit_lambda_expression (Vala.LambdaExpression le);
		public override void visit_local_variable (Vala.LocalVariable local);
		public override void visit_lock_statement (Vala.LockStatement stmt);
		public override void visit_loop_statement (Vala.LoopStatement stmt);
		public override void visit_method (Vala.Method m);
		public override void visit_property (Vala.Property prop);
		public override void visit_property_accessor (Vala.PropertyAccessor acc);
		public override void visit_return_statement (Vala.ReturnStatement stmt);
		public override void visit_signal (Vala.Signal sig);
		public override void visit_source_file (Vala.SourceFile source_file);
		public override void visit_struct (Vala.Struct st);
		public override void visit_switch_statement (Vala.SwitchStatement stmt);
		public override void visit_throw_statement (Vala.ThrowStatement stmt);
		public override void visit_try_statement (Vala.TryStatement stmt);
		public override void visit_unlock_statement (Vala.UnlockStatement stmt);
		public override void visit_with_statement (Vala.WithStatement stmt);
		public override void visit_yield_statement (Vala.YieldStatement stmt);
	}
	[CCode (cheader_filename = "vala.h")]
	public class ForStatement : Vala.Loop, Vala.Statement {
		public ForStatement (Vala.Expression? condition, Vala.Block body, Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public void add_initializer (Vala.Expression init);
		public void add_iterator (Vala.Expression iter);
		public override bool check (Vala.CodeContext context);
		public unowned Vala.List<Vala.Expression> get_initializer ();
		public unowned Vala.List<Vala.Expression> get_iterator ();
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
	}
	[CCode (cheader_filename = "vala.h")]
	public class ForeachStatement : Vala.Block {
		public ForeachStatement (Vala.DataType? type_reference, string variable_name, Vala.Expression collection, Vala.Block body, Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public override void get_defined_variables (Vala.Collection<Vala.Variable> collection);
		public override void get_error_types (Vala.Collection<Vala.DataType> collection, Vala.SourceReference? source_reference = null);
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public override void replace_type (Vala.DataType old_type, Vala.DataType new_type);
		public Vala.Block body { get; private set; }
		public Vala.Expression collection { get; private set; }
		public Vala.LocalVariable collection_variable { get; private set; }
		public Vala.LocalVariable element_variable { get; private set; }
		public Vala.LocalVariable iterator_variable { get; private set; }
		public Vala.DataType? type_reference { get; private set; }
		public bool use_iterator { get; private set; }
		public string variable_name { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class GenericDestroyField : Vala.Field {
		public GenericDestroyField (Vala.SourceReference? source_reference = null);
	}
	[CCode (cheader_filename = "vala.h")]
	public class GenericDupField : Vala.Field {
		public GenericDupField (Vala.SourceReference? source_reference = null);
	}
	[CCode (cheader_filename = "vala.h")]
	public class GenericType : Vala.DataType {
		public GenericType (Vala.TypeParameter type_parameter);
		public override Vala.DataType copy ();
		public override Vala.DataType get_actual_type (Vala.DataType? derived_instance_type, Vala.List<Vala.DataType>? method_type_arguments, Vala.CodeNode? node_reference);
		public override Vala.Symbol? get_member (string member_name);
		public override Vala.DataType? infer_type_argument (Vala.TypeParameter type_param, Vala.DataType value_type);
		public override string to_qualified_string (Vala.Scope? scope = null);
		public weak Vala.TypeParameter type_parameter { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class GirComment : Vala.Comment {
		public GirComment (string? comment, Vala.SourceReference _source_reference);
		public Vala.Comment? get_content_for_parameter (string name);
		public Vala.MapIterator<string,Vala.Comment> parameter_iterator ();
		public Vala.Comment? return_content { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class GirParser : Vala.CodeVisitor {
		public GirParser ();
		public void parse (Vala.CodeContext context);
		public void parse_file (Vala.SourceFile source_file);
		public override void visit_source_file (Vala.SourceFile source_file);
	}
	[CCode (cheader_filename = "vala.h")]
	public class IfStatement : Vala.CodeNode, Vala.Statement {
		public IfStatement (Vala.Expression cond, Vala.Block true_stmt, Vala.Block? false_stmt, Vala.SourceReference? source = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public override void get_error_types (Vala.Collection<Vala.DataType> collection, Vala.SourceReference? source_reference = null);
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public Vala.Expression condition { get; private set; }
		public Vala.Block? false_statement { get; private set; }
		public Vala.Block true_statement { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class InitializerList : Vala.Expression {
		public InitializerList (Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public void append (Vala.Expression expr);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public unowned Vala.List<Vala.Expression> get_initializers ();
		public override void get_used_variables (Vala.Collection<Vala.Variable> collection);
		public override bool is_accessible (Vala.Symbol sym);
		public override bool is_constant ();
		public override bool is_pure ();
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public override string to_string ();
		public int size { get; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class IntegerLiteral : Vala.Literal {
		public IntegerLiteral (string i, Vala.SourceReference? source = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public override bool is_pure ();
		public override string to_string ();
		public string type_suffix { get; private set; }
		public string value { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class IntegerType : Vala.ValueType {
		public IntegerType (Vala.Struct type_symbol, string? literal_value = null, string? literal_type_name = null);
		public override bool compatible (Vala.DataType target_type);
		public override Vala.DataType copy ();
	}
	[CCode (cheader_filename = "vala.h")]
	public class Interface : Vala.ObjectTypeSymbol {
		public Interface (string name, Vala.SourceReference? source_reference = null, Vala.Comment? comment = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override void add_method (Vala.Method m);
		public void add_prerequisite (Vala.DataType type);
		public override void add_property (Vala.Property prop);
		public override bool check (Vala.CodeContext context);
		public unowned Vala.List<Vala.DataType> get_prerequisites ();
		public virtual Vala.List<Vala.Symbol> get_virtuals ();
		public override bool is_reference_type ();
		public override bool is_subtype_of (Vala.TypeSymbol t);
		public override void replace_type (Vala.DataType old_type, Vala.DataType new_type);
	}
	[CCode (cheader_filename = "vala.h")]
	public class InterfaceType : Vala.ReferenceType {
		public InterfaceType (Vala.Interface interface_symbol);
		public override Vala.DataType copy ();
		public weak Vala.Interface interface_symbol { get; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class InvalidExpression : Vala.Expression {
		public InvalidExpression ();
		public override bool check (Vala.CodeContext context);
		public override bool is_pure ();
	}
	[CCode (cheader_filename = "vala.h")]
	public class InvalidType : Vala.DataType {
		public InvalidType ();
		public override Vala.DataType copy ();
	}
	[CCode (cheader_filename = "vala.h")]
	public class LambdaExpression : Vala.Expression {
		public LambdaExpression (Vala.Expression expression_body, Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public void add_parameter (Vala.Parameter param);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public unowned Vala.List<Vala.Parameter> get_parameters ();
		public override void get_used_variables (Vala.Collection<Vala.Variable> collection);
		public override bool is_pure ();
		public LambdaExpression.with_statement_body (Vala.Block statement_body, Vala.SourceReference? source_reference = null);
		public Vala.Expression expression_body { get; private set; }
		public Vala.Method method { get; private set; }
		public Vala.Block statement_body { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public abstract class Literal : Vala.Expression {
		protected Literal ();
		public override bool is_constant ();
		public override bool is_pure ();
	}
	[CCode (cheader_filename = "vala.h")]
	public class LocalVariable : Vala.Variable {
		public LocalVariable (Vala.DataType? variable_type, string name, Vala.Expression? initializer = null, Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public override void replace_type (Vala.DataType old_type, Vala.DataType new_type);
		public bool captured { get; set; }
		public bool init { get; set; }
		public bool is_result { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class LockStatement : Vala.CodeNode, Vala.Statement {
		public LockStatement (Vala.Expression resource, Vala.Block? body, Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public Vala.Block? body { get; private set; }
		public Vala.Expression resource { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public abstract class Loop : Vala.CodeNode {
		protected Loop (Vala.Expression? condition, Vala.Block body, Vala.SourceReference? source_reference = null);
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public Vala.Block body { get; private set; }
		public Vala.Expression? condition { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class LoopStatement : Vala.Loop, Vala.Statement {
		public LoopStatement (Vala.Block body, Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public override void get_error_types (Vala.Collection<Vala.DataType> collection, Vala.SourceReference? source_reference = null);
	}
	[CCode (cheader_filename = "vala.h")]
	public class MarkupReader {
		public MarkupReader (string filename);
		public MarkupReader.from_string (string filename, string content);
		public string? get_attribute (string attr);
		public Vala.Map<string,string> get_attributes ();
		public Vala.MarkupTokenType read_token (out Vala.SourceLocation token_begin, out Vala.SourceLocation token_end);
		public string content { get; private set; }
		public string filename { get; private set; }
		public string name { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class MemberAccess : Vala.Expression {
		public MemberAccess (Vala.Expression? inner, string member_name, Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public void add_type_argument (Vala.DataType arg);
		public override bool check (Vala.CodeContext context);
		public void check_lvalue_access ();
		public override void emit (Vala.CodeGenerator codegen);
		public override void get_defined_variables (Vala.Collection<Vala.Variable> collection);
		public override void get_error_types (Vala.Collection<Vala.DataType> collection, Vala.SourceReference? source_reference = null);
		public unowned Vala.List<Vala.DataType> get_type_arguments ();
		public override void get_used_variables (Vala.Collection<Vala.Variable> collection);
		public override bool is_accessible (Vala.Symbol sym);
		public override bool is_constant ();
		public override bool is_non_null ();
		public override bool is_pure ();
		public MemberAccess.pointer (Vala.Expression inner, string member_name, Vala.SourceReference? source_reference = null);
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public override void replace_type (Vala.DataType old_type, Vala.DataType new_type);
		public MemberAccess.simple (string member_name, Vala.SourceReference? source_reference = null);
		public override string to_string ();
		public bool creation_member { get; set; }
		public Vala.Expression? inner { get; set; }
		public string member_name { get; set; }
		public bool pointer_member_access { get; set; }
		public bool prototype_access { get; set; }
		public bool qualified { get; set; }
		public bool tainted_access { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class MemberInitializer : Vala.Expression {
		public MemberInitializer (string name, Vala.Expression initializer, Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public override void get_used_variables (Vala.Collection<Vala.Variable> collection);
		public override bool is_pure ();
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public Vala.Expression initializer { get; private set; }
		public string name { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class Method : Vala.Subroutine, Vala.Callable {
		protected Vala.List<Vala.DataType> error_types;
		public Method (string? name, Vala.DataType return_type, Vala.SourceReference? source_reference = null, Vala.Comment? comment = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public void add_captured_variable (Vala.LocalVariable local);
		public void add_error_type (Vala.DataType error_type);
		public void add_postcondition (Vala.Expression postcondition);
		public void add_precondition (Vala.Expression precondition);
		public void add_type_parameter (Vala.TypeParameter p);
		public override bool check (Vala.CodeContext context);
		public void clear_parameters ();
		public bool compatible (Vala.Method base_method, out string? invalid_match);
		public bool compatible_no_error (Vala.Method base_method);
		public unowned Vala.List<Vala.Parameter> get_async_begin_parameters ();
		public unowned Vala.List<Vala.Parameter> get_async_end_parameters ();
		public unowned Vala.Method get_callback_method ();
		public void get_captured_variables (Vala.Collection<Vala.LocalVariable> variables);
		public override void get_defined_variables (Vala.Collection<Vala.Variable> collection);
		public unowned Vala.Method get_end_method ();
		public override void get_error_types (Vala.Collection<Vala.DataType> collection, Vala.SourceReference? source_reference = null);
		public int get_format_arg_index ();
		public unowned Vala.List<Vala.Expression> get_postconditions ();
		public unowned Vala.List<Vala.Expression> get_preconditions ();
		public int get_required_arguments ();
		public int get_type_parameter_index (string name);
		public unowned Vala.List<Vala.TypeParameter> get_type_parameters ();
		public bool has_error_type_parameter ();
		public bool has_type_parameters ();
		public bool is_variadic ();
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public override void replace_type (Vala.DataType old_type, Vala.DataType new_type);
		public Vala.Method base_interface_method { get; }
		public Vala.DataType base_interface_type { get; set; }
		public Vala.Method base_method { get; }
		public Vala.MemberBinding binding { get; set; }
		public bool closure { get; set; }
		public bool coroutine { get; set; }
		public bool entry_point { get; private set; }
		public bool has_construct_function { get; set; }
		public override bool has_result { get; }
		public bool is_abstract { get; set; }
		public bool is_async_callback { get; set; }
		public bool is_inline { get; set; }
		public bool is_virtual { get; set; }
		public bool overrides { get; set; }
		public Vala.LocalVariable? params_array_var { get; protected set; }
		public bool printf_format { get; set; }
		public bool returns_floating_reference { get; set; }
		public bool returns_modified_pointer { get; set; }
		public bool scanf_format { get; set; }
		public weak Vala.Signal signal_reference { get; set; }
		public Vala.Parameter this_parameter { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class MethodCall : Vala.Expression, Vala.CallableExpression {
		public MethodCall (Vala.Expression call, Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public override void get_defined_variables (Vala.Collection<Vala.Variable> collection);
		public override void get_error_types (Vala.Collection<Vala.DataType> collection, Vala.SourceReference? source_reference = null);
		public Vala.StringLiteral? get_format_literal ();
		public override void get_used_variables (Vala.Collection<Vala.Variable> collection);
		public override bool is_accessible (Vala.Symbol sym);
		public override bool is_constant ();
		public override bool is_pure ();
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public override string to_string ();
		public Vala.Expression call { get; private set; }
		public bool is_assert { get; private set; }
		public bool is_chainup { get; private set; }
		public bool is_constructv_chainup { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class MethodType : Vala.CallableType {
		public MethodType (Vala.Method method_symbol);
		public override bool compatible (Vala.DataType target_type);
		public override Vala.DataType copy ();
		public override Vala.Symbol? get_member (string member_name);
		public override string to_qualified_string (Vala.Scope? scope);
		public weak Vala.Method method_symbol { get; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class NamedArgument : Vala.Expression {
		public NamedArgument (string name, Vala.Expression inner, Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public override void get_defined_variables (Vala.Collection<Vala.Variable> collection);
		public override void get_used_variables (Vala.Collection<Vala.Variable> collection);
		public override bool is_pure ();
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public Vala.Expression inner { get; private set; }
		public string name { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class Namespace : Vala.Symbol {
		public Namespace (string? name, Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override void add_class (Vala.Class cl);
		public void add_comment (Vala.Comment comment);
		public override void add_constant (Vala.Constant constant);
		public override void add_delegate (Vala.Delegate d);
		public override void add_enum (Vala.Enum en);
		public override void add_error_domain (Vala.ErrorDomain edomain);
		public override void add_field (Vala.Field f);
		public override void add_interface (Vala.Interface iface);
		public override void add_method (Vala.Method m);
		public override void add_namespace (Vala.Namespace ns);
		public override void add_struct (Vala.Struct st);
		public void add_using_directive (Vala.UsingDirective ns);
		public override bool check (Vala.CodeContext context);
		public unowned Vala.List<Vala.Class> get_classes ();
		public unowned Vala.List<Vala.Comment> get_comments ();
		public unowned Vala.List<Vala.Constant> get_constants ();
		public unowned Vala.List<Vala.Delegate> get_delegates ();
		public unowned Vala.List<Vala.Enum> get_enums ();
		public unowned Vala.List<Vala.ErrorDomain> get_error_domains ();
		public unowned Vala.List<Vala.Field> get_fields ();
		public unowned Vala.List<Vala.Interface> get_interfaces ();
		public unowned Vala.List<Vala.Method> get_methods ();
		public unowned Vala.List<Vala.Namespace> get_namespaces ();
		public unowned Vala.List<Vala.Struct> get_structs ();
		public override string to_string ();
	}
	[CCode (cheader_filename = "vala.h")]
	public class NullLiteral : Vala.Literal {
		public NullLiteral (Vala.SourceReference? source = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public override bool is_pure ();
		public override string to_string ();
	}
	[CCode (cheader_filename = "vala.h")]
	public class NullType : Vala.ReferenceType {
		public NullType (Vala.SourceReference? source_reference = null);
		public override bool compatible (Vala.DataType target_type);
		public override Vala.DataType copy ();
		public override bool is_disposable ();
		public override string to_qualified_string (Vala.Scope? scope = null);
	}
	[CCode (cheader_filename = "vala.h")]
	public class ObjectCreationExpression : Vala.Expression, Vala.CallableExpression {
		public ObjectCreationExpression (Vala.MemberAccess? member_name, Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public void add_member_initializer (Vala.MemberInitializer init);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public override void get_defined_variables (Vala.Collection<Vala.Variable> collection);
		public override void get_error_types (Vala.Collection<Vala.DataType> collection, Vala.SourceReference? source_reference = null);
		public unowned Vala.List<Vala.MemberInitializer> get_object_initializer ();
		public override void get_used_variables (Vala.Collection<Vala.Variable> collection);
		public override bool is_accessible (Vala.Symbol sym);
		public override bool is_pure ();
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public override void replace_type (Vala.DataType old_type, Vala.DataType new_type);
		public override string to_string ();
		public Vala.MemberAccess? member_name { get; private set; }
		public bool struct_creation { get; set; }
		public Vala.DataType type_reference { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class ObjectType : Vala.ReferenceType {
		public ObjectType (Vala.ObjectTypeSymbol type_symbol);
		public override bool check (Vala.CodeContext context);
		public override Vala.DataType copy ();
		public override unowned Vala.List<Vala.Parameter>? get_parameters ();
		public override unowned Vala.DataType? get_return_type ();
		public override bool is_invokable ();
		public override bool stricter (Vala.DataType target_type);
		public weak Vala.ObjectTypeSymbol object_type_symbol { get; }
	}
	[CCode (cheader_filename = "vala.h")]
	public abstract class ObjectTypeSymbol : Vala.TypeSymbol {
		protected ObjectTypeSymbol (string name, Vala.SourceReference? source_reference = null, Vala.Comment? comment = null);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override void add_class (Vala.Class cl);
		public override void add_constant (Vala.Constant c);
		public override void add_delegate (Vala.Delegate d);
		public override void add_enum (Vala.Enum en);
		public override void add_field (Vala.Field f);
		public void add_hidden_method (Vala.Method m);
		public override void add_interface (Vala.Interface iface);
		public override void add_method (Vala.Method m);
		public override void add_property (Vala.Property prop);
		public override void add_signal (Vala.Signal sig);
		public override void add_struct (Vala.Struct st);
		public void add_type_parameter (Vala.TypeParameter p);
		public override bool check (Vala.CodeContext context);
		public unowned Vala.List<Vala.Class> get_classes ();
		public unowned Vala.List<Vala.Constant> get_constants ();
		public unowned Vala.List<Vala.Delegate> get_delegates ();
		public unowned Vala.List<Vala.Enum> get_enums ();
		public unowned Vala.List<Vala.Field> get_fields ();
		public unowned Vala.List<Vala.Interface> get_interfaces ();
		public unowned Vala.List<Vala.Symbol> get_members ();
		public unowned Vala.List<Vala.Method> get_methods ();
		public unowned Vala.List<Vala.Property> get_properties ();
		public unowned Vala.List<Vala.Signal> get_signals ();
		public unowned Vala.List<Vala.Struct> get_structs ();
		public override int get_type_parameter_index (string name);
		public unowned Vala.List<Vala.TypeParameter> get_type_parameters ();
		public bool has_type_parameters ();
	}
	[CCode (cheader_filename = "vala.h")]
	public class Parameter : Vala.Variable {
		public Parameter (string name, Vala.DataType? variable_type, Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public Vala.Parameter copy ();
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public override void replace_type (Vala.DataType old_type, Vala.DataType new_type);
		public Parameter.with_ellipsis (Vala.SourceReference? source_reference = null);
		public Vala.Parameter base_parameter { get; set; }
		public bool captured { get; set; }
		public Vala.ParameterDirection direction { get; set; }
		public bool ellipsis { get; set; }
		public bool format_arg { get; }
		public bool params_array { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class Parser : Vala.CodeVisitor {
		public Parser ();
		public void parse (Vala.CodeContext context);
		public void parse_file (Vala.SourceFile source_file);
		public override void visit_source_file (Vala.SourceFile source_file);
	}
	[CCode (cheader_filename = "vala.h")]
	public class PhiFunction {
		public PhiFunction (Vala.Variable variable, int num_of_ops);
		public Vala.List<Vala.Variable?> operands { get; private set; }
		public Vala.Variable original_variable { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class PointerIndirection : Vala.Expression {
		public PointerIndirection (Vala.Expression inner, Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public override void get_defined_variables (Vala.Collection<Vala.Variable> collection);
		public override void get_error_types (Vala.Collection<Vala.DataType> collection, Vala.SourceReference? source_reference = null);
		public override void get_used_variables (Vala.Collection<Vala.Variable> collection);
		public override bool is_accessible (Vala.Symbol sym);
		public override bool is_pure ();
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public override string to_string ();
		public Vala.Expression inner { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class PointerType : Vala.DataType {
		public PointerType (Vala.DataType base_type, Vala.SourceReference? source_reference = null);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override bool compatible (Vala.DataType target_type);
		public override Vala.DataType copy ();
		public override Vala.DataType get_actual_type (Vala.DataType? derived_instance_type, Vala.List<Vala.DataType>? method_type_arguments, Vala.CodeNode? node_reference);
		public override Vala.Symbol? get_member (string member_name);
		public override Vala.Symbol? get_pointer_member (string member_name);
		public override Vala.DataType? infer_type_argument (Vala.TypeParameter type_param, Vala.DataType value_type);
		public override bool is_accessible (Vala.Symbol sym);
		public override bool is_disposable ();
		public override void replace_type (Vala.DataType old_type, Vala.DataType new_type);
		public override bool stricter (Vala.DataType type2);
		public override string to_qualified_string (Vala.Scope? scope);
		public Vala.DataType base_type { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class PostfixExpression : Vala.Expression {
		public PostfixExpression (Vala.Expression _inner, bool inc, Vala.SourceReference? source = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public override void get_defined_variables (Vala.Collection<Vala.Variable> collection);
		public override void get_used_variables (Vala.Collection<Vala.Variable> collection);
		public override bool is_accessible (Vala.Symbol sym);
		public override bool is_pure ();
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public override string to_string ();
		public bool increment { get; private set; }
		public Vala.Expression inner { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class Property : Vala.Symbol, Vala.Lockable {
		public Property (string name, Vala.DataType? property_type, Vala.PropertyAccessor? get_accessor, Vala.PropertyAccessor? set_accessor, Vala.SourceReference? source_reference = null, Vala.Comment? comment = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public bool compatible (Vala.Property base_property, out string? invalid_match);
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public override void replace_type (Vala.DataType old_type, Vala.DataType new_type);
		public Vala.Property base_interface_property { get; }
		public Vala.Property base_property { get; }
		public Vala.MemberBinding binding { get; set; }
		public string blurb { get; }
		public Vala.Field? field { get; }
		public Vala.PropertyAccessor? get_accessor { get; set; }
		public Vala.Expression initializer { get; set; }
		public bool interface_only { get; set; }
		public bool is_abstract { get; set; }
		public bool is_virtual { get; set; }
		public string nick { get; }
		public bool notify { get; }
		public bool overrides { get; set; }
		public Vala.DataType? property_type { get; set; }
		public Vala.PropertyAccessor? set_accessor { get; set; }
		public Vala.Parameter this_parameter { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class PropertyAccessor : Vala.Subroutine {
		public PropertyAccessor (bool readable, bool writable, bool construction, Vala.DataType? value_type, Vala.Block? body, Vala.SourceReference? source_reference = null, Vala.Comment? comment = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public Vala.Method? get_method ();
		public override void replace_type (Vala.DataType old_type, Vala.DataType new_type);
		public bool automatic_body { get; private set; }
		public bool construction { get; private set; }
		public override bool has_result { get; }
		public Vala.Property prop { get; }
		public bool readable { get; private set; }
		public Vala.Parameter value_parameter { get; private set; }
		public Vala.DataType? value_type { get; private set; }
		public bool writable { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class PropertyPrototype : Vala.DataType {
		public PropertyPrototype (Vala.Property property_symbol);
		public override Vala.DataType copy ();
		public override string to_qualified_string (Vala.Scope? scope);
		public weak Vala.Property property_symbol { get; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class RealLiteral : Vala.Literal {
		public RealLiteral (string r, Vala.SourceReference? source = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public string get_type_name ();
		public override bool is_pure ();
		public override string to_string ();
		public string value { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class ReferenceTransferExpression : Vala.Expression {
		public ReferenceTransferExpression (Vala.Expression inner, Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public override void get_defined_variables (Vala.Collection<Vala.Variable> collection);
		public override void get_used_variables (Vala.Collection<Vala.Variable> collection);
		public override bool is_accessible (Vala.Symbol sym);
		public override bool is_pure ();
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public override string to_string ();
		public Vala.Expression inner { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public abstract class ReferenceType : Vala.DataType {
		protected ReferenceType (Vala.Symbol? symbol);
	}
	[CCode (cheader_filename = "vala.h")]
	public class RegexLiteral : Vala.Literal {
		public RegexLiteral (string value, Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public override bool is_non_null ();
		public override bool is_pure ();
		public override string to_string ();
		public string value { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class Report {
		public enum Colored {
			AUTO,
			NEVER,
			ALWAYS
		}
		protected int errors;
		protected int warnings;
		public Report ();
		public virtual void depr (Vala.SourceReference? source, string message);
		[PrintfFormat]
		public static void deprecated (Vala.SourceReference? source, string msg_format, ...);
		public virtual void err (Vala.SourceReference? source, string message);
		[PrintfFormat]
		public static void error (Vala.SourceReference? source, string msg_format, ...);
		[PrintfFormat]
		public static void experimental (Vala.SourceReference? source, string msg_format, ...);
		public int get_errors ();
		public int get_warnings ();
		public virtual void note (Vala.SourceReference? source, string message);
		[PrintfFormat]
		public static void notice (Vala.SourceReference? source, string msg_format, ...);
		public bool set_colors (string str, Vala.Report.Colored colored_output = Report.Colored.AUTO);
		public void set_verbose_errors (bool verbose);
		public virtual void warn (Vala.SourceReference? source, string message);
		[PrintfFormat]
		public static void warning (Vala.SourceReference? source, string msg_format, ...);
		public bool enable_warnings { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class ReturnStatement : Vala.CodeNode, Vala.Statement {
		public ReturnStatement (Vala.Expression? return_expression = null, Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public override void get_defined_variables (Vala.Collection<Vala.Variable> collection);
		public override void get_error_types (Vala.Collection<Vala.DataType> collection, Vala.SourceReference? source_reference = null);
		public override void get_used_variables (Vala.Collection<Vala.Variable> collection);
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public Vala.Expression? return_expression { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class Scanner {
		public Scanner (Vala.SourceFile source_file);
		public static Vala.TokenType get_identifier_or_keyword (char* begin, int len);
		public void parse_file_comments ();
		public Vala.Comment? pop_comment ();
		public Vala.TokenType read_regex_token (out Vala.SourceLocation token_begin, out Vala.SourceLocation token_end);
		public Vala.TokenType read_template_token (out Vala.SourceLocation token_begin, out Vala.SourceLocation token_end);
		public Vala.TokenType read_token (out Vala.SourceLocation token_begin, out Vala.SourceLocation token_end);
		public void seek (Vala.SourceLocation location);
		public Vala.SourceFile source_file { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class Scope {
		public Scope (Vala.Symbol? owner = null);
		public void add (string? name, Vala.Symbol sym);
		public unowned Vala.Map<string,Vala.Symbol> get_symbol_table ();
		public bool is_subscope_of (Vala.Scope? scope);
		public Vala.Symbol? lookup (string name);
		public void remove (string name);
		public weak Vala.Symbol owner { get; set; }
		public weak Vala.Scope parent_scope { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class SemanticAnalyzer : Vala.CodeVisitor {
		public Vala.DataType bool_type;
		public Vala.DataType char_type;
		public Vala.DelegateType delegate_target_destroy_type;
		public Vala.DataType delegate_target_type;
		public Vala.DataType double_type;
		public Vala.DataType garray_type;
		public Vala.DelegateType generics_dup_func_type;
		public Vala.Class gerror_type;
		public Vala.DataType glist_type;
		public Vala.DataType gslist_type;
		public Vala.Class gsource_type;
		public Vala.StructValueType gvalue_type;
		public Vala.DataType gvaluearray_type;
		public Vala.ObjectType gvariant_type;
		public Vala.Block insert_block;
		public Vala.DataType int16_type;
		public Vala.DataType int32_type;
		public Vala.DataType int8_type;
		public Vala.DataType int_type;
		public Vala.DataType list_type;
		public Vala.DataType long_type;
		public Vala.Class object_type;
		public Vala.DataType regex_type;
		public Vala.List<Vala.CodeNode> replaced_nodes;
		public Vala.DataType short_type;
		public Vala.DataType size_t_type;
		public Vala.DataType ssize_t_type;
		public Vala.DataType string_type;
		public Vala.DataType tuple_type;
		public Vala.DataType type_type;
		public Vala.DataType uchar_type;
		public Vala.DataType uint16_type;
		public Vala.DataType uint32_type;
		public Vala.DataType uint8_type;
		public Vala.DataType uint_type;
		public Vala.DataType ulong_type;
		public Vala.DataType unichar_type;
		public Vala.DataType ushort_type;
		public Vala.DataType va_list_type;
		public Vala.DataType void_type;
		public SemanticAnalyzer ();
		public void analyze (Vala.CodeContext context);
		public bool check_arguments (Vala.Expression expr, Vala.DataType mtype, Vala.List<Vala.Parameter> @params, Vala.List<Vala.Expression> args);
		public bool check_print_format (string format, Vala.Iterator<Vala.Expression> arg_it, Vala.SourceReference? source_reference = null);
		public void check_type (Vala.DataType type);
		public void check_type_arguments (Vala.MemberAccess access);
		public bool check_variadic_arguments (Vala.Iterator<Vala.Expression>? arg_it, int i, Vala.SourceReference? source_reference = null);
		public static Vala.Expression create_temp_access (Vala.LocalVariable local, Vala.DataType? target_type);
		public unowned Vala.Method? find_current_method ();
		public static unowned Vala.Method? find_parent_method (Vala.Symbol sym);
		public static unowned Vala.Symbol? find_parent_method_or_property_accessor (Vala.Symbol sym);
		public static unowned Vala.TypeSymbol? find_parent_type_symbol (Vala.Symbol sym);
		public static Vala.DataType get_actual_type (Vala.DataType? derived_instance_type, Vala.List<Vala.DataType>? method_type_arguments, Vala.GenericType generic_type, Vala.CodeNode? node_reference);
		public unowned Vala.DataType? get_arithmetic_result_type (Vala.DataType left_type, Vala.DataType right_type);
		public static Vala.DataType get_data_type_for_symbol (Vala.Symbol sym);
		public static unowned Vala.Symbol? get_symbol_for_data_type (Vala.DataType type);
		public static Vala.DataType? get_this_type (Vala.Symbol s, Vala.TypeSymbol? parent = null);
		public Vala.DataType? get_value_type_for_symbol (Vala.Symbol sym, bool lvalue);
		public bool is_gobject_property (Vala.Property prop);
		public bool is_gobject_property_type (Vala.DataType property_type);
		public bool is_in_constructor ();
		public bool is_in_destructor ();
		public bool is_in_instance_method ();
		public bool is_nullable_value_type_argument (Vala.DataType type_arg);
		public bool is_reference_type_argument (Vala.DataType type_arg);
		public bool is_signed_integer_type_argument (Vala.DataType type_arg);
		public bool is_type_accessible (Vala.Symbol sym, Vala.DataType type);
		public bool is_unsigned_integer_type_argument (Vala.DataType type_arg);
		public static Vala.Symbol? symbol_lookup_inherited (Vala.Symbol sym, string name);
		public override void visit_source_file (Vala.SourceFile file);
		public Vala.Method? current_async_method { get; }
		public Vala.Class? current_class { get; }
		public Vala.Method? current_method { get; }
		public Vala.Symbol? current_method_or_property_accessor { get; }
		public Vala.PropertyAccessor? current_property_accessor { get; }
		public Vala.DataType? current_return_type { get; }
		public Vala.SourceFile current_source_file { get; set; }
		public Vala.Struct? current_struct { get; }
		public Vala.Symbol? current_symbol { get; set; }
		public Vala.TypeSymbol? current_type_symbol { get; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class Signal : Vala.Symbol, Vala.Callable {
		public Signal (string name, Vala.DataType return_type, Vala.SourceReference? source_reference = null, Vala.Comment? comment = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public Vala.Delegate get_delegate (Vala.DataType sender_type, Vala.CodeNode node_reference);
		public override void replace_type (Vala.DataType old_type, Vala.DataType new_type);
		public Vala.Block body { get; set; }
		public Vala.Method default_handler { get; private set; }
		public Vala.Method emitter { get; private set; }
		public bool is_virtual { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class SignalType : Vala.CallableType {
		public SignalType (Vala.Signal signal_symbol);
		public override bool compatible (Vala.DataType target_type);
		public override Vala.DataType copy ();
		public Vala.DelegateType get_handler_type ();
		public override Vala.Symbol? get_member (string member_name);
		public override bool is_accessible (Vala.Symbol sym);
		public override string to_qualified_string (Vala.Scope? scope);
		public weak Vala.Signal signal_symbol { get; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class SizeofExpression : Vala.Expression {
		public SizeofExpression (Vala.DataType type, Vala.SourceReference? source = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public override bool is_constant ();
		public override bool is_pure ();
		public override void replace_type (Vala.DataType old_type, Vala.DataType new_type);
		public Vala.DataType type_reference { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class SliceExpression : Vala.Expression {
		public SliceExpression (Vala.Expression container, Vala.Expression start, Vala.Expression stop, Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public override void get_defined_variables (Vala.Collection<Vala.Variable> collection);
		public override void get_used_variables (Vala.Collection<Vala.Variable> collection);
		public override bool is_accessible (Vala.Symbol sym);
		public override bool is_pure ();
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public Vala.Expression container { get; private set; }
		public Vala.Expression start { get; private set; }
		public Vala.Expression stop { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class SourceFile {
		public SourceFile (Vala.CodeContext context, Vala.SourceFileType type, string filename, string? content = null, bool cmdline = false);
		public void accept (Vala.CodeVisitor visitor);
		public void accept_children (Vala.CodeVisitor visitor);
		public void add_comment (Vala.Comment comment);
		public void add_node (Vala.CodeNode node);
		public void add_using_directive (Vala.UsingDirective ns);
		public bool check (Vala.CodeContext context);
		public string get_cinclude_filename ();
		public unowned Vala.List<Vala.Comment> get_comments ();
		public string get_csource_filename ();
		public char* get_mapped_contents ();
		public size_t get_mapped_length ();
		public unowned Vala.List<Vala.CodeNode> get_nodes ();
		public string get_relative_filename ();
		public string? get_source_line (int lineno);
		public void remove_node (Vala.CodeNode node);
		public string? content { get; set; }
		public weak Vala.CodeContext context { get; set; }
		public Vala.List<Vala.UsingDirective> current_using_directives { get; set; }
		public Vala.SourceFileType file_type { get; set; }
		public string filename { get; private set; }
		public bool from_commandline { get; set; }
		public bool gir_ambiguous { get; set; }
		public string gir_namespace { get; set; }
		public string gir_version { get; set; }
		public string? installed_version { get; set; }
		public string? package_name { get; set; }
		public string? relative_filename { set; }
		public bool used { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class SourceReference {
		public SourceReference (Vala.SourceFile _file, Vala.SourceLocation begin, Vala.SourceLocation end);
		public bool contains (Vala.SourceLocation location);
		public string to_string ();
		public Vala.SourceLocation begin { get; set; }
		public Vala.SourceLocation end { get; set; }
		public weak Vala.SourceFile file { get; set; }
		public Vala.List<Vala.UsingDirective> using_directives { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class StatementList : Vala.CodeNode, Vala.Statement {
		public StatementList (Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public void add (Vala.Statement stmt);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public Vala.Statement @get (int index);
		public override void get_error_types (Vala.Collection<Vala.DataType> collection, Vala.SourceReference? source_reference = null);
		public void insert (int index, Vala.Statement stmt);
		public void @set (int index, Vala.Statement stmt);
		public int length { get; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class StringLiteral : Vala.Literal {
		public StringLiteral (string value, Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public string? eval ();
		public static Vala.StringLiteral? get_format_literal (Vala.Expression expr);
		public override bool is_non_null ();
		public override bool is_pure ();
		public override string to_string ();
		public bool translate { get; set; }
		public string value { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class Struct : Vala.TypeSymbol {
		public Struct (string name, Vala.SourceReference? source_reference = null, Vala.Comment? comment = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override void add_constant (Vala.Constant c);
		public override void add_field (Vala.Field f);
		public override void add_method (Vala.Method m);
		public override void add_property (Vala.Property prop);
		public void add_type_parameter (Vala.TypeParameter p);
		public override bool check (Vala.CodeContext context);
		public unowned Vala.List<Vala.Constant> get_constants ();
		public unowned Vala.List<Vala.Field> get_fields ();
		public unowned Vala.List<Vala.Method> get_methods ();
		public unowned Vala.List<Vala.Property> get_properties ();
		public override int get_type_parameter_index (string name);
		public unowned Vala.List<Vala.TypeParameter> get_type_parameters ();
		public bool is_boolean_type ();
		public bool is_decimal_floating_type ();
		public bool is_disposable ();
		public bool is_floating_type ();
		public bool is_integer_type ();
		public bool is_simple_type ();
		public override bool is_subtype_of (Vala.TypeSymbol t);
		public override void replace_type (Vala.DataType old_type, Vala.DataType new_type);
		public void set_simple_type (bool simple_type);
		public Vala.Struct? base_struct { get; }
		public Vala.DataType? base_type { get; set; }
		public Vala.CreationMethod? default_construction_method { get; private set; }
		public bool is_immutable { get; set; }
		public int rank { get; set; }
		public bool signed { get; set; }
		public int width { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class StructValueType : Vala.ValueType {
		public StructValueType (Vala.Struct type_symbol);
		public override Vala.DataType copy ();
		public override unowned Vala.List<Vala.Parameter>? get_parameters ();
		public override unowned Vala.DataType? get_return_type ();
		public override bool is_invokable ();
	}
	[CCode (cheader_filename = "vala.h")]
	public abstract class Subroutine : Vala.Symbol {
		protected Subroutine (string? name, Vala.SourceReference? source_reference = null, Vala.Comment? comment = null);
		public Vala.Block body { get; set; }
		public Vala.BasicBlock entry_block { get; set; }
		public Vala.BasicBlock exit_block { get; set; }
		public abstract bool has_result { get; }
		public Vala.LocalVariable result_var { get; set; }
		public Vala.BasicBlock return_block { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class SwitchLabel : Vala.CodeNode {
		public SwitchLabel (Vala.Expression expr, Vala.SourceReference? source = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public SwitchLabel.with_default (Vala.SourceReference? source = null);
		public Vala.Expression expression { get; private set; }
		public weak Vala.SwitchSection section { get; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class SwitchSection : Vala.Block {
		public SwitchSection (Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public void add_label (Vala.SwitchLabel label);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public unowned Vala.List<Vala.SwitchLabel> get_labels ();
		public bool has_default_label ();
	}
	[CCode (cheader_filename = "vala.h")]
	public class SwitchStatement : Vala.CodeNode, Vala.Statement {
		public SwitchStatement (Vala.Expression expression, Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public void add_section (Vala.SwitchSection section);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public override void get_error_types (Vala.Collection<Vala.DataType> collection, Vala.SourceReference? source_reference = null);
		public unowned Vala.List<Vala.SwitchSection> get_sections ();
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public Vala.Expression expression { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public abstract class Symbol : Vala.CodeNode {
		protected Symbol (string? name, Vala.SourceReference? source_reference = null, Vala.Comment? comment = null);
		public virtual void add_class (Vala.Class cl);
		public virtual void add_constant (Vala.Constant constant);
		public virtual void add_constructor (Vala.Constructor c);
		public virtual void add_delegate (Vala.Delegate d);
		public virtual void add_destructor (Vala.Destructor d);
		public virtual void add_enum (Vala.Enum en);
		public virtual void add_error_domain (Vala.ErrorDomain edomain);
		public virtual void add_field (Vala.Field f);
		public virtual void add_interface (Vala.Interface iface);
		public virtual void add_method (Vala.Method m);
		public virtual void add_namespace (Vala.Namespace ns);
		public virtual void add_property (Vala.Property prop);
		public virtual void add_signal (Vala.Signal sig);
		public virtual void add_struct (Vala.Struct st);
		public static string camel_case_to_lower_case (string camel_case);
		public static bool equal_func (Vala.Symbol a, Vala.Symbol b);
		public string get_full_name ();
		public Vala.Symbol? get_hidden_member ();
		public Vala.Scope? get_top_accessible_scope (bool is_internal = false);
		public static uint hash_func (Vala.Symbol s);
		public bool is_accessible (Vala.Symbol sym);
		public virtual bool is_class_member ();
		public virtual bool is_instance_member ();
		public bool is_internal_symbol ();
		public bool is_private_symbol ();
		public static string lower_case_to_camel_case (string lower_case);
		public override string to_string ();
		public Vala.SymbolAccessibility access { get; set; }
		public bool active { get; set; }
		public bool anonymous { get; set; }
		public Vala.Comment? comment { get; set; }
		public bool external { get; set; }
		public bool external_package { get; }
		public bool from_commandline { get; }
		public bool hides { get; set; }
		public bool is_extern { get; set; }
		public string? name { get; set; }
		public weak Vala.Scope owner { get; set; }
		public weak Vala.Symbol? parent_symbol { get; }
		public Vala.Scope scope { get; }
		public Vala.SourceFileType source_type { get; }
		public bool used { get; set; }
		public Vala.VersionAttribute version { get; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class SymbolResolver : Vala.CodeVisitor {
		public SymbolResolver ();
		public void resolve (Vala.CodeContext context);
		public override void visit_addressof_expression (Vala.AddressofExpression expr);
		public override void visit_array_creation_expression (Vala.ArrayCreationExpression e);
		public override void visit_assignment (Vala.Assignment a);
		public override void visit_binary_expression (Vala.BinaryExpression expr);
		public override void visit_block (Vala.Block b);
		public override void visit_cast_expression (Vala.CastExpression expr);
		public override void visit_catch_clause (Vala.CatchClause clause);
		public override void visit_class (Vala.Class cl);
		public override void visit_conditional_expression (Vala.ConditionalExpression expr);
		public override void visit_constant (Vala.Constant c);
		public override void visit_constructor (Vala.Constructor c);
		public override void visit_creation_method (Vala.CreationMethod m);
		public override void visit_data_type (Vala.DataType data_type);
		public override void visit_declaration_statement (Vala.DeclarationStatement stmt);
		public override void visit_delegate (Vala.Delegate cb);
		public override void visit_delete_statement (Vala.DeleteStatement stmt);
		public override void visit_destructor (Vala.Destructor d);
		public override void visit_do_statement (Vala.DoStatement stmt);
		public override void visit_element_access (Vala.ElementAccess expr);
		public override void visit_enum (Vala.Enum en);
		public override void visit_error_domain (Vala.ErrorDomain ed);
		public override void visit_expression_statement (Vala.ExpressionStatement stmt);
		public override void visit_field (Vala.Field f);
		public override void visit_for_statement (Vala.ForStatement stmt);
		public override void visit_foreach_statement (Vala.ForeachStatement stmt);
		public override void visit_formal_parameter (Vala.Parameter p);
		public override void visit_if_statement (Vala.IfStatement stmt);
		public override void visit_initializer_list (Vala.InitializerList list);
		public override void visit_interface (Vala.Interface iface);
		public override void visit_lambda_expression (Vala.LambdaExpression l);
		public override void visit_local_variable (Vala.LocalVariable local);
		public override void visit_loop_statement (Vala.LoopStatement stmt);
		public override void visit_member_access (Vala.MemberAccess expr);
		public override void visit_method (Vala.Method m);
		public override void visit_method_call (Vala.MethodCall expr);
		public override void visit_named_argument (Vala.NamedArgument expr);
		public override void visit_namespace (Vala.Namespace ns);
		public override void visit_object_creation_expression (Vala.ObjectCreationExpression expr);
		public override void visit_pointer_indirection (Vala.PointerIndirection expr);
		public override void visit_postfix_expression (Vala.PostfixExpression expr);
		public override void visit_property (Vala.Property prop);
		public override void visit_property_accessor (Vala.PropertyAccessor acc);
		public override void visit_reference_transfer_expression (Vala.ReferenceTransferExpression expr);
		public override void visit_return_statement (Vala.ReturnStatement stmt);
		public override void visit_signal (Vala.Signal sig);
		public override void visit_sizeof_expression (Vala.SizeofExpression expr);
		public override void visit_slice_expression (Vala.SliceExpression expr);
		public override void visit_struct (Vala.Struct st);
		public override void visit_switch_label (Vala.SwitchLabel label);
		public override void visit_switch_section (Vala.SwitchSection section);
		public override void visit_switch_statement (Vala.SwitchStatement stmt);
		public override void visit_template (Vala.Template tmpl);
		public override void visit_throw_statement (Vala.ThrowStatement stmt);
		public override void visit_try_statement (Vala.TryStatement stmt);
		public override void visit_tuple (Vala.Tuple tuple);
		public override void visit_type_check (Vala.TypeCheck expr);
		public override void visit_typeof_expression (Vala.TypeofExpression expr);
		public override void visit_unary_expression (Vala.UnaryExpression expr);
		public override void visit_using_directive (Vala.UsingDirective ns);
		public override void visit_while_statement (Vala.WhileStatement stmt);
		public override void visit_with_statement (Vala.WithStatement stmt);
		public override void visit_yield_statement (Vala.YieldStatement stmt);
	}
	[CCode (cheader_filename = "vala.h")]
	public abstract class TargetValue {
		protected TargetValue (Vala.DataType? value_type);
		public Vala.DataType? actual_value_type { get; set; }
		public Vala.DataType? value_type { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class Template : Vala.Expression {
		public Template (Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public void add_expression (Vala.Expression expr);
		public override bool check (Vala.CodeContext context);
		public unowned Vala.List<Vala.Expression> get_expressions ();
		public override bool is_pure ();
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
	}
	[CCode (cheader_filename = "vala.h")]
	public class ThrowStatement : Vala.CodeNode, Vala.Statement {
		public ThrowStatement (Vala.Expression error_expression, Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public override void get_defined_variables (Vala.Collection<Vala.Variable> collection);
		public override void get_error_types (Vala.Collection<Vala.DataType> collection, Vala.SourceReference? source_reference = null);
		public override void get_used_variables (Vala.Collection<Vala.Variable> collection);
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public Vala.Expression error_expression { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class TraverseVisitor : Vala.CodeVisitor {
		public TraverseVisitor (owned Vala.TraverseFunc func);
		public override void visit_addressof_expression (Vala.AddressofExpression expr);
		public override void visit_array_creation_expression (Vala.ArrayCreationExpression expr);
		public override void visit_assignment (Vala.Assignment expr);
		public override void visit_binary_expression (Vala.BinaryExpression expr);
		public override void visit_block (Vala.Block b);
		public override void visit_break_statement (Vala.BreakStatement stmt);
		public override void visit_cast_expression (Vala.CastExpression expr);
		public override void visit_catch_clause (Vala.CatchClause clause);
		public override void visit_class (Vala.Class cl);
		public override void visit_conditional_expression (Vala.ConditionalExpression expr);
		public override void visit_constant (Vala.Constant c);
		public override void visit_constructor (Vala.Constructor c);
		public override void visit_continue_statement (Vala.ContinueStatement stmt);
		public override void visit_creation_method (Vala.CreationMethod m);
		public override void visit_declaration_statement (Vala.DeclarationStatement stmt);
		public override void visit_delegate (Vala.Delegate d);
		public override void visit_delete_statement (Vala.DeleteStatement stmt);
		public override void visit_destructor (Vala.Destructor d);
		public override void visit_do_statement (Vala.DoStatement stmt);
		public override void visit_element_access (Vala.ElementAccess expr);
		public override void visit_enum (Vala.Enum en);
		public override void visit_enum_value (Vala.EnumValue ev);
		public override void visit_error_code (Vala.ErrorCode ecode);
		public override void visit_error_domain (Vala.ErrorDomain edomain);
		public override void visit_expression_statement (Vala.ExpressionStatement stmt);
		public override void visit_field (Vala.Field f);
		public override void visit_for_statement (Vala.ForStatement stmt);
		public override void visit_foreach_statement (Vala.ForeachStatement stmt);
		public override void visit_formal_parameter (Vala.Parameter p);
		public override void visit_if_statement (Vala.IfStatement stmt);
		public override void visit_initializer_list (Vala.InitializerList list);
		public override void visit_interface (Vala.Interface iface);
		public override void visit_lambda_expression (Vala.LambdaExpression expr);
		public override void visit_local_variable (Vala.LocalVariable local);
		public override void visit_lock_statement (Vala.LockStatement stmt);
		public override void visit_loop_statement (Vala.LoopStatement loop);
		public override void visit_member_access (Vala.MemberAccess expr);
		public override void visit_method (Vala.Method m);
		public override void visit_method_call (Vala.MethodCall expr);
		public override void visit_namespace (Vala.Namespace ns);
		public override void visit_object_creation_expression (Vala.ObjectCreationExpression expr);
		public override void visit_pointer_indirection (Vala.PointerIndirection expr);
		public override void visit_postfix_expression (Vala.PostfixExpression expr);
		public override void visit_property (Vala.Property prop);
		public override void visit_property_accessor (Vala.PropertyAccessor acc);
		public override void visit_reference_transfer_expression (Vala.ReferenceTransferExpression expr);
		public override void visit_return_statement (Vala.ReturnStatement stmt);
		public override void visit_signal (Vala.Signal sig);
		public override void visit_slice_expression (Vala.SliceExpression expr);
		public override void visit_struct (Vala.Struct st);
		public override void visit_switch_label (Vala.SwitchLabel label);
		public override void visit_switch_section (Vala.SwitchSection section);
		public override void visit_switch_statement (Vala.SwitchStatement stmt);
		public override void visit_throw_statement (Vala.ThrowStatement stmt);
		public override void visit_try_statement (Vala.TryStatement stmt);
		public override void visit_unary_expression (Vala.UnaryExpression expr);
		public override void visit_unlock_statement (Vala.UnlockStatement stmt);
		public override void visit_while_statement (Vala.WhileStatement stmt);
		public override void visit_with_statement (Vala.WithStatement stmt);
		public override void visit_yield_statement (Vala.YieldStatement stmt);
	}
	[CCode (cheader_filename = "vala.h")]
	public class TryStatement : Vala.CodeNode, Vala.Statement {
		public TryStatement (Vala.Block body, Vala.Block? finally_body, Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public void add_catch_clause (Vala.CatchClause clause);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public unowned Vala.List<Vala.CatchClause> get_catch_clauses ();
		public override void get_error_types (Vala.Collection<Vala.DataType> collection, Vala.SourceReference? source_reference = null);
		public bool after_try_block_reachable { get; set; }
		public Vala.Block body { get; private set; }
		public Vala.Block? finally_body { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class Tuple : Vala.Expression {
		public Tuple (Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public void add_expression (Vala.Expression expr);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public unowned Vala.List<Vala.Expression> get_expressions ();
		public override bool is_pure ();
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
	}
	[CCode (cheader_filename = "vala.h")]
	public class TypeCheck : Vala.Expression {
		public TypeCheck (Vala.Expression expr, Vala.DataType type, Vala.SourceReference? source = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public override bool is_pure ();
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public override void replace_type (Vala.DataType old_type, Vala.DataType new_type);
		public override string to_string ();
		public Vala.Expression expression { get; private set; }
		public Vala.DataType type_reference { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class TypeParameter : Vala.Symbol {
		public TypeParameter (string name, Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public bool equals (Vala.TypeParameter param2);
	}
	[CCode (cheader_filename = "vala.h")]
	public abstract class TypeSymbol : Vala.Symbol {
		protected TypeSymbol (string? name, Vala.SourceReference? source_reference = null, Vala.Comment? comment = null);
		public virtual int get_type_parameter_index (string name);
		public virtual bool is_reference_type ();
		public virtual bool is_subtype_of (Vala.TypeSymbol t);
	}
	[CCode (cheader_filename = "vala.h")]
	public class TypeofExpression : Vala.Expression {
		public TypeofExpression (Vala.DataType type, Vala.SourceReference? source = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public override bool is_pure ();
		public override void replace_type (Vala.DataType old_type, Vala.DataType new_type);
		public Vala.DataType type_reference { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class UnaryExpression : Vala.Expression {
		public UnaryExpression (Vala.UnaryOperator op, Vala.Expression _inner, Vala.SourceReference? source = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public override void get_defined_variables (Vala.Collection<Vala.Variable> collection);
		public override void get_error_types (Vala.Collection<Vala.DataType> collection, Vala.SourceReference? source_reference = null);
		public override void get_used_variables (Vala.Collection<Vala.Variable> collection);
		public override bool is_accessible (Vala.Symbol sym);
		public override bool is_constant ();
		public override bool is_pure ();
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public override string to_string ();
		public Vala.Expression inner { get; private set; }
		public Vala.UnaryOperator operator { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class UnlockStatement : Vala.CodeNode, Vala.Statement {
		public UnlockStatement (Vala.Expression resource, Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public override void replace_expression (Vala.Expression old_node, Vala.Expression new_node);
		public Vala.Expression resource { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class UnresolvedSymbol : Vala.Symbol {
		public UnresolvedSymbol (Vala.UnresolvedSymbol? inner, string name, Vala.SourceReference? source_reference = null);
		public Vala.UnresolvedSymbol copy ();
		public static Vala.UnresolvedSymbol? new_from_expression (Vala.Expression expr);
		public override string to_string ();
		public Vala.UnresolvedSymbol? inner { get; set; }
		public bool qualified { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class UnresolvedType : Vala.DataType {
		public UnresolvedType ();
		public override Vala.DataType copy ();
		public UnresolvedType.from_symbol (Vala.UnresolvedSymbol symbol, Vala.SourceReference? source = null);
		public override bool is_disposable ();
		public static Vala.UnresolvedType? new_from_expression (Vala.Expression expr);
		public override string to_qualified_string (Vala.Scope? scope);
		public Vala.UnresolvedSymbol unresolved_symbol { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class UsedAttr : Vala.CodeVisitor {
		public Vala.Map<string,Vala.Set<string>> marked;
		public UsedAttr ();
		public void check_unused (Vala.CodeContext context);
		public void mark (string attribute, string? argument);
		public override void visit_class (Vala.Class cl);
		public override void visit_constant (Vala.Constant c);
		public override void visit_creation_method (Vala.CreationMethod m);
		public override void visit_delegate (Vala.Delegate cb);
		public override void visit_enum (Vala.Enum en);
		public override void visit_error_domain (Vala.ErrorDomain ed);
		public override void visit_field (Vala.Field f);
		public override void visit_formal_parameter (Vala.Parameter p);
		public override void visit_interface (Vala.Interface iface);
		public override void visit_method (Vala.Method m);
		public override void visit_namespace (Vala.Namespace ns);
		public override void visit_property (Vala.Property prop);
		public override void visit_signal (Vala.Signal sig);
		public override void visit_struct (Vala.Struct st);
	}
	[CCode (cheader_filename = "vala.h")]
	public class UsingDirective : Vala.CodeNode {
		public UsingDirective (Vala.Symbol namespace_symbol, Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public weak Vala.Symbol namespace_symbol { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public abstract class ValueType : Vala.DataType {
		protected ValueType (Vala.TypeSymbol type_symbol);
		public override bool check (Vala.CodeContext context);
		public override bool is_disposable ();
	}
	[CCode (cheader_filename = "vala.h")]
	public class VarType : Vala.DataType {
		public VarType (bool value_owned = true);
		public override Vala.DataType copy ();
		public override string to_qualified_string (Vala.Scope? scope);
	}
	[CCode (cheader_filename = "vala.h")]
	public class Variable : Vala.Symbol {
		public Variable (Vala.DataType? variable_type, string? name, Vala.Expression? initializer = null, Vala.SourceReference? source_reference = null, Vala.Comment? comment = null);
		public Vala.Expression? initializer { get; set; }
		public bool single_assignment { get; set; }
		public Vala.DataType? variable_type { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class VersionAttribute {
		public VersionAttribute (Vala.Symbol symbol);
		public bool check (Vala.CodeContext context, Vala.SourceReference? source_ref = null);
		public static int cmp_versions (string v1str, string v2str);
		public bool deprecated { get; set; }
		public string? deprecated_since { owned get; set; }
		public bool experimental { get; set; }
		public string? experimental_until { owned get; set; }
		public string? replacement { owned get; set; }
		public string? since { owned get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class VoidType : Vala.DataType {
		public VoidType (Vala.SourceReference? source_reference = null);
		public override bool compatible (Vala.DataType type2);
		public override Vala.DataType copy ();
		public override bool stricter (Vala.DataType type2);
		public override string to_qualified_string (Vala.Scope? scope);
	}
	[CCode (cheader_filename = "vala.h")]
	public class WhileStatement : Vala.Loop, Vala.Statement {
		public WhileStatement (Vala.Expression condition, Vala.Block body, Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
	}
	[CCode (cheader_filename = "vala.h")]
	public class WithStatement : Vala.Block {
		public WithStatement (Vala.LocalVariable? variable, Vala.Expression expression, Vala.Block body, Vala.SourceReference? source_reference = null);
		public override void accept (Vala.CodeVisitor visitor);
		public override void accept_children (Vala.CodeVisitor visitor);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
		public override void get_defined_variables (Vala.Collection<Vala.Variable> collection);
		public override void get_error_types (Vala.Collection<Vala.DataType> collection, Vala.SourceReference? source_reference = null);
		public Vala.Block body { get; private set; }
		public Vala.Expression expression { get; private set; }
		public Vala.LocalVariable? with_variable { get; private set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public class YieldStatement : Vala.CodeNode, Vala.Statement {
		public YieldStatement (Vala.SourceReference? source_reference = null);
		public override bool check (Vala.CodeContext context);
		public override void emit (Vala.CodeGenerator codegen);
	}
	[CCode (cheader_filename = "vala.h")]
	public interface Callable : Vala.Symbol {
		public abstract void add_parameter (Vala.Parameter param);
		public abstract unowned Vala.List<Vala.Parameter> get_parameters ();
		public abstract Vala.DataType return_type { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public interface CallableExpression : Vala.Expression {
		public abstract void add_argument (Vala.Expression arg);
		public abstract unowned Vala.List<Vala.Expression> get_argument_list ();
		public abstract bool is_yield_expression { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public interface Lockable {
		public abstract bool lock_used { get; set; }
	}
	[CCode (cheader_filename = "vala.h")]
	public interface Statement : Vala.CodeNode {
	}
	[CCode (cheader_filename = "vala.h")]
	public struct SourceLocation {
		public char* pos;
		public int line;
		public int column;
		public SourceLocation (char* _pos, int _line, int _column);
		public string to_string ();
	}
	[CCode (cheader_filename = "vala.h")]
	public enum AssignmentOperator {
		NONE,
		SIMPLE,
		BITWISE_OR,
		BITWISE_AND,
		BITWISE_XOR,
		ADD,
		SUB,
		MUL,
		DIV,
		PERCENT,
		SHIFT_LEFT,
		SHIFT_RIGHT;
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "vala.h")]
	public enum BinaryOperator {
		NONE,
		PLUS,
		MINUS,
		MUL,
		DIV,
		MOD,
		SHIFT_LEFT,
		SHIFT_RIGHT,
		LESS_THAN,
		GREATER_THAN,
		LESS_THAN_OR_EQUAL,
		GREATER_THAN_OR_EQUAL,
		EQUALITY,
		INEQUALITY,
		BITWISE_AND,
		BITWISE_OR,
		BITWISE_XOR,
		AND,
		OR,
		IN,
		COALESCE;
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "vala.h")]
	public enum CodeWriterType {
		EXTERNAL,
		INTERNAL,
		FAST,
		DUMP,
		VAPIGEN
	}
	[CCode (cheader_filename = "vala.h")]
	public enum MarkupTokenType {
		NONE,
		START_ELEMENT,
		END_ELEMENT,
		TEXT,
		EOF;
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "vala.h")]
	public enum MemberBinding {
		INSTANCE,
		CLASS,
		STATIC
	}
	[CCode (cheader_filename = "vala.h")]
	public enum ParameterDirection {
		IN,
		OUT,
		REF
	}
	[CCode (cheader_filename = "vala.h")]
	public enum Profile {
		GOBJECT,
		POSIX
	}
	[CCode (cheader_filename = "vala.h")]
	public enum SourceFileType {
		NONE,
		SOURCE,
		PACKAGE,
		FAST
	}
	[CCode (cheader_filename = "vala.h")]
	public enum SymbolAccessibility {
		PRIVATE,
		INTERNAL,
		PROTECTED,
		PUBLIC;
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "vala.h")]
	public enum TokenType {
		NONE,
		ABSTRACT,
		AS,
		ASSIGN,
		ASSIGN_ADD,
		ASSIGN_BITWISE_AND,
		ASSIGN_BITWISE_OR,
		ASSIGN_BITWISE_XOR,
		ASSIGN_DIV,
		ASSIGN_MUL,
		ASSIGN_PERCENT,
		ASSIGN_SHIFT_LEFT,
		ASSIGN_SUB,
		ASYNC,
		BASE,
		BITWISE_AND,
		BITWISE_OR,
		BREAK,
		CARRET,
		CASE,
		CATCH,
		CHARACTER_LITERAL,
		CLASS,
		CLOSE_BRACE,
		CLOSE_BRACKET,
		CLOSE_PARENS,
		CLOSE_REGEX_LITERAL,
		CLOSE_TEMPLATE,
		COLON,
		COMMA,
		CONST,
		CONSTRUCT,
		CONTINUE,
		DEFAULT,
		DELEGATE,
		DELETE,
		DIV,
		DO,
		DOUBLE_COLON,
		DOT,
		DYNAMIC,
		ELLIPSIS,
		ELSE,
		ENUM,
		ENSURES,
		ERRORDOMAIN,
		EOF,
		EXTERN,
		FALSE,
		FINALLY,
		FOR,
		FOREACH,
		GET,
		HASH,
		IDENTIFIER,
		IF,
		IN,
		INLINE,
		INTEGER_LITERAL,
		INTERFACE,
		INTERNAL,
		INTERR,
		IS,
		LAMBDA,
		LOCK,
		MINUS,
		NAMESPACE,
		NEW,
		NULL,
		OUT,
		OP_AND,
		OP_COALESCING,
		OP_DEC,
		OP_EQ,
		OP_GE,
		OP_GT,
		OP_INC,
		OP_LE,
		OP_LT,
		OP_NE,
		OP_NEG,
		OP_OR,
		OP_PTR,
		OP_SHIFT_LEFT,
		OPEN_BRACE,
		OPEN_BRACKET,
		OPEN_PARENS,
		OPEN_REGEX_LITERAL,
		OPEN_TEMPLATE,
		OVERRIDE,
		OWNED,
		PARAMS,
		PERCENT,
		PLUS,
		PRIVATE,
		PROTECTED,
		PUBLIC,
		REAL_LITERAL,
		REF,
		REGEX_LITERAL,
		REQUIRES,
		RETURN,
		SEALED,
		SEMICOLON,
		SET,
		SIGNAL,
		SIZEOF,
		STAR,
		STATIC,
		STRING_LITERAL,
		STRUCT,
		SWITCH,
		TEMPLATE_STRING_LITERAL,
		THIS,
		THROW,
		THROWS,
		TILDE,
		TRUE,
		TRY,
		TYPEOF,
		UNLOCK,
		UNOWNED,
		USING,
		VAR,
		VERBATIM_STRING_LITERAL,
		VIRTUAL,
		VOID,
		VOLATILE,
		WEAK,
		WHILE,
		WITH,
		YIELD;
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "vala.h")]
	public enum TraverseStatus {
		STOP,
		CONTINUE
	}
	[CCode (cheader_filename = "vala.h")]
	public enum UnaryOperator {
		NONE,
		PLUS,
		MINUS,
		LOGICAL_NEGATION,
		BITWISE_COMPLEMENT,
		INCREMENT,
		DECREMENT,
		REF,
		OUT;
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "vala.h")]
	public errordomain ParseError {
		FAILED,
		SYNTAX
	}
	[CCode (cheader_filename = "vala.h")]
	public delegate Vala.TraverseStatus TraverseFunc (Vala.CodeNode node);
	[CCode (cheader_filename = "vala.h")]
	public const string API_VERSION;
	[CCode (cheader_filename = "vala.h")]
	public const string BUILD_VERSION;
	[CCode (cheader_filename = "vala.h")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "vala.h")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "vala.h")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "vala.h")]
	public static unowned string? check_version (uint required_major, uint required_minor, uint required_micro);
	[CCode (cheader_filename = "vala.h")]
	public static unowned string get_build_version ();
	[CCode (cheader_filename = "vala.h")]
	public static uint get_major_version ();
	[CCode (cheader_filename = "vala.h")]
	public static uint get_micro_version ();
	[CCode (cheader_filename = "vala.h")]
	public static uint get_minor_version ();
}
