/* valamethodcall.c generated by valac, the Vala compiler
 * generated from valamethodcall.vala, do not modify */

/* valamethodcall.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValaMethodCallPrivate {
	gboolean _is_yield_expression;
	gboolean _is_assert;
	gboolean _is_constructv_chainup;
	gboolean _is_chainup;
	ValaExpression* _call;
	ValaList* argument_list;
};

static gint ValaMethodCall_private_offset;
static gpointer vala_method_call_parent_class = NULL;
static ValaCallableExpressionIface * vala_method_call_vala_callable_expression_parent_iface = NULL;

static void vala_method_call_set_call (ValaMethodCall* self,
                                ValaExpression* value);
static void vala_method_call_set_is_assert (ValaMethodCall* self,
                                     gboolean value);
static void vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                                 gboolean value);
static void vala_method_call_set_is_chainup (ValaMethodCall* self,
                                      gboolean value);
static void vala_method_call_real_add_argument (ValaCallableExpression* base,
                                         ValaExpression* arg);
static ValaList* vala_method_call_real_get_argument_list (ValaCallableExpression* base);
static void vala_method_call_real_accept (ValaCodeNode* base,
                                   ValaCodeVisitor* visitor);
static void vala_method_call_real_accept_children (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor);
static void vala_method_call_real_replace_expression (ValaCodeNode* base,
                                               ValaExpression* old_node,
                                               ValaExpression* new_node);
static gboolean vala_method_call_real_is_constant (ValaExpression* base);
static gboolean vala_method_call_real_is_pure (ValaExpression* base);
static gboolean vala_method_call_real_is_accessible (ValaExpression* base,
                                              ValaSymbol* sym);
static void vala_method_call_real_get_error_types (ValaCodeNode* base,
                                            ValaCollection* collection,
                                            ValaSourceReference* source_reference);
static gboolean vala_method_call_real_check (ValaCodeNode* base,
                                      ValaCodeContext* context);
static void vala_method_call_real_emit (ValaCodeNode* base,
                                 ValaCodeGenerator* codegen);
static void vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                                  ValaCollection* collection);
static void vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                               ValaCollection* collection);
static gchar* vala_method_call_real_to_string (ValaCodeNode* base);
static void vala_method_call_finalize (ValaCodeNode * obj);
static GType vala_method_call_get_type_once (void);

static inline gpointer
vala_method_call_get_instance_private (ValaMethodCall* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMethodCall_private_offset);
}

ValaExpression*
vala_method_call_get_call (ValaMethodCall* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_call;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_method_call_set_call (ValaMethodCall* self,
                           ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_call);
	self->priv->_call = _tmp0_;
	_tmp1_ = self->priv->_call;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

static gboolean
vala_method_call_real_get_is_yield_expression (ValaCallableExpression* base)
{
	gboolean result;
	ValaMethodCall* self;
	self = (ValaMethodCall*) base;
	result = self->priv->_is_yield_expression;
	return result;
}

static void
vala_method_call_real_set_is_yield_expression (ValaCallableExpression* base,
                                               gboolean value)
{
	ValaMethodCall* self;
	self = (ValaMethodCall*) base;
	self->priv->_is_yield_expression = value;
}

gboolean
vala_method_call_get_is_assert (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_assert;
	return result;
}

static void
vala_method_call_set_is_assert (ValaMethodCall* self,
                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_assert = value;
}

gboolean
vala_method_call_get_is_constructv_chainup (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_constructv_chainup;
	return result;
}

static void
vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_constructv_chainup = value;
}

gboolean
vala_method_call_get_is_chainup (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_chainup;
	return result;
}

static void
vala_method_call_set_is_chainup (ValaMethodCall* self,
                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_chainup = value;
}

/**
 * Creates a new invocation expression.
 *
 * @param call             method to call
 * @param source_reference reference to source code
 * @return                 newly created invocation expression
 */
ValaMethodCall*
vala_method_call_construct (GType object_type,
                            ValaExpression* call,
                            ValaSourceReference* source_reference)
{
	ValaMethodCall* self = NULL;
	g_return_val_if_fail (call != NULL, NULL);
	self = (ValaMethodCall*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_method_call_set_call (self, call);
	return self;
}

ValaMethodCall*
vala_method_call_new (ValaExpression* call,
                      ValaSourceReference* source_reference)
{
	return vala_method_call_construct (VALA_TYPE_METHOD_CALL, call, source_reference);
}

/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
static void
vala_method_call_real_add_argument (ValaCallableExpression* base,
                                    ValaExpression* arg)
{
	ValaMethodCall * self;
	ValaList* _tmp0_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the argument list.
 *
 * @return argument list
 */
static ValaList*
vala_method_call_real_get_argument_list (ValaCallableExpression* base)
{
	ValaMethodCall * self;
	ValaList* _tmp0_;
	ValaList* result = NULL;
	self = (ValaMethodCall*) base;
	_tmp0_ = self->priv->argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_method_call_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method_call (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_method_call_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp2_;
		gint _expr_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _expr_index = 0;
		_tmp2_ = self->priv->argument_list;
		_expr_list = _tmp2_;
		_tmp3_ = _expr_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_expr_size = _tmp5_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* expr = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_expr_index = _expr_index + 1;
			_tmp6_ = _expr_index;
			_tmp7_ = _expr_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _expr_list;
			_tmp9_ = vala_list_get (_tmp8_, _expr_index);
			expr = (ValaExpression*) _tmp9_;
			_tmp10_ = expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp10_, visitor);
			_vala_code_node_unref0 (expr);
		}
	}
}

static void
vala_method_call_real_replace_expression (ValaCodeNode* base,
                                          ValaExpression* old_node,
                                          ValaExpression* new_node)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gint index = 0;
	ValaList* _tmp2_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_method_call_set_call (self, new_node);
	}
	_tmp2_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp2_, old_node);
	if (index >= 0) {
		ValaList* _tmp3_;
		_tmp3_ = self->priv->argument_list;
		vala_list_set (_tmp3_, index, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}

static gboolean
vala_method_call_real_is_constant (ValaExpression* base)
{
	ValaMethodCall * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	method_type = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp4_ = method_type;
	if (_tmp4_ != NULL) {
		ValaMethodType* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gboolean _tmp10_;
		_tmp5_ = method_type;
		_tmp6_ = vala_method_type_get_method_symbol (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strcmp0 (_tmp9_, "GLib.N_") == 0;
		_g_free0 (_tmp9_);
		if (_tmp10_) {
			ValaList* _tmp11_;
			gpointer _tmp12_;
			ValaExpression* _tmp13_;
			gboolean _tmp14_;
			_tmp11_ = self->priv->argument_list;
			_tmp12_ = vala_list_get (_tmp11_, 0);
			_tmp13_ = (ValaExpression*) _tmp12_;
			_tmp14_ = vala_expression_is_constant (_tmp13_);
			_vala_code_node_unref0 (_tmp13_);
			result = _tmp14_;
			return result;
		} else {
			ValaMethodType* _tmp15_;
			ValaMethod* _tmp16_;
			ValaMethod* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gboolean _tmp20_;
			_tmp15_ = method_type;
			_tmp16_ = vala_method_type_get_method_symbol (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strcmp0 (_tmp19_, "GLib.NC_") == 0;
			_g_free0 (_tmp19_);
			if (_tmp20_) {
				gboolean _tmp21_ = FALSE;
				ValaList* _tmp22_;
				gpointer _tmp23_;
				ValaExpression* _tmp24_;
				gboolean _tmp25_;
				_tmp22_ = self->priv->argument_list;
				_tmp23_ = vala_list_get (_tmp22_, 0);
				_tmp24_ = (ValaExpression*) _tmp23_;
				_tmp25_ = vala_expression_is_constant (_tmp24_);
				_vala_code_node_unref0 (_tmp24_);
				if (_tmp25_) {
					ValaList* _tmp26_;
					gpointer _tmp27_;
					ValaExpression* _tmp28_;
					_tmp26_ = self->priv->argument_list;
					_tmp27_ = vala_list_get (_tmp26_, 1);
					_tmp28_ = (ValaExpression*) _tmp27_;
					_tmp21_ = vala_expression_is_constant (_tmp28_);
					_vala_code_node_unref0 (_tmp28_);
				} else {
					_tmp21_ = FALSE;
				}
				result = _tmp21_;
				return result;
			}
		}
	}
	result = FALSE;
	return result;
}

static gboolean
vala_method_call_real_is_pure (ValaExpression* base)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_method_call_real_is_accessible (ValaExpression* base,
                                     ValaSymbol* sym)
{
	ValaMethodCall * self;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* arg = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_arg_index = _arg_index + 1;
			_tmp4_ = _arg_index;
			_tmp5_ = _arg_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _arg_list;
			_tmp7_ = vala_list_get (_tmp6_, _arg_index);
			arg = (ValaExpression*) _tmp7_;
			_tmp8_ = arg;
			if (!vala_expression_is_accessible (_tmp8_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp9_ = vala_method_call_get_call (self);
	_tmp10_ = _tmp9_;
	result = vala_expression_is_accessible (_tmp10_, sym);
	return result;
}

static void
vala_method_call_real_get_error_types (ValaCodeNode* base,
                                       ValaCollection* collection,
                                       ValaSourceReference* source_reference)
{
	ValaMethodCall * self;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	if (source_reference == NULL) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp1_ = _tmp0_;
		source_reference = _tmp1_;
	}
	_tmp2_ = vala_method_call_get_call (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_expression_get_value_type (_tmp3_);
	_tmp5_ = _tmp4_;
	mtype = _tmp5_;
	_tmp6_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp6_)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		ValaMethod* _tmp12_;
		gboolean _tmp13_;
		gboolean _tmp14_;
		_tmp7_ = mtype;
		_tmp8_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp9_ = _tmp8_;
		m = _tmp9_;
		_tmp12_ = m;
		_tmp13_ = vala_method_get_coroutine (_tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_) {
			gboolean _tmp15_;
			gboolean _tmp16_;
			_tmp15_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
			_tmp16_ = _tmp15_;
			_tmp11_ = !_tmp16_;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp17_ = vala_method_call_get_call (self);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_member_access_get_member_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp20_ = _tmp19_;
			_tmp10_ = g_strcmp0 (_tmp20_, "end") != 0;
		} else {
			_tmp10_ = FALSE;
		}
		if (!_tmp10_) {
			ValaMethod* _tmp21_;
			_tmp21_ = m;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp21_, collection, source_reference);
		}
	} else {
		ValaDataType* _tmp22_;
		_tmp22_ = mtype;
		if (VALA_IS_OBJECT_TYPE (_tmp22_)) {
			ValaClass* cl = NULL;
			ValaDataType* _tmp23_;
			ValaTypeSymbol* _tmp24_;
			ValaTypeSymbol* _tmp25_;
			ValaMethod* m = NULL;
			ValaClass* _tmp26_;
			ValaCreationMethod* _tmp27_;
			ValaCreationMethod* _tmp28_;
			ValaMethod* _tmp29_;
			_tmp23_ = mtype;
			_tmp24_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			_tmp25_ = _tmp24_;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, VALA_TYPE_CLASS, ValaClass);
			_tmp26_ = cl;
			_tmp27_ = vala_class_get_default_construction_method (_tmp26_);
			_tmp28_ = _tmp27_;
			m = (ValaMethod*) _tmp28_;
			_tmp29_ = m;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp29_, collection, source_reference);
		} else {
			ValaDataType* _tmp30_;
			_tmp30_ = mtype;
			if (VALA_IS_DELEGATE_TYPE (_tmp30_)) {
				ValaDelegate* d = NULL;
				ValaDataType* _tmp31_;
				ValaDelegate* _tmp32_;
				ValaDelegate* _tmp33_;
				ValaDelegate* _tmp34_;
				_tmp31_ = mtype;
				_tmp32_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				_tmp33_ = _tmp32_;
				d = _tmp33_;
				_tmp34_ = d;
				vala_code_node_get_error_types ((ValaCodeNode*) _tmp34_, collection, source_reference);
			}
		}
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp35_;
		gint _expr_size = 0;
		ValaList* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gint _expr_index = 0;
		_tmp35_ = self->priv->argument_list;
		_expr_list = _tmp35_;
		_tmp36_ = _expr_list;
		_tmp37_ = vala_collection_get_size ((ValaCollection*) _tmp36_);
		_tmp38_ = _tmp37_;
		_expr_size = _tmp38_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp39_;
			gint _tmp40_;
			ValaExpression* expr = NULL;
			ValaList* _tmp41_;
			gpointer _tmp42_;
			ValaExpression* _tmp43_;
			_expr_index = _expr_index + 1;
			_tmp39_ = _expr_index;
			_tmp40_ = _expr_size;
			if (!(_tmp39_ < _tmp40_)) {
				break;
			}
			_tmp41_ = _expr_list;
			_tmp42_ = vala_list_get (_tmp41_, _expr_index);
			expr = (ValaExpression*) _tmp42_;
			_tmp43_ = expr;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp43_, collection, source_reference);
			_vala_code_node_unref0 (expr);
		}
	}
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gboolean
vala_method_call_real_check (ValaCodeNode* base,
                             ValaCodeContext* context)
{
	ValaMethodCall * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaDataType* target_object_type = NULL;
	ValaList* method_type_args = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp102_;
	ValaExpression* _tmp103_;
	ValaDataType* _tmp104_;
	ValaDataType* _tmp105_;
	ValaDataType* _tmp106_;
	gboolean _tmp107_ = FALSE;
	ValaProfile _tmp108_;
	ValaProfile _tmp109_;
	gboolean gobject_chainup = FALSE;
	ValaCreationMethod* base_cm = NULL;
	gboolean _tmp135_;
	gboolean _tmp221_ = FALSE;
	ValaExpression* _tmp222_;
	ValaExpression* _tmp223_;
	gboolean _tmp294_ = FALSE;
	gboolean _tmp295_;
	ValaDataType* ret_type = NULL;
	ValaDataType* _tmp310_;
	ValaDataType* _tmp311_;
	ValaDataType* _tmp312_;
	ValaList* params = NULL;
	ValaDataType* _tmp313_;
	ValaList* _tmp314_;
	ValaList* _tmp315_;
	ValaDataType* _tmp316_;
	ValaExpression* last_arg = NULL;
	ValaIterator* arg_it = NULL;
	ValaList* _tmp372_;
	ValaIterator* _tmp373_;
	gboolean _tmp423_ = FALSE;
	ValaDataType* _tmp424_;
	gboolean _tmp445_ = FALSE;
	ValaDataType* _tmp446_;
	gboolean force_lambda_method_closure = FALSE;
	gboolean _tmp526_ = FALSE;
	gboolean _tmp527_;
	gboolean _tmp528_;
	ValaDataType* _tmp548_;
	ValaDataType* _tmp559_;
	ValaDataType* _tmp560_;
	ValaDataType* _tmp561_;
	ValaDataType* _tmp562_;
	ValaDataType* _tmp563_;
	ValaDataType* _tmp564_;
	ValaList* _tmp565_;
	ValaDataType* _tmp566_;
	ValaDataType* _tmp567_;
	gboolean _tmp568_;
	gboolean _tmp569_;
	ValaDataType* _tmp592_;
	ValaSemanticAnalyzer* _tmp841_;
	ValaSemanticAnalyzer* _tmp842_;
	ValaDataType* _tmp843_;
	ValaList* _tmp844_;
	ValaList* _tmp845_;
	gboolean _tmp872_ = FALSE;
	gboolean _tmp873_ = FALSE;
	ValaCreationMethod* _tmp874_;
	ValaDataType* _tmp902_;
	ValaDataType* _tmp903_;
	gboolean _tmp904_;
	gboolean _tmp905_;
	gboolean _tmp966_;
	gboolean _tmp967_;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_method_call_get_call (self);
	_tmp5_ = _tmp4_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp5_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	target_object_type = NULL;
	method_type_args = NULL;
	_tmp6_ = vala_method_call_get_call (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_expression_get_value_type (_tmp7_);
	_tmp9_ = _tmp8_;
	if (VALA_IS_DELEGATE_TYPE (_tmp9_)) {
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		ValaDataType* _tmp12_;
		ValaDataType* _tmp13_;
		ValaDataType* _tmp14_;
		_tmp10_ = vala_method_call_get_call (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_expression_get_value_type (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _vala_code_node_ref0 (_tmp13_);
		_vala_code_node_unref0 (target_object_type);
		target_object_type = _tmp14_;
	} else {
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		_tmp15_ = vala_method_call_get_call (self);
		_tmp16_ = _tmp15_;
		if (VALA_IS_MEMBER_ACCESS (_tmp16_)) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			ValaMemberAccess* _tmp19_;
			gboolean _tmp20_;
			gboolean _tmp21_;
			ValaMemberAccess* _tmp30_;
			ValaList* _tmp31_;
			ValaList* _tmp32_;
			ValaMemberAccess* _tmp33_;
			ValaExpression* _tmp34_;
			ValaExpression* _tmp35_;
			gboolean _tmp86_ = FALSE;
			ValaMemberAccess* _tmp87_;
			ValaSymbol* _tmp88_;
			ValaSymbol* _tmp89_;
			_tmp17_ = vala_method_call_get_call (self);
			_tmp18_ = _tmp17_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp19_ = ma;
			_tmp20_ = vala_member_access_get_prototype_access (_tmp19_);
			_tmp21_ = _tmp20_;
			if (_tmp21_) {
				ValaSourceReference* _tmp22_;
				ValaSourceReference* _tmp23_;
				ValaExpression* _tmp24_;
				ValaExpression* _tmp25_;
				ValaSymbol* _tmp26_;
				ValaSymbol* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp22_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp23_ = _tmp22_;
				_tmp24_ = vala_method_call_get_call (self);
				_tmp25_ = _tmp24_;
				_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = vala_symbol_get_full_name (_tmp27_);
				_tmp29_ = _tmp28_;
				vala_report_error (_tmp23_, "Access to instance member `%s' denied", _tmp29_);
				_g_free0 (_tmp29_);
				result = FALSE;
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_tmp30_ = ma;
			_tmp31_ = vala_member_access_get_type_arguments (_tmp30_);
			_tmp32_ = _vala_iterable_ref0 (_tmp31_);
			_vala_iterable_unref0 (method_type_args);
			method_type_args = _tmp32_;
			_tmp33_ = ma;
			_tmp34_ = vala_member_access_get_inner (_tmp33_);
			_tmp35_ = _tmp34_;
			if (_tmp35_ != NULL) {
				ValaMemberAccess* _tmp36_;
				ValaExpression* _tmp37_;
				ValaExpression* _tmp38_;
				ValaDataType* _tmp39_;
				ValaDataType* _tmp40_;
				ValaDataType* _tmp41_;
				ValaMemberAccess* _tmp42_;
				ValaExpression* _tmp43_;
				ValaExpression* _tmp44_;
				ValaSymbol* _tmp45_;
				ValaSymbol* _tmp46_;
				ValaMethod* m = NULL;
				ValaMemberAccess* _tmp57_;
				ValaSymbol* _tmp58_;
				ValaSymbol* _tmp59_;
				gboolean _tmp60_ = FALSE;
				ValaMethod* _tmp61_;
				_tmp36_ = ma;
				_tmp37_ = vala_member_access_get_inner (_tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = vala_expression_get_value_type (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = _vala_code_node_ref0 (_tmp40_);
				_vala_code_node_unref0 (target_object_type);
				target_object_type = _tmp41_;
				_tmp42_ = ma;
				_tmp43_ = vala_member_access_get_inner (_tmp42_);
				_tmp44_ = _tmp43_;
				_tmp45_ = vala_expression_get_symbol_reference (_tmp44_);
				_tmp46_ = _tmp45_;
				if (VALA_IS_SIGNAL (_tmp46_)) {
					ValaMemberAccess* sig = NULL;
					ValaMemberAccess* _tmp47_;
					ValaExpression* _tmp48_;
					ValaExpression* _tmp49_;
					ValaMemberAccess* _tmp50_;
					_tmp47_ = ma;
					_tmp48_ = vala_member_access_get_inner (_tmp47_);
					_tmp49_ = _tmp48_;
					sig = VALA_IS_MEMBER_ACCESS (_tmp49_) ? ((ValaMemberAccess*) _tmp49_) : NULL;
					_tmp50_ = sig;
					if (_tmp50_ != NULL) {
						ValaMemberAccess* _tmp51_;
						ValaExpression* _tmp52_;
						ValaExpression* _tmp53_;
						ValaDataType* _tmp54_;
						ValaDataType* _tmp55_;
						ValaDataType* _tmp56_;
						_tmp51_ = sig;
						_tmp52_ = vala_member_access_get_inner (_tmp51_);
						_tmp53_ = _tmp52_;
						_tmp54_ = vala_expression_get_value_type (_tmp53_);
						_tmp55_ = _tmp54_;
						_tmp56_ = _vala_code_node_ref0 (_tmp55_);
						_vala_code_node_unref0 (target_object_type);
						target_object_type = _tmp56_;
					}
				}
				_tmp57_ = ma;
				_tmp58_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp57_);
				_tmp59_ = _tmp58_;
				m = VALA_IS_METHOD (_tmp59_) ? ((ValaMethod*) _tmp59_) : NULL;
				_tmp61_ = m;
				if (_tmp61_ != NULL) {
					ValaMethod* _tmp62_;
					gboolean _tmp63_;
					gboolean _tmp64_;
					_tmp62_ = m;
					_tmp63_ = vala_method_get_coroutine (_tmp62_);
					_tmp64_ = _tmp63_;
					_tmp60_ = _tmp64_;
				} else {
					_tmp60_ = FALSE;
				}
				if (_tmp60_) {
					gboolean _tmp65_ = FALSE;
					ValaMemberAccess* _tmp66_;
					const gchar* _tmp67_;
					const gchar* _tmp68_;
					_tmp66_ = ma;
					_tmp67_ = vala_member_access_get_member_name (_tmp66_);
					_tmp68_ = _tmp67_;
					if (g_strcmp0 (_tmp68_, "begin") == 0) {
						_tmp65_ = TRUE;
					} else {
						ValaMemberAccess* _tmp69_;
						const gchar* _tmp70_;
						const gchar* _tmp71_;
						_tmp69_ = ma;
						_tmp70_ = vala_member_access_get_member_name (_tmp69_);
						_tmp71_ = _tmp70_;
						_tmp65_ = g_strcmp0 (_tmp71_, "end") == 0;
					}
					if (_tmp65_) {
						ValaMemberAccess* method_access = NULL;
						ValaMemberAccess* _tmp72_;
						ValaExpression* _tmp73_;
						ValaExpression* _tmp74_;
						gboolean _tmp75_ = FALSE;
						ValaMemberAccess* _tmp76_;
						_tmp72_ = ma;
						_tmp73_ = vala_member_access_get_inner (_tmp72_);
						_tmp74_ = _tmp73_;
						method_access = VALA_IS_MEMBER_ACCESS (_tmp74_) ? ((ValaMemberAccess*) _tmp74_) : NULL;
						_tmp76_ = method_access;
						if (_tmp76_ != NULL) {
							ValaMemberAccess* _tmp77_;
							ValaExpression* _tmp78_;
							ValaExpression* _tmp79_;
							_tmp77_ = method_access;
							_tmp78_ = vala_member_access_get_inner (_tmp77_);
							_tmp79_ = _tmp78_;
							_tmp75_ = _tmp79_ != NULL;
						} else {
							_tmp75_ = FALSE;
						}
						if (_tmp75_) {
							ValaMemberAccess* _tmp80_;
							ValaExpression* _tmp81_;
							ValaExpression* _tmp82_;
							ValaDataType* _tmp83_;
							ValaDataType* _tmp84_;
							ValaDataType* _tmp85_;
							_tmp80_ = method_access;
							_tmp81_ = vala_member_access_get_inner (_tmp80_);
							_tmp82_ = _tmp81_;
							_tmp83_ = vala_expression_get_value_type (_tmp82_);
							_tmp84_ = _tmp83_;
							_tmp85_ = _vala_code_node_ref0 (_tmp84_);
							_vala_code_node_unref0 (target_object_type);
							target_object_type = _tmp85_;
						} else {
							_vala_code_node_unref0 (target_object_type);
							target_object_type = NULL;
						}
					}
				}
			}
			_tmp87_ = ma;
			_tmp88_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp87_);
			_tmp89_ = _tmp88_;
			if (_tmp89_ != NULL) {
				ValaMemberAccess* _tmp90_;
				ValaSymbol* _tmp91_;
				ValaSymbol* _tmp92_;
				ValaAttribute* _tmp93_;
				_tmp90_ = ma;
				_tmp91_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp90_);
				_tmp92_ = _tmp91_;
				_tmp93_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp92_, "Assert");
				_tmp86_ = _tmp93_ != NULL;
			} else {
				_tmp86_ = FALSE;
			}
			if (_tmp86_) {
				ValaList* _tmp94_;
				gint _tmp95_;
				gint _tmp96_;
				vala_method_call_set_is_assert (self, TRUE);
				_tmp94_ = self->priv->argument_list;
				_tmp95_ = vala_collection_get_size ((ValaCollection*) _tmp94_);
				_tmp96_ = _tmp95_;
				if (_tmp96_ == 1) {
					ValaList* _tmp97_;
					gpointer _tmp98_;
					ValaExpression* _tmp99_;
					ValaSourceReference* _tmp100_;
					ValaSourceReference* _tmp101_;
					_tmp97_ = self->priv->argument_list;
					_tmp98_ = vala_list_get (_tmp97_, 0);
					_tmp99_ = (ValaExpression*) _tmp98_;
					_tmp100_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp99_);
					_tmp101_ = _tmp100_;
					vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp101_);
					_vala_code_node_unref0 (_tmp99_);
				}
			}
		}
	}
	_tmp102_ = vala_method_call_get_call (self);
	_tmp103_ = _tmp102_;
	_tmp104_ = vala_expression_get_value_type (_tmp103_);
	_tmp105_ = _tmp104_;
	_tmp106_ = _vala_code_node_ref0 (_tmp105_);
	mtype = _tmp106_;
	_tmp108_ = vala_code_context_get_profile (context);
	_tmp109_ = _tmp108_;
	if (_tmp109_ == VALA_PROFILE_GOBJECT) {
		ValaExpression* _tmp110_;
		ValaExpression* _tmp111_;
		ValaSymbol* _tmp112_;
		ValaSymbol* _tmp113_;
		ValaSemanticAnalyzer* _tmp114_;
		ValaSemanticAnalyzer* _tmp115_;
		ValaClass* _tmp116_;
		_tmp110_ = vala_method_call_get_call (self);
		_tmp111_ = _tmp110_;
		_tmp112_ = vala_expression_get_symbol_reference (_tmp111_);
		_tmp113_ = _tmp112_;
		_tmp114_ = vala_code_context_get_analyzer (context);
		_tmp115_ = _tmp114_;
		_tmp116_ = _tmp115_->object_type;
		_tmp107_ = _tmp113_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp116_, VALA_TYPE_SYMBOL, ValaSymbol);
	} else {
		_tmp107_ = FALSE;
	}
	gobject_chainup = _tmp107_;
	vala_method_call_set_is_chainup (self, gobject_chainup);
	if (!gobject_chainup) {
		ValaExpression* expr = NULL;
		ValaExpression* _tmp117_;
		ValaExpression* _tmp118_;
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp119_;
		gboolean _tmp120_ = FALSE;
		ValaMemberAccess* _tmp121_;
		gboolean _tmp129_ = FALSE;
		ValaMemberAccess* _tmp130_;
		_tmp117_ = vala_method_call_get_call (self);
		_tmp118_ = _tmp117_;
		expr = _tmp118_;
		_tmp119_ = expr;
		ma = VALA_IS_MEMBER_ACCESS (_tmp119_) ? ((ValaMemberAccess*) _tmp119_) : NULL;
		_tmp121_ = ma;
		if (_tmp121_ != NULL) {
			ValaMemberAccess* _tmp122_;
			ValaSymbol* _tmp123_;
			ValaSymbol* _tmp124_;
			_tmp122_ = ma;
			_tmp123_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp122_);
			_tmp124_ = _tmp123_;
			_tmp120_ = VALA_IS_CREATION_METHOD (_tmp124_);
		} else {
			_tmp120_ = FALSE;
		}
		if (_tmp120_) {
			ValaMemberAccess* _tmp125_;
			ValaExpression* _tmp126_;
			ValaExpression* _tmp127_;
			ValaExpression* _tmp128_;
			_tmp125_ = ma;
			_tmp126_ = vala_member_access_get_inner (_tmp125_);
			_tmp127_ = _tmp126_;
			expr = _tmp127_;
			_tmp128_ = expr;
			ma = VALA_IS_MEMBER_ACCESS (_tmp128_) ? ((ValaMemberAccess*) _tmp128_) : NULL;
		}
		_tmp130_ = ma;
		if (_tmp130_ != NULL) {
			ValaMemberAccess* _tmp131_;
			const gchar* _tmp132_;
			const gchar* _tmp133_;
			_tmp131_ = ma;
			_tmp132_ = vala_member_access_get_member_name (_tmp131_);
			_tmp133_ = _tmp132_;
			_tmp129_ = g_strcmp0 (_tmp133_, "this") == 0;
		} else {
			_tmp129_ = FALSE;
		}
		if (_tmp129_) {
			vala_method_call_set_is_chainup (self, TRUE);
		} else {
			ValaExpression* _tmp134_;
			_tmp134_ = expr;
			if (VALA_IS_BASE_ACCESS (_tmp134_)) {
				vala_method_call_set_is_chainup (self, TRUE);
			}
		}
	}
	base_cm = NULL;
	_tmp135_ = self->priv->_is_chainup;
	if (_tmp135_) {
		ValaCreationMethod* cm = NULL;
		ValaSemanticAnalyzer* _tmp136_;
		ValaSemanticAnalyzer* _tmp137_;
		ValaMethod* _tmp138_;
		ValaCreationMethod* _tmp139_;
		ValaCreationMethod* _tmp147_;
		ValaDataType* _tmp148_;
		_tmp136_ = vala_code_context_get_analyzer (context);
		_tmp137_ = _tmp136_;
		_tmp138_ = vala_semantic_analyzer_find_current_method (_tmp137_);
		cm = VALA_IS_CREATION_METHOD (_tmp138_) ? ((ValaCreationMethod*) _tmp138_) : NULL;
		_tmp139_ = cm;
		if (_tmp139_ == NULL) {
			ValaSourceReference* _tmp140_;
			ValaSourceReference* _tmp141_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp140_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp141_ = _tmp140_;
			vala_report_error (_tmp141_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		} else {
			ValaCreationMethod* _tmp142_;
			gboolean _tmp143_;
			gboolean _tmp144_;
			_tmp142_ = cm;
			_tmp143_ = vala_creation_method_get_chain_up (_tmp142_);
			_tmp144_ = _tmp143_;
			if (_tmp144_) {
				ValaSourceReference* _tmp145_;
				ValaSourceReference* _tmp146_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp145_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp146_ = _tmp145_;
				vala_report_error (_tmp146_, "Multiple constructor calls in the same constructor are not permitted");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
		_tmp147_ = cm;
		vala_creation_method_set_chain_up (_tmp147_, TRUE);
		_tmp148_ = mtype;
		if (VALA_IS_OBJECT_TYPE (_tmp148_)) {
			ValaClass* cl = NULL;
			ValaDataType* _tmp149_;
			ValaTypeSymbol* _tmp150_;
			ValaTypeSymbol* _tmp151_;
			ValaClass* _tmp152_;
			ValaCreationMethod* _tmp153_;
			ValaCreationMethod* _tmp154_;
			ValaCreationMethod* _tmp155_;
			_tmp149_ = mtype;
			_tmp150_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp149_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			_tmp151_ = _tmp150_;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp151_, VALA_TYPE_CLASS, ValaClass);
			_tmp152_ = cl;
			_tmp153_ = vala_class_get_default_construction_method (_tmp152_);
			_tmp154_ = _tmp153_;
			base_cm = _tmp154_;
			_tmp155_ = base_cm;
			if (_tmp155_ == NULL) {
				ValaSourceReference* _tmp156_;
				ValaSourceReference* _tmp157_;
				ValaClass* _tmp158_;
				gchar* _tmp159_;
				gchar* _tmp160_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp156_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp157_ = _tmp156_;
				_tmp158_ = cl;
				_tmp159_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp158_);
				_tmp160_ = _tmp159_;
				vala_report_error (_tmp157_, "chain up to `%s' not supported", _tmp160_);
				_g_free0 (_tmp160_);
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaCreationMethod* _tmp161_;
				gboolean _tmp162_;
				gboolean _tmp163_;
				_tmp161_ = base_cm;
				_tmp162_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp161_);
				_tmp163_ = _tmp162_;
				if (!_tmp163_) {
					ValaSourceReference* _tmp164_;
					ValaSourceReference* _tmp165_;
					ValaCreationMethod* _tmp166_;
					gchar* _tmp167_;
					gchar* _tmp168_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp164_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp165_ = _tmp164_;
					_tmp166_ = base_cm;
					_tmp167_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp166_);
					_tmp168_ = _tmp167_;
					vala_report_error (_tmp165_, "chain up to `%s' not supported", _tmp168_);
					_g_free0 (_tmp168_);
					result = FALSE;
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			}
		} else {
			gboolean _tmp169_ = FALSE;
			ValaExpression* _tmp170_;
			ValaExpression* _tmp171_;
			ValaSymbol* _tmp172_;
			ValaSymbol* _tmp173_;
			_tmp170_ = vala_method_call_get_call (self);
			_tmp171_ = _tmp170_;
			_tmp172_ = vala_expression_get_symbol_reference (_tmp171_);
			_tmp173_ = _tmp172_;
			if (VALA_IS_CREATION_METHOD (_tmp173_)) {
				ValaExpression* _tmp174_;
				ValaExpression* _tmp175_;
				ValaSymbol* _tmp176_;
				ValaSymbol* _tmp177_;
				ValaSymbol* _tmp178_;
				ValaSymbol* _tmp179_;
				_tmp174_ = vala_method_call_get_call (self);
				_tmp175_ = _tmp174_;
				_tmp176_ = vala_expression_get_symbol_reference (_tmp175_);
				_tmp177_ = _tmp176_;
				_tmp178_ = vala_symbol_get_parent_symbol (_tmp177_);
				_tmp179_ = _tmp178_;
				_tmp169_ = VALA_IS_CLASS (_tmp179_);
			} else {
				_tmp169_ = FALSE;
			}
			if (_tmp169_) {
				ValaExpression* _tmp180_;
				ValaExpression* _tmp181_;
				ValaSymbol* _tmp182_;
				ValaSymbol* _tmp183_;
				ValaCreationMethod* _tmp184_;
				gboolean _tmp185_;
				gboolean _tmp186_;
				_tmp180_ = vala_method_call_get_call (self);
				_tmp181_ = _tmp180_;
				_tmp182_ = vala_expression_get_symbol_reference (_tmp181_);
				_tmp183_ = _tmp182_;
				base_cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp183_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
				_tmp184_ = base_cm;
				_tmp185_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp184_);
				_tmp186_ = _tmp185_;
				if (!_tmp186_) {
					ValaSourceReference* _tmp187_;
					ValaSourceReference* _tmp188_;
					ValaCreationMethod* _tmp189_;
					gchar* _tmp190_;
					gchar* _tmp191_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp187_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp188_ = _tmp187_;
					_tmp189_ = base_cm;
					_tmp190_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp189_);
					_tmp191_ = _tmp190_;
					vala_report_error (_tmp188_, "chain up to `%s' not supported", _tmp191_);
					_g_free0 (_tmp191_);
					result = FALSE;
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			} else {
				if (gobject_chainup) {
					ValaClass* cl = NULL;
					ValaCreationMethod* _tmp192_;
					ValaSymbol* _tmp193_;
					ValaSymbol* _tmp194_;
					gboolean _tmp195_ = FALSE;
					ValaClass* _tmp196_;
					ValaExpression* _tmp203_;
					ValaExpression* _tmp204_;
					ValaSemanticAnalyzer* _tmp205_;
					ValaSemanticAnalyzer* _tmp206_;
					ValaClass* _tmp207_;
					ValaObjectType* _tmp208_;
					ValaObjectType* _tmp209_;
					ValaExpression* _tmp210_;
					ValaExpression* _tmp211_;
					ValaDataType* _tmp212_;
					ValaDataType* _tmp213_;
					ValaSourceReference* _tmp214_;
					ValaSourceReference* _tmp215_;
					ValaExpression* _tmp216_;
					ValaExpression* _tmp217_;
					ValaDataType* _tmp218_;
					ValaDataType* _tmp219_;
					ValaDataType* _tmp220_;
					_tmp192_ = cm;
					_tmp193_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp192_);
					_tmp194_ = _tmp193_;
					cl = VALA_IS_CLASS (_tmp194_) ? ((ValaClass*) _tmp194_) : NULL;
					_tmp196_ = cl;
					if (_tmp196_ == NULL) {
						_tmp195_ = TRUE;
					} else {
						ValaClass* _tmp197_;
						ValaSemanticAnalyzer* _tmp198_;
						ValaSemanticAnalyzer* _tmp199_;
						ValaClass* _tmp200_;
						_tmp197_ = cl;
						_tmp198_ = vala_code_context_get_analyzer (context);
						_tmp199_ = _tmp198_;
						_tmp200_ = _tmp199_->object_type;
						_tmp195_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp197_, (ValaTypeSymbol*) _tmp200_);
					}
					if (_tmp195_) {
						ValaSourceReference* _tmp201_;
						ValaSourceReference* _tmp202_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp201_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp202_ = _tmp201_;
						vala_report_error (_tmp202_, "chain up to `GLib.Object' not supported");
						result = FALSE;
						_vala_code_node_unref0 (mtype);
						_vala_iterable_unref0 (method_type_args);
						_vala_code_node_unref0 (target_object_type);
						return result;
					}
					_tmp203_ = vala_method_call_get_call (self);
					_tmp204_ = _tmp203_;
					_tmp205_ = vala_code_context_get_analyzer (context);
					_tmp206_ = _tmp205_;
					_tmp207_ = _tmp206_->object_type;
					_tmp208_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp207_);
					_tmp209_ = _tmp208_;
					vala_expression_set_value_type (_tmp204_, (ValaDataType*) _tmp209_);
					_vala_code_node_unref0 (_tmp209_);
					_tmp210_ = vala_method_call_get_call (self);
					_tmp211_ = _tmp210_;
					_tmp212_ = vala_expression_get_value_type (_tmp211_);
					_tmp213_ = _tmp212_;
					_tmp214_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp215_ = _tmp214_;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp213_, _tmp215_);
					_tmp216_ = vala_method_call_get_call (self);
					_tmp217_ = _tmp216_;
					_tmp218_ = vala_expression_get_value_type (_tmp217_);
					_tmp219_ = _tmp218_;
					_tmp220_ = _vala_code_node_ref0 (_tmp219_);
					_vala_code_node_unref0 (mtype);
					mtype = _tmp220_;
				}
			}
		}
	}
	_tmp222_ = vala_method_call_get_call (self);
	_tmp223_ = _tmp222_;
	if (VALA_IS_MEMBER_ACCESS (_tmp223_)) {
		gboolean _tmp224_ = FALSE;
		gboolean _tmp225_ = FALSE;
		ValaExpression* _tmp226_;
		ValaExpression* _tmp227_;
		ValaSymbol* _tmp228_;
		ValaSymbol* _tmp229_;
		_tmp226_ = vala_method_call_get_call (self);
		_tmp227_ = _tmp226_;
		_tmp228_ = vala_expression_get_symbol_reference (_tmp227_);
		_tmp229_ = _tmp228_;
		if (VALA_IS_CREATION_METHOD (_tmp229_)) {
			ValaExpression* _tmp230_;
			ValaExpression* _tmp231_;
			ValaSymbol* _tmp232_;
			ValaSymbol* _tmp233_;
			ValaSymbol* _tmp234_;
			ValaSymbol* _tmp235_;
			_tmp230_ = vala_method_call_get_call (self);
			_tmp231_ = _tmp230_;
			_tmp232_ = vala_expression_get_symbol_reference (_tmp231_);
			_tmp233_ = _tmp232_;
			_tmp234_ = vala_symbol_get_parent_symbol (_tmp233_);
			_tmp235_ = _tmp234_;
			_tmp225_ = VALA_IS_STRUCT (_tmp235_);
		} else {
			_tmp225_ = FALSE;
		}
		if (_tmp225_) {
			_tmp224_ = TRUE;
		} else {
			ValaExpression* _tmp236_;
			ValaExpression* _tmp237_;
			ValaSymbol* _tmp238_;
			ValaSymbol* _tmp239_;
			_tmp236_ = vala_method_call_get_call (self);
			_tmp237_ = _tmp236_;
			_tmp238_ = vala_expression_get_symbol_reference (_tmp237_);
			_tmp239_ = _tmp238_;
			_tmp224_ = VALA_IS_STRUCT (_tmp239_);
		}
		_tmp221_ = _tmp224_;
	} else {
		_tmp221_ = FALSE;
	}
	if (_tmp221_) {
		ValaStruct* st = NULL;
		ValaExpression* _tmp240_;
		ValaExpression* _tmp241_;
		ValaSymbol* _tmp242_;
		ValaSymbol* _tmp243_;
		gboolean _tmp244_ = FALSE;
		gboolean _tmp245_ = FALSE;
		ValaStruct* _tmp246_;
		ValaObjectCreationExpression* struct_creation_expression = NULL;
		ValaExpression* _tmp257_;
		ValaExpression* _tmp258_;
		ValaSourceReference* _tmp259_;
		ValaSourceReference* _tmp260_;
		ValaObjectCreationExpression* _tmp261_;
		ValaObjectCreationExpression* _tmp262_;
		ValaObjectCreationExpression* _tmp273_;
		ValaDataType* _tmp274_;
		ValaDataType* _tmp275_;
		ValaSemanticAnalyzer* _tmp276_;
		ValaSemanticAnalyzer* _tmp277_;
		ValaList* _tmp278_;
		ValaCodeNode* _tmp279_;
		ValaCodeNode* _tmp280_;
		ValaObjectCreationExpression* _tmp281_;
		ValaObjectCreationExpression* _tmp282_;
		_tmp240_ = vala_method_call_get_call (self);
		_tmp241_ = _tmp240_;
		_tmp242_ = vala_expression_get_symbol_reference (_tmp241_);
		_tmp243_ = _tmp242_;
		st = VALA_IS_STRUCT (_tmp243_) ? ((ValaStruct*) _tmp243_) : NULL;
		_tmp246_ = st;
		if (_tmp246_ != NULL) {
			ValaStruct* _tmp247_;
			ValaCreationMethod* _tmp248_;
			ValaCreationMethod* _tmp249_;
			_tmp247_ = st;
			_tmp248_ = vala_struct_get_default_construction_method (_tmp247_);
			_tmp249_ = _tmp248_;
			_tmp245_ = _tmp249_ == NULL;
		} else {
			_tmp245_ = FALSE;
		}
		if (_tmp245_) {
			gboolean _tmp250_ = FALSE;
			gboolean _tmp251_ = FALSE;
			ValaStruct* _tmp252_;
			_tmp252_ = st;
			if (vala_struct_is_boolean_type (_tmp252_)) {
				_tmp251_ = TRUE;
			} else {
				ValaStruct* _tmp253_;
				_tmp253_ = st;
				_tmp251_ = vala_struct_is_integer_type (_tmp253_);
			}
			if (_tmp251_) {
				_tmp250_ = TRUE;
			} else {
				ValaStruct* _tmp254_;
				_tmp254_ = st;
				_tmp250_ = vala_struct_is_floating_type (_tmp254_);
			}
			_tmp244_ = _tmp250_;
		} else {
			_tmp244_ = FALSE;
		}
		if (_tmp244_) {
			ValaSourceReference* _tmp255_;
			ValaSourceReference* _tmp256_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp255_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp256_ = _tmp255_;
			vala_report_error (_tmp256_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
		_tmp257_ = vala_method_call_get_call (self);
		_tmp258_ = _tmp257_;
		_tmp259_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp260_ = _tmp259_;
		_tmp261_ = vala_object_creation_expression_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp258_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess), _tmp260_);
		struct_creation_expression = _tmp261_;
		_tmp262_ = struct_creation_expression;
		vala_object_creation_expression_set_struct_creation (_tmp262_, TRUE);
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp263_;
			gint _arg_size = 0;
			ValaList* _tmp264_;
			gint _tmp265_;
			gint _tmp266_;
			gint _arg_index = 0;
			_tmp263_ = self->priv->argument_list;
			_arg_list = _tmp263_;
			_tmp264_ = _arg_list;
			_tmp265_ = vala_collection_get_size ((ValaCollection*) _tmp264_);
			_tmp266_ = _tmp265_;
			_arg_size = _tmp266_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp267_;
				gint _tmp268_;
				ValaExpression* arg = NULL;
				ValaList* _tmp269_;
				gpointer _tmp270_;
				ValaObjectCreationExpression* _tmp271_;
				ValaExpression* _tmp272_;
				_arg_index = _arg_index + 1;
				_tmp267_ = _arg_index;
				_tmp268_ = _arg_size;
				if (!(_tmp267_ < _tmp268_)) {
					break;
				}
				_tmp269_ = _arg_list;
				_tmp270_ = vala_list_get (_tmp269_, _arg_index);
				arg = (ValaExpression*) _tmp270_;
				_tmp271_ = struct_creation_expression;
				_tmp272_ = arg;
				vala_callable_expression_add_argument ((ValaCallableExpression*) _tmp271_, _tmp272_);
				_vala_code_node_unref0 (arg);
			}
		}
		_tmp273_ = struct_creation_expression;
		_tmp274_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp275_ = _tmp274_;
		vala_expression_set_target_type ((ValaExpression*) _tmp273_, _tmp275_);
		_tmp276_ = vala_code_context_get_analyzer (context);
		_tmp277_ = _tmp276_;
		_tmp278_ = _tmp277_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp278_, (ValaCodeNode*) self);
		_tmp279_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp280_ = _tmp279_;
		_tmp281_ = struct_creation_expression;
		vala_code_node_replace_expression (_tmp280_, (ValaExpression*) self, (ValaExpression*) _tmp281_);
		_tmp282_ = struct_creation_expression;
		vala_code_node_check ((ValaCodeNode*) _tmp282_, context);
		result = TRUE;
		_vala_code_node_unref0 (struct_creation_expression);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp283_ = FALSE;
		gboolean _tmp284_ = FALSE;
		gboolean _tmp285_;
		_tmp285_ = self->priv->_is_chainup;
		if (!_tmp285_) {
			ValaExpression* _tmp286_;
			ValaExpression* _tmp287_;
			_tmp286_ = vala_method_call_get_call (self);
			_tmp287_ = _tmp286_;
			_tmp284_ = VALA_IS_MEMBER_ACCESS (_tmp287_);
		} else {
			_tmp284_ = FALSE;
		}
		if (_tmp284_) {
			ValaExpression* _tmp288_;
			ValaExpression* _tmp289_;
			ValaSymbol* _tmp290_;
			ValaSymbol* _tmp291_;
			_tmp288_ = vala_method_call_get_call (self);
			_tmp289_ = _tmp288_;
			_tmp290_ = vala_expression_get_symbol_reference (_tmp289_);
			_tmp291_ = _tmp290_;
			_tmp283_ = VALA_IS_CREATION_METHOD (_tmp291_);
		} else {
			_tmp283_ = FALSE;
		}
		if (_tmp283_) {
			ValaSourceReference* _tmp292_;
			ValaSourceReference* _tmp293_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp292_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp293_ = _tmp292_;
			vala_report_error (_tmp293_, "use `new' operator to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp295_ = self->priv->_is_chainup;
	if (!_tmp295_) {
		ValaDataType* _tmp296_;
		_tmp296_ = mtype;
		_tmp294_ = VALA_IS_OBJECT_TYPE (_tmp296_);
	} else {
		_tmp294_ = FALSE;
	}
	if (_tmp294_) {
		ValaSourceReference* _tmp297_;
		ValaSourceReference* _tmp298_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp297_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp298_ = _tmp297_;
		vala_report_error (_tmp298_, "invocation not supported in this context");
		result = FALSE;
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp299_ = FALSE;
		ValaDataType* _tmp300_;
		_tmp300_ = mtype;
		if (_tmp300_ != NULL) {
			ValaDataType* _tmp301_;
			_tmp301_ = mtype;
			_tmp299_ = vala_data_type_is_invokable (_tmp301_);
		} else {
			_tmp299_ = FALSE;
		}
		if (_tmp299_) {
		} else {
			ValaExpression* _tmp302_;
			ValaExpression* _tmp303_;
			ValaSymbol* _tmp304_;
			ValaSymbol* _tmp305_;
			_tmp302_ = vala_method_call_get_call (self);
			_tmp303_ = _tmp302_;
			_tmp304_ = vala_expression_get_symbol_reference (_tmp303_);
			_tmp305_ = _tmp304_;
			if (VALA_IS_CLASS (_tmp305_)) {
				ValaSourceReference* _tmp306_;
				ValaSourceReference* _tmp307_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp306_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp307_ = _tmp306_;
				vala_report_error (_tmp307_, "use `new' operator to create new objects");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaSourceReference* _tmp308_;
				ValaSourceReference* _tmp309_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp308_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp309_ = _tmp308_;
				vala_report_error (_tmp309_, "invocation not supported in this context");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
	}
	_tmp310_ = mtype;
	_tmp311_ = vala_data_type_get_return_type (_tmp310_);
	_tmp312_ = _vala_code_node_ref0 (_tmp311_);
	ret_type = _tmp312_;
	_tmp313_ = mtype;
	_tmp314_ = vala_data_type_get_parameters (_tmp313_);
	_tmp315_ = _vala_iterable_ref0 (_tmp314_);
	params = _tmp315_;
	_tmp316_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp316_)) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp317_;
		ValaExpression* _tmp318_;
		ValaMethod* m = NULL;
		ValaDataType* _tmp319_;
		ValaMethod* _tmp320_;
		ValaMethod* _tmp321_;
		ValaMethod* _tmp322_;
		gboolean _tmp323_;
		gboolean _tmp324_;
		gint n_type_params = 0;
		ValaMethod* _tmp356_;
		ValaList* _tmp357_;
		gint _tmp358_;
		gint _tmp359_;
		gint n_type_args = 0;
		ValaMemberAccess* _tmp360_;
		ValaList* _tmp361_;
		gint _tmp362_;
		gint _tmp363_;
		gboolean _tmp364_ = FALSE;
		_tmp317_ = vala_method_call_get_call (self);
		_tmp318_ = _tmp317_;
		ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp318_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
		_tmp319_ = mtype;
		_tmp320_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp319_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp321_ = _tmp320_;
		m = _tmp321_;
		_tmp322_ = m;
		_tmp323_ = vala_method_get_coroutine (_tmp322_);
		_tmp324_ = _tmp323_;
		if (_tmp324_) {
			gboolean _tmp325_;
			gboolean _tmp326_;
			_tmp325_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
			_tmp326_ = _tmp325_;
			if (!_tmp326_) {
				ValaMemberAccess* _tmp327_;
				const gchar* _tmp328_;
				const gchar* _tmp329_;
				_tmp327_ = ma;
				_tmp328_ = vala_member_access_get_member_name (_tmp327_);
				_tmp329_ = _tmp328_;
				if (g_strcmp0 (_tmp329_, "end") != 0) {
					ValaMemberAccess* _tmp330_;
					const gchar* _tmp331_;
					const gchar* _tmp332_;
					ValaMethod* _tmp336_;
					ValaList* _tmp337_;
					ValaList* _tmp338_;
					ValaVoidType* _tmp339_;
					_tmp330_ = ma;
					_tmp331_ = vala_member_access_get_member_name (_tmp330_);
					_tmp332_ = _tmp331_;
					if (g_strcmp0 (_tmp332_, "begin") != 0) {
						ValaMemberAccess* _tmp333_;
						ValaSourceReference* _tmp334_;
						ValaSourceReference* _tmp335_;
						_tmp333_ = ma;
						_tmp334_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp333_);
						_tmp335_ = _tmp334_;
						vala_report_deprecated (_tmp335_, "implicit .begin is deprecated");
					}
					_tmp336_ = m;
					_tmp337_ = vala_method_get_async_begin_parameters (_tmp336_);
					_tmp338_ = _vala_iterable_ref0 (_tmp337_);
					_vala_iterable_unref0 (params);
					params = _tmp338_;
					_tmp339_ = vala_void_type_new (NULL);
					_vala_code_node_unref0 (ret_type);
					ret_type = (ValaDataType*) _tmp339_;
				} else {
					ValaMethod* _tmp340_;
					ValaList* _tmp341_;
					ValaList* _tmp342_;
					_tmp340_ = m;
					_tmp341_ = vala_method_get_async_end_parameters (_tmp340_);
					_tmp342_ = _vala_iterable_ref0 (_tmp341_);
					_vala_iterable_unref0 (params);
					params = _tmp342_;
				}
			} else {
				gboolean _tmp343_ = FALSE;
				ValaMemberAccess* _tmp344_;
				const gchar* _tmp345_;
				const gchar* _tmp346_;
				_tmp344_ = ma;
				_tmp345_ = vala_member_access_get_member_name (_tmp344_);
				_tmp346_ = _tmp345_;
				if (g_strcmp0 (_tmp346_, "begin") == 0) {
					_tmp343_ = TRUE;
				} else {
					ValaMemberAccess* _tmp347_;
					const gchar* _tmp348_;
					const gchar* _tmp349_;
					_tmp347_ = ma;
					_tmp348_ = vala_member_access_get_member_name (_tmp347_);
					_tmp349_ = _tmp348_;
					_tmp343_ = g_strcmp0 (_tmp349_, "end") == 0;
				}
				if (_tmp343_) {
					ValaMemberAccess* _tmp350_;
					ValaSourceReference* _tmp351_;
					ValaSourceReference* _tmp352_;
					ValaMemberAccess* _tmp353_;
					const gchar* _tmp354_;
					const gchar* _tmp355_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp350_ = ma;
					_tmp351_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp350_);
					_tmp352_ = _tmp351_;
					_tmp353_ = ma;
					_tmp354_ = vala_member_access_get_member_name (_tmp353_);
					_tmp355_ = _tmp354_;
					vala_report_error (_tmp352_, "use of `%s' not allowed in yield statement", _tmp355_);
				}
			}
		}
		_tmp356_ = m;
		_tmp357_ = vala_method_get_type_parameters (_tmp356_);
		_tmp358_ = vala_collection_get_size ((ValaCollection*) _tmp357_);
		_tmp359_ = _tmp358_;
		n_type_params = _tmp359_;
		_tmp360_ = ma;
		_tmp361_ = vala_member_access_get_type_arguments (_tmp360_);
		_tmp362_ = vala_collection_get_size ((ValaCollection*) _tmp361_);
		_tmp363_ = _tmp362_;
		n_type_args = _tmp363_;
		if (n_type_args > 0) {
			_tmp364_ = n_type_args < n_type_params;
		} else {
			_tmp364_ = FALSE;
		}
		if (_tmp364_) {
			ValaMemberAccess* _tmp365_;
			ValaSourceReference* _tmp366_;
			ValaSourceReference* _tmp367_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp365_ = ma;
			_tmp366_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp365_);
			_tmp367_ = _tmp366_;
			vala_report_error (_tmp367_, "too few type arguments");
			result = FALSE;
			_vala_iterable_unref0 (params);
			_vala_code_node_unref0 (ret_type);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		} else {
			gboolean _tmp368_ = FALSE;
			if (n_type_args > 0) {
				_tmp368_ = n_type_args > n_type_params;
			} else {
				_tmp368_ = FALSE;
			}
			if (_tmp368_) {
				ValaMemberAccess* _tmp369_;
				ValaSourceReference* _tmp370_;
				ValaSourceReference* _tmp371_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp369_ = ma;
				_tmp370_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp369_);
				_tmp371_ = _tmp370_;
				vala_report_error (_tmp371_, "too many type arguments");
				result = FALSE;
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
	}
	last_arg = NULL;
	_tmp372_ = self->priv->argument_list;
	_tmp373_ = vala_iterable_iterator ((ValaIterable*) _tmp372_);
	arg_it = _tmp373_;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp374_;
		gint _param_size = 0;
		ValaList* _tmp375_;
		gint _tmp376_;
		gint _tmp377_;
		gint _param_index = 0;
		_tmp374_ = params;
		_param_list = _tmp374_;
		_tmp375_ = _param_list;
		_tmp376_ = vala_collection_get_size ((ValaCollection*) _tmp375_);
		_tmp377_ = _tmp376_;
		_param_size = _tmp377_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp378_;
			gint _tmp379_;
			ValaParameter* param = NULL;
			ValaList* _tmp380_;
			gpointer _tmp381_;
			ValaParameter* _tmp382_;
			ValaParameter* _tmp383_;
			gboolean _tmp384_;
			gboolean _tmp385_;
			ValaParameter* _tmp386_;
			gboolean _tmp387_;
			gboolean _tmp388_;
			ValaIterator* _tmp406_;
			_param_index = _param_index + 1;
			_tmp378_ = _param_index;
			_tmp379_ = _param_size;
			if (!(_tmp378_ < _tmp379_)) {
				break;
			}
			_tmp380_ = _param_list;
			_tmp381_ = vala_list_get (_tmp380_, _param_index);
			param = (ValaParameter*) _tmp381_;
			_tmp382_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp382_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_tmp383_ = param;
			_tmp384_ = vala_parameter_get_ellipsis (_tmp383_);
			_tmp385_ = _tmp384_;
			if (_tmp385_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp386_ = param;
			_tmp387_ = vala_parameter_get_params_array (_tmp386_);
			_tmp388_ = _tmp387_;
			if (_tmp388_) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp389_;
				ValaDataType* _tmp390_;
				ValaDataType* _tmp391_;
				ValaArrayType* _tmp392_;
				_tmp389_ = param;
				_tmp390_ = vala_variable_get_variable_type ((ValaVariable*) _tmp389_);
				_tmp391_ = _tmp390_;
				_tmp392_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp391_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp392_;
				while (TRUE) {
					ValaIterator* _tmp393_;
					ValaExpression* arg = NULL;
					ValaIterator* _tmp394_;
					gpointer _tmp395_;
					ValaExpression* _tmp396_;
					ValaArrayType* _tmp397_;
					ValaDataType* _tmp398_;
					ValaDataType* _tmp399_;
					ValaExpression* _tmp400_;
					ValaDataType* _tmp401_;
					ValaDataType* _tmp402_;
					ValaArrayType* _tmp403_;
					gboolean _tmp404_;
					gboolean _tmp405_;
					_tmp393_ = arg_it;
					if (!vala_iterator_next (_tmp393_)) {
						break;
					}
					_tmp394_ = arg_it;
					_tmp395_ = vala_iterator_get (_tmp394_);
					arg = (ValaExpression*) _tmp395_;
					_tmp396_ = arg;
					_tmp397_ = array_type;
					_tmp398_ = vala_array_type_get_element_type (_tmp397_);
					_tmp399_ = _tmp398_;
					vala_expression_set_target_type (_tmp396_, _tmp399_);
					_tmp400_ = arg;
					_tmp401_ = vala_expression_get_target_type (_tmp400_);
					_tmp402_ = _tmp401_;
					_tmp403_ = array_type;
					_tmp404_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp403_);
					_tmp405_ = _tmp404_;
					vala_data_type_set_value_owned (_tmp402_, _tmp405_);
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (array_type);
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp406_ = arg_it;
			if (vala_iterator_next (_tmp406_)) {
				ValaExpression* arg = NULL;
				ValaIterator* _tmp407_;
				gpointer _tmp408_;
				ValaExpression* _tmp409_;
				ValaParameter* _tmp410_;
				ValaDataType* _tmp411_;
				ValaDataType* _tmp412_;
				ValaExpression* _tmp413_;
				ValaExpression* _tmp414_;
				ValaDataType* _tmp415_;
				ValaDataType* _tmp416_;
				ValaDataType* _tmp417_;
				ValaList* _tmp418_;
				ValaDataType* _tmp419_;
				ValaDataType* _tmp420_;
				ValaExpression* _tmp421_;
				ValaExpression* _tmp422_;
				_tmp407_ = arg_it;
				_tmp408_ = vala_iterator_get (_tmp407_);
				arg = (ValaExpression*) _tmp408_;
				_tmp409_ = arg;
				_tmp410_ = param;
				_tmp411_ = vala_variable_get_variable_type ((ValaVariable*) _tmp410_);
				_tmp412_ = _tmp411_;
				vala_expression_set_formal_target_type (_tmp409_, _tmp412_);
				_tmp413_ = arg;
				_tmp414_ = arg;
				_tmp415_ = vala_expression_get_formal_target_type (_tmp414_);
				_tmp416_ = _tmp415_;
				_tmp417_ = target_object_type;
				_tmp418_ = method_type_args;
				_tmp419_ = vala_data_type_get_actual_type (_tmp416_, _tmp417_, _tmp418_, (ValaCodeNode*) self);
				_tmp420_ = _tmp419_;
				vala_expression_set_target_type (_tmp413_, _tmp420_);
				_vala_code_node_unref0 (_tmp420_);
				_tmp421_ = arg;
				_tmp422_ = _vala_code_node_ref0 (_tmp421_);
				_vala_code_node_unref0 (last_arg);
				last_arg = _tmp422_;
				_vala_code_node_unref0 (arg);
			}
			_vala_code_node_unref0 (param);
		}
	}
	_tmp424_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp424_)) {
		ValaDataType* _tmp425_;
		ValaMethod* _tmp426_;
		ValaMethod* _tmp427_;
		ValaAttribute* _tmp428_;
		_tmp425_ = mtype;
		_tmp426_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp425_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp427_ = _tmp426_;
		_tmp428_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp427_, "Print");
		_tmp423_ = _tmp428_ != NULL;
	} else {
		_tmp423_ = FALSE;
	}
	if (_tmp423_) {
		ValaTemplate* template = NULL;
		ValaSourceReference* _tmp429_;
		ValaSourceReference* _tmp430_;
		ValaTemplate* _tmp431_;
		ValaList* _tmp443_;
		ValaTemplate* _tmp444_;
		_tmp429_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp430_ = _tmp429_;
		_tmp431_ = vala_template_new (_tmp430_);
		template = _tmp431_;
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp432_;
			gint _arg_size = 0;
			ValaList* _tmp433_;
			gint _tmp434_;
			gint _tmp435_;
			gint _arg_index = 0;
			_tmp432_ = self->priv->argument_list;
			_arg_list = _tmp432_;
			_tmp433_ = _arg_list;
			_tmp434_ = vala_collection_get_size ((ValaCollection*) _tmp433_);
			_tmp435_ = _tmp434_;
			_arg_size = _tmp435_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp436_;
				gint _tmp437_;
				ValaExpression* arg = NULL;
				ValaList* _tmp438_;
				gpointer _tmp439_;
				ValaExpression* _tmp440_;
				ValaTemplate* _tmp441_;
				ValaExpression* _tmp442_;
				_arg_index = _arg_index + 1;
				_tmp436_ = _arg_index;
				_tmp437_ = _arg_size;
				if (!(_tmp436_ < _tmp437_)) {
					break;
				}
				_tmp438_ = _arg_list;
				_tmp439_ = vala_list_get (_tmp438_, _arg_index);
				arg = (ValaExpression*) _tmp439_;
				_tmp440_ = arg;
				vala_code_node_set_parent_node ((ValaCodeNode*) _tmp440_, NULL);
				_tmp441_ = template;
				_tmp442_ = arg;
				vala_template_add_expression (_tmp441_, _tmp442_);
				_vala_code_node_unref0 (arg);
			}
		}
		_tmp443_ = self->priv->argument_list;
		vala_collection_clear ((ValaCollection*) _tmp443_);
		_tmp444_ = template;
		vala_callable_expression_add_argument ((ValaCallableExpression*) self, (ValaExpression*) _tmp444_);
		_vala_code_node_unref0 (template);
	}
	_tmp446_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp446_)) {
		ValaDataType* _tmp447_;
		ValaMethod* _tmp448_;
		ValaMethod* _tmp449_;
		gboolean _tmp450_;
		gboolean _tmp451_;
		_tmp447_ = mtype;
		_tmp448_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp447_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp449_ = _tmp448_;
		_tmp450_ = vala_method_get_printf_format (_tmp449_);
		_tmp451_ = _tmp450_;
		_tmp445_ = _tmp451_;
	} else {
		_tmp445_ = FALSE;
	}
	if (_tmp445_) {
		ValaStringLiteral* format_literal = NULL;
		ValaExpression* _tmp452_;
		ValaStringLiteral* _tmp501_;
		format_literal = NULL;
		_tmp452_ = last_arg;
		if (VALA_IS_NULL_LITERAL (_tmp452_)) {
		} else {
			ValaExpression* _tmp453_;
			_tmp453_ = last_arg;
			if (_tmp453_ != NULL) {
				ValaExpression* _tmp454_;
				ValaStringLiteral* _tmp455_;
				gboolean _tmp456_ = FALSE;
				ValaStringLiteral* _tmp457_;
				_tmp454_ = last_arg;
				_tmp455_ = vala_string_literal_get_format_literal (_tmp454_);
				_vala_code_node_unref0 (format_literal);
				format_literal = _tmp455_;
				_tmp457_ = format_literal;
				if (_tmp457_ == NULL) {
					ValaList* _tmp458_;
					gint _tmp459_;
					gint _tmp460_;
					ValaList* _tmp461_;
					gint _tmp462_;
					gint _tmp463_;
					_tmp458_ = self->priv->argument_list;
					_tmp459_ = vala_collection_get_size ((ValaCollection*) _tmp458_);
					_tmp460_ = _tmp459_;
					_tmp461_ = params;
					_tmp462_ = vala_collection_get_size ((ValaCollection*) _tmp461_);
					_tmp463_ = _tmp462_;
					_tmp456_ = _tmp460_ == (_tmp463_ - 1);
				} else {
					_tmp456_ = FALSE;
				}
				if (_tmp456_) {
					ValaStringLiteral* _tmp464_;
					ValaStringLiteral* _tmp465_;
					ValaSemanticAnalyzer* _tmp466_;
					ValaSemanticAnalyzer* _tmp467_;
					ValaDataType* _tmp468_;
					ValaDataType* _tmp469_;
					ValaDataType* _tmp470_;
					ValaList* _tmp471_;
					ValaList* _tmp472_;
					gint _tmp473_;
					gint _tmp474_;
					ValaStringLiteral* _tmp475_;
					ValaList* _tmp476_;
					ValaIterator* _tmp477_;
					_tmp464_ = vala_string_literal_new ("\"%s\"", NULL);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp464_;
					_tmp465_ = format_literal;
					_tmp466_ = vala_code_context_get_analyzer (context);
					_tmp467_ = _tmp466_;
					_tmp468_ = _tmp467_->string_type;
					_tmp469_ = vala_data_type_copy (_tmp468_);
					_tmp470_ = _tmp469_;
					vala_expression_set_target_type ((ValaExpression*) _tmp465_, _tmp470_);
					_vala_code_node_unref0 (_tmp470_);
					_tmp471_ = self->priv->argument_list;
					_tmp472_ = self->priv->argument_list;
					_tmp473_ = vala_collection_get_size ((ValaCollection*) _tmp472_);
					_tmp474_ = _tmp473_;
					_tmp475_ = format_literal;
					vala_list_insert (_tmp471_, _tmp474_ - 1, (ValaExpression*) _tmp475_);
					_tmp476_ = self->priv->argument_list;
					_tmp477_ = vala_iterable_iterator ((ValaIterable*) _tmp476_);
					_vala_iterator_unref0 (arg_it);
					arg_it = _tmp477_;
					{
						ValaList* _param_list = NULL;
						ValaList* _tmp478_;
						gint _param_size = 0;
						ValaList* _tmp479_;
						gint _tmp480_;
						gint _tmp481_;
						gint _param_index = 0;
						_tmp478_ = params;
						_param_list = _tmp478_;
						_tmp479_ = _param_list;
						_tmp480_ = vala_collection_get_size ((ValaCollection*) _tmp479_);
						_tmp481_ = _tmp480_;
						_param_size = _tmp481_;
						_param_index = -1;
						while (TRUE) {
							gint _tmp482_;
							gint _tmp483_;
							ValaParameter* param = NULL;
							ValaList* _tmp484_;
							gpointer _tmp485_;
							gboolean _tmp486_ = FALSE;
							ValaParameter* _tmp487_;
							gboolean _tmp488_;
							gboolean _tmp489_;
							ValaIterator* _tmp493_;
							_param_index = _param_index + 1;
							_tmp482_ = _param_index;
							_tmp483_ = _param_size;
							if (!(_tmp482_ < _tmp483_)) {
								break;
							}
							_tmp484_ = _param_list;
							_tmp485_ = vala_list_get (_tmp484_, _param_index);
							param = (ValaParameter*) _tmp485_;
							_tmp487_ = param;
							_tmp488_ = vala_parameter_get_ellipsis (_tmp487_);
							_tmp489_ = _tmp488_;
							if (_tmp489_) {
								_tmp486_ = TRUE;
							} else {
								ValaParameter* _tmp490_;
								gboolean _tmp491_;
								gboolean _tmp492_;
								_tmp490_ = param;
								_tmp491_ = vala_parameter_get_params_array (_tmp490_);
								_tmp492_ = _tmp491_;
								_tmp486_ = _tmp492_;
							}
							if (_tmp486_) {
								_vala_code_node_unref0 (param);
								break;
							}
							_tmp493_ = arg_it;
							vala_iterator_next (_tmp493_);
							_vala_code_node_unref0 (param);
						}
					}
				}
			} else {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp494_;
				ValaExpression* _tmp495_;
				ValaMemberAccess* _tmp496_;
				_tmp494_ = vala_method_call_get_call (self);
				_tmp495_ = _tmp494_;
				ma = VALA_IS_MEMBER_ACCESS (_tmp495_) ? ((ValaMemberAccess*) _tmp495_) : NULL;
				_tmp496_ = ma;
				if (_tmp496_ != NULL) {
					ValaMemberAccess* _tmp497_;
					ValaExpression* _tmp498_;
					ValaExpression* _tmp499_;
					ValaStringLiteral* _tmp500_;
					_tmp497_ = ma;
					_tmp498_ = vala_member_access_get_inner (_tmp497_);
					_tmp499_ = _tmp498_;
					_tmp500_ = vala_string_literal_get_format_literal (_tmp499_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp500_;
				}
			}
		}
		_tmp501_ = format_literal;
		if (_tmp501_ != NULL) {
			gchar* format = NULL;
			ValaStringLiteral* _tmp502_;
			gchar* _tmp503_;
			ValaSemanticAnalyzer* _tmp504_;
			ValaSemanticAnalyzer* _tmp505_;
			const gchar* _tmp506_;
			ValaIterator* _tmp507_;
			ValaSourceReference* _tmp508_;
			ValaSourceReference* _tmp509_;
			_tmp502_ = format_literal;
			_tmp503_ = vala_string_literal_eval (_tmp502_);
			format = _tmp503_;
			_tmp504_ = vala_code_context_get_analyzer (context);
			_tmp505_ = _tmp504_;
			_tmp506_ = format;
			_tmp507_ = arg_it;
			_tmp508_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp509_ = _tmp508_;
			if (!vala_semantic_analyzer_check_print_format (_tmp505_, _tmp506_, _tmp507_, _tmp509_)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_g_free0 (format);
				_vala_code_node_unref0 (format_literal);
				_vala_iterator_unref0 (arg_it);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_g_free0 (format);
		}
		_vala_code_node_unref0 (format_literal);
	}
	force_lambda_method_closure = FALSE;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp510_;
		gint _arg_size = 0;
		ValaList* _tmp511_;
		gint _tmp512_;
		gint _tmp513_;
		gint _arg_index = 0;
		_tmp510_ = self->priv->argument_list;
		_arg_list = _tmp510_;
		_tmp511_ = _arg_list;
		_tmp512_ = vala_collection_get_size ((ValaCollection*) _tmp511_);
		_tmp513_ = _tmp512_;
		_arg_size = _tmp513_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp514_;
			gint _tmp515_;
			ValaExpression* arg = NULL;
			ValaList* _tmp516_;
			gpointer _tmp517_;
			ValaExpression* _tmp518_;
			gboolean _tmp519_ = FALSE;
			ValaExpression* _tmp520_;
			_arg_index = _arg_index + 1;
			_tmp514_ = _arg_index;
			_tmp515_ = _arg_size;
			if (!(_tmp514_ < _tmp515_)) {
				break;
			}
			_tmp516_ = _arg_list;
			_tmp517_ = vala_list_get (_tmp516_, _arg_index);
			arg = (ValaExpression*) _tmp517_;
			_tmp518_ = arg;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp518_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp520_ = arg;
			if (VALA_IS_LAMBDA_EXPRESSION (_tmp520_)) {
				ValaExpression* _tmp521_;
				ValaMethod* _tmp522_;
				ValaMethod* _tmp523_;
				gboolean _tmp524_;
				gboolean _tmp525_;
				_tmp521_ = arg;
				_tmp522_ = vala_lambda_expression_get_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp521_, VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpression));
				_tmp523_ = _tmp522_;
				_tmp524_ = vala_method_get_closure (_tmp523_);
				_tmp525_ = _tmp524_;
				_tmp519_ = _tmp525_;
			} else {
				_tmp519_ = FALSE;
			}
			if (_tmp519_) {
				force_lambda_method_closure = TRUE;
			}
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp527_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp528_ = _tmp527_;
	if (!_tmp528_) {
		_tmp526_ = force_lambda_method_closure;
	} else {
		_tmp526_ = FALSE;
	}
	if (_tmp526_) {
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp529_;
			gint _arg_size = 0;
			ValaList* _tmp530_;
			gint _tmp531_;
			gint _tmp532_;
			gint _arg_index = 0;
			_tmp529_ = self->priv->argument_list;
			_arg_list = _tmp529_;
			_tmp530_ = _arg_list;
			_tmp531_ = vala_collection_get_size ((ValaCollection*) _tmp530_);
			_tmp532_ = _tmp531_;
			_arg_size = _tmp532_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp533_;
				gint _tmp534_;
				ValaExpression* arg = NULL;
				ValaList* _tmp535_;
				gpointer _tmp536_;
				ValaLambdaExpression* lambda = NULL;
				ValaExpression* _tmp537_;
				gboolean _tmp538_ = FALSE;
				ValaLambdaExpression* _tmp539_;
				_arg_index = _arg_index + 1;
				_tmp533_ = _arg_index;
				_tmp534_ = _arg_size;
				if (!(_tmp533_ < _tmp534_)) {
					break;
				}
				_tmp535_ = _arg_list;
				_tmp536_ = vala_list_get (_tmp535_, _arg_index);
				arg = (ValaExpression*) _tmp536_;
				_tmp537_ = arg;
				lambda = VALA_IS_LAMBDA_EXPRESSION (_tmp537_) ? ((ValaLambdaExpression*) _tmp537_) : NULL;
				_tmp539_ = lambda;
				if (_tmp539_ != NULL) {
					ValaLambdaExpression* _tmp540_;
					ValaMethod* _tmp541_;
					ValaMethod* _tmp542_;
					ValaMemberBinding _tmp543_;
					ValaMemberBinding _tmp544_;
					_tmp540_ = lambda;
					_tmp541_ = vala_lambda_expression_get_method (_tmp540_);
					_tmp542_ = _tmp541_;
					_tmp543_ = vala_method_get_binding (_tmp542_);
					_tmp544_ = _tmp543_;
					_tmp538_ = _tmp544_ != VALA_MEMBER_BINDING_STATIC;
				} else {
					_tmp538_ = FALSE;
				}
				if (_tmp538_) {
					ValaLambdaExpression* _tmp545_;
					ValaMethod* _tmp546_;
					ValaMethod* _tmp547_;
					_tmp545_ = lambda;
					_tmp546_ = vala_lambda_expression_get_method (_tmp545_);
					_tmp547_ = _tmp546_;
					vala_method_set_closure (_tmp547_, TRUE);
				}
				_vala_code_node_unref0 (arg);
			}
		}
	}
	_tmp548_ = ret_type;
	if (VALA_IS_VOID_TYPE (_tmp548_)) {
		gboolean _tmp549_ = FALSE;
		gboolean _tmp550_ = FALSE;
		ValaCodeNode* _tmp551_;
		ValaCodeNode* _tmp552_;
		_tmp551_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp552_ = _tmp551_;
		if (!VALA_IS_EXPRESSION_STATEMENT (_tmp552_)) {
			ValaCodeNode* _tmp553_;
			ValaCodeNode* _tmp554_;
			_tmp553_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp554_ = _tmp553_;
			_tmp550_ = !VALA_IS_FOR_STATEMENT (_tmp554_);
		} else {
			_tmp550_ = FALSE;
		}
		if (_tmp550_) {
			ValaCodeNode* _tmp555_;
			ValaCodeNode* _tmp556_;
			_tmp555_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp556_ = _tmp555_;
			_tmp549_ = !VALA_IS_YIELD_STATEMENT (_tmp556_);
		} else {
			_tmp549_ = FALSE;
		}
		if (_tmp549_) {
			ValaSourceReference* _tmp557_;
			ValaSourceReference* _tmp558_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp557_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp558_ = _tmp557_;
			vala_report_error (_tmp558_, "invocation of void method not allowed as expression");
			result = FALSE;
			_vala_iterator_unref0 (arg_it);
			_vala_code_node_unref0 (last_arg);
			_vala_iterable_unref0 (params);
			_vala_code_node_unref0 (ret_type);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp559_ = ret_type;
	_tmp560_ = vala_data_type_copy (_tmp559_);
	_tmp561_ = _tmp560_;
	vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp561_);
	_vala_code_node_unref0 (_tmp561_);
	_tmp562_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
	_tmp563_ = _tmp562_;
	_tmp564_ = target_object_type;
	_tmp565_ = method_type_args;
	_tmp566_ = vala_data_type_get_actual_type (_tmp563_, _tmp564_, _tmp565_, (ValaCodeNode*) self);
	_tmp567_ = _tmp566_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp567_);
	_vala_code_node_unref0 (_tmp567_);
	_tmp568_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
	_tmp569_ = _tmp568_;
	if (_tmp569_) {
		gboolean _tmp570_ = FALSE;
		ValaDataType* _tmp571_;
		gboolean _tmp579_ = FALSE;
		ValaSemanticAnalyzer* _tmp580_;
		ValaSemanticAnalyzer* _tmp581_;
		ValaMethod* _tmp582_;
		ValaMethod* _tmp583_;
		_tmp571_ = mtype;
		if (!VALA_IS_METHOD_TYPE (_tmp571_)) {
			_tmp570_ = TRUE;
		} else {
			ValaDataType* _tmp572_;
			ValaMethod* _tmp573_;
			ValaMethod* _tmp574_;
			gboolean _tmp575_;
			gboolean _tmp576_;
			_tmp572_ = mtype;
			_tmp573_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp572_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
			_tmp574_ = _tmp573_;
			_tmp575_ = vala_method_get_coroutine (_tmp574_);
			_tmp576_ = _tmp575_;
			_tmp570_ = !_tmp576_;
		}
		if (_tmp570_) {
			ValaSourceReference* _tmp577_;
			ValaSourceReference* _tmp578_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp577_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp578_ = _tmp577_;
			vala_report_error (_tmp578_, "yield expression requires async method");
		}
		_tmp580_ = vala_code_context_get_analyzer (context);
		_tmp581_ = _tmp580_;
		_tmp582_ = vala_semantic_analyzer_get_current_method (_tmp581_);
		_tmp583_ = _tmp582_;
		if (_tmp583_ == NULL) {
			_tmp579_ = TRUE;
		} else {
			ValaSemanticAnalyzer* _tmp584_;
			ValaSemanticAnalyzer* _tmp585_;
			ValaMethod* _tmp586_;
			ValaMethod* _tmp587_;
			gboolean _tmp588_;
			gboolean _tmp589_;
			_tmp584_ = vala_code_context_get_analyzer (context);
			_tmp585_ = _tmp584_;
			_tmp586_ = vala_semantic_analyzer_get_current_method (_tmp585_);
			_tmp587_ = _tmp586_;
			_tmp588_ = vala_method_get_coroutine (_tmp587_);
			_tmp589_ = _tmp588_;
			_tmp579_ = !_tmp589_;
		}
		if (_tmp579_) {
			ValaSourceReference* _tmp590_;
			ValaSourceReference* _tmp591_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp590_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp591_ = _tmp590_;
			vala_report_error (_tmp591_, "yield expression not available outside async method");
		}
	}
	_tmp592_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp592_)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp593_;
		ValaMethod* _tmp594_;
		ValaMethod* _tmp595_;
		ValaMethod* _tmp596_;
		gboolean _tmp597_;
		gboolean _tmp598_;
		ValaMethod* _tmp601_;
		gboolean _tmp602_;
		gboolean _tmp603_;
		gboolean _tmp629_ = FALSE;
		gboolean _tmp630_ = FALSE;
		gboolean _tmp631_ = FALSE;
		gboolean _tmp632_;
		gboolean _tmp633_;
		ValaSignal* sig = NULL;
		ValaMethod* _tmp645_;
		ValaSymbol* _tmp646_;
		ValaSymbol* _tmp647_;
		gboolean _tmp648_ = FALSE;
		ValaSignal* _tmp649_;
		ValaDynamicSignal* dynamic_sig = NULL;
		ValaMethod* _tmp662_;
		ValaSymbol* _tmp663_;
		ValaSymbol* _tmp664_;
		gboolean _tmp665_ = FALSE;
		ValaDynamicSignal* _tmp666_;
		gboolean _tmp716_ = FALSE;
		ValaMethod* _tmp717_;
		gboolean _tmp825_ = FALSE;
		ValaMethod* _tmp826_;
		_tmp593_ = mtype;
		_tmp594_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp593_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp595_ = _tmp594_;
		m = _tmp595_;
		_tmp596_ = m;
		_tmp597_ = vala_method_get_returns_floating_reference (_tmp596_);
		_tmp598_ = _tmp597_;
		if (_tmp598_) {
			ValaDataType* _tmp599_;
			ValaDataType* _tmp600_;
			_tmp599_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp600_ = _tmp599_;
			vala_data_type_set_floating_reference (_tmp600_, TRUE);
		}
		_tmp601_ = m;
		_tmp602_ = vala_method_get_returns_modified_pointer (_tmp601_);
		_tmp603_ = _tmp602_;
		if (_tmp603_) {
			ValaExpression* inner = NULL;
			ValaExpression* _tmp604_;
			ValaExpression* _tmp605_;
			ValaExpression* _tmp606_;
			ValaExpression* _tmp607_;
			ValaExpression* _tmp608_;
			ValaProperty* prop = NULL;
			ValaExpression* _tmp609_;
			ValaSymbol* _tmp610_;
			ValaSymbol* _tmp611_;
			gboolean _tmp612_ = FALSE;
			ValaProperty* _tmp613_;
			_tmp604_ = vala_method_call_get_call (self);
			_tmp605_ = _tmp604_;
			_tmp606_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp605_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp607_ = _tmp606_;
			inner = _tmp607_;
			_tmp608_ = inner;
			vala_expression_set_lvalue (_tmp608_, TRUE);
			_tmp609_ = inner;
			_tmp610_ = vala_expression_get_symbol_reference (_tmp609_);
			_tmp611_ = _tmp610_;
			prop = VALA_IS_PROPERTY (_tmp611_) ? ((ValaProperty*) _tmp611_) : NULL;
			_tmp613_ = prop;
			if (_tmp613_ != NULL) {
				gboolean _tmp614_ = FALSE;
				ValaProperty* _tmp615_;
				ValaPropertyAccessor* _tmp616_;
				ValaPropertyAccessor* _tmp617_;
				_tmp615_ = prop;
				_tmp616_ = vala_property_get_set_accessor (_tmp615_);
				_tmp617_ = _tmp616_;
				if (_tmp617_ == NULL) {
					_tmp614_ = TRUE;
				} else {
					ValaProperty* _tmp618_;
					ValaPropertyAccessor* _tmp619_;
					ValaPropertyAccessor* _tmp620_;
					gboolean _tmp621_;
					gboolean _tmp622_;
					_tmp618_ = prop;
					_tmp619_ = vala_property_get_set_accessor (_tmp618_);
					_tmp620_ = _tmp619_;
					_tmp621_ = vala_property_accessor_get_writable (_tmp620_);
					_tmp622_ = _tmp621_;
					_tmp614_ = !_tmp622_;
				}
				_tmp612_ = _tmp614_;
			} else {
				_tmp612_ = FALSE;
			}
			if (_tmp612_) {
				ValaExpression* _tmp623_;
				ValaSourceReference* _tmp624_;
				ValaSourceReference* _tmp625_;
				ValaProperty* _tmp626_;
				gchar* _tmp627_;
				gchar* _tmp628_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp623_ = inner;
				_tmp624_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp623_);
				_tmp625_ = _tmp624_;
				_tmp626_ = prop;
				_tmp627_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp626_);
				_tmp628_ = _tmp627_;
				vala_report_error (_tmp625_, "Property `%s' is read-only", _tmp628_);
				_g_free0 (_tmp628_);
			}
		}
		_tmp632_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
		_tmp633_ = _tmp632_;
		if (_tmp633_) {
			ValaDataType* _tmp634_;
			ValaDataType* _tmp635_;
			gboolean _tmp636_;
			gboolean _tmp637_;
			_tmp634_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp635_ = _tmp634_;
			_tmp636_ = vala_data_type_get_nullable (_tmp635_);
			_tmp637_ = _tmp636_;
			_tmp631_ = !_tmp637_;
		} else {
			_tmp631_ = FALSE;
		}
		if (_tmp631_) {
			ValaDataType* _tmp638_;
			ValaDataType* _tmp639_;
			gboolean _tmp640_;
			gboolean _tmp641_;
			_tmp638_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp639_ = _tmp638_;
			_tmp640_ = vala_data_type_get_floating_reference (_tmp639_);
			_tmp641_ = _tmp640_;
			_tmp630_ = _tmp641_;
		} else {
			_tmp630_ = FALSE;
		}
		if (_tmp630_) {
			ValaDataType* _tmp642_;
			_tmp642_ = ret_type;
			_tmp629_ = VALA_IS_OBJECT_TYPE (_tmp642_);
		} else {
			_tmp629_ = FALSE;
		}
		if (_tmp629_) {
			ValaDataType* _tmp643_;
			ValaDataType* _tmp644_;
			_tmp643_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp644_ = _tmp643_;
			vala_data_type_set_nullable (_tmp644_, TRUE);
		}
		_tmp645_ = m;
		_tmp646_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp645_);
		_tmp647_ = _tmp646_;
		sig = VALA_IS_SIGNAL (_tmp647_) ? ((ValaSignal*) _tmp647_) : NULL;
		_tmp649_ = sig;
		if (_tmp649_ != NULL) {
			ValaMethod* _tmp650_;
			const gchar* _tmp651_;
			const gchar* _tmp652_;
			_tmp650_ = m;
			_tmp651_ = vala_symbol_get_name ((ValaSymbol*) _tmp650_);
			_tmp652_ = _tmp651_;
			_tmp648_ = g_strcmp0 (_tmp652_, "disconnect") == 0;
		} else {
			_tmp648_ = FALSE;
		}
		if (_tmp648_) {
			gboolean _tmp653_ = FALSE;
			ValaList* _tmp654_;
			gboolean _tmp655_;
			gboolean _tmp656_;
			_tmp654_ = self->priv->argument_list;
			_tmp655_ = vala_collection_get_is_empty ((ValaCollection*) _tmp654_);
			_tmp656_ = _tmp655_;
			if (!_tmp656_) {
				ValaList* _tmp657_;
				gpointer _tmp658_;
				ValaExpression* _tmp659_;
				_tmp657_ = self->priv->argument_list;
				_tmp658_ = vala_list_get (_tmp657_, 0);
				_tmp659_ = (ValaExpression*) _tmp658_;
				_tmp653_ = VALA_IS_LAMBDA_EXPRESSION (_tmp659_);
				_vala_code_node_unref0 (_tmp659_);
			} else {
				_tmp653_ = FALSE;
			}
			if (_tmp653_) {
				ValaSourceReference* _tmp660_;
				ValaSourceReference* _tmp661_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp660_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp661_ = _tmp660_;
				vala_report_error (_tmp661_, "Cannot disconnect lambda expression from signal");
				result = FALSE;
				_vala_iterator_unref0 (arg_it);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
		_tmp662_ = m;
		_tmp663_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp662_);
		_tmp664_ = _tmp663_;
		dynamic_sig = VALA_IS_DYNAMIC_SIGNAL (_tmp664_) ? ((ValaDynamicSignal*) _tmp664_) : NULL;
		_tmp666_ = dynamic_sig;
		if (_tmp666_ != NULL) {
			ValaDynamicSignal* _tmp667_;
			ValaExpression* _tmp668_;
			ValaExpression* _tmp669_;
			_tmp667_ = dynamic_sig;
			_tmp668_ = vala_dynamic_signal_get_handler (_tmp667_);
			_tmp669_ = _tmp668_;
			_tmp665_ = _tmp669_ != NULL;
		} else {
			_tmp665_ = FALSE;
		}
		if (_tmp665_) {
			ValaDynamicSignal* _tmp670_;
			ValaDynamicSignal* _tmp671_;
			ValaExpression* _tmp672_;
			ValaExpression* _tmp673_;
			ValaDataType* _tmp674_;
			ValaDataType* _tmp675_;
			ValaDataType* _tmp676_;
			ValaDataType* _tmp677_;
			ValaDataType* _tmp678_;
			gboolean first = FALSE;
			ValaDynamicSignal* _tmp696_;
			ValaExpression* _tmp697_;
			ValaExpression* _tmp698_;
			ValaDynamicSignal* _tmp699_;
			ValaDynamicSignal* _tmp700_;
			ValaSymbol* _tmp701_;
			ValaSymbol* _tmp702_;
			ValaObjectType* _tmp703_;
			ValaObjectType* _tmp704_;
			ValaDelegate* _tmp705_;
			ValaDelegate* _tmp706_;
			ValaDelegateType* _tmp707_;
			ValaDelegateType* _tmp708_;
			ValaDynamicSignal* _tmp709_;
			ValaExpression* _tmp710_;
			ValaExpression* _tmp711_;
			ValaDataType* _tmp712_;
			ValaDataType* _tmp713_;
			ValaSourceReference* _tmp714_;
			ValaSourceReference* _tmp715_;
			_tmp670_ = dynamic_sig;
			_tmp671_ = dynamic_sig;
			_tmp672_ = vala_dynamic_signal_get_handler (_tmp671_);
			_tmp673_ = _tmp672_;
			_tmp674_ = vala_expression_get_value_type (_tmp673_);
			_tmp675_ = _tmp674_;
			_tmp676_ = vala_data_type_get_return_type (_tmp675_);
			_tmp677_ = vala_data_type_copy (_tmp676_);
			_tmp678_ = _tmp677_;
			vala_callable_set_return_type ((ValaCallable*) _tmp670_, _tmp678_);
			_vala_code_node_unref0 (_tmp678_);
			first = TRUE;
			{
				ValaList* _param_list = NULL;
				ValaDynamicSignal* _tmp679_;
				ValaExpression* _tmp680_;
				ValaExpression* _tmp681_;
				ValaDataType* _tmp682_;
				ValaDataType* _tmp683_;
				ValaList* _tmp684_;
				gint _param_size = 0;
				ValaList* _tmp685_;
				gint _tmp686_;
				gint _tmp687_;
				gint _param_index = 0;
				_tmp679_ = dynamic_sig;
				_tmp680_ = vala_dynamic_signal_get_handler (_tmp679_);
				_tmp681_ = _tmp680_;
				_tmp682_ = vala_expression_get_value_type (_tmp681_);
				_tmp683_ = _tmp682_;
				_tmp684_ = vala_data_type_get_parameters (_tmp683_);
				_param_list = _tmp684_;
				_tmp685_ = _param_list;
				_tmp686_ = vala_collection_get_size ((ValaCollection*) _tmp685_);
				_tmp687_ = _tmp686_;
				_param_size = _tmp687_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp688_;
					gint _tmp689_;
					ValaParameter* param = NULL;
					ValaList* _tmp690_;
					gpointer _tmp691_;
					_param_index = _param_index + 1;
					_tmp688_ = _param_index;
					_tmp689_ = _param_size;
					if (!(_tmp688_ < _tmp689_)) {
						break;
					}
					_tmp690_ = _param_list;
					_tmp691_ = vala_list_get (_tmp690_, _param_index);
					param = (ValaParameter*) _tmp691_;
					if (first) {
						first = FALSE;
					} else {
						ValaDynamicSignal* _tmp692_;
						ValaParameter* _tmp693_;
						ValaParameter* _tmp694_;
						ValaParameter* _tmp695_;
						_tmp692_ = dynamic_sig;
						_tmp693_ = param;
						_tmp694_ = vala_parameter_copy (_tmp693_);
						_tmp695_ = _tmp694_;
						vala_callable_add_parameter ((ValaCallable*) _tmp692_, _tmp695_);
						_vala_code_node_unref0 (_tmp695_);
					}
					_vala_code_node_unref0 (param);
				}
			}
			_tmp696_ = dynamic_sig;
			_tmp697_ = vala_dynamic_signal_get_handler (_tmp696_);
			_tmp698_ = _tmp697_;
			_tmp699_ = dynamic_sig;
			_tmp700_ = dynamic_sig;
			_tmp701_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp700_);
			_tmp702_ = _tmp701_;
			_tmp703_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp702_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp704_ = _tmp703_;
			_tmp705_ = vala_signal_get_delegate ((ValaSignal*) _tmp699_, (ValaDataType*) _tmp704_, (ValaCodeNode*) self);
			_tmp706_ = _tmp705_;
			_tmp707_ = vala_delegate_type_new (_tmp706_);
			_tmp708_ = _tmp707_;
			vala_expression_set_target_type (_tmp698_, (ValaDataType*) _tmp708_);
			_vala_code_node_unref0 (_tmp708_);
			_vala_code_node_unref0 (_tmp706_);
			_vala_code_node_unref0 (_tmp704_);
			_tmp709_ = dynamic_sig;
			_tmp710_ = vala_dynamic_signal_get_handler (_tmp709_);
			_tmp711_ = _tmp710_;
			_tmp712_ = vala_expression_get_target_type (_tmp711_);
			_tmp713_ = _tmp712_;
			_tmp714_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp715_ = _tmp714_;
			vala_code_node_set_source_reference ((ValaCodeNode*) _tmp713_, _tmp715_);
		}
		_tmp717_ = m;
		if (_tmp717_ != NULL) {
			ValaMethod* _tmp718_;
			_tmp718_ = m;
			_tmp716_ = vala_method_has_type_parameters (_tmp718_);
		} else {
			_tmp716_ = FALSE;
		}
		if (_tmp716_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp719_;
			ValaExpression* _tmp720_;
			ValaMemberAccess* _tmp721_;
			ValaList* _tmp722_;
			gint _tmp723_;
			gint _tmp724_;
			_tmp719_ = vala_method_call_get_call (self);
			_tmp720_ = _tmp719_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp720_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp721_ = ma;
			_tmp722_ = vala_member_access_get_type_arguments (_tmp721_);
			_tmp723_ = vala_collection_get_size ((ValaCollection*) _tmp722_);
			_tmp724_ = _tmp723_;
			if (_tmp724_ == 0) {
				ValaList* _tmp791_;
				ValaIterator* _tmp792_;
				ValaDataType* _tmp819_;
				ValaDataType* _tmp820_;
				ValaDataType* _tmp821_;
				ValaList* _tmp822_;
				ValaDataType* _tmp823_;
				ValaDataType* _tmp824_;
				{
					ValaList* _type_param_list = NULL;
					ValaMethod* _tmp725_;
					ValaList* _tmp726_;
					gint _type_param_size = 0;
					ValaList* _tmp727_;
					gint _tmp728_;
					gint _tmp729_;
					gint _type_param_index = 0;
					_tmp725_ = m;
					_tmp726_ = vala_method_get_type_parameters (_tmp725_);
					_type_param_list = _tmp726_;
					_tmp727_ = _type_param_list;
					_tmp728_ = vala_collection_get_size ((ValaCollection*) _tmp727_);
					_tmp729_ = _tmp728_;
					_type_param_size = _tmp729_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp730_;
						gint _tmp731_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp732_;
						gpointer _tmp733_;
						ValaDataType* type_arg = NULL;
						ValaList* _tmp734_;
						ValaIterator* _tmp735_;
						gboolean _tmp771_ = FALSE;
						ValaDataType* _tmp772_;
						ValaDataType* _tmp782_;
						ValaMemberAccess* _tmp789_;
						ValaDataType* _tmp790_;
						_type_param_index = _type_param_index + 1;
						_tmp730_ = _type_param_index;
						_tmp731_ = _type_param_size;
						if (!(_tmp730_ < _tmp731_)) {
							break;
						}
						_tmp732_ = _type_param_list;
						_tmp733_ = vala_list_get (_tmp732_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp733_;
						type_arg = NULL;
						_tmp734_ = self->priv->argument_list;
						_tmp735_ = vala_iterable_iterator ((ValaIterable*) _tmp734_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp735_;
						{
							ValaList* _param_list = NULL;
							ValaList* _tmp736_;
							gint _param_size = 0;
							ValaList* _tmp737_;
							gint _tmp738_;
							gint _tmp739_;
							gint _param_index = 0;
							_tmp736_ = params;
							_param_list = _tmp736_;
							_tmp737_ = _param_list;
							_tmp738_ = vala_collection_get_size ((ValaCollection*) _tmp737_);
							_tmp739_ = _tmp738_;
							_param_size = _tmp739_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp740_;
								gint _tmp741_;
								ValaParameter* param = NULL;
								ValaList* _tmp742_;
								gpointer _tmp743_;
								gboolean _tmp744_ = FALSE;
								ValaParameter* _tmp745_;
								gboolean _tmp746_;
								gboolean _tmp747_;
								ValaIterator* _tmp751_;
								_param_index = _param_index + 1;
								_tmp740_ = _param_index;
								_tmp741_ = _param_size;
								if (!(_tmp740_ < _tmp741_)) {
									break;
								}
								_tmp742_ = _param_list;
								_tmp743_ = vala_list_get (_tmp742_, _param_index);
								param = (ValaParameter*) _tmp743_;
								_tmp745_ = param;
								_tmp746_ = vala_parameter_get_ellipsis (_tmp745_);
								_tmp747_ = _tmp746_;
								if (_tmp747_) {
									_tmp744_ = TRUE;
								} else {
									ValaParameter* _tmp748_;
									gboolean _tmp749_;
									gboolean _tmp750_;
									_tmp748_ = param;
									_tmp749_ = vala_parameter_get_params_array (_tmp748_);
									_tmp750_ = _tmp749_;
									_tmp744_ = _tmp750_;
								}
								if (_tmp744_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp751_ = arg_it;
								if (vala_iterator_next (_tmp751_)) {
									ValaExpression* arg = NULL;
									ValaIterator* _tmp752_;
									gpointer _tmp753_;
									ValaParameter* _tmp754_;
									ValaDataType* _tmp755_;
									ValaDataType* _tmp756_;
									ValaTypeParameter* _tmp757_;
									ValaExpression* _tmp758_;
									ValaDataType* _tmp759_;
									ValaDataType* _tmp760_;
									ValaDataType* _tmp761_;
									ValaDataType* _tmp762_;
									ValaExpression* _tmp763_;
									ValaExpression* _tmp764_;
									ValaDataType* _tmp765_;
									ValaDataType* _tmp766_;
									ValaDataType* _tmp767_;
									ValaList* _tmp768_;
									ValaDataType* _tmp769_;
									ValaDataType* _tmp770_;
									_tmp752_ = arg_it;
									_tmp753_ = vala_iterator_get (_tmp752_);
									arg = (ValaExpression*) _tmp753_;
									_tmp754_ = param;
									_tmp755_ = vala_variable_get_variable_type ((ValaVariable*) _tmp754_);
									_tmp756_ = _tmp755_;
									_tmp757_ = type_param;
									_tmp758_ = arg;
									_tmp759_ = vala_expression_get_value_type (_tmp758_);
									_tmp760_ = _tmp759_;
									_tmp761_ = vala_data_type_infer_type_argument (_tmp756_, _tmp757_, _tmp760_);
									_vala_code_node_unref0 (type_arg);
									type_arg = _tmp761_;
									_tmp762_ = type_arg;
									if (_tmp762_ != NULL) {
										_vala_code_node_unref0 (arg);
										_vala_code_node_unref0 (param);
										break;
									}
									_tmp763_ = arg;
									_tmp764_ = arg;
									_tmp765_ = vala_expression_get_formal_target_type (_tmp764_);
									_tmp766_ = _tmp765_;
									_tmp767_ = target_object_type;
									_tmp768_ = method_type_args;
									_tmp769_ = vala_data_type_get_actual_type (_tmp766_, _tmp767_, _tmp768_, (ValaCodeNode*) self);
									_tmp770_ = _tmp769_;
									vala_expression_set_target_type (_tmp763_, _tmp770_);
									_vala_code_node_unref0 (_tmp770_);
									_vala_code_node_unref0 (arg);
								}
								_vala_code_node_unref0 (param);
							}
						}
						_tmp772_ = type_arg;
						if (_tmp772_ == NULL) {
							ValaDataType* _tmp773_;
							ValaDataType* _tmp774_;
							_tmp773_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp774_ = _tmp773_;
							_tmp771_ = _tmp774_ != NULL;
						} else {
							_tmp771_ = FALSE;
						}
						if (_tmp771_) {
							ValaMethod* _tmp775_;
							ValaDataType* _tmp776_;
							ValaDataType* _tmp777_;
							ValaTypeParameter* _tmp778_;
							ValaDataType* _tmp779_;
							ValaDataType* _tmp780_;
							ValaDataType* _tmp781_;
							_tmp775_ = m;
							_tmp776_ = vala_callable_get_return_type ((ValaCallable*) _tmp775_);
							_tmp777_ = _tmp776_;
							_tmp778_ = type_param;
							_tmp779_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp780_ = _tmp779_;
							_tmp781_ = vala_data_type_infer_type_argument (_tmp777_, _tmp778_, _tmp780_);
							_vala_code_node_unref0 (type_arg);
							type_arg = _tmp781_;
						}
						_tmp782_ = type_arg;
						if (_tmp782_ == NULL) {
							ValaMemberAccess* _tmp783_;
							ValaSourceReference* _tmp784_;
							ValaSourceReference* _tmp785_;
							ValaTypeParameter* _tmp786_;
							gchar* _tmp787_;
							gchar* _tmp788_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp783_ = ma;
							_tmp784_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp783_);
							_tmp785_ = _tmp784_;
							_tmp786_ = type_param;
							_tmp787_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp786_);
							_tmp788_ = _tmp787_;
							vala_report_error (_tmp785_, "cannot infer generic type argument for type parameter `%s'", _tmp788_);
							_g_free0 (_tmp788_);
							result = FALSE;
							_vala_code_node_unref0 (type_arg);
							_vala_code_node_unref0 (type_param);
							_vala_iterator_unref0 (arg_it);
							_vala_code_node_unref0 (last_arg);
							_vala_iterable_unref0 (params);
							_vala_code_node_unref0 (ret_type);
							_vala_code_node_unref0 (mtype);
							_vala_iterable_unref0 (method_type_args);
							_vala_code_node_unref0 (target_object_type);
							return result;
						}
						_tmp789_ = ma;
						_tmp790_ = type_arg;
						vala_member_access_add_type_argument (_tmp789_, _tmp790_);
						_vala_code_node_unref0 (type_arg);
						_vala_code_node_unref0 (type_param);
					}
				}
				_tmp791_ = self->priv->argument_list;
				_tmp792_ = vala_iterable_iterator ((ValaIterable*) _tmp791_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp792_;
				{
					ValaList* _param_list = NULL;
					ValaList* _tmp793_;
					gint _param_size = 0;
					ValaList* _tmp794_;
					gint _tmp795_;
					gint _tmp796_;
					gint _param_index = 0;
					_tmp793_ = params;
					_param_list = _tmp793_;
					_tmp794_ = _param_list;
					_tmp795_ = vala_collection_get_size ((ValaCollection*) _tmp794_);
					_tmp796_ = _tmp795_;
					_param_size = _tmp796_;
					_param_index = -1;
					while (TRUE) {
						gint _tmp797_;
						gint _tmp798_;
						ValaParameter* param = NULL;
						ValaList* _tmp799_;
						gpointer _tmp800_;
						gboolean _tmp801_ = FALSE;
						ValaParameter* _tmp802_;
						gboolean _tmp803_;
						gboolean _tmp804_;
						ValaIterator* _tmp808_;
						_param_index = _param_index + 1;
						_tmp797_ = _param_index;
						_tmp798_ = _param_size;
						if (!(_tmp797_ < _tmp798_)) {
							break;
						}
						_tmp799_ = _param_list;
						_tmp800_ = vala_list_get (_tmp799_, _param_index);
						param = (ValaParameter*) _tmp800_;
						_tmp802_ = param;
						_tmp803_ = vala_parameter_get_ellipsis (_tmp802_);
						_tmp804_ = _tmp803_;
						if (_tmp804_) {
							_tmp801_ = TRUE;
						} else {
							ValaParameter* _tmp805_;
							gboolean _tmp806_;
							gboolean _tmp807_;
							_tmp805_ = param;
							_tmp806_ = vala_parameter_get_params_array (_tmp805_);
							_tmp807_ = _tmp806_;
							_tmp801_ = _tmp807_;
						}
						if (_tmp801_) {
							_vala_code_node_unref0 (param);
							break;
						}
						_tmp808_ = arg_it;
						if (vala_iterator_next (_tmp808_)) {
							ValaExpression* arg = NULL;
							ValaIterator* _tmp809_;
							gpointer _tmp810_;
							ValaExpression* _tmp811_;
							ValaExpression* _tmp812_;
							ValaDataType* _tmp813_;
							ValaDataType* _tmp814_;
							ValaDataType* _tmp815_;
							ValaList* _tmp816_;
							ValaDataType* _tmp817_;
							ValaDataType* _tmp818_;
							_tmp809_ = arg_it;
							_tmp810_ = vala_iterator_get (_tmp809_);
							arg = (ValaExpression*) _tmp810_;
							_tmp811_ = arg;
							_tmp812_ = arg;
							_tmp813_ = vala_expression_get_formal_target_type (_tmp812_);
							_tmp814_ = _tmp813_;
							_tmp815_ = target_object_type;
							_tmp816_ = method_type_args;
							_tmp817_ = vala_data_type_get_actual_type (_tmp814_, _tmp815_, _tmp816_, (ValaCodeNode*) self);
							_tmp818_ = _tmp817_;
							vala_expression_set_target_type (_tmp811_, _tmp818_);
							_vala_code_node_unref0 (_tmp818_);
							_vala_code_node_unref0 (arg);
						}
						_vala_code_node_unref0 (param);
					}
				}
				_tmp819_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
				_tmp820_ = _tmp819_;
				_tmp821_ = target_object_type;
				_tmp822_ = method_type_args;
				_tmp823_ = vala_data_type_get_actual_type (_tmp820_, _tmp821_, _tmp822_, (ValaCodeNode*) self);
				_tmp824_ = _tmp823_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp824_);
				_vala_code_node_unref0 (_tmp824_);
			}
		}
		_tmp826_ = m;
		if (_tmp826_ != NULL) {
			ValaMethod* _tmp827_;
			gboolean _tmp828_;
			gboolean _tmp829_;
			_tmp827_ = m;
			_tmp828_ = vala_method_get_coroutine (_tmp827_);
			_tmp829_ = _tmp828_;
			_tmp825_ = _tmp829_;
		} else {
			_tmp825_ = FALSE;
		}
		if (_tmp825_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp830_;
			ValaExpression* _tmp831_;
			ValaMemberAccess* _tmp832_;
			const gchar* _tmp833_;
			const gchar* _tmp834_;
			_tmp830_ = vala_method_call_get_call (self);
			_tmp831_ = _tmp830_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp831_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp832_ = ma;
			_tmp833_ = vala_member_access_get_member_name (_tmp832_);
			_tmp834_ = _tmp833_;
			if (g_strcmp0 (_tmp834_, "end") == 0) {
				ValaMethod* _tmp835_;
				ValaMethod* _tmp836_;
				ValaMethodType* _tmp837_;
				ValaDataType* _tmp838_;
				ValaSourceReference* _tmp839_;
				ValaSourceReference* _tmp840_;
				_tmp835_ = m;
				_tmp836_ = vala_method_get_end_method (_tmp835_);
				_tmp837_ = vala_method_type_new (_tmp836_);
				_vala_code_node_unref0 (mtype);
				mtype = (ValaDataType*) _tmp837_;
				_tmp838_ = mtype;
				_tmp839_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp840_ = _tmp839_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp838_, _tmp840_);
			}
		}
	}
	_tmp841_ = vala_code_context_get_analyzer (context);
	_tmp842_ = _tmp841_;
	_tmp843_ = mtype;
	_tmp844_ = params;
	_tmp845_ = self->priv->argument_list;
	if (!vala_semantic_analyzer_check_arguments (_tmp842_, (ValaExpression*) self, _tmp843_, _tmp844_, _tmp845_)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_iterator_unref0 (arg_it);
		_vala_code_node_unref0 (last_arg);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (ret_type);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp846_;
		gint _arg_size = 0;
		ValaList* _tmp847_;
		gint _tmp848_;
		gint _tmp849_;
		gint _arg_index = 0;
		_tmp846_ = self->priv->argument_list;
		_arg_list = _tmp846_;
		_tmp847_ = _arg_list;
		_tmp848_ = vala_collection_get_size ((ValaCollection*) _tmp847_);
		_tmp849_ = _tmp848_;
		_arg_size = _tmp849_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp850_;
			gint _tmp851_;
			ValaExpression* arg = NULL;
			ValaList* _tmp852_;
			gpointer _tmp853_;
			ValaSizeofExpression* sizeof_expr = NULL;
			ValaExpression* _tmp854_;
			gboolean _tmp855_ = FALSE;
			ValaSizeofExpression* _tmp856_;
			_arg_index = _arg_index + 1;
			_tmp850_ = _arg_index;
			_tmp851_ = _arg_size;
			if (!(_tmp850_ < _tmp851_)) {
				break;
			}
			_tmp852_ = _arg_list;
			_tmp853_ = vala_list_get (_tmp852_, _arg_index);
			arg = (ValaExpression*) _tmp853_;
			_tmp854_ = arg;
			sizeof_expr = VALA_IS_SIZEOF_EXPRESSION (_tmp854_) ? ((ValaSizeofExpression*) _tmp854_) : NULL;
			_tmp856_ = sizeof_expr;
			if (_tmp856_ != NULL) {
				ValaSizeofExpression* _tmp857_;
				ValaDataType* _tmp858_;
				ValaDataType* _tmp859_;
				_tmp857_ = sizeof_expr;
				_tmp858_ = vala_sizeof_expression_get_type_reference (_tmp857_);
				_tmp859_ = _tmp858_;
				_tmp855_ = VALA_IS_GENERIC_TYPE (_tmp859_);
			} else {
				_tmp855_ = FALSE;
			}
			if (_tmp855_) {
				ValaDataType* sizeof_type = NULL;
				ValaSizeofExpression* _tmp860_;
				ValaDataType* _tmp861_;
				ValaDataType* _tmp862_;
				ValaDataType* _tmp863_;
				ValaList* _tmp864_;
				ValaDataType* _tmp865_;
				ValaExpression* _tmp866_;
				ValaDataType* _tmp867_;
				ValaSourceReference* _tmp868_;
				ValaSourceReference* _tmp869_;
				ValaSizeofExpression* _tmp870_;
				ValaSizeofExpression* _tmp871_;
				_tmp860_ = sizeof_expr;
				_tmp861_ = vala_sizeof_expression_get_type_reference (_tmp860_);
				_tmp862_ = _tmp861_;
				_tmp863_ = target_object_type;
				_tmp864_ = method_type_args;
				_tmp865_ = vala_data_type_get_actual_type (_tmp862_, _tmp863_, _tmp864_, (ValaCodeNode*) self);
				sizeof_type = _tmp865_;
				_tmp866_ = arg;
				_tmp867_ = sizeof_type;
				_tmp868_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp869_ = _tmp868_;
				_tmp870_ = vala_sizeof_expression_new (_tmp867_, _tmp869_);
				_tmp871_ = _tmp870_;
				vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp866_, (ValaExpression*) _tmp871_);
				_vala_code_node_unref0 (_tmp871_);
				_vala_code_node_unref0 (sizeof_type);
			}
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp874_ = base_cm;
	if (_tmp874_ != NULL) {
		ValaCreationMethod* _tmp875_;
		_tmp875_ = base_cm;
		_tmp873_ = vala_method_is_variadic ((ValaMethod*) _tmp875_);
	} else {
		_tmp873_ = FALSE;
	}
	if (_tmp873_) {
		ValaList* _tmp876_;
		gint _tmp877_;
		gint _tmp878_;
		ValaCreationMethod* _tmp879_;
		ValaList* _tmp880_;
		gint _tmp881_;
		gint _tmp882_;
		_tmp876_ = self->priv->argument_list;
		_tmp877_ = vala_collection_get_size ((ValaCollection*) _tmp876_);
		_tmp878_ = _tmp877_;
		_tmp879_ = base_cm;
		_tmp880_ = vala_callable_get_parameters ((ValaCallable*) _tmp879_);
		_tmp881_ = vala_collection_get_size ((ValaCollection*) _tmp880_);
		_tmp882_ = _tmp881_;
		_tmp872_ = _tmp878_ == _tmp882_;
	} else {
		_tmp872_ = FALSE;
	}
	if (_tmp872_) {
		ValaExpression* this_last_arg = NULL;
		ValaList* _tmp883_;
		ValaList* _tmp884_;
		gint _tmp885_;
		gint _tmp886_;
		gpointer _tmp887_;
		gboolean _tmp888_ = FALSE;
		ValaExpression* _tmp889_;
		ValaDataType* _tmp890_;
		ValaDataType* _tmp891_;
		_tmp883_ = self->priv->argument_list;
		_tmp884_ = self->priv->argument_list;
		_tmp885_ = vala_collection_get_size ((ValaCollection*) _tmp884_);
		_tmp886_ = _tmp885_;
		_tmp887_ = vala_list_get (_tmp883_, _tmp886_ - 1);
		this_last_arg = (ValaExpression*) _tmp887_;
		_tmp889_ = this_last_arg;
		_tmp890_ = vala_expression_get_value_type (_tmp889_);
		_tmp891_ = _tmp890_;
		if (VALA_IS_STRUCT_VALUE_TYPE (_tmp891_)) {
			ValaExpression* _tmp892_;
			ValaDataType* _tmp893_;
			ValaDataType* _tmp894_;
			ValaTypeSymbol* _tmp895_;
			ValaTypeSymbol* _tmp896_;
			ValaSemanticAnalyzer* _tmp897_;
			ValaSemanticAnalyzer* _tmp898_;
			ValaDataType* _tmp899_;
			ValaTypeSymbol* _tmp900_;
			ValaTypeSymbol* _tmp901_;
			_tmp892_ = this_last_arg;
			_tmp893_ = vala_expression_get_value_type (_tmp892_);
			_tmp894_ = _tmp893_;
			_tmp895_ = vala_data_type_get_type_symbol (_tmp894_);
			_tmp896_ = _tmp895_;
			_tmp897_ = vala_code_context_get_analyzer (context);
			_tmp898_ = _tmp897_;
			_tmp899_ = _tmp898_->va_list_type;
			_tmp900_ = vala_data_type_get_type_symbol (_tmp899_);
			_tmp901_ = _tmp900_;
			_tmp888_ = _tmp896_ == _tmp901_;
		} else {
			_tmp888_ = FALSE;
		}
		if (_tmp888_) {
			vala_method_call_set_is_constructv_chainup (self, TRUE);
		}
		_vala_code_node_unref0 (this_last_arg);
	}
	_tmp902_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp903_ = _tmp902_;
	vala_code_node_check ((ValaCodeNode*) _tmp903_, context);
	_tmp904_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp905_ = _tmp904_;
	if (_tmp905_) {
		gboolean _tmp906_ = FALSE;
		ValaCodeNode* _tmp907_;
		ValaCodeNode* _tmp908_;
		_tmp907_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp908_ = _tmp907_;
		if (VALA_IS_LOCAL_VARIABLE (_tmp908_)) {
			_tmp906_ = TRUE;
		} else {
			ValaCodeNode* _tmp909_;
			ValaCodeNode* _tmp910_;
			_tmp909_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp910_ = _tmp909_;
			_tmp906_ = VALA_IS_EXPRESSION_STATEMENT (_tmp910_);
		}
		if (_tmp906_) {
		} else {
			ValaSemanticAnalyzer* _tmp911_;
			ValaSemanticAnalyzer* _tmp912_;
			ValaSymbol* _tmp913_;
			ValaSymbol* _tmp914_;
			_tmp911_ = vala_code_context_get_analyzer (context);
			_tmp912_ = _tmp911_;
			_tmp913_ = vala_semantic_analyzer_get_current_symbol (_tmp912_);
			_tmp914_ = _tmp913_;
			if (!VALA_IS_BLOCK (_tmp914_)) {
				ValaSourceReference* _tmp915_;
				ValaSourceReference* _tmp916_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp915_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp916_ = _tmp915_;
				vala_report_error (_tmp916_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp917_;
				ValaCodeNode* _tmp918_;
				ValaCodeNode* _tmp919_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp920_;
				ValaDataType* _tmp921_;
				ValaDataType* _tmp922_;
				ValaDataType* _tmp923_;
				gchar* _tmp924_;
				gchar* _tmp925_;
				ValaSourceReference* _tmp926_;
				ValaSourceReference* _tmp927_;
				ValaLocalVariable* _tmp928_;
				ValaLocalVariable* _tmp929_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp930_;
				ValaSourceReference* _tmp931_;
				ValaSourceReference* _tmp932_;
				ValaDeclarationStatement* _tmp933_;
				ValaDataType* _tmp934_;
				ValaDataType* _tmp935_;
				ValaSemanticAnalyzer* _tmp939_;
				ValaSemanticAnalyzer* _tmp940_;
				ValaBlock* _tmp941_;
				ValaDeclarationStatement* _tmp942_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp943_;
				ValaDataType* _tmp944_;
				ValaDataType* _tmp945_;
				ValaExpression* _tmp946_;
				ValaExpression* _tmp947_;
				ValaDataType* _tmp948_;
				ValaDataType* _tmp949_;
				ValaLocalVariable* _tmp950_;
				ValaDeclarationStatement* _tmp951_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp952_;
				ValaSemanticAnalyzer* _tmp953_;
				ValaSymbol* _tmp954_;
				ValaSymbol* _tmp955_;
				ValaBlock* _tmp956_;
				ValaBlock* _tmp957_;
				ValaLocalVariable* _tmp958_;
				ValaSemanticAnalyzer* _tmp959_;
				ValaSemanticAnalyzer* _tmp960_;
				ValaBlock* _tmp961_;
				ValaLocalVariable* _tmp962_;
				ValaCodeNode* _tmp963_;
				ValaExpression* _tmp964_;
				ValaExpression* _tmp965_;
				_tmp917_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp918_ = _tmp917_;
				_tmp919_ = _vala_code_node_ref0 (_tmp918_);
				old_parent_node = _tmp919_;
				_tmp920_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp921_ = _tmp920_;
				_tmp922_ = vala_data_type_copy (_tmp921_);
				_tmp923_ = _tmp922_;
				_tmp924_ = vala_code_node_get_temp_name ();
				_tmp925_ = _tmp924_;
				_tmp926_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp927_ = _tmp926_;
				_tmp928_ = vala_local_variable_new (_tmp923_, _tmp925_, NULL, _tmp927_);
				_tmp929_ = _tmp928_;
				_g_free0 (_tmp925_);
				_vala_code_node_unref0 (_tmp923_);
				local = _tmp929_;
				_tmp930_ = local;
				_tmp931_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp932_ = _tmp931_;
				_tmp933_ = vala_declaration_statement_new ((ValaSymbol*) _tmp930_, _tmp932_);
				decl = _tmp933_;
				_tmp934_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp935_ = _tmp934_;
				if (_tmp935_ == NULL) {
					ValaLocalVariable* _tmp936_;
					ValaDataType* _tmp937_;
					ValaDataType* _tmp938_;
					_tmp936_ = local;
					_tmp937_ = vala_variable_get_variable_type ((ValaVariable*) _tmp936_);
					_tmp938_ = _tmp937_;
					vala_data_type_set_floating_reference (_tmp938_, FALSE);
				}
				_tmp939_ = vala_code_context_get_analyzer (context);
				_tmp940_ = _tmp939_;
				_tmp941_ = _tmp940_->insert_block;
				_tmp942_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp941_, (ValaStatement*) _tmp942_);
				_tmp943_ = local;
				_tmp944_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp945_ = _tmp944_;
				_tmp946_ = vala_semantic_analyzer_create_temp_access (_tmp943_, _tmp945_);
				temp_access = _tmp946_;
				_tmp947_ = temp_access;
				_tmp948_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
				_tmp949_ = _tmp948_;
				vala_expression_set_formal_target_type (_tmp947_, _tmp949_);
				_tmp950_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp950_, (ValaExpression*) self);
				_tmp951_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp951_, context);
				_tmp952_ = vala_code_context_get_analyzer (context);
				_tmp953_ = _tmp952_;
				_tmp954_ = vala_semantic_analyzer_get_current_symbol (_tmp953_);
				_tmp955_ = _tmp954_;
				_tmp956_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp955_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp956_;
				_tmp957_ = block;
				_tmp958_ = local;
				vala_block_remove_local_variable (_tmp957_, _tmp958_);
				_tmp959_ = vala_code_context_get_analyzer (context);
				_tmp960_ = _tmp959_;
				_tmp961_ = _tmp960_->insert_block;
				_tmp962_ = local;
				vala_block_add_local_variable (_tmp961_, _tmp962_);
				_tmp963_ = old_parent_node;
				_tmp964_ = temp_access;
				vala_code_node_replace_expression (_tmp963_, (ValaExpression*) self, _tmp964_);
				_tmp965_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp965_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp966_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp967_ = _tmp966_;
	result = !_tmp967_;
	_vala_iterator_unref0 (arg_it);
	_vala_code_node_unref0 (last_arg);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (ret_type);
	_vala_code_node_unref0 (mtype);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (target_object_type);
	return result;
}

static void
vala_method_call_real_emit (ValaCodeNode* base,
                            ValaCodeGenerator* codegen)
{
	ValaMethodCall * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaMethodType* _tmp5_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	method_type = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp5_ = method_type;
	if (_tmp5_ != NULL) {
		ValaMethodType* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		ValaSymbol* _tmp9_;
		ValaSymbol* _tmp10_;
		_tmp6_ = method_type;
		_tmp7_ = vala_method_type_get_method_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp4_ = VALA_IS_SIGNAL (_tmp10_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		ValaExpression* _tmp14_;
		_tmp11_ = vala_method_call_get_call (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_tmp14_ = _tmp13_;
		vala_code_node_emit ((ValaCodeNode*) _tmp14_, codegen);
	} else {
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		_tmp15_ = vala_method_call_get_call (self);
		_tmp16_ = _tmp15_;
		vala_code_node_emit ((ValaCodeNode*) _tmp16_, codegen);
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp17_;
		gint _expr_size = 0;
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _expr_index = 0;
		_tmp17_ = self->priv->argument_list;
		_expr_list = _tmp17_;
		_tmp18_ = _expr_list;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_expr_size = _tmp20_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			ValaExpression* expr = NULL;
			ValaList* _tmp23_;
			gpointer _tmp24_;
			ValaExpression* _tmp25_;
			_expr_index = _expr_index + 1;
			_tmp21_ = _expr_index;
			_tmp22_ = _expr_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _expr_list;
			_tmp24_ = vala_list_get (_tmp23_, _expr_index);
			expr = (ValaExpression*) _tmp24_;
			_tmp25_ = expr;
			vala_code_node_emit ((ValaCodeNode*) _tmp25_, codegen);
			_vala_code_node_unref0 (expr);
		}
	}
	vala_code_visitor_visit_method_call ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                             ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		gint _arg_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_arg_list = _tmp2_;
		_tmp3_ = _arg_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_arg_size = _tmp5_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_arg_index = _arg_index + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = vala_list_get (_tmp8_, _arg_index);
			arg = (ValaExpression*) _tmp9_;
			_tmp10_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp10_, collection);
			_vala_code_node_unref0 (arg);
		}
	}
}

static void
vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                          ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		gint _arg_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_arg_list = _tmp2_;
		_tmp3_ = _arg_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_arg_size = _tmp5_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_arg_index = _arg_index + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = vala_list_get (_tmp8_, _arg_index);
			arg = (ValaExpression*) _tmp9_;
			_tmp10_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp10_, collection);
			_vala_code_node_unref0 (arg);
		}
	}
}

ValaStringLiteral*
vala_method_call_get_format_literal (ValaMethodCall* self)
{
	ValaMethodType* mtype = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	ValaStringLiteral* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	mtype = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp4_ = mtype;
	if (_tmp4_ != NULL) {
		gint format_arg = 0;
		ValaMethodType* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = mtype;
		_tmp6_ = vala_method_type_get_method_symbol (_tmp5_);
		_tmp7_ = _tmp6_;
		format_arg = vala_method_get_format_arg_index (_tmp7_);
		if (format_arg >= 0) {
			ValaList* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			_tmp9_ = self->priv->argument_list;
			_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp8_ = format_arg < _tmp11_;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			ValaList* _tmp12_;
			gpointer _tmp13_;
			ValaExpression* _tmp14_;
			ValaStringLiteral* _tmp15_;
			ValaStringLiteral* _tmp16_;
			_tmp12_ = self->priv->argument_list;
			_tmp13_ = vala_list_get (_tmp12_, format_arg);
			_tmp14_ = (ValaExpression*) _tmp13_;
			_tmp15_ = vala_string_literal_get_format_literal (_tmp14_);
			_tmp16_ = _tmp15_;
			_vala_code_node_unref0 (_tmp14_);
			result = _tmp16_;
			return result;
		}
	}
	result = NULL;
	return result;
}

static gchar*
vala_method_call_real_to_string (ValaCodeNode* base)
{
	ValaMethodCall * self;
	GString* b = NULL;
	GString* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GString* _tmp4_;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GString* _tmp9_;
	gboolean first = FALSE;
	GString* _tmp23_;
	GString* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* result = NULL;
	self = (ValaMethodCall*) base;
	_tmp0_ = g_string_new ("");
	b = _tmp0_;
	_tmp1_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GString* _tmp3_;
		_tmp3_ = b;
		g_string_append (_tmp3_, "yield ");
	}
	_tmp4_ = b;
	_tmp5_ = vala_method_call_get_call (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_code_node_to_string ((ValaCodeNode*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append (_tmp4_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = b;
	g_string_append_c (_tmp9_, '(');
	first = TRUE;
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp10_;
		gint _expr_size = 0;
		ValaList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _expr_index = 0;
		_tmp10_ = self->priv->argument_list;
		_expr_list = _tmp10_;
		_tmp11_ = _expr_list;
		_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_expr_size = _tmp13_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			ValaExpression* expr = NULL;
			ValaList* _tmp16_;
			gpointer _tmp17_;
			GString* _tmp19_;
			ValaExpression* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			_expr_index = _expr_index + 1;
			_tmp14_ = _expr_index;
			_tmp15_ = _expr_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _expr_list;
			_tmp17_ = vala_list_get (_tmp16_, _expr_index);
			expr = (ValaExpression*) _tmp17_;
			if (!first) {
				GString* _tmp18_;
				_tmp18_ = b;
				g_string_append (_tmp18_, ", ");
			}
			_tmp19_ = b;
			_tmp20_ = expr;
			_tmp21_ = vala_code_node_to_string ((ValaCodeNode*) _tmp20_);
			_tmp22_ = _tmp21_;
			g_string_append (_tmp19_, _tmp22_);
			_g_free0 (_tmp22_);
			first = FALSE;
			_vala_code_node_unref0 (expr);
		}
	}
	_tmp23_ = b;
	g_string_append_c (_tmp23_, ')');
	_tmp24_ = b;
	_tmp25_ = _tmp24_->str;
	_tmp26_ = g_strdup (_tmp25_);
	result = _tmp26_;
	_g_string_free0 (b);
	return result;
}

static void
vala_method_call_class_init (ValaMethodCallClass * klass,
                             gpointer klass_data)
{
	vala_method_call_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_call_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMethodCall_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_method_call_real_replace_expression;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_method_call_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_method_call_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_method_call_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_method_call_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_used_variables;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_method_call_real_to_string;
}

static void
vala_method_call_vala_callable_expression_interface_init (ValaCallableExpressionIface * iface,
                                                          gpointer iface_data)
{
	vala_method_call_vala_callable_expression_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_argument = (void (*) (ValaCallableExpression*, ValaExpression*)) vala_method_call_real_add_argument;
	iface->get_argument_list = (ValaList* (*) (ValaCallableExpression*)) vala_method_call_real_get_argument_list;
	iface->get_is_yield_expression = vala_method_call_real_get_is_yield_expression;
	iface->set_is_yield_expression = vala_method_call_real_set_is_yield_expression;
}

static void
vala_method_call_instance_init (ValaMethodCall * self,
                                gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_method_call_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
}

static void
vala_method_call_finalize (ValaCodeNode * obj)
{
	ValaMethodCall * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD_CALL, ValaMethodCall);
	_vala_code_node_unref0 (self->priv->_call);
	_vala_iterable_unref0 (self->priv->argument_list);
	VALA_CODE_NODE_CLASS (vala_method_call_parent_class)->finalize (obj);
}

/**
 * Represents an invocation expression in the source code.
 */
static GType
vala_method_call_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMethodCallClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_call_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethodCall), 0, (GInstanceInitFunc) vala_method_call_instance_init, NULL };
	static const GInterfaceInfo vala_callable_expression_info = { (GInterfaceInitFunc) vala_method_call_vala_callable_expression_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_method_call_type_id;
	vala_method_call_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMethodCall", &g_define_type_info, 0);
	g_type_add_interface_static (vala_method_call_type_id, VALA_TYPE_CALLABLE_EXPRESSION, &vala_callable_expression_info);
	ValaMethodCall_private_offset = g_type_add_instance_private (vala_method_call_type_id, sizeof (ValaMethodCallPrivate));
	return vala_method_call_type_id;
}

GType
vala_method_call_get_type (void)
{
	static volatile gsize vala_method_call_type_id__volatile = 0;
	if (g_once_init_enter (&vala_method_call_type_id__volatile)) {
		GType vala_method_call_type_id;
		vala_method_call_type_id = vala_method_call_get_type_once ();
		g_once_init_leave (&vala_method_call_type_id__volatile, vala_method_call_type_id);
	}
	return vala_method_call_type_id__volatile;
}

