/* valaccodemethodcallmodule.c generated by valac, the Vala compiler
 * generated from valaccodemethodcallmodule.vala, do not modify */

/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "valacodegen.h"
#include <vala.h>
#include <glib.h>
#include <valaccode.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

static gpointer vala_ccode_method_call_module_parent_class = NULL;

static void vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                           ValaMethodCall* expr);
static gchar* vala_ccode_method_call_module_generate_enum_to_string_function (ValaCCodeMethodCallModule* self,
                                                                       ValaEnum* en);
static gchar* vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self);
static gboolean vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                             ValaMethodCall* c);
static GType vala_ccode_method_call_module_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                      ValaMethodCall* expr)
{
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* async_call = NULL;
	ValaCCodeFunctionCall* finish_call = NULL;
	ValaMethod* m = NULL;
	ValaDelegate* deleg = NULL;
	ValaList* params = NULL;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaMemberAccess* _tmp6_;
	ValaDataType* itype = NULL;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaList* _tmp13_;
	ValaList* _tmp14_;
	ValaDataType* _tmp15_;
	ValaHashMap* in_arg_map = NULL;
	GHashFunc _tmp166_;
	GEqualFunc _tmp167_;
	GEqualFunc _tmp168_;
	ValaHashMap* _tmp169_;
	ValaHashMap* out_arg_map = NULL;
	ValaHashMap* _tmp170_;
	ValaHashMap* _tmp171_;
	gboolean _tmp172_ = FALSE;
	ValaMethod* _tmp173_;
	gboolean _tmp365_ = FALSE;
	ValaMethod* _tmp366_;
	ValaCCodeExpression* ccall_expr = NULL;
	ValaCCodeFunctionCall* _tmp573_;
	ValaCCodeExpression* _tmp574_;
	gboolean _tmp575_ = FALSE;
	ValaMethod* _tmp576_;
	ValaCCodeExpression* instance = NULL;
	gboolean _tmp604_ = FALSE;
	ValaMethod* _tmp605_;
	gboolean _tmp738_ = FALSE;
	ValaMethod* _tmp739_;
	ValaMethod* _tmp791_;
	gboolean ellipsis = FALSE;
	gint i = 0;
	gint arg_pos = 0;
	ValaIterator* params_it = NULL;
	ValaList* _tmp990_;
	ValaIterator* _tmp991_;
	ValaIterator* _tmp1411_;
	gboolean _tmp1421_ = FALSE;
	gboolean _tmp1422_ = FALSE;
	ValaMethod* _tmp1423_;
	gboolean _tmp1544_ = FALSE;
	ValaDelegate* _tmp1545_;
	gboolean _tmp1641_ = FALSE;
	ValaMethod* _tmp1642_;
	gboolean _tmp1658_;
	gboolean _tmp1659_;
	gboolean _tmp1702_ = FALSE;
	ValaDelegate* _tmp1703_;
	gboolean return_result_via_out_param = FALSE;
	ValaDataType* _tmp1721_;
	ValaDataType* _tmp1722_;
	gboolean _tmp1723_ = FALSE;
	ValaDataType* _tmp1724_;
	ValaCCodeFunctionCall* _tmp1752_;
	ValaCCodeFunctionCall* _tmp1753_;
	ValaCCodeExpression* out_param_ref = NULL;
	gint last_pos = 0;
	gint min_pos = 0;
	ValaCCodeFunctionCall* _tmp1766_;
	ValaCCodeFunctionCall* _tmp1767_;
	ValaCCodeFunctionCall* _tmp1782_;
	gboolean _tmp1797_;
	gboolean _tmp1798_;
	gboolean _tmp1820_;
	gboolean _tmp1821_;
	gboolean _tmp1856_ = FALSE;
	gboolean _tmp1857_ = FALSE;
	ValaMethod* _tmp1858_;
	gboolean _tmp1896_ = FALSE;
	gboolean _tmp1897_ = FALSE;
	gboolean _tmp1898_ = FALSE;
	gboolean _tmp1899_ = FALSE;
	gboolean _tmp1900_ = FALSE;
	ValaMethod* _tmp1901_;
	gboolean _tmp1918_ = FALSE;
	gboolean _tmp1919_ = FALSE;
	ValaMethod* _tmp1920_;
	ValaMethod* _tmp1939_;
	gboolean _tmp2051_ = FALSE;
	ValaCodeNode* _tmp2052_;
	ValaCodeNode* _tmp2053_;
	ValaList* _tmp2153_;
	ValaIterator* _tmp2154_;
	gboolean _tmp2307_ = FALSE;
	gboolean _tmp2308_ = FALSE;
	ValaMethod* _tmp2309_;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_get_cvalue (_tmp1_);
	_tmp3_ = vala_ccode_function_call_new (_tmp2_);
	ccall = _tmp3_;
	async_call = NULL;
	finish_call = NULL;
	m = NULL;
	deleg = NULL;
	_tmp4_ = vala_method_call_get_call (expr);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp5_) : NULL);
	ma = _tmp6_;
	_tmp7_ = vala_method_call_get_call (expr);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_expression_get_value_type (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _vala_code_node_ref0 (_tmp10_);
	itype = _tmp11_;
	_tmp12_ = itype;
	_tmp13_ = vala_data_type_get_parameters (_tmp12_);
	_tmp14_ = _vala_iterable_ref0 (_tmp13_);
	_vala_iterable_unref0 (params);
	params = _tmp14_;
	_tmp15_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, VALA_TYPE_METHOD_TYPE)) {
		ValaMemberAccess* _tmp16_;
		ValaDataType* _tmp17_;
		ValaMethod* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaMethod* _tmp21_;
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		ValaMemberAccess* _tmp29_;
		ValaExpression* _tmp30_;
		ValaExpression* _tmp31_;
		_tmp16_ = ma;
		_vala_assert (_tmp16_ != NULL, "ma != null");
		_tmp17_ = itype;
		_tmp18_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp19_ = _tmp18_;
		_tmp20_ = _vala_code_node_ref0 (_tmp19_);
		_vala_code_node_unref0 (m);
		m = _tmp20_;
		_tmp21_ = m;
		if (!vala_get_ccode_simple_generics (_tmp21_)) {
			ValaCodeContext* _tmp22_;
			ValaCodeContext* _tmp23_;
			ValaSemanticAnalyzer* _tmp24_;
			ValaSemanticAnalyzer* _tmp25_;
			ValaMemberAccess* _tmp26_;
			_tmp22_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp23_ = _tmp22_;
			_tmp24_ = vala_code_context_get_analyzer (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = ma;
			vala_semantic_analyzer_check_type_arguments (_tmp25_, _tmp26_);
		}
		_tmp29_ = ma;
		_tmp30_ = vala_member_access_get_inner (_tmp29_);
		_tmp31_ = _tmp30_;
		if (_tmp31_ != NULL) {
			ValaMemberAccess* _tmp32_;
			ValaExpression* _tmp33_;
			ValaExpression* _tmp34_;
			ValaDataType* _tmp35_;
			ValaDataType* _tmp36_;
			_tmp32_ = ma;
			_tmp33_ = vala_member_access_get_inner (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_expression_get_value_type (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp28_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp36_, VALA_TYPE_ENUM_VALUE_TYPE);
		} else {
			_tmp28_ = FALSE;
		}
		if (_tmp28_) {
			ValaMemberAccess* _tmp37_;
			ValaExpression* _tmp38_;
			ValaExpression* _tmp39_;
			ValaDataType* _tmp40_;
			ValaDataType* _tmp41_;
			ValaMethod* _tmp42_;
			ValaMethod* _tmp43_;
			_tmp37_ = ma;
			_tmp38_ = vala_member_access_get_inner (_tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_expression_get_value_type (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_enum_value_type_get_to_string_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueType));
			_tmp43_ = m;
			_tmp27_ = _tmp42_ == _tmp43_;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			ValaEnum* en = NULL;
			ValaMemberAccess* _tmp44_;
			ValaExpression* _tmp45_;
			ValaExpression* _tmp46_;
			ValaDataType* _tmp47_;
			ValaDataType* _tmp48_;
			ValaTypeSymbol* _tmp49_;
			ValaTypeSymbol* _tmp50_;
			ValaCCodeFunctionCall* _tmp51_;
			ValaEnum* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			ValaCCodeIdentifier* _tmp55_;
			ValaCCodeIdentifier* _tmp56_;
			_tmp44_ = ma;
			_tmp45_ = vala_member_access_get_inner (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_expression_get_value_type (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_data_type_get_type_symbol (_tmp48_);
			_tmp50_ = _tmp49_;
			en = G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, VALA_TYPE_ENUM, ValaEnum);
			_tmp51_ = ccall;
			_tmp52_ = en;
			_tmp53_ = vala_ccode_method_call_module_generate_enum_to_string_function (self, _tmp52_);
			_tmp54_ = _tmp53_;
			_tmp55_ = vala_ccode_identifier_new (_tmp54_);
			_tmp56_ = _tmp55_;
			vala_ccode_function_call_set_call (_tmp51_, (ValaCCodeExpression*) _tmp56_);
			_vala_ccode_node_unref0 (_tmp56_);
			_g_free0 (_tmp54_);
		} else {
			gboolean _tmp57_ = FALSE;
			gboolean _tmp58_ = FALSE;
			gboolean _tmp59_ = FALSE;
			gboolean _tmp60_ = FALSE;
			ValaCodeContext* _tmp61_;
			ValaCodeContext* _tmp62_;
			ValaProfile _tmp63_;
			ValaProfile _tmp64_;
			_tmp61_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_code_context_get_profile (_tmp62_);
			_tmp64_ = _tmp63_;
			if (_tmp64_ == VALA_PROFILE_POSIX) {
				ValaMemberAccess* _tmp65_;
				ValaExpression* _tmp66_;
				ValaExpression* _tmp67_;
				_tmp65_ = ma;
				_tmp66_ = vala_member_access_get_inner (_tmp65_);
				_tmp67_ = _tmp66_;
				_tmp60_ = _tmp67_ != NULL;
			} else {
				_tmp60_ = FALSE;
			}
			if (_tmp60_) {
				ValaMemberAccess* _tmp68_;
				ValaExpression* _tmp69_;
				ValaExpression* _tmp70_;
				ValaDataType* _tmp71_;
				ValaDataType* _tmp72_;
				_tmp68_ = ma;
				_tmp69_ = vala_member_access_get_inner (_tmp68_);
				_tmp70_ = _tmp69_;
				_tmp71_ = vala_expression_get_value_type (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp59_ = _tmp72_ != NULL;
			} else {
				_tmp59_ = FALSE;
			}
			if (_tmp59_) {
				ValaMemberAccess* _tmp73_;
				ValaExpression* _tmp74_;
				ValaExpression* _tmp75_;
				ValaDataType* _tmp76_;
				ValaDataType* _tmp77_;
				ValaTypeSymbol* _tmp78_;
				ValaTypeSymbol* _tmp79_;
				ValaDataType* _tmp80_;
				ValaTypeSymbol* _tmp81_;
				ValaTypeSymbol* _tmp82_;
				_tmp73_ = ma;
				_tmp74_ = vala_member_access_get_inner (_tmp73_);
				_tmp75_ = _tmp74_;
				_tmp76_ = vala_expression_get_value_type (_tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = vala_data_type_get_type_symbol (_tmp77_);
				_tmp79_ = _tmp78_;
				_tmp80_ = ((ValaCCodeBaseModule*) self)->string_type;
				_tmp81_ = vala_data_type_get_type_symbol (_tmp80_);
				_tmp82_ = _tmp81_;
				_tmp58_ = _tmp79_ == _tmp82_;
			} else {
				_tmp58_ = FALSE;
			}
			if (_tmp58_) {
				ValaMemberAccess* _tmp83_;
				const gchar* _tmp84_;
				const gchar* _tmp85_;
				_tmp83_ = ma;
				_tmp84_ = vala_member_access_get_member_name (_tmp83_);
				_tmp85_ = _tmp84_;
				_tmp57_ = g_strcmp0 (_tmp85_, "printf") == 0;
			} else {
				_tmp57_ = FALSE;
			}
			if (_tmp57_) {
				ValaCCodeFunctionCall* _tmp86_;
				gchar* _tmp87_;
				gchar* _tmp88_;
				ValaCCodeIdentifier* _tmp89_;
				ValaCCodeIdentifier* _tmp90_;
				_tmp86_ = ccall;
				_tmp87_ = vala_ccode_method_call_module_generate_string_printf_function (self);
				_tmp88_ = _tmp87_;
				_tmp89_ = vala_ccode_identifier_new (_tmp88_);
				_tmp90_ = _tmp89_;
				vala_ccode_function_call_set_call (_tmp86_, (ValaCCodeExpression*) _tmp90_);
				_vala_ccode_node_unref0 (_tmp90_);
				_g_free0 (_tmp88_);
			} else {
				gboolean _tmp91_;
				gboolean _tmp92_;
				_tmp91_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp92_ = _tmp91_;
				if (_tmp92_) {
					ValaCCodeFunctionCall* _tmp93_;
					ValaMethod* _tmp94_;
					gchar* _tmp95_;
					gchar* _tmp96_;
					ValaCCodeIdentifier* _tmp97_;
					ValaCCodeIdentifier* _tmp98_;
					_tmp93_ = ccall;
					_tmp94_ = m;
					_tmp95_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_tmp96_ = _tmp95_;
					_tmp97_ = vala_ccode_identifier_new (_tmp96_);
					_tmp98_ = _tmp97_;
					vala_ccode_function_call_set_call (_tmp93_, (ValaCCodeExpression*) _tmp98_);
					_vala_ccode_node_unref0 (_tmp98_);
					_g_free0 (_tmp96_);
				}
			}
		}
	} else {
		ValaDataType* _tmp99_;
		_tmp99_ = itype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp99_, VALA_TYPE_SIGNAL_TYPE)) {
			ValaSignalType* sig_type = NULL;
			ValaDataType* _tmp100_;
			ValaSignalType* _tmp101_;
			gboolean _tmp102_ = FALSE;
			gboolean _tmp103_ = FALSE;
			ValaMemberAccess* _tmp104_;
			_tmp100_ = itype;
			_tmp101_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
			sig_type = _tmp101_;
			_tmp104_ = ma;
			if (_tmp104_ != NULL) {
				ValaMemberAccess* _tmp105_;
				ValaExpression* _tmp106_;
				ValaExpression* _tmp107_;
				_tmp105_ = ma;
				_tmp106_ = vala_member_access_get_inner (_tmp105_);
				_tmp107_ = _tmp106_;
				_tmp103_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp107_, VALA_TYPE_BASE_ACCESS);
			} else {
				_tmp103_ = FALSE;
			}
			if (_tmp103_) {
				ValaSignalType* _tmp108_;
				ValaSignal* _tmp109_;
				ValaSignal* _tmp110_;
				gboolean _tmp111_;
				gboolean _tmp112_;
				_tmp108_ = sig_type;
				_tmp109_ = vala_signal_type_get_signal_symbol (_tmp108_);
				_tmp110_ = _tmp109_;
				_tmp111_ = vala_signal_get_is_virtual (_tmp110_);
				_tmp112_ = _tmp111_;
				_tmp102_ = _tmp112_;
			} else {
				_tmp102_ = FALSE;
			}
			if (_tmp102_) {
				ValaSignalType* _tmp113_;
				ValaSignal* _tmp114_;
				ValaSignal* _tmp115_;
				ValaMethod* _tmp116_;
				ValaMethod* _tmp117_;
				ValaMethod* _tmp118_;
				_tmp113_ = sig_type;
				_tmp114_ = vala_signal_type_get_signal_symbol (_tmp113_);
				_tmp115_ = _tmp114_;
				_tmp116_ = vala_signal_get_default_handler (_tmp115_);
				_tmp117_ = _tmp116_;
				_tmp118_ = _vala_code_node_ref0 (_tmp117_);
				_vala_code_node_unref0 (m);
				m = _tmp118_;
			} else {
				ValaExpression* _tmp119_;
				ValaExpression* _tmp120_;
				ValaCCodeExpression* _tmp121_;
				ValaCCodeFunctionCall* _tmp122_;
				_tmp119_ = vala_method_call_get_call (expr);
				_tmp120_ = _tmp119_;
				_tmp121_ = vala_get_cvalue (_tmp120_);
				_tmp122_ = _vala_ccode_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp121_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall));
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp122_;
			}
			_vala_code_node_unref0 (sig_type);
		} else {
			ValaDataType* _tmp123_;
			_tmp123_ = itype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp123_, VALA_TYPE_OBJECT_TYPE)) {
				ValaClass* cl = NULL;
				ValaDataType* _tmp124_;
				ValaTypeSymbol* _tmp125_;
				ValaTypeSymbol* _tmp126_;
				ValaClass* _tmp127_;
				ValaClass* _tmp128_;
				ValaCreationMethod* _tmp129_;
				ValaCreationMethod* _tmp130_;
				ValaMethod* _tmp131_;
				ValaMethod* _tmp132_;
				ValaCCodeFile* _tmp133_;
				gchar* real_name = NULL;
				ValaMethod* _tmp134_;
				gchar* _tmp135_;
				gboolean _tmp136_;
				gboolean _tmp137_;
				const gchar* _tmp140_;
				ValaCCodeIdentifier* _tmp141_;
				ValaCCodeIdentifier* _tmp142_;
				ValaCCodeFunctionCall* _tmp143_;
				_tmp124_ = itype;
				_tmp125_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp126_ = _tmp125_;
				_tmp127_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp126_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp127_;
				_tmp128_ = cl;
				_tmp129_ = vala_class_get_default_construction_method (_tmp128_);
				_tmp130_ = _tmp129_;
				_tmp131_ = _vala_code_node_ref0 ((ValaMethod*) _tmp130_);
				_vala_code_node_unref0 (m);
				m = _tmp131_;
				_tmp132_ = m;
				_tmp133_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp132_, _tmp133_);
				_tmp134_ = m;
				_tmp135_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp134_);
				real_name = _tmp135_;
				_tmp136_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp137_ = _tmp136_;
				if (_tmp137_) {
					ValaMethod* _tmp138_;
					gchar* _tmp139_;
					_tmp138_ = m;
					_tmp139_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp138_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_g_free0 (real_name);
					real_name = _tmp139_;
				}
				_tmp140_ = real_name;
				_tmp141_ = vala_ccode_identifier_new (_tmp140_);
				_tmp142_ = _tmp141_;
				_tmp143_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp142_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp143_;
				_vala_ccode_node_unref0 (_tmp142_);
				_g_free0 (real_name);
				_vala_code_node_unref0 (cl);
			} else {
				ValaDataType* _tmp144_;
				_tmp144_ = itype;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp144_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp145_;
					ValaTypeSymbol* _tmp146_;
					ValaTypeSymbol* _tmp147_;
					ValaStruct* _tmp148_;
					ValaStruct* _tmp149_;
					ValaCreationMethod* _tmp150_;
					ValaCreationMethod* _tmp151_;
					ValaMethod* _tmp152_;
					ValaMethod* _tmp153_;
					ValaCCodeFile* _tmp154_;
					ValaMethod* _tmp155_;
					gchar* _tmp156_;
					gchar* _tmp157_;
					ValaCCodeIdentifier* _tmp158_;
					ValaCCodeIdentifier* _tmp159_;
					ValaCCodeFunctionCall* _tmp160_;
					_tmp145_ = itype;
					_tmp146_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp145_, VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType));
					_tmp147_ = _tmp146_;
					_tmp148_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp147_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp148_;
					_tmp149_ = st;
					_tmp150_ = vala_struct_get_default_construction_method (_tmp149_);
					_tmp151_ = _tmp150_;
					_tmp152_ = _vala_code_node_ref0 ((ValaMethod*) _tmp151_);
					_vala_code_node_unref0 (m);
					m = _tmp152_;
					_tmp153_ = m;
					_tmp154_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp153_, _tmp154_);
					_tmp155_ = m;
					_tmp156_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp155_);
					_tmp157_ = _tmp156_;
					_tmp158_ = vala_ccode_identifier_new (_tmp157_);
					_tmp159_ = _tmp158_;
					_tmp160_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp159_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp160_;
					_vala_ccode_node_unref0 (_tmp159_);
					_g_free0 (_tmp157_);
					_vala_code_node_unref0 (st);
				} else {
					ValaDataType* _tmp161_;
					_tmp161_ = itype;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp161_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDataType* _tmp162_;
						ValaDelegate* _tmp163_;
						ValaDelegate* _tmp164_;
						ValaDelegate* _tmp165_;
						_tmp162_ = itype;
						_tmp163_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp162_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp164_ = _tmp163_;
						_tmp165_ = _vala_code_node_ref0 (_tmp164_);
						_vala_code_node_unref0 (deleg);
						deleg = _tmp165_;
					}
				}
			}
		}
	}
	_tmp166_ = g_direct_hash;
	_tmp167_ = g_direct_equal;
	_tmp168_ = g_direct_equal;
	_tmp169_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp166_, _tmp167_, _tmp168_);
	in_arg_map = _tmp169_;
	_tmp170_ = in_arg_map;
	_tmp171_ = _vala_map_ref0 (_tmp170_);
	out_arg_map = _tmp171_;
	_tmp173_ = m;
	if (_tmp173_ != NULL) {
		ValaMethod* _tmp174_;
		gboolean _tmp175_;
		gboolean _tmp176_;
		_tmp174_ = m;
		_tmp175_ = vala_method_get_coroutine (_tmp174_);
		_tmp176_ = _tmp175_;
		_tmp172_ = _tmp176_;
	} else {
		_tmp172_ = FALSE;
	}
	if (_tmp172_) {
		ValaMethod* _tmp177_;
		gchar* _tmp178_;
		gchar* _tmp179_;
		ValaCCodeIdentifier* _tmp180_;
		ValaCCodeIdentifier* _tmp181_;
		ValaCCodeFunctionCall* _tmp182_;
		ValaMethod* _tmp183_;
		gchar* _tmp184_;
		gchar* _tmp185_;
		ValaCCodeIdentifier* _tmp186_;
		ValaCCodeIdentifier* _tmp187_;
		ValaCCodeFunctionCall* _tmp188_;
		ValaMemberAccess* _tmp189_;
		ValaExpression* _tmp190_;
		ValaExpression* _tmp191_;
		gboolean _tmp314_ = FALSE;
		ValaMemberAccess* _tmp315_;
		const gchar* _tmp316_;
		const gchar* _tmp317_;
		_tmp177_ = m;
		_tmp178_ = vala_get_ccode_name ((ValaCodeNode*) _tmp177_);
		_tmp179_ = _tmp178_;
		_tmp180_ = vala_ccode_identifier_new (_tmp179_);
		_tmp181_ = _tmp180_;
		_tmp182_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp181_);
		_vala_ccode_node_unref0 (async_call);
		async_call = _tmp182_;
		_vala_ccode_node_unref0 (_tmp181_);
		_g_free0 (_tmp179_);
		_tmp183_ = m;
		_tmp184_ = vala_get_ccode_finish_name (_tmp183_);
		_tmp185_ = _tmp184_;
		_tmp186_ = vala_ccode_identifier_new (_tmp185_);
		_tmp187_ = _tmp186_;
		_tmp188_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp187_);
		_vala_ccode_node_unref0 (finish_call);
		finish_call = _tmp188_;
		_vala_ccode_node_unref0 (_tmp187_);
		_g_free0 (_tmp185_);
		_tmp189_ = ma;
		_tmp190_ = vala_member_access_get_inner (_tmp189_);
		_tmp191_ = _tmp190_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp191_, VALA_TYPE_BASE_ACCESS)) {
			ValaCCodeExpression* vcast = NULL;
			ValaMethod* _tmp192_;
			ValaMethod* _tmp193_;
			ValaMethod* _tmp194_;
			ValaCCodeExpression* _tmp225_;
			vcast = NULL;
			_tmp192_ = m;
			_tmp193_ = vala_method_get_base_method (_tmp192_);
			_tmp194_ = _tmp193_;
			if (_tmp194_ != NULL) {
				ValaClass* base_class = NULL;
				ValaMethod* _tmp195_;
				ValaMethod* _tmp196_;
				ValaMethod* _tmp197_;
				ValaSymbol* _tmp198_;
				ValaSymbol* _tmp199_;
				ValaClass* _tmp200_;
				gchar* _tmp201_;
				gchar* _tmp202_;
				ValaCCodeIdentifier* _tmp203_;
				ValaCCodeIdentifier* _tmp204_;
				ValaCCodeFunctionCall* _tmp205_;
				ValaCCodeExpression* _tmp206_;
				ValaClass* _tmp207_;
				ValaClass* _tmp208_;
				gchar* _tmp209_;
				gchar* _tmp210_;
				gchar* _tmp211_;
				gchar* _tmp212_;
				ValaCCodeIdentifier* _tmp213_;
				ValaCCodeIdentifier* _tmp214_;
				_tmp195_ = m;
				_tmp196_ = vala_method_get_base_method (_tmp195_);
				_tmp197_ = _tmp196_;
				_tmp198_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp197_);
				_tmp199_ = _tmp198_;
				base_class = G_TYPE_CHECK_INSTANCE_CAST (_tmp199_, VALA_TYPE_CLASS, ValaClass);
				_tmp200_ = base_class;
				_tmp201_ = vala_get_ccode_class_type_function (_tmp200_);
				_tmp202_ = _tmp201_;
				_tmp203_ = vala_ccode_identifier_new (_tmp202_);
				_tmp204_ = _tmp203_;
				_tmp205_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp204_);
				_vala_ccode_node_unref0 (vcast);
				vcast = (ValaCCodeExpression*) _tmp205_;
				_vala_ccode_node_unref0 (_tmp204_);
				_g_free0 (_tmp202_);
				_tmp206_ = vcast;
				_tmp207_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp208_ = _tmp207_;
				_tmp209_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp208_, NULL);
				_tmp210_ = _tmp209_;
				_tmp211_ = g_strdup_printf ("%s_parent_class", _tmp210_);
				_tmp212_ = _tmp211_;
				_tmp213_ = vala_ccode_identifier_new (_tmp212_);
				_tmp214_ = _tmp213_;
				vala_ccode_function_call_add_argument (G_TYPE_CHECK_INSTANCE_CAST (_tmp206_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall), (ValaCCodeExpression*) _tmp214_);
				_vala_ccode_node_unref0 (_tmp214_);
				_g_free0 (_tmp212_);
				_g_free0 (_tmp210_);
			} else {
				ValaMethod* _tmp215_;
				ValaMethod* _tmp216_;
				ValaMethod* _tmp217_;
				_tmp215_ = m;
				_tmp216_ = vala_method_get_base_interface_method (_tmp215_);
				_tmp217_ = _tmp216_;
				if (_tmp217_ != NULL) {
					ValaInterface* base_iface = NULL;
					ValaMethod* _tmp218_;
					ValaMethod* _tmp219_;
					ValaMethod* _tmp220_;
					ValaSymbol* _tmp221_;
					ValaSymbol* _tmp222_;
					ValaInterface* _tmp223_;
					ValaCCodeExpression* _tmp224_;
					_tmp218_ = m;
					_tmp219_ = vala_method_get_base_interface_method (_tmp218_);
					_tmp220_ = _tmp219_;
					_tmp221_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp220_);
					_tmp222_ = _tmp221_;
					base_iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp222_, VALA_TYPE_INTERFACE, ValaInterface);
					_tmp223_ = base_iface;
					_tmp224_ = vala_ccode_base_module_get_this_interface_cexpression ((ValaCCodeBaseModule*) self, _tmp223_, NULL);
					_vala_ccode_node_unref0 (vcast);
					vcast = _tmp224_;
				}
			}
			_tmp225_ = vcast;
			if (_tmp225_ != NULL) {
				ValaCCodeFunctionCall* _tmp226_;
				ValaCCodeExpression* _tmp227_;
				ValaMethod* _tmp228_;
				gchar* _tmp229_;
				gchar* _tmp230_;
				ValaCCodeMemberAccess* _tmp231_;
				ValaCCodeMemberAccess* _tmp232_;
				ValaCCodeFunctionCall* _tmp233_;
				ValaCCodeExpression* _tmp234_;
				ValaMethod* _tmp235_;
				gchar* _tmp236_;
				gchar* _tmp237_;
				ValaCCodeMemberAccess* _tmp238_;
				ValaCCodeMemberAccess* _tmp239_;
				_tmp226_ = async_call;
				_tmp227_ = vcast;
				_tmp228_ = m;
				_tmp229_ = vala_get_ccode_vfunc_name (_tmp228_);
				_tmp230_ = _tmp229_;
				_tmp231_ = vala_ccode_member_access_new_pointer (_tmp227_, _tmp230_);
				_tmp232_ = _tmp231_;
				vala_ccode_function_call_set_call (_tmp226_, (ValaCCodeExpression*) _tmp232_);
				_vala_ccode_node_unref0 (_tmp232_);
				_g_free0 (_tmp230_);
				_tmp233_ = finish_call;
				_tmp234_ = vcast;
				_tmp235_ = m;
				_tmp236_ = vala_get_ccode_finish_vfunc_name (_tmp235_);
				_tmp237_ = _tmp236_;
				_tmp238_ = vala_ccode_member_access_new_pointer (_tmp234_, _tmp237_);
				_tmp239_ = _tmp238_;
				vala_ccode_function_call_set_call (_tmp233_, (ValaCCodeExpression*) _tmp239_);
				_vala_ccode_node_unref0 (_tmp239_);
				_g_free0 (_tmp237_);
			}
			_vala_ccode_node_unref0 (vcast);
		} else {
			gboolean _tmp240_ = FALSE;
			gboolean _tmp241_ = FALSE;
			gboolean _tmp242_ = FALSE;
			ValaMethod* _tmp243_;
			_tmp243_ = m;
			if (_tmp243_ != NULL) {
				ValaMethod* _tmp244_;
				_tmp244_ = m;
				_tmp242_ = vala_get_ccode_no_wrapper (_tmp244_);
			} else {
				_tmp242_ = FALSE;
			}
			if (_tmp242_) {
				ValaMethod* _tmp245_;
				ValaMemberBinding _tmp246_;
				ValaMemberBinding _tmp247_;
				_tmp245_ = m;
				_tmp246_ = vala_method_get_binding (_tmp245_);
				_tmp247_ = _tmp246_;
				_tmp241_ = _tmp247_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp241_ = FALSE;
			}
			if (_tmp241_) {
				ValaMethod* _tmp248_;
				_tmp248_ = m;
				_tmp240_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp248_, VALA_TYPE_CREATION_METHOD);
			} else {
				_tmp240_ = FALSE;
			}
			if (_tmp240_) {
				ValaTargetValue* instance_value = NULL;
				ValaMemberAccess* _tmp249_;
				ValaExpression* _tmp250_;
				ValaExpression* _tmp251_;
				ValaTargetValue* _tmp252_;
				ValaTargetValue* _tmp253_;
				ValaTargetValue* _tmp254_;
				gboolean _tmp255_ = FALSE;
				gboolean _tmp256_ = FALSE;
				ValaMemberAccess* _tmp257_;
				const gchar* _tmp258_;
				const gchar* _tmp259_;
				ValaCCodeExpression* vcast = NULL;
				ValaMethod* _tmp281_;
				ValaSymbol* _tmp282_;
				ValaSymbol* _tmp283_;
				ValaCCodeExpression* _tmp299_;
				_tmp249_ = ma;
				_tmp250_ = vala_member_access_get_inner (_tmp249_);
				_tmp251_ = _tmp250_;
				_tmp252_ = vala_expression_get_target_value (_tmp251_);
				_tmp253_ = _tmp252_;
				_tmp254_ = _vala_target_value_ref0 (_tmp253_);
				instance_value = _tmp254_;
				_tmp257_ = ma;
				_tmp258_ = vala_member_access_get_member_name (_tmp257_);
				_tmp259_ = _tmp258_;
				if (g_strcmp0 (_tmp259_, "begin") == 0) {
					_tmp256_ = TRUE;
				} else {
					ValaMemberAccess* _tmp260_;
					const gchar* _tmp261_;
					const gchar* _tmp262_;
					_tmp260_ = ma;
					_tmp261_ = vala_member_access_get_member_name (_tmp260_);
					_tmp262_ = _tmp261_;
					_tmp256_ = g_strcmp0 (_tmp262_, "end") == 0;
				}
				if (_tmp256_) {
					ValaMemberAccess* _tmp263_;
					ValaExpression* _tmp264_;
					ValaExpression* _tmp265_;
					ValaSymbol* _tmp266_;
					ValaSymbol* _tmp267_;
					ValaMemberAccess* _tmp268_;
					ValaSymbol* _tmp269_;
					ValaSymbol* _tmp270_;
					_tmp263_ = ma;
					_tmp264_ = vala_member_access_get_inner (_tmp263_);
					_tmp265_ = _tmp264_;
					_tmp266_ = vala_expression_get_symbol_reference (_tmp265_);
					_tmp267_ = _tmp266_;
					_tmp268_ = ma;
					_tmp269_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp268_);
					_tmp270_ = _tmp269_;
					_tmp255_ = _tmp267_ == _tmp270_;
				} else {
					_tmp255_ = FALSE;
				}
				if (_tmp255_) {
					ValaMemberAccess* inner_ma = NULL;
					ValaMemberAccess* _tmp271_;
					ValaExpression* _tmp272_;
					ValaExpression* _tmp273_;
					ValaMemberAccess* _tmp274_;
					ValaMemberAccess* _tmp275_;
					ValaExpression* _tmp276_;
					ValaExpression* _tmp277_;
					ValaTargetValue* _tmp278_;
					ValaTargetValue* _tmp279_;
					ValaTargetValue* _tmp280_;
					_tmp271_ = ma;
					_tmp272_ = vala_member_access_get_inner (_tmp271_);
					_tmp273_ = _tmp272_;
					_tmp274_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp273_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
					inner_ma = _tmp274_;
					_tmp275_ = inner_ma;
					_tmp276_ = vala_member_access_get_inner (_tmp275_);
					_tmp277_ = _tmp276_;
					_tmp278_ = vala_expression_get_target_value (_tmp277_);
					_tmp279_ = _tmp278_;
					_tmp280_ = _vala_target_value_ref0 (_tmp279_);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp280_;
					_vala_code_node_unref0 (inner_ma);
				}
				vcast = NULL;
				_tmp281_ = m;
				_tmp282_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp281_);
				_tmp283_ = _tmp282_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp283_, VALA_TYPE_CLASS)) {
					ValaClass* base_class = NULL;
					ValaMethod* _tmp284_;
					ValaSymbol* _tmp285_;
					ValaSymbol* _tmp286_;
					ValaClass* _tmp287_;
					ValaTargetValue* _tmp288_;
					ValaCCodeExpression* _tmp289_;
					_tmp284_ = m;
					_tmp285_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp284_);
					_tmp286_ = _tmp285_;
					base_class = G_TYPE_CHECK_INSTANCE_CAST (_tmp286_, VALA_TYPE_CLASS, ValaClass);
					_tmp287_ = base_class;
					_tmp288_ = instance_value;
					_tmp289_ = vala_ccode_base_module_get_this_class_cexpression ((ValaCCodeBaseModule*) self, _tmp287_, _tmp288_);
					_vala_ccode_node_unref0 (vcast);
					vcast = _tmp289_;
				} else {
					ValaMethod* _tmp290_;
					ValaSymbol* _tmp291_;
					ValaSymbol* _tmp292_;
					_tmp290_ = m;
					_tmp291_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp290_);
					_tmp292_ = _tmp291_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp292_, VALA_TYPE_INTERFACE)) {
						ValaInterface* base_iface = NULL;
						ValaMethod* _tmp293_;
						ValaSymbol* _tmp294_;
						ValaSymbol* _tmp295_;
						ValaInterface* _tmp296_;
						ValaTargetValue* _tmp297_;
						ValaCCodeExpression* _tmp298_;
						_tmp293_ = m;
						_tmp294_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp293_);
						_tmp295_ = _tmp294_;
						base_iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp295_, VALA_TYPE_INTERFACE, ValaInterface);
						_tmp296_ = base_iface;
						_tmp297_ = instance_value;
						_tmp298_ = vala_ccode_base_module_get_this_interface_cexpression ((ValaCCodeBaseModule*) self, _tmp296_, _tmp297_);
						_vala_ccode_node_unref0 (vcast);
						vcast = _tmp298_;
					}
				}
				_tmp299_ = vcast;
				if (_tmp299_ != NULL) {
					ValaCCodeFunctionCall* _tmp300_;
					ValaCCodeExpression* _tmp301_;
					ValaMethod* _tmp302_;
					gchar* _tmp303_;
					gchar* _tmp304_;
					ValaCCodeMemberAccess* _tmp305_;
					ValaCCodeMemberAccess* _tmp306_;
					ValaCCodeFunctionCall* _tmp307_;
					ValaCCodeExpression* _tmp308_;
					ValaMethod* _tmp309_;
					gchar* _tmp310_;
					gchar* _tmp311_;
					ValaCCodeMemberAccess* _tmp312_;
					ValaCCodeMemberAccess* _tmp313_;
					_tmp300_ = async_call;
					_tmp301_ = vcast;
					_tmp302_ = m;
					_tmp303_ = vala_get_ccode_vfunc_name (_tmp302_);
					_tmp304_ = _tmp303_;
					_tmp305_ = vala_ccode_member_access_new_pointer (_tmp301_, _tmp304_);
					_tmp306_ = _tmp305_;
					vala_ccode_function_call_set_call (_tmp300_, (ValaCCodeExpression*) _tmp306_);
					_vala_ccode_node_unref0 (_tmp306_);
					_g_free0 (_tmp304_);
					_tmp307_ = finish_call;
					_tmp308_ = vcast;
					_tmp309_ = m;
					_tmp310_ = vala_get_ccode_finish_vfunc_name (_tmp309_);
					_tmp311_ = _tmp310_;
					_tmp312_ = vala_ccode_member_access_new_pointer (_tmp308_, _tmp311_);
					_tmp313_ = _tmp312_;
					vala_ccode_function_call_set_call (_tmp307_, (ValaCCodeExpression*) _tmp313_);
					_vala_ccode_node_unref0 (_tmp313_);
					_g_free0 (_tmp311_);
				}
				_vala_ccode_node_unref0 (vcast);
				_vala_target_value_unref0 (instance_value);
			}
		}
		_tmp315_ = ma;
		_tmp316_ = vala_member_access_get_member_name (_tmp315_);
		_tmp317_ = _tmp316_;
		if (g_strcmp0 (_tmp317_, "begin") == 0) {
			ValaMemberAccess* _tmp318_;
			ValaExpression* _tmp319_;
			ValaExpression* _tmp320_;
			ValaSymbol* _tmp321_;
			ValaSymbol* _tmp322_;
			ValaMemberAccess* _tmp323_;
			ValaSymbol* _tmp324_;
			ValaSymbol* _tmp325_;
			_tmp318_ = ma;
			_tmp319_ = vala_member_access_get_inner (_tmp318_);
			_tmp320_ = _tmp319_;
			_tmp321_ = vala_expression_get_symbol_reference (_tmp320_);
			_tmp322_ = _tmp321_;
			_tmp323_ = ma;
			_tmp324_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp323_);
			_tmp325_ = _tmp324_;
			_tmp314_ = _tmp322_ == _tmp325_;
		} else {
			_tmp314_ = FALSE;
		}
		if (_tmp314_) {
			ValaCCodeFunctionCall* _tmp326_;
			ValaCCodeFunctionCall* _tmp327_;
			ValaMethod* _tmp328_;
			ValaList* _tmp329_;
			ValaList* _tmp330_;
			_tmp326_ = async_call;
			_tmp327_ = _vala_ccode_node_ref0 (_tmp326_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp327_;
			_tmp328_ = m;
			_tmp329_ = vala_method_get_async_begin_parameters (_tmp328_);
			_tmp330_ = _vala_iterable_ref0 (_tmp329_);
			_vala_iterable_unref0 (params);
			params = _tmp330_;
		} else {
			gboolean _tmp331_ = FALSE;
			ValaMemberAccess* _tmp332_;
			const gchar* _tmp333_;
			const gchar* _tmp334_;
			_tmp332_ = ma;
			_tmp333_ = vala_member_access_get_member_name (_tmp332_);
			_tmp334_ = _tmp333_;
			if (g_strcmp0 (_tmp334_, "end") == 0) {
				ValaMemberAccess* _tmp335_;
				ValaExpression* _tmp336_;
				ValaExpression* _tmp337_;
				ValaSymbol* _tmp338_;
				ValaSymbol* _tmp339_;
				ValaMemberAccess* _tmp340_;
				ValaSymbol* _tmp341_;
				ValaSymbol* _tmp342_;
				_tmp335_ = ma;
				_tmp336_ = vala_member_access_get_inner (_tmp335_);
				_tmp337_ = _tmp336_;
				_tmp338_ = vala_expression_get_symbol_reference (_tmp337_);
				_tmp339_ = _tmp338_;
				_tmp340_ = ma;
				_tmp341_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp340_);
				_tmp342_ = _tmp341_;
				_tmp331_ = _tmp339_ == _tmp342_;
			} else {
				_tmp331_ = FALSE;
			}
			if (_tmp331_) {
				ValaCCodeFunctionCall* _tmp343_;
				ValaCCodeFunctionCall* _tmp344_;
				ValaMethod* _tmp345_;
				ValaList* _tmp346_;
				ValaList* _tmp347_;
				_tmp343_ = finish_call;
				_tmp344_ = _vala_ccode_node_ref0 (_tmp343_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp344_;
				_tmp345_ = m;
				_tmp346_ = vala_method_get_async_end_parameters (_tmp345_);
				_tmp347_ = _vala_iterable_ref0 (_tmp346_);
				_vala_iterable_unref0 (params);
				params = _tmp347_;
			} else {
				gboolean _tmp348_;
				gboolean _tmp349_;
				_tmp348_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) expr);
				_tmp349_ = _tmp348_;
				if (!_tmp349_) {
					ValaCCodeFunctionCall* _tmp350_;
					ValaCCodeFunctionCall* _tmp351_;
					ValaMethod* _tmp352_;
					ValaList* _tmp353_;
					ValaList* _tmp354_;
					_tmp350_ = async_call;
					_tmp351_ = _vala_ccode_node_ref0 (_tmp350_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp351_;
					_tmp352_ = m;
					_tmp353_ = vala_method_get_async_begin_parameters (_tmp352_);
					_tmp354_ = _vala_iterable_ref0 (_tmp353_);
					_vala_iterable_unref0 (params);
					params = _tmp354_;
				} else {
					ValaCCodeFunctionCall* _tmp355_;
					ValaCCodeFunctionCall* _tmp356_;
					GHashFunc _tmp357_;
					GEqualFunc _tmp358_;
					GEqualFunc _tmp359_;
					ValaHashMap* _tmp360_;
					ValaHashMap* _tmp361_;
					ValaMethod* _tmp362_;
					ValaCCodeExpression* _tmp363_;
					ValaCCodeExpression* _tmp364_;
					_tmp355_ = finish_call;
					_tmp356_ = _vala_ccode_node_ref0 (_tmp355_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp356_;
					_tmp357_ = g_direct_hash;
					_tmp358_ = g_direct_equal;
					_tmp359_ = g_direct_equal;
					_tmp360_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp357_, _tmp358_, _tmp359_);
					_vala_map_unref0 (out_arg_map);
					out_arg_map = _tmp360_;
					_tmp361_ = out_arg_map;
					_tmp362_ = m;
					_tmp363_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "_res_");
					_tmp364_ = _tmp363_;
					vala_map_set ((ValaMap*) _tmp361_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_async_result_pos (_tmp362_), FALSE)), _tmp364_);
					_vala_ccode_node_unref0 (_tmp364_);
				}
			}
		}
	}
	_tmp366_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp366_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp367_;
		ValaSymbol* _tmp368_;
		ValaSymbol* _tmp369_;
		_tmp367_ = m;
		_tmp368_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp367_);
		_tmp369_ = _tmp368_;
		_tmp365_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp369_, VALA_TYPE_CLASS);
	} else {
		_tmp365_ = FALSE;
	}
	if (_tmp365_) {
		ValaCodeContext* _tmp370_;
		ValaCodeContext* _tmp371_;
		ValaProfile _tmp372_;
		ValaProfile _tmp373_;
		ValaClass* _tmp385_;
		ValaClass* _tmp386_;
		gboolean _tmp387_;
		gboolean _tmp388_;
		_tmp370_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp371_ = _tmp370_;
		_tmp372_ = vala_code_context_get_profile (_tmp371_);
		_tmp373_ = _tmp372_;
		if (_tmp373_ == VALA_PROFILE_GOBJECT) {
			ValaMethod* _tmp374_;
			ValaSymbol* _tmp375_;
			ValaSymbol* _tmp376_;
			gboolean _tmp377_;
			gboolean _tmp378_;
			_tmp374_ = m;
			_tmp375_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp374_);
			_tmp376_ = _tmp375_;
			_tmp377_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp376_, VALA_TYPE_CLASS, ValaClass));
			_tmp378_ = _tmp377_;
			if (!_tmp378_) {
				ValaCCodeFunctionCall* _tmp379_;
				ValaCCodeExpression* _tmp380_;
				ValaCCodeExpression* _tmp381_;
				_tmp379_ = ccall;
				_tmp380_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "object_type");
				_tmp381_ = _tmp380_;
				vala_ccode_function_call_add_argument (_tmp379_, _tmp381_);
				_vala_ccode_node_unref0 (_tmp381_);
			}
		} else {
			ValaCCodeFunctionCall* _tmp382_;
			ValaCCodeExpression* _tmp383_;
			ValaCCodeExpression* _tmp384_;
			_tmp382_ = ccall;
			_tmp383_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp384_ = _tmp383_;
			vala_ccode_function_call_add_argument (_tmp382_, _tmp384_);
			_vala_ccode_node_unref0 (_tmp384_);
		}
		_tmp385_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp386_ = _tmp385_;
		_tmp387_ = vala_class_get_is_compact (_tmp386_);
		_tmp388_ = _tmp387_;
		if (!_tmp388_) {
			ValaClass* _tmp389_;
			ValaClass* _tmp390_;
			ValaMethod* _tmp391_;
			ValaSymbol* _tmp392_;
			ValaSymbol* _tmp393_;
			_tmp389_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp390_ = _tmp389_;
			_tmp391_ = m;
			_tmp392_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp391_);
			_tmp393_ = _tmp392_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp390_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp393_) {
				{
					ValaList* _base_type_list = NULL;
					ValaClass* _tmp394_;
					ValaClass* _tmp395_;
					ValaList* _tmp396_;
					gint _base_type_size = 0;
					ValaList* _tmp397_;
					gint _tmp398_;
					gint _tmp399_;
					gint _base_type_index = 0;
					_tmp394_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp395_ = _tmp394_;
					_tmp396_ = vala_class_get_base_types (_tmp395_);
					_base_type_list = _tmp396_;
					_tmp397_ = _base_type_list;
					_tmp398_ = vala_collection_get_size ((ValaCollection*) _tmp397_);
					_tmp399_ = _tmp398_;
					_base_type_size = _tmp399_;
					_base_type_index = -1;
					while (TRUE) {
						gint _tmp400_;
						gint _tmp401_;
						ValaDataType* base_type = NULL;
						ValaList* _tmp402_;
						gpointer _tmp403_;
						ValaDataType* _tmp404_;
						ValaTypeSymbol* _tmp405_;
						ValaTypeSymbol* _tmp406_;
						_base_type_index = _base_type_index + 1;
						_tmp400_ = _base_type_index;
						_tmp401_ = _base_type_size;
						if (!(_tmp400_ < _tmp401_)) {
							break;
						}
						_tmp402_ = _base_type_list;
						_tmp403_ = vala_list_get (_tmp402_, _base_type_index);
						base_type = (ValaDataType*) _tmp403_;
						_tmp404_ = base_type;
						_tmp405_ = vala_data_type_get_type_symbol (_tmp404_);
						_tmp406_ = _tmp405_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp406_, VALA_TYPE_CLASS)) {
							ValaList* type_parameters = NULL;
							ValaMethod* _tmp407_;
							gchar* _tmp408_;
							gchar* _tmp409_;
							gboolean _tmp410_;
							ValaMethod* _tmp416_;
							ValaHashMap* _tmp417_;
							ValaDataType* _tmp418_;
							ValaList* _tmp419_;
							ValaList* _tmp420_;
							type_parameters = NULL;
							_tmp407_ = m;
							_tmp408_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp407_);
							_tmp409_ = _tmp408_;
							_tmp410_ = g_strcmp0 (_tmp409_, "g_object_new") == 0;
							_g_free0 (_tmp409_);
							if (_tmp410_) {
								ValaDataType* _tmp411_;
								ValaTypeSymbol* _tmp412_;
								ValaTypeSymbol* _tmp413_;
								ValaList* _tmp414_;
								ValaList* _tmp415_;
								_tmp411_ = base_type;
								_tmp412_ = vala_data_type_get_type_symbol (_tmp411_);
								_tmp413_ = _tmp412_;
								_tmp414_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp413_, VALA_TYPE_CLASS, ValaClass));
								_tmp415_ = _vala_iterable_ref0 (_tmp414_);
								_vala_iterable_unref0 (type_parameters);
								type_parameters = _tmp415_;
							}
							_tmp416_ = m;
							_tmp417_ = in_arg_map;
							_tmp418_ = base_type;
							_tmp419_ = vala_data_type_get_type_arguments (_tmp418_);
							_tmp420_ = type_parameters;
							vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, _tmp416_, (ValaMap*) _tmp417_, _tmp419_, (ValaCodeNode*) expr, TRUE, _tmp420_);
							_vala_iterable_unref0 (type_parameters);
							_vala_code_node_unref0 (base_type);
							break;
						}
						_vala_code_node_unref0 (base_type);
					}
				}
			} else {
				gint type_param_index = 0;
				ValaClass* cl = NULL;
				ValaMethod* _tmp421_;
				ValaSymbol* _tmp422_;
				ValaSymbol* _tmp423_;
				ValaClass* _tmp424_;
				type_param_index = 0;
				_tmp421_ = m;
				_tmp422_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp421_);
				_tmp423_ = _tmp422_;
				_tmp424_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp423_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp424_;
				{
					ValaList* _type_param_list = NULL;
					ValaClass* _tmp425_;
					ValaList* _tmp426_;
					gint _type_param_size = 0;
					ValaList* _tmp427_;
					gint _tmp428_;
					gint _tmp429_;
					gint _type_param_index = 0;
					_tmp425_ = cl;
					_tmp426_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp425_);
					_type_param_list = _tmp426_;
					_tmp427_ = _type_param_list;
					_tmp428_ = vala_collection_get_size ((ValaCollection*) _tmp427_);
					_tmp429_ = _tmp428_;
					_type_param_size = _tmp429_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp430_;
						gint _tmp431_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp432_;
						gpointer _tmp433_;
						ValaHashMap* _tmp434_;
						ValaTypeParameter* _tmp435_;
						gchar* _tmp436_;
						gchar* _tmp437_;
						ValaCCodeIdentifier* _tmp438_;
						ValaCCodeIdentifier* _tmp439_;
						ValaHashMap* _tmp440_;
						ValaTypeParameter* _tmp441_;
						gchar* _tmp442_;
						gchar* _tmp443_;
						ValaCCodeIdentifier* _tmp444_;
						ValaCCodeIdentifier* _tmp445_;
						ValaHashMap* _tmp446_;
						ValaTypeParameter* _tmp447_;
						gchar* _tmp448_;
						gchar* _tmp449_;
						ValaCCodeIdentifier* _tmp450_;
						ValaCCodeIdentifier* _tmp451_;
						gint _tmp452_;
						_type_param_index = _type_param_index + 1;
						_tmp430_ = _type_param_index;
						_tmp431_ = _type_param_size;
						if (!(_tmp430_ < _tmp431_)) {
							break;
						}
						_tmp432_ = _type_param_list;
						_tmp433_ = vala_list_get (_tmp432_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp433_;
						_tmp434_ = in_arg_map;
						_tmp435_ = type_param;
						_tmp436_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp435_);
						_tmp437_ = _tmp436_;
						_tmp438_ = vala_ccode_identifier_new (_tmp437_);
						_tmp439_ = _tmp438_;
						vala_map_set ((ValaMap*) _tmp434_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp439_);
						_vala_ccode_node_unref0 (_tmp439_);
						_g_free0 (_tmp437_);
						_tmp440_ = in_arg_map;
						_tmp441_ = type_param;
						_tmp442_ = vala_get_ccode_copy_function ((ValaTypeSymbol*) _tmp441_);
						_tmp443_ = _tmp442_;
						_tmp444_ = vala_ccode_identifier_new (_tmp443_);
						_tmp445_ = _tmp444_;
						vala_map_set ((ValaMap*) _tmp440_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.02, FALSE)), (ValaCCodeExpression*) _tmp445_);
						_vala_ccode_node_unref0 (_tmp445_);
						_g_free0 (_tmp443_);
						_tmp446_ = in_arg_map;
						_tmp447_ = type_param;
						_tmp448_ = vala_get_ccode_destroy_function ((ValaTypeSymbol*) _tmp447_);
						_tmp449_ = _tmp448_;
						_tmp450_ = vala_ccode_identifier_new (_tmp449_);
						_tmp451_ = _tmp450_;
						vala_map_set ((ValaMap*) _tmp446_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.03, FALSE)), (ValaCCodeExpression*) _tmp451_);
						_vala_ccode_node_unref0 (_tmp451_);
						_g_free0 (_tmp449_);
						_tmp452_ = type_param_index;
						type_param_index = _tmp452_ + 1;
						_vala_code_node_unref0 (type_param);
					}
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			ValaClass* _tmp453_;
			ValaClass* _tmp454_;
			ValaClass* _tmp455_;
			_tmp453_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp454_ = _tmp453_;
			_tmp455_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp454_, (ValaTypeSymbol*) _tmp455_)) {
				gchar* class_prefix = NULL;
				ValaClass* _tmp456_;
				ValaClass* _tmp457_;
				gchar* _tmp458_;
				gchar* prepare_func = NULL;
				gchar* _tmp459_;
				gchar* check_func = NULL;
				gchar* _tmp460_;
				ValaCCodeDeclaration* funcs = NULL;
				ValaCCodeDeclaration* _tmp484_;
				ValaCCodeDeclaration* _tmp485_;
				ValaCCodeDeclaration* _tmp486_;
				const gchar* _tmp487_;
				const gchar* _tmp488_;
				const gchar* _tmp489_;
				const gchar* _tmp490_;
				gchar* _tmp491_;
				gchar* _tmp492_;
				ValaCCodeConstant* _tmp493_;
				ValaCCodeConstant* _tmp494_;
				ValaCCodeVariableDeclarator* _tmp495_;
				ValaCCodeVariableDeclarator* _tmp496_;
				ValaCCodeFunction* _tmp497_;
				ValaCCodeFunction* _tmp498_;
				ValaCCodeDeclaration* _tmp499_;
				ValaCCodeFunctionCall* _tmp500_;
				ValaCCodeIdentifier* _tmp501_;
				ValaCCodeIdentifier* _tmp502_;
				ValaCCodeUnaryExpression* _tmp503_;
				ValaCCodeUnaryExpression* _tmp504_;
				ValaCCodeCastExpression* _tmp505_;
				ValaCCodeCastExpression* _tmp506_;
				ValaCCodeFunctionCall* csizeof = NULL;
				ValaCCodeIdentifier* _tmp507_;
				ValaCCodeIdentifier* _tmp508_;
				ValaCCodeFunctionCall* _tmp509_;
				ValaCCodeFunctionCall* _tmp510_;
				ValaCCodeFunctionCall* _tmp511_;
				ValaClass* _tmp512_;
				ValaClass* _tmp513_;
				gchar* _tmp514_;
				gchar* _tmp515_;
				ValaCCodeIdentifier* _tmp516_;
				ValaCCodeIdentifier* _tmp517_;
				ValaCCodeFunctionCall* _tmp518_;
				ValaCCodeFunctionCall* _tmp519_;
				_tmp456_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp457_ = _tmp456_;
				_tmp458_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp457_, NULL);
				class_prefix = _tmp458_;
				_tmp459_ = g_strdup ("NULL");
				prepare_func = _tmp459_;
				_tmp460_ = g_strdup ("NULL");
				check_func = _tmp460_;
				{
					ValaList* _impl_list = NULL;
					ValaClass* _tmp461_;
					ValaClass* _tmp462_;
					ValaList* _tmp463_;
					gint _impl_size = 0;
					ValaList* _tmp464_;
					gint _tmp465_;
					gint _tmp466_;
					gint _impl_index = 0;
					_tmp461_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp462_ = _tmp461_;
					_tmp463_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp462_);
					_impl_list = _tmp463_;
					_tmp464_ = _impl_list;
					_tmp465_ = vala_collection_get_size ((ValaCollection*) _tmp464_);
					_tmp466_ = _tmp465_;
					_impl_size = _tmp466_;
					_impl_index = -1;
					while (TRUE) {
						gint _tmp467_;
						gint _tmp468_;
						ValaMethod* impl = NULL;
						ValaList* _tmp469_;
						gpointer _tmp470_;
						ValaMethod* _tmp471_;
						gboolean _tmp472_;
						gboolean _tmp473_;
						ValaMethod* _tmp474_;
						const gchar* _tmp475_;
						const gchar* _tmp476_;
						const gchar* _tmp477_;
						GQuark _tmp479_ = 0U;
						static GQuark _tmp478_label0 = 0;
						static GQuark _tmp478_label1 = 0;
						_impl_index = _impl_index + 1;
						_tmp467_ = _impl_index;
						_tmp468_ = _impl_size;
						if (!(_tmp467_ < _tmp468_)) {
							break;
						}
						_tmp469_ = _impl_list;
						_tmp470_ = vala_list_get (_tmp469_, _impl_index);
						impl = (ValaMethod*) _tmp470_;
						_tmp471_ = impl;
						_tmp472_ = vala_method_get_overrides (_tmp471_);
						_tmp473_ = _tmp472_;
						if (!_tmp473_) {
							_vala_code_node_unref0 (impl);
							continue;
						}
						_tmp474_ = impl;
						_tmp475_ = vala_symbol_get_name ((ValaSymbol*) _tmp474_);
						_tmp476_ = _tmp475_;
						_tmp477_ = _tmp476_;
						_tmp479_ = (NULL == _tmp477_) ? 0 : g_quark_from_string (_tmp477_);
						if (_tmp479_ == ((0 != _tmp478_label0) ? _tmp478_label0 : (_tmp478_label0 = g_quark_from_static_string ("prepare")))) {
							switch (0) {
								default:
								{
									const gchar* _tmp480_;
									gchar* _tmp481_;
									_tmp480_ = class_prefix;
									_tmp481_ = g_strdup_printf ("%s_real_prepare", _tmp480_);
									_g_free0 (prepare_func);
									prepare_func = _tmp481_;
									break;
								}
							}
						} else if (_tmp479_ == ((0 != _tmp478_label1) ? _tmp478_label1 : (_tmp478_label1 = g_quark_from_static_string ("check")))) {
							switch (0) {
								default:
								{
									const gchar* _tmp482_;
									gchar* _tmp483_;
									_tmp482_ = class_prefix;
									_tmp483_ = g_strdup_printf ("%s_real_check", _tmp482_);
									_g_free0 (check_func);
									check_func = _tmp483_;
									break;
								}
							}
						} else {
							switch (0) {
								default:
								{
									break;
								}
							}
						}
						_vala_code_node_unref0 (impl);
					}
				}
				_tmp484_ = vala_ccode_declaration_new ("const GSourceFuncs");
				funcs = _tmp484_;
				_tmp485_ = funcs;
				vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp485_, VALA_CCODE_MODIFIERS_STATIC);
				_tmp486_ = funcs;
				_tmp487_ = prepare_func;
				_tmp488_ = check_func;
				_tmp489_ = class_prefix;
				_tmp490_ = class_prefix;
				_tmp491_ = g_strdup_printf ("{ %s, %s, %s_real_dispatch, %s_finalize}", _tmp487_, _tmp488_, _tmp489_, _tmp490_);
				_tmp492_ = _tmp491_;
				_tmp493_ = vala_ccode_constant_new (_tmp492_);
				_tmp494_ = _tmp493_;
				_tmp495_ = vala_ccode_variable_declarator_new ("_source_funcs", (ValaCCodeExpression*) _tmp494_, NULL);
				_tmp496_ = _tmp495_;
				vala_ccode_declaration_add_declarator (_tmp486_, (ValaCCodeDeclarator*) _tmp496_);
				_vala_ccode_node_unref0 (_tmp496_);
				_vala_ccode_node_unref0 (_tmp494_);
				_g_free0 (_tmp492_);
				_tmp497_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp498_ = _tmp497_;
				_tmp499_ = funcs;
				vala_ccode_function_add_statement (_tmp498_, (ValaCCodeNode*) _tmp499_);
				_tmp500_ = ccall;
				_tmp501_ = vala_ccode_identifier_new ("_source_funcs");
				_tmp502_ = _tmp501_;
				_tmp503_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp502_);
				_tmp504_ = _tmp503_;
				_tmp505_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp504_, "GSourceFuncs *");
				_tmp506_ = _tmp505_;
				vala_ccode_function_call_add_argument (_tmp500_, (ValaCCodeExpression*) _tmp506_);
				_vala_ccode_node_unref0 (_tmp506_);
				_vala_ccode_node_unref0 (_tmp504_);
				_vala_ccode_node_unref0 (_tmp502_);
				_tmp507_ = vala_ccode_identifier_new ("sizeof");
				_tmp508_ = _tmp507_;
				_tmp509_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp508_);
				_tmp510_ = _tmp509_;
				_vala_ccode_node_unref0 (_tmp508_);
				csizeof = _tmp510_;
				_tmp511_ = csizeof;
				_tmp512_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp513_ = _tmp512_;
				_tmp514_ = vala_get_ccode_name ((ValaCodeNode*) _tmp513_);
				_tmp515_ = _tmp514_;
				_tmp516_ = vala_ccode_identifier_new (_tmp515_);
				_tmp517_ = _tmp516_;
				vala_ccode_function_call_add_argument (_tmp511_, (ValaCCodeExpression*) _tmp517_);
				_vala_ccode_node_unref0 (_tmp517_);
				_g_free0 (_tmp515_);
				_tmp518_ = ccall;
				_tmp519_ = csizeof;
				vala_ccode_function_call_add_argument (_tmp518_, (ValaCCodeExpression*) _tmp519_);
				_vala_ccode_node_unref0 (csizeof);
				_vala_ccode_node_unref0 (funcs);
				_g_free0 (check_func);
				_g_free0 (prepare_func);
				_g_free0 (class_prefix);
			} else {
				gboolean _tmp520_ = FALSE;
				ValaClass* _tmp521_;
				ValaClass* _tmp522_;
				ValaClass* _tmp523_;
				ValaClass* _tmp524_;
				_tmp521_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp522_ = _tmp521_;
				_tmp523_ = vala_class_get_base_class (_tmp522_);
				_tmp524_ = _tmp523_;
				if (_tmp524_ != NULL) {
					ValaMethod* _tmp525_;
					_tmp525_ = m;
					_tmp520_ = vala_get_ccode_simple_generics (_tmp525_);
				} else {
					_tmp520_ = FALSE;
				}
				if (_tmp520_) {
					ValaClass* _tmp526_;
					ValaClass* _tmp527_;
					ValaMethod* _tmp528_;
					ValaSymbol* _tmp529_;
					ValaSymbol* _tmp530_;
					_tmp526_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp527_ = _tmp526_;
					_tmp528_ = m;
					_tmp529_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp528_);
					_tmp530_ = _tmp529_;
					if (G_TYPE_CHECK_INSTANCE_CAST (_tmp527_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp530_) {
						{
							ValaList* _base_type_list = NULL;
							ValaClass* _tmp531_;
							ValaClass* _tmp532_;
							ValaList* _tmp533_;
							gint _base_type_size = 0;
							ValaList* _tmp534_;
							gint _tmp535_;
							gint _tmp536_;
							gint _base_type_index = 0;
							_tmp531_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
							_tmp532_ = _tmp531_;
							_tmp533_ = vala_class_get_base_types (_tmp532_);
							_base_type_list = _tmp533_;
							_tmp534_ = _base_type_list;
							_tmp535_ = vala_collection_get_size ((ValaCollection*) _tmp534_);
							_tmp536_ = _tmp535_;
							_base_type_size = _tmp536_;
							_base_type_index = -1;
							while (TRUE) {
								gint _tmp537_;
								gint _tmp538_;
								ValaDataType* base_type = NULL;
								ValaList* _tmp539_;
								gpointer _tmp540_;
								ValaDataType* _tmp541_;
								ValaTypeSymbol* _tmp542_;
								ValaTypeSymbol* _tmp543_;
								_base_type_index = _base_type_index + 1;
								_tmp537_ = _base_type_index;
								_tmp538_ = _base_type_size;
								if (!(_tmp537_ < _tmp538_)) {
									break;
								}
								_tmp539_ = _base_type_list;
								_tmp540_ = vala_list_get (_tmp539_, _base_type_index);
								base_type = (ValaDataType*) _tmp540_;
								_tmp541_ = base_type;
								_tmp542_ = vala_data_type_get_type_symbol (_tmp541_);
								_tmp543_ = _tmp542_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp543_, VALA_TYPE_CLASS)) {
									ValaMethod* _tmp544_;
									ValaHashMap* _tmp545_;
									ValaDataType* _tmp546_;
									ValaList* _tmp547_;
									_tmp544_ = m;
									_tmp545_ = in_arg_map;
									_tmp546_ = base_type;
									_tmp547_ = vala_data_type_get_type_arguments (_tmp546_);
									vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, _tmp544_, (ValaMap*) _tmp545_, _tmp547_, (ValaCodeNode*) expr, FALSE, NULL);
									_vala_code_node_unref0 (base_type);
									break;
								}
								_vala_code_node_unref0 (base_type);
							}
						}
					} else {
					}
				}
			}
		}
	} else {
		gboolean _tmp548_ = FALSE;
		ValaMethod* _tmp549_;
		_tmp549_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp549_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp550_;
			ValaSymbol* _tmp551_;
			ValaSymbol* _tmp552_;
			_tmp550_ = m;
			_tmp551_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp550_);
			_tmp552_ = _tmp551_;
			_tmp548_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp552_, VALA_TYPE_STRUCT);
		} else {
			_tmp548_ = FALSE;
		}
		if (_tmp548_) {
			ValaCCodeFunctionCall* _tmp553_;
			ValaCCodeExpression* _tmp554_;
			ValaCCodeExpression* _tmp555_;
			_tmp553_ = ccall;
			_tmp554_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp555_ = _tmp554_;
			vala_ccode_function_call_add_argument (_tmp553_, _tmp555_);
			_vala_ccode_node_unref0 (_tmp555_);
		} else {
			gboolean _tmp556_ = FALSE;
			gboolean _tmp557_ = FALSE;
			gboolean _tmp558_ = FALSE;
			gboolean _tmp559_ = FALSE;
			ValaMethod* _tmp560_;
			_tmp560_ = m;
			if (_tmp560_ != NULL) {
				ValaMethod* _tmp561_;
				_tmp561_ = m;
				_tmp559_ = vala_method_has_type_parameters (_tmp561_);
			} else {
				_tmp559_ = FALSE;
			}
			if (_tmp559_) {
				ValaMethod* _tmp562_;
				_tmp562_ = m;
				_tmp558_ = !vala_get_ccode_has_generic_type_parameter (_tmp562_);
			} else {
				_tmp558_ = FALSE;
			}
			if (_tmp558_) {
				ValaMethod* _tmp563_;
				_tmp563_ = m;
				_tmp557_ = !vala_get_ccode_simple_generics (_tmp563_);
			} else {
				_tmp557_ = FALSE;
			}
			if (_tmp557_) {
				gboolean _tmp564_ = FALSE;
				ValaCCodeFunctionCall* _tmp565_;
				ValaCCodeFunctionCall* _tmp566_;
				_tmp565_ = ccall;
				_tmp566_ = finish_call;
				if (_tmp565_ != _tmp566_) {
					_tmp564_ = TRUE;
				} else {
					gboolean _tmp567_;
					gboolean _tmp568_;
					_tmp567_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) expr);
					_tmp568_ = _tmp567_;
					_tmp564_ = _tmp568_;
				}
				_tmp556_ = _tmp564_;
			} else {
				_tmp556_ = FALSE;
			}
			if (_tmp556_) {
				ValaMethod* _tmp569_;
				ValaHashMap* _tmp570_;
				ValaMemberAccess* _tmp571_;
				ValaList* _tmp572_;
				_tmp569_ = m;
				_tmp570_ = in_arg_map;
				_tmp571_ = ma;
				_tmp572_ = vala_member_access_get_type_arguments (_tmp571_);
				vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, _tmp569_, (ValaMap*) _tmp570_, _tmp572_, (ValaCodeNode*) expr, FALSE, NULL);
			}
		}
	}
	_tmp573_ = ccall;
	_tmp574_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp573_);
	ccall_expr = _tmp574_;
	_tmp576_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp576_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaCodeContext* _tmp577_;
		ValaCodeContext* _tmp578_;
		ValaProfile _tmp579_;
		ValaProfile _tmp580_;
		_tmp577_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp578_ = _tmp577_;
		_tmp579_ = vala_code_context_get_profile (_tmp578_);
		_tmp580_ = _tmp579_;
		_tmp575_ = _tmp580_ != VALA_PROFILE_POSIX;
	} else {
		_tmp575_ = FALSE;
	}
	if (_tmp575_) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp581_;
		ValaExpression* _tmp582_;
		ValaExpression* _tmp583_;
		ValaDataType* _tmp584_;
		ValaDataType* _tmp585_;
		ValaArrayType* _tmp586_;
		ValaHashMap* _tmp587_;
		ValaArrayType* _tmp588_;
		ValaDataType* _tmp589_;
		ValaDataType* _tmp590_;
		gchar* _tmp591_;
		gchar* _tmp592_;
		ValaCCodeIdentifier* _tmp593_;
		ValaCCodeIdentifier* _tmp594_;
		_tmp581_ = ma;
		_tmp582_ = vala_member_access_get_inner (_tmp581_);
		_tmp583_ = _tmp582_;
		_tmp584_ = vala_expression_get_value_type (_tmp583_);
		_tmp585_ = _tmp584_;
		_tmp586_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp585_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp586_;
		_tmp587_ = in_arg_map;
		_tmp588_ = array_type;
		_tmp589_ = vala_array_type_get_element_type (_tmp588_);
		_tmp590_ = _tmp589_;
		_tmp591_ = vala_get_ccode_name ((ValaCodeNode*) _tmp590_);
		_tmp592_ = _tmp591_;
		_tmp593_ = vala_ccode_identifier_new (_tmp592_);
		_tmp594_ = _tmp593_;
		vala_map_set ((ValaMap*) _tmp587_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) 0, FALSE)), (ValaCCodeExpression*) _tmp594_);
		_vala_ccode_node_unref0 (_tmp594_);
		_g_free0 (_tmp592_);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp595_;
		_tmp595_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp595_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		} else {
			ValaMethod* _tmp596_;
			_tmp596_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp596_, VALA_TYPE_ARRAY_COPY_METHOD)) {
				ValaMemberAccess* _tmp597_;
				ValaExpression* _tmp598_;
				ValaExpression* _tmp599_;
				ValaTargetValue* _tmp600_;
				ValaTargetValue* _tmp601_;
				ValaTargetValue* _tmp602_;
				ValaTargetValue* _tmp603_;
				_tmp597_ = ma;
				_tmp598_ = vala_member_access_get_inner (_tmp597_);
				_tmp599_ = _tmp598_;
				_tmp600_ = vala_expression_get_target_value (_tmp599_);
				_tmp601_ = _tmp600_;
				_tmp602_ = vala_ccode_base_module_copy_value ((ValaCCodeBaseModule*) self, _tmp601_, (ValaCodeNode*) expr);
				_tmp603_ = _tmp602_;
				vala_expression_set_target_value ((ValaExpression*) expr, _tmp603_);
				_vala_target_value_unref0 (_tmp603_);
				_vala_ccode_node_unref0 (ccall_expr);
				_vala_map_unref0 (out_arg_map);
				_vala_map_unref0 (in_arg_map);
				_vala_code_node_unref0 (itype);
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (deleg);
				_vala_code_node_unref0 (m);
				_vala_ccode_node_unref0 (finish_call);
				_vala_ccode_node_unref0 (async_call);
				_vala_ccode_node_unref0 (ccall);
				return;
			}
		}
	}
	instance = NULL;
	_tmp605_ = m;
	if (_tmp605_ != NULL) {
		ValaMethod* _tmp606_;
		gboolean _tmp607_;
		gboolean _tmp608_;
		_tmp606_ = m;
		_tmp607_ = vala_method_get_is_async_callback (_tmp606_);
		_tmp608_ = _tmp607_;
		_tmp604_ = _tmp608_;
	} else {
		_tmp604_ = FALSE;
	}
	if (_tmp604_) {
		ValaMethod* _tmp609_;
		ValaMethod* _tmp610_;
		gboolean _tmp611_;
		gboolean _tmp612_;
		ValaHashMap* _tmp626_;
		ValaMethod* _tmp627_;
		ValaCCodeExpression* _tmp628_;
		ValaHashMap* _tmp629_;
		ValaMethod* _tmp630_;
		ValaCCodeExpression* _tmp631_;
		_tmp609_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp610_ = _tmp609_;
		_tmp611_ = vala_method_get_closure (_tmp610_);
		_tmp612_ = _tmp611_;
		if (_tmp612_) {
			ValaBlock* block = NULL;
			ValaMethod* _tmp613_;
			ValaSymbol* _tmp614_;
			ValaSymbol* _tmp615_;
			ValaBlock* _tmp616_;
			ValaBlock* _tmp617_;
			ValaBlock* _tmp618_;
			ValaBlock* _tmp619_;
			gchar* _tmp620_;
			gchar* _tmp621_;
			ValaCCodeExpression* _tmp622_;
			ValaCCodeExpression* _tmp623_;
			ValaCCodeMemberAccess* _tmp624_;
			_tmp613_ = m;
			_tmp614_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp613_);
			_tmp615_ = _tmp614_;
			_tmp616_ = vala_subroutine_get_body ((ValaSubroutine*) G_TYPE_CHECK_INSTANCE_CAST (_tmp615_, VALA_TYPE_METHOD, ValaMethod));
			_tmp617_ = _tmp616_;
			_tmp618_ = _vala_code_node_ref0 (_tmp617_);
			block = _tmp618_;
			_tmp619_ = block;
			_tmp620_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp619_));
			_tmp621_ = _tmp620_;
			_tmp622_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp621_);
			_tmp623_ = _tmp622_;
			_tmp624_ = vala_ccode_member_access_new_pointer (_tmp623_, "_async_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp624_;
			_vala_ccode_node_unref0 (_tmp623_);
			_g_free0 (_tmp621_);
			_vala_code_node_unref0 (block);
		} else {
			ValaCCodeIdentifier* _tmp625_;
			_tmp625_ = vala_ccode_identifier_new ("_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp625_;
		}
		_tmp626_ = in_arg_map;
		_tmp627_ = m;
		_tmp628_ = instance;
		vala_map_set ((ValaMap*) _tmp626_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp627_), FALSE)), _tmp628_);
		_tmp629_ = out_arg_map;
		_tmp630_ = m;
		_tmp631_ = instance;
		vala_map_set ((ValaMap*) _tmp629_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp630_), FALSE)), _tmp631_);
	} else {
		gboolean _tmp632_ = FALSE;
		gboolean _tmp633_ = FALSE;
		ValaMethod* _tmp634_;
		_tmp634_ = m;
		if (_tmp634_ != NULL) {
			ValaMethod* _tmp635_;
			ValaMemberBinding _tmp636_;
			ValaMemberBinding _tmp637_;
			_tmp635_ = m;
			_tmp636_ = vala_method_get_binding (_tmp635_);
			_tmp637_ = _tmp636_;
			_tmp633_ = _tmp637_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp633_ = FALSE;
		}
		if (_tmp633_) {
			ValaMethod* _tmp638_;
			_tmp638_ = m;
			_tmp632_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp638_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp632_ = FALSE;
		}
		if (_tmp632_) {
			ValaTargetValue* instance_value = NULL;
			ValaMemberAccess* _tmp639_;
			ValaExpression* _tmp640_;
			ValaExpression* _tmp641_;
			ValaTargetValue* _tmp642_;
			ValaTargetValue* _tmp643_;
			ValaTargetValue* _tmp644_;
			gboolean _tmp645_ = FALSE;
			gboolean _tmp646_ = FALSE;
			ValaMemberAccess* _tmp647_;
			const gchar* _tmp648_;
			const gchar* _tmp649_;
			ValaTargetValue* _tmp671_;
			ValaCCodeExpression* _tmp672_;
			ValaCCodeExpression* _tmp673_;
			ValaStruct* st = NULL;
			ValaMethod* _tmp674_;
			ValaSymbol* _tmp675_;
			ValaSymbol* _tmp676_;
			ValaStruct* _tmp677_;
			gboolean _tmp678_ = FALSE;
			ValaStruct* _tmp679_;
			ValaMethod* _tmp687_;
			gboolean _tmp688_;
			gboolean _tmp689_;
			_tmp639_ = ma;
			_tmp640_ = vala_member_access_get_inner (_tmp639_);
			_tmp641_ = _tmp640_;
			_tmp642_ = vala_expression_get_target_value (_tmp641_);
			_tmp643_ = _tmp642_;
			_tmp644_ = _vala_target_value_ref0 (_tmp643_);
			instance_value = _tmp644_;
			_tmp647_ = ma;
			_tmp648_ = vala_member_access_get_member_name (_tmp647_);
			_tmp649_ = _tmp648_;
			if (g_strcmp0 (_tmp649_, "begin") == 0) {
				_tmp646_ = TRUE;
			} else {
				ValaMemberAccess* _tmp650_;
				const gchar* _tmp651_;
				const gchar* _tmp652_;
				_tmp650_ = ma;
				_tmp651_ = vala_member_access_get_member_name (_tmp650_);
				_tmp652_ = _tmp651_;
				_tmp646_ = g_strcmp0 (_tmp652_, "end") == 0;
			}
			if (_tmp646_) {
				ValaMemberAccess* _tmp653_;
				ValaExpression* _tmp654_;
				ValaExpression* _tmp655_;
				ValaSymbol* _tmp656_;
				ValaSymbol* _tmp657_;
				ValaMemberAccess* _tmp658_;
				ValaSymbol* _tmp659_;
				ValaSymbol* _tmp660_;
				_tmp653_ = ma;
				_tmp654_ = vala_member_access_get_inner (_tmp653_);
				_tmp655_ = _tmp654_;
				_tmp656_ = vala_expression_get_symbol_reference (_tmp655_);
				_tmp657_ = _tmp656_;
				_tmp658_ = ma;
				_tmp659_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp658_);
				_tmp660_ = _tmp659_;
				_tmp645_ = _tmp657_ == _tmp660_;
			} else {
				_tmp645_ = FALSE;
			}
			if (_tmp645_) {
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp661_;
				ValaExpression* _tmp662_;
				ValaExpression* _tmp663_;
				ValaMemberAccess* _tmp664_;
				ValaMemberAccess* _tmp665_;
				ValaExpression* _tmp666_;
				ValaExpression* _tmp667_;
				ValaTargetValue* _tmp668_;
				ValaTargetValue* _tmp669_;
				ValaTargetValue* _tmp670_;
				_tmp661_ = ma;
				_tmp662_ = vala_member_access_get_inner (_tmp661_);
				_tmp663_ = _tmp662_;
				_tmp664_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp663_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				inner_ma = _tmp664_;
				_tmp665_ = inner_ma;
				_tmp666_ = vala_member_access_get_inner (_tmp665_);
				_tmp667_ = _tmp666_;
				_tmp668_ = vala_expression_get_target_value (_tmp667_);
				_tmp669_ = _tmp668_;
				_tmp670_ = _vala_target_value_ref0 (_tmp669_);
				_vala_target_value_unref0 (instance_value);
				instance_value = _tmp670_;
				_vala_code_node_unref0 (inner_ma);
			}
			_tmp671_ = instance_value;
			_tmp672_ = vala_get_cvalue_ (_tmp671_);
			_tmp673_ = _vala_ccode_node_ref0 (_tmp672_);
			_vala_ccode_node_unref0 (instance);
			instance = _tmp673_;
			_tmp674_ = m;
			_tmp675_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp674_);
			_tmp676_ = _tmp675_;
			_tmp677_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp676_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp676_) : NULL);
			st = _tmp677_;
			_tmp679_ = st;
			if (_tmp679_ != NULL) {
				ValaStruct* _tmp680_;
				_tmp680_ = st;
				_tmp678_ = !vala_struct_is_simple_type (_tmp680_);
			} else {
				_tmp678_ = FALSE;
			}
			if (_tmp678_) {
				ValaTargetValue* _tmp681_;
				ValaTargetValue* _tmp684_;
				ValaCCodeExpression* _tmp685_;
				ValaCCodeUnaryExpression* _tmp686_;
				_tmp681_ = instance_value;
				if (!vala_get_lvalue (_tmp681_)) {
					ValaTargetValue* _tmp682_;
					ValaTargetValue* _tmp683_;
					_tmp682_ = instance_value;
					_tmp683_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, _tmp682_, (ValaCodeNode*) expr, NULL);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp683_;
				}
				_tmp684_ = instance_value;
				_tmp685_ = vala_get_cvalue_ (_tmp684_);
				_tmp686_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp685_);
				_vala_ccode_node_unref0 (instance);
				instance = (ValaCCodeExpression*) _tmp686_;
			}
			_tmp687_ = m;
			_tmp688_ = vala_method_get_coroutine (_tmp687_);
			_tmp689_ = _tmp688_;
			if (!_tmp689_) {
				ValaHashMap* _tmp690_;
				ValaMethod* _tmp691_;
				ValaCCodeExpression* _tmp692_;
				_tmp690_ = in_arg_map;
				_tmp691_ = m;
				_tmp692_ = instance;
				vala_map_set ((ValaMap*) _tmp690_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp691_), FALSE)), _tmp692_);
			} else {
				gboolean _tmp693_;
				gboolean _tmp694_;
				_tmp693_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) expr);
				_tmp694_ = _tmp693_;
				if (_tmp694_) {
					ValaHashMap* _tmp695_;
					ValaMethod* _tmp696_;
					ValaCCodeExpression* _tmp697_;
					ValaMethod* _tmp698_;
					_tmp695_ = in_arg_map;
					_tmp696_ = m;
					_tmp697_ = instance;
					vala_map_set ((ValaMap*) _tmp695_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp696_), FALSE)), _tmp697_);
					_tmp698_ = m;
					if (vala_get_ccode_finish_instance (_tmp698_)) {
						ValaHashMap* _tmp699_;
						ValaMethod* _tmp700_;
						ValaCCodeExpression* _tmp701_;
						_tmp699_ = out_arg_map;
						_tmp700_ = m;
						_tmp701_ = instance;
						vala_map_set ((ValaMap*) _tmp699_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp700_), FALSE)), _tmp701_);
					}
				} else {
					gboolean _tmp702_ = FALSE;
					ValaMemberAccess* _tmp703_;
					const gchar* _tmp704_;
					const gchar* _tmp705_;
					_tmp703_ = ma;
					_tmp704_ = vala_member_access_get_member_name (_tmp703_);
					_tmp705_ = _tmp704_;
					if (g_strcmp0 (_tmp705_, "end") != 0) {
						_tmp702_ = TRUE;
					} else {
						ValaMethod* _tmp706_;
						_tmp706_ = m;
						_tmp702_ = vala_get_ccode_finish_instance (_tmp706_);
					}
					if (_tmp702_) {
						ValaHashMap* _tmp707_;
						ValaMethod* _tmp708_;
						ValaCCodeExpression* _tmp709_;
						ValaHashMap* _tmp710_;
						ValaMethod* _tmp711_;
						ValaCCodeExpression* _tmp712_;
						_tmp707_ = out_arg_map;
						_tmp708_ = m;
						_tmp709_ = instance;
						vala_map_set ((ValaMap*) _tmp707_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp708_), FALSE)), _tmp709_);
						_tmp710_ = in_arg_map;
						_tmp711_ = m;
						_tmp712_ = instance;
						vala_map_set ((ValaMap*) _tmp710_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp711_), FALSE)), _tmp712_);
					}
				}
			}
			_vala_code_node_unref0 (st);
			_vala_target_value_unref0 (instance_value);
		} else {
			gboolean _tmp713_ = FALSE;
			ValaMethod* _tmp714_;
			_tmp714_ = m;
			if (_tmp714_ != NULL) {
				ValaMethod* _tmp715_;
				ValaMemberBinding _tmp716_;
				ValaMemberBinding _tmp717_;
				_tmp715_ = m;
				_tmp716_ = vala_method_get_binding (_tmp715_);
				_tmp717_ = _tmp716_;
				_tmp713_ = _tmp717_ == VALA_MEMBER_BINDING_CLASS;
			} else {
				_tmp713_ = FALSE;
			}
			if (_tmp713_) {
				ValaClass* cl = NULL;
				ValaMethod* _tmp718_;
				ValaSymbol* _tmp719_;
				ValaSymbol* _tmp720_;
				ValaTargetValue* _tmp721_ = NULL;
				ValaMemberAccess* _tmp722_;
				ValaExpression* _tmp723_;
				ValaExpression* _tmp724_;
				ValaCCodeExpression* cast = NULL;
				ValaClass* _tmp730_;
				ValaCCodeExpression* _tmp731_;
				ValaHashMap* _tmp732_;
				ValaMethod* _tmp733_;
				ValaCCodeExpression* _tmp734_;
				ValaHashMap* _tmp735_;
				ValaMethod* _tmp736_;
				ValaCCodeExpression* _tmp737_;
				_tmp718_ = m;
				_tmp719_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp718_);
				_tmp720_ = _tmp719_;
				cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp720_, VALA_TYPE_CLASS, ValaClass);
				_tmp722_ = ma;
				_tmp723_ = vala_member_access_get_inner (_tmp722_);
				_tmp724_ = _tmp723_;
				if (_tmp724_ != NULL) {
					ValaMemberAccess* _tmp725_;
					ValaExpression* _tmp726_;
					ValaExpression* _tmp727_;
					ValaTargetValue* _tmp728_;
					ValaTargetValue* _tmp729_;
					_tmp725_ = ma;
					_tmp726_ = vala_member_access_get_inner (_tmp725_);
					_tmp727_ = _tmp726_;
					_tmp728_ = vala_expression_get_target_value (_tmp727_);
					_tmp729_ = _tmp728_;
					_tmp721_ = _tmp729_;
				} else {
					_tmp721_ = NULL;
				}
				_tmp730_ = cl;
				_tmp731_ = vala_ccode_base_module_get_this_class_cexpression ((ValaCCodeBaseModule*) self, _tmp730_, _tmp721_);
				cast = _tmp731_;
				_tmp732_ = in_arg_map;
				_tmp733_ = m;
				_tmp734_ = cast;
				vala_map_set ((ValaMap*) _tmp732_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp733_), FALSE)), _tmp734_);
				_tmp735_ = out_arg_map;
				_tmp736_ = m;
				_tmp737_ = cast;
				vala_map_set ((ValaMap*) _tmp735_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp736_), FALSE)), _tmp737_);
				_vala_ccode_node_unref0 (cast);
			}
		}
	}
	_tmp739_ = m;
	if (_tmp739_ != NULL) {
		ValaMethod* _tmp740_;
		_tmp740_ = m;
		_tmp738_ = vala_get_ccode_has_generic_type_parameter (_tmp740_);
	} else {
		_tmp738_ = FALSE;
	}
	if (_tmp738_) {
		ValaMethod* _tmp741_;
		_tmp741_ = m;
		if (vala_method_has_type_parameters (_tmp741_)) {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp742_;
				ValaList* _tmp743_;
				gint _type_arg_size = 0;
				ValaList* _tmp744_;
				gint _tmp745_;
				gint _tmp746_;
				gint _type_arg_index = 0;
				_tmp742_ = ma;
				_tmp743_ = vala_member_access_get_type_arguments (_tmp742_);
				_type_arg_list = _tmp743_;
				_tmp744_ = _type_arg_list;
				_tmp745_ = vala_collection_get_size ((ValaCollection*) _tmp744_);
				_tmp746_ = _tmp745_;
				_type_arg_size = _tmp746_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp747_;
					gint _tmp748_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp749_;
					gpointer _tmp750_;
					gboolean _tmp751_ = FALSE;
					gboolean _tmp752_ = FALSE;
					gboolean _tmp753_ = FALSE;
					ValaMethod* _tmp754_;
					ValaHashMap* _tmp762_;
					ValaMethod* _tmp763_;
					ValaDataType* _tmp764_;
					gchar* _tmp765_;
					gchar* _tmp766_;
					ValaCCodeIdentifier* _tmp767_;
					ValaCCodeIdentifier* _tmp768_;
					gint _tmp769_;
					_type_arg_index = _type_arg_index + 1;
					_tmp747_ = _type_arg_index;
					_tmp748_ = _type_arg_size;
					if (!(_tmp747_ < _tmp748_)) {
						break;
					}
					_tmp749_ = _type_arg_list;
					_tmp750_ = vala_list_get (_tmp749_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp750_;
					_tmp754_ = m;
					if (vala_get_ccode_simple_generics (_tmp754_)) {
						ValaDataType* _tmp755_;
						_tmp755_ = type_arg;
						_tmp753_ = vala_data_type_is_real_struct_type (_tmp755_);
					} else {
						_tmp753_ = FALSE;
					}
					if (_tmp753_) {
						ValaDataType* _tmp756_;
						gboolean _tmp757_;
						gboolean _tmp758_;
						_tmp756_ = type_arg;
						_tmp757_ = vala_data_type_get_nullable (_tmp756_);
						_tmp758_ = _tmp757_;
						_tmp752_ = !_tmp758_;
					} else {
						_tmp752_ = FALSE;
					}
					if (_tmp752_) {
						ValaDataType* _tmp759_;
						_tmp759_ = type_arg;
						_tmp751_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp759_, VALA_TYPE_POINTER_TYPE);
					} else {
						_tmp751_ = FALSE;
					}
					if (_tmp751_) {
						ValaDataType* _tmp760_;
						ValaPointerType* _tmp761_;
						_tmp760_ = type_arg;
						_tmp761_ = vala_pointer_type_new (_tmp760_, NULL);
						_vala_code_node_unref0 (type_arg);
						type_arg = (ValaDataType*) _tmp761_;
					}
					_tmp762_ = in_arg_map;
					_tmp763_ = m;
					_tmp764_ = type_arg;
					_tmp765_ = vala_get_ccode_name ((ValaCodeNode*) _tmp764_);
					_tmp766_ = _tmp765_;
					_tmp767_ = vala_ccode_identifier_new (_tmp766_);
					_tmp768_ = _tmp767_;
					vala_map_set ((ValaMap*) _tmp762_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp763_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp768_);
					_vala_ccode_node_unref0 (_tmp768_);
					_g_free0 (_tmp766_);
					_tmp769_ = type_param_index;
					type_param_index = _tmp769_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
			}
		} else {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp770_;
				ValaExpression* _tmp771_;
				ValaExpression* _tmp772_;
				ValaDataType* _tmp773_;
				ValaDataType* _tmp774_;
				ValaList* _tmp775_;
				gint _type_arg_size = 0;
				ValaList* _tmp776_;
				gint _tmp777_;
				gint _tmp778_;
				gint _type_arg_index = 0;
				_tmp770_ = ma;
				_tmp771_ = vala_member_access_get_inner (_tmp770_);
				_tmp772_ = _tmp771_;
				_tmp773_ = vala_expression_get_value_type (_tmp772_);
				_tmp774_ = _tmp773_;
				_tmp775_ = vala_data_type_get_type_arguments (_tmp774_);
				_type_arg_list = _tmp775_;
				_tmp776_ = _type_arg_list;
				_tmp777_ = vala_collection_get_size ((ValaCollection*) _tmp776_);
				_tmp778_ = _tmp777_;
				_type_arg_size = _tmp778_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp779_;
					gint _tmp780_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp781_;
					gpointer _tmp782_;
					ValaHashMap* _tmp783_;
					ValaMethod* _tmp784_;
					ValaDataType* _tmp785_;
					gchar* _tmp786_;
					gchar* _tmp787_;
					ValaCCodeIdentifier* _tmp788_;
					ValaCCodeIdentifier* _tmp789_;
					gint _tmp790_;
					_type_arg_index = _type_arg_index + 1;
					_tmp779_ = _type_arg_index;
					_tmp780_ = _type_arg_size;
					if (!(_tmp779_ < _tmp780_)) {
						break;
					}
					_tmp781_ = _type_arg_list;
					_tmp782_ = vala_list_get (_tmp781_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp782_;
					_tmp783_ = in_arg_map;
					_tmp784_ = m;
					_tmp785_ = type_arg;
					_tmp786_ = vala_get_ccode_name ((ValaCodeNode*) _tmp785_);
					_tmp787_ = _tmp786_;
					_tmp788_ = vala_ccode_identifier_new (_tmp787_);
					_tmp789_ = _tmp788_;
					vala_map_set ((ValaMap*) _tmp783_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp784_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp789_);
					_vala_ccode_node_unref0 (_tmp789_);
					_g_free0 (_tmp787_);
					_tmp790_ = type_param_index;
					type_param_index = _tmp790_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
			}
		}
	}
	_tmp791_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp791_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp792_;
		ValaExpression* _tmp793_;
		ValaExpression* _tmp794_;
		ValaDataType* _tmp795_;
		ValaDataType* _tmp796_;
		ValaArrayType* _tmp797_;
		ValaCCodeFunctionCall* csizeof = NULL;
		ValaCCodeIdentifier* _tmp798_;
		ValaCCodeIdentifier* _tmp799_;
		ValaCCodeFunctionCall* _tmp800_;
		ValaCCodeFunctionCall* _tmp801_;
		ValaCCodeFunctionCall* _tmp802_;
		ValaArrayType* _tmp803_;
		ValaDataType* _tmp804_;
		ValaDataType* _tmp805_;
		gchar* _tmp806_;
		gchar* _tmp807_;
		ValaCCodeIdentifier* _tmp808_;
		ValaCCodeIdentifier* _tmp809_;
		ValaHashMap* _tmp810_;
		ValaCCodeFunctionCall* _tmp811_;
		_tmp792_ = ma;
		_tmp793_ = vala_member_access_get_inner (_tmp792_);
		_tmp794_ = _tmp793_;
		_tmp795_ = vala_expression_get_value_type (_tmp794_);
		_tmp796_ = _tmp795_;
		_tmp797_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp796_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp797_;
		_tmp798_ = vala_ccode_identifier_new ("sizeof");
		_tmp799_ = _tmp798_;
		_tmp800_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp799_);
		_tmp801_ = _tmp800_;
		_vala_ccode_node_unref0 (_tmp799_);
		csizeof = _tmp801_;
		_tmp802_ = csizeof;
		_tmp803_ = array_type;
		_tmp804_ = vala_array_type_get_element_type (_tmp803_);
		_tmp805_ = _tmp804_;
		_tmp806_ = vala_get_ccode_name ((ValaCodeNode*) _tmp805_);
		_tmp807_ = _tmp806_;
		_tmp808_ = vala_ccode_identifier_new (_tmp807_);
		_tmp809_ = _tmp808_;
		vala_ccode_function_call_add_argument (_tmp802_, (ValaCCodeExpression*) _tmp809_);
		_vala_ccode_node_unref0 (_tmp809_);
		_g_free0 (_tmp807_);
		_tmp810_ = in_arg_map;
		_tmp811_ = csizeof;
		vala_map_set ((ValaMap*) _tmp810_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp811_);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp812_;
		_tmp812_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp812_, VALA_TYPE_DYNAMIC_METHOD)) {
			ValaCCodeBaseModuleEmitContext* _tmp813_;
			ValaMethod* _tmp814_;
			ValaMethod* _tmp815_;
			gint param_nr = 0;
			ValaMethod* _tmp879_;
			ValaCCodeBaseModuleEmitContext* _tmp880_;
			_tmp813_ = ((ValaCCodeBaseModule*) self)->emit_context;
			_tmp814_ = m;
			vala_ccode_base_module_emit_context_push_symbol (_tmp813_, (ValaSymbol*) _tmp814_);
			_tmp815_ = m;
			vala_method_clear_parameters (_tmp815_);
			param_nr = 1;
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp816_;
				gint _arg_size = 0;
				ValaList* _tmp817_;
				gint _tmp818_;
				gint _tmp819_;
				gint _arg_index = 0;
				_tmp816_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) expr);
				_arg_list = _tmp816_;
				_tmp817_ = _arg_list;
				_tmp818_ = vala_collection_get_size ((ValaCollection*) _tmp817_);
				_tmp819_ = _tmp818_;
				_arg_size = _tmp819_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp820_;
					gint _tmp821_;
					ValaExpression* arg = NULL;
					ValaList* _tmp822_;
					gpointer _tmp823_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp824_;
					ValaUnaryExpression* _tmp825_;
					gboolean _tmp826_ = FALSE;
					ValaUnaryExpression* _tmp827_;
					gint _tmp868_;
					_arg_index = _arg_index + 1;
					_tmp820_ = _arg_index;
					_tmp821_ = _arg_size;
					if (!(_tmp820_ < _tmp821_)) {
						break;
					}
					_tmp822_ = _arg_list;
					_tmp823_ = vala_list_get (_tmp822_, _arg_index);
					arg = (ValaExpression*) _tmp823_;
					_tmp824_ = arg;
					_tmp825_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp824_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp824_) : NULL);
					unary = _tmp825_;
					_tmp827_ = unary;
					if (_tmp827_ != NULL) {
						ValaUnaryExpression* _tmp828_;
						ValaUnaryOperator _tmp829_;
						ValaUnaryOperator _tmp830_;
						_tmp828_ = unary;
						_tmp829_ = vala_unary_expression_get_operator (_tmp828_);
						_tmp830_ = _tmp829_;
						_tmp826_ = _tmp830_ == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp826_ = FALSE;
					}
					if (_tmp826_) {
						ValaParameter* param = NULL;
						gchar* _tmp831_;
						gchar* _tmp832_;
						ValaUnaryExpression* _tmp833_;
						ValaExpression* _tmp834_;
						ValaExpression* _tmp835_;
						ValaDataType* _tmp836_;
						ValaDataType* _tmp837_;
						ValaParameter* _tmp838_;
						ValaParameter* _tmp839_;
						ValaParameter* _tmp840_;
						ValaMethod* _tmp841_;
						ValaParameter* _tmp842_;
						_tmp831_ = g_strdup_printf ("param%d", param_nr);
						_tmp832_ = _tmp831_;
						_tmp833_ = unary;
						_tmp834_ = vala_unary_expression_get_inner (_tmp833_);
						_tmp835_ = _tmp834_;
						_tmp836_ = vala_expression_get_value_type (_tmp835_);
						_tmp837_ = _tmp836_;
						_tmp838_ = vala_parameter_new (_tmp832_, _tmp837_, NULL);
						_tmp839_ = _tmp838_;
						_g_free0 (_tmp832_);
						param = _tmp839_;
						_tmp840_ = param;
						vala_parameter_set_direction (_tmp840_, VALA_PARAMETER_DIRECTION_OUT);
						_tmp841_ = m;
						_tmp842_ = param;
						vala_callable_add_parameter ((ValaCallable*) _tmp841_, _tmp842_);
						_vala_code_node_unref0 (param);
					} else {
						gboolean _tmp843_ = FALSE;
						ValaUnaryExpression* _tmp844_;
						_tmp844_ = unary;
						if (_tmp844_ != NULL) {
							ValaUnaryExpression* _tmp845_;
							ValaUnaryOperator _tmp846_;
							ValaUnaryOperator _tmp847_;
							_tmp845_ = unary;
							_tmp846_ = vala_unary_expression_get_operator (_tmp845_);
							_tmp847_ = _tmp846_;
							_tmp843_ = _tmp847_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp843_ = FALSE;
						}
						if (_tmp843_) {
							ValaParameter* param = NULL;
							gchar* _tmp848_;
							gchar* _tmp849_;
							ValaUnaryExpression* _tmp850_;
							ValaExpression* _tmp851_;
							ValaExpression* _tmp852_;
							ValaDataType* _tmp853_;
							ValaDataType* _tmp854_;
							ValaParameter* _tmp855_;
							ValaParameter* _tmp856_;
							ValaParameter* _tmp857_;
							ValaMethod* _tmp858_;
							ValaParameter* _tmp859_;
							_tmp848_ = g_strdup_printf ("param%d", param_nr);
							_tmp849_ = _tmp848_;
							_tmp850_ = unary;
							_tmp851_ = vala_unary_expression_get_inner (_tmp850_);
							_tmp852_ = _tmp851_;
							_tmp853_ = vala_expression_get_value_type (_tmp852_);
							_tmp854_ = _tmp853_;
							_tmp855_ = vala_parameter_new (_tmp849_, _tmp854_, NULL);
							_tmp856_ = _tmp855_;
							_g_free0 (_tmp849_);
							param = _tmp856_;
							_tmp857_ = param;
							vala_parameter_set_direction (_tmp857_, VALA_PARAMETER_DIRECTION_REF);
							_tmp858_ = m;
							_tmp859_ = param;
							vala_callable_add_parameter ((ValaCallable*) _tmp858_, _tmp859_);
							_vala_code_node_unref0 (param);
						} else {
							ValaMethod* _tmp860_;
							gchar* _tmp861_;
							gchar* _tmp862_;
							ValaExpression* _tmp863_;
							ValaDataType* _tmp864_;
							ValaDataType* _tmp865_;
							ValaParameter* _tmp866_;
							ValaParameter* _tmp867_;
							_tmp860_ = m;
							_tmp861_ = g_strdup_printf ("param%d", param_nr);
							_tmp862_ = _tmp861_;
							_tmp863_ = arg;
							_tmp864_ = vala_expression_get_value_type (_tmp863_);
							_tmp865_ = _tmp864_;
							_tmp866_ = vala_parameter_new (_tmp862_, _tmp865_, NULL);
							_tmp867_ = _tmp866_;
							vala_callable_add_parameter ((ValaCallable*) _tmp860_, _tmp867_);
							_vala_code_node_unref0 (_tmp867_);
							_g_free0 (_tmp862_);
						}
					}
					_tmp868_ = param_nr;
					param_nr = _tmp868_ + 1;
					_vala_code_node_unref0 (unary);
					_vala_code_node_unref0 (arg);
				}
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp869_;
				ValaList* _tmp870_;
				gint _param_size = 0;
				ValaList* _tmp871_;
				gint _tmp872_;
				gint _tmp873_;
				gint _param_index = 0;
				_tmp869_ = m;
				_tmp870_ = vala_callable_get_parameters ((ValaCallable*) _tmp869_);
				_param_list = _tmp870_;
				_tmp871_ = _param_list;
				_tmp872_ = vala_collection_get_size ((ValaCollection*) _tmp871_);
				_tmp873_ = _tmp872_;
				_param_size = _tmp873_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp874_;
					gint _tmp875_;
					ValaParameter* param = NULL;
					ValaList* _tmp876_;
					gpointer _tmp877_;
					ValaParameter* _tmp878_;
					_param_index = _param_index + 1;
					_tmp874_ = _param_index;
					_tmp875_ = _param_size;
					if (!(_tmp874_ < _tmp875_)) {
						break;
					}
					_tmp876_ = _param_list;
					_tmp877_ = vala_list_get (_tmp876_, _param_index);
					param = (ValaParameter*) _tmp877_;
					_tmp878_ = param;
					vala_code_node_accept ((ValaCodeNode*) _tmp878_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (param);
				}
			}
			_tmp879_ = m;
			vala_ccode_base_module_generate_dynamic_method_wrapper ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp879_, VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethod));
			_tmp880_ = ((ValaCCodeBaseModule*) self)->emit_context;
			vala_ccode_base_module_emit_context_pop_symbol (_tmp880_);
		} else {
			gboolean _tmp881_ = FALSE;
			gboolean _tmp882_ = FALSE;
			ValaMethod* _tmp883_;
			_tmp883_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp883_, VALA_TYPE_CREATION_METHOD)) {
				ValaCodeContext* _tmp884_;
				ValaCodeContext* _tmp885_;
				ValaProfile _tmp886_;
				ValaProfile _tmp887_;
				_tmp884_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp885_ = _tmp884_;
				_tmp886_ = vala_code_context_get_profile (_tmp885_);
				_tmp887_ = _tmp886_;
				_tmp882_ = _tmp887_ == VALA_PROFILE_GOBJECT;
			} else {
				_tmp882_ = FALSE;
			}
			if (_tmp882_) {
				ValaMethod* _tmp888_;
				ValaSymbol* _tmp889_;
				ValaSymbol* _tmp890_;
				_tmp888_ = m;
				_tmp889_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp888_);
				_tmp890_ = _tmp889_;
				_tmp881_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp890_, VALA_TYPE_CLASS);
			} else {
				_tmp881_ = FALSE;
			}
			if (_tmp881_) {
				ValaCCodeFunction* _tmp891_;
				ValaCCodeFunction* _tmp892_;
				ValaCCodeExpression* _tmp893_;
				ValaCCodeExpression* _tmp894_;
				ValaCCodeFunctionCall* _tmp895_;
				ValaClass* _tmp896_;
				ValaClass* _tmp897_;
				gchar* _tmp898_;
				gchar* _tmp899_;
				gchar* _tmp900_;
				gchar* _tmp901_;
				ValaCCodeCastExpression* _tmp902_;
				ValaCCodeCastExpression* _tmp903_;
				ValaMethod* _tmp904_;
				ValaMethod* _tmp905_;
				ValaBlock* _tmp906_;
				ValaBlock* _tmp907_;
				gboolean _tmp908_;
				gboolean _tmp909_;
				gboolean _tmp936_ = FALSE;
				ValaClass* _tmp937_;
				ValaClass* _tmp938_;
				gboolean _tmp939_;
				gboolean _tmp940_;
				_tmp891_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp892_ = _tmp891_;
				_tmp893_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
				_tmp894_ = _tmp893_;
				_tmp895_ = ccall;
				_tmp896_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp897_ = _tmp896_;
				_tmp898_ = vala_get_ccode_name ((ValaCodeNode*) _tmp897_);
				_tmp899_ = _tmp898_;
				_tmp900_ = g_strconcat (_tmp899_, "*", NULL);
				_tmp901_ = _tmp900_;
				_tmp902_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp895_, _tmp901_);
				_tmp903_ = _tmp902_;
				vala_ccode_function_add_assignment (_tmp892_, _tmp894_, (ValaCCodeExpression*) _tmp903_);
				_vala_ccode_node_unref0 (_tmp903_);
				_g_free0 (_tmp901_);
				_g_free0 (_tmp899_);
				_vala_ccode_node_unref0 (_tmp894_);
				_tmp904_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
				_tmp905_ = _tmp904_;
				_tmp906_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp905_);
				_tmp907_ = _tmp906_;
				_tmp908_ = vala_block_get_captured (_tmp907_);
				_tmp909_ = _tmp908_;
				if (_tmp909_) {
					ValaCCodeFunctionCall* ref_call = NULL;
					ValaClass* _tmp910_;
					ValaClass* _tmp911_;
					ValaObjectType* _tmp912_;
					ValaObjectType* _tmp913_;
					ValaSourceReference* _tmp914_;
					ValaSourceReference* _tmp915_;
					ValaCCodeExpression* _tmp916_;
					ValaCCodeExpression* _tmp917_;
					ValaCCodeFunctionCall* _tmp918_;
					ValaCCodeFunctionCall* _tmp919_;
					ValaCCodeFunctionCall* _tmp920_;
					ValaCCodeExpression* _tmp921_;
					ValaCCodeExpression* _tmp922_;
					ValaCCodeFunction* _tmp923_;
					ValaCCodeFunction* _tmp924_;
					ValaMethod* _tmp925_;
					ValaMethod* _tmp926_;
					ValaBlock* _tmp927_;
					ValaBlock* _tmp928_;
					gchar* _tmp929_;
					gchar* _tmp930_;
					ValaCCodeExpression* _tmp931_;
					ValaCCodeExpression* _tmp932_;
					ValaCCodeMemberAccess* _tmp933_;
					ValaCCodeMemberAccess* _tmp934_;
					ValaCCodeFunctionCall* _tmp935_;
					_tmp910_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp911_ = _tmp910_;
					_tmp912_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp911_);
					_tmp913_ = _tmp912_;
					_tmp914_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
					_tmp915_ = _tmp914_;
					_tmp916_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp913_, _tmp915_, FALSE);
					_tmp917_ = _tmp916_;
					_tmp918_ = vala_ccode_function_call_new (_tmp917_);
					_tmp919_ = _tmp918_;
					_vala_ccode_node_unref0 (_tmp917_);
					_vala_code_node_unref0 (_tmp913_);
					ref_call = _tmp919_;
					_tmp920_ = ref_call;
					_tmp921_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp922_ = _tmp921_;
					vala_ccode_function_call_add_argument (_tmp920_, _tmp922_);
					_vala_ccode_node_unref0 (_tmp922_);
					_tmp923_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp924_ = _tmp923_;
					_tmp925_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
					_tmp926_ = _tmp925_;
					_tmp927_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp926_);
					_tmp928_ = _tmp927_;
					_tmp929_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp928_));
					_tmp930_ = _tmp929_;
					_tmp931_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp930_);
					_tmp932_ = _tmp931_;
					_tmp933_ = vala_ccode_member_access_new_pointer (_tmp932_, "self");
					_tmp934_ = _tmp933_;
					_tmp935_ = ref_call;
					vala_ccode_function_add_assignment (_tmp924_, (ValaCCodeExpression*) _tmp934_, (ValaCCodeExpression*) _tmp935_);
					_vala_ccode_node_unref0 (_tmp934_);
					_vala_ccode_node_unref0 (_tmp932_);
					_g_free0 (_tmp930_);
					_vala_ccode_node_unref0 (ref_call);
				}
				_tmp937_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp938_ = _tmp937_;
				_tmp939_ = vala_class_get_is_compact (_tmp938_);
				_tmp940_ = _tmp939_;
				if (!_tmp940_) {
					ValaClass* _tmp941_;
					ValaClass* _tmp942_;
					_tmp941_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp942_ = _tmp941_;
					_tmp936_ = vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) _tmp942_);
				} else {
					_tmp936_ = FALSE;
				}
				if (_tmp936_) {
					ValaCCodeMemberAccess* priv_access = NULL;
					ValaCCodeIdentifier* _tmp943_;
					ValaCCodeIdentifier* _tmp944_;
					ValaCCodeMemberAccess* _tmp945_;
					ValaCCodeMemberAccess* _tmp946_;
					_tmp943_ = vala_ccode_identifier_new ("self");
					_tmp944_ = _tmp943_;
					_tmp945_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp944_, "priv");
					_tmp946_ = _tmp945_;
					_vala_ccode_node_unref0 (_tmp944_);
					priv_access = _tmp946_;
					{
						ValaList* _type_param_list = NULL;
						ValaClass* _tmp947_;
						ValaClass* _tmp948_;
						ValaList* _tmp949_;
						gint _type_param_size = 0;
						ValaList* _tmp950_;
						gint _tmp951_;
						gint _tmp952_;
						gint _type_param_index = 0;
						_tmp947_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp948_ = _tmp947_;
						_tmp949_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp948_);
						_type_param_list = _tmp949_;
						_tmp950_ = _type_param_list;
						_tmp951_ = vala_collection_get_size ((ValaCollection*) _tmp950_);
						_tmp952_ = _tmp951_;
						_type_param_size = _tmp952_;
						_type_param_index = -1;
						while (TRUE) {
							gint _tmp953_;
							gint _tmp954_;
							ValaTypeParameter* type_param = NULL;
							ValaList* _tmp955_;
							gpointer _tmp956_;
							gchar* type = NULL;
							ValaTypeParameter* _tmp957_;
							gchar* _tmp958_;
							gchar* dup_func = NULL;
							ValaTypeParameter* _tmp959_;
							gchar* _tmp960_;
							gchar* destroy_func = NULL;
							ValaTypeParameter* _tmp961_;
							gchar* _tmp962_;
							ValaCCodeFunction* _tmp963_;
							ValaCCodeFunction* _tmp964_;
							ValaCCodeMemberAccess* _tmp965_;
							const gchar* _tmp966_;
							ValaCCodeMemberAccess* _tmp967_;
							ValaCCodeMemberAccess* _tmp968_;
							const gchar* _tmp969_;
							ValaCCodeIdentifier* _tmp970_;
							ValaCCodeIdentifier* _tmp971_;
							ValaCCodeFunction* _tmp972_;
							ValaCCodeFunction* _tmp973_;
							ValaCCodeMemberAccess* _tmp974_;
							const gchar* _tmp975_;
							ValaCCodeMemberAccess* _tmp976_;
							ValaCCodeMemberAccess* _tmp977_;
							const gchar* _tmp978_;
							ValaCCodeIdentifier* _tmp979_;
							ValaCCodeIdentifier* _tmp980_;
							ValaCCodeFunction* _tmp981_;
							ValaCCodeFunction* _tmp982_;
							ValaCCodeMemberAccess* _tmp983_;
							const gchar* _tmp984_;
							ValaCCodeMemberAccess* _tmp985_;
							ValaCCodeMemberAccess* _tmp986_;
							const gchar* _tmp987_;
							ValaCCodeIdentifier* _tmp988_;
							ValaCCodeIdentifier* _tmp989_;
							_type_param_index = _type_param_index + 1;
							_tmp953_ = _type_param_index;
							_tmp954_ = _type_param_size;
							if (!(_tmp953_ < _tmp954_)) {
								break;
							}
							_tmp955_ = _type_param_list;
							_tmp956_ = vala_list_get (_tmp955_, _type_param_index);
							type_param = (ValaTypeParameter*) _tmp956_;
							_tmp957_ = type_param;
							_tmp958_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp957_);
							type = _tmp958_;
							_tmp959_ = type_param;
							_tmp960_ = vala_get_ccode_copy_function ((ValaTypeSymbol*) _tmp959_);
							dup_func = _tmp960_;
							_tmp961_ = type_param;
							_tmp962_ = vala_get_ccode_destroy_function ((ValaTypeSymbol*) _tmp961_);
							destroy_func = _tmp962_;
							_tmp963_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
							_tmp964_ = _tmp963_;
							_tmp965_ = priv_access;
							_tmp966_ = type;
							_tmp967_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp965_, _tmp966_);
							_tmp968_ = _tmp967_;
							_tmp969_ = type;
							_tmp970_ = vala_ccode_identifier_new (_tmp969_);
							_tmp971_ = _tmp970_;
							vala_ccode_function_add_assignment (_tmp964_, (ValaCCodeExpression*) _tmp968_, (ValaCCodeExpression*) _tmp971_);
							_vala_ccode_node_unref0 (_tmp971_);
							_vala_ccode_node_unref0 (_tmp968_);
							_tmp972_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
							_tmp973_ = _tmp972_;
							_tmp974_ = priv_access;
							_tmp975_ = dup_func;
							_tmp976_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp974_, _tmp975_);
							_tmp977_ = _tmp976_;
							_tmp978_ = dup_func;
							_tmp979_ = vala_ccode_identifier_new (_tmp978_);
							_tmp980_ = _tmp979_;
							vala_ccode_function_add_assignment (_tmp973_, (ValaCCodeExpression*) _tmp977_, (ValaCCodeExpression*) _tmp980_);
							_vala_ccode_node_unref0 (_tmp980_);
							_vala_ccode_node_unref0 (_tmp977_);
							_tmp981_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
							_tmp982_ = _tmp981_;
							_tmp983_ = priv_access;
							_tmp984_ = destroy_func;
							_tmp985_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp983_, _tmp984_);
							_tmp986_ = _tmp985_;
							_tmp987_ = destroy_func;
							_tmp988_ = vala_ccode_identifier_new (_tmp987_);
							_tmp989_ = _tmp988_;
							vala_ccode_function_add_assignment (_tmp982_, (ValaCCodeExpression*) _tmp986_, (ValaCCodeExpression*) _tmp989_);
							_vala_ccode_node_unref0 (_tmp989_);
							_vala_ccode_node_unref0 (_tmp986_);
							_g_free0 (destroy_func);
							_g_free0 (dup_func);
							_g_free0 (type);
							_vala_code_node_unref0 (type_param);
						}
					}
					_vala_ccode_node_unref0 (priv_access);
				}
				_vala_ccode_node_unref0 (ccall_expr);
				ccall_expr = NULL;
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	_tmp990_ = params;
	_tmp991_ = vala_iterable_iterator ((ValaIterable*) _tmp990_);
	params_it = _tmp991_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp992_;
		gint _arg_size = 0;
		ValaList* _tmp993_;
		gint _tmp994_;
		gint _tmp995_;
		gint _arg_index = 0;
		_tmp992_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) expr);
		_arg_list = _tmp992_;
		_tmp993_ = _arg_list;
		_tmp994_ = vala_collection_get_size ((ValaCollection*) _tmp993_);
		_tmp995_ = _tmp994_;
		_arg_size = _tmp995_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp996_;
			gint _tmp997_;
			ValaExpression* arg = NULL;
			ValaList* _tmp998_;
			gpointer _tmp999_;
			ValaCCodeExpression* cexpr = NULL;
			ValaExpression* _tmp1000_;
			ValaCCodeExpression* _tmp1001_;
			ValaCCodeExpression* _tmp1002_;
			ValaHashMap* carg_map = NULL;
			ValaHashMap* _tmp1003_;
			ValaHashMap* _tmp1004_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp1005_;
			gboolean _tmp1015_ = FALSE;
			ValaParameter* _tmp1016_;
			gdouble _tmp1360_ = 0.0;
			gboolean _tmp1361_ = FALSE;
			ValaParameter* _tmp1362_;
			ValaHashMap* _tmp1364_;
			ValaCCodeExpression* _tmp1365_;
			gboolean _tmp1366_ = FALSE;
			ValaMethod* _tmp1367_;
			gboolean _tmp1392_ = FALSE;
			ValaExpression* _tmp1393_;
			gint _tmp1410_;
			_arg_index = _arg_index + 1;
			_tmp996_ = _arg_index;
			_tmp997_ = _arg_size;
			if (!(_tmp996_ < _tmp997_)) {
				break;
			}
			_tmp998_ = _arg_list;
			_tmp999_ = vala_list_get (_tmp998_, _arg_index);
			arg = (ValaExpression*) _tmp999_;
			_tmp1000_ = arg;
			_tmp1001_ = vala_get_cvalue (_tmp1000_);
			_tmp1002_ = _vala_ccode_node_ref0 (_tmp1001_);
			cexpr = _tmp1002_;
			_tmp1003_ = in_arg_map;
			_tmp1004_ = _vala_map_ref0 (_tmp1003_);
			carg_map = _tmp1004_;
			param = NULL;
			_tmp1005_ = params_it;
			if (vala_iterator_next (_tmp1005_)) {
				ValaIterator* _tmp1006_;
				gpointer _tmp1007_;
				gboolean _tmp1008_ = FALSE;
				ValaParameter* _tmp1009_;
				gboolean _tmp1010_;
				gboolean _tmp1011_;
				_tmp1006_ = params_it;
				_tmp1007_ = vala_iterator_get (_tmp1006_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp1007_;
				_tmp1009_ = param;
				_tmp1010_ = vala_parameter_get_params_array (_tmp1009_);
				_tmp1011_ = _tmp1010_;
				if (_tmp1011_) {
					_tmp1008_ = TRUE;
				} else {
					ValaParameter* _tmp1012_;
					gboolean _tmp1013_;
					gboolean _tmp1014_;
					_tmp1012_ = param;
					_tmp1013_ = vala_parameter_get_ellipsis (_tmp1012_);
					_tmp1014_ = _tmp1013_;
					_tmp1008_ = _tmp1014_;
				}
				ellipsis = _tmp1008_;
			}
			_tmp1016_ = param;
			if (_tmp1016_ != NULL) {
				_tmp1015_ = !ellipsis;
			} else {
				_tmp1015_ = FALSE;
			}
			if (_tmp1015_) {
				ValaParameter* _tmp1017_;
				ValaParameterDirection _tmp1018_;
				ValaParameterDirection _tmp1019_;
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp1022_;
				ValaUnaryExpression* _tmp1023_;
				gboolean _tmp1024_ = FALSE;
				ValaUnaryExpression* _tmp1025_;
				ValaParameter* _tmp1290_;
				gchar* _tmp1291_;
				gchar* _tmp1292_;
				gboolean _tmp1293_;
				_tmp1017_ = param;
				_tmp1018_ = vala_parameter_get_direction (_tmp1017_);
				_tmp1019_ = _tmp1018_;
				if (_tmp1019_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaHashMap* _tmp1020_;
					ValaHashMap* _tmp1021_;
					_tmp1020_ = out_arg_map;
					_tmp1021_ = _vala_map_ref0 (_tmp1020_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp1021_;
				}
				_tmp1022_ = arg;
				_tmp1023_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1022_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1022_) : NULL);
				unary = _tmp1023_;
				_tmp1025_ = unary;
				if (_tmp1025_ == NULL) {
					_tmp1024_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp1026_;
					ValaUnaryOperator _tmp1027_;
					ValaUnaryOperator _tmp1028_;
					_tmp1026_ = unary;
					_tmp1027_ = vala_unary_expression_get_operator (_tmp1026_);
					_tmp1028_ = _tmp1027_;
					_tmp1024_ = _tmp1028_ != VALA_UNARY_OPERATOR_OUT;
				}
				if (_tmp1024_) {
					gboolean _tmp1029_ = FALSE;
					gboolean _tmp1030_ = FALSE;
					ValaParameter* _tmp1031_;
					ValaParameter* _tmp1173_;
					ValaExpression* _tmp1174_;
					ValaCCodeExpression* _tmp1175_;
					ValaCCodeExpression* _tmp1176_;
					_tmp1031_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1031_)) {
						ValaParameter* _tmp1032_;
						ValaDataType* _tmp1033_;
						ValaDataType* _tmp1034_;
						_tmp1032_ = param;
						_tmp1033_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1032_);
						_tmp1034_ = _tmp1033_;
						_tmp1030_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1034_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp1030_ = FALSE;
					}
					if (_tmp1030_) {
						ValaParameter* _tmp1035_;
						ValaDataType* _tmp1036_;
						ValaDataType* _tmp1037_;
						gboolean _tmp1038_;
						gboolean _tmp1039_;
						_tmp1035_ = param;
						_tmp1036_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1035_);
						_tmp1037_ = _tmp1036_;
						_tmp1038_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp1037_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp1039_ = _tmp1038_;
						_tmp1029_ = !_tmp1039_;
					} else {
						_tmp1029_ = FALSE;
					}
					if (_tmp1029_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp1040_;
						ValaDataType* _tmp1041_;
						ValaDataType* _tmp1042_;
						ValaArrayType* _tmp1043_;
						gchar* length_ctype = NULL;
						ValaParameter* _tmp1044_;
						gchar* _tmp1045_;
						gboolean _tmp1046_ = FALSE;
						ValaUnaryExpression* _tmp1047_;
						_tmp1040_ = param;
						_tmp1041_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1040_);
						_tmp1042_ = _tmp1041_;
						_tmp1043_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1042_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp1043_;
						_tmp1044_ = param;
						_tmp1045_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1044_);
						length_ctype = _tmp1045_;
						_tmp1047_ = unary;
						if (_tmp1047_ != NULL) {
							ValaUnaryExpression* _tmp1048_;
							ValaUnaryOperator _tmp1049_;
							ValaUnaryOperator _tmp1050_;
							_tmp1048_ = unary;
							_tmp1049_ = vala_unary_expression_get_operator (_tmp1048_);
							_tmp1050_ = _tmp1049_;
							_tmp1046_ = _tmp1050_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp1046_ = FALSE;
						}
						if (_tmp1046_) {
							const gchar* _tmp1051_;
							gchar* _tmp1052_;
							_tmp1051_ = length_ctype;
							_tmp1052_ = g_strdup_printf ("%s*", _tmp1051_);
							_g_free0 (length_ctype);
							length_ctype = _tmp1052_;
						}
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp1053_ = FALSE;
								_tmp1053_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp1055_;
									gint _tmp1056_;
									gint _tmp1057_;
									ValaCCodeCastExpression* array_length_expr = NULL;
									ValaExpression* _tmp1058_;
									ValaCCodeExpression* _tmp1059_;
									ValaCCodeExpression* _tmp1060_;
									const gchar* _tmp1061_;
									ValaCCodeCastExpression* _tmp1062_;
									ValaCCodeCastExpression* _tmp1063_;
									ValaHashMap* _tmp1064_;
									ValaParameter* _tmp1065_;
									ValaCCodeCastExpression* _tmp1066_;
									if (!_tmp1053_) {
										gint _tmp1054_;
										_tmp1054_ = dim;
										dim = _tmp1054_ + 1;
									}
									_tmp1053_ = FALSE;
									_tmp1055_ = array_type;
									_tmp1056_ = vala_array_type_get_rank (_tmp1055_);
									_tmp1057_ = _tmp1056_;
									if (!(dim <= _tmp1057_)) {
										break;
									}
									_tmp1058_ = arg;
									_tmp1059_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1058_, dim);
									_tmp1060_ = _tmp1059_;
									_tmp1061_ = length_ctype;
									_tmp1062_ = vala_ccode_cast_expression_new (_tmp1060_, _tmp1061_);
									_tmp1063_ = _tmp1062_;
									_vala_ccode_node_unref0 (_tmp1060_);
									array_length_expr = _tmp1063_;
									_tmp1064_ = carg_map;
									_tmp1065_ = param;
									_tmp1066_ = array_length_expr;
									vala_map_set ((ValaMap*) _tmp1064_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1065_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1066_);
									_vala_ccode_node_unref0 (array_length_expr);
								}
							}
						}
						_g_free0 (length_ctype);
						_vala_code_node_unref0 (array_type);
					} else {
						gboolean _tmp1067_ = FALSE;
						ValaParameter* _tmp1068_;
						_tmp1068_ = param;
						if (vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1068_)) {
							ValaParameter* _tmp1069_;
							ValaDataType* _tmp1070_;
							ValaDataType* _tmp1071_;
							_tmp1069_ = param;
							_tmp1070_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1069_);
							_tmp1071_ = _tmp1070_;
							_tmp1067_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1071_, VALA_TYPE_DELEGATE_TYPE);
						} else {
							_tmp1067_ = FALSE;
						}
						if (_tmp1067_) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp1072_;
							ValaDataType* _tmp1073_;
							ValaDataType* _tmp1074_;
							ValaDelegateType* _tmp1075_;
							ValaDelegateType* _tmp1076_;
							ValaDelegate* _tmp1077_;
							ValaDelegate* _tmp1078_;
							gboolean _tmp1079_;
							gboolean _tmp1080_;
							_tmp1072_ = param;
							_tmp1073_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1072_);
							_tmp1074_ = _tmp1073_;
							_tmp1075_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1074_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp1075_;
							_tmp1076_ = deleg_type;
							_tmp1077_ = vala_delegate_type_get_delegate_symbol (_tmp1076_);
							_tmp1078_ = _tmp1077_;
							_tmp1079_ = vala_delegate_get_has_target (_tmp1078_);
							_tmp1080_ = _tmp1079_;
							if (_tmp1080_) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaCCodeExpression* delegate_target = NULL;
								ValaExpression* _tmp1081_;
								ValaCCodeExpression* _tmp1082_ = NULL;
								ValaCCodeExpression* _tmp1083_;
								ValaCCodeExpression* _tmp1084_;
								ValaParameter* _tmp1085_;
								gchar* _tmp1086_;
								gchar* _tmp1087_;
								gboolean _tmp1088_;
								_tmp1081_ = arg;
								_tmp1083_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1081_, &_tmp1082_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp1082_;
								delegate_target = _tmp1083_;
								_tmp1084_ = delegate_target;
								_vala_assert (_tmp1084_ != NULL, "delegate_target != null");
								_tmp1085_ = param;
								_tmp1086_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1085_);
								_tmp1087_ = _tmp1086_;
								_tmp1088_ = g_strcmp0 (_tmp1087_, "GClosure*") == 0;
								_g_free0 (_tmp1087_);
								if (_tmp1088_) {
									ValaCCodeFunctionCall* closure_new = NULL;
									ValaCCodeIdentifier* _tmp1089_;
									ValaCCodeIdentifier* _tmp1090_;
									ValaCCodeFunctionCall* _tmp1091_;
									ValaCCodeFunctionCall* _tmp1092_;
									ValaCCodeFunctionCall* _tmp1093_;
									ValaCCodeExpression* _tmp1094_;
									ValaCCodeCastExpression* _tmp1095_;
									ValaCCodeCastExpression* _tmp1096_;
									ValaCCodeFunctionCall* _tmp1097_;
									ValaCCodeExpression* _tmp1098_;
									ValaCCodeFunctionCall* _tmp1099_;
									ValaCCodeExpression* _tmp1100_;
									ValaCCodeCastExpression* _tmp1101_;
									ValaCCodeCastExpression* _tmp1102_;
									ValaCCodeExpression* _tmp1103_;
									ValaCCodeConstant* _tmp1104_;
									ValaCCodeConstant* _tmp1105_;
									ValaCCodeBinaryExpression* _tmp1106_;
									ValaCCodeBinaryExpression* _tmp1107_;
									ValaCCodeConstant* _tmp1108_;
									ValaCCodeConstant* _tmp1109_;
									ValaCCodeFunctionCall* _tmp1110_;
									ValaCCodeConditionalExpression* _tmp1111_;
									_tmp1089_ = vala_ccode_identifier_new ("g_cclosure_new");
									_tmp1090_ = _tmp1089_;
									_tmp1091_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1090_);
									_tmp1092_ = _tmp1091_;
									_vala_ccode_node_unref0 (_tmp1090_);
									closure_new = _tmp1092_;
									_tmp1093_ = closure_new;
									_tmp1094_ = cexpr;
									_tmp1095_ = vala_ccode_cast_expression_new (_tmp1094_, "GCallback");
									_tmp1096_ = _tmp1095_;
									vala_ccode_function_call_add_argument (_tmp1093_, (ValaCCodeExpression*) _tmp1096_);
									_vala_ccode_node_unref0 (_tmp1096_);
									_tmp1097_ = closure_new;
									_tmp1098_ = delegate_target;
									vala_ccode_function_call_add_argument (_tmp1097_, _tmp1098_);
									_tmp1099_ = closure_new;
									_tmp1100_ = delegate_target_destroy_notify;
									_tmp1101_ = vala_ccode_cast_expression_new (_tmp1100_, "GClosureNotify");
									_tmp1102_ = _tmp1101_;
									vala_ccode_function_call_add_argument (_tmp1099_, (ValaCCodeExpression*) _tmp1102_);
									_vala_ccode_node_unref0 (_tmp1102_);
									_tmp1103_ = cexpr;
									_tmp1104_ = vala_ccode_constant_new ("NULL");
									_tmp1105_ = _tmp1104_;
									_tmp1106_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp1103_, (ValaCCodeExpression*) _tmp1105_);
									_tmp1107_ = _tmp1106_;
									_tmp1108_ = vala_ccode_constant_new ("NULL");
									_tmp1109_ = _tmp1108_;
									_tmp1110_ = closure_new;
									_tmp1111_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1107_, (ValaCCodeExpression*) _tmp1109_, (ValaCCodeExpression*) _tmp1110_);
									_vala_ccode_node_unref0 (cexpr);
									cexpr = (ValaCCodeExpression*) _tmp1111_;
									_vala_ccode_node_unref0 (_tmp1109_);
									_vala_ccode_node_unref0 (_tmp1107_);
									_vala_ccode_node_unref0 (_tmp1105_);
									_vala_ccode_node_unref0 (closure_new);
								} else {
									ValaCCodeExpression* node = NULL;
									ValaHashMap* _tmp1112_;
									ValaParameter* _tmp1113_;
									gpointer _tmp1114_;
									gboolean _tmp1115_ = FALSE;
									ValaCCodeExpression* _tmp1116_;
									_tmp1112_ = carg_map;
									_tmp1113_ = param;
									_tmp1114_ = vala_map_get ((ValaMap*) _tmp1112_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1113_), FALSE)));
									node = (ValaCCodeExpression*) _tmp1114_;
									_tmp1116_ = node;
									if (_tmp1116_ == NULL) {
										_tmp1115_ = TRUE;
									} else {
										gboolean _tmp1117_ = FALSE;
										ValaCCodeExpression* _tmp1118_;
										_tmp1118_ = node;
										if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1118_, VALA_TYPE_CCODE_CONSTANT)) {
											ValaCCodeExpression* _tmp1119_;
											const gchar* _tmp1120_;
											const gchar* _tmp1121_;
											_tmp1119_ = node;
											_tmp1120_ = vala_ccode_constant_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp1119_, VALA_TYPE_CCODE_CONSTANT, ValaCCodeConstant));
											_tmp1121_ = _tmp1120_;
											_tmp1117_ = g_strcmp0 (_tmp1121_, "NULL") == 0;
										} else {
											_tmp1117_ = FALSE;
										}
										_tmp1115_ = _tmp1117_;
									}
									if (_tmp1115_) {
										ValaHashMap* _tmp1122_;
										ValaParameter* _tmp1123_;
										ValaCCodeExpression* _tmp1124_;
										ValaDelegateType* _tmp1125_;
										_tmp1122_ = carg_map;
										_tmp1123_ = param;
										_tmp1124_ = delegate_target;
										vala_map_set ((ValaMap*) _tmp1122_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1123_), FALSE)), _tmp1124_);
										_tmp1125_ = deleg_type;
										if (vala_data_type_is_disposable ((ValaDataType*) _tmp1125_)) {
											ValaCCodeExpression* _tmp1126_;
											ValaHashMap* _tmp1127_;
											ValaParameter* _tmp1128_;
											ValaCCodeExpression* _tmp1129_;
											_tmp1126_ = delegate_target_destroy_notify;
											_vala_assert (_tmp1126_ != NULL, "delegate_target_destroy_notify != null");
											_tmp1127_ = carg_map;
											_tmp1128_ = param;
											_tmp1129_ = delegate_target_destroy_notify;
											vala_map_set ((ValaMap*) _tmp1127_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1128_), FALSE)), _tmp1129_);
										}
									}
									_vala_ccode_node_unref0 (node);
								}
								_vala_ccode_node_unref0 (delegate_target);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							}
							_vala_code_node_unref0 (deleg_type);
						} else {
							ValaParameter* _tmp1130_;
							ValaDataType* _tmp1131_;
							ValaDataType* _tmp1132_;
							_tmp1130_ = param;
							_tmp1131_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1130_);
							_tmp1132_ = _tmp1131_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1132_, VALA_TYPE_METHOD_TYPE)) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaHashMap* _tmp1133_;
								ValaParameter* _tmp1134_;
								ValaExpression* _tmp1135_;
								ValaCCodeExpression* _tmp1136_ = NULL;
								ValaCCodeExpression* _tmp1137_;
								ValaCCodeExpression* _tmp1138_;
								_tmp1133_ = carg_map;
								_tmp1134_ = param;
								_tmp1135_ = arg;
								_tmp1137_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1135_, &_tmp1136_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp1136_;
								_tmp1138_ = _tmp1137_;
								vala_map_set ((ValaMap*) _tmp1133_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1134_), FALSE)), _tmp1138_);
								_vala_ccode_node_unref0 (_tmp1138_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							} else {
								ValaParameter* _tmp1139_;
								ValaDataType* _tmp1140_;
								ValaDataType* _tmp1141_;
								_tmp1139_ = param;
								_tmp1140_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1139_);
								_tmp1141_ = _tmp1140_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1141_, VALA_TYPE_GENERIC_TYPE)) {
									gboolean _tmp1142_ = FALSE;
									ValaMethod* _tmp1143_;
									_tmp1143_ = m;
									if (_tmp1143_ != NULL) {
										ValaMethod* _tmp1144_;
										_tmp1144_ = m;
										_tmp1142_ = vala_get_ccode_simple_generics (_tmp1144_);
									} else {
										_tmp1142_ = FALSE;
									}
									if (_tmp1142_) {
										ValaGenericType* generic_type = NULL;
										ValaParameter* _tmp1145_;
										ValaDataType* _tmp1146_;
										ValaDataType* _tmp1147_;
										ValaGenericType* _tmp1148_;
										gint type_param_index = 0;
										ValaMethod* _tmp1149_;
										ValaGenericType* _tmp1150_;
										ValaTypeParameter* _tmp1151_;
										ValaTypeParameter* _tmp1152_;
										const gchar* _tmp1153_;
										const gchar* _tmp1154_;
										ValaDataType* type_arg = NULL;
										ValaMemberAccess* _tmp1155_;
										ValaList* _tmp1156_;
										gpointer _tmp1157_;
										ValaParameter* _tmp1158_;
										ValaDataType* _tmp1159_;
										ValaDataType* _tmp1160_;
										gboolean _tmp1161_;
										gboolean _tmp1162_;
										_tmp1145_ = param;
										_tmp1146_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1145_);
										_tmp1147_ = _tmp1146_;
										_tmp1148_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1147_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
										generic_type = _tmp1148_;
										_tmp1149_ = m;
										_tmp1150_ = generic_type;
										_tmp1151_ = vala_generic_type_get_type_parameter (_tmp1150_);
										_tmp1152_ = _tmp1151_;
										_tmp1153_ = vala_symbol_get_name ((ValaSymbol*) _tmp1152_);
										_tmp1154_ = _tmp1153_;
										type_param_index = vala_method_get_type_parameter_index (_tmp1149_, _tmp1154_);
										_tmp1155_ = ma;
										_tmp1156_ = vala_member_access_get_type_arguments (_tmp1155_);
										_tmp1157_ = vala_list_get (_tmp1156_, type_param_index);
										type_arg = (ValaDataType*) _tmp1157_;
										_tmp1158_ = param;
										_tmp1159_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1158_);
										_tmp1160_ = _tmp1159_;
										_tmp1161_ = vala_data_type_get_value_owned (_tmp1160_);
										_tmp1162_ = _tmp1161_;
										if (_tmp1162_) {
											ValaDataType* _tmp1163_;
											_tmp1163_ = type_arg;
											if (vala_ccode_base_module_requires_copy (_tmp1163_)) {
												ValaHashMap* _tmp1164_;
												ValaParameter* _tmp1165_;
												ValaDataType* _tmp1166_;
												ValaCCodeExpression* _tmp1167_;
												ValaCCodeExpression* _tmp1168_;
												_tmp1164_ = carg_map;
												_tmp1165_ = param;
												_tmp1166_ = type_arg;
												_tmp1167_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, _tmp1166_, FALSE);
												_tmp1168_ = _tmp1167_;
												vala_map_set ((ValaMap*) _tmp1164_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1165_), FALSE)), _tmp1168_);
												_vala_ccode_node_unref0 (_tmp1168_);
											} else {
												ValaHashMap* _tmp1169_;
												ValaParameter* _tmp1170_;
												ValaCCodeConstant* _tmp1171_;
												ValaCCodeConstant* _tmp1172_;
												_tmp1169_ = carg_map;
												_tmp1170_ = param;
												_tmp1171_ = vala_ccode_constant_new ("NULL");
												_tmp1172_ = _tmp1171_;
												vala_map_set ((ValaMap*) _tmp1169_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1170_), FALSE)), (ValaCCodeExpression*) _tmp1172_);
												_vala_ccode_node_unref0 (_tmp1172_);
											}
										}
										_vala_code_node_unref0 (type_arg);
										_vala_code_node_unref0 (generic_type);
									}
								}
							}
						}
					}
					_tmp1173_ = param;
					_tmp1174_ = arg;
					_tmp1175_ = cexpr;
					_tmp1176_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, _tmp1173_, _tmp1174_, _tmp1175_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1176_;
				} else {
					ValaExpression* _tmp1177_;
					ValaLocalVariable* temp_var = NULL;
					ValaParameter* _tmp1178_;
					ValaDataType* _tmp1179_;
					ValaDataType* _tmp1180_;
					ValaParameter* _tmp1181_;
					ValaDataType* _tmp1182_;
					ValaDataType* _tmp1183_;
					gboolean _tmp1184_;
					gboolean _tmp1185_;
					ValaLocalVariable* _tmp1186_;
					ValaLocalVariable* _tmp1187_;
					ValaExpression* _tmp1188_;
					ValaLocalVariable* _tmp1189_;
					const gchar* _tmp1190_;
					const gchar* _tmp1191_;
					ValaCCodeExpression* _tmp1192_;
					ValaCCodeExpression* _tmp1193_;
					ValaExpression* _tmp1194_;
					ValaTargetValue* _tmp1195_;
					ValaTargetValue* _tmp1196_;
					ValaExpression* _tmp1197_;
					ValaDataType* _tmp1198_;
					ValaDataType* _tmp1199_;
					ValaExpression* _tmp1200_;
					ValaCCodeExpression* _tmp1201_;
					ValaCCodeUnaryExpression* _tmp1202_;
					gboolean _tmp1203_ = FALSE;
					gboolean _tmp1204_ = FALSE;
					ValaParameter* _tmp1205_;
					_tmp1177_ = arg;
					vala_expression_set_target_value (_tmp1177_, NULL);
					_tmp1178_ = param;
					_tmp1179_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1178_);
					_tmp1180_ = _tmp1179_;
					_tmp1181_ = param;
					_tmp1182_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1181_);
					_tmp1183_ = _tmp1182_;
					_tmp1184_ = vala_data_type_get_value_owned (_tmp1183_);
					_tmp1185_ = _tmp1184_;
					_tmp1186_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1180_, _tmp1185_, NULL, TRUE);
					temp_var = _tmp1186_;
					_tmp1187_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1187_, FALSE);
					_tmp1188_ = arg;
					_tmp1189_ = temp_var;
					_tmp1190_ = vala_symbol_get_name ((ValaSymbol*) _tmp1189_);
					_tmp1191_ = _tmp1190_;
					_tmp1192_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1191_);
					_tmp1193_ = _tmp1192_;
					vala_set_cvalue (_tmp1188_, _tmp1193_);
					_vala_ccode_node_unref0 (_tmp1193_);
					_tmp1194_ = arg;
					_tmp1195_ = vala_expression_get_target_value (_tmp1194_);
					_tmp1196_ = _tmp1195_;
					_tmp1197_ = arg;
					_tmp1198_ = vala_expression_get_target_type (_tmp1197_);
					_tmp1199_ = _tmp1198_;
					vala_target_value_set_value_type (_tmp1196_, _tmp1199_);
					_tmp1200_ = arg;
					_tmp1201_ = vala_get_cvalue (_tmp1200_);
					_tmp1202_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1201_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1202_;
					_tmp1205_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1205_)) {
						ValaParameter* _tmp1206_;
						ValaDataType* _tmp1207_;
						ValaDataType* _tmp1208_;
						_tmp1206_ = param;
						_tmp1207_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1206_);
						_tmp1208_ = _tmp1207_;
						_tmp1204_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1208_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp1204_ = FALSE;
					}
					if (_tmp1204_) {
						ValaParameter* _tmp1209_;
						ValaDataType* _tmp1210_;
						ValaDataType* _tmp1211_;
						gboolean _tmp1212_;
						gboolean _tmp1213_;
						_tmp1209_ = param;
						_tmp1210_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1209_);
						_tmp1211_ = _tmp1210_;
						_tmp1212_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp1211_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp1213_ = _tmp1212_;
						_tmp1203_ = !_tmp1213_;
					} else {
						_tmp1203_ = FALSE;
					}
					if (_tmp1203_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp1214_;
						ValaDataType* _tmp1215_;
						ValaDataType* _tmp1216_;
						ValaArrayType* _tmp1217_;
						gchar* length_ctype = NULL;
						ValaParameter* _tmp1218_;
						gchar* _tmp1219_;
						_tmp1214_ = param;
						_tmp1215_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1214_);
						_tmp1216_ = _tmp1215_;
						_tmp1217_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1216_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp1217_;
						_tmp1218_ = param;
						_tmp1219_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1218_);
						length_ctype = _tmp1219_;
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp1220_ = FALSE;
								_tmp1220_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp1222_;
									gint _tmp1223_;
									gint _tmp1224_;
									ValaLocalVariable* temp_array_length = NULL;
									const gchar* _tmp1225_;
									ValaCType* _tmp1226_;
									ValaCType* _tmp1227_;
									ValaLocalVariable* _tmp1228_;
									ValaLocalVariable* _tmp1229_;
									ValaLocalVariable* _tmp1230_;
									ValaExpression* _tmp1231_;
									ValaLocalVariable* _tmp1232_;
									const gchar* _tmp1233_;
									const gchar* _tmp1234_;
									ValaCCodeExpression* _tmp1235_;
									ValaCCodeExpression* _tmp1236_;
									ValaHashMap* _tmp1237_;
									ValaParameter* _tmp1238_;
									ValaExpression* _tmp1239_;
									ValaList* _tmp1240_;
									gpointer _tmp1241_;
									ValaCCodeExpression* _tmp1242_;
									ValaCCodeUnaryExpression* _tmp1243_;
									ValaCCodeUnaryExpression* _tmp1244_;
									if (!_tmp1220_) {
										gint _tmp1221_;
										_tmp1221_ = dim;
										dim = _tmp1221_ + 1;
									}
									_tmp1220_ = FALSE;
									_tmp1222_ = array_type;
									_tmp1223_ = vala_array_type_get_rank (_tmp1222_);
									_tmp1224_ = _tmp1223_;
									if (!(dim <= _tmp1224_)) {
										break;
									}
									_tmp1225_ = length_ctype;
									_tmp1226_ = vala_ctype_new (_tmp1225_, "0");
									_tmp1227_ = _tmp1226_;
									_tmp1228_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1227_, TRUE, NULL, TRUE);
									_tmp1229_ = _tmp1228_;
									_vala_code_node_unref0 (_tmp1227_);
									temp_array_length = _tmp1229_;
									_tmp1230_ = temp_array_length;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1230_, FALSE);
									_tmp1231_ = arg;
									_tmp1232_ = temp_array_length;
									_tmp1233_ = vala_symbol_get_name ((ValaSymbol*) _tmp1232_);
									_tmp1234_ = _tmp1233_;
									_tmp1235_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1234_);
									_tmp1236_ = _tmp1235_;
									vala_append_array_length (_tmp1231_, _tmp1236_);
									_vala_ccode_node_unref0 (_tmp1236_);
									_tmp1237_ = carg_map;
									_tmp1238_ = param;
									_tmp1239_ = arg;
									_tmp1240_ = vala_get_array_lengths (_tmp1239_);
									_tmp1241_ = vala_list_get (_tmp1240_, dim - 1);
									_tmp1242_ = (ValaCCodeExpression*) _tmp1241_;
									_tmp1243_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1242_);
									_tmp1244_ = _tmp1243_;
									vala_map_set ((ValaMap*) _tmp1237_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1238_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1244_);
									_vala_ccode_node_unref0 (_tmp1244_);
									_vala_ccode_node_unref0 (_tmp1242_);
									_vala_code_node_unref0 (temp_array_length);
								}
							}
						}
						_g_free0 (length_ctype);
						_vala_code_node_unref0 (array_type);
					} else {
						gboolean _tmp1245_ = FALSE;
						ValaParameter* _tmp1246_;
						_tmp1246_ = param;
						if (vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1246_)) {
							ValaParameter* _tmp1247_;
							ValaDataType* _tmp1248_;
							ValaDataType* _tmp1249_;
							_tmp1247_ = param;
							_tmp1248_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1247_);
							_tmp1249_ = _tmp1248_;
							_tmp1245_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1249_, VALA_TYPE_DELEGATE_TYPE);
						} else {
							_tmp1245_ = FALSE;
						}
						if (_tmp1245_) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp1250_;
							ValaDataType* _tmp1251_;
							ValaDataType* _tmp1252_;
							ValaDelegateType* _tmp1253_;
							ValaDelegateType* _tmp1254_;
							ValaDelegate* _tmp1255_;
							ValaDelegate* _tmp1256_;
							gboolean _tmp1257_;
							gboolean _tmp1258_;
							_tmp1250_ = param;
							_tmp1251_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1250_);
							_tmp1252_ = _tmp1251_;
							_tmp1253_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1252_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp1253_;
							_tmp1254_ = deleg_type;
							_tmp1255_ = vala_delegate_type_get_delegate_symbol (_tmp1254_);
							_tmp1256_ = _tmp1255_;
							_tmp1257_ = vala_delegate_get_has_target (_tmp1256_);
							_tmp1258_ = _tmp1257_;
							if (_tmp1258_) {
								ValaDataType* _tmp1259_;
								ValaLocalVariable* _tmp1260_;
								ValaLocalVariable* _tmp1261_;
								ValaExpression* _tmp1262_;
								ValaLocalVariable* _tmp1263_;
								const gchar* _tmp1264_;
								const gchar* _tmp1265_;
								ValaCCodeExpression* _tmp1266_;
								ValaCCodeExpression* _tmp1267_;
								ValaHashMap* _tmp1268_;
								ValaParameter* _tmp1269_;
								ValaExpression* _tmp1270_;
								ValaCCodeExpression* _tmp1271_;
								ValaCCodeUnaryExpression* _tmp1272_;
								ValaCCodeUnaryExpression* _tmp1273_;
								ValaDelegateType* _tmp1274_;
								_tmp1259_ = ((ValaCCodeBaseModule*) self)->delegate_target_type;
								_tmp1260_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1259_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1260_;
								_tmp1261_ = temp_var;
								vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1261_, FALSE);
								_tmp1262_ = arg;
								_tmp1263_ = temp_var;
								_tmp1264_ = vala_symbol_get_name ((ValaSymbol*) _tmp1263_);
								_tmp1265_ = _tmp1264_;
								_tmp1266_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1265_);
								_tmp1267_ = _tmp1266_;
								vala_set_delegate_target (_tmp1262_, _tmp1267_);
								_vala_ccode_node_unref0 (_tmp1267_);
								_tmp1268_ = carg_map;
								_tmp1269_ = param;
								_tmp1270_ = arg;
								_tmp1271_ = vala_get_delegate_target (_tmp1270_);
								_tmp1272_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1271_);
								_tmp1273_ = _tmp1272_;
								vala_map_set ((ValaMap*) _tmp1268_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1269_), FALSE)), (ValaCCodeExpression*) _tmp1273_);
								_vala_ccode_node_unref0 (_tmp1273_);
								_tmp1274_ = deleg_type;
								if (vala_data_type_is_disposable ((ValaDataType*) _tmp1274_)) {
									ValaDelegateType* _tmp1275_;
									ValaLocalVariable* _tmp1276_;
									ValaLocalVariable* _tmp1277_;
									ValaExpression* _tmp1278_;
									ValaLocalVariable* _tmp1279_;
									const gchar* _tmp1280_;
									const gchar* _tmp1281_;
									ValaCCodeExpression* _tmp1282_;
									ValaCCodeExpression* _tmp1283_;
									ValaHashMap* _tmp1284_;
									ValaParameter* _tmp1285_;
									ValaExpression* _tmp1286_;
									ValaCCodeExpression* _tmp1287_;
									ValaCCodeUnaryExpression* _tmp1288_;
									ValaCCodeUnaryExpression* _tmp1289_;
									_tmp1275_ = ((ValaCCodeBaseModule*) self)->delegate_target_destroy_type;
									_tmp1276_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1275_, TRUE, NULL, TRUE);
									_vala_code_node_unref0 (temp_var);
									temp_var = _tmp1276_;
									_tmp1277_ = temp_var;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1277_, FALSE);
									_tmp1278_ = arg;
									_tmp1279_ = temp_var;
									_tmp1280_ = vala_symbol_get_name ((ValaSymbol*) _tmp1279_);
									_tmp1281_ = _tmp1280_;
									_tmp1282_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1281_);
									_tmp1283_ = _tmp1282_;
									vala_set_delegate_target_destroy_notify (_tmp1278_, _tmp1283_);
									_vala_ccode_node_unref0 (_tmp1283_);
									_tmp1284_ = carg_map;
									_tmp1285_ = param;
									_tmp1286_ = arg;
									_tmp1287_ = vala_get_delegate_target_destroy_notify (_tmp1286_);
									_tmp1288_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1287_);
									_tmp1289_ = _tmp1288_;
									vala_map_set ((ValaMap*) _tmp1284_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1285_), FALSE)), (ValaCCodeExpression*) _tmp1289_);
									_vala_ccode_node_unref0 (_tmp1289_);
								}
							}
							_vala_code_node_unref0 (deleg_type);
						}
					}
					_vala_code_node_unref0 (temp_var);
				}
				_tmp1290_ = param;
				_tmp1291_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1290_);
				_tmp1292_ = _tmp1291_;
				_tmp1293_ = _tmp1292_ != NULL;
				_g_free0 (_tmp1292_);
				if (_tmp1293_) {
					ValaCCodeExpression* _tmp1294_;
					ValaParameter* _tmp1295_;
					gchar* _tmp1296_;
					gchar* _tmp1297_;
					ValaCCodeCastExpression* _tmp1298_;
					_tmp1294_ = cexpr;
					_tmp1295_ = param;
					_tmp1296_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1295_);
					_tmp1297_ = _tmp1296_;
					_tmp1298_ = vala_ccode_cast_expression_new (_tmp1294_, _tmp1297_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1298_;
					_g_free0 (_tmp1297_);
				}
				_vala_code_node_unref0 (unary);
			} else {
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp1299_;
				ValaUnaryExpression* _tmp1300_;
				gboolean _tmp1301_ = FALSE;
				gboolean _tmp1302_ = FALSE;
				_tmp1299_ = arg;
				_tmp1300_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1299_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1299_) : NULL);
				unary = _tmp1300_;
				if (ellipsis) {
					ValaUnaryExpression* _tmp1303_;
					_tmp1303_ = unary;
					_tmp1302_ = _tmp1303_ != NULL;
				} else {
					_tmp1302_ = FALSE;
				}
				if (_tmp1302_) {
					ValaUnaryExpression* _tmp1304_;
					ValaUnaryOperator _tmp1305_;
					ValaUnaryOperator _tmp1306_;
					_tmp1304_ = unary;
					_tmp1305_ = vala_unary_expression_get_operator (_tmp1304_);
					_tmp1306_ = _tmp1305_;
					_tmp1301_ = _tmp1306_ == VALA_UNARY_OPERATOR_OUT;
				} else {
					_tmp1301_ = FALSE;
				}
				if (_tmp1301_) {
					ValaHashMap* _tmp1307_;
					ValaHashMap* _tmp1308_;
					ValaExpression* _tmp1309_;
					ValaLocalVariable* temp_var = NULL;
					ValaExpression* _tmp1310_;
					ValaDataType* _tmp1311_;
					ValaDataType* _tmp1312_;
					ValaExpression* _tmp1313_;
					ValaDataType* _tmp1314_;
					ValaDataType* _tmp1315_;
					gboolean _tmp1316_;
					gboolean _tmp1317_;
					ValaLocalVariable* _tmp1318_;
					ValaLocalVariable* _tmp1319_;
					ValaExpression* _tmp1320_;
					ValaLocalVariable* _tmp1321_;
					const gchar* _tmp1322_;
					const gchar* _tmp1323_;
					ValaCCodeExpression* _tmp1324_;
					ValaCCodeExpression* _tmp1325_;
					ValaExpression* _tmp1326_;
					ValaTargetValue* _tmp1327_;
					ValaTargetValue* _tmp1328_;
					ValaExpression* _tmp1329_;
					ValaDataType* _tmp1330_;
					ValaDataType* _tmp1331_;
					gboolean _tmp1332_ = FALSE;
					ValaExpression* _tmp1333_;
					ValaDataType* _tmp1334_;
					ValaDataType* _tmp1335_;
					ValaExpression* _tmp1354_;
					ValaCCodeExpression* _tmp1355_;
					ValaCCodeUnaryExpression* _tmp1356_;
					_tmp1307_ = out_arg_map;
					_tmp1308_ = _vala_map_ref0 (_tmp1307_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp1308_;
					_tmp1309_ = arg;
					vala_expression_set_target_value (_tmp1309_, NULL);
					_tmp1310_ = arg;
					_tmp1311_ = vala_expression_get_value_type (_tmp1310_);
					_tmp1312_ = _tmp1311_;
					_tmp1313_ = arg;
					_tmp1314_ = vala_expression_get_value_type (_tmp1313_);
					_tmp1315_ = _tmp1314_;
					_tmp1316_ = vala_data_type_get_value_owned (_tmp1315_);
					_tmp1317_ = _tmp1316_;
					_tmp1318_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1312_, _tmp1317_, NULL, TRUE);
					temp_var = _tmp1318_;
					_tmp1319_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1319_, FALSE);
					_tmp1320_ = arg;
					_tmp1321_ = temp_var;
					_tmp1322_ = vala_symbol_get_name ((ValaSymbol*) _tmp1321_);
					_tmp1323_ = _tmp1322_;
					_tmp1324_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1323_);
					_tmp1325_ = _tmp1324_;
					vala_set_cvalue (_tmp1320_, _tmp1325_);
					_vala_ccode_node_unref0 (_tmp1325_);
					_tmp1326_ = arg;
					_tmp1327_ = vala_expression_get_target_value (_tmp1326_);
					_tmp1328_ = _tmp1327_;
					_tmp1329_ = arg;
					_tmp1330_ = vala_expression_get_value_type (_tmp1329_);
					_tmp1331_ = _tmp1330_;
					vala_target_value_set_value_type (_tmp1328_, _tmp1331_);
					_tmp1333_ = arg;
					_tmp1334_ = vala_expression_get_value_type (_tmp1333_);
					_tmp1335_ = _tmp1334_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1335_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaExpression* _tmp1336_;
						ValaDataType* _tmp1337_;
						ValaDataType* _tmp1338_;
						ValaDelegate* _tmp1339_;
						ValaDelegate* _tmp1340_;
						gboolean _tmp1341_;
						gboolean _tmp1342_;
						_tmp1336_ = arg;
						_tmp1337_ = vala_expression_get_value_type (_tmp1336_);
						_tmp1338_ = _tmp1337_;
						_tmp1339_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1338_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp1340_ = _tmp1339_;
						_tmp1341_ = vala_delegate_get_has_target (_tmp1340_);
						_tmp1342_ = _tmp1341_;
						_tmp1332_ = _tmp1342_;
					} else {
						_tmp1332_ = FALSE;
					}
					if (_tmp1332_) {
						ValaGLibValue* arg_value = NULL;
						ValaExpression* _tmp1343_;
						ValaTargetValue* _tmp1344_;
						ValaTargetValue* _tmp1345_;
						ValaGLibValue* _tmp1346_;
						ValaCCodeExpression* _tmp1347_;
						ValaGLibValue* _tmp1350_;
						ValaCCodeExpression* _tmp1351_;
						_tmp1343_ = arg;
						_tmp1344_ = vala_expression_get_target_value (_tmp1343_);
						_tmp1345_ = _tmp1344_;
						arg_value = G_TYPE_CHECK_INSTANCE_CAST (_tmp1345_, VALA_TYPE_GLIB_VALUE, ValaGLibValue);
						_tmp1346_ = arg_value;
						_tmp1347_ = _tmp1346_->delegate_target_cvalue;
						if (_tmp1347_ == NULL) {
							ValaGLibValue* _tmp1348_;
							ValaCCodeConstant* _tmp1349_;
							_tmp1348_ = arg_value;
							_tmp1349_ = vala_ccode_constant_new ("NULL");
							_vala_ccode_node_unref0 (_tmp1348_->delegate_target_cvalue);
							_tmp1348_->delegate_target_cvalue = (ValaCCodeExpression*) _tmp1349_;
						}
						_tmp1350_ = arg_value;
						_tmp1351_ = _tmp1350_->delegate_target_destroy_notify_cvalue;
						if (_tmp1351_ == NULL) {
							ValaGLibValue* _tmp1352_;
							ValaCCodeConstant* _tmp1353_;
							_tmp1352_ = arg_value;
							_tmp1353_ = vala_ccode_constant_new ("NULL");
							_vala_ccode_node_unref0 (_tmp1352_->delegate_target_destroy_notify_cvalue);
							_tmp1352_->delegate_target_destroy_notify_cvalue = (ValaCCodeExpression*) _tmp1353_;
						}
					}
					_tmp1354_ = arg;
					_tmp1355_ = vala_get_cvalue (_tmp1354_);
					_tmp1356_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1355_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1356_;
					_vala_code_node_unref0 (temp_var);
				} else {
					ValaExpression* _tmp1357_;
					ValaCCodeExpression* _tmp1358_;
					ValaCCodeExpression* _tmp1359_;
					_tmp1357_ = arg;
					_tmp1358_ = cexpr;
					_tmp1359_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1357_, _tmp1358_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1359_;
				}
				_vala_code_node_unref0 (unary);
			}
			_tmp1362_ = param;
			if (_tmp1362_ != NULL) {
				_tmp1361_ = !ellipsis;
			} else {
				_tmp1361_ = FALSE;
			}
			if (_tmp1361_) {
				ValaParameter* _tmp1363_;
				_tmp1363_ = param;
				_tmp1360_ = vala_get_ccode_pos (_tmp1363_);
			} else {
				_tmp1360_ = (gdouble) i;
			}
			arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, _tmp1360_, ellipsis);
			_tmp1364_ = carg_map;
			_tmp1365_ = cexpr;
			vala_map_set ((ValaMap*) _tmp1364_, (gpointer) ((gintptr) arg_pos), _tmp1365_);
			_tmp1367_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1367_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
				ValaCodeContext* _tmp1368_;
				ValaCodeContext* _tmp1369_;
				ValaProfile _tmp1370_;
				ValaProfile _tmp1371_;
				_tmp1368_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp1369_ = _tmp1368_;
				_tmp1370_ = vala_code_context_get_profile (_tmp1369_);
				_tmp1371_ = _tmp1370_;
				_tmp1366_ = _tmp1371_ == VALA_PROFILE_POSIX;
			} else {
				_tmp1366_ = FALSE;
			}
			if (_tmp1366_) {
				ValaCCodeIdentifier* csizeof = NULL;
				ValaMemberAccess* _tmp1372_;
				ValaExpression* _tmp1373_;
				ValaExpression* _tmp1374_;
				ValaDataType* _tmp1375_;
				ValaDataType* _tmp1376_;
				ValaDataType* _tmp1377_;
				ValaDataType* _tmp1378_;
				gchar* _tmp1379_;
				gchar* _tmp1380_;
				gchar* _tmp1381_;
				gchar* _tmp1382_;
				ValaCCodeIdentifier* _tmp1383_;
				ValaCCodeIdentifier* _tmp1384_;
				ValaHashMap* _tmp1385_;
				ValaCCodeIdentifier* _tmp1386_;
				ValaCCodeExpression* _tmp1387_;
				ValaCCodeBinaryExpression* _tmp1388_;
				ValaCCodeBinaryExpression* _tmp1389_;
				_tmp1372_ = ma;
				_tmp1373_ = vala_member_access_get_inner (_tmp1372_);
				_tmp1374_ = _tmp1373_;
				_tmp1375_ = vala_expression_get_value_type (_tmp1374_);
				_tmp1376_ = _tmp1375_;
				_tmp1377_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp1376_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp1378_ = _tmp1377_;
				_tmp1379_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1378_);
				_tmp1380_ = _tmp1379_;
				_tmp1381_ = g_strdup_printf ("sizeof (%s)", _tmp1380_);
				_tmp1382_ = _tmp1381_;
				_tmp1383_ = vala_ccode_identifier_new (_tmp1382_);
				_tmp1384_ = _tmp1383_;
				_g_free0 (_tmp1382_);
				_g_free0 (_tmp1380_);
				csizeof = _tmp1384_;
				_tmp1385_ = carg_map;
				_tmp1386_ = csizeof;
				_tmp1387_ = cexpr;
				_tmp1388_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1386_, _tmp1387_);
				_tmp1389_ = _tmp1388_;
				vala_map_set ((ValaMap*) _tmp1385_, (gpointer) ((gintptr) arg_pos), (ValaCCodeExpression*) _tmp1389_);
				_vala_ccode_node_unref0 (_tmp1389_);
				_vala_ccode_node_unref0 (csizeof);
			} else {
				ValaHashMap* _tmp1390_;
				ValaCCodeExpression* _tmp1391_;
				_tmp1390_ = carg_map;
				_tmp1391_ = cexpr;
				vala_map_set ((ValaMap*) _tmp1390_, (gpointer) ((gintptr) arg_pos), _tmp1391_);
			}
			_tmp1393_ = arg;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1393_, VALA_TYPE_NAMED_ARGUMENT)) {
				_tmp1392_ = ellipsis;
			} else {
				_tmp1392_ = FALSE;
			}
			if (_tmp1392_) {
				ValaNamedArgument* named_arg = NULL;
				ValaExpression* _tmp1394_;
				ValaNamedArgument* _tmp1395_;
				gchar* name = NULL;
				ValaNamedArgument* _tmp1396_;
				const gchar* _tmp1397_;
				const gchar* _tmp1398_;
				gchar** _tmp1399_;
				gchar** _tmp1400_;
				gchar** _tmp1401_;
				gint _tmp1401__length1;
				gchar* _tmp1402_;
				gchar* _tmp1403_;
				ValaHashMap* _tmp1404_;
				const gchar* _tmp1405_;
				gchar* _tmp1406_;
				gchar* _tmp1407_;
				ValaCCodeConstant* _tmp1408_;
				ValaCCodeConstant* _tmp1409_;
				_tmp1394_ = arg;
				_tmp1395_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1394_, VALA_TYPE_NAMED_ARGUMENT, ValaNamedArgument));
				named_arg = _tmp1395_;
				_tmp1396_ = named_arg;
				_tmp1397_ = vala_named_argument_get_name (_tmp1396_);
				_tmp1398_ = _tmp1397_;
				_tmp1400_ = _tmp1399_ = g_strsplit (_tmp1398_, "_", 0);
				_tmp1401_ = _tmp1400_;
				_tmp1401__length1 = _vala_array_length (_tmp1399_);
				_tmp1402_ = _vala_g_strjoinv ("-", _tmp1401_, (gint) _vala_array_length (_tmp1399_));
				_tmp1403_ = _tmp1402_;
				_tmp1401_ = (_vala_array_free (_tmp1401_, _tmp1401__length1, (GDestroyNotify) g_free), NULL);
				name = _tmp1403_;
				_tmp1404_ = carg_map;
				_tmp1405_ = name;
				_tmp1406_ = g_strdup_printf ("\"%s\"", _tmp1405_);
				_tmp1407_ = _tmp1406_;
				_tmp1408_ = vala_ccode_constant_new (_tmp1407_);
				_tmp1409_ = _tmp1408_;
				vala_map_set ((ValaMap*) _tmp1404_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, i - 0.1, ellipsis)), (ValaCCodeExpression*) _tmp1409_);
				_vala_ccode_node_unref0 (_tmp1409_);
				_g_free0 (_tmp1407_);
				_g_free0 (name);
				_vala_code_node_unref0 (named_arg);
			}
			_tmp1410_ = i;
			i = _tmp1410_ + 1;
			_vala_code_node_unref0 (param);
			_vala_map_unref0 (carg_map);
			_vala_ccode_node_unref0 (cexpr);
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp1411_ = params_it;
	if (vala_iterator_next (_tmp1411_)) {
		ValaParameter* param = NULL;
		ValaIterator* _tmp1412_;
		gpointer _tmp1413_;
		gboolean _tmp1414_ = FALSE;
		ValaParameter* _tmp1415_;
		gboolean _tmp1416_;
		gboolean _tmp1417_;
		_tmp1412_ = params_it;
		_tmp1413_ = vala_iterator_get (_tmp1412_);
		param = (ValaParameter*) _tmp1413_;
		_tmp1415_ = param;
		_tmp1416_ = vala_parameter_get_params_array (_tmp1415_);
		_tmp1417_ = _tmp1416_;
		if (_tmp1417_) {
			_tmp1414_ = TRUE;
		} else {
			ValaParameter* _tmp1418_;
			gboolean _tmp1419_;
			gboolean _tmp1420_;
			_tmp1418_ = param;
			_tmp1419_ = vala_parameter_get_ellipsis (_tmp1418_);
			_tmp1420_ = _tmp1419_;
			_tmp1414_ = _tmp1420_;
		}
		_vala_assert (_tmp1414_, "param.params_array || param.ellipsis");
		ellipsis = TRUE;
		_vala_code_node_unref0 (param);
	}
	_tmp1423_ = m;
	if (_tmp1423_ != NULL) {
		ValaMethod* _tmp1424_;
		ValaDataType* _tmp1425_;
		ValaDataType* _tmp1426_;
		_tmp1424_ = m;
		_tmp1425_ = vala_callable_get_return_type ((ValaCallable*) _tmp1424_);
		_tmp1426_ = _tmp1425_;
		_tmp1422_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1426_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1422_ = FALSE;
	}
	if (_tmp1422_) {
		ValaCCodeFunctionCall* _tmp1427_;
		ValaCCodeFunctionCall* _tmp1428_;
		_tmp1427_ = async_call;
		_tmp1428_ = ccall;
		_tmp1421_ = _tmp1427_ != _tmp1428_;
	} else {
		_tmp1421_ = FALSE;
	}
	if (_tmp1421_) {
		ValaArrayType* array_type = NULL;
		ValaMethod* _tmp1429_;
		ValaDataType* _tmp1430_;
		ValaDataType* _tmp1431_;
		ValaArrayType* _tmp1432_;
		_tmp1429_ = m;
		_tmp1430_ = vala_callable_get_return_type ((ValaCallable*) _tmp1429_);
		_tmp1431_ = _tmp1430_;
		_tmp1432_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1431_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1432_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1433_ = FALSE;
				_tmp1433_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1435_;
					gint _tmp1436_;
					gint _tmp1437_;
					ValaMethod* _tmp1438_;
					if (!_tmp1433_) {
						gint _tmp1434_;
						_tmp1434_ = dim;
						dim = _tmp1434_ + 1;
					}
					_tmp1433_ = FALSE;
					_tmp1435_ = array_type;
					_tmp1436_ = vala_array_type_get_rank (_tmp1435_);
					_tmp1437_ = _tmp1436_;
					if (!(dim <= _tmp1437_)) {
						break;
					}
					_tmp1438_ = m;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1438_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1439_;
						ValaDataType* _tmp1440_;
						ValaLocalVariable* _tmp1441_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1442_;
						const gchar* _tmp1443_;
						const gchar* _tmp1444_;
						ValaCCodeExpression* _tmp1445_;
						ValaLocalVariable* _tmp1446_;
						ValaCCodeExpression* _tmp1447_;
						ValaCCodeExpression* _tmp1448_;
						ValaCCodeAssignment* _tmp1449_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1450_;
						ValaCCodeIdentifier* _tmp1451_;
						ValaCCodeFunctionCall* _tmp1452_;
						ValaCCodeFunctionCall* _tmp1453_;
						ValaCCodeFunctionCall* _tmp1454_;
						ValaCCodeExpression* _tmp1455_;
						ValaCCodeFunctionCall* _tmp1456_;
						_tmp1439_ = itype;
						_tmp1440_ = vala_data_type_get_return_type (_tmp1439_);
						_tmp1441_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1440_, TRUE, NULL, FALSE);
						temp_var = _tmp1441_;
						_tmp1442_ = temp_var;
						_tmp1443_ = vala_symbol_get_name ((ValaSymbol*) _tmp1442_);
						_tmp1444_ = _tmp1443_;
						_tmp1445_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1444_);
						temp_ref = _tmp1445_;
						_tmp1446_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1446_, FALSE);
						_tmp1447_ = temp_ref;
						_tmp1448_ = ccall_expr;
						_tmp1449_ = vala_ccode_assignment_new (_tmp1447_, _tmp1448_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1449_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1450_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1451_ = _tmp1450_;
						_tmp1452_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1451_);
						_tmp1453_ = _tmp1452_;
						_vala_ccode_node_unref0 (_tmp1451_);
						len_call = _tmp1453_;
						_tmp1454_ = len_call;
						_tmp1455_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1454_, _tmp1455_);
						_tmp1456_ = len_call;
						vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1456_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaMethod* _tmp1457_;
						_tmp1457_ = m;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1457_)) {
							gchar* length_ctype = NULL;
							ValaMethod* _tmp1458_;
							gchar* _tmp1459_;
							ValaLocalVariable* temp_var = NULL;
							const gchar* _tmp1460_;
							ValaCType* _tmp1461_;
							ValaCType* _tmp1462_;
							ValaLocalVariable* _tmp1463_;
							ValaLocalVariable* _tmp1464_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1465_;
							const gchar* _tmp1466_;
							const gchar* _tmp1467_;
							ValaCCodeExpression* _tmp1468_;
							ValaLocalVariable* _tmp1469_;
							ValaHashMap* _tmp1470_;
							ValaMethod* _tmp1471_;
							ValaCCodeExpression* _tmp1472_;
							ValaCCodeUnaryExpression* _tmp1473_;
							ValaCCodeUnaryExpression* _tmp1474_;
							ValaCCodeExpression* _tmp1475_;
							_tmp1458_ = m;
							_tmp1459_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1458_);
							length_ctype = _tmp1459_;
							_tmp1460_ = length_ctype;
							_tmp1461_ = vala_ctype_new (_tmp1460_, "0");
							_tmp1462_ = _tmp1461_;
							_tmp1463_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1462_, TRUE, NULL, TRUE);
							_tmp1464_ = _tmp1463_;
							_vala_code_node_unref0 (_tmp1462_);
							temp_var = _tmp1464_;
							_tmp1465_ = temp_var;
							_tmp1466_ = vala_symbol_get_name ((ValaSymbol*) _tmp1465_);
							_tmp1467_ = _tmp1466_;
							_tmp1468_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1467_);
							temp_ref = _tmp1468_;
							_tmp1469_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1469_, FALSE);
							_tmp1470_ = out_arg_map;
							_tmp1471_ = m;
							_tmp1472_ = temp_ref;
							_tmp1473_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1472_);
							_tmp1474_ = _tmp1473_;
							vala_map_set ((ValaMap*) _tmp1470_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1471_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1474_);
							_vala_ccode_node_unref0 (_tmp1474_);
							_tmp1475_ = temp_ref;
							vala_append_array_length ((ValaExpression*) expr, _tmp1475_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
							_g_free0 (length_ctype);
						} else {
							ValaMethod* _tmp1476_;
							gchar* _tmp1477_;
							gchar* _tmp1478_;
							gboolean _tmp1479_;
							_tmp1476_ = m;
							_tmp1477_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1476_);
							_tmp1478_ = _tmp1477_;
							_tmp1479_ = _tmp1478_ != NULL;
							_g_free0 (_tmp1478_);
							if (_tmp1479_) {
								ValaMethod* _tmp1480_;
								gchar* _tmp1481_;
								gchar* _tmp1482_;
								ValaCCodeConstant* _tmp1483_;
								ValaCCodeConstant* _tmp1484_;
								_tmp1480_ = m;
								_tmp1481_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1480_);
								_tmp1482_ = _tmp1481_;
								_tmp1483_ = vala_ccode_constant_new (_tmp1482_);
								_tmp1484_ = _tmp1483_;
								vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1484_);
								_vala_ccode_node_unref0 (_tmp1484_);
								_g_free0 (_tmp1482_);
							} else {
								ValaCCodeConstant* _tmp1485_;
								ValaCCodeConstant* _tmp1486_;
								_tmp1485_ = vala_ccode_constant_new ("-1");
								_tmp1486_ = _tmp1485_;
								vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1486_);
								_vala_ccode_node_unref0 (_tmp1486_);
							}
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1487_ = FALSE;
		gboolean _tmp1488_ = FALSE;
		ValaMethod* _tmp1489_;
		_tmp1489_ = m;
		if (_tmp1489_ != NULL) {
			ValaMethod* _tmp1490_;
			ValaDataType* _tmp1491_;
			ValaDataType* _tmp1492_;
			_tmp1490_ = m;
			_tmp1491_ = vala_callable_get_return_type ((ValaCallable*) _tmp1490_);
			_tmp1492_ = _tmp1491_;
			_tmp1488_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1492_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1488_ = FALSE;
		}
		if (_tmp1488_) {
			ValaCCodeFunctionCall* _tmp1493_;
			ValaCCodeFunctionCall* _tmp1494_;
			_tmp1493_ = async_call;
			_tmp1494_ = ccall;
			_tmp1487_ = _tmp1493_ != _tmp1494_;
		} else {
			_tmp1487_ = FALSE;
		}
		if (_tmp1487_) {
			ValaDelegateType* deleg_type = NULL;
			ValaMethod* _tmp1495_;
			ValaDataType* _tmp1496_;
			ValaDataType* _tmp1497_;
			ValaDelegateType* _tmp1498_;
			gboolean _tmp1499_ = FALSE;
			ValaMethod* _tmp1500_;
			_tmp1495_ = m;
			_tmp1496_ = vala_callable_get_return_type ((ValaCallable*) _tmp1495_);
			_tmp1497_ = _tmp1496_;
			_tmp1498_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1497_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1498_;
			_tmp1500_ = m;
			if (vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1500_)) {
				ValaDelegateType* _tmp1501_;
				ValaDelegate* _tmp1502_;
				ValaDelegate* _tmp1503_;
				gboolean _tmp1504_;
				gboolean _tmp1505_;
				_tmp1501_ = deleg_type;
				_tmp1502_ = vala_delegate_type_get_delegate_symbol (_tmp1501_);
				_tmp1503_ = _tmp1502_;
				_tmp1504_ = vala_delegate_get_has_target (_tmp1503_);
				_tmp1505_ = _tmp1504_;
				_tmp1499_ = _tmp1505_;
			} else {
				_tmp1499_ = FALSE;
			}
			if (_tmp1499_) {
				ValaLocalVariable* temp_var = NULL;
				ValaDataType* _tmp1506_;
				ValaLocalVariable* _tmp1507_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1508_;
				const gchar* _tmp1509_;
				const gchar* _tmp1510_;
				ValaCCodeExpression* _tmp1511_;
				ValaLocalVariable* _tmp1512_;
				ValaHashMap* _tmp1513_;
				ValaMethod* _tmp1514_;
				ValaCCodeExpression* _tmp1515_;
				ValaCCodeUnaryExpression* _tmp1516_;
				ValaCCodeUnaryExpression* _tmp1517_;
				ValaCCodeExpression* _tmp1518_;
				ValaDelegateType* _tmp1519_;
				_tmp1506_ = ((ValaCCodeBaseModule*) self)->delegate_target_type;
				_tmp1507_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1506_, TRUE, NULL, TRUE);
				temp_var = _tmp1507_;
				_tmp1508_ = temp_var;
				_tmp1509_ = vala_symbol_get_name ((ValaSymbol*) _tmp1508_);
				_tmp1510_ = _tmp1509_;
				_tmp1511_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1510_);
				temp_ref = _tmp1511_;
				_tmp1512_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1512_, FALSE);
				_tmp1513_ = out_arg_map;
				_tmp1514_ = m;
				_tmp1515_ = temp_ref;
				_tmp1516_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1515_);
				_tmp1517_ = _tmp1516_;
				vala_map_set ((ValaMap*) _tmp1513_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1514_), FALSE)), (ValaCCodeExpression*) _tmp1517_);
				_vala_ccode_node_unref0 (_tmp1517_);
				_tmp1518_ = temp_ref;
				vala_set_delegate_target ((ValaExpression*) expr, _tmp1518_);
				_tmp1519_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1519_)) {
					ValaDelegateType* _tmp1520_;
					ValaLocalVariable* _tmp1521_;
					ValaLocalVariable* _tmp1522_;
					const gchar* _tmp1523_;
					const gchar* _tmp1524_;
					ValaCCodeExpression* _tmp1525_;
					ValaLocalVariable* _tmp1526_;
					ValaHashMap* _tmp1527_;
					ValaMethod* _tmp1528_;
					ValaCCodeExpression* _tmp1529_;
					ValaCCodeUnaryExpression* _tmp1530_;
					ValaCCodeUnaryExpression* _tmp1531_;
					ValaCCodeExpression* _tmp1532_;
					_tmp1520_ = ((ValaCCodeBaseModule*) self)->delegate_target_destroy_type;
					_tmp1521_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1520_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1521_;
					_tmp1522_ = temp_var;
					_tmp1523_ = vala_symbol_get_name ((ValaSymbol*) _tmp1522_);
					_tmp1524_ = _tmp1523_;
					_tmp1525_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1524_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1525_;
					_tmp1526_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1526_, FALSE);
					_tmp1527_ = out_arg_map;
					_tmp1528_ = m;
					_tmp1529_ = temp_ref;
					_tmp1530_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1529_);
					_tmp1531_ = _tmp1530_;
					vala_map_set ((ValaMap*) _tmp1527_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1528_), FALSE)), (ValaCCodeExpression*) _tmp1531_);
					_vala_ccode_node_unref0 (_tmp1531_);
					_tmp1532_ = temp_ref;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, _tmp1532_);
				} else {
					ValaCCodeConstant* _tmp1533_;
					ValaCCodeConstant* _tmp1534_;
					_tmp1533_ = vala_ccode_constant_new ("NULL");
					_tmp1534_ = _tmp1533_;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1534_);
					_vala_ccode_node_unref0 (_tmp1534_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			} else {
				ValaCCodeConstant* _tmp1535_;
				ValaCCodeConstant* _tmp1536_;
				ValaDelegateType* _tmp1537_;
				ValaDelegate* _tmp1538_;
				ValaDelegate* _tmp1539_;
				gboolean _tmp1540_;
				gboolean _tmp1541_;
				_tmp1535_ = vala_ccode_constant_new ("NULL");
				_tmp1536_ = _tmp1535_;
				vala_set_delegate_target ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1536_);
				_vala_ccode_node_unref0 (_tmp1536_);
				_tmp1537_ = deleg_type;
				_tmp1538_ = vala_delegate_type_get_delegate_symbol (_tmp1537_);
				_tmp1539_ = _tmp1538_;
				_tmp1540_ = vala_delegate_get_has_target (_tmp1539_);
				_tmp1541_ = _tmp1540_;
				if (_tmp1541_) {
					ValaCCodeConstant* _tmp1542_;
					ValaCCodeConstant* _tmp1543_;
					_tmp1542_ = vala_ccode_constant_new ("NULL");
					_tmp1543_ = _tmp1542_;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1543_);
					_vala_ccode_node_unref0 (_tmp1543_);
				}
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1545_ = deleg;
	if (_tmp1545_ != NULL) {
		ValaDelegate* _tmp1546_;
		ValaDataType* _tmp1547_;
		ValaDataType* _tmp1548_;
		_tmp1546_ = deleg;
		_tmp1547_ = vala_callable_get_return_type ((ValaCallable*) _tmp1546_);
		_tmp1548_ = _tmp1547_;
		_tmp1544_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1548_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1544_ = FALSE;
	}
	if (_tmp1544_) {
		ValaArrayType* array_type = NULL;
		ValaDelegate* _tmp1549_;
		ValaDataType* _tmp1550_;
		ValaDataType* _tmp1551_;
		ValaArrayType* _tmp1552_;
		_tmp1549_ = deleg;
		_tmp1550_ = vala_callable_get_return_type ((ValaCallable*) _tmp1549_);
		_tmp1551_ = _tmp1550_;
		_tmp1552_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1551_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1552_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1553_ = FALSE;
				_tmp1553_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1555_;
					gint _tmp1556_;
					gint _tmp1557_;
					ValaDelegate* _tmp1558_;
					if (!_tmp1553_) {
						gint _tmp1554_;
						_tmp1554_ = dim;
						dim = _tmp1554_ + 1;
					}
					_tmp1553_ = FALSE;
					_tmp1555_ = array_type;
					_tmp1556_ = vala_array_type_get_rank (_tmp1555_);
					_tmp1557_ = _tmp1556_;
					if (!(dim <= _tmp1557_)) {
						break;
					}
					_tmp1558_ = deleg;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1558_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1559_;
						ValaDataType* _tmp1560_;
						ValaLocalVariable* _tmp1561_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1562_;
						const gchar* _tmp1563_;
						const gchar* _tmp1564_;
						ValaCCodeExpression* _tmp1565_;
						ValaLocalVariable* _tmp1566_;
						ValaCCodeExpression* _tmp1567_;
						ValaCCodeExpression* _tmp1568_;
						ValaCCodeAssignment* _tmp1569_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1570_;
						ValaCCodeIdentifier* _tmp1571_;
						ValaCCodeFunctionCall* _tmp1572_;
						ValaCCodeFunctionCall* _tmp1573_;
						ValaCCodeFunctionCall* _tmp1574_;
						ValaCCodeExpression* _tmp1575_;
						ValaCCodeFunctionCall* _tmp1576_;
						_tmp1559_ = itype;
						_tmp1560_ = vala_data_type_get_return_type (_tmp1559_);
						_tmp1561_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1560_, TRUE, NULL, FALSE);
						temp_var = _tmp1561_;
						_tmp1562_ = temp_var;
						_tmp1563_ = vala_symbol_get_name ((ValaSymbol*) _tmp1562_);
						_tmp1564_ = _tmp1563_;
						_tmp1565_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1564_);
						temp_ref = _tmp1565_;
						_tmp1566_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1566_, FALSE);
						_tmp1567_ = temp_ref;
						_tmp1568_ = ccall_expr;
						_tmp1569_ = vala_ccode_assignment_new (_tmp1567_, _tmp1568_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1569_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1570_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1571_ = _tmp1570_;
						_tmp1572_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1571_);
						_tmp1573_ = _tmp1572_;
						_vala_ccode_node_unref0 (_tmp1571_);
						len_call = _tmp1573_;
						_tmp1574_ = len_call;
						_tmp1575_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1574_, _tmp1575_);
						_tmp1576_ = len_call;
						vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1576_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaDelegate* _tmp1577_;
						_tmp1577_ = deleg;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1577_)) {
							gchar* length_ctype = NULL;
							ValaDelegate* _tmp1578_;
							gchar* _tmp1579_;
							ValaLocalVariable* temp_var = NULL;
							const gchar* _tmp1580_;
							ValaCType* _tmp1581_;
							ValaCType* _tmp1582_;
							ValaLocalVariable* _tmp1583_;
							ValaLocalVariable* _tmp1584_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1585_;
							const gchar* _tmp1586_;
							const gchar* _tmp1587_;
							ValaCCodeExpression* _tmp1588_;
							ValaLocalVariable* _tmp1589_;
							ValaHashMap* _tmp1590_;
							ValaDelegate* _tmp1591_;
							ValaCCodeExpression* _tmp1592_;
							ValaCCodeUnaryExpression* _tmp1593_;
							ValaCCodeUnaryExpression* _tmp1594_;
							ValaCCodeExpression* _tmp1595_;
							_tmp1578_ = deleg;
							_tmp1579_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1578_);
							length_ctype = _tmp1579_;
							_tmp1580_ = length_ctype;
							_tmp1581_ = vala_ctype_new (_tmp1580_, "0");
							_tmp1582_ = _tmp1581_;
							_tmp1583_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1582_, TRUE, NULL, TRUE);
							_tmp1584_ = _tmp1583_;
							_vala_code_node_unref0 (_tmp1582_);
							temp_var = _tmp1584_;
							_tmp1585_ = temp_var;
							_tmp1586_ = vala_symbol_get_name ((ValaSymbol*) _tmp1585_);
							_tmp1587_ = _tmp1586_;
							_tmp1588_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1587_);
							temp_ref = _tmp1588_;
							_tmp1589_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1589_, FALSE);
							_tmp1590_ = out_arg_map;
							_tmp1591_ = deleg;
							_tmp1592_ = temp_ref;
							_tmp1593_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1592_);
							_tmp1594_ = _tmp1593_;
							vala_map_set ((ValaMap*) _tmp1590_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1591_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1594_);
							_vala_ccode_node_unref0 (_tmp1594_);
							_tmp1595_ = temp_ref;
							vala_append_array_length ((ValaExpression*) expr, _tmp1595_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
							_g_free0 (length_ctype);
						} else {
							ValaCCodeConstant* _tmp1596_;
							ValaCCodeConstant* _tmp1597_;
							_tmp1596_ = vala_ccode_constant_new ("-1");
							_tmp1597_ = _tmp1596_;
							vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1597_);
							_vala_ccode_node_unref0 (_tmp1597_);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1598_ = FALSE;
		gboolean _tmp1599_ = FALSE;
		ValaDelegate* _tmp1600_;
		_tmp1600_ = deleg;
		if (_tmp1600_ != NULL) {
			ValaDelegate* _tmp1601_;
			ValaDataType* _tmp1602_;
			ValaDataType* _tmp1603_;
			_tmp1601_ = deleg;
			_tmp1602_ = vala_callable_get_return_type ((ValaCallable*) _tmp1601_);
			_tmp1603_ = _tmp1602_;
			_tmp1599_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1603_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1599_ = FALSE;
		}
		if (_tmp1599_) {
			ValaDelegate* _tmp1604_;
			_tmp1604_ = deleg;
			_tmp1598_ = vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1604_);
		} else {
			_tmp1598_ = FALSE;
		}
		if (_tmp1598_) {
			ValaDelegateType* deleg_type = NULL;
			ValaDelegate* _tmp1605_;
			ValaDataType* _tmp1606_;
			ValaDataType* _tmp1607_;
			ValaDelegateType* _tmp1608_;
			ValaDelegateType* _tmp1609_;
			ValaDelegate* _tmp1610_;
			ValaDelegate* _tmp1611_;
			gboolean _tmp1612_;
			gboolean _tmp1613_;
			_tmp1605_ = deleg;
			_tmp1606_ = vala_callable_get_return_type ((ValaCallable*) _tmp1605_);
			_tmp1607_ = _tmp1606_;
			_tmp1608_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1607_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1608_;
			_tmp1609_ = deleg_type;
			_tmp1610_ = vala_delegate_type_get_delegate_symbol (_tmp1609_);
			_tmp1611_ = _tmp1610_;
			_tmp1612_ = vala_delegate_get_has_target (_tmp1611_);
			_tmp1613_ = _tmp1612_;
			if (_tmp1613_) {
				ValaLocalVariable* temp_var = NULL;
				ValaDataType* _tmp1614_;
				ValaLocalVariable* _tmp1615_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1616_;
				const gchar* _tmp1617_;
				const gchar* _tmp1618_;
				ValaCCodeExpression* _tmp1619_;
				ValaLocalVariable* _tmp1620_;
				ValaHashMap* _tmp1621_;
				ValaDelegate* _tmp1622_;
				ValaCCodeExpression* _tmp1623_;
				ValaCCodeUnaryExpression* _tmp1624_;
				ValaCCodeUnaryExpression* _tmp1625_;
				ValaCCodeExpression* _tmp1626_;
				ValaDelegateType* _tmp1627_;
				_tmp1614_ = ((ValaCCodeBaseModule*) self)->delegate_target_type;
				_tmp1615_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1614_, TRUE, NULL, TRUE);
				temp_var = _tmp1615_;
				_tmp1616_ = temp_var;
				_tmp1617_ = vala_symbol_get_name ((ValaSymbol*) _tmp1616_);
				_tmp1618_ = _tmp1617_;
				_tmp1619_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1618_);
				temp_ref = _tmp1619_;
				_tmp1620_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1620_, FALSE);
				_tmp1621_ = out_arg_map;
				_tmp1622_ = deleg;
				_tmp1623_ = temp_ref;
				_tmp1624_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1623_);
				_tmp1625_ = _tmp1624_;
				vala_map_set ((ValaMap*) _tmp1621_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1622_), FALSE)), (ValaCCodeExpression*) _tmp1625_);
				_vala_ccode_node_unref0 (_tmp1625_);
				_tmp1626_ = temp_ref;
				vala_set_delegate_target ((ValaExpression*) expr, _tmp1626_);
				_tmp1627_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1627_)) {
					ValaDelegateType* _tmp1628_;
					ValaLocalVariable* _tmp1629_;
					ValaLocalVariable* _tmp1630_;
					const gchar* _tmp1631_;
					const gchar* _tmp1632_;
					ValaCCodeExpression* _tmp1633_;
					ValaLocalVariable* _tmp1634_;
					ValaHashMap* _tmp1635_;
					ValaDelegate* _tmp1636_;
					ValaCCodeExpression* _tmp1637_;
					ValaCCodeUnaryExpression* _tmp1638_;
					ValaCCodeUnaryExpression* _tmp1639_;
					ValaCCodeExpression* _tmp1640_;
					_tmp1628_ = ((ValaCCodeBaseModule*) self)->delegate_target_destroy_type;
					_tmp1629_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1628_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1629_;
					_tmp1630_ = temp_var;
					_tmp1631_ = vala_symbol_get_name ((ValaSymbol*) _tmp1630_);
					_tmp1632_ = _tmp1631_;
					_tmp1633_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1632_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1633_;
					_tmp1634_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1634_, FALSE);
					_tmp1635_ = out_arg_map;
					_tmp1636_ = deleg;
					_tmp1637_ = temp_ref;
					_tmp1638_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1637_);
					_tmp1639_ = _tmp1638_;
					vala_map_set ((ValaMap*) _tmp1635_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1636_), FALSE)), (ValaCCodeExpression*) _tmp1639_);
					_vala_ccode_node_unref0 (_tmp1639_);
					_tmp1640_ = temp_ref;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, _tmp1640_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1642_ = m;
	if (_tmp1642_ != NULL) {
		ValaMethod* _tmp1643_;
		gboolean _tmp1644_;
		gboolean _tmp1645_;
		_tmp1643_ = m;
		_tmp1644_ = vala_method_get_coroutine (_tmp1643_);
		_tmp1645_ = _tmp1644_;
		_tmp1641_ = _tmp1645_;
	} else {
		_tmp1641_ = FALSE;
	}
	if (_tmp1641_) {
		gboolean _tmp1646_;
		gboolean _tmp1647_;
		_tmp1646_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) expr);
		_tmp1647_ = _tmp1646_;
		if (_tmp1647_) {
			ValaHashMap* _tmp1648_;
			ValaMethod* _tmp1649_;
			ValaMethod* _tmp1650_;
			gchar* _tmp1651_;
			gchar* _tmp1652_;
			ValaCCodeIdentifier* _tmp1653_;
			ValaCCodeIdentifier* _tmp1654_;
			ValaHashMap* _tmp1655_;
			ValaCCodeIdentifier* _tmp1656_;
			ValaCCodeIdentifier* _tmp1657_;
			_tmp1648_ = in_arg_map;
			_tmp1649_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp1650_ = _tmp1649_;
			_tmp1651_ = vala_ccode_base_module_generate_ready_function ((ValaCCodeBaseModule*) self, _tmp1650_);
			_tmp1652_ = _tmp1651_;
			_tmp1653_ = vala_ccode_identifier_new (_tmp1652_);
			_tmp1654_ = _tmp1653_;
			vala_map_set ((ValaMap*) _tmp1648_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1654_);
			_vala_ccode_node_unref0 (_tmp1654_);
			_g_free0 (_tmp1652_);
			_tmp1655_ = in_arg_map;
			_tmp1656_ = vala_ccode_identifier_new ("_data_");
			_tmp1657_ = _tmp1656_;
			vala_map_set ((ValaMap*) _tmp1655_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) _tmp1657_);
			_vala_ccode_node_unref0 (_tmp1657_);
		}
	}
	_tmp1658_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr);
	_tmp1659_ = _tmp1658_;
	if (_tmp1659_) {
		ValaCallable* _tmp1660_ = NULL;
		ValaMethod* _tmp1661_;
		ValaHashMap* _tmp1663_;
		ValaCCodeExpression* _tmp1664_;
		ValaCCodeExpression* _tmp1665_;
		ValaCCodeUnaryExpression* _tmp1666_;
		ValaCCodeUnaryExpression* _tmp1667_;
		vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
		_tmp1661_ = m;
		_tmp1660_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1661_, VALA_TYPE_CALLABLE, ValaCallable);
		if (_tmp1660_ == NULL) {
			ValaDelegate* _tmp1662_;
			_tmp1662_ = deleg;
			_tmp1660_ = (ValaCallable*) _tmp1662_;
		}
		_tmp1663_ = out_arg_map;
		_tmp1664_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
		_tmp1665_ = _tmp1664_;
		_tmp1666_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1665_);
		_tmp1667_ = _tmp1666_;
		vala_map_set ((ValaMap*) _tmp1663_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_error_pos (_tmp1660_), FALSE)), (ValaCCodeExpression*) _tmp1667_);
		_vala_ccode_node_unref0 (_tmp1667_);
		_vala_ccode_node_unref0 (_tmp1665_);
	} else {
		gboolean _tmp1668_ = FALSE;
		gboolean _tmp1669_ = FALSE;
		ValaMethod* _tmp1670_;
		_tmp1670_ = m;
		if (_tmp1670_ != NULL) {
			ValaMethod* _tmp1671_;
			_tmp1671_ = m;
			_tmp1669_ = vala_method_has_error_type_parameter (_tmp1671_);
		} else {
			_tmp1669_ = FALSE;
		}
		if (_tmp1669_) {
			ValaCCodeFunctionCall* _tmp1672_;
			ValaCCodeFunctionCall* _tmp1673_;
			_tmp1672_ = async_call;
			_tmp1673_ = ccall;
			_tmp1668_ = _tmp1672_ != _tmp1673_;
		} else {
			_tmp1668_ = FALSE;
		}
		if (_tmp1668_) {
			ValaHashMap* _tmp1674_;
			ValaMethod* _tmp1675_;
			ValaCCodeConstant* _tmp1676_;
			ValaCCodeConstant* _tmp1677_;
			_tmp1674_ = out_arg_map;
			_tmp1675_ = m;
			_tmp1676_ = vala_ccode_constant_new ("NULL");
			_tmp1677_ = _tmp1676_;
			vala_map_set ((ValaMap*) _tmp1674_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_error_pos ((ValaCallable*) _tmp1675_), FALSE)), (ValaCCodeExpression*) _tmp1677_);
			_vala_ccode_node_unref0 (_tmp1677_);
		}
	}
	if (ellipsis) {
		ValaMethod* _tmp1678_;
		_tmp1678_ = m;
		if (_tmp1678_ == NULL) {
			ValaHashMap* _tmp1679_;
			ValaCCodeConstant* _tmp1680_;
			ValaCCodeConstant* _tmp1681_;
			_tmp1679_ = in_arg_map;
			_tmp1680_ = vala_ccode_constant_new ("NULL");
			_tmp1681_ = _tmp1680_;
			vala_map_set ((ValaMap*) _tmp1679_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1681_);
			_vala_ccode_node_unref0 (_tmp1681_);
		} else {
			gboolean _tmp1682_ = FALSE;
			gboolean _tmp1683_ = FALSE;
			gboolean _tmp1684_ = FALSE;
			ValaMethod* _tmp1685_;
			gboolean _tmp1686_;
			gboolean _tmp1687_;
			_tmp1685_ = m;
			_tmp1686_ = vala_method_get_printf_format (_tmp1685_);
			_tmp1687_ = _tmp1686_;
			if (!_tmp1687_) {
				ValaMethod* _tmp1688_;
				gboolean _tmp1689_;
				gboolean _tmp1690_;
				_tmp1688_ = m;
				_tmp1689_ = vala_method_get_scanf_format (_tmp1688_);
				_tmp1690_ = _tmp1689_;
				_tmp1684_ = !_tmp1690_;
			} else {
				_tmp1684_ = FALSE;
			}
			if (_tmp1684_) {
				ValaMethod* _tmp1691_;
				gchar* _tmp1692_;
				gchar* _tmp1693_;
				_tmp1691_ = m;
				_tmp1692_ = vala_get_ccode_sentinel (_tmp1691_);
				_tmp1693_ = _tmp1692_;
				_tmp1683_ = g_strcmp0 (_tmp1693_, "") != 0;
				_g_free0 (_tmp1693_);
			} else {
				_tmp1683_ = FALSE;
			}
			if (_tmp1683_) {
				gboolean _tmp1694_;
				gboolean _tmp1695_;
				_tmp1694_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp1695_ = _tmp1694_;
				_tmp1682_ = !_tmp1695_;
			} else {
				_tmp1682_ = FALSE;
			}
			if (_tmp1682_) {
				ValaHashMap* _tmp1696_;
				ValaMethod* _tmp1697_;
				gchar* _tmp1698_;
				gchar* _tmp1699_;
				ValaCCodeConstant* _tmp1700_;
				ValaCCodeConstant* _tmp1701_;
				_tmp1696_ = in_arg_map;
				_tmp1697_ = m;
				_tmp1698_ = vala_get_ccode_sentinel (_tmp1697_);
				_tmp1699_ = _tmp1698_;
				_tmp1700_ = vala_ccode_constant_new (_tmp1699_);
				_tmp1701_ = _tmp1700_;
				vala_map_set ((ValaMap*) _tmp1696_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1701_);
				_vala_ccode_node_unref0 (_tmp1701_);
				_g_free0 (_tmp1699_);
			}
		}
	}
	_tmp1703_ = deleg;
	if (_tmp1703_ != NULL) {
		ValaDelegate* _tmp1704_;
		gboolean _tmp1705_;
		gboolean _tmp1706_;
		_tmp1704_ = deleg;
		_tmp1705_ = vala_delegate_get_has_target (_tmp1704_);
		_tmp1706_ = _tmp1705_;
		_tmp1702_ = _tmp1706_;
	} else {
		_tmp1702_ = FALSE;
	}
	if (_tmp1702_) {
		ValaCCodeExpression* delegate_target_destroy_notify = NULL;
		ValaHashMap* _tmp1707_;
		ValaDelegate* _tmp1708_;
		ValaExpression* _tmp1709_;
		ValaExpression* _tmp1710_;
		ValaCCodeExpression* _tmp1711_ = NULL;
		ValaCCodeExpression* _tmp1712_;
		ValaCCodeExpression* _tmp1713_;
		ValaHashMap* _tmp1714_;
		ValaDelegate* _tmp1715_;
		ValaExpression* _tmp1716_;
		ValaExpression* _tmp1717_;
		ValaCCodeExpression* _tmp1718_ = NULL;
		ValaCCodeExpression* _tmp1719_;
		ValaCCodeExpression* _tmp1720_;
		_tmp1707_ = in_arg_map;
		_tmp1708_ = deleg;
		_tmp1709_ = vala_method_call_get_call (expr);
		_tmp1710_ = _tmp1709_;
		_tmp1712_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1710_, &_tmp1711_);
		_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		delegate_target_destroy_notify = _tmp1711_;
		_tmp1713_ = _tmp1712_;
		vala_map_set ((ValaMap*) _tmp1707_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1708_), FALSE)), _tmp1713_);
		_vala_ccode_node_unref0 (_tmp1713_);
		_tmp1714_ = out_arg_map;
		_tmp1715_ = deleg;
		_tmp1716_ = vala_method_call_get_call (expr);
		_tmp1717_ = _tmp1716_;
		_tmp1719_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1717_, &_tmp1718_);
		_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		delegate_target_destroy_notify = _tmp1718_;
		_tmp1720_ = _tmp1719_;
		vala_map_set ((ValaMap*) _tmp1714_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1715_), FALSE)), _tmp1720_);
		_vala_ccode_node_unref0 (_tmp1720_);
		_vala_ccode_node_unref0 (delegate_target_destroy_notify);
	}
	_tmp1721_ = itype;
	_tmp1722_ = vala_data_type_get_return_type (_tmp1721_);
	return_result_via_out_param = vala_data_type_is_real_non_null_struct_type (_tmp1722_);
	_tmp1724_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1724_, VALA_TYPE_SIGNAL_TYPE)) {
		ValaDataType* _tmp1725_;
		ValaDataType* _tmp1726_;
		_tmp1725_ = itype;
		_tmp1726_ = vala_data_type_get_return_type (_tmp1725_);
		_tmp1723_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1726_, VALA_TYPE_VOID_TYPE);
	} else {
		_tmp1723_ = FALSE;
	}
	if (_tmp1723_) {
		ValaSignal* sig = NULL;
		ValaDataType* _tmp1727_;
		ValaSignal* _tmp1728_;
		ValaSignal* _tmp1729_;
		ValaSignal* _tmp1730_;
		gboolean _tmp1731_ = FALSE;
		gboolean _tmp1732_ = FALSE;
		ValaMemberAccess* _tmp1733_;
		_tmp1727_ = itype;
		_tmp1728_ = vala_signal_type_get_signal_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1727_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
		_tmp1729_ = _tmp1728_;
		_tmp1730_ = _vala_code_node_ref0 (_tmp1729_);
		sig = _tmp1730_;
		_tmp1733_ = ma;
		if (_tmp1733_ != NULL) {
			ValaMemberAccess* _tmp1734_;
			ValaExpression* _tmp1735_;
			ValaExpression* _tmp1736_;
			_tmp1734_ = ma;
			_tmp1735_ = vala_member_access_get_inner (_tmp1734_);
			_tmp1736_ = _tmp1735_;
			_tmp1732_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1736_, VALA_TYPE_BASE_ACCESS);
		} else {
			_tmp1732_ = FALSE;
		}
		if (_tmp1732_) {
			ValaSignal* _tmp1737_;
			gboolean _tmp1738_;
			gboolean _tmp1739_;
			_tmp1737_ = sig;
			_tmp1738_ = vala_signal_get_is_virtual (_tmp1737_);
			_tmp1739_ = _tmp1738_;
			_tmp1731_ = _tmp1739_;
		} else {
			_tmp1731_ = FALSE;
		}
		if (_tmp1731_) {
		} else {
			gboolean _tmp1740_ = FALSE;
			ValaSignal* _tmp1741_;
			_tmp1741_ = sig;
			if (!vala_get_ccode_has_emitter (_tmp1741_)) {
				_tmp1740_ = TRUE;
			} else {
				ValaMemberAccess* _tmp1742_;
				ValaSourceReference* _tmp1743_;
				ValaSourceReference* _tmp1744_;
				ValaSourceFile* _tmp1745_;
				ValaSourceFile* _tmp1746_;
				ValaSignal* _tmp1747_;
				ValaSourceReference* _tmp1748_;
				ValaSourceReference* _tmp1749_;
				ValaSourceFile* _tmp1750_;
				ValaSourceFile* _tmp1751_;
				_tmp1742_ = ma;
				_tmp1743_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1742_);
				_tmp1744_ = _tmp1743_;
				_tmp1745_ = vala_source_reference_get_file (_tmp1744_);
				_tmp1746_ = _tmp1745_;
				_tmp1747_ = sig;
				_tmp1748_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1747_);
				_tmp1749_ = _tmp1748_;
				_tmp1750_ = vala_source_reference_get_file (_tmp1749_);
				_tmp1751_ = _tmp1750_;
				_tmp1740_ = _tmp1746_ == _tmp1751_;
			}
			if (_tmp1740_) {
				return_result_via_out_param = TRUE;
			}
		}
		_vala_code_node_unref0 (sig);
	}
	_tmp1752_ = async_call;
	_tmp1753_ = ccall;
	if (_tmp1752_ == _tmp1753_) {
		return_result_via_out_param = FALSE;
	}
	out_param_ref = NULL;
	if (return_result_via_out_param) {
		ValaLocalVariable* out_param_var = NULL;
		ValaDataType* _tmp1754_;
		ValaDataType* _tmp1755_;
		ValaLocalVariable* _tmp1756_;
		ValaLocalVariable* _tmp1757_;
		const gchar* _tmp1758_;
		const gchar* _tmp1759_;
		ValaCCodeExpression* _tmp1760_;
		ValaLocalVariable* _tmp1761_;
		ValaHashMap* _tmp1762_;
		ValaCCodeExpression* _tmp1763_;
		ValaCCodeUnaryExpression* _tmp1764_;
		ValaCCodeUnaryExpression* _tmp1765_;
		_tmp1754_ = itype;
		_tmp1755_ = vala_data_type_get_return_type (_tmp1754_);
		_tmp1756_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1755_, TRUE, NULL, TRUE);
		out_param_var = _tmp1756_;
		_tmp1757_ = out_param_var;
		_tmp1758_ = vala_symbol_get_name ((ValaSymbol*) _tmp1757_);
		_tmp1759_ = _tmp1758_;
		_tmp1760_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1759_);
		_vala_ccode_node_unref0 (out_param_ref);
		out_param_ref = _tmp1760_;
		_tmp1761_ = out_param_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1761_, FALSE);
		_tmp1762_ = out_arg_map;
		_tmp1763_ = out_param_ref;
		_tmp1764_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1763_);
		_tmp1765_ = _tmp1764_;
		vala_map_set ((ValaMap*) _tmp1762_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -3, FALSE)), (ValaCCodeExpression*) _tmp1765_);
		_vala_ccode_node_unref0 (_tmp1765_);
		_vala_code_node_unref0 (out_param_var);
	}
	_tmp1766_ = async_call;
	_tmp1767_ = ccall;
	if (_tmp1766_ != _tmp1767_) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1778_;
			ValaHashMap* _tmp1779_;
			gpointer _tmp1780_;
			ValaCCodeExpression* _tmp1781_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1768_;
				ValaSet* _tmp1769_;
				ValaSet* _tmp1770_;
				ValaIterator* _tmp1771_;
				ValaIterator* _tmp1772_;
				_tmp1768_ = out_arg_map;
				_tmp1769_ = vala_map_get_keys ((ValaMap*) _tmp1768_);
				_tmp1770_ = _tmp1769_;
				_tmp1771_ = vala_iterable_iterator ((ValaIterable*) _tmp1770_);
				_tmp1772_ = _tmp1771_;
				_vala_iterable_unref0 (_tmp1770_);
				_pos_it = _tmp1772_;
				while (TRUE) {
					ValaIterator* _tmp1773_;
					gint pos = 0;
					ValaIterator* _tmp1774_;
					gpointer _tmp1775_;
					gboolean _tmp1776_ = FALSE;
					_tmp1773_ = _pos_it;
					if (!vala_iterator_next (_tmp1773_)) {
						break;
					}
					_tmp1774_ = _pos_it;
					_tmp1775_ = vala_iterator_get (_tmp1774_);
					pos = (gint) ((gintptr) _tmp1775_);
					if (pos > last_pos) {
						gboolean _tmp1777_ = FALSE;
						if (min_pos == -1) {
							_tmp1777_ = TRUE;
						} else {
							_tmp1777_ = pos < min_pos;
						}
						_tmp1776_ = _tmp1777_;
					} else {
						_tmp1776_ = FALSE;
					}
					if (_tmp1776_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1778_ = ccall;
			_tmp1779_ = out_arg_map;
			_tmp1780_ = vala_map_get ((ValaMap*) _tmp1779_, (gpointer) ((gintptr) min_pos));
			_tmp1781_ = (ValaCCodeExpression*) _tmp1780_;
			vala_ccode_function_call_add_argument (_tmp1778_, _tmp1781_);
			_vala_ccode_node_unref0 (_tmp1781_);
			last_pos = min_pos;
		}
	}
	_tmp1782_ = async_call;
	if (_tmp1782_ != NULL) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1793_;
			ValaHashMap* _tmp1794_;
			gpointer _tmp1795_;
			ValaCCodeExpression* _tmp1796_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1783_;
				ValaSet* _tmp1784_;
				ValaSet* _tmp1785_;
				ValaIterator* _tmp1786_;
				ValaIterator* _tmp1787_;
				_tmp1783_ = in_arg_map;
				_tmp1784_ = vala_map_get_keys ((ValaMap*) _tmp1783_);
				_tmp1785_ = _tmp1784_;
				_tmp1786_ = vala_iterable_iterator ((ValaIterable*) _tmp1785_);
				_tmp1787_ = _tmp1786_;
				_vala_iterable_unref0 (_tmp1785_);
				_pos_it = _tmp1787_;
				while (TRUE) {
					ValaIterator* _tmp1788_;
					gint pos = 0;
					ValaIterator* _tmp1789_;
					gpointer _tmp1790_;
					gboolean _tmp1791_ = FALSE;
					_tmp1788_ = _pos_it;
					if (!vala_iterator_next (_tmp1788_)) {
						break;
					}
					_tmp1789_ = _pos_it;
					_tmp1790_ = vala_iterator_get (_tmp1789_);
					pos = (gint) ((gintptr) _tmp1790_);
					if (pos > last_pos) {
						gboolean _tmp1792_ = FALSE;
						if (min_pos == -1) {
							_tmp1792_ = TRUE;
						} else {
							_tmp1792_ = pos < min_pos;
						}
						_tmp1791_ = _tmp1792_;
					} else {
						_tmp1791_ = FALSE;
					}
					if (_tmp1791_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1793_ = async_call;
			_tmp1794_ = in_arg_map;
			_tmp1795_ = vala_map_get ((ValaMap*) _tmp1794_, (gpointer) ((gintptr) min_pos));
			_tmp1796_ = (ValaCCodeExpression*) _tmp1795_;
			vala_ccode_function_call_add_argument (_tmp1793_, _tmp1796_);
			_vala_ccode_node_unref0 (_tmp1796_);
			last_pos = min_pos;
		}
	}
	_tmp1797_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) expr);
	_tmp1798_ = _tmp1797_;
	if (_tmp1798_) {
		gint state = 0;
		ValaCCodeBaseModuleEmitContext* _tmp1799_;
		gint _tmp1800_;
		ValaCCodeFunction* _tmp1801_;
		ValaCCodeFunction* _tmp1802_;
		ValaCCodeExpression* _tmp1803_;
		ValaCCodeExpression* _tmp1804_;
		gchar* _tmp1805_;
		gchar* _tmp1806_;
		ValaCCodeConstant* _tmp1807_;
		ValaCCodeConstant* _tmp1808_;
		ValaCCodeFunction* _tmp1809_;
		ValaCCodeFunction* _tmp1810_;
		ValaCCodeFunctionCall* _tmp1811_;
		ValaCCodeFunction* _tmp1812_;
		ValaCCodeFunction* _tmp1813_;
		ValaCCodeConstant* _tmp1814_;
		ValaCCodeConstant* _tmp1815_;
		ValaCCodeFunction* _tmp1816_;
		ValaCCodeFunction* _tmp1817_;
		gchar* _tmp1818_;
		gchar* _tmp1819_;
		_tmp1799_ = ((ValaCCodeBaseModule*) self)->emit_context;
		_tmp1800_ = _tmp1799_->next_coroutine_state;
		_tmp1799_->next_coroutine_state = _tmp1800_ + 1;
		state = _tmp1800_;
		_tmp1801_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1802_ = _tmp1801_;
		_tmp1803_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "_state_");
		_tmp1804_ = _tmp1803_;
		_tmp1805_ = g_strdup_printf ("%i", state);
		_tmp1806_ = _tmp1805_;
		_tmp1807_ = vala_ccode_constant_new (_tmp1806_);
		_tmp1808_ = _tmp1807_;
		vala_ccode_function_add_assignment (_tmp1802_, _tmp1804_, (ValaCCodeExpression*) _tmp1808_);
		_vala_ccode_node_unref0 (_tmp1808_);
		_g_free0 (_tmp1806_);
		_vala_ccode_node_unref0 (_tmp1804_);
		_tmp1809_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1810_ = _tmp1809_;
		_tmp1811_ = async_call;
		vala_ccode_function_add_expression (_tmp1810_, (ValaCCodeExpression*) _tmp1811_);
		_tmp1812_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1813_ = _tmp1812_;
		_tmp1814_ = vala_ccode_constant_new ("FALSE");
		_tmp1815_ = _tmp1814_;
		vala_ccode_function_add_return (_tmp1813_, (ValaCCodeExpression*) _tmp1815_);
		_vala_ccode_node_unref0 (_tmp1815_);
		_tmp1816_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1817_ = _tmp1816_;
		_tmp1818_ = g_strdup_printf ("_state_%d", state);
		_tmp1819_ = _tmp1818_;
		vala_ccode_function_add_label (_tmp1817_, _tmp1819_);
		_g_free0 (_tmp1819_);
	}
	_tmp1820_ = vala_method_call_get_is_assert (expr);
	_tmp1821_ = _tmp1820_;
	if (_tmp1821_) {
		gchar* message = NULL;
		ValaSourceReference* _tmp1822_;
		ValaSourceReference* _tmp1823_;
		ValaSourceLocation _tmp1824_ = {0};
		ValaSourceLocation _tmp1825_;
		gchar* _tmp1826_;
		ValaSourceReference* _tmp1827_;
		ValaSourceReference* _tmp1828_;
		ValaSourceLocation _tmp1829_ = {0};
		ValaSourceLocation _tmp1830_;
		gchar* _tmp1831_;
		ValaSourceReference* _tmp1832_;
		ValaSourceReference* _tmp1833_;
		ValaSourceLocation _tmp1834_ = {0};
		ValaSourceLocation _tmp1835_;
		gchar* _tmp1836_;
		gchar* _tmp1837_;
		ValaCCodeFunctionCall* _tmp1838_;
		ValaCCodeIdentifier* _tmp1839_;
		ValaCCodeIdentifier* _tmp1840_;
		ValaCCodeFunctionCall* _tmp1841_;
		const gchar* _tmp1842_;
		gchar* _tmp1843_;
		gchar* _tmp1844_;
		gchar* _tmp1845_;
		gchar* _tmp1846_;
		gchar* _tmp1847_;
		gchar* _tmp1848_;
		ValaCCodeConstant* _tmp1849_;
		ValaCCodeConstant* _tmp1850_;
		_tmp1822_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1823_ = _tmp1822_;
		vala_source_reference_get_begin (_tmp1823_, &_tmp1824_);
		_tmp1825_ = _tmp1824_;
		_tmp1826_ = _tmp1825_.pos;
		_tmp1827_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1828_ = _tmp1827_;
		vala_source_reference_get_end (_tmp1828_, &_tmp1829_);
		_tmp1830_ = _tmp1829_;
		_tmp1831_ = _tmp1830_.pos;
		_tmp1832_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1833_ = _tmp1832_;
		vala_source_reference_get_begin (_tmp1833_, &_tmp1834_);
		_tmp1835_ = _tmp1834_;
		_tmp1836_ = _tmp1835_.pos;
		_tmp1837_ = string_substring ((const gchar*) _tmp1826_, (glong) 0, (glong) ((gint) (_tmp1831_ - _tmp1836_)));
		message = _tmp1837_;
		_tmp1838_ = ccall;
		_tmp1839_ = vala_ccode_identifier_new ("_vala_assert");
		_tmp1840_ = _tmp1839_;
		vala_ccode_function_call_set_call (_tmp1838_, (ValaCCodeExpression*) _tmp1840_);
		_vala_ccode_node_unref0 (_tmp1840_);
		_tmp1841_ = ccall;
		_tmp1842_ = message;
		_tmp1843_ = string_replace (_tmp1842_, "\n", " ");
		_tmp1844_ = _tmp1843_;
		_tmp1845_ = g_strescape (_tmp1844_, "");
		_tmp1846_ = _tmp1845_;
		_tmp1847_ = g_strdup_printf ("\"%s\"", _tmp1846_);
		_tmp1848_ = _tmp1847_;
		_tmp1849_ = vala_ccode_constant_new (_tmp1848_);
		_tmp1850_ = _tmp1849_;
		vala_ccode_function_call_add_argument (_tmp1841_, (ValaCCodeExpression*) _tmp1850_);
		_vala_ccode_node_unref0 (_tmp1850_);
		_g_free0 (_tmp1848_);
		_g_free0 (_tmp1846_);
		_g_free0 (_tmp1844_);
		((ValaCCodeBaseModule*) self)->requires_assert = TRUE;
		_g_free0 (message);
	}
	if (return_result_via_out_param) {
		ValaCCodeFunction* _tmp1851_;
		ValaCCodeFunction* _tmp1852_;
		ValaCCodeExpression* _tmp1853_;
		ValaCCodeExpression* _tmp1854_;
		ValaCCodeExpression* _tmp1855_;
		_tmp1851_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1852_ = _tmp1851_;
		_tmp1853_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1852_, _tmp1853_);
		_tmp1854_ = out_param_ref;
		_tmp1855_ = _vala_ccode_node_ref0 (_tmp1854_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = _tmp1855_;
	}
	_tmp1858_ = m;
	if (_tmp1858_ != NULL) {
		ValaMethod* _tmp1859_;
		ValaMemberBinding _tmp1860_;
		ValaMemberBinding _tmp1861_;
		_tmp1859_ = m;
		_tmp1860_ = vala_method_get_binding (_tmp1859_);
		_tmp1861_ = _tmp1860_;
		_tmp1857_ = _tmp1861_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp1857_ = FALSE;
	}
	if (_tmp1857_) {
		ValaMethod* _tmp1862_;
		gboolean _tmp1863_;
		gboolean _tmp1864_;
		_tmp1862_ = m;
		_tmp1863_ = vala_method_get_returns_modified_pointer (_tmp1862_);
		_tmp1864_ = _tmp1863_;
		_tmp1856_ = _tmp1864_;
	} else {
		_tmp1856_ = FALSE;
	}
	if (_tmp1856_) {
		gboolean _tmp1865_ = FALSE;
		gboolean _tmp1866_ = FALSE;
		ValaMemberAccess* _tmp1867_;
		_tmp1867_ = ma;
		if (_tmp1867_ != NULL) {
			ValaMemberAccess* _tmp1868_;
			ValaExpression* _tmp1869_;
			ValaExpression* _tmp1870_;
			ValaSymbol* _tmp1871_;
			ValaSymbol* _tmp1872_;
			_tmp1868_ = ma;
			_tmp1869_ = vala_member_access_get_inner (_tmp1868_);
			_tmp1870_ = _tmp1869_;
			_tmp1871_ = vala_expression_get_symbol_reference (_tmp1870_);
			_tmp1872_ = _tmp1871_;
			_tmp1866_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1872_, VALA_TYPE_PROPERTY);
		} else {
			_tmp1866_ = FALSE;
		}
		if (_tmp1866_) {
			ValaMemberAccess* _tmp1873_;
			ValaExpression* _tmp1874_;
			ValaExpression* _tmp1875_;
			_tmp1873_ = ma;
			_tmp1874_ = vala_member_access_get_inner (_tmp1873_);
			_tmp1875_ = _tmp1874_;
			_tmp1865_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1875_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp1865_ = FALSE;
		}
		if (_tmp1865_) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp1876_;
			ValaExpression* _tmp1877_;
			ValaExpression* _tmp1878_;
			ValaSymbol* _tmp1879_;
			ValaSymbol* _tmp1880_;
			ValaProperty* _tmp1881_;
			ValaProperty* _tmp1882_;
			ValaMemberAccess* _tmp1883_;
			ValaExpression* _tmp1884_;
			ValaExpression* _tmp1885_;
			ValaExpression* _tmp1886_;
			ValaExpression* _tmp1887_;
			ValaDataType* _tmp1888_;
			ValaDataType* _tmp1889_;
			ValaCCodeExpression* _tmp1890_;
			ValaGLibValue* _tmp1891_;
			ValaGLibValue* _tmp1892_;
			_tmp1876_ = ma;
			_tmp1877_ = vala_member_access_get_inner (_tmp1876_);
			_tmp1878_ = _tmp1877_;
			_tmp1879_ = vala_expression_get_symbol_reference (_tmp1878_);
			_tmp1880_ = _tmp1879_;
			_tmp1881_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1880_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp1881_;
			_tmp1882_ = prop;
			_tmp1883_ = ma;
			_tmp1884_ = vala_member_access_get_inner (_tmp1883_);
			_tmp1885_ = _tmp1884_;
			_tmp1886_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp1885_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp1887_ = _tmp1886_;
			_tmp1888_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1889_ = _tmp1888_;
			_tmp1890_ = ccall_expr;
			_tmp1891_ = vala_glib_value_new (_tmp1889_, _tmp1890_, FALSE);
			_tmp1892_ = _tmp1891_;
			vala_ccode_base_module_store_property ((ValaCCodeBaseModule*) self, _tmp1882_, _tmp1887_, (ValaTargetValue*) _tmp1892_);
			_vala_target_value_unref0 (_tmp1892_);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = NULL;
			_vala_code_node_unref0 (prop);
		} else {
			ValaCCodeExpression* _tmp1893_;
			ValaCCodeExpression* _tmp1894_;
			ValaCCodeAssignment* _tmp1895_;
			_tmp1893_ = instance;
			_tmp1894_ = ccall_expr;
			_tmp1895_ = vala_ccode_assignment_new (_tmp1893_, _tmp1894_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = (ValaCCodeExpression*) _tmp1895_;
		}
	}
	_tmp1901_ = m;
	if (_tmp1901_ != NULL) {
		ValaMethod* _tmp1902_;
		_tmp1902_ = m;
		_tmp1900_ = vala_get_ccode_simple_generics (_tmp1902_);
	} else {
		_tmp1900_ = FALSE;
	}
	if (_tmp1900_) {
		ValaMethod* _tmp1903_;
		ValaDataType* _tmp1904_;
		ValaDataType* _tmp1905_;
		_tmp1903_ = m;
		_tmp1904_ = vala_callable_get_return_type ((ValaCallable*) _tmp1903_);
		_tmp1905_ = _tmp1904_;
		_tmp1899_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1905_, VALA_TYPE_GENERIC_TYPE);
	} else {
		_tmp1899_ = FALSE;
	}
	if (_tmp1899_) {
		ValaDataType* _tmp1906_;
		ValaDataType* _tmp1907_;
		_tmp1906_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1907_ = _tmp1906_;
		_tmp1898_ = vala_data_type_is_real_struct_type (_tmp1907_);
	} else {
		_tmp1898_ = FALSE;
	}
	if (_tmp1898_) {
		ValaDataType* _tmp1908_;
		ValaDataType* _tmp1909_;
		gboolean _tmp1910_;
		gboolean _tmp1911_;
		_tmp1908_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1909_ = _tmp1908_;
		_tmp1910_ = vala_data_type_get_nullable (_tmp1909_);
		_tmp1911_ = _tmp1910_;
		_tmp1897_ = !_tmp1911_;
	} else {
		_tmp1897_ = FALSE;
	}
	if (_tmp1897_) {
		ValaDataType* _tmp1912_;
		ValaDataType* _tmp1913_;
		_tmp1912_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1913_ = _tmp1912_;
		_tmp1896_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1913_, VALA_TYPE_POINTER_TYPE);
	} else {
		_tmp1896_ = FALSE;
	}
	if (_tmp1896_) {
		ValaCCodeExpression* _tmp1914_;
		ValaCCodeParenthesizedExpression* _tmp1915_;
		ValaCCodeParenthesizedExpression* _tmp1916_;
		ValaCCodeUnaryExpression* _tmp1917_;
		_tmp1914_ = ccall_expr;
		_tmp1915_ = vala_ccode_parenthesized_expression_new (_tmp1914_);
		_tmp1916_ = _tmp1915_;
		_tmp1917_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) _tmp1916_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1917_;
		_vala_ccode_node_unref0 (_tmp1916_);
	}
	_tmp1920_ = m;
	if (_tmp1920_ != NULL) {
		ValaMethod* _tmp1921_;
		gchar* _tmp1922_;
		gchar* _tmp1923_;
		_tmp1921_ = m;
		_tmp1922_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1921_);
		_tmp1923_ = _tmp1922_;
		_tmp1919_ = _tmp1923_ != NULL;
		_g_free0 (_tmp1923_);
	} else {
		_tmp1919_ = FALSE;
	}
	if (_tmp1919_) {
		ValaMethod* _tmp1924_;
		gchar* _tmp1925_;
		gchar* _tmp1926_;
		ValaMethod* _tmp1927_;
		ValaDataType* _tmp1928_;
		ValaDataType* _tmp1929_;
		gchar* _tmp1930_;
		gchar* _tmp1931_;
		_tmp1924_ = m;
		_tmp1925_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1924_);
		_tmp1926_ = _tmp1925_;
		_tmp1927_ = m;
		_tmp1928_ = vala_callable_get_return_type ((ValaCallable*) _tmp1927_);
		_tmp1929_ = _tmp1928_;
		_tmp1930_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1929_);
		_tmp1931_ = _tmp1930_;
		_tmp1918_ = g_strcmp0 (_tmp1926_, _tmp1931_) != 0;
		_g_free0 (_tmp1931_);
		_g_free0 (_tmp1926_);
	} else {
		_tmp1918_ = FALSE;
	}
	if (_tmp1918_) {
		ValaCCodeExpression* _tmp1932_;
		ValaMethod* _tmp1933_;
		ValaDataType* _tmp1934_;
		ValaDataType* _tmp1935_;
		gchar* _tmp1936_;
		gchar* _tmp1937_;
		ValaCCodeCastExpression* _tmp1938_;
		_tmp1932_ = ccall_expr;
		_tmp1933_ = m;
		_tmp1934_ = vala_callable_get_return_type ((ValaCallable*) _tmp1933_);
		_tmp1935_ = _tmp1934_;
		_tmp1936_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1935_);
		_tmp1937_ = _tmp1936_;
		_tmp1938_ = vala_ccode_cast_expression_new (_tmp1932_, _tmp1937_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1938_;
		_g_free0 (_tmp1937_);
	}
	_tmp1939_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1939_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaIterator* arg_it = NULL;
		ValaList* _tmp1940_;
		ValaIterator* _tmp1941_;
		ValaIterator* _tmp1942_;
		ValaCCodeExpression* new_size = NULL;
		ValaIterator* _tmp1943_;
		gpointer _tmp1944_;
		ValaExpression* _tmp1945_;
		ValaCCodeExpression* _tmp1946_;
		ValaCCodeExpression* _tmp1947_;
		ValaCCodeExpression* _tmp1948_;
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp1949_;
		ValaExpression* _tmp1950_;
		ValaExpression* _tmp1951_;
		ValaDataType* _tmp1952_;
		ValaDataType* _tmp1953_;
		ValaArrayType* _tmp1954_;
		ValaLocalVariable* temp_decl = NULL;
		ValaArrayType* _tmp1955_;
		ValaDataType* _tmp1956_;
		ValaDataType* _tmp1957_;
		ValaLocalVariable* _tmp1958_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp1959_;
		const gchar* _tmp1960_;
		const gchar* _tmp1961_;
		ValaCCodeExpression* _tmp1962_;
		ValaLocalVariable* _tmp1963_;
		ValaCCodeFile* _tmp1964_;
		ValaCCodeExpression* clen = NULL;
		ValaMemberAccess* _tmp1965_;
		ValaExpression* _tmp1966_;
		ValaExpression* _tmp1967_;
		ValaCCodeExpression* _tmp1968_;
		ValaCCodeExpression* celems = NULL;
		ValaMemberAccess* _tmp1969_;
		ValaExpression* _tmp1970_;
		ValaExpression* _tmp1971_;
		ValaCCodeExpression* _tmp1972_;
		ValaCCodeExpression* _tmp1973_;
		ValaCCodeIdentifier* csizeof = NULL;
		ValaArrayType* _tmp1974_;
		ValaDataType* _tmp1975_;
		ValaDataType* _tmp1976_;
		gchar* _tmp1977_;
		gchar* _tmp1978_;
		gchar* _tmp1979_;
		gchar* _tmp1980_;
		ValaCCodeIdentifier* _tmp1981_;
		ValaCCodeIdentifier* _tmp1982_;
		ValaCCodeBinaryExpression* cdelta = NULL;
		ValaCCodeExpression* _tmp1983_;
		ValaCCodeExpression* _tmp1984_;
		ValaCCodeBinaryExpression* _tmp1985_;
		ValaCCodeBinaryExpression* ccheck = NULL;
		ValaCCodeExpression* _tmp1986_;
		ValaCCodeExpression* _tmp1987_;
		ValaCCodeBinaryExpression* _tmp1988_;
		ValaCCodeFunctionCall* czero = NULL;
		ValaCCodeIdentifier* _tmp1989_;
		ValaCCodeIdentifier* _tmp1990_;
		ValaCCodeFunctionCall* _tmp1991_;
		ValaCCodeFunctionCall* _tmp1992_;
		ValaCCodeFunctionCall* _tmp1993_;
		ValaCCodeExpression* _tmp1994_;
		ValaCCodeExpression* _tmp1995_;
		ValaCCodeBinaryExpression* _tmp1996_;
		ValaCCodeBinaryExpression* _tmp1997_;
		ValaCCodeFunctionCall* _tmp1998_;
		ValaCCodeConstant* _tmp1999_;
		ValaCCodeConstant* _tmp2000_;
		ValaCCodeFunctionCall* _tmp2001_;
		ValaCCodeIdentifier* _tmp2002_;
		ValaCCodeBinaryExpression* _tmp2003_;
		ValaCCodeBinaryExpression* _tmp2004_;
		ValaCCodeBinaryExpression* _tmp2005_;
		ValaCCodeFunction* _tmp2006_;
		ValaCCodeFunction* _tmp2007_;
		ValaCCodeExpression* _tmp2008_;
		ValaCCodeExpression* _tmp2009_;
		ValaCCodeFunction* _tmp2010_;
		ValaCCodeFunction* _tmp2011_;
		ValaCCodeExpression* _tmp2012_;
		ValaCCodeFunction* _tmp2013_;
		ValaCCodeFunction* _tmp2014_;
		ValaCCodeBinaryExpression* _tmp2015_;
		ValaCCodeFunctionCall* _tmp2016_;
		ValaCCodeConstant* _tmp2017_;
		ValaCCodeConstant* _tmp2018_;
		ValaCCodeConditionalExpression* _tmp2019_;
		ValaCCodeConditionalExpression* _tmp2020_;
		ValaCCodeFunction* _tmp2021_;
		ValaCCodeFunction* _tmp2022_;
		ValaMemberAccess* _tmp2023_;
		ValaExpression* _tmp2024_;
		ValaExpression* _tmp2025_;
		ValaCCodeExpression* _tmp2026_;
		ValaCCodeExpression* _tmp2027_;
		ValaCCodeExpression* _tmp2028_;
		ValaSymbol* array_var = NULL;
		ValaMemberAccess* _tmp2029_;
		ValaExpression* _tmp2030_;
		ValaExpression* _tmp2031_;
		ValaSymbol* _tmp2032_;
		ValaSymbol* _tmp2033_;
		ValaSymbol* _tmp2034_;
		gboolean _tmp2035_ = FALSE;
		gboolean _tmp2036_ = FALSE;
		ValaSymbol* _tmp2037_;
		_tmp1940_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) expr);
		_tmp1941_ = vala_iterable_iterator ((ValaIterable*) _tmp1940_);
		arg_it = _tmp1941_;
		_tmp1942_ = arg_it;
		vala_iterator_next (_tmp1942_);
		_tmp1943_ = arg_it;
		_tmp1944_ = vala_iterator_get (_tmp1943_);
		_tmp1945_ = (ValaExpression*) _tmp1944_;
		_tmp1946_ = vala_get_cvalue (_tmp1945_);
		_tmp1947_ = _vala_ccode_node_ref0 (_tmp1946_);
		_tmp1948_ = _tmp1947_;
		_vala_code_node_unref0 (_tmp1945_);
		new_size = _tmp1948_;
		_tmp1949_ = ma;
		_tmp1950_ = vala_member_access_get_inner (_tmp1949_);
		_tmp1951_ = _tmp1950_;
		_tmp1952_ = vala_expression_get_value_type (_tmp1951_);
		_tmp1953_ = _tmp1952_;
		_tmp1954_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1953_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1954_;
		_tmp1955_ = array_type;
		_tmp1956_ = vala_array_type_get_length_type (_tmp1955_);
		_tmp1957_ = _tmp1956_;
		_tmp1958_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1957_, TRUE, NULL, FALSE);
		temp_decl = _tmp1958_;
		_tmp1959_ = temp_decl;
		_tmp1960_ = vala_symbol_get_name ((ValaSymbol*) _tmp1959_);
		_tmp1961_ = _tmp1960_;
		_tmp1962_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1961_);
		temp_ref = _tmp1962_;
		_tmp1963_ = temp_decl;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1963_, FALSE);
		_tmp1964_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp1964_, "string.h", FALSE);
		_tmp1965_ = ma;
		_tmp1966_ = vala_member_access_get_inner (_tmp1965_);
		_tmp1967_ = _tmp1966_;
		_tmp1968_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1967_, 1);
		clen = _tmp1968_;
		_tmp1969_ = ma;
		_tmp1970_ = vala_member_access_get_inner (_tmp1969_);
		_tmp1971_ = _tmp1970_;
		_tmp1972_ = vala_get_cvalue (_tmp1971_);
		_tmp1973_ = _vala_ccode_node_ref0 (_tmp1972_);
		celems = _tmp1973_;
		_tmp1974_ = array_type;
		_tmp1975_ = vala_array_type_get_element_type (_tmp1974_);
		_tmp1976_ = _tmp1975_;
		_tmp1977_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1976_);
		_tmp1978_ = _tmp1977_;
		_tmp1979_ = g_strdup_printf ("sizeof (%s)", _tmp1978_);
		_tmp1980_ = _tmp1979_;
		_tmp1981_ = vala_ccode_identifier_new (_tmp1980_);
		_tmp1982_ = _tmp1981_;
		_g_free0 (_tmp1980_);
		_g_free0 (_tmp1978_);
		csizeof = _tmp1982_;
		_tmp1983_ = temp_ref;
		_tmp1984_ = clen;
		_tmp1985_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, _tmp1983_, _tmp1984_);
		cdelta = _tmp1985_;
		_tmp1986_ = temp_ref;
		_tmp1987_ = clen;
		_tmp1988_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, _tmp1986_, _tmp1987_);
		ccheck = _tmp1988_;
		_tmp1989_ = vala_ccode_identifier_new ("memset");
		_tmp1990_ = _tmp1989_;
		_tmp1991_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1990_);
		_tmp1992_ = _tmp1991_;
		_vala_ccode_node_unref0 (_tmp1990_);
		czero = _tmp1992_;
		_tmp1993_ = czero;
		_tmp1994_ = celems;
		_tmp1995_ = clen;
		_tmp1996_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp1994_, _tmp1995_);
		_tmp1997_ = _tmp1996_;
		vala_ccode_function_call_add_argument (_tmp1993_, (ValaCCodeExpression*) _tmp1997_);
		_vala_ccode_node_unref0 (_tmp1997_);
		_tmp1998_ = czero;
		_tmp1999_ = vala_ccode_constant_new ("0");
		_tmp2000_ = _tmp1999_;
		vala_ccode_function_call_add_argument (_tmp1998_, (ValaCCodeExpression*) _tmp2000_);
		_vala_ccode_node_unref0 (_tmp2000_);
		_tmp2001_ = czero;
		_tmp2002_ = csizeof;
		_tmp2003_ = cdelta;
		_tmp2004_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp2002_, (ValaCCodeExpression*) _tmp2003_);
		_tmp2005_ = _tmp2004_;
		vala_ccode_function_call_add_argument (_tmp2001_, (ValaCCodeExpression*) _tmp2005_);
		_vala_ccode_node_unref0 (_tmp2005_);
		_tmp2006_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2007_ = _tmp2006_;
		_tmp2008_ = temp_ref;
		_tmp2009_ = new_size;
		vala_ccode_function_add_assignment (_tmp2007_, _tmp2008_, _tmp2009_);
		_tmp2010_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2011_ = _tmp2010_;
		_tmp2012_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp2011_, _tmp2012_);
		_tmp2013_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2014_ = _tmp2013_;
		_tmp2015_ = ccheck;
		_tmp2016_ = czero;
		_tmp2017_ = vala_ccode_constant_new ("NULL");
		_tmp2018_ = _tmp2017_;
		_tmp2019_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp2015_, (ValaCCodeExpression*) _tmp2016_, (ValaCCodeExpression*) _tmp2018_);
		_tmp2020_ = _tmp2019_;
		vala_ccode_function_add_expression (_tmp2014_, (ValaCCodeExpression*) _tmp2020_);
		_vala_ccode_node_unref0 (_tmp2020_);
		_vala_ccode_node_unref0 (_tmp2018_);
		_tmp2021_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2022_ = _tmp2021_;
		_tmp2023_ = ma;
		_tmp2024_ = vala_member_access_get_inner (_tmp2023_);
		_tmp2025_ = _tmp2024_;
		_tmp2026_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp2025_, 1);
		_tmp2027_ = _tmp2026_;
		_tmp2028_ = temp_ref;
		vala_ccode_function_add_assignment (_tmp2022_, _tmp2027_, _tmp2028_);
		_vala_ccode_node_unref0 (_tmp2027_);
		_tmp2029_ = ma;
		_tmp2030_ = vala_member_access_get_inner (_tmp2029_);
		_tmp2031_ = _tmp2030_;
		_tmp2032_ = vala_expression_get_symbol_reference (_tmp2031_);
		_tmp2033_ = _tmp2032_;
		_tmp2034_ = _vala_code_node_ref0 (_tmp2033_);
		array_var = _tmp2034_;
		_tmp2037_ = array_var;
		if (_tmp2037_ != NULL) {
			ValaSymbol* _tmp2038_;
			_tmp2038_ = array_var;
			_tmp2036_ = vala_symbol_is_internal_symbol (_tmp2038_);
		} else {
			_tmp2036_ = FALSE;
		}
		if (_tmp2036_) {
			gboolean _tmp2039_ = FALSE;
			ValaSymbol* _tmp2040_;
			_tmp2040_ = array_var;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2040_, VALA_TYPE_LOCAL_VARIABLE)) {
				_tmp2039_ = TRUE;
			} else {
				ValaSymbol* _tmp2041_;
				_tmp2041_ = array_var;
				_tmp2039_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2041_, VALA_TYPE_FIELD);
			}
			_tmp2035_ = _tmp2039_;
		} else {
			_tmp2035_ = FALSE;
		}
		if (_tmp2035_) {
			ValaCCodeFunction* _tmp2042_;
			ValaCCodeFunction* _tmp2043_;
			ValaMemberAccess* _tmp2044_;
			ValaExpression* _tmp2045_;
			ValaExpression* _tmp2046_;
			ValaTargetValue* _tmp2047_;
			ValaTargetValue* _tmp2048_;
			ValaCCodeExpression* _tmp2049_;
			ValaCCodeExpression* _tmp2050_;
			_tmp2042_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp2043_ = _tmp2042_;
			_tmp2044_ = ma;
			_tmp2045_ = vala_member_access_get_inner (_tmp2044_);
			_tmp2046_ = _tmp2045_;
			_tmp2047_ = vala_expression_get_target_value (_tmp2046_);
			_tmp2048_ = _tmp2047_;
			_tmp2049_ = vala_get_array_size_cvalue (_tmp2048_);
			_tmp2050_ = temp_ref;
			vala_ccode_function_add_assignment (_tmp2043_, _tmp2049_, _tmp2050_);
		}
		_vala_code_node_unref0 (array_var);
		_vala_ccode_node_unref0 (czero);
		_vala_ccode_node_unref0 (ccheck);
		_vala_ccode_node_unref0 (cdelta);
		_vala_ccode_node_unref0 (csizeof);
		_vala_ccode_node_unref0 (celems);
		_vala_ccode_node_unref0 (clen);
		_vala_ccode_node_unref0 (temp_ref);
		_vala_code_node_unref0 (temp_decl);
		_vala_code_node_unref0 (array_type);
		_vala_ccode_node_unref0 (new_size);
		_vala_iterator_unref0 (arg_it);
		_vala_ccode_node_unref0 (out_param_ref);
		_vala_iterator_unref0 (params_it);
		_vala_ccode_node_unref0 (instance);
		_vala_ccode_node_unref0 (ccall_expr);
		_vala_map_unref0 (out_arg_map);
		_vala_map_unref0 (in_arg_map);
		_vala_code_node_unref0 (itype);
		_vala_code_node_unref0 (ma);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (deleg);
		_vala_code_node_unref0 (m);
		_vala_ccode_node_unref0 (finish_call);
		_vala_ccode_node_unref0 (async_call);
		_vala_ccode_node_unref0 (ccall);
		return;
	}
	_tmp2052_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
	_tmp2053_ = _tmp2052_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2053_, VALA_TYPE_EXPRESSION_STATEMENT)) {
		ValaDataType* _tmp2054_;
		ValaDataType* _tmp2055_;
		_tmp2054_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp2055_ = _tmp2054_;
		_tmp2051_ = !vala_data_type_is_disposable (_tmp2055_);
	} else {
		_tmp2051_ = FALSE;
	}
	if (_tmp2051_) {
		gboolean _tmp2056_ = FALSE;
		ValaCCodeExpression* _tmp2057_;
		_tmp2057_ = ccall_expr;
		if (_tmp2057_ != NULL) {
			_tmp2056_ = !return_result_via_out_param;
		} else {
			_tmp2056_ = FALSE;
		}
		if (_tmp2056_) {
			ValaCCodeFunction* _tmp2058_;
			ValaCCodeFunction* _tmp2059_;
			ValaCCodeExpression* _tmp2060_;
			_tmp2058_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp2059_ = _tmp2058_;
			_tmp2060_ = ccall_expr;
			vala_ccode_function_add_expression (_tmp2059_, _tmp2060_);
		}
	} else {
		ValaDataType* result_type = NULL;
		ValaDataType* _tmp2061_;
		ValaDataType* _tmp2062_;
		ValaDataType* _tmp2063_;
		gboolean _tmp2064_ = FALSE;
		ValaDataType* _tmp2065_;
		ValaDataType* _tmp2066_;
		gboolean _tmp2119_ = FALSE;
		ValaMethod* _tmp2120_;
		_tmp2061_ = itype;
		_tmp2062_ = vala_data_type_get_return_type (_tmp2061_);
		_tmp2063_ = _vala_code_node_ref0 (_tmp2062_);
		result_type = _tmp2063_;
		_tmp2065_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
		_tmp2066_ = _tmp2065_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2066_, VALA_TYPE_GENERIC_TYPE)) {
			ValaDataType* _tmp2067_;
			ValaDataType* _tmp2068_;
			_tmp2067_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp2068_ = _tmp2067_;
			_tmp2064_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp2068_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp2064_ = FALSE;
		}
		if (_tmp2064_) {
			ValaTypeParameter* type_parameter = NULL;
			ValaDataType* _tmp2069_;
			ValaDataType* _tmp2070_;
			ValaTypeParameter* _tmp2071_;
			ValaTypeParameter* _tmp2072_;
			ValaTypeParameter* _tmp2073_;
			ValaStruct* st = NULL;
			ValaTypeParameter* _tmp2074_;
			ValaSymbol* _tmp2075_;
			ValaSymbol* _tmp2076_;
			ValaSymbol* _tmp2077_;
			ValaSymbol* _tmp2078_;
			ValaStruct* _tmp2079_;
			gboolean _tmp2080_ = FALSE;
			ValaTypeParameter* _tmp2081_;
			ValaSymbol* _tmp2082_;
			ValaSymbol* _tmp2083_;
			ValaTypeSymbol* _tmp2084_;
			gboolean _tmp2093_ = FALSE;
			gboolean _tmp2094_ = FALSE;
			ValaStruct* _tmp2095_;
			_tmp2069_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
			_tmp2070_ = _tmp2069_;
			_tmp2071_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp2070_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
			_tmp2072_ = _tmp2071_;
			_tmp2073_ = _vala_code_node_ref0 (_tmp2072_);
			type_parameter = _tmp2073_;
			_tmp2074_ = type_parameter;
			_tmp2075_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2074_);
			_tmp2076_ = _tmp2075_;
			_tmp2077_ = vala_symbol_get_parent_symbol (_tmp2076_);
			_tmp2078_ = _tmp2077_;
			_tmp2079_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2078_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp2078_) : NULL);
			st = _tmp2079_;
			_tmp2081_ = type_parameter;
			_tmp2082_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2081_);
			_tmp2083_ = _tmp2082_;
			_tmp2084_ = ((ValaCCodeBaseModule*) self)->garray_type;
			if (_tmp2083_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp2084_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				_tmp2080_ = TRUE;
			} else {
				gboolean _tmp2085_ = FALSE;
				ValaStruct* _tmp2086_;
				_tmp2086_ = st;
				if (_tmp2086_ != NULL) {
					ValaStruct* _tmp2087_;
					gchar* _tmp2088_;
					gchar* _tmp2089_;
					_tmp2087_ = st;
					_tmp2088_ = vala_get_ccode_name ((ValaCodeNode*) _tmp2087_);
					_tmp2089_ = _tmp2088_;
					_tmp2085_ = g_strcmp0 (_tmp2089_, "va_list") == 0;
					_g_free0 (_tmp2089_);
				} else {
					_tmp2085_ = FALSE;
				}
				_tmp2080_ = _tmp2085_;
			}
			if (_tmp2080_) {
				ValaDataType* _tmp2090_;
				ValaDataType* _tmp2091_;
				ValaDataType* _tmp2092_;
				_tmp2090_ = vala_expression_get_value_type ((ValaExpression*) expr);
				_tmp2091_ = _tmp2090_;
				_tmp2092_ = _vala_code_node_ref0 (_tmp2091_);
				_vala_code_node_unref0 (result_type);
				result_type = _tmp2092_;
			}
			_tmp2095_ = st;
			if (_tmp2095_ != NULL) {
				ValaStruct* _tmp2096_;
				gchar* _tmp2097_;
				gchar* _tmp2098_;
				_tmp2096_ = st;
				_tmp2097_ = vala_get_ccode_name ((ValaCodeNode*) _tmp2096_);
				_tmp2098_ = _tmp2097_;
				_tmp2094_ = g_strcmp0 (_tmp2098_, "va_list") == 0;
				_g_free0 (_tmp2098_);
			} else {
				_tmp2094_ = FALSE;
			}
			if (_tmp2094_) {
				ValaMemberAccess* _tmp2099_;
				const gchar* _tmp2100_;
				const gchar* _tmp2101_;
				_tmp2099_ = ma;
				_tmp2100_ = vala_member_access_get_member_name (_tmp2099_);
				_tmp2101_ = _tmp2100_;
				_tmp2093_ = g_strcmp0 (_tmp2101_, "arg") == 0;
			} else {
				_tmp2093_ = FALSE;
			}
			if (_tmp2093_) {
				gboolean _tmp2102_ = FALSE;
				ValaDataType* _tmp2103_;
				_tmp2103_ = result_type;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2103_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDataType* _tmp2104_;
					ValaDelegate* _tmp2105_;
					ValaDelegate* _tmp2106_;
					gboolean _tmp2107_;
					gboolean _tmp2108_;
					_tmp2104_ = result_type;
					_tmp2105_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp2104_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
					_tmp2106_ = _tmp2105_;
					_tmp2107_ = vala_delegate_get_has_target (_tmp2106_);
					_tmp2108_ = _tmp2107_;
					_tmp2102_ = _tmp2108_;
				} else {
					_tmp2102_ = FALSE;
				}
				if (_tmp2102_) {
					ValaGLibValue* arg_value = NULL;
					ValaTargetValue* _tmp2109_;
					ValaTargetValue* _tmp2110_;
					ValaGLibValue* _tmp2111_;
					ValaCCodeExpression* _tmp2112_;
					ValaGLibValue* _tmp2115_;
					ValaCCodeExpression* _tmp2116_;
					vala_set_cvalue ((ValaExpression*) expr, NULL);
					_tmp2109_ = vala_expression_get_target_value ((ValaExpression*) expr);
					_tmp2110_ = _tmp2109_;
					arg_value = G_TYPE_CHECK_INSTANCE_CAST (_tmp2110_, VALA_TYPE_GLIB_VALUE, ValaGLibValue);
					_tmp2111_ = arg_value;
					_tmp2112_ = _tmp2111_->delegate_target_cvalue;
					if (_tmp2112_ == NULL) {
						ValaGLibValue* _tmp2113_;
						ValaCCodeConstant* _tmp2114_;
						_tmp2113_ = arg_value;
						_tmp2114_ = vala_ccode_constant_new ("NULL");
						_vala_ccode_node_unref0 (_tmp2113_->delegate_target_cvalue);
						_tmp2113_->delegate_target_cvalue = (ValaCCodeExpression*) _tmp2114_;
					}
					_tmp2115_ = arg_value;
					_tmp2116_ = _tmp2115_->delegate_target_destroy_notify_cvalue;
					if (_tmp2116_ == NULL) {
						ValaGLibValue* _tmp2117_;
						ValaCCodeConstant* _tmp2118_;
						_tmp2117_ = arg_value;
						_tmp2118_ = vala_ccode_constant_new ("NULL");
						_vala_ccode_node_unref0 (_tmp2117_->delegate_target_destroy_notify_cvalue);
						_tmp2117_->delegate_target_destroy_notify_cvalue = (ValaCCodeExpression*) _tmp2118_;
					}
				}
			}
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (type_parameter);
		}
		_tmp2120_ = m;
		if (_tmp2120_ != NULL) {
			ValaMethod* _tmp2121_;
			_tmp2121_ = m;
			_tmp2119_ = vala_method_get_format_arg_index (_tmp2121_) >= 0;
		} else {
			_tmp2119_ = FALSE;
		}
		if (_tmp2119_) {
			ValaCCodeExpression* _tmp2122_;
			_tmp2122_ = ccall_expr;
			vala_set_cvalue ((ValaExpression*) expr, _tmp2122_);
		} else {
			gboolean _tmp2123_ = FALSE;
			ValaMethod* _tmp2124_;
			_tmp2124_ = m;
			if (_tmp2124_ != NULL) {
				ValaMethod* _tmp2125_;
				_tmp2125_ = m;
				_tmp2123_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp2125_, "CCode", "use_inplace", FALSE);
			} else {
				_tmp2123_ = FALSE;
			}
			if (_tmp2123_) {
				ValaCCodeExpression* _tmp2126_;
				_tmp2126_ = ccall_expr;
				vala_set_cvalue ((ValaExpression*) expr, _tmp2126_);
			} else {
				gboolean _tmp2127_ = FALSE;
				gboolean _tmp2128_ = FALSE;
				if (!return_result_via_out_param) {
					_tmp2128_ = !vala_ccode_method_call_module_has_ref_out_argument (self, expr);
				} else {
					_tmp2128_ = FALSE;
				}
				if (_tmp2128_) {
					gboolean _tmp2129_ = FALSE;
					ValaDataType* _tmp2130_;
					_tmp2130_ = result_type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2130_, VALA_TYPE_VALUE_TYPE)) {
						ValaDataType* _tmp2131_;
						_tmp2131_ = result_type;
						_tmp2129_ = !vala_data_type_is_disposable (_tmp2131_);
					} else {
						_tmp2129_ = FALSE;
					}
					_tmp2127_ = _tmp2129_;
				} else {
					_tmp2127_ = FALSE;
				}
				if (_tmp2127_) {
					ValaCCodeExpression* _tmp2132_;
					_tmp2132_ = ccall_expr;
					vala_set_cvalue ((ValaExpression*) expr, _tmp2132_);
				} else {
					if (!return_result_via_out_param) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp2133_;
						ValaDataType* _tmp2134_;
						gboolean _tmp2135_;
						gboolean _tmp2136_;
						ValaLocalVariable* _tmp2137_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp2138_;
						const gchar* _tmp2139_;
						const gchar* _tmp2140_;
						ValaCCodeExpression* _tmp2141_;
						ValaLocalVariable* _tmp2142_;
						ValaCCodeFunction* _tmp2143_;
						ValaCCodeFunction* _tmp2144_;
						ValaCCodeExpression* _tmp2145_;
						ValaCCodeExpression* _tmp2146_;
						ValaCCodeExpression* _tmp2147_;
						ValaTargetValue* _tmp2148_;
						ValaTargetValue* _tmp2149_;
						_tmp2133_ = result_type;
						_tmp2134_ = result_type;
						_tmp2135_ = vala_data_type_get_value_owned (_tmp2134_);
						_tmp2136_ = _tmp2135_;
						_tmp2137_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp2133_, _tmp2136_, NULL, FALSE);
						temp_var = _tmp2137_;
						_tmp2138_ = temp_var;
						_tmp2139_ = vala_symbol_get_name ((ValaSymbol*) _tmp2138_);
						_tmp2140_ = _tmp2139_;
						_tmp2141_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp2140_);
						temp_ref = _tmp2141_;
						_tmp2142_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp2142_, FALSE);
						_tmp2143_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp2144_ = _tmp2143_;
						_tmp2145_ = temp_ref;
						_tmp2146_ = ccall_expr;
						vala_ccode_function_add_assignment (_tmp2144_, _tmp2145_, _tmp2146_);
						_tmp2147_ = temp_ref;
						vala_set_cvalue ((ValaExpression*) expr, _tmp2147_);
						_tmp2148_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2149_ = _tmp2148_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2149_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaCCodeExpression* _tmp2150_;
						ValaTargetValue* _tmp2151_;
						ValaTargetValue* _tmp2152_;
						_tmp2150_ = ccall_expr;
						vala_set_cvalue ((ValaExpression*) expr, _tmp2150_);
						_tmp2151_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2152_ = _tmp2151_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2152_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
					}
				}
			}
		}
		_vala_code_node_unref0 (result_type);
	}
	_tmp2153_ = params;
	_tmp2154_ = vala_iterable_iterator ((ValaIterable*) _tmp2153_);
	_vala_iterator_unref0 (params_it);
	params_it = _tmp2154_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2155_;
		gint _arg_size = 0;
		ValaList* _tmp2156_;
		gint _tmp2157_;
		gint _tmp2158_;
		gint _arg_index = 0;
		_tmp2155_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) expr);
		_arg_list = _tmp2155_;
		_tmp2156_ = _arg_list;
		_tmp2157_ = vala_collection_get_size ((ValaCollection*) _tmp2156_);
		_tmp2158_ = _tmp2157_;
		_arg_size = _tmp2158_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp2159_;
			gint _tmp2160_;
			ValaExpression* arg = NULL;
			ValaList* _tmp2161_;
			gpointer _tmp2162_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp2163_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp2166_;
			ValaUnaryExpression* _tmp2167_;
			gboolean _tmp2168_ = FALSE;
			ValaUnaryExpression* _tmp2169_;
			gboolean _tmp2227_ = FALSE;
			ValaUnaryExpression* _tmp2228_;
			ValaUnaryExpression* _tmp2232_;
			ValaExpression* _tmp2233_;
			ValaExpression* _tmp2234_;
			ValaDataType* _tmp2235_;
			ValaDataType* _tmp2236_;
			gboolean _tmp2246_ = FALSE;
			ValaMemberAccess* _tmp2247_;
			ValaSymbol* _tmp2248_;
			ValaSymbol* _tmp2249_;
			ValaUnaryExpression* _tmp2265_;
			ValaExpression* _tmp2266_;
			ValaExpression* _tmp2267_;
			ValaTargetValue* _tmp2268_;
			ValaTargetValue* _tmp2269_;
			ValaUnaryExpression* _tmp2270_;
			ValaTargetValue* _tmp2271_;
			ValaTargetValue* _tmp2272_;
			ValaUnaryExpression* _tmp2273_;
			ValaExpression* _tmp2274_;
			ValaExpression* _tmp2275_;
			ValaDataType* _tmp2276_;
			ValaDataType* _tmp2277_;
			ValaExpression* _tmp2278_;
			ValaTargetValue* _tmp2279_;
			ValaTargetValue* _tmp2280_;
			ValaSourceReference* _tmp2281_;
			ValaSourceReference* _tmp2282_;
			gboolean _tmp2283_ = FALSE;
			ValaParameter* _tmp2284_;
			_arg_index = _arg_index + 1;
			_tmp2159_ = _arg_index;
			_tmp2160_ = _arg_size;
			if (!(_tmp2159_ < _tmp2160_)) {
				break;
			}
			_tmp2161_ = _arg_list;
			_tmp2162_ = vala_list_get (_tmp2161_, _arg_index);
			arg = (ValaExpression*) _tmp2162_;
			param = NULL;
			_tmp2163_ = params_it;
			if (vala_iterator_next (_tmp2163_)) {
				ValaIterator* _tmp2164_;
				gpointer _tmp2165_;
				_tmp2164_ = params_it;
				_tmp2165_ = vala_iterator_get (_tmp2164_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp2165_;
			}
			_tmp2166_ = arg;
			_tmp2167_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2166_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp2166_) : NULL);
			unary = _tmp2167_;
			_tmp2169_ = unary;
			if (_tmp2169_ != NULL) {
				ValaUnaryExpression* _tmp2170_;
				ValaUnaryOperator _tmp2171_;
				ValaUnaryOperator _tmp2172_;
				_tmp2170_ = unary;
				_tmp2171_ = vala_unary_expression_get_operator (_tmp2170_);
				_tmp2172_ = _tmp2171_;
				_tmp2168_ = _tmp2172_ == VALA_UNARY_OPERATOR_REF;
			} else {
				_tmp2168_ = FALSE;
			}
			if (_tmp2168_) {
				gboolean _tmp2173_ = FALSE;
				gboolean _tmp2174_ = FALSE;
				gboolean _tmp2175_ = FALSE;
				gboolean _tmp2176_ = FALSE;
				ValaParameter* _tmp2177_;
				_tmp2177_ = param;
				if (_tmp2177_ != NULL) {
					ValaParameter* _tmp2178_;
					_tmp2178_ = param;
					_tmp2176_ = vala_get_ccode_array_length ((ValaCodeNode*) _tmp2178_);
				} else {
					_tmp2176_ = FALSE;
				}
				if (_tmp2176_) {
					ValaParameter* _tmp2179_;
					ValaDataType* _tmp2180_;
					ValaDataType* _tmp2181_;
					_tmp2179_ = param;
					_tmp2180_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2179_);
					_tmp2181_ = _tmp2180_;
					_tmp2175_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2181_, VALA_TYPE_ARRAY_TYPE);
				} else {
					_tmp2175_ = FALSE;
				}
				if (_tmp2175_) {
					ValaParameter* _tmp2182_;
					ValaDataType* _tmp2183_;
					ValaDataType* _tmp2184_;
					gboolean _tmp2185_;
					gboolean _tmp2186_;
					_tmp2182_ = param;
					_tmp2183_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2182_);
					_tmp2184_ = _tmp2183_;
					_tmp2185_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp2184_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp2186_ = _tmp2185_;
					_tmp2174_ = !_tmp2186_;
				} else {
					_tmp2174_ = FALSE;
				}
				if (_tmp2174_) {
					ValaParameter* _tmp2187_;
					ValaDataType* _tmp2188_;
					ValaDataType* _tmp2189_;
					gint _tmp2190_;
					gint _tmp2191_;
					_tmp2187_ = param;
					_tmp2188_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2187_);
					_tmp2189_ = _tmp2188_;
					_tmp2190_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp2189_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp2191_ = _tmp2190_;
					_tmp2173_ = _tmp2191_ == 1;
				} else {
					_tmp2173_ = FALSE;
				}
				if (_tmp2173_) {
					ValaVariable* array_var = NULL;
					ValaUnaryExpression* _tmp2192_;
					ValaExpression* _tmp2193_;
					ValaExpression* _tmp2194_;
					ValaSymbol* _tmp2195_;
					ValaSymbol* _tmp2196_;
					gboolean _tmp2197_ = FALSE;
					gboolean _tmp2198_ = FALSE;
					gboolean _tmp2199_ = FALSE;
					gboolean _tmp2200_ = FALSE;
					ValaVariable* _tmp2201_;
					_tmp2192_ = unary;
					_tmp2193_ = vala_unary_expression_get_inner (_tmp2192_);
					_tmp2194_ = _tmp2193_;
					_tmp2195_ = vala_expression_get_symbol_reference (_tmp2194_);
					_tmp2196_ = _tmp2195_;
					array_var = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2196_, VALA_TYPE_VARIABLE) ? ((ValaVariable*) _tmp2196_) : NULL;
					_tmp2201_ = array_var;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2201_, VALA_TYPE_LOCAL_VARIABLE)) {
						_tmp2200_ = TRUE;
					} else {
						ValaVariable* _tmp2202_;
						_tmp2202_ = array_var;
						_tmp2200_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2202_, VALA_TYPE_FIELD);
					}
					if (_tmp2200_) {
						ValaVariable* _tmp2203_;
						_tmp2203_ = array_var;
						_tmp2199_ = vala_symbol_is_internal_symbol ((ValaSymbol*) _tmp2203_);
					} else {
						_tmp2199_ = FALSE;
					}
					if (_tmp2199_) {
						ValaVariable* _tmp2204_;
						ValaDataType* _tmp2205_;
						ValaDataType* _tmp2206_;
						_tmp2204_ = array_var;
						_tmp2205_ = vala_variable_get_variable_type (_tmp2204_);
						_tmp2206_ = _tmp2205_;
						_tmp2198_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2206_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp2198_ = FALSE;
					}
					if (_tmp2198_) {
						ValaVariable* _tmp2207_;
						ValaDataType* _tmp2208_;
						ValaDataType* _tmp2209_;
						gboolean _tmp2210_;
						gboolean _tmp2211_;
						_tmp2207_ = array_var;
						_tmp2208_ = vala_variable_get_variable_type (_tmp2207_);
						_tmp2209_ = _tmp2208_;
						_tmp2210_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp2209_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp2211_ = _tmp2210_;
						_tmp2197_ = !_tmp2211_;
					} else {
						_tmp2197_ = FALSE;
					}
					if (_tmp2197_) {
						ValaCCodeFunction* _tmp2212_;
						ValaCCodeFunction* _tmp2213_;
						ValaUnaryExpression* _tmp2214_;
						ValaExpression* _tmp2215_;
						ValaExpression* _tmp2216_;
						ValaTargetValue* _tmp2217_;
						ValaTargetValue* _tmp2218_;
						ValaCCodeExpression* _tmp2219_;
						ValaUnaryExpression* _tmp2220_;
						ValaExpression* _tmp2221_;
						ValaExpression* _tmp2222_;
						ValaTargetValue* _tmp2223_;
						ValaTargetValue* _tmp2224_;
						ValaCCodeExpression* _tmp2225_;
						ValaCCodeExpression* _tmp2226_;
						_tmp2212_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp2213_ = _tmp2212_;
						_tmp2214_ = unary;
						_tmp2215_ = vala_unary_expression_get_inner (_tmp2214_);
						_tmp2216_ = _tmp2215_;
						_tmp2217_ = vala_expression_get_target_value (_tmp2216_);
						_tmp2218_ = _tmp2217_;
						_tmp2219_ = vala_get_array_size_cvalue (_tmp2218_);
						_tmp2220_ = unary;
						_tmp2221_ = vala_unary_expression_get_inner (_tmp2220_);
						_tmp2222_ = _tmp2221_;
						_tmp2223_ = vala_expression_get_target_value (_tmp2222_);
						_tmp2224_ = _tmp2223_;
						_tmp2225_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2224_, 1);
						_tmp2226_ = _tmp2225_;
						vala_ccode_function_add_assignment (_tmp2213_, _tmp2219_, _tmp2226_);
						_vala_ccode_node_unref0 (_tmp2226_);
					}
				}
			}
			_tmp2228_ = unary;
			if (_tmp2228_ == NULL) {
				_tmp2227_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp2229_;
				ValaUnaryOperator _tmp2230_;
				ValaUnaryOperator _tmp2231_;
				_tmp2229_ = unary;
				_tmp2230_ = vala_unary_expression_get_operator (_tmp2229_);
				_tmp2231_ = _tmp2230_;
				_tmp2227_ = _tmp2231_ != VALA_UNARY_OPERATOR_OUT;
			}
			if (_tmp2227_) {
				_vala_code_node_unref0 (unary);
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp2232_ = unary;
			_tmp2233_ = vala_unary_expression_get_inner (_tmp2232_);
			_tmp2234_ = _tmp2233_;
			_tmp2235_ = vala_expression_get_value_type (_tmp2234_);
			_tmp2236_ = _tmp2235_;
			if (vala_ccode_base_module_requires_destroy (_tmp2236_)) {
				ValaCCodeFunction* _tmp2237_;
				ValaCCodeFunction* _tmp2238_;
				ValaUnaryExpression* _tmp2239_;
				ValaExpression* _tmp2240_;
				ValaExpression* _tmp2241_;
				ValaTargetValue* _tmp2242_;
				ValaTargetValue* _tmp2243_;
				ValaCCodeExpression* _tmp2244_;
				ValaCCodeExpression* _tmp2245_;
				_tmp2237_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2238_ = _tmp2237_;
				_tmp2239_ = unary;
				_tmp2240_ = vala_unary_expression_get_inner (_tmp2239_);
				_tmp2241_ = _tmp2240_;
				_tmp2242_ = vala_expression_get_target_value (_tmp2241_);
				_tmp2243_ = _tmp2242_;
				_tmp2244_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, _tmp2243_, FALSE);
				_tmp2245_ = _tmp2244_;
				vala_ccode_function_add_expression (_tmp2238_, _tmp2245_);
				_vala_ccode_node_unref0 (_tmp2245_);
			}
			_tmp2247_ = ma;
			_tmp2248_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp2247_);
			_tmp2249_ = _tmp2248_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2249_, VALA_TYPE_DYNAMIC_METHOD)) {
				ValaUnaryExpression* _tmp2250_;
				ValaTargetValue* _tmp2251_;
				ValaTargetValue* _tmp2252_;
				ValaDataType* _tmp2253_;
				ValaDataType* _tmp2254_;
				_tmp2250_ = unary;
				_tmp2251_ = vala_expression_get_target_value ((ValaExpression*) _tmp2250_);
				_tmp2252_ = _tmp2251_;
				_tmp2253_ = vala_target_value_get_value_type (_tmp2252_);
				_tmp2254_ = _tmp2253_;
				_tmp2246_ = _tmp2254_ == NULL;
			} else {
				_tmp2246_ = FALSE;
			}
			if (_tmp2246_) {
				ValaUnaryExpression* _tmp2255_;
				ValaTargetValue* _tmp2256_;
				ValaTargetValue* _tmp2257_;
				ValaUnaryExpression* _tmp2258_;
				ValaExpression* _tmp2259_;
				ValaExpression* _tmp2260_;
				ValaDataType* _tmp2261_;
				ValaDataType* _tmp2262_;
				ValaDataType* _tmp2263_;
				ValaDataType* _tmp2264_;
				_tmp2255_ = unary;
				_tmp2256_ = vala_expression_get_target_value ((ValaExpression*) _tmp2255_);
				_tmp2257_ = _tmp2256_;
				_tmp2258_ = unary;
				_tmp2259_ = vala_unary_expression_get_inner (_tmp2258_);
				_tmp2260_ = _tmp2259_;
				_tmp2261_ = vala_expression_get_value_type (_tmp2260_);
				_tmp2262_ = _tmp2261_;
				_tmp2263_ = vala_data_type_copy (_tmp2262_);
				_tmp2264_ = _tmp2263_;
				vala_target_value_set_value_type (_tmp2257_, _tmp2264_);
				_vala_code_node_unref0 (_tmp2264_);
			}
			_tmp2265_ = unary;
			_tmp2266_ = vala_unary_expression_get_inner (_tmp2265_);
			_tmp2267_ = _tmp2266_;
			_tmp2268_ = vala_expression_get_target_value (_tmp2267_);
			_tmp2269_ = _tmp2268_;
			_tmp2270_ = unary;
			_tmp2271_ = vala_expression_get_target_value ((ValaExpression*) _tmp2270_);
			_tmp2272_ = _tmp2271_;
			_tmp2273_ = unary;
			_tmp2274_ = vala_unary_expression_get_inner (_tmp2273_);
			_tmp2275_ = _tmp2274_;
			_tmp2276_ = vala_expression_get_value_type (_tmp2275_);
			_tmp2277_ = _tmp2276_;
			_tmp2278_ = arg;
			_tmp2279_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, _tmp2272_, _tmp2277_, (ValaCodeNode*) _tmp2278_);
			_tmp2280_ = _tmp2279_;
			_tmp2281_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp2282_ = _tmp2281_;
			vala_ccode_base_module_store_value ((ValaCCodeBaseModule*) self, _tmp2269_, _tmp2280_, _tmp2282_);
			_vala_target_value_unref0 (_tmp2280_);
			_tmp2284_ = param;
			if (_tmp2284_ != NULL) {
				ValaParameter* _tmp2285_;
				_tmp2285_ = param;
				_tmp2283_ = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp2285_);
			} else {
				_tmp2283_ = FALSE;
			}
			if (_tmp2283_) {
				ValaCCodeFunctionCall* len_call = NULL;
				ValaCCodeIdentifier* _tmp2286_;
				ValaCCodeIdentifier* _tmp2287_;
				ValaCCodeFunctionCall* _tmp2288_;
				ValaCCodeFunctionCall* _tmp2289_;
				ValaCCodeFunctionCall* _tmp2290_;
				ValaUnaryExpression* _tmp2291_;
				ValaExpression* _tmp2292_;
				ValaExpression* _tmp2293_;
				ValaTargetValue* _tmp2294_;
				ValaTargetValue* _tmp2295_;
				ValaCCodeExpression* _tmp2296_;
				ValaCCodeFunction* _tmp2297_;
				ValaCCodeFunction* _tmp2298_;
				ValaUnaryExpression* _tmp2299_;
				ValaExpression* _tmp2300_;
				ValaExpression* _tmp2301_;
				ValaTargetValue* _tmp2302_;
				ValaTargetValue* _tmp2303_;
				ValaCCodeExpression* _tmp2304_;
				ValaCCodeExpression* _tmp2305_;
				ValaCCodeFunctionCall* _tmp2306_;
				((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
				_tmp2286_ = vala_ccode_identifier_new ("_vala_array_length");
				_tmp2287_ = _tmp2286_;
				_tmp2288_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2287_);
				_tmp2289_ = _tmp2288_;
				_vala_ccode_node_unref0 (_tmp2287_);
				len_call = _tmp2289_;
				_tmp2290_ = len_call;
				_tmp2291_ = unary;
				_tmp2292_ = vala_unary_expression_get_inner (_tmp2291_);
				_tmp2293_ = _tmp2292_;
				_tmp2294_ = vala_expression_get_target_value (_tmp2293_);
				_tmp2295_ = _tmp2294_;
				_tmp2296_ = vala_get_cvalue_ (_tmp2295_);
				vala_ccode_function_call_add_argument (_tmp2290_, _tmp2296_);
				_tmp2297_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2298_ = _tmp2297_;
				_tmp2299_ = unary;
				_tmp2300_ = vala_unary_expression_get_inner (_tmp2299_);
				_tmp2301_ = _tmp2300_;
				_tmp2302_ = vala_expression_get_target_value (_tmp2301_);
				_tmp2303_ = _tmp2302_;
				_tmp2304_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2303_, 1);
				_tmp2305_ = _tmp2304_;
				_tmp2306_ = len_call;
				vala_ccode_function_add_assignment (_tmp2298_, _tmp2305_, (ValaCCodeExpression*) _tmp2306_);
				_vala_ccode_node_unref0 (_tmp2305_);
				_vala_ccode_node_unref0 (len_call);
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp2309_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2309_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp2310_;
		ValaSymbol* _tmp2311_;
		ValaSymbol* _tmp2312_;
		_tmp2310_ = m;
		_tmp2311_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2310_);
		_tmp2312_ = _tmp2311_;
		_tmp2308_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2312_, VALA_TYPE_CLASS);
	} else {
		_tmp2308_ = FALSE;
	}
	if (_tmp2308_) {
		gboolean _tmp2313_ = FALSE;
		gboolean _tmp2314_ = FALSE;
		ValaClass* _tmp2315_;
		ValaClass* _tmp2316_;
		gboolean _tmp2317_;
		gboolean _tmp2318_;
		_tmp2315_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2316_ = _tmp2315_;
		_tmp2317_ = vala_class_get_is_compact (_tmp2316_);
		_tmp2318_ = _tmp2317_;
		if (_tmp2318_) {
			ValaClass* _tmp2319_;
			ValaClass* _tmp2320_;
			ValaClass* _tmp2321_;
			ValaClass* _tmp2322_;
			_tmp2319_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2320_ = _tmp2319_;
			_tmp2321_ = vala_class_get_base_class (_tmp2320_);
			_tmp2322_ = _tmp2321_;
			_tmp2314_ = _tmp2322_ != NULL;
		} else {
			_tmp2314_ = FALSE;
		}
		if (_tmp2314_) {
			_tmp2313_ = TRUE;
		} else {
			ValaClass* _tmp2323_;
			ValaClass* _tmp2324_;
			ValaClass* _tmp2325_;
			_tmp2323_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2324_ = _tmp2323_;
			_tmp2325_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			_tmp2313_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp2324_, (ValaTypeSymbol*) _tmp2325_);
		}
		_tmp2307_ = _tmp2313_;
	} else {
		_tmp2307_ = FALSE;
	}
	if (_tmp2307_) {
		ValaCCodeFunctionCall* cinitcall = NULL;
		ValaClass* _tmp2326_;
		ValaClass* _tmp2327_;
		gchar* _tmp2328_;
		gchar* _tmp2329_;
		gchar* _tmp2330_;
		gchar* _tmp2331_;
		ValaCCodeIdentifier* _tmp2332_;
		ValaCCodeIdentifier* _tmp2333_;
		ValaCCodeFunctionCall* _tmp2334_;
		ValaCCodeFunctionCall* _tmp2335_;
		ValaCCodeFunctionCall* _tmp2336_;
		ValaCCodeExpression* _tmp2337_;
		ValaCCodeExpression* _tmp2338_;
		ValaClass* _tmp2339_;
		ValaClass* _tmp2340_;
		gboolean _tmp2341_;
		gboolean _tmp2342_;
		ValaCCodeFunction* _tmp2346_;
		ValaCCodeFunction* _tmp2347_;
		ValaCCodeFunctionCall* _tmp2348_;
		_tmp2326_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2327_ = _tmp2326_;
		_tmp2328_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp2327_, NULL);
		_tmp2329_ = _tmp2328_;
		_tmp2330_ = g_strdup_printf ("%s_instance_init", _tmp2329_);
		_tmp2331_ = _tmp2330_;
		_tmp2332_ = vala_ccode_identifier_new (_tmp2331_);
		_tmp2333_ = _tmp2332_;
		_tmp2334_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2333_);
		_tmp2335_ = _tmp2334_;
		_vala_ccode_node_unref0 (_tmp2333_);
		_g_free0 (_tmp2331_);
		_g_free0 (_tmp2329_);
		cinitcall = _tmp2335_;
		_tmp2336_ = cinitcall;
		_tmp2337_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp2338_ = _tmp2337_;
		vala_ccode_function_call_add_argument (_tmp2336_, _tmp2338_);
		_vala_ccode_node_unref0 (_tmp2338_);
		_tmp2339_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2340_ = _tmp2339_;
		_tmp2341_ = vala_class_get_is_compact (_tmp2340_);
		_tmp2342_ = _tmp2341_;
		if (!_tmp2342_) {
			ValaCCodeFunctionCall* _tmp2343_;
			ValaCCodeConstant* _tmp2344_;
			ValaCCodeConstant* _tmp2345_;
			_tmp2343_ = cinitcall;
			_tmp2344_ = vala_ccode_constant_new ("NULL");
			_tmp2345_ = _tmp2344_;
			vala_ccode_function_call_add_argument (_tmp2343_, (ValaCCodeExpression*) _tmp2345_);
			_vala_ccode_node_unref0 (_tmp2345_);
		}
		_tmp2346_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2347_ = _tmp2346_;
		_tmp2348_ = cinitcall;
		vala_ccode_function_add_expression (_tmp2347_, (ValaCCodeExpression*) _tmp2348_);
		_vala_ccode_node_unref0 (cinitcall);
	}
	_vala_ccode_node_unref0 (out_param_ref);
	_vala_iterator_unref0 (params_it);
	_vala_ccode_node_unref0 (instance);
	_vala_ccode_node_unref0 (ccall_expr);
	_vala_map_unref0 (out_arg_map);
	_vala_map_unref0 (in_arg_map);
	_vala_code_node_unref0 (itype);
	_vala_code_node_unref0 (ma);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (deleg);
	_vala_code_node_unref0 (m);
	_vala_ccode_node_unref0 (finish_call);
	_vala_ccode_node_unref0 (async_call);
	_vala_ccode_node_unref0 (ccall);
}

static gchar*
vala_ccode_method_call_module_generate_enum_to_string_function (ValaCCodeMethodCallModule* self,
                                                                ValaEnum* en)
{
	gchar* to_string_func = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCCodeFunction* function = NULL;
	const gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeBaseModuleEmitContext* _tmp13_;
	ValaCCodeBaseModuleEmitContext* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeFunction* _tmp46_;
	ValaCCodeFunction* _tmp47_;
	ValaCCodeFunction* _tmp48_;
	ValaCCodeFunction* _tmp49_;
	ValaCCodeConstant* _tmp50_;
	ValaCCodeConstant* _tmp51_;
	ValaCCodeFile* _tmp52_;
	ValaCCodeFunction* _tmp53_;
	ValaCCodeFile* _tmp54_;
	ValaCCodeFunction* _tmp55_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_%s_to_string", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	to_string_func = _tmp3_;
	_tmp4_ = to_string_func;
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, _tmp4_)) {
		result = to_string_func;
		return result;
	}
	_tmp5_ = to_string_func;
	_tmp6_ = vala_ccode_function_new (_tmp5_, "const char*");
	function = _tmp6_;
	_tmp7_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp7_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8_ = function;
	_tmp9_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_parameter_new ("value", _tmp10_);
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp8_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp14_ = _tmp13_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp14_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp14_);
	_tmp15_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_constant_new ("value");
	_tmp19_ = _tmp18_;
	vala_ccode_function_open_switch (_tmp17_, (ValaCCodeExpression*) _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	{
		ValaList* _enum_value_list = NULL;
		ValaList* _tmp20_;
		gint _enum_value_size = 0;
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _enum_value_index = 0;
		_tmp20_ = vala_enum_get_values (en);
		_enum_value_list = _tmp20_;
		_tmp21_ = _enum_value_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_enum_value_size = _tmp23_;
		_enum_value_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			ValaEnumValue* enum_value = NULL;
			ValaList* _tmp26_;
			gpointer _tmp27_;
			ValaCCodeFunction* _tmp28_;
			ValaCCodeFunction* _tmp29_;
			ValaEnumValue* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			ValaCCodeIdentifier* _tmp33_;
			ValaCCodeIdentifier* _tmp34_;
			ValaCCodeFunction* _tmp35_;
			ValaCCodeFunction* _tmp36_;
			ValaEnumValue* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			ValaCCodeConstant* _tmp44_;
			ValaCCodeConstant* _tmp45_;
			_enum_value_index = _enum_value_index + 1;
			_tmp24_ = _enum_value_index;
			_tmp25_ = _enum_value_size;
			if (!(_tmp24_ < _tmp25_)) {
				break;
			}
			_tmp26_ = _enum_value_list;
			_tmp27_ = vala_list_get (_tmp26_, _enum_value_index);
			enum_value = (ValaEnumValue*) _tmp27_;
			_tmp28_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp29_ = _tmp28_;
			_tmp30_ = enum_value;
			_tmp31_ = vala_get_ccode_name ((ValaCodeNode*) _tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = vala_ccode_identifier_new (_tmp32_);
			_tmp34_ = _tmp33_;
			vala_ccode_function_add_case (_tmp29_, (ValaCCodeExpression*) _tmp34_);
			_vala_ccode_node_unref0 (_tmp34_);
			_g_free0 (_tmp32_);
			_tmp35_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp36_ = _tmp35_;
			_tmp37_ = enum_value;
			_tmp38_ = vala_get_ccode_name ((ValaCodeNode*) _tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = g_strconcat ("\"", _tmp39_, NULL);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_strconcat (_tmp41_, "\"", NULL);
			_tmp43_ = _tmp42_;
			_tmp44_ = vala_ccode_constant_new (_tmp43_);
			_tmp45_ = _tmp44_;
			vala_ccode_function_add_return (_tmp36_, (ValaCCodeExpression*) _tmp45_);
			_vala_ccode_node_unref0 (_tmp45_);
			_g_free0 (_tmp43_);
			_g_free0 (_tmp41_);
			_g_free0 (_tmp39_);
			_vala_code_node_unref0 (enum_value);
		}
	}
	_tmp46_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp47_ = _tmp46_;
	vala_ccode_function_close (_tmp47_);
	_tmp48_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp49_ = _tmp48_;
	_tmp50_ = vala_ccode_constant_new ("NULL");
	_tmp51_ = _tmp50_;
	vala_ccode_function_add_return (_tmp49_, (ValaCCodeExpression*) _tmp51_);
	_vala_ccode_node_unref0 (_tmp51_);
	_tmp52_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp53_ = function;
	vala_ccode_file_add_function_declaration (_tmp52_, _tmp53_);
	_tmp54_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp55_ = function;
	vala_ccode_file_add_function (_tmp54_, _tmp55_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	result = to_string_func;
	_vala_ccode_node_unref0 (function);
	return result;
}

static gboolean
vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                    ValaMethodCall* c)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) c);
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* arg = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp8_;
			gboolean _tmp9_ = FALSE;
			ValaUnaryExpression* _tmp10_;
			_arg_index = _arg_index + 1;
			_tmp4_ = _arg_index;
			_tmp5_ = _arg_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _arg_list;
			_tmp7_ = vala_list_get (_tmp6_, _arg_index);
			arg = (ValaExpression*) _tmp7_;
			_tmp8_ = arg;
			unary = G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp8_) : NULL;
			_tmp10_ = unary;
			if (_tmp10_ != NULL) {
				gboolean _tmp11_ = FALSE;
				ValaUnaryExpression* _tmp12_;
				ValaUnaryOperator _tmp13_;
				ValaUnaryOperator _tmp14_;
				_tmp12_ = unary;
				_tmp13_ = vala_unary_expression_get_operator (_tmp12_);
				_tmp14_ = _tmp13_;
				if (_tmp14_ == VALA_UNARY_OPERATOR_OUT) {
					_tmp11_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp15_;
					ValaUnaryOperator _tmp16_;
					ValaUnaryOperator _tmp17_;
					_tmp15_ = unary;
					_tmp16_ = vala_unary_expression_get_operator (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp11_ = _tmp17_ == VALA_UNARY_OPERATOR_REF;
				}
				_tmp9_ = _tmp11_;
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				result = TRUE;
				_vala_code_node_unref0 (arg);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
	}
	result = FALSE;
	return result;
}

static gchar*
vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self)
{
	ValaCCodeFunction* function = NULL;
	ValaCCodeFunction* _tmp1_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeParameter* _tmp3_;
	ValaCCodeParameter* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeParameter* _tmp6_;
	ValaCCodeParameter* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeBaseModuleEmitContext* _tmp9_;
	ValaCCodeBaseModuleEmitContext* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	ValaCCodeFunction* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeVariableDeclarator* _tmp14_;
	ValaCCodeVariableDeclarator* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeVariableDeclarator* _tmp18_;
	ValaCCodeVariableDeclarator* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaCCodeVariableDeclarator* _tmp22_;
	ValaCCodeVariableDeclarator* _tmp23_;
	ValaCCodeFunctionCall* va_start = NULL;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeFunctionCall* _tmp26_;
	ValaCCodeFunctionCall* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	ValaCCodeIdentifier* _tmp29_;
	ValaCCodeIdentifier* _tmp30_;
	ValaCCodeFunctionCall* _tmp31_;
	ValaCCodeIdentifier* _tmp32_;
	ValaCCodeIdentifier* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaCCodeFunctionCall* _tmp36_;
	ValaCodeContext* _tmp37_;
	ValaCodeContext* _tmp38_;
	ValaProfile _tmp39_;
	ValaProfile _tmp40_;
	ValaCCodeFunctionCall* vsnprintf = NULL;
	ValaCCodeIdentifier* _tmp42_;
	ValaCCodeIdentifier* _tmp43_;
	ValaCCodeFunctionCall* _tmp44_;
	ValaCCodeFunctionCall* _tmp45_;
	ValaCCodeFunctionCall* _tmp46_;
	ValaCCodeConstant* _tmp47_;
	ValaCCodeConstant* _tmp48_;
	ValaCCodeFunctionCall* _tmp49_;
	ValaCCodeConstant* _tmp50_;
	ValaCCodeConstant* _tmp51_;
	ValaCCodeFunctionCall* _tmp52_;
	ValaCCodeIdentifier* _tmp53_;
	ValaCCodeIdentifier* _tmp54_;
	ValaCCodeFunctionCall* _tmp55_;
	ValaCCodeIdentifier* _tmp56_;
	ValaCCodeIdentifier* _tmp57_;
	ValaCCodeFunction* _tmp58_;
	ValaCCodeFunction* _tmp59_;
	ValaCCodeIdentifier* _tmp60_;
	ValaCCodeIdentifier* _tmp61_;
	ValaCCodeFunctionCall* _tmp62_;
	ValaCCodeConstant* _tmp63_;
	ValaCCodeConstant* _tmp64_;
	ValaCCodeBinaryExpression* _tmp65_;
	ValaCCodeBinaryExpression* _tmp66_;
	ValaCCodeFunctionCall* va_end = NULL;
	ValaCCodeIdentifier* _tmp67_;
	ValaCCodeIdentifier* _tmp68_;
	ValaCCodeFunctionCall* _tmp69_;
	ValaCCodeFunctionCall* _tmp70_;
	ValaCCodeFunctionCall* _tmp71_;
	ValaCCodeIdentifier* _tmp72_;
	ValaCCodeIdentifier* _tmp73_;
	ValaCCodeFunction* _tmp74_;
	ValaCCodeFunction* _tmp75_;
	ValaCCodeFunctionCall* _tmp76_;
	ValaCCodeFunctionCall* malloc = NULL;
	ValaCCodeIdentifier* _tmp77_;
	ValaCCodeIdentifier* _tmp78_;
	ValaCCodeFunctionCall* _tmp79_;
	ValaCCodeFunctionCall* _tmp80_;
	ValaCCodeFunctionCall* _tmp81_;
	ValaCCodeIdentifier* _tmp82_;
	ValaCCodeIdentifier* _tmp83_;
	ValaCCodeFunction* _tmp84_;
	ValaCCodeFunction* _tmp85_;
	ValaCCodeIdentifier* _tmp86_;
	ValaCCodeIdentifier* _tmp87_;
	ValaCCodeFunctionCall* _tmp88_;
	ValaCCodeIdentifier* _tmp89_;
	ValaCCodeIdentifier* _tmp90_;
	ValaCCodeFunctionCall* _tmp91_;
	ValaCCodeFunctionCall* _tmp92_;
	ValaCCodeIdentifier* _tmp93_;
	ValaCCodeIdentifier* _tmp94_;
	ValaCCodeFunctionCall* _tmp95_;
	ValaCCodeIdentifier* _tmp96_;
	ValaCCodeIdentifier* _tmp97_;
	ValaCCodeFunction* _tmp98_;
	ValaCCodeFunction* _tmp99_;
	ValaCCodeFunctionCall* _tmp100_;
	ValaCCodeIdentifier* _tmp101_;
	ValaCCodeIdentifier* _tmp102_;
	ValaCCodeFunctionCall* _tmp103_;
	ValaCCodeFunctionCall* _tmp104_;
	ValaCCodeIdentifier* _tmp105_;
	ValaCCodeIdentifier* _tmp106_;
	ValaCCodeFunctionCall* _tmp107_;
	ValaCCodeIdentifier* _tmp108_;
	ValaCCodeIdentifier* _tmp109_;
	ValaCCodeFunctionCall* _tmp110_;
	ValaCCodeIdentifier* _tmp111_;
	ValaCCodeIdentifier* _tmp112_;
	ValaCCodeFunctionCall* _tmp113_;
	ValaCCodeIdentifier* _tmp114_;
	ValaCCodeIdentifier* _tmp115_;
	ValaCCodeFunction* _tmp116_;
	ValaCCodeFunction* _tmp117_;
	ValaCCodeFunctionCall* _tmp118_;
	ValaCCodeIdentifier* _tmp119_;
	ValaCCodeIdentifier* _tmp120_;
	ValaCCodeFunctionCall* _tmp121_;
	ValaCCodeFunctionCall* _tmp122_;
	ValaCCodeIdentifier* _tmp123_;
	ValaCCodeIdentifier* _tmp124_;
	ValaCCodeFunction* _tmp125_;
	ValaCCodeFunction* _tmp126_;
	ValaCCodeFunctionCall* _tmp127_;
	ValaCCodeFunction* _tmp128_;
	ValaCCodeFunction* _tmp129_;
	ValaCCodeIdentifier* _tmp130_;
	ValaCCodeIdentifier* _tmp131_;
	ValaCCodeFile* _tmp132_;
	ValaCCodeFile* _tmp133_;
	ValaCCodeFunction* _tmp134_;
	ValaCCodeFile* _tmp135_;
	ValaCCodeFunction* _tmp136_;
	gchar* _tmp137_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, "string_printf")) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("string_printf");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = vala_ccode_function_new ("string_printf", "char*");
	function = _tmp1_;
	_tmp2_ = function;
	_tmp3_ = vala_ccode_parameter_new ("format", "const char*");
	_tmp4_ = _tmp3_;
	vala_ccode_function_add_parameter (_tmp2_, _tmp4_);
	_vala_ccode_node_unref0 (_tmp4_);
	_tmp5_ = function;
	_tmp6_ = vala_ccode_parameter_new_with_ellipsis ();
	_tmp7_ = _tmp6_;
	vala_ccode_function_add_parameter (_tmp5_, _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	_tmp8_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp8_, VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_PRINTF);
	_tmp9_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp10_ = _tmp9_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp10_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp10_);
	_tmp11_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp11_);
	_tmp12_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_variable_declarator_new ("length", NULL, NULL);
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_declaration (_tmp13_, "int", (ValaCCodeDeclarator*) _tmp15_, 0);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_variable_declarator_new ("ap", NULL, NULL);
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_declaration (_tmp17_, "va_list", (ValaCCodeDeclarator*) _tmp19_, 0);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_variable_declarator_new ("result", NULL, NULL);
	_tmp23_ = _tmp22_;
	vala_ccode_function_add_declaration (_tmp21_, "char*", (ValaCCodeDeclarator*) _tmp23_, 0);
	_vala_ccode_node_unref0 (_tmp23_);
	_tmp24_ = vala_ccode_identifier_new ("va_start");
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp25_);
	_tmp27_ = _tmp26_;
	_vala_ccode_node_unref0 (_tmp25_);
	va_start = _tmp27_;
	_tmp28_ = va_start;
	_tmp29_ = vala_ccode_identifier_new ("ap");
	_tmp30_ = _tmp29_;
	vala_ccode_function_call_add_argument (_tmp28_, (ValaCCodeExpression*) _tmp30_);
	_vala_ccode_node_unref0 (_tmp30_);
	_tmp31_ = va_start;
	_tmp32_ = vala_ccode_identifier_new ("format");
	_tmp33_ = _tmp32_;
	vala_ccode_function_call_add_argument (_tmp31_, (ValaCCodeExpression*) _tmp33_);
	_vala_ccode_node_unref0 (_tmp33_);
	_tmp34_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = va_start;
	vala_ccode_function_add_expression (_tmp35_, (ValaCCodeExpression*) _tmp36_);
	_tmp37_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
	_tmp38_ = _tmp37_;
	_tmp39_ = vala_code_context_get_profile (_tmp38_);
	_tmp40_ = _tmp39_;
	if (_tmp40_ == VALA_PROFILE_POSIX) {
		ValaCCodeFile* _tmp41_;
		_tmp41_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp41_, "stdio.h", FALSE);
	}
	_tmp42_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp43_ = _tmp42_;
	_tmp44_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp43_);
	_tmp45_ = _tmp44_;
	_vala_ccode_node_unref0 (_tmp43_);
	vsnprintf = _tmp45_;
	_tmp46_ = vsnprintf;
	_tmp47_ = vala_ccode_constant_new ("NULL");
	_tmp48_ = _tmp47_;
	vala_ccode_function_call_add_argument (_tmp46_, (ValaCCodeExpression*) _tmp48_);
	_vala_ccode_node_unref0 (_tmp48_);
	_tmp49_ = vsnprintf;
	_tmp50_ = vala_ccode_constant_new ("0");
	_tmp51_ = _tmp50_;
	vala_ccode_function_call_add_argument (_tmp49_, (ValaCCodeExpression*) _tmp51_);
	_vala_ccode_node_unref0 (_tmp51_);
	_tmp52_ = vsnprintf;
	_tmp53_ = vala_ccode_identifier_new ("format");
	_tmp54_ = _tmp53_;
	vala_ccode_function_call_add_argument (_tmp52_, (ValaCCodeExpression*) _tmp54_);
	_vala_ccode_node_unref0 (_tmp54_);
	_tmp55_ = vsnprintf;
	_tmp56_ = vala_ccode_identifier_new ("ap");
	_tmp57_ = _tmp56_;
	vala_ccode_function_call_add_argument (_tmp55_, (ValaCCodeExpression*) _tmp57_);
	_vala_ccode_node_unref0 (_tmp57_);
	_tmp58_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp59_ = _tmp58_;
	_tmp60_ = vala_ccode_identifier_new ("length");
	_tmp61_ = _tmp60_;
	_tmp62_ = vsnprintf;
	_tmp63_ = vala_ccode_constant_new ("1");
	_tmp64_ = _tmp63_;
	_tmp65_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp62_, (ValaCCodeExpression*) _tmp64_);
	_tmp66_ = _tmp65_;
	vala_ccode_function_add_assignment (_tmp59_, (ValaCCodeExpression*) _tmp61_, (ValaCCodeExpression*) _tmp66_);
	_vala_ccode_node_unref0 (_tmp66_);
	_vala_ccode_node_unref0 (_tmp64_);
	_vala_ccode_node_unref0 (_tmp61_);
	_tmp67_ = vala_ccode_identifier_new ("va_end");
	_tmp68_ = _tmp67_;
	_tmp69_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp68_);
	_tmp70_ = _tmp69_;
	_vala_ccode_node_unref0 (_tmp68_);
	va_end = _tmp70_;
	_tmp71_ = va_end;
	_tmp72_ = vala_ccode_identifier_new ("ap");
	_tmp73_ = _tmp72_;
	vala_ccode_function_call_add_argument (_tmp71_, (ValaCCodeExpression*) _tmp73_);
	_vala_ccode_node_unref0 (_tmp73_);
	_tmp74_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp75_ = _tmp74_;
	_tmp76_ = va_end;
	vala_ccode_function_add_expression (_tmp75_, (ValaCCodeExpression*) _tmp76_);
	_tmp77_ = vala_ccode_identifier_new ("malloc");
	_tmp78_ = _tmp77_;
	_tmp79_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp78_);
	_tmp80_ = _tmp79_;
	_vala_ccode_node_unref0 (_tmp78_);
	malloc = _tmp80_;
	_tmp81_ = malloc;
	_tmp82_ = vala_ccode_identifier_new ("length");
	_tmp83_ = _tmp82_;
	vala_ccode_function_call_add_argument (_tmp81_, (ValaCCodeExpression*) _tmp83_);
	_vala_ccode_node_unref0 (_tmp83_);
	_tmp84_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp85_ = _tmp84_;
	_tmp86_ = vala_ccode_identifier_new ("result");
	_tmp87_ = _tmp86_;
	_tmp88_ = malloc;
	vala_ccode_function_add_assignment (_tmp85_, (ValaCCodeExpression*) _tmp87_, (ValaCCodeExpression*) _tmp88_);
	_vala_ccode_node_unref0 (_tmp87_);
	_tmp89_ = vala_ccode_identifier_new ("va_start");
	_tmp90_ = _tmp89_;
	_tmp91_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp90_);
	_vala_ccode_node_unref0 (va_start);
	va_start = _tmp91_;
	_vala_ccode_node_unref0 (_tmp90_);
	_tmp92_ = va_start;
	_tmp93_ = vala_ccode_identifier_new ("ap");
	_tmp94_ = _tmp93_;
	vala_ccode_function_call_add_argument (_tmp92_, (ValaCCodeExpression*) _tmp94_);
	_vala_ccode_node_unref0 (_tmp94_);
	_tmp95_ = va_start;
	_tmp96_ = vala_ccode_identifier_new ("format");
	_tmp97_ = _tmp96_;
	vala_ccode_function_call_add_argument (_tmp95_, (ValaCCodeExpression*) _tmp97_);
	_vala_ccode_node_unref0 (_tmp97_);
	_tmp98_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp99_ = _tmp98_;
	_tmp100_ = va_start;
	vala_ccode_function_add_expression (_tmp99_, (ValaCCodeExpression*) _tmp100_);
	_tmp101_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp102_ = _tmp101_;
	_tmp103_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp102_);
	_vala_ccode_node_unref0 (vsnprintf);
	vsnprintf = _tmp103_;
	_vala_ccode_node_unref0 (_tmp102_);
	_tmp104_ = vsnprintf;
	_tmp105_ = vala_ccode_identifier_new ("result");
	_tmp106_ = _tmp105_;
	vala_ccode_function_call_add_argument (_tmp104_, (ValaCCodeExpression*) _tmp106_);
	_vala_ccode_node_unref0 (_tmp106_);
	_tmp107_ = vsnprintf;
	_tmp108_ = vala_ccode_identifier_new ("length");
	_tmp109_ = _tmp108_;
	vala_ccode_function_call_add_argument (_tmp107_, (ValaCCodeExpression*) _tmp109_);
	_vala_ccode_node_unref0 (_tmp109_);
	_tmp110_ = vsnprintf;
	_tmp111_ = vala_ccode_identifier_new ("format");
	_tmp112_ = _tmp111_;
	vala_ccode_function_call_add_argument (_tmp110_, (ValaCCodeExpression*) _tmp112_);
	_vala_ccode_node_unref0 (_tmp112_);
	_tmp113_ = vsnprintf;
	_tmp114_ = vala_ccode_identifier_new ("ap");
	_tmp115_ = _tmp114_;
	vala_ccode_function_call_add_argument (_tmp113_, (ValaCCodeExpression*) _tmp115_);
	_vala_ccode_node_unref0 (_tmp115_);
	_tmp116_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp117_ = _tmp116_;
	_tmp118_ = vsnprintf;
	vala_ccode_function_add_expression (_tmp117_, (ValaCCodeExpression*) _tmp118_);
	_tmp119_ = vala_ccode_identifier_new ("va_end");
	_tmp120_ = _tmp119_;
	_tmp121_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp120_);
	_vala_ccode_node_unref0 (va_end);
	va_end = _tmp121_;
	_vala_ccode_node_unref0 (_tmp120_);
	_tmp122_ = va_end;
	_tmp123_ = vala_ccode_identifier_new ("ap");
	_tmp124_ = _tmp123_;
	vala_ccode_function_call_add_argument (_tmp122_, (ValaCCodeExpression*) _tmp124_);
	_vala_ccode_node_unref0 (_tmp124_);
	_tmp125_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp126_ = _tmp125_;
	_tmp127_ = va_end;
	vala_ccode_function_add_expression (_tmp126_, (ValaCCodeExpression*) _tmp127_);
	_tmp128_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp129_ = _tmp128_;
	_tmp130_ = vala_ccode_identifier_new ("result");
	_tmp131_ = _tmp130_;
	vala_ccode_function_add_return (_tmp129_, (ValaCCodeExpression*) _tmp131_);
	_vala_ccode_node_unref0 (_tmp131_);
	_tmp132_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_include (_tmp132_, "stdarg.h", FALSE);
	_tmp133_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp134_ = function;
	vala_ccode_file_add_function_declaration (_tmp133_, _tmp134_);
	_tmp135_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp136_ = function;
	vala_ccode_file_add_function (_tmp135_, _tmp136_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	_tmp137_ = g_strdup ("string_printf");
	result = _tmp137_;
	_vala_ccode_node_unref0 (malloc);
	_vala_ccode_node_unref0 (va_end);
	_vala_ccode_node_unref0 (vsnprintf);
	_vala_ccode_node_unref0 (va_start);
	_vala_ccode_node_unref0 (function);
	return result;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_construct (GType object_type)
{
	ValaCCodeMethodCallModule* self = NULL;
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type);
	return self;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_new (void)
{
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE);
}

static void
vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass,
                                          gpointer klass_data)
{
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_ccode_method_call_module_real_visit_method_call;
}

static void
vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self,
                                             gpointer klass)
{
}

static GType
vala_ccode_method_call_module_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
	GType vala_ccode_method_call_module_type_id;
	vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
	return vala_ccode_method_call_module_type_id;
}

GType
vala_ccode_method_call_module_get_type (void)
{
	static volatile gsize vala_ccode_method_call_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_method_call_module_type_id__volatile)) {
		GType vala_ccode_method_call_module_type_id;
		vala_ccode_method_call_module_type_id = vala_ccode_method_call_module_get_type_once ();
		g_once_init_leave (&vala_ccode_method_call_module_type_id__volatile, vala_ccode_method_call_module_type_id);
	}
	return vala_ccode_method_call_module_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

