/* valamethodcall.c generated by valac, the Vala compiler
 * generated from valamethodcall.vala, do not modify */

/* valamethodcall.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValaMethodCallPrivate {
	gboolean _is_yield_expression;
	gboolean _is_assert;
	gboolean _is_constructv_chainup;
	gboolean _is_chainup;
	ValaExpression* _call;
	ValaList* argument_list;
};

static gint ValaMethodCall_private_offset;
static gpointer vala_method_call_parent_class = NULL;
static ValaCallableExpressionIface * vala_method_call_vala_callable_expression_parent_iface = NULL;

static void vala_method_call_set_call (ValaMethodCall* self,
                                ValaExpression* value);
static void vala_method_call_set_is_assert (ValaMethodCall* self,
                                     gboolean value);
static void vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                                 gboolean value);
static void vala_method_call_set_is_chainup (ValaMethodCall* self,
                                      gboolean value);
static void vala_method_call_real_add_argument (ValaCallableExpression* base,
                                         ValaExpression* arg);
static ValaList* vala_method_call_real_get_argument_list (ValaCallableExpression* base);
static void vala_method_call_real_accept (ValaCodeNode* base,
                                   ValaCodeVisitor* visitor);
static void vala_method_call_real_accept_children (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor);
static void vala_method_call_real_replace_expression (ValaCodeNode* base,
                                               ValaExpression* old_node,
                                               ValaExpression* new_node);
static gboolean vala_method_call_real_is_constant (ValaExpression* base);
static gboolean vala_method_call_real_is_pure (ValaExpression* base);
static gboolean vala_method_call_real_is_accessible (ValaExpression* base,
                                              ValaSymbol* sym);
static void vala_method_call_real_get_error_types (ValaCodeNode* base,
                                            ValaCollection* collection,
                                            ValaSourceReference* source_reference);
static gboolean vala_method_call_real_check (ValaCodeNode* base,
                                      ValaCodeContext* context);
static void vala_method_call_real_emit (ValaCodeNode* base,
                                 ValaCodeGenerator* codegen);
static void vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                                  ValaCollection* collection);
static void vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                               ValaCollection* collection);
static gchar* vala_method_call_real_to_string (ValaCodeNode* base);
static void vala_method_call_finalize (ValaCodeNode * obj);
static GType vala_method_call_get_type_once (void);

static inline gpointer
vala_method_call_get_instance_private (ValaMethodCall* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMethodCall_private_offset);
}

ValaExpression*
vala_method_call_get_call (ValaMethodCall* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_call;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_method_call_set_call (ValaMethodCall* self,
                           ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_call);
	self->priv->_call = _tmp0_;
	_tmp1_ = self->priv->_call;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

static gboolean
vala_method_call_real_get_is_yield_expression (ValaCallableExpression* base)
{
	gboolean result;
	ValaMethodCall* self;
	self = (ValaMethodCall*) base;
	result = self->priv->_is_yield_expression;
	return result;
}

static void
vala_method_call_real_set_is_yield_expression (ValaCallableExpression* base,
                                               gboolean value)
{
	ValaMethodCall* self;
	self = (ValaMethodCall*) base;
	self->priv->_is_yield_expression = value;
}

gboolean
vala_method_call_get_is_assert (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_assert;
	return result;
}

static void
vala_method_call_set_is_assert (ValaMethodCall* self,
                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_assert = value;
}

gboolean
vala_method_call_get_is_constructv_chainup (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_constructv_chainup;
	return result;
}

static void
vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_constructv_chainup = value;
}

gboolean
vala_method_call_get_is_chainup (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_chainup;
	return result;
}

static void
vala_method_call_set_is_chainup (ValaMethodCall* self,
                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_chainup = value;
}

/**
 * Creates a new invocation expression.
 *
 * @param call             method to call
 * @param source_reference reference to source code
 * @return                 newly created invocation expression
 */
ValaMethodCall*
vala_method_call_construct (GType object_type,
                            ValaExpression* call,
                            ValaSourceReference* source_reference)
{
	ValaMethodCall* self = NULL;
	g_return_val_if_fail (call != NULL, NULL);
	self = (ValaMethodCall*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_method_call_set_call (self, call);
	return self;
}

ValaMethodCall*
vala_method_call_new (ValaExpression* call,
                      ValaSourceReference* source_reference)
{
	return vala_method_call_construct (VALA_TYPE_METHOD_CALL, call, source_reference);
}

/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
static void
vala_method_call_real_add_argument (ValaCallableExpression* base,
                                    ValaExpression* arg)
{
	ValaMethodCall * self;
	ValaList* _tmp0_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the argument list.
 *
 * @return argument list
 */
static ValaList*
vala_method_call_real_get_argument_list (ValaCallableExpression* base)
{
	ValaMethodCall * self;
	ValaList* _tmp0_;
	ValaList* result = NULL;
	self = (ValaMethodCall*) base;
	_tmp0_ = self->priv->argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_method_call_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method_call (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_method_call_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp2_;
		gint _expr_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _expr_index = 0;
		_tmp2_ = self->priv->argument_list;
		_expr_list = _tmp2_;
		_tmp3_ = _expr_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_expr_size = _tmp5_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* expr = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_expr_index = _expr_index + 1;
			_tmp6_ = _expr_index;
			_tmp7_ = _expr_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _expr_list;
			_tmp9_ = vala_list_get (_tmp8_, _expr_index);
			expr = (ValaExpression*) _tmp9_;
			_tmp10_ = expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp10_, visitor);
			_vala_code_node_unref0 (expr);
		}
	}
}

static void
vala_method_call_real_replace_expression (ValaCodeNode* base,
                                          ValaExpression* old_node,
                                          ValaExpression* new_node)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gint index = 0;
	ValaList* _tmp2_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_method_call_set_call (self, new_node);
	}
	_tmp2_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp2_, old_node);
	if (index >= 0) {
		ValaList* _tmp3_;
		_tmp3_ = self->priv->argument_list;
		vala_list_set (_tmp3_, index, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}

static gboolean
vala_method_call_real_is_constant (ValaExpression* base)
{
	ValaMethodCall * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	method_type = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp4_ = method_type;
	if (_tmp4_ != NULL) {
		ValaMethodType* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gboolean _tmp10_;
		_tmp5_ = method_type;
		_tmp6_ = vala_method_type_get_method_symbol (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strcmp0 (_tmp9_, "GLib.N_") == 0;
		_g_free0 (_tmp9_);
		if (_tmp10_) {
			ValaList* _tmp11_;
			gpointer _tmp12_;
			ValaExpression* _tmp13_;
			gboolean _tmp14_;
			_tmp11_ = self->priv->argument_list;
			_tmp12_ = vala_list_get (_tmp11_, 0);
			_tmp13_ = (ValaExpression*) _tmp12_;
			_tmp14_ = vala_expression_is_constant (_tmp13_);
			_vala_code_node_unref0 (_tmp13_);
			result = _tmp14_;
			return result;
		} else {
			ValaMethodType* _tmp15_;
			ValaMethod* _tmp16_;
			ValaMethod* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gboolean _tmp20_;
			_tmp15_ = method_type;
			_tmp16_ = vala_method_type_get_method_symbol (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strcmp0 (_tmp19_, "GLib.NC_") == 0;
			_g_free0 (_tmp19_);
			if (_tmp20_) {
				gboolean _tmp21_ = FALSE;
				ValaList* _tmp22_;
				gpointer _tmp23_;
				ValaExpression* _tmp24_;
				gboolean _tmp25_;
				_tmp22_ = self->priv->argument_list;
				_tmp23_ = vala_list_get (_tmp22_, 0);
				_tmp24_ = (ValaExpression*) _tmp23_;
				_tmp25_ = vala_expression_is_constant (_tmp24_);
				_vala_code_node_unref0 (_tmp24_);
				if (_tmp25_) {
					ValaList* _tmp26_;
					gpointer _tmp27_;
					ValaExpression* _tmp28_;
					_tmp26_ = self->priv->argument_list;
					_tmp27_ = vala_list_get (_tmp26_, 1);
					_tmp28_ = (ValaExpression*) _tmp27_;
					_tmp21_ = vala_expression_is_constant (_tmp28_);
					_vala_code_node_unref0 (_tmp28_);
				} else {
					_tmp21_ = FALSE;
				}
				result = _tmp21_;
				return result;
			}
		}
	}
	result = FALSE;
	return result;
}

static gboolean
vala_method_call_real_is_pure (ValaExpression* base)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_method_call_real_is_accessible (ValaExpression* base,
                                     ValaSymbol* sym)
{
	ValaMethodCall * self;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* arg = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_arg_index = _arg_index + 1;
			_tmp4_ = _arg_index;
			_tmp5_ = _arg_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _arg_list;
			_tmp7_ = vala_list_get (_tmp6_, _arg_index);
			arg = (ValaExpression*) _tmp7_;
			_tmp8_ = arg;
			if (!vala_expression_is_accessible (_tmp8_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp9_ = vala_method_call_get_call (self);
	_tmp10_ = _tmp9_;
	result = vala_expression_is_accessible (_tmp10_, sym);
	return result;
}

static void
vala_method_call_real_get_error_types (ValaCodeNode* base,
                                       ValaCollection* collection,
                                       ValaSourceReference* source_reference)
{
	ValaMethodCall * self;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	if (source_reference == NULL) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp1_ = _tmp0_;
		source_reference = _tmp1_;
	}
	_tmp2_ = vala_method_call_get_call (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_expression_get_value_type (_tmp3_);
	_tmp5_ = _tmp4_;
	mtype = _tmp5_;
	_tmp6_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp6_)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		ValaMethod* _tmp12_;
		gboolean _tmp13_;
		gboolean _tmp14_;
		_tmp7_ = mtype;
		_tmp8_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp9_ = _tmp8_;
		m = _tmp9_;
		_tmp12_ = m;
		_tmp13_ = vala_method_get_coroutine (_tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_) {
			gboolean _tmp15_;
			gboolean _tmp16_;
			_tmp15_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
			_tmp16_ = _tmp15_;
			_tmp11_ = !_tmp16_;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp17_ = vala_method_call_get_call (self);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_member_access_get_member_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp20_ = _tmp19_;
			_tmp10_ = g_strcmp0 (_tmp20_, "end") != 0;
		} else {
			_tmp10_ = FALSE;
		}
		if (!_tmp10_) {
			ValaMethod* _tmp21_;
			_tmp21_ = m;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp21_, collection, source_reference);
		}
	} else {
		ValaDataType* _tmp22_;
		_tmp22_ = mtype;
		if (VALA_IS_OBJECT_TYPE (_tmp22_)) {
			ValaClass* cl = NULL;
			ValaDataType* _tmp23_;
			ValaTypeSymbol* _tmp24_;
			ValaTypeSymbol* _tmp25_;
			ValaMethod* m = NULL;
			ValaClass* _tmp26_;
			ValaCreationMethod* _tmp27_;
			ValaCreationMethod* _tmp28_;
			ValaMethod* _tmp29_;
			_tmp23_ = mtype;
			_tmp24_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			_tmp25_ = _tmp24_;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, VALA_TYPE_CLASS, ValaClass);
			_tmp26_ = cl;
			_tmp27_ = vala_class_get_default_construction_method (_tmp26_);
			_tmp28_ = _tmp27_;
			m = (ValaMethod*) _tmp28_;
			_tmp29_ = m;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp29_, collection, source_reference);
		} else {
			ValaDataType* _tmp30_;
			_tmp30_ = mtype;
			if (VALA_IS_DELEGATE_TYPE (_tmp30_)) {
				ValaDelegate* d = NULL;
				ValaDataType* _tmp31_;
				ValaDelegate* _tmp32_;
				ValaDelegate* _tmp33_;
				ValaDelegate* _tmp34_;
				_tmp31_ = mtype;
				_tmp32_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				_tmp33_ = _tmp32_;
				d = _tmp33_;
				_tmp34_ = d;
				vala_code_node_get_error_types ((ValaCodeNode*) _tmp34_, collection, source_reference);
			}
		}
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp35_;
		gint _expr_size = 0;
		ValaList* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gint _expr_index = 0;
		_tmp35_ = self->priv->argument_list;
		_expr_list = _tmp35_;
		_tmp36_ = _expr_list;
		_tmp37_ = vala_collection_get_size ((ValaCollection*) _tmp36_);
		_tmp38_ = _tmp37_;
		_expr_size = _tmp38_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp39_;
			gint _tmp40_;
			ValaExpression* expr = NULL;
			ValaList* _tmp41_;
			gpointer _tmp42_;
			ValaExpression* _tmp43_;
			_expr_index = _expr_index + 1;
			_tmp39_ = _expr_index;
			_tmp40_ = _expr_size;
			if (!(_tmp39_ < _tmp40_)) {
				break;
			}
			_tmp41_ = _expr_list;
			_tmp42_ = vala_list_get (_tmp41_, _expr_index);
			expr = (ValaExpression*) _tmp42_;
			_tmp43_ = expr;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp43_, collection, source_reference);
			_vala_code_node_unref0 (expr);
		}
	}
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gboolean
vala_method_call_real_check (ValaCodeNode* base,
                             ValaCodeContext* context)
{
	ValaMethodCall * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp13_;
	ValaExpression* _tmp14_;
	ValaDataType* target_object_type = NULL;
	ValaList* method_type_args = NULL;
	ValaExpression* _tmp15_;
	ValaExpression* _tmp16_;
	ValaDataType* _tmp17_;
	ValaDataType* _tmp18_;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp111_;
	ValaExpression* _tmp112_;
	ValaDataType* _tmp113_;
	ValaDataType* _tmp114_;
	ValaDataType* _tmp115_;
	gboolean _tmp116_ = FALSE;
	ValaProfile _tmp117_;
	ValaProfile _tmp118_;
	gboolean gobject_chainup = FALSE;
	ValaCreationMethod* base_cm = NULL;
	gboolean _tmp144_;
	gboolean _tmp224_ = FALSE;
	ValaExpression* _tmp225_;
	ValaExpression* _tmp226_;
	gboolean _tmp297_ = FALSE;
	gboolean _tmp298_;
	ValaDataType* ret_type = NULL;
	ValaDataType* _tmp313_;
	ValaDataType* _tmp314_;
	ValaDataType* _tmp315_;
	ValaList* params = NULL;
	ValaDataType* _tmp316_;
	ValaList* _tmp317_;
	ValaList* _tmp318_;
	ValaDataType* _tmp319_;
	ValaExpression* last_arg = NULL;
	ValaIterator* arg_it = NULL;
	ValaList* _tmp375_;
	ValaIterator* _tmp376_;
	gboolean _tmp426_ = FALSE;
	ValaDataType* _tmp427_;
	gboolean _tmp448_ = FALSE;
	ValaDataType* _tmp449_;
	gboolean force_lambda_method_closure = FALSE;
	gboolean _tmp529_ = FALSE;
	gboolean _tmp530_;
	gboolean _tmp531_;
	ValaDataType* _tmp551_;
	ValaDataType* _tmp562_;
	ValaDataType* _tmp563_;
	ValaDataType* _tmp564_;
	ValaDataType* _tmp565_;
	ValaDataType* _tmp566_;
	ValaDataType* _tmp567_;
	ValaList* _tmp568_;
	ValaDataType* _tmp569_;
	ValaDataType* _tmp570_;
	gboolean _tmp571_;
	gboolean _tmp572_;
	ValaDataType* _tmp595_;
	ValaSemanticAnalyzer* _tmp834_;
	ValaSemanticAnalyzer* _tmp835_;
	ValaDataType* _tmp836_;
	ValaList* _tmp837_;
	ValaList* _tmp838_;
	gboolean _tmp865_ = FALSE;
	gboolean _tmp866_ = FALSE;
	ValaCreationMethod* _tmp867_;
	ValaDataType* _tmp895_;
	ValaDataType* _tmp896_;
	gboolean _tmp897_;
	gboolean _tmp898_;
	gboolean _tmp959_;
	gboolean _tmp960_;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = vala_method_call_get_call (self);
	_tmp6_ = _tmp5_;
	if (VALA_IS_MEMBER_ACCESS (_tmp6_)) {
		ValaExpression* _tmp7_;
		ValaExpression* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp7_ = vala_method_call_get_call (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_member_access_get_null_safe_access (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_tmp10_ = _tmp9_;
		_tmp4_ = _tmp10_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gboolean _tmp11_;
		gboolean _tmp12_;
		vala_code_node_set_error ((ValaCodeNode*) self, !VALA_CODE_NODE_CLASS (vala_method_call_parent_class)->check ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression), context));
		_tmp11_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp12_ = _tmp11_;
		result = !_tmp12_;
		return result;
	}
	_tmp13_ = vala_method_call_get_call (self);
	_tmp14_ = _tmp13_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp14_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	target_object_type = NULL;
	method_type_args = NULL;
	_tmp15_ = vala_method_call_get_call (self);
	_tmp16_ = _tmp15_;
	_tmp17_ = vala_expression_get_value_type (_tmp16_);
	_tmp18_ = _tmp17_;
	if (VALA_IS_DELEGATE_TYPE (_tmp18_)) {
		ValaExpression* _tmp19_;
		ValaExpression* _tmp20_;
		ValaDataType* _tmp21_;
		ValaDataType* _tmp22_;
		ValaDataType* _tmp23_;
		_tmp19_ = vala_method_call_get_call (self);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_expression_get_value_type (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = _vala_code_node_ref0 (_tmp22_);
		_vala_code_node_unref0 (target_object_type);
		target_object_type = _tmp23_;
	} else {
		ValaExpression* _tmp24_;
		ValaExpression* _tmp25_;
		_tmp24_ = vala_method_call_get_call (self);
		_tmp25_ = _tmp24_;
		if (VALA_IS_MEMBER_ACCESS (_tmp25_)) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp26_;
			ValaExpression* _tmp27_;
			ValaMemberAccess* _tmp28_;
			gboolean _tmp29_;
			gboolean _tmp30_;
			ValaMemberAccess* _tmp39_;
			ValaList* _tmp40_;
			ValaList* _tmp41_;
			ValaMemberAccess* _tmp42_;
			ValaExpression* _tmp43_;
			ValaExpression* _tmp44_;
			gboolean _tmp95_ = FALSE;
			ValaMemberAccess* _tmp96_;
			ValaSymbol* _tmp97_;
			ValaSymbol* _tmp98_;
			_tmp26_ = vala_method_call_get_call (self);
			_tmp27_ = _tmp26_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp28_ = ma;
			_tmp29_ = vala_member_access_get_prototype_access (_tmp28_);
			_tmp30_ = _tmp29_;
			if (_tmp30_) {
				ValaSourceReference* _tmp31_;
				ValaSourceReference* _tmp32_;
				ValaExpression* _tmp33_;
				ValaExpression* _tmp34_;
				ValaSymbol* _tmp35_;
				ValaSymbol* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp32_ = _tmp31_;
				_tmp33_ = vala_method_call_get_call (self);
				_tmp34_ = _tmp33_;
				_tmp35_ = vala_expression_get_symbol_reference (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = vala_symbol_get_full_name (_tmp36_);
				_tmp38_ = _tmp37_;
				vala_report_error (_tmp32_, "Access to instance member `%s' denied", _tmp38_);
				_g_free0 (_tmp38_);
				result = FALSE;
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_tmp39_ = ma;
			_tmp40_ = vala_member_access_get_type_arguments (_tmp39_);
			_tmp41_ = _vala_iterable_ref0 (_tmp40_);
			_vala_iterable_unref0 (method_type_args);
			method_type_args = _tmp41_;
			_tmp42_ = ma;
			_tmp43_ = vala_member_access_get_inner (_tmp42_);
			_tmp44_ = _tmp43_;
			if (_tmp44_ != NULL) {
				ValaMemberAccess* _tmp45_;
				ValaExpression* _tmp46_;
				ValaExpression* _tmp47_;
				ValaDataType* _tmp48_;
				ValaDataType* _tmp49_;
				ValaDataType* _tmp50_;
				ValaMemberAccess* _tmp51_;
				ValaExpression* _tmp52_;
				ValaExpression* _tmp53_;
				ValaSymbol* _tmp54_;
				ValaSymbol* _tmp55_;
				ValaMethod* m = NULL;
				ValaMemberAccess* _tmp66_;
				ValaSymbol* _tmp67_;
				ValaSymbol* _tmp68_;
				gboolean _tmp69_ = FALSE;
				ValaMethod* _tmp70_;
				_tmp45_ = ma;
				_tmp46_ = vala_member_access_get_inner (_tmp45_);
				_tmp47_ = _tmp46_;
				_tmp48_ = vala_expression_get_value_type (_tmp47_);
				_tmp49_ = _tmp48_;
				_tmp50_ = _vala_code_node_ref0 (_tmp49_);
				_vala_code_node_unref0 (target_object_type);
				target_object_type = _tmp50_;
				_tmp51_ = ma;
				_tmp52_ = vala_member_access_get_inner (_tmp51_);
				_tmp53_ = _tmp52_;
				_tmp54_ = vala_expression_get_symbol_reference (_tmp53_);
				_tmp55_ = _tmp54_;
				if (VALA_IS_SIGNAL (_tmp55_)) {
					ValaMemberAccess* sig = NULL;
					ValaMemberAccess* _tmp56_;
					ValaExpression* _tmp57_;
					ValaExpression* _tmp58_;
					ValaMemberAccess* _tmp59_;
					_tmp56_ = ma;
					_tmp57_ = vala_member_access_get_inner (_tmp56_);
					_tmp58_ = _tmp57_;
					sig = VALA_IS_MEMBER_ACCESS (_tmp58_) ? ((ValaMemberAccess*) _tmp58_) : NULL;
					_tmp59_ = sig;
					if (_tmp59_ != NULL) {
						ValaMemberAccess* _tmp60_;
						ValaExpression* _tmp61_;
						ValaExpression* _tmp62_;
						ValaDataType* _tmp63_;
						ValaDataType* _tmp64_;
						ValaDataType* _tmp65_;
						_tmp60_ = sig;
						_tmp61_ = vala_member_access_get_inner (_tmp60_);
						_tmp62_ = _tmp61_;
						_tmp63_ = vala_expression_get_value_type (_tmp62_);
						_tmp64_ = _tmp63_;
						_tmp65_ = _vala_code_node_ref0 (_tmp64_);
						_vala_code_node_unref0 (target_object_type);
						target_object_type = _tmp65_;
					}
				}
				_tmp66_ = ma;
				_tmp67_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp66_);
				_tmp68_ = _tmp67_;
				m = VALA_IS_METHOD (_tmp68_) ? ((ValaMethod*) _tmp68_) : NULL;
				_tmp70_ = m;
				if (_tmp70_ != NULL) {
					ValaMethod* _tmp71_;
					gboolean _tmp72_;
					gboolean _tmp73_;
					_tmp71_ = m;
					_tmp72_ = vala_method_get_coroutine (_tmp71_);
					_tmp73_ = _tmp72_;
					_tmp69_ = _tmp73_;
				} else {
					_tmp69_ = FALSE;
				}
				if (_tmp69_) {
					gboolean _tmp74_ = FALSE;
					ValaMemberAccess* _tmp75_;
					const gchar* _tmp76_;
					const gchar* _tmp77_;
					_tmp75_ = ma;
					_tmp76_ = vala_member_access_get_member_name (_tmp75_);
					_tmp77_ = _tmp76_;
					if (g_strcmp0 (_tmp77_, "begin") == 0) {
						_tmp74_ = TRUE;
					} else {
						ValaMemberAccess* _tmp78_;
						const gchar* _tmp79_;
						const gchar* _tmp80_;
						_tmp78_ = ma;
						_tmp79_ = vala_member_access_get_member_name (_tmp78_);
						_tmp80_ = _tmp79_;
						_tmp74_ = g_strcmp0 (_tmp80_, "end") == 0;
					}
					if (_tmp74_) {
						ValaMemberAccess* method_access = NULL;
						ValaMemberAccess* _tmp81_;
						ValaExpression* _tmp82_;
						ValaExpression* _tmp83_;
						gboolean _tmp84_ = FALSE;
						ValaMemberAccess* _tmp85_;
						_tmp81_ = ma;
						_tmp82_ = vala_member_access_get_inner (_tmp81_);
						_tmp83_ = _tmp82_;
						method_access = VALA_IS_MEMBER_ACCESS (_tmp83_) ? ((ValaMemberAccess*) _tmp83_) : NULL;
						_tmp85_ = method_access;
						if (_tmp85_ != NULL) {
							ValaMemberAccess* _tmp86_;
							ValaExpression* _tmp87_;
							ValaExpression* _tmp88_;
							_tmp86_ = method_access;
							_tmp87_ = vala_member_access_get_inner (_tmp86_);
							_tmp88_ = _tmp87_;
							_tmp84_ = _tmp88_ != NULL;
						} else {
							_tmp84_ = FALSE;
						}
						if (_tmp84_) {
							ValaMemberAccess* _tmp89_;
							ValaExpression* _tmp90_;
							ValaExpression* _tmp91_;
							ValaDataType* _tmp92_;
							ValaDataType* _tmp93_;
							ValaDataType* _tmp94_;
							_tmp89_ = method_access;
							_tmp90_ = vala_member_access_get_inner (_tmp89_);
							_tmp91_ = _tmp90_;
							_tmp92_ = vala_expression_get_value_type (_tmp91_);
							_tmp93_ = _tmp92_;
							_tmp94_ = _vala_code_node_ref0 (_tmp93_);
							_vala_code_node_unref0 (target_object_type);
							target_object_type = _tmp94_;
						} else {
							_vala_code_node_unref0 (target_object_type);
							target_object_type = NULL;
						}
					}
				}
			}
			_tmp96_ = ma;
			_tmp97_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp96_);
			_tmp98_ = _tmp97_;
			if (_tmp98_ != NULL) {
				ValaMemberAccess* _tmp99_;
				ValaSymbol* _tmp100_;
				ValaSymbol* _tmp101_;
				ValaAttribute* _tmp102_;
				_tmp99_ = ma;
				_tmp100_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp99_);
				_tmp101_ = _tmp100_;
				_tmp102_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp101_, "Assert");
				_tmp95_ = _tmp102_ != NULL;
			} else {
				_tmp95_ = FALSE;
			}
			if (_tmp95_) {
				ValaList* _tmp103_;
				gint _tmp104_;
				gint _tmp105_;
				vala_method_call_set_is_assert (self, TRUE);
				_tmp103_ = self->priv->argument_list;
				_tmp104_ = vala_collection_get_size ((ValaCollection*) _tmp103_);
				_tmp105_ = _tmp104_;
				if (_tmp105_ == 1) {
					ValaList* _tmp106_;
					gpointer _tmp107_;
					ValaExpression* _tmp108_;
					ValaSourceReference* _tmp109_;
					ValaSourceReference* _tmp110_;
					_tmp106_ = self->priv->argument_list;
					_tmp107_ = vala_list_get (_tmp106_, 0);
					_tmp108_ = (ValaExpression*) _tmp107_;
					_tmp109_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp108_);
					_tmp110_ = _tmp109_;
					vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp110_);
					_vala_code_node_unref0 (_tmp108_);
				}
			}
		}
	}
	_tmp111_ = vala_method_call_get_call (self);
	_tmp112_ = _tmp111_;
	_tmp113_ = vala_expression_get_value_type (_tmp112_);
	_tmp114_ = _tmp113_;
	_tmp115_ = _vala_code_node_ref0 (_tmp114_);
	mtype = _tmp115_;
	_tmp117_ = vala_code_context_get_profile (context);
	_tmp118_ = _tmp117_;
	if (_tmp118_ == VALA_PROFILE_GOBJECT) {
		ValaExpression* _tmp119_;
		ValaExpression* _tmp120_;
		ValaSymbol* _tmp121_;
		ValaSymbol* _tmp122_;
		ValaSemanticAnalyzer* _tmp123_;
		ValaSemanticAnalyzer* _tmp124_;
		ValaClass* _tmp125_;
		_tmp119_ = vala_method_call_get_call (self);
		_tmp120_ = _tmp119_;
		_tmp121_ = vala_expression_get_symbol_reference (_tmp120_);
		_tmp122_ = _tmp121_;
		_tmp123_ = vala_code_context_get_analyzer (context);
		_tmp124_ = _tmp123_;
		_tmp125_ = _tmp124_->object_type;
		_tmp116_ = _tmp122_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp125_, VALA_TYPE_SYMBOL, ValaSymbol);
	} else {
		_tmp116_ = FALSE;
	}
	gobject_chainup = _tmp116_;
	vala_method_call_set_is_chainup (self, gobject_chainup);
	if (!gobject_chainup) {
		ValaExpression* expr = NULL;
		ValaExpression* _tmp126_;
		ValaExpression* _tmp127_;
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp128_;
		gboolean _tmp129_ = FALSE;
		ValaMemberAccess* _tmp130_;
		gboolean _tmp138_ = FALSE;
		ValaMemberAccess* _tmp139_;
		_tmp126_ = vala_method_call_get_call (self);
		_tmp127_ = _tmp126_;
		expr = _tmp127_;
		_tmp128_ = expr;
		ma = VALA_IS_MEMBER_ACCESS (_tmp128_) ? ((ValaMemberAccess*) _tmp128_) : NULL;
		_tmp130_ = ma;
		if (_tmp130_ != NULL) {
			ValaMemberAccess* _tmp131_;
			ValaSymbol* _tmp132_;
			ValaSymbol* _tmp133_;
			_tmp131_ = ma;
			_tmp132_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp131_);
			_tmp133_ = _tmp132_;
			_tmp129_ = VALA_IS_CREATION_METHOD (_tmp133_);
		} else {
			_tmp129_ = FALSE;
		}
		if (_tmp129_) {
			ValaMemberAccess* _tmp134_;
			ValaExpression* _tmp135_;
			ValaExpression* _tmp136_;
			ValaExpression* _tmp137_;
			_tmp134_ = ma;
			_tmp135_ = vala_member_access_get_inner (_tmp134_);
			_tmp136_ = _tmp135_;
			expr = _tmp136_;
			_tmp137_ = expr;
			ma = VALA_IS_MEMBER_ACCESS (_tmp137_) ? ((ValaMemberAccess*) _tmp137_) : NULL;
		}
		_tmp139_ = ma;
		if (_tmp139_ != NULL) {
			ValaMemberAccess* _tmp140_;
			const gchar* _tmp141_;
			const gchar* _tmp142_;
			_tmp140_ = ma;
			_tmp141_ = vala_member_access_get_member_name (_tmp140_);
			_tmp142_ = _tmp141_;
			_tmp138_ = g_strcmp0 (_tmp142_, "this") == 0;
		} else {
			_tmp138_ = FALSE;
		}
		if (_tmp138_) {
			vala_method_call_set_is_chainup (self, TRUE);
		} else {
			ValaExpression* _tmp143_;
			_tmp143_ = expr;
			if (VALA_IS_BASE_ACCESS (_tmp143_)) {
				vala_method_call_set_is_chainup (self, TRUE);
			}
		}
	}
	base_cm = NULL;
	_tmp144_ = self->priv->_is_chainup;
	if (_tmp144_) {
		ValaCreationMethod* cm = NULL;
		ValaSemanticAnalyzer* _tmp145_;
		ValaSemanticAnalyzer* _tmp146_;
		ValaMethod* _tmp147_;
		ValaCreationMethod* _tmp148_;
		ValaCreationMethod* _tmp156_;
		ValaDataType* _tmp157_;
		_tmp145_ = vala_code_context_get_analyzer (context);
		_tmp146_ = _tmp145_;
		_tmp147_ = vala_semantic_analyzer_find_current_method (_tmp146_);
		cm = VALA_IS_CREATION_METHOD (_tmp147_) ? ((ValaCreationMethod*) _tmp147_) : NULL;
		_tmp148_ = cm;
		if (_tmp148_ == NULL) {
			ValaSourceReference* _tmp149_;
			ValaSourceReference* _tmp150_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp149_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp150_ = _tmp149_;
			vala_report_error (_tmp150_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		} else {
			ValaCreationMethod* _tmp151_;
			gboolean _tmp152_;
			gboolean _tmp153_;
			_tmp151_ = cm;
			_tmp152_ = vala_creation_method_get_chain_up (_tmp151_);
			_tmp153_ = _tmp152_;
			if (_tmp153_) {
				ValaSourceReference* _tmp154_;
				ValaSourceReference* _tmp155_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp154_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp155_ = _tmp154_;
				vala_report_error (_tmp155_, "Multiple constructor calls in the same constructor are not permitted");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
		_tmp156_ = cm;
		vala_creation_method_set_chain_up (_tmp156_, TRUE);
		_tmp157_ = mtype;
		if (VALA_IS_OBJECT_TYPE (_tmp157_)) {
			ValaClass* cl = NULL;
			ValaDataType* _tmp158_;
			ValaTypeSymbol* _tmp159_;
			ValaTypeSymbol* _tmp160_;
			ValaClass* _tmp161_;
			ValaCreationMethod* _tmp162_;
			ValaCreationMethod* _tmp163_;
			ValaCreationMethod* _tmp164_;
			_tmp158_ = mtype;
			_tmp159_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp158_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			_tmp160_ = _tmp159_;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp160_, VALA_TYPE_CLASS, ValaClass);
			_tmp161_ = cl;
			_tmp162_ = vala_class_get_default_construction_method (_tmp161_);
			_tmp163_ = _tmp162_;
			base_cm = _tmp163_;
			_tmp164_ = base_cm;
			if (_tmp164_ == NULL) {
				ValaSourceReference* _tmp165_;
				ValaSourceReference* _tmp166_;
				ValaClass* _tmp167_;
				gchar* _tmp168_;
				gchar* _tmp169_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp165_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp166_ = _tmp165_;
				_tmp167_ = cl;
				_tmp168_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp167_);
				_tmp169_ = _tmp168_;
				vala_report_error (_tmp166_, "chain up to `%s' not supported", _tmp169_);
				_g_free0 (_tmp169_);
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaCreationMethod* _tmp170_;
				gboolean _tmp171_;
				gboolean _tmp172_;
				_tmp170_ = base_cm;
				_tmp171_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp170_);
				_tmp172_ = _tmp171_;
				if (!_tmp172_) {
					ValaSourceReference* _tmp173_;
					ValaSourceReference* _tmp174_;
					ValaCreationMethod* _tmp175_;
					gchar* _tmp176_;
					gchar* _tmp177_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp173_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp174_ = _tmp173_;
					_tmp175_ = base_cm;
					_tmp176_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp175_);
					_tmp177_ = _tmp176_;
					vala_report_error (_tmp174_, "chain up to `%s' not supported", _tmp177_);
					_g_free0 (_tmp177_);
					result = FALSE;
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			}
		} else {
			gboolean _tmp178_ = FALSE;
			ValaExpression* _tmp179_;
			ValaExpression* _tmp180_;
			ValaSymbol* _tmp181_;
			ValaSymbol* _tmp182_;
			_tmp179_ = vala_method_call_get_call (self);
			_tmp180_ = _tmp179_;
			_tmp181_ = vala_expression_get_symbol_reference (_tmp180_);
			_tmp182_ = _tmp181_;
			if (VALA_IS_CREATION_METHOD (_tmp182_)) {
				ValaExpression* _tmp183_;
				ValaExpression* _tmp184_;
				ValaSymbol* _tmp185_;
				ValaSymbol* _tmp186_;
				ValaSymbol* _tmp187_;
				ValaSymbol* _tmp188_;
				_tmp183_ = vala_method_call_get_call (self);
				_tmp184_ = _tmp183_;
				_tmp185_ = vala_expression_get_symbol_reference (_tmp184_);
				_tmp186_ = _tmp185_;
				_tmp187_ = vala_symbol_get_parent_symbol (_tmp186_);
				_tmp188_ = _tmp187_;
				_tmp178_ = VALA_IS_CLASS (_tmp188_);
			} else {
				_tmp178_ = FALSE;
			}
			if (_tmp178_) {
				ValaExpression* _tmp189_;
				ValaExpression* _tmp190_;
				ValaSymbol* _tmp191_;
				ValaSymbol* _tmp192_;
				ValaCreationMethod* _tmp193_;
				gboolean _tmp194_;
				gboolean _tmp195_;
				_tmp189_ = vala_method_call_get_call (self);
				_tmp190_ = _tmp189_;
				_tmp191_ = vala_expression_get_symbol_reference (_tmp190_);
				_tmp192_ = _tmp191_;
				base_cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp192_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
				_tmp193_ = base_cm;
				_tmp194_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp193_);
				_tmp195_ = _tmp194_;
				if (!_tmp195_) {
					ValaSourceReference* _tmp196_;
					ValaSourceReference* _tmp197_;
					ValaCreationMethod* _tmp198_;
					gchar* _tmp199_;
					gchar* _tmp200_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp196_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp197_ = _tmp196_;
					_tmp198_ = base_cm;
					_tmp199_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp198_);
					_tmp200_ = _tmp199_;
					vala_report_error (_tmp197_, "chain up to `%s' not supported", _tmp200_);
					_g_free0 (_tmp200_);
					result = FALSE;
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			} else {
				if (gobject_chainup) {
					ValaClass* cl = NULL;
					ValaCreationMethod* _tmp201_;
					ValaSymbol* _tmp202_;
					ValaSymbol* _tmp203_;
					gboolean _tmp204_ = FALSE;
					ValaClass* _tmp205_;
					ValaExpression* _tmp212_;
					ValaExpression* _tmp213_;
					ValaSemanticAnalyzer* _tmp214_;
					ValaSemanticAnalyzer* _tmp215_;
					ValaClass* _tmp216_;
					ValaObjectType* _tmp217_;
					ValaObjectType* _tmp218_;
					ValaExpression* _tmp219_;
					ValaExpression* _tmp220_;
					ValaDataType* _tmp221_;
					ValaDataType* _tmp222_;
					ValaDataType* _tmp223_;
					_tmp201_ = cm;
					_tmp202_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp201_);
					_tmp203_ = _tmp202_;
					cl = VALA_IS_CLASS (_tmp203_) ? ((ValaClass*) _tmp203_) : NULL;
					_tmp205_ = cl;
					if (_tmp205_ == NULL) {
						_tmp204_ = TRUE;
					} else {
						ValaClass* _tmp206_;
						ValaSemanticAnalyzer* _tmp207_;
						ValaSemanticAnalyzer* _tmp208_;
						ValaClass* _tmp209_;
						_tmp206_ = cl;
						_tmp207_ = vala_code_context_get_analyzer (context);
						_tmp208_ = _tmp207_;
						_tmp209_ = _tmp208_->object_type;
						_tmp204_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp206_, (ValaTypeSymbol*) _tmp209_);
					}
					if (_tmp204_) {
						ValaSourceReference* _tmp210_;
						ValaSourceReference* _tmp211_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp210_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp211_ = _tmp210_;
						vala_report_error (_tmp211_, "chain up to `GLib.Object' not supported");
						result = FALSE;
						_vala_code_node_unref0 (mtype);
						_vala_iterable_unref0 (method_type_args);
						_vala_code_node_unref0 (target_object_type);
						return result;
					}
					_tmp212_ = vala_method_call_get_call (self);
					_tmp213_ = _tmp212_;
					_tmp214_ = vala_code_context_get_analyzer (context);
					_tmp215_ = _tmp214_;
					_tmp216_ = _tmp215_->object_type;
					_tmp217_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp216_);
					_tmp218_ = _tmp217_;
					vala_expression_set_value_type (_tmp213_, (ValaDataType*) _tmp218_);
					_vala_code_node_unref0 (_tmp218_);
					_tmp219_ = vala_method_call_get_call (self);
					_tmp220_ = _tmp219_;
					_tmp221_ = vala_expression_get_value_type (_tmp220_);
					_tmp222_ = _tmp221_;
					_tmp223_ = _vala_code_node_ref0 (_tmp222_);
					_vala_code_node_unref0 (mtype);
					mtype = _tmp223_;
				}
			}
		}
	}
	_tmp225_ = vala_method_call_get_call (self);
	_tmp226_ = _tmp225_;
	if (VALA_IS_MEMBER_ACCESS (_tmp226_)) {
		gboolean _tmp227_ = FALSE;
		gboolean _tmp228_ = FALSE;
		ValaExpression* _tmp229_;
		ValaExpression* _tmp230_;
		ValaSymbol* _tmp231_;
		ValaSymbol* _tmp232_;
		_tmp229_ = vala_method_call_get_call (self);
		_tmp230_ = _tmp229_;
		_tmp231_ = vala_expression_get_symbol_reference (_tmp230_);
		_tmp232_ = _tmp231_;
		if (VALA_IS_CREATION_METHOD (_tmp232_)) {
			ValaExpression* _tmp233_;
			ValaExpression* _tmp234_;
			ValaSymbol* _tmp235_;
			ValaSymbol* _tmp236_;
			ValaSymbol* _tmp237_;
			ValaSymbol* _tmp238_;
			_tmp233_ = vala_method_call_get_call (self);
			_tmp234_ = _tmp233_;
			_tmp235_ = vala_expression_get_symbol_reference (_tmp234_);
			_tmp236_ = _tmp235_;
			_tmp237_ = vala_symbol_get_parent_symbol (_tmp236_);
			_tmp238_ = _tmp237_;
			_tmp228_ = VALA_IS_STRUCT (_tmp238_);
		} else {
			_tmp228_ = FALSE;
		}
		if (_tmp228_) {
			_tmp227_ = TRUE;
		} else {
			ValaExpression* _tmp239_;
			ValaExpression* _tmp240_;
			ValaSymbol* _tmp241_;
			ValaSymbol* _tmp242_;
			_tmp239_ = vala_method_call_get_call (self);
			_tmp240_ = _tmp239_;
			_tmp241_ = vala_expression_get_symbol_reference (_tmp240_);
			_tmp242_ = _tmp241_;
			_tmp227_ = VALA_IS_STRUCT (_tmp242_);
		}
		_tmp224_ = _tmp227_;
	} else {
		_tmp224_ = FALSE;
	}
	if (_tmp224_) {
		ValaStruct* st = NULL;
		ValaExpression* _tmp243_;
		ValaExpression* _tmp244_;
		ValaSymbol* _tmp245_;
		ValaSymbol* _tmp246_;
		gboolean _tmp247_ = FALSE;
		gboolean _tmp248_ = FALSE;
		ValaStruct* _tmp249_;
		ValaObjectCreationExpression* struct_creation_expression = NULL;
		ValaExpression* _tmp260_;
		ValaExpression* _tmp261_;
		ValaSourceReference* _tmp262_;
		ValaSourceReference* _tmp263_;
		ValaObjectCreationExpression* _tmp264_;
		ValaObjectCreationExpression* _tmp265_;
		ValaObjectCreationExpression* _tmp276_;
		ValaDataType* _tmp277_;
		ValaDataType* _tmp278_;
		ValaSemanticAnalyzer* _tmp279_;
		ValaSemanticAnalyzer* _tmp280_;
		ValaList* _tmp281_;
		ValaCodeNode* _tmp282_;
		ValaCodeNode* _tmp283_;
		ValaObjectCreationExpression* _tmp284_;
		ValaObjectCreationExpression* _tmp285_;
		_tmp243_ = vala_method_call_get_call (self);
		_tmp244_ = _tmp243_;
		_tmp245_ = vala_expression_get_symbol_reference (_tmp244_);
		_tmp246_ = _tmp245_;
		st = VALA_IS_STRUCT (_tmp246_) ? ((ValaStruct*) _tmp246_) : NULL;
		_tmp249_ = st;
		if (_tmp249_ != NULL) {
			ValaStruct* _tmp250_;
			ValaCreationMethod* _tmp251_;
			ValaCreationMethod* _tmp252_;
			_tmp250_ = st;
			_tmp251_ = vala_struct_get_default_construction_method (_tmp250_);
			_tmp252_ = _tmp251_;
			_tmp248_ = _tmp252_ == NULL;
		} else {
			_tmp248_ = FALSE;
		}
		if (_tmp248_) {
			gboolean _tmp253_ = FALSE;
			gboolean _tmp254_ = FALSE;
			ValaStruct* _tmp255_;
			_tmp255_ = st;
			if (vala_struct_is_boolean_type (_tmp255_)) {
				_tmp254_ = TRUE;
			} else {
				ValaStruct* _tmp256_;
				_tmp256_ = st;
				_tmp254_ = vala_struct_is_integer_type (_tmp256_);
			}
			if (_tmp254_) {
				_tmp253_ = TRUE;
			} else {
				ValaStruct* _tmp257_;
				_tmp257_ = st;
				_tmp253_ = vala_struct_is_floating_type (_tmp257_);
			}
			_tmp247_ = _tmp253_;
		} else {
			_tmp247_ = FALSE;
		}
		if (_tmp247_) {
			ValaSourceReference* _tmp258_;
			ValaSourceReference* _tmp259_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp258_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp259_ = _tmp258_;
			vala_report_error (_tmp259_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
		_tmp260_ = vala_method_call_get_call (self);
		_tmp261_ = _tmp260_;
		_tmp262_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp263_ = _tmp262_;
		_tmp264_ = vala_object_creation_expression_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp261_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess), _tmp263_);
		struct_creation_expression = _tmp264_;
		_tmp265_ = struct_creation_expression;
		vala_object_creation_expression_set_struct_creation (_tmp265_, TRUE);
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp266_;
			gint _arg_size = 0;
			ValaList* _tmp267_;
			gint _tmp268_;
			gint _tmp269_;
			gint _arg_index = 0;
			_tmp266_ = self->priv->argument_list;
			_arg_list = _tmp266_;
			_tmp267_ = _arg_list;
			_tmp268_ = vala_collection_get_size ((ValaCollection*) _tmp267_);
			_tmp269_ = _tmp268_;
			_arg_size = _tmp269_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp270_;
				gint _tmp271_;
				ValaExpression* arg = NULL;
				ValaList* _tmp272_;
				gpointer _tmp273_;
				ValaObjectCreationExpression* _tmp274_;
				ValaExpression* _tmp275_;
				_arg_index = _arg_index + 1;
				_tmp270_ = _arg_index;
				_tmp271_ = _arg_size;
				if (!(_tmp270_ < _tmp271_)) {
					break;
				}
				_tmp272_ = _arg_list;
				_tmp273_ = vala_list_get (_tmp272_, _arg_index);
				arg = (ValaExpression*) _tmp273_;
				_tmp274_ = struct_creation_expression;
				_tmp275_ = arg;
				vala_callable_expression_add_argument ((ValaCallableExpression*) _tmp274_, _tmp275_);
				_vala_code_node_unref0 (arg);
			}
		}
		_tmp276_ = struct_creation_expression;
		_tmp277_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp278_ = _tmp277_;
		vala_expression_set_target_type ((ValaExpression*) _tmp276_, _tmp278_);
		_tmp279_ = vala_code_context_get_analyzer (context);
		_tmp280_ = _tmp279_;
		_tmp281_ = _tmp280_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp281_, (ValaCodeNode*) self);
		_tmp282_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp283_ = _tmp282_;
		_tmp284_ = struct_creation_expression;
		vala_code_node_replace_expression (_tmp283_, (ValaExpression*) self, (ValaExpression*) _tmp284_);
		_tmp285_ = struct_creation_expression;
		vala_code_node_check ((ValaCodeNode*) _tmp285_, context);
		result = TRUE;
		_vala_code_node_unref0 (struct_creation_expression);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp286_ = FALSE;
		gboolean _tmp287_ = FALSE;
		gboolean _tmp288_;
		_tmp288_ = self->priv->_is_chainup;
		if (!_tmp288_) {
			ValaExpression* _tmp289_;
			ValaExpression* _tmp290_;
			_tmp289_ = vala_method_call_get_call (self);
			_tmp290_ = _tmp289_;
			_tmp287_ = VALA_IS_MEMBER_ACCESS (_tmp290_);
		} else {
			_tmp287_ = FALSE;
		}
		if (_tmp287_) {
			ValaExpression* _tmp291_;
			ValaExpression* _tmp292_;
			ValaSymbol* _tmp293_;
			ValaSymbol* _tmp294_;
			_tmp291_ = vala_method_call_get_call (self);
			_tmp292_ = _tmp291_;
			_tmp293_ = vala_expression_get_symbol_reference (_tmp292_);
			_tmp294_ = _tmp293_;
			_tmp286_ = VALA_IS_CREATION_METHOD (_tmp294_);
		} else {
			_tmp286_ = FALSE;
		}
		if (_tmp286_) {
			ValaSourceReference* _tmp295_;
			ValaSourceReference* _tmp296_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp295_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp296_ = _tmp295_;
			vala_report_error (_tmp296_, "use `new' operator to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp298_ = self->priv->_is_chainup;
	if (!_tmp298_) {
		ValaDataType* _tmp299_;
		_tmp299_ = mtype;
		_tmp297_ = VALA_IS_OBJECT_TYPE (_tmp299_);
	} else {
		_tmp297_ = FALSE;
	}
	if (_tmp297_) {
		ValaSourceReference* _tmp300_;
		ValaSourceReference* _tmp301_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp300_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp301_ = _tmp300_;
		vala_report_error (_tmp301_, "invocation not supported in this context");
		result = FALSE;
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp302_ = FALSE;
		ValaDataType* _tmp303_;
		_tmp303_ = mtype;
		if (_tmp303_ != NULL) {
			ValaDataType* _tmp304_;
			_tmp304_ = mtype;
			_tmp302_ = vala_data_type_is_invokable (_tmp304_);
		} else {
			_tmp302_ = FALSE;
		}
		if (_tmp302_) {
		} else {
			ValaExpression* _tmp305_;
			ValaExpression* _tmp306_;
			ValaSymbol* _tmp307_;
			ValaSymbol* _tmp308_;
			_tmp305_ = vala_method_call_get_call (self);
			_tmp306_ = _tmp305_;
			_tmp307_ = vala_expression_get_symbol_reference (_tmp306_);
			_tmp308_ = _tmp307_;
			if (VALA_IS_CLASS (_tmp308_)) {
				ValaSourceReference* _tmp309_;
				ValaSourceReference* _tmp310_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp309_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp310_ = _tmp309_;
				vala_report_error (_tmp310_, "use `new' operator to create new objects");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaSourceReference* _tmp311_;
				ValaSourceReference* _tmp312_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp311_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp312_ = _tmp311_;
				vala_report_error (_tmp312_, "invocation not supported in this context");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
	}
	_tmp313_ = mtype;
	_tmp314_ = vala_data_type_get_return_type (_tmp313_);
	_tmp315_ = _vala_code_node_ref0 (_tmp314_);
	ret_type = _tmp315_;
	_tmp316_ = mtype;
	_tmp317_ = vala_data_type_get_parameters (_tmp316_);
	_tmp318_ = _vala_iterable_ref0 (_tmp317_);
	params = _tmp318_;
	_tmp319_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp319_)) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp320_;
		ValaExpression* _tmp321_;
		ValaMethod* m = NULL;
		ValaDataType* _tmp322_;
		ValaMethod* _tmp323_;
		ValaMethod* _tmp324_;
		ValaMethod* _tmp325_;
		gboolean _tmp326_;
		gboolean _tmp327_;
		gint n_type_params = 0;
		ValaMethod* _tmp359_;
		ValaList* _tmp360_;
		gint _tmp361_;
		gint _tmp362_;
		gint n_type_args = 0;
		ValaMemberAccess* _tmp363_;
		ValaList* _tmp364_;
		gint _tmp365_;
		gint _tmp366_;
		gboolean _tmp367_ = FALSE;
		_tmp320_ = vala_method_call_get_call (self);
		_tmp321_ = _tmp320_;
		ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp321_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
		_tmp322_ = mtype;
		_tmp323_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp322_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp324_ = _tmp323_;
		m = _tmp324_;
		_tmp325_ = m;
		_tmp326_ = vala_method_get_coroutine (_tmp325_);
		_tmp327_ = _tmp326_;
		if (_tmp327_) {
			gboolean _tmp328_;
			gboolean _tmp329_;
			_tmp328_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
			_tmp329_ = _tmp328_;
			if (!_tmp329_) {
				ValaMemberAccess* _tmp330_;
				const gchar* _tmp331_;
				const gchar* _tmp332_;
				_tmp330_ = ma;
				_tmp331_ = vala_member_access_get_member_name (_tmp330_);
				_tmp332_ = _tmp331_;
				if (g_strcmp0 (_tmp332_, "end") != 0) {
					ValaMemberAccess* _tmp333_;
					const gchar* _tmp334_;
					const gchar* _tmp335_;
					ValaMethod* _tmp339_;
					ValaList* _tmp340_;
					ValaList* _tmp341_;
					ValaVoidType* _tmp342_;
					_tmp333_ = ma;
					_tmp334_ = vala_member_access_get_member_name (_tmp333_);
					_tmp335_ = _tmp334_;
					if (g_strcmp0 (_tmp335_, "begin") != 0) {
						ValaMemberAccess* _tmp336_;
						ValaSourceReference* _tmp337_;
						ValaSourceReference* _tmp338_;
						_tmp336_ = ma;
						_tmp337_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp336_);
						_tmp338_ = _tmp337_;
						vala_report_deprecated (_tmp338_, "implicit .begin is deprecated");
					}
					_tmp339_ = m;
					_tmp340_ = vala_method_get_async_begin_parameters (_tmp339_);
					_tmp341_ = _vala_iterable_ref0 (_tmp340_);
					_vala_iterable_unref0 (params);
					params = _tmp341_;
					_tmp342_ = vala_void_type_new (NULL);
					_vala_code_node_unref0 (ret_type);
					ret_type = (ValaDataType*) _tmp342_;
				} else {
					ValaMethod* _tmp343_;
					ValaList* _tmp344_;
					ValaList* _tmp345_;
					_tmp343_ = m;
					_tmp344_ = vala_method_get_async_end_parameters (_tmp343_);
					_tmp345_ = _vala_iterable_ref0 (_tmp344_);
					_vala_iterable_unref0 (params);
					params = _tmp345_;
				}
			} else {
				gboolean _tmp346_ = FALSE;
				ValaMemberAccess* _tmp347_;
				const gchar* _tmp348_;
				const gchar* _tmp349_;
				_tmp347_ = ma;
				_tmp348_ = vala_member_access_get_member_name (_tmp347_);
				_tmp349_ = _tmp348_;
				if (g_strcmp0 (_tmp349_, "begin") == 0) {
					_tmp346_ = TRUE;
				} else {
					ValaMemberAccess* _tmp350_;
					const gchar* _tmp351_;
					const gchar* _tmp352_;
					_tmp350_ = ma;
					_tmp351_ = vala_member_access_get_member_name (_tmp350_);
					_tmp352_ = _tmp351_;
					_tmp346_ = g_strcmp0 (_tmp352_, "end") == 0;
				}
				if (_tmp346_) {
					ValaMemberAccess* _tmp353_;
					ValaSourceReference* _tmp354_;
					ValaSourceReference* _tmp355_;
					ValaMemberAccess* _tmp356_;
					const gchar* _tmp357_;
					const gchar* _tmp358_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp353_ = ma;
					_tmp354_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp353_);
					_tmp355_ = _tmp354_;
					_tmp356_ = ma;
					_tmp357_ = vala_member_access_get_member_name (_tmp356_);
					_tmp358_ = _tmp357_;
					vala_report_error (_tmp355_, "use of `%s' not allowed in yield statement", _tmp358_);
				}
			}
		}
		_tmp359_ = m;
		_tmp360_ = vala_method_get_type_parameters (_tmp359_);
		_tmp361_ = vala_collection_get_size ((ValaCollection*) _tmp360_);
		_tmp362_ = _tmp361_;
		n_type_params = _tmp362_;
		_tmp363_ = ma;
		_tmp364_ = vala_member_access_get_type_arguments (_tmp363_);
		_tmp365_ = vala_collection_get_size ((ValaCollection*) _tmp364_);
		_tmp366_ = _tmp365_;
		n_type_args = _tmp366_;
		if (n_type_args > 0) {
			_tmp367_ = n_type_args < n_type_params;
		} else {
			_tmp367_ = FALSE;
		}
		if (_tmp367_) {
			ValaMemberAccess* _tmp368_;
			ValaSourceReference* _tmp369_;
			ValaSourceReference* _tmp370_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp368_ = ma;
			_tmp369_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp368_);
			_tmp370_ = _tmp369_;
			vala_report_error (_tmp370_, "too few type arguments");
			result = FALSE;
			_vala_iterable_unref0 (params);
			_vala_code_node_unref0 (ret_type);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		} else {
			gboolean _tmp371_ = FALSE;
			if (n_type_args > 0) {
				_tmp371_ = n_type_args > n_type_params;
			} else {
				_tmp371_ = FALSE;
			}
			if (_tmp371_) {
				ValaMemberAccess* _tmp372_;
				ValaSourceReference* _tmp373_;
				ValaSourceReference* _tmp374_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp372_ = ma;
				_tmp373_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp372_);
				_tmp374_ = _tmp373_;
				vala_report_error (_tmp374_, "too many type arguments");
				result = FALSE;
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
	}
	last_arg = NULL;
	_tmp375_ = self->priv->argument_list;
	_tmp376_ = vala_iterable_iterator ((ValaIterable*) _tmp375_);
	arg_it = _tmp376_;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp377_;
		gint _param_size = 0;
		ValaList* _tmp378_;
		gint _tmp379_;
		gint _tmp380_;
		gint _param_index = 0;
		_tmp377_ = params;
		_param_list = _tmp377_;
		_tmp378_ = _param_list;
		_tmp379_ = vala_collection_get_size ((ValaCollection*) _tmp378_);
		_tmp380_ = _tmp379_;
		_param_size = _tmp380_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp381_;
			gint _tmp382_;
			ValaParameter* param = NULL;
			ValaList* _tmp383_;
			gpointer _tmp384_;
			ValaParameter* _tmp385_;
			ValaParameter* _tmp386_;
			gboolean _tmp387_;
			gboolean _tmp388_;
			ValaParameter* _tmp389_;
			gboolean _tmp390_;
			gboolean _tmp391_;
			ValaIterator* _tmp409_;
			_param_index = _param_index + 1;
			_tmp381_ = _param_index;
			_tmp382_ = _param_size;
			if (!(_tmp381_ < _tmp382_)) {
				break;
			}
			_tmp383_ = _param_list;
			_tmp384_ = vala_list_get (_tmp383_, _param_index);
			param = (ValaParameter*) _tmp384_;
			_tmp385_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp385_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_tmp386_ = param;
			_tmp387_ = vala_parameter_get_ellipsis (_tmp386_);
			_tmp388_ = _tmp387_;
			if (_tmp388_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp389_ = param;
			_tmp390_ = vala_parameter_get_params_array (_tmp389_);
			_tmp391_ = _tmp390_;
			if (_tmp391_) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp392_;
				ValaDataType* _tmp393_;
				ValaDataType* _tmp394_;
				ValaArrayType* _tmp395_;
				_tmp392_ = param;
				_tmp393_ = vala_variable_get_variable_type ((ValaVariable*) _tmp392_);
				_tmp394_ = _tmp393_;
				_tmp395_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp394_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp395_;
				while (TRUE) {
					ValaIterator* _tmp396_;
					ValaExpression* arg = NULL;
					ValaIterator* _tmp397_;
					gpointer _tmp398_;
					ValaExpression* _tmp399_;
					ValaArrayType* _tmp400_;
					ValaDataType* _tmp401_;
					ValaDataType* _tmp402_;
					ValaExpression* _tmp403_;
					ValaDataType* _tmp404_;
					ValaDataType* _tmp405_;
					ValaArrayType* _tmp406_;
					gboolean _tmp407_;
					gboolean _tmp408_;
					_tmp396_ = arg_it;
					if (!vala_iterator_next (_tmp396_)) {
						break;
					}
					_tmp397_ = arg_it;
					_tmp398_ = vala_iterator_get (_tmp397_);
					arg = (ValaExpression*) _tmp398_;
					_tmp399_ = arg;
					_tmp400_ = array_type;
					_tmp401_ = vala_array_type_get_element_type (_tmp400_);
					_tmp402_ = _tmp401_;
					vala_expression_set_target_type (_tmp399_, _tmp402_);
					_tmp403_ = arg;
					_tmp404_ = vala_expression_get_target_type (_tmp403_);
					_tmp405_ = _tmp404_;
					_tmp406_ = array_type;
					_tmp407_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp406_);
					_tmp408_ = _tmp407_;
					vala_data_type_set_value_owned (_tmp405_, _tmp408_);
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (array_type);
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp409_ = arg_it;
			if (vala_iterator_next (_tmp409_)) {
				ValaExpression* arg = NULL;
				ValaIterator* _tmp410_;
				gpointer _tmp411_;
				ValaExpression* _tmp412_;
				ValaParameter* _tmp413_;
				ValaDataType* _tmp414_;
				ValaDataType* _tmp415_;
				ValaExpression* _tmp416_;
				ValaExpression* _tmp417_;
				ValaDataType* _tmp418_;
				ValaDataType* _tmp419_;
				ValaDataType* _tmp420_;
				ValaList* _tmp421_;
				ValaDataType* _tmp422_;
				ValaDataType* _tmp423_;
				ValaExpression* _tmp424_;
				ValaExpression* _tmp425_;
				_tmp410_ = arg_it;
				_tmp411_ = vala_iterator_get (_tmp410_);
				arg = (ValaExpression*) _tmp411_;
				_tmp412_ = arg;
				_tmp413_ = param;
				_tmp414_ = vala_variable_get_variable_type ((ValaVariable*) _tmp413_);
				_tmp415_ = _tmp414_;
				vala_expression_set_formal_target_type (_tmp412_, _tmp415_);
				_tmp416_ = arg;
				_tmp417_ = arg;
				_tmp418_ = vala_expression_get_formal_target_type (_tmp417_);
				_tmp419_ = _tmp418_;
				_tmp420_ = target_object_type;
				_tmp421_ = method_type_args;
				_tmp422_ = vala_data_type_get_actual_type (_tmp419_, _tmp420_, _tmp421_, (ValaCodeNode*) self);
				_tmp423_ = _tmp422_;
				vala_expression_set_target_type (_tmp416_, _tmp423_);
				_vala_code_node_unref0 (_tmp423_);
				_tmp424_ = arg;
				_tmp425_ = _vala_code_node_ref0 (_tmp424_);
				_vala_code_node_unref0 (last_arg);
				last_arg = _tmp425_;
				_vala_code_node_unref0 (arg);
			}
			_vala_code_node_unref0 (param);
		}
	}
	_tmp427_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp427_)) {
		ValaDataType* _tmp428_;
		ValaMethod* _tmp429_;
		ValaMethod* _tmp430_;
		ValaAttribute* _tmp431_;
		_tmp428_ = mtype;
		_tmp429_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp428_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp430_ = _tmp429_;
		_tmp431_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp430_, "Print");
		_tmp426_ = _tmp431_ != NULL;
	} else {
		_tmp426_ = FALSE;
	}
	if (_tmp426_) {
		ValaTemplate* template = NULL;
		ValaSourceReference* _tmp432_;
		ValaSourceReference* _tmp433_;
		ValaTemplate* _tmp434_;
		ValaList* _tmp446_;
		ValaTemplate* _tmp447_;
		_tmp432_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp433_ = _tmp432_;
		_tmp434_ = vala_template_new (_tmp433_);
		template = _tmp434_;
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp435_;
			gint _arg_size = 0;
			ValaList* _tmp436_;
			gint _tmp437_;
			gint _tmp438_;
			gint _arg_index = 0;
			_tmp435_ = self->priv->argument_list;
			_arg_list = _tmp435_;
			_tmp436_ = _arg_list;
			_tmp437_ = vala_collection_get_size ((ValaCollection*) _tmp436_);
			_tmp438_ = _tmp437_;
			_arg_size = _tmp438_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp439_;
				gint _tmp440_;
				ValaExpression* arg = NULL;
				ValaList* _tmp441_;
				gpointer _tmp442_;
				ValaExpression* _tmp443_;
				ValaTemplate* _tmp444_;
				ValaExpression* _tmp445_;
				_arg_index = _arg_index + 1;
				_tmp439_ = _arg_index;
				_tmp440_ = _arg_size;
				if (!(_tmp439_ < _tmp440_)) {
					break;
				}
				_tmp441_ = _arg_list;
				_tmp442_ = vala_list_get (_tmp441_, _arg_index);
				arg = (ValaExpression*) _tmp442_;
				_tmp443_ = arg;
				vala_code_node_set_parent_node ((ValaCodeNode*) _tmp443_, NULL);
				_tmp444_ = template;
				_tmp445_ = arg;
				vala_template_add_expression (_tmp444_, _tmp445_);
				_vala_code_node_unref0 (arg);
			}
		}
		_tmp446_ = self->priv->argument_list;
		vala_collection_clear ((ValaCollection*) _tmp446_);
		_tmp447_ = template;
		vala_callable_expression_add_argument ((ValaCallableExpression*) self, (ValaExpression*) _tmp447_);
		_vala_code_node_unref0 (template);
	}
	_tmp449_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp449_)) {
		ValaDataType* _tmp450_;
		ValaMethod* _tmp451_;
		ValaMethod* _tmp452_;
		gboolean _tmp453_;
		gboolean _tmp454_;
		_tmp450_ = mtype;
		_tmp451_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp450_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp452_ = _tmp451_;
		_tmp453_ = vala_method_get_printf_format (_tmp452_);
		_tmp454_ = _tmp453_;
		_tmp448_ = _tmp454_;
	} else {
		_tmp448_ = FALSE;
	}
	if (_tmp448_) {
		ValaStringLiteral* format_literal = NULL;
		ValaExpression* _tmp455_;
		ValaStringLiteral* _tmp504_;
		format_literal = NULL;
		_tmp455_ = last_arg;
		if (VALA_IS_NULL_LITERAL (_tmp455_)) {
		} else {
			ValaExpression* _tmp456_;
			_tmp456_ = last_arg;
			if (_tmp456_ != NULL) {
				ValaExpression* _tmp457_;
				ValaStringLiteral* _tmp458_;
				gboolean _tmp459_ = FALSE;
				ValaStringLiteral* _tmp460_;
				_tmp457_ = last_arg;
				_tmp458_ = vala_string_literal_get_format_literal (_tmp457_);
				_vala_code_node_unref0 (format_literal);
				format_literal = _tmp458_;
				_tmp460_ = format_literal;
				if (_tmp460_ == NULL) {
					ValaList* _tmp461_;
					gint _tmp462_;
					gint _tmp463_;
					ValaList* _tmp464_;
					gint _tmp465_;
					gint _tmp466_;
					_tmp461_ = self->priv->argument_list;
					_tmp462_ = vala_collection_get_size ((ValaCollection*) _tmp461_);
					_tmp463_ = _tmp462_;
					_tmp464_ = params;
					_tmp465_ = vala_collection_get_size ((ValaCollection*) _tmp464_);
					_tmp466_ = _tmp465_;
					_tmp459_ = _tmp463_ == (_tmp466_ - 1);
				} else {
					_tmp459_ = FALSE;
				}
				if (_tmp459_) {
					ValaStringLiteral* _tmp467_;
					ValaStringLiteral* _tmp468_;
					ValaSemanticAnalyzer* _tmp469_;
					ValaSemanticAnalyzer* _tmp470_;
					ValaDataType* _tmp471_;
					ValaDataType* _tmp472_;
					ValaDataType* _tmp473_;
					ValaList* _tmp474_;
					ValaList* _tmp475_;
					gint _tmp476_;
					gint _tmp477_;
					ValaStringLiteral* _tmp478_;
					ValaList* _tmp479_;
					ValaIterator* _tmp480_;
					_tmp467_ = vala_string_literal_new ("\"%s\"", NULL);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp467_;
					_tmp468_ = format_literal;
					_tmp469_ = vala_code_context_get_analyzer (context);
					_tmp470_ = _tmp469_;
					_tmp471_ = _tmp470_->string_type;
					_tmp472_ = vala_data_type_copy (_tmp471_);
					_tmp473_ = _tmp472_;
					vala_expression_set_target_type ((ValaExpression*) _tmp468_, _tmp473_);
					_vala_code_node_unref0 (_tmp473_);
					_tmp474_ = self->priv->argument_list;
					_tmp475_ = self->priv->argument_list;
					_tmp476_ = vala_collection_get_size ((ValaCollection*) _tmp475_);
					_tmp477_ = _tmp476_;
					_tmp478_ = format_literal;
					vala_list_insert (_tmp474_, _tmp477_ - 1, (ValaExpression*) _tmp478_);
					_tmp479_ = self->priv->argument_list;
					_tmp480_ = vala_iterable_iterator ((ValaIterable*) _tmp479_);
					_vala_iterator_unref0 (arg_it);
					arg_it = _tmp480_;
					{
						ValaList* _param_list = NULL;
						ValaList* _tmp481_;
						gint _param_size = 0;
						ValaList* _tmp482_;
						gint _tmp483_;
						gint _tmp484_;
						gint _param_index = 0;
						_tmp481_ = params;
						_param_list = _tmp481_;
						_tmp482_ = _param_list;
						_tmp483_ = vala_collection_get_size ((ValaCollection*) _tmp482_);
						_tmp484_ = _tmp483_;
						_param_size = _tmp484_;
						_param_index = -1;
						while (TRUE) {
							gint _tmp485_;
							gint _tmp486_;
							ValaParameter* param = NULL;
							ValaList* _tmp487_;
							gpointer _tmp488_;
							gboolean _tmp489_ = FALSE;
							ValaParameter* _tmp490_;
							gboolean _tmp491_;
							gboolean _tmp492_;
							ValaIterator* _tmp496_;
							_param_index = _param_index + 1;
							_tmp485_ = _param_index;
							_tmp486_ = _param_size;
							if (!(_tmp485_ < _tmp486_)) {
								break;
							}
							_tmp487_ = _param_list;
							_tmp488_ = vala_list_get (_tmp487_, _param_index);
							param = (ValaParameter*) _tmp488_;
							_tmp490_ = param;
							_tmp491_ = vala_parameter_get_ellipsis (_tmp490_);
							_tmp492_ = _tmp491_;
							if (_tmp492_) {
								_tmp489_ = TRUE;
							} else {
								ValaParameter* _tmp493_;
								gboolean _tmp494_;
								gboolean _tmp495_;
								_tmp493_ = param;
								_tmp494_ = vala_parameter_get_params_array (_tmp493_);
								_tmp495_ = _tmp494_;
								_tmp489_ = _tmp495_;
							}
							if (_tmp489_) {
								_vala_code_node_unref0 (param);
								break;
							}
							_tmp496_ = arg_it;
							vala_iterator_next (_tmp496_);
							_vala_code_node_unref0 (param);
						}
					}
				}
			} else {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp497_;
				ValaExpression* _tmp498_;
				ValaMemberAccess* _tmp499_;
				_tmp497_ = vala_method_call_get_call (self);
				_tmp498_ = _tmp497_;
				ma = VALA_IS_MEMBER_ACCESS (_tmp498_) ? ((ValaMemberAccess*) _tmp498_) : NULL;
				_tmp499_ = ma;
				if (_tmp499_ != NULL) {
					ValaMemberAccess* _tmp500_;
					ValaExpression* _tmp501_;
					ValaExpression* _tmp502_;
					ValaStringLiteral* _tmp503_;
					_tmp500_ = ma;
					_tmp501_ = vala_member_access_get_inner (_tmp500_);
					_tmp502_ = _tmp501_;
					_tmp503_ = vala_string_literal_get_format_literal (_tmp502_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp503_;
				}
			}
		}
		_tmp504_ = format_literal;
		if (_tmp504_ != NULL) {
			gchar* format = NULL;
			ValaStringLiteral* _tmp505_;
			gchar* _tmp506_;
			ValaSemanticAnalyzer* _tmp507_;
			ValaSemanticAnalyzer* _tmp508_;
			const gchar* _tmp509_;
			ValaIterator* _tmp510_;
			ValaSourceReference* _tmp511_;
			ValaSourceReference* _tmp512_;
			_tmp505_ = format_literal;
			_tmp506_ = vala_string_literal_eval (_tmp505_);
			format = _tmp506_;
			_tmp507_ = vala_code_context_get_analyzer (context);
			_tmp508_ = _tmp507_;
			_tmp509_ = format;
			_tmp510_ = arg_it;
			_tmp511_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp512_ = _tmp511_;
			if (!vala_semantic_analyzer_check_print_format (_tmp508_, _tmp509_, _tmp510_, _tmp512_)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_g_free0 (format);
				_vala_code_node_unref0 (format_literal);
				_vala_iterator_unref0 (arg_it);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_g_free0 (format);
		}
		_vala_code_node_unref0 (format_literal);
	}
	force_lambda_method_closure = FALSE;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp513_;
		gint _arg_size = 0;
		ValaList* _tmp514_;
		gint _tmp515_;
		gint _tmp516_;
		gint _arg_index = 0;
		_tmp513_ = self->priv->argument_list;
		_arg_list = _tmp513_;
		_tmp514_ = _arg_list;
		_tmp515_ = vala_collection_get_size ((ValaCollection*) _tmp514_);
		_tmp516_ = _tmp515_;
		_arg_size = _tmp516_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp517_;
			gint _tmp518_;
			ValaExpression* arg = NULL;
			ValaList* _tmp519_;
			gpointer _tmp520_;
			ValaExpression* _tmp521_;
			gboolean _tmp522_ = FALSE;
			ValaExpression* _tmp523_;
			_arg_index = _arg_index + 1;
			_tmp517_ = _arg_index;
			_tmp518_ = _arg_size;
			if (!(_tmp517_ < _tmp518_)) {
				break;
			}
			_tmp519_ = _arg_list;
			_tmp520_ = vala_list_get (_tmp519_, _arg_index);
			arg = (ValaExpression*) _tmp520_;
			_tmp521_ = arg;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp521_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp523_ = arg;
			if (VALA_IS_LAMBDA_EXPRESSION (_tmp523_)) {
				ValaExpression* _tmp524_;
				ValaMethod* _tmp525_;
				ValaMethod* _tmp526_;
				gboolean _tmp527_;
				gboolean _tmp528_;
				_tmp524_ = arg;
				_tmp525_ = vala_lambda_expression_get_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp524_, VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpression));
				_tmp526_ = _tmp525_;
				_tmp527_ = vala_method_get_closure (_tmp526_);
				_tmp528_ = _tmp527_;
				_tmp522_ = _tmp528_;
			} else {
				_tmp522_ = FALSE;
			}
			if (_tmp522_) {
				force_lambda_method_closure = TRUE;
			}
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp530_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp531_ = _tmp530_;
	if (!_tmp531_) {
		_tmp529_ = force_lambda_method_closure;
	} else {
		_tmp529_ = FALSE;
	}
	if (_tmp529_) {
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp532_;
			gint _arg_size = 0;
			ValaList* _tmp533_;
			gint _tmp534_;
			gint _tmp535_;
			gint _arg_index = 0;
			_tmp532_ = self->priv->argument_list;
			_arg_list = _tmp532_;
			_tmp533_ = _arg_list;
			_tmp534_ = vala_collection_get_size ((ValaCollection*) _tmp533_);
			_tmp535_ = _tmp534_;
			_arg_size = _tmp535_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp536_;
				gint _tmp537_;
				ValaExpression* arg = NULL;
				ValaList* _tmp538_;
				gpointer _tmp539_;
				ValaLambdaExpression* lambda = NULL;
				ValaExpression* _tmp540_;
				gboolean _tmp541_ = FALSE;
				ValaLambdaExpression* _tmp542_;
				_arg_index = _arg_index + 1;
				_tmp536_ = _arg_index;
				_tmp537_ = _arg_size;
				if (!(_tmp536_ < _tmp537_)) {
					break;
				}
				_tmp538_ = _arg_list;
				_tmp539_ = vala_list_get (_tmp538_, _arg_index);
				arg = (ValaExpression*) _tmp539_;
				_tmp540_ = arg;
				lambda = VALA_IS_LAMBDA_EXPRESSION (_tmp540_) ? ((ValaLambdaExpression*) _tmp540_) : NULL;
				_tmp542_ = lambda;
				if (_tmp542_ != NULL) {
					ValaLambdaExpression* _tmp543_;
					ValaMethod* _tmp544_;
					ValaMethod* _tmp545_;
					ValaMemberBinding _tmp546_;
					ValaMemberBinding _tmp547_;
					_tmp543_ = lambda;
					_tmp544_ = vala_lambda_expression_get_method (_tmp543_);
					_tmp545_ = _tmp544_;
					_tmp546_ = vala_method_get_binding (_tmp545_);
					_tmp547_ = _tmp546_;
					_tmp541_ = _tmp547_ != VALA_MEMBER_BINDING_STATIC;
				} else {
					_tmp541_ = FALSE;
				}
				if (_tmp541_) {
					ValaLambdaExpression* _tmp548_;
					ValaMethod* _tmp549_;
					ValaMethod* _tmp550_;
					_tmp548_ = lambda;
					_tmp549_ = vala_lambda_expression_get_method (_tmp548_);
					_tmp550_ = _tmp549_;
					vala_method_set_closure (_tmp550_, TRUE);
				}
				_vala_code_node_unref0 (arg);
			}
		}
	}
	_tmp551_ = ret_type;
	if (VALA_IS_VOID_TYPE (_tmp551_)) {
		gboolean _tmp552_ = FALSE;
		gboolean _tmp553_ = FALSE;
		ValaCodeNode* _tmp554_;
		ValaCodeNode* _tmp555_;
		_tmp554_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp555_ = _tmp554_;
		if (!VALA_IS_EXPRESSION_STATEMENT (_tmp555_)) {
			ValaCodeNode* _tmp556_;
			ValaCodeNode* _tmp557_;
			_tmp556_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp557_ = _tmp556_;
			_tmp553_ = !VALA_IS_FOR_STATEMENT (_tmp557_);
		} else {
			_tmp553_ = FALSE;
		}
		if (_tmp553_) {
			ValaCodeNode* _tmp558_;
			ValaCodeNode* _tmp559_;
			_tmp558_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp559_ = _tmp558_;
			_tmp552_ = !VALA_IS_YIELD_STATEMENT (_tmp559_);
		} else {
			_tmp552_ = FALSE;
		}
		if (_tmp552_) {
			ValaSourceReference* _tmp560_;
			ValaSourceReference* _tmp561_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp560_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp561_ = _tmp560_;
			vala_report_error (_tmp561_, "invocation of void method not allowed as expression");
			result = FALSE;
			_vala_iterator_unref0 (arg_it);
			_vala_code_node_unref0 (last_arg);
			_vala_iterable_unref0 (params);
			_vala_code_node_unref0 (ret_type);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp562_ = ret_type;
	_tmp563_ = vala_data_type_copy (_tmp562_);
	_tmp564_ = _tmp563_;
	vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp564_);
	_vala_code_node_unref0 (_tmp564_);
	_tmp565_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
	_tmp566_ = _tmp565_;
	_tmp567_ = target_object_type;
	_tmp568_ = method_type_args;
	_tmp569_ = vala_data_type_get_actual_type (_tmp566_, _tmp567_, _tmp568_, (ValaCodeNode*) self);
	_tmp570_ = _tmp569_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp570_);
	_vala_code_node_unref0 (_tmp570_);
	_tmp571_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
	_tmp572_ = _tmp571_;
	if (_tmp572_) {
		gboolean _tmp573_ = FALSE;
		ValaDataType* _tmp574_;
		gboolean _tmp582_ = FALSE;
		ValaSemanticAnalyzer* _tmp583_;
		ValaSemanticAnalyzer* _tmp584_;
		ValaMethod* _tmp585_;
		ValaMethod* _tmp586_;
		_tmp574_ = mtype;
		if (!VALA_IS_METHOD_TYPE (_tmp574_)) {
			_tmp573_ = TRUE;
		} else {
			ValaDataType* _tmp575_;
			ValaMethod* _tmp576_;
			ValaMethod* _tmp577_;
			gboolean _tmp578_;
			gboolean _tmp579_;
			_tmp575_ = mtype;
			_tmp576_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp575_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
			_tmp577_ = _tmp576_;
			_tmp578_ = vala_method_get_coroutine (_tmp577_);
			_tmp579_ = _tmp578_;
			_tmp573_ = !_tmp579_;
		}
		if (_tmp573_) {
			ValaSourceReference* _tmp580_;
			ValaSourceReference* _tmp581_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp580_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp581_ = _tmp580_;
			vala_report_error (_tmp581_, "yield expression requires async method");
		}
		_tmp583_ = vala_code_context_get_analyzer (context);
		_tmp584_ = _tmp583_;
		_tmp585_ = vala_semantic_analyzer_get_current_method (_tmp584_);
		_tmp586_ = _tmp585_;
		if (_tmp586_ == NULL) {
			_tmp582_ = TRUE;
		} else {
			ValaSemanticAnalyzer* _tmp587_;
			ValaSemanticAnalyzer* _tmp588_;
			ValaMethod* _tmp589_;
			ValaMethod* _tmp590_;
			gboolean _tmp591_;
			gboolean _tmp592_;
			_tmp587_ = vala_code_context_get_analyzer (context);
			_tmp588_ = _tmp587_;
			_tmp589_ = vala_semantic_analyzer_get_current_method (_tmp588_);
			_tmp590_ = _tmp589_;
			_tmp591_ = vala_method_get_coroutine (_tmp590_);
			_tmp592_ = _tmp591_;
			_tmp582_ = !_tmp592_;
		}
		if (_tmp582_) {
			ValaSourceReference* _tmp593_;
			ValaSourceReference* _tmp594_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp593_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp594_ = _tmp593_;
			vala_report_error (_tmp594_, "yield expression not available outside async method");
		}
	}
	_tmp595_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp595_)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp596_;
		ValaMethod* _tmp597_;
		ValaMethod* _tmp598_;
		ValaMethod* _tmp599_;
		gboolean _tmp600_;
		gboolean _tmp601_;
		ValaMethod* _tmp604_;
		gboolean _tmp605_;
		gboolean _tmp606_;
		gboolean _tmp632_ = FALSE;
		gboolean _tmp633_ = FALSE;
		gboolean _tmp634_ = FALSE;
		gboolean _tmp635_;
		gboolean _tmp636_;
		ValaSignal* sig = NULL;
		ValaMethod* _tmp648_;
		ValaSymbol* _tmp649_;
		ValaSymbol* _tmp650_;
		gboolean _tmp651_ = FALSE;
		ValaSignal* _tmp652_;
		ValaDynamicSignal* dynamic_sig = NULL;
		ValaMethod* _tmp665_;
		ValaSymbol* _tmp666_;
		ValaSymbol* _tmp667_;
		gboolean _tmp668_ = FALSE;
		ValaDynamicSignal* _tmp669_;
		gboolean _tmp712_ = FALSE;
		ValaMethod* _tmp713_;
		gboolean _tmp821_ = FALSE;
		ValaMethod* _tmp822_;
		_tmp596_ = mtype;
		_tmp597_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp596_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp598_ = _tmp597_;
		m = _tmp598_;
		_tmp599_ = m;
		_tmp600_ = vala_method_get_returns_floating_reference (_tmp599_);
		_tmp601_ = _tmp600_;
		if (_tmp601_) {
			ValaDataType* _tmp602_;
			ValaDataType* _tmp603_;
			_tmp602_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp603_ = _tmp602_;
			vala_data_type_set_floating_reference (_tmp603_, TRUE);
		}
		_tmp604_ = m;
		_tmp605_ = vala_method_get_returns_modified_pointer (_tmp604_);
		_tmp606_ = _tmp605_;
		if (_tmp606_) {
			ValaExpression* inner = NULL;
			ValaExpression* _tmp607_;
			ValaExpression* _tmp608_;
			ValaExpression* _tmp609_;
			ValaExpression* _tmp610_;
			ValaExpression* _tmp611_;
			ValaProperty* prop = NULL;
			ValaExpression* _tmp612_;
			ValaSymbol* _tmp613_;
			ValaSymbol* _tmp614_;
			gboolean _tmp615_ = FALSE;
			ValaProperty* _tmp616_;
			_tmp607_ = vala_method_call_get_call (self);
			_tmp608_ = _tmp607_;
			_tmp609_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp608_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp610_ = _tmp609_;
			inner = _tmp610_;
			_tmp611_ = inner;
			vala_expression_set_lvalue (_tmp611_, TRUE);
			_tmp612_ = inner;
			_tmp613_ = vala_expression_get_symbol_reference (_tmp612_);
			_tmp614_ = _tmp613_;
			prop = VALA_IS_PROPERTY (_tmp614_) ? ((ValaProperty*) _tmp614_) : NULL;
			_tmp616_ = prop;
			if (_tmp616_ != NULL) {
				gboolean _tmp617_ = FALSE;
				ValaProperty* _tmp618_;
				ValaPropertyAccessor* _tmp619_;
				ValaPropertyAccessor* _tmp620_;
				_tmp618_ = prop;
				_tmp619_ = vala_property_get_set_accessor (_tmp618_);
				_tmp620_ = _tmp619_;
				if (_tmp620_ == NULL) {
					_tmp617_ = TRUE;
				} else {
					ValaProperty* _tmp621_;
					ValaPropertyAccessor* _tmp622_;
					ValaPropertyAccessor* _tmp623_;
					gboolean _tmp624_;
					gboolean _tmp625_;
					_tmp621_ = prop;
					_tmp622_ = vala_property_get_set_accessor (_tmp621_);
					_tmp623_ = _tmp622_;
					_tmp624_ = vala_property_accessor_get_writable (_tmp623_);
					_tmp625_ = _tmp624_;
					_tmp617_ = !_tmp625_;
				}
				_tmp615_ = _tmp617_;
			} else {
				_tmp615_ = FALSE;
			}
			if (_tmp615_) {
				ValaExpression* _tmp626_;
				ValaSourceReference* _tmp627_;
				ValaSourceReference* _tmp628_;
				ValaProperty* _tmp629_;
				gchar* _tmp630_;
				gchar* _tmp631_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp626_ = inner;
				_tmp627_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp626_);
				_tmp628_ = _tmp627_;
				_tmp629_ = prop;
				_tmp630_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp629_);
				_tmp631_ = _tmp630_;
				vala_report_error (_tmp628_, "Property `%s' is read-only", _tmp631_);
				_g_free0 (_tmp631_);
			}
		}
		_tmp635_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
		_tmp636_ = _tmp635_;
		if (_tmp636_) {
			ValaDataType* _tmp637_;
			ValaDataType* _tmp638_;
			gboolean _tmp639_;
			gboolean _tmp640_;
			_tmp637_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp638_ = _tmp637_;
			_tmp639_ = vala_data_type_get_nullable (_tmp638_);
			_tmp640_ = _tmp639_;
			_tmp634_ = !_tmp640_;
		} else {
			_tmp634_ = FALSE;
		}
		if (_tmp634_) {
			ValaDataType* _tmp641_;
			ValaDataType* _tmp642_;
			gboolean _tmp643_;
			gboolean _tmp644_;
			_tmp641_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp642_ = _tmp641_;
			_tmp643_ = vala_data_type_get_floating_reference (_tmp642_);
			_tmp644_ = _tmp643_;
			_tmp633_ = _tmp644_;
		} else {
			_tmp633_ = FALSE;
		}
		if (_tmp633_) {
			ValaDataType* _tmp645_;
			_tmp645_ = ret_type;
			_tmp632_ = VALA_IS_OBJECT_TYPE (_tmp645_);
		} else {
			_tmp632_ = FALSE;
		}
		if (_tmp632_) {
			ValaDataType* _tmp646_;
			ValaDataType* _tmp647_;
			_tmp646_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp647_ = _tmp646_;
			vala_data_type_set_nullable (_tmp647_, TRUE);
		}
		_tmp648_ = m;
		_tmp649_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp648_);
		_tmp650_ = _tmp649_;
		sig = VALA_IS_SIGNAL (_tmp650_) ? ((ValaSignal*) _tmp650_) : NULL;
		_tmp652_ = sig;
		if (_tmp652_ != NULL) {
			ValaMethod* _tmp653_;
			const gchar* _tmp654_;
			const gchar* _tmp655_;
			_tmp653_ = m;
			_tmp654_ = vala_symbol_get_name ((ValaSymbol*) _tmp653_);
			_tmp655_ = _tmp654_;
			_tmp651_ = g_strcmp0 (_tmp655_, "disconnect") == 0;
		} else {
			_tmp651_ = FALSE;
		}
		if (_tmp651_) {
			gboolean _tmp656_ = FALSE;
			ValaList* _tmp657_;
			gboolean _tmp658_;
			gboolean _tmp659_;
			_tmp657_ = self->priv->argument_list;
			_tmp658_ = vala_collection_get_is_empty ((ValaCollection*) _tmp657_);
			_tmp659_ = _tmp658_;
			if (!_tmp659_) {
				ValaList* _tmp660_;
				gpointer _tmp661_;
				ValaExpression* _tmp662_;
				_tmp660_ = self->priv->argument_list;
				_tmp661_ = vala_list_get (_tmp660_, 0);
				_tmp662_ = (ValaExpression*) _tmp661_;
				_tmp656_ = VALA_IS_LAMBDA_EXPRESSION (_tmp662_);
				_vala_code_node_unref0 (_tmp662_);
			} else {
				_tmp656_ = FALSE;
			}
			if (_tmp656_) {
				ValaSourceReference* _tmp663_;
				ValaSourceReference* _tmp664_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp663_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp664_ = _tmp663_;
				vala_report_error (_tmp664_, "Cannot disconnect lambda expression from signal");
				result = FALSE;
				_vala_iterator_unref0 (arg_it);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
		_tmp665_ = m;
		_tmp666_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp665_);
		_tmp667_ = _tmp666_;
		dynamic_sig = VALA_IS_DYNAMIC_SIGNAL (_tmp667_) ? ((ValaDynamicSignal*) _tmp667_) : NULL;
		_tmp669_ = dynamic_sig;
		if (_tmp669_ != NULL) {
			ValaDynamicSignal* _tmp670_;
			ValaExpression* _tmp671_;
			ValaExpression* _tmp672_;
			_tmp670_ = dynamic_sig;
			_tmp671_ = vala_dynamic_signal_get_handler (_tmp670_);
			_tmp672_ = _tmp671_;
			_tmp668_ = _tmp672_ != NULL;
		} else {
			_tmp668_ = FALSE;
		}
		if (_tmp668_) {
			ValaDynamicSignal* _tmp673_;
			ValaDynamicSignal* _tmp674_;
			ValaExpression* _tmp675_;
			ValaExpression* _tmp676_;
			ValaDataType* _tmp677_;
			ValaDataType* _tmp678_;
			ValaDataType* _tmp679_;
			ValaDataType* _tmp680_;
			ValaDataType* _tmp681_;
			gboolean first = FALSE;
			ValaDynamicSignal* _tmp699_;
			ValaExpression* _tmp700_;
			ValaExpression* _tmp701_;
			ValaDynamicSignal* _tmp702_;
			ValaDynamicSignal* _tmp703_;
			ValaSymbol* _tmp704_;
			ValaSymbol* _tmp705_;
			ValaObjectType* _tmp706_;
			ValaObjectType* _tmp707_;
			ValaDelegate* _tmp708_;
			ValaDelegate* _tmp709_;
			ValaDelegateType* _tmp710_;
			ValaDelegateType* _tmp711_;
			_tmp673_ = dynamic_sig;
			_tmp674_ = dynamic_sig;
			_tmp675_ = vala_dynamic_signal_get_handler (_tmp674_);
			_tmp676_ = _tmp675_;
			_tmp677_ = vala_expression_get_value_type (_tmp676_);
			_tmp678_ = _tmp677_;
			_tmp679_ = vala_data_type_get_return_type (_tmp678_);
			_tmp680_ = vala_data_type_copy (_tmp679_);
			_tmp681_ = _tmp680_;
			vala_callable_set_return_type ((ValaCallable*) _tmp673_, _tmp681_);
			_vala_code_node_unref0 (_tmp681_);
			first = TRUE;
			{
				ValaList* _param_list = NULL;
				ValaDynamicSignal* _tmp682_;
				ValaExpression* _tmp683_;
				ValaExpression* _tmp684_;
				ValaDataType* _tmp685_;
				ValaDataType* _tmp686_;
				ValaList* _tmp687_;
				gint _param_size = 0;
				ValaList* _tmp688_;
				gint _tmp689_;
				gint _tmp690_;
				gint _param_index = 0;
				_tmp682_ = dynamic_sig;
				_tmp683_ = vala_dynamic_signal_get_handler (_tmp682_);
				_tmp684_ = _tmp683_;
				_tmp685_ = vala_expression_get_value_type (_tmp684_);
				_tmp686_ = _tmp685_;
				_tmp687_ = vala_data_type_get_parameters (_tmp686_);
				_param_list = _tmp687_;
				_tmp688_ = _param_list;
				_tmp689_ = vala_collection_get_size ((ValaCollection*) _tmp688_);
				_tmp690_ = _tmp689_;
				_param_size = _tmp690_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp691_;
					gint _tmp692_;
					ValaParameter* param = NULL;
					ValaList* _tmp693_;
					gpointer _tmp694_;
					_param_index = _param_index + 1;
					_tmp691_ = _param_index;
					_tmp692_ = _param_size;
					if (!(_tmp691_ < _tmp692_)) {
						break;
					}
					_tmp693_ = _param_list;
					_tmp694_ = vala_list_get (_tmp693_, _param_index);
					param = (ValaParameter*) _tmp694_;
					if (first) {
						first = FALSE;
					} else {
						ValaDynamicSignal* _tmp695_;
						ValaParameter* _tmp696_;
						ValaParameter* _tmp697_;
						ValaParameter* _tmp698_;
						_tmp695_ = dynamic_sig;
						_tmp696_ = param;
						_tmp697_ = vala_parameter_copy (_tmp696_);
						_tmp698_ = _tmp697_;
						vala_callable_add_parameter ((ValaCallable*) _tmp695_, _tmp698_);
						_vala_code_node_unref0 (_tmp698_);
					}
					_vala_code_node_unref0 (param);
				}
			}
			_tmp699_ = dynamic_sig;
			_tmp700_ = vala_dynamic_signal_get_handler (_tmp699_);
			_tmp701_ = _tmp700_;
			_tmp702_ = dynamic_sig;
			_tmp703_ = dynamic_sig;
			_tmp704_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp703_);
			_tmp705_ = _tmp704_;
			_tmp706_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp705_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp707_ = _tmp706_;
			_tmp708_ = vala_signal_get_delegate ((ValaSignal*) _tmp702_, (ValaDataType*) _tmp707_, (ValaCodeNode*) self);
			_tmp709_ = _tmp708_;
			_tmp710_ = vala_delegate_type_new (_tmp709_);
			_tmp711_ = _tmp710_;
			vala_expression_set_target_type (_tmp701_, (ValaDataType*) _tmp711_);
			_vala_code_node_unref0 (_tmp711_);
			_vala_code_node_unref0 (_tmp709_);
			_vala_code_node_unref0 (_tmp707_);
		}
		_tmp713_ = m;
		if (_tmp713_ != NULL) {
			ValaMethod* _tmp714_;
			_tmp714_ = m;
			_tmp712_ = vala_method_has_type_parameters (_tmp714_);
		} else {
			_tmp712_ = FALSE;
		}
		if (_tmp712_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp715_;
			ValaExpression* _tmp716_;
			ValaMemberAccess* _tmp717_;
			ValaList* _tmp718_;
			gint _tmp719_;
			gint _tmp720_;
			_tmp715_ = vala_method_call_get_call (self);
			_tmp716_ = _tmp715_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp716_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp717_ = ma;
			_tmp718_ = vala_member_access_get_type_arguments (_tmp717_);
			_tmp719_ = vala_collection_get_size ((ValaCollection*) _tmp718_);
			_tmp720_ = _tmp719_;
			if (_tmp720_ == 0) {
				ValaList* _tmp787_;
				ValaIterator* _tmp788_;
				ValaDataType* _tmp815_;
				ValaDataType* _tmp816_;
				ValaDataType* _tmp817_;
				ValaList* _tmp818_;
				ValaDataType* _tmp819_;
				ValaDataType* _tmp820_;
				{
					ValaList* _type_param_list = NULL;
					ValaMethod* _tmp721_;
					ValaList* _tmp722_;
					gint _type_param_size = 0;
					ValaList* _tmp723_;
					gint _tmp724_;
					gint _tmp725_;
					gint _type_param_index = 0;
					_tmp721_ = m;
					_tmp722_ = vala_method_get_type_parameters (_tmp721_);
					_type_param_list = _tmp722_;
					_tmp723_ = _type_param_list;
					_tmp724_ = vala_collection_get_size ((ValaCollection*) _tmp723_);
					_tmp725_ = _tmp724_;
					_type_param_size = _tmp725_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp726_;
						gint _tmp727_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp728_;
						gpointer _tmp729_;
						ValaDataType* type_arg = NULL;
						ValaList* _tmp730_;
						ValaIterator* _tmp731_;
						gboolean _tmp767_ = FALSE;
						ValaDataType* _tmp768_;
						ValaDataType* _tmp778_;
						ValaMemberAccess* _tmp785_;
						ValaDataType* _tmp786_;
						_type_param_index = _type_param_index + 1;
						_tmp726_ = _type_param_index;
						_tmp727_ = _type_param_size;
						if (!(_tmp726_ < _tmp727_)) {
							break;
						}
						_tmp728_ = _type_param_list;
						_tmp729_ = vala_list_get (_tmp728_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp729_;
						type_arg = NULL;
						_tmp730_ = self->priv->argument_list;
						_tmp731_ = vala_iterable_iterator ((ValaIterable*) _tmp730_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp731_;
						{
							ValaList* _param_list = NULL;
							ValaList* _tmp732_;
							gint _param_size = 0;
							ValaList* _tmp733_;
							gint _tmp734_;
							gint _tmp735_;
							gint _param_index = 0;
							_tmp732_ = params;
							_param_list = _tmp732_;
							_tmp733_ = _param_list;
							_tmp734_ = vala_collection_get_size ((ValaCollection*) _tmp733_);
							_tmp735_ = _tmp734_;
							_param_size = _tmp735_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp736_;
								gint _tmp737_;
								ValaParameter* param = NULL;
								ValaList* _tmp738_;
								gpointer _tmp739_;
								gboolean _tmp740_ = FALSE;
								ValaParameter* _tmp741_;
								gboolean _tmp742_;
								gboolean _tmp743_;
								ValaIterator* _tmp747_;
								_param_index = _param_index + 1;
								_tmp736_ = _param_index;
								_tmp737_ = _param_size;
								if (!(_tmp736_ < _tmp737_)) {
									break;
								}
								_tmp738_ = _param_list;
								_tmp739_ = vala_list_get (_tmp738_, _param_index);
								param = (ValaParameter*) _tmp739_;
								_tmp741_ = param;
								_tmp742_ = vala_parameter_get_ellipsis (_tmp741_);
								_tmp743_ = _tmp742_;
								if (_tmp743_) {
									_tmp740_ = TRUE;
								} else {
									ValaParameter* _tmp744_;
									gboolean _tmp745_;
									gboolean _tmp746_;
									_tmp744_ = param;
									_tmp745_ = vala_parameter_get_params_array (_tmp744_);
									_tmp746_ = _tmp745_;
									_tmp740_ = _tmp746_;
								}
								if (_tmp740_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp747_ = arg_it;
								if (vala_iterator_next (_tmp747_)) {
									ValaExpression* arg = NULL;
									ValaIterator* _tmp748_;
									gpointer _tmp749_;
									ValaParameter* _tmp750_;
									ValaDataType* _tmp751_;
									ValaDataType* _tmp752_;
									ValaTypeParameter* _tmp753_;
									ValaExpression* _tmp754_;
									ValaDataType* _tmp755_;
									ValaDataType* _tmp756_;
									ValaDataType* _tmp757_;
									ValaDataType* _tmp758_;
									ValaExpression* _tmp759_;
									ValaExpression* _tmp760_;
									ValaDataType* _tmp761_;
									ValaDataType* _tmp762_;
									ValaDataType* _tmp763_;
									ValaList* _tmp764_;
									ValaDataType* _tmp765_;
									ValaDataType* _tmp766_;
									_tmp748_ = arg_it;
									_tmp749_ = vala_iterator_get (_tmp748_);
									arg = (ValaExpression*) _tmp749_;
									_tmp750_ = param;
									_tmp751_ = vala_variable_get_variable_type ((ValaVariable*) _tmp750_);
									_tmp752_ = _tmp751_;
									_tmp753_ = type_param;
									_tmp754_ = arg;
									_tmp755_ = vala_expression_get_value_type (_tmp754_);
									_tmp756_ = _tmp755_;
									_tmp757_ = vala_data_type_infer_type_argument (_tmp752_, _tmp753_, _tmp756_);
									_vala_code_node_unref0 (type_arg);
									type_arg = _tmp757_;
									_tmp758_ = type_arg;
									if (_tmp758_ != NULL) {
										_vala_code_node_unref0 (arg);
										_vala_code_node_unref0 (param);
										break;
									}
									_tmp759_ = arg;
									_tmp760_ = arg;
									_tmp761_ = vala_expression_get_formal_target_type (_tmp760_);
									_tmp762_ = _tmp761_;
									_tmp763_ = target_object_type;
									_tmp764_ = method_type_args;
									_tmp765_ = vala_data_type_get_actual_type (_tmp762_, _tmp763_, _tmp764_, (ValaCodeNode*) self);
									_tmp766_ = _tmp765_;
									vala_expression_set_target_type (_tmp759_, _tmp766_);
									_vala_code_node_unref0 (_tmp766_);
									_vala_code_node_unref0 (arg);
								}
								_vala_code_node_unref0 (param);
							}
						}
						_tmp768_ = type_arg;
						if (_tmp768_ == NULL) {
							ValaDataType* _tmp769_;
							ValaDataType* _tmp770_;
							_tmp769_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp770_ = _tmp769_;
							_tmp767_ = _tmp770_ != NULL;
						} else {
							_tmp767_ = FALSE;
						}
						if (_tmp767_) {
							ValaMethod* _tmp771_;
							ValaDataType* _tmp772_;
							ValaDataType* _tmp773_;
							ValaTypeParameter* _tmp774_;
							ValaDataType* _tmp775_;
							ValaDataType* _tmp776_;
							ValaDataType* _tmp777_;
							_tmp771_ = m;
							_tmp772_ = vala_callable_get_return_type ((ValaCallable*) _tmp771_);
							_tmp773_ = _tmp772_;
							_tmp774_ = type_param;
							_tmp775_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp776_ = _tmp775_;
							_tmp777_ = vala_data_type_infer_type_argument (_tmp773_, _tmp774_, _tmp776_);
							_vala_code_node_unref0 (type_arg);
							type_arg = _tmp777_;
						}
						_tmp778_ = type_arg;
						if (_tmp778_ == NULL) {
							ValaMemberAccess* _tmp779_;
							ValaSourceReference* _tmp780_;
							ValaSourceReference* _tmp781_;
							ValaTypeParameter* _tmp782_;
							gchar* _tmp783_;
							gchar* _tmp784_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp779_ = ma;
							_tmp780_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp779_);
							_tmp781_ = _tmp780_;
							_tmp782_ = type_param;
							_tmp783_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp782_);
							_tmp784_ = _tmp783_;
							vala_report_error (_tmp781_, "cannot infer generic type argument for type parameter `%s'", _tmp784_);
							_g_free0 (_tmp784_);
							result = FALSE;
							_vala_code_node_unref0 (type_arg);
							_vala_code_node_unref0 (type_param);
							_vala_iterator_unref0 (arg_it);
							_vala_code_node_unref0 (last_arg);
							_vala_iterable_unref0 (params);
							_vala_code_node_unref0 (ret_type);
							_vala_code_node_unref0 (mtype);
							_vala_iterable_unref0 (method_type_args);
							_vala_code_node_unref0 (target_object_type);
							return result;
						}
						_tmp785_ = ma;
						_tmp786_ = type_arg;
						vala_member_access_add_type_argument (_tmp785_, _tmp786_);
						_vala_code_node_unref0 (type_arg);
						_vala_code_node_unref0 (type_param);
					}
				}
				_tmp787_ = self->priv->argument_list;
				_tmp788_ = vala_iterable_iterator ((ValaIterable*) _tmp787_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp788_;
				{
					ValaList* _param_list = NULL;
					ValaList* _tmp789_;
					gint _param_size = 0;
					ValaList* _tmp790_;
					gint _tmp791_;
					gint _tmp792_;
					gint _param_index = 0;
					_tmp789_ = params;
					_param_list = _tmp789_;
					_tmp790_ = _param_list;
					_tmp791_ = vala_collection_get_size ((ValaCollection*) _tmp790_);
					_tmp792_ = _tmp791_;
					_param_size = _tmp792_;
					_param_index = -1;
					while (TRUE) {
						gint _tmp793_;
						gint _tmp794_;
						ValaParameter* param = NULL;
						ValaList* _tmp795_;
						gpointer _tmp796_;
						gboolean _tmp797_ = FALSE;
						ValaParameter* _tmp798_;
						gboolean _tmp799_;
						gboolean _tmp800_;
						ValaIterator* _tmp804_;
						_param_index = _param_index + 1;
						_tmp793_ = _param_index;
						_tmp794_ = _param_size;
						if (!(_tmp793_ < _tmp794_)) {
							break;
						}
						_tmp795_ = _param_list;
						_tmp796_ = vala_list_get (_tmp795_, _param_index);
						param = (ValaParameter*) _tmp796_;
						_tmp798_ = param;
						_tmp799_ = vala_parameter_get_ellipsis (_tmp798_);
						_tmp800_ = _tmp799_;
						if (_tmp800_) {
							_tmp797_ = TRUE;
						} else {
							ValaParameter* _tmp801_;
							gboolean _tmp802_;
							gboolean _tmp803_;
							_tmp801_ = param;
							_tmp802_ = vala_parameter_get_params_array (_tmp801_);
							_tmp803_ = _tmp802_;
							_tmp797_ = _tmp803_;
						}
						if (_tmp797_) {
							_vala_code_node_unref0 (param);
							break;
						}
						_tmp804_ = arg_it;
						if (vala_iterator_next (_tmp804_)) {
							ValaExpression* arg = NULL;
							ValaIterator* _tmp805_;
							gpointer _tmp806_;
							ValaExpression* _tmp807_;
							ValaExpression* _tmp808_;
							ValaDataType* _tmp809_;
							ValaDataType* _tmp810_;
							ValaDataType* _tmp811_;
							ValaList* _tmp812_;
							ValaDataType* _tmp813_;
							ValaDataType* _tmp814_;
							_tmp805_ = arg_it;
							_tmp806_ = vala_iterator_get (_tmp805_);
							arg = (ValaExpression*) _tmp806_;
							_tmp807_ = arg;
							_tmp808_ = arg;
							_tmp809_ = vala_expression_get_formal_target_type (_tmp808_);
							_tmp810_ = _tmp809_;
							_tmp811_ = target_object_type;
							_tmp812_ = method_type_args;
							_tmp813_ = vala_data_type_get_actual_type (_tmp810_, _tmp811_, _tmp812_, (ValaCodeNode*) self);
							_tmp814_ = _tmp813_;
							vala_expression_set_target_type (_tmp807_, _tmp814_);
							_vala_code_node_unref0 (_tmp814_);
							_vala_code_node_unref0 (arg);
						}
						_vala_code_node_unref0 (param);
					}
				}
				_tmp815_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
				_tmp816_ = _tmp815_;
				_tmp817_ = target_object_type;
				_tmp818_ = method_type_args;
				_tmp819_ = vala_data_type_get_actual_type (_tmp816_, _tmp817_, _tmp818_, (ValaCodeNode*) self);
				_tmp820_ = _tmp819_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp820_);
				_vala_code_node_unref0 (_tmp820_);
			}
		}
		_tmp822_ = m;
		if (_tmp822_ != NULL) {
			ValaMethod* _tmp823_;
			gboolean _tmp824_;
			gboolean _tmp825_;
			_tmp823_ = m;
			_tmp824_ = vala_method_get_coroutine (_tmp823_);
			_tmp825_ = _tmp824_;
			_tmp821_ = _tmp825_;
		} else {
			_tmp821_ = FALSE;
		}
		if (_tmp821_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp826_;
			ValaExpression* _tmp827_;
			ValaMemberAccess* _tmp828_;
			const gchar* _tmp829_;
			const gchar* _tmp830_;
			_tmp826_ = vala_method_call_get_call (self);
			_tmp827_ = _tmp826_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp827_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp828_ = ma;
			_tmp829_ = vala_member_access_get_member_name (_tmp828_);
			_tmp830_ = _tmp829_;
			if (g_strcmp0 (_tmp830_, "end") == 0) {
				ValaMethod* _tmp831_;
				ValaMethod* _tmp832_;
				ValaMethodType* _tmp833_;
				_tmp831_ = m;
				_tmp832_ = vala_method_get_end_method (_tmp831_);
				_tmp833_ = vala_method_type_new (_tmp832_);
				_vala_code_node_unref0 (mtype);
				mtype = (ValaDataType*) _tmp833_;
			}
		}
	}
	_tmp834_ = vala_code_context_get_analyzer (context);
	_tmp835_ = _tmp834_;
	_tmp836_ = mtype;
	_tmp837_ = params;
	_tmp838_ = self->priv->argument_list;
	if (!vala_semantic_analyzer_check_arguments (_tmp835_, (ValaExpression*) self, _tmp836_, _tmp837_, _tmp838_)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_iterator_unref0 (arg_it);
		_vala_code_node_unref0 (last_arg);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (ret_type);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp839_;
		gint _arg_size = 0;
		ValaList* _tmp840_;
		gint _tmp841_;
		gint _tmp842_;
		gint _arg_index = 0;
		_tmp839_ = self->priv->argument_list;
		_arg_list = _tmp839_;
		_tmp840_ = _arg_list;
		_tmp841_ = vala_collection_get_size ((ValaCollection*) _tmp840_);
		_tmp842_ = _tmp841_;
		_arg_size = _tmp842_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp843_;
			gint _tmp844_;
			ValaExpression* arg = NULL;
			ValaList* _tmp845_;
			gpointer _tmp846_;
			ValaSizeofExpression* sizeof_expr = NULL;
			ValaExpression* _tmp847_;
			gboolean _tmp848_ = FALSE;
			ValaSizeofExpression* _tmp849_;
			_arg_index = _arg_index + 1;
			_tmp843_ = _arg_index;
			_tmp844_ = _arg_size;
			if (!(_tmp843_ < _tmp844_)) {
				break;
			}
			_tmp845_ = _arg_list;
			_tmp846_ = vala_list_get (_tmp845_, _arg_index);
			arg = (ValaExpression*) _tmp846_;
			_tmp847_ = arg;
			sizeof_expr = VALA_IS_SIZEOF_EXPRESSION (_tmp847_) ? ((ValaSizeofExpression*) _tmp847_) : NULL;
			_tmp849_ = sizeof_expr;
			if (_tmp849_ != NULL) {
				ValaSizeofExpression* _tmp850_;
				ValaDataType* _tmp851_;
				ValaDataType* _tmp852_;
				_tmp850_ = sizeof_expr;
				_tmp851_ = vala_sizeof_expression_get_type_reference (_tmp850_);
				_tmp852_ = _tmp851_;
				_tmp848_ = VALA_IS_GENERIC_TYPE (_tmp852_);
			} else {
				_tmp848_ = FALSE;
			}
			if (_tmp848_) {
				ValaDataType* sizeof_type = NULL;
				ValaSizeofExpression* _tmp853_;
				ValaDataType* _tmp854_;
				ValaDataType* _tmp855_;
				ValaDataType* _tmp856_;
				ValaList* _tmp857_;
				ValaDataType* _tmp858_;
				ValaExpression* _tmp859_;
				ValaDataType* _tmp860_;
				ValaSourceReference* _tmp861_;
				ValaSourceReference* _tmp862_;
				ValaSizeofExpression* _tmp863_;
				ValaSizeofExpression* _tmp864_;
				_tmp853_ = sizeof_expr;
				_tmp854_ = vala_sizeof_expression_get_type_reference (_tmp853_);
				_tmp855_ = _tmp854_;
				_tmp856_ = target_object_type;
				_tmp857_ = method_type_args;
				_tmp858_ = vala_data_type_get_actual_type (_tmp855_, _tmp856_, _tmp857_, (ValaCodeNode*) self);
				sizeof_type = _tmp858_;
				_tmp859_ = arg;
				_tmp860_ = sizeof_type;
				_tmp861_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp862_ = _tmp861_;
				_tmp863_ = vala_sizeof_expression_new (_tmp860_, _tmp862_);
				_tmp864_ = _tmp863_;
				vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp859_, (ValaExpression*) _tmp864_);
				_vala_code_node_unref0 (_tmp864_);
				_vala_code_node_unref0 (sizeof_type);
			}
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp867_ = base_cm;
	if (_tmp867_ != NULL) {
		ValaCreationMethod* _tmp868_;
		_tmp868_ = base_cm;
		_tmp866_ = vala_method_is_variadic ((ValaMethod*) _tmp868_);
	} else {
		_tmp866_ = FALSE;
	}
	if (_tmp866_) {
		ValaList* _tmp869_;
		gint _tmp870_;
		gint _tmp871_;
		ValaCreationMethod* _tmp872_;
		ValaList* _tmp873_;
		gint _tmp874_;
		gint _tmp875_;
		_tmp869_ = self->priv->argument_list;
		_tmp870_ = vala_collection_get_size ((ValaCollection*) _tmp869_);
		_tmp871_ = _tmp870_;
		_tmp872_ = base_cm;
		_tmp873_ = vala_callable_get_parameters ((ValaCallable*) _tmp872_);
		_tmp874_ = vala_collection_get_size ((ValaCollection*) _tmp873_);
		_tmp875_ = _tmp874_;
		_tmp865_ = _tmp871_ == _tmp875_;
	} else {
		_tmp865_ = FALSE;
	}
	if (_tmp865_) {
		ValaExpression* this_last_arg = NULL;
		ValaList* _tmp876_;
		ValaList* _tmp877_;
		gint _tmp878_;
		gint _tmp879_;
		gpointer _tmp880_;
		gboolean _tmp881_ = FALSE;
		ValaExpression* _tmp882_;
		ValaDataType* _tmp883_;
		ValaDataType* _tmp884_;
		_tmp876_ = self->priv->argument_list;
		_tmp877_ = self->priv->argument_list;
		_tmp878_ = vala_collection_get_size ((ValaCollection*) _tmp877_);
		_tmp879_ = _tmp878_;
		_tmp880_ = vala_list_get (_tmp876_, _tmp879_ - 1);
		this_last_arg = (ValaExpression*) _tmp880_;
		_tmp882_ = this_last_arg;
		_tmp883_ = vala_expression_get_value_type (_tmp882_);
		_tmp884_ = _tmp883_;
		if (VALA_IS_STRUCT_VALUE_TYPE (_tmp884_)) {
			ValaExpression* _tmp885_;
			ValaDataType* _tmp886_;
			ValaDataType* _tmp887_;
			ValaTypeSymbol* _tmp888_;
			ValaTypeSymbol* _tmp889_;
			ValaSemanticAnalyzer* _tmp890_;
			ValaSemanticAnalyzer* _tmp891_;
			ValaDataType* _tmp892_;
			ValaTypeSymbol* _tmp893_;
			ValaTypeSymbol* _tmp894_;
			_tmp885_ = this_last_arg;
			_tmp886_ = vala_expression_get_value_type (_tmp885_);
			_tmp887_ = _tmp886_;
			_tmp888_ = vala_data_type_get_type_symbol (_tmp887_);
			_tmp889_ = _tmp888_;
			_tmp890_ = vala_code_context_get_analyzer (context);
			_tmp891_ = _tmp890_;
			_tmp892_ = _tmp891_->va_list_type;
			_tmp893_ = vala_data_type_get_type_symbol (_tmp892_);
			_tmp894_ = _tmp893_;
			_tmp881_ = _tmp889_ == _tmp894_;
		} else {
			_tmp881_ = FALSE;
		}
		if (_tmp881_) {
			vala_method_call_set_is_constructv_chainup (self, TRUE);
		}
		_vala_code_node_unref0 (this_last_arg);
	}
	_tmp895_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp896_ = _tmp895_;
	vala_code_node_check ((ValaCodeNode*) _tmp896_, context);
	_tmp897_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp898_ = _tmp897_;
	if (_tmp898_) {
		gboolean _tmp899_ = FALSE;
		ValaCodeNode* _tmp900_;
		ValaCodeNode* _tmp901_;
		_tmp900_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp901_ = _tmp900_;
		if (VALA_IS_LOCAL_VARIABLE (_tmp901_)) {
			_tmp899_ = TRUE;
		} else {
			ValaCodeNode* _tmp902_;
			ValaCodeNode* _tmp903_;
			_tmp902_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp903_ = _tmp902_;
			_tmp899_ = VALA_IS_EXPRESSION_STATEMENT (_tmp903_);
		}
		if (_tmp899_) {
		} else {
			ValaSemanticAnalyzer* _tmp904_;
			ValaSemanticAnalyzer* _tmp905_;
			ValaSymbol* _tmp906_;
			ValaSymbol* _tmp907_;
			_tmp904_ = vala_code_context_get_analyzer (context);
			_tmp905_ = _tmp904_;
			_tmp906_ = vala_semantic_analyzer_get_current_symbol (_tmp905_);
			_tmp907_ = _tmp906_;
			if (!VALA_IS_BLOCK (_tmp907_)) {
				ValaSourceReference* _tmp908_;
				ValaSourceReference* _tmp909_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp908_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp909_ = _tmp908_;
				vala_report_error (_tmp909_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp910_;
				ValaCodeNode* _tmp911_;
				ValaCodeNode* _tmp912_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp913_;
				ValaDataType* _tmp914_;
				ValaDataType* _tmp915_;
				ValaDataType* _tmp916_;
				gchar* _tmp917_;
				gchar* _tmp918_;
				ValaSourceReference* _tmp919_;
				ValaSourceReference* _tmp920_;
				ValaLocalVariable* _tmp921_;
				ValaLocalVariable* _tmp922_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp923_;
				ValaSourceReference* _tmp924_;
				ValaSourceReference* _tmp925_;
				ValaDeclarationStatement* _tmp926_;
				ValaDataType* _tmp927_;
				ValaDataType* _tmp928_;
				ValaSemanticAnalyzer* _tmp932_;
				ValaSemanticAnalyzer* _tmp933_;
				ValaBlock* _tmp934_;
				ValaDeclarationStatement* _tmp935_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp936_;
				ValaDataType* _tmp937_;
				ValaDataType* _tmp938_;
				ValaExpression* _tmp939_;
				ValaExpression* _tmp940_;
				ValaDataType* _tmp941_;
				ValaDataType* _tmp942_;
				ValaLocalVariable* _tmp943_;
				ValaDeclarationStatement* _tmp944_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp945_;
				ValaSemanticAnalyzer* _tmp946_;
				ValaSymbol* _tmp947_;
				ValaSymbol* _tmp948_;
				ValaBlock* _tmp949_;
				ValaBlock* _tmp950_;
				ValaLocalVariable* _tmp951_;
				ValaSemanticAnalyzer* _tmp952_;
				ValaSemanticAnalyzer* _tmp953_;
				ValaBlock* _tmp954_;
				ValaLocalVariable* _tmp955_;
				ValaCodeNode* _tmp956_;
				ValaExpression* _tmp957_;
				ValaExpression* _tmp958_;
				_tmp910_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp911_ = _tmp910_;
				_tmp912_ = _vala_code_node_ref0 (_tmp911_);
				old_parent_node = _tmp912_;
				_tmp913_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp914_ = _tmp913_;
				_tmp915_ = vala_data_type_copy (_tmp914_);
				_tmp916_ = _tmp915_;
				_tmp917_ = vala_code_node_get_temp_name ();
				_tmp918_ = _tmp917_;
				_tmp919_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp920_ = _tmp919_;
				_tmp921_ = vala_local_variable_new (_tmp916_, _tmp918_, NULL, _tmp920_);
				_tmp922_ = _tmp921_;
				_g_free0 (_tmp918_);
				_vala_code_node_unref0 (_tmp916_);
				local = _tmp922_;
				_tmp923_ = local;
				_tmp924_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp925_ = _tmp924_;
				_tmp926_ = vala_declaration_statement_new ((ValaSymbol*) _tmp923_, _tmp925_);
				decl = _tmp926_;
				_tmp927_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp928_ = _tmp927_;
				if (_tmp928_ == NULL) {
					ValaLocalVariable* _tmp929_;
					ValaDataType* _tmp930_;
					ValaDataType* _tmp931_;
					_tmp929_ = local;
					_tmp930_ = vala_variable_get_variable_type ((ValaVariable*) _tmp929_);
					_tmp931_ = _tmp930_;
					vala_data_type_set_floating_reference (_tmp931_, FALSE);
				}
				_tmp932_ = vala_code_context_get_analyzer (context);
				_tmp933_ = _tmp932_;
				_tmp934_ = _tmp933_->insert_block;
				_tmp935_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp934_, (ValaStatement*) _tmp935_);
				_tmp936_ = local;
				_tmp937_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp938_ = _tmp937_;
				_tmp939_ = vala_semantic_analyzer_create_temp_access (_tmp936_, _tmp938_);
				temp_access = _tmp939_;
				_tmp940_ = temp_access;
				_tmp941_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
				_tmp942_ = _tmp941_;
				vala_expression_set_formal_target_type (_tmp940_, _tmp942_);
				_tmp943_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp943_, (ValaExpression*) self);
				_tmp944_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp944_, context);
				_tmp945_ = vala_code_context_get_analyzer (context);
				_tmp946_ = _tmp945_;
				_tmp947_ = vala_semantic_analyzer_get_current_symbol (_tmp946_);
				_tmp948_ = _tmp947_;
				_tmp949_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp948_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp949_;
				_tmp950_ = block;
				_tmp951_ = local;
				vala_block_remove_local_variable (_tmp950_, _tmp951_);
				_tmp952_ = vala_code_context_get_analyzer (context);
				_tmp953_ = _tmp952_;
				_tmp954_ = _tmp953_->insert_block;
				_tmp955_ = local;
				vala_block_add_local_variable (_tmp954_, _tmp955_);
				_tmp956_ = old_parent_node;
				_tmp957_ = temp_access;
				vala_code_node_replace_expression (_tmp956_, (ValaExpression*) self, _tmp957_);
				_tmp958_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp958_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp959_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp960_ = _tmp959_;
	result = !_tmp960_;
	_vala_iterator_unref0 (arg_it);
	_vala_code_node_unref0 (last_arg);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (ret_type);
	_vala_code_node_unref0 (mtype);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (target_object_type);
	return result;
}

static void
vala_method_call_real_emit (ValaCodeNode* base,
                            ValaCodeGenerator* codegen)
{
	ValaMethodCall * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaMethodType* _tmp5_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	method_type = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp5_ = method_type;
	if (_tmp5_ != NULL) {
		ValaMethodType* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		ValaSymbol* _tmp9_;
		ValaSymbol* _tmp10_;
		_tmp6_ = method_type;
		_tmp7_ = vala_method_type_get_method_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp4_ = VALA_IS_SIGNAL (_tmp10_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		ValaExpression* _tmp14_;
		_tmp11_ = vala_method_call_get_call (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_tmp14_ = _tmp13_;
		vala_code_node_emit ((ValaCodeNode*) _tmp14_, codegen);
	} else {
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		_tmp15_ = vala_method_call_get_call (self);
		_tmp16_ = _tmp15_;
		vala_code_node_emit ((ValaCodeNode*) _tmp16_, codegen);
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp17_;
		gint _expr_size = 0;
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _expr_index = 0;
		_tmp17_ = self->priv->argument_list;
		_expr_list = _tmp17_;
		_tmp18_ = _expr_list;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_expr_size = _tmp20_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			ValaExpression* expr = NULL;
			ValaList* _tmp23_;
			gpointer _tmp24_;
			ValaExpression* _tmp25_;
			_expr_index = _expr_index + 1;
			_tmp21_ = _expr_index;
			_tmp22_ = _expr_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _expr_list;
			_tmp24_ = vala_list_get (_tmp23_, _expr_index);
			expr = (ValaExpression*) _tmp24_;
			_tmp25_ = expr;
			vala_code_node_emit ((ValaCodeNode*) _tmp25_, codegen);
			_vala_code_node_unref0 (expr);
		}
	}
	vala_code_visitor_visit_method_call ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                             ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		gint _arg_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_arg_list = _tmp2_;
		_tmp3_ = _arg_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_arg_size = _tmp5_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_arg_index = _arg_index + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = vala_list_get (_tmp8_, _arg_index);
			arg = (ValaExpression*) _tmp9_;
			_tmp10_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp10_, collection);
			_vala_code_node_unref0 (arg);
		}
	}
}

static void
vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                          ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		gint _arg_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_arg_list = _tmp2_;
		_tmp3_ = _arg_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_arg_size = _tmp5_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_arg_index = _arg_index + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = vala_list_get (_tmp8_, _arg_index);
			arg = (ValaExpression*) _tmp9_;
			_tmp10_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp10_, collection);
			_vala_code_node_unref0 (arg);
		}
	}
}

ValaStringLiteral*
vala_method_call_get_format_literal (ValaMethodCall* self)
{
	ValaMethodType* mtype = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	ValaStringLiteral* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	mtype = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp4_ = mtype;
	if (_tmp4_ != NULL) {
		gint format_arg = 0;
		ValaMethodType* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = mtype;
		_tmp6_ = vala_method_type_get_method_symbol (_tmp5_);
		_tmp7_ = _tmp6_;
		format_arg = vala_method_get_format_arg_index (_tmp7_);
		if (format_arg >= 0) {
			ValaList* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			_tmp9_ = self->priv->argument_list;
			_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp8_ = format_arg < _tmp11_;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			ValaList* _tmp12_;
			gpointer _tmp13_;
			ValaExpression* _tmp14_;
			ValaStringLiteral* _tmp15_;
			ValaStringLiteral* _tmp16_;
			_tmp12_ = self->priv->argument_list;
			_tmp13_ = vala_list_get (_tmp12_, format_arg);
			_tmp14_ = (ValaExpression*) _tmp13_;
			_tmp15_ = vala_string_literal_get_format_literal (_tmp14_);
			_tmp16_ = _tmp15_;
			_vala_code_node_unref0 (_tmp14_);
			result = _tmp16_;
			return result;
		}
	}
	result = NULL;
	return result;
}

static gchar*
vala_method_call_real_to_string (ValaCodeNode* base)
{
	ValaMethodCall * self;
	GString* b = NULL;
	GString* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GString* _tmp4_;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GString* _tmp9_;
	gboolean first = FALSE;
	GString* _tmp23_;
	GString* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* result = NULL;
	self = (ValaMethodCall*) base;
	_tmp0_ = g_string_new ("");
	b = _tmp0_;
	_tmp1_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GString* _tmp3_;
		_tmp3_ = b;
		g_string_append (_tmp3_, "yield ");
	}
	_tmp4_ = b;
	_tmp5_ = vala_method_call_get_call (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_code_node_to_string ((ValaCodeNode*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append (_tmp4_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = b;
	g_string_append_c (_tmp9_, '(');
	first = TRUE;
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp10_;
		gint _expr_size = 0;
		ValaList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _expr_index = 0;
		_tmp10_ = self->priv->argument_list;
		_expr_list = _tmp10_;
		_tmp11_ = _expr_list;
		_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_expr_size = _tmp13_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			ValaExpression* expr = NULL;
			ValaList* _tmp16_;
			gpointer _tmp17_;
			GString* _tmp19_;
			ValaExpression* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			_expr_index = _expr_index + 1;
			_tmp14_ = _expr_index;
			_tmp15_ = _expr_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _expr_list;
			_tmp17_ = vala_list_get (_tmp16_, _expr_index);
			expr = (ValaExpression*) _tmp17_;
			if (!first) {
				GString* _tmp18_;
				_tmp18_ = b;
				g_string_append (_tmp18_, ", ");
			}
			_tmp19_ = b;
			_tmp20_ = expr;
			_tmp21_ = vala_code_node_to_string ((ValaCodeNode*) _tmp20_);
			_tmp22_ = _tmp21_;
			g_string_append (_tmp19_, _tmp22_);
			_g_free0 (_tmp22_);
			first = FALSE;
			_vala_code_node_unref0 (expr);
		}
	}
	_tmp23_ = b;
	g_string_append_c (_tmp23_, ')');
	_tmp24_ = b;
	_tmp25_ = _tmp24_->str;
	_tmp26_ = g_strdup (_tmp25_);
	result = _tmp26_;
	_g_string_free0 (b);
	return result;
}

static void
vala_method_call_class_init (ValaMethodCallClass * klass,
                             gpointer klass_data)
{
	vala_method_call_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_call_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMethodCall_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_method_call_real_replace_expression;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_method_call_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_method_call_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_method_call_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_method_call_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_used_variables;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_method_call_real_to_string;
}

static void
vala_method_call_vala_callable_expression_interface_init (ValaCallableExpressionIface * iface,
                                                          gpointer iface_data)
{
	vala_method_call_vala_callable_expression_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_argument = (void (*) (ValaCallableExpression*, ValaExpression*)) vala_method_call_real_add_argument;
	iface->get_argument_list = (ValaList* (*) (ValaCallableExpression*)) vala_method_call_real_get_argument_list;
	iface->get_is_yield_expression = vala_method_call_real_get_is_yield_expression;
	iface->set_is_yield_expression = vala_method_call_real_set_is_yield_expression;
}

static void
vala_method_call_instance_init (ValaMethodCall * self,
                                gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_method_call_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
}

static void
vala_method_call_finalize (ValaCodeNode * obj)
{
	ValaMethodCall * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD_CALL, ValaMethodCall);
	_vala_code_node_unref0 (self->priv->_call);
	_vala_iterable_unref0 (self->priv->argument_list);
	VALA_CODE_NODE_CLASS (vala_method_call_parent_class)->finalize (obj);
}

/**
 * Represents an invocation expression in the source code.
 */
static GType
vala_method_call_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMethodCallClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_call_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethodCall), 0, (GInstanceInitFunc) vala_method_call_instance_init, NULL };
	static const GInterfaceInfo vala_callable_expression_info = { (GInterfaceInitFunc) vala_method_call_vala_callable_expression_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_method_call_type_id;
	vala_method_call_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMethodCall", &g_define_type_info, 0);
	g_type_add_interface_static (vala_method_call_type_id, VALA_TYPE_CALLABLE_EXPRESSION, &vala_callable_expression_info);
	ValaMethodCall_private_offset = g_type_add_instance_private (vala_method_call_type_id, sizeof (ValaMethodCallPrivate));
	return vala_method_call_type_id;
}

GType
vala_method_call_get_type (void)
{
	static volatile gsize vala_method_call_type_id__volatile = 0;
	if (g_once_init_enter (&vala_method_call_type_id__volatile)) {
		GType vala_method_call_type_id;
		vala_method_call_type_id = vala_method_call_get_type_once ();
		g_once_init_leave (&vala_method_call_type_id__volatile, vala_method_call_type_id);
	}
	return vala_method_call_type_id__volatile;
}

