/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _tainted_access;
	gboolean _creation_member;
	gboolean _qualified;
	gboolean _null_safe_access;
	ValaExpression* _inner;
	ValaList* type_argument_list;
	gboolean is_with_variable_access;
};

struct _Block1Data {
	int _ref_count_;
	ValaMemberAccess* self;
	gboolean found;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static void vala_member_access_check_narrowed_value_type (ValaMemberAccess* self);
static gboolean vala_member_access_is_tainted (ValaMemberAccess* self);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static ValaTraverseStatus __lambda4_ (Block1Data* _data1_,
                               ValaCodeNode* n);
static ValaTraverseStatus ___lambda4__vala_traverse_func (ValaCodeNode* node,
                                                   gpointer self);
static void vala_member_access_finalize (ValaCodeNode * obj);
static GType vala_member_access_get_type_once (void);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_tainted_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_tainted_access;
	return result;
}

void
vala_member_access_set_tainted_access (ValaMemberAccess* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_tainted_access = value;
}

gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}

void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

gboolean
vala_member_access_get_null_safe_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_null_safe_access;
	return result;
}

void
vala_member_access_set_null_safe_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_null_safe_access = value;
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, NULL);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the list of generic type arguments.
 *
 * @return type argument list
 */
ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		gint _type_arg_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_type_arg_list = _tmp4_;
		_tmp5_ = _type_arg_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_type_arg_size = _tmp7_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp10_;
			gpointer _tmp11_;
			ValaDataType* _tmp12_;
			_type_arg_index = _type_arg_index + 1;
			_tmp8_ = _type_arg_index;
			_tmp9_ = _type_arg_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _type_arg_list;
			_tmp11_ = vala_list_get (_tmp10_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp11_;
			_tmp12_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp12_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	gchar* result;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gboolean result;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	method = VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL;
	_tmp2_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp3_ = _tmp2_;
	if (VALA_IS_CONSTANT (_tmp3_)) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp7_)) {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_member_access_get_inner (self);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			ValaExpression* _tmp10_;
			ValaExpression* _tmp11_;
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			_tmp10_ = vala_member_access_get_inner (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_expression_get_symbol_reference (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp4_ = VALA_IS_CONSTANT (_tmp13_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp14_ = FALSE;
			ValaMethod* _tmp15_;
			_tmp15_ = method;
			if (_tmp15_ != NULL) {
				gboolean _tmp16_ = FALSE;
				ValaMethod* _tmp17_;
				ValaMemberBinding _tmp18_;
				ValaMemberBinding _tmp19_;
				_tmp17_ = method;
				_tmp18_ = vala_method_get_binding (_tmp17_);
				_tmp19_ = _tmp18_;
				if (_tmp19_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp16_ = TRUE;
				} else {
					gboolean _tmp20_;
					_tmp20_ = self->priv->_prototype_access;
					_tmp16_ = _tmp20_;
				}
				_tmp14_ = _tmp16_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				result = TRUE;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaLocalVariable* l = NULL;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaMethod* m = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaConstant* _tmp6_;
	gboolean result;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	c = VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL;
	_tmp2_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp3_ = _tmp2_;
	l = VALA_IS_LOCAL_VARIABLE (_tmp3_) ? ((ValaLocalVariable*) _tmp3_) : NULL;
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	m = VALA_IS_METHOD (_tmp5_) ? ((ValaMethod*) _tmp5_) : NULL;
	_tmp6_ = c;
	if (_tmp6_ != NULL) {
		gboolean _tmp7_ = FALSE;
		ValaConstant* _tmp8_;
		_tmp8_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp8_)) {
			_tmp7_ = TRUE;
		} else {
			ValaConstant* _tmp9_;
			ValaDataType* _tmp10_;
			ValaDataType* _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
			_tmp9_ = c;
			_tmp10_ = vala_constant_get_type_reference (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_data_type_get_nullable (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp7_ = !_tmp13_;
		}
		result = _tmp7_;
		return result;
	} else {
		ValaLocalVariable* _tmp14_;
		_tmp14_ = l;
		if (_tmp14_ != NULL) {
			ValaDataType* type = NULL;
			ValaLocalVariable* _tmp15_;
			ValaDataType* _tmp16_;
			ValaDataType* _tmp17_;
			ValaDataType* _tmp18_;
			_tmp15_ = l;
			_tmp16_ = vala_variable_get_variable_type ((ValaVariable*) _tmp15_);
			_tmp17_ = _tmp16_;
			type = _tmp17_;
			_tmp18_ = type;
			if (VALA_IS_ARRAY_TYPE (_tmp18_)) {
				ValaDataType* _tmp19_;
				gboolean _tmp20_;
				gboolean _tmp21_;
				_tmp19_ = type;
				_tmp20_ = vala_array_type_get_inline_allocated (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp21_ = _tmp20_;
				result = _tmp21_;
				return result;
			} else {
				gboolean _tmp22_ = FALSE;
				ValaDataType* _tmp23_;
				_tmp23_ = type;
				if (vala_data_type_is_real_non_null_struct_type (_tmp23_)) {
					_tmp22_ = TRUE;
				} else {
					ValaDataType* _tmp24_;
					_tmp24_ = type;
					_tmp22_ = vala_data_type_is_non_null_simple_type (_tmp24_);
				}
				result = _tmp22_;
				return result;
			}
		} else {
			ValaMethod* _tmp25_;
			_tmp25_ = m;
			if (_tmp25_ != NULL) {
				gboolean _tmp26_ = FALSE;
				ValaMethod* _tmp27_;
				ValaMemberBinding _tmp28_;
				ValaMemberBinding _tmp29_;
				_tmp27_ = m;
				_tmp28_ = vala_method_get_binding (_tmp27_);
				_tmp29_ = _tmp28_;
				if (_tmp29_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp26_ = TRUE;
				} else {
					gboolean _tmp30_;
					_tmp30_ = self->priv->_prototype_access;
					_tmp26_ = _tmp30_;
				}
				result = _tmp26_;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	ValaArrayList* visited_types = NULL;
	GEqualFunc _tmp20_;
	ValaArrayList* _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp721_ = FALSE;
	gboolean _tmp722_ = FALSE;
	gboolean _tmp723_ = FALSE;
	ValaExpression* _tmp724_;
	ValaExpression* _tmp725_;
	ValaSymbol* _tmp752_;
	ValaSymbol* _tmp753_;
	ValaSymbol* _tmp822_;
	ValaSymbol* _tmp823_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp859_;
	ValaSymbol* _tmp860_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp861_;
	ValaSymbol* _tmp862_;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp1310_;
	ValaSymbol* _tmp1311_;
	ValaSymbol* _tmp1313_;
	ValaVersionAttribute* _tmp1314_;
	ValaVersionAttribute* _tmp1315_;
	ValaSourceReference* _tmp1316_;
	ValaSourceReference* _tmp1317_;
	gboolean _tmp1318_ = FALSE;
	gboolean _tmp1369_ = FALSE;
	gboolean _tmp1396_ = FALSE;
	gboolean _tmp1397_ = FALSE;
	ValaDataType* _tmp1690_;
	ValaDataType* _tmp1691_;
	ValaSymbol* _tmp1694_;
	ValaSymbol* _tmp1695_;
	gboolean _tmp1736_;
	gboolean _tmp1737_;
	gboolean _tmp1738_;
	gboolean result;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = self->priv->_null_safe_access;
	if (_tmp4_) {
		gboolean _tmp5_;
		gboolean _tmp6_;
		vala_code_node_set_error ((ValaCodeNode*) self, !VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->check ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression), context));
		_tmp5_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp6_ = _tmp5_;
		result = !_tmp6_;
		return result;
	}
	_tmp7_ = vala_member_access_get_inner (self);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != NULL) {
		ValaExpression* _tmp9_;
		ValaExpression* _tmp10_;
		_tmp9_ = vala_member_access_get_inner (self);
		_tmp10_ = _tmp9_;
		vala_code_node_check ((ValaCodeNode*) _tmp10_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp11_;
		gint _type_arg_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _type_arg_index = 0;
		_tmp11_ = self->priv->type_argument_list;
		_type_arg_list = _tmp11_;
		_tmp12_ = _type_arg_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_type_arg_size = _tmp14_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp17_;
			gpointer _tmp18_;
			ValaDataType* _tmp19_;
			_type_arg_index = _type_arg_index + 1;
			_tmp15_ = _type_arg_index;
			_tmp16_ = _type_arg_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _type_arg_list;
			_tmp18_ = vala_list_get (_tmp17_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp18_;
			_tmp19_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp19_, context);
			_vala_code_node_unref0 (type_arg);
		}
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	_tmp20_ = g_direct_equal;
	_tmp21_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp20_);
	visited_types = _tmp21_;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp22_ = self->priv->_qualified;
	if (_tmp22_) {
		ValaNamespace* _tmp23_;
		ValaNamespace* _tmp24_;
		ValaSymbol* _tmp25_;
		ValaScope* _tmp26_;
		ValaScope* _tmp27_;
		const gchar* _tmp28_;
		ValaSymbol* _tmp29_;
		ValaSymbol* _tmp30_;
		_tmp23_ = vala_code_context_get_root (context);
		_tmp24_ = _tmp23_;
		base_symbol = (ValaSymbol*) _tmp24_;
		_tmp25_ = base_symbol;
		_tmp26_ = vala_symbol_get_scope (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = self->priv->_member_name;
		_tmp29_ = vala_scope_lookup (_tmp27_, _tmp28_);
		_tmp30_ = _tmp29_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp30_);
		_vala_code_node_unref0 (_tmp30_);
	} else {
		ValaExpression* _tmp31_;
		ValaExpression* _tmp32_;
		_tmp31_ = vala_member_access_get_inner (self);
		_tmp32_ = _tmp31_;
		if (_tmp32_ == NULL) {
			const gchar* _tmp33_;
			ValaSemanticAnalyzer* _tmp38_;
			ValaSemanticAnalyzer* _tmp39_;
			ValaSymbol* _tmp40_;
			ValaSymbol* _tmp41_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp42_;
			ValaSemanticAnalyzer* _tmp43_;
			ValaSymbol* _tmp44_;
			ValaSymbol* _tmp45_;
			gboolean _tmp182_ = FALSE;
			ValaSymbol* _tmp183_;
			ValaSymbol* _tmp184_;
			_tmp33_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp33_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp34_;
				ValaSemanticAnalyzer* _tmp35_;
				_tmp34_ = vala_code_context_get_analyzer (context);
				_tmp35_ = _tmp34_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp35_)) {
					ValaSourceReference* _tmp36_;
					ValaSourceReference* _tmp37_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp37_ = _tmp36_;
					vala_report_error (_tmp37_, "This access invalid outside of instance methods");
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
			}
			_tmp38_ = vala_code_context_get_analyzer (context);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_semantic_analyzer_get_current_symbol (_tmp39_);
			_tmp41_ = _tmp40_;
			base_symbol = _tmp41_;
			method_found = FALSE;
			_tmp42_ = vala_code_context_get_analyzer (context);
			_tmp43_ = _tmp42_;
			_tmp44_ = vala_semantic_analyzer_get_current_symbol (_tmp43_);
			_tmp45_ = _tmp44_;
			sym = _tmp45_;
			while (TRUE) {
				gboolean _tmp46_ = FALSE;
				ValaSymbol* _tmp47_;
				ValaSymbol* _tmp93_;
				const gchar* _tmp94_;
				ValaSymbol* _tmp95_;
				ValaSymbol* _tmp96_;
				gboolean _tmp97_ = FALSE;
				gboolean _tmp98_ = FALSE;
				gboolean _tmp135_ = FALSE;
				gboolean _tmp136_ = FALSE;
				ValaSymbol* _tmp137_;
				ValaSymbol* _tmp138_;
				ValaSymbol* _tmp176_;
				ValaSymbol* _tmp177_;
				ValaSymbol* _tmp179_;
				ValaSymbol* _tmp180_;
				ValaSymbol* _tmp181_;
				_tmp47_ = sym;
				if (_tmp47_ != NULL) {
					ValaSymbol* _tmp48_;
					ValaSymbol* _tmp49_;
					_tmp48_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp49_ = _tmp48_;
					_tmp46_ = _tmp49_ == NULL;
				} else {
					_tmp46_ = FALSE;
				}
				if (!_tmp46_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp50_;
					_tmp50_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp50_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp51_;
						ValaCreationMethod* _tmp52_;
						ValaParameter* _tmp53_;
						ValaParameter* _tmp54_;
						_tmp51_ = sym;
						cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
						_tmp52_ = cm;
						_tmp53_ = vala_method_get_this_parameter ((ValaMethod*) _tmp52_);
						_tmp54_ = _tmp53_;
						this_parameter = _tmp54_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
					} else {
						ValaSymbol* _tmp55_;
						_tmp55_ = sym;
						if (VALA_IS_PROPERTY (_tmp55_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp56_;
							ValaProperty* _tmp57_;
							ValaParameter* _tmp58_;
							ValaParameter* _tmp59_;
							ValaProperty* _tmp60_;
							ValaMemberBinding _tmp61_;
							ValaMemberBinding _tmp62_;
							ValaProperty* _tmp63_;
							ValaMemberBinding _tmp64_;
							ValaMemberBinding _tmp65_;
							_tmp56_ = sym;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp57_ = prop;
							_tmp58_ = vala_property_get_this_parameter (_tmp57_);
							_tmp59_ = _tmp58_;
							this_parameter = _tmp59_;
							_tmp60_ = prop;
							_tmp61_ = vala_property_get_binding (_tmp60_);
							_tmp62_ = _tmp61_;
							may_access_instance_members = _tmp62_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp63_ = prop;
							_tmp64_ = vala_property_get_binding (_tmp63_);
							_tmp65_ = _tmp64_;
							may_access_klass_members = _tmp65_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
						} else {
							ValaSymbol* _tmp66_;
							_tmp66_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp66_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp67_;
								ValaConstructor* _tmp68_;
								ValaParameter* _tmp69_;
								ValaParameter* _tmp70_;
								ValaConstructor* _tmp71_;
								ValaMemberBinding _tmp72_;
								ValaMemberBinding _tmp73_;
								_tmp67_ = sym;
								c = G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, VALA_TYPE_CONSTRUCTOR, ValaConstructor);
								_tmp68_ = c;
								_tmp69_ = vala_constructor_get_this_parameter (_tmp68_);
								_tmp70_ = _tmp69_;
								this_parameter = _tmp70_;
								_tmp71_ = c;
								_tmp72_ = vala_constructor_get_binding (_tmp71_);
								_tmp73_ = _tmp72_;
								may_access_instance_members = _tmp73_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
							} else {
								ValaSymbol* _tmp74_;
								_tmp74_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp74_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp75_;
									ValaDestructor* _tmp76_;
									ValaParameter* _tmp77_;
									ValaParameter* _tmp78_;
									ValaDestructor* _tmp79_;
									ValaMemberBinding _tmp80_;
									ValaMemberBinding _tmp81_;
									_tmp75_ = sym;
									d = G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, VALA_TYPE_DESTRUCTOR, ValaDestructor);
									_tmp76_ = d;
									_tmp77_ = vala_destructor_get_this_parameter (_tmp76_);
									_tmp78_ = _tmp77_;
									this_parameter = _tmp78_;
									_tmp79_ = d;
									_tmp80_ = vala_destructor_get_binding (_tmp79_);
									_tmp81_ = _tmp80_;
									may_access_instance_members = _tmp81_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
								} else {
									ValaSymbol* _tmp82_;
									_tmp82_ = sym;
									if (VALA_IS_METHOD (_tmp82_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp83_;
										ValaMethod* _tmp84_;
										ValaParameter* _tmp85_;
										ValaParameter* _tmp86_;
										ValaMethod* _tmp87_;
										ValaMemberBinding _tmp88_;
										ValaMemberBinding _tmp89_;
										ValaMethod* _tmp90_;
										ValaMemberBinding _tmp91_;
										ValaMemberBinding _tmp92_;
										_tmp83_ = sym;
										m = G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, VALA_TYPE_METHOD, ValaMethod);
										_tmp84_ = m;
										_tmp85_ = vala_method_get_this_parameter (_tmp84_);
										_tmp86_ = _tmp85_;
										this_parameter = _tmp86_;
										_tmp87_ = m;
										_tmp88_ = vala_method_get_binding (_tmp87_);
										_tmp89_ = _tmp88_;
										may_access_instance_members = _tmp89_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp90_ = m;
										_tmp91_ = vala_method_get_binding (_tmp90_);
										_tmp92_ = _tmp91_;
										may_access_klass_members = _tmp92_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
									}
								}
							}
						}
					}
				}
				_tmp93_ = sym;
				_tmp94_ = self->priv->_member_name;
				_tmp95_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp93_, _tmp94_);
				_tmp96_ = _tmp95_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp96_);
				_vala_code_node_unref0 (_tmp96_);
				if (!self->priv->is_with_variable_access) {
					ValaSymbol* _tmp99_;
					ValaSymbol* _tmp100_;
					_tmp99_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp100_ = _tmp99_;
					_tmp98_ = _tmp100_ == NULL;
				} else {
					_tmp98_ = FALSE;
				}
				if (_tmp98_) {
					ValaSymbol* _tmp101_;
					_tmp101_ = sym;
					_tmp97_ = VALA_IS_WITH_STATEMENT (_tmp101_);
				} else {
					_tmp97_ = FALSE;
				}
				if (_tmp97_) {
					ValaWithStatement* w = NULL;
					ValaSymbol* _tmp102_;
					ValaDataType* variable_type = NULL;
					ValaWithStatement* _tmp103_;
					ValaLocalVariable* _tmp104_;
					ValaLocalVariable* _tmp105_;
					ValaDataType* _tmp106_;
					ValaDataType* _tmp107_;
					ValaDataType* _tmp108_;
					ValaDataType* _tmp109_;
					ValaArrayList* _tmp114_;
					ValaDataType* _tmp115_;
					ValaDataType* _tmp116_;
					const gchar* _tmp117_;
					ValaSymbol* _tmp118_;
					ValaSymbol* _tmp119_;
					ValaSymbol* _tmp120_;
					ValaSymbol* _tmp121_;
					_tmp102_ = sym;
					w = G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, VALA_TYPE_WITH_STATEMENT, ValaWithStatement);
					_tmp103_ = w;
					_tmp104_ = vala_with_statement_get_with_variable (_tmp103_);
					_tmp105_ = _tmp104_;
					_tmp106_ = vala_variable_get_variable_type ((ValaVariable*) _tmp105_);
					_tmp107_ = _tmp106_;
					_tmp108_ = _vala_code_node_ref0 (_tmp107_);
					variable_type = _tmp108_;
					_tmp109_ = variable_type;
					if (VALA_IS_POINTER_TYPE (_tmp109_)) {
						ValaDataType* _tmp110_;
						ValaDataType* _tmp111_;
						ValaDataType* _tmp112_;
						ValaDataType* _tmp113_;
						_tmp110_ = variable_type;
						_tmp111_ = vala_pointer_type_get_base_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp110_, VALA_TYPE_POINTER_TYPE, ValaPointerType));
						_tmp112_ = _tmp111_;
						_tmp113_ = _vala_code_node_ref0 (_tmp112_);
						_vala_code_node_unref0 (variable_type);
						variable_type = _tmp113_;
					}
					_tmp114_ = visited_types;
					_tmp115_ = variable_type;
					vala_collection_add ((ValaCollection*) _tmp114_, _tmp115_);
					_tmp116_ = variable_type;
					_tmp117_ = self->priv->_member_name;
					_tmp118_ = vala_data_type_get_member (_tmp116_, _tmp117_);
					_tmp119_ = _tmp118_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp119_);
					_vala_code_node_unref0 (_tmp119_);
					_tmp120_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp121_ = _tmp120_;
					if (_tmp121_ != NULL) {
						ValaWithStatement* _tmp122_;
						ValaLocalVariable* _tmp123_;
						ValaLocalVariable* _tmp124_;
						const gchar* _tmp125_;
						const gchar* _tmp126_;
						ValaSourceReference* _tmp127_;
						ValaSourceReference* _tmp128_;
						ValaMemberAccess* _tmp129_;
						ValaMemberAccess* _tmp130_;
						ValaExpression* _tmp131_;
						ValaExpression* _tmp132_;
						ValaExpression* _tmp133_;
						ValaExpression* _tmp134_;
						_tmp122_ = w;
						_tmp123_ = vala_with_statement_get_with_variable (_tmp122_);
						_tmp124_ = _tmp123_;
						_tmp125_ = vala_symbol_get_name ((ValaSymbol*) _tmp124_);
						_tmp126_ = _tmp125_;
						_tmp127_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp128_ = _tmp127_;
						_tmp129_ = vala_member_access_new (NULL, _tmp126_, _tmp128_);
						_tmp130_ = _tmp129_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp130_);
						_vala_code_node_unref0 (_tmp130_);
						_tmp131_ = vala_member_access_get_inner (self);
						_tmp132_ = _tmp131_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp132_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess)->priv->is_with_variable_access = TRUE;
						_tmp133_ = vala_member_access_get_inner (self);
						_tmp134_ = _tmp133_;
						vala_code_node_check ((ValaCodeNode*) _tmp134_, context);
						may_access_instance_members = TRUE;
					}
					_vala_code_node_unref0 (variable_type);
				}
				_tmp137_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp138_ = _tmp137_;
				if (_tmp138_ == NULL) {
					ValaSymbol* _tmp139_;
					_tmp139_ = sym;
					_tmp136_ = VALA_IS_TYPESYMBOL (_tmp139_);
				} else {
					_tmp136_ = FALSE;
				}
				if (_tmp136_) {
					_tmp135_ = may_access_instance_members;
				} else {
					_tmp135_ = FALSE;
				}
				if (_tmp135_) {
					ValaParameter* _tmp140_;
					ValaDataType* _tmp141_;
					ValaDataType* _tmp142_;
					const gchar* _tmp143_;
					ValaSymbol* _tmp144_;
					ValaSymbol* _tmp145_;
					gboolean _tmp146_ = FALSE;
					ValaSymbol* _tmp147_;
					ValaSymbol* _tmp148_;
					_tmp140_ = this_parameter;
					_tmp141_ = vala_variable_get_variable_type ((ValaVariable*) _tmp140_);
					_tmp142_ = _tmp141_;
					_tmp143_ = self->priv->_member_name;
					_tmp144_ = vala_data_type_get_member (_tmp142_, _tmp143_);
					_tmp145_ = _tmp144_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp145_);
					_vala_code_node_unref0 (_tmp145_);
					_tmp147_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp148_ = _tmp147_;
					if (_tmp148_ != NULL) {
						ValaSymbol* _tmp149_;
						ValaSymbol* _tmp150_;
						_tmp149_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp150_ = _tmp149_;
						_tmp146_ = vala_member_access_is_instance_symbol (_tmp150_);
					} else {
						_tmp146_ = FALSE;
					}
					if (_tmp146_) {
						ValaSourceReference* _tmp151_;
						ValaSourceReference* _tmp152_;
						ValaMemberAccess* _tmp153_;
						ValaMemberAccess* _tmp154_;
						ValaExpression* _tmp155_;
						ValaExpression* _tmp156_;
						ValaParameter* _tmp157_;
						ValaDataType* _tmp158_;
						ValaDataType* _tmp159_;
						ValaDataType* _tmp160_;
						ValaDataType* _tmp161_;
						ValaExpression* _tmp162_;
						ValaExpression* _tmp163_;
						ValaDataType* _tmp164_;
						ValaDataType* _tmp165_;
						ValaExpression* _tmp166_;
						ValaExpression* _tmp167_;
						ValaParameter* _tmp168_;
						ValaExpression* _tmp169_;
						ValaExpression* _tmp170_;
						ValaDataType* _tmp171_;
						ValaDataType* _tmp172_;
						const gchar* _tmp173_;
						ValaSymbol* _tmp174_;
						ValaSymbol* _tmp175_;
						_tmp151_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp152_ = _tmp151_;
						_tmp153_ = vala_member_access_new (NULL, "this", _tmp152_);
						_tmp154_ = _tmp153_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp154_);
						_vala_code_node_unref0 (_tmp154_);
						_tmp155_ = vala_member_access_get_inner (self);
						_tmp156_ = _tmp155_;
						_tmp157_ = this_parameter;
						_tmp158_ = vala_variable_get_variable_type ((ValaVariable*) _tmp157_);
						_tmp159_ = _tmp158_;
						_tmp160_ = vala_data_type_copy (_tmp159_);
						_tmp161_ = _tmp160_;
						vala_expression_set_value_type (_tmp156_, _tmp161_);
						_vala_code_node_unref0 (_tmp161_);
						_tmp162_ = vala_member_access_get_inner (self);
						_tmp163_ = _tmp162_;
						_tmp164_ = vala_expression_get_value_type (_tmp163_);
						_tmp165_ = _tmp164_;
						vala_data_type_set_value_owned (_tmp165_, FALSE);
						_tmp166_ = vala_member_access_get_inner (self);
						_tmp167_ = _tmp166_;
						_tmp168_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp167_, (ValaSymbol*) _tmp168_);
						_tmp169_ = vala_member_access_get_inner (self);
						_tmp170_ = _tmp169_;
						_tmp171_ = vala_expression_get_value_type (_tmp170_);
						_tmp172_ = _tmp171_;
						_tmp173_ = self->priv->_member_name;
						_tmp174_ = vala_data_type_get_member (_tmp172_, _tmp173_);
						_tmp175_ = _tmp174_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp175_);
						_vala_code_node_unref0 (_tmp175_);
					}
				}
				_tmp176_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp177_ = _tmp176_;
				if (_tmp177_ == NULL) {
					ValaSymbol* _tmp178_;
					_tmp178_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp178_)) {
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp179_ = sym;
				_tmp180_ = vala_symbol_get_parent_symbol (_tmp179_);
				_tmp181_ = _tmp180_;
				sym = _tmp181_;
			}
			_tmp183_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp184_ = _tmp183_;
			if (_tmp184_ == NULL) {
				ValaSourceReference* _tmp185_;
				ValaSourceReference* _tmp186_;
				_tmp185_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp186_ = _tmp185_;
				_tmp182_ = _tmp186_ != NULL;
			} else {
				_tmp182_ = FALSE;
			}
			if (_tmp182_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp187_;
					ValaSourceReference* _tmp188_;
					ValaList* _tmp189_;
					ValaList* _tmp190_;
					gint _ns_size = 0;
					ValaList* _tmp191_;
					gint _tmp192_;
					gint _tmp193_;
					gint _ns_index = 0;
					_tmp187_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp188_ = _tmp187_;
					_tmp189_ = vala_source_reference_get_using_directives (_tmp188_);
					_tmp190_ = _tmp189_;
					_ns_list = _tmp190_;
					_tmp191_ = _ns_list;
					_tmp192_ = vala_collection_get_size ((ValaCollection*) _tmp191_);
					_tmp193_ = _tmp192_;
					_ns_size = _tmp193_;
					_ns_index = -1;
					while (TRUE) {
						gint _tmp194_;
						gint _tmp195_;
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp196_;
						gpointer _tmp197_;
						ValaUsingDirective* _tmp198_;
						gboolean _tmp199_;
						gboolean _tmp200_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp201_;
						ValaSymbol* _tmp202_;
						ValaSymbol* _tmp203_;
						ValaScope* _tmp204_;
						ValaScope* _tmp205_;
						const gchar* _tmp206_;
						ValaSymbol* _tmp207_;
						ValaSymbol* _tmp208_;
						_ns_index = _ns_index + 1;
						_tmp194_ = _ns_index;
						_tmp195_ = _ns_size;
						if (!(_tmp194_ < _tmp195_)) {
							break;
						}
						_tmp196_ = _ns_list;
						_tmp197_ = vala_list_get (_tmp196_, _ns_index);
						ns = (ValaUsingDirective*) _tmp197_;
						_tmp198_ = ns;
						_tmp199_ = vala_code_node_get_error ((ValaCodeNode*) _tmp198_);
						_tmp200_ = _tmp199_;
						if (_tmp200_) {
							_vala_code_node_unref0 (ns);
							continue;
						}
						_tmp201_ = ns;
						_tmp202_ = vala_using_directive_get_namespace_symbol (_tmp201_);
						_tmp203_ = _tmp202_;
						_tmp204_ = vala_symbol_get_scope (_tmp203_);
						_tmp205_ = _tmp204_;
						_tmp206_ = self->priv->_member_name;
						_tmp207_ = vala_scope_lookup (_tmp205_, _tmp206_);
						local_sym = _tmp207_;
						_tmp208_ = local_sym;
						if (_tmp208_ != NULL) {
							gboolean _tmp209_ = FALSE;
							ValaSymbol* _tmp210_;
							ValaSymbol* _tmp211_;
							ValaSymbol* inner_sym = NULL;
							ValaSymbol* _tmp225_;
							ValaSymbol* _tmp226_;
							ValaSymbol* _tmp227_;
							ValaMemberAccess* inner_ma = NULL;
							ValaMemberAccess* _tmp247_;
							ValaExpression* _tmp248_;
							ValaExpression* _tmp249_;
							ValaSymbol* _tmp250_;
							_tmp210_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp211_ = _tmp210_;
							if (_tmp211_ != NULL) {
								ValaSymbol* _tmp212_;
								ValaSymbol* _tmp213_;
								ValaSymbol* _tmp214_;
								_tmp212_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp213_ = _tmp212_;
								_tmp214_ = local_sym;
								_tmp209_ = _tmp213_ != _tmp214_;
							} else {
								_tmp209_ = FALSE;
							}
							if (_tmp209_) {
								ValaSourceReference* _tmp215_;
								ValaSourceReference* _tmp216_;
								const gchar* _tmp217_;
								ValaSymbol* _tmp218_;
								ValaSymbol* _tmp219_;
								gchar* _tmp220_;
								gchar* _tmp221_;
								ValaSymbol* _tmp222_;
								gchar* _tmp223_;
								gchar* _tmp224_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp215_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp216_ = _tmp215_;
								_tmp217_ = self->priv->_member_name;
								_tmp218_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp219_ = _tmp218_;
								_tmp220_ = vala_symbol_get_full_name (_tmp219_);
								_tmp221_ = _tmp220_;
								_tmp222_ = local_sym;
								_tmp223_ = vala_symbol_get_full_name (_tmp222_);
								_tmp224_ = _tmp223_;
								vala_report_error (_tmp216_, "`%s' is an ambiguous reference between `%s' and `%s'", _tmp217_, _tmp221_, _tmp224_);
								_g_free0 (_tmp224_);
								_g_free0 (_tmp221_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp225_ = local_sym;
							_tmp226_ = vala_symbol_get_parent_symbol (_tmp225_);
							_tmp227_ = _tmp226_;
							inner_sym = _tmp227_;
							inner_ma = self;
							while (TRUE) {
								gboolean _tmp228_ = FALSE;
								ValaSymbol* _tmp229_;
								ValaMemberAccess* _tmp233_;
								ValaSymbol* _tmp234_;
								const gchar* _tmp235_;
								const gchar* _tmp236_;
								ValaSourceReference* _tmp237_;
								ValaSourceReference* _tmp238_;
								ValaMemberAccess* _tmp239_;
								ValaMemberAccess* _tmp240_;
								ValaMemberAccess* _tmp241_;
								ValaExpression* _tmp242_;
								ValaExpression* _tmp243_;
								ValaSymbol* _tmp244_;
								ValaSymbol* _tmp245_;
								ValaSymbol* _tmp246_;
								_tmp229_ = inner_sym;
								if (_tmp229_ != NULL) {
									ValaSymbol* _tmp230_;
									const gchar* _tmp231_;
									const gchar* _tmp232_;
									_tmp230_ = inner_sym;
									_tmp231_ = vala_symbol_get_name (_tmp230_);
									_tmp232_ = _tmp231_;
									_tmp228_ = _tmp232_ != NULL;
								} else {
									_tmp228_ = FALSE;
								}
								if (!_tmp228_) {
									break;
								}
								_tmp233_ = inner_ma;
								_tmp234_ = inner_sym;
								_tmp235_ = vala_symbol_get_name (_tmp234_);
								_tmp236_ = _tmp235_;
								_tmp237_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp238_ = _tmp237_;
								_tmp239_ = vala_member_access_new (NULL, _tmp236_, _tmp238_);
								_tmp240_ = _tmp239_;
								vala_member_access_set_inner (_tmp233_, (ValaExpression*) _tmp240_);
								_vala_code_node_unref0 (_tmp240_);
								_tmp241_ = inner_ma;
								_tmp242_ = vala_member_access_get_inner (_tmp241_);
								_tmp243_ = _tmp242_;
								inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp243_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
								_tmp244_ = inner_sym;
								_tmp245_ = vala_symbol_get_parent_symbol (_tmp244_);
								_tmp246_ = _tmp245_;
								inner_sym = _tmp246_;
							}
							_tmp247_ = inner_ma;
							vala_member_access_set_qualified (_tmp247_, TRUE);
							_tmp248_ = vala_member_access_get_inner (self);
							_tmp249_ = _tmp248_;
							vala_code_node_check ((ValaCodeNode*) _tmp249_, context);
							_tmp250_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp250_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
				}
			}
		} else {
			ValaExpression* _tmp251_;
			ValaExpression* _tmp252_;
			gboolean _tmp253_;
			gboolean _tmp254_;
			ValaExpression* _tmp255_;
			ValaExpression* _tmp256_;
			ValaDataType* _tmp257_;
			ValaDataType* _tmp258_;
			gboolean _tmp289_ = FALSE;
			ValaExpression* _tmp290_;
			ValaExpression* _tmp291_;
			ValaDataType* _tmp292_;
			ValaDataType* _tmp293_;
			ValaExpression* _tmp299_;
			ValaExpression* _tmp300_;
			gboolean _tmp313_ = FALSE;
			ValaExpression* _tmp314_;
			ValaExpression* _tmp315_;
			gboolean _tmp322_ = FALSE;
			ValaExpression* _tmp323_;
			ValaExpression* _tmp324_;
			gboolean _tmp345_ = FALSE;
			ValaExpression* _tmp346_;
			ValaExpression* _tmp347_;
			gboolean _tmp362_ = FALSE;
			ValaSymbol* _tmp363_;
			ValaSymbol* _tmp364_;
			gboolean _tmp398_ = FALSE;
			gboolean _tmp399_ = FALSE;
			ValaSymbol* _tmp400_;
			ValaSymbol* _tmp401_;
			ValaSymbol* _tmp687_;
			ValaSymbol* _tmp688_;
			_tmp251_ = vala_member_access_get_inner (self);
			_tmp252_ = _tmp251_;
			_tmp253_ = vala_code_node_get_error ((ValaCodeNode*) _tmp252_);
			_tmp254_ = _tmp253_;
			if (_tmp254_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
			_tmp255_ = vala_member_access_get_inner (self);
			_tmp256_ = _tmp255_;
			_tmp257_ = vala_expression_get_value_type (_tmp256_);
			_tmp258_ = _tmp257_;
			if (VALA_IS_POINTER_TYPE (_tmp258_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp259_;
				ValaExpression* _tmp260_;
				ValaDataType* _tmp261_;
				ValaDataType* _tmp262_;
				gboolean _tmp263_ = FALSE;
				ValaPointerType* _tmp264_;
				_tmp259_ = vala_member_access_get_inner (self);
				_tmp260_ = _tmp259_;
				_tmp261_ = vala_expression_get_value_type (_tmp260_);
				_tmp262_ = _tmp261_;
				pointer_type = VALA_IS_POINTER_TYPE (_tmp262_) ? ((ValaPointerType*) _tmp262_) : NULL;
				_tmp264_ = pointer_type;
				if (_tmp264_ != NULL) {
					ValaPointerType* _tmp265_;
					ValaDataType* _tmp266_;
					ValaDataType* _tmp267_;
					_tmp265_ = pointer_type;
					_tmp266_ = vala_pointer_type_get_base_type (_tmp265_);
					_tmp267_ = _tmp266_;
					_tmp263_ = VALA_IS_VALUE_TYPE (_tmp267_);
				} else {
					_tmp263_ = FALSE;
				}
				if (_tmp263_) {
					ValaExpression* _tmp268_;
					ValaExpression* _tmp269_;
					ValaDataType* _tmp270_;
					ValaDataType* _tmp271_;
					ValaExpression* _tmp281_;
					ValaExpression* _tmp282_;
					ValaSourceReference* _tmp283_;
					ValaSourceReference* _tmp284_;
					ValaPointerIndirection* _tmp285_;
					ValaPointerIndirection* _tmp286_;
					ValaExpression* _tmp287_;
					ValaExpression* _tmp288_;
					_tmp268_ = vala_member_access_get_inner (self);
					_tmp269_ = _tmp268_;
					_tmp270_ = vala_expression_get_formal_value_type (_tmp269_);
					_tmp271_ = _tmp270_;
					if (VALA_IS_GENERIC_TYPE (_tmp271_)) {
						ValaExpression* _tmp272_;
						ValaExpression* _tmp273_;
						ValaPointerType* _tmp274_;
						ValaDataType* _tmp275_;
						ValaDataType* _tmp276_;
						ValaSourceReference* _tmp277_;
						ValaSourceReference* _tmp278_;
						ValaCastExpression* _tmp279_;
						ValaCastExpression* _tmp280_;
						_tmp272_ = vala_member_access_get_inner (self);
						_tmp273_ = _tmp272_;
						_tmp274_ = pointer_type;
						_tmp275_ = vala_data_type_copy ((ValaDataType*) _tmp274_);
						_tmp276_ = _tmp275_;
						_tmp277_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp278_ = _tmp277_;
						_tmp279_ = vala_cast_expression_new (_tmp273_, _tmp276_, _tmp278_);
						_tmp280_ = _tmp279_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp280_);
						_vala_code_node_unref0 (_tmp280_);
						_vala_code_node_unref0 (_tmp276_);
					}
					_tmp281_ = vala_member_access_get_inner (self);
					_tmp282_ = _tmp281_;
					_tmp283_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp284_ = _tmp283_;
					_tmp285_ = vala_pointer_indirection_new (_tmp282_, _tmp284_);
					_tmp286_ = _tmp285_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp286_);
					_vala_code_node_unref0 (_tmp286_);
					_tmp287_ = vala_member_access_get_inner (self);
					_tmp288_ = _tmp287_;
					vala_code_node_check ((ValaCodeNode*) _tmp288_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
			}
			_tmp290_ = vala_member_access_get_inner (self);
			_tmp291_ = _tmp290_;
			_tmp292_ = vala_expression_get_value_type (_tmp291_);
			_tmp293_ = _tmp292_;
			if (VALA_IS_SIGNAL_TYPE (_tmp293_)) {
				const gchar* _tmp294_;
				_tmp294_ = self->priv->_member_name;
				_tmp289_ = g_strcmp0 (_tmp294_, "emit") == 0;
			} else {
				_tmp289_ = FALSE;
			}
			if (_tmp289_) {
				ValaCodeNode* _tmp295_;
				ValaCodeNode* _tmp296_;
				ValaExpression* _tmp297_;
				ValaExpression* _tmp298_;
				_tmp295_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp296_ = _tmp295_;
				_tmp297_ = vala_member_access_get_inner (self);
				_tmp298_ = _tmp297_;
				vala_code_node_replace_expression (_tmp296_, (ValaExpression*) self, _tmp298_);
				result = TRUE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
			_tmp299_ = vala_member_access_get_inner (self);
			_tmp300_ = _tmp299_;
			if (VALA_IS_MEMBER_ACCESS (_tmp300_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp301_;
				ValaExpression* _tmp302_;
				ValaMemberAccess* _tmp303_;
				gboolean _tmp304_;
				_tmp301_ = vala_member_access_get_inner (self);
				_tmp302_ = _tmp301_;
				ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp302_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
				_tmp303_ = ma;
				_tmp304_ = _tmp303_->priv->_prototype_access;
				if (_tmp304_) {
					ValaSourceReference* _tmp305_;
					ValaSourceReference* _tmp306_;
					ValaExpression* _tmp307_;
					ValaExpression* _tmp308_;
					ValaSymbol* _tmp309_;
					ValaSymbol* _tmp310_;
					gchar* _tmp311_;
					gchar* _tmp312_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp305_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp306_ = _tmp305_;
					_tmp307_ = vala_member_access_get_inner (self);
					_tmp308_ = _tmp307_;
					_tmp309_ = vala_expression_get_symbol_reference (_tmp308_);
					_tmp310_ = _tmp309_;
					_tmp311_ = vala_symbol_get_full_name (_tmp310_);
					_tmp312_ = _tmp311_;
					vala_report_error (_tmp306_, "Access to instance member `%s' denied", _tmp312_);
					_g_free0 (_tmp312_);
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
			}
			_tmp314_ = vala_member_access_get_inner (self);
			_tmp315_ = _tmp314_;
			if (VALA_IS_CAST_EXPRESSION (_tmp315_)) {
				ValaExpression* _tmp316_;
				ValaExpression* _tmp317_;
				gboolean _tmp318_;
				gboolean _tmp319_;
				_tmp316_ = vala_member_access_get_inner (self);
				_tmp317_ = _tmp316_;
				_tmp318_ = vala_cast_expression_get_is_silent_cast (G_TYPE_CHECK_INSTANCE_CAST (_tmp317_, VALA_TYPE_CAST_EXPRESSION, ValaCastExpression));
				_tmp319_ = _tmp318_;
				_tmp313_ = _tmp319_;
			} else {
				_tmp313_ = FALSE;
			}
			if (_tmp313_) {
				ValaSourceReference* _tmp320_;
				ValaSourceReference* _tmp321_;
				_tmp320_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp321_ = _tmp320_;
				vala_report_warning (_tmp321_, "Access to possible `null'. Perform a check or use an unsafe cast.");
			}
			_tmp323_ = vala_member_access_get_inner (self);
			_tmp324_ = _tmp323_;
			if (VALA_IS_MEMBER_ACCESS (_tmp324_)) {
				_tmp322_ = TRUE;
			} else {
				ValaExpression* _tmp325_;
				ValaExpression* _tmp326_;
				_tmp325_ = vala_member_access_get_inner (self);
				_tmp326_ = _tmp325_;
				_tmp322_ = VALA_IS_BASE_ACCESS (_tmp326_);
			}
			if (_tmp322_) {
				ValaExpression* _tmp327_;
				ValaExpression* _tmp328_;
				ValaSymbol* _tmp329_;
				ValaSymbol* _tmp330_;
				gboolean _tmp331_ = FALSE;
				ValaSymbol* _tmp332_;
				ValaSymbol* _tmp333_;
				_tmp327_ = vala_member_access_get_inner (self);
				_tmp328_ = _tmp327_;
				_tmp329_ = vala_expression_get_symbol_reference (_tmp328_);
				_tmp330_ = _tmp329_;
				base_symbol = _tmp330_;
				_tmp332_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp333_ = _tmp332_;
				if (_tmp333_ == NULL) {
					gboolean _tmp334_ = FALSE;
					ValaSymbol* _tmp335_;
					_tmp335_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp335_)) {
						_tmp334_ = TRUE;
					} else {
						ValaSymbol* _tmp336_;
						_tmp336_ = base_symbol;
						_tmp334_ = VALA_IS_TYPESYMBOL (_tmp336_);
					}
					_tmp331_ = _tmp334_;
				} else {
					_tmp331_ = FALSE;
				}
				if (_tmp331_) {
					ValaSymbol* _tmp337_;
					ValaScope* _tmp338_;
					ValaScope* _tmp339_;
					const gchar* _tmp340_;
					ValaSymbol* _tmp341_;
					ValaSymbol* _tmp342_;
					ValaExpression* _tmp343_;
					ValaExpression* _tmp344_;
					_tmp337_ = base_symbol;
					_tmp338_ = vala_symbol_get_scope (_tmp337_);
					_tmp339_ = _tmp338_;
					_tmp340_ = self->priv->_member_name;
					_tmp341_ = vala_scope_lookup (_tmp339_, _tmp340_);
					_tmp342_ = _tmp341_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp342_);
					_vala_code_node_unref0 (_tmp342_);
					_tmp343_ = vala_member_access_get_inner (self);
					_tmp344_ = _tmp343_;
					if (VALA_IS_BASE_ACCESS (_tmp344_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp346_ = vala_member_access_get_inner (self);
			_tmp347_ = _tmp346_;
			if (VALA_IS_MEMBER_ACCESS (_tmp347_)) {
				ValaExpression* _tmp348_;
				ValaExpression* _tmp349_;
				ValaSymbol* _tmp350_;
				ValaSymbol* _tmp351_;
				_tmp348_ = vala_member_access_get_inner (self);
				_tmp349_ = _tmp348_;
				_tmp350_ = vala_expression_get_symbol_reference (_tmp349_);
				_tmp351_ = _tmp350_;
				_tmp345_ = VALA_IS_TYPEPARAMETER (_tmp351_);
			} else {
				_tmp345_ = FALSE;
			}
			if (_tmp345_) {
				ValaExpression* _tmp352_;
				ValaExpression* _tmp353_;
				ValaExpression* _tmp354_;
				ValaExpression* _tmp355_;
				ValaSymbol* _tmp356_;
				ValaSymbol* _tmp357_;
				ValaSourceReference* _tmp358_;
				ValaSourceReference* _tmp359_;
				ValaGenericType* _tmp360_;
				ValaGenericType* _tmp361_;
				_tmp352_ = vala_member_access_get_inner (self);
				_tmp353_ = _tmp352_;
				_tmp354_ = vala_member_access_get_inner (self);
				_tmp355_ = _tmp354_;
				_tmp356_ = vala_expression_get_symbol_reference (_tmp355_);
				_tmp357_ = _tmp356_;
				_tmp358_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp359_ = _tmp358_;
				_tmp360_ = vala_generic_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp357_, VALA_TYPE_TYPEPARAMETER, ValaTypeParameter), _tmp359_);
				_tmp361_ = _tmp360_;
				vala_expression_set_value_type (_tmp353_, (ValaDataType*) _tmp361_);
				_vala_code_node_unref0 (_tmp361_);
			}
			_tmp363_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp364_ = _tmp363_;
			if (_tmp364_ == NULL) {
				ValaExpression* _tmp365_;
				ValaExpression* _tmp366_;
				ValaDataType* _tmp367_;
				ValaDataType* _tmp368_;
				_tmp365_ = vala_member_access_get_inner (self);
				_tmp366_ = _tmp365_;
				_tmp367_ = vala_expression_get_value_type (_tmp366_);
				_tmp368_ = _tmp367_;
				_tmp362_ = _tmp368_ != NULL;
			} else {
				_tmp362_ = FALSE;
			}
			if (_tmp362_) {
				gboolean _tmp369_;
				ValaSymbol* _tmp396_;
				ValaSymbol* _tmp397_;
				_tmp369_ = self->priv->_pointer_member_access;
				if (_tmp369_) {
					ValaExpression* _tmp370_;
					ValaExpression* _tmp371_;
					ValaDataType* _tmp372_;
					ValaDataType* _tmp373_;
					const gchar* _tmp374_;
					ValaSymbol* _tmp375_;
					ValaSymbol* _tmp376_;
					_tmp370_ = vala_member_access_get_inner (self);
					_tmp371_ = _tmp370_;
					_tmp372_ = vala_expression_get_value_type (_tmp371_);
					_tmp373_ = _tmp372_;
					_tmp374_ = self->priv->_member_name;
					_tmp375_ = vala_data_type_get_pointer_member (_tmp373_, _tmp374_);
					_tmp376_ = _tmp375_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp376_);
					_vala_code_node_unref0 (_tmp376_);
				} else {
					ValaExpression* _tmp377_;
					ValaExpression* _tmp378_;
					ValaDataType* _tmp379_;
					ValaDataType* _tmp380_;
					ValaTypeSymbol* _tmp381_;
					ValaTypeSymbol* _tmp382_;
					ValaExpression* _tmp389_;
					ValaExpression* _tmp390_;
					ValaDataType* _tmp391_;
					ValaDataType* _tmp392_;
					const gchar* _tmp393_;
					ValaSymbol* _tmp394_;
					ValaSymbol* _tmp395_;
					_tmp377_ = vala_member_access_get_inner (self);
					_tmp378_ = _tmp377_;
					_tmp379_ = vala_expression_get_value_type (_tmp378_);
					_tmp380_ = _tmp379_;
					_tmp381_ = vala_data_type_get_type_symbol (_tmp380_);
					_tmp382_ = _tmp381_;
					if (_tmp382_ != NULL) {
						ValaExpression* _tmp383_;
						ValaExpression* _tmp384_;
						ValaDataType* _tmp385_;
						ValaDataType* _tmp386_;
						ValaTypeSymbol* _tmp387_;
						ValaTypeSymbol* _tmp388_;
						_tmp383_ = vala_member_access_get_inner (self);
						_tmp384_ = _tmp383_;
						_tmp385_ = vala_expression_get_value_type (_tmp384_);
						_tmp386_ = _tmp385_;
						_tmp387_ = vala_data_type_get_type_symbol (_tmp386_);
						_tmp388_ = _tmp387_;
						base_symbol = (ValaSymbol*) _tmp388_;
					}
					_tmp389_ = vala_member_access_get_inner (self);
					_tmp390_ = _tmp389_;
					_tmp391_ = vala_expression_get_value_type (_tmp390_);
					_tmp392_ = _tmp391_;
					_tmp393_ = self->priv->_member_name;
					_tmp394_ = vala_data_type_get_member (_tmp392_, _tmp393_);
					_tmp395_ = _tmp394_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp395_);
					_vala_code_node_unref0 (_tmp395_);
				}
				_tmp396_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp397_ = _tmp396_;
				if (_tmp397_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp400_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp401_ = _tmp400_;
			if (_tmp401_ == NULL) {
				ValaExpression* _tmp402_;
				ValaExpression* _tmp403_;
				ValaDataType* _tmp404_;
				ValaDataType* _tmp405_;
				_tmp402_ = vala_member_access_get_inner (self);
				_tmp403_ = _tmp402_;
				_tmp404_ = vala_expression_get_value_type (_tmp403_);
				_tmp405_ = _tmp404_;
				_tmp399_ = _tmp405_ != NULL;
			} else {
				_tmp399_ = FALSE;
			}
			if (_tmp399_) {
				ValaExpression* _tmp406_;
				ValaExpression* _tmp407_;
				ValaDataType* _tmp408_;
				ValaDataType* _tmp409_;
				gboolean _tmp410_;
				gboolean _tmp411_;
				_tmp406_ = vala_member_access_get_inner (self);
				_tmp407_ = _tmp406_;
				_tmp408_ = vala_expression_get_value_type (_tmp407_);
				_tmp409_ = _tmp408_;
				_tmp410_ = vala_data_type_get_is_dynamic (_tmp409_);
				_tmp411_ = _tmp410_;
				_tmp398_ = _tmp411_;
			} else {
				_tmp398_ = FALSE;
			}
			if (_tmp398_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp412_;
				ValaExpression* _tmp413_;
				ValaDataType* _tmp414_;
				ValaDataType* _tmp415_;
				ValaObjectType* _tmp416_;
				ValaCodeNode* _tmp417_;
				ValaCodeNode* _tmp418_;
				ValaSymbol* _tmp635_;
				ValaSymbol* _tmp636_;
				ValaSymbol* _tmp685_;
				ValaSymbol* _tmp686_;
				_tmp412_ = vala_member_access_get_inner (self);
				_tmp413_ = _tmp412_;
				_tmp414_ = vala_expression_get_value_type (_tmp413_);
				_tmp415_ = _tmp414_;
				_tmp416_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp415_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp416_;
				_tmp417_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp418_ = _tmp417_;
				if (VALA_IS_METHOD_CALL (_tmp418_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp419_;
					ValaCodeNode* _tmp420_;
					ValaMethodCall* _tmp421_;
					ValaExpression* _tmp422_;
					ValaExpression* _tmp423_;
					_tmp419_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp420_ = _tmp419_;
					invoc = G_TYPE_CHECK_INSTANCE_CAST (_tmp420_, VALA_TYPE_METHOD_CALL, ValaMethodCall);
					_tmp421_ = invoc;
					_tmp422_ = vala_method_call_get_call (_tmp421_);
					_tmp423_ = _tmp422_;
					if (_tmp423_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp424_;
						ValaDataType* _tmp425_;
						ValaDataType* _tmp426_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp441_;
						ValaExpression* _tmp442_;
						ValaDataType* _tmp443_;
						ValaDataType* _tmp444_;
						const gchar* _tmp445_;
						ValaDataType* _tmp446_;
						ValaSourceReference* _tmp447_;
						ValaSourceReference* _tmp448_;
						ValaDynamicMethod* _tmp449_;
						ValaDynamicMethod* _tmp450_;
						ValaMethodCall* _tmp451_;
						ValaErrorType* err = NULL;
						ValaDynamicMethod* _tmp452_;
						ValaSourceReference* _tmp453_;
						ValaSourceReference* _tmp454_;
						ValaErrorType* _tmp455_;
						ValaErrorType* _tmp456_;
						ValaDynamicMethod* _tmp457_;
						ValaErrorType* _tmp458_;
						ValaDynamicMethod* _tmp459_;
						ValaDynamicMethod* _tmp460_;
						ValaParameter* _tmp461_;
						ValaParameter* _tmp462_;
						ValaDynamicMethod* _tmp463_;
						ValaObjectType* _tmp464_;
						ValaDataType* _tmp465_;
						ValaDataType* _tmp466_;
						ValaDynamicMethod* _tmp467_;
						ValaSourceReference* _tmp468_;
						ValaSourceReference* _tmp469_;
						ValaParameter* _tmp470_;
						ValaParameter* _tmp471_;
						ValaObjectType* _tmp472_;
						ValaTypeSymbol* _tmp473_;
						ValaTypeSymbol* _tmp474_;
						ValaScope* _tmp475_;
						ValaScope* _tmp476_;
						ValaDynamicMethod* _tmp477_;
						ValaDynamicMethod* _tmp478_;
						_tmp424_ = invoc;
						_tmp425_ = vala_expression_get_target_type ((ValaExpression*) _tmp424_);
						_tmp426_ = _tmp425_;
						if (_tmp426_ != NULL) {
							ValaMethodCall* _tmp427_;
							ValaDataType* _tmp428_;
							ValaDataType* _tmp429_;
							ValaDataType* _tmp430_;
							ValaDataType* _tmp431_;
							_tmp427_ = invoc;
							_tmp428_ = vala_expression_get_target_type ((ValaExpression*) _tmp427_);
							_tmp429_ = _tmp428_;
							_tmp430_ = vala_data_type_copy (_tmp429_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp430_;
							_tmp431_ = ret_type;
							vala_data_type_set_value_owned (_tmp431_, TRUE);
						} else {
							ValaMethodCall* _tmp432_;
							ValaCodeNode* _tmp433_;
							ValaCodeNode* _tmp434_;
							_tmp432_ = invoc;
							_tmp433_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp432_);
							_tmp434_ = _tmp433_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp434_)) {
								ValaVoidType* _tmp435_;
								_tmp435_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp435_;
							} else {
								ValaExpression* _tmp436_;
								ValaExpression* _tmp437_;
								ValaDataType* _tmp438_;
								ValaDataType* _tmp439_;
								ValaDataType* _tmp440_;
								_tmp436_ = vala_member_access_get_inner (self);
								_tmp437_ = _tmp436_;
								_tmp438_ = vala_expression_get_value_type (_tmp437_);
								_tmp439_ = _tmp438_;
								_tmp440_ = vala_data_type_copy (_tmp439_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp440_;
							}
						}
						_tmp441_ = vala_member_access_get_inner (self);
						_tmp442_ = _tmp441_;
						_tmp443_ = vala_expression_get_value_type (_tmp442_);
						_tmp444_ = _tmp443_;
						_tmp445_ = self->priv->_member_name;
						_tmp446_ = ret_type;
						_tmp447_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp448_ = _tmp447_;
						_tmp449_ = vala_dynamic_method_new (_tmp444_, _tmp445_, _tmp446_, _tmp448_, NULL);
						m = _tmp449_;
						_tmp450_ = m;
						_tmp451_ = invoc;
						vala_dynamic_method_set_invocation (_tmp450_, _tmp451_);
						_tmp452_ = m;
						_tmp453_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp452_);
						_tmp454_ = _tmp453_;
						_tmp455_ = vala_error_type_new (NULL, NULL, _tmp454_);
						err = _tmp455_;
						_tmp456_ = err;
						vala_error_type_set_dynamic_error (_tmp456_, TRUE);
						_tmp457_ = m;
						_tmp458_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp457_, (ValaDataType*) _tmp458_);
						_tmp459_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp459_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp460_ = m;
						_tmp461_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp462_ = _tmp461_;
						vala_callable_add_parameter ((ValaCallable*) _tmp460_, _tmp462_);
						_vala_code_node_unref0 (_tmp462_);
						_tmp463_ = m;
						_tmp464_ = dynamic_object_type;
						_tmp465_ = vala_data_type_copy ((ValaDataType*) _tmp464_);
						_tmp466_ = _tmp465_;
						_tmp467_ = m;
						_tmp468_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp467_);
						_tmp469_ = _tmp468_;
						_tmp470_ = vala_parameter_new ("this", _tmp466_, _tmp469_);
						_tmp471_ = _tmp470_;
						vala_method_set_this_parameter ((ValaMethod*) _tmp463_, _tmp471_);
						_vala_code_node_unref0 (_tmp471_);
						_vala_code_node_unref0 (_tmp466_);
						_tmp472_ = dynamic_object_type;
						_tmp473_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp472_);
						_tmp474_ = _tmp473_;
						_tmp475_ = vala_symbol_get_scope ((ValaSymbol*) _tmp474_);
						_tmp476_ = _tmp475_;
						_tmp477_ = m;
						vala_scope_add (_tmp476_, NULL, (ValaSymbol*) _tmp477_);
						_tmp478_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp478_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
				} else {
					ValaCodeNode* _tmp479_;
					ValaCodeNode* _tmp480_;
					_tmp479_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp480_ = _tmp479_;
					if (VALA_IS_ASSIGNMENT (_tmp480_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp481_;
						ValaCodeNode* _tmp482_;
						ValaAssignment* _tmp483_;
						ValaExpression* _tmp484_;
						ValaExpression* _tmp485_;
						_tmp481_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp482_ = _tmp481_;
						a = G_TYPE_CHECK_INSTANCE_CAST (_tmp482_, VALA_TYPE_ASSIGNMENT, ValaAssignment);
						_tmp483_ = a;
						_tmp484_ = vala_assignment_get_left (_tmp483_);
						_tmp485_ = _tmp484_;
						if (_tmp485_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							ValaDynamicProperty* prop = NULL;
							ValaExpression* _tmp486_;
							ValaExpression* _tmp487_;
							ValaDataType* _tmp488_;
							ValaDataType* _tmp489_;
							const gchar* _tmp490_;
							ValaSourceReference* _tmp491_;
							ValaSourceReference* _tmp492_;
							ValaDynamicProperty* _tmp493_;
							ValaDynamicProperty* _tmp494_;
							ValaDynamicProperty* _tmp495_;
							ValaDynamicProperty* _tmp496_;
							ValaSourceReference* _tmp497_;
							ValaSourceReference* _tmp498_;
							ValaPropertyAccessor* _tmp499_;
							ValaPropertyAccessor* _tmp500_;
							ValaDynamicProperty* _tmp501_;
							ValaExpression* _tmp502_;
							ValaExpression* _tmp503_;
							ValaDataType* _tmp504_;
							ValaDataType* _tmp505_;
							ValaTypeSymbol* _tmp506_;
							ValaTypeSymbol* _tmp507_;
							ValaScope* _tmp508_;
							ValaScope* _tmp509_;
							ValaObjectType* _tmp510_;
							ValaTypeSymbol* _tmp511_;
							ValaTypeSymbol* _tmp512_;
							ValaScope* _tmp513_;
							ValaScope* _tmp514_;
							ValaDynamicProperty* _tmp515_;
							ValaDynamicProperty* _tmp516_;
							_tmp486_ = vala_member_access_get_inner (self);
							_tmp487_ = _tmp486_;
							_tmp488_ = vala_expression_get_value_type (_tmp487_);
							_tmp489_ = _tmp488_;
							_tmp490_ = self->priv->_member_name;
							_tmp491_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp492_ = _tmp491_;
							_tmp493_ = vala_dynamic_property_new (_tmp489_, _tmp490_, _tmp492_, NULL);
							prop = _tmp493_;
							_tmp494_ = prop;
							vala_symbol_set_access ((ValaSymbol*) _tmp494_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp495_ = prop;
							_tmp496_ = prop;
							_tmp497_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp496_);
							_tmp498_ = _tmp497_;
							_tmp499_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp498_, NULL);
							_tmp500_ = _tmp499_;
							vala_property_set_set_accessor ((ValaProperty*) _tmp495_, _tmp500_);
							_vala_code_node_unref0 (_tmp500_);
							_tmp501_ = prop;
							_tmp502_ = vala_member_access_get_inner (self);
							_tmp503_ = _tmp502_;
							_tmp504_ = vala_expression_get_value_type (_tmp503_);
							_tmp505_ = _tmp504_;
							_tmp506_ = vala_data_type_get_type_symbol (_tmp505_);
							_tmp507_ = _tmp506_;
							_tmp508_ = vala_symbol_get_scope ((ValaSymbol*) _tmp507_);
							_tmp509_ = _tmp508_;
							vala_symbol_set_owner ((ValaSymbol*) _tmp501_, _tmp509_);
							_tmp510_ = dynamic_object_type;
							_tmp511_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp510_);
							_tmp512_ = _tmp511_;
							_tmp513_ = vala_symbol_get_scope ((ValaSymbol*) _tmp512_);
							_tmp514_ = _tmp513_;
							_tmp515_ = prop;
							vala_scope_add (_tmp514_, NULL, (ValaSymbol*) _tmp515_);
							_tmp516_ = prop;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp516_);
							_vala_code_node_unref0 (prop);
						}
					} else {
						gboolean _tmp517_ = FALSE;
						gboolean _tmp518_ = FALSE;
						ValaCodeNode* _tmp519_;
						ValaCodeNode* _tmp520_;
						_tmp519_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp520_ = _tmp519_;
						if (VALA_IS_MEMBER_ACCESS (_tmp520_)) {
							ValaExpression* _tmp521_;
							ValaExpression* _tmp522_;
							_tmp521_ = vala_member_access_get_inner (self);
							_tmp522_ = _tmp521_;
							_tmp518_ = VALA_IS_MEMBER_ACCESS (_tmp522_);
						} else {
							_tmp518_ = FALSE;
						}
						if (_tmp518_) {
							ValaCodeNode* _tmp523_;
							ValaCodeNode* _tmp524_;
							ValaCodeNode* _tmp525_;
							ValaCodeNode* _tmp526_;
							_tmp523_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp524_ = _tmp523_;
							_tmp525_ = vala_code_node_get_parent_node (_tmp524_);
							_tmp526_ = _tmp525_;
							_tmp517_ = VALA_IS_METHOD_CALL (_tmp526_);
						} else {
							_tmp517_ = FALSE;
						}
						if (_tmp517_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp527_;
							ValaCodeNode* _tmp528_;
							gboolean _tmp529_ = FALSE;
							ValaMemberAccess* _tmp530_;
							const gchar* _tmp531_;
							_tmp527_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp528_ = _tmp527_;
							ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp528_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
							_tmp530_ = ma;
							_tmp531_ = _tmp530_->priv->_member_name;
							if (g_strcmp0 (_tmp531_, "connect") == 0) {
								_tmp529_ = TRUE;
							} else {
								ValaMemberAccess* _tmp532_;
								const gchar* _tmp533_;
								_tmp532_ = ma;
								_tmp533_ = _tmp532_->priv->_member_name;
								_tmp529_ = g_strcmp0 (_tmp533_, "connect_after") == 0;
							}
							if (_tmp529_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp534_;
								ValaExpression* _tmp535_;
								ValaDataType* _tmp536_;
								ValaDataType* _tmp537_;
								const gchar* _tmp538_;
								ValaVoidType* _tmp539_;
								ValaVoidType* _tmp540_;
								ValaSourceReference* _tmp541_;
								ValaSourceReference* _tmp542_;
								ValaDynamicSignal* _tmp543_;
								ValaDynamicSignal* _tmp544_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp545_;
								ValaCodeNode* _tmp546_;
								ValaCodeNode* _tmp547_;
								ValaCodeNode* _tmp548_;
								ValaMethodCall* _tmp549_;
								ValaMethodCall* _tmp550_;
								ValaList* _tmp551_;
								gint _tmp552_;
								gint _tmp553_;
								ValaDynamicSignal* _tmp585_;
								ValaObjectType* _tmp586_;
								ValaTypeSymbol* _tmp587_;
								ValaTypeSymbol* _tmp588_;
								ValaScope* _tmp589_;
								ValaScope* _tmp590_;
								ValaDynamicSignal* _tmp591_;
								ValaDynamicSignal* _tmp592_;
								_tmp534_ = vala_member_access_get_inner (self);
								_tmp535_ = _tmp534_;
								_tmp536_ = vala_expression_get_value_type (_tmp535_);
								_tmp537_ = _tmp536_;
								_tmp538_ = self->priv->_member_name;
								_tmp539_ = vala_void_type_new (NULL);
								_tmp540_ = _tmp539_;
								_tmp541_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp542_ = _tmp541_;
								_tmp543_ = vala_dynamic_signal_new (_tmp537_, _tmp538_, (ValaDataType*) _tmp540_, _tmp542_, NULL);
								_tmp544_ = _tmp543_;
								_vala_code_node_unref0 (_tmp540_);
								s = _tmp544_;
								_tmp545_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp546_ = _tmp545_;
								_tmp547_ = vala_code_node_get_parent_node (_tmp546_);
								_tmp548_ = _tmp547_;
								_tmp549_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp548_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp549_;
								_tmp550_ = mcall;
								_tmp551_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) _tmp550_);
								_tmp552_ = vala_collection_get_size ((ValaCollection*) _tmp551_);
								_tmp553_ = _tmp552_;
								if (_tmp553_ > 0) {
									ValaDynamicSignal* _tmp554_;
									ValaMethodCall* _tmp555_;
									ValaList* _tmp556_;
									gpointer _tmp557_;
									ValaExpression* _tmp558_;
									ValaMemberAccess* arg = NULL;
									ValaDynamicSignal* _tmp559_;
									ValaExpression* _tmp560_;
									ValaExpression* _tmp561_;
									gboolean _tmp562_ = FALSE;
									gboolean _tmp563_ = FALSE;
									ValaMemberAccess* _tmp564_;
									_tmp554_ = s;
									_tmp555_ = mcall;
									_tmp556_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) _tmp555_);
									_tmp557_ = vala_list_get (_tmp556_, 0);
									_tmp558_ = (ValaExpression*) _tmp557_;
									vala_dynamic_signal_set_handler (_tmp554_, _tmp558_);
									_vala_code_node_unref0 (_tmp558_);
									_tmp559_ = s;
									_tmp560_ = vala_dynamic_signal_get_handler (_tmp559_);
									_tmp561_ = _tmp560_;
									arg = VALA_IS_MEMBER_ACCESS (_tmp561_) ? ((ValaMemberAccess*) _tmp561_) : NULL;
									_tmp564_ = arg;
									if (_tmp564_ == NULL) {
										_tmp563_ = TRUE;
									} else {
										ValaMemberAccess* _tmp565_;
										_tmp565_ = arg;
										_tmp563_ = !vala_code_node_check ((ValaCodeNode*) _tmp565_, context);
									}
									if (_tmp563_) {
										_tmp562_ = TRUE;
									} else {
										ValaMemberAccess* _tmp566_;
										ValaSymbol* _tmp567_;
										ValaSymbol* _tmp568_;
										_tmp566_ = arg;
										_tmp567_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp566_);
										_tmp568_ = _tmp567_;
										_tmp562_ = !VALA_IS_METHOD (_tmp568_);
									}
									if (_tmp562_) {
										ValaDynamicSignal* _tmp569_;
										ValaExpression* _tmp570_;
										ValaExpression* _tmp571_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp569_ = s;
										_tmp570_ = vala_dynamic_signal_get_handler (_tmp569_);
										_tmp571_ = _tmp570_;
										if (VALA_IS_LAMBDA_EXPRESSION (_tmp571_)) {
											ValaDynamicSignal* _tmp572_;
											ValaExpression* _tmp573_;
											ValaExpression* _tmp574_;
											ValaSourceReference* _tmp575_;
											ValaSourceReference* _tmp576_;
											_tmp572_ = s;
											_tmp573_ = vala_dynamic_signal_get_handler (_tmp572_);
											_tmp574_ = _tmp573_;
											_tmp575_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp574_);
											_tmp576_ = _tmp575_;
											vala_report_error (_tmp576_, "Lambdas are not allowed for dynamic signals");
										} else {
											ValaDynamicSignal* _tmp577_;
											ValaExpression* _tmp578_;
											ValaExpression* _tmp579_;
											ValaSourceReference* _tmp580_;
											ValaSourceReference* _tmp581_;
											ValaDynamicSignal* _tmp582_;
											gchar* _tmp583_;
											gchar* _tmp584_;
											_tmp577_ = s;
											_tmp578_ = vala_dynamic_signal_get_handler (_tmp577_);
											_tmp579_ = _tmp578_;
											_tmp580_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp579_);
											_tmp581_ = _tmp580_;
											_tmp582_ = s;
											_tmp583_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp582_);
											_tmp584_ = _tmp583_;
											vala_report_error (_tmp581_, "Cannot infer call signature for dynamic signal `%s' from given express" \
"ion", _tmp584_);
											_g_free0 (_tmp584_);
										}
									}
								}
								_tmp585_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp585_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp586_ = dynamic_object_type;
								_tmp587_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp586_);
								_tmp588_ = _tmp587_;
								_tmp589_ = vala_symbol_get_scope ((ValaSymbol*) _tmp588_);
								_tmp590_ = _tmp589_;
								_tmp591_ = s;
								vala_scope_add (_tmp590_, NULL, (ValaSymbol*) _tmp591_);
								_tmp592_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp592_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							} else {
								ValaMemberAccess* _tmp593_;
								const gchar* _tmp594_;
								_tmp593_ = ma;
								_tmp594_ = _tmp593_->priv->_member_name;
								if (g_strcmp0 (_tmp594_, "emit") == 0) {
									ValaMethodCall* mcall = NULL;
									ValaMemberAccess* _tmp595_;
									ValaCodeNode* _tmp596_;
									ValaCodeNode* _tmp597_;
									ValaDataType* _tmp598_ = NULL;
									ValaMethodCall* _tmp599_;
									ValaDataType* _tmp600_;
									ValaDataType* _tmp601_;
									ValaDataType* _tmp602_;
									ValaDataType* return_type = NULL;
									ValaDataType* _tmp604_;
									ValaDataType* _tmp605_;
									ValaDynamicSignal* s = NULL;
									ValaExpression* _tmp610_;
									ValaExpression* _tmp611_;
									ValaDataType* _tmp612_;
									ValaDataType* _tmp613_;
									const gchar* _tmp614_;
									ValaDataType* _tmp615_;
									ValaSourceReference* _tmp616_;
									ValaSourceReference* _tmp617_;
									ValaDynamicSignal* _tmp618_;
									ValaDynamicSignal* _tmp619_;
									ValaDynamicSignal* _tmp620_;
									ValaParameter* _tmp621_;
									ValaParameter* _tmp622_;
									ValaObjectType* _tmp623_;
									ValaTypeSymbol* _tmp624_;
									ValaTypeSymbol* _tmp625_;
									ValaScope* _tmp626_;
									ValaScope* _tmp627_;
									ValaDynamicSignal* _tmp628_;
									ValaDynamicSignal* _tmp629_;
									_tmp595_ = ma;
									_tmp596_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp595_);
									_tmp597_ = _tmp596_;
									mcall = G_TYPE_CHECK_INSTANCE_CAST (_tmp597_, VALA_TYPE_METHOD_CALL, ValaMethodCall);
									_tmp599_ = mcall;
									_tmp600_ = vala_expression_get_target_type ((ValaExpression*) _tmp599_);
									_tmp601_ = _tmp600_;
									_tmp602_ = _vala_code_node_ref0 (_tmp601_);
									_tmp598_ = _tmp602_;
									if (_tmp598_ == NULL) {
										ValaVoidType* _tmp603_;
										_tmp603_ = vala_void_type_new (NULL);
										_vala_code_node_unref0 (_tmp598_);
										_tmp598_ = (ValaDataType*) _tmp603_;
									}
									_tmp604_ = _tmp598_;
									_tmp598_ = NULL;
									return_type = _tmp604_;
									_tmp605_ = return_type;
									if (VALA_IS_VAR_TYPE (_tmp605_)) {
										ValaMethodCall* _tmp606_;
										ValaSourceReference* _tmp607_;
										ValaSourceReference* _tmp608_;
										const gchar* _tmp609_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp606_ = mcall;
										_tmp607_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp606_);
										_tmp608_ = _tmp607_;
										_tmp609_ = self->priv->_member_name;
										vala_report_error (_tmp608_, "Cannot infer return type for dynamic signal `%s' from given context", _tmp609_);
									}
									_tmp610_ = vala_member_access_get_inner (self);
									_tmp611_ = _tmp610_;
									_tmp612_ = vala_expression_get_value_type (_tmp611_);
									_tmp613_ = _tmp612_;
									_tmp614_ = self->priv->_member_name;
									_tmp615_ = return_type;
									_tmp616_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp617_ = _tmp616_;
									_tmp618_ = vala_dynamic_signal_new (_tmp613_, _tmp614_, _tmp615_, _tmp617_, NULL);
									s = _tmp618_;
									_tmp619_ = s;
									vala_symbol_set_access ((ValaSymbol*) _tmp619_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
									_tmp620_ = s;
									_tmp621_ = vala_parameter_new_with_ellipsis (NULL);
									_tmp622_ = _tmp621_;
									vala_callable_add_parameter ((ValaCallable*) _tmp620_, _tmp622_);
									_vala_code_node_unref0 (_tmp622_);
									_tmp623_ = dynamic_object_type;
									_tmp624_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp623_);
									_tmp625_ = _tmp624_;
									_tmp626_ = vala_symbol_get_scope ((ValaSymbol*) _tmp625_);
									_tmp627_ = _tmp626_;
									_tmp628_ = s;
									vala_scope_add (_tmp627_, NULL, (ValaSymbol*) _tmp628_);
									_tmp629_ = s;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp629_);
									_vala_code_node_unref0 (s);
									_vala_code_node_unref0 (return_type);
									_vala_code_node_unref0 (_tmp598_);
								} else {
									ValaMemberAccess* _tmp630_;
									const gchar* _tmp631_;
									_tmp630_ = ma;
									_tmp631_ = _tmp630_->priv->_member_name;
									if (g_strcmp0 (_tmp631_, "disconnect") == 0) {
										ValaMemberAccess* _tmp632_;
										ValaSourceReference* _tmp633_;
										ValaSourceReference* _tmp634_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp632_ = ma;
										_tmp633_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp632_);
										_tmp634_ = _tmp633_;
										vala_report_error (_tmp634_, "Use SignalHandler.disconnect() to disconnect from dynamic signal");
									}
								}
							}
						}
					}
				}
				_tmp635_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp636_ = _tmp635_;
				if (_tmp636_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp637_;
					ValaExpression* _tmp638_;
					ValaDataType* _tmp639_;
					ValaDataType* _tmp640_;
					const gchar* _tmp641_;
					ValaSourceReference* _tmp642_;
					ValaSourceReference* _tmp643_;
					ValaDynamicProperty* _tmp644_;
					ValaDataType* _tmp645_;
					ValaDataType* _tmp646_;
					ValaDynamicProperty* _tmp657_;
					ValaDynamicProperty* _tmp658_;
					ValaDynamicProperty* _tmp659_;
					ValaDataType* _tmp660_;
					ValaDataType* _tmp661_;
					ValaDataType* _tmp662_;
					ValaDataType* _tmp663_;
					ValaDynamicProperty* _tmp664_;
					ValaSourceReference* _tmp665_;
					ValaSourceReference* _tmp666_;
					ValaPropertyAccessor* _tmp667_;
					ValaPropertyAccessor* _tmp668_;
					ValaDynamicProperty* _tmp669_;
					ValaExpression* _tmp670_;
					ValaExpression* _tmp671_;
					ValaDataType* _tmp672_;
					ValaDataType* _tmp673_;
					ValaTypeSymbol* _tmp674_;
					ValaTypeSymbol* _tmp675_;
					ValaScope* _tmp676_;
					ValaScope* _tmp677_;
					ValaObjectType* _tmp678_;
					ValaTypeSymbol* _tmp679_;
					ValaTypeSymbol* _tmp680_;
					ValaScope* _tmp681_;
					ValaScope* _tmp682_;
					ValaDynamicProperty* _tmp683_;
					ValaDynamicProperty* _tmp684_;
					_tmp637_ = vala_member_access_get_inner (self);
					_tmp638_ = _tmp637_;
					_tmp639_ = vala_expression_get_value_type (_tmp638_);
					_tmp640_ = _tmp639_;
					_tmp641_ = self->priv->_member_name;
					_tmp642_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp643_ = _tmp642_;
					_tmp644_ = vala_dynamic_property_new (_tmp640_, _tmp641_, _tmp643_, NULL);
					prop = _tmp644_;
					_tmp645_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp646_ = _tmp645_;
					if (_tmp646_ != NULL) {
						ValaDynamicProperty* _tmp647_;
						ValaDataType* _tmp648_;
						ValaDataType* _tmp649_;
						_tmp647_ = prop;
						_tmp648_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp649_ = _tmp648_;
						vala_property_set_property_type ((ValaProperty*) _tmp647_, _tmp649_);
					} else {
						ValaDynamicProperty* _tmp650_;
						ValaExpression* _tmp651_;
						ValaExpression* _tmp652_;
						ValaDataType* _tmp653_;
						ValaDataType* _tmp654_;
						ValaDataType* _tmp655_;
						ValaDataType* _tmp656_;
						_tmp650_ = prop;
						_tmp651_ = vala_member_access_get_inner (self);
						_tmp652_ = _tmp651_;
						_tmp653_ = vala_expression_get_value_type (_tmp652_);
						_tmp654_ = _tmp653_;
						_tmp655_ = vala_data_type_copy (_tmp654_);
						_tmp656_ = _tmp655_;
						vala_property_set_property_type ((ValaProperty*) _tmp650_, _tmp656_);
						_vala_code_node_unref0 (_tmp656_);
					}
					_tmp657_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp657_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp658_ = prop;
					_tmp659_ = prop;
					_tmp660_ = vala_property_get_property_type ((ValaProperty*) _tmp659_);
					_tmp661_ = _tmp660_;
					_tmp662_ = vala_data_type_copy (_tmp661_);
					_tmp663_ = _tmp662_;
					_tmp664_ = prop;
					_tmp665_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp664_);
					_tmp666_ = _tmp665_;
					_tmp667_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp663_, NULL, _tmp666_, NULL);
					_tmp668_ = _tmp667_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp658_, _tmp668_);
					_vala_code_node_unref0 (_tmp668_);
					_vala_code_node_unref0 (_tmp663_);
					_tmp669_ = prop;
					_tmp670_ = vala_member_access_get_inner (self);
					_tmp671_ = _tmp670_;
					_tmp672_ = vala_expression_get_value_type (_tmp671_);
					_tmp673_ = _tmp672_;
					_tmp674_ = vala_data_type_get_type_symbol (_tmp673_);
					_tmp675_ = _tmp674_;
					_tmp676_ = vala_symbol_get_scope ((ValaSymbol*) _tmp675_);
					_tmp677_ = _tmp676_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp669_, _tmp677_);
					_tmp678_ = dynamic_object_type;
					_tmp679_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp678_);
					_tmp680_ = _tmp679_;
					_tmp681_ = vala_symbol_get_scope ((ValaSymbol*) _tmp680_);
					_tmp682_ = _tmp681_;
					_tmp683_ = prop;
					vala_scope_add (_tmp682_, NULL, (ValaSymbol*) _tmp683_);
					_tmp684_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp684_);
					_vala_code_node_unref0 (prop);
				}
				_tmp685_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp686_ = _tmp685_;
				if (_tmp686_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp687_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp688_ = _tmp687_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp688_)) {
				ValaExpression* _tmp689_;
				ValaExpression* _tmp690_;
				ValaSymbol* _tmp691_;
				ValaSymbol* _tmp692_;
				_tmp689_ = vala_member_access_get_inner (self);
				_tmp690_ = _tmp689_;
				_tmp691_ = vala_expression_get_symbol_reference (_tmp690_);
				_tmp692_ = _tmp691_;
				if (VALA_IS_VARIABLE (_tmp692_)) {
					ValaArrayType* inner_type = NULL;
					ValaSemanticAnalyzer* _tmp693_;
					ValaSemanticAnalyzer* _tmp694_;
					ValaExpression* _tmp695_;
					ValaExpression* _tmp696_;
					ValaSymbol* _tmp697_;
					ValaSymbol* _tmp698_;
					ValaDataType* _tmp699_;
					ValaArrayType* _tmp700_;
					gboolean _tmp701_ = FALSE;
					ValaArrayType* _tmp702_;
					_tmp693_ = vala_code_context_get_analyzer (context);
					_tmp694_ = _tmp693_;
					_tmp695_ = vala_member_access_get_inner (self);
					_tmp696_ = _tmp695_;
					_tmp697_ = vala_expression_get_symbol_reference (_tmp696_);
					_tmp698_ = _tmp697_;
					_tmp699_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp694_, _tmp698_, TRUE);
					_tmp700_ = VALA_IS_ARRAY_TYPE (_tmp699_) ? ((ValaArrayType*) _tmp699_) : NULL;
					if (_tmp700_ == NULL) {
						_vala_code_node_unref0 (_tmp699_);
					}
					inner_type = _tmp700_;
					_tmp702_ = inner_type;
					if (_tmp702_ != NULL) {
						ValaArrayType* _tmp703_;
						gboolean _tmp704_;
						gboolean _tmp705_;
						_tmp703_ = inner_type;
						_tmp704_ = vala_array_type_get_inline_allocated (_tmp703_);
						_tmp705_ = _tmp704_;
						_tmp701_ = _tmp705_;
					} else {
						_tmp701_ = FALSE;
					}
					if (_tmp701_) {
						ValaSourceReference* _tmp706_;
						ValaSourceReference* _tmp707_;
						_tmp706_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp707_ = _tmp706_;
						vala_report_error (_tmp707_, "`resize' is not supported for arrays with fixed length");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					} else {
						gboolean _tmp708_ = FALSE;
						ValaArrayType* _tmp709_;
						_tmp709_ = inner_type;
						if (_tmp709_ != NULL) {
							ValaArrayType* _tmp710_;
							gboolean _tmp711_;
							gboolean _tmp712_;
							_tmp710_ = inner_type;
							_tmp711_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp710_);
							_tmp712_ = _tmp711_;
							_tmp708_ = !_tmp712_;
						} else {
							_tmp708_ = FALSE;
						}
						if (_tmp708_) {
							ValaSourceReference* _tmp713_;
							ValaSourceReference* _tmp714_;
							_tmp713_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp714_ = _tmp713_;
							vala_report_error (_tmp714_, "`resize' is not allowed for unowned array references");
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						}
					}
					_vala_code_node_unref0 (inner_type);
				} else {
					ValaExpression* _tmp715_;
					ValaExpression* _tmp716_;
					ValaSymbol* _tmp717_;
					ValaSymbol* _tmp718_;
					_tmp715_ = vala_member_access_get_inner (self);
					_tmp716_ = _tmp715_;
					_tmp717_ = vala_expression_get_symbol_reference (_tmp716_);
					_tmp718_ = _tmp717_;
					if (VALA_IS_CONSTANT (_tmp718_)) {
						ValaSourceReference* _tmp719_;
						ValaSourceReference* _tmp720_;
						_tmp719_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp720_ = _tmp719_;
						vala_report_error (_tmp720_, "`resize' is not allowed for constant arrays");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
				}
			}
		}
	}
	_tmp724_ = vala_member_access_get_inner (self);
	_tmp725_ = _tmp724_;
	if (_tmp725_ == NULL) {
		ValaSymbol* _tmp726_;
		ValaSymbol* _tmp727_;
		_tmp726_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp727_ = _tmp726_;
		_tmp723_ = _tmp727_ == NULL;
	} else {
		_tmp723_ = FALSE;
	}
	if (_tmp723_) {
		ValaDataType* _tmp728_;
		ValaDataType* _tmp729_;
		_tmp728_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp729_ = _tmp728_;
		_tmp722_ = _tmp729_ != NULL;
	} else {
		_tmp722_ = FALSE;
	}
	if (_tmp722_) {
		ValaDataType* _tmp730_;
		ValaDataType* _tmp731_;
		ValaTypeSymbol* _tmp732_;
		ValaTypeSymbol* _tmp733_;
		_tmp730_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp731_ = _tmp730_;
		_tmp732_ = vala_data_type_get_type_symbol (_tmp731_);
		_tmp733_ = _tmp732_;
		_tmp721_ = VALA_IS_ENUM (_tmp733_);
	} else {
		_tmp721_ = FALSE;
	}
	if (_tmp721_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp734_;
		ValaDataType* _tmp735_;
		ValaTypeSymbol* _tmp736_;
		ValaTypeSymbol* _tmp737_;
		_tmp734_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp735_ = _tmp734_;
		_tmp736_ = vala_data_type_get_type_symbol (_tmp735_);
		_tmp737_ = _tmp736_;
		enum_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp737_, VALA_TYPE_ENUM, ValaEnum);
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp738_;
			ValaList* _tmp739_;
			gint _val_size = 0;
			ValaList* _tmp740_;
			gint _tmp741_;
			gint _tmp742_;
			gint _val_index = 0;
			_tmp738_ = enum_type;
			_tmp739_ = vala_enum_get_values (_tmp738_);
			_val_list = _tmp739_;
			_tmp740_ = _val_list;
			_tmp741_ = vala_collection_get_size ((ValaCollection*) _tmp740_);
			_tmp742_ = _tmp741_;
			_val_size = _tmp742_;
			_val_index = -1;
			while (TRUE) {
				gint _tmp743_;
				gint _tmp744_;
				ValaEnumValue* val = NULL;
				ValaList* _tmp745_;
				gpointer _tmp746_;
				const gchar* _tmp747_;
				ValaEnumValue* _tmp748_;
				const gchar* _tmp749_;
				const gchar* _tmp750_;
				_val_index = _val_index + 1;
				_tmp743_ = _val_index;
				_tmp744_ = _val_size;
				if (!(_tmp743_ < _tmp744_)) {
					break;
				}
				_tmp745_ = _val_list;
				_tmp746_ = vala_list_get (_tmp745_, _val_index);
				val = (ValaEnumValue*) _tmp746_;
				_tmp747_ = self->priv->_member_name;
				_tmp748_ = val;
				_tmp749_ = vala_symbol_get_name ((ValaSymbol*) _tmp748_);
				_tmp750_ = _tmp749_;
				if (g_strcmp0 (_tmp747_, _tmp750_) == 0) {
					ValaEnumValue* _tmp751_;
					_tmp751_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp751_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
		}
	}
	_tmp752_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp753_ = _tmp752_;
	if (_tmp753_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp754_;
		ValaSymbol* base_type = NULL;
		gboolean _tmp755_ = FALSE;
		ValaExpression* _tmp756_;
		ValaExpression* _tmp757_;
		gchar* base_type_package = NULL;
		gchar* _tmp777_;
		gboolean _tmp778_ = FALSE;
		ValaSymbol* _tmp779_;
		gchar* visited_types_string = NULL;
		gchar* _tmp794_;
		ValaSourceReference* _tmp810_;
		ValaSourceReference* _tmp811_;
		const gchar* _tmp812_;
		const gchar* _tmp813_;
		const gchar* _tmp814_;
		const gchar* _tmp815_;
		ValaInvalidType* _tmp816_;
		ValaInvalidType* _tmp817_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp754_ = g_strdup ("(null)");
		base_type_name = _tmp754_;
		base_type = NULL;
		_tmp756_ = vala_member_access_get_inner (self);
		_tmp757_ = _tmp756_;
		if (_tmp757_ != NULL) {
			ValaExpression* _tmp758_;
			ValaExpression* _tmp759_;
			ValaDataType* _tmp760_;
			ValaDataType* _tmp761_;
			_tmp758_ = vala_member_access_get_inner (self);
			_tmp759_ = _tmp758_;
			_tmp760_ = vala_expression_get_value_type (_tmp759_);
			_tmp761_ = _tmp760_;
			_tmp755_ = _tmp761_ != NULL;
		} else {
			_tmp755_ = FALSE;
		}
		if (_tmp755_) {
			ValaExpression* _tmp762_;
			ValaExpression* _tmp763_;
			ValaDataType* _tmp764_;
			ValaDataType* _tmp765_;
			gchar* _tmp766_;
			ValaExpression* _tmp767_;
			ValaExpression* _tmp768_;
			ValaDataType* _tmp769_;
			ValaDataType* _tmp770_;
			ValaTypeSymbol* _tmp771_;
			ValaTypeSymbol* _tmp772_;
			_tmp762_ = vala_member_access_get_inner (self);
			_tmp763_ = _tmp762_;
			_tmp764_ = vala_expression_get_value_type (_tmp763_);
			_tmp765_ = _tmp764_;
			_tmp766_ = vala_code_node_to_string ((ValaCodeNode*) _tmp765_);
			_g_free0 (base_type_name);
			base_type_name = _tmp766_;
			_tmp767_ = vala_member_access_get_inner (self);
			_tmp768_ = _tmp767_;
			_tmp769_ = vala_expression_get_value_type (_tmp768_);
			_tmp770_ = _tmp769_;
			_tmp771_ = vala_data_type_get_type_symbol (_tmp770_);
			_tmp772_ = _tmp771_;
			base_type = (ValaSymbol*) _tmp772_;
		} else {
			ValaSymbol* _tmp773_;
			_tmp773_ = base_symbol;
			if (_tmp773_ != NULL) {
				ValaSymbol* _tmp774_;
				gchar* _tmp775_;
				ValaSymbol* _tmp776_;
				_tmp774_ = base_symbol;
				_tmp775_ = vala_symbol_get_full_name (_tmp774_);
				_g_free0 (base_type_name);
				base_type_name = _tmp775_;
				_tmp776_ = base_symbol;
				base_type = _tmp776_;
			}
		}
		_tmp777_ = g_strdup ("");
		base_type_package = _tmp777_;
		_tmp779_ = base_type;
		if (_tmp779_ != NULL) {
			ValaSymbol* _tmp780_;
			gboolean _tmp781_;
			gboolean _tmp782_;
			_tmp780_ = base_type;
			_tmp781_ = vala_symbol_get_external_package (_tmp780_);
			_tmp782_ = _tmp781_;
			_tmp778_ = _tmp782_;
		} else {
			_tmp778_ = FALSE;
		}
		if (_tmp778_) {
			ValaSymbol* _tmp783_;
			ValaSourceReference* _tmp784_;
			ValaSourceReference* _tmp785_;
			ValaSourceFile* _tmp786_;
			ValaSourceFile* _tmp787_;
			const gchar* _tmp788_;
			const gchar* _tmp789_;
			gchar* _tmp790_;
			const gchar* _tmp791_;
			_tmp783_ = base_symbol;
			_tmp784_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp783_);
			_tmp785_ = _tmp784_;
			_tmp786_ = vala_source_reference_get_file (_tmp785_);
			_tmp787_ = _tmp786_;
			_tmp788_ = vala_source_file_get_package_name (_tmp787_);
			_tmp789_ = _tmp788_;
			_tmp790_ = g_strdup (_tmp789_);
			_g_free0 (base_type_package);
			base_type_package = _tmp790_;
			_tmp791_ = base_type_package;
			if (_tmp791_ != NULL) {
				const gchar* _tmp792_;
				gchar* _tmp793_;
				_tmp792_ = base_type_package;
				_tmp793_ = g_strdup_printf (" (%s)", _tmp792_);
				_g_free0 (base_type_package);
				base_type_package = _tmp793_;
			}
		}
		_tmp794_ = g_strdup ("");
		visited_types_string = _tmp794_;
		{
			ValaArrayList* _type_list = NULL;
			ValaArrayList* _tmp795_;
			gint _type_size = 0;
			ValaArrayList* _tmp796_;
			gint _tmp797_;
			gint _tmp798_;
			gint _type_index = 0;
			_tmp795_ = visited_types;
			_type_list = _tmp795_;
			_tmp796_ = _type_list;
			_tmp797_ = vala_collection_get_size ((ValaCollection*) _tmp796_);
			_tmp798_ = _tmp797_;
			_type_size = _tmp798_;
			_type_index = -1;
			while (TRUE) {
				gint _tmp799_;
				gint _tmp800_;
				ValaDataType* type = NULL;
				ValaArrayList* _tmp801_;
				gpointer _tmp802_;
				const gchar* _tmp803_;
				ValaDataType* _tmp804_;
				gchar* _tmp805_;
				gchar* _tmp806_;
				gchar* _tmp807_;
				gchar* _tmp808_;
				gchar* _tmp809_;
				_type_index = _type_index + 1;
				_tmp799_ = _type_index;
				_tmp800_ = _type_size;
				if (!(_tmp799_ < _tmp800_)) {
					break;
				}
				_tmp801_ = _type_list;
				_tmp802_ = vala_list_get ((ValaList*) _tmp801_, _type_index);
				type = (ValaDataType*) _tmp802_;
				_tmp803_ = visited_types_string;
				_tmp804_ = type;
				_tmp805_ = vala_code_node_to_string ((ValaCodeNode*) _tmp804_);
				_tmp806_ = _tmp805_;
				_tmp807_ = g_strdup_printf (" or `%s'", _tmp806_);
				_tmp808_ = _tmp807_;
				_tmp809_ = g_strconcat (_tmp803_, _tmp808_, NULL);
				_g_free0 (visited_types_string);
				visited_types_string = _tmp809_;
				_g_free0 (_tmp808_);
				_g_free0 (_tmp806_);
				_vala_code_node_unref0 (type);
			}
		}
		_tmp810_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp811_ = _tmp810_;
		_tmp812_ = self->priv->_member_name;
		_tmp813_ = base_type_name;
		_tmp814_ = base_type_package;
		_tmp815_ = visited_types_string;
		vala_report_error (_tmp811_, "The name `%s' does not exist in the context of `%s'%s%s", _tmp812_, _tmp813_, _tmp814_, _tmp815_);
		_tmp816_ = vala_invalid_type_new ();
		_tmp817_ = _tmp816_;
		vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp817_);
		_vala_code_node_unref0 (_tmp817_);
		result = FALSE;
		_g_free0 (visited_types_string);
		_g_free0 (base_type_package);
		_g_free0 (base_type_name);
		_vala_iterable_unref0 (visited_types);
		return result;
	} else {
		ValaSymbol* _tmp818_;
		ValaSymbol* _tmp819_;
		gboolean _tmp820_;
		gboolean _tmp821_;
		_tmp818_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp819_ = _tmp818_;
		_tmp820_ = vala_code_node_get_error ((ValaCodeNode*) _tmp819_);
		_tmp821_ = _tmp820_;
		if (_tmp821_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	}
	_tmp822_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp823_ = _tmp822_;
	if (VALA_IS_SIGNAL (_tmp823_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp824_;
		ValaSymbol* _tmp825_;
		ValaCodeNode* ma = NULL;
		ValaCodeNode* parent = NULL;
		ValaCodeNode* _tmp832_;
		ValaCodeNode* _tmp833_;
		ValaCodeNode* _tmp834_;
		gboolean _tmp835_ = FALSE;
		gboolean _tmp836_ = FALSE;
		gboolean _tmp837_ = FALSE;
		ValaCodeNode* _tmp838_;
		_tmp824_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp825_ = _tmp824_;
		sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp825_, VALA_TYPE_SIGNAL, ValaSignal);
		ma = (ValaCodeNode*) self;
		while (TRUE) {
			ValaCodeNode* _tmp826_;
			ValaCodeNode* _tmp827_;
			ValaCodeNode* _tmp828_;
			ValaCodeNode* _tmp829_;
			ValaCodeNode* _tmp830_;
			ValaCodeNode* _tmp831_;
			_tmp826_ = ma;
			_tmp827_ = vala_code_node_get_parent_node (_tmp826_);
			_tmp828_ = _tmp827_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp828_)) {
				break;
			}
			_tmp829_ = ma;
			_tmp830_ = vala_code_node_get_parent_node (_tmp829_);
			_tmp831_ = _tmp830_;
			ma = _tmp831_;
		}
		_tmp832_ = ma;
		_tmp833_ = vala_code_node_get_parent_node (_tmp832_);
		_tmp834_ = _tmp833_;
		parent = _tmp834_;
		_tmp838_ = parent;
		if (_tmp838_ != NULL) {
			ValaCodeNode* _tmp839_;
			_tmp839_ = parent;
			_tmp837_ = !VALA_IS_ELEMENT_ACCESS (_tmp839_);
		} else {
			_tmp837_ = FALSE;
		}
		if (_tmp837_) {
			ValaCodeNode* _tmp840_;
			ValaExpression* _tmp841_;
			ValaExpression* _tmp842_;
			_tmp840_ = ma;
			_tmp841_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp840_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp842_ = _tmp841_;
			_tmp836_ = !VALA_IS_BASE_ACCESS (_tmp842_);
		} else {
			_tmp836_ = FALSE;
		}
		if (_tmp836_) {
			gboolean _tmp843_ = FALSE;
			ValaCodeNode* _tmp844_;
			_tmp844_ = parent;
			if (!VALA_IS_METHOD_CALL (_tmp844_)) {
				_tmp843_ = TRUE;
			} else {
				ValaCodeNode* _tmp845_;
				ValaList* _tmp846_;
				_tmp845_ = parent;
				_tmp846_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) G_TYPE_CHECK_INSTANCE_CAST (_tmp845_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
				_tmp843_ = vala_collection_contains ((ValaCollection*) _tmp846_, (ValaExpression*) self);
			}
			_tmp835_ = _tmp843_;
		} else {
			_tmp835_ = FALSE;
		}
		if (_tmp835_) {
			ValaSignal* _tmp847_;
			ValaAttribute* _tmp848_;
			_tmp847_ = sig;
			_tmp848_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp847_, "HasEmitter");
			if (_tmp848_ != NULL) {
				ValaSignal* _tmp849_;
				ValaSignal* _tmp850_;
				ValaMethod* _tmp851_;
				ValaMethod* _tmp852_;
				_tmp849_ = sig;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp849_, context)) {
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
				_tmp850_ = sig;
				_tmp851_ = vala_signal_get_emitter (_tmp850_);
				_tmp852_ = _tmp851_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp852_);
			} else {
				ValaSourceReference* _tmp853_;
				ValaSourceReference* _tmp854_;
				ValaSymbol* _tmp855_;
				ValaSymbol* _tmp856_;
				gchar* _tmp857_;
				gchar* _tmp858_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp853_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp854_ = _tmp853_;
				_tmp855_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp856_ = _tmp855_;
				_tmp857_ = vala_symbol_get_full_name (_tmp856_);
				_tmp858_ = _tmp857_;
				vala_report_error (_tmp854_, "Signal `%s' requires emitter in this context", _tmp858_);
				_g_free0 (_tmp858_);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
		}
	}
	_tmp859_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp860_ = _tmp859_;
	member = _tmp860_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp861_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp861_, context)) {
		result = FALSE;
		_vala_iterable_unref0 (visited_types);
		return result;
	}
	_tmp862_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp862_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp863_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp864_;
		ValaSymbol* _tmp865_;
		ValaSymbol* _tmp866_;
		gboolean _tmp867_ = FALSE;
		ValaBlock* _tmp868_;
		_tmp863_ = member;
		local = G_TYPE_CHECK_INSTANCE_CAST (_tmp863_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
		_tmp864_ = local;
		_tmp865_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp864_);
		_tmp866_ = _tmp865_;
		block = VALA_IS_BLOCK (_tmp866_) ? ((ValaBlock*) _tmp866_) : NULL;
		_tmp868_ = block;
		if (_tmp868_ != NULL) {
			ValaBlock* _tmp869_;
			ValaSymbol* _tmp870_;
			ValaSemanticAnalyzer* _tmp871_;
			ValaSemanticAnalyzer* _tmp872_;
			ValaSymbol* _tmp873_;
			ValaSymbol* _tmp874_;
			_tmp869_ = block;
			_tmp870_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp869_);
			_tmp871_ = vala_code_context_get_analyzer (context);
			_tmp872_ = _tmp871_;
			_tmp873_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp872_);
			_tmp874_ = _tmp873_;
			_tmp867_ = _tmp870_ != _tmp874_;
		} else {
			_tmp867_ = FALSE;
		}
		if (_tmp867_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp875_;
			ValaSemanticAnalyzer* _tmp876_;
			ValaSymbol* _tmp877_;
			ValaSymbol* _tmp878_;
			ValaLocalVariable* _tmp889_;
			ValaBlock* _tmp890_;
			ValaLocalVariable* _tmp891_;
			ValaDataType* _tmp892_;
			ValaDataType* _tmp893_;
			ValaTypeSymbol* _tmp894_;
			ValaTypeSymbol* _tmp895_;
			ValaSemanticAnalyzer* _tmp896_;
			ValaSemanticAnalyzer* _tmp897_;
			ValaDataType* _tmp898_;
			ValaTypeSymbol* _tmp899_;
			ValaTypeSymbol* _tmp900_;
			_tmp875_ = vala_code_context_get_analyzer (context);
			_tmp876_ = _tmp875_;
			_tmp877_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp876_);
			_tmp878_ = _tmp877_;
			sym = _tmp878_;
			while (TRUE) {
				ValaSymbol* _tmp879_;
				ValaBlock* _tmp880_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp881_;
				ValaMethod* _tmp882_;
				ValaSymbol* _tmp886_;
				ValaSymbol* _tmp887_;
				ValaSymbol* _tmp888_;
				_tmp879_ = sym;
				_tmp880_ = block;
				if (!(_tmp879_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp880_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp881_ = sym;
				method = VALA_IS_METHOD (_tmp881_) ? ((ValaMethod*) _tmp881_) : NULL;
				_tmp882_ = method;
				if (_tmp882_ != NULL) {
					ValaMethod* _tmp883_;
					ValaMethod* _tmp884_;
					ValaLocalVariable* _tmp885_;
					_tmp883_ = method;
					vala_method_set_closure (_tmp883_, TRUE);
					_tmp884_ = method;
					_tmp885_ = local;
					vala_method_add_captured_variable (_tmp884_, _tmp885_);
				}
				_tmp886_ = sym;
				_tmp887_ = vala_symbol_get_parent_symbol (_tmp886_);
				_tmp888_ = _tmp887_;
				sym = _tmp888_;
			}
			_tmp889_ = local;
			vala_local_variable_set_captured (_tmp889_, TRUE);
			_tmp890_ = block;
			vala_block_set_captured (_tmp890_, TRUE);
			_tmp891_ = local;
			_tmp892_ = vala_variable_get_variable_type ((ValaVariable*) _tmp891_);
			_tmp893_ = _tmp892_;
			_tmp894_ = vala_data_type_get_type_symbol (_tmp893_);
			_tmp895_ = _tmp894_;
			_tmp896_ = vala_code_context_get_analyzer (context);
			_tmp897_ = _tmp896_;
			_tmp898_ = _tmp897_->va_list_type;
			_tmp899_ = vala_data_type_get_type_symbol (_tmp898_);
			_tmp900_ = _tmp899_;
			if (_tmp895_ == _tmp900_) {
				ValaSourceReference* _tmp901_;
				ValaSourceReference* _tmp902_;
				ValaLocalVariable* _tmp903_;
				gchar* _tmp904_;
				gchar* _tmp905_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp901_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp902_ = _tmp901_;
				_tmp903_ = local;
				_tmp904_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp903_);
				_tmp905_ = _tmp904_;
				vala_report_error (_tmp902_, "Capturing `va_list' variable `%s' is not allowed", _tmp905_);
				_g_free0 (_tmp905_);
			}
		}
	} else {
		ValaSymbol* _tmp906_;
		_tmp906_ = member;
		if (VALA_IS_PARAMETER (_tmp906_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp907_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp908_;
			ValaSymbol* _tmp909_;
			ValaSymbol* _tmp910_;
			gboolean _tmp911_ = FALSE;
			gboolean _tmp912_ = FALSE;
			ValaMethod* _tmp913_;
			_tmp907_ = member;
			param = G_TYPE_CHECK_INSTANCE_CAST (_tmp907_, VALA_TYPE_PARAMETER, ValaParameter);
			_tmp908_ = param;
			_tmp909_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp908_);
			_tmp910_ = _tmp909_;
			m = VALA_IS_METHOD (_tmp910_) ? ((ValaMethod*) _tmp910_) : NULL;
			_tmp913_ = m;
			if (_tmp913_ != NULL) {
				ValaMethod* _tmp914_;
				ValaSemanticAnalyzer* _tmp915_;
				ValaSemanticAnalyzer* _tmp916_;
				ValaSymbol* _tmp917_;
				ValaSymbol* _tmp918_;
				_tmp914_ = m;
				_tmp915_ = vala_code_context_get_analyzer (context);
				_tmp916_ = _tmp915_;
				_tmp917_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp916_);
				_tmp918_ = _tmp917_;
				_tmp912_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp914_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp918_;
			} else {
				_tmp912_ = FALSE;
			}
			if (_tmp912_) {
				ValaParameter* _tmp919_;
				ValaMethod* _tmp920_;
				ValaParameter* _tmp921_;
				ValaParameter* _tmp922_;
				_tmp919_ = param;
				_tmp920_ = m;
				_tmp921_ = vala_method_get_this_parameter (_tmp920_);
				_tmp922_ = _tmp921_;
				_tmp911_ = _tmp919_ != _tmp922_;
			} else {
				_tmp911_ = FALSE;
			}
			if (_tmp911_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp923_;
				ValaSemanticAnalyzer* _tmp924_;
				ValaSymbol* _tmp925_;
				ValaSymbol* _tmp926_;
				ValaParameter* _tmp935_;
				ValaMethod* _tmp936_;
				ValaBlock* _tmp937_;
				ValaBlock* _tmp938_;
				ValaParameter* _tmp939_;
				ValaParameterDirection _tmp940_;
				ValaParameterDirection _tmp941_;
				ValaParameter* _tmp947_;
				ValaDataType* _tmp948_;
				ValaDataType* _tmp949_;
				ValaTypeSymbol* _tmp950_;
				ValaTypeSymbol* _tmp951_;
				ValaSemanticAnalyzer* _tmp952_;
				ValaSemanticAnalyzer* _tmp953_;
				ValaDataType* _tmp954_;
				ValaTypeSymbol* _tmp955_;
				ValaTypeSymbol* _tmp956_;
				_tmp923_ = vala_code_context_get_analyzer (context);
				_tmp924_ = _tmp923_;
				_tmp925_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp924_);
				_tmp926_ = _tmp925_;
				sym = _tmp926_;
				while (TRUE) {
					ValaSymbol* _tmp927_;
					ValaMethod* _tmp928_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp929_;
					ValaMethod* _tmp930_;
					ValaSymbol* _tmp932_;
					ValaSymbol* _tmp933_;
					ValaSymbol* _tmp934_;
					_tmp927_ = sym;
					_tmp928_ = m;
					if (!(_tmp927_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp928_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp929_ = sym;
					method = VALA_IS_METHOD (_tmp929_) ? ((ValaMethod*) _tmp929_) : NULL;
					_tmp930_ = method;
					if (_tmp930_ != NULL) {
						ValaMethod* _tmp931_;
						_tmp931_ = method;
						vala_method_set_closure (_tmp931_, TRUE);
					}
					_tmp932_ = sym;
					_tmp933_ = vala_symbol_get_parent_symbol (_tmp932_);
					_tmp934_ = _tmp933_;
					sym = _tmp934_;
				}
				_tmp935_ = param;
				vala_parameter_set_captured (_tmp935_, TRUE);
				_tmp936_ = m;
				_tmp937_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp936_);
				_tmp938_ = _tmp937_;
				vala_block_set_captured (_tmp938_, TRUE);
				_tmp939_ = param;
				_tmp940_ = vala_parameter_get_direction (_tmp939_);
				_tmp941_ = _tmp940_;
				if (_tmp941_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp942_;
					ValaSourceReference* _tmp943_;
					ValaParameter* _tmp944_;
					gchar* _tmp945_;
					gchar* _tmp946_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp942_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp943_ = _tmp942_;
					_tmp944_ = param;
					_tmp945_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp944_);
					_tmp946_ = _tmp945_;
					vala_report_error (_tmp943_, "Cannot capture reference or output parameter `%s'", _tmp946_);
					_g_free0 (_tmp946_);
				}
				_tmp947_ = param;
				_tmp948_ = vala_variable_get_variable_type ((ValaVariable*) _tmp947_);
				_tmp949_ = _tmp948_;
				_tmp950_ = vala_data_type_get_type_symbol (_tmp949_);
				_tmp951_ = _tmp950_;
				_tmp952_ = vala_code_context_get_analyzer (context);
				_tmp953_ = _tmp952_;
				_tmp954_ = _tmp953_->va_list_type;
				_tmp955_ = vala_data_type_get_type_symbol (_tmp954_);
				_tmp956_ = _tmp955_;
				if (_tmp951_ == _tmp956_) {
					ValaSourceReference* _tmp957_;
					ValaSourceReference* _tmp958_;
					ValaParameter* _tmp959_;
					gchar* _tmp960_;
					gchar* _tmp961_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp957_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp958_ = _tmp957_;
					_tmp959_ = param;
					_tmp960_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp959_);
					_tmp961_ = _tmp960_;
					vala_report_error (_tmp958_, "Capturing `va_list' parameter `%s' is not allowed", _tmp961_);
					_g_free0 (_tmp961_);
				}
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp962_;
				ValaSymbol* _tmp963_;
				ValaSymbol* _tmp964_;
				ValaSymbol* _tmp965_;
				ValaSymbol* _tmp966_;
				gboolean _tmp967_ = FALSE;
				gboolean _tmp968_ = FALSE;
				ValaPropertyAccessor* _tmp969_;
				_tmp962_ = param;
				_tmp963_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp962_);
				_tmp964_ = _tmp963_;
				_tmp965_ = vala_symbol_get_parent_symbol (_tmp964_);
				_tmp966_ = _tmp965_;
				acc = VALA_IS_PROPERTY_ACCESSOR (_tmp966_) ? ((ValaPropertyAccessor*) _tmp966_) : NULL;
				_tmp969_ = acc;
				if (_tmp969_ != NULL) {
					ValaPropertyAccessor* _tmp970_;
					ValaSemanticAnalyzer* _tmp971_;
					ValaSemanticAnalyzer* _tmp972_;
					ValaSymbol* _tmp973_;
					ValaSymbol* _tmp974_;
					_tmp970_ = acc;
					_tmp971_ = vala_code_context_get_analyzer (context);
					_tmp972_ = _tmp971_;
					_tmp973_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp972_);
					_tmp974_ = _tmp973_;
					_tmp968_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp970_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp974_;
				} else {
					_tmp968_ = FALSE;
				}
				if (_tmp968_) {
					ValaParameter* _tmp975_;
					ValaPropertyAccessor* _tmp976_;
					ValaProperty* _tmp977_;
					ValaProperty* _tmp978_;
					ValaParameter* _tmp979_;
					ValaParameter* _tmp980_;
					_tmp975_ = param;
					_tmp976_ = acc;
					_tmp977_ = vala_property_accessor_get_prop (_tmp976_);
					_tmp978_ = _tmp977_;
					_tmp979_ = vala_property_get_this_parameter (_tmp978_);
					_tmp980_ = _tmp979_;
					_tmp967_ = _tmp975_ != _tmp980_;
				} else {
					_tmp967_ = FALSE;
				}
				if (_tmp967_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp981_;
					ValaSemanticAnalyzer* _tmp982_;
					ValaSymbol* _tmp983_;
					ValaSymbol* _tmp984_;
					ValaParameter* _tmp993_;
					ValaPropertyAccessor* _tmp994_;
					ValaBlock* _tmp995_;
					ValaBlock* _tmp996_;
					_tmp981_ = vala_code_context_get_analyzer (context);
					_tmp982_ = _tmp981_;
					_tmp983_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp982_);
					_tmp984_ = _tmp983_;
					sym = _tmp984_;
					while (TRUE) {
						ValaSymbol* _tmp985_;
						ValaMethod* _tmp986_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp987_;
						ValaMethod* _tmp988_;
						ValaSymbol* _tmp990_;
						ValaSymbol* _tmp991_;
						ValaSymbol* _tmp992_;
						_tmp985_ = sym;
						_tmp986_ = m;
						if (!(_tmp985_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp986_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp987_ = sym;
						method = VALA_IS_METHOD (_tmp987_) ? ((ValaMethod*) _tmp987_) : NULL;
						_tmp988_ = method;
						if (_tmp988_ != NULL) {
							ValaMethod* _tmp989_;
							_tmp989_ = method;
							vala_method_set_closure (_tmp989_, TRUE);
						}
						_tmp990_ = sym;
						_tmp991_ = vala_symbol_get_parent_symbol (_tmp990_);
						_tmp992_ = _tmp991_;
						sym = _tmp992_;
					}
					_tmp993_ = param;
					vala_parameter_set_captured (_tmp993_, TRUE);
					_tmp994_ = acc;
					_tmp995_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp994_);
					_tmp996_ = _tmp995_;
					vala_block_set_captured (_tmp996_, TRUE);
				}
			}
		} else {
			ValaSymbol* _tmp997_;
			_tmp997_ = member;
			if (VALA_IS_FIELD (_tmp997_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp998_;
				ValaField* _tmp999_;
				ValaSymbolAccessibility _tmp1000_;
				ValaSymbolAccessibility _tmp1001_;
				ValaField* _tmp1002_;
				ValaMemberBinding _tmp1003_;
				ValaMemberBinding _tmp1004_;
				ValaField* _tmp1005_;
				ValaMemberBinding _tmp1006_;
				ValaMemberBinding _tmp1007_;
				ValaField* _tmp1008_;
				ValaDataType* _tmp1009_;
				ValaDataType* _tmp1010_;
				_tmp998_ = member;
				f = G_TYPE_CHECK_INSTANCE_CAST (_tmp998_, VALA_TYPE_FIELD, ValaField);
				_tmp999_ = f;
				_tmp1000_ = vala_symbol_get_access ((ValaSymbol*) _tmp999_);
				_tmp1001_ = _tmp1000_;
				access = _tmp1001_;
				_tmp1002_ = f;
				_tmp1003_ = vala_field_get_binding (_tmp1002_);
				_tmp1004_ = _tmp1003_;
				instance = _tmp1004_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp1005_ = f;
				_tmp1006_ = vala_field_get_binding (_tmp1005_);
				_tmp1007_ = _tmp1006_;
				klass = _tmp1007_ == VALA_MEMBER_BINDING_CLASS;
				_tmp1008_ = f;
				_tmp1009_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1008_);
				_tmp1010_ = _tmp1009_;
				if (VALA_IS_GENERIC_TYPE (_tmp1010_)) {
					generics = TRUE;
				}
			} else {
				ValaSymbol* _tmp1011_;
				_tmp1011_ = member;
				if (VALA_IS_CONSTANT (_tmp1011_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp1012_;
					ValaConstant* _tmp1013_;
					ValaSymbolAccessibility _tmp1014_;
					ValaSymbolAccessibility _tmp1015_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp1016_;
					ValaSymbol* _tmp1017_;
					ValaSymbol* _tmp1018_;
					gboolean _tmp1019_ = FALSE;
					ValaBlock* _tmp1020_;
					_tmp1012_ = member;
					c = G_TYPE_CHECK_INSTANCE_CAST (_tmp1012_, VALA_TYPE_CONSTANT, ValaConstant);
					_tmp1013_ = c;
					_tmp1014_ = vala_symbol_get_access ((ValaSymbol*) _tmp1013_);
					_tmp1015_ = _tmp1014_;
					access = _tmp1015_;
					_tmp1016_ = c;
					_tmp1017_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1016_);
					_tmp1018_ = _tmp1017_;
					block = VALA_IS_BLOCK (_tmp1018_) ? ((ValaBlock*) _tmp1018_) : NULL;
					_tmp1020_ = block;
					if (_tmp1020_ != NULL) {
						ValaBlock* _tmp1021_;
						ValaSymbol* _tmp1022_;
						ValaSemanticAnalyzer* _tmp1023_;
						ValaSemanticAnalyzer* _tmp1024_;
						ValaSymbol* _tmp1025_;
						ValaSymbol* _tmp1026_;
						_tmp1021_ = block;
						_tmp1022_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp1021_);
						_tmp1023_ = vala_code_context_get_analyzer (context);
						_tmp1024_ = _tmp1023_;
						_tmp1025_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp1024_);
						_tmp1026_ = _tmp1025_;
						_tmp1019_ = _tmp1022_ != _tmp1026_;
					} else {
						_tmp1019_ = FALSE;
					}
					if (_tmp1019_) {
						ValaSourceReference* _tmp1027_;
						ValaSourceReference* _tmp1028_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp1027_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp1028_ = _tmp1027_;
						vala_report_error (_tmp1028_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						_vala_iterable_unref0 (visited_types);
						return result;
					}
				} else {
					ValaSymbol* _tmp1029_;
					_tmp1029_ = member;
					if (VALA_IS_METHOD (_tmp1029_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp1030_;
						ValaMethod* _tmp1031_;
						gboolean _tmp1032_;
						gboolean _tmp1033_;
						ValaMethod* _tmp1120_;
						ValaSymbolAccessibility _tmp1121_;
						ValaSymbolAccessibility _tmp1122_;
						ValaMethod* _tmp1123_;
						ValaMethod* _tmp1127_;
						ValaMemberBinding _tmp1128_;
						ValaMemberBinding _tmp1129_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp1149_;
						ValaDataType* _tmp1150_;
						ValaDataType* _tmp1151_;
						gboolean _tmp1152_ = FALSE;
						ValaGenericType* _tmp1153_;
						_tmp1030_ = member;
						m = G_TYPE_CHECK_INSTANCE_CAST (_tmp1030_, VALA_TYPE_METHOD, ValaMethod);
						_tmp1031_ = m;
						_tmp1032_ = vala_method_get_is_async_callback (_tmp1031_);
						_tmp1033_ = _tmp1032_;
						if (_tmp1033_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp1034_;
							ValaSemanticAnalyzer* _tmp1035_;
							ValaMethod* _tmp1036_;
							ValaMethod* _tmp1037_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp1038_;
							ValaMethod* _tmp1065_;
							ValaSemanticAnalyzer* _tmp1066_;
							ValaSemanticAnalyzer* _tmp1067_;
							ValaMethod* _tmp1068_;
							ValaMethod* _tmp1069_;
							ValaMethod* _tmp1085_;
							ValaMethod* _tmp1086_;
							ValaMethod* _tmp1087_;
							ValaSymbol* _tmp1088_;
							ValaSymbol* _tmp1089_;
							_tmp1034_ = vala_code_context_get_analyzer (context);
							_tmp1035_ = _tmp1034_;
							_tmp1036_ = vala_semantic_analyzer_get_current_async_method (_tmp1035_);
							_tmp1037_ = _tmp1036_;
							async_method = _tmp1037_;
							is_valid_access = FALSE;
							_tmp1038_ = async_method;
							if (_tmp1038_ != NULL) {
								ValaMethod* _tmp1039_;
								ValaMethod* _tmp1040_;
								ValaMethod* _tmp1041_;
								_tmp1039_ = m;
								_tmp1040_ = async_method;
								_tmp1041_ = vala_method_get_callback_method (_tmp1040_);
								if (_tmp1039_ == _tmp1041_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp1042_ = FALSE;
									ValaMethod* _tmp1043_;
									ValaMethod* _tmp1044_;
									ValaMethod* _tmp1045_;
									_tmp1043_ = async_method;
									_tmp1044_ = vala_method_get_base_method (_tmp1043_);
									_tmp1045_ = _tmp1044_;
									if (_tmp1045_ != NULL) {
										ValaMethod* _tmp1046_;
										ValaMethod* _tmp1047_;
										ValaMethod* _tmp1048_;
										ValaMethod* _tmp1049_;
										ValaMethod* _tmp1050_;
										_tmp1046_ = m;
										_tmp1047_ = async_method;
										_tmp1048_ = vala_method_get_base_method (_tmp1047_);
										_tmp1049_ = _tmp1048_;
										_tmp1050_ = vala_method_get_callback_method (_tmp1049_);
										_tmp1042_ = _tmp1046_ == _tmp1050_;
									} else {
										_tmp1042_ = FALSE;
									}
									if (_tmp1042_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp1051_ = FALSE;
										ValaMethod* _tmp1052_;
										ValaMethod* _tmp1053_;
										ValaMethod* _tmp1054_;
										_tmp1052_ = async_method;
										_tmp1053_ = vala_method_get_base_interface_method (_tmp1052_);
										_tmp1054_ = _tmp1053_;
										if (_tmp1054_ != NULL) {
											ValaMethod* _tmp1055_;
											ValaMethod* _tmp1056_;
											ValaMethod* _tmp1057_;
											ValaMethod* _tmp1058_;
											ValaMethod* _tmp1059_;
											_tmp1055_ = m;
											_tmp1056_ = async_method;
											_tmp1057_ = vala_method_get_base_interface_method (_tmp1056_);
											_tmp1058_ = _tmp1057_;
											_tmp1059_ = vala_method_get_callback_method (_tmp1058_);
											_tmp1051_ = _tmp1055_ == _tmp1059_;
										} else {
											_tmp1051_ = FALSE;
										}
										if (_tmp1051_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp1060_;
								ValaSourceReference* _tmp1061_;
								ValaMethod* _tmp1062_;
								gchar* _tmp1063_;
								gchar* _tmp1064_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp1060_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp1061_ = _tmp1060_;
								_tmp1062_ = m;
								_tmp1063_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1062_);
								_tmp1064_ = _tmp1063_;
								vala_report_error (_tmp1061_, "Access to async callback `%s' not allowed in this context", _tmp1064_);
								_g_free0 (_tmp1064_);
								result = FALSE;
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp1065_ = async_method;
							_tmp1066_ = vala_code_context_get_analyzer (context);
							_tmp1067_ = _tmp1066_;
							_tmp1068_ = vala_semantic_analyzer_get_current_method (_tmp1067_);
							_tmp1069_ = _tmp1068_;
							if (_tmp1065_ != _tmp1069_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp1070_;
								ValaSemanticAnalyzer* _tmp1071_;
								ValaMethod* _tmp1072_;
								ValaMethod* _tmp1073_;
								ValaMethod* _tmp1082_;
								ValaBlock* _tmp1083_;
								ValaBlock* _tmp1084_;
								_tmp1070_ = vala_code_context_get_analyzer (context);
								_tmp1071_ = _tmp1070_;
								_tmp1072_ = vala_semantic_analyzer_get_current_method (_tmp1071_);
								_tmp1073_ = _tmp1072_;
								sym = (ValaSymbol*) _tmp1073_;
								while (TRUE) {
									ValaSymbol* _tmp1074_;
									ValaMethod* _tmp1075_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp1076_;
									ValaMethod* _tmp1077_;
									ValaSymbol* _tmp1079_;
									ValaSymbol* _tmp1080_;
									ValaSymbol* _tmp1081_;
									_tmp1074_ = sym;
									_tmp1075_ = async_method;
									if (!(_tmp1074_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1075_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp1076_ = sym;
									method = VALA_IS_METHOD (_tmp1076_) ? ((ValaMethod*) _tmp1076_) : NULL;
									_tmp1077_ = method;
									if (_tmp1077_ != NULL) {
										ValaMethod* _tmp1078_;
										_tmp1078_ = method;
										vala_method_set_closure (_tmp1078_, TRUE);
									}
									_tmp1079_ = sym;
									_tmp1080_ = vala_symbol_get_parent_symbol (_tmp1079_);
									_tmp1081_ = _tmp1080_;
									sym = _tmp1081_;
								}
								_tmp1082_ = async_method;
								_tmp1083_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp1082_);
								_tmp1084_ = _tmp1083_;
								vala_block_set_captured (_tmp1084_, TRUE);
							}
							_tmp1085_ = async_method;
							_tmp1086_ = vala_method_get_callback_method (_tmp1085_);
							m = _tmp1086_;
							_tmp1087_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1087_);
							_tmp1088_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp1089_ = _tmp1088_;
							member = _tmp1089_;
						} else {
							ValaMethod* _tmp1090_;
							ValaMethod* _tmp1091_;
							ValaMethod* _tmp1092_;
							_tmp1090_ = m;
							_tmp1091_ = vala_method_get_base_method (_tmp1090_);
							_tmp1092_ = _tmp1091_;
							if (_tmp1092_ != NULL) {
								ValaMethod* _tmp1093_;
								ValaMethod* _tmp1094_;
								ValaMethod* _tmp1095_;
								ValaMethod* _tmp1096_;
								ValaSignal* _tmp1097_;
								ValaSignal* _tmp1098_;
								ValaSymbol* _tmp1103_;
								ValaSymbol* _tmp1104_;
								_tmp1093_ = m;
								_tmp1094_ = vala_method_get_base_method (_tmp1093_);
								_tmp1095_ = _tmp1094_;
								m = _tmp1095_;
								_tmp1096_ = m;
								_tmp1097_ = vala_method_get_signal_reference (_tmp1096_);
								_tmp1098_ = _tmp1097_;
								if (_tmp1098_ != NULL) {
									ValaMethod* _tmp1099_;
									ValaSignal* _tmp1100_;
									ValaSignal* _tmp1101_;
									_tmp1099_ = m;
									_tmp1100_ = vala_method_get_signal_reference (_tmp1099_);
									_tmp1101_ = _tmp1100_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1101_);
								} else {
									ValaMethod* _tmp1102_;
									_tmp1102_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1102_);
								}
								_tmp1103_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1104_ = _tmp1103_;
								member = _tmp1104_;
							} else {
								ValaMethod* _tmp1105_;
								ValaMethod* _tmp1106_;
								ValaMethod* _tmp1107_;
								_tmp1105_ = m;
								_tmp1106_ = vala_method_get_base_interface_method (_tmp1105_);
								_tmp1107_ = _tmp1106_;
								if (_tmp1107_ != NULL) {
									ValaMethod* _tmp1108_;
									ValaMethod* _tmp1109_;
									ValaMethod* _tmp1110_;
									ValaMethod* _tmp1111_;
									ValaSignal* _tmp1112_;
									ValaSignal* _tmp1113_;
									ValaSymbol* _tmp1118_;
									ValaSymbol* _tmp1119_;
									_tmp1108_ = m;
									_tmp1109_ = vala_method_get_base_interface_method (_tmp1108_);
									_tmp1110_ = _tmp1109_;
									m = _tmp1110_;
									_tmp1111_ = m;
									_tmp1112_ = vala_method_get_signal_reference (_tmp1111_);
									_tmp1113_ = _tmp1112_;
									if (_tmp1113_ != NULL) {
										ValaMethod* _tmp1114_;
										ValaSignal* _tmp1115_;
										ValaSignal* _tmp1116_;
										_tmp1114_ = m;
										_tmp1115_ = vala_method_get_signal_reference (_tmp1114_);
										_tmp1116_ = _tmp1115_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1116_);
									} else {
										ValaMethod* _tmp1117_;
										_tmp1117_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1117_);
									}
									_tmp1118_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1119_ = _tmp1118_;
									member = _tmp1119_;
								}
							}
						}
						_tmp1120_ = m;
						_tmp1121_ = vala_symbol_get_access ((ValaSymbol*) _tmp1120_);
						_tmp1122_ = _tmp1121_;
						access = _tmp1122_;
						_tmp1123_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp1123_)) {
							ValaMethod* _tmp1124_;
							ValaMemberBinding _tmp1125_;
							ValaMemberBinding _tmp1126_;
							_tmp1124_ = m;
							_tmp1125_ = vala_method_get_binding (_tmp1124_);
							_tmp1126_ = _tmp1125_;
							instance = _tmp1126_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp1127_ = m;
						_tmp1128_ = vala_method_get_binding (_tmp1127_);
						_tmp1129_ = _tmp1128_;
						klass = _tmp1129_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp1130_;
							ValaList* _tmp1131_;
							gint _param_size = 0;
							ValaList* _tmp1132_;
							gint _tmp1133_;
							gint _tmp1134_;
							gint _param_index = 0;
							_tmp1130_ = m;
							_tmp1131_ = vala_callable_get_parameters ((ValaCallable*) _tmp1130_);
							_param_list = _tmp1131_;
							_tmp1132_ = _param_list;
							_tmp1133_ = vala_collection_get_size ((ValaCollection*) _tmp1132_);
							_tmp1134_ = _tmp1133_;
							_param_size = _tmp1134_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp1135_;
								gint _tmp1136_;
								ValaParameter* param = NULL;
								ValaList* _tmp1137_;
								gpointer _tmp1138_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp1139_;
								ValaDataType* _tmp1140_;
								ValaDataType* _tmp1141_;
								gboolean _tmp1142_ = FALSE;
								ValaGenericType* _tmp1143_;
								_param_index = _param_index + 1;
								_tmp1135_ = _param_index;
								_tmp1136_ = _param_size;
								if (!(_tmp1135_ < _tmp1136_)) {
									break;
								}
								_tmp1137_ = _param_list;
								_tmp1138_ = vala_list_get (_tmp1137_, _param_index);
								param = (ValaParameter*) _tmp1138_;
								_tmp1139_ = param;
								_tmp1140_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1139_);
								_tmp1141_ = _tmp1140_;
								generic_type = VALA_IS_GENERIC_TYPE (_tmp1141_) ? ((ValaGenericType*) _tmp1141_) : NULL;
								_tmp1143_ = generic_type;
								if (_tmp1143_ != NULL) {
									ValaGenericType* _tmp1144_;
									ValaTypeParameter* _tmp1145_;
									ValaTypeParameter* _tmp1146_;
									ValaSymbol* _tmp1147_;
									ValaSymbol* _tmp1148_;
									_tmp1144_ = generic_type;
									_tmp1145_ = vala_generic_type_get_type_parameter (_tmp1144_);
									_tmp1146_ = _tmp1145_;
									_tmp1147_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1146_);
									_tmp1148_ = _tmp1147_;
									_tmp1142_ = VALA_IS_TYPESYMBOL (_tmp1148_);
								} else {
									_tmp1142_ = FALSE;
								}
								if (_tmp1142_) {
									generics = TRUE;
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (param);
							}
						}
						_tmp1149_ = m;
						_tmp1150_ = vala_callable_get_return_type ((ValaCallable*) _tmp1149_);
						_tmp1151_ = _tmp1150_;
						generic_type = VALA_IS_GENERIC_TYPE (_tmp1151_) ? ((ValaGenericType*) _tmp1151_) : NULL;
						_tmp1153_ = generic_type;
						if (_tmp1153_ != NULL) {
							ValaGenericType* _tmp1154_;
							ValaTypeParameter* _tmp1155_;
							ValaTypeParameter* _tmp1156_;
							ValaSymbol* _tmp1157_;
							ValaSymbol* _tmp1158_;
							_tmp1154_ = generic_type;
							_tmp1155_ = vala_generic_type_get_type_parameter (_tmp1154_);
							_tmp1156_ = _tmp1155_;
							_tmp1157_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1156_);
							_tmp1158_ = _tmp1157_;
							_tmp1152_ = VALA_IS_TYPESYMBOL (_tmp1158_);
						} else {
							_tmp1152_ = FALSE;
						}
						if (_tmp1152_) {
							generics = TRUE;
						}
					} else {
						ValaSymbol* _tmp1159_;
						_tmp1159_ = member;
						if (VALA_IS_PROPERTY (_tmp1159_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp1160_;
							ValaProperty* _tmp1161_;
							ValaProperty* _tmp1162_;
							ValaProperty* _tmp1163_;
							ValaProperty* _tmp1164_;
							ValaProperty* _tmp1180_;
							ValaSymbolAccessibility _tmp1181_;
							ValaSymbolAccessibility _tmp1182_;
							gboolean _tmp1183_;
							gboolean _tmp1184_;
							ValaProperty* _tmp1283_;
							ValaMemberBinding _tmp1284_;
							ValaMemberBinding _tmp1285_;
							ValaProperty* _tmp1286_;
							ValaDataType* _tmp1287_;
							ValaDataType* _tmp1288_;
							_tmp1160_ = member;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp1160_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp1161_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp1161_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp1162_ = prop;
							_tmp1163_ = vala_property_get_base_property (_tmp1162_);
							_tmp1164_ = _tmp1163_;
							if (_tmp1164_ != NULL) {
								ValaProperty* _tmp1165_;
								ValaProperty* _tmp1166_;
								ValaProperty* _tmp1167_;
								ValaProperty* _tmp1168_;
								ValaSymbol* _tmp1169_;
								ValaSymbol* _tmp1170_;
								_tmp1165_ = prop;
								_tmp1166_ = vala_property_get_base_property (_tmp1165_);
								_tmp1167_ = _tmp1166_;
								prop = _tmp1167_;
								_tmp1168_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1168_);
								_tmp1169_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1170_ = _tmp1169_;
								member = _tmp1170_;
							} else {
								ValaProperty* _tmp1171_;
								ValaProperty* _tmp1172_;
								ValaProperty* _tmp1173_;
								_tmp1171_ = prop;
								_tmp1172_ = vala_property_get_base_interface_property (_tmp1171_);
								_tmp1173_ = _tmp1172_;
								if (_tmp1173_ != NULL) {
									ValaProperty* _tmp1174_;
									ValaProperty* _tmp1175_;
									ValaProperty* _tmp1176_;
									ValaProperty* _tmp1177_;
									ValaSymbol* _tmp1178_;
									ValaSymbol* _tmp1179_;
									_tmp1174_ = prop;
									_tmp1175_ = vala_property_get_base_interface_property (_tmp1174_);
									_tmp1176_ = _tmp1175_;
									prop = _tmp1176_;
									_tmp1177_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1177_);
									_tmp1178_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1179_ = _tmp1178_;
									member = _tmp1179_;
								}
							}
							_tmp1180_ = prop;
							_tmp1181_ = vala_symbol_get_access ((ValaSymbol*) _tmp1180_);
							_tmp1182_ = _tmp1181_;
							access = _tmp1182_;
							_tmp1183_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp1184_ = _tmp1183_;
							if (_tmp1184_) {
								ValaProperty* _tmp1185_;
								ValaPropertyAccessor* _tmp1186_;
								ValaPropertyAccessor* _tmp1187_;
								ValaProperty* _tmp1231_;
								ValaSymbolAccessibility _tmp1232_;
								ValaSymbolAccessibility _tmp1233_;
								_tmp1185_ = prop;
								_tmp1186_ = vala_property_get_set_accessor (_tmp1185_);
								_tmp1187_ = _tmp1186_;
								if (_tmp1187_ == NULL) {
									ValaSourceReference* _tmp1188_;
									ValaSourceReference* _tmp1189_;
									ValaProperty* _tmp1190_;
									gchar* _tmp1191_;
									gchar* _tmp1192_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1188_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1189_ = _tmp1188_;
									_tmp1190_ = prop;
									_tmp1191_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1190_);
									_tmp1192_ = _tmp1191_;
									vala_report_error (_tmp1189_, "Property `%s' is read-only", _tmp1192_);
									_g_free0 (_tmp1192_);
									result = FALSE;
									_vala_iterable_unref0 (visited_types);
									return result;
								} else {
									gboolean _tmp1193_ = FALSE;
									ValaProperty* _tmp1194_;
									ValaPropertyAccessor* _tmp1195_;
									ValaPropertyAccessor* _tmp1196_;
									gboolean _tmp1197_;
									gboolean _tmp1198_;
									_tmp1194_ = prop;
									_tmp1195_ = vala_property_get_set_accessor (_tmp1194_);
									_tmp1196_ = _tmp1195_;
									_tmp1197_ = vala_property_accessor_get_writable (_tmp1196_);
									_tmp1198_ = _tmp1197_;
									if (!_tmp1198_) {
										ValaProperty* _tmp1199_;
										ValaPropertyAccessor* _tmp1200_;
										ValaPropertyAccessor* _tmp1201_;
										gboolean _tmp1202_;
										gboolean _tmp1203_;
										_tmp1199_ = prop;
										_tmp1200_ = vala_property_get_set_accessor (_tmp1199_);
										_tmp1201_ = _tmp1200_;
										_tmp1202_ = vala_property_accessor_get_construction (_tmp1201_);
										_tmp1203_ = _tmp1202_;
										_tmp1193_ = _tmp1203_;
									} else {
										_tmp1193_ = FALSE;
									}
									if (_tmp1193_) {
										ValaSemanticAnalyzer* _tmp1204_;
										ValaSemanticAnalyzer* _tmp1205_;
										ValaMethod* _tmp1206_;
										_tmp1204_ = vala_code_context_get_analyzer (context);
										_tmp1205_ = _tmp1204_;
										_tmp1206_ = vala_semantic_analyzer_find_current_method (_tmp1205_);
										if (VALA_IS_CREATION_METHOD (_tmp1206_)) {
											ValaSourceReference* _tmp1207_;
											ValaSourceReference* _tmp1208_;
											vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
											_tmp1207_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
											_tmp1208_ = _tmp1207_;
											vala_report_error (_tmp1208_, "Cannot assign to construct-only properties, use Object (property: valu" \
"e) constructor chain up");
											result = FALSE;
											_vala_iterable_unref0 (visited_types);
											return result;
										} else {
											ValaSemanticAnalyzer* _tmp1209_;
											ValaSemanticAnalyzer* _tmp1210_;
											_tmp1209_ = vala_code_context_get_analyzer (context);
											_tmp1210_ = _tmp1209_;
											if (vala_semantic_analyzer_is_in_constructor (_tmp1210_)) {
												ValaSemanticAnalyzer* _tmp1211_;
												ValaSemanticAnalyzer* _tmp1212_;
												ValaTypeSymbol* _tmp1213_;
												ValaTypeSymbol* _tmp1214_;
												ValaProperty* _tmp1215_;
												ValaSymbol* _tmp1216_;
												ValaSymbol* _tmp1217_;
												_tmp1211_ = vala_code_context_get_analyzer (context);
												_tmp1212_ = _tmp1211_;
												_tmp1213_ = vala_semantic_analyzer_get_current_type_symbol (_tmp1212_);
												_tmp1214_ = _tmp1213_;
												_tmp1215_ = prop;
												_tmp1216_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1215_);
												_tmp1217_ = _tmp1216_;
												if (!vala_typesymbol_is_subtype_of (_tmp1214_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1217_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))) {
													ValaSourceReference* _tmp1218_;
													ValaSourceReference* _tmp1219_;
													ValaProperty* _tmp1220_;
													gchar* _tmp1221_;
													gchar* _tmp1222_;
													ValaSemanticAnalyzer* _tmp1223_;
													ValaSemanticAnalyzer* _tmp1224_;
													ValaTypeSymbol* _tmp1225_;
													ValaTypeSymbol* _tmp1226_;
													gchar* _tmp1227_;
													gchar* _tmp1228_;
													vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
													_tmp1218_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
													_tmp1219_ = _tmp1218_;
													_tmp1220_ = prop;
													_tmp1221_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1220_);
													_tmp1222_ = _tmp1221_;
													_tmp1223_ = vala_code_context_get_analyzer (context);
													_tmp1224_ = _tmp1223_;
													_tmp1225_ = vala_semantic_analyzer_get_current_type_symbol (_tmp1224_);
													_tmp1226_ = _tmp1225_;
													_tmp1227_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1226_);
													_tmp1228_ = _tmp1227_;
													vala_report_error (_tmp1219_, "Cannot assign to construct-only property `%s' in `construct' of `%s'", _tmp1222_, _tmp1228_);
													_g_free0 (_tmp1228_);
													_g_free0 (_tmp1222_);
													result = FALSE;
													_vala_iterable_unref0 (visited_types);
													return result;
												}
											} else {
												ValaSourceReference* _tmp1229_;
												ValaSourceReference* _tmp1230_;
												vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
												_tmp1229_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp1230_ = _tmp1229_;
												vala_report_error (_tmp1230_, "Cannot assign to construct-only property in this context");
												result = FALSE;
												_vala_iterable_unref0 (visited_types);
												return result;
											}
										}
									}
								}
								_tmp1231_ = prop;
								_tmp1232_ = vala_symbol_get_access ((ValaSymbol*) _tmp1231_);
								_tmp1233_ = _tmp1232_;
								if (_tmp1233_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1234_;
									ValaPropertyAccessor* _tmp1235_;
									ValaPropertyAccessor* _tmp1236_;
									ValaSymbolAccessibility _tmp1237_;
									ValaSymbolAccessibility _tmp1238_;
									_tmp1234_ = prop;
									_tmp1235_ = vala_property_get_set_accessor (_tmp1234_);
									_tmp1236_ = _tmp1235_;
									_tmp1237_ = vala_symbol_get_access ((ValaSymbol*) _tmp1236_);
									_tmp1238_ = _tmp1237_;
									access = _tmp1238_;
								} else {
									gboolean _tmp1239_ = FALSE;
									ValaProperty* _tmp1240_;
									ValaSymbolAccessibility _tmp1241_;
									ValaSymbolAccessibility _tmp1242_;
									_tmp1240_ = prop;
									_tmp1241_ = vala_symbol_get_access ((ValaSymbol*) _tmp1240_);
									_tmp1242_ = _tmp1241_;
									if (_tmp1242_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1243_;
										ValaPropertyAccessor* _tmp1244_;
										ValaPropertyAccessor* _tmp1245_;
										ValaSymbolAccessibility _tmp1246_;
										ValaSymbolAccessibility _tmp1247_;
										_tmp1243_ = prop;
										_tmp1244_ = vala_property_get_set_accessor (_tmp1243_);
										_tmp1245_ = _tmp1244_;
										_tmp1246_ = vala_symbol_get_access ((ValaSymbol*) _tmp1245_);
										_tmp1247_ = _tmp1246_;
										_tmp1239_ = _tmp1247_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1239_ = FALSE;
									}
									if (_tmp1239_) {
										ValaProperty* _tmp1248_;
										ValaPropertyAccessor* _tmp1249_;
										ValaPropertyAccessor* _tmp1250_;
										ValaSymbolAccessibility _tmp1251_;
										ValaSymbolAccessibility _tmp1252_;
										_tmp1248_ = prop;
										_tmp1249_ = vala_property_get_set_accessor (_tmp1248_);
										_tmp1250_ = _tmp1249_;
										_tmp1251_ = vala_symbol_get_access ((ValaSymbol*) _tmp1250_);
										_tmp1252_ = _tmp1251_;
										access = _tmp1252_;
									}
								}
							} else {
								ValaProperty* _tmp1253_;
								ValaPropertyAccessor* _tmp1254_;
								ValaPropertyAccessor* _tmp1255_;
								ValaProperty* _tmp1261_;
								ValaSymbolAccessibility _tmp1262_;
								ValaSymbolAccessibility _tmp1263_;
								_tmp1253_ = prop;
								_tmp1254_ = vala_property_get_get_accessor (_tmp1253_);
								_tmp1255_ = _tmp1254_;
								if (_tmp1255_ == NULL) {
									ValaSourceReference* _tmp1256_;
									ValaSourceReference* _tmp1257_;
									ValaProperty* _tmp1258_;
									gchar* _tmp1259_;
									gchar* _tmp1260_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1256_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1257_ = _tmp1256_;
									_tmp1258_ = prop;
									_tmp1259_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1258_);
									_tmp1260_ = _tmp1259_;
									vala_report_error (_tmp1257_, "Property `%s' is write-only", _tmp1260_);
									_g_free0 (_tmp1260_);
									result = FALSE;
									_vala_iterable_unref0 (visited_types);
									return result;
								}
								_tmp1261_ = prop;
								_tmp1262_ = vala_symbol_get_access ((ValaSymbol*) _tmp1261_);
								_tmp1263_ = _tmp1262_;
								if (_tmp1263_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1264_;
									ValaPropertyAccessor* _tmp1265_;
									ValaPropertyAccessor* _tmp1266_;
									ValaSymbolAccessibility _tmp1267_;
									ValaSymbolAccessibility _tmp1268_;
									_tmp1264_ = prop;
									_tmp1265_ = vala_property_get_get_accessor (_tmp1264_);
									_tmp1266_ = _tmp1265_;
									_tmp1267_ = vala_symbol_get_access ((ValaSymbol*) _tmp1266_);
									_tmp1268_ = _tmp1267_;
									access = _tmp1268_;
								} else {
									gboolean _tmp1269_ = FALSE;
									ValaProperty* _tmp1270_;
									ValaSymbolAccessibility _tmp1271_;
									ValaSymbolAccessibility _tmp1272_;
									_tmp1270_ = prop;
									_tmp1271_ = vala_symbol_get_access ((ValaSymbol*) _tmp1270_);
									_tmp1272_ = _tmp1271_;
									if (_tmp1272_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1273_;
										ValaPropertyAccessor* _tmp1274_;
										ValaPropertyAccessor* _tmp1275_;
										ValaSymbolAccessibility _tmp1276_;
										ValaSymbolAccessibility _tmp1277_;
										_tmp1273_ = prop;
										_tmp1274_ = vala_property_get_get_accessor (_tmp1273_);
										_tmp1275_ = _tmp1274_;
										_tmp1276_ = vala_symbol_get_access ((ValaSymbol*) _tmp1275_);
										_tmp1277_ = _tmp1276_;
										_tmp1269_ = _tmp1277_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1269_ = FALSE;
									}
									if (_tmp1269_) {
										ValaProperty* _tmp1278_;
										ValaPropertyAccessor* _tmp1279_;
										ValaPropertyAccessor* _tmp1280_;
										ValaSymbolAccessibility _tmp1281_;
										ValaSymbolAccessibility _tmp1282_;
										_tmp1278_ = prop;
										_tmp1279_ = vala_property_get_get_accessor (_tmp1278_);
										_tmp1280_ = _tmp1279_;
										_tmp1281_ = vala_symbol_get_access ((ValaSymbol*) _tmp1280_);
										_tmp1282_ = _tmp1281_;
										access = _tmp1282_;
									}
								}
							}
							_tmp1283_ = prop;
							_tmp1284_ = vala_property_get_binding (_tmp1283_);
							_tmp1285_ = _tmp1284_;
							instance = _tmp1285_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1286_ = prop;
							_tmp1287_ = vala_property_get_property_type (_tmp1286_);
							_tmp1288_ = _tmp1287_;
							if (VALA_IS_GENERIC_TYPE (_tmp1288_)) {
								generics = TRUE;
							}
						} else {
							ValaSymbol* _tmp1289_;
							_tmp1289_ = member;
							if (VALA_IS_SIGNAL (_tmp1289_)) {
								ValaSymbol* _tmp1290_;
								ValaSymbolAccessibility _tmp1291_;
								ValaSymbolAccessibility _tmp1292_;
								instance = TRUE;
								_tmp1290_ = member;
								_tmp1291_ = vala_symbol_get_access (_tmp1290_);
								_tmp1292_ = _tmp1291_;
								access = _tmp1292_;
							} else {
								gboolean _tmp1293_ = FALSE;
								gboolean _tmp1294_;
								_tmp1294_ = self->priv->_creation_member;
								if (!_tmp1294_) {
									ValaSymbol* _tmp1295_;
									_tmp1295_ = member;
									_tmp1293_ = VALA_IS_ERROR_CODE (_tmp1295_);
								} else {
									_tmp1293_ = FALSE;
								}
								if (_tmp1293_) {
									ValaSymbol* _tmp1296_;
									ValaConstant* _tmp1297_;
									ValaConstant* _tmp1298_;
									ValaSymbol* _tmp1299_;
									ValaSymbol* _tmp1300_;
									_tmp1296_ = member;
									_tmp1297_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp1296_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp1298_ = _tmp1297_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1298_);
									_tmp1299_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1300_ = _tmp1299_;
									member = _tmp1300_;
								}
							}
						}
					}
				}
			}
		}
	}
	parent = (ValaCodeNode*) self;
	while (TRUE) {
		ValaCodeNode* _tmp1301_;
		ValaSymbol* _tmp1302_;
		ValaCodeNode* _tmp1303_;
		ValaCodeNode* _tmp1304_;
		ValaCodeNode* _tmp1305_;
		gboolean _tmp1306_ = FALSE;
		ValaCodeNode* _tmp1307_;
		_tmp1301_ = parent;
		_tmp1302_ = member;
		if (!(_tmp1301_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1302_, VALA_TYPE_CODE_NODE, ValaCodeNode))) {
			break;
		}
		_tmp1303_ = parent;
		_tmp1304_ = vala_code_node_get_parent_node (_tmp1303_);
		_tmp1305_ = _tmp1304_;
		parent = _tmp1305_;
		_tmp1307_ = parent;
		if (_tmp1307_ == NULL) {
			_tmp1306_ = TRUE;
		} else {
			ValaCodeNode* _tmp1308_;
			ValaSymbol* _tmp1309_;
			_tmp1308_ = parent;
			_tmp1309_ = member;
			_tmp1306_ = _tmp1308_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1309_, VALA_TYPE_CODE_NODE, ValaCodeNode);
		}
		if (_tmp1306_) {
			break;
		}
	}
	_tmp1310_ = parent;
	_tmp1311_ = member;
	if (_tmp1310_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1311_, VALA_TYPE_CODE_NODE, ValaCodeNode)) {
		ValaSymbol* _tmp1312_;
		_tmp1312_ = member;
		vala_symbol_set_used (_tmp1312_, TRUE);
	}
	_tmp1313_ = member;
	_tmp1314_ = vala_symbol_get_version (_tmp1313_);
	_tmp1315_ = _tmp1314_;
	_tmp1316_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1317_ = _tmp1316_;
	vala_version_attribute_check (_tmp1315_, context, _tmp1317_);
	if (access == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1319_;
		ValaSymbol* _tmp1320_;
		ValaSymbol* _tmp1321_;
		_tmp1319_ = member;
		_tmp1320_ = vala_symbol_get_parent_symbol (_tmp1319_);
		_tmp1321_ = _tmp1320_;
		_tmp1318_ = VALA_IS_TYPESYMBOL (_tmp1321_);
	} else {
		_tmp1318_ = FALSE;
	}
	if (_tmp1318_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1322_;
		ValaSymbol* _tmp1323_;
		ValaSymbol* _tmp1324_;
		gboolean in_subtype = FALSE;
		_tmp1322_ = member;
		_tmp1323_ = vala_symbol_get_parent_symbol (_tmp1322_);
		_tmp1324_ = _tmp1323_;
		target_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp1324_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1325_;
			ValaSemanticAnalyzer* _tmp1326_;
			ValaSymbol* _tmp1327_;
			ValaSymbol* _tmp1328_;
			ValaSymbol* _tmp1329_;
			_tmp1325_ = vala_code_context_get_analyzer (context);
			_tmp1326_ = _tmp1325_;
			_tmp1327_ = vala_semantic_analyzer_get_current_symbol (_tmp1326_);
			_tmp1328_ = _tmp1327_;
			_tmp1329_ = _vala_code_node_ref0 (_tmp1328_);
			this_symbol = _tmp1329_;
			{
				gboolean _tmp1330_ = FALSE;
				_tmp1330_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1335_;
					ValaSymbol* _tmp1336_;
					ValaTypeSymbol* _tmp1337_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1338_;
					gboolean _tmp1339_ = FALSE;
					ValaClass* _tmp1340_;
					if (!_tmp1330_) {
						ValaSymbol* _tmp1331_;
						ValaSymbol* _tmp1332_;
						ValaSymbol* _tmp1333_;
						ValaSymbol* _tmp1334_;
						_tmp1331_ = this_symbol;
						_tmp1332_ = vala_symbol_get_parent_symbol (_tmp1331_);
						_tmp1333_ = _tmp1332_;
						_tmp1334_ = _vala_code_node_ref0 (_tmp1333_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1334_;
					}
					_tmp1330_ = FALSE;
					_tmp1335_ = this_symbol;
					if (!(_tmp1335_ != NULL)) {
						break;
					}
					_tmp1336_ = this_symbol;
					_tmp1337_ = target_type;
					if (_tmp1336_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1337_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1338_ = this_symbol;
					cl = VALA_IS_CLASS (_tmp1338_) ? ((ValaClass*) _tmp1338_) : NULL;
					_tmp1340_ = cl;
					if (_tmp1340_ != NULL) {
						ValaClass* _tmp1341_;
						ValaTypeSymbol* _tmp1342_;
						_tmp1341_ = cl;
						_tmp1342_ = target_type;
						_tmp1339_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1341_, _tmp1342_);
					} else {
						_tmp1339_ = FALSE;
					}
					if (_tmp1339_) {
						in_subtype = TRUE;
						break;
					}
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1343_;
			ValaSourceReference* _tmp1344_;
			ValaSymbol* _tmp1345_;
			gchar* _tmp1346_;
			gchar* _tmp1347_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1343_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1344_ = _tmp1343_;
			_tmp1345_ = member;
			_tmp1346_ = vala_symbol_get_full_name (_tmp1345_);
			_tmp1347_ = _tmp1346_;
			vala_report_error (_tmp1344_, "Access to protected member `%s' denied", _tmp1347_);
			_g_free0 (_tmp1347_);
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	} else {
		if (access == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1348_;
			ValaSymbol* _tmp1349_;
			ValaSymbol* _tmp1350_;
			gboolean in_target_type = FALSE;
			_tmp1348_ = member;
			_tmp1349_ = vala_symbol_get_parent_symbol (_tmp1348_);
			_tmp1350_ = _tmp1349_;
			target_type = _tmp1350_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1351_;
				ValaSemanticAnalyzer* _tmp1352_;
				ValaSymbol* _tmp1353_;
				ValaSymbol* _tmp1354_;
				ValaSymbol* _tmp1355_;
				_tmp1351_ = vala_code_context_get_analyzer (context);
				_tmp1352_ = _tmp1351_;
				_tmp1353_ = vala_semantic_analyzer_get_current_symbol (_tmp1352_);
				_tmp1354_ = _tmp1353_;
				_tmp1355_ = _vala_code_node_ref0 (_tmp1354_);
				this_symbol = _tmp1355_;
				{
					gboolean _tmp1356_ = FALSE;
					_tmp1356_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1361_;
						ValaSymbol* _tmp1362_;
						ValaSymbol* _tmp1363_;
						if (!_tmp1356_) {
							ValaSymbol* _tmp1357_;
							ValaSymbol* _tmp1358_;
							ValaSymbol* _tmp1359_;
							ValaSymbol* _tmp1360_;
							_tmp1357_ = this_symbol;
							_tmp1358_ = vala_symbol_get_parent_symbol (_tmp1357_);
							_tmp1359_ = _tmp1358_;
							_tmp1360_ = _vala_code_node_ref0 (_tmp1359_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1360_;
						}
						_tmp1356_ = FALSE;
						_tmp1361_ = this_symbol;
						if (!(_tmp1361_ != NULL)) {
							break;
						}
						_tmp1362_ = target_type;
						_tmp1363_ = this_symbol;
						if (_tmp1362_ == _tmp1363_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1364_;
				ValaSourceReference* _tmp1365_;
				ValaSymbol* _tmp1366_;
				gchar* _tmp1367_;
				gchar* _tmp1368_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1364_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1365_ = _tmp1364_;
				_tmp1366_ = member;
				_tmp1367_ = vala_symbol_get_full_name (_tmp1366_);
				_tmp1368_ = _tmp1367_;
				vala_report_error (_tmp1365_, "Access to private member `%s' denied", _tmp1368_);
				_g_free0 (_tmp1368_);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
		}
	}
	if (generics) {
		ValaExpression* _tmp1370_;
		ValaExpression* _tmp1371_;
		_tmp1370_ = vala_member_access_get_inner (self);
		_tmp1371_ = _tmp1370_;
		_tmp1369_ = _tmp1371_ != NULL;
	} else {
		_tmp1369_ = FALSE;
	}
	if (_tmp1369_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1372_;
		ValaExpression* _tmp1373_;
		ValaDataType* _tmp1374_;
		ValaDataType* _tmp1375_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1376_;
		ValaExpression* _tmp1377_;
		ValaDataType* _tmp1378_;
		ValaDataType* _tmp1379_;
		ValaPointerType* _tmp1380_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1384_;
		gboolean _tmp1385_ = FALSE;
		gboolean _tmp1386_ = FALSE;
		ValaObjectType* _tmp1387_;
		_tmp1372_ = vala_member_access_get_inner (self);
		_tmp1373_ = _tmp1372_;
		_tmp1374_ = vala_expression_get_value_type (_tmp1373_);
		_tmp1375_ = _tmp1374_;
		instance_type = _tmp1375_;
		_tmp1376_ = vala_member_access_get_inner (self);
		_tmp1377_ = _tmp1376_;
		_tmp1378_ = vala_expression_get_value_type (_tmp1377_);
		_tmp1379_ = _tmp1378_;
		pointer_type = VALA_IS_POINTER_TYPE (_tmp1379_) ? ((ValaPointerType*) _tmp1379_) : NULL;
		_tmp1380_ = pointer_type;
		if (_tmp1380_ != NULL) {
			ValaPointerType* _tmp1381_;
			ValaDataType* _tmp1382_;
			ValaDataType* _tmp1383_;
			_tmp1381_ = pointer_type;
			_tmp1382_ = vala_pointer_type_get_base_type (_tmp1381_);
			_tmp1383_ = _tmp1382_;
			instance_type = _tmp1383_;
		}
		_tmp1384_ = instance_type;
		object_type = VALA_IS_OBJECT_TYPE (_tmp1384_) ? ((ValaObjectType*) _tmp1384_) : NULL;
		_tmp1387_ = object_type;
		if (_tmp1387_ != NULL) {
			ValaObjectType* _tmp1388_;
			ValaObjectTypeSymbol* _tmp1389_;
			ValaObjectTypeSymbol* _tmp1390_;
			_tmp1388_ = object_type;
			_tmp1389_ = vala_object_type_get_object_type_symbol (_tmp1388_);
			_tmp1390_ = _tmp1389_;
			_tmp1386_ = vala_object_type_symbol_has_type_parameters (_tmp1390_);
		} else {
			_tmp1386_ = FALSE;
		}
		if (_tmp1386_) {
			ValaDataType* _tmp1391_;
			_tmp1391_ = instance_type;
			_tmp1385_ = !vala_data_type_has_type_arguments (_tmp1391_);
		} else {
			_tmp1385_ = FALSE;
		}
		if (_tmp1385_) {
			ValaExpression* _tmp1392_;
			ValaExpression* _tmp1393_;
			ValaSourceReference* _tmp1394_;
			ValaSourceReference* _tmp1395_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1392_ = vala_member_access_get_inner (self);
			_tmp1393_ = _tmp1392_;
			_tmp1394_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1393_);
			_tmp1395_ = _tmp1394_;
			vala_report_error (_tmp1395_, "missing generic type arguments");
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	}
	if (instance) {
		_tmp1397_ = !may_access_instance_members;
	} else {
		_tmp1397_ = FALSE;
	}
	if (_tmp1397_) {
		_tmp1396_ = TRUE;
	} else {
		gboolean _tmp1398_ = FALSE;
		if (klass) {
			_tmp1398_ = !may_access_klass_members;
		} else {
			_tmp1398_ = FALSE;
		}
		_tmp1396_ = _tmp1398_;
	}
	if (_tmp1396_) {
		ValaSymbol* _tmp1399_;
		ValaSymbol* _tmp1400_;
		ValaDataType* _tmp1431_;
		ValaDataType* _tmp1432_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1399_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1400_ = _tmp1399_;
		if (VALA_IS_METHOD (_tmp1400_)) {
			ValaSemanticAnalyzer* _tmp1401_;
			ValaSemanticAnalyzer* _tmp1402_;
			ValaSymbol* _tmp1403_;
			ValaSymbol* _tmp1404_;
			gboolean _tmp1405_;
			gboolean _tmp1406_;
			ValaDataType* _tmp1407_;
			ValaDataType* _tmp1408_;
			ValaDataType* _tmp1409_;
			ValaDataType* _tmp1410_;
			ValaSourceReference* _tmp1411_;
			ValaSourceReference* _tmp1412_;
			_tmp1401_ = vala_code_context_get_analyzer (context);
			_tmp1402_ = _tmp1401_;
			_tmp1403_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1404_ = _tmp1403_;
			_tmp1405_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1406_ = _tmp1405_;
			_tmp1407_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1402_, _tmp1404_, _tmp1406_);
			_tmp1408_ = _tmp1407_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1408_);
			_vala_code_node_unref0 (_tmp1408_);
			_tmp1409_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1410_ = _tmp1409_;
			_tmp1411_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1412_ = _tmp1411_;
			vala_code_node_set_source_reference ((ValaCodeNode*) _tmp1410_, _tmp1412_);
		} else {
			ValaSymbol* _tmp1413_;
			ValaSymbol* _tmp1414_;
			_tmp1413_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1414_ = _tmp1413_;
			if (VALA_IS_FIELD (_tmp1414_)) {
				ValaSymbol* _tmp1415_;
				ValaSymbol* _tmp1416_;
				ValaSourceReference* _tmp1417_;
				ValaSourceReference* _tmp1418_;
				ValaFieldPrototype* _tmp1419_;
				ValaFieldPrototype* _tmp1420_;
				_tmp1415_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1416_ = _tmp1415_;
				_tmp1417_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1418_ = _tmp1417_;
				_tmp1419_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1416_, VALA_TYPE_FIELD, ValaField), _tmp1418_);
				_tmp1420_ = _tmp1419_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1420_);
				_vala_code_node_unref0 (_tmp1420_);
			} else {
				ValaSymbol* _tmp1421_;
				ValaSymbol* _tmp1422_;
				_tmp1421_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1422_ = _tmp1421_;
				if (VALA_IS_PROPERTY (_tmp1422_)) {
					ValaSymbol* _tmp1423_;
					ValaSymbol* _tmp1424_;
					ValaSourceReference* _tmp1425_;
					ValaSourceReference* _tmp1426_;
					ValaPropertyPrototype* _tmp1427_;
					ValaPropertyPrototype* _tmp1428_;
					_tmp1423_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1424_ = _tmp1423_;
					_tmp1425_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1426_ = _tmp1425_;
					_tmp1427_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1424_, VALA_TYPE_PROPERTY, ValaProperty), _tmp1426_);
					_tmp1428_ = _tmp1427_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1428_);
					_vala_code_node_unref0 (_tmp1428_);
				} else {
					ValaInvalidType* _tmp1429_;
					ValaInvalidType* _tmp1430_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp1429_ = vala_invalid_type_new ();
					_tmp1430_ = _tmp1429_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1430_);
					_vala_code_node_unref0 (_tmp1430_);
				}
			}
		}
		_tmp1431_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1432_ = _tmp1431_;
		if (_tmp1432_ != NULL) {
			ValaDataType* _tmp1433_;
			ValaDataType* _tmp1434_;
			ValaDataType* _tmp1435_;
			ValaDataType* _tmp1436_;
			gboolean _tmp1437_;
			gboolean _tmp1438_;
			_tmp1433_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1434_ = _tmp1433_;
			_tmp1435_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1436_ = _tmp1435_;
			_tmp1437_ = vala_data_type_get_value_owned (_tmp1436_);
			_tmp1438_ = _tmp1437_;
			vala_data_type_set_value_owned (_tmp1434_, _tmp1438_);
		}
	} else {
		gboolean _tmp1439_ = FALSE;
		gboolean _tmp1460_ = FALSE;
		gboolean _tmp1461_ = FALSE;
		gboolean _tmp1462_ = FALSE;
		gboolean _tmp1463_ = FALSE;
		gboolean _tmp1504_ = FALSE;
		gboolean _tmp1505_ = FALSE;
		gboolean _tmp1506_ = FALSE;
		gboolean _tmp1507_ = FALSE;
		gboolean _tmp1508_ = FALSE;
		gboolean _tmp1509_;
		gboolean _tmp1510_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1535_;
		ValaSymbol* _tmp1536_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1537_;
		ValaExpression* _tmp1538_;
		gboolean _tmp1539_ = FALSE;
		gboolean _tmp1540_ = FALSE;
		gboolean _tmp1541_ = FALSE;
		gboolean _tmp1542_ = FALSE;
		gboolean _tmp1543_ = FALSE;
		ValaMethod* _tmp1544_;
		ValaSemanticAnalyzer* _tmp1584_;
		ValaSemanticAnalyzer* _tmp1585_;
		ValaSymbol* _tmp1586_;
		ValaSymbol* _tmp1587_;
		gboolean _tmp1588_;
		gboolean _tmp1589_;
		ValaDataType* _tmp1590_;
		ValaDataType* _tmp1591_;
		gboolean _tmp1592_ = FALSE;
		ValaExpression* _tmp1593_;
		ValaExpression* _tmp1594_;
		ValaSymbol* _tmp1607_;
		ValaSymbol* _tmp1608_;
		gboolean _tmp1682_ = FALSE;
		gboolean _tmp1683_ = FALSE;
		ValaExpression* _tmp1684_;
		ValaExpression* _tmp1685_;
		if (instance) {
			ValaExpression* _tmp1440_;
			ValaExpression* _tmp1441_;
			_tmp1440_ = vala_member_access_get_inner (self);
			_tmp1441_ = _tmp1440_;
			_tmp1439_ = _tmp1441_ == NULL;
		} else {
			_tmp1439_ = FALSE;
		}
		if (_tmp1439_) {
			ValaSourceReference* _tmp1442_;
			ValaSourceReference* _tmp1443_;
			ValaMemberAccess* _tmp1444_;
			ValaMemberAccess* _tmp1445_;
			ValaExpression* _tmp1446_;
			ValaExpression* _tmp1447_;
			ValaParameter* _tmp1448_;
			ValaDataType* _tmp1449_;
			ValaDataType* _tmp1450_;
			ValaDataType* _tmp1451_;
			ValaDataType* _tmp1452_;
			ValaExpression* _tmp1453_;
			ValaExpression* _tmp1454_;
			ValaDataType* _tmp1455_;
			ValaDataType* _tmp1456_;
			ValaExpression* _tmp1457_;
			ValaExpression* _tmp1458_;
			ValaParameter* _tmp1459_;
			_tmp1442_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1443_ = _tmp1442_;
			_tmp1444_ = vala_member_access_new (NULL, "this", _tmp1443_);
			_tmp1445_ = _tmp1444_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1445_);
			_vala_code_node_unref0 (_tmp1445_);
			_tmp1446_ = vala_member_access_get_inner (self);
			_tmp1447_ = _tmp1446_;
			_tmp1448_ = this_parameter;
			_tmp1449_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1448_);
			_tmp1450_ = _tmp1449_;
			_tmp1451_ = vala_data_type_copy (_tmp1450_);
			_tmp1452_ = _tmp1451_;
			vala_expression_set_value_type (_tmp1447_, _tmp1452_);
			_vala_code_node_unref0 (_tmp1452_);
			_tmp1453_ = vala_member_access_get_inner (self);
			_tmp1454_ = _tmp1453_;
			_tmp1455_ = vala_expression_get_value_type (_tmp1454_);
			_tmp1456_ = _tmp1455_;
			vala_data_type_set_value_owned (_tmp1456_, FALSE);
			_tmp1457_ = vala_member_access_get_inner (self);
			_tmp1458_ = _tmp1457_;
			_tmp1459_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1458_, (ValaSymbol*) _tmp1459_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1463_ = !klass;
		} else {
			_tmp1463_ = FALSE;
		}
		if (_tmp1463_) {
			ValaSymbol* _tmp1464_;
			ValaSymbol* _tmp1465_;
			_tmp1464_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1465_ = _tmp1464_;
			_tmp1462_ = !VALA_IS_CREATION_METHOD (_tmp1465_);
		} else {
			_tmp1462_ = FALSE;
		}
		if (_tmp1462_) {
			_tmp1461_ = may_access_instance_members;
		} else {
			_tmp1461_ = FALSE;
		}
		if (_tmp1461_) {
			ValaExpression* _tmp1466_;
			ValaExpression* _tmp1467_;
			_tmp1466_ = vala_member_access_get_inner (self);
			_tmp1467_ = _tmp1466_;
			_tmp1460_ = _tmp1467_ != NULL;
		} else {
			_tmp1460_ = FALSE;
		}
		if (_tmp1460_) {
			ValaExpression* _tmp1468_;
			ValaExpression* _tmp1469_;
			ValaSymbol* _tmp1470_;
			ValaSymbol* _tmp1471_;
			_tmp1468_ = vala_member_access_get_inner (self);
			_tmp1469_ = _tmp1468_;
			_tmp1470_ = vala_expression_get_symbol_reference (_tmp1469_);
			_tmp1471_ = _tmp1470_;
			if (VALA_IS_METHOD (_tmp1471_)) {
			} else {
				ValaSourceReference* _tmp1472_;
				ValaSourceReference* _tmp1473_;
				ValaSymbol* _tmp1474_;
				ValaSymbol* _tmp1475_;
				gchar* _tmp1476_;
				gchar* _tmp1477_;
				ValaSymbol* inner_sym = NULL;
				ValaSymbol* _tmp1478_;
				ValaSymbol* _tmp1479_;
				ValaSymbol* _tmp1480_;
				ValaSymbol* _tmp1481_;
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp1501_;
				ValaExpression* _tmp1502_;
				ValaExpression* _tmp1503_;
				_tmp1472_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1473_ = _tmp1472_;
				_tmp1474_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1475_ = _tmp1474_;
				_tmp1476_ = vala_symbol_get_full_name (_tmp1475_);
				_tmp1477_ = _tmp1476_;
				vala_report_warning (_tmp1473_, "Access to static member `%s' with an instance reference", _tmp1477_);
				_g_free0 (_tmp1477_);
				_tmp1478_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1479_ = _tmp1478_;
				_tmp1480_ = vala_symbol_get_parent_symbol (_tmp1479_);
				_tmp1481_ = _tmp1480_;
				inner_sym = _tmp1481_;
				inner_ma = self;
				while (TRUE) {
					gboolean _tmp1482_ = FALSE;
					ValaSymbol* _tmp1483_;
					ValaMemberAccess* _tmp1487_;
					ValaSymbol* _tmp1488_;
					const gchar* _tmp1489_;
					const gchar* _tmp1490_;
					ValaSourceReference* _tmp1491_;
					ValaSourceReference* _tmp1492_;
					ValaMemberAccess* _tmp1493_;
					ValaMemberAccess* _tmp1494_;
					ValaMemberAccess* _tmp1495_;
					ValaExpression* _tmp1496_;
					ValaExpression* _tmp1497_;
					ValaSymbol* _tmp1498_;
					ValaSymbol* _tmp1499_;
					ValaSymbol* _tmp1500_;
					_tmp1483_ = inner_sym;
					if (_tmp1483_ != NULL) {
						ValaSymbol* _tmp1484_;
						const gchar* _tmp1485_;
						const gchar* _tmp1486_;
						_tmp1484_ = inner_sym;
						_tmp1485_ = vala_symbol_get_name (_tmp1484_);
						_tmp1486_ = _tmp1485_;
						_tmp1482_ = _tmp1486_ != NULL;
					} else {
						_tmp1482_ = FALSE;
					}
					if (!_tmp1482_) {
						break;
					}
					_tmp1487_ = inner_ma;
					_tmp1488_ = inner_sym;
					_tmp1489_ = vala_symbol_get_name (_tmp1488_);
					_tmp1490_ = _tmp1489_;
					_tmp1491_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1492_ = _tmp1491_;
					_tmp1493_ = vala_member_access_new (NULL, _tmp1490_, _tmp1492_);
					_tmp1494_ = _tmp1493_;
					vala_member_access_set_inner (_tmp1487_, (ValaExpression*) _tmp1494_);
					_vala_code_node_unref0 (_tmp1494_);
					_tmp1495_ = inner_ma;
					_tmp1496_ = vala_member_access_get_inner (_tmp1495_);
					_tmp1497_ = _tmp1496_;
					inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp1497_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
					_tmp1498_ = inner_sym;
					_tmp1499_ = vala_symbol_get_parent_symbol (_tmp1498_);
					_tmp1500_ = _tmp1499_;
					inner_sym = _tmp1500_;
				}
				_tmp1501_ = inner_ma;
				vala_member_access_set_qualified (_tmp1501_, TRUE);
				_tmp1502_ = vala_member_access_get_inner (self);
				_tmp1503_ = _tmp1502_;
				vala_code_node_check ((ValaCodeNode*) _tmp1503_, context);
			}
		}
		_tmp1509_ = vala_code_context_get_experimental_non_null (context);
		_tmp1510_ = _tmp1509_;
		if (_tmp1510_) {
			_tmp1508_ = instance;
		} else {
			_tmp1508_ = FALSE;
		}
		if (_tmp1508_) {
			ValaExpression* _tmp1511_;
			ValaExpression* _tmp1512_;
			ValaDataType* _tmp1513_;
			ValaDataType* _tmp1514_;
			gboolean _tmp1515_;
			gboolean _tmp1516_;
			_tmp1511_ = vala_member_access_get_inner (self);
			_tmp1512_ = _tmp1511_;
			_tmp1513_ = vala_expression_get_value_type (_tmp1512_);
			_tmp1514_ = _tmp1513_;
			_tmp1515_ = vala_data_type_get_nullable (_tmp1514_);
			_tmp1516_ = _tmp1515_;
			_tmp1507_ = _tmp1516_;
		} else {
			_tmp1507_ = FALSE;
		}
		if (_tmp1507_) {
			ValaExpression* _tmp1517_;
			ValaExpression* _tmp1518_;
			ValaDataType* _tmp1519_;
			ValaDataType* _tmp1520_;
			_tmp1517_ = vala_member_access_get_inner (self);
			_tmp1518_ = _tmp1517_;
			_tmp1519_ = vala_expression_get_value_type (_tmp1518_);
			_tmp1520_ = _tmp1519_;
			_tmp1506_ = !VALA_IS_POINTER_TYPE (_tmp1520_);
		} else {
			_tmp1506_ = FALSE;
		}
		if (_tmp1506_) {
			ValaExpression* _tmp1521_;
			ValaExpression* _tmp1522_;
			ValaDataType* _tmp1523_;
			ValaDataType* _tmp1524_;
			_tmp1521_ = vala_member_access_get_inner (self);
			_tmp1522_ = _tmp1521_;
			_tmp1523_ = vala_expression_get_value_type (_tmp1522_);
			_tmp1524_ = _tmp1523_;
			_tmp1505_ = !VALA_IS_GENERIC_TYPE (_tmp1524_);
		} else {
			_tmp1505_ = FALSE;
		}
		if (_tmp1505_) {
			ValaExpression* _tmp1525_;
			ValaExpression* _tmp1526_;
			ValaDataType* _tmp1527_;
			ValaDataType* _tmp1528_;
			_tmp1525_ = vala_member_access_get_inner (self);
			_tmp1526_ = _tmp1525_;
			_tmp1527_ = vala_expression_get_value_type (_tmp1526_);
			_tmp1528_ = _tmp1527_;
			_tmp1504_ = !VALA_IS_ARRAY_TYPE (_tmp1528_);
		} else {
			_tmp1504_ = FALSE;
		}
		if (_tmp1504_) {
			ValaSourceReference* _tmp1529_;
			ValaSourceReference* _tmp1530_;
			ValaSymbol* _tmp1531_;
			ValaSymbol* _tmp1532_;
			gchar* _tmp1533_;
			gchar* _tmp1534_;
			_tmp1529_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1530_ = _tmp1529_;
			_tmp1531_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1532_ = _tmp1531_;
			_tmp1533_ = vala_symbol_get_full_name (_tmp1532_);
			_tmp1534_ = _tmp1533_;
			vala_report_error (_tmp1530_, "Access to instance member `%s' from nullable reference denied", _tmp1534_);
			_g_free0 (_tmp1534_);
		}
		_tmp1535_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1536_ = _tmp1535_;
		m = VALA_IS_METHOD (_tmp1536_) ? ((ValaMethod*) _tmp1536_) : NULL;
		_tmp1537_ = vala_member_access_get_inner (self);
		_tmp1538_ = _tmp1537_;
		inner_ma = VALA_IS_MEMBER_ACCESS (_tmp1538_) ? ((ValaMemberAccess*) _tmp1538_) : NULL;
		_tmp1544_ = m;
		if (_tmp1544_ != NULL) {
			ValaMethod* _tmp1545_;
			ValaMemberBinding _tmp1546_;
			ValaMemberBinding _tmp1547_;
			_tmp1545_ = m;
			_tmp1546_ = vala_method_get_binding (_tmp1545_);
			_tmp1547_ = _tmp1546_;
			_tmp1543_ = _tmp1547_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1543_ = FALSE;
		}
		if (_tmp1543_) {
			ValaMethod* _tmp1548_;
			ValaSymbol* _tmp1549_;
			ValaSymbol* _tmp1550_;
			_tmp1548_ = m;
			_tmp1549_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1548_);
			_tmp1550_ = _tmp1549_;
			_tmp1542_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1550_);
		} else {
			_tmp1542_ = FALSE;
		}
		if (_tmp1542_) {
			ValaExpression* _tmp1551_;
			ValaExpression* _tmp1552_;
			_tmp1551_ = vala_member_access_get_inner (self);
			_tmp1552_ = _tmp1551_;
			_tmp1541_ = _tmp1552_ != NULL;
		} else {
			_tmp1541_ = FALSE;
		}
		if (_tmp1541_) {
			ValaExpression* _tmp1553_;
			ValaExpression* _tmp1554_;
			ValaDataType* _tmp1555_;
			ValaDataType* _tmp1556_;
			_tmp1553_ = vala_member_access_get_inner (self);
			_tmp1554_ = _tmp1553_;
			_tmp1555_ = vala_expression_get_value_type (_tmp1554_);
			_tmp1556_ = _tmp1555_;
			_tmp1540_ = _tmp1556_ == NULL;
		} else {
			_tmp1540_ = FALSE;
		}
		if (_tmp1540_) {
			ValaMemberAccess* _tmp1557_;
			ValaList* _tmp1558_;
			gint _tmp1559_;
			gint _tmp1560_;
			_tmp1557_ = inner_ma;
			_tmp1558_ = _tmp1557_->priv->type_argument_list;
			_tmp1559_ = vala_collection_get_size ((ValaCollection*) _tmp1558_);
			_tmp1560_ = _tmp1559_;
			_tmp1539_ = _tmp1560_ > 0;
		} else {
			_tmp1539_ = FALSE;
		}
		if (_tmp1539_) {
			ValaExpression* _tmp1561_;
			ValaExpression* _tmp1562_;
			ValaMethod* _tmp1563_;
			ValaSymbol* _tmp1564_;
			ValaSymbol* _tmp1565_;
			ValaSourceReference* _tmp1566_;
			ValaSourceReference* _tmp1567_;
			ValaObjectType* _tmp1568_;
			ValaObjectType* _tmp1569_;
			_tmp1561_ = vala_member_access_get_inner (self);
			_tmp1562_ = _tmp1561_;
			_tmp1563_ = m;
			_tmp1564_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1563_);
			_tmp1565_ = _tmp1564_;
			_tmp1566_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1567_ = _tmp1566_;
			_tmp1568_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1565_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), _tmp1567_);
			_tmp1569_ = _tmp1568_;
			vala_expression_set_value_type (_tmp1562_, (ValaDataType*) _tmp1569_);
			_vala_code_node_unref0 (_tmp1569_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1570_;
				ValaList* _tmp1571_;
				gint _type_argument_size = 0;
				ValaList* _tmp1572_;
				gint _tmp1573_;
				gint _tmp1574_;
				gint _type_argument_index = 0;
				_tmp1570_ = inner_ma;
				_tmp1571_ = _tmp1570_->priv->type_argument_list;
				_type_argument_list = _tmp1571_;
				_tmp1572_ = _type_argument_list;
				_tmp1573_ = vala_collection_get_size ((ValaCollection*) _tmp1572_);
				_tmp1574_ = _tmp1573_;
				_type_argument_size = _tmp1574_;
				_type_argument_index = -1;
				while (TRUE) {
					gint _tmp1575_;
					gint _tmp1576_;
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1577_;
					gpointer _tmp1578_;
					ValaExpression* _tmp1579_;
					ValaExpression* _tmp1580_;
					ValaDataType* _tmp1581_;
					ValaDataType* _tmp1582_;
					ValaDataType* _tmp1583_;
					_type_argument_index = _type_argument_index + 1;
					_tmp1575_ = _type_argument_index;
					_tmp1576_ = _type_argument_size;
					if (!(_tmp1575_ < _tmp1576_)) {
						break;
					}
					_tmp1577_ = _type_argument_list;
					_tmp1578_ = vala_list_get (_tmp1577_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1578_;
					_tmp1579_ = vala_member_access_get_inner (self);
					_tmp1580_ = _tmp1579_;
					_tmp1581_ = vala_expression_get_value_type (_tmp1580_);
					_tmp1582_ = _tmp1581_;
					_tmp1583_ = type_argument;
					vala_data_type_add_type_argument (_tmp1582_, _tmp1583_);
					_vala_code_node_unref0 (type_argument);
				}
			}
		}
		_tmp1584_ = vala_code_context_get_analyzer (context);
		_tmp1585_ = _tmp1584_;
		_tmp1586_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1587_ = _tmp1586_;
		_tmp1588_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1589_ = _tmp1588_;
		_tmp1590_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1585_, _tmp1587_, _tmp1589_);
		_tmp1591_ = _tmp1590_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1591_);
		_vala_code_node_unref0 (_tmp1591_);
		_tmp1593_ = vala_member_access_get_inner (self);
		_tmp1594_ = _tmp1593_;
		if (_tmp1594_ != NULL) {
			ValaDataType* _tmp1595_;
			ValaDataType* _tmp1596_;
			_tmp1595_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1596_ = _tmp1595_;
			_tmp1592_ = _tmp1596_ != NULL;
		} else {
			_tmp1592_ = FALSE;
		}
		if (_tmp1592_) {
			ValaDataType* _tmp1597_;
			ValaDataType* _tmp1598_;
			ValaExpression* _tmp1599_;
			ValaExpression* _tmp1600_;
			ValaDataType* _tmp1601_;
			ValaDataType* _tmp1602_;
			ValaDataType* _tmp1603_;
			ValaDataType* _tmp1604_;
			_tmp1597_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1598_ = _tmp1597_;
			_tmp1599_ = vala_member_access_get_inner (self);
			_tmp1600_ = _tmp1599_;
			_tmp1601_ = vala_expression_get_value_type (_tmp1600_);
			_tmp1602_ = _tmp1601_;
			_tmp1603_ = vala_data_type_get_actual_type (_tmp1598_, _tmp1602_, NULL, (ValaCodeNode*) self);
			_tmp1604_ = _tmp1603_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1604_);
			_vala_code_node_unref0 (_tmp1604_);
		} else {
			ValaDataType* _tmp1605_;
			ValaDataType* _tmp1606_;
			_tmp1605_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1606_ = _tmp1605_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1606_);
		}
		_tmp1607_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1608_ = _tmp1607_;
		if (VALA_IS_METHOD (_tmp1608_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1609_;
			ValaSymbol* _tmp1610_;
			ValaDataType* _tmp1611_;
			ValaDataType* _tmp1612_;
			gboolean _tmp1619_ = FALSE;
			_tmp1609_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1610_ = _tmp1609_;
			method = G_TYPE_CHECK_INSTANCE_CAST (_tmp1610_, VALA_TYPE_METHOD, ValaMethod);
			_tmp1611_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1612_ = _tmp1611_;
			if (_tmp1612_ != NULL) {
				ValaDataType* _tmp1613_;
				ValaDataType* _tmp1614_;
				ValaDataType* _tmp1615_;
				ValaDataType* _tmp1616_;
				gboolean _tmp1617_;
				gboolean _tmp1618_;
				_tmp1613_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1614_ = _tmp1613_;
				_tmp1615_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1616_ = _tmp1615_;
				_tmp1617_ = vala_data_type_get_value_owned (_tmp1616_);
				_tmp1618_ = _tmp1617_;
				vala_data_type_set_value_owned (_tmp1614_, _tmp1618_);
			}
			if (instance) {
				ValaMethod* _tmp1620_;
				ValaSymbol* _tmp1621_;
				ValaSymbol* _tmp1622_;
				_tmp1620_ = method;
				_tmp1621_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1620_);
				_tmp1622_ = _tmp1621_;
				_tmp1619_ = VALA_IS_TYPESYMBOL (_tmp1622_);
			} else {
				_tmp1619_ = FALSE;
			}
			if (_tmp1619_) {
				ValaExpression* _tmp1623_;
				ValaExpression* _tmp1624_;
				ValaMethod* _tmp1625_;
				ValaSymbol* _tmp1626_;
				ValaSymbol* _tmp1627_;
				ValaDataType* _tmp1628_;
				ValaDataType* _tmp1629_;
				ValaExpression* _tmp1630_;
				ValaExpression* _tmp1631_;
				ValaDataType* _tmp1632_;
				ValaDataType* _tmp1633_;
				ValaMethod* _tmp1634_;
				ValaParameter* _tmp1635_;
				ValaParameter* _tmp1636_;
				ValaDataType* _tmp1637_;
				ValaDataType* _tmp1638_;
				gboolean _tmp1639_;
				gboolean _tmp1640_;
				_tmp1623_ = vala_member_access_get_inner (self);
				_tmp1624_ = _tmp1623_;
				_tmp1625_ = method;
				_tmp1626_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1625_);
				_tmp1627_ = _tmp1626_;
				_tmp1628_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1627_);
				_tmp1629_ = _tmp1628_;
				vala_expression_set_target_type (_tmp1624_, _tmp1629_);
				_vala_code_node_unref0 (_tmp1629_);
				_tmp1630_ = vala_member_access_get_inner (self);
				_tmp1631_ = _tmp1630_;
				_tmp1632_ = vala_expression_get_target_type (_tmp1631_);
				_tmp1633_ = _tmp1632_;
				_tmp1634_ = method;
				_tmp1635_ = vala_method_get_this_parameter (_tmp1634_);
				_tmp1636_ = _tmp1635_;
				_tmp1637_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1636_);
				_tmp1638_ = _tmp1637_;
				_tmp1639_ = vala_data_type_get_value_owned (_tmp1638_);
				_tmp1640_ = _tmp1639_;
				vala_data_type_set_value_owned (_tmp1633_, _tmp1640_);
			}
		} else {
			gboolean _tmp1641_ = FALSE;
			gboolean _tmp1642_ = FALSE;
			ValaSymbol* _tmp1643_;
			ValaSymbol* _tmp1644_;
			_tmp1643_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1644_ = _tmp1643_;
			if (VALA_IS_PROPERTY (_tmp1644_)) {
				_tmp1642_ = instance;
			} else {
				_tmp1642_ = FALSE;
			}
			if (_tmp1642_) {
				ValaSymbol* _tmp1645_;
				ValaSymbol* _tmp1646_;
				ValaSymbol* _tmp1647_;
				ValaSymbol* _tmp1648_;
				_tmp1645_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1646_ = _tmp1645_;
				_tmp1647_ = vala_symbol_get_parent_symbol (_tmp1646_);
				_tmp1648_ = _tmp1647_;
				_tmp1641_ = _tmp1648_ != NULL;
			} else {
				_tmp1641_ = FALSE;
			}
			if (_tmp1641_) {
				ValaExpression* _tmp1649_;
				ValaExpression* _tmp1650_;
				ValaSymbol* _tmp1651_;
				ValaSymbol* _tmp1652_;
				ValaSymbol* _tmp1653_;
				ValaSymbol* _tmp1654_;
				ValaDataType* _tmp1655_;
				ValaDataType* _tmp1656_;
				_tmp1649_ = vala_member_access_get_inner (self);
				_tmp1650_ = _tmp1649_;
				_tmp1651_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1652_ = _tmp1651_;
				_tmp1653_ = vala_symbol_get_parent_symbol (_tmp1652_);
				_tmp1654_ = _tmp1653_;
				_tmp1655_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1654_);
				_tmp1656_ = _tmp1655_;
				vala_expression_set_target_type (_tmp1650_, _tmp1656_);
				_vala_code_node_unref0 (_tmp1656_);
			} else {
				gboolean _tmp1657_ = FALSE;
				gboolean _tmp1658_ = FALSE;
				gboolean _tmp1659_ = FALSE;
				ValaSymbol* _tmp1660_;
				ValaSymbol* _tmp1661_;
				_tmp1660_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1661_ = _tmp1660_;
				if (VALA_IS_FIELD (_tmp1661_)) {
					_tmp1659_ = TRUE;
				} else {
					ValaSymbol* _tmp1662_;
					ValaSymbol* _tmp1663_;
					_tmp1662_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1663_ = _tmp1662_;
					_tmp1659_ = VALA_IS_SIGNAL (_tmp1663_);
				}
				if (_tmp1659_) {
					_tmp1658_ = instance;
				} else {
					_tmp1658_ = FALSE;
				}
				if (_tmp1658_) {
					ValaSymbol* _tmp1664_;
					ValaSymbol* _tmp1665_;
					ValaSymbol* _tmp1666_;
					ValaSymbol* _tmp1667_;
					_tmp1664_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1665_ = _tmp1664_;
					_tmp1666_ = vala_symbol_get_parent_symbol (_tmp1665_);
					_tmp1667_ = _tmp1666_;
					_tmp1657_ = _tmp1667_ != NULL;
				} else {
					_tmp1657_ = FALSE;
				}
				if (_tmp1657_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1668_;
					ValaSymbol* _tmp1669_;
					ValaSymbol* _tmp1670_;
					ValaSymbol* _tmp1671_;
					ValaDataType* _tmp1672_;
					ValaExpression* _tmp1673_;
					ValaExpression* _tmp1674_;
					ValaDataType* _tmp1675_;
					ValaExpression* _tmp1676_;
					ValaExpression* _tmp1677_;
					ValaDataType* _tmp1678_;
					ValaDataType* _tmp1679_;
					ValaDataType* _tmp1680_;
					ValaDataType* _tmp1681_;
					_tmp1668_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1669_ = _tmp1668_;
					_tmp1670_ = vala_symbol_get_parent_symbol (_tmp1669_);
					_tmp1671_ = _tmp1670_;
					_tmp1672_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1671_);
					parent_type = _tmp1672_;
					_tmp1673_ = vala_member_access_get_inner (self);
					_tmp1674_ = _tmp1673_;
					_tmp1675_ = parent_type;
					_tmp1676_ = vala_member_access_get_inner (self);
					_tmp1677_ = _tmp1676_;
					_tmp1678_ = vala_expression_get_value_type (_tmp1677_);
					_tmp1679_ = _tmp1678_;
					_tmp1680_ = vala_data_type_get_actual_type (_tmp1675_, _tmp1679_, NULL, (ValaCodeNode*) self);
					_tmp1681_ = _tmp1680_;
					vala_expression_set_target_type (_tmp1674_, _tmp1681_);
					_vala_code_node_unref0 (_tmp1681_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
		_tmp1684_ = vala_member_access_get_inner (self);
		_tmp1685_ = _tmp1684_;
		if (_tmp1685_ == NULL) {
			ValaDataType* _tmp1686_;
			ValaDataType* _tmp1687_;
			_tmp1686_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1687_ = _tmp1686_;
			_tmp1683_ = _tmp1687_ != NULL;
		} else {
			_tmp1683_ = FALSE;
		}
		if (_tmp1683_) {
			ValaProfile _tmp1688_;
			ValaProfile _tmp1689_;
			_tmp1688_ = vala_code_context_get_profile (context);
			_tmp1689_ = _tmp1688_;
			_tmp1682_ = _tmp1689_ == VALA_PROFILE_GOBJECT;
		} else {
			_tmp1682_ = FALSE;
		}
		if (_tmp1682_) {
			vala_member_access_check_narrowed_value_type (self);
		}
	}
	_tmp1690_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1691_ = _tmp1690_;
	if (_tmp1691_ != NULL) {
		ValaDataType* _tmp1692_;
		ValaDataType* _tmp1693_;
		_tmp1692_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp1693_ = _tmp1692_;
		vala_code_node_check ((ValaCodeNode*) _tmp1693_, context);
	}
	_tmp1694_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1695_ = _tmp1694_;
	if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp1695_)) {
		gboolean _tmp1696_ = FALSE;
		gboolean _tmp1697_ = FALSE;
		ValaExpression* _tmp1698_;
		ValaExpression* _tmp1699_;
		ValaDataType* _tmp1700_;
		ValaDataType* _tmp1701_;
		_tmp1698_ = vala_member_access_get_inner (self);
		_tmp1699_ = _tmp1698_;
		_tmp1700_ = vala_expression_get_value_type (_tmp1699_);
		_tmp1701_ = _tmp1700_;
		if (VALA_IS_ARRAY_TYPE (_tmp1701_)) {
			ValaExpression* _tmp1702_;
			ValaExpression* _tmp1703_;
			ValaDataType* _tmp1704_;
			ValaDataType* _tmp1705_;
			gint _tmp1706_;
			gint _tmp1707_;
			_tmp1702_ = vala_member_access_get_inner (self);
			_tmp1703_ = _tmp1702_;
			_tmp1704_ = vala_expression_get_value_type (_tmp1703_);
			_tmp1705_ = _tmp1704_;
			_tmp1706_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp1705_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
			_tmp1707_ = _tmp1706_;
			_tmp1697_ = _tmp1707_ > 1;
		} else {
			_tmp1697_ = FALSE;
		}
		if (_tmp1697_) {
			ValaCodeNode* _tmp1708_;
			ValaCodeNode* _tmp1709_;
			_tmp1708_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp1709_ = _tmp1708_;
			_tmp1696_ = !VALA_IS_ELEMENT_ACCESS (_tmp1709_);
		} else {
			_tmp1696_ = FALSE;
		}
		if (_tmp1696_) {
			ValaSourceReference* _tmp1710_;
			ValaSourceReference* _tmp1711_;
			_tmp1710_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1711_ = _tmp1710_;
			vala_report_error (_tmp1711_, "unsupported use of length field of multi-dimensional array");
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		}
	} else {
		ValaSymbol* _tmp1712_;
		ValaSymbol* _tmp1713_;
		_tmp1712_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1713_ = _tmp1712_;
		if (VALA_IS_DELEGATE_TARGET_FIELD (_tmp1713_)) {
			ValaExpression* _tmp1714_;
			ValaExpression* _tmp1715_;
			ValaDataType* _tmp1716_;
			ValaDataType* _tmp1717_;
			ValaDelegate* _tmp1718_;
			ValaDelegate* _tmp1719_;
			gboolean _tmp1720_;
			gboolean _tmp1721_;
			_tmp1714_ = vala_member_access_get_inner (self);
			_tmp1715_ = _tmp1714_;
			_tmp1716_ = vala_expression_get_value_type (_tmp1715_);
			_tmp1717_ = _tmp1716_;
			_tmp1718_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1717_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			_tmp1719_ = _tmp1718_;
			_tmp1720_ = vala_delegate_get_has_target (_tmp1719_);
			_tmp1721_ = _tmp1720_;
			if (!_tmp1721_) {
				ValaSourceReference* _tmp1722_;
				ValaSourceReference* _tmp1723_;
				_tmp1722_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1723_ = _tmp1722_;
				vala_report_error (_tmp1723_, "unsupported use of target field of delegate without target");
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
		} else {
			ValaSymbol* _tmp1724_;
			ValaSymbol* _tmp1725_;
			_tmp1724_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1725_ = _tmp1724_;
			if (VALA_IS_DELEGATE_DESTROY_FIELD (_tmp1725_)) {
				ValaExpression* _tmp1726_;
				ValaExpression* _tmp1727_;
				ValaDataType* _tmp1728_;
				ValaDataType* _tmp1729_;
				ValaDelegate* _tmp1730_;
				ValaDelegate* _tmp1731_;
				gboolean _tmp1732_;
				gboolean _tmp1733_;
				_tmp1726_ = vala_member_access_get_inner (self);
				_tmp1727_ = _tmp1726_;
				_tmp1728_ = vala_expression_get_value_type (_tmp1727_);
				_tmp1729_ = _tmp1728_;
				_tmp1730_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1729_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				_tmp1731_ = _tmp1730_;
				_tmp1732_ = vala_delegate_get_has_target (_tmp1731_);
				_tmp1733_ = _tmp1732_;
				if (!_tmp1733_) {
					ValaSourceReference* _tmp1734_;
					ValaSourceReference* _tmp1735_;
					_tmp1734_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1735_ = _tmp1734_;
					vala_report_error (_tmp1735_, "unsupported use of destroy field of delegate without target");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
			}
		}
	}
	_tmp1736_ = self->priv->_tainted_access;
	if (!_tmp1736_) {
		vala_member_access_set_tainted_access (self, vala_member_access_is_tainted (self));
	}
	_tmp1737_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1738_ = _tmp1737_;
	result = !_tmp1738_;
	_vala_iterable_unref0 (visited_types);
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp50_;
	ValaExpression* _tmp51_;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	ValaMemberAccess* _tmp54_;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp83_ = FALSE;
	ValaSymbol* _tmp84_;
	ValaSymbol* _tmp85_;
	gboolean _tmp93_ = FALSE;
	ValaSymbol* _tmp94_;
	ValaSymbol* _tmp95_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_METHOD (_tmp11_)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (VALA_IS_PROPERTY (_tmp18_)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (VALA_IS_PARAMETER (_tmp27_)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp39_)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		ValaExpression* _tmp46_;
		ValaExpression* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		_tmp46_ = vala_member_access_get_inner (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_get_value_type (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp34_ = VALA_IS_ARRAY_TYPE (_tmp49_);
	}
	struct_or_array = _tmp34_;
	_tmp50_ = vala_member_access_get_inner (self);
	_tmp51_ = _tmp50_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL;
	_tmp54_ = ma;
	if (_tmp54_ == NULL) {
		_tmp53_ = struct_or_array;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		_tmp55_ = vala_member_access_get_inner (self);
		_tmp56_ = _tmp55_;
		_tmp52_ = VALA_IS_POINTER_INDIRECTION (_tmp56_);
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		ValaExpression* _tmp57_;
		ValaExpression* _tmp58_;
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		_tmp57_ = vala_member_access_get_inner (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp60_ = _tmp59_;
		ma = VALA_IS_MEMBER_ACCESS (_tmp60_) ? ((ValaMemberAccess*) _tmp60_) : NULL;
	}
	if (instance) {
		_tmp64_ = struct_or_array;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		gboolean _tmp65_ = FALSE;
		ValaSymbol* _tmp66_;
		ValaSymbol* _tmp67_;
		_tmp66_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp67_ = _tmp66_;
		if (VALA_IS_METHOD (_tmp67_)) {
			_tmp65_ = TRUE;
		} else {
			gboolean _tmp68_;
			gboolean _tmp69_;
			_tmp68_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp69_ = _tmp68_;
			_tmp65_ = _tmp69_;
		}
		_tmp63_ = _tmp65_;
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		gboolean _tmp70_ = FALSE;
		gboolean _tmp71_ = FALSE;
		ValaMemberAccess* _tmp72_;
		_tmp72_ = ma;
		if (_tmp72_ != NULL) {
			ValaMemberAccess* _tmp73_;
			ValaSymbol* _tmp74_;
			ValaSymbol* _tmp75_;
			_tmp73_ = ma;
			_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp71_ = VALA_IS_VARIABLE (_tmp75_);
		} else {
			_tmp71_ = FALSE;
		}
		if (_tmp71_) {
			_tmp70_ = TRUE;
		} else {
			ValaExpression* _tmp76_;
			ValaExpression* _tmp77_;
			_tmp76_ = vala_member_access_get_inner (self);
			_tmp77_ = _tmp76_;
			_tmp70_ = VALA_IS_ELEMENT_ACCESS (_tmp77_);
		}
		_tmp62_ = _tmp70_;
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		_tmp61_ = !this_access;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		ValaExpression* _tmp78_;
		ValaExpression* _tmp79_;
		ValaMemberAccess* _tmp80_;
		_tmp78_ = vala_member_access_get_inner (self);
		_tmp79_ = _tmp78_;
		vala_expression_set_lvalue (_tmp79_, TRUE);
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaMemberAccess* _tmp82_;
			_tmp81_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp81_, TRUE);
			_tmp82_ = ma;
			vala_member_access_check_lvalue_access (_tmp82_);
		}
	}
	_tmp84_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp85_ = _tmp84_;
	if (VALA_IS_DELEGATE_TARGET_FIELD (_tmp85_)) {
		_tmp83_ = TRUE;
	} else {
		ValaSymbol* _tmp86_;
		ValaSymbol* _tmp87_;
		_tmp86_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp87_ = _tmp86_;
		_tmp83_ = VALA_IS_DELEGATE_DESTROY_FIELD (_tmp87_);
	}
	if (_tmp83_) {
		ValaExpression* _tmp88_;
		ValaExpression* _tmp89_;
		ValaMemberAccess* _tmp90_;
		_tmp88_ = vala_member_access_get_inner (self);
		_tmp89_ = _tmp88_;
		vala_expression_set_lvalue (_tmp89_, TRUE);
		_tmp90_ = ma;
		if (_tmp90_ != NULL) {
			ValaMemberAccess* _tmp91_;
			ValaMemberAccess* _tmp92_;
			_tmp91_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp91_, TRUE);
			_tmp92_ = ma;
			vala_member_access_check_lvalue_access (_tmp92_);
		}
	}
	_tmp94_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp95_ = _tmp94_;
	if (VALA_IS_METHOD (_tmp95_)) {
		ValaSymbol* _tmp96_;
		ValaSymbol* _tmp97_;
		ValaAttribute* _tmp98_;
		_tmp96_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp97_ = _tmp96_;
		_tmp98_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp93_ = _tmp98_ != NULL;
	} else {
		_tmp93_ = FALSE;
	}
	if (_tmp93_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp99_;
		ValaSymbol* _tmp100_;
		ValaSymbol* _tmp101_;
		ValaSymbol* _tmp102_;
		gboolean _tmp103_ = FALSE;
		gboolean _tmp104_ = FALSE;
		ValaClass* _tmp105_;
		_tmp99_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp100_ = _tmp99_;
		_tmp101_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, VALA_TYPE_METHOD, ValaMethod));
		_tmp102_ = _tmp101_;
		cl = VALA_IS_CLASS (_tmp102_) ? ((ValaClass*) _tmp102_) : NULL;
		_tmp105_ = cl;
		if (_tmp105_ != NULL) {
			ValaClass* _tmp106_;
			gboolean _tmp107_;
			gboolean _tmp108_;
			_tmp106_ = cl;
			_tmp107_ = vala_class_get_is_compact (_tmp106_);
			_tmp108_ = _tmp107_;
			_tmp104_ = _tmp108_;
		} else {
			_tmp104_ = FALSE;
		}
		if (_tmp104_) {
			ValaMemberAccess* _tmp109_;
			_tmp109_ = ma;
			_tmp103_ = _tmp109_ != NULL;
		} else {
			_tmp103_ = FALSE;
		}
		if (_tmp103_) {
			ValaMemberAccess* _tmp110_;
			ValaMemberAccess* _tmp111_;
			_tmp110_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp110_, TRUE);
			_tmp111_ = ma;
			vala_member_access_check_lvalue_access (_tmp111_);
		}
	}
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL;
	_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp7_ = _tmp6_;
	param = VALA_IS_PARAMETER (_tmp7_) ? ((ValaParameter*) _tmp7_) : NULL;
	_tmp8_ = local;
	if (_tmp8_ != NULL) {
		ValaLocalVariable* _tmp9_;
		_tmp9_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp9_);
	} else {
		gboolean _tmp10_ = FALSE;
		ValaParameter* _tmp11_;
		_tmp11_ = param;
		if (_tmp11_ != NULL) {
			ValaParameter* _tmp12_;
			ValaParameterDirection _tmp13_;
			ValaParameterDirection _tmp14_;
			_tmp12_ = param;
			_tmp13_ = vala_parameter_get_direction (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp10_ = _tmp14_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			ValaParameter* _tmp15_;
			_tmp15_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp15_);
		}
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ValaMemberAccess* self;
		self = _data1_->self;
		_vala_code_node_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static ValaTraverseStatus
__lambda4_ (Block1Data* _data1_,
            ValaCodeNode* n)
{
	ValaMemberAccess* self;
	ValaTraverseStatus result;
	self = _data1_->self;
	g_return_val_if_fail (n != NULL, 0);
	if (VALA_IS_POSTFIX_EXPRESSION (n)) {
		_data1_->found = TRUE;
		result = VALA_TRAVERSE_STATUS_STOP;
		return result;
	} else {
		if (VALA_IS_UNARY_EXPRESSION (n)) {
			ValaUnaryExpression* e = NULL;
			gboolean _tmp0_ = FALSE;
			ValaUnaryExpression* _tmp1_;
			ValaUnaryOperator _tmp2_;
			ValaUnaryOperator _tmp3_;
			e = G_TYPE_CHECK_INSTANCE_CAST (n, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression);
			_tmp1_ = e;
			_tmp2_ = vala_unary_expression_get_operator (_tmp1_);
			_tmp3_ = _tmp2_;
			if (_tmp3_ == VALA_UNARY_OPERATOR_INCREMENT) {
				_tmp0_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp4_;
				ValaUnaryOperator _tmp5_;
				ValaUnaryOperator _tmp6_;
				_tmp4_ = e;
				_tmp5_ = vala_unary_expression_get_operator (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp0_ = _tmp6_ == VALA_UNARY_OPERATOR_DECREMENT;
			}
			if (_tmp0_) {
				_data1_->found = TRUE;
				result = VALA_TRAVERSE_STATUS_STOP;
				return result;
			}
		}
	}
	result = VALA_TRAVERSE_STATUS_CONTINUE;
	return result;
}

static ValaTraverseStatus
___lambda4__vala_traverse_func (ValaCodeNode* node,
                                gpointer self)
{
	ValaTraverseStatus result;
	result = __lambda4_ (self, node);
	return result;
}

static gboolean
vala_member_access_is_tainted (ValaMemberAccess* self)
{
	Block1Data* _data1_;
	ValaCodeNode* node = NULL;
	ValaCodeNode* _tmp0_;
	ValaCodeNode* _tmp1_;
	ValaCodeNode* _tmp2_;
	ValaTraverseVisitor* traverse = NULL;
	ValaTraverseVisitor* _tmp14_;
	ValaCodeNode* _tmp15_;
	ValaTraverseVisitor* _tmp16_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = vala_code_node_ref (self);
	node = (ValaCodeNode*) self;
	_tmp0_ = node;
	_tmp1_ = vala_code_node_get_parent_node (_tmp0_);
	_tmp2_ = _tmp1_;
	if (VALA_IS_MEMBER_ACCESS (_tmp2_)) {
		result = FALSE;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	while (TRUE) {
		ValaCodeNode* _tmp3_;
		ValaCodeNode* _tmp4_;
		ValaCodeNode* _tmp5_;
		ValaCodeNode* _tmp6_;
		ValaCodeNode* _tmp7_;
		ValaCodeNode* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		ValaCodeNode* _tmp11_;
		_tmp3_ = node;
		_tmp4_ = vala_code_node_get_parent_node (_tmp3_);
		_tmp5_ = _tmp4_;
		if (!VALA_IS_EXPRESSION (_tmp5_)) {
			break;
		}
		_tmp6_ = node;
		_tmp7_ = vala_code_node_get_parent_node (_tmp6_);
		_tmp8_ = _tmp7_;
		node = _tmp8_;
		_tmp11_ = node;
		if (VALA_IS_ASSIGNMENT (_tmp11_)) {
			_tmp10_ = TRUE;
		} else {
			ValaCodeNode* _tmp12_;
			_tmp12_ = node;
			_tmp10_ = VALA_IS_METHOD_CALL (_tmp12_);
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			ValaCodeNode* _tmp13_;
			_tmp13_ = node;
			_tmp9_ = VALA_IS_OBJECT_CREATION_EXPRESSION (_tmp13_);
		}
		if (_tmp9_) {
			break;
		}
	}
	_data1_->found = FALSE;
	_tmp14_ = vala_traverse_visitor_new (___lambda4__vala_traverse_func, block1_data_ref (_data1_), block1_data_unref);
	traverse = _tmp14_;
	_tmp15_ = node;
	_tmp16_ = traverse;
	vala_code_node_accept (_tmp15_, (ValaCodeVisitor*) _tmp16_);
	result = _data1_->found;
	_vala_code_visitor_unref0 (traverse);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

static void
vala_member_access_check_narrowed_value_type (ValaMemberAccess* self)
{
	ValaVariable* variable = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaVariable* _tmp2_;
	ValaCodeNode* _tmp3_;
	ValaCodeNode* _tmp4_;
	gboolean is_negation = FALSE;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp5_;
	ValaCodeNode* _tmp6_;
	ValaIfStatement* if_statement = NULL;
	ValaArrayList* scope_type_checks = NULL;
	GEqualFunc _tmp7_;
	ValaArrayList* _tmp8_;
	ValaIfStatement* _tmp43_;
	ValaDataType* _tmp79_;
	ValaDataType* _tmp80_;
	ValaSymbol* _tmp81_;
	ValaSymbol* _tmp82_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	variable = VALA_IS_VARIABLE (_tmp1_) ? ((ValaVariable*) _tmp1_) : NULL;
	_tmp2_ = variable;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp4_ = _tmp3_;
	if (!VALA_IS_MEMBER_ACCESS (_tmp4_)) {
		return;
	}
	is_negation = FALSE;
	_tmp5_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp6_ = _tmp5_;
	parent = _tmp6_;
	if_statement = NULL;
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_array_list_new (VALA_TYPE_TYPECHECK, NULL, NULL, _tmp7_);
	scope_type_checks = _tmp8_;
	while (TRUE) {
		gboolean _tmp9_ = FALSE;
		ValaCodeNode* _tmp10_;
		ValaCodeNode* _tmp12_;
		ValaCodeNode* _tmp13_;
		ValaCodeNode* _tmp14_;
		ValaCodeNode* _tmp15_;
		ValaCodeNode* _tmp23_;
		ValaCodeNode* _tmp24_;
		ValaCodeNode* _tmp25_;
		ValaCodeNode* _tmp40_;
		ValaCodeNode* _tmp41_;
		ValaCodeNode* _tmp42_;
		_tmp10_ = parent;
		if (_tmp10_ != NULL) {
			ValaCodeNode* _tmp11_;
			_tmp11_ = parent;
			_tmp9_ = !VALA_IS_METHOD (_tmp11_);
		} else {
			_tmp9_ = FALSE;
		}
		if (!_tmp9_) {
			break;
		}
		_tmp12_ = parent;
		if (VALA_IS_TYPECHECK (_tmp12_)) {
			parent = NULL;
			break;
		}
		_tmp13_ = parent;
		_tmp14_ = vala_code_node_get_parent_node (_tmp13_);
		_tmp15_ = _tmp14_;
		if (VALA_IS_IF_STATEMENT (_tmp15_)) {
			ValaCodeNode* _tmp16_;
			ValaCodeNode* _tmp17_;
			ValaCodeNode* _tmp18_;
			ValaIfStatement* _tmp19_;
			ValaBlock* _tmp20_;
			ValaBlock* _tmp21_;
			ValaCodeNode* _tmp22_;
			_tmp16_ = parent;
			_tmp17_ = vala_code_node_get_parent_node (_tmp16_);
			_tmp18_ = _tmp17_;
			if_statement = G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_IF_STATEMENT, ValaIfStatement);
			_tmp19_ = if_statement;
			_tmp20_ = vala_if_statement_get_false_statement (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = parent;
			is_negation = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_CODE_NODE, ValaCodeNode) == _tmp22_;
			break;
		}
		_tmp23_ = parent;
		_tmp24_ = vala_code_node_get_parent_node (_tmp23_);
		_tmp25_ = _tmp24_;
		if (VALA_IS_METHOD (_tmp25_)) {
			{
				ValaList* _expr_list = NULL;
				ValaCodeNode* _tmp26_;
				ValaCodeNode* _tmp27_;
				ValaCodeNode* _tmp28_;
				ValaList* _tmp29_;
				gint _expr_size = 0;
				ValaList* _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				gint _expr_index = 0;
				_tmp26_ = parent;
				_tmp27_ = vala_code_node_get_parent_node (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = vala_method_get_preconditions (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_METHOD, ValaMethod));
				_expr_list = _tmp29_;
				_tmp30_ = _expr_list;
				_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
				_tmp32_ = _tmp31_;
				_expr_size = _tmp32_;
				_expr_index = -1;
				while (TRUE) {
					gint _tmp33_;
					gint _tmp34_;
					ValaExpression* expr = NULL;
					ValaList* _tmp35_;
					gpointer _tmp36_;
					ValaExpression* _tmp37_;
					_expr_index = _expr_index + 1;
					_tmp33_ = _expr_index;
					_tmp34_ = _expr_size;
					if (!(_tmp33_ < _tmp34_)) {
						break;
					}
					_tmp35_ = _expr_list;
					_tmp36_ = vala_list_get (_tmp35_, _expr_index);
					expr = (ValaExpression*) _tmp36_;
					_tmp37_ = expr;
					if (VALA_IS_TYPECHECK (_tmp37_)) {
						ValaArrayList* _tmp38_;
						ValaExpression* _tmp39_;
						_tmp38_ = scope_type_checks;
						_tmp39_ = expr;
						vala_collection_add ((ValaCollection*) _tmp38_, G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, VALA_TYPE_TYPECHECK, ValaTypeCheck));
					}
					_vala_code_node_unref0 (expr);
				}
			}
			break;
		}
		_tmp40_ = parent;
		_tmp41_ = vala_code_node_get_parent_node (_tmp40_);
		_tmp42_ = _tmp41_;
		parent = _tmp42_;
	}
	_tmp43_ = if_statement;
	if (_tmp43_ != NULL) {
		ValaExpression* expr = NULL;
		ValaIfStatement* _tmp44_;
		ValaExpression* _tmp45_;
		ValaExpression* _tmp46_;
		gboolean _tmp47_ = FALSE;
		ValaExpression* _tmp48_;
		ValaTypeCheck* type_check = NULL;
		ValaExpression* _tmp55_;
		gboolean _tmp56_ = FALSE;
		_tmp44_ = if_statement;
		_tmp45_ = vala_if_statement_get_condition (_tmp44_);
		_tmp46_ = _tmp45_;
		expr = _tmp46_;
		_tmp48_ = expr;
		if (VALA_IS_UNARY_EXPRESSION (_tmp48_)) {
			ValaExpression* _tmp49_;
			ValaUnaryOperator _tmp50_;
			ValaUnaryOperator _tmp51_;
			_tmp49_ = expr;
			_tmp50_ = vala_unary_expression_get_operator (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression));
			_tmp51_ = _tmp50_;
			_tmp47_ = _tmp51_ == VALA_UNARY_OPERATOR_LOGICAL_NEGATION;
		} else {
			_tmp47_ = FALSE;
		}
		if (_tmp47_) {
			ValaExpression* _tmp52_;
			ValaExpression* _tmp53_;
			ValaExpression* _tmp54_;
			_tmp52_ = expr;
			_tmp53_ = vala_unary_expression_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression));
			_tmp54_ = _tmp53_;
			expr = _tmp54_;
			is_negation = !is_negation;
		}
		_tmp55_ = expr;
		type_check = VALA_IS_TYPECHECK (_tmp55_) ? ((ValaTypeCheck*) _tmp55_) : NULL;
		if (!is_negation) {
			ValaTypeCheck* _tmp57_;
			_tmp57_ = type_check;
			_tmp56_ = _tmp57_ != NULL;
		} else {
			_tmp56_ = FALSE;
		}
		if (_tmp56_) {
			ValaTypeSymbol* narrowed_symnol = NULL;
			ValaTypeCheck* _tmp58_;
			ValaDataType* _tmp59_;
			ValaDataType* _tmp60_;
			ValaTypeSymbol* _tmp61_;
			ValaTypeSymbol* _tmp62_;
			ValaVariable* _tmp63_;
			ValaTypeCheck* _tmp64_;
			ValaExpression* _tmp65_;
			ValaExpression* _tmp66_;
			ValaSymbol* _tmp67_;
			ValaSymbol* _tmp68_;
			_tmp58_ = type_check;
			_tmp59_ = vala_typecheck_get_type_reference (_tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = vala_data_type_get_type_symbol (_tmp60_);
			_tmp62_ = _tmp61_;
			narrowed_symnol = _tmp62_;
			_tmp63_ = variable;
			_tmp64_ = type_check;
			_tmp65_ = vala_typecheck_get_expression (_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = vala_expression_get_symbol_reference (_tmp66_);
			_tmp68_ = _tmp67_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, VALA_TYPE_SYMBOL, ValaSymbol) == _tmp68_) {
				ValaTypeSymbol* _tmp69_;
				ValaDataType* _tmp70_;
				ValaDataType* _tmp71_;
				ValaTypeSymbol* _tmp72_;
				ValaTypeSymbol* _tmp73_;
				ValaDataType* _tmp77_;
				ValaDataType* _tmp78_;
				_tmp69_ = narrowed_symnol;
				_tmp70_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp71_ = _tmp70_;
				_tmp72_ = vala_data_type_get_type_symbol (_tmp71_);
				_tmp73_ = _tmp72_;
				if (_tmp69_ != _tmp73_) {
					ValaDataType* _tmp74_;
					ValaDataType* _tmp75_;
					ValaTypeSymbol* _tmp76_;
					_tmp74_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp75_ = _tmp74_;
					_tmp76_ = narrowed_symnol;
					vala_data_type_set_context_symbol (_tmp75_, (ValaSymbol*) _tmp76_);
				}
				_tmp77_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp78_ = _tmp77_;
				vala_data_type_set_nullable (_tmp78_, FALSE);
			}
		}
	}
	_tmp79_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp80_ = _tmp79_;
	_tmp81_ = vala_data_type_get_context_symbol (_tmp80_);
	_tmp82_ = _tmp81_;
	if (_tmp82_ == NULL) {
		{
			ValaArrayList* _type_check_list = NULL;
			ValaArrayList* _tmp83_;
			gint _type_check_size = 0;
			ValaArrayList* _tmp84_;
			gint _tmp85_;
			gint _tmp86_;
			gint _type_check_index = 0;
			_tmp83_ = scope_type_checks;
			_type_check_list = _tmp83_;
			_tmp84_ = _type_check_list;
			_tmp85_ = vala_collection_get_size ((ValaCollection*) _tmp84_);
			_tmp86_ = _tmp85_;
			_type_check_size = _tmp86_;
			_type_check_index = -1;
			while (TRUE) {
				gint _tmp87_;
				gint _tmp88_;
				ValaTypeCheck* type_check = NULL;
				ValaArrayList* _tmp89_;
				gpointer _tmp90_;
				ValaTypeCheck* _tmp91_;
				ValaTypeSymbol* narrowed_symnol = NULL;
				ValaTypeCheck* _tmp92_;
				ValaDataType* _tmp93_;
				ValaDataType* _tmp94_;
				ValaTypeSymbol* _tmp95_;
				ValaTypeSymbol* _tmp96_;
				ValaVariable* _tmp97_;
				ValaTypeCheck* _tmp98_;
				ValaExpression* _tmp99_;
				ValaExpression* _tmp100_;
				ValaSymbol* _tmp101_;
				ValaSymbol* _tmp102_;
				_type_check_index = _type_check_index + 1;
				_tmp87_ = _type_check_index;
				_tmp88_ = _type_check_size;
				if (!(_tmp87_ < _tmp88_)) {
					break;
				}
				_tmp89_ = _type_check_list;
				_tmp90_ = vala_list_get ((ValaList*) _tmp89_, _type_check_index);
				_tmp91_ = _vala_code_node_ref0 ((ValaTypeCheck*) _tmp90_);
				type_check = _tmp91_;
				_tmp92_ = type_check;
				_tmp93_ = vala_typecheck_get_type_reference (_tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = vala_data_type_get_type_symbol (_tmp94_);
				_tmp96_ = _tmp95_;
				narrowed_symnol = _tmp96_;
				_tmp97_ = variable;
				_tmp98_ = type_check;
				_tmp99_ = vala_typecheck_get_expression (_tmp98_);
				_tmp100_ = _tmp99_;
				_tmp101_ = vala_expression_get_symbol_reference (_tmp100_);
				_tmp102_ = _tmp101_;
				if (G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, VALA_TYPE_SYMBOL, ValaSymbol) == _tmp102_) {
					ValaTypeSymbol* _tmp103_;
					ValaDataType* _tmp104_;
					ValaDataType* _tmp105_;
					ValaTypeSymbol* _tmp106_;
					ValaTypeSymbol* _tmp107_;
					ValaDataType* _tmp111_;
					ValaDataType* _tmp112_;
					_tmp103_ = narrowed_symnol;
					_tmp104_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp105_ = _tmp104_;
					_tmp106_ = vala_data_type_get_type_symbol (_tmp105_);
					_tmp107_ = _tmp106_;
					if (_tmp103_ != _tmp107_) {
						ValaDataType* _tmp108_;
						ValaDataType* _tmp109_;
						ValaTypeSymbol* _tmp110_;
						_tmp108_ = vala_expression_get_value_type ((ValaExpression*) self);
						_tmp109_ = _tmp108_;
						_tmp110_ = narrowed_symnol;
						vala_data_type_set_context_symbol (_tmp109_, (ValaSymbol*) _tmp110_);
					}
					_tmp111_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp112_ = _tmp111_;
					vala_data_type_set_nullable (_tmp112_, FALSE);
				}
				_vala_code_node_unref0 (type_check);
			}
		}
	}
	_vala_iterable_unref0 (scope_type_checks);
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass,
                               gpointer klass_data)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
static GType
vala_member_access_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
	GType vala_member_access_type_id;
	vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
	ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
	return vala_member_access_type_id;
}

GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__once = 0;
	if (g_once_init_enter (&vala_member_access_type_id__once)) {
		GType vala_member_access_type_id;
		vala_member_access_type_id = vala_member_access_get_type_once ();
		g_once_init_leave (&vala_member_access_type_id__once, vala_member_access_type_id);
	}
	return vala_member_access_type_id__once;
}

