/* valamethod.c generated by valac, the Vala compiler
 * generated from valamethod.vala, do not modify */

/* valamethod.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaMethodPrivate {
	ValaList* type_parameters;
	ValaMemberBinding _binding;
	gboolean _is_abstract;
	gboolean _is_virtual;
	gboolean _overrides;
	gboolean _is_inline;
	gboolean _entry_point;
	gboolean _is_main_block;
	ValaParameter* _this_parameter;
	ValaLocalVariable* _params_array_var;
	ValaSignal* _signal_reference;
	gboolean _closure;
	gboolean _coroutine;
	gboolean _is_async_callback;
	ValaList* parameters;
	ValaList* async_begin_parameters;
	ValaList* async_end_parameters;
	ValaList* preconditions;
	ValaList* postconditions;
	ValaDataType* _return_type;
	ValaMethod* _base_method;
	ValaMethod* _base_interface_method;
	ValaDataType* _base_interface_type;
	gboolean base_methods_valid;
	ValaMethod* callback_method;
	ValaMethod* end_method;
	ValaList* captured_variables;
};

struct _Block2Data {
	int _ref_count_;
	ValaMethod* self;
	ValaList* referenced_generics;
};

static gint ValaMethod_private_offset;
static gpointer vala_method_parent_class = NULL;
static ValaList* vala_method__empty_expression_list;
static ValaList* vala_method__empty_expression_list = NULL;
static ValaList* vala_method__empty_type_parameter_list;
static ValaList* vala_method__empty_type_parameter_list = NULL;
static ValaCallableIface * vala_method_vala_callable_parent_iface = NULL;

static void vala_method_find_base_methods (ValaMethod* self);
static void vala_method_set_entry_point (ValaMethod* self,
                                  gboolean value);
static void vala_method_set_is_main_block (ValaMethod* self,
                                    gboolean value);
static void vala_method_real_add_parameter (ValaCallable* base,
                                     ValaParameter* param);
static ValaList* vala_method_real_get_parameters (ValaCallable* base);
static void vala_method_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor);
static void vala_method_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static gboolean vala_method_compatible_internal (ValaMethod* self,
                                          ValaMethod* base_method,
                                          gchar** invalid_match,
                                          ValaCodeNode* node_reference);
static void vala_method_real_get_error_types (ValaCodeNode* base,
                                       ValaCollection* collection,
                                       ValaSourceReference* source_reference);
static void vala_method_real_replace_expression (ValaCodeNode* base,
                                          ValaExpression* old_node,
                                          ValaExpression* new_node);
static void vala_method_real_replace_type (ValaCodeNode* base,
                                    ValaDataType* old_type,
                                    ValaDataType* new_type);
static void vala_method_find_base_interface_method (ValaMethod* self,
                                             ValaClass* cl);
static void vala_method_find_base_class_method (ValaMethod* self,
                                         ValaClass* cl);
static gboolean vala_method_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static ValaTraverseStatus ___lambda5_ (ValaMethod* self,
                                ValaCodeNode* node);
static ValaTraverseStatus ____lambda5__vala_traverse_func (ValaCodeNode* node,
                                                    gpointer self);
static ValaTraverseStatus __lambda6_ (Block2Data* _data2_,
                               ValaCodeNode* node);
static ValaTraverseStatus ___lambda6__vala_traverse_func (ValaCodeNode* node,
                                                   gpointer self);
static gboolean vala_method_is_possible_entry_point (ValaMethod* self,
                                              ValaCodeContext* context);
static void vala_method_real_get_defined_variables (ValaCodeNode* base,
                                             ValaCollection* collection);
static void vala_method_finalize (ValaCodeNode * obj);
static GType vala_method_get_type_once (void);

static inline gpointer
vala_method_get_instance_private (ValaMethod* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMethod_private_offset);
}

static ValaDataType*
vala_method_real_get_return_type (ValaCallable* base)
{
	ValaDataType* result;
	ValaMethod* self;
	ValaDataType* _tmp0_;
	self = (ValaMethod*) base;
	_tmp0_ = self->priv->_return_type;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_method_real_set_return_type (ValaCallable* base,
                                  ValaDataType* value)
{
	ValaMethod* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaMethod*) base;
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_return_type);
	self->priv->_return_type = _tmp0_;
	_tmp1_ = self->priv->_return_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

static gboolean
vala_method_real_get_has_result (ValaSubroutine* base)
{
	gboolean result;
	ValaMethod* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaMethod*) base;
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	result = !VALA_IS_VOID_TYPE (_tmp1_);
	return result;
}

ValaMemberBinding
vala_method_get_binding (ValaMethod* self)
{
	ValaMemberBinding result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_binding;
	return result;
}

void
vala_method_set_binding (ValaMethod* self,
                         ValaMemberBinding value)
{
	g_return_if_fail (self != NULL);
	self->priv->_binding = value;
}

gboolean
vala_method_get_is_abstract (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_abstract;
	return result;
}

void
vala_method_set_is_abstract (ValaMethod* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}

gboolean
vala_method_get_is_virtual (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_virtual;
	return result;
}

void
vala_method_set_is_virtual (ValaMethod* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_virtual = value;
}

gboolean
vala_method_get_overrides (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_overrides;
	return result;
}

void
vala_method_set_overrides (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_overrides = value;
}

gboolean
vala_method_get_is_inline (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_inline;
	return result;
}

void
vala_method_set_is_inline (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_inline = value;
}

gboolean
vala_method_get_returns_floating_reference (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "returns_floating_reference", FALSE);
	return result;
}

void
vala_method_set_returns_floating_reference (ValaMethod* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "CCode", "returns_floating_reference", value, NULL);
}

gboolean
vala_method_get_returns_modified_pointer (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ReturnsModifiedPointer");
	result = _tmp0_ != NULL;
	return result;
}

void
vala_method_set_returns_modified_pointer (ValaMethod* self,
                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "ReturnsModifiedPointer", value, NULL);
}

ValaMethod*
vala_method_get_base_method (ValaMethod* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_method_find_base_methods (self);
	_tmp0_ = self->priv->_base_method;
	result = _tmp0_;
	return result;
}

ValaMethod*
vala_method_get_base_interface_method (ValaMethod* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_method_find_base_methods (self);
	_tmp0_ = self->priv->_base_interface_method;
	result = _tmp0_;
	return result;
}

ValaDataType*
vala_method_get_base_interface_type (ValaMethod* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_interface_type;
	result = _tmp0_;
	return result;
}

void
vala_method_set_base_interface_type (ValaMethod* self,
                                     ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_interface_type);
	self->priv->_base_interface_type = _tmp0_;
	_tmp1_ = self->priv->_base_interface_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

gboolean
vala_method_get_entry_point (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_entry_point;
	return result;
}

static void
vala_method_set_entry_point (ValaMethod* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_entry_point = value;
}

gboolean
vala_method_get_is_main_block (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_main_block;
	return result;
}

static void
vala_method_set_is_main_block (ValaMethod* self,
                               gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_main_block = value;
}

ValaParameter*
vala_method_get_this_parameter (ValaMethod* self)
{
	ValaParameter* result;
	ValaParameter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_this_parameter;
	result = _tmp0_;
	return result;
}

void
vala_method_set_this_parameter (ValaMethod* self,
                                ValaParameter* value)
{
	ValaParameter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	self->priv->_this_parameter = _tmp0_;
}

gboolean
vala_method_get_printf_format (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "PrintfFormat");
	result = _tmp0_ != NULL;
	return result;
}

void
vala_method_set_printf_format (ValaMethod* self,
                               gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "PrintfFormat", value, NULL);
}

gboolean
vala_method_get_scanf_format (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ScanfFormat");
	result = _tmp0_ != NULL;
	return result;
}

void
vala_method_set_scanf_format (ValaMethod* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "ScanfFormat", value, NULL);
}

gboolean
vala_method_get_has_construct_function (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "has_construct_function", TRUE);
	return result;
}

void
vala_method_set_has_construct_function (ValaMethod* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "CCode", "has_construct_function", value, NULL);
}

ValaLocalVariable*
vala_method_get_params_array_var (ValaMethod* self)
{
	ValaLocalVariable* result;
	ValaLocalVariable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_params_array_var;
	result = _tmp0_;
	return result;
}

void
vala_method_set_params_array_var (ValaMethod* self,
                                  ValaLocalVariable* value)
{
	ValaLocalVariable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_params_array_var);
	self->priv->_params_array_var = _tmp0_;
}

ValaSignal*
vala_method_get_signal_reference (ValaMethod* self)
{
	ValaSignal* result;
	ValaSignal* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_signal_reference;
	result = _tmp0_;
	return result;
}

void
vala_method_set_signal_reference (ValaMethod* self,
                                  ValaSignal* value)
{
	g_return_if_fail (self != NULL);
	self->priv->_signal_reference = value;
}

gboolean
vala_method_get_closure (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_closure;
	return result;
}

void
vala_method_set_closure (ValaMethod* self,
                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_closure = value;
}

gboolean
vala_method_get_coroutine (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_coroutine;
	return result;
}

void
vala_method_set_coroutine (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_coroutine = value;
}

gboolean
vala_method_get_is_async_callback (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_async_callback;
	return result;
}

void
vala_method_set_is_async_callback (ValaMethod* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_async_callback = value;
}

/**
 * Creates a new method.
 *
 * @param name              method name
 * @param return_type       method return type
 * @param source_reference  reference to source code
 * @return                  newly created method
 */
ValaMethod*
vala_method_construct (GType object_type,
                       const gchar* name,
                       ValaDataType* return_type,
                       ValaSourceReference* source_reference,
                       ValaComment* comment)
{
	ValaMethod* self = NULL;
	g_return_val_if_fail (return_type != NULL, NULL);
	self = (ValaMethod*) vala_subroutine_construct (object_type, name, source_reference, comment);
	vala_callable_set_return_type ((ValaCallable*) self, return_type);
	return self;
}

ValaMethod*
vala_method_new (const gchar* name,
                 ValaDataType* return_type,
                 ValaSourceReference* source_reference,
                 ValaComment* comment)
{
	return vala_method_construct (VALA_TYPE_METHOD, name, return_type, source_reference, comment);
}

/**
 * Creates a new main block method.
 *
 * @param source_reference  reference to source code
 * @return                  newly created method
 */
ValaMethod*
vala_method_construct_main_block (GType object_type,
                                  ValaSourceReference* source_reference)
{
	ValaMethod* self = NULL;
	ValaVoidType* _tmp0_;
	ValaVoidType* _tmp1_;
	self = (ValaMethod*) vala_subroutine_construct (object_type, "main", source_reference, NULL);
	_tmp0_ = vala_void_type_new (NULL);
	_tmp1_ = _tmp0_;
	vala_callable_set_return_type ((ValaCallable*) self, (ValaDataType*) _tmp1_);
	_vala_code_node_unref0 (_tmp1_);
	vala_method_set_is_main_block (self, TRUE);
	return self;
}

ValaMethod*
vala_method_new_main_block (ValaSourceReference* source_reference)
{
	return vala_method_construct_main_block (VALA_TYPE_METHOD, source_reference);
}

/**
 * Appends parameter to this method.
 *
 * @param param a formal parameter
 */
static void
vala_method_real_add_parameter (ValaCallable* base,
                                ValaParameter* param)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaMethod*) base;
	g_return_if_fail (param != NULL);
	_tmp0_ = self->priv->parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, param);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) param);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) param);
}

static ValaList*
vala_method_real_get_parameters (ValaCallable* base)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	ValaList* result;
	self = (ValaMethod*) base;
	_tmp0_ = self->priv->parameters;
	result = _tmp0_;
	return result;
}

/**
 * Remove all parameters from this method.
 */
void
vala_method_clear_parameters (ValaMethod* self)
{
	ValaList* _tmp16_;
	g_return_if_fail (self != NULL);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		gint _param_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_param_list = _tmp0_;
		_tmp1_ = _param_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_param_size = _tmp3_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaParameter* param = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaParameter* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_param_index = _param_index + 1;
			_tmp4_ = _param_index;
			_tmp5_ = _param_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _param_list;
			_tmp7_ = vala_list_get (_tmp6_, _param_index);
			param = (ValaParameter*) _tmp7_;
			_tmp8_ = param;
			_tmp9_ = vala_parameter_get_ellipsis (_tmp8_);
			_tmp10_ = _tmp9_;
			if (!_tmp10_) {
				ValaScope* _tmp11_;
				ValaScope* _tmp12_;
				ValaParameter* _tmp13_;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				_tmp11_ = vala_symbol_get_scope ((ValaSymbol*) self);
				_tmp12_ = _tmp11_;
				_tmp13_ = param;
				_tmp14_ = vala_symbol_get_name ((ValaSymbol*) _tmp13_);
				_tmp15_ = _tmp14_;
				vala_scope_remove (_tmp12_, _tmp15_);
			}
			_vala_code_node_unref0 (param);
		}
	}
	_tmp16_ = self->priv->parameters;
	vala_collection_clear ((ValaCollection*) _tmp16_);
}

gboolean
vala_method_is_variadic (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		gint _param_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_param_list = _tmp0_;
		_tmp1_ = _param_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_param_size = _tmp3_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaParameter* param = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			ValaParameter* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			_param_index = _param_index + 1;
			_tmp4_ = _param_index;
			_tmp5_ = _param_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _param_list;
			_tmp7_ = vala_list_get (_tmp6_, _param_index);
			param = (ValaParameter*) _tmp7_;
			_tmp9_ = param;
			_tmp10_ = vala_parameter_get_ellipsis (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_) {
				_tmp8_ = TRUE;
			} else {
				ValaParameter* _tmp12_;
				gboolean _tmp13_;
				gboolean _tmp14_;
				_tmp12_ = param;
				_tmp13_ = vala_parameter_get_params_array (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp8_ = _tmp14_;
			}
			if (_tmp8_) {
				result = TRUE;
				_vala_code_node_unref0 (param);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
	}
	result = FALSE;
	return result;
}

static void
vala_method_real_accept (ValaCodeNode* base,
                         ValaCodeVisitor* visitor)
{
	ValaMethod * self;
	self = (ValaMethod*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method (visitor, self);
}

static void
vala_method_real_accept_children (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaMethod * self;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp13_;
	ValaDataType* _tmp14_;
	ValaList* _tmp26_;
	ValaLocalVariable* _tmp36_;
	ValaLocalVariable* _tmp37_;
	ValaList* _tmp40_;
	ValaList* _tmp50_;
	ValaBlock* _tmp60_;
	ValaBlock* _tmp61_;
	self = (ValaMethod*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp0_;
		gint _p_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _p_index = 0;
		_tmp0_ = vala_method_get_type_parameters (self);
		_p_list = _tmp0_;
		_tmp1_ = _p_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_p_size = _tmp3_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaTypeParameter* _tmp8_;
			_p_index = _p_index + 1;
			_tmp4_ = _p_index;
			_tmp5_ = _p_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _p_list;
			_tmp7_ = vala_list_get (_tmp6_, _p_index);
			p = (ValaTypeParameter*) _tmp7_;
			_tmp8_ = p;
			vala_code_node_accept ((ValaCodeNode*) _tmp8_, visitor);
			_vala_code_node_unref0 (p);
		}
	}
	_tmp9_ = vala_method_get_base_interface_type (self);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != NULL) {
		ValaDataType* _tmp11_;
		ValaDataType* _tmp12_;
		_tmp11_ = vala_method_get_base_interface_type (self);
		_tmp12_ = _tmp11_;
		vala_code_node_accept ((ValaCodeNode*) _tmp12_, visitor);
	}
	_tmp13_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp14_ = _tmp13_;
	if (_tmp14_ != NULL) {
		ValaDataType* _tmp15_;
		ValaDataType* _tmp16_;
		_tmp15_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp16_ = _tmp15_;
		vala_code_node_accept ((ValaCodeNode*) _tmp16_, visitor);
	}
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp17_;
		gint _param_size = 0;
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _param_index = 0;
		_tmp17_ = self->priv->parameters;
		_param_list = _tmp17_;
		_tmp18_ = _param_list;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_param_size = _tmp20_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			ValaParameter* param = NULL;
			ValaList* _tmp23_;
			gpointer _tmp24_;
			ValaParameter* _tmp25_;
			_param_index = _param_index + 1;
			_tmp21_ = _param_index;
			_tmp22_ = _param_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _param_list;
			_tmp24_ = vala_list_get (_tmp23_, _param_index);
			param = (ValaParameter*) _tmp24_;
			_tmp25_ = param;
			vala_code_node_accept ((ValaCodeNode*) _tmp25_, visitor);
			_vala_code_node_unref0 (param);
		}
	}
	_tmp26_ = self->error_types;
	if (_tmp26_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp27_;
			gint _error_type_size = 0;
			ValaList* _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			gint _error_type_index = 0;
			_tmp27_ = self->error_types;
			_error_type_list = _tmp27_;
			_tmp28_ = _error_type_list;
			_tmp29_ = vala_collection_get_size ((ValaCollection*) _tmp28_);
			_tmp30_ = _tmp29_;
			_error_type_size = _tmp30_;
			_error_type_index = -1;
			while (TRUE) {
				gint _tmp31_;
				gint _tmp32_;
				ValaDataType* error_type = NULL;
				ValaList* _tmp33_;
				gpointer _tmp34_;
				ValaDataType* _tmp35_;
				_error_type_index = _error_type_index + 1;
				_tmp31_ = _error_type_index;
				_tmp32_ = _error_type_size;
				if (!(_tmp31_ < _tmp32_)) {
					break;
				}
				_tmp33_ = _error_type_list;
				_tmp34_ = vala_list_get (_tmp33_, _error_type_index);
				error_type = (ValaDataType*) _tmp34_;
				_tmp35_ = error_type;
				vala_code_node_accept ((ValaCodeNode*) _tmp35_, visitor);
				_vala_code_node_unref0 (error_type);
			}
		}
	}
	_tmp36_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp37_ = _tmp36_;
	if (_tmp37_ != NULL) {
		ValaLocalVariable* _tmp38_;
		ValaLocalVariable* _tmp39_;
		_tmp38_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp39_ = _tmp38_;
		vala_code_node_accept ((ValaCodeNode*) _tmp39_, visitor);
	}
	_tmp40_ = self->priv->preconditions;
	if (_tmp40_ != NULL) {
		{
			ValaList* _precondition_list = NULL;
			ValaList* _tmp41_;
			gint _precondition_size = 0;
			ValaList* _tmp42_;
			gint _tmp43_;
			gint _tmp44_;
			gint _precondition_index = 0;
			_tmp41_ = self->priv->preconditions;
			_precondition_list = _tmp41_;
			_tmp42_ = _precondition_list;
			_tmp43_ = vala_collection_get_size ((ValaCollection*) _tmp42_);
			_tmp44_ = _tmp43_;
			_precondition_size = _tmp44_;
			_precondition_index = -1;
			while (TRUE) {
				gint _tmp45_;
				gint _tmp46_;
				ValaExpression* precondition = NULL;
				ValaList* _tmp47_;
				gpointer _tmp48_;
				ValaExpression* _tmp49_;
				_precondition_index = _precondition_index + 1;
				_tmp45_ = _precondition_index;
				_tmp46_ = _precondition_size;
				if (!(_tmp45_ < _tmp46_)) {
					break;
				}
				_tmp47_ = _precondition_list;
				_tmp48_ = vala_list_get (_tmp47_, _precondition_index);
				precondition = (ValaExpression*) _tmp48_;
				_tmp49_ = precondition;
				vala_code_node_accept ((ValaCodeNode*) _tmp49_, visitor);
				_vala_code_node_unref0 (precondition);
			}
		}
	}
	_tmp50_ = self->priv->postconditions;
	if (_tmp50_ != NULL) {
		{
			ValaList* _postcondition_list = NULL;
			ValaList* _tmp51_;
			gint _postcondition_size = 0;
			ValaList* _tmp52_;
			gint _tmp53_;
			gint _tmp54_;
			gint _postcondition_index = 0;
			_tmp51_ = self->priv->postconditions;
			_postcondition_list = _tmp51_;
			_tmp52_ = _postcondition_list;
			_tmp53_ = vala_collection_get_size ((ValaCollection*) _tmp52_);
			_tmp54_ = _tmp53_;
			_postcondition_size = _tmp54_;
			_postcondition_index = -1;
			while (TRUE) {
				gint _tmp55_;
				gint _tmp56_;
				ValaExpression* postcondition = NULL;
				ValaList* _tmp57_;
				gpointer _tmp58_;
				ValaExpression* _tmp59_;
				_postcondition_index = _postcondition_index + 1;
				_tmp55_ = _postcondition_index;
				_tmp56_ = _postcondition_size;
				if (!(_tmp55_ < _tmp56_)) {
					break;
				}
				_tmp57_ = _postcondition_list;
				_tmp58_ = vala_list_get (_tmp57_, _postcondition_index);
				postcondition = (ValaExpression*) _tmp58_;
				_tmp59_ = postcondition;
				vala_code_node_accept ((ValaCodeNode*) _tmp59_, visitor);
				_vala_code_node_unref0 (postcondition);
			}
		}
	}
	_tmp60_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp61_ = _tmp60_;
	if (_tmp61_ != NULL) {
		ValaBlock* _tmp62_;
		ValaBlock* _tmp63_;
		_tmp62_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp63_ = _tmp62_;
		vala_code_node_accept ((ValaCodeNode*) _tmp63_, visitor);
	}
}

/**
 * Checks whether the parameters and return type of this method are
 * compatible with the specified method
 *
 * @param base_method a method
 * @param invalid_match error string about which check failed
 * @return true if the specified method is compatible to this method
 */
gboolean
vala_method_compatible (ValaMethod* self,
                        ValaMethod* base_method,
                        gchar** invalid_match)
{
	gchar* _vala_invalid_match = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_method != NULL, FALSE);
	_tmp1_ = vala_method_compatible_internal (self, base_method, &_tmp0_, (ValaCodeNode*) self);
	_g_free0 (_vala_invalid_match);
	_vala_invalid_match = _tmp0_;
	result = _tmp1_;
	if (invalid_match) {
		*invalid_match = _vala_invalid_match;
	} else {
		_g_free0 (_vala_invalid_match);
	}
	return result;
}

/**
 * Checks whether the parameters and return type of this method are
 * compatible with the specified method
 *
 * @param base_method a method
 * @return true if the specified method is compatible to this method
 */
gboolean
vala_method_compatible_no_error (ValaMethod* self,
                                 ValaMethod* base_method)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_method != NULL, FALSE);
	result = vala_method_compatible_internal (self, base_method, NULL, NULL);
	return result;
}

static gboolean
vala_method_compatible_internal (ValaMethod* self,
                                 ValaMethod* base_method,
                                 gchar** invalid_match,
                                 ValaCodeNode* node_reference)
{
	gchar* _vala_invalid_match = NULL;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaObjectType* object_type = NULL;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaList* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	ValaList* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	ValaList* method_type_args = NULL;
	ValaDataType* return_type = NULL;
	ValaDataType* _tmp53_;
	ValaDataType* _tmp54_;
	ValaDataType* _tmp55_;
	ValaDataType* actual_base_type = NULL;
	ValaDataType* _tmp62_;
	ValaDataType* _tmp63_;
	ValaObjectType* _tmp64_;
	ValaList* _tmp65_;
	ValaDataType* _tmp66_;
	ValaDataType* _tmp67_;
	ValaDataType* _tmp68_;
	ValaIterator* method_params_it = NULL;
	ValaList* _tmp76_;
	ValaIterator* _tmp77_;
	gint param_index = 0;
	ValaIterator* _tmp126_;
	ValaArrayList* base_method_errors = NULL;
	GEqualFunc _tmp128_;
	ValaArrayList* _tmp129_;
	ValaArrayList* _tmp130_;
	ValaList* _tmp131_;
	gboolean _tmp154_;
	gboolean _tmp155_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_method != NULL, FALSE);
	if (self == base_method) {
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = NULL;
		result = TRUE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp0_ = self->priv->_binding;
	_tmp1_ = base_method->priv->_binding;
	if (_tmp0_ != _tmp1_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("incompatible binding");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp2_;
		result = FALSE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	object_type = NULL;
	_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_OBJECT_TYPE_SYMBOL (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaObjectType* _tmp7_;
		_tmp5_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), NULL);
		_vala_code_node_unref0 (object_type);
		object_type = _tmp7_;
		{
			ValaList* _type_parameter_list = NULL;
			ValaObjectType* _tmp8_;
			ValaObjectTypeSymbol* _tmp9_;
			ValaObjectTypeSymbol* _tmp10_;
			ValaList* _tmp11_;
			gint _type_parameter_size = 0;
			ValaList* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			gint _type_parameter_index = 0;
			_tmp8_ = object_type;
			_tmp9_ = vala_object_type_get_object_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_object_type_symbol_get_type_parameters (_tmp10_);
			_type_parameter_list = _tmp11_;
			_tmp12_ = _type_parameter_list;
			_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
			_tmp14_ = _tmp13_;
			_type_parameter_size = _tmp14_;
			_type_parameter_index = -1;
			while (TRUE) {
				gint _tmp15_;
				gint _tmp16_;
				ValaTypeParameter* type_parameter = NULL;
				ValaList* _tmp17_;
				gpointer _tmp18_;
				ValaGenericType* type_arg = NULL;
				ValaTypeParameter* _tmp19_;
				ValaGenericType* _tmp20_;
				ValaGenericType* _tmp21_;
				ValaObjectType* _tmp22_;
				ValaGenericType* _tmp23_;
				_type_parameter_index = _type_parameter_index + 1;
				_tmp15_ = _type_parameter_index;
				_tmp16_ = _type_parameter_size;
				if (!(_tmp15_ < _tmp16_)) {
					break;
				}
				_tmp17_ = _type_parameter_list;
				_tmp18_ = vala_list_get (_tmp17_, _type_parameter_index);
				type_parameter = (ValaTypeParameter*) _tmp18_;
				_tmp19_ = type_parameter;
				_tmp20_ = vala_generic_type_new (_tmp19_, NULL);
				type_arg = _tmp20_;
				_tmp21_ = type_arg;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp21_, TRUE);
				_tmp22_ = object_type;
				_tmp23_ = type_arg;
				vala_data_type_add_type_argument ((ValaDataType*) _tmp22_, (ValaDataType*) _tmp23_);
				_vala_code_node_unref0 (type_arg);
				_vala_code_node_unref0 (type_parameter);
			}
		}
	}
	_tmp24_ = vala_method_get_type_parameters (self);
	_tmp25_ = vala_collection_get_size ((ValaCollection*) _tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = vala_method_get_type_parameters (base_method);
	_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
	_tmp29_ = _tmp28_;
	if (_tmp26_ < _tmp29_) {
		gchar* _tmp30_;
		_tmp30_ = g_strdup ("too few type parameters");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp30_;
		result = FALSE;
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	} else {
		ValaList* _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
		ValaList* _tmp34_;
		gint _tmp35_;
		gint _tmp36_;
		_tmp31_ = vala_method_get_type_parameters (self);
		_tmp32_ = vala_collection_get_size ((ValaCollection*) _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_method_get_type_parameters (base_method);
		_tmp35_ = vala_collection_get_size ((ValaCollection*) _tmp34_);
		_tmp36_ = _tmp35_;
		if (_tmp33_ > _tmp36_) {
			gchar* _tmp37_;
			_tmp37_ = g_strdup ("too many type parameters");
			_g_free0 (_vala_invalid_match);
			_vala_invalid_match = _tmp37_;
			result = FALSE;
			_vala_code_node_unref0 (object_type);
			if (invalid_match) {
				*invalid_match = _vala_invalid_match;
			} else {
				_g_free0 (_vala_invalid_match);
			}
			return result;
		}
	}
	method_type_args = NULL;
	if (vala_method_has_type_parameters (self)) {
		GEqualFunc _tmp38_;
		ValaArrayList* _tmp39_;
		_tmp38_ = g_direct_equal;
		_tmp39_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp38_);
		_vala_iterable_unref0 (method_type_args);
		method_type_args = (ValaList*) _tmp39_;
		{
			ValaList* _type_parameter_list = NULL;
			ValaList* _tmp40_;
			gint _type_parameter_size = 0;
			ValaList* _tmp41_;
			gint _tmp42_;
			gint _tmp43_;
			gint _type_parameter_index = 0;
			_tmp40_ = vala_method_get_type_parameters (self);
			_type_parameter_list = _tmp40_;
			_tmp41_ = _type_parameter_list;
			_tmp42_ = vala_collection_get_size ((ValaCollection*) _tmp41_);
			_tmp43_ = _tmp42_;
			_type_parameter_size = _tmp43_;
			_type_parameter_index = -1;
			while (TRUE) {
				gint _tmp44_;
				gint _tmp45_;
				ValaTypeParameter* type_parameter = NULL;
				ValaList* _tmp46_;
				gpointer _tmp47_;
				ValaGenericType* type_arg = NULL;
				ValaTypeParameter* _tmp48_;
				ValaGenericType* _tmp49_;
				ValaGenericType* _tmp50_;
				ValaList* _tmp51_;
				ValaGenericType* _tmp52_;
				_type_parameter_index = _type_parameter_index + 1;
				_tmp44_ = _type_parameter_index;
				_tmp45_ = _type_parameter_size;
				if (!(_tmp44_ < _tmp45_)) {
					break;
				}
				_tmp46_ = _type_parameter_list;
				_tmp47_ = vala_list_get (_tmp46_, _type_parameter_index);
				type_parameter = (ValaTypeParameter*) _tmp47_;
				_tmp48_ = type_parameter;
				_tmp49_ = vala_generic_type_new (_tmp48_, NULL);
				type_arg = _tmp49_;
				_tmp50_ = type_arg;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp50_, TRUE);
				_tmp51_ = method_type_args;
				_tmp52_ = type_arg;
				vala_collection_add ((ValaCollection*) _tmp51_, (ValaDataType*) _tmp52_);
				_vala_code_node_unref0 (type_arg);
				_vala_code_node_unref0 (type_parameter);
			}
		}
	}
	_tmp53_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp54_ = _tmp53_;
	_tmp55_ = vala_data_type_copy (_tmp54_);
	return_type = _tmp55_;
	if (vala_code_node_has_attribute_argument ((ValaCodeNode*) self, "CCode", "returns_floating_reference")) {
		ValaDataType* _tmp56_;
		gboolean _tmp57_;
		gboolean _tmp58_;
		_tmp56_ = return_type;
		_tmp57_ = vala_method_get_returns_floating_reference (self);
		_tmp58_ = _tmp57_;
		vala_data_type_set_floating_reference (_tmp56_, _tmp58_);
	} else {
		ValaDataType* _tmp59_;
		gboolean _tmp60_;
		gboolean _tmp61_;
		_tmp59_ = return_type;
		_tmp60_ = vala_method_get_returns_floating_reference (base_method);
		_tmp61_ = _tmp60_;
		vala_data_type_set_floating_reference (_tmp59_, _tmp61_);
	}
	_tmp62_ = vala_callable_get_return_type ((ValaCallable*) base_method);
	_tmp63_ = _tmp62_;
	_tmp64_ = object_type;
	_tmp65_ = method_type_args;
	_tmp66_ = vala_data_type_get_actual_type (_tmp63_, (ValaDataType*) _tmp64_, _tmp65_, node_reference);
	actual_base_type = _tmp66_;
	_tmp67_ = return_type;
	_tmp68_ = actual_base_type;
	if (!vala_data_type_equals (_tmp67_, _tmp68_)) {
		ValaDataType* _tmp69_;
		gchar* _tmp70_;
		gchar* _tmp71_;
		ValaDataType* _tmp72_;
		gchar* _tmp73_;
		gchar* _tmp74_;
		gchar* _tmp75_;
		_tmp69_ = actual_base_type;
		_tmp70_ = vala_data_type_to_prototype_string (_tmp69_, NULL);
		_tmp71_ = _tmp70_;
		_tmp72_ = return_type;
		_tmp73_ = vala_data_type_to_prototype_string (_tmp72_, NULL);
		_tmp74_ = _tmp73_;
		_tmp75_ = g_strdup_printf ("Base method expected return type `%s', but `%s' was provided", _tmp71_, _tmp74_);
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp75_;
		_g_free0 (_tmp74_);
		_g_free0 (_tmp71_);
		result = FALSE;
		_vala_code_node_unref0 (actual_base_type);
		_vala_code_node_unref0 (return_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp76_ = self->priv->parameters;
	_tmp77_ = vala_iterable_iterator ((ValaIterable*) _tmp76_);
	method_params_it = _tmp77_;
	param_index = 1;
	{
		ValaList* _base_param_list = NULL;
		ValaList* _tmp78_;
		gint _base_param_size = 0;
		ValaList* _tmp79_;
		gint _tmp80_;
		gint _tmp81_;
		gint _base_param_index = 0;
		_tmp78_ = base_method->priv->parameters;
		_base_param_list = _tmp78_;
		_tmp79_ = _base_param_list;
		_tmp80_ = vala_collection_get_size ((ValaCollection*) _tmp79_);
		_tmp81_ = _tmp80_;
		_base_param_size = _tmp81_;
		_base_param_index = -1;
		while (TRUE) {
			gint _tmp82_;
			gint _tmp83_;
			ValaParameter* base_param = NULL;
			ValaList* _tmp84_;
			gpointer _tmp85_;
			ValaIterator* _tmp86_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp88_;
			gpointer _tmp89_;
			ValaParameter* _tmp90_;
			gboolean _tmp91_;
			gboolean _tmp92_;
			ValaParameter* _tmp93_;
			gboolean _tmp94_;
			gboolean _tmp95_;
			ValaParameter* _tmp97_;
			gboolean _tmp98_;
			gboolean _tmp99_;
			ValaParameter* _tmp100_;
			gboolean _tmp101_;
			gboolean _tmp102_;
			ValaParameter* _tmp104_;
			gboolean _tmp105_;
			gboolean _tmp106_;
			gint _tmp125_;
			_base_param_index = _base_param_index + 1;
			_tmp82_ = _base_param_index;
			_tmp83_ = _base_param_size;
			if (!(_tmp82_ < _tmp83_)) {
				break;
			}
			_tmp84_ = _base_param_list;
			_tmp85_ = vala_list_get (_tmp84_, _base_param_index);
			base_param = (ValaParameter*) _tmp85_;
			_tmp86_ = method_params_it;
			if (!vala_iterator_next (_tmp86_)) {
				gchar* _tmp87_;
				_tmp87_ = g_strdup ("too few parameters");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp87_;
				result = FALSE;
				_vala_code_node_unref0 (base_param);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_code_node_unref0 (return_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp88_ = method_params_it;
			_tmp89_ = vala_iterator_get (_tmp88_);
			param = (ValaParameter*) _tmp89_;
			_tmp90_ = base_param;
			_tmp91_ = vala_parameter_get_ellipsis (_tmp90_);
			_tmp92_ = _tmp91_;
			_tmp93_ = param;
			_tmp94_ = vala_parameter_get_ellipsis (_tmp93_);
			_tmp95_ = _tmp94_;
			if (_tmp92_ != _tmp95_) {
				gchar* _tmp96_;
				_tmp96_ = g_strdup ("ellipsis parameter mismatch");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp96_;
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (base_param);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_code_node_unref0 (return_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp97_ = base_param;
			_tmp98_ = vala_parameter_get_params_array (_tmp97_);
			_tmp99_ = _tmp98_;
			_tmp100_ = param;
			_tmp101_ = vala_parameter_get_params_array (_tmp100_);
			_tmp102_ = _tmp101_;
			if (_tmp99_ != _tmp102_) {
				gchar* _tmp103_;
				_tmp103_ = g_strdup ("params array parameter mismatch");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp103_;
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (base_param);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_code_node_unref0 (return_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp104_ = base_param;
			_tmp105_ = vala_parameter_get_ellipsis (_tmp104_);
			_tmp106_ = _tmp105_;
			if (!_tmp106_) {
				ValaParameter* _tmp107_;
				ValaParameterDirection _tmp108_;
				ValaParameterDirection _tmp109_;
				ValaParameter* _tmp110_;
				ValaParameterDirection _tmp111_;
				ValaParameterDirection _tmp112_;
				ValaParameter* _tmp114_;
				ValaDataType* _tmp115_;
				ValaDataType* _tmp116_;
				ValaObjectType* _tmp117_;
				ValaList* _tmp118_;
				ValaDataType* _tmp119_;
				ValaDataType* _tmp120_;
				ValaParameter* _tmp121_;
				ValaDataType* _tmp122_;
				ValaDataType* _tmp123_;
				_tmp107_ = base_param;
				_tmp108_ = vala_parameter_get_direction (_tmp107_);
				_tmp109_ = _tmp108_;
				_tmp110_ = param;
				_tmp111_ = vala_parameter_get_direction (_tmp110_);
				_tmp112_ = _tmp111_;
				if (_tmp109_ != _tmp112_) {
					gchar* _tmp113_;
					_tmp113_ = g_strdup_printf ("incompatible direction of parameter %d", param_index);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp113_;
					result = FALSE;
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (base_param);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_code_node_unref0 (return_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
				_tmp114_ = base_param;
				_tmp115_ = vala_variable_get_variable_type ((ValaVariable*) _tmp114_);
				_tmp116_ = _tmp115_;
				_tmp117_ = object_type;
				_tmp118_ = method_type_args;
				_tmp119_ = vala_data_type_get_actual_type (_tmp116_, (ValaDataType*) _tmp117_, _tmp118_, node_reference);
				_vala_code_node_unref0 (actual_base_type);
				actual_base_type = _tmp119_;
				_tmp120_ = actual_base_type;
				_tmp121_ = param;
				_tmp122_ = vala_variable_get_variable_type ((ValaVariable*) _tmp121_);
				_tmp123_ = _tmp122_;
				if (!vala_data_type_equals (_tmp120_, _tmp123_)) {
					gchar* _tmp124_;
					_tmp124_ = g_strdup_printf ("incompatible type of parameter %d", param_index);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp124_;
					result = FALSE;
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (base_param);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_code_node_unref0 (return_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
			}
			_tmp125_ = param_index;
			param_index = _tmp125_ + 1;
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (base_param);
		}
	}
	_tmp126_ = method_params_it;
	if (vala_iterator_next (_tmp126_)) {
		gchar* _tmp127_;
		_tmp127_ = g_strdup ("too many parameters");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp127_;
		result = FALSE;
		_vala_iterator_unref0 (method_params_it);
		_vala_code_node_unref0 (actual_base_type);
		_vala_code_node_unref0 (return_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp128_ = g_direct_equal;
	_tmp129_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp128_);
	base_method_errors = _tmp129_;
	_tmp130_ = base_method_errors;
	vala_code_node_get_error_types ((ValaCodeNode*) base_method, (ValaCollection*) _tmp130_, NULL);
	_tmp131_ = self->error_types;
	if (_tmp131_ != NULL) {
		{
			ValaList* _method_error_type_list = NULL;
			ValaList* _tmp132_;
			gint _method_error_type_size = 0;
			ValaList* _tmp133_;
			gint _tmp134_;
			gint _tmp135_;
			gint _method_error_type_index = 0;
			_tmp132_ = self->error_types;
			_method_error_type_list = _tmp132_;
			_tmp133_ = _method_error_type_list;
			_tmp134_ = vala_collection_get_size ((ValaCollection*) _tmp133_);
			_tmp135_ = _tmp134_;
			_method_error_type_size = _tmp135_;
			_method_error_type_index = -1;
			while (TRUE) {
				gint _tmp136_;
				gint _tmp137_;
				ValaDataType* method_error_type = NULL;
				ValaList* _tmp138_;
				gpointer _tmp139_;
				gboolean match = FALSE;
				_method_error_type_index = _method_error_type_index + 1;
				_tmp136_ = _method_error_type_index;
				_tmp137_ = _method_error_type_size;
				if (!(_tmp136_ < _tmp137_)) {
					break;
				}
				_tmp138_ = _method_error_type_list;
				_tmp139_ = vala_list_get (_tmp138_, _method_error_type_index);
				method_error_type = (ValaDataType*) _tmp139_;
				match = FALSE;
				{
					ValaArrayList* _base_method_error_type_list = NULL;
					ValaArrayList* _tmp140_;
					gint _base_method_error_type_size = 0;
					ValaArrayList* _tmp141_;
					gint _tmp142_;
					gint _tmp143_;
					gint _base_method_error_type_index = 0;
					_tmp140_ = base_method_errors;
					_base_method_error_type_list = _tmp140_;
					_tmp141_ = _base_method_error_type_list;
					_tmp142_ = vala_collection_get_size ((ValaCollection*) _tmp141_);
					_tmp143_ = _tmp142_;
					_base_method_error_type_size = _tmp143_;
					_base_method_error_type_index = -1;
					while (TRUE) {
						gint _tmp144_;
						gint _tmp145_;
						ValaDataType* base_method_error_type = NULL;
						ValaArrayList* _tmp146_;
						gpointer _tmp147_;
						ValaDataType* _tmp148_;
						ValaDataType* _tmp149_;
						_base_method_error_type_index = _base_method_error_type_index + 1;
						_tmp144_ = _base_method_error_type_index;
						_tmp145_ = _base_method_error_type_size;
						if (!(_tmp144_ < _tmp145_)) {
							break;
						}
						_tmp146_ = _base_method_error_type_list;
						_tmp147_ = vala_list_get ((ValaList*) _tmp146_, _base_method_error_type_index);
						base_method_error_type = (ValaDataType*) _tmp147_;
						_tmp148_ = method_error_type;
						_tmp149_ = base_method_error_type;
						if (vala_data_type_compatible (_tmp148_, _tmp149_)) {
							match = TRUE;
							_vala_code_node_unref0 (base_method_error_type);
							break;
						}
						_vala_code_node_unref0 (base_method_error_type);
					}
				}
				if (!match) {
					ValaDataType* _tmp150_;
					gchar* _tmp151_;
					gchar* _tmp152_;
					gchar* _tmp153_;
					_tmp150_ = method_error_type;
					_tmp151_ = vala_code_node_to_string ((ValaCodeNode*) _tmp150_);
					_tmp152_ = _tmp151_;
					_tmp153_ = g_strdup_printf ("incompatible error type `%s'", _tmp152_);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp153_;
					_g_free0 (_tmp152_);
					result = FALSE;
					_vala_code_node_unref0 (method_error_type);
					_vala_iterable_unref0 (base_method_errors);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_code_node_unref0 (return_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
				_vala_code_node_unref0 (method_error_type);
			}
		}
	}
	_tmp154_ = base_method->priv->_coroutine;
	_tmp155_ = self->priv->_coroutine;
	if (_tmp154_ != _tmp155_) {
		gchar* _tmp156_;
		_tmp156_ = g_strdup ("async mismatch");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp156_;
		result = FALSE;
		_vala_iterable_unref0 (base_method_errors);
		_vala_iterator_unref0 (method_params_it);
		_vala_code_node_unref0 (actual_base_type);
		_vala_code_node_unref0 (return_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_g_free0 (_vala_invalid_match);
	_vala_invalid_match = NULL;
	result = TRUE;
	_vala_iterable_unref0 (base_method_errors);
	_vala_iterator_unref0 (method_params_it);
	_vala_code_node_unref0 (actual_base_type);
	_vala_code_node_unref0 (return_type);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (object_type);
	if (invalid_match) {
		*invalid_match = _vala_invalid_match;
	} else {
		_g_free0 (_vala_invalid_match);
	}
	return result;
}

/**
 * Appends the specified parameter to the list of type parameters.
 *
 * @param p a type parameter
 */
void
vala_method_add_type_parameter (ValaMethod* self,
                                ValaTypeParameter* p)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaScope* _tmp4_;
	ValaScope* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->type_parameters);
		self->priv->type_parameters = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->type_parameters;
	vala_collection_add ((ValaCollection*) _tmp3_, p);
	_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_symbol_get_name ((ValaSymbol*) p);
	_tmp7_ = _tmp6_;
	vala_scope_add (_tmp5_, _tmp7_, (ValaSymbol*) p);
}

/**
 * Returns the type parameter list.
 *
 * @return list of type parameters
 */
ValaList*
vala_method_get_type_parameters (ValaMethod* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp2_;
	ValaList* _tmp5_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		_tmp1_ = self->priv->type_parameters;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = vala_method__empty_type_parameter_list;
	if (_tmp2_ == NULL) {
		GEqualFunc _tmp3_;
		ValaArrayList* _tmp4_;
		_tmp3_ = g_direct_equal;
		_tmp4_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp3_);
		_vala_iterable_unref0 (vala_method__empty_type_parameter_list);
		vala_method__empty_type_parameter_list = (ValaList*) _tmp4_;
	}
	_tmp5_ = vala_method__empty_type_parameter_list;
	result = _tmp5_;
	return result;
}

gint
vala_method_get_type_parameter_index (ValaMethod* self,
                                      const gchar* name)
{
	ValaList* _tmp0_;
	gint i = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (name != NULL, 0);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ == NULL) {
		result = -1;
		return result;
	}
	i = 0;
	{
		ValaList* _parameter_list = NULL;
		ValaList* _tmp1_;
		gint _parameter_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _parameter_index = 0;
		_tmp1_ = self->priv->type_parameters;
		_parameter_list = _tmp1_;
		_tmp2_ = _parameter_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_parameter_size = _tmp4_;
		_parameter_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaTypeParameter* parameter = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaTypeParameter* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			gint _tmp12_;
			_parameter_index = _parameter_index + 1;
			_tmp5_ = _parameter_index;
			_tmp6_ = _parameter_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _parameter_list;
			_tmp8_ = vala_list_get (_tmp7_, _parameter_index);
			parameter = (ValaTypeParameter*) _tmp8_;
			_tmp9_ = parameter;
			_tmp10_ = vala_symbol_get_name ((ValaSymbol*) _tmp9_);
			_tmp11_ = _tmp10_;
			if (g_strcmp0 (_tmp11_, name) == 0) {
				result = i;
				_vala_code_node_unref0 (parameter);
				return result;
			}
			_tmp12_ = i;
			i = _tmp12_ + 1;
			_vala_code_node_unref0 (parameter);
		}
	}
	result = -1;
	return result;
}

gboolean
vala_method_has_type_parameters (ValaMethod* self)
{
	gboolean _tmp0_ = FALSE;
	ValaList* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->type_parameters;
	if (_tmp1_ != NULL) {
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->type_parameters;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

/**
 * Adds a precondition to this method.
 *
 * @param precondition a boolean precondition expression
 */
void
vala_method_add_precondition (ValaMethod* self,
                              ValaExpression* precondition)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (precondition != NULL);
	_tmp0_ = self->priv->preconditions;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->preconditions);
		self->priv->preconditions = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->preconditions;
	vala_collection_add ((ValaCollection*) _tmp3_, precondition);
	vala_code_node_set_parent_node ((ValaCodeNode*) precondition, (ValaCodeNode*) self);
}

/**
 * Returns the list of preconditions of this method.
 *
 * @return list of preconditions
 */
ValaList*
vala_method_get_preconditions (ValaMethod* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp2_;
	ValaList* _tmp5_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->preconditions;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		_tmp1_ = self->priv->preconditions;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = vala_method__empty_expression_list;
	if (_tmp2_ == NULL) {
		GEqualFunc _tmp3_;
		ValaArrayList* _tmp4_;
		_tmp3_ = g_direct_equal;
		_tmp4_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp3_);
		_vala_iterable_unref0 (vala_method__empty_expression_list);
		vala_method__empty_expression_list = (ValaList*) _tmp4_;
	}
	_tmp5_ = vala_method__empty_expression_list;
	result = _tmp5_;
	return result;
}

/**
 * Adds a postcondition to this method.
 *
 * @param postcondition a boolean postcondition expression
 */
void
vala_method_add_postcondition (ValaMethod* self,
                               ValaExpression* postcondition)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (postcondition != NULL);
	_tmp0_ = self->priv->postconditions;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->postconditions);
		self->priv->postconditions = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->postconditions;
	vala_collection_add ((ValaCollection*) _tmp3_, postcondition);
	vala_code_node_set_parent_node ((ValaCodeNode*) postcondition, (ValaCodeNode*) self);
}

/**
 * Returns the list of postconditions of this method.
 *
 * @return list of postconditions
 */
ValaList*
vala_method_get_postconditions (ValaMethod* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp2_;
	ValaList* _tmp5_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->postconditions;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		_tmp1_ = self->priv->postconditions;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = vala_method__empty_expression_list;
	if (_tmp2_ == NULL) {
		GEqualFunc _tmp3_;
		ValaArrayList* _tmp4_;
		_tmp3_ = g_direct_equal;
		_tmp4_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp3_);
		_vala_iterable_unref0 (vala_method__empty_expression_list);
		vala_method__empty_expression_list = (ValaList*) _tmp4_;
	}
	_tmp5_ = vala_method__empty_expression_list;
	result = _tmp5_;
	return result;
}

/**
 * Adds an error type to the exceptions that can be
 * thrown by this method.
 */
void
vala_method_add_error_type (ValaMethod* self,
                            ValaDataType* error_type)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_type != NULL);
	_tmp0_ = self->error_types;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->error_types);
		self->error_types = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->error_types;
	vala_collection_add ((ValaCollection*) _tmp3_, error_type);
	vala_code_node_set_parent_node ((ValaCodeNode*) error_type, (ValaCodeNode*) self);
}

static void
vala_method_real_get_error_types (ValaCodeNode* base,
                                  ValaCollection* collection,
                                  ValaSourceReference* source_reference)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	self = (ValaMethod*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = self->error_types;
	if (_tmp0_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp1_;
			gint _error_type_size = 0;
			ValaList* _tmp2_;
			gint _tmp3_;
			gint _tmp4_;
			gint _error_type_index = 0;
			_tmp1_ = self->error_types;
			_error_type_list = _tmp1_;
			_tmp2_ = _error_type_list;
			_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
			_tmp4_ = _tmp3_;
			_error_type_size = _tmp4_;
			_error_type_index = -1;
			while (TRUE) {
				gint _tmp5_;
				gint _tmp6_;
				ValaDataType* error_type = NULL;
				ValaList* _tmp7_;
				gpointer _tmp8_;
				_error_type_index = _error_type_index + 1;
				_tmp5_ = _error_type_index;
				_tmp6_ = _error_type_size;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				_tmp7_ = _error_type_list;
				_tmp8_ = vala_list_get (_tmp7_, _error_type_index);
				error_type = (ValaDataType*) _tmp8_;
				if (source_reference != NULL) {
					ValaDataType* type = NULL;
					ValaDataType* _tmp9_;
					ValaDataType* _tmp10_;
					ValaDataType* _tmp11_;
					ValaDataType* _tmp12_;
					_tmp9_ = error_type;
					_tmp10_ = vala_data_type_copy (_tmp9_);
					type = _tmp10_;
					_tmp11_ = type;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp11_, source_reference);
					_tmp12_ = type;
					vala_collection_add (collection, _tmp12_);
					_vala_code_node_unref0 (type);
				} else {
					ValaDataType* _tmp13_;
					_tmp13_ = error_type;
					vala_collection_add (collection, _tmp13_);
				}
				_vala_code_node_unref0 (error_type);
			}
		}
	}
}

static void
vala_method_real_replace_expression (ValaCodeNode* base,
                                     ValaExpression* old_node,
                                     ValaExpression* new_node)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	self = (ValaMethod*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = self->priv->preconditions;
	if (_tmp0_ != NULL) {
		gint index = 0;
		ValaList* _tmp1_;
		_tmp1_ = self->priv->preconditions;
		index = vala_list_index_of (_tmp1_, old_node);
		if (index >= 0) {
			ValaList* _tmp2_;
			_tmp2_ = self->priv->preconditions;
			vala_list_set (_tmp2_, index, new_node);
			vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
		}
	}
	_tmp3_ = self->priv->postconditions;
	if (_tmp3_ != NULL) {
		gint index = 0;
		ValaList* _tmp4_;
		_tmp4_ = self->priv->postconditions;
		index = vala_list_index_of (_tmp4_, old_node);
		if (index >= 0) {
			ValaList* _tmp5_;
			_tmp5_ = self->priv->postconditions;
			vala_list_set (_tmp5_, index, new_node);
			vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
		}
	}
}

static void
vala_method_real_replace_type (ValaCodeNode* base,
                               ValaDataType* old_type,
                               ValaDataType* new_type)
{
	ValaMethod * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaList* _tmp4_;
	self = (ValaMethod*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_method_get_base_interface_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_method_set_base_interface_type (self, new_type);
		return;
	}
	_tmp2_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_type) {
		vala_callable_set_return_type ((ValaCallable*) self, new_type);
		return;
	}
	_tmp4_ = self->error_types;
	if (_tmp4_ != NULL) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					ValaList* _tmp7_;
					gint _tmp8_;
					gint _tmp9_;
					ValaList* _tmp10_;
					gpointer _tmp11_;
					ValaDataType* _tmp12_;
					gboolean _tmp13_;
					if (!_tmp5_) {
						gint _tmp6_;
						_tmp6_ = i;
						i = _tmp6_ + 1;
					}
					_tmp5_ = FALSE;
					_tmp7_ = self->error_types;
					_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
					_tmp9_ = _tmp8_;
					if (!(i < _tmp9_)) {
						break;
					}
					_tmp10_ = self->error_types;
					_tmp11_ = vala_list_get (_tmp10_, i);
					_tmp12_ = (ValaDataType*) _tmp11_;
					_tmp13_ = _tmp12_ == old_type;
					_vala_code_node_unref0 (_tmp12_);
					if (_tmp13_) {
						ValaList* _tmp14_;
						_tmp14_ = self->error_types;
						vala_list_set (_tmp14_, i, new_type);
						return;
					}
				}
			}
		}
	}
}

static void
vala_method_find_base_methods (ValaMethod* self)
{
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	g_return_if_fail (self != NULL);
	if (self->priv->base_methods_valid) {
		return;
	}
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	if (VALA_IS_CLASS (_tmp1_)) {
		if (!VALA_IS_CREATION_METHOD (self)) {
			ValaSymbol* _tmp2_;
			ValaSymbol* _tmp3_;
			gboolean _tmp4_ = FALSE;
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_;
			_tmp2_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp3_ = _tmp2_;
			vala_method_find_base_interface_method (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_CLASS, ValaClass));
			_tmp6_ = self->priv->_is_virtual;
			if (_tmp6_) {
				_tmp5_ = TRUE;
			} else {
				gboolean _tmp7_;
				_tmp7_ = self->priv->_is_abstract;
				_tmp5_ = _tmp7_;
			}
			if (_tmp5_) {
				_tmp4_ = TRUE;
			} else {
				gboolean _tmp8_;
				_tmp8_ = self->priv->_overrides;
				_tmp4_ = _tmp8_;
			}
			if (_tmp4_) {
				ValaSymbol* _tmp9_;
				ValaSymbol* _tmp10_;
				_tmp9_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp10_ = _tmp9_;
				vala_method_find_base_class_method (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_CLASS, ValaClass));
			}
		}
	} else {
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		_tmp11_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp12_ = _tmp11_;
		if (VALA_IS_INTERFACE (_tmp12_)) {
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_;
			_tmp14_ = self->priv->_is_virtual;
			if (_tmp14_) {
				_tmp13_ = TRUE;
			} else {
				gboolean _tmp15_;
				_tmp15_ = self->priv->_is_abstract;
				_tmp13_ = _tmp15_;
			}
			if (_tmp13_) {
				self->priv->_base_interface_method = self;
			}
		}
	}
	self->priv->base_methods_valid = TRUE;
}

static void
vala_method_find_base_class_method (ValaMethod* self,
                                    ValaClass* cl)
{
	ValaSymbol* sym = NULL;
	ValaScope* _tmp0_;
	ValaScope* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaSymbol* _tmp11_;
	ValaClass* _tmp34_;
	ValaClass* _tmp35_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_symbol_get_scope ((ValaSymbol*) cl);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_scope_lookup (_tmp1_, _tmp3_);
	sym = _tmp4_;
	_tmp5_ = sym;
	if (VALA_IS_SIGNAL (_tmp5_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp6_;
		ValaSignal* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaSymbol* _tmp10_;
		_tmp6_ = sym;
		sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_SIGNAL, ValaSignal);
		_tmp7_ = sig;
		_tmp8_ = vala_signal_get_default_handler (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp9_);
		_vala_code_node_unref0 (sym);
		sym = _tmp10_;
	}
	_tmp11_ = sym;
	if (VALA_IS_METHOD (_tmp11_)) {
		ValaMethod* base_method = NULL;
		ValaSymbol* _tmp12_;
		gboolean _tmp13_ = FALSE;
		ValaMethod* _tmp14_;
		gboolean _tmp15_;
		_tmp12_ = sym;
		base_method = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_METHOD, ValaMethod);
		_tmp14_ = base_method;
		_tmp15_ = _tmp14_->priv->_is_abstract;
		if (_tmp15_) {
			_tmp13_ = TRUE;
		} else {
			ValaMethod* _tmp16_;
			gboolean _tmp17_;
			_tmp16_ = base_method;
			_tmp17_ = _tmp16_->priv->_is_virtual;
			_tmp13_ = _tmp17_;
		}
		if (_tmp13_) {
			gchar* invalid_match = NULL;
			ValaMethod* _tmp18_;
			gchar* _tmp19_ = NULL;
			gboolean _tmp20_;
			ValaMethod* _tmp31_;
			ValaMethod* _tmp32_;
			ValaMethod* _tmp33_;
			_tmp18_ = base_method;
			_tmp20_ = vala_method_compatible (self, _tmp18_, &_tmp19_);
			_g_free0 (invalid_match);
			invalid_match = _tmp19_;
			if (!_tmp20_) {
				ValaMethodType* base_method_type = NULL;
				ValaMethod* _tmp21_;
				ValaMethodType* _tmp22_;
				ValaSourceReference* _tmp23_;
				ValaSourceReference* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				ValaMethodType* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				const gchar* _tmp30_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp21_ = base_method;
				_tmp22_ = vala_method_type_new (_tmp21_, NULL);
				base_method_type = _tmp22_;
				_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp24_ = _tmp23_;
				_tmp25_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp26_ = _tmp25_;
				_tmp27_ = base_method_type;
				_tmp28_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp27_, NULL);
				_tmp29_ = _tmp28_;
				_tmp30_ = invalid_match;
				vala_report_error (_tmp24_, "overriding method `%s' is incompatible with base method `%s': %s.", _tmp26_, _tmp29_, _tmp30_);
				_g_free0 (_tmp29_);
				_g_free0 (_tmp26_);
				_vala_code_node_unref0 (base_method_type);
				_g_free0 (invalid_match);
				_vala_code_node_unref0 (sym);
				return;
			}
			_tmp31_ = base_method;
			self->priv->_base_method = _tmp31_;
			_tmp32_ = base_method;
			vala_code_node_copy_attribute_double ((ValaCodeNode*) self, (ValaCodeNode*) _tmp32_, "CCode", "instance_pos");
			_tmp33_ = base_method;
			vala_code_node_copy_attribute_bool ((ValaCodeNode*) self, (ValaCodeNode*) _tmp33_, "CCode", "returns_floating_reference");
			_g_free0 (invalid_match);
			_vala_code_node_unref0 (sym);
			return;
		}
	}
	_tmp34_ = vala_class_get_base_class (cl);
	_tmp35_ = _tmp34_;
	if (_tmp35_ != NULL) {
		ValaClass* _tmp36_;
		ValaClass* _tmp37_;
		_tmp36_ = vala_class_get_base_class (cl);
		_tmp37_ = _tmp36_;
		vala_method_find_base_class_method (self, _tmp37_);
	}
	_vala_code_node_unref0 (sym);
}

static void
vala_method_find_base_interface_method (ValaMethod* self,
                                        ValaClass* cl)
{
	ValaMethod* base_match = NULL;
	gchar* invalid_error = NULL;
	ValaMethod* invalid_base_match = NULL;
	ValaMethod* _tmp69_;
	ValaDataType* _tmp87_;
	ValaDataType* _tmp88_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	base_match = NULL;
	invalid_error = NULL;
	invalid_base_match = NULL;
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		gint _type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _type_index = 0;
		_tmp0_ = vala_class_get_base_types (cl);
		_type_list = _tmp0_;
		_tmp1_ = _type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_type_size = _tmp3_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* type = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaDataType* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			_type_index = _type_index + 1;
			_tmp4_ = _type_index;
			_tmp5_ = _type_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _type_list;
			_tmp7_ = vala_list_get (_tmp6_, _type_index);
			type = (ValaDataType*) _tmp7_;
			_tmp8_ = type;
			_tmp9_ = vala_data_type_get_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			if (VALA_IS_INTERFACE (_tmp10_)) {
				gboolean _tmp11_ = FALSE;
				ValaDataType* _tmp12_;
				ValaDataType* _tmp13_;
				ValaSymbol* sym = NULL;
				ValaDataType* _tmp21_;
				ValaTypeSymbol* _tmp22_;
				ValaTypeSymbol* _tmp23_;
				ValaScope* _tmp24_;
				ValaScope* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				ValaSymbol* _tmp28_;
				ValaSymbol* _tmp29_;
				ValaSymbol* _tmp35_;
				_tmp12_ = vala_method_get_base_interface_type (self);
				_tmp13_ = _tmp12_;
				if (_tmp13_ != NULL) {
					ValaDataType* _tmp14_;
					ValaDataType* _tmp15_;
					ValaTypeSymbol* _tmp16_;
					ValaTypeSymbol* _tmp17_;
					ValaDataType* _tmp18_;
					ValaTypeSymbol* _tmp19_;
					ValaTypeSymbol* _tmp20_;
					_tmp14_ = vala_method_get_base_interface_type (self);
					_tmp15_ = _tmp14_;
					_tmp16_ = vala_data_type_get_type_symbol (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = type;
					_tmp19_ = vala_data_type_get_type_symbol (_tmp18_);
					_tmp20_ = _tmp19_;
					_tmp11_ = _tmp17_ != _tmp20_;
				} else {
					_tmp11_ = FALSE;
				}
				if (_tmp11_) {
					_vala_code_node_unref0 (type);
					continue;
				}
				_tmp21_ = type;
				_tmp22_ = vala_data_type_get_type_symbol (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = vala_symbol_get_scope ((ValaSymbol*) _tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = vala_symbol_get_name ((ValaSymbol*) self);
				_tmp27_ = _tmp26_;
				_tmp28_ = vala_scope_lookup (_tmp25_, _tmp27_);
				sym = _tmp28_;
				_tmp29_ = sym;
				if (VALA_IS_SIGNAL (_tmp29_)) {
					ValaSignal* sig = NULL;
					ValaSymbol* _tmp30_;
					ValaSignal* _tmp31_;
					ValaMethod* _tmp32_;
					ValaMethod* _tmp33_;
					ValaSymbol* _tmp34_;
					_tmp30_ = sym;
					sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, VALA_TYPE_SIGNAL, ValaSignal);
					_tmp31_ = sig;
					_tmp32_ = vala_signal_get_default_handler (_tmp31_);
					_tmp33_ = _tmp32_;
					_tmp34_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp33_);
					_vala_code_node_unref0 (sym);
					sym = _tmp34_;
				}
				_tmp35_ = sym;
				if (VALA_IS_METHOD (_tmp35_)) {
					ValaMethod* base_method = NULL;
					ValaSymbol* _tmp36_;
					gboolean _tmp37_ = FALSE;
					ValaMethod* _tmp38_;
					gboolean _tmp39_;
					_tmp36_ = sym;
					base_method = G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, VALA_TYPE_METHOD, ValaMethod);
					_tmp38_ = base_method;
					_tmp39_ = _tmp38_->priv->_is_abstract;
					if (_tmp39_) {
						_tmp37_ = TRUE;
					} else {
						ValaMethod* _tmp40_;
						gboolean _tmp41_;
						_tmp40_ = base_method;
						_tmp41_ = _tmp40_->priv->_is_virtual;
						_tmp37_ = _tmp41_;
					}
					if (_tmp37_) {
						ValaDataType* _tmp42_;
						ValaDataType* _tmp43_;
						gchar* invalid_match = NULL;
						ValaMethod* _tmp60_;
						gchar* _tmp61_ = NULL;
						gboolean _tmp62_;
						_tmp42_ = vala_method_get_base_interface_type (self);
						_tmp43_ = _tmp42_;
						if (_tmp43_ == NULL) {
							gboolean has_explicit_implementation = FALSE;
							has_explicit_implementation = FALSE;
							{
								ValaList* _m_list = NULL;
								ValaList* _tmp44_;
								gint _m_size = 0;
								ValaList* _tmp45_;
								gint _tmp46_;
								gint _tmp47_;
								gint _m_index = 0;
								_tmp44_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) cl);
								_m_list = _tmp44_;
								_tmp45_ = _m_list;
								_tmp46_ = vala_collection_get_size ((ValaCollection*) _tmp45_);
								_tmp47_ = _tmp46_;
								_m_size = _tmp47_;
								_m_index = -1;
								while (TRUE) {
									gint _tmp48_;
									gint _tmp49_;
									ValaMethod* m = NULL;
									ValaList* _tmp50_;
									gpointer _tmp51_;
									gboolean _tmp52_ = FALSE;
									ValaMethod* _tmp53_;
									ValaDataType* _tmp54_;
									ValaDataType* _tmp55_;
									_m_index = _m_index + 1;
									_tmp48_ = _m_index;
									_tmp49_ = _m_size;
									if (!(_tmp48_ < _tmp49_)) {
										break;
									}
									_tmp50_ = _m_list;
									_tmp51_ = vala_list_get (_tmp50_, _m_index);
									m = (ValaMethod*) _tmp51_;
									_tmp53_ = m;
									_tmp54_ = vala_method_get_base_interface_type (_tmp53_);
									_tmp55_ = _tmp54_;
									if (_tmp55_ != NULL) {
										ValaMethod* _tmp56_;
										ValaMethod* _tmp57_;
										ValaMethod* _tmp58_;
										ValaMethod* _tmp59_;
										_tmp56_ = base_method;
										_tmp57_ = m;
										_tmp58_ = vala_method_get_base_interface_method (_tmp57_);
										_tmp59_ = _tmp58_;
										_tmp52_ = _tmp56_ == _tmp59_;
									} else {
										_tmp52_ = FALSE;
									}
									if (_tmp52_) {
										has_explicit_implementation = TRUE;
										_vala_code_node_unref0 (m);
										break;
									}
									_vala_code_node_unref0 (m);
								}
							}
							if (has_explicit_implementation) {
								_vala_code_node_unref0 (sym);
								_vala_code_node_unref0 (type);
								continue;
							}
						}
						invalid_match = NULL;
						_tmp60_ = base_method;
						_tmp62_ = vala_method_compatible (self, _tmp60_, &_tmp61_);
						_g_free0 (invalid_match);
						invalid_match = _tmp61_;
						if (!_tmp62_) {
							const gchar* _tmp63_;
							gchar* _tmp64_;
							ValaMethod* _tmp65_;
							ValaMethod* _tmp66_;
							_tmp63_ = invalid_match;
							_tmp64_ = g_strdup (_tmp63_);
							_g_free0 (invalid_error);
							invalid_error = _tmp64_;
							_tmp65_ = base_method;
							_tmp66_ = _vala_code_node_ref0 (_tmp65_);
							_vala_code_node_unref0 (invalid_base_match);
							invalid_base_match = _tmp66_;
						} else {
							ValaMethod* _tmp67_;
							ValaMethod* _tmp68_;
							_tmp67_ = base_method;
							_tmp68_ = _vala_code_node_ref0 (_tmp67_);
							_vala_code_node_unref0 (base_match);
							base_match = _tmp68_;
							_g_free0 (invalid_match);
							_vala_code_node_unref0 (sym);
							_vala_code_node_unref0 (type);
							break;
						}
						_g_free0 (invalid_match);
					}
				}
				_vala_code_node_unref0 (sym);
			}
			_vala_code_node_unref0 (type);
		}
	}
	_tmp69_ = base_match;
	if (_tmp69_ != NULL) {
		ValaMethod* _tmp70_;
		ValaMethod* _tmp71_;
		ValaMethod* _tmp72_;
		_tmp70_ = base_match;
		self->priv->_base_interface_method = _tmp70_;
		_tmp71_ = base_match;
		vala_code_node_copy_attribute_double ((ValaCodeNode*) self, (ValaCodeNode*) _tmp71_, "CCode", "instance_pos");
		_tmp72_ = base_match;
		vala_code_node_copy_attribute_bool ((ValaCodeNode*) self, (ValaCodeNode*) _tmp72_, "CCode", "returns_floating_reference");
		_vala_code_node_unref0 (invalid_base_match);
		_g_free0 (invalid_error);
		_vala_code_node_unref0 (base_match);
		return;
	} else {
		gboolean _tmp73_ = FALSE;
		gboolean _tmp74_;
		gboolean _tmp75_;
		_tmp74_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp75_ = _tmp74_;
		if (!_tmp75_) {
			ValaMethod* _tmp76_;
			_tmp76_ = invalid_base_match;
			_tmp73_ = _tmp76_ != NULL;
		} else {
			_tmp73_ = FALSE;
		}
		if (_tmp73_) {
			ValaMethodType* base_method_type = NULL;
			ValaMethod* _tmp77_;
			ValaMethodType* _tmp78_;
			ValaSourceReference* _tmp79_;
			ValaSourceReference* _tmp80_;
			gchar* _tmp81_;
			gchar* _tmp82_;
			ValaMethodType* _tmp83_;
			gchar* _tmp84_;
			gchar* _tmp85_;
			const gchar* _tmp86_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp77_ = invalid_base_match;
			_tmp78_ = vala_method_type_new (_tmp77_, NULL);
			base_method_type = _tmp78_;
			_tmp79_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp80_ = _tmp79_;
			_tmp81_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp82_ = _tmp81_;
			_tmp83_ = base_method_type;
			_tmp84_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp83_, NULL);
			_tmp85_ = _tmp84_;
			_tmp86_ = invalid_error;
			vala_report_error (_tmp80_, "overriding method `%s' is incompatible with base method `%s': %s.", _tmp82_, _tmp85_, _tmp86_);
			_g_free0 (_tmp85_);
			_g_free0 (_tmp82_);
			_vala_code_node_unref0 (base_method_type);
			_vala_code_node_unref0 (invalid_base_match);
			_g_free0 (invalid_error);
			_vala_code_node_unref0 (base_match);
			return;
		}
	}
	_tmp87_ = vala_method_get_base_interface_type (self);
	_tmp88_ = _tmp87_;
	if (_tmp88_ != NULL) {
		ValaSourceReference* _tmp89_;
		ValaSourceReference* _tmp90_;
		gchar* _tmp91_;
		gchar* _tmp92_;
		_tmp89_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp92_ = _tmp91_;
		vala_report_error (_tmp90_, "`%s': no suitable interface method found to implement", _tmp92_);
		_g_free0 (_tmp92_);
	}
	_vala_code_node_unref0 (invalid_base_match);
	_g_free0 (invalid_error);
	_vala_code_node_unref0 (base_match);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		ValaMethod* self;
		self = _data2_->self;
		_vala_iterable_unref0 (_data2_->referenced_generics);
		_vala_code_node_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static ValaTraverseStatus
___lambda5_ (ValaMethod* self,
             ValaCodeNode* node)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	ValaTraverseStatus result;
	g_return_val_if_fail (node != NULL, 0);
	if (VALA_IS_STATEMENT (node)) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = VALA_IS_EXPRESSION (node);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = VALA_IS_VARIABLE (node);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_CATCH_CLAUSE (node);
	}
	if (!_tmp0_) {
		result = VALA_TRAVERSE_STATUS_STOP;
		return result;
	}
	if (VALA_IS_YIELD_STATEMENT (node)) {
		_tmp4_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		if (VALA_IS_METHOD_CALL (node)) {
			gboolean _tmp6_;
			gboolean _tmp7_;
			_tmp6_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) G_TYPE_CHECK_INSTANCE_CAST (node, VALA_TYPE_METHOD_CALL, ValaMethodCall));
			_tmp7_ = _tmp6_;
			_tmp5_ = _tmp7_;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp4_ = _tmp5_;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp8_ = FALSE;
		if (VALA_IS_OBJECT_CREATION_EXPRESSION (node)) {
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp9_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) G_TYPE_CHECK_INSTANCE_CAST (node, VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpression));
			_tmp10_ = _tmp9_;
			_tmp8_ = _tmp10_;
		} else {
			_tmp8_ = FALSE;
		}
		_tmp3_ = _tmp8_;
	}
	if (_tmp3_) {
		vala_method_set_coroutine (self, TRUE);
		result = VALA_TRAVERSE_STATUS_STOP;
		return result;
	}
	result = VALA_TRAVERSE_STATUS_CONTINUE;
	return result;
}

static ValaTraverseStatus
____lambda5__vala_traverse_func (ValaCodeNode* node,
                                 gpointer self)
{
	ValaTraverseStatus result;
	result = ___lambda5_ ((ValaMethod*) self, node);
	return result;
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static ValaTraverseStatus
__lambda6_ (Block2Data* _data2_,
            ValaCodeNode* node)
{
	ValaMethod* self;
	ValaTraverseStatus result;
	self = _data2_->self;
	g_return_val_if_fail (node != NULL, 0);
	if (VALA_IS_GENERIC_TYPE (node)) {
		ValaList* _tmp0_;
		_tmp0_ = _data2_->referenced_generics;
		vala_collection_add ((ValaCollection*) _tmp0_, G_TYPE_CHECK_INSTANCE_CAST (node, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
		result = VALA_TRAVERSE_STATUS_STOP;
		return result;
	}
	result = VALA_TRAVERSE_STATUS_CONTINUE;
	return result;
}

static ValaTraverseStatus
___lambda6__vala_traverse_func (ValaCodeNode* node,
                                gpointer self)
{
	ValaTraverseStatus result;
	result = __lambda6_ (self, node);
	return result;
}

static gboolean
vala_method_real_check (ValaCodeNode* base,
                        ValaCodeContext* context)
{
	ValaMethod * self;
	Block2Data* _data2_;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaParameter* _tmp4_;
	ValaAttribute* _tmp6_;
	ValaAttribute* _tmp10_;
	gboolean _tmp11_ = FALSE;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	gboolean _tmp33_ = FALSE;
	gboolean _tmp39_ = FALSE;
	ValaAttribute* _tmp40_;
	gboolean _tmp46_;
	gboolean _tmp82_ = FALSE;
	gboolean _tmp83_;
	gboolean _tmp115_ = FALSE;
	gboolean _tmp116_;
	gboolean _tmp123_ = FALSE;
	gboolean _tmp124_ = FALSE;
	gboolean _tmp125_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp130_;
	ValaSemanticAnalyzer* _tmp131_;
	ValaSourceFile* _tmp132_;
	ValaSourceFile* _tmp133_;
	ValaSourceFile* _tmp134_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp135_;
	ValaSemanticAnalyzer* _tmp136_;
	ValaSymbol* _tmp137_;
	ValaSymbol* _tmp138_;
	ValaSymbol* _tmp139_;
	ValaSourceReference* _tmp140_;
	ValaSourceReference* _tmp141_;
	ValaSemanticAnalyzer* _tmp148_;
	ValaSemanticAnalyzer* _tmp149_;
	ValaDataType* _tmp150_;
	ValaDataType* _tmp151_;
	gboolean _tmp152_;
	gboolean _tmp153_;
	ValaDataType* _tmp154_;
	ValaDataType* _tmp155_;
	gboolean _tmp156_;
	gboolean _tmp157_;
	ValaDataType* _tmp162_;
	ValaDataType* _tmp163_;
	ValaTypeSymbol* _tmp164_;
	ValaTypeSymbol* _tmp165_;
	ValaSemanticAnalyzer* _tmp166_;
	ValaSemanticAnalyzer* _tmp167_;
	ValaDataType* _tmp168_;
	ValaTypeSymbol* _tmp169_;
	ValaTypeSymbol* _tmp170_;
	ValaAttribute* init_attr = NULL;
	ValaAttribute* _tmp179_;
	ValaAttribute* _tmp180_;
	ValaAttribute* _tmp181_;
	gboolean _tmp188_ = FALSE;
	gboolean _tmp189_ = FALSE;
	gboolean _tmp190_ = FALSE;
	ValaList* _tmp191_;
	gint _tmp192_;
	gint _tmp193_;
	gboolean _tmp207_ = FALSE;
	ValaAttribute* _tmp208_;
	GEqualFunc _tmp227_;
	ValaArrayList* _tmp228_;
	ValaTraverseVisitor* traverse = NULL;
	ValaTraverseVisitor* _tmp229_;
	ValaDataType* _tmp230_;
	ValaDataType* _tmp231_;
	ValaTraverseVisitor* _tmp232_;
	gboolean optional_param = FALSE;
	gboolean params_array_param = FALSE;
	gboolean ellipsis_param = FALSE;
	gboolean _tmp366_ = FALSE;
	gboolean _tmp367_ = FALSE;
	ValaMemberBinding _tmp368_;
	gboolean _tmp413_;
	ValaList* _tmp427_;
	ValaLocalVariable* _tmp452_;
	ValaLocalVariable* _tmp453_;
	ValaList* _tmp456_;
	ValaList* _tmp466_;
	ValaBlock* _tmp476_;
	ValaBlock* _tmp477_;
	gboolean _tmp480_ = FALSE;
	gboolean _tmp481_ = FALSE;
	gboolean _tmp482_ = FALSE;
	gboolean _tmp483_;
	gboolean _tmp520_ = FALSE;
	gboolean _tmp521_ = FALSE;
	ValaDataType* _tmp522_;
	ValaDataType* _tmp523_;
	ValaSemanticAnalyzer* _tmp564_;
	ValaSemanticAnalyzer* _tmp565_;
	ValaSourceFile* _tmp566_;
	ValaSemanticAnalyzer* _tmp567_;
	ValaSemanticAnalyzer* _tmp568_;
	ValaSymbol* _tmp569_;
	gboolean _tmp570_ = FALSE;
	gboolean _tmp571_ = FALSE;
	gboolean _tmp572_ = FALSE;
	gboolean _tmp573_;
	gboolean _tmp574_;
	ValaDataType* _tmp588_;
	ValaDataType* _tmp589_;
	gboolean _tmp638_ = FALSE;
	ValaBlock* _tmp639_;
	ValaBlock* _tmp640_;
	gboolean _tmp681_ = FALSE;
	gboolean _tmp682_ = FALSE;
	gboolean _tmp683_ = FALSE;
	gboolean _tmp684_ = FALSE;
	gboolean _tmp685_ = FALSE;
	ValaAttribute* _tmp739_;
	gboolean _tmp740_;
	gboolean _tmp741_;
	gboolean result;
	self = (ValaMethod*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = vala_code_node_ref (self);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = self->priv->_this_parameter;
	if (_tmp4_ != NULL) {
		ValaParameter* _tmp5_;
		_tmp5_ = self->priv->_this_parameter;
		vala_code_node_check ((ValaCodeNode*) _tmp5_, context);
	}
	_tmp6_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "DestroysInstance");
	if (_tmp6_ != NULL) {
		ValaParameter* _tmp7_;
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp7_ = self->priv->_this_parameter;
		_tmp8_ = vala_variable_get_variable_type ((ValaVariable*) _tmp7_);
		_tmp9_ = _tmp8_;
		vala_data_type_set_value_owned (_tmp9_, TRUE);
	}
	_tmp10_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "NoThrow");
	if (_tmp10_ != NULL) {
		_vala_iterable_unref0 (self->error_types);
		self->error_types = NULL;
	}
	_tmp12_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp13_ = _tmp12_;
	if (VALA_IS_CLASS (_tmp13_)) {
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_;
		_tmp15_ = self->priv->_is_abstract;
		if (_tmp15_) {
			_tmp14_ = TRUE;
		} else {
			gboolean _tmp16_;
			_tmp16_ = self->priv->_is_virtual;
			_tmp14_ = _tmp16_;
		}
		_tmp11_ = _tmp14_;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		gboolean _tmp19_ = FALSE;
		ValaClass* _tmp20_;
		gboolean _tmp21_;
		gboolean _tmp22_;
		ValaClass* _tmp28_;
		gboolean _tmp29_;
		gboolean _tmp30_;
		_tmp17_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp18_ = _tmp17_;
		cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_CLASS, ValaClass);
		_tmp20_ = cl;
		_tmp21_ = vala_class_get_is_compact (_tmp20_);
		_tmp22_ = _tmp21_;
		if (_tmp22_) {
			ValaClass* _tmp23_;
			ValaClass* _tmp24_;
			ValaClass* _tmp25_;
			_tmp23_ = cl;
			_tmp24_ = vala_class_get_base_class (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp19_ = _tmp25_ != NULL;
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			ValaSourceReference* _tmp26_;
			ValaSourceReference* _tmp27_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp27_ = _tmp26_;
			vala_report_error (_tmp27_, "Abstract and virtual methods may not be declared in derived compact cl" \
"asses");
			result = FALSE;
			block2_data_unref (_data2_);
			_data2_ = NULL;
			return result;
		}
		_tmp28_ = cl;
		_tmp29_ = vala_class_get_is_opaque (_tmp28_);
		_tmp30_ = _tmp29_;
		if (_tmp30_) {
			ValaSourceReference* _tmp31_;
			ValaSourceReference* _tmp32_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp32_ = _tmp31_;
			vala_report_error (_tmp32_, "Abstract and virtual methods may not be declared in opaque compact cla" \
"sses");
			result = FALSE;
			block2_data_unref (_data2_);
			_data2_ = NULL;
			return result;
		}
	}
	if (vala_method_is_variadic (self)) {
		gboolean _tmp34_ = FALSE;
		gboolean _tmp35_;
		_tmp35_ = self->priv->_is_abstract;
		if (_tmp35_) {
			_tmp34_ = TRUE;
		} else {
			gboolean _tmp36_;
			_tmp36_ = self->priv->_is_virtual;
			_tmp34_ = _tmp36_;
		}
		_tmp33_ = _tmp34_;
	} else {
		_tmp33_ = FALSE;
	}
	if (_tmp33_) {
		ValaSourceReference* _tmp37_;
		ValaSourceReference* _tmp38_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp37_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp38_ = _tmp37_;
		vala_report_error (_tmp38_, "Abstract and virtual methods may not be variadic. Use a `va_list' para" \
"meter instead of `...' or params-array.");
		result = FALSE;
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return result;
	}
	_tmp40_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "NoWrapper");
	if (_tmp40_ != NULL) {
		gboolean _tmp41_ = FALSE;
		gboolean _tmp42_;
		_tmp42_ = self->priv->_is_abstract;
		if (_tmp42_) {
			_tmp41_ = TRUE;
		} else {
			gboolean _tmp43_;
			_tmp43_ = self->priv->_is_virtual;
			_tmp41_ = _tmp43_;
		}
		_tmp39_ = !_tmp41_;
	} else {
		_tmp39_ = FALSE;
	}
	if (_tmp39_) {
		ValaSourceReference* _tmp44_;
		ValaSourceReference* _tmp45_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp44_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp45_ = _tmp44_;
		vala_report_error (_tmp45_, "[NoWrapper] methods must be declared abstract or virtual");
		result = FALSE;
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return result;
	}
	_tmp46_ = self->priv->_is_abstract;
	if (_tmp46_) {
		ValaSymbol* _tmp47_;
		ValaSymbol* _tmp48_;
		_tmp47_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp48_ = _tmp47_;
		if (VALA_IS_CLASS (_tmp48_)) {
			ValaClass* cl = NULL;
			ValaSymbol* _tmp49_;
			ValaSymbol* _tmp50_;
			ValaClass* _tmp51_;
			gboolean _tmp52_;
			gboolean _tmp53_;
			_tmp49_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp50_ = _tmp49_;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, VALA_TYPE_CLASS, ValaClass);
			_tmp51_ = cl;
			_tmp52_ = vala_class_get_is_abstract (_tmp51_);
			_tmp53_ = _tmp52_;
			if (!_tmp53_) {
				ValaSourceReference* _tmp54_;
				ValaSourceReference* _tmp55_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp54_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp55_ = _tmp54_;
				vala_report_error (_tmp55_, "Abstract methods may not be declared in non-abstract classes");
				result = FALSE;
				block2_data_unref (_data2_);
				_data2_ = NULL;
				return result;
			}
		} else {
			ValaSymbol* _tmp56_;
			ValaSymbol* _tmp57_;
			_tmp56_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp57_ = _tmp56_;
			if (!VALA_IS_INTERFACE (_tmp57_)) {
				ValaSourceReference* _tmp58_;
				ValaSourceReference* _tmp59_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp58_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp59_ = _tmp58_;
				vala_report_error (_tmp59_, "Abstract methods may not be declared outside of classes and interfaces");
				result = FALSE;
				block2_data_unref (_data2_);
				_data2_ = NULL;
				return result;
			}
		}
	} else {
		gboolean _tmp60_;
		_tmp60_ = self->priv->_is_virtual;
		if (_tmp60_) {
			gboolean _tmp61_ = FALSE;
			ValaSymbol* _tmp62_;
			ValaSymbol* _tmp63_;
			_tmp62_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp63_ = _tmp62_;
			if (!VALA_IS_CLASS (_tmp63_)) {
				ValaSymbol* _tmp64_;
				ValaSymbol* _tmp65_;
				_tmp64_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp65_ = _tmp64_;
				_tmp61_ = !VALA_IS_INTERFACE (_tmp65_);
			} else {
				_tmp61_ = FALSE;
			}
			if (_tmp61_) {
				ValaSourceReference* _tmp66_;
				ValaSourceReference* _tmp67_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp66_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp67_ = _tmp66_;
				vala_report_error (_tmp67_, "Virtual methods may not be declared outside of classes and interfaces");
				result = FALSE;
				block2_data_unref (_data2_);
				_data2_ = NULL;
				return result;
			}
		} else {
			gboolean _tmp68_;
			_tmp68_ = self->priv->_overrides;
			if (_tmp68_) {
				ValaSymbol* _tmp69_;
				ValaSymbol* _tmp70_;
				_tmp69_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp70_ = _tmp69_;
				if (!VALA_IS_CLASS (_tmp70_)) {
					ValaSourceReference* _tmp71_;
					ValaSourceReference* _tmp72_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp71_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp72_ = _tmp71_;
					vala_report_error (_tmp72_, "Methods may not be overridden outside of classes");
					result = FALSE;
					block2_data_unref (_data2_);
					_data2_ = NULL;
					return result;
				}
			} else {
				ValaSymbolAccessibility _tmp73_;
				ValaSymbolAccessibility _tmp74_;
				_tmp73_ = vala_symbol_get_access ((ValaSymbol*) self);
				_tmp74_ = _tmp73_;
				if (_tmp74_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
					gboolean _tmp75_ = FALSE;
					ValaSymbol* _tmp76_;
					ValaSymbol* _tmp77_;
					_tmp76_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
					_tmp77_ = _tmp76_;
					if (!VALA_IS_CLASS (_tmp77_)) {
						ValaSymbol* _tmp78_;
						ValaSymbol* _tmp79_;
						_tmp78_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
						_tmp79_ = _tmp78_;
						_tmp75_ = !VALA_IS_INTERFACE (_tmp79_);
					} else {
						_tmp75_ = FALSE;
					}
					if (_tmp75_) {
						ValaSourceReference* _tmp80_;
						ValaSourceReference* _tmp81_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp80_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp81_ = _tmp80_;
						vala_report_error (_tmp81_, "Protected methods may not be declared outside of classes and interface" \
"s");
						result = FALSE;
						block2_data_unref (_data2_);
						_data2_ = NULL;
						return result;
					}
				}
			}
		}
	}
	_tmp83_ = self->priv->_is_abstract;
	if (_tmp83_) {
		ValaBlock* _tmp84_;
		ValaBlock* _tmp85_;
		_tmp84_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp85_ = _tmp84_;
		_tmp82_ = _tmp85_ != NULL;
	} else {
		_tmp82_ = FALSE;
	}
	if (_tmp82_) {
		ValaSourceReference* _tmp86_;
		ValaSourceReference* _tmp87_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp86_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp87_ = _tmp86_;
		vala_report_error (_tmp87_, "Abstract methods cannot have bodies");
	} else {
		gboolean _tmp88_ = FALSE;
		gboolean _tmp89_ = FALSE;
		gboolean _tmp90_;
		_tmp90_ = self->priv->_is_abstract;
		if (_tmp90_) {
			_tmp89_ = TRUE;
		} else {
			gboolean _tmp91_;
			_tmp91_ = self->priv->_is_virtual;
			_tmp89_ = _tmp91_;
		}
		if (_tmp89_) {
			gboolean _tmp92_;
			gboolean _tmp93_;
			_tmp92_ = vala_symbol_get_is_extern ((ValaSymbol*) self);
			_tmp93_ = _tmp92_;
			_tmp88_ = _tmp93_;
		} else {
			_tmp88_ = FALSE;
		}
		if (_tmp88_) {
			ValaSourceReference* _tmp94_;
			ValaSourceReference* _tmp95_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp94_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp95_ = _tmp94_;
			vala_report_error (_tmp95_, "Extern methods cannot be abstract or virtual");
		} else {
			gboolean _tmp96_ = FALSE;
			gboolean _tmp97_;
			gboolean _tmp98_;
			_tmp97_ = vala_symbol_get_is_extern ((ValaSymbol*) self);
			_tmp98_ = _tmp97_;
			if (_tmp98_) {
				ValaBlock* _tmp99_;
				ValaBlock* _tmp100_;
				_tmp99_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp100_ = _tmp99_;
				_tmp96_ = _tmp100_ != NULL;
			} else {
				_tmp96_ = FALSE;
			}
			if (_tmp96_) {
				ValaSourceReference* _tmp101_;
				ValaSourceReference* _tmp102_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp101_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp102_ = _tmp101_;
				vala_report_error (_tmp102_, "Extern methods cannot have bodies");
			} else {
				gboolean _tmp103_ = FALSE;
				gboolean _tmp104_ = FALSE;
				gboolean _tmp105_ = FALSE;
				gboolean _tmp106_;
				_tmp106_ = self->priv->_is_abstract;
				if (!_tmp106_) {
					gboolean _tmp107_;
					gboolean _tmp108_;
					_tmp107_ = vala_symbol_get_external ((ValaSymbol*) self);
					_tmp108_ = _tmp107_;
					_tmp105_ = !_tmp108_;
				} else {
					_tmp105_ = FALSE;
				}
				if (_tmp105_) {
					ValaSourceFileType _tmp109_;
					ValaSourceFileType _tmp110_;
					_tmp109_ = vala_symbol_get_source_type ((ValaSymbol*) self);
					_tmp110_ = _tmp109_;
					_tmp104_ = _tmp110_ == VALA_SOURCE_FILE_TYPE_SOURCE;
				} else {
					_tmp104_ = FALSE;
				}
				if (_tmp104_) {
					ValaBlock* _tmp111_;
					ValaBlock* _tmp112_;
					_tmp111_ = vala_subroutine_get_body ((ValaSubroutine*) self);
					_tmp112_ = _tmp111_;
					_tmp103_ = _tmp112_ == NULL;
				} else {
					_tmp103_ = FALSE;
				}
				if (_tmp103_) {
					ValaSourceReference* _tmp113_;
					ValaSourceReference* _tmp114_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp113_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp114_ = _tmp113_;
					vala_report_error (_tmp114_, "Non-abstract, non-extern methods must have bodies");
				}
			}
		}
	}
	_tmp116_ = self->priv->_is_main_block;
	if (_tmp116_) {
		ValaBlock* _tmp117_;
		ValaBlock* _tmp118_;
		_tmp117_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp118_ = _tmp117_;
		_tmp115_ = _tmp118_ != NULL;
	} else {
		_tmp115_ = FALSE;
	}
	if (_tmp115_) {
		ValaBlock* _tmp119_;
		ValaBlock* _tmp120_;
		ValaTraverseVisitor* _tmp121_;
		ValaTraverseVisitor* _tmp122_;
		_tmp119_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp120_ = _tmp119_;
		_tmp121_ = vala_traverse_visitor_new (____lambda5__vala_traverse_func, vala_code_node_ref (self), vala_code_node_unref);
		_tmp122_ = _tmp121_;
		vala_code_node_accept ((ValaCodeNode*) _tmp120_, (ValaCodeVisitor*) _tmp122_);
		_vala_code_visitor_unref0 (_tmp122_);
	}
	_tmp125_ = self->priv->_coroutine;
	if (_tmp125_) {
		gboolean _tmp126_;
		gboolean _tmp127_;
		_tmp126_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp127_ = _tmp126_;
		_tmp124_ = !_tmp127_;
	} else {
		_tmp124_ = FALSE;
	}
	if (_tmp124_) {
		_tmp123_ = !vala_code_context_has_package (context, "gio-2.0");
	} else {
		_tmp123_ = FALSE;
	}
	if (_tmp123_) {
		ValaSourceReference* _tmp128_;
		ValaSourceReference* _tmp129_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp128_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp129_ = _tmp128_;
		vala_report_error (_tmp129_, "gio-2.0 package required for async methods");
		result = FALSE;
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return result;
	}
	_tmp130_ = vala_code_context_get_analyzer (context);
	_tmp131_ = _tmp130_;
	_tmp132_ = vala_semantic_analyzer_get_current_source_file (_tmp131_);
	_tmp133_ = _tmp132_;
	_tmp134_ = _vala_source_file_ref0 (_tmp133_);
	old_source_file = _tmp134_;
	_tmp135_ = vala_code_context_get_analyzer (context);
	_tmp136_ = _tmp135_;
	_tmp137_ = vala_semantic_analyzer_get_current_symbol (_tmp136_);
	_tmp138_ = _tmp137_;
	_tmp139_ = _vala_code_node_ref0 (_tmp138_);
	old_symbol = _tmp139_;
	_tmp140_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp141_ = _tmp140_;
	if (_tmp141_ != NULL) {
		ValaSemanticAnalyzer* _tmp142_;
		ValaSemanticAnalyzer* _tmp143_;
		ValaSourceReference* _tmp144_;
		ValaSourceReference* _tmp145_;
		ValaSourceFile* _tmp146_;
		ValaSourceFile* _tmp147_;
		_tmp142_ = vala_code_context_get_analyzer (context);
		_tmp143_ = _tmp142_;
		_tmp144_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp145_ = _tmp144_;
		_tmp146_ = vala_source_reference_get_file (_tmp145_);
		_tmp147_ = _tmp146_;
		vala_semantic_analyzer_set_current_source_file (_tmp143_, _tmp147_);
	}
	_tmp148_ = vala_code_context_get_analyzer (context);
	_tmp149_ = _tmp148_;
	vala_semantic_analyzer_set_current_symbol (_tmp149_, (ValaSymbol*) self);
	_tmp150_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp151_ = _tmp150_;
	_tmp152_ = vala_method_get_returns_floating_reference (self);
	_tmp153_ = _tmp152_;
	vala_data_type_set_floating_reference (_tmp151_, _tmp153_);
	_tmp154_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp155_ = _tmp154_;
	vala_code_node_check ((ValaCodeNode*) _tmp155_, context);
	_tmp156_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp157_ = _tmp156_;
	if (!_tmp157_) {
		ValaSemanticAnalyzer* _tmp158_;
		ValaSemanticAnalyzer* _tmp159_;
		ValaDataType* _tmp160_;
		ValaDataType* _tmp161_;
		_tmp158_ = vala_code_context_get_analyzer (context);
		_tmp159_ = _tmp158_;
		_tmp160_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp161_ = _tmp160_;
		vala_semantic_analyzer_check_type (_tmp159_, _tmp161_);
	}
	_tmp162_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp163_ = _tmp162_;
	_tmp164_ = vala_data_type_get_type_symbol (_tmp163_);
	_tmp165_ = _tmp164_;
	_tmp166_ = vala_code_context_get_analyzer (context);
	_tmp167_ = _tmp166_;
	_tmp168_ = _tmp167_->va_list_type;
	_tmp169_ = vala_data_type_get_type_symbol (_tmp168_);
	_tmp170_ = _tmp169_;
	if (_tmp165_ == _tmp170_) {
		ValaSourceReference* _tmp171_;
		ValaSourceReference* _tmp172_;
		ValaDataType* _tmp173_;
		ValaDataType* _tmp174_;
		ValaTypeSymbol* _tmp175_;
		ValaTypeSymbol* _tmp176_;
		gchar* _tmp177_;
		gchar* _tmp178_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp171_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp172_ = _tmp171_;
		_tmp173_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp174_ = _tmp173_;
		_tmp175_ = vala_data_type_get_type_symbol (_tmp174_);
		_tmp176_ = _tmp175_;
		_tmp177_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp176_);
		_tmp178_ = _tmp177_;
		vala_report_error (_tmp172_, "`%s' not supported as return type", _tmp178_);
		_g_free0 (_tmp178_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return result;
	}
	_tmp179_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ModuleInit");
	_tmp180_ = _vala_code_node_ref0 (_tmp179_);
	init_attr = _tmp180_;
	_tmp181_ = init_attr;
	if (_tmp181_ != NULL) {
		ValaSourceReference* _tmp182_;
		ValaSourceReference* _tmp183_;
		ValaSourceFile* _tmp184_;
		ValaSourceFile* _tmp185_;
		ValaCodeContext* _tmp186_;
		ValaCodeContext* _tmp187_;
		_tmp182_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp183_ = _tmp182_;
		_tmp184_ = vala_source_reference_get_file (_tmp183_);
		_tmp185_ = _tmp184_;
		_tmp186_ = vala_source_file_get_context (_tmp185_);
		_tmp187_ = _tmp186_;
		vala_code_context_set_module_init_method (_tmp187_, self);
	}
	_tmp191_ = self->priv->parameters;
	_tmp192_ = vala_collection_get_size ((ValaCollection*) _tmp191_);
	_tmp193_ = _tmp192_;
	if (_tmp193_ == 1) {
		ValaList* _tmp194_;
		gpointer _tmp195_;
		ValaParameter* _tmp196_;
		gboolean _tmp197_;
		gboolean _tmp198_;
		_tmp194_ = self->priv->parameters;
		_tmp195_ = vala_list_get (_tmp194_, 0);
		_tmp196_ = (ValaParameter*) _tmp195_;
		_tmp197_ = vala_parameter_get_ellipsis (_tmp196_);
		_tmp198_ = _tmp197_;
		_tmp190_ = _tmp198_;
		_vala_code_node_unref0 (_tmp196_);
	} else {
		_tmp190_ = FALSE;
	}
	if (_tmp190_) {
		ValaBlock* _tmp199_;
		ValaBlock* _tmp200_;
		_tmp199_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp200_ = _tmp199_;
		_tmp189_ = _tmp200_ != NULL;
	} else {
		_tmp189_ = FALSE;
	}
	if (_tmp189_) {
		ValaMemberBinding _tmp201_;
		_tmp201_ = self->priv->_binding;
		_tmp188_ = _tmp201_ != VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp188_ = FALSE;
	}
	if (_tmp188_) {
		ValaList* _tmp202_;
		gpointer _tmp203_;
		ValaParameter* _tmp204_;
		ValaSourceReference* _tmp205_;
		ValaSourceReference* _tmp206_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp202_ = self->priv->parameters;
		_tmp203_ = vala_list_get (_tmp202_, 0);
		_tmp204_ = (ValaParameter*) _tmp203_;
		_tmp205_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp204_);
		_tmp206_ = _tmp205_;
		vala_report_error (_tmp206_, "Named parameter required before `...'");
		_vala_code_node_unref0 (_tmp204_);
	}
	_tmp208_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Print");
	if (_tmp208_ != NULL) {
		gboolean _tmp209_ = FALSE;
		ValaList* _tmp210_;
		gint _tmp211_;
		gint _tmp212_;
		_tmp210_ = self->priv->parameters;
		_tmp211_ = vala_collection_get_size ((ValaCollection*) _tmp210_);
		_tmp212_ = _tmp211_;
		if (_tmp212_ != 1) {
			_tmp209_ = TRUE;
		} else {
			ValaList* _tmp213_;
			gpointer _tmp214_;
			ValaParameter* _tmp215_;
			ValaDataType* _tmp216_;
			ValaDataType* _tmp217_;
			ValaTypeSymbol* _tmp218_;
			ValaTypeSymbol* _tmp219_;
			ValaSemanticAnalyzer* _tmp220_;
			ValaSemanticAnalyzer* _tmp221_;
			ValaDataType* _tmp222_;
			ValaTypeSymbol* _tmp223_;
			ValaTypeSymbol* _tmp224_;
			_tmp213_ = self->priv->parameters;
			_tmp214_ = vala_list_get (_tmp213_, 0);
			_tmp215_ = (ValaParameter*) _tmp214_;
			_tmp216_ = vala_variable_get_variable_type ((ValaVariable*) _tmp215_);
			_tmp217_ = _tmp216_;
			_tmp218_ = vala_data_type_get_type_symbol (_tmp217_);
			_tmp219_ = _tmp218_;
			_tmp220_ = vala_code_context_get_analyzer (context);
			_tmp221_ = _tmp220_;
			_tmp222_ = _tmp221_->string_type;
			_tmp223_ = vala_data_type_get_type_symbol (_tmp222_);
			_tmp224_ = _tmp223_;
			_tmp209_ = _tmp219_ != _tmp224_;
			_vala_code_node_unref0 (_tmp215_);
		}
		_tmp207_ = _tmp209_;
	} else {
		_tmp207_ = FALSE;
	}
	if (_tmp207_) {
		ValaSourceReference* _tmp225_;
		ValaSourceReference* _tmp226_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp225_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp226_ = _tmp225_;
		vala_report_error (_tmp226_, "[Print] methods must have exactly one parameter of type `string'");
	}
	_tmp227_ = g_direct_equal;
	_tmp228_ = vala_array_list_new (VALA_TYPE_GENERIC_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp227_);
	_data2_->referenced_generics = (ValaList*) _tmp228_;
	_tmp229_ = vala_traverse_visitor_new (___lambda6__vala_traverse_func, block2_data_ref (_data2_), block2_data_unref);
	traverse = _tmp229_;
	_tmp230_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp231_ = _tmp230_;
	_tmp232_ = traverse;
	vala_code_node_accept ((ValaCodeNode*) _tmp231_, (ValaCodeVisitor*) _tmp232_);
	optional_param = FALSE;
	params_array_param = FALSE;
	ellipsis_param = FALSE;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp233_;
		gint _param_size = 0;
		ValaList* _tmp234_;
		gint _tmp235_;
		gint _tmp236_;
		gint _param_index = 0;
		_tmp233_ = self->priv->parameters;
		_param_list = _tmp233_;
		_tmp234_ = _param_list;
		_tmp235_ = vala_collection_get_size ((ValaCollection*) _tmp234_);
		_tmp236_ = _tmp235_;
		_param_size = _tmp236_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp237_;
			gint _tmp238_;
			ValaParameter* param = NULL;
			ValaList* _tmp239_;
			gpointer _tmp240_;
			ValaParameter* _tmp241_;
			gboolean _tmp242_ = FALSE;
			gboolean _tmp243_;
			gboolean _tmp250_ = FALSE;
			gboolean _tmp251_ = FALSE;
			gboolean _tmp252_;
			gboolean _tmp253_;
			ValaParameter* _tmp276_;
			ValaTraverseVisitor* _tmp277_;
			gboolean _tmp278_;
			gboolean _tmp279_ = FALSE;
			gboolean _tmp280_ = FALSE;
			gboolean _tmp305_ = FALSE;
			ValaParameter* _tmp306_;
			gboolean _tmp307_;
			gboolean _tmp308_;
			_param_index = _param_index + 1;
			_tmp237_ = _param_index;
			_tmp238_ = _param_size;
			if (!(_tmp237_ < _tmp238_)) {
				break;
			}
			_tmp239_ = _param_list;
			_tmp240_ = vala_list_get (_tmp239_, _param_index);
			param = (ValaParameter*) _tmp240_;
			_tmp241_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp241_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_vala_code_node_unref0 (param);
				continue;
			}
			_tmp243_ = self->priv->_coroutine;
			if (_tmp243_) {
				ValaParameter* _tmp244_;
				ValaParameterDirection _tmp245_;
				ValaParameterDirection _tmp246_;
				_tmp244_ = param;
				_tmp245_ = vala_parameter_get_direction (_tmp244_);
				_tmp246_ = _tmp245_;
				_tmp242_ = _tmp246_ == VALA_PARAMETER_DIRECTION_REF;
			} else {
				_tmp242_ = FALSE;
			}
			if (_tmp242_) {
				ValaParameter* _tmp247_;
				ValaSourceReference* _tmp248_;
				ValaSourceReference* _tmp249_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp247_ = param;
				_tmp248_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp247_);
				_tmp249_ = _tmp248_;
				vala_report_error (_tmp249_, "Reference parameters are not supported for async methods");
			}
			_tmp252_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp253_ = _tmp252_;
			if (!_tmp253_) {
				gboolean _tmp254_;
				_tmp254_ = self->priv->_coroutine;
				_tmp251_ = _tmp254_;
			} else {
				_tmp251_ = FALSE;
			}
			if (_tmp251_) {
				gboolean _tmp255_ = FALSE;
				gboolean _tmp256_ = FALSE;
				ValaParameter* _tmp257_;
				gboolean _tmp258_;
				gboolean _tmp259_;
				_tmp257_ = param;
				_tmp258_ = vala_parameter_get_ellipsis (_tmp257_);
				_tmp259_ = _tmp258_;
				if (_tmp259_) {
					_tmp256_ = TRUE;
				} else {
					ValaParameter* _tmp260_;
					gboolean _tmp261_;
					gboolean _tmp262_;
					_tmp260_ = param;
					_tmp261_ = vala_parameter_get_params_array (_tmp260_);
					_tmp262_ = _tmp261_;
					_tmp256_ = _tmp262_;
				}
				if (_tmp256_) {
					_tmp255_ = TRUE;
				} else {
					ValaParameter* _tmp263_;
					ValaDataType* _tmp264_;
					ValaDataType* _tmp265_;
					ValaTypeSymbol* _tmp266_;
					ValaTypeSymbol* _tmp267_;
					ValaSemanticAnalyzer* _tmp268_;
					ValaSemanticAnalyzer* _tmp269_;
					ValaDataType* _tmp270_;
					ValaTypeSymbol* _tmp271_;
					ValaTypeSymbol* _tmp272_;
					_tmp263_ = param;
					_tmp264_ = vala_variable_get_variable_type ((ValaVariable*) _tmp263_);
					_tmp265_ = _tmp264_;
					_tmp266_ = vala_data_type_get_type_symbol (_tmp265_);
					_tmp267_ = _tmp266_;
					_tmp268_ = vala_code_context_get_analyzer (context);
					_tmp269_ = _tmp268_;
					_tmp270_ = _tmp269_->va_list_type;
					_tmp271_ = vala_data_type_get_type_symbol (_tmp270_);
					_tmp272_ = _tmp271_;
					_tmp255_ = _tmp267_ == _tmp272_;
				}
				_tmp250_ = _tmp255_;
			} else {
				_tmp250_ = FALSE;
			}
			if (_tmp250_) {
				ValaParameter* _tmp273_;
				ValaSourceReference* _tmp274_;
				ValaSourceReference* _tmp275_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp273_ = param;
				_tmp274_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp273_);
				_tmp275_ = _tmp274_;
				vala_report_error (_tmp275_, "Variadic parameters are not supported for async methods");
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_code_visitor_unref0 (traverse);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				block2_data_unref (_data2_);
				_data2_ = NULL;
				return result;
			}
			_tmp276_ = param;
			_tmp277_ = traverse;
			vala_code_node_accept_children ((ValaCodeNode*) _tmp276_, (ValaCodeVisitor*) _tmp277_);
			_tmp278_ = self->priv->_coroutine;
			if (_tmp278_) {
				_vala_code_node_unref0 (param);
				continue;
			}
			if (optional_param) {
				ValaParameter* _tmp281_;
				ValaExpression* _tmp282_;
				ValaExpression* _tmp283_;
				_tmp281_ = param;
				_tmp282_ = vala_variable_get_initializer ((ValaVariable*) _tmp281_);
				_tmp283_ = _tmp282_;
				_tmp280_ = _tmp283_ == NULL;
			} else {
				_tmp280_ = FALSE;
			}
			if (_tmp280_) {
				ValaParameter* _tmp284_;
				gboolean _tmp285_;
				gboolean _tmp286_;
				_tmp284_ = param;
				_tmp285_ = vala_parameter_get_ellipsis (_tmp284_);
				_tmp286_ = _tmp285_;
				_tmp279_ = !_tmp286_;
			} else {
				_tmp279_ = FALSE;
			}
			if (_tmp279_) {
				ValaParameter* _tmp287_;
				ValaSourceReference* _tmp288_;
				ValaSourceReference* _tmp289_;
				_tmp287_ = param;
				_tmp288_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp287_);
				_tmp289_ = _tmp288_;
				vala_report_warning (_tmp289_, "parameter without default follows parameter with default");
			} else {
				ValaParameter* _tmp290_;
				ValaExpression* _tmp291_;
				ValaExpression* _tmp292_;
				_tmp290_ = param;
				_tmp291_ = vala_variable_get_initializer ((ValaVariable*) _tmp290_);
				_tmp292_ = _tmp291_;
				if (_tmp292_ != NULL) {
					optional_param = TRUE;
				}
			}
			if (params_array_param) {
				ValaParameter* _tmp293_;
				ValaSourceReference* _tmp294_;
				ValaSourceReference* _tmp295_;
				_tmp293_ = param;
				_tmp294_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp293_);
				_tmp295_ = _tmp294_;
				vala_report_error (_tmp295_, "parameter follows params-array parameter");
			} else {
				ValaParameter* _tmp296_;
				gboolean _tmp297_;
				gboolean _tmp298_;
				_tmp296_ = param;
				_tmp297_ = vala_parameter_get_params_array (_tmp296_);
				_tmp298_ = _tmp297_;
				if (_tmp298_) {
					params_array_param = TRUE;
				}
			}
			if (ellipsis_param) {
				ValaParameter* _tmp299_;
				ValaSourceReference* _tmp300_;
				ValaSourceReference* _tmp301_;
				_tmp299_ = param;
				_tmp300_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp299_);
				_tmp301_ = _tmp300_;
				vala_report_error (_tmp301_, "parameter follows ellipsis parameter");
			} else {
				ValaParameter* _tmp302_;
				gboolean _tmp303_;
				gboolean _tmp304_;
				_tmp302_ = param;
				_tmp303_ = vala_parameter_get_ellipsis (_tmp302_);
				_tmp304_ = _tmp303_;
				if (_tmp304_) {
					ellipsis_param = TRUE;
				}
			}
			_tmp306_ = param;
			_tmp307_ = vala_parameter_get_params_array (_tmp306_);
			_tmp308_ = _tmp307_;
			if (_tmp308_) {
				ValaBlock* _tmp309_;
				ValaBlock* _tmp310_;
				_tmp309_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp310_ = _tmp309_;
				_tmp305_ = _tmp310_ != NULL;
			} else {
				_tmp305_ = FALSE;
			}
			if (_tmp305_) {
				ValaLocalVariable* _tmp311_;
				gboolean _tmp315_;
				gboolean _tmp316_;
				ValaArrayType* type = NULL;
				ValaParameter* _tmp320_;
				ValaDataType* _tmp321_;
				ValaDataType* _tmp322_;
				ValaDataType* _tmp323_;
				ValaArrayType* _tmp324_;
				ValaDataType* _tmp325_;
				ValaDataType* _tmp326_;
				ValaArrayType* _tmp327_;
				gboolean _tmp328_;
				gboolean _tmp329_;
				ValaArrayType* _tmp330_;
				gboolean _tmp331_ = FALSE;
				ValaArrayType* _tmp332_;
				ValaDataType* _tmp333_;
				ValaDataType* _tmp334_;
				ValaArrayType* _tmp343_;
				ValaExpression* _tmp344_;
				ValaExpression* _tmp345_;
				ValaArrayType* _tmp349_;
				ValaParameter* _tmp350_;
				const gchar* _tmp351_;
				const gchar* _tmp352_;
				ValaParameter* _tmp353_;
				ValaSourceReference* _tmp354_;
				ValaSourceReference* _tmp355_;
				ValaLocalVariable* _tmp356_;
				ValaLocalVariable* _tmp357_;
				ValaBlock* _tmp358_;
				ValaBlock* _tmp359_;
				ValaLocalVariable* _tmp360_;
				ValaParameter* _tmp361_;
				ValaSourceReference* _tmp362_;
				ValaSourceReference* _tmp363_;
				ValaDeclarationStatement* _tmp364_;
				ValaDeclarationStatement* _tmp365_;
				_tmp311_ = self->priv->_params_array_var;
				if (_tmp311_ != NULL) {
					ValaParameter* _tmp312_;
					ValaSourceReference* _tmp313_;
					ValaSourceReference* _tmp314_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp312_ = param;
					_tmp313_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp312_);
					_tmp314_ = _tmp313_;
					vala_report_error (_tmp314_, "Only one params-array parameter is allowed");
					_vala_code_node_unref0 (param);
					continue;
				}
				_tmp315_ = vala_code_context_get_experimental (context);
				_tmp316_ = _tmp315_;
				if (!_tmp316_) {
					ValaParameter* _tmp317_;
					ValaSourceReference* _tmp318_;
					ValaSourceReference* _tmp319_;
					_tmp317_ = param;
					_tmp318_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp317_);
					_tmp319_ = _tmp318_;
					vala_report_warning (_tmp319_, "Support of params-arrays is experimental");
				}
				_tmp320_ = param;
				_tmp321_ = vala_variable_get_variable_type ((ValaVariable*) _tmp320_);
				_tmp322_ = _tmp321_;
				_tmp323_ = vala_data_type_copy (_tmp322_);
				type = G_TYPE_CHECK_INSTANCE_CAST (_tmp323_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
				_tmp324_ = type;
				_tmp325_ = vala_array_type_get_element_type (_tmp324_);
				_tmp326_ = _tmp325_;
				_tmp327_ = type;
				_tmp328_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp327_);
				_tmp329_ = _tmp328_;
				vala_data_type_set_value_owned (_tmp326_, _tmp329_);
				_tmp330_ = type;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp330_, TRUE);
				_tmp332_ = type;
				_tmp333_ = vala_array_type_get_element_type (_tmp332_);
				_tmp334_ = _tmp333_;
				if (vala_data_type_is_real_struct_type (_tmp334_)) {
					ValaArrayType* _tmp335_;
					ValaDataType* _tmp336_;
					ValaDataType* _tmp337_;
					gboolean _tmp338_;
					gboolean _tmp339_;
					_tmp335_ = type;
					_tmp336_ = vala_array_type_get_element_type (_tmp335_);
					_tmp337_ = _tmp336_;
					_tmp338_ = vala_data_type_get_nullable (_tmp337_);
					_tmp339_ = _tmp338_;
					_tmp331_ = !_tmp339_;
				} else {
					_tmp331_ = FALSE;
				}
				if (_tmp331_) {
					ValaParameter* _tmp340_;
					ValaSourceReference* _tmp341_;
					ValaSourceReference* _tmp342_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp340_ = param;
					_tmp341_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp340_);
					_tmp342_ = _tmp341_;
					vala_report_error (_tmp342_, "Only nullable struct elements are supported in params-array");
				}
				_tmp343_ = type;
				_tmp344_ = vala_array_type_get_length (_tmp343_);
				_tmp345_ = _tmp344_;
				if (_tmp345_ != NULL) {
					ValaParameter* _tmp346_;
					ValaSourceReference* _tmp347_;
					ValaSourceReference* _tmp348_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp346_ = param;
					_tmp347_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp346_);
					_tmp348_ = _tmp347_;
					vala_report_error (_tmp348_, "Passing length to params-array is not supported yet");
				}
				_tmp349_ = type;
				_tmp350_ = param;
				_tmp351_ = vala_symbol_get_name ((ValaSymbol*) _tmp350_);
				_tmp352_ = _tmp351_;
				_tmp353_ = param;
				_tmp354_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp353_);
				_tmp355_ = _tmp354_;
				_tmp356_ = vala_local_variable_new ((ValaDataType*) _tmp349_, _tmp352_, NULL, _tmp355_);
				_tmp357_ = _tmp356_;
				vala_method_set_params_array_var (self, _tmp357_);
				_vala_code_node_unref0 (_tmp357_);
				_tmp358_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp359_ = _tmp358_;
				_tmp360_ = self->priv->_params_array_var;
				_tmp361_ = param;
				_tmp362_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp361_);
				_tmp363_ = _tmp362_;
				_tmp364_ = vala_declaration_statement_new ((ValaSymbol*) _tmp360_, _tmp363_);
				_tmp365_ = _tmp364_;
				vala_block_insert_statement (_tmp359_, 0, (ValaStatement*) _tmp365_);
				_vala_code_node_unref0 (_tmp365_);
				_vala_code_node_unref0 (type);
			}
			_vala_code_node_unref0 (param);
		}
	}
	_tmp368_ = self->priv->_binding;
	if (_tmp368_ == VALA_MEMBER_BINDING_STATIC) {
		ValaSymbol* _tmp369_;
		ValaSymbol* _tmp370_;
		_tmp369_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp370_ = _tmp369_;
		_tmp367_ = VALA_IS_CLASS (_tmp370_);
	} else {
		_tmp367_ = FALSE;
	}
	if (_tmp367_) {
		ValaSymbol* _tmp371_;
		ValaSymbol* _tmp372_;
		gboolean _tmp373_;
		gboolean _tmp374_;
		_tmp371_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp372_ = _tmp371_;
		_tmp373_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp372_, VALA_TYPE_CLASS, ValaClass));
		_tmp374_ = _tmp373_;
		_tmp366_ = !_tmp374_;
	} else {
		_tmp366_ = FALSE;
	}
	if (_tmp366_) {
		ValaIterator* ref_generics_it = NULL;
		ValaList* _tmp375_;
		ValaIterator* _tmp376_;
		_tmp375_ = _data2_->referenced_generics;
		_tmp376_ = vala_iterable_iterator ((ValaIterable*) _tmp375_);
		ref_generics_it = _tmp376_;
		while (TRUE) {
			ValaIterator* _tmp377_;
			ValaGenericType* ref_generics = NULL;
			ValaIterator* _tmp378_;
			gpointer _tmp379_;
			_tmp377_ = ref_generics_it;
			if (!vala_iterator_next (_tmp377_)) {
				break;
			}
			_tmp378_ = ref_generics_it;
			_tmp379_ = vala_iterator_get (_tmp378_);
			ref_generics = (ValaGenericType*) _tmp379_;
			{
				ValaList* _type_param_list = NULL;
				ValaList* _tmp380_;
				gint _type_param_size = 0;
				ValaList* _tmp381_;
				gint _tmp382_;
				gint _tmp383_;
				gint _type_param_index = 0;
				_tmp380_ = vala_method_get_type_parameters (self);
				_type_param_list = _tmp380_;
				_tmp381_ = _type_param_list;
				_tmp382_ = vala_collection_get_size ((ValaCollection*) _tmp381_);
				_tmp383_ = _tmp382_;
				_type_param_size = _tmp383_;
				_type_param_index = -1;
				while (TRUE) {
					gint _tmp384_;
					gint _tmp385_;
					ValaTypeParameter* type_param = NULL;
					ValaList* _tmp386_;
					gpointer _tmp387_;
					ValaGenericType* _tmp388_;
					ValaTypeParameter* _tmp389_;
					ValaTypeParameter* _tmp390_;
					const gchar* _tmp391_;
					const gchar* _tmp392_;
					ValaTypeParameter* _tmp393_;
					const gchar* _tmp394_;
					const gchar* _tmp395_;
					_type_param_index = _type_param_index + 1;
					_tmp384_ = _type_param_index;
					_tmp385_ = _type_param_size;
					if (!(_tmp384_ < _tmp385_)) {
						break;
					}
					_tmp386_ = _type_param_list;
					_tmp387_ = vala_list_get (_tmp386_, _type_param_index);
					type_param = (ValaTypeParameter*) _tmp387_;
					_tmp388_ = ref_generics;
					_tmp389_ = vala_generic_type_get_type_parameter (_tmp388_);
					_tmp390_ = _tmp389_;
					_tmp391_ = vala_symbol_get_name ((ValaSymbol*) _tmp390_);
					_tmp392_ = _tmp391_;
					_tmp393_ = type_param;
					_tmp394_ = vala_symbol_get_name ((ValaSymbol*) _tmp393_);
					_tmp395_ = _tmp394_;
					if (g_strcmp0 (_tmp392_, _tmp395_) == 0) {
						ValaIterator* _tmp396_;
						_tmp396_ = ref_generics_it;
						vala_iterator_remove (_tmp396_);
					}
					_vala_code_node_unref0 (type_param);
				}
			}
			_vala_code_node_unref0 (ref_generics);
		}
		{
			ValaList* _type_list = NULL;
			ValaList* _tmp397_;
			gint _type_size = 0;
			ValaList* _tmp398_;
			gint _tmp399_;
			gint _tmp400_;
			gint _type_index = 0;
			_tmp397_ = _data2_->referenced_generics;
			_type_list = _tmp397_;
			_tmp398_ = _type_list;
			_tmp399_ = vala_collection_get_size ((ValaCollection*) _tmp398_);
			_tmp400_ = _tmp399_;
			_type_size = _tmp400_;
			_type_index = -1;
			while (TRUE) {
				gint _tmp401_;
				gint _tmp402_;
				ValaGenericType* type = NULL;
				ValaList* _tmp403_;
				gpointer _tmp404_;
				ValaGenericType* _tmp405_;
				ValaSourceReference* _tmp406_;
				ValaSourceReference* _tmp407_;
				ValaGenericType* _tmp408_;
				ValaTypeParameter* _tmp409_;
				ValaTypeParameter* _tmp410_;
				const gchar* _tmp411_;
				const gchar* _tmp412_;
				_type_index = _type_index + 1;
				_tmp401_ = _type_index;
				_tmp402_ = _type_size;
				if (!(_tmp401_ < _tmp402_)) {
					break;
				}
				_tmp403_ = _type_list;
				_tmp404_ = vala_list_get (_tmp403_, _type_index);
				type = (ValaGenericType*) _tmp404_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp405_ = type;
				_tmp406_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp405_);
				_tmp407_ = _tmp406_;
				_tmp408_ = type;
				_tmp409_ = vala_generic_type_get_type_parameter (_tmp408_);
				_tmp410_ = _tmp409_;
				_tmp411_ = vala_symbol_get_name ((ValaSymbol*) _tmp410_);
				_tmp412_ = _tmp411_;
				vala_report_error (_tmp407_, "The type name `%s' could not be found", _tmp412_);
				_vala_code_node_unref0 (type);
			}
		}
		_vala_iterator_unref0 (ref_generics_it);
	}
	_tmp413_ = self->priv->_coroutine;
	if (_tmp413_) {
		gboolean requires_pointer = FALSE;
		requires_pointer = FALSE;
		{
			gint i = 0;
			ValaList* _tmp414_;
			gint _tmp415_;
			gint _tmp416_;
			_tmp414_ = self->priv->parameters;
			_tmp415_ = vala_collection_get_size ((ValaCollection*) _tmp414_);
			_tmp416_ = _tmp415_;
			i = _tmp416_ - 1;
			{
				gboolean _tmp417_ = FALSE;
				_tmp417_ = TRUE;
				while (TRUE) {
					ValaParameter* param = NULL;
					ValaList* _tmp419_;
					gpointer _tmp420_;
					ValaParameter* _tmp421_;
					ValaParameterDirection _tmp422_;
					ValaParameterDirection _tmp423_;
					if (!_tmp417_) {
						gint _tmp418_;
						_tmp418_ = i;
						i = _tmp418_ - 1;
					}
					_tmp417_ = FALSE;
					if (!(i >= 0)) {
						break;
					}
					_tmp419_ = self->priv->parameters;
					_tmp420_ = vala_list_get (_tmp419_, i);
					param = (ValaParameter*) _tmp420_;
					_tmp421_ = param;
					_tmp422_ = vala_parameter_get_direction (_tmp421_);
					_tmp423_ = _tmp422_;
					if (_tmp423_ == VALA_PARAMETER_DIRECTION_IN) {
						requires_pointer = TRUE;
					} else {
						if (requires_pointer) {
							ValaParameter* _tmp424_;
							ValaSourceReference* _tmp425_;
							ValaSourceReference* _tmp426_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp424_ = param;
							_tmp425_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp424_);
							_tmp426_ = _tmp425_;
							vala_report_error (_tmp426_, "Synchronous out-parameters are not supported in async methods");
						}
					}
					_vala_code_node_unref0 (param);
				}
			}
		}
	}
	_tmp427_ = self->error_types;
	if (_tmp427_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp428_;
			gint _error_type_size = 0;
			ValaList* _tmp429_;
			gint _tmp430_;
			gint _tmp431_;
			gint _error_type_index = 0;
			_tmp428_ = self->error_types;
			_error_type_list = _tmp428_;
			_tmp429_ = _error_type_list;
			_tmp430_ = vala_collection_get_size ((ValaCollection*) _tmp429_);
			_tmp431_ = _tmp430_;
			_error_type_size = _tmp431_;
			_error_type_index = -1;
			while (TRUE) {
				gint _tmp432_;
				gint _tmp433_;
				ValaDataType* error_type = NULL;
				ValaList* _tmp434_;
				gpointer _tmp435_;
				ValaDataType* _tmp436_;
				ValaDataType* _tmp443_;
				ValaDataType* _tmp444_;
				_error_type_index = _error_type_index + 1;
				_tmp432_ = _error_type_index;
				_tmp433_ = _error_type_size;
				if (!(_tmp432_ < _tmp433_)) {
					break;
				}
				_tmp434_ = _error_type_list;
				_tmp435_ = vala_list_get (_tmp434_, _error_type_index);
				error_type = (ValaDataType*) _tmp435_;
				_tmp436_ = error_type;
				if (!VALA_IS_ERROR_TYPE (_tmp436_)) {
					ValaDataType* _tmp437_;
					ValaSourceReference* _tmp438_;
					ValaSourceReference* _tmp439_;
					ValaDataType* _tmp440_;
					gchar* _tmp441_;
					gchar* _tmp442_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp437_ = error_type;
					_tmp438_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp437_);
					_tmp439_ = _tmp438_;
					_tmp440_ = error_type;
					_tmp441_ = vala_code_node_to_string ((ValaCodeNode*) _tmp440_);
					_tmp442_ = _tmp441_;
					vala_report_error (_tmp439_, "`%s' is not an error type", _tmp442_);
					_g_free0 (_tmp442_);
				}
				_tmp443_ = error_type;
				vala_code_node_check ((ValaCodeNode*) _tmp443_, context);
				_tmp444_ = error_type;
				if (!vala_data_type_is_accessible (_tmp444_, (ValaSymbol*) self)) {
					ValaSourceReference* _tmp445_;
					ValaSourceReference* _tmp446_;
					ValaDataType* _tmp447_;
					gchar* _tmp448_;
					gchar* _tmp449_;
					gchar* _tmp450_;
					gchar* _tmp451_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp445_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp446_ = _tmp445_;
					_tmp447_ = error_type;
					_tmp448_ = vala_code_node_to_string ((ValaCodeNode*) _tmp447_);
					_tmp449_ = _tmp448_;
					_tmp450_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp451_ = _tmp450_;
					vala_report_error (_tmp446_, "error type `%s' is less accessible than method `%s'", _tmp449_, _tmp451_);
					_g_free0 (_tmp451_);
					_g_free0 (_tmp449_);
					result = FALSE;
					_vala_code_node_unref0 (error_type);
					_vala_code_visitor_unref0 (traverse);
					_vala_code_node_unref0 (init_attr);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					block2_data_unref (_data2_);
					_data2_ = NULL;
					return result;
				}
				_vala_code_node_unref0 (error_type);
			}
		}
	}
	_tmp452_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp453_ = _tmp452_;
	if (_tmp453_ != NULL) {
		ValaLocalVariable* _tmp454_;
		ValaLocalVariable* _tmp455_;
		_tmp454_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp455_ = _tmp454_;
		vala_code_node_check ((ValaCodeNode*) _tmp455_, context);
	}
	_tmp456_ = self->priv->preconditions;
	if (_tmp456_ != NULL) {
		{
			ValaList* _precondition_list = NULL;
			ValaList* _tmp457_;
			gint _precondition_size = 0;
			ValaList* _tmp458_;
			gint _tmp459_;
			gint _tmp460_;
			gint _precondition_index = 0;
			_tmp457_ = self->priv->preconditions;
			_precondition_list = _tmp457_;
			_tmp458_ = _precondition_list;
			_tmp459_ = vala_collection_get_size ((ValaCollection*) _tmp458_);
			_tmp460_ = _tmp459_;
			_precondition_size = _tmp460_;
			_precondition_index = -1;
			while (TRUE) {
				gint _tmp461_;
				gint _tmp462_;
				ValaExpression* precondition = NULL;
				ValaList* _tmp463_;
				gpointer _tmp464_;
				ValaExpression* _tmp465_;
				_precondition_index = _precondition_index + 1;
				_tmp461_ = _precondition_index;
				_tmp462_ = _precondition_size;
				if (!(_tmp461_ < _tmp462_)) {
					break;
				}
				_tmp463_ = _precondition_list;
				_tmp464_ = vala_list_get (_tmp463_, _precondition_index);
				precondition = (ValaExpression*) _tmp464_;
				_tmp465_ = precondition;
				vala_code_node_check ((ValaCodeNode*) _tmp465_, context);
				_vala_code_node_unref0 (precondition);
			}
		}
	}
	_tmp466_ = self->priv->postconditions;
	if (_tmp466_ != NULL) {
		{
			ValaList* _postcondition_list = NULL;
			ValaList* _tmp467_;
			gint _postcondition_size = 0;
			ValaList* _tmp468_;
			gint _tmp469_;
			gint _tmp470_;
			gint _postcondition_index = 0;
			_tmp467_ = self->priv->postconditions;
			_postcondition_list = _tmp467_;
			_tmp468_ = _postcondition_list;
			_tmp469_ = vala_collection_get_size ((ValaCollection*) _tmp468_);
			_tmp470_ = _tmp469_;
			_postcondition_size = _tmp470_;
			_postcondition_index = -1;
			while (TRUE) {
				gint _tmp471_;
				gint _tmp472_;
				ValaExpression* postcondition = NULL;
				ValaList* _tmp473_;
				gpointer _tmp474_;
				ValaExpression* _tmp475_;
				_postcondition_index = _postcondition_index + 1;
				_tmp471_ = _postcondition_index;
				_tmp472_ = _postcondition_size;
				if (!(_tmp471_ < _tmp472_)) {
					break;
				}
				_tmp473_ = _postcondition_list;
				_tmp474_ = vala_list_get (_tmp473_, _postcondition_index);
				postcondition = (ValaExpression*) _tmp474_;
				_tmp475_ = postcondition;
				vala_code_node_check ((ValaCodeNode*) _tmp475_, context);
				_vala_code_node_unref0 (postcondition);
			}
		}
	}
	_tmp476_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp477_ = _tmp476_;
	if (_tmp477_ != NULL) {
		ValaBlock* _tmp478_;
		ValaBlock* _tmp479_;
		_tmp478_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp479_ = _tmp478_;
		vala_code_node_check ((ValaCodeNode*) _tmp479_, context);
	}
	_tmp483_ = self->priv->_overrides;
	if (_tmp483_) {
		ValaMethod* _tmp484_;
		ValaMethod* _tmp485_;
		_tmp484_ = vala_method_get_base_method (self);
		_tmp485_ = _tmp484_;
		_tmp482_ = _tmp485_ == NULL;
	} else {
		_tmp482_ = FALSE;
	}
	if (_tmp482_) {
		ValaMethod* _tmp486_;
		ValaMethod* _tmp487_;
		_tmp486_ = vala_method_get_base_interface_method (self);
		_tmp487_ = _tmp486_;
		_tmp481_ = _tmp487_ != NULL;
	} else {
		_tmp481_ = FALSE;
	}
	if (_tmp481_) {
		ValaMethod* _tmp488_;
		ValaMethod* _tmp489_;
		gboolean _tmp490_;
		_tmp488_ = vala_method_get_base_interface_method (self);
		_tmp489_ = _tmp488_;
		_tmp490_ = _tmp489_->priv->_is_abstract;
		_tmp480_ = _tmp490_;
	} else {
		_tmp480_ = FALSE;
	}
	if (_tmp480_) {
		ValaSourceReference* _tmp491_;
		ValaSourceReference* _tmp492_;
		ValaMethod* _tmp493_;
		ValaMethod* _tmp494_;
		gchar* _tmp495_;
		gchar* _tmp496_;
		_tmp491_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp492_ = _tmp491_;
		_tmp493_ = vala_method_get_base_interface_method (self);
		_tmp494_ = _tmp493_;
		_tmp495_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp494_);
		_tmp496_ = _tmp495_;
		vala_report_warning (_tmp492_, "`override' not required to implement `abstract' interface method `%s'", _tmp496_);
		_g_free0 (_tmp496_);
		vala_method_set_overrides (self, FALSE);
	} else {
		gboolean _tmp497_ = FALSE;
		gboolean _tmp498_ = FALSE;
		gboolean _tmp499_;
		_tmp499_ = self->priv->_overrides;
		if (_tmp499_) {
			ValaMethod* _tmp500_;
			ValaMethod* _tmp501_;
			_tmp500_ = vala_method_get_base_method (self);
			_tmp501_ = _tmp500_;
			_tmp498_ = _tmp501_ == NULL;
		} else {
			_tmp498_ = FALSE;
		}
		if (_tmp498_) {
			ValaMethod* _tmp502_;
			ValaMethod* _tmp503_;
			_tmp502_ = vala_method_get_base_interface_method (self);
			_tmp503_ = _tmp502_;
			_tmp497_ = _tmp503_ == NULL;
		} else {
			_tmp497_ = FALSE;
		}
		if (_tmp497_) {
			ValaSourceReference* _tmp504_;
			ValaSourceReference* _tmp505_;
			gchar* _tmp506_;
			gchar* _tmp507_;
			_tmp504_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp505_ = _tmp504_;
			_tmp506_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp507_ = _tmp506_;
			vala_report_error (_tmp505_, "`%s': no suitable method found to override", _tmp507_);
			_g_free0 (_tmp507_);
		} else {
			gboolean _tmp508_ = FALSE;
			gboolean _tmp509_ = FALSE;
			gboolean _tmp510_ = FALSE;
			gboolean _tmp511_;
			_tmp511_ = self->priv->_is_abstract;
			if (_tmp511_) {
				_tmp510_ = TRUE;
			} else {
				gboolean _tmp512_;
				_tmp512_ = self->priv->_is_virtual;
				_tmp510_ = _tmp512_;
			}
			if (_tmp510_) {
				_tmp509_ = TRUE;
			} else {
				gboolean _tmp513_;
				_tmp513_ = self->priv->_overrides;
				_tmp509_ = _tmp513_;
			}
			if (_tmp509_) {
				ValaSymbolAccessibility _tmp514_;
				ValaSymbolAccessibility _tmp515_;
				_tmp514_ = vala_symbol_get_access ((ValaSymbol*) self);
				_tmp515_ = _tmp514_;
				_tmp508_ = _tmp515_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
			} else {
				_tmp508_ = FALSE;
			}
			if (_tmp508_) {
				ValaSourceReference* _tmp516_;
				ValaSourceReference* _tmp517_;
				gchar* _tmp518_;
				gchar* _tmp519_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp516_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp517_ = _tmp516_;
				_tmp518_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp519_ = _tmp518_;
				vala_report_error (_tmp517_, "Private member `%s' cannot be marked as override, virtual, or abstract", _tmp519_);
				_g_free0 (_tmp519_);
				result = FALSE;
				_vala_code_visitor_unref0 (traverse);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				block2_data_unref (_data2_);
				_data2_ = NULL;
				return result;
			}
		}
	}
	_tmp522_ = vala_method_get_base_interface_type (self);
	_tmp523_ = _tmp522_;
	if (_tmp523_ != NULL) {
		ValaMethod* _tmp524_;
		ValaMethod* _tmp525_;
		_tmp524_ = vala_method_get_base_interface_method (self);
		_tmp525_ = _tmp524_;
		_tmp521_ = _tmp525_ != NULL;
	} else {
		_tmp521_ = FALSE;
	}
	if (_tmp521_) {
		ValaSymbol* _tmp526_;
		ValaSymbol* _tmp527_;
		_tmp526_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp527_ = _tmp526_;
		_tmp520_ = VALA_IS_CLASS (_tmp527_);
	} else {
		_tmp520_ = FALSE;
	}
	if (_tmp520_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp528_;
		ValaSymbol* _tmp529_;
		_tmp528_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp529_ = _tmp528_;
		cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp529_, VALA_TYPE_CLASS, ValaClass);
		{
			ValaList* _m_list = NULL;
			ValaClass* _tmp530_;
			ValaList* _tmp531_;
			gint _m_size = 0;
			ValaList* _tmp532_;
			gint _tmp533_;
			gint _tmp534_;
			gint _m_index = 0;
			_tmp530_ = cl;
			_tmp531_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp530_);
			_m_list = _tmp531_;
			_tmp532_ = _m_list;
			_tmp533_ = vala_collection_get_size ((ValaCollection*) _tmp532_);
			_tmp534_ = _tmp533_;
			_m_size = _tmp534_;
			_m_index = -1;
			while (TRUE) {
				gint _tmp535_;
				gint _tmp536_;
				ValaMethod* m = NULL;
				ValaList* _tmp537_;
				gpointer _tmp538_;
				gboolean _tmp539_ = FALSE;
				ValaMethod* _tmp540_;
				_m_index = _m_index + 1;
				_tmp535_ = _m_index;
				_tmp536_ = _m_size;
				if (!(_tmp535_ < _tmp536_)) {
					break;
				}
				_tmp537_ = _m_list;
				_tmp538_ = vala_list_get (_tmp537_, _m_index);
				m = (ValaMethod*) _tmp538_;
				_tmp540_ = m;
				if (_tmp540_ != self) {
					ValaMethod* _tmp541_;
					ValaMethod* _tmp542_;
					ValaMethod* _tmp543_;
					ValaMethod* _tmp544_;
					ValaMethod* _tmp545_;
					_tmp541_ = m;
					_tmp542_ = vala_method_get_base_interface_method (_tmp541_);
					_tmp543_ = _tmp542_;
					_tmp544_ = vala_method_get_base_interface_method (self);
					_tmp545_ = _tmp544_;
					_tmp539_ = _tmp543_ == _tmp545_;
				} else {
					_tmp539_ = FALSE;
				}
				if (_tmp539_) {
					ValaMethod* _tmp546_;
					ValaMethod* _tmp547_;
					ValaSourceReference* _tmp548_;
					ValaSourceReference* _tmp549_;
					ValaClass* _tmp550_;
					gchar* _tmp551_;
					gchar* _tmp552_;
					ValaMethod* _tmp553_;
					ValaMethod* _tmp554_;
					gchar* _tmp555_;
					gchar* _tmp556_;
					ValaMethod* _tmp557_;
					ValaSourceReference* _tmp558_;
					ValaSourceReference* _tmp559_;
					ValaMethod* _tmp560_;
					ValaMethod* _tmp561_;
					gchar* _tmp562_;
					gchar* _tmp563_;
					_tmp546_ = m;
					vala_code_node_set_checked ((ValaCodeNode*) _tmp546_, TRUE);
					_tmp547_ = m;
					vala_code_node_set_error ((ValaCodeNode*) _tmp547_, TRUE);
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp548_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp549_ = _tmp548_;
					_tmp550_ = cl;
					_tmp551_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp550_);
					_tmp552_ = _tmp551_;
					_tmp553_ = vala_method_get_base_interface_method (self);
					_tmp554_ = _tmp553_;
					_tmp555_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp554_);
					_tmp556_ = _tmp555_;
					vala_report_error (_tmp549_, "`%s' already contains an implementation for `%s'", _tmp552_, _tmp556_);
					_g_free0 (_tmp556_);
					_g_free0 (_tmp552_);
					_tmp557_ = m;
					_tmp558_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp557_);
					_tmp559_ = _tmp558_;
					_tmp560_ = vala_method_get_base_interface_method (self);
					_tmp561_ = _tmp560_;
					_tmp562_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp561_);
					_tmp563_ = _tmp562_;
					vala_report_notice (_tmp559_, "previous implementation of `%s' was here", _tmp563_);
					_g_free0 (_tmp563_);
					result = FALSE;
					_vala_code_node_unref0 (m);
					_vala_code_visitor_unref0 (traverse);
					_vala_code_node_unref0 (init_attr);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					block2_data_unref (_data2_);
					_data2_ = NULL;
					return result;
				}
				_vala_code_node_unref0 (m);
			}
		}
	}
	_tmp564_ = vala_code_context_get_analyzer (context);
	_tmp565_ = _tmp564_;
	_tmp566_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp565_, _tmp566_);
	_tmp567_ = vala_code_context_get_analyzer (context);
	_tmp568_ = _tmp567_;
	_tmp569_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp568_, _tmp569_);
	_tmp573_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp574_ = _tmp573_;
	if (!_tmp574_) {
		gboolean _tmp575_;
		_tmp575_ = self->priv->_overrides;
		_tmp572_ = !_tmp575_;
	} else {
		_tmp572_ = FALSE;
	}
	if (_tmp572_) {
		gboolean _tmp576_;
		gboolean _tmp577_;
		_tmp576_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp577_ = _tmp576_;
		_tmp571_ = !_tmp577_;
	} else {
		_tmp571_ = FALSE;
	}
	if (_tmp571_) {
		ValaSymbol* _tmp578_;
		ValaSymbol* _tmp579_;
		_tmp578_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp579_ = _tmp578_;
		_tmp570_ = _tmp579_ != NULL;
		_vala_code_node_unref0 (_tmp579_);
	} else {
		_tmp570_ = FALSE;
	}
	if (_tmp570_) {
		ValaSourceReference* _tmp580_;
		ValaSourceReference* _tmp581_;
		gchar* _tmp582_;
		gchar* _tmp583_;
		ValaSymbol* _tmp584_;
		ValaSymbol* _tmp585_;
		gchar* _tmp586_;
		gchar* _tmp587_;
		_tmp580_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp581_ = _tmp580_;
		_tmp582_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp583_ = _tmp582_;
		_tmp584_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp585_ = _tmp584_;
		_tmp586_ = vala_symbol_get_full_name (_tmp585_);
		_tmp587_ = _tmp586_;
		vala_report_warning (_tmp581_, "%s hides inherited method `%s'. Use the `new' keyword if hiding was in" \
"tentional", _tmp583_, _tmp587_);
		_g_free0 (_tmp587_);
		_vala_code_node_unref0 (_tmp585_);
		_g_free0 (_tmp583_);
	}
	_tmp588_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp589_ = _tmp588_;
	if (!vala_data_type_is_accessible (_tmp589_, (ValaSymbol*) self)) {
		ValaSourceReference* _tmp590_;
		ValaSourceReference* _tmp591_;
		ValaDataType* _tmp592_;
		ValaDataType* _tmp593_;
		gchar* _tmp594_;
		gchar* _tmp595_;
		gchar* _tmp596_;
		gchar* _tmp597_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp590_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp591_ = _tmp590_;
		_tmp592_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp593_ = _tmp592_;
		_tmp594_ = vala_code_node_to_string ((ValaCodeNode*) _tmp593_);
		_tmp595_ = _tmp594_;
		_tmp596_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp597_ = _tmp596_;
		vala_report_error (_tmp591_, "return type `%s' is less accessible than method `%s'", _tmp595_, _tmp597_);
		_g_free0 (_tmp597_);
		_g_free0 (_tmp595_);
		result = FALSE;
		_vala_code_visitor_unref0 (traverse);
		_vala_code_node_unref0 (init_attr);
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return result;
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp598_;
		gint _precondition_size = 0;
		ValaList* _tmp599_;
		gint _tmp600_;
		gint _tmp601_;
		gint _precondition_index = 0;
		_tmp598_ = vala_method_get_preconditions (self);
		_precondition_list = _tmp598_;
		_tmp599_ = _precondition_list;
		_tmp600_ = vala_collection_get_size ((ValaCollection*) _tmp599_);
		_tmp601_ = _tmp600_;
		_precondition_size = _tmp601_;
		_precondition_index = -1;
		while (TRUE) {
			gint _tmp602_;
			gint _tmp603_;
			ValaExpression* precondition = NULL;
			ValaList* _tmp604_;
			gpointer _tmp605_;
			ValaExpression* _tmp606_;
			gboolean _tmp607_;
			gboolean _tmp608_;
			ValaExpression* _tmp609_;
			ValaDataType* _tmp610_;
			ValaDataType* _tmp611_;
			ValaSemanticAnalyzer* _tmp612_;
			ValaSemanticAnalyzer* _tmp613_;
			ValaDataType* _tmp614_;
			_precondition_index = _precondition_index + 1;
			_tmp602_ = _precondition_index;
			_tmp603_ = _precondition_size;
			if (!(_tmp602_ < _tmp603_)) {
				break;
			}
			_tmp604_ = _precondition_list;
			_tmp605_ = vala_list_get (_tmp604_, _precondition_index);
			precondition = (ValaExpression*) _tmp605_;
			_tmp606_ = precondition;
			_tmp607_ = vala_code_node_get_error ((ValaCodeNode*) _tmp606_);
			_tmp608_ = _tmp607_;
			if (_tmp608_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (precondition);
				_vala_code_visitor_unref0 (traverse);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				block2_data_unref (_data2_);
				_data2_ = NULL;
				return result;
			}
			_tmp609_ = precondition;
			_tmp610_ = vala_expression_get_value_type (_tmp609_);
			_tmp611_ = _tmp610_;
			_tmp612_ = vala_code_context_get_analyzer (context);
			_tmp613_ = _tmp612_;
			_tmp614_ = _tmp613_->bool_type;
			if (!vala_data_type_compatible (_tmp611_, _tmp614_)) {
				ValaExpression* _tmp615_;
				ValaSourceReference* _tmp616_;
				ValaSourceReference* _tmp617_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp615_ = precondition;
				_tmp616_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp615_);
				_tmp617_ = _tmp616_;
				vala_report_error (_tmp617_, "Precondition must be boolean");
				result = FALSE;
				_vala_code_node_unref0 (precondition);
				_vala_code_visitor_unref0 (traverse);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				block2_data_unref (_data2_);
				_data2_ = NULL;
				return result;
			}
			_vala_code_node_unref0 (precondition);
		}
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp618_;
		gint _postcondition_size = 0;
		ValaList* _tmp619_;
		gint _tmp620_;
		gint _tmp621_;
		gint _postcondition_index = 0;
		_tmp618_ = vala_method_get_postconditions (self);
		_postcondition_list = _tmp618_;
		_tmp619_ = _postcondition_list;
		_tmp620_ = vala_collection_get_size ((ValaCollection*) _tmp619_);
		_tmp621_ = _tmp620_;
		_postcondition_size = _tmp621_;
		_postcondition_index = -1;
		while (TRUE) {
			gint _tmp622_;
			gint _tmp623_;
			ValaExpression* postcondition = NULL;
			ValaList* _tmp624_;
			gpointer _tmp625_;
			ValaExpression* _tmp626_;
			gboolean _tmp627_;
			gboolean _tmp628_;
			ValaExpression* _tmp629_;
			ValaDataType* _tmp630_;
			ValaDataType* _tmp631_;
			ValaSemanticAnalyzer* _tmp632_;
			ValaSemanticAnalyzer* _tmp633_;
			ValaDataType* _tmp634_;
			_postcondition_index = _postcondition_index + 1;
			_tmp622_ = _postcondition_index;
			_tmp623_ = _postcondition_size;
			if (!(_tmp622_ < _tmp623_)) {
				break;
			}
			_tmp624_ = _postcondition_list;
			_tmp625_ = vala_list_get (_tmp624_, _postcondition_index);
			postcondition = (ValaExpression*) _tmp625_;
			_tmp626_ = postcondition;
			_tmp627_ = vala_code_node_get_error ((ValaCodeNode*) _tmp626_);
			_tmp628_ = _tmp627_;
			if (_tmp628_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (postcondition);
				_vala_code_visitor_unref0 (traverse);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				block2_data_unref (_data2_);
				_data2_ = NULL;
				return result;
			}
			_tmp629_ = postcondition;
			_tmp630_ = vala_expression_get_value_type (_tmp629_);
			_tmp631_ = _tmp630_;
			_tmp632_ = vala_code_context_get_analyzer (context);
			_tmp633_ = _tmp632_;
			_tmp634_ = _tmp633_->bool_type;
			if (!vala_data_type_compatible (_tmp631_, _tmp634_)) {
				ValaExpression* _tmp635_;
				ValaSourceReference* _tmp636_;
				ValaSourceReference* _tmp637_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp635_ = postcondition;
				_tmp636_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp635_);
				_tmp637_ = _tmp636_;
				vala_report_error (_tmp637_, "Postcondition must be boolean");
				result = FALSE;
				_vala_code_node_unref0 (postcondition);
				_vala_code_visitor_unref0 (traverse);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				block2_data_unref (_data2_);
				_data2_ = NULL;
				return result;
			}
			_vala_code_node_unref0 (postcondition);
		}
	}
	_tmp639_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp640_ = _tmp639_;
	if (_tmp640_ != NULL) {
		ValaBlock* _tmp641_;
		ValaBlock* _tmp642_;
		gboolean _tmp643_;
		gboolean _tmp644_;
		_tmp641_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp642_ = _tmp641_;
		_tmp643_ = vala_code_node_get_error ((ValaCodeNode*) _tmp642_);
		_tmp644_ = _tmp643_;
		_tmp638_ = !_tmp644_;
	} else {
		_tmp638_ = FALSE;
	}
	if (_tmp638_) {
		ValaArrayList* body_errors = NULL;
		GEqualFunc _tmp645_;
		ValaArrayList* _tmp646_;
		ValaBlock* _tmp647_;
		ValaBlock* _tmp648_;
		ValaArrayList* _tmp649_;
		_tmp645_ = g_direct_equal;
		_tmp646_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp645_);
		body_errors = _tmp646_;
		_tmp647_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp648_ = _tmp647_;
		_tmp649_ = body_errors;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp648_, (ValaCollection*) _tmp649_, NULL);
		{
			ValaArrayList* _body_error_type_list = NULL;
			ValaArrayList* _tmp650_;
			gint _body_error_type_size = 0;
			ValaArrayList* _tmp651_;
			gint _tmp652_;
			gint _tmp653_;
			gint _body_error_type_index = 0;
			_tmp650_ = body_errors;
			_body_error_type_list = _tmp650_;
			_tmp651_ = _body_error_type_list;
			_tmp652_ = vala_collection_get_size ((ValaCollection*) _tmp651_);
			_tmp653_ = _tmp652_;
			_body_error_type_size = _tmp653_;
			_body_error_type_index = -1;
			while (TRUE) {
				gint _tmp654_;
				gint _tmp655_;
				ValaDataType* body_error_type = NULL;
				ValaArrayList* _tmp656_;
				gpointer _tmp657_;
				gboolean can_propagate_error = FALSE;
				ValaList* _tmp658_;
				gboolean _tmp669_ = FALSE;
				ValaDataType* _tmp670_;
				gboolean is_dynamic_error = FALSE;
				gboolean _tmp674_ = FALSE;
				_body_error_type_index = _body_error_type_index + 1;
				_tmp654_ = _body_error_type_index;
				_tmp655_ = _body_error_type_size;
				if (!(_tmp654_ < _tmp655_)) {
					break;
				}
				_tmp656_ = _body_error_type_list;
				_tmp657_ = vala_list_get ((ValaList*) _tmp656_, _body_error_type_index);
				body_error_type = (ValaDataType*) _tmp657_;
				can_propagate_error = FALSE;
				_tmp658_ = self->error_types;
				if (_tmp658_ != NULL) {
					{
						ValaList* _method_error_type_list = NULL;
						ValaList* _tmp659_;
						gint _method_error_type_size = 0;
						ValaList* _tmp660_;
						gint _tmp661_;
						gint _tmp662_;
						gint _method_error_type_index = 0;
						_tmp659_ = self->error_types;
						_method_error_type_list = _tmp659_;
						_tmp660_ = _method_error_type_list;
						_tmp661_ = vala_collection_get_size ((ValaCollection*) _tmp660_);
						_tmp662_ = _tmp661_;
						_method_error_type_size = _tmp662_;
						_method_error_type_index = -1;
						while (TRUE) {
							gint _tmp663_;
							gint _tmp664_;
							ValaDataType* method_error_type = NULL;
							ValaList* _tmp665_;
							gpointer _tmp666_;
							ValaDataType* _tmp667_;
							ValaDataType* _tmp668_;
							_method_error_type_index = _method_error_type_index + 1;
							_tmp663_ = _method_error_type_index;
							_tmp664_ = _method_error_type_size;
							if (!(_tmp663_ < _tmp664_)) {
								break;
							}
							_tmp665_ = _method_error_type_list;
							_tmp666_ = vala_list_get (_tmp665_, _method_error_type_index);
							method_error_type = (ValaDataType*) _tmp666_;
							_tmp667_ = body_error_type;
							_tmp668_ = method_error_type;
							if (vala_data_type_compatible (_tmp667_, _tmp668_)) {
								can_propagate_error = TRUE;
							}
							_vala_code_node_unref0 (method_error_type);
						}
					}
				}
				_tmp670_ = body_error_type;
				if (VALA_IS_ERROR_TYPE (_tmp670_)) {
					ValaDataType* _tmp671_;
					gboolean _tmp672_;
					gboolean _tmp673_;
					_tmp671_ = body_error_type;
					_tmp672_ = vala_error_type_get_dynamic_error (G_TYPE_CHECK_INSTANCE_CAST (_tmp671_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp673_ = _tmp672_;
					_tmp669_ = _tmp673_;
				} else {
					_tmp669_ = FALSE;
				}
				is_dynamic_error = _tmp669_;
				if (!can_propagate_error) {
					_tmp674_ = !is_dynamic_error;
				} else {
					_tmp674_ = FALSE;
				}
				if (_tmp674_) {
					ValaDataType* _tmp675_;
					ValaSourceReference* _tmp676_;
					ValaSourceReference* _tmp677_;
					ValaDataType* _tmp678_;
					gchar* _tmp679_;
					gchar* _tmp680_;
					_tmp675_ = body_error_type;
					_tmp676_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp675_);
					_tmp677_ = _tmp676_;
					_tmp678_ = body_error_type;
					_tmp679_ = vala_code_node_to_string ((ValaCodeNode*) _tmp678_);
					_tmp680_ = _tmp679_;
					vala_report_warning (_tmp677_, "unhandled error `%s'", _tmp680_);
					_g_free0 (_tmp680_);
				}
				_vala_code_node_unref0 (body_error_type);
			}
		}
		_vala_iterable_unref0 (body_errors);
	}
	if (!VALA_IS_CREATION_METHOD (self)) {
		ValaMemberBinding _tmp686_;
		_tmp686_ = self->priv->_binding;
		_tmp685_ = _tmp686_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp685_ = FALSE;
	}
	if (_tmp685_) {
		gboolean _tmp687_;
		_tmp687_ = self->priv->_overrides;
		_tmp684_ = !_tmp687_;
	} else {
		_tmp684_ = FALSE;
	}
	if (_tmp684_) {
		ValaSymbolAccessibility _tmp688_;
		ValaSymbolAccessibility _tmp689_;
		_tmp688_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp689_ = _tmp688_;
		_tmp683_ = _tmp689_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	} else {
		_tmp683_ = FALSE;
	}
	if (_tmp683_) {
		ValaSymbol* _tmp690_;
		ValaSymbol* _tmp691_;
		_tmp690_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp691_ = _tmp690_;
		_tmp682_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp691_);
	} else {
		_tmp682_ = FALSE;
	}
	if (_tmp682_) {
		ValaSymbol* _tmp692_;
		ValaSymbol* _tmp693_;
		ValaAttribute* _tmp694_;
		_tmp692_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp693_ = _tmp692_;
		_tmp694_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp693_, "DBus");
		_tmp681_ = _tmp694_ != NULL;
	} else {
		_tmp681_ = FALSE;
	}
	if (_tmp681_) {
		ValaAttribute* dbus_attr = NULL;
		ValaAttribute* _tmp695_;
		ValaAttribute* _tmp696_;
		gboolean _tmp697_ = FALSE;
		ValaAttribute* _tmp698_;
		_tmp695_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "DBus");
		_tmp696_ = _vala_code_node_ref0 (_tmp695_);
		dbus_attr = _tmp696_;
		_tmp698_ = dbus_attr;
		if (_tmp698_ == NULL) {
			_tmp697_ = TRUE;
		} else {
			ValaAttribute* _tmp699_;
			_tmp699_ = dbus_attr;
			_tmp697_ = vala_attribute_get_bool (_tmp699_, "visible", TRUE);
		}
		if (_tmp697_) {
			gboolean throws_gerror = FALSE;
			gboolean throws_gioerror = FALSE;
			gboolean throws_gdbuserror = FALSE;
			ValaArrayList* error_types = NULL;
			GEqualFunc _tmp700_;
			ValaArrayList* _tmp701_;
			ValaArrayList* _tmp702_;
			gboolean _tmp720_ = FALSE;
			throws_gerror = FALSE;
			throws_gioerror = FALSE;
			throws_gdbuserror = FALSE;
			_tmp700_ = g_direct_equal;
			_tmp701_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp700_);
			error_types = _tmp701_;
			_tmp702_ = error_types;
			vala_code_node_get_error_types ((ValaCodeNode*) self, (ValaCollection*) _tmp702_, NULL);
			{
				ValaArrayList* _error_type_list = NULL;
				ValaArrayList* _tmp703_;
				gint _error_type_size = 0;
				ValaArrayList* _tmp704_;
				gint _tmp705_;
				gint _tmp706_;
				gint _error_type_index = 0;
				_tmp703_ = error_types;
				_error_type_list = _tmp703_;
				_tmp704_ = _error_type_list;
				_tmp705_ = vala_collection_get_size ((ValaCollection*) _tmp704_);
				_tmp706_ = _tmp705_;
				_error_type_size = _tmp706_;
				_error_type_index = -1;
				while (TRUE) {
					gint _tmp707_;
					gint _tmp708_;
					ValaDataType* error_type = NULL;
					ValaArrayList* _tmp709_;
					gpointer _tmp710_;
					ValaDataType* _tmp711_;
					ValaErrorDomain* error_domain = NULL;
					ValaDataType* _tmp712_;
					ValaErrorDomain* _tmp713_;
					ValaErrorDomain* _tmp714_;
					ValaErrorDomain* _tmp715_;
					gchar* full_error_domain = NULL;
					ValaErrorDomain* _tmp716_;
					gchar* _tmp717_;
					const gchar* _tmp718_;
					_error_type_index = _error_type_index + 1;
					_tmp707_ = _error_type_index;
					_tmp708_ = _error_type_size;
					if (!(_tmp707_ < _tmp708_)) {
						break;
					}
					_tmp709_ = _error_type_list;
					_tmp710_ = vala_list_get ((ValaList*) _tmp709_, _error_type_index);
					error_type = (ValaDataType*) _tmp710_;
					_tmp711_ = error_type;
					if (!VALA_IS_ERROR_TYPE (_tmp711_)) {
						_vala_code_node_unref0 (error_type);
						continue;
					}
					_tmp712_ = error_type;
					_tmp713_ = vala_error_type_get_error_domain (G_TYPE_CHECK_INSTANCE_CAST (_tmp712_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp714_ = _tmp713_;
					error_domain = _tmp714_;
					_tmp715_ = error_domain;
					if (_tmp715_ == NULL) {
						throws_gerror = TRUE;
						_vala_code_node_unref0 (error_type);
						break;
					}
					_tmp716_ = error_domain;
					_tmp717_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp716_);
					full_error_domain = _tmp717_;
					_tmp718_ = full_error_domain;
					if (g_strcmp0 (_tmp718_, "GLib.IOError") == 0) {
						throws_gioerror = TRUE;
					} else {
						const gchar* _tmp719_;
						_tmp719_ = full_error_domain;
						if (g_strcmp0 (_tmp719_, "GLib.DBusError") == 0) {
							throws_gdbuserror = TRUE;
						}
					}
					_g_free0 (full_error_domain);
					_vala_code_node_unref0 (error_type);
				}
			}
			if (!throws_gerror) {
				gboolean _tmp721_ = FALSE;
				if (throws_gioerror) {
					_tmp721_ = throws_gdbuserror;
				} else {
					_tmp721_ = FALSE;
				}
				_tmp720_ = !_tmp721_;
			} else {
				_tmp720_ = FALSE;
			}
			if (_tmp720_) {
				ValaSourceReference* _tmp722_;
				ValaSourceReference* _tmp723_;
				_tmp722_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp723_ = _tmp722_;
				vala_report_warning (_tmp723_, "DBus methods are recommended to throw at least `GLib.Error' or `GLib.D" \
"BusError, GLib.IOError'");
			}
			_vala_iterable_unref0 (error_types);
		}
		_vala_code_node_unref0 (dbus_attr);
	}
	if (vala_method_is_possible_entry_point (self, context)) {
		ValaMethod* _tmp724_;
		ValaMethod* _tmp725_;
		gboolean _tmp732_;
		gboolean _tmp733_;
		gboolean _tmp736_;
		_tmp724_ = vala_code_context_get_entry_point (context);
		_tmp725_ = _tmp724_;
		if (_tmp725_ != NULL) {
			ValaSourceReference* _tmp726_;
			ValaSourceReference* _tmp727_;
			ValaMethod* _tmp728_;
			ValaMethod* _tmp729_;
			gchar* _tmp730_;
			gchar* _tmp731_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp726_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp727_ = _tmp726_;
			_tmp728_ = vala_code_context_get_entry_point (context);
			_tmp729_ = _tmp728_;
			_tmp730_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp729_);
			_tmp731_ = _tmp730_;
			vala_report_error (_tmp727_, "program already has an entry point `%s'", _tmp731_);
			_g_free0 (_tmp731_);
			result = FALSE;
			_vala_code_visitor_unref0 (traverse);
			_vala_code_node_unref0 (init_attr);
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			block2_data_unref (_data2_);
			_data2_ = NULL;
			return result;
		}
		vala_method_set_entry_point (self, TRUE);
		vala_code_context_set_entry_point (context, self);
		_tmp732_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
		_tmp733_ = _tmp732_;
		if (_tmp733_) {
			ValaSourceReference* _tmp734_;
			ValaSourceReference* _tmp735_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp734_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp735_ = _tmp734_;
			vala_report_error (_tmp735_, "\"main\" method cannot throw errors");
		}
		_tmp736_ = self->priv->_is_inline;
		if (_tmp736_) {
			ValaSourceReference* _tmp737_;
			ValaSourceReference* _tmp738_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp737_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp738_ = _tmp737_;
			vala_report_error (_tmp738_, "\"main\" method cannot be inline");
		}
	}
	_tmp739_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "GtkCallback");
	if (_tmp739_ != NULL) {
		vala_symbol_set_used ((ValaSymbol*) self, TRUE);
	}
	_tmp740_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp741_ = _tmp740_;
	result = !_tmp741_;
	_vala_code_visitor_unref0 (traverse);
	_vala_code_node_unref0 (init_attr);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gboolean
vala_method_is_possible_entry_point (ValaMethod* self,
                                     ValaCodeContext* context)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaMemberBinding _tmp14_;
	ValaDataType* _tmp15_;
	ValaDataType* _tmp16_;
	ValaList* params = NULL;
	ValaList* _tmp26_;
	ValaList* _tmp27_;
	ValaList* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	ValaList* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	ValaIterator* params_it = NULL;
	ValaList* _tmp34_;
	ValaIterator* _tmp35_;
	ValaIterator* _tmp36_;
	ValaParameter* param = NULL;
	ValaIterator* _tmp37_;
	gpointer _tmp38_;
	ValaParameter* _tmp39_;
	ValaParameterDirection _tmp40_;
	ValaParameterDirection _tmp41_;
	ValaParameter* _tmp42_;
	ValaDataType* _tmp43_;
	ValaDataType* _tmp44_;
	ValaArrayType* array_type = NULL;
	ValaParameter* _tmp45_;
	ValaDataType* _tmp46_;
	ValaDataType* _tmp47_;
	ValaArrayType* _tmp48_;
	ValaDataType* _tmp49_;
	ValaDataType* _tmp50_;
	ValaTypeSymbol* _tmp51_;
	ValaTypeSymbol* _tmp52_;
	ValaSemanticAnalyzer* _tmp53_;
	ValaSemanticAnalyzer* _tmp54_;
	ValaDataType* _tmp55_;
	ValaTypeSymbol* _tmp56_;
	ValaTypeSymbol* _tmp57_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = vala_code_context_get_entry_point_name (context);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		gboolean _tmp4_ = FALSE;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			_tmp4_ = TRUE;
		} else {
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp8_ = _tmp7_;
			_tmp4_ = g_strcmp0 (_tmp8_, "main") != 0;
		}
		if (_tmp4_) {
			result = FALSE;
			return result;
		}
	} else {
		gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gboolean _tmp13_;
		_tmp9_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_code_context_get_entry_point_name (context);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strcmp0 (_tmp10_, _tmp12_) != 0;
		_g_free0 (_tmp10_);
		if (_tmp13_) {
			result = FALSE;
			return result;
		}
	}
	_tmp14_ = self->priv->_binding;
	if (_tmp14_ == VALA_MEMBER_BINDING_INSTANCE) {
		result = FALSE;
		return result;
	}
	_tmp15_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp16_ = _tmp15_;
	if (VALA_IS_VOID_TYPE (_tmp16_)) {
	} else {
		ValaDataType* _tmp17_;
		ValaDataType* _tmp18_;
		ValaTypeSymbol* _tmp19_;
		ValaTypeSymbol* _tmp20_;
		ValaSemanticAnalyzer* _tmp21_;
		ValaSemanticAnalyzer* _tmp22_;
		ValaDataType* _tmp23_;
		ValaTypeSymbol* _tmp24_;
		ValaTypeSymbol* _tmp25_;
		_tmp17_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_data_type_get_type_symbol (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_code_context_get_analyzer (context);
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp22_->int_type;
		_tmp24_ = vala_data_type_get_type_symbol (_tmp23_);
		_tmp25_ = _tmp24_;
		if (_tmp20_ == _tmp25_) {
		} else {
			result = FALSE;
			return result;
		}
	}
	_tmp26_ = vala_callable_get_parameters ((ValaCallable*) self);
	_tmp27_ = _vala_iterable_ref0 (_tmp26_);
	params = _tmp27_;
	_tmp28_ = params;
	_tmp29_ = vala_collection_get_size ((ValaCollection*) _tmp28_);
	_tmp30_ = _tmp29_;
	if (_tmp30_ == 0) {
		result = TRUE;
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp31_ = params;
	_tmp32_ = vala_collection_get_size ((ValaCollection*) _tmp31_);
	_tmp33_ = _tmp32_;
	if (_tmp33_ > 1) {
		result = FALSE;
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp34_ = params;
	_tmp35_ = vala_iterable_iterator ((ValaIterable*) _tmp34_);
	params_it = _tmp35_;
	_tmp36_ = params_it;
	vala_iterator_next (_tmp36_);
	_tmp37_ = params_it;
	_tmp38_ = vala_iterator_get (_tmp37_);
	param = (ValaParameter*) _tmp38_;
	_tmp39_ = param;
	_tmp40_ = vala_parameter_get_direction (_tmp39_);
	_tmp41_ = _tmp40_;
	if (_tmp41_ == VALA_PARAMETER_DIRECTION_OUT) {
		result = FALSE;
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp42_ = param;
	_tmp43_ = vala_variable_get_variable_type ((ValaVariable*) _tmp42_);
	_tmp44_ = _tmp43_;
	if (!VALA_IS_ARRAY_TYPE (_tmp44_)) {
		result = FALSE;
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp45_ = param;
	_tmp46_ = vala_variable_get_variable_type ((ValaVariable*) _tmp45_);
	_tmp47_ = _tmp46_;
	array_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
	_tmp48_ = array_type;
	_tmp49_ = vala_array_type_get_element_type (_tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_data_type_get_type_symbol (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = vala_code_context_get_analyzer (context);
	_tmp54_ = _tmp53_;
	_tmp55_ = _tmp54_->string_type;
	_tmp56_ = vala_data_type_get_type_symbol (_tmp55_);
	_tmp57_ = _tmp56_;
	if (_tmp52_ != _tmp57_) {
		result = FALSE;
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	result = TRUE;
	_vala_code_node_unref0 (param);
	_vala_iterator_unref0 (params_it);
	_vala_iterable_unref0 (params);
	return result;
}

gint
vala_method_get_required_arguments (ValaMethod* self)
{
	gint n = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	n = 0;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		gint _param_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_param_list = _tmp0_;
		_tmp1_ = _param_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_param_size = _tmp3_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaParameter* param = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			ValaParameter* _tmp9_;
			ValaExpression* _tmp10_;
			ValaExpression* _tmp11_;
			gint _tmp15_;
			_param_index = _param_index + 1;
			_tmp4_ = _param_index;
			_tmp5_ = _param_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _param_list;
			_tmp7_ = vala_list_get (_tmp6_, _param_index);
			param = (ValaParameter*) _tmp7_;
			_tmp9_ = param;
			_tmp10_ = vala_variable_get_initializer ((ValaVariable*) _tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				_tmp8_ = TRUE;
			} else {
				ValaParameter* _tmp12_;
				gboolean _tmp13_;
				gboolean _tmp14_;
				_tmp12_ = param;
				_tmp13_ = vala_parameter_get_ellipsis (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp8_ = _tmp14_;
			}
			if (_tmp8_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp15_ = n;
			n = _tmp15_ + 1;
			_vala_code_node_unref0 (param);
		}
	}
	result = n;
	return result;
}

ValaMethod*
vala_method_get_end_method (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp35_;
	ValaMethod* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = self->priv->end_method;
	if (_tmp1_ == NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaScope* _tmp10_;
		ValaScope* _tmp11_;
		ValaMethod* _tmp34_;
		_tmp2_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_method_new ("end", _tmp3_, _tmp5_, NULL);
		_vala_code_node_unref0 (self->priv->end_method);
		self->priv->end_method = _tmp6_;
		_tmp7_ = self->priv->end_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp7_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp8_ = self->priv->end_method;
		vala_symbol_set_external ((ValaSymbol*) _tmp8_, TRUE);
		_tmp9_ = self->priv->end_method;
		_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp11_ = _tmp10_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp9_, _tmp11_);
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp12_;
			gint _param_size = 0;
			ValaList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _param_index = 0;
			_tmp12_ = vala_method_get_async_end_parameters (self);
			_param_list = _tmp12_;
			_tmp13_ = _param_list;
			_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			_param_size = _tmp15_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp16_;
				gint _tmp17_;
				ValaParameter* param = NULL;
				ValaList* _tmp18_;
				gpointer _tmp19_;
				ValaMethod* _tmp20_;
				ValaParameter* _tmp21_;
				ValaParameter* _tmp22_;
				ValaParameter* _tmp23_;
				_param_index = _param_index + 1;
				_tmp16_ = _param_index;
				_tmp17_ = _param_size;
				if (!(_tmp16_ < _tmp17_)) {
					break;
				}
				_tmp18_ = _param_list;
				_tmp19_ = vala_list_get (_tmp18_, _param_index);
				param = (ValaParameter*) _tmp19_;
				_tmp20_ = self->priv->end_method;
				_tmp21_ = param;
				_tmp22_ = vala_parameter_copy (_tmp21_);
				_tmp23_ = _tmp22_;
				vala_callable_add_parameter ((ValaCallable*) _tmp20_, _tmp23_);
				_vala_code_node_unref0 (_tmp23_);
				_vala_code_node_unref0 (param);
			}
		}
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp24_;
			gint _param_size = 0;
			ValaList* _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			gint _param_index = 0;
			_tmp24_ = vala_method_get_type_parameters (self);
			_param_list = _tmp24_;
			_tmp25_ = _param_list;
			_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
			_tmp27_ = _tmp26_;
			_param_size = _tmp27_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp28_;
				gint _tmp29_;
				ValaTypeParameter* param = NULL;
				ValaList* _tmp30_;
				gpointer _tmp31_;
				ValaMethod* _tmp32_;
				ValaTypeParameter* _tmp33_;
				_param_index = _param_index + 1;
				_tmp28_ = _param_index;
				_tmp29_ = _param_size;
				if (!(_tmp28_ < _tmp29_)) {
					break;
				}
				_tmp30_ = _param_list;
				_tmp31_ = vala_list_get (_tmp30_, _param_index);
				param = (ValaTypeParameter*) _tmp31_;
				_tmp32_ = self->priv->end_method;
				_tmp33_ = param;
				vala_method_add_type_parameter (_tmp32_, _tmp33_);
				_vala_code_node_unref0 (param);
			}
		}
		_tmp34_ = self->priv->end_method;
		vala_code_node_copy_attribute_double ((ValaCodeNode*) _tmp34_, (ValaCodeNode*) self, "CCode", "async_result_pos");
	}
	_tmp35_ = self->priv->end_method;
	result = _tmp35_;
	return result;
}

ValaMethod*
vala_method_get_callback_method (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp21_;
	ValaMethod* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = self->priv->callback_method;
	if (_tmp1_ == NULL) {
		ValaDataType* bool_type = NULL;
		ValaCodeContext* _tmp2_;
		ValaCodeContext* _tmp3_;
		ValaSemanticAnalyzer* _tmp4_;
		ValaSemanticAnalyzer* _tmp5_;
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		ValaDataType* _tmp10_;
		ValaSourceReference* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaMethod* _tmp13_;
		ValaMethod* _tmp14_;
		ValaMethod* _tmp15_;
		ValaMethod* _tmp16_;
		ValaMethod* _tmp17_;
		ValaScope* _tmp18_;
		ValaScope* _tmp19_;
		ValaMethod* _tmp20_;
		_tmp2_ = vala_code_context_get ();
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_context_get_analyzer (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_->bool_type;
		_tmp7_ = vala_data_type_copy (_tmp6_);
		_tmp8_ = _tmp7_;
		_vala_code_context_unref0 (_tmp3_);
		bool_type = _tmp8_;
		_tmp9_ = bool_type;
		vala_data_type_set_value_owned (_tmp9_, TRUE);
		_tmp10_ = bool_type;
		_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_method_new ("callback", _tmp10_, _tmp12_, NULL);
		_vala_code_node_unref0 (self->priv->callback_method);
		self->priv->callback_method = _tmp13_;
		_tmp14_ = self->priv->callback_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp14_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp15_ = self->priv->callback_method;
		vala_symbol_set_external ((ValaSymbol*) _tmp15_, TRUE);
		_tmp16_ = self->priv->callback_method;
		vala_method_set_binding (_tmp16_, VALA_MEMBER_BINDING_INSTANCE);
		_tmp17_ = self->priv->callback_method;
		_tmp18_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp19_ = _tmp18_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp17_, _tmp19_);
		_tmp20_ = self->priv->callback_method;
		vala_method_set_is_async_callback (_tmp20_, TRUE);
		_vala_code_node_unref0 (bool_type);
	}
	_tmp21_ = self->priv->callback_method;
	result = _tmp21_;
	return result;
}

ValaList*
vala_method_get_async_begin_parameters (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaList* _tmp1_;
	GEqualFunc _tmp3_;
	ValaArrayList* _tmp4_;
	ValaSymbol* glib_ns = NULL;
	ValaCodeContext* _tmp5_;
	ValaCodeContext* _tmp6_;
	ValaNamespace* _tmp7_;
	ValaNamespace* _tmp8_;
	ValaScope* _tmp9_;
	ValaScope* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaParameter* ellipsis = NULL;
	ValaDelegateType* callback_type = NULL;
	ValaSymbol* _tmp31_;
	ValaScope* _tmp32_;
	ValaScope* _tmp33_;
	ValaSymbol* _tmp34_;
	ValaDelegate* _tmp35_;
	ValaSourceReference* _tmp36_;
	ValaSourceReference* _tmp37_;
	ValaDelegateType* _tmp38_;
	ValaDelegateType* _tmp39_;
	ValaDelegateType* _tmp40_;
	ValaDelegateType* _tmp41_;
	ValaDelegateType* _tmp42_;
	ValaParameter* callback_param = NULL;
	ValaDelegateType* _tmp43_;
	ValaSourceReference* _tmp44_;
	ValaSourceReference* _tmp45_;
	ValaParameter* _tmp46_;
	ValaParameter* _tmp47_;
	ValaSourceReference* _tmp48_;
	ValaSourceReference* _tmp49_;
	ValaNullLiteral* _tmp50_;
	ValaNullLiteral* _tmp51_;
	ValaParameter* _tmp52_;
	ValaExpression* _tmp53_;
	ValaExpression* _tmp54_;
	ValaDelegateType* _tmp55_;
	ValaDataType* _tmp56_;
	ValaDataType* _tmp57_;
	ValaParameter* _tmp58_;
	ValaParameter* _tmp59_;
	ValaScope* _tmp60_;
	ValaScope* _tmp61_;
	ValaParameter* _tmp62_;
	ValaList* _tmp63_;
	ValaParameter* _tmp64_;
	ValaParameter* _tmp65_;
	ValaList* _tmp68_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = self->priv->async_begin_parameters;
	if (_tmp1_ != NULL) {
		ValaList* _tmp2_;
		_tmp2_ = self->priv->async_begin_parameters;
		result = _tmp2_;
		return result;
	}
	_tmp3_ = g_direct_equal;
	_tmp4_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp3_);
	_vala_iterable_unref0 (self->priv->async_begin_parameters);
	self->priv->async_begin_parameters = (ValaList*) _tmp4_;
	_tmp5_ = vala_code_context_get ();
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_code_context_get_root (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_scope_lookup (_tmp10_, "GLib");
	_tmp12_ = _tmp11_;
	_vala_code_context_unref0 (_tmp6_);
	glib_ns = _tmp12_;
	ellipsis = NULL;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp13_;
		gint _param_size = 0;
		ValaList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _param_index = 0;
		_tmp13_ = self->priv->parameters;
		_param_list = _tmp13_;
		_tmp14_ = _param_list;
		_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_param_size = _tmp16_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			ValaParameter* param = NULL;
			ValaList* _tmp19_;
			gpointer _tmp20_;
			ValaParameter* _tmp21_;
			gboolean _tmp22_;
			gboolean _tmp23_;
			_param_index = _param_index + 1;
			_tmp17_ = _param_index;
			_tmp18_ = _param_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _param_list;
			_tmp20_ = vala_list_get (_tmp19_, _param_index);
			param = (ValaParameter*) _tmp20_;
			_tmp21_ = param;
			_tmp22_ = vala_parameter_get_ellipsis (_tmp21_);
			_tmp23_ = _tmp22_;
			if (_tmp23_) {
				ValaParameter* _tmp24_;
				ValaParameter* _tmp25_;
				_tmp24_ = param;
				_tmp25_ = _vala_code_node_ref0 (_tmp24_);
				_vala_code_node_unref0 (ellipsis);
				ellipsis = _tmp25_;
			} else {
				ValaParameter* _tmp26_;
				ValaParameterDirection _tmp27_;
				ValaParameterDirection _tmp28_;
				_tmp26_ = param;
				_tmp27_ = vala_parameter_get_direction (_tmp26_);
				_tmp28_ = _tmp27_;
				if (_tmp28_ == VALA_PARAMETER_DIRECTION_IN) {
					ValaList* _tmp29_;
					ValaParameter* _tmp30_;
					_tmp29_ = self->priv->async_begin_parameters;
					_tmp30_ = param;
					vala_collection_add ((ValaCollection*) _tmp29_, _tmp30_);
				}
			}
			_vala_code_node_unref0 (param);
		}
	}
	_tmp31_ = glib_ns;
	_tmp32_ = vala_symbol_get_scope (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = vala_scope_lookup (_tmp33_, "AsyncReadyCallback");
	_tmp35_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, VALA_TYPE_DELEGATE, ValaDelegate);
	_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_delegate_type_new (_tmp35_, _tmp37_);
	_tmp39_ = _tmp38_;
	_vala_code_node_unref0 (_tmp35_);
	callback_type = _tmp39_;
	_tmp40_ = callback_type;
	vala_data_type_set_nullable ((ValaDataType*) _tmp40_, TRUE);
	_tmp41_ = callback_type;
	vala_data_type_set_value_owned ((ValaDataType*) _tmp41_, TRUE);
	_tmp42_ = callback_type;
	vala_delegate_type_set_is_called_once (_tmp42_, TRUE);
	_tmp43_ = callback_type;
	_tmp44_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp45_ = _tmp44_;
	_tmp46_ = vala_parameter_new ("_callback_", (ValaDataType*) _tmp43_, _tmp45_);
	callback_param = _tmp46_;
	_tmp47_ = callback_param;
	_tmp48_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp49_ = _tmp48_;
	_tmp50_ = vala_null_literal_new (_tmp49_);
	_tmp51_ = _tmp50_;
	vala_variable_set_initializer ((ValaVariable*) _tmp47_, (ValaExpression*) _tmp51_);
	_vala_code_node_unref0 (_tmp51_);
	_tmp52_ = callback_param;
	_tmp53_ = vala_variable_get_initializer ((ValaVariable*) _tmp52_);
	_tmp54_ = _tmp53_;
	_tmp55_ = callback_type;
	_tmp56_ = vala_data_type_copy ((ValaDataType*) _tmp55_);
	_tmp57_ = _tmp56_;
	vala_expression_set_target_type (_tmp54_, _tmp57_);
	_vala_code_node_unref0 (_tmp57_);
	_tmp58_ = callback_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp58_, "CCode", "pos", (gdouble) -1, NULL);
	_tmp59_ = callback_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp59_, "CCode", "delegate_target_pos", -0.9, NULL);
	_tmp60_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp61_ = _tmp60_;
	_tmp62_ = callback_param;
	vala_scope_add (_tmp61_, NULL, (ValaSymbol*) _tmp62_);
	_tmp63_ = self->priv->async_begin_parameters;
	_tmp64_ = callback_param;
	vala_collection_add ((ValaCollection*) _tmp63_, _tmp64_);
	_tmp65_ = ellipsis;
	if (_tmp65_ != NULL) {
		ValaList* _tmp66_;
		ValaParameter* _tmp67_;
		_tmp66_ = self->priv->async_begin_parameters;
		_tmp67_ = ellipsis;
		vala_collection_add ((ValaCollection*) _tmp66_, _tmp67_);
	}
	_tmp68_ = self->priv->async_begin_parameters;
	result = _tmp68_;
	_vala_code_node_unref0 (callback_param);
	_vala_code_node_unref0 (callback_type);
	_vala_code_node_unref0 (ellipsis);
	_vala_code_node_unref0 (glib_ns);
	return result;
}

ValaList*
vala_method_get_async_end_parameters (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaList* _tmp1_;
	GEqualFunc _tmp3_;
	ValaArrayList* _tmp4_;
	ValaSymbol* glib_ns = NULL;
	ValaCodeContext* _tmp5_;
	ValaCodeContext* _tmp6_;
	ValaNamespace* _tmp7_;
	ValaNamespace* _tmp8_;
	ValaScope* _tmp9_;
	ValaScope* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaObjectType* result_type = NULL;
	ValaSymbol* _tmp13_;
	ValaScope* _tmp14_;
	ValaScope* _tmp15_;
	ValaSymbol* _tmp16_;
	ValaObjectTypeSymbol* _tmp17_;
	ValaObjectType* _tmp18_;
	ValaObjectType* _tmp19_;
	ValaParameter* result_param = NULL;
	ValaObjectType* _tmp20_;
	ValaSourceReference* _tmp21_;
	ValaSourceReference* _tmp22_;
	ValaParameter* _tmp23_;
	ValaParameter* _tmp24_;
	ValaScope* _tmp25_;
	ValaScope* _tmp26_;
	ValaParameter* _tmp27_;
	ValaList* _tmp28_;
	ValaParameter* _tmp29_;
	ValaList* _tmp43_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = self->priv->async_end_parameters;
	if (_tmp1_ != NULL) {
		ValaList* _tmp2_;
		_tmp2_ = self->priv->async_end_parameters;
		result = _tmp2_;
		return result;
	}
	_tmp3_ = g_direct_equal;
	_tmp4_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp3_);
	_vala_iterable_unref0 (self->priv->async_end_parameters);
	self->priv->async_end_parameters = (ValaList*) _tmp4_;
	_tmp5_ = vala_code_context_get ();
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_code_context_get_root (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_scope_lookup (_tmp10_, "GLib");
	_tmp12_ = _tmp11_;
	_vala_code_context_unref0 (_tmp6_);
	glib_ns = _tmp12_;
	_tmp13_ = glib_ns;
	_tmp14_ = vala_symbol_get_scope (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = vala_scope_lookup (_tmp15_, "AsyncResult");
	_tmp17_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol);
	_tmp18_ = vala_object_type_new (_tmp17_, NULL);
	_tmp19_ = _tmp18_;
	_vala_code_node_unref0 (_tmp17_);
	result_type = _tmp19_;
	_tmp20_ = result_type;
	_tmp21_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp22_ = _tmp21_;
	_tmp23_ = vala_parameter_new ("_res_", (ValaDataType*) _tmp20_, _tmp22_);
	result_param = _tmp23_;
	_tmp24_ = result_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp24_, "CCode", "pos", vala_code_node_get_attribute_double ((ValaCodeNode*) self, "CCode", "async_result_pos", 0.1), NULL);
	_tmp25_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp26_ = _tmp25_;
	_tmp27_ = result_param;
	vala_scope_add (_tmp26_, NULL, (ValaSymbol*) _tmp27_);
	_tmp28_ = self->priv->async_end_parameters;
	_tmp29_ = result_param;
	vala_collection_add ((ValaCollection*) _tmp28_, _tmp29_);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp30_;
		gint _param_size = 0;
		ValaList* _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
		gint _param_index = 0;
		_tmp30_ = self->priv->parameters;
		_param_list = _tmp30_;
		_tmp31_ = _param_list;
		_tmp32_ = vala_collection_get_size ((ValaCollection*) _tmp31_);
		_tmp33_ = _tmp32_;
		_param_size = _tmp33_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp34_;
			gint _tmp35_;
			ValaParameter* param = NULL;
			ValaList* _tmp36_;
			gpointer _tmp37_;
			ValaParameter* _tmp38_;
			ValaParameterDirection _tmp39_;
			ValaParameterDirection _tmp40_;
			_param_index = _param_index + 1;
			_tmp34_ = _param_index;
			_tmp35_ = _param_size;
			if (!(_tmp34_ < _tmp35_)) {
				break;
			}
			_tmp36_ = _param_list;
			_tmp37_ = vala_list_get (_tmp36_, _param_index);
			param = (ValaParameter*) _tmp37_;
			_tmp38_ = param;
			_tmp39_ = vala_parameter_get_direction (_tmp38_);
			_tmp40_ = _tmp39_;
			if (_tmp40_ == VALA_PARAMETER_DIRECTION_OUT) {
				ValaList* _tmp41_;
				ValaParameter* _tmp42_;
				_tmp41_ = self->priv->async_end_parameters;
				_tmp42_ = param;
				vala_collection_add ((ValaCollection*) _tmp41_, _tmp42_);
			}
			_vala_code_node_unref0 (param);
		}
	}
	_tmp43_ = self->priv->async_end_parameters;
	result = _tmp43_;
	_vala_code_node_unref0 (result_param);
	_vala_code_node_unref0 (result_type);
	_vala_code_node_unref0 (glib_ns);
	return result;
}

void
vala_method_add_captured_variable (ValaMethod* self,
                                   ValaLocalVariable* local)
{
	gboolean _tmp0_;
	ValaList* _tmp1_;
	ValaList* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (local != NULL);
	_tmp0_ = self->priv->_closure;
	_vala_assert (_tmp0_, "this.closure");
	_tmp1_ = self->priv->captured_variables;
	if (_tmp1_ == NULL) {
		GEqualFunc _tmp2_;
		ValaArrayList* _tmp3_;
		_tmp2_ = g_direct_equal;
		_tmp3_ = vala_array_list_new (VALA_TYPE_LOCAL_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
		_vala_iterable_unref0 (self->priv->captured_variables);
		self->priv->captured_variables = (ValaList*) _tmp3_;
	}
	_tmp4_ = self->priv->captured_variables;
	vala_collection_add ((ValaCollection*) _tmp4_, local);
}

void
vala_method_get_captured_variables (ValaMethod* self,
                                    ValaCollection* variables)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (variables != NULL);
	_tmp0_ = self->priv->captured_variables;
	if (_tmp0_ != NULL) {
		{
			ValaList* _local_list = NULL;
			ValaList* _tmp1_;
			gint _local_size = 0;
			ValaList* _tmp2_;
			gint _tmp3_;
			gint _tmp4_;
			gint _local_index = 0;
			_tmp1_ = self->priv->captured_variables;
			_local_list = _tmp1_;
			_tmp2_ = _local_list;
			_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
			_tmp4_ = _tmp3_;
			_local_size = _tmp4_;
			_local_index = -1;
			while (TRUE) {
				gint _tmp5_;
				gint _tmp6_;
				ValaLocalVariable* local = NULL;
				ValaList* _tmp7_;
				gpointer _tmp8_;
				ValaLocalVariable* _tmp9_;
				_local_index = _local_index + 1;
				_tmp5_ = _local_index;
				_tmp6_ = _local_size;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				_tmp7_ = _local_list;
				_tmp8_ = vala_list_get (_tmp7_, _local_index);
				local = (ValaLocalVariable*) _tmp8_;
				_tmp9_ = local;
				vala_collection_add (variables, _tmp9_);
				_vala_code_node_unref0 (local);
			}
		}
	}
}

static void
vala_method_real_get_defined_variables (ValaCodeNode* base,
                                        ValaCollection* collection)
{
	ValaMethod * self;
	ValaLocalVariable* _tmp0_;
	ValaLocalVariable* _tmp1_;
	ValaLocalVariable* _tmp4_;
	gboolean _tmp6_;
	self = (ValaMethod*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaLocalVariable* _tmp2_;
		ValaLocalVariable* _tmp3_;
		_tmp2_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp3_ = _tmp2_;
		vala_collection_add (collection, (ValaVariable*) _tmp3_);
	}
	_tmp4_ = self->priv->_params_array_var;
	if (_tmp4_ != NULL) {
		ValaLocalVariable* _tmp5_;
		_tmp5_ = self->priv->_params_array_var;
		vala_collection_add (collection, (ValaVariable*) _tmp5_);
	}
	_tmp6_ = self->priv->_closure;
	if (_tmp6_) {
		vala_method_get_captured_variables (self, G_TYPE_CHECK_INSTANCE_CAST (collection, VALA_TYPE_COLLECTION, ValaCollection));
	}
}

gint
vala_method_get_format_arg_index (ValaMethod* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaParameter* _tmp7_;
				gboolean _tmp8_;
				gboolean _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->parameters;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->parameters;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaParameter*) _tmp6_;
				_tmp8_ = vala_parameter_get_format_arg (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = _tmp9_;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp10_) {
					result = i;
					return result;
				}
			}
		}
	}
	result = -1;
	return result;
}

gboolean
vala_method_has_error_type_parameter (ValaMethod* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	ValaMethod* _tmp4_;
	ValaMethod* _tmp5_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	ValaMethod* _tmp12_;
	ValaMethod* _tmp13_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = TRUE;
		return result;
	}
	_tmp4_ = vala_method_get_base_method (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		_tmp6_ = vala_method_get_base_method (self);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_ != self;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		_tmp8_ = vala_method_get_base_method (self);
		_tmp9_ = _tmp8_;
		_tmp2_ = vala_method_has_error_type_parameter (_tmp9_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	_tmp12_ = vala_method_get_base_interface_method (self);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaMethod* _tmp14_;
		ValaMethod* _tmp15_;
		_tmp14_ = vala_method_get_base_interface_method (self);
		_tmp15_ = _tmp14_;
		_tmp11_ = _tmp15_ != self;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		ValaMethod* _tmp16_;
		ValaMethod* _tmp17_;
		_tmp16_ = vala_method_get_base_interface_method (self);
		_tmp17_ = _tmp16_;
		_tmp10_ = vala_method_has_error_type_parameter (_tmp17_);
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static void
vala_method_class_init (ValaMethodClass * klass,
                        gpointer klass_data)
{
	vala_method_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMethod_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_real_accept_children;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_method_real_get_error_types;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_method_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_method_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_method_real_check;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_real_get_defined_variables;
	VALA_SUBROUTINE_CLASS (klass)->get_has_result = (gboolean (*) (ValaSubroutine*)) vala_method_real_get_has_result;
}

static void
vala_method_vala_callable_interface_init (ValaCallableIface * iface,
                                          gpointer iface_data)
{
	vala_method_vala_callable_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_parameter = (void (*) (ValaCallable*, ValaParameter*)) vala_method_real_add_parameter;
	iface->get_parameters = (ValaList* (*) (ValaCallable*)) vala_method_real_get_parameters;
	iface->get_return_type = vala_method_real_get_return_type;
	iface->set_return_type = vala_method_real_set_return_type;
}

static void
vala_method_instance_init (ValaMethod * self,
                           gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_method_get_instance_private (self);
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->parameters = (ValaList*) _tmp1_;
}

static void
vala_method_finalize (ValaCodeNode * obj)
{
	ValaMethod * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD, ValaMethod);
	_vala_iterable_unref0 (self->priv->type_parameters);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	_vala_code_node_unref0 (self->priv->_params_array_var);
	_vala_iterable_unref0 (self->priv->parameters);
	_vala_iterable_unref0 (self->priv->async_begin_parameters);
	_vala_iterable_unref0 (self->priv->async_end_parameters);
	_vala_iterable_unref0 (self->priv->preconditions);
	_vala_iterable_unref0 (self->priv->postconditions);
	_vala_code_node_unref0 (self->priv->_return_type);
	_vala_iterable_unref0 (self->error_types);
	_vala_code_node_unref0 (self->priv->_base_interface_type);
	_vala_code_node_unref0 (self->priv->callback_method);
	_vala_code_node_unref0 (self->priv->end_method);
	_vala_iterable_unref0 (self->priv->captured_variables);
	VALA_CODE_NODE_CLASS (vala_method_parent_class)->finalize (obj);
}

/**
 * Represents a type or namespace method.
 */
static GType
vala_method_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethod), 0, (GInstanceInitFunc) vala_method_instance_init, NULL };
	static const GInterfaceInfo vala_callable_info = { (GInterfaceInitFunc) vala_method_vala_callable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_method_type_id;
	vala_method_type_id = g_type_register_static (VALA_TYPE_SUBROUTINE, "ValaMethod", &g_define_type_info, 0);
	g_type_add_interface_static (vala_method_type_id, VALA_TYPE_CALLABLE, &vala_callable_info);
	ValaMethod_private_offset = g_type_add_instance_private (vala_method_type_id, sizeof (ValaMethodPrivate));
	return vala_method_type_id;
}

GType
vala_method_get_type (void)
{
	static volatile gsize vala_method_type_id__once = 0;
	if (g_once_init_enter (&vala_method_type_id__once)) {
		GType vala_method_type_id;
		vala_method_type_id = vala_method_get_type_once ();
		g_once_init_leave (&vala_method_type_id__once, vala_method_type_id);
	}
	return vala_method_type_id__once;
}

