/* valadynamicsignal.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valadynamicsignal.h>




struct _ValaDynamicSignalPrivate {
	ValaDataType* _dynamic_type;
	ValaExpression* _handler;
};

#define VALA_DYNAMIC_SIGNAL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_DYNAMIC_SIGNAL, ValaDynamicSignalPrivate))
enum  {
	VALA_DYNAMIC_SIGNAL_DUMMY_PROPERTY
};
static gboolean vala_dynamic_signal_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
static gpointer vala_dynamic_signal_parent_class = NULL;
static void vala_dynamic_signal_finalize (ValaCodeNode* obj);



ValaDynamicSignal* vala_dynamic_signal_construct (GType object_type, ValaDataType* dynamic_type, const char* name, ValaDataType* return_type, ValaSourceReference* source_reference) {
	ValaDynamicSignal* self;
	g_return_val_if_fail (dynamic_type != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	self = (ValaDynamicSignal*) vala_signal_construct (object_type, name, return_type, source_reference);
	vala_dynamic_signal_set_dynamic_type (self, dynamic_type);
	return self;
}


ValaDynamicSignal* vala_dynamic_signal_new (ValaDataType* dynamic_type, const char* name, ValaDataType* return_type, ValaSourceReference* source_reference) {
	return vala_dynamic_signal_construct (VALA_TYPE_DYNAMIC_SIGNAL, dynamic_type, name, return_type, source_reference);
}


static gboolean vala_dynamic_signal_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaDynamicSignal * self;
	self = (ValaDynamicSignal*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	return TRUE;
}


ValaDataType* vala_dynamic_signal_get_dynamic_type (ValaDynamicSignal* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_dynamic_type;
}


void vala_dynamic_signal_set_dynamic_type (ValaDynamicSignal* self, ValaDataType* value) {
	ValaDataType* _tmp2;
	ValaDataType* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_dynamic_type = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (self->priv->_dynamic_type == NULL) ? NULL : (self->priv->_dynamic_type = (vala_code_node_unref (self->priv->_dynamic_type), NULL)), _tmp2);
}


ValaExpression* vala_dynamic_signal_get_handler (ValaDynamicSignal* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_handler;
}


void vala_dynamic_signal_set_handler (ValaDynamicSignal* self, ValaExpression* value) {
	ValaExpression* _tmp2;
	ValaExpression* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_handler = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (self->priv->_handler == NULL) ? NULL : (self->priv->_handler = (vala_code_node_unref (self->priv->_handler), NULL)), _tmp2);
}


static void vala_dynamic_signal_class_init (ValaDynamicSignalClass * klass) {
	vala_dynamic_signal_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_dynamic_signal_finalize;
	g_type_class_add_private (klass, sizeof (ValaDynamicSignalPrivate));
	VALA_CODE_NODE_CLASS (klass)->check = vala_dynamic_signal_real_check;
}


static void vala_dynamic_signal_instance_init (ValaDynamicSignal * self) {
	self->priv = VALA_DYNAMIC_SIGNAL_GET_PRIVATE (self);
}


static void vala_dynamic_signal_finalize (ValaCodeNode* obj) {
	ValaDynamicSignal * self;
	self = VALA_DYNAMIC_SIGNAL (obj);
	(self->priv->_dynamic_type == NULL) ? NULL : (self->priv->_dynamic_type = (vala_code_node_unref (self->priv->_dynamic_type), NULL));
	(self->priv->_handler == NULL) ? NULL : (self->priv->_handler = (vala_code_node_unref (self->priv->_handler), NULL));
	VALA_CODE_NODE_CLASS (vala_dynamic_signal_parent_class)->finalize (obj);
}


GType vala_dynamic_signal_get_type (void) {
	static GType vala_dynamic_signal_type_id = 0;
	if (vala_dynamic_signal_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDynamicSignalClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_dynamic_signal_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDynamicSignal), 0, (GInstanceInitFunc) vala_dynamic_signal_instance_init, NULL };
		vala_dynamic_signal_type_id = g_type_register_static (VALA_TYPE_SIGNAL, "ValaDynamicSignal", &g_define_type_info, 0);
	}
	return vala_dynamic_signal_type_id;
}




