/* valaccodememberaccessmodule.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valaccode.h>
#include <gee.h>


#define VALA_TYPE_CCODE_MODULE (vala_ccode_module_get_type ())
#define VALA_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModule))
#define VALA_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))
#define VALA_IS_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MODULE))
#define VALA_IS_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MODULE))
#define VALA_CCODE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))

typedef struct _ValaCCodeModule ValaCCodeModule;
typedef struct _ValaCCodeModuleClass ValaCCodeModuleClass;
typedef struct _ValaCCodeModulePrivate ValaCCodeModulePrivate;

#define VALA_TYPE_CCODE_BASE_MODULE (vala_ccode_base_module_get_type ())
#define VALA_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModule))
#define VALA_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))
#define VALA_IS_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_IS_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_CCODE_BASE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))

typedef struct _ValaCCodeBaseModule ValaCCodeBaseModule;
typedef struct _ValaCCodeBaseModuleClass ValaCCodeBaseModuleClass;
typedef struct _ValaCCodeBaseModulePrivate ValaCCodeBaseModulePrivate;

#define VALA_TYPE_CCODE_DECLARATION_SPACE (vala_ccode_declaration_space_get_type ())
#define VALA_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpace))
#define VALA_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))
#define VALA_IS_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_IS_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_CCODE_DECLARATION_SPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))

typedef struct _ValaCCodeDeclarationSpace ValaCCodeDeclarationSpace;
typedef struct _ValaCCodeDeclarationSpaceClass ValaCCodeDeclarationSpaceClass;

#define VALA_TYPE_CCODE_STRUCT_MODULE (vala_ccode_struct_module_get_type ())
#define VALA_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModule))
#define VALA_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))
#define VALA_IS_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_IS_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_CCODE_STRUCT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))

typedef struct _ValaCCodeStructModule ValaCCodeStructModule;
typedef struct _ValaCCodeStructModuleClass ValaCCodeStructModuleClass;
typedef struct _ValaCCodeStructModulePrivate ValaCCodeStructModulePrivate;

#define VALA_TYPE_CCODE_METHOD_MODULE (vala_ccode_method_module_get_type ())
#define VALA_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModule))
#define VALA_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))
#define VALA_IS_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_IS_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_CCODE_METHOD_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))

typedef struct _ValaCCodeMethodModule ValaCCodeMethodModule;
typedef struct _ValaCCodeMethodModuleClass ValaCCodeMethodModuleClass;
typedef struct _ValaCCodeMethodModulePrivate ValaCCodeMethodModulePrivate;

#define VALA_TYPE_CCODE_CONTROL_FLOW_MODULE (vala_ccode_control_flow_module_get_type ())
#define VALA_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModule))
#define VALA_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_CCODE_CONTROL_FLOW_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))

typedef struct _ValaCCodeControlFlowModule ValaCCodeControlFlowModule;
typedef struct _ValaCCodeControlFlowModuleClass ValaCCodeControlFlowModuleClass;
typedef struct _ValaCCodeControlFlowModulePrivate ValaCCodeControlFlowModulePrivate;

#define VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE (vala_ccode_member_access_module_get_type ())
#define VALA_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModule))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))

typedef struct _ValaCCodeMemberAccessModule ValaCCodeMemberAccessModule;
typedef struct _ValaCCodeMemberAccessModuleClass ValaCCodeMemberAccessModuleClass;
typedef struct _ValaCCodeMemberAccessModulePrivate ValaCCodeMemberAccessModulePrivate;

#define VALA_TYPE_CCODE_GENERATOR (vala_ccode_generator_get_type ())
#define VALA_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGenerator))
#define VALA_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))
#define VALA_IS_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_GENERATOR))
#define VALA_IS_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_GENERATOR))
#define VALA_CCODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))

typedef struct _ValaCCodeGenerator ValaCCodeGenerator;
typedef struct _ValaCCodeGeneratorClass ValaCCodeGeneratorClass;

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeModule {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeModulePrivate * priv;
};

struct _ValaCCodeModuleClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeModule *self);
	void (*emit) (ValaCCodeModule* self, ValaCodeContext* context);
	void (*visit_source_file) (ValaCCodeModule* self, ValaSourceFile* source_file);
	void (*visit_class) (ValaCCodeModule* self, ValaClass* cl);
	void (*visit_interface) (ValaCCodeModule* self, ValaInterface* iface);
	void (*visit_struct) (ValaCCodeModule* self, ValaStruct* st);
	void (*visit_enum) (ValaCCodeModule* self, ValaEnum* en);
	void (*visit_error_domain) (ValaCCodeModule* self, ValaErrorDomain* edomain);
	void (*visit_delegate) (ValaCCodeModule* self, ValaDelegate* d);
	void (*visit_member) (ValaCCodeModule* self, ValaMember* m);
	void (*visit_constant) (ValaCCodeModule* self, ValaConstant* c);
	void (*visit_field) (ValaCCodeModule* self, ValaField* f);
	void (*visit_method) (ValaCCodeModule* self, ValaMethod* m);
	void (*visit_creation_method) (ValaCCodeModule* self, ValaCreationMethod* m);
	void (*visit_formal_parameter) (ValaCCodeModule* self, ValaFormalParameter* p);
	void (*visit_property) (ValaCCodeModule* self, ValaProperty* prop);
	void (*visit_property_accessor) (ValaCCodeModule* self, ValaPropertyAccessor* acc);
	void (*visit_signal) (ValaCCodeModule* self, ValaSignal* sig);
	void (*visit_constructor) (ValaCCodeModule* self, ValaConstructor* c);
	void (*visit_destructor) (ValaCCodeModule* self, ValaDestructor* d);
	void (*visit_block) (ValaCCodeModule* self, ValaBlock* b);
	void (*visit_empty_statement) (ValaCCodeModule* self, ValaEmptyStatement* stmt);
	void (*visit_declaration_statement) (ValaCCodeModule* self, ValaDeclarationStatement* stmt);
	void (*visit_local_variable) (ValaCCodeModule* self, ValaLocalVariable* local);
	void (*visit_initializer_list) (ValaCCodeModule* self, ValaInitializerList* list);
	void (*visit_end_full_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_expression_statement) (ValaCCodeModule* self, ValaExpressionStatement* stmt);
	void (*visit_if_statement) (ValaCCodeModule* self, ValaIfStatement* stmt);
	void (*visit_switch_statement) (ValaCCodeModule* self, ValaSwitchStatement* stmt);
	void (*visit_switch_section) (ValaCCodeModule* self, ValaSwitchSection* section);
	void (*visit_switch_label) (ValaCCodeModule* self, ValaSwitchLabel* label);
	void (*visit_while_statement) (ValaCCodeModule* self, ValaWhileStatement* stmt);
	void (*visit_do_statement) (ValaCCodeModule* self, ValaDoStatement* stmt);
	void (*visit_for_statement) (ValaCCodeModule* self, ValaForStatement* stmt);
	void (*visit_foreach_statement) (ValaCCodeModule* self, ValaForeachStatement* stmt);
	void (*visit_break_statement) (ValaCCodeModule* self, ValaBreakStatement* stmt);
	void (*visit_continue_statement) (ValaCCodeModule* self, ValaContinueStatement* stmt);
	void (*visit_return_statement) (ValaCCodeModule* self, ValaReturnStatement* stmt);
	void (*visit_yield_statement) (ValaCCodeModule* self, ValaYieldStatement* stmt);
	void (*visit_throw_statement) (ValaCCodeModule* self, ValaThrowStatement* stmt);
	void (*visit_try_statement) (ValaCCodeModule* self, ValaTryStatement* stmt);
	void (*visit_catch_clause) (ValaCCodeModule* self, ValaCatchClause* clause);
	void (*visit_lock_statement) (ValaCCodeModule* self, ValaLockStatement* stmt);
	void (*visit_delete_statement) (ValaCCodeModule* self, ValaDeleteStatement* stmt);
	void (*visit_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_array_creation_expression) (ValaCCodeModule* self, ValaArrayCreationExpression* expr);
	void (*visit_boolean_literal) (ValaCCodeModule* self, ValaBooleanLiteral* expr);
	void (*visit_character_literal) (ValaCCodeModule* self, ValaCharacterLiteral* expr);
	void (*visit_integer_literal) (ValaCCodeModule* self, ValaIntegerLiteral* expr);
	void (*visit_real_literal) (ValaCCodeModule* self, ValaRealLiteral* expr);
	void (*visit_string_literal) (ValaCCodeModule* self, ValaStringLiteral* expr);
	void (*visit_null_literal) (ValaCCodeModule* self, ValaNullLiteral* expr);
	void (*visit_member_access) (ValaCCodeModule* self, ValaMemberAccess* expr);
	void (*visit_method_call) (ValaCCodeModule* self, ValaMethodCall* expr);
	void (*visit_element_access) (ValaCCodeModule* self, ValaElementAccess* expr);
	void (*visit_base_access) (ValaCCodeModule* self, ValaBaseAccess* expr);
	void (*visit_postfix_expression) (ValaCCodeModule* self, ValaPostfixExpression* expr);
	void (*visit_object_creation_expression) (ValaCCodeModule* self, ValaObjectCreationExpression* expr);
	void (*visit_sizeof_expression) (ValaCCodeModule* self, ValaSizeofExpression* expr);
	void (*visit_typeof_expression) (ValaCCodeModule* self, ValaTypeofExpression* expr);
	void (*visit_unary_expression) (ValaCCodeModule* self, ValaUnaryExpression* expr);
	void (*visit_cast_expression) (ValaCCodeModule* self, ValaCastExpression* expr);
	void (*visit_pointer_indirection) (ValaCCodeModule* self, ValaPointerIndirection* expr);
	void (*visit_addressof_expression) (ValaCCodeModule* self, ValaAddressofExpression* expr);
	void (*visit_reference_transfer_expression) (ValaCCodeModule* self, ValaReferenceTransferExpression* expr);
	void (*visit_binary_expression) (ValaCCodeModule* self, ValaBinaryExpression* expr);
	void (*visit_type_check) (ValaCCodeModule* self, ValaTypeCheck* expr);
	void (*visit_lambda_expression) (ValaCCodeModule* self, ValaLambdaExpression* l);
	void (*visit_assignment) (ValaCCodeModule* self, ValaAssignment* a);
	char* (*get_custom_creturn_type) (ValaCCodeModule* self, ValaMethod* m);
	void (*generate_dynamic_method_wrapper) (ValaCCodeModule* self, ValaDynamicMethod* method);
	gboolean (*method_has_wrapper) (ValaCCodeModule* self, ValaMethod* method);
	ValaCCodeIdentifier* (*get_value_setter_function) (ValaCCodeModule* self, ValaDataType* type_reference);
	ValaCCodeExpression* (*get_construct_property_assignment) (ValaCCodeModule* self, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value);
	ValaCCodeFunctionCall* (*get_param_spec) (ValaCCodeModule* self, ValaProperty* prop);
	ValaCCodeFunctionCall* (*get_signal_creation) (ValaCCodeModule* self, ValaSignal* sig, ValaTypeSymbol* type);
	ValaCCodeFragment* (*register_dbus_info) (ValaCCodeModule* self, ValaObjectTypeSymbol* bindable);
	char* (*get_dynamic_property_getter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_property_setter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_signal_cname) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_connect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_disconnect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	void (*generate_marshaller) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, gboolean dbus);
	char* (*get_marshaller_function) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, const char* prefix, gboolean dbus);
	char* (*get_array_length_cname) (ValaCCodeModule* self, const char* array_cname, gint dim);
	ValaCCodeExpression* (*get_array_length_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
	char* (*get_array_size_cname) (ValaCCodeModule* self, const char* array_cname);
	ValaCCodeExpression* (*get_array_size_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr);
	void (*add_simple_check) (ValaCCodeModule* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
};

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeBaseModule {
	ValaCCodeModule parent_instance;
	ValaCCodeBaseModulePrivate * priv;
	ValaSymbol* root_symbol;
	ValaSymbol* current_symbol;
	ValaTypeSymbol* current_type_symbol;
	ValaClass* current_class;
	ValaMethod* current_method;
	ValaDataType* current_return_type;
	ValaTryStatement* current_try;
	ValaPropertyAccessor* current_property_accessor;
	ValaCCodeDeclarationSpace* header_declarations;
	ValaCCodeDeclarationSpace* internal_header_declarations;
	ValaCCodeDeclarationSpace* source_declarations;
	ValaCCodeFragment* source_signal_marshaller_declaration;
	ValaCCodeFragment* source_type_member_definition;
	ValaCCodeFragment* class_init_fragment;
	ValaCCodeFragment* base_init_fragment;
	ValaCCodeFragment* class_finalize_fragment;
	ValaCCodeFragment* base_finalize_fragment;
	ValaCCodeFragment* instance_init_fragment;
	ValaCCodeFragment* instance_finalize_fragment;
	ValaCCodeFragment* source_signal_marshaller_definition;
	ValaCCodeFragment* module_init_fragment;
	ValaCCodeStruct* param_spec_struct;
	ValaCCodeStruct* closure_struct;
	ValaCCodeEnum* prop_enum;
	ValaCCodeFunction* function;
	ValaCCodeFragment* pre_statement_fragment;
	GeeArrayList* temp_vars;
	GeeArrayList* temp_ref_vars;
	GeeSet* user_marshal_set;
	GeeSet* predefined_marshal_set;
	GeeSet* c_keywords;
	gint next_temp_var_id;
	gboolean in_creation_method;
	gboolean in_constructor;
	gboolean in_static_or_class_ctor;
	gboolean current_method_inner_error;
	gint next_coroutine_state;
	ValaDataType* bool_type;
	ValaDataType* char_type;
	ValaDataType* uchar_type;
	ValaDataType* unichar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* int8_type;
	ValaDataType* uint8_type;
	ValaDataType* int16_type;
	ValaDataType* uint16_type;
	ValaDataType* int32_type;
	ValaDataType* uint32_type;
	ValaDataType* int64_type;
	ValaDataType* uint64_type;
	ValaDataType* string_type;
	ValaDataType* float_type;
	ValaDataType* double_type;
	ValaTypeSymbol* gtype_type;
	ValaTypeSymbol* gobject_type;
	ValaErrorType* gerror_type;
	ValaClass* glist_type;
	ValaClass* gslist_type;
	ValaTypeSymbol* gstringbuilder_type;
	ValaTypeSymbol* garray_type;
	ValaTypeSymbol* gbytearray_type;
	ValaTypeSymbol* gptrarray_type;
	ValaDataType* gquark_type;
	ValaStruct* gvalue_type;
	ValaStruct* mutex_type;
	ValaTypeSymbol* type_module_type;
	ValaTypeSymbol* dbus_object_type;
	gboolean in_plugin;
	char* module_init_param_name;
	gboolean string_h_needed;
	gboolean gvaluecollector_h_needed;
	gboolean gio_h_needed;
	gboolean requires_array_free;
	gboolean requires_array_move;
	gboolean requires_array_length;
	gboolean requires_strcmp0;
	gboolean dbus_glib_h_needed;
	gboolean dbus_glib_h_needed_in_header;
	GeeSet* wrappers;
	GeeMap* variable_name_map;
};

struct _ValaCCodeBaseModuleClass {
	ValaCCodeModuleClass parent_class;
	void (*append_vala_array_free) (ValaCCodeBaseModule* self);
	void (*append_vala_array_move) (ValaCCodeBaseModule* self);
	void (*append_vala_array_length) (ValaCCodeBaseModule* self);
	void (*generate_class_struct_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_struct_declaration) (ValaCCodeBaseModule* self, ValaStruct* st, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_delegate_declaration) (ValaCCodeBaseModule* self, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_cparameters) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
	ValaCCodeExpression* (*get_dup_func_expression) (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference);
	char* (*get_delegate_target_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_delegate_target_cexpression) (ValaCCodeBaseModule* self, ValaExpression* delegate_expr);
	char* (*get_delegate_target_destroy_notify_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	void (*generate_class_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_interface_declaration) (ValaCCodeBaseModule* self, ValaInterface* iface, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_method_declaration) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_error_domain_declaration) (ValaCCodeBaseModule* self, ValaErrorDomain* edomain, ValaCCodeDeclarationSpace* decl_space);
	ValaCCodeExpression* (*get_implicit_cast_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
};

struct _ValaCCodeStructModule {
	ValaCCodeBaseModule parent_instance;
	ValaCCodeStructModulePrivate * priv;
};

struct _ValaCCodeStructModuleClass {
	ValaCCodeBaseModuleClass parent_class;
};

/**
 * The link between a method and generated code.
 */
struct _ValaCCodeMethodModule {
	ValaCCodeStructModule parent_instance;
	ValaCCodeMethodModulePrivate * priv;
};

struct _ValaCCodeMethodModuleClass {
	ValaCCodeStructModuleClass parent_class;
	void (*generate_method_result_declaration) (ValaCCodeMethodModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeFunction* cfunc, GeeMap* cparam_map, GeeMap* carg_map);
	void (*generate_parameter) (ValaCCodeMethodModule* self, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map);
};

struct _ValaCCodeControlFlowModule {
	ValaCCodeMethodModule parent_instance;
	ValaCCodeControlFlowModulePrivate * priv;
};

struct _ValaCCodeControlFlowModuleClass {
	ValaCCodeMethodModuleClass parent_class;
};

struct _ValaCCodeMemberAccessModule {
	ValaCCodeControlFlowModule parent_instance;
	ValaCCodeMemberAccessModulePrivate * priv;
};

struct _ValaCCodeMemberAccessModuleClass {
	ValaCCodeControlFlowModuleClass parent_class;
};



gpointer vala_ccode_module_ref (gpointer instance);
void vala_ccode_module_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_module (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_module (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_module (const GValue* value);
GType vala_ccode_module_get_type (void);
GType vala_ccode_base_module_get_type (void);
gpointer vala_ccode_declaration_space_ref (gpointer instance);
void vala_ccode_declaration_space_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_declaration_space (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_declaration_space (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_declaration_space (const GValue* value);
GType vala_ccode_declaration_space_get_type (void);
GType vala_ccode_struct_module_get_type (void);
GType vala_ccode_method_module_get_type (void);
GType vala_ccode_control_flow_module_get_type (void);
GType vala_ccode_member_access_module_get_type (void);
enum  {
	VALA_CCODE_MEMBER_ACCESS_MODULE_DUMMY_PROPERTY
};
GType vala_ccode_generator_get_type (void);
ValaCCodeControlFlowModule* vala_ccode_control_flow_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeControlFlowModule* vala_ccode_control_flow_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeMemberAccessModule* vala_ccode_member_access_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeMemberAccessModule* vala_ccode_member_access_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeMemberAccessModule* vala_ccode_member_access_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeGenerator* vala_ccode_module_get_codegen (ValaCCodeModule* self);
void vala_ccode_base_module_generate_method_declaration (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space);
gboolean vala_ccode_base_module_add_generated_external_symbol (ValaCCodeBaseModule* self, ValaSymbol* external_symbol);
void vala_ccode_module_visit_method (ValaCCodeModule* self, ValaMethod* m);
ValaCCodeModule* vala_ccode_module_get_head (ValaCCodeModule* self);
gboolean vala_ccode_module_method_has_wrapper (ValaCCodeModule* self, ValaMethod* method);
ValaLocalVariable* vala_ccode_base_module_get_temp_variable (ValaCCodeBaseModule* self, ValaDataType* type, gboolean value_owned, ValaCodeNode* node_reference);
ValaCCodeExpression* vala_ccode_module_get_array_length_cexpression (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
ValaDataType* vala_ccode_base_module_get_data_type_for_symbol (ValaTypeSymbol* sym);
void vala_ccode_base_module_generate_class_struct_declaration (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
void vala_ccode_base_module_generate_constant_declaration (ValaCCodeBaseModule* self, ValaConstant* c, ValaCCodeDeclarationSpace* decl_space);
void vala_ccode_base_module_generate_property_accessor_declaration (ValaCCodeBaseModule* self, ValaPropertyAccessor* acc, ValaCCodeDeclarationSpace* decl_space);
void vala_ccode_module_visit_property (ValaCCodeModule* self, ValaProperty* prop);
char* vala_ccode_module_get_dynamic_property_getter_cname (ValaCCodeModule* self, ValaDynamicProperty* node);
gboolean vala_ccode_base_module_requires_copy (ValaCCodeBaseModule* self, ValaDataType* type);
void vala_ccode_base_module_generate_enum_declaration (ValaCCodeBaseModule* self, ValaEnum* en, ValaCCodeDeclarationSpace* decl_space);
ValaCCodeExpression* vala_ccode_base_module_get_variable_cexpression (ValaCCodeBaseModule* self, const char* name);
static void vala_ccode_member_access_module_real_visit_member_access (ValaCCodeModule* base, ValaMemberAccess* expr);
static gpointer vala_ccode_member_access_module_parent_class = NULL;
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaCCodeMemberAccessModule* vala_ccode_member_access_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeMemberAccessModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaCCodeMemberAccessModule*) vala_ccode_control_flow_module_construct (object_type, codegen, next);
	return self;
}


ValaCCodeMemberAccessModule* vala_ccode_member_access_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_member_access_module_construct (VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, codegen, next);
}


static void vala_ccode_member_access_module_real_visit_member_access (ValaCCodeModule* base, ValaMemberAccess* expr) {
	ValaCCodeMemberAccessModule * self;
	ValaCCodeExpression* pub_inst;
	ValaDataType* base_type;
	self = (ValaCCodeMemberAccessModule*) base;
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	pub_inst = NULL;
	base_type = NULL;
	if (vala_member_access_get_inner (expr) != NULL) {
		ValaCCodeExpression* _tmp1;
		ValaCCodeExpression* _tmp0;
		_tmp1 = NULL;
		_tmp0 = NULL;
		pub_inst = (_tmp1 = (_tmp0 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (expr))), (_tmp0 == NULL) ? NULL : vala_ccode_node_ref (_tmp0)), (pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL)), _tmp1);
		if (vala_expression_get_value_type (vala_member_access_get_inner (expr)) != NULL) {
			ValaDataType* _tmp3;
			ValaDataType* _tmp2;
			_tmp3 = NULL;
			_tmp2 = NULL;
			base_type = (_tmp3 = (_tmp2 = vala_expression_get_value_type (vala_member_access_get_inner (expr)), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2)), (base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)), _tmp3);
		}
	}
	if (VALA_IS_METHOD (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
		ValaMethod* _tmp4;
		ValaMethod* m;
		gboolean _tmp5;
		gboolean _tmp6;
		_tmp4 = NULL;
		m = (_tmp4 = VALA_METHOD (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp4 == NULL) ? NULL : vala_code_node_ref (_tmp4));
		_tmp5 = FALSE;
		_tmp6 = FALSE;
		if (VALA_IS_DYNAMIC_METHOD (m)) {
			_tmp6 = TRUE;
		} else {
			_tmp6 = VALA_IS_ARRAY_MOVE_METHOD (m);
		}
		if (_tmp6) {
			_tmp5 = TRUE;
		} else {
			_tmp5 = VALA_IS_ARRAY_RESIZE_METHOD (m);
		}
		if (!_tmp5) {
			gboolean _tmp7;
			vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, m, ((ValaCCodeBaseModule*) self)->source_declarations);
			_tmp7 = FALSE;
			if (!vala_symbol_get_external ((ValaSymbol*) m)) {
				_tmp7 = vala_symbol_get_external_package ((ValaSymbol*) m);
			} else {
				_tmp7 = FALSE;
			}
			if (_tmp7) {
				/* internal VAPI methods
				 only add them once per source file*/
				if (vala_ccode_base_module_add_generated_external_symbol ((ValaCCodeBaseModule*) self, (ValaSymbol*) m)) {
					vala_ccode_module_visit_method ((ValaCCodeModule*) self, m);
				}
			}
		}
		if (VALA_IS_BASE_ACCESS (vala_member_access_get_inner (expr))) {
			if (vala_method_get_base_method (m) != NULL) {
				ValaClass* _tmp8;
				ValaClass* base_class;
				ValaCCodeIdentifier* _tmp11;
				char* _tmp10;
				char* _tmp9;
				ValaCCodeFunctionCall* _tmp12;
				ValaCCodeFunctionCall* vcast;
				ValaCCodeIdentifier* _tmp15;
				char* _tmp14;
				char* _tmp13;
				ValaCCodeMemberAccess* _tmp16;
				_tmp8 = NULL;
				base_class = (_tmp8 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_method_get_base_method (m))), (_tmp8 == NULL) ? NULL : vala_code_node_ref (_tmp8));
				_tmp11 = NULL;
				_tmp10 = NULL;
				_tmp9 = NULL;
				_tmp12 = NULL;
				vcast = (_tmp12 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp11 = vala_ccode_identifier_new (_tmp10 = g_strdup_printf ("%s_CLASS", _tmp9 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) base_class, NULL))))), (_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL)), _tmp10 = (g_free (_tmp10), NULL), _tmp9 = (g_free (_tmp9), NULL), _tmp12);
				_tmp15 = NULL;
				_tmp14 = NULL;
				_tmp13 = NULL;
				vala_ccode_function_call_add_argument (vcast, (ValaCCodeExpression*) (_tmp15 = vala_ccode_identifier_new (_tmp14 = g_strdup_printf ("%s_parent_class", _tmp13 = vala_symbol_get_lower_case_cname ((ValaSymbol*) ((ValaCCodeBaseModule*) self)->current_class, NULL)))));
				(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
				_tmp14 = (g_free (_tmp14), NULL);
				_tmp13 = (g_free (_tmp13), NULL);
				_tmp16 = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp16 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) vcast, vala_method_get_vfunc_name (m))));
				(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
				(base_class == NULL) ? NULL : (base_class = (vala_code_node_unref (base_class), NULL));
				(vcast == NULL) ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL));
				(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
				(pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL));
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
				return;
			} else {
				if (vala_method_get_base_interface_method (m) != NULL) {
					ValaInterface* _tmp17;
					ValaInterface* base_iface;
					char* _tmp19;
					char* _tmp18;
					char* _tmp20;
					char* parent_iface_var;
					ValaCCodeMemberAccess* _tmp22;
					ValaCCodeIdentifier* _tmp21;
					_tmp17 = NULL;
					base_iface = (_tmp17 = VALA_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_method_get_base_interface_method (m))), (_tmp17 == NULL) ? NULL : vala_code_node_ref (_tmp17));
					_tmp19 = NULL;
					_tmp18 = NULL;
					_tmp20 = NULL;
					parent_iface_var = (_tmp20 = g_strdup_printf ("%s_%s_parent_iface", _tmp18 = vala_symbol_get_lower_case_cname ((ValaSymbol*) ((ValaCCodeBaseModule*) self)->current_class, NULL), _tmp19 = vala_symbol_get_lower_case_cname ((ValaSymbol*) base_iface, NULL)), _tmp19 = (g_free (_tmp19), NULL), _tmp18 = (g_free (_tmp18), NULL), _tmp20);
					_tmp22 = NULL;
					_tmp21 = NULL;
					vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp22 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp21 = vala_ccode_identifier_new (parent_iface_var)), vala_method_get_vfunc_name (m))));
					(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
					(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
					(base_iface == NULL) ? NULL : (base_iface = (vala_code_node_unref (base_iface), NULL));
					parent_iface_var = (g_free (parent_iface_var), NULL);
					(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
					(pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL));
					(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
					return;
				}
			}
		}
		if (vala_method_get_base_method (m) != NULL) {
			if (!vala_ccode_module_method_has_wrapper (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_method_get_base_method (m))) {
				ValaCCodeExpression* _tmp23;
				ValaCCodeExpression* inst;
				gboolean _tmp24;
				ValaClass* _tmp26;
				ValaClass* base_class;
				ValaCCodeIdentifier* _tmp29;
				char* _tmp28;
				char* _tmp27;
				ValaCCodeFunctionCall* _tmp30;
				ValaCCodeFunctionCall* vclass;
				ValaCCodeMemberAccess* _tmp31;
				_tmp23 = NULL;
				inst = (_tmp23 = pub_inst, (_tmp23 == NULL) ? NULL : vala_ccode_node_ref (_tmp23));
				_tmp24 = FALSE;
				if (vala_member_access_get_inner (expr) != NULL) {
					_tmp24 = !vala_expression_is_pure (vala_member_access_get_inner (expr));
				} else {
					_tmp24 = FALSE;
				}
				if (_tmp24) {
					ValaLocalVariable* temp_var;
					ValaCCodeIdentifier* ctemp;
					ValaCCodeExpression* _tmp25;
					/* instance expression has side-effects
					 store in temp. variable*/
					temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (vala_member_access_get_inner (expr)), TRUE, NULL);
					gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
					ctemp = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var));
					_tmp25 = NULL;
					inst = (_tmp25 = (ValaCCodeExpression*) vala_ccode_assignment_new ((ValaCCodeExpression*) ctemp, pub_inst, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp25);
					vala_code_node_set_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (expr), (ValaCCodeNode*) ctemp);
					(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
					(ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL));
				}
				_tmp26 = NULL;
				base_class = (_tmp26 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_method_get_base_method (m))), (_tmp26 == NULL) ? NULL : vala_code_node_ref (_tmp26));
				_tmp29 = NULL;
				_tmp28 = NULL;
				_tmp27 = NULL;
				_tmp30 = NULL;
				vclass = (_tmp30 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp29 = vala_ccode_identifier_new (_tmp28 = g_strdup_printf ("%s_GET_CLASS", _tmp27 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) base_class, NULL))))), (_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL)), _tmp28 = (g_free (_tmp28), NULL), _tmp27 = (g_free (_tmp27), NULL), _tmp30);
				vala_ccode_function_call_add_argument (vclass, inst);
				_tmp31 = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp31 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) vclass, vala_symbol_get_name ((ValaSymbol*) m))));
				(_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL));
				(inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL));
				(base_class == NULL) ? NULL : (base_class = (vala_code_node_unref (base_class), NULL));
				(vclass == NULL) ? NULL : (vclass = (vala_ccode_node_unref (vclass), NULL));
			} else {
				ValaCCodeIdentifier* _tmp33;
				char* _tmp32;
				_tmp33 = NULL;
				_tmp32 = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp33 = vala_ccode_identifier_new (_tmp32 = vala_method_get_cname (vala_method_get_base_method (m)))));
				(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
				_tmp32 = (g_free (_tmp32), NULL);
			}
		} else {
			if (vala_method_get_base_interface_method (m) != NULL) {
				ValaCCodeIdentifier* _tmp35;
				char* _tmp34;
				_tmp35 = NULL;
				_tmp34 = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp35 = vala_ccode_identifier_new (_tmp34 = vala_method_get_cname (vala_method_get_base_interface_method (m)))));
				(_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL));
				_tmp34 = (g_free (_tmp34), NULL);
			} else {
				if (VALA_IS_CREATION_METHOD (m)) {
					ValaCCodeIdentifier* _tmp37;
					char* _tmp36;
					_tmp37 = NULL;
					_tmp36 = NULL;
					vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp37 = vala_ccode_identifier_new (_tmp36 = vala_method_get_real_cname (m))));
					(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
					_tmp36 = (g_free (_tmp36), NULL);
				} else {
					ValaCCodeIdentifier* _tmp39;
					char* _tmp38;
					_tmp39 = NULL;
					_tmp38 = NULL;
					vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp39 = vala_ccode_identifier_new (_tmp38 = vala_method_get_cname (m))));
					(_tmp39 == NULL) ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL));
					_tmp38 = (g_free (_tmp38), NULL);
				}
			}
		}
		(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
	} else {
		if (VALA_IS_ARRAY_LENGTH_FIELD (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
			ValaCCodeExpression* _tmp40;
			_tmp40 = NULL;
			vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp40 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_member_access_get_inner (expr), 1)));
			(_tmp40 == NULL) ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL));
		} else {
			if (VALA_IS_FIELD (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
				ValaField* _tmp41;
				ValaField* f;
				_tmp41 = NULL;
				f = (_tmp41 = VALA_FIELD (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp41 == NULL) ? NULL : vala_code_node_ref (_tmp41));
				if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
					ValaDataType* instance_target_type;
					ValaClass* _tmp43;
					ValaTypeSymbol* _tmp42;
					ValaClass* cl;
					gboolean _tmp44;
					gboolean is_gtypeinstance;
					ValaCCodeExpression* inst;
					gboolean _tmp46;
					gboolean _tmp50;
					instance_target_type = vala_ccode_base_module_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) f)));
					_tmp43 = NULL;
					_tmp42 = NULL;
					cl = (_tmp43 = (_tmp42 = vala_data_type_get_data_type (instance_target_type), VALA_IS_CLASS (_tmp42) ? ((ValaClass*) _tmp42) : NULL), (_tmp43 == NULL) ? NULL : vala_code_node_ref (_tmp43));
					_tmp44 = FALSE;
					if (vala_data_type_get_data_type (instance_target_type) == VALA_TYPESYMBOL (cl)) {
						gboolean _tmp45;
						_tmp45 = FALSE;
						if (cl == NULL) {
							_tmp45 = TRUE;
						} else {
							_tmp45 = !vala_class_get_is_compact (cl);
						}
						_tmp44 = _tmp45;
					} else {
						_tmp44 = FALSE;
					}
					is_gtypeinstance = _tmp44;
					inst = NULL;
					_tmp46 = FALSE;
					if (is_gtypeinstance) {
						_tmp46 = vala_symbol_get_access ((ValaSymbol*) f) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
					} else {
						_tmp46 = FALSE;
					}
					if (_tmp46) {
						ValaCCodeExpression* _tmp47;
						_tmp47 = NULL;
						inst = (_tmp47 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (pub_inst, "priv"), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp47);
					} else {
						ValaCCodeExpression* _tmp49;
						ValaCCodeExpression* _tmp48;
						if (cl != NULL) {
							vala_ccode_base_module_generate_class_struct_declaration ((ValaCCodeBaseModule*) self, cl, ((ValaCCodeBaseModule*) self)->source_declarations);
						}
						_tmp49 = NULL;
						_tmp48 = NULL;
						inst = (_tmp49 = (_tmp48 = pub_inst, (_tmp48 == NULL) ? NULL : vala_ccode_node_ref (_tmp48)), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp49);
					}
					_tmp50 = FALSE;
					if (vala_typesymbol_is_reference_type (vala_data_type_get_data_type (instance_target_type))) {
						_tmp50 = TRUE;
					} else {
						gboolean _tmp51;
						_tmp51 = FALSE;
						if (vala_member_access_get_inner (expr) != NULL) {
							_tmp51 = VALA_IS_POINTER_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (expr)));
						} else {
							_tmp51 = FALSE;
						}
						_tmp50 = _tmp51;
					}
					if (_tmp50) {
						ValaCCodeMemberAccess* _tmp53;
						char* _tmp52;
						_tmp53 = NULL;
						_tmp52 = NULL;
						vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp53 = vala_ccode_member_access_new_pointer (inst, _tmp52 = vala_field_get_cname (f))));
						(_tmp53 == NULL) ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL));
						_tmp52 = (g_free (_tmp52), NULL);
					} else {
						ValaCCodeMemberAccess* _tmp55;
						char* _tmp54;
						_tmp55 = NULL;
						_tmp54 = NULL;
						vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp55 = vala_ccode_member_access_new (inst, _tmp54 = vala_field_get_cname (f), FALSE)));
						(_tmp55 == NULL) ? NULL : (_tmp55 = (vala_ccode_node_unref (_tmp55), NULL));
						_tmp54 = (g_free (_tmp54), NULL);
					}
					(instance_target_type == NULL) ? NULL : (instance_target_type = (vala_code_node_unref (instance_target_type), NULL));
					(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
					(inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL));
				} else {
					if (vala_field_get_binding (f) == MEMBER_BINDING_CLASS) {
						ValaClass* _tmp56;
						ValaClass* cl;
						ValaCCodeIdentifier* _tmp59;
						char* _tmp58;
						char* _tmp57;
						ValaCCodeFunctionCall* _tmp60;
						ValaCCodeFunctionCall* cast;
						ValaCCodeExpression* klass;
						_tmp56 = NULL;
						cl = (_tmp56 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) f)), (_tmp56 == NULL) ? NULL : vala_code_node_ref (_tmp56));
						_tmp59 = NULL;
						_tmp58 = NULL;
						_tmp57 = NULL;
						_tmp60 = NULL;
						cast = (_tmp60 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp59 = vala_ccode_identifier_new (_tmp58 = g_strconcat (_tmp57 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL), "_CLASS", NULL)))), (_tmp59 == NULL) ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL)), _tmp58 = (g_free (_tmp58), NULL), _tmp57 = (g_free (_tmp57), NULL), _tmp60);
						klass = NULL;
						if (vala_member_access_get_inner (expr) == NULL) {
							if (((ValaCCodeBaseModule*) self)->in_static_or_class_ctor) {
								ValaCCodeExpression* _tmp61;
								/* Accessing the field from a static or class constructor*/
								_tmp61 = NULL;
								klass = (_tmp61 = (ValaCCodeExpression*) vala_ccode_identifier_new ("klass"), (klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)), _tmp61);
							} else {
								ValaCCodeIdentifier* _tmp62;
								ValaCCodeFunctionCall* _tmp63;
								ValaCCodeFunctionCall* k;
								ValaCCodeIdentifier* _tmp64;
								ValaCCodeExpression* _tmp66;
								ValaCCodeExpression* _tmp65;
								/* Accessing the field from within an instance method*/
								_tmp62 = NULL;
								_tmp63 = NULL;
								k = (_tmp63 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp62 = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS"))), (_tmp62 == NULL) ? NULL : (_tmp62 = (vala_ccode_node_unref (_tmp62), NULL)), _tmp63);
								_tmp64 = NULL;
								vala_ccode_function_call_add_argument (k, (ValaCCodeExpression*) (_tmp64 = vala_ccode_identifier_new ("self")));
								(_tmp64 == NULL) ? NULL : (_tmp64 = (vala_ccode_node_unref (_tmp64), NULL));
								_tmp66 = NULL;
								_tmp65 = NULL;
								klass = (_tmp66 = (_tmp65 = (ValaCCodeExpression*) k, (_tmp65 == NULL) ? NULL : vala_ccode_node_ref (_tmp65)), (klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)), _tmp66);
								(k == NULL) ? NULL : (k = (vala_ccode_node_unref (k), NULL));
							}
						} else {
							ValaCCodeIdentifier* _tmp67;
							ValaCCodeFunctionCall* _tmp68;
							ValaCCodeFunctionCall* k;
							ValaCCodeExpression* _tmp70;
							ValaCCodeExpression* _tmp69;
							/* Accessing the field of an instance*/
							_tmp67 = NULL;
							_tmp68 = NULL;
							k = (_tmp68 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp67 = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS"))), (_tmp67 == NULL) ? NULL : (_tmp67 = (vala_ccode_node_unref (_tmp67), NULL)), _tmp68);
							vala_ccode_function_call_add_argument (k, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (expr))));
							_tmp70 = NULL;
							_tmp69 = NULL;
							klass = (_tmp70 = (_tmp69 = (ValaCCodeExpression*) k, (_tmp69 == NULL) ? NULL : vala_ccode_node_ref (_tmp69)), (klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)), _tmp70);
							(k == NULL) ? NULL : (k = (vala_ccode_node_unref (k), NULL));
						}
						vala_ccode_function_call_add_argument (cast, klass);
						if (vala_symbol_get_access ((ValaSymbol*) f) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
							ValaCCodeIdentifier* _tmp73;
							char* _tmp72;
							char* _tmp71;
							ValaCCodeFunctionCall* _tmp74;
							ValaCCodeFunctionCall* ccall;
							ValaCCodeIdentifier* _tmp75;
							ValaCCodeFunctionCall* _tmp76;
							ValaCCodeFunctionCall* ccall2;
							ValaCCodeMemberAccess* _tmp78;
							char* _tmp77;
							_tmp73 = NULL;
							_tmp72 = NULL;
							_tmp71 = NULL;
							_tmp74 = NULL;
							ccall = (_tmp74 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp73 = vala_ccode_identifier_new (_tmp72 = g_strdup_printf ("%s_GET_CLASS_PRIVATE", _tmp71 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL))))), (_tmp73 == NULL) ? NULL : (_tmp73 = (vala_ccode_node_unref (_tmp73), NULL)), _tmp72 = (g_free (_tmp72), NULL), _tmp71 = (g_free (_tmp71), NULL), _tmp74);
							_tmp75 = NULL;
							_tmp76 = NULL;
							ccall2 = (_tmp76 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp75 = vala_ccode_identifier_new ("G_TYPE_FROM_CLASS"))), (_tmp75 == NULL) ? NULL : (_tmp75 = (vala_ccode_node_unref (_tmp75), NULL)), _tmp76);
							vala_ccode_function_call_add_argument (ccall2, (ValaCCodeExpression*) cast);
							vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) ccall2);
							_tmp78 = NULL;
							_tmp77 = NULL;
							vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp78 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ccall, _tmp77 = vala_field_get_cname (f))));
							(_tmp78 == NULL) ? NULL : (_tmp78 = (vala_ccode_node_unref (_tmp78), NULL));
							_tmp77 = (g_free (_tmp77), NULL);
							(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
							(ccall2 == NULL) ? NULL : (ccall2 = (vala_ccode_node_unref (ccall2), NULL));
						} else {
							ValaCCodeMemberAccess* _tmp80;
							char* _tmp79;
							_tmp80 = NULL;
							_tmp79 = NULL;
							vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp80 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) cast, _tmp79 = vala_field_get_cname (f))));
							(_tmp80 == NULL) ? NULL : (_tmp80 = (vala_ccode_node_unref (_tmp80), NULL));
							_tmp79 = (g_free (_tmp79), NULL);
						}
						(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
						(cast == NULL) ? NULL : (cast = (vala_ccode_node_unref (cast), NULL));
						(klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL));
					} else {
						ValaCCodeIdentifier* _tmp82;
						char* _tmp81;
						_tmp82 = NULL;
						_tmp81 = NULL;
						vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp82 = vala_ccode_identifier_new (_tmp81 = vala_field_get_cname (f))));
						(_tmp82 == NULL) ? NULL : (_tmp82 = (vala_ccode_node_unref (_tmp82), NULL));
						_tmp81 = (g_free (_tmp81), NULL);
					}
				}
				(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
			} else {
				if (VALA_IS_CONSTANT (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
					ValaConstant* _tmp83;
					ValaConstant* c;
					char* fn;
					_tmp83 = NULL;
					c = (_tmp83 = VALA_CONSTANT (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp83 == NULL) ? NULL : vala_code_node_ref (_tmp83));
					vala_ccode_base_module_generate_constant_declaration ((ValaCCodeBaseModule*) self, c, ((ValaCCodeBaseModule*) self)->source_declarations);
					fn = vala_symbol_get_full_name ((ValaSymbol*) c);
					if (_vala_strcmp0 (fn, "GLib.Log.FILE") == 0) {
						char* s;
						ValaCCodeConstant* _tmp85;
						char* _tmp84;
						s = g_path_get_basename (vala_source_file_get_filename (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) expr))));
						_tmp85 = NULL;
						_tmp84 = NULL;
						vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp85 = vala_ccode_constant_new (_tmp84 = g_strdup_printf ("\"%s\"", s))));
						(_tmp85 == NULL) ? NULL : (_tmp85 = (vala_ccode_node_unref (_tmp85), NULL));
						_tmp84 = (g_free (_tmp84), NULL);
						s = (g_free (s), NULL);
					} else {
						if (_vala_strcmp0 (fn, "GLib.Log.LINE") == 0) {
							gint i;
							ValaCCodeConstant* _tmp87;
							char* _tmp86;
							i = vala_source_reference_get_first_line (vala_code_node_get_source_reference ((ValaCodeNode*) expr));
							_tmp87 = NULL;
							_tmp86 = NULL;
							vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp87 = vala_ccode_constant_new (_tmp86 = g_strdup_printf ("%d", i))));
							(_tmp87 == NULL) ? NULL : (_tmp87 = (vala_ccode_node_unref (_tmp87), NULL));
							_tmp86 = (g_free (_tmp86), NULL);
						} else {
							if (_vala_strcmp0 (fn, "GLib.Log.METHOD") == 0) {
								char* s;
								ValaCCodeConstant* _tmp90;
								char* _tmp89;
								s = g_strdup ("");
								if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
									char* _tmp88;
									_tmp88 = NULL;
									s = (_tmp88 = vala_symbol_get_full_name ((ValaSymbol*) ((ValaCCodeBaseModule*) self)->current_method), s = (g_free (s), NULL), _tmp88);
								}
								_tmp90 = NULL;
								_tmp89 = NULL;
								vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp90 = vala_ccode_constant_new (_tmp89 = g_strdup_printf ("\"%s\"", s))));
								(_tmp90 == NULL) ? NULL : (_tmp90 = (vala_ccode_node_unref (_tmp90), NULL));
								_tmp89 = (g_free (_tmp89), NULL);
								s = (g_free (s), NULL);
							} else {
								ValaCCodeIdentifier* _tmp92;
								char* _tmp91;
								_tmp92 = NULL;
								_tmp91 = NULL;
								vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp92 = vala_ccode_identifier_new (_tmp91 = vala_constant_get_cname (c))));
								(_tmp92 == NULL) ? NULL : (_tmp92 = (vala_ccode_node_unref (_tmp92), NULL));
								_tmp91 = (g_free (_tmp91), NULL);
							}
						}
					}
					(c == NULL) ? NULL : (c = (vala_code_node_unref (c), NULL));
					fn = (g_free (fn), NULL);
				} else {
					if (VALA_IS_PROPERTY (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
						ValaProperty* _tmp93;
						ValaProperty* prop;
						gboolean _tmp114;
						gboolean _tmp115;
						gboolean _tmp116;
						_tmp93 = NULL;
						prop = (_tmp93 = VALA_PROPERTY (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp93 == NULL) ? NULL : vala_code_node_ref (_tmp93));
						if (!VALA_IS_DYNAMIC_PROPERTY (prop)) {
							gboolean _tmp94;
							vala_ccode_base_module_generate_property_accessor_declaration ((ValaCCodeBaseModule*) self, vala_property_get_get_accessor (prop), ((ValaCCodeBaseModule*) self)->source_declarations);
							_tmp94 = FALSE;
							if (!vala_symbol_get_external ((ValaSymbol*) prop)) {
								_tmp94 = vala_symbol_get_external_package ((ValaSymbol*) prop);
							} else {
								_tmp94 = FALSE;
							}
							if (_tmp94) {
								/* internal VAPI properties
								 only add them once per source file*/
								if (vala_ccode_base_module_add_generated_external_symbol ((ValaCCodeBaseModule*) self, (ValaSymbol*) prop)) {
									vala_ccode_module_visit_property ((ValaCCodeModule*) self, prop);
								}
							}
						}
						if (VALA_IS_BASE_ACCESS (vala_member_access_get_inner (expr))) {
							if (vala_property_get_base_property (prop) != NULL) {
								ValaClass* _tmp95;
								ValaClass* base_class;
								ValaCCodeIdentifier* _tmp98;
								char* _tmp97;
								char* _tmp96;
								ValaCCodeFunctionCall* _tmp99;
								ValaCCodeFunctionCall* vcast;
								ValaCCodeIdentifier* _tmp102;
								char* _tmp101;
								char* _tmp100;
								ValaCCodeMemberAccess* _tmp104;
								char* _tmp103;
								ValaCCodeFunctionCall* _tmp105;
								ValaCCodeFunctionCall* ccall;
								_tmp95 = NULL;
								base_class = (_tmp95 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_property_get_base_property (prop))), (_tmp95 == NULL) ? NULL : vala_code_node_ref (_tmp95));
								_tmp98 = NULL;
								_tmp97 = NULL;
								_tmp96 = NULL;
								_tmp99 = NULL;
								vcast = (_tmp99 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp98 = vala_ccode_identifier_new (_tmp97 = g_strdup_printf ("%s_CLASS", _tmp96 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) base_class, NULL))))), (_tmp98 == NULL) ? NULL : (_tmp98 = (vala_ccode_node_unref (_tmp98), NULL)), _tmp97 = (g_free (_tmp97), NULL), _tmp96 = (g_free (_tmp96), NULL), _tmp99);
								_tmp102 = NULL;
								_tmp101 = NULL;
								_tmp100 = NULL;
								vala_ccode_function_call_add_argument (vcast, (ValaCCodeExpression*) (_tmp102 = vala_ccode_identifier_new (_tmp101 = g_strdup_printf ("%s_parent_class", _tmp100 = vala_symbol_get_lower_case_cname ((ValaSymbol*) ((ValaCCodeBaseModule*) self)->current_class, NULL)))));
								(_tmp102 == NULL) ? NULL : (_tmp102 = (vala_ccode_node_unref (_tmp102), NULL));
								_tmp101 = (g_free (_tmp101), NULL);
								_tmp100 = (g_free (_tmp100), NULL);
								_tmp104 = NULL;
								_tmp103 = NULL;
								_tmp105 = NULL;
								ccall = (_tmp105 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp104 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) vcast, _tmp103 = g_strdup_printf ("get_%s", vala_symbol_get_name ((ValaSymbol*) prop))))), (_tmp104 == NULL) ? NULL : (_tmp104 = (vala_ccode_node_unref (_tmp104), NULL)), _tmp103 = (g_free (_tmp103), NULL), _tmp105);
								vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (expr))));
								vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall);
								(base_class == NULL) ? NULL : (base_class = (vala_code_node_unref (base_class), NULL));
								(vcast == NULL) ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL));
								(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
								(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
								(pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL));
								(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
								return;
							} else {
								if (vala_property_get_base_interface_property (prop) != NULL) {
									ValaInterface* _tmp106;
									ValaInterface* base_iface;
									char* _tmp108;
									char* _tmp107;
									char* _tmp109;
									char* parent_iface_var;
									ValaCCodeMemberAccess* _tmp112;
									char* _tmp111;
									ValaCCodeIdentifier* _tmp110;
									ValaCCodeFunctionCall* _tmp113;
									ValaCCodeFunctionCall* ccall;
									_tmp106 = NULL;
									base_iface = (_tmp106 = VALA_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_property_get_base_interface_property (prop))), (_tmp106 == NULL) ? NULL : vala_code_node_ref (_tmp106));
									_tmp108 = NULL;
									_tmp107 = NULL;
									_tmp109 = NULL;
									parent_iface_var = (_tmp109 = g_strdup_printf ("%s_%s_parent_iface", _tmp107 = vala_symbol_get_lower_case_cname ((ValaSymbol*) ((ValaCCodeBaseModule*) self)->current_class, NULL), _tmp108 = vala_symbol_get_lower_case_cname ((ValaSymbol*) base_iface, NULL)), _tmp108 = (g_free (_tmp108), NULL), _tmp107 = (g_free (_tmp107), NULL), _tmp109);
									_tmp112 = NULL;
									_tmp111 = NULL;
									_tmp110 = NULL;
									_tmp113 = NULL;
									ccall = (_tmp113 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp112 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp110 = vala_ccode_identifier_new (parent_iface_var)), _tmp111 = g_strdup_printf ("get_%s", vala_symbol_get_name ((ValaSymbol*) prop))))), (_tmp112 == NULL) ? NULL : (_tmp112 = (vala_ccode_node_unref (_tmp112), NULL)), _tmp111 = (g_free (_tmp111), NULL), (_tmp110 == NULL) ? NULL : (_tmp110 = (vala_ccode_node_unref (_tmp110), NULL)), _tmp113);
									vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (expr))));
									vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall);
									(base_iface == NULL) ? NULL : (base_iface = (vala_code_node_unref (base_iface), NULL));
									parent_iface_var = (g_free (parent_iface_var), NULL);
									(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
									(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
									(pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL));
									(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
									return;
								}
							}
						}
						_tmp114 = FALSE;
						_tmp115 = FALSE;
						_tmp116 = FALSE;
						if (vala_property_accessor_get_automatic_body (vala_property_get_get_accessor (prop))) {
							_tmp116 = VALA_SYMBOL (((ValaCCodeBaseModule*) self)->current_type_symbol) == vala_symbol_get_parent_symbol ((ValaSymbol*) prop);
						} else {
							_tmp116 = FALSE;
						}
						if (_tmp116) {
							_tmp115 = vala_property_get_base_property (prop) == NULL;
						} else {
							_tmp115 = FALSE;
						}
						if (_tmp115) {
							_tmp114 = vala_property_get_base_interface_property (prop) == NULL;
						} else {
							_tmp114 = FALSE;
						}
						if (_tmp114) {
							ValaCCodeExpression* inst;
							ValaCCodeExpression* _tmp117;
							ValaCCodeMemberAccess* _tmp119;
							char* _tmp118;
							inst = NULL;
							_tmp117 = NULL;
							inst = (_tmp117 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (pub_inst, "priv"), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp117);
							_tmp119 = NULL;
							_tmp118 = NULL;
							vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp119 = vala_ccode_member_access_new_pointer (inst, _tmp118 = vala_field_get_cname (vala_property_get_field (prop)))));
							(_tmp119 == NULL) ? NULL : (_tmp119 = (vala_ccode_node_unref (_tmp119), NULL));
							_tmp118 = (g_free (_tmp118), NULL);
							(inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL));
						} else {
							if (!vala_property_get_no_accessor_method (prop)) {
								ValaProperty* _tmp120;
								ValaProperty* base_property;
								char* getter_cname;
								ValaCCodeIdentifier* _tmp127;
								ValaCCodeFunctionCall* _tmp128;
								ValaCCodeFunctionCall* ccall;
								_tmp120 = NULL;
								base_property = (_tmp120 = prop, (_tmp120 == NULL) ? NULL : vala_code_node_ref (_tmp120));
								if (vala_property_get_base_property (prop) != NULL) {
									ValaProperty* _tmp122;
									ValaProperty* _tmp121;
									_tmp122 = NULL;
									_tmp121 = NULL;
									base_property = (_tmp122 = (_tmp121 = vala_property_get_base_property (prop), (_tmp121 == NULL) ? NULL : vala_code_node_ref (_tmp121)), (base_property == NULL) ? NULL : (base_property = (vala_code_node_unref (base_property), NULL)), _tmp122);
								} else {
									if (vala_property_get_base_interface_property (prop) != NULL) {
										ValaProperty* _tmp124;
										ValaProperty* _tmp123;
										_tmp124 = NULL;
										_tmp123 = NULL;
										base_property = (_tmp124 = (_tmp123 = vala_property_get_base_interface_property (prop), (_tmp123 == NULL) ? NULL : vala_code_node_ref (_tmp123)), (base_property == NULL) ? NULL : (base_property = (vala_code_node_unref (base_property), NULL)), _tmp124);
									}
								}
								getter_cname = NULL;
								if (VALA_IS_DYNAMIC_PROPERTY (prop)) {
									char* _tmp125;
									_tmp125 = NULL;
									getter_cname = (_tmp125 = vala_ccode_module_get_dynamic_property_getter_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), VALA_DYNAMIC_PROPERTY (prop)), getter_cname = (g_free (getter_cname), NULL), _tmp125);
								} else {
									char* _tmp126;
									_tmp126 = NULL;
									getter_cname = (_tmp126 = vala_property_accessor_get_cname (vala_property_get_get_accessor (base_property)), getter_cname = (g_free (getter_cname), NULL), _tmp126);
								}
								_tmp127 = NULL;
								_tmp128 = NULL;
								ccall = (_tmp128 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp127 = vala_ccode_identifier_new (getter_cname))), (_tmp127 == NULL) ? NULL : (_tmp127 = (vala_ccode_node_unref (_tmp127), NULL)), _tmp128);
								if (vala_property_get_binding (prop) == MEMBER_BINDING_INSTANCE) {
									vala_ccode_function_call_add_argument (ccall, pub_inst);
								}
								/* Property access to real struct types is handled differently
								 The value is returned by out parameter*/
								if (vala_data_type_is_real_struct_type (vala_property_get_property_type (base_property))) {
									ValaCCodeCommaExpression* ccomma;
									ValaLocalVariable* temp_var;
									ValaCCodeIdentifier* ctemp;
									ValaCCodeUnaryExpression* _tmp129;
									ccomma = vala_ccode_comma_expression_new ();
									temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_property_accessor_get_value_type (vala_property_get_get_accessor (base_property)), TRUE, NULL);
									ctemp = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var));
									gee_collection_add ((GeeCollection*) ((ValaCCodeBaseModule*) self)->temp_vars, temp_var);
									_tmp129 = NULL;
									vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp129 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) ctemp)));
									(_tmp129 == NULL) ? NULL : (_tmp129 = (vala_ccode_node_unref (_tmp129), NULL));
									vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) ccall);
									vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) ctemp);
									vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccomma);
									(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
									(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
									(ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL));
								} else {
									vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall);
								}
								(base_property == NULL) ? NULL : (base_property = (vala_code_node_unref (base_property), NULL));
								getter_cname = (g_free (getter_cname), NULL);
								(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
							} else {
								ValaCCodeIdentifier* _tmp130;
								ValaCCodeFunctionCall* _tmp131;
								ValaCCodeFunctionCall* ccall;
								ValaCCodeConstant* _tmp132;
								ValaCCodeCommaExpression* ccomma;
								ValaLocalVariable* temp_var;
								ValaCCodeIdentifier* ctemp;
								ValaCCodeUnaryExpression* _tmp135;
								ValaCCodeConstant* _tmp136;
								_tmp130 = NULL;
								_tmp131 = NULL;
								ccall = (_tmp131 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp130 = vala_ccode_identifier_new ("g_object_get"))), (_tmp130 == NULL) ? NULL : (_tmp130 = (vala_ccode_node_unref (_tmp130), NULL)), _tmp131);
								vala_ccode_function_call_add_argument (ccall, pub_inst);
								/* property name is second argument of g_object_get*/
								_tmp132 = NULL;
								vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp132 = vala_property_get_canonical_cconstant (prop)));
								(_tmp132 == NULL) ? NULL : (_tmp132 = (vala_ccode_node_unref (_tmp132), NULL));
								/* g_object_get always returns owned values
								 therefore, property getters of properties
								 without accessor methods need to be marked as owned*/
								if (!vala_data_type_get_value_owned (vala_property_accessor_get_value_type (vala_property_get_get_accessor (prop)))) {
									ValaDataType* owned_value_type;
									/* only report error for types where there actually
									 is a difference between `owned' and `unowned'*/
									owned_value_type = vala_data_type_copy (vala_property_accessor_get_value_type (vala_property_get_get_accessor (prop)));
									vala_data_type_set_value_owned (owned_value_type, TRUE);
									if (vala_ccode_base_module_requires_copy ((ValaCCodeBaseModule*) self, owned_value_type)) {
										char* _tmp134;
										char* _tmp133;
										_tmp134 = NULL;
										_tmp133 = NULL;
										vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) vala_property_get_get_accessor (prop)), _tmp134 = g_strdup_printf ("unowned return value for getter of property `%s' not supported without accessor", _tmp133 = vala_symbol_get_full_name ((ValaSymbol*) prop)));
										_tmp134 = (g_free (_tmp134), NULL);
										_tmp133 = (g_free (_tmp133), NULL);
									}
									(owned_value_type == NULL) ? NULL : (owned_value_type = (vala_code_node_unref (owned_value_type), NULL));
								}
								ccomma = vala_ccode_comma_expression_new ();
								temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_value_type ((ValaExpression*) expr), TRUE, NULL);
								ctemp = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var));
								gee_collection_add ((GeeCollection*) ((ValaCCodeBaseModule*) self)->temp_vars, temp_var);
								_tmp135 = NULL;
								vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp135 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) ctemp)));
								(_tmp135 == NULL) ? NULL : (_tmp135 = (vala_ccode_node_unref (_tmp135), NULL));
								_tmp136 = NULL;
								vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp136 = vala_ccode_constant_new ("NULL")));
								(_tmp136 == NULL) ? NULL : (_tmp136 = (vala_ccode_node_unref (_tmp136), NULL));
								vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) ccall);
								vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) ctemp);
								vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccomma);
								(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
								(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
								(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
								(ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL));
							}
						}
						(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
					} else {
						if (VALA_IS_ENUM_VALUE (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
							ValaEnumValue* _tmp137;
							ValaEnumValue* ev;
							ValaCCodeConstant* _tmp139;
							char* _tmp138;
							_tmp137 = NULL;
							ev = (_tmp137 = VALA_ENUM_VALUE (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp137 == NULL) ? NULL : vala_code_node_ref (_tmp137));
							vala_ccode_base_module_generate_enum_declaration ((ValaCCodeBaseModule*) self, VALA_ENUM (vala_symbol_get_parent_symbol ((ValaSymbol*) ev)), ((ValaCCodeBaseModule*) self)->source_declarations);
							_tmp139 = NULL;
							_tmp138 = NULL;
							vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp139 = vala_ccode_constant_new (_tmp138 = vala_enum_value_get_cname (ev))));
							(_tmp139 == NULL) ? NULL : (_tmp139 = (vala_ccode_node_unref (_tmp139), NULL));
							_tmp138 = (g_free (_tmp138), NULL);
							(ev == NULL) ? NULL : (ev = (vala_code_node_unref (ev), NULL));
						} else {
							if (VALA_IS_LOCAL_VARIABLE (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
								ValaLocalVariable* _tmp140;
								ValaLocalVariable* local;
								ValaCCodeExpression* _tmp141;
								_tmp140 = NULL;
								local = (_tmp140 = VALA_LOCAL_VARIABLE (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp140 == NULL) ? NULL : vala_code_node_ref (_tmp140));
								_tmp141 = NULL;
								vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp141 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) local))));
								(_tmp141 == NULL) ? NULL : (_tmp141 = (vala_ccode_node_unref (_tmp141), NULL));
								(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
							} else {
								if (VALA_IS_FORMAL_PARAMETER (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
									ValaFormalParameter* _tmp142;
									ValaFormalParameter* p;
									_tmp142 = NULL;
									p = (_tmp142 = VALA_FORMAL_PARAMETER (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp142 == NULL) ? NULL : vala_code_node_ref (_tmp142));
									if (_vala_strcmp0 (vala_symbol_get_name ((ValaSymbol*) p), "this") == 0) {
										gboolean _tmp143;
										_tmp143 = FALSE;
										if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
											_tmp143 = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
										} else {
											_tmp143 = FALSE;
										}
										if (_tmp143) {
											ValaCCodeExpression* _tmp144;
											/* use closure*/
											_tmp144 = NULL;
											vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp144 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "self")));
											(_tmp144 == NULL) ? NULL : (_tmp144 = (vala_ccode_node_unref (_tmp144), NULL));
										} else {
											ValaStruct* _tmp146;
											ValaTypeSymbol* _tmp145;
											ValaStruct* st;
											gboolean _tmp147;
											_tmp146 = NULL;
											_tmp145 = NULL;
											st = (_tmp146 = (_tmp145 = ((ValaCCodeBaseModule*) self)->current_type_symbol, VALA_IS_STRUCT (_tmp145) ? ((ValaStruct*) _tmp145) : NULL), (_tmp146 == NULL) ? NULL : vala_code_node_ref (_tmp146));
											_tmp147 = FALSE;
											if (st != NULL) {
												_tmp147 = !vala_struct_is_simple_type (st);
											} else {
												_tmp147 = FALSE;
											}
											if (_tmp147) {
												ValaCCodeIdentifier* _tmp148;
												_tmp148 = NULL;
												vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp148 = vala_ccode_identifier_new ("(*self)")));
												(_tmp148 == NULL) ? NULL : (_tmp148 = (vala_ccode_node_unref (_tmp148), NULL));
											} else {
												ValaCCodeIdentifier* _tmp149;
												_tmp149 = NULL;
												vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp149 = vala_ccode_identifier_new ("self")));
												(_tmp149 == NULL) ? NULL : (_tmp149 = (vala_ccode_node_unref (_tmp149), NULL));
											}
											(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
										}
									} else {
										gboolean _tmp150;
										_tmp150 = FALSE;
										if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
											_tmp150 = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
										} else {
											_tmp150 = FALSE;
										}
										if (_tmp150) {
											ValaCCodeExpression* _tmp151;
											/* use closure*/
											_tmp151 = NULL;
											vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp151 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) p))));
											(_tmp151 == NULL) ? NULL : (_tmp151 = (vala_ccode_node_unref (_tmp151), NULL));
										} else {
											ValaStruct* _tmp153;
											ValaTypeSymbol* _tmp152;
											ValaStruct* type_as_struct;
											gboolean _tmp154;
											_tmp153 = NULL;
											_tmp152 = NULL;
											type_as_struct = (_tmp153 = (_tmp152 = vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (p)), VALA_IS_STRUCT (_tmp152) ? ((ValaStruct*) _tmp152) : NULL), (_tmp153 == NULL) ? NULL : vala_code_node_ref (_tmp153));
											_tmp154 = FALSE;
											if (vala_formal_parameter_get_direction (p) != VALA_PARAMETER_DIRECTION_IN) {
												_tmp154 = TRUE;
											} else {
												gboolean _tmp155;
												gboolean _tmp156;
												_tmp155 = FALSE;
												_tmp156 = FALSE;
												if (type_as_struct != NULL) {
													_tmp156 = !vala_struct_is_simple_type (type_as_struct);
												} else {
													_tmp156 = FALSE;
												}
												if (_tmp156) {
													_tmp155 = !vala_data_type_get_nullable (vala_formal_parameter_get_parameter_type (p));
												} else {
													_tmp155 = FALSE;
												}
												_tmp154 = _tmp155;
											}
											if (_tmp154) {
												ValaCCodeIdentifier* _tmp158;
												char* _tmp157;
												_tmp158 = NULL;
												_tmp157 = NULL;
												vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp158 = vala_ccode_identifier_new (_tmp157 = g_strdup_printf ("(*%s)", vala_symbol_get_name ((ValaSymbol*) p)))));
												(_tmp158 == NULL) ? NULL : (_tmp158 = (vala_ccode_node_unref (_tmp158), NULL));
												_tmp157 = (g_free (_tmp157), NULL);
											} else {
												gboolean _tmp159;
												gboolean _tmp160;
												gboolean _tmp161;
												_tmp159 = FALSE;
												_tmp160 = FALSE;
												_tmp161 = FALSE;
												if (((ValaCCodeBaseModule*) self)->current_property_accessor != NULL) {
													_tmp161 = vala_property_accessor_get_writable (((ValaCCodeBaseModule*) self)->current_property_accessor);
												} else {
													_tmp161 = FALSE;
												}
												if (_tmp161) {
													_tmp160 = vala_property_accessor_get_value_parameter (((ValaCCodeBaseModule*) self)->current_property_accessor) == p;
												} else {
													_tmp160 = FALSE;
												}
												if (_tmp160) {
													_tmp159 = vala_data_type_is_real_struct_type (vala_property_get_property_type (vala_property_accessor_get_prop (((ValaCCodeBaseModule*) self)->current_property_accessor)));
												} else {
													_tmp159 = FALSE;
												}
												/* Property setters of non simple structs shall replace all occurences
												 of the "value" formal parameter with a dereferencing version of that
												 parameter.*/
												if (_tmp159) {
													ValaCCodeIdentifier* _tmp162;
													_tmp162 = NULL;
													vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp162 = vala_ccode_identifier_new ("(*value)")));
													(_tmp162 == NULL) ? NULL : (_tmp162 = (vala_ccode_node_unref (_tmp162), NULL));
												} else {
													ValaCCodeIdentifier* _tmp163;
													_tmp163 = NULL;
													vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp163 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) p))));
													(_tmp163 == NULL) ? NULL : (_tmp163 = (vala_ccode_node_unref (_tmp163), NULL));
												}
											}
											(type_as_struct == NULL) ? NULL : (type_as_struct = (vala_code_node_unref (type_as_struct), NULL));
										}
									}
									(p == NULL) ? NULL : (p = (vala_code_node_unref (p), NULL));
								}
							}
						}
					}
				}
			}
		}
	}
	(pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL));
	(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
}


static void vala_ccode_member_access_module_class_init (ValaCCodeMemberAccessModuleClass * klass) {
	vala_ccode_member_access_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->visit_member_access = vala_ccode_member_access_module_real_visit_member_access;
}


static void vala_ccode_member_access_module_instance_init (ValaCCodeMemberAccessModule * self) {
}


GType vala_ccode_member_access_module_get_type (void) {
	static GType vala_ccode_member_access_module_type_id = 0;
	if (vala_ccode_member_access_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMemberAccessModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_member_access_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMemberAccessModule), 0, (GInstanceInitFunc) vala_ccode_member_access_module_instance_init, NULL };
		vala_ccode_member_access_module_type_id = g_type_register_static (VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, "ValaCCodeMemberAccessModule", &g_define_type_info, 0);
	}
	return vala_ccode_member_access_module_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




