/* valadbusmodule.vala
 *
 * Copyright (C) 2008-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valaccode.h>
#include <gee.h>


#define VALA_TYPE_CCODE_MODULE (vala_ccode_module_get_type ())
#define VALA_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModule))
#define VALA_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))
#define VALA_IS_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MODULE))
#define VALA_IS_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MODULE))
#define VALA_CCODE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))

typedef struct _ValaCCodeModule ValaCCodeModule;
typedef struct _ValaCCodeModuleClass ValaCCodeModuleClass;
typedef struct _ValaCCodeModulePrivate ValaCCodeModulePrivate;

#define VALA_TYPE_CCODE_BASE_MODULE (vala_ccode_base_module_get_type ())
#define VALA_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModule))
#define VALA_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))
#define VALA_IS_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_IS_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_CCODE_BASE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))

typedef struct _ValaCCodeBaseModule ValaCCodeBaseModule;
typedef struct _ValaCCodeBaseModuleClass ValaCCodeBaseModuleClass;
typedef struct _ValaCCodeBaseModulePrivate ValaCCodeBaseModulePrivate;

#define VALA_TYPE_CCODE_DECLARATION_SPACE (vala_ccode_declaration_space_get_type ())
#define VALA_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpace))
#define VALA_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))
#define VALA_IS_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_IS_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_CCODE_DECLARATION_SPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))

typedef struct _ValaCCodeDeclarationSpace ValaCCodeDeclarationSpace;
typedef struct _ValaCCodeDeclarationSpaceClass ValaCCodeDeclarationSpaceClass;

#define VALA_TYPE_CCODE_STRUCT_MODULE (vala_ccode_struct_module_get_type ())
#define VALA_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModule))
#define VALA_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))
#define VALA_IS_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_IS_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_CCODE_STRUCT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))

typedef struct _ValaCCodeStructModule ValaCCodeStructModule;
typedef struct _ValaCCodeStructModuleClass ValaCCodeStructModuleClass;
typedef struct _ValaCCodeStructModulePrivate ValaCCodeStructModulePrivate;

#define VALA_TYPE_CCODE_METHOD_MODULE (vala_ccode_method_module_get_type ())
#define VALA_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModule))
#define VALA_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))
#define VALA_IS_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_IS_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_CCODE_METHOD_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))

typedef struct _ValaCCodeMethodModule ValaCCodeMethodModule;
typedef struct _ValaCCodeMethodModuleClass ValaCCodeMethodModuleClass;
typedef struct _ValaCCodeMethodModulePrivate ValaCCodeMethodModulePrivate;

#define VALA_TYPE_CCODE_CONTROL_FLOW_MODULE (vala_ccode_control_flow_module_get_type ())
#define VALA_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModule))
#define VALA_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_CCODE_CONTROL_FLOW_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))

typedef struct _ValaCCodeControlFlowModule ValaCCodeControlFlowModule;
typedef struct _ValaCCodeControlFlowModuleClass ValaCCodeControlFlowModuleClass;
typedef struct _ValaCCodeControlFlowModulePrivate ValaCCodeControlFlowModulePrivate;

#define VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE (vala_ccode_member_access_module_get_type ())
#define VALA_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModule))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))

typedef struct _ValaCCodeMemberAccessModule ValaCCodeMemberAccessModule;
typedef struct _ValaCCodeMemberAccessModuleClass ValaCCodeMemberAccessModuleClass;
typedef struct _ValaCCodeMemberAccessModulePrivate ValaCCodeMemberAccessModulePrivate;

#define VALA_TYPE_CCODE_ASSIGNMENT_MODULE (vala_ccode_assignment_module_get_type ())
#define VALA_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModule))
#define VALA_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_CCODE_ASSIGNMENT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))

typedef struct _ValaCCodeAssignmentModule ValaCCodeAssignmentModule;
typedef struct _ValaCCodeAssignmentModuleClass ValaCCodeAssignmentModuleClass;
typedef struct _ValaCCodeAssignmentModulePrivate ValaCCodeAssignmentModulePrivate;

#define VALA_TYPE_CCODE_METHOD_CALL_MODULE (vala_ccode_method_call_module_get_type ())
#define VALA_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModule))
#define VALA_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))
#define VALA_IS_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_IS_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_CCODE_METHOD_CALL_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))

typedef struct _ValaCCodeMethodCallModule ValaCCodeMethodCallModule;
typedef struct _ValaCCodeMethodCallModuleClass ValaCCodeMethodCallModuleClass;
typedef struct _ValaCCodeMethodCallModulePrivate ValaCCodeMethodCallModulePrivate;

#define VALA_TYPE_CCODE_ARRAY_MODULE (vala_ccode_array_module_get_type ())
#define VALA_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModule))
#define VALA_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))
#define VALA_IS_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_IS_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_CCODE_ARRAY_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))

typedef struct _ValaCCodeArrayModule ValaCCodeArrayModule;
typedef struct _ValaCCodeArrayModuleClass ValaCCodeArrayModuleClass;
typedef struct _ValaCCodeArrayModulePrivate ValaCCodeArrayModulePrivate;

#define VALA_TYPE_CCODE_DELEGATE_MODULE (vala_ccode_delegate_module_get_type ())
#define VALA_CCODE_DELEGATE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModule))
#define VALA_CCODE_DELEGATE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModuleClass))
#define VALA_IS_CCODE_DELEGATE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE))
#define VALA_IS_CCODE_DELEGATE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DELEGATE_MODULE))
#define VALA_CCODE_DELEGATE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModuleClass))

typedef struct _ValaCCodeDelegateModule ValaCCodeDelegateModule;
typedef struct _ValaCCodeDelegateModuleClass ValaCCodeDelegateModuleClass;
typedef struct _ValaCCodeDelegateModulePrivate ValaCCodeDelegateModulePrivate;

#define VALA_TYPE_GERROR_MODULE (vala_gerror_module_get_type ())
#define VALA_GERROR_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GERROR_MODULE, ValaGErrorModule))
#define VALA_GERROR_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GERROR_MODULE, ValaGErrorModuleClass))
#define VALA_IS_GERROR_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GERROR_MODULE))
#define VALA_IS_GERROR_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GERROR_MODULE))
#define VALA_GERROR_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GERROR_MODULE, ValaGErrorModuleClass))

typedef struct _ValaGErrorModule ValaGErrorModule;
typedef struct _ValaGErrorModuleClass ValaGErrorModuleClass;
typedef struct _ValaGErrorModulePrivate ValaGErrorModulePrivate;

#define VALA_TYPE_GTYPE_MODULE (vala_gtype_module_get_type ())
#define VALA_GTYPE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GTYPE_MODULE, ValaGTypeModule))
#define VALA_GTYPE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GTYPE_MODULE, ValaGTypeModuleClass))
#define VALA_IS_GTYPE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GTYPE_MODULE))
#define VALA_IS_GTYPE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GTYPE_MODULE))
#define VALA_GTYPE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GTYPE_MODULE, ValaGTypeModuleClass))

typedef struct _ValaGTypeModule ValaGTypeModule;
typedef struct _ValaGTypeModuleClass ValaGTypeModuleClass;
typedef struct _ValaGTypeModulePrivate ValaGTypeModulePrivate;

#define VALA_TYPE_GOBJECT_MODULE (vala_gobject_module_get_type ())
#define VALA_GOBJECT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule))
#define VALA_GOBJECT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GOBJECT_MODULE, ValaGObjectModuleClass))
#define VALA_IS_GOBJECT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GOBJECT_MODULE))
#define VALA_IS_GOBJECT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GOBJECT_MODULE))
#define VALA_GOBJECT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GOBJECT_MODULE, ValaGObjectModuleClass))

typedef struct _ValaGObjectModule ValaGObjectModule;
typedef struct _ValaGObjectModuleClass ValaGObjectModuleClass;
typedef struct _ValaGObjectModulePrivate ValaGObjectModulePrivate;

#define VALA_TYPE_GSIGNAL_MODULE (vala_gsignal_module_get_type ())
#define VALA_GSIGNAL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModule))
#define VALA_GSIGNAL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModuleClass))
#define VALA_IS_GSIGNAL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GSIGNAL_MODULE))
#define VALA_IS_GSIGNAL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GSIGNAL_MODULE))
#define VALA_GSIGNAL_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModuleClass))

typedef struct _ValaGSignalModule ValaGSignalModule;
typedef struct _ValaGSignalModuleClass ValaGSignalModuleClass;
typedef struct _ValaGSignalModulePrivate ValaGSignalModulePrivate;

#define VALA_TYPE_GASYNC_MODULE (vala_gasync_module_get_type ())
#define VALA_GASYNC_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GASYNC_MODULE, ValaGAsyncModule))
#define VALA_GASYNC_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GASYNC_MODULE, ValaGAsyncModuleClass))
#define VALA_IS_GASYNC_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GASYNC_MODULE))
#define VALA_IS_GASYNC_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GASYNC_MODULE))
#define VALA_GASYNC_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GASYNC_MODULE, ValaGAsyncModuleClass))

typedef struct _ValaGAsyncModule ValaGAsyncModule;
typedef struct _ValaGAsyncModuleClass ValaGAsyncModuleClass;
typedef struct _ValaGAsyncModulePrivate ValaGAsyncModulePrivate;

#define VALA_TYPE_DBUS_MODULE (vala_dbus_module_get_type ())
#define VALA_DBUS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DBUS_MODULE, ValaDBusModule))
#define VALA_DBUS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DBUS_MODULE, ValaDBusModuleClass))
#define VALA_IS_DBUS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DBUS_MODULE))
#define VALA_IS_DBUS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DBUS_MODULE))
#define VALA_DBUS_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DBUS_MODULE, ValaDBusModuleClass))

typedef struct _ValaDBusModule ValaDBusModule;
typedef struct _ValaDBusModuleClass ValaDBusModuleClass;
typedef struct _ValaDBusModulePrivate ValaDBusModulePrivate;

#define VALA_TYPE_CCODE_GENERATOR (vala_ccode_generator_get_type ())
#define VALA_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGenerator))
#define VALA_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))
#define VALA_IS_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_GENERATOR))
#define VALA_IS_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_GENERATOR))
#define VALA_CCODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))

typedef struct _ValaCCodeGenerator ValaCCodeGenerator;
typedef struct _ValaCCodeGeneratorClass ValaCCodeGeneratorClass;

#define VALA_DBUS_MODULE_TYPE_BASIC_TYPE_INFO (vala_dbus_module_basic_type_info_get_type ())
typedef struct _ValaDBusModuleBasicTypeInfo ValaDBusModuleBasicTypeInfo;

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeModule {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeModulePrivate * priv;
};

struct _ValaCCodeModuleClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeModule *self);
	void (*emit) (ValaCCodeModule* self, ValaCodeContext* context);
	void (*visit_source_file) (ValaCCodeModule* self, ValaSourceFile* source_file);
	void (*visit_class) (ValaCCodeModule* self, ValaClass* cl);
	void (*visit_interface) (ValaCCodeModule* self, ValaInterface* iface);
	void (*visit_struct) (ValaCCodeModule* self, ValaStruct* st);
	void (*visit_enum) (ValaCCodeModule* self, ValaEnum* en);
	void (*visit_error_domain) (ValaCCodeModule* self, ValaErrorDomain* edomain);
	void (*visit_delegate) (ValaCCodeModule* self, ValaDelegate* d);
	void (*visit_member) (ValaCCodeModule* self, ValaMember* m);
	void (*visit_constant) (ValaCCodeModule* self, ValaConstant* c);
	void (*visit_field) (ValaCCodeModule* self, ValaField* f);
	void (*visit_method) (ValaCCodeModule* self, ValaMethod* m);
	void (*visit_creation_method) (ValaCCodeModule* self, ValaCreationMethod* m);
	void (*visit_formal_parameter) (ValaCCodeModule* self, ValaFormalParameter* p);
	void (*visit_property) (ValaCCodeModule* self, ValaProperty* prop);
	void (*visit_property_accessor) (ValaCCodeModule* self, ValaPropertyAccessor* acc);
	void (*visit_signal) (ValaCCodeModule* self, ValaSignal* sig);
	void (*visit_constructor) (ValaCCodeModule* self, ValaConstructor* c);
	void (*visit_destructor) (ValaCCodeModule* self, ValaDestructor* d);
	void (*visit_block) (ValaCCodeModule* self, ValaBlock* b);
	void (*visit_empty_statement) (ValaCCodeModule* self, ValaEmptyStatement* stmt);
	void (*visit_declaration_statement) (ValaCCodeModule* self, ValaDeclarationStatement* stmt);
	void (*visit_local_variable) (ValaCCodeModule* self, ValaLocalVariable* local);
	void (*visit_initializer_list) (ValaCCodeModule* self, ValaInitializerList* list);
	void (*visit_end_full_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_expression_statement) (ValaCCodeModule* self, ValaExpressionStatement* stmt);
	void (*visit_if_statement) (ValaCCodeModule* self, ValaIfStatement* stmt);
	void (*visit_switch_statement) (ValaCCodeModule* self, ValaSwitchStatement* stmt);
	void (*visit_switch_section) (ValaCCodeModule* self, ValaSwitchSection* section);
	void (*visit_switch_label) (ValaCCodeModule* self, ValaSwitchLabel* label);
	void (*visit_while_statement) (ValaCCodeModule* self, ValaWhileStatement* stmt);
	void (*visit_do_statement) (ValaCCodeModule* self, ValaDoStatement* stmt);
	void (*visit_for_statement) (ValaCCodeModule* self, ValaForStatement* stmt);
	void (*visit_foreach_statement) (ValaCCodeModule* self, ValaForeachStatement* stmt);
	void (*visit_break_statement) (ValaCCodeModule* self, ValaBreakStatement* stmt);
	void (*visit_continue_statement) (ValaCCodeModule* self, ValaContinueStatement* stmt);
	void (*visit_return_statement) (ValaCCodeModule* self, ValaReturnStatement* stmt);
	void (*visit_yield_statement) (ValaCCodeModule* self, ValaYieldStatement* stmt);
	void (*visit_throw_statement) (ValaCCodeModule* self, ValaThrowStatement* stmt);
	void (*visit_try_statement) (ValaCCodeModule* self, ValaTryStatement* stmt);
	void (*visit_catch_clause) (ValaCCodeModule* self, ValaCatchClause* clause);
	void (*visit_lock_statement) (ValaCCodeModule* self, ValaLockStatement* stmt);
	void (*visit_delete_statement) (ValaCCodeModule* self, ValaDeleteStatement* stmt);
	void (*visit_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_array_creation_expression) (ValaCCodeModule* self, ValaArrayCreationExpression* expr);
	void (*visit_boolean_literal) (ValaCCodeModule* self, ValaBooleanLiteral* expr);
	void (*visit_character_literal) (ValaCCodeModule* self, ValaCharacterLiteral* expr);
	void (*visit_integer_literal) (ValaCCodeModule* self, ValaIntegerLiteral* expr);
	void (*visit_real_literal) (ValaCCodeModule* self, ValaRealLiteral* expr);
	void (*visit_string_literal) (ValaCCodeModule* self, ValaStringLiteral* expr);
	void (*visit_null_literal) (ValaCCodeModule* self, ValaNullLiteral* expr);
	void (*visit_member_access) (ValaCCodeModule* self, ValaMemberAccess* expr);
	void (*visit_method_call) (ValaCCodeModule* self, ValaMethodCall* expr);
	void (*visit_element_access) (ValaCCodeModule* self, ValaElementAccess* expr);
	void (*visit_base_access) (ValaCCodeModule* self, ValaBaseAccess* expr);
	void (*visit_postfix_expression) (ValaCCodeModule* self, ValaPostfixExpression* expr);
	void (*visit_object_creation_expression) (ValaCCodeModule* self, ValaObjectCreationExpression* expr);
	void (*visit_sizeof_expression) (ValaCCodeModule* self, ValaSizeofExpression* expr);
	void (*visit_typeof_expression) (ValaCCodeModule* self, ValaTypeofExpression* expr);
	void (*visit_unary_expression) (ValaCCodeModule* self, ValaUnaryExpression* expr);
	void (*visit_cast_expression) (ValaCCodeModule* self, ValaCastExpression* expr);
	void (*visit_pointer_indirection) (ValaCCodeModule* self, ValaPointerIndirection* expr);
	void (*visit_addressof_expression) (ValaCCodeModule* self, ValaAddressofExpression* expr);
	void (*visit_reference_transfer_expression) (ValaCCodeModule* self, ValaReferenceTransferExpression* expr);
	void (*visit_binary_expression) (ValaCCodeModule* self, ValaBinaryExpression* expr);
	void (*visit_type_check) (ValaCCodeModule* self, ValaTypeCheck* expr);
	void (*visit_lambda_expression) (ValaCCodeModule* self, ValaLambdaExpression* l);
	void (*visit_assignment) (ValaCCodeModule* self, ValaAssignment* a);
	char* (*get_custom_creturn_type) (ValaCCodeModule* self, ValaMethod* m);
	void (*generate_dynamic_method_wrapper) (ValaCCodeModule* self, ValaDynamicMethod* method);
	gboolean (*method_has_wrapper) (ValaCCodeModule* self, ValaMethod* method);
	ValaCCodeIdentifier* (*get_value_setter_function) (ValaCCodeModule* self, ValaDataType* type_reference);
	ValaCCodeExpression* (*get_construct_property_assignment) (ValaCCodeModule* self, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value);
	ValaCCodeFunctionCall* (*get_param_spec) (ValaCCodeModule* self, ValaProperty* prop);
	ValaCCodeFunctionCall* (*get_signal_creation) (ValaCCodeModule* self, ValaSignal* sig, ValaTypeSymbol* type);
	ValaCCodeFragment* (*register_dbus_info) (ValaCCodeModule* self, ValaObjectTypeSymbol* bindable);
	char* (*get_dynamic_property_getter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_property_setter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_signal_cname) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_connect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_disconnect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	void (*generate_marshaller) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, gboolean dbus);
	char* (*get_marshaller_function) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, const char* prefix, gboolean dbus);
	char* (*get_array_length_cname) (ValaCCodeModule* self, const char* array_cname, gint dim);
	ValaCCodeExpression* (*get_array_length_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
	char* (*get_array_size_cname) (ValaCCodeModule* self, const char* array_cname);
	ValaCCodeExpression* (*get_array_size_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr);
	void (*add_simple_check) (ValaCCodeModule* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
};

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeBaseModule {
	ValaCCodeModule parent_instance;
	ValaCCodeBaseModulePrivate * priv;
	ValaSymbol* root_symbol;
	ValaSymbol* current_symbol;
	ValaTypeSymbol* current_type_symbol;
	ValaClass* current_class;
	ValaMethod* current_method;
	ValaDataType* current_return_type;
	ValaTryStatement* current_try;
	ValaPropertyAccessor* current_property_accessor;
	ValaCCodeDeclarationSpace* header_declarations;
	ValaCCodeDeclarationSpace* internal_header_declarations;
	ValaCCodeDeclarationSpace* source_declarations;
	ValaCCodeFragment* source_signal_marshaller_declaration;
	ValaCCodeFragment* source_type_member_definition;
	ValaCCodeFragment* class_init_fragment;
	ValaCCodeFragment* base_init_fragment;
	ValaCCodeFragment* class_finalize_fragment;
	ValaCCodeFragment* base_finalize_fragment;
	ValaCCodeFragment* instance_init_fragment;
	ValaCCodeFragment* instance_finalize_fragment;
	ValaCCodeFragment* source_signal_marshaller_definition;
	ValaCCodeFragment* module_init_fragment;
	ValaCCodeStruct* param_spec_struct;
	ValaCCodeStruct* closure_struct;
	ValaCCodeEnum* prop_enum;
	ValaCCodeFunction* function;
	ValaCCodeFragment* pre_statement_fragment;
	GeeArrayList* temp_vars;
	GeeArrayList* temp_ref_vars;
	GeeSet* user_marshal_set;
	GeeSet* predefined_marshal_set;
	gint next_temp_var_id;
	gboolean in_creation_method;
	gboolean in_constructor;
	gboolean in_static_or_class_ctor;
	gboolean current_method_inner_error;
	gint next_coroutine_state;
	ValaDataType* bool_type;
	ValaDataType* char_type;
	ValaDataType* uchar_type;
	ValaDataType* unichar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* int8_type;
	ValaDataType* uint8_type;
	ValaDataType* int16_type;
	ValaDataType* uint16_type;
	ValaDataType* int32_type;
	ValaDataType* uint32_type;
	ValaDataType* int64_type;
	ValaDataType* uint64_type;
	ValaDataType* string_type;
	ValaDataType* float_type;
	ValaDataType* double_type;
	ValaTypeSymbol* gtype_type;
	ValaTypeSymbol* gobject_type;
	ValaErrorType* gerror_type;
	ValaClass* glist_type;
	ValaClass* gslist_type;
	ValaTypeSymbol* gstringbuilder_type;
	ValaTypeSymbol* garray_type;
	ValaTypeSymbol* gbytearray_type;
	ValaTypeSymbol* gptrarray_type;
	ValaDataType* gquark_type;
	ValaStruct* gvalue_type;
	ValaStruct* mutex_type;
	ValaTypeSymbol* type_module_type;
	ValaTypeSymbol* dbus_object_type;
	gboolean in_plugin;
	char* module_init_param_name;
	gboolean gvaluecollector_h_needed;
	gboolean gio_h_needed;
	gboolean requires_array_free;
	gboolean requires_array_move;
	gboolean requires_array_length;
	gboolean requires_strcmp0;
	gboolean dbus_glib_h_needed;
	gboolean dbus_glib_h_needed_in_header;
	GeeSet* wrappers;
	GeeMap* variable_name_map;
};

struct _ValaCCodeBaseModuleClass {
	ValaCCodeModuleClass parent_class;
	void (*append_vala_array_free) (ValaCCodeBaseModule* self);
	void (*append_vala_array_move) (ValaCCodeBaseModule* self);
	void (*append_vala_array_length) (ValaCCodeBaseModule* self);
	void (*generate_class_struct_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_struct_declaration) (ValaCCodeBaseModule* self, ValaStruct* st, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_delegate_declaration) (ValaCCodeBaseModule* self, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_cparameters) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
	ValaCCodeExpression* (*get_dup_func_expression) (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference);
	ValaCCodeExpression* (*get_unref_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr);
	char* (*get_delegate_target_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_delegate_target_cexpression) (ValaCCodeBaseModule* self, ValaExpression* delegate_expr);
	char* (*get_delegate_target_destroy_notify_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_ref_cexpression) (ValaCCodeBaseModule* self, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node);
	void (*generate_class_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_interface_declaration) (ValaCCodeBaseModule* self, ValaInterface* iface, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_method_declaration) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_error_domain_declaration) (ValaCCodeBaseModule* self, ValaErrorDomain* edomain, ValaCCodeDeclarationSpace* decl_space);
	ValaCCodeExpression* (*get_implicit_cast_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
};

struct _ValaCCodeStructModule {
	ValaCCodeBaseModule parent_instance;
	ValaCCodeStructModulePrivate * priv;
};

struct _ValaCCodeStructModuleClass {
	ValaCCodeBaseModuleClass parent_class;
};

/**
 * The link between a method and generated code.
 */
struct _ValaCCodeMethodModule {
	ValaCCodeStructModule parent_instance;
	ValaCCodeMethodModulePrivate * priv;
};

struct _ValaCCodeMethodModuleClass {
	ValaCCodeStructModuleClass parent_class;
	void (*generate_method_result_declaration) (ValaCCodeMethodModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeFunction* cfunc, GeeMap* cparam_map, GeeMap* carg_map);
	void (*generate_parameter) (ValaCCodeMethodModule* self, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map);
};

struct _ValaCCodeControlFlowModule {
	ValaCCodeMethodModule parent_instance;
	ValaCCodeControlFlowModulePrivate * priv;
};

struct _ValaCCodeControlFlowModuleClass {
	ValaCCodeMethodModuleClass parent_class;
};

struct _ValaCCodeMemberAccessModule {
	ValaCCodeControlFlowModule parent_instance;
	ValaCCodeMemberAccessModulePrivate * priv;
};

struct _ValaCCodeMemberAccessModuleClass {
	ValaCCodeControlFlowModuleClass parent_class;
};

/**
 * The link between an assignment and generated code.
 */
struct _ValaCCodeAssignmentModule {
	ValaCCodeMemberAccessModule parent_instance;
	ValaCCodeAssignmentModulePrivate * priv;
};

struct _ValaCCodeAssignmentModuleClass {
	ValaCCodeMemberAccessModuleClass parent_class;
};

struct _ValaCCodeMethodCallModule {
	ValaCCodeAssignmentModule parent_instance;
	ValaCCodeMethodCallModulePrivate * priv;
};

struct _ValaCCodeMethodCallModuleClass {
	ValaCCodeAssignmentModuleClass parent_class;
};

struct _ValaCCodeArrayModule {
	ValaCCodeMethodCallModule parent_instance;
	ValaCCodeArrayModulePrivate * priv;
};

struct _ValaCCodeArrayModuleClass {
	ValaCCodeMethodCallModuleClass parent_class;
};

/**
 * The link between an assignment and generated code.
 */
struct _ValaCCodeDelegateModule {
	ValaCCodeArrayModule parent_instance;
	ValaCCodeDelegateModulePrivate * priv;
};

struct _ValaCCodeDelegateModuleClass {
	ValaCCodeArrayModuleClass parent_class;
};

struct _ValaGErrorModule {
	ValaCCodeDelegateModule parent_instance;
	ValaGErrorModulePrivate * priv;
};

struct _ValaGErrorModuleClass {
	ValaCCodeDelegateModuleClass parent_class;
	ValaCCodeStatement* (*return_with_exception) (ValaGErrorModule* self, ValaCCodeExpression* error_expr);
};

struct _ValaGTypeModule {
	ValaGErrorModule parent_instance;
	ValaGTypeModulePrivate * priv;
};

struct _ValaGTypeModuleClass {
	ValaGErrorModuleClass parent_class;
	void (*generate_virtual_method_declaration) (ValaGTypeModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeStruct* type_struct);
	void (*generate_class_init) (ValaGTypeModule* self, ValaClass* cl, ValaCCodeBlock* init_block);
};

struct _ValaGObjectModule {
	ValaGTypeModule parent_instance;
	ValaGObjectModulePrivate * priv;
};

struct _ValaGObjectModuleClass {
	ValaGTypeModuleClass parent_class;
};

struct _ValaGSignalModule {
	ValaGObjectModule parent_instance;
	ValaGSignalModulePrivate * priv;
};

struct _ValaGSignalModuleClass {
	ValaGObjectModuleClass parent_class;
	ValaCCodeExpression* (*get_dbus_g_type) (ValaGSignalModule* self, ValaDataType* data_type);
};

struct _ValaGAsyncModule {
	ValaGSignalModule parent_instance;
	ValaGAsyncModulePrivate * priv;
};

struct _ValaGAsyncModuleClass {
	ValaGSignalModuleClass parent_class;
};

struct _ValaDBusModule {
	ValaGAsyncModule parent_instance;
	ValaDBusModulePrivate * priv;
};

struct _ValaDBusModuleClass {
	ValaGAsyncModuleClass parent_class;
};

struct _ValaDBusModuleBasicTypeInfo {
	const char* signature;
	const char* type_name;
	const char* cname;
	const char* gtype;
	const char* get_value_function;
	const char* set_value_function;
};



gpointer vala_ccode_module_ref (gpointer instance);
void vala_ccode_module_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_module (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_module (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_module (const GValue* value);
GType vala_ccode_module_get_type (void);
GType vala_ccode_base_module_get_type (void);
gpointer vala_ccode_declaration_space_ref (gpointer instance);
void vala_ccode_declaration_space_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_declaration_space (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_declaration_space (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_declaration_space (const GValue* value);
GType vala_ccode_declaration_space_get_type (void);
GType vala_ccode_struct_module_get_type (void);
GType vala_ccode_method_module_get_type (void);
GType vala_ccode_control_flow_module_get_type (void);
GType vala_ccode_member_access_module_get_type (void);
GType vala_ccode_assignment_module_get_type (void);
GType vala_ccode_method_call_module_get_type (void);
GType vala_ccode_array_module_get_type (void);
GType vala_ccode_delegate_module_get_type (void);
GType vala_gerror_module_get_type (void);
GType vala_gtype_module_get_type (void);
GType vala_gobject_module_get_type (void);
GType vala_gsignal_module_get_type (void);
GType vala_gasync_module_get_type (void);
GType vala_dbus_module_get_type (void);
enum  {
	VALA_DBUS_MODULE_DUMMY_PROPERTY
};
GType vala_ccode_generator_get_type (void);
ValaGAsyncModule* vala_gasync_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaGAsyncModule* vala_gasync_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaDBusModule* vala_dbus_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaDBusModule* vala_dbus_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaDBusModule* vala_dbus_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
static GType vala_dbus_module_basic_type_info_get_type (void);
static gboolean vala_dbus_module_get_basic_type_info (ValaDBusModule* self, const char* signature, ValaDBusModuleBasicTypeInfo* basic_type);
static ValaCCodeExpression* vala_dbus_module_get_array_length (ValaDBusModule* self, ValaCCodeExpression* expr, gint dim);
static ValaCCodeExpression* vala_dbus_module_read_basic (ValaDBusModule* self, ValaCCodeFragment* fragment, const ValaDBusModuleBasicTypeInfo* basic_type, ValaCCodeExpression* iter_expr);
static void vala_dbus_module_read_array_dim (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaArrayType* array_type, gint dim, const char* temp_name, ValaCCodeExpression* iter_expr, ValaCCodeExpression* expr);
static ValaCCodeExpression* vala_dbus_module_read_array (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaArrayType* array_type, ValaCCodeExpression* iter_expr, ValaCCodeExpression* expr);
ValaCCodeExpression* vala_dbus_module_read_expression (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaDataType* type, ValaCCodeExpression* iter_expr, ValaCCodeExpression* expr);
static ValaCCodeExpression* vala_dbus_module_read_struct (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaStruct* st, ValaCCodeExpression* iter_expr);
static ValaCCodeExpression* vala_dbus_module_read_value (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaCCodeExpression* iter_expr);
ValaCCodeExpression* vala_ccode_base_module_convert_to_generic_pointer (ValaCCodeBaseModule* self, ValaCCodeExpression* cexpr, ValaDataType* actual_type);
static ValaCCodeExpression* vala_dbus_module_read_hash_table (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaObjectType* type, ValaCCodeExpression* iter_expr);
static void vala_dbus_module_write_basic (ValaDBusModule* self, ValaCCodeFragment* fragment, const ValaDBusModuleBasicTypeInfo* basic_type, ValaCCodeExpression* iter_expr, ValaCCodeExpression* expr);
static void vala_dbus_module_write_array_dim (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaArrayType* array_type, gint dim, ValaCCodeExpression* iter_expr, ValaCCodeExpression* array_expr, ValaCCodeExpression* array_iter_expr);
static void vala_dbus_module_write_array (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaArrayType* array_type, ValaCCodeExpression* iter_expr, ValaCCodeExpression* array_expr);
void vala_dbus_module_write_expression (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaDataType* type, ValaCCodeExpression* iter_expr, ValaCCodeExpression* expr);
static void vala_dbus_module_write_struct (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaStruct* st, ValaCCodeExpression* iter_expr, ValaCCodeExpression* struct_expr);
static void vala_dbus_module_write_value (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaCCodeExpression* iter_expr, ValaCCodeExpression* expr);
ValaCCodeExpression* vala_ccode_base_module_convert_from_generic_pointer (ValaCCodeBaseModule* self, ValaCCodeExpression* cexpr, ValaDataType* actual_type);
static void vala_dbus_module_write_hash_table (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaObjectType* type, ValaCCodeExpression* iter_expr, ValaCCodeExpression* hash_table_expr);
static ValaDBusModuleBasicTypeInfo* vala_dbus_module_basic_type_info_dup (const ValaDBusModuleBasicTypeInfo* self);
static void vala_dbus_module_basic_type_info_free (ValaDBusModuleBasicTypeInfo* self);
static gpointer vala_dbus_module_parent_class = NULL;
static int _vala_strcmp0 (const char * str1, const char * str2);

static const ValaDBusModuleBasicTypeInfo VALA_DBUS_MODULE_basic_types[] = {{"y", "BYTE", "guint8", "G_TYPE_UCHAR", "g_value_get_uchar", "g_value_set_uchar"}, {"b", "BOOLEAN", "dbus_bool_t", "G_TYPE_BOOLEAN", "g_value_get_boolean", "g_value_set_boolean"}, {"n", "INT16", "dbus_int16_t", "G_TYPE_INT", NULL, "g_value_set_int"}, {"q", "UINT16", "dbus_uint16_t", "G_TYPE_UINT", NULL, "g_value_set_uint"}, {"i", "INT32", "dbus_int32_t", "G_TYPE_INT", "g_value_get_int", "g_value_set_int"}, {"u", "UINT32", "dbus_uint32_t", "G_TYPE_UINT", "g_value_get_uint", "g_value_set_uint"}, {"x", "INT64", "dbus_int64_t", "G_TYPE_INT64", "g_value_get_int64", "g_value_set_int64"}, {"t", "UINT64", "dbus_uint64_t", "G_TYPE_UINT64", "g_value_get_uint64", "g_value_set_uint64"}, {"d", "DOUBLE", "double", "G_TYPE_DOUBLE", "g_value_get_double", "g_value_set_double"}, {"s", "STRING", "const char*", "G_TYPE_STRING", "g_value_get_string", "g_value_take_string"}, {"o", "OBJECT_PATH", "const char*", "G_TYPE_STRING", NULL, "g_value_take_string"}, {"g", "SIGNATURE", "const char*", "G_TYPE_STRING", NULL, "g_value_take_string"}};


ValaDBusModule* vala_dbus_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaDBusModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaDBusModule*) vala_gasync_module_construct (object_type, codegen, next);
	return self;
}


ValaDBusModule* vala_dbus_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_dbus_module_construct (VALA_TYPE_DBUS_MODULE, codegen, next);
}


static gboolean vala_dbus_module_get_basic_type_info (ValaDBusModule* self, const char* signature, ValaDBusModuleBasicTypeInfo* basic_type) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (signature != NULL, FALSE);
	{
		ValaDBusModuleBasicTypeInfo* info_collection;
		int info_collection_length1;
		int info_it;
		info_collection = VALA_DBUS_MODULE_basic_types;
		info_collection_length1 = G_N_ELEMENTS (VALA_DBUS_MODULE_basic_types);
		for (info_it = 0; info_it < G_N_ELEMENTS (VALA_DBUS_MODULE_basic_types); info_it = info_it + 1) {
			ValaDBusModuleBasicTypeInfo info;
			info = info_collection[info_it];
			{
				if (_vala_strcmp0 (info.signature, signature) == 0) {
					(*basic_type) = info;
					return TRUE;
				}
			}
		}
	}
	return FALSE;
}


static ValaCCodeExpression* vala_dbus_module_get_array_length (ValaDBusModule* self, ValaCCodeExpression* expr, gint dim) {
	ValaCCodeIdentifier* _tmp1_;
	ValaCCodeExpression* _tmp0_;
	ValaCCodeIdentifier* id;
	ValaCCodeMemberAccess* _tmp3_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeMemberAccess* ma;
	ValaCCodeExpression* _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	id = (_tmp1_ = (_tmp0_ = expr, VALA_IS_CCODE_IDENTIFIER (_tmp0_) ? ((ValaCCodeIdentifier*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : vala_ccode_node_ref (_tmp1_));
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	ma = (_tmp3_ = (_tmp2_ = expr, VALA_IS_CCODE_MEMBER_ACCESS (_tmp2_) ? ((ValaCCodeMemberAccess*) _tmp2_) : NULL), (_tmp3_ == NULL) ? NULL : vala_ccode_node_ref (_tmp3_));
	if (id != NULL) {
		char* _tmp4_;
		ValaCCodeExpression* _tmp5_;
		ValaCCodeExpression* _tmp6_;
		_tmp4_ = NULL;
		_tmp5_ = NULL;
		_tmp6_ = NULL;
		return (_tmp6_ = (_tmp5_ = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp4_ = g_strdup_printf ("%s_length%d", vala_ccode_identifier_get_name (id), dim)), _tmp4_ = (g_free (_tmp4_), NULL), _tmp5_), (id == NULL) ? NULL : (id = (vala_ccode_node_unref (id), NULL)), (ma == NULL) ? NULL : (ma = (vala_ccode_node_unref (ma), NULL)), _tmp6_);
	} else {
		if (ma != NULL) {
			char* _tmp7_;
			ValaCCodeExpression* _tmp8_;
			ValaCCodeExpression* _tmp9_;
			_tmp7_ = NULL;
			_tmp8_ = NULL;
			_tmp9_ = NULL;
			return (_tmp9_ = (_tmp8_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (vala_ccode_member_access_get_inner (ma), _tmp7_ = g_strdup_printf ("%s_length%d", vala_ccode_member_access_get_member_name (ma), dim)), _tmp7_ = (g_free (_tmp7_), NULL), _tmp8_), (id == NULL) ? NULL : (id = (vala_ccode_node_unref (id), NULL)), (ma == NULL) ? NULL : (ma = (vala_ccode_node_unref (ma), NULL)), _tmp9_);
		}
	}
	_tmp10_ = NULL;
	return (_tmp10_ = NULL, (id == NULL) ? NULL : (id = (vala_ccode_node_unref (id), NULL)), (ma == NULL) ? NULL : (ma = (vala_ccode_node_unref (ma), NULL)), _tmp10_);
}


static ValaCCodeExpression* vala_dbus_module_read_basic (ValaDBusModule* self, ValaCCodeFragment* fragment, const ValaDBusModuleBasicTypeInfo* basic_type, ValaCCodeExpression* iter_expr) {
	char* temp_name;
	ValaCCodeDeclaration* _cdecl_;
	ValaCCodeVariableDeclarator* _tmp0_;
	ValaCCodeIdentifier* _tmp1_;
	ValaCCodeFunctionCall* _tmp2_;
	ValaCCodeFunctionCall* iter_call;
	ValaCCodeUnaryExpression* _tmp3_;
	ValaCCodeUnaryExpression* _tmp5_;
	ValaCCodeIdentifier* _tmp4_;
	ValaCCodeExpressionStatement* _tmp6_;
	ValaCCodeIdentifier* temp_result;
	gboolean _tmp7_;
	gboolean _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (fragment != NULL, NULL);
	g_return_val_if_fail (iter_expr != NULL, NULL);
	temp_name = g_strdup_printf ("_tmp%d_", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	_cdecl_ = vala_ccode_declaration_new ((*basic_type).cname);
	_tmp0_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp0_ = vala_ccode_variable_declarator_new (temp_name, NULL, NULL)));
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) _cdecl_);
	_tmp1_ = NULL;
	_tmp2_ = NULL;
	iter_call = (_tmp2_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp1_ = vala_ccode_identifier_new ("dbus_message_iter_get_basic"))), (_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL)), _tmp2_);
	_tmp3_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp3_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, iter_expr)));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	_tmp5_ = NULL;
	_tmp4_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp5_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp4_ = vala_ccode_identifier_new (temp_name)))));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	_tmp6_ = NULL;
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp6_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	temp_result = vala_ccode_identifier_new (temp_name);
	_tmp7_ = FALSE;
	_tmp8_ = FALSE;
	if (_vala_strcmp0 ((*basic_type).signature, "s") == 0) {
		_tmp8_ = TRUE;
	} else {
		_tmp8_ = _vala_strcmp0 ((*basic_type).signature, "o") == 0;
	}
	if (_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		_tmp7_ = _vala_strcmp0 ((*basic_type).signature, "g") == 0;
	}
	if (_tmp7_) {
		ValaCCodeIdentifier* _tmp9_;
		ValaCCodeFunctionCall* _tmp10_;
		ValaCCodeFunctionCall* dup_call;
		ValaCCodeExpression* _tmp11_;
		_tmp9_ = NULL;
		_tmp10_ = NULL;
		dup_call = (_tmp10_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp9_ = vala_ccode_identifier_new ("g_strdup"))), (_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL)), _tmp10_);
		vala_ccode_function_call_add_argument (dup_call, (ValaCCodeExpression*) temp_result);
		_tmp11_ = NULL;
		return (_tmp11_ = (ValaCCodeExpression*) dup_call, temp_name = (g_free (temp_name), NULL), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), (temp_result == NULL) ? NULL : (temp_result = (vala_ccode_node_unref (temp_result), NULL)), _tmp11_);
	} else {
		ValaCCodeExpression* _tmp12_;
		_tmp12_ = NULL;
		return (_tmp12_ = (ValaCCodeExpression*) temp_result, temp_name = (g_free (temp_name), NULL), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp12_);
	}
	temp_name = (g_free (temp_name), NULL);
	(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
	(iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL));
	(temp_result == NULL) ? NULL : (temp_result = (vala_ccode_node_unref (temp_result), NULL));
}


static ValaCCodeExpression* vala_dbus_module_read_array (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaArrayType* array_type, ValaCCodeExpression* iter_expr, ValaCCodeExpression* expr) {
	char* temp_name;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeFunctionCall* _tmp1_;
	ValaCCodeFunctionCall* new_call;
	ValaCCodeIdentifier* _tmp3_;
	char* _tmp2_;
	ValaCCodeConstant* _tmp4_;
	char* _tmp5_;
	ValaCCodeDeclaration* _tmp6_;
	ValaCCodeDeclaration* _cdecl_;
	ValaCCodeVariableDeclarator* _tmp7_;
	ValaCCodeDeclaration* _tmp8_;
	ValaCCodeVariableDeclarator* _tmp11_;
	ValaCCodeConstant* _tmp10_;
	char* _tmp9_;
	ValaCCodeDeclaration* _tmp12_;
	ValaCCodeVariableDeclarator* _tmp15_;
	ValaCCodeConstant* _tmp14_;
	char* _tmp13_;
	ValaCCodeExpression* _tmp23_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (fragment != NULL, NULL);
	g_return_val_if_fail (array_type != NULL, NULL);
	g_return_val_if_fail (iter_expr != NULL, NULL);
	temp_name = g_strdup_printf ("_tmp%d_", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	new_call = (_tmp1_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0_ = vala_ccode_identifier_new ("g_new"))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL)), _tmp1_);
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	vala_ccode_function_call_add_argument (new_call, (ValaCCodeExpression*) (_tmp3_ = vala_ccode_identifier_new (_tmp2_ = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	_tmp2_ = (g_free (_tmp2_), NULL);
	/* add one extra element for NULL-termination*/
	_tmp4_ = NULL;
	vala_ccode_function_call_add_argument (new_call, (ValaCCodeExpression*) (_tmp4_ = vala_ccode_constant_new ("5")));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	_tmp5_ = NULL;
	_tmp6_ = NULL;
	_cdecl_ = (_tmp6_ = vala_ccode_declaration_new (_tmp5_ = vala_data_type_get_cname ((ValaDataType*) array_type)), _tmp5_ = (g_free (_tmp5_), NULL), _tmp6_);
	_tmp7_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp7_ = vala_ccode_variable_declarator_new (temp_name, (ValaCCodeExpression*) new_call, NULL)));
	(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) _cdecl_);
	_tmp8_ = NULL;
	_cdecl_ = (_tmp8_ = vala_ccode_declaration_new ("int"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp8_);
	_tmp11_ = NULL;
	_tmp10_ = NULL;
	_tmp9_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp11_ = vala_ccode_variable_declarator_new (_tmp9_ = g_strconcat (temp_name, "_length", NULL), (ValaCCodeExpression*) (_tmp10_ = vala_ccode_constant_new ("0")), NULL)));
	(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
	(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
	_tmp9_ = (g_free (_tmp9_), NULL);
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) _cdecl_);
	_tmp12_ = NULL;
	_cdecl_ = (_tmp12_ = vala_ccode_declaration_new ("int"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp12_);
	_tmp15_ = NULL;
	_tmp14_ = NULL;
	_tmp13_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp15_ = vala_ccode_variable_declarator_new (_tmp13_ = g_strconcat (temp_name, "_size", NULL), (ValaCCodeExpression*) (_tmp14_ = vala_ccode_constant_new ("4")), NULL)));
	(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
	(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
	_tmp13_ = (g_free (_tmp13_), NULL);
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) _cdecl_);
	vala_dbus_module_read_array_dim (self, fragment, array_type, 1, temp_name, iter_expr, expr);
	if (vala_data_type_is_reference_type_or_type_parameter (vala_array_type_get_element_type (array_type))) {
		char* _tmp16_;
		ValaCCodeIdentifier* _tmp17_;
		ValaCCodeIdentifier* length;
		ValaCCodeIdentifier* _tmp18_;
		ValaCCodeElementAccess* _tmp19_;
		ValaCCodeElementAccess* element_access;
		ValaCCodeExpressionStatement* _tmp22_;
		ValaCCodeAssignment* _tmp21_;
		ValaCCodeIdentifier* _tmp20_;
		/* NULL terminate array*/
		_tmp16_ = NULL;
		_tmp17_ = NULL;
		length = (_tmp17_ = vala_ccode_identifier_new (_tmp16_ = g_strconcat (temp_name, "_length", NULL)), _tmp16_ = (g_free (_tmp16_), NULL), _tmp17_);
		_tmp18_ = NULL;
		_tmp19_ = NULL;
		element_access = (_tmp19_ = vala_ccode_element_access_new ((ValaCCodeExpression*) (_tmp18_ = vala_ccode_identifier_new (temp_name)), (ValaCCodeExpression*) length), (_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL)), _tmp19_);
		_tmp22_ = NULL;
		_tmp21_ = NULL;
		_tmp20_ = NULL;
		vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp22_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp21_ = vala_ccode_assignment_new ((ValaCCodeExpression*) element_access, (ValaCCodeExpression*) (_tmp20_ = vala_ccode_identifier_new ("NULL")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
		(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
		(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL));
		(length == NULL) ? NULL : (length = (vala_ccode_node_unref (length), NULL));
		(element_access == NULL) ? NULL : (element_access = (vala_ccode_node_unref (element_access), NULL));
	}
	_tmp23_ = NULL;
	return (_tmp23_ = (ValaCCodeExpression*) vala_ccode_identifier_new (temp_name), temp_name = (g_free (temp_name), NULL), (new_call == NULL) ? NULL : (new_call = (vala_ccode_node_unref (new_call), NULL)), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp23_);
}


static void vala_dbus_module_read_array_dim (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaArrayType* array_type, gint dim, const char* temp_name, ValaCCodeExpression* iter_expr, ValaCCodeExpression* expr) {
	char* subiter_name;
	ValaCCodeDeclaration* _cdecl_;
	ValaCCodeVariableDeclarator* _tmp2_;
	ValaCCodeConstant* _tmp1_;
	char* _tmp0_;
	ValaCCodeDeclaration* _tmp3_;
	ValaCCodeVariableDeclarator* _tmp4_;
	ValaCCodeIdentifier* _tmp5_;
	ValaCCodeFunctionCall* _tmp6_;
	ValaCCodeFunctionCall* iter_call;
	ValaCCodeUnaryExpression* _tmp7_;
	ValaCCodeUnaryExpression* _tmp9_;
	ValaCCodeIdentifier* _tmp8_;
	ValaCCodeExpressionStatement* _tmp10_;
	ValaCCodeFunctionCall* _tmp12_;
	ValaCCodeIdentifier* _tmp11_;
	ValaCCodeUnaryExpression* _tmp14_;
	ValaCCodeIdentifier* _tmp13_;
	ValaCCodeBlock* cforblock;
	ValaCCodeFragment* cforfragment;
	ValaCCodeForStatement* cfor;
	ValaCCodeUnaryExpression* _tmp17_;
	ValaCCodeIdentifier* _tmp16_;
	char* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (fragment != NULL);
	g_return_if_fail (array_type != NULL);
	g_return_if_fail (temp_name != NULL);
	g_return_if_fail (iter_expr != NULL);
	subiter_name = g_strdup_printf ("_tmp%d_", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	_cdecl_ = vala_ccode_declaration_new ("int");
	_tmp2_ = NULL;
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp2_ = vala_ccode_variable_declarator_new (_tmp0_ = g_strdup_printf ("%s_length%d", temp_name, dim), (ValaCCodeExpression*) (_tmp1_ = vala_ccode_constant_new ("0")), NULL)));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL));
	_tmp0_ = (g_free (_tmp0_), NULL);
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) _cdecl_);
	_tmp3_ = NULL;
	_cdecl_ = (_tmp3_ = vala_ccode_declaration_new ("DBusMessageIter"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp3_);
	_tmp4_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp4_ = vala_ccode_variable_declarator_new (subiter_name, NULL, NULL)));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) _cdecl_);
	_tmp5_ = NULL;
	_tmp6_ = NULL;
	iter_call = (_tmp6_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp5_ = vala_ccode_identifier_new ("dbus_message_iter_recurse"))), (_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL)), _tmp6_);
	_tmp7_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp7_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, iter_expr)));
	(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
	_tmp9_ = NULL;
	_tmp8_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp9_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp8_ = vala_ccode_identifier_new (subiter_name)))));
	(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
	(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
	_tmp10_ = NULL;
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp10_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
	_tmp12_ = NULL;
	_tmp11_ = NULL;
	iter_call = (_tmp12_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp11_ = vala_ccode_identifier_new ("dbus_message_iter_get_arg_type"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp12_);
	(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
	_tmp14_ = NULL;
	_tmp13_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp14_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp13_ = vala_ccode_identifier_new (subiter_name)))));
	(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
	(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
	cforblock = vala_ccode_block_new ();
	cforfragment = vala_ccode_fragment_new ();
	vala_ccode_block_add_statement (cforblock, (ValaCCodeNode*) cforfragment);
	cfor = vala_ccode_for_statement_new ((ValaCCodeExpression*) iter_call, (ValaCCodeStatement*) cforblock);
	_tmp17_ = NULL;
	_tmp16_ = NULL;
	_tmp15_ = NULL;
	vala_ccode_for_statement_add_iterator (cfor, (ValaCCodeExpression*) (_tmp17_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, (ValaCCodeExpression*) (_tmp16_ = vala_ccode_identifier_new (_tmp15_ = g_strdup_printf ("%s_length%d", temp_name, dim))))));
	(_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL));
	(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
	_tmp15_ = (g_free (_tmp15_), NULL);
	if (dim < vala_array_type_get_rank (array_type)) {
		ValaCCodeIdentifier* _tmp18_;
		ValaCCodeFunctionCall* _tmp20_;
		ValaCCodeIdentifier* _tmp19_;
		ValaCCodeUnaryExpression* _tmp22_;
		ValaCCodeIdentifier* _tmp21_;
		ValaCCodeExpressionStatement* _tmp23_;
		_tmp18_ = NULL;
		vala_dbus_module_read_array_dim (self, cforfragment, array_type, dim + 1, temp_name, (ValaCCodeExpression*) (_tmp18_ = vala_ccode_identifier_new (subiter_name)), expr);
		(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL));
		_tmp20_ = NULL;
		_tmp19_ = NULL;
		iter_call = (_tmp20_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp19_ = vala_ccode_identifier_new ("dbus_message_iter_next"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp20_);
		(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
		_tmp22_ = NULL;
		_tmp21_ = NULL;
		vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp22_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp21_ = vala_ccode_identifier_new (subiter_name)))));
		(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
		(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
		_tmp23_ = NULL;
		vala_ccode_fragment_append (cforfragment, (ValaCCodeNode*) (_tmp23_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
		(_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL));
	} else {
		ValaCCodeIdentifier* _tmp27_;
		char* _tmp26_;
		ValaCCodeIdentifier* _tmp25_;
		char* _tmp24_;
		ValaCCodeBinaryExpression* _tmp28_;
		ValaCCodeBinaryExpression* size_check;
		ValaCCodeBlock* renew_block;
		ValaCCodeIdentifier* _tmp31_;
		char* _tmp30_;
		ValaCCodeConstant* _tmp29_;
		ValaCCodeBinaryExpression* _tmp32_;
		ValaCCodeBinaryExpression* new_size;
		ValaCCodeExpressionStatement* _tmp36_;
		ValaCCodeAssignment* _tmp35_;
		ValaCCodeIdentifier* _tmp34_;
		char* _tmp33_;
		ValaCCodeIdentifier* _tmp37_;
		ValaCCodeFunctionCall* _tmp38_;
		ValaCCodeFunctionCall* renew_call;
		ValaCCodeIdentifier* _tmp40_;
		char* _tmp39_;
		ValaCCodeIdentifier* _tmp41_;
		ValaCCodeBinaryExpression* _tmp45_;
		ValaCCodeConstant* _tmp44_;
		ValaCCodeIdentifier* _tmp43_;
		char* _tmp42_;
		ValaCCodeAssignment* _tmp47_;
		ValaCCodeIdentifier* _tmp46_;
		ValaCCodeExpressionStatement* _tmp48_;
		ValaCCodeExpressionStatement* renew_stmt;
		ValaCCodeIfStatement* cif;
		ValaCCodeUnaryExpression* _tmp52_;
		ValaCCodeIdentifier* _tmp51_;
		char* _tmp50_;
		ValaCCodeIdentifier* _tmp49_;
		ValaCCodeElementAccess* _tmp53_;
		ValaCCodeElementAccess* element_access;
		ValaCCodeIdentifier* _tmp54_;
		ValaCCodeExpression* _tmp55_;
		ValaCCodeExpression* element_expr;
		ValaCCodeExpressionStatement* _tmp57_;
		ValaCCodeAssignment* _tmp56_;
		_tmp27_ = NULL;
		_tmp26_ = NULL;
		_tmp25_ = NULL;
		_tmp24_ = NULL;
		_tmp28_ = NULL;
		size_check = (_tmp28_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) (_tmp25_ = vala_ccode_identifier_new (_tmp24_ = g_strconcat (temp_name, "_size", NULL))), (ValaCCodeExpression*) (_tmp27_ = vala_ccode_identifier_new (_tmp26_ = g_strconcat (temp_name, "_length", NULL)))), (_tmp27_ == NULL) ? NULL : (_tmp27_ = (vala_ccode_node_unref (_tmp27_), NULL)), _tmp26_ = (g_free (_tmp26_), NULL), (_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_ccode_node_unref (_tmp25_), NULL)), _tmp24_ = (g_free (_tmp24_), NULL), _tmp28_);
		renew_block = vala_ccode_block_new ();
		/* tmp_size = (2 * tmp_size);*/
		_tmp31_ = NULL;
		_tmp30_ = NULL;
		_tmp29_ = NULL;
		_tmp32_ = NULL;
		new_size = (_tmp32_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) (_tmp29_ = vala_ccode_constant_new ("2")), (ValaCCodeExpression*) (_tmp31_ = vala_ccode_identifier_new (_tmp30_ = g_strconcat (temp_name, "_size", NULL)))), (_tmp31_ == NULL) ? NULL : (_tmp31_ = (vala_ccode_node_unref (_tmp31_), NULL)), _tmp30_ = (g_free (_tmp30_), NULL), (_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL)), _tmp32_);
		_tmp36_ = NULL;
		_tmp35_ = NULL;
		_tmp34_ = NULL;
		_tmp33_ = NULL;
		vala_ccode_block_add_statement (renew_block, (ValaCCodeNode*) (_tmp36_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp35_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp34_ = vala_ccode_identifier_new (_tmp33_ = g_strconcat (temp_name, "_size", NULL))), (ValaCCodeExpression*) new_size, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp36_ == NULL) ? NULL : (_tmp36_ = (vala_ccode_node_unref (_tmp36_), NULL));
		(_tmp35_ == NULL) ? NULL : (_tmp35_ = (vala_ccode_node_unref (_tmp35_), NULL));
		(_tmp34_ == NULL) ? NULL : (_tmp34_ = (vala_ccode_node_unref (_tmp34_), NULL));
		_tmp33_ = (g_free (_tmp33_), NULL);
		_tmp37_ = NULL;
		_tmp38_ = NULL;
		renew_call = (_tmp38_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp37_ = vala_ccode_identifier_new ("g_renew"))), (_tmp37_ == NULL) ? NULL : (_tmp37_ = (vala_ccode_node_unref (_tmp37_), NULL)), _tmp38_);
		_tmp40_ = NULL;
		_tmp39_ = NULL;
		vala_ccode_function_call_add_argument (renew_call, (ValaCCodeExpression*) (_tmp40_ = vala_ccode_identifier_new (_tmp39_ = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))));
		(_tmp40_ == NULL) ? NULL : (_tmp40_ = (vala_ccode_node_unref (_tmp40_), NULL));
		_tmp39_ = (g_free (_tmp39_), NULL);
		_tmp41_ = NULL;
		vala_ccode_function_call_add_argument (renew_call, (ValaCCodeExpression*) (_tmp41_ = vala_ccode_identifier_new (temp_name)));
		(_tmp41_ == NULL) ? NULL : (_tmp41_ = (vala_ccode_node_unref (_tmp41_), NULL));
		/* add one extra element for NULL-termination*/
		_tmp45_ = NULL;
		_tmp44_ = NULL;
		_tmp43_ = NULL;
		_tmp42_ = NULL;
		vala_ccode_function_call_add_argument (renew_call, (ValaCCodeExpression*) (_tmp45_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) (_tmp43_ = vala_ccode_identifier_new (_tmp42_ = g_strconcat (temp_name, "_size", NULL))), (ValaCCodeExpression*) (_tmp44_ = vala_ccode_constant_new ("1")))));
		(_tmp45_ == NULL) ? NULL : (_tmp45_ = (vala_ccode_node_unref (_tmp45_), NULL));
		(_tmp44_ == NULL) ? NULL : (_tmp44_ = (vala_ccode_node_unref (_tmp44_), NULL));
		(_tmp43_ == NULL) ? NULL : (_tmp43_ = (vala_ccode_node_unref (_tmp43_), NULL));
		_tmp42_ = (g_free (_tmp42_), NULL);
		_tmp47_ = NULL;
		_tmp46_ = NULL;
		_tmp48_ = NULL;
		renew_stmt = (_tmp48_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp47_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp46_ = vala_ccode_identifier_new (temp_name)), (ValaCCodeExpression*) renew_call, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))), (_tmp47_ == NULL) ? NULL : (_tmp47_ = (vala_ccode_node_unref (_tmp47_), NULL)), (_tmp46_ == NULL) ? NULL : (_tmp46_ = (vala_ccode_node_unref (_tmp46_), NULL)), _tmp48_);
		vala_ccode_block_add_statement (renew_block, (ValaCCodeNode*) renew_stmt);
		cif = vala_ccode_if_statement_new ((ValaCCodeExpression*) size_check, (ValaCCodeStatement*) renew_block, NULL);
		vala_ccode_fragment_append (cforfragment, (ValaCCodeNode*) cif);
		_tmp52_ = NULL;
		_tmp51_ = NULL;
		_tmp50_ = NULL;
		_tmp49_ = NULL;
		_tmp53_ = NULL;
		element_access = (_tmp53_ = vala_ccode_element_access_new ((ValaCCodeExpression*) (_tmp49_ = vala_ccode_identifier_new (temp_name)), (ValaCCodeExpression*) (_tmp52_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, (ValaCCodeExpression*) (_tmp51_ = vala_ccode_identifier_new (_tmp50_ = g_strconcat (temp_name, "_length", NULL)))))), (_tmp52_ == NULL) ? NULL : (_tmp52_ = (vala_ccode_node_unref (_tmp52_), NULL)), (_tmp51_ == NULL) ? NULL : (_tmp51_ = (vala_ccode_node_unref (_tmp51_), NULL)), _tmp50_ = (g_free (_tmp50_), NULL), (_tmp49_ == NULL) ? NULL : (_tmp49_ = (vala_ccode_node_unref (_tmp49_), NULL)), _tmp53_);
		_tmp54_ = NULL;
		_tmp55_ = NULL;
		element_expr = (_tmp55_ = vala_dbus_module_read_expression (self, cforfragment, vala_array_type_get_element_type (array_type), (ValaCCodeExpression*) (_tmp54_ = vala_ccode_identifier_new (subiter_name)), NULL), (_tmp54_ == NULL) ? NULL : (_tmp54_ = (vala_ccode_node_unref (_tmp54_), NULL)), _tmp55_);
		_tmp57_ = NULL;
		_tmp56_ = NULL;
		vala_ccode_fragment_append (cforfragment, (ValaCCodeNode*) (_tmp57_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp56_ = vala_ccode_assignment_new ((ValaCCodeExpression*) element_access, element_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp57_ == NULL) ? NULL : (_tmp57_ = (vala_ccode_node_unref (_tmp57_), NULL));
		(_tmp56_ == NULL) ? NULL : (_tmp56_ = (vala_ccode_node_unref (_tmp56_), NULL));
		(size_check == NULL) ? NULL : (size_check = (vala_ccode_node_unref (size_check), NULL));
		(renew_block == NULL) ? NULL : (renew_block = (vala_ccode_node_unref (renew_block), NULL));
		(new_size == NULL) ? NULL : (new_size = (vala_ccode_node_unref (new_size), NULL));
		(renew_call == NULL) ? NULL : (renew_call = (vala_ccode_node_unref (renew_call), NULL));
		(renew_stmt == NULL) ? NULL : (renew_stmt = (vala_ccode_node_unref (renew_stmt), NULL));
		(cif == NULL) ? NULL : (cif = (vala_ccode_node_unref (cif), NULL));
		(element_access == NULL) ? NULL : (element_access = (vala_ccode_node_unref (element_access), NULL));
		(element_expr == NULL) ? NULL : (element_expr = (vala_ccode_node_unref (element_expr), NULL));
	}
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) cfor);
	if (expr != NULL) {
		ValaCCodeExpressionStatement* _tmp62_;
		ValaCCodeAssignment* _tmp61_;
		ValaCCodeIdentifier* _tmp60_;
		char* _tmp59_;
		ValaCCodeExpression* _tmp58_;
		_tmp62_ = NULL;
		_tmp61_ = NULL;
		_tmp60_ = NULL;
		_tmp59_ = NULL;
		_tmp58_ = NULL;
		vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp62_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp61_ = vala_ccode_assignment_new (_tmp58_ = vala_dbus_module_get_array_length (self, expr, dim), (ValaCCodeExpression*) (_tmp60_ = vala_ccode_identifier_new (_tmp59_ = g_strdup_printf ("%s_length%d", temp_name, dim))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp62_ == NULL) ? NULL : (_tmp62_ = (vala_ccode_node_unref (_tmp62_), NULL));
		(_tmp61_ == NULL) ? NULL : (_tmp61_ = (vala_ccode_node_unref (_tmp61_), NULL));
		(_tmp60_ == NULL) ? NULL : (_tmp60_ = (vala_ccode_node_unref (_tmp60_), NULL));
		_tmp59_ = (g_free (_tmp59_), NULL);
		(_tmp58_ == NULL) ? NULL : (_tmp58_ = (vala_ccode_node_unref (_tmp58_), NULL));
	}
	subiter_name = (g_free (subiter_name), NULL);
	(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
	(iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL));
	(cforblock == NULL) ? NULL : (cforblock = (vala_ccode_node_unref (cforblock), NULL));
	(cforfragment == NULL) ? NULL : (cforfragment = (vala_ccode_node_unref (cforfragment), NULL));
	(cfor == NULL) ? NULL : (cfor = (vala_ccode_node_unref (cfor), NULL));
}


static ValaCCodeExpression* vala_dbus_module_read_struct (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaStruct* st, ValaCCodeExpression* iter_expr) {
	char* temp_name;
	char* subiter_name;
	char* _tmp0_;
	ValaCCodeDeclaration* _tmp1_;
	ValaCCodeDeclaration* _cdecl_;
	ValaCCodeVariableDeclarator* _tmp2_;
	ValaCCodeDeclaration* _tmp3_;
	ValaCCodeVariableDeclarator* _tmp4_;
	ValaCCodeIdentifier* _tmp5_;
	ValaCCodeFunctionCall* _tmp6_;
	ValaCCodeFunctionCall* iter_call;
	ValaCCodeUnaryExpression* _tmp7_;
	ValaCCodeUnaryExpression* _tmp9_;
	ValaCCodeIdentifier* _tmp8_;
	ValaCCodeExpressionStatement* _tmp10_;
	ValaCCodeExpression* _tmp23_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (fragment != NULL, NULL);
	g_return_val_if_fail (st != NULL, NULL);
	g_return_val_if_fail (iter_expr != NULL, NULL);
	temp_name = g_strdup_printf ("_tmp%d_", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	subiter_name = g_strdup_printf ("_tmp%d_", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	_cdecl_ = (_tmp1_ = vala_ccode_declaration_new (_tmp0_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	_tmp2_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp2_ = vala_ccode_variable_declarator_new (temp_name, NULL, NULL)));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) _cdecl_);
	_tmp3_ = NULL;
	_cdecl_ = (_tmp3_ = vala_ccode_declaration_new ("DBusMessageIter"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp3_);
	_tmp4_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp4_ = vala_ccode_variable_declarator_new (subiter_name, NULL, NULL)));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) _cdecl_);
	_tmp5_ = NULL;
	_tmp6_ = NULL;
	iter_call = (_tmp6_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp5_ = vala_ccode_identifier_new ("dbus_message_iter_recurse"))), (_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL)), _tmp6_);
	_tmp7_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp7_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, iter_expr)));
	(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
	_tmp9_ = NULL;
	_tmp8_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp9_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp8_ = vala_ccode_identifier_new (subiter_name)))));
	(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
	(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
	_tmp10_ = NULL;
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp10_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
	{
		GeeList* _tmp11_;
		GeeIterator* _tmp12_;
		GeeIterator* _f_it;
		_tmp11_ = NULL;
		_tmp12_ = NULL;
		_f_it = (_tmp12_ = gee_iterable_iterator ((GeeIterable*) (_tmp11_ = vala_struct_get_fields (st))), (_tmp11_ == NULL) ? NULL : (_tmp11_ = (gee_collection_object_unref (_tmp11_), NULL)), _tmp12_);
		while (gee_iterator_next (_f_it)) {
			ValaField* f;
			ValaCCodeMemberAccess* _tmp16_;
			char* _tmp15_;
			ValaCCodeIdentifier* _tmp14_;
			ValaCCodeIdentifier* _tmp13_;
			ValaCCodeExpression* _tmp17_;
			ValaCCodeExpression* field_expr;
			ValaCCodeExpressionStatement* _tmp22_;
			ValaCCodeAssignment* _tmp21_;
			ValaCCodeMemberAccess* _tmp20_;
			char* _tmp19_;
			ValaCCodeIdentifier* _tmp18_;
			f = (ValaField*) gee_iterator_get (_f_it);
			if (vala_field_get_binding (f) != MEMBER_BINDING_INSTANCE) {
				(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
				continue;
			}
			_tmp16_ = NULL;
			_tmp15_ = NULL;
			_tmp14_ = NULL;
			_tmp13_ = NULL;
			_tmp17_ = NULL;
			field_expr = (_tmp17_ = vala_dbus_module_read_expression (self, fragment, vala_field_get_field_type (f), (ValaCCodeExpression*) (_tmp13_ = vala_ccode_identifier_new (subiter_name)), (ValaCCodeExpression*) (_tmp16_ = vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp14_ = vala_ccode_identifier_new (temp_name)), _tmp15_ = vala_field_get_cname (f), FALSE))), (_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL)), _tmp15_ = (g_free (_tmp15_), NULL), (_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL)), (_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL)), _tmp17_);
			_tmp22_ = NULL;
			_tmp21_ = NULL;
			_tmp20_ = NULL;
			_tmp19_ = NULL;
			_tmp18_ = NULL;
			vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp22_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp21_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp20_ = vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp18_ = vala_ccode_identifier_new (temp_name)), _tmp19_ = vala_field_get_cname (f), FALSE)), field_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
			(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
			(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL));
			_tmp19_ = (g_free (_tmp19_), NULL);
			(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL));
			(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
			(field_expr == NULL) ? NULL : (field_expr = (vala_ccode_node_unref (field_expr), NULL));
		}
		(_f_it == NULL) ? NULL : (_f_it = (gee_collection_object_unref (_f_it), NULL));
	}
	_tmp23_ = NULL;
	return (_tmp23_ = (ValaCCodeExpression*) vala_ccode_identifier_new (temp_name), temp_name = (g_free (temp_name), NULL), subiter_name = (g_free (subiter_name), NULL), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp23_);
}


static ValaCCodeExpression* vala_dbus_module_read_value (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaCCodeExpression* iter_expr) {
	char* temp_name;
	char* subiter_name;
	ValaCCodeInitializerList* cvalinit;
	ValaCCodeConstant* _tmp0_;
	ValaCCodeDeclaration* _cdecl_;
	ValaCCodeVariableDeclarator* _tmp1_;
	ValaCCodeDeclaration* _tmp2_;
	ValaCCodeVariableDeclarator* _tmp3_;
	ValaCCodeIdentifier* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	ValaCCodeFunctionCall* iter_call;
	ValaCCodeUnaryExpression* _tmp6_;
	ValaCCodeUnaryExpression* _tmp8_;
	ValaCCodeIdentifier* _tmp7_;
	ValaCCodeExpressionStatement* _tmp9_;
	ValaCCodeIfStatement* clastif;
	ValaCCodeExpression* _tmp32_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (fragment != NULL, NULL);
	g_return_val_if_fail (iter_expr != NULL, NULL);
	temp_name = g_strdup_printf ("_tmp%d_", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	subiter_name = g_strdup_printf ("_tmp%d_", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	/* 0-initialize struct with struct initializer { 0 }*/
	cvalinit = vala_ccode_initializer_list_new ();
	_tmp0_ = NULL;
	vala_ccode_initializer_list_append (cvalinit, (ValaCCodeExpression*) (_tmp0_ = vala_ccode_constant_new ("0")));
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL));
	_cdecl_ = vala_ccode_declaration_new ("GValue");
	_tmp1_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp1_ = vala_ccode_variable_declarator_new (temp_name, (ValaCCodeExpression*) cvalinit, NULL)));
	(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) _cdecl_);
	_tmp2_ = NULL;
	_cdecl_ = (_tmp2_ = vala_ccode_declaration_new ("DBusMessageIter"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp2_);
	_tmp3_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp3_ = vala_ccode_variable_declarator_new (subiter_name, NULL, NULL)));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) _cdecl_);
	_tmp4_ = NULL;
	_tmp5_ = NULL;
	iter_call = (_tmp5_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp4_ = vala_ccode_identifier_new ("dbus_message_iter_recurse"))), (_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL)), _tmp5_);
	_tmp6_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp6_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, iter_expr)));
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	_tmp8_ = NULL;
	_tmp7_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp8_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp7_ = vala_ccode_identifier_new (subiter_name)))));
	(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
	(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
	_tmp9_ = NULL;
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp9_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
	clastif = NULL;
	{
		ValaDBusModuleBasicTypeInfo* basic_type_collection;
		int basic_type_collection_length1;
		int basic_type_it;
		basic_type_collection = VALA_DBUS_MODULE_basic_types;
		basic_type_collection_length1 = G_N_ELEMENTS (VALA_DBUS_MODULE_basic_types);
		for (basic_type_it = 0; basic_type_it < G_N_ELEMENTS (VALA_DBUS_MODULE_basic_types); basic_type_it = basic_type_it + 1) {
			ValaDBusModuleBasicTypeInfo basic_type;
			basic_type = basic_type_collection[basic_type_it];
			{
				ValaCCodeIdentifier* _tmp10_;
				ValaCCodeFunctionCall* _tmp11_;
				ValaCCodeFunctionCall* type_call;
				ValaCCodeUnaryExpression* _tmp13_;
				ValaCCodeIdentifier* _tmp12_;
				ValaCCodeIdentifier* _tmp15_;
				char* _tmp14_;
				ValaCCodeBinaryExpression* _tmp16_;
				ValaCCodeBinaryExpression* type_check;
				ValaCCodeBlock* type_block;
				ValaCCodeFragment* type_fragment;
				ValaCCodeIdentifier* _tmp17_;
				ValaCCodeExpression* _tmp18_;
				ValaCCodeExpression* _result_;
				ValaCCodeIdentifier* _tmp19_;
				ValaCCodeFunctionCall* _tmp20_;
				ValaCCodeFunctionCall* value_init;
				ValaCCodeUnaryExpression* _tmp22_;
				ValaCCodeIdentifier* _tmp21_;
				ValaCCodeIdentifier* _tmp23_;
				ValaCCodeExpressionStatement* _tmp24_;
				ValaCCodeIdentifier* _tmp25_;
				ValaCCodeFunctionCall* _tmp26_;
				ValaCCodeFunctionCall* value_set;
				ValaCCodeUnaryExpression* _tmp28_;
				ValaCCodeIdentifier* _tmp27_;
				ValaCCodeExpressionStatement* _tmp29_;
				ValaCCodeIfStatement* cif;
				ValaCCodeIfStatement* _tmp31_;
				ValaCCodeIfStatement* _tmp30_;
				_tmp10_ = NULL;
				_tmp11_ = NULL;
				type_call = (_tmp11_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp10_ = vala_ccode_identifier_new ("dbus_message_iter_get_arg_type"))), (_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL)), _tmp11_);
				_tmp13_ = NULL;
				_tmp12_ = NULL;
				vala_ccode_function_call_add_argument (type_call, (ValaCCodeExpression*) (_tmp13_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp12_ = vala_ccode_identifier_new (subiter_name)))));
				(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
				(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
				_tmp15_ = NULL;
				_tmp14_ = NULL;
				_tmp16_ = NULL;
				type_check = (_tmp16_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) type_call, (ValaCCodeExpression*) (_tmp15_ = vala_ccode_identifier_new (_tmp14_ = g_strconcat ("DBUS_TYPE_", basic_type.type_name, NULL)))), (_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL)), _tmp14_ = (g_free (_tmp14_), NULL), _tmp16_);
				type_block = vala_ccode_block_new ();
				type_fragment = vala_ccode_fragment_new ();
				vala_ccode_block_add_statement (type_block, (ValaCCodeNode*) type_fragment);
				_tmp17_ = NULL;
				_tmp18_ = NULL;
				_result_ = (_tmp18_ = vala_dbus_module_read_basic (self, type_fragment, &basic_type, (ValaCCodeExpression*) (_tmp17_ = vala_ccode_identifier_new (subiter_name))), (_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL)), _tmp18_);
				_tmp19_ = NULL;
				_tmp20_ = NULL;
				value_init = (_tmp20_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp19_ = vala_ccode_identifier_new ("g_value_init"))), (_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL)), _tmp20_);
				_tmp22_ = NULL;
				_tmp21_ = NULL;
				vala_ccode_function_call_add_argument (value_init, (ValaCCodeExpression*) (_tmp22_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp21_ = vala_ccode_identifier_new (temp_name)))));
				(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
				(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
				_tmp23_ = NULL;
				vala_ccode_function_call_add_argument (value_init, (ValaCCodeExpression*) (_tmp23_ = vala_ccode_identifier_new (basic_type.gtype)));
				(_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL));
				_tmp24_ = NULL;
				vala_ccode_fragment_append (type_fragment, (ValaCCodeNode*) (_tmp24_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) value_init)));
				(_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL));
				_tmp25_ = NULL;
				_tmp26_ = NULL;
				value_set = (_tmp26_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp25_ = vala_ccode_identifier_new (basic_type.set_value_function))), (_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_ccode_node_unref (_tmp25_), NULL)), _tmp26_);
				_tmp28_ = NULL;
				_tmp27_ = NULL;
				vala_ccode_function_call_add_argument (value_set, (ValaCCodeExpression*) (_tmp28_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp27_ = vala_ccode_identifier_new (temp_name)))));
				(_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_ccode_node_unref (_tmp28_), NULL));
				(_tmp27_ == NULL) ? NULL : (_tmp27_ = (vala_ccode_node_unref (_tmp27_), NULL));
				vala_ccode_function_call_add_argument (value_set, _result_);
				_tmp29_ = NULL;
				vala_ccode_fragment_append (type_fragment, (ValaCCodeNode*) (_tmp29_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) value_set)));
				(_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL));
				cif = vala_ccode_if_statement_new ((ValaCCodeExpression*) type_check, (ValaCCodeStatement*) type_block, NULL);
				if (clastif == NULL) {
					vala_ccode_fragment_append (fragment, (ValaCCodeNode*) cif);
				} else {
					vala_ccode_if_statement_set_false_statement (clastif, (ValaCCodeStatement*) cif);
				}
				_tmp31_ = NULL;
				_tmp30_ = NULL;
				clastif = (_tmp31_ = (_tmp30_ = cif, (_tmp30_ == NULL) ? NULL : vala_ccode_node_ref (_tmp30_)), (clastif == NULL) ? NULL : (clastif = (vala_ccode_node_unref (clastif), NULL)), _tmp31_);
				(type_call == NULL) ? NULL : (type_call = (vala_ccode_node_unref (type_call), NULL));
				(type_check == NULL) ? NULL : (type_check = (vala_ccode_node_unref (type_check), NULL));
				(type_block == NULL) ? NULL : (type_block = (vala_ccode_node_unref (type_block), NULL));
				(type_fragment == NULL) ? NULL : (type_fragment = (vala_ccode_node_unref (type_fragment), NULL));
				(_result_ == NULL) ? NULL : (_result_ = (vala_ccode_node_unref (_result_), NULL));
				(value_init == NULL) ? NULL : (value_init = (vala_ccode_node_unref (value_init), NULL));
				(value_set == NULL) ? NULL : (value_set = (vala_ccode_node_unref (value_set), NULL));
				(cif == NULL) ? NULL : (cif = (vala_ccode_node_unref (cif), NULL));
			}
		}
	}
	_tmp32_ = NULL;
	return (_tmp32_ = (ValaCCodeExpression*) vala_ccode_identifier_new (temp_name), temp_name = (g_free (temp_name), NULL), subiter_name = (g_free (subiter_name), NULL), (cvalinit == NULL) ? NULL : (cvalinit = (vala_ccode_node_unref (cvalinit), NULL)), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), (clastif == NULL) ? NULL : (clastif = (vala_ccode_node_unref (clastif), NULL)), _tmp32_);
}


static ValaCCodeExpression* vala_dbus_module_read_hash_table (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaObjectType* type, ValaCCodeExpression* iter_expr) {
	char* temp_name;
	char* subiter_name;
	char* entryiter_name;
	GeeList* type_args;
	ValaDataType* key_type;
	ValaDataType* value_type;
	ValaCCodeDeclaration* _cdecl_;
	ValaCCodeVariableDeclarator* _tmp0_;
	ValaCCodeDeclaration* _tmp1_;
	ValaCCodeVariableDeclarator* _tmp2_;
	ValaCCodeDeclaration* _tmp3_;
	ValaCCodeVariableDeclarator* _tmp4_;
	ValaCCodeIdentifier* _tmp5_;
	ValaCCodeFunctionCall* _tmp6_;
	ValaCCodeFunctionCall* hash_table_new;
	ValaCCodeExpressionStatement* _tmp17_;
	ValaCCodeAssignment* _tmp16_;
	ValaCCodeIdentifier* _tmp15_;
	ValaCCodeIdentifier* _tmp18_;
	ValaCCodeFunctionCall* _tmp19_;
	ValaCCodeFunctionCall* iter_call;
	ValaCCodeUnaryExpression* _tmp20_;
	ValaCCodeUnaryExpression* _tmp22_;
	ValaCCodeIdentifier* _tmp21_;
	ValaCCodeExpressionStatement* _tmp23_;
	ValaCCodeFunctionCall* _tmp25_;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeUnaryExpression* _tmp27_;
	ValaCCodeIdentifier* _tmp26_;
	ValaCCodeBlock* cwhileblock;
	ValaCCodeFragment* cwhilefragment;
	ValaCCodeWhileStatement* cwhile;
	ValaCCodeFunctionCall* _tmp29_;
	ValaCCodeIdentifier* _tmp28_;
	ValaCCodeUnaryExpression* _tmp31_;
	ValaCCodeIdentifier* _tmp30_;
	ValaCCodeUnaryExpression* _tmp33_;
	ValaCCodeIdentifier* _tmp32_;
	ValaCCodeExpressionStatement* _tmp34_;
	ValaCCodeDeclaration* _tmp36_;
	char* _tmp35_;
	ValaCCodeVariableDeclarator* _tmp37_;
	ValaCCodeDeclaration* _tmp39_;
	char* _tmp38_;
	ValaCCodeVariableDeclarator* _tmp40_;
	ValaCCodeIdentifier* _tmp41_;
	ValaCCodeExpression* _tmp42_;
	ValaCCodeExpression* key_expr;
	ValaCCodeExpressionStatement* _tmp45_;
	ValaCCodeAssignment* _tmp44_;
	ValaCCodeIdentifier* _tmp43_;
	ValaCCodeIdentifier* _tmp46_;
	ValaCCodeExpression* _tmp47_;
	ValaCCodeExpression* value_expr;
	ValaCCodeExpressionStatement* _tmp50_;
	ValaCCodeAssignment* _tmp49_;
	ValaCCodeIdentifier* _tmp48_;
	ValaCCodeIdentifier* _tmp51_;
	ValaCCodeFunctionCall* _tmp52_;
	ValaCCodeFunctionCall* hash_table_insert;
	ValaCCodeIdentifier* _tmp53_;
	ValaCCodeExpression* _tmp55_;
	ValaCCodeIdentifier* _tmp54_;
	ValaCCodeExpression* _tmp57_;
	ValaCCodeIdentifier* _tmp56_;
	ValaCCodeExpressionStatement* _tmp58_;
	ValaCCodeFunctionCall* _tmp60_;
	ValaCCodeIdentifier* _tmp59_;
	ValaCCodeUnaryExpression* _tmp62_;
	ValaCCodeIdentifier* _tmp61_;
	ValaCCodeExpressionStatement* _tmp63_;
	ValaCCodeExpression* _tmp64_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (fragment != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (iter_expr != NULL, NULL);
	temp_name = g_strdup_printf ("_tmp%d_", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	subiter_name = g_strdup_printf ("_tmp%d_", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	entryiter_name = g_strdup_printf ("_tmp%d_", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	type_args = vala_data_type_get_type_arguments ((ValaDataType*) type);
	g_assert (gee_collection_get_size ((GeeCollection*) type_args) == 2);
	key_type = (ValaDataType*) gee_list_get (type_args, 0);
	value_type = (ValaDataType*) gee_list_get (type_args, 1);
	_cdecl_ = vala_ccode_declaration_new ("GHashTable*");
	_tmp0_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp0_ = vala_ccode_variable_declarator_new (temp_name, NULL, NULL)));
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) _cdecl_);
	_tmp1_ = NULL;
	_cdecl_ = (_tmp1_ = vala_ccode_declaration_new ("DBusMessageIter"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp1_);
	_tmp2_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp2_ = vala_ccode_variable_declarator_new (subiter_name, NULL, NULL)));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) _cdecl_);
	_tmp3_ = NULL;
	_cdecl_ = (_tmp3_ = vala_ccode_declaration_new ("DBusMessageIter"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp3_);
	_tmp4_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp4_ = vala_ccode_variable_declarator_new (entryiter_name, NULL, NULL)));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) _cdecl_);
	_tmp5_ = NULL;
	_tmp6_ = NULL;
	hash_table_new = (_tmp6_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp5_ = vala_ccode_identifier_new ("g_hash_table_new_full"))), (_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL)), _tmp6_);
	if (vala_data_type_get_data_type (key_type) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type)) {
		ValaCCodeIdentifier* _tmp7_;
		ValaCCodeIdentifier* _tmp8_;
		_tmp7_ = NULL;
		vala_ccode_function_call_add_argument (hash_table_new, (ValaCCodeExpression*) (_tmp7_ = vala_ccode_identifier_new ("g_str_hash")));
		(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
		_tmp8_ = NULL;
		vala_ccode_function_call_add_argument (hash_table_new, (ValaCCodeExpression*) (_tmp8_ = vala_ccode_identifier_new ("g_str_equal")));
		(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
	} else {
		ValaCCodeIdentifier* _tmp9_;
		ValaCCodeIdentifier* _tmp10_;
		_tmp9_ = NULL;
		vala_ccode_function_call_add_argument (hash_table_new, (ValaCCodeExpression*) (_tmp9_ = vala_ccode_identifier_new ("g_direct_hash")));
		(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
		_tmp10_ = NULL;
		vala_ccode_function_call_add_argument (hash_table_new, (ValaCCodeExpression*) (_tmp10_ = vala_ccode_identifier_new ("g_direct_equal")));
		(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
	}
	if (vala_data_type_get_data_type (key_type) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type)) {
		ValaCCodeIdentifier* _tmp11_;
		_tmp11_ = NULL;
		vala_ccode_function_call_add_argument (hash_table_new, (ValaCCodeExpression*) (_tmp11_ = vala_ccode_identifier_new ("g_free")));
		(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
	} else {
		ValaCCodeIdentifier* _tmp12_;
		_tmp12_ = NULL;
		vala_ccode_function_call_add_argument (hash_table_new, (ValaCCodeExpression*) (_tmp12_ = vala_ccode_identifier_new ("NULL")));
		(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
	}
	if (vala_data_type_get_data_type (value_type) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type)) {
		ValaCCodeIdentifier* _tmp13_;
		_tmp13_ = NULL;
		vala_ccode_function_call_add_argument (hash_table_new, (ValaCCodeExpression*) (_tmp13_ = vala_ccode_identifier_new ("g_free")));
		(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
	} else {
		ValaCCodeIdentifier* _tmp14_;
		_tmp14_ = NULL;
		vala_ccode_function_call_add_argument (hash_table_new, (ValaCCodeExpression*) (_tmp14_ = vala_ccode_identifier_new ("NULL")));
		(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
	}
	_tmp17_ = NULL;
	_tmp16_ = NULL;
	_tmp15_ = NULL;
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp17_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp16_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp15_ = vala_ccode_identifier_new (temp_name)), (ValaCCodeExpression*) hash_table_new, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL));
	(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
	(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
	_tmp18_ = NULL;
	_tmp19_ = NULL;
	iter_call = (_tmp19_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp18_ = vala_ccode_identifier_new ("dbus_message_iter_recurse"))), (_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL)), _tmp19_);
	_tmp20_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp20_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, iter_expr)));
	(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL));
	_tmp22_ = NULL;
	_tmp21_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp22_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp21_ = vala_ccode_identifier_new (subiter_name)))));
	(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
	(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
	_tmp23_ = NULL;
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp23_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL));
	_tmp25_ = NULL;
	_tmp24_ = NULL;
	iter_call = (_tmp25_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp24_ = vala_ccode_identifier_new ("dbus_message_iter_get_arg_type"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp25_);
	(_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL));
	_tmp27_ = NULL;
	_tmp26_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp27_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp26_ = vala_ccode_identifier_new (subiter_name)))));
	(_tmp27_ == NULL) ? NULL : (_tmp27_ = (vala_ccode_node_unref (_tmp27_), NULL));
	(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL));
	cwhileblock = vala_ccode_block_new ();
	cwhilefragment = vala_ccode_fragment_new ();
	vala_ccode_block_add_statement (cwhileblock, (ValaCCodeNode*) cwhilefragment);
	cwhile = vala_ccode_while_statement_new ((ValaCCodeExpression*) iter_call, (ValaCCodeStatement*) cwhileblock);
	_tmp29_ = NULL;
	_tmp28_ = NULL;
	iter_call = (_tmp29_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp28_ = vala_ccode_identifier_new ("dbus_message_iter_recurse"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp29_);
	(_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_ccode_node_unref (_tmp28_), NULL));
	_tmp31_ = NULL;
	_tmp30_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp31_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp30_ = vala_ccode_identifier_new (subiter_name)))));
	(_tmp31_ == NULL) ? NULL : (_tmp31_ = (vala_ccode_node_unref (_tmp31_), NULL));
	(_tmp30_ == NULL) ? NULL : (_tmp30_ = (vala_ccode_node_unref (_tmp30_), NULL));
	_tmp33_ = NULL;
	_tmp32_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp33_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp32_ = vala_ccode_identifier_new (entryiter_name)))));
	(_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_ccode_node_unref (_tmp33_), NULL));
	(_tmp32_ == NULL) ? NULL : (_tmp32_ = (vala_ccode_node_unref (_tmp32_), NULL));
	_tmp34_ = NULL;
	vala_ccode_fragment_append (cwhilefragment, (ValaCCodeNode*) (_tmp34_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp34_ == NULL) ? NULL : (_tmp34_ = (vala_ccode_node_unref (_tmp34_), NULL));
	_tmp36_ = NULL;
	_tmp35_ = NULL;
	_cdecl_ = (_tmp36_ = vala_ccode_declaration_new (_tmp35_ = vala_data_type_get_cname (key_type)), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp36_);
	_tmp35_ = (g_free (_tmp35_), NULL);
	_tmp37_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp37_ = vala_ccode_variable_declarator_new ("_key", NULL, NULL)));
	(_tmp37_ == NULL) ? NULL : (_tmp37_ = (vala_ccode_node_unref (_tmp37_), NULL));
	vala_ccode_fragment_append (cwhilefragment, (ValaCCodeNode*) _cdecl_);
	_tmp39_ = NULL;
	_tmp38_ = NULL;
	_cdecl_ = (_tmp39_ = vala_ccode_declaration_new (_tmp38_ = vala_data_type_get_cname (value_type)), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp39_);
	_tmp38_ = (g_free (_tmp38_), NULL);
	_tmp40_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp40_ = vala_ccode_variable_declarator_new ("_value", NULL, NULL)));
	(_tmp40_ == NULL) ? NULL : (_tmp40_ = (vala_ccode_node_unref (_tmp40_), NULL));
	vala_ccode_fragment_append (cwhilefragment, (ValaCCodeNode*) _cdecl_);
	_tmp41_ = NULL;
	_tmp42_ = NULL;
	key_expr = (_tmp42_ = vala_dbus_module_read_expression (self, cwhilefragment, key_type, (ValaCCodeExpression*) (_tmp41_ = vala_ccode_identifier_new (entryiter_name)), NULL), (_tmp41_ == NULL) ? NULL : (_tmp41_ = (vala_ccode_node_unref (_tmp41_), NULL)), _tmp42_);
	_tmp45_ = NULL;
	_tmp44_ = NULL;
	_tmp43_ = NULL;
	vala_ccode_fragment_append (cwhilefragment, (ValaCCodeNode*) (_tmp45_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp44_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp43_ = vala_ccode_identifier_new ("_key")), key_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp45_ == NULL) ? NULL : (_tmp45_ = (vala_ccode_node_unref (_tmp45_), NULL));
	(_tmp44_ == NULL) ? NULL : (_tmp44_ = (vala_ccode_node_unref (_tmp44_), NULL));
	(_tmp43_ == NULL) ? NULL : (_tmp43_ = (vala_ccode_node_unref (_tmp43_), NULL));
	_tmp46_ = NULL;
	_tmp47_ = NULL;
	value_expr = (_tmp47_ = vala_dbus_module_read_expression (self, cwhilefragment, value_type, (ValaCCodeExpression*) (_tmp46_ = vala_ccode_identifier_new (entryiter_name)), NULL), (_tmp46_ == NULL) ? NULL : (_tmp46_ = (vala_ccode_node_unref (_tmp46_), NULL)), _tmp47_);
	_tmp50_ = NULL;
	_tmp49_ = NULL;
	_tmp48_ = NULL;
	vala_ccode_fragment_append (cwhilefragment, (ValaCCodeNode*) (_tmp50_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp49_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp48_ = vala_ccode_identifier_new ("_value")), value_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp50_ == NULL) ? NULL : (_tmp50_ = (vala_ccode_node_unref (_tmp50_), NULL));
	(_tmp49_ == NULL) ? NULL : (_tmp49_ = (vala_ccode_node_unref (_tmp49_), NULL));
	(_tmp48_ == NULL) ? NULL : (_tmp48_ = (vala_ccode_node_unref (_tmp48_), NULL));
	_tmp51_ = NULL;
	_tmp52_ = NULL;
	hash_table_insert = (_tmp52_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp51_ = vala_ccode_identifier_new ("g_hash_table_insert"))), (_tmp51_ == NULL) ? NULL : (_tmp51_ = (vala_ccode_node_unref (_tmp51_), NULL)), _tmp52_);
	_tmp53_ = NULL;
	vala_ccode_function_call_add_argument (hash_table_insert, (ValaCCodeExpression*) (_tmp53_ = vala_ccode_identifier_new (temp_name)));
	(_tmp53_ == NULL) ? NULL : (_tmp53_ = (vala_ccode_node_unref (_tmp53_), NULL));
	_tmp55_ = NULL;
	_tmp54_ = NULL;
	vala_ccode_function_call_add_argument (hash_table_insert, _tmp55_ = vala_ccode_base_module_convert_to_generic_pointer ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) (_tmp54_ = vala_ccode_identifier_new ("_key")), key_type));
	(_tmp55_ == NULL) ? NULL : (_tmp55_ = (vala_ccode_node_unref (_tmp55_), NULL));
	(_tmp54_ == NULL) ? NULL : (_tmp54_ = (vala_ccode_node_unref (_tmp54_), NULL));
	_tmp57_ = NULL;
	_tmp56_ = NULL;
	vala_ccode_function_call_add_argument (hash_table_insert, _tmp57_ = vala_ccode_base_module_convert_to_generic_pointer ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) (_tmp56_ = vala_ccode_identifier_new ("_value")), value_type));
	(_tmp57_ == NULL) ? NULL : (_tmp57_ = (vala_ccode_node_unref (_tmp57_), NULL));
	(_tmp56_ == NULL) ? NULL : (_tmp56_ = (vala_ccode_node_unref (_tmp56_), NULL));
	_tmp58_ = NULL;
	vala_ccode_fragment_append (cwhilefragment, (ValaCCodeNode*) (_tmp58_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) hash_table_insert)));
	(_tmp58_ == NULL) ? NULL : (_tmp58_ = (vala_ccode_node_unref (_tmp58_), NULL));
	_tmp60_ = NULL;
	_tmp59_ = NULL;
	iter_call = (_tmp60_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp59_ = vala_ccode_identifier_new ("dbus_message_iter_next"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp60_);
	(_tmp59_ == NULL) ? NULL : (_tmp59_ = (vala_ccode_node_unref (_tmp59_), NULL));
	_tmp62_ = NULL;
	_tmp61_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp62_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp61_ = vala_ccode_identifier_new (subiter_name)))));
	(_tmp62_ == NULL) ? NULL : (_tmp62_ = (vala_ccode_node_unref (_tmp62_), NULL));
	(_tmp61_ == NULL) ? NULL : (_tmp61_ = (vala_ccode_node_unref (_tmp61_), NULL));
	_tmp63_ = NULL;
	vala_ccode_fragment_append (cwhilefragment, (ValaCCodeNode*) (_tmp63_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp63_ == NULL) ? NULL : (_tmp63_ = (vala_ccode_node_unref (_tmp63_), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) cwhile);
	_tmp64_ = NULL;
	return (_tmp64_ = (ValaCCodeExpression*) vala_ccode_identifier_new (temp_name), temp_name = (g_free (temp_name), NULL), subiter_name = (g_free (subiter_name), NULL), entryiter_name = (g_free (entryiter_name), NULL), (type_args == NULL) ? NULL : (type_args = (gee_collection_object_unref (type_args), NULL)), (key_type == NULL) ? NULL : (key_type = (vala_code_node_unref (key_type), NULL)), (value_type == NULL) ? NULL : (value_type = (vala_code_node_unref (value_type), NULL)), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), (hash_table_new == NULL) ? NULL : (hash_table_new = (vala_ccode_node_unref (hash_table_new), NULL)), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), (cwhileblock == NULL) ? NULL : (cwhileblock = (vala_ccode_node_unref (cwhileblock), NULL)), (cwhilefragment == NULL) ? NULL : (cwhilefragment = (vala_ccode_node_unref (cwhilefragment), NULL)), (cwhile == NULL) ? NULL : (cwhile = (vala_ccode_node_unref (cwhile), NULL)), (key_expr == NULL) ? NULL : (key_expr = (vala_ccode_node_unref (key_expr), NULL)), (value_expr == NULL) ? NULL : (value_expr = (vala_ccode_node_unref (value_expr), NULL)), (hash_table_insert == NULL) ? NULL : (hash_table_insert = (vala_ccode_node_unref (hash_table_insert), NULL)), _tmp64_);
}


ValaCCodeExpression* vala_dbus_module_read_expression (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaDataType* type, ValaCCodeExpression* iter_expr, ValaCCodeExpression* expr) {
	ValaDBusModuleBasicTypeInfo basic_type = {0};
	ValaCCodeExpression* _result_;
	char* _tmp0_;
	gboolean _tmp1_;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeFunctionCall* _tmp25_;
	ValaCCodeFunctionCall* iter_call;
	ValaCCodeUnaryExpression* _tmp26_;
	ValaCCodeExpressionStatement* _tmp27_;
	ValaCCodeExpression* _tmp28_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (fragment != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (iter_expr != NULL, NULL);
	_result_ = NULL;
	_tmp0_ = NULL;
	if ((_tmp1_ = vala_dbus_module_get_basic_type_info (self, _tmp0_ = vala_data_type_get_type_signature (type), &basic_type), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_)) {
		ValaCCodeExpression* _tmp2_;
		_tmp2_ = NULL;
		_result_ = (_tmp2_ = vala_dbus_module_read_basic (self, fragment, &basic_type, iter_expr), (_result_ == NULL) ? NULL : (_result_ = (vala_ccode_node_unref (_result_), NULL)), _tmp2_);
	} else {
		if (VALA_IS_ARRAY_TYPE (type)) {
			ValaCCodeExpression* _tmp3_;
			_tmp3_ = NULL;
			_result_ = (_tmp3_ = vala_dbus_module_read_array (self, fragment, VALA_ARRAY_TYPE (type), iter_expr, expr), (_result_ == NULL) ? NULL : (_result_ = (vala_ccode_node_unref (_result_), NULL)), _tmp3_);
		} else {
			if (VALA_IS_STRUCT (vala_data_type_get_data_type (type))) {
				ValaStruct* _tmp4_;
				ValaStruct* st;
				char* _tmp5_;
				gboolean _tmp6_;
				_tmp4_ = NULL;
				st = (_tmp4_ = VALA_STRUCT (vala_data_type_get_data_type (type)), (_tmp4_ == NULL) ? NULL : vala_code_node_ref (_tmp4_));
				_tmp5_ = NULL;
				if ((_tmp6_ = _vala_strcmp0 (_tmp5_ = vala_symbol_get_full_name ((ValaSymbol*) vala_data_type_get_data_type (type)), "GLib.Value") == 0, _tmp5_ = (g_free (_tmp5_), NULL), _tmp6_)) {
					ValaCCodeExpression* _tmp7_;
					_tmp7_ = NULL;
					_result_ = (_tmp7_ = vala_dbus_module_read_value (self, fragment, iter_expr), (_result_ == NULL) ? NULL : (_result_ = (vala_ccode_node_unref (_result_), NULL)), _tmp7_);
				} else {
					ValaCCodeExpression* _tmp8_;
					_tmp8_ = NULL;
					_result_ = (_tmp8_ = vala_dbus_module_read_struct (self, fragment, st, iter_expr), (_result_ == NULL) ? NULL : (_result_ = (vala_ccode_node_unref (_result_), NULL)), _tmp8_);
				}
				if (vala_data_type_get_nullable (type)) {
					ValaCCodeIdentifier* _tmp9_;
					ValaCCodeFunctionCall* _tmp10_;
					ValaCCodeFunctionCall* csizeof;
					ValaCCodeIdentifier* _tmp12_;
					char* _tmp11_;
					ValaCCodeIdentifier* _tmp13_;
					ValaCCodeFunctionCall* _tmp14_;
					ValaCCodeFunctionCall* cdup;
					ValaCCodeUnaryExpression* _tmp15_;
					ValaCCodeExpression* _tmp17_;
					ValaCCodeExpression* _tmp16_;
					_tmp9_ = NULL;
					_tmp10_ = NULL;
					csizeof = (_tmp10_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp9_ = vala_ccode_identifier_new ("sizeof"))), (_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL)), _tmp10_);
					_tmp12_ = NULL;
					_tmp11_ = NULL;
					vala_ccode_function_call_add_argument (csizeof, (ValaCCodeExpression*) (_tmp12_ = vala_ccode_identifier_new (_tmp11_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE))));
					(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
					_tmp11_ = (g_free (_tmp11_), NULL);
					_tmp13_ = NULL;
					_tmp14_ = NULL;
					cdup = (_tmp14_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp13_ = vala_ccode_identifier_new ("g_memdup"))), (_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL)), _tmp14_);
					_tmp15_ = NULL;
					vala_ccode_function_call_add_argument (cdup, (ValaCCodeExpression*) (_tmp15_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _result_)));
					(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
					vala_ccode_function_call_add_argument (cdup, (ValaCCodeExpression*) csizeof);
					_tmp17_ = NULL;
					_tmp16_ = NULL;
					_result_ = (_tmp17_ = (_tmp16_ = (ValaCCodeExpression*) cdup, (_tmp16_ == NULL) ? NULL : vala_ccode_node_ref (_tmp16_)), (_result_ == NULL) ? NULL : (_result_ = (vala_ccode_node_unref (_result_), NULL)), _tmp17_);
					(csizeof == NULL) ? NULL : (csizeof = (vala_ccode_node_unref (csizeof), NULL));
					(cdup == NULL) ? NULL : (cdup = (vala_ccode_node_unref (cdup), NULL));
				}
				(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
			} else {
				if (VALA_IS_OBJECT_TYPE (type)) {
					char* _tmp18_;
					gboolean _tmp19_;
					_tmp18_ = NULL;
					if ((_tmp19_ = _vala_strcmp0 (_tmp18_ = vala_symbol_get_full_name ((ValaSymbol*) vala_data_type_get_data_type (type)), "GLib.HashTable") == 0, _tmp18_ = (g_free (_tmp18_), NULL), _tmp19_)) {
						ValaCCodeExpression* _tmp20_;
						_tmp20_ = NULL;
						_result_ = (_tmp20_ = vala_dbus_module_read_hash_table (self, fragment, VALA_OBJECT_TYPE (type), iter_expr), (_result_ == NULL) ? NULL : (_result_ = (vala_ccode_node_unref (_result_), NULL)), _tmp20_);
					}
				} else {
					char* _tmp22_;
					char* _tmp21_;
					ValaCCodeExpression* _tmp23_;
					_tmp22_ = NULL;
					_tmp21_ = NULL;
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) type), _tmp22_ = g_strdup_printf ("D-Bus deserialization of type `%s' is not supported", _tmp21_ = vala_code_node_to_string ((ValaCodeNode*) type)));
					_tmp22_ = (g_free (_tmp22_), NULL);
					_tmp21_ = (g_free (_tmp21_), NULL);
					_tmp23_ = NULL;
					return (_tmp23_ = NULL, (_result_ == NULL) ? NULL : (_result_ = (vala_ccode_node_unref (_result_), NULL)), _tmp23_);
				}
			}
		}
	}
	_tmp24_ = NULL;
	_tmp25_ = NULL;
	iter_call = (_tmp25_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp24_ = vala_ccode_identifier_new ("dbus_message_iter_next"))), (_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL)), _tmp25_);
	_tmp26_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp26_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, iter_expr)));
	(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL));
	_tmp27_ = NULL;
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp27_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp27_ == NULL) ? NULL : (_tmp27_ = (vala_ccode_node_unref (_tmp27_), NULL));
	_tmp28_ = NULL;
	return (_tmp28_ = _result_, (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp28_);
}


static void vala_dbus_module_write_basic (ValaDBusModule* self, ValaCCodeFragment* fragment, const ValaDBusModuleBasicTypeInfo* basic_type, ValaCCodeExpression* iter_expr, ValaCCodeExpression* expr) {
	char* temp_name;
	ValaCCodeDeclaration* _cdecl_;
	ValaCCodeVariableDeclarator* _tmp0_;
	ValaCCodeExpressionStatement* _tmp3_;
	ValaCCodeAssignment* _tmp2_;
	ValaCCodeIdentifier* _tmp1_;
	ValaCCodeIdentifier* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	ValaCCodeFunctionCall* iter_call;
	ValaCCodeUnaryExpression* _tmp6_;
	ValaCCodeIdentifier* _tmp8_;
	char* _tmp7_;
	ValaCCodeUnaryExpression* _tmp10_;
	ValaCCodeIdentifier* _tmp9_;
	ValaCCodeExpressionStatement* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (fragment != NULL);
	g_return_if_fail (iter_expr != NULL);
	g_return_if_fail (expr != NULL);
	temp_name = g_strdup_printf ("_tmp%d_", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	_cdecl_ = vala_ccode_declaration_new ((*basic_type).cname);
	_tmp0_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp0_ = vala_ccode_variable_declarator_new (temp_name, NULL, NULL)));
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) _cdecl_);
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	_tmp1_ = NULL;
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp3_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp2_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp1_ = vala_ccode_identifier_new (temp_name)), expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL));
	_tmp4_ = NULL;
	_tmp5_ = NULL;
	iter_call = (_tmp5_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp4_ = vala_ccode_identifier_new ("dbus_message_iter_append_basic"))), (_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL)), _tmp5_);
	_tmp6_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp6_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, iter_expr)));
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	_tmp8_ = NULL;
	_tmp7_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp8_ = vala_ccode_identifier_new (_tmp7_ = g_strconcat ("DBUS_TYPE_", (*basic_type).type_name, NULL))));
	(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
	_tmp7_ = (g_free (_tmp7_), NULL);
	_tmp10_ = NULL;
	_tmp9_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp10_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp9_ = vala_ccode_identifier_new (temp_name)))));
	(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
	(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
	_tmp11_ = NULL;
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp11_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
	temp_name = (g_free (temp_name), NULL);
	(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
	(iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL));
}


static void vala_dbus_module_write_array (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaArrayType* array_type, ValaCCodeExpression* iter_expr, ValaCCodeExpression* array_expr) {
	char* array_iter_name;
	char* _tmp0_;
	ValaCCodeDeclaration* _tmp1_;
	ValaCCodeDeclaration* _cdecl_;
	ValaCCodeVariableDeclarator* _tmp2_;
	ValaCCodeExpressionStatement* _tmp5_;
	ValaCCodeAssignment* _tmp4_;
	ValaCCodeIdentifier* _tmp3_;
	ValaCCodeIdentifier* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (fragment != NULL);
	g_return_if_fail (array_type != NULL);
	g_return_if_fail (iter_expr != NULL);
	g_return_if_fail (array_expr != NULL);
	array_iter_name = g_strdup_printf ("_tmp%d_", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	_cdecl_ = (_tmp1_ = vala_ccode_declaration_new (_tmp0_ = vala_data_type_get_cname ((ValaDataType*) array_type)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	_tmp2_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp2_ = vala_ccode_variable_declarator_new (array_iter_name, NULL, NULL)));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) _cdecl_);
	_tmp5_ = NULL;
	_tmp4_ = NULL;
	_tmp3_ = NULL;
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp5_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp4_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp3_ = vala_ccode_identifier_new (array_iter_name)), array_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	_tmp6_ = NULL;
	vala_dbus_module_write_array_dim (self, fragment, array_type, 1, iter_expr, array_expr, (ValaCCodeExpression*) (_tmp6_ = vala_ccode_identifier_new (array_iter_name)));
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	array_iter_name = (g_free (array_iter_name), NULL);
	(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
}


static void vala_dbus_module_write_array_dim (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaArrayType* array_type, gint dim, ValaCCodeExpression* iter_expr, ValaCCodeExpression* array_expr, ValaCCodeExpression* array_iter_expr) {
	char* subiter_name;
	char* index_name;
	ValaCCodeDeclaration* _cdecl_;
	ValaCCodeVariableDeclarator* _tmp0_;
	ValaCCodeDeclaration* _tmp1_;
	ValaCCodeVariableDeclarator* _tmp2_;
	ValaCCodeIdentifier* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeFunctionCall* iter_call;
	ValaCCodeUnaryExpression* _tmp5_;
	ValaCCodeIdentifier* _tmp6_;
	ValaCCodeConstant* _tmp10_;
	char* _tmp9_;
	char* _tmp8_;
	char* _tmp7_;
	ValaCCodeUnaryExpression* _tmp12_;
	ValaCCodeIdentifier* _tmp11_;
	ValaCCodeExpressionStatement* _tmp13_;
	ValaCCodeBlock* cforblock;
	ValaCCodeFragment* cforfragment;
	ValaCCodeBinaryExpression* _tmp16_;
	ValaCCodeExpression* _tmp15_;
	ValaCCodeIdentifier* _tmp14_;
	ValaCCodeForStatement* _tmp17_;
	ValaCCodeForStatement* cfor;
	ValaCCodeAssignment* _tmp20_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeIdentifier* _tmp18_;
	ValaCCodeUnaryExpression* _tmp22_;
	ValaCCodeIdentifier* _tmp21_;
	ValaCCodeFunctionCall* _tmp27_;
	ValaCCodeIdentifier* _tmp26_;
	ValaCCodeUnaryExpression* _tmp28_;
	ValaCCodeUnaryExpression* _tmp30_;
	ValaCCodeIdentifier* _tmp29_;
	ValaCCodeExpressionStatement* _tmp31_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (fragment != NULL);
	g_return_if_fail (array_type != NULL);
	g_return_if_fail (iter_expr != NULL);
	g_return_if_fail (array_expr != NULL);
	g_return_if_fail (array_iter_expr != NULL);
	subiter_name = g_strdup_printf ("_tmp%d_", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	index_name = g_strdup_printf ("_tmp%d_", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	_cdecl_ = vala_ccode_declaration_new ("DBusMessageIter");
	_tmp0_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp0_ = vala_ccode_variable_declarator_new (subiter_name, NULL, NULL)));
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) _cdecl_);
	_tmp1_ = NULL;
	_cdecl_ = (_tmp1_ = vala_ccode_declaration_new ("int"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp1_);
	_tmp2_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp2_ = vala_ccode_variable_declarator_new (index_name, NULL, NULL)));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) _cdecl_);
	_tmp3_ = NULL;
	_tmp4_ = NULL;
	iter_call = (_tmp4_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp3_ = vala_ccode_identifier_new ("dbus_message_iter_open_container"))), (_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL)), _tmp4_);
	_tmp5_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp5_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, iter_expr)));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	_tmp6_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp6_ = vala_ccode_identifier_new ("DBUS_TYPE_ARRAY")));
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	_tmp10_ = NULL;
	_tmp9_ = NULL;
	_tmp8_ = NULL;
	_tmp7_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp10_ = vala_ccode_constant_new (_tmp9_ = g_strdup_printf ("\"%s%s\"", _tmp7_ = g_strnfill ((gulong) (vala_array_type_get_rank (array_type) - dim), 'a'), _tmp8_ = vala_data_type_get_type_signature (vala_array_type_get_element_type (array_type))))));
	(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
	_tmp9_ = (g_free (_tmp9_), NULL);
	_tmp8_ = (g_free (_tmp8_), NULL);
	_tmp7_ = (g_free (_tmp7_), NULL);
	_tmp12_ = NULL;
	_tmp11_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp12_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp11_ = vala_ccode_identifier_new (subiter_name)))));
	(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
	(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
	_tmp13_ = NULL;
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp13_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
	cforblock = vala_ccode_block_new ();
	cforfragment = vala_ccode_fragment_new ();
	vala_ccode_block_add_statement (cforblock, (ValaCCodeNode*) cforfragment);
	_tmp16_ = NULL;
	_tmp15_ = NULL;
	_tmp14_ = NULL;
	_tmp17_ = NULL;
	cfor = (_tmp17_ = vala_ccode_for_statement_new ((ValaCCodeExpression*) (_tmp16_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, (ValaCCodeExpression*) (_tmp14_ = vala_ccode_identifier_new (index_name)), _tmp15_ = vala_dbus_module_get_array_length (self, array_expr, dim))), (ValaCCodeStatement*) cforblock), (_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL)), (_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL)), (_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL)), _tmp17_);
	_tmp20_ = NULL;
	_tmp19_ = NULL;
	_tmp18_ = NULL;
	vala_ccode_for_statement_add_initializer (cfor, (ValaCCodeExpression*) (_tmp20_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp18_ = vala_ccode_identifier_new (index_name)), (ValaCCodeExpression*) (_tmp19_ = vala_ccode_constant_new ("0")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
	(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL));
	(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
	(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL));
	_tmp22_ = NULL;
	_tmp21_ = NULL;
	vala_ccode_for_statement_add_iterator (cfor, (ValaCCodeExpression*) (_tmp22_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, (ValaCCodeExpression*) (_tmp21_ = vala_ccode_identifier_new (index_name)))));
	(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
	(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
	if (dim < vala_array_type_get_rank (array_type)) {
		ValaCCodeIdentifier* _tmp23_;
		_tmp23_ = NULL;
		vala_dbus_module_write_array_dim (self, cforfragment, array_type, dim + 1, (ValaCCodeExpression*) (_tmp23_ = vala_ccode_identifier_new (subiter_name)), array_expr, array_iter_expr);
		(_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL));
	} else {
		ValaCCodeUnaryExpression* element_expr;
		ValaCCodeIdentifier* _tmp24_;
		ValaCCodeUnaryExpression* array_iter_incr;
		ValaCCodeExpressionStatement* _tmp25_;
		element_expr = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, array_iter_expr);
		_tmp24_ = NULL;
		vala_dbus_module_write_expression (self, cforfragment, vala_array_type_get_element_type (array_type), (ValaCCodeExpression*) (_tmp24_ = vala_ccode_identifier_new (subiter_name)), (ValaCCodeExpression*) element_expr);
		(_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL));
		array_iter_incr = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, array_iter_expr);
		_tmp25_ = NULL;
		vala_ccode_fragment_append (cforfragment, (ValaCCodeNode*) (_tmp25_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) array_iter_incr)));
		(_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_ccode_node_unref (_tmp25_), NULL));
		(element_expr == NULL) ? NULL : (element_expr = (vala_ccode_node_unref (element_expr), NULL));
		(array_iter_incr == NULL) ? NULL : (array_iter_incr = (vala_ccode_node_unref (array_iter_incr), NULL));
	}
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) cfor);
	_tmp27_ = NULL;
	_tmp26_ = NULL;
	iter_call = (_tmp27_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp26_ = vala_ccode_identifier_new ("dbus_message_iter_close_container"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp27_);
	(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL));
	_tmp28_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp28_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, iter_expr)));
	(_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_ccode_node_unref (_tmp28_), NULL));
	_tmp30_ = NULL;
	_tmp29_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp30_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp29_ = vala_ccode_identifier_new (subiter_name)))));
	(_tmp30_ == NULL) ? NULL : (_tmp30_ = (vala_ccode_node_unref (_tmp30_), NULL));
	(_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL));
	_tmp31_ = NULL;
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp31_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp31_ == NULL) ? NULL : (_tmp31_ = (vala_ccode_node_unref (_tmp31_), NULL));
	subiter_name = (g_free (subiter_name), NULL);
	index_name = (g_free (index_name), NULL);
	(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
	(iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL));
	(cforblock == NULL) ? NULL : (cforblock = (vala_ccode_node_unref (cforblock), NULL));
	(cforfragment == NULL) ? NULL : (cforfragment = (vala_ccode_node_unref (cforfragment), NULL));
	(cfor == NULL) ? NULL : (cfor = (vala_ccode_node_unref (cfor), NULL));
}


static void vala_dbus_module_write_struct (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaStruct* st, ValaCCodeExpression* iter_expr, ValaCCodeExpression* struct_expr) {
	char* subiter_name;
	ValaCCodeDeclaration* _cdecl_;
	ValaCCodeVariableDeclarator* _tmp0_;
	ValaCCodeIdentifier* _tmp1_;
	ValaCCodeFunctionCall* _tmp2_;
	ValaCCodeFunctionCall* iter_call;
	ValaCCodeUnaryExpression* _tmp3_;
	ValaCCodeIdentifier* _tmp4_;
	ValaCCodeConstant* _tmp5_;
	ValaCCodeUnaryExpression* _tmp7_;
	ValaCCodeIdentifier* _tmp6_;
	ValaCCodeExpressionStatement* _tmp8_;
	ValaCCodeFunctionCall* _tmp15_;
	ValaCCodeIdentifier* _tmp14_;
	ValaCCodeUnaryExpression* _tmp16_;
	ValaCCodeUnaryExpression* _tmp18_;
	ValaCCodeIdentifier* _tmp17_;
	ValaCCodeExpressionStatement* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (fragment != NULL);
	g_return_if_fail (st != NULL);
	g_return_if_fail (iter_expr != NULL);
	g_return_if_fail (struct_expr != NULL);
	subiter_name = g_strdup_printf ("_tmp%d_", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	_cdecl_ = vala_ccode_declaration_new ("DBusMessageIter");
	_tmp0_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp0_ = vala_ccode_variable_declarator_new (subiter_name, NULL, NULL)));
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) _cdecl_);
	_tmp1_ = NULL;
	_tmp2_ = NULL;
	iter_call = (_tmp2_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp1_ = vala_ccode_identifier_new ("dbus_message_iter_open_container"))), (_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL)), _tmp2_);
	_tmp3_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp3_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, iter_expr)));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	_tmp4_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp4_ = vala_ccode_identifier_new ("DBUS_TYPE_STRUCT")));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	_tmp5_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp5_ = vala_ccode_constant_new ("NULL")));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	_tmp7_ = NULL;
	_tmp6_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp7_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp6_ = vala_ccode_identifier_new (subiter_name)))));
	(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	_tmp8_ = NULL;
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp8_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
	{
		GeeList* _tmp9_;
		GeeIterator* _tmp10_;
		GeeIterator* _f_it;
		_tmp9_ = NULL;
		_tmp10_ = NULL;
		_f_it = (_tmp10_ = gee_iterable_iterator ((GeeIterable*) (_tmp9_ = vala_struct_get_fields (st))), (_tmp9_ == NULL) ? NULL : (_tmp9_ = (gee_collection_object_unref (_tmp9_), NULL)), _tmp10_);
		while (gee_iterator_next (_f_it)) {
			ValaField* f;
			ValaCCodeMemberAccess* _tmp13_;
			char* _tmp12_;
			ValaCCodeIdentifier* _tmp11_;
			f = (ValaField*) gee_iterator_get (_f_it);
			if (vala_field_get_binding (f) != MEMBER_BINDING_INSTANCE) {
				(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
				continue;
			}
			_tmp13_ = NULL;
			_tmp12_ = NULL;
			_tmp11_ = NULL;
			vala_dbus_module_write_expression (self, fragment, vala_field_get_field_type (f), (ValaCCodeExpression*) (_tmp11_ = vala_ccode_identifier_new (subiter_name)), (ValaCCodeExpression*) (_tmp13_ = vala_ccode_member_access_new (struct_expr, _tmp12_ = vala_field_get_cname (f), FALSE)));
			(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
			_tmp12_ = (g_free (_tmp12_), NULL);
			(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
			(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
		}
		(_f_it == NULL) ? NULL : (_f_it = (gee_collection_object_unref (_f_it), NULL));
	}
	_tmp15_ = NULL;
	_tmp14_ = NULL;
	iter_call = (_tmp15_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp14_ = vala_ccode_identifier_new ("dbus_message_iter_close_container"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp15_);
	(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
	_tmp16_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp16_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, iter_expr)));
	(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
	_tmp18_ = NULL;
	_tmp17_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp18_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp17_ = vala_ccode_identifier_new (subiter_name)))));
	(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL));
	(_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL));
	_tmp19_ = NULL;
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp19_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
	subiter_name = (g_free (subiter_name), NULL);
	(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
	(iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL));
}


static void vala_dbus_module_write_value (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaCCodeExpression* iter_expr, ValaCCodeExpression* expr) {
	char* subiter_name;
	ValaCCodeDeclaration* _cdecl_;
	ValaCCodeVariableDeclarator* _tmp0_;
	ValaCCodeIfStatement* clastif;
	g_return_if_fail (self != NULL);
	g_return_if_fail (fragment != NULL);
	g_return_if_fail (iter_expr != NULL);
	g_return_if_fail (expr != NULL);
	subiter_name = g_strdup_printf ("_tmp%d_", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	_cdecl_ = vala_ccode_declaration_new ("DBusMessageIter");
	_tmp0_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp0_ = vala_ccode_variable_declarator_new (subiter_name, NULL, NULL)));
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) _cdecl_);
	clastif = NULL;
	{
		ValaDBusModuleBasicTypeInfo* basic_type_collection;
		int basic_type_collection_length1;
		int basic_type_it;
		basic_type_collection = VALA_DBUS_MODULE_basic_types;
		basic_type_collection_length1 = G_N_ELEMENTS (VALA_DBUS_MODULE_basic_types);
		for (basic_type_it = 0; basic_type_it < G_N_ELEMENTS (VALA_DBUS_MODULE_basic_types); basic_type_it = basic_type_it + 1) {
			ValaDBusModuleBasicTypeInfo basic_type;
			basic_type = basic_type_collection[basic_type_it];
			{
				ValaCCodeIdentifier* _tmp1_;
				ValaCCodeFunctionCall* _tmp2_;
				ValaCCodeFunctionCall* type_call;
				ValaCCodeUnaryExpression* _tmp3_;
				ValaCCodeIdentifier* _tmp4_;
				ValaCCodeBinaryExpression* _tmp5_;
				ValaCCodeBinaryExpression* type_check;
				ValaCCodeBlock* type_block;
				ValaCCodeFragment* type_fragment;
				ValaCCodeIdentifier* _tmp6_;
				ValaCCodeFunctionCall* _tmp7_;
				ValaCCodeFunctionCall* iter_call;
				ValaCCodeUnaryExpression* _tmp8_;
				ValaCCodeIdentifier* _tmp9_;
				ValaCCodeConstant* _tmp11_;
				char* _tmp10_;
				ValaCCodeUnaryExpression* _tmp13_;
				ValaCCodeIdentifier* _tmp12_;
				ValaCCodeExpressionStatement* _tmp14_;
				ValaCCodeIdentifier* _tmp15_;
				ValaCCodeFunctionCall* _tmp16_;
				ValaCCodeFunctionCall* value_get;
				ValaCCodeUnaryExpression* _tmp17_;
				ValaCCodeIdentifier* _tmp18_;
				ValaCCodeFunctionCall* _tmp20_;
				ValaCCodeIdentifier* _tmp19_;
				ValaCCodeUnaryExpression* _tmp21_;
				ValaCCodeUnaryExpression* _tmp23_;
				ValaCCodeIdentifier* _tmp22_;
				ValaCCodeExpressionStatement* _tmp24_;
				ValaCCodeIfStatement* cif;
				ValaCCodeIfStatement* _tmp26_;
				ValaCCodeIfStatement* _tmp25_;
				/* ensure that there is only one case per GType*/
				if (basic_type.get_value_function == NULL) {
					continue;
				}
				_tmp1_ = NULL;
				_tmp2_ = NULL;
				type_call = (_tmp2_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp1_ = vala_ccode_identifier_new ("G_VALUE_TYPE"))), (_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL)), _tmp2_);
				_tmp3_ = NULL;
				vala_ccode_function_call_add_argument (type_call, (ValaCCodeExpression*) (_tmp3_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, expr)));
				(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
				_tmp4_ = NULL;
				_tmp5_ = NULL;
				type_check = (_tmp5_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) type_call, (ValaCCodeExpression*) (_tmp4_ = vala_ccode_identifier_new (basic_type.gtype))), (_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL)), _tmp5_);
				type_block = vala_ccode_block_new ();
				type_fragment = vala_ccode_fragment_new ();
				vala_ccode_block_add_statement (type_block, (ValaCCodeNode*) type_fragment);
				_tmp6_ = NULL;
				_tmp7_ = NULL;
				iter_call = (_tmp7_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp6_ = vala_ccode_identifier_new ("dbus_message_iter_open_container"))), (_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL)), _tmp7_);
				_tmp8_ = NULL;
				vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp8_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, iter_expr)));
				(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
				_tmp9_ = NULL;
				vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp9_ = vala_ccode_identifier_new ("DBUS_TYPE_VARIANT")));
				(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
				_tmp11_ = NULL;
				_tmp10_ = NULL;
				vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp11_ = vala_ccode_constant_new (_tmp10_ = g_strdup_printf ("\"%s\"", basic_type.signature))));
				(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
				_tmp10_ = (g_free (_tmp10_), NULL);
				_tmp13_ = NULL;
				_tmp12_ = NULL;
				vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp13_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp12_ = vala_ccode_identifier_new (subiter_name)))));
				(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
				(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
				_tmp14_ = NULL;
				vala_ccode_fragment_append (type_fragment, (ValaCCodeNode*) (_tmp14_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
				(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
				_tmp15_ = NULL;
				_tmp16_ = NULL;
				value_get = (_tmp16_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp15_ = vala_ccode_identifier_new (basic_type.get_value_function))), (_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL)), _tmp16_);
				_tmp17_ = NULL;
				vala_ccode_function_call_add_argument (value_get, (ValaCCodeExpression*) (_tmp17_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, expr)));
				(_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL));
				_tmp18_ = NULL;
				vala_dbus_module_write_basic (self, type_fragment, &basic_type, (ValaCCodeExpression*) (_tmp18_ = vala_ccode_identifier_new (subiter_name)), (ValaCCodeExpression*) value_get);
				(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL));
				_tmp20_ = NULL;
				_tmp19_ = NULL;
				iter_call = (_tmp20_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp19_ = vala_ccode_identifier_new ("dbus_message_iter_close_container"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp20_);
				(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
				_tmp21_ = NULL;
				vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp21_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, iter_expr)));
				(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
				_tmp23_ = NULL;
				_tmp22_ = NULL;
				vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp23_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp22_ = vala_ccode_identifier_new (subiter_name)))));
				(_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL));
				(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
				_tmp24_ = NULL;
				vala_ccode_fragment_append (type_fragment, (ValaCCodeNode*) (_tmp24_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
				(_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL));
				cif = vala_ccode_if_statement_new ((ValaCCodeExpression*) type_check, (ValaCCodeStatement*) type_block, NULL);
				if (clastif == NULL) {
					vala_ccode_fragment_append (fragment, (ValaCCodeNode*) cif);
				} else {
					vala_ccode_if_statement_set_false_statement (clastif, (ValaCCodeStatement*) cif);
				}
				_tmp26_ = NULL;
				_tmp25_ = NULL;
				clastif = (_tmp26_ = (_tmp25_ = cif, (_tmp25_ == NULL) ? NULL : vala_ccode_node_ref (_tmp25_)), (clastif == NULL) ? NULL : (clastif = (vala_ccode_node_unref (clastif), NULL)), _tmp26_);
				(type_call == NULL) ? NULL : (type_call = (vala_ccode_node_unref (type_call), NULL));
				(type_check == NULL) ? NULL : (type_check = (vala_ccode_node_unref (type_check), NULL));
				(type_block == NULL) ? NULL : (type_block = (vala_ccode_node_unref (type_block), NULL));
				(type_fragment == NULL) ? NULL : (type_fragment = (vala_ccode_node_unref (type_fragment), NULL));
				(iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL));
				(value_get == NULL) ? NULL : (value_get = (vala_ccode_node_unref (value_get), NULL));
				(cif == NULL) ? NULL : (cif = (vala_ccode_node_unref (cif), NULL));
			}
		}
	}
	subiter_name = (g_free (subiter_name), NULL);
	(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
	(clastif == NULL) ? NULL : (clastif = (vala_ccode_node_unref (clastif), NULL));
}


static void vala_dbus_module_write_hash_table (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaObjectType* type, ValaCCodeExpression* iter_expr, ValaCCodeExpression* hash_table_expr) {
	char* subiter_name;
	char* entryiter_name;
	char* tableiter_name;
	char* key_name;
	char* value_name;
	GeeList* type_args;
	ValaDataType* key_type;
	ValaDataType* value_type;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeFunctionCall* _tmp1_;
	ValaCCodeFunctionCall* iter_call;
	ValaCCodeUnaryExpression* _tmp2_;
	ValaCCodeIdentifier* _tmp3_;
	ValaCCodeConstant* _tmp7_;
	char* _tmp6_;
	char* _tmp5_;
	char* _tmp4_;
	ValaCCodeUnaryExpression* _tmp9_;
	ValaCCodeIdentifier* _tmp8_;
	ValaCCodeExpressionStatement* _tmp10_;
	ValaCCodeDeclaration* _cdecl_;
	ValaCCodeVariableDeclarator* _tmp11_;
	ValaCCodeVariableDeclarator* _tmp12_;
	ValaCCodeDeclaration* _tmp13_;
	ValaCCodeVariableDeclarator* _tmp14_;
	ValaCCodeDeclaration* _tmp15_;
	ValaCCodeVariableDeclarator* _tmp16_;
	ValaCCodeVariableDeclarator* _tmp17_;
	ValaCCodeIdentifier* _tmp18_;
	ValaCCodeFunctionCall* _tmp19_;
	ValaCCodeFunctionCall* iter_init_call;
	ValaCCodeUnaryExpression* _tmp21_;
	ValaCCodeIdentifier* _tmp20_;
	ValaCCodeExpressionStatement* _tmp22_;
	ValaCCodeIdentifier* _tmp23_;
	ValaCCodeFunctionCall* _tmp24_;
	ValaCCodeFunctionCall* iter_next_call;
	ValaCCodeUnaryExpression* _tmp26_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeUnaryExpression* _tmp28_;
	ValaCCodeIdentifier* _tmp27_;
	ValaCCodeUnaryExpression* _tmp30_;
	ValaCCodeIdentifier* _tmp29_;
	ValaCCodeBlock* cwhileblock;
	ValaCCodeFragment* cwhilefragment;
	ValaCCodeWhileStatement* cwhile;
	ValaCCodeDeclaration* _tmp32_;
	char* _tmp31_;
	ValaCCodeVariableDeclarator* _tmp33_;
	ValaCCodeDeclaration* _tmp35_;
	char* _tmp34_;
	ValaCCodeVariableDeclarator* _tmp36_;
	ValaCCodeFunctionCall* _tmp38_;
	ValaCCodeIdentifier* _tmp37_;
	ValaCCodeUnaryExpression* _tmp40_;
	ValaCCodeIdentifier* _tmp39_;
	ValaCCodeIdentifier* _tmp41_;
	ValaCCodeConstant* _tmp42_;
	ValaCCodeUnaryExpression* _tmp44_;
	ValaCCodeIdentifier* _tmp43_;
	ValaCCodeExpressionStatement* _tmp45_;
	ValaCCodeExpressionStatement* _tmp50_;
	ValaCCodeAssignment* _tmp49_;
	ValaCCodeExpression* _tmp48_;
	ValaCCodeIdentifier* _tmp47_;
	ValaCCodeIdentifier* _tmp46_;
	ValaCCodeExpressionStatement* _tmp55_;
	ValaCCodeAssignment* _tmp54_;
	ValaCCodeExpression* _tmp53_;
	ValaCCodeIdentifier* _tmp52_;
	ValaCCodeIdentifier* _tmp51_;
	ValaCCodeIdentifier* _tmp57_;
	ValaCCodeIdentifier* _tmp56_;
	ValaCCodeIdentifier* _tmp59_;
	ValaCCodeIdentifier* _tmp58_;
	ValaCCodeFunctionCall* _tmp61_;
	ValaCCodeIdentifier* _tmp60_;
	ValaCCodeUnaryExpression* _tmp63_;
	ValaCCodeIdentifier* _tmp62_;
	ValaCCodeUnaryExpression* _tmp65_;
	ValaCCodeIdentifier* _tmp64_;
	ValaCCodeExpressionStatement* _tmp66_;
	ValaCCodeFunctionCall* _tmp68_;
	ValaCCodeIdentifier* _tmp67_;
	ValaCCodeUnaryExpression* _tmp69_;
	ValaCCodeUnaryExpression* _tmp71_;
	ValaCCodeIdentifier* _tmp70_;
	ValaCCodeExpressionStatement* _tmp72_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (fragment != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (iter_expr != NULL);
	g_return_if_fail (hash_table_expr != NULL);
	subiter_name = g_strdup_printf ("_tmp%d_", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	entryiter_name = g_strdup_printf ("_tmp%d_", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	tableiter_name = g_strdup_printf ("_tmp%d_", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	key_name = g_strdup_printf ("_tmp%d_", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	value_name = g_strdup_printf ("_tmp%d_", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
	type_args = vala_data_type_get_type_arguments ((ValaDataType*) type);
	g_assert (gee_collection_get_size ((GeeCollection*) type_args) == 2);
	key_type = (ValaDataType*) gee_list_get (type_args, 0);
	value_type = (ValaDataType*) gee_list_get (type_args, 1);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	iter_call = (_tmp1_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0_ = vala_ccode_identifier_new ("dbus_message_iter_open_container"))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL)), _tmp1_);
	_tmp2_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp2_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, iter_expr)));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	_tmp3_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp3_ = vala_ccode_identifier_new ("DBUS_TYPE_ARRAY")));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	_tmp7_ = NULL;
	_tmp6_ = NULL;
	_tmp5_ = NULL;
	_tmp4_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp7_ = vala_ccode_constant_new (_tmp6_ = g_strdup_printf ("\"{%s%s}\"", _tmp4_ = vala_data_type_get_type_signature (key_type), _tmp5_ = vala_data_type_get_type_signature (value_type)))));
	(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
	_tmp6_ = (g_free (_tmp6_), NULL);
	_tmp5_ = (g_free (_tmp5_), NULL);
	_tmp4_ = (g_free (_tmp4_), NULL);
	_tmp9_ = NULL;
	_tmp8_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp9_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp8_ = vala_ccode_identifier_new (subiter_name)))));
	(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
	(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
	_tmp10_ = NULL;
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp10_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
	_cdecl_ = vala_ccode_declaration_new ("DBusMessageIter");
	_tmp11_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp11_ = vala_ccode_variable_declarator_new (subiter_name, NULL, NULL)));
	(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
	_tmp12_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp12_ = vala_ccode_variable_declarator_new (entryiter_name, NULL, NULL)));
	(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) _cdecl_);
	_tmp13_ = NULL;
	_cdecl_ = (_tmp13_ = vala_ccode_declaration_new ("GHashTableIter"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp13_);
	_tmp14_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp14_ = vala_ccode_variable_declarator_new (tableiter_name, NULL, NULL)));
	(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) _cdecl_);
	_tmp15_ = NULL;
	_cdecl_ = (_tmp15_ = vala_ccode_declaration_new ("gpointer"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp15_);
	_tmp16_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp16_ = vala_ccode_variable_declarator_new (key_name, NULL, NULL)));
	(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
	_tmp17_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp17_ = vala_ccode_variable_declarator_new (value_name, NULL, NULL)));
	(_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) _cdecl_);
	_tmp18_ = NULL;
	_tmp19_ = NULL;
	iter_init_call = (_tmp19_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp18_ = vala_ccode_identifier_new ("g_hash_table_iter_init"))), (_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL)), _tmp19_);
	_tmp21_ = NULL;
	_tmp20_ = NULL;
	vala_ccode_function_call_add_argument (iter_init_call, (ValaCCodeExpression*) (_tmp21_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp20_ = vala_ccode_identifier_new (tableiter_name)))));
	(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
	(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL));
	vala_ccode_function_call_add_argument (iter_init_call, hash_table_expr);
	_tmp22_ = NULL;
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp22_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_init_call)));
	(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
	_tmp23_ = NULL;
	_tmp24_ = NULL;
	iter_next_call = (_tmp24_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp23_ = vala_ccode_identifier_new ("g_hash_table_iter_next"))), (_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL)), _tmp24_);
	_tmp26_ = NULL;
	_tmp25_ = NULL;
	vala_ccode_function_call_add_argument (iter_next_call, (ValaCCodeExpression*) (_tmp26_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp25_ = vala_ccode_identifier_new (tableiter_name)))));
	(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL));
	(_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_ccode_node_unref (_tmp25_), NULL));
	_tmp28_ = NULL;
	_tmp27_ = NULL;
	vala_ccode_function_call_add_argument (iter_next_call, (ValaCCodeExpression*) (_tmp28_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp27_ = vala_ccode_identifier_new (key_name)))));
	(_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_ccode_node_unref (_tmp28_), NULL));
	(_tmp27_ == NULL) ? NULL : (_tmp27_ = (vala_ccode_node_unref (_tmp27_), NULL));
	_tmp30_ = NULL;
	_tmp29_ = NULL;
	vala_ccode_function_call_add_argument (iter_next_call, (ValaCCodeExpression*) (_tmp30_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp29_ = vala_ccode_identifier_new (value_name)))));
	(_tmp30_ == NULL) ? NULL : (_tmp30_ = (vala_ccode_node_unref (_tmp30_), NULL));
	(_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL));
	cwhileblock = vala_ccode_block_new ();
	cwhilefragment = vala_ccode_fragment_new ();
	vala_ccode_block_add_statement (cwhileblock, (ValaCCodeNode*) cwhilefragment);
	cwhile = vala_ccode_while_statement_new ((ValaCCodeExpression*) iter_next_call, (ValaCCodeStatement*) cwhileblock);
	_tmp32_ = NULL;
	_tmp31_ = NULL;
	_cdecl_ = (_tmp32_ = vala_ccode_declaration_new (_tmp31_ = vala_data_type_get_cname (key_type)), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp32_);
	_tmp31_ = (g_free (_tmp31_), NULL);
	_tmp33_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp33_ = vala_ccode_variable_declarator_new ("_key", NULL, NULL)));
	(_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_ccode_node_unref (_tmp33_), NULL));
	vala_ccode_fragment_append (cwhilefragment, (ValaCCodeNode*) _cdecl_);
	_tmp35_ = NULL;
	_tmp34_ = NULL;
	_cdecl_ = (_tmp35_ = vala_ccode_declaration_new (_tmp34_ = vala_data_type_get_cname (value_type)), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp35_);
	_tmp34_ = (g_free (_tmp34_), NULL);
	_tmp36_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp36_ = vala_ccode_variable_declarator_new ("_value", NULL, NULL)));
	(_tmp36_ == NULL) ? NULL : (_tmp36_ = (vala_ccode_node_unref (_tmp36_), NULL));
	vala_ccode_fragment_append (cwhilefragment, (ValaCCodeNode*) _cdecl_);
	_tmp38_ = NULL;
	_tmp37_ = NULL;
	iter_call = (_tmp38_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp37_ = vala_ccode_identifier_new ("dbus_message_iter_open_container"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp38_);
	(_tmp37_ == NULL) ? NULL : (_tmp37_ = (vala_ccode_node_unref (_tmp37_), NULL));
	_tmp40_ = NULL;
	_tmp39_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp40_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp39_ = vala_ccode_identifier_new (subiter_name)))));
	(_tmp40_ == NULL) ? NULL : (_tmp40_ = (vala_ccode_node_unref (_tmp40_), NULL));
	(_tmp39_ == NULL) ? NULL : (_tmp39_ = (vala_ccode_node_unref (_tmp39_), NULL));
	_tmp41_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp41_ = vala_ccode_identifier_new ("DBUS_TYPE_DICT_ENTRY")));
	(_tmp41_ == NULL) ? NULL : (_tmp41_ = (vala_ccode_node_unref (_tmp41_), NULL));
	_tmp42_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp42_ = vala_ccode_constant_new ("NULL")));
	(_tmp42_ == NULL) ? NULL : (_tmp42_ = (vala_ccode_node_unref (_tmp42_), NULL));
	_tmp44_ = NULL;
	_tmp43_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp44_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp43_ = vala_ccode_identifier_new (entryiter_name)))));
	(_tmp44_ == NULL) ? NULL : (_tmp44_ = (vala_ccode_node_unref (_tmp44_), NULL));
	(_tmp43_ == NULL) ? NULL : (_tmp43_ = (vala_ccode_node_unref (_tmp43_), NULL));
	_tmp45_ = NULL;
	vala_ccode_fragment_append (cwhilefragment, (ValaCCodeNode*) (_tmp45_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp45_ == NULL) ? NULL : (_tmp45_ = (vala_ccode_node_unref (_tmp45_), NULL));
	_tmp50_ = NULL;
	_tmp49_ = NULL;
	_tmp48_ = NULL;
	_tmp47_ = NULL;
	_tmp46_ = NULL;
	vala_ccode_fragment_append (cwhilefragment, (ValaCCodeNode*) (_tmp50_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp49_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp46_ = vala_ccode_identifier_new ("_key")), _tmp48_ = vala_ccode_base_module_convert_from_generic_pointer ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) (_tmp47_ = vala_ccode_identifier_new (key_name)), key_type), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp50_ == NULL) ? NULL : (_tmp50_ = (vala_ccode_node_unref (_tmp50_), NULL));
	(_tmp49_ == NULL) ? NULL : (_tmp49_ = (vala_ccode_node_unref (_tmp49_), NULL));
	(_tmp48_ == NULL) ? NULL : (_tmp48_ = (vala_ccode_node_unref (_tmp48_), NULL));
	(_tmp47_ == NULL) ? NULL : (_tmp47_ = (vala_ccode_node_unref (_tmp47_), NULL));
	(_tmp46_ == NULL) ? NULL : (_tmp46_ = (vala_ccode_node_unref (_tmp46_), NULL));
	_tmp55_ = NULL;
	_tmp54_ = NULL;
	_tmp53_ = NULL;
	_tmp52_ = NULL;
	_tmp51_ = NULL;
	vala_ccode_fragment_append (cwhilefragment, (ValaCCodeNode*) (_tmp55_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp54_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp51_ = vala_ccode_identifier_new ("_value")), _tmp53_ = vala_ccode_base_module_convert_from_generic_pointer ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) (_tmp52_ = vala_ccode_identifier_new (value_name)), value_type), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp55_ == NULL) ? NULL : (_tmp55_ = (vala_ccode_node_unref (_tmp55_), NULL));
	(_tmp54_ == NULL) ? NULL : (_tmp54_ = (vala_ccode_node_unref (_tmp54_), NULL));
	(_tmp53_ == NULL) ? NULL : (_tmp53_ = (vala_ccode_node_unref (_tmp53_), NULL));
	(_tmp52_ == NULL) ? NULL : (_tmp52_ = (vala_ccode_node_unref (_tmp52_), NULL));
	(_tmp51_ == NULL) ? NULL : (_tmp51_ = (vala_ccode_node_unref (_tmp51_), NULL));
	_tmp57_ = NULL;
	_tmp56_ = NULL;
	vala_dbus_module_write_expression (self, cwhilefragment, key_type, (ValaCCodeExpression*) (_tmp56_ = vala_ccode_identifier_new (entryiter_name)), (ValaCCodeExpression*) (_tmp57_ = vala_ccode_identifier_new ("_key")));
	(_tmp57_ == NULL) ? NULL : (_tmp57_ = (vala_ccode_node_unref (_tmp57_), NULL));
	(_tmp56_ == NULL) ? NULL : (_tmp56_ = (vala_ccode_node_unref (_tmp56_), NULL));
	_tmp59_ = NULL;
	_tmp58_ = NULL;
	vala_dbus_module_write_expression (self, cwhilefragment, value_type, (ValaCCodeExpression*) (_tmp58_ = vala_ccode_identifier_new (entryiter_name)), (ValaCCodeExpression*) (_tmp59_ = vala_ccode_identifier_new ("_value")));
	(_tmp59_ == NULL) ? NULL : (_tmp59_ = (vala_ccode_node_unref (_tmp59_), NULL));
	(_tmp58_ == NULL) ? NULL : (_tmp58_ = (vala_ccode_node_unref (_tmp58_), NULL));
	_tmp61_ = NULL;
	_tmp60_ = NULL;
	iter_call = (_tmp61_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp60_ = vala_ccode_identifier_new ("dbus_message_iter_close_container"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp61_);
	(_tmp60_ == NULL) ? NULL : (_tmp60_ = (vala_ccode_node_unref (_tmp60_), NULL));
	_tmp63_ = NULL;
	_tmp62_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp63_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp62_ = vala_ccode_identifier_new (subiter_name)))));
	(_tmp63_ == NULL) ? NULL : (_tmp63_ = (vala_ccode_node_unref (_tmp63_), NULL));
	(_tmp62_ == NULL) ? NULL : (_tmp62_ = (vala_ccode_node_unref (_tmp62_), NULL));
	_tmp65_ = NULL;
	_tmp64_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp65_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp64_ = vala_ccode_identifier_new (entryiter_name)))));
	(_tmp65_ == NULL) ? NULL : (_tmp65_ = (vala_ccode_node_unref (_tmp65_), NULL));
	(_tmp64_ == NULL) ? NULL : (_tmp64_ = (vala_ccode_node_unref (_tmp64_), NULL));
	_tmp66_ = NULL;
	vala_ccode_fragment_append (cwhilefragment, (ValaCCodeNode*) (_tmp66_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp66_ == NULL) ? NULL : (_tmp66_ = (vala_ccode_node_unref (_tmp66_), NULL));
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) cwhile);
	_tmp68_ = NULL;
	_tmp67_ = NULL;
	iter_call = (_tmp68_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp67_ = vala_ccode_identifier_new ("dbus_message_iter_close_container"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp68_);
	(_tmp67_ == NULL) ? NULL : (_tmp67_ = (vala_ccode_node_unref (_tmp67_), NULL));
	_tmp69_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp69_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, iter_expr)));
	(_tmp69_ == NULL) ? NULL : (_tmp69_ = (vala_ccode_node_unref (_tmp69_), NULL));
	_tmp71_ = NULL;
	_tmp70_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp71_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp70_ = vala_ccode_identifier_new (subiter_name)))));
	(_tmp71_ == NULL) ? NULL : (_tmp71_ = (vala_ccode_node_unref (_tmp71_), NULL));
	(_tmp70_ == NULL) ? NULL : (_tmp70_ = (vala_ccode_node_unref (_tmp70_), NULL));
	_tmp72_ = NULL;
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp72_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp72_ == NULL) ? NULL : (_tmp72_ = (vala_ccode_node_unref (_tmp72_), NULL));
	subiter_name = (g_free (subiter_name), NULL);
	entryiter_name = (g_free (entryiter_name), NULL);
	tableiter_name = (g_free (tableiter_name), NULL);
	key_name = (g_free (key_name), NULL);
	value_name = (g_free (value_name), NULL);
	(type_args == NULL) ? NULL : (type_args = (gee_collection_object_unref (type_args), NULL));
	(key_type == NULL) ? NULL : (key_type = (vala_code_node_unref (key_type), NULL));
	(value_type == NULL) ? NULL : (value_type = (vala_code_node_unref (value_type), NULL));
	(iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL));
	(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
	(iter_init_call == NULL) ? NULL : (iter_init_call = (vala_ccode_node_unref (iter_init_call), NULL));
	(iter_next_call == NULL) ? NULL : (iter_next_call = (vala_ccode_node_unref (iter_next_call), NULL));
	(cwhileblock == NULL) ? NULL : (cwhileblock = (vala_ccode_node_unref (cwhileblock), NULL));
	(cwhilefragment == NULL) ? NULL : (cwhilefragment = (vala_ccode_node_unref (cwhilefragment), NULL));
	(cwhile == NULL) ? NULL : (cwhile = (vala_ccode_node_unref (cwhile), NULL));
}


void vala_dbus_module_write_expression (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaDataType* type, ValaCCodeExpression* iter_expr, ValaCCodeExpression* expr) {
	ValaDBusModuleBasicTypeInfo basic_type = {0};
	char* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (fragment != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (iter_expr != NULL);
	g_return_if_fail (expr != NULL);
	_tmp0_ = NULL;
	if ((_tmp1_ = vala_dbus_module_get_basic_type_info (self, _tmp0_ = vala_data_type_get_type_signature (type), &basic_type), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_)) {
		vala_dbus_module_write_basic (self, fragment, &basic_type, iter_expr, expr);
	} else {
		if (VALA_IS_ARRAY_TYPE (type)) {
			vala_dbus_module_write_array (self, fragment, VALA_ARRAY_TYPE (type), iter_expr, expr);
		} else {
			if (VALA_IS_STRUCT (vala_data_type_get_data_type (type))) {
				ValaCCodeExpression* _tmp2_;
				ValaCCodeExpression* st_expr;
				char* _tmp4_;
				gboolean _tmp5_;
				_tmp2_ = NULL;
				st_expr = (_tmp2_ = expr, (_tmp2_ == NULL) ? NULL : vala_ccode_node_ref (_tmp2_));
				if (vala_data_type_get_nullable (type)) {
					ValaCCodeExpression* _tmp3_;
					_tmp3_ = NULL;
					st_expr = (_tmp3_ = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, st_expr), (st_expr == NULL) ? NULL : (st_expr = (vala_ccode_node_unref (st_expr), NULL)), _tmp3_);
				}
				_tmp4_ = NULL;
				if ((_tmp5_ = _vala_strcmp0 (_tmp4_ = vala_symbol_get_full_name ((ValaSymbol*) vala_data_type_get_data_type (type)), "GLib.Value") == 0, _tmp4_ = (g_free (_tmp4_), NULL), _tmp5_)) {
					vala_dbus_module_write_value (self, fragment, iter_expr, st_expr);
				} else {
					vala_dbus_module_write_struct (self, fragment, VALA_STRUCT (vala_data_type_get_data_type (type)), iter_expr, st_expr);
				}
				(st_expr == NULL) ? NULL : (st_expr = (vala_ccode_node_unref (st_expr), NULL));
			} else {
				if (VALA_IS_OBJECT_TYPE (type)) {
					char* _tmp6_;
					gboolean _tmp7_;
					_tmp6_ = NULL;
					if ((_tmp7_ = _vala_strcmp0 (_tmp6_ = vala_symbol_get_full_name ((ValaSymbol*) vala_data_type_get_data_type (type)), "GLib.HashTable") == 0, _tmp6_ = (g_free (_tmp6_), NULL), _tmp7_)) {
						vala_dbus_module_write_hash_table (self, fragment, VALA_OBJECT_TYPE (type), iter_expr, expr);
					}
				} else {
					char* _tmp9_;
					char* _tmp8_;
					_tmp9_ = NULL;
					_tmp8_ = NULL;
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) type), _tmp9_ = g_strdup_printf ("D-Bus serialization of type `%s' is not supported", _tmp8_ = vala_code_node_to_string ((ValaCodeNode*) type)));
					_tmp9_ = (g_free (_tmp9_), NULL);
					_tmp8_ = (g_free (_tmp8_), NULL);
				}
			}
		}
	}
}


static ValaDBusModuleBasicTypeInfo* vala_dbus_module_basic_type_info_dup (const ValaDBusModuleBasicTypeInfo* self) {
	ValaDBusModuleBasicTypeInfo* dup;
	dup = g_new0 (ValaDBusModuleBasicTypeInfo, 1);
	memcpy (dup, self, sizeof (ValaDBusModuleBasicTypeInfo));
	return dup;
}


static void vala_dbus_module_basic_type_info_free (ValaDBusModuleBasicTypeInfo* self) {
	g_free (self);
}


static GType vala_dbus_module_basic_type_info_get_type (void) {
	static GType vala_dbus_module_basic_type_info_type_id = 0;
	if (vala_dbus_module_basic_type_info_type_id == 0) {
		vala_dbus_module_basic_type_info_type_id = g_boxed_type_register_static ("ValaDBusModuleBasicTypeInfo", (GBoxedCopyFunc) vala_dbus_module_basic_type_info_dup, (GBoxedFreeFunc) vala_dbus_module_basic_type_info_free);
	}
	return vala_dbus_module_basic_type_info_type_id;
}


static void vala_dbus_module_class_init (ValaDBusModuleClass * klass) {
	vala_dbus_module_parent_class = g_type_class_peek_parent (klass);
}


static void vala_dbus_module_instance_init (ValaDBusModule * self) {
}


GType vala_dbus_module_get_type (void) {
	static GType vala_dbus_module_type_id = 0;
	if (vala_dbus_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDBusModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_dbus_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDBusModule), 0, (GInstanceInitFunc) vala_dbus_module_instance_init, NULL };
		vala_dbus_module_type_id = g_type_register_static (VALA_TYPE_GASYNC_MODULE, "ValaDBusModule", &g_define_type_info, 0);
	}
	return vala_dbus_module_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




