/* valasemanticanalyzer.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;
typedef struct _ValaCodeVisitorPrivate ValaCodeVisitorPrivate;

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;

#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespace ValaNamespace;
typedef struct _ValaNamespaceClass ValaNamespaceClass;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_OBJECT_TYPE_SYMBOL (vala_object_type_symbol_get_type ())
#define VALA_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))
#define VALA_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))
#define VALA_IS_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_IS_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_OBJECT_TYPE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))

typedef struct _ValaObjectTypeSymbol ValaObjectTypeSymbol;
typedef struct _ValaObjectTypeSymbolClass ValaObjectTypeSymbolClass;

#define VALA_TYPE_CLASS (vala_class_get_type ())
#define VALA_CLASS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS, ValaClass))
#define VALA_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS, ValaClassClass))
#define VALA_IS_CLASS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS))
#define VALA_IS_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS))
#define VALA_CLASS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS, ValaClassClass))

typedef struct _ValaClass ValaClass;
typedef struct _ValaClassClass ValaClassClass;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;

#define VALA_TYPE_INTERFACE (vala_interface_get_type ())
#define VALA_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE, ValaInterface))
#define VALA_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE, ValaInterfaceClass))
#define VALA_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE))
#define VALA_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE))
#define VALA_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE, ValaInterfaceClass))

typedef struct _ValaInterface ValaInterface;
typedef struct _ValaInterfaceClass ValaInterfaceClass;

#define VALA_TYPE_ENUM (vala_enum_get_type ())
#define VALA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM, ValaEnum))
#define VALA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM, ValaEnumClass))
#define VALA_IS_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM))
#define VALA_IS_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM))
#define VALA_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM, ValaEnumClass))

typedef struct _ValaEnum ValaEnum;
typedef struct _ValaEnumClass ValaEnumClass;

#define VALA_TYPE_ENUM_VALUE (vala_enum_value_get_type ())
#define VALA_ENUM_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM_VALUE, ValaEnumValue))
#define VALA_ENUM_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM_VALUE, ValaEnumValueClass))
#define VALA_IS_ENUM_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM_VALUE))
#define VALA_IS_ENUM_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM_VALUE))
#define VALA_ENUM_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM_VALUE, ValaEnumValueClass))

typedef struct _ValaEnumValue ValaEnumValue;
typedef struct _ValaEnumValueClass ValaEnumValueClass;

#define VALA_TYPE_ERROR_DOMAIN (vala_error_domain_get_type ())
#define VALA_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain))
#define VALA_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))
#define VALA_IS_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_DOMAIN))
#define VALA_IS_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_DOMAIN))
#define VALA_ERROR_DOMAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))

typedef struct _ValaErrorDomain ValaErrorDomain;
typedef struct _ValaErrorDomainClass ValaErrorDomainClass;

#define VALA_TYPE_ERROR_CODE (vala_error_code_get_type ())
#define VALA_ERROR_CODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_CODE, ValaErrorCode))
#define VALA_ERROR_CODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_CODE, ValaErrorCodeClass))
#define VALA_IS_ERROR_CODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_CODE))
#define VALA_IS_ERROR_CODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_CODE))
#define VALA_ERROR_CODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_CODE, ValaErrorCodeClass))

typedef struct _ValaErrorCode ValaErrorCode;
typedef struct _ValaErrorCodeClass ValaErrorCodeClass;

#define VALA_TYPE_DELEGATE (vala_delegate_get_type ())
#define VALA_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE, ValaDelegate))
#define VALA_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE, ValaDelegateClass))
#define VALA_IS_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE))
#define VALA_IS_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE))
#define VALA_DELEGATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE, ValaDelegateClass))

typedef struct _ValaDelegate ValaDelegate;
typedef struct _ValaDelegateClass ValaDelegateClass;

#define VALA_TYPE_MEMBER (vala_member_get_type ())
#define VALA_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER, ValaMember))
#define VALA_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER, ValaMemberClass))
#define VALA_IS_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER))
#define VALA_IS_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER))
#define VALA_MEMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER, ValaMemberClass))

typedef struct _ValaMember ValaMember;
typedef struct _ValaMemberClass ValaMemberClass;

#define VALA_TYPE_CONSTANT (vala_constant_get_type ())
#define VALA_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTANT, ValaConstant))
#define VALA_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTANT, ValaConstantClass))
#define VALA_IS_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTANT))
#define VALA_IS_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTANT))
#define VALA_CONSTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTANT, ValaConstantClass))

typedef struct _ValaConstant ValaConstant;
typedef struct _ValaConstantClass ValaConstantClass;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_CREATION_METHOD (vala_creation_method_get_type ())
#define VALA_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethod))
#define VALA_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))
#define VALA_IS_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CREATION_METHOD))
#define VALA_IS_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CREATION_METHOD))
#define VALA_CREATION_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))

typedef struct _ValaCreationMethod ValaCreationMethod;
typedef struct _ValaCreationMethodClass ValaCreationMethodClass;

#define VALA_TYPE_FORMAL_PARAMETER (vala_formal_parameter_get_type ())
#define VALA_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameter))
#define VALA_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))
#define VALA_IS_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_IS_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_FORMAL_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))

typedef struct _ValaFormalParameter ValaFormalParameter;
typedef struct _ValaFormalParameterClass ValaFormalParameterClass;

#define VALA_TYPE_PROPERTY (vala_property_get_type ())
#define VALA_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY, ValaProperty))
#define VALA_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY, ValaPropertyClass))
#define VALA_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY))
#define VALA_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY))
#define VALA_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY, ValaPropertyClass))

typedef struct _ValaProperty ValaProperty;
typedef struct _ValaPropertyClass ValaPropertyClass;

#define VALA_TYPE_PROPERTY_ACCESSOR (vala_property_accessor_get_type ())
#define VALA_PROPERTY_ACCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessor))
#define VALA_PROPERTY_ACCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessorClass))
#define VALA_IS_PROPERTY_ACCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY_ACCESSOR))
#define VALA_IS_PROPERTY_ACCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY_ACCESSOR))
#define VALA_PROPERTY_ACCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessorClass))

typedef struct _ValaPropertyAccessor ValaPropertyAccessor;
typedef struct _ValaPropertyAccessorClass ValaPropertyAccessorClass;

#define VALA_TYPE_SIGNAL (vala_signal_get_type ())
#define VALA_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIGNAL, ValaSignal))
#define VALA_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIGNAL, ValaSignalClass))
#define VALA_IS_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIGNAL))
#define VALA_IS_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIGNAL))
#define VALA_SIGNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIGNAL, ValaSignalClass))

typedef struct _ValaSignal ValaSignal;
typedef struct _ValaSignalClass ValaSignalClass;

#define VALA_TYPE_CONSTRUCTOR (vala_constructor_get_type ())
#define VALA_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructor))
#define VALA_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))
#define VALA_IS_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTRUCTOR))
#define VALA_IS_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTRUCTOR))
#define VALA_CONSTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))

typedef struct _ValaConstructor ValaConstructor;
typedef struct _ValaConstructorClass ValaConstructorClass;

#define VALA_TYPE_DESTRUCTOR (vala_destructor_get_type ())
#define VALA_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructor))
#define VALA_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))
#define VALA_IS_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DESTRUCTOR))
#define VALA_IS_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DESTRUCTOR))
#define VALA_DESTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))

typedef struct _ValaDestructor ValaDestructor;
typedef struct _ValaDestructorClass ValaDestructorClass;

#define VALA_TYPE_TYPEPARAMETER (vala_typeparameter_get_type ())
#define VALA_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameter))
#define VALA_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))
#define VALA_IS_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEPARAMETER))
#define VALA_IS_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEPARAMETER))
#define VALA_TYPEPARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))

typedef struct _ValaTypeParameter ValaTypeParameter;
typedef struct _ValaTypeParameterClass ValaTypeParameterClass;

#define VALA_TYPE_USING_DIRECTIVE (vala_using_directive_get_type ())
#define VALA_USING_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirective))
#define VALA_USING_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirectiveClass))
#define VALA_IS_USING_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_USING_DIRECTIVE))
#define VALA_IS_USING_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_USING_DIRECTIVE))
#define VALA_USING_DIRECTIVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirectiveClass))

typedef struct _ValaUsingDirective ValaUsingDirective;
typedef struct _ValaUsingDirectiveClass ValaUsingDirectiveClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_BLOCK (vala_block_get_type ())
#define VALA_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BLOCK, ValaBlock))
#define VALA_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BLOCK, ValaBlockClass))
#define VALA_IS_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BLOCK))
#define VALA_IS_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BLOCK))
#define VALA_BLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BLOCK, ValaBlockClass))

typedef struct _ValaBlock ValaBlock;
typedef struct _ValaBlockClass ValaBlockClass;

#define VALA_TYPE_EMPTY_STATEMENT (vala_empty_statement_get_type ())
#define VALA_EMPTY_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EMPTY_STATEMENT, ValaEmptyStatement))
#define VALA_EMPTY_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EMPTY_STATEMENT, ValaEmptyStatementClass))
#define VALA_IS_EMPTY_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EMPTY_STATEMENT))
#define VALA_IS_EMPTY_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EMPTY_STATEMENT))
#define VALA_EMPTY_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EMPTY_STATEMENT, ValaEmptyStatementClass))

typedef struct _ValaEmptyStatement ValaEmptyStatement;
typedef struct _ValaEmptyStatementClass ValaEmptyStatementClass;

#define VALA_TYPE_DECLARATION_STATEMENT (vala_declaration_statement_get_type ())
#define VALA_DECLARATION_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DECLARATION_STATEMENT, ValaDeclarationStatement))
#define VALA_DECLARATION_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DECLARATION_STATEMENT, ValaDeclarationStatementClass))
#define VALA_IS_DECLARATION_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DECLARATION_STATEMENT))
#define VALA_IS_DECLARATION_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DECLARATION_STATEMENT))
#define VALA_DECLARATION_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DECLARATION_STATEMENT, ValaDeclarationStatementClass))

typedef struct _ValaDeclarationStatement ValaDeclarationStatement;
typedef struct _ValaDeclarationStatementClass ValaDeclarationStatementClass;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_INITIALIZER_LIST (vala_initializer_list_get_type ())
#define VALA_INITIALIZER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INITIALIZER_LIST, ValaInitializerList))
#define VALA_INITIALIZER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INITIALIZER_LIST, ValaInitializerListClass))
#define VALA_IS_INITIALIZER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INITIALIZER_LIST))
#define VALA_IS_INITIALIZER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INITIALIZER_LIST))
#define VALA_INITIALIZER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INITIALIZER_LIST, ValaInitializerListClass))

typedef struct _ValaInitializerList ValaInitializerList;
typedef struct _ValaInitializerListClass ValaInitializerListClass;

#define VALA_TYPE_EXPRESSION_STATEMENT (vala_expression_statement_get_type ())
#define VALA_EXPRESSION_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION_STATEMENT, ValaExpressionStatement))
#define VALA_EXPRESSION_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION_STATEMENT, ValaExpressionStatementClass))
#define VALA_IS_EXPRESSION_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION_STATEMENT))
#define VALA_IS_EXPRESSION_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION_STATEMENT))
#define VALA_EXPRESSION_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION_STATEMENT, ValaExpressionStatementClass))

typedef struct _ValaExpressionStatement ValaExpressionStatement;
typedef struct _ValaExpressionStatementClass ValaExpressionStatementClass;

#define VALA_TYPE_IF_STATEMENT (vala_if_statement_get_type ())
#define VALA_IF_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_IF_STATEMENT, ValaIfStatement))
#define VALA_IF_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_IF_STATEMENT, ValaIfStatementClass))
#define VALA_IS_IF_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_IF_STATEMENT))
#define VALA_IS_IF_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_IF_STATEMENT))
#define VALA_IF_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_IF_STATEMENT, ValaIfStatementClass))

typedef struct _ValaIfStatement ValaIfStatement;
typedef struct _ValaIfStatementClass ValaIfStatementClass;

#define VALA_TYPE_SWITCH_STATEMENT (vala_switch_statement_get_type ())
#define VALA_SWITCH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SWITCH_STATEMENT, ValaSwitchStatement))
#define VALA_SWITCH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SWITCH_STATEMENT, ValaSwitchStatementClass))
#define VALA_IS_SWITCH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SWITCH_STATEMENT))
#define VALA_IS_SWITCH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SWITCH_STATEMENT))
#define VALA_SWITCH_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SWITCH_STATEMENT, ValaSwitchStatementClass))

typedef struct _ValaSwitchStatement ValaSwitchStatement;
typedef struct _ValaSwitchStatementClass ValaSwitchStatementClass;

#define VALA_TYPE_SWITCH_SECTION (vala_switch_section_get_type ())
#define VALA_SWITCH_SECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SWITCH_SECTION, ValaSwitchSection))
#define VALA_SWITCH_SECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SWITCH_SECTION, ValaSwitchSectionClass))
#define VALA_IS_SWITCH_SECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SWITCH_SECTION))
#define VALA_IS_SWITCH_SECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SWITCH_SECTION))
#define VALA_SWITCH_SECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SWITCH_SECTION, ValaSwitchSectionClass))

typedef struct _ValaSwitchSection ValaSwitchSection;
typedef struct _ValaSwitchSectionClass ValaSwitchSectionClass;

#define VALA_TYPE_SWITCH_LABEL (vala_switch_label_get_type ())
#define VALA_SWITCH_LABEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SWITCH_LABEL, ValaSwitchLabel))
#define VALA_SWITCH_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SWITCH_LABEL, ValaSwitchLabelClass))
#define VALA_IS_SWITCH_LABEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SWITCH_LABEL))
#define VALA_IS_SWITCH_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SWITCH_LABEL))
#define VALA_SWITCH_LABEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SWITCH_LABEL, ValaSwitchLabelClass))

typedef struct _ValaSwitchLabel ValaSwitchLabel;
typedef struct _ValaSwitchLabelClass ValaSwitchLabelClass;

#define VALA_TYPE_WHILE_STATEMENT (vala_while_statement_get_type ())
#define VALA_WHILE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_WHILE_STATEMENT, ValaWhileStatement))
#define VALA_WHILE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_WHILE_STATEMENT, ValaWhileStatementClass))
#define VALA_IS_WHILE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_WHILE_STATEMENT))
#define VALA_IS_WHILE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_WHILE_STATEMENT))
#define VALA_WHILE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_WHILE_STATEMENT, ValaWhileStatementClass))

typedef struct _ValaWhileStatement ValaWhileStatement;
typedef struct _ValaWhileStatementClass ValaWhileStatementClass;

#define VALA_TYPE_DO_STATEMENT (vala_do_statement_get_type ())
#define VALA_DO_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DO_STATEMENT, ValaDoStatement))
#define VALA_DO_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DO_STATEMENT, ValaDoStatementClass))
#define VALA_IS_DO_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DO_STATEMENT))
#define VALA_IS_DO_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DO_STATEMENT))
#define VALA_DO_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DO_STATEMENT, ValaDoStatementClass))

typedef struct _ValaDoStatement ValaDoStatement;
typedef struct _ValaDoStatementClass ValaDoStatementClass;

#define VALA_TYPE_FOR_STATEMENT (vala_for_statement_get_type ())
#define VALA_FOR_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FOR_STATEMENT, ValaForStatement))
#define VALA_FOR_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FOR_STATEMENT, ValaForStatementClass))
#define VALA_IS_FOR_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FOR_STATEMENT))
#define VALA_IS_FOR_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FOR_STATEMENT))
#define VALA_FOR_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FOR_STATEMENT, ValaForStatementClass))

typedef struct _ValaForStatement ValaForStatement;
typedef struct _ValaForStatementClass ValaForStatementClass;

#define VALA_TYPE_FOREACH_STATEMENT (vala_foreach_statement_get_type ())
#define VALA_FOREACH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FOREACH_STATEMENT, ValaForeachStatement))
#define VALA_FOREACH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FOREACH_STATEMENT, ValaForeachStatementClass))
#define VALA_IS_FOREACH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FOREACH_STATEMENT))
#define VALA_IS_FOREACH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FOREACH_STATEMENT))
#define VALA_FOREACH_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FOREACH_STATEMENT, ValaForeachStatementClass))

typedef struct _ValaForeachStatement ValaForeachStatement;
typedef struct _ValaForeachStatementClass ValaForeachStatementClass;

#define VALA_TYPE_BREAK_STATEMENT (vala_break_statement_get_type ())
#define VALA_BREAK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BREAK_STATEMENT, ValaBreakStatement))
#define VALA_BREAK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BREAK_STATEMENT, ValaBreakStatementClass))
#define VALA_IS_BREAK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BREAK_STATEMENT))
#define VALA_IS_BREAK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BREAK_STATEMENT))
#define VALA_BREAK_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BREAK_STATEMENT, ValaBreakStatementClass))

typedef struct _ValaBreakStatement ValaBreakStatement;
typedef struct _ValaBreakStatementClass ValaBreakStatementClass;

#define VALA_TYPE_CONTINUE_STATEMENT (vala_continue_statement_get_type ())
#define VALA_CONTINUE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONTINUE_STATEMENT, ValaContinueStatement))
#define VALA_CONTINUE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONTINUE_STATEMENT, ValaContinueStatementClass))
#define VALA_IS_CONTINUE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONTINUE_STATEMENT))
#define VALA_IS_CONTINUE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONTINUE_STATEMENT))
#define VALA_CONTINUE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONTINUE_STATEMENT, ValaContinueStatementClass))

typedef struct _ValaContinueStatement ValaContinueStatement;
typedef struct _ValaContinueStatementClass ValaContinueStatementClass;

#define VALA_TYPE_RETURN_STATEMENT (vala_return_statement_get_type ())
#define VALA_RETURN_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_RETURN_STATEMENT, ValaReturnStatement))
#define VALA_RETURN_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_RETURN_STATEMENT, ValaReturnStatementClass))
#define VALA_IS_RETURN_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_RETURN_STATEMENT))
#define VALA_IS_RETURN_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_RETURN_STATEMENT))
#define VALA_RETURN_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_RETURN_STATEMENT, ValaReturnStatementClass))

typedef struct _ValaReturnStatement ValaReturnStatement;
typedef struct _ValaReturnStatementClass ValaReturnStatementClass;

#define VALA_TYPE_YIELD_STATEMENT (vala_yield_statement_get_type ())
#define VALA_YIELD_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_YIELD_STATEMENT, ValaYieldStatement))
#define VALA_YIELD_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_YIELD_STATEMENT, ValaYieldStatementClass))
#define VALA_IS_YIELD_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_YIELD_STATEMENT))
#define VALA_IS_YIELD_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_YIELD_STATEMENT))
#define VALA_YIELD_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_YIELD_STATEMENT, ValaYieldStatementClass))

typedef struct _ValaYieldStatement ValaYieldStatement;
typedef struct _ValaYieldStatementClass ValaYieldStatementClass;

#define VALA_TYPE_THROW_STATEMENT (vala_throw_statement_get_type ())
#define VALA_THROW_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_THROW_STATEMENT, ValaThrowStatement))
#define VALA_THROW_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_THROW_STATEMENT, ValaThrowStatementClass))
#define VALA_IS_THROW_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_THROW_STATEMENT))
#define VALA_IS_THROW_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_THROW_STATEMENT))
#define VALA_THROW_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_THROW_STATEMENT, ValaThrowStatementClass))

typedef struct _ValaThrowStatement ValaThrowStatement;
typedef struct _ValaThrowStatementClass ValaThrowStatementClass;

#define VALA_TYPE_TRY_STATEMENT (vala_try_statement_get_type ())
#define VALA_TRY_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TRY_STATEMENT, ValaTryStatement))
#define VALA_TRY_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TRY_STATEMENT, ValaTryStatementClass))
#define VALA_IS_TRY_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TRY_STATEMENT))
#define VALA_IS_TRY_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TRY_STATEMENT))
#define VALA_TRY_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TRY_STATEMENT, ValaTryStatementClass))

typedef struct _ValaTryStatement ValaTryStatement;
typedef struct _ValaTryStatementClass ValaTryStatementClass;

#define VALA_TYPE_CATCH_CLAUSE (vala_catch_clause_get_type ())
#define VALA_CATCH_CLAUSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CATCH_CLAUSE, ValaCatchClause))
#define VALA_CATCH_CLAUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CATCH_CLAUSE, ValaCatchClauseClass))
#define VALA_IS_CATCH_CLAUSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CATCH_CLAUSE))
#define VALA_IS_CATCH_CLAUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CATCH_CLAUSE))
#define VALA_CATCH_CLAUSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CATCH_CLAUSE, ValaCatchClauseClass))

typedef struct _ValaCatchClause ValaCatchClause;
typedef struct _ValaCatchClauseClass ValaCatchClauseClass;

#define VALA_TYPE_LOCK_STATEMENT (vala_lock_statement_get_type ())
#define VALA_LOCK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCK_STATEMENT, ValaLockStatement))
#define VALA_LOCK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCK_STATEMENT, ValaLockStatementClass))
#define VALA_IS_LOCK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCK_STATEMENT))
#define VALA_IS_LOCK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCK_STATEMENT))
#define VALA_LOCK_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCK_STATEMENT, ValaLockStatementClass))

typedef struct _ValaLockStatement ValaLockStatement;
typedef struct _ValaLockStatementClass ValaLockStatementClass;

#define VALA_TYPE_DELETE_STATEMENT (vala_delete_statement_get_type ())
#define VALA_DELETE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELETE_STATEMENT, ValaDeleteStatement))
#define VALA_DELETE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELETE_STATEMENT, ValaDeleteStatementClass))
#define VALA_IS_DELETE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELETE_STATEMENT))
#define VALA_IS_DELETE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELETE_STATEMENT))
#define VALA_DELETE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELETE_STATEMENT, ValaDeleteStatementClass))

typedef struct _ValaDeleteStatement ValaDeleteStatement;
typedef struct _ValaDeleteStatementClass ValaDeleteStatementClass;

#define VALA_TYPE_ARRAY_CREATION_EXPRESSION (vala_array_creation_expression_get_type ())
#define VALA_ARRAY_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression))
#define VALA_ARRAY_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpressionClass))
#define VALA_IS_ARRAY_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ARRAY_CREATION_EXPRESSION))
#define VALA_IS_ARRAY_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ARRAY_CREATION_EXPRESSION))
#define VALA_ARRAY_CREATION_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpressionClass))

typedef struct _ValaArrayCreationExpression ValaArrayCreationExpression;
typedef struct _ValaArrayCreationExpressionClass ValaArrayCreationExpressionClass;

#define VALA_TYPE_LITERAL (vala_literal_get_type ())
#define VALA_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LITERAL, ValaLiteral))
#define VALA_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LITERAL, ValaLiteralClass))
#define VALA_IS_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LITERAL))
#define VALA_IS_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LITERAL))
#define VALA_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LITERAL, ValaLiteralClass))

typedef struct _ValaLiteral ValaLiteral;
typedef struct _ValaLiteralClass ValaLiteralClass;

#define VALA_TYPE_BOOLEAN_LITERAL (vala_boolean_literal_get_type ())
#define VALA_BOOLEAN_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BOOLEAN_LITERAL, ValaBooleanLiteral))
#define VALA_BOOLEAN_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BOOLEAN_LITERAL, ValaBooleanLiteralClass))
#define VALA_IS_BOOLEAN_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BOOLEAN_LITERAL))
#define VALA_IS_BOOLEAN_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BOOLEAN_LITERAL))
#define VALA_BOOLEAN_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BOOLEAN_LITERAL, ValaBooleanLiteralClass))

typedef struct _ValaBooleanLiteral ValaBooleanLiteral;
typedef struct _ValaBooleanLiteralClass ValaBooleanLiteralClass;

#define VALA_TYPE_CHARACTER_LITERAL (vala_character_literal_get_type ())
#define VALA_CHARACTER_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CHARACTER_LITERAL, ValaCharacterLiteral))
#define VALA_CHARACTER_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CHARACTER_LITERAL, ValaCharacterLiteralClass))
#define VALA_IS_CHARACTER_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CHARACTER_LITERAL))
#define VALA_IS_CHARACTER_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CHARACTER_LITERAL))
#define VALA_CHARACTER_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CHARACTER_LITERAL, ValaCharacterLiteralClass))

typedef struct _ValaCharacterLiteral ValaCharacterLiteral;
typedef struct _ValaCharacterLiteralClass ValaCharacterLiteralClass;

#define VALA_TYPE_INTEGER_LITERAL (vala_integer_literal_get_type ())
#define VALA_INTEGER_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteral))
#define VALA_INTEGER_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteralClass))
#define VALA_IS_INTEGER_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTEGER_LITERAL))
#define VALA_IS_INTEGER_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTEGER_LITERAL))
#define VALA_INTEGER_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteralClass))

typedef struct _ValaIntegerLiteral ValaIntegerLiteral;
typedef struct _ValaIntegerLiteralClass ValaIntegerLiteralClass;

#define VALA_TYPE_REAL_LITERAL (vala_real_literal_get_type ())
#define VALA_REAL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REAL_LITERAL, ValaRealLiteral))
#define VALA_REAL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REAL_LITERAL, ValaRealLiteralClass))
#define VALA_IS_REAL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REAL_LITERAL))
#define VALA_IS_REAL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REAL_LITERAL))
#define VALA_REAL_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REAL_LITERAL, ValaRealLiteralClass))

typedef struct _ValaRealLiteral ValaRealLiteral;
typedef struct _ValaRealLiteralClass ValaRealLiteralClass;

#define VALA_TYPE_STRING_LITERAL (vala_string_literal_get_type ())
#define VALA_STRING_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRING_LITERAL, ValaStringLiteral))
#define VALA_STRING_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRING_LITERAL, ValaStringLiteralClass))
#define VALA_IS_STRING_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRING_LITERAL))
#define VALA_IS_STRING_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRING_LITERAL))
#define VALA_STRING_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRING_LITERAL, ValaStringLiteralClass))

typedef struct _ValaStringLiteral ValaStringLiteral;
typedef struct _ValaStringLiteralClass ValaStringLiteralClass;

#define VALA_TYPE_NULL_LITERAL (vala_null_literal_get_type ())
#define VALA_NULL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NULL_LITERAL, ValaNullLiteral))
#define VALA_NULL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NULL_LITERAL, ValaNullLiteralClass))
#define VALA_IS_NULL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NULL_LITERAL))
#define VALA_IS_NULL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NULL_LITERAL))
#define VALA_NULL_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NULL_LITERAL, ValaNullLiteralClass))

typedef struct _ValaNullLiteral ValaNullLiteral;
typedef struct _ValaNullLiteralClass ValaNullLiteralClass;

#define VALA_TYPE_MEMBER_ACCESS (vala_member_access_get_type ())
#define VALA_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess))
#define VALA_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))
#define VALA_IS_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER_ACCESS))
#define VALA_IS_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER_ACCESS))
#define VALA_MEMBER_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))

typedef struct _ValaMemberAccess ValaMemberAccess;
typedef struct _ValaMemberAccessClass ValaMemberAccessClass;

#define VALA_TYPE_METHOD_CALL (vala_method_call_get_type ())
#define VALA_METHOD_CALL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD_CALL, ValaMethodCall))
#define VALA_METHOD_CALL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD_CALL, ValaMethodCallClass))
#define VALA_IS_METHOD_CALL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD_CALL))
#define VALA_IS_METHOD_CALL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD_CALL))
#define VALA_METHOD_CALL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD_CALL, ValaMethodCallClass))

typedef struct _ValaMethodCall ValaMethodCall;
typedef struct _ValaMethodCallClass ValaMethodCallClass;

#define VALA_TYPE_ELEMENT_ACCESS (vala_element_access_get_type ())
#define VALA_ELEMENT_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess))
#define VALA_ELEMENT_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ELEMENT_ACCESS, ValaElementAccessClass))
#define VALA_IS_ELEMENT_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ELEMENT_ACCESS))
#define VALA_IS_ELEMENT_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ELEMENT_ACCESS))
#define VALA_ELEMENT_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ELEMENT_ACCESS, ValaElementAccessClass))

typedef struct _ValaElementAccess ValaElementAccess;
typedef struct _ValaElementAccessClass ValaElementAccessClass;

#define VALA_TYPE_BASE_ACCESS (vala_base_access_get_type ())
#define VALA_BASE_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BASE_ACCESS, ValaBaseAccess))
#define VALA_BASE_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BASE_ACCESS, ValaBaseAccessClass))
#define VALA_IS_BASE_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BASE_ACCESS))
#define VALA_IS_BASE_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BASE_ACCESS))
#define VALA_BASE_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BASE_ACCESS, ValaBaseAccessClass))

typedef struct _ValaBaseAccess ValaBaseAccess;
typedef struct _ValaBaseAccessClass ValaBaseAccessClass;

#define VALA_TYPE_POSTFIX_EXPRESSION (vala_postfix_expression_get_type ())
#define VALA_POSTFIX_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_POSTFIX_EXPRESSION, ValaPostfixExpression))
#define VALA_POSTFIX_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_POSTFIX_EXPRESSION, ValaPostfixExpressionClass))
#define VALA_IS_POSTFIX_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_POSTFIX_EXPRESSION))
#define VALA_IS_POSTFIX_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_POSTFIX_EXPRESSION))
#define VALA_POSTFIX_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_POSTFIX_EXPRESSION, ValaPostfixExpressionClass))

typedef struct _ValaPostfixExpression ValaPostfixExpression;
typedef struct _ValaPostfixExpressionClass ValaPostfixExpressionClass;

#define VALA_TYPE_OBJECT_CREATION_EXPRESSION (vala_object_creation_expression_get_type ())
#define VALA_OBJECT_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpression))
#define VALA_OBJECT_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpressionClass))
#define VALA_IS_OBJECT_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_CREATION_EXPRESSION))
#define VALA_IS_OBJECT_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_CREATION_EXPRESSION))
#define VALA_OBJECT_CREATION_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpressionClass))

typedef struct _ValaObjectCreationExpression ValaObjectCreationExpression;
typedef struct _ValaObjectCreationExpressionClass ValaObjectCreationExpressionClass;

#define VALA_TYPE_SIZEOF_EXPRESSION (vala_sizeof_expression_get_type ())
#define VALA_SIZEOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIZEOF_EXPRESSION, ValaSizeofExpression))
#define VALA_SIZEOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIZEOF_EXPRESSION, ValaSizeofExpressionClass))
#define VALA_IS_SIZEOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIZEOF_EXPRESSION))
#define VALA_IS_SIZEOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIZEOF_EXPRESSION))
#define VALA_SIZEOF_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIZEOF_EXPRESSION, ValaSizeofExpressionClass))

typedef struct _ValaSizeofExpression ValaSizeofExpression;
typedef struct _ValaSizeofExpressionClass ValaSizeofExpressionClass;

#define VALA_TYPE_TYPEOF_EXPRESSION (vala_typeof_expression_get_type ())
#define VALA_TYPEOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEOF_EXPRESSION, ValaTypeofExpression))
#define VALA_TYPEOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEOF_EXPRESSION, ValaTypeofExpressionClass))
#define VALA_IS_TYPEOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEOF_EXPRESSION))
#define VALA_IS_TYPEOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEOF_EXPRESSION))
#define VALA_TYPEOF_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEOF_EXPRESSION, ValaTypeofExpressionClass))

typedef struct _ValaTypeofExpression ValaTypeofExpression;
typedef struct _ValaTypeofExpressionClass ValaTypeofExpressionClass;

#define VALA_TYPE_UNARY_EXPRESSION (vala_unary_expression_get_type ())
#define VALA_UNARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression))
#define VALA_UNARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpressionClass))
#define VALA_IS_UNARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_UNARY_EXPRESSION))
#define VALA_IS_UNARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_UNARY_EXPRESSION))
#define VALA_UNARY_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpressionClass))

typedef struct _ValaUnaryExpression ValaUnaryExpression;
typedef struct _ValaUnaryExpressionClass ValaUnaryExpressionClass;

#define VALA_TYPE_CAST_EXPRESSION (vala_cast_expression_get_type ())
#define VALA_CAST_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CAST_EXPRESSION, ValaCastExpression))
#define VALA_CAST_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CAST_EXPRESSION, ValaCastExpressionClass))
#define VALA_IS_CAST_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CAST_EXPRESSION))
#define VALA_IS_CAST_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CAST_EXPRESSION))
#define VALA_CAST_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CAST_EXPRESSION, ValaCastExpressionClass))

typedef struct _ValaCastExpression ValaCastExpression;
typedef struct _ValaCastExpressionClass ValaCastExpressionClass;

#define VALA_TYPE_POINTER_INDIRECTION (vala_pointer_indirection_get_type ())
#define VALA_POINTER_INDIRECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection))
#define VALA_POINTER_INDIRECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirectionClass))
#define VALA_IS_POINTER_INDIRECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_POINTER_INDIRECTION))
#define VALA_IS_POINTER_INDIRECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_POINTER_INDIRECTION))
#define VALA_POINTER_INDIRECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirectionClass))

typedef struct _ValaPointerIndirection ValaPointerIndirection;
typedef struct _ValaPointerIndirectionClass ValaPointerIndirectionClass;

#define VALA_TYPE_ADDRESSOF_EXPRESSION (vala_addressof_expression_get_type ())
#define VALA_ADDRESSOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ADDRESSOF_EXPRESSION, ValaAddressofExpression))
#define VALA_ADDRESSOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ADDRESSOF_EXPRESSION, ValaAddressofExpressionClass))
#define VALA_IS_ADDRESSOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ADDRESSOF_EXPRESSION))
#define VALA_IS_ADDRESSOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ADDRESSOF_EXPRESSION))
#define VALA_ADDRESSOF_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ADDRESSOF_EXPRESSION, ValaAddressofExpressionClass))

typedef struct _ValaAddressofExpression ValaAddressofExpression;
typedef struct _ValaAddressofExpressionClass ValaAddressofExpressionClass;

#define VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION (vala_reference_transfer_expression_get_type ())
#define VALA_REFERENCE_TRANSFER_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION, ValaReferenceTransferExpression))
#define VALA_REFERENCE_TRANSFER_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION, ValaReferenceTransferExpressionClass))
#define VALA_IS_REFERENCE_TRANSFER_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION))
#define VALA_IS_REFERENCE_TRANSFER_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION))
#define VALA_REFERENCE_TRANSFER_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION, ValaReferenceTransferExpressionClass))

typedef struct _ValaReferenceTransferExpression ValaReferenceTransferExpression;
typedef struct _ValaReferenceTransferExpressionClass ValaReferenceTransferExpressionClass;

#define VALA_TYPE_BINARY_EXPRESSION (vala_binary_expression_get_type ())
#define VALA_BINARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpression))
#define VALA_BINARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpressionClass))
#define VALA_IS_BINARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BINARY_EXPRESSION))
#define VALA_IS_BINARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BINARY_EXPRESSION))
#define VALA_BINARY_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpressionClass))

typedef struct _ValaBinaryExpression ValaBinaryExpression;
typedef struct _ValaBinaryExpressionClass ValaBinaryExpressionClass;

#define VALA_TYPE_TYPECHECK (vala_typecheck_get_type ())
#define VALA_TYPECHECK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPECHECK, ValaTypeCheck))
#define VALA_TYPECHECK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPECHECK, ValaTypeCheckClass))
#define VALA_IS_TYPECHECK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPECHECK))
#define VALA_IS_TYPECHECK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPECHECK))
#define VALA_TYPECHECK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPECHECK, ValaTypeCheckClass))

typedef struct _ValaTypeCheck ValaTypeCheck;
typedef struct _ValaTypeCheckClass ValaTypeCheckClass;

#define VALA_TYPE_CONDITIONAL_EXPRESSION (vala_conditional_expression_get_type ())
#define VALA_CONDITIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONDITIONAL_EXPRESSION, ValaConditionalExpression))
#define VALA_CONDITIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONDITIONAL_EXPRESSION, ValaConditionalExpressionClass))
#define VALA_IS_CONDITIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONDITIONAL_EXPRESSION))
#define VALA_IS_CONDITIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONDITIONAL_EXPRESSION))
#define VALA_CONDITIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONDITIONAL_EXPRESSION, ValaConditionalExpressionClass))

typedef struct _ValaConditionalExpression ValaConditionalExpression;
typedef struct _ValaConditionalExpressionClass ValaConditionalExpressionClass;

#define VALA_TYPE_LAMBDA_EXPRESSION (vala_lambda_expression_get_type ())
#define VALA_LAMBDA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpression))
#define VALA_LAMBDA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpressionClass))
#define VALA_IS_LAMBDA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LAMBDA_EXPRESSION))
#define VALA_IS_LAMBDA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LAMBDA_EXPRESSION))
#define VALA_LAMBDA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpressionClass))

typedef struct _ValaLambdaExpression ValaLambdaExpression;
typedef struct _ValaLambdaExpressionClass ValaLambdaExpressionClass;

#define VALA_TYPE_ASSIGNMENT (vala_assignment_get_type ())
#define VALA_ASSIGNMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ASSIGNMENT, ValaAssignment))
#define VALA_ASSIGNMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ASSIGNMENT, ValaAssignmentClass))
#define VALA_IS_ASSIGNMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ASSIGNMENT))
#define VALA_IS_ASSIGNMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ASSIGNMENT))
#define VALA_ASSIGNMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ASSIGNMENT, ValaAssignmentClass))

typedef struct _ValaAssignment ValaAssignment;
typedef struct _ValaAssignmentClass ValaAssignmentClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;
typedef struct _ValaSemanticAnalyzerPrivate ValaSemanticAnalyzerPrivate;

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;

#define VALA_TYPE_SCOPE (vala_scope_get_type ())
#define VALA_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCOPE, ValaScope))
#define VALA_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCOPE, ValaScopeClass))
#define VALA_IS_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCOPE))
#define VALA_IS_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCOPE))
#define VALA_SCOPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCOPE, ValaScopeClass))

typedef struct _ValaScope ValaScope;
typedef struct _ValaScopeClass ValaScopeClass;

#define VALA_TYPE_VALUE_TYPE (vala_value_type_get_type ())
#define VALA_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VALUE_TYPE, ValaValueType))
#define VALA_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VALUE_TYPE, ValaValueTypeClass))
#define VALA_IS_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VALUE_TYPE))
#define VALA_IS_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VALUE_TYPE))
#define VALA_VALUE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VALUE_TYPE, ValaValueTypeClass))

typedef struct _ValaValueType ValaValueType;
typedef struct _ValaValueTypeClass ValaValueTypeClass;

#define VALA_TYPE_BOOLEAN_TYPE (vala_boolean_type_get_type ())
#define VALA_BOOLEAN_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BOOLEAN_TYPE, ValaBooleanType))
#define VALA_BOOLEAN_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BOOLEAN_TYPE, ValaBooleanTypeClass))
#define VALA_IS_BOOLEAN_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BOOLEAN_TYPE))
#define VALA_IS_BOOLEAN_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BOOLEAN_TYPE))
#define VALA_BOOLEAN_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BOOLEAN_TYPE, ValaBooleanTypeClass))

typedef struct _ValaBooleanType ValaBooleanType;
typedef struct _ValaBooleanTypeClass ValaBooleanTypeClass;

#define VALA_TYPE_REFERENCE_TYPE (vala_reference_type_get_type ())
#define VALA_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceType))
#define VALA_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))
#define VALA_IS_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REFERENCE_TYPE))
#define VALA_IS_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REFERENCE_TYPE))
#define VALA_REFERENCE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))

typedef struct _ValaReferenceType ValaReferenceType;
typedef struct _ValaReferenceTypeClass ValaReferenceTypeClass;

#define VALA_TYPE_OBJECT_TYPE (vala_object_type_get_type ())
#define VALA_OBJECT_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE, ValaObjectType))
#define VALA_OBJECT_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE, ValaObjectTypeClass))
#define VALA_IS_OBJECT_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE))
#define VALA_IS_OBJECT_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE))
#define VALA_OBJECT_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE, ValaObjectTypeClass))

typedef struct _ValaObjectType ValaObjectType;
typedef struct _ValaObjectTypeClass ValaObjectTypeClass;

#define VALA_TYPE_INTEGER_TYPE (vala_integer_type_get_type ())
#define VALA_INTEGER_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTEGER_TYPE, ValaIntegerType))
#define VALA_INTEGER_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTEGER_TYPE, ValaIntegerTypeClass))
#define VALA_IS_INTEGER_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTEGER_TYPE))
#define VALA_IS_INTEGER_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTEGER_TYPE))
#define VALA_INTEGER_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTEGER_TYPE, ValaIntegerTypeClass))

typedef struct _ValaIntegerType ValaIntegerType;
typedef struct _ValaIntegerTypeClass ValaIntegerTypeClass;

#define VALA_TYPE_FLOATING_TYPE (vala_floating_type_get_type ())
#define VALA_FLOATING_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FLOATING_TYPE, ValaFloatingType))
#define VALA_FLOATING_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FLOATING_TYPE, ValaFloatingTypeClass))
#define VALA_IS_FLOATING_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FLOATING_TYPE))
#define VALA_IS_FLOATING_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FLOATING_TYPE))
#define VALA_FLOATING_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FLOATING_TYPE, ValaFloatingTypeClass))

typedef struct _ValaFloatingType ValaFloatingType;
typedef struct _ValaFloatingTypeClass ValaFloatingTypeClass;

#define VALA_TYPE_ENUM_VALUE_TYPE (vala_enum_value_type_get_type ())
#define VALA_ENUM_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueType))
#define VALA_ENUM_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueTypeClass))
#define VALA_IS_ENUM_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM_VALUE_TYPE))
#define VALA_IS_ENUM_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM_VALUE_TYPE))
#define VALA_ENUM_VALUE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueTypeClass))

typedef struct _ValaEnumValueType ValaEnumValueType;
typedef struct _ValaEnumValueTypeClass ValaEnumValueTypeClass;

#define VALA_TYPE_METHOD_TYPE (vala_method_type_get_type ())
#define VALA_METHOD_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD_TYPE, ValaMethodType))
#define VALA_METHOD_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD_TYPE, ValaMethodTypeClass))
#define VALA_IS_METHOD_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD_TYPE))
#define VALA_IS_METHOD_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD_TYPE))
#define VALA_METHOD_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD_TYPE, ValaMethodTypeClass))

typedef struct _ValaMethodType ValaMethodType;
typedef struct _ValaMethodTypeClass ValaMethodTypeClass;

#define VALA_TYPE_SIGNAL_TYPE (vala_signal_type_get_type ())
#define VALA_SIGNAL_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIGNAL_TYPE, ValaSignalType))
#define VALA_SIGNAL_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIGNAL_TYPE, ValaSignalTypeClass))
#define VALA_IS_SIGNAL_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIGNAL_TYPE))
#define VALA_IS_SIGNAL_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIGNAL_TYPE))
#define VALA_SIGNAL_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIGNAL_TYPE, ValaSignalTypeClass))

typedef struct _ValaSignalType ValaSignalType;
typedef struct _ValaSignalTypeClass ValaSignalTypeClass;

#define VALA_TYPE_STRUCT_VALUE_TYPE (vala_struct_value_type_get_type ())
#define VALA_STRUCT_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType))
#define VALA_STRUCT_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueTypeClass))
#define VALA_IS_STRUCT_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT_VALUE_TYPE))
#define VALA_IS_STRUCT_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT_VALUE_TYPE))
#define VALA_STRUCT_VALUE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueTypeClass))

typedef struct _ValaStructValueType ValaStructValueType;
typedef struct _ValaStructValueTypeClass ValaStructValueTypeClass;

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_ERROR_TYPE (vala_error_type_get_type ())
#define VALA_ERROR_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_TYPE, ValaErrorType))
#define VALA_ERROR_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_TYPE, ValaErrorTypeClass))
#define VALA_IS_ERROR_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_TYPE))
#define VALA_IS_ERROR_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_TYPE))
#define VALA_ERROR_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_TYPE, ValaErrorTypeClass))

typedef struct _ValaErrorType ValaErrorType;
typedef struct _ValaErrorTypeClass ValaErrorTypeClass;

#define VALA_TYPE_INVALID_TYPE (vala_invalid_type_get_type ())
#define VALA_INVALID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INVALID_TYPE, ValaInvalidType))
#define VALA_INVALID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INVALID_TYPE, ValaInvalidTypeClass))
#define VALA_IS_INVALID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INVALID_TYPE))
#define VALA_IS_INVALID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INVALID_TYPE))
#define VALA_INVALID_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INVALID_TYPE, ValaInvalidTypeClass))

typedef struct _ValaInvalidType ValaInvalidType;
typedef struct _ValaInvalidTypeClass ValaInvalidTypeClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;

#define VALA_TYPE_PARAMETER_DIRECTION (vala_parameter_direction_get_type ())

#define VALA_TYPE_DELEGATE_TYPE (vala_delegate_type_get_type ())
#define VALA_DELEGATE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE_TYPE, ValaDelegateType))
#define VALA_DELEGATE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE_TYPE, ValaDelegateTypeClass))
#define VALA_IS_DELEGATE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE_TYPE))
#define VALA_IS_DELEGATE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE_TYPE))
#define VALA_DELEGATE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE_TYPE, ValaDelegateTypeClass))

typedef struct _ValaDelegateType ValaDelegateType;
typedef struct _ValaDelegateTypeClass ValaDelegateTypeClass;

#define VALA_TYPE_NULL_TYPE (vala_null_type_get_type ())
#define VALA_NULL_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NULL_TYPE, ValaNullType))
#define VALA_NULL_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NULL_TYPE, ValaNullTypeClass))
#define VALA_IS_NULL_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NULL_TYPE))
#define VALA_IS_NULL_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NULL_TYPE))
#define VALA_NULL_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NULL_TYPE, ValaNullTypeClass))

typedef struct _ValaNullType ValaNullType;
typedef struct _ValaNullTypeClass ValaNullTypeClass;

#define VALA_TYPE_UNARY_OPERATOR (vala_unary_operator_get_type ())

#define VALA_TYPE_POINTER_TYPE (vala_pointer_type_get_type ())
#define VALA_POINTER_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_POINTER_TYPE, ValaPointerType))
#define VALA_POINTER_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_POINTER_TYPE, ValaPointerTypeClass))
#define VALA_IS_POINTER_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_POINTER_TYPE))
#define VALA_IS_POINTER_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_POINTER_TYPE))
#define VALA_POINTER_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_POINTER_TYPE, ValaPointerTypeClass))

typedef struct _ValaPointerType ValaPointerType;
typedef struct _ValaPointerTypeClass ValaPointerTypeClass;

#define VALA_TYPE_GENERIC_TYPE (vala_generic_type_get_type ())
#define VALA_GENERIC_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GENERIC_TYPE, ValaGenericType))
#define VALA_GENERIC_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GENERIC_TYPE, ValaGenericTypeClass))
#define VALA_IS_GENERIC_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GENERIC_TYPE))
#define VALA_IS_GENERIC_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GENERIC_TYPE))
#define VALA_GENERIC_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GENERIC_TYPE, ValaGenericTypeClass))

typedef struct _ValaGenericType ValaGenericType;
typedef struct _ValaGenericTypeClass ValaGenericTypeClass;

#define TYPE_MEMBER_BINDING (member_binding_get_type ())

#define VALA_TYPE_MEMBER_INITIALIZER (vala_member_initializer_get_type ())
#define VALA_MEMBER_INITIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER_INITIALIZER, ValaMemberInitializer))
#define VALA_MEMBER_INITIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER_INITIALIZER, ValaMemberInitializerClass))
#define VALA_IS_MEMBER_INITIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER_INITIALIZER))
#define VALA_IS_MEMBER_INITIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER_INITIALIZER))
#define VALA_MEMBER_INITIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER_INITIALIZER, ValaMemberInitializerClass))

typedef struct _ValaMemberInitializer ValaMemberInitializer;
typedef struct _ValaMemberInitializerClass ValaMemberInitializerClass;

#define VALA_TYPE_SYMBOL_ACCESSIBILITY (vala_symbol_accessibility_get_type ())

/**
 * Abstract code node visitor for traversing source code tree.
 */
struct _ValaCodeVisitor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeVisitorPrivate * priv;
};

struct _ValaCodeVisitorClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeVisitor *self);
	void (*visit_source_file) (ValaCodeVisitor* self, ValaSourceFile* source_file);
	void (*visit_namespace) (ValaCodeVisitor* self, ValaNamespace* ns);
	void (*visit_class) (ValaCodeVisitor* self, ValaClass* cl);
	void (*visit_struct) (ValaCodeVisitor* self, ValaStruct* st);
	void (*visit_interface) (ValaCodeVisitor* self, ValaInterface* iface);
	void (*visit_enum) (ValaCodeVisitor* self, ValaEnum* en);
	void (*visit_enum_value) (ValaCodeVisitor* self, ValaEnumValue* ev);
	void (*visit_error_domain) (ValaCodeVisitor* self, ValaErrorDomain* edomain);
	void (*visit_error_code) (ValaCodeVisitor* self, ValaErrorCode* ecode);
	void (*visit_delegate) (ValaCodeVisitor* self, ValaDelegate* d);
	void (*visit_member) (ValaCodeVisitor* self, ValaMember* m);
	void (*visit_constant) (ValaCodeVisitor* self, ValaConstant* c);
	void (*visit_field) (ValaCodeVisitor* self, ValaField* f);
	void (*visit_method) (ValaCodeVisitor* self, ValaMethod* m);
	void (*visit_creation_method) (ValaCodeVisitor* self, ValaCreationMethod* m);
	void (*visit_formal_parameter) (ValaCodeVisitor* self, ValaFormalParameter* p);
	void (*visit_property) (ValaCodeVisitor* self, ValaProperty* prop);
	void (*visit_property_accessor) (ValaCodeVisitor* self, ValaPropertyAccessor* acc);
	void (*visit_signal) (ValaCodeVisitor* self, ValaSignal* sig);
	void (*visit_constructor) (ValaCodeVisitor* self, ValaConstructor* c);
	void (*visit_destructor) (ValaCodeVisitor* self, ValaDestructor* d);
	void (*visit_type_parameter) (ValaCodeVisitor* self, ValaTypeParameter* p);
	void (*visit_using_directive) (ValaCodeVisitor* self, ValaUsingDirective* ns);
	void (*visit_data_type) (ValaCodeVisitor* self, ValaDataType* type);
	void (*visit_block) (ValaCodeVisitor* self, ValaBlock* b);
	void (*visit_empty_statement) (ValaCodeVisitor* self, ValaEmptyStatement* stmt);
	void (*visit_declaration_statement) (ValaCodeVisitor* self, ValaDeclarationStatement* stmt);
	void (*visit_local_variable) (ValaCodeVisitor* self, ValaLocalVariable* local);
	void (*visit_initializer_list) (ValaCodeVisitor* self, ValaInitializerList* list);
	void (*visit_expression_statement) (ValaCodeVisitor* self, ValaExpressionStatement* stmt);
	void (*visit_if_statement) (ValaCodeVisitor* self, ValaIfStatement* stmt);
	void (*visit_switch_statement) (ValaCodeVisitor* self, ValaSwitchStatement* stmt);
	void (*visit_switch_section) (ValaCodeVisitor* self, ValaSwitchSection* section);
	void (*visit_switch_label) (ValaCodeVisitor* self, ValaSwitchLabel* label);
	void (*visit_while_statement) (ValaCodeVisitor* self, ValaWhileStatement* stmt);
	void (*visit_do_statement) (ValaCodeVisitor* self, ValaDoStatement* stmt);
	void (*visit_for_statement) (ValaCodeVisitor* self, ValaForStatement* stmt);
	void (*visit_foreach_statement) (ValaCodeVisitor* self, ValaForeachStatement* stmt);
	void (*visit_break_statement) (ValaCodeVisitor* self, ValaBreakStatement* stmt);
	void (*visit_continue_statement) (ValaCodeVisitor* self, ValaContinueStatement* stmt);
	void (*visit_return_statement) (ValaCodeVisitor* self, ValaReturnStatement* stmt);
	void (*visit_yield_statement) (ValaCodeVisitor* self, ValaYieldStatement* y);
	void (*visit_throw_statement) (ValaCodeVisitor* self, ValaThrowStatement* stmt);
	void (*visit_try_statement) (ValaCodeVisitor* self, ValaTryStatement* stmt);
	void (*visit_catch_clause) (ValaCodeVisitor* self, ValaCatchClause* clause);
	void (*visit_lock_statement) (ValaCodeVisitor* self, ValaLockStatement* stmt);
	void (*visit_delete_statement) (ValaCodeVisitor* self, ValaDeleteStatement* stmt);
	void (*visit_expression) (ValaCodeVisitor* self, ValaExpression* expr);
	void (*visit_array_creation_expression) (ValaCodeVisitor* self, ValaArrayCreationExpression* expr);
	void (*visit_boolean_literal) (ValaCodeVisitor* self, ValaBooleanLiteral* lit);
	void (*visit_character_literal) (ValaCodeVisitor* self, ValaCharacterLiteral* lit);
	void (*visit_integer_literal) (ValaCodeVisitor* self, ValaIntegerLiteral* lit);
	void (*visit_real_literal) (ValaCodeVisitor* self, ValaRealLiteral* lit);
	void (*visit_string_literal) (ValaCodeVisitor* self, ValaStringLiteral* lit);
	void (*visit_null_literal) (ValaCodeVisitor* self, ValaNullLiteral* lit);
	void (*visit_member_access) (ValaCodeVisitor* self, ValaMemberAccess* expr);
	void (*visit_method_call) (ValaCodeVisitor* self, ValaMethodCall* expr);
	void (*visit_element_access) (ValaCodeVisitor* self, ValaElementAccess* expr);
	void (*visit_base_access) (ValaCodeVisitor* self, ValaBaseAccess* expr);
	void (*visit_postfix_expression) (ValaCodeVisitor* self, ValaPostfixExpression* expr);
	void (*visit_object_creation_expression) (ValaCodeVisitor* self, ValaObjectCreationExpression* expr);
	void (*visit_sizeof_expression) (ValaCodeVisitor* self, ValaSizeofExpression* expr);
	void (*visit_typeof_expression) (ValaCodeVisitor* self, ValaTypeofExpression* expr);
	void (*visit_unary_expression) (ValaCodeVisitor* self, ValaUnaryExpression* expr);
	void (*visit_cast_expression) (ValaCodeVisitor* self, ValaCastExpression* expr);
	void (*visit_pointer_indirection) (ValaCodeVisitor* self, ValaPointerIndirection* expr);
	void (*visit_addressof_expression) (ValaCodeVisitor* self, ValaAddressofExpression* expr);
	void (*visit_reference_transfer_expression) (ValaCodeVisitor* self, ValaReferenceTransferExpression* expr);
	void (*visit_binary_expression) (ValaCodeVisitor* self, ValaBinaryExpression* expr);
	void (*visit_type_check) (ValaCodeVisitor* self, ValaTypeCheck* expr);
	void (*visit_conditional_expression) (ValaCodeVisitor* self, ValaConditionalExpression* expr);
	void (*visit_lambda_expression) (ValaCodeVisitor* self, ValaLambdaExpression* expr);
	void (*visit_assignment) (ValaCodeVisitor* self, ValaAssignment* a);
	void (*visit_end_full_expression) (ValaCodeVisitor* self, ValaExpression* expr);
};

/**
 * Code visitor analyzing and checking code.
 */
struct _ValaSemanticAnalyzer {
	ValaCodeVisitor parent_instance;
	ValaSemanticAnalyzerPrivate * priv;
	ValaSymbol* root_symbol;
	ValaDataType* current_return_type;
	ValaClass* current_class;
	ValaStruct* current_struct;
	ValaBlock* insert_block;
	ValaDataType* bool_type;
	ValaDataType* string_type;
	ValaDataType* uchar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* size_t_type;
	ValaDataType* ssize_t_type;
	ValaDataType* uint64_type;
	ValaDataType* int8_type;
	ValaDataType* unichar_type;
	ValaDataType* double_type;
	ValaDataType* type_type;
	ValaClass* object_type;
	ValaDataType* glist_type;
	ValaDataType* gslist_type;
	ValaDataType* garray_type;
	ValaClass* gerror_type;
	gint next_lambda_id;
	GeeList* replaced_nodes;
};

struct _ValaSemanticAnalyzerClass {
	ValaCodeVisitorClass parent_class;
};

struct _ValaSemanticAnalyzerPrivate {
	ValaCodeContext* _context;
	ValaSymbol* _current_symbol;
	ValaSourceFile* _current_source_file;
};

typedef enum  {
	VALA_PARAMETER_DIRECTION_IN,
	VALA_PARAMETER_DIRECTION_OUT,
	VALA_PARAMETER_DIRECTION_REF
} ValaParameterDirection;

typedef enum  {
	VALA_UNARY_OPERATOR_NONE,
	VALA_UNARY_OPERATOR_PLUS,
	VALA_UNARY_OPERATOR_MINUS,
	VALA_UNARY_OPERATOR_LOGICAL_NEGATION,
	VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT,
	VALA_UNARY_OPERATOR_INCREMENT,
	VALA_UNARY_OPERATOR_DECREMENT,
	VALA_UNARY_OPERATOR_REF,
	VALA_UNARY_OPERATOR_OUT
} ValaUnaryOperator;

typedef enum  {
	MEMBER_BINDING_INSTANCE,
	MEMBER_BINDING_CLASS,
	MEMBER_BINDING_STATIC
} MemberBinding;

typedef enum  {
	VALA_SYMBOL_ACCESSIBILITY_PRIVATE,
	VALA_SYMBOL_ACCESSIBILITY_INTERNAL,
	VALA_SYMBOL_ACCESSIBILITY_PROTECTED,
	VALA_SYMBOL_ACCESSIBILITY_PUBLIC
} ValaSymbolAccessibility;



gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void);
gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void);
GType vala_symbol_get_type (void);
GType vala_namespace_get_type (void);
GType vala_typesymbol_get_type (void);
GType vala_object_type_symbol_get_type (void);
GType vala_class_get_type (void);
GType vala_struct_get_type (void);
GType vala_interface_get_type (void);
GType vala_enum_get_type (void);
GType vala_enum_value_get_type (void);
GType vala_error_domain_get_type (void);
GType vala_error_code_get_type (void);
GType vala_delegate_get_type (void);
GType vala_member_get_type (void);
GType vala_constant_get_type (void);
GType vala_field_get_type (void);
GType vala_method_get_type (void);
GType vala_creation_method_get_type (void);
GType vala_formal_parameter_get_type (void);
GType vala_property_get_type (void);
GType vala_property_accessor_get_type (void);
GType vala_signal_get_type (void);
GType vala_constructor_get_type (void);
GType vala_destructor_get_type (void);
GType vala_typeparameter_get_type (void);
GType vala_using_directive_get_type (void);
GType vala_data_type_get_type (void);
GType vala_block_get_type (void);
GType vala_empty_statement_get_type (void);
GType vala_declaration_statement_get_type (void);
GType vala_local_variable_get_type (void);
GType vala_expression_get_type (void);
GType vala_initializer_list_get_type (void);
GType vala_expression_statement_get_type (void);
GType vala_if_statement_get_type (void);
GType vala_switch_statement_get_type (void);
GType vala_switch_section_get_type (void);
GType vala_switch_label_get_type (void);
GType vala_while_statement_get_type (void);
GType vala_do_statement_get_type (void);
GType vala_for_statement_get_type (void);
GType vala_foreach_statement_get_type (void);
GType vala_break_statement_get_type (void);
GType vala_continue_statement_get_type (void);
GType vala_return_statement_get_type (void);
GType vala_yield_statement_get_type (void);
GType vala_throw_statement_get_type (void);
GType vala_try_statement_get_type (void);
GType vala_catch_clause_get_type (void);
GType vala_lock_statement_get_type (void);
GType vala_delete_statement_get_type (void);
GType vala_array_creation_expression_get_type (void);
GType vala_literal_get_type (void);
GType vala_boolean_literal_get_type (void);
GType vala_character_literal_get_type (void);
GType vala_integer_literal_get_type (void);
GType vala_real_literal_get_type (void);
GType vala_string_literal_get_type (void);
GType vala_null_literal_get_type (void);
GType vala_member_access_get_type (void);
GType vala_method_call_get_type (void);
GType vala_element_access_get_type (void);
GType vala_base_access_get_type (void);
GType vala_postfix_expression_get_type (void);
GType vala_object_creation_expression_get_type (void);
GType vala_sizeof_expression_get_type (void);
GType vala_typeof_expression_get_type (void);
GType vala_unary_expression_get_type (void);
GType vala_cast_expression_get_type (void);
GType vala_pointer_indirection_get_type (void);
GType vala_addressof_expression_get_type (void);
GType vala_reference_transfer_expression_get_type (void);
GType vala_binary_expression_get_type (void);
GType vala_typecheck_get_type (void);
GType vala_conditional_expression_get_type (void);
GType vala_lambda_expression_get_type (void);
GType vala_assignment_get_type (void);
GType vala_semantic_analyzer_get_type (void);
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void);
#define VALA_SEMANTIC_ANALYZER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerPrivate))
enum  {
	VALA_SEMANTIC_ANALYZER_DUMMY_PROPERTY
};
ValaSemanticAnalyzer* vala_semantic_analyzer_new (void);
ValaSemanticAnalyzer* vala_semantic_analyzer_construct (GType object_type);
ValaSemanticAnalyzer* vala_semantic_analyzer_new (void);
void vala_semantic_analyzer_set_context (ValaSemanticAnalyzer* self, ValaCodeContext* value);
ValaNamespace* vala_code_context_get_root (ValaCodeContext* self);
gpointer vala_scope_ref (gpointer instance);
void vala_scope_unref (gpointer instance);
GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scope (GValue* value, gpointer v_object);
gpointer vala_value_get_scope (const GValue* value);
GType vala_scope_get_type (void);
ValaScope* vala_symbol_get_scope (ValaSymbol* self);
ValaSymbol* vala_scope_lookup (ValaScope* self, const char* name);
ValaBooleanType* vala_boolean_type_new (ValaStruct* type_symbol);
ValaBooleanType* vala_boolean_type_construct (GType object_type, ValaStruct* type_symbol);
GType vala_value_type_get_type (void);
GType vala_boolean_type_get_type (void);
ValaObjectType* vala_object_type_new (ValaObjectTypeSymbol* type_symbol);
ValaObjectType* vala_object_type_construct (GType object_type, ValaObjectTypeSymbol* type_symbol);
GType vala_reference_type_get_type (void);
GType vala_object_type_get_type (void);
ValaIntegerType* vala_integer_type_new (ValaStruct* type_symbol, const char* literal_value, const char* literal_type_name);
ValaIntegerType* vala_integer_type_construct (GType object_type, ValaStruct* type_symbol, const char* literal_value, const char* literal_type_name);
GType vala_integer_type_get_type (void);
ValaFloatingType* vala_floating_type_new (ValaStruct* type_symbol);
ValaFloatingType* vala_floating_type_construct (GType object_type, ValaStruct* type_symbol);
GType vala_floating_type_get_type (void);
void vala_semantic_analyzer_set_current_symbol (ValaSemanticAnalyzer* self, ValaSymbol* value);
gboolean vala_code_node_check (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
void vala_code_context_accept (ValaCodeContext* self, ValaCodeVisitor* visitor);
void vala_semantic_analyzer_analyze (ValaSemanticAnalyzer* self, ValaCodeContext* context);
void vala_semantic_analyzer_set_current_source_file (ValaSemanticAnalyzer* self, ValaSourceFile* value);
gboolean vala_source_file_check (ValaSourceFile* self, ValaSemanticAnalyzer* analyzer);
static void vala_semantic_analyzer_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* file);
GeeList* vala_data_type_get_symbols (ValaDataType* self);
ValaScope* vala_symbol_get_top_accessible_scope (ValaSymbol* self, gboolean is_internal);
gboolean vala_scope_is_subscope_of (ValaScope* self, ValaScope* scope);
gboolean vala_semantic_analyzer_is_type_accessible (ValaSemanticAnalyzer* self, ValaSymbol* sym, ValaDataType* type);
ValaDataType* vala_field_get_field_type (ValaField* self);
ValaDataType* vala_data_type_copy (ValaDataType* self);
void vala_data_type_set_value_owned (ValaDataType* self, gboolean value);
ValaDataType* vala_constant_get_type_reference (ValaConstant* self);
ValaPropertyAccessor* vala_property_get_set_accessor (ValaProperty* self);
ValaDataType* vala_property_accessor_get_value_type (ValaPropertyAccessor* self);
ValaPropertyAccessor* vala_property_get_get_accessor (ValaProperty* self);
ValaDataType* vala_formal_parameter_get_parameter_type (ValaFormalParameter* self);
ValaDataType* vala_local_variable_get_variable_type (ValaLocalVariable* self);
gboolean vala_local_variable_get_floating (ValaLocalVariable* self);
ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self);
ValaEnumValueType* vala_enum_value_type_new (ValaEnum* type_symbol);
ValaEnumValueType* vala_enum_value_type_construct (GType object_type, ValaEnum* type_symbol);
GType vala_enum_value_type_get_type (void);
ValaMethodType* vala_method_type_new (ValaMethod* method_symbol);
ValaMethodType* vala_method_type_construct (GType object_type, ValaMethod* method_symbol);
GType vala_method_type_get_type (void);
ValaSignalType* vala_signal_type_new (ValaSignal* signal_symbol);
ValaSignalType* vala_signal_type_construct (GType object_type, ValaSignal* signal_symbol);
GType vala_signal_type_get_type (void);
ValaDataType* vala_semantic_analyzer_get_value_type_for_symbol (ValaSemanticAnalyzer* self, ValaSymbol* sym, gboolean lvalue);
GeeList* vala_class_get_base_types (ValaClass* self);
ValaTypeSymbol* vala_data_type_get_data_type (ValaDataType* self);
ValaClass* vala_class_get_base_class (ValaClass* self);
ValaSymbol* vala_semantic_analyzer_symbol_lookup_inherited (ValaSymbol* sym, const char* name);
ValaDataType* vala_struct_get_base_type (ValaStruct* self);
GeeList* vala_interface_get_prerequisites (ValaInterface* self);
gboolean vala_struct_is_boolean_type (ValaStruct* self);
gboolean vala_struct_is_integer_type (ValaStruct* self);
gboolean vala_struct_is_floating_type (ValaStruct* self);
ValaStructValueType* vala_struct_value_type_new (ValaStruct* type_symbol);
ValaStructValueType* vala_struct_value_type_construct (GType object_type, ValaStruct* type_symbol);
GType vala_struct_value_type_get_type (void);
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void);
ValaErrorType* vala_error_type_new (ValaErrorDomain* error_domain, ValaErrorCode* error_code, ValaSourceReference* source_reference);
ValaErrorType* vala_error_type_construct (GType object_type, ValaErrorDomain* error_domain, ValaErrorCode* error_code, ValaSourceReference* source_reference);
GType vala_error_type_get_type (void);
void vala_report_error (ValaSourceReference* source, const char* message);
char* vala_symbol_get_full_name (ValaSymbol* self);
ValaInvalidType* vala_invalid_type_new (void);
ValaInvalidType* vala_invalid_type_construct (GType object_type);
GType vala_invalid_type_get_type (void);
ValaDataType* vala_semantic_analyzer_get_data_type_for_symbol (ValaTypeSymbol* sym);
ValaMethod* vala_method_type_get_method_symbol (ValaMethodType* self);
GType vala_attribute_get_type (void);
ValaAttribute* vala_code_node_get_attribute (ValaCodeNode* self, const char* name);
gboolean vala_formal_parameter_get_ellipsis (ValaFormalParameter* self);
gboolean vala_formal_parameter_get_params_array (ValaFormalParameter* self);
GType vala_parameter_direction_get_type (void);
static gboolean vala_semantic_analyzer_check_argument (ValaSemanticAnalyzer* self, ValaExpression* arg, gint i, ValaParameterDirection direction);
ValaParameterDirection vala_formal_parameter_get_direction (ValaFormalParameter* self);
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
ValaExpression* vala_formal_parameter_get_default_expression (ValaFormalParameter* self);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
char* vala_code_node_to_string (ValaCodeNode* self);
void vala_method_call_add_argument (ValaMethodCall* self, ValaExpression* arg);
void vala_object_creation_expression_add_argument (ValaObjectCreationExpression* self, ValaExpression* arg);
gboolean vala_code_node_get_error (ValaCodeNode* self);
ValaDataType* vala_expression_get_value_type (ValaExpression* self);
ValaSymbol* vala_expression_get_symbol_reference (ValaExpression* self);
ValaDataType* vala_expression_get_target_type (ValaExpression* self);
gboolean vala_data_type_compatible (ValaDataType* self, ValaDataType* target_type);
ValaSourceFile* vala_source_reference_get_file (ValaSourceReference* self);
const char* vala_source_file_get_filename (ValaSourceFile* self);
gint vala_source_reference_get_first_line (ValaSourceReference* self);
const char* vala_string_literal_get_value (ValaStringLiteral* self);
void vala_string_literal_set_value (ValaStringLiteral* self, const char* value);
gboolean vala_semantic_analyzer_check_arguments (ValaSemanticAnalyzer* self, ValaExpression* expr, ValaDataType* mtype, GeeList* params, GeeList* args);
GType vala_delegate_type_get_type (void);
GType vala_null_type_get_type (void);
GType vala_unary_operator_get_type (void);
ValaUnaryOperator vala_unary_expression_get_operator (ValaUnaryExpression* self);
gboolean vala_data_type_get_nullable (ValaDataType* self);
void vala_report_warning (ValaSourceReference* source, const char* message);
gboolean vala_data_type_is_disposable (ValaDataType* self);
GType vala_pointer_type_get_type (void);
gboolean vala_data_type_get_value_owned (ValaDataType* self);
GeeList* vala_data_type_get_type_arguments (ValaDataType* self);
ValaTypeParameter* vala_data_type_get_type_parameter (ValaDataType* self);
gint vala_typesymbol_get_type_parameter_index (ValaTypeSymbol* self, const char* name);
const char* vala_symbol_get_name (ValaSymbol* self);
void vala_data_type_add_type_argument (ValaDataType* self, ValaDataType* arg);
static ValaDataType* vala_semantic_analyzer_get_instance_base_type (ValaDataType* instance_type, ValaDataType* base_type, ValaCodeNode* node_reference);
ValaDataType* vala_pointer_type_get_base_type (ValaPointerType* self);
static ValaDataType* vala_semantic_analyzer_get_instance_base_type_for_member (ValaDataType* derived_instance_type, ValaTypeSymbol* type_symbol, ValaCodeNode* node_reference);
GType vala_generic_type_get_type (void);
ValaDataType* vala_semantic_analyzer_get_actual_type (ValaDataType* derived_instance_type, ValaGenericType* generic_type, ValaCodeNode* node_reference);
ValaSymbol* vala_semantic_analyzer_get_current_symbol (ValaSemanticAnalyzer* self);
GType member_binding_get_type (void);
MemberBinding vala_method_get_binding (ValaMethod* self);
MemberBinding vala_constructor_get_binding (ValaConstructor* self);
gboolean vala_semantic_analyzer_is_in_instance_method (ValaSemanticAnalyzer* self);
GType vala_member_initializer_get_type (void);
const char* vala_member_initializer_get_name (ValaMemberInitializer* self);
void vala_member_initializer_set_symbol_reference (ValaMemberInitializer* self, ValaSymbol* value);
ValaSymbol* vala_member_initializer_get_symbol_reference (ValaMemberInitializer* self);
GType vala_symbol_accessibility_get_type (void);
ValaSymbolAccessibility vala_symbol_get_access (ValaSymbol* self);
ValaDataType* vala_property_get_property_type (ValaProperty* self);
gboolean vala_property_accessor_get_writable (ValaPropertyAccessor* self);
void vala_expression_set_target_type (ValaExpression* self, ValaDataType* value);
ValaExpression* vala_member_initializer_get_initializer (ValaMemberInitializer* self);
void vala_semantic_analyzer_visit_member_initializer (ValaSemanticAnalyzer* self, ValaMemberInitializer* init, ValaDataType* type);
gint vala_struct_get_rank (ValaStruct* self);
ValaDataType* vala_semantic_analyzer_get_arithmetic_result_type (ValaSemanticAnalyzer* self, ValaDataType* left_type, ValaDataType* right_type);
ValaMethod* vala_semantic_analyzer_find_current_method (ValaSemanticAnalyzer* self);
gboolean vala_semantic_analyzer_is_in_constructor (ValaSemanticAnalyzer* self);
ValaCodeContext* vala_semantic_analyzer_get_context (ValaSemanticAnalyzer* self);
ValaSourceFile* vala_semantic_analyzer_get_current_source_file (ValaSemanticAnalyzer* self);
static gpointer vala_semantic_analyzer_parent_class = NULL;
static void vala_semantic_analyzer_finalize (ValaCodeVisitor* obj);



ValaSemanticAnalyzer* vala_semantic_analyzer_construct (GType object_type) {
	ValaSemanticAnalyzer* self;
	self = (ValaSemanticAnalyzer*) g_type_create_instance (object_type);
	return self;
}


ValaSemanticAnalyzer* vala_semantic_analyzer_new (void) {
	return vala_semantic_analyzer_construct (VALA_TYPE_SEMANTIC_ANALYZER);
}


/**
 * Analyze and check code in the specified context.
 *
 * @param context a code context
 */
void vala_semantic_analyzer_analyze (ValaSemanticAnalyzer* self, ValaCodeContext* context) {
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp0_;
	ValaDataType* _tmp3_;
	ValaStruct* _tmp2_;
	ValaDataType* _tmp5_;
	ValaClass* _tmp4_;
	ValaDataType* _tmp7_;
	ValaStruct* _tmp6_;
	ValaDataType* _tmp9_;
	ValaStruct* _tmp8_;
	ValaDataType* _tmp11_;
	ValaStruct* _tmp10_;
	ValaDataType* _tmp13_;
	ValaStruct* _tmp12_;
	ValaDataType* _tmp15_;
	ValaStruct* _tmp14_;
	ValaDataType* _tmp17_;
	ValaStruct* _tmp16_;
	ValaDataType* _tmp19_;
	ValaStruct* _tmp18_;
	ValaDataType* _tmp21_;
	ValaStruct* _tmp20_;
	ValaDataType* _tmp23_;
	ValaStruct* _tmp22_;
	ValaDataType* _tmp25_;
	ValaStruct* _tmp24_;
	ValaDataType* _tmp27_;
	ValaStruct* _tmp26_;
	ValaDataType* _tmp29_;
	ValaStruct* _tmp28_;
	ValaDataType* _tmp31_;
	ValaStruct* _tmp30_;
	ValaSymbol* glib_ns;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	vala_semantic_analyzer_set_context (self, context);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->root_symbol = (_tmp1_ = (_tmp0_ = (ValaSymbol*) vala_code_context_get_root (context), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_)), (self->root_symbol == NULL) ? NULL : (self->root_symbol = (vala_code_node_unref (self->root_symbol), NULL)), _tmp1_);
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	self->bool_type = (_tmp3_ = (ValaDataType*) vala_boolean_type_new (_tmp2_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "bool"))), (self->bool_type == NULL) ? NULL : (self->bool_type = (vala_code_node_unref (self->bool_type), NULL)), _tmp3_);
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_code_node_unref (_tmp2_), NULL));
	_tmp5_ = NULL;
	_tmp4_ = NULL;
	self->string_type = (_tmp5_ = (ValaDataType*) vala_object_type_new ((ValaObjectTypeSymbol*) (_tmp4_ = VALA_CLASS (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "string")))), (self->string_type == NULL) ? NULL : (self->string_type = (vala_code_node_unref (self->string_type), NULL)), _tmp5_);
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_code_node_unref (_tmp4_), NULL));
	_tmp7_ = NULL;
	_tmp6_ = NULL;
	self->uchar_type = (_tmp7_ = (ValaDataType*) vala_integer_type_new (_tmp6_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "uchar")), NULL, NULL), (self->uchar_type == NULL) ? NULL : (self->uchar_type = (vala_code_node_unref (self->uchar_type), NULL)), _tmp7_);
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_code_node_unref (_tmp6_), NULL));
	_tmp9_ = NULL;
	_tmp8_ = NULL;
	self->short_type = (_tmp9_ = (ValaDataType*) vala_integer_type_new (_tmp8_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "short")), NULL, NULL), (self->short_type == NULL) ? NULL : (self->short_type = (vala_code_node_unref (self->short_type), NULL)), _tmp9_);
	(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_code_node_unref (_tmp8_), NULL));
	_tmp11_ = NULL;
	_tmp10_ = NULL;
	self->ushort_type = (_tmp11_ = (ValaDataType*) vala_integer_type_new (_tmp10_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "ushort")), NULL, NULL), (self->ushort_type == NULL) ? NULL : (self->ushort_type = (vala_code_node_unref (self->ushort_type), NULL)), _tmp11_);
	(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_code_node_unref (_tmp10_), NULL));
	_tmp13_ = NULL;
	_tmp12_ = NULL;
	self->int_type = (_tmp13_ = (ValaDataType*) vala_integer_type_new (_tmp12_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "int")), NULL, NULL), (self->int_type == NULL) ? NULL : (self->int_type = (vala_code_node_unref (self->int_type), NULL)), _tmp13_);
	(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_code_node_unref (_tmp12_), NULL));
	_tmp15_ = NULL;
	_tmp14_ = NULL;
	self->uint_type = (_tmp15_ = (ValaDataType*) vala_integer_type_new (_tmp14_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "uint")), NULL, NULL), (self->uint_type == NULL) ? NULL : (self->uint_type = (vala_code_node_unref (self->uint_type), NULL)), _tmp15_);
	(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_code_node_unref (_tmp14_), NULL));
	_tmp17_ = NULL;
	_tmp16_ = NULL;
	self->long_type = (_tmp17_ = (ValaDataType*) vala_integer_type_new (_tmp16_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "long")), NULL, NULL), (self->long_type == NULL) ? NULL : (self->long_type = (vala_code_node_unref (self->long_type), NULL)), _tmp17_);
	(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_code_node_unref (_tmp16_), NULL));
	_tmp19_ = NULL;
	_tmp18_ = NULL;
	self->ulong_type = (_tmp19_ = (ValaDataType*) vala_integer_type_new (_tmp18_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "ulong")), NULL, NULL), (self->ulong_type == NULL) ? NULL : (self->ulong_type = (vala_code_node_unref (self->ulong_type), NULL)), _tmp19_);
	(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_code_node_unref (_tmp18_), NULL));
	_tmp21_ = NULL;
	_tmp20_ = NULL;
	self->size_t_type = (_tmp21_ = (ValaDataType*) vala_integer_type_new (_tmp20_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "size_t")), NULL, NULL), (self->size_t_type == NULL) ? NULL : (self->size_t_type = (vala_code_node_unref (self->size_t_type), NULL)), _tmp21_);
	(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_code_node_unref (_tmp20_), NULL));
	_tmp23_ = NULL;
	_tmp22_ = NULL;
	self->ssize_t_type = (_tmp23_ = (ValaDataType*) vala_integer_type_new (_tmp22_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "ssize_t")), NULL, NULL), (self->ssize_t_type == NULL) ? NULL : (self->ssize_t_type = (vala_code_node_unref (self->ssize_t_type), NULL)), _tmp23_);
	(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_code_node_unref (_tmp22_), NULL));
	_tmp25_ = NULL;
	_tmp24_ = NULL;
	self->uint64_type = (_tmp25_ = (ValaDataType*) vala_integer_type_new (_tmp24_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "uint64")), NULL, NULL), (self->uint64_type == NULL) ? NULL : (self->uint64_type = (vala_code_node_unref (self->uint64_type), NULL)), _tmp25_);
	(_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_code_node_unref (_tmp24_), NULL));
	_tmp27_ = NULL;
	_tmp26_ = NULL;
	self->int8_type = (_tmp27_ = (ValaDataType*) vala_integer_type_new (_tmp26_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "int8")), NULL, NULL), (self->int8_type == NULL) ? NULL : (self->int8_type = (vala_code_node_unref (self->int8_type), NULL)), _tmp27_);
	(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_code_node_unref (_tmp26_), NULL));
	_tmp29_ = NULL;
	_tmp28_ = NULL;
	self->unichar_type = (_tmp29_ = (ValaDataType*) vala_integer_type_new (_tmp28_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "unichar")), NULL, NULL), (self->unichar_type == NULL) ? NULL : (self->unichar_type = (vala_code_node_unref (self->unichar_type), NULL)), _tmp29_);
	(_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_code_node_unref (_tmp28_), NULL));
	_tmp31_ = NULL;
	_tmp30_ = NULL;
	self->double_type = (_tmp31_ = (ValaDataType*) vala_floating_type_new (_tmp30_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "double"))), (self->double_type == NULL) ? NULL : (self->double_type = (vala_code_node_unref (self->double_type), NULL)), _tmp31_);
	(_tmp30_ == NULL) ? NULL : (_tmp30_ = (vala_code_node_unref (_tmp30_), NULL));
	/* TODO: don't require GLib namespace in semantic analyzer*/
	glib_ns = vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "GLib");
	if (glib_ns != NULL) {
		ValaClass* _tmp32_;
		ValaDataType* _tmp34_;
		ValaStruct* _tmp33_;
		ValaDataType* _tmp36_;
		ValaClass* _tmp35_;
		ValaDataType* _tmp38_;
		ValaClass* _tmp37_;
		ValaDataType* _tmp40_;
		ValaClass* _tmp39_;
		ValaClass* _tmp41_;
		_tmp32_ = NULL;
		self->object_type = (_tmp32_ = VALA_CLASS (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Object")), (self->object_type == NULL) ? NULL : (self->object_type = (vala_code_node_unref (self->object_type), NULL)), _tmp32_);
		_tmp34_ = NULL;
		_tmp33_ = NULL;
		self->type_type = (_tmp34_ = (ValaDataType*) vala_integer_type_new (_tmp33_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Type")), NULL, NULL), (self->type_type == NULL) ? NULL : (self->type_type = (vala_code_node_unref (self->type_type), NULL)), _tmp34_);
		(_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_code_node_unref (_tmp33_), NULL));
		_tmp36_ = NULL;
		_tmp35_ = NULL;
		self->glist_type = (_tmp36_ = (ValaDataType*) vala_object_type_new ((ValaObjectTypeSymbol*) (_tmp35_ = VALA_CLASS (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "List")))), (self->glist_type == NULL) ? NULL : (self->glist_type = (vala_code_node_unref (self->glist_type), NULL)), _tmp36_);
		(_tmp35_ == NULL) ? NULL : (_tmp35_ = (vala_code_node_unref (_tmp35_), NULL));
		_tmp38_ = NULL;
		_tmp37_ = NULL;
		self->gslist_type = (_tmp38_ = (ValaDataType*) vala_object_type_new ((ValaObjectTypeSymbol*) (_tmp37_ = VALA_CLASS (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "SList")))), (self->gslist_type == NULL) ? NULL : (self->gslist_type = (vala_code_node_unref (self->gslist_type), NULL)), _tmp38_);
		(_tmp37_ == NULL) ? NULL : (_tmp37_ = (vala_code_node_unref (_tmp37_), NULL));
		_tmp40_ = NULL;
		_tmp39_ = NULL;
		self->garray_type = (_tmp40_ = (ValaDataType*) vala_object_type_new ((ValaObjectTypeSymbol*) (_tmp39_ = VALA_CLASS (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Array")))), (self->garray_type == NULL) ? NULL : (self->garray_type = (vala_code_node_unref (self->garray_type), NULL)), _tmp40_);
		(_tmp39_ == NULL) ? NULL : (_tmp39_ = (vala_code_node_unref (_tmp39_), NULL));
		_tmp41_ = NULL;
		self->gerror_type = (_tmp41_ = VALA_CLASS (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Error")), (self->gerror_type == NULL) ? NULL : (self->gerror_type = (vala_code_node_unref (self->gerror_type), NULL)), _tmp41_);
	}
	vala_semantic_analyzer_set_current_symbol (self, self->root_symbol);
	vala_code_node_check ((ValaCodeNode*) vala_code_context_get_root (context), self);
	vala_code_context_accept (context, (ValaCodeVisitor*) self);
	(glib_ns == NULL) ? NULL : (glib_ns = (vala_code_node_unref (glib_ns), NULL));
}


static void vala_semantic_analyzer_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* file) {
	ValaSemanticAnalyzer * self;
	self = (ValaSemanticAnalyzer*) base;
	g_return_if_fail (file != NULL);
	vala_semantic_analyzer_set_current_source_file (self, file);
	vala_source_file_check (file, self);
}


/* check whether type is at least as accessible as the specified symbol*/
gboolean vala_semantic_analyzer_is_type_accessible (ValaSemanticAnalyzer* self, ValaSymbol* sym, ValaDataType* type) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sym != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	{
		GeeList* _tmp0_;
		GeeIterator* _tmp1_;
		GeeIterator* _type_symbol_it;
		_tmp0_ = NULL;
		_tmp1_ = NULL;
		_type_symbol_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = vala_data_type_get_symbols (type))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (gee_collection_object_unref (_tmp0_), NULL)), _tmp1_);
		while (gee_iterator_next (_type_symbol_it)) {
			ValaSymbol* type_symbol;
			ValaScope* method_scope;
			ValaScope* type_scope;
			gboolean _tmp2_;
			gboolean _tmp3_;
			type_symbol = (ValaSymbol*) gee_iterator_get (_type_symbol_it);
			method_scope = vala_symbol_get_top_accessible_scope (sym, FALSE);
			type_scope = vala_symbol_get_top_accessible_scope (type_symbol, FALSE);
			_tmp2_ = FALSE;
			_tmp3_ = FALSE;
			if (method_scope == NULL) {
				_tmp3_ = type_scope != NULL;
			} else {
				_tmp3_ = FALSE;
			}
			if (_tmp3_) {
				_tmp2_ = TRUE;
			} else {
				gboolean _tmp4_;
				_tmp4_ = FALSE;
				if (method_scope != NULL) {
					_tmp4_ = !vala_scope_is_subscope_of (method_scope, type_scope);
				} else {
					_tmp4_ = FALSE;
				}
				_tmp2_ = _tmp4_;
			}
			if (_tmp2_) {
				gboolean _tmp5_;
				return (_tmp5_ = FALSE, (type_symbol == NULL) ? NULL : (type_symbol = (vala_code_node_unref (type_symbol), NULL)), (method_scope == NULL) ? NULL : (method_scope = (vala_scope_unref (method_scope), NULL)), (type_scope == NULL) ? NULL : (type_scope = (vala_scope_unref (type_scope), NULL)), (_type_symbol_it == NULL) ? NULL : (_type_symbol_it = (gee_collection_object_unref (_type_symbol_it), NULL)), _tmp5_);
			}
			(type_symbol == NULL) ? NULL : (type_symbol = (vala_code_node_unref (type_symbol), NULL));
			(method_scope == NULL) ? NULL : (method_scope = (vala_scope_unref (method_scope), NULL));
			(type_scope == NULL) ? NULL : (type_scope = (vala_scope_unref (type_scope), NULL));
		}
		(_type_symbol_it == NULL) ? NULL : (_type_symbol_it = (gee_collection_object_unref (_type_symbol_it), NULL));
	}
	return TRUE;
}


ValaDataType* vala_semantic_analyzer_get_value_type_for_symbol (ValaSemanticAnalyzer* self, ValaSymbol* sym, gboolean lvalue) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	if (VALA_IS_FIELD (sym)) {
		ValaField* _tmp0_;
		ValaField* f;
		ValaDataType* type;
		ValaDataType* _tmp1_;
		_tmp0_ = NULL;
		f = (_tmp0_ = VALA_FIELD (sym), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
		type = vala_data_type_copy (vala_field_get_field_type (f));
		if (!lvalue) {
			vala_data_type_set_value_owned (type, FALSE);
		}
		_tmp1_ = NULL;
		return (_tmp1_ = type, (f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL)), _tmp1_);
	} else {
		if (VALA_IS_CONSTANT (sym)) {
			ValaConstant* _tmp2_;
			ValaConstant* c;
			ValaDataType* _tmp3_;
			ValaDataType* _tmp4_;
			_tmp2_ = NULL;
			c = (_tmp2_ = VALA_CONSTANT (sym), (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_));
			_tmp3_ = NULL;
			_tmp4_ = NULL;
			return (_tmp4_ = (_tmp3_ = vala_constant_get_type_reference (c), (_tmp3_ == NULL) ? NULL : vala_code_node_ref (_tmp3_)), (c == NULL) ? NULL : (c = (vala_code_node_unref (c), NULL)), _tmp4_);
		} else {
			if (VALA_IS_PROPERTY (sym)) {
				ValaProperty* _tmp5_;
				ValaProperty* prop;
				_tmp5_ = NULL;
				prop = (_tmp5_ = VALA_PROPERTY (sym), (_tmp5_ == NULL) ? NULL : vala_code_node_ref (_tmp5_));
				if (lvalue) {
					gboolean _tmp6_;
					_tmp6_ = FALSE;
					if (vala_property_get_set_accessor (prop) != NULL) {
						_tmp6_ = vala_property_accessor_get_value_type (vala_property_get_set_accessor (prop)) != NULL;
					} else {
						_tmp6_ = FALSE;
					}
					if (_tmp6_) {
						ValaDataType* _tmp7_;
						_tmp7_ = NULL;
						return (_tmp7_ = vala_data_type_copy (vala_property_accessor_get_value_type (vala_property_get_set_accessor (prop))), (prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL)), _tmp7_);
					}
				} else {
					gboolean _tmp8_;
					_tmp8_ = FALSE;
					if (vala_property_get_get_accessor (prop) != NULL) {
						_tmp8_ = vala_property_accessor_get_value_type (vala_property_get_get_accessor (prop)) != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					if (_tmp8_) {
						ValaDataType* _tmp9_;
						_tmp9_ = NULL;
						return (_tmp9_ = vala_data_type_copy (vala_property_accessor_get_value_type (vala_property_get_get_accessor (prop))), (prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL)), _tmp9_);
					}
				}
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
			} else {
				if (VALA_IS_FORMAL_PARAMETER (sym)) {
					ValaFormalParameter* _tmp10_;
					ValaFormalParameter* p;
					ValaDataType* type;
					ValaDataType* _tmp11_;
					_tmp10_ = NULL;
					p = (_tmp10_ = VALA_FORMAL_PARAMETER (sym), (_tmp10_ == NULL) ? NULL : vala_code_node_ref (_tmp10_));
					type = vala_data_type_copy (vala_formal_parameter_get_parameter_type (p));
					if (!lvalue) {
						vala_data_type_set_value_owned (type, FALSE);
					}
					_tmp11_ = NULL;
					return (_tmp11_ = type, (p == NULL) ? NULL : (p = (vala_code_node_unref (p), NULL)), _tmp11_);
				} else {
					if (VALA_IS_LOCAL_VARIABLE (sym)) {
						ValaLocalVariable* _tmp12_;
						ValaLocalVariable* local;
						ValaDataType* type;
						gboolean _tmp13_;
						ValaDataType* _tmp14_;
						_tmp12_ = NULL;
						local = (_tmp12_ = VALA_LOCAL_VARIABLE (sym), (_tmp12_ == NULL) ? NULL : vala_code_node_ref (_tmp12_));
						type = vala_data_type_copy (vala_local_variable_get_variable_type (local));
						_tmp13_ = FALSE;
						if (!lvalue) {
							_tmp13_ = !vala_local_variable_get_floating (local);
						} else {
							_tmp13_ = FALSE;
						}
						if (_tmp13_) {
							vala_data_type_set_value_owned (type, FALSE);
						}
						_tmp14_ = NULL;
						return (_tmp14_ = type, (local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL)), _tmp14_);
					} else {
						if (VALA_IS_ENUM_VALUE (sym)) {
							return (ValaDataType*) vala_enum_value_type_new (VALA_ENUM (vala_symbol_get_parent_symbol (sym)));
						} else {
							if (VALA_IS_METHOD (sym)) {
								return (ValaDataType*) vala_method_type_new (VALA_METHOD (sym));
							} else {
								if (VALA_IS_SIGNAL (sym)) {
									return (ValaDataType*) vala_signal_type_new (VALA_SIGNAL (sym));
								}
							}
						}
					}
				}
			}
		}
	}
	return NULL;
}


ValaSymbol* vala_semantic_analyzer_symbol_lookup_inherited (ValaSymbol* sym, const char* name) {
	ValaSymbol* _result_;
	ValaSymbol* _tmp19_;
	g_return_val_if_fail (sym != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_result_ = vala_scope_lookup (vala_symbol_get_scope (sym), name);
	if (_result_ != NULL) {
		return _result_;
	}
	if (VALA_IS_CLASS (sym)) {
		ValaClass* _tmp1_;
		ValaClass* cl;
		_tmp1_ = NULL;
		cl = (_tmp1_ = VALA_CLASS (sym), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
		/* first check interfaces without prerequisites
		 (prerequisites can be assumed to be met already)*/
		{
			GeeList* _tmp2_;
			GeeIterator* _tmp3_;
			GeeIterator* _base_type_it;
			/* first check interfaces without prerequisites
			 (prerequisites can be assumed to be met already)*/
			_tmp2_ = NULL;
			_tmp3_ = NULL;
			_base_type_it = (_tmp3_ = gee_iterable_iterator ((GeeIterable*) (_tmp2_ = vala_class_get_base_types (cl))), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (gee_collection_object_unref (_tmp2_), NULL)), _tmp3_);
			/* first check interfaces without prerequisites
			 (prerequisites can be assumed to be met already)*/
			while (gee_iterator_next (_base_type_it)) {
				ValaDataType* base_type;
				/* first check interfaces without prerequisites
				 (prerequisites can be assumed to be met already)*/
				base_type = (ValaDataType*) gee_iterator_get (_base_type_it);
				if (VALA_IS_INTERFACE (vala_data_type_get_data_type (base_type))) {
					ValaSymbol* _tmp4_;
					_tmp4_ = NULL;
					_result_ = (_tmp4_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) vala_data_type_get_data_type (base_type)), name), (_result_ == NULL) ? NULL : (_result_ = (vala_code_node_unref (_result_), NULL)), _tmp4_);
					if (_result_ != NULL) {
						ValaSymbol* _tmp5_;
						_tmp5_ = NULL;
						return (_tmp5_ = _result_, (base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)), (_base_type_it == NULL) ? NULL : (_base_type_it = (gee_collection_object_unref (_base_type_it), NULL)), (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), _tmp5_);
					}
				}
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
			}
			(_base_type_it == NULL) ? NULL : (_base_type_it = (gee_collection_object_unref (_base_type_it), NULL));
		}
		/* then check base class recursively*/
		if (vala_class_get_base_class (cl) != NULL) {
			ValaSymbol* _tmp6_;
			_tmp6_ = NULL;
			return (_tmp6_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) vala_class_get_base_class (cl), name), (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), (_result_ == NULL) ? NULL : (_result_ = (vala_code_node_unref (_result_), NULL)), _tmp6_);
		}
		(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	} else {
		if (VALA_IS_STRUCT (sym)) {
			ValaStruct* _tmp7_;
			ValaStruct* st;
			_tmp7_ = NULL;
			st = (_tmp7_ = VALA_STRUCT (sym), (_tmp7_ == NULL) ? NULL : vala_code_node_ref (_tmp7_));
			if (vala_struct_get_base_type (st) != NULL) {
				ValaSymbol* _tmp8_;
				_tmp8_ = NULL;
				_result_ = (_tmp8_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) vala_data_type_get_data_type (vala_struct_get_base_type (st)), name), (_result_ == NULL) ? NULL : (_result_ = (vala_code_node_unref (_result_), NULL)), _tmp8_);
				if (_result_ != NULL) {
					ValaSymbol* _tmp9_;
					_tmp9_ = NULL;
					return (_tmp9_ = _result_, (st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL)), _tmp9_);
				}
			}
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
		} else {
			if (VALA_IS_INTERFACE (sym)) {
				ValaInterface* _tmp10_;
				ValaInterface* iface;
				_tmp10_ = NULL;
				iface = (_tmp10_ = VALA_INTERFACE (sym), (_tmp10_ == NULL) ? NULL : vala_code_node_ref (_tmp10_));
				/* first check interface prerequisites recursively*/
				{
					GeeList* _tmp11_;
					GeeIterator* _tmp12_;
					GeeIterator* _prerequisite_it;
					/* first check interface prerequisites recursively*/
					_tmp11_ = NULL;
					_tmp12_ = NULL;
					_prerequisite_it = (_tmp12_ = gee_iterable_iterator ((GeeIterable*) (_tmp11_ = vala_interface_get_prerequisites (iface))), (_tmp11_ == NULL) ? NULL : (_tmp11_ = (gee_collection_object_unref (_tmp11_), NULL)), _tmp12_);
					/* first check interface prerequisites recursively*/
					while (gee_iterator_next (_prerequisite_it)) {
						ValaDataType* prerequisite;
						/* first check interface prerequisites recursively*/
						prerequisite = (ValaDataType*) gee_iterator_get (_prerequisite_it);
						if (VALA_IS_INTERFACE (vala_data_type_get_data_type (prerequisite))) {
							ValaSymbol* _tmp13_;
							_tmp13_ = NULL;
							_result_ = (_tmp13_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) vala_data_type_get_data_type (prerequisite), name), (_result_ == NULL) ? NULL : (_result_ = (vala_code_node_unref (_result_), NULL)), _tmp13_);
							if (_result_ != NULL) {
								ValaSymbol* _tmp14_;
								_tmp14_ = NULL;
								return (_tmp14_ = _result_, (prerequisite == NULL) ? NULL : (prerequisite = (vala_code_node_unref (prerequisite), NULL)), (_prerequisite_it == NULL) ? NULL : (_prerequisite_it = (gee_collection_object_unref (_prerequisite_it), NULL)), (iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL)), _tmp14_);
							}
						}
						(prerequisite == NULL) ? NULL : (prerequisite = (vala_code_node_unref (prerequisite), NULL));
					}
					(_prerequisite_it == NULL) ? NULL : (_prerequisite_it = (gee_collection_object_unref (_prerequisite_it), NULL));
				}
				/* then check class prerequisite recursively*/
				{
					GeeList* _tmp15_;
					GeeIterator* _tmp16_;
					GeeIterator* _prerequisite_it;
					/* then check class prerequisite recursively*/
					_tmp15_ = NULL;
					_tmp16_ = NULL;
					_prerequisite_it = (_tmp16_ = gee_iterable_iterator ((GeeIterable*) (_tmp15_ = vala_interface_get_prerequisites (iface))), (_tmp15_ == NULL) ? NULL : (_tmp15_ = (gee_collection_object_unref (_tmp15_), NULL)), _tmp16_);
					/* then check class prerequisite recursively*/
					while (gee_iterator_next (_prerequisite_it)) {
						ValaDataType* prerequisite;
						/* then check class prerequisite recursively*/
						prerequisite = (ValaDataType*) gee_iterator_get (_prerequisite_it);
						if (VALA_IS_CLASS (vala_data_type_get_data_type (prerequisite))) {
							ValaSymbol* _tmp17_;
							_tmp17_ = NULL;
							_result_ = (_tmp17_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) vala_data_type_get_data_type (prerequisite), name), (_result_ == NULL) ? NULL : (_result_ = (vala_code_node_unref (_result_), NULL)), _tmp17_);
							if (_result_ != NULL) {
								ValaSymbol* _tmp18_;
								_tmp18_ = NULL;
								return (_tmp18_ = _result_, (prerequisite == NULL) ? NULL : (prerequisite = (vala_code_node_unref (prerequisite), NULL)), (_prerequisite_it == NULL) ? NULL : (_prerequisite_it = (gee_collection_object_unref (_prerequisite_it), NULL)), (iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL)), _tmp18_);
							}
						}
						(prerequisite == NULL) ? NULL : (prerequisite = (vala_code_node_unref (prerequisite), NULL));
					}
					(_prerequisite_it == NULL) ? NULL : (_prerequisite_it = (gee_collection_object_unref (_prerequisite_it), NULL));
				}
				(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
			}
		}
	}
	_tmp19_ = NULL;
	return (_tmp19_ = NULL, (_result_ == NULL) ? NULL : (_result_ = (vala_code_node_unref (_result_), NULL)), _tmp19_);
}


ValaDataType* vala_semantic_analyzer_get_data_type_for_symbol (ValaTypeSymbol* sym) {
	ValaDataType* type;
	g_return_val_if_fail (sym != NULL, NULL);
	type = NULL;
	if (VALA_IS_OBJECT_TYPE_SYMBOL (sym)) {
		ValaDataType* _tmp0_;
		_tmp0_ = NULL;
		type = (_tmp0_ = (ValaDataType*) vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (sym)), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp0_);
	} else {
		if (VALA_IS_STRUCT (sym)) {
			ValaStruct* _tmp1_;
			ValaStruct* st;
			_tmp1_ = NULL;
			st = (_tmp1_ = VALA_STRUCT (sym), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
			if (vala_struct_is_boolean_type (st)) {
				ValaDataType* _tmp2_;
				_tmp2_ = NULL;
				type = (_tmp2_ = (ValaDataType*) vala_boolean_type_new (st), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp2_);
			} else {
				if (vala_struct_is_integer_type (st)) {
					ValaDataType* _tmp3_;
					_tmp3_ = NULL;
					type = (_tmp3_ = (ValaDataType*) vala_integer_type_new (st, NULL, NULL), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp3_);
				} else {
					if (vala_struct_is_floating_type (st)) {
						ValaDataType* _tmp4_;
						_tmp4_ = NULL;
						type = (_tmp4_ = (ValaDataType*) vala_floating_type_new (st), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp4_);
					} else {
						ValaDataType* _tmp5_;
						_tmp5_ = NULL;
						type = (_tmp5_ = (ValaDataType*) vala_struct_value_type_new (st), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp5_);
					}
				}
			}
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
		} else {
			if (VALA_IS_ENUM (sym)) {
				ValaDataType* _tmp6_;
				_tmp6_ = NULL;
				type = (_tmp6_ = (ValaDataType*) vala_enum_value_type_new (VALA_ENUM (sym)), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp6_);
			} else {
				if (VALA_IS_ERROR_DOMAIN (sym)) {
					ValaDataType* _tmp7_;
					_tmp7_ = NULL;
					type = (_tmp7_ = (ValaDataType*) vala_error_type_new (VALA_ERROR_DOMAIN (sym), NULL, NULL), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp7_);
				} else {
					if (VALA_IS_ERROR_CODE (sym)) {
						ValaDataType* _tmp8_;
						_tmp8_ = NULL;
						type = (_tmp8_ = (ValaDataType*) vala_error_type_new (VALA_ERROR_DOMAIN (vala_symbol_get_parent_symbol ((ValaSymbol*) sym)), VALA_ERROR_CODE (sym), NULL), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp8_);
					} else {
						char* _tmp10_;
						char* _tmp9_;
						ValaDataType* _tmp11_;
						_tmp10_ = NULL;
						_tmp9_ = NULL;
						vala_report_error (NULL, _tmp10_ = g_strdup_printf ("internal error: `%s' is not a supported type", _tmp9_ = vala_symbol_get_full_name ((ValaSymbol*) sym)));
						_tmp10_ = (g_free (_tmp10_), NULL);
						_tmp9_ = (g_free (_tmp9_), NULL);
						_tmp11_ = NULL;
						return (_tmp11_ = (ValaDataType*) vala_invalid_type_new (), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp11_);
					}
				}
			}
		}
	}
	return type;
}


gboolean vala_semantic_analyzer_check_arguments (ValaSemanticAnalyzer* self, ValaExpression* expr, ValaDataType* mtype, GeeList* params, GeeList* args) {
	ValaExpression* prev_arg;
	GeeIterator* arg_it;
	gboolean _tmp0_;
	gboolean diag;
	gboolean ellipsis;
	gint i;
	gboolean _tmp30_;
	gboolean _tmp35_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (expr != NULL, FALSE);
	g_return_val_if_fail (mtype != NULL, FALSE);
	g_return_val_if_fail (params != NULL, FALSE);
	g_return_val_if_fail (args != NULL, FALSE);
	prev_arg = NULL;
	arg_it = gee_iterable_iterator ((GeeIterable*) args);
	_tmp0_ = FALSE;
	if (VALA_IS_METHOD_TYPE (mtype)) {
		ValaAttribute* _tmp1_;
		_tmp1_ = NULL;
		_tmp0_ = (_tmp1_ = vala_code_node_get_attribute ((ValaCodeNode*) vala_method_type_get_method_symbol (VALA_METHOD_TYPE (mtype)), "Diagnostics")) != NULL;
		(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_code_node_unref (_tmp1_), NULL));
	} else {
		_tmp0_ = FALSE;
	}
	diag = _tmp0_;
	ellipsis = FALSE;
	i = 0;
	{
		GeeIterator* _param_it;
		_param_it = gee_iterable_iterator ((GeeIterable*) params);
		while (gee_iterator_next (_param_it)) {
			ValaFormalParameter* param;
			gboolean _tmp4_;
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			if (!vala_code_node_check ((ValaCodeNode*) param, self)) {
				gboolean _tmp2_;
				return (_tmp2_ = FALSE, (param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL)), (_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL)), (prev_arg == NULL) ? NULL : (prev_arg = (vala_code_node_unref (prev_arg), NULL)), (arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL)), _tmp2_);
			}
			if (vala_formal_parameter_get_ellipsis (param)) {
				ellipsis = TRUE;
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				break;
			}
			if (vala_formal_parameter_get_params_array (param)) {
				while (gee_iterator_next (arg_it)) {
					ValaExpression* arg;
					arg = (ValaExpression*) gee_iterator_get (arg_it);
					if (!vala_semantic_analyzer_check_argument (self, arg, i, vala_formal_parameter_get_direction (param))) {
						gboolean _tmp3_;
						vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
						return (_tmp3_ = FALSE, (arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL)), (param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL)), (_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL)), (prev_arg == NULL) ? NULL : (prev_arg = (vala_code_node_unref (prev_arg), NULL)), (arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL)), _tmp3_);
					}
					i++;
					(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
				}
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				break;
			}
			_tmp4_ = FALSE;
			if (arg_it == NULL) {
				_tmp4_ = TRUE;
			} else {
				_tmp4_ = !gee_iterator_next (arg_it);
			}
			if (_tmp4_) {
				if (vala_formal_parameter_get_default_expression (param) == NULL) {
					char* _tmp6_;
					char* _tmp5_;
					gboolean _tmp7_;
					vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
					_tmp6_ = NULL;
					_tmp5_ = NULL;
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) expr), _tmp6_ = g_strdup_printf ("Too few arguments, method `%s' does not take %d arguments", _tmp5_ = vala_code_node_to_string ((ValaCodeNode*) mtype), gee_collection_get_size ((GeeCollection*) args)));
					_tmp6_ = (g_free (_tmp6_), NULL);
					_tmp5_ = (g_free (_tmp5_), NULL);
					return (_tmp7_ = FALSE, (param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL)), (_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL)), (prev_arg == NULL) ? NULL : (prev_arg = (vala_code_node_unref (prev_arg), NULL)), (arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL)), _tmp7_);
				} else {
					ValaMethodCall* _tmp9_;
					ValaExpression* _tmp8_;
					ValaMethodCall* invocation_expr;
					ValaObjectCreationExpression* _tmp11_;
					ValaExpression* _tmp10_;
					ValaObjectCreationExpression* object_creation_expr;
					GeeIterator* _tmp12_;
					_tmp9_ = NULL;
					_tmp8_ = NULL;
					invocation_expr = (_tmp9_ = (_tmp8_ = expr, VALA_IS_METHOD_CALL (_tmp8_) ? ((ValaMethodCall*) _tmp8_) : NULL), (_tmp9_ == NULL) ? NULL : vala_code_node_ref (_tmp9_));
					_tmp11_ = NULL;
					_tmp10_ = NULL;
					object_creation_expr = (_tmp11_ = (_tmp10_ = expr, VALA_IS_OBJECT_CREATION_EXPRESSION (_tmp10_) ? ((ValaObjectCreationExpression*) _tmp10_) : NULL), (_tmp11_ == NULL) ? NULL : vala_code_node_ref (_tmp11_));
					if (invocation_expr != NULL) {
						vala_method_call_add_argument (invocation_expr, vala_formal_parameter_get_default_expression (param));
					} else {
						if (object_creation_expr != NULL) {
							vala_object_creation_expression_add_argument (object_creation_expr, vala_formal_parameter_get_default_expression (param));
						} else {
							g_assert_not_reached ();
						}
					}
					_tmp12_ = NULL;
					arg_it = (_tmp12_ = NULL, (arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL)), _tmp12_);
					(invocation_expr == NULL) ? NULL : (invocation_expr = (vala_code_node_unref (invocation_expr), NULL));
					(object_creation_expr == NULL) ? NULL : (object_creation_expr = (vala_code_node_unref (object_creation_expr), NULL));
				}
			} else {
				ValaExpression* arg;
				ValaExpression* _tmp15_;
				ValaExpression* _tmp14_;
				arg = (ValaExpression*) gee_iterator_get (arg_it);
				if (!vala_semantic_analyzer_check_argument (self, arg, i, vala_formal_parameter_get_direction (param))) {
					gboolean _tmp13_;
					vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
					return (_tmp13_ = FALSE, (arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL)), (param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL)), (_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL)), (prev_arg == NULL) ? NULL : (prev_arg = (vala_code_node_unref (prev_arg), NULL)), (arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL)), _tmp13_);
				}
				_tmp15_ = NULL;
				_tmp14_ = NULL;
				prev_arg = (_tmp15_ = (_tmp14_ = arg, (_tmp14_ == NULL) ? NULL : vala_code_node_ref (_tmp14_)), (prev_arg == NULL) ? NULL : (prev_arg = (vala_code_node_unref (prev_arg), NULL)), _tmp15_);
				i++;
				(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
			}
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	if (ellipsis) {
		while (TRUE) {
			gboolean _tmp16_;
			ValaExpression* arg;
			_tmp16_ = FALSE;
			if (arg_it != NULL) {
				_tmp16_ = gee_iterator_next (arg_it);
			} else {
				_tmp16_ = FALSE;
			}
			if (!_tmp16_) {
				break;
			}
			arg = (ValaExpression*) gee_iterator_get (arg_it);
			if (vala_code_node_get_error ((ValaCodeNode*) arg)) {
				gboolean _tmp17_;
				/* ignore inner error*/
				vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
				return (_tmp17_ = FALSE, (arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL)), (prev_arg == NULL) ? NULL : (prev_arg = (vala_code_node_unref (prev_arg), NULL)), (arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL)), _tmp17_);
			} else {
				if (vala_expression_get_value_type (arg) == NULL) {
					/* disallow untyped arguments except for type inference of callbacks*/
					if (!VALA_IS_METHOD (vala_expression_get_symbol_reference (arg))) {
						char* _tmp18_;
						gboolean _tmp19_;
						vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
						_tmp18_ = NULL;
						vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) expr), _tmp18_ = g_strdup_printf ("Invalid type for argument %d", i + 1));
						_tmp18_ = (g_free (_tmp18_), NULL);
						return (_tmp19_ = FALSE, (arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL)), (prev_arg == NULL) ? NULL : (prev_arg = (vala_code_node_unref (prev_arg), NULL)), (arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL)), _tmp19_);
					}
				} else {
					gboolean _tmp20_;
					_tmp20_ = FALSE;
					if (vala_expression_get_target_type (arg) != NULL) {
						_tmp20_ = !vala_data_type_compatible (vala_expression_get_value_type (arg), vala_expression_get_target_type (arg));
					} else {
						_tmp20_ = FALSE;
					}
					if (_tmp20_) {
						char* _tmp23_;
						char* _tmp22_;
						char* _tmp21_;
						gboolean _tmp24_;
						/* target_type known for printf arguments*/
						vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
						_tmp23_ = NULL;
						_tmp22_ = NULL;
						_tmp21_ = NULL;
						vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) arg), _tmp23_ = g_strdup_printf ("Argument %d: Cannot convert from `%s' to `%s'", i + 1, _tmp21_ = vala_code_node_to_string ((ValaCodeNode*) vala_expression_get_value_type (arg)), _tmp22_ = vala_code_node_to_string ((ValaCodeNode*) vala_expression_get_target_type (arg))));
						_tmp23_ = (g_free (_tmp23_), NULL);
						_tmp22_ = (g_free (_tmp22_), NULL);
						_tmp21_ = (g_free (_tmp21_), NULL);
						return (_tmp24_ = FALSE, (arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL)), (prev_arg == NULL) ? NULL : (prev_arg = (vala_code_node_unref (prev_arg), NULL)), (arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL)), _tmp24_);
					}
				}
			}
			i++;
			(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
		}
	} else {
		gboolean _tmp25_;
		gboolean _tmp26_;
		_tmp25_ = FALSE;
		_tmp26_ = FALSE;
		if (!ellipsis) {
			_tmp26_ = arg_it != NULL;
		} else {
			_tmp26_ = FALSE;
		}
		if (_tmp26_) {
			_tmp25_ = gee_iterator_next (arg_it);
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			char* _tmp28_;
			char* _tmp27_;
			gboolean _tmp29_;
			vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
			_tmp28_ = NULL;
			_tmp27_ = NULL;
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) expr), _tmp28_ = g_strdup_printf ("Too many arguments, method `%s' does not take %d arguments", _tmp27_ = vala_code_node_to_string ((ValaCodeNode*) mtype), gee_collection_get_size ((GeeCollection*) args)));
			_tmp28_ = (g_free (_tmp28_), NULL);
			_tmp27_ = (g_free (_tmp27_), NULL);
			return (_tmp29_ = FALSE, (prev_arg == NULL) ? NULL : (prev_arg = (vala_code_node_unref (prev_arg), NULL)), (arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL)), _tmp29_);
		}
	}
	_tmp30_ = FALSE;
	if (diag) {
		_tmp30_ = prev_arg != NULL;
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		ValaStringLiteral* _tmp32_;
		ValaExpression* _tmp31_;
		ValaStringLiteral* format_arg;
		_tmp32_ = NULL;
		_tmp31_ = NULL;
		format_arg = (_tmp32_ = (_tmp31_ = prev_arg, VALA_IS_STRING_LITERAL (_tmp31_) ? ((ValaStringLiteral*) _tmp31_) : NULL), (_tmp32_ == NULL) ? NULL : vala_code_node_ref (_tmp32_));
		if (format_arg != NULL) {
			char* _tmp34_;
			char* _tmp33_;
			_tmp34_ = NULL;
			_tmp33_ = NULL;
			vala_string_literal_set_value (format_arg, _tmp34_ = g_strdup_printf ("\"%s:%d: %s", _tmp33_ = g_path_get_basename (vala_source_file_get_filename (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) expr)))), vala_source_reference_get_first_line (vala_code_node_get_source_reference ((ValaCodeNode*) expr)), g_utf8_offset_to_pointer (vala_string_literal_get_value (format_arg), (glong) 1)));
			_tmp34_ = (g_free (_tmp34_), NULL);
			_tmp33_ = (g_free (_tmp33_), NULL);
		}
		(format_arg == NULL) ? NULL : (format_arg = (vala_code_node_unref (format_arg), NULL));
	}
	return (_tmp35_ = TRUE, (prev_arg == NULL) ? NULL : (prev_arg = (vala_code_node_unref (prev_arg), NULL)), (arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL)), _tmp35_);
}


static gboolean vala_semantic_analyzer_check_argument (ValaSemanticAnalyzer* self, ValaExpression* arg, gint i, ValaParameterDirection direction) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (arg != NULL, FALSE);
	if (vala_code_node_get_error ((ValaCodeNode*) arg)) {
		/* ignore inner error*/
		return FALSE;
	} else {
		if (vala_expression_get_value_type (arg) == NULL) {
			gboolean _tmp1_;
			_tmp1_ = FALSE;
			if (!VALA_IS_DELEGATE_TYPE (vala_expression_get_target_type (arg))) {
				_tmp1_ = TRUE;
			} else {
				_tmp1_ = !VALA_IS_METHOD (vala_expression_get_symbol_reference (arg));
			}
			/* disallow untyped arguments except for type inference of callbacks*/
			if (_tmp1_) {
				char* _tmp2_;
				_tmp2_ = NULL;
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) arg), _tmp2_ = g_strdup_printf ("Invalid type for argument %d", i + 1));
				_tmp2_ = (g_free (_tmp2_), NULL);
				return FALSE;
			}
		} else {
			gboolean _tmp4_;
			gboolean _tmp5_;
			_tmp4_ = FALSE;
			_tmp5_ = FALSE;
			if (vala_expression_get_target_type (arg) != NULL) {
				_tmp5_ = !vala_data_type_compatible (vala_expression_get_value_type (arg), vala_expression_get_target_type (arg));
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				gboolean _tmp6_;
				_tmp6_ = FALSE;
				if (VALA_IS_NULL_LITERAL (arg)) {
					_tmp6_ = direction == VALA_PARAMETER_DIRECTION_OUT;
				} else {
					_tmp6_ = FALSE;
				}
				_tmp4_ = !_tmp6_;
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				char* _tmp9_;
				char* _tmp8_;
				char* _tmp7_;
				_tmp9_ = NULL;
				_tmp8_ = NULL;
				_tmp7_ = NULL;
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) arg), _tmp9_ = g_strdup_printf ("Argument %d: Cannot convert from `%s' to `%s'", i + 1, _tmp7_ = vala_code_node_to_string ((ValaCodeNode*) vala_expression_get_value_type (arg)), _tmp8_ = vala_code_node_to_string ((ValaCodeNode*) vala_expression_get_target_type (arg))));
				_tmp9_ = (g_free (_tmp9_), NULL);
				_tmp8_ = (g_free (_tmp8_), NULL);
				_tmp7_ = (g_free (_tmp7_), NULL);
				return FALSE;
			} else {
				gint arg_type;
				/* 0 => null, 1 => in, 2 => ref, 3 => out*/
				arg_type = 1;
				if (VALA_IS_NULL_TYPE (vala_expression_get_value_type (arg))) {
					arg_type = 0;
				} else {
					if (VALA_IS_UNARY_EXPRESSION (arg)) {
						ValaUnaryExpression* _tmp11_;
						ValaUnaryExpression* unary;
						_tmp11_ = NULL;
						unary = (_tmp11_ = VALA_UNARY_EXPRESSION (arg), (_tmp11_ == NULL) ? NULL : vala_code_node_ref (_tmp11_));
						if (vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_REF) {
							arg_type = 2;
						} else {
							if (vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_OUT) {
								arg_type = 3;
							}
						}
						(unary == NULL) ? NULL : (unary = (vala_code_node_unref (unary), NULL));
					}
				}
				if (arg_type == 0) {
					if (direction == VALA_PARAMETER_DIRECTION_REF) {
						char* _tmp12_;
						_tmp12_ = NULL;
						vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) arg), _tmp12_ = g_strdup_printf ("Argument %d: Cannot pass null to reference parameter", i + 1));
						_tmp12_ = (g_free (_tmp12_), NULL);
						return FALSE;
					} else {
						gboolean _tmp14_;
						_tmp14_ = FALSE;
						if (direction != VALA_PARAMETER_DIRECTION_OUT) {
							_tmp14_ = !vala_data_type_get_nullable (vala_expression_get_target_type (arg));
						} else {
							_tmp14_ = FALSE;
						}
						if (_tmp14_) {
							char* _tmp15_;
							_tmp15_ = NULL;
							vala_report_warning (vala_code_node_get_source_reference ((ValaCodeNode*) arg), _tmp15_ = g_strdup_printf ("Argument %d: Cannot pass null to non-null parameter type", i + 1));
							_tmp15_ = (g_free (_tmp15_), NULL);
						}
					}
				} else {
					if (arg_type == 1) {
						if (direction != VALA_PARAMETER_DIRECTION_IN) {
							char* _tmp16_;
							_tmp16_ = NULL;
							vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) arg), _tmp16_ = g_strdup_printf ("Argument %d: Cannot pass value to reference or output parameter", i + 1));
							_tmp16_ = (g_free (_tmp16_), NULL);
							return FALSE;
						}
					} else {
						if (arg_type == 2) {
							if (direction != VALA_PARAMETER_DIRECTION_REF) {
								char* _tmp18_;
								_tmp18_ = NULL;
								vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) arg), _tmp18_ = g_strdup_printf ("Argument %d: Cannot pass ref argument to non-reference parameter", i + 1));
								_tmp18_ = (g_free (_tmp18_), NULL);
								return FALSE;
							}
							/* weak variables can only be used with weak ref parameters*/
							if (vala_data_type_is_disposable (vala_expression_get_target_type (arg))) {
								gboolean _tmp20_;
								_tmp20_ = FALSE;
								if (!VALA_IS_POINTER_TYPE (vala_expression_get_value_type (arg))) {
									_tmp20_ = !vala_data_type_get_value_owned (vala_expression_get_value_type (arg));
								} else {
									_tmp20_ = FALSE;
								}
								if (_tmp20_) {
									/* variable doesn't own the value */
									vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) arg), "Invalid assignment from owned expression to unowned variable");
									return FALSE;
								}
							}
						} else {
							if (arg_type == 3) {
								if (direction != VALA_PARAMETER_DIRECTION_OUT) {
									char* _tmp22_;
									_tmp22_ = NULL;
									vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) arg), _tmp22_ = g_strdup_printf ("Argument %d: Cannot pass out argument to non-output parameter", i + 1));
									_tmp22_ = (g_free (_tmp22_), NULL);
									return FALSE;
								}
								/* weak variables can only be used with weak out parameters*/
								if (vala_data_type_is_disposable (vala_expression_get_target_type (arg))) {
									gboolean _tmp24_;
									_tmp24_ = FALSE;
									if (!VALA_IS_POINTER_TYPE (vala_expression_get_value_type (arg))) {
										_tmp24_ = !vala_data_type_get_value_owned (vala_expression_get_value_type (arg));
									} else {
										_tmp24_ = FALSE;
									}
									if (_tmp24_) {
										/* variable doesn't own the value */
										vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) arg), "Invalid assignment from owned expression to unowned variable");
										return FALSE;
									}
								}
							}
						}
					}
				}
			}
		}
	}
	return TRUE;
}


static ValaDataType* vala_semantic_analyzer_get_instance_base_type (ValaDataType* instance_type, ValaDataType* base_type, ValaCodeNode* node_reference) {
	ValaReferenceType* instance_base_type;
	g_return_val_if_fail (instance_type != NULL, NULL);
	g_return_val_if_fail (base_type != NULL, NULL);
	g_return_val_if_fail (node_reference != NULL, NULL);
	/* construct a new type reference for the base type with correctly linked type arguments*/
	instance_base_type = NULL;
	if (VALA_IS_CLASS (vala_data_type_get_data_type (base_type))) {
		ValaReferenceType* _tmp0_;
		_tmp0_ = NULL;
		instance_base_type = (_tmp0_ = (ValaReferenceType*) vala_object_type_new ((ValaObjectTypeSymbol*) VALA_CLASS (vala_data_type_get_data_type (base_type))), (instance_base_type == NULL) ? NULL : (instance_base_type = (vala_code_node_unref (instance_base_type), NULL)), _tmp0_);
	} else {
		ValaReferenceType* _tmp1_;
		_tmp1_ = NULL;
		instance_base_type = (_tmp1_ = (ValaReferenceType*) vala_object_type_new ((ValaObjectTypeSymbol*) VALA_INTERFACE (vala_data_type_get_data_type (base_type))), (instance_base_type == NULL) ? NULL : (instance_base_type = (vala_code_node_unref (instance_base_type), NULL)), _tmp1_);
	}
	{
		GeeList* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _type_arg_it;
		_tmp2_ = NULL;
		_tmp3_ = NULL;
		_type_arg_it = (_tmp3_ = gee_iterable_iterator ((GeeIterable*) (_tmp2_ = vala_data_type_get_type_arguments (base_type))), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (gee_collection_object_unref (_tmp2_), NULL)), _tmp3_);
		while (gee_iterator_next (_type_arg_it)) {
			ValaDataType* type_arg;
			type_arg = (ValaDataType*) gee_iterator_get (_type_arg_it);
			if (vala_data_type_get_type_parameter (type_arg) != NULL) {
				gint param_index;
				GeeList* _tmp6_;
				gboolean _tmp7_;
				ValaDataType* _tmp13_;
				GeeList* _tmp12_;
				/* link to type argument of derived type*/
				param_index = vala_typesymbol_get_type_parameter_index (vala_data_type_get_data_type (instance_type), vala_symbol_get_name ((ValaSymbol*) vala_data_type_get_type_parameter (type_arg)));
				if (param_index == (-1)) {
					char* _tmp4_;
					ValaDataType* _tmp5_;
					_tmp4_ = NULL;
					vala_report_error (vala_code_node_get_source_reference (node_reference), _tmp4_ = g_strdup_printf ("internal error: unknown type parameter %s", vala_symbol_get_name ((ValaSymbol*) vala_data_type_get_type_parameter (type_arg))));
					_tmp4_ = (g_free (_tmp4_), NULL);
					vala_code_node_set_error (node_reference, TRUE);
					_tmp5_ = NULL;
					return (_tmp5_ = NULL, (type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL)), (_type_arg_it == NULL) ? NULL : (_type_arg_it = (gee_collection_object_unref (_type_arg_it), NULL)), (instance_base_type == NULL) ? NULL : (instance_base_type = (vala_code_node_unref (instance_base_type), NULL)), _tmp5_);
				}
				_tmp6_ = NULL;
				if ((_tmp7_ = gee_collection_get_size ((GeeCollection*) (_tmp6_ = vala_data_type_get_type_arguments (instance_type))) <= param_index, (_tmp6_ == NULL) ? NULL : (_tmp6_ = (gee_collection_object_unref (_tmp6_), NULL)), _tmp7_)) {
					char* _tmp10_;
					char* _tmp9_;
					char* _tmp8_;
					ValaDataType* _tmp11_;
					_tmp10_ = NULL;
					_tmp9_ = NULL;
					_tmp8_ = NULL;
					vala_report_error (vala_code_node_get_source_reference (node_reference), _tmp10_ = g_strdup_printf ("internal error: missing type argument for type parameter `%s' in `%s'", _tmp8_ = vala_symbol_get_full_name ((ValaSymbol*) vala_data_type_get_type_parameter (type_arg)), _tmp9_ = vala_code_node_to_string ((ValaCodeNode*) instance_type)));
					_tmp10_ = (g_free (_tmp10_), NULL);
					_tmp9_ = (g_free (_tmp9_), NULL);
					_tmp8_ = (g_free (_tmp8_), NULL);
					vala_code_node_set_error (node_reference, TRUE);
					_tmp11_ = NULL;
					return (_tmp11_ = NULL, (type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL)), (_type_arg_it == NULL) ? NULL : (_type_arg_it = (gee_collection_object_unref (_type_arg_it), NULL)), (instance_base_type == NULL) ? NULL : (instance_base_type = (vala_code_node_unref (instance_base_type), NULL)), _tmp11_);
				}
				_tmp13_ = NULL;
				_tmp12_ = NULL;
				type_arg = (_tmp13_ = (ValaDataType*) gee_list_get (_tmp12_ = vala_data_type_get_type_arguments (instance_type), param_index), (type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL)), _tmp13_);
				(_tmp12_ == NULL) ? NULL : (_tmp12_ = (gee_collection_object_unref (_tmp12_), NULL));
			}
			vala_data_type_add_type_argument ((ValaDataType*) instance_base_type, type_arg);
			(type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL));
		}
		(_type_arg_it == NULL) ? NULL : (_type_arg_it = (gee_collection_object_unref (_type_arg_it), NULL));
	}
	return (ValaDataType*) instance_base_type;
}


static ValaDataType* vala_semantic_analyzer_get_instance_base_type_for_member (ValaDataType* derived_instance_type, ValaTypeSymbol* type_symbol, ValaCodeNode* node_reference) {
	ValaDataType* _tmp0_;
	ValaDataType* instance_type;
	ValaDataType* instance_base_type;
	ValaDataType* _tmp31_;
	g_return_val_if_fail (derived_instance_type != NULL, NULL);
	g_return_val_if_fail (type_symbol != NULL, NULL);
	g_return_val_if_fail (node_reference != NULL, NULL);
	_tmp0_ = NULL;
	instance_type = (_tmp0_ = derived_instance_type, (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
	while (VALA_IS_POINTER_TYPE (instance_type)) {
		ValaPointerType* _tmp1_;
		ValaPointerType* instance_pointer_type;
		ValaDataType* _tmp3_;
		ValaDataType* _tmp2_;
		_tmp1_ = NULL;
		instance_pointer_type = (_tmp1_ = VALA_POINTER_TYPE (instance_type), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
		_tmp3_ = NULL;
		_tmp2_ = NULL;
		instance_type = (_tmp3_ = (_tmp2_ = vala_pointer_type_get_base_type (instance_pointer_type), (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_)), (instance_type == NULL) ? NULL : (instance_type = (vala_code_node_unref (instance_type), NULL)), _tmp3_);
		(instance_pointer_type == NULL) ? NULL : (instance_pointer_type = (vala_code_node_unref (instance_pointer_type), NULL));
	}
	if (vala_data_type_get_data_type (instance_type) == type_symbol) {
		return instance_type;
	}
	instance_base_type = NULL;
	/* use same algorithm as symbol_lookup_inherited*/
	if (VALA_IS_CLASS (vala_data_type_get_data_type (instance_type))) {
		ValaClass* _tmp5_;
		ValaClass* cl;
		_tmp5_ = NULL;
		cl = (_tmp5_ = VALA_CLASS (vala_data_type_get_data_type (instance_type)), (_tmp5_ == NULL) ? NULL : vala_code_node_ref (_tmp5_));
		/* first check interfaces without prerequisites
		 (prerequisites can be assumed to be met already)*/
		{
			GeeList* _tmp6_;
			GeeIterator* _tmp7_;
			GeeIterator* _base_type_it;
			/* first check interfaces without prerequisites
			 (prerequisites can be assumed to be met already)*/
			_tmp6_ = NULL;
			_tmp7_ = NULL;
			_base_type_it = (_tmp7_ = gee_iterable_iterator ((GeeIterable*) (_tmp6_ = vala_class_get_base_types (cl))), (_tmp6_ == NULL) ? NULL : (_tmp6_ = (gee_collection_object_unref (_tmp6_), NULL)), _tmp7_);
			/* first check interfaces without prerequisites
			 (prerequisites can be assumed to be met already)*/
			while (gee_iterator_next (_base_type_it)) {
				ValaDataType* base_type;
				/* first check interfaces without prerequisites
				 (prerequisites can be assumed to be met already)*/
				base_type = (ValaDataType*) gee_iterator_get (_base_type_it);
				if (VALA_IS_INTERFACE (vala_data_type_get_data_type (base_type))) {
					ValaDataType* _tmp9_;
					ValaDataType* _tmp8_;
					_tmp9_ = NULL;
					_tmp8_ = NULL;
					instance_base_type = (_tmp9_ = vala_semantic_analyzer_get_instance_base_type_for_member (_tmp8_ = vala_semantic_analyzer_get_instance_base_type (instance_type, base_type, node_reference), type_symbol, node_reference), (instance_base_type == NULL) ? NULL : (instance_base_type = (vala_code_node_unref (instance_base_type), NULL)), _tmp9_);
					(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_code_node_unref (_tmp8_), NULL));
					if (instance_base_type != NULL) {
						ValaDataType* _tmp10_;
						_tmp10_ = NULL;
						return (_tmp10_ = instance_base_type, (base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)), (_base_type_it == NULL) ? NULL : (_base_type_it = (gee_collection_object_unref (_base_type_it), NULL)), (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), (instance_type == NULL) ? NULL : (instance_type = (vala_code_node_unref (instance_type), NULL)), _tmp10_);
					}
				}
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
			}
			(_base_type_it == NULL) ? NULL : (_base_type_it = (gee_collection_object_unref (_base_type_it), NULL));
		}
		/* then check base class recursively*/
		if (instance_base_type == NULL) {
			{
				GeeList* _tmp11_;
				GeeIterator* _tmp12_;
				GeeIterator* _base_type_it;
				_tmp11_ = NULL;
				_tmp12_ = NULL;
				_base_type_it = (_tmp12_ = gee_iterable_iterator ((GeeIterable*) (_tmp11_ = vala_class_get_base_types (cl))), (_tmp11_ == NULL) ? NULL : (_tmp11_ = (gee_collection_object_unref (_tmp11_), NULL)), _tmp12_);
				while (gee_iterator_next (_base_type_it)) {
					ValaDataType* base_type;
					base_type = (ValaDataType*) gee_iterator_get (_base_type_it);
					if (VALA_IS_CLASS (vala_data_type_get_data_type (base_type))) {
						ValaDataType* _tmp14_;
						ValaDataType* _tmp13_;
						_tmp14_ = NULL;
						_tmp13_ = NULL;
						instance_base_type = (_tmp14_ = vala_semantic_analyzer_get_instance_base_type_for_member (_tmp13_ = vala_semantic_analyzer_get_instance_base_type (instance_type, base_type, node_reference), type_symbol, node_reference), (instance_base_type == NULL) ? NULL : (instance_base_type = (vala_code_node_unref (instance_base_type), NULL)), _tmp14_);
						(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_code_node_unref (_tmp13_), NULL));
						if (instance_base_type != NULL) {
							ValaDataType* _tmp15_;
							_tmp15_ = NULL;
							return (_tmp15_ = instance_base_type, (base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)), (_base_type_it == NULL) ? NULL : (_base_type_it = (gee_collection_object_unref (_base_type_it), NULL)), (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), (instance_type == NULL) ? NULL : (instance_type = (vala_code_node_unref (instance_type), NULL)), _tmp15_);
						}
					}
					(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
				}
				(_base_type_it == NULL) ? NULL : (_base_type_it = (gee_collection_object_unref (_base_type_it), NULL));
			}
		}
		(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	} else {
		if (VALA_IS_STRUCT (vala_data_type_get_data_type (instance_type))) {
			ValaStruct* _tmp16_;
			ValaStruct* st;
			_tmp16_ = NULL;
			st = (_tmp16_ = VALA_STRUCT (vala_data_type_get_data_type (instance_type)), (_tmp16_ == NULL) ? NULL : vala_code_node_ref (_tmp16_));
			if (vala_struct_get_base_type (st) != NULL) {
				ValaDataType* _tmp18_;
				ValaDataType* _tmp17_;
				_tmp18_ = NULL;
				_tmp17_ = NULL;
				instance_base_type = (_tmp18_ = vala_semantic_analyzer_get_instance_base_type_for_member (_tmp17_ = vala_semantic_analyzer_get_instance_base_type (instance_type, vala_struct_get_base_type (st), node_reference), type_symbol, node_reference), (instance_base_type == NULL) ? NULL : (instance_base_type = (vala_code_node_unref (instance_base_type), NULL)), _tmp18_);
				(_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_code_node_unref (_tmp17_), NULL));
				if (instance_base_type != NULL) {
					ValaDataType* _tmp19_;
					_tmp19_ = NULL;
					return (_tmp19_ = instance_base_type, (st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL)), (instance_type == NULL) ? NULL : (instance_type = (vala_code_node_unref (instance_type), NULL)), _tmp19_);
				}
			}
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
		} else {
			if (VALA_IS_INTERFACE (vala_data_type_get_data_type (instance_type))) {
				ValaInterface* _tmp20_;
				ValaInterface* iface;
				_tmp20_ = NULL;
				iface = (_tmp20_ = VALA_INTERFACE (vala_data_type_get_data_type (instance_type)), (_tmp20_ == NULL) ? NULL : vala_code_node_ref (_tmp20_));
				/* first check interface prerequisites recursively*/
				{
					GeeList* _tmp21_;
					GeeIterator* _tmp22_;
					GeeIterator* _prerequisite_it;
					/* first check interface prerequisites recursively*/
					_tmp21_ = NULL;
					_tmp22_ = NULL;
					_prerequisite_it = (_tmp22_ = gee_iterable_iterator ((GeeIterable*) (_tmp21_ = vala_interface_get_prerequisites (iface))), (_tmp21_ == NULL) ? NULL : (_tmp21_ = (gee_collection_object_unref (_tmp21_), NULL)), _tmp22_);
					/* first check interface prerequisites recursively*/
					while (gee_iterator_next (_prerequisite_it)) {
						ValaDataType* prerequisite;
						/* first check interface prerequisites recursively*/
						prerequisite = (ValaDataType*) gee_iterator_get (_prerequisite_it);
						if (VALA_IS_INTERFACE (vala_data_type_get_data_type (prerequisite))) {
							ValaDataType* _tmp24_;
							ValaDataType* _tmp23_;
							_tmp24_ = NULL;
							_tmp23_ = NULL;
							instance_base_type = (_tmp24_ = vala_semantic_analyzer_get_instance_base_type_for_member (_tmp23_ = vala_semantic_analyzer_get_instance_base_type (instance_type, prerequisite, node_reference), type_symbol, node_reference), (instance_base_type == NULL) ? NULL : (instance_base_type = (vala_code_node_unref (instance_base_type), NULL)), _tmp24_);
							(_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_code_node_unref (_tmp23_), NULL));
							if (instance_base_type != NULL) {
								ValaDataType* _tmp25_;
								_tmp25_ = NULL;
								return (_tmp25_ = instance_base_type, (prerequisite == NULL) ? NULL : (prerequisite = (vala_code_node_unref (prerequisite), NULL)), (_prerequisite_it == NULL) ? NULL : (_prerequisite_it = (gee_collection_object_unref (_prerequisite_it), NULL)), (iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL)), (instance_type == NULL) ? NULL : (instance_type = (vala_code_node_unref (instance_type), NULL)), _tmp25_);
							}
						}
						(prerequisite == NULL) ? NULL : (prerequisite = (vala_code_node_unref (prerequisite), NULL));
					}
					(_prerequisite_it == NULL) ? NULL : (_prerequisite_it = (gee_collection_object_unref (_prerequisite_it), NULL));
				}
				if (instance_base_type == NULL) {
					/* then check class prerequisite recursively*/
					{
						GeeList* _tmp26_;
						GeeIterator* _tmp27_;
						GeeIterator* _prerequisite_it;
						/* then check class prerequisite recursively*/
						_tmp26_ = NULL;
						_tmp27_ = NULL;
						_prerequisite_it = (_tmp27_ = gee_iterable_iterator ((GeeIterable*) (_tmp26_ = vala_interface_get_prerequisites (iface))), (_tmp26_ == NULL) ? NULL : (_tmp26_ = (gee_collection_object_unref (_tmp26_), NULL)), _tmp27_);
						/* then check class prerequisite recursively*/
						while (gee_iterator_next (_prerequisite_it)) {
							ValaDataType* prerequisite;
							/* then check class prerequisite recursively*/
							prerequisite = (ValaDataType*) gee_iterator_get (_prerequisite_it);
							if (VALA_IS_CLASS (vala_data_type_get_data_type (prerequisite))) {
								ValaDataType* _tmp29_;
								ValaDataType* _tmp28_;
								_tmp29_ = NULL;
								_tmp28_ = NULL;
								instance_base_type = (_tmp29_ = vala_semantic_analyzer_get_instance_base_type_for_member (_tmp28_ = vala_semantic_analyzer_get_instance_base_type (instance_type, prerequisite, node_reference), type_symbol, node_reference), (instance_base_type == NULL) ? NULL : (instance_base_type = (vala_code_node_unref (instance_base_type), NULL)), _tmp29_);
								(_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_code_node_unref (_tmp28_), NULL));
								if (instance_base_type != NULL) {
									ValaDataType* _tmp30_;
									_tmp30_ = NULL;
									return (_tmp30_ = instance_base_type, (prerequisite == NULL) ? NULL : (prerequisite = (vala_code_node_unref (prerequisite), NULL)), (_prerequisite_it == NULL) ? NULL : (_prerequisite_it = (gee_collection_object_unref (_prerequisite_it), NULL)), (iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL)), (instance_type == NULL) ? NULL : (instance_type = (vala_code_node_unref (instance_type), NULL)), _tmp30_);
								}
							}
							(prerequisite == NULL) ? NULL : (prerequisite = (vala_code_node_unref (prerequisite), NULL));
						}
						(_prerequisite_it == NULL) ? NULL : (_prerequisite_it = (gee_collection_object_unref (_prerequisite_it), NULL));
					}
				}
				(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
			}
		}
	}
	_tmp31_ = NULL;
	return (_tmp31_ = NULL, (instance_type == NULL) ? NULL : (instance_type = (vala_code_node_unref (instance_type), NULL)), (instance_base_type == NULL) ? NULL : (instance_base_type = (vala_code_node_unref (instance_base_type), NULL)), _tmp31_);
}


ValaDataType* vala_semantic_analyzer_get_actual_type (ValaDataType* derived_instance_type, ValaGenericType* generic_type, ValaCodeNode* node_reference) {
	ValaDataType* instance_type;
	gint param_index;
	ValaDataType* actual_type;
	GeeList* _tmp2_;
	gboolean _tmp3_;
	ValaDataType* _tmp8_;
	gboolean _tmp9_;
	ValaDataType* _tmp10_;
	g_return_val_if_fail (derived_instance_type != NULL, NULL);
	g_return_val_if_fail (generic_type != NULL, NULL);
	g_return_val_if_fail (node_reference != NULL, NULL);
	/* trace type arguments back to the datatype where the method has been declared*/
	instance_type = vala_semantic_analyzer_get_instance_base_type_for_member (derived_instance_type, VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_data_type_get_type_parameter ((ValaDataType*) generic_type))), node_reference);
	g_assert (instance_type != NULL);
	param_index = vala_typesymbol_get_type_parameter_index (vala_data_type_get_data_type (instance_type), vala_symbol_get_name ((ValaSymbol*) vala_data_type_get_type_parameter ((ValaDataType*) generic_type)));
	if (param_index == (-1)) {
		char* _tmp0_;
		ValaDataType* _tmp1_;
		_tmp0_ = NULL;
		vala_report_error (vala_code_node_get_source_reference (node_reference), _tmp0_ = g_strdup_printf ("internal error: unknown type parameter %s", vala_symbol_get_name ((ValaSymbol*) vala_data_type_get_type_parameter ((ValaDataType*) generic_type))));
		_tmp0_ = (g_free (_tmp0_), NULL);
		vala_code_node_set_error (node_reference, TRUE);
		_tmp1_ = NULL;
		return (_tmp1_ = NULL, (instance_type == NULL) ? NULL : (instance_type = (vala_code_node_unref (instance_type), NULL)), _tmp1_);
	}
	actual_type = NULL;
	_tmp2_ = NULL;
	if ((_tmp3_ = param_index < gee_collection_get_size ((GeeCollection*) (_tmp2_ = vala_data_type_get_type_arguments (instance_type))), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (gee_collection_object_unref (_tmp2_), NULL)), _tmp3_)) {
		ValaDataType* _tmp5_;
		GeeList* _tmp4_;
		_tmp5_ = NULL;
		_tmp4_ = NULL;
		actual_type = (_tmp5_ = VALA_DATA_TYPE ((ValaDataType*) gee_list_get (_tmp4_ = vala_data_type_get_type_arguments (instance_type), param_index)), (actual_type == NULL) ? NULL : (actual_type = (vala_code_node_unref (actual_type), NULL)), _tmp5_);
		(_tmp4_ == NULL) ? NULL : (_tmp4_ = (gee_collection_object_unref (_tmp4_), NULL));
	}
	if (actual_type == NULL) {
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		/* no actual type available*/
		_tmp6_ = NULL;
		_tmp7_ = NULL;
		return (_tmp7_ = (_tmp6_ = (ValaDataType*) generic_type, (_tmp6_ == NULL) ? NULL : vala_code_node_ref (_tmp6_)), (instance_type == NULL) ? NULL : (instance_type = (vala_code_node_unref (instance_type), NULL)), (actual_type == NULL) ? NULL : (actual_type = (vala_code_node_unref (actual_type), NULL)), _tmp7_);
	}
	_tmp8_ = NULL;
	actual_type = (_tmp8_ = vala_data_type_copy (actual_type), (actual_type == NULL) ? NULL : (actual_type = (vala_code_node_unref (actual_type), NULL)), _tmp8_);
	_tmp9_ = FALSE;
	if (vala_data_type_get_value_owned (actual_type)) {
		_tmp9_ = vala_data_type_get_value_owned ((ValaDataType*) generic_type);
	} else {
		_tmp9_ = FALSE;
	}
	vala_data_type_set_value_owned (actual_type, _tmp9_);
	_tmp10_ = NULL;
	return (_tmp10_ = actual_type, (instance_type == NULL) ? NULL : (instance_type = (vala_code_node_unref (instance_type), NULL)), _tmp10_);
}


gboolean vala_semantic_analyzer_is_in_instance_method (ValaSemanticAnalyzer* self) {
	ValaSymbol* _tmp0_;
	ValaSymbol* sym;
	gboolean _tmp10_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = NULL;
	sym = (_tmp0_ = self->priv->_current_symbol, (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
	while (sym != NULL) {
		ValaSymbol* _tmp9_;
		ValaSymbol* _tmp8_;
		if (VALA_IS_CREATION_METHOD (sym)) {
			gboolean _tmp1_;
			return (_tmp1_ = TRUE, (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp1_);
		} else {
			if (VALA_IS_METHOD (sym)) {
				ValaMethod* _tmp2_;
				ValaMethod* m;
				gboolean _tmp3_;
				_tmp2_ = NULL;
				m = (_tmp2_ = VALA_METHOD (sym), (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_));
				return (_tmp3_ = vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE, (m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL)), (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp3_);
			} else {
				if (VALA_IS_CONSTRUCTOR (sym)) {
					ValaConstructor* _tmp4_;
					ValaConstructor* c;
					gboolean _tmp5_;
					_tmp4_ = NULL;
					c = (_tmp4_ = VALA_CONSTRUCTOR (sym), (_tmp4_ == NULL) ? NULL : vala_code_node_ref (_tmp4_));
					return (_tmp5_ = vala_constructor_get_binding (c) == MEMBER_BINDING_INSTANCE, (c == NULL) ? NULL : (c = (vala_code_node_unref (c), NULL)), (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp5_);
				} else {
					if (VALA_IS_DESTRUCTOR (sym)) {
						gboolean _tmp6_;
						return (_tmp6_ = TRUE, (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp6_);
					} else {
						if (VALA_IS_PROPERTY (sym)) {
							gboolean _tmp7_;
							return (_tmp7_ = TRUE, (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp7_);
						}
					}
				}
			}
		}
		_tmp9_ = NULL;
		_tmp8_ = NULL;
		sym = (_tmp9_ = (_tmp8_ = vala_symbol_get_parent_symbol (sym), (_tmp8_ == NULL) ? NULL : vala_code_node_ref (_tmp8_)), (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp9_);
	}
	return (_tmp10_ = FALSE, (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp10_);
}


void vala_semantic_analyzer_visit_member_initializer (ValaSemanticAnalyzer* self, ValaMemberInitializer* init, ValaDataType* type) {
	ValaSymbol* _tmp0_;
	gboolean _tmp1_;
	ValaDataType* member_type;
	gboolean _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (init != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = NULL;
	vala_member_initializer_set_symbol_reference (init, _tmp0_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) vala_data_type_get_data_type (type), vala_member_initializer_get_name (init)));
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_code_node_unref (_tmp0_), NULL));
	_tmp1_ = FALSE;
	if (VALA_IS_FIELD (vala_member_initializer_get_symbol_reference (init))) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = VALA_IS_PROPERTY (vala_member_initializer_get_symbol_reference (init));
	}
	if (!_tmp1_) {
		char* _tmp3_;
		char* _tmp2_;
		vala_code_node_set_error ((ValaCodeNode*) init, TRUE);
		_tmp3_ = NULL;
		_tmp2_ = NULL;
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) init), _tmp3_ = g_strdup_printf ("Invalid member `%s' in `%s'", vala_member_initializer_get_name (init), _tmp2_ = vala_symbol_get_full_name ((ValaSymbol*) vala_data_type_get_data_type (type))));
		_tmp3_ = (g_free (_tmp3_), NULL);
		_tmp2_ = (g_free (_tmp2_), NULL);
		return;
	}
	if (vala_symbol_get_access (vala_member_initializer_get_symbol_reference (init)) != VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
		char* _tmp5_;
		char* _tmp4_;
		vala_code_node_set_error ((ValaCodeNode*) init, TRUE);
		_tmp5_ = NULL;
		_tmp4_ = NULL;
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) init), _tmp5_ = g_strdup_printf ("Access to private member `%s' denied", _tmp4_ = vala_symbol_get_full_name (vala_member_initializer_get_symbol_reference (init))));
		_tmp5_ = (g_free (_tmp5_), NULL);
		_tmp4_ = (g_free (_tmp4_), NULL);
		return;
	}
	member_type = NULL;
	if (VALA_IS_FIELD (vala_member_initializer_get_symbol_reference (init))) {
		ValaField* _tmp6_;
		ValaField* f;
		ValaDataType* _tmp8_;
		ValaDataType* _tmp7_;
		_tmp6_ = NULL;
		f = (_tmp6_ = VALA_FIELD (vala_member_initializer_get_symbol_reference (init)), (_tmp6_ == NULL) ? NULL : vala_code_node_ref (_tmp6_));
		_tmp8_ = NULL;
		_tmp7_ = NULL;
		member_type = (_tmp8_ = (_tmp7_ = vala_field_get_field_type (f), (_tmp7_ == NULL) ? NULL : vala_code_node_ref (_tmp7_)), (member_type == NULL) ? NULL : (member_type = (vala_code_node_unref (member_type), NULL)), _tmp8_);
		(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
	} else {
		if (VALA_IS_PROPERTY (vala_member_initializer_get_symbol_reference (init))) {
			ValaProperty* _tmp9_;
			ValaProperty* prop;
			ValaDataType* _tmp11_;
			ValaDataType* _tmp10_;
			gboolean _tmp12_;
			_tmp9_ = NULL;
			prop = (_tmp9_ = VALA_PROPERTY (vala_member_initializer_get_symbol_reference (init)), (_tmp9_ == NULL) ? NULL : vala_code_node_ref (_tmp9_));
			_tmp11_ = NULL;
			_tmp10_ = NULL;
			member_type = (_tmp11_ = (_tmp10_ = vala_property_get_property_type (prop), (_tmp10_ == NULL) ? NULL : vala_code_node_ref (_tmp10_)), (member_type == NULL) ? NULL : (member_type = (vala_code_node_unref (member_type), NULL)), _tmp11_);
			_tmp12_ = FALSE;
			if (vala_property_get_set_accessor (prop) == NULL) {
				_tmp12_ = TRUE;
			} else {
				_tmp12_ = !vala_property_accessor_get_writable (vala_property_get_set_accessor (prop));
			}
			if (_tmp12_) {
				char* _tmp14_;
				char* _tmp13_;
				vala_code_node_set_error ((ValaCodeNode*) init, TRUE);
				_tmp14_ = NULL;
				_tmp13_ = NULL;
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) init), _tmp14_ = g_strdup_printf ("Property `%s' is read-only", _tmp13_ = vala_symbol_get_full_name ((ValaSymbol*) prop)));
				_tmp14_ = (g_free (_tmp14_), NULL);
				_tmp13_ = (g_free (_tmp13_), NULL);
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				(member_type == NULL) ? NULL : (member_type = (vala_code_node_unref (member_type), NULL));
				return;
			}
			(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
		}
	}
	vala_expression_set_target_type (vala_member_initializer_get_initializer (init), member_type);
	vala_code_node_check ((ValaCodeNode*) init, self);
	_tmp15_ = FALSE;
	if (vala_expression_get_value_type (vala_member_initializer_get_initializer (init)) == NULL) {
		_tmp15_ = TRUE;
	} else {
		_tmp15_ = !vala_data_type_compatible (vala_expression_get_value_type (vala_member_initializer_get_initializer (init)), vala_expression_get_target_type (vala_member_initializer_get_initializer (init)));
	}
	if (_tmp15_) {
		char* _tmp16_;
		vala_code_node_set_error ((ValaCodeNode*) init, TRUE);
		_tmp16_ = NULL;
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) init), _tmp16_ = g_strdup_printf ("Invalid type for member `%s'", vala_member_initializer_get_name (init)));
		_tmp16_ = (g_free (_tmp16_), NULL);
		(member_type == NULL) ? NULL : (member_type = (vala_code_node_unref (member_type), NULL));
		return;
	}
	(member_type == NULL) ? NULL : (member_type = (vala_code_node_unref (member_type), NULL));
}


ValaDataType* vala_semantic_analyzer_get_arithmetic_result_type (ValaSemanticAnalyzer* self, ValaDataType* left_type, ValaDataType* right_type) {
	gboolean _tmp0_;
	ValaStruct* _tmp2_;
	ValaStruct* left;
	ValaStruct* _tmp3_;
	ValaStruct* right;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (left_type != NULL, NULL);
	g_return_val_if_fail (right_type != NULL, NULL);
	_tmp0_ = FALSE;
	if (!VALA_IS_STRUCT (vala_data_type_get_data_type (left_type))) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !VALA_IS_STRUCT (vala_data_type_get_data_type (right_type));
	}
	if (_tmp0_) {
		/* at least one operand not struct*/
		return NULL;
	}
	_tmp2_ = NULL;
	left = (_tmp2_ = VALA_STRUCT (vala_data_type_get_data_type (left_type)), (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_));
	_tmp3_ = NULL;
	right = (_tmp3_ = VALA_STRUCT (vala_data_type_get_data_type (right_type)), (_tmp3_ == NULL) ? NULL : vala_code_node_ref (_tmp3_));
	_tmp4_ = FALSE;
	_tmp5_ = FALSE;
	if (!vala_struct_is_floating_type (left)) {
		_tmp5_ = !vala_struct_is_integer_type (left);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		gboolean _tmp6_;
		_tmp6_ = FALSE;
		if (!vala_struct_is_floating_type (right)) {
			_tmp6_ = !vala_struct_is_integer_type (right);
		} else {
			_tmp6_ = FALSE;
		}
		_tmp4_ = _tmp6_;
	}
	if (_tmp4_) {
		ValaDataType* _tmp7_;
		/* at least one operand not numeric*/
		_tmp7_ = NULL;
		return (_tmp7_ = NULL, (left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL)), (right == NULL) ? NULL : (right = (vala_code_node_unref (right), NULL)), _tmp7_);
	}
	if (vala_struct_is_floating_type (left) == vala_struct_is_floating_type (right)) {
		/* both operands integer or floating type*/
		if (vala_struct_get_rank (left) >= vala_struct_get_rank (right)) {
			ValaDataType* _tmp8_;
			ValaDataType* _tmp9_;
			_tmp8_ = NULL;
			_tmp9_ = NULL;
			return (_tmp9_ = (_tmp8_ = left_type, (_tmp8_ == NULL) ? NULL : vala_code_node_ref (_tmp8_)), (left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL)), (right == NULL) ? NULL : (right = (vala_code_node_unref (right), NULL)), _tmp9_);
		} else {
			ValaDataType* _tmp10_;
			ValaDataType* _tmp11_;
			_tmp10_ = NULL;
			_tmp11_ = NULL;
			return (_tmp11_ = (_tmp10_ = right_type, (_tmp10_ == NULL) ? NULL : vala_code_node_ref (_tmp10_)), (left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL)), (right == NULL) ? NULL : (right = (vala_code_node_unref (right), NULL)), _tmp11_);
		}
	} else {
		/* one integer and one floating type operand*/
		if (vala_struct_is_floating_type (left)) {
			ValaDataType* _tmp12_;
			ValaDataType* _tmp13_;
			_tmp12_ = NULL;
			_tmp13_ = NULL;
			return (_tmp13_ = (_tmp12_ = left_type, (_tmp12_ == NULL) ? NULL : vala_code_node_ref (_tmp12_)), (left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL)), (right == NULL) ? NULL : (right = (vala_code_node_unref (right), NULL)), _tmp13_);
		} else {
			ValaDataType* _tmp14_;
			ValaDataType* _tmp15_;
			_tmp14_ = NULL;
			_tmp15_ = NULL;
			return (_tmp15_ = (_tmp14_ = right_type, (_tmp14_ == NULL) ? NULL : vala_code_node_ref (_tmp14_)), (left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL)), (right == NULL) ? NULL : (right = (vala_code_node_unref (right), NULL)), _tmp15_);
		}
	}
	(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
	(right == NULL) ? NULL : (right = (vala_code_node_unref (right), NULL));
}


ValaMethod* vala_semantic_analyzer_find_current_method (ValaSemanticAnalyzer* self) {
	ValaSymbol* _tmp0_;
	ValaSymbol* sym;
	ValaMethod* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = NULL;
	sym = (_tmp0_ = self->priv->_current_symbol, (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
	while (sym != NULL) {
		ValaSymbol* _tmp4_;
		ValaSymbol* _tmp3_;
		if (VALA_IS_METHOD (sym)) {
			ValaMethod* _tmp1_;
			ValaMethod* _tmp2_;
			_tmp1_ = NULL;
			_tmp2_ = NULL;
			return (_tmp2_ = (_tmp1_ = VALA_METHOD (sym), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_)), (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp2_);
		}
		_tmp4_ = NULL;
		_tmp3_ = NULL;
		sym = (_tmp4_ = (_tmp3_ = vala_symbol_get_parent_symbol (sym), (_tmp3_ == NULL) ? NULL : vala_code_node_ref (_tmp3_)), (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp4_);
	}
	_tmp5_ = NULL;
	return (_tmp5_ = NULL, (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp5_);
}


gboolean vala_semantic_analyzer_is_in_constructor (ValaSemanticAnalyzer* self) {
	ValaSymbol* _tmp0_;
	ValaSymbol* sym;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = NULL;
	sym = (_tmp0_ = self->priv->_current_symbol, (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
	while (sym != NULL) {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp2_;
		if (VALA_IS_CONSTRUCTOR (sym)) {
			gboolean _tmp1_;
			return (_tmp1_ = TRUE, (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp1_);
		}
		_tmp3_ = NULL;
		_tmp2_ = NULL;
		sym = (_tmp3_ = (_tmp2_ = vala_symbol_get_parent_symbol (sym), (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_)), (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp3_);
	}
	return (_tmp4_ = FALSE, (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp4_);
}


ValaCodeContext* vala_semantic_analyzer_get_context (ValaSemanticAnalyzer* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_context;
}


void vala_semantic_analyzer_set_context (ValaSemanticAnalyzer* self, ValaCodeContext* value) {
	ValaCodeContext* _tmp2_;
	ValaCodeContext* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp2_ = NULL;
	_tmp1_ = NULL;
	self->priv->_context = (_tmp2_ = (_tmp1_ = value, (_tmp1_ == NULL) ? NULL : vala_code_context_ref (_tmp1_)), (self->priv->_context == NULL) ? NULL : (self->priv->_context = (vala_code_context_unref (self->priv->_context), NULL)), _tmp2_);
}


ValaSymbol* vala_semantic_analyzer_get_current_symbol (ValaSemanticAnalyzer* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_current_symbol;
}


void vala_semantic_analyzer_set_current_symbol (ValaSemanticAnalyzer* self, ValaSymbol* value) {
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp2_ = NULL;
	_tmp1_ = NULL;
	self->priv->_current_symbol = (_tmp2_ = (_tmp1_ = value, (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_)), (self->priv->_current_symbol == NULL) ? NULL : (self->priv->_current_symbol = (vala_code_node_unref (self->priv->_current_symbol), NULL)), _tmp2_);
}


ValaSourceFile* vala_semantic_analyzer_get_current_source_file (ValaSemanticAnalyzer* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_current_source_file;
}


void vala_semantic_analyzer_set_current_source_file (ValaSemanticAnalyzer* self, ValaSourceFile* value) {
	ValaSourceFile* _tmp2_;
	ValaSourceFile* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp2_ = NULL;
	_tmp1_ = NULL;
	self->priv->_current_source_file = (_tmp2_ = (_tmp1_ = value, (_tmp1_ == NULL) ? NULL : vala_source_file_ref (_tmp1_)), (self->priv->_current_source_file == NULL) ? NULL : (self->priv->_current_source_file = (vala_source_file_unref (self->priv->_current_source_file), NULL)), _tmp2_);
}


static void vala_semantic_analyzer_class_init (ValaSemanticAnalyzerClass * klass) {
	vala_semantic_analyzer_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_VISITOR_CLASS (klass)->finalize = vala_semantic_analyzer_finalize;
	g_type_class_add_private (klass, sizeof (ValaSemanticAnalyzerPrivate));
	VALA_CODE_VISITOR_CLASS (klass)->visit_source_file = vala_semantic_analyzer_real_visit_source_file;
}


static void vala_semantic_analyzer_instance_init (ValaSemanticAnalyzer * self) {
	self->priv = VALA_SEMANTIC_ANALYZER_GET_PRIVATE (self);
	self->next_lambda_id = 0;
	self->replaced_nodes = (GeeList*) gee_array_list_new (VALA_TYPE_CODE_NODE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
}


static void vala_semantic_analyzer_finalize (ValaCodeVisitor* obj) {
	ValaSemanticAnalyzer * self;
	self = VALA_SEMANTIC_ANALYZER (obj);
	(self->priv->_context == NULL) ? NULL : (self->priv->_context = (vala_code_context_unref (self->priv->_context), NULL));
	(self->root_symbol == NULL) ? NULL : (self->root_symbol = (vala_code_node_unref (self->root_symbol), NULL));
	(self->priv->_current_symbol == NULL) ? NULL : (self->priv->_current_symbol = (vala_code_node_unref (self->priv->_current_symbol), NULL));
	(self->priv->_current_source_file == NULL) ? NULL : (self->priv->_current_source_file = (vala_source_file_unref (self->priv->_current_source_file), NULL));
	(self->current_return_type == NULL) ? NULL : (self->current_return_type = (vala_code_node_unref (self->current_return_type), NULL));
	(self->current_class == NULL) ? NULL : (self->current_class = (vala_code_node_unref (self->current_class), NULL));
	(self->current_struct == NULL) ? NULL : (self->current_struct = (vala_code_node_unref (self->current_struct), NULL));
	(self->insert_block == NULL) ? NULL : (self->insert_block = (vala_code_node_unref (self->insert_block), NULL));
	(self->bool_type == NULL) ? NULL : (self->bool_type = (vala_code_node_unref (self->bool_type), NULL));
	(self->string_type == NULL) ? NULL : (self->string_type = (vala_code_node_unref (self->string_type), NULL));
	(self->uchar_type == NULL) ? NULL : (self->uchar_type = (vala_code_node_unref (self->uchar_type), NULL));
	(self->short_type == NULL) ? NULL : (self->short_type = (vala_code_node_unref (self->short_type), NULL));
	(self->ushort_type == NULL) ? NULL : (self->ushort_type = (vala_code_node_unref (self->ushort_type), NULL));
	(self->int_type == NULL) ? NULL : (self->int_type = (vala_code_node_unref (self->int_type), NULL));
	(self->uint_type == NULL) ? NULL : (self->uint_type = (vala_code_node_unref (self->uint_type), NULL));
	(self->long_type == NULL) ? NULL : (self->long_type = (vala_code_node_unref (self->long_type), NULL));
	(self->ulong_type == NULL) ? NULL : (self->ulong_type = (vala_code_node_unref (self->ulong_type), NULL));
	(self->size_t_type == NULL) ? NULL : (self->size_t_type = (vala_code_node_unref (self->size_t_type), NULL));
	(self->ssize_t_type == NULL) ? NULL : (self->ssize_t_type = (vala_code_node_unref (self->ssize_t_type), NULL));
	(self->uint64_type == NULL) ? NULL : (self->uint64_type = (vala_code_node_unref (self->uint64_type), NULL));
	(self->int8_type == NULL) ? NULL : (self->int8_type = (vala_code_node_unref (self->int8_type), NULL));
	(self->unichar_type == NULL) ? NULL : (self->unichar_type = (vala_code_node_unref (self->unichar_type), NULL));
	(self->double_type == NULL) ? NULL : (self->double_type = (vala_code_node_unref (self->double_type), NULL));
	(self->type_type == NULL) ? NULL : (self->type_type = (vala_code_node_unref (self->type_type), NULL));
	(self->object_type == NULL) ? NULL : (self->object_type = (vala_code_node_unref (self->object_type), NULL));
	(self->glist_type == NULL) ? NULL : (self->glist_type = (vala_code_node_unref (self->glist_type), NULL));
	(self->gslist_type == NULL) ? NULL : (self->gslist_type = (vala_code_node_unref (self->gslist_type), NULL));
	(self->garray_type == NULL) ? NULL : (self->garray_type = (vala_code_node_unref (self->garray_type), NULL));
	(self->gerror_type == NULL) ? NULL : (self->gerror_type = (vala_code_node_unref (self->gerror_type), NULL));
	(self->replaced_nodes == NULL) ? NULL : (self->replaced_nodes = (gee_collection_object_unref (self->replaced_nodes), NULL));
	VALA_CODE_VISITOR_CLASS (vala_semantic_analyzer_parent_class)->finalize (obj);
}


GType vala_semantic_analyzer_get_type (void) {
	static GType vala_semantic_analyzer_type_id = 0;
	if (vala_semantic_analyzer_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaSemanticAnalyzerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_semantic_analyzer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSemanticAnalyzer), 0, (GInstanceInitFunc) vala_semantic_analyzer_instance_init, NULL };
		vala_semantic_analyzer_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaSemanticAnalyzer", &g_define_type_info, 0);
	}
	return vala_semantic_analyzer_type_id;
}




