/* valaccodearraymodule.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valaccode.h>
#include <gee.h>
#include <float.h>
#include <math.h>


#define VALA_TYPE_CCODE_MODULE (vala_ccode_module_get_type ())
#define VALA_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModule))
#define VALA_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))
#define VALA_IS_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MODULE))
#define VALA_IS_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MODULE))
#define VALA_CCODE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))

typedef struct _ValaCCodeModule ValaCCodeModule;
typedef struct _ValaCCodeModuleClass ValaCCodeModuleClass;
typedef struct _ValaCCodeModulePrivate ValaCCodeModulePrivate;

#define VALA_TYPE_CCODE_BASE_MODULE (vala_ccode_base_module_get_type ())
#define VALA_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModule))
#define VALA_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))
#define VALA_IS_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_IS_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_CCODE_BASE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))

typedef struct _ValaCCodeBaseModule ValaCCodeBaseModule;
typedef struct _ValaCCodeBaseModuleClass ValaCCodeBaseModuleClass;
typedef struct _ValaCCodeBaseModulePrivate ValaCCodeBaseModulePrivate;

#define VALA_TYPE_CCODE_DECLARATION_SPACE (vala_ccode_declaration_space_get_type ())
#define VALA_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpace))
#define VALA_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))
#define VALA_IS_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_IS_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_CCODE_DECLARATION_SPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))

typedef struct _ValaCCodeDeclarationSpace ValaCCodeDeclarationSpace;
typedef struct _ValaCCodeDeclarationSpaceClass ValaCCodeDeclarationSpaceClass;

#define VALA_TYPE_CCODE_STRUCT_MODULE (vala_ccode_struct_module_get_type ())
#define VALA_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModule))
#define VALA_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))
#define VALA_IS_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_IS_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_CCODE_STRUCT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))

typedef struct _ValaCCodeStructModule ValaCCodeStructModule;
typedef struct _ValaCCodeStructModuleClass ValaCCodeStructModuleClass;
typedef struct _ValaCCodeStructModulePrivate ValaCCodeStructModulePrivate;

#define VALA_TYPE_CCODE_METHOD_MODULE (vala_ccode_method_module_get_type ())
#define VALA_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModule))
#define VALA_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))
#define VALA_IS_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_IS_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_CCODE_METHOD_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))

typedef struct _ValaCCodeMethodModule ValaCCodeMethodModule;
typedef struct _ValaCCodeMethodModuleClass ValaCCodeMethodModuleClass;
typedef struct _ValaCCodeMethodModulePrivate ValaCCodeMethodModulePrivate;

#define VALA_TYPE_CCODE_CONTROL_FLOW_MODULE (vala_ccode_control_flow_module_get_type ())
#define VALA_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModule))
#define VALA_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_CCODE_CONTROL_FLOW_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))

typedef struct _ValaCCodeControlFlowModule ValaCCodeControlFlowModule;
typedef struct _ValaCCodeControlFlowModuleClass ValaCCodeControlFlowModuleClass;
typedef struct _ValaCCodeControlFlowModulePrivate ValaCCodeControlFlowModulePrivate;

#define VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE (vala_ccode_member_access_module_get_type ())
#define VALA_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModule))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))

typedef struct _ValaCCodeMemberAccessModule ValaCCodeMemberAccessModule;
typedef struct _ValaCCodeMemberAccessModuleClass ValaCCodeMemberAccessModuleClass;
typedef struct _ValaCCodeMemberAccessModulePrivate ValaCCodeMemberAccessModulePrivate;

#define VALA_TYPE_CCODE_ASSIGNMENT_MODULE (vala_ccode_assignment_module_get_type ())
#define VALA_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModule))
#define VALA_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_CCODE_ASSIGNMENT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))

typedef struct _ValaCCodeAssignmentModule ValaCCodeAssignmentModule;
typedef struct _ValaCCodeAssignmentModuleClass ValaCCodeAssignmentModuleClass;
typedef struct _ValaCCodeAssignmentModulePrivate ValaCCodeAssignmentModulePrivate;

#define VALA_TYPE_CCODE_METHOD_CALL_MODULE (vala_ccode_method_call_module_get_type ())
#define VALA_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModule))
#define VALA_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))
#define VALA_IS_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_IS_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_CCODE_METHOD_CALL_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))

typedef struct _ValaCCodeMethodCallModule ValaCCodeMethodCallModule;
typedef struct _ValaCCodeMethodCallModuleClass ValaCCodeMethodCallModuleClass;
typedef struct _ValaCCodeMethodCallModulePrivate ValaCCodeMethodCallModulePrivate;

#define VALA_TYPE_CCODE_ARRAY_MODULE (vala_ccode_array_module_get_type ())
#define VALA_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModule))
#define VALA_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))
#define VALA_IS_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_IS_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_CCODE_ARRAY_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))

typedef struct _ValaCCodeArrayModule ValaCCodeArrayModule;
typedef struct _ValaCCodeArrayModuleClass ValaCCodeArrayModuleClass;
typedef struct _ValaCCodeArrayModulePrivate ValaCCodeArrayModulePrivate;

#define VALA_TYPE_CCODE_GENERATOR (vala_ccode_generator_get_type ())
#define VALA_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGenerator))
#define VALA_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))
#define VALA_IS_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_GENERATOR))
#define VALA_IS_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_GENERATOR))
#define VALA_CCODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))

typedef struct _ValaCCodeGenerator ValaCCodeGenerator;
typedef struct _ValaCCodeGeneratorClass ValaCCodeGeneratorClass;

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeModule {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeModulePrivate * priv;
};

struct _ValaCCodeModuleClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeModule *self);
	void (*emit) (ValaCCodeModule* self, ValaCodeContext* context);
	void (*visit_source_file) (ValaCCodeModule* self, ValaSourceFile* source_file);
	void (*visit_class) (ValaCCodeModule* self, ValaClass* cl);
	void (*visit_interface) (ValaCCodeModule* self, ValaInterface* iface);
	void (*visit_struct) (ValaCCodeModule* self, ValaStruct* st);
	void (*visit_enum) (ValaCCodeModule* self, ValaEnum* en);
	void (*visit_error_domain) (ValaCCodeModule* self, ValaErrorDomain* edomain);
	void (*visit_delegate) (ValaCCodeModule* self, ValaDelegate* d);
	void (*visit_member) (ValaCCodeModule* self, ValaMember* m);
	void (*visit_constant) (ValaCCodeModule* self, ValaConstant* c);
	void (*visit_field) (ValaCCodeModule* self, ValaField* f);
	void (*visit_method) (ValaCCodeModule* self, ValaMethod* m);
	void (*visit_creation_method) (ValaCCodeModule* self, ValaCreationMethod* m);
	void (*visit_formal_parameter) (ValaCCodeModule* self, ValaFormalParameter* p);
	void (*visit_property) (ValaCCodeModule* self, ValaProperty* prop);
	void (*visit_property_accessor) (ValaCCodeModule* self, ValaPropertyAccessor* acc);
	void (*visit_signal) (ValaCCodeModule* self, ValaSignal* sig);
	void (*visit_constructor) (ValaCCodeModule* self, ValaConstructor* c);
	void (*visit_destructor) (ValaCCodeModule* self, ValaDestructor* d);
	void (*visit_block) (ValaCCodeModule* self, ValaBlock* b);
	void (*visit_empty_statement) (ValaCCodeModule* self, ValaEmptyStatement* stmt);
	void (*visit_declaration_statement) (ValaCCodeModule* self, ValaDeclarationStatement* stmt);
	void (*visit_local_variable) (ValaCCodeModule* self, ValaLocalVariable* local);
	void (*visit_initializer_list) (ValaCCodeModule* self, ValaInitializerList* list);
	void (*visit_end_full_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_expression_statement) (ValaCCodeModule* self, ValaExpressionStatement* stmt);
	void (*visit_if_statement) (ValaCCodeModule* self, ValaIfStatement* stmt);
	void (*visit_switch_statement) (ValaCCodeModule* self, ValaSwitchStatement* stmt);
	void (*visit_switch_section) (ValaCCodeModule* self, ValaSwitchSection* section);
	void (*visit_switch_label) (ValaCCodeModule* self, ValaSwitchLabel* label);
	void (*visit_loop) (ValaCCodeModule* self, ValaLoop* stmt);
	void (*visit_foreach_statement) (ValaCCodeModule* self, ValaForeachStatement* stmt);
	void (*visit_break_statement) (ValaCCodeModule* self, ValaBreakStatement* stmt);
	void (*visit_continue_statement) (ValaCCodeModule* self, ValaContinueStatement* stmt);
	void (*visit_return_statement) (ValaCCodeModule* self, ValaReturnStatement* stmt);
	void (*visit_yield_statement) (ValaCCodeModule* self, ValaYieldStatement* stmt);
	void (*visit_throw_statement) (ValaCCodeModule* self, ValaThrowStatement* stmt);
	void (*visit_try_statement) (ValaCCodeModule* self, ValaTryStatement* stmt);
	void (*visit_catch_clause) (ValaCCodeModule* self, ValaCatchClause* clause);
	void (*visit_lock_statement) (ValaCCodeModule* self, ValaLockStatement* stmt);
	void (*visit_delete_statement) (ValaCCodeModule* self, ValaDeleteStatement* stmt);
	void (*visit_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_array_creation_expression) (ValaCCodeModule* self, ValaArrayCreationExpression* expr);
	void (*visit_boolean_literal) (ValaCCodeModule* self, ValaBooleanLiteral* expr);
	void (*visit_character_literal) (ValaCCodeModule* self, ValaCharacterLiteral* expr);
	void (*visit_integer_literal) (ValaCCodeModule* self, ValaIntegerLiteral* expr);
	void (*visit_real_literal) (ValaCCodeModule* self, ValaRealLiteral* expr);
	void (*visit_string_literal) (ValaCCodeModule* self, ValaStringLiteral* expr);
	void (*visit_null_literal) (ValaCCodeModule* self, ValaNullLiteral* expr);
	void (*visit_member_access) (ValaCCodeModule* self, ValaMemberAccess* expr);
	void (*visit_method_call) (ValaCCodeModule* self, ValaMethodCall* expr);
	void (*visit_element_access) (ValaCCodeModule* self, ValaElementAccess* expr);
	void (*visit_base_access) (ValaCCodeModule* self, ValaBaseAccess* expr);
	void (*visit_postfix_expression) (ValaCCodeModule* self, ValaPostfixExpression* expr);
	void (*visit_object_creation_expression) (ValaCCodeModule* self, ValaObjectCreationExpression* expr);
	void (*visit_sizeof_expression) (ValaCCodeModule* self, ValaSizeofExpression* expr);
	void (*visit_typeof_expression) (ValaCCodeModule* self, ValaTypeofExpression* expr);
	void (*visit_unary_expression) (ValaCCodeModule* self, ValaUnaryExpression* expr);
	void (*visit_cast_expression) (ValaCCodeModule* self, ValaCastExpression* expr);
	void (*visit_pointer_indirection) (ValaCCodeModule* self, ValaPointerIndirection* expr);
	void (*visit_addressof_expression) (ValaCCodeModule* self, ValaAddressofExpression* expr);
	void (*visit_reference_transfer_expression) (ValaCCodeModule* self, ValaReferenceTransferExpression* expr);
	void (*visit_binary_expression) (ValaCCodeModule* self, ValaBinaryExpression* expr);
	void (*visit_type_check) (ValaCCodeModule* self, ValaTypeCheck* expr);
	void (*visit_lambda_expression) (ValaCCodeModule* self, ValaLambdaExpression* l);
	void (*visit_assignment) (ValaCCodeModule* self, ValaAssignment* a);
	char* (*get_custom_creturn_type) (ValaCCodeModule* self, ValaMethod* m);
	void (*generate_dynamic_method_wrapper) (ValaCCodeModule* self, ValaDynamicMethod* method);
	gboolean (*method_has_wrapper) (ValaCCodeModule* self, ValaMethod* method);
	ValaCCodeIdentifier* (*get_value_setter_function) (ValaCCodeModule* self, ValaDataType* type_reference);
	ValaCCodeExpression* (*get_construct_property_assignment) (ValaCCodeModule* self, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value);
	ValaCCodeFunctionCall* (*get_param_spec) (ValaCCodeModule* self, ValaProperty* prop);
	ValaCCodeFunctionCall* (*get_signal_creation) (ValaCCodeModule* self, ValaSignal* sig, ValaTypeSymbol* type);
	ValaCCodeFragment* (*register_dbus_info) (ValaCCodeModule* self, ValaObjectTypeSymbol* bindable);
	char* (*get_dynamic_property_getter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_property_setter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_signal_cname) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_connect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_disconnect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	void (*generate_marshaller) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, gboolean dbus);
	char* (*get_marshaller_function) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, const char* prefix, gboolean dbus);
	char* (*get_array_length_cname) (ValaCCodeModule* self, const char* array_cname, gint dim);
	ValaCCodeExpression* (*get_array_length_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
	char* (*get_array_size_cname) (ValaCCodeModule* self, const char* array_cname);
	ValaCCodeExpression* (*get_array_size_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr);
	void (*add_simple_check) (ValaCCodeModule* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
};

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeBaseModule {
	ValaCCodeModule parent_instance;
	ValaCCodeBaseModulePrivate * priv;
	ValaSymbol* root_symbol;
	ValaSymbol* current_symbol;
	ValaTypeSymbol* current_type_symbol;
	ValaClass* current_class;
	ValaMethod* current_method;
	ValaDataType* current_return_type;
	ValaTryStatement* current_try;
	ValaPropertyAccessor* current_property_accessor;
	ValaCCodeDeclarationSpace* header_declarations;
	ValaCCodeDeclarationSpace* internal_header_declarations;
	ValaCCodeDeclarationSpace* source_declarations;
	ValaCCodeFragment* source_signal_marshaller_declaration;
	ValaCCodeFragment* source_type_member_definition;
	ValaCCodeFragment* class_init_fragment;
	ValaCCodeFragment* base_init_fragment;
	ValaCCodeFragment* class_finalize_fragment;
	ValaCCodeFragment* base_finalize_fragment;
	ValaCCodeFragment* instance_init_fragment;
	ValaCCodeFragment* instance_finalize_fragment;
	ValaCCodeFragment* source_signal_marshaller_definition;
	ValaCCodeFragment* module_init_fragment;
	ValaCCodeStruct* param_spec_struct;
	ValaCCodeStruct* closure_struct;
	ValaCCodeEnum* prop_enum;
	ValaCCodeFunction* function;
	ValaCCodeFragment* pre_statement_fragment;
	GeeArrayList* temp_vars;
	GeeArrayList* temp_ref_vars;
	GeeSet* user_marshal_set;
	GeeSet* predefined_marshal_set;
	gint next_temp_var_id;
	gboolean in_creation_method;
	gboolean in_constructor;
	gboolean in_static_or_class_ctor;
	gboolean current_method_inner_error;
	gint next_coroutine_state;
	ValaDataType* bool_type;
	ValaDataType* char_type;
	ValaDataType* uchar_type;
	ValaDataType* unichar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* int8_type;
	ValaDataType* uint8_type;
	ValaDataType* int16_type;
	ValaDataType* uint16_type;
	ValaDataType* int32_type;
	ValaDataType* uint32_type;
	ValaDataType* int64_type;
	ValaDataType* uint64_type;
	ValaDataType* string_type;
	ValaDataType* float_type;
	ValaDataType* double_type;
	ValaTypeSymbol* gtype_type;
	ValaTypeSymbol* gobject_type;
	ValaErrorType* gerror_type;
	ValaClass* glist_type;
	ValaClass* gslist_type;
	ValaClass* gvaluearray_type;
	ValaTypeSymbol* gstringbuilder_type;
	ValaTypeSymbol* garray_type;
	ValaTypeSymbol* gbytearray_type;
	ValaTypeSymbol* gptrarray_type;
	ValaDataType* gquark_type;
	ValaStruct* gvalue_type;
	ValaStruct* mutex_type;
	ValaTypeSymbol* type_module_type;
	ValaTypeSymbol* dbus_object_type;
	gboolean in_plugin;
	char* module_init_param_name;
	gboolean gvaluecollector_h_needed;
	gboolean requires_array_free;
	gboolean requires_array_move;
	gboolean requires_array_length;
	gboolean requires_strcmp0;
	gboolean dbus_glib_h_needed;
	gboolean dbus_glib_h_needed_in_header;
	GeeSet* wrappers;
	GeeMap* variable_name_map;
};

struct _ValaCCodeBaseModuleClass {
	ValaCCodeModuleClass parent_class;
	void (*append_vala_array_free) (ValaCCodeBaseModule* self);
	void (*append_vala_array_move) (ValaCCodeBaseModule* self);
	void (*append_vala_array_length) (ValaCCodeBaseModule* self);
	void (*generate_class_struct_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_struct_declaration) (ValaCCodeBaseModule* self, ValaStruct* st, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_delegate_declaration) (ValaCCodeBaseModule* self, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_cparameters) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
	ValaCCodeExpression* (*get_dup_func_expression) (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference, gboolean is_chainup);
	char* (*append_struct_array_free) (ValaCCodeBaseModule* self, ValaStruct* st);
	ValaCCodeExpression* (*get_unref_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr);
	void (*append_local_free) (ValaCCodeBaseModule* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, gboolean stop_at_loop);
	gboolean (*variable_accessible_in_finally) (ValaCCodeBaseModule* self, ValaLocalVariable* local);
	char* (*get_delegate_target_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_delegate_target_cexpression) (ValaCCodeBaseModule* self, ValaExpression* delegate_expr);
	char* (*get_delegate_target_destroy_notify_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_ref_cexpression) (ValaCCodeBaseModule* self, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node);
	void (*generate_class_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_interface_declaration) (ValaCCodeBaseModule* self, ValaInterface* iface, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_method_declaration) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_error_domain_declaration) (ValaCCodeBaseModule* self, ValaErrorDomain* edomain, ValaCCodeDeclarationSpace* decl_space);
	ValaCCodeExpression* (*get_implicit_cast_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
	gboolean (*is_gobject_property) (ValaCCodeBaseModule* self, ValaProperty* prop);
};

struct _ValaCCodeStructModule {
	ValaCCodeBaseModule parent_instance;
	ValaCCodeStructModulePrivate * priv;
};

struct _ValaCCodeStructModuleClass {
	ValaCCodeBaseModuleClass parent_class;
};

/**
 * The link between a method and generated code.
 */
struct _ValaCCodeMethodModule {
	ValaCCodeStructModule parent_instance;
	ValaCCodeMethodModulePrivate * priv;
};

struct _ValaCCodeMethodModuleClass {
	ValaCCodeStructModuleClass parent_class;
	void (*generate_method_result_declaration) (ValaCCodeMethodModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeFunction* cfunc, GeeMap* cparam_map, GeeMap* carg_map);
	void (*generate_parameter) (ValaCCodeMethodModule* self, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map);
};

struct _ValaCCodeControlFlowModule {
	ValaCCodeMethodModule parent_instance;
	ValaCCodeControlFlowModulePrivate * priv;
};

struct _ValaCCodeControlFlowModuleClass {
	ValaCCodeMethodModuleClass parent_class;
};

struct _ValaCCodeMemberAccessModule {
	ValaCCodeControlFlowModule parent_instance;
	ValaCCodeMemberAccessModulePrivate * priv;
};

struct _ValaCCodeMemberAccessModuleClass {
	ValaCCodeControlFlowModuleClass parent_class;
};

/**
 * The link between an assignment and generated code.
 */
struct _ValaCCodeAssignmentModule {
	ValaCCodeMemberAccessModule parent_instance;
	ValaCCodeAssignmentModulePrivate * priv;
};

struct _ValaCCodeAssignmentModuleClass {
	ValaCCodeMemberAccessModuleClass parent_class;
};

struct _ValaCCodeMethodCallModule {
	ValaCCodeAssignmentModule parent_instance;
	ValaCCodeMethodCallModulePrivate * priv;
};

struct _ValaCCodeMethodCallModuleClass {
	ValaCCodeAssignmentModuleClass parent_class;
};

struct _ValaCCodeArrayModule {
	ValaCCodeMethodCallModule parent_instance;
	ValaCCodeArrayModulePrivate * priv;
};

struct _ValaCCodeArrayModuleClass {
	ValaCCodeMethodCallModuleClass parent_class;
};

struct _ValaCCodeArrayModulePrivate {
	gint next_array_dup_id;
	gint next_array_add_id;
};


static gpointer vala_ccode_array_module_parent_class = NULL;

gpointer vala_ccode_module_ref (gpointer instance);
void vala_ccode_module_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_module (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_module (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_module (const GValue* value);
GType vala_ccode_module_get_type (void);
GType vala_ccode_base_module_get_type (void);
gpointer vala_ccode_declaration_space_ref (gpointer instance);
void vala_ccode_declaration_space_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_declaration_space (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_declaration_space (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_declaration_space (const GValue* value);
GType vala_ccode_declaration_space_get_type (void);
GType vala_ccode_struct_module_get_type (void);
GType vala_ccode_method_module_get_type (void);
GType vala_ccode_control_flow_module_get_type (void);
GType vala_ccode_member_access_module_get_type (void);
GType vala_ccode_assignment_module_get_type (void);
GType vala_ccode_method_call_module_get_type (void);
GType vala_ccode_array_module_get_type (void);
#define VALA_CCODE_ARRAY_MODULE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModulePrivate))
enum  {
	VALA_CCODE_ARRAY_MODULE_DUMMY_PROPERTY
};
GType vala_ccode_generator_get_type (void);
ValaCCodeMethodCallModule* vala_ccode_method_call_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeMethodCallModule* vala_ccode_method_call_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeArrayModule* vala_ccode_array_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeArrayModule* vala_ccode_array_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
static void vala_ccode_array_module_append_initializer_list (ValaCCodeArrayModule* self, ValaCCodeCommaExpression* ce, ValaCCodeExpression* name_cnode, ValaInitializerList* initializer_list, gint rank, gint* i);
ValaCCodeGenerator* vala_ccode_module_get_codegen (ValaCCodeModule* self);
ValaLocalVariable* vala_ccode_base_module_get_temp_variable (ValaCCodeBaseModule* self, ValaDataType* type, gboolean value_owned, ValaCodeNode* node_reference);
gboolean vala_ccode_base_module_is_pure_ccode_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* cexpr);
static void vala_ccode_array_module_real_visit_array_creation_expression (ValaCCodeModule* base, ValaArrayCreationExpression* expr);
static char* vala_ccode_array_module_real_get_array_length_cname (ValaCCodeModule* base, const char* array_cname, gint dim);
ValaCCodeExpression* vala_ccode_module_get_array_length_cexpression (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
ValaCCodeNode* vala_ccode_base_module_get_ccodenode (ValaCCodeBaseModule* self, ValaCodeNode* node);
ValaCCodeExpression* vala_ccode_base_module_get_variable_cexpression (ValaCCodeBaseModule* self, const char* name);
char* vala_ccode_module_get_array_length_cname (ValaCCodeModule* self, const char* array_cname, gint dim);
char* vala_ccode_base_module_get_variable_cname (ValaCCodeBaseModule* self, const char* name);
static ValaCCodeExpression* vala_ccode_array_module_real_get_array_length_cexpression (ValaCCodeModule* base, ValaExpression* array_expr, gint dim);
static char* vala_ccode_array_module_real_get_array_size_cname (ValaCCodeModule* base, const char* array_cname);
char* vala_ccode_module_get_array_size_cname (ValaCCodeModule* self, const char* array_cname);
static ValaCCodeExpression* vala_ccode_array_module_real_get_array_size_cexpression (ValaCCodeModule* base, ValaExpression* array_expr);
ValaCCodeModule* vala_ccode_module_get_head (ValaCCodeModule* self);
static void vala_ccode_array_module_real_visit_element_access (ValaCCodeModule* base, ValaElementAccess* expr);
ValaCCodeExpression* vala_ccode_base_module_get_destroy_func_expression (ValaCCodeBaseModule* self, ValaDataType* type, gboolean is_chainup);
static ValaCCodeForStatement* vala_ccode_array_module_get_struct_array_free_loop (ValaCCodeArrayModule* self, ValaStruct* st);
gboolean vala_ccode_declaration_space_add_declaration (ValaCCodeDeclarationSpace* self, const char* name);
void vala_ccode_declaration_space_add_type_member_declaration (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
static char* vala_ccode_array_module_real_append_struct_array_free (ValaCCodeBaseModule* base, ValaStruct* st);
static ValaCCodeForStatement* vala_ccode_array_module_get_vala_array_free_loop (ValaCCodeArrayModule* self);
static void vala_ccode_array_module_real_append_vala_array_free (ValaCCodeBaseModule* base);
void vala_ccode_declaration_space_add_include (ValaCCodeDeclarationSpace* self, const char* filename, gboolean local);
static void vala_ccode_array_module_real_append_vala_array_move (ValaCCodeBaseModule* base);
static void vala_ccode_array_module_real_append_vala_array_length (ValaCCodeBaseModule* base);
ValaCCodeExpression* vala_ccode_base_module_get_ref_cexpression (ValaCCodeBaseModule* self, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node);
static char* vala_ccode_array_module_generate_array_copy_wrapper (ValaCCodeArrayModule* self, ValaArrayType* array_type);
static ValaCCodeExpression* vala_ccode_array_module_real_get_ref_cexpression (ValaCCodeBaseModule* base, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node);
static char* vala_ccode_array_module_generate_array_dup_wrapper (ValaCCodeArrayModule* self, ValaArrayType* array_type);
ValaCCodeExpression* vala_ccode_base_module_get_dup_func_expression (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference, gboolean is_chainup);
static ValaCCodeExpression* vala_ccode_array_module_real_get_dup_func_expression (ValaCCodeBaseModule* base, ValaDataType* type, ValaSourceReference* source_reference, gboolean is_chainup);
ValaCCodeExpression* vala_ccode_base_module_get_unref_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr);
static ValaCCodeExpression* vala_ccode_array_module_real_get_unref_expression (ValaCCodeBaseModule* base, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr);
gboolean vala_ccode_base_module_add_wrapper (ValaCCodeBaseModule* self, const char* wrapper_name);
gboolean vala_ccode_base_module_requires_copy (ValaCCodeBaseModule* self, ValaDataType* type);
void vala_ccode_base_module_append_temp_decl (ValaCCodeBaseModule* self, ValaCCodeFragment* cfrag, GeeList* temp_vars);
static char* vala_ccode_array_module_generate_array_add_wrapper (ValaCCodeArrayModule* self, ValaArrayType* array_type);
void vala_ccode_module_visit_method_call (ValaCCodeModule* self, ValaMethodCall* expr);
static void vala_ccode_array_module_real_visit_method_call (ValaCCodeModule* base, ValaMethodCall* expr);
static gboolean vala_ccode_array_module_is_array_add (ValaCCodeArrayModule* self, ValaAssignment* assignment);
void vala_ccode_module_visit_assignment (ValaCCodeModule* self, ValaAssignment* a);
ValaCCodeExpression* vala_ccode_module_get_array_size_cexpression (ValaCCodeModule* self, ValaExpression* array_expr);
ValaCCodeExpression* vala_ccode_base_module_handle_struct_argument (ValaCCodeBaseModule* self, ValaFormalParameter* param, ValaExpression* arg, ValaCCodeExpression* cexpr);
static void vala_ccode_array_module_real_visit_assignment (ValaCCodeModule* base, ValaAssignment* assignment);
void vala_ccode_method_module_generate_parameter (ValaCCodeMethodModule* self, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map);
void vala_ccode_base_module_generate_type_declaration (ValaCCodeBaseModule* self, ValaDataType* type, ValaCCodeDeclarationSpace* decl_space);
gint vala_ccode_base_module_get_param_pos (ValaCCodeBaseModule* self, double param_pos, gboolean ellipsis);
static void vala_ccode_array_module_real_generate_parameter (ValaCCodeMethodModule* base, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map);
static void vala_ccode_array_module_finalize (ValaCCodeModule* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaCCodeArrayModule* vala_ccode_array_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeArrayModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaCCodeArrayModule*) vala_ccode_method_call_module_construct (object_type, codegen, next);
	return self;
}


ValaCCodeArrayModule* vala_ccode_array_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_array_module_construct (VALA_TYPE_CCODE_ARRAY_MODULE, codegen, next);
}


static void vala_ccode_array_module_append_initializer_list (ValaCCodeArrayModule* self, ValaCCodeCommaExpression* ce, ValaCCodeExpression* name_cnode, ValaInitializerList* initializer_list, gint rank, gint* i) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (ce != NULL);
	g_return_if_fail (name_cnode != NULL);
	g_return_if_fail (initializer_list != NULL);
	{
		GeeList* _tmp0_;
		GeeIterator* _tmp1_;
		GeeIterator* _e_it;
		_tmp0_ = NULL;
		_tmp1_ = NULL;
		_e_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = vala_initializer_list_get_initializers (initializer_list))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (gee_collection_object_unref (_tmp0_), NULL)), _tmp1_);
		while (TRUE) {
			ValaExpression* e;
			if (!gee_iterator_next (_e_it)) {
				break;
			}
			e = (ValaExpression*) gee_iterator_get (_e_it);
			if (rank > 1) {
				vala_ccode_array_module_append_initializer_list (self, ce, name_cnode, VALA_INITIALIZER_LIST (e), rank - 1, &(*i));
			} else {
				ValaCCodeAssignment* _tmp5_;
				ValaCCodeElementAccess* _tmp4_;
				ValaCCodeConstant* _tmp3_;
				char* _tmp2_;
				_tmp5_ = NULL;
				_tmp4_ = NULL;
				_tmp3_ = NULL;
				_tmp2_ = NULL;
				vala_ccode_comma_expression_append_expression (ce, (ValaCCodeExpression*) (_tmp5_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp4_ = vala_ccode_element_access_new (name_cnode, (ValaCCodeExpression*) (_tmp3_ = vala_ccode_constant_new (_tmp2_ = g_strdup_printf ("%i", (*i)))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) e)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
				(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
				(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
				(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
				_tmp2_ = (g_free (_tmp2_), NULL);
				(*i)++;
			}
			(e == NULL) ? NULL : (e = (vala_code_node_unref (e), NULL));
		}
		(_e_it == NULL) ? NULL : (_e_it = (gee_collection_object_unref (_e_it), NULL));
	}
}


static void vala_ccode_array_module_real_visit_array_creation_expression (ValaCCodeModule* base, ValaArrayCreationExpression* expr) {
	ValaCCodeArrayModule * self;
	ValaArrayType* _tmp1_;
	ValaDataType* _tmp0_;
	ValaArrayType* array_type;
	gboolean _tmp2_;
	ValaCCodeIdentifier* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeFunctionCall* gnew;
	ValaCCodeIdentifier* _tmp6_;
	char* _tmp5_;
	gboolean first;
	ValaCCodeExpression* cexpr;
	gboolean _tmp14_;
	self = (ValaCCodeArrayModule*) base;
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	array_type = (_tmp1_ = (_tmp0_ = vala_expression_get_target_type ((ValaExpression*) expr), VALA_IS_ARRAY_TYPE (_tmp0_) ? ((ValaArrayType*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	_tmp2_ = FALSE;
	if (array_type != NULL) {
		_tmp2_ = vala_array_type_get_fixed_length (array_type);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaCCodeCommaExpression* ce;
		ValaLocalVariable* temp_var;
		ValaCCodeIdentifier* name_cnode;
		gint i;
		/* no heap allocation for fixed-length arrays*/
		ce = vala_ccode_comma_expression_new ();
		temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) array_type, TRUE, (ValaCodeNode*) expr);
		name_cnode = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var));
		i = 0;
		gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
		vala_ccode_array_module_append_initializer_list (self, ce, (ValaCCodeExpression*) name_cnode, vala_array_creation_expression_get_initializer_list (expr), vala_array_creation_expression_get_rank (expr), &i);
		vala_ccode_comma_expression_append_expression (ce, (ValaCCodeExpression*) name_cnode);
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ce);
		(ce == NULL) ? NULL : (ce = (vala_ccode_node_unref (ce), NULL));
		(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
		(name_cnode == NULL) ? NULL : (name_cnode = (vala_ccode_node_unref (name_cnode), NULL));
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		return;
	}
	_tmp3_ = NULL;
	_tmp4_ = NULL;
	gnew = (_tmp4_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp3_ = vala_ccode_identifier_new ("g_new0"))), (_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL)), _tmp4_);
	_tmp6_ = NULL;
	_tmp5_ = NULL;
	vala_ccode_function_call_add_argument (gnew, (ValaCCodeExpression*) (_tmp6_ = vala_ccode_identifier_new (_tmp5_ = vala_data_type_get_cname (vala_array_creation_expression_get_element_type (expr)))));
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	_tmp5_ = (g_free (_tmp5_), NULL);
	first = TRUE;
	cexpr = NULL;
	/* iterate over each dimension*/
	{
		GeeList* _tmp7_;
		GeeIterator* _tmp8_;
		GeeIterator* _size_it;
		/* iterate over each dimension*/
		_tmp7_ = NULL;
		_tmp8_ = NULL;
		_size_it = (_tmp8_ = gee_iterable_iterator ((GeeIterable*) (_tmp7_ = vala_array_creation_expression_get_sizes (expr))), (_tmp7_ == NULL) ? NULL : (_tmp7_ = (gee_collection_object_unref (_tmp7_), NULL)), _tmp8_);
		/* iterate over each dimension*/
		while (TRUE) {
			ValaExpression* size;
			ValaCCodeExpression* _tmp9_;
			ValaCCodeExpression* csize;
			/* iterate over each dimension*/
			if (!gee_iterator_next (_size_it)) {
				/* iterate over each dimension*/
				break;
			}
			/* iterate over each dimension*/
			size = (ValaExpression*) gee_iterator_get (_size_it);
			_tmp9_ = NULL;
			csize = (_tmp9_ = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) size)), (_tmp9_ == NULL) ? NULL : vala_ccode_node_ref (_tmp9_));
			if (!vala_ccode_base_module_is_pure_ccode_expression ((ValaCCodeBaseModule*) self, csize)) {
				ValaLocalVariable* temp_var;
				ValaCCodeIdentifier* name_cnode;
				ValaCCodeExpression* _tmp10_;
				temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->int_type, FALSE, (ValaCodeNode*) expr);
				name_cnode = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var));
				vala_code_node_set_ccodenode ((ValaCodeNode*) size, (ValaCCodeNode*) name_cnode);
				gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
				_tmp10_ = NULL;
				csize = (_tmp10_ = (ValaCCodeExpression*) vala_ccode_assignment_new ((ValaCCodeExpression*) name_cnode, csize, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (csize == NULL) ? NULL : (csize = (vala_ccode_node_unref (csize), NULL)), _tmp10_);
				(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
				(name_cnode == NULL) ? NULL : (name_cnode = (vala_ccode_node_unref (name_cnode), NULL));
			}
			if (first) {
				ValaCCodeExpression* _tmp12_;
				ValaCCodeExpression* _tmp11_;
				_tmp12_ = NULL;
				_tmp11_ = NULL;
				cexpr = (_tmp12_ = (_tmp11_ = csize, (_tmp11_ == NULL) ? NULL : vala_ccode_node_ref (_tmp11_)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp12_);
				first = FALSE;
			} else {
				ValaCCodeExpression* _tmp13_;
				_tmp13_ = NULL;
				cexpr = (_tmp13_ = (ValaCCodeExpression*) vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, cexpr, csize), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp13_);
			}
			(size == NULL) ? NULL : (size = (vala_code_node_unref (size), NULL));
			(csize == NULL) ? NULL : (csize = (vala_ccode_node_unref (csize), NULL));
		}
		(_size_it == NULL) ? NULL : (_size_it = (gee_collection_object_unref (_size_it), NULL));
	}
	_tmp14_ = FALSE;
	if (vala_data_type_get_data_type (vala_array_creation_expression_get_element_type (expr)) != NULL) {
		_tmp14_ = vala_typesymbol_is_reference_type (vala_data_type_get_data_type (vala_array_creation_expression_get_element_type (expr)));
	} else {
		_tmp14_ = FALSE;
	}
	/* add extra item to have array NULL-terminated for all reference types*/
	if (_tmp14_) {
		ValaCCodeExpression* _tmp16_;
		ValaCCodeConstant* _tmp15_;
		_tmp16_ = NULL;
		_tmp15_ = NULL;
		cexpr = (_tmp16_ = (ValaCCodeExpression*) vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, cexpr, (ValaCCodeExpression*) (_tmp15_ = vala_ccode_constant_new ("1"))), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp16_);
		(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
	}
	vala_ccode_function_call_add_argument (gnew, cexpr);
	if (vala_array_creation_expression_get_initializer_list (expr) != NULL) {
		ValaCCodeCommaExpression* ce;
		ValaLocalVariable* temp_var;
		ValaCCodeIdentifier* name_cnode;
		gint i;
		ValaCCodeAssignment* _tmp17_;
		ce = vala_ccode_comma_expression_new ();
		temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_value_type ((ValaExpression*) expr), TRUE, (ValaCodeNode*) expr);
		name_cnode = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var));
		i = 0;
		gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
		_tmp17_ = NULL;
		vala_ccode_comma_expression_append_expression (ce, (ValaCCodeExpression*) (_tmp17_ = vala_ccode_assignment_new ((ValaCCodeExpression*) name_cnode, (ValaCCodeExpression*) gnew, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		(_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL));
		vala_ccode_array_module_append_initializer_list (self, ce, (ValaCCodeExpression*) name_cnode, vala_array_creation_expression_get_initializer_list (expr), vala_array_creation_expression_get_rank (expr), &i);
		vala_ccode_comma_expression_append_expression (ce, (ValaCCodeExpression*) name_cnode);
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ce);
		(ce == NULL) ? NULL : (ce = (vala_ccode_node_unref (ce), NULL));
		(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
		(name_cnode == NULL) ? NULL : (name_cnode = (vala_ccode_node_unref (name_cnode), NULL));
	} else {
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) gnew);
	}
	(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	(gnew == NULL) ? NULL : (gnew = (vala_ccode_node_unref (gnew), NULL));
	(cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL));
}


static char* vala_ccode_array_module_real_get_array_length_cname (ValaCCodeModule* base, const char* array_cname, gint dim) {
	ValaCCodeArrayModule * self;
	char* result;
	self = (ValaCCodeArrayModule*) base;
	g_return_val_if_fail (array_cname != NULL, NULL);
	result = g_strdup_printf ("%s_length%d", array_cname, dim);
	return result;
}


static ValaCCodeExpression* vala_ccode_array_module_real_get_array_length_cexpression (ValaCCodeModule* base, ValaExpression* array_expr, gint dim) {
	ValaCCodeArrayModule * self;
	ValaCCodeExpression* result;
	ValaArrayType* _tmp1_;
	ValaDataType* _tmp0_;
	ValaArrayType* array_type;
	gboolean _tmp2_;
	gboolean is_out;
	self = (ValaCCodeArrayModule*) base;
	g_return_val_if_fail (array_expr != NULL, NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	array_type = (_tmp1_ = (_tmp0_ = vala_expression_get_value_type (array_expr), VALA_IS_ARRAY_TYPE (_tmp0_) ? ((ValaArrayType*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	_tmp2_ = FALSE;
	if (array_type != NULL) {
		_tmp2_ = vala_array_type_get_fixed_length (array_type);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		char* _tmp3_;
		ValaCCodeExpression* _tmp4_;
		_tmp3_ = NULL;
		_tmp4_ = NULL;
		result = (_tmp4_ = (ValaCCodeExpression*) vala_ccode_constant_new (_tmp3_ = g_strdup_printf ("%i", vala_array_type_get_length (array_type))), _tmp3_ = (g_free (_tmp3_), NULL), _tmp4_);
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		return result;
	}
	/* dim == -1 => total size over all dimensions*/
	if (dim == (-1)) {
		gboolean _tmp5_;
		_tmp5_ = FALSE;
		if (array_type != NULL) {
			_tmp5_ = vala_array_type_get_rank (array_type) > 1;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			ValaCCodeExpression* cexpr;
			cexpr = vala_ccode_module_get_array_length_cexpression ((ValaCCodeModule*) self, array_expr, 1);
			{
				gboolean _tmp6_;
				dim = 2;
				_tmp6_ = TRUE;
				while (TRUE) {
					ValaCCodeExpression* _tmp8_;
					ValaCCodeExpression* _tmp7_;
					if (!_tmp6_) {
						dim++;
					}
					_tmp6_ = FALSE;
					if (!(dim <= vala_array_type_get_rank (array_type))) {
						break;
					}
					_tmp8_ = NULL;
					_tmp7_ = NULL;
					cexpr = (_tmp8_ = (ValaCCodeExpression*) vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, cexpr, _tmp7_ = vala_ccode_module_get_array_length_cexpression ((ValaCCodeModule*) self, array_expr, dim)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp8_);
					(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
				}
			}
			result = cexpr;
			(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
			return result;
		} else {
			dim = 1;
		}
	}
	is_out = FALSE;
	if (VALA_IS_UNARY_EXPRESSION (array_expr)) {
		ValaUnaryExpression* _tmp9_;
		ValaUnaryExpression* unary_expr;
		gboolean _tmp10_;
		_tmp9_ = NULL;
		unary_expr = (_tmp9_ = VALA_UNARY_EXPRESSION (array_expr), (_tmp9_ == NULL) ? NULL : vala_code_node_ref (_tmp9_));
		_tmp10_ = FALSE;
		if (vala_unary_expression_get_operator (unary_expr) == VALA_UNARY_OPERATOR_OUT) {
			_tmp10_ = TRUE;
		} else {
			_tmp10_ = vala_unary_expression_get_operator (unary_expr) == VALA_UNARY_OPERATOR_REF;
		}
		if (_tmp10_) {
			array_expr = vala_unary_expression_get_inner (unary_expr);
			is_out = TRUE;
		}
		(unary_expr == NULL) ? NULL : (unary_expr = (vala_code_node_unref (unary_expr), NULL));
	} else {
		if (VALA_IS_REFERENCE_TRANSFER_EXPRESSION (array_expr)) {
			ValaReferenceTransferExpression* _tmp11_;
			ValaReferenceTransferExpression* reftransfer_expr;
			_tmp11_ = NULL;
			reftransfer_expr = (_tmp11_ = VALA_REFERENCE_TRANSFER_EXPRESSION (array_expr), (_tmp11_ == NULL) ? NULL : vala_code_node_ref (_tmp11_));
			array_expr = vala_reference_transfer_expression_get_inner (reftransfer_expr);
			(reftransfer_expr == NULL) ? NULL : (reftransfer_expr = (vala_code_node_unref (reftransfer_expr), NULL));
		}
	}
	if (VALA_IS_ARRAY_CREATION_EXPRESSION (array_expr)) {
		GeeList* size;
		ValaExpression* length_expr;
		size = vala_array_creation_expression_get_sizes (VALA_ARRAY_CREATION_EXPRESSION (array_expr));
		length_expr = (ValaExpression*) gee_list_get (size, dim - 1);
		result = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, (ValaCodeNode*) length_expr));
		(size == NULL) ? NULL : (size = (gee_collection_object_unref (size), NULL));
		(length_expr == NULL) ? NULL : (length_expr = (vala_code_node_unref (length_expr), NULL));
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		return result;
	} else {
		gboolean _tmp12_;
		_tmp12_ = FALSE;
		if (VALA_IS_METHOD_CALL (array_expr)) {
			_tmp12_ = TRUE;
		} else {
			_tmp12_ = VALA_IS_CAST_EXPRESSION (array_expr);
		}
		if (_tmp12_) {
			GeeList* size;
			size = vala_expression_get_array_sizes (array_expr);
			result = (ValaCCodeExpression*) gee_list_get (size, dim - 1);
			(size == NULL) ? NULL : (size = (gee_collection_object_unref (size), NULL));
			(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
			return result;
		} else {
			if (vala_expression_get_symbol_reference (array_expr) != NULL) {
				if (VALA_IS_FORMAL_PARAMETER (vala_expression_get_symbol_reference (array_expr))) {
					ValaFormalParameter* _tmp13_;
					ValaFormalParameter* param;
					_tmp13_ = NULL;
					param = (_tmp13_ = VALA_FORMAL_PARAMETER (vala_expression_get_symbol_reference (array_expr)), (_tmp13_ == NULL) ? NULL : vala_code_node_ref (_tmp13_));
					if (vala_formal_parameter_get_array_null_terminated (param)) {
						ValaCCodeExpression* carray_expr;
						ValaCCodeIdentifier* _tmp14_;
						ValaCCodeFunctionCall* _tmp15_;
						ValaCCodeFunctionCall* len_call;
						carray_expr = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param));
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp14_ = NULL;
						_tmp15_ = NULL;
						len_call = (_tmp15_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp14_ = vala_ccode_identifier_new ("_vala_array_length"))), (_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL)), _tmp15_);
						vala_ccode_function_call_add_argument (len_call, carray_expr);
						result = (ValaCCodeExpression*) len_call;
						(carray_expr == NULL) ? NULL : (carray_expr = (vala_ccode_node_unref (carray_expr), NULL));
						(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
						(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
						return result;
					} else {
						if (!vala_formal_parameter_get_no_array_length (param)) {
							char* _tmp16_;
							ValaCCodeExpression* _tmp17_;
							ValaCCodeExpression* length_expr;
							_tmp16_ = NULL;
							_tmp17_ = NULL;
							length_expr = (_tmp17_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp16_ = vala_ccode_module_get_array_length_cname ((ValaCCodeModule*) self, vala_symbol_get_name ((ValaSymbol*) param), dim)), _tmp16_ = (g_free (_tmp16_), NULL), _tmp17_);
							if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
								ValaCCodeExpression* _tmp18_;
								/* accessing argument of out/ref param*/
								_tmp18_ = NULL;
								length_expr = (_tmp18_ = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, length_expr), (length_expr == NULL) ? NULL : (length_expr = (vala_ccode_node_unref (length_expr), NULL)), _tmp18_);
							}
							if (is_out) {
								/* passing array as out/ref*/
								result = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, length_expr);
								(length_expr == NULL) ? NULL : (length_expr = (vala_ccode_node_unref (length_expr), NULL));
								(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
								(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
								return result;
							} else {
								result = length_expr;
								(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
								(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
								return result;
							}
							(length_expr == NULL) ? NULL : (length_expr = (vala_ccode_node_unref (length_expr), NULL));
						}
					}
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				} else {
					if (VALA_IS_LOCAL_VARIABLE (vala_expression_get_symbol_reference (array_expr))) {
						ValaLocalVariable* _tmp19_;
						ValaLocalVariable* local;
						char* _tmp21_;
						char* _tmp20_;
						ValaCCodeExpression* _tmp22_;
						ValaCCodeExpression* length_expr;
						_tmp19_ = NULL;
						local = (_tmp19_ = VALA_LOCAL_VARIABLE (vala_expression_get_symbol_reference (array_expr)), (_tmp19_ == NULL) ? NULL : vala_code_node_ref (_tmp19_));
						_tmp21_ = NULL;
						_tmp20_ = NULL;
						_tmp22_ = NULL;
						length_expr = (_tmp22_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp21_ = vala_ccode_module_get_array_length_cname ((ValaCCodeModule*) self, _tmp20_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) local)), dim)), _tmp21_ = (g_free (_tmp21_), NULL), _tmp20_ = (g_free (_tmp20_), NULL), _tmp22_);
						if (is_out) {
							result = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, length_expr);
							(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
							(length_expr == NULL) ? NULL : (length_expr = (vala_ccode_node_unref (length_expr), NULL));
							(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
							return result;
						} else {
							result = length_expr;
							(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
							(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
							return result;
						}
						(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
						(length_expr == NULL) ? NULL : (length_expr = (vala_ccode_node_unref (length_expr), NULL));
					} else {
						if (VALA_IS_FIELD (vala_expression_get_symbol_reference (array_expr))) {
							ValaField* _tmp23_;
							ValaField* field;
							_tmp23_ = NULL;
							field = (_tmp23_ = VALA_FIELD (vala_expression_get_symbol_reference (array_expr)), (_tmp23_ == NULL) ? NULL : vala_code_node_ref (_tmp23_));
							if (vala_field_get_array_null_terminated (field)) {
								ValaMemberAccess* _tmp24_;
								ValaMemberAccess* ma;
								ValaCCodeExpression* carray_expr;
								ValaCCodeIdentifier* _tmp36_;
								ValaCCodeFunctionCall* _tmp37_;
								ValaCCodeFunctionCall* len_call;
								_tmp24_ = NULL;
								ma = (_tmp24_ = VALA_MEMBER_ACCESS (array_expr), (_tmp24_ == NULL) ? NULL : vala_code_node_ref (_tmp24_));
								carray_expr = NULL;
								if (vala_field_get_binding (field) == MEMBER_BINDING_INSTANCE) {
									ValaClass* _tmp26_;
									ValaSymbol* _tmp25_;
									ValaClass* cl;
									gboolean _tmp27_;
									gboolean is_gtypeinstance;
									char* array_cname;
									ValaCCodeExpression* typed_inst;
									ValaCCodeExpression* inst;
									gboolean _tmp28_;
									_tmp26_ = NULL;
									_tmp25_ = NULL;
									cl = (_tmp26_ = (_tmp25_ = vala_symbol_get_parent_symbol ((ValaSymbol*) field), VALA_IS_CLASS (_tmp25_) ? ((ValaClass*) _tmp25_) : NULL), (_tmp26_ == NULL) ? NULL : vala_code_node_ref (_tmp26_));
									_tmp27_ = FALSE;
									if (cl != NULL) {
										_tmp27_ = !vala_class_get_is_compact (cl);
									} else {
										_tmp27_ = FALSE;
									}
									is_gtypeinstance = _tmp27_;
									array_cname = vala_field_get_cname (field);
									typed_inst = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, (ValaCodeNode*) vala_member_access_get_inner (ma)));
									inst = NULL;
									_tmp28_ = FALSE;
									if (is_gtypeinstance) {
										_tmp28_ = vala_symbol_get_access ((ValaSymbol*) field) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
									} else {
										_tmp28_ = FALSE;
									}
									if (_tmp28_) {
										ValaCCodeExpression* _tmp29_;
										_tmp29_ = NULL;
										inst = (_tmp29_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (typed_inst, "priv"), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp29_);
									} else {
										ValaCCodeExpression* _tmp31_;
										ValaCCodeExpression* _tmp30_;
										_tmp31_ = NULL;
										_tmp30_ = NULL;
										inst = (_tmp31_ = (_tmp30_ = typed_inst, (_tmp30_ == NULL) ? NULL : vala_ccode_node_ref (_tmp30_)), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp31_);
									}
									if (vala_typesymbol_is_reference_type (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) field)))) {
										ValaCCodeExpression* _tmp32_;
										_tmp32_ = NULL;
										carray_expr = (_tmp32_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (inst, array_cname), (carray_expr == NULL) ? NULL : (carray_expr = (vala_ccode_node_unref (carray_expr), NULL)), _tmp32_);
									} else {
										ValaCCodeExpression* _tmp33_;
										_tmp33_ = NULL;
										carray_expr = (_tmp33_ = (ValaCCodeExpression*) vala_ccode_member_access_new (inst, array_cname, FALSE), (carray_expr == NULL) ? NULL : (carray_expr = (vala_ccode_node_unref (carray_expr), NULL)), _tmp33_);
									}
									(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
									array_cname = (g_free (array_cname), NULL);
									(typed_inst == NULL) ? NULL : (typed_inst = (vala_ccode_node_unref (typed_inst), NULL));
									(inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL));
								} else {
									ValaCCodeExpression* _tmp35_;
									char* _tmp34_;
									_tmp35_ = NULL;
									_tmp34_ = NULL;
									carray_expr = (_tmp35_ = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp34_ = vala_field_get_cname (field)), (carray_expr == NULL) ? NULL : (carray_expr = (vala_ccode_node_unref (carray_expr), NULL)), _tmp35_);
									_tmp34_ = (g_free (_tmp34_), NULL);
								}
								((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
								_tmp36_ = NULL;
								_tmp37_ = NULL;
								len_call = (_tmp37_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp36_ = vala_ccode_identifier_new ("_vala_array_length"))), (_tmp36_ == NULL) ? NULL : (_tmp36_ = (vala_ccode_node_unref (_tmp36_), NULL)), _tmp37_);
								vala_ccode_function_call_add_argument (len_call, carray_expr);
								result = (ValaCCodeExpression*) len_call;
								(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
								(carray_expr == NULL) ? NULL : (carray_expr = (vala_ccode_node_unref (carray_expr), NULL));
								(field == NULL) ? NULL : (field = (vala_code_node_unref (field), NULL));
								(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
								return result;
							} else {
								if (!vala_field_get_no_array_length (field)) {
									ValaMemberAccess* _tmp38_;
									ValaMemberAccess* ma;
									ValaCCodeExpression* length_expr;
									_tmp38_ = NULL;
									ma = (_tmp38_ = VALA_MEMBER_ACCESS (array_expr), (_tmp38_ == NULL) ? NULL : vala_code_node_ref (_tmp38_));
									length_expr = NULL;
									if (vala_field_get_has_array_length_cexpr (field)) {
										ValaCCodeExpression* _tmp40_;
										char* _tmp39_;
										_tmp40_ = NULL;
										_tmp39_ = NULL;
										length_expr = (_tmp40_ = (ValaCCodeExpression*) vala_ccode_constant_new (_tmp39_ = vala_field_get_array_length_cexpr (field)), (length_expr == NULL) ? NULL : (length_expr = (vala_ccode_node_unref (length_expr), NULL)), _tmp40_);
										_tmp39_ = (g_free (_tmp39_), NULL);
									} else {
										if (vala_field_get_binding (field) == MEMBER_BINDING_INSTANCE) {
											ValaClass* _tmp42_;
											ValaSymbol* _tmp41_;
											ValaClass* cl;
											gboolean _tmp43_;
											gboolean is_gtypeinstance;
											char* length_cname;
											ValaCCodeExpression* typed_inst;
											ValaCCodeExpression* inst;
											gboolean _tmp46_;
											_tmp42_ = NULL;
											_tmp41_ = NULL;
											cl = (_tmp42_ = (_tmp41_ = vala_symbol_get_parent_symbol ((ValaSymbol*) field), VALA_IS_CLASS (_tmp41_) ? ((ValaClass*) _tmp41_) : NULL), (_tmp42_ == NULL) ? NULL : vala_code_node_ref (_tmp42_));
											_tmp43_ = FALSE;
											if (cl != NULL) {
												_tmp43_ = !vala_class_get_is_compact (cl);
											} else {
												_tmp43_ = FALSE;
											}
											is_gtypeinstance = _tmp43_;
											length_cname = NULL;
											if (vala_field_get_has_array_length_cname (field)) {
												char* _tmp44_;
												_tmp44_ = NULL;
												length_cname = (_tmp44_ = vala_field_get_array_length_cname (field), length_cname = (g_free (length_cname), NULL), _tmp44_);
											} else {
												char* _tmp45_;
												_tmp45_ = NULL;
												length_cname = (_tmp45_ = vala_ccode_module_get_array_length_cname ((ValaCCodeModule*) self, vala_symbol_get_name ((ValaSymbol*) field), dim), length_cname = (g_free (length_cname), NULL), _tmp45_);
											}
											typed_inst = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, (ValaCodeNode*) vala_member_access_get_inner (ma)));
											inst = NULL;
											_tmp46_ = FALSE;
											if (is_gtypeinstance) {
												_tmp46_ = vala_symbol_get_access ((ValaSymbol*) field) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
											} else {
												_tmp46_ = FALSE;
											}
											if (_tmp46_) {
												ValaCCodeExpression* _tmp47_;
												_tmp47_ = NULL;
												inst = (_tmp47_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (typed_inst, "priv"), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp47_);
											} else {
												ValaCCodeExpression* _tmp49_;
												ValaCCodeExpression* _tmp48_;
												_tmp49_ = NULL;
												_tmp48_ = NULL;
												inst = (_tmp49_ = (_tmp48_ = typed_inst, (_tmp48_ == NULL) ? NULL : vala_ccode_node_ref (_tmp48_)), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp49_);
											}
											if (vala_typesymbol_is_reference_type (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) field)))) {
												ValaCCodeExpression* _tmp50_;
												_tmp50_ = NULL;
												length_expr = (_tmp50_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (inst, length_cname), (length_expr == NULL) ? NULL : (length_expr = (vala_ccode_node_unref (length_expr), NULL)), _tmp50_);
											} else {
												ValaCCodeExpression* _tmp51_;
												_tmp51_ = NULL;
												length_expr = (_tmp51_ = (ValaCCodeExpression*) vala_ccode_member_access_new (inst, length_cname, FALSE), (length_expr == NULL) ? NULL : (length_expr = (vala_ccode_node_unref (length_expr), NULL)), _tmp51_);
											}
											(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
											length_cname = (g_free (length_cname), NULL);
											(typed_inst == NULL) ? NULL : (typed_inst = (vala_ccode_node_unref (typed_inst), NULL));
											(inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL));
										} else {
											ValaCCodeExpression* _tmp54_;
											char* _tmp53_;
											char* _tmp52_;
											_tmp54_ = NULL;
											_tmp53_ = NULL;
											_tmp52_ = NULL;
											length_expr = (_tmp54_ = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp53_ = vala_ccode_module_get_array_length_cname ((ValaCCodeModule*) self, _tmp52_ = vala_field_get_cname (field), dim)), (length_expr == NULL) ? NULL : (length_expr = (vala_ccode_node_unref (length_expr), NULL)), _tmp54_);
											_tmp53_ = (g_free (_tmp53_), NULL);
											_tmp52_ = (g_free (_tmp52_), NULL);
										}
									}
									if (is_out) {
										result = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, length_expr);
										(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
										(length_expr == NULL) ? NULL : (length_expr = (vala_ccode_node_unref (length_expr), NULL));
										(field == NULL) ? NULL : (field = (vala_code_node_unref (field), NULL));
										(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
										return result;
									} else {
										result = length_expr;
										(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
										(field == NULL) ? NULL : (field = (vala_code_node_unref (field), NULL));
										(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
										return result;
									}
									(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
									(length_expr == NULL) ? NULL : (length_expr = (vala_ccode_node_unref (length_expr), NULL));
								}
							}
							(field == NULL) ? NULL : (field = (vala_code_node_unref (field), NULL));
						} else {
							if (VALA_IS_CONSTANT (vala_expression_get_symbol_reference (array_expr))) {
								ValaConstant* _tmp55_;
								ValaConstant* constant;
								ValaCCodeIdentifier* _tmp56_;
								ValaCCodeFunctionCall* _tmp57_;
								ValaCCodeFunctionCall* ccall;
								ValaCCodeIdentifier* _tmp59_;
								char* _tmp58_;
								_tmp55_ = NULL;
								constant = (_tmp55_ = VALA_CONSTANT (vala_expression_get_symbol_reference (array_expr)), (_tmp55_ == NULL) ? NULL : vala_code_node_ref (_tmp55_));
								_tmp56_ = NULL;
								_tmp57_ = NULL;
								ccall = (_tmp57_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp56_ = vala_ccode_identifier_new ("G_N_ELEMENTS"))), (_tmp56_ == NULL) ? NULL : (_tmp56_ = (vala_ccode_node_unref (_tmp56_), NULL)), _tmp57_);
								_tmp59_ = NULL;
								_tmp58_ = NULL;
								vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp59_ = vala_ccode_identifier_new (_tmp58_ = vala_constant_get_cname (constant))));
								(_tmp59_ == NULL) ? NULL : (_tmp59_ = (vala_ccode_node_unref (_tmp59_), NULL));
								_tmp58_ = (g_free (_tmp58_), NULL);
								result = (ValaCCodeExpression*) ccall;
								(constant == NULL) ? NULL : (constant = (vala_code_node_unref (constant), NULL));
								(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
								return result;
							} else {
								if (VALA_IS_PROPERTY (vala_expression_get_symbol_reference (array_expr))) {
									ValaProperty* _tmp60_;
									ValaProperty* prop;
									_tmp60_ = NULL;
									prop = (_tmp60_ = VALA_PROPERTY (vala_expression_get_symbol_reference (array_expr)), (_tmp60_ == NULL) ? NULL : vala_code_node_ref (_tmp60_));
									if (!vala_property_get_no_array_length (prop)) {
										GeeList* size;
										size = vala_expression_get_array_sizes (array_expr);
										result = (ValaCCodeExpression*) gee_list_get (size, dim - 1);
										(size == NULL) ? NULL : (size = (gee_collection_object_unref (size), NULL));
										(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
										(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
										return result;
									}
									(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
								}
							}
						}
					}
				}
			} else {
				if (VALA_IS_NULL_LITERAL (array_expr)) {
					result = (ValaCCodeExpression*) vala_ccode_constant_new ("0");
					(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
					return result;
				}
			}
		}
	}
	if (!is_out) {
		/* allow arrays with unknown length even for value types
		 * as else it may be impossible to bind some libraries
		 * users of affected libraries should explicitly set
		 * the array length as early as possible
		 * by setting the virtual length field of the array
		 */
		result = (ValaCCodeExpression*) vala_ccode_constant_new ("-1");
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		return result;
	} else {
		result = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL");
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		return result;
	}
	(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
}


static char* vala_ccode_array_module_real_get_array_size_cname (ValaCCodeModule* base, const char* array_cname) {
	ValaCCodeArrayModule * self;
	char* result;
	self = (ValaCCodeArrayModule*) base;
	g_return_val_if_fail (array_cname != NULL, NULL);
	result = g_strdup_printf ("%s_size", array_cname);
	return result;
}


static ValaCCodeExpression* vala_ccode_array_module_real_get_array_size_cexpression (ValaCCodeModule* base, ValaExpression* array_expr) {
	ValaCCodeArrayModule * self;
	ValaCCodeExpression* result;
	self = (ValaCCodeArrayModule*) base;
	g_return_val_if_fail (array_expr != NULL, NULL);
	if (VALA_IS_LOCAL_VARIABLE (vala_expression_get_symbol_reference (array_expr))) {
		ValaLocalVariable* _tmp0_;
		ValaLocalVariable* local;
		char* _tmp2_;
		char* _tmp1_;
		ValaCCodeExpression* _tmp3_;
		_tmp0_ = NULL;
		local = (_tmp0_ = VALA_LOCAL_VARIABLE (vala_expression_get_symbol_reference (array_expr)), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
		_tmp2_ = NULL;
		_tmp1_ = NULL;
		_tmp3_ = NULL;
		result = (_tmp3_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp2_ = vala_ccode_module_get_array_size_cname ((ValaCCodeModule*) self, _tmp1_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) local)))), _tmp2_ = (g_free (_tmp2_), NULL), _tmp1_ = (g_free (_tmp1_), NULL), _tmp3_);
		(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
		return result;
		(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
	} else {
		if (VALA_IS_FIELD (vala_expression_get_symbol_reference (array_expr))) {
			ValaField* _tmp4_;
			ValaField* field;
			ValaMemberAccess* _tmp5_;
			ValaMemberAccess* ma;
			ValaCCodeExpression* size_expr;
			_tmp4_ = NULL;
			field = (_tmp4_ = VALA_FIELD (vala_expression_get_symbol_reference (array_expr)), (_tmp4_ == NULL) ? NULL : vala_code_node_ref (_tmp4_));
			_tmp5_ = NULL;
			ma = (_tmp5_ = VALA_MEMBER_ACCESS (array_expr), (_tmp5_ == NULL) ? NULL : vala_code_node_ref (_tmp5_));
			size_expr = NULL;
			if (vala_field_get_binding (field) == MEMBER_BINDING_INSTANCE) {
				ValaClass* _tmp7_;
				ValaSymbol* _tmp6_;
				ValaClass* cl;
				gboolean _tmp8_;
				gboolean is_gtypeinstance;
				char* size_cname;
				ValaCCodeExpression* typed_inst;
				ValaCCodeExpression* inst;
				gboolean _tmp9_;
				_tmp7_ = NULL;
				_tmp6_ = NULL;
				cl = (_tmp7_ = (_tmp6_ = vala_symbol_get_parent_symbol ((ValaSymbol*) field), VALA_IS_CLASS (_tmp6_) ? ((ValaClass*) _tmp6_) : NULL), (_tmp7_ == NULL) ? NULL : vala_code_node_ref (_tmp7_));
				_tmp8_ = FALSE;
				if (cl != NULL) {
					_tmp8_ = !vala_class_get_is_compact (cl);
				} else {
					_tmp8_ = FALSE;
				}
				is_gtypeinstance = _tmp8_;
				size_cname = vala_ccode_module_get_array_size_cname ((ValaCCodeModule*) self, vala_symbol_get_name ((ValaSymbol*) field));
				typed_inst = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, (ValaCodeNode*) vala_member_access_get_inner (ma)));
				inst = NULL;
				_tmp9_ = FALSE;
				if (is_gtypeinstance) {
					_tmp9_ = vala_symbol_get_access ((ValaSymbol*) field) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					ValaCCodeExpression* _tmp10_;
					_tmp10_ = NULL;
					inst = (_tmp10_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (typed_inst, "priv"), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp10_);
				} else {
					ValaCCodeExpression* _tmp12_;
					ValaCCodeExpression* _tmp11_;
					_tmp12_ = NULL;
					_tmp11_ = NULL;
					inst = (_tmp12_ = (_tmp11_ = typed_inst, (_tmp11_ == NULL) ? NULL : vala_ccode_node_ref (_tmp11_)), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp12_);
				}
				if (vala_typesymbol_is_reference_type (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) field)))) {
					ValaCCodeExpression* _tmp13_;
					_tmp13_ = NULL;
					size_expr = (_tmp13_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (inst, size_cname), (size_expr == NULL) ? NULL : (size_expr = (vala_ccode_node_unref (size_expr), NULL)), _tmp13_);
				} else {
					ValaCCodeExpression* _tmp14_;
					_tmp14_ = NULL;
					size_expr = (_tmp14_ = (ValaCCodeExpression*) vala_ccode_member_access_new (inst, size_cname, FALSE), (size_expr == NULL) ? NULL : (size_expr = (vala_ccode_node_unref (size_expr), NULL)), _tmp14_);
				}
				(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
				size_cname = (g_free (size_cname), NULL);
				(typed_inst == NULL) ? NULL : (typed_inst = (vala_ccode_node_unref (typed_inst), NULL));
				(inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL));
			} else {
				ValaCCodeExpression* _tmp17_;
				char* _tmp16_;
				char* _tmp15_;
				_tmp17_ = NULL;
				_tmp16_ = NULL;
				_tmp15_ = NULL;
				size_expr = (_tmp17_ = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp16_ = vala_ccode_module_get_array_size_cname ((ValaCCodeModule*) self, _tmp15_ = vala_field_get_cname (field))), (size_expr == NULL) ? NULL : (size_expr = (vala_ccode_node_unref (size_expr), NULL)), _tmp17_);
				_tmp16_ = (g_free (_tmp16_), NULL);
				_tmp15_ = (g_free (_tmp15_), NULL);
			}
			result = size_expr;
			(field == NULL) ? NULL : (field = (vala_code_node_unref (field), NULL));
			(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
			return result;
		}
	}
	g_assert_not_reached ();
}


static void vala_ccode_array_module_real_visit_element_access (ValaCCodeModule* base, ValaElementAccess* expr) {
	ValaCCodeArrayModule * self;
	GeeList* indices;
	gint rank;
	ValaTypeSymbol* _tmp0_;
	ValaTypeSymbol* container_type;
	ValaCCodeExpression* _tmp1_;
	ValaCCodeExpression* ccontainer;
	ValaCCodeExpression* _tmp3_;
	ValaExpression* _tmp2_;
	ValaCCodeExpression* _tmp4_;
	ValaCCodeExpression* cindex;
	self = (ValaCCodeArrayModule*) base;
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	indices = vala_element_access_get_indices (expr);
	rank = gee_collection_get_size ((GeeCollection*) indices);
	_tmp0_ = NULL;
	container_type = (_tmp0_ = vala_data_type_get_data_type (vala_expression_get_value_type (vala_element_access_get_container (expr))), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
	_tmp1_ = NULL;
	ccontainer = (_tmp1_ = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_element_access_get_container (expr))), (_tmp1_ == NULL) ? NULL : vala_ccode_node_ref (_tmp1_));
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	_tmp4_ = NULL;
	cindex = (_tmp4_ = (_tmp3_ = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) (_tmp2_ = (ValaExpression*) gee_list_get (indices, 0)))), (_tmp3_ == NULL) ? NULL : vala_ccode_node_ref (_tmp3_)), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_code_node_unref (_tmp2_), NULL)), _tmp4_);
	if (VALA_IS_ARRAY_LENGTH_FIELD (vala_expression_get_symbol_reference (vala_element_access_get_container (expr)))) {
		ValaExpression* _tmp5_;
		ValaIntegerLiteral* lit;
		ValaMemberAccess* _tmp7_;
		ValaExpression* _tmp6_;
		ValaMemberAccess* memberaccess;
		gboolean _tmp8_;
		/* Figure if cindex is a constant expression and calculate dim...*/
		_tmp5_ = NULL;
		lit = (_tmp5_ = (ValaExpression*) gee_list_get (indices, 0), VALA_IS_INTEGER_LITERAL (_tmp5_) ? ((ValaIntegerLiteral*) _tmp5_) : NULL);
		_tmp7_ = NULL;
		_tmp6_ = NULL;
		memberaccess = (_tmp7_ = (_tmp6_ = vala_element_access_get_container (expr), VALA_IS_MEMBER_ACCESS (_tmp6_) ? ((ValaMemberAccess*) _tmp6_) : NULL), (_tmp7_ == NULL) ? NULL : vala_code_node_ref (_tmp7_));
		_tmp8_ = FALSE;
		if (lit != NULL) {
			_tmp8_ = memberaccess != NULL;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			gint dim;
			ValaCCodeExpression* _tmp9_;
			dim = atoi (vala_integer_literal_get_value (lit));
			_tmp9_ = NULL;
			vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp9_ = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_member_access_get_inner (memberaccess), dim + 1)));
			(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
		}
		(lit == NULL) ? NULL : (lit = (vala_code_node_unref (lit), NULL));
		(memberaccess == NULL) ? NULL : (memberaccess = (vala_code_node_unref (memberaccess), NULL));
	} else {
		if (container_type == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type)) {
			ValaCCodeIdentifier* _tmp10_;
			ValaCCodeFunctionCall* _tmp11_;
			ValaCCodeFunctionCall* coffsetcall;
			ValaCCodeIdentifier* _tmp12_;
			ValaCCodeFunctionCall* _tmp13_;
			ValaCCodeFunctionCall* ccall;
			/* should be moved to a different module
			 access to unichar in a string*/
			_tmp10_ = NULL;
			_tmp11_ = NULL;
			coffsetcall = (_tmp11_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp10_ = vala_ccode_identifier_new ("g_utf8_offset_to_pointer"))), (_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL)), _tmp11_);
			vala_ccode_function_call_add_argument (coffsetcall, ccontainer);
			vala_ccode_function_call_add_argument (coffsetcall, cindex);
			_tmp12_ = NULL;
			_tmp13_ = NULL;
			ccall = (_tmp13_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp12_ = vala_ccode_identifier_new ("g_utf8_get_char"))), (_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL)), _tmp13_);
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) coffsetcall);
			vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall);
			(coffsetcall == NULL) ? NULL : (coffsetcall = (vala_ccode_node_unref (coffsetcall), NULL));
			(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
		} else {
			ValaCCodeElementAccess* _tmp19_;
			{
				gint i;
				/* access to element in an array*/
				i = 1;
				{
					gboolean _tmp14_;
					_tmp14_ = TRUE;
					while (TRUE) {
						ValaCCodeExpression* _tmp15_;
						ValaCCodeBinaryExpression* _tmp16_;
						ValaCCodeBinaryExpression* cmul;
						ValaCCodeExpression* _tmp18_;
						ValaExpression* _tmp17_;
						if (!_tmp14_) {
							i++;
						}
						_tmp14_ = FALSE;
						if (!(i < rank)) {
							break;
						}
						_tmp15_ = NULL;
						_tmp16_ = NULL;
						cmul = (_tmp16_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, cindex, _tmp15_ = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_element_access_get_container (expr), i + 1)), (_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL)), _tmp16_);
						_tmp18_ = NULL;
						_tmp17_ = NULL;
						cindex = (_tmp18_ = (ValaCCodeExpression*) vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) cmul, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) (_tmp17_ = (ValaExpression*) gee_list_get (indices, i))))), (cindex == NULL) ? NULL : (cindex = (vala_ccode_node_unref (cindex), NULL)), _tmp18_);
						(_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_code_node_unref (_tmp17_), NULL));
						(cmul == NULL) ? NULL : (cmul = (vala_ccode_node_unref (cmul), NULL));
					}
				}
			}
			_tmp19_ = NULL;
			vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp19_ = vala_ccode_element_access_new (ccontainer, cindex)));
			(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
		}
	}
	(indices == NULL) ? NULL : (indices = (gee_collection_object_unref (indices), NULL));
	(container_type == NULL) ? NULL : (container_type = (vala_code_node_unref (container_type), NULL));
	(ccontainer == NULL) ? NULL : (ccontainer = (vala_ccode_node_unref (ccontainer), NULL));
	(cindex == NULL) ? NULL : (cindex = (vala_ccode_node_unref (cindex), NULL));
}


static ValaCCodeForStatement* vala_ccode_array_module_get_struct_array_free_loop (ValaCCodeArrayModule* self, ValaStruct* st) {
	ValaCCodeForStatement* result;
	ValaCCodeBlock* cbody;
	ValaCCodeIdentifier* cptrarray;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeElementAccess* _tmp1_;
	ValaCCodeElementAccess* cea;
	ValaCCodeExpression* _tmp3_;
	ValaStructValueType* _tmp2_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeFunctionCall* cfreecall;
	ValaCCodeUnaryExpression* _tmp5_;
	ValaCCodeIdentifier* _tmp7_;
	ValaCCodeIdentifier* _tmp6_;
	ValaCCodeBinaryExpression* _tmp8_;
	ValaCCodeBinaryExpression* cforcond;
	ValaCCodeExpressionStatement* _tmp9_;
	ValaCCodeForStatement* cfor;
	ValaCCodeAssignment* _tmp12_;
	ValaCCodeConstant* _tmp11_;
	ValaCCodeIdentifier* _tmp10_;
	ValaCCodeAssignment* _tmp17_;
	ValaCCodeBinaryExpression* _tmp16_;
	ValaCCodeConstant* _tmp15_;
	ValaCCodeIdentifier* _tmp14_;
	ValaCCodeIdentifier* _tmp13_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (st != NULL, NULL);
	cbody = vala_ccode_block_new ();
	cptrarray = vala_ccode_identifier_new ("array");
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	cea = (_tmp1_ = vala_ccode_element_access_new ((ValaCCodeExpression*) cptrarray, (ValaCCodeExpression*) (_tmp0_ = vala_ccode_identifier_new ("i"))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL)), _tmp1_);
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	_tmp4_ = NULL;
	cfreecall = (_tmp4_ = vala_ccode_function_call_new (_tmp3_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, (ValaDataType*) (_tmp2_ = vala_struct_value_type_new (st)), FALSE)), (_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL)), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_code_node_unref (_tmp2_), NULL)), _tmp4_);
	_tmp5_ = NULL;
	vala_ccode_function_call_add_argument (cfreecall, (ValaCCodeExpression*) (_tmp5_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) cea)));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	_tmp7_ = NULL;
	_tmp6_ = NULL;
	_tmp8_ = NULL;
	cforcond = (_tmp8_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, (ValaCCodeExpression*) (_tmp6_ = vala_ccode_identifier_new ("i")), (ValaCCodeExpression*) (_tmp7_ = vala_ccode_identifier_new ("array_length"))), (_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL)), (_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL)), _tmp8_);
	_tmp9_ = NULL;
	vala_ccode_block_add_statement (cbody, (ValaCCodeNode*) (_tmp9_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cfreecall)));
	(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
	cfor = vala_ccode_for_statement_new ((ValaCCodeExpression*) cforcond, (ValaCCodeStatement*) cbody);
	_tmp12_ = NULL;
	_tmp11_ = NULL;
	_tmp10_ = NULL;
	vala_ccode_for_statement_add_initializer (cfor, (ValaCCodeExpression*) (_tmp12_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp10_ = vala_ccode_identifier_new ("i")), (ValaCCodeExpression*) (_tmp11_ = vala_ccode_constant_new ("0")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
	(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
	(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
	(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
	_tmp17_ = NULL;
	_tmp16_ = NULL;
	_tmp15_ = NULL;
	_tmp14_ = NULL;
	_tmp13_ = NULL;
	vala_ccode_for_statement_add_iterator (cfor, (ValaCCodeExpression*) (_tmp17_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp13_ = vala_ccode_identifier_new ("i")), (ValaCCodeExpression*) (_tmp16_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) (_tmp14_ = vala_ccode_identifier_new ("i")), (ValaCCodeExpression*) (_tmp15_ = vala_ccode_constant_new ("1")))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
	(_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL));
	(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
	(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
	(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
	(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
	result = cfor;
	(cbody == NULL) ? NULL : (cbody = (vala_ccode_node_unref (cbody), NULL));
	(cptrarray == NULL) ? NULL : (cptrarray = (vala_ccode_node_unref (cptrarray), NULL));
	(cea == NULL) ? NULL : (cea = (vala_ccode_node_unref (cea), NULL));
	(cfreecall == NULL) ? NULL : (cfreecall = (vala_ccode_node_unref (cfreecall), NULL));
	(cforcond == NULL) ? NULL : (cforcond = (vala_ccode_node_unref (cforcond), NULL));
	return result;
}


static char* vala_ccode_array_module_real_append_struct_array_free (ValaCCodeBaseModule* base, ValaStruct* st) {
	ValaCCodeArrayModule * self;
	char* result;
	char* _tmp0_;
	char* _tmp1_;
	char* cname;
	ValaCCodeFunction* fun;
	ValaCCodeFormalParameter* _tmp4_;
	char* _tmp3_;
	char* _tmp2_;
	ValaCCodeFormalParameter* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeBlock* cdofree;
	ValaCCodeDeclaration* citdecl;
	ValaCCodeVariableDeclarator* _tmp7_;
	ValaCCodeForStatement* _tmp8_;
	ValaCCodeConstant* _tmp10_;
	ValaCCodeIdentifier* _tmp9_;
	ValaCCodeBinaryExpression* _tmp11_;
	ValaCCodeBinaryExpression* ccondarr;
	ValaCCodeIfStatement* cif;
	ValaCCodeBlock* _tmp12_;
	ValaCCodeIdentifier* _tmp13_;
	ValaCCodeFunctionCall* _tmp14_;
	ValaCCodeFunctionCall* carrfree;
	ValaCCodeIdentifier* _tmp15_;
	ValaCCodeExpressionStatement* _tmp16_;
	self = (ValaCCodeArrayModule*) base;
	g_return_val_if_fail (st != NULL, NULL);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	cname = (_tmp1_ = g_strdup_printf ("_vala_%s_array_free", _tmp0_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	;
	if (vala_ccode_declaration_space_add_declaration (((ValaCCodeBaseModule*) self)->source_declarations, cname)) {
		result = cname;
		return result;
	}
	fun = vala_ccode_function_new (cname, "void");
	vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
	_tmp4_ = NULL;
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	vala_ccode_function_add_parameter (fun, _tmp4_ = vala_ccode_formal_parameter_new ("array", _tmp3_ = g_strdup_printf ("%s*", _tmp2_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE))));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	_tmp3_ = (g_free (_tmp3_), NULL);
	_tmp2_ = (g_free (_tmp2_), NULL);
	_tmp5_ = NULL;
	vala_ccode_function_add_parameter (fun, _tmp5_ = vala_ccode_formal_parameter_new ("array_length", "gint"));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	_tmp6_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp6_ = vala_ccode_function_copy (fun)));
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	cdofree = vala_ccode_block_new ();
	citdecl = vala_ccode_declaration_new ("int");
	_tmp7_ = NULL;
	vala_ccode_declaration_add_declarator (citdecl, (ValaCCodeDeclarator*) (_tmp7_ = vala_ccode_variable_declarator_new ("i", NULL, NULL)));
	(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
	vala_ccode_block_add_statement (cdofree, (ValaCCodeNode*) citdecl);
	_tmp8_ = NULL;
	vala_ccode_block_add_statement (cdofree, (ValaCCodeNode*) (_tmp8_ = vala_ccode_array_module_get_struct_array_free_loop (self, st)));
	(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
	_tmp10_ = NULL;
	_tmp9_ = NULL;
	_tmp11_ = NULL;
	ccondarr = (_tmp11_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) (_tmp9_ = vala_ccode_identifier_new ("array")), (ValaCCodeExpression*) (_tmp10_ = vala_ccode_constant_new ("NULL"))), (_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL)), (_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL)), _tmp11_);
	cif = vala_ccode_if_statement_new ((ValaCCodeExpression*) ccondarr, (ValaCCodeStatement*) cdofree, NULL);
	_tmp12_ = NULL;
	vala_ccode_function_set_block (fun, _tmp12_ = vala_ccode_block_new ());
	(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), (ValaCCodeNode*) cif);
	_tmp13_ = NULL;
	_tmp14_ = NULL;
	carrfree = (_tmp14_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp13_ = vala_ccode_identifier_new ("g_free"))), (_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL)), _tmp14_);
	_tmp15_ = NULL;
	vala_ccode_function_call_add_argument (carrfree, (ValaCCodeExpression*) (_tmp15_ = vala_ccode_identifier_new ("array")));
	(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
	_tmp16_ = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), (ValaCCodeNode*) (_tmp16_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) carrfree)));
	(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) fun);
	result = cname;
	(fun == NULL) ? NULL : (fun = (vala_ccode_node_unref (fun), NULL));
	(cdofree == NULL) ? NULL : (cdofree = (vala_ccode_node_unref (cdofree), NULL));
	(citdecl == NULL) ? NULL : (citdecl = (vala_ccode_node_unref (citdecl), NULL));
	(ccondarr == NULL) ? NULL : (ccondarr = (vala_ccode_node_unref (ccondarr), NULL));
	(cif == NULL) ? NULL : (cif = (vala_ccode_node_unref (cif), NULL));
	(carrfree == NULL) ? NULL : (carrfree = (vala_ccode_node_unref (carrfree), NULL));
	return result;
}


static ValaCCodeForStatement* vala_ccode_array_module_get_vala_array_free_loop (ValaCCodeArrayModule* self) {
	ValaCCodeForStatement* result;
	ValaCCodeBlock* cbody;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeCastExpression* _tmp1_;
	ValaCCodeCastExpression* cptrarray;
	ValaCCodeIdentifier* _tmp2_;
	ValaCCodeElementAccess* _tmp3_;
	ValaCCodeElementAccess* cea;
	ValaCCodeIdentifier* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	ValaCCodeFunctionCall* cfreecall;
	ValaCCodeConstant* _tmp6_;
	ValaCCodeBinaryExpression* _tmp7_;
	ValaCCodeBinaryExpression* cfreecond;
	ValaCCodeIdentifier* _tmp9_;
	ValaCCodeIdentifier* _tmp8_;
	ValaCCodeBinaryExpression* _tmp10_;
	ValaCCodeBinaryExpression* cforcond;
	ValaCCodeBlock* cfreeblock;
	ValaCCodeExpressionStatement* _tmp11_;
	ValaCCodeIfStatement* _tmp12_;
	ValaCCodeForStatement* cfor;
	ValaCCodeAssignment* _tmp15_;
	ValaCCodeConstant* _tmp14_;
	ValaCCodeIdentifier* _tmp13_;
	ValaCCodeAssignment* _tmp20_;
	ValaCCodeBinaryExpression* _tmp19_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeIdentifier* _tmp17_;
	ValaCCodeIdentifier* _tmp16_;
	g_return_val_if_fail (self != NULL, NULL);
	cbody = vala_ccode_block_new ();
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	cptrarray = (_tmp1_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp0_ = vala_ccode_identifier_new ("array")), "gpointer*"), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL)), _tmp1_);
	_tmp2_ = NULL;
	_tmp3_ = NULL;
	cea = (_tmp3_ = vala_ccode_element_access_new ((ValaCCodeExpression*) cptrarray, (ValaCCodeExpression*) (_tmp2_ = vala_ccode_identifier_new ("i"))), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL)), _tmp3_);
	_tmp4_ = NULL;
	_tmp5_ = NULL;
	cfreecall = (_tmp5_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp4_ = vala_ccode_identifier_new ("destroy_func"))), (_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL)), _tmp5_);
	vala_ccode_function_call_add_argument (cfreecall, (ValaCCodeExpression*) cea);
	_tmp6_ = NULL;
	_tmp7_ = NULL;
	cfreecond = (_tmp7_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) cea, (ValaCCodeExpression*) (_tmp6_ = vala_ccode_constant_new ("NULL"))), (_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL)), _tmp7_);
	_tmp9_ = NULL;
	_tmp8_ = NULL;
	_tmp10_ = NULL;
	cforcond = (_tmp10_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, (ValaCCodeExpression*) (_tmp8_ = vala_ccode_identifier_new ("i")), (ValaCCodeExpression*) (_tmp9_ = vala_ccode_identifier_new ("array_length"))), (_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL)), (_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL)), _tmp10_);
	cfreeblock = vala_ccode_block_new ();
	_tmp11_ = NULL;
	vala_ccode_block_add_statement (cfreeblock, (ValaCCodeNode*) (_tmp11_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cfreecall)));
	(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
	_tmp12_ = NULL;
	vala_ccode_block_add_statement (cbody, (ValaCCodeNode*) (_tmp12_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) cfreecond, (ValaCCodeStatement*) cfreeblock, NULL)));
	(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
	cfor = vala_ccode_for_statement_new ((ValaCCodeExpression*) cforcond, (ValaCCodeStatement*) cbody);
	_tmp15_ = NULL;
	_tmp14_ = NULL;
	_tmp13_ = NULL;
	vala_ccode_for_statement_add_initializer (cfor, (ValaCCodeExpression*) (_tmp15_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp13_ = vala_ccode_identifier_new ("i")), (ValaCCodeExpression*) (_tmp14_ = vala_ccode_constant_new ("0")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
	(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
	(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
	(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
	_tmp20_ = NULL;
	_tmp19_ = NULL;
	_tmp18_ = NULL;
	_tmp17_ = NULL;
	_tmp16_ = NULL;
	vala_ccode_for_statement_add_iterator (cfor, (ValaCCodeExpression*) (_tmp20_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp16_ = vala_ccode_identifier_new ("i")), (ValaCCodeExpression*) (_tmp19_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) (_tmp17_ = vala_ccode_identifier_new ("i")), (ValaCCodeExpression*) (_tmp18_ = vala_ccode_constant_new ("1")))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
	(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL));
	(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
	(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL));
	(_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL));
	(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
	result = cfor;
	(cbody == NULL) ? NULL : (cbody = (vala_ccode_node_unref (cbody), NULL));
	(cptrarray == NULL) ? NULL : (cptrarray = (vala_ccode_node_unref (cptrarray), NULL));
	(cea == NULL) ? NULL : (cea = (vala_ccode_node_unref (cea), NULL));
	(cfreecall == NULL) ? NULL : (cfreecall = (vala_ccode_node_unref (cfreecall), NULL));
	(cfreecond == NULL) ? NULL : (cfreecond = (vala_ccode_node_unref (cfreecond), NULL));
	(cforcond == NULL) ? NULL : (cforcond = (vala_ccode_node_unref (cforcond), NULL));
	(cfreeblock == NULL) ? NULL : (cfreeblock = (vala_ccode_node_unref (cfreeblock), NULL));
	return result;
}


static void vala_ccode_array_module_real_append_vala_array_free (ValaCCodeBaseModule* base) {
	ValaCCodeArrayModule * self;
	ValaCCodeFunction* fun;
	ValaCCodeFormalParameter* _tmp0_;
	ValaCCodeFormalParameter* _tmp1_;
	ValaCCodeFormalParameter* _tmp2_;
	ValaCCodeFunction* _tmp3_;
	ValaCCodeBlock* cdofree;
	ValaCCodeDeclaration* citdecl;
	ValaCCodeVariableDeclarator* _tmp4_;
	ValaCCodeForStatement* _tmp5_;
	ValaCCodeConstant* _tmp7_;
	ValaCCodeIdentifier* _tmp6_;
	ValaCCodeBinaryExpression* _tmp8_;
	ValaCCodeBinaryExpression* ccondarr;
	ValaCCodeConstant* _tmp10_;
	ValaCCodeIdentifier* _tmp9_;
	ValaCCodeBinaryExpression* _tmp11_;
	ValaCCodeBinaryExpression* ccondfunc;
	ValaCCodeBinaryExpression* _tmp12_;
	ValaCCodeIfStatement* _tmp13_;
	ValaCCodeIfStatement* cif;
	ValaCCodeBlock* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaCCodeFormalParameter* _tmp16_;
	ValaCCodeFormalParameter* _tmp17_;
	ValaCCodeFormalParameter* _tmp18_;
	ValaCCodeFunction* _tmp19_;
	ValaCCodeIdentifier* _tmp20_;
	ValaCCodeFunctionCall* _tmp21_;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp22_;
	ValaCCodeIdentifier* _tmp23_;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeBlock* _tmp25_;
	ValaCCodeExpressionStatement* _tmp26_;
	ValaCCodeIdentifier* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	ValaCCodeFunctionCall* carrfree;
	ValaCCodeIdentifier* _tmp29_;
	ValaCCodeExpressionStatement* _tmp30_;
	self = (ValaCCodeArrayModule*) base;
	/* _vala_array_destroy only frees elements but not the array itself*/
	fun = vala_ccode_function_new ("_vala_array_destroy", "void");
	vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
	_tmp0_ = NULL;
	vala_ccode_function_add_parameter (fun, _tmp0_ = vala_ccode_formal_parameter_new ("array", "gpointer"));
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL));
	_tmp1_ = NULL;
	vala_ccode_function_add_parameter (fun, _tmp1_ = vala_ccode_formal_parameter_new ("array_length", "gint"));
	(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL));
	_tmp2_ = NULL;
	vala_ccode_function_add_parameter (fun, _tmp2_ = vala_ccode_formal_parameter_new ("destroy_func", "GDestroyNotify"));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	_tmp3_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp3_ = vala_ccode_function_copy (fun)));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	cdofree = vala_ccode_block_new ();
	citdecl = vala_ccode_declaration_new ("int");
	_tmp4_ = NULL;
	vala_ccode_declaration_add_declarator (citdecl, (ValaCCodeDeclarator*) (_tmp4_ = vala_ccode_variable_declarator_new ("i", NULL, NULL)));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	vala_ccode_block_add_statement (cdofree, (ValaCCodeNode*) citdecl);
	_tmp5_ = NULL;
	vala_ccode_block_add_statement (cdofree, (ValaCCodeNode*) (_tmp5_ = vala_ccode_array_module_get_vala_array_free_loop (self)));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	_tmp7_ = NULL;
	_tmp6_ = NULL;
	_tmp8_ = NULL;
	ccondarr = (_tmp8_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) (_tmp6_ = vala_ccode_identifier_new ("array")), (ValaCCodeExpression*) (_tmp7_ = vala_ccode_constant_new ("NULL"))), (_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL)), (_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL)), _tmp8_);
	_tmp10_ = NULL;
	_tmp9_ = NULL;
	_tmp11_ = NULL;
	ccondfunc = (_tmp11_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) (_tmp9_ = vala_ccode_identifier_new ("destroy_func")), (ValaCCodeExpression*) (_tmp10_ = vala_ccode_constant_new ("NULL"))), (_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL)), (_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL)), _tmp11_);
	_tmp12_ = NULL;
	_tmp13_ = NULL;
	cif = (_tmp13_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) (_tmp12_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_AND, (ValaCCodeExpression*) ccondarr, (ValaCCodeExpression*) ccondfunc)), (ValaCCodeStatement*) cdofree, NULL), (_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL)), _tmp13_);
	_tmp14_ = NULL;
	vala_ccode_function_set_block (fun, _tmp14_ = vala_ccode_block_new ());
	(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), (ValaCCodeNode*) cif);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) fun);
	/* _vala_array_free frees elements and array*/
	_tmp15_ = NULL;
	fun = (_tmp15_ = vala_ccode_function_new ("_vala_array_free", "void"), (fun == NULL) ? NULL : (fun = (vala_ccode_node_unref (fun), NULL)), _tmp15_);
	vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
	_tmp16_ = NULL;
	vala_ccode_function_add_parameter (fun, _tmp16_ = vala_ccode_formal_parameter_new ("array", "gpointer"));
	(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
	_tmp17_ = NULL;
	vala_ccode_function_add_parameter (fun, _tmp17_ = vala_ccode_formal_parameter_new ("array_length", "gint"));
	(_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL));
	_tmp18_ = NULL;
	vala_ccode_function_add_parameter (fun, _tmp18_ = vala_ccode_formal_parameter_new ("destroy_func", "GDestroyNotify"));
	(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL));
	_tmp19_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp19_ = vala_ccode_function_copy (fun)));
	(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
	/* call _vala_array_destroy to free the array elements*/
	_tmp20_ = NULL;
	_tmp21_ = NULL;
	ccall = (_tmp21_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp20_ = vala_ccode_identifier_new ("_vala_array_destroy"))), (_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL)), _tmp21_);
	_tmp22_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp22_ = vala_ccode_identifier_new ("array")));
	(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
	_tmp23_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp23_ = vala_ccode_identifier_new ("array_length")));
	(_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL));
	_tmp24_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp24_ = vala_ccode_identifier_new ("destroy_func")));
	(_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL));
	_tmp25_ = NULL;
	vala_ccode_function_set_block (fun, _tmp25_ = vala_ccode_block_new ());
	(_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_ccode_node_unref (_tmp25_), NULL));
	_tmp26_ = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), (ValaCCodeNode*) (_tmp26_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL));
	_tmp27_ = NULL;
	_tmp28_ = NULL;
	carrfree = (_tmp28_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp27_ = vala_ccode_identifier_new ("g_free"))), (_tmp27_ == NULL) ? NULL : (_tmp27_ = (vala_ccode_node_unref (_tmp27_), NULL)), _tmp28_);
	_tmp29_ = NULL;
	vala_ccode_function_call_add_argument (carrfree, (ValaCCodeExpression*) (_tmp29_ = vala_ccode_identifier_new ("array")));
	(_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL));
	_tmp30_ = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), (ValaCCodeNode*) (_tmp30_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) carrfree)));
	(_tmp30_ == NULL) ? NULL : (_tmp30_ = (vala_ccode_node_unref (_tmp30_), NULL));
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) fun);
	(fun == NULL) ? NULL : (fun = (vala_ccode_node_unref (fun), NULL));
	(cdofree == NULL) ? NULL : (cdofree = (vala_ccode_node_unref (cdofree), NULL));
	(citdecl == NULL) ? NULL : (citdecl = (vala_ccode_node_unref (citdecl), NULL));
	(ccondarr == NULL) ? NULL : (ccondarr = (vala_ccode_node_unref (ccondarr), NULL));
	(ccondfunc == NULL) ? NULL : (ccondfunc = (vala_ccode_node_unref (ccondfunc), NULL));
	(cif == NULL) ? NULL : (cif = (vala_ccode_node_unref (cif), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(carrfree == NULL) ? NULL : (carrfree = (vala_ccode_node_unref (carrfree), NULL));
}


static void vala_ccode_array_module_real_append_vala_array_move (ValaCCodeBaseModule* base) {
	ValaCCodeArrayModule * self;
	ValaCCodeFunction* fun;
	ValaCCodeFormalParameter* _tmp0_;
	ValaCCodeFormalParameter* _tmp1_;
	ValaCCodeFormalParameter* _tmp2_;
	ValaCCodeFormalParameter* _tmp3_;
	ValaCCodeFormalParameter* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeIdentifier* _tmp6_;
	ValaCCodeCastExpression* _tmp7_;
	ValaCCodeCastExpression* array;
	ValaCCodeIdentifier* element_size;
	ValaCCodeIdentifier* length;
	ValaCCodeIdentifier* src;
	ValaCCodeIdentifier* dest;
	ValaCCodeBinaryExpression* _tmp8_;
	ValaCCodeBinaryExpression* _tmp9_;
	ValaCCodeBinaryExpression* src_address;
	ValaCCodeBinaryExpression* _tmp10_;
	ValaCCodeBinaryExpression* _tmp11_;
	ValaCCodeBinaryExpression* dest_address;
	ValaCCodeBinaryExpression* _tmp13_;
	ValaCCodeBinaryExpression* _tmp12_;
	ValaCCodeBinaryExpression* _tmp14_;
	ValaCCodeBinaryExpression* dest_end_address;
	ValaCCodeBlock* _tmp15_;
	ValaCCodeIdentifier* _tmp16_;
	ValaCCodeFunctionCall* _tmp17_;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeBinaryExpression* _tmp18_;
	ValaCCodeExpressionStatement* _tmp19_;
	ValaCCodeIdentifier* _tmp20_;
	ValaCCodeFunctionCall* _tmp21_;
	ValaCCodeFunctionCall* czero1;
	ValaCCodeConstant* _tmp22_;
	ValaCCodeBinaryExpression* _tmp24_;
	ValaCCodeBinaryExpression* _tmp23_;
	ValaCCodeBlock* czeroblock1;
	ValaCCodeExpressionStatement* _tmp25_;
	ValaCCodeIdentifier* _tmp26_;
	ValaCCodeFunctionCall* _tmp27_;
	ValaCCodeFunctionCall* czero2;
	ValaCCodeConstant* _tmp28_;
	ValaCCodeBinaryExpression* _tmp30_;
	ValaCCodeBinaryExpression* _tmp29_;
	ValaCCodeBlock* czeroblock2;
	ValaCCodeExpressionStatement* _tmp31_;
	ValaCCodeIfStatement* _tmp33_;
	ValaCCodeBinaryExpression* _tmp32_;
	self = (ValaCCodeArrayModule*) base;
	vala_ccode_declaration_space_add_include (((ValaCCodeBaseModule*) self)->source_declarations, "string.h", FALSE);
	/* assumes that overwritten array elements are null before invocation
	 FIXME will leak memory if that's not the case*/
	fun = vala_ccode_function_new ("_vala_array_move", "void");
	vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
	_tmp0_ = NULL;
	vala_ccode_function_add_parameter (fun, _tmp0_ = vala_ccode_formal_parameter_new ("array", "gpointer"));
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL));
	_tmp1_ = NULL;
	vala_ccode_function_add_parameter (fun, _tmp1_ = vala_ccode_formal_parameter_new ("element_size", "gsize"));
	(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL));
	_tmp2_ = NULL;
	vala_ccode_function_add_parameter (fun, _tmp2_ = vala_ccode_formal_parameter_new ("src", "gint"));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	_tmp3_ = NULL;
	vala_ccode_function_add_parameter (fun, _tmp3_ = vala_ccode_formal_parameter_new ("dest", "gint"));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	_tmp4_ = NULL;
	vala_ccode_function_add_parameter (fun, _tmp4_ = vala_ccode_formal_parameter_new ("length", "gint"));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	_tmp5_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp5_ = vala_ccode_function_copy (fun)));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	_tmp6_ = NULL;
	_tmp7_ = NULL;
	array = (_tmp7_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp6_ = vala_ccode_identifier_new ("array")), "char*"), (_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL)), _tmp7_);
	element_size = vala_ccode_identifier_new ("element_size");
	length = vala_ccode_identifier_new ("length");
	src = vala_ccode_identifier_new ("src");
	dest = vala_ccode_identifier_new ("dest");
	_tmp8_ = NULL;
	_tmp9_ = NULL;
	src_address = (_tmp9_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) array, (ValaCCodeExpression*) (_tmp8_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) src, (ValaCCodeExpression*) element_size))), (_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL)), _tmp9_);
	_tmp10_ = NULL;
	_tmp11_ = NULL;
	dest_address = (_tmp11_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) array, (ValaCCodeExpression*) (_tmp10_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) dest, (ValaCCodeExpression*) element_size))), (_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL)), _tmp11_);
	_tmp13_ = NULL;
	_tmp12_ = NULL;
	_tmp14_ = NULL;
	dest_end_address = (_tmp14_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) array, (ValaCCodeExpression*) (_tmp13_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) (_tmp12_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) dest, (ValaCCodeExpression*) length)), (ValaCCodeExpression*) element_size))), (_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL)), (_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL)), _tmp14_);
	_tmp15_ = NULL;
	vala_ccode_function_set_block (fun, _tmp15_ = vala_ccode_block_new ());
	(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
	_tmp16_ = NULL;
	_tmp17_ = NULL;
	ccall = (_tmp17_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp16_ = vala_ccode_identifier_new ("g_memmove"))), (_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL)), _tmp17_);
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) dest_address);
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) src_address);
	_tmp18_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp18_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) length, (ValaCCodeExpression*) element_size)));
	(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL));
	_tmp19_ = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), (ValaCCodeNode*) (_tmp19_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
	_tmp20_ = NULL;
	_tmp21_ = NULL;
	czero1 = (_tmp21_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp20_ = vala_ccode_identifier_new ("memset"))), (_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL)), _tmp21_);
	vala_ccode_function_call_add_argument (czero1, (ValaCCodeExpression*) src_address);
	_tmp22_ = NULL;
	vala_ccode_function_call_add_argument (czero1, (ValaCCodeExpression*) (_tmp22_ = vala_ccode_constant_new ("0")));
	(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
	_tmp24_ = NULL;
	_tmp23_ = NULL;
	vala_ccode_function_call_add_argument (czero1, (ValaCCodeExpression*) (_tmp24_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) (_tmp23_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, (ValaCCodeExpression*) dest, (ValaCCodeExpression*) src)), (ValaCCodeExpression*) element_size)));
	(_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL));
	(_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL));
	czeroblock1 = vala_ccode_block_new ();
	_tmp25_ = NULL;
	vala_ccode_block_add_statement (czeroblock1, (ValaCCodeNode*) (_tmp25_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) czero1)));
	(_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_ccode_node_unref (_tmp25_), NULL));
	_tmp26_ = NULL;
	_tmp27_ = NULL;
	czero2 = (_tmp27_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp26_ = vala_ccode_identifier_new ("memset"))), (_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL)), _tmp27_);
	vala_ccode_function_call_add_argument (czero2, (ValaCCodeExpression*) dest_end_address);
	_tmp28_ = NULL;
	vala_ccode_function_call_add_argument (czero2, (ValaCCodeExpression*) (_tmp28_ = vala_ccode_constant_new ("0")));
	(_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_ccode_node_unref (_tmp28_), NULL));
	_tmp30_ = NULL;
	_tmp29_ = NULL;
	vala_ccode_function_call_add_argument (czero2, (ValaCCodeExpression*) (_tmp30_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) (_tmp29_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, (ValaCCodeExpression*) src, (ValaCCodeExpression*) dest)), (ValaCCodeExpression*) element_size)));
	(_tmp30_ == NULL) ? NULL : (_tmp30_ = (vala_ccode_node_unref (_tmp30_), NULL));
	(_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL));
	czeroblock2 = vala_ccode_block_new ();
	_tmp31_ = NULL;
	vala_ccode_block_add_statement (czeroblock2, (ValaCCodeNode*) (_tmp31_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) czero2)));
	(_tmp31_ == NULL) ? NULL : (_tmp31_ = (vala_ccode_node_unref (_tmp31_), NULL));
	_tmp33_ = NULL;
	_tmp32_ = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), (ValaCCodeNode*) (_tmp33_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) (_tmp32_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, (ValaCCodeExpression*) src, (ValaCCodeExpression*) dest)), (ValaCCodeStatement*) czeroblock1, (ValaCCodeStatement*) czeroblock2)));
	(_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_ccode_node_unref (_tmp33_), NULL));
	(_tmp32_ == NULL) ? NULL : (_tmp32_ = (vala_ccode_node_unref (_tmp32_), NULL));
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) fun);
	(fun == NULL) ? NULL : (fun = (vala_ccode_node_unref (fun), NULL));
	(array == NULL) ? NULL : (array = (vala_ccode_node_unref (array), NULL));
	(element_size == NULL) ? NULL : (element_size = (vala_ccode_node_unref (element_size), NULL));
	(length == NULL) ? NULL : (length = (vala_ccode_node_unref (length), NULL));
	(src == NULL) ? NULL : (src = (vala_ccode_node_unref (src), NULL));
	(dest == NULL) ? NULL : (dest = (vala_ccode_node_unref (dest), NULL));
	(src_address == NULL) ? NULL : (src_address = (vala_ccode_node_unref (src_address), NULL));
	(dest_address == NULL) ? NULL : (dest_address = (vala_ccode_node_unref (dest_address), NULL));
	(dest_end_address == NULL) ? NULL : (dest_end_address = (vala_ccode_node_unref (dest_end_address), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(czero1 == NULL) ? NULL : (czero1 = (vala_ccode_node_unref (czero1), NULL));
	(czeroblock1 == NULL) ? NULL : (czeroblock1 = (vala_ccode_node_unref (czeroblock1), NULL));
	(czero2 == NULL) ? NULL : (czero2 = (vala_ccode_node_unref (czero2), NULL));
	(czeroblock2 == NULL) ? NULL : (czeroblock2 = (vala_ccode_node_unref (czeroblock2), NULL));
}


static void vala_ccode_array_module_real_append_vala_array_length (ValaCCodeBaseModule* base) {
	ValaCCodeArrayModule * self;
	ValaCCodeFunction* fun;
	ValaCCodeFormalParameter* _tmp0_;
	ValaCCodeFunction* _tmp1_;
	ValaCCodeBlock* block;
	ValaCCodeDeclaration* len_decl;
	ValaCCodeVariableDeclarator* _tmp3_;
	ValaCCodeConstant* _tmp2_;
	ValaCCodeBlock* non_null_block;
	ValaCCodeBlock* while_body;
	ValaCCodeExpressionStatement* _tmp6_;
	ValaCCodeUnaryExpression* _tmp5_;
	ValaCCodeIdentifier* _tmp4_;
	ValaCCodeConstant* _tmp9_;
	ValaCCodeCastExpression* _tmp8_;
	ValaCCodeIdentifier* _tmp7_;
	ValaCCodeElementAccess* _tmp10_;
	ValaCCodeElementAccess* array_element_check;
	ValaCCodeWhileStatement* _tmp11_;
	ValaCCodeIdentifier* array_check;
	ValaCCodeIfStatement* _tmp12_;
	ValaCCodeReturnStatement* _tmp14_;
	ValaCCodeIdentifier* _tmp13_;
	self = (ValaCCodeArrayModule*) base;
	fun = vala_ccode_function_new ("_vala_array_length", "gint");
	vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
	_tmp0_ = NULL;
	vala_ccode_function_add_parameter (fun, _tmp0_ = vala_ccode_formal_parameter_new ("array", "gpointer"));
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL));
	_tmp1_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp1_ = vala_ccode_function_copy (fun)));
	(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL));
	block = vala_ccode_block_new ();
	len_decl = vala_ccode_declaration_new ("int");
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	vala_ccode_declaration_add_declarator (len_decl, (ValaCCodeDeclarator*) (_tmp3_ = vala_ccode_variable_declarator_new ("length", (ValaCCodeExpression*) (_tmp2_ = vala_ccode_constant_new ("0")), NULL)));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) len_decl);
	non_null_block = vala_ccode_block_new ();
	while_body = vala_ccode_block_new ();
	_tmp6_ = NULL;
	_tmp5_ = NULL;
	_tmp4_ = NULL;
	vala_ccode_block_add_statement (while_body, (ValaCCodeNode*) (_tmp6_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp5_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, (ValaCCodeExpression*) (_tmp4_ = vala_ccode_identifier_new ("length")))))));
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	_tmp9_ = NULL;
	_tmp8_ = NULL;
	_tmp7_ = NULL;
	_tmp10_ = NULL;
	array_element_check = (_tmp10_ = vala_ccode_element_access_new ((ValaCCodeExpression*) (_tmp8_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp7_ = vala_ccode_identifier_new ("array")), "gpointer*")), (ValaCCodeExpression*) (_tmp9_ = vala_ccode_constant_new ("length"))), (_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL)), (_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL)), (_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL)), _tmp10_);
	_tmp11_ = NULL;
	vala_ccode_block_add_statement (non_null_block, (ValaCCodeNode*) (_tmp11_ = vala_ccode_while_statement_new ((ValaCCodeExpression*) array_element_check, (ValaCCodeStatement*) while_body)));
	(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
	/* return 0 if the array is NULL
	 avoids an extra NULL check on the caller side*/
	array_check = vala_ccode_identifier_new ("array");
	_tmp12_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp12_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) array_check, (ValaCCodeStatement*) non_null_block, NULL)));
	(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
	_tmp14_ = NULL;
	_tmp13_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp14_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp13_ = vala_ccode_identifier_new ("length")))));
	(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
	(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
	vala_ccode_function_set_block (fun, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) fun);
	(fun == NULL) ? NULL : (fun = (vala_ccode_node_unref (fun), NULL));
	(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
	(len_decl == NULL) ? NULL : (len_decl = (vala_ccode_node_unref (len_decl), NULL));
	(non_null_block == NULL) ? NULL : (non_null_block = (vala_ccode_node_unref (non_null_block), NULL));
	(while_body == NULL) ? NULL : (while_body = (vala_ccode_node_unref (while_body), NULL));
	(array_element_check == NULL) ? NULL : (array_element_check = (vala_ccode_node_unref (array_element_check), NULL));
	(array_check == NULL) ? NULL : (array_check = (vala_ccode_node_unref (array_check), NULL));
}


static ValaCCodeExpression* vala_ccode_array_module_real_get_ref_cexpression (ValaCCodeBaseModule* base, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node) {
	ValaCCodeArrayModule * self;
	ValaCCodeExpression* result;
	self = (ValaCCodeArrayModule*) base;
	g_return_val_if_fail (expression_type != NULL, NULL);
	g_return_val_if_fail (cexpr != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	if (VALA_IS_ARRAY_TYPE (expression_type)) {
		ValaArrayType* _tmp0_;
		ValaArrayType* array_type;
		ValaLocalVariable* decl;
		ValaCCodeExpression* ctemp;
		ValaCCodeIdentifier* _tmp2_;
		char* _tmp1_;
		ValaCCodeFunctionCall* _tmp3_;
		ValaCCodeFunctionCall* copy_call;
		ValaCCodeCommaExpression* ccomma;
		_tmp0_ = NULL;
		array_type = (_tmp0_ = VALA_ARRAY_TYPE (expression_type), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
		if (!vala_array_type_get_fixed_length (array_type)) {
			result = VALA_CCODE_BASE_MODULE_CLASS (vala_ccode_array_module_parent_class)->get_ref_cexpression ((ValaCCodeBaseModule*) VALA_CCODE_METHOD_CALL_MODULE (self), expression_type, cexpr, expr, node);
			(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
			return result;
		}
		decl = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, expression_type, FALSE, node);
		gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, decl);
		ctemp = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) decl));
		_tmp2_ = NULL;
		_tmp1_ = NULL;
		_tmp3_ = NULL;
		copy_call = (_tmp3_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp2_ = vala_ccode_identifier_new (_tmp1_ = vala_ccode_array_module_generate_array_copy_wrapper (self, array_type)))), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL)), _tmp1_ = (g_free (_tmp1_), NULL), _tmp3_);
		vala_ccode_function_call_add_argument (copy_call, cexpr);
		vala_ccode_function_call_add_argument (copy_call, ctemp);
		ccomma = vala_ccode_comma_expression_new ();
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) copy_call);
		vala_ccode_comma_expression_append_expression (ccomma, ctemp);
		result = (ValaCCodeExpression*) ccomma;
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		(decl == NULL) ? NULL : (decl = (vala_code_node_unref (decl), NULL));
		(ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL));
		(copy_call == NULL) ? NULL : (copy_call = (vala_ccode_node_unref (copy_call), NULL));
		return result;
	} else {
		result = VALA_CCODE_BASE_MODULE_CLASS (vala_ccode_array_module_parent_class)->get_ref_cexpression ((ValaCCodeBaseModule*) VALA_CCODE_METHOD_CALL_MODULE (self), expression_type, cexpr, expr, node);
		return result;
	}
}


static ValaCCodeExpression* vala_ccode_array_module_real_get_dup_func_expression (ValaCCodeBaseModule* base, ValaDataType* type, ValaSourceReference* source_reference, gboolean is_chainup) {
	ValaCCodeArrayModule * self;
	ValaCCodeExpression* result;
	self = (ValaCCodeArrayModule*) base;
	g_return_val_if_fail (type != NULL, NULL);
	if (VALA_IS_ARRAY_TYPE (type)) {
		ValaArrayType* _tmp0_;
		ValaArrayType* array_type;
		char* _tmp1_;
		ValaCCodeExpression* _tmp2_;
		_tmp0_ = NULL;
		array_type = (_tmp0_ = VALA_ARRAY_TYPE (type), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
		/* fixed length arrays use different code
		 generated by overridden get_ref_cexpression method*/
		g_assert (!vala_array_type_get_fixed_length (array_type));
		_tmp1_ = NULL;
		_tmp2_ = NULL;
		result = (_tmp2_ = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp1_ = vala_ccode_array_module_generate_array_dup_wrapper (self, array_type)), _tmp1_ = (g_free (_tmp1_), NULL), _tmp2_);
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		return result;
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	} else {
		result = VALA_CCODE_BASE_MODULE_CLASS (vala_ccode_array_module_parent_class)->get_dup_func_expression ((ValaCCodeBaseModule*) VALA_CCODE_METHOD_CALL_MODULE (self), type, source_reference, is_chainup);
		return result;
	}
}


static ValaCCodeExpression* vala_ccode_array_module_real_get_unref_expression (ValaCCodeBaseModule* base, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr) {
	ValaCCodeArrayModule * self;
	ValaCCodeExpression* result;
	self = (ValaCCodeArrayModule*) base;
	g_return_val_if_fail (cvar != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	if (VALA_IS_ARRAY_TYPE (type)) {
		ValaArrayType* _tmp0_;
		ValaArrayType* array_type;
		ValaCCodeExpression* _tmp1_;
		ValaCCodeFunctionCall* _tmp2_;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeFunctionCall* _tmp4_;
		ValaCCodeIdentifier* _tmp3_;
		ValaCCodeConstant* _tmp6_;
		char* _tmp5_;
		ValaCCodeCastExpression* _tmp8_;
		ValaCCodeExpression* _tmp7_;
		_tmp0_ = NULL;
		array_type = (_tmp0_ = VALA_ARRAY_TYPE (type), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
		if (!vala_array_type_get_fixed_length (array_type)) {
			result = VALA_CCODE_BASE_MODULE_CLASS (vala_ccode_array_module_parent_class)->get_unref_expression ((ValaCCodeBaseModule*) VALA_CCODE_METHOD_CALL_MODULE (self), cvar, type, expr);
			(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
			return result;
		}
		((ValaCCodeBaseModule*) self)->requires_array_free = TRUE;
		_tmp1_ = NULL;
		_tmp2_ = NULL;
		ccall = (_tmp2_ = vala_ccode_function_call_new (_tmp1_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, type, FALSE)), (_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL)), _tmp2_);
		_tmp4_ = NULL;
		_tmp3_ = NULL;
		ccall = (_tmp4_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp3_ = vala_ccode_identifier_new ("_vala_array_destroy"))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp4_);
		(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
		vala_ccode_function_call_add_argument (ccall, cvar);
		_tmp6_ = NULL;
		_tmp5_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp6_ = vala_ccode_constant_new (_tmp5_ = g_strdup_printf ("%d", vala_array_type_get_length (array_type)))));
		(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
		_tmp5_ = (g_free (_tmp5_), NULL);
		_tmp8_ = NULL;
		_tmp7_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp8_ = vala_ccode_cast_expression_new (_tmp7_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, vala_array_type_get_element_type (array_type), FALSE), "GDestroyNotify")));
		(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
		(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
		result = (ValaCCodeExpression*) ccall;
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		return result;
	} else {
		result = VALA_CCODE_BASE_MODULE_CLASS (vala_ccode_array_module_parent_class)->get_unref_expression ((ValaCCodeBaseModule*) VALA_CCODE_METHOD_CALL_MODULE (self), cvar, type, expr);
		return result;
	}
}


static char* vala_ccode_array_module_generate_array_dup_wrapper (ValaCCodeArrayModule* self, ValaArrayType* array_type) {
	char* result;
	char* dup_func;
	char* _tmp0_;
	ValaCCodeFunction* _tmp1_;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp3_;
	char* _tmp2_;
	ValaCCodeFormalParameter* _tmp4_;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp46_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (array_type != NULL, NULL);
	dup_func = g_strdup_printf ("_vala_array_dup%d", self->priv->next_array_dup_id = self->priv->next_array_dup_id + 1);
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, dup_func)) {
		/* wrapper already defined*/
		result = dup_func;
		return result;
	}
	/* declaration*/
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	function = (_tmp1_ = vala_ccode_function_new (dup_func, _tmp0_ = vala_data_type_get_cname ((ValaDataType*) array_type)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp3_ = vala_ccode_formal_parameter_new ("self", _tmp2_ = vala_data_type_get_cname ((ValaDataType*) array_type)));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	_tmp2_ = (g_free (_tmp2_), NULL);
	/* total length over all dimensions*/
	_tmp4_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp4_ = vala_ccode_formal_parameter_new ("length", "int"));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	/* definition*/
	block = vala_ccode_block_new ();
	if (vala_ccode_base_module_requires_copy ((ValaCCodeBaseModule*) self, vala_array_type_get_element_type (array_type))) {
		GeeArrayList* _tmp5_;
		GeeArrayList* old_temp_vars;
		char* _tmp6_;
		ValaCCodeDeclaration* _tmp7_;
		ValaCCodeDeclaration* _cdecl_;
		ValaCCodeVariableDeclarator* cvardecl;
		ValaCCodeIdentifier* _tmp8_;
		ValaCCodeFunctionCall* _tmp9_;
		ValaCCodeFunctionCall* gnew;
		ValaCCodeIdentifier* _tmp11_;
		char* _tmp10_;
		ValaCCodeIdentifier* _tmp12_;
		ValaCCodeDeclaration* idx_decl;
		ValaCCodeVariableDeclarator* _tmp13_;
		ValaCCodeBlock* loop_body;
		ValaCCodeExpressionStatement* _tmp22_;
		ValaCCodeAssignment* _tmp21_;
		ValaCCodeExpression* _tmp20_;
		ValaCCodeElementAccess* _tmp19_;
		ValaCCodeIdentifier* _tmp18_;
		ValaCCodeIdentifier* _tmp17_;
		ValaCCodeElementAccess* _tmp16_;
		ValaCCodeIdentifier* _tmp15_;
		ValaCCodeIdentifier* _tmp14_;
		ValaCCodeBinaryExpression* _tmp25_;
		ValaCCodeIdentifier* _tmp24_;
		ValaCCodeIdentifier* _tmp23_;
		ValaCCodeForStatement* _tmp26_;
		ValaCCodeForStatement* cfor;
		ValaCCodeAssignment* _tmp29_;
		ValaCCodeConstant* _tmp28_;
		ValaCCodeIdentifier* _tmp27_;
		ValaCCodeUnaryExpression* _tmp31_;
		ValaCCodeIdentifier* _tmp30_;
		ValaCCodeReturnStatement* _tmp33_;
		ValaCCodeIdentifier* _tmp32_;
		ValaCCodeFragment* cfrag;
		GeeArrayList* _tmp35_;
		GeeArrayList* _tmp34_;
		_tmp5_ = NULL;
		old_temp_vars = (_tmp5_ = ((ValaCCodeBaseModule*) self)->temp_vars, (_tmp5_ == NULL) ? NULL : gee_collection_object_ref (_tmp5_));
		_tmp6_ = NULL;
		_tmp7_ = NULL;
		_cdecl_ = (_tmp7_ = vala_ccode_declaration_new (_tmp6_ = vala_data_type_get_cname ((ValaDataType*) array_type)), _tmp6_ = (g_free (_tmp6_), NULL), _tmp7_);
		cvardecl = vala_ccode_variable_declarator_new ("result", NULL, NULL);
		vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) cvardecl);
		_tmp8_ = NULL;
		_tmp9_ = NULL;
		gnew = (_tmp9_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp8_ = vala_ccode_identifier_new ("g_new0"))), (_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL)), _tmp9_);
		_tmp11_ = NULL;
		_tmp10_ = NULL;
		vala_ccode_function_call_add_argument (gnew, (ValaCCodeExpression*) (_tmp11_ = vala_ccode_identifier_new (_tmp10_ = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))));
		(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
		_tmp10_ = (g_free (_tmp10_), NULL);
		_tmp12_ = NULL;
		vala_ccode_function_call_add_argument (gnew, (ValaCCodeExpression*) (_tmp12_ = vala_ccode_identifier_new ("length")));
		(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
		vala_ccode_variable_declarator_set_initializer (cvardecl, (ValaCCodeExpression*) gnew);
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) _cdecl_);
		idx_decl = vala_ccode_declaration_new ("int");
		_tmp13_ = NULL;
		vala_ccode_declaration_add_declarator (idx_decl, (ValaCCodeDeclarator*) (_tmp13_ = vala_ccode_variable_declarator_new ("i", NULL, NULL)));
		(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) idx_decl);
		loop_body = vala_ccode_block_new ();
		_tmp22_ = NULL;
		_tmp21_ = NULL;
		_tmp20_ = NULL;
		_tmp19_ = NULL;
		_tmp18_ = NULL;
		_tmp17_ = NULL;
		_tmp16_ = NULL;
		_tmp15_ = NULL;
		_tmp14_ = NULL;
		vala_ccode_block_add_statement (loop_body, (ValaCCodeNode*) (_tmp22_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp21_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp16_ = vala_ccode_element_access_new ((ValaCCodeExpression*) (_tmp14_ = vala_ccode_identifier_new ("result")), (ValaCCodeExpression*) (_tmp15_ = vala_ccode_identifier_new ("i")))), _tmp20_ = vala_ccode_base_module_get_ref_cexpression ((ValaCCodeBaseModule*) self, vala_array_type_get_element_type (array_type), (ValaCCodeExpression*) (_tmp19_ = vala_ccode_element_access_new ((ValaCCodeExpression*) (_tmp17_ = vala_ccode_identifier_new ("self")), (ValaCCodeExpression*) (_tmp18_ = vala_ccode_identifier_new ("i")))), NULL, (ValaCodeNode*) array_type), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
		(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
		(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL));
		(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
		(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL));
		(_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL));
		(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
		(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
		(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
		_tmp25_ = NULL;
		_tmp24_ = NULL;
		_tmp23_ = NULL;
		_tmp26_ = NULL;
		cfor = (_tmp26_ = vala_ccode_for_statement_new ((ValaCCodeExpression*) (_tmp25_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, (ValaCCodeExpression*) (_tmp23_ = vala_ccode_identifier_new ("i")), (ValaCCodeExpression*) (_tmp24_ = vala_ccode_identifier_new ("length")))), (ValaCCodeStatement*) loop_body), (_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_ccode_node_unref (_tmp25_), NULL)), (_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL)), (_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL)), _tmp26_);
		_tmp29_ = NULL;
		_tmp28_ = NULL;
		_tmp27_ = NULL;
		vala_ccode_for_statement_add_initializer (cfor, (ValaCCodeExpression*) (_tmp29_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp27_ = vala_ccode_identifier_new ("i")), (ValaCCodeExpression*) (_tmp28_ = vala_ccode_constant_new ("0")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		(_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL));
		(_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_ccode_node_unref (_tmp28_), NULL));
		(_tmp27_ == NULL) ? NULL : (_tmp27_ = (vala_ccode_node_unref (_tmp27_), NULL));
		_tmp31_ = NULL;
		_tmp30_ = NULL;
		vala_ccode_for_statement_add_iterator (cfor, (ValaCCodeExpression*) (_tmp31_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, (ValaCCodeExpression*) (_tmp30_ = vala_ccode_identifier_new ("i")))));
		(_tmp31_ == NULL) ? NULL : (_tmp31_ = (vala_ccode_node_unref (_tmp31_), NULL));
		(_tmp30_ == NULL) ? NULL : (_tmp30_ = (vala_ccode_node_unref (_tmp30_), NULL));
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) cfor);
		_tmp33_ = NULL;
		_tmp32_ = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp33_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp32_ = vala_ccode_identifier_new ("result")))));
		(_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_ccode_node_unref (_tmp33_), NULL));
		(_tmp32_ == NULL) ? NULL : (_tmp32_ = (vala_ccode_node_unref (_tmp32_), NULL));
		cfrag = vala_ccode_fragment_new ();
		vala_ccode_base_module_append_temp_decl ((ValaCCodeBaseModule*) self, cfrag, (GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars);
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) cfrag);
		_tmp35_ = NULL;
		_tmp34_ = NULL;
		((ValaCCodeBaseModule*) self)->temp_vars = (_tmp35_ = (_tmp34_ = old_temp_vars, (_tmp34_ == NULL) ? NULL : gee_collection_object_ref (_tmp34_)), (((ValaCCodeBaseModule*) self)->temp_vars == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->temp_vars = (gee_collection_object_unref (((ValaCCodeBaseModule*) self)->temp_vars), NULL)), _tmp35_);
		(old_temp_vars == NULL) ? NULL : (old_temp_vars = (gee_collection_object_unref (old_temp_vars), NULL));
		(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
		(cvardecl == NULL) ? NULL : (cvardecl = (vala_ccode_node_unref (cvardecl), NULL));
		(gnew == NULL) ? NULL : (gnew = (vala_ccode_node_unref (gnew), NULL));
		(idx_decl == NULL) ? NULL : (idx_decl = (vala_ccode_node_unref (idx_decl), NULL));
		(loop_body == NULL) ? NULL : (loop_body = (vala_ccode_node_unref (loop_body), NULL));
		(cfor == NULL) ? NULL : (cfor = (vala_ccode_node_unref (cfor), NULL));
		(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
	} else {
		ValaCCodeIdentifier* _tmp36_;
		ValaCCodeFunctionCall* _tmp37_;
		ValaCCodeFunctionCall* dup_call;
		ValaCCodeIdentifier* _tmp38_;
		ValaCCodeIdentifier* _tmp39_;
		ValaCCodeFunctionCall* _tmp40_;
		ValaCCodeFunctionCall* sizeof_call;
		ValaCCodeIdentifier* _tmp42_;
		char* _tmp41_;
		ValaCCodeBinaryExpression* _tmp44_;
		ValaCCodeIdentifier* _tmp43_;
		ValaCCodeReturnStatement* _tmp45_;
		_tmp36_ = NULL;
		_tmp37_ = NULL;
		dup_call = (_tmp37_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp36_ = vala_ccode_identifier_new ("g_memdup"))), (_tmp36_ == NULL) ? NULL : (_tmp36_ = (vala_ccode_node_unref (_tmp36_), NULL)), _tmp37_);
		_tmp38_ = NULL;
		vala_ccode_function_call_add_argument (dup_call, (ValaCCodeExpression*) (_tmp38_ = vala_ccode_identifier_new ("self")));
		(_tmp38_ == NULL) ? NULL : (_tmp38_ = (vala_ccode_node_unref (_tmp38_), NULL));
		_tmp39_ = NULL;
		_tmp40_ = NULL;
		sizeof_call = (_tmp40_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp39_ = vala_ccode_identifier_new ("sizeof"))), (_tmp39_ == NULL) ? NULL : (_tmp39_ = (vala_ccode_node_unref (_tmp39_), NULL)), _tmp40_);
		_tmp42_ = NULL;
		_tmp41_ = NULL;
		vala_ccode_function_call_add_argument (sizeof_call, (ValaCCodeExpression*) (_tmp42_ = vala_ccode_identifier_new (_tmp41_ = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))));
		(_tmp42_ == NULL) ? NULL : (_tmp42_ = (vala_ccode_node_unref (_tmp42_), NULL));
		_tmp41_ = (g_free (_tmp41_), NULL);
		_tmp44_ = NULL;
		_tmp43_ = NULL;
		vala_ccode_function_call_add_argument (dup_call, (ValaCCodeExpression*) (_tmp44_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) (_tmp43_ = vala_ccode_identifier_new ("length")), (ValaCCodeExpression*) sizeof_call)));
		(_tmp44_ == NULL) ? NULL : (_tmp44_ = (vala_ccode_node_unref (_tmp44_), NULL));
		(_tmp43_ == NULL) ? NULL : (_tmp43_ = (vala_ccode_node_unref (_tmp43_), NULL));
		_tmp45_ = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp45_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) dup_call)));
		(_tmp45_ == NULL) ? NULL : (_tmp45_ = (vala_ccode_node_unref (_tmp45_), NULL));
		(dup_call == NULL) ? NULL : (dup_call = (vala_ccode_node_unref (dup_call), NULL));
		(sizeof_call == NULL) ? NULL : (sizeof_call = (vala_ccode_node_unref (sizeof_call), NULL));
	}
	/* append to file*/
	_tmp46_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp46_ = vala_ccode_function_copy (function)));
	(_tmp46_ == NULL) ? NULL : (_tmp46_ = (vala_ccode_node_unref (_tmp46_), NULL));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	result = dup_func;
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
	return result;
}


static char* vala_ccode_array_module_generate_array_copy_wrapper (ValaCCodeArrayModule* self, ValaArrayType* array_type) {
	char* result;
	char* dup_func;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp2_;
	char* _tmp1_;
	char* _tmp0_;
	ValaCCodeFormalParameter* _tmp5_;
	char* _tmp4_;
	char* _tmp3_;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp41_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (array_type != NULL, NULL);
	dup_func = g_strdup_printf ("_vala_array_copy%d", self->priv->next_array_dup_id = self->priv->next_array_dup_id + 1);
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, dup_func)) {
		/* wrapper already defined*/
		result = dup_func;
		return result;
	}
	/* declaration*/
	function = vala_ccode_function_new (dup_func, "void");
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp2_ = NULL;
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp2_ = vala_ccode_formal_parameter_new ("self", _tmp1_ = g_strconcat (_tmp0_ = vala_data_type_get_cname ((ValaDataType*) array_type), "*", NULL)));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	_tmp1_ = (g_free (_tmp1_), NULL);
	_tmp0_ = (g_free (_tmp0_), NULL);
	_tmp5_ = NULL;
	_tmp4_ = NULL;
	_tmp3_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp5_ = vala_ccode_formal_parameter_new ("dest", _tmp4_ = g_strconcat (_tmp3_ = vala_data_type_get_cname ((ValaDataType*) array_type), "*", NULL)));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	_tmp4_ = (g_free (_tmp4_), NULL);
	_tmp3_ = (g_free (_tmp3_), NULL);
	/* definition*/
	block = vala_ccode_block_new ();
	if (vala_ccode_base_module_requires_copy ((ValaCCodeBaseModule*) self, vala_array_type_get_element_type (array_type))) {
		GeeArrayList* _tmp6_;
		GeeArrayList* old_temp_vars;
		ValaCCodeDeclaration* idx_decl;
		ValaCCodeVariableDeclarator* _tmp7_;
		ValaCCodeBlock* loop_body;
		ValaCCodeExpressionStatement* _tmp16_;
		ValaCCodeAssignment* _tmp15_;
		ValaCCodeExpression* _tmp14_;
		ValaCCodeElementAccess* _tmp13_;
		ValaCCodeIdentifier* _tmp12_;
		ValaCCodeIdentifier* _tmp11_;
		ValaCCodeElementAccess* _tmp10_;
		ValaCCodeIdentifier* _tmp9_;
		ValaCCodeIdentifier* _tmp8_;
		ValaCCodeBinaryExpression* _tmp20_;
		ValaCCodeConstant* _tmp19_;
		char* _tmp18_;
		ValaCCodeIdentifier* _tmp17_;
		ValaCCodeForStatement* _tmp21_;
		ValaCCodeForStatement* cfor;
		ValaCCodeAssignment* _tmp24_;
		ValaCCodeConstant* _tmp23_;
		ValaCCodeIdentifier* _tmp22_;
		ValaCCodeUnaryExpression* _tmp26_;
		ValaCCodeIdentifier* _tmp25_;
		ValaCCodeFragment* cfrag;
		GeeArrayList* _tmp28_;
		GeeArrayList* _tmp27_;
		_tmp6_ = NULL;
		old_temp_vars = (_tmp6_ = ((ValaCCodeBaseModule*) self)->temp_vars, (_tmp6_ == NULL) ? NULL : gee_collection_object_ref (_tmp6_));
		idx_decl = vala_ccode_declaration_new ("int");
		_tmp7_ = NULL;
		vala_ccode_declaration_add_declarator (idx_decl, (ValaCCodeDeclarator*) (_tmp7_ = vala_ccode_variable_declarator_new ("i", NULL, NULL)));
		(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) idx_decl);
		loop_body = vala_ccode_block_new ();
		_tmp16_ = NULL;
		_tmp15_ = NULL;
		_tmp14_ = NULL;
		_tmp13_ = NULL;
		_tmp12_ = NULL;
		_tmp11_ = NULL;
		_tmp10_ = NULL;
		_tmp9_ = NULL;
		_tmp8_ = NULL;
		vala_ccode_block_add_statement (loop_body, (ValaCCodeNode*) (_tmp16_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp15_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp10_ = vala_ccode_element_access_new ((ValaCCodeExpression*) (_tmp8_ = vala_ccode_identifier_new ("dest")), (ValaCCodeExpression*) (_tmp9_ = vala_ccode_identifier_new ("i")))), _tmp14_ = vala_ccode_base_module_get_ref_cexpression ((ValaCCodeBaseModule*) self, vala_array_type_get_element_type (array_type), (ValaCCodeExpression*) (_tmp13_ = vala_ccode_element_access_new ((ValaCCodeExpression*) (_tmp11_ = vala_ccode_identifier_new ("self")), (ValaCCodeExpression*) (_tmp12_ = vala_ccode_identifier_new ("i")))), NULL, (ValaCodeNode*) array_type), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
		(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
		(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
		(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
		(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
		(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
		(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
		(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
		(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
		_tmp20_ = NULL;
		_tmp19_ = NULL;
		_tmp18_ = NULL;
		_tmp17_ = NULL;
		_tmp21_ = NULL;
		cfor = (_tmp21_ = vala_ccode_for_statement_new ((ValaCCodeExpression*) (_tmp20_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, (ValaCCodeExpression*) (_tmp17_ = vala_ccode_identifier_new ("i")), (ValaCCodeExpression*) (_tmp19_ = vala_ccode_constant_new (_tmp18_ = g_strdup_printf ("%d", vala_array_type_get_length (array_type)))))), (ValaCCodeStatement*) loop_body), (_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL)), (_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL)), _tmp18_ = (g_free (_tmp18_), NULL), (_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL)), _tmp21_);
		_tmp24_ = NULL;
		_tmp23_ = NULL;
		_tmp22_ = NULL;
		vala_ccode_for_statement_add_initializer (cfor, (ValaCCodeExpression*) (_tmp24_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp22_ = vala_ccode_identifier_new ("i")), (ValaCCodeExpression*) (_tmp23_ = vala_ccode_constant_new ("0")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		(_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL));
		(_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL));
		(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
		_tmp26_ = NULL;
		_tmp25_ = NULL;
		vala_ccode_for_statement_add_iterator (cfor, (ValaCCodeExpression*) (_tmp26_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, (ValaCCodeExpression*) (_tmp25_ = vala_ccode_identifier_new ("i")))));
		(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL));
		(_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_ccode_node_unref (_tmp25_), NULL));
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) cfor);
		cfrag = vala_ccode_fragment_new ();
		vala_ccode_base_module_append_temp_decl ((ValaCCodeBaseModule*) self, cfrag, (GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars);
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) cfrag);
		_tmp28_ = NULL;
		_tmp27_ = NULL;
		((ValaCCodeBaseModule*) self)->temp_vars = (_tmp28_ = (_tmp27_ = old_temp_vars, (_tmp27_ == NULL) ? NULL : gee_collection_object_ref (_tmp27_)), (((ValaCCodeBaseModule*) self)->temp_vars == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->temp_vars = (gee_collection_object_unref (((ValaCCodeBaseModule*) self)->temp_vars), NULL)), _tmp28_);
		(old_temp_vars == NULL) ? NULL : (old_temp_vars = (gee_collection_object_unref (old_temp_vars), NULL));
		(idx_decl == NULL) ? NULL : (idx_decl = (vala_ccode_node_unref (idx_decl), NULL));
		(loop_body == NULL) ? NULL : (loop_body = (vala_ccode_node_unref (loop_body), NULL));
		(cfor == NULL) ? NULL : (cfor = (vala_ccode_node_unref (cfor), NULL));
		(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
	} else {
		ValaCCodeIdentifier* _tmp29_;
		ValaCCodeFunctionCall* _tmp30_;
		ValaCCodeFunctionCall* dup_call;
		ValaCCodeIdentifier* _tmp31_;
		ValaCCodeIdentifier* _tmp32_;
		ValaCCodeIdentifier* _tmp33_;
		ValaCCodeFunctionCall* _tmp34_;
		ValaCCodeFunctionCall* sizeof_call;
		ValaCCodeIdentifier* _tmp36_;
		char* _tmp35_;
		ValaCCodeBinaryExpression* _tmp39_;
		ValaCCodeConstant* _tmp38_;
		char* _tmp37_;
		ValaCCodeExpressionStatement* _tmp40_;
		vala_ccode_declaration_space_add_include (((ValaCCodeBaseModule*) self)->source_declarations, "string.h", FALSE);
		_tmp29_ = NULL;
		_tmp30_ = NULL;
		dup_call = (_tmp30_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp29_ = vala_ccode_identifier_new ("memcpy"))), (_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL)), _tmp30_);
		_tmp31_ = NULL;
		vala_ccode_function_call_add_argument (dup_call, (ValaCCodeExpression*) (_tmp31_ = vala_ccode_identifier_new ("dest")));
		(_tmp31_ == NULL) ? NULL : (_tmp31_ = (vala_ccode_node_unref (_tmp31_), NULL));
		_tmp32_ = NULL;
		vala_ccode_function_call_add_argument (dup_call, (ValaCCodeExpression*) (_tmp32_ = vala_ccode_identifier_new ("self")));
		(_tmp32_ == NULL) ? NULL : (_tmp32_ = (vala_ccode_node_unref (_tmp32_), NULL));
		_tmp33_ = NULL;
		_tmp34_ = NULL;
		sizeof_call = (_tmp34_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp33_ = vala_ccode_identifier_new ("sizeof"))), (_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_ccode_node_unref (_tmp33_), NULL)), _tmp34_);
		_tmp36_ = NULL;
		_tmp35_ = NULL;
		vala_ccode_function_call_add_argument (sizeof_call, (ValaCCodeExpression*) (_tmp36_ = vala_ccode_identifier_new (_tmp35_ = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))));
		(_tmp36_ == NULL) ? NULL : (_tmp36_ = (vala_ccode_node_unref (_tmp36_), NULL));
		_tmp35_ = (g_free (_tmp35_), NULL);
		_tmp39_ = NULL;
		_tmp38_ = NULL;
		_tmp37_ = NULL;
		vala_ccode_function_call_add_argument (dup_call, (ValaCCodeExpression*) (_tmp39_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) (_tmp38_ = vala_ccode_constant_new (_tmp37_ = g_strdup_printf ("%d", vala_array_type_get_length (array_type)))), (ValaCCodeExpression*) sizeof_call)));
		(_tmp39_ == NULL) ? NULL : (_tmp39_ = (vala_ccode_node_unref (_tmp39_), NULL));
		(_tmp38_ == NULL) ? NULL : (_tmp38_ = (vala_ccode_node_unref (_tmp38_), NULL));
		_tmp37_ = (g_free (_tmp37_), NULL);
		_tmp40_ = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp40_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) dup_call)));
		(_tmp40_ == NULL) ? NULL : (_tmp40_ = (vala_ccode_node_unref (_tmp40_), NULL));
		(dup_call == NULL) ? NULL : (dup_call = (vala_ccode_node_unref (dup_call), NULL));
		(sizeof_call == NULL) ? NULL : (sizeof_call = (vala_ccode_node_unref (sizeof_call), NULL));
	}
	/* append to file*/
	_tmp41_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp41_ = vala_ccode_function_copy (function)));
	(_tmp41_ == NULL) ? NULL : (_tmp41_ = (vala_ccode_node_unref (_tmp41_), NULL));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	result = dup_func;
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
	return result;
}


static char* vala_ccode_array_module_generate_array_add_wrapper (ValaCCodeArrayModule* self, ValaArrayType* array_type) {
	char* result;
	char* add_func;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp2_;
	char* _tmp1_;
	char* _tmp0_;
	ValaCCodeFormalParameter* _tmp3_;
	ValaCCodeFormalParameter* _tmp4_;
	char* typename;
	ValaCCodeExpression* value;
	ValaCCodeFormalParameter* _tmp9_;
	ValaCCodeIdentifier* _tmp10_;
	ValaCCodeUnaryExpression* _tmp11_;
	ValaCCodeUnaryExpression* array;
	ValaCCodeIdentifier* _tmp12_;
	ValaCCodeUnaryExpression* _tmp13_;
	ValaCCodeUnaryExpression* length;
	ValaCCodeIdentifier* _tmp14_;
	ValaCCodeUnaryExpression* _tmp15_;
	ValaCCodeUnaryExpression* size;
	ValaCCodeBlock* block;
	ValaCCodeIdentifier* _tmp16_;
	ValaCCodeFunctionCall* _tmp17_;
	ValaCCodeFunctionCall* renew_call;
	ValaCCodeIdentifier* _tmp19_;
	char* _tmp18_;
	ValaCCodeBlock* resize_block;
	ValaCCodeExpressionStatement* _tmp27_;
	ValaCCodeAssignment* _tmp26_;
	ValaCCodeConditionalExpression* _tmp25_;
	ValaCCodeConstant* _tmp24_;
	ValaCCodeBinaryExpression* _tmp23_;
	ValaCCodeConstant* _tmp22_;
	ValaCCodeExpressionStatement* _tmp29_;
	ValaCCodeAssignment* _tmp28_;
	ValaCCodeBinaryExpression* csizecheck;
	ValaCCodeIfStatement* _tmp30_;
	ValaCCodeExpressionStatement* _tmp34_;
	ValaCCodeAssignment* _tmp33_;
	ValaCCodeElementAccess* _tmp32_;
	ValaCCodeUnaryExpression* _tmp31_;
	ValaCCodeFunction* _tmp39_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (array_type != NULL, NULL);
	add_func = g_strdup_printf ("_vala_array_add%d", self->priv->next_array_add_id = self->priv->next_array_add_id + 1);
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, add_func)) {
		/* wrapper already defined*/
		result = add_func;
		return result;
	}
	/* declaration*/
	function = vala_ccode_function_new (add_func, "void");
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp2_ = NULL;
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp2_ = vala_ccode_formal_parameter_new ("array", _tmp1_ = g_strconcat (_tmp0_ = vala_data_type_get_cname ((ValaDataType*) array_type), "*", NULL)));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	_tmp1_ = (g_free (_tmp1_), NULL);
	_tmp0_ = (g_free (_tmp0_), NULL);
	_tmp3_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp3_ = vala_ccode_formal_parameter_new ("length", "int*"));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	_tmp4_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp4_ = vala_ccode_formal_parameter_new ("size", "int*"));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	typename = vala_data_type_get_cname (vala_array_type_get_element_type (array_type));
	value = (ValaCCodeExpression*) vala_ccode_identifier_new ("value");
	if (vala_data_type_is_real_struct_type (vala_array_type_get_element_type (array_type))) {
		gboolean _tmp5_;
		_tmp5_ = FALSE;
		if (!vala_data_type_get_nullable (vala_array_type_get_element_type (array_type))) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = !vala_data_type_get_value_owned (vala_array_type_get_element_type (array_type));
		}
		if (_tmp5_) {
			char* _tmp6_;
			_tmp6_ = NULL;
			typename = (_tmp6_ = g_strconcat ("const ", typename, NULL), typename = (g_free (typename), NULL), _tmp6_);
		}
		if (!vala_data_type_get_nullable (vala_array_type_get_element_type (array_type))) {
			char* _tmp7_;
			ValaCCodeExpression* _tmp8_;
			_tmp7_ = NULL;
			typename = (_tmp7_ = g_strconcat (typename, "*", NULL), typename = (g_free (typename), NULL), _tmp7_);
			_tmp8_ = NULL;
			value = (_tmp8_ = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, value), (value == NULL) ? NULL : (value = (vala_ccode_node_unref (value), NULL)), _tmp8_);
		}
	}
	_tmp9_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp9_ = vala_ccode_formal_parameter_new ("value", typename));
	(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
	_tmp10_ = NULL;
	_tmp11_ = NULL;
	array = (_tmp11_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp10_ = vala_ccode_identifier_new ("array"))), (_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL)), _tmp11_);
	_tmp12_ = NULL;
	_tmp13_ = NULL;
	length = (_tmp13_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp12_ = vala_ccode_identifier_new ("length"))), (_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL)), _tmp13_);
	_tmp14_ = NULL;
	_tmp15_ = NULL;
	size = (_tmp15_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp14_ = vala_ccode_identifier_new ("size"))), (_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL)), _tmp15_);
	/* definition*/
	block = vala_ccode_block_new ();
	_tmp16_ = NULL;
	_tmp17_ = NULL;
	renew_call = (_tmp17_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp16_ = vala_ccode_identifier_new ("g_renew"))), (_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL)), _tmp17_);
	_tmp19_ = NULL;
	_tmp18_ = NULL;
	vala_ccode_function_call_add_argument (renew_call, (ValaCCodeExpression*) (_tmp19_ = vala_ccode_identifier_new (_tmp18_ = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))));
	(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
	_tmp18_ = (g_free (_tmp18_), NULL);
	vala_ccode_function_call_add_argument (renew_call, (ValaCCodeExpression*) array);
	if (vala_data_type_is_reference_type_or_type_parameter (vala_array_type_get_element_type (array_type))) {
		ValaCCodeBinaryExpression* _tmp21_;
		ValaCCodeConstant* _tmp20_;
		/* NULL terminate array*/
		_tmp21_ = NULL;
		_tmp20_ = NULL;
		vala_ccode_function_call_add_argument (renew_call, (ValaCCodeExpression*) (_tmp21_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) size, (ValaCCodeExpression*) (_tmp20_ = vala_ccode_constant_new ("1")))));
		(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
		(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL));
	} else {
		vala_ccode_function_call_add_argument (renew_call, (ValaCCodeExpression*) size);
	}
	resize_block = vala_ccode_block_new ();
	_tmp27_ = NULL;
	_tmp26_ = NULL;
	_tmp25_ = NULL;
	_tmp24_ = NULL;
	_tmp23_ = NULL;
	_tmp22_ = NULL;
	vala_ccode_block_add_statement (resize_block, (ValaCCodeNode*) (_tmp27_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp26_ = vala_ccode_assignment_new ((ValaCCodeExpression*) size, (ValaCCodeExpression*) (_tmp25_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) size, (ValaCCodeExpression*) (_tmp23_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) (_tmp22_ = vala_ccode_constant_new ("2")), (ValaCCodeExpression*) size)), (ValaCCodeExpression*) (_tmp24_ = vala_ccode_constant_new ("4")))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp27_ == NULL) ? NULL : (_tmp27_ = (vala_ccode_node_unref (_tmp27_), NULL));
	(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL));
	(_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_ccode_node_unref (_tmp25_), NULL));
	(_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL));
	(_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL));
	(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
	_tmp29_ = NULL;
	_tmp28_ = NULL;
	vala_ccode_block_add_statement (resize_block, (ValaCCodeNode*) (_tmp29_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp28_ = vala_ccode_assignment_new ((ValaCCodeExpression*) array, (ValaCCodeExpression*) renew_call, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL));
	(_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_ccode_node_unref (_tmp28_), NULL));
	csizecheck = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) length, (ValaCCodeExpression*) size);
	_tmp30_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp30_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) csizecheck, (ValaCCodeStatement*) resize_block, NULL)));
	(_tmp30_ == NULL) ? NULL : (_tmp30_ = (vala_ccode_node_unref (_tmp30_), NULL));
	_tmp34_ = NULL;
	_tmp33_ = NULL;
	_tmp32_ = NULL;
	_tmp31_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp34_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp33_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp32_ = vala_ccode_element_access_new ((ValaCCodeExpression*) array, (ValaCCodeExpression*) (_tmp31_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, (ValaCCodeExpression*) length)))), value, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp34_ == NULL) ? NULL : (_tmp34_ = (vala_ccode_node_unref (_tmp34_), NULL));
	(_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_ccode_node_unref (_tmp33_), NULL));
	(_tmp32_ == NULL) ? NULL : (_tmp32_ = (vala_ccode_node_unref (_tmp32_), NULL));
	(_tmp31_ == NULL) ? NULL : (_tmp31_ = (vala_ccode_node_unref (_tmp31_), NULL));
	if (vala_data_type_is_reference_type_or_type_parameter (vala_array_type_get_element_type (array_type))) {
		ValaCCodeExpressionStatement* _tmp38_;
		ValaCCodeAssignment* _tmp37_;
		ValaCCodeConstant* _tmp36_;
		ValaCCodeElementAccess* _tmp35_;
		/* NULL terminate array*/
		_tmp38_ = NULL;
		_tmp37_ = NULL;
		_tmp36_ = NULL;
		_tmp35_ = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp38_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp37_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp35_ = vala_ccode_element_access_new ((ValaCCodeExpression*) array, (ValaCCodeExpression*) length)), (ValaCCodeExpression*) (_tmp36_ = vala_ccode_constant_new ("NULL")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp38_ == NULL) ? NULL : (_tmp38_ = (vala_ccode_node_unref (_tmp38_), NULL));
		(_tmp37_ == NULL) ? NULL : (_tmp37_ = (vala_ccode_node_unref (_tmp37_), NULL));
		(_tmp36_ == NULL) ? NULL : (_tmp36_ = (vala_ccode_node_unref (_tmp36_), NULL));
		(_tmp35_ == NULL) ? NULL : (_tmp35_ = (vala_ccode_node_unref (_tmp35_), NULL));
	}
	/* append to file*/
	_tmp39_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp39_ = vala_ccode_function_copy (function)));
	(_tmp39_ == NULL) ? NULL : (_tmp39_ = (vala_ccode_node_unref (_tmp39_), NULL));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	result = add_func;
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	typename = (g_free (typename), NULL);
	(value == NULL) ? NULL : (value = (vala_ccode_node_unref (value), NULL));
	(array == NULL) ? NULL : (array = (vala_ccode_node_unref (array), NULL));
	(length == NULL) ? NULL : (length = (vala_ccode_node_unref (length), NULL));
	(size == NULL) ? NULL : (size = (vala_ccode_node_unref (size), NULL));
	(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
	(renew_call == NULL) ? NULL : (renew_call = (vala_ccode_node_unref (renew_call), NULL));
	(resize_block == NULL) ? NULL : (resize_block = (vala_ccode_node_unref (resize_block), NULL));
	(csizecheck == NULL) ? NULL : (csizecheck = (vala_ccode_node_unref (csizecheck), NULL));
	return result;
}


static void vala_ccode_array_module_real_visit_method_call (ValaCCodeModule* base, ValaMethodCall* expr) {
	ValaCCodeArrayModule * self;
	ValaCCodeFunctionCall* _tmp1_;
	ValaCCodeNode* _tmp0_;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp3_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeIdentifier* cid;
	gboolean _tmp4_;
	ValaMemberAccess* _tmp5_;
	ValaMemberAccess* ma;
	GeeList* _tmp6_;
	ValaDataType* _tmp7_;
	ValaDataType* element_type;
	ValaCCodeIdentifier* _tmp9_;
	char* _tmp8_;
	self = (ValaCCodeArrayModule*) base;
	g_return_if_fail (expr != NULL);
	VALA_CCODE_MODULE_CLASS (vala_ccode_array_module_parent_class)->visit_method_call ((ValaCCodeModule*) VALA_CCODE_METHOD_CALL_MODULE (self), expr);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	ccall = (_tmp1_ = (_tmp0_ = vala_code_node_get_ccodenode ((ValaCodeNode*) expr), VALA_IS_CCODE_FUNCTION_CALL (_tmp0_) ? ((ValaCCodeFunctionCall*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : vala_ccode_node_ref (_tmp1_));
	if (ccall == NULL) {
		(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
		return;
	}
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	cid = (_tmp3_ = (_tmp2_ = vala_ccode_function_call_get_call (ccall), VALA_IS_CCODE_IDENTIFIER (_tmp2_) ? ((ValaCCodeIdentifier*) _tmp2_) : NULL), (_tmp3_ == NULL) ? NULL : vala_ccode_node_ref (_tmp3_));
	_tmp4_ = FALSE;
	if (cid == NULL) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = _vala_strcmp0 (vala_ccode_identifier_get_name (cid), "g_array_index") != 0;
	}
	if (_tmp4_) {
		(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
		(cid == NULL) ? NULL : (cid = (vala_ccode_node_unref (cid), NULL));
		return;
	}
	/* insert type argument in calls to g_array_index macro*/
	_tmp5_ = NULL;
	ma = (_tmp5_ = VALA_MEMBER_ACCESS (vala_method_call_get_call (expr)), (_tmp5_ == NULL) ? NULL : vala_code_node_ref (_tmp5_));
	_tmp6_ = NULL;
	_tmp7_ = NULL;
	element_type = (_tmp7_ = (ValaDataType*) gee_list_get (_tmp6_ = vala_data_type_get_type_arguments (vala_expression_get_value_type (vala_member_access_get_inner (ma))), 0), (_tmp6_ == NULL) ? NULL : (_tmp6_ = (gee_collection_object_unref (_tmp6_), NULL)), _tmp7_);
	_tmp9_ = NULL;
	_tmp8_ = NULL;
	vala_ccode_function_call_insert_argument (ccall, 1, (ValaCCodeExpression*) (_tmp9_ = vala_ccode_identifier_new (_tmp8_ = vala_data_type_get_cname (element_type))));
	(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
	_tmp8_ = (g_free (_tmp8_), NULL);
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(cid == NULL) ? NULL : (cid = (vala_ccode_node_unref (cid), NULL));
	(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
	(element_type == NULL) ? NULL : (element_type = (vala_code_node_unref (element_type), NULL));
}


static gboolean vala_ccode_array_module_is_array_add (ValaCCodeArrayModule* self, ValaAssignment* assignment) {
	gboolean result;
	ValaBinaryExpression* _tmp1_;
	ValaExpression* _tmp0_;
	ValaBinaryExpression* binary;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (assignment != NULL, FALSE);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	binary = (_tmp1_ = (_tmp0_ = vala_assignment_get_right (assignment), VALA_IS_BINARY_EXPRESSION (_tmp0_) ? ((ValaBinaryExpression*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	_tmp2_ = FALSE;
	if (binary != NULL) {
		_tmp2_ = VALA_IS_ARRAY_TYPE (vala_expression_get_value_type (vala_binary_expression_get_left (binary)));
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		if (vala_binary_expression_get_operator (binary) == VALA_BINARY_OPERATOR_PLUS) {
			if (vala_expression_get_symbol_reference (vala_assignment_get_left (assignment)) == vala_expression_get_symbol_reference (vala_binary_expression_get_left (binary))) {
				result = TRUE;
				(binary == NULL) ? NULL : (binary = (vala_code_node_unref (binary), NULL));
				return result;
			}
		}
	}
	result = FALSE;
	(binary == NULL) ? NULL : (binary = (vala_code_node_unref (binary), NULL));
	return result;
}


static void vala_ccode_array_module_real_visit_assignment (ValaCCodeModule* base, ValaAssignment* assignment) {
	ValaCCodeArrayModule * self;
	ValaBinaryExpression* _tmp1_;
	ValaExpression* _tmp0_;
	ValaBinaryExpression* binary;
	ValaExpression* _tmp2_;
	ValaExpression* array;
	ValaArrayType* _tmp3_;
	ValaArrayType* array_type;
	ValaExpression* _tmp4_;
	ValaExpression* element;
	ValaDataType* _tmp5_;
	ValaFormalParameter* value_param;
	ValaCCodeIdentifier* _tmp7_;
	char* _tmp6_;
	ValaCCodeFunctionCall* _tmp8_;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeUnaryExpression* _tmp9_;
	ValaCCodeUnaryExpression* _tmp11_;
	ValaCCodeExpression* _tmp10_;
	ValaCCodeUnaryExpression* _tmp13_;
	ValaCCodeExpression* _tmp12_;
	ValaCCodeExpression* _tmp14_;
	self = (ValaCCodeArrayModule*) base;
	g_return_if_fail (assignment != NULL);
	if (!vala_ccode_array_module_is_array_add (self, assignment)) {
		VALA_CCODE_MODULE_CLASS (vala_ccode_array_module_parent_class)->visit_assignment ((ValaCCodeModule*) VALA_CCODE_METHOD_CALL_MODULE (self), assignment);
		return;
	}
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	binary = (_tmp1_ = (_tmp0_ = vala_assignment_get_right (assignment), VALA_IS_BINARY_EXPRESSION (_tmp0_) ? ((ValaBinaryExpression*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	_tmp2_ = NULL;
	array = (_tmp2_ = vala_binary_expression_get_left (binary), (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_));
	_tmp3_ = NULL;
	array_type = (_tmp3_ = VALA_ARRAY_TYPE (vala_expression_get_value_type (array)), (_tmp3_ == NULL) ? NULL : vala_code_node_ref (_tmp3_));
	_tmp4_ = NULL;
	element = (_tmp4_ = vala_binary_expression_get_right (binary), (_tmp4_ == NULL) ? NULL : vala_code_node_ref (_tmp4_));
	vala_code_node_accept ((ValaCodeNode*) array, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	_tmp5_ = NULL;
	vala_expression_set_target_type (element, _tmp5_ = vala_data_type_copy (vala_array_type_get_element_type (array_type)));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_code_node_unref (_tmp5_), NULL));
	vala_code_node_accept ((ValaCodeNode*) element, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	value_param = vala_formal_parameter_new ("value", vala_expression_get_target_type (element), NULL);
	_tmp7_ = NULL;
	_tmp6_ = NULL;
	_tmp8_ = NULL;
	ccall = (_tmp8_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp7_ = vala_ccode_identifier_new (_tmp6_ = vala_ccode_array_module_generate_array_add_wrapper (self, array_type)))), (_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL)), _tmp6_ = (g_free (_tmp6_), NULL), _tmp8_);
	_tmp9_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp9_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) array)))));
	(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
	_tmp11_ = NULL;
	_tmp10_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp11_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp10_ = vala_ccode_module_get_array_length_cexpression ((ValaCCodeModule*) self, array, -1))));
	(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
	(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
	_tmp13_ = NULL;
	_tmp12_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp13_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp12_ = vala_ccode_module_get_array_size_cexpression ((ValaCCodeModule*) self, array))));
	(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
	(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
	_tmp14_ = NULL;
	vala_ccode_function_call_add_argument (ccall, _tmp14_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, value_param, element, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) element))));
	(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
	vala_code_node_set_ccodenode ((ValaCodeNode*) assignment, (ValaCCodeNode*) ccall);
	(binary == NULL) ? NULL : (binary = (vala_code_node_unref (binary), NULL));
	(array == NULL) ? NULL : (array = (vala_code_node_unref (array), NULL));
	(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	(element == NULL) ? NULL : (element = (vala_code_node_unref (element), NULL));
	(value_param == NULL) ? NULL : (value_param = (vala_code_node_unref (value_param), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
}


static void vala_ccode_array_module_real_generate_parameter (ValaCCodeMethodModule* base, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map) {
	ValaCCodeArrayModule * self;
	char* ctypename;
	ValaCCodeFormalParameter* _tmp2_;
	char* _tmp1_;
	ValaArrayType* _tmp3_;
	ValaArrayType* array_type;
	self = (ValaCCodeArrayModule*) base;
	g_return_if_fail (param != NULL);
	g_return_if_fail (decl_space != NULL);
	g_return_if_fail (cparam_map != NULL);
	if (!VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))) {
		VALA_CCODE_METHOD_MODULE_CLASS (vala_ccode_array_module_parent_class)->generate_parameter ((ValaCCodeMethodModule*) VALA_CCODE_METHOD_CALL_MODULE (self), param, decl_space, cparam_map, carg_map);
		return;
	}
	ctypename = vala_data_type_get_cname (vala_formal_parameter_get_parameter_type (param));
	if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
		char* _tmp0_;
		_tmp0_ = NULL;
		ctypename = (_tmp0_ = g_strconcat (ctypename, "*", NULL), ctypename = (g_free (ctypename), NULL), _tmp0_);
	}
	_tmp2_ = NULL;
	_tmp1_ = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) param, (ValaCCodeNode*) (_tmp2_ = vala_ccode_formal_parameter_new (_tmp1_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param)), ctypename)));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	_tmp1_ = (g_free (_tmp1_), NULL);
	_tmp3_ = NULL;
	array_type = (_tmp3_ = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp3_ == NULL) ? NULL : vala_code_node_ref (_tmp3_));
	vala_ccode_base_module_generate_type_declaration ((ValaCCodeBaseModule*) self, vala_array_type_get_element_type (array_type), decl_space);
	gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cparameter_position (param), FALSE)), VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode ((ValaCodeNode*) param)));
	if (carg_map != NULL) {
		ValaCCodeExpression* _tmp4_;
		_tmp4_ = NULL;
		gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cparameter_position (param), FALSE)), _tmp4_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param)));
		(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	}
	if (!vala_formal_parameter_get_no_array_length (param)) {
		char* length_ctype;
		length_ctype = g_strdup ("int");
		if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
			char* _tmp5_;
			_tmp5_ = NULL;
			length_ctype = (_tmp5_ = g_strdup ("int*"), length_ctype = (g_free (length_ctype), NULL), _tmp5_);
		}
		{
			gint dim;
			dim = 1;
			{
				gboolean _tmp6_;
				_tmp6_ = TRUE;
				while (TRUE) {
					char* _tmp8_;
					char* _tmp7_;
					ValaCCodeFormalParameter* _tmp9_;
					ValaCCodeFormalParameter* cparam;
					if (!_tmp6_) {
						dim++;
					}
					_tmp6_ = FALSE;
					if (!(dim <= vala_array_type_get_rank (array_type))) {
						break;
					}
					_tmp8_ = NULL;
					_tmp7_ = NULL;
					_tmp9_ = NULL;
					cparam = (_tmp9_ = vala_ccode_formal_parameter_new (_tmp8_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp7_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param)), dim), length_ctype), _tmp8_ = (g_free (_tmp8_), NULL), _tmp7_ = (g_free (_tmp7_), NULL), _tmp9_);
					gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_carray_length_parameter_position (param) + (0.01 * dim), FALSE)), cparam);
					if (carg_map != NULL) {
						ValaCCodeExpression* _tmp10_;
						_tmp10_ = NULL;
						gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_carray_length_parameter_position (param) + (0.01 * dim), FALSE)), _tmp10_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_ccode_formal_parameter_get_name (cparam)));
						(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
					}
					(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
				}
			}
		}
		length_ctype = (g_free (length_ctype), NULL);
	}
	ctypename = (g_free (ctypename), NULL);
	(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
}


static void vala_ccode_array_module_class_init (ValaCCodeArrayModuleClass * klass) {
	vala_ccode_array_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->finalize = vala_ccode_array_module_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeArrayModulePrivate));
	VALA_CCODE_MODULE_CLASS (klass)->visit_array_creation_expression = vala_ccode_array_module_real_visit_array_creation_expression;
	VALA_CCODE_MODULE_CLASS (klass)->get_array_length_cname = vala_ccode_array_module_real_get_array_length_cname;
	VALA_CCODE_MODULE_CLASS (klass)->get_array_length_cexpression = vala_ccode_array_module_real_get_array_length_cexpression;
	VALA_CCODE_MODULE_CLASS (klass)->get_array_size_cname = vala_ccode_array_module_real_get_array_size_cname;
	VALA_CCODE_MODULE_CLASS (klass)->get_array_size_cexpression = vala_ccode_array_module_real_get_array_size_cexpression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_element_access = vala_ccode_array_module_real_visit_element_access;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->append_struct_array_free = vala_ccode_array_module_real_append_struct_array_free;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->append_vala_array_free = vala_ccode_array_module_real_append_vala_array_free;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->append_vala_array_move = vala_ccode_array_module_real_append_vala_array_move;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->append_vala_array_length = vala_ccode_array_module_real_append_vala_array_length;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_ref_cexpression = vala_ccode_array_module_real_get_ref_cexpression;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_dup_func_expression = vala_ccode_array_module_real_get_dup_func_expression;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_unref_expression = vala_ccode_array_module_real_get_unref_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_method_call = vala_ccode_array_module_real_visit_method_call;
	VALA_CCODE_MODULE_CLASS (klass)->visit_assignment = vala_ccode_array_module_real_visit_assignment;
	VALA_CCODE_METHOD_MODULE_CLASS (klass)->generate_parameter = vala_ccode_array_module_real_generate_parameter;
}


static void vala_ccode_array_module_instance_init (ValaCCodeArrayModule * self) {
	self->priv = VALA_CCODE_ARRAY_MODULE_GET_PRIVATE (self);
	self->priv->next_array_dup_id = 0;
	self->priv->next_array_add_id = 0;
}


static void vala_ccode_array_module_finalize (ValaCCodeModule* obj) {
	ValaCCodeArrayModule * self;
	self = VALA_CCODE_ARRAY_MODULE (obj);
	VALA_CCODE_MODULE_CLASS (vala_ccode_array_module_parent_class)->finalize (obj);
}


GType vala_ccode_array_module_get_type (void) {
	static GType vala_ccode_array_module_type_id = 0;
	if (vala_ccode_array_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeArrayModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_array_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeArrayModule), 0, (GInstanceInitFunc) vala_ccode_array_module_instance_init, NULL };
		vala_ccode_array_module_type_id = g_type_register_static (VALA_TYPE_CCODE_METHOD_CALL_MODULE, "ValaCCodeArrayModule", &g_define_type_info, 0);
	}
	return vala_ccode_array_module_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




