/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valaccode.h>
#include <gee.h>
#include <float.h>
#include <math.h>


#define VALA_TYPE_CCODE_MODULE (vala_ccode_module_get_type ())
#define VALA_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModule))
#define VALA_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))
#define VALA_IS_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MODULE))
#define VALA_IS_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MODULE))
#define VALA_CCODE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))

typedef struct _ValaCCodeModule ValaCCodeModule;
typedef struct _ValaCCodeModuleClass ValaCCodeModuleClass;
typedef struct _ValaCCodeModulePrivate ValaCCodeModulePrivate;

#define VALA_TYPE_CCODE_BASE_MODULE (vala_ccode_base_module_get_type ())
#define VALA_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModule))
#define VALA_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))
#define VALA_IS_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_IS_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_CCODE_BASE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))

typedef struct _ValaCCodeBaseModule ValaCCodeBaseModule;
typedef struct _ValaCCodeBaseModuleClass ValaCCodeBaseModuleClass;
typedef struct _ValaCCodeBaseModulePrivate ValaCCodeBaseModulePrivate;

#define VALA_TYPE_CCODE_DECLARATION_SPACE (vala_ccode_declaration_space_get_type ())
#define VALA_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpace))
#define VALA_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))
#define VALA_IS_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_IS_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_CCODE_DECLARATION_SPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))

typedef struct _ValaCCodeDeclarationSpace ValaCCodeDeclarationSpace;
typedef struct _ValaCCodeDeclarationSpaceClass ValaCCodeDeclarationSpaceClass;

#define VALA_TYPE_CCODE_STRUCT_MODULE (vala_ccode_struct_module_get_type ())
#define VALA_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModule))
#define VALA_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))
#define VALA_IS_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_IS_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_CCODE_STRUCT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))

typedef struct _ValaCCodeStructModule ValaCCodeStructModule;
typedef struct _ValaCCodeStructModuleClass ValaCCodeStructModuleClass;
typedef struct _ValaCCodeStructModulePrivate ValaCCodeStructModulePrivate;

#define VALA_TYPE_CCODE_METHOD_MODULE (vala_ccode_method_module_get_type ())
#define VALA_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModule))
#define VALA_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))
#define VALA_IS_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_IS_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_CCODE_METHOD_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))

typedef struct _ValaCCodeMethodModule ValaCCodeMethodModule;
typedef struct _ValaCCodeMethodModuleClass ValaCCodeMethodModuleClass;
typedef struct _ValaCCodeMethodModulePrivate ValaCCodeMethodModulePrivate;

#define VALA_TYPE_CCODE_CONTROL_FLOW_MODULE (vala_ccode_control_flow_module_get_type ())
#define VALA_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModule))
#define VALA_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_CCODE_CONTROL_FLOW_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))

typedef struct _ValaCCodeControlFlowModule ValaCCodeControlFlowModule;
typedef struct _ValaCCodeControlFlowModuleClass ValaCCodeControlFlowModuleClass;
typedef struct _ValaCCodeControlFlowModulePrivate ValaCCodeControlFlowModulePrivate;

#define VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE (vala_ccode_member_access_module_get_type ())
#define VALA_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModule))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))

typedef struct _ValaCCodeMemberAccessModule ValaCCodeMemberAccessModule;
typedef struct _ValaCCodeMemberAccessModuleClass ValaCCodeMemberAccessModuleClass;
typedef struct _ValaCCodeMemberAccessModulePrivate ValaCCodeMemberAccessModulePrivate;

#define VALA_TYPE_CCODE_ASSIGNMENT_MODULE (vala_ccode_assignment_module_get_type ())
#define VALA_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModule))
#define VALA_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_CCODE_ASSIGNMENT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))

typedef struct _ValaCCodeAssignmentModule ValaCCodeAssignmentModule;
typedef struct _ValaCCodeAssignmentModuleClass ValaCCodeAssignmentModuleClass;
typedef struct _ValaCCodeAssignmentModulePrivate ValaCCodeAssignmentModulePrivate;

#define VALA_TYPE_CCODE_METHOD_CALL_MODULE (vala_ccode_method_call_module_get_type ())
#define VALA_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModule))
#define VALA_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))
#define VALA_IS_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_IS_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_CCODE_METHOD_CALL_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))

typedef struct _ValaCCodeMethodCallModule ValaCCodeMethodCallModule;
typedef struct _ValaCCodeMethodCallModuleClass ValaCCodeMethodCallModuleClass;
typedef struct _ValaCCodeMethodCallModulePrivate ValaCCodeMethodCallModulePrivate;

#define VALA_TYPE_CCODE_GENERATOR (vala_ccode_generator_get_type ())
#define VALA_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGenerator))
#define VALA_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))
#define VALA_IS_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_GENERATOR))
#define VALA_IS_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_GENERATOR))
#define VALA_CCODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))

typedef struct _ValaCCodeGenerator ValaCCodeGenerator;
typedef struct _ValaCCodeGeneratorClass ValaCCodeGeneratorClass;

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeModule {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeModulePrivate * priv;
};

struct _ValaCCodeModuleClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeModule *self);
	void (*emit) (ValaCCodeModule* self, ValaCodeContext* context);
	void (*visit_source_file) (ValaCCodeModule* self, ValaSourceFile* source_file);
	void (*visit_class) (ValaCCodeModule* self, ValaClass* cl);
	void (*visit_interface) (ValaCCodeModule* self, ValaInterface* iface);
	void (*visit_struct) (ValaCCodeModule* self, ValaStruct* st);
	void (*visit_enum) (ValaCCodeModule* self, ValaEnum* en);
	void (*visit_error_domain) (ValaCCodeModule* self, ValaErrorDomain* edomain);
	void (*visit_delegate) (ValaCCodeModule* self, ValaDelegate* d);
	void (*visit_member) (ValaCCodeModule* self, ValaMember* m);
	void (*visit_constant) (ValaCCodeModule* self, ValaConstant* c);
	void (*visit_field) (ValaCCodeModule* self, ValaField* f);
	void (*visit_method) (ValaCCodeModule* self, ValaMethod* m);
	void (*visit_creation_method) (ValaCCodeModule* self, ValaCreationMethod* m);
	void (*visit_formal_parameter) (ValaCCodeModule* self, ValaFormalParameter* p);
	void (*visit_property) (ValaCCodeModule* self, ValaProperty* prop);
	void (*visit_property_accessor) (ValaCCodeModule* self, ValaPropertyAccessor* acc);
	void (*visit_signal) (ValaCCodeModule* self, ValaSignal* sig);
	void (*visit_constructor) (ValaCCodeModule* self, ValaConstructor* c);
	void (*visit_destructor) (ValaCCodeModule* self, ValaDestructor* d);
	void (*visit_block) (ValaCCodeModule* self, ValaBlock* b);
	void (*visit_empty_statement) (ValaCCodeModule* self, ValaEmptyStatement* stmt);
	void (*visit_declaration_statement) (ValaCCodeModule* self, ValaDeclarationStatement* stmt);
	void (*visit_local_variable) (ValaCCodeModule* self, ValaLocalVariable* local);
	void (*visit_initializer_list) (ValaCCodeModule* self, ValaInitializerList* list);
	void (*visit_end_full_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_expression_statement) (ValaCCodeModule* self, ValaExpressionStatement* stmt);
	void (*visit_if_statement) (ValaCCodeModule* self, ValaIfStatement* stmt);
	void (*visit_switch_statement) (ValaCCodeModule* self, ValaSwitchStatement* stmt);
	void (*visit_switch_section) (ValaCCodeModule* self, ValaSwitchSection* section);
	void (*visit_switch_label) (ValaCCodeModule* self, ValaSwitchLabel* label);
	void (*visit_loop) (ValaCCodeModule* self, ValaLoop* stmt);
	void (*visit_foreach_statement) (ValaCCodeModule* self, ValaForeachStatement* stmt);
	void (*visit_break_statement) (ValaCCodeModule* self, ValaBreakStatement* stmt);
	void (*visit_continue_statement) (ValaCCodeModule* self, ValaContinueStatement* stmt);
	void (*visit_return_statement) (ValaCCodeModule* self, ValaReturnStatement* stmt);
	void (*visit_yield_statement) (ValaCCodeModule* self, ValaYieldStatement* stmt);
	void (*visit_throw_statement) (ValaCCodeModule* self, ValaThrowStatement* stmt);
	void (*visit_try_statement) (ValaCCodeModule* self, ValaTryStatement* stmt);
	void (*visit_catch_clause) (ValaCCodeModule* self, ValaCatchClause* clause);
	void (*visit_lock_statement) (ValaCCodeModule* self, ValaLockStatement* stmt);
	void (*visit_delete_statement) (ValaCCodeModule* self, ValaDeleteStatement* stmt);
	void (*visit_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_array_creation_expression) (ValaCCodeModule* self, ValaArrayCreationExpression* expr);
	void (*visit_boolean_literal) (ValaCCodeModule* self, ValaBooleanLiteral* expr);
	void (*visit_character_literal) (ValaCCodeModule* self, ValaCharacterLiteral* expr);
	void (*visit_integer_literal) (ValaCCodeModule* self, ValaIntegerLiteral* expr);
	void (*visit_real_literal) (ValaCCodeModule* self, ValaRealLiteral* expr);
	void (*visit_string_literal) (ValaCCodeModule* self, ValaStringLiteral* expr);
	void (*visit_null_literal) (ValaCCodeModule* self, ValaNullLiteral* expr);
	void (*visit_member_access) (ValaCCodeModule* self, ValaMemberAccess* expr);
	void (*visit_method_call) (ValaCCodeModule* self, ValaMethodCall* expr);
	void (*visit_element_access) (ValaCCodeModule* self, ValaElementAccess* expr);
	void (*visit_base_access) (ValaCCodeModule* self, ValaBaseAccess* expr);
	void (*visit_postfix_expression) (ValaCCodeModule* self, ValaPostfixExpression* expr);
	void (*visit_object_creation_expression) (ValaCCodeModule* self, ValaObjectCreationExpression* expr);
	void (*visit_sizeof_expression) (ValaCCodeModule* self, ValaSizeofExpression* expr);
	void (*visit_typeof_expression) (ValaCCodeModule* self, ValaTypeofExpression* expr);
	void (*visit_unary_expression) (ValaCCodeModule* self, ValaUnaryExpression* expr);
	void (*visit_cast_expression) (ValaCCodeModule* self, ValaCastExpression* expr);
	void (*visit_pointer_indirection) (ValaCCodeModule* self, ValaPointerIndirection* expr);
	void (*visit_addressof_expression) (ValaCCodeModule* self, ValaAddressofExpression* expr);
	void (*visit_reference_transfer_expression) (ValaCCodeModule* self, ValaReferenceTransferExpression* expr);
	void (*visit_binary_expression) (ValaCCodeModule* self, ValaBinaryExpression* expr);
	void (*visit_type_check) (ValaCCodeModule* self, ValaTypeCheck* expr);
	void (*visit_lambda_expression) (ValaCCodeModule* self, ValaLambdaExpression* l);
	void (*visit_assignment) (ValaCCodeModule* self, ValaAssignment* a);
	char* (*get_custom_creturn_type) (ValaCCodeModule* self, ValaMethod* m);
	void (*generate_dynamic_method_wrapper) (ValaCCodeModule* self, ValaDynamicMethod* method);
	gboolean (*method_has_wrapper) (ValaCCodeModule* self, ValaMethod* method);
	ValaCCodeIdentifier* (*get_value_setter_function) (ValaCCodeModule* self, ValaDataType* type_reference);
	ValaCCodeExpression* (*get_construct_property_assignment) (ValaCCodeModule* self, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value);
	ValaCCodeFunctionCall* (*get_param_spec) (ValaCCodeModule* self, ValaProperty* prop);
	ValaCCodeFunctionCall* (*get_signal_creation) (ValaCCodeModule* self, ValaSignal* sig, ValaTypeSymbol* type);
	ValaCCodeFragment* (*register_dbus_info) (ValaCCodeModule* self, ValaObjectTypeSymbol* bindable);
	char* (*get_dynamic_property_getter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_property_setter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_signal_cname) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_connect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_disconnect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	void (*generate_marshaller) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, gboolean dbus);
	char* (*get_marshaller_function) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, const char* prefix, gboolean dbus);
	char* (*get_array_length_cname) (ValaCCodeModule* self, const char* array_cname, gint dim);
	ValaCCodeExpression* (*get_array_length_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
	char* (*get_array_size_cname) (ValaCCodeModule* self, const char* array_cname);
	ValaCCodeExpression* (*get_array_size_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr);
	void (*add_simple_check) (ValaCCodeModule* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
};

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeBaseModule {
	ValaCCodeModule parent_instance;
	ValaCCodeBaseModulePrivate * priv;
	ValaSymbol* root_symbol;
	ValaSymbol* current_symbol;
	ValaTypeSymbol* current_type_symbol;
	ValaClass* current_class;
	ValaMethod* current_method;
	ValaDataType* current_return_type;
	ValaTryStatement* current_try;
	ValaPropertyAccessor* current_property_accessor;
	ValaCCodeDeclarationSpace* header_declarations;
	ValaCCodeDeclarationSpace* internal_header_declarations;
	ValaCCodeDeclarationSpace* source_declarations;
	ValaCCodeFragment* source_signal_marshaller_declaration;
	ValaCCodeFragment* source_type_member_definition;
	ValaCCodeFragment* class_init_fragment;
	ValaCCodeFragment* base_init_fragment;
	ValaCCodeFragment* class_finalize_fragment;
	ValaCCodeFragment* base_finalize_fragment;
	ValaCCodeFragment* instance_init_fragment;
	ValaCCodeFragment* instance_finalize_fragment;
	ValaCCodeFragment* source_signal_marshaller_definition;
	ValaCCodeFragment* module_init_fragment;
	ValaCCodeStruct* param_spec_struct;
	ValaCCodeStruct* closure_struct;
	ValaCCodeEnum* prop_enum;
	ValaCCodeFunction* function;
	ValaCCodeFragment* pre_statement_fragment;
	GeeArrayList* temp_vars;
	GeeArrayList* temp_ref_vars;
	GeeSet* user_marshal_set;
	GeeSet* predefined_marshal_set;
	gint next_temp_var_id;
	gboolean in_creation_method;
	gboolean in_constructor;
	gboolean in_static_or_class_ctor;
	gboolean current_method_inner_error;
	gint next_coroutine_state;
	ValaDataType* bool_type;
	ValaDataType* char_type;
	ValaDataType* uchar_type;
	ValaDataType* unichar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* int8_type;
	ValaDataType* uint8_type;
	ValaDataType* int16_type;
	ValaDataType* uint16_type;
	ValaDataType* int32_type;
	ValaDataType* uint32_type;
	ValaDataType* int64_type;
	ValaDataType* uint64_type;
	ValaDataType* string_type;
	ValaDataType* float_type;
	ValaDataType* double_type;
	ValaTypeSymbol* gtype_type;
	ValaTypeSymbol* gobject_type;
	ValaErrorType* gerror_type;
	ValaClass* glist_type;
	ValaClass* gslist_type;
	ValaClass* gvaluearray_type;
	ValaTypeSymbol* gstringbuilder_type;
	ValaTypeSymbol* garray_type;
	ValaTypeSymbol* gbytearray_type;
	ValaTypeSymbol* gptrarray_type;
	ValaDataType* gquark_type;
	ValaStruct* gvalue_type;
	ValaStruct* mutex_type;
	ValaTypeSymbol* type_module_type;
	ValaTypeSymbol* dbus_object_type;
	gboolean in_plugin;
	char* module_init_param_name;
	gboolean gvaluecollector_h_needed;
	gboolean requires_array_free;
	gboolean requires_array_move;
	gboolean requires_array_length;
	gboolean requires_strcmp0;
	gboolean dbus_glib_h_needed;
	gboolean dbus_glib_h_needed_in_header;
	GeeSet* wrappers;
	GeeMap* variable_name_map;
};

struct _ValaCCodeBaseModuleClass {
	ValaCCodeModuleClass parent_class;
	void (*append_vala_array_free) (ValaCCodeBaseModule* self);
	void (*append_vala_array_move) (ValaCCodeBaseModule* self);
	void (*append_vala_array_length) (ValaCCodeBaseModule* self);
	void (*generate_class_struct_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_struct_declaration) (ValaCCodeBaseModule* self, ValaStruct* st, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_delegate_declaration) (ValaCCodeBaseModule* self, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_cparameters) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
	ValaCCodeExpression* (*get_dup_func_expression) (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference, gboolean is_chainup);
	char* (*append_struct_array_free) (ValaCCodeBaseModule* self, ValaStruct* st);
	ValaCCodeExpression* (*get_unref_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr);
	void (*append_local_free) (ValaCCodeBaseModule* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, gboolean stop_at_loop);
	gboolean (*variable_accessible_in_finally) (ValaCCodeBaseModule* self, ValaLocalVariable* local);
	char* (*get_delegate_target_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_delegate_target_cexpression) (ValaCCodeBaseModule* self, ValaExpression* delegate_expr);
	char* (*get_delegate_target_destroy_notify_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_ref_cexpression) (ValaCCodeBaseModule* self, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node);
	void (*generate_class_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_interface_declaration) (ValaCCodeBaseModule* self, ValaInterface* iface, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_method_declaration) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_error_domain_declaration) (ValaCCodeBaseModule* self, ValaErrorDomain* edomain, ValaCCodeDeclarationSpace* decl_space);
	ValaCCodeExpression* (*get_implicit_cast_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
	gboolean (*is_gobject_property) (ValaCCodeBaseModule* self, ValaProperty* prop);
};

struct _ValaCCodeStructModule {
	ValaCCodeBaseModule parent_instance;
	ValaCCodeStructModulePrivate * priv;
};

struct _ValaCCodeStructModuleClass {
	ValaCCodeBaseModuleClass parent_class;
};

/**
 * The link between a method and generated code.
 */
struct _ValaCCodeMethodModule {
	ValaCCodeStructModule parent_instance;
	ValaCCodeMethodModulePrivate * priv;
};

struct _ValaCCodeMethodModuleClass {
	ValaCCodeStructModuleClass parent_class;
	void (*generate_method_result_declaration) (ValaCCodeMethodModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeFunction* cfunc, GeeMap* cparam_map, GeeMap* carg_map);
	void (*generate_parameter) (ValaCCodeMethodModule* self, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map);
};

struct _ValaCCodeControlFlowModule {
	ValaCCodeMethodModule parent_instance;
	ValaCCodeControlFlowModulePrivate * priv;
};

struct _ValaCCodeControlFlowModuleClass {
	ValaCCodeMethodModuleClass parent_class;
};

struct _ValaCCodeMemberAccessModule {
	ValaCCodeControlFlowModule parent_instance;
	ValaCCodeMemberAccessModulePrivate * priv;
};

struct _ValaCCodeMemberAccessModuleClass {
	ValaCCodeControlFlowModuleClass parent_class;
};

/**
 * The link between an assignment and generated code.
 */
struct _ValaCCodeAssignmentModule {
	ValaCCodeMemberAccessModule parent_instance;
	ValaCCodeAssignmentModulePrivate * priv;
};

struct _ValaCCodeAssignmentModuleClass {
	ValaCCodeMemberAccessModuleClass parent_class;
};

struct _ValaCCodeMethodCallModule {
	ValaCCodeAssignmentModule parent_instance;
	ValaCCodeMethodCallModulePrivate * priv;
};

struct _ValaCCodeMethodCallModuleClass {
	ValaCCodeAssignmentModuleClass parent_class;
};


static gpointer vala_ccode_method_call_module_parent_class = NULL;

gpointer vala_ccode_module_ref (gpointer instance);
void vala_ccode_module_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_module (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_module (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_module (const GValue* value);
GType vala_ccode_module_get_type (void);
GType vala_ccode_base_module_get_type (void);
gpointer vala_ccode_declaration_space_ref (gpointer instance);
void vala_ccode_declaration_space_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_declaration_space (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_declaration_space (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_declaration_space (const GValue* value);
GType vala_ccode_declaration_space_get_type (void);
GType vala_ccode_struct_module_get_type (void);
GType vala_ccode_method_module_get_type (void);
GType vala_ccode_control_flow_module_get_type (void);
GType vala_ccode_member_access_module_get_type (void);
GType vala_ccode_assignment_module_get_type (void);
GType vala_ccode_method_call_module_get_type (void);
enum  {
	VALA_CCODE_METHOD_CALL_MODULE_DUMMY_PROPERTY
};
GType vala_ccode_generator_get_type (void);
ValaCCodeAssignmentModule* vala_ccode_assignment_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeAssignmentModule* vala_ccode_assignment_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeMethodCallModule* vala_ccode_method_call_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeMethodCallModule* vala_ccode_method_call_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeGenerator* vala_ccode_module_get_codegen (ValaCCodeModule* self);
void vala_ccode_base_module_generate_method_declaration (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space);
gint vala_ccode_base_module_get_param_pos (ValaCCodeBaseModule* self, double param_pos, gboolean ellipsis);
ValaCodeContext* vala_ccode_base_module_get_context (ValaCCodeBaseModule* self);
void vala_ccode_base_module_add_generic_type_arguments (ValaCCodeBaseModule* self, ValaCCodeFunctionCall* ccall, GeeList* type_args, ValaCodeNode* expr, gboolean is_chainup);
ValaLocalVariable* vala_ccode_base_module_get_temp_variable (ValaCCodeBaseModule* self, ValaDataType* type, gboolean value_owned, ValaCodeNode* node_reference);
ValaCCodeExpression* vala_ccode_base_module_get_variable_cexpression (ValaCCodeBaseModule* self, const char* name);
ValaCCodeModule* vala_ccode_module_get_head (ValaCCodeModule* self);
void vala_ccode_module_generate_dynamic_method_wrapper (ValaCCodeModule* self, ValaDynamicMethod* method);
ValaCCodeExpression* vala_ccode_module_get_array_length_cexpression (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
ValaCCodeExpression* vala_ccode_base_module_get_delegate_target_cexpression (ValaCCodeBaseModule* self, ValaExpression* delegate_expr);
ValaCCodeExpression* vala_ccode_base_module_get_dup_func_expression (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference, gboolean is_chainup);
ValaCCodeExpression* vala_ccode_base_module_get_destroy_func_expression (ValaCCodeBaseModule* self, ValaDataType* type, gboolean is_chainup);
ValaCCodeExpression* vala_ccode_base_module_handle_struct_argument (ValaCCodeBaseModule* self, ValaFormalParameter* param, ValaExpression* arg, ValaCCodeExpression* cexpr);
gboolean vala_ccode_base_module_requires_destroy (ValaCCodeBaseModule* self, ValaDataType* type);
ValaCCodeExpression* vala_ccode_base_module_transform_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
ValaCCodeExpression* vala_ccode_base_module_get_unref_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr);
void vala_ccode_declaration_space_add_include (ValaCCodeDeclarationSpace* self, const char* filename, gboolean local);
static void vala_ccode_method_call_module_real_visit_method_call (ValaCCodeModule* base, ValaMethodCall* expr);
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaCCodeMethodCallModule* vala_ccode_method_call_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeMethodCallModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type, codegen, next);
	return self;
}


ValaCCodeMethodCallModule* vala_ccode_method_call_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE, codegen, next);
}


static void vala_ccode_method_call_module_real_visit_method_call (ValaCCodeModule* base, ValaMethodCall* expr) {
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeFunctionCall* async_call;
	ValaMethod* m;
	ValaDelegate* deleg;
	GeeList* params;
	ValaMemberAccess* _tmp1_;
	ValaExpression* _tmp0_;
	ValaMemberAccess* ma;
	ValaDataType* _tmp2_;
	ValaDataType* itype;
	GeeList* _tmp3_;
	GeeHashMap* in_arg_map;
	GeeHashMap* out_arg_map;
	gboolean _tmp21_;
	gboolean _tmp22_;
	ValaCCodeExpression* _tmp59_;
	ValaCCodeExpression* ccall_expr;
	ValaCCodeExpression* instance;
	gboolean _tmp63_;
	gboolean _tmp64_;
	gboolean ellipsis;
	gint i;
	gint arg_pos;
	GeeIterator* params_it;
	gboolean _tmp233_;
	gboolean _tmp250_;
	gboolean _tmp267_;
	gboolean _tmp278_;
	gboolean _tmp290_;
	gint last_pos;
	gint min_pos;
	gboolean _tmp310_;
	gboolean _tmp311_;
	gboolean _tmp313_;
	gboolean _tmp314_;
	gboolean _tmp315_;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	/* the bare function call*/
	ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_method_call_get_call (expr))));
	async_call = NULL;
	m = NULL;
	deleg = NULL;
	params = NULL;
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	ma = (_tmp1_ = (_tmp0_ = vala_method_call_get_call (expr), VALA_IS_MEMBER_ACCESS (_tmp0_) ? ((ValaMemberAccess*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	_tmp2_ = NULL;
	itype = (_tmp2_ = vala_expression_get_value_type (vala_method_call_get_call (expr)), (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_));
	_tmp3_ = NULL;
	params = (_tmp3_ = vala_data_type_get_parameters (itype), (params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL)), _tmp3_);
	if (VALA_IS_METHOD_TYPE (itype)) {
		ValaMethod* _tmp5_;
		ValaMethod* _tmp4_;
		g_assert (ma != NULL);
		_tmp5_ = NULL;
		_tmp4_ = NULL;
		m = (_tmp5_ = (_tmp4_ = vala_method_type_get_method_symbol (VALA_METHOD_TYPE (itype)), (_tmp4_ == NULL) ? NULL : vala_code_node_ref (_tmp4_)), (m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL)), _tmp5_);
	} else {
		if (VALA_IS_SIGNAL_TYPE (itype)) {
			ValaSignalType* _tmp6_;
			ValaSignalType* sig_type;
			gboolean _tmp7_;
			gboolean _tmp8_;
			_tmp6_ = NULL;
			sig_type = (_tmp6_ = VALA_SIGNAL_TYPE (itype), (_tmp6_ == NULL) ? NULL : vala_code_node_ref (_tmp6_));
			_tmp7_ = FALSE;
			_tmp8_ = FALSE;
			if (ma != NULL) {
				_tmp8_ = VALA_IS_BASE_ACCESS (vala_member_access_get_inner (ma));
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				_tmp7_ = vala_signal_get_is_virtual (vala_signal_type_get_signal_symbol (sig_type));
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				ValaMethod* _tmp10_;
				ValaMethod* _tmp9_;
				_tmp10_ = NULL;
				_tmp9_ = NULL;
				m = (_tmp10_ = (_tmp9_ = vala_signal_get_default_handler (vala_signal_type_get_signal_symbol (sig_type)), (_tmp9_ == NULL) ? NULL : vala_code_node_ref (_tmp9_)), (m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL)), _tmp10_);
			} else {
				ValaCCodeFunctionCall* _tmp12_;
				ValaCCodeFunctionCall* _tmp11_;
				_tmp12_ = NULL;
				_tmp11_ = NULL;
				ccall = (_tmp12_ = (_tmp11_ = VALA_CCODE_FUNCTION_CALL (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_method_call_get_call (expr))), (_tmp11_ == NULL) ? NULL : vala_ccode_node_ref (_tmp11_)), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp12_);
			}
			(sig_type == NULL) ? NULL : (sig_type = (vala_code_node_unref (sig_type), NULL));
		} else {
			if (VALA_IS_OBJECT_TYPE (itype)) {
				ValaClass* _tmp13_;
				ValaClass* cl;
				ValaMethod* _tmp15_;
				ValaMethod* _tmp14_;
				ValaCCodeFunctionCall* _tmp18_;
				ValaCCodeIdentifier* _tmp17_;
				char* _tmp16_;
				/* constructor*/
				_tmp13_ = NULL;
				cl = (_tmp13_ = VALA_CLASS (vala_object_type_get_type_symbol (VALA_OBJECT_TYPE (itype))), (_tmp13_ == NULL) ? NULL : vala_code_node_ref (_tmp13_));
				_tmp15_ = NULL;
				_tmp14_ = NULL;
				m = (_tmp15_ = (_tmp14_ = vala_class_get_default_construction_method (cl), (_tmp14_ == NULL) ? NULL : vala_code_node_ref (_tmp14_)), (m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL)), _tmp15_);
				vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, m, ((ValaCCodeBaseModule*) self)->source_declarations);
				_tmp18_ = NULL;
				_tmp17_ = NULL;
				_tmp16_ = NULL;
				ccall = (_tmp18_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp17_ = vala_ccode_identifier_new (_tmp16_ = vala_method_get_real_cname (m)))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp18_);
				(_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL));
				_tmp16_ = (g_free (_tmp16_), NULL);
				(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
			} else {
				if (VALA_IS_DELEGATE_TYPE (itype)) {
					ValaDelegate* _tmp20_;
					ValaDelegate* _tmp19_;
					_tmp20_ = NULL;
					_tmp19_ = NULL;
					deleg = (_tmp20_ = (_tmp19_ = vala_delegate_type_get_delegate_symbol (VALA_DELEGATE_TYPE (itype)), (_tmp19_ == NULL) ? NULL : vala_code_node_ref (_tmp19_)), (deleg == NULL) ? NULL : (deleg = (vala_code_node_unref (deleg), NULL)), _tmp20_);
				}
			}
		}
	}
	in_arg_map = NULL;
	out_arg_map = NULL;
	_tmp21_ = FALSE;
	_tmp22_ = FALSE;
	if (m != NULL) {
		_tmp22_ = vala_method_get_coroutine (m);
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		gboolean _tmp23_;
		gboolean _tmp24_;
		_tmp23_ = FALSE;
		_tmp24_ = FALSE;
		if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
			_tmp24_ = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			_tmp23_ = TRUE;
		} else {
			gboolean _tmp25_;
			_tmp25_ = FALSE;
			if (_vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") == 0) {
				_tmp25_ = vala_expression_get_symbol_reference (vala_member_access_get_inner (ma)) == vala_expression_get_symbol_reference ((ValaExpression*) ma);
			} else {
				_tmp25_ = FALSE;
			}
			_tmp23_ = _tmp25_;
		}
		_tmp21_ = _tmp23_;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		GeeHashMap* _tmp26_;
		GeeHashMap* _tmp27_;
		ValaCCodeFunctionCall* _tmp31_;
		ValaCCodeIdentifier* _tmp30_;
		char* _tmp29_;
		char* _tmp28_;
		gboolean _tmp32_;
		/* async call*/
		_tmp26_ = NULL;
		in_arg_map = (_tmp26_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal), (in_arg_map == NULL) ? NULL : (in_arg_map = (gee_collection_object_unref (in_arg_map), NULL)), _tmp26_);
		_tmp27_ = NULL;
		out_arg_map = (_tmp27_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal), (out_arg_map == NULL) ? NULL : (out_arg_map = (gee_collection_object_unref (out_arg_map), NULL)), _tmp27_);
		_tmp31_ = NULL;
		_tmp30_ = NULL;
		_tmp29_ = NULL;
		_tmp28_ = NULL;
		async_call = (_tmp31_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp30_ = vala_ccode_identifier_new (_tmp29_ = g_strconcat (_tmp28_ = vala_method_get_cname (m), "_async", NULL)))), (async_call == NULL) ? NULL : (async_call = (vala_ccode_node_unref (async_call), NULL)), _tmp31_);
		(_tmp30_ == NULL) ? NULL : (_tmp30_ = (vala_ccode_node_unref (_tmp30_), NULL));
		_tmp29_ = (g_free (_tmp29_), NULL);
		_tmp28_ = (g_free (_tmp28_), NULL);
		_tmp32_ = FALSE;
		if (_vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") == 0) {
			_tmp32_ = vala_expression_get_symbol_reference (vala_member_access_get_inner (ma)) == vala_expression_get_symbol_reference ((ValaExpression*) ma);
		} else {
			_tmp32_ = FALSE;
		}
		if (_tmp32_) {
			ValaCCodeFunctionCall* _tmp34_;
			ValaCCodeFunctionCall* _tmp33_;
			/* no finish call*/
			_tmp34_ = NULL;
			_tmp33_ = NULL;
			ccall = (_tmp34_ = (_tmp33_ = async_call, (_tmp33_ == NULL) ? NULL : vala_ccode_node_ref (_tmp33_)), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp34_);
		} else {
			ValaCCodeFunctionCall* _tmp38_;
			ValaCCodeIdentifier* _tmp37_;
			char* _tmp36_;
			char* _tmp35_;
			ValaCCodeMemberAccess* _tmp40_;
			ValaCCodeIdentifier* _tmp39_;
			_tmp38_ = NULL;
			_tmp37_ = NULL;
			_tmp36_ = NULL;
			_tmp35_ = NULL;
			ccall = (_tmp38_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp37_ = vala_ccode_identifier_new (_tmp36_ = g_strconcat (_tmp35_ = vala_method_get_cname (m), "_finish", NULL)))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp38_);
			(_tmp37_ == NULL) ? NULL : (_tmp37_ = (vala_ccode_node_unref (_tmp37_), NULL));
			_tmp36_ = (g_free (_tmp36_), NULL);
			_tmp35_ = (g_free (_tmp35_), NULL);
			/* pass GAsyncResult stored in closure to finish function*/
			_tmp40_ = NULL;
			_tmp39_ = NULL;
			gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) (_tmp40_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp39_ = vala_ccode_identifier_new ("data")), "res")));
			(_tmp40_ == NULL) ? NULL : (_tmp40_ = (vala_ccode_node_unref (_tmp40_), NULL));
			(_tmp39_ == NULL) ? NULL : (_tmp39_ = (vala_ccode_node_unref (_tmp39_), NULL));
		}
	} else {
		GeeHashMap* _tmp41_;
		GeeHashMap* _tmp43_;
		GeeHashMap* _tmp42_;
		_tmp41_ = NULL;
		in_arg_map = (_tmp41_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal), (in_arg_map == NULL) ? NULL : (in_arg_map = (gee_collection_object_unref (in_arg_map), NULL)), _tmp41_);
		_tmp43_ = NULL;
		_tmp42_ = NULL;
		out_arg_map = (_tmp43_ = (_tmp42_ = in_arg_map, (_tmp42_ == NULL) ? NULL : gee_collection_object_ref (_tmp42_)), (out_arg_map == NULL) ? NULL : (out_arg_map = (gee_collection_object_unref (out_arg_map), NULL)), _tmp43_);
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		if (vala_code_context_get_profile (vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self)) == VALA_PROFILE_GOBJECT) {
			if (!vala_class_get_is_compact (VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m)))) {
				ValaCCodeIdentifier* _tmp44_;
				_tmp44_ = NULL;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp44_ = vala_ccode_identifier_new ("object_type")));
				(_tmp44_ == NULL) ? NULL : (_tmp44_ = (vala_ccode_node_unref (_tmp44_), NULL));
			}
		} else {
			ValaCCodeIdentifier* _tmp45_;
			_tmp45_ = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp45_ = vala_ccode_identifier_new ("self")));
			(_tmp45_ == NULL) ? NULL : (_tmp45_ = (vala_ccode_node_unref (_tmp45_), NULL));
		}
		{
			GeeList* _tmp46_;
			GeeIterator* _tmp47_;
			GeeIterator* _base_type_it;
			_tmp46_ = NULL;
			_tmp47_ = NULL;
			_base_type_it = (_tmp47_ = gee_iterable_iterator ((GeeIterable*) (_tmp46_ = vala_class_get_base_types (((ValaCCodeBaseModule*) self)->current_class))), (_tmp46_ == NULL) ? NULL : (_tmp46_ = (gee_collection_object_unref (_tmp46_), NULL)), _tmp47_);
			while (TRUE) {
				ValaDataType* base_type;
				if (!gee_iterator_next (_base_type_it)) {
					break;
				}
				base_type = (ValaDataType*) gee_iterator_get (_base_type_it);
				if (VALA_IS_CLASS (vala_data_type_get_data_type (base_type))) {
					GeeList* _tmp48_;
					_tmp48_ = NULL;
					vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, ccall, _tmp48_ = vala_data_type_get_type_arguments (base_type), (ValaCodeNode*) expr, TRUE);
					(_tmp48_ == NULL) ? NULL : (_tmp48_ = (gee_collection_object_unref (_tmp48_), NULL));
					(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
					break;
				}
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
			}
			(_base_type_it == NULL) ? NULL : (_base_type_it = (gee_collection_object_unref (_base_type_it), NULL));
		}
	} else {
		if (m != NULL) {
			gboolean _tmp49_;
			GeeList* _tmp56_;
			gboolean _tmp57_;
			_tmp49_ = FALSE;
			if (vala_method_get_binding (m) != MEMBER_BINDING_INSTANCE) {
				_tmp49_ = VALA_IS_OBJECT_TYPE_SYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) m));
			} else {
				_tmp49_ = FALSE;
			}
			if (_tmp49_) {
				ValaObjectTypeSymbol* _tmp50_;
				ValaObjectTypeSymbol* type_symbol;
				gboolean _tmp51_;
				GeeList* _tmp52_;
				gboolean _tmp53_;
				/* support static methods in generic types*/
				_tmp50_ = NULL;
				type_symbol = (_tmp50_ = VALA_OBJECT_TYPE_SYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), (_tmp50_ == NULL) ? NULL : vala_code_node_ref (_tmp50_));
				_tmp51_ = FALSE;
				_tmp52_ = NULL;
				if ((_tmp53_ = gee_collection_get_size ((GeeCollection*) (_tmp52_ = vala_object_type_symbol_get_type_parameters (type_symbol))) > 0, (_tmp52_ == NULL) ? NULL : (_tmp52_ = (gee_collection_object_unref (_tmp52_), NULL)), _tmp53_)) {
					_tmp51_ = VALA_IS_MEMBER_ACCESS (vala_member_access_get_inner (ma));
				} else {
					_tmp51_ = FALSE;
				}
				if (_tmp51_) {
					ValaMemberAccess* _tmp54_;
					ValaMemberAccess* type_ma;
					GeeList* _tmp55_;
					_tmp54_ = NULL;
					type_ma = (_tmp54_ = VALA_MEMBER_ACCESS (vala_member_access_get_inner (ma)), (_tmp54_ == NULL) ? NULL : vala_code_node_ref (_tmp54_));
					_tmp55_ = NULL;
					vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, ccall, _tmp55_ = vala_member_access_get_type_arguments (type_ma), (ValaCodeNode*) expr, FALSE);
					(_tmp55_ == NULL) ? NULL : (_tmp55_ = (gee_collection_object_unref (_tmp55_), NULL));
					(type_ma == NULL) ? NULL : (type_ma = (vala_code_node_unref (type_ma), NULL));
				}
				(type_symbol == NULL) ? NULL : (type_symbol = (vala_code_node_unref (type_symbol), NULL));
			}
			_tmp56_ = NULL;
			if ((_tmp57_ = gee_collection_get_size ((GeeCollection*) (_tmp56_ = vala_method_get_type_parameters (m))) > 0, (_tmp56_ == NULL) ? NULL : (_tmp56_ = (gee_collection_object_unref (_tmp56_), NULL)), _tmp57_)) {
				GeeList* _tmp58_;
				_tmp58_ = NULL;
				vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, ccall, _tmp58_ = vala_member_access_get_type_arguments (ma), (ValaCodeNode*) expr, FALSE);
				(_tmp58_ == NULL) ? NULL : (_tmp58_ = (gee_collection_object_unref (_tmp58_), NULL));
			}
		}
	}
	/* the complete call expression, might include casts, comma expressions, and/or assignments*/
	_tmp59_ = NULL;
	ccall_expr = (_tmp59_ = (ValaCCodeExpression*) ccall, (_tmp59_ == NULL) ? NULL : vala_ccode_node_ref (_tmp59_));
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		ValaArrayType* _tmp60_;
		ValaArrayType* array_type;
		ValaCCodeIdentifier* _tmp62_;
		char* _tmp61_;
		_tmp60_ = NULL;
		array_type = (_tmp60_ = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (ma))), (_tmp60_ == NULL) ? NULL : vala_code_node_ref (_tmp60_));
		_tmp62_ = NULL;
		_tmp61_ = NULL;
		gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) 0, FALSE)), (ValaCCodeExpression*) (_tmp62_ = vala_ccode_identifier_new (_tmp61_ = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))));
		(_tmp62_ == NULL) ? NULL : (_tmp62_ = (vala_ccode_node_unref (_tmp62_), NULL));
		_tmp61_ = (g_free (_tmp61_), NULL);
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	} else {
		if (VALA_IS_ARRAY_MOVE_METHOD (m)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		}
	}
	instance = NULL;
	_tmp63_ = FALSE;
	_tmp64_ = FALSE;
	if (m != NULL) {
		_tmp64_ = vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		_tmp63_ = !VALA_IS_CREATION_METHOD (m);
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		ValaCCodeExpression* _tmp66_;
		ValaCCodeExpression* _tmp65_;
		gboolean _tmp67_;
		ValaStruct* _tmp72_;
		ValaSymbol* _tmp71_;
		ValaStruct* st;
		gboolean _tmp73_;
		_tmp66_ = NULL;
		_tmp65_ = NULL;
		instance = (_tmp66_ = (_tmp65_ = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (ma))), (_tmp65_ == NULL) ? NULL : vala_ccode_node_ref (_tmp65_)), (instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)), _tmp66_);
		_tmp67_ = FALSE;
		if (_vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") == 0) {
			_tmp67_ = vala_expression_get_symbol_reference (vala_member_access_get_inner (ma)) == vala_expression_get_symbol_reference ((ValaExpression*) ma);
		} else {
			_tmp67_ = FALSE;
		}
		if (_tmp67_) {
			ValaMemberAccess* _tmp68_;
			ValaMemberAccess* inner_ma;
			ValaCCodeExpression* _tmp70_;
			ValaCCodeExpression* _tmp69_;
			_tmp68_ = NULL;
			inner_ma = (_tmp68_ = VALA_MEMBER_ACCESS (vala_member_access_get_inner (ma)), (_tmp68_ == NULL) ? NULL : vala_code_node_ref (_tmp68_));
			_tmp70_ = NULL;
			_tmp69_ = NULL;
			instance = (_tmp70_ = (_tmp69_ = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (inner_ma))), (_tmp69_ == NULL) ? NULL : vala_ccode_node_ref (_tmp69_)), (instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)), _tmp70_);
			(inner_ma == NULL) ? NULL : (inner_ma = (vala_code_node_unref (inner_ma), NULL));
		}
		_tmp72_ = NULL;
		_tmp71_ = NULL;
		st = (_tmp72_ = (_tmp71_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m), VALA_IS_STRUCT (_tmp71_) ? ((ValaStruct*) _tmp71_) : NULL), (_tmp72_ == NULL) ? NULL : vala_code_node_ref (_tmp72_));
		_tmp73_ = FALSE;
		if (st != NULL) {
			_tmp73_ = !vala_struct_is_simple_type (st);
		} else {
			_tmp73_ = FALSE;
		}
		if (_tmp73_) {
			ValaCCodeUnaryExpression* _tmp75_;
			ValaCCodeExpression* _tmp74_;
			ValaCCodeUnaryExpression* unary;
			gboolean _tmp76_;
			/* we need to pass struct instance by reference*/
			_tmp75_ = NULL;
			_tmp74_ = NULL;
			unary = (_tmp75_ = (_tmp74_ = instance, VALA_IS_CCODE_UNARY_EXPRESSION (_tmp74_) ? ((ValaCCodeUnaryExpression*) _tmp74_) : NULL), (_tmp75_ == NULL) ? NULL : vala_ccode_node_ref (_tmp75_));
			_tmp76_ = FALSE;
			if (unary != NULL) {
				_tmp76_ = vala_ccode_unary_expression_get_operator (unary) == VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION;
			} else {
				_tmp76_ = FALSE;
			}
			if (_tmp76_) {
				ValaCCodeExpression* _tmp78_;
				ValaCCodeExpression* _tmp77_;
				/* *expr => expr*/
				_tmp78_ = NULL;
				_tmp77_ = NULL;
				instance = (_tmp78_ = (_tmp77_ = vala_ccode_unary_expression_get_inner (unary), (_tmp77_ == NULL) ? NULL : vala_ccode_node_ref (_tmp77_)), (instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)), _tmp78_);
			} else {
				gboolean _tmp79_;
				_tmp79_ = FALSE;
				if (VALA_IS_CCODE_IDENTIFIER (instance)) {
					_tmp79_ = TRUE;
				} else {
					_tmp79_ = VALA_IS_CCODE_MEMBER_ACCESS (instance);
				}
				if (_tmp79_) {
					ValaCCodeExpression* _tmp80_;
					_tmp80_ = NULL;
					instance = (_tmp80_ = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, instance), (instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)), _tmp80_);
				} else {
					ValaCCodeCommaExpression* ccomma;
					ValaLocalVariable* temp_var;
					ValaCCodeAssignment* _tmp82_;
					ValaCCodeExpression* _tmp81_;
					ValaCCodeUnaryExpression* _tmp84_;
					ValaCCodeExpression* _tmp83_;
					ValaCCodeExpression* _tmp86_;
					ValaCCodeExpression* _tmp85_;
					/* if instance is e.g. a function call, we can't take the address of the expression
					 (tmp = expr, &tmp)*/
					ccomma = vala_ccode_comma_expression_new ();
					temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_target_type (vala_member_access_get_inner (ma)), TRUE, NULL);
					gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
					_tmp82_ = NULL;
					_tmp81_ = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp82_ = vala_ccode_assignment_new (_tmp81_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var)), instance, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
					(_tmp82_ == NULL) ? NULL : (_tmp82_ = (vala_ccode_node_unref (_tmp82_), NULL));
					(_tmp81_ == NULL) ? NULL : (_tmp81_ = (vala_ccode_node_unref (_tmp81_), NULL));
					_tmp84_ = NULL;
					_tmp83_ = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp84_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp83_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var)))));
					(_tmp84_ == NULL) ? NULL : (_tmp84_ = (vala_ccode_node_unref (_tmp84_), NULL));
					(_tmp83_ == NULL) ? NULL : (_tmp83_ = (vala_ccode_node_unref (_tmp83_), NULL));
					_tmp86_ = NULL;
					_tmp85_ = NULL;
					instance = (_tmp86_ = (_tmp85_ = (ValaCCodeExpression*) ccomma, (_tmp85_ == NULL) ? NULL : vala_ccode_node_ref (_tmp85_)), (instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)), _tmp86_);
					(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
					(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
				}
			}
			(unary == NULL) ? NULL : (unary = (vala_ccode_node_unref (unary), NULL));
		}
		gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), instance);
		gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), instance);
		(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
	} else {
		gboolean _tmp87_;
		_tmp87_ = FALSE;
		if (m != NULL) {
			_tmp87_ = vala_method_get_binding (m) == MEMBER_BINDING_CLASS;
		} else {
			_tmp87_ = FALSE;
		}
		if (_tmp87_) {
			ValaClass* _tmp88_;
			ValaClass* cl;
			ValaCCodeIdentifier* _tmp91_;
			char* _tmp90_;
			char* _tmp89_;
			ValaCCodeFunctionCall* _tmp92_;
			ValaCCodeFunctionCall* cast;
			ValaCCodeExpression* klass;
			_tmp88_ = NULL;
			cl = (_tmp88_ = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), (_tmp88_ == NULL) ? NULL : vala_code_node_ref (_tmp88_));
			_tmp91_ = NULL;
			_tmp90_ = NULL;
			_tmp89_ = NULL;
			_tmp92_ = NULL;
			cast = (_tmp92_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp91_ = vala_ccode_identifier_new (_tmp90_ = g_strconcat (_tmp89_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL), "_CLASS", NULL)))), (_tmp91_ == NULL) ? NULL : (_tmp91_ = (vala_ccode_node_unref (_tmp91_), NULL)), _tmp90_ = (g_free (_tmp90_), NULL), _tmp89_ = (g_free (_tmp89_), NULL), _tmp92_);
			klass = NULL;
			if (vala_member_access_get_inner (ma) == NULL) {
				if (((ValaCCodeBaseModule*) self)->in_static_or_class_ctor) {
					ValaCCodeExpression* _tmp93_;
					/* Accessing the method from a static or class constructor*/
					_tmp93_ = NULL;
					klass = (_tmp93_ = (ValaCCodeExpression*) vala_ccode_identifier_new ("klass"), (klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)), _tmp93_);
				} else {
					ValaCCodeIdentifier* _tmp94_;
					ValaCCodeFunctionCall* _tmp95_;
					ValaCCodeFunctionCall* k;
					ValaCCodeIdentifier* _tmp96_;
					ValaCCodeExpression* _tmp98_;
					ValaCCodeExpression* _tmp97_;
					/* Accessing the method from within an instance method*/
					_tmp94_ = NULL;
					_tmp95_ = NULL;
					k = (_tmp95_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp94_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS"))), (_tmp94_ == NULL) ? NULL : (_tmp94_ = (vala_ccode_node_unref (_tmp94_), NULL)), _tmp95_);
					_tmp96_ = NULL;
					vala_ccode_function_call_add_argument (k, (ValaCCodeExpression*) (_tmp96_ = vala_ccode_identifier_new ("self")));
					(_tmp96_ == NULL) ? NULL : (_tmp96_ = (vala_ccode_node_unref (_tmp96_), NULL));
					_tmp98_ = NULL;
					_tmp97_ = NULL;
					klass = (_tmp98_ = (_tmp97_ = (ValaCCodeExpression*) k, (_tmp97_ == NULL) ? NULL : vala_ccode_node_ref (_tmp97_)), (klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)), _tmp98_);
					(k == NULL) ? NULL : (k = (vala_ccode_node_unref (k), NULL));
				}
			} else {
				ValaCCodeIdentifier* _tmp99_;
				ValaCCodeFunctionCall* _tmp100_;
				ValaCCodeFunctionCall* k;
				ValaCCodeExpression* _tmp102_;
				ValaCCodeExpression* _tmp101_;
				/* Accessing the method of an instance*/
				_tmp99_ = NULL;
				_tmp100_ = NULL;
				k = (_tmp100_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp99_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS"))), (_tmp99_ == NULL) ? NULL : (_tmp99_ = (vala_ccode_node_unref (_tmp99_), NULL)), _tmp100_);
				vala_ccode_function_call_add_argument (k, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (ma))));
				_tmp102_ = NULL;
				_tmp101_ = NULL;
				klass = (_tmp102_ = (_tmp101_ = (ValaCCodeExpression*) k, (_tmp101_ == NULL) ? NULL : vala_ccode_node_ref (_tmp101_)), (klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)), _tmp102_);
				(k == NULL) ? NULL : (k = (vala_ccode_node_unref (k), NULL));
			}
			vala_ccode_function_call_add_argument (cast, klass);
			gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), (ValaCCodeExpression*) cast);
			gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), (ValaCCodeExpression*) cast);
			(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
			(cast == NULL) ? NULL : (cast = (vala_ccode_node_unref (cast), NULL));
			(klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL));
		}
	}
	if (VALA_IS_ARRAY_MOVE_METHOD (m)) {
		ValaArrayType* _tmp103_;
		ValaArrayType* array_type;
		ValaCCodeIdentifier* _tmp104_;
		ValaCCodeFunctionCall* _tmp105_;
		ValaCCodeFunctionCall* csizeof;
		ValaCCodeIdentifier* _tmp107_;
		char* _tmp106_;
		_tmp103_ = NULL;
		array_type = (_tmp103_ = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (ma))), (_tmp103_ == NULL) ? NULL : vala_code_node_ref (_tmp103_));
		_tmp104_ = NULL;
		_tmp105_ = NULL;
		csizeof = (_tmp105_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp104_ = vala_ccode_identifier_new ("sizeof"))), (_tmp104_ == NULL) ? NULL : (_tmp104_ = (vala_ccode_node_unref (_tmp104_), NULL)), _tmp105_);
		_tmp107_ = NULL;
		_tmp106_ = NULL;
		vala_ccode_function_call_add_argument (csizeof, (ValaCCodeExpression*) (_tmp107_ = vala_ccode_identifier_new (_tmp106_ = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))));
		(_tmp107_ == NULL) ? NULL : (_tmp107_ = (vala_ccode_node_unref (_tmp107_), NULL));
		_tmp106_ = (g_free (_tmp106_), NULL);
		gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) csizeof);
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		(csizeof == NULL) ? NULL : (csizeof = (vala_ccode_node_unref (csizeof), NULL));
	} else {
		if (VALA_IS_DYNAMIC_METHOD (m)) {
			gint param_nr;
			vala_method_clear_parameters (m);
			param_nr = 1;
			{
				GeeList* _tmp108_;
				GeeIterator* _tmp109_;
				GeeIterator* _arg_it;
				_tmp108_ = NULL;
				_tmp109_ = NULL;
				_arg_it = (_tmp109_ = gee_iterable_iterator ((GeeIterable*) (_tmp108_ = vala_method_call_get_argument_list (expr))), (_tmp108_ == NULL) ? NULL : (_tmp108_ = (gee_collection_object_unref (_tmp108_), NULL)), _tmp109_);
				while (TRUE) {
					ValaExpression* arg;
					ValaUnaryExpression* _tmp111_;
					ValaExpression* _tmp110_;
					ValaUnaryExpression* unary;
					gboolean _tmp112_;
					if (!gee_iterator_next (_arg_it)) {
						break;
					}
					arg = (ValaExpression*) gee_iterator_get (_arg_it);
					_tmp111_ = NULL;
					_tmp110_ = NULL;
					unary = (_tmp111_ = (_tmp110_ = arg, VALA_IS_UNARY_EXPRESSION (_tmp110_) ? ((ValaUnaryExpression*) _tmp110_) : NULL), (_tmp111_ == NULL) ? NULL : vala_code_node_ref (_tmp111_));
					_tmp112_ = FALSE;
					if (unary != NULL) {
						_tmp112_ = vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp112_ = FALSE;
					}
					if (_tmp112_) {
						char* _tmp113_;
						ValaFormalParameter* _tmp114_;
						ValaFormalParameter* param;
						/* out argument*/
						_tmp113_ = NULL;
						_tmp114_ = NULL;
						param = (_tmp114_ = vala_formal_parameter_new (_tmp113_ = g_strdup_printf ("param%d", param_nr), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), NULL), _tmp113_ = (g_free (_tmp113_), NULL), _tmp114_);
						vala_formal_parameter_set_direction (param, VALA_PARAMETER_DIRECTION_OUT);
						vala_method_add_parameter (m, param);
						(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
					} else {
						gboolean _tmp115_;
						_tmp115_ = FALSE;
						if (unary != NULL) {
							_tmp115_ = vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp115_ = FALSE;
						}
						if (_tmp115_) {
							char* _tmp116_;
							ValaFormalParameter* _tmp117_;
							ValaFormalParameter* param;
							/* ref argument*/
							_tmp116_ = NULL;
							_tmp117_ = NULL;
							param = (_tmp117_ = vala_formal_parameter_new (_tmp116_ = g_strdup_printf ("param%d", param_nr), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), NULL), _tmp116_ = (g_free (_tmp116_), NULL), _tmp117_);
							vala_formal_parameter_set_direction (param, VALA_PARAMETER_DIRECTION_REF);
							vala_method_add_parameter (m, param);
							(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
						} else {
							ValaFormalParameter* _tmp119_;
							char* _tmp118_;
							/* in argument*/
							_tmp119_ = NULL;
							_tmp118_ = NULL;
							vala_method_add_parameter (m, _tmp119_ = vala_formal_parameter_new (_tmp118_ = g_strdup_printf ("param%d", param_nr), vala_expression_get_value_type (arg), NULL));
							(_tmp119_ == NULL) ? NULL : (_tmp119_ = (vala_code_node_unref (_tmp119_), NULL));
							_tmp118_ = (g_free (_tmp118_), NULL);
						}
					}
					param_nr++;
					(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
					(unary == NULL) ? NULL : (unary = (vala_code_node_unref (unary), NULL));
				}
				(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
			}
			{
				GeeList* _tmp120_;
				GeeIterator* _tmp121_;
				GeeIterator* _param_it;
				_tmp120_ = NULL;
				_tmp121_ = NULL;
				_param_it = (_tmp121_ = gee_iterable_iterator ((GeeIterable*) (_tmp120_ = vala_method_get_parameters (m))), (_tmp120_ == NULL) ? NULL : (_tmp120_ = (gee_collection_object_unref (_tmp120_), NULL)), _tmp121_);
				while (TRUE) {
					ValaFormalParameter* param;
					if (!gee_iterator_next (_param_it)) {
						break;
					}
					param = (ValaFormalParameter*) gee_iterator_get (_param_it);
					vala_code_node_accept ((ValaCodeNode*) param, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				}
				(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
			}
			vala_ccode_module_generate_dynamic_method_wrapper (vala_ccode_module_get_head ((ValaCCodeModule*) self), VALA_DYNAMIC_METHOD (m));
		} else {
			gboolean _tmp122_;
			_tmp122_ = FALSE;
			if (VALA_IS_CREATION_METHOD (m)) {
				_tmp122_ = vala_code_context_get_profile (vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self)) == VALA_PROFILE_GOBJECT;
			} else {
				_tmp122_ = FALSE;
			}
			if (_tmp122_) {
				ValaCCodeExpression* _tmp127_;
				ValaCCodeCastExpression* _tmp126_;
				char* _tmp125_;
				char* _tmp124_;
				ValaCCodeIdentifier* _tmp123_;
				gboolean _tmp128_;
				_tmp127_ = NULL;
				_tmp126_ = NULL;
				_tmp125_ = NULL;
				_tmp124_ = NULL;
				_tmp123_ = NULL;
				ccall_expr = (_tmp127_ = (ValaCCodeExpression*) vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp123_ = vala_ccode_identifier_new ("self")), (ValaCCodeExpression*) (_tmp126_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) ccall, _tmp125_ = g_strconcat (_tmp124_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class, FALSE), "*", NULL))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp127_);
				(_tmp126_ == NULL) ? NULL : (_tmp126_ = (vala_ccode_node_unref (_tmp126_), NULL));
				_tmp125_ = (g_free (_tmp125_), NULL);
				_tmp124_ = (g_free (_tmp124_), NULL);
				(_tmp123_ == NULL) ? NULL : (_tmp123_ = (vala_ccode_node_unref (_tmp123_), NULL));
				_tmp128_ = FALSE;
				if (!vala_class_get_is_compact (((ValaCCodeBaseModule*) self)->current_class)) {
					GeeList* _tmp129_;
					_tmp129_ = NULL;
					_tmp128_ = gee_collection_get_size ((GeeCollection*) (_tmp129_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class))) > 0;
					(_tmp129_ == NULL) ? NULL : (_tmp129_ = (gee_collection_object_unref (_tmp129_), NULL));
				} else {
					_tmp128_ = FALSE;
				}
				if (_tmp128_) {
					ValaCCodeCommaExpression* ccomma;
					ValaCCodeExpression* _tmp150_;
					ValaCCodeExpression* _tmp149_;
					ccomma = vala_ccode_comma_expression_new ();
					vala_ccode_comma_expression_append_expression (ccomma, ccall_expr);
					/* type, dup func, and destroy func fields for generic types */
					{
						GeeList* _tmp130_;
						GeeIterator* _tmp131_;
						GeeIterator* _type_param_it;
						/* type, dup func, and destroy func fields for generic types */
						_tmp130_ = NULL;
						_tmp131_ = NULL;
						_type_param_it = (_tmp131_ = gee_iterable_iterator ((GeeIterable*) (_tmp130_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class))), (_tmp130_ == NULL) ? NULL : (_tmp130_ = (gee_collection_object_unref (_tmp130_), NULL)), _tmp131_);
						/* type, dup func, and destroy func fields for generic types */
						while (TRUE) {
							ValaTypeParameter* type_param;
							ValaCCodeIdentifier* param_name;
							ValaCCodeIdentifier* _tmp132_;
							ValaCCodeMemberAccess* _tmp133_;
							ValaCCodeMemberAccess* priv_access;
							ValaCCodeIdentifier* _tmp136_;
							char* _tmp135_;
							char* _tmp134_;
							ValaCCodeAssignment* _tmp138_;
							ValaCCodeMemberAccess* _tmp137_;
							ValaCCodeIdentifier* _tmp141_;
							char* _tmp140_;
							char* _tmp139_;
							ValaCCodeAssignment* _tmp143_;
							ValaCCodeMemberAccess* _tmp142_;
							ValaCCodeIdentifier* _tmp146_;
							char* _tmp145_;
							char* _tmp144_;
							ValaCCodeAssignment* _tmp148_;
							ValaCCodeMemberAccess* _tmp147_;
							/* type, dup func, and destroy func fields for generic types */
							if (!gee_iterator_next (_type_param_it)) {
								/* type, dup func, and destroy func fields for generic types */
								break;
							}
							/* type, dup func, and destroy func fields for generic types */
							type_param = (ValaTypeParameter*) gee_iterator_get (_type_param_it);
							param_name = NULL;
							_tmp132_ = NULL;
							_tmp133_ = NULL;
							priv_access = (_tmp133_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp132_ = vala_ccode_identifier_new ("self")), "priv"), (_tmp132_ == NULL) ? NULL : (_tmp132_ = (vala_ccode_node_unref (_tmp132_), NULL)), _tmp133_);
							_tmp136_ = NULL;
							_tmp135_ = NULL;
							_tmp134_ = NULL;
							param_name = (_tmp136_ = vala_ccode_identifier_new (_tmp135_ = g_strdup_printf ("%s_type", _tmp134_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), (param_name == NULL) ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL)), _tmp136_);
							_tmp135_ = (g_free (_tmp135_), NULL);
							_tmp134_ = (g_free (_tmp134_), NULL);
							_tmp138_ = NULL;
							_tmp137_ = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp138_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp137_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) priv_access, vala_ccode_identifier_get_name (param_name))), (ValaCCodeExpression*) param_name, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
							(_tmp138_ == NULL) ? NULL : (_tmp138_ = (vala_ccode_node_unref (_tmp138_), NULL));
							(_tmp137_ == NULL) ? NULL : (_tmp137_ = (vala_ccode_node_unref (_tmp137_), NULL));
							_tmp141_ = NULL;
							_tmp140_ = NULL;
							_tmp139_ = NULL;
							param_name = (_tmp141_ = vala_ccode_identifier_new (_tmp140_ = g_strdup_printf ("%s_dup_func", _tmp139_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), (param_name == NULL) ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL)), _tmp141_);
							_tmp140_ = (g_free (_tmp140_), NULL);
							_tmp139_ = (g_free (_tmp139_), NULL);
							_tmp143_ = NULL;
							_tmp142_ = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp143_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp142_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) priv_access, vala_ccode_identifier_get_name (param_name))), (ValaCCodeExpression*) param_name, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
							(_tmp143_ == NULL) ? NULL : (_tmp143_ = (vala_ccode_node_unref (_tmp143_), NULL));
							(_tmp142_ == NULL) ? NULL : (_tmp142_ = (vala_ccode_node_unref (_tmp142_), NULL));
							_tmp146_ = NULL;
							_tmp145_ = NULL;
							_tmp144_ = NULL;
							param_name = (_tmp146_ = vala_ccode_identifier_new (_tmp145_ = g_strdup_printf ("%s_destroy_func", _tmp144_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), (param_name == NULL) ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL)), _tmp146_);
							_tmp145_ = (g_free (_tmp145_), NULL);
							_tmp144_ = (g_free (_tmp144_), NULL);
							_tmp148_ = NULL;
							_tmp147_ = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp148_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp147_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) priv_access, vala_ccode_identifier_get_name (param_name))), (ValaCCodeExpression*) param_name, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
							(_tmp148_ == NULL) ? NULL : (_tmp148_ = (vala_ccode_node_unref (_tmp148_), NULL));
							(_tmp147_ == NULL) ? NULL : (_tmp147_ = (vala_ccode_node_unref (_tmp147_), NULL));
							(type_param == NULL) ? NULL : (type_param = (vala_code_node_unref (type_param), NULL));
							(param_name == NULL) ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL));
							(priv_access == NULL) ? NULL : (priv_access = (vala_ccode_node_unref (priv_access), NULL));
						}
						(_type_param_it == NULL) ? NULL : (_type_param_it = (gee_collection_object_unref (_type_param_it), NULL));
					}
					_tmp150_ = NULL;
					_tmp149_ = NULL;
					ccall_expr = (_tmp150_ = (_tmp149_ = (ValaCCodeExpression*) ccomma, (_tmp149_ == NULL) ? NULL : vala_ccode_node_ref (_tmp149_)), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp150_);
					(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
				}
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	arg_pos = 0;
	params_it = gee_iterable_iterator ((GeeIterable*) params);
	{
		GeeList* _tmp151_;
		GeeIterator* _tmp152_;
		GeeIterator* _arg_it;
		_tmp151_ = NULL;
		_tmp152_ = NULL;
		_arg_it = (_tmp152_ = gee_iterable_iterator ((GeeIterable*) (_tmp151_ = vala_method_call_get_argument_list (expr))), (_tmp151_ == NULL) ? NULL : (_tmp151_ = (gee_collection_object_unref (_tmp151_), NULL)), _tmp152_);
		while (TRUE) {
			ValaExpression* arg;
			ValaCCodeExpression* _tmp153_;
			ValaCCodeExpression* cexpr;
			GeeHashMap* _tmp154_;
			GeeHashMap* carg_map;
			if (!gee_iterator_next (_arg_it)) {
				break;
			}
			arg = (ValaExpression*) gee_iterator_get (_arg_it);
			_tmp153_ = NULL;
			cexpr = (_tmp153_ = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) arg)), (_tmp153_ == NULL) ? NULL : vala_ccode_node_ref (_tmp153_));
			_tmp154_ = NULL;
			carg_map = (_tmp154_ = in_arg_map, (_tmp154_ == NULL) ? NULL : gee_collection_object_ref (_tmp154_));
			if (gee_iterator_next (params_it)) {
				ValaFormalParameter* param;
				gboolean _tmp155_;
				param = (ValaFormalParameter*) gee_iterator_get (params_it);
				_tmp155_ = FALSE;
				if (vala_formal_parameter_get_params_array (param)) {
					_tmp155_ = TRUE;
				} else {
					_tmp155_ = vala_formal_parameter_get_ellipsis (param);
				}
				ellipsis = _tmp155_;
				if (!ellipsis) {
					gboolean _tmp156_;
					gboolean _tmp157_;
					gboolean multiple_cargs;
					gboolean _tmp164_;
					ValaCCodeExpression* _tmp195_;
					gboolean _tmp196_;
					gboolean _tmp202_;
					gboolean _tmp203_;
					gboolean _tmp204_;
					_tmp156_ = FALSE;
					_tmp157_ = FALSE;
					if (vala_formal_parameter_get_async_only (param)) {
						gboolean _tmp158_;
						_tmp158_ = FALSE;
						if (((ValaCCodeBaseModule*) self)->current_method == NULL) {
							_tmp158_ = TRUE;
						} else {
							_tmp158_ = !vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
						}
						_tmp157_ = _tmp158_;
					} else {
						_tmp157_ = FALSE;
					}
					if (_tmp157_) {
						gboolean _tmp159_;
						_tmp159_ = FALSE;
						if (ma == NULL) {
							_tmp159_ = TRUE;
						} else {
							_tmp159_ = _vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") != 0;
						}
						_tmp156_ = _tmp159_;
					} else {
						_tmp156_ = FALSE;
					}
					if (_tmp156_) {
						ValaCCodeCommaExpression* comma;
						ValaCCodeExpression* _tmp161_;
						ValaCCodeExpression* _tmp160_;
						/* only skip if we are in a sync function (or property handler) 
						 and not manually starting async 
						 [CCode (async_only = true)] and we're making a
						 * synchronous version of the call.  Emit the arg
						 * at the start of a comma expression so that we
						 * get any side effects but otherwise ignore the
						 * value.
						 */
						comma = vala_ccode_comma_expression_new ();
						vala_ccode_comma_expression_append_expression (comma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) arg)));
						vala_ccode_comma_expression_append_expression (comma, ccall_expr);
						_tmp161_ = NULL;
						_tmp160_ = NULL;
						ccall_expr = (_tmp161_ = (_tmp160_ = (ValaCCodeExpression*) comma, (_tmp160_ == NULL) ? NULL : vala_ccode_node_ref (_tmp160_)), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp161_);
						(comma == NULL) ? NULL : (comma = (vala_ccode_node_unref (comma), NULL));
						(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
						(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
						(cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL));
						(carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL));
						continue;
					}
					/* if the vala argument expands to multiple C arguments,
					 we have to make sure that the C arguments don't depend
					 on each other as there is no guaranteed argument
					 evaluation order
					 http://bugzilla.gnome.org/show_bug.cgi?id=519597*/
					multiple_cargs = FALSE;
					if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT) {
						GeeHashMap* _tmp163_;
						GeeHashMap* _tmp162_;
						_tmp163_ = NULL;
						_tmp162_ = NULL;
						carg_map = (_tmp163_ = (_tmp162_ = out_arg_map, (_tmp162_ == NULL) ? NULL : gee_collection_object_ref (_tmp162_)), (carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL)), _tmp163_);
					}
					_tmp164_ = FALSE;
					if (!vala_formal_parameter_get_no_array_length (param)) {
						_tmp164_ = VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param));
					} else {
						_tmp164_ = FALSE;
					}
					if (_tmp164_) {
						ValaArrayType* _tmp165_;
						ValaArrayType* array_type;
						_tmp165_ = NULL;
						array_type = (_tmp165_ = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp165_ == NULL) ? NULL : vala_code_node_ref (_tmp165_));
						{
							gint dim;
							dim = 1;
							{
								gboolean _tmp166_;
								_tmp166_ = TRUE;
								while (TRUE) {
									ValaCCodeExpression* _tmp167_;
									if (!_tmp166_) {
										dim++;
									}
									_tmp166_ = FALSE;
									if (!(dim <= vala_array_type_get_rank (array_type))) {
										break;
									}
									_tmp167_ = NULL;
									gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_carray_length_parameter_position (param) + (0.01 * dim), FALSE)), _tmp167_ = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), arg, dim));
									(_tmp167_ == NULL) ? NULL : (_tmp167_ = (vala_ccode_node_unref (_tmp167_), NULL));
								}
							}
						}
						multiple_cargs = TRUE;
						(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
					} else {
						if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param))) {
							ValaDelegateType* _tmp168_;
							ValaDelegateType* deleg_type;
							ValaDelegate* _tmp169_;
							ValaDelegate* d;
							_tmp168_ = NULL;
							deleg_type = (_tmp168_ = VALA_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp168_ == NULL) ? NULL : vala_code_node_ref (_tmp168_));
							_tmp169_ = NULL;
							d = (_tmp169_ = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp169_ == NULL) ? NULL : vala_code_node_ref (_tmp169_));
							if (vala_delegate_get_has_target (d)) {
								ValaCCodeExpression* delegate_target;
								delegate_target = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, arg);
								if (vala_data_type_get_value_owned ((ValaDataType*) deleg_type)) {
									ValaCCodeExpression* delegate_target_destroy_notify;
									ValaMethod* _tmp171_;
									ValaSymbol* _tmp170_;
									ValaMethod* delegate_method;
									ValaLambdaExpression* _tmp173_;
									ValaExpression* _tmp172_;
									ValaLambdaExpression* lambda;
									ValaMemberAccess* _tmp175_;
									ValaExpression* _tmp174_;
									ValaMemberAccess* arg_ma;
									gboolean _tmp176_;
									gboolean _tmp177_;
									delegate_target_destroy_notify = NULL;
									_tmp171_ = NULL;
									_tmp170_ = NULL;
									delegate_method = (_tmp171_ = (_tmp170_ = vala_expression_get_symbol_reference (arg), VALA_IS_METHOD (_tmp170_) ? ((ValaMethod*) _tmp170_) : NULL), (_tmp171_ == NULL) ? NULL : vala_code_node_ref (_tmp171_));
									_tmp173_ = NULL;
									_tmp172_ = NULL;
									lambda = (_tmp173_ = (_tmp172_ = arg, VALA_IS_LAMBDA_EXPRESSION (_tmp172_) ? ((ValaLambdaExpression*) _tmp172_) : NULL), (_tmp173_ == NULL) ? NULL : vala_code_node_ref (_tmp173_));
									_tmp175_ = NULL;
									_tmp174_ = NULL;
									arg_ma = (_tmp175_ = (_tmp174_ = arg, VALA_IS_MEMBER_ACCESS (_tmp174_) ? ((ValaMemberAccess*) _tmp174_) : NULL), (_tmp175_ == NULL) ? NULL : vala_code_node_ref (_tmp175_));
									_tmp176_ = FALSE;
									_tmp177_ = FALSE;
									if (lambda != NULL) {
										_tmp177_ = ((ValaCCodeBaseModule*) self)->current_method != NULL;
									} else {
										_tmp177_ = FALSE;
									}
									if (_tmp177_) {
										_tmp176_ = vala_method_get_binding (((ValaCCodeBaseModule*) self)->current_method) == MEMBER_BINDING_INSTANCE;
									} else {
										_tmp176_ = FALSE;
									}
									if (_tmp176_) {
										ValaCCodeExpression* _tmp178_;
										ValaCCodeFunctionCall* _tmp179_;
										ValaCCodeFunctionCall* ref_call;
										ValaCCodeExpression* _tmp181_;
										ValaCCodeExpression* _tmp180_;
										ValaCCodeExpression* _tmp182_;
										/* type of delegate target is same as `this'
										 for lambda expressions in instance methods*/
										_tmp178_ = NULL;
										_tmp179_ = NULL;
										ref_call = (_tmp179_ = vala_ccode_function_call_new (_tmp178_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_parameter_type (vala_method_get_this_parameter (((ValaCCodeBaseModule*) self)->current_method)), vala_code_node_get_source_reference ((ValaCodeNode*) arg), FALSE)), (_tmp178_ == NULL) ? NULL : (_tmp178_ = (vala_ccode_node_unref (_tmp178_), NULL)), _tmp179_);
										vala_ccode_function_call_add_argument (ref_call, delegate_target);
										_tmp181_ = NULL;
										_tmp180_ = NULL;
										delegate_target = (_tmp181_ = (_tmp180_ = (ValaCCodeExpression*) ref_call, (_tmp180_ == NULL) ? NULL : vala_ccode_node_ref (_tmp180_)), (delegate_target == NULL) ? NULL : (delegate_target = (vala_ccode_node_unref (delegate_target), NULL)), _tmp181_);
										_tmp182_ = NULL;
										delegate_target_destroy_notify = (_tmp182_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_parameter_type (vala_method_get_this_parameter (((ValaCCodeBaseModule*) self)->current_method)), FALSE), (delegate_target_destroy_notify == NULL) ? NULL : (delegate_target_destroy_notify = (vala_ccode_node_unref (delegate_target_destroy_notify), NULL)), _tmp182_);
										(ref_call == NULL) ? NULL : (ref_call = (vala_ccode_node_unref (ref_call), NULL));
									} else {
										gboolean _tmp183_;
										gboolean _tmp184_;
										gboolean _tmp185_;
										gboolean _tmp186_;
										gboolean _tmp187_;
										_tmp183_ = FALSE;
										_tmp184_ = FALSE;
										_tmp185_ = FALSE;
										_tmp186_ = FALSE;
										_tmp187_ = FALSE;
										if (delegate_method != NULL) {
											_tmp187_ = vala_method_get_binding (delegate_method) == MEMBER_BINDING_INSTANCE;
										} else {
											_tmp187_ = FALSE;
										}
										if (_tmp187_) {
											_tmp186_ = arg_ma != NULL;
										} else {
											_tmp186_ = FALSE;
										}
										if (_tmp186_) {
											_tmp185_ = vala_member_access_get_inner (arg_ma) != NULL;
										} else {
											_tmp185_ = FALSE;
										}
										if (_tmp185_) {
											_tmp184_ = vala_data_type_get_data_type (vala_expression_get_value_type (vala_member_access_get_inner (arg_ma))) != NULL;
										} else {
											_tmp184_ = FALSE;
										}
										if (_tmp184_) {
											_tmp183_ = vala_typesymbol_is_reference_counting (vala_data_type_get_data_type (vala_expression_get_value_type (vala_member_access_get_inner (arg_ma))));
										} else {
											_tmp183_ = FALSE;
										}
										if (_tmp183_) {
											ValaCCodeExpression* _tmp188_;
											ValaCCodeFunctionCall* _tmp189_;
											ValaCCodeFunctionCall* ref_call;
											ValaCCodeExpression* _tmp191_;
											ValaCCodeExpression* _tmp190_;
											ValaCCodeExpression* _tmp192_;
											_tmp188_ = NULL;
											_tmp189_ = NULL;
											ref_call = (_tmp189_ = vala_ccode_function_call_new (_tmp188_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (vala_member_access_get_inner (arg_ma)), vala_code_node_get_source_reference ((ValaCodeNode*) arg), FALSE)), (_tmp188_ == NULL) ? NULL : (_tmp188_ = (vala_ccode_node_unref (_tmp188_), NULL)), _tmp189_);
											vala_ccode_function_call_add_argument (ref_call, delegate_target);
											_tmp191_ = NULL;
											_tmp190_ = NULL;
											delegate_target = (_tmp191_ = (_tmp190_ = (ValaCCodeExpression*) ref_call, (_tmp190_ == NULL) ? NULL : vala_ccode_node_ref (_tmp190_)), (delegate_target == NULL) ? NULL : (delegate_target = (vala_ccode_node_unref (delegate_target), NULL)), _tmp191_);
											_tmp192_ = NULL;
											delegate_target_destroy_notify = (_tmp192_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (vala_member_access_get_inner (arg_ma)), FALSE), (delegate_target_destroy_notify == NULL) ? NULL : (delegate_target_destroy_notify = (vala_ccode_node_unref (delegate_target_destroy_notify), NULL)), _tmp192_);
											(ref_call == NULL) ? NULL : (ref_call = (vala_ccode_node_unref (ref_call), NULL));
										} else {
											ValaCCodeExpression* _tmp193_;
											_tmp193_ = NULL;
											delegate_target_destroy_notify = (_tmp193_ = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL"), (delegate_target_destroy_notify == NULL) ? NULL : (delegate_target_destroy_notify = (vala_ccode_node_unref (delegate_target_destroy_notify), NULL)), _tmp193_);
										}
									}
									gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param) + 0.01, FALSE)), delegate_target_destroy_notify);
									(delegate_target_destroy_notify == NULL) ? NULL : (delegate_target_destroy_notify = (vala_ccode_node_unref (delegate_target_destroy_notify), NULL));
									(delegate_method == NULL) ? NULL : (delegate_method = (vala_code_node_unref (delegate_method), NULL));
									(lambda == NULL) ? NULL : (lambda = (vala_code_node_unref (lambda), NULL));
									(arg_ma == NULL) ? NULL : (arg_ma = (vala_code_node_unref (arg_ma), NULL));
								}
								gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), delegate_target);
								multiple_cargs = TRUE;
								(delegate_target == NULL) ? NULL : (delegate_target = (vala_ccode_node_unref (delegate_target), NULL));
							}
							(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
							(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
						} else {
							if (VALA_IS_METHOD_TYPE (vala_formal_parameter_get_parameter_type (param))) {
								ValaCCodeExpression* _tmp194_;
								_tmp194_ = NULL;
								gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), _tmp194_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, arg));
								(_tmp194_ == NULL) ? NULL : (_tmp194_ = (vala_ccode_node_unref (_tmp194_), NULL));
								multiple_cargs = TRUE;
							}
						}
					}
					_tmp195_ = NULL;
					cexpr = (_tmp195_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, param, arg, cexpr), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp195_);
					_tmp196_ = FALSE;
					if (multiple_cargs) {
						_tmp196_ = VALA_IS_METHOD_CALL (arg);
					} else {
						_tmp196_ = FALSE;
					}
					if (_tmp196_) {
						ValaCCodeCommaExpression* ccomma;
						ValaLocalVariable* temp_decl;
						ValaCCodeAssignment* _tmp198_;
						ValaCCodeExpression* _tmp197_;
						ValaCCodeExpression* _tmp199_;
						ValaCCodeExpression* _tmp201_;
						ValaCCodeExpression* _tmp200_;
						/* if vala argument is invocation expression
						 the auxiliary C argument(s) will depend on the main C argument
						 (tmp = arg1, call (tmp, arg2, arg3,...))*/
						ccomma = vala_ccode_comma_expression_new ();
						temp_decl = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (arg), TRUE, NULL);
						gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_decl);
						_tmp198_ = NULL;
						_tmp197_ = NULL;
						vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp198_ = vala_ccode_assignment_new (_tmp197_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_decl)), cexpr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
						(_tmp198_ == NULL) ? NULL : (_tmp198_ = (vala_ccode_node_unref (_tmp198_), NULL));
						(_tmp197_ == NULL) ? NULL : (_tmp197_ = (vala_ccode_node_unref (_tmp197_), NULL));
						_tmp199_ = NULL;
						cexpr = (_tmp199_ = (ValaCCodeExpression*) vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_decl)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp199_);
						vala_ccode_comma_expression_append_expression (ccomma, ccall_expr);
						_tmp201_ = NULL;
						_tmp200_ = NULL;
						ccall_expr = (_tmp201_ = (_tmp200_ = (ValaCCodeExpression*) ccomma, (_tmp200_ == NULL) ? NULL : vala_ccode_node_ref (_tmp200_)), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp201_);
						(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
						(temp_decl == NULL) ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL));
					}
					_tmp202_ = FALSE;
					_tmp203_ = FALSE;
					_tmp204_ = FALSE;
					if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
						_tmp204_ = vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (arg));
					} else {
						_tmp204_ = FALSE;
					}
					if (_tmp204_) {
						gboolean _tmp205_;
						_tmp205_ = FALSE;
						if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT) {
							_tmp205_ = TRUE;
						} else {
							_tmp205_ = !vala_data_type_get_value_owned (vala_formal_parameter_get_parameter_type (param));
						}
						_tmp203_ = _tmp205_;
					} else {
						_tmp203_ = FALSE;
					}
					if (_tmp203_) {
						_tmp202_ = !VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param));
					} else {
						_tmp202_ = FALSE;
					}
					/* unref old value for non-null non-weak ref/out arguments
					 disabled for arrays for now as that requires special handling
					 (ret_tmp = call (&tmp), var1 = (assign_tmp = dup (tmp), free (var1), assign_tmp), ret_tmp)*/
					if (_tmp202_) {
						ValaUnaryExpression* _tmp206_;
						ValaUnaryExpression* unary;
						ValaCCodeCommaExpression* ccomma;
						ValaLocalVariable* temp_var;
						ValaCCodeExpression* _tmp208_;
						ValaCCodeExpression* _tmp207_;
						ValaLocalVariable* ret_temp_var;
						ValaDataType* _tmp213_;
						gboolean _tmp214_;
						ValaCCodeCommaExpression* cassign_comma;
						ValaLocalVariable* assign_temp_var;
						ValaCCodeAssignment* _tmp222_;
						ValaCCodeExpression* _tmp221_;
						ValaCCodeExpression* _tmp220_;
						ValaCCodeExpression* _tmp219_;
						ValaCCodeExpression* _tmp223_;
						ValaCCodeExpression* _tmp224_;
						ValaCCodeAssignment* _tmp225_;
						ValaDataType* _tmp226_;
						gboolean _tmp227_;
						ValaCCodeExpression* _tmp230_;
						ValaCCodeExpression* _tmp229_;
						_tmp206_ = NULL;
						unary = (_tmp206_ = VALA_UNARY_EXPRESSION (arg), (_tmp206_ == NULL) ? NULL : vala_code_node_ref (_tmp206_));
						ccomma = vala_ccode_comma_expression_new ();
						temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_parameter_type (param), vala_data_type_get_value_owned (vala_formal_parameter_get_parameter_type (param)), NULL);
						gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
						_tmp208_ = NULL;
						_tmp207_ = NULL;
						cexpr = (_tmp208_ = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp207_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var))), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp208_);
						(_tmp207_ == NULL) ? NULL : (_tmp207_ = (vala_ccode_node_unref (_tmp207_), NULL));
						if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_REF) {
							ValaCCodeCommaExpression* crefcomma;
							ValaCCodeAssignment* _tmp210_;
							ValaCCodeExpression* _tmp209_;
							ValaCCodeExpression* _tmp212_;
							ValaCCodeExpression* _tmp211_;
							crefcomma = vala_ccode_comma_expression_new ();
							_tmp210_ = NULL;
							_tmp209_ = NULL;
							vala_ccode_comma_expression_append_expression (crefcomma, (ValaCCodeExpression*) (_tmp210_ = vala_ccode_assignment_new (_tmp209_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_unary_expression_get_inner (unary))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
							(_tmp210_ == NULL) ? NULL : (_tmp210_ = (vala_ccode_node_unref (_tmp210_), NULL));
							(_tmp209_ == NULL) ? NULL : (_tmp209_ = (vala_ccode_node_unref (_tmp209_), NULL));
							vala_ccode_comma_expression_append_expression (crefcomma, cexpr);
							_tmp212_ = NULL;
							_tmp211_ = NULL;
							cexpr = (_tmp212_ = (_tmp211_ = (ValaCCodeExpression*) crefcomma, (_tmp211_ == NULL) ? NULL : vala_ccode_node_ref (_tmp211_)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp212_);
							(crefcomma == NULL) ? NULL : (crefcomma = (vala_ccode_node_unref (crefcomma), NULL));
						}
						/* call function*/
						ret_temp_var = NULL;
						_tmp213_ = NULL;
						if ((_tmp214_ = VALA_IS_VOID_TYPE (_tmp213_ = vala_data_type_get_return_type (itype)), (_tmp213_ == NULL) ? NULL : (_tmp213_ = (vala_code_node_unref (_tmp213_), NULL)), _tmp214_)) {
							vala_ccode_comma_expression_append_expression (ccomma, ccall_expr);
						} else {
							ValaLocalVariable* _tmp216_;
							ValaDataType* _tmp215_;
							ValaCCodeAssignment* _tmp218_;
							ValaCCodeExpression* _tmp217_;
							_tmp216_ = NULL;
							_tmp215_ = NULL;
							ret_temp_var = (_tmp216_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp215_ = vala_data_type_get_return_type (itype), TRUE, NULL), (ret_temp_var == NULL) ? NULL : (ret_temp_var = (vala_code_node_unref (ret_temp_var), NULL)), _tmp216_);
							(_tmp215_ == NULL) ? NULL : (_tmp215_ = (vala_code_node_unref (_tmp215_), NULL));
							gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, ret_temp_var);
							_tmp218_ = NULL;
							_tmp217_ = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp218_ = vala_ccode_assignment_new (_tmp217_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) ret_temp_var)), ccall_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
							(_tmp218_ == NULL) ? NULL : (_tmp218_ = (vala_ccode_node_unref (_tmp218_), NULL));
							(_tmp217_ == NULL) ? NULL : (_tmp217_ = (vala_ccode_node_unref (_tmp217_), NULL));
						}
						cassign_comma = vala_ccode_comma_expression_new ();
						assign_temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), vala_data_type_get_value_owned (vala_expression_get_value_type (vala_unary_expression_get_inner (unary))), NULL);
						gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, assign_temp_var);
						_tmp222_ = NULL;
						_tmp221_ = NULL;
						_tmp220_ = NULL;
						_tmp219_ = NULL;
						vala_ccode_comma_expression_append_expression (cassign_comma, (ValaCCodeExpression*) (_tmp222_ = vala_ccode_assignment_new (_tmp219_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) assign_temp_var)), _tmp221_ = vala_ccode_base_module_transform_expression ((ValaCCodeBaseModule*) self, _tmp220_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var)), vala_formal_parameter_get_parameter_type (param), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), arg), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
						(_tmp222_ == NULL) ? NULL : (_tmp222_ = (vala_ccode_node_unref (_tmp222_), NULL));
						(_tmp221_ == NULL) ? NULL : (_tmp221_ = (vala_ccode_node_unref (_tmp221_), NULL));
						(_tmp220_ == NULL) ? NULL : (_tmp220_ = (vala_ccode_node_unref (_tmp220_), NULL));
						(_tmp219_ == NULL) ? NULL : (_tmp219_ = (vala_ccode_node_unref (_tmp219_), NULL));
						/* unref old value*/
						_tmp223_ = NULL;
						vala_ccode_comma_expression_append_expression (cassign_comma, _tmp223_ = vala_ccode_base_module_get_unref_expression ((ValaCCodeBaseModule*) self, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_unary_expression_get_inner (unary))), vala_expression_get_value_type (arg), arg));
						(_tmp223_ == NULL) ? NULL : (_tmp223_ = (vala_ccode_node_unref (_tmp223_), NULL));
						_tmp224_ = NULL;
						vala_ccode_comma_expression_append_expression (cassign_comma, _tmp224_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) assign_temp_var)));
						(_tmp224_ == NULL) ? NULL : (_tmp224_ = (vala_ccode_node_unref (_tmp224_), NULL));
						/* assign new value*/
						_tmp225_ = NULL;
						vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp225_ = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_unary_expression_get_inner (unary))), (ValaCCodeExpression*) cassign_comma, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
						(_tmp225_ == NULL) ? NULL : (_tmp225_ = (vala_ccode_node_unref (_tmp225_), NULL));
						/* return value*/
						_tmp226_ = NULL;
						if ((_tmp227_ = !VALA_IS_VOID_TYPE (_tmp226_ = vala_data_type_get_return_type (itype)), (_tmp226_ == NULL) ? NULL : (_tmp226_ = (vala_code_node_unref (_tmp226_), NULL)), _tmp227_)) {
							ValaCCodeExpression* _tmp228_;
							_tmp228_ = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, _tmp228_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) ret_temp_var)));
							(_tmp228_ == NULL) ? NULL : (_tmp228_ = (vala_ccode_node_unref (_tmp228_), NULL));
						}
						_tmp230_ = NULL;
						_tmp229_ = NULL;
						ccall_expr = (_tmp230_ = (_tmp229_ = (ValaCCodeExpression*) ccomma, (_tmp229_ == NULL) ? NULL : vala_ccode_node_ref (_tmp229_)), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp230_);
						(unary == NULL) ? NULL : (unary = (vala_code_node_unref (unary), NULL));
						(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
						(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
						(ret_temp_var == NULL) ? NULL : (ret_temp_var = (vala_code_node_unref (ret_temp_var), NULL));
						(cassign_comma == NULL) ? NULL : (cassign_comma = (vala_ccode_node_unref (cassign_comma), NULL));
						(assign_temp_var == NULL) ? NULL : (assign_temp_var = (vala_code_node_unref (assign_temp_var), NULL));
					}
					if (vala_formal_parameter_get_ctype (param) != NULL) {
						ValaCCodeExpression* _tmp231_;
						_tmp231_ = NULL;
						cexpr = (_tmp231_ = (ValaCCodeExpression*) vala_ccode_cast_expression_new (cexpr, vala_formal_parameter_get_ctype (param)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp231_);
					}
				}
				arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cparameter_position (param), ellipsis);
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
			} else {
				/* default argument position*/
				arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) i, ellipsis);
			}
			gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (arg_pos), cexpr);
			i++;
			(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
			(cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL));
			(carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL));
		}
		(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
	}
	if (gee_iterator_next (params_it)) {
		ValaFormalParameter* param;
		gboolean _tmp232_;
		param = (ValaFormalParameter*) gee_iterator_get (params_it);
		_tmp232_ = FALSE;
		if (vala_formal_parameter_get_params_array (param)) {
			_tmp232_ = TRUE;
		} else {
			_tmp232_ = vala_formal_parameter_get_ellipsis (param);
		}
		/* if there are more parameters than arguments,
		 * the additional parameter is an ellipsis parameter
		 * otherwise there is a bug in the semantic analyzer
		 */
		g_assert (_tmp232_);
		ellipsis = TRUE;
		(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
	}
	_tmp233_ = FALSE;
	if (m != NULL) {
		_tmp233_ = VALA_IS_ARRAY_TYPE (vala_method_get_return_type (m));
	} else {
		_tmp233_ = FALSE;
	}
	/* add length argument for methods returning arrays */
	if (_tmp233_) {
		ValaArrayType* _tmp234_;
		ValaArrayType* array_type;
		_tmp234_ = NULL;
		array_type = (_tmp234_ = VALA_ARRAY_TYPE (vala_method_get_return_type (m)), (_tmp234_ == NULL) ? NULL : vala_code_node_ref (_tmp234_));
		{
			gint dim;
			dim = 1;
			{
				gboolean _tmp235_;
				_tmp235_ = TRUE;
				while (TRUE) {
					if (!_tmp235_) {
						dim++;
					}
					_tmp235_ = FALSE;
					if (!(dim <= vala_array_type_get_rank (array_type))) {
						break;
					}
					if (vala_method_get_array_null_terminated (m)) {
						ValaDataType* _tmp236_;
						ValaLocalVariable* _tmp237_;
						ValaLocalVariable* temp_var;
						ValaCCodeExpression* temp_ref;
						ValaCCodeExpression* _tmp238_;
						ValaCCodeIdentifier* _tmp239_;
						ValaCCodeFunctionCall* _tmp240_;
						ValaCCodeFunctionCall* len_call;
						/* handle calls to methods returning null-terminated arrays*/
						_tmp236_ = NULL;
						_tmp237_ = NULL;
						temp_var = (_tmp237_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp236_ = vala_data_type_get_return_type (itype), TRUE, NULL), (_tmp236_ == NULL) ? NULL : (_tmp236_ = (vala_code_node_unref (_tmp236_), NULL)), _tmp237_);
						temp_ref = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var));
						gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
						_tmp238_ = NULL;
						ccall_expr = (_tmp238_ = (ValaCCodeExpression*) vala_ccode_assignment_new (temp_ref, ccall_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp238_);
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp239_ = NULL;
						_tmp240_ = NULL;
						len_call = (_tmp240_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp239_ = vala_ccode_identifier_new ("_vala_array_length"))), (_tmp239_ == NULL) ? NULL : (_tmp239_ = (vala_ccode_node_unref (_tmp239_), NULL)), _tmp240_);
						vala_ccode_function_call_add_argument (len_call, temp_ref);
						vala_expression_append_array_size ((ValaExpression*) expr, (ValaCCodeExpression*) len_call);
						(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
						(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
						(len_call == NULL) ? NULL : (len_call = (vala_ccode_node_unref (len_call), NULL));
					} else {
						if (!vala_method_get_no_array_length (m)) {
							ValaLocalVariable* temp_var;
							ValaCCodeExpression* temp_ref;
							ValaCCodeUnaryExpression* _tmp241_;
							temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->int_type, TRUE, NULL);
							temp_ref = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var));
							gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
							_tmp241_ = NULL;
							gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_carray_length_parameter_position (m) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) (_tmp241_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, temp_ref)));
							(_tmp241_ == NULL) ? NULL : (_tmp241_ = (vala_ccode_node_unref (_tmp241_), NULL));
							vala_expression_append_array_size ((ValaExpression*) expr, temp_ref);
							(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
							(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
						} else {
							ValaCCodeConstant* _tmp242_;
							_tmp242_ = NULL;
							vala_expression_append_array_size ((ValaExpression*) expr, (ValaCCodeExpression*) (_tmp242_ = vala_ccode_constant_new ("-1")));
							(_tmp242_ == NULL) ? NULL : (_tmp242_ = (vala_ccode_node_unref (_tmp242_), NULL));
						}
					}
				}
			}
		}
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	} else {
		gboolean _tmp243_;
		_tmp243_ = FALSE;
		if (m != NULL) {
			_tmp243_ = VALA_IS_DELEGATE_TYPE (vala_method_get_return_type (m));
		} else {
			_tmp243_ = FALSE;
		}
		if (_tmp243_) {
			ValaDelegateType* _tmp244_;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp245_;
			ValaDelegate* d;
			_tmp244_ = NULL;
			deleg_type = (_tmp244_ = VALA_DELEGATE_TYPE (vala_method_get_return_type (m)), (_tmp244_ == NULL) ? NULL : vala_code_node_ref (_tmp244_));
			_tmp245_ = NULL;
			d = (_tmp245_ = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp245_ == NULL) ? NULL : vala_code_node_ref (_tmp245_));
			if (vala_delegate_get_has_target (d)) {
				ValaPointerType* _tmp247_;
				ValaVoidType* _tmp246_;
				ValaLocalVariable* _tmp248_;
				ValaLocalVariable* temp_var;
				ValaCCodeExpression* temp_ref;
				ValaCCodeUnaryExpression* _tmp249_;
				_tmp247_ = NULL;
				_tmp246_ = NULL;
				_tmp248_ = NULL;
				temp_var = (_tmp248_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) (_tmp247_ = vala_pointer_type_new ((ValaDataType*) (_tmp246_ = vala_void_type_new (NULL)), NULL)), TRUE, NULL), (_tmp247_ == NULL) ? NULL : (_tmp247_ = (vala_code_node_unref (_tmp247_), NULL)), (_tmp246_ == NULL) ? NULL : (_tmp246_ = (vala_code_node_unref (_tmp246_), NULL)), _tmp248_);
				temp_ref = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var));
				gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
				_tmp249_ = NULL;
				gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cdelegate_target_parameter_position (m), FALSE)), (ValaCCodeExpression*) (_tmp249_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, temp_ref)));
				(_tmp249_ == NULL) ? NULL : (_tmp249_ = (vala_ccode_node_unref (_tmp249_), NULL));
				vala_expression_set_delegate_target ((ValaExpression*) expr, temp_ref);
				(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
				(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
			}
			(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
			(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
		}
	}
	_tmp250_ = FALSE;
	if (deleg != NULL) {
		_tmp250_ = VALA_IS_ARRAY_TYPE (vala_delegate_get_return_type (deleg));
	} else {
		_tmp250_ = FALSE;
	}
	/* add length argument for delegates returning arrays
	 TODO: avoid code duplication with methods returning arrays, see above*/
	if (_tmp250_) {
		ValaArrayType* _tmp251_;
		ValaArrayType* array_type;
		_tmp251_ = NULL;
		array_type = (_tmp251_ = VALA_ARRAY_TYPE (vala_delegate_get_return_type (deleg)), (_tmp251_ == NULL) ? NULL : vala_code_node_ref (_tmp251_));
		{
			gint dim;
			dim = 1;
			{
				gboolean _tmp252_;
				_tmp252_ = TRUE;
				while (TRUE) {
					if (!_tmp252_) {
						dim++;
					}
					_tmp252_ = FALSE;
					if (!(dim <= vala_array_type_get_rank (array_type))) {
						break;
					}
					if (vala_delegate_get_array_null_terminated (deleg)) {
						ValaDataType* _tmp253_;
						ValaLocalVariable* _tmp254_;
						ValaLocalVariable* temp_var;
						ValaCCodeExpression* temp_ref;
						ValaCCodeExpression* _tmp255_;
						ValaCCodeIdentifier* _tmp256_;
						ValaCCodeFunctionCall* _tmp257_;
						ValaCCodeFunctionCall* len_call;
						/* handle calls to methods returning null-terminated arrays*/
						_tmp253_ = NULL;
						_tmp254_ = NULL;
						temp_var = (_tmp254_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp253_ = vala_data_type_get_return_type (itype), TRUE, NULL), (_tmp253_ == NULL) ? NULL : (_tmp253_ = (vala_code_node_unref (_tmp253_), NULL)), _tmp254_);
						temp_ref = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var));
						gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
						_tmp255_ = NULL;
						ccall_expr = (_tmp255_ = (ValaCCodeExpression*) vala_ccode_assignment_new (temp_ref, ccall_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp255_);
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp256_ = NULL;
						_tmp257_ = NULL;
						len_call = (_tmp257_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp256_ = vala_ccode_identifier_new ("_vala_array_length"))), (_tmp256_ == NULL) ? NULL : (_tmp256_ = (vala_ccode_node_unref (_tmp256_), NULL)), _tmp257_);
						vala_ccode_function_call_add_argument (len_call, temp_ref);
						vala_expression_append_array_size ((ValaExpression*) expr, (ValaCCodeExpression*) len_call);
						(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
						(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
						(len_call == NULL) ? NULL : (len_call = (vala_ccode_node_unref (len_call), NULL));
					} else {
						if (!vala_delegate_get_no_array_length (deleg)) {
							ValaLocalVariable* temp_var;
							ValaCCodeExpression* temp_ref;
							ValaCCodeUnaryExpression* _tmp258_;
							temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->int_type, TRUE, NULL);
							temp_ref = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var));
							gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
							_tmp258_ = NULL;
							gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_delegate_get_carray_length_parameter_position (deleg) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) (_tmp258_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, temp_ref)));
							(_tmp258_ == NULL) ? NULL : (_tmp258_ = (vala_ccode_node_unref (_tmp258_), NULL));
							vala_expression_append_array_size ((ValaExpression*) expr, temp_ref);
							(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
							(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
						} else {
							ValaCCodeConstant* _tmp259_;
							_tmp259_ = NULL;
							vala_expression_append_array_size ((ValaExpression*) expr, (ValaCCodeExpression*) (_tmp259_ = vala_ccode_constant_new ("-1")));
							(_tmp259_ == NULL) ? NULL : (_tmp259_ = (vala_ccode_node_unref (_tmp259_), NULL));
						}
					}
				}
			}
		}
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	} else {
		gboolean _tmp260_;
		_tmp260_ = FALSE;
		if (deleg != NULL) {
			_tmp260_ = VALA_IS_DELEGATE_TYPE (vala_delegate_get_return_type (deleg));
		} else {
			_tmp260_ = FALSE;
		}
		if (_tmp260_) {
			ValaDelegateType* _tmp261_;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp262_;
			ValaDelegate* d;
			_tmp261_ = NULL;
			deleg_type = (_tmp261_ = VALA_DELEGATE_TYPE (vala_delegate_get_return_type (deleg)), (_tmp261_ == NULL) ? NULL : vala_code_node_ref (_tmp261_));
			_tmp262_ = NULL;
			d = (_tmp262_ = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp262_ == NULL) ? NULL : vala_code_node_ref (_tmp262_));
			if (vala_delegate_get_has_target (d)) {
				ValaPointerType* _tmp264_;
				ValaVoidType* _tmp263_;
				ValaLocalVariable* _tmp265_;
				ValaLocalVariable* temp_var;
				ValaCCodeExpression* temp_ref;
				ValaCCodeUnaryExpression* _tmp266_;
				_tmp264_ = NULL;
				_tmp263_ = NULL;
				_tmp265_ = NULL;
				temp_var = (_tmp265_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) (_tmp264_ = vala_pointer_type_new ((ValaDataType*) (_tmp263_ = vala_void_type_new (NULL)), NULL)), TRUE, NULL), (_tmp264_ == NULL) ? NULL : (_tmp264_ = (vala_code_node_unref (_tmp264_), NULL)), (_tmp263_ == NULL) ? NULL : (_tmp263_ = (vala_code_node_unref (_tmp263_), NULL)), _tmp265_);
				temp_ref = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var));
				gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
				_tmp266_ = NULL;
				gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_delegate_get_cdelegate_target_parameter_position (deleg), FALSE)), (ValaCCodeExpression*) (_tmp266_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, temp_ref)));
				(_tmp266_ == NULL) ? NULL : (_tmp266_ = (vala_ccode_node_unref (_tmp266_), NULL));
				vala_expression_set_delegate_target ((ValaExpression*) expr, temp_ref);
				(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
				(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
			}
			(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
			(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
		}
	}
	_tmp267_ = FALSE;
	if (m != NULL) {
		_tmp267_ = vala_method_get_coroutine (m);
	} else {
		_tmp267_ = FALSE;
	}
	if (_tmp267_) {
		gboolean _tmp268_;
		gboolean _tmp269_;
		_tmp268_ = FALSE;
		_tmp269_ = FALSE;
		if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
			_tmp269_ = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
		} else {
			_tmp269_ = FALSE;
		}
		if (_tmp269_) {
			_tmp268_ = TRUE;
		} else {
			gboolean _tmp270_;
			_tmp270_ = FALSE;
			if (_vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") == 0) {
				_tmp270_ = vala_expression_get_symbol_reference (vala_member_access_get_inner (ma)) == vala_expression_get_symbol_reference ((ValaExpression*) ma);
			} else {
				_tmp270_ = FALSE;
			}
			_tmp268_ = _tmp270_;
		}
		if (_tmp268_) {
			gboolean _tmp271_;
			_tmp271_ = FALSE;
			if (_vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") == 0) {
				_tmp271_ = vala_expression_get_symbol_reference (vala_member_access_get_inner (ma)) == vala_expression_get_symbol_reference ((ValaExpression*) ma);
			} else {
				_tmp271_ = FALSE;
			}
			/* asynchronous call*/
			if (_tmp271_) {
				ValaCCodeConstant* _tmp272_;
				ValaCCodeConstant* _tmp273_;
				_tmp272_ = NULL;
				gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp272_ = vala_ccode_constant_new ("NULL")));
				(_tmp272_ == NULL) ? NULL : (_tmp272_ = (vala_ccode_node_unref (_tmp272_), NULL));
				_tmp273_ = NULL;
				gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) (_tmp273_ = vala_ccode_constant_new ("NULL")));
				(_tmp273_ == NULL) ? NULL : (_tmp273_ = (vala_ccode_node_unref (_tmp273_), NULL));
			} else {
				ValaCCodeIdentifier* _tmp276_;
				char* _tmp275_;
				char* _tmp274_;
				ValaCCodeIdentifier* _tmp277_;
				_tmp276_ = NULL;
				_tmp275_ = NULL;
				_tmp274_ = NULL;
				gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp276_ = vala_ccode_identifier_new (_tmp275_ = g_strconcat (_tmp274_ = vala_method_get_cname (((ValaCCodeBaseModule*) self)->current_method), "_ready", NULL))));
				(_tmp276_ == NULL) ? NULL : (_tmp276_ = (vala_ccode_node_unref (_tmp276_), NULL));
				_tmp275_ = (g_free (_tmp275_), NULL);
				_tmp274_ = (g_free (_tmp274_), NULL);
				_tmp277_ = NULL;
				gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) (_tmp277_ = vala_ccode_identifier_new ("data")));
				(_tmp277_ == NULL) ? NULL : (_tmp277_ = (vala_ccode_node_unref (_tmp277_), NULL));
			}
		}
	}
	_tmp278_ = FALSE;
	if (VALA_IS_CREATION_METHOD (m)) {
		GeeList* _tmp279_;
		_tmp279_ = NULL;
		_tmp278_ = gee_collection_get_size ((GeeCollection*) (_tmp279_ = vala_code_node_get_error_types ((ValaCodeNode*) m))) > 0;
		(_tmp279_ == NULL) ? NULL : (_tmp279_ = (gee_collection_object_unref (_tmp279_), NULL));
	} else {
		_tmp278_ = FALSE;
	}
	if (_tmp278_) {
		ValaCCodeIdentifier* _tmp280_;
		_tmp280_ = NULL;
		gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp280_ = vala_ccode_identifier_new ("error")));
		(_tmp280_ == NULL) ? NULL : (_tmp280_ = (vala_ccode_node_unref (_tmp280_), NULL));
	} else {
		if (vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr)) {
			ValaCCodeUnaryExpression* _tmp282_;
			ValaCCodeExpression* _tmp281_;
			/* method can fail*/
			((ValaCCodeBaseModule*) self)->current_method_inner_error = TRUE;
			/* add &inner_error before the ellipsis arguments*/
			_tmp282_ = NULL;
			_tmp281_ = NULL;
			gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp282_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp281_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "_inner_error_"))));
			(_tmp282_ == NULL) ? NULL : (_tmp282_ = (vala_ccode_node_unref (_tmp282_), NULL));
			(_tmp281_ == NULL) ? NULL : (_tmp281_ = (vala_ccode_node_unref (_tmp281_), NULL));
		}
	}
	if (ellipsis) {
		gboolean _tmp283_;
		gboolean _tmp284_;
		_tmp283_ = FALSE;
		_tmp284_ = FALSE;
		if (!vala_method_get_printf_format (m)) {
			_tmp284_ = !vala_method_get_scanf_format (m);
		} else {
			_tmp284_ = FALSE;
		}
		if (_tmp284_) {
			_tmp283_ = _vala_strcmp0 (vala_method_get_sentinel (m), "") != 0;
		} else {
			_tmp283_ = FALSE;
		}
		/* ensure variable argument list ends with NULL
		 * except when using printf-style arguments */
		if (_tmp283_) {
			ValaCCodeConstant* _tmp285_;
			_tmp285_ = NULL;
			gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), TRUE)), (ValaCCodeExpression*) (_tmp285_ = vala_ccode_constant_new (vala_method_get_sentinel (m))));
			(_tmp285_ == NULL) ? NULL : (_tmp285_ = (vala_ccode_node_unref (_tmp285_), NULL));
		}
	} else {
		if (VALA_IS_DELEGATE_TYPE (itype)) {
			ValaDelegateType* _tmp286_;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp287_;
			ValaDelegate* d;
			_tmp286_ = NULL;
			deleg_type = (_tmp286_ = VALA_DELEGATE_TYPE (itype), (_tmp286_ == NULL) ? NULL : vala_code_node_ref (_tmp286_));
			_tmp287_ = NULL;
			d = (_tmp287_ = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp287_ == NULL) ? NULL : vala_code_node_ref (_tmp287_));
			if (vala_delegate_get_has_target (d)) {
				ValaCCodeExpression* _tmp288_;
				ValaCCodeExpression* _tmp289_;
				_tmp288_ = NULL;
				gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_delegate_get_cinstance_parameter_position (d), FALSE)), _tmp288_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, vala_method_call_get_call (expr)));
				(_tmp288_ == NULL) ? NULL : (_tmp288_ = (vala_ccode_node_unref (_tmp288_), NULL));
				_tmp289_ = NULL;
				gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_delegate_get_cinstance_parameter_position (d), FALSE)), _tmp289_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, vala_method_call_get_call (expr)));
				(_tmp289_ == NULL) ? NULL : (_tmp289_ = (vala_ccode_node_unref (_tmp289_), NULL));
			}
			(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
			(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
		}
	}
	_tmp290_ = FALSE;
	if (VALA_IS_SIGNAL_TYPE (itype)) {
		ValaDataType* _tmp291_;
		_tmp291_ = NULL;
		_tmp290_ = !VALA_IS_VOID_TYPE (_tmp291_ = vala_data_type_get_return_type (itype));
		(_tmp291_ == NULL) ? NULL : (_tmp291_ = (vala_code_node_unref (_tmp291_), NULL));
	} else {
		_tmp290_ = FALSE;
	}
	/* pass address for the return value of non-void signals without emitter functions*/
	if (_tmp290_) {
		ValaSignal* _tmp292_;
		ValaSignal* sig;
		gboolean _tmp293_;
		gboolean _tmp294_;
		_tmp292_ = NULL;
		sig = (_tmp292_ = vala_signal_type_get_signal_symbol (VALA_SIGNAL_TYPE (itype)), (_tmp292_ == NULL) ? NULL : vala_code_node_ref (_tmp292_));
		_tmp293_ = FALSE;
		_tmp294_ = FALSE;
		if (ma != NULL) {
			_tmp294_ = VALA_IS_BASE_ACCESS (vala_member_access_get_inner (ma));
		} else {
			_tmp294_ = FALSE;
		}
		if (_tmp294_) {
			_tmp293_ = vala_signal_get_is_virtual (sig);
		} else {
			_tmp293_ = FALSE;
		}
		if (_tmp293_) {
		} else {
			if (!vala_signal_get_has_emitter (sig)) {
				ValaDataType* _tmp295_;
				ValaLocalVariable* _tmp296_;
				ValaLocalVariable* temp_var;
				ValaCCodeExpression* temp_ref;
				ValaCCodeUnaryExpression* _tmp297_;
				ValaCCodeCommaExpression* ccomma;
				ValaCCodeExpression* _tmp299_;
				ValaCCodeExpression* _tmp298_;
				_tmp295_ = NULL;
				_tmp296_ = NULL;
				temp_var = (_tmp296_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp295_ = vala_data_type_get_return_type (itype), TRUE, NULL), (_tmp295_ == NULL) ? NULL : (_tmp295_ = (vala_code_node_unref (_tmp295_), NULL)), _tmp296_);
				temp_ref = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var));
				gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
				_tmp297_ = NULL;
				gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), TRUE)), (ValaCCodeExpression*) (_tmp297_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, temp_ref)));
				(_tmp297_ == NULL) ? NULL : (_tmp297_ = (vala_ccode_node_unref (_tmp297_), NULL));
				ccomma = vala_ccode_comma_expression_new ();
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall_expr));
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (temp_ref));
				_tmp299_ = NULL;
				_tmp298_ = NULL;
				ccall_expr = (_tmp299_ = (_tmp298_ = (ValaCCodeExpression*) ccomma, (_tmp298_ == NULL) ? NULL : vala_ccode_node_ref (_tmp298_)), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp299_);
				(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
				(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
				(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
			}
		}
		(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
	}
	/* append C arguments in the right order*/
	last_pos = 0;
	min_pos = 0;
	if (async_call != ccall) {
		/* don't append out arguments for .begin() calls*/
		last_pos = -1;
		while (TRUE) {
			ValaCCodeExpression* _tmp304_;
			min_pos = -1;
			{
				GeeSet* _tmp300_;
				GeeIterator* _tmp301_;
				GeeIterator* _pos_it;
				_tmp300_ = NULL;
				_tmp301_ = NULL;
				_pos_it = (_tmp301_ = gee_iterable_iterator ((GeeIterable*) (_tmp300_ = gee_map_get_keys ((GeeMap*) out_arg_map))), (_tmp300_ == NULL) ? NULL : (_tmp300_ = (gee_collection_object_unref (_tmp300_), NULL)), _tmp301_);
				while (TRUE) {
					gint pos;
					gboolean _tmp302_;
					if (!gee_iterator_next (_pos_it)) {
						break;
					}
					pos = GPOINTER_TO_INT (gee_iterator_get (_pos_it));
					_tmp302_ = FALSE;
					if (pos > last_pos) {
						gboolean _tmp303_;
						_tmp303_ = FALSE;
						if (min_pos == (-1)) {
							_tmp303_ = TRUE;
						} else {
							_tmp303_ = pos < min_pos;
						}
						_tmp302_ = _tmp303_;
					} else {
						_tmp302_ = FALSE;
					}
					if (_tmp302_) {
						min_pos = pos;
					}
				}
				(_pos_it == NULL) ? NULL : (_pos_it = (gee_collection_object_unref (_pos_it), NULL));
			}
			if (min_pos == (-1)) {
				break;
			}
			_tmp304_ = NULL;
			vala_ccode_function_call_add_argument (ccall, _tmp304_ = (ValaCCodeExpression*) gee_map_get ((GeeMap*) out_arg_map, GINT_TO_POINTER (min_pos)));
			(_tmp304_ == NULL) ? NULL : (_tmp304_ = (vala_ccode_node_unref (_tmp304_), NULL));
			last_pos = min_pos;
		}
	}
	if (async_call != NULL) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeExpression* _tmp309_;
			min_pos = -1;
			{
				GeeSet* _tmp305_;
				GeeIterator* _tmp306_;
				GeeIterator* _pos_it;
				_tmp305_ = NULL;
				_tmp306_ = NULL;
				_pos_it = (_tmp306_ = gee_iterable_iterator ((GeeIterable*) (_tmp305_ = gee_map_get_keys ((GeeMap*) in_arg_map))), (_tmp305_ == NULL) ? NULL : (_tmp305_ = (gee_collection_object_unref (_tmp305_), NULL)), _tmp306_);
				while (TRUE) {
					gint pos;
					gboolean _tmp307_;
					if (!gee_iterator_next (_pos_it)) {
						break;
					}
					pos = GPOINTER_TO_INT (gee_iterator_get (_pos_it));
					_tmp307_ = FALSE;
					if (pos > last_pos) {
						gboolean _tmp308_;
						_tmp308_ = FALSE;
						if (min_pos == (-1)) {
							_tmp308_ = TRUE;
						} else {
							_tmp308_ = pos < min_pos;
						}
						_tmp307_ = _tmp308_;
					} else {
						_tmp307_ = FALSE;
					}
					if (_tmp307_) {
						min_pos = pos;
					}
				}
				(_pos_it == NULL) ? NULL : (_pos_it = (gee_collection_object_unref (_pos_it), NULL));
			}
			if (min_pos == (-1)) {
				break;
			}
			_tmp309_ = NULL;
			vala_ccode_function_call_add_argument (async_call, _tmp309_ = (ValaCCodeExpression*) gee_map_get ((GeeMap*) in_arg_map, GINT_TO_POINTER (min_pos)));
			(_tmp309_ == NULL) ? NULL : (_tmp309_ = (vala_ccode_node_unref (_tmp309_), NULL));
			last_pos = min_pos;
		}
	}
	_tmp310_ = FALSE;
	_tmp311_ = FALSE;
	if (m != NULL) {
		_tmp311_ = vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE;
	} else {
		_tmp311_ = FALSE;
	}
	if (_tmp311_) {
		_tmp310_ = vala_method_get_returns_modified_pointer (m);
	} else {
		_tmp310_ = FALSE;
	}
	if (_tmp310_) {
		ValaCCodeAssignment* _tmp312_;
		_tmp312_ = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp312_ = vala_ccode_assignment_new (instance, ccall_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		(_tmp312_ == NULL) ? NULL : (_tmp312_ = (vala_ccode_node_unref (_tmp312_), NULL));
	} else {
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall_expr);
	}
	_tmp313_ = FALSE;
	_tmp314_ = FALSE;
	_tmp315_ = FALSE;
	if (m != NULL) {
		_tmp315_ = vala_method_get_coroutine (m);
	} else {
		_tmp315_ = FALSE;
	}
	if (_tmp315_) {
		_tmp314_ = ((ValaCCodeBaseModule*) self)->current_method != NULL;
	} else {
		_tmp314_ = FALSE;
	}
	if (_tmp314_) {
		_tmp313_ = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
	} else {
		_tmp313_ = FALSE;
	}
	if (_tmp313_) {
		gboolean _tmp316_;
		_tmp316_ = FALSE;
		if (_vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") != 0) {
			_tmp316_ = TRUE;
		} else {
			_tmp316_ = vala_expression_get_symbol_reference (vala_member_access_get_inner (ma)) != vala_expression_get_symbol_reference ((ValaExpression*) ma);
		}
		if (_tmp316_) {
			ValaCCodeExpressionStatement* _tmp318_;
			gint state;
			ValaCCodeExpressionStatement* _tmp324_;
			ValaCCodeAssignment* _tmp323_;
			ValaCCodeConstant* _tmp322_;
			char* _tmp321_;
			ValaCCodeMemberAccess* _tmp320_;
			ValaCCodeIdentifier* _tmp319_;
			ValaCCodeReturnStatement* _tmp326_;
			ValaCCodeConstant* _tmp325_;
			ValaCCodeCaseStatement* _tmp329_;
			ValaCCodeConstant* _tmp328_;
			char* _tmp327_;
			if (((ValaCCodeBaseModule*) self)->pre_statement_fragment == NULL) {
				ValaCCodeFragment* _tmp317_;
				_tmp317_ = NULL;
				((ValaCCodeBaseModule*) self)->pre_statement_fragment = (_tmp317_ = vala_ccode_fragment_new (), (((ValaCCodeBaseModule*) self)->pre_statement_fragment == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->pre_statement_fragment = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->pre_statement_fragment), NULL)), _tmp317_);
			}
			_tmp318_ = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->pre_statement_fragment, (ValaCCodeNode*) (_tmp318_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) async_call)));
			(_tmp318_ == NULL) ? NULL : (_tmp318_ = (vala_ccode_node_unref (_tmp318_), NULL));
			state = ((ValaCCodeBaseModule*) self)->next_coroutine_state++;
			_tmp324_ = NULL;
			_tmp323_ = NULL;
			_tmp322_ = NULL;
			_tmp321_ = NULL;
			_tmp320_ = NULL;
			_tmp319_ = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->pre_statement_fragment, (ValaCCodeNode*) (_tmp324_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp323_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp320_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp319_ = vala_ccode_identifier_new ("data")), "state")), (ValaCCodeExpression*) (_tmp322_ = vala_ccode_constant_new (_tmp321_ = g_strdup_printf ("%i", state))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp324_ == NULL) ? NULL : (_tmp324_ = (vala_ccode_node_unref (_tmp324_), NULL));
			(_tmp323_ == NULL) ? NULL : (_tmp323_ = (vala_ccode_node_unref (_tmp323_), NULL));
			(_tmp322_ == NULL) ? NULL : (_tmp322_ = (vala_ccode_node_unref (_tmp322_), NULL));
			_tmp321_ = (g_free (_tmp321_), NULL);
			(_tmp320_ == NULL) ? NULL : (_tmp320_ = (vala_ccode_node_unref (_tmp320_), NULL));
			(_tmp319_ == NULL) ? NULL : (_tmp319_ = (vala_ccode_node_unref (_tmp319_), NULL));
			_tmp326_ = NULL;
			_tmp325_ = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->pre_statement_fragment, (ValaCCodeNode*) (_tmp326_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp325_ = vala_ccode_constant_new ("FALSE")))));
			(_tmp326_ == NULL) ? NULL : (_tmp326_ = (vala_ccode_node_unref (_tmp326_), NULL));
			(_tmp325_ == NULL) ? NULL : (_tmp325_ = (vala_ccode_node_unref (_tmp325_), NULL));
			_tmp329_ = NULL;
			_tmp328_ = NULL;
			_tmp327_ = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->pre_statement_fragment, (ValaCCodeNode*) (_tmp329_ = vala_ccode_case_statement_new ((ValaCCodeExpression*) (_tmp328_ = vala_ccode_constant_new (_tmp327_ = g_strdup_printf ("%i", state))))));
			(_tmp329_ == NULL) ? NULL : (_tmp329_ = (vala_ccode_node_unref (_tmp329_), NULL));
			(_tmp328_ == NULL) ? NULL : (_tmp328_ = (vala_ccode_node_unref (_tmp328_), NULL));
			_tmp327_ = (g_free (_tmp327_), NULL);
		}
	}
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		GeeList* _tmp330_;
		GeeIterator* _tmp331_;
		GeeIterator* arg_it;
		ValaCCodeExpression* _tmp333_;
		ValaExpression* _tmp332_;
		ValaCCodeExpression* _tmp334_;
		ValaCCodeExpression* new_size;
		ValaLocalVariable* temp_decl;
		ValaCCodeExpression* temp_ref;
		ValaCCodeExpression* clen;
		ValaCCodeExpression* _tmp335_;
		ValaCCodeExpression* celems;
		ValaArrayType* _tmp336_;
		ValaArrayType* array_type;
		char* _tmp338_;
		char* _tmp337_;
		ValaCCodeIdentifier* _tmp339_;
		ValaCCodeIdentifier* csizeof;
		ValaCCodeBinaryExpression* cdelta;
		ValaCCodeBinaryExpression* ccheck;
		ValaCCodeIdentifier* _tmp340_;
		ValaCCodeFunctionCall* _tmp341_;
		ValaCCodeFunctionCall* czero;
		ValaCCodeBinaryExpression* _tmp342_;
		ValaCCodeConstant* _tmp343_;
		ValaCCodeBinaryExpression* _tmp344_;
		ValaCCodeCommaExpression* ccomma;
		ValaCCodeAssignment* _tmp345_;
		ValaCCodeConditionalExpression* _tmp347_;
		ValaCCodeConstant* _tmp346_;
		ValaCCodeAssignment* _tmp349_;
		ValaCCodeExpression* _tmp348_;
		/* FIXME: size expression must not be evaluated twice at runtime (potential side effects)*/
		_tmp330_ = NULL;
		_tmp331_ = NULL;
		arg_it = (_tmp331_ = gee_iterable_iterator ((GeeIterable*) (_tmp330_ = vala_method_call_get_argument_list (expr))), (_tmp330_ == NULL) ? NULL : (_tmp330_ = (gee_collection_object_unref (_tmp330_), NULL)), _tmp331_);
		gee_iterator_next (arg_it);
		_tmp333_ = NULL;
		_tmp332_ = NULL;
		_tmp334_ = NULL;
		new_size = (_tmp334_ = (_tmp333_ = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) (_tmp332_ = (ValaExpression*) gee_iterator_get (arg_it)))), (_tmp333_ == NULL) ? NULL : vala_ccode_node_ref (_tmp333_)), (_tmp332_ == NULL) ? NULL : (_tmp332_ = (vala_code_node_unref (_tmp332_), NULL)), _tmp334_);
		temp_decl = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->int_type, TRUE, NULL);
		temp_ref = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_decl));
		gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_decl);
		/* memset needs string.h */
		vala_ccode_declaration_space_add_include (((ValaCCodeBaseModule*) self)->source_declarations, "string.h", FALSE);
		clen = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_member_access_get_inner (ma), 1);
		_tmp335_ = NULL;
		celems = (_tmp335_ = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (ma))), (_tmp335_ == NULL) ? NULL : vala_ccode_node_ref (_tmp335_));
		_tmp336_ = NULL;
		array_type = (_tmp336_ = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (ma))), (_tmp336_ == NULL) ? NULL : vala_code_node_ref (_tmp336_));
		_tmp338_ = NULL;
		_tmp337_ = NULL;
		_tmp339_ = NULL;
		csizeof = (_tmp339_ = vala_ccode_identifier_new (_tmp338_ = g_strdup_printf ("sizeof (%s)", _tmp337_ = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))), _tmp338_ = (g_free (_tmp338_), NULL), _tmp337_ = (g_free (_tmp337_), NULL), _tmp339_);
		cdelta = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, temp_ref, clen);
		ccheck = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, temp_ref, clen);
		_tmp340_ = NULL;
		_tmp341_ = NULL;
		czero = (_tmp341_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp340_ = vala_ccode_identifier_new ("memset"))), (_tmp340_ == NULL) ? NULL : (_tmp340_ = (vala_ccode_node_unref (_tmp340_), NULL)), _tmp341_);
		_tmp342_ = NULL;
		vala_ccode_function_call_add_argument (czero, (ValaCCodeExpression*) (_tmp342_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, celems, clen)));
		(_tmp342_ == NULL) ? NULL : (_tmp342_ = (vala_ccode_node_unref (_tmp342_), NULL));
		_tmp343_ = NULL;
		vala_ccode_function_call_add_argument (czero, (ValaCCodeExpression*) (_tmp343_ = vala_ccode_constant_new ("0")));
		(_tmp343_ == NULL) ? NULL : (_tmp343_ = (vala_ccode_node_unref (_tmp343_), NULL));
		_tmp344_ = NULL;
		vala_ccode_function_call_add_argument (czero, (ValaCCodeExpression*) (_tmp344_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) csizeof, (ValaCCodeExpression*) cdelta)));
		(_tmp344_ == NULL) ? NULL : (_tmp344_ = (vala_ccode_node_unref (_tmp344_), NULL));
		ccomma = vala_ccode_comma_expression_new ();
		_tmp345_ = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp345_ = vala_ccode_assignment_new (temp_ref, new_size, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		(_tmp345_ == NULL) ? NULL : (_tmp345_ = (vala_ccode_node_unref (_tmp345_), NULL));
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) expr)));
		_tmp347_ = NULL;
		_tmp346_ = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp347_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) ccheck, (ValaCCodeExpression*) czero, (ValaCCodeExpression*) (_tmp346_ = vala_ccode_constant_new ("NULL")))));
		(_tmp347_ == NULL) ? NULL : (_tmp347_ = (vala_ccode_node_unref (_tmp347_), NULL));
		(_tmp346_ == NULL) ? NULL : (_tmp346_ = (vala_ccode_node_unref (_tmp346_), NULL));
		_tmp349_ = NULL;
		_tmp348_ = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp349_ = vala_ccode_assignment_new (_tmp348_ = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_member_access_get_inner (ma), 1), temp_ref, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		(_tmp349_ == NULL) ? NULL : (_tmp349_ = (vala_ccode_node_unref (_tmp349_), NULL));
		(_tmp348_ == NULL) ? NULL : (_tmp348_ = (vala_ccode_node_unref (_tmp348_), NULL));
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccomma);
		(arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL));
		(new_size == NULL) ? NULL : (new_size = (vala_ccode_node_unref (new_size), NULL));
		(temp_decl == NULL) ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL));
		(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
		(clen == NULL) ? NULL : (clen = (vala_ccode_node_unref (clen), NULL));
		(celems == NULL) ? NULL : (celems = (vala_ccode_node_unref (celems), NULL));
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		(csizeof == NULL) ? NULL : (csizeof = (vala_ccode_node_unref (csizeof), NULL));
		(cdelta == NULL) ? NULL : (cdelta = (vala_ccode_node_unref (cdelta), NULL));
		(ccheck == NULL) ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL));
		(czero == NULL) ? NULL : (czero = (vala_ccode_node_unref (czero), NULL));
		(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
	}
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(async_call == NULL) ? NULL : (async_call = (vala_ccode_node_unref (async_call), NULL));
	(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
	(deleg == NULL) ? NULL : (deleg = (vala_code_node_unref (deleg), NULL));
	(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
	(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
	(itype == NULL) ? NULL : (itype = (vala_code_node_unref (itype), NULL));
	(in_arg_map == NULL) ? NULL : (in_arg_map = (gee_collection_object_unref (in_arg_map), NULL));
	(out_arg_map == NULL) ? NULL : (out_arg_map = (gee_collection_object_unref (out_arg_map), NULL));
	(ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL));
	(instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL));
	(params_it == NULL) ? NULL : (params_it = (gee_collection_object_unref (params_it), NULL));
}


static void vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass) {
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->visit_method_call = vala_ccode_method_call_module_real_visit_method_call;
}


static void vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self) {
}


GType vala_ccode_method_call_module_get_type (void) {
	static GType vala_ccode_method_call_module_type_id = 0;
	if (vala_ccode_method_call_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
		vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
	}
	return vala_ccode_method_call_module_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




