/* valaccodestructmodule.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valaccode.h>
#include <gee.h>


#define VALA_TYPE_CCODE_MODULE (vala_ccode_module_get_type ())
#define VALA_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModule))
#define VALA_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))
#define VALA_IS_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MODULE))
#define VALA_IS_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MODULE))
#define VALA_CCODE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))

typedef struct _ValaCCodeModule ValaCCodeModule;
typedef struct _ValaCCodeModuleClass ValaCCodeModuleClass;
typedef struct _ValaCCodeModulePrivate ValaCCodeModulePrivate;

#define VALA_TYPE_CCODE_BASE_MODULE (vala_ccode_base_module_get_type ())
#define VALA_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModule))
#define VALA_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))
#define VALA_IS_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_IS_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_CCODE_BASE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))

typedef struct _ValaCCodeBaseModule ValaCCodeBaseModule;
typedef struct _ValaCCodeBaseModuleClass ValaCCodeBaseModuleClass;
typedef struct _ValaCCodeBaseModulePrivate ValaCCodeBaseModulePrivate;

#define VALA_TYPE_CCODE_DECLARATION_SPACE (vala_ccode_declaration_space_get_type ())
#define VALA_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpace))
#define VALA_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))
#define VALA_IS_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_IS_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_CCODE_DECLARATION_SPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))

typedef struct _ValaCCodeDeclarationSpace ValaCCodeDeclarationSpace;
typedef struct _ValaCCodeDeclarationSpaceClass ValaCCodeDeclarationSpaceClass;

#define VALA_TYPE_CCODE_STRUCT_MODULE (vala_ccode_struct_module_get_type ())
#define VALA_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModule))
#define VALA_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))
#define VALA_IS_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_IS_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_CCODE_STRUCT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))

typedef struct _ValaCCodeStructModule ValaCCodeStructModule;
typedef struct _ValaCCodeStructModuleClass ValaCCodeStructModuleClass;
typedef struct _ValaCCodeStructModulePrivate ValaCCodeStructModulePrivate;

#define VALA_TYPE_CCODE_GENERATOR (vala_ccode_generator_get_type ())
#define VALA_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGenerator))
#define VALA_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))
#define VALA_IS_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_GENERATOR))
#define VALA_IS_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_GENERATOR))
#define VALA_CCODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))

typedef struct _ValaCCodeGenerator ValaCCodeGenerator;
typedef struct _ValaCCodeGeneratorClass ValaCCodeGeneratorClass;

#define VALA_TYPE_TYPEREGISTER_FUNCTION (vala_typeregister_function_get_type ())
#define VALA_TYPEREGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunction))
#define VALA_TYPEREGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunctionClass))
#define VALA_IS_TYPEREGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION))
#define VALA_IS_TYPEREGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEREGISTER_FUNCTION))
#define VALA_TYPEREGISTER_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunctionClass))

typedef struct _ValaTypeRegisterFunction ValaTypeRegisterFunction;
typedef struct _ValaTypeRegisterFunctionClass ValaTypeRegisterFunctionClass;

#define VALA_TYPE_STRUCT_REGISTER_FUNCTION (vala_struct_register_function_get_type ())
#define VALA_STRUCT_REGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT_REGISTER_FUNCTION, ValaStructRegisterFunction))
#define VALA_STRUCT_REGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT_REGISTER_FUNCTION, ValaStructRegisterFunctionClass))
#define VALA_IS_STRUCT_REGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT_REGISTER_FUNCTION))
#define VALA_IS_STRUCT_REGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT_REGISTER_FUNCTION))
#define VALA_STRUCT_REGISTER_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT_REGISTER_FUNCTION, ValaStructRegisterFunctionClass))

typedef struct _ValaStructRegisterFunction ValaStructRegisterFunction;
typedef struct _ValaStructRegisterFunctionClass ValaStructRegisterFunctionClass;

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeModule {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeModulePrivate * priv;
};

struct _ValaCCodeModuleClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeModule *self);
	void (*emit) (ValaCCodeModule* self, ValaCodeContext* context);
	void (*visit_source_file) (ValaCCodeModule* self, ValaSourceFile* source_file);
	void (*visit_class) (ValaCCodeModule* self, ValaClass* cl);
	void (*visit_interface) (ValaCCodeModule* self, ValaInterface* iface);
	void (*visit_struct) (ValaCCodeModule* self, ValaStruct* st);
	void (*visit_enum) (ValaCCodeModule* self, ValaEnum* en);
	void (*visit_error_domain) (ValaCCodeModule* self, ValaErrorDomain* edomain);
	void (*visit_delegate) (ValaCCodeModule* self, ValaDelegate* d);
	void (*visit_member) (ValaCCodeModule* self, ValaMember* m);
	void (*visit_constant) (ValaCCodeModule* self, ValaConstant* c);
	void (*visit_field) (ValaCCodeModule* self, ValaField* f);
	void (*visit_method) (ValaCCodeModule* self, ValaMethod* m);
	void (*visit_creation_method) (ValaCCodeModule* self, ValaCreationMethod* m);
	void (*visit_formal_parameter) (ValaCCodeModule* self, ValaFormalParameter* p);
	void (*visit_property) (ValaCCodeModule* self, ValaProperty* prop);
	void (*visit_property_accessor) (ValaCCodeModule* self, ValaPropertyAccessor* acc);
	void (*visit_signal) (ValaCCodeModule* self, ValaSignal* sig);
	void (*visit_constructor) (ValaCCodeModule* self, ValaConstructor* c);
	void (*visit_destructor) (ValaCCodeModule* self, ValaDestructor* d);
	void (*visit_block) (ValaCCodeModule* self, ValaBlock* b);
	void (*visit_empty_statement) (ValaCCodeModule* self, ValaEmptyStatement* stmt);
	void (*visit_declaration_statement) (ValaCCodeModule* self, ValaDeclarationStatement* stmt);
	void (*visit_local_variable) (ValaCCodeModule* self, ValaLocalVariable* local);
	void (*visit_initializer_list) (ValaCCodeModule* self, ValaInitializerList* list);
	void (*visit_end_full_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_expression_statement) (ValaCCodeModule* self, ValaExpressionStatement* stmt);
	void (*visit_if_statement) (ValaCCodeModule* self, ValaIfStatement* stmt);
	void (*visit_switch_statement) (ValaCCodeModule* self, ValaSwitchStatement* stmt);
	void (*visit_switch_section) (ValaCCodeModule* self, ValaSwitchSection* section);
	void (*visit_switch_label) (ValaCCodeModule* self, ValaSwitchLabel* label);
	void (*visit_loop) (ValaCCodeModule* self, ValaLoop* stmt);
	void (*visit_foreach_statement) (ValaCCodeModule* self, ValaForeachStatement* stmt);
	void (*visit_break_statement) (ValaCCodeModule* self, ValaBreakStatement* stmt);
	void (*visit_continue_statement) (ValaCCodeModule* self, ValaContinueStatement* stmt);
	void (*visit_return_statement) (ValaCCodeModule* self, ValaReturnStatement* stmt);
	void (*visit_yield_statement) (ValaCCodeModule* self, ValaYieldStatement* stmt);
	void (*visit_throw_statement) (ValaCCodeModule* self, ValaThrowStatement* stmt);
	void (*visit_try_statement) (ValaCCodeModule* self, ValaTryStatement* stmt);
	void (*visit_catch_clause) (ValaCCodeModule* self, ValaCatchClause* clause);
	void (*visit_lock_statement) (ValaCCodeModule* self, ValaLockStatement* stmt);
	void (*visit_delete_statement) (ValaCCodeModule* self, ValaDeleteStatement* stmt);
	void (*visit_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_array_creation_expression) (ValaCCodeModule* self, ValaArrayCreationExpression* expr);
	void (*visit_boolean_literal) (ValaCCodeModule* self, ValaBooleanLiteral* expr);
	void (*visit_character_literal) (ValaCCodeModule* self, ValaCharacterLiteral* expr);
	void (*visit_integer_literal) (ValaCCodeModule* self, ValaIntegerLiteral* expr);
	void (*visit_real_literal) (ValaCCodeModule* self, ValaRealLiteral* expr);
	void (*visit_string_literal) (ValaCCodeModule* self, ValaStringLiteral* expr);
	void (*visit_null_literal) (ValaCCodeModule* self, ValaNullLiteral* expr);
	void (*visit_member_access) (ValaCCodeModule* self, ValaMemberAccess* expr);
	void (*visit_method_call) (ValaCCodeModule* self, ValaMethodCall* expr);
	void (*visit_element_access) (ValaCCodeModule* self, ValaElementAccess* expr);
	void (*visit_base_access) (ValaCCodeModule* self, ValaBaseAccess* expr);
	void (*visit_postfix_expression) (ValaCCodeModule* self, ValaPostfixExpression* expr);
	void (*visit_object_creation_expression) (ValaCCodeModule* self, ValaObjectCreationExpression* expr);
	void (*visit_sizeof_expression) (ValaCCodeModule* self, ValaSizeofExpression* expr);
	void (*visit_typeof_expression) (ValaCCodeModule* self, ValaTypeofExpression* expr);
	void (*visit_unary_expression) (ValaCCodeModule* self, ValaUnaryExpression* expr);
	void (*visit_cast_expression) (ValaCCodeModule* self, ValaCastExpression* expr);
	void (*visit_pointer_indirection) (ValaCCodeModule* self, ValaPointerIndirection* expr);
	void (*visit_addressof_expression) (ValaCCodeModule* self, ValaAddressofExpression* expr);
	void (*visit_reference_transfer_expression) (ValaCCodeModule* self, ValaReferenceTransferExpression* expr);
	void (*visit_binary_expression) (ValaCCodeModule* self, ValaBinaryExpression* expr);
	void (*visit_type_check) (ValaCCodeModule* self, ValaTypeCheck* expr);
	void (*visit_lambda_expression) (ValaCCodeModule* self, ValaLambdaExpression* l);
	void (*visit_assignment) (ValaCCodeModule* self, ValaAssignment* a);
	char* (*get_custom_creturn_type) (ValaCCodeModule* self, ValaMethod* m);
	void (*generate_dynamic_method_wrapper) (ValaCCodeModule* self, ValaDynamicMethod* method);
	gboolean (*method_has_wrapper) (ValaCCodeModule* self, ValaMethod* method);
	ValaCCodeIdentifier* (*get_value_setter_function) (ValaCCodeModule* self, ValaDataType* type_reference);
	ValaCCodeExpression* (*get_construct_property_assignment) (ValaCCodeModule* self, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value);
	ValaCCodeFunctionCall* (*get_param_spec) (ValaCCodeModule* self, ValaProperty* prop);
	ValaCCodeFunctionCall* (*get_signal_creation) (ValaCCodeModule* self, ValaSignal* sig, ValaTypeSymbol* type);
	ValaCCodeFragment* (*register_dbus_info) (ValaCCodeModule* self, ValaObjectTypeSymbol* bindable);
	char* (*get_dynamic_property_getter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_property_setter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_signal_cname) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_connect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_disconnect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	void (*generate_marshaller) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, gboolean dbus);
	char* (*get_marshaller_function) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, const char* prefix, gboolean dbus);
	char* (*get_array_length_cname) (ValaCCodeModule* self, const char* array_cname, gint dim);
	ValaCCodeExpression* (*get_array_length_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
	char* (*get_array_size_cname) (ValaCCodeModule* self, const char* array_cname);
	ValaCCodeExpression* (*get_array_size_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr);
	void (*add_simple_check) (ValaCCodeModule* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
};

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeBaseModule {
	ValaCCodeModule parent_instance;
	ValaCCodeBaseModulePrivate * priv;
	ValaSymbol* root_symbol;
	ValaSymbol* current_symbol;
	ValaTypeSymbol* current_type_symbol;
	ValaClass* current_class;
	ValaMethod* current_method;
	ValaDataType* current_return_type;
	ValaTryStatement* current_try;
	ValaPropertyAccessor* current_property_accessor;
	ValaCCodeDeclarationSpace* header_declarations;
	ValaCCodeDeclarationSpace* internal_header_declarations;
	ValaCCodeDeclarationSpace* source_declarations;
	ValaCCodeFragment* source_signal_marshaller_declaration;
	ValaCCodeFragment* source_type_member_definition;
	ValaCCodeFragment* class_init_fragment;
	ValaCCodeFragment* base_init_fragment;
	ValaCCodeFragment* class_finalize_fragment;
	ValaCCodeFragment* base_finalize_fragment;
	ValaCCodeFragment* instance_init_fragment;
	ValaCCodeFragment* instance_finalize_fragment;
	ValaCCodeFragment* source_signal_marshaller_definition;
	ValaCCodeFragment* module_init_fragment;
	ValaCCodeStruct* param_spec_struct;
	ValaCCodeStruct* closure_struct;
	ValaCCodeEnum* prop_enum;
	ValaCCodeFunction* function;
	ValaCCodeFragment* pre_statement_fragment;
	GeeArrayList* temp_vars;
	GeeArrayList* temp_ref_vars;
	GeeSet* user_marshal_set;
	GeeSet* predefined_marshal_set;
	gint next_temp_var_id;
	gboolean in_creation_method;
	gboolean in_constructor;
	gboolean in_static_or_class_ctor;
	gboolean current_method_inner_error;
	gint next_coroutine_state;
	ValaDataType* bool_type;
	ValaDataType* char_type;
	ValaDataType* uchar_type;
	ValaDataType* unichar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* int8_type;
	ValaDataType* uint8_type;
	ValaDataType* int16_type;
	ValaDataType* uint16_type;
	ValaDataType* int32_type;
	ValaDataType* uint32_type;
	ValaDataType* int64_type;
	ValaDataType* uint64_type;
	ValaDataType* string_type;
	ValaDataType* float_type;
	ValaDataType* double_type;
	ValaTypeSymbol* gtype_type;
	ValaTypeSymbol* gobject_type;
	ValaErrorType* gerror_type;
	ValaClass* glist_type;
	ValaClass* gslist_type;
	ValaClass* gvaluearray_type;
	ValaTypeSymbol* gstringbuilder_type;
	ValaTypeSymbol* garray_type;
	ValaTypeSymbol* gbytearray_type;
	ValaTypeSymbol* gptrarray_type;
	ValaDataType* gquark_type;
	ValaStruct* gvalue_type;
	ValaStruct* mutex_type;
	ValaTypeSymbol* type_module_type;
	ValaTypeSymbol* dbus_object_type;
	gboolean in_plugin;
	char* module_init_param_name;
	gboolean gvaluecollector_h_needed;
	gboolean requires_array_free;
	gboolean requires_array_move;
	gboolean requires_array_length;
	gboolean requires_strcmp0;
	gboolean dbus_glib_h_needed;
	gboolean dbus_glib_h_needed_in_header;
	GeeSet* wrappers;
	GeeMap* variable_name_map;
};

struct _ValaCCodeBaseModuleClass {
	ValaCCodeModuleClass parent_class;
	void (*append_vala_array_free) (ValaCCodeBaseModule* self);
	void (*append_vala_array_move) (ValaCCodeBaseModule* self);
	void (*append_vala_array_length) (ValaCCodeBaseModule* self);
	void (*generate_class_struct_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_struct_declaration) (ValaCCodeBaseModule* self, ValaStruct* st, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_delegate_declaration) (ValaCCodeBaseModule* self, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_cparameters) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
	ValaCCodeExpression* (*get_dup_func_expression) (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference, gboolean is_chainup);
	char* (*append_struct_array_free) (ValaCCodeBaseModule* self, ValaStruct* st);
	ValaCCodeExpression* (*get_unref_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr);
	void (*append_local_free) (ValaCCodeBaseModule* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, gboolean stop_at_loop);
	gboolean (*variable_accessible_in_finally) (ValaCCodeBaseModule* self, ValaLocalVariable* local);
	char* (*get_delegate_target_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_delegate_target_cexpression) (ValaCCodeBaseModule* self, ValaExpression* delegate_expr);
	char* (*get_delegate_target_destroy_notify_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_ref_cexpression) (ValaCCodeBaseModule* self, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node);
	void (*generate_class_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_interface_declaration) (ValaCCodeBaseModule* self, ValaInterface* iface, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_method_declaration) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_error_domain_declaration) (ValaCCodeBaseModule* self, ValaErrorDomain* edomain, ValaCCodeDeclarationSpace* decl_space);
	ValaCCodeExpression* (*get_implicit_cast_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
	gboolean (*is_gobject_property) (ValaCCodeBaseModule* self, ValaProperty* prop);
};

struct _ValaCCodeStructModule {
	ValaCCodeBaseModule parent_instance;
	ValaCCodeStructModulePrivate * priv;
};

struct _ValaCCodeStructModuleClass {
	ValaCCodeBaseModuleClass parent_class;
};


static gpointer vala_ccode_struct_module_parent_class = NULL;

gpointer vala_ccode_module_ref (gpointer instance);
void vala_ccode_module_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_module (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_module (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_module (const GValue* value);
GType vala_ccode_module_get_type (void);
GType vala_ccode_base_module_get_type (void);
gpointer vala_ccode_declaration_space_ref (gpointer instance);
void vala_ccode_declaration_space_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_declaration_space (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_declaration_space (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_declaration_space (const GValue* value);
GType vala_ccode_declaration_space_get_type (void);
GType vala_ccode_struct_module_get_type (void);
enum  {
	VALA_CCODE_STRUCT_MODULE_DUMMY_PROPERTY
};
GType vala_ccode_generator_get_type (void);
ValaCCodeBaseModule* vala_ccode_base_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeBaseModule* vala_ccode_base_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeStructModule* vala_ccode_struct_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeStructModule* vala_ccode_struct_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
gboolean vala_ccode_declaration_space_add_symbol_declaration (ValaCCodeDeclarationSpace* self, ValaSymbol* sym, const char* name);
void vala_ccode_declaration_space_add_include (ValaCCodeDeclarationSpace* self, const char* filename, gboolean local);
ValaCodeContext* vala_ccode_base_module_get_context (ValaCCodeBaseModule* self);
void vala_ccode_declaration_space_add_type_declaration (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
ValaStructRegisterFunction* vala_struct_register_function_new (ValaStruct* st, ValaCodeContext* context);
ValaStructRegisterFunction* vala_struct_register_function_construct (GType object_type, ValaStruct* st, ValaCodeContext* context);
gpointer vala_typeregister_function_ref (gpointer instance);
void vala_typeregister_function_unref (gpointer instance);
GParamSpec* vala_param_spec_typeregister_function (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_typeregister_function (GValue* value, gpointer v_object);
gpointer vala_value_get_typeregister_function (const GValue* value);
GType vala_typeregister_function_get_type (void);
GType vala_struct_register_function_get_type (void);
void vala_typeregister_function_init_from_type (ValaTypeRegisterFunction* self, gboolean plugin);
void vala_ccode_declaration_space_add_type_member_declaration (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
ValaCCodeFragment* vala_typeregister_function_get_declaration (ValaTypeRegisterFunction* self);
void vala_ccode_base_module_generate_type_declaration (ValaCCodeBaseModule* self, ValaDataType* type, ValaCCodeDeclarationSpace* decl_space);
ValaCCodeModule* vala_ccode_module_get_head (ValaCCodeModule* self);
char* vala_ccode_module_get_array_length_cname (ValaCCodeModule* self, const char* array_cname, gint dim);
char* vala_ccode_module_get_array_size_cname (ValaCCodeModule* self, const char* array_cname);
char* vala_ccode_base_module_get_delegate_target_cname (ValaCCodeBaseModule* self, const char* delegate_cname);
void vala_ccode_declaration_space_add_type_definition (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
static void vala_ccode_struct_module_real_generate_struct_declaration (ValaCCodeBaseModule* base, ValaStruct* st, ValaCCodeDeclarationSpace* decl_space);
void vala_ccode_base_module_generate_struct_declaration (ValaCCodeBaseModule* self, ValaStruct* st, ValaCCodeDeclarationSpace* decl_space);
ValaCCodeGenerator* vala_ccode_module_get_codegen (ValaCCodeModule* self);
static void vala_ccode_struct_module_add_struct_copy_function (ValaCCodeStructModule* self, ValaStruct* st);
static void vala_ccode_struct_module_add_struct_destroy_function (ValaCCodeStructModule* self, ValaStruct* st);
static void vala_ccode_struct_module_add_struct_dup_function (ValaCCodeStructModule* self, ValaStruct* st);
static void vala_ccode_struct_module_add_struct_free_function (ValaCCodeStructModule* self, ValaStruct* st);
static void vala_ccode_struct_module_real_visit_struct (ValaCCodeModule* base, ValaStruct* st);
gboolean vala_ccode_base_module_requires_copy (ValaCCodeBaseModule* self, ValaDataType* type);
ValaDataType* vala_ccode_base_module_get_data_type_for_symbol (ValaTypeSymbol* sym);
ValaCCodeExpression* vala_ccode_base_module_get_ref_cexpression (ValaCCodeBaseModule* self, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node);
void vala_ccode_base_module_append_temp_decl (ValaCCodeBaseModule* self, ValaCCodeFragment* cfrag, GeeList* temp_vars);



ValaCCodeStructModule* vala_ccode_struct_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeStructModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaCCodeStructModule*) vala_ccode_base_module_construct (object_type, codegen, next);
	return self;
}


ValaCCodeStructModule* vala_ccode_struct_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_struct_module_construct (VALA_TYPE_CCODE_STRUCT_MODULE, codegen, next);
}


static void vala_ccode_struct_module_real_generate_struct_declaration (ValaCCodeBaseModule* base, ValaStruct* st, ValaCCodeDeclarationSpace* decl_space) {
	ValaCCodeStructModule * self;
	char* _tmp0_;
	gboolean _tmp1_;
	char* _tmp12_;
	char* _tmp11_;
	ValaCCodeStruct* _tmp13_;
	ValaCCodeStruct* instance_struct;
	ValaCCodeTypeDefinition* _tmp34_;
	ValaCCodeVariableDeclarator* _tmp33_;
	char* _tmp32_;
	char* _tmp31_;
	char* _tmp30_;
	char* _tmp38_;
	char* _tmp37_;
	char* _tmp36_;
	ValaCCodeFunction* _tmp39_;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp43_;
	char* _tmp42_;
	char* _tmp41_;
	char* _tmp40_;
	ValaCCodeFunction* _tmp45_;
	char* _tmp44_;
	ValaCCodeFormalParameter* _tmp48_;
	char* _tmp47_;
	char* _tmp46_;
	self = (ValaCCodeStructModule*) base;
	g_return_if_fail (st != NULL);
	g_return_if_fail (decl_space != NULL);
	_tmp0_ = NULL;
	if ((_tmp1_ = vala_ccode_declaration_space_add_symbol_declaration (decl_space, (ValaSymbol*) st, _tmp0_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_)) {
		return;
	}
	if (vala_struct_is_boolean_type (st)) {
		/* typedef for boolean types*/
		vala_ccode_declaration_space_add_include (decl_space, "stdbool.h", FALSE);
		vala_struct_set_cname (st, "bool");
		return;
	} else {
		if (vala_struct_is_integer_type (st)) {
			const char* _tmp2_;
			char* _tmp3_;
			/* typedef for integral types*/
			vala_ccode_declaration_space_add_include (decl_space, "stdint.h", FALSE);
			_tmp2_ = NULL;
			if (vala_struct_get_signed (st)) {
				_tmp2_ = "";
			} else {
				_tmp2_ = "u";
			}
			_tmp3_ = NULL;
			vala_struct_set_cname (st, _tmp3_ = g_strdup_printf ("%sint%d_t", _tmp2_, vala_struct_get_width (st)));
			_tmp3_ = (g_free (_tmp3_), NULL);
			return;
		} else {
			if (vala_struct_is_floating_type (st)) {
				const char* _tmp4_;
				_tmp4_ = NULL;
				if (vala_struct_get_width (st) == 64) {
					_tmp4_ = "double";
				} else {
					_tmp4_ = "float";
				}
				/* typedef for floating types*/
				vala_struct_set_cname (st, _tmp4_);
				return;
			}
		}
	}
	if (vala_code_context_get_profile (vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self)) == VALA_PROFILE_GOBJECT) {
		if (vala_struct_get_has_type_id (st)) {
			ValaCCodeNewline* _tmp5_;
			char* _tmp6_;
			char* _tmp7_;
			char* macro;
			ValaCCodeMacroReplacement* _tmp9_;
			char* _tmp8_;
			ValaStructRegisterFunction* type_fun;
			ValaCCodeFragment* _tmp10_;
			_tmp5_ = NULL;
			vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp5_ = vala_ccode_newline_new ()));
			(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
			_tmp6_ = NULL;
			_tmp7_ = NULL;
			macro = (_tmp7_ = g_strdup_printf ("(%s_get_type ())", _tmp6_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) st, NULL)), _tmp6_ = (g_free (_tmp6_), NULL), _tmp7_);
			_tmp9_ = NULL;
			_tmp8_ = NULL;
			vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp9_ = vala_ccode_macro_replacement_new (_tmp8_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) st), macro)));
			(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
			_tmp8_ = (g_free (_tmp8_), NULL);
			type_fun = vala_struct_register_function_new (st, vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self));
			vala_typeregister_function_init_from_type ((ValaTypeRegisterFunction*) type_fun, FALSE);
			_tmp10_ = NULL;
			vala_ccode_declaration_space_add_type_member_declaration (decl_space, (ValaCCodeNode*) (_tmp10_ = vala_typeregister_function_get_declaration ((ValaTypeRegisterFunction*) type_fun)));
			(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
			macro = (g_free (macro), NULL);
			(type_fun == NULL) ? NULL : (type_fun = (vala_typeregister_function_unref (type_fun), NULL));
		}
	}
	_tmp12_ = NULL;
	_tmp11_ = NULL;
	_tmp13_ = NULL;
	instance_struct = (_tmp13_ = vala_ccode_struct_new (_tmp12_ = g_strdup_printf ("_%s", _tmp11_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE))), _tmp12_ = (g_free (_tmp12_), NULL), _tmp11_ = (g_free (_tmp11_), NULL), _tmp13_);
	{
		GeeList* _tmp14_;
		GeeIterator* _tmp15_;
		GeeIterator* _f_it;
		_tmp14_ = NULL;
		_tmp15_ = NULL;
		_f_it = (_tmp15_ = gee_iterable_iterator ((GeeIterable*) (_tmp14_ = vala_struct_get_fields (st))), (_tmp14_ == NULL) ? NULL : (_tmp14_ = (gee_collection_object_unref (_tmp14_), NULL)), _tmp15_);
		while (TRUE) {
			ValaField* f;
			char* field_ctype;
			if (!gee_iterator_next (_f_it)) {
				break;
			}
			f = (ValaField*) gee_iterator_get (_f_it);
			field_ctype = vala_data_type_get_cname (vala_field_get_field_type (f));
			if (vala_field_get_is_volatile (f)) {
				char* _tmp16_;
				_tmp16_ = NULL;
				field_ctype = (_tmp16_ = g_strconcat ("volatile ", field_ctype, NULL), field_ctype = (g_free (field_ctype), NULL), _tmp16_);
			}
			if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
				char* _tmp19_;
				char* _tmp18_;
				char* _tmp17_;
				gboolean _tmp20_;
				vala_ccode_base_module_generate_type_declaration ((ValaCCodeBaseModule*) self, vala_field_get_field_type (f), decl_space);
				_tmp19_ = NULL;
				_tmp18_ = NULL;
				_tmp17_ = NULL;
				vala_ccode_struct_add_field (instance_struct, field_ctype, _tmp19_ = g_strconcat (_tmp17_ = vala_field_get_cname (f), _tmp18_ = vala_data_type_get_cdeclarator_suffix (vala_field_get_field_type (f)), NULL));
				_tmp19_ = (g_free (_tmp19_), NULL);
				_tmp18_ = (g_free (_tmp18_), NULL);
				_tmp17_ = (g_free (_tmp17_), NULL);
				_tmp20_ = FALSE;
				if (VALA_IS_ARRAY_TYPE (vala_field_get_field_type (f))) {
					_tmp20_ = !vala_field_get_no_array_length (f);
				} else {
					_tmp20_ = FALSE;
				}
				if (_tmp20_) {
					ValaArrayType* _tmp21_;
					ValaArrayType* array_type;
					/* create fields to store array dimensions*/
					_tmp21_ = NULL;
					array_type = (_tmp21_ = VALA_ARRAY_TYPE (vala_field_get_field_type (f)), (_tmp21_ == NULL) ? NULL : vala_code_node_ref (_tmp21_));
					if (!vala_array_type_get_fixed_length (array_type)) {
						ValaDataType* len_type;
						gboolean _tmp25_;
						len_type = vala_data_type_copy (((ValaCCodeBaseModule*) self)->int_type);
						{
							gint dim;
							dim = 1;
							{
								gboolean _tmp22_;
								_tmp22_ = TRUE;
								while (TRUE) {
									char* _tmp24_;
									char* _tmp23_;
									if (!_tmp22_) {
										dim++;
									}
									_tmp22_ = FALSE;
									if (!(dim <= vala_array_type_get_rank (array_type))) {
										break;
									}
									_tmp24_ = NULL;
									_tmp23_ = NULL;
									vala_ccode_struct_add_field (instance_struct, _tmp23_ = vala_data_type_get_cname (len_type), _tmp24_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_symbol_get_name ((ValaSymbol*) f), dim));
									_tmp24_ = (g_free (_tmp24_), NULL);
									_tmp23_ = (g_free (_tmp23_), NULL);
								}
							}
						}
						_tmp25_ = FALSE;
						if (vala_array_type_get_rank (array_type) == 1) {
							_tmp25_ = vala_symbol_is_internal_symbol ((ValaSymbol*) f);
						} else {
							_tmp25_ = FALSE;
						}
						if (_tmp25_) {
							char* _tmp27_;
							char* _tmp26_;
							_tmp27_ = NULL;
							_tmp26_ = NULL;
							vala_ccode_struct_add_field (instance_struct, _tmp26_ = vala_data_type_get_cname (len_type), _tmp27_ = vala_ccode_module_get_array_size_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_symbol_get_name ((ValaSymbol*) f)));
							_tmp27_ = (g_free (_tmp27_), NULL);
							_tmp26_ = (g_free (_tmp26_), NULL);
						}
						(len_type == NULL) ? NULL : (len_type = (vala_code_node_unref (len_type), NULL));
					}
					(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
				} else {
					if (VALA_IS_DELEGATE_TYPE (vala_field_get_field_type (f))) {
						ValaDelegateType* _tmp28_;
						ValaDelegateType* delegate_type;
						_tmp28_ = NULL;
						delegate_type = (_tmp28_ = VALA_DELEGATE_TYPE (vala_field_get_field_type (f)), (_tmp28_ == NULL) ? NULL : vala_code_node_ref (_tmp28_));
						if (vala_delegate_get_has_target (vala_delegate_type_get_delegate_symbol (delegate_type))) {
							char* _tmp29_;
							/* create field to store delegate target*/
							_tmp29_ = NULL;
							vala_ccode_struct_add_field (instance_struct, "gpointer", _tmp29_ = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) f)));
							_tmp29_ = (g_free (_tmp29_), NULL);
						}
						(delegate_type == NULL) ? NULL : (delegate_type = (vala_code_node_unref (delegate_type), NULL));
					}
				}
			}
			(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
			field_ctype = (g_free (field_ctype), NULL);
		}
		(_f_it == NULL) ? NULL : (_f_it = (gee_collection_object_unref (_f_it), NULL));
	}
	_tmp34_ = NULL;
	_tmp33_ = NULL;
	_tmp32_ = NULL;
	_tmp31_ = NULL;
	_tmp30_ = NULL;
	vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp34_ = vala_ccode_type_definition_new (_tmp31_ = g_strdup_printf ("struct _%s", _tmp30_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE)), (ValaCCodeDeclarator*) (_tmp33_ = vala_ccode_variable_declarator_new (_tmp32_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE), NULL, NULL)))));
	(_tmp34_ == NULL) ? NULL : (_tmp34_ = (vala_ccode_node_unref (_tmp34_), NULL));
	(_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_ccode_node_unref (_tmp33_), NULL));
	_tmp32_ = (g_free (_tmp32_), NULL);
	_tmp31_ = (g_free (_tmp31_), NULL);
	_tmp30_ = (g_free (_tmp30_), NULL);
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) st)) != NULL) {
		ValaCCodeComment* _tmp35_;
		_tmp35_ = NULL;
		vala_ccode_declaration_space_add_type_definition (decl_space, (ValaCCodeNode*) (_tmp35_ = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) st)))));
		(_tmp35_ == NULL) ? NULL : (_tmp35_ = (vala_ccode_node_unref (_tmp35_), NULL));
	}
	vala_ccode_declaration_space_add_type_definition (decl_space, (ValaCCodeNode*) instance_struct);
	_tmp38_ = NULL;
	_tmp37_ = NULL;
	_tmp36_ = NULL;
	_tmp39_ = NULL;
	function = (_tmp39_ = vala_ccode_function_new (_tmp36_ = vala_typesymbol_get_dup_function ((ValaTypeSymbol*) st), _tmp38_ = g_strconcat (_tmp37_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE), "*", NULL)), _tmp38_ = (g_free (_tmp38_), NULL), _tmp37_ = (g_free (_tmp37_), NULL), _tmp36_ = (g_free (_tmp36_), NULL), _tmp39_);
	if (vala_symbol_is_private_symbol ((ValaSymbol*) st)) {
		vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	}
	_tmp43_ = NULL;
	_tmp42_ = NULL;
	_tmp41_ = NULL;
	_tmp40_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp43_ = vala_ccode_formal_parameter_new ("self", _tmp42_ = g_strconcat (_tmp41_ = g_strconcat ("const ", _tmp40_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE), NULL), "*", NULL)));
	(_tmp43_ == NULL) ? NULL : (_tmp43_ = (vala_ccode_node_unref (_tmp43_), NULL));
	_tmp42_ = (g_free (_tmp42_), NULL);
	_tmp41_ = (g_free (_tmp41_), NULL);
	_tmp40_ = (g_free (_tmp40_), NULL);
	vala_ccode_declaration_space_add_type_member_declaration (decl_space, (ValaCCodeNode*) function);
	_tmp45_ = NULL;
	_tmp44_ = NULL;
	function = (_tmp45_ = vala_ccode_function_new (_tmp44_ = vala_typesymbol_get_free_function ((ValaTypeSymbol*) st), "void"), (function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL)), _tmp45_);
	_tmp44_ = (g_free (_tmp44_), NULL);
	if (vala_symbol_is_private_symbol ((ValaSymbol*) st)) {
		vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	}
	_tmp48_ = NULL;
	_tmp47_ = NULL;
	_tmp46_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp48_ = vala_ccode_formal_parameter_new ("self", _tmp47_ = g_strconcat (_tmp46_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE), "*", NULL)));
	(_tmp48_ == NULL) ? NULL : (_tmp48_ = (vala_ccode_node_unref (_tmp48_), NULL));
	_tmp47_ = (g_free (_tmp47_), NULL);
	_tmp46_ = (g_free (_tmp46_), NULL);
	vala_ccode_declaration_space_add_type_member_declaration (decl_space, (ValaCCodeNode*) function);
	if (vala_struct_is_disposable (st)) {
		ValaCCodeFunction* _tmp50_;
		char* _tmp49_;
		ValaCCodeFormalParameter* _tmp54_;
		char* _tmp53_;
		char* _tmp52_;
		char* _tmp51_;
		ValaCCodeFormalParameter* _tmp57_;
		char* _tmp56_;
		char* _tmp55_;
		ValaCCodeFunction* _tmp59_;
		char* _tmp58_;
		ValaCCodeFormalParameter* _tmp62_;
		char* _tmp61_;
		char* _tmp60_;
		_tmp50_ = NULL;
		_tmp49_ = NULL;
		function = (_tmp50_ = vala_ccode_function_new (_tmp49_ = vala_typesymbol_get_copy_function ((ValaTypeSymbol*) st), "void"), (function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL)), _tmp50_);
		_tmp49_ = (g_free (_tmp49_), NULL);
		if (vala_symbol_is_private_symbol ((ValaSymbol*) st)) {
			vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
		}
		_tmp54_ = NULL;
		_tmp53_ = NULL;
		_tmp52_ = NULL;
		_tmp51_ = NULL;
		vala_ccode_function_add_parameter (function, _tmp54_ = vala_ccode_formal_parameter_new ("self", _tmp53_ = g_strconcat (_tmp52_ = g_strconcat ("const ", _tmp51_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE), NULL), "*", NULL)));
		(_tmp54_ == NULL) ? NULL : (_tmp54_ = (vala_ccode_node_unref (_tmp54_), NULL));
		_tmp53_ = (g_free (_tmp53_), NULL);
		_tmp52_ = (g_free (_tmp52_), NULL);
		_tmp51_ = (g_free (_tmp51_), NULL);
		_tmp57_ = NULL;
		_tmp56_ = NULL;
		_tmp55_ = NULL;
		vala_ccode_function_add_parameter (function, _tmp57_ = vala_ccode_formal_parameter_new ("dest", _tmp56_ = g_strconcat (_tmp55_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE), "*", NULL)));
		(_tmp57_ == NULL) ? NULL : (_tmp57_ = (vala_ccode_node_unref (_tmp57_), NULL));
		_tmp56_ = (g_free (_tmp56_), NULL);
		_tmp55_ = (g_free (_tmp55_), NULL);
		vala_ccode_declaration_space_add_type_member_declaration (decl_space, (ValaCCodeNode*) function);
		_tmp59_ = NULL;
		_tmp58_ = NULL;
		function = (_tmp59_ = vala_ccode_function_new (_tmp58_ = vala_typesymbol_get_destroy_function ((ValaTypeSymbol*) st), "void"), (function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL)), _tmp59_);
		_tmp58_ = (g_free (_tmp58_), NULL);
		if (vala_symbol_is_private_symbol ((ValaSymbol*) st)) {
			vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
		}
		_tmp62_ = NULL;
		_tmp61_ = NULL;
		_tmp60_ = NULL;
		vala_ccode_function_add_parameter (function, _tmp62_ = vala_ccode_formal_parameter_new ("self", _tmp61_ = g_strconcat (_tmp60_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE), "*", NULL)));
		(_tmp62_ == NULL) ? NULL : (_tmp62_ = (vala_ccode_node_unref (_tmp62_), NULL));
		_tmp61_ = (g_free (_tmp61_), NULL);
		_tmp60_ = (g_free (_tmp60_), NULL);
		vala_ccode_declaration_space_add_type_member_declaration (decl_space, (ValaCCodeNode*) function);
	}
	(instance_struct == NULL) ? NULL : (instance_struct = (vala_ccode_node_unref (instance_struct), NULL));
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
}


static void vala_ccode_struct_module_real_visit_struct (ValaCCodeModule* base, ValaStruct* st) {
	ValaCCodeStructModule * self;
	ValaTypeSymbol* _tmp0_;
	ValaTypeSymbol* old_type_symbol;
	ValaCCodeFragment* _tmp1_;
	ValaCCodeFragment* old_instance_finalize_fragment;
	ValaTypeSymbol* _tmp3_;
	ValaTypeSymbol* _tmp2_;
	ValaCCodeFragment* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	ValaTypeSymbol* _tmp9_;
	ValaTypeSymbol* _tmp8_;
	ValaCCodeFragment* _tmp11_;
	ValaCCodeFragment* _tmp10_;
	self = (ValaCCodeStructModule*) base;
	g_return_if_fail (st != NULL);
	_tmp0_ = NULL;
	old_type_symbol = (_tmp0_ = ((ValaCCodeBaseModule*) self)->current_type_symbol, (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
	_tmp1_ = NULL;
	old_instance_finalize_fragment = (_tmp1_ = ((ValaCCodeBaseModule*) self)->instance_finalize_fragment, (_tmp1_ == NULL) ? NULL : vala_ccode_node_ref (_tmp1_));
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	((ValaCCodeBaseModule*) self)->current_type_symbol = (_tmp3_ = (_tmp2_ = (ValaTypeSymbol*) st, (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_)), (((ValaCCodeBaseModule*) self)->current_type_symbol == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_type_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_type_symbol), NULL)), _tmp3_);
	_tmp4_ = NULL;
	((ValaCCodeBaseModule*) self)->instance_finalize_fragment = (_tmp4_ = vala_ccode_fragment_new (), (((ValaCCodeBaseModule*) self)->instance_finalize_fragment == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->instance_finalize_fragment = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->instance_finalize_fragment), NULL)), _tmp4_);
	vala_ccode_base_module_generate_struct_declaration ((ValaCCodeBaseModule*) self, st, ((ValaCCodeBaseModule*) self)->source_declarations);
	if (!vala_symbol_is_internal_symbol ((ValaSymbol*) st)) {
		vala_ccode_base_module_generate_struct_declaration ((ValaCCodeBaseModule*) self, st, ((ValaCCodeBaseModule*) self)->header_declarations);
	}
	vala_ccode_base_module_generate_struct_declaration ((ValaCCodeBaseModule*) self, st, ((ValaCCodeBaseModule*) self)->internal_header_declarations);
	vala_code_node_accept_children ((ValaCodeNode*) st, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	_tmp5_ = FALSE;
	_tmp6_ = FALSE;
	_tmp7_ = FALSE;
	if (vala_code_context_get_profile (vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self)) == VALA_PROFILE_GOBJECT) {
		_tmp7_ = !vala_struct_is_boolean_type (st);
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		_tmp6_ = !vala_struct_is_integer_type (st);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		_tmp5_ = !vala_struct_is_floating_type (st);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		if (vala_struct_is_disposable (st)) {
			vala_ccode_struct_module_add_struct_copy_function (self, st);
			vala_ccode_struct_module_add_struct_destroy_function (self, st);
		}
		vala_ccode_struct_module_add_struct_dup_function (self, st);
		vala_ccode_struct_module_add_struct_free_function (self, st);
	}
	_tmp9_ = NULL;
	_tmp8_ = NULL;
	((ValaCCodeBaseModule*) self)->current_type_symbol = (_tmp9_ = (_tmp8_ = old_type_symbol, (_tmp8_ == NULL) ? NULL : vala_code_node_ref (_tmp8_)), (((ValaCCodeBaseModule*) self)->current_type_symbol == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_type_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_type_symbol), NULL)), _tmp9_);
	_tmp11_ = NULL;
	_tmp10_ = NULL;
	((ValaCCodeBaseModule*) self)->instance_finalize_fragment = (_tmp11_ = (_tmp10_ = old_instance_finalize_fragment, (_tmp10_ == NULL) ? NULL : vala_ccode_node_ref (_tmp10_)), (((ValaCCodeBaseModule*) self)->instance_finalize_fragment == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->instance_finalize_fragment = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->instance_finalize_fragment), NULL)), _tmp11_);
	(old_type_symbol == NULL) ? NULL : (old_type_symbol = (vala_code_node_unref (old_type_symbol), NULL));
	(old_instance_finalize_fragment == NULL) ? NULL : (old_instance_finalize_fragment = (vala_ccode_node_unref (old_instance_finalize_fragment), NULL));
}


static void vala_ccode_struct_module_add_struct_dup_function (ValaCCodeStructModule* self, ValaStruct* st) {
	char* _tmp2_;
	char* _tmp1_;
	char* _tmp0_;
	ValaCCodeFunction* _tmp3_;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp7_;
	char* _tmp6_;
	char* _tmp5_;
	char* _tmp4_;
	ValaCCodeBlock* cblock;
	char* _tmp9_;
	char* _tmp8_;
	ValaCCodeDeclaration* _tmp10_;
	ValaCCodeDeclaration* _cdecl_;
	ValaCCodeVariableDeclarator* _tmp11_;
	ValaCCodeIdentifier* _tmp12_;
	ValaCCodeFunctionCall* _tmp13_;
	ValaCCodeFunctionCall* creation_call;
	ValaCCodeConstant* _tmp15_;
	char* _tmp14_;
	ValaCCodeConstant* _tmp16_;
	ValaCCodeExpressionStatement* _tmp19_;
	ValaCCodeAssignment* _tmp18_;
	ValaCCodeIdentifier* _tmp17_;
	ValaCCodeReturnStatement* _tmp36_;
	ValaCCodeIdentifier* _tmp35_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (st != NULL);
	_tmp2_ = NULL;
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	_tmp3_ = NULL;
	function = (_tmp3_ = vala_ccode_function_new (_tmp0_ = vala_typesymbol_get_dup_function ((ValaTypeSymbol*) st), _tmp2_ = g_strconcat (_tmp1_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE), "*", NULL)), _tmp2_ = (g_free (_tmp2_), NULL), _tmp1_ = (g_free (_tmp1_), NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp3_);
	if (vala_symbol_get_access ((ValaSymbol*) st) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	}
	_tmp7_ = NULL;
	_tmp6_ = NULL;
	_tmp5_ = NULL;
	_tmp4_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp7_ = vala_ccode_formal_parameter_new ("self", _tmp6_ = g_strconcat (_tmp5_ = g_strconcat ("const ", _tmp4_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE), NULL), "*", NULL)));
	(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
	_tmp6_ = (g_free (_tmp6_), NULL);
	_tmp5_ = (g_free (_tmp5_), NULL);
	_tmp4_ = (g_free (_tmp4_), NULL);
	cblock = vala_ccode_block_new ();
	_tmp9_ = NULL;
	_tmp8_ = NULL;
	_tmp10_ = NULL;
	_cdecl_ = (_tmp10_ = vala_ccode_declaration_new (_tmp9_ = g_strconcat (_tmp8_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE), "*", NULL)), _tmp9_ = (g_free (_tmp9_), NULL), _tmp8_ = (g_free (_tmp8_), NULL), _tmp10_);
	_tmp11_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp11_ = vala_ccode_variable_declarator_new ("dup", NULL, NULL)));
	(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
	vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) _cdecl_);
	_tmp12_ = NULL;
	_tmp13_ = NULL;
	creation_call = (_tmp13_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp12_ = vala_ccode_identifier_new ("g_new0"))), (_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL)), _tmp13_);
	_tmp15_ = NULL;
	_tmp14_ = NULL;
	vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp15_ = vala_ccode_constant_new (_tmp14_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE))));
	(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
	_tmp14_ = (g_free (_tmp14_), NULL);
	_tmp16_ = NULL;
	vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp16_ = vala_ccode_constant_new ("1")));
	(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
	_tmp19_ = NULL;
	_tmp18_ = NULL;
	_tmp17_ = NULL;
	vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp19_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp18_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp17_ = vala_ccode_identifier_new ("dup")), (ValaCCodeExpression*) creation_call, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
	(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL));
	(_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL));
	if (vala_struct_is_disposable (st)) {
		ValaCCodeIdentifier* _tmp21_;
		char* _tmp20_;
		ValaCCodeFunctionCall* _tmp22_;
		ValaCCodeFunctionCall* copy_call;
		ValaCCodeIdentifier* _tmp23_;
		ValaCCodeIdentifier* _tmp24_;
		ValaCCodeExpressionStatement* _tmp25_;
		_tmp21_ = NULL;
		_tmp20_ = NULL;
		_tmp22_ = NULL;
		copy_call = (_tmp22_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp21_ = vala_ccode_identifier_new (_tmp20_ = vala_typesymbol_get_copy_function ((ValaTypeSymbol*) st)))), (_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL)), _tmp20_ = (g_free (_tmp20_), NULL), _tmp22_);
		_tmp23_ = NULL;
		vala_ccode_function_call_add_argument (copy_call, (ValaCCodeExpression*) (_tmp23_ = vala_ccode_identifier_new ("self")));
		(_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL));
		_tmp24_ = NULL;
		vala_ccode_function_call_add_argument (copy_call, (ValaCCodeExpression*) (_tmp24_ = vala_ccode_identifier_new ("dup")));
		(_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL));
		_tmp25_ = NULL;
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp25_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) copy_call)));
		(_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_ccode_node_unref (_tmp25_), NULL));
		(copy_call == NULL) ? NULL : (copy_call = (vala_ccode_node_unref (copy_call), NULL));
	} else {
		ValaCCodeIdentifier* _tmp26_;
		ValaCCodeFunctionCall* _tmp27_;
		ValaCCodeFunctionCall* sizeof_call;
		ValaCCodeConstant* _tmp29_;
		char* _tmp28_;
		ValaCCodeIdentifier* _tmp30_;
		ValaCCodeFunctionCall* _tmp31_;
		ValaCCodeFunctionCall* copy_call;
		ValaCCodeIdentifier* _tmp32_;
		ValaCCodeIdentifier* _tmp33_;
		ValaCCodeExpressionStatement* _tmp34_;
		vala_ccode_declaration_space_add_include (((ValaCCodeBaseModule*) self)->source_declarations, "string.h", FALSE);
		_tmp26_ = NULL;
		_tmp27_ = NULL;
		sizeof_call = (_tmp27_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp26_ = vala_ccode_identifier_new ("sizeof"))), (_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL)), _tmp27_);
		_tmp29_ = NULL;
		_tmp28_ = NULL;
		vala_ccode_function_call_add_argument (sizeof_call, (ValaCCodeExpression*) (_tmp29_ = vala_ccode_constant_new (_tmp28_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE))));
		(_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL));
		_tmp28_ = (g_free (_tmp28_), NULL);
		_tmp30_ = NULL;
		_tmp31_ = NULL;
		copy_call = (_tmp31_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp30_ = vala_ccode_identifier_new ("memcpy"))), (_tmp30_ == NULL) ? NULL : (_tmp30_ = (vala_ccode_node_unref (_tmp30_), NULL)), _tmp31_);
		_tmp32_ = NULL;
		vala_ccode_function_call_add_argument (copy_call, (ValaCCodeExpression*) (_tmp32_ = vala_ccode_identifier_new ("dup")));
		(_tmp32_ == NULL) ? NULL : (_tmp32_ = (vala_ccode_node_unref (_tmp32_), NULL));
		_tmp33_ = NULL;
		vala_ccode_function_call_add_argument (copy_call, (ValaCCodeExpression*) (_tmp33_ = vala_ccode_identifier_new ("self")));
		(_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_ccode_node_unref (_tmp33_), NULL));
		vala_ccode_function_call_add_argument (copy_call, (ValaCCodeExpression*) sizeof_call);
		_tmp34_ = NULL;
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp34_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) copy_call)));
		(_tmp34_ == NULL) ? NULL : (_tmp34_ = (vala_ccode_node_unref (_tmp34_), NULL));
		(sizeof_call == NULL) ? NULL : (sizeof_call = (vala_ccode_node_unref (sizeof_call), NULL));
		(copy_call == NULL) ? NULL : (copy_call = (vala_ccode_node_unref (copy_call), NULL));
	}
	_tmp36_ = NULL;
	_tmp35_ = NULL;
	vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp36_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp35_ = vala_ccode_identifier_new ("dup")))));
	(_tmp36_ == NULL) ? NULL : (_tmp36_ = (vala_ccode_node_unref (_tmp36_), NULL));
	(_tmp35_ == NULL) ? NULL : (_tmp35_ = (vala_ccode_node_unref (_tmp35_), NULL));
	vala_ccode_function_set_block (function, cblock);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
	(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
	(creation_call == NULL) ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL));
}


static void vala_ccode_struct_module_add_struct_free_function (ValaCCodeStructModule* self, ValaStruct* st) {
	char* _tmp0_;
	ValaCCodeFunction* _tmp1_;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp4_;
	char* _tmp3_;
	char* _tmp2_;
	ValaCCodeBlock* cblock;
	ValaCCodeIdentifier* _tmp10_;
	ValaCCodeFunctionCall* _tmp11_;
	ValaCCodeFunctionCall* free_call;
	ValaCCodeIdentifier* _tmp12_;
	ValaCCodeExpressionStatement* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (st != NULL);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	function = (_tmp1_ = vala_ccode_function_new (_tmp0_ = vala_typesymbol_get_free_function ((ValaTypeSymbol*) st), "void"), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	if (vala_symbol_get_access ((ValaSymbol*) st) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	}
	_tmp4_ = NULL;
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp4_ = vala_ccode_formal_parameter_new ("self", _tmp3_ = g_strconcat (_tmp2_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE), "*", NULL)));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	_tmp3_ = (g_free (_tmp3_), NULL);
	_tmp2_ = (g_free (_tmp2_), NULL);
	cblock = vala_ccode_block_new ();
	if (vala_struct_is_disposable (st)) {
		ValaCCodeIdentifier* _tmp6_;
		char* _tmp5_;
		ValaCCodeFunctionCall* _tmp7_;
		ValaCCodeFunctionCall* destroy_call;
		ValaCCodeIdentifier* _tmp8_;
		ValaCCodeExpressionStatement* _tmp9_;
		_tmp6_ = NULL;
		_tmp5_ = NULL;
		_tmp7_ = NULL;
		destroy_call = (_tmp7_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp6_ = vala_ccode_identifier_new (_tmp5_ = vala_typesymbol_get_destroy_function ((ValaTypeSymbol*) st)))), (_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL)), _tmp5_ = (g_free (_tmp5_), NULL), _tmp7_);
		_tmp8_ = NULL;
		vala_ccode_function_call_add_argument (destroy_call, (ValaCCodeExpression*) (_tmp8_ = vala_ccode_identifier_new ("self")));
		(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
		_tmp9_ = NULL;
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp9_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) destroy_call)));
		(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
		(destroy_call == NULL) ? NULL : (destroy_call = (vala_ccode_node_unref (destroy_call), NULL));
	}
	_tmp10_ = NULL;
	_tmp11_ = NULL;
	free_call = (_tmp11_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp10_ = vala_ccode_identifier_new ("g_free"))), (_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL)), _tmp11_);
	_tmp12_ = NULL;
	vala_ccode_function_call_add_argument (free_call, (ValaCCodeExpression*) (_tmp12_ = vala_ccode_identifier_new ("self")));
	(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
	_tmp13_ = NULL;
	vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp13_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) free_call)));
	(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
	vala_ccode_function_set_block (function, cblock);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
	(free_call == NULL) ? NULL : (free_call = (vala_ccode_node_unref (free_call), NULL));
}


static void vala_ccode_struct_module_add_struct_copy_function (ValaCCodeStructModule* self, ValaStruct* st) {
	char* _tmp0_;
	ValaCCodeFunction* _tmp1_;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp5_;
	char* _tmp4_;
	char* _tmp3_;
	char* _tmp2_;
	ValaCCodeFormalParameter* _tmp8_;
	char* _tmp7_;
	char* _tmp6_;
	ValaCCodeBlock* cblock;
	ValaCCodeFragment* cfrag;
	g_return_if_fail (self != NULL);
	g_return_if_fail (st != NULL);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	function = (_tmp1_ = vala_ccode_function_new (_tmp0_ = vala_typesymbol_get_copy_function ((ValaTypeSymbol*) st), "void"), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	if (vala_symbol_get_access ((ValaSymbol*) st) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	}
	_tmp5_ = NULL;
	_tmp4_ = NULL;
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp5_ = vala_ccode_formal_parameter_new ("self", _tmp4_ = g_strconcat (_tmp3_ = g_strconcat ("const ", _tmp2_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE), NULL), "*", NULL)));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	_tmp4_ = (g_free (_tmp4_), NULL);
	_tmp3_ = (g_free (_tmp3_), NULL);
	_tmp2_ = (g_free (_tmp2_), NULL);
	_tmp8_ = NULL;
	_tmp7_ = NULL;
	_tmp6_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp8_ = vala_ccode_formal_parameter_new ("dest", _tmp7_ = g_strconcat (_tmp6_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE), "*", NULL)));
	(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
	_tmp7_ = (g_free (_tmp7_), NULL);
	_tmp6_ = (g_free (_tmp6_), NULL);
	cblock = vala_ccode_block_new ();
	cfrag = vala_ccode_fragment_new ();
	vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) cfrag);
	{
		GeeList* _tmp9_;
		GeeIterator* _tmp10_;
		GeeIterator* _f_it;
		_tmp9_ = NULL;
		_tmp10_ = NULL;
		_f_it = (_tmp10_ = gee_iterable_iterator ((GeeIterable*) (_tmp9_ = vala_struct_get_fields (st))), (_tmp9_ == NULL) ? NULL : (_tmp9_ = (gee_collection_object_unref (_tmp9_), NULL)), _tmp10_);
		while (TRUE) {
			ValaField* f;
			if (!gee_iterator_next (_f_it)) {
				break;
			}
			f = (ValaField*) gee_iterator_get (_f_it);
			if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
				ValaCCodeIdentifier* _tmp11_;
				ValaCCodeExpression* _tmp12_;
				ValaCCodeExpression* copy;
				ValaCCodeIdentifier* _tmp16_;
				ValaCCodeMemberAccess* _tmp17_;
				ValaCCodeMemberAccess* dest;
				ValaArrayType* _tmp19_;
				ValaDataType* _tmp18_;
				ValaArrayType* array_type;
				gboolean _tmp20_;
				_tmp11_ = NULL;
				_tmp12_ = NULL;
				copy = (_tmp12_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp11_ = vala_ccode_identifier_new ("self")), vala_symbol_get_name ((ValaSymbol*) f)), (_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL)), _tmp12_);
				if (vala_ccode_base_module_requires_copy ((ValaCCodeBaseModule*) self, vala_field_get_field_type (f))) {
					ValaMemberAccess* this_access;
					ValaDataType* _tmp13_;
					ValaCCodeIdentifier* _tmp14_;
					ValaMemberAccess* ma;
					ValaCCodeExpression* _tmp15_;
					this_access = vala_member_access_new_simple ("this", NULL);
					_tmp13_ = NULL;
					vala_expression_set_value_type ((ValaExpression*) this_access, _tmp13_ = vala_ccode_base_module_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) f))));
					(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_code_node_unref (_tmp13_), NULL));
					_tmp14_ = NULL;
					vala_code_node_set_ccodenode ((ValaCodeNode*) this_access, (ValaCCodeNode*) (_tmp14_ = vala_ccode_identifier_new ("(*self)")));
					(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
					ma = vala_member_access_new ((ValaExpression*) this_access, vala_symbol_get_name ((ValaSymbol*) f), NULL);
					vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) f);
					_tmp15_ = NULL;
					copy = (_tmp15_ = vala_ccode_base_module_get_ref_cexpression ((ValaCCodeBaseModule*) self, vala_field_get_field_type (f), copy, (ValaExpression*) ma, (ValaCodeNode*) f), (copy == NULL) ? NULL : (copy = (vala_ccode_node_unref (copy), NULL)), _tmp15_);
					(this_access == NULL) ? NULL : (this_access = (vala_code_node_unref (this_access), NULL));
					(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
				}
				_tmp16_ = NULL;
				_tmp17_ = NULL;
				dest = (_tmp17_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp16_ = vala_ccode_identifier_new ("dest")), vala_symbol_get_name ((ValaSymbol*) f)), (_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL)), _tmp17_);
				_tmp19_ = NULL;
				_tmp18_ = NULL;
				array_type = (_tmp19_ = (_tmp18_ = vala_field_get_field_type (f), VALA_IS_ARRAY_TYPE (_tmp18_) ? ((ValaArrayType*) _tmp18_) : NULL), (_tmp19_ == NULL) ? NULL : vala_code_node_ref (_tmp19_));
				_tmp20_ = FALSE;
				if (array_type != NULL) {
					_tmp20_ = vala_array_type_get_fixed_length (array_type);
				} else {
					_tmp20_ = FALSE;
				}
				if (_tmp20_) {
					ValaCCodeIdentifier* _tmp21_;
					ValaCCodeFunctionCall* _tmp22_;
					ValaCCodeFunctionCall* sizeof_call;
					ValaCCodeIdentifier* _tmp24_;
					char* _tmp23_;
					ValaCCodeConstant* _tmp26_;
					char* _tmp25_;
					ValaCCodeBinaryExpression* _tmp27_;
					ValaCCodeBinaryExpression* size;
					ValaCCodeIdentifier* _tmp28_;
					ValaCCodeFunctionCall* _tmp29_;
					ValaCCodeFunctionCall* array_copy_call;
					ValaCCodeExpressionStatement* _tmp30_;
					/* fixed-length (stack-allocated) arrays*/
					vala_ccode_declaration_space_add_include (((ValaCCodeBaseModule*) self)->source_declarations, "string.h", FALSE);
					_tmp21_ = NULL;
					_tmp22_ = NULL;
					sizeof_call = (_tmp22_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp21_ = vala_ccode_identifier_new ("sizeof"))), (_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL)), _tmp22_);
					_tmp24_ = NULL;
					_tmp23_ = NULL;
					vala_ccode_function_call_add_argument (sizeof_call, (ValaCCodeExpression*) (_tmp24_ = vala_ccode_identifier_new (_tmp23_ = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))));
					(_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL));
					_tmp23_ = (g_free (_tmp23_), NULL);
					_tmp26_ = NULL;
					_tmp25_ = NULL;
					_tmp27_ = NULL;
					size = (_tmp27_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) (_tmp26_ = vala_ccode_constant_new (_tmp25_ = g_strdup_printf ("%d", vala_array_type_get_length (array_type)))), (ValaCCodeExpression*) sizeof_call), (_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL)), _tmp25_ = (g_free (_tmp25_), NULL), _tmp27_);
					_tmp28_ = NULL;
					_tmp29_ = NULL;
					array_copy_call = (_tmp29_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp28_ = vala_ccode_identifier_new ("memcpy"))), (_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_ccode_node_unref (_tmp28_), NULL)), _tmp29_);
					vala_ccode_function_call_add_argument (array_copy_call, (ValaCCodeExpression*) dest);
					vala_ccode_function_call_add_argument (array_copy_call, copy);
					vala_ccode_function_call_add_argument (array_copy_call, (ValaCCodeExpression*) size);
					_tmp30_ = NULL;
					vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp30_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) array_copy_call)));
					(_tmp30_ == NULL) ? NULL : (_tmp30_ = (vala_ccode_node_unref (_tmp30_), NULL));
					(sizeof_call == NULL) ? NULL : (sizeof_call = (vala_ccode_node_unref (sizeof_call), NULL));
					(size == NULL) ? NULL : (size = (vala_ccode_node_unref (size), NULL));
					(array_copy_call == NULL) ? NULL : (array_copy_call = (vala_ccode_node_unref (array_copy_call), NULL));
				} else {
					ValaCCodeExpressionStatement* _tmp32_;
					ValaCCodeAssignment* _tmp31_;
					_tmp32_ = NULL;
					_tmp31_ = NULL;
					vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp32_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp31_ = vala_ccode_assignment_new ((ValaCCodeExpression*) dest, copy, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
					(_tmp32_ == NULL) ? NULL : (_tmp32_ = (vala_ccode_node_unref (_tmp32_), NULL));
					(_tmp31_ == NULL) ? NULL : (_tmp31_ = (vala_ccode_node_unref (_tmp31_), NULL));
					if (array_type != NULL) {
						{
							gint dim;
							dim = 1;
							{
								gboolean _tmp33_;
								_tmp33_ = TRUE;
								while (TRUE) {
									char* _tmp35_;
									ValaCCodeIdentifier* _tmp34_;
									ValaCCodeMemberAccess* _tmp36_;
									ValaCCodeMemberAccess* len_src;
									char* _tmp38_;
									ValaCCodeIdentifier* _tmp37_;
									ValaCCodeMemberAccess* _tmp39_;
									ValaCCodeMemberAccess* len_dest;
									ValaCCodeExpressionStatement* _tmp41_;
									ValaCCodeAssignment* _tmp40_;
									if (!_tmp33_) {
										dim++;
									}
									_tmp33_ = FALSE;
									if (!(dim <= vala_array_type_get_rank (array_type))) {
										break;
									}
									_tmp35_ = NULL;
									_tmp34_ = NULL;
									_tmp36_ = NULL;
									len_src = (_tmp36_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp34_ = vala_ccode_identifier_new ("self")), _tmp35_ = vala_ccode_module_get_array_length_cname ((ValaCCodeModule*) self, vala_symbol_get_name ((ValaSymbol*) f), dim)), _tmp35_ = (g_free (_tmp35_), NULL), (_tmp34_ == NULL) ? NULL : (_tmp34_ = (vala_ccode_node_unref (_tmp34_), NULL)), _tmp36_);
									_tmp38_ = NULL;
									_tmp37_ = NULL;
									_tmp39_ = NULL;
									len_dest = (_tmp39_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp37_ = vala_ccode_identifier_new ("dest")), _tmp38_ = vala_ccode_module_get_array_length_cname ((ValaCCodeModule*) self, vala_symbol_get_name ((ValaSymbol*) f), dim)), _tmp38_ = (g_free (_tmp38_), NULL), (_tmp37_ == NULL) ? NULL : (_tmp37_ = (vala_ccode_node_unref (_tmp37_), NULL)), _tmp39_);
									_tmp41_ = NULL;
									_tmp40_ = NULL;
									vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp41_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp40_ = vala_ccode_assignment_new ((ValaCCodeExpression*) len_dest, (ValaCCodeExpression*) len_src, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
									(_tmp41_ == NULL) ? NULL : (_tmp41_ = (vala_ccode_node_unref (_tmp41_), NULL));
									(_tmp40_ == NULL) ? NULL : (_tmp40_ = (vala_ccode_node_unref (_tmp40_), NULL));
									(len_src == NULL) ? NULL : (len_src = (vala_ccode_node_unref (len_src), NULL));
									(len_dest == NULL) ? NULL : (len_dest = (vala_ccode_node_unref (len_dest), NULL));
								}
							}
						}
					}
				}
				(copy == NULL) ? NULL : (copy = (vala_ccode_node_unref (copy), NULL));
				(dest == NULL) ? NULL : (dest = (vala_ccode_node_unref (dest), NULL));
				(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
			}
			(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
		}
		(_f_it == NULL) ? NULL : (_f_it = (gee_collection_object_unref (_f_it), NULL));
	}
	vala_ccode_base_module_append_temp_decl ((ValaCCodeBaseModule*) self, cfrag, (GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars);
	gee_collection_clear ((GeeCollection*) ((ValaCCodeBaseModule*) self)->temp_vars);
	vala_ccode_function_set_block (function, cblock);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
	(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
}


static void vala_ccode_struct_module_add_struct_destroy_function (ValaCCodeStructModule* self, ValaStruct* st) {
	char* _tmp0_;
	ValaCCodeFunction* _tmp1_;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp4_;
	char* _tmp3_;
	char* _tmp2_;
	ValaCCodeBlock* cblock;
	g_return_if_fail (self != NULL);
	g_return_if_fail (st != NULL);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	function = (_tmp1_ = vala_ccode_function_new (_tmp0_ = vala_typesymbol_get_destroy_function ((ValaTypeSymbol*) st), "void"), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	if (vala_symbol_get_access ((ValaSymbol*) st) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	}
	_tmp4_ = NULL;
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp4_ = vala_ccode_formal_parameter_new ("self", _tmp3_ = g_strconcat (_tmp2_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE), "*", NULL)));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	_tmp3_ = (g_free (_tmp3_), NULL);
	_tmp2_ = (g_free (_tmp2_), NULL);
	cblock = vala_ccode_block_new ();
	vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->instance_finalize_fragment);
	vala_ccode_function_set_block (function, cblock);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
}


static void vala_ccode_struct_module_class_init (ValaCCodeStructModuleClass * klass) {
	vala_ccode_struct_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_BASE_MODULE_CLASS (klass)->generate_struct_declaration = vala_ccode_struct_module_real_generate_struct_declaration;
	VALA_CCODE_MODULE_CLASS (klass)->visit_struct = vala_ccode_struct_module_real_visit_struct;
}


static void vala_ccode_struct_module_instance_init (ValaCCodeStructModule * self) {
}


GType vala_ccode_struct_module_get_type (void) {
	static GType vala_ccode_struct_module_type_id = 0;
	if (vala_ccode_struct_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeStructModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_struct_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeStructModule), 0, (GInstanceInitFunc) vala_ccode_struct_module_instance_init, NULL };
		vala_ccode_struct_module_type_id = g_type_register_static (VALA_TYPE_CCODE_BASE_MODULE, "ValaCCodeStructModule", &g_define_type_info, 0);
	}
	return vala_ccode_struct_module_type_id;
}




